       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04792.                                         
COB303 DATE-WRITTEN.  MAY 2014.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS USED TO UPDATE CONTRACT DETAILS FOR A CONTRACT *        
      * SENT FROM SALESFORCE.                                          *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/09/14    DMS      INITIAL VERSION.                         *        
P00846*  05/18/15    DMS      MULTIPLE THE CHARGE AMT BY THE QUANTITY. *        
A05207*  11/10/15    DMS      CHANGE TO USE CPD04822.                  *        
ACT278*  09/21/16   TP7R341   REMOVE UNWANTED COLUMNS FROM CONTRACT,   *        
A05460*        0    ACT278    CONTRACT DETAIL AND INFO TABLES.         *        
A05460*  12/12/16   SM93554   REMOVED THE ACCOUNT TABLE UPDATE SINCE   *        
      *             ACT380    CONTRACT PROCESS WILL TAKE CARE OF IT.   *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04792'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04792 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
           COPY CWS00303.                                                       
           COPY CJF00101.                                                       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * AT - CSS_ACCOUNT                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      * CT - CSS_CONTRACT                                                       
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      * EA - CSS_CNT_DETAIL                                                     
           EXEC SQL                                                             
              INCLUDE TBCNTDET                                                  
           END-EXEC.                                                            
                                                                        
      * K6 - CSS_CONTRACT_INFO                                                  
           EXEC SQL                                                             
              INCLUDE TBCNTINF                                                  
           END-EXEC.                                                            
                                                                        
      * PR - CSS_PREMISE                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      * CU - CSS_CUSTOMER                                                       
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      * CD - CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                             
             INCLUDE TBCDCNTL                                                   
           END-EXEC.                                                            
                                                                        
      * CJ - CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                             
             INCLUDE TBCDJRNL                                                   
           END-EXEC.                                                            
                                                                        
      * PF - CSS_USER_PROFILE                                                   
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      * GO - CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      * AR - CSS_AR_TRANS_HIST                                                  
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
                                                                        
      * AU - CSS_AR_TRN_HST_DET                                                 
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
                                                                        
      * AR - CSS_AR_CNTL                                                        
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
                                                                        
      * BC - CSS_BCH_JRNL_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      * BJ - CSS_BATCH_JRNL                                                     
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * MJ - CSS_MISC_JRNL                                                      
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * AL - CSS_AR_LOCKOUT                                                     
           EXEC SQL                                                     05060000
              INCLUDE TBARLOCK                                          05070000
           END-EXEC.                                                    05080000
                                                                        
      * MH - CSS_MNT_TRANS_HIST                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      * MI - CSS_MT_TRN_HST_DET                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      * C8 - CSS_DELINQUENCY                                                    
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      * U1 - CSS_SPCL_BILL_MSG                                                  
           EXEC SQL                                                     00880000
              INCLUDE TBSBLMSG                                                  
           END-EXEC.                                                            
                                                                        
      * WORKING STORAGE FOR PAYMENT APPLICATION ROUTINE                         
           EXEC SQL                                                             
             INCLUDE CWS00017                                                   
           END-EXEC.                                                            
                                                                        
      * LAYOUT FOR CODES_DATA_PRESENT ON CSS_ACCOUNT                            
           EXEC SQL                                                             
             INCLUDE CWS00056                                                   
           END-EXEC.                                                            
                                                                        
      * COMMON JOURNAL AREA                                                     
           EXEC SQL                                                             
             INCLUDE CWS0013B                                                   
           END-EXEC.                                                            
                                                                        
      * GENERAL LEDGER                                                          
           COPY CWS00061.                                                       
      * CASH JOURNAL DETAIL                                                     
           COPY CJF00105.                                                       
                                                                        
A05207* WORK AREAS CONTRACT ROUTINE MCSCB822                                    
A05207     COPY CWS04822.                                                       
                                                                        
      ******************************************************************00660000
      *    WORK AREAS                                                  *00670000
      ******************************************************************00680000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04792'.     
           05  MCSCB822                 PIC X(08) VALUE 'MCSCB822'.     
           05  WS-ROW-COUNT             PIC 9(5) VALUE 0.               
           05  WS-METER-COUNT           PIC S9(9) COMP VALUE +0.        
           05  WS-IC-COUNT              PIC S9(9) COMP VALUE +0.        
           05  WS-FULL-NAME             PIC X(70) VALUE SPACES.         
           05  WS-GTT-NAME              PIC X(19) VALUE SPACES.         
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-APPL-RETURN-CODE      PIC S9(04) COMP VALUE 0.        
           05  WS-FAILED                PIC X(01)  VALUE 'F'.           
           05  WS-CURRENT-DATE          PIC X(10) VALUE  SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE  SPACES.        
           05  WS-AR-AGE                PIC X(01)      VALUE  SPACES.   
           05  WS-CNT-DET-COUNT         PIC S9(9) COMP VALUE 0.         
           05  WS-AMT-POSTED            PIC S9(9)V9(2) VALUE 0.         
           05  WS-ACCUM-DET-MO-PYMT     PIC S9(9)V9(5) VALUE 0.         
           05  WS-TOT-DET-FIN-AMT       PIC S9(9)V9(5) COMP-3 VALUE 0.  
           05  WS-TOT-DET-MO-PYMT       PIC S9(9)V9(5) COMP-3 VALUE 0.  
           05  WS-PANEL-NAME            PIC X(09)      VALUE  SPACES.   
           05  WS-TOTAL-CIA-NEG         PIC S9(11)V9(2) COMP-3          
                                                        VALUE 0.        
           05  WS-TOTAL-CIA-AMT         PIC S9(11)V9(2) VALUE 0.        
           05  WS-DOWNPYMT-FOUND        PIC X(01)      VALUE  SPACES.   
           05  WS-DEBIT-GL              PIC S9(03)V9999 COMP-3 VALUE 0. 
           05  WS-CREDIT-GL             PIC S9(03)V9999 COMP-3 VALUE 0. 
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-AR-AMT-ORIG-ENTERED   PIC S9(9)V9(2) USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-ORIG-AMT              PIC S9(11)V9(2) COMP-3 VALUE 0. 
           05  WS-TOT-INT               PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-NO-CNT-MO             PIC 999         VALUE ZERO.     
           05  WS-CUR-REV-MTH-X.                                        
               10 WS-REV-MTH-CCYY       PIC X(04).                      
               10 WS-REV-MTH-MM         PIC X(02).                      
           05  WS-CUR-REV-MTH-NUM  REDEFINES WS-CUR-REV-MTH-X           
                                        PIC 9(06).                      
COB305     05 WS-CUR-REV-MTH-DEC        PIC S9(6)V USAGE COMP-3 VALUE 0.        
A05207     05  WS-CNT-ITEM-ID           PIC S9(9) USAGE COMP.           
           05  WS-NULL-IND              PIC S9(4) COMP VALUE  +0.       
           05  WS-NULL-IND-1            PIC S9(4) COMP VALUE  +0.       
           05  WS-NULL-IND-2            PIC S9(4) COMP VALUE  +0.       
           05  WS-NULL-IND-3            PIC S9(4) COMP VALUE  +0.       
           05  WS-NULL-IND-4            PIC S9(4) COMP VALUE  +0.       
           05  WS-NULL-IND-5            PIC S9(4) COMP VALUE  +0.       
           05  WS-NULL-IND-6            PIC S9(4) COMP VALUE  +0.       
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-E                     PIC X(01) VALUE 'E'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
           05  WS-01                    PIC X(2)  VALUE '01'.           
           05  WS-998                   PIC  X(03) VALUE '998'.         
           05  WS-COMMENT.                                              
               10 WS-CNT-COMMENT        PIC X(33) VALUE                 
               'CONTRACT CREATED BY CRM SYSTEM = '.                     
               10 WS-CUST-CNT-ID-COMM   PIC X(10) VALUE SPACES.         
           05  WS-TH-COMMENT.                                           
               10 FILLER                PIC X(11) VALUE 'AGREEMENT: '.  
               10 WS-TH-CUST-CNT-ID     PIC X(10).                      
               10 FILLER                PIC X(15) VALUE                 
                                        ', SUMM CNT ID: '.              
               10 WS-TH-SUMM-CNT-ID-NUM PIC 9(07).                      
               10 WS-TH-SUMM-CNT-ID REDEFINES                           
                  WS-TH-SUMM-CNT-ID-NUM PIC S9(09) USAGE COMP.          
               10 FILLER                PIC X(13) VALUE                 
                                        ', SALE TYPE: '.                
               10 WS-TH-SALE-TYPE-DESC  PIC X(20).                      
           05  WS-MANUAL-PULL           PIC X(23) VALUE                 
                                       'PULL BILL TO RITA DAVIS'.       
       01  CSRERLOG-P.                                                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-INSERT-ROW-SW         PIC X(01) VALUE 'A'.            
               88 APPLIANCE-CONTRACT              VALUE 'A'.            
               88 SERVICE-CONTRACT                VALUE 'S'.            
           05  WS-JRNL-SWITCH           PIC X(01) VALUE 'O'.            
               88 DOWNPYMT                        VALUE 'D'.            
               88 CIA                             VALUE 'C'.            
               88 ALL-OTHERS                      VALUE 'O'.            
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-APPL-RETURN-CODE      PIC S9(04) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR BUSINESS RULES.                         *        
      ******************************************************************        
           05  GTT-RETURN-FIELDS.                                       
               10  S-RETURN-CODE          PIC S9(9) COMP VALUE ZERO.    
               10  S-APPL-RETURN-CODE     PIC S9(04) COMP VALUE 0.      
               10  S-BUS-RULE-ID          PIC X(10) VALUE SPACES.       
               10  S-BUS-RULE-RESULT-CD   PIC X(10)  VALUE SPACES.      
               10  S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
      *    05  CTR-ROWS-RS1             PIC S9(9) COMP VALUE 0.                 
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO-TEMP     PIC  X(13) VALUE SPACES.        
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO-TEMP  
                                        PIC 9(13).                      
           05  WS-ACCOUNT-NO            PIC 9(13).                      
           05  WS-SUMMARY-CNT-ID        PIC S9(09) COMP.                
           05  WS-USER-ID               PIC X(07).                      
           05  WS-CNT-DATE              PIC X(10).                      
           05  WS-CODE-BILL-TYPE        PIC X(01).                      
           05  WS-CUST-CNT-ID           PIC X(10).                      
           05  WS-APPL-ACCT-CD          PIC X(03).                      
COB305     05 WS-INTRST-RATE        PIC S9(3)V9(4) COMP-3 VALUE 0.          
           05  WS-REBATE-CD             PIC X(01).                      
COB305     05 WS-REBATE-AMT        PIC S9(7)V9(2) COMP-3 VALUE 0.          
COB305     05 WS-AMT-MO-PYMT        PIC S9(9)V9(2) COMP-3 VALUE 0.          
COB305     05 WS-AMT-DOWN-PYMT        PIC S9(9)V9(2) COMP-3 VALUE 0.          
COB305     05 WS-AMT-TAX-STATE        PIC S9(7)V9(2) COMP-3 VALUE 0.          
COB305     05 WS-AMT-TAX-OTHER        PIC S9(7)V9(2) COMP-3 VALUE 0.          
           05  WS-NUM-SCHED-PYMTS       PIC S9(4) COMP.                 
           05  WS-LIEN-CD               PIC X(01).                      
           05  WS-ITEM-QT               PIC S9(04) COMP.                
           05  WS-ITEM-ID               PIC X(11).                      
           05  WS-FUEL-REPL             PIC X(02).                      
COB305     05 WS-CHARGE-AMT        PIC S9(09)V9(2) COMP-3 VALUE 0.         
           05  WS-SERV-MONTHS           PIC S9(04) COMP.                
COB305     05 WS-INSP-FEE        PIC S9(09)V9(2) COMP-3 VALUE 0.         
COB305     05 WS-DISP-FEE        PIC S9(09)V9(2) COMP-3 VALUE 0.         
COB305     05 WS-FINANCED-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.         
           05  WS-REL-CNT-ITEM-ID       PIC S9(07) COMP.                
COB305     05 WS-FILING-FEE        PIC S9(09)V9(2) COMP-3 VALUE 0.         
           05  WS-SALE-TYPE-CD          PIC X(03).                      
                                                                        
      *****************************************************************         
      * CURSOR DECLARATIONS                                           *         
      *****************************************************************         
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  PARM-ACCOUNT-NO            PIC X(13).                        
       01  PARM-SUMMARY-CNT-ID        PIC S9(09) COMP.                  
       01  PARM-USER-ID               PIC X(07).                        
       01  PARM-CNT-DATE              PIC X(10).                        
       01  PARM-CODE-BILL-TYPE        PIC X(01).                        
       01  PARM-CUST-CNT-ID           PIC X(10).                        
       01  PARM-APPL-ACCT-CD          PIC X(03).                        
COB305 01 PARM-INTRST-RATE        PIC S9(3)V9(4) COMP-3 VALUE 0.            
       01  PARM-REBATE-CD             PIC X(01).                        
COB305 01 PARM-REBATE-AMT        PIC S9(7)V9(2) COMP-3 VALUE 0.            
COB305 01 PARM-AMT-MO-PYMT        PIC S9(9)V9(2) COMP-3 VALUE 0.            
COB305 01 PARM-AMT-DOWN-PYMT        PIC S9(9)V9(2) COMP-3 VALUE 0.            
COB305 01 PARM-AMT-TAX-STATE        PIC S9(7)V9(2) COMP-3 VALUE 0.            
COB305 01 PARM-AMT-TAX-OTHER        PIC S9(7)V9(2) COMP-3 VALUE 0.            
       01  PARM-NO-SCHED-PYMTS        PIC S9(4) COMP.                   
       01  PARM-LIEN-CD               PIC X(01).                        
       01  PARM-ITEM-QT               PIC S9(4) COMP.                   
       01  PARM-ITEM-ID               PIC X(11).                        
       01  PARM-FUEL-REPL             PIC X(02).                        
COB305 01 PARM-CHARGE-AMT        PIC S9(09)V9(2) COMP-3 VALUE 0.           
       01  PARM-SERV-MONTHS           PIC S9(04) COMP.                  
COB305 01 PARM-INSP-FEE        PIC S9(09)V9(2) COMP-3 VALUE 0.           
COB305 01 PARM-DISP-FEE        PIC S9(09)V9(2) COMP-3 VALUE 0.           
COB305 01 PARM-FINANCED-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.           
       01  PARM-REL-CNT-ITEM-ID       PIC S9(07) COMP.                  
COB305 01 PARM-FILING-FEE        PIC S9(09)V9(2) COMP-3 VALUE 0.           
       01  PARM-SALE-TYPE-CD          PIC X(03).                        
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                 PARM-SUMMARY-CNT-ID                    
                                 PARM-USER-ID                           
                                 PARM-CNT-DATE                          
                                 PARM-CODE-BILL-TYPE                    
                                 PARM-CUST-CNT-ID                       
                                 PARM-APPL-ACCT-CD                      
                                 PARM-INTRST-RATE                       
                                 PARM-REBATE-CD                         
                                 PARM-REBATE-AMT                        
                                 PARM-AMT-MO-PYMT                       
                                 PARM-AMT-DOWN-PYMT                     
                                 PARM-AMT-TAX-STATE                     
                                 PARM-AMT-TAX-OTHER                     
                                 PARM-NO-SCHED-PYMTS                    
                                 PARM-LIEN-CD                           
                                 PARM-ITEM-QT                           
                                 PARM-ITEM-ID                           
                                 PARM-FUEL-REPL                         
                                 PARM-CHARGE-AMT                        
                                 PARM-SERV-MONTHS                       
                                 PARM-INSP-FEE                          
                                 PARM-DISP-FEE                          
                                 PARM-FINANCED-AMT                      
                                 PARM-REL-CNT-ITEM-ID                   
                                 PARM-FILING-FEE                        
                                 PARM-SALE-TYPE-CD.                     
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************02500000
      * 0000-MAINLINE                                                  *02510000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02520000
      ******************************************************************02530000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02640000
      * 0100-INITIALIZE                                                *02650000
      *                                                                *02660000
      *                                                                *02670000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02680000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02690000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02700000
      *                                                                *02710000
      ******************************************************************02720000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE 'N'                       TO WS-GTT01-DECLARED.         
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1   THRU 0100A-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  0100A-DECLARE-GTT-R1 - BUSINESS RULES                         *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04792_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04792_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04792_R1
              (                                                      
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 MOVE 'Y'                   TO WS-GTT01-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE WS-GTT-NAME          TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                  FROM #CSR04792_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*           FROM SESSION.CSR04792_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO          TO PARM-ACCOUNT-NO-TEMP.       
           MOVE PARM-ACCOUNT-NO-RED      TO WS-ACCOUNT-NO.              
           MOVE PARM-SUMMARY-CNT-ID      TO WS-SUMMARY-CNT-ID.          
           MOVE PARM-USER-ID             TO WS-USER-ID.                 
           MOVE PARM-CNT-DATE            TO WS-CNT-DATE.                
           MOVE PARM-CODE-BILL-TYPE      TO WS-CODE-BILL-TYPE.          
           MOVE PARM-CUST-CNT-ID         TO WS-CUST-CNT-ID.             
           MOVE PARM-APPL-ACCT-CD        TO WS-APPL-ACCT-CD.            
           MOVE PARM-INTRST-RATE         TO WS-INTRST-RATE.             
           MOVE PARM-REBATE-CD           TO WS-REBATE-CD.               
           MOVE PARM-REBATE-AMT          TO WS-REBATE-AMT.              
           MOVE PARM-AMT-MO-PYMT         TO WS-AMT-MO-PYMT.             
           MOVE PARM-AMT-DOWN-PYMT       TO WS-AMT-DOWN-PYMT.           
           MOVE PARM-AMT-TAX-STATE       TO WS-AMT-TAX-STATE.           
           MOVE PARM-AMT-TAX-OTHER       TO WS-AMT-TAX-OTHER.           
           MOVE PARM-NO-SCHED-PYMTS      TO WS-NUM-SCHED-PYMTS.         
           MOVE PARM-LIEN-CD             TO WS-LIEN-CD.                 
           MOVE PARM-ITEM-QT             TO WS-ITEM-QT.                 
           MOVE PARM-ITEM-ID             TO WS-ITEM-ID.                 
           MOVE PARM-FUEL-REPL           TO WS-FUEL-REPL.               
           MOVE PARM-CHARGE-AMT          TO WS-CHARGE-AMT.              
           MOVE PARM-SERV-MONTHS         TO WS-SERV-MONTHS.             
           MOVE PARM-INSP-FEE            TO WS-INSP-FEE.                
           MOVE PARM-DISP-FEE            TO WS-DISP-FEE.                
           MOVE PARM-REL-CNT-ITEM-ID     TO WS-REL-CNT-ITEM-ID.         
           MOVE PARM-FINANCED-AMT        TO WS-FINANCED-AMT.            
           MOVE PARM-FILING-FEE          TO WS-FILING-FEE.              
           MOVE PARM-SALE-TYPE-CD        TO WS-SALE-TYPE-CD.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03780000
      * 2000-PROCESS-OUTPUT.                                           *03790000
      *                                                                *03800000
      *     1. DESCRIBE RESULT SET                                     *03810000
      *     2. UPDATE DB2 DATA                                         *03820000
      *     3. BUILD RESULT SET                                        *03830000
      *     4. SEND RESULT SET                                         *03840000
      *                                                                *03850000
      ******************************************************************03860000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 2100-PROCESS-CONTRACT THRU 2100-EXIT.                
           MOVE ZERO TO RS-RETURN-CODE.                                 
           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE  RS-RETURN-CODE       TO S-RETURN-CODE.                 
           MOVE  RS-APPL-RETURN-CODE  TO S-APPL-RETURN-CODE.            
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************06600000
      * 2100-PROCESS-CONTRACT                                          *06610000
      ******************************************************************06620000
       2100-PROCESS-CONTRACT.                                           
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-APPL-RETURN-CODE                          
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              ADD +1                        TO   CTR-ROWS               
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           MOVE WS-ACCOUNT-NO TO AT-ACCOUNT-NO.                         
           PERFORM 7050-SELECT-CURRENT-DATE THRU 7050-EXIT.             
           PERFORM 7200-SELECT-ACCOUNT-INFO  THRU 7200-EXIT             
           PERFORM 7450-SELECT-PREMISE       THRU 7450-EXIT             
           PERFORM 7460-SELECT-CUSTOMER      THRU 7460-EXIT             
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT         
                                                                        
           MOVE WS-APPL-ACCT-CD TO K6-APPL-ACCT-CD.                     
           PERFORM 7250-SELECT-CONTRACT-INFO THRU 7250-EXIT.            
A05207     SET APPLIANCE-CONTRACT TO TRUE.                              
A05207     PERFORM 2200-WRITE-APPLIANCE-CNT THRU 2200-EXIT.             
                                                                        
ACT380*    MOVE WS-CODES-DATA-PRESENT     TO AT-CODES-DATA-PRESENT.             
ACT380*    PERFORM 7650-UPDATE-ACCOUNT    THRU 7650-EXIT.                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    3200-WRITE-APPLIANCE-CNT.                                   *        
      *       WRITE THE APPLIANCE CONTRACT TO CIS CONTRACT TABLES      *        
      ******************************************************************        
       2200-WRITE-APPLIANCE-CNT.                                        
                                                                        
           INITIALIZE WS-CONTRACT-HEADER-PARMS                          
                      WS-CONTRACT-DETAIL-PARMS                          
                      WS-CONTRACT-RETURN-INFO.                          
           PERFORM 2400-MOVE-CNT-VALUES      THRU 2400-EXIT.            
                                                                        
           PERFORM 2450-MOVE-CNT-DET-VALUES  THRU 2450-EXIT.            
A05207     PERFORM 5600-CREATE-CIS-CONTRACT  THRU 5600-EXIT.            
                                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2400-MOVE-CNT-VALUES.                                       *        
      *       MOVE CONTRACT VALUES FOR INSERT                          *        
      ******************************************************************        
       2400-MOVE-CNT-VALUES.                                            
                                                                        
A05207     MOVE AT-ACCOUNT-NO          TO WS-4822-ACCOUNT-NO.           
           PERFORM 7150-SELECT-MAX-CNT-ID  THRU 7150-EXIT.              
A05207     MOVE WS-CNT-ITEM-ID         TO WS-4822-CNT-ITEM-ID.          
A05207     MOVE WS-CNT-DATE            TO WS-4822-DATE-CONTRACT.        
A05207     MOVE WS-CURRENT-DATE        TO WS-4822-DATE-PYMT-START.      
           IF WS-INTRST-RATE = 0                                        
A05207        MOVE WS-A                TO WS-4822-CODE-INTRST-METH      
           ELSE                                                         
A05207        MOVE WS-B                TO WS-4822-CODE-INTRST-METH      
           END-IF.                                                      
A05207     MOVE K6-CODE-CONTRACT-TYPE  TO WS-4822-CODE-CONTRACT-TYPE.   
           IF K6-CODE-CONTRACT-TYPE = 'O'                               
A05207       MOVE WS-E                 TO WS-4822-CNT-STATUS-CD         
           ELSE                                                         
A05207       MOVE WS-B                 TO WS-4822-CNT-STATUS-CD         
           END-IF.                                                      
A05207     MOVE WS-USER-ID             TO WS-4822-USER-ID.              
A05207     MOVE PR-REV-DISTRICT-CD     TO WS-4822-REV-DISTRICT-CD.      
A05207     IF WS-REBATE-CD = 'B'                                        
A05207        MOVE 'A'                 TO WS-4822-CODE-BILL-TYPE        
A05207     ELSE                                                         
A05207        MOVE WS-CODE-BILL-TYPE   TO WS-4822-CODE-BILL-TYPE        
A05207     END-IF.                                                      
           MOVE WS-SUMMARY-CNT-ID      TO CT-SUMM-CNT-ID.               
           MOVE WS-CUST-CNT-ID         TO WS-CUST-CNT-ID-COMM.          
A05207     MOVE WS-COMMENT             TO WS-4822-CNT-COMMENTS-TXT.     
A05207     MOVE WS-REBATE-CD           TO WS-4822-REBATE-CD.            
A05207     MOVE K6-GL-ACCT-NO-ERN-INT  TO WS-4822-GL-ACCT-NO-ERN-INT.   
A05207     MOVE K6-GL-ACCT-NO-DEF-INT  TO WS-4822-GL-ACCT-NO-DEF-INT.   
A05207     MOVE WS-REBATE-AMT          TO WS-4822-REBATE-AMOUNT.        
A05207     MOVE WS-INTRST-RATE         TO WS-4822-INTRST-RATE.          
A05207     MOVE ZERO                   TO WS-4822-AMT-TAX-CITY.         
                                                                        
A05207     MOVE SPACES                 TO WS-4822-STATUS-CHANGE-DT.     
                                                                        
P00846     COMPUTE WS-CHARGE-AMT = WS-CHARGE-AMT * WS-ITEM-QT.          
           EVALUATE TRUE                                                
              WHEN APPLIANCE-CONTRACT                                   
               IF WS-NUM-SCHED-PYMTS > 1                                
                 IF WS-INTRST-RATE = 0                                  
                   COMPUTE WS-ORIG-AMT = WS-INSP-FEE                    
                                       + WS-CHARGE-AMT                  
                                       + WS-DISP-FEE                    
                                       + WS-AMT-TAX-OTHER               
                                       + WS-AMT-TAX-STATE               
                                       + WS-FILING-FEE                  
                 ELSE                                                   
                   COMPUTE WS-ORIG-AMT = (WS-NUM-SCHED-PYMTS *          
                                         WS-AMT-MO-PYMT)                
                                        + WS-AMT-DOWN-PYMT              
                 END-IF                                                 
A05207           MOVE WS-ORIG-AMT         TO WS-4822-AMT-ORIG-ENTERED   
                 COMPUTE WS-TOT-INT = WS-ORIG-AMT                       
                                     - WS-INSP-FEE                      
                                     - WS-CHARGE-AMT                    
                                     - WS-DISP-FEE                      
                                     - WS-AMT-TAX-OTHER                 
                                     - WS-AMT-TAX-STATE                 
                                     - WS-FILING-FEE                    
                                                                        
A05207           MOVE WS-TOT-INT          TO WS-4822-ADD-ON-INTRST      
A05207                                       WS-4822-DEFERRED-INTEREST  
A05207           MOVE WS-AMT-MO-PYMT      TO WS-4822-AMT-MO-PYMT        
               ELSE                                                     
                 COMPUTE WS-ORIG-AMT = WS-INSP-FEE                      
                                     + WS-CHARGE-AMT                    
                                     + WS-DISP-FEE                      
                                     + WS-AMT-TAX-OTHER                 
                                     + WS-AMT-TAX-STATE                 
                                     + WS-FILING-FEE                    
                 END-COMPUTE                                            
A05207           MOVE WS-ORIG-AMT         TO WS-4822-AMT-ORIG-ENTERED   
A05207           MOVE 0                   TO WS-4822-ADD-ON-INTRST      
A05207                                       WS-4822-DEFERRED-INTEREST  
A05207           COMPUTE WS-4822-AMT-MO-PYMT = WS-ORIG-AMT              
                                        - WS-AMT-DOWN-PYMT              
                 END-COMPUTE                                            
               END-IF                                                   
A05207           MOVE WS-AMT-DOWN-PYMT    TO WS-4822-AMT-DOWN-PYMT      
A05207           MOVE WS-AMT-TAX-STATE    TO WS-4822-AMT-TAX-STATE      
A05207           MOVE WS-AMT-TAX-OTHER    TO WS-4822-AMT-TAX-OTHER      
A05207           MOVE WS-NUM-SCHED-PYMTS  TO WS-4822-NO-SCHED-PYMTS     
A05207           MOVE K6-CNT-NAME-CD      TO WS-4822-CNT-NAME-CD        
A05207           MOVE WS-LIEN-CD          TO WS-4822-LIEN-CD            
              WHEN SERVICE-CONTRACT                                     
A05207           CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
           IF WS-REBATE-CD = 'D' OR 'B'                                 
A05207        COMPUTE WS-4822-AMT-ORIG-ENTERED =                        
A05207                   WS-4822-REBATE-AMOUNT                          
A05207*                  WS-4822-REBATE-AMOUNT * -1                             
A05207        MOVE ZEROES                   TO WS-4822-REBATE-AMOUNT    
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2450-MOVE-CNT-DET-VALUES.                                   *        
      *       MOVE CONTRACT DETAIL VALUES FOR INSERT                   *        
      ******************************************************************        
       2450-MOVE-CNT-DET-VALUES.                                        
                                                                        
           INITIALIZE DCLCSS-CNT-DETAIL.                                
           EVALUATE TRUE                                                
              WHEN APPLIANCE-CONTRACT                                   
A05207           MOVE WS-DISP-FEE        TO WS-4822-DTL-DISP-FEE        
A05207           MOVE WS-INSP-FEE        TO WS-4822-DTL-INSP-FEE        
A05207           MOVE WS-CHARGE-AMT      TO WS-4822-DTL-CHRG-AMT        
A05207           MOVE WS-FILING-FEE      TO WS-4822-DTL-FILING-FEE      
              WHEN SERVICE-CONTRACT                                     
A05207           CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
           IF WS-REBATE-CD = 'D'                                        
A05207        MOVE WS-REBATE-AMT                TO WS-4822-DTL-CHRG-AMT 
           END-IF.                                                      
                                                                        
A05207     MOVE WS-ACCOUNT-NO          TO WS-4822-ACCOUNT-NO.           
           MOVE CT-CNT-ITEM-ID         TO EA-CNT-ITEM-ID.               
A05207     MOVE K6-CHARGE-TYPE-CD      TO WS-4822-DTL-CHRG-TYPE.        
A05207     MOVE K6-COST-CENTER         TO WS-4822-COST-CENTER.          
A05207     MOVE K6-GL-ACCT-NO          TO WS-4822-DTL-GL-NO.            
A05207     MOVE K6-WRT-OFF-GL-ACCT-NO  TO WS-4822-DTL-WRT-OFF-GL-NO.    
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2650-UPD-INS-CNT-PPTY                                       *        
      *       UPDATE/INSERT ACCOUNTS RECEIVABLE INFO FOR ACCOUNT       *        
      ******************************************************************        
       2650-UPD-INS-CNT-PPTY.                                           
                                                                        
           MOVE CT-ACCOUNT-NO               TO   AC-ACCOUNT-NO.         
           MOVE CT-PYMT-PRIORITY-LVL        TO   AC-PYMT-PRIORITY-LVL.  
           MOVE 0                           TO   AC-ITEM-ID.            
                                                                        
           PERFORM 7500-SELECT-AR-CNTL                                  
              THRU 7500-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD CT-AMT-DOWN-PYMT           TO   AC-AMT-AR-DAY-00     
               PERFORM 7600-UPD-ARCNTL-ZERO-DAY-ONLY                    
                  THRU 7600-EXIT                                        
           ELSE                                                         
               MOVE CT-AMT-DOWN-PYMT          TO   AC-AMT-AR-DAY-00     
               MOVE 0                         TO   AC-AMT-AR-DAY-30     
               MOVE 0                         TO   AC-AMT-AR-DAY-60     
               MOVE 0                         TO   AC-AMT-AR-DAY-90     
               MOVE 0                         TO   AC-AMT-AR-DAY-30     
               MOVE 0                         TO   AC-AMT-TRAN-BALANCE  
               MOVE 0                         TO   AC-AMT-UNUSED-CR     
               MOVE 0                         TO   AC-TOT-SUMM-UNBILLED 
               PERFORM 7550-INSERT-AR-CNTL                              
                  THRU 7550-EXIT                                        
           END-IF.                                                      
           MOVE CT-CNT-ITEM-ID            TO   AC-ITEM-ID.              
           MOVE CT-AMT-DOWN-PYMT          TO   AC-AMT-AR-DAY-00.        
           MOVE 0                         TO   AC-AMT-AR-DAY-30.        
           MOVE 0                         TO   AC-AMT-AR-DAY-60.        
           MOVE 0                         TO   AC-AMT-AR-DAY-90.        
           MOVE 0                         TO   AC-AMT-AR-DAY-30.        
           MOVE CT-AMT-ORIG-ENTERED       TO   AC-AMT-TRAN-BALANCE.     
           MOVE 0                         TO   AC-AMT-UNUSED-CR.        
           MOVE 0                         TO   AC-TOT-SUMM-UNBILLED.    
           PERFORM 7550-INSERT-AR-CNTL                                  
              THRU 7550-EXIT.                                           
           ADD CT-AMT-DOWN-PYMT           TO AT-TOTAL-AR-BALANCE.       
           MOVE 'A'                       TO WS-CODE-CONTRACT.          
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2660-PROCESS-CIA                                            *        
      *       PROCESS CIA                                              *        
      ******************************************************************        
       2660-PROCESS-CIA.                                                
                                                                        
A05207     MOVE WS-4822-ACCOUNT-NO          TO   AC-ACCOUNT-NO.         
           MOVE 70                          TO   AC-PYMT-PRIORITY-LVL.  
           MOVE 0                           TO   AC-ITEM-ID.            
                                                                        
           PERFORM 7500-SELECT-AR-CNTL THRU 7500-EXIT.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD  WS-TOTAL-CIA-NEG        TO AC-AMT-UNUSED-CR          
              PERFORM 7605-UPDATE-AR-CNTL  THRU 7605-EXIT               
                                                                        
           ELSE                                                         
              MOVE 0                         TO   AC-AMT-AR-DAY-00      
              MOVE 0                         TO   AC-AMT-AR-DAY-30      
              MOVE 0                         TO   AC-AMT-AR-DAY-60      
              MOVE 0                         TO   AC-AMT-AR-DAY-90      
              MOVE 0                         TO   AC-AMT-AR-DAY-30      
              MOVE 0                         TO   AC-AMT-TRAN-BALANCE   
              MOVE WS-TOTAL-CIA-NEG          TO   AC-AMT-UNUSED-CR      
              MOVE 0                         TO   AC-TOT-SUMM-UNBILLED  
              PERFORM 7550-INSERT-AR-CNTL    THRU 7550-EXIT             
           END-IF.                                                      
                                                                        
A05207     MOVE WS-4822-ACCOUNT-NO          TO   AC-ACCOUNT-NO.         
           MOVE 70                          TO   AC-PYMT-PRIORITY-LVL.  
           MOVE 1                           TO   AC-ITEM-ID.            
                                                                        
           PERFORM 7500-SELECT-AR-CNTL THRU 7500-EXIT.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD  WS-TOTAL-CIA-NEG        TO AC-AMT-UNUSED-CR          
              ADD  WS-TOTAL-CIA-NEG        TO AC-AMT-TRAN-BALANCE       
              PERFORM 7605-UPDATE-AR-CNTL  THRU 7605-EXIT               
                                                                        
           ELSE                                                         
              MOVE 0                         TO   AC-AMT-AR-DAY-00      
              MOVE 0                         TO   AC-AMT-AR-DAY-30      
              MOVE 0                         TO   AC-AMT-AR-DAY-60      
              MOVE 0                         TO   AC-AMT-AR-DAY-90      
              MOVE 0                         TO   AC-AMT-AR-DAY-30      
              MOVE WS-TOTAL-CIA-NEG          TO   AC-AMT-TRAN-BALANCE   
              MOVE WS-TOTAL-CIA-NEG          TO   AC-AMT-UNUSED-CR      
              MOVE 0                         TO   AC-TOT-SUMM-UNBILLED  
              PERFORM 7550-INSERT-AR-CNTL    THRU 7550-EXIT             
           END-IF.                                                      
                                                                        
           ADD WS-TOTAL-CIA-NEG           TO AT-TOTAL-AR-BALANCE.       
           MOVE 'A'                       TO WS-CODE-CIA.               
                                                                        
       2660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2670-SCC-BILL-MSG                                           *        
      *       INSERT SPECIAL BILL MESSAGE FOR ALL SERVICECARE CREDITS. *        
      ******************************************************************        
       2670-SCC-BILL-MSG.                                               
                                                                        
           IF AT-REV-MTH-LST-NRML > 0                                   
              COMPUTE U1-REVENUE-MO-ST                                  
                    = AT-REV-MTH-LST-NRML + 1                           
           ELSE                                                         
              MOVE WS-CURRENT-DATE(1:4)    TO WS-REV-MTH-CCYY           
              MOVE WS-CURRENT-DATE(6:2)    TO WS-REV-MTH-MM             
              MOVE WS-CUR-REV-MTH-NUM      TO WS-CUR-REV-MTH-DEC        
              MOVE WS-CUR-REV-MTH-DEC      TO U1-REVENUE-MO-ST          
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO              TO U1-ACCOUNT-NO.            
           MOVE '95005'                    TO U1-BILL-MSG-ID.           
           MOVE 'M'                        TO U1-MSG-TYPE-CD.           
           MOVE AT-COMPANY-NO              TO U1-COMPANY-NO.            
           MOVE 1                          TO U1-BILL-CYCLE-ST.         
           MOVE 21                         TO U1-BILL-CYCLE-END.        
           MOVE U1-REVENUE-MO-ST           TO U1-REVENUE-MO-END.        
                                                                        
           PERFORM 8850-INSERT-SPCL-BILL-MSG THRU 8850-EXIT.            
                                                                        
       2670-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5500-MAINTENANCE-HISTORY.                                     *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
       5500-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '5500'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7050-SELECT-CURRENT-DATE THRU 7050-EXIT.             
           MOVE WS-CURRENT-TIMESTAMP   TO MH-TRANS-HIST-SEQ-NO,         
           MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS                 
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE AT-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE WS-USER-ID             TO MH-USER-ID.                   
           MOVE 'PANEL404P'            TO MH-APPL-PROGRAM-ID.           
           MOVE +1                     TO MI-TRAN-APPL-NO.              
           MOVE 'TEMP PULL CODE'       TO MI-COLUMN-DESC.               
           MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE AT-CODE-TEMP-BILL      TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN.      
           MOVE 'T'                    TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE '71'                   TO MI-TABLE-ID.                  
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE 1                            TO MI-TRAN-APPL-NO.        
           COMPUTE MH-TRAN-COMMENT-LEN =                                
            (LENGTH OF WS-MANUAL-PULL) + (LENGTH OF WS-TH-COMMENT) + 2  
           STRING                                                       
                WS-MANUAL-PULL DELIMITED BY SIZE                        
                SPACE SPACE WS-TH-COMMENT DELIMITED BY SIZE             
                INTO MH-TRAN-COMMENT-TEXT.                              
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           PERFORM 7625-UPDATE-BILL-PULL     THRU 7625-EXIT.            
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05207******************************************************************        
A05207* 5600-CREATE-CIS-CONTRACT                                                
A05207******************************************************************        
A05207                                                                  
       5600-CREATE-CIS-CONTRACT.                                        
                                                                        
            SET  CONTRACT-INSERT          TO TRUE.                      
            SET  CALLED-FROM-ONLINE       TO TRUE.                      
            SET  SALS-FRCE-CONTRACT       TO TRUE.                      
                                                                        
            MOVE WS-USER-ID               TO WS-4822-USER-ID.           
            MOVE WS-ACCOUNT-NO            TO WS-4822-ACCOUNT-NO.        
            MOVE PROGRAM-NAME             TO WS-4822-CNT-APPL-PGM-ID.   
                                                                        
            CALL MCSCB822 USING ABEND-FILE                              
                               ,WS-WARNING-DATA-ELEMENTS                
                               ,WS-CONTRACT-HEADER-PARMS                
                               ,WS-CONTRACT-DETAIL-PARMS                
                               ,WS-CONTRACT-OPERATION-TYPE              
                               ,WS-CONTRACT-RETURN-INFO.                
                                                                        
            IF CPD4822-DB2-ERR-FOUND                                    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '5600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CALL'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE MCSCB822                TO TABLE-1                  
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            END-IF.                                                     
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6500-ONLINE-LOAD-AR-TRAN-HIST                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *     JOURNALING ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    7050-SELECT-CURRENT-DATE                                    *        
      *       SELECT CURRENT DATE FROM CSS_MODEL_SQL                   *        
      ******************************************************************        
       7050-SELECT-CURRENT-DATE.                                        
                                                                        
           EXEC SQL                                                     
             SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-DATE                                               
MFA-TR*           = CURRENT DATE,                                               
MFA-TR*          :WS-CURRENT-TIMESTAMP                                          
MFA-TR*           = CURRENT TIMESTAMP                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7150-SELECT-MAX-CNT-ID                                      *        
      *       SELECT MAXIMUM CONTRACT ID                               *        
      ******************************************************************        
       7150-SELECT-MAX-CNT-ID.                                          
                                                                        
           MOVE 0                              TO WS-NULL-IND-1         
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CNT_ITEM_ID)                                    
A05207         INTO :WS-CNT-ITEM-ID :WS-NULL-IND-1                      
               FROM CSS_CONTRACT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                  
                AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL           
                AND CNT_ITEM_ID < 2000000                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(CNT_ITEM_ID)                                            
MFA-TR*        INTO :WS-CNT-ITEM-ID :WS-NULL-IND-1                              
MFA-TR*        FROM CSS_CONTRACT                                                
MFA-TR*       WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                          
MFA-TR*         AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL                   
MFA-TR*         AND CNT_ITEM_ID < 2000000                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-1 = -1                                     
A05207           MOVE 1000000                  TO WS-CNT-ITEM-ID        
              ELSE                                                      
A05207           ADD 1                         TO WS-CNT-ITEM-ID        
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7150'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CONTRACT'              TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'         TO TABLE-ELEMENT-2       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              MOVE CT-PYMT-PRIORITY-LVL        TO HOSTVAR-ELEMENT-2     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7200-SELECT-ACCOUNT-INFO.                                   *        
      *       SELECT ACCOUNT TABLE                                     *        
      ******************************************************************        
       7200-SELECT-ACCOUNT-INFO.                                        
                                                                        
           EXEC SQL                                                     
             SELECT PREMISE_NO                                          
                    ,COMPANY_NO                                         
                    ,LOCAL_OFFICE                                       
                    ,TOTAL_AR_BALANCE                                   
                    ,CODE_COMPANY_ACCT                                  
                    ,CODE_ACCT_STAT                                     
                    ,CUSTOMER_NO                                        
                    ,CODES_DATA_PRESENT                                 
                    ,CODE_TEMP_BILL                                     
                    ,REV_MTH_LST_NRML                                   
               INTO :AT-PREMISE-NO                                      
                    ,:AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODE-COMPANY-ACCT                              
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-CODE-TEMP-BILL                                 
                    ,:AT-REV-MTH-LST-NRML                               
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PREMISE_NO                                                  
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,TOTAL_AR_BALANCE                                           
MFA-TR*             ,CODE_COMPANY_ACCT                                          
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,CODES_DATA_PRESENT                                         
MFA-TR*             ,CODE_TEMP_BILL                                             
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*        INTO :AT-PREMISE-NO                                              
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CODE-COMPANY-ACCT                                      
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-TEMP-BILL                                         
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_ACCOUNT'              TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           IF AT-CODE-ACCT-STAT NOT = 'A'                               
               MOVE 5050                     TO RS-APPL-RETURN-CODE     
               PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
      *        ADD +1                        TO CTR-ROWS-RS1                    
               ADD +1                        TO CTR-ROWS                
               PERFORM 8100-SEND-RESULT      THRU 8100-EXIT             
               PERFORM 9999-END-PROGRAM      THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7250-SELECT-CNT-INFO.                                       *        
      *       SELECT CONTRACT INFO                                     *        
      ******************************************************************        
       7250-SELECT-CONTRACT-INFO.                                       
           EXEC SQL                                                     
             SELECT CNT_NAME_CD                                         
                   ,CHARGE_TYPE_CD                                      
                   ,CNT_NAME_DESC                                       
                   ,GL_ACCT_NO                                          
                   ,COST_CENTER                                         
                   ,GL_ACCT_NO_ERN_INT                                  
                   ,GL_ACCT_NO_DEF_INT                                  
                   ,WRT_OFF_GL_ACCT_NO                                  
                   ,CODE_CONTRACT_TYPE                                  
               INTO :K6-CNT-NAME-CD                                     
                   ,:K6-CHARGE-TYPE-CD                                  
                   ,:K6-CNT-NAME-DESC                                   
                   ,:K6-GL-ACCT-NO                                      
                   ,:K6-COST-CENTER                                     
                   ,:K6-GL-ACCT-NO-ERN-INT                              
                   ,:K6-GL-ACCT-NO-DEF-INT                              
                   ,:K6-WRT-OFF-GL-ACCT-NO                              
                   ,:K6-CODE-CONTRACT-TYPE                              
               FROM CSS_CONTRACT_INFO WITH(READUNCOMMITTED)                     
              WHERE CODE_BILL_TYPE = :WS-CODE-BILL-TYPE                 
                AND APPL_ACCT_CD   = :K6-APPL-ACCT-CD                   
                AND COMPANY_NO     = :AT-COMPANY-NO                     
                AND REBATE_CD      = :WS-REBATE-CD                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CNT_NAME_CD                                                 
MFA-TR*            ,CHARGE_TYPE_CD                                              
MFA-TR*            ,CNT_NAME_DESC                                               
MFA-TR*            ,GL_ACCT_NO                                                  
MFA-TR*            ,COST_CENTER                                                 
MFA-TR*            ,GL_ACCT_NO_ERN_INT                                          
MFA-TR*            ,GL_ACCT_NO_DEF_INT                                          
MFA-TR*            ,WRT_OFF_GL_ACCT_NO                                          
MFA-TR*            ,CODE_CONTRACT_TYPE                                          
MFA-TR*        INTO :K6-CNT-NAME-CD                                             
MFA-TR*            ,:K6-CHARGE-TYPE-CD                                          
MFA-TR*            ,:K6-CNT-NAME-DESC                                           
MFA-TR*            ,:K6-GL-ACCT-NO                                              
MFA-TR*            ,:K6-COST-CENTER                                             
MFA-TR*            ,:K6-GL-ACCT-NO-ERN-INT                                      
MFA-TR*            ,:K6-GL-ACCT-NO-DEF-INT                                      
MFA-TR*            ,:K6-WRT-OFF-GL-ACCT-NO                                      
MFA-TR*            ,:K6-CODE-CONTRACT-TYPE                                      
MFA-TR*        FROM CSS_CONTRACT_INFO                                           
MFA-TR*       WHERE CODE_BILL_TYPE = :WS-CODE-BILL-TYPE                         
MFA-TR*         AND APPL_ACCT_CD   = :K6-APPL-ACCT-CD                           
MFA-TR*         AND COMPANY_NO     = :AT-COMPANY-NO                             
MFA-TR*         AND REBATE_CD      = :WS-REBATE-CD                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7250'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CONTRACT_INFO'        TO TABLE-1               
               MOVE 'CODE_BILL_TYPE'           TO TABLE-ELEMENT-1       
               MOVE 'APPL_ACCT_CD'             TO TABLE-ELEMENT-2       
               MOVE 'REBATE_CD'                TO TABLE-ELEMENT-3       
               MOVE WS-CODE-BILL-TYPE          TO HOSTVAR-ELEMENT-1     
               MOVE K6-APPL-ACCT-CD            TO HOSTVAR-ELEMENT-2     
               MOVE WS-REBATE-CD               TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7300-SELECT-CNT-INFO.                                       *        
      *       SELECT CONTRACT INFO                                     *        
      ******************************************************************        
       7300-SELECT-CNT-INFO.                                            
                                                                        
           EXEC SQL                                                     
             SELECT CNT_NAME_CD                                         
                   ,CHARGE_TYPE_CD                                      
                   ,CNT_NAME_DESC                                       
                   ,GL_ACCT_NO                                          
                   ,COST_CENTER                                         
                   ,WRT_OFF_GL_ACCT_NO                                  
               INTO :K6-CNT-NAME-CD                                     
                   ,:K6-CHARGE-TYPE-CD                                  
                   ,:K6-CNT-NAME-DESC                                   
                   ,:K6-GL-ACCT-NO                                      
                   ,:K6-COST-CENTER                                     
                   ,:K6-WRT-OFF-GL-ACCT-NO                              
               FROM CSS_CONTRACT_INFO WITH(READUNCOMMITTED)                     
              WHERE CNT_NAME_CD  = :CT-CNT-NAME-CD                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CNT_NAME_CD                                                 
MFA-TR*            ,CHARGE_TYPE_CD                                              
MFA-TR*            ,CNT_NAME_DESC                                               
MFA-TR*            ,GL_ACCT_NO                                                  
MFA-TR*            ,COST_CENTER                                                 
MFA-TR*            ,WRT_OFF_GL_ACCT_NO                                          
MFA-TR*        INTO :K6-CNT-NAME-CD                                             
MFA-TR*            ,:K6-CHARGE-TYPE-CD                                          
MFA-TR*            ,:K6-CNT-NAME-DESC                                           
MFA-TR*            ,:K6-GL-ACCT-NO                                              
MFA-TR*            ,:K6-COST-CENTER                                             
MFA-TR*            ,:K6-WRT-OFF-GL-ACCT-NO                                      
MFA-TR*        FROM CSS_CONTRACT_INFO                                           
MFA-TR*       WHERE CNT_NAME_CD  = :CT-CNT-NAME-CD                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CONTRACT_INFO'        TO TABLE-1               
               MOVE 'CNT_NAME_CD'              TO TABLE-ELEMENT-1       
               MOVE K6-CNT-NAME-CD             TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7450-SELECT-PREMISE.                                        *        
      *       SELECT PREMISE TABLE                                     *        
      ******************************************************************        
       7450-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
             SELECT REV_DISTRICT_CD                                     
                   ,CODE_PREMISE_STAT                                   
             INTO  :PR-REV-DISTRICT-CD                                  
                  ,:PR-CODE-PREMISE-STAT                                
             FROM CSS_PREMISE WITH(READUNCOMMITTED)                             
             WHERE PREMISE_NO = :AT-PREMISE-NO                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT REV_DISTRICT_CD                                             
MFA-TR*            ,CODE_PREMISE_STAT                                           
MFA-TR*      INTO  :PR-REV-DISTRICT-CD                                          
MFA-TR*           ,:PR-CODE-PREMISE-STAT                                        
MFA-TR*      FROM CSS_PREMISE                                                   
MFA-TR*      WHERE PREMISE_NO = :AT-PREMISE-NO                                  
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7450'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_PREMISE'              TO TABLE-1               
               MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1       
               MOVE PR-PREMISE-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7460-SELECT-CUSTOMER.                                       *        
      *       SELECT CUSTOMER TABLE                                    *        
      ******************************************************************        
       7460-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT   CODE_EMPL_ACCT                                   
              INTO    :CU-CODE-EMPL-ACCT                                
              FROM     CSS_CUSTOMER WITH(READUNCOMMITTED)                       
              WHERE    CUSTOMER_NO = :AT-CUSTOMER-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   CODE_EMPL_ACCT                                           
MFA-TR*       INTO    :CU-CODE-EMPL-ACCT                                        
MFA-TR*       FROM     CSS_CUSTOMER                                             
MFA-TR*       WHERE    CUSTOMER_NO = :AT-CUSTOMER-NO                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7460'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CUSTOMER'             TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7500-SELECT-AR-CNTL.                                        *        
      *       SELECT AR CONTROL                                        *        
      ******************************************************************        
       7500-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
                 SELECT   AMT_AR_DAY_00                                 
                        , AMT_AR_DAY_30                                 
                        , AMT_AR_DAY_60                                 
                        , AMT_AR_DAY_90                                 
                        , AMT_TRAN_BALANCE                              
                        , AMT_UNUSED_CR                                 
                        , REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
                        , TOT_SUMM_UNBILLED                             
                   INTO   :AC-AMT-AR-DAY-00                             
                        , :AC-AMT-AR-DAY-30                             
                        , :AC-AMT-AR-DAY-60                             
                        , :AC-AMT-AR-DAY-90                             
                        , :AC-AMT-TRAN-BALANCE                          
                        , :AC-AMT-UNUSED-CR                             
                        , :AC-LAST-UPDATE-TS                            
                        , :AC-TOT-SUMM-UNBILLED                         
                   FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                     
                  WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO            
                    AND   PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL     
                    AND   ITEM_ID           = :AC-ITEM-ID               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT   AMT_AR_DAY_00                                         
MFA-TR*                 , AMT_AR_DAY_30                                         
MFA-TR*                 , AMT_AR_DAY_60                                         
MFA-TR*                 , AMT_AR_DAY_90                                         
MFA-TR*                 , AMT_TRAN_BALANCE                                      
MFA-TR*                 , AMT_UNUSED_CR                                         
MFA-TR*                 , LAST_UPDATE_TS                                        
MFA-TR*                 , TOT_SUMM_UNBILLED                                     
MFA-TR*            INTO   :AC-AMT-AR-DAY-00                                     
MFA-TR*                 , :AC-AMT-AR-DAY-30                                     
MFA-TR*                 , :AC-AMT-AR-DAY-60                                     
MFA-TR*                 , :AC-AMT-AR-DAY-90                                     
MFA-TR*                 , :AC-AMT-TRAN-BALANCE                                  
MFA-TR*                 , :AC-AMT-UNUSED-CR                                     
MFA-TR*                 , :AC-LAST-UPDATE-TS                                    
MFA-TR*                 , :AC-TOT-SUMM-UNBILLED                                 
MFA-TR*            FROM   CSS_AR_CNTL                                           
MFA-TR*           WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO                    
MFA-TR*             AND   PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL             
MFA-TR*             AND   ITEM_ID           = :AC-ITEM-ID                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
              OR WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
              MOVE '7500'                    TO   ACTIVE-PARAGRAPH      
              MOVE '7500-SELECT-AR-CN'       TO   ABEND-FUNCTION        
              MOVE 'CSS_AR_CNTL      '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'ITEM_ID     '            TO   TABLE-ELEMENT-3       
              MOVE AC-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE AC-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
              MOVE AC-ITEM-ID                TO   HOSTVAR-ELEMENT-2     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7550-INSERT-AR-CNTL                                         *        
      *       SELECT AR CONTROL                                        *        
      ******************************************************************        
       7550-INSERT-AR-CNTL.                                             
                                                                        
           MOVE '7550'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_AR_CNTL                                 
                       (  ACCOUNT_NO                                    
                        , AMT_AR_DAY_00                                 
                        , AMT_AR_DAY_30                                 
                        , AMT_AR_DAY_60                                 
                        , AMT_AR_DAY_90                                 
                        , AMT_TRAN_BALANCE                              
                        , AMT_UNUSED_CR                                 
                        , ITEM_ID                                       
                        , LAST_UPDATE_TS                                
                        , PYMT_PRIORITY_LVL                             
                        , TOT_SUMM_UNBILLED )                           
                VALUES (  :AC-ACCOUNT-NO                                
                        , :AC-AMT-AR-DAY-00                             
                        , :AC-AMT-AR-DAY-30                             
                        , :AC-AMT-AR-DAY-60                             
                        , :AC-AMT-AR-DAY-90                             
                        , :AC-AMT-TRAN-BALANCE                          
                        , :AC-AMT-UNUSED-CR                             
                        , :AC-ITEM-ID                                   
                        , CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)             
                        , :AC-PYMT-PRIORITY-LVL                         
                        , :AC-TOT-SUMM-UNBILLED )                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_AR_CNTL                                         
MFA-TR*                (  ACCOUNT_NO                                            
MFA-TR*                 , AMT_AR_DAY_00                                         
MFA-TR*                 , AMT_AR_DAY_30                                         
MFA-TR*                 , AMT_AR_DAY_60                                         
MFA-TR*                 , AMT_AR_DAY_90                                         
MFA-TR*                 , AMT_TRAN_BALANCE                                      
MFA-TR*                 , AMT_UNUSED_CR                                         
MFA-TR*                 , ITEM_ID                                               
MFA-TR*                 , LAST_UPDATE_TS                                        
MFA-TR*                 , PYMT_PRIORITY_LVL                                     
MFA-TR*                 , TOT_SUMM_UNBILLED )                                   
MFA-TR*         VALUES (  :AC-ACCOUNT-NO                                        
MFA-TR*                 , :AC-AMT-AR-DAY-00                                     
MFA-TR*                 , :AC-AMT-AR-DAY-30                                     
MFA-TR*                 , :AC-AMT-AR-DAY-60                                     
MFA-TR*                 , :AC-AMT-AR-DAY-90                                     
MFA-TR*                 , :AC-AMT-TRAN-BALANCE                                  
MFA-TR*                 , :AC-AMT-UNUSED-CR                                     
MFA-TR*                 , :AC-ITEM-ID                                           
MFA-TR*                 , :WS-CURRENT-TIMESTAMP                                 
MFA-TR*                 , :AC-PYMT-PRIORITY-LVL                                 
MFA-TR*                 , :AC-TOT-SUMM-UNBILLED )                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
              MOVE '7550'                    TO   ACTIVE-PARAGRAPH      
              MOVE SPACES                    TO   ABEND-TABLES          
              MOVE SPACES                    TO   ABEND-SQL-PREDICATES  
              MOVE 'CSS_AR_CNTL   '          TO   TABLE-1               
              MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'ITEM-ID     '            TO   TABLE-ELEMENT-3       
              MOVE AC-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE AC-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
              MOVE AC-ITEM-ID                TO   HOSTVAR-ELEMENT-3     
              MOVE '7010-INSERT-AR-CNTL'     TO   ABEND-FUNCTION        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *    7600-UPD-ARCNTL-ZERO-DAY-ONLY.                              *        
      *       SELECT AR CONTROL                                        *        
      ******************************************************************        
       7600-UPD-ARCNTL-ZERO-DAY-ONLY.                                   
                                                                        
           MOVE '7600'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00              
                   , LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_CNTL                                                
MFA-TR*         SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00                      
MFA-TR*            , LAST_UPDATE_TS    = :WS-CURRENT-TIMESTAMP                  
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
              MOVE '7600-UPD-ARCNTL-ZERO'     TO   ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-2      
              MOVE 'ITEM-ID     '             TO   TABLE-ELEMENT-3      
              MOVE AC-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE AC-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-2    
              MOVE AC-ITEM-ID                 TO   HOSTVAR-ELEMENT-3    
              MOVE '7600'                     TO   HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7605-UPDATE-AR-CNTL.                                        *        
      *       UPDATE AR CONTROL                                        *        
      ******************************************************************        
       7605-UPDATE-AR-CNTL.                                             
                                                                        
           MOVE '7605'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00              
                    ,AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30              
                    ,AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60              
                    ,AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90              
                    ,AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE           
                    ,AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR              
                    ,TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED          
                    ,LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_CNTL                                                
MFA-TR*         SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00                      
MFA-TR*             ,AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30                      
MFA-TR*             ,AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60                      
MFA-TR*             ,AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90                      
MFA-TR*             ,AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE                   
MFA-TR*             ,AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR                      
MFA-TR*             ,TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED                  
MFA-TR*             ,LAST_UPDATE_TS    = :WS-CURRENT-TIMESTAMP                  
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
              MOVE '7605-UPDATE-AR-CNTL'      TO   ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-2      
              MOVE 'ITEM-ID     '             TO   TABLE-ELEMENT-3      
              MOVE AC-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE AC-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-2    
              MOVE AC-ITEM-ID                 TO   HOSTVAR-ELEMENT-3    
              MOVE '7605'                     TO   HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7605-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7625-UPDATE-BILL-PULL.                                                  
      ******************************************************************        
       7625-UPDATE-BILL-PULL.                                           
                                                                        
           MOVE '7625'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                SET  CODE_TEMP_BILL    = 'T'                            
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
              MOVE '7625-UPDATE-BILL-PULL'    TO   ABEND-FUNCTION       
              MOVE 'CSS_ACCOUNT       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE '7625'                     TO   HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-UPDATE-ACCOUNT.                                                    
      ******************************************************************        
       7650-UPDATE-ACCOUNT.                                             
           MOVE '7650'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                SET  TOTAL_AR_BALANCE  = :AT-TOTAL-AR-BALANCE           
                   , CODES_DATA_PRESENT= :AT-CODES-DATA-PRESENT         
                   , LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*         SET  TOTAL_AR_BALANCE  = :AT-TOTAL-AR-BALANCE                   
MFA-TR*            , CODES_DATA_PRESENT= :AT-CODES-DATA-PRESENT                 
MFA-TR*            , LAST_UPDATE_TS    = :WS-CURRENT-TIMESTAMP                  
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
              MOVE '7650-UPDATE-ACCOUNT '     TO   ABEND-FUNCTION       
              MOVE 'CSS_ACCOUNT       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE '7650'                     TO   HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-SELECT-GL-ACCT.                                                    
      ******************************************************************        
       7700-SELECT-GL-ACCT.                                             
                                                                        
           MOVE '7700'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
               INTO :GO-GL-ACCT-NO                                      
               FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                        
               WHERE  COMPANY_NO        = '01'                          
               AND    GL_ACCT_NAME      = :GO-GL-ACCT-NAME              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31740000
MFA-TR*        SELECT GL_ACCT_NO                                        31750000
MFA-TR*        INTO :GO-GL-ACCT-NO                                      31760000
MFA-TR*        FROM CSS_GL_ACCT_NO                                      31770000
MFA-TR*        WHERE  COMPANY_NO        = '01'                          31780000
MFA-TR*        AND    GL_ACCT_NAME      = :GO-GL-ACCT-NAME              31790000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    31800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
              MOVE '7700-SELECT-GL-ACCT '     TO   ABEND-FUNCTION       
              MOVE 'CSS_GL-ACCT-NO    '       TO   TABLE-1              
              MOVE 'GO-GL-ACCT-NAME'          TO   TABLE-ELEMENT-1      
              MOVE GO-GL-ACCT-NAME            TO   HOSTVAR-ELEMENT-1    
              MOVE '7650'                     TO   HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00000100
      * 7999-SELECT-AL.                                                *00000200
      ******************************************************************00000300
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************00000100
      * 8000A-DELETE-GTT-ROWS.                                         *00000200
      ******************************************************************00000300
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04792_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04792_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04792_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00003400
                                                                        
      *****************************************************************         
      * 8100-SEND-RESULT.                                             *         
      *****************************************************************         
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04792_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :RS-RETURN-CODE                                           
             ,:RS-APPL-RETURN-CODE                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04792_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-APPL-RETURN-CODE                                              
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'Y'                  TO WS-ERR-INSRT-R1              
              MOVE 'CSR04792_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *    ADD 1 TO CTR-ROWS-RS1.                                               
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *    8800-CHECK-RESULTS.                                         *        
      ******************************************************************        
       8800-CHECK-RESULTS.                                              
                                                                        
      *    IF CTR-ROWS-RS1 <= 0                                                 
           IF CTR-ROWS <= 0                                             
              INITIALIZE TDS-RETURN-FIELDS                              
              MOVE 0                        TO RS-RETURN-CODE           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    8850-INSERT-SPCL-BILL-MSG                                   *        
      *       INSERT TO SPECIAL BILL MESSAGE TABLE                     *        
      ******************************************************************        
       8850-INSERT-SPCL-BILL-MSG.                                       
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_SPCL_BILL_MSG                              
                  ( REVENUE_MO_ST                                       
                   ,ACCOUNT_NO                                          
                   ,BILL_MSG_ID                                         
                   ,MSG_TYPE_CD                                         
                   ,COMPANY_NO                                          
                   ,BILL_CYCLE_ST                                       
                   ,BILL_CYCLE_END                                      
                   ,REVENUE_MO_END )                                    
            VALUES (:U1-REVENUE-MO-ST                                   
                   ,:U1-ACCOUNT-NO                                      
                   ,:U1-BILL-MSG-ID                                     
                   ,:U1-MSG-TYPE-CD                                     
                   ,:U1-COMPANY-NO                                      
                   ,:U1-BILL-CYCLE-ST                                   
                   ,:U1-BILL-CYCLE-END                                  
                   ,:U1-REVENUE-MO-END )                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '8900'                        TO ACTIVE-PARAGRAPH    
              MOVE 'INSERT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_SPCL_BILL_MSG'           TO TABLE-1             
              MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
              MOVE U1-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
              MOVE 'BILL_MSG_ID'                 TO TABLE-ELEMENT-2     
              MOVE U1-BILL-MSG-ID                TO HOSTVAR-ELEMENT-2   
              MOVE 'REVENUE_MO_END'              TO TABLE-ELEMENT-3     
              MOVE U1-REVENUE-MO-END             TO HOSTVAR-ELEMENT-3   
              PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
              PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE.                                               *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            RS-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04792_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT.                                       *         
      *****************************************************************         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               RS-RETURN-CODE.          
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
     **    IF WS-GTT01-DECLARED = 'N'                                           
              PERFORM 0100A-DECLARE-GTT-R1  THRU 0100A-EXIT.            
     **    END-IF.                                                              
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9700-PROCESS-ABEND.                                           *         
      *****************************************************************         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14820000
      * 9900-SQL-ERROR-ROUTINE                                         *14830000
      ******************************************************************14840000
           EXEC SQL                                                     14850000
              INCLUDE CPDSP300                                          14860000
           END-EXEC.                                                    14870000
      ******************************************************************14840000
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
