       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04791.                                          
       AUTHOR.       RAJU MANCHAM.                                      
       DATE-WRITTEN. MAY 2014.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS IS THE DRIVER PROGRAM FOR GETTING METER DATA TO VALIDATE *        
      *  BEFORE POSTING.                                               *        
      *  THIS PROGRAM IS USED TO RETRIEVE METER DATA FOR METER VIEW    *        
      *  IN COMPLETION WIZARD.                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  08/16/2011 MSR       INITIAL VERSION                          *        
P00795* 12/1/2015  MSR       Add missing fields for MOD posting       *         
P00795* 1/28/2016  MSR       Add check for group A orders             *         
P00795* 2/09/2016  MSR       Add Code Status reason                   *         
P00795* 3/9/2016   MSR       Add meter supplying field                *         
      * 8/10/2016  MLF       Add code to check history_fl when        *         
      *                      getting order type.                      *         
      * 8/16/2016  MLF       Removed check for 'FW004' in 2000        *         
      * 8/30/2016  MLF       Added Meter_Pressure as returned from    *         
      *                      CSR01182.  Added to Result Set #3.       *         
      * 11/03/2016 MLF       Added check for 'MCU' 'MCB' on           *         
      *                      css_so_order_inst table for SO.          *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04791'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04791 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04791_R1'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04791_R2'.          
            05  GTT-NAME-4              PIC X(26) VALUE                 
                                        'SESSION.CSR04791_R3'.          
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1        PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-1     PIC X(01) VALUE SPACES.          
             10 S-IC-NO-1              PIC S9(4) COMP VALUE 0.          
             10 S-RATE-PLAN-NO-1       PIC X(03) VALUE SPACES.          
             10 S-RATE-DESC-1          PIC X(50) VALUE SPACES.          
             10 S-METER-NO-1           PIC X(09) VALUE SPACES.          
             10 S-MTR-REF-NO-1         PIC S9(4) COMP VALUE 0.          
             10 S-LAST-MTR-RD-VALUE-1  PIC S9(12)V999 COMP-3 VALUE 0.   
             10 S-CODE-USAGE-TYPE-1    PIC X(01) VALUE SPACES.          
             10 S-REG-STATUS-1         PIC X(01) VALUE SPACES.          
             10 S-REG-ID-NO-1          PIC S9(4) COMP VALUE ZERO.       
             10 S-NO-DIALS-1           PIC S9(4) COMP VALUE ZERO.       
             10 S-CONSTANT-1           PIC S9(6)V999 COMP-3 VALUE 0.    
             10 S-WORK-TYPE-CD-1       PIC X(03) VALUE SPACES.          
             10 S-SELECT-TYPE-1        PIC X(02) VALUE SPACES.          
             10 S-SO-INST-SEQ-NO-1     PIC S9(4) COMP VALUE ZERO.       
             10 S-CODE-TIME-PERIOD-1   PIC S9(4) COMP VALUE ZERO.       
             10 S-CODE-USAGE-ID-1      PIC X(01) VALUE SPACES.          
             10 S-CODE-USAGE-SOURCE-1  PIC X(01) VALUE SPACES.          
P00795       10 S-TASK-STATUS-CD-1     PIC X(01) VALUE SPACES.          
P00795       10 S-CODE-REVENUE-CLASS-1 PIC X(03) VALUE SPACES.          
P00795       10 S-REVENUE-CLASS-DESC-1 PIC X(26) VALUE SPACES.          
P00795       10 S-GIS-POINT-ID-1       PIC S9(9) USAGE COMP VALUE 0.    
P00795       10 S-METER-PRESSURE-1     PIC S9(9) USAGE COMP VALUE 0.    
P00795       10 S-CODE-METER-LOC-1     PIC X(02) VALUE SPACES.          
P00795       10 S-CODE-STATUS-REASON-1 PIC X(01) VALUE SPACES.          
P00795       10 S-POINT-ID-1           PIC X(10) VALUE SPACES.          
P00795       10 S-METER-SUPPLIES-1     PIC X(15) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-2     PIC X(01) VALUE SPACES.          
             10 S-IC-NO-2              PIC S9(4) COMP VALUE 0.          
             10 S-RATE-DESC-2          PIC X(50) VALUE SPACES.          
             10 S-METER-NO-2           PIC X(09) VALUE SPACES.          
             10 S-MTR-REF-NO-2         PIC S9(4) COMP VALUE 0.          
             10 S-LAST-MTR-RD-VALUE-2  PIC S9(12)V999 COMP-3 VALUE 0.   
             10 S-READ-VALUE-IS-2      PIC S9(12)V999 COMP-3 VALUE 0.   
             10 S-LAST-REG-RD-DATE-2   PIC X(26) VALUE SPACES.          
             10 S-CODE-USAGE-TYPE-2    PIC X(01) VALUE SPACES.          
             10 S-METER-STATUS-IS-2    PIC X(01) VALUE SPACES.          
             10 S-METER-STATUS-WS-2    PIC X(01) VALUE SPACES.          
             10 S-CODE-STATUS-REA-IS-2 PIC X(01) VALUE SPACES.          
             10 S-CODE-STATUS-REA-WS-2 PIC X(01) VALUE SPACES.          
             10 S-REG-ID-NO-2          PIC S9(4) COMP VALUE ZERO.       
             10 S-NO-DIALS-2           PIC S9(4) COMP VALUE ZERO.       
             10 S-CONSTANT-2           PIC S9(6)V999 COMP-3 VALUE 0.    
             10 S-CODE-USAGE-ID-2      PIC X(01) VALUE SPACES.          
             10 S-CODE-USAGE-SOURCE-2  PIC X(01) VALUE SPACES.          
             10 S-CODE-TIME-PERIOD-2   PIC S9(4) COMP VALUE ZERO.       
             10 S-CODE-DEST-2          PIC X(01) VALUE SPACES.          
             10 S-DEST-NO-2            PIC X(03) VALUE SPACES.          
             10 S-WORK-TYPE-CD-2       PIC X(03) VALUE SPACES.          
             10 S-TABLE-CODE-2         PIC X(02) VALUE SPACES.          
             10 S-SO-INST-SEQ-NO-2     PIC S9(4) COMP VALUE ZERO.       
             10 S-LOCK-TYPE-ID-2       PIC X(01) VALUE SPACES.          
P00795       10 S-RATE-PLAN-NO-2       PIC X(03) VALUE SPACES.          
P00795       10 S-CODE-REVENUE-CLASS-2 PIC X(03) VALUE SPACES.          
P00795       10 S-REVENUE-CLASS-DESC-2 PIC X(26) VALUE SPACES.          
P00795       10 S-TASK-STATUS-CD-2     PIC X(01) VALUE SPACES.          
P00795       10 S-GIS-POINT-ID-2       PIC S9(9) USAGE COMP VALUE 0.    
P00795       10 S-METER-PRESSURE-2     PIC S9(9) USAGE COMP VALUE 0.    
P00795       10 S-CODE-METER-LOC-2     PIC X(02) VALUE SPACES.          
P00795       10 S-POINT-ID-2           PIC X(10) VALUE SPACES.          
P00795       10 S-METER-SUPPLIES-2     PIC X(15) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3        PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-3     PIC X(01) VALUE SPACES.          
             10 S-IC-NO-3              PIC S9(4) COMP VALUE 0.          
             10 S-RATE-PLAN-NO-3       PIC X(03) VALUE SPACES.          
             10 S-RATE-DESC-3          PIC X(50) VALUE SPACES.          
             10 S-METER-NO-3           PIC X(09) VALUE SPACES.          
             10 S-MTR-REF-NO-3         PIC S9(4) COMP VALUE 0.          
             10 S-LAST-MTR-RD-VALUE-3  PIC S9(12)V999 COMP-3 VALUE 0.   
             10 S-CODE-USAGE-TYPE-3    PIC X(01) VALUE SPACES.          
             10 S-REG-STATUS-3         PIC X(01) VALUE SPACES.          
             10 S-REG-ID-NO-3          PIC S9(4) COMP VALUE ZERO.       
             10 S-NO-DIALS-3           PIC S9(4) COMP VALUE ZERO.       
             10 S-CONSTANT-3           PIC S9(6)V999 COMP-3 VALUE 0.    
             10 S-WORK-TYPE-CD-3       PIC X(03) VALUE SPACES.          
             10 S-SELECT-TYPE-3        PIC X(02) VALUE SPACES.          
             10 S-SO-INST-SEQ-NO-3     PIC S9(4) COMP VALUE ZERO.       
             10 S-CODE-TIME-PERIOD-3   PIC S9(4) COMP VALUE ZERO.       
             10 S-CODE-USAGE-ID-3      PIC X(01) VALUE SPACES.          
             10 S-CODE-USAGE-SOURCE-3  PIC X(01) VALUE SPACES.          
P00795       10 S-CODE-STATUS-REASON-3 PIC X(01) VALUE SPACES.          
P00795       10 S-POINT-ID-3           PIC X(10) VALUE SPACES.          
P00795       10 S-CODE-METER-LOC-3     PIC X(02) VALUE SPACES.          
             10 S-METER-PRESSURE-3     PIC S9(9) USAGE COMP VALUE 0.    
                                                                        
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4        PIC S9(9) COMP VALUE ZERO.       
             10 S-PROCESS              PIC X(02) VALUE SPACES.          
                                                                        
P00795    05 GTT-RETURN-FIELDS-5.                                       
P00795       10 S-RETURN-CODE-5        PIC S9(9) COMP VALUE ZERO.       
P00795       10 S-CODE-USAGE-TYPE      PIC X(01) VALUE SPACES.          
P00795       10 S-CODE-USAGE-ID        PIC X(01) VALUE SPACES.          
P00795       10 S-CODE-USAGE-SOURCE    PIC X(01) VALUE SPACES.          
P00795       10 S-CODE-TIME-PERIOD     PIC S9(4)  COMP VALUE 0.         
P00795       10 S-REGISTER-READ-SEQ    PIC S9(4)  COMP VALUE 0.         
P00795       10 S-METER-RD-DISP-CD     PIC X(03) VALUE SPACES.          
P00795       10 S-INDEX-VALUE-CD       PIC X(01) VALUE SPACES.          
P00795       10 S-NO-READ-DIGITS       PIC S9(4) COMP VALUE ZEROES.     
P00795       10 S-NO-READ-DECIMALS     PIC S9(4) COMP VALUE ZEROES.     
P00795       10 S-METER-USAGE-DESC     PIC X(35) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04791'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  WS-DATA-ERROR-FLAG       PIC X(03) VALUE SPACES.          
          05  WS-YES                   PIC X(03) VALUE 'YES'.           
P00795    05  WS-METER-NO-5            PIC X(09) VALUE SPACES.          
          05  WS-MTR-CAP-COUNTER       PIC S9(4) COMP VALUE 0.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-SERV-ORDER-NO         PIC X(13) VALUE SPACES.          
          05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO       
                                       PIC 9(13).                       
          05  WS-HISTORY-FL            PIC X(01) VALUE SPACES.          
          05  WS-SOURCE-SYSTEM         PIC X(03) VALUE SPACES.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT04-DECLARED        PIC X(01) VALUE 'N'.             
P00795    05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.             
          05  DUMMY-DATA               PIC X(01) VALUE SPACES.          
P00795    05  WS-POINT-ID              PIC X(10) VALUE SPACES.          
          05  WS-WORK-TYPE-EXISTS      PIC X(01) VALUE 'N'.             
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01 IND-VARIABLES.                                                
          05 WS-NULL1                    PIC S9(04) COMP.               
                                                                        
       01  CSR01135-CALL-DATA.                                          
           03  SERV-ORDER-NO-1135       PIC X(13) VALUE SPACES.         
           03  HISTORY-FL-1135          PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01135-RETURN-DATA.                                        
           03 CODE-UTIL-TYPE-1135       PIC X(01) VALUE SPACES.         
           03 IC-NO-1135                PIC S9(4) COMP VALUE 0.         
           03 RATE-PLAN-NO-1135         PIC X(03) VALUE SPACES.         
           03 RATE-DESC-1135            PIC X(50) VALUE SPACES.         
           03 METER-NO-1135             PIC X(09) VALUE SPACES.         
           03 MTR-REF-NO-1135           PIC S9(4) COMP VALUE 0.         
           03 LAST-MTR-RD-VALUE-1135    PIC S9(12)V999 COMP-3 VALUE 0.  
           03 CODE-USAGE-TYPE-1135      PIC X(01) VALUE SPACES.         
           03 REGISTER-STATUS-1135      PIC X(01) VALUE SPACES.         
           03 REG-ID-NO-1135            PIC S9(4) COMP VALUE ZERO.      
           03 NO-DIALS-1135             PIC S9(4) COMP VALUE ZERO.      
           03 CONSTANT-1135             PIC S9(6)V999 COMP-3 VALUE 0.   
           03 WORK-TYPE-CD-1135         PIC X(03) VALUE SPACES.         
           03 SELECT-TYPE-1135          PIC X(02) VALUE SPACES.         
           03 SO-INST-SEQ-NO-1135       PIC S9(4) COMP VALUE ZERO.      
           03 CODE-TIME-PERIOD-1135     PIC S9(4) COMP VALUE ZERO.      
           03 CODE-USAGE-ID-1135        PIC X(01) VALUE SPACES.         
           03 CODE-USAGE-SOURCE-1135    PIC X(01) VALUE SPACES.         
P00795     03 TASK-STATUS-CD-1135       PIC X(01) VALUE SPACES.         
P00795     03 CODE-REVENUE-CLASS-1135   PIC X(03) VALUE SPACES.         
P00795     03 REVENUE-CLASS-DESC-1135   PIC X(26) VALUE SPACES.         
P00795     03 GIS-POINT-ID-1135         PIC S9(9) USAGE COMP VALUE 0.   
P00795     03 METER-PRESSURE-1135       PIC S9(9) USAGE COMP VALUE 0.   
P00795     03 CODE-METER-LOC-1135       PIC X(02) VALUE SPACES.         
P00795     03 CODE-STATUS-REASON-1135   PIC X(01) VALUE SPACES.         
P00795     03 POINT-ID-1135             PIC X(10) VALUE SPACES.         
P00795     03 METER-SUPPLIES-1135       PIC X(15) VALUE SPACES.         
                                                                        
       01  CSR01138-CALL-DATA.                                          
           03  SERV-ORDER-NO-1138       PIC X(13) VALUE SPACES.         
           03  HISTORY-FL-1138          PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01138-RETURN-DATA.                                        
           03 CODE-UTIL-TYPE-1138       PIC X(01) VALUE SPACES.         
           03 IC-NO-1138                PIC S9(4) COMP VALUE 0.         
           03 RATE-DESC-1138            PIC X(50) VALUE SPACES.         
           03 METER-NO-1138             PIC X(09) VALUE SPACES.         
           03 MTR-REF-NO-1138           PIC S9(4) COMP VALUE 0.         
           03 LAST-MTR-RD-VALUE-1138    PIC S9(12)V999 COMP-3 VALUE 0.  
           03 READ-VALUE-IS-1138        PIC S9(12)V999 COMP-3 VALUE 0.  
           03 LAST-REG-RD-DATE-1138     PIC X(26) VALUE SPACES.         
           03 CODE-USAGE-TYPE-1138      PIC X(01) VALUE SPACES.         
           03 METER-STATUS-IS-1138      PIC X(01) VALUE SPACES.         
           03 METER-STATUS-WS-1138      PIC X(01) VALUE SPACES.         
           03 CODE-STATUS-REA-IS-1138   PIC X(01) VALUE SPACES.         
           03 CODE-STATUS-REA-WS-1138   PIC X(01) VALUE SPACES.         
           03 REG-ID-NO-1138            PIC S9(4) COMP VALUE ZERO.      
           03 NO-DIALS-1138             PIC S9(4) COMP VALUE ZERO.      
           03 CONSTANT-1138             PIC S9(6)V999 COMP-3 VALUE 0.   
           03 CODE-USAGE-ID-1138        PIC X(01) VALUE SPACES.         
           03 CODE-USAGE-SOURCE-1138    PIC X(01) VALUE SPACES.         
           03 CODE-TIME-PERIOD-1138     PIC S9(4) COMP VALUE ZERO.      
           03 CODE-DEST-1138            PIC X(01) VALUE SPACES.         
           03 DEST-NO-1138              PIC X(03) VALUE SPACES.         
           03 WORK-TYPE-CD-1138         PIC X(03) VALUE SPACES.         
           03 TABLE-CODE-1138           PIC X(02) VALUE SPACES.         
           03 SO-INST-SEQ-NO-1138       PIC S9(4) COMP VALUE ZERO.      
           03 LOCK-TYPE-ID-1138         PIC X(01) VALUE SPACES.         
P00795     03 RATE-PLAN-NO-1138         PIC X(03) VALUE SPACES.         
P00795     03 CODE-REVENUE-CLASS-1138   PIC X(03) VALUE SPACES.         
P00795     03 REVENUE-CLASS-DESC-1138   PIC X(26) VALUE SPACES.         
P00795     03 TASK-STATUS-CD-1138       PIC X(01) VALUE SPACES.         
P00795     03 GIS-POINT-ID-1138         PIC S9(9) USAGE COMP VALUE 0.   
P00795     03 METER-PRESSURE-1138       PIC S9(9) USAGE COMP VALUE 0.   
P00795     03 CODE-METER-LOC-1138       PIC X(02) VALUE SPACES.         
P00795     03 POINT-ID-1138             PIC X(10) VALUE SPACES.         
P00795     03 METER-SUPPLIES-1138       PIC X(15) VALUE SPACES.         
                                                                        
       01  CSR01182-CALL-DATA.                                          
           03  SERV-ORDER-NO-1182       PIC X(13) VALUE SPACES.         
           03  HISTORY-FL-1182          PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01182-RETURN-DATA.                                        
           03 CODE-UTIL-TYPE-1182       PIC X(01) VALUE SPACES.         
           03 IC-NO-1182                PIC S9(4) COMP VALUE 0.         
           03 RATE-PLAN-NO-1182         PIC X(03) VALUE SPACES.         
           03 RATE-DESC-1182            PIC X(50) VALUE SPACES.         
           03 METER-NO-1182             PIC X(09) VALUE SPACES.         
           03 MTR-REF-NO-1182           PIC S9(4) COMP VALUE 0.         
           03 LAST-MTR-RD-VALUE-1182    PIC S9(12)V999 COMP-3 VALUE 0.  
           03 CODE-USAGE-TYPE-1182      PIC X(01) VALUE SPACES.         
           03 REGISTER-STATUS-1182      PIC X(01) VALUE SPACES.         
           03 REG-ID-NO-1182            PIC S9(4) COMP VALUE ZERO.      
           03 NO-DIALS-1182             PIC S9(4) COMP VALUE ZERO.      
           03 CONSTANT-1182             PIC S9(6)V999 COMP-3 VALUE 0.   
           03 WORK-TYPE-CD-1182         PIC X(03) VALUE SPACES.         
           03 SELECT-TYPE-1182          PIC X(02) VALUE SPACES.         
           03 SO-INST-SEQ-NO-1182       PIC S9(4) COMP VALUE ZERO.      
           03 CODE-TIME-PERIOD-1182     PIC S9(4) COMP VALUE ZERO.      
           03 CODE-USAGE-ID-1182        PIC X(01) VALUE SPACES.         
           03 CODE-USAGE-SOURCE-1182    PIC X(01) VALUE SPACES.         
P00795     03 FILLER1-1182              PIC X(03) VALUE SPACES.         
P00795     03 FILLER2-1182              PIC X(03) VALUE SPACES.         
P00795     03 FILLER3-1182              PIC X(01) VALUE SPACES.         
P00795     03 FILLER4-1182              PIC X(01) VALUE SPACES.         
P00795     03 FILLER1-1135              PIC X(01) VALUE SPACES.         
P00795     03 FILLER2-1135              PIC S9(4) COMP VALUE ZERO.      
P00795     03 FILLER3-1135              PIC X(01) VALUE SPACES.         
P00795     03 FILLER1-1138              PIC X(01) VALUE SPACES.         
P00795     03 FILLER2-1138              PIC S9(4) COMP VALUE ZERO.      
P00795     03 FILLER3-1138              PIC X(01) VALUE SPACES.         
P00795     03 FILLER4-1138              PIC X(01) VALUE SPACES.         
P00795     03 CODE-STATUS-REASON-1182   PIC X(01) VALUE SPACES.         
P00795     03 GIS-POINT-ID-1182         PIC S9(9) USAGE COMP VALUE 0.   
P00795     03 CODE-METER-LOC-1182       PIC X(02) VALUE SPACES.         
           03 METER-PRESSURE-1182       PIC S9(9) USAGE COMP VALUE 0.   
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
P00795     EXEC SQL                                                             
P00795        INCLUDE TBRDFMT                                                   
P00795     END-EXEC.                                                            
P00795                                                                  
P00795     EXEC SQL                                                             
P00795        INCLUDE TBMTRENV                                                  
P00795     END-EXEC.                                                            
P00795                                                                  
P00795     EXEC SQL                                                             
P00795        INCLUDE TBSOMTR                                                   
P00795     END-EXEC.                                                            
P00795                                                                  
P00795     EXEC SQL                                                             
P00795        INCLUDE TBPIMPNT                                                  
P00795     END-EXEC.                                                            
P00795                                                                  
P00795***************************************************************           
      *    CSS_MTR_USAGE_VALS S5                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRVAL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
      *01 LOC1135 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1138 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1182 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE        AS RETURN_CODE,                     
                 CODE_UTIL_TYPE     AS CODE_UTIL_TYPE,                  
                 IC_NO              AS IC_NO,                           
                 RATE_PLAN_NO       AS RATE_PLAN_NO,                    
                 RATE_DESC          AS RATE_DESC,                       
                 METER_NO           AS METER_NO,                        
                 MTR_REF_NO         AS MTR_REF_NO,                      
                 LAST_MTR_RD_VALUE  AS LAST_MTR_RD_VALUE,               
                 CODE_USAGE_TYPE    AS CODE_USAGE_TYPE,                 
                 REGISTER_STATUS    AS REGISTER_STATUS,                 
                 REG_ID_NO          AS REG_ID_NO,                       
                 NO_DIALS           AS NO_DIALS,                        
                 CONSTANT           AS CONSTANT,                        
                 WORK_TYPE_CD       AS WORK_TYPE_CD,                    
                 SELECT_TYPE        AS SELECT_TYPE,                     
                 SO_INST_SEQ_NO     AS SO_INST_SEQ_NO,                  
                 CODE_TIME_PERIOD   AS CODE_TIME_PERIOD,                
                 CODE_USAGE_ID      AS CODE_USAGE_ID,                   
                 CODE_USAGE_SOURCE  AS CODE_USAGE_SOURCE,               
P00795           TASK_STATUS_CD     AS TASK_STATUS_CD,                  
P00795           CODE_REVENUE_CLASS AS CODE_REVENUE_CLASS,              
P00795           REVENUE_CLASS_DESC AS REVENUE_CLASS_DESC,              
P00795           GIS_POINT_ID       AS GIS_POINT_ID,                    
P00795           METER_PRESSURE     AS METER_PRESSURE,                  
P00795           CODE_METER_LOC     AS CODE_METER_LOC,                  
P00795           CODE_STATUS_REASON AS CODE_STATUS_REASON,              
P00795           POINT_ID           AS POINT_ID,                        
P00795           METER_SUPPLIES     AS METER_SUPPLIES                   
              FROM #CSR04791_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE        AS RETURN_CODE,                             
MFA-TR*          CODE_UTIL_TYPE     AS CODE_UTIL_TYPE,                          
MFA-TR*          IC_NO              AS IC_NO,                                   
MFA-TR*          RATE_PLAN_NO       AS RATE_PLAN_NO,                            
MFA-TR*          RATE_DESC          AS RATE_DESC,                               
MFA-TR*          METER_NO           AS METER_NO,                                
MFA-TR*          MTR_REF_NO         AS MTR_REF_NO,                              
MFA-TR*          LAST_MTR_RD_VALUE  AS LAST_MTR_RD_VALUE,                       
MFA-TR*          CODE_USAGE_TYPE    AS CODE_USAGE_TYPE,                         
MFA-TR*          REGISTER_STATUS    AS REGISTER_STATUS,                         
MFA-TR*          REG_ID_NO          AS REG_ID_NO,                               
MFA-TR*          NO_DIALS           AS NO_DIALS,                                
MFA-TR*          CONSTANT           AS CONSTANT,                                
MFA-TR*          WORK_TYPE_CD       AS WORK_TYPE_CD,                            
MFA-TR*          SELECT_TYPE        AS SELECT_TYPE,                             
MFA-TR*          SO_INST_SEQ_NO     AS SO_INST_SEQ_NO,                          
MFA-TR*          CODE_TIME_PERIOD   AS CODE_TIME_PERIOD,                        
MFA-TR*          CODE_USAGE_ID      AS CODE_USAGE_ID,                           
MFA-TR*          CODE_USAGE_SOURCE  AS CODE_USAGE_SOURCE,                       
MFA-TR*          TASK_STATUS_CD     AS TASK_STATUS_CD,                          
MFA-TR*          CODE_REVENUE_CLASS AS CODE_REVENUE_CLASS,                      
MFA-TR*          REVENUE_CLASS_DESC AS REVENUE_CLASS_DESC,                      
MFA-TR*          GIS_POINT_ID       AS GIS_POINT_ID,                            
MFA-TR*          METER_PRESSURE     AS METER_PRESSURE,                          
MFA-TR*          CODE_METER_LOC     AS CODE_METER_LOC,                          
MFA-TR*          CODE_STATUS_REASON AS CODE_STATUS_REASON,                      
MFA-TR*          POINT_ID           AS POINT_ID,                                
MFA-TR*          METER_SUPPLIES     AS METER_SUPPLIES                           
MFA-TR*       FROM SESSION.CSR04791_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1        AS RETURN_CODE,           
                      :S-CODE-UTIL-TYPE-1     AS CODE_UTIL_TYPE,        
                      :S-IC-NO-1              AS IC_NO,                 
                      :S-RATE-PLAN-NO-1       AS RATE_PLAN_NO,          
                      :S-RATE-DESC-1          AS RATE_DESC,             
                      :S-METER-NO-1           AS METER_NO,              
                      :S-MTR-REF-NO-1         AS MTR_REF_NO,            
                      :S-LAST-MTR-RD-VALUE-1  AS LAST_MTR_RD_VALUE,     
                      :S-CODE-USAGE-TYPE-1    AS CODE_USAGE_TYPE,       
                      :S-REG-STATUS-1         AS REGISTER_STATUS,       
                      :S-REG-ID-NO-1          AS REG_ID_NO,             
                      :S-NO-DIALS-1           AS NO_DIALS,              
                      :S-CONSTANT-1           AS CONSTANT,              
                      :S-WORK-TYPE-CD-1       AS WORK_TYPE_CD,          
                      :S-SELECT-TYPE-1        AS SELECT_TYPE,           
                      :S-SO-INST-SEQ-NO-1     AS SO_INST_SEQ_NO,        
                      :S-CODE-TIME-PERIOD-1   AS CODE_TIME_PERIOD,      
                      :S-CODE-USAGE-ID-1      AS CODE_USAGE_ID,         
                      :S-CODE-USAGE-SOURCE-1  AS CODE_USAGE_SOURCE,     
P00795                :S-TASK-STATUS-CD-1     AS TASK_STATUS_CD,        
P00795                :S-CODE-REVENUE-CLASS-1 AS CODE_REVENUE_CLASS,    
P00795                :S-REVENUE-CLASS-DESC-1 AS REVENUE_CLASS_DESC,    
P00795                :S-GIS-POINT-ID-1       AS GIS_POINT_ID,          
P00795                :S-METER-PRESSURE-1     AS METER_PRESSURE,        
P00795                :S-CODE-METER-LOC-1     AS CODE_METER_LOC,        
P00795                :S-CODE-STATUS-REASON-1 AS CODE_STATUS_REASON,    
P00795                :S-POINT-ID-1           AS POINT_ID,              
P00795                :S-METER-SUPPLIES-1     AS METER_SUPPLIES         
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1        AS RETURN_CODE,                   
MFA-TR*               :S-CODE-UTIL-TYPE-1     AS CODE_UTIL_TYPE,                
MFA-TR*               :S-IC-NO-1              AS IC_NO,                         
MFA-TR*               :S-RATE-PLAN-NO-1       AS RATE_PLAN_NO,                  
MFA-TR*               :S-RATE-DESC-1          AS RATE_DESC,                     
MFA-TR*               :S-METER-NO-1           AS METER_NO,                      
MFA-TR*               :S-MTR-REF-NO-1         AS MTR_REF_NO,                    
MFA-TR*               :S-LAST-MTR-RD-VALUE-1  AS LAST_MTR_RD_VALUE,             
MFA-TR*               :S-CODE-USAGE-TYPE-1    AS CODE_USAGE_TYPE,               
MFA-TR*               :S-REG-STATUS-1         AS REGISTER_STATUS,               
MFA-TR*               :S-REG-ID-NO-1          AS REG_ID_NO,                     
MFA-TR*               :S-NO-DIALS-1           AS NO_DIALS,                      
MFA-TR*               :S-CONSTANT-1           AS CONSTANT,                      
MFA-TR*               :S-WORK-TYPE-CD-1       AS WORK_TYPE_CD,                  
MFA-TR*               :S-SELECT-TYPE-1        AS SELECT_TYPE,                   
MFA-TR*               :S-SO-INST-SEQ-NO-1     AS SO_INST_SEQ_NO,                
MFA-TR*               :S-CODE-TIME-PERIOD-1   AS CODE_TIME_PERIOD,              
MFA-TR*               :S-CODE-USAGE-ID-1      AS CODE_USAGE_ID,                 
MFA-TR*               :S-CODE-USAGE-SOURCE-1  AS CODE_USAGE_SOURCE,             
MFA-TR*               :S-TASK-STATUS-CD-1     AS TASK_STATUS_CD,                
MFA-TR*               :S-CODE-REVENUE-CLASS-1 AS CODE_REVENUE_CLASS,            
MFA-TR*               :S-REVENUE-CLASS-DESC-1 AS REVENUE_CLASS_DESC,            
MFA-TR*               :S-GIS-POINT-ID-1       AS GIS_POINT_ID,                  
MFA-TR*               :S-METER-PRESSURE-1     AS METER_PRESSURE,                
MFA-TR*               :S-CODE-METER-LOC-1     AS CODE_METER_LOC,                
MFA-TR*               :S-CODE-STATUS-REASON-1 AS CODE_STATUS_REASON,            
MFA-TR*               :S-POINT-ID-1           AS POINT_ID,                      
MFA-TR*               :S-METER-SUPPLIES-1     AS METER_SUPPLIES                 
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE        AS RETURN_CODE,                     
                 CODE_UTIL_TYPE     AS CODE_UTIL_TYPE,                  
                 IC_NO              AS IC_NO,                           
                 RATE_DESC          AS RATE_DESC,                       
                 METER_NO           AS METER_NO,                        
                 MTR_REF_NO         AS MTR_REF_NO,                      
                 LAST_MTR_RD_VALUE  AS LAST_MTR_RD_VALUE,               
                 READ_VALUE_IS      AS READ_VALUE_IS,                   
                 LAST_REG_RD_DATE   AS LAST_REG_RD_DATE,                
                 CODE_USAGE_TYPE    AS CODE_USAGE_TYPE,                 
                 METER_STATUS_IS    AS METER_STATUS_IS,                 
                 METER_STATUS_WS    AS METER_STATUS_WS,                 
                 CODE_STATUS_REA_IS AS CODE_STATUS_REA_IS,              
                 CODE_STATUS_REA_WS AS CODE_STATUS_REA_WS,              
                 REG_ID_NO          AS REG_ID_NO,                       
                 NO_DIALS           AS NO_DIALS,                        
                 CONSTANT           AS CONSTANT,                        
                 CODE_USAGE_ID      AS CODE_USAGE_ID,                   
                 CODE_USAGE_SOURCE  AS CODE_USAGE_SOURCE,               
                 CODE_TIME_PERIOD   AS CODE_TIME_PERIOD,                
                 CODE_DEST          AS CODE_DEST,                       
                 DEST_NO            AS DEST_NO,                         
                 WORK_TYPE_CD       AS WORK_TYPE_CD,                    
                 TABLE_CODE         AS TABLE_CODE,                      
                 SO_INST_SEQ_NO     AS SO_INST_SEQ_NO,                  
                 LOCK_TYPE_ID       AS LOCK_TYPE_ID,                    
P00795           RATE_PLAN_NO       AS RATE_PLAN_NO,                    
P00795           CODE_REVENUE_CLASS AS CODE_REVENUE_CLASS,              
P00795           REVENUE_CLASS_DESC AS REVENUE_CLASS_DESC,              
P00795           TASK_STATUS_CD     AS TASK_STATUS_CD,                  
P00795           GIS_POINT_ID      AS GIS_POINT_ID,                     
P00795           METER_PRESSURE    AS METER_PRESSURE,                   
P00795           CODE_METER_LOC    AS CODE_METER_LOC,                   
P00795           POINT_ID          AS POINT_ID,                         
P00795           METER_SUPPLIES     AS METER_SUPPLIES                   
              FROM #CSR04791_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE        AS RETURN_CODE,                             
MFA-TR*          CODE_UTIL_TYPE     AS CODE_UTIL_TYPE,                          
MFA-TR*          IC_NO              AS IC_NO,                                   
MFA-TR*          RATE_DESC          AS RATE_DESC,                               
MFA-TR*          METER_NO           AS METER_NO,                                
MFA-TR*          MTR_REF_NO         AS MTR_REF_NO,                              
MFA-TR*          LAST_MTR_RD_VALUE  AS LAST_MTR_RD_VALUE,                       
MFA-TR*          READ_VALUE_IS      AS READ_VALUE_IS,                           
MFA-TR*          LAST_REG_RD_DATE   AS LAST_REG_RD_DATE,                        
MFA-TR*          CODE_USAGE_TYPE    AS CODE_USAGE_TYPE,                         
MFA-TR*          METER_STATUS_IS    AS METER_STATUS_IS,                         
MFA-TR*          METER_STATUS_WS    AS METER_STATUS_WS,                         
MFA-TR*          CODE_STATUS_REA_IS AS CODE_STATUS_REA_IS,                      
MFA-TR*          CODE_STATUS_REA_WS AS CODE_STATUS_REA_WS,                      
MFA-TR*          REG_ID_NO          AS REG_ID_NO,                               
MFA-TR*          NO_DIALS           AS NO_DIALS,                                
MFA-TR*          CONSTANT           AS CONSTANT,                                
MFA-TR*          CODE_USAGE_ID      AS CODE_USAGE_ID,                           
MFA-TR*          CODE_USAGE_SOURCE  AS CODE_USAGE_SOURCE,                       
MFA-TR*          CODE_TIME_PERIOD   AS CODE_TIME_PERIOD,                        
MFA-TR*          CODE_DEST          AS CODE_DEST,                               
MFA-TR*          DEST_NO            AS DEST_NO,                                 
MFA-TR*          WORK_TYPE_CD       AS WORK_TYPE_CD,                            
MFA-TR*          TABLE_CODE         AS TABLE_CODE,                              
MFA-TR*          SO_INST_SEQ_NO     AS SO_INST_SEQ_NO,                          
MFA-TR*          LOCK_TYPE_ID       AS LOCK_TYPE_ID,                            
MFA-TR*          RATE_PLAN_NO       AS RATE_PLAN_NO,                            
MFA-TR*          CODE_REVENUE_CLASS AS CODE_REVENUE_CLASS,                      
MFA-TR*          REVENUE_CLASS_DESC AS REVENUE_CLASS_DESC,                      
MFA-TR*          TASK_STATUS_CD     AS TASK_STATUS_CD,                          
MFA-TR*          GIS_POINT_ID      AS GIS_POINT_ID,                             
MFA-TR*          METER_PRESSURE    AS METER_PRESSURE,                           
MFA-TR*          CODE_METER_LOC    AS CODE_METER_LOC,                           
MFA-TR*          POINT_ID          AS POINT_ID,                                 
MFA-TR*          METER_SUPPLIES     AS METER_SUPPLIES                           
MFA-TR*       FROM SESSION.CSR04791_R2                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2        AS RETURN_CODE,           
                      :S-CODE-UTIL-TYPE-2     AS CODE_UTIL_TYPE,        
                      :S-IC-NO-2              AS IC_NO,                 
                      :S-RATE-DESC-2          AS RATE_DESC,             
                      :S-METER-NO-2           AS METER_NO,              
                      :S-MTR-REF-NO-2         AS MTR_REF_NO,            
                      :S-LAST-MTR-RD-VALUE-2  AS LAST_MTR_RD_VALUE,     
                      :S-READ-VALUE-IS-2      AS READ_VALUE_IS,         
                      :S-LAST-REG-RD-DATE-2   AS LAST_REG_RD_DATE,      
                      :S-CODE-USAGE-TYPE-2    AS CODE_USAGE_TYPE,       
                      :S-METER-STATUS-IS-2    AS METER_STATUS_IS,       
                      :S-METER-STATUS-WS-2    AS METER_STATUS_WS,       
                      :S-CODE-STATUS-REA-IS-2 AS CODE_STATUS_REA_IS,    
                      :S-CODE-STATUS-REA-WS-2 AS CODE_STATUS_REA_WS,    
                      :S-REG-ID-NO-2          AS REG_ID_NO,             
                      :S-NO-DIALS-2           AS NO_DIALS,              
                      :S-CONSTANT-2           AS CONSTANT,              
                      :S-CODE-USAGE-ID-2      AS CODE_USAGE_ID,         
                      :S-CODE-USAGE-SOURCE-2  AS CODE_USAGE_SOURCE,     
                      :S-CODE-TIME-PERIOD-2   AS CODE_TIME_PERIOD,      
                      :S-CODE-DEST-2          AS CODE_DEST,             
                      :S-DEST-NO-2            AS DEST_NO,               
                      :S-WORK-TYPE-CD-2       AS WORK_TYPE_CD,          
                      :S-TABLE-CODE-2         AS TABLE_CODE,            
                      :S-SO-INST-SEQ-NO-2     AS SO_INST_SEQ_NO,        
                      :S-LOCK-TYPE-ID-2       AS LOCK_TYPE_ID,          
P00795                :S-RATE-PLAN-NO-2       AS RATE_PLAN_NO,          
P00795                :S-CODE-REVENUE-CLASS-2 AS [CODE_-REVENUE_CLASS],   
P00795                :S-REVENUE-CLASS-DESC-2 AS REVENUE_CLASS_DESC,    
P00795                :S-TASK-STATUS-CD-2     AS TASK_STATUS_CD,        
P00795                :S-GIS-POINT-ID-2       AS GIS_POINT_ID,          
P00795                :S-METER-PRESSURE-2     AS METER_PRESSURE,        
P00795                :S-CODE-METER-LOC-2     AS CODE_METER_LOC,        
P00795                :S-POINT-ID-2           AS POINT_ID,              
P00795                :S-METER-SUPPLIES-2     AS METER_SUPPLIES         
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2        AS RETURN_CODE,                   
MFA-TR*               :S-CODE-UTIL-TYPE-2     AS CODE_UTIL_TYPE,                
MFA-TR*               :S-IC-NO-2              AS IC_NO,                         
MFA-TR*               :S-RATE-DESC-2          AS RATE_DESC,                     
MFA-TR*               :S-METER-NO-2           AS METER_NO,                      
MFA-TR*               :S-MTR-REF-NO-2         AS MTR_REF_NO,                    
MFA-TR*               :S-LAST-MTR-RD-VALUE-2  AS LAST_MTR_RD_VALUE,             
MFA-TR*               :S-READ-VALUE-IS-2      AS READ_VALUE_IS,                 
MFA-TR*               :S-LAST-REG-RD-DATE-2   AS LAST_REG_RD_DATE,              
MFA-TR*               :S-CODE-USAGE-TYPE-2    AS CODE_USAGE_TYPE,               
MFA-TR*               :S-METER-STATUS-IS-2    AS METER_STATUS_IS,               
MFA-TR*               :S-METER-STATUS-WS-2    AS METER_STATUS_WS,               
MFA-TR*               :S-CODE-STATUS-REA-IS-2 AS CODE_STATUS_REA_IS,            
MFA-TR*               :S-CODE-STATUS-REA-WS-2 AS CODE_STATUS_REA_WS,            
MFA-TR*               :S-REG-ID-NO-2          AS REG_ID_NO,                     
MFA-TR*               :S-NO-DIALS-2           AS NO_DIALS,                      
MFA-TR*               :S-CONSTANT-2           AS CONSTANT,                      
MFA-TR*               :S-CODE-USAGE-ID-2      AS CODE_USAGE_ID,                 
MFA-TR*               :S-CODE-USAGE-SOURCE-2  AS CODE_USAGE_SOURCE,             
MFA-TR*               :S-CODE-TIME-PERIOD-2   AS CODE_TIME_PERIOD,              
MFA-TR*               :S-CODE-DEST-2          AS CODE_DEST,                     
MFA-TR*               :S-DEST-NO-2            AS DEST_NO,                       
MFA-TR*               :S-WORK-TYPE-CD-2       AS WORK_TYPE_CD,                  
MFA-TR*               :S-TABLE-CODE-2         AS TABLE_CODE,                    
MFA-TR*               :S-SO-INST-SEQ-NO-2     AS SO_INST_SEQ_NO,                
MFA-TR*               :S-LOCK-TYPE-ID-2       AS LOCK_TYPE_ID,                  
MFA-TR*               :S-RATE-PLAN-NO-2       AS RATE_PLAN_NO,                  
MFA-TR*               :S-CODE-REVENUE-CLASS-2 AS CODE_-REVENUE_CLASS,           
MFA-TR*               :S-REVENUE-CLASS-DESC-2 AS REVENUE_CLASS_DESC,            
MFA-TR*               :S-TASK-STATUS-CD-2     AS TASK_STATUS_CD,                
MFA-TR*               :S-GIS-POINT-ID-2       AS GIS_POINT_ID,                  
MFA-TR*               :S-METER-PRESSURE-2     AS METER_PRESSURE,                
MFA-TR*               :S-CODE-METER-LOC-2     AS CODE_METER_LOC,                
MFA-TR*               :S-POINT-ID-2           AS POINT_ID,                      
MFA-TR*               :S-METER-SUPPLIES-2     AS METER_SUPPLIES                 
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE       AS RETURN_CODE,                      
                 CODE_UTIL_TYPE    AS CODE_UTIL_TYPE,                   
                 IC_NO             AS IC_NO,                            
                 RATE_PLAN_NO      AS RATE_PLAN_NO,                     
                 RATE_DESC         AS RATE_DESC,                        
                 METER_NO          AS METER_NO,                         
                 MTR_REF_NO        AS MTR_REF_NO,                       
                 LAST_MTR_RD_VALUE AS LAST_MTR_RD_VALUE,                
                 CODE_USAGE_TYPE   AS CODE_USAGE_TYPE,                  
                 REGISTER_STATUS   AS REGISTER_STATUS,                  
                 REG_ID_NO         AS REG_ID_NO,                        
                 NO_DIALS          AS NO_DIALS,                         
                 CONSTANT          AS CONSTANT,                         
                 WORK_TYPE_CD      AS WORK_TYPE_CD,                     
                 SELECT_TYPE       AS SELECT_TYPE,                      
                 SO_INST_SEQ_NO    AS SO_INST_SEQ_NO,                   
                 CODE_TIME_PERIOD  AS CODE_TIME_PERIOD,                 
                 CODE_USAGE_ID     AS CODE_USAGE_ID,                    
                 CODE_USAGE_SOURCE AS CODE_USAGE_SOURCE,                
P00795           CODE_STATUS_REASON AS CODE_STATUS_REASON,              
P00795           POINT_ID           AS POINT_ID,                        
P00795           CODE_METER_LOC    AS CODE_METER_LOC,                   
                 METER_PRESSURE    AS METER_PRESSURE                    
              FROM #CSR04791_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE       AS RETURN_CODE,                              
MFA-TR*          CODE_UTIL_TYPE    AS CODE_UTIL_TYPE,                           
MFA-TR*          IC_NO             AS IC_NO,                                    
MFA-TR*          RATE_PLAN_NO      AS RATE_PLAN_NO,                             
MFA-TR*          RATE_DESC         AS RATE_DESC,                                
MFA-TR*          METER_NO          AS METER_NO,                                 
MFA-TR*          MTR_REF_NO        AS MTR_REF_NO,                               
MFA-TR*          LAST_MTR_RD_VALUE AS LAST_MTR_RD_VALUE,                        
MFA-TR*          CODE_USAGE_TYPE   AS CODE_USAGE_TYPE,                          
MFA-TR*          REGISTER_STATUS   AS REGISTER_STATUS,                          
MFA-TR*          REG_ID_NO         AS REG_ID_NO,                                
MFA-TR*          NO_DIALS          AS NO_DIALS,                                 
MFA-TR*          CONSTANT          AS CONSTANT,                                 
MFA-TR*          WORK_TYPE_CD      AS WORK_TYPE_CD,                             
MFA-TR*          SELECT_TYPE       AS SELECT_TYPE,                              
MFA-TR*          SO_INST_SEQ_NO    AS SO_INST_SEQ_NO,                           
MFA-TR*          CODE_TIME_PERIOD  AS CODE_TIME_PERIOD,                         
MFA-TR*          CODE_USAGE_ID     AS CODE_USAGE_ID,                            
MFA-TR*          CODE_USAGE_SOURCE AS CODE_USAGE_SOURCE,                        
MFA-TR*          CODE_STATUS_REASON AS CODE_STATUS_REASON,                      
MFA-TR*          POINT_ID           AS POINT_ID,                                
MFA-TR*          CODE_METER_LOC    AS CODE_METER_LOC,                           
MFA-TR*          METER_PRESSURE    AS METER_PRESSURE                            
MFA-TR*       FROM SESSION.CSR04791_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE,              
                      :S-CODE-UTIL-TYPE-3     AS CODE_UTIL_TYPE,        
                      :S-IC-NO-3              AS IC_NO,                 
                      :S-RATE-PLAN-NO-3       AS RATE_PLAN_NO,          
                      :S-RATE-DESC-3          AS RATE_DESC,             
                      :S-METER-NO-3           AS METER_NO,              
                      :S-MTR-REF-NO-3         AS MTR_REF_NO,            
                      :S-LAST-MTR-RD-VALUE-3  AS LAST_MTR_RD_VALUE,     
                      :S-CODE-USAGE-TYPE-3    AS CODE_USAGE_TYPE,       
                      :S-REG-STATUS-3         AS REGISTER_STATUS,       
                      :S-REG-ID-NO-3          AS REG_ID_NO,             
                      :S-NO-DIALS-3           AS NO_DIALS,              
                      :S-CONSTANT-3           AS CONSTANT,              
                      :S-WORK-TYPE-CD-3       AS WORK_TYPE_CD,          
                      :S-SELECT-TYPE-3        AS SELECT_TYPE,           
                      :S-SO-INST-SEQ-NO-3     AS SO_INST_SEQ_NO,        
                      :S-CODE-TIME-PERIOD-3   AS CODE_TIME_PERIOD,      
                      :S-CODE-USAGE-ID-3      AS CODE_USAGE_ID,         
                      :S-CODE-USAGE-SOURCE-3  AS CODE_USAGE_SOURCE,     
P00795                :S-CODE-STATUS-REASON-3 AS CODE_STATUS_REASON,    
P00795                :S-POINT-ID-3           AS POINT_ID,              
P00795                :S-CODE-METER-LOC-3     AS CODE_METER_LOC,        
P00795                :S-METER-PRESSURE-3     AS METER_PRESSURE         
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                      
MFA-TR*               :S-CODE-UTIL-TYPE-3     AS CODE_UTIL_TYPE,                
MFA-TR*               :S-IC-NO-3              AS IC_NO,                         
MFA-TR*               :S-RATE-PLAN-NO-3       AS RATE_PLAN_NO,                  
MFA-TR*               :S-RATE-DESC-3          AS RATE_DESC,                     
MFA-TR*               :S-METER-NO-3           AS METER_NO,                      
MFA-TR*               :S-MTR-REF-NO-3         AS MTR_REF_NO,                    
MFA-TR*               :S-LAST-MTR-RD-VALUE-3  AS LAST_MTR_RD_VALUE,             
MFA-TR*               :S-CODE-USAGE-TYPE-3    AS CODE_USAGE_TYPE,               
MFA-TR*               :S-REG-STATUS-3         AS REGISTER_STATUS,               
MFA-TR*               :S-REG-ID-NO-3          AS REG_ID_NO,                     
MFA-TR*               :S-NO-DIALS-3           AS NO_DIALS,                      
MFA-TR*               :S-CONSTANT-3           AS CONSTANT,                      
MFA-TR*               :S-WORK-TYPE-CD-3       AS WORK_TYPE_CD,                  
MFA-TR*               :S-SELECT-TYPE-3        AS SELECT_TYPE,                   
MFA-TR*               :S-SO-INST-SEQ-NO-3     AS SO_INST_SEQ_NO,                
MFA-TR*               :S-CODE-TIME-PERIOD-3   AS CODE_TIME_PERIOD,              
MFA-TR*               :S-CODE-USAGE-ID-3      AS CODE_USAGE_ID,                 
MFA-TR*               :S-CODE-USAGE-SOURCE-3  AS CODE_USAGE_SOURCE,             
MFA-TR*               :S-CODE-STATUS-REASON-3 AS CODE_STATUS_REASON,            
MFA-TR*               :S-POINT-ID-3           AS POINT_ID,                      
MFA-TR*               :S-CODE-METER-LOC-3     AS CODE_METER_LOC,                
MFA-TR*               :S-METER-PRESSURE-3     AS METER_PRESSURE                 
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE       AS RETURN_CODE,                      
                 PROCESS           AS PROCESS                           
              FROM #CSR04791_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE       AS RETURN_CODE,                              
MFA-TR*          PROCESS           AS PROCESS                                   
MFA-TR*       FROM SESSION.CSR04791_R4                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N4 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-4     AS RETURN_CODE,              
                      :S-PROCESS              AS PROCESS                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-4     AS RETURN_CODE,                      
MFA-TR*               :S-PROCESS              AS PROCESS                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
P00795     EXEC SQL                                                     
P00795        DECLARE C5 CURSOR  WITH ROWSET POSITIONING FOR 
P00795        SELECT                                                    
P00795              RETURN_CODE       AS RETURN_CODE                    
P00795             ,METER_NO          AS METER_NO                       
P00795             ,CODE_USAGE_TYPE   AS CODE_USAGE_TYPE                
P00795             ,CODE_USAGE_ID     AS CODE_USAGE_ID                  
P00795             ,CODE_USAGE_SOURCE AS CODE_USAGE_SOURCE              
P00795             ,CODE_TIME_PERIOD  AS CODE_TIME_PERIOD               
P00795             ,REGISTER_READ_SEQ AS REGISTER_READ_SEQ              
P00795             ,MTR_RD_DISP_CD    AS MTR_RD_DISP_CD                 
P00795             ,INDEX_VALUE_CD    AS INDEX_VALUE_CD                 
P00795             ,NO_READ_DIGITS    AS NO_READ_DIGITS                 
P00795             ,NO_READ_DECIMALS  AS NO_READ_DECIMALS               
P00795             ,METER_USAGE_DESC  AS METER_USAGE_DESC               
P00795        FROM #CSR04791_R5                                  
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*             RETURN_CODE       AS RETURN_CODE                            
MFA-TR*            ,METER_NO          AS METER_NO                               
MFA-TR*            ,CODE_USAGE_TYPE   AS CODE_USAGE_TYPE                        
MFA-TR*            ,CODE_USAGE_ID     AS CODE_USAGE_ID                          
MFA-TR*            ,CODE_USAGE_SOURCE AS CODE_USAGE_SOURCE                      
MFA-TR*            ,CODE_TIME_PERIOD  AS CODE_TIME_PERIOD                       
MFA-TR*            ,REGISTER_READ_SEQ AS REGISTER_READ_SEQ                      
MFA-TR*            ,MTR_RD_DISP_CD    AS MTR_RD_DISP_CD                         
MFA-TR*            ,INDEX_VALUE_CD    AS INDEX_VALUE_CD                         
MFA-TR*            ,NO_READ_DIGITS    AS NO_READ_DIGITS                         
MFA-TR*            ,NO_READ_DECIMALS  AS NO_READ_DECIMALS                       
MFA-TR*            ,METER_USAGE_DESC  AS METER_USAGE_DESC                       
MFA-TR*       FROM SESSION.CSR04791_R5                                          
MFA-TR*    END-EXEC.                                                            
P00795                                                                  
P00795     EXEC SQL                                                     
P00795         DECLARE N5 CURSOR  FOR                        
P00795         SELECT                                                   
P00795                :S-RETURN-CODE-5     AS RETURN_CODE               
P00795               ,:WS-METER-NO-5       AS METER_NO                  
P00795               ,:S-CODE-USAGE-TYPE   AS CODE_USAGE_TYPE           
P00795               ,:S-CODE-USAGE-ID     AS CODE_USAGE_ID             
P00795               ,:S-CODE-USAGE-SOURCE AS CODE_USAGE_SOURCE         
P00795               ,:S-CODE-TIME-PERIOD  AS CODE_TIME_PERIOD          
P00795               ,:S-REGISTER-READ-SEQ AS REGISTER_READ_SEQ         
P00795               ,:S-METER-RD-DISP-CD  AS MTR_RD_DISP_CD            
P00795               ,:S-INDEX-VALUE-CD    AS INDEX_VALUE_CD            
P00795               ,:S-NO-READ-DIGITS    AS NO_READ_DIGITS            
P00795               ,:S-NO-READ-DECIMALS  AS NO_READ_DECIMALS          
P00795               ,:S-METER-USAGE-DESC  AS METER_USAGE_DESC          
P00795           FROM CIS.SYSDUMMY1                                  
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE N5 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*               :S-RETURN-CODE-5     AS RETURN_CODE                       
MFA-TR*              ,:WS-METER-NO-5       AS METER_NO                          
MFA-TR*              ,:S-CODE-USAGE-TYPE   AS CODE_USAGE_TYPE                   
MFA-TR*              ,:S-CODE-USAGE-ID     AS CODE_USAGE_ID                     
MFA-TR*              ,:S-CODE-USAGE-SOURCE AS CODE_USAGE_SOURCE                 
MFA-TR*              ,:S-CODE-TIME-PERIOD  AS CODE_TIME_PERIOD                  
MFA-TR*              ,:S-REGISTER-READ-SEQ AS REGISTER_READ_SEQ                 
MFA-TR*              ,:S-METER-RD-DISP-CD  AS MTR_RD_DISP_CD                    
MFA-TR*              ,:S-INDEX-VALUE-CD    AS INDEX_VALUE_CD                    
MFA-TR*              ,:S-NO-READ-DIGITS    AS NO_READ_DIGITS                    
MFA-TR*              ,:S-NO-READ-DECIMALS  AS NO_READ_DECIMALS                  
MFA-TR*              ,:S-METER-USAGE-DESC  AS METER_USAGE_DESC                  
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
P00795                                                                  
P00795*     CSS_MTR_RD_FMT CURSOR.                                              
P00795*                                                                         
P00795     EXEC SQL DECLARE OA-PGM-CAP-CURSOR CURSOR FOR                
P00795        SELECT OA.CODE_CAP_TYPE,                                  
P00795               OA.CODE_USAGE_SOURCE,                              
P00795               REG_ID_NO,                                         
P00795               CODE_TIME_PERIOD,                                  
P00795               OA.CODE_USAGE_TYPE,                                
P00795               OA.CODE_USAGE_ID,                                  
P00795               READ_SEQUENCE_NO,                                  
P00795               MTR_RD_DISP_CD,                                    
P00795               INDEX_VALUE_CD,                                    
P00795               NO_READ_DIGITS,                                    
P00795               NO_READ_DECIMALS,                                  
P00795               METER_USAGE_DESC                                   
P00795          FROM CSS_MTR_RD_FMT OA WITH(READUNCOMMITTED)                    
POO795              ,CSS_MTR_USAGE_VALS S5 WITH(READUNCOMMITTED)                
P00795         WHERE OA.CODE_UTIL_TYPE  = :OA-CODE-UTIL-TYPE            
P00795           AND DIGTL_MTR_TYPE  = :OA-DIGTL-MTR-TYPE               
P00795           AND PROGRAM_ID      = :OA-PROGRAM-ID                   
P00795           AND REMOTE_READ_IND = :OA-REMOTE-READ-IND              
P00795           AND MTR_READ_SOURCE_CD = :OA-MTR-READ-SOURCE-CD        
P00795           AND OA.CODE_USAGE_ID = S5.CODE_USAGE_ID                
P00795           AND OA.CODE_USAGE_TYPE = S5.CODE_USAGE_TYPE            
P00795           AND OA.CODE_USAGE_SOURCE = S5.CODE_USAGE_SOURCE        
P00795           AND CNSMPTN_READ_FL = 'Y'                              
P00795           AND SO_REGISTER_CD <> 'I'                              
P00795           AND CODE_TOU_SEASN = 'C'                               
P00795         ORDER BY REG_ID_NO ASC, CODE_TIME_PERIOD ASC             
P00795         FOR READ ONLY                                           
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE OA-PGM-CAP-CURSOR CURSOR FOR                        
MFA-TR*       SELECT OA.CODE_CAP_TYPE,                                          
MFA-TR*              OA.CODE_USAGE_SOURCE,                                      
MFA-TR*              REG_ID_NO,                                                 
MFA-TR*              CODE_TIME_PERIOD,                                          
MFA-TR*              OA.CODE_USAGE_TYPE,                                        
MFA-TR*              OA.CODE_USAGE_ID,                                          
MFA-TR*              READ_SEQUENCE_NO,                                          
MFA-TR*              MTR_RD_DISP_CD,                                            
MFA-TR*              INDEX_VALUE_CD,                                            
MFA-TR*              NO_READ_DIGITS,                                            
MFA-TR*              NO_READ_DECIMALS,                                          
MFA-TR*              METER_USAGE_DESC                                           
MFA-TR*         FROM CSS_MTR_RD_FMT OA                                          
MFA-TR*             ,CSS_MTR_USAGE_VALS S5                                      
MFA-TR*        WHERE OA.CODE_UTIL_TYPE  = :OA-CODE-UTIL-TYPE                    
MFA-TR*          AND DIGTL_MTR_TYPE  = :OA-DIGTL-MTR-TYPE                       
MFA-TR*          AND PROGRAM_ID      = :OA-PROGRAM-ID                           
MFA-TR*          AND REMOTE_READ_IND = :OA-REMOTE-READ-IND                      
MFA-TR*          AND MTR_READ_SOURCE_CD = :OA-MTR-READ-SOURCE-CD                
MFA-TR*          AND OA.CODE_USAGE_ID = S5.CODE_USAGE_ID                        
MFA-TR*          AND OA.CODE_USAGE_TYPE = S5.CODE_USAGE_TYPE                    
MFA-TR*          AND OA.CODE_USAGE_SOURCE = S5.CODE_USAGE_SOURCE                
MFA-TR*          AND CNSMPTN_READ_FL = 'Y'                                      
MFA-TR*          AND SO_REGISTER_CD <> 'I'                                      
MFA-TR*          AND CODE_TOU_SEASN = 'C'                                       
MFA-TR*        ORDER BY REG_ID_NO ASC, CODE_TIME_PERIOD ASC                     
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
P00795*                                                                         
P00795*     CSS_SO_METER CURSOR.                                                
P00795*                                                                         
P00795     EXEC SQL DECLARE SO-METER-CURSOR CURSOR FOR                  
P00795        SELECT CODE_UTIL_TYPE,                                    
P00795               DIGTL_MTR_TYPE,                                    
P00795               PROGRAM_ID,                                        
P00795               REMOTE_READ_IND,                                   
P00795               MTR_READ_SOURCE_CD,                                
P00795               METER_NO                                           
P00795          FROM CSS_SO_METER VM WITH(READUNCOMMITTED)                      
P00795         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
P00795         FOR READ ONLY                                           
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE SO-METER-CURSOR CURSOR FOR                          
MFA-TR*       SELECT CODE_UTIL_TYPE,                                            
MFA-TR*              DIGTL_MTR_TYPE,                                            
MFA-TR*              PROGRAM_ID,                                                
MFA-TR*              REMOTE_READ_IND,                                           
MFA-TR*              MTR_READ_SOURCE_CD,                                        
MFA-TR*              METER_NO                                                   
MFA-TR*         FROM CSS_SO_METER VM                                            
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            
P00795*                                                                         
P00795*     CSS_MTRD_ENVRNMT CURSOR.                                            
P00795*                                                                         
P00795     EXEC SQL DECLARE MTR-ENV-CURSOR CURSOR FOR                   
P00795        SELECT CODE_UTIL_TYPE,                                    
P00795               DIGTL_MTR_TYPE,                                    
P00795               PROGRAM_ID,                                        
P00795               REMOTE_READ_IND,                                   
P00795               MTR_READ_SOURCE_CD,                                
P00795               METER_NO                                           
P00795          FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
P00795              ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
P00795         WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO               
P00795           AND MN.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR                
P00795         FOR READ ONLY                                           
P00795                                                           
P00795                                                      
P00795     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE MTR-ENV-CURSOR CURSOR FOR                           
MFA-TR*       SELECT CODE_UTIL_TYPE,                                            
MFA-TR*              DIGTL_MTR_TYPE,                                            
MFA-TR*              PROGRAM_ID,                                                
MFA-TR*              REMOTE_READ_IND,                                           
MFA-TR*              MTR_READ_SOURCE_CD,                                        
MFA-TR*              METER_NO                                                   
MFA-TR*         FROM CSS_SO_DATA VO                                             
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO                       
MFA-TR*          AND MN.ACCOUNT_NO = VO.ACCOUNT_NO_PRIOR                        
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1135 CURSOR
MSQ001          FOR CALL CSR01135                                             
                  ( :SERV-ORDER-NO-1135
                  , :HISTORY-FL-1135
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1138 CURSOR
MSQ001          FOR CALL CSR01138                                             
                  ( :SERV-ORDER-NO-1138
                  , :HISTORY-FL-1138
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1182 CURSOR
MSQ001          FOR CALL CSR01182                                             
                  ( :SERV-ORDER-NO-1182
                  , :HISTORY-FL-1182
                  )
MSQ001        END-EXEC.
                                                    
P00795*                                                                         
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SERV-ORDER-NO       PIC X(13).                          
       01  LINK-HISTORY-FL          PIC X(01).                          
       01  LINK-SOURCE-SYSTEM       PIC X(03).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-SERV-ORDER-NO,                    
                                 LINK-HISTORY-FL,                       
                                 LINK-SOURCE-SYSTEM.                    
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
P00795                      S-RETURN-CODE-5                             
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0103-DECLARE-GTT02 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-2 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT03 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-3 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT04 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-4 THRU 8500-EXIT                
P00795         PERFORM 0106-DECLARE-GTT05 THRU 0106-EXIT                
P00795         PERFORM 8600-SEND-RESULT-5 THRU 8600-EXIT                
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED                                
                       WS-GTT04-DECLARED                                
P00795                 WS-GTT05-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04791_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04791_R1
              (                                                          
               RETURN_CODE          INT,                            
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               IC_NO                SMALLINT,                           
               RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RATE_DESC CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,             
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               MTR_REF_NO           SMALLINT,                           
               LAST_MTR_RD_VALUE    DECIMAL(15,3),                      
               CODE_USAGE_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               REGISTER_STATUS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               REG_ID_NO            SMALLINT,                           
               NO_DIALS             SMALLINT,                           
               CONSTANT             DECIMAL(9,3),                       
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               SELECT_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SO_INST_SEQ_NO       SMALLINT,                           
               CODE_TIME_PERIOD     SMALLINT,                           
               CODE_USAGE_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         TASK_STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
P00795         CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         REVENUE_CLASS_DESC CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         GIS_POINT_ID         INT,                            
P00795         METER_PRESSURE       INT,                            
P00795         CODE_METER_LOC CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
P00795         CODE_STATUS_REASON CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
P00795         METER_SUPPLIES CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT1'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04791_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04791_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04791_R2
              (                                                          
               RETURN_CODE          INT,                            
               CODE_UTIL_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
               IC_NO                SMALLINT,                           
               RATE_DESC CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,             
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               MTR_REF_NO           SMALLINT,                           
               LAST_MTR_RD_VALUE    DECIMAL(15,3),                      
               READ_VALUE_IS        DECIMAL(15,3),                      
               LAST_REG_RD_DATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_USAGE_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               METER_STATUS_IS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               METER_STATUS_WS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_STATUS_REA_IS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_STATUS_REA_WS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               REG_ID_NO            SMALLINT,                           
               NO_DIALS             SMALLINT,                           
               CONSTANT             DECIMAL(9,3),                       
               CODE_USAGE_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_TIME_PERIOD     SMALLINT,                           
               CODE_DEST CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               DEST_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,               
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               TABLE_CODE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               SO_INST_SEQ_NO       SMALLINT,                           
               LOCK_TYPE_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
P00795         RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
P00795         CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         REVENUE_CLASS_DESC CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         TASK_STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
P00795         GIS_POINT_ID         INT,                            
P00795         METER_PRESSURE       INT,                            
P00795         CODE_METER_LOC CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
P00795         POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
P00795         METER_SUPPLIES CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT2-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT2'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04791_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0104-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04791_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04791_R3
              (                                                          
               RETURN_CODE          INT,                            
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               IC_NO                SMALLINT,                           
               RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RATE_DESC CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,             
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               MTR_REF_NO           SMALLINT,                           
               LAST_MTR_RD_VALUE    DECIMAL(15,3),                      
               CODE_USAGE_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               REGISTER_STATUS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               REG_ID_NO            SMALLINT,                           
               NO_DIALS             SMALLINT,                           
               CONSTANT             DECIMAL(9,3),                       
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               SELECT_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SO_INST_SEQ_NO       SMALLINT,                           
               CODE_TIME_PERIOD     SMALLINT,                           
               CODE_USAGE_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         CODE_STATUS_REASON CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00795         POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
P00795         CODE_METER_LOC CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
               METER_PRESSURE       INT                             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8004-DELETE-GTT3-ROWS THRU 8004-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0104'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT3'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04791_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0104-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0105-DECLARE-GTT04.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04791_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04791_R4
              (                                                          
               RETURN_CODE          INT,                            
               PROCESS CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2                
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT4-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT4'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04791_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT04-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795 0106-DECLARE-GTT05.                                              
P00795                                                                  
P00795     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04791_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04791_R5
              (                                                          
P00795          RETURN_CODE              INT                        
P00795         ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2              
P00795         ,CODE_USAGE_TYPE CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                       
P00795         ,CODE_USAGE_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00795         ,CODE_USAGE_SOURCE CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                       
P00795         ,CODE_TIME_PERIOD         SMALLINT                       
P00795         ,REGISTER_READ_SEQ        SMALLINT                       
P00795         ,MTR_RD_DISP_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
P00795         ,INDEX_VALUE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00795         ,NO_READ_DIGITS           SMALLINT                       
P00795         ,NO_READ_DECIMALS         SMALLINT                       
P00795         ,METER_USAGE_DESC CHAR(35)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                       
P00795       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLSTATE TO WS-SQLSTATE.                                
P00795     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
P00795                                                                  
P00795     IF WS-SQLSTATE = '42710'                                     
P00795        PERFORM 8005-DELETE-GTT4-ROWS THRU 8005-EXIT              
P00795     ELSE                                                         
P00795         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00795             NEXT SENTENCE                                        
P00795         ELSE                                                     
P00795            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
P00795            MOVE SQLCODE              TO ABEND-SQLCODE            
P00795            MOVE SQLSTATE             TO ABEND-SQLSTATE           
P00795            MOVE '0106'               TO ACTIVE-PARAGRAPH         
P00795            MOVE 'DECLARE GTT5'       TO ABEND-FUNCTION           
P00795            MOVE SPACES               TO ABEND-SQL-PREDICATES     
P00795                                         ABEND-TABLES             
P00795            MOVE 'CSR04791_R5'        TO TABLE-1                  
P00795            MOVE SPACES               TO TABLE-ELEMENT-1          
P00795            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
P00795            PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
P00795     MOVE 'Y' TO WS-GTT05-DECLARED.                               
P00795                                                                  
P00795 0106-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
               MOVE ZEROES TO LINK-SERV-ORDER-NO
           END-IF.                       
           MOVE LINK-SERV-ORDER-NO      TO WS-SERV-ORDER-NO.            
           MOVE WS-SERV-ORDER-NO-NUM       TO VO-SERV-ORDER-NO.         
           MOVE LINK-HISTORY-FL         TO WS-HISTORY-FL.               
           MOVE LINK-SOURCE-SYSTEM      TO WS-SOURCE-SYSTEM.            
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-SERV-ORDER-NO = ZEROES                               
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
P00795                      S-RETURN-CODE-5                             
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0103-DECLARE-GTT02 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-2 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT03 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-3 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT04 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-4 THRU 8500-EXIT                
P00795         PERFORM 0106-DECLARE-GTT05 THRU 0106-EXIT                
P00795         PERFORM 8600-SEND-RESULT-5 THRU 8600-EXIT                
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ORDER-TYPE THRU 7000-EXIT.               
           PERFORM 7010-SELECT-ORDERGRP   THRU 7010-EXIT.               
           PERFORM 7020-CHECK-WORK-TYPE-EXIST THRU 7020-EXIT.           
                                                                        
           IF WS-WORK-TYPE-EXISTS = 'Y'                                 
               PERFORM 5100-CALL-CSR01138 THRU 5100-EXIT                
               PERFORM 5200-CALL-CSR01182 THRU 5200-EXIT                
               MOVE 'MC'                  TO S-PROCESS                  
               MOVE 0                     TO S-RETURN-CODE-4            
           ELSE                                                         
             EVALUATE C2-ORDER-GROUP-CD                                 
               WHEN 'B'                                                 
                  IF VO-ORDER-TYPE-CD = 'MC001'                         
                     PERFORM 5100-CALL-CSR01138 THRU 5100-EXIT          
                     PERFORM 5200-CALL-CSR01182 THRU 5200-EXIT          
                     MOVE 'MC'                  TO S-PROCESS            
                     MOVE 0                     TO S-RETURN-CODE-4      
                  ELSE                                                  
                     PERFORM 5100-CALL-CSR01138 THRU 5100-EXIT          
                     MOVE 'MW'                  TO S-PROCESS            
                     MOVE 0                     TO S-RETURN-CODE-4      
                  END-IF                                                
               WHEN 'C'                                                 
                  PERFORM 5000-CALL-CSR01135 THRU 5000-EXIT             
                  MOVE 'ST'                  TO S-PROCESS               
                  MOVE 0                     TO S-RETURN-CODE-4         
               WHEN 'D'                                                 
                  PERFORM 5100-CALL-CSR01138 THRU 5100-EXIT             
                  IF VO-ORDER-TYPE-CD(1:2) = 'FM' OR                    
                     VO-ORDER-TYPE-CD(1:2) = 'ON'                       
                     MOVE 'MW'               TO S-PROCESS               
                     MOVE 0                  TO S-RETURN-CODE-4         
                  ELSE                                                  
                     MOVE 'CC'               TO S-PROCESS               
                     MOVE 0                  TO S-RETURN-CODE-4         
                  END-IF                                                
               WHEN 'E'                                                 
                  PERFORM 5100-CALL-CSR01138 THRU 5100-EXIT             
                  IF VO-ORDER-TYPE-CD = 'DNPFB'                         
                     MOVE 'CC'               TO S-PROCESS               
                     MOVE 0                  TO S-RETURN-CODE-4         
                  ELSE                                                  
                     MOVE 'MW'               TO S-PROCESS               
                     MOVE 0                  TO S-RETURN-CODE-4         
                  END-IF                                                
               WHEN OTHER                                               
                  PERFORM 5100-CALL-CSR01138 THRU 5100-EXIT             
                  MOVE 'MW'                  TO S-PROCESS               
                  MOVE 0                     TO S-RETURN-CODE-4         
             END-EVALUATE                                               
           END-IF.                                                      
                                                                        
           IF VO-ORDER-TYPE-CD = 'FM008' OR                             
              VO-ORDER-TYPE-CD = 'FW026' OR                             
              C2-ORDER-GROUP-CD = 'A'                                   
              MOVE 'SK'                  TO S-PROCESS                   
              MOVE 0                     TO S-RETURN-CODE-4             
           END-IF                                                       
                                                                        
P00795*    POPULATE REG DETAILS.                                                
P00795     IF WS-SOURCE-SYSTEM = 'CIS'                                  
P00795         PERFORM 2200-PROCESS-REG   THRU 2200-EXIT                
P00795     END-IF                                                       
           IF WS-GTT04-DECLARED = 'N'                                   
               PERFORM 0105-DECLARE-GTT04 THRU 0105-EXIT
           END-IF.               
           PERFORM 8500-SEND-RESULT-4 THRU 8500-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795 2200-PROCESS-REG.                                                
P00795*                                                                         
P00795     PERFORM 7400-OPEN-SO-MTR-CURSOR          THRU 7400-EXIT.     
P00795                                                                  
P00795     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00795                                                                  
P00795        PERFORM 7410-FETCH-SO-METER-CURSOR     THRU 7410-EXIT     
P00795        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00795            MOVE VM-CODE-UTIL-TYPE  TO OA-CODE-UTIL-TYPE          
P00795            MOVE VM-DIGTL-MTR-TYPE  TO OA-DIGTL-MTR-TYPE          
P00795            MOVE VM-PROGRAM-ID      TO OA-PROGRAM-ID              
P00795            MOVE VM-REMOTE-READ-IND TO OA-REMOTE-READ-IND         
P00795            MOVE VM-MTR-READ-SOURCE-CD TO OA-MTR-READ-SOURCE-CD   
P00795            MOVE VM-METER-NO        TO WS-METER-NO-5              
P00795            PERFORM 2400-GET-REG-DETAILS   THRU 2400-EXIT         
P00795            INITIALIZE WS-METER-NO-5                              
P00795        END-IF                                                    
P00795     END-PERFORM.                                                 
P00795                                                                  
P00795     PERFORM 7420-CLOSE-SO-METER-CURSOR        THRU 7420-EXIT.    
P00795*                                                                         
P00795     PERFORM 7500-OPEN-MTR-ENV-CURSOR          THRU 7500-EXIT.    
P00795                                                                  
P00795     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00795                                                                  
P00795        PERFORM 7510-FETCH-METER-ENV-CURSOR     THRU 7510-EXIT    
P00795        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00795            MOVE MN-CODE-UTIL-TYPE  TO OA-CODE-UTIL-TYPE          
P00795            MOVE MN-DIGTL-MTR-TYPE  TO OA-DIGTL-MTR-TYPE          
P00795            MOVE MN-PROGRAM-ID      TO OA-PROGRAM-ID              
P00795            MOVE MN-REMOTE-READ-IND TO OA-REMOTE-READ-IND         
P00795            MOVE MN-MTR-READ-SOURCE-CD TO OA-MTR-READ-SOURCE-CD   
P00795            MOVE MN-METER-NO        TO WS-METER-NO-5              
P00795            PERFORM 2400-GET-REG-DETAILS   THRU 2400-EXIT         
P00795            INITIALIZE WS-METER-NO-5                              
P00795        END-IF                                                    
P00795     END-PERFORM.                                                 
P00795                                                                  
P00795     PERFORM 7520-CLOSE-METER-ENV-CURSOR        THRU 7520-EXIT.   
P00795*                                                                         
P00795                                                                  
P00795 2200-EXIT.                                                       
P00795     EXIT.                                                        
P00795 2400-GET-REG-DETAILS.                                            
P00795*                                                                         
P00795     PERFORM 7100-OPEN-PGM-CAP-CURSOR         THRU 7100-EXIT.     
P00795     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00795               OR WS-DATA-ERROR-FLAG  = WS-YES                    
P00795* PROCESS EACH METER CAPABILITY ROW.                                      
P00795                                                                  
P00795        PERFORM 7200-FETCH-PGM-CAP-CURSOR     THRU 7200-EXIT      
P00795        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00795           INITIALIZE GTT-RETURN-FIELDS-5                         
P00795           IF WS-GTT05-DECLARED = 'N'                             
P00795             PERFORM 0106-DECLARE-GTT05 THRU 0106-EXIT            
P00795           END-IF                                                 
P00795           MOVE OA-CODE-USAGE-TYPE   TO S-CODE-USAGE-TYPE         
P00795           MOVE OA-CODE-USAGE-ID     TO S-CODE-USAGE-ID           
P00795           MOVE OA-CODE-USAGE-SOURCE TO S-CODE-USAGE-SOURCE       
P00795           MOVE OA-CODE-TIME-PERIOD  TO S-CODE-TIME-PERIOD        
P00795           MOVE OA-READ-SEQUENCE-NO  TO S-REGISTER-READ-SEQ       
P00795           MOVE OA-MTR-RD-DISP-CD    TO S-METER-RD-DISP-CD        
P00795           MOVE OA-INDEX-VALUE-CD    TO S-INDEX-VALUE-CD          
P00795           MOVE OA-NO-READ-DIGITS    TO S-NO-READ-DIGITS          
P00795           MOVE OA-NO-READ-DECIMALS  TO S-NO-READ-DECIMALS        
P00795           MOVE S5-METER-USAGE-DESC  TO S-METER-USAGE-DESC        
P00795           PERFORM 8600-SEND-RESULT-5  THRU 8600-EXIT             
P00795        END-IF                                                    
P00795     END-PERFORM.                                                 
P00795                                                                  
P00795     PERFORM 7300-CLOSE-PGM-CAP-CURSOR        THRU 7300-EXIT.     
P00795*                                                                         
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
       5000-CALL-CSR01135.                                              
                                                                        
           MOVE WS-SERV-ORDER-NO TO SERV-ORDER-NO-1135.                 
           MOVE WS-HISTORY-FL    TO HISTORY-FL-1135.                    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01135                                             
      *           (:SERV-ORDER-NO-1135,                                 
      *            :HISTORY-FL-1135)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1135
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1135
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1135 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01135'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-1135    TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1135)                                                
      *       WITH PROCEDURE CSR01135                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1135 CURSOR FOR RESULT SET        
      *       :LOC1135                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1135 INTO                          
                   :CODE-UTIL-TYPE-1135                                 
                  ,:IC-NO-1135                                          
                  ,:RATE-PLAN-NO-1135 :WS-NULL1                          
                  ,:RATE-DESC-1135 :WS-NULL1                             
                  ,:METER-NO-1135                                       
                  ,:MTR-REF-NO-1135                                     
                  ,:LAST-MTR-RD-VALUE-1135                              
                  ,:CODE-USAGE-TYPE-1135                                
                  ,:REGISTER-STATUS-1135                                
                  ,:REG-ID-NO-1135                                      
                  ,:NO-DIALS-1135                                       
                  ,:CONSTANT-1135                                       
                  ,:WORK-TYPE-CD-1135                                   
                  ,:SELECT-TYPE-1135                                    
                  ,:SO-INST-SEQ-NO-1135                                 
                  ,:CODE-TIME-PERIOD-1135                               
                  ,:CODE-USAGE-ID-1135                                  
                  ,:CODE-USAGE-SOURCE-1135                              
P00795            ,:FILLER1-1182                                        
P00795            ,:FILLER2-1182                                        
P00795            ,:FILLER3-1182                                        
P00795            ,:TASK-STATUS-CD-1135                                 
P00795            ,:CODE-REVENUE-CLASS-1135 :WS-NULL1                    
P00795            ,:REVENUE-CLASS-DESC-1135 :WS-NULL1                    
P00795            ,:GIS-POINT-ID-1135                                   
P00795            ,:METER-PRESSURE-1135                                 
P00795            ,:CODE-METER-LOC-1135                                 
P00795            ,:CODE-STATUS-REASON-1135                             
P00795            ,:POINT-ID-1135                                       
P00795            ,:METER-SUPPLIES-1135                                 
                                                                        
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                      PERFORM 5010-PROCESS-1135 THRU 5010-EXIT          
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5000'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR01135'            TO TABLE-1              
                     MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1      
                     MOVE SERV-ORDER-NO-1135    TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y' TO SW-FETCH.                                        
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5010-PROCESS-1135.                                               
                                                                        
           IF WS-GTT01-DECLARED = 'N'                                   
              PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                 
           END-IF.                                                      
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE GIS-POINT-ID-1135       TO PP-POINT-ID.                 
           MOVE SPACES                  TO WS-POINT-ID.                 
           IF GIS-POINT-ID-1135 > 0                                     
              PERFORM 7600-GET-PIMPOINT    THRU 7600-EXIT               
           END-IF.                                                      
           MOVE WS-POINT-ID            TO S-POINT-ID-1.                 
           MOVE 0                      TO S-RETURN-CODE-1.              
           MOVE CODE-UTIL-TYPE-1135    TO S-CODE-UTIL-TYPE-1.           
           MOVE IC-NO-1135             TO S-IC-NO-1.                    
           MOVE RATE-PLAN-NO-1135      TO S-RATE-PLAN-NO-1.             
           MOVE RATE-DESC-1135         TO S-RATE-DESC-1.                
           MOVE METER-NO-1135          TO S-METER-NO-1.                 
           MOVE MTR-REF-NO-1135        TO S-MTR-REF-NO-1.               
           MOVE LAST-MTR-RD-VALUE-1135 TO S-LAST-MTR-RD-VALUE-1.        
           MOVE CODE-USAGE-TYPE-1135   TO S-CODE-USAGE-TYPE-1.          
           MOVE REGISTER-STATUS-1135   TO S-REG-STATUS-1.               
           MOVE REG-ID-NO-1135         TO S-REG-ID-NO-1.                
           MOVE NO-DIALS-1135          TO S-NO-DIALS-1.                 
           MOVE CONSTANT-1135          TO S-CONSTANT-1.                 
           MOVE WORK-TYPE-CD-1135      TO S-WORK-TYPE-CD-1.             
           MOVE SELECT-TYPE-1135       TO S-SELECT-TYPE-1.              
           MOVE SO-INST-SEQ-NO-1135    TO S-SO-INST-SEQ-NO-1.           
           MOVE CODE-TIME-PERIOD-1135  TO S-CODE-TIME-PERIOD-1.         
           MOVE CODE-USAGE-ID-1135     TO S-CODE-USAGE-ID-1.            
           MOVE CODE-USAGE-SOURCE-1135 TO S-CODE-USAGE-SOURCE-1.        
P00795     MOVE TASK-STATUS-CD-1135    TO S-TASK-STATUS-CD-1.           
P00795     MOVE CODE-REVENUE-CLASS-1135 TO S-CODE-REVENUE-CLASS-1.      
P00795     MOVE REVENUE-CLASS-DESC-1135 TO S-REVENUE-CLASS-DESC-1.      
P00795     MOVE GIS-POINT-ID-1135      TO S-GIS-POINT-ID-1.             
P00795     MOVE METER-PRESSURE-1135    TO S-METER-PRESSURE-1.           
P00795     MOVE CODE-METER-LOC-1135    TO S-CODE-METER-LOC-1.           
P00795     MOVE CODE-STATUS-REASON-1135 TO S-CODE-STATUS-REASON-1.      
P00795     MOVE POINT-ID-1135          TO S-POINT-ID-1.                 
P00795     MOVE METER-SUPPLIES-1135    TO S-METER-SUPPLIES-1.           
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5100-CALL-CSR01138.                                              
                                                                        
           MOVE WS-SERV-ORDER-NO TO SERV-ORDER-NO-1138.                 
           MOVE WS-HISTORY-FL    TO HISTORY-FL-1138.                    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01138                                             
      *           (:SERV-ORDER-NO-1138,                                 
      *            :HISTORY-FL-1138)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1138
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1138
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1138 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01138'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-1138    TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1138)                                                
      *       WITH PROCEDURE CSR01138                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1138 CURSOR FOR RESULT SET        
      *       :LOC1138                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1138 INTO                          
                   :CODE-UTIL-TYPE-1138                                 
                  ,:IC-NO-1138                                          
                  ,:RATE-DESC-1138                                      
                  ,:METER-NO-1138                                       
                  ,:MTR-REF-NO-1138                                     
                  ,:LAST-MTR-RD-VALUE-1138                              
                  ,:READ-VALUE-IS-1138                                  
                  ,:LAST-REG-RD-DATE-1138                               
                  ,:CODE-USAGE-TYPE-1138                                
                  ,:METER-STATUS-IS-1138                                
                  ,:METER-STATUS-WS-1138                                
                  ,:CODE-STATUS-REA-IS-1138                             
                  ,:CODE-STATUS-REA-WS-1138                             
                  ,:REG-ID-NO-1138                                      
                  ,:NO-DIALS-1138                                       
                  ,:CONSTANT-1138                                       
                  ,:CODE-USAGE-ID-1138                                  
                  ,:CODE-USAGE-SOURCE-1138                              
                  ,:CODE-TIME-PERIOD-1138                               
                  ,:CODE-DEST-1138                                      
                  ,:DEST-NO-1138                                        
                  ,:WORK-TYPE-CD-1138                                   
                  ,:TABLE-CODE-1138                                     
                  ,:SO-INST-SEQ-NO-1138                                 
                  ,:LOCK-TYPE-ID-1138                                   
                  ,:DUMMY-DATA                                          
P00795            ,:FILLER1-1138                                        
P00795            ,:FILLER2-1138                                        
P00795            ,:FILLER3-1138                                        
P00795            ,:FILLER4-1138                                        
P00795            ,:RATE-PLAN-NO-1138                                   
P00795            ,:CODE-REVENUE-CLASS-1138                             
P00795            ,:REVENUE-CLASS-DESC-1138                             
P00795            ,:TASK-STATUS-CD-1138                                 
P00795            ,:GIS-POINT-ID-1138                                   
P00795            ,:METER-PRESSURE-1138                                 
P00795            ,:CODE-METER-LOC-1138                                 
P00795            ,:POINT-ID-1138                                       
P00795            ,:METER-SUPPLIES-1138                                 
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     PERFORM 5110-PROCESS-1138 THRU 5110-EXIT           
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME          TO ABEND-PROGRAM      
                       MOVE '5100'                TO ACTIVE-PARAGRAPH   
                       MOVE 'FETCH'               TO ABEND-FUNCTION     
                       MOVE 'CSR01138'           TO TABLE-1             
                       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1    
                       MOVE SERV-ORDER-NO-1138    TO HOSTVAR-ELEMENT-1  
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
               END-EVALUATE                                             
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5110-PROCESS-1138.                                               
                                                                        
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT02 THRU 0103-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE GIS-POINT-ID-1138       TO PP-POINT-ID.                 
           MOVE SPACES                  TO WS-POINT-ID.                 
           IF GIS-POINT-ID-1138 > 0                                     
              PERFORM 7600-GET-PIMPOINT    THRU 7600-EXIT               
           END-IF.                                                      
           MOVE WS-POINT-ID            TO S-POINT-ID-2.                 
           MOVE 0 TO S-RETURN-CODE-2.                                   
           MOVE CODE-UTIL-TYPE-1138     TO S-CODE-UTIL-TYPE-2.          
           MOVE IC-NO-1138              TO S-IC-NO-2.                   
           MOVE RATE-DESC-1138          TO S-RATE-DESC-2.               
           MOVE METER-NO-1138           TO S-METER-NO-2.                
           MOVE MTR-REF-NO-1138         TO S-MTR-REF-NO-2.              
           MOVE LAST-MTR-RD-VALUE-1138  TO S-LAST-MTR-RD-VALUE-2.       
           MOVE READ-VALUE-IS-1138      TO S-READ-VALUE-IS-2.           
           MOVE LAST-REG-RD-DATE-1138   TO S-LAST-REG-RD-DATE-2.        
           MOVE CODE-USAGE-TYPE-1138    TO S-CODE-USAGE-TYPE-2.         
           MOVE METER-STATUS-IS-1138    TO S-METER-STATUS-IS-2.         
           MOVE METER-STATUS-WS-1138    TO S-METER-STATUS-WS-2.         
           MOVE CODE-STATUS-REA-IS-1138 TO S-CODE-STATUS-REA-IS-2.      
           MOVE CODE-STATUS-REA-WS-1138 TO S-CODE-STATUS-REA-WS-2.      
           MOVE REG-ID-NO-1138          TO S-REG-ID-NO-2.               
           MOVE NO-DIALS-1138           TO S-NO-DIALS-2.                
           MOVE CONSTANT-1138           TO S-CONSTANT-2.                
           MOVE CODE-USAGE-ID-1138      TO S-CODE-USAGE-ID-2.           
           MOVE CODE-USAGE-SOURCE-1138  TO S-CODE-USAGE-SOURCE-2.       
           MOVE CODE-TIME-PERIOD-1138   TO S-CODE-TIME-PERIOD-2.        
           MOVE CODE-DEST-1138          TO S-CODE-DEST-2.               
           MOVE DEST-NO-1138            TO S-DEST-NO-2.                 
           MOVE WORK-TYPE-CD-1138       TO S-WORK-TYPE-CD-2.            
           MOVE TABLE-CODE-1138         TO S-TABLE-CODE-2.              
           MOVE SO-INST-SEQ-NO-1138     TO S-SO-INST-SEQ-NO-2.          
           MOVE LOCK-TYPE-ID-1138       TO S-LOCK-TYPE-ID-2.            
P00795     MOVE RATE-PLAN-NO-1138       TO S-RATE-PLAN-NO-2.            
P00795     MOVE CODE-REVENUE-CLASS-1138 TO S-CODE-REVENUE-CLASS-2.      
P00795     MOVE REVENUE-CLASS-DESC-1138 TO S-REVENUE-CLASS-DESC-2.      
P00795     MOVE TASK-STATUS-CD-1138     TO S-TASK-STATUS-CD-2.          
P00795     MOVE GIS-POINT-ID-1138       TO S-GIS-POINT-ID-2.            
P00795     MOVE METER-PRESSURE-1138     TO S-METER-PRESSURE-2.          
P00795     MOVE CODE-METER-LOC-1138     TO S-CODE-METER-LOC-2.          
P00795     MOVE METER-SUPPLIES-1138     TO S-METER-SUPPLIES-2.          
           PERFORM 8300-SEND-RESULT-2 THRU 8300-EXIT.                   
                                                                        
       5110-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       5200-CALL-CSR01182.                                              
                                                                        
           MOVE WS-SERV-ORDER-NO TO SERV-ORDER-NO-1182.                 
           MOVE WS-HISTORY-FL    TO HISTORY-FL-1182.                    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01182                                             
      *           (:SERV-ORDER-NO-1182,                                 
      *            :HISTORY-FL-1182)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1182
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1182
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1182 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01182'            TO TABLE-1                     
              MOVE 'SEV_ORDER_NO'        TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-1182    TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1182)                                                
      *       WITH PROCEDURE CSR01182                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1182 CURSOR FOR RESULT SET        
      *       :LOC1182                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1182 INTO                          
                   :CODE-UTIL-TYPE-1182                                 
                  ,:IC-NO-1182                                          
                  ,:RATE-PLAN-NO-1182                                   
                  ,:RATE-DESC-1182                                      
                  ,:METER-NO-1182                                       
                  ,:MTR-REF-NO-1182                                     
                  ,:LAST-MTR-RD-VALUE-1182                              
                  ,:CODE-USAGE-TYPE-1182                                
                  ,:REGISTER-STATUS-1182                                
                  ,:REG-ID-NO-1182                                      
                  ,:NO-DIALS-1182                                       
                  ,:CONSTANT-1182                                       
                  ,:WORK-TYPE-CD-1182                                   
                  ,:SELECT-TYPE-1182                                    
                  ,:SO-INST-SEQ-NO-1182                                 
                  ,:CODE-TIME-PERIOD-1182                               
                  ,:CODE-USAGE-ID-1182                                  
                  ,:CODE-USAGE-SOURCE-1182                              
P00795            ,:FILLER1-1182                                        
P00795            ,:FILLER2-1182                                        
P00795            ,:FILLER3-1182                                        
P00795            ,:FILLER4-1182                                        
P00795            ,:CODE-STATUS-REASON-1182                             
P00795            ,:GIS-POINT-ID-1182                                   
P00795            ,:CODE-METER-LOC-1182                                 
                  ,:METER-PRESSURE-1182                                 
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    PERFORM 5210-PROCESS-1182 THRU 5210-EXIT            
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR01182'            TO TABLE-1              
                     MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1      
                     MOVE SERV-ORDER-NO-1182    TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5210-PROCESS-1182.                                               
                                                                        
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0104-DECLARE-GTT03 THRU 0104-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           MOVE 0                      TO S-RETURN-CODE-3.              
           MOVE GIS-POINT-ID-1182       TO PP-POINT-ID.                 
           MOVE SPACES                  TO WS-POINT-ID.                 
           IF GIS-POINT-ID-1182 > 0                                     
              PERFORM 7600-GET-PIMPOINT    THRU 7600-EXIT               
           END-IF.                                                      
           MOVE WS-POINT-ID            TO S-POINT-ID-3.                 
           MOVE CODE-UTIL-TYPE-1182    TO S-CODE-UTIL-TYPE-3.           
           MOVE IC-NO-1182             TO S-IC-NO-3.                    
           MOVE RATE-PLAN-NO-1182      TO S-RATE-PLAN-NO-3.             
           MOVE RATE-DESC-1182         TO S-RATE-DESC-3.                
           MOVE METER-NO-1182          TO S-METER-NO-3.                 
           MOVE MTR-REF-NO-1182        TO S-MTR-REF-NO-3.               
           MOVE LAST-MTR-RD-VALUE-1182 TO S-LAST-MTR-RD-VALUE-3.        
           MOVE CODE-USAGE-TYPE-1182   TO S-CODE-USAGE-TYPE-3.          
           MOVE REGISTER-STATUS-1182   TO S-REG-STATUS-3.               
           MOVE REG-ID-NO-1182         TO S-REG-ID-NO-3.                
           MOVE NO-DIALS-1182          TO S-NO-DIALS-3.                 
           MOVE CONSTANT-1182          TO S-CONSTANT-3.                 
           MOVE WORK-TYPE-CD-1182      TO S-WORK-TYPE-CD-3.             
           MOVE SELECT-TYPE-1182       TO S-SELECT-TYPE-3.              
           MOVE SO-INST-SEQ-NO-1182    TO S-SO-INST-SEQ-NO-3.           
           MOVE CODE-TIME-PERIOD-1182  TO S-CODE-TIME-PERIOD-3.         
           MOVE CODE-USAGE-ID-1182     TO S-CODE-USAGE-ID-3.            
           MOVE CODE-USAGE-SOURCE-1182 TO S-CODE-USAGE-SOURCE-3.        
P00795     MOVE CODE-STATUS-REASON-1182 TO S-CODE-STATUS-REASON-3.      
P00795     MOVE CODE-METER-LOC-1182     TO S-CODE-METER-LOC-3.          
P00795     MOVE METER-PRESSURE-1182     TO S-METER-PRESSURE-3.          
           PERFORM 8400-SEND-RESULT-3 THRU 8400-EXIT.                   
                                                                        
       5210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-ORDER-TYPE.                                          
                                                                        
           IF WS-HISTORY-FL = 'H'                                       
             EXEC SQL                                                   
                SELECT ORDER_TYPE_CD,                                   
                       COMPANY_NO                                       
                  INTO :VO-ORDER-TYPE-CD                                
                      ,:VO-COMPANY-NO                                   
                  FROM HST_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                                                                 
                                                            
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT ORDER_TYPE_CD,                                           
MFA-TR*                COMPANY_NO                                               
MFA-TR*           INTO :VO-ORDER-TYPE-CD                                        
MFA-TR*               ,:VO-COMPANY-NO                                           
MFA-TR*           FROM HST_SO_DATA                                              
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           ELSE                                                         
             EXEC SQL                                                   
                SELECT ORDER_TYPE_CD,                                   
                       COMPANY_NO                                       
                  INTO :VO-ORDER-TYPE-CD                                
                      ,:VO-COMPANY-NO                                   
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                                                                 
                                                            
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT ORDER_TYPE_CD,                                           
MFA-TR*                COMPANY_NO                                               
MFA-TR*           INTO :VO-ORDER-TYPE-CD                                        
MFA-TR*               ,:VO-COMPANY-NO                                           
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           END-IF.                                                      
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-ORDERGRP.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ORDER_GROUP_CD                                     
                INTO :C2-ORDER-GROUP-CD                                 
                FROM CSS_ORDER_TYPE WITH(READUNCOMMITTED)                       
               WHERE ORDER_TYPE_CD = :VO-ORDER-TYPE-CD                  
                 AND COMPANY_NO = :VO-COMPANY-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ORDER_GROUP_CD                                             
MFA-TR*         INTO :C2-ORDER-GROUP-CD                                         
MFA-TR*         FROM CSS_ORDER_TYPE                                             
MFA-TR*        WHERE ORDER_TYPE_CD = :VO-ORDER-TYPE-CD                          
MFA-TR*          AND COMPANY_NO = :VO-COMPANY-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ORDER_TYPE'    TO TABLE-1                  
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-1          
                   MOVE VO-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-1        
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-COMPANY-NO       TO HOSTVAR-ELEMENT-2        
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-2          
                   MOVE WS-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CHECK-WORK-TYPE-EXIST.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-WORK-TYPE-EXISTS                               
                FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                    
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                 AND WORK_TYPE_CD IN ('MCU', 'MCB')                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-WORK-TYPE-EXISTS                                       
MFA-TR*         FROM CSS_SO_ORDER_INST                                          
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                          
MFA-TR*          AND WORK_TYPE_CD IN ('MCU', 'MCB')                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
P00795*                                                                         
P00795*****************************************************************         
P00795* 7100-OPEN-PGM-CAP-CURSOR.                                     *         
P00795*    OPEN THE DIGITAL METER'S PROGRAM ID CURSOR.                *         
P00795*                                                               *         
P00795*    CALLED BY: 2200-BUILD-RESULT.                              *         
P00795******************************************************************        
P00795 7100-OPEN-PGM-CAP-CURSOR.                                        
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        OPEN OA-PGM-CAP-CURSOR                                    
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7100'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'OPEN'                     TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_MTR_RD_FMT'           TO TABLE-1                
P00795        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
P00795        MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
P00795        MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
P00795        MOVE 'METER_NO'                 TO TABLE-ELEMENT-4        
P00795        MOVE OA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00795        MOVE OA-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
P00795        MOVE OA-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
P00795        MOVE WS-METER-NO-5               TO HOSTVAR-ELEMENT-4     
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7100-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795******************************************************************        
P00795* 7200-FETCH-PGM-CAP-CURSOR.                                     *        
P00795*     FETCH THE DIGITAL METER'S PROGRAM ID CAPABILITIES.         *        
P00795*                                                                *        
P00795*     CALLED BY: 5000-PROCESS-PGM-CAP-CURSOR.                    *        
P00795******************************************************************        
P00795 7200-FETCH-PGM-CAP-CURSOR.                                       
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        FETCH OA-PGM-CAP-CURSOR                                   
P00795         INTO :OA-CODE-CAP-TYPE,                                  
P00795              :OA-CODE-USAGE-SOURCE,                              
P00795              :OA-REG-ID-NO,                                      
P00795              :OA-CODE-TIME-PERIOD,                               
P00795              :OA-CODE-USAGE-TYPE,                                
P00795              :OA-CODE-USAGE-ID,                                  
P00795              :OA-READ-SEQUENCE-NO,                               
P00795              :OA-MTR-RD-DISP-CD,                                 
P00795              :OA-INDEX-VALUE-CD,                                 
P00795              :OA-NO-READ-DIGITS,                                 
P00795              :OA-NO-READ-DECIMALS,                               
P00795              :S5-METER-USAGE-DESC                                
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7200'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'FETCH'                    TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_MTR_RD_FMT '           TO TABLE-1               
P00795        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
P00795        MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
P00795        MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
P00795        MOVE 'METER_NO'                 TO TABLE-ELEMENT-4        
P00795        MOVE OA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00795        MOVE OA-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
P00795        MOVE OA-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
P00795        MOVE WS-METER-NO-5               TO HOSTVAR-ELEMENT-4     
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7200-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795*****************************************************************         
P00795* 7300-CLOSE-PGM-CAP-CURSOR.                                     *        
P00795*     CLOSE THE DIGITAL METER'S PROGRAM ID CURSOR.               *        
P00795*                                                                *        
P00795*     CALLED BY: 2200-BUILD-RESULT.                              *        
P00795******************************************************************        
P00795 7300-CLOSE-PGM-CAP-CURSOR.                                       
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        CLOSE OA-PGM-CAP-CURSOR                                   
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7300'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_MTR_RD_FMT'           TO TABLE-1                
P00795        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
P00795        MOVE 'DIGTL_MTR_TYPE'           TO TABLE-ELEMENT-2        
P00795        MOVE 'PROGRAM_ID'               TO TABLE-ELEMENT-3        
P00795        MOVE 'METER_NO'                 TO TABLE-ELEMENT-4        
P00795        MOVE OA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00795        MOVE OA-DIGTL-MTR-TYPE          TO HOSTVAR-ELEMENT-2      
P00795        MOVE OA-PROGRAM-ID              TO HOSTVAR-ELEMENT-3      
P00795        MOVE WS-METER-NO-5               TO HOSTVAR-ELEMENT-4     
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7300-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795*                                                                         
P00795******************************************************************        
P00795* 7400-OPEN-SO-MTR-CURSOR.                                       *        
P00795*     OPEN THE SO METER CURSOR.                                  *        
P00795*                                                                *        
P00795*     CALLED BY: 2200-BUILD-RESULT.                              *        
P00795******************************************************************        
P00795 7400-OPEN-SO-MTR-CURSOR.                                         
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        OPEN SO-METER-CURSOR                                      
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7400'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'OPEN'                     TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                            ABEND-TABLES          
P00795        MOVE 'CSS_SO_METER'             TO TABLE-1                
P00795        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00795        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7400-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795******************************************************************        
P00795* 7410-FETCH-SO-METER-CURSOR.                                    *        
P00795*     FETCH THE DIGITAL METER'S PROGRAM ID CAPABILITIES.         *        
P00795*                                                                *        
P00795******************************************************************        
P00795 7410-FETCH-SO-METER-CURSOR.                                      
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        FETCH SO-METER-CURSOR                                     
P00795         INTO :VM-CODE-UTIL-TYPE,                                 
P00795              :VM-DIGTL-MTR-TYPE,                                 
P00795              :VM-PROGRAM-ID,                                     
P00795              :VM-REMOTE-READ-IND,                                
P00795              :VM-MTR-READ-SOURCE-CD,                             
P00795              :VM-METER-NO                                        
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7410'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'FETCH'                    TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_SO_METER'             TO TABLE-1                
P00795        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00795        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7410-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795*****************************************************************         
P00795* 7420-CLOSE-SO-METE-CURSOR.                                     *        
P00795*     CLOSE THE SO METER CURSOR.               *                          
P00795*                                                                *        
P00795******************************************************************        
P00795 7420-CLOSE-SO-METER-CURSOR.                                      
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        CLOSE SO-METER-CURSOR                                     
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7300'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_SO_METER'             TO TABLE-1                
P00795        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00795        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7420-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795*                                                                         
P00795******************************************************************        
P00795* 7500-OPEN-MTR-ENV-CURSOR.                                      *        
P00795*     OPEN THE METER ENV  CURSOR.                                *        
P00795*                                                                *        
P00795******************************************************************        
P00795 7500-OPEN-MTR-ENV-CURSOR.                                        
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        OPEN MTR-ENV-CURSOR                                       
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7500'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'OPEN'                     TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                            ABEND-TABLES          
P00795        MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
P00795        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00795        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7500-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795******************************************************************        
P00795* 7510-FETCH-METER-ENV-CURSOR.                                   *        
P00795*     FETCH THE METER ENV CURSOR                                 *        
P00795*                                                                *        
P00795******************************************************************        
P00795 7510-FETCH-METER-ENV-CURSOR.                                     
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        FETCH MTR-ENV-CURSOR                                      
P00795         INTO :MN-CODE-UTIL-TYPE,                                 
P00795              :MN-DIGTL-MTR-TYPE,                                 
P00795              :MN-PROGRAM-ID,                                     
P00795              :MN-REMOTE-READ-IND,                                
P00795              :MN-MTR-READ-SOURCE-CD,                             
P00795              :MN-METER-NO                                        
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7510'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'FETCH'                    TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
P00795        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00795        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7510-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795*****************************************************************         
P00795* 7520-CLOSE-METER-ENV-CURSOR.                                   *        
P00795*     CLOSE THE METER ENV CURSOR.                                *        
P00795*                                                                *        
P00795******************************************************************        
P00795 7520-CLOSE-METER-ENV-CURSOR.                                     
P00795                                                                  
P00795     EXEC SQL                                                     
P00795        CLOSE MTR-ENV-CURSOR                                      
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7520'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
P00795        MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
P00795        MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1      
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7520-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795*****************************************************************         
P00795* 7600-GET-PIMPONT.                                              *        
P00795*     GET POINT ID FROM PIM POINT TABLE                          *        
P00795*                                                                *        
P00795******************************************************************        
P00795 7600-GET-PIMPOINT.                                               
P00795                                                                  
P00795     EXEC SQL                                                     
P00795         SELECT TOP(1) AREA_ID + TAG_NM                                 
P00795           INTO :WS-POINT-ID                                      
P00795           FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                       
P00795          WHERE POINT_ID = :PP-POINT-ID                           
P00795                                           
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AREA_ID || TAG_NM                                         
MFA-TR*          INTO :WS-POINT-ID                                              
MFA-TR*          FROM CSS_PIM_POINT                                             
MFA-TR*         WHERE POINT_ID = :PP-POINT-ID                                   
MFA-TR*     FETCH FIRST 1 ROWS ONLY                                             
MFA-TR*     WITH UR                                                             
MFA-TR*     QUERYNO 7600                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00795        MOVE '7520'                     TO ACTIVE-PARAGRAPH       
P00795        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
P00795        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00795                                           ABEND-TABLES           
P00795        MOVE 'CSS_PIM_POINT'            TO TABLE-1                
P00795        MOVE 'POINT_ID'                 TO TABLE-ELEMENT-1        
P00795        MOVE PP-POINT-ID                TO HOSTVAR-ELEMENT-1      
P00795        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00795     END-IF.                                                      
P00795                                                                  
P00795 7600-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04791_R1                            
             (                                                          
               RETURN_CODE,                                             
               CODE_UTIL_TYPE,                                          
               IC_NO,                                                   
               RATE_PLAN_NO,                                            
               RATE_DESC,                                               
               METER_NO,                                                
               MTR_REF_NO,                                              
               LAST_MTR_RD_VALUE,                                       
               CODE_USAGE_TYPE,                                         
               REGISTER_STATUS,                                         
               REG_ID_NO,                                               
               NO_DIALS,                                                
               CONSTANT,                                                
               WORK_TYPE_CD,                                            
               SELECT_TYPE,                                             
               SO_INST_SEQ_NO,                                          
               CODE_TIME_PERIOD,                                        
               CODE_USAGE_ID,                                           
               CODE_USAGE_SOURCE,                                       
P00795         TASK_STATUS_CD,                                          
P00795         CODE_REVENUE_CLASS,                                      
P00795         REVENUE_CLASS_DESC,                                      
P00795         GIS_POINT_ID,                                            
P00795         METER_PRESSURE,                                          
P00795         CODE_METER_LOC,                                          
P00795         CODE_STATUS_REASON,                                      
P00795         POINT_ID,                                                
P00795         METER_SUPPLIES                                           
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1                                         
              ,:S-CODE-UTIL-TYPE-1                                      
              ,:S-IC-NO-1                                               
              ,:S-RATE-PLAN-NO-1                                        
              ,:S-RATE-DESC-1                                           
              ,:S-METER-NO-1                                            
              ,:S-MTR-REF-NO-1                                          
              ,:S-LAST-MTR-RD-VALUE-1                                   
              ,:S-CODE-USAGE-TYPE-1                                     
              ,:S-REG-STATUS-1                                          
              ,:S-REG-ID-NO-1                                           
              ,:S-NO-DIALS-1                                            
              ,:S-CONSTANT-1                                            
              ,:S-WORK-TYPE-CD-1                                        
              ,:S-SELECT-TYPE-1                                         
              ,:S-SO-INST-SEQ-NO-1                                      
              ,:S-CODE-TIME-PERIOD-1                                    
              ,:S-CODE-USAGE-ID-1                                       
              ,:S-CODE-USAGE-SOURCE-1                                   
P00795        ,:S-TASK-STATUS-CD-1                                      
P00795        ,:S-CODE-REVENUE-CLASS-1                                  
P00795        ,:S-REVENUE-CLASS-DESC-1                                  
P00795        ,:S-GIS-POINT-ID-1                                        
P00795        ,:S-METER-PRESSURE-1                                      
P00795        ,:S-CODE-METER-LOC-1                                      
P00795        ,:S-CODE-STATUS-REASON-1                                  
P00795        ,:S-POINT-ID-1                                            
P00795        ,:S-METER-SUPPLIES-1                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04791_R1                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        CODE_UTIL_TYPE,                                                  
MFA-TR*        IC_NO,                                                           
MFA-TR*        RATE_PLAN_NO,                                                    
MFA-TR*        RATE_DESC,                                                       
MFA-TR*        METER_NO,                                                        
MFA-TR*        MTR_REF_NO,                                                      
MFA-TR*        LAST_MTR_RD_VALUE,                                               
MFA-TR*        CODE_USAGE_TYPE,                                                 
MFA-TR*        REGISTER_STATUS,                                                 
MFA-TR*        REG_ID_NO,                                                       
MFA-TR*        NO_DIALS,                                                        
MFA-TR*        CONSTANT,                                                        
MFA-TR*        WORK_TYPE_CD,                                                    
MFA-TR*        SELECT_TYPE,                                                     
MFA-TR*        SO_INST_SEQ_NO,                                                  
MFA-TR*        CODE_TIME_PERIOD,                                                
MFA-TR*        CODE_USAGE_ID,                                                   
MFA-TR*        CODE_USAGE_SOURCE,                                               
MFA-TR*        TASK_STATUS_CD,                                                  
MFA-TR*        CODE_REVENUE_CLASS,                                              
MFA-TR*        REVENUE_CLASS_DESC,                                              
MFA-TR*        GIS_POINT_ID,                                                    
MFA-TR*        METER_PRESSURE,                                                  
MFA-TR*        CODE_METER_LOC,                                                  
MFA-TR*        CODE_STATUS_REASON,                                              
MFA-TR*        POINT_ID,                                                        
MFA-TR*        METER_SUPPLIES                                                   
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1                                                 
MFA-TR*       ,:S-CODE-UTIL-TYPE-1                                              
MFA-TR*       ,:S-IC-NO-1                                                       
MFA-TR*       ,:S-RATE-PLAN-NO-1                                                
MFA-TR*       ,:S-RATE-DESC-1                                                   
MFA-TR*       ,:S-METER-NO-1                                                    
MFA-TR*       ,:S-MTR-REF-NO-1                                                  
MFA-TR*       ,:S-LAST-MTR-RD-VALUE-1                                           
MFA-TR*       ,:S-CODE-USAGE-TYPE-1                                             
MFA-TR*       ,:S-REG-STATUS-1                                                  
MFA-TR*       ,:S-REG-ID-NO-1                                                   
MFA-TR*       ,:S-NO-DIALS-1                                                    
MFA-TR*       ,:S-CONSTANT-1                                                    
MFA-TR*       ,:S-WORK-TYPE-CD-1                                                
MFA-TR*       ,:S-SELECT-TYPE-1                                                 
MFA-TR*       ,:S-SO-INST-SEQ-NO-1                                              
MFA-TR*       ,:S-CODE-TIME-PERIOD-1                                            
MFA-TR*       ,:S-CODE-USAGE-ID-1                                               
MFA-TR*       ,:S-CODE-USAGE-SOURCE-1                                           
MFA-TR*       ,:S-TASK-STATUS-CD-1                                              
MFA-TR*       ,:S-CODE-REVENUE-CLASS-1                                          
MFA-TR*       ,:S-REVENUE-CLASS-DESC-1                                          
MFA-TR*       ,:S-GIS-POINT-ID-1                                                
MFA-TR*       ,:S-METER-PRESSURE-1                                              
MFA-TR*       ,:S-CODE-METER-LOC-1                                              
MFA-TR*       ,:S-CODE-STATUS-REASON-1                                          
MFA-TR*       ,:S-POINT-ID-1                                                    
MFA-TR*       ,:S-METER-SUPPLIES-1                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -204           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04791_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04791_R2                            
             (                                                          
              RETURN_CODE                                               
             ,CODE_UTIL_TYPE                                            
             ,IC_NO                                                     
             ,RATE_DESC                                                 
             ,METER_NO                                                  
             ,MTR_REF_NO                                                
             ,LAST_MTR_RD_VALUE                                         
             ,READ_VALUE_IS                                             
             ,LAST_REG_RD_DATE                                          
             ,CODE_USAGE_TYPE                                           
             ,METER_STATUS_IS                                           
             ,METER_STATUS_WS                                           
             ,CODE_STATUS_REA_IS                                        
             ,CODE_STATUS_REA_WS                                        
             ,REG_ID_NO                                                 
             ,NO_DIALS                                                  
             ,CONSTANT                                                  
             ,CODE_USAGE_ID                                             
             ,CODE_USAGE_SOURCE                                         
             ,CODE_TIME_PERIOD                                          
             ,CODE_DEST                                                 
             ,DEST_NO                                                   
             ,WORK_TYPE_CD                                              
             ,TABLE_CODE                                                
             ,SO_INST_SEQ_NO                                            
             ,LOCK_TYPE_ID                                              
P00795       ,RATE_PLAN_NO                                              
P00795       ,CODE_REVENUE_CLASS                                        
P00795       ,REVENUE_CLASS_DESC                                        
P00795       ,TASK_STATUS_CD                                            
P00795       ,GIS_POINT_ID                                              
P00795       ,METER_PRESSURE                                            
P00795       ,CODE_METER_LOC                                            
P00795       ,POINT_ID                                                  
P00795       ,METER_SUPPLIES                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2                                         
              ,:S-CODE-UTIL-TYPE-2                                      
              ,:S-IC-NO-2                                               
              ,:S-RATE-DESC-2                                           
              ,:S-METER-NO-2                                            
              ,:S-MTR-REF-NO-2                                          
              ,:S-LAST-MTR-RD-VALUE-2                                   
              ,:S-READ-VALUE-IS-2                                       
              ,:S-LAST-REG-RD-DATE-2                                    
              ,:S-CODE-USAGE-TYPE-2                                     
              ,:S-METER-STATUS-IS-2                                     
              ,:S-METER-STATUS-WS-2                                     
              ,:S-CODE-STATUS-REA-IS-2                                  
              ,:S-CODE-STATUS-REA-WS-2                                  
              ,:S-REG-ID-NO-2                                           
              ,:S-NO-DIALS-2                                            
              ,:S-CONSTANT-2                                            
              ,:S-CODE-USAGE-ID-2                                       
              ,:S-CODE-USAGE-SOURCE-2                                   
              ,:S-CODE-TIME-PERIOD-2                                    
              ,:S-CODE-DEST-2                                           
              ,:S-DEST-NO-2                                             
              ,:S-WORK-TYPE-CD-2                                        
              ,:S-TABLE-CODE-2                                          
              ,:S-SO-INST-SEQ-NO-2                                      
              ,:S-LOCK-TYPE-ID-2                                        
P00795        ,:S-RATE-PLAN-NO-2                                        
P00795        ,:S-CODE-REVENUE-CLASS-2                                  
P00795        ,:S-REVENUE-CLASS-DESC-2                                  
P00795        ,:S-TASK-STATUS-CD-2                                      
P00795        ,:S-GIS-POINT-ID-2                                        
P00795        ,:S-METER-PRESSURE-2                                      
P00795        ,:S-CODE-METER-LOC-2                                      
P00795        ,:S-POINT-ID-2                                            
P00795        ,:S-METER-SUPPLIES-2                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04791_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,RATE_DESC                                                         
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,MTR_REF_NO                                                        
MFA-TR*      ,LAST_MTR_RD_VALUE                                                 
MFA-TR*      ,READ_VALUE_IS                                                     
MFA-TR*      ,LAST_REG_RD_DATE                                                  
MFA-TR*      ,CODE_USAGE_TYPE                                                   
MFA-TR*      ,METER_STATUS_IS                                                   
MFA-TR*      ,METER_STATUS_WS                                                   
MFA-TR*      ,CODE_STATUS_REA_IS                                                
MFA-TR*      ,CODE_STATUS_REA_WS                                                
MFA-TR*      ,REG_ID_NO                                                         
MFA-TR*      ,NO_DIALS                                                          
MFA-TR*      ,CONSTANT                                                          
MFA-TR*      ,CODE_USAGE_ID                                                     
MFA-TR*      ,CODE_USAGE_SOURCE                                                 
MFA-TR*      ,CODE_TIME_PERIOD                                                  
MFA-TR*      ,CODE_DEST                                                         
MFA-TR*      ,DEST_NO                                                           
MFA-TR*      ,WORK_TYPE_CD                                                      
MFA-TR*      ,TABLE_CODE                                                        
MFA-TR*      ,SO_INST_SEQ_NO                                                    
MFA-TR*      ,LOCK_TYPE_ID                                                      
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,CODE_REVENUE_CLASS                                                
MFA-TR*      ,REVENUE_CLASS_DESC                                                
MFA-TR*      ,TASK_STATUS_CD                                                    
MFA-TR*      ,GIS_POINT_ID                                                      
MFA-TR*      ,METER_PRESSURE                                                    
MFA-TR*      ,CODE_METER_LOC                                                    
MFA-TR*      ,POINT_ID                                                          
MFA-TR*      ,METER_SUPPLIES                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2                                                 
MFA-TR*       ,:S-CODE-UTIL-TYPE-2                                              
MFA-TR*       ,:S-IC-NO-2                                                       
MFA-TR*       ,:S-RATE-DESC-2                                                   
MFA-TR*       ,:S-METER-NO-2                                                    
MFA-TR*       ,:S-MTR-REF-NO-2                                                  
MFA-TR*       ,:S-LAST-MTR-RD-VALUE-2                                           
MFA-TR*       ,:S-READ-VALUE-IS-2                                               
MFA-TR*       ,:S-LAST-REG-RD-DATE-2                                            
MFA-TR*       ,:S-CODE-USAGE-TYPE-2                                             
MFA-TR*       ,:S-METER-STATUS-IS-2                                             
MFA-TR*       ,:S-METER-STATUS-WS-2                                             
MFA-TR*       ,:S-CODE-STATUS-REA-IS-2                                          
MFA-TR*       ,:S-CODE-STATUS-REA-WS-2                                          
MFA-TR*       ,:S-REG-ID-NO-2                                                   
MFA-TR*       ,:S-NO-DIALS-2                                                    
MFA-TR*       ,:S-CONSTANT-2                                                    
MFA-TR*       ,:S-CODE-USAGE-ID-2                                               
MFA-TR*       ,:S-CODE-USAGE-SOURCE-2                                           
MFA-TR*       ,:S-CODE-TIME-PERIOD-2                                            
MFA-TR*       ,:S-CODE-DEST-2                                                   
MFA-TR*       ,:S-DEST-NO-2                                                     
MFA-TR*       ,:S-WORK-TYPE-CD-2                                                
MFA-TR*       ,:S-TABLE-CODE-2                                                  
MFA-TR*       ,:S-SO-INST-SEQ-NO-2                                              
MFA-TR*       ,:S-LOCK-TYPE-ID-2                                                
MFA-TR*       ,:S-RATE-PLAN-NO-2                                                
MFA-TR*       ,:S-CODE-REVENUE-CLASS-2                                          
MFA-TR*       ,:S-REVENUE-CLASS-DESC-2                                          
MFA-TR*       ,:S-TASK-STATUS-CD-2                                              
MFA-TR*       ,:S-GIS-POINT-ID-2                                                
MFA-TR*       ,:S-METER-PRESSURE-2                                              
MFA-TR*       ,:S-CODE-METER-LOC-2                                              
MFA-TR*       ,:S-POINT-ID-2                                                    
MFA-TR*       ,:S-METER-SUPPLIES-2                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04791_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04791_R3                            
             (                                                          
               RETURN_CODE,                                             
               CODE_UTIL_TYPE,                                          
               IC_NO,                                                   
               RATE_PLAN_NO,                                            
               RATE_DESC,                                               
               METER_NO,                                                
               MTR_REF_NO,                                              
               LAST_MTR_RD_VALUE,                                       
               CODE_USAGE_TYPE,                                         
               REGISTER_STATUS,                                         
               REG_ID_NO,                                               
               NO_DIALS,                                                
               CONSTANT,                                                
               WORK_TYPE_CD,                                            
               SELECT_TYPE,                                             
               SO_INST_SEQ_NO,                                          
               CODE_TIME_PERIOD,                                        
               CODE_USAGE_ID,                                           
               CODE_USAGE_SOURCE,                                       
P00795         CODE_STATUS_REASON,                                      
P00795         POINT_ID,                                                
P00795         CODE_METER_LOC,                                          
               METER_PRESSURE                                           
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3                                         
              ,:S-CODE-UTIL-TYPE-3                                      
              ,:S-IC-NO-3                                               
              ,:S-RATE-PLAN-NO-3                                        
              ,:S-RATE-DESC-3                                           
              ,:S-METER-NO-3                                            
              ,:S-MTR-REF-NO-3                                          
              ,:S-LAST-MTR-RD-VALUE-3                                   
              ,:S-CODE-USAGE-TYPE-3                                     
              ,:S-REG-STATUS-3                                          
              ,:S-REG-ID-NO-3                                           
              ,:S-NO-DIALS-3                                            
              ,:S-CONSTANT-3                                            
              ,:S-WORK-TYPE-CD-3                                        
              ,:S-SELECT-TYPE-3                                         
              ,:S-SO-INST-SEQ-NO-3                                      
              ,:S-CODE-TIME-PERIOD-3                                    
              ,:S-CODE-USAGE-ID-3                                       
              ,:S-CODE-USAGE-SOURCE-3                                   
P00795        ,:S-CODE-STATUS-REASON-3                                  
P00795        ,:S-POINT-ID-3                                            
P00795        ,:S-CODE-METER-LOC-3                                      
              ,:S-METER-PRESSURE-3                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04791_R3                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        CODE_UTIL_TYPE,                                                  
MFA-TR*        IC_NO,                                                           
MFA-TR*        RATE_PLAN_NO,                                                    
MFA-TR*        RATE_DESC,                                                       
MFA-TR*        METER_NO,                                                        
MFA-TR*        MTR_REF_NO,                                                      
MFA-TR*        LAST_MTR_RD_VALUE,                                               
MFA-TR*        CODE_USAGE_TYPE,                                                 
MFA-TR*        REGISTER_STATUS,                                                 
MFA-TR*        REG_ID_NO,                                                       
MFA-TR*        NO_DIALS,                                                        
MFA-TR*        CONSTANT,                                                        
MFA-TR*        WORK_TYPE_CD,                                                    
MFA-TR*        SELECT_TYPE,                                                     
MFA-TR*        SO_INST_SEQ_NO,                                                  
MFA-TR*        CODE_TIME_PERIOD,                                                
MFA-TR*        CODE_USAGE_ID,                                                   
MFA-TR*        CODE_USAGE_SOURCE,                                               
MFA-TR*        CODE_STATUS_REASON,                                              
MFA-TR*        POINT_ID,                                                        
MFA-TR*        CODE_METER_LOC,                                                  
MFA-TR*        METER_PRESSURE                                                   
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3                                                 
MFA-TR*       ,:S-CODE-UTIL-TYPE-3                                              
MFA-TR*       ,:S-IC-NO-3                                                       
MFA-TR*       ,:S-RATE-PLAN-NO-3                                                
MFA-TR*       ,:S-RATE-DESC-3                                                   
MFA-TR*       ,:S-METER-NO-3                                                    
MFA-TR*       ,:S-MTR-REF-NO-3                                                  
MFA-TR*       ,:S-LAST-MTR-RD-VALUE-3                                           
MFA-TR*       ,:S-CODE-USAGE-TYPE-3                                             
MFA-TR*       ,:S-REG-STATUS-3                                                  
MFA-TR*       ,:S-REG-ID-NO-3                                                   
MFA-TR*       ,:S-NO-DIALS-3                                                    
MFA-TR*       ,:S-CONSTANT-3                                                    
MFA-TR*       ,:S-WORK-TYPE-CD-3                                                
MFA-TR*       ,:S-SELECT-TYPE-3                                                 
MFA-TR*       ,:S-SO-INST-SEQ-NO-3                                              
MFA-TR*       ,:S-CODE-TIME-PERIOD-3                                            
MFA-TR*       ,:S-CODE-USAGE-ID-3                                               
MFA-TR*       ,:S-CODE-USAGE-SOURCE-3                                           
MFA-TR*       ,:S-CODE-STATUS-REASON-3                                          
MFA-TR*       ,:S-POINT-ID-3                                                    
MFA-TR*       ,:S-CODE-METER-LOC-3                                              
MFA-TR*       ,:S-METER-PRESSURE-3                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04791_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-SEND-RESULT-4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04791_R4                            
             (                                                          
               RETURN_CODE,                                             
               PROCESS                                                  
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-4                                         
              ,:S-PROCESS                                               
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04791_R4                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        PROCESS                                                          
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-4                                                 
MFA-TR*       ,:S-PROCESS                                                       
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04791_R4'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795 8600-SEND-RESULT-5.                                              
P00795                                                                  
P00795     EXEC SQL                                                     
P00795       INSERT INTO #CSR04791_R5                            
P00795       (                                                          
P00795         RETURN_CODE                                              
P00795        ,METER_NO                                                 
P00795        ,CODE_USAGE_TYPE                                          
P00795        ,CODE_USAGE_ID                                            
P00795        ,CODE_USAGE_SOURCE                                        
P00795        ,CODE_TIME_PERIOD                                         
P00795        ,REGISTER_READ_SEQ                                        
P00795        ,MTR_RD_DISP_CD                                           
P00795        ,INDEX_VALUE_CD                                           
P00795        ,NO_READ_DIGITS                                           
P00795        ,NO_READ_DECIMALS                                         
P00795        ,METER_USAGE_DESC                                         
P00795        )                                                         
P00795        VALUES                                                    
P00795        (                                                         
P00795           :S-RETURN-CODE-5                                       
P00795          ,:WS-METER-NO-5                                         
P00795          ,:S-CODE-USAGE-TYPE                                     
P00795          ,:S-CODE-USAGE-ID                                       
P00795          ,:S-CODE-USAGE-SOURCE                                   
P00795          ,:S-CODE-TIME-PERIOD                                    
P00795          ,:S-REGISTER-READ-SEQ                                   
P00795          ,:S-METER-RD-DISP-CD                                    
P00795          ,:S-INDEX-VALUE-CD                                      
P00795          ,:S-NO-READ-DIGITS                                      
P00795          ,:S-NO-READ-DECIMALS                                    
P00795          ,:S-METER-USAGE-DESC                                    
P00795        )                                                         
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04791_R5                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,METER_NO                                                         
MFA-TR*       ,CODE_USAGE_TYPE                                                  
MFA-TR*       ,CODE_USAGE_ID                                                    
MFA-TR*       ,CODE_USAGE_SOURCE                                                
MFA-TR*       ,CODE_TIME_PERIOD                                                 
MFA-TR*       ,REGISTER_READ_SEQ                                                
MFA-TR*       ,MTR_RD_DISP_CD                                                   
MFA-TR*       ,INDEX_VALUE_CD                                                   
MFA-TR*       ,NO_READ_DIGITS                                                   
MFA-TR*       ,NO_READ_DECIMALS                                                 
MFA-TR*       ,METER_USAGE_DESC                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*          :S-RETURN-CODE-5                                               
MFA-TR*         ,:WS-METER-NO-5                                                 
MFA-TR*         ,:S-CODE-USAGE-TYPE                                             
MFA-TR*         ,:S-CODE-USAGE-ID                                               
MFA-TR*         ,:S-CODE-USAGE-SOURCE                                           
MFA-TR*         ,:S-CODE-TIME-PERIOD                                            
MFA-TR*         ,:S-REGISTER-READ-SEQ                                           
MFA-TR*         ,:S-METER-RD-DISP-CD                                            
MFA-TR*         ,:S-INDEX-VALUE-CD                                              
MFA-TR*         ,:S-NO-READ-DIGITS                                              
MFA-TR*         ,:S-NO-READ-DECIMALS                                        )   
MFA-TR*         ,:S-METER-USAGE-DESC                                            
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00795        NEXT SENTENCE                                             
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00795        MOVE SQLCODE              TO ABEND-SQLCODE                
P00795        MOVE SQLSTATE             TO ABEND-SQLSTATE               
P00795        MOVE '8600'               TO ACTIVE-PARAGRAPH             
P00795        MOVE 'INSERT'             TO ABEND-FUNCTION               
P00795        MOVE 'CSR04791_R5'        TO TABLE-1                      
P00795        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
P00795                                                                  
P00795     ADD 1 TO CTR-ROWS.                                           
P00795                                                                  
P00795 8600-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04791_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04791_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04791_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04791_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04791_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8003'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04791_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8004-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04791_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04791_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8004'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04791_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8004-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8005-DELETE-GTT4-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04791_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04791_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8005'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04791_R4'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
P00795                                                                  
P00795 8006-DELETE-GTT5-ROWS.                                           
P00795                                                                  
P00795     EXEC SQL                                                     
P00795         DELETE FROM #CSR04791_R5                          
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04791_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00795         NEXT SENTENCE                                            
P00795     ELSE                                                         
P00795         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00795         MOVE SQLCODE              TO ABEND-SQLCODE               
P00795         MOVE SQLSTATE             TO ABEND-SQLSTATE              
P00795         MOVE '8006'               TO ACTIVE-PARAGRAPH            
P00795         MOVE 'DELETE'             TO ABEND-FUNCTION              
P00795         MOVE SPACES               TO ABEND-SQL-PREDICATES        
P00795                                      ABEND-TABLES                
P00795         MOVE 'CSR04791_R5'        TO TABLE-1                     
P00795         MOVE SPACES               TO TABLE-ELEMENT-1             
P00795         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
P00795         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
P00795                                                                  
P00795 8006-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT04-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-4                             
               EXEC SQL                                                 
                   OPEN N4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
P00795     IF WS-GTT05-DECLARED = 'Y'                                   
P00795         EXEC SQL                                                 
P00795             OPEN C5                                              
P00795         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
P00795     ELSE                                                         
P00795         MOVE +100 TO S-RETURN-CODE-5                             
P00795         EXEC SQL                                                 
P00795             OPEN N5                                              
P00795         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
P00795                                                                  
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
