       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04789.                                         
       AUTHOR.       SHABNAM.                                           
COB303 DATE-WRITTEN.  MAY 22, 2014                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160013
      *                 P R O G R A M  S U M M A R Y                 -- 00170013
      *                                                              -- 00180013
      *--  THIS PROCEDURE UPDATE/INSERT ROW IN ACCT_MISC_INFO. AND   -- 00200037
      *--  WRITE A RECORD INTO MNT TRANS HIST TABLES.                -- 00200037
      *--                                                            --         
      *--    NOTE:IF THERE IS NO INSERT/UPDATE FOR THE INPUT ACCOUNT -- 00180013
      *--         SP WILL RETURN CODE AS 100.                        -- 00180013
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_ACCOUNT_NO            DECIMAL(13)             --         
      *--            I_USERID                CHAR(07)                --         
      *--            I_SEASONAL_FLG          CHAR(01)                --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      ******************************************************************00320013
      *                     PROGRAM MODIFICATION LOG                   *00230013
      *                                                                *00240013
      *    DATE    INITIALS   COMMENTS                                 *00250013
      *  --------  --------   ---------------------------------------  *00260013
A04880*  22/05/14  SS7F226    PROCEDURE ORIGINALLY CODED.              *00270037
      ******************************************************************00320013
      *                                                                *00340013
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350013
      *                                                                *00360013
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370013
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380013
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390013
      *  3000 - 4999  NOT USED                                         *00400013
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410013
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420013
      *  7000 - 7999  INPUT MODULES                                    *00430013
      *  8000 - 8999  OUTPUT MODULES                                   *00440013
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450013
      *                                                                *00460013
      ******************************************************************00470013
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04789'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04789 STARTS HERE'.                  
                                                                        
      ******************************************************************00560013
      *    DB2 INCLUDES                                                *00570013
      ******************************************************************00580013
           EXEC SQL                                                     00600013
              INCLUDE SQLCA                                             00610013
           END-EXEC.                                                    00620013
                                                                        
      ******************************************************************00632037
      *    CSS_RESP_AREA,      C1                                      *00632037
      ******************************************************************00632037
           EXEC SQL                                                     00640013
              INCLUDE TBRSAREA                                          00650037
           END-EXEC.                                                    00660013
                                                                        
      ******************************************************************00632037
      *    CSS_MNT_TRANS_HIST, MH                                      *00632037
      ******************************************************************00632037
           EXEC SQL                                                     00640013
              INCLUDE TBMNHIST                                          00650037
           END-EXEC.                                                    00660013
                                                                        
      ******************************************************************00632037
      *    CSS_MT_TRN_HST_DET, MI                                      *00632037
      ******************************************************************00632037
           EXEC SQL                                                     00640013
              INCLUDE TBMNHDT                                           00650037
           END-EXEC.                                                    00660013
                                                                        
      ******************************************************************00632037
      *    CSS_USER_PROFILE,   PF                                      *00632037
      ******************************************************************00632037
           EXEC SQL                                                     00640013
              INCLUDE TBUSRPRF                                          00650037
           END-EXEC.                                                    00660013
                                                                        
      ******************************************************************00632037
      *    CSS_ACCT_MISC_INFO, TA                                      *00632037
      ******************************************************************00632037
           EXEC SQL                                                     00640013
              INCLUDE TBATMISC                                          00650037
           END-EXEC.                                                    00660013
                                                                        
      ******************************************************************01126017
      *    ERROR HANDLING COPY BOOK.                                   *01126017
      ******************************************************************01126017
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
      ******************************************************************        
      *    ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                       
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************01240013
      *    WORK AREAS                                                  *01250013
      ******************************************************************01260013
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04789'.     
           05  WS-ZERO                  PIC 9(01) VALUE 0.              
           05  WS-ONE                   PIC 9(01) VALUE 1.              
           05  WS-100                   PIC 9(03) VALUE 100.            
                                                                        
       01  WS-MISC.                                                     
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-GENERAL-FIELDS.                                           
           05  WS-SEASONAL-FL           PIC X(01) VALUE SPACES.         
           05  WS-TRAN-COMMENT-TXT      PIC X(25) VALUE                 
               'SEASONAL INDICATOR ON GIT'.                             
           05  WS-COL-DESC              PIC X(11) VALUE                 
               'SEASONAL-FL'.                                           
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                PIC X(18) VALUE SPACES.         
           10  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
           10  S-SQLSTATE               PIC X(5)  VALUE ' '.            
           10  S-TABLE-NAME             PIC X(18) VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L   PIC S9(4) USAGE COMP.           
               49  S-HOST-VARIABLES-V   PIC X(255).                     
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L    PIC S9(4) USAGE COMP.           
               49  S-SQL-STATEMENT-V    PIC X(255).                     
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L  PIC S9(4) USAGE COMP.           
               49  S-SQL-DESCRIPTION-V  PIC X(255).                     
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L  PIC S9(4) USAGE COMP.           
               49  WS-ABEND-SQLERRMC-V  PIC X(255).                     
           10  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.             
       01  PARM-USERID                  PIC X(07).                      
       01  PARM-SEASONAL-FLAG           PIC X(01).                      
                                                                        
       PROCEDURE DIVISION USING                                         
                          PARM-ACCOUNT-NO                               
                          PARM-USERID                                   
                          PARM-SEASONAL-FLAG.                           
                                                                        
      ******************************************************************02140013
      * 0000-MAINLINE                                                  *02150013
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160013
      ******************************************************************02170013
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290013
      * 0100-INITIALIZE                                                *02300013
      *     1. RESET DB2 ERROR HANDLERS                                *02320013
      *                                                                *02360013
      ******************************************************************02370013
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
               SELECT                                                   
                  :S-RETURN-CODE       AS    RETURN_CODE                
                 ,:S-APPL-RETURN-CODE  AS    APPL_RETURN_CODE           
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE       AS    RETURN_CODE                        
MFA-TR*          ,:S-APPL-RETURN-CODE  AS    APPL_RETURN_CODE                   
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05116013
      * 1000-PROCESS-INPUT.                                            *05120013
      ******************************************************************05190013
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO              TO TA-ACCOUNT-NO.          
           MOVE PARM-USERID                  TO PF-USER-ID.             
           MOVE PARM-SEASONAL-FLAG           TO WS-SEASONAL-FL.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05116013
      * 2000-PROCESS-OUTPUT.                                           *05120013
      ******************************************************************05190013
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *    WRITE TRANSACTION HISTORY SUMMARY.                                   
           PERFORM 2100-WRITE-TRANS-HIST-SUMM THRU 2100-EXIT.           
                                                                        
           PERFORM 7000-CHECK-ACCT-EXIST      THRU 7000-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              IF TA-SEASONAL-FL NOT = WS-SEASONAL-FL                    
      *    WRITE TRANSACTION HISTORY DETAILS.                                   
                 PERFORM 2100A-WRITE-TRANS-HIST-DET1                    
                                              THRU 2100A-EXIT           
                                                                        
                 MOVE WS-SEASONAL-FL         TO TA-SEASONAL-FL          
                 PERFORM 8100-UPDATE-SEASONAL THRU 8100-EXIT            
               ELSE                                                     
      *    NO UPDATE/INSERT FOR THIS ACCOUNT PASS RETURN CODE 100.              
                 MOVE WS-100                 TO S-RETURN-CODE           
                 ADD  WS-ONE                 TO CTR-ROWS                
                                                                        
                 PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
              END-IF                                                    
                                                                        
           ELSE                                                         
      *    WRITE TRANSACTION HISTORY DETAILS.                                   
              PERFORM 2100B-WRITE-TRANS-HIST-DET2                       
                                              THRU 2100B-EXIT           
                                                                        
              MOVE WS-SEASONAL-FL            TO TA-SEASONAL-FL          
              PERFORM 8200-INSERT-SEASONAL    THRU 8200-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05300013
      * 2000A-MOVE-RESULT.                                                      
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.          
            ADD WS-ONE                       TO CTR-ROWS.               
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************05300013
      * 2100-WRITE-TRANS-HIST-SUMM.                                             
      ******************************************************************        
       2100-WRITE-TRANS-HIST-SUMM.                                      
                                                                        
           PERFORM 7015-GET-RESP-AREA-ID      THRU 7015-EXIT.           
           PERFORM 7020-GET-CURR-TIMESTAMP    THRU 7020-EXIT.           
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW                       
           MOVE 'F'                          TO MH-CODE-TRAN-TYPE.      
           MOVE PF-RESP-AREA-ID              TO MH-RESP-AREA-ID.        
           MOVE TA-ACCOUNT-NO                TO MH-ACCOUNT-NO.          
           MOVE WS-ZERO                      TO MH-CUSTOMER-NO.         
           MOVE WS-ZERO                      TO MH-PREMISE-NO.          
           MOVE PF-USER-ID                   TO MH-USER-ID.             
           MOVE PROGRAM-NAME                 TO MH-APPL-PROGRAM-ID.     
           MOVE WS-ONE                       TO MI-TRAN-APPL-NO.        
           MOVE +25                          TO MH-TRAN-COMMENT-LEN.    
           MOVE WS-TRAN-COMMENT-TXT          TO MH-TRAN-COMMENT-TEXT.   
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05300013
      * 2100A-WRITE-TRANS-HIST-DET1.                                            
      ******************************************************************        
       2100A-WRITE-TRANS-HIST-DET1.                                     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE WS-COL-DESC                  TO MI-COLUMN-DESC.         
           MOVE +1                           TO                         
                                                MI-PRV-COLUMN-VALUE-LEN.
           MOVE TA-SEASONAL-FL               TO                         
                                               MI-PRV-COLUMN-VALUE-TEXT.
           MOVE +1                           TO                         
                                                MI-CHG-COLUMN-VALUE-LEN.
           MOVE WS-SEASONAL-FL               TO                         
                                               MI-CHG-COLUMN-VALUE-TEXT.
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD WS-ONE                        TO MI-TRAN-APPL-NO.        
                                                                        
       2100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************05300013
      * 2100B-WRITE-TRANS-HIST-DET2.                                            
      ******************************************************************        
       2100B-WRITE-TRANS-HIST-DET2.                                     
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE WS-COL-DESC                  TO MI-COLUMN-DESC.         
           MOVE +5                           TO                         
                                              MI-PRV-COLUMN-VALUE-LEN.  
           MOVE '*NEW*'                      TO                         
                                              MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +1                           TO                         
                                              MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-SEASONAL-FL               TO                         
                                              MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
           ADD WS-ONE                        TO MI-TRAN-APPL-NO.        
                                                                        
       2100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 10972013
      * 7000-CHECK-ACCT-EXIST                                         * 10980038
      *     CHECK IF ROW EXIST IN ACCT_MISC_INFO TABLE.               * 10985038
      ***************************************************************** 10990013
       7000-CHECK-ACCT-EXIST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TA.SEASONAL_FL                                     
                INTO :TA-SEASONAL-FL                                    
                FROM  CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
               WHERE  TA.ACCOUNT_NO         = :TA-ACCOUNT-NO            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04450000
MFA-TR*       SELECT TA.SEASONAL_FL                                     04460000
MFA-TR*         INTO :TA-SEASONAL-FL                                    04470000
MFA-TR*         FROM  CSS_ACCT_MISC_INFO TA                             04480000
MFA-TR*        WHERE  TA.ACCOUNT_NO         = :TA-ACCOUNT-NO            04490000
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    04530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCT_MISC_INFO'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE TA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10972013
      * 7015-GET-RESP-AREA-ID                                         * 10980038
      *     GET THE RESP AREA ID TO INSERT INTO TRANS_HIST HEADER.    * 10985038
      ***************************************************************** 10990013
       7015-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE USER_ID = :PF-USER-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE USER_ID = :PF-USER-ID                                      
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7015'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT '                 TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_USER_PROFILE  '      TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10972013
      * 7020-GET-CURR-TIMESTAMP                                       * 10980038
      *     CHECK IF ROW EXIST IN ACCT_MISC_INFO TABLE.               * 10985038
      ***************************************************************** 10990013
       7020-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SET'                     TO ABEND-FUNCTION          
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10972013
      * 8100-UPDATE-SEASONAL                                          * 10980038
      *     UPDATES CSS_ACCT_MISC_INFO.                               * 10985038
      ***************************************************************** 10990013
       8100-UPDATE-SEASONAL.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_MISC_INFO                                 
                 SET SEASONAL_FL        = :TA-SEASONAL-FL               
              WHERE  ACCOUNT_NO         = :TA-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_ACCT_MISC_INFO'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE TA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12541032
      * 8200-INSERT-SEASONAL                                          * 12542038
      *     INSERTS CSS_ACCT_MISC_INFO.                               * 12548038
      ***************************************************************** 12549032
       8200-INSERT-SEASONAL.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_MISC_INFO                            
                    (ACCOUNT_NO                                         
                    ,SEASONAL_FL)                                       
              VALUES                                                    
                   (:TA-ACCOUNT-NO                                      
                   ,:TA-SEASONAL-FL)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_ACCT_MISC_INFO'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'SEASONAL_FL'             TO TABLE-ELEMENT-2         
              MOVE TA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE TA-SEASONAL-FL            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                            *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT.           
           PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT.           
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12570013
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     12560013
      ******************************************************************12570013
           EXEC SQL                                                     12580013
              INCLUDE CPDSP300                                          12590013
           END-EXEC.                                                    12600013
                                                                        
      ******************************************************************12620013
      *       END PROGRAM COPYLIB                                      *12630013
      ******************************************************************12640013
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
