       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04783.                                     
COB303 DATE-WRITTEN.      MAY 14, 2014.                                 
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04783              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04783 :                                                --         
      *--                                                            --         
      *--    #  SELECTS                                              --         
      *--    #  SELECT SERVICE ORDER INFORMATION NECESSARY TO PAY    --         
      *--    #  COMMISSIONS IN THE CRM SYSTEM                        --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--      IN                                                    --         
      *--         I_START_DATE_TIME   CHAR(25)                       --         
      *--      OUT                                                   --         
      *--         S-RETURN-CODE                                      --         
      *--         S-PREMISE-NO                                       --         
      *--         S-ACCOUNT-NO                                       --         
      *--         S-SERV-ORDER-NO                                    --         
      *--         S-COMPANY-NO                                       --         
      *--         S-ORDER-TYPE-CD                                    --         
      *--         S-LOCAL-OFFICE                                     --         
      *--         S-COMPLETED-DATETIME                               --         
      *--         S-ACCOUNT-TYPE-CODE                                --         
      *--         S-CUST-CNT-ID                                      --         
      *--         S-MATERIAL-CHRG                                    --         
      *--         S-MATL-OVERRIDE-CHRG                               --         
      *--         S-ADDL-MATL-CHRG                                   --         
      *--         S-EQUIP-CHARG-AM                                   --         
      *--         S-EQUIP-OVERRIDE-AM                                --         
      *--         S-CALC-LABOR-CHRG                                  --         
      *--         S-OTHER-CHRG                                       --         
      *--         S-CONTRACTOR-AM                                    --         
      *--         S-MATL-ITEM-CD                                     --         
      *--         S-MATL-ITEM-QT                                     --         
      *--         S-MATL-ITEM-TOT-AM                                 --         
      *--         S-EMPLOYEE-ID                                      --         
      *--         S-MATL-ITEM-TX                                     --         
      *--         S-MATL-EQUIP-CD                                    --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  14 MAY 2014   HB42148     NEW CODE                        --         
SCEG01*--  27 APR 2015   HB42148     DO NOT ALLOW SCEG SERV ORDERS   --         
SCEG02*--  01 SEP 2015   HB42148     ALLOW SCEG ORDERS               --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04783'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00303                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_SO_DATA                                                             
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_CHARGES                                                          
           EXEC SQL                                                             
               INCLUDE TBSOCHR                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_MATL_TRAN                                                        
           EXEC SQL                                                             
               INCLUDE TBWMSTRN                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_MATL_ITEM                                                           
           EXEC SQL                                                             
               INCLUDE TBMATITM                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_MATL_CATALOG                                                        
           EXEC SQL                                                             
               INCLUDE TBMATCAT                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_NAME_ACCT_XREF                                                      
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_NAME                                                                
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_SO_ORDER_INST                                                       
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_UTIL_ENVRNMT                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_APPLIANCE                                                           
           EXEC SQL                                                             
               INCLUDE TBAPPLAN                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_SO_UTILITY                                                          
           EXEC SQL                                                             
               INCLUDE TBSOUTL                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_SO_UTL_CHG                                                          
           EXEC SQL                                                             
               INCLUDE TBSOUTG                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_PREM_GAS_LINE                                                       
           EXEC SQL                                                             
               INCLUDE TBPREMLN                                                 
           END-EXEC.                                                            
                                                                        
      * CSS_SO_REQUIREMENT                                                      
           EXEC SQL                                                             
               INCLUDE TBSOREQ                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_MTRD_ENVRNMT                                                        
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
                                                                        
      *01 LOC-RESLTSET   USAGE SQL TYPE IS                              
      *                  RESULT-SET-LOCATOR VARYING.                    
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04783'.      
           05  WS-PGRMNAME             PIC X(08) VALUE 'CSR04783'.      
           05  PANEL-NAME              PIC X(08) VALUE 'XXXXXXXX'.      
       01  GTT-MISC-FIELDS.                                             
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-PREMISE-NO            PIC S9(10) COMP VALUE 0.         
           05  S-ACCOUNT-NO            PIC S9(13) COMP VALUE 0.         
           05  S-CUSTOMER-NO           PIC S9(13) COMP VALUE 0.         
           05  S-SERV-ORDER-NO         PIC S9(13) COMP VALUE 0.         
           05  S-COMPANY-NO            PIC  X(02).                      
           05  S-ORDER-TYPE-CD         PIC  X(07).                      
           05  S-LOCAL-OFFICE          PIC  X(03).                      
           05  S-COMPLETED-DATETIME    PIC  X(26).                      
           05  S-ACCOUNT-TYPE-CODE     PIC  X(01).                      
           05  S-CUST-CNT-ID           PIC  X(10).                      
           05  S-MATERIAL-CHRG         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-MATL-OVERRIDE-CHRG    PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-ADDL-MATL-CHRG        PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-EQUIP-CHARG-AM        PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-EQUIP-OVERRIDE-AM     PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-CALC-LABOR-CHRG       PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-OTHER-CHRG            PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-CONTRACTOR-AM         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-MATL-ITEM-CD          PIC  X(12).                      
           05  S-MATL-ITEM-QT          PIC S9(03) COMP VALUE 0.         
           05  S-MATL-ITEM-TOT-AM      PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-MATL-ITEM-AM          PIC S9(09)V99 COMP-3 VALUE 0.    
           05  S-MATL-ITEM-TX          PIC X(065).                      
           05  S-APPLIANCE-CD          PIC  X(13).                      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  SEND-DONE-SW            PIC  X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  P-PREMISE-NO            PIC S9(10) COMP VALUE 0.         
           05  P-ACCOUNT-NO            PIC S9(13) COMP VALUE 0.         
           05  P-CUSTOMER-NO           PIC S9(13) COMP VALUE 0.         
           05  P-SERV-ORDER-NO         PIC S9(13) COMP VALUE 0.         
           05  P-COMPANY-NO            PIC  X(02).                      
           05  P-ORDER-TYPE-CD         PIC  X(07).                      
           05  P-LOCAL-OFFICE          PIC  X(03).                      
           05  P-COMPLETED-DATETIME    PIC  X(26).                      
           05  P-ACCOUNT-TYPE-CODE     PIC  X(01).                      
           05  P-CUST-CNT-ID           PIC  X(10).                      
           05  P-MATERIAL-CHRG         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-MATL-OVERRIDE-CHRG    PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-ADDL-MATL-CHRG        PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-EQUIP-CHARG-AM        PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-EQUIP-OVERRIDE-AM     PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-CALC-LABOR-CHRG       PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-OTHER-CHRG            PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-CONTRACTOR-AM         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-MATL-ITEM-CD          PIC  X(12).                      
           05  P-MATL-ITEM-QT          PIC S9(03) COMP VALUE 0.         
           05  P-MATL-ITEM-TOT-AM      PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-MATL-ITEM-AM          PIC S9(09)V99 COMP-3 VALUE 0.    
           05  P-APPLIANCE-CD          PIC  X(13).                      
           05  P-APPLIANCE-CD-SERV     PIC  X(03).                      
           05  P-EMPLOYEE-ID           PIC  X(05).                      
           05  P-MATL-ITEM-TX          PIC X(255).                      
           05  P-MATL-EQUIP-CD         PIC  X(01).                      
           05  WS-START-DATE-TIME      PIC  X(26).                      
           05  WS-SERV-ORDER-NO        PIC S9(13) COMP VALUE 0.         
           05  WS-PREMISE-NO           PIC S9(10) COMP VALUE 0.         
           05  PARM-START-DATE-TIME    PIC  X(26).                      
           05  WS-SUMM-RETURN-CODE     PIC S9(04) COMP.                 
           05  WS-ITEM-RETURN-CODE     PIC S9(04) COMP.                 
           05  WS-ITEM-COUNT           PIC S9(04) COMP.                 
           05  WS-APPL-ITEM-INDEX      PIC S9(03) COMP.                 
           05  WS-APPL-STRING-TX       PIC X(255).                      
           05  WS-APPL-ITEM-TX REDEFINES WS-APPL-STRING-TX              
                                       PIC X(3) OCCURS 85 TIMES.        
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
              DECLARE APPL_SUMM_CUR CURSOR FOR                          
                   SELECT                                               
                     VO.PREMISE_NO                                      
                   , CASE WHEN VO.ACCOUNT_NO = 0                        
                          THEN VO.ACCOUNT_NO_PRIOR                      
                          ELSE VO.ACCOUNT_NO END AS ACCOUNT_NO          
                   , NAX.CUSTOMER_NO                                    
                   , VO.SERV_ORDER_NO                                   
                   , VO.COMPANY_NO                                      
                   , VO.ORDER_TYPE_CD                                   
                   , VO.LOCAL_OFFICE                                    
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                              
                   , VO.ACCOUNT_TYPE_CODE                               
                   , VO.CUST_CNT_ID                                     
                   , CASE WHEN VG.MATL_OVERRIDE_CHRG > 0                
                          THEN (VG.MATL_OVERRIDE_CHRG                   
                               * (FZ.MATL_MARKUP_PCT + 1))              
                               + VG.ADDL_MATL_CHRG                      
                          ELSE (VG.MATERIAL_CHRG                        
                               * (FZ.MATL_MARKUP_PCT + 1))              
                               + VG.ADDL_MATL_CHRG                      
                          END AS MATERIAL_CHRG                          
                   , CASE WHEN VG.EQUIP_OVERRIDE_AM > 0                 
                          THEN VG.EQUIP_OVERRIDE_AM                     
                               * (FZ.EQUIP_MARKUP_PCT + 1)              
                          ELSE EQUIP_CHARG_AM                           
                               * (FZ.EQUIP_MARKUP_PCT + 1)              
                          END AS EQUIP_CHARG_AM                         
                   , VG.CALC_LABOR_CHRG +                               
                        (VG.CALC_LABOR_CHRG * FZ.LABOR_MARKUP_PCT)      
                         AS CALC_LABOR_CHRG                             
                   , VG.OTHER_CHRG +                                    
                    (                                                   
                     (                                                  
                        CASE WHEN VG.MATL_OVERRIDE_CHRG > 0             
                             THEN (VG.MATL_OVERRIDE_CHRG                
                                  * (FZ.MATL_MARKUP_PCT + 1))           
                                  + VG.ADDL_MATL_CHRG                   
                             ELSE (VG.MATERIAL_CHRG                     
                                  * (FZ.MATL_MARKUP_PCT + 1))           
                                  + VG.ADDL_MATL_CHRG END               
                      + CASE WHEN VG.EQUIP_OVERRIDE_AM > 0              
                             THEN VG.EQUIP_OVERRIDE_AM                  
                                  * (FZ.EQUIP_MARKUP_PCT + 1)           
                             ELSE EQUIP_CHARG_AM                        
                                  * (FZ.EQUIP_MARKUP_PCT + 1) END       
                      + (VG.CALC_LABOR_CHRG +                           
                         (VG.CALC_LABOR_CHRG * FZ.LABOR_MARKUP_PCT)     
                        )                                               
                      + VG.CONTRACTOR_AM                                
                     ) * BAD_DEBT_PCT                                   
                    ) AS OTHER_CHRG                                     
                   , VG.CONTRACTOR_AM                                   
                   FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                    
                                                                        
                   INNER JOIN CSS_SO_REQUIREMENT EG
                           WITH(READUNCOMMITTED)                     
                   ON VO.SERV_ORDER_NO = EG.SERV_ORDER_NO               
                   AND EG.REQMNT_STAGE_CD = 'C'                         
      *            AND EG.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS              
                   AND EG.SERV_ORDER_STATUS = 50                        
                                                                        
                   INNER JOIN CSS_SO_CHARGES VG WITH(READUNCOMMITTED)           
                   ON VO.SERV_ORDER_NO = VG.SERV_ORDER_NO               
                   AND VG.CODE_UTIL_TYPE = 'G'                          
                                                                        
                   INNER JOIN CSS_NAME_ACCT_XREF NAX
                           WITH(READUNCOMMITTED)                    
                   ON CASE WHEN VO.ACCOUNT_NO = 0                       
                           THEN VO.ACCOUNT_NO_PRIOR                     
                           ELSE VO.ACCOUNT_NO END                       
                           = NAX.ACCOUNT_NO                             
                   AND NAX.CUSTOMER_ROLE_CD = ''                        
                                                                        
                   INNER JOIN CSS_NAME NA WITH(READUNCOMMITTED)                 
                   ON NAX.NAME_ID = NA.NAME_ID                          
                   AND NA.NAME_TYPE = 'CN'                              
                                                                        
                   INNER JOIN (                                         
                         SELECT                                         
                         COMPANY_NO                                     
                         , START_DT AS DATE_FROM                        
                         , END_DATE AS DATE_TO                          
                         , SUM(CASE WHEN COLUMN_NA = 'EQUIP_MARKUP_PCT' 
                           THEN CAST(CODE_VALUE
               AS DECIMAL(31,15)) ELSE 0 END )                 
                           AS EQUIP_MARKUP_PCT                          
                         , SUM(CASE WHEN COLUMN_NA = 'LABOR_MARKUP_PCT' 
                           THEN CAST(CODE_VALUE
               AS DECIMAL(31,15)) ELSE 0 END)                  
                           AS LABOR_MARKUP_PCT                          
                         , SUM(CASE WHEN COLUMN_NA = 'MATL_MARKUP_PCT'  
                           THEN CAST(CODE_VALUE
               AS DECIMAL(31,15)) ELSE 0 END)                  
                           AS MATL_MARKUP_PCT                           
                         , SUM(CASE WHEN COLUMN_NA = 'BAD_DEBT_PCT'     
                           THEN CAST(CODE_VALUE
               AS DECIMAL(31,15)) ELSE 0 END)                  
                           AS BAD_DEBT_PCT                              
                         FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)              
                         WHERE TABLE_NA = 'CSS_MKT_MARKUPS'             
                         GROUP BY COMPANY_NO, START_DT, END_DATE        
                     ) FZ                                               
                      ON VO.COMPANY_NO = FZ.COMPANY_NO                  
                     AND FZ.DATE_FROM                                   
                            <= CAST(VO.COMPLETED_DATETIME AS DATE)      
                     AND FZ.DATE_TO                                     
                            >= CAST(VO.COMPLETED_DATETIME AS DATE)      
                                                                        
                   WHERE VO.ORDER_TYPE_CD = 'FM007'                     
                   AND VO.ORDER_STATE_CD = 'Z'                          
                   AND EG.REQMNT_COMP_DT >= CIS.CHAR2TIMESTAMP(
                                                    :WS-START-DATE-TIME
              )         
SCEG01*            AND VO.COMPANY_NO = '26'                                     
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ051
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE APPL_SUMM_CUR CURSOR FOR                                  
MFA-TR*            SELECT                                                       
MFA-TR*              VO.PREMISE_NO                                              
MFA-TR*            , CASE WHEN VO.ACCOUNT_NO = 0                                
MFA-TR*                   THEN VO.ACCOUNT_NO_PRIOR                              
MFA-TR*                   ELSE VO.ACCOUNT_NO END AS ACCOUNT_NO                  
MFA-TR*            , NAX.CUSTOMER_NO                                            
MFA-TR*            , VO.SERV_ORDER_NO                                           
MFA-TR*            , VO.COMPANY_NO                                              
MFA-TR*            , VO.ORDER_TYPE_CD                                           
MFA-TR*            , VO.LOCAL_OFFICE                                            
MFA-TR*            , VO.COMPLETED_DATETIME                                      
MFA-TR*            , VO.ACCOUNT_TYPE_CODE                                       
MFA-TR*            , VO.CUST_CNT_ID                                             
MFA-TR*            , CASE WHEN VG.MATL_OVERRIDE_CHRG > 0                        
MFA-TR*                   THEN (VG.MATL_OVERRIDE_CHRG                           
MFA-TR*                        * (FZ.MATL_MARKUP_PCT + 1))                      
MFA-TR*                        + VG.ADDL_MATL_CHRG                              
MFA-TR*                   ELSE (VG.MATERIAL_CHRG                                
MFA-TR*                        * (FZ.MATL_MARKUP_PCT + 1))                      
MFA-TR*                        + VG.ADDL_MATL_CHRG                              
MFA-TR*                   END AS MATERIAL_CHRG                                  
MFA-TR*            , CASE WHEN VG.EQUIP_OVERRIDE_AM > 0                         
MFA-TR*                   THEN VG.EQUIP_OVERRIDE_AM                             
MFA-TR*                        * (FZ.EQUIP_MARKUP_PCT + 1)                      
MFA-TR*                   ELSE EQUIP_CHARG_AM                                   
MFA-TR*                        * (FZ.EQUIP_MARKUP_PCT + 1)                      
MFA-TR*                   END AS EQUIP_CHARG_AM                                 
MFA-TR*            , VG.CALC_LABOR_CHRG +                                       
MFA-TR*                 (VG.CALC_LABOR_CHRG * FZ.LABOR_MARKUP_PCT)              
MFA-TR*                  AS CALC_LABOR_CHRG                                     
MFA-TR*            , VG.OTHER_CHRG +                                            
MFA-TR*             (                                                           
MFA-TR*              (                                                          
MFA-TR*                 CASE WHEN VG.MATL_OVERRIDE_CHRG > 0                     
MFA-TR*                      THEN (VG.MATL_OVERRIDE_CHRG                        
MFA-TR*                           * (FZ.MATL_MARKUP_PCT + 1))                   
MFA-TR*                           + VG.ADDL_MATL_CHRG                           
MFA-TR*                      ELSE (VG.MATERIAL_CHRG                             
MFA-TR*                           * (FZ.MATL_MARKUP_PCT + 1))                   
MFA-TR*                           + VG.ADDL_MATL_CHRG END                       
MFA-TR*               + CASE WHEN VG.EQUIP_OVERRIDE_AM > 0                      
MFA-TR*                      THEN VG.EQUIP_OVERRIDE_AM                          
MFA-TR*                           * (FZ.EQUIP_MARKUP_PCT + 1)                   
MFA-TR*                      ELSE EQUIP_CHARG_AM                                
MFA-TR*                           * (FZ.EQUIP_MARKUP_PCT + 1) END               
MFA-TR*               + (VG.CALC_LABOR_CHRG +                                   
MFA-TR*                  (VG.CALC_LABOR_CHRG * FZ.LABOR_MARKUP_PCT)             
MFA-TR*                 )                                                       
MFA-TR*               + VG.CONTRACTOR_AM                                        
MFA-TR*              ) * BAD_DEBT_PCT                                           
MFA-TR*             ) AS OTHER_CHRG                                             
MFA-TR*            , VG.CONTRACTOR_AM                                           
MFA-TR*            FROM CSS_SO_DATA VO                                          
MFA-TR*                                                                         
MFA-TR*            INNER JOIN CSS_SO_REQUIREMENT EG                             
MFA-TR*            ON VO.SERV_ORDER_NO = EG.SERV_ORDER_NO                       
MFA-TR*            AND EG.REQMNT_STAGE_CD = 'C'                                 
MFA-TR*            AND EG.SERV_ORDER_STATUS = VO.SERV_ORDER_STATUS              
MFA-TR*            AND EG.SERV_ORDER_STATUS = 50                                
MFA-TR*                                                                         
MFA-TR*            INNER JOIN CSS_SO_CHARGES VG                                 
MFA-TR*            ON VO.SERV_ORDER_NO = VG.SERV_ORDER_NO                       
MFA-TR*            AND VG.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*                                                                         
MFA-TR*            INNER JOIN CSS_NAME_ACCT_XREF NAX                            
MFA-TR*            ON CASE WHEN VO.ACCOUNT_NO = 0                               
MFA-TR*                    THEN VO.ACCOUNT_NO_PRIOR                             
MFA-TR*                    ELSE VO.ACCOUNT_NO END                               
MFA-TR*                    = NAX.ACCOUNT_NO                                     
MFA-TR*            AND NAX.CUSTOMER_ROLE_CD = ''                                
MFA-TR*                                                                         
MFA-TR*            INNER JOIN CSS_NAME NA                                       
MFA-TR*            ON NAX.NAME_ID = NA.NAME_ID                                  
MFA-TR*            AND NA.NAME_TYPE = 'CN'                                      
MFA-TR*                                                                         
MFA-TR*            INNER JOIN (                                                 
MFA-TR*                  SELECT                                                 
MFA-TR*                  COMPANY_NO                                             
MFA-TR*                  , START_DT AS DATE_FROM                                
MFA-TR*                  , END_DATE AS DATE_TO                                  
MFA-TR*                  , SUM(CASE WHEN COLUMN_NA = 'EQUIP_MARKUP_PCT'         
MFA-TR*                    THEN CODE_VALUE ELSE 0 END )                         
MFA-TR*                    AS EQUIP_MARKUP_PCT                                  
MFA-TR*                  , SUM(CASE WHEN COLUMN_NA = 'LABOR_MARKUP_PCT'         
MFA-TR*                    THEN CODE_VALUE ELSE 0 END)                          
MFA-TR*                    AS LABOR_MARKUP_PCT                                  
MFA-TR*                  , SUM(CASE WHEN COLUMN_NA = 'MATL_MARKUP_PCT'          
MFA-TR*                    THEN CODE_VALUE ELSE 0 END)                          
MFA-TR*                    AS MATL_MARKUP_PCT                                   
MFA-TR*                  , SUM(CASE WHEN COLUMN_NA = 'BAD_DEBT_PCT'             
MFA-TR*                    THEN CODE_VALUE ELSE 0 END)                          
MFA-TR*                    AS BAD_DEBT_PCT                                      
MFA-TR*                  FROM CSS_CODE_VALUE                                    
MFA-TR*                  WHERE TABLE_NA = 'CSS_MKT_MARKUPS'                     
MFA-TR*                  GROUP BY COMPANY_NO, START_DT, END_DATE                
MFA-TR*              ) FZ                                                       
MFA-TR*               ON VO.COMPANY_NO = FZ.COMPANY_NO                          
MFA-TR*              AND FZ.DATE_FROM                                           
MFA-TR*                     <= CAST(VO.COMPLETED_DATETIME AS DATE)              
MFA-TR*              AND FZ.DATE_TO                                             
MFA-TR*                     >= CAST(VO.COMPLETED_DATETIME AS DATE)              
MFA-TR*                                                                         
MFA-TR*            WHERE VO.ORDER_TYPE_CD = 'FM007'                             
MFA-TR*            AND VO.ORDER_STATE_CD = 'Z'                                  
MFA-TR*            AND EG.REQMNT_COMP_DT >= :WS-START-DATE-TIME                 
MFA-TR*            AND VO.COMPANY_NO = '26'                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE APPL_ITEM_CUR CURSOR FOR                          
              SELECT                                                    
                MATL_ITEM_CD                                            
              , MATL_ITEM_QT                                            
              , CASE WHEN CNT_WH > 0 THEN 'WH; ' ELSE '' END + 
           CASE WHEN CNT_WT > 0 THEN 'WT; ' ELSE '' END + CASE WHEN 
           CNT_GG > 0 THEN 'GG; ' ELSE '' END + CASE WHEN 
           CNT_LG > 0 THEN 'LG; ' ELSE '' END + CASE WHEN 
           CNT_HS > 0 THEN 'HS; ' ELSE '' END + CASE WHEN 
           CNT_SH > 0 THEN 'SH; ' ELSE '' END + CASE WHEN 
           CNT_GL > 0 THEN 'GL; ' ELSE '' END + CASE WHEN 
           CNT_OF > 0 THEN 'OF; ' ELSE '' END + CASE WHEN 
           CNT_PH > 0 THEN 'PH; ' ELSE '' END + CASE WHEN 
           CNT_CD > 0 THEN 'CD; ' ELSE '' END + CASE WHEN 
           CNT_RO > 0 THEN 'RO; ' ELSE '' END + CASE WHEN 
           CNT_CE > 0 THEN 'CE; ' ELSE '' END + CASE WHEN 
           CNT_OT > 0 THEN 'OT; ' ELSE '' END + CASE WHEN 
           MATL_ITEM_QT = 0 THEN 'XX; ' ELSE '' END      
                     AS MATL_ITEM_TX                                    
              , '' AS APPLIANCE_CD                                      
              , MATL_ITEM_TOT_AM                                        
              , MATL_ITEM_AM                                            
              FROM                                                      
              (                                                         
                SELECT                                                  
                MATL_ITEM_CD                                            
                , SUM(MATL_ITEM_QT) AS MATL_ITEM_QT                     
                , SUM(CNT_WH) AS CNT_WH                                 
                , SUM(CNT_WT) AS CNT_WT                                 
                , SUM(CNT_GG) AS CNT_GG                                 
                , SUM(CNT_LG) AS CNT_LG                                 
                , SUM(CNT_HS) AS CNT_HS                                 
                , SUM(CNT_SH) AS CNT_SH                                 
                , SUM(CNT_GL) AS CNT_GL                                 
                , SUM(CNT_OF) AS CNT_OF                                 
                , SUM(CNT_PH) AS CNT_PH                                 
                , SUM(CNT_CD) AS CNT_CD                                 
                , SUM(CNT_RO) AS CNT_RO                                 
                , SUM(CNT_CE) AS CNT_CE                                 
                , SUM(CNT_OT) AS CNT_OT                                 
                , MATL_ITEM_TOT_AM                                      
                , MATL_ITEM_AM                                          
                FROM                                                    
                (                                                       
                  SELECT                                                
                    '' AS MATL_ITEM_CD                                  
                  , COUNT(*) AS MATL_ITEM_QT                            
             , CASE WHEN QM.APPL_ACCT_CD IN ('725', 'MIL', 'WHC', 'WHR')
                         THEN 1 ELSE 0 END AS CNT_WH                    
                  , CASE WHEN QM.APPL_ACCT_CD IN ('740')                
                         THEN 1 ELSE 0 END AS CNT_WT                    
                  , CASE WHEN QM.APPL_ACCT_CD IN ('709')                
                         THEN 1 ELSE 0 END AS CNT_GG                    
                  , CASE WHEN QM.APPL_ACCT_CD IN ('714', '733')         
                         THEN 1 ELSE 0 END AS CNT_LG                    
                  , CASE WHEN QM.APPL_ACCT_CD                           
                         IN ('708','795', 'HVC', 'HVF'                  
                         , '712', '726', '701', '702', '706', '711')    
                         THEN 1 ELSE 0 END AS CNT_HS                    
                  , CASE WHEN QM.APPL_ACCT_CD                           
                         IN ('SCH', '713', '721', '727', '722')         
                         THEN 1 ELSE 0 END AS CNT_SH                    
                  , CASE WHEN QM.APPL_ACCT_CD IN ('710')                
                         THEN 1 ELSE 0 END AS CNT_GL                    
                  , CASE WHEN QM.APPL_ACCT_CD IN ('FT')                 
                         THEN 1 ELSE 0 END AS CNT_OF                    
                  , CASE WHEN QM.APPL_ACCT_CD IN ('717')                
                         THEN 1 ELSE 0 END AS CNT_PH                    
                  , CASE WHEN QM.APPL_ACCT_CD IN ('705')                
                         THEN 1 ELSE 0 END AS CNT_CD                    
                  , CASE WHEN QM.APPL_ACCT_CD                           
                         IN ('716', '718')                              
                         THEN 1 ELSE 0 END AS CNT_RO                    
                  , CASE WHEN QM.APPL_ACCT_CD                           
                         IN ('703', '724', '739')                       
                         THEN 1 ELSE 0 END AS CNT_CE                    
                  , CASE WHEN QM.APPL_ACCT_CD                           
                         IN ('700', '742', '707', '715', '723')         
                         THEN 1 ELSE 0 END AS CNT_OT                    
                  , 0 AS MATL_ITEM_TOT_AM                               
                  , 0 AS MATL_ITEM_AM                                   
                  FROM CSS_SO_MATL_TRAN WU WITH(READUNCOMMITTED)                
                                                                        
                  INNER JOIN CSS_MATL_CATALOG QM WITH(READUNCOMMITTED)          
                  ON WU.MATL_ITEM_CD = QM.MATL_ITEM_CD                  
                                                                        
                  WHERE WU.SERV_ORDER_NO = :WS-SERV-ORDER-NO            
                  AND WU.MATL_USAGE_CD = 'I'                            
SCEG01*           AND WU.COMPANY_NO = '26'                                      
                  GROUP BY QM.APPL_ACCT_CD                              
                ) TEMP_TBL1                                             
                GROUP BY MATL_ITEM_CD, MATL_ITEM_TOT_AM, MATL_ITEM_AM   
              ) TEMP_TBL2                                               
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE APPL_ITEM_CUR CURSOR FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*         MATL_ITEM_CD                                                    
MFA-TR*       , MATL_ITEM_QT                                                    
MFA-TR*       , CASE WHEN CNT_WH > 0 THEN 'WH; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_WT > 0 THEN 'WT; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_GG > 0 THEN 'GG; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_LG > 0 THEN 'LG; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_HS > 0 THEN 'HS; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_SH > 0 THEN 'SH; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_GL > 0 THEN 'GL; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_OF > 0 THEN 'OF; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_PH > 0 THEN 'PH; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_CD > 0 THEN 'CD; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_RO > 0 THEN 'RO; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_CE > 0 THEN 'CE; ' ELSE '' END||                  
MFA-TR*         CASE WHEN CNT_OT > 0 THEN 'OT; ' ELSE '' END||                  
MFA-TR*         CASE WHEN MATL_ITEM_QT = 0 THEN 'XX; ' ELSE '' END              
MFA-TR*              AS MATL_ITEM_TX                                            
MFA-TR*       , '' AS APPLIANCE_CD                                              
MFA-TR*       , MATL_ITEM_TOT_AM                                                
MFA-TR*       , MATL_ITEM_AM                                                    
MFA-TR*       FROM                                                              
MFA-TR*       (                                                                 
MFA-TR*         SELECT                                                          
MFA-TR*         MATL_ITEM_CD                                                    
MFA-TR*         , SUM(MATL_ITEM_QT) AS MATL_ITEM_QT                             
MFA-TR*         , SUM(CNT_WH) AS CNT_WH                                         
MFA-TR*         , SUM(CNT_WT) AS CNT_WT                                         
MFA-TR*         , SUM(CNT_GG) AS CNT_GG                                         
MFA-TR*         , SUM(CNT_LG) AS CNT_LG                                         
MFA-TR*         , SUM(CNT_HS) AS CNT_HS                                         
MFA-TR*         , SUM(CNT_SH) AS CNT_SH                                         
MFA-TR*         , SUM(CNT_GL) AS CNT_GL                                         
MFA-TR*         , SUM(CNT_OF) AS CNT_OF                                         
MFA-TR*         , SUM(CNT_PH) AS CNT_PH                                         
MFA-TR*         , SUM(CNT_CD) AS CNT_CD                                         
MFA-TR*         , SUM(CNT_RO) AS CNT_RO                                         
MFA-TR*         , SUM(CNT_CE) AS CNT_CE                                         
MFA-TR*         , SUM(CNT_OT) AS CNT_OT                                         
MFA-TR*         , MATL_ITEM_TOT_AM                                              
MFA-TR*         , MATL_ITEM_AM                                                  
MFA-TR*         FROM                                                            
MFA-TR*         (                                                               
MFA-TR*           SELECT                                                        
MFA-TR*             '' AS MATL_ITEM_CD                                          
MFA-TR*           , COUNT(*) AS MATL_ITEM_QT                                    
MFA-TR*      , CASE WHEN QM.APPL_ACCT_CD IN ('725', 'MIL', 'WHC', 'WHR')        
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_WH                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD IN ('740')                        
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_WT                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD IN ('709')                        
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_GG                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD IN ('714', '733')                 
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_LG                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD                                   
MFA-TR*                  IN ('708','795', 'HVC', 'HVF'                          
MFA-TR*                  , '712', '726', '701', '702', '706', '711')            
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_HS                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD                                   
MFA-TR*                  IN ('SCH', '713', '721', '727', '722')                 
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_SH                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD IN ('710')                        
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_GL                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD IN ('FT')                         
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_OF                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD IN ('717')                        
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_PH                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD IN ('705')                        
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_CD                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD                                   
MFA-TR*                  IN ('716', '718')                                      
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_RO                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD                                   
MFA-TR*                  IN ('703', '724', '739')                               
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_CE                            
MFA-TR*           , CASE WHEN QM.APPL_ACCT_CD                                   
MFA-TR*                  IN ('700', '742', '707', '715', '723')                 
MFA-TR*                  THEN 1 ELSE 0 END AS CNT_OT                            
MFA-TR*           , 0 AS MATL_ITEM_TOT_AM                                       
MFA-TR*           , 0 AS MATL_ITEM_AM                                           
MFA-TR*           FROM CSS_SO_MATL_TRAN WU                                      
MFA-TR*                                                                         
MFA-TR*           INNER JOIN CSS_MATL_CATALOG QM                                
MFA-TR*           ON WU.MATL_ITEM_CD = QM.MATL_ITEM_CD                          
MFA-TR*                                                                         
MFA-TR*           WHERE WU.SERV_ORDER_NO = :WS-SERV-ORDER-NO                    
MFA-TR*           AND WU.MATL_USAGE_CD = 'I'                                    
MFA-TR*           AND WU.COMPANY_NO = '26'                                      
MFA-TR*           GROUP BY QM.APPL_ACCT_CD                                      
MFA-TR*         ) TEMP_TBL1                                                     
MFA-TR*         GROUP BY MATL_ITEM_CD, MATL_ITEM_TOT_AM, MATL_ITEM_AM           
MFA-TR*       ) TEMP_TBL2                                                       
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE NEW_SERVICE_CUR CURSOR FOR                       
               SELECT DISTINCT                                          
                 VO.PREMISE_NO                                          
               , VO.ACCOUNT_NO                                          
               , HT.CUSTOMER_NO                                         
               , VO.SERV_ORDER_NO                                       
               , VO.COMPANY_NO                                          
               , CASE WHEN VO.CUST_CNT_ID = '' THEN VO.ORDER_TYPE_CD    
                 ELSE 'FM007' END + CASE                                        
                     WHEN VO.COMPANY_NO = '01' AND                      
                          VO.CUST_CNT_ID = '' THEN 'N'                  
                     WHEN VO.COMPANY_NO = '01' AND                      
                          VO.CUST_CNT_ID <> '' THEN 'E'                 
                     WHEN VO.COMPANY_NO = '26' AND                      
                          PG.STRUCTURE_TYPE_CD IS NULL THEN ''          
                     WHEN VO.COMPANY_NO = '26'                          
                          THEN PG.STRUCTURE_TYPE_CD                     
                  ELSE ' ' END + CASE                                           
                    WHEN                                                
                      VO.COMPANY_NO = '01' AND                          
                       (VT.CODE_REVENUE_CLASS LIKE '__3' OR             
                        VE.CODE_REVENUE_CLASS LIKE '__3' OR             
                        VT.CODE_REVENUE_CLASS = '112'    OR             
                        VE.CODE_REVENUE_CLASS = '112') THEN 'M'         
                    WHEN                                                
                      VO.COMPANY_NO = '01' AND                          
                       (VT.CODE_REVENUE_CLASS LIKE '_1_' OR             
                        VE.CODE_REVENUE_CLASS LIKE '_1_') THEN 'S'      
                    WHEN                                                
                      (VO.COMPANY_NO = '01' AND                         
                       (VT.CODE_REVENUE_CLASS LIKE '_2_' OR             
                        VE.CODE_REVENUE_CLASS LIKE '_2_'))              
                     OR                                                 
                      (VO.COMPANY_NO = '01' AND                         
                       (VT.CODE_REVENUE_CLASS LIKE '_8_' OR             
                        VE.CODE_REVENUE_CLASS LIKE '_8_')) THEN 'C'     
                    WHEN                                                
                      VO.COMPANY_NO = '01' AND                          
                       (VT.CODE_REVENUE_CLASS LIKE '_3_' OR             
                        VE.CODE_REVENUE_CLASS LIKE '_3_') THEN 'I'      
                    WHEN                                                
                      VO.COMPANY_NO = '26' AND                          
                      PG.STRUCTURE_CD IS NULL THEN ''                   
                    WHEN VO.COMPANY_NO = '26' THEN PG.STRUCTURE_CD      
                 ELSE ' ' END AS STRUCTURE_CODE                         
               , VO.LOCAL_OFFICE                                        
               , REPLACE(REPLACE(CONVERT(CHAR(26), VO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME                     
               , VO.ACCOUNT_TYPE_CODE                                   
               , VO.CUST_CNT_ID                                         
               , 0 AS MATERIAL_CHRG                                     
               , 0 AS EQUIP_CHARG_AM                                    
               , 0 AS CALC_LABOR_CHRG                                   
               , 0 AS OTHER_CHRG                                        
               , 0 AS CONTRACTOR_AM                                     
               FROM CSS_SO_DATA VO                                      
               INNER JOIN CSS_SO_ORDER_INST VI                          
               ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                   
               AND VI.METER_NO <> ''                                    
               AND VI.METER_NO IS NOT NULL                              
               LEFT OUTER JOIN CSS_SO_REQUIREMENT EG                    
               ON VO.SERV_ORDER_NO = EG.SERV_ORDER_NO                   
               AND EG.REQMNT_STAGE_CD = 'C'                             
               AND EG.SERV_ORDER_STATUS = 50                            
               INNER JOIN CSS_NAME_ACCT_XREF HT                         
               ON VO.ACCOUNT_NO = HT.ACCOUNT_NO                         
               AND HT.CUSTOMER_ROLE_CD = ''                             
               INNER JOIN CSS_NAME DQ                                   
               ON HT.NAME_ID = DQ.NAME_ID                               
               AND DQ.NAME_TYPE = 'CN'                                  
               LEFT OUTER JOIN CSS_SO_UTILITY VT                        
               ON VO.SERV_ORDER_NO = VT.SERV_ORDER_NO                   
               AND VI.CODE_UTIL_TYPE =  VT.CODE_UTIL_TYPE               
               LEFT OUTER JOIN CSS_SO_UTL_CHG VE                        
               ON VO.SERV_ORDER_NO = VE.SERV_ORDER_NO                   
               AND VI.CODE_UTIL_TYPE = VE.CODE_UTIL_TYPE                
               LEFT OUTER JOIN CSS_PREM_GAS_LINE PG                     
               ON VO.PREMISE_NO = PG.PREMISE_NO                         
               LEFT OUTER JOIN CSS_MTRD_ENVRNMT ME                      
               ON VO.ACCOUNT_NO = ME.ACCOUNT_NO                         
               AND VI.CODE_UTIL_TYPE = ME.CODE_UTIL_TYPE                
               AND ME.CODE_METER_STATUS = 'K'                           
                                                                        
               WHERE VO.ORDER_TYPE_CD = 'FM002'                         
               AND VI.WORK_TYPE_CD = 'SET'                              
               AND VO.ORDER_STATE_CD = 'Z'                              
               AND VI.CODE_UTIL_TYPE = 'G'                              
               AND (   VT.CODE_REVENUE_CLASS IS NOT NULL                
                    OR VE.CODE_REVENUE_CLASS IS NOT NULL)               
               AND VO.ACCOUNT_TYPE_CODE  <> 'D'                         
               AND EG.REQMNT_COMP_DT >= CIS.CHAR2TIMESTAMP(
                                                    :WS-START-DATE-TIME
              )             
               AND ME.ACCOUNT_NO IS NULL                                
SCEG01*        AND VO.COMPANY_NO = '26'                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE NEW_SERVICE_CUR CURSOR FOR                               
MFA-TR*        SELECT DISTINCT                                                  
MFA-TR*          VO.PREMISE_NO                                                  
MFA-TR*        , VO.ACCOUNT_NO                                                  
MFA-TR*        , HT.CUSTOMER_NO                                                 
MFA-TR*        , VO.SERV_ORDER_NO                                               
MFA-TR*        , VO.COMPANY_NO                                                  
MFA-TR*        , CASE WHEN VO.CUST_CNT_ID = '' THEN VO.ORDER_TYPE_CD            
MFA-TR*          ELSE 'FM007' END                                               
MFA-TR*        || CASE                                                          
MFA-TR*              WHEN VO.COMPANY_NO = '01' AND                              
MFA-TR*                   VO.CUST_CNT_ID = '' THEN 'N'                          
MFA-TR*              WHEN VO.COMPANY_NO = '01' AND                              
MFA-TR*                   VO.CUST_CNT_ID <> '' THEN 'E'                         
MFA-TR*              WHEN VO.COMPANY_NO = '26' AND                              
MFA-TR*                   PG.STRUCTURE_TYPE_CD IS NULL THEN ''                  
MFA-TR*              WHEN VO.COMPANY_NO = '26'                                  
MFA-TR*                   THEN PG.STRUCTURE_TYPE_CD                             
MFA-TR*           ELSE ' ' END                                                  
MFA-TR*        || CASE                                                          
MFA-TR*             WHEN                                                        
MFA-TR*               VO.COMPANY_NO = '01' AND                                  
MFA-TR*                (VT.CODE_REVENUE_CLASS LIKE '__3' OR                     
MFA-TR*                 VE.CODE_REVENUE_CLASS LIKE '__3' OR                     
MFA-TR*                 VT.CODE_REVENUE_CLASS = '112'    OR                     
MFA-TR*                 VE.CODE_REVENUE_CLASS = '112') THEN 'M'                 
MFA-TR*             WHEN                                                        
MFA-TR*               VO.COMPANY_NO = '01' AND                                  
MFA-TR*                (VT.CODE_REVENUE_CLASS LIKE '_1_' OR                     
MFA-TR*                 VE.CODE_REVENUE_CLASS LIKE '_1_') THEN 'S'              
MFA-TR*             WHEN                                                        
MFA-TR*               (VO.COMPANY_NO = '01' AND                                 
MFA-TR*                (VT.CODE_REVENUE_CLASS LIKE '_2_' OR                     
MFA-TR*                 VE.CODE_REVENUE_CLASS LIKE '_2_'))                      
MFA-TR*              OR                                                         
MFA-TR*               (VO.COMPANY_NO = '01' AND                                 
MFA-TR*                (VT.CODE_REVENUE_CLASS LIKE '_8_' OR                     
MFA-TR*                 VE.CODE_REVENUE_CLASS LIKE '_8_')) THEN 'C'             
MFA-TR*             WHEN                                                        
MFA-TR*               VO.COMPANY_NO = '01' AND                                  
MFA-TR*                (VT.CODE_REVENUE_CLASS LIKE '_3_' OR                     
MFA-TR*                 VE.CODE_REVENUE_CLASS LIKE '_3_') THEN 'I'              
MFA-TR*             WHEN                                                        
MFA-TR*               VO.COMPANY_NO = '26' AND                                  
MFA-TR*               PG.STRUCTURE_CD IS NULL THEN ''                           
MFA-TR*             WHEN VO.COMPANY_NO = '26' THEN PG.STRUCTURE_CD              
MFA-TR*          ELSE ' ' END AS STRUCTURE_CODE                                 
MFA-TR*        , VO.LOCAL_OFFICE                                                
MFA-TR*        , VO.COMPLETED_DATETIME                                          
MFA-TR*        , VO.ACCOUNT_TYPE_CODE                                           
MFA-TR*        , VO.CUST_CNT_ID                                                 
MFA-TR*        , 0 AS MATERIAL_CHRG                                             
MFA-TR*        , 0 AS EQUIP_CHARG_AM                                            
MFA-TR*        , 0 AS CALC_LABOR_CHRG                                           
MFA-TR*        , 0 AS OTHER_CHRG                                                
MFA-TR*        , 0 AS CONTRACTOR_AM                                             
MFA-TR*        FROM CSS_SO_DATA VO                                              
MFA-TR*        INNER JOIN CSS_SO_ORDER_INST VI                                  
MFA-TR*        ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                           
MFA-TR*        AND VI.METER_NO <> ''                                            
MFA-TR*        AND VI.METER_NO IS NOT NULL                                      
MFA-TR*        LEFT OUTER JOIN CSS_SO_REQUIREMENT EG                            
MFA-TR*        ON VO.SERV_ORDER_NO = EG.SERV_ORDER_NO                           
MFA-TR*        AND EG.REQMNT_STAGE_CD = 'C'                                     
MFA-TR*        AND EG.SERV_ORDER_STATUS = 50                                    
MFA-TR*        INNER JOIN CSS_NAME_ACCT_XREF HT                                 
MFA-TR*        ON VO.ACCOUNT_NO = HT.ACCOUNT_NO                                 
MFA-TR*        AND HT.CUSTOMER_ROLE_CD = ''                                     
MFA-TR*        INNER JOIN CSS_NAME DQ                                           
MFA-TR*        ON HT.NAME_ID = DQ.NAME_ID                                       
MFA-TR*        AND DQ.NAME_TYPE = 'CN'                                          
MFA-TR*        LEFT OUTER JOIN CSS_SO_UTILITY VT                                
MFA-TR*        ON VO.SERV_ORDER_NO = VT.SERV_ORDER_NO                           
MFA-TR*        AND VI.CODE_UTIL_TYPE =  VT.CODE_UTIL_TYPE                       
MFA-TR*        LEFT OUTER JOIN CSS_SO_UTL_CHG VE                                
MFA-TR*        ON VO.SERV_ORDER_NO = VE.SERV_ORDER_NO                           
MFA-TR*        AND VI.CODE_UTIL_TYPE = VE.CODE_UTIL_TYPE                        
MFA-TR*        LEFT OUTER JOIN CSS_PREM_GAS_LINE PG                             
MFA-TR*        ON VO.PREMISE_NO = PG.PREMISE_NO                                 
MFA-TR*        LEFT OUTER JOIN CSS_MTRD_ENVRNMT ME                              
MFA-TR*        ON VO.ACCOUNT_NO = ME.ACCOUNT_NO                                 
MFA-TR*        AND VI.CODE_UTIL_TYPE = ME.CODE_UTIL_TYPE                        
MFA-TR*        AND ME.CODE_METER_STATUS = 'K'                                   
MFA-TR*                                                                         
MFA-TR*        WHERE VO.ORDER_TYPE_CD = 'FM002'                                 
MFA-TR*        AND VI.WORK_TYPE_CD = 'SET'                                      
MFA-TR*        AND VO.ORDER_STATE_CD = 'Z'                                      
MFA-TR*        AND VI.CODE_UTIL_TYPE = 'G'                                      
MFA-TR*        AND (   VT.CODE_REVENUE_CLASS IS NOT NULL                        
MFA-TR*             OR VE.CODE_REVENUE_CLASS IS NOT NULL)                       
MFA-TR*        AND VO.ACCOUNT_TYPE_CODE  <> 'D'                                 
MFA-TR*        AND EG.REQMNT_COMP_DT >= :WS-START-DATE-TIME                     
MFA-TR*        AND ME.ACCOUNT_NO IS NULL                                        
MFA-TR*        AND VO.COMPANY_NO = '26'                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE NEW_SERV_APPL_CUR CURSOR FOR                      
                SELECT                                                  
                  CASE WHEN LA.APPLIANCE_CD IN ('WH', 'WV', 'WD')       
                         THEN 'WH;'                                     
                       WHEN LA.APPLIANCE_CD IN ('WT')                   
                         THEN 'WT;'                                     
                       WHEN LA.APPLIANCE_CD IN ('GG', 'GR')             
                         THEN 'GG;'                                     
                       WHEN LA.APPLIANCE_CD IN ('LG', 'FP')             
                         THEN 'LG;'                                     
                       WHEN LA.APPLIANCE_CD                             
                         IN ('BO', 'DF', 'FF', 'GP', 'HD', 'HV'         
                             , 'HY', 'WF', 'CU', 'CV', 'DV', 'HC')      
                         THEN 'HS;'                                     
                       WHEN LA.APPLIANCE_CD                             
                         IN ('BB', 'HH', 'SH', 'IR', 'SU', 'TU', 'UH')  
                         THEN 'SH;'                                     
                       WHEN LA.APPLIANCE_CD IN ('GL')                   
                         THEN 'GL;'                                     
                       WHEN LA.APPLIANCE_CD IN ('FT')                   
                         THEN 'OF;'                                     
                       WHEN LA.APPLIANCE_CD IN ('PH')                   
                         THEN 'PH;'                                     
                       WHEN LA.APPLIANCE_CD IN ('DR')                   
                         THEN 'CD;'                                     
                       WHEN LA.APPLIANCE_CD                             
                         IN ('DE', 'MC', 'OV', 'RG', 'RA')              
                         THEN 'RO;'                                     
                       WHEN LA.APPLIANCE_CD                             
                         IN ('CR', 'DC', 'PG', 'WC')                    
                         THEN 'CE;'                                     
                       WHEN LA.APPLIANCE_CD                             
                         IN ('AC', 'CN', 'GN', 'DW', 'MI', 'WA')        
                         THEN 'OT;'                                     
                       ELSE '' END AS MATL_ITEM_TX                      
                                                                        
                FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED)                     
                                                                        
                WHERE LA.PREMISE_NO = :WS-PREMISE-NO                    
SCEG01*         AND LA.COMPANY_NO = '26'                                        
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE NEW_SERV_APPL_CUR CURSOR FOR                              
MFA-TR*         SELECT                                                          
MFA-TR*           CASE WHEN LA.APPLIANCE_CD IN ('WH', 'WV', 'WD')               
MFA-TR*                  THEN 'WH;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD IN ('WT')                           
MFA-TR*                  THEN 'WT;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD IN ('GG', 'GR')                     
MFA-TR*                  THEN 'GG;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD IN ('LG', 'FP')                     
MFA-TR*                  THEN 'LG;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD                                     
MFA-TR*                  IN ('BO', 'DF', 'FF', 'GP', 'HD', 'HV'                 
MFA-TR*                      , 'HY', 'WF', 'CU', 'CV', 'DV', 'HC')              
MFA-TR*                  THEN 'HS;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD                                     
MFA-TR*                  IN ('BB', 'HH', 'SH', 'IR', 'SU', 'TU', 'UH')          
MFA-TR*                  THEN 'SH;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD IN ('GL')                           
MFA-TR*                  THEN 'GL;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD IN ('FT')                           
MFA-TR*                  THEN 'OF;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD IN ('PH')                           
MFA-TR*                  THEN 'PH;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD IN ('DR')                           
MFA-TR*                  THEN 'CD;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD                                     
MFA-TR*                  IN ('DE', 'MC', 'OV', 'RG', 'RA')                      
MFA-TR*                  THEN 'RO;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD                                     
MFA-TR*                  IN ('CR', 'DC', 'PG', 'WC')                            
MFA-TR*                  THEN 'CE;'                                             
MFA-TR*                WHEN LA.APPLIANCE_CD                                     
MFA-TR*                  IN ('AC', 'CN', 'GN', 'DW', 'MI', 'WA')                
MFA-TR*                  THEN 'OT;'                                             
MFA-TR*                ELSE '' END AS MATL_ITEM_TX                              
MFA-TR*                                                                         
MFA-TR*         FROM CSS_APPLIANCE LA                                           
MFA-TR*                                                                         
MFA-TR*         WHERE LA.PREMISE_NO = :WS-PREMISE-NO                            
MFA-TR*         AND LA.COMPANY_NO = '26'                                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *    EXEC SQL                                                             
      *        DECLARE C1 CURSOR WITH RETURN FOR                                
      *        SELECT                                                           
      *            RETURN_CODE                                                  
      *           ,PREMISE_NO                                                   
      *           ,ACCOUNT_NO                                                   
      *           ,CUSTOMER_NO                                                  
      *           ,SERV_ORDER_NO                                                
      *           ,COMPANY_NO                                                   
      *           ,ORDER_TYPE_CD                                                
      *           ,LOCAL_OFFICE                                                 
      *           ,COMPLETED_DATETIME                                           
      *           ,ACCOUNT_TYPE_CODE                                            
      *           ,CUST_CNT_ID                                                  
      *           ,MATERIAL_CHRG                                                
      *           ,EQUIP_CHARG_AM                                               
      *           ,CALC_LABOR_CHRG                                              
      *           ,OTHER_CHRG                                                   
      *           ,CONTRACTOR_AM                                                
      *           ,MATL_ITEM_CD                                                 
      *           ,MATL_ITEM_QT                                                 
      *           ,MATL_ITEM_TOT_AM                                             
      *           ,MATL_ITEM_AM                                                 
      *           ,STRIP(MATL_ITEM_TX) AS MATL_ITEM_TX                          
      *           ,APPLIANCE_CD                                                 
      *        FROM                                                             
      *            SESSION.CSR04783_R1                                          
      *    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  LINK-START-DATE-TIME        PIC  X(26).                      
                                                                        
       PROCEDURE DIVISION USING  LINK-START-DATE-TIME                   
                                 .                                      
                                                                        
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                           
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)            
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)         
      *                                                                         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
           MOVE LINK-START-DATE-TIME  TO PARM-START-DATE-TIME.          
           PERFORM 0100A-DECLARE-GTT                                    
             THRU 0100A-EXIT.                                           
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   RETURN_CODE                                          
                  ,PREMISE_NO                                           
                  ,ACCOUNT_NO                                           
                  ,CUSTOMER_NO                                          
                  ,SERV_ORDER_NO                                        
                  ,COMPANY_NO                                           
                  ,ORDER_TYPE_CD                                        
                  ,LOCAL_OFFICE                                         
                  ,COMPLETED_DATETIME                                   
                  ,ACCOUNT_TYPE_CODE                                    
                  ,CUST_CNT_ID                                          
                  ,MATERIAL_CHRG                                        
                  ,EQUIP_CHARG_AM                                       
                  ,CALC_LABOR_CHRG                                      
                  ,OTHER_CHRG                                           
                  ,CONTRACTOR_AM                                        
                  ,MATL_ITEM_CD                                         
                  ,MATL_ITEM_QT                                         
                  ,MATL_ITEM_TOT_AM                                     
                  ,MATL_ITEM_AM                                         
                  ,MATL_ITEM_TX                                         
                  ,APPLIANCE_CD                                         
               FROM                                                     
                   #CSR04783_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,PREMISE_NO                                                   
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,SERV_ORDER_NO                                                
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,ORDER_TYPE_CD                                                
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*           ,COMPLETED_DATETIME                                           
MFA-TR*           ,ACCOUNT_TYPE_CODE                                            
MFA-TR*           ,CUST_CNT_ID                                                  
MFA-TR*           ,MATERIAL_CHRG                                                
MFA-TR*           ,EQUIP_CHARG_AM                                               
MFA-TR*           ,CALC_LABOR_CHRG                                              
MFA-TR*           ,OTHER_CHRG                                                   
MFA-TR*           ,CONTRACTOR_AM                                                
MFA-TR*           ,MATL_ITEM_CD                                                 
MFA-TR*           ,MATL_ITEM_QT                                                 
MFA-TR*           ,MATL_ITEM_TOT_AM                                             
MFA-TR*           ,MATL_ITEM_AM                                                 
MFA-TR*           ,MATL_ITEM_TX                                                 
MFA-TR*           ,APPLIANCE_CD                                                 
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04783_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04783_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04783_R1
              (                                                          
               RETURN_CODE              INT                         
              ,PREMISE_NO               DECIMAL(10,0)                   
              ,ACCOUNT_NO               DECIMAL(13,0)                   
              ,CUSTOMER_NO              DECIMAL(13,0)                   
              ,SERV_ORDER_NO            DECIMAL(13,0)                   
              ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,ORDER_TYPE_CD CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,LOCAL_OFFICE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,COMPLETED_DATETIME CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,ACCOUNT_TYPE_CODE CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
              ,CUST_CNT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,MATERIAL_CHRG            DECIMAL(9,2)                    
              ,EQUIP_CHARG_AM           DECIMAL(9,2)                    
              ,CALC_LABOR_CHRG          DECIMAL(9,2)                    
              ,OTHER_CHRG               DECIMAL(9,2)                    
              ,CONTRACTOR_AM            DECIMAL(9,2)                    
              ,MATL_ITEM_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,MATL_ITEM_QT             INT                         
              ,MATL_ITEM_TOT_AM         DECIMAL(9,2)                    
              ,MATL_ITEM_AM             DECIMAL(9,2)                    
              ,MATL_ITEM_TX VARCHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                    
              ,APPLIANCE_CD CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 4000-DELETE-GTT-ROWS  THRU 4000-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04783_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS                                           *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-START-DATE-TIME      TO WS-START-DATE-TIME.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *****PROCESS APPLIANCE SALES SERVICE ORDERS                               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           PERFORM 7100-OPEN-SERV-ORDER-CURSOR  THRU 7100-EXIT.         
           PERFORM 7200-FETCH-SERV-ORDER-CURSOR THRU 7200-EXIT.         
           IF WS-SUMM-RETURN-CODE EQUAL SUCCESSFUL-CALL                 
              PERFORM UNTIL WS-SUMM-RETURN-CODE EQUAL NOT-FOUND         
                 MOVE P-SERV-ORDER-NO      TO WS-SERV-ORDER-NO          
                 MOVE 0                    TO WS-ITEM-COUNT             
                 PERFORM 7400-OPEN-APPL-ITEM-CURSOR THRU 7400-EXIT      
                 PERFORM 7500-FETCH-APPL-ITEM-CURSOR THRU 7500-EXIT     
                 IF WS-ITEM-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                    PERFORM UNTIL WS-ITEM-RETURN-CODE EQUAL NOT-FOUND   
                      PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT         
                      PERFORM 8100-SEND-RESULT  THRU 8100-EXIT          
                      PERFORM 7500-FETCH-APPL-ITEM-CURSOR THRU 7500-EXIT
                    END-PERFORM                                         
                 END-IF                                                 
                 IF WS-ITEM-RETURN-CODE EQUAL NOT-FOUND                 
                    AND WS-ITEM-COUNT EQUAL 0                           
                       PERFORM 2100A-MOVE-JOBBING-RESULT THRU 2100A-EXIT
                       PERFORM 8100-SEND-RESULT  THRU 8100-EXIT         
                 END-IF                                                 
                 PERFORM 7600-CLOSE-APPL-ITEM-CURSOR THRU 7600-EXIT     
                 INITIALIZE GTT-RETURN-FIELDS                           
                 PERFORM 7200-FETCH-SERV-ORDER-CURSOR    THRU 7200-EXIT 
              END-PERFORM                                               
           ELSE                                                         
                 PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT          
                 PERFORM 8100-SEND-RESULT      THRU 8100-EXIT           
           END-IF                                                       
           PERFORM 7300-CLOSE-SERV-ORDER-CURSOR THRU 7300-EXIT.         
                                                                        
      *****PROCESS NEW SERVICE SERVICE ORDERS                                   
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           PERFORM 7701-OPEN-NEW-SERV-CUR     THRU 7701-EXIT.           
           PERFORM 7702-FETCH-NEW-SERVICE-CUR THRU 7702-EXIT.           
           IF WS-SUMM-RETURN-CODE EQUAL SUCCESSFUL-CALL                 
              PERFORM UNTIL WS-SUMM-RETURN-CODE EQUAL NOT-FOUND         
                 MOVE P-PREMISE-NO         TO WS-PREMISE-NO             
                 MOVE 0                    TO WS-ITEM-COUNT             
                 PERFORM 7801-OPEN-NEW-SERV-APPL-CUR  THRU 7801-EXIT    
                 PERFORM 7802-FETCH-NEW-SERV-APPL-CUR THRU 7802-EXIT    
                 IF WS-ITEM-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                    MOVE 1                      TO WS-APPL-ITEM-INDEX   
                    MOVE SPACES                 TO WS-APPL-STRING-TX    
                    PERFORM UNTIL WS-ITEM-RETURN-CODE EQUAL NOT-FOUND   
                     PERFORM 7804-BUILD-APPL-TX THRU 7804-EXIT          
                     PERFORM 7802-FETCH-NEW-SERV-APPL-CUR THRU 7802-EXIT
                    END-PERFORM                                         
                    MOVE SPACES                 TO P-MATL-ITEM-CD       
                    MOVE 1                      TO P-MATL-ITEM-QT       
                    MOVE 0                      TO P-MATL-ITEM-TOT-AM   
                    MOVE 0                      TO P-MATL-ITEM-AM       
                    MOVE WS-APPL-STRING-TX      TO P-MATL-ITEM-TX       
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT  THRU 8100-EXIT            
                 END-IF                                                 
                 IF WS-ITEM-RETURN-CODE EQUAL NOT-FOUND                 
                    AND WS-ITEM-COUNT EQUAL 0                           
                       PERFORM 2100B-MOVE-EMPTY-RESULT THRU 2100B-EXIT  
                       PERFORM 8100-SEND-RESULT  THRU 8100-EXIT         
                 END-IF                                                 
                 PERFORM 7803-CLOSE-NEW-SERV-APPL-CUR THRU 7803-EXIT    
                 INITIALIZE GTT-RETURN-FIELDS                           
                 PERFORM 7702-FETCH-NEW-SERVICE-CUR   THRU 7702-EXIT    
              END-PERFORM                                               
      *    ELSE                                                                 
      *          PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT                  
      *          PERFORM 8100-SEND-RESULT      THRU 8100-EXIT                   
           END-IF                                                       
           PERFORM 7703-CLOSE-NEW-SERVICE-CUR THRU 7703-EXIT.           
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
      *                                                                         
      *    MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE.                        
           MOVE P-PREMISE-NO           TO S-PREMISE-NO.                 
           MOVE P-ACCOUNT-NO           TO S-ACCOUNT-NO.                 
           MOVE P-CUSTOMER-NO          TO S-CUSTOMER-NO.                
           MOVE P-SERV-ORDER-NO        TO S-SERV-ORDER-NO.              
           MOVE P-COMPANY-NO           TO S-COMPANY-NO.                 
           MOVE P-ORDER-TYPE-CD        TO S-ORDER-TYPE-CD.              
           MOVE P-LOCAL-OFFICE         TO S-LOCAL-OFFICE.               
           MOVE P-COMPLETED-DATETIME   TO S-COMPLETED-DATETIME.         
           MOVE P-ACCOUNT-TYPE-CODE    TO S-ACCOUNT-TYPE-CODE.          
           MOVE P-CUST-CNT-ID          TO S-CUST-CNT-ID.                
           MOVE P-MATERIAL-CHRG        TO S-MATERIAL-CHRG.              
           MOVE P-EQUIP-CHARG-AM       TO S-EQUIP-CHARG-AM.             
           MOVE P-CALC-LABOR-CHRG      TO S-CALC-LABOR-CHRG.            
           MOVE P-OTHER-CHRG           TO S-OTHER-CHRG.                 
           MOVE P-CONTRACTOR-AM        TO S-CONTRACTOR-AM.              
           MOVE P-MATL-ITEM-CD         TO S-MATL-ITEM-CD.               
           MOVE P-MATL-ITEM-QT         TO S-MATL-ITEM-QT.               
           MOVE P-MATL-ITEM-TOT-AM     TO S-MATL-ITEM-TOT-AM.           
           MOVE P-MATL-ITEM-AM         TO S-MATL-ITEM-AM.               
           MOVE P-MATL-ITEM-TX         TO S-MATL-ITEM-TX.               
      *    MOVE P-APPLIANCE-CD         TO S-APPLIANCE-CD.                       
           MOVE P-CUSTOMER-NO          TO S-APPLIANCE-CD.               
           ADD +1                      TO WS-ITEM-COUNT.                
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2100A-MOVE-JOBBING-RESULT.                                    *         
      *****************************************************************         
       2100A-MOVE-JOBBING-RESULT.                                       
      *                                                                         
      *    MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE.                        
           MOVE P-PREMISE-NO           TO S-PREMISE-NO.                 
           MOVE P-ACCOUNT-NO           TO S-ACCOUNT-NO.                 
           MOVE P-CUSTOMER-NO          TO S-CUSTOMER-NO.                
           MOVE P-SERV-ORDER-NO        TO S-SERV-ORDER-NO.              
           MOVE P-COMPANY-NO           TO S-COMPANY-NO.                 
           MOVE P-ORDER-TYPE-CD        TO S-ORDER-TYPE-CD.              
           MOVE P-LOCAL-OFFICE         TO S-LOCAL-OFFICE.               
           MOVE P-COMPLETED-DATETIME   TO S-COMPLETED-DATETIME.         
           MOVE P-ACCOUNT-TYPE-CODE    TO S-ACCOUNT-TYPE-CODE.          
           MOVE P-CUST-CNT-ID          TO S-CUST-CNT-ID.                
           MOVE P-MATERIAL-CHRG        TO S-MATERIAL-CHRG.              
           MOVE P-EQUIP-CHARG-AM       TO S-EQUIP-CHARG-AM.             
           MOVE P-CALC-LABOR-CHRG      TO S-CALC-LABOR-CHRG.            
           MOVE P-OTHER-CHRG           TO S-OTHER-CHRG.                 
           MOVE P-CONTRACTOR-AM        TO S-CONTRACTOR-AM.              
           MOVE '99999'                TO S-MATL-ITEM-CD.               
           MOVE 1                      TO S-MATL-ITEM-QT.               
           MOVE P-MATERIAL-CHRG        TO S-MATL-ITEM-TOT-AM.           
           MOVE P-MATERIAL-CHRG        TO S-MATL-ITEM-AM.               
           MOVE ' '                    TO S-MATL-ITEM-TX.               
      *    MOVE 'JJ'                   TO S-APPLIANCE-CD.                       
           MOVE P-CUSTOMER-NO          TO S-APPLIANCE-CD.               
       2100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2100B-MOVE-EMPTY-RESULT.                                      *         
      *****************************************************************         
       2100B-MOVE-EMPTY-RESULT.                                         
      *                                                                         
      *    MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE.                        
           MOVE P-PREMISE-NO           TO S-PREMISE-NO.                 
           MOVE P-ACCOUNT-NO           TO S-ACCOUNT-NO.                 
           MOVE P-CUSTOMER-NO          TO S-CUSTOMER-NO.                
           MOVE P-SERV-ORDER-NO        TO S-SERV-ORDER-NO.              
           MOVE P-COMPANY-NO           TO S-COMPANY-NO.                 
           MOVE P-ORDER-TYPE-CD        TO S-ORDER-TYPE-CD.              
           MOVE P-LOCAL-OFFICE         TO S-LOCAL-OFFICE.               
           MOVE P-COMPLETED-DATETIME   TO S-COMPLETED-DATETIME.         
           MOVE P-ACCOUNT-TYPE-CODE    TO S-ACCOUNT-TYPE-CODE.          
           MOVE P-CUST-CNT-ID          TO S-CUST-CNT-ID.                
           MOVE P-MATERIAL-CHRG        TO S-MATERIAL-CHRG.              
           MOVE P-EQUIP-CHARG-AM       TO S-EQUIP-CHARG-AM.             
           MOVE P-CALC-LABOR-CHRG      TO S-CALC-LABOR-CHRG.            
           MOVE P-OTHER-CHRG           TO S-OTHER-CHRG.                 
           MOVE P-CONTRACTOR-AM        TO S-CONTRACTOR-AM.              
           MOVE '99999'                TO S-MATL-ITEM-CD.               
           MOVE 0                      TO S-MATL-ITEM-QT.               
           MOVE P-MATERIAL-CHRG        TO S-MATL-ITEM-TOT-AM.           
           MOVE P-MATERIAL-CHRG        TO S-MATL-ITEM-AM.               
           MOVE ' '                    TO S-MATL-ITEM-TX.               
      *    MOVE 'XX'                   TO S-APPLIANCE-CD.                       
           MOVE P-CUSTOMER-NO          TO S-APPLIANCE-CD.               
       2100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      *              4000-DELETE-GTT-ROWS.                           *          
      ****************************************************************          
       4000-DELETE-GTT-ROWS.                                            
           MOVE '4000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04783_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04783_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4000'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04783_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              PERFORM 9900-SQL-ERROR-ROUTINE                            
      *                                                                         
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7100-OPEN-SERV-ORDER-CURSOR                                 *        
      *       OPEN THE SERV_ORDER_CUR CURSOR                           *        
      ******************************************************************        
                                                                        
       7100-OPEN-SERV-ORDER-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN APPL_SUMM_CUR                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SO_DATA'              TO TABLE-1               
               MOVE 'START DATE'               TO TABLE-ELEMENT-1       
               MOVE WS-START-DATE-TIME         TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7200-FETCH-SERV-ORDER-CURSOR                                *        
      *       FETCH THE SERV-ORD-CUR    CURSOR                         *        
      *                                                                *        
      ******************************************************************        
       7200-FETCH-SERV-ORDER-CURSOR.                                    
           EXEC SQL                                                     
                FETCH APPL_SUMM_CUR                                     
                 INTO  :P-PREMISE-NO                                    
                      ,:P-ACCOUNT-NO                                    
                      ,:P-CUSTOMER-NO                                   
                      ,:P-SERV-ORDER-NO                                 
                      ,:P-COMPANY-NO                                    
                      ,:P-ORDER-TYPE-CD                                 
                      ,:P-LOCAL-OFFICE                                  
                      ,:P-COMPLETED-DATETIME                            
                      ,:P-ACCOUNT-TYPE-CODE                             
                      ,:P-CUST-CNT-ID                                   
                      ,:P-MATERIAL-CHRG                                 
                      ,:P-EQUIP-CHARG-AM                                
                      ,:P-CALC-LABOR-CHRG                               
                      ,:P-OTHER-CHRG                                    
                      ,:P-CONTRACTOR-AM                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                  WS-SUMM-RETURN-CODE.  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_SO_DATA'              TO TABLE-1               
               MOVE 'START DATE'               TO TABLE-ELEMENT-1       
               MOVE WS-START-DATE-TIME         TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7300-CLOSE-SERV-ORDER-CURSOR                                *        
      *       CLOSE THE SERV-ORD-CUR                                   *        
      ******************************************************************        
       7300-CLOSE-SERV-ORDER-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE APPL_SUMM_CUR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SO_DATA'              TO TABLE-1               
               MOVE 'START DATE'               TO TABLE-ELEMENT-1       
               MOVE WS-START-DATE-TIME         TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7400-OPEN-APPL-ITEM-CURSOR                                  *        
      *       OPEN THE APPL_ITEM_CUR  CURSOR                           *        
      ******************************************************************        
                                                                        
       7400-OPEN-APPL-ITEM-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN APPL_ITEM_CUR                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                  WS-ITEM-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SO_MATL_TRAN'         TO TABLE-1               
               MOVE 'SERV_ORDER'               TO TABLE-ELEMENT-1       
               MOVE WS-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7500-FETCH-APPL-ITEM-CURSOR                                 *        
      *       FETCH THE APPL_ITEM_CUR   CURSOR                         *        
      *                                                                *        
      ******************************************************************        
       7500-FETCH-APPL-ITEM-CURSOR.                                     
           EXEC SQL                                                     
                FETCH APPL_ITEM_CUR                                     
                 INTO  :P-MATL-ITEM-CD                                  
                      ,:P-MATL-ITEM-QT                                  
                      ,:P-MATL-ITEM-TX                                  
                      ,:P-APPLIANCE-CD                                  
                      ,:P-MATL-ITEM-TOT-AM                              
                      ,:P-MATL-ITEM-AM                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                  WS-ITEM-RETURN-CODE.  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7500'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_SO_MATL_TRAN'         TO TABLE-1               
               MOVE 'SERV_ORDER'               TO TABLE-ELEMENT-1       
               MOVE WS-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7600-CLOSE-APPL-ITEM-CURSOR                                 *        
      *       CLOSE THE APPL_ITEM_CUR                                  *        
      ******************************************************************        
       7600-CLOSE-APPL-ITEM-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE APPL_ITEM_CUR                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7600'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SO_MATL_TRAN'         TO TABLE-1               
               MOVE 'SERV_ORDER'               TO TABLE-ELEMENT-1       
               MOVE WS-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *    7701-OPEN-NEW-SERV-CURSOR                                   *        
      *       OPEN THE NEW_SERVICE_CUR CURSOR                          *        
      ******************************************************************        
                                                                        
       7701-OPEN-NEW-SERV-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN NEW_SERVICE_CUR                                    
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7701'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SO_DATA'              TO TABLE-1               
               MOVE 'START DATE'               TO TABLE-ELEMENT-1       
               MOVE WS-START-DATE-TIME         TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7701-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7702-FETCH-NEW-SERV-CURSOR                                  *        
      *       FETCH THE NEW_SERVICE_CUR CURSOR                         *        
      *                                                                *        
      ******************************************************************        
       7702-FETCH-NEW-SERVICE-CUR.                                      
           EXEC SQL                                                     
                FETCH NEW_SERVICE_CUR                                   
                 INTO  :P-PREMISE-NO                                    
                      ,:P-ACCOUNT-NO                                    
                      ,:P-CUSTOMER-NO                                   
                      ,:P-SERV-ORDER-NO                                 
                      ,:P-COMPANY-NO                                    
                      ,:P-ORDER-TYPE-CD                                 
                      ,:P-LOCAL-OFFICE                                  
                      ,:P-COMPLETED-DATETIME                            
                      ,:P-ACCOUNT-TYPE-CODE                             
                      ,:P-CUST-CNT-ID                                   
                      ,:P-MATERIAL-CHRG                                 
                      ,:P-EQUIP-CHARG-AM                                
                      ,:P-CALC-LABOR-CHRG                               
                      ,:P-OTHER-CHRG                                    
                      ,:P-CONTRACTOR-AM                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                  WS-SUMM-RETURN-CODE.  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7702'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_SO_DATA'              TO TABLE-1               
               MOVE 'START DATE'               TO TABLE-ELEMENT-1       
               MOVE WS-START-DATE-TIME         TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7702-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7703-CLOSE-NEW-SERVICE-CURSOR                               *        
      *       CLOSE THE NEW_SERVICE_CUR                                         
      ******************************************************************        
       7703-CLOSE-NEW-SERVICE-CUR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE NEW_SERVICE_CUR                                   
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7703'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SO_DATA'              TO TABLE-1               
               MOVE 'START DATE'               TO TABLE-ELEMENT-1       
               MOVE WS-START-DATE-TIME         TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7703-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7801-OPEN-NEW-SERV-APPL CURSOR                              *        
      *       OPEN THE NEW_SERV_APPL_CUR CURSOR                        *        
      ******************************************************************        
                                                                        
       7801-OPEN-NEW-SERV-APPL-CUR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN NEW_SERV_APPL_CUR                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                  WS-ITEM-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7801'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_APPLIANCE'            TO TABLE-1               
               MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1       
               MOVE S-PREMISE-NO               TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7801-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7802-FETCH-NEW-SERV-APPL-CURSOR                             *        
      *       FETCH THE NEW_SERV_APPL CURSOR                           *        
      ******************************************************************        
       7802-FETCH-NEW-SERV-APPL-CUR.                                    
           EXEC SQL                                                     
                FETCH NEW_SERV_APPL_CUR                                 
                 INTO  :P-APPLIANCE-CD-SERV                             
      *          INTO  :P-MATL-ITEM-CD                                          
      *               ,:P-MATL-ITEM-QT                                          
      *               ,:P-MATL-ITEM-TX                                          
      *               ,:P-APPLIANCE-CD                                          
      *               ,:P-MATL-ITEM-TOT-AM                                      
      *               ,:P-MATL-ITEM-AM                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                  WS-ITEM-RETURN-CODE.  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7802'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_APPLIANCE'            TO TABLE-1               
               MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1       
               MOVE S-PREMISE-NO               TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7802-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7803-CLOSE-NEW-SERV-APPL-CURSOR                             *        
      *       CLOSE THE NEW_SERV_APPL_CUR                              *        
      ******************************************************************        
       7803-CLOSE-NEW-SERV-APPL-CUR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE NEW_SERV_APPL_CUR                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7803'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_APPLIANCE'            TO TABLE-1               
               MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1       
               MOVE S-PREMISE-NO               TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7803-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7804-BUILD-APPL-TX                                           *        
      *       BUILD THE APPLIANCE TEXT STRING                          *        
      ******************************************************************        
       7804-BUILD-APPL-TX.                                              
           MOVE P-APPLIANCE-CD-SERV                                     
                                 TO WS-APPL-ITEM-TX(WS-APPL-ITEM-INDEX).
           ADD +1                           TO WS-APPL-ITEM-INDEX.      
       7804-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8100-SEND-RESULT                                            *           
      ***************************************************************           
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04783_R1                         
      *         (                                                               
      *              RETURN_CODE                                                
      *             ,PREMISE_NO                                                 
      *             ,ACCOUNT_NO                                                 
      *             ,CUSTOMER_NO                                                
      *             ,SERV_ORDER_NO                                              
      *             ,COMPANY_NO                                                 
      *             ,ORDER_TYPE_CD                                              
      *             ,LOCAL_OFFICE                                               
      *             ,COMPLETED_DATETIME                                         
      *             ,ACCOUNT_TYPE_CODE                                          
      *             ,CUST_CNT_ID                                                
      *             ,MATERIAL_CHRG                                              
      *             ,EQUIP_CHARG_AM                                             
      *             ,CALC_LABOR_CHRG                                            
      *             ,OTHER_CHRG                                                 
      *             ,CONTRACTOR_AM                                              
      *             ,MATL_ITEM_CD                                               
      *             ,MATL_ITEM_QT                                               
      *             ,MATL_ITEM_TOT_AM                                           
      *             ,MATL_ITEM_AM                                               
      *             ,MATL_ITEM_TX                                               
      *             ,APPLIANCE_CD                                               
      *         )                                                               
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-PREMISE-NO                                      
                    ,:S-ACCOUNT-NO                                      
                    ,:S-CUSTOMER-NO                                     
                    ,:S-SERV-ORDER-NO                                   
                    ,:S-COMPANY-NO                                      
                    ,:S-ORDER-TYPE-CD                                   
                    ,:S-LOCAL-OFFICE                                    
                    ,:S-COMPLETED-DATETIME                              
                    ,:S-ACCOUNT-TYPE-CODE                               
                    ,:S-CUST-CNT-ID                                     
                    ,:S-MATERIAL-CHRG                                   
                    ,:S-EQUIP-CHARG-AM                                  
                    ,:S-CALC-LABOR-CHRG                                 
                    ,:S-OTHER-CHRG                                      
                    ,:S-CONTRACTOR-AM                                   
                    ,:S-MATL-ITEM-CD                                    
                    ,:S-MATL-ITEM-QT                                    
                    ,:S-MATL-ITEM-TOT-AM                                
                    ,:S-MATL-ITEM-AM                                    
                    ,:S-MATL-ITEM-TX                                    
                    ,:S-APPLIANCE-CD                                    
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04783_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,SERV_ORDER_NO                                              
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,ORDER_TYPE_CD                                              
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,COMPLETED_DATETIME                                         
MFA-TR*             ,ACCOUNT_TYPE_CODE                                          
MFA-TR*             ,CUST_CNT_ID                                                
MFA-TR*             ,MATERIAL_CHRG                                              
MFA-TR*             ,EQUIP_CHARG_AM                                             
MFA-TR*             ,CALC_LABOR_CHRG                                            
MFA-TR*             ,OTHER_CHRG                                                 
MFA-TR*             ,CONTRACTOR_AM                                              
MFA-TR*             ,MATL_ITEM_CD                                               
MFA-TR*             ,MATL_ITEM_QT                                               
MFA-TR*             ,MATL_ITEM_TOT_AM                                           
MFA-TR*             ,MATL_ITEM_AM                                               
MFA-TR*             ,MATL_ITEM_TX                                               
MFA-TR*             ,APPLIANCE_CD                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-PREMISE-NO                                              
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-CUSTOMER-NO                                             
MFA-TR*             ,:S-SERV-ORDER-NO                                           
MFA-TR*             ,:S-COMPANY-NO                                              
MFA-TR*             ,:S-ORDER-TYPE-CD                                           
MFA-TR*             ,:S-LOCAL-OFFICE                                            
MFA-TR*             ,:S-COMPLETED-DATETIME                                      
MFA-TR*             ,:S-ACCOUNT-TYPE-CODE                                       
MFA-TR*             ,:S-CUST-CNT-ID                                             
MFA-TR*             ,:S-MATERIAL-CHRG                                           
MFA-TR*             ,:S-EQUIP-CHARG-AM                                          
MFA-TR*             ,:S-CALC-LABOR-CHRG                                         
MFA-TR*             ,:S-OTHER-CHRG                                              
MFA-TR*             ,:S-CONTRACTOR-AM                                           
MFA-TR*             ,:S-MATL-ITEM-CD                                            
MFA-TR*             ,:S-MATL-ITEM-QT                                            
MFA-TR*             ,:S-MATL-ITEM-TOT-AM                                        
MFA-TR*             ,:S-MATL-ITEM-AM                                            
MFA-TR*             ,:S-MATL-ITEM-TX                                            
MFA-TR*             ,:S-APPLIANCE-CD                                            
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                    TO CTR-ROWS                     
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04783_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
