       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04782.                                         
       AUTHOR.        VENKAT PONNEKANTI.                                
COB303 DATE-WRITTEN.  JUN 30, 2014.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  CSR04782 RETRIEVE SP FOR EXEMPTIONS SETUP VIEW                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS EXEMPTIONS DETAILS                       *        
      *  RESULTS SETS:                                                 *        
      *     1. EXCEMPTIONS (7)                                         *        
      *        - DISCONNECTION/NOTICES                                 *        
      *        - LPC                                                   *        
      *        - IVR CALLS                                             *        
      *        - COLLECTION AGENCY/CREDIT BUREAU                       *        
      *        - AUTO DEPOSIT - ACCT REVIEW/DNP/RETURN CHECK           *        
      *        - DPP DROP                                              *        
      *        - AUTO TRANSFERS                                        *        
      *        - ARCHIVE                                               *        
      *     2. ARCHIVE FORECAST DETAILS                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *   DATE   INITIALS COMMENTS                                     *        
      * -------- -------- -------------------------------------------- *        
P00726* 06/30/14 VP43661  INITIAL IMPLEMENTATION.                      *        
AP5740* 02/09/16 VV7M72K  Added IVR-NDO-EXEMPT Indicator to RS1.       *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04782'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40) VALUE              
           'WORKING STORAGE FOR CSR04782 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08)  VALUE 'CSR04782'. 
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'CSR04782'. 
           05  WS-CA-XMPT-ATTR             PIC X(08)  VALUE             
                                               'CAEXEMPT'.              
           05  WS-CB-XMPT-ATTR             PIC X(08)  VALUE             
                                               'CBEXEMPT'.              
           05  WS-ACCT-REVIEW-ATTRIB       PIC X(13)  VALUE             
                                               'REVIEW EXEMPT'.         
           05  WS-AUTO-DNP-ATTRIB          PIC X(18)  VALUE             
                                               'AUTODNPDEPEXEMPIND'.    
           05  WS-AUTO-DPP-DROP-ATTRIB     PIC X(18)  VALUE             
                                               'AUTODPPDRPEXEMPIND'.    
           05  WS-AUTO-RTN-CHK-ATTRIB      PIC X(18)  VALUE             
                                               'AUTORETDEPEXEMPIND'.    
           05  WS-AUTO-XFER-ATTRIB         PIC X(18)  VALUE             
                                               'AUTOXFERFBWOEXEMPT'.    
           05  WS-YES                      PIC X(01)  VALUE 'Y'.        
           05  WS-NO-MORE-ROWS             PIC X(01)  VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
           05  WS-CURRENT-DATE             PIC X(10)  VALUE SPACES.     
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                PIC S9(9)  COMP  VALUE 0.    
           05  CTR-ROWS-RS2                PIC S9(9)  COMP  VALUE 0.    
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-R1-RETURN-CODE         PIC S9(9)  COMP  VALUE 0.    
               10 S-R1-APPL-RETURN-CODE    PIC x(10)  VALUE SPACES.     
               10 S-R1-CODE-LPC-XMT        PIC X(01)  VALUE SPACES.     
               10 S-R1-CODE-DISC-OK        PIC X(01)  VALUE SPACES.     
               10 S-R1-NOTICE-EXEMPT-CD    PIC X(01)  VALUE SPACES.     
               10 S-R1-IVR-EXEMPT-CD       PIC X(01)  VALUE SPACES.     
               10 S-R1-DPP-DROP-EXEMPT-CD  PIC X(05)  VALUE SPACES.     
               10 S-R1-DNP-EXEMPT-CD       PIC X(05)  VALUE SPACES.     
               10 S-R1-RETURN-CHK-CD       PIC X(05)  VALUE SPACES.     
               10 S-R1-ACT-REVIEW-CD       PIC X(01)  VALUE SPACES.     
               10 S-R1-CA-EXEMPT-CD        PIC X(05)  VALUE SPACES.     
               10 S-R1-CB-EXEMPT-CD        PIC X(05)  VALUE SPACES.     
               10 S-R1-ARCH-EXEMPT-CD      PIC X(01)  VALUE SPACES.     
               10 S-R1-AUTO-XFER-XMPT-CD   PIC X(10)  VALUE SPACES.     
AP5740         10 S-R1-IVR-NDO-EXEMPT      PIC X(01)  VALUE SPACES.     
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-R2-RETURN-CODE         PIC S9(9)  COMP VALUE 0.     
               10 S-R2-FCST-TYPE-CD        PIC X(01)  VALUE SPACES.     
               10 S-R2-FCST-REASON-CD      PIC X(01)  VALUE SPACES.     
               10 S-R2-FCST-DT             PIC X(10)  VALUE SPACES.     
               10 S-R2-FINALED-DT          PIC X(26)  VALUE SPACES.     
               10 S-R2-LST-UPD-TS          PIC X(26)  VALUE SPACES.     
               10 S-R2-LST-UPD-BY-ID       PIC X(07)  VALUE SPACES.     
               10 S-R2-REMARKS             PIC X(200) VALUE SPACES.     
                                                                        
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                 PIC X(05)  VALUE SPACES.     
           05  WS-GTT-NAME                 PIC X(19)  VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ARCHIEVE_EXEMPT - AA                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACXMPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT - AT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ARCHIEVE_FCST - AZ                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCFCS                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE  - YP                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
AP5740******************************************************************        
AP5740*    CSS_CUST_MISC_INFO                                          *        
AP5740******************************************************************        
AP5740                                                                  
AP5740     EXEC SQL                                                             
AP5740        INCLUDE TBCSTMSC                                                  
AP5740     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWSSP001.                                                       
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      * CURSOR TO RETRIEVE THE ROWS FROM THE CSS_ARCHIVE_FCST          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE ATTRIBUTE_CSR CURSOR FOR                          
              SELECT                                                    
                     ATTRIBUTE_DESC                                     
                    ,ATTRIBUTE_VALUE_CD                                 
                    ,ATTRIBUTE_VALUE_DT                                 
                FROM                                                    
                     CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     ACCOUNT_NO     = :YP-ACCOUNT-NO                    
                 AND ATTRIBUTE_DESC IN ('CAEXEMPT'                      
                                       ,'CBEXEMPT'                      
                                       ,'REVIEW EXEMPT'                 
                                       ,'AUTODNPDEPEXEMPIND'            
                                       ,'AUTODPPDRPEXEMPIND'            
                                       ,'AUTORETDEPEXEMPIND'            
                                       ,'AUTOXFERFBWOEXEMPT'            
                                       )                                
                 FOR READ ONLY                                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ATTRIBUTE_CSR CURSOR FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*              ATTRIBUTE_DESC                                             
MFA-TR*             ,ATTRIBUTE_VALUE_CD                                         
MFA-TR*             ,ATTRIBUTE_VALUE_DT                                         
MFA-TR*         FROM                                                    07930211
MFA-TR*              CSS_ACCT_ATTRIBUTE                                 07930211
MFA-TR*        WHERE                                                    07930314
MFA-TR*              ACCOUNT_NO     = :YP-ACCOUNT-NO                    07930314
MFA-TR*          AND ATTRIBUTE_DESC IN ('CAEXEMPT'                      07930411
MFA-TR*                                ,'CBEXEMPT'                              
MFA-TR*                                ,'REVIEW EXEMPT'                         
MFA-TR*                                ,'AUTODNPDEPEXEMPIND'                    
MFA-TR*                                ,'AUTODPPDRPEXEMPIND'                    
MFA-TR*                                ,'AUTORETDEPEXEMPIND'                    
MFA-TR*                                ,'AUTOXFERFBWOEXEMPT'                    
MFA-TR*                                )                                        
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE ARCHFCT_CSR CURSOR FOR                            
                SELECT                                                  
                 COALESCE(AZ.FORECAST_TYPE_CD, ' ')                       
                ,COALESCE(AZ.FORECAST_REASON_CD, ' ')                     
                ,COALESCE((CIS.CHAR2$DATE(
           AZ.FORECAST_DT,'USA')),'2999-12-31')  
                ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           AZ.LAST_UPDATE_TS,CIS.CHAR2TIMESTAMP(
              '2999-12-31-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.') 
                ,COALESCE(AZ.LAST_UPDATE_USERID,'  ')                     
                ,COALESCE(AZ.REMARKS, ' ')                                
                ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           AZ.ACCT_FINALED_DT,CIS.CHAR2TIMESTAMP(
              '2999-12-31-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')
                FROM                                                    
                       CSS_ARCHIVE_FCST AZ WITH(READUNCOMMITTED)                
                WHERE                                                   
                      AZ.ACCOUNT_NO = :AZ-ACCOUNT-NO                    
                FOR READ ONLY                                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARCHFCT_CSR CURSOR FOR                                    
MFA-TR*         SELECT                                                          
MFA-TR*          IFNULL(AZ.FORECAST_TYPE_CD, ' ')                               
MFA-TR*         ,IFNULL(AZ.FORECAST_REASON_CD, ' ')                             
MFA-TR*         ,IFNULL((CHAR(DATE(AZ.FORECAST_DT),USA)),'2999-12-31')          
MFA-TR*         ,IFNULL(AZ.LAST_UPDATE_TS,'2999-12-31-00.00.00.000000')         
MFA-TR*         ,IFNULL(AZ.LAST_UPDATE_USERID,'  ')                             
MFA-TR*         ,IFNULL(AZ.REMARKS, ' ')                                        
MFA-TR*         ,IFNULL(AZ.ACCT_FINALED_DT,'2999-12-31-00.00.00.000000')        
MFA-TR*         FROM                                                            
MFA-TR*                CSS_ARCHIVE_FCST AZ                                      
MFA-TR*         WHERE                                                           
MFA-TR*               AZ.ACCOUNT_NO = :AZ-ACCOUNT-NO                            
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO             PIC 9(13).                       
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
           PERFORM 7010-GET-CURRENT-DATE    THRU 7010-EXIT.             
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                  :S-R1-RETURN-CODE                AS RETURN_CODE       
                 ,LTRIM(RTRIM(:S-R1-APPL-RETURN-CODE))    AS 
           APPL_RETURN_CODE  
                 ,LTRIM(RTRIM(:S-R1-CODE-LPC-XMT))        AS 
           CODE_LPC_XMT      
                 ,LTRIM(RTRIM(:S-R1-CODE-DISC-OK))        AS 
           CODE_DISK_OK      
                 ,LTRIM(RTRIM(:S-R1-NOTICE-EXEMPT-CD))    AS 
           NOTICE_EXEMPT_CD  
                 ,LTRIM(RTRIM(:S-R1-IVR-EXEMPT-CD))       AS 
           IVR_EXEMPT_CD     
                 ,LTRIM(RTRIM(:S-R1-DPP-DROP-EXEMPT-CD))  AS 
           DPP_DROP_EXEMPT_CD
                 ,LTRIM(RTRIM(:S-R1-DNP-EXEMPT-CD))       AS 
           DNP_EXEMPT_CD     
                 ,LTRIM(RTRIM(:S-R1-RETURN-CHK-CD))       AS 
           RETURN_CHK_CD     
                 ,LTRIM(RTRIM(:S-R1-ACT-REVIEW-CD))       AS 
           ACT_REVIEW_CD     
                 ,LTRIM(RTRIM(:S-R1-CA-EXEMPT-CD))        AS 
           CA_EXEMPT_CD      
                 ,LTRIM(RTRIM(:S-R1-CB-EXEMPT-CD))        AS 
           CB_EXEMPT_CD      
                 ,LTRIM(RTRIM(:S-R1-ARCH-EXEMPT-CD))      AS 
           ARCH_EXEMPT_CD    
                 ,LTRIM(RTRIM(:S-R1-AUTO-XFER-XMPT-CD))   AS 
           AUTO_XFER_XMPT_CD 
AP5740           ,LTRIM(RTRIM(:S-R1-IVR-NDO-EXEMPT))      AS 
           IVR_NDO_EXEMPT    
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-R1-RETURN-CODE                AS RETURN_CODE               
MFA-TR*          ,STRIP(:S-R1-APPL-RETURN-CODE)    AS APPL_RETURN_CODE          
MFA-TR*          ,STRIP(:S-R1-CODE-LPC-XMT)        AS CODE_LPC_XMT              
MFA-TR*          ,STRIP(:S-R1-CODE-DISC-OK)        AS CODE_DISK_OK              
MFA-TR*          ,STRIP(:S-R1-NOTICE-EXEMPT-CD)    AS NOTICE_EXEMPT_CD          
MFA-TR*          ,STRIP(:S-R1-IVR-EXEMPT-CD)       AS IVR_EXEMPT_CD             
MFA-TR*          ,STRIP(:S-R1-DPP-DROP-EXEMPT-CD)  AS DPP_DROP_EXEMPT_CD        
MFA-TR*          ,STRIP(:S-R1-DNP-EXEMPT-CD)       AS DNP_EXEMPT_CD             
MFA-TR*          ,STRIP(:S-R1-RETURN-CHK-CD)       AS RETURN_CHK_CD             
MFA-TR*          ,STRIP(:S-R1-ACT-REVIEW-CD)       AS ACT_REVIEW_CD             
MFA-TR*          ,STRIP(:S-R1-CA-EXEMPT-CD)        AS CA_EXEMPT_CD              
MFA-TR*          ,STRIP(:S-R1-CB-EXEMPT-CD)        AS CB_EXEMPT_CD              
MFA-TR*          ,STRIP(:S-R1-ARCH-EXEMPT-CD)      AS ARCH_EXEMPT_CD            
MFA-TR*          ,STRIP(:S-R1-AUTO-XFER-XMPT-CD)   AS AUTO_XFER_XMPT_CD         
MFA-TR*          ,STRIP(:S-R1-IVR-NDO-EXEMPT)      AS IVR_NDO_EXEMPT            
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           PERFORM 0101-DECLARE-GTT-R2      THRU 0101-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0101-DECLARE-GTT-R2                                            *        
      ******************************************************************        
      *                                                                         
       0101-DECLARE-GTT-R2.                                             
      *                                                                         
           MOVE 'SESSION.CSR04782_R2'       TO WS-GTT-NAME.             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04782_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04782_R2
              (                                                          
                RETURN_CODE                 INT                     
               ,FCST_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
               ,FCST_REASON_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,FCST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
               ,FINALED_DT CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
               ,LST_UPD_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
               ,LST_UPD_BY_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2         
               ,REMARKS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2              
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000-DELETE-GTT-ROWS THRU 8000-EXIT               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0101'                TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,LTRIM(RTRIM(FCST_TYPE_CD))       AS FCST_TYPE_CD             
                 ,LTRIM(RTRIM(FCST_REASON_CD))     AS FCST_REASON_CD           
                 ,LTRIM(RTRIM(FCST_DT))            AS FCST_DT                  
                 ,LTRIM(RTRIM(FINALED_DT))         AS FINALED_DT               
                 ,LTRIM(RTRIM(LST_UPD_TS))         AS LST_UPD_TS               
                 ,LTRIM(RTRIM(LST_UPD_BY_ID))      AS LST_UPD_BY_ID            
                 ,LTRIM(RTRIM(REMARKS))            AS REMARKS                  
               FROM #CSR04782_R2                                 
               ORDER BY FCST_DT DESC                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(FCST_TYPE_CD)       AS FCST_TYPE_CD                     
MFA-TR*          ,STRIP(FCST_REASON_CD)     AS FCST_REASON_CD                   
MFA-TR*          ,STRIP(FCST_DT)            AS FCST_DT                          
MFA-TR*          ,STRIP(FINALED_DT)         AS FINALED_DT                       
MFA-TR*          ,STRIP(LST_UPD_TS)         AS LST_UPD_TS                       
MFA-TR*          ,STRIP(LST_UPD_BY_ID)      AS LST_UPD_BY_ID                    
MFA-TR*          ,STRIP(REMARKS)            AS REMARKS                          
MFA-TR*        FROM SESSION.CSR04782_R2                                         
MFA-TR*        ORDER BY FCST_DT DESC                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO               TO AA-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO          
                                                 AZ-ACCOUNT-NO          
                                                 YP-ACCOUNT-NO.         
      *                                                                         
           PERFORM 7000-SELECT-ACCOUNT        THRU 7000-EXIT.           
AP5740     MOVE AT-CUSTOMER-NO                TO LQ-CUSTOMER-NO.        
                                                                        
AP5740     PERFORM 7005-GET-IVR-NDO-EXEMPT    THRU 7005-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2100-BUILD-RESULTS-1          THRU 2100-EXIT.        
      *                                                                         
           PERFORM 2200-BUILD-RESULTS-2          THRU 2200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2100-BUILD-RESULTS-1                                                    
      ******************************************************************        
      *                                                                         
       2100-BUILD-RESULTS-1.                                            
      *                                                                         
           MOVE SPACES                       TO AA-ARCHIVE-EXEMPT-CD.   
           PERFORM 7100-GET-ARCH-XMPT-CD     THRU 7100-EXIT.            
           MOVE AA-ARCHIVE-EXEMPT-CD         TO S-R1-ARCH-EXEMPT-CD.    
      *                                                                         
           MOVE AT-IVR-EXEMPT-CD             TO S-R1-IVR-EXEMPT-CD.     
           MOVE AT-CODE-LPC-XMT              TO S-R1-CODE-LPC-XMT.      
           MOVE AT-CODE-DISC-OK              TO S-R1-CODE-DISC-OK.      
           MOVE AT-NOTICE-EXEMPT-CD          TO S-R1-NOTICE-EXEMPT-CD.  
AP5740     MOVE LQ-IVR-NDO-EXEMPT            TO S-R1-IVR-NDO-EXEMPT.    
      *                                                                         
           MOVE SPACES                       TO WS-NO-MORE-ROWS.        
           PERFORM 7101-OPEN-ATTRIBUTE-CUR   THRU 7101-EXIT.            
           PERFORM 7102-FETCH-ATTRIBUTE-CUR  THRU 7102-EXIT.            
           PERFORM 2110-BUILD-RESULT-SET     THRU 2110-EXIT             
                                             UNTIL NO-MORE-ROWS         
           PERFORM 7103-CLOSE-ATTRIBUTE-CUR  THRU 7103-EXIT.            
      *                                                                         
           ADD +1                            TO CTR-ROWS-RS1.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2110-PROCESS-ATTRIBUTES.                                      **        
      ******************************************************************        
      *                                                                         
       2110-BUILD-RESULT-SET.                                           
      *                                                                         
           EVALUATE YP-ATTRIBUTE-DESC                                   
              WHEN WS-CA-XMPT-ATTR                                      
                   MOVE YP-ATTRIBUTE-VALUE-CD  TO S-R1-CA-EXEMPT-CD     
              WHEN WS-CB-XMPT-ATTR                                      
                   MOVE YP-ATTRIBUTE-VALUE-CD  TO S-R1-CB-EXEMPT-CD     
              WHEN WS-AUTO-DPP-DROP-ATTRIB                              
                   MOVE YP-ATTRIBUTE-VALUE-CD                           
                                             TO S-R1-DPP-DROP-EXEMPT-CD 
              WHEN WS-AUTO-DNP-ATTRIB                                   
                    MOVE YP-ATTRIBUTE-VALUE-CD TO S-R1-DNP-EXEMPT-CD    
              WHEN WS-AUTO-RTN-CHK-ATTRIB                               
                   MOVE YP-ATTRIBUTE-VALUE-CD  TO S-R1-RETURN-CHK-CD    
              WHEN WS-ACCT-REVIEW-ATTRIB                                
                   MOVE YP-ATTRIBUTE-VALUE-CD(1:1)                      
                                               TO S-R1-ACT-REVIEW-CD    
              WHEN WS-AUTO-XFER-ATTRIB                                  
                   IF YP-ATTRIBUTE-VALUE-CD = 'YES'                     
                      MOVE YP-ATTRIBUTE-VALUE-DT                        
                                             TO S-R1-AUTO-XFER-XMPT-CD  
                   ELSE                                                 
                      MOVE SPACES            TO S-R1-AUTO-XFER-XMPT-CD  
                   END-IF                                               
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 7102-FETCH-ATTRIBUTE-CUR    THRU 7102-EXIT.          
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULTS-2                                          **        
      ******************************************************************        
      *                                                                         
       2200-BUILD-RESULTS-2.                                            
      *                                                                         
           MOVE SPACES                         TO WS-NO-MORE-ROWS.      
           PERFORM 7200-OPEN-ARCH-FCST-CUR     THRU 7200-EXIT.          
           PERFORM 7201-FETCH-ARCH-FCST-CUR    THRU 7201-EXIT.          
           PERFORM 2140-BUILD-RESULT-SET       THRU 2140-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7202-CLOSE-ARCH-FCST-CUR    THRU 7202-EXIT.          
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2140-BUILD-RESULT-SET                                          *        
      ******************************************************************        
      *                                                                         
       2140-BUILD-RESULT-SET.                                           
      *                                                                         
           MOVE ZEROES                 TO S-R2-RETURN-CODE.             
           MOVE AZ-FORECAST-TYPE-CD    TO S-R2-FCST-TYPE-CD.            
           MOVE AZ-FORECAST-REASON-CD  TO S-R2-FCST-REASON-CD.          
           MOVE AZ-FORECAST-DT         TO S-R2-FCST-DT.                 
           MOVE AZ-ACCT-FINALED-DT     TO S-R2-FINALED-DT.              
           MOVE AZ-LAST-UPDATE-TS      TO S-R2-LST-UPD-TS.              
           MOVE AZ-LAST-UPDATE-USERID  TO S-R2-LST-UPD-BY-ID.           
           MOVE AZ-REMARKS             TO S-R2-REMARKS.                 
           PERFORM 8001-INSERT-GTT-R2          THRU 8001-EXIT.          
      *                                                                         
           PERFORM 7201-FETCH-ARCH-FCST-CUR    THRU 7201-EXIT.          
      *                                                                         
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7000-SELECT-ACCOUNT                                           *31850000
      ******************************************************************        
      *                                                                         
       7000-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     AT.IVR_EXEMPT_CD                                   
                    ,AT.CODE_LPC_XMT                                    
                    ,AT.CODE_DISC_OK                                    
                    ,AT.NOTICE_EXEMPT_CD                                
AP5740              ,AT.CUSTOMER_NO                                     
                INTO                                                    
                     :AT-IVR-EXEMPT-CD                                  
                    ,:AT-CODE-LPC-XMT                                   
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-NOTICE-EXEMPT-CD                               
AP5740              ,:AT-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT                                                    32000000
MFA-TR*              AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.CODE_LPC_XMT                                            
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*         INTO                                                    32260000
MFA-TR*              :AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-CODE-LPC-XMT                                           
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_ACCOUNT AT                                     32390000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        32400000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32420000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 32420000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
AP5740******************************************************************        
AP5740* 7005-GET-IVR-NDO-EXEMPT                                        *        
AP5740******************************************************************        
      *                                                                         
AP5740 7005-GET-IVR-NDO-EXEMPT.                                         
      *                                                                         
AP5740     EXEC SQL                                                     
AP5740        SELECT TOP(1) IVR_NDO_EXEMPT                                     
AP5740          INTO                                                    
AP5740               :LQ-IVR-NDO-EXEMPT                                 
AP5740          FROM                                                    
AP5740               CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
AP5740         WHERE                                                    
AP5740               CUSTOMER_NO = :LQ-CUSTOMER-NO                      
AP5740                                       
AP5740                                                      
AP5740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              IVR_NDO_EXEMPT                                             
MFA-TR*         INTO                                                            
MFA-TR*              :LQ-IVR-NDO-EXEMPT                                         
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE                                                            
MFA-TR*              CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
AP5740     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
AP5740     EVALUATE WS-ACTIVE-RETURN-CODE                               
AP5740     WHEN SUCCESSFUL-CALL                                         
AP5740        CONTINUE                                                  
                                                                        
AP5740     WHEN NOT-FOUND                                               
AP5740        MOVE SPACES                TO LQ-IVR-NDO-EXEMPT           
                                                                        
AP5740     WHEN OTHER                                                   
AP5740        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
AP5740        MOVE '7005'                TO ACTIVE-PARAGRAPH            
AP5740        MOVE 'SELECT'              TO ABEND-FUNCTION              
AP5740        MOVE 'CSS_CUST_MISC_INFO'  TO TABLE-1                     
AP5740        MOVE 'IVR_NDO_EXEMPT'      TO TABLE-ELEMENT-1             
AP5740        MOVE  LQ-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
AP5740        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
AP5740     END-EVALUATE.                                                
      *                                                                         
AP5740 7005-EXIT.                                                       
AP5740     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-GET-CURRENT-DATE                                                   
      ******************************************************************        
      *                                                                         
       7010-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-ARCH-XMPT-CD                                          *        
      ******************************************************************        
      *                                                                         
       7100-GET-ARCH-XMPT-CD.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     COALESCE(AA.ARCHIVE_EXEMPT_CD, ' ')                  
                INTO                                                    
                     :AA-ARCHIVE-EXEMPT-CD                              
                FROM                                                    
                     CSS_ARCHIVE_EXEMPT AA WITH(READUNCOMMITTED)                
               WHERE                                                    
                     AA.ACCOUNT_NO  = :AA-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              IFNULL(AA.ARCHIVE_EXEMPT_CD, ' ')                          
MFA-TR*         INTO                                                            
MFA-TR*              :AA-ARCHIVE-EXEMPT-CD                                      
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ARCHIVE_EXEMPT AA                                      
MFA-TR*        WHERE                                                            
MFA-TR*              AA.ACCOUNT_NO  = :AA-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ARCHIVE_EXEMPT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE  AA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7101-OPEN-ATTRIBUTE-CUR                                        *        
      ******************************************************************        
      *                                                                         
       7101-OPEN-ATTRIBUTE-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN ATTRIBUTE_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE   EQUAL  SUCCESSFUL-CALL            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7101'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN '               TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7102-FETCH-ATTRIBUTE-CUR                                       *        
      ******************************************************************        
      *                                                                         
       7102-FETCH-ATTRIBUTE-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH ATTRIBUTE_CSR                                       
              INTO                                                      
                   :YP-ATTRIBUTE-DESC                                   
                  ,:YP-ATTRIBUTE-VALUE-CD                               
                  ,:YP-ATTRIBUTE-VALUE-DT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES          TO WS-NO-MORE-ROWS             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE '7102'          TO ACTIVE-PARAGRAPH            
                    MOVE 'FETCH'         TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSS_ACCT_ATTRIBUTE'                           
                                         TO TABLE-1                     
                    MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1             
                    MOVE YP-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7102-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7103-CLOSE-ATTRIBUTE-CUR.                                     *         
      *****************************************************************         
      *                                                                         
       7103-CLOSE-ATTRIBUTE-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE ATTRIBUTE_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7103'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7103-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-ARCH-FCST-CUR                                        *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-ARCH-FCST-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN ARCHFCT_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE   EQUAL  SUCCESSFUL-CALL            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN '               TO ABEND-FUNCTION              
              MOVE 'CSS_ARCHIVE_FCST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7201-FETCH-ARCH-FCST-CUR                                       *        
      ******************************************************************        
      *                                                                         
       7201-FETCH-ARCH-FCST-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH ARCHFCT_CSR                                         
              INTO                                                      
                   :AZ-FORECAST-TYPE-CD                                 
                  ,:AZ-FORECAST-REASON-CD                               
                  ,:AZ-FORECAST-DT                                      
                  ,:AZ-LAST-UPDATE-TS                                   
                  ,:AZ-LAST-UPDATE-USERID                               
                  ,:AZ-REMARKS                                          
                  ,:AZ-ACCT-FINALED-DT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES          TO WS-NO-MORE-ROWS             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE '7201'          TO ACTIVE-PARAGRAPH            
                    MOVE 'FETCH'         TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
                    MOVE 'CSS_ARCHIVE_FCST'                             
                                         TO TABLE-1                     
                    MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1             
                    MOVE AZ-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7202-CLOSE-ARCH-FCST-CUR.                                     *         
      *****************************************************************         
      *                                                                         
       7202-CLOSE-ARCH-FCST-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE ARCHFCT_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7202'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_ARCHIVE_FCST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE  AZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-DELETE-GTT-ROWS.                                          *        
      ******************************************************************        
      *                                                                         
       8000-DELETE-GTT-ROWS.                                            
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04782_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04782_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES           TO WS-ACTIVE-RETURN-CODE       
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSR04782_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8001-INSERT-GTT-R2                                             *        
      ******************************************************************        
      *                                                                         
       8001-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04782_R2                            
             (                                                          
              RETURN_CODE                                               
             ,FCST_TYPE_CD                                              
             ,FCST_REASON_CD                                            
             ,FCST_DT                                                   
             ,FINALED_DT                                                
             ,LST_UPD_TS                                                
             ,LST_UPD_BY_ID                                             
             ,REMARKS                                                   
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R2-RETURN-CODE                                         
             ,:S-R2-FCST-TYPE-CD                                        
             ,:S-R2-FCST-REASON-CD                                      
             ,:S-R2-FCST-DT                                             
             ,:S-R2-FINALED-DT                                          
             ,:S-R2-LST-UPD-TS                                          
             ,:S-R2-LST-UPD-BY-ID                                       
             ,:S-R2-REMARKS                                             
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04782_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,FCST_TYPE_CD                                                      
MFA-TR*      ,FCST_REASON_CD                                                    
MFA-TR*      ,FCST_DT                                                           
MFA-TR*      ,FINALED_DT                                                        
MFA-TR*      ,LST_UPD_TS                                                        
MFA-TR*      ,LST_UPD_BY_ID                                                     
MFA-TR*      ,REMARKS                                                           
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R2-RETURN-CODE                                                 
MFA-TR*      ,:S-R2-FCST-TYPE-CD                                                
MFA-TR*      ,:S-R2-FCST-REASON-CD                                              
MFA-TR*      ,:S-R2-FCST-DT                                                     
MFA-TR*      ,:S-R2-FINALED-DT                                                  
MFA-TR*      ,:S-R2-LST-UPD-TS                                                  
MFA-TR*      ,:S-R2-LST-UPD-BY-ID                                               
MFA-TR*      ,:S-R2-REMARKS                                                     
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8001'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSR04782_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF CTR-ROWS-RS1 = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-R1-RETURN-CODE         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                      TO S-R2-RETURN-CODE         
              PERFORM 8001-INSERT-GTT-R2    THRU 8001-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-R1-RETURN-CODE         
                                               S-R2-RETURN-CODE.        
      *                                                                         
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
      *                                                                         
           PERFORM 0101-DECLARE-GTT-R2      THRU 0101-EXIT.             
      *                                                                         
           PERFORM 8001-INSERT-GTT-R2       THRU 8001-EXIT.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00341600
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS-RS1 < 1 AND CTR-ROWS-RS2 < 1                     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS    THRU 8800-EXIT              
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
