       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04781.                                         
       AUTHOR.        VENKAT PONNEKANTI.                                
COB303 DATE-WRITTEN.  JUL 18, 2014.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *       CSR04781 RETRIEVE SP FOR EXEMPTIONS SETUP VIEW           *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES & RETURNS EXEMPTIONS DETAILS             *        
      *  RESULTS SETS:                                                 *        
      *        - SQL RETURN CODE                                       *        
      *        - APPLICATION RETURN CODE                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *   DATE   INITIALS COMMENTS                                     *        
      * -------- -------- -------------------------------------------- *        
P00726* 06/30/14 VP43661  INITIAL IMPLEMENTATION.                      *        
P0726A* 01/28/15 AA97148  1.Added *NEW* as previous value when set up  *        
P0726A*                     Exemption first time.                      *        
P0726A*                   2.Modified IVR column description to sync    *        
P0726A*                     legacy SP.                                 *        
P0726A*                   3.Remove hardcoded description for DPPDROP,  *        
P0726A*                     RETNRN CHECK and Disconnection.            *        
A05470* 02/09/16 VK7L032  ADDED THE LOGIC FOR IVR-NDO-EXEMPT PROCESS   *        
A04860* 04/11/16 MS7M727  REPLACE CSS_WQ_ITEMS_MF TABLE WITH           *01790100
A04860*          ACT107   CSS_WQ_ITEMS TABLE                           *01790200
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04781'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40)  VALUE             
           'WORKING STORAGE FOR CSR04781 STARTS HERE'.                  
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  CTR-ROWS-RS1                PIC S9(9)  COMP VALUE 0.     
      *                                                                         
       01  WS-FLAGS.                                                    
           05  WS-DPPDROP-EXMP-CHG         PIC X(01)  VALUE 'N'.        
               88 DPPDROP-EXMP-CHG                    VALUE 'Y'.        
           05  WS-CA-XMT-CHG               PIC X(01)  VALUE 'N'.        
               88 CA-XMT-CHG                          VALUE 'Y'.        
           05  WS-CB-XMT-CHG               PIC X(01)  VALUE 'N'.        
               88 CB-XMT-CHG                          VALUE 'Y'.        
           05  WS-ROW-EXIST                PIC X(01)  VALUE 'N'.        
               88 ROW-EXIST                           VALUE 'Y'.        
P0726A     05  WS-CODE-VAL-FND             PIC X(1)   VALUE SPACES.     
P0726A         88 CODE-VAL-FND                        VALUE 'Y'.        
P0726A     05  WS-CODE-VAL-LOADED          PIC X(1)   VALUE SPACES.     
P0726A         88 CODE-VAL-LOADED                     VALUE 'Y'.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08)  VALUE 'CSR04781'. 
           05  WS-ACCT-REV-ATTRIB          PIC X(13)  VALUE             
                                               'REVIEW EXEMPT'.         
           05  WS-AUTO-DNP-ATTRIB          PIC X(18)  VALUE             
                                               'AUTODNPDEPEXEMPIND'.    
           05  WS-AUTO-DPP-DROP-ATTRIB     PIC X(18)  VALUE             
                                               'AUTODPPDRPEXEMPIND'.    
           05  WS-AUTO-RTN-CHK-ATTRIB      PIC X(18)  VALUE             
                                               'AUTORETDEPEXEMPIND'.    
           05  WS-AUTO-XFER-ATTRIB         PIC X(18)  VALUE             
                                               'AUTOXFERFBWOEXEMPT'.    
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-CATEGORY-ID              PIC S9(4)  USAGE COMP        
                                                      VALUE 457.        
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                 PIC X(05)  VALUE SPACES.     
P0726A     05  WS-ATTRB-VAL-TX             PIC X(40)  VALUE SPACES.     
ACT108     05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN          PIC S9(4)  COMP.             
               10 WS-COMMENTS-TEXT         PIC X(210).                  
           05  WS-RESP-AREA-ID             PIC X(03)  VALUE SPACES.     
           05  WS-CA-EXEMPT-DESC           PIC X(75)  VALUE SPACES.     
           05  WS-CB-EXEMPT-DESC           PIC X(75)  VALUE SPACES.     
           05  WS-ACT-REV-FLAG             PIC X(01)  VALUE SPACES.     
           05  WS-ARCH-XMPT-FLAG           PIC X(01)  VALUE SPACES.     
           05  WS-ARCH-FCST-FLAG           PIC X(01)  VALUE SPACES.     
           05  WS-DNP-FLAG                 PIC X(01)  VALUE SPACES.     
           05  WS-DPPDROP-FLAG             PIC X(01)  VALUE SPACES.     
           05  WS-RETCHK-FLAG              PIC X(01)  VALUE SPACES.     
           05  WS-AUTO-XFER-FLAG           PIC X(01)  VALUE SPACES.     
           05  WS-TRAN-APPL-NO             PIC S9(4)  COMP.             
           05  WS-WQ-MESSAGE               PIC X(250) VALUE SPACES.     
           05  WS-WQ-MESSAGE-TMP           PIC X(250) VALUE SPACES.     
           05  WS-DATE-TRANS               PIC X(10)  VALUE SPACES.     
           05  WS-CURRENT-TS               PIC X(26)  VALUE SPACES.     
           05  WS-USER-NAME                PIC X(37)  VALUE SPACES.     
           05  RS-RETURN-CODE              PIC S9(9)  COMP  VALUE 0.    
           05  WS-NULL-IND-1               PIC S9(04) COMP  VALUE +0.   
P0726A     05  WS-CODE-VAL-CNT             PIC S9(5) COMP-3 VALUE +0.   
P0726A     05  WS-CODE-VALUE.                                           
P0726A         49 WS-CODE-VALUE-LEN        PIC S9(4) USAGE COMP VALUE 0.
P0726A         49 WS-CODE-VALUE-TEXT       PIC X(10) VALUE SPACES.      
P0726A     05  WS-COLUMN-NA.                                            
P0726A         49 WS-COLUMN-NA-LEN         PIC S9(4) USAGE COMP VALUE 0.
P0726A         49 WS-COLUMN-NA-TEXT        PIC X(18) VALUE SPACES.      
A05470     05  WS-CUST-EXIST               PIC X(01) VALUE SPACES.      
A05470     05  WS-PRV-IVR-NDO-EXEMPT-CD    PIC X(01) VALUE SPACES.      
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  WS-PREVIOUS.                                                 
           05  WS-PREV-CA-XMT-CD           PIC X(05)  VALUE SPACES.     
           05  WS-PREV-CA-XMT-DESC         PIC X(75)  VALUE SPACES.     
           05  WS-PREV-CB-XMT-CD           PIC X(05)  VALUE SPACES.     
           05  WS-PREV-CB-XMT-DESC         PIC X(75)  VALUE SPACES.     
           05  WS-PREV-IVR-XMT-CD          PIC X(01)  VALUE SPACES.     
           05  WS-PREV-DNP-XMT-CD          PIC X(05)  VALUE SPACE.      
           05  WS-PREV-DISC-XMT-CD         PIC X(01)  VALUE SPACES.     
           05  WS-PREV-LPC-XMT-CD          PIC X(01)  VALUE SPACES.     
           05  WS-PREV-DPPDROP-XMT-CD      PIC X(05)  VALUE SPACE.      
           05  WS-PREV-RETCHK-XMT-CD       PIC X(05)  VALUE SPACE.      
           05  WS-PREV-NOTICE-XMT-CD       PIC X(01)  VALUE SPACES.     
           05  WS-PREV-ARCH-XMT-CD         PIC X(01)  VALUE SPACES.     
           05  WS-PREV-AUTO-XFER-XMT-CD    PIC X(01)  VALUE SPACES.     
      *                                                                         
P0726A 01  WS-CODE_VAL-TABLE.                                           
P0726A     05  T1-CODE-VALUE-TBL OCCURS 500 TIMES                       
P0726A            ASCENDING KEY T1-CODE-VALUE                           
P0726A            INDEXED BY WS-CODE-VAL-INDX.                          
P0726A         10 T1-CODE-VALUE.                                        
P0726A            49 T1-CODE-VALUE-LEN     PIC S9(4) USAGE COMP.        
P0726A            49 T1-CODE-VALUE-TEXT    PIC X(10).                   
P0726A         10 T1-CODE-LONG-DESC.                                    
P0726A            49 T1-CODE-LONG-DESC-LEN PIC S9(4) USAGE COMP.        
P0726A            49 T1-CODE-LONG-DESC-TEXT                             
P0726A                                     PIC X(80).                   
P0726A         10 T1-COLUMN-NA.                                         
P0726A            49 T1-COLUMN-NA-LEN      PIC S9(4) USAGE COMP.        
P0726A            49 T1-COLUMN-NA-TEXT     PIC X(18).                   
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE                PIC S9(9)  COMP VALUE 0.     
           05 S-APPL-RETURN-CODE           PIC S9(9)  COMP VALUE 0.     
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ARCHIEVE_EXEMPT - AA                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACXMPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT - AT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ARCHIEVE_FCST - AZ                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCFCS                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CHRG_OFF - CO                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_FINAL_WO - FW                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_FIN_WO_COLLECT - IZ                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFWCLAG                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
ACT108******************************************************************        
ACT108* WORKING STORAGE COPYBOOK FOR MCSCB077                                   
ACT108******************************************************************        
ACT108*                                                                         
ACT108     EXEC SQL                                                             
ACT108        INCLUDE CWS00077                                                  
ACT108     END-EXEC.                                                            
ACT108*                                                                         
      ******************************************************************        
      *    CSS_FW_ATTRIB_DESC  - KV                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBATTDES                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    CSS_USER_PROFILE    - PF                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST  - MH                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET  - MI                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CODE_VALUE - UV                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_ACCT_ATTRIBUTE - YP                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
A05470******************************************************************        
A05470*    CSS_CUST_MISC_INFO - LQ                                     *        
A05470******************************************************************        
A05470*                                                                         
A05470     EXEC SQL                                                             
A05470        INCLUDE TBCSTMSC                                                  
A05470     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
           COPY CWS00056.                                               01680000
      *                                                                         
      ******************************************************************        
      *  ARCH_FCST_CUR                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE ARCH_FCST_CUR CURSOR FOR                          
              SELECT                                                    
                     AZ.ACCOUNT_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AZ.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,AZ.FORECAST_TYPE_CD                                
                    ,AZ.FORECAST_REASON_CD                              
                    ,AZ.FORECAST_DT                                     
                FROM                                                    
                     CSS_ARCHIVE_FCST AZ WITH(READUNCOMMITTED)                  
               WHERE                                                    
                     AZ.ACCOUNT_NO   = :AZ-ACCOUNT-NO                   
                 AND AZ.FORECAST_DT >= IIF(TRY_CONVERT(DATE, 
                                                        :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) )                  
                 FOR READ ONLY                                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ARCH_FCST_CUR CURSOR FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*              AZ.ACCOUNT_NO                                              
MFA-TR*             ,AZ.LAST_UPDATE_TS                                          
MFA-TR*             ,AZ.FORECAST_TYPE_CD                                        
MFA-TR*             ,AZ.FORECAST_REASON_CD                                      
MFA-TR*             ,AZ.FORECAST_DT                                             
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ARCHIVE_FCST AZ                                        
MFA-TR*        WHERE                                                            
MFA-TR*              AZ.ACCOUNT_NO   = :AZ-ACCOUNT-NO                           
MFA-TR*          AND AZ.FORECAST_DT >= :AZ-FORECAST-DT                          
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P0726A******************************************************************        
P0726A*  DECLARE CURSOR TO GET EXEMPTIONS CODE VALUES                  *        
P0726A******************************************************************        
P0726A*                                                                         
P0726A     EXEC SQL                                                     
P0726A        DECLARE CODE_VALUE CURSOR FOR                             
P0726A         SELECT UV.CODE_VALUE                                     
P0726A               ,RTRIM(UV.CODE_LONG_DESC)                          
P0726A               ,UV.COLUMN_NA                                      
P0726A           FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                   
P0726A          WHERE UV.TABLE_NA   = 'EXEMPTIONS'                      
P0726A            AND UV.COLUMN_NA  = :WS-COLUMN-NA                     
P0726A            AND UV.CODE_VALUE = :WS-CODE-VALUE                    
P0726A            FOR READ ONLY                                 
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CODE_VALUE CURSOR FOR                                     
MFA-TR*        SELECT UV.CODE_VALUE                                             
MFA-TR*              ,RTRIM(UV.CODE_LONG_DESC)                                  
MFA-TR*              ,UV.COLUMN_NA                                              
MFA-TR*          FROM CSS_CODE_VALUE UV                                         
MFA-TR*         WHERE UV.TABLE_NA   = 'EXEMPTIONS'                              
MFA-TR*           AND UV.COLUMN_NA  = :WS-COLUMN-NA                             
MFA-TR*           AND UV.CODE_VALUE = :WS-CODE-VALUE                            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7204                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-ACCOUNT-NO             PIC 9(13).                       
       01  PARM-USER-ID                PIC X(07).                       
       01  PARM-DISCONNECT-UPD-FL      PIC X(01).                       
       01  PARM-NOTICE-UPD-FL          PIC X(01).                       
       01  PARM-LPC-UPD-FL             PIC X(01).                       
       01  PARM-IVR-UPD-FL             PIC X(01).                       
       01  PARM-CA-UPD-FL              PIC X(01).                       
       01  PARM-CB-UPD-FL              PIC X(01).                       
       01  PARM-DEPOSIT-UPD-FL         PIC X(01).                       
       01  PARM-RET-CHK-UPD-FL         PIC X(01).                       
       01  PARM-ACT-REV-UPD-FL         PIC X(01).                       
       01  PARM-DPPDROP-UPD-FL         PIC X(01).                       
       01  PARM-ARCH-XMPT-UPD-FL       PIC X(01).                       
       01  PARM-ARCH-FCST-UPD-FL       PIC X(01).                       
       01  PARM-AUTO-XFER-UPD-FL       PIC X(01).                       
A05470 01  PARM-IVR-NDO-UPD-FL         PIC X(01).                       
       01  PARM-CODE-DISC-OK           PIC X(01).                       
       01  PARM-NOTICE-EXEMPT-CD       PIC X(01).                       
       01  PARM-CODE-LPC-XMT           PIC X(01).                       
       01  PARM-IVR-EXEMPT-CD          PIC X(01).                       
       01  PARM-CA-EXEMPT              PIC X(05).                       
       01  PARM-CB-EXEMPT              PIC X(05).                       
       01  PARM-DNP-EXMP-CD            PIC X(05).                       
       01  PARM-RET-CHK-EXMP-CD        PIC X(05).                       
       01  PARM-ACT-REV-EXMP-CD        PIC X(01).                       
       01  PARM-DPPDROP-EXMP-CD        PIC X(05).                       
       01  PARM-ARCH-EXMP-CD           PIC X(01).                       
       01  PARM-ARCH-FCST-TYP-CD       PIC X(01).                       
       01  PARM-ARCH-FCST-RSN-CD       PIC X(01).                       
       01  PARM-ARCH-FCST-DT           PIC X(10).                       
       01  PARM-AUTO-XFER-EXMP-CD      PIC X(01).                       
A05470 01  PARM-IVR-NDO-EXEMPT-CD      PIC X(01).                       
       01  PARM-COMMENTS               PIC X(210).                      
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-USER-ID                            
                                PARM-DISCONNECT-UPD-FL                  
                                PARM-NOTICE-UPD-FL                      
                                PARM-LPC-UPD-FL                         
                                PARM-IVR-UPD-FL                         
                                PARM-CA-UPD-FL                          
                                PARM-CB-UPD-FL                          
                                PARM-DEPOSIT-UPD-FL                     
                                PARM-RET-CHK-UPD-FL                     
                                PARM-ACT-REV-UPD-FL                     
                                PARM-DPPDROP-UPD-FL                     
                                PARM-ARCH-XMPT-UPD-FL                   
                                PARM-ARCH-FCST-UPD-FL                   
                                PARM-AUTO-XFER-UPD-FL                   
A05470                          PARM-IVR-NDO-UPD-FL                     
                                PARM-CODE-DISC-OK                       
                                PARM-NOTICE-EXEMPT-CD                   
                                PARM-CODE-LPC-XMT                       
                                PARM-IVR-EXEMPT-CD                      
                                PARM-CA-EXEMPT                          
                                PARM-CB-EXEMPT                          
                                PARM-DNP-EXMP-CD                        
                                PARM-RET-CHK-EXMP-CD                    
                                PARM-ACT-REV-EXMP-CD                    
                                PARM-DPPDROP-EXMP-CD                    
                                PARM-ARCH-EXMP-CD                       
                                PARM-ARCH-FCST-TYP-CD                   
                                PARM-ARCH-FCST-RSN-CD                   
                                PARM-ARCH-FCST-DT                       
                                PARM-AUTO-XFER-EXMP-CD                  
A05470                          PARM-IVR-NDO-EXEMPT-CD                  
                                PARM-COMMENTS.                          
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                    THRU 0100-EXIT.   
           PERFORM 1000-PROCESS-INPUT                 THRU 1000-EXIT.   
           PERFORM 2000-PROCESS-OUTPUT                THRU 2000-EXIT.   
           PERFORM 9999-END-PROGRAM                   THRU 9999-EXIT.   
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE +0                            TO WS-TRAN-APPL-NO.       
           PERFORM 7010-SELECT-DATE-TIMESTAMP THRU 7010-EXIT.           
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                       :S-RETURN-CODE         AS RETURN_CODE            
                      ,:S-APPL-RETURN-CODE    AS APPL_RETURN_CODE       
                 FROM                                                   
                      CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*                :S-RETURN-CODE         AS RETURN_CODE                    
MFA-TR*               ,:S-APPL-RETURN-CODE    AS APPL_RETURN_CODE               
MFA-TR*          FROM                                                           
MFA-TR*               SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO               TO AA-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO          
                                                 AZ-ACCOUNT-NO          
                                                 CO-ACCOUNT-NO          
                                                 IZ-ACCOUNT-NO          
                                                 YP-ACCOUNT-NO.         
      *                                                                         
           PERFORM 7080-SEL-RESP-AREA-ID      THRU 7080-EXIT.           
           PERFORM 7000-SELECT-ACCOUNT        THRU 7000-EXIT.           
      *                                                                         
A05470     MOVE AT-CUSTOMER-NO                TO LQ-CUSTOMER-NO.        
           MOVE AT-CODE-DISC-OK               TO WS-PREV-DISC-XMT-CD.   
           MOVE AT-IVR-EXEMPT-CD              TO WS-PREV-IVR-XMT-CD.    
           MOVE AT-CODE-LPC-XMT               TO WS-PREV-LPC-XMT-CD.    
           MOVE AT-NOTICE-EXEMPT-CD           TO WS-PREV-NOTICE-XMT-CD. 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 5000-UPDATE-EXEMPTIONS     THRU 5000-EXIT.           
           IF WS-TRAN-APPL-NO = 0                                       
              PERFORM 5100-BUILD-MNT-HIST-HDR THRU 5100-EXIT            
           END-IF.                                                      
           PERFORM 5200-BUILD-MNT-HIST-DET    THRU 5200-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-CA-XMT-PROCESS                                            *        
      ******************************************************************        
      *                                                                         
       2100-CA-XMT-PROCESS.                                             
      *                                                                         
           MOVE 'CAEXEMPT'                    TO YP-ATTRIBUTE-DESC.     
           MOVE PARM-USER-ID                  TO PF-USER-ID.            
           PERFORM 7040-SEL-ACCT-ATTRIBUTE        THRU 7040-EXIT.       
           MOVE YP-ATTRIBUTE-VALUE-CD         TO WS-PREV-CA-XMT-CD.     
           MOVE PARM-CA-EXEMPT                TO YP-ATTRIBUTE-VALUE-CD. 
      *                                                                         
           IF PARM-CA-EXEMPT NOT EQUAL WS-PREV-CA-XMT-CD                
              SET CA-XMT-CHG                  TO TRUE                   
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES                  TO YP-STATUS-CD           
                 MOVE ZEROS                   TO                        
                                              YP-ATTRIBUTE-VALUE-TX-LEN 
                 MOVE SPACES                  TO                        
                                              YP-ATTRIBUTE-VALUE-TX-TEXT
                 PERFORM 8030-INSERT-ATTRB-CD     THRU 8030-EXIT        
              ELSE                                                      
                 IF PARM-CA-EXEMPT = SPACES                             
                    PERFORM 8050-DELETE-ATTRB-CD  THRU 8050-EXIT        
                 ELSE                                                   
                    PERFORM 8040-UPDATE-ATTRB-CD  THRU 8040-EXIT        
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF PARM-CA-EXEMPT > SPACES AND AT-CODE-ACCT-STAT = 'S'    
                 PERFORM 2110-FIN-COLLECT-PROCESS THRU 2110-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2110-FIN-COLLECT-PROCESS                                      *         
      *****************************************************************         
      *                                                                         
       2110-FIN-COLLECT-PROCESS.                                        
      *                                                                         
           PERFORM 7060-GET-COLL-STATCD       THRU 7060-EXIT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EVALUATE FW-COLLECT-STATUS-CD                             
                 WHEN 'F'                                               
                    MOVE '1PLMT'              TO IZ-FW-ACTION-TYPE-CD   
                 WHEN 'H'                                               
                    MOVE '2PLMT'              TO IZ-FW-ACTION-TYPE-CD   
                 WHEN 'J'                                               
                    MOVE '3PLMT'              TO IZ-FW-ACTION-TYPE-CD   
                 WHEN OTHER                                             
                    GO TO 2110-EXIT                                     
              END-EVALUATE                                              
              PERFORM 7070-GET-WO-AMT         THRU 7070-EXIT            
              MOVE CO-AMT-TRANS               TO IZ-WITHDRAW-AM         
              MOVE PARM-CA-EXEMPT             TO IZ-WITHDRAW-REASON-CD  
              PERFORM 8060-UPDATE-FIN-WO      THRU 8060-EXIT            
           END-IF.                                                      
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2120-GENERATE-WQ                                              *         
      *****************************************************************         
      *                                                                         
       2120-GENERATE-WQ.                                                
      *                                                                         
ACT108     INITIALIZE CWS00077-FIELDS.                                  
ACT108     MOVE WS-DATE-TRANS             TO WS-77-DATE-CREATED         
ACT108                                       WS-77-DATE-REQUIRED.       
ACT108     MOVE WS-CATEGORY-ID            TO WS-77-CATEGORY-ID.         
ACT108     MOVE WS-RESP-AREA-ID           TO WS-77-RESP-AREA-ID         
ACT108     MOVE ZEROS                     TO WS-77-SERV-ORDER-NO.       
ACT108     MOVE PARM-USER-ID              TO WS-77-USER-ID-ORIG.        
ACT108     MOVE AT-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.          
ACT108     MOVE AT-CUSTOMER-NO            TO WS-77-CUSTOMER-NO.         
ACT108     MOVE ZEROS                     TO WS-77-PREMISE-NO.          
ACT108     MOVE AT-LOCAL-OFFICE           TO WS-77-LOCAL-OFFICE.        
ACT108     MOVE 5                         TO WS-77-ROUTE-CATEGORY.      
ACT108     MOVE WS-N                      TO WS-77-PRIORITY.            
ACT108     MOVE WS-WQ-MESSAGE             TO WS-77-COMMENTS-TEXT.       
ACT108     MOVE LENGTH OF WS-WQ-MESSAGE   TO WS-77-COMMENTS-LEN.        
ACT108     MOVE SPACES                    TO WS-77-FREE-FORM-TXT.       
ACT108     MOVE ZERO                      TO WS-77-FREE-FORM-LEN.       
ACT108     MOVE PROGRAM-NAME              TO WS-77-CREATED-BY.          
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
      *                                                                         
           MOVE SPACES                    TO WS-WQ-MESSAGE.             
      *                                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2130-CB-XMT-PROCESS                                            *        
      ******************************************************************        
      *                                                                         
       2130-CB-XMT-PROCESS.                                             
      *                                                                         
           MOVE 'CBEXEMPT'                    TO YP-ATTRIBUTE-DESC.     
           PERFORM 7040-SEL-ACCT-ATTRIBUTE       THRU 7040-EXIT.        
           MOVE YP-ATTRIBUTE-VALUE-CD         TO WS-PREV-CB-XMT-CD.     
           MOVE PARM-CB-EXEMPT                TO YP-ATTRIBUTE-VALUE-CD. 
      *                                                                         
           IF PARM-CB-EXEMPT NOT EQUAL WS-PREV-CB-XMT-CD                
              SET CB-XMT-CHG                  TO TRUE                   
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES                  TO YP-STATUS-CD           
                 MOVE ZEROS                   TO                        
                                              YP-ATTRIBUTE-VALUE-TX-LEN 
                 MOVE SPACES                  TO                        
                                              YP-ATTRIBUTE-VALUE-TX-TEXT
                 PERFORM 8030-INSERT-ATTRB-CD    THRU 8030-EXIT         
              ELSE                                                      
                 IF PARM-CB-EXEMPT = SPACES                             
                    PERFORM 8050-DELETE-ATTRB-CD THRU 8050-EXIT         
                 ELSE                                                   
                    PERFORM 8040-UPDATE-ATTRB-CD THRU 8040-EXIT         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * 2300-DPPDROP-XMT-PROCESS                                       *        
      ******************************************************************06620000
      *                                                                         
       2300-DPPDROP-XMT-PROCESS.                                        
      *                                                                         
           MOVE WS-AUTO-DPP-DROP-ATTRIB    TO YP-ATTRIBUTE-DESC.        
           PERFORM 7040-SEL-ACCT-ATTRIBUTE        THRU 7040-EXIT.       
           MOVE YP-ATTRIBUTE-VALUE-CD      TO WS-PREV-DPPDROP-XMT-CD.   
      *                                                                         
           IF YP-ATTRIBUTE-VALUE-CD NOT EQUAL PARM-DPPDROP-EXMP-CD      
              SET DPPDROP-EXMP-CHG TO TRUE                              
              IF PARM-DPPDROP-EXMP-CD = SPACES                          
                 MOVE 'D'                  TO WS-DPPDROP-FLAG           
                 PERFORM 8050-DELETE-ATTRB-CD     THRU 8050-EXIT        
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'I'                   TO WS-DPPDROP-FLAG       
                    MOVE 'A'                   TO YP-STATUS-CD          
P0726A              MOVE 16                    TO WS-COLUMN-NA-LEN      
P0726A              MOVE 'AUTO_DROP_EXEMPT'    TO WS-COLUMN-NA-TEXT     
P0726A              MOVE 1                     TO WS-CODE-VALUE-LEN     
                    MOVE PARM-DPPDROP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD 
P0726A                                            WS-CODE-VALUE-TEXT    
                    PERFORM 5240-GET-ATTRB-VAL-TX THRU 5240-EXIT        
                    MOVE LENGTH OF WS-ATTRB-VAL-TX                      
                                           TO YP-ATTRIBUTE-VALUE-TX-LEN 
                    MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
                    PERFORM 8030-INSERT-ATTRB-CD  THRU 8030-EXIT        
                ELSE                                                    
                    MOVE 'U'               TO WS-DPPDROP-FLAG           
P0726A              MOVE 16                    TO WS-COLUMN-NA-LEN      
P0726A              MOVE 'AUTO_DROP_EXEMPT'    TO WS-COLUMN-NA-TEXT     
P0726A              MOVE 1                     TO WS-CODE-VALUE-LEN     
                    MOVE PARM-DPPDROP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD 
P0726A                                            WS-CODE-VALUE-TEXT    
                    PERFORM 5240-GET-ATTRB-VAL-TX THRU 5240-EXIT        
                    MOVE LENGTH OF WS-ATTRB-VAL-TX                      
                                           TO YP-ATTRIBUTE-VALUE-TX-LEN 
                    MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
                    PERFORM 8040-UPDATE-ATTRB-CD  THRU 8040-EXIT        
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * 2400-DNP-DEP-XMT-PROCESS                                       *06620000
      ******************************************************************06620000
      *                                                                         
       2400-DNP-DEP-XMT-PROCESS.                                        
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
           MOVE WS-AUTO-DNP-ATTRIB         TO YP-ATTRIBUTE-DESC.        
           PERFORM 7040-SEL-ACCT-ATTRIBUTE           THRU 7040-EXIT.    
           MOVE YP-ATTRIBUTE-VALUE-CD      TO WS-PREV-DNP-XMT-CD.       
      *                                                                         
           IF YP-ATTRIBUTE-VALUE-CD NOT =  PARM-DNP-EXMP-CD             
              IF PARM-DNP-EXMP-CD = SPACES                              
                 MOVE 'D'                  TO WS-DNP-FLAG               
                 PERFORM 8050-DELETE-ATTRB-CD     THRU 8050-EXIT        
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'I'               TO WS-DNP-FLAG               
                    MOVE SPACES            TO YP-STATUS-CD              
P0726A              MOVE 15                TO WS-COLUMN-NA-LEN          
P0726A              MOVE 'AUTO_DEP_EXEMPT' TO WS-COLUMN-NA-TEXT         
P0726A              MOVE 1                 TO WS-CODE-VALUE-LEN         
                    MOVE PARM-DNP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD     
P0726A                                        WS-CODE-VALUE-TEXT        
                    PERFORM 5240-GET-ATTRB-VAL-TX THRU 5240-EXIT        
                    MOVE LENGTH OF WS-ATTRB-VAL-TX                      
                                           TO YP-ATTRIBUTE-VALUE-TX-LEN 
                    MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
                    PERFORM 8030-INSERT-ATTRB-CD  THRU 8030-EXIT        
                ELSE                                                    
                    MOVE 'U'               TO WS-DNP-FLAG               
P0726A              MOVE 15                TO WS-COLUMN-NA-LEN          
P0726A              MOVE 'AUTO_DEP_EXEMPT' TO WS-COLUMN-NA-TEXT         
P0726A              MOVE 1                 TO WS-CODE-VALUE-LEN         
                    MOVE PARM-DNP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD     
P0726A                                        WS-CODE-VALUE-TEXT        
                    PERFORM 5240-GET-ATTRB-VAL-TX THRU 5240-EXIT        
                    MOVE LENGTH OF WS-ATTRB-VAL-TX                      
                                           TO YP-ATTRIBUTE-VALUE-TX-LEN 
                    MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
                    PERFORM 8040-UPDATE-ATTRB-CD  THRU 8040-EXIT        
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * 2410-RETCK-DEP-XMT-PROCESS                                     *06620000
      ******************************************************************06620000
      *                                                                         
       2410-RETCK-DEP-XMT-PROCESS.                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
           MOVE WS-AUTO-RTN-CHK-ATTRIB     TO YP-ATTRIBUTE-DESC.        
           PERFORM 7040-SEL-ACCT-ATTRIBUTE        THRU 7040-EXIT.       
           MOVE YP-ATTRIBUTE-VALUE-CD      TO WS-PREV-RETCHK-XMT-CD.    
           IF YP-ATTRIBUTE-VALUE-CD NOT EQUAL PARM-RET-CHK-EXMP-CD      
              IF PARM-RET-CHK-EXMP-CD = SPACES                          
                 MOVE 'D'                  TO WS-RETCHK-FLAG            
                 PERFORM 8050-DELETE-ATTRB-CD     THRU 8050-EXIT        
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'I'               TO WS-RETCHK-FLAG            
                    MOVE SPACES            TO YP-STATUS-CD              
P0726A              MOVE 15                TO WS-COLUMN-NA-LEN          
P0726A              MOVE 'AUTO_DEP_EXEMPT' TO WS-COLUMN-NA-TEXT         
P0726A              MOVE 1                 TO WS-CODE-VALUE-LEN         
                    MOVE PARM-RET-CHK-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD  
P0726A                                           WS-CODE-VALUE-TEXT     
                    PERFORM 5240-GET-ATTRB-VAL-TX THRU 5240-EXIT        
                    MOVE LENGTH OF WS-ATTRB-VAL-TX                      
                                           TO YP-ATTRIBUTE-VALUE-TX-LEN 
                    MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
                    PERFORM 8030-INSERT-ATTRB-CD  THRU 8030-EXIT        
                 ELSE                                                   
                    MOVE 'U'               TO WS-RETCHK-FLAG            
P0726A              MOVE 15                TO WS-COLUMN-NA-LEN          
P0726A              MOVE 'AUTO_DEP_EXEMPT' TO WS-COLUMN-NA-TEXT         
P0726A              MOVE 1                 TO WS-CODE-VALUE-LEN         
                    MOVE PARM-RET-CHK-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD  
P0726A                                           WS-CODE-VALUE-TEXT     
                    PERFORM 5240-GET-ATTRB-VAL-TX THRU 5240-EXIT        
                    MOVE LENGTH OF WS-ATTRB-VAL-TX                      
                                           TO YP-ATTRIBUTE-VALUE-TX-LEN 
                    MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
                    PERFORM 8040-UPDATE-ATTRB-CD  THRU 8040-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * 2420-ARRS-REV-XMT-PROCESS                                      *06620000
      ******************************************************************06620000
      *                                                                         
       2420-ARRS-REV-XMT-PROCESS.                                       
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
           MOVE WS-ACCT-REV-ATTRIB         TO YP-ATTRIBUTE-DESC.        
           PERFORM 7040-SEL-ACCT-ATTRIBUTE     THRU 7040-EXIT.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF PARM-ACT-REV-EXMP-CD = WS-N OR SPACES                  
                 MOVE 'D'                  TO WS-ACT-REV-FLAG           
                 PERFORM 8050-DELETE-ATTRB-CD  THRU 8050-EXIT           
              END-IF                                                    
           ELSE                                                         
              IF PARM-ACT-REV-EXMP-CD = WS-Y                            
                 MOVE 'I'                  TO WS-ACT-REV-FLAG           
                 MOVE 'A'                  TO YP-STATUS-CD              
                 MOVE 'YES'                TO YP-ATTRIBUTE-VALUE-CD     
                 MOVE 13                   TO YP-ATTRIBUTE-VALUE-TX-LEN 
                 MOVE WS-ACCT-REV-ATTRIB   TO YP-ATTRIBUTE-VALUE-TX-TEXT
                 PERFORM 8030-INSERT-ATTRB-CD  THRU 8030-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * 2500-ARCH-XMT-PROCESS                                          *        
      ******************************************************************06620000
      *                                                                         
       2500-ARCH-XMT-PROCESS.                                           
      *                                                                         
           MOVE 'N'                          TO WS-ROW-EXIST            
           PERFORM 7090-SEL-ARCH-EXMPT       THRU 7090-EXIT             
           MOVE AA-ARCHIVE-EXEMPT-CD         TO WS-PREV-ARCH-XMT-CD     
           IF PARM-ARCH-EXMP-CD = SPACES                                
              MOVE 'D'                       TO WS-ARCH-XMPT-FLAG       
              PERFORM 8005-DEL-ARCH-EXMPT    THRU 8005-EXIT             
           ELSE                                                         
              MOVE PARM-ARCH-EXMP-CD         TO AA-ARCHIVE-EXEMPT-CD    
              MOVE PARM-USER-ID              TO AA-LAST-UPDATE-USERID   
              MOVE WS-CURRENT-TS             TO AA-LAST-UPDATE-TS       
              IF ROW-EXIST                                              
                 MOVE 'U'                    TO WS-ARCH-XMPT-FLAG       
                 PERFORM 8010-UPD-ARCH-EXMPT THRU 8010-EXIT             
              ELSE                                                      
                 MOVE 'I'                    TO WS-ARCH-XMPT-FLAG       
                 PERFORM 8015-INS-ARCH-EXMPT THRU 8015-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06620000
      * 2510-ARCH-FCST-PROCESS                                         *        
      ******************************************************************06620000
      *                                                                         
       2510-ARCH-FCST-PROCESS.                                          
      *                                                                         
      *    DELETE EXISTING FCST ROWS FOR THE >= CURRENT FCST DT                 
           MOVE WS-Y                             TO WS-ROW-EXIST        
           MOVE PARM-ARCH-FCST-DT                TO AZ-FORECAST-DT      
           PERFORM 7200-OPEN-ARCH-FCST-CUR       THRU 7200-EXIT.        
           PERFORM 7201-FETCH-ARCH-FCST-CUR      THRU 7201-EXIT.        
           PERFORM 5100-BUILD-MNT-HIST-HDR       THRU 5100-EXIT.        
      *                                                                         
           PERFORM UNTIL NOT ROW-EXIST                                  
              MOVE 'D'                           TO WS-ARCH-FCST-FLAG   
              PERFORM 8070-DEL-ARCHV-FCST        THRU 8070-EXIT         
              PERFORM 5230-INS-ARCH-FCST-MNT     THRU 5230-EXIT         
              PERFORM 7201-FETCH-ARCH-FCST-CUR   THRU 7201-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7202-CLOSE-ARCH-FCST-CUR      THRU 7202-EXIT.        
      *    INSERT NEW FCST ROW                                                  
           MOVE 'I'                              TO WS-ARCH-FCST-FLAG.  
           MOVE PARM-ARCH-FCST-TYP-CD            TO AZ-FORECAST-TYPE-CD.
           MOVE PARM-ARCH-FCST-DT                TO AZ-FORECAST-DT.     
           MOVE AT-ACCT-FINALED-DT               TO AZ-ACCT-FINALED-DT. 
           MOVE PARM-ARCH-FCST-RSN-CD            TO                     
                                                 AZ-FORECAST-REASON-CD. 
           MOVE PARM-USER-ID                     TO                     
                                                 AZ-LAST-UPDATE-USERID. 
           MOVE WS-CURRENT-TS                    TO AZ-LAST-UPDATE-TS.  
           PERFORM 8020-INS-ARCH-FCST            THRU 8020-EXIT.        
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-AUTO-XFER-PROCESS                                         *        
      ******************************************************************        
      *                                                                         
       2600-AUTO-XFER-PROCESS.                                          
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
           MOVE WS-AUTO-XFER-ATTRIB        TO YP-ATTRIBUTE-DESC.        
           PERFORM 7040-SEL-ACCT-ATTRIBUTE        THRU 7040-EXIT.       
           MOVE YP-ATTRIBUTE-VALUE-CD      TO WS-PREV-AUTO-XFER-XMT-CD. 
           IF PARM-AUTO-XFER-EXMP-CD = SPACES                           
              MOVE 'D'                     TO WS-AUTO-XFER-FLAG         
              PERFORM 8050-DELETE-ATTRB-CD        THRU 8050-EXIT        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 8050-DELETE-ATTRB-CD     THRU 8050-EXIT        
              END-IF                                                    
              MOVE 'I'                     TO WS-AUTO-XFER-FLAG         
              MOVE 'A'                     TO YP-STATUS-CD              
              MOVE 'YES'                   TO YP-ATTRIBUTE-VALUE-CD     
              MOVE 16                      TO YP-ATTRIBUTE-VALUE-TX-LEN 
              MOVE 'EXEMPT AUTO XFER'      TO YP-ATTRIBUTE-VALUE-TX-TEXT
              PERFORM 8030-INSERT-ATTRB-CD        THRU 8030-EXIT        
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726A******************************************************************        
P0726A* 2700-CHECK-LOAD-CODE-VAL                                                
P0726A******************************************************************        
P0726A                                                                  
P0726A  2700-CHECK-LOAD-CODE-VAL.                                       
P0726A                                                                  
P0726A     IF NOT CODE-VAL-LOADED                                       
P0726A        PERFORM 2710-LOAD-CODE-VAL        THRU 2710-EXIT          
P0726A        SET CODE-VAL-LOADED TO TRUE                               
P0726A     END-IF.                                                      
P0726A                                                                  
P0726A     PERFORM 2720-MATCH-CODE-VAL          THRU 2720-EXIT.         
P0726A                                                                  
P0726A     IF CODE-VAL-FND                                              
P0726A        CONTINUE                                                  
P0726A     ELSE                                                         
P0726A        PERFORM 2710-LOAD-CODE-VAL        THRU 2710-EXIT          
P0726A        PERFORM 2720-MATCH-CODE-VAL       THRU 2720-EXIT          
P0726A     END-IF.                                                      
P0726A                                                                  
P0726A 2700-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A******************************************************************        
P0726A* 2710-LOAD-CODE-VAL                                                      
P0726A******************************************************************        
P0726A                                                                  
P0726A 2710-LOAD-CODE-VAL.                                              
P0726A                                                                  
P0726A      INITIALIZE DCLCSS-CODE-VALUE.                               
P0726A      PERFORM 7203-OPEN-CODE-VAL-CUR          THRU 7203-EXIT.     
P0726A      PERFORM 7204-FETCH-CODE-VAL-CUR         THRU 7204-EXIT.     
P0726A      PERFORM 2730-LOAD-CODE-VAL-TB           THRU 2730-EXIT      
P0726A        UNTIL SQLCODE = NOT-FOUND.                                
P0726A      PERFORM 7205-CLOSE-CODE-VAL-CUR         THRU 7205-EXIT.     
P0726A                                                                  
P0726A 2710-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A******************************************************************        
P0726A* 2720-MATCH-CODE-VAL                                                     
P0726A******************************************************************        
P0726A                                                                  
P0726A 2720-MATCH-CODE-VAL.                                             
P0726A                                                                  
P0726A     PERFORM VARYING WS-CODE-VAL-INDX FROM 1 BY 1                 
P0726A       UNTIL WS-CODE-VAL-INDX > WS-CODE-VAL-CNT                   
P0726A          IF T1-CODE-VALUE(WS-CODE-VAL-INDX) = WS-CODE-VALUE AND  
P0726A             T1-COLUMN-NA(WS-CODE-VAL-INDX)  = WS-COLUMN-NA       
P0726A             MOVE T1-CODE-LONG-DESC-TEXT(WS-CODE-VAL-INDX) TO     
P0726A                  WS-ATTRB-VAL-TX                                 
P0726A             SET CODE-VAL-FND       TO TRUE                       
P0726A          END-IF                                                  
P0726A     END-PERFORM.                                                 
P0726A                                                                  
P0726A 2720-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A******************************************************************        
P0726A* 2730-LOAD-CODE-VAL-TB                                                   
P0726A******************************************************************        
P0726A                                                                  
P0726A 2730-LOAD-CODE-VAL-TB.                                           
P0726A                                                                  
P0726A     ADD +1          TO WS-CODE-VAL-CNT.                          
P0726A                                                                  
P0726A     MOVE UV-CODE-VALUE          TO                               
P0726A          T1-CODE-VALUE(WS-CODE-VAL-CNT).                         
P0726A     MOVE UV-CODE-LONG-DESC      TO                               
P0726A          T1-CODE-LONG-DESC(WS-CODE-VAL-CNT).                     
P0726A     MOVE UV-COLUMN-NA           TO                               
P0726A          T1-COLUMN-NA(WS-CODE-VAL-CNT).                          
P0726A                                                                  
P0726A     PERFORM 7204-FETCH-CODE-VAL-CUR      THRU 7204-EXIT.         
P0726A                                                                  
P0726A 2730-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
      ******************************************************************        
A05470* 2800-IVR-NDO-PROCESS.                                                   
A05470******************************************************************        
A05470*                                                                         
A05470 2800-IVR-NDO-PROCESS.                                            
A05470*                                                                         
A05470     MOVE PARM-IVR-NDO-EXEMPT-CD           TO LQ-IVR-NDO-EXEMPT.  
A05470     MOVE WS-N                             TO WS-CUST-EXIST.      
A05470     PERFORM 7300-CUST-MISC-INFO              THRU 7300-EXIT.     
A05470     IF WS-CUST-EXIST EQUAL WS-Y                                  
A05470        PERFORM 8100-UPDATE-CUST-MISC-INFO    THRU 8100-EXIT      
A05470     ELSE                                                         
A05470        PERFORM 8200-INSERT-CUST-MISC-INFO    THRU 8200-EXIT      
A05470     END-IF.                                                      
A05470*                                                                         
A05470 2800-EXIT.                                                       
A05470     EXIT.                                                        
A05470*                                                                         
      ******************************************************************        
      *  5000-UPDATE-EXEMPTIONS                                        *        
      ******************************************************************        
                                                                        
       5000-UPDATE-EXEMPTIONS.                                          
      *                                                                         
      * FORECASTED CREDIT ACTIONS                                               
           IF PARM-NOTICE-UPD-FL = WS-Y                                 
              MOVE PARM-NOTICE-EXEMPT-CD         TO AT-NOTICE-EXEMPT-CD 
           ELSE                                                         
              MOVE WS-PREV-NOTICE-XMT-CD         TO AT-NOTICE-EXEMPT-CD 
           END-IF.                                                      
      *                                                                         
           IF PARM-DISCONNECT-UPD-FL = WS-Y                             
              MOVE PARM-CODE-DISC-OK             TO AT-CODE-DISC-OK     
           ELSE                                                         
              MOVE WS-PREV-DISC-XMT-CD           TO AT-CODE-DISC-OK     
           END-IF.                                                      
      * LPC                                                                     
           IF PARM-LPC-UPD-FL = WS-Y                                    
              MOVE PARM-CODE-LPC-XMT             TO AT-CODE-LPC-XMT     
           ELSE                                                         
              MOVE WS-PREV-LPC-XMT-CD            TO AT-CODE-LPC-XMT     
           END-IF.                                                      
      * IVR                                                                     
           IF PARM-IVR-UPD-FL = WS-Y                                    
              MOVE PARM-IVR-EXEMPT-CD            TO AT-IVR-EXEMPT-CD    
           ELSE                                                         
              MOVE WS-PREV-IVR-XMT-CD            TO AT-IVR-EXEMPT-CD    
           END-IF.                                                      
      * UPDATE ACCT IF NEEDED                                                   
           IF PARM-LPC-UPD-FL = WS-Y OR PARM-NOTICE-UPD-FL = WS-Y  OR   
              PARM-IVR-UPD-FL = WS-Y OR PARM-DISCONNECT-UPD-FL = WS-Y   
              PERFORM 8000-UPDATE-ACCOUNT        THRU 8000-EXIT         
           END-IF.                                                      
      * FB/WRITE-OFF                                                            
           IF PARM-CA-UPD-FL = WS-Y  OR PARM-CB-UPD-FL = WS-Y           
              PERFORM 7030-SELECT-USER-NAME      THRU 7030-EXIT         
           END-IF.                                                      
      *                                                                         
           IF PARM-CA-UPD-FL = WS-Y                                     
              PERFORM 2100-CA-XMT-PROCESS        THRU 2100-EXIT         
           END-IF.                                                      
      *                                                                         
           IF PARM-CB-UPD-FL = WS-Y                                     
              PERFORM 2130-CB-XMT-PROCESS        THRU 2130-EXIT         
           END-IF.                                                      
      * AUTO DPP DROP                                                           
           IF PARM-DPPDROP-UPD-FL = WS-Y                                
              PERFORM 2300-DPPDROP-XMT-PROCESS   THRU 2300-EXIT         
           END-IF.                                                      
      * AUTO DEPOSIT                                                            
           IF PARM-DEPOSIT-UPD-FL = WS-Y                                
              PERFORM 2400-DNP-DEP-XMT-PROCESS   THRU 2400-EXIT         
           END-IF.                                                      
      *                                                                         
           IF PARM-RET-CHK-UPD-FL = WS-Y                                
              PERFORM 2410-RETCK-DEP-XMT-PROCESS THRU 2410-EXIT         
           END-IF.                                                      
      *                                                                         
           IF PARM-ACT-REV-UPD-FL = WS-Y                                
              PERFORM 2420-ARRS-REV-XMT-PROCESS  THRU 2420-EXIT         
           END-IF.                                                      
      * ARCHIVE                                                                 
           IF PARM-ARCH-XMPT-UPD-FL = WS-Y                              
              PERFORM 2500-ARCH-XMT-PROCESS      THRU 2500-EXIT         
           END-IF.                                                      
      *                                                                         
           IF PARM-ARCH-FCST-UPD-FL = WS-Y                              
              PERFORM 2510-ARCH-FCST-PROCESS      THRU 2510-EXIT        
           END-IF.                                                      
      * AUTO TRANSFER                                                           
           IF PARM-AUTO-XFER-UPD-FL = WS-Y                              
              PERFORM 2600-AUTO-XFER-PROCESS      THRU 2600-EXIT        
           END-IF.                                                      
A05470*                                                                         
A05470     IF PARM-IVR-NDO-UPD-FL = WS-Y                                
A05470        PERFORM 2800-IVR-NDO-PROCESS        THRU 2800-EXIT        
A05470     END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14010000
      * 5100-BUILD-MNT-HIST-HDR                                        *14020000
      ******************************************************************14100000
      *                                                                         
       5100-BUILD-MNT-HIST-HDR.                                         
      *                                                                         
           MOVE 1                               TO WS-TRAN-APPL-NO      
                                                   MI-TRAN-APPL-NO.     
           MOVE WS-CURRENT-TS                   TO MH-TRANS-HIST-SEQ-NO.
           MOVE WS-DATE-TRANS                   TO MH-DATE-TRANS.       
           MOVE 'F'                             TO MH-CODE-TRAN-TYPE.   
           MOVE WS-RESP-AREA-ID                 TO MH-RESP-AREA-ID.     
           MOVE AT-ACCOUNT-NO                   TO MH-ACCOUNT-NO.       
           MOVE ZEROS                           TO MH-CUSTOMER-NO       
                                                   MH-PREMISE-NO.       
           MOVE PARM-USER-ID                    TO MH-USER-ID.          
           MOVE 'CSR04781'                      TO MH-APPL-PROGRAM-ID.  
           MOVE PARM-COMMENTS                   TO WS-COMMENTS.         
           MOVE WS-COMMENTS-TEXT                TO MH-TRAN-COMMENT-TEXT.
           MOVE WS-COMMENTS-LEN                 TO MH-TRAN-COMMENT-LEN. 
      *                                                                 14400000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14400000
      ******************************************************************14010000
      * 5200-BUILD-MNT-HIST-DET                                        *14020000
      ******************************************************************14100000
      *                                                                 14110000
       5200-BUILD-MNT-HIST-DET.                                         
      *                                                                 14110000
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
      *                                                                         
           IF PARM-CODE-LPC-XMT NOT = WS-PREV-LPC-XMT-CD AND            
              PARM-LPC-UPD-FL = WS-Y                                    
              PERFORM 5210-INITIALIZE      THRU 5210-EXIT               
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'LATE PAYMENT EXMPTN'   TO MI-COLUMN-DESC            
              MOVE '11'                    TO MI-TABLE-ID               
              IF PARM-CODE-LPC-XMT > SPACES                             
                 MOVE 1                    TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE PARM-CODE-LPC-XMT    TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-PREV-LPC-XMT-CD > SPACES                            
                 MOVE 1                    TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-PREV-LPC-XMT-CD   TO MI-PRV-COLUMN-VALUE-TEXT  
P0726A        ELSE                                                      
P0726A           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
P0726A           MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
      *                                                                 16650000
           IF PARM-CODE-DISC-OK NOT = WS-PREV-DISC-XMT-CD AND           
              PARM-DISCONNECT-UPD-FL = WS-Y                             
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'DISCONNECT EXMPTN'      TO MI-COLUMN-DESC           
              MOVE '12'                     TO MI-TABLE-ID              
              IF PARM-CODE-DISC-OK > SPACES                             
                 MOVE 1                     TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-CODE-DISC-OK     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-PREV-DISC-XMT-CD > SPACES                           
                 MOVE 1                     TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-PREV-DISC-XMT-CD   TO MI-PRV-COLUMN-VALUE-TEXT 
P0726A        ELSE                                                      
P0726A           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
P0726A           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                 16880000
           IF PARM-NOTICE-EXEMPT-CD NOT = WS-PREV-NOTICE-XMT-CD AND     
              PARM-NOTICE-UPD-FL = WS-Y                                 
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'SEND NOTICE EXMPTN'     TO MI-COLUMN-DESC           
              MOVE '13'                     TO MI-TABLE-ID              
              IF PARM-NOTICE-EXEMPT-CD > SPACES                         
                MOVE 1                      TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE PARM-NOTICE-EXEMPT-CD  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-PREV-NOTICE-XMT-CD > SPACES                         
                 MOVE 1                     TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-PREV-NOTICE-XMT-CD TO MI-PRV-COLUMN-VALUE-TEXT 
P0726A        ELSE                                                      
P0726A           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
P0726A           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                 16880000
           IF PARM-IVR-EXEMPT-CD NOT = WS-PREV-IVR-XMT-CD AND           
              PARM-IVR-UPD-FL = WS-Y                                    
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
P0726A        MOVE 'SEND IVR EXMPTN'        TO MI-COLUMN-DESC           
              MOVE '13'                     TO MI-TABLE-ID              
              IF PARM-IVR-EXEMPT-CD > SPACES                            
                MOVE 1                      TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE PARM-IVR-EXEMPT-CD     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-PREV-IVR-XMT-CD > SPACES                            
                 MOVE 1                     TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-PREV-IVR-XMT-CD    TO MI-PRV-COLUMN-VALUE-TEXT 
P0726A        ELSE                                                      
P0726A           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
P0726A           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
           IF PARM-CA-UPD-FL = WS-Y OR PARM-CB-UPD-FL = WS-Y            
              PERFORM 5220-INS-CA-CB-MNT    THRU 5220-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-DNP-FLAG = 'D' OR 'I' OR = 'U' AND                     
              PARM-DEPOSIT-UPD-FL = WS-Y                                
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'DNPAUTODEPEXEMP'        TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              IF WS-DNP-FLAG = 'D'                                      
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
P0726A           MOVE 15                    TO WS-COLUMN-NA-LEN         
P0726A           MOVE 'AUTO_DEP_EXEMPT'     TO WS-COLUMN-NA-TEXT        
P0726A           MOVE 1                     TO WS-CODE-VALUE-LEN        
                 MOVE PARM-DNP-EXMP-CD      TO YP-ATTRIBUTE-VALUE-CD    
P0726A                                         WS-CODE-VALUE-TEXT       
                 PERFORM 5240-GET-ATTRB-VAL-TX  THRU 5240-EXIT          
                 MOVE LENGTH OF WS-ATTRB-VAL-TX                         
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-ATTRB-VAL-TX       TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-DNP-FLAG = 'I'                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
P0726A           MOVE 15                    TO WS-COLUMN-NA-LEN         
P0726A           MOVE 'AUTO_DEP_EXEMPT'     TO WS-COLUMN-NA-TEXT        
P0726A           MOVE 1                     TO WS-CODE-VALUE-LEN        
                 MOVE WS-PREV-DNP-XMT-CD    TO YP-ATTRIBUTE-VALUE-CD    
P0726A                                         WS-CODE-VALUE-TEXT       
                 PERFORM 5240-GET-ATTRB-VAL-TX  THRU 5240-EXIT          
                 MOVE LENGTH OF WS-ATTRB-VAL-TX                         
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-ATTRB-VAL-TX       TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
           IF WS-RETCHK-FLAG = 'D' OR 'I' OR = 'U' AND                  
              PARM-RET-CHK-UPD-FL = WS-Y                                
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'RETAUTODEPEXEMP'        TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              IF WS-RETCHK-FLAG = 'D'                                   
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
P0726A           MOVE 15                    TO WS-COLUMN-NA-LEN         
P0726A           MOVE 'AUTO_DEP_EXEMPT'     TO WS-COLUMN-NA-TEXT        
P0726A           MOVE 1                     TO WS-CODE-VALUE-LEN        
                 MOVE PARM-RET-CHK-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD    
P0726A                                         WS-CODE-VALUE-TEXT       
                 PERFORM 5240-GET-ATTRB-VAL-TX  THRU 5240-EXIT          
                 MOVE LENGTH OF WS-ATTRB-VAL-TX                         
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-ATTRB-VAL-TX       TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-RETCHK-FLAG = 'I'                                   
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
P0726A           MOVE 15                    TO WS-COLUMN-NA-LEN         
P0726A           MOVE 'AUTO_DEP_EXEMPT'     TO WS-COLUMN-NA-TEXT        
P0726A           MOVE 1                     TO WS-CODE-VALUE-LEN        
                 MOVE WS-PREV-RETCHK-XMT-CD TO YP-ATTRIBUTE-VALUE-CD    
P0726A                                         WS-CODE-VALUE-TEXT       
                 PERFORM 5240-GET-ATTRB-VAL-TX  THRU 5240-EXIT          
                 MOVE LENGTH OF WS-ATTRB-VAL-TX                         
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-ATTRB-VAL-TX       TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
           IF WS-ACT-REV-FLAG  = 'D' OR 'I' AND                         
              PARM-ACT-REV-UPD-FL = WS-Y                                
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE WS-ACCT-REV-ATTRIB       TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              IF WS-ACT-REV-FLAG = 'D'                                  
                 MOVE +3                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE 'YES'                 TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-ACT-REV-FLAG = 'I'                                  
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE 'YES'                 TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
           IF WS-ARCH-XMPT-FLAG = 'D' OR 'I' OR 'U' AND                 
              PARM-ARCH-XMPT-UPD-FL = WS-Y                              
              MOVE 18                       TO UV-TABLE-NA-LEN          
              MOVE 'CSS_ARCHIVE_EXEMPT'     TO UV-TABLE-NA-TEXT         
              MOVE 17                       TO UV-COLUMN-NA-LEN         
              MOVE 'ARCHIVE_EXEMPT_CD'      TO UV-COLUMN-NA-TEXT        
              MOVE 1                        TO UV-CODE-VALUE-LEN        
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'ARCH EXMPT'             TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              IF WS-ARCH-XMPT-FLAG = 'D'                                
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE PARM-ARCH-EXMP-CD     TO UV-CODE-VALUE-TEXT       
                 PERFORM 7100-GET-CD-VALUE  THRU 7100-EXIT              
                 MOVE UV-CODE-SHORT-DESC-LEN                            
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE UV-CODE-SHORT-DESC-TEXT                           
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-ARCH-XMPT-FLAG = 'I'                                
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE WS-PREV-ARCH-XMT-CD   TO UV-CODE-VALUE-TEXT       
                 PERFORM 7100-GET-CD-VALUE  THRU 7100-EXIT              
                 MOVE UV-CODE-SHORT-DESC-LEN                            
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE UV-CODE-SHORT-DESC-TEXT                           
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
           IF PARM-ARCH-FCST-UPD-FL = WS-Y                              
              PERFORM 5230-INS-ARCH-FCST-MNT    THRU 5230-EXIT          
           END-IF.                                                      
      *                                                                         
           IF WS-AUTO-XFER-FLAG  = 'D' OR 'I' AND                       
              PARM-AUTO-XFER-UPD-FL = WS-Y                              
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE WS-AUTO-XFER-ATTRIB      TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              IF WS-AUTO-XFER-FLAG = 'D'                                
                 MOVE +3                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE 'YES'                 TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-AUTO-XFER-FLAG = 'I'                                
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE 'YES'                 TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
           IF WS-DPPDROP-FLAG = 'D' OR 'I' OR 'U' AND                   
              PARM-DPPDROP-UPD-FL = WS-Y                                
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'DPPDROPEXEMPIND'        TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              IF WS-DPPDROP-FLAG = 'D'                                  
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
P0726A           MOVE 16                    TO WS-COLUMN-NA-LEN         
P0726A           MOVE 'AUTO_DROP_EXEMPT'    TO WS-COLUMN-NA-TEXT        
P0726A           MOVE 1                     TO WS-CODE-VALUE-LEN        
                 MOVE PARM-DPPDROP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD    
P0726A                                         WS-CODE-VALUE-TEXT       
                 PERFORM 5240-GET-ATTRB-VAL-TX  THRU 5240-EXIT          
                 MOVE LENGTH OF WS-ATTRB-VAL-TX                         
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-ATTRB-VAL-TX       TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF WS-DPPDROP-FLAG = 'I'                                  
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
P0726A           MOVE 16                    TO WS-COLUMN-NA-LEN         
P0726A           MOVE 'AUTO_DROP_EXEMPT'    TO WS-COLUMN-NA-TEXT        
P0726A           MOVE 1                     TO WS-CODE-VALUE-LEN        
                 MOVE WS-PREV-DPPDROP-XMT-CD TO YP-ATTRIBUTE-VALUE-CD   
P0726A                                          WS-CODE-VALUE-TEXT      
                 PERFORM 5240-GET-ATTRB-VAL-TX  THRU 5240-EXIT          
                 MOVE LENGTH OF WS-ATTRB-VAL-TX                         
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-ATTRB-VAL-TX       TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
A05470     IF PARM-IVR-NDO-UPD-FL = WS-Y                                
A05470        PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
A05470        MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
A05470        MOVE 'IVRNDOEXEMPTIND'        TO MI-COLUMN-DESC           
A05470        MOVE SPACES                   TO MI-TABLE-ID              
A05470        IF WS-CUST-EXIST = 'Y'                                    
A05470           MOVE +3                    TO MI-PRV-COLUMN-VALUE-LEN  
A05470           IF WS-PRV-IVR-NDO-EXEMPT-CD EQUAL 'Y'                  
A05470              MOVE 'YES'              TO MI-PRV-COLUMN-VALUE-TEXT 
A05470           ELSE                                                   
A05470              MOVE 'NO'               TO MI-PRV-COLUMN-VALUE-TEXT 
A05470           END-IF                                                 
A05470           MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN  
A05470           IF PARM-IVR-NDO-EXEMPT-CD EQUAL 'Y'                    
A05470              MOVE 'YES'              TO MI-CHG-COLUMN-VALUE-TEXT 
A05470           ELSE                                                   
A05470              MOVE 'NO'               TO MI-CHG-COLUMN-VALUE-TEXT 
A05470           END-IF                                                 
A05470        END-IF                                                    
A05470        IF WS-CUST-EXIST = 'N'                                    
A05470           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
A05470           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
A05470           MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN  
A05470           IF PARM-IVR-NDO-EXEMPT-CD EQUAL 'Y'                    
A05470              MOVE 'YES'              TO MI-CHG-COLUMN-VALUE-TEXT 
A05470           ELSE                                                   
A05470              MOVE 'NO'               TO MI-CHG-COLUMN-VALUE-TEXT 
A05470           END-IF                                                 
A05470        END-IF                                                    
A05470        PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
A05470        ADD 1                         TO WS-TRAN-APPL-NO          
A05470     END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14400000
      ******************************************************************14010000
      * 5210-INITIALIZE.                                               *14020000
      ******************************************************************14100000
      *                                                                 14110000
       5210-INITIALIZE.                                                 
      *                                                                 14130000
                                                                        
           MOVE 10                         TO MI-CHG-COLUMN-VALUE-LEN   
                                              MI-PRV-COLUMN-VALUE-LEN   
           MOVE SPACES                     TO MI-CHG-COLUMN-VALUE-TEXT  
                                              MI-PRV-COLUMN-VALUE-TEXT. 
      *                                                                         
       5210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14010000
      * 5220-INS-CA-CB-MNT                                             *14020000
      ******************************************************************14100000
      *                                                                 14110000
       5220-INS-CA-CB-MNT.                                              
      *                                                                 14130000
           INITIALIZE WS-WQ-MESSAGE                                     
                      WS-WQ-MESSAGE-TMP.                                
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
      *                                                                         
           IF WS-PREV-CA-XMT-CD NOT = PARM-CA-EXEMPT AND                
              PARM-CA-UPD-FL = WS-Y                                     
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'CAEXEMPT'               TO MI-COLUMN-DESC           
              IF WS-PREV-CA-XMT-CD = SPACES                             
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE 'CA'                  TO KV-FW-ATTRIB-TYPE-CD     
                 MOVE WS-PREV-CA-XMT-CD     TO KV-FW-ATTR-VALUE-CD      
                 PERFORM 7050-GET-CR-EXMT-DESC THRU 7050-EXIT           
                 MOVE LENGTH OF KV-FW-ATTR-VALUE-DESC                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE KV-FW-ATTR-VALUE-DESC TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF PARM-CA-EXEMPT = SPACES                                
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE 'CA'                  TO KV-FW-ATTRIB-TYPE-CD     
                 MOVE PARM-CA-EXEMPT        TO KV-FW-ATTR-VALUE-CD      
                 PERFORM 7050-GET-CR-EXMT-DESC THRU 7050-EXIT           
                 MOVE LENGTH OF KV-FW-ATTR-VALUE-DESC                   
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE KV-FW-ATTR-VALUE-DESC TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE SPACES                   TO MI-TABLE-ID              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
              MOVE MI-PRV-COLUMN-VALUE-TEXT TO WS-PREV-CA-XMT-DESC      
              MOVE MI-CHG-COLUMN-VALUE-TEXT TO WS-CA-EXEMPT-DESC        
           END-IF.                                                      
      *                                                                         
           IF WS-PREV-CB-XMT-CD NOT = PARM-CB-EXEMPT AND                
              PARM-CB-UPD-FL = WS-Y                                     
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'CBEXEMPT'               TO MI-COLUMN-DESC           
              IF WS-PREV-CB-XMT-CD = SPACES                             
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE 'CB'                  TO KV-FW-ATTRIB-TYPE-CD     
                 MOVE WS-PREV-CB-XMT-CD     TO KV-FW-ATTR-VALUE-CD      
                 PERFORM 7050-GET-CR-EXMT-DESC THRU 7050-EXIT           
                 MOVE LENGTH OF KV-FW-ATTR-VALUE-DESC                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE KV-FW-ATTR-VALUE-DESC TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF PARM-CB-EXEMPT = SPACES                                
                 MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETE*'            TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE 'CB'                  TO KV-FW-ATTRIB-TYPE-CD     
                 MOVE PARM-CB-EXEMPT        TO KV-FW-ATTR-VALUE-CD      
                 PERFORM 7050-GET-CR-EXMT-DESC THRU 7050-EXIT           
                 MOVE LENGTH OF KV-FW-ATTR-VALUE-DESC                   
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE KV-FW-ATTR-VALUE-DESC TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE SPACES                   TO MI-TABLE-ID              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
              MOVE MI-PRV-COLUMN-VALUE-TEXT TO WS-PREV-CB-XMT-DESC      
              MOVE MI-CHG-COLUMN-VALUE-TEXT TO WS-CB-EXEMPT-DESC        
           END-IF.                                                      
      *                                                                 14130000
           IF CA-XMT-CHG OR CB-XMT-CHG                                  
              PERFORM 5221-FORMAT-COMMENTS     THRU 5221-EXIT           
              PERFORM 2120-GENERATE-WQ         THRU 2120-EXIT           
           END-IF.                                                      
      *                                                                 14130000
       5220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14010000
      * 5221-FORMAT-COMMENTS.                                          *14020000
      ******************************************************************14100000
      *                                                                 14110000
       5221-FORMAT-COMMENTS.                                            
      *                                                                 14130000
           IF PARM-CA-EXEMPT = SPACES                                   
              IF CB-XMT-CHG                                             
                 STRING 'COLLECTION AGENCY EXEMPTION REMOVED;'          
                        DELIMITED BY SIZE INTO WS-WQ-MESSAGE            
              ELSE                                                      
                 STRING 'COLLECTION AGENCY EXEMPTION REMOVED BY '       
                                     DELIMITED BY SIZE                  
                        WS-USER-NAME DELIMITED BY '  '                  
                        '.'          DELIMITED BY SIZE                  
                   INTO WS-WQ-MESSAGE                                   
              END-IF                                                    
           ELSE                                                         
              IF CB-XMT-CHG                                             
                 STRING 'COLLECTION AGENCY EXEMPTION SET '              
                        'WITH REASON OF ' DELIMITED BY SIZE             
                        WS-CA-EXEMPT-DESC DELIMITED BY '  '             
                        ';'               DELIMITED BY SIZE             
                   INTO WS-WQ-MESSAGE                                   
              ELSE                                                      
                 STRING 'COLLECTION AGENCY EXEMPTION SET '              
                        'WITH REASON OF ' DELIMITED BY SIZE             
                        WS-CA-EXEMPT-DESC DELIMITED BY '  '             
                        ' BY '            DELIMITED BY SIZE             
                        WS-USER-NAME      DELIMITED BY '  '             
                        '.'               DELIMITED BY SIZE             
                   INTO WS-WQ-MESSAGE                                   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF CB-XMT-CHG                                                
              MOVE WS-WQ-MESSAGE            TO WS-WQ-MESSAGE-TMP        
              MOVE SPACES                   TO WS-WQ-MESSAGE            
           END-IF.                                                      
                                                                        
           IF PARM-CB-EXEMPT = SPACES                                   
              IF CA-XMT-CHG                                             
                 STRING WS-WQ-MESSAGE-TMP DELIMITED BY '  '             
                        'CREDIT BUREAU EXEMPTION REMOVED BY '           
                                          DELIMITED BY SIZE             
                        WS-USER-NAME         DELIMITED BY '  '          
                        '.'                  DELIMITED BY SIZE          
                   INTO WS-WQ-MESSAGE                                   
              ELSE                                                      
                 STRING 'CREDIT BUREAU EXEMPTION REMOVED BY '           
                                     DELIMITED BY SIZE                  
                        WS-USER-NAME DELIMITED BY '  '                  
                        '.'             DELIMITED BY SIZE               
                   INTO WS-WQ-MESSAGE                                   
              END-IF                                                    
           ELSE                                                         
              IF CA-XMT-CHG                                             
                 STRING WS-WQ-MESSAGE-TMP DELIMITED BY '  '             
                        'CREDIT BUREAU EXEMPTION SET WITH REASON OF '   
                                          DELIMITED BY SIZE             
                        WS-CB-EXEMPT-DESC DELIMITED BY '  '             
                        ' BY '               DELIMITED BY SIZE          
                        WS-USER-NAME         DELIMITED BY '  '          
                        '.'                  DELIMITED BY SIZE          
                   INTO WS-WQ-MESSAGE                                   
              ELSE                                                      
                 STRING 'CREDIT BUREAU EXEMPTION SET WITH REASON OF '   
                                          DELIMITED BY SIZE             
                        WS-CB-EXEMPT-DESC DELIMITED BY '  '             
                        ' BY '               DELIMITED BY SIZE          
                        WS-USER-NAME         DELIMITED BY '  '          
                        '.'                  DELIMITED BY SIZE          
                   INTO WS-WQ-MESSAGE                                   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5221-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************14010000
      * 5230-INS-ARCH-FCST-MNT                                         *14020000
      ******************************************************************14100000
      *                                                                 14110000
       5230-INS-ARCH-FCST-MNT.                                          
      *                                                                 14130000
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
      *                                                                         
           IF WS-ARCH-FCST-FLAG = 'D'                                   
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 11                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '**DELETED**'            TO MI-CHG-COLUMN-VALUE-TEXT 
      *       FORECAST DATE                                                     
              MOVE 10                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE AZ-FORECAST-DT           TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'FCST DATE'              TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
      *       FORECAST TYPE CODE                                                
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 16                       TO UV-TABLE-NA-LEN          
              MOVE 'CSS_ARCHIVE_FCST'       TO UV-TABLE-NA-TEXT         
              MOVE 16                       TO UV-COLUMN-NA-LEN         
              MOVE 'FORECAST_TYPE_CD'       TO UV-COLUMN-NA-TEXT        
              MOVE 1                        TO UV-CODE-VALUE-LEN        
              MOVE AZ-FORECAST-TYPE-CD      TO UV-CODE-VALUE-TEXT       
              PERFORM 7100-GET-CD-VALUE        THRU 7100-EXIT           
              MOVE UV-CODE-SHORT-DESC-LEN   TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE UV-CODE-SHORT-DESC-TEXT  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'FCST TYPE CD'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
      *       FORECAST REASON CODE                                              
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 16                       TO UV-TABLE-NA-LEN          
              MOVE 'CSS_ARCHIVE_FCST'       TO UV-TABLE-NA-TEXT         
              MOVE 18                       TO UV-COLUMN-NA-LEN         
              MOVE 'FORECAST_REASON_CD'     TO UV-COLUMN-NA-TEXT        
              MOVE 1                        TO UV-CODE-VALUE-LEN        
              MOVE AZ-FORECAST-REASON-CD    TO UV-CODE-VALUE-TEXT       
              PERFORM 7100-GET-CD-VALUE        THRU 7100-EXIT           
              MOVE UV-CODE-SHORT-DESC-LEN   TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE UV-CODE-SHORT-DESC-TEXT  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'FCST REASON CD'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
           IF WS-ARCH-FCST-FLAG = 'I'                                   
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 12                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '**INSERTED**'           TO MI-PRV-COLUMN-VALUE-TEXT 
      *       FORECAST DATE                                                     
              MOVE 10                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE AZ-FORECAST-DT           TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'FORECAST DATE '         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
      *       FORECAST TYPE CD                                                  
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 16                       TO UV-TABLE-NA-LEN          
              MOVE 'CSS_ARCHIVE_FCST'       TO UV-TABLE-NA-TEXT         
              MOVE 16                       TO UV-COLUMN-NA-LEN         
              MOVE 'FORECAST_TYPE_CD'       TO UV-COLUMN-NA-TEXT        
              MOVE 1                        TO UV-CODE-VALUE-LEN        
              MOVE AZ-FORECAST-TYPE-CD      TO UV-CODE-VALUE-TEXT       
              PERFORM 7100-GET-CD-VALUE        THRU 7100-EXIT           
              MOVE UV-CODE-SHORT-DESC-LEN   TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE UV-CODE-SHORT-DESC-TEXT  TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'FCST TYPE CD  '         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
      *       FORECAST REASON CD                                                
              PERFORM 5210-INITIALIZE       THRU 5210-EXIT              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 16                       TO UV-TABLE-NA-LEN          
              MOVE 'CSS_ARCHIVE_FCST'       TO UV-TABLE-NA-TEXT         
              MOVE 18                       TO UV-COLUMN-NA-LEN         
              MOVE 'FORECAST_REASON_CD'     TO UV-COLUMN-NA-TEXT        
              MOVE 1                        TO UV-CODE-VALUE-LEN        
              MOVE AZ-FORECAST-REASON-CD    TO UV-CODE-VALUE-TEXT       
              PERFORM 7100-GET-CD-VALUE        THRU 7100-EXIT           
              MOVE UV-CODE-SHORT-DESC-LEN   TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE UV-CODE-SHORT-DESC-TEXT  TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'FCST REASON CD'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                 14130000
       5230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726A******************************************************************        
P0726A* 5240-GET-ATTRB-VAL-TX                                                   
P0726A******************************************************************        
P0726A                                                                  
P0726A 5240-GET-ATTRB-VAL-TX.                                           
P0726A                                                                  
P0726A     MOVE SPACES                          TO WS-CODE-VAL-FND      
P0726A                                             WS-ATTRB-VAL-TX.     
P0726A     SET WS-CODE-VAL-INDX                 TO 1.                   
P0726A                                                                  
P0726A     PERFORM 2700-CHECK-LOAD-CODE-VAL     THRU 2700-EXIT.         
P0726A                                                                  
P0726A 5240-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************20540000
      * 7000-SELECT-ACCOUNT                                            *20550000
      ******************************************************************20630000
      *                                                                 20640000
       7000-SELECT-ACCOUNT.                                             
      *                                                                 20660000
           EXEC SQL                                                     
              SELECT                                                    
                     AT.CUSTOMER_NO                                     
                    ,AT.COMPANY_NO                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.CODE_LPC_XMT                                    
                    ,AT.NOTICE_EXEMPT_CD                                
                    ,AT.CODE_DISC_OK                                    
                    ,AT.IVR_EXEMPT_CD                                   
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                 
                INTO                                                    
                     :AT-CUSTOMER-NO                                    
                    ,:AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CODE-LPC-XMT                                   
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:AT-ACCT-FINALED-DT :WS-NULL-IND-1                 
                FROM                                                    
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE                                                    
                     AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     20690000
MFA-TR*       SELECT                                                    20700000
MFA-TR*              AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.CODE_LPC_XMT                                    20700000
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*         INTO                                                            
MFA-TR*              :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-CODE-LPC-XMT                                           
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-ACCT-FINALED-DT :WS-NULL-IND-1                         
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE                                                            
MFA-TR*              AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                 21060000
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    20730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20740000
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                 20760000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND-1 < 0                                      
                 MOVE SPACES                    TO AT-ACCT-FINALED-DT   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7000'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                 20860000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20890000
      ******************************************************************20540000
      * 7010-SELECT-DATE-TIMESTAMP                                     *20550000
      ******************************************************************20630000
      *                                                                 20640000
       7010-SELECT-DATE-TIMESTAMP.                                      
      *                                                                 20660000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TS,
              :WS-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     20690000
MFA-TR*       SET :WS-CURRENT-TS = CURRENT TIMESTAMP                    20700000
MFA-TR*          ,:WS-DATE-TRANS = CURRENT DATE                         21060000
MFA-TR*    END-EXEC.                                                    20730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20740000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 20760000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 20860000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20890000
      ******************************************************************        
      * 7030-SELECT-USER-NAME                                          *        
      ******************************************************************        
      *                                                                         
       7030-SELECT-USER-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     CIS.CHAR2$CHAR (RTRIM(PF.LAST_NAME) + ', ' + RTRIM(
           PF.FIRST_NAME) + ' ' + RTRIM(PF.MIDDLE_NAME), 37)                   
                INTO                                                    
                     :WS-USER-NAME                                      
                FROM                                                    
                     CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE                                                    
                     USER_ID   =  :PF-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              CHAR (RTRIM(PF.LAST_NAME)  || ', ' ||                      
MFA-TR*                    RTRIM(PF.FIRST_NAME) || ' '  ||                      
MFA-TR*                    RTRIM(PF.MIDDLE_NAME), 37)                           
MFA-TR*         INTO                                                            
MFA-TR*              :WS-USER-NAME                                              
MFA-TR*         FROM                                                            
MFA-TR*              CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE                                                            
MFA-TR*              USER_ID   =  :PF-USER-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  MOVE PARM-USER-ID           TO WS-USER-NAME           
              ELSE                                                      
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE '7030'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE SPACES                 TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                  MOVE 'CSS_USER_PROFILE'     TO TABLE-1                
                  MOVE 'USER_ID'              TO TABLE-ELEMENT-1        
                  MOVE PF-USER-ID             TO HOSTVAR-ELEMENT-1      
                  PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-SEL-ACCT-ATTRIBUTE                                        *        
      ******************************************************************        
      *                                                                         
       7040-SEL-ACCT-ATTRIBUTE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     ATTRIBUTE_VALUE_CD                                 
                    ,ATTRIBUTE_VALUE_DT                                 
                    ,ATTRIBUTE_VALUE_TX                                 
                INTO                                                    
                     :YP-ATTRIBUTE-VALUE-CD                             
                    ,:YP-ATTRIBUTE-VALUE-DT                             
                    ,:YP-ATTRIBUTE-VALUE-TX                             
                FROM                                                    
                     CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     ACCOUNT_NO      = :YP-ACCOUNT-NO                   
                 AND ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              ATTRIBUTE_VALUE_CD                                         
MFA-TR*             ,ATTRIBUTE_VALUE_DT                                         
MFA-TR*             ,ATTRIBUTE_VALUE_TX                                         
MFA-TR*         INTO                                                            
MFA-TR*              :YP-ATTRIBUTE-VALUE-CD                                     
MFA-TR*             ,:YP-ATTRIBUTE-VALUE-DT                                     
MFA-TR*             ,:YP-ATTRIBUTE-VALUE-TX                                     
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCT_ATTRIBUTE                                         
MFA-TR*        WHERE                                                            
MFA-TR*              ACCOUNT_NO      = :YP-ACCOUNT-NO                           
MFA-TR*          AND ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                  TO YP-ATTRIBUTE-VALUE-CD  
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7040'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'ATTRIBUTE_DESC'           TO TABLE-ELEMENT-2        
              MOVE YP-ATTRIBUTE-DESC          TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07969900
      * 7050-GET-CR-EXMT-DESC                                          *07492029
      ******************************************************************07550000
      *                                                                         
       7050-GET-CR-EXMT-DESC.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       FW_ATTR_VALUE_DESC                               
                  INTO                                                  
                       :KV-FW-ATTR-VALUE-DESC                           
                  FROM                                                  
                       CSS_FW_ATTRIB_DESC WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                       FW_ATTRIB_TYPE_CD    = :KV-FW-ATTRIB-TYPE-CD     
                   AND FW_ATTR_VALUE_CD     = :KV-FW-ATTR-VALUE-CD      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT                                                          
MFA-TR*                FW_ATTR_VALUE_DESC                                       
MFA-TR*           INTO                                                          
MFA-TR*                :KV-FW-ATTR-VALUE-DESC                                   
MFA-TR*           FROM                                                          
MFA-TR*                CSS_FW_ATTRIB_DESC                                       
MFA-TR*          WHERE                                                          
MFA-TR*                FW_ATTRIB_TYPE_CD    = :KV-FW-ATTRIB-TYPE-CD             
MFA-TR*            AND FW_ATTR_VALUE_CD     = :KV-FW-ATTR-VALUE-CD              
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07930511
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_FW_ATTRIB_DESC'       TO TABLE-1                
              MOVE 'FW_ATTR_VALUE_CD'         TO TABLE-ELEMENT-1        
              MOVE KV-FW-ATTR-VALUE-CD        TO HOSTVAR-ELEMENT-1      
              MOVE 'FW_ATTRIB_TYPE_CD'        TO TABLE-ELEMENT-2        
              MOVE KV-FW-ATTRIB-TYPE-CD       TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07969900
      * 7060-GET-COLL-STATCD                                           *07492029
      ******************************************************************07550000
      *                                                                         
       7060-GET-COLL-STATCD.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       COLLECT_STATUS_CD                                
                  INTO                                                  
                       :FW-COLLECT-STATUS-CD                            
                  FROM                                                  
                       CSS_FINAL_WO WITH(READUNCOMMITTED)                       
                 WHERE                                                  
                       ACCOUNT_NO = :FW-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT                                                          
MFA-TR*                COLLECT_STATUS_CD                                        
MFA-TR*           INTO                                                          
MFA-TR*                :FW-COLLECT-STATUS-CD                                    
MFA-TR*           FROM                                                          
MFA-TR*                CSS_FINAL_WO                                             
MFA-TR*          WHERE                                                          
MFA-TR*                ACCOUNT_NO = :FW-ACCOUNT-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07930511
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7060'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_FINAL_WO'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE FW-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07969900
      * 7070-GET-WO-AMT                                                *07492029
      ******************************************************************07550000
      *                                                                         
       7070-GET-WO-AMT.                                                 
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       SUM(AMT_TRANS)                                   
                  INTO                                                  
                       :CO-AMT-TRANS                                    
                  FROM                                                  
                       CSS_CHRG_OFF WITH(READUNCOMMITTED)                       
                 WHERE                                                  
                       ACCOUNT_NO = :CO-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT                                                          
MFA-TR*                SUM(AMT_TRANS)                                           
MFA-TR*           INTO                                                          
MFA-TR*                :CO-AMT-TRANS                                            
MFA-TR*           FROM                                                          
MFA-TR*                CSS_CHRG_OFF                                             
MFA-TR*          WHERE                                                          
MFA-TR*                ACCOUNT_NO = :CO-ACCOUNT-NO                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07930511
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS                   TO CO-AMT-TRANS           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7070'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CHRG_OFF'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************21260000
      * 7080-SEL-RESP-AREA-ID                                          *21270000
      ******************************************************************21350000
      *                                                                 21360000
       7080-SEL-RESP-AREA-ID.                                           
      *                                                                 21380000
           EXEC SQL                                                     
              SELECT                                                    
                      RESP_AREA_ID                                      
              INTO                                                      
                      :WS-RESP-AREA-ID                                  
              FROM                                                      
                      CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
              WHERE                                                     
                      USER_ID = :PARM-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21410000
MFA-TR*       SELECT                                                    21420000
MFA-TR*               RESP_AREA_ID                                      21420000
MFA-TR*       INTO                                                      21430000
MFA-TR*               :WS-RESP-AREA-ID                                  21430000
MFA-TR*       FROM                                                      21440000
MFA-TR*               CSS_USER_PROFILE                                  21440000
MFA-TR*       WHERE                                                     21450000
MFA-TR*               USER_ID = :PARM-USER-ID                           21450000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                    21460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21470000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 21490000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7080'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_USER_PROFILE'           TO TABLE-1              
              MOVE 'USER_ID'                    TO TABLE-ELEMENT-1      
              MOVE PARM-USER-ID                 TO HOSTVAR-ELEMENT-1    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                 21610000
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21640000
      ******************************************************************        
      * 7090-SEL-ARCH-EXMPT                                            *        
      ******************************************************************        
      *                                                                 21640000
       7090-SEL-ARCH-EXMPT.                                             
      *                                                                 21640000
           EXEC SQL                                                     
              SELECT TOP(1) :WS-Y,
              AA.ARCHIVE_EXEMPT_CD                               
                INTO                                                    
                     :WS-ROW-EXIST                                      
                    ,:AA-ARCHIVE-EXEMPT-CD                              
                FROM                                                    
                     CSS_ARCHIVE_EXEMPT AA WITH(READUNCOMMITTED)                
               WHERE                                                    
                     AA.ACCOUNT_NO = :AA-ACCOUNT-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              :WS-Y                                                      
MFA-TR*             ,AA.ARCHIVE_EXEMPT_CD                                       
MFA-TR*         INTO                                                            
MFA-TR*              :WS-ROW-EXIST                                              
MFA-TR*             ,:AA-ARCHIVE-EXEMPT-CD                                      
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ARCHIVE_EXEMPT AA                                      
MFA-TR*        WHERE                                                            
MFA-TR*              AA.ACCOUNT_NO = :AA-ACCOUNT-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7090'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_ARCHIVE_EXMPT'          TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AA-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-CD-VALUE.                                             *        
      ******************************************************************        
      *                                                                         
       7100-GET-CD-VALUE.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     UV.CODE_SHORT_DESC                                 
                INTO                                                    
                     :UV-CODE-SHORT-DESC                                
                FROM                                                    
                     CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                    
               WHERE                                                    
                     UV.COLUMN_NA   = :UV-COLUMN-NA                     
                 AND UV.TABLE_NA    = :UV-TABLE-NA                      
                 AND UV.CODE_VALUE  = :UV-CODE-VALUE                    
                 AND UV.PROGRAM_ID  = 'ALL'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              UV.CODE_SHORT_DESC                                         
MFA-TR*         INTO                                                            
MFA-TR*              :UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CODE_VALUE UV                                          
MFA-TR*        WHERE                                                            
MFA-TR*              UV.COLUMN_NA   = :UV-COLUMN-NA                             
MFA-TR*          AND UV.TABLE_NA    = :UV-TABLE-NA                              
MFA-TR*          AND UV.CODE_VALUE  = :UV-CODE-VALUE                            
MFA-TR*          AND UV.PROGRAM_ID  = 'ALL'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7000'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_CODE_VALUE'             TO TABLE-1              
              MOVE 'CODE_VALUE'                 TO TABLE-ELEMENT-1      
              MOVE UV-CODE-VALUE                TO HOSTVAR-ELEMENT-1    
              MOVE 'COLUMN_NA'                  TO TABLE-ELEMENT-2      
              MOVE UV-COLUMN-NA                 TO HOSTVAR-ELEMENT-2    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-ARCH-FCST-CUR.                                       *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-ARCH-FCST-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN ARCH_FCST_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7200'                       TO ACTIVE-PARAGRAPH     
              MOVE 'OPEN'                       TO ABEND-FUNCTION       
              MOVE 'CSS_ARCHIVE_FCST'           TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AZ-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'FORECAST_DT'                TO TABLE-ELEMENT-2      
              MOVE AZ-FORECAST-DT               TO HOSTVAR-ELEMENT-2    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7201-FETCH-ARCH-FCST-CUR.                                      *        
      ******************************************************************        
      *                                                                         
       7201-FETCH-ARCH-FCST-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH                                                     
                    ARCH_FCST_CUR                                       
               INTO                                                     
                    :AZ-ACCOUNT-NO                                      
                   ,:AZ-LAST-UPDATE-TS                                  
                   ,:AZ-FORECAST-TYPE-CD                                
                   ,:AZ-FORECAST-REASON-CD                              
                   ,:AZ-FORECAST-DT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'N'                    TO WS-ROW-EXIST         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7201'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE 'CSS_ARCHIVE_FCST'     TO TABLE-1              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE AZ-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    MOVE 'FORECAST_DT'          TO TABLE-ELEMENT-2      
                    MOVE AZ-FORECAST-DT         TO HOSTVAR-ELEMENT-2    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       7201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7202-CLOSE-ARCH-FCST-CUR.                                      *        
      ******************************************************************        
      *                                                                         
       7202-CLOSE-ARCH-FCST-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE ARCH_FCST_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7202'                       TO ACTIVE-PARAGRAPH     
              MOVE 'CLOSE'                      TO ABEND-FUNCTION       
              MOVE 'CSS_ARCHIVE_FCST'           TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AZ-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'FORECAST_DT'                TO TABLE-ELEMENT-2      
              MOVE AZ-FORECAST-DT               TO HOSTVAR-ELEMENT-2    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726A******************************************************************        
P0726A* 7203-OPEN-CODE-VAL-CUR.                                        *        
P0726A******************************************************************        
P0726A                                                                  
P0726A 7203-OPEN-CODE-VAL-CUR.                                          
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A        OPEN CODE_VALUE                                           
P0726A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
P0726A                                                                  
P0726A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726A        CONTINUE                                                  
P0726A     ELSE                                                         
P0726A        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
P0726A        MOVE '7203'                       TO ACTIVE-PARAGRAPH     
P0726A        MOVE 'OPEN'                       TO ABEND-FUNCTION       
P0726A        MOVE 'CSS_CODE_VALUE'             TO TABLE-1              
P0726A        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
P0726A     END-IF.                                                      
P0726A                                                                  
P0726A 7203-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A******************************************************************        
P0726A* 7204-FETCH-CODE-VAL-CUR.                                       *        
P0726A******************************************************************        
P0726A                                                                  
P0726A 7204-FETCH-CODE-VAL-CUR.                                         
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A        FETCH                                                     
P0726A              CODE_VALUE                                          
P0726A         INTO                                                     
P0726A              :UV-CODE-VALUE                                      
P0726A             ,:UV-CODE-LONG-DESC                                  
P0726A             ,:UV-COLUMN-NA                                       
P0726A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
P0726A                                                                  
P0726A     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726A         WHEN SUCCESSFUL-CALL                                     
P0726A         WHEN NOT-FOUND                                           
P0726A              CONTINUE                                            
P0726A         WHEN OTHER                                               
P0726A              MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
P0726A              MOVE '7204'                 TO ACTIVE-PARAGRAPH     
P0726A              MOVE 'FETCH'                TO ABEND-FUNCTION       
P0726A              MOVE 'CSS_CODE_VALUE'       TO TABLE-1              
P0726A              MOVE 'COLUMN_NA'            TO TABLE-ELEMENT-1      
P0726A              MOVE WS-COLUMN-NA           TO HOSTVAR-ELEMENT-1    
P0726A              MOVE 'CODE_VALUE'           TO TABLE-ELEMENT-2      
P0726A              MOVE WS-CODE-VALUE          TO HOSTVAR-ELEMENT-2    
P0726A              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P0726A     END-EVALUATE.                                                
P0726A                                                                  
P0726A 7204-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
P0726A******************************************************************        
P0726A* 7205-CLOSE-CODE-VAL-CUR.                                       *        
P0726A******************************************************************        
P0726A                                                                  
P0726A 7205-CLOSE-CODE-VAL-CUR.                                         
P0726A                                                                  
P0726A     EXEC SQL                                                     
P0726A        CLOSE CODE_VALUE                                          
P0726A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A                                                                  
P0726A     MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
P0726A                                                                  
P0726A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726A        CONTINUE                                                  
P0726A     ELSE                                                         
P0726A        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
P0726A        MOVE '7205'                       TO ACTIVE-PARAGRAPH     
P0726A        MOVE 'CLOSE'                      TO ABEND-FUNCTION       
P0726A        MOVE 'CSS_CODE_VALUE'             TO TABLE-1              
P0726A        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
P0726A     END-IF.                                                      
P0726A                                                                  
P0726A 7205-EXIT.                                                       
P0726A     EXIT.                                                        
P0726A                                                                  
A05470******************************************************************20540000
A05470* 7300-CUST-MISC-INFO.                                           *20550000
A05470******************************************************************20630000
A05470*                                                                 20640000
A05470 7300-CUST-MISC-INFO.                                             
A05470*                                                                 20660000
A05470     EXEC SQL                                                     
A05470        SELECT 'Y'                                                
A05740              ,LQ.IVR_NDO_EXEMPT                                  
A05470          INTO                                                    
A05470               :WS-CUST-EXIST                                     
A05470              ,:WS-PRV-IVR-NDO-EXEMPT-CD                          
A05470          FROM                                                    
A05470               CSS_CUST_MISC_INFO LQ WITH(READUNCOMMITTED)                
A05470         WHERE                                                    
A05470               LQ.CUSTOMER_NO = :LQ-CUSTOMER-NO                   
A05470                                                           
A05470                                                      
A05470     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20690000
MFA-TR*       SELECT 'Y'                                                20700000
MFA-TR*             ,LQ.IVR_NDO_EXEMPT                                          
MFA-TR*         INTO                                                            
MFA-TR*              :WS-CUST-EXIST                                             
MFA-TR*             ,:WS-PRV-IVR-NDO-EXEMPT-CD                                  
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CUST_MISC_INFO LQ                                      
MFA-TR*        WHERE                                                            
MFA-TR*              LQ.CUSTOMER_NO = :LQ-CUSTOMER-NO                           
MFA-TR*         WITH UR                                                 21060000
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                    20730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05470*                                                                 20740000
A05470     MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
A05470*                                                                 20760000
A05470     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05470        CONTINUE                                                  
A05470     ELSE                                                         
A05470        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
A05470        MOVE '7300'                       TO ACTIVE-PARAGRAPH     
A05470        MOVE 'SELECT'                     TO ABEND-FUNCTION       
A05470        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
A05470                                             ABEND-TABLES         
A05470        MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
A05470        MOVE LQ-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
A05470        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
A05470     END-IF.                                                      
A05470*                                                                 20860000
A05470 7300-EXIT.                                                       
A05470     EXIT.                                                        
A05470*                                                                 20890000
      ******************************************************************        
      *  8000-UPDATE-ACCOUNT                                           *31850000
      ******************************************************************        
      *                                                                         
       8000-UPDATE-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              UPDATE                                                    
                     CSS_ACCOUNT                                        
                 SET                                                    
                     CODE_DISC_OK     = :AT-CODE-DISC-OK                
                    ,IVR_EXEMPT_CD    = :AT-IVR-EXEMPT-CD               
                    ,CODE_LPC_XMT     = :AT-CODE-LPC-XMT                
                    ,NOTICE_EXEMPT_CD = :AT-NOTICE-EXEMPT-CD            
               WHERE                                                    
                     ACCOUNT_NO   = :AT-ACCOUNT-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       UPDATE                                                    32000000
MFA-TR*              CSS_ACCOUNT                                        32000000
MFA-TR*          SET                                                            
MFA-TR*              CODE_DISC_OK     = :AT-CODE-DISC-OK                        
MFA-TR*             ,IVR_EXEMPT_CD    = :AT-IVR-EXEMPT-CD                       
MFA-TR*             ,CODE_LPC_XMT     = :AT-CODE-LPC-XMT                        
MFA-TR*             ,NOTICE_EXEMPT_CD = :AT-NOTICE-EXEMPT-CD                    
MFA-TR*        WHERE                                                    32260000
MFA-TR*              ACCOUNT_NO   = :AT-ACCOUNT-NO                      32260000
MFA-TR*      QUERYNO 8000                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32420000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 32420000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '8000'                       TO ACTIVE-PARAGRAPH     
              MOVE 'UPDATE'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_ACCOUNT'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'CODE_DISC_OK'               TO TABLE-ELEMENT-2      
              MOVE AT-CODE-DISC-OK              TO HOSTVAR-ELEMENT-2    
              MOVE 'IVR_EXEMPT_CD'              TO TABLE-ELEMENT-3      
              MOVE AT-IVR-EXEMPT-CD             TO HOSTVAR-ELEMENT-3    
              MOVE 'CODE_LPC_XMT'               TO TABLE-ELEMENT-4      
              MOVE AT-CODE-LPC-XMT              TO HOSTVAR-ELEMENT-4    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8005-DEL-ARCH-EXMPT                                            *        
      ******************************************************************        
      *                                                                         
       8005-DEL-ARCH-EXMPT.                                             
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM CSS_ARCHIVE_EXEMPT                             
              WHERE ACCOUNT_NO = :AA-ACCOUNT-NO                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '8005'                       TO ACTIVE-PARAGRAPH     
              MOVE 'DELETE'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_ARCHIVE_EXMT'           TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AA-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       8005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8010-UPD-ARCH-EXMPT.                                           *        
      ******************************************************************        
      *                                                                         
       8010-UPD-ARCH-EXMPT.                                             
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_ARCHIVE_EXEMPT                                  
                SET ARCHIVE_EXEMPT_CD  = :AA-ARCHIVE-EXEMPT-CD          
              WHERE ACCOUNT_NO         = :AA-ACCOUNT-NO                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '8010'                       TO ACTIVE-PARAGRAPH     
              MOVE 'UPDATE'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_ARCHIVE_EXMPT'          TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AA-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'ARCHIVE_EXEMPT_CD'          TO TABLE-ELEMENT-2      
              MOVE AA-ARCHIVE-EXEMPT-CD         TO HOSTVAR-ELEMENT-2    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8015-INS-ARCH-EXMPT                                            *        
      ******************************************************************        
      *                                                                         
       8015-INS-ARCH-EXMPT.                                             
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ARCHIVE_EXEMPT                          
                       (                                                
                        ACCOUNT_NO                                      
                       ,ARCHIVE_EXEMPT_CD                               
                       ,LAST_UPDATE_USERID                              
                       ,LAST_UPDATE_TS                                  
                       )                                                
                VALUES                                                  
                       (                                                
                        :AA-ACCOUNT-NO                                  
                       ,:AA-ARCHIVE-EXEMPT-CD                           
                       ,:AA-LAST-UPDATE-USERID                          
                       ,CIS.CHAR2TIMESTAMP(:AA-LAST-UPDATE-TS)                  
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ARCHIVE_EXEMPT                                  
MFA-TR*                (                                                        
MFA-TR*                 ACCOUNT_NO                                              
MFA-TR*                ,ARCHIVE_EXEMPT_CD                                       
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :AA-ACCOUNT-NO                                          
MFA-TR*                ,:AA-ARCHIVE-EXEMPT-CD                                   
MFA-TR*                ,:AA-LAST-UPDATE-USERID                                  
MFA-TR*                ,:AA-LAST-UPDATE-TS                                      
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '8015'                       TO ACTIVE-PARAGRAPH     
              MOVE 'INSERT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_ACCOUNT'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AA-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              MOVE 'ARCHIVE_EXMPT_CD'           TO TABLE-ELEMENT-2      
              MOVE AA-ARCHIVE-EXEMPT-CD         TO HOSTVAR-ELEMENT-2    
              MOVE 'LAST_UPDATE_USERID '        TO TABLE-ELEMENT-3      
              MOVE AA-LAST-UPDATE-USERID        TO HOSTVAR-ELEMENT-3    
              MOVE 'LAST_UPDATE_TS'             TO TABLE-ELEMENT-4      
              MOVE AA-LAST-UPDATE-TS            TO HOSTVAR-ELEMENT-4    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       8015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8020-INS-ARCH-FCST                                             *        
      ******************************************************************        
      *                                                                         
       8020-INS-ARCH-FCST.                                              
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ARCHIVE_FCST                            
                       (                                                
                        ACCOUNT_NO                                      
                       ,FORECAST_TYPE_CD                                
                       ,FORECAST_REASON_CD                              
                       ,FORECAST_DT                                     
                       ,LAST_UPDATE_TS                                  
                       ,LAST_UPDATE_USERID                              
                       ,REMARKS                                         
                       ,ACCT_FINALED_DT                                 
                       )                                                
                VALUES                                                  
                       (                                                
                        :AZ-ACCOUNT-NO                                  
                       ,:AZ-FORECAST-TYPE-CD                            
                       ,:AZ-FORECAST-REASON-CD                          
                       ,IIF(TRY_CONVERT(DATE, :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) )                              
                       ,CIS.CHAR2TIMESTAMP(:AZ-LAST-UPDATE-TS)                  
                       ,:AZ-LAST-UPDATE-USERID                          
                       ,:AZ-REMARKS                                     
                       ,CIS.CHAR2TIMESTAMP(:AZ-ACCT-FINALED-DT)                 
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ARCHIVE_FCST                                    
MFA-TR*                (                                                        
MFA-TR*                 ACCOUNT_NO                                              
MFA-TR*                ,FORECAST_TYPE_CD                                        
MFA-TR*                ,FORECAST_REASON_CD                                      
MFA-TR*                ,FORECAST_DT                                             
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,REMARKS                                                 
MFA-TR*                ,ACCT_FINALED_DT                                         
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :AZ-ACCOUNT-NO                                          
MFA-TR*                ,:AZ-FORECAST-TYPE-CD                                    
MFA-TR*                ,:AZ-FORECAST-REASON-CD                                  
MFA-TR*                ,:AZ-FORECAST-DT                                         
MFA-TR*                ,:AZ-LAST-UPDATE-TS                                      
MFA-TR*                ,:AZ-LAST-UPDATE-USERID                                  
MFA-TR*                ,:AZ-REMARKS                                             
MFA-TR*                ,:AZ-ACCT-FINALED-DT                                     
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8020'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ARCHIVE_FCST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'FORECAST_TYPE_CD'    TO TABLE-ELEMENT-2             
              MOVE AZ-FORECAST-TYPE-CD   TO HOSTVAR-ELEMENT-2           
              MOVE 'FORECAST_REASON_CD'  TO TABLE-ELEMENT-3             
              MOVE AZ-FORECAST-REASON-CD TO HOSTVAR-ELEMENT-3           
              MOVE 'FORECAST_DT'         TO TABLE-ELEMENT-4             
              MOVE AZ-FORECAST-DT        TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8030-INSERT-ATTRB-CD                                           *        
      ******************************************************************        
      *                                                                         
       8030-INSERT-ATTRB-CD.                                            
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_ATTRIBUTE                           
                     (ACCOUNT_NO                                        
                     ,ATTRIBUTE_DESC                                    
                     ,ATTRIBUTE_VALUE_CD                                
                     ,ATTRIBUTE_VALUE_DT                                
                     ,ATTRIBUTE_VALUE_TX                                
                     ,STATUS_CD)                                        
               VALUES                                                   
                     (:YP-ACCOUNT-NO                                    
                     ,:YP-ATTRIBUTE-DESC                                
                     ,:YP-ATTRIBUTE-VALUE-CD                            
                     ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
                     ,:YP-ATTRIBUTE-VALUE-TX                            
                     ,:YP-STATUS-CD)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*              (ACCOUNT_NO                                                
MFA-TR*              ,ATTRIBUTE_DESC                                            
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,ATTRIBUTE_VALUE_TX                                        
MFA-TR*              ,STATUS_CD)                                                
MFA-TR*        VALUES                                                           
MFA-TR*              (:YP-ACCOUNT-NO                                            
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                        
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,CURRENT DATE                                              
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX                                    
MFA-TR*              ,:YP-STATUS-CD)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8030'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ATTRIBUTE_DESC'      TO TABLE-ELEMENT-2             
              MOVE YP-ATTRIBUTE-DESC     TO HOSTVAR-ELEMENT-2           
              MOVE 'ATTRIBUTE_VALUE_CD'  TO TABLE-ELEMENT-3             
              MOVE YP-ATTRIBUTE-VALUE-CD TO HOSTVAR-ELEMENT-3           
              MOVE 'ATTRIBUTE_VALUE_DT'  TO TABLE-ELEMENT-4             
              MOVE YP-ATTRIBUTE-VALUE-DT TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8040-UPDATE-ATTRB-CD                                           *        
      ******************************************************************        
      *                                                                         
       8040-UPDATE-ATTRB-CD.                                            
      *                                                                         
           EXEC SQL                                                     
               UPDATE                                                   
                      CSS_ACCT_ATTRIBUTE                                
                  SET                                                   
                      ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD       
                     ,ATTRIBUTE_VALUE_DT = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                     ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX       
                WHERE                                                   
                      ACCOUNT_NO     = :YP-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE                                                           
MFA-TR*               CSS_ACCT_ATTRIBUTE                                        
MFA-TR*           SET                                                           
MFA-TR*               ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD               
MFA-TR*              ,ATTRIBUTE_VALUE_DT = CURRENT DATE                         
MFA-TR*              ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX               
MFA-TR*         WHERE                                                           
MFA-TR*               ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*       QUERYNO 8040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8040'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ATTRIBUTE_DESC'      TO TABLE-ELEMENT-2             
              MOVE YP-ATTRIBUTE-DESC     TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8050-DELETE-ATTRB-CD                                           *        
      ******************************************************************        
      *                                                                         
       8050-DELETE-ATTRB-CD.                                            
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_ATTRIBUTE                           
                WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_ATTRIBUTE                                   
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*      QUERYNO 8050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8050'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ATTRIBUTE_DESC'      TO TABLE-ELEMENT-2             
              MOVE YP-ATTRIBUTE-DESC     TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07969900
      * 8060-UPDATE-FIN-WO                                             *07492029
      ******************************************************************07550000
      *                                                                         
       8060-UPDATE-FIN-WO.                                              
      *                                                                         
           EXEC SQL                                                     
              UPDATE                                                    
                     CSS_FIN_WO_COLLECT                                 
                 SET                                                    
                     WITHDRAW_DT        = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                    ,WITHDRAW_AM        = :IZ-WITHDRAW-AM               
                    ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD        
               WHERE                                                    
                     ACCOUNT_NO         = :IZ-ACCOUNT-NO                
                 AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD         
                 AND WITHDRAW_DT       >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*       UPDATE                                                            
MFA-TR*              CSS_FIN_WO_COLLECT                                         
MFA-TR*          SET                                                            
MFA-TR*              WITHDRAW_DT        = CURRENT DATE                          
MFA-TR*             ,WITHDRAW_AM        = :IZ-WITHDRAW-AM                       
MFA-TR*             ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD                
MFA-TR*        WHERE                                                            
MFA-TR*              ACCOUNT_NO         = :IZ-ACCOUNT-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD                 
MFA-TR*          AND WITHDRAW_DT       >= CURRENT DATE                          
MFA-TR*      QUERYNO 8060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07930511
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8060'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'FW-ACTION-TYPE-CD'   TO TABLE-ELEMENT-2             
              MOVE IZ-FW-ACTION-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8070-DEL-ARCHV-FCST                                            *        
      ******************************************************************        
      *                                                                         
       8070-DEL-ARCHV-FCST.                                             
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM                                                
                    AZ                                  
             FROM CSS_ARCHIVE_FCST AZ
              WHERE                                                     
                    AZ.ACCOUNT_NO     = :AZ-ACCOUNT-NO                  
                AND AZ.LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :AZ-LAST-UPDATE-TS
              )              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM                                                        
MFA-TR*             CSS_ARCHIVE_FCST AZ                                         
MFA-TR*       WHERE                                                             
MFA-TR*             AZ.ACCOUNT_NO     = :AZ-ACCOUNT-NO                          
MFA-TR*         AND AZ.LAST_UPDATE_TS = :AZ-LAST-UPDATE-TS                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ARCHIVE_FCST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'LAST_UPDATE_TS'          TO TABLE-ELEMENT-2         
              MOVE AZ-LAST-UPDATE-TS         TO HOSTVAR-ELEMENT-2       
           END-IF.                                                      
      *                                                                         
       8070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A05470*  8100-UPDATE-CUST-MISC-INFO                                    *31850000
A05470******************************************************************        
A05470*                                                                         
A05470 8100-UPDATE-CUST-MISC-INFO.                                      
A05470*                                                                         
A05470     EXEC SQL                                                     
A05470        UPDATE                                                    
A05470               LQ                               
A05470           SET                                                    
A05470               LQ.IVR_NDO_EXEMPT   = :LQ-IVR-NDO-EXEMPT           
              FROM CSS_CUST_MISC_INFO LQ
A05470         WHERE                                                    
A05470               LQ.CUSTOMER_NO      = :LQ-CUSTOMER-NO              
A05470                                                      
A05470     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       UPDATE                                                    32000000
MFA-TR*              CSS_CUST_MISC_INFO LQ                              32000000
MFA-TR*          SET                                                            
MFA-TR*              LQ.IVR_NDO_EXEMPT   = :LQ-IVR-NDO-EXEMPT                   
MFA-TR*        WHERE                                                    32260000
MFA-TR*              LQ.CUSTOMER_NO      = :LQ-CUSTOMER-NO              32260000
MFA-TR*      QUERYNO 8100                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05470*                                                                 32420000
A05470     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05470*                                                                 32420000
A05470     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A05470        CONTINUE                                                  
A05470     ELSE                                                         
A05470        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
A05470        MOVE '8100'                       TO ACTIVE-PARAGRAPH     
A05470        MOVE 'UPDATE'                     TO ABEND-FUNCTION       
A05470        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
A05470                                             ABEND-TABLES         
A05470        MOVE 'CSS_CUST_MISC_INFO'         TO TABLE-1              
A05470        MOVE 'IVR_NDO_EXEMPT'             TO TABLE-ELEMENT-1      
A05470        MOVE LQ-IVR-NDO-EXEMPT            TO HOSTVAR-ELEMENT-1    
A05470        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
A05470     END-IF.                                                      
A05470*                                                                         
A05470 8100-EXIT.                                                       
A05470     EXIT.                                                        
A05470*                                                                         
A05470******************************************************************        
A05470* 8200-INSERT-CUST-MISC-INFO.                                    *        
A05470******************************************************************        
A05470*                                                                         
A05470 8200-INSERT-CUST-MISC-INFO.                                      
A05470*                                                                         
A05470     EXEC SQL                                                     
A05470          INSERT INTO CSS_CUST_MISC_INFO                          
A05470                 (                                                
A05470                  CUSTOMER_NO                                     
A05470                 ,IVR_NDO_EXEMPT                                  
A05470                 )                                                
A05470          VALUES                                                  
A05470                 (                                                
A05470                  :LQ-CUSTOMER-NO                                 
A05470                 ,:LQ-IVR-NDO-EXEMPT                              
A05470                 )                                                
A05470     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05470*                                                                         
A05470     MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
A05470*                                                                         
A05470     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A05470        CONTINUE                                                  
A05470     ELSE                                                         
A05470        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
A05470        MOVE '8200'                       TO ACTIVE-PARAGRAPH     
A05470        MOVE 'INSERT'                     TO ABEND-FUNCTION       
A05470        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
A05470                                             ABEND-TABLES         
A05470        MOVE 'CSS_CUST_MISC_INFO'         TO TABLE-1              
A05470        MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
A05470        MOVE LQ-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
A05470        MOVE 'IVR_NDO_EXEMPT'             TO TABLE-ELEMENT-2      
A05470        MOVE LQ-IVR-NDO-EXEMPT            TO HOSTVAR-ELEMENT-2    
A05470        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
A05470     END-IF.                                                      
A05470*                                                                         
A05470 8200-EXIT.                                                       
A05470     EXIT.                                                        
A05470*                                                                         
      ******************************************************************        
      * 8895-INSERT-WORK-QUEUE                                         *        
      ******************************************************************        
      *                                                                         
       8895-INSERT-WORK-QUEUE.                                          
ACT108                                                                  
ACT108     CALL MCSCB077 USING CWS00077-FIELDS                          
ACT108                        ,ABEND-FILE                               
ACT108                        ,RS-RETURN-CODE                           
ACT108                                                                  
ACT108     MOVE RS-RETURN-CODE               TO WS-ACTIVE-RETURN-CODE.  
ACT108                                                                  
ACT108     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT108         CONTINUE                                                 
ACT108     ELSE                                                         
ACT108         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT108         DISPLAY 'CALL MCSCB077         '                         
ACT108         MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
ACT108         MOVE '8895'             TO ACTIVE-PARAGRAPH              
ACT108         MOVE 'CALL'             TO ABEND-FUNCTION                
ACT108         MOVE 'MCSCB077'         TO TABLE-1                       
ACT108         MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
ACT108         MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-2               
ACT108         MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3               
ACT108         MOVE WS-77-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1             
ACT108         MOVE WS-77-PREMISE-NO   TO HOSTVAR-ELEMENT-2             
ACT108         MOVE WS-77-CUSTOMER-NO  TO HOSTVAR-ELEMENT-3             
ACT108         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
ACT108         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
ACT108     END-IF.                                                      
      *                                                                         
       8895-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE.           
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00341600
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                 00341600
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE        THRU 8900-EXIT                 
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
