       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04777.                                            
       DATE-WRITTEN. 08/18/14.                                          
       DATE-COMPILED.                                                   
       AUTHOR. SATISH SIVASUBRAMANIAN.                                  
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *                   START BILLING LIGHTS                         *        
      *                   ====================                         *        
      *                                                                *        
      *              THIS SP STARTS BILLING PENDING LIGHTS             *        
      *                                                                *        
      * THIS GETS CALLED WHEN 4F.BILLING_FL = 'Z'. FIRST CALL SCANS    *        
      * THE TABLES FOR REVENUE CLASS AND IF AVAILABLE IT CALLS  THE    *        
      * COPYBOOK AND MAKES NECESSARY UPDATES FOR START BILLING.WHEN    *        
      * REVENUE CLASS IS UNAVAILABLE, IT GIVES A RETURN CODE  WHICH    *        
      * INDICATES USER HAS TO MANUALLY SELECT THE REVENUE CLASS FOR    *        
      * APLICABLE FIXTURES & POLES. THUS A SECOND CALL WILL EXECUTE    *        
      * THE COPYBOOK AS IT WILL HAVE ALLTHE REVENUE CLASSES IN PARM.   *        
      * A TRANSACTION HISTORY IS WRITTEN FOR EACH COPYBOOK CALL.       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/19/14  SS95855    PROJ#0817 PROCEDURE ORIGINALLY CODED.    *        
ACT027*  05/16/15  VK7L032    APPL#5084 USE CURRENT DATE ONLY IF INSTAL*        
      *                       IS NUL OR SPACES.                        *        
      ******************************************************************        
      *****************************************************************         
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04777'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                         PIC X(40) VALUE             
           'WORKING STORAGE FOR CSR04777 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR04777'. 
           05 CSRERLOG                      PIC X(08) VALUE 'CSRERLOG'. 
           05 WS-YES                        PIC X(01) VALUE 'Y'.        
           05 WS-NO                         PIC X(01) VALUE 'N'.        
           05 WS-BILL-FL-Z                  PIC X(01) VALUE 'Z'.        
           05 WS-NEW                        PIC X(07) VALUE '**NEW**'.  
           05 WS-TRAN-COMNTS                PIC X(20) VALUE             
                                               'START BILLING LIGHTS'.  
ACT027     05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
                                                                        
       01  WS-MISC.                                                     
           05 WS-SQLSTATE                   PIC X(05) VALUE SPACES.     
           05 WS-ACTION-DATE                PIC X(10) VALUE SPACES.     
           05 WS-EQUIP-SEQUENCE             PIC 9(10).                  
           05 WS-EQUIP-SEQUENCE-STR      REDEFINES                      
              WS-EQUIP-SEQUENCE             PIC X(10).                  
           05 WS-INSTALL-LOC-NO             PIC X(10) VALUE SPACES.     
      *    05 WS-INSTALL-POINT-NO           PIC S9(05)V COMP-3 VALUE 0.         
           05 WS-RATE-ITEM-CD               PIC ZZZ9.                   
           05 WS-IC-NO                      PIC ZZZ9.                   
                                                                        
       01  WS-ACTION-CODE                   PIC X(01) VALUE ' '.        
           88 ADD-NEW-LIGHT                           VALUE 'N'.        
           88 ACTIVATE                                VALUE 'A'.        
           88 INACTIVATE                              VALUE 'I'.        
           88 REMOVE                                  VALUE 'R'.        
           88 RATE-CHANGE                             VALUE 'C'.        
                                                                        
       01  WS-EQUIP-ARRAY.                                              
           05 WS-EQUIP-COUNT                PIC 9(03) VALUE ZERO.       
           05 WS-SUB                        PIC 9(03) VALUE ZERO.       
           05 WS-EQUIP-TABLE OCCURS 6 TIMES.                            
              10 WS-INST-LOC-NO             PIC X(10).                  
COB305        10 WS-INST-PT-NO        PIC S9(05)V COMP-3 VALUE 0.         
COB305        10 WS-EQUIP-SEQ        PIC S9(10)V COMP-3 VALUE 0.         
              10 WS-TAG-NO                  PIC X(12).                  
              10 WS-BILLING-FL              PIC X(01).                  
              10 WS-UTL-TYP                 PIC X(01).                  
              10 WS-RATE-PLAN               PIC X(03).                  
              10 WS-REV-CLS                 PIC X(03).                  
                                                                        
ACT027 01  WS-NULL-INDICATORS.                                          
ACT027     05  IND-INSTALL-DT               PIC S9(04) COMP.            
                                                                        
       01  CSRERLOG-P.                                                  
           10 S-SP-NAME                     PIC X(18) VALUE SPACES.     
           10 S-SQLCODE                     PIC S9(09) COMP VALUE 0.    
           10 S-SQLSTATE                    PIC X(05)  VALUE ' '.       
           10 S-TABLE-NAME                  PIC X(18) VALUE SPACES.     
           10 S-HOST-VARIABLES.                                         
              49 S-HOST-VARIABLES-L         PIC S9(4) COMP.             
              49 S-HOST-VARIABLES-V         PIC X(255).                 
           10 S-SQL-STATEMENT.                                          
              49 S-SQL-STATEMENT-L          PIC S9(4) COMP.             
              49 S-SQL-STATEMENT-V          PIC X(255).                 
           10 S-SQL-DESCRIPTION.                                        
              49 S-SQL-DESCRIPTION-L        PIC S9(4) COMP.             
              49 S-SQL-DESCRIPTION-V        PIC X(255).                 
           05 WS-ABEND-SQLERRMC.                                        
              49 WS-ABEND-SQLERRMC-L        PIC S9(4) COMP.             
              49 WS-ABEND-SQLERRMC-V        PIC X(255).                 
                                                                        
       01  PARM-FIELDS.                                                 
           05 PARM-CALL-TYPE                PIC X(01) VALUE SPACES.     
           05 PARM-FXTR-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0. 
           05 PARM-FXTR-TAG-NO              PIC X(12) VALUE SPACES.     
           05 PARM-FXTR-INST-LOC-NO         PIC X(10) VALUE SPACES.     
           05 PARM-FXTR-INST-LOC-NUM REDEFINES                          
              PARM-FXTR-INST-LOC-NO         PIC 9(10).                  
           05 PARM-FXTR-INST-POINT-NO       PIC S9(05)V COMP-3 VALUE 0. 
           05 PARM-FXTR-UTIL-TYPE           PIC X(01) VALUE SPACES.     
           05 PARM-FXTR-RATE-PLAN           PIC X(03) VALUE SPACES.     
           05 PARM-FXTR-REV-CLS             PIC X(03) VALUE SPACES.     
           05 PARM-POL1-INST-POINT-NO       PIC S9(05)V COMP-3 VALUE 0. 
           05 PARM-POL1-REV-CLS             PIC X(03) VALUE SPACES.     
           05 PARM-POL2-INST-POINT-NO       PIC S9(05)V COMP-3 VALUE 0. 
           05 PARM-POL2-REV-CLS             PIC X(03) VALUE SPACES.     
           05 PARM-POL3-INST-POINT-NO       PIC S9(05)V COMP-3 VALUE 0. 
           05 PARM-POL3-REV-CLS             PIC X(03) VALUE SPACES.     
           05 PARM-POL4-INST-POINT-NO       PIC S9(05)V COMP-3 VALUE 0. 
           05 PARM-POL4-REV-CLS             PIC X(03) VALUE SPACES.     
           05 PARM-POL5-INST-POINT-NO       PIC S9(05)V COMP-3 VALUE 0. 
           05 PARM-POL5-REV-CLS             PIC X(03) VALUE SPACES.     
           05 PARM-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0. 
           05 PARM-USER-ID                  PIC X(07) VALUE SPACES.     
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS-1                    PIC S9(9) COMP VALUE 0.     
           05 CTR-ROWS-2                    PIC S9(9) COMP VALUE 0.     
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW                   PIC X(01) VALUE 'N'.        
              88 NOT-ALL-DONE                         VALUE 'N'.        
              88 ALL-DONE                             VALUE 'Y'.        
           05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.        
              88 SEND-DONE-ERROR                      VALUE 'N'.        
              88 SEND-DONE-OK                         VALUE 'Y'.        
           05 WS-CALL-TYPE                  PIC X(01) VALUE ' '.        
              88 FIRST-CALL                           VALUE 'I'.        
              88 SECOND-CALL                          VALUE 'N'.        
           05 REV-CLASS-SW                  PIC X(01) VALUE 'Y'.        
              88 REV-CLASS-FOUND                      VALUE 'Y'.        
              88 REV-CLASS-NOT-FOUND                  VALUE 'N'.        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05 GTT-ROW.                                                  
              49 GTT-ROW-LEN                PIC S9(4) COMP.             
              49 GTT-ROW-CHAR               PIC X(1024).                
           05 GTT-SQLCODE                   PIC S9(9) COMP.             
           05 GTT-NAME-R1                   PIC X(26) VALUE             
                                          'SESSION.CSR04777_R1'.        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE                 PIC S9(9) COMP VALUE 0.     
           10 S-APPL-RETURN-CODE            PIC S9(9) COMP VALUE 0.     
           10 S-BUS-RULE-ID                 PIC X(10) VALUE SPACES.     
           10 S-BUS-RULE-RESULT-CD          PIC X(08) VALUE SPACES.     
           10 S-BUS-RULE-XREF-ID            PIC X(26) VALUE SPACES.     
      *                                                                         
      *** WS LMS COPYBOOK TO SYNC RATES                                         
           EXEC SQL                                                             
              INCLUDE CWSLM001                                                  
           END-EXEC.                                                            
                                                                        
      *** WS ABEND WORK AREA                                                    
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *** DB2 ERROR CHECKING.                                                   
           COPY CWS00303.                                                       
                                                                        
      *** SQL COMMUNICATION AREA                                                
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC .                                                           
                                                                        
      *** LMS_EQUIP_ENVRNMT,4F                                                  
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_INVENTRY,4D                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_FXTR_ATTACHMTS,4H                                                 
           EXEC SQL                                                             
              INCLUDE TBFXTATC                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST,4J                                                     
           EXEC SQL                                                             
              INCLUDE TBLGTHST                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST_DET,4S                                                 
           EXEC SQL                                                             
              INCLUDE TBLMSHST                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      **** CSS_REV_CLS_RATE, Q8                                                 
           EXEC SQL                                                             
               INCLUDE TBRVCLS                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MNT_TRANS_HIST, MH                                                
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MT_TRN_HST_DET, MI                                                
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ***  CSS_MTRD_ENVRNMT, MN                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      ***  CSS_PREMISE, PR                                                      
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
      ***  CSS_CUSTOMER, CU                                                     
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ***  CSS_RESP_AREA, C1                                                    
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      *    CSS_CUST_PREM_HIST, CH                                               
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
      *    CSS_ACCOUNT, AT                                                      
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *--------< TO BREAK UP CODES_DATA_PRESENT         >                       
           COPY CWS00056.                                                       
      *                                                                         
      *--------< WORKING STORAGE COPYBOOK FOR CPD00118  >                       
           EXEC SQL                                                             
              INCLUDE CWS00118                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------< WORKING STORAGE COPYBOOK FOR CPDLM004  >                       
           EXEC SQL                                                             
              INCLUDE CWSLM004                                                  
           END-EXEC.                                                            
      *                                                                         
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET ALL POLES TO BUILD THE ARRAY       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE EQUIP_CSR CURSOR FOR                              
                 SELECT [4H].ATTACH_EQUIP_SEQ                             
                       ,[4F].INSTALL_LOC_NO                               
                       ,[4F].INSTALL_POINT_NO                             
                       ,[4F].BILLING_FL                                   
                       ,[4F].CODE_UTIL_TYPE                               
                       ,[4F].RATE_PLAN_NO                                 
                       ,[4D].EQUIP_TAG_NO                                 
                   FROM LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)           
                       ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)           
                       ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                  WHERE [4H].ATTACH_EQUIP_SEQ = [4F].EQUIP_SEQ              
                    AND [4F].EQUIP_SEQ        = [4D].EQUIP_SEQ              
                    AND [4H].FXTR_EQUIP_SEQ   = :4H-FXTR-EQUIP-SEQ        
                    AND [4H].EQUIP_TYPE_CD    = [4D].EQUIP_TYPE_CD          
                    AND [4H].EQUIP_TYPE_CD    = 'P'                       
                    AND [4F].INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO        
                    AND [4F].RATE_PLAN_NO     > '   '                     
                    AND [4F].RATE_ITEM_CODE   >  0                        
                    AND [4F].BILLING_FL       IN ('Z','N')                
                FOR READ ONLY                                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EQUIP_CSR CURSOR FOR                                      
MFA-TR*          SELECT 4H.ATTACH_EQUIP_SEQ                                     
MFA-TR*                ,4F.INSTALL_LOC_NO                                       
MFA-TR*                ,4F.INSTALL_POINT_NO                                     
MFA-TR*                ,4F.BILLING_FL                                           
MFA-TR*                ,4F.CODE_UTIL_TYPE                                       
MFA-TR*                ,4F.RATE_PLAN_NO                                         
MFA-TR*                ,4D.EQUIP_TAG_NO                                         
MFA-TR*            FROM LMS_FXTR_ATTACHMTS 4H                                   
MFA-TR*                ,LMS_EQUIP_ENVRNMT  4F                                   
MFA-TR*                ,LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*           WHERE 4H.ATTACH_EQUIP_SEQ = 4F.EQUIP_SEQ                      
MFA-TR*             AND 4F.EQUIP_SEQ        = 4D.EQUIP_SEQ                      
MFA-TR*             AND 4H.FXTR_EQUIP_SEQ   = :4H-FXTR-EQUIP-SEQ                
MFA-TR*             AND 4H.EQUIP_TYPE_CD    = 4D.EQUIP_TYPE_CD                  
MFA-TR*             AND 4H.EQUIP_TYPE_CD    = 'P'                               
MFA-TR*             AND 4F.INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO                
MFA-TR*             AND 4F.RATE_PLAN_NO     > '   '                             
MFA-TR*             AND 4F.RATE_ITEM_CODE   >  0                                
MFA-TR*             AND 4F.BILLING_FL       IN ('Z','N')                        
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  LINK-CALL-TYPE                   PIC X(01).                  
COB305 01 LINK-FXTR-EQUIP-SEQ        PIC S9(10)V COMP-3 VALUE 0.         
       01  LINK-FXTR-TAG-NO                 PIC X(12).                  
       01  LINK-FXTR-INST-LOC-NO            PIC X(10).                  
COB305 01 LINK-FXTR-INST-POINT-NO        PIC S9(05)V COMP-3 VALUE 0.         
       01  LINK-FXTR-UTIL-TYPE              PIC X(01).                  
       01  LINK-FXTR-RATE-PLAN              PIC X(03).                  
       01  LINK-FXTR-REV-CLS                PIC X(03).                  
COB305 01 LINK-POL1-INST-POINT-NO        PIC S9(05)V COMP-3 VALUE 0.         
       01  LINK-POL1-REV-CLS                PIC X(03).                  
COB305 01 LINK-POL2-INST-POINT-NO        PIC S9(05)V COMP-3 VALUE 0.         
       01  LINK-POL2-REV-CLS                PIC X(03).                  
COB305 01 LINK-POL3-INST-POINT-NO        PIC S9(05)V COMP-3 VALUE 0.         
       01  LINK-POL3-REV-CLS                PIC X(03).                  
COB305 01 LINK-POL4-INST-POINT-NO        PIC S9(05)V COMP-3 VALUE 0.         
       01  LINK-POL4-REV-CLS                PIC X(03).                  
COB305 01 LINK-POL5-INST-POINT-NO        PIC S9(05)V COMP-3 VALUE 0.         
       01  LINK-POL5-REV-CLS                PIC X(03).                  
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.         
       01  LINK-USER-ID                     PIC X(07).                  
                                                                        
       PROCEDURE DIVISION USING LINK-CALL-TYPE                          
                                LINK-FXTR-EQUIP-SEQ                     
                                LINK-FXTR-TAG-NO                        
                                LINK-FXTR-INST-LOC-NO                   
                                LINK-FXTR-INST-POINT-NO                 
                                LINK-FXTR-UTIL-TYPE                     
                                LINK-FXTR-RATE-PLAN                     
                                LINK-FXTR-REV-CLS                       
                                LINK-POL1-INST-POINT-NO                 
                                LINK-POL1-REV-CLS                       
                                LINK-POL2-INST-POINT-NO                 
                                LINK-POL2-REV-CLS                       
                                LINK-POL3-INST-POINT-NO                 
                                LINK-POL3-REV-CLS                       
                                LINK-POL4-INST-POINT-NO                 
                                LINK-POL4-REV-CLS                       
                                LINK-POL5-INST-POINT-NO                 
                                LINK-POL5-REV-CLS                       
                                LINK-ACCOUNT-NO                         
                                LINK-USER-ID.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PARA     THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE-PARA                                           *        
      ******************************************************************        
       0100-INITIALIZE-PARA.                                            
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLCSS-REV-CLS-RATE                               
                      DCLLMS-EQUIP-ENVRNMT                              
                      DCLLMS-EQUIP-INVENTRY                             
                      DCLLMS-FXTR-ATTACHMTS                             
                      DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04777_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04777_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS      THRU 8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME-R1           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04777_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04777_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-CALL-TYPE              TO PARM-CALL-TYPE.          
           MOVE LINK-FXTR-EQUIP-SEQ         TO PARM-FXTR-EQUIP-SEQ.     
           MOVE LINK-FXTR-TAG-NO            TO PARM-FXTR-TAG-NO.        
           MOVE LINK-FXTR-INST-LOC-NO       TO PARM-FXTR-INST-LOC-NO.   
           MOVE LINK-FXTR-INST-POINT-NO     TO PARM-FXTR-INST-POINT-NO. 
           MOVE LINK-FXTR-UTIL-TYPE         TO PARM-FXTR-UTIL-TYPE.     
           MOVE LINK-FXTR-RATE-PLAN         TO PARM-FXTR-RATE-PLAN.     
           MOVE LINK-FXTR-REV-CLS           TO PARM-FXTR-REV-CLS.       
           MOVE LINK-POL1-INST-POINT-NO     TO PARM-POL1-INST-POINT-NO. 
           MOVE LINK-POL1-REV-CLS           TO PARM-POL1-REV-CLS.       
           MOVE LINK-POL2-INST-POINT-NO     TO PARM-POL2-INST-POINT-NO. 
           MOVE LINK-POL2-REV-CLS           TO PARM-POL2-REV-CLS.       
           MOVE LINK-POL3-INST-POINT-NO     TO PARM-POL3-INST-POINT-NO. 
           MOVE LINK-POL3-REV-CLS           TO PARM-POL3-REV-CLS.       
           MOVE LINK-POL4-INST-POINT-NO     TO PARM-POL4-INST-POINT-NO. 
           MOVE LINK-POL4-REV-CLS           TO PARM-POL4-REV-CLS.       
           MOVE LINK-POL5-INST-POINT-NO     TO PARM-POL5-INST-POINT-NO. 
           MOVE LINK-POL5-REV-CLS           TO PARM-POL5-REV-CLS.       
           MOVE LINK-ACCOUNT-NO             TO PARM-ACCOUNT-NO.         
           MOVE LINK-USER-ID                TO PARM-USER-ID.            
                                                                        
           MOVE PARM-CALL-TYPE              TO WS-CALL-TYPE.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * BUILD A WORKING STORAGE ARRAY.                                 *        
      * IF REVENUE CLASS IS AVAILABLE START BILLING THEM.              *        
      * IF REVENUE CLASS IS NOT AVAILABLE GET IT FROM THE USER AND     *        
      * START BILLING THEM.                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-ACTION-DATE        THRU 7000-EXIT.          
                                                                        
           PERFORM 2100-BUILD-ENVRNMT-ARRAY    THRU 2100-EXIT.          
                                                                        
           IF REV-CLASS-FOUND                                           
              PERFORM 2500-START-BILLING           THRU 2500-EXIT       
              IF PARM-FXTR-RATE-PLAN NOT = '064'                        
                 PERFORM 2600-SET-ACCT-STAT-TO-ACTIVE THRU 2600-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CREATE A WORKING STORAGE ARRAY TO LOAD FIXTURE & POLE DETAILS  *        
      * GET REVENUE CLASS FROM RATE IF AVAILABLE DURING THE FIRST CALL *        
      * USE THE PARM REVENUE CLASS DURING THE SECOND CALL.             *        
      ******************************************************************        
       2100-BUILD-ENVRNMT-ARRAY.                                        
                                                                        
           INITIALIZE WS-EQUIP-ARRAY.                                   
                                                                        
           MOVE PARM-ACCOUNT-NO             TO UT-ACCOUNT-NO.           
           MOVE PARM-FXTR-INST-LOC-NUM      TO UT-PREMISE-NO.           
                                                                        
           COMPUTE WS-SUB = WS-SUB + 1.                                 
           MOVE WS-SUB                      TO WS-EQUIP-COUNT.          
           MOVE PARM-FXTR-INST-LOC-NO       TO WS-INST-LOC-NO(WS-SUB)   
           MOVE PARM-FXTR-INST-POINT-NO     TO WS-INST-PT-NO(WS-SUB)    
           MOVE PARM-FXTR-EQUIP-SEQ         TO WS-EQUIP-SEQ(WS-SUB)     
           MOVE PARM-FXTR-RATE-PLAN         TO WS-RATE-PLAN(WS-SUB)     
           MOVE PARM-FXTR-UTIL-TYPE         TO WS-UTL-TYP(WS-SUB)       
           MOVE PARM-FXTR-TAG-NO            TO WS-TAG-NO(WS-SUB)        
           MOVE WS-BILL-FL-Z                TO WS-BILLING-FL(WS-SUB)    
                                                                        
           IF FIRST-CALL AND (PARM-FXTR-RATE-PLAN NOT = '064')          
              MOVE PARM-FXTR-RATE-PLAN      TO Q8-RATE-PLAN-NO          
              PERFORM 2300-GET-REVENUE-CLASS   THRU 2300-EXIT           
           END-IF.                                                      
                                                                        
           MOVE PARM-FXTR-EQUIP-SEQ         TO 4H-FXTR-EQUIP-SEQ.       
           MOVE PARM-FXTR-INST-LOC-NO       TO 4F-INSTALL-LOC-NO.       
                                                                        
           PERFORM 7010-OPEN-POLE-CSR          THRU 7010-EXIT.          
           PERFORM 7020-FETCH-POLE-CSR         THRU 7020-EXIT.          
           PERFORM 2200-LOAD-ALL-POLES         THRU 2200-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7030-CLOSE-POLE-CSR         THRU 7030-EXIT.          
                                                                        
           IF SECOND-CALL                                               
              PERFORM 2400-LOAD-PARM-REV-CLS   THRU 2400-EXIT           
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * LOADS EACH POLE DETAILS FROM THE CURSOR                        *        
      ******************************************************************        
       2200-LOAD-ALL-POLES.                                             
                                                                        
           COMPUTE WS-SUB = WS-SUB + 1.                                 
           MOVE WS-SUB                      TO WS-EQUIP-COUNT.          
                                                                        
           MOVE 4H-ATTACH-EQUIP-SEQ         TO WS-EQUIP-SEQ(WS-SUB).    
           MOVE 4F-INSTALL-LOC-NO           TO WS-INST-LOC-NO(WS-SUB).  
           MOVE 4F-INSTALL-POINT-NO         TO WS-INST-PT-NO(WS-SUB).   
           MOVE 4F-CODE-UTIL-TYPE           TO WS-UTL-TYP(WS-SUB).      
           MOVE 4F-RATE-PLAN-NO             TO WS-RATE-PLAN(WS-SUB).    
           MOVE 4D-EQUIP-TAG-NO             TO WS-TAG-NO(WS-SUB).       
           MOVE 4F-BILLING-FL               TO WS-BILLING-FL(WS-SUB).   
                                                                        
           IF FIRST-CALL                                                
              IF 4F-BILLING-FL = 'Z' AND (4F-RATE-PLAN-NO NOT = '064')  
                 MOVE 4F-RATE-PLAN-NO       TO Q8-RATE-PLAN-NO          
                 PERFORM 2300-GET-REVENUE-CLASS   THRU 2300-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7020-FETCH-POLE-CSR         THRU 7020-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET THE REVENUE CLASS FROM CSS_REV_CLS_RATE USING PARM RATE.   *        
      ******************************************************************        
       2300-GET-REVENUE-CLASS.                                          
                                                                        
           MOVE SPACES                      TO Q8-CODE-REVENUE-CLASS.   
           PERFORM 7040-GET-REVENUE-CLS        THRU 7040-EXIT.          
           MOVE Q8-CODE-REVENUE-CLASS       TO WS-REV-CLS(WS-SUB).      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              SET REV-CLASS-NOT-FOUND TO TRUE                           
              MOVE 'LMS0000042'             TO S-BUS-RULE-ID            
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DURING THE SECOND CALL, REVENUE CLASS WILL BE FROM PARMS, SO   *        
      * MAP THE REVENUE CLASS TO THE CORRESPONDING FIXTURE AND POLES.  *        
      ******************************************************************        
       2400-LOAD-PARM-REV-CLS.                                          
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
             UNTIL WS-SUB > WS-EQUIP-COUNT                              
                OR WS-SUB > 6                                           
             IF WS-INST-LOC-NO(WS-SUB) = PARM-FXTR-INST-LOC-NO          
                EVALUATE WS-INST-PT-NO(WS-SUB)                          
                   WHEN PARM-FXTR-INST-POINT-NO                         
                     MOVE PARM-FXTR-REV-CLS TO WS-REV-CLS(WS-SUB)       
                   WHEN PARM-POL1-INST-POINT-NO                         
                     MOVE PARM-POL1-REV-CLS TO WS-REV-CLS(WS-SUB)       
                   WHEN PARM-POL2-INST-POINT-NO                         
                     MOVE PARM-POL2-REV-CLS TO WS-REV-CLS(WS-SUB)       
                   WHEN PARM-POL3-INST-POINT-NO                         
                     MOVE PARM-POL3-REV-CLS TO WS-REV-CLS(WS-SUB)       
                   WHEN PARM-POL4-INST-POINT-NO                         
                     MOVE PARM-POL4-REV-CLS TO WS-REV-CLS(WS-SUB)       
                   WHEN PARM-POL5-INST-POINT-NO                         
                     MOVE PARM-POL5-REV-CLS TO WS-REV-CLS(WS-SUB)       
                END-EVALUATE                                            
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * REVENUE CLASS IS AVAILABLE FOR FIXTURE AND BILLABLE POLES.SO   *        
      * START BILLING THEM USING THE CUST PLAN COPYBOOK. FOR NON       *        
      * BILLABLE POLES, BLANK OUT THE RATE AND RATE ITEM CODE.         *        
      ******************************************************************        
       2500-START-BILLING.                                              
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
             UNTIL WS-SUB > WS-EQUIP-COUNT                              
                OR WS-SUB > 6                                           
             EVALUATE TRUE                                              
                WHEN WS-BILLING-FL(WS-SUB) = 'N'                        
                   MOVE WS-INST-LOC-NO(WS-SUB)   TO WS-INSTALL-LOC-NO   
                   MOVE WS-INST-PT-NO(WS-SUB)    TO 4F-INSTALL-POINT-NO 
                   PERFORM 8200-UPDATE-EQUIP-ENV    THRU 8200-EXIT      
                WHEN (WS-BILLING-FL(WS-SUB) = 'Z'   AND                 
                      WS-RATE-PLAN(WS-SUB)  = '064' )                   
                   MOVE WS-INST-LOC-NO(WS-SUB)   TO WS-INSTALL-LOC-NO   
                   MOVE WS-INST-PT-NO(WS-SUB)    TO 4F-INSTALL-POINT-NO 
                   PERFORM 8225-UPDATE-EQUIP-ENV-OTHR  THRU  8225-EXIT  
                WHEN WS-BILLING-FL(WS-SUB) = 'Z'                        
                   PERFORM 5300-SYNC-LIGHTS-BILLING THRU 5300-EXIT      
                   PERFORM 5800-CREATE-TRNS-HIST    THRU 5800-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SET PENDING ACCOUNT TO ACTIVE                                  *        
      ******************************************************************        
       2600-SET-ACCT-STAT-TO-ACTIVE.                                    
                                                                        
           INITIALIZE LM04-INPUT.                                       
                                                                        
           MOVE PARM-ACCOUNT-NO             TO LM04-ACCOUNT-NO.         
           MOVE PARM-FXTR-INST-LOC-NUM      TO LM04-INSTALL-LOC-NO.     
           MOVE PARM-USER-ID                TO LM04-USER-ID.            
           MOVE PROGRAM-NAME                TO LM04-PROGRAM-NAME.       
           MOVE WS-ACTION-DATE              TO LM04-ACTION-DATE.        
                                                                        
           PERFORM 6000-LM04-SET-PEND-ACCOUNT  THRU 6000-LM04-EXIT.     
                                                                        
           IF LM04-ERROR                                                
              MOVE LM04-ERR-SQLCODE      TO WS-ACTIVE-RETURN-CODE       
              MOVE LM04-BUS-RULE-ID      TO S-BUS-RULE-ID               
              MOVE LM04-BUS-RULE-RESULT-CD TO S-BUS-RULE-RESULT-CD      
              MOVE 'CPDLM004'            TO ABEND-PROGRAM               
              MOVE LM04-ERR-PARAGRAPH-NO TO ACTIVE-PARAGRAPH            
              MOVE LM04-ERR-FUNCTION     TO ABEND-FUNCTION              
              MOVE LM04-ERR-TABLE1       TO TABLE-1                     
              MOVE LM04-ERR-TABLE2       TO TABLE-2                     
              MOVE LM04-ERR-COLUMN-1     TO TABLE-ELEMENT-1             
              MOVE LM04-ERR-COLUMN-2     TO TABLE-ELEMENT-2             
              MOVE LM04-ERR-COLUMN-3     TO TABLE-ELEMENT-3             
              MOVE LM04-ERR-COLUMN-4     TO TABLE-ELEMENT-4             
              MOVE LM04-ERR-HOSTVAR-1    TO HOSTVAR-ELEMENT-1           
              MOVE LM04-ERR-HOSTVAR-2    TO HOSTVAR-ELEMENT-2           
              MOVE LM04-ERR-HOSTVAR-3    TO HOSTVAR-ELEMENT-3           
              MOVE LM04-ERR-HOSTVAR-4    TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * START BILLING CALL TO COPYBOOK IS ADD NEW LIGHT SCENARIO       *        
      ******************************************************************        
       5300-SYNC-LIGHTS-BILLING.                                        
                                                                        
           INITIALIZE LM001-INPUT.                                      
                                                                        
           MOVE PARM-ACCOUNT-NO             TO LM001-ACCOUNT-NO.        
           MOVE WS-INST-LOC-NO(WS-SUB)      TO LM001-INSTALL-LOC-NO     
                                               4F-INSTALL-LOC-NO.       
           MOVE WS-INST-PT-NO(WS-SUB)       TO LM001-INSTALL-POINT-NO   
                                               4F-INSTALL-POINT-NO.     
           MOVE WS-UTL-TYP(WS-SUB)          TO LM001-NEW-RATE-UTIL-TYPE.
           MOVE WS-RATE-PLAN(WS-SUB)        TO LM001-NEW-RATE-PLAN-NO.  
           MOVE WS-REV-CLS(WS-SUB)          TO LM001-CODE-REVENUE-CLASS.
                                                                        
           MOVE PARM-USER-ID                TO LM001-USER-ID.           
           MOVE PROGRAM-NAME                TO LM001-PROGRAM-NAME.      
                                                                        
           PERFORM 7050-GET-EQUP-ENVRNMT-DTLS  THRU 7050-EXIT.          
                                                                        
ACT027     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT027        IF IND-INSTALL-DT = WS-YES-NULL                           
ACT027           MOVE SPACES                  TO 4F-EQUIP-INSTALL-DT    
ACT027        END-IF                                                    
ACT027     END-IF.                                                      
ACT027                                                                  
ACT027     IF 4F-EQUIP-INSTALL-DT > SPACES                              
ACT027        MOVE 4F-EQUIP-INSTALL-DT   TO LM001-ACTION-DATE           
ACT027     ELSE                                                         
ACT027        MOVE WS-ACTION-DATE        TO LM001-ACTION-DATE           
ACT027     END-IF.                                                      
                                                                        
           SET ADD-NEW-LIGHT TO TRUE.                                   
           MOVE WS-ACTION-CODE              TO LM001-ACTION-CODE.       
                                                                        
           PERFORM 6300-LM001-CUST-LIGHT-SYNC                           
              THRU 6300-LM001-EXIT.                                     
                                                                        
           IF LM001-ERROR                                               
              MOVE LM001-ERR-SQLCODE     TO WS-ACTIVE-RETURN-CODE       
      *       MOVE +100                  TO WS-ACTIVE-RETURN-CODE               
              MOVE LM001-BUS-RULE-ID     TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              MOVE 'CPDLM001'            TO ABEND-PROGRAM               
              MOVE LM001-ERR-PARAGRAPH-NO                               
                                         TO ACTIVE-PARAGRAPH            
              MOVE LM001-ERR-FUNCTION    TO ABEND-FUNCTION              
              MOVE LM001-ERR-TABLE1      TO TABLE-1                     
              MOVE LM001-ERR-TABLE2      TO TABLE-2                     
              MOVE LM001-ERR-COLUMN-1    TO TABLE-ELEMENT-1             
              MOVE LM001-ERR-COLUMN-2    TO TABLE-ELEMENT-2             
              MOVE LM001-ERR-COLUMN-3    TO TABLE-ELEMENT-3             
              MOVE LM001-ERR-COLUMN-4    TO TABLE-ELEMENT-4             
              MOVE LM001-ERR-HOSTVAR-1   TO HOSTVAR-ELEMENT-1           
              MOVE LM001-ERR-HOSTVAR-2   TO HOSTVAR-ELEMENT-2           
              MOVE LM001-ERR-HOSTVAR-3   TO HOSTVAR-ELEMENT-3           
              MOVE LM001-ERR-HOSTVAR-4   TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-CREATE-TRNS-HIST.                                           
                                                                        
           IF WS-SUB = 1                                                
              MOVE 0                     TO 4J-SOURCE-APPL-REQ-NO       
                                            4J-WMS-POINT-NO             
              MOVE SPACES                TO 4J-SOURCE-APPL-CD           
              MOVE PROGRAM-NAME          TO 4J-APPL-PROGRAM-ID          
              MOVE PARM-ACCOUNT-NO       TO 4J-ACCOUNT-NO               
              MOVE PARM-USER-ID          TO 4J-LAST-UPDATE-USERID       
                                            4S-LAST-UPDATE-USERID       
              MOVE PARM-FXTR-EQUIP-SEQ   TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
              MOVE WS-TRAN-COMNTS        TO 4J-TRANS-COMMENTS-TEXT      
              MOVE LENGTH OF WS-TRAN-COMNTS                             
                                         TO 4J-TRANS-COMMENTS-LEN       
           END-IF.                                                      
           MOVE WS-TAG-NO(WS-SUB)        TO 4J-EQUIP-TAG-NO.            
           MOVE WS-INST-LOC-NO(WS-SUB)   TO 4J-INSTALL-LOC-NO.          
           MOVE WS-INST-PT-NO(WS-SUB)    TO 4J-INSTALL-POINT-NO.        
           MOVE 1                        TO 4S-DETAIL-SEQ-NO.           
           MOVE SPACES                   TO 4J-TRANS-HIST-SEQ-NO.       
                                                                        
           IF WS-SUB = 1                                                
              MOVE 'FXTR_RATE_PLAN_NO'   TO 4S-COLUMN-DESC              
              MOVE 4F-RATE-PLAN-NO       TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF 4F-RATE-PLAN-NO                            
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-RATE-PLAN-NO     TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF LM4F-RATE-PLAN-NO                          
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'FXTR_RATE_ITEM_CD'   TO 4S-COLUMN-DESC              
              MOVE 4F-RATE-ITEM-CODE     TO WS-RATE-ITEM-CD             
              MOVE WS-RATE-ITEM-CD       TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-RATE-ITEM-CD                            
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-RATE-ITEM-CODE   TO WS-RATE-ITEM-CD             
              MOVE WS-RATE-ITEM-CD       TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-RATE-ITEM-CD                            
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
      *       MOVE 'FXTR_CD_UTIL_TYPE'   TO 4S-COLUMN-DESC                      
      *       MOVE 4F-CODE-UTIL-TYPE     TO 4S-PRV-COLUMN-VALUE-TEXT            
      *       MOVE LENGTH OF 4F-CODE-UTIL-TYPE                                  
      *                                  TO 4S-PRV-COLUMN-VALUE-LEN             
      *       MOVE LM4F-CODE-UTIL-TYPE   TO 4S-CHG-COLUMN-VALUE-TEXT            
      *       MOVE LENGTH OF LM4F-CODE-UTIL-TYPE                                
      *                                  TO 4S-CHG-COLUMN-VALUE-LEN             
      *       PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                              
      *          THRU 6000-CPDLM2-EXIT                                          
                                                                        
              MOVE 'FXTR_IC_NO'          TO 4S-COLUMN-DESC              
              MOVE 4F-IC-NO              TO WS-IC-NO                    
              MOVE WS-IC-NO              TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-IC-NO    TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-IC-NO            TO WS-IC-NO                    
              MOVE WS-IC-NO              TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-IC-NO    TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'FXTR_REVENUE_CLASS'  TO 4S-COLUMN-DESC              
              MOVE WS-REV-CLS(WS-SUB)    TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-REV-CLS(WS-SUB)                         
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM001-CODE-REVENUE-CLASS                             
                                         TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF LM001-CODE-REVENUE-CLASS                   
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'FXTR_BILLING_FL'     TO 4S-COLUMN-DESC              
              MOVE 4F-BILLING-FL         TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF 4F-BILLING-FL                              
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-BILLING-FL       TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF LM4F-BILLING-FL                            
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           ELSE                                                         
              MOVE 'POLE_NUMBER'         TO 4S-COLUMN-DESC              
              MOVE WS-TAG-NO(WS-SUB)     TO 4S-PRV-COLUMN-VALUE-TEXT    
                                            4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-TAG-NO(WS-SUB)                          
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
                                            4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'POLE_RATE_PLAN_NO'   TO 4S-COLUMN-DESC              
              MOVE 4F-RATE-PLAN-NO       TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF 4F-RATE-PLAN-NO                            
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-RATE-PLAN-NO     TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF LM4F-RATE-PLAN-NO                          
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'POLE_RATE_ITEM_CD'   TO 4S-COLUMN-DESC              
              MOVE 4F-RATE-ITEM-CODE     TO WS-RATE-ITEM-CD             
              MOVE WS-RATE-ITEM-CD       TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-RATE-ITEM-CD                            
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-RATE-ITEM-CODE                                  
                                         TO WS-RATE-ITEM-CD             
              MOVE WS-RATE-ITEM-CD       TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-RATE-ITEM-CD                            
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
      *       MOVE 'POLE_CD_UTIL_TYPE'   TO 4S-COLUMN-DESC                      
      *       MOVE 4F-CODE-UTIL-TYPE     TO 4S-PRV-COLUMN-VALUE-TEXT            
      *       MOVE LENGTH OF 4F-CODE-UTIL-TYPE                                  
      *                                  TO 4S-PRV-COLUMN-VALUE-LEN             
      *       MOVE LM4F-CODE-UTIL-TYPE   TO 4S-CHG-COLUMN-VALUE-TEXT            
      *       MOVE LENGTH OF LM4F-CODE-UTIL-TYPE                                
      *                                  TO 4S-CHG-COLUMN-VALUE-LEN             
      *       PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                              
      *          THRU 6000-CPDLM2-EXIT                                          
                                                                        
              MOVE 'POLE_IC_NO'          TO 4S-COLUMN-DESC              
              MOVE 4F-IC-NO              TO WS-IC-NO                    
              MOVE WS-IC-NO              TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-IC-NO    TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-IC-NO            TO WS-IC-NO                    
              MOVE WS-IC-NO              TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-IC-NO    TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'POLE_REVENUE_CLASS'  TO 4S-COLUMN-DESC              
              MOVE WS-REV-CLS(WS-SUB)    TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-REV-CLS(WS-SUB)                         
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM001-CODE-REVENUE-CLASS                             
                                         TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF LM001-CODE-REVENUE-CLASS                   
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'POLE_BILLING_FL'     TO 4S-COLUMN-DESC              
              MOVE 4F-BILLING-FL         TO 4S-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF 4F-BILLING-FL                              
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
              MOVE LM4F-BILLING-FL       TO 4S-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF LM4F-BILLING-FL                            
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *6000-LOAD-LMS-TRN-HST-CPDLM2                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM002                                                  
           END-EXEC.                                                            
                                                                        
      *6000-LM04-SET-PEND-ACCOUNT                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM004                                                  
           END-EXEC.                                                            
                                                                        
      *6000-GET-ACCT-TYPE-CODE-CPD118                                           
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00118                                                 
           END-EXEC.                                                            
                                                                        
      *                                                                         
                                                                        
      *6300-LM001-CUST-LITE-SYNC                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM001                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
                                                                        
       7000-GET-ACTION-DATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-ACTION-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-ACTION-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACTION-DATE'            TO TABLE-ELEMENT-1          
              MOVE WS-ACTION-DATE           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-POLE-CSR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN EQUIP_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-FETCH-POLE-CSR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH EQUIP_CSR                                          
                INTO :4H-ATTACH-EQUIP-SEQ                               
                    ,:4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-POINT-NO                               
                    ,:4F-BILLING-FL                                     
                    ,:4F-CODE-UTIL-TYPE                                 
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4D-EQUIP-TAG-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-POLE-CSR.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE EQUIP_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-GET-REVENUE-CLS.                                            
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) Q8.CODE_REVENUE_CLASS                           
                  INTO :Q8-CODE-REVENUE-CLASS                           
                  FROM CSS_REV_CLS_RATE Q8 WITH(READUNCOMMITTED)                
                 WHERE Q8.RATE_PLAN_NO = :Q8-RATE-PLAN-NO               
                   AND Q8.STATUS_CD <> 'I'                              
                   AND EXISTS                                           
                  (SELECT 1                                             
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                    WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                
                      AND UT.PREMISE_NO = :UT-PREMISE-NO                
                      AND UT.CODE_REVENUE_CLASS = Q8.CODE_REVENUE_CLASS)
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  Q8.CODE_REVENUE_CLASS                                   
MFA-TR*           INTO :Q8-CODE-REVENUE-CLASS                                   
MFA-TR*           FROM CSS_REV_CLS_RATE Q8                                      
MFA-TR*          WHERE Q8.RATE_PLAN_NO = :Q8-RATE-PLAN-NO                       
MFA-TR*            AND Q8.STATUS_CD <> 'I'                                      
MFA-TR*            AND EXISTS                                                   
MFA-TR*           (SELECT 1                                                     
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*             WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                        
MFA-TR*               AND UT.PREMISE_NO = :UT-PREMISE-NO                        
MFA-TR*               AND UT.CODE_REVENUE_CLASS = Q8.CODE_REVENUE_CLASS)        
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-PREMISE-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-3          
              MOVE Q8-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-GET-EQUP-ENVRNMT-DTLS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT INSTALL_LOC_CD                                     
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,RATE_PLAN_NO                                       
                    ,RATE_ITEM_CODE                                     
                    ,ITEM_SEQ_NO                                        
                    ,BILLING_FL                                         
ACT027              ,EQUIP_INSTALL_DT                                   
                INTO :4F-INSTALL-LOC-CD                                 
                    ,:4F-CODE-UTIL-TYPE                                 
                    ,:4F-IC-NO                                          
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4F-RATE-ITEM-CODE                                 
                    ,:4F-ITEM-SEQ-NO                                    
                    ,:4F-BILLING-FL                                     
ACT027              ,:4F-EQUIP-INSTALL-DT :IND-INSTALL-DT                
              FROM LMS_EQUIP_ENVRNMT [4F]                                 
              WHERE INSTALL_LOC_NO =   :4F-INSTALL-LOC-NO               
                AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT INSTALL_LOC_CD                                             
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,BILLING_FL                                                 
MFA-TR*             ,EQUIP_INSTALL_DT                                           
MFA-TR*         INTO :4F-INSTALL-LOC-CD                                         
MFA-TR*             ,:4F-CODE-UTIL-TYPE                                         
MFA-TR*             ,:4F-IC-NO                                                  
MFA-TR*             ,:4F-RATE-PLAN-NO                                           
MFA-TR*             ,:4F-RATE-ITEM-CODE                                         
MFA-TR*             ,:4F-ITEM-SEQ-NO                                            
MFA-TR*             ,:4F-BILLING-FL                                             
MFA-TR*             ,:4F-EQUIP-INSTALL-DT:IND-INSTALL-DT                        
MFA-TR*       FROM LMS_EQUIP_ENVRNMT 4F                                         
MFA-TR*       WHERE INSTALL_LOC_NO =   :4F-INSTALL-LOC-NO                       
MFA-TR*         AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)               
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE      1R                                       
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BUS_RULE'           TO TABLE-1                  
              MOVE 'BUS_RULE_ID'            TO TABLE-ELEMENT-1          
              MOVE S-BUS-RULE-ID            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04777_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04777_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE GTT-NAME-R1              TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04777_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-BUS-RULE-ID                                       
                  ,:S-BUS-RULE-RESULT-CD                                
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04777_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-BUS-RULE-RESULT-CD                                        
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS-1                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04777_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
       8200-UPDATE-EQUIP-ENV.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                 SET RATE_PLAN_NO       = '   '                         
                    ,RATE_ITEM_CODE     = 0                             
                    ,LAST_UPDATE_USERID = :PARM-USER-ID                 
               WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO            
                 AND INSTALL_POINT_NO   = :4F-INSTALL-POINT-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8225-UPDATE-EQUIP-ENV-OTHR.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                 SET BILLING_FL         = 'Y'                           
                    ,LAST_UPDATE_USERID = :PARM-USER-ID                 
               WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO            
                 AND INSTALL_POINT_NO   = :4F-INSTALL-POINT-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8225'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8225-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-1 <= 0                                           
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                   TO S-APPL-RETURN-CODE          
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                 
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
      * COMMENTED TO FIX START BILLING ERROR                                    
      *    INITIALIZE GTT-RETURN-FIELDS.                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE               
                                            ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE            THRU 8900-EXIT.            
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS        THRU 8800-EXIT.            
           PERFORM 8900-SEND-DONE            THRU 8900-EXIT.            
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                       END OF PROGRAM                           *        
      ******************************************************************        
