       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04776.                                          
       AUTHOR.       SIVARAJAN.                                         
COB303 DATE-WRITTEN. OCT 10,2014.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04776              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--  CSR04776 :                                                --         
      *--  #  UPDATE ROUTINE FOR LMS TRANSFER FIXTURE WIZARD.        --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            I_REQUEST_NO            DECIMAL(13,0)           --         
      *--            I_ACCOUNT_NO            DECIMAL(13,0)           --         
      *--            I_TRAN_TO_ACCT_NO       DECIMAL(13,0)           --         
      *--            I_TRAN_TO_ACCT_ST       CHAR(01)                --         
      *--            I_FXTR_RATE             CHAR(03)                --         
      *--            I_FXTR_RATE_ITEM_CD     SMALLINT                --         
      *--            I_FXTR_REV_CLASS        CHAR(03)                --         
      *--            I_FXTR_SEQ              DECIMAL(10,0)           --         
      *--            I_FIXTURE_STOCK_CODE    CHAR(15)                --         
      *--            I_FXTR_EQ_TAG_NO        CHAR(12)                --         
      *--            I_OLD_FX_INST_LOC_NO    CHAR(10)                --         
      *--            I_OLD_FX_INST_PNT_NO    DECIMAL(5,0)            --         
      *--            I_NEW_FX_INST_LOC_NO    CHAR(10)                --         
      *--            I_OLD_CNT_CD            CHAR(01)                --         
      *--            I_OLD_CNT_ST_DATE       CHAR(10)                --         
      *--            I_ORIG_CNT_TERM_CHG     CHAR(08)                --         
      *--            I_OLD_CNT_TERM_CHG      CHAR(08)                --         
      *--            I_NEW_CNT_CD            CHAR(01)                --         
      *--            I_NEW_CNT_CLP_NO        CHAR(50)                --         
      *--            I_NEW_CNT_DUR_CD        CHAR(02)                --         
      *--            I_NEW_CNT_STR_DT        CHAR(10)                --         
      *--            I_NEW_CNT_END_DT        CHAR(10)                --         
      *--            I_NEW_CNT_NO_CN_RSN_CD  CHAR(02)                --         
      *--            I_USER_ID               CHAR(07)                --         
      *--            I_POLE_ACTION_CD        CHAR(01)                --         
      *--            I_NEW_POLE_TAG_NO       CHAR(12)                --         
      *--            I_NEW_POLE_STK_CD       CHAR(15)                --         
      *--            I_NEW_POLE_RATE         CHAR(03)                --         
      *--            I_NEW_POLE_RATE_ITEM_CD SMALLINT                --         
      *--            I_NEW_POLE_REV_CLASS    CHAR(03)                --         
      *--            I_OLD_CNT_TRFEE_OVR_CMT VARCHAR(250)            --         
      *--            I_WMS_SO_NO_CMT         VARCHAR(250)            --         
      *--            I_OLD_CNT_CLP_NO        CHAR(50)                --         
ACT069*--            I_EFFECTIVE_DT          CHAR(10)                --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  CSR04776_R1 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--            RETURN_CODE          INTEGER                    --         
      *--            APPL_RETURN_CODE     INTEGER                    --         
      *--            BUS_RULE_ID          CHAR(10)                   --         
      *--            BUS_RULE_RESULT_CD   CHAR(10)                   --         
      *--            BUS_RULE_XREF_ID     CHAR(26)                   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  10/08/2014    SV95326     INITIAL VERSION.                --         
      *--  04/20/2015    HA7A338     CALL CPDLM001 FOR INACTIVE      --         
      *--                            SCENARIOS WHEN RATE/RATE ITEM   --         
      *--                            CODE EXISTS FOR OLD FXTR/PLE.   --         
      *--  05/05/2015    HA7A338     SET BILLING FLAG AS Z FOR EQUIP --         
      *--                A05084      HAVING RATE PLAN WITH BILLING   --         
      *--                            FLAG 'N'                        --         
A#5084*--  06/19/15      SS95855     ACT040 CLP# CHANGED TO CHAR(50) --         
A#5084*--  12/07/15      SV95326     ACT069 ADD EFFECTIVE DATE IN    --         
      *--                            RRT SCREEN AS A NEW INPUT.      --         
A#5084*--  02/29/16      DB41297     DELETE ATTACHMENT BEFORE POLE   --         
ACT073*--                                                            --         
A#5470*--  05/03/16      GD43988     POPULATE CODE_UTIL_TYPE BASED   --         
ACT026*--                            ON RATE PLAN                    --         
A05470*--  05/23/16      VK7L032     WQ LOGIC  INCLUDED WHEN TRANFER --         
ACT028*--                            THE FIXTURE FROM ONE ACCOUNT TO --         
ACT028*--                            ANOTHER                         --         
A*5501*--  09/09/16      AK7T405     ACT#17062 - Defect#12062 -      --         
      *--                            Relpacing LMS_CODE_VALUE with   --         
      *--                            CSS_RATE_PLAN_DESC Table        --         
      *----------------------------------------------------------------         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-ALL-FXTR-ATMS  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-ALL-EQU-ENVMT  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04776'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE SQLCA                                                  
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_FXTR_ATTACHMTS, 4H                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXTATC                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_EQUIP_INVENTRY, 4D                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBEQPINV                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_EQUIP_ENVRNMT, 4F                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBEQPIVT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_EQUIP_CONTRACT, 4L                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBEQPCNT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_MSTR_STCK_INFO  4A                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMSTINF                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY     C8                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM        G6                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBJBPARM                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_TRANS_HIST,     4J                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLGTHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_TRANS_HIST_DET, 4S                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLMSHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_UTIL_ENVRNMT  , UT                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBUTLENV                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BUS_RULE , 1R                                             *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBBUSRUL                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_BUS_RULE_XREF , 1T                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRULXRF                                               
            END-EXEC.                                                           
                                                                        
      ***************************************************************** 00730000
      *** CSS_MNT_TRANS_HIST, MH                                                
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_MT_TRN_HST_DET, MI                                                
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_MTRD_ENVRNMT, MN                                                  
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_PREMISE, PR                                                       
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_CUSTOMER, CU                                                      
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_RESP_AREA, C1                                                     
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_CUST_PREM_HIST, CH                                                
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_ACCOUNT, AT                                                       
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
ACT026*** CSS_CSS_RATE_PLAN_DESC, RD                                            
ACT026     EXEC SQL                                                             
ACT026        INCLUDE TBRTDESC                                                  
ACT026     END-EXEC.                                                            
ACT026*                                                                         
      *--------< TO BREAK UP CODES_DATA_PRESENT         >                       
           COPY CWS00056.                                                       
      *                                                                         
      *--------< WORKING STORAGE COPYBOOK FOR CPD00118  >                       
           EXEC SQL                                                             
              INCLUDE CWS00118                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------< WORKING STORAGE COPYBOOK FOR CPDLM004  >                       
           EXEC SQL                                                             
              INCLUDE CWSLM004                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS FOR LMS CONTRACT ROUTINE MCSCB822                *        
      ******************************************************************        
           COPY CWS04822.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS FOR LMS TO BILLING SYNC COPYBOOK CPDLM001        *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSLM001                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
ACT028******************************************************************        
ACT028*    WORK AREAS FOR WQ ROUTINE MCSCB077                          *        
ACT028******************************************************************        
ACT028     EXEC SQL                                                             
ACT028        INCLUDE CWS00077                                                  
ACT028     END-EXEC.                                                            
ACT028                                                                  
                                                                        
       01 WS-WORKING-STORAGE.                                           
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-GTT-NAME             PIC X(30) VALUE SPACES.            
                                                                        
       01 WS-LITERALS.                                                  
ACT028     05  MCSCB077                     PIC X(08) VALUE 'MCSCB077'. 
ACT028     05  WS-WQ-COMMENTS               PIC X(56) VALUE             
ACT028      'All Lights have been removed. Need to final bill account'. 
          05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04776'.        
          05 MCSCB822                PIC X(08) VALUE 'MCSCB822'.        
          05 WS-POLE                 PIC X(01) VALUE 'P'.               
          05 WS-NODE                 PIC X(01) VALUE 'N'.               
          05 WS-N                    PIC X(01) VALUE 'N'.               
          05 WS-Y                    PIC X(01) VALUE 'Y'.               
          05 USE-EXISTING            PIC X(01) VALUE 'U'.               
          05 WS-Y                    PIC X(01) VALUE 'Y'.               
          05 GTT-NAME                PIC X(26)                          
                                            VALUE 'SESSION.CSR04776_R1'.
      *                                                                         
       01 NULL-INDICATORS.                                              
          05  WS-NULL-MAX-INS-POINT  PIC S9(4) COMP VALUE 0.            
          05  WS-NULL-EQU-INST-DT    PIC S9(4) COMP VALUE 0.            
          05  WS-NULL-APPROVED-TS    PIC S9(4) COMP VALUE 0.            
          05  WS-NULL-EQUIP-MFR-DT   PIC S9(4) COMP VALUE -1.           
          05  WS-NULL-WARR-EXP-DT    PIC S9(4) COMP VALUE -1.           
          05  WS-NULL-EQUIP-DISP-DT  PIC S9(4) COMP VALUE -1.           
          05  WS-NULL-ACTL-CHRG-DT   PIC S9(4) COMP VALUE -1.           
      *                                                                         
       01 COUNTER-FIELDS.                                               
          05  CTR-ROWS-RS1           PIC S9(4) COMP VALUE 0.            
          05  WS-MAX-ENTRY-COUNT     PIC S9(4) COMP VALUE 10.           
          05  WS-ENVRNMT-COUNT       PIC 9(05) VALUE 0.                 
          05  WS-ATCHMNT-COUNT       PIC 9(05) VALUE 0.                 
ACT028    05  WS-ACT-CUST-PLAN-CNT   PIC S9(4) COMP VALUE 0.            
ACT028    05  WS-ACT-METER-ENV-CNT   PIC S9(4) COMP VALUE 0.            
      *                                                                         
       01 WS-TERM-CHG.                                                  
          05  WS-TERM-CHRG-AMT-TXT.                                     
              10  WS-TERM-CHRG-AMT-SI                                   
                                     PIC X(01) VALUE SPACES.            
              10  WS-TERM-CHRG-AMT-AM                                   
                                     PIC X(07) VALUE SPACES.            
          05  WS-TERM-CHRG-AMT-TEXT  PIC X(07) VALUE SPACES.            
          05  WS-TERM-CHRG-AMT-NUM REDEFINES WS-TERM-CHRG-AMT-TEXT      
                                     PIC 9(5)V9(2).                     
          05  WS-TERM-CHRG-AMT-COMP  PIC S9(5)V9(2).                    
          05  WS-TERM-CHRG-AMT-HST   PIC -----9(01).9(02).              
      *                                                                         
       01 WS-ORIG-TERM-CHRG.                                            
          05  WS-ORIG-TERM-CHRG-TXT.                                    
              10  WS-ORIG-TERM-CHRG-SI                                  
                                     PIC X(01) VALUE SPACES.            
              10  WS-ORIG-TERM-CHRG-AM                                  
                                     PIC X(07) VALUE SPACES.            
          05  WS-ORIG-TERM-CHRG-TEXT PIC X(07) VALUE SPACES.            
          05  WS-ORIG-TERM-CHRG-NUM REDEFINES WS-ORIG-TERM-CHRG-TEXT    
                                     PIC 9(5)V9(2).                     
          05  WS-ORIG-TERM-CHRG-COMP PIC S9(5)V9(2).                    
          05  WS-ORIG-TERM-CHRG-HST  PIC -----9(01).9(02).              
      *                                                                         
       01 WS-INDEX-VARS.                                                
          05  WS-TAB-INDX            PIC S9(4) COMP VALUE 0.            
      *                                                                         
       01 WS-ALL-EQU-ENVRNMT.                                           
          05 TAB-INSTALL-POINT-NO    PIC S9(05)V  USAGE COMP-3          
                                     OCCURS 10 TIMES VALUE 0.           
          05 TAB-EQUIP-SEQ           PIC S9(10)V  USAGE COMP-3          
                                     OCCURS 10 TIMES VALUE 0.           
          05 TAB-INSTALL-LOC-CD      PIC X(01) OCCURS 10 TIMES          
                                                     VALUE SPACES.      
          05 TAB-CODE-UTIL-TYPE      PIC X(01) OCCURS 10 TIMES          
                                                     VALUE SPACES.      
          05 TAB-IC-NO               PIC S9(04)   USAGE COMP            
                                     OCCURS 10 TIMES VALUE 0.           
          05 TAB-RATE-PLAN-NO        PIC X(03) OCCURS 10 TIMES          
                                                     VALUE SPACES.      
          05 TAB-RATE-ITEM-CODE      PIC S9(4)    USAGE COMP            
                                     OCCURS 10 TIMES VALUE 0.           
          05 TAB-ITEM-SEQ-NO         PIC S9(4)    USAGE COMP            
                                     OCCURS 10 TIMES VALUE 0.           
          05 TAB-BILLING-FL          PIC X(01) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-NO-BILL-REASON-CD   PIC X(02) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-EQUIP-CONTRACT-FL   PIC X(01) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-NO-CONTRACT-RSN-CD  PIC X(02) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-EQUIP-OWNER-CD      PIC X(01) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-EQUIP-DRAWING-ID    PIC X(10) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-EQUIP-GIS-GKEY      PIC S9(09)   USAGE COMP            
                                     OCCURS 10 TIMES  VALUE 0.          
          05 TAB-SOURCE-APPL-CD      PIC X(3)  OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-SOURCE-APPL-REQ-NO  PIC S9(13)V  USAGE COMP-3          
                                     OCCURS 10 TIMES  VALUE 0.          
          05 TAB-WMS-POINT-NO        PIC S9(3)V9(2) USAGE COMP-3        
                                     OCCURS 10 TIMES  VALUE 0.          
          05 TAB-EQUIP-INSTALL-DT    PIC X(10) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-INSTALL-USERID      PIC X(07) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-APPROVED-TS         PIC X(26) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-NULL-APPROVED-TS    PIC S9(4)    COMP                  
                                     OCCURS 10 TIMES  VALUE 0.          
          05 TAB-APPROVER-USERID     PIC X(07) OCCURS 10 TIMES          
                                                      VALUE SPACES.     
          05 TAB-SPCL-AGR-COMMENTS   PIC X(250) OCCURS 10 TIMES         
                                                      VALUE SPACES.     
          05 TAB-EQUIP-COMMENTS      PIC X(250) OCCURS 10 TIMES         
                                                      VALUE SPACES.     
      *                                                                         
       01 WS-MISC-FIELDS.                                               
ACT028    05 WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.            
          05 WS-REQUEST-NO           PIC S9(13)V USAGE COMP-3 VALUE 0.  
          05 WS-ACCOUNT-NO           PIC S9(13)V USAGE COMP-3 VALUE 0.  
          05 WS-TRAN-TO-ACCT-NO      PIC S9(13)V USAGE COMP-3 VALUE 0.  
          05 WS-TRAN-TO-ACCT-ST      PIC X(01)   VALUE SPACES.          
          05 WS-FXTR-RATE            PIC X(03)   VALUE SPACES.          
          05 WS-FXTR-RATE-ITEM-CD    PIC S9(4)   USAGE COMP VALUE 0.    
          05 WS-FXTR-REV-CLASS       PIC X(03)   VALUE SPACES.          
          05 WS-FIXTURE-STOCK-CD     PIC X(15)   VALUE SPACES.          
          05 WS-FXTR-SEQ             PIC S9(10)V USAGE COMP-3 VALUE 0.  
          05 WS-FXTR-EQ-TAG-NO       PIC X(12)   VALUE SPACES.          
          05 WS-OLD-FX-INST-LOC-NO   PIC X(10)   VALUE SPACES.          
          05 WS-OLD-FX-INST-PNT-NO   PIC S9(05)V USAGE COMP-3 VALUE 0.  
          05 WS-NEW-FX-INST-LOC-NO   PIC X(10)   VALUE SPACES.          
          05 WS-OLD-CNT-CD           PIC X(01)   VALUE SPACES.          
          05 WS-OLD-CNT-ST-DATE      PIC X(10)   VALUE SPACES.          
          05 WS-OLD-CNT-TERM-CHG     PIC X(08)   VALUE SPACES.          
          05 WS-NEW-CNT-CD           PIC X(01)   VALUE SPACES.          
ACT040    05 WS-NEW-CNT-CLP-NO       PIC X(50)   VALUE SPACES.          
ACT040    05 WS-OLD-CNT-CLP-NO       PIC X(50)   VALUE SPACES.          
          05 WS-NEW-CNT-DUR-CD       PIC X(02)   VALUE SPACES.          
          05 WS-NEW-CNT-STR-DT       PIC X(10)   VALUE SPACES.          
          05 WS-NEW-CNT-END-DT       PIC X(10)   VALUE SPACES.          
          05 WS-NEW-CNT-NO-CN-RSN-CD PIC X(02)   VALUE SPACES.          
          05 WS-USER-ID              PIC X(07)   VALUE SPACES.          
ACT028    05  WS-MCSCB077-RET-CODE   PIC S9(09) COMP VALUE 0.           
          05 WS-OLD-CNT-TRFEE-OVR-CMT.                                  
             10 WS-OLD-CN-TRFEE-OVR-CMT-LN                              
                                     PIC S9(04)  COMP VALUE 0.          
             10 WS-OLD-CN-TRFEE-OVR-CMT-TX                              
                                     PIC X(248)  VALUE SPACES.          
          05 WS-WMS-SO-NO-CMT.                                          
             10 WS-WMS-SO-NO-CMT-LN  PIC S9(04)  COMP VALUE 0.          
             10 WS-WMS-SO-NO-CMT-TX  PIC X(248)  VALUE SPACES.          
          05 WS-POLE-ACTION-CD       PIC X(01)   VALUE SPACES.          
          05 WS-NEW-POLE-TAG-NO      PIC X(12)   VALUE SPACES.          
          05 WS-NEW-POLE-STK-CD      PIC X(15)   VALUE SPACES.          
          05 WS-NEW-EQUIP-SEQ        PIC S9(10)V USAGE COMP-3 VALUE 0.  
          05 WS-LMS-CNTR-ITEM-ID     PIC X(09)   VALUE SPACES.          
          05 WS-EQUIP-COST-AMOUNT    PIC -----9(01).9(02).              
                                                                        
       01 WS-MISC-GENERAL.                                              
          05 WS-TAB-CODE-UTIL-TYPE   PIC X(01)   VALUE SPACES.          
          05 WS-TAB-IC-NO            PIC S9(04)  COMP VALUE 0.          
          05 WS-TAB-RATE-PLAN-NO     PIC X(03)   VALUE SPACES.          
          05 WS-TAB-RATE-ITEM-CD     PIC S9(04)  COMP VALUE 0.          
          05 WS-CODE-REV-CLASS       PIC X(03)   VALUE SPACES.          
          05 WS-OLD-CNT-TERM-DT      PIC X(10)   VALUE SPACES.          
          05 WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.          
          05 WS-CURRENT-TS           PIC X(26)   VALUE SPACES.          
          05 WS-4F-INST-LOC-NO       PIC X(10)   VALUE SPACES.          
          05 WS-MAX-4F-INS-POINT-NO  PIC S9(05)V USAGE COMP-3 VALUE 0.  
                                                                        
      *01  SWITCHES.                                                            
      *    05  WS-RATE-MATCHING      PIC X(01)   VALUE 'N'.                     
      *        88 RATE-DIFFERS                   VALUE 'Y'.                     
                                                                        
       01 WS-ALL-FXTR-ATTACHMENTS.                                      
           05  TAB-ATTACH-EQUIP-SEQ-ATT     OCCURS 10 TIMES             
                                            PIC S9(10)V USAGE COMP-3    
                                                      VALUE 0.          
           05  TAB-EQUIP-TYPE-CD-ATT        OCCURS 10 TIMES PIC X(01)   
                                                      VALUE SPACES.     
           05  TAB-EQUIP-TAG-NO-ATT         OCCURS 10 TIMES PIC X(12)   
                                                      VALUE SPACES.     
           05  TAB-RATE-PLAN-NO-ATT         OCCURS 10 TIMES PIC X(03)   
                                                      VALUE SPACES.     
           05  TAB-RATE-ITEM-CODE-ATT       OCCURS 10 TIMES PIC S9(4)   
                                                  USAGE COMP VALUE 0.   
           05  TAB-BILLING-FL-ATT           OCCURS 10 TIMES PIC X(01)   
                                                      VALUE SPACES.     
           05  TAB-NO-BILL-REASON-CD-ATT    OCCURS 10 TIMES PIC X(02)   
                                                      VALUE SPACES.     
           05  TAB-INSTALL-POINT-NO-ATT     OCCURS 10 TIMES             
                                            PIC S9(05)V USAGE COMP-3    
                                                      VALUE 0.          
           05  TAB-ATTACH-EQUIP-DATE-ATT    OCCURS 10 TIMES PIC X(10)   
                                                      VALUE SPACES.     
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05  S-RETURN-CODE                PIC S9(04) COMP VALUE 0.     
          05  S-APPL-RETURN-CODE           PIC S9(04) COMP VALUE 0.     
          05  WS-APPL-RETURN-CODE          PIC S9(04) COMP VALUE 0.     
      *                                                                         
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE AND IC NO            *                  
      *********************************************************                 
          05  GTT-RETURN-FIELDS-1.                                      
              10  S-RETURN-CODE-1          PIC S9(04) COMP VALUE 0.     
              10  S-APPL-RETURN-CODE-1     PIC S9(04) COMP VALUE 0.     
              10  S-RS1-BUS-RULE-ID        PIC X(10)  VALUE SPACES.     
              10  S-RS1-BUS-RULE-RESULT-CD PIC X(10)  VALUE SPACES.     
              10  S-RS1-BUS-RULE-XREF-ID   PIC X(26)  VALUE SPACES.     
      *                                                                         
      ****************************************************************          
      *    ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
      *                                                                         
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE ALL_EQU_ENVMT CURSOR WITH ROWSET POSITIONING FOR  
               SELECT  INSTALL_POINT_NO                                 
                     , EQUIP_SEQ                                        
                     , INSTALL_LOC_CD                                   
                     , CODE_UTIL_TYPE                                   
                     , IC_NO                                            
                     , RATE_PLAN_NO                                     
                     , RATE_ITEM_CODE                                   
                     , ITEM_SEQ_NO                                      
                     , BILLING_FL                                       
                     , NO_BILL_REASON_CD                                
                     , EQUIP_CONTRACT_FL                                
                     , NO_CONTRACT_RSN_CD                               
                     , EQUIP_OWNER_CD                                   
                     , EQUIP_DRAWING_ID                                 
                     , EQUIP_GIS_GKEY                                   
                     , SOURCE_APPL_CD                                   
                     , SOURCE_APPL_REQ_NO                               
                     , WMS_POINT_NO                                     
                     , COALESCE(EQUIP_INSTALL_DT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))            
                     , INSTALL_USERID                                   
                     , REPLACE(REPLACE(CONVERT(CHAR(26), APPROVED_TS
           , 121), ' ', '-'), ':', '.') APPROVED_TS                            
                     , APPROVER_USERID                                  
                     , SPCL_AGR_COMMENTS                                
                     , EQUIP_COMMENTS                                   
                 FROM  LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)            
                WHERE  [4F].INSTALL_LOC_NO   = :WS-OLD-FX-INST-LOC-NO     
                  AND  [4F].INSTALL_POINT_NO = :WS-OLD-FX-INST-PNT-NO     
                                                                        
               UNION ALL                                                
                                                                        
               SELECT  INSTALL_POINT_NO                                 
                     , EQUIP_SEQ                                        
                     , INSTALL_LOC_CD                                   
                     , CODE_UTIL_TYPE                                   
                     , IC_NO                                            
                     , RATE_PLAN_NO                                     
                     , RATE_ITEM_CODE                                   
                     , ITEM_SEQ_NO                                      
                     , BILLING_FL                                       
                     , NO_BILL_REASON_CD                                
                     , EQUIP_CONTRACT_FL                                
                     , NO_CONTRACT_RSN_CD                               
                     , EQUIP_OWNER_CD                                   
                     , EQUIP_DRAWING_ID                                 
                     , EQUIP_GIS_GKEY                                   
                     , SOURCE_APPL_CD                                   
                     , SOURCE_APPL_REQ_NO                               
                     , WMS_POINT_NO                                     
                     , COALESCE(EQUIP_INSTALL_DT,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))            
                     , INSTALL_USERID                                   
                     , REPLACE(REPLACE(CONVERT(CHAR(26), APPROVED_TS
           , 121), ' ', '-'), ':', '.') APPROVED_TS                            
                     , APPROVER_USERID                                  
                     , SPCL_AGR_COMMENTS                                
                     , EQUIP_COMMENTS                                   
                 FROM  LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)            
                     , LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)            
                WHERE  [4H].FXTR_EQUIP_SEQ   = :WS-FXTR-SEQ               
                  AND  [4H].EQUIP_TYPE_CD    = 'P'                        
                  AND  [4F].INSTALL_LOC_NO   = :WS-OLD-FX-INST-LOC-NO     
                  AND  [4F].EQUIP_SEQ        = [4H].ATTACH_EQUIP_SEQ        
                                                                        
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ALL_EQU_ENVMT CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*        SELECT  INSTALL_POINT_NO                                         
MFA-TR*              , EQUIP_SEQ                                                
MFA-TR*              , INSTALL_LOC_CD                                           
MFA-TR*              , CODE_UTIL_TYPE                                           
MFA-TR*              , IC_NO                                                    
MFA-TR*              , RATE_PLAN_NO                                             
MFA-TR*              , RATE_ITEM_CODE                                           
MFA-TR*              , ITEM_SEQ_NO                                              
MFA-TR*              , BILLING_FL                                               
MFA-TR*              , NO_BILL_REASON_CD                                        
MFA-TR*              , EQUIP_CONTRACT_FL                                        
MFA-TR*              , NO_CONTRACT_RSN_CD                                       
MFA-TR*              , EQUIP_OWNER_CD                                           
MFA-TR*              , EQUIP_DRAWING_ID                                         
MFA-TR*              , EQUIP_GIS_GKEY                                           
MFA-TR*              , SOURCE_APPL_CD                                           
MFA-TR*              , SOURCE_APPL_REQ_NO                                       
MFA-TR*              , WMS_POINT_NO                                             
MFA-TR*              , IFNULL(EQUIP_INSTALL_DT,'1900-01-01')                    
MFA-TR*              , INSTALL_USERID                                           
MFA-TR*              , APPROVED_TS                                              
MFA-TR*              , APPROVER_USERID                                          
MFA-TR*              , SPCL_AGR_COMMENTS                                        
MFA-TR*              , EQUIP_COMMENTS                                           
MFA-TR*          FROM  LMS_EQUIP_ENVRNMT  4F                                    
MFA-TR*         WHERE  4F.INSTALL_LOC_NO   = :WS-OLD-FX-INST-LOC-NO             
MFA-TR*           AND  4F.INSTALL_POINT_NO = :WS-OLD-FX-INST-PNT-NO             
MFA-TR*                                                                         
MFA-TR*        UNION ALL                                                        
MFA-TR*                                                                         
MFA-TR*        SELECT  INSTALL_POINT_NO                                         
MFA-TR*              , EQUIP_SEQ                                                
MFA-TR*              , INSTALL_LOC_CD                                           
MFA-TR*              , CODE_UTIL_TYPE                                           
MFA-TR*              , IC_NO                                                    
MFA-TR*              , RATE_PLAN_NO                                             
MFA-TR*              , RATE_ITEM_CODE                                           
MFA-TR*              , ITEM_SEQ_NO                                              
MFA-TR*              , BILLING_FL                                               
MFA-TR*              , NO_BILL_REASON_CD                                        
MFA-TR*              , EQUIP_CONTRACT_FL                                        
MFA-TR*              , NO_CONTRACT_RSN_CD                                       
MFA-TR*              , EQUIP_OWNER_CD                                           
MFA-TR*              , EQUIP_DRAWING_ID                                         
MFA-TR*              , EQUIP_GIS_GKEY                                           
MFA-TR*              , SOURCE_APPL_CD                                           
MFA-TR*              , SOURCE_APPL_REQ_NO                                       
MFA-TR*              , WMS_POINT_NO                                             
MFA-TR*              , IFNULL(EQUIP_INSTALL_DT,'1900-01-01')                    
MFA-TR*              , INSTALL_USERID                                           
MFA-TR*              , APPROVED_TS                                              
MFA-TR*              , APPROVER_USERID                                          
MFA-TR*              , SPCL_AGR_COMMENTS                                        
MFA-TR*              , EQUIP_COMMENTS                                           
MFA-TR*          FROM  LMS_FXTR_ATTACHMTS 4H                                    
MFA-TR*              , LMS_EQUIP_ENVRNMT  4F                                    
MFA-TR*         WHERE  4H.FXTR_EQUIP_SEQ   = :WS-FXTR-SEQ                       
MFA-TR*           AND  4H.EQUIP_TYPE_CD    = 'P'                                
MFA-TR*           AND  4F.INSTALL_LOC_NO   = :WS-OLD-FX-INST-LOC-NO             
MFA-TR*           AND  4F.EQUIP_SEQ        = 4H.ATTACH_EQUIP_SEQ                
MFA-TR*                                                                         
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ALL_FXTR_ATMS CURSOR WITH ROWSET POSITIONING FOR  
                 SELECT  [4H].ATTACH_EQUIP_SEQ                            
                        ,[4D].EQUIP_TYPE_CD                               
                        ,[4D].EQUIP_TAG_NO                                
                        ,COALESCE([4F].INSTALL_POINT_NO,0)                  
                        ,COALESCE([4F].RATE_PLAN_NO,'')                     
                        ,COALESCE([4F].RATE_ITEM_CODE,0)                    
                        ,COALESCE([4F].BILLING_FL,'')                       
                        ,COALESCE([4F].NO_BILL_REASON_CD,'')                
                        ,[4H].ATTACH_EQUIP_DT                             
                   FROM LMS_FXTR_ATTACHMTS [4H]
                           WITH(READUNCOMMITTED)      JOIN                 
                        LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                 ON ([4H].FXTR_EQUIP_SEQ         = :WS-FXTR-SEQ           
                    AND  [4D].EQUIP_SEQ          = [4H].ATTACH_EQUIP_SEQ    
                    AND  [4D].EQUIP_TYPE_CD      = [4H].EQUIP_TYPE_CD       
                    AND  [4D].INVENTRY_STATUS_CD =  'J')  LEFT JOIN       
                         LMS_EQUIP_ENVRNMT   [4F] WITH(READUNCOMMITTED)         
                     ON ([4F].EQUIP_SEQ          = [4H].ATTACH_EQUIP_SEQ    
                    AND  [4F].INSTALL_LOC_NO     = 
                                                :WS-OLD-FX-INST-LOC-NO)
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ALL_FXTR_ATMS CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*          SELECT  4H.ATTACH_EQUIP_SEQ                                    
MFA-TR*                 ,4D.EQUIP_TYPE_CD                                       
MFA-TR*                 ,4D.EQUIP_TAG_NO                                        
MFA-TR*                 ,IFNULL(4F.INSTALL_POINT_NO,0)                          
MFA-TR*                 ,IFNULL(4F.RATE_PLAN_NO,'')                             
MFA-TR*                 ,IFNULL(4F.RATE_ITEM_CODE,0)                            
MFA-TR*                 ,IFNULL(4F.BILLING_FL,'')                               
MFA-TR*                 ,IFNULL(4F.NO_BILL_REASON_CD,'')                        
MFA-TR*                 ,4H.ATTACH_EQUIP_DT                                     
MFA-TR*            FROM LMS_FXTR_ATTACHMTS 4H      JOIN                         
MFA-TR*                 LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*          ON (4H.FXTR_EQUIP_SEQ         = :WS-FXTR-SEQ                   
MFA-TR*             AND  4D.EQUIP_SEQ          = 4H.ATTACH_EQUIP_SEQ            
MFA-TR*             AND  4D.EQUIP_TYPE_CD      = 4H.EQUIP_TYPE_CD               
MFA-TR*             AND  4D.INVENTRY_STATUS_CD =  'J')  LEFT JOIN               
MFA-TR*                  LMS_EQUIP_ENVRNMT   4F                                 
MFA-TR*              ON (4F.EQUIP_SEQ          = 4H.ATTACH_EQUIP_SEQ            
MFA-TR*             AND  4F.INSTALL_LOC_NO     = :WS-OLD-FX-INST-LOC-NO)        
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-REQUEST-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
COB305 01 I-TRAN-TO-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
       01  I-TRAN-TO-ACCT-ST              PIC X(01).                    
       01  I-FXTR-RATE                    PIC X(03).                    
       01  I-FXTR-RATE-ITEM-CD            PIC S9(4)   USAGE COMP.       
       01  I-FXTR-REV-CLASS               PIC X(03).                    
COB305 01 I-FXTR-SEQ        PIC S9(10)V USAGE COMP-3 VALUE 0.     
       01  I-FIXTURE-STOCK-CODE           PIC X(15).                    
       01  I-FXTR-EQ-TAG-NO               PIC X(12).                    
       01  I-OLD-FX-INST-LOC-NO           PIC X(10).                    
COB305 01 I-OLD-FX-INST-PNT-NO        PIC S9(05)V USAGE COMP-3 VALUE 0.     
       01  I-NEW-FX-INST-LOC-NO           PIC X(10).                    
       01  I-OLD-CNT-CD                   PIC X(01).                    
       01  I-OLD-CNT-ST-DATE              PIC X(10).                    
       01  I-ORIG-CNT-TERM-CHG            PIC X(08).                    
       01  I-OLD-CNT-TERM-CHG             PIC X(08).                    
       01  I-NEW-CNT-CD                   PIC X(01).                    
ACT040 01  I-NEW-CNT-CLP-NO               PIC X(50).                    
       01  I-NEW-CNT-DUR-CD               PIC X(02).                    
       01  I-NEW-CNT-STR-DT               PIC X(10).                    
       01  I-NEW-CNT-END-DT               PIC X(10).                    
       01  I-NEW-CNT-NO-CN-RSN-CD         PIC X(02).                    
       01  I-USER-ID                      PIC X(07).                    
       01  I-POLE-ACTION-CD               PIC X(01).                    
       01  I-NEW-POLE-TAG-NO              PIC X(12).                    
       01  I-NEW-POLE-STK-CD              PIC X(15).                    
       01  I-NEW-POLE-RATE                PIC X(03).                    
       01  I-NEW-POLE-RATE-ITEM-CD        PIC S9(4) USAGE COMP.         
       01  I-NEW-POLE-REV-CLASS           PIC X(03).                    
       01  I-OLD-CNT-TRFEE-OVR-CMT.                                     
           05 I-OLD-CNT-TRFEE-OVR-CMT-LEN PIC S9(04) COMP.              
           05 I-OLD-CNT-TRFEE-OVR-CMT-TXT PIC X(248).                   
       01  I-WMS-SO-NO-CMT.                                             
           05 I-WMS-SO-NO-CMT-LEN         PIC S9(04) COMP.              
           05 I-WMS-SO-NO-CMT-TXT         PIC X(248).                   
ACT040 01  I-OLD-CNT-CLP-NO               PIC X(50).                    
ACT069 01  I-EFFECTIVE-DATE               PIC X(10) VALUE SPACES.       
                                                                        
       PROCEDURE DIVISION  USING I-REQUEST-NO                           
                                 I-ACCOUNT-NO                           
                                 I-TRAN-TO-ACCT-NO                      
                                 I-TRAN-TO-ACCT-ST                      
                                 I-FXTR-RATE                            
                                 I-FXTR-RATE-ITEM-CD                    
                                 I-FXTR-REV-CLASS                       
                                 I-FXTR-SEQ                             
                                 I-FIXTURE-STOCK-CODE                   
                                 I-FXTR-EQ-TAG-NO                       
                                 I-OLD-FX-INST-LOC-NO                   
                                 I-OLD-FX-INST-PNT-NO                   
                                 I-NEW-FX-INST-LOC-NO                   
                                 I-OLD-CNT-CD                           
                                 I-OLD-CNT-ST-DATE                      
                                 I-ORIG-CNT-TERM-CHG                    
                                 I-OLD-CNT-TERM-CHG                     
                                 I-NEW-CNT-CD                           
                                 I-NEW-CNT-CLP-NO                       
                                 I-NEW-CNT-DUR-CD                       
                                 I-NEW-CNT-STR-DT                       
                                 I-NEW-CNT-END-DT                       
                                 I-NEW-CNT-NO-CN-RSN-CD                 
                                 I-USER-ID                              
                                 I-POLE-ACTION-CD                       
                                 I-NEW-POLE-TAG-NO                      
                                 I-NEW-POLE-STK-CD                      
                                 I-NEW-POLE-RATE                        
                                 I-NEW-POLE-RATE-ITEM-CD                
                                 I-NEW-POLE-REV-CLASS                   
                                 I-OLD-CNT-TRFEE-OVR-CMT                
                                 I-WMS-SO-NO-CMT                        
                                 I-OLD-CNT-CLP-NO                       
ACT069                           I-EFFECTIVE-DATE.                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1                                 
              THRU 0100A-EXIT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04776_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04776_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04776_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS          THRU 8000A-EXIT    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04776_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04776_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-REQUEST-NO              TO WS-REQUEST-NO              
           MOVE I-ACCOUNT-NO              TO WS-ACCOUNT-NO              
           MOVE I-TRAN-TO-ACCT-NO         TO WS-TRAN-TO-ACCT-NO         
           MOVE I-TRAN-TO-ACCT-ST         TO WS-TRAN-TO-ACCT-ST         
           MOVE I-FXTR-RATE               TO WS-FXTR-RATE               
           MOVE I-FXTR-RATE-ITEM-CD       TO WS-FXTR-RATE-ITEM-CD       
           MOVE I-FXTR-REV-CLASS          TO WS-FXTR-REV-CLASS          
           MOVE I-FXTR-SEQ                TO WS-FXTR-SEQ                
           MOVE I-FXTR-EQ-TAG-NO          TO WS-FXTR-EQ-TAG-NO          
           MOVE I-FIXTURE-STOCK-CODE      TO WS-FIXTURE-STOCK-CD        
           MOVE I-OLD-FX-INST-LOC-NO      TO WS-OLD-FX-INST-LOC-NO      
           MOVE I-OLD-FX-INST-PNT-NO      TO WS-OLD-FX-INST-PNT-NO      
           MOVE I-NEW-FX-INST-LOC-NO      TO WS-NEW-FX-INST-LOC-NO      
           MOVE I-OLD-CNT-CD              TO WS-OLD-CNT-CD              
           MOVE I-OLD-CNT-ST-DATE         TO WS-OLD-CNT-ST-DATE         
           MOVE I-NEW-CNT-CD              TO WS-NEW-CNT-CD              
           MOVE I-NEW-CNT-CLP-NO          TO WS-NEW-CNT-CLP-NO          
           MOVE I-NEW-CNT-DUR-CD          TO WS-NEW-CNT-DUR-CD          
           MOVE I-NEW-CNT-STR-DT          TO WS-NEW-CNT-STR-DT          
           MOVE I-NEW-CNT-END-DT          TO WS-NEW-CNT-END-DT          
           MOVE I-NEW-CNT-NO-CN-RSN-CD    TO WS-NEW-CNT-NO-CN-RSN-CD    
           MOVE I-USER-ID                 TO WS-USER-ID                 
           MOVE I-OLD-CNT-TRFEE-OVR-CMT   TO WS-OLD-CNT-TRFEE-OVR-CMT   
           MOVE I-WMS-SO-NO-CMT           TO WS-WMS-SO-NO-CMT           
           MOVE I-POLE-ACTION-CD          TO WS-POLE-ACTION-CD          
           MOVE I-NEW-POLE-TAG-NO         TO WS-NEW-POLE-TAG-NO         
           MOVE I-NEW-POLE-STK-CD         TO WS-NEW-POLE-STK-CD         
                                                                        
           MOVE I-OLD-CNT-TERM-CHG        TO WS-TERM-CHRG-AMT-TXT       
           MOVE WS-TERM-CHRG-AMT-AM       TO WS-TERM-CHRG-AMT-TEXT      
                                                                        
           IF WS-TERM-CHRG-AMT-SI = '-'                                 
              COMPUTE WS-TERM-CHRG-AMT-COMP = WS-TERM-CHRG-AMT-NUM  * -1
           ELSE                                                         
              COMPUTE WS-TERM-CHRG-AMT-COMP = WS-TERM-CHRG-AMT-NUM  *  1
           END-IF.                                                      
                                                                        
           MOVE I-ORIG-CNT-TERM-CHG       TO WS-ORIG-TERM-CHRG-TXT.     
           MOVE WS-ORIG-TERM-CHRG-AM      TO WS-ORIG-TERM-CHRG-TEXT.    
                                                                        
           IF WS-ORIG-TERM-CHRG-AM = '-'                                
              COMPUTE WS-ORIG-TERM-CHRG-COMP                            
                      EQUAL WS-ORIG-TERM-CHRG-NUM  * -1                 
           ELSE                                                         
              COMPUTE WS-ORIG-TERM-CHRG-COMP                            
                      EQUAL WS-ORIG-TERM-CHRG-NUM  *  1                 
           END-IF.                                                      
                                                                        
           MOVE I-OLD-CNT-CLP-NO          TO WS-OLD-CNT-CLP-NO          
                                                                        
           MOVE 01                        TO WS-TAB-INDX.               
           PERFORM 7205-GET-CURRENT-DT-TM    THRU 7205-EXIT.            
           MOVE 0                         TO 4L-FIXTURE-COST-AM         
                                             4L-POLE-COST-AM.           
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *** TRANSFER FROM/TO LOCATIONS SHOULD NOT BE SAME                         
           IF WS-OLD-FX-INST-LOC-NO = WS-NEW-FX-INST-LOC-NO             
              MOVE 'LMS0000002'           TO S-RS1-BUS-RULE-ID          
              MOVE 'F'                    TO S-RS1-BUS-RULE-RESULT-CD   
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
      **LOAD ALL EQUIP_ENV ENTRIES FOR FIXTURE OLD LOCATION                     
           PERFORM 7100-OPEN-ALL-EQU-ENV-CUR      THRU 7100-EXIT.       
           PERFORM 7101-FETCH-ALL-EQU-ENV-CUR     THRU 7101-EXIT.       
           PERFORM 7102-CLOSE-ALL-EQU-ENV-CUR     THRU 7102-EXIT.       
                                                                        
      **LOAD ALL FXTR_ATTCHMENT FOR FIXTURE                                     
           PERFORM 7200-OPEN-ALL-FIX-ATT-CUR      THRU 7200-EXIT.       
           PERFORM 7201-FETCH-ALL-FIX-ATT-CUR     THRU 7201-EXIT.       
           PERFORM 7202-CLOSE-ALL-FIX-ATT-CUR     THRU 7202-EXIT.       
                                                                        
           PERFORM 2025-PROCESS-OLD-LOCATION      THRU 2025-EXIT.       
           PERFORM 2050-PROCESS-NEW-LOCATION      THRU 2050-EXIT.       
                                                                        
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            ADD +1                         TO CTR-ROWS-RS1              
            MOVE S-RETURN-CODE             TO S-RETURN-CODE-1.          
            MOVE S-APPL-RETURN-CODE        TO S-APPL-RETURN-CODE-1.     
            PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.           
      *                                                                         
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 2025-PROCESS-OLD-LOCATION.                                     *        
      ******************************************************************        
       2025-PROCESS-OLD-LOCATION.                                       
      *                                                                         
           MOVE 1                              TO WS-TAB-INDX.          
           PERFORM 2100-PROCESS-OLD-EQUIP-ENV     THRU 2100-EXIT        
              UNTIL TAB-EQUIP-SEQ(WS-TAB-INDX) = ZERO                   
                 OR WS-TAB-INDX > WS-MAX-ENTRY-COUNT.                   
                                                                        
           PERFORM 2200-PRCS-OLD-FXTR-CNTR-CD     THRU 2200-EXIT.       
           PERFORM 5000-WRITE-TRANS-HIST          THRU 5000-EXIT.       
ACT028     IF WS-ACCOUNT-NO > 0                                         
ACT028       PERFORM 7590-GET-ACCOUNT-STATUS  THRU 7590-EXIT            
ACT028     END-IF.                                                      
ACT028     IF WS-ACCOUNT-NO > 0 AND AT-CODE-ACCT-STAT = 'A'             
ACT028          PERFORM 2450-PROCESS-LAST-LIGHT-WQ   THRU   2450-EXIT   
ACT028     END-IF.                                                      
      *                                                                         
       2025-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2050-PROCESS-NEW-LOCATION.                                     *        
      ******************************************************************        
       2050-PROCESS-NEW-LOCATION.                                       
      *                                                                         
           MOVE 1                              TO WS-TAB-INDX.          
           PERFORM 2150-PROCESS-NEW-EQUIP-ENV     THRU 2150-EXIT        
              UNTIL TAB-EQUIP-SEQ(WS-TAB-INDX) = ZERO                   
                 OR WS-TAB-INDX > WS-MAX-ENTRY-COUNT.                   
                                                                        
           PERFORM 2250-PRCS-NEW-FXTR-CNTR-CD     THRU 2250-EXIT.       
           PERFORM 5701-WRITE-TRANS-HIST-NEW      THRU 5701-EXIT.       
      **SET PENDING ACCOUNT TO ACTIVE                                           
           PERFORM 2600-SET-ACCT-STAT-TO-ACTIVE   THRU 2600-EXIT.       
      *                                                                         
       2050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2100-PROCESS-OLD-EQUIP-ENV                                     *        
      ******************************************************************        
       2100-PROCESS-OLD-EQUIP-ENV.                                      
      *                                                                         
      ***PROCESSING FIXTURE                                                     
            IF TAB-EQUIP-SEQ(WS-TAB-INDX) = WS-FXTR-SEQ                 
               INITIALIZE WS-TAB-CODE-UTIL-TYPE                         
                          WS-TAB-IC-NO                                  
               MOVE TAB-CODE-UTIL-TYPE(WS-TAB-INDX)                     
                                             TO WS-TAB-CODE-UTIL-TYPE   
               MOVE TAB-IC-NO(WS-TAB-INDX)   TO WS-TAB-IC-NO            
               MOVE TAB-RATE-PLAN-NO(WS-TAB-INDX)                       
                                             TO WS-TAB-RATE-PLAN-NO     
               MOVE TAB-RATE-ITEM-CODE(WS-TAB-INDX)                     
                                             TO WS-TAB-RATE-ITEM-CD     
                                                                        
               PERFORM 7210-GET-UT-REV-CLASS     THRU 7210-EXIT         
      ***      PERFORM 2115-DO-RATE-MATCHING     THRU 2115-EXIT                 
                                                                        
               MOVE WS-NEW-FX-INST-LOC-NO    TO WS-4F-INST-LOC-NO       
               PERFORM 7418-GET-NXT-4F-INS-POINT THRU 7418-EXIT         
                                                                        
      ***DIRECT BILLED LIGHT:STOP BILLING FIXTURE AT OLD LOCATION               
               IF (TAB-INSTALL-LOC-CD(WS-TAB-INDX) = 'P') AND           
                 ((TAB-BILLING-FL(WS-TAB-INDX)     = 'Y') OR            
                  (TAB-BILLING-FL(WS-TAB-INDX)     = 'N'  AND           
                   TAB-RATE-PLAN-NO(WS-TAB-INDX)   > ' '  AND           
                   TAB-RATE-ITEM-CODE(WS-TAB-INDX) >  0 ) )             
                  INITIALIZE LM001-INPUT                                
                  MOVE 'R'                   TO LM001-ACTION-CODE       
                  MOVE WS-ACCOUNT-NO         TO LM001-ACCOUNT-NO        
                  MOVE WS-OLD-FX-INST-LOC-NO                            
                                             TO LM001-INSTALL-LOC-NO    
                  MOVE WS-OLD-FX-INST-PNT-NO                            
                                             TO LM001-INSTALL-POINT-NO  
ACT069*           MOVE WS-CURRENT-DATE       TO LM001-ACTION-DATE               
ACT069            MOVE I-EFFECTIVE-DATE      TO LM001-ACTION-DATE       
                  MOVE WS-CODE-REV-CLASS     TO LM001-CODE-REVENUE-CLASS
                  PERFORM 6001-ADJUST-CUST-PLAN-COUNT                   
                                                THRU 6001-EXIT          
               ELSE                                                     
                  MOVE WS-OLD-FX-INST-LOC-NO TO 4F-INSTALL-LOC-NO       
                  MOVE WS-OLD-FX-INST-PNT-NO TO 4F-INSTALL-POINT-NO     
                  PERFORM 8310-DELETE-EQU-ENV   THRU 8310-EXIT          
               END-IF                                                   
            ELSE                                                        
               MOVE TAB-EQUIP-SEQ(WS-TAB-INDX) TO 4D-EQUIP-SEQ          
      ***DIRECT BILLED LIGHT:STOP BILLING POLE AT OLD LOCATION                  
               IF (TAB-INSTALL-LOC-CD(WS-TAB-INDX) = 'P') AND           
                 ((TAB-BILLING-FL(WS-TAB-INDX)     = 'Y') OR            
                  (TAB-BILLING-FL(WS-TAB-INDX)     = 'N'  AND           
                   TAB-RATE-PLAN-NO(WS-TAB-INDX)   > ' '  AND           
                   TAB-RATE-ITEM-CODE(WS-TAB-INDX) >  0 ) )             
                  INITIALIZE LM001-INPUT                                
                  MOVE 'R'                     TO LM001-ACTION-CODE     
                  MOVE WS-ACCOUNT-NO           TO LM001-ACCOUNT-NO      
                  MOVE WS-OLD-FX-INST-LOC-NO   TO LM001-INSTALL-LOC-NO  
                  MOVE TAB-INSTALL-POINT-NO(WS-TAB-INDX)                
                                               TO LM001-INSTALL-POINT-NO
ACT069*           MOVE WS-CURRENT-DATE         TO LM001-ACTION-DATE             
ACT069            MOVE I-EFFECTIVE-DATE        TO LM001-ACTION-DATE     
                  PERFORM 6001-ADJUST-CUST-PLAN-COUNT THRU 6001-EXIT    
               ELSE                                                     
      ***POLE NOT BILLABLE, CUST COUNT ADJUSTMENT NOT NEEDED                    
                  MOVE WS-OLD-FX-INST-LOC-NO   TO 4F-INSTALL-LOC-NO     
                  MOVE TAB-INSTALL-POINT-NO(WS-TAB-INDX)                
                                               TO 4F-INSTALL-POINT-NO   
                  PERFORM 8310-DELETE-EQU-ENV         THRU 8310-EXIT    
               END-IF                                                   
      ***DELETE POLE FROM INVENTORY ONLY IF NEW POLE IS ADDED                   
               IF WS-POLE-ACTION-CD = 'A'                               
ACT073            PERFORM 8102-DEL-OLD-FX-ATTCH       THRU 8102-EXIT    
                  PERFORM 8104-DEL-OLD-POLE-EQ-INV    THRU 8104-EXIT    
               END-IF                                                   
            END-IF.                                                     
                                                                        
            ADD 1                             TO WS-TAB-INDX.           
      *                                                                         
       2100-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2115-DO-RATE-MATCHING                                          *        
      * CHECK IF FIXTURE RATE/RATE ITEM CODE/REVENUE CLASS CHANGED     *        
      ******************************************************************        
      *2115-DO-RATE-MATCHING.                                                   
      *                                                                         
      *    IF TAB-RATE-PLAN-NO  (WS-TAB-INDX) = WS-FXTR-RATE AND                
      *       TAB-RATE-ITEM-CODE(WS-TAB-INDX) = WS-FXTR-RATE-ITEM-CD            
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       SET RATE-DIFFERS TO TRUE                                          
      *    END-IF.                                                              
      *                                                                         
      *2115-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      * 2150-PROCESS-NEW-EQUIP-ENV.                                    *        
      ******************************************************************        
       2150-PROCESS-NEW-EQUIP-ENV.                                      
      *                                                                         
      ***PROCESSING FIXTURE                                                     
            IF TAB-EQUIP-SEQ(WS-TAB-INDX) = WS-FXTR-SEQ                 
               MOVE WS-NEW-FX-INST-LOC-NO      TO WS-4F-INST-LOC-NO     
               PERFORM 7418-GET-NXT-4F-INS-POINT  THRU 7418-EXIT        
                                                                        
      ***INSTALL FIXTURE AT NEW LOCATION                                        
               PERFORM 2160-MOVE-EQ-ENV-VALUES    THRU 2160-EXIT        
               PERFORM 8210-INSRT-EQU-ENV         THRU 8210-EXIT        
                                                                        
      ***START BILLING FIXTURE AT NEW LOCATION (ASSUMPTION IS FIXTURE           
      ***WILL ALWAYS BE BILLABLE WHEN TRANSFERED TO ACCOUNT                     
               INITIALIZE LM001-INPUT                                   
               MOVE 'N'                        TO LM001-ACTION-CODE     
               MOVE WS-TRAN-TO-ACCT-NO         TO LM001-ACCOUNT-NO      
               MOVE WS-NEW-FX-INST-LOC-NO      TO LM001-INSTALL-LOC-NO  
               MOVE WS-MAX-4F-INS-POINT-NO     TO LM001-INSTALL-POINT-NO
ACT069*        MOVE WS-CURRENT-DATE            TO LM001-ACTION-DATE             
ACT069         MOVE I-EFFECTIVE-DATE           TO LM001-ACTION-DATE     
               MOVE WS-FXTR-REV-CLASS          TO                       
                    LM001-CODE-REVENUE-CLASS                            
               PERFORM 6001-ADJUST-CUST-PLAN-COUNT THRU 6001-EXIT       
            ELSE                                                        
      ***PROCESSING POLE/S                                                      
               IF WS-POLE-ACTION-CD = 'A'                               
                  MOVE WS-NEW-POLE-STK-CD      TO 4A-STOCK-CD           
                  MOVE 'P'                     TO 4A-EQUIP-TYPE-CD      
                  PERFORM 7410-GET-MSTR-STK-INFO    THRU 7410-EXIT      
                  MOVE 4A-EQUIPMENT-COST-AM    TO 4L-POLE-COST-AM       
                  PERFORM 7412-GET-NEW-EQUIP-SEQ    THRU 7412-EXIT      
                  PERFORM 7415-ADD-NEW-POLE-EQ-INV  THRU 7415-EXIT      
                  MOVE WS-NEW-FX-INST-LOC-NO   TO WS-4F-INST-LOC-NO     
                  PERFORM 7418-GET-NXT-4F-INS-POINT THRU 7418-EXIT      
                  MOVE 'U'                     TO 4F-CODE-UTIL-TYPE     
                  IF I-NEW-POLE-RATE > SPACES OR                        
                     I-NEW-POLE-RATE-ITEM-CD > 0                        
                     MOVE 'Z'                  TO 4F-BILLING-FL         
ACT026               INITIALIZE                   RD-CODE-UTIL-TYPE     
ACT026                                            RD-RATE-PLAN-NO       
ACT026               MOVE I-NEW-POLE-RATE      TO RD-RATE-PLAN-NO       
ACT026               PERFORM 7560-GET-CODE-UTIL-TYPE THRU 7560-EXIT     
ACT026               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL     
ACT026                  MOVE RD-CODE-UTIL-TYPE TO 4F-CODE-UTIL-TYPE     
ACT026               END-IF                                             
                  ELSE                                                  
                     MOVE 'N'                  TO 4F-BILLING-FL         
                  END-IF                                                
                  PERFORM 7420-ADD-NEW-POLE-EQ-ENV  THRU 7420-EXIT      
                  PERFORM 7400-ADD-POLES-NEW-FX-ATT THRU 7400-EXIT      
                  IF 4F-BILLING-FL = 'Z'                                
                     INITIALIZE LM001-INPUT                             
                     MOVE 'N'                  TO LM001-ACTION-CODE     
                     MOVE WS-TRAN-TO-ACCT-NO   TO LM001-ACCOUNT-NO      
                     MOVE WS-NEW-FX-INST-LOC-NO                         
                                               TO LM001-INSTALL-LOC-NO  
                     MOVE WS-MAX-4F-INS-POINT-NO                        
                       TO LM001-INSTALL-POINT-NO                        
ACT069*              MOVE WS-CURRENT-DATE      TO LM001-ACTION-DATE             
ACT069               MOVE I-EFFECTIVE-DATE     TO LM001-ACTION-DATE     
                     MOVE I-NEW-POLE-REV-CLASS                          
                       TO LM001-CODE-REVENUE-CLASS                      
                     PERFORM 6001-ADJUST-CUST-PLAN-COUNT                
                                                    THRU 6001-EXIT      
                  END-IF                                                
               ELSE                                                     
      ***FOR EXISTING POLE IF NEW CONTRACT IS ESTABLISHED GET EQUIP COST        
                  IF WS-NEW-CNT-CD EQUAL 'Y'                            
                     PERFORM 7411-GET-EQUIPMENT-COST THRU 7411-EXIT     
                     COMPUTE 4L-POLE-COST-AM EQUAL                      
                             4L-POLE-COST-AM + 4A-EQUIPMENT-COST-AM     
                  END-IF                                                
                  PERFORM 7418-GET-NXT-4F-INS-POINT  THRU 7418-EXIT     
                  PERFORM 2160-MOVE-EQ-ENV-VALUES    THRU 2160-EXIT     
                  PERFORM 8210-INSRT-EQU-ENV         THRU 8210-EXIT     
      ***FOR BILLABLE POLE START BILLING AT NEW LOCATION                        
                  IF 4F-BILLING-FL = 'Z'                                
                     INITIALIZE LM001-INPUT                             
                     MOVE 'N'                  TO LM001-ACTION-CODE     
                     MOVE WS-TRAN-TO-ACCT-NO   TO LM001-ACCOUNT-NO      
                     MOVE WS-NEW-FX-INST-LOC-NO                         
                                               TO LM001-INSTALL-LOC-NO  
                     MOVE WS-MAX-4F-INS-POINT-NO                        
                                               TO LM001-INSTALL-POINT-NO
ACT069*              MOVE WS-CURRENT-DATE      TO LM001-ACTION-DATE             
ACT069               MOVE I-EFFECTIVE-DATE     TO LM001-ACTION-DATE     
                     MOVE SPACES                                        
                       TO LM001-CODE-REVENUE-CLASS                      
                     PERFORM 6001-ADJUST-CUST-PLAN-COUNT                
                                                     THRU 6001-EXIT     
                  END-IF                                                
               END-IF                                                   
            END-IF.                                                     
                                                                        
            ADD 1                              TO WS-TAB-INDX.          
      *                                                                         
       2150-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 2160-MOVE-EQ-ENV-VALUES.                                       *        
      ******************************************************************        
       2160-MOVE-EQ-ENV-VALUES.                                         
                                                                        
            MOVE WS-NEW-FX-INST-LOC-NO      TO 4F-INSTALL-LOC-NO.       
            MOVE WS-MAX-4F-INS-POINT-NO     TO 4F-INSTALL-POINT-NO.     
            MOVE TAB-EQUIP-CONTRACT-FL(WS-TAB-INDX)                     
                                            TO 4F-EQUIP-CONTRACT-FL.    
      ***PROCESSING FIXTURE                                                     
            IF TAB-EQUIP-SEQ(WS-TAB-INDX) = WS-FXTR-SEQ                 
               MOVE WS-FXTR-RATE            TO 4F-RATE-PLAN-NO          
               MOVE WS-FXTR-RATE-ITEM-CD    TO 4F-RATE-ITEM-CODE        
               IF 4F-RATE-PLAN-NO > SPACES AND                          
                  4F-RATE-ITEM-CODE > 0                                 
      ***NEW LIGHT FIXTURE INSTALLATION AT TRANSFER TO LOCATION                 
                  MOVE 'Z'                  TO 4F-BILLING-FL            
               ELSE                                                     
                  MOVE 'N'                  TO 4F-BILLING-FL            
               END-IF                                                   
               IF WS-NEW-CNT-CD EQUAL 'Y'                               
                  MOVE 'Y'                  TO 4F-EQUIP-CONTRACT-FL     
               END-IF                                                   
            ELSE                                                        
      ***PROCESSING POLE(S)                                                     
               IF TAB-BILLING-FL(WS-TAB-INDX)      = 'Y'                
A05084         OR (TAB-BILLING-FL(WS-TAB-INDX)     = 'N'                
A05084        AND  TAB-RATE-PLAN-NO(WS-TAB-INDX)   > ' '                
A05084        AND  TAB-RATE-ITEM-CODE(WS-TAB-INDX) > 0 )                
                  MOVE 'Z'                  TO 4F-BILLING-FL            
               ELSE                                                     
                  MOVE TAB-BILLING-FL(WS-TAB-INDX)                      
                                            TO 4F-BILLING-FL            
               END-IF                                                   
               MOVE TAB-RATE-PLAN-NO(WS-TAB-INDX)                       
                                            TO 4F-RATE-PLAN-NO          
               MOVE TAB-RATE-ITEM-CODE(WS-TAB-INDX)                     
                                            TO 4F-RATE-ITEM-CODE        
            END-IF.                                                     
            MOVE WS-NEW-CNT-NO-CN-RSN-CD    TO 4F-NO-CONTRACT-RSN-CD.   
            MOVE WS-CURRENT-TS              TO 4F-LAST-UPDATE-TS.       
            MOVE WS-USER-ID                 TO 4F-LAST-UPDATE-USERID.   
            MOVE 'CIS'                      TO 4F-SOURCE-APPL-CD.       
                                                                        
            MOVE TAB-EQUIP-SEQ(WS-TAB-INDX) TO 4F-EQUIP-SEQ.            
      ***TRANSFER TO IS ALWAYS PREMISE                                          
            MOVE 'P'                        TO 4F-INSTALL-LOC-CD.       
            MOVE 'U'                        TO 4F-CODE-UTIL-TYPE.       
ACT026      IF 4F-RATE-PLAN-NO > SPACES                                 
ACT026         INITIALIZE                      RD-CODE-UTIL-TYPE        
ACT026                                         RD-RATE-PLAN-NO          
ACT026         MOVE 4F-RATE-PLAN-NO         TO RD-RATE-PLAN-NO          
ACT026         PERFORM 7560-GET-CODE-UTIL-TYPE THRU 7560-EXIT           
ACT026         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
ACT026            MOVE RD-CODE-UTIL-TYPE    TO 4F-CODE-UTIL-TYPE        
ACT026         END-IF                                                   
ACT026      END-IF.                                                     
            MOVE TAB-IC-NO(WS-TAB-INDX)     TO 4F-IC-NO.                
            MOVE TAB-ITEM-SEQ-NO(WS-TAB-INDX)                           
                                            TO 4F-ITEM-SEQ-NO.          
            MOVE TAB-NO-BILL-REASON-CD(WS-TAB-INDX)                     
                                            TO 4F-NO-BILL-REASON-CD.    
            MOVE TAB-EQUIP-OWNER-CD(WS-TAB-INDX)                        
                                            TO 4F-EQUIP-OWNER-CD.       
            MOVE TAB-EQUIP-DRAWING-ID(WS-TAB-INDX)                      
                                            TO 4F-EQUIP-DRAWING-ID.     
            MOVE TAB-EQUIP-GIS-GKEY(WS-TAB-INDX)                        
                                            TO 4F-EQUIP-GIS-GKEY.       
            MOVE WS-REQUEST-NO              TO 4F-SOURCE-APPL-REQ-NO.   
            MOVE TAB-WMS-POINT-NO(WS-TAB-INDX)                          
                                            TO 4F-WMS-POINT-NO.         
            MOVE TAB-EQUIP-INSTALL-DT(WS-TAB-INDX)                      
                                            TO 4F-EQUIP-INSTALL-DT.     
            IF TAB-EQUIP-INSTALL-DT(WS-TAB-INDX) = '1900-01-01'         
               MOVE -1                      TO WS-NULL-EQU-INST-DT      
            END-IF.                                                     
            MOVE TAB-INSTALL-USERID(WS-TAB-INDX)                        
                                            TO 4F-INSTALL-USERID.       
            MOVE TAB-APPROVED-TS(WS-TAB-INDX)                           
                                            TO 4F-APPROVED-TS.          
            IF TAB-NULL-APPROVED-TS(WS-TAB-INDX) EQUAL -1               
               MOVE -1                      TO WS-NULL-APPROVED-TS      
            ELSE                                                        
               MOVE 0                       TO WS-NULL-APPROVED-TS      
            END-IF.                                                     
            MOVE TAB-APPROVER-USERID(WS-TAB-INDX)                       
                                            TO 4F-APPROVER-USERID.      
            MOVE LENGTH OF TAB-SPCL-AGR-COMMENTS(WS-TAB-INDX)           
                                            TO 4F-SPCL-AGR-COMMENTS-LEN.
            MOVE TAB-SPCL-AGR-COMMENTS(WS-TAB-INDX)                     
                                            TO 4F-SPCL-AGR-COMMENTS-TEXT
            MOVE LENGTH OF TAB-EQUIP-COMMENTS(WS-TAB-INDX)              
                                            TO 4F-EQUIP-COMMENTS-LEN.   
            MOVE TAB-EQUIP-COMMENTS(WS-TAB-INDX)                        
                                            TO 4F-EQUIP-COMMENTS-TEXT.  
      *                                                                         
       2160-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 2200-PRCS-OLD-FXTR-CNTR-CD                                              
      ******************************************************************        
       2200-PRCS-OLD-FXTR-CNTR-CD.                                      
                                                                        
            IF WS-OLD-CNT-CD = 'T'                                      
               MOVE WS-TERM-CHRG-AMT-COMP     TO 4L-ACTL-TERM-CHRG-AM   
               MOVE WS-ORIG-TERM-CHRG-COMP    TO 4L-ORIG-TERM-CHRG-AM   
               MOVE WS-CURRENT-DATE           TO WS-OLD-CNT-TERM-DT     
               PERFORM 7515-UPD-OLD-EQ-CNT       THRU 7515-EXIT         
               IF 4L-ACTL-TERM-CHRG-AM > 0                              
                  PERFORM 6003-CREATE-CONTRACT   THRU 6003-EXIT         
               END-IF                                                   
            END-IF.                                                     
      *                                                                         
       2200-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 2250-PRCS-NEW-FXTR-CNTR-CD                                              
      ******************************************************************        
       2250-PRCS-NEW-FXTR-CNTR-CD.                                      
                                                                        
            IF WS-NEW-CNT-CD EQUAL 'Y'                                  
               MOVE WS-FIXTURE-STOCK-CD    TO 4A-STOCK-CD               
               MOVE 'F'                    TO 4A-EQUIP-TYPE-CD          
               PERFORM 7410-GET-MSTR-STK-INFO THRU 7410-EXIT            
               MOVE 4A-EQUIPMENT-COST-AM   TO 4L-FIXTURE-COST-AM        
                                                                        
               MOVE WS-TERM-CHRG-AMT-COMP  TO 4L-ACTL-TERM-CHRG-AM      
               MOVE WS-ORIG-TERM-CHRG-COMP TO 4L-ORIG-TERM-CHRG-AM      
                                                                        
               PERFORM 7510-INS-NEW-EQ-CNT    THRU 7510-EXIT            
            END-IF.                                                     
      *                                                                         
       2250-EXIT.                                                       
             EXIT.                                                      
                                                                        
ACT028******************************************************************        
ACT028* 2450-PROCESS-LAST-LIGHT-WQ.                                    *        
ACT028******************************************************************        
ACT028 2450-PROCESS-LAST-LIGHT-WQ.                                      
ACT028                                                                  
ACT028      MOVE 0                         TO WS-ACT-CUST-PLAN-CNT      
ACT028                                        WS-ACT-METER-ENV-CNT.     
ACT028                                                                  
ACT028      PERFORM 7570-CHECK-ACTIVE-CUST-PLAN    THRU 7570-EXIT       
ACT028                                                                  
ACT028      IF WS-ACT-CUST-PLAN-CNT = 0                                 
ACT028         PERFORM 7580-CHECK-ACTIVE-METER-ENV THRU 7580-EXIT       
ACT028      END-IF.                                                     
ACT028                                                                  
ACT028      IF WS-ACT-METER-ENV-CNT = 0 AND WS-ACT-CUST-PLAN-CNT = 0    
ACT028         INITIALIZE CWS00077-FIELDS                               
ACT028                                                                  
ACT028         EXEC SQL                                                 
ACT028              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP       
ACT028         END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                         
MFA-TR*             SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP               
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT028                                                                  
ACT028         MOVE WS-ACCOUNT-NO          TO WS-77-ACCOUNT-NO          
ACT028         MOVE WS-CURRENT-TIMESTAMP   TO WS-77-DATE-CREATED        
ACT028                                        WS-77-DATE-REQUIRED       
ACT028         MOVE 571                    TO WS-77-CATEGORY-ID         
ACT028         MOVE 'H'                    TO WS-77-PRIORITY            
ACT028         MOVE '1'                    TO WS-77-ROUTE-CATEGORY      
ACT028         MOVE WS-WQ-COMMENTS         TO WS-77-COMMENTS-TEXT       
ACT028                                                                  
ACT028         COMPUTE WS-77-COMMENTS-LEN                               
ACT028                 EQUAL LENGTH OF WS-77-COMMENTS-TEXT              
ACT028                                                                  
ACT028         MOVE PROGRAM-NAME           TO WS-77-CREATED-BY          
ACT028         MOVE 'SYSTEM'               TO WS-77-USER-ID-ORIG        
ACT028                                                                  
ACT028         PERFORM 6002-INSERT-WORK-QUEUE THRU 6002-EXIT            
ACT028      END-IF.                                                     
ACT028                                                                  
ACT028 2450-EXIT.                                                       
ACT028     EXIT.                                                        
ACT028                                                                  
ACT028******************************************************************        
      ******************************************************************        
      * SET PENDING ACCOUNT TO ACTIVE                                  *        
      ******************************************************************        
       2600-SET-ACCT-STAT-TO-ACTIVE.                                    
                                                                        
           INITIALIZE LM04-INPUT.                                       
                                                                        
           MOVE WS-TRAN-TO-ACCT-NO          TO LM04-ACCOUNT-NO.         
           MOVE WS-NEW-FX-INST-LOC-NO       TO LM04-INSTALL-LOC-NO.     
           MOVE WS-USER-ID                  TO LM04-USER-ID.            
           MOVE PROGRAM-NAME                TO LM04-PROGRAM-NAME.       
           MOVE WS-CURRENT-DATE             TO LM04-ACTION-DATE.        
                                                                        
           PERFORM 6000-LM04-SET-PEND-ACCOUNT  THRU 6000-LM04-EXIT.     
                                                                        
           IF LM04-ERROR                                                
              MOVE LM04-ERR-SQLCODE        TO WS-ACTIVE-RETURN-CODE     
              MOVE LM04-BUS-RULE-ID        TO S-RS1-BUS-RULE-ID         
              MOVE LM04-BUS-RULE-RESULT-CD TO S-RS1-BUS-RULE-RESULT-CD  
              MOVE 'CPDLM004'              TO ABEND-PROGRAM             
              MOVE LM04-ERR-PARAGRAPH-NO   TO ACTIVE-PARAGRAPH          
              MOVE LM04-ERR-FUNCTION       TO ABEND-FUNCTION            
              MOVE LM04-ERR-TABLE1         TO TABLE-1                   
              MOVE LM04-ERR-TABLE2         TO TABLE-2                   
              MOVE LM04-ERR-COLUMN-1       TO TABLE-ELEMENT-1           
              MOVE LM04-ERR-COLUMN-2       TO TABLE-ELEMENT-2           
              MOVE LM04-ERR-COLUMN-3       TO TABLE-ELEMENT-3           
              MOVE LM04-ERR-COLUMN-4       TO TABLE-ELEMENT-4           
              MOVE LM04-ERR-HOSTVAR-1      TO HOSTVAR-ELEMENT-1         
              MOVE LM04-ERR-HOSTVAR-2      TO HOSTVAR-ELEMENT-2         
              MOVE LM04-ERR-HOSTVAR-3      TO HOSTVAR-ELEMENT-3         
              MOVE LM04-ERR-HOSTVAR-4      TO HOSTVAR-ELEMENT-4         
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * WRITE TRANSACTION HISTORY IN LMS TABLE.                        *        
      ******************************************************************        
       5000-WRITE-TRANS-HIST.                                           
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
            MOVE 'GISYSNC'                   TO 4J-APPL-PROGRAM-ID.     
            MOVE 16                          TO 4J-TRANS-COMMENTS-LEN.  
            MOVE 'GISSYNC REQUIRED'          TO 4J-TRANS-COMMENTS-TEXT. 
            PERFORM 5050-WRITE-TRAN-HIST-HDR    THRU 5050-EXIT.         
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
            MOVE PROGRAM-NAME                TO 4J-APPL-PROGRAM-ID.     
            IF I-OLD-CNT-TRFEE-OVR-CMT-TXT > SPACES                     
               MOVE I-OLD-CNT-TRFEE-OVR-CMT-LEN                         
                                             TO 4J-TRANS-COMMENTS-LEN   
               MOVE I-OLD-CNT-TRFEE-OVR-CMT-TXT                         
                                             TO 4J-TRANS-COMMENTS-TEXT  
               PERFORM 5050-WRITE-TRAN-HIST-HDR THRU 5050-EXIT          
            END-IF.                                                     
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
            MOVE PROGRAM-NAME                TO 4J-APPL-PROGRAM-ID.     
            IF WS-WMS-SO-NO-CMT-TX > SPACES                             
               MOVE WS-WMS-SO-NO-CMT-LN      TO 4J-TRANS-COMMENTS-LEN   
               MOVE WS-WMS-SO-NO-CMT-TX      TO 4J-TRANS-COMMENTS-TEXT  
            ELSE                                                        
               MOVE 15                       TO 4J-TRANS-COMMENTS-LEN   
               MOVE 'TRANSFER WIZARD'        TO 4J-TRANS-COMMENTS-TEXT  
            END-IF.                                                     
            PERFORM 5050-WRITE-TRAN-HIST-HDR    THRU 5050-EXIT.         
                                                                        
            PERFORM 5100-WRITE-FXTR-TRAN-HIST   THRU 5100-EXIT.         
                                                                        
            MOVE 4J-TRANS-HIST-SEQ-NO        TO 4S-TRANS-HIST-SEQ-NO.   
            IF WS-OLD-CNT-CD  = 'T'                                     
               PERFORM 5200-WRITE-CNTRCT-TRAN-HIST                      
                                                THRU 5200-EXIT          
            END-IF.                                                     
                                                                        
            IF WS-POLE-ACTION-CD = 'A'                                  
               MOVE 01                       TO WS-TAB-INDX             
               PERFORM 5300-WRITE-ATTCHMNT-TRAN-HIST  THRU 5300-EXIT    
                   UNTIL WS-TAB-INDX > WS-MAX-ENTRY-COUNT               
                         OR TAB-EQUIP-TYPE-CD-ATT(WS-TAB-INDX) = SPACES 
            END-IF.                                                     
                                                                        
       5000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE TRANSACTION HISTORY HEADER IN LMS TABLE.                 *        
      ******************************************************************        
       5050-WRITE-TRAN-HIST-HDR.                                        
                                                                        
            MOVE WS-CURRENT-DATE           TO 4J-TRANS-DATE.            
            MOVE +01                       TO 4S-DETAIL-SEQ-NO.         
            MOVE WS-FXTR-SEQ               TO 4J-EQUIP-SEQ.             
            MOVE WS-FXTR-EQ-TAG-NO         TO 4J-EQUIP-TAG-NO.          
            MOVE I-ACCOUNT-NO              TO 4J-ACCOUNT-NO.            
      ****  IF LENGTH OF PARM-REQUEST-NO = 6 THEN 'WMS' ELSE 'CIS'              
            MOVE 'CIS'                     TO 4J-SOURCE-APPL-CD.        
            MOVE I-REQUEST-NO              TO 4J-SOURCE-APPL-REQ-NO.    
            MOVE 0                         TO 4J-WMS-POINT-NO.          
            MOVE I-OLD-FX-INST-LOC-NO      TO 4J-INSTALL-LOC-NO.        
            MOVE I-OLD-FX-INST-PNT-NO      TO 4J-INSTALL-POINT-NO.      
            MOVE I-USER-ID                 TO 4J-LAST-UPDATE-USERID     
                                              4S-LAST-UPDATE-USERID.    
                                                                        
            PERFORM 6080-GET-CURR-TS-CPDLM2       THRU 6080-CPDLM2-EXIT.
            PERFORM 6025-INS-LMS-TRN-HST-CPDLM2   THRU 6025-CPDLM2-EXIT.
                                                                        
       5050-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 5100-WRITE-FXTR-TRAN-HIST.                                     *        
      ******************************************************************        
       5100-WRITE-FXTR-TRAN-HIST.                                       
                                                                        
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_RATE_PLAN_NO'       TO 4S-COLUMN-DESC.           
            MOVE 03                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-TAB-RATE-PLAN-NO       TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 03                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE I-FXTR-RATE               TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_RATE_ITEM_CD'       TO 4S-COLUMN-DESC.           
            MOVE 04                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-TAB-RATE-ITEM-CD       TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 04                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE I-FXTR-RATE-ITEM-CD       TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
       5100-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE CONTRACT TRANSACTION HISTORY IN LMS TABLE.               *        
      ******************************************************************        
       5200-WRITE-CNTRCT-TRAN-HIST.                                     
                                                                        
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_START_DT'         TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE I-OLD-CNT-ST-DATE         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_END_DT'           TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-OLD-CNT-TERM-DT        TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'ORIG_TERM_CHRG_AM'       TO 4S-COLUMN-DESC.           
            MOVE 08                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-ORIG-TERM-CHRG-NUM     TO WS-ORIG-TERM-CHRG-HST.    
            MOVE WS-ORIG-TERM-CHRG-HST     TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'ACTL_TERM_CHRG_AM'       TO 4S-COLUMN-DESC.           
            MOVE 08                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-TERM-CHRG-AMT-NUM      TO WS-TERM-CHRG-AMT-HST.     
            MOVE WS-TERM-CHRG-AMT-HST      TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED ACTUAL CHARGED DATE VALUES TO HISTORY TABLE              
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'ACTUAL_CHRG_DT'          TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-CURRENT-DATE           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT CLP NO CODE VALUES TO HISTORY TABLE             
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_CLP_NO'           TO 4S-COLUMN-DESC.           
ACT040      MOVE LENGTH OF WS-OLD-CNT-CLP-NO                            
ACT040                                     TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-OLD-CNT-CLP-NO         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
       5200-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.             *        
      ******************************************************************        
       5300-WRITE-ATTCHMNT-TRAN-HIST.                                   
                                                                        
            EVALUATE TAB-EQUIP-TYPE-CD-ATT(WS-TAB-INDX)                 
                WHEN 'P'                                                
                   IF WS-POLE-ACTION-CD = 'A'                           
                      PERFORM 5600-WRITE-POLE-TRAN-HIST THRU 5600-EXIT  
                   END-IF                                               
                WHEN 'N'                                                
                   PERFORM 5700-WRITE-NODE-TRAN-HIST    THRU 5700-EXIT  
            END-EVALUATE.                                               
                                                                        
            ADD 01                                   TO WS-TAB-INDX.    
                                                                        
       5300-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE POLE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.        *        
      ******************************************************************        
       5600-WRITE-POLE-TRAN-HIST.                                       
                                                                        
      * MOVING CHANGED EQUIP TAG NO VALUES TO HISTORY TABLE                     
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-EQUIP-TAG-NO-ATT(WS-TAB-INDX)                      
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-PLAN-NO VALUES TO HISTORY TABLE                     
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_PLAN_NO'       TO 4S-COLUMN-DESC.           
            MOVE 03                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-RATE-PLAN-NO-ATT(WS-TAB-INDX)                      
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-ITEM-CODE VALUES TO HISTORY TABLE                   
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_ITEM_CD '      TO 4S-COLUMN-DESC.           
            MOVE 04                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-RATE-ITEM-CODE-ATT(WS-TAB-INDX)                    
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED BILLING FLAG VALUES TO HISTORY TABLE                     
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_BILLING_FL'         TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-BILLING-FL-ATT(WS-TAB-INDX)                        
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED NO BILL REASON CD VALUES TO HISTORY TABLE                
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_NOBILL_RSN_CD'      TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-NO-BILL-REASON-CD-ATT(WS-TAB-INDX)                 
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
       5600-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE NODE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.        *        
      ******************************************************************        
       5700-WRITE-NODE-TRAN-HIST.                                       
                                                                        
      * MOVING CHANGED EQUIP TAG NO VALUES TO HISTORY TABLE                     
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'NODE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-EQUIP-TAG-NO-ATT(WS-TAB-INDX)                      
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
            ADD 01                         TO WS-TAB-INDX.              
                                                                        
       5700-EXIT.                                                       
             EXIT.                                                      
                                                                        
       5701-WRITE-TRANS-HIST-NEW.                                       
                                                                        
            MOVE 4J-TRANS-HIST-SEQ-NO       TO 4S-TRANS-HIST-SEQ-NO.    
                                                                        
            IF WS-NEW-CNT-CD  = 'Y'                                     
               PERFORM 5703-WRITE-CNTRCT-TRAN-HIST    THRU 5703-EXIT    
            ELSE                                                        
               MOVE WS-FXTR-SEQ             TO 4S-EQUIP-SEQ             
               MOVE 'NO_CONTRACT_RSN_CD'    TO 4S-COLUMN-DESC           
               MOVE LENGTH OF WS-NEW-CNT-NO-CN-RSN-CD                   
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
               MOVE WS-NEW-CNT-NO-CN-RSN-CD TO 4S-PRV-COLUMN-VALUE-TEXT 
               MOVE 07                      TO 4S-CHG-COLUMN-VALUE-LEN  
               MOVE '**NEW**'               TO 4S-CHG-COLUMN-VALUE-TEXT 
                                                                        
               PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU              
                                                  6050-CPDLM2-EXIT      
            END-IF.                                                     
                                                                        
            IF WS-POLE-ACTION-CD = 'A'                                  
               PERFORM 5705-WRITE-POLE-TRAN-HIST      THRU 5705-EXIT    
            END-IF.                                                     
                                                                        
       5701-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE CONTRACT TRANSACTION HISTORY IN LMS TABLE.               *        
      ******************************************************************        
       5703-WRITE-CNTRCT-TRAN-HIST.                                     
                                                                        
      * MOVING CHANGED CONTRACT START DATE VALUES TO HISTORY TABLE              
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_START_DT'         TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-NEW-CNT-STR-DT         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NEW**'                 TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT END DATE VALUES TO HISTORY TABLE                
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_END_DT'           TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-NEW-CNT-END-DT         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NEW**'                 TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT DURATION CD VALUES TO HISTORY TABLE             
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_DURATION_CD'      TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-NEW-CNT-DUR-CD         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NEW**'                 TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      *                                                                         
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'FIXTURE_COST_AM'         TO 4S-COLUMN-DESC.           
            MOVE 08                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE 4L-FIXTURE-COST-AM        TO WS-EQUIP-COST-AMOUNT.     
            MOVE WS-EQUIP-COST-AMOUNT      TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NEW**'                 TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      *                                                                         
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_COST_AM'            TO 4S-COLUMN-DESC.           
            MOVE 08                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE 4L-POLE-COST-AM           TO WS-EQUIP-COST-AMOUNT.     
            MOVE WS-EQUIP-COST-AMOUNT      TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NEW**'                 TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT CLP NO CODE VALUES TO HISTORY TABLE             
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_CLP_NO'           TO 4S-COLUMN-DESC.           
ACT040      MOVE LENGTH OF WS-NEW-CNT-CLP-NO                            
ACT040                                     TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-NEW-CNT-CLP-NO         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NEW**'                 TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT STATUS CD VALUES TO HISTORY TABLE               
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_STATUS_CD'        TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE 'A'                       TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 07                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NEW**'                 TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
       5703-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE POLE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.        *        
      ******************************************************************        
       5705-WRITE-POLE-TRAN-HIST.                                       
                                                                        
      * MOVING CHANGED EQUIP TAG NO VALUES TO HISTORY TABLE                     
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE I-NEW-POLE-TAG-NO         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**INSERTED**'            TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED STOCK CD VALUES TO HISTORY TABLE                         
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_STOCK_CD'           TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE I-NEW-POLE-STK-CD         TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**INSERTED**'            TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED POLE RATE VALUES TO HISTORY TABLE                        
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_PLAN_NO'       TO 4S-COLUMN-DESC.           
            MOVE 03                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE I-NEW-POLE-RATE           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**INSERTED**'            TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-ITEM-CODE VALUES TO HISTORY TABLE                   
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_ITEM_CD '      TO 4S-COLUMN-DESC.           
            MOVE 04                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE I-NEW-POLE-RATE-ITEM-CD   TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**INSERTED**'            TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED BILLING FLAG VALUES TO HISTORY TABLE                     
            MOVE WS-FXTR-SEQ               TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_BILLING_FL'         TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE 4F-BILLING-FL             TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**INSERTED**'            TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
       5705-EXIT.                                                       
             EXIT.                                                      
                                                                        
      *6000-LM04-SET-PEND-ACCOUNT                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM004                                                  
           END-EXEC.                                                            
                                                                        
      *6000-GET-ACCT-TYPE-CODE-CPD118                                           
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00118                                                 
           END-EXEC.                                                            
                                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 6001-ADJUST-CUST-PLAN-COUNT                                    *        
      ******************************************************************        
       6001-ADJUST-CUST-PLAN-COUNT.                                     
                                                                        
            MOVE WS-USER-ID                 TO LM001-USER-ID            
            MOVE PROGRAM-NAME               TO LM001-PROGRAM-NAME       
                                                                        
            PERFORM 6300-LM001-CUST-LIGHT-SYNC THRU 6300-LM001-EXIT.    
                                                                        
            IF LM001-ERROR                                              
               MOVE LM001-ERR-SQLCODE       TO WS-ACTIVE-RETURN-CODE    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE LM001-BUS-RULE-ID       TO S-RS1-BUS-RULE-ID        
               MOVE 'F'                     TO S-RS1-BUS-RULE-RESULT-CD 
               MOVE 'CPDLM001'              TO ABEND-PROGRAM            
               MOVE LM001-ERR-PARAGRAPH-NO  TO ACTIVE-PARAGRAPH         
               MOVE LM001-ERR-FUNCTION      TO ABEND-FUNCTION           
               MOVE LM001-ERR-TABLE1        TO TABLE-1                  
               MOVE LM001-ERR-TABLE2        TO TABLE-2                  
               MOVE LM001-ERR-COLUMN-1      TO TABLE-ELEMENT-1          
               MOVE LM001-ERR-COLUMN-2      TO TABLE-ELEMENT-2          
               MOVE LM001-ERR-COLUMN-3      TO TABLE-ELEMENT-3          
               MOVE LM001-ERR-COLUMN-4      TO TABLE-ELEMENT-4          
               MOVE LM001-ERR-HOSTVAR-1     TO HOSTVAR-ELEMENT-1        
               MOVE LM001-ERR-HOSTVAR-2     TO HOSTVAR-ELEMENT-2        
               MOVE LM001-ERR-HOSTVAR-3     TO HOSTVAR-ELEMENT-3        
               MOVE LM001-ERR-HOSTVAR-4     TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            END-IF.                                                     
                                                                        
       6001-EXIT.                                                       
            EXIT.                                                       
                                                                        
ACT028****************************************************************          
ACT028** 6002-INSERT-WORK-QUEUE.                                    **          
ACT028**  CALL SUB PROGRAM MCSCB077 FOR INSERTING WORK QUEUES INTO  **  28610000
ACT028**  CSS_WQ_ITEMS.                                             **  28620000
ACT028****************************************************************          
ACT028 6002-INSERT-WORK-QUEUE.                                          
ACT028                                                                  
ACT028     CALL MCSCB077  USING   CWS00077-FIELDS,                      
ACT028                            ABEND-FILE,                           
ACT028                            WS-MCSCB077-RET-CODE.                 
ACT028*                                                                         
ACT028     MOVE WS-MCSCB077-RET-CODE       TO WS-ACTIVE-RETURN-CODE.    
ACT028                                                                  
ACT028     IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
ACT028        MOVE 100                     TO S-APPL-RETURN-CODE        
ACT028        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
ACT028        MOVE '6002'                  TO ACTIVE-PARAGRAPH          
ACT028        MOVE 'CALL'                  TO ABEND-FUNCTION            
ACT028        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
ACT028                                         ABEND-TABLES             
ACT028        MOVE MCSCB077                TO TABLE-1                   
ACT028        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
ACT028     END-IF.                                                      
ACT028                                                                  
ACT028 6002-EXIT.                                                       
ACT028     EXIT.                                                        
      ******************************************************************        
      * 6003-CREATE-CONTRACT.                                          *        
      ******************************************************************        
       6003-CREATE-CONTRACT.                                            
                                                                        
            INITIALIZE WS-CONTRACT-HEADER-PARMS                         
                       WS-CONTRACT-DETAIL-PARMS                         
                       WS-CONTRACT-RETURN-INFO.                         
                                                                        
            SET  CONTRACT-INSERT          TO TRUE.                      
            SET  CALLED-FROM-ONLINE       TO TRUE.                      
            SET  LMS-CONTRACT             TO TRUE.                      
                                                                        
            MOVE WS-USER-ID               TO WS-4822-USER-ID.           
            MOVE WS-ACCOUNT-NO            TO WS-4822-ACCOUNT-NO.        
            MOVE 407                      TO WS-4822-CNT-NAME-CD.       
            MOVE PROGRAM-NAME             TO WS-4822-CNT-APPL-PGM-ID.   
            MOVE WS-TERM-CHRG-AMT-COMP    TO WS-4822-AMT-ORIG-ENTERED.  
            MOVE 'E'                      TO WS-4822-CODE-CONTRACT-TYPE.
                                                                        
            CALL MCSCB822 USING ABEND-FILE                              
                               ,WS-WARNING-DATA-ELEMENTS                
                               ,WS-CONTRACT-HEADER-PARMS                
                               ,WS-CONTRACT-DETAIL-PARMS                
                               ,WS-CONTRACT-OPERATION-TYPE              
                               ,WS-CONTRACT-RETURN-INFO.                
                                                                        
            IF CPD4822-DB2-ERR-FOUND                                    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            ELSE                                                        
               MOVE WS-4822-NEW-ITEM-ID     TO WS-LMS-CNTR-ITEM-ID      
            END-IF.                                                     
                                                                        
       6003-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 6300-LM001-CUST-LITE-SYNC.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDLM001                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7100-OPEN-ALL-EQU-ENV-CUR.                                     *        
      *                                                                *        
      ******************************************************************        
       7100-OPEN-ALL-EQU-ENV-CUR.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN ALL_EQU_ENVMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7100'               TO ACTIVE-PARAGRAPH            
               MOVE 'OPEN'               TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_EQUIP_ENVRNMT'  TO TABLE-1                     
               MOVE 'INSTALL_LOC_NO '    TO TABLE-ELEMENT-1             
               MOVE WS-OLD-FX-INST-LOC-NO                               
                                         TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7101-FETCH-ALL-EQU-ENV-CUR.                                    *        
      *                                                                *        
      ******************************************************************        
       7101-FETCH-ALL-EQU-ENV-CUR.                                      

MSQ008     MOVE 10 TO MSQ008-ALL-EQU-ENVMT
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-ALL-EQU-ENVMT
              FETCH 
              FROM ALL_EQU_ENVMT          
                INTO :TAB-INSTALL-POINT-NO                              
                    ,:TAB-EQUIP-SEQ                                     
                    ,:TAB-INSTALL-LOC-CD                                
                    ,:TAB-CODE-UTIL-TYPE                                
                    ,:TAB-IC-NO                                         
                    ,:TAB-RATE-PLAN-NO                                  
                    ,:TAB-RATE-ITEM-CODE                                
                    ,:TAB-ITEM-SEQ-NO                                   
                    ,:TAB-BILLING-FL                                    
                    ,:TAB-NO-BILL-REASON-CD                             
                    ,:TAB-EQUIP-CONTRACT-FL                             
                    ,:TAB-NO-CONTRACT-RSN-CD                            
                    ,:TAB-EQUIP-OWNER-CD                                
                    ,:TAB-EQUIP-DRAWING-ID                              
                    ,:TAB-EQUIP-GIS-GKEY                                
                    ,:TAB-SOURCE-APPL-CD                                
                    ,:TAB-SOURCE-APPL-REQ-NO                            
                    ,:TAB-WMS-POINT-NO                                  
                    ,:TAB-EQUIP-INSTALL-DT                              
                    ,:TAB-INSTALL-USERID                                
                    ,:TAB-APPROVED-TS :TAB-NULL-APPROVED-TS           
                    ,:TAB-APPROVER-USERID                               
                    ,:TAB-SPCL-AGR-COMMENTS                             
                    ,:TAB-EQUIP-COMMENTS                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM ALL_EQU_ENVMT FOR 10 ROWS                 
MFA-TR*         INTO :TAB-INSTALL-POINT-NO                                      
MFA-TR*             ,:TAB-EQUIP-SEQ                                             
MFA-TR*             ,:TAB-INSTALL-LOC-CD                                        
MFA-TR*             ,:TAB-CODE-UTIL-TYPE                                        
MFA-TR*             ,:TAB-IC-NO                                                 
MFA-TR*             ,:TAB-RATE-PLAN-NO                                          
MFA-TR*             ,:TAB-RATE-ITEM-CODE                                        
MFA-TR*             ,:TAB-ITEM-SEQ-NO                                           
MFA-TR*             ,:TAB-BILLING-FL                                            
MFA-TR*             ,:TAB-NO-BILL-REASON-CD                                     
MFA-TR*             ,:TAB-EQUIP-CONTRACT-FL                                     
MFA-TR*             ,:TAB-NO-CONTRACT-RSN-CD                                    
MFA-TR*             ,:TAB-EQUIP-OWNER-CD                                        
MFA-TR*             ,:TAB-EQUIP-DRAWING-ID                                      
MFA-TR*             ,:TAB-EQUIP-GIS-GKEY                                        
MFA-TR*             ,:TAB-SOURCE-APPL-CD                                        
MFA-TR*             ,:TAB-SOURCE-APPL-REQ-NO                                    
MFA-TR*             ,:TAB-WMS-POINT-NO                                          
MFA-TR*             ,:TAB-EQUIP-INSTALL-DT                                      
MFA-TR*             ,:TAB-INSTALL-USERID                                        
MFA-TR*             ,:TAB-APPROVED-TS   :TAB-NULL-APPROVED-TS                   
MFA-TR*             ,:TAB-APPROVER-USERID                                       
MFA-TR*             ,:TAB-SPCL-AGR-COMMENTS                                     
MFA-TR*             ,:TAB-EQUIP-COMMENTS                                        
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ALL-EQU-ENVMT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           MOVE SQLERRD(3)               TO WS-ENVRNMT-COUNT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                    AND WS-ENVRNMT-COUNT >  0                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7101'               TO ACTIVE-PARAGRAPH            
               MOVE 'FETCH'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_EQUIP_ENVRNMT'  TO TABLE-1                     
               MOVE 'INSTALL_LOC_NO '    TO TABLE-ELEMENT-1             
               MOVE WS-OLD-FX-INST-LOC-NO                               
                                         TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7102-CLOSE-ALL-EQU-ENV-CUR.                                    *        
      *                                                                *        
      ******************************************************************        
       7102-CLOSE-ALL-EQU-ENV-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE ALL_EQU_ENVMT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7102'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_EQUIP_ENVRNMT'  TO TABLE-1                     
               MOVE 'INSTALL_LOC_NO'     TO TABLE-ELEMENT-1             
               MOVE WS-OLD-FX-INST-LOC-NO                               
                                         TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7102-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-ALL-FIX-ATT-CUR.                                     *        
      *                                                                *        
      ******************************************************************        
       7200-OPEN-ALL-FIX-ATT-CUR.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN ALL_FXTR_ATMS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7200'               TO ACTIVE-PARAGRAPH            
               MOVE 'OPEN'               TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_FXTR_ATTACHMTS' TO TABLE-1                     
               MOVE 'FXTR_EQUIP_SEQ '    TO TABLE-ELEMENT-1             
               MOVE WS-FXTR-SEQ          TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7201-FETCH-ALL-FIX-ATT-CUR.                                    *        
      *                                                                *        
      ******************************************************************        
       7201-FETCH-ALL-FIX-ATT-CUR.                                      

MSQ008     MOVE 10 TO MSQ008-ALL-FXTR-ATMS
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-ALL-FXTR-ATMS
              FETCH 
              FROM ALL_FXTR_ATMS          
                INTO :TAB-ATTACH-EQUIP-SEQ-ATT                          
                    ,:TAB-EQUIP-TYPE-CD-ATT                             
                    ,:TAB-EQUIP-TAG-NO-ATT                              
                    ,:TAB-INSTALL-POINT-NO-ATT                          
                    ,:TAB-RATE-PLAN-NO-ATT                              
                    ,:TAB-RATE-ITEM-CODE-ATT                            
                    ,:TAB-BILLING-FL-ATT                                
                    ,:TAB-NO-BILL-REASON-CD-ATT                         
                    ,:TAB-ATTACH-EQUIP-DATE-ATT                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM ALL_FXTR_ATMS FOR 10 ROWS                 
MFA-TR*         INTO :TAB-ATTACH-EQUIP-SEQ-ATT                                  
MFA-TR*             ,:TAB-EQUIP-TYPE-CD-ATT                                     
MFA-TR*             ,:TAB-EQUIP-TAG-NO-ATT                                      
MFA-TR*             ,:TAB-INSTALL-POINT-NO-ATT                                  
MFA-TR*             ,:TAB-RATE-PLAN-NO-ATT                                      
MFA-TR*             ,:TAB-RATE-ITEM-CODE-ATT                                    
MFA-TR*             ,:TAB-BILLING-FL-ATT                                        
MFA-TR*             ,:TAB-NO-BILL-REASON-CD-ATT                                 
MFA-TR*             ,:TAB-ATTACH-EQUIP-DATE-ATT                                 
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ALL-FXTR-ATMS
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           MOVE SQLERRD(3)               TO WS-ATCHMNT-COUNT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                    AND WS-ATCHMNT-COUNT >  0                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7201'               TO ACTIVE-PARAGRAPH            
               MOVE 'FETCH'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_FXTR_ATTACHMTS' TO TABLE-1                     
               MOVE 'FXTR_EQUIP_SEQ '    TO TABLE-ELEMENT-1             
               MOVE WS-FXTR-SEQ          TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7202-CLOSE-ALL-FIX-ATT-CUR.                                    *        
      *                                                                *        
      ******************************************************************        
       7202-CLOSE-ALL-FIX-ATT-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE ALL_FXTR_ATMS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7202'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_FXTR_ATTACHMTS' TO TABLE-1                     
               MOVE 'FXTR_EQUIP_SEQ '    TO TABLE-ELEMENT-1             
               MOVE WS-FXTR-SEQ          TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7205-GET-CURRENT-DT-TM                                         *        
      ******************************************************************        
       7205-GET-CURRENT-DT-TM.                                          
                                                                        
           EXEC SQL                                                     
             SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-DATE  = CURRENT DATE                               
MFA-TR*         ,:WS-CURRENT-TS    = CURRENT TIMESTAMP                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7205'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'SYSIBM.SYSDUMMY1'       TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7210-GET-UT-REV-CLASS.                                         *        
      *                                                                *        
      ******************************************************************        
       7210-GET-UT-REV-CLASS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CODE_REVENUE_CLASS                                 
                INTO :WS-CODE-REV-CLASS                                 
                FROM CSS_UTIL_ENVRNMT                                   
               WHERE ACCOUNT_NO            = :WS-ACCOUNT-NO             
                 AND CODE_UTIL_TYPE        = :WS-TAB-CODE-UTIL-TYPE     
                 AND IC_NO                 = :WS-TAB-IC-NO              
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_REVENUE_CLASS                                         
MFA-TR*         INTO :WS-CODE-REV-CLASS                                         
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO            = :WS-ACCOUNT-NO                     
MFA-TR*          AND CODE_UTIL_TYPE        = :WS-TAB-CODE-UTIL-TYPE             
MFA-TR*          AND IC_NO                 = :WS-TAB-IC-NO                      
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES                TO WS-CODE-REV-CLASS        
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE WS-TAB-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2        
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE WS-TAB-IC-NO             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7400-ADD-POLES-NEW-FX-ATT                                      *        
      ******************************************************************        
       7400-ADD-POLES-NEW-FX-ATT.                                       
                                                                        
           EXEC SQL                                                     
             INSERT INTO LMS_FXTR_ATTACHMTS                             
                 ( FXTR_EQUIP_SEQ                                       
                  ,ATTACH_SEQ_NO                                        
                  ,EQUIP_TYPE_CD                                        
                  ,ATTACH_EQUIP_SEQ                                     
                  ,ATTACH_EQUIP_DT                                      
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS)                                      
             VALUES                                                     
                 ( :WS-FXTR-SEQ                                         
                  ,1                                                    
                  ,'P'                                                  
                  ,:WS-NEW-EQUIP-SEQ                                    
                  ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
                  ,:WS-USER-ID                                          
                  ,CIS.CURRENT$TIMESTAMP())                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO LMS_FXTR_ATTACHMTS                                     
MFA-TR*          ( FXTR_EQUIP_SEQ                                               
MFA-TR*           ,ATTACH_SEQ_NO                                                
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,ATTACH_EQUIP_SEQ                                             
MFA-TR*           ,ATTACH_EQUIP_DT                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS)                                              
MFA-TR*      VALUES                                                             
MFA-TR*          ( :WS-FXTR-SEQ                                                 
MFA-TR*           ,1                                                            
MFA-TR*           ,'P'                                                          
MFA-TR*           ,:WS-NEW-EQUIP-SEQ                                            
MFA-TR*           ,CURRENT DATE                                                 
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*           ,CURRENT TIMESTAMP)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ'         TO TABLE-ELEMENT-1          
              MOVE WS-FXTR-SEQ              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7410-GET-MSTR-STK-INFO                                         *        
      ******************************************************************        
       7410-GET-MSTR-STK-INFO.                                          
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) [4A].COMPANY_NO,
              [4A].CODE_SERVICE_TYPE,
              [4A].EQUIPMENT_COST_AM                                
               INTO :4A-COMPANY-NO                                      
                   ,:4A-CODE-SERVICE-TYPE                               
                   ,:4A-EQUIPMENT-COST-AM                               
               FROM LMS_MSTR_STCK_INFO  [4A] WITH(READUNCOMMITTED)              
              WHERE [4A].STOCK_CD       = :4A-STOCK-CD                    
                AND [4A].EQUIP_TYPE_CD  = :4A-EQUIP-TYPE-CD               
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 4A.COMPANY_NO                                               
MFA-TR*            ,4A.CODE_SERVICE_TYPE                                        
MFA-TR*            ,4A.EQUIPMENT_COST_AM                                        
MFA-TR*        INTO :4A-COMPANY-NO                                              
MFA-TR*            ,:4A-CODE-SERVICE-TYPE                                       
MFA-TR*            ,:4A-EQUIPMENT-COST-AM                                       
MFA-TR*        FROM LMS_MSTR_STCK_INFO  4A                                      
MFA-TR*       WHERE 4A.STOCK_CD       = :4A-STOCK-CD                            
MFA-TR*         AND 4A.EQUIP_TYPE_CD  = :4A-EQUIP-TYPE-CD                       
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*     QUERYNO 7410                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 0                     TO 4A-EQUIPMENT-COST-AM     
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7410'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_MSTR_STCK_INFO'     TO TABLE-1                  
              MOVE 'STOCK_CD'               TO TABLE-ELEMENT-1          
              MOVE WS-NEW-POLE-STK-CD       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7411-GET-EQUIPMENT-COST.                                       *        
      ******************************************************************        
       7411-GET-EQUIPMENT-COST.                                         
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) [4A].EQUIPMENT_COST_AM                               
               INTO :4A-EQUIPMENT-COST-AM                               
               FROM  LMS_EQUIP_INVENTRY   [4D] WITH(READUNCOMMITTED)            
                    ,LMS_MSTR_STCK_INFO   [4A] WITH(READUNCOMMITTED)            
              WHERE  [4D].EQUIP_SEQ      = :4D-EQUIP-SEQ                  
                AND  [4D].STOCK_CD       =  [4A].STOCK_CD                   
                AND  [4D].EQUIP_TYPE_CD  =  [4A].EQUIP_TYPE_CD              
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  4A.EQUIPMENT_COST_AM                                       
MFA-TR*        INTO :4A-EQUIPMENT-COST-AM                                       
MFA-TR*        FROM  LMS_EQUIP_INVENTRY   4D                                    
MFA-TR*             ,LMS_MSTR_STCK_INFO   4A                                    
MFA-TR*       WHERE  4D.EQUIP_SEQ      = :4D-EQUIP-SEQ                          
MFA-TR*         AND  4D.STOCK_CD       =  4A.STOCK_CD                           
MFA-TR*         AND  4D.EQUIP_TYPE_CD  =  4A.EQUIP_TYPE_CD                      
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*     QUERYNO 7411                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 0                     TO 4A-EQUIPMENT-COST-AM     
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7411'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_MSTR_STCK_INFO'     TO TABLE-1                  
              MOVE 'STOCK_CD'               TO TABLE-ELEMENT-1          
              MOVE WS-NEW-POLE-STK-CD       TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7411-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7412-GET-NEW-EQUIP-SEQ                                         *        
      ******************************************************************        
       7412-GET-NEW-EQUIP-SEQ.                                          
                                                                        
           EXEC SQL                                                     
             SELECT
              NEXT VALUE FOR SEQ_ID_EQUIP_SEQ
            INTO
              :WS-NEW-EQUIP-SEQ                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-NEW-EQUIP-SEQ =                                            
MFA-TR*             NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7412'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'SYSIBM.SYSDUMMY1'       TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7412-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7415-ADD-NEW-POLE-EQ-INV                                       *        
      ******************************************************************        
       7415-ADD-NEW-POLE-EQ-INV.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_INVENTRY                            
                 (                                                      
                   EQUIP_SEQ                                            
                  ,EQUIP_TAG_NO                                         
                  ,COMPANY_NO                                           
                  ,CODE_SERVICE_TYPE                                    
                  ,STOCK_CD                                             
                  ,EQUIP_TYPE_CD                                        
                  ,EQUIP_MFR_CD                                         
                  ,EQUIP_MFR_DT                                         
                  ,WARRANTY_EXP_DT                                      
                  ,EQUIP_DISPOSAL_DT                                    
                  ,STORAGE_FAC_CD                                       
                  ,IN_TRANSIT_USERID                                    
                  ,INVENTRY_STATUS_CD                                   
                  ,WRNTY_RECEIVED_FL                                    
                  ,WRNTY_RECOUP_AMT                                     
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :WS-NEW-EQUIP-SEQ                                    
                  ,:I-NEW-POLE-TAG-NO                                   
                  ,:4A-COMPANY-NO                                       
                  ,:4A-CODE-SERVICE-TYPE                                
                  ,:I-NEW-POLE-STK-CD                                   
                  ,:WS-POLE                                             
                  ,' '                                                  
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-MFR-DT 
                                         :WS-NULL-EQUIP-MFR-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-MFR-DT 
                                                  :WS-NULL-EQUIP-MFR-DT
              ) <> 0) OR (LEN(:4D-EQUIP-MFR-DT :WS-NULL-EQUIP-MFR-DT
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-MFR-DT 
                                                  :WS-NULL-EQUIP-MFR-DT
              ), CONVERT(DATE, :4D-EQUIP-MFR-DT :WS-NULL-EQUIP-MFR-DT
              ) )          
                  ,IIF(TRY_CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                         :WS-NULL-WARR-EXP-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-WARRANTY-EXP-DT 
                                                   :WS-NULL-WARR-EXP-DT
              ) <> 0) OR (LEN(:4D-WARRANTY-EXP-DT :WS-NULL-WARR-EXP-DT
              ) <> 10), CIS.CHAR2DATE(:4D-WARRANTY-EXP-DT 
                                                   :WS-NULL-WARR-EXP-DT
              ), CONVERT(DATE, :4D-WARRANTY-EXP-DT :WS-NULL-WARR-EXP-DT
              ) )           
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                         :WS-NULL-EQUIP-DISP-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ) <> 0) OR (LEN(:4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ), CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ) )         
                  ,' '                                                  
                  ,' '                                                  
                  ,'J'                                                  
                  ,' '                                                  
                  ,0                                                    
                  ,:WS-USER-ID                                          
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_INVENTRY                                    
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ                                                    
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,STOCK_CD                                                     
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,EQUIP_MFR_CD                                                 
MFA-TR*           ,EQUIP_MFR_DT                                                 
MFA-TR*           ,WARRANTY_EXP_DT                                              
MFA-TR*           ,EQUIP_DISPOSAL_DT                                            
MFA-TR*           ,STORAGE_FAC_CD                                               
MFA-TR*           ,IN_TRANSIT_USERID                                            
MFA-TR*           ,INVENTRY_STATUS_CD                                           
MFA-TR*           ,WRNTY_RECEIVED_FL                                            
MFA-TR*           ,WRNTY_RECOUP_AMT                                             
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :WS-NEW-EQUIP-SEQ                                            
MFA-TR*           ,:I-NEW-POLE-TAG-NO                                           
MFA-TR*           ,:4A-COMPANY-NO                                               
MFA-TR*           ,:4A-CODE-SERVICE-TYPE                                        
MFA-TR*           ,:I-NEW-POLE-STK-CD                                           
MFA-TR*           ,:WS-POLE                                                     
MFA-TR*           ,' '                                                          
MFA-TR*           ,:4D-EQUIP-MFR-DT      :WS-NULL-EQUIP-MFR-DT                  
MFA-TR*           ,:4D-WARRANTY-EXP-DT   :WS-NULL-WARR-EXP-DT                   
MFA-TR*           ,:4D-EQUIP-DISPOSAL-DT :WS-NULL-EQUIP-DISP-DT                 
MFA-TR*           ,' '                                                          
MFA-TR*           ,' '                                                          
MFA-TR*           ,'J'                                                          
MFA-TR*           ,' '                                                          
MFA-TR*           ,0                                                            
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '7415'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_INVENTRY'     TO  TABLE-1                 
              MOVE 'EQUIP_SEQ'              TO  TABLE-ELEMENT-1         
              MOVE WS-NEW-EQUIP-SEQ         TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
        7415-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7418-GET-NXT-4F-INS-POINT.                                     *        
      ******************************************************************        
       7418-GET-NXT-4F-INS-POINT.                                       
                                                                        
           EXEC SQL                                                     
             SELECT  MAX(INSTALL_POINT_NO) + 1                          
               INTO :WS-MAX-4F-INS-POINT-NO :WS-NULL-MAX-INS-POINT      
               FROM  LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                    
              WHERE  INSTALL_LOC_NO = :WS-4F-INST-LOC-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  MAX(INSTALL_POINT_NO) + 1                                  
MFA-TR*        INTO :WS-MAX-4F-INS-POINT-NO :WS-NULL-MAX-INS-POINT              
MFA-TR*        FROM  LMS_EQUIP_ENVRNMT                                          
MFA-TR*       WHERE  INSTALL_LOC_NO = :WS-4F-INST-LOC-NO                        
MFA-TR*       WITH UR                                                           
MFA-TR*     QUERYNO 7418                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-MAX-INS-POINT < 0                              
                 MOVE +1                    TO WS-MAX-4F-INS-POINT-NO   
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '7418'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'SELECT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_ENVRNMT'      TO  TABLE-1                 
              MOVE 'INSTALL_LOC_NO'         TO  TABLE-ELEMENT-1         
              MOVE WS-4F-INST-LOC-NO        TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7418-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7420-ADD-NEW-POLE-EQ-ENV                                       *        
      ******************************************************************        
       7420-ADD-NEW-POLE-EQ-ENV.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_ENVRNMT                             
                 (                                                      
                   INSTALL_LOC_NO                                       
                  ,INSTALL_POINT_NO                                     
                  ,EQUIP_SEQ                                            
                  ,INSTALL_LOC_CD                                       
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,BILLING_FL                                           
                  ,NO_BILL_REASON_CD                                    
                  ,EQUIP_CONTRACT_FL                                    
                  ,NO_CONTRACT_RSN_CD                                   
                  ,EQUIP_OWNER_CD                                       
                  ,EQUIP_DRAWING_ID                                     
                  ,EQUIP_GIS_GKEY                                       
                  ,SOURCE_APPL_CD                                       
                  ,SOURCE_APPL_REQ_NO                                   
                  ,WMS_POINT_NO                                         
                  ,EQUIP_INSTALL_DT                                     
                  ,INSTALL_USERID                                       
                  ,APPROVED_TS                                          
                  ,APPROVER_USERID                                      
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,SPCL_AGR_COMMENTS                                    
                  ,EQUIP_COMMENTS                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :WS-NEW-FX-INST-LOC-NO                               
                  ,:WS-MAX-4F-INS-POINT-NO                              
                  ,:WS-NEW-EQUIP-SEQ                                    
                  ,:WS-POLE                                             
                  ,:4F-CODE-UTIL-TYPE                                   
                  ,0                                                    
                  ,:I-NEW-POLE-RATE                                     
                  ,:I-NEW-POLE-RATE-ITEM-CD                             
                  ,0                                                    
                  ,:4F-BILLING-FL                                       
                  ,' '                                                  
                  ,'N'                                                  
                  ,'  '                                                 
                  ,' '                                                  
                  ,' '                                                  
                  ,0                                                    
                  ,'CIS'                                                
                  ,:WS-REQUEST-NO                                       
                  ,0                                                    
                  ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
                  ,:WS-USER-ID                                          
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:WS-USER-ID                                          
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:WS-USER-ID                                          
                  ,' '                                                  
                  ,' '                                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_ENVRNMT                                     
MFA-TR*          (                                                              
MFA-TR*            INSTALL_LOC_NO                                               
MFA-TR*           ,INSTALL_POINT_NO                                             
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,INSTALL_LOC_CD                                               
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,BILLING_FL                                                   
MFA-TR*           ,NO_BILL_REASON_CD                                            
MFA-TR*           ,EQUIP_CONTRACT_FL                                            
MFA-TR*           ,NO_CONTRACT_RSN_CD                                           
MFA-TR*           ,EQUIP_OWNER_CD                                               
MFA-TR*           ,EQUIP_DRAWING_ID                                             
MFA-TR*           ,EQUIP_GIS_GKEY                                               
MFA-TR*           ,SOURCE_APPL_CD                                               
MFA-TR*           ,SOURCE_APPL_REQ_NO                                           
MFA-TR*           ,WMS_POINT_NO                                                 
MFA-TR*           ,EQUIP_INSTALL_DT                                             
MFA-TR*           ,INSTALL_USERID                                               
MFA-TR*           ,APPROVED_TS                                                  
MFA-TR*           ,APPROVER_USERID                                              
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,SPCL_AGR_COMMENTS                                            
MFA-TR*           ,EQUIP_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :WS-NEW-FX-INST-LOC-NO                                       
MFA-TR*           ,:WS-MAX-4F-INS-POINT-NO                                      
MFA-TR*           ,:WS-NEW-EQUIP-SEQ                                            
MFA-TR*           ,:WS-POLE                                                     
MFA-TR*           ,:4F-CODE-UTIL-TYPE                                           
MFA-TR*           ,0                                                            
MFA-TR*           ,:I-NEW-POLE-RATE                                             
MFA-TR*           ,:I-NEW-POLE-RATE-ITEM-CD                                     
MFA-TR*           ,0                                                            
MFA-TR*           ,:4F-BILLING-FL                                               
MFA-TR*           ,' '                                                          
MFA-TR*           ,'N'                                                          
MFA-TR*           ,'  '                                                         
MFA-TR*           ,' '                                                          
MFA-TR*           ,' '                                                          
MFA-TR*           ,0                                                            
MFA-TR*           ,'CIS'                                                        
MFA-TR*           ,:WS-REQUEST-NO                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,CURRENT DATE                                                 
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*           ,' '                                                          
MFA-TR*           ,' '                                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '7420'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_ENVRNMT'      TO  TABLE-1                 
              MOVE 'INSTALL_LOC_NO'         TO  TABLE-ELEMENT-1         
              MOVE 'INSTALL_POINT_NO'       TO  TABLE-ELEMENT-2         
              MOVE 'EQUIP_SEQ'              TO  TABLE-ELEMENT-3         
              MOVE WS-OLD-FX-INST-LOC-NO    TO  HOSTVAR-ELEMENT-1       
              MOVE WS-MAX-4F-INS-POINT-NO   TO  HOSTVAR-ELEMENT-2       
              MOVE WS-NEW-EQUIP-SEQ         TO  HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        7420-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7510-INS-NEW-EQ-CNT                                            *        
      ******************************************************************        
       7510-INS-NEW-EQ-CNT.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_CONTRACT                            
                 (                                                      
                   ACCOUNT_NO                                           
                  ,EQUIP_SEQ                                            
                  ,CNTRCT_START_DT                                      
                  ,INSTALL_LOC_NO                                       
                  ,CNTRCT_END_DT                                        
                  ,CNTRCT_DURATION_CD                                   
                  ,FIXTURE_COST_AM                                      
                  ,POLE_COST_AM                                         
                  ,ORIG_TERM_CHRG_AM                                    
                  ,ACTL_TERM_CHRG_AM                                    
                  ,ACTL_CHRG_DT                                         
                  ,CNTRCT_CLP_NO                                        
                  ,CNTRCT_STATUS_CD                                     
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :WS-TRAN-TO-ACCT-NO                                  
                  ,:WS-FXTR-SEQ                                         
                  ,IIF(TRY_CONVERT(DATE, :WS-NEW-CNT-STR-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNT-STR-DT
              ) <> 0) OR (LEN(:WS-NEW-CNT-STR-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNT-STR-DT
              ), CONVERT(DATE, :WS-NEW-CNT-STR-DT) )                           
                  ,:WS-NEW-FX-INST-LOC-NO                               
                  ,IIF(TRY_CONVERT(DATE, :WS-NEW-CNT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNT-END-DT
              ) <> 0) OR (LEN(:WS-NEW-CNT-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNT-END-DT
              ), CONVERT(DATE, :WS-NEW-CNT-END-DT) )                           
                  ,:WS-NEW-CNT-DUR-CD                                   
                  ,:4L-FIXTURE-COST-AM                                  
                  ,:4L-POLE-COST-AM                                     
                  ,0                                                    
                  ,0                                                    
                  ,IIF(TRY_CONVERT(DATE, :4L-ACTL-CHRG-DT 
                                         :WS-NULL-ACTL-CHRG-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-ACTL-CHRG-DT 
                                                  :WS-NULL-ACTL-CHRG-DT
              ) <> 0) OR (LEN(:4L-ACTL-CHRG-DT :WS-NULL-ACTL-CHRG-DT
              ) <> 10), CIS.CHAR2DATE(:4L-ACTL-CHRG-DT 
                                                  :WS-NULL-ACTL-CHRG-DT
              ), CONVERT(DATE, :4L-ACTL-CHRG-DT :WS-NULL-ACTL-CHRG-DT
              ) )               
                  ,:WS-NEW-CNT-CLP-NO                                   
                  ,'A'                                                  
                  ,:WS-USER-ID                                          
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_CONTRACT                                    
MFA-TR*          (                                                              
MFA-TR*            ACCOUNT_NO                                                   
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,INSTALL_LOC_NO                                               
MFA-TR*           ,CNTRCT_END_DT                                                
MFA-TR*           ,CNTRCT_DURATION_CD                                           
MFA-TR*           ,FIXTURE_COST_AM                                              
MFA-TR*           ,POLE_COST_AM                                                 
MFA-TR*           ,ORIG_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_CHRG_DT                                                 
MFA-TR*           ,CNTRCT_CLP_NO                                                
MFA-TR*           ,CNTRCT_STATUS_CD                                             
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :WS-TRAN-TO-ACCT-NO                                          
MFA-TR*           ,:WS-FXTR-SEQ                                                 
MFA-TR*           ,:WS-NEW-CNT-STR-DT                                           
MFA-TR*           ,:WS-NEW-FX-INST-LOC-NO                                       
MFA-TR*           ,:WS-NEW-CNT-END-DT                                           
MFA-TR*           ,:WS-NEW-CNT-DUR-CD                                           
MFA-TR*           ,:4L-FIXTURE-COST-AM                                          
MFA-TR*           ,:4L-POLE-COST-AM                                             
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,:4L-ACTL-CHRG-DT :WS-NULL-ACTL-CHRG-DT                       
MFA-TR*           ,:WS-NEW-CNT-CLP-NO                                           
MFA-TR*           ,'A'                                                          
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '7510'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_CONTRACT'     TO  TABLE-1                 
              MOVE 'PREMISE_NO'             TO  TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-2         
              MOVE 'CNTRCT_START_DT'        TO  TABLE-ELEMENT-3         
              MOVE WS-OLD-FX-INST-LOC-NO    TO  HOSTVAR-ELEMENT-1       
              MOVE WS-TRAN-TO-ACCT-NO       TO  HOSTVAR-ELEMENT-2       
              MOVE WS-NEW-CNT-STR-DT        TO  HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        7510-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 7515-UPD-OLD-EQ-CNT                                           *         
      *****************************************************************         
       7515-UPD-OLD-EQ-CNT.                                             
      *                                                                         
            EXEC SQL                                                    
                UPDATE LMS_EQUIP_CONTRACT                               
                   SET ACTL_TERM_CHRG_AM  = :4L-ACTL-TERM-CHRG-AM       
                      ,ORIG_TERM_CHRG_AM  = :4L-ORIG-TERM-CHRG-AM       
                      ,CNTRCT_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                    :WS-OLD-CNT-TERM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-CNT-TERM-DT
              ) <> 0) OR (LEN(:WS-OLD-CNT-TERM-DT
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-CNT-TERM-DT
              ), CONVERT(DATE, :WS-OLD-CNT-TERM-DT) )         
                      ,CNTRCT_STATUS_CD   = 'T'                         
                      ,ACTL_CHRG_DT       = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
                      ,LAST_UPDATE_USERID = :WS-USER-ID                 
                 WHERE EQUIP_SEQ          = :WS-FXTR-SEQ                
                   AND INSTALL_LOC_NO     = :WS-OLD-FX-INST-LOC-NO      
                   AND CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :WS-OLD-CNT-ST-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-CNT-ST-DATE
              ) <> 0) OR (LEN(:WS-OLD-CNT-ST-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-CNT-ST-DATE
              ), CONVERT(DATE, :WS-OLD-CNT-ST-DATE) )         
                   AND ACCOUNT_NO         = :WS-ACCOUNT-NO              
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE LMS_EQUIP_CONTRACT                                       
MFA-TR*            SET ACTL_TERM_CHRG_AM  = :4L-ACTL-TERM-CHRG-AM               
MFA-TR*               ,ORIG_TERM_CHRG_AM  = :4L-ORIG-TERM-CHRG-AM               
MFA-TR*               ,CNTRCT_END_DT      = :WS-OLD-CNT-TERM-DT                 
MFA-TR*               ,CNTRCT_STATUS_CD   = 'T'                                 
MFA-TR*               ,ACTL_CHRG_DT       = CURRENT DATE                        
MFA-TR*               ,LAST_UPDATE_USERID = :WS-USER-ID                         
MFA-TR*          WHERE EQUIP_SEQ          = :WS-FXTR-SEQ                        
MFA-TR*            AND INSTALL_LOC_NO     = :WS-OLD-FX-INST-LOC-NO              
MFA-TR*            AND CNTRCT_START_DT    = :WS-OLD-CNT-ST-DATE                 
MFA-TR*            AND ACCOUNT_NO         = :WS-ACCOUNT-NO                      
MFA-TR*        QUERYNO 7515                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7515'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_CONTRACT'    TO TABLE-1                  
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-1          
               MOVE 'INSTALL_POINT_NO'      TO TABLE-ELEMENT-2          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3          
               MOVE WS-OLD-FX-INST-LOC-NO   TO HOSTVAR-ELEMENT-1        
               MOVE WS-OLD-FX-INST-PNT-NO   TO HOSTVAR-ELEMENT-2        
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7515-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS1-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)               
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS1-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE      1R                                       
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS1-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT026******************************************************************        
ACT026** GET CODE UTIL TYPE USING RATE PLAN                           **        
ACT026******************************************************************        
ACT026*                                                                         
ACT026 7560-GET-CODE-UTIL-TYPE.                                         
ACT026*                                                                         
ACT026     EXEC SQL                                                     
ACT026        SELECT TOP(1) RD.CODE_UTIL_TYPE                                 
ACT026          INTO :RD-CODE-UTIL-TYPE                                 
ACT026          FROM  CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)              
ACT026        WHERE  RD.RATE_PLAN_NO  = :RD-RATE-PLAN-NO                
A17062           AND RD.LMS_RATE_FL   = 'Y'                             
A17062           AND RD.COMPANY_NO    = '01'                            
ACT026                                       
ACT026                                                      
ACT026     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  RD.CODE_UTIL_TYPE                                         
MFA-TR*         INTO :RD-CODE-UTIL-TYPE                                         
MFA-TR*         FROM  CSS_RATE_PLAN_DESC  RD                                    
MFA-TR*       WHERE  RD.RATE_PLAN_NO  = :RD-RATE-PLAN-NO                        
MFA-TR*          AND RD.LMS_RATE_FL   = 'Y'                                     
MFA-TR*          AND RD.COMPANY_NO    = '01'                                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*      QUERYNO 7560                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT026*                                                                         
ACT026     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT026*                                                                         
ACT026     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT026        CONTINUE                                                  
ACT026     ELSE                                                         
ACT026         MOVE SPACES                  TO ABEND-TABLES             
ACT026         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
ACT026         MOVE '7560'                  TO ACTIVE-PARAGRAPH         
ACT026         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
ACT026         MOVE 'SELECT'                TO ABEND-FUNCTION           
ACT026         MOVE 'CSS_RATE_PLAN_DESC'    TO TABLE-1                  
ACT026         MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-1          
ACT026         MOVE RD-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-1        
ACT026         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
ACT026     END-IF.                                                      
ACT026*                                                                         
ACT026 7560-EXIT.                                                       
ACT026     EXIT.                                                        
ACT026*                                                                         
ACT028******************************************************************        
ACT028* 7570-CHECK-ACTIVE-CUST-PLAN.                                   *        
ACT028******************************************************************        
ACT028 7570-CHECK-ACTIVE-CUST-PLAN.                                     
ACT028                                                                  
ACT028     EXEC SQL                                                     
ACT028         SELECT  COUNT(*)                                         
ACT028           INTO :WS-ACT-CUST-PLAN-CNT                             
ACT028           FROM  CSS_CUST_PLAN      CP WITH(READUNCOMMITTED)              
ACT028          WHERE  CP.ACCOUNT_NO       = :WS-ACCOUNT-NO             
ACT028            AND  CP.CODE_PLAN_STATUS = 'A'                        
ACT028                                                           
ACT028     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COUNT(*)                                                 
MFA-TR*          INTO :WS-ACT-CUST-PLAN-CNT                                     
MFA-TR*          FROM  CSS_CUST_PLAN      CP                                    
MFA-TR*         WHERE  CP.ACCOUNT_NO       = :WS-ACCOUNT-NO                     
MFA-TR*           AND  CP.CODE_PLAN_STATUS = 'A'                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT028                                                                  
ACT028     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
ACT028                                                                  
ACT028     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT028         NEXT SENTENCE                                            
ACT028     ELSE                                                         
ACT028         MOVE SQLCODE              TO ABEND-SQLCODE               
ACT028         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
ACT028         MOVE '7570'               TO ACTIVE-PARAGRAPH            
ACT028         MOVE 'SELECT'             TO ABEND-FUNCTION              
ACT028         MOVE SPACES               TO ABEND-SQL-PREDICATES        
ACT028                                      ABEND-TABLES                
ACT028         MOVE 'CSS_CUST_PLAN'      TO TABLE-1                     
ACT028         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
ACT028         MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
ACT028         PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
ACT028     END-IF.                                                      
ACT028                                                                  
ACT028 7570-EXIT.                                                       
ACT028     EXIT.                                                        
ACT028                                                                  
ACT028******************************************************************        
ACT028* 7580-CHECK-ACTIVE-METER-ENV.                                   *        
ACT028******************************************************************        
ACT028 7580-CHECK-ACTIVE-METER-ENV.                                     
ACT028                                                                  
ACT028     EXEC SQL                                                     
ACT028         SELECT  COUNT(*)                                         
ACT028           INTO :WS-ACT-METER-ENV-CNT                             
ACT028           FROM  CSS_MTRD_ENVRNMT     MN WITH(READUNCOMMITTED)            
ACT028          WHERE  MN.ACCOUNT_NO         = :WS-ACCOUNT-NO           
ACT028            AND  MN.CODE_METER_STATUS <> 'K'                      
ACT028                                                           
ACT028     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COUNT(*)                                                 
MFA-TR*          INTO :WS-ACT-METER-ENV-CNT                                     
MFA-TR*          FROM  CSS_MTRD_ENVRNMT     MN                                  
MFA-TR*         WHERE  MN.ACCOUNT_NO         = :WS-ACCOUNT-NO                   
MFA-TR*           AND  MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT028                                                                  
ACT028     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
ACT028                                                                  
ACT028     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT028         NEXT SENTENCE                                            
ACT028     ELSE                                                         
ACT028         MOVE SQLCODE              TO ABEND-SQLCODE               
ACT028         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
ACT028         MOVE '7580'               TO ACTIVE-PARAGRAPH            
ACT028         MOVE 'SELECT'             TO ABEND-FUNCTION              
ACT028         MOVE SPACES               TO ABEND-SQL-PREDICATES        
ACT028                                      ABEND-TABLES                
ACT028         MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                     
ACT028         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
ACT028         MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
ACT028         PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
ACT028     END-IF.                                                      
ACT028                                                                  
ACT028 7580-EXIT.                                                       
ACT028     EXIT.                                                        
ACT028                                                                  
ACT028******************************************************************        
ACT028* 7590-GET-ACCOUNT-STATUS.                                       *        
ACT028******************************************************************        
ACT028 7590-GET-ACCOUNT-STATUS.                                         
ACT028                                                                  
ACT028     EXEC SQL                                                     
ACT028         SELECT  CODE_ACCT_STAT                                   
ACT028           INTO :AT-CODE-ACCT-STAT                                
ACT028           FROM  CSS_ACCOUNT        AT WITH(READUNCOMMITTED)              
ACT028          WHERE  AT.ACCOUNT_NO         = :WS-ACCOUNT-NO           
ACT028                                                           
ACT028     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_ACCT_STAT                                           
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*          FROM  CSS_ACCOUNT        AT                                    
MFA-TR*         WHERE  AT.ACCOUNT_NO         = :WS-ACCOUNT-NO                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT028                                                                  
ACT028     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
ACT028                                                                  
ACT028     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT028         CONTINUE                                                 
ACT028     ELSE                                                         
ACT028         MOVE SQLCODE              TO ABEND-SQLCODE               
ACT028         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
ACT028         MOVE '7590'               TO ACTIVE-PARAGRAPH            
ACT028         MOVE 'SELECT'             TO ABEND-FUNCTION              
ACT028         MOVE SPACES               TO ABEND-SQL-PREDICATES        
ACT028                                      ABEND-TABLES                
ACT028         MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
ACT028         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
ACT028         MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
ACT028         PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
ACT028     END-IF.                                                      
ACT028                                                                  
ACT028 7590-EXIT.                                                       
ACT028     EXIT.                                                        
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS.                                        *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04776_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04776_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSR04776_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8102-DEL-OLD-FX-ATTCH                                         *         
      *****************************************************************         
       8102-DEL-OLD-FX-ATTCH.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM LMS_FXTR_ATTACHMTS                          
                 WHERE FXTR_EQUIP_SEQ   = :WS-FXTR-SEQ                  
ACT073           AND   ATTACH_EQUIP_SEQ = :4D-EQUIP-SEQ                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8102'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_FXTR_ATTACHMTS'    TO TABLE-1                  
               MOVE 'FXTR_EQUIP_SEQ'        TO TABLE-ELEMENT-1          
               MOVE WS-FXTR-SEQ             TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8102-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8104-DEL-OLD-POLE-EQ-INV                                      *         
      *****************************************************************         
       8104-DEL-OLD-POLE-EQ-INV.                                        
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM LMS_EQUIP_INVENTRY                          
                 WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8104'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_INVENTRY'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 4D-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8104-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04776_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04776_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04776_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8210-INSRT-EQU-ENV                                             *        
      ******************************************************************        
      *                                                                         
       8210-INSRT-EQU-ENV.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_ENVRNMT                             
                 (                                                      
                   INSTALL_LOC_NO                                       
                  ,INSTALL_POINT_NO                                     
                  ,EQUIP_SEQ                                            
                  ,INSTALL_LOC_CD                                       
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,BILLING_FL                                           
                  ,NO_BILL_REASON_CD                                    
                  ,EQUIP_CONTRACT_FL                                    
                  ,NO_CONTRACT_RSN_CD                                   
                  ,EQUIP_OWNER_CD                                       
                  ,EQUIP_DRAWING_ID                                     
                  ,EQUIP_GIS_GKEY                                       
                  ,SOURCE_APPL_CD                                       
                  ,SOURCE_APPL_REQ_NO                                   
                  ,WMS_POINT_NO                                         
                  ,EQUIP_INSTALL_DT                                     
                  ,INSTALL_USERID                                       
                  ,APPROVED_TS                                          
                  ,APPROVER_USERID                                      
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,SPCL_AGR_COMMENTS                                    
                  ,EQUIP_COMMENTS                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :4F-INSTALL-LOC-NO                                   
                  ,:4F-INSTALL-POINT-NO                                 
                  ,:4F-EQUIP-SEQ                                        
                  ,:4F-INSTALL-LOC-CD                                   
                  ,:4F-CODE-UTIL-TYPE                                   
                  ,:4F-IC-NO                                            
                  ,:4F-RATE-PLAN-NO                                     
                  ,:4F-RATE-ITEM-CODE                                   
                  ,:4F-ITEM-SEQ-NO                                      
                  ,:4F-BILLING-FL                                       
                  ,:4F-NO-BILL-REASON-CD                                
                  ,:4F-EQUIP-CONTRACT-FL                                
                  ,:4F-NO-CONTRACT-RSN-CD                               
                  ,:4F-EQUIP-OWNER-CD                                   
                  ,:4F-EQUIP-DRAWING-ID                                 
                  ,:4F-EQUIP-GIS-GKEY                                   
                  ,:4F-SOURCE-APPL-CD                                   
                  ,:4F-SOURCE-APPL-REQ-NO                               
                  ,:4F-WMS-POINT-NO                                     
                  ,IIF(TRY_CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                         :WS-NULL-EQU-INST-DT
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT 
                                                   :WS-NULL-EQU-INST-DT
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT :WS-NULL-EQU-INST-DT
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT 
                                                   :WS-NULL-EQU-INST-DT
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                                   :WS-NULL-EQU-INST-DT
              ) )           
                  ,:I-USER-ID                                           
                  ,CIS.CHAR2TIMESTAMP(:4F-APPROVED-TS 
                                      :WS-NULL-APPROVED-TS)           
                  ,:4F-APPROVER-USERID                                  
                  ,CIS.CHAR2TIMESTAMP(:4F-LAST-UPDATE-TS)                       
                  ,:4F-LAST-UPDATE-USERID                               
                  ,:4F-SPCL-AGR-COMMENTS                                
                  ,:4F-EQUIP-COMMENTS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_ENVRNMT                                     
MFA-TR*          (                                                              
MFA-TR*            INSTALL_LOC_NO                                               
MFA-TR*           ,INSTALL_POINT_NO                                             
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,INSTALL_LOC_CD                                               
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,BILLING_FL                                                   
MFA-TR*           ,NO_BILL_REASON_CD                                            
MFA-TR*           ,EQUIP_CONTRACT_FL                                            
MFA-TR*           ,NO_CONTRACT_RSN_CD                                           
MFA-TR*           ,EQUIP_OWNER_CD                                               
MFA-TR*           ,EQUIP_DRAWING_ID                                             
MFA-TR*           ,EQUIP_GIS_GKEY                                               
MFA-TR*           ,SOURCE_APPL_CD                                               
MFA-TR*           ,SOURCE_APPL_REQ_NO                                           
MFA-TR*           ,WMS_POINT_NO                                                 
MFA-TR*           ,EQUIP_INSTALL_DT                                             
MFA-TR*           ,INSTALL_USERID                                               
MFA-TR*           ,APPROVED_TS                                                  
MFA-TR*           ,APPROVER_USERID                                              
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,SPCL_AGR_COMMENTS                                            
MFA-TR*           ,EQUIP_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :4F-INSTALL-LOC-NO                                           
MFA-TR*           ,:4F-INSTALL-POINT-NO                                         
MFA-TR*           ,:4F-EQUIP-SEQ                                                
MFA-TR*           ,:4F-INSTALL-LOC-CD                                           
MFA-TR*           ,:4F-CODE-UTIL-TYPE                                           
MFA-TR*           ,:4F-IC-NO                                                    
MFA-TR*           ,:4F-RATE-PLAN-NO                                             
MFA-TR*           ,:4F-RATE-ITEM-CODE                                           
MFA-TR*           ,:4F-ITEM-SEQ-NO                                              
MFA-TR*           ,:4F-BILLING-FL                                               
MFA-TR*           ,:4F-NO-BILL-REASON-CD                                        
MFA-TR*           ,:4F-EQUIP-CONTRACT-FL                                        
MFA-TR*           ,:4F-NO-CONTRACT-RSN-CD                                       
MFA-TR*           ,:4F-EQUIP-OWNER-CD                                           
MFA-TR*           ,:4F-EQUIP-DRAWING-ID                                         
MFA-TR*           ,:4F-EQUIP-GIS-GKEY                                           
MFA-TR*           ,:4F-SOURCE-APPL-CD                                           
MFA-TR*           ,:4F-SOURCE-APPL-REQ-NO                                       
MFA-TR*           ,:4F-WMS-POINT-NO                                             
MFA-TR*           ,:4F-EQUIP-INSTALL-DT  :WS-NULL-EQU-INST-DT                   
MFA-TR*           ,:I-USER-ID                                                   
MFA-TR*           ,:4F-APPROVED-TS       :WS-NULL-APPROVED-TS                   
MFA-TR*           ,:4F-APPROVER-USERID                                          
MFA-TR*           ,:4F-LAST-UPDATE-TS                                           
MFA-TR*           ,:4F-LAST-UPDATE-USERID                                       
MFA-TR*           ,:4F-SPCL-AGR-COMMENTS                                        
MFA-TR*           ,:4F-EQUIP-COMMENTS                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8210'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_ENVRNMT'      TO  TABLE-1                 
              MOVE 'INSTALL_LOC_NO'         TO  TABLE-ELEMENT-1         
              MOVE 'INSTALL_POINT_NO'       TO  TABLE-ELEMENT-2         
              MOVE 'EQUIP_SEQ'              TO  TABLE-ELEMENT-3         
              MOVE 4F-INSTALL-LOC-NO        TO  HOSTVAR-ELEMENT-1       
              MOVE 4F-INSTALL-POINT-NO      TO  HOSTVAR-ELEMENT-2       
              MOVE 4F-EQUIP-SEQ             TO  HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
        8210-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 8310-DELETE-EQU-ENV                                           *         
      *****************************************************************         
       8310-DELETE-EQU-ENV.                                             
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM [4F]                         
                FROM LMS_EQUIP_ENVRNMT [4F]
                 WHERE [4F].INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO         
                   AND [4F].INSTALL_POINT_NO = :4F-INSTALL-POINT-NO       
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM LMS_EQUIP_ENVRNMT 4F                                
MFA-TR*          WHERE 4F.INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO                 
MFA-TR*            AND 4F.INSTALL_POINT_NO = :4F-INSTALL-POINT-NO               
MFA-TR*        QUERYNO 8310                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8310'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_ENVRNMT'     TO TABLE-1                  
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-1          
               MOVE 'INSTALL_POINT_NO'      TO TABLE-ELEMENT-2          
               MOVE 4F-INSTALL-LOC-NO       TO HOSTVAR-ELEMENT-1        
               MOVE 4F-INSTALL-POINT-NO     TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT        
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04776_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1.         
                                                                        
           MOVE S-APPL-RETURN-CODE          TO S-APPL-RETURN-CODE-1.    
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
                                                                        
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    CUSTOMER PLAN UPDATE COPYBOOK                               *        
      ******************************************************************        
      *    EXEC SQL                                                             
      *         INCLUDE CPDLM001                                                
      *    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    TRANSACTION HISTORY  COPYBOOK                               *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDLM002                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
