       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04771.                                          
       AUTHOR.       AMIRTHARAJ.                                        
COB303 DATE-WRITTEN. SEP 04,2014.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04771              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04771 :                                                --         
      *--                                                            --         
      *--  #  UPDATE SP FOR LMS REMOVE WIZARD.                       --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            I_FXTR_EQUIP_SEQ              DECIMAL(10, 0)    --         
      *--            I_FXTR_EQUIP_TAG_NO           CHAR(12)          --         
      *--            I_FXTR_INST_LOC_NO            CHAR(10)          --         
      *--            I_FXTR_INST_POINT_NO          DECIMAL(5,0)      --         
      *--            I_FXTR_RATE_PLAN_NO           CHAR(03)          --         
      *--            I_FXTR_RATE_ITEM_CODE         SMALLINT          --         
      *--            I_FXTR_RATE_TYPE_CD           CHAR(01)          --         
      *--            I_FXTR_BILLIN                 CHAR(01)          --         
      *--            I_FXTR_NO_BILL_REASON_CD      CHAR(02)          --         
      *--            I_NO_CONTRACT_RSN_CD          CHAR(02)          --         
      *--            I_FXTR_EQUIP_CONTRACT_FL      CHAR(01)          --         
      *--            I_FXTR_ACTION_CD              CHAR(01)          --         
      *--            I_ACCOUNT_NO                  DECIMAL(13, 0)    --         
      *--            I_REQUEST_NO                  DECIMAL(13, 0)    --         
      *--            I_TERMINATE_CNTRCT_FL         CHAR(01)          --         
      *--            I_CNTRCT_START_DT             CHAR(10)          --         
      *--            I_ORIG_TERM_CHRG_AM           CHAR(08)          --         
      *--            I_ACTL_TERM_CHRG_AM           CHAR(08)          --         
      *--            I_CNTRCT_CLP_NO               CHAR(50)          --         
      *--            I_TERM_CHRG_OVR_COMMENTS      VARCHAR(250)      --         
      *--            I_REQUEST_NA_COMMENTS         VARCHAR(250)      --         
      *--            I_USER_ID                     CHAR(07)          --         
ACT069*--            I_EFFECTIVE_DATE              CHAR(10)          --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  CSR04771_R1 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--            RETURN_CODE               INTEGER               --         
      *--            APPL_RETURN_CODE          INTEGER               --         
      *--            BUS_RULE_ID               CHAR(10)              --         
      *--            BUS_RULE_RESULT_CD        CHAR(10)              --         
      *--            BUS_RULE_XREF_ID          CHAR(26)              --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  09/04/2014    AD7F921     INITIAL VERSION.                --         
      *--  20/04/2015    VK7L032     CALL CPDLM001 FOR INACTIVE      --         
      *--                            SCENERIOS WHEN RATE/RATE ITEM   --         
      *--                            CODE EXISTS FOR OLD FIXTURE/POLE--         
A05084*--  04/05/2015    VK7L032     NOT TO CREATE WQ WHEN THE ACCOUNT-         
A05084*--                            STATUS OTHER THAN ACTIVE.       --         
A#5084*--  06/19/15      SS95855     ACT040 CLP# CHANGED TO CHAR(50) --         
A#5084*--  12/07/15      SV95326     ACT069 ADD EFFECTIVE DATE IN    --         
      *--                            RRT SCREEN AS A NEW INPUT.      --         
A#5084*--  09/14/16      db41297     Delete tran record              --         
ACT082*----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-ALL-FXTR-ATMS  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04771'.
MSQ017     COPY MFASQLM.
                                                                        
      *                                                                         
       01  WS-START                         PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04771 STARTS HERE'.                 
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_FXTR_ATTACHMTS, 4H                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBFXTATC                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_EQUIP_INVENTRY, 4D                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBEQPINV                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_EQUIP_ENVRNMT, 4F                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBEQPIVT                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_EQUIP_CONTRACT, 4L                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBEQPCNT                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_TERM_CHRG_CALC  4K                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBTRMCLC                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY     C8                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM        G6                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_TRANS_HIST,     4J                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBLGTHST                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_TRANS_HIST_DET, 4S                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBLMSHST                                                
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_MNT_TRANS_HIST, MH                                                
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
      *** CSS_MT_TRN_HST_DET, MI                                                
      ***************************************************************** 00730000
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 00730000
A05084*** CSS_ACCOUNT, AT                                                       
A05084***************************************************************** 00730000
A05084     EXEC SQL                                                             
A05084        INCLUDE TBACCT                                                    
A05084     END-EXEC.                                                            
A05084                                                                  
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS FOR LMS TO BILLING SYNC COPYBOOK CPDLM001        *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSLM001                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS FOR WQ ROUTINE MCSCB077                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00077                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS FOR LMS CONTRACT ROUTINE MCSCB822                *        
      ******************************************************************        
           COPY CWS04822.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(30) VALUE SPACES.     
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04771'. 
           05  MCSCB822                     PIC X(08) VALUE 'MCSCB822'. 
           05  MCSCB077                     PIC X(08) VALUE 'MCSCB077'. 
           05  WS-WQ-COMMENTS               PIC X(56) VALUE             
            'All Lights have been removed. Need to final bill account'. 
      *                                                                         
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
      *                                                                         
       01  WS-TERM-CHG.                                                 
           05  WS-TERM-CHRG-AMT-TXT.                                    
               10  WS-TERM-CHRG-AMT-SI      PIC X(01) VALUE SPACES.     
               10  WS-TERM-CHRG-AMT-AM      PIC X(07) VALUE SPACES.     
           05  WS-TERM-CHRG-AMT-TXT1        PIC X(07) VALUE SPACES.     
           05  WS-TERM-CHRG-AMT-NUM REDEFINES WS-TERM-CHRG-AMT-TXT1     
                                            PIC 9(05)V99.               
           05  WS-TERM-CHRG-AMT-COMP        PIC S9(5)V9(2).             
           05  WS-TERM-CHRG-AMT-HST         PIC -----9(01).9(02).       
                                                                        
      *                                                                         
       01  WS-ORIG-TERM-CHRG.                                           
           05  WS-ORIG-TERM-CHRG-TXT.                                   
               10  WS-ORIG-TERM-CHRG-SI     PIC X(01) VALUE SPACES.     
               10  WS-ORIG-TERM-CHRG-AM     PIC X(07) VALUE SPACES.     
           05  WS-ORIG-TERM-CHRG-TXT1       PIC X(07) VALUE SPACES.     
           05  WS-ORIG-TERM-CHRG-NUM REDEFINES WS-ORIG-TERM-CHRG-TXT1   
                                            PIC 9(05)V99.               
           05  WS-ORIG-TERM-CHRG-COMP       PIC S9(5)V9(2).             
           05  WS-ORIG-TERM-CHRG-HST        PIC -----9(01).9(02).       
                                                                        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(4) COMP VALUE 0.     
           05  WS-ATTMNT-MAX-COUNT          PIC S9(4) COMP VALUE 10.    
           05  WS-ATCHMNT-COUNT             PIC 9(05) VALUE 0.          
           05  WS-ACT-CUST-PLAN-CNT         PIC S9(4) COMP VALUE 0.     
           05  WS-ACT-METER-ENV-CNT         PIC S9(4) COMP VALUE 0.     
      *                                                                         
       01  WS-INDEX-VARS.                                               
           05  WS-TAB-INDX                  PIC S9(4) COMP VALUE 0.     
      *                                                                         
       01  WS-ALL-FXTR-ATTACHMENTS.                                     
           05  TAB-ATTACH-EQUIP-SEQ         OCCURS 10 TIMES             
                                            PIC S9(10)V USAGE COMP-3    
                                                      VALUE 0.          
           05  TAB-EQUIP-TYPE-CD            OCCURS 10 TIMES PIC X(01)   
                                                      VALUE SPACES.     
           05  TAB-EQUIP-TAG-NO             OCCURS 10 TIMES PIC X(12)   
                                                      VALUE SPACES.     
           05  TAB-RATE-PLAN-NO             OCCURS 10 TIMES PIC X(03)   
                                                      VALUE SPACES.     
           05  TAB-RATE-ITEM-CODE           OCCURS 10 TIMES PIC S9(4)   
                                                  USAGE COMP VALUE 0.   
           05  TAB-BILLING-FL               OCCURS 10 TIMES PIC X(01)   
                                                      VALUE SPACES.     
           05  TAB-NO-BILL-REASON-CD        OCCURS 10 TIMES PIC X(02)   
                                                      VALUE SPACES.     
           05  TAB-INSTALL-POINT-NO         OCCURS 10 TIMES             
                                            PIC S9(05)V USAGE COMP-3    
                                                      VALUE 0.          
      *                                                                         
       01  WS-MISC-FIELDS.                                              
           05  WS-FIX-EQ-SEQ                PIC S9(10)V USAGE COMP-3    
                                                      VALUE 0.          
           05  WS-EQUIP-TAG-NO              PIC X(12) VALUE SPACES.     
           05  WS-INST-LOC-NO               PIC X(10) VALUE SPACES.     
           05  WS-INST-POINT-NO             PIC S9(05)V USAGE COMP-3    
                                                      VALUE 0.          
           05  WS-ACCOUNT-NO                PIC S9(13)V USAGE COMP-3    
                                                      VALUE 0.          
           05  WS-REQUEST-NO                PIC S9(13)V USAGE COMP-3    
                                                      VALUE 0.          
           05  WS-FIX-ACTION-CD             PIC X(01) VALUE SPACES.     
           05  WS-CNTRCT-ST-DATE            PIC X(10) VALUE SPACES.     
           05  WS-TERMINATE-CNTRCT-FL       PIC X(01) VALUE SPACES.     
                                                                        
           05  WS-TRCHG-OVERID-CMN.                                     
               10  WS-TRCHG-OVERID-CMN-LEN  PIC S9(04) COMP VALUE +0.   
               10  WS-TRCHG-OVERID-CMN-TXT  PIC X(248) VALUE SPACES.    
                                                                        
           05  WS-WMS-REQ-CMN.                                          
               10  WS-WMS-REQ-CMN-LEN       PIC S9(04) COMP VALUE +0.   
               10  WS-WMS-REQ-CMN-TXT       PIC X(248) VALUE SPACES.    
                                                                        
           05  WS-USER-ID                   PIC X(07)  VALUE SPACES.    
           05  WS-FXTR-RT-GRNDFTHRD         PIC X(01)  VALUE SPACES.    
           05  WS-FIX-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.    
           05  WS-FIX-RATE-ITEM-CODE        PIC S9(04) USAGE COMP       
                                                       VALUE 0.         
           05  WS-FIX-RATE-ITEM-CD-TXT      PIC X(04)  VALUE SPACES.    
           05  WS-RATE-ITEM-CODE-TXT        PIC X(04)  VALUE SPACES.    
           05  WS-INVENTRY-ST-CD-PREV       PIC X(01)  VALUE SPACES.    
ACT040     05  WS-CNTRCT-CLP-NO-PREV        PIC X(50)  VALUE SPACES.    
           05  WS-EQUIP-TAG-NO-NODE         PIC X(12)  VALUE SPACES.    
           05  WS-LMS-CNTR-ITEM-ID          PIC X(09)  VALUE SPACES.    
           05  WS-CURRENT-DATE              PIC X(10)  VALUE SPACES.    
           05  WS-FXTR-INST-LOC-CD          PIC X(01)  VALUE SPACES.    
           05  WS-MCSCB077-RET-CODE         PIC S9(09) COMP VALUE 0.    
           05  WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(04) COMP VALUE 0.    
           05  S-APPL-RETURN-CODE           PIC S9(04) COMP VALUE 0.    
      *                                                                         
           05  GTT-RETURN-FIELDS-1.                                     
               10  S-RETURN-CODE-1          PIC S9(04) COMP VALUE 0.    
               10  S-APPL-RETURN-CODE-1     PIC S9(04) COMP VALUE 0.    
               10  S-RS1-BUS-RULE-ID        PIC X(10)  VALUE SPACES.    
               10  S-RS1-BUS-RULE-RESULT-CD PIC X(10)  VALUE SPACES.    
               10  S-RS1-BUS-RULE-XREF-ID   PIC X(26)  VALUE SPACES.    
      *                                                                         
      ****************************************************************          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18)  VALUE SPACES.    
           10  S-SQLCODE                    PIC S9(9)  COMP VALUE 0.    
           10  S-SQLSTATE                   PIC X(5)   VALUE ' '.       
           10  S-TABLE-NAME                 PIC X(18)  VALUE SPACES.    
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
      *                                                                         
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE ALL_FXTR_ATMS CURSOR WITH ROWSET POSITIONING FOR  
                 SELECT  [4H].ATTACH_EQUIP_SEQ                            
                        ,[4D].EQUIP_TYPE_CD                               
                        ,[4D].EQUIP_TAG_NO                                
                        ,COALESCE([4F].INSTALL_POINT_NO,0)                  
                        ,COALESCE([4F].RATE_PLAN_NO,'')                     
                        ,COALESCE([4F].RATE_ITEM_CODE,0)                    
                        ,COALESCE([4F].BILLING_FL,'')                       
                        ,COALESCE([4F].NO_BILL_REASON_CD,'')                
                   FROM LMS_FXTR_ATTACHMTS [4H]
                           WITH(READUNCOMMITTED)      JOIN                 
                        LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                 ON ([4H].FXTR_EQUIP_SEQ         = :4H-FXTR-EQUIP-SEQ     
                    AND  [4D].EQUIP_SEQ          = [4H].ATTACH_EQUIP_SEQ    
                    AND  [4D].EQUIP_TYPE_CD      = [4H].EQUIP_TYPE_CD       
                    AND  [4D].INVENTRY_STATUS_CD =  'J')  LEFT JOIN       
                         LMS_EQUIP_ENVRNMT   [4F] WITH(READUNCOMMITTED)         
                     ON ([4F].EQUIP_SEQ          = [4H].ATTACH_EQUIP_SEQ    
                    AND  [4F].INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO)    
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ALL_FXTR_ATMS CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*          SELECT  4H.ATTACH_EQUIP_SEQ                                    
MFA-TR*                 ,4D.EQUIP_TYPE_CD                                       
MFA-TR*                 ,4D.EQUIP_TAG_NO                                        
MFA-TR*                 ,IFNULL(4F.INSTALL_POINT_NO,0)                          
MFA-TR*                 ,IFNULL(4F.RATE_PLAN_NO,'')                             
MFA-TR*                 ,IFNULL(4F.RATE_ITEM_CODE,0)                            
MFA-TR*                 ,IFNULL(4F.BILLING_FL,'')                               
MFA-TR*                 ,IFNULL(4F.NO_BILL_REASON_CD,'')                        
MFA-TR*            FROM LMS_FXTR_ATTACHMTS 4H      JOIN                         
MFA-TR*                 LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*          ON (4H.FXTR_EQUIP_SEQ         = :4H-FXTR-EQUIP-SEQ             
MFA-TR*             AND  4D.EQUIP_SEQ          = 4H.ATTACH_EQUIP_SEQ            
MFA-TR*             AND  4D.EQUIP_TYPE_CD      = 4H.EQUIP_TYPE_CD               
MFA-TR*             AND  4D.INVENTRY_STATUS_CD =  'J')  LEFT JOIN               
MFA-TR*                  LMS_EQUIP_ENVRNMT   4F                                 
MFA-TR*              ON (4F.EQUIP_SEQ          = 4H.ATTACH_EQUIP_SEQ            
MFA-TR*             AND  4F.INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO)            
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
COB305 01 PARM-FXTR-EQUIP-SEQ        PIC S9(10)V USAGE COMP-3 VALUE 0.   
       01  PARM-FXTR-EQUIP-TAG-NO           PIC X(12).                  
       01  PARM-FXTR-INST-LOC-NO            PIC X(10).                  
COB305 01 PARM-FXTR-INST-POINT-NO        PIC S9(05)V USAGE COMP-3 
COB305       VALUE 0.   
       01  PARM-FXTR-INST-LOC-CD            PIC X(01).                  
       01  PARM-FXTR-RATE-PLAN-NO           PIC X(03).                  
       01  PARM-FXTR-RATE-ITEM-CD           PIC S9(4) COMP.             
       01  PARM-FXTR-BILLING-FL             PIC X(01).                  
       01  PARM-FXTR-NO-BILL-RSN-CD         PIC X(02).                  
       01  PARM-NO-CONTRACT-RSN-CD          PIC X(02).                  
       01  PARM-FXTR-ACTION-CD              PIC X(01).                  
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
COB305 01 PARM-REQUEST-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
       01  PARM-TERMINATE-CNTRCT-FL         PIC X(01).                  
       01  PARM-CNTRCT-START-DT             PIC X(10).                  
       01  PARM-ORIG-TERM-CHRG-AM           PIC X(08).                  
       01  PARM-ACTL-TERM-CHRG-AM           PIC X(08).                  
ACT040 01  PARM-CNTRCT-CLP-NO               PIC X(50).                  
       01  PARM-TERM-CHRG-OVR-COMMENTS.                                 
           05  PARM-TERM-CHRG-OVR-CMNT-LEN  PIC S9(04) COMP.            
           05  PARM-TERM-CHRG-OVR-CMNT-TXT  PIC X(248).                 
       01  PARM-REQUEST-NA-COMMENTS.                                    
           05  PARM-REQUEST-NA-COMMENTS-LEN PIC S9(04) COMP.            
           05  PARM-REQUEST-NA-COMMENTS-TXT PIC X(248).                 
       01  PARM-USER-ID                     PIC X(07).                  
ACT069 01  PARM-EFFECTIVE-DT                PIC X(10) VALUE SPACES.     
                                                                        
       PROCEDURE DIVISION USING PARM-FXTR-EQUIP-SEQ                     
                               ,PARM-FXTR-EQUIP-TAG-NO                  
                               ,PARM-FXTR-INST-LOC-NO                   
                               ,PARM-FXTR-INST-POINT-NO                 
                               ,PARM-FXTR-INST-LOC-CD                   
                               ,PARM-FXTR-RATE-PLAN-NO                  
                               ,PARM-FXTR-RATE-ITEM-CD                  
                               ,PARM-FXTR-BILLING-FL                    
                               ,PARM-FXTR-NO-BILL-RSN-CD                
                               ,PARM-NO-CONTRACT-RSN-CD                 
                               ,PARM-FXTR-ACTION-CD                     
                               ,PARM-ACCOUNT-NO                         
                               ,PARM-REQUEST-NO                         
                               ,PARM-TERMINATE-CNTRCT-FL                
                               ,PARM-CNTRCT-START-DT                    
                               ,PARM-ORIG-TERM-CHRG-AM                  
                               ,PARM-ACTL-TERM-CHRG-AM                  
                               ,PARM-CNTRCT-CLP-NO                      
                               ,PARM-TERM-CHRG-OVR-COMMENTS             
                               ,PARM-REQUEST-NA-COMMENTS                
                               ,PARM-USER-ID                            
ACT069                         ,PARM-EFFECTIVE-DT.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04771_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04771_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04771_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04771_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04771_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-FXTR-EQUIP-SEQ        TO WS-FIX-EQ-SEQ             
                                              4H-FXTR-EQUIP-SEQ         
                                              4L-EQUIP-SEQ.             
           MOVE PARM-FXTR-EQUIP-TAG-NO     TO WS-EQUIP-TAG-NO           
                                              4D-EQUIP-TAG-NO.          
           MOVE PARM-FXTR-INST-LOC-NO      TO WS-INST-LOC-NO            
                                              4F-INSTALL-LOC-NO         
                                              4L-INSTALL-LOC-NO.        
           MOVE PARM-FXTR-INST-POINT-NO    TO WS-INST-POINT-NO          
                                              4F-INSTALL-POINT-NO.      
           MOVE PARM-FXTR-INST-LOC-CD      TO WS-FXTR-INST-LOC-CD.      
           MOVE PARM-ACCOUNT-NO            TO WS-ACCOUNT-NO             
                                              4L-ACCOUNT-NO             
A05084                                        AT-ACCOUNT-NO.            
           MOVE PARM-REQUEST-NO            TO WS-REQUEST-NO.            
           MOVE PARM-FXTR-ACTION-CD        TO WS-FIX-ACTION-CD          
                                              4D-INVENTRY-STATUS-CD.    
           MOVE PARM-CNTRCT-START-DT       TO WS-CNTRCT-ST-DATE         
                                              4L-CNTRCT-START-DT.       
           MOVE PARM-TERMINATE-CNTRCT-FL   TO WS-TERMINATE-CNTRCT-FL.   
           MOVE PARM-TERM-CHRG-OVR-COMMENTS TO WS-TRCHG-OVERID-CMN.     
           MOVE PARM-REQUEST-NA-COMMENTS   TO WS-WMS-REQ-CMN.           
           MOVE PARM-USER-ID               TO WS-USER-ID.               
                                                                        
           MOVE PARM-ACTL-TERM-CHRG-AM     TO WS-TERM-CHRG-AMT-TXT.     
           MOVE WS-TERM-CHRG-AMT-AM        TO WS-TERM-CHRG-AMT-TXT1.    
                                                                        
           IF WS-TERM-CHRG-AMT-AM = '-'                                 
              COMPUTE WS-TERM-CHRG-AMT-COMP = WS-TERM-CHRG-AMT-NUM  * -1
           ELSE                                                         
              COMPUTE WS-TERM-CHRG-AMT-COMP = WS-TERM-CHRG-AMT-NUM  * 1 
           END-IF.                                                      
                                                                        
           MOVE PARM-ORIG-TERM-CHRG-AM     TO WS-ORIG-TERM-CHRG-TXT.    
           MOVE WS-ORIG-TERM-CHRG-AM       TO WS-ORIG-TERM-CHRG-TXT1.   
                                                                        
           IF WS-ORIG-TERM-CHRG-SI = '-'                                
              COMPUTE WS-ORIG-TERM-CHRG-COMP                            
                      EQUAL WS-ORIG-TERM-CHRG-NUM  * -1                 
           ELSE                                                         
              COMPUTE WS-ORIG-TERM-CHRG-COMP                            
                      EQUAL WS-ORIG-TERM-CHRG-NUM  * 1                  
           END-IF.                                                      
                                                                        
           MOVE 01                         TO WS-TAB-INDX.              
           PERFORM 7000-GET-CURRENT-DATE      THRU 7000-EXIT.           
A05084     IF AT-ACCOUNT-NO > 0                                         
A05084       PERFORM 7300-GET-ACCOUNT-STATUS  THRU 7300-EXIT            
A05084     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7100-OPEN-ALL-FIX-ATT-CUR   THRU 7100-EXIT.          
           PERFORM 7101-FETCH-ALL-FIX-ATT-CUR  THRU 7101-EXIT.          
           PERFORM 7102-CLOSE-ALL-FIX-ATT-CUR  THRU 7102-EXIT.          
      *                                                                         
           PERFORM 8101-DELETE-ATTACHMENTS     THRU 8101-EXIT.          
                                                                        
           PERFORM 2100-PROCESS-ATTACHMENTS    THRU 2100-EXIT           
                   UNTIL WS-TAB-INDX > WS-ATTMNT-MAX-COUNT              
                         OR TAB-EQUIP-TYPE-CD(WS-TAB-INDX) = SPACES.    
                                                                        
           PERFORM 2200-PROCESS-FIXTURE        THRU 2200-EXIT.          
                                                                        
           IF WS-TERMINATE-CNTRCT-FL = 'Y'                              
              PERFORM 2300-PROCESS-CONTRACT    THRU 2300-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 5000-WRITE-TRANS-HIST       THRU 5000-EXIT.          
                                                                        
A05084     IF WS-ACCOUNT-NO > 0 AND AT-CODE-ACCT-STAT = 'A'             
              PERFORM 2450-PROCESS-LAST-LIGHT-WQ                        
                                               THRU 2450-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 2500-MOVE-RESULT            THRU 2500-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-ATTACHMENTS                                       *        
      ******************************************************************        
       2100-PROCESS-ATTACHMENTS.                                        
                                                                        
            EVALUATE TAB-EQUIP-TYPE-CD(WS-TAB-INDX)                     
                WHEN 'P'                                                
                   MOVE TAB-ATTACH-EQUIP-SEQ(WS-TAB-INDX)               
                                                   TO 4D-EQUIP-SEQ      
                                                      4F-EQUIP-SEQ      
                   MOVE TAB-INSTALL-POINT-NO (WS-TAB-INDX) TO           
                                                   4F-INSTALL-POINT-NO  
                   IF (PARM-FXTR-INST-LOC-CD  = 'P')          AND       
                     ((TAB-BILLING-FL(WS-TAB-INDX)     = 'Y') OR        
                      (TAB-BILLING-FL(WS-TAB-INDX)     = 'N'  AND       
                       TAB-RATE-PLAN-NO(WS-TAB-INDX)   > ' '  AND       
                       TAB-RATE-ITEM-CODE(WS-TAB-INDX) >  0 ) )         
                      PERFORM 2400-UPDATE-CUST-PLAN   THRU 2400-EXIT    
                   ELSE                                                 
                      PERFORM 8103-DELETE-EQUIP-ENV   THRU 8103-EXIT    
                   END-IF                                               
                                                                        
ACT082             PERFORM 8100-DELETE-MNT            THRU 8100-EXIT    
                   PERFORM 8104-DELETE-EQ-INV         THRU 8104-EXIT    
                WHEN 'N'                                                
                   MOVE TAB-ATTACH-EQUIP-SEQ(WS-TAB-INDX)               
                                                   TO 4D-EQUIP-SEQ      
                   PERFORM 8105-UPDATE-EQUIP-INV      THRU 8105-EXIT    
           END-EVALUATE.                                                
                                                                        
           ADD 1                                   TO WS-TAB-INDX.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-FIXTURE.                                          *        
      ******************************************************************        
       2200-PROCESS-FIXTURE.                                            
                                                                        
           MOVE WS-INST-POINT-NO           TO 4F-INSTALL-POINT-NO.      
                                                                        
           IF PARM-FXTR-INST-LOC-CD  = 'S' OR                           
              PARM-FXTR-INST-LOC-CD  = 'Z'                              
               MOVE WS-FIX-EQ-SEQ              TO 4F-EQUIP-SEQ          
               MOVE WS-INST-LOC-NO             TO 4F-INSTALL-LOC-NO     
               PERFORM 8103-DELETE-EQUIP-ENV   THRU 8103-EXIT           
           ELSE                                                         
               IF PARM-FXTR-INST-LOC-CD  = 'P'                          
                  PERFORM 2400-UPDATE-CUST-PLAN   THRU 2400-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
            MOVE WS-FIX-EQ-SEQ              TO 4D-EQUIP-SEQ.            
            MOVE SPACES                     TO WS-INVENTRY-ST-CD-PREV.  
            PERFORM 8105-UPDATE-EQUIP-INV      THRU 8105-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS CONTRACT TERMINATION                                   *        
      ******************************************************************        
       2300-PROCESS-CONTRACT.                                           
                                                                        
            MOVE WS-ORIG-TERM-CHRG-COMP     TO 4L-ORIG-TERM-CHRG-AM.    
            MOVE WS-TERM-CHRG-AMT-COMP      TO 4L-ACTL-TERM-CHRG-AM.    
            MOVE PARM-ACCOUNT-NO            TO 4L-ACCOUNT-NO.           
            PERFORM 8102-UPDATE-EQUIP-CNT      THRU 8102-EXIT.          
                                                                        
            IF WS-TERM-CHRG-AMT-COMP > 0                                
               PERFORM 6001-CREATE-LMS-CONTRACT THRU 6001-EXIT          
            END-IF.                                                     
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-UPDATE-CUST-PLAN.                                         *        
      ******************************************************************        
       2400-UPDATE-CUST-PLAN.                                           
                                                                        
            INITIALIZE LM001-INPUT.                                     
                                                                        
            MOVE 'R'                        TO LM001-ACTION-CODE        
            MOVE WS-ACCOUNT-NO              TO LM001-ACCOUNT-NO         
            MOVE WS-INST-LOC-NO             TO LM001-INSTALL-LOC-NO     
            MOVE 4F-INSTALL-POINT-NO        TO LM001-INSTALL-POINT-NO   
ACT069*     MOVE WS-CURRENT-DATE            TO LM001-ACTION-DATE                
ACT069      MOVE PARM-EFFECTIVE-DT          TO LM001-ACTION-DATE        
            MOVE WS-USER-ID                 TO LM001-USER-ID            
            MOVE PROGRAM-NAME               TO LM001-PROGRAM-NAME       
                                                                        
            PERFORM 6300-LM001-CUST-LIGHT-SYNC THRU 6300-LM001-EXIT.    
                                                                        
            IF LM001-ERROR                                              
               MOVE LM001-ERR-SQLCODE       TO WS-ACTIVE-RETURN-CODE    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE LM001-BUS-RULE-ID       TO S-RS1-BUS-RULE-ID        
               MOVE 'F'                     TO S-RS1-BUS-RULE-RESULT-CD 
               MOVE 'CPDLM001'              TO ABEND-PROGRAM            
               MOVE LM001-ERR-PARAGRAPH-NO  TO ACTIVE-PARAGRAPH         
               MOVE LM001-ERR-FUNCTION      TO ABEND-FUNCTION           
               MOVE LM001-ERR-TABLE1        TO TABLE-1                  
               MOVE LM001-ERR-TABLE2        TO TABLE-2                  
               MOVE LM001-ERR-COLUMN-1      TO TABLE-ELEMENT-1          
               MOVE LM001-ERR-COLUMN-2      TO TABLE-ELEMENT-2          
               MOVE LM001-ERR-COLUMN-3      TO TABLE-ELEMENT-3          
               MOVE LM001-ERR-COLUMN-4      TO TABLE-ELEMENT-4          
               MOVE LM001-ERR-HOSTVAR-1     TO HOSTVAR-ELEMENT-1        
               MOVE LM001-ERR-HOSTVAR-2     TO HOSTVAR-ELEMENT-2        
               MOVE LM001-ERR-HOSTVAR-3     TO HOSTVAR-ELEMENT-3        
               MOVE LM001-ERR-HOSTVAR-4     TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            END-IF.                                                     
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2450-PROCESS-LAST-LIGHT-WQ.                                    *        
      ******************************************************************        
       2450-PROCESS-LAST-LIGHT-WQ.                                      
                                                                        
            MOVE 0                         TO WS-ACT-CUST-PLAN-CNT      
                                              WS-ACT-METER-ENV-CNT.     
                                                                        
            PERFORM 7200-CHECK-ACTIVE-CUST-PLAN    THRU 7200-EXIT       
                                                                        
            IF WS-ACT-CUST-PLAN-CNT = 0                                 
               PERFORM 7250-CHECK-ACTIVE-METER-ENV THRU 7250-EXIT       
            END-IF.                                                     
                                                                        
            IF WS-ACT-METER-ENV-CNT = 0 AND WS-ACT-CUST-PLAN-CNT = 0    
               INITIALIZE CWS00077-FIELDS                               
                                                                        
               EXEC SQL                                                 
                    SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP       
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                         
MFA-TR*             SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP               
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE WS-ACCOUNT-NO          TO WS-77-ACCOUNT-NO          
               MOVE WS-CURRENT-TIMESTAMP   TO WS-77-DATE-CREATED        
                                              WS-77-DATE-REQUIRED       
               MOVE 571                    TO WS-77-CATEGORY-ID         
               MOVE 'H'                    TO WS-77-PRIORITY            
               MOVE '1'                    TO WS-77-ROUTE-CATEGORY      
               MOVE WS-WQ-COMMENTS         TO WS-77-COMMENTS-TEXT       
                                                                        
               COMPUTE WS-77-COMMENTS-LEN                               
                       EQUAL LENGTH OF WS-77-COMMENTS-TEXT              
                                                                        
               MOVE PROGRAM-NAME           TO WS-77-CREATED-BY          
               MOVE 'SYSTEM'               TO WS-77-USER-ID-ORIG        
                                                                        
               PERFORM 6002-INSERT-WORK-QUEUE THRU 6002-EXIT            
            END-IF.                                                     
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-MOVE-RESULT.                                              *        
      ******************************************************************        
       2500-MOVE-RESULT.                                                
                                                                        
            MOVE S-RETURN-CODE              TO S-RETURN-CODE-1.         
            MOVE S-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1.    
            PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.          
                                                                        
       2500-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE TRANSACTION HISTORY IN LMS TABLE.                        *        
      ******************************************************************        
       5000-WRITE-TRANS-HIST.                                           
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
            MOVE 'GISYSNC'                 TO 4J-APPL-PROGRAM-ID.       
            MOVE 16                        TO 4J-TRANS-COMMENTS-LEN.    
            MOVE 'GISSYNC REQUIRED'        TO 4J-TRANS-COMMENTS-TEXT.   
            PERFORM 5050-WRITE-TRAN-HIST-HDR       THRU 5050-EXIT.      
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
            MOVE PROGRAM-NAME                    TO 4J-APPL-PROGRAM-ID. 
            IF PARM-TERM-CHRG-OVR-CMNT-TXT > SPACES                     
               MOVE PARM-TERM-CHRG-OVR-CMNT-LEN TO                      
                                                 4J-TRANS-COMMENTS-LEN  
               MOVE PARM-TERM-CHRG-OVR-CMNT-TXT TO                      
                                                 4J-TRANS-COMMENTS-TEXT 
               PERFORM 5050-WRITE-TRAN-HIST-HDR       THRU 5050-EXIT    
            END-IF.                                                     
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
            MOVE PROGRAM-NAME                    TO 4J-APPL-PROGRAM-ID. 
            IF PARM-REQUEST-NA-COMMENTS-TXT > SPACES                    
               MOVE PARM-REQUEST-NA-COMMENTS-LEN TO                     
                                                 4J-TRANS-COMMENTS-LEN  
               MOVE PARM-REQUEST-NA-COMMENTS-TXT TO                     
                                                 4J-TRANS-COMMENTS-TEXT 
            ELSE                                                        
               MOVE 13                        TO 4J-TRANS-COMMENTS-LEN  
               MOVE 'REMOVE WIZARD'           TO 4J-TRANS-COMMENTS-TEXT 
            END-IF.                                                     
            PERFORM 5050-WRITE-TRAN-HIST-HDR       THRU 5050-EXIT.      
                                                                        
            MOVE 4J-TRANS-HIST-SEQ-NO          TO 4S-TRANS-HIST-SEQ-NO. 
            PERFORM 5100-WRITE-FXTR-TRAN-HIST      THRU 5100-EXIT.      
            IF WS-TERMINATE-CNTRCT-FL = 'Y'                             
                PERFORM 5200-WRITE-CNTRCT-TRAN-HIST    THRU 5200-EXIT   
            ELSE                                                        
                PERFORM 5250-WRITE-NO-CNTRCT-TRAN-HIST THRU 5250-EXIT   
            END-IF.                                                     
            MOVE 01                                TO WS-TAB-INDX.      
            PERFORM 5300-WRITE-ATTCHMNT-TRAN-HIST  THRU 5300-EXIT       
                   UNTIL WS-TAB-INDX > WS-ATTMNT-MAX-COUNT              
                         OR TAB-EQUIP-TYPE-CD(WS-TAB-INDX) = SPACES.    
                                                                        
       5000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE TRANSACTION HISTORY HEADER IN LMS TABLE.                 *        
      ******************************************************************        
       5050-WRITE-TRAN-HIST-HDR.                                        
                                                                        
            MOVE WS-CURRENT-DATE           TO 4J-TRANS-DATE.            
            MOVE +01                       TO 4S-DETAIL-SEQ-NO.         
            MOVE WS-FIX-EQ-SEQ             TO 4J-EQUIP-SEQ.             
            MOVE 4D-EQUIP-TAG-NO           TO 4J-EQUIP-TAG-NO.          
            MOVE WS-ACCOUNT-NO             TO 4J-ACCOUNT-NO.            
GOPI******  IF LENGTH OF WS-REQUEST-NO = 6 THEN 'WMS' ELSE 'CIS'                
            MOVE 'CIS'                     TO 4J-SOURCE-APPL-CD.        
            MOVE WS-REQUEST-NO             TO 4J-SOURCE-APPL-REQ-NO.    
            MOVE 0                         TO 4J-WMS-POINT-NO.          
            MOVE WS-INST-LOC-NO            TO 4J-INSTALL-LOC-NO.        
            MOVE 4F-INSTALL-POINT-NO       TO 4J-INSTALL-POINT-NO.      
            MOVE WS-USER-ID                TO 4J-LAST-UPDATE-USERID     
                                              4S-LAST-UPDATE-USERID.    
                                                                        
            PERFORM 6080-GET-CURR-TS-CPDLM2       THRU 6080-CPDLM2-EXIT.
            PERFORM 6025-INS-LMS-TRN-HST-CPDLM2   THRU 6025-CPDLM2-EXIT.
                                                                        
       5050-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE FIXTURE TRANSACTION HISTORY IN LMS TABLE.                *        
      ******************************************************************        
       5100-WRITE-FXTR-TRAN-HIST.                                       
                                                                        
      * MOVING FIXTURE INVENTORY STATUS CODE TO HISTORY TABLE                   
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_INVNTRY_ST_CD'      TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE 'J'                       TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 01                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE PARM-FXTR-ACTION-CD       TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
      * MOVING CHANGED RATE-PLAN-NO VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_RATE_PLAN_NO'       TO 4S-COLUMN-DESC.           
            MOVE 03                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-FXTR-RATE-PLAN-NO    TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
      * MOVING CHANGED RATE-ITEM-CODE VALUES TO HISTORY TABLE                   
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_RATE_ITEM_CD'       TO 4S-COLUMN-DESC.           
            MOVE 04                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-FXTR-RATE-ITEM-CD    TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED BILLING FL VALUES TO HISTORY TABLE                       
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_BILLING_FL'         TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-FXTR-BILLING-FL      TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED FXTR NO BILL REASON CODE IN TRANSACTION TABLE            
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_NOBILL_RSN_CD'      TO 4S-COLUMN-DESC.           
            MOVE 02                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-FXTR-NO-BILL-RSN-CD  TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5100-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE CONTRACT TRANSACTION HISTORY IN LMS TABLE.               *        
      ******************************************************************        
       5200-WRITE-CNTRCT-TRAN-HIST.                                     
                                                                        
      * MOVING CHANGED CONTRACT END DATE VALUES TO HISTORY TABLE                
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'ACTL_TERM_CHRG_AM'       TO 4S-COLUMN-DESC.           
            MOVE 08                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-TERM-CHRG-AMT-NUM      TO WS-TERM-CHRG-AMT-HST.     
            MOVE WS-TERM-CHRG-AMT-HST      TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED ACTUAL CHARGED DATE VALUES TO HISTORY TABLE              
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'ACTUAL_CHRG_DT'          TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-CURRENT-DATE           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT CLP NO CODE VALUES TO HISTORY TABLE             
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_CLP_NO'           TO 4S-COLUMN-DESC.           
ACT040      MOVE LENGTH OF PARM-CNTRCT-CLP-NO                           
ACT040                                     TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-CNTRCT-CLP-NO        TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 14                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**TERMINATED**'          TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5200-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE NO CONTRACT TRANSACTION HISTORY IN LMS TABLE.            *        
      ******************************************************************        
       5250-WRITE-NO-CNTRCT-TRAN-HIST.                                  
                                                                        
      * MOVING CHANGED CONTRACT START DATE VALUES TO HISTORY TABLE              
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'NO_CONTRACT_RSN_CD'      TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-NO-CONTRACT-RSN-CD   TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 15                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**NO CONTRACT**'         TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5250-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.             *        
      ******************************************************************        
       5300-WRITE-ATTCHMNT-TRAN-HIST.                                   
                                                                        
            EVALUATE TAB-EQUIP-TYPE-CD(WS-TAB-INDX)                     
                WHEN 'P'                                                
                   PERFORM 5600-WRITE-POLE-TRAN-HIST THRU               
                                                              5600-EXIT 
                WHEN 'N'                                                
                   PERFORM 5700-WRITE-NODE-TRAN-HIST THRU               
                                                              5700-EXIT 
            END-EVALUATE.                                               
                                                                        
            ADD 01                                    TO WS-TAB-INDX.   
                                                                        
       5300-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE POLE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.        *        
      ******************************************************************        
       5600-WRITE-POLE-TRAN-HIST.                                       
                                                                        
      * MOVING CHANGED EQUIP TAG NO VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-EQUIP-TAG-NO(WS-TAB-INDX) TO                       
                                              4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-PLAN-NO VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_PLAN_NO'       TO 4S-COLUMN-DESC.           
            MOVE 03                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-RATE-PLAN-NO(WS-TAB-INDX)                          
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-ITEM-CODE VALUES TO HISTORY TABLE                   
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_ITEM_CD'       TO 4S-COLUMN-DESC.           
            MOVE 04                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-RATE-ITEM-CODE(WS-TAB-INDX)                        
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED BILLING FLAG VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_BILLING_FL'         TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-BILLING-FL(WS-TAB-INDX)                            
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED NO BILL REASON CD VALUES TO HISTORY TABLE                
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_NOBILL_RSN_CD'      TO 4S-COLUMN-DESC.           
            MOVE LENGTH OF TAB-NO-BILL-REASON-CD(WS-TAB-INDX)           
                                           TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-NO-BILL-REASON-CD(WS-TAB-INDX)                     
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5600-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE NODE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.        *        
      ******************************************************************        
       5700-WRITE-NODE-TRAN-HIST.                                       
                                                                        
      * MOVING CHANGED EQUIP TAG NO VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'NODE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-EQUIP-TAG-NO(WS-TAB-INDX) TO                       
                                              4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
            ADD 01                         TO WS-TAB-INDX.              
                                                                        
       5700-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 6001-CREATE-LMS-CONTRACT.                                      *        
      ******************************************************************        
       6001-CREATE-LMS-CONTRACT.                                        
                                                                        
            INITIALIZE WS-CONTRACT-HEADER-PARMS                         
                       WS-CONTRACT-DETAIL-PARMS                         
                       WS-CONTRACT-RETURN-INFO.                         
                                                                        
            SET  CONTRACT-INSERT          TO TRUE.                      
            SET  CALLED-FROM-ONLINE       TO TRUE.                      
            SET  LMS-CONTRACT             TO TRUE.                      
                                                                        
            MOVE WS-USER-ID               TO WS-4822-USER-ID.           
            MOVE WS-ACCOUNT-NO            TO WS-4822-ACCOUNT-NO.        
            MOVE 407                      TO WS-4822-CNT-NAME-CD.       
            MOVE PROGRAM-NAME             TO WS-4822-CNT-APPL-PGM-ID.   
            MOVE WS-TERM-CHRG-AMT-COMP    TO WS-4822-AMT-ORIG-ENTERED.  
            MOVE 'E'                      TO WS-4822-CODE-CONTRACT-TYPE.
                                                                        
            CALL MCSCB822 USING ABEND-FILE                              
                               ,WS-WARNING-DATA-ELEMENTS                
                               ,WS-CONTRACT-HEADER-PARMS                
                               ,WS-CONTRACT-DETAIL-PARMS                
                               ,WS-CONTRACT-OPERATION-TYPE              
                               ,WS-CONTRACT-RETURN-INFO.                
                                                                        
            IF CPD4822-DB2-ERR-FOUND                                    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '6001'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CALL'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE MCSCB822                TO TABLE-1                  
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            ELSE                                                        
               MOVE WS-4822-NEW-ITEM-ID     TO WS-LMS-CNTR-ITEM-ID      
            END-IF.                                                     
                                                                        
       6001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 6002-INSERT-WORK-QUEUE.                                    **          
      **  CALL SUB PROGRAM MCSCB077 FOR INSERTING WORK QUEUES INTO  **  28610000
      **  CSS_WQ_ITEMS.                                             **  28620000
      ****************************************************************          
       6002-INSERT-WORK-QUEUE.                                          
                                                                        
           CALL MCSCB077  USING   CWS00077-FIELDS,                      
                                  ABEND-FILE,                           
                                  WS-MCSCB077-RET-CODE.                 
      *                                                                         
           MOVE WS-MCSCB077-RET-CODE       TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
              MOVE 100                     TO S-APPL-RETURN-CODE        
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '6002'                  TO ACTIVE-PARAGRAPH          
              MOVE 'CALL'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                               ABEND-TABLES             
              MOVE MCSCB077                TO TABLE-1                   
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       6002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6300-LM001-CUST-LITE-SYNC.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDLM001                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 100                      TO S-APPL-RETURN-CODE       
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-ALL-FIX-ATT-CUR.                                     *        
      ******************************************************************        
       7100-OPEN-ALL-FIX-ATT-CUR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN ALL_FXTR_ATMS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 100                      TO S-APPL-RETURN-CODE       
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ '        TO TABLE-ELEMENT-1          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7101-FETCH-ALL-FIX-ATT-CUR.                                    *        
      ******************************************************************        
       7101-FETCH-ALL-FIX-ATT-CUR.                                      

MSQ008     MOVE 10 TO MSQ008-ALL-FXTR-ATMS
                                                                        
           EXEC SQL                                                     
               FOR :MSQ008-ALL-FXTR-ATMS
              FETCH 
              FROM ALL_FXTR_ATMS         
                INTO :TAB-ATTACH-EQUIP-SEQ                              
                    ,:TAB-EQUIP-TYPE-CD                                 
                    ,:TAB-EQUIP-TAG-NO                                  
                    ,:TAB-INSTALL-POINT-NO                              
                    ,:TAB-RATE-PLAN-NO                                  
                    ,:TAB-RATE-ITEM-CODE                                
                    ,:TAB-BILLING-FL                                    
                    ,:TAB-NO-BILL-REASON-CD                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH  NEXT ROWSET FROM ALL_FXTR_ATMS FOR 10 ROWS                
MFA-TR*         INTO :TAB-ATTACH-EQUIP-SEQ                                      
MFA-TR*             ,:TAB-EQUIP-TYPE-CD                                         
MFA-TR*             ,:TAB-EQUIP-TAG-NO                                          
MFA-TR*             ,:TAB-INSTALL-POINT-NO                                      
MFA-TR*             ,:TAB-RATE-PLAN-NO                                          
MFA-TR*             ,:TAB-RATE-ITEM-CODE                                        
MFA-TR*             ,:TAB-BILLING-FL                                            
MFA-TR*             ,:TAB-NO-BILL-REASON-CD                                     
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ALL-FXTR-ATMS
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           MOVE SQLERRD(3)                 TO WS-ATCHMNT-COUNT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                    AND WS-ATCHMNT-COUNT >  0                           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 100                     TO S-APPL-RETURN-CODE        
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7101'                  TO ACTIVE-PARAGRAPH          
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'LMS_FXTR_ATTACHMTS'    TO TABLE-1                   
              MOVE 'FXTR_EQUIP_SEQ '       TO TABLE-ELEMENT-1           
              MOVE 4H-FXTR-EQUIP-SEQ       TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7102-CLOSE-ALL-FIX-ATT-CUR.                                    *        
      *                                                                *        
      ******************************************************************        
       7102-CLOSE-ALL-FIX-ATT-CUR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE ALL_FXTR_ATMS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 100                  TO S-APPL-RETURN-CODE          
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7102'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_FXTR_ATTACHMTS' TO TABLE-1                     
               MOVE 'FXTR_EQUIP_SEQ '    TO TABLE-ELEMENT-1             
               MOVE 4H-FXTR-EQUIP-SEQ    TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CHECK-ACTIVE-CUST-PLAN.                                   *        
      ******************************************************************        
       7200-CHECK-ACTIVE-CUST-PLAN.                                     
                                                                        
           EXEC SQL                                                     
               SELECT  COUNT(*)                                         
                 INTO :WS-ACT-CUST-PLAN-CNT                             
                 FROM  CSS_CUST_PLAN      CP WITH(READUNCOMMITTED)              
                WHERE  CP.ACCOUNT_NO       = :WS-ACCOUNT-NO             
                  AND  CP.CODE_PLAN_STATUS = 'A'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COUNT(*)                                                 
MFA-TR*          INTO :WS-ACT-CUST-PLAN-CNT                                     
MFA-TR*          FROM  CSS_CUST_PLAN      CP                                    
MFA-TR*         WHERE  CP.ACCOUNT_NO       = :WS-ACCOUNT-NO                     
MFA-TR*           AND  CP.CODE_PLAN_STATUS = 'A'                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 100                  TO S-APPL-RETURN-CODE          
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7200'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_CUST_PLAN'      TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-CHECK-ACTIVE-METER-ENV.                                   *        
      ******************************************************************        
       7250-CHECK-ACTIVE-METER-ENV.                                     
                                                                        
           EXEC SQL                                                     
               SELECT  COUNT(*)                                         
                 INTO :WS-ACT-METER-ENV-CNT                             
                 FROM  CSS_MTRD_ENVRNMT     MN WITH(READUNCOMMITTED)            
                WHERE  MN.ACCOUNT_NO         = :WS-ACCOUNT-NO           
                  AND  MN.CODE_METER_STATUS <> 'K'                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COUNT(*)                                                 
MFA-TR*          INTO :WS-ACT-METER-ENV-CNT                                     
MFA-TR*          FROM  CSS_MTRD_ENVRNMT     MN                                  
MFA-TR*         WHERE  MN.ACCOUNT_NO         = :WS-ACCOUNT-NO                   
MFA-TR*           AND  MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 100                  TO S-APPL-RETURN-CODE          
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7250'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05084******************************************************************        
A05084* 7300-GET-ACCOUNT-STATUS.                                       *        
A05084******************************************************************        
A05084 7300-GET-ACCOUNT-STATUS.                                         
A05084                                                                  
A05084     EXEC SQL                                                     
A05084         SELECT  CODE_ACCT_STAT                                   
A05084           INTO :AT-CODE-ACCT-STAT                                
A05084           FROM  CSS_ACCOUNT        AT WITH(READUNCOMMITTED)              
A05084          WHERE  AT.ACCOUNT_NO         = :AT-ACCOUNT-NO           
A05084                                                           
A05084     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_ACCT_STAT                                           
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*          FROM  CSS_ACCOUNT        AT                                    
MFA-TR*         WHERE  AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05084                                                                  
A05084     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A05084                                                                  
A05084     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05084         CONTINUE                                                 
A05084     ELSE                                                         
A05084         MOVE 100                  TO S-APPL-RETURN-CODE          
A05084         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
A05084         MOVE '7300'               TO ACTIVE-PARAGRAPH            
A05084         MOVE 'SELECT'             TO ABEND-FUNCTION              
A05084         MOVE SPACES               TO ABEND-SQL-PREDICATES        
A05084                                      ABEND-TABLES                
A05084         MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
A05084         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
A05084         MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
A05084         PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
A05084     END-IF.                                                      
A05084                                                                  
A05084 7300-EXIT.                                                       
A05084     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS.                                        *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04771_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04771_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSR04771_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04771_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04771_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE 100                      TO S-APPL-RETURN-CODE       
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'Y'                      TO  WS-ERR-INSRT-R1         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04771_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
ACT082*****************************************************************         
ACT082* DELETE MNT ROWS TO AVOID -532 IN 8104                         *         
ACT082*****************************************************************         
ACT082*                                                                         
ACT082 8100-DELETE-MNT.                                                 
ACT082*                                                                         
ACT082                                                                  
ACT082      EXEC SQL                                                    
ACT082          DELETE FROM LMS_TRANS_HIST                              
ACT082           WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                        
ACT082      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT082                                                                  
ACT082      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
ACT082                                         S-RETURN-CODE.           
ACT082                                                                  
ACT082      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
ACT082         MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
ACT082                                         S-RETURN-CODE            
ACT082      ELSE                                                        
ACT082         MOVE 100                     TO S-APPL-RETURN-CODE       
ACT082         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
ACT082         MOVE SQLCODE                 TO ABEND-SQLCODE            
ACT082         MOVE SQLSTATE                TO ABEND-SQLSTATE           
ACT082         MOVE '8100'                  TO ACTIVE-PARAGRAPH         
ACT082         MOVE 'DELETE'                TO ABEND-FUNCTION           
ACT082         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
ACT082                                         ABEND-TABLES             
ACT082         MOVE 'LMS_TRANS_HIST'        TO TABLE-1                  
ACT082         MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
ACT082         MOVE 4D-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
ACT082         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
ACT082     END-IF.                                                      
ACT082                                                                  
ACT082 8100-EXIT.                                                       
ACT082     EXIT.                                                        
                                                                        
      *****************************************************************         
      * DELETE FIXTURE ATTACHMENTS                                    *         
      *****************************************************************         
      *                                                                         
       8101-DELETE-ATTACHMENTS.                                         
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM LMS_FXTR_ATTACHMTS                          
                 WHERE FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8101'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_FXTR_ATTACHMTS'    TO TABLE-1                  
               MOVE 'FXTR_EQUIP_SEQ'        TO TABLE-ELEMENT-1          
               MOVE 4H-FXTR-EQUIP-SEQ       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8102-UPDATE-EQUIP-CNT                                         *         
      *****************************************************************         
       8102-UPDATE-EQUIP-CNT.                                           
                                                                        
            EXEC SQL                                                    
               UPDATE  [4L]                             
                  SET  [4L].ORIG_TERM_CHRG_AM  = :4L-ORIG-TERM-CHRG-AM    
                      ,[4L].ACTL_TERM_CHRG_AM  = :4L-ACTL-TERM-CHRG-AM    
                      ,[4L].ACTL_CHRG_DT       =  
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                      ,[4L].CNTRCT_END_DT      =  
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                      ,[4L].CNTRCT_STATUS_CD   = 'T'                      
                      ,[4L].LAST_UPDATE_TS     =  
           CIS.CURRENT$TIMESTAMP()       
                      ,LAST_UPDATE_USERID    = :WS-USER-ID              
               FROM LMS_EQUIP_CONTRACT [4L]
                WHERE  [4L].EQUIP_SEQ          = :4L-EQUIP-SEQ            
                  AND  [4L].INSTALL_LOC_NO     = :4L-INSTALL-LOC-NO       
                  AND  [4L].CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )      
                  AND  [4L].ACCOUNT_NO         = :4L-ACCOUNT-NO           
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        UPDATE  LMS_EQUIP_CONTRACT 4L                                    
MFA-TR*           SET  4L.ORIG_TERM_CHRG_AM  = :4L-ORIG-TERM-CHRG-AM            
MFA-TR*               ,4L.ACTL_TERM_CHRG_AM  = :4L-ACTL-TERM-CHRG-AM            
MFA-TR*               ,4L.ACTL_CHRG_DT       =  CURRENT DATE                    
MFA-TR*               ,4L.CNTRCT_END_DT      =  CURRENT DATE                    
MFA-TR*               ,4L.CNTRCT_STATUS_CD   = 'T'                              
MFA-TR*               ,4L.LAST_UPDATE_TS     =  CURRENT TIMESTAMP               
MFA-TR*               ,LAST_UPDATE_USERID    = :WS-USER-ID                      
MFA-TR*         WHERE  4L.EQUIP_SEQ          = :4L-EQUIP-SEQ                    
MFA-TR*           AND  4L.INSTALL_LOC_NO     = :4L-INSTALL-LOC-NO               
MFA-TR*           AND  4L.CNTRCT_START_DT    = :4L-CNTRCT-START-DT              
MFA-TR*           AND  4L.ACCOUNT_NO         = :4L-ACCOUNT-NO                   
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8102'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_CONTRACT'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-2          
               MOVE 'CONTRACT_START_DT'     TO TABLE-ELEMENT-3          
               MOVE 4L-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               MOVE 4L-INSTALL-LOC-NO       TO HOSTVAR-ELEMENT-2        
               MOVE 4L-CNTRCT-START-DT      TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8103-DELETE-EQUIP-ENV.                                        *         
      *****************************************************************         
       8103-DELETE-EQUIP-ENV.                                           
                                                                        
            EXEC SQL                                                    
                DELETE FROM LMS_EQUIP_ENVRNMT                           
                 WHERE INSTALL_LOC_NO    = :4F-INSTALL-LOC-NO           
                   AND INSTALL_POINT_NO  = :4F-INSTALL-POINT-NO         
                   AND EQUIP_SEQ         = :4F-EQUIP-SEQ                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8103'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_ENVRNMT'     TO TABLE-1                  
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-1          
               MOVE 'INSTALL_POINT_NO'      TO TABLE-ELEMENT-2          
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-3          
               MOVE WS-INST-LOC-NO          TO HOSTVAR-ELEMENT-1        
               MOVE WS-INST-POINT-NO        TO HOSTVAR-ELEMENT-2        
               MOVE WS-FIX-EQ-SEQ           TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8103-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8104-DELETE-EQ-INV.                                           *         
      *****************************************************************         
       8104-DELETE-EQ-INV.                                              
                                                                        
            EXEC SQL                                                    
                DELETE FROM LMS_EQUIP_INVENTRY                          
                 WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8104'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_INVENTRY'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 4D-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8104-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8105-UPDATE-EQUIP-INV                                          *        
      ******************************************************************        
       8105-UPDATE-EQUIP-INV.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE [4D]                               
                 SET [4D].INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD     
                    ,[4D].LAST_UPDATE_USERID = :WS-USER-ID                
                    ,[4D].LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP()         
              FROM LMS_EQUIP_INVENTRY [4D]
               WHERE [4D].EQUIP_SEQ          = :4D-EQUIP-SEQ              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_INVENTRY       4D                                
MFA-TR*          SET 4D.INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD             
MFA-TR*             ,4D.LAST_UPDATE_USERID = :WS-USER-ID                        
MFA-TR*             ,4D.LAST_UPDATE_TS     =  CURRENT TIMESTAMP                 
MFA-TR*        WHERE 4D.EQUIP_SEQ          = :4D-EQUIP-SEQ                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '8105'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'LMS_EQUIP_INVENTRY'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 4D-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04771_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
           MOVE S-APPL-RETURN-CODE          TO S-APPL-RETURN-CODE-1.    
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
                                                                        
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    TRANSACTION HISTORY  COPYBOOK                               *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDLM002                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
            
MSQ016        GOBACK.                                                   
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
