       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04770.                                         
       AUTHOR.        SIVARAJAN.                                        
COB303 DATE-WRITTEN.  NOV 28,2014.                                      
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04770              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--  CSR04770 :                                                --         
      *--     UPDATE ROUTINE FOR LMS REPLACE FIXTURE WIZARD.         --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            I_ACCOUNT_NO             DECIMAL(13,0)          --         
      *--            I_REQUEST_NO             DECIMAL(13,0)          --         
      *--            I_O_FXTR_ACTION_CD       CHAR(01)               --         
      *--            I_O_FXTR_EQUIP_SEQ       DECIMAL(10,0)          --         
      *--            I_O_FXTR_EQUIP_TAG_NO    CHAR(12)               --         
      *--            I_O_FXTR_INST_LOC_NO     CHAR(10)               --         
      *--            I_O_FXTR_INST_POINT_NO   DECIMAL(5,0)           --         
      *--            I_O_FXTR_INST_LOC_CD     CHAR(01)               --         
      *--            I_O_FXTR_RATE_PLAN_NO    CHAR(03)               --         
      *--            I_O_FXTR_RATE_ITEM_CD    SMALLINT               --         
      *--            I_O_FXTR_BILLING_FL      CHAR(01)               --         
      *--            I_FXTR_NO_BILL_RSN_CD    CHAR(02)               --         
      *--            I_O_TERMINATE_CNTRCT_FL  CHAR(01)               --         
      *--            I_O_CNTRCT_START_DT      CHAR(10)               --         
      *--            I_O_ORIG_TERM_CHRG_AM    CHAR(08)               --         
      *--            I_O_ACTL_TERM_CHRG_AM    CHAR(08)               --         
      *--            I_O_CNTRCT_CLP_NO        CHAR(50)               --         
      *--            I_O_TERM_CHRG_OVR_COMMENTS VARCHAR(250)         --         
      *--            I_N_FXTR_EQUIP_SEQ       DECIMAL(10,0)          --         
      *--            I_N_FXTR_EQUIP_TAG_NO    CHAR(12)               --         
      *--            I_N_FXTR_STOCK_CD        CHAR(15)               --         
      *--            I_POLE_ACTION_CD         CHAR(01)               --         
      *--            I_N_POLE_STOCK_CD        CHAR(15)               --         
      *--            I_N_POLE_EQUIP_TAG_NO    CHAR(12)               --         
      *--            I_N_POLE_RATE_PLAN_NO    CHAR(03)               --         
      *--            I_N_POLE_RATE_ITEM_CD    SMALLINT               --         
      *--            I_N_POLE_CODE_REVENUE_CLASS CHAR(03)            --         
      *--            I_N_CREATE_CNTRCT_FL     CHAR(01)               --         
      *--            I_N_CNTRCT_CLP_NO        CHAR(50)               --         
      *--            I_N_CNTRCT_DURATION_CD   CHAR(02)               --         
      *--            I_N_CNTRCT_START_DT      CHAR(10)               --         
      *--            I_N_CNTRCT_END_DT        CHAR(10)               --         
      *--            I_N_NO_CONTRACT_RSN_CD   CHAR(02)               --         
      *--            I_REQUEST_NA_COMMENTS    VARCHAR(250)           --         
      *--            I_USER_ID                CHAR(07)               --         
ACT069*--            I_EFFECTIVE_DT           CHAR(10)               --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  CSR04770_R1 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--            RETURN_CODE          INTEGER                    --         
      *--            APPL_RETURN_CODE     INTEGER                    --         
      *--            BUS_RULE_ID          CHAR(10)                   --         
      *--            BUS_RULE_RESULT_CD   CHAR(10)                   --         
      *--            BUS_RULE_XREF_ID     CHAR(26)                   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  11/28/2014    SV95326     INITIAL VERSION.                --         
      *--  04/20/2015    HA7A338     CALL CPDLM001 FOR INACTIVE      --         
      *--                            SCENARIOS WHEN RATE/RATE ITEM   --         
      *--                            CODE EXISTS FOR OLD FXTR/PLE    --         
 A5084*--  06/02/2015    SS95855     ACT039 POPULATE CORRECT FIXTURE --         
      *--                            ID IN TRANSACTION HISTORY.      --         
A#5084*--  06/19/15      SS95855     ACT040 CLP# CHANGED TO CHAR(50) --         
A#5084*--  12/07/15      SV95326     ACT069 ADD EFFECTIVE DATE IN    --         
      *--                            RRT SCREEN AS A NEW INPUT.      --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-ALL-FXTR-ATMS  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04770'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE SQLCA                                                  
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_FXTR_ATTACHMTS, 4H                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXTATC                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_EQUIP_INVENTRY, 4D                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBEQPINV                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_EQUIP_ENVRNMT, 4F                                         *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBEQPIVT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_EQUIP_CONTRACT, 4L                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBEQPCNT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_MSTR_STCK_INFO  4A                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMSTINF                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY     C8                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM        G6                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBJBPARM                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_TRANS_HIST,     4J                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLGTHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * LMS_TRANS_HIST_DET, 4S                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBLMSHST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *** CSS_MNT_TRANS_HIST, MH                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *** CSS_MT_TRN_HST_DET, MI                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS FOR LMS CONTRACT ROUTINE MCSCB822                *        
      ******************************************************************        
           COPY CWS04822.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS FOR LMS TO BILLING SYNC COPYBOOK CPDLM001        *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSLM001                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01 WS-WORKING-STORAGE.                                           
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-GTT-NAME             PIC X(30) VALUE SPACES.            
                                                                        
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04770'.        
          05 MCSCB822                PIC X(08) VALUE 'MCSCB822'.        
          05 WS-POLE                 PIC X(01) VALUE 'P'.               
          05 WS-NODE                 PIC X(01) VALUE 'N'.               
          05 WS-N                    PIC X(01) VALUE 'N'.               
          05 WS-Y                    PIC X(01) VALUE 'Y'.               
          05 USE-EXISTING            PIC X(01) VALUE 'U'.               
          05 ADD-NEW-POLE            PIC X(01) VALUE 'A'.               
          05 WS-Y                    PIC X(01) VALUE 'Y'.               
          05 GTT-NAME                PIC X(26)                          
                                            VALUE 'SESSION.CSR04770_R1'.
      *                                                                         
       01 NULL-INDICATORS.                                              
          05  WS-NULL-EQUIP-MFR-DT   PIC S9(4) COMP VALUE -1.           
          05  WS-NULL-WARR-EXP-DT    PIC S9(4) COMP VALUE -1.           
          05  WS-NULL-EQUIP-DISP-DT  PIC S9(4) COMP VALUE -1.           
          05  WS-NULL-ACTL-CHRG-DT   PIC S9(4) COMP VALUE -1.           
      *                                                                         
       01 COUNTER-FIELDS.                                               
          05  CTR-ROWS-RS1           PIC S9(4) COMP VALUE 0.            
          05  WS-ATTMNT-MAX-COUNT    PIC S9(4) COMP VALUE 10.           
          05  WS-TRAN-LENGTH         PIC S9(4) COMP VALUE 0.            
          05  WS-ATCHMNT-COUNT       PIC 9(05) VALUE 0.                 
      *                                                                         
       01  WS-TERM-CHG.                                                 
           05  WS-TERM-CHRG-AMT-TXT.                                    
               10  WS-TERM-CHRG-AMT-SI      PIC X(01) VALUE SPACES.     
               10  WS-TERM-CHRG-AMT-AM      PIC X(07) VALUE SPACES.     
           05  WS-TERM-CHRG-AMT-TXT1        PIC X(07) VALUE SPACES.     
           05  WS-TERM-CHRG-AMT-NUM REDEFINES WS-TERM-CHRG-AMT-TXT1     
                                            PIC 9(05)V99.               
           05  WS-TERM-CHRG-AMT-COMP        PIC S9(5)V9(2).             
           05  WS-TERM-CHRG-AMT-HST         PIC -----9(01).9(02).       
      *                                                                         
       01  WS-ORIG-TERM-CHRG.                                           
           05  WS-ORIG-TERM-CHRG-TXT.                                   
               10  WS-ORIG-TERM-CHRG-SI     PIC X(01) VALUE SPACES.     
               10  WS-ORIG-TERM-CHRG-AM     PIC X(07) VALUE SPACES.     
           05  WS-ORIG-TERM-CHRG-TXT1       PIC X(07) VALUE SPACES.     
           05  WS-ORIG-TERM-CHRG-NUM REDEFINES WS-ORIG-TERM-CHRG-TXT1   
                                            PIC 9(05)V99.               
           05  WS-ORIG-TERM-CHRG-COMP       PIC S9(5)V9(2).             
           05  WS-ORIG-TERM-CHRG-HST        PIC -----9(01).9(02).       
      *                                                                         
       01 WS-INDEX-VARS.                                                
          05  WS-TAB-INDX            PIC S9(4) COMP VALUE 0.            
      *                                                                         
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
      *                                                                         
       01  WS-ALL-FXTR-ATTACHMENTS.                                     
           05  TAB-ATTACH-EQUIP-SEQ         OCCURS 10 TIMES             
                                            PIC S9(10)V USAGE COMP-3    
                                                      VALUE 0.          
           05  TAB-EQUIP-TYPE-CD            OCCURS 10 TIMES PIC X(01)   
                                                      VALUE SPACES.     
           05  TAB-EQUIP-TAG-NO             OCCURS 10 TIMES PIC X(12)   
                                                      VALUE SPACES.     
           05  TAB-RATE-PLAN-NO             OCCURS 10 TIMES PIC X(03)   
                                                      VALUE SPACES.     
           05  TAB-RATE-ITEM-CODE           OCCURS 10 TIMES PIC S9(4)   
                                                  USAGE COMP VALUE 0.   
           05  TAB-BILLING-FL               OCCURS 10 TIMES PIC X(01)   
                                                      VALUE SPACES.     
           05  TAB-NO-BILL-REASON-CD        OCCURS 10 TIMES PIC X(02)   
                                                      VALUE SPACES.     
           05  TAB-INSTALL-POINT-NO         OCCURS 10 TIMES             
                                            PIC S9(05)V USAGE COMP-3    
                                                      VALUE 0.          
           05  TAB-ATTACH-EQUIP-DATE        OCCURS 10 TIMES PIC X(10)   
                                                      VALUE SPACES.     
      *                                                                         
       01 WS-MISC-FIELDS.                                               
          05 WS-OLD-FX-INST-LOC-NO   PIC X(10)  VALUE SPACES.           
          05 WS-LMS-CNTR-ITEM-ID     PIC X(09)  VALUE SPACES.           
          05 WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.           
          05 WS-NEW-EQUIP-SEQ        PIC S9(10)V USAGE COMP-3 VALUE 0.  
          05 WS-MAX-INS-POINT-NO     PIC S9(05)V USAGE COMP-3 VALUE 0.  
          05 WS-FIX-EQ-SEQ           PIC S9(10)V USAGE COMP-3 VALUE 0.  
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE           PIC S9(04) COMP VALUE 0.           
          05 S-APPL-RETURN-CODE      PIC S9(04) COMP VALUE 0.           
      ****************************************************************          
      *   GTT TABLE LAYOUT FOR BUS RULE AND IC NO                    *          
      ****************************************************************          
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1      PIC S9(04) COMP VALUE 0.           
             10 S-APPL-RETURN-CODE-1 PIC S9(04) COMP VALUE 0.           
             10 S-RS1-BUS-RULE-ID    PIC X(10)  VALUE SPACES.           
             10 S-RS1-BUS-RULE-RESULT-CD                                
                                     PIC X(10)  VALUE SPACES.           
             10 S-RS1-BUS-RULE-XREF-ID                                  
                                     PIC X(26)  VALUE SPACES.           
      *                                                                         
      ****************************************************************          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME            PIC X(18)  VALUE SPACES.           
            10  S-SQLCODE            PIC S9(9) COMP VALUE 0.            
            10  S-SQLSTATE           PIC X(5)   VALUE ' '.              
            10  S-TABLE-NAME         PIC X(18)  VALUE SPACES.           
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE ALL_FXTR_ATMS CURSOR WITH ROWSET POSITIONING FOR  
                 SELECT  [4H].ATTACH_EQUIP_SEQ                            
                        ,[4D].EQUIP_TYPE_CD                               
                        ,[4D].EQUIP_TAG_NO                                
                        ,COALESCE([4F].INSTALL_POINT_NO,0)                  
                        ,COALESCE([4F].RATE_PLAN_NO,'')                     
                        ,COALESCE([4F].RATE_ITEM_CODE,0)                    
                        ,COALESCE([4F].BILLING_FL,'')                       
                        ,COALESCE([4F].NO_BILL_REASON_CD,'')                
                        ,[4H].ATTACH_EQUIP_DT                             
                   FROM LMS_FXTR_ATTACHMTS [4H]
                           WITH(READUNCOMMITTED)      JOIN                 
                        LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                 ON ([4H].FXTR_EQUIP_SEQ         = :4H-FXTR-EQUIP-SEQ     
                    AND  [4D].EQUIP_SEQ          = [4H].ATTACH_EQUIP_SEQ    
                    AND  [4D].EQUIP_TYPE_CD      = [4H].EQUIP_TYPE_CD       
                    AND  [4D].INVENTRY_STATUS_CD =  'J')  LEFT JOIN       
                         LMS_EQUIP_ENVRNMT   [4F] WITH(READUNCOMMITTED)         
                     ON ([4F].EQUIP_SEQ          = [4H].ATTACH_EQUIP_SEQ    
                    AND  [4F].INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO)    
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ALL_FXTR_ATMS CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*          SELECT  4H.ATTACH_EQUIP_SEQ                                    
MFA-TR*                 ,4D.EQUIP_TYPE_CD                                       
MFA-TR*                 ,4D.EQUIP_TAG_NO                                        
MFA-TR*                 ,IFNULL(4F.INSTALL_POINT_NO,0)                          
MFA-TR*                 ,IFNULL(4F.RATE_PLAN_NO,'')                             
MFA-TR*                 ,IFNULL(4F.RATE_ITEM_CODE,0)                            
MFA-TR*                 ,IFNULL(4F.BILLING_FL,'')                               
MFA-TR*                 ,IFNULL(4F.NO_BILL_REASON_CD,'')                        
MFA-TR*                 ,4H.ATTACH_EQUIP_DT                                     
MFA-TR*            FROM LMS_FXTR_ATTACHMTS 4H      JOIN                         
MFA-TR*                 LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*          ON (4H.FXTR_EQUIP_SEQ         = :4H-FXTR-EQUIP-SEQ             
MFA-TR*             AND  4D.EQUIP_SEQ          = 4H.ATTACH_EQUIP_SEQ            
MFA-TR*             AND  4D.EQUIP_TYPE_CD      = 4H.EQUIP_TYPE_CD               
MFA-TR*             AND  4D.INVENTRY_STATUS_CD =  'J')  LEFT JOIN               
MFA-TR*                  LMS_EQUIP_ENVRNMT   4F                                 
MFA-TR*              ON (4F.EQUIP_SEQ          = 4H.ATTACH_EQUIP_SEQ            
MFA-TR*             AND  4F.INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO)            
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
COB305 01 PARM-REQUEST-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
       01  PARM-O-FXTR-ACTION-CD            PIC X(01).                  
COB305 01 PARM-O-FXTR-EQUIP-SEQ        PIC S9(10)V USAGE COMP-3 VALUE 0.   
       01  PARM-O-FXTR-EQUIP-TAG-NO         PIC X(12).                  
       01  PARM-O-FXTR-INST-LOC-NO          PIC X(10).                  
COB305 01 PARM-O-FXTR-INST-POINT-NO        PIC S9(05)V USAGE COMP-3 
COB305       VALUE 0.   
       01  PARM-O-FXTR-INST-LOC-CD          PIC X(01).                  
       01  PARM-O-FXTR-RATE-PLAN-NO         PIC X(03).                  
       01  PARM-O-FXTR-RATE-ITEM-CD         PIC S9(4) COMP.             
       01  PARM-O-FXTR-BILLING-FL           PIC X(01).                  
       01  PARM-O-FXTR-NO-BILL-RSN-CD       PIC X(02).                  
       01  PARM-O-TERMINATE-CNTRCT-CD       PIC X(01).                  
       01  PARM-O-CNTRCT-START-DT           PIC X(10).                  
       01  PARM-O-ORIG-TERM-CHRG-AM         PIC X(08).                  
       01  PARM-O-ACTL-TERM-CHRG-AM         PIC X(08).                  
ACT040 01  PARM-O-CNTRCT-CLP-NO             PIC X(50).                  
       01  PARM-O-TERM-CHRG-OVR-COMMENTS.                               
           05  PARM-O-TERM-CHRG-OVR-CMT-LEN PIC S9(04) COMP.            
           05  PARM-O-TERM-CHRG-OVR-CMT-TXT PIC X(248).                 
COB305 01 PARM-N-FXTR-EQUIP-SEQ        PIC S9(10)V USAGE COMP-3 VALUE 0.   
       01  PARM-N-FXTR-EQUIP-TAG-NO         PIC X(12).                  
       01  PARM-N-FXTR-STOCK-CD             PIC X(15).                  
       01  PARM-POLE-ACTION-CD              PIC X(01).                  
       01  PARM-N-POLE-STOCK-CD             PIC X(15).                  
       01  PARM-N-POLE-EQUIP-TAG-NO         PIC X(12).                  
       01  PARM-N-POLE-RATE-PLAN-NO         PIC X(03).                  
       01  PARM-N-POLE-RATE-ITEM-CD         PIC S9(4) COMP.             
       01  PARM-N-POLE-CODE-REVENUE-CLASS   PIC X(03).                  
       01  PARM-N-CREATE-CNTRCT-FL          PIC X(01).                  
ACT040 01  PARM-N-CNTRCT-CLP-NO             PIC X(50).                  
       01  PARM-N-CNTRCT-DURATION-CD        PIC X(02).                  
       01  PARM-N-CNTRCT-START-DT           PIC X(10).                  
       01  PARM-N-CNTRCT-END-DT             PIC X(10).                  
       01  PARM-N-NO-CONTRACT-RSN-CD        PIC X(02).                  
       01  PARM-REQUEST-NA-COMMENTS.                                    
           05  PARM-REQUEST-NA-CMT-LEN      PIC S9(04) COMP.            
           05  PARM-REQUEST-NA-CMT-TXT      PIC X(248).                 
       01  PARM-USER-ID                     PIC X(07).                  
ACT069 01  PARM-EFFECTIVE-DT                PIC X(10) VALUE SPACES.     
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                               ,PARM-REQUEST-NO                         
                               ,PARM-O-FXTR-ACTION-CD                   
                               ,PARM-O-FXTR-EQUIP-SEQ                   
                               ,PARM-O-FXTR-EQUIP-TAG-NO                
                               ,PARM-O-FXTR-INST-LOC-NO                 
                               ,PARM-O-FXTR-INST-POINT-NO               
                               ,PARM-O-FXTR-INST-LOC-CD                 
                               ,PARM-O-FXTR-RATE-PLAN-NO                
                               ,PARM-O-FXTR-RATE-ITEM-CD                
                               ,PARM-O-FXTR-BILLING-FL                  
                               ,PARM-O-FXTR-NO-BILL-RSN-CD              
                               ,PARM-O-TERMINATE-CNTRCT-CD              
                               ,PARM-O-CNTRCT-START-DT                  
                               ,PARM-O-ORIG-TERM-CHRG-AM                
                               ,PARM-O-ACTL-TERM-CHRG-AM                
                               ,PARM-O-CNTRCT-CLP-NO                    
                               ,PARM-O-TERM-CHRG-OVR-COMMENTS           
                               ,PARM-N-FXTR-EQUIP-SEQ                   
                               ,PARM-N-FXTR-EQUIP-TAG-NO                
                               ,PARM-N-FXTR-STOCK-CD                    
                               ,PARM-POLE-ACTION-CD                     
                               ,PARM-N-POLE-STOCK-CD                    
                               ,PARM-N-POLE-EQUIP-TAG-NO                
                               ,PARM-N-POLE-RATE-PLAN-NO                
                               ,PARM-N-POLE-RATE-ITEM-CD                
                               ,PARM-N-POLE-CODE-REVENUE-CLASS          
                               ,PARM-N-CREATE-CNTRCT-FL                 
                               ,PARM-N-CNTRCT-CLP-NO                    
                               ,PARM-N-CNTRCT-DURATION-CD               
                               ,PARM-N-CNTRCT-START-DT                  
                               ,PARM-N-CNTRCT-END-DT                    
                               ,PARM-N-NO-CONTRACT-RSN-CD               
                               ,PARM-REQUEST-NA-COMMENTS                
                               ,PARM-USER-ID                            
ACT069                         ,PARM-EFFECTIVE-DT.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04770_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04770_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04770_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04770_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04770_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO            TO 4L-ACCOUNT-NO.            
           MOVE PARM-O-FXTR-ACTION-CD      TO 4D-INVENTRY-STATUS-CD.    
           MOVE PARM-O-FXTR-EQUIP-SEQ      TO WS-FIX-EQ-SEQ             
                                              4H-FXTR-EQUIP-SEQ         
                                              4L-EQUIP-SEQ.             
           MOVE PARM-O-FXTR-EQUIP-TAG-NO   TO 4D-EQUIP-TAG-NO.          
           MOVE PARM-O-FXTR-INST-LOC-NO    TO WS-OLD-FX-INST-LOC-NO     
                                              4F-INSTALL-LOC-NO         
                                              4L-INSTALL-LOC-NO.        
           MOVE PARM-O-FXTR-INST-POINT-NO  TO 4F-INSTALL-POINT-NO.      
           MOVE PARM-O-CNTRCT-START-DT     TO 4L-CNTRCT-START-DT.       
                                                                        
           MOVE PARM-O-ACTL-TERM-CHRG-AM   TO WS-TERM-CHRG-AMT-TXT.     
           MOVE WS-TERM-CHRG-AMT-AM        TO WS-TERM-CHRG-AMT-TXT1.    
                                                                        
           IF WS-TERM-CHRG-AMT-AM = '-'                                 
              COMPUTE WS-TERM-CHRG-AMT-COMP = WS-TERM-CHRG-AMT-NUM  * -1
           ELSE                                                         
              COMPUTE WS-TERM-CHRG-AMT-COMP = WS-TERM-CHRG-AMT-NUM  * 1 
           END-IF.                                                      
                                                                        
           MOVE PARM-O-ORIG-TERM-CHRG-AM   TO WS-ORIG-TERM-CHRG-TXT.    
           MOVE WS-ORIG-TERM-CHRG-AM       TO WS-ORIG-TERM-CHRG-TXT1.   
                                                                        
           IF WS-ORIG-TERM-CHRG-SI = '-'                                
              COMPUTE WS-ORIG-TERM-CHRG-COMP                            
                      EQUAL WS-ORIG-TERM-CHRG-NUM  * -1                 
           ELSE                                                         
              COMPUTE WS-ORIG-TERM-CHRG-COMP                            
                      EQUAL WS-ORIG-TERM-CHRG-NUM  * 1                  
           END-IF.                                                      
                                                                        
           MOVE 01                         TO WS-TAB-INDX.              
           MOVE 0                          TO 4L-FIXTURE-COST-AM        
                                              4L-POLE-COST-AM.          
           PERFORM 7000-GET-CURRENT-DATE      THRU 7000-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2001-PROCESS-OLD-DETAILS    THRU 2001-EXIT.          
                                                                        
           PERFORM 2002-PROCESS-NEW-DETAILS    THRU 2002-EXIT.          
                                                                        
           PERFORM 2500-MOVE-RESULT            THRU 2500-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2001-PROCESS-OLD-DETAILS.                                      *        
      ******************************************************************        
       2001-PROCESS-OLD-DETAILS.                                        
      *                                                                         
                                                                        
           MOVE PARM-O-FXTR-EQUIP-SEQ  TO 4D-EQUIP-SEQ.                 
           PERFORM 8105-UPDATE-EQUIP-INV       THRU 8105-EXIT.          
                                                                        
           PERFORM 7100-OPEN-ALL-FIX-ATT-CUR   THRU 7100-EXIT.          
           PERFORM 7101-FETCH-ALL-FIX-ATT-CUR  THRU 7101-EXIT.          
           PERFORM 7102-CLOSE-ALL-FIX-ATT-CUR  THRU 7102-EXIT.          
      *                                                                         
           PERFORM 8101-DELETE-ATTACHMENTS     THRU 8101-EXIT.          
                                                                        
           PERFORM 2100-PROCESS-OLD-ATTACHMENTS     THRU 2100-EXIT      
                   UNTIL WS-TAB-INDX > WS-ATTMNT-MAX-COUNT              
                         OR TAB-EQUIP-TYPE-CD(WS-TAB-INDX) = SPACES.    
                                                                        
           PERFORM 2300-PROCESS-OLD-CONTRACT   THRU 2300-EXIT           
                                                                        
           PERFORM 5000-WRITE-TRANS-HIST       THRU 5000-EXIT.          
                                                                        
       2001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2002-PROCESS-NEW-DETAILS.                                      *        
      ******************************************************************        
       2002-PROCESS-NEW-DETAILS.                                        
      *                                                                         
           MOVE 'J'                     TO 4D-INVENTRY-STATUS-CD.       
           MOVE PARM-N-FXTR-EQUIP-SEQ   TO 4D-EQUIP-SEQ.                
           PERFORM 8105-UPDATE-EQUIP-INV       THRU 8105-EXIT.          
           PERFORM 8106-RPL-EQ-ENV-OLD-FX      THRU 8106-EXIT.          
                                                                        
           MOVE 01                      TO WS-TAB-INDX.                 
           IF PARM-POLE-ACTION-CD = 'U'                                 
              MOVE 1                    TO 4H-ATTACH-SEQ-NO             
              PERFORM 2101-PROCESS-UPD-NEW-ATTACH THRU 2101-EXIT        
                   UNTIL WS-TAB-INDX > WS-ATTMNT-MAX-COUNT              
                         OR TAB-EQUIP-TYPE-CD(WS-TAB-INDX) = SPACES     
              INITIALIZE 4H-ATTACH-EQUIP-SEQ                            
                         4H-ATTACH-EQUIP-DT                             
                         4H-EQUIP-TYPE-CD                               
           END-IF.                                                      
                                                                        
           IF PARM-POLE-ACTION-CD = 'A'                                 
              PERFORM 2102-PROCESS-ADD-NEW-ATTACH THRU 2102-EXIT        
           END-IF.                                                      
                                                                        
           IF PARM-N-CREATE-CNTRCT-FL = 'Y'                             
              PERFORM 2301-PROCESS-NEW-CONTRACT THRU 2301-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 5701-WRITE-TRANS-HIST-NEW    THRU 5701-EXIT.         
                                                                        
       2002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-OLD-ATTACHMENTS                                   *        
      ******************************************************************        
       2100-PROCESS-OLD-ATTACHMENTS.                                    
                                                                        
            EVALUATE TAB-EQUIP-TYPE-CD(WS-TAB-INDX)                     
                WHEN 'P'                                                
                   MOVE TAB-ATTACH-EQUIP-SEQ(WS-TAB-INDX)               
                                                   TO 4D-EQUIP-SEQ      
                                                      4F-EQUIP-SEQ      
                   MOVE TAB-INSTALL-POINT-NO (WS-TAB-INDX) TO           
                                                   4F-INSTALL-POINT-NO  
                   IF PARM-POLE-ACTION-CD = 'A'                         
                      IF (TAB-BILLING-FL(WS-TAB-INDX)     = 'Y')        
                                        OR                              
                         (TAB-BILLING-FL(WS-TAB-INDX)     = 'N'  AND    
                          TAB-RATE-PLAN-NO(WS-TAB-INDX)   > ' '  AND    
                          TAB-RATE-ITEM-CODE(WS-TAB-INDX) >  0 )        
                         PERFORM 2400-REM-POLE-CUST-PLAN THRU 2400-EXIT 
                         PERFORM 8104-DELETE-EQ-INV      THRU 8104-EXIT 
                      ELSE                                              
                         PERFORM 8103-DELETE-EQUIP-ENV   THRU 8103-EXIT 
                         PERFORM 8104-DELETE-EQ-INV      THRU 8104-EXIT 
                      END-IF                                            
                   END-IF                                               
                                                                        
                WHEN 'N'                                                
                   MOVE TAB-ATTACH-EQUIP-SEQ(WS-TAB-INDX)               
                                                   TO 4D-EQUIP-SEQ      
                   PERFORM 8105-UPDATE-EQUIP-INV      THRU 8105-EXIT    
           END-EVALUATE.                                                
                                                                        
           ADD 1                                   TO WS-TAB-INDX.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2101-PROCESS-UPD-NEW-ATTACH.                                   *        
      ******************************************************************        
       2101-PROCESS-UPD-NEW-ATTACH.                                     
                                                                        
           IF TAB-EQUIP-TYPE-CD(WS-TAB-INDX) = 'P'                      
              MOVE PARM-N-FXTR-EQUIP-SEQ   TO 4H-FXTR-EQUIP-SEQ         
              MOVE TAB-EQUIP-TYPE-CD(WS-TAB-INDX)     TO                
                                              4H-EQUIP-TYPE-CD          
              MOVE TAB-ATTACH-EQUIP-SEQ(WS-TAB-INDX)  TO                
                                              4H-ATTACH-EQUIP-SEQ       
              MOVE TAB-ATTACH-EQUIP-DATE(WS-TAB-INDX) TO                
                                              4H-ATTACH-EQUIP-DT        
              MOVE PARM-USER-ID            TO 4H-LAST-UPDATE-USERID     
                                                                        
              PERFORM 8109-RPL-POLES-NEW-FX-ATT THRU 8109-EXIT          
           END-IF.                                                      
                                                                        
           ADD 1                           TO WS-TAB-INDX.              
                                                                        
       2101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2102-PROCESS-ADD-NEW-ATTACH.                                   *        
      ******************************************************************        
       2102-PROCESS-ADD-NEW-ATTACH.                                     
                                                                        
           PERFORM 7104-GET-NEW-EQUIP-SEQ      THRU 7104-EXIT.          
           PERFORM 7106-GET-MAX-INS-POINT      THRU 7106-EXIT.          
           COMPUTE WS-MAX-INS-POINT-NO = WS-MAX-INS-POINT-NO + 1.       
                                                                        
           MOVE PARM-N-POLE-STOCK-CD        TO 4A-STOCK-CD.             
           MOVE WS-POLE                     TO 4A-EQUIP-TYPE-CD.        
           PERFORM 7105-GET-MSTR-STK-INFO      THRU 7105-EXIT.          
           MOVE 4A-EQUIPMENT-COST-AM        TO 4L-POLE-COST-AM.         
                                                                        
           PERFORM 8110-ADD-NEW-POLE-EQ-INV    THRU 8110-EXIT.          
                                                                        
           IF PARM-N-POLE-RATE-PLAN-NO > SPACES AND                     
              PARM-N-POLE-RATE-ITEM-CD > 0                              
              MOVE 'Z'                      TO 4F-BILLING-FL            
           ELSE                                                         
              MOVE 'N'                      TO 4F-BILLING-FL            
           END-IF.                                                      
                                                                        
           PERFORM 8112-ADD-NEW-POLE-EQ-ENV    THRU 8112-EXIT.          
                                                                        
           MOVE 1                           TO 4H-ATTACH-SEQ-NO.        
           MOVE PARM-N-FXTR-EQUIP-SEQ       TO 4H-FXTR-EQUIP-SEQ.       
           MOVE WS-POLE                     TO 4H-EQUIP-TYPE-CD.        
           MOVE WS-NEW-EQUIP-SEQ            TO 4H-ATTACH-EQUIP-SEQ.     
           MOVE WS-CURRENT-DATE             TO 4H-ATTACH-EQUIP-DT.      
           MOVE PARM-USER-ID                TO 4H-LAST-UPDATE-USERID.   
                                                                        
           PERFORM 8109-RPL-POLES-NEW-FX-ATT   THRU 8109-EXIT.          
                                                                        
           IF 4F-BILLING-FL = 'Z'                                       
              PERFORM 2450-ADD-POLE-CUST-PLAN  THRU 2450-EXIT           
           END-IF.                                                      
                                                                        
       2102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS CONTRACT TERMINATION                                   *        
      ******************************************************************        
       2300-PROCESS-OLD-CONTRACT.                                       
                                                                        
            MOVE PARM-ACCOUNT-NO            TO 4L-ACCOUNT-NO.           
            MOVE WS-ORIG-TERM-CHRG-COMP     TO 4L-ORIG-TERM-CHRG-AM.    
            MOVE WS-TERM-CHRG-AMT-COMP      TO 4L-ACTL-TERM-CHRG-AM.    
            IF PARM-O-TERMINATE-CNTRCT-CD = 'R'                         
               PERFORM 7103-GET-OLD-EQ-CNT-PREV      THRU 7103-EXIT     
               PERFORM 8108-UPDATE-REPLACE-EQUIP-CNT THRU 8108-EXIT     
            END-IF.                                                     
                                                                        
            IF PARM-O-TERMINATE-CNTRCT-CD = 'T'                         
               PERFORM 7103-GET-OLD-EQ-CNT-PREV      THRU 7103-EXIT     
               PERFORM 8102-UPDATE-TERM-EQUIP-CNT    THRU 8102-EXIT     
               IF WS-TERM-CHRG-AMT-COMP > 0                             
                  PERFORM 6001-CREATE-LMS-CONTRACT   THRU 6001-EXIT     
               END-IF                                                   
            END-IF.                                                     
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * PROCESS CONTRACT TERMINATION                                   *        
      ******************************************************************        
       2301-PROCESS-NEW-CONTRACT.                                       
                                                                        
            MOVE PARM-ACCOUNT-NO               TO 4L-ACCOUNT-NO.        
            MOVE 'F'                           TO 4A-EQUIP-TYPE-CD.     
            MOVE PARM-N-FXTR-STOCK-CD          TO 4A-STOCK-CD           
            PERFORM 7105-GET-MSTR-STK-INFO        THRU 7105-EXIT.       
            MOVE 4A-EQUIPMENT-COST-AM          TO 4L-FIXTURE-COST-AM.   
            IF PARM-N-CREATE-CNTRCT-FL    = 'Y'                         
               MOVE PARM-N-CNTRCT-START-DT     TO 4L-CNTRCT-START-DT    
               MOVE PARM-N-CNTRCT-END-DT       TO 4L-CNTRCT-END-DT      
               MOVE PARM-N-CNTRCT-DURATION-CD  TO 4L-CNTRCT-DURATION-CD 
               MOVE PARM-N-CNTRCT-CLP-NO       TO 4L-CNTRCT-CLP-NO      
               PERFORM 8111-INS-NEW-EQ-CNT        THRU 8111-EXIT        
            ELSE                                                        
               IF PARM-O-TERMINATE-CNTRCT-CD = 'R' OR                   
                  PARM-O-TERMINATE-CNTRCT-CD = 'T'                      
               MOVE WS-CURRENT-DATE            TO 4L-CNTRCT-START-DT    
               PERFORM 8111-INS-NEW-EQ-CNT        THRU 8111-EXIT        
            END-IF
            END-IF.                                                     
                                                                        
       2301-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-REM-POLE-CUST-PLAN.                                       *        
      ******************************************************************        
       2400-REM-POLE-CUST-PLAN.                                         
                                                                        
            INITIALIZE LM001-INPUT.                                     
                                                                        
            MOVE 'R'                        TO LM001-ACTION-CODE        
            MOVE PARM-ACCOUNT-NO            TO LM001-ACCOUNT-NO         
            MOVE PARM-O-FXTR-INST-LOC-NO    TO LM001-INSTALL-LOC-NO     
            MOVE 4F-INSTALL-POINT-NO        TO LM001-INSTALL-POINT-NO   
ACT069*     MOVE WS-CURRENT-DATE            TO LM001-ACTION-DATE                
ACT069      MOVE PARM-EFFECTIVE-DT          TO LM001-ACTION-DATE        
            MOVE PARM-USER-ID               TO LM001-USER-ID            
            MOVE PROGRAM-NAME               TO LM001-PROGRAM-NAME       
                                                                        
            PERFORM 6300-LM001-CUST-LIGHT-SYNC THRU 6300-LM001-EXIT.    
                                                                        
            IF LM001-ERROR                                              
               MOVE LM001-ERR-SQLCODE       TO WS-ACTIVE-RETURN-CODE    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE LM001-BUS-RULE-ID       TO S-RS1-BUS-RULE-ID        
               MOVE 'F'                     TO S-RS1-BUS-RULE-RESULT-CD 
               MOVE 'CPDLM001'              TO ABEND-PROGRAM            
               MOVE LM001-ERR-PARAGRAPH-NO  TO ACTIVE-PARAGRAPH         
               MOVE LM001-ERR-FUNCTION      TO ABEND-FUNCTION           
               MOVE LM001-ERR-TABLE1        TO TABLE-1                  
               MOVE LM001-ERR-TABLE2        TO TABLE-2                  
               MOVE LM001-ERR-COLUMN-1      TO TABLE-ELEMENT-1          
               MOVE LM001-ERR-COLUMN-2      TO TABLE-ELEMENT-2          
               MOVE LM001-ERR-COLUMN-3      TO TABLE-ELEMENT-3          
               MOVE LM001-ERR-COLUMN-4      TO TABLE-ELEMENT-4          
               MOVE LM001-ERR-HOSTVAR-1     TO HOSTVAR-ELEMENT-1        
               MOVE LM001-ERR-HOSTVAR-2     TO HOSTVAR-ELEMENT-2        
               MOVE LM001-ERR-HOSTVAR-3     TO HOSTVAR-ELEMENT-3        
               MOVE LM001-ERR-HOSTVAR-4     TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            END-IF.                                                     
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2450-ADD-POLE-CUST-PLAN.                                       *        
      ******************************************************************        
       2450-ADD-POLE-CUST-PLAN.                                         
                                                                        
            INITIALIZE LM001-INPUT.                                     
                                                                        
            MOVE 'N'                        TO LM001-ACTION-CODE        
            MOVE PARM-ACCOUNT-NO            TO LM001-ACCOUNT-NO         
            MOVE PARM-O-FXTR-INST-LOC-NO    TO LM001-INSTALL-LOC-NO     
            MOVE WS-MAX-INS-POINT-NO        TO LM001-INSTALL-POINT-NO   
ACT069*     MOVE WS-CURRENT-DATE            TO LM001-ACTION-DATE                
ACT069      MOVE PARM-EFFECTIVE-DT          TO LM001-ACTION-DATE        
            MOVE PARM-N-POLE-CODE-REVENUE-CLASS                         
                                            TO LM001-CODE-REVENUE-CLASS.
            MOVE PARM-USER-ID               TO LM001-USER-ID            
            MOVE PROGRAM-NAME               TO LM001-PROGRAM-NAME       
                                                                        
            PERFORM 6300-LM001-CUST-LIGHT-SYNC THRU 6300-LM001-EXIT.    
                                                                        
            IF LM001-ERROR                                              
               MOVE LM001-ERR-SQLCODE       TO WS-ACTIVE-RETURN-CODE    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE LM001-BUS-RULE-ID       TO S-RS1-BUS-RULE-ID        
               MOVE 'F'                     TO S-RS1-BUS-RULE-RESULT-CD 
               MOVE 'CPDLM001'              TO ABEND-PROGRAM            
               MOVE LM001-ERR-PARAGRAPH-NO  TO ACTIVE-PARAGRAPH         
               MOVE LM001-ERR-FUNCTION      TO ABEND-FUNCTION           
               MOVE LM001-ERR-TABLE1        TO TABLE-1                  
               MOVE LM001-ERR-TABLE2        TO TABLE-2                  
               MOVE LM001-ERR-COLUMN-1      TO TABLE-ELEMENT-1          
               MOVE LM001-ERR-COLUMN-2      TO TABLE-ELEMENT-2          
               MOVE LM001-ERR-COLUMN-3      TO TABLE-ELEMENT-3          
               MOVE LM001-ERR-COLUMN-4      TO TABLE-ELEMENT-4          
               MOVE LM001-ERR-HOSTVAR-1     TO HOSTVAR-ELEMENT-1        
               MOVE LM001-ERR-HOSTVAR-2     TO HOSTVAR-ELEMENT-2        
               MOVE LM001-ERR-HOSTVAR-3     TO HOSTVAR-ELEMENT-3        
               MOVE LM001-ERR-HOSTVAR-4     TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            END-IF.                                                     
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-MOVE-RESULT.                                              *        
      ******************************************************************        
       2500-MOVE-RESULT.                                                
                                                                        
            MOVE S-RETURN-CODE              TO S-RETURN-CODE-1.         
            MOVE S-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1.    
            PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.          
                                                                        
       2500-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE TRANSACTION HISTORY IN LMS TABLE. (OLD)                  *        
      ******************************************************************        
       5000-WRITE-TRANS-HIST.                                           
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
                                                                        
ACT039      MOVE 43                       TO 4J-TRANS-COMMENTS-LEN.     
ACT039      STRING 'FIXTURE '                DELIMITED BY '   '         
ACT039             PARM-O-FXTR-EQUIP-TAG-NO  DELIMITED BY '   '         
ACT039             ' REPLACED WITH '         DELIMITED BY '   '         
ACT039             PARM-N-FXTR-EQUIP-TAG-NO  DELIMITED BY '   '         
ACT039        INTO 4J-TRANS-COMMENTS-TEXT                               
ACT039      END-STRING.                                                 
ACT039      PERFORM 5050-WRITE-TRAN-HIST-HDR THRU 5050-EXIT.            
                                                                        
ACT039      MOVE SPACES                      TO 4J-TRANS-COMMENTS-TEXT. 
            IF PARM-O-TERM-CHRG-OVR-CMT-TXT    > SPACES                 
               MOVE PARM-O-TERM-CHRG-OVR-CMT-TXT  TO                    
                                                 4J-TRANS-COMMENTS-LEN  
               MOVE PARM-O-TERM-CHRG-OVR-CMT-TXT  TO                    
                                                 4J-TRANS-COMMENTS-TEXT 
               PERFORM 5050-WRITE-TRAN-HIST-HDR       THRU 5050-EXIT    
            END-IF.                                                     
                                                                        
ACT039      MOVE SPACES                      TO 4J-TRANS-COMMENTS-TEXT. 
            IF PARM-REQUEST-NA-CMT-TXT > SPACES                         
               MOVE PARM-REQUEST-NA-CMT-LEN      TO                     
                                                 4J-TRANS-COMMENTS-LEN  
               MOVE PARM-REQUEST-NA-CMT-TXT      TO                     
                                                 4J-TRANS-COMMENTS-TEXT 
            ELSE                                                        
               MOVE 14                        TO 4J-TRANS-COMMENTS-LEN  
               MOVE 'REPLACE WIZARD'          TO 4J-TRANS-COMMENTS-TEXT 
            END-IF.                                                     
            PERFORM 5050-WRITE-TRAN-HIST-HDR       THRU 5050-EXIT.      
                                                                        
            MOVE 4J-TRANS-HIST-SEQ-NO          TO 4S-TRANS-HIST-SEQ-NO. 
            PERFORM 5100-WRITE-FXTR-TRAN-HIST      THRU 5100-EXIT.      
            IF PARM-O-TERMINATE-CNTRCT-CD = 'Y'                         
ACT039         OR PARM-N-CREATE-CNTRCT-FL = 'Y'                         
                PERFORM 5200-WRITE-CNTRCT-TRAN-HIST    THRU 5200-EXIT   
            ELSE                                                        
                PERFORM 5250-WRITE-NO-CNTRCT-TRAN-HIST THRU 5250-EXIT   
            END-IF.                                                     
            MOVE 01                                TO WS-TAB-INDX.      
            PERFORM 5300-WRITE-ATTCHMNT-TRAN-HIST  THRU 5300-EXIT       
                   UNTIL WS-TAB-INDX > WS-ATTMNT-MAX-COUNT              
                         OR TAB-EQUIP-TYPE-CD(WS-TAB-INDX) = SPACES.    
                                                                        
       5000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE TRANSACTION HISTORY HEADER IN LMS TABLE.                 *        
      ******************************************************************        
       5050-WRITE-TRAN-HIST-HDR.                                        
                                                                        
            MOVE WS-CURRENT-DATE           TO 4J-TRANS-DATE.            
ACT039      MOVE PROGRAM-NAME              TO 4J-APPL-PROGRAM-ID.       
            MOVE +01                       TO 4S-DETAIL-SEQ-NO.         
            MOVE WS-FIX-EQ-SEQ             TO 4J-EQUIP-SEQ.             
            MOVE 4D-EQUIP-TAG-NO           TO 4J-EQUIP-TAG-NO.          
            MOVE PARM-ACCOUNT-NO           TO 4J-ACCOUNT-NO.            
GOPI******  IF LENGTH OF PARM-REQUEST-NO = 6 THEN 'WMS' ELSE 'CIS'              
            MOVE 'CIS'                     TO 4J-SOURCE-APPL-CD.        
            MOVE PARM-REQUEST-NO           TO 4J-SOURCE-APPL-REQ-NO.    
            MOVE 0                         TO 4J-WMS-POINT-NO.          
            MOVE PARM-O-FXTR-INST-LOC-NO   TO 4J-INSTALL-LOC-NO.        
            MOVE 4F-INSTALL-POINT-NO       TO 4J-INSTALL-POINT-NO.      
            MOVE PARM-USER-ID              TO 4J-LAST-UPDATE-USERID     
                                              4S-LAST-UPDATE-USERID.    
                                                                        
            PERFORM 6080-GET-CURR-TS-CPDLM2       THRU 6080-CPDLM2-EXIT.
            PERFORM 6025-INS-LMS-TRN-HST-CPDLM2   THRU 6025-CPDLM2-EXIT.
                                                                        
       5050-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE FIXTURE TRANSACTION HISTORY IN LMS TABLE.                *        
      ******************************************************************        
       5100-WRITE-FXTR-TRAN-HIST.                                       
                                                                        
      * MOVING FIXTURE INVENTORY STATUS VALUES TO HISTORY TABLE.                
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_INVNTRY_ST_CD'      TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE 'J'                       TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 01                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE PARM-O-FXTR-ACTION-CD     TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
       5100-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE CONTRACT TRANSACTION HISTORY IN LMS TABLE.               *        
      ******************************************************************        
       5200-WRITE-CNTRCT-TRAN-HIST.                                     
                                                                        
ACT039* MOVING CHANGED CONTRACT START DATE VALUES TO HISTORY TABLE              
ACT039      MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
ACT039      MOVE 'CNTRCT_START_DT'         TO 4S-COLUMN-DESC.           
ACT039      MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-O-CNTRCT-START-DT    TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039                                                                  
ACT039      PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
ACT039                                         6050-CPDLM2-EXIT.        
                                                                        
      * MOVING CHANGED CONTRACT CLP NO CODE VALUES TO HISTORY TABLE             
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_CLP_NO'           TO 4S-COLUMN-DESC.           
ACT040      MOVE LENGTH OF PARM-O-CNTRCT-CLP-NO                         
ACT040                                     TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-O-CNTRCT-CLP-NO      TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
ACT039* MOVING CHANGED ORIGINAL TREM CHARGE VALUES TO HISTORY TABLE             
ACT039      MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
ACT039      MOVE 'ORIG_TERM_CHRG_AM'       TO 4S-COLUMN-DESC.           
ACT039      MOVE 8                         TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE WS-ORIG-TERM-CHRG-NUM     TO WS-TERM-CHRG-AMT-HST.     
ACT039      MOVE WS-TERM-CHRG-AMT-HST      TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039                                                                  
ACT039      PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
ACT039                                         6050-CPDLM2-EXIT.        
                                                                        
      * MOVING CHANGED ACTUAL CHARGED DATE VALUES TO HISTORY TABLE              
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'ACTUAL_CHRG_DT'          TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-CURRENT-DATE           TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT END DATE VALUES TO HISTORY TABLE                
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'ACTL_TERM_CHRG_AM'       TO 4S-COLUMN-DESC.           
            MOVE 08                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE WS-TERM-CHRG-AMT-NUM      TO WS-TERM-CHRG-AMT-HST.     
            MOVE WS-TERM-CHRG-AMT-HST      TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
       5200-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE NO CONTRACT TRANSACTION HISTORY IN LMS TABLE.            *        
      ******************************************************************        
       5250-WRITE-NO-CNTRCT-TRAN-HIST.                                  
                                                                        
      * MOVING CHANGED CONTRACT START DATE VALUES TO HISTORY TABLE              
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'NO_CONTRACT_RSN_CD'      TO 4S-COLUMN-DESC.           
            MOVE 10                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE PARM-N-NO-CONTRACT-RSN-CD TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2                      
                                              THRU 6050-CPDLM2-EXIT.    
       5250-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.             *        
      ******************************************************************        
       5300-WRITE-ATTCHMNT-TRAN-HIST.                                   
                                                                        
            EVALUATE TAB-EQUIP-TYPE-CD(WS-TAB-INDX)                     
                WHEN 'P'                                                
                   PERFORM 5600-WRITE-POLE-TRAN-HIST THRU 5600-EXIT     
                WHEN 'N'                                                
                   PERFORM 5700-WRITE-NODE-TRAN-HIST THRU 5700-EXIT     
            END-EVALUATE.                                               
                                                                        
            ADD 01                                    TO WS-TAB-INDX.   
                                                                        
       5300-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE POLE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.        *        
      ******************************************************************        
       5600-WRITE-POLE-TRAN-HIST.                                       
                                                                        
      * MOVING CHANGED EQUIP TAG NO VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-EQUIP-TAG-NO(WS-TAB-INDX) TO                       
                                              4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-PLAN-NO VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_PLAN_NO'       TO 4S-COLUMN-DESC.           
            MOVE 03                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-RATE-PLAN-NO(WS-TAB-INDX)                          
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-ITEM-CODE VALUES TO HISTORY TABLE                   
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_ITEM_CD'       TO 4S-COLUMN-DESC.           
            MOVE 04                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-RATE-ITEM-CODE(WS-TAB-INDX)                        
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED BILLING FLAG VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_BILLING_FL'         TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-BILLING-FL(WS-TAB-INDX)                            
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED NO BILL REASON CD VALUES TO HISTORY TABLE                
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_NOBILL_RSN_CD'      TO 4S-COLUMN-DESC.           
            MOVE LENGTH OF TAB-NO-BILL-REASON-CD(WS-TAB-INDX)           
                                           TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-NO-BILL-REASON-CD(WS-TAB-INDX)                     
                                           TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5600-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE NODE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.        *        
      ******************************************************************        
       5700-WRITE-NODE-TRAN-HIST.                                       
                                                                        
      * MOVING CHANGED EQUIP TAG NO VALUES TO HISTORY TABLE                     
            MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
            MOVE 'NODE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
            MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE TAB-EQUIP-TAG-NO(WS-TAB-INDX) TO                       
                                              4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 11                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE '**DELETED**'             TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
            ADD 01                         TO WS-TAB-INDX.              
                                                                        
       5700-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 6001-CREATE-LMS-CONTRACT.                                      *        
      ******************************************************************        
       6001-CREATE-LMS-CONTRACT.                                        
                                                                        
            INITIALIZE WS-CONTRACT-HEADER-PARMS                         
                       WS-CONTRACT-DETAIL-PARMS                         
                       WS-CONTRACT-RETURN-INFO.                         
                                                                        
            SET  CONTRACT-INSERT          TO TRUE.                      
            SET  CALLED-FROM-ONLINE       TO TRUE.                      
            SET  LMS-CONTRACT             TO TRUE.                      
                                                                        
            MOVE PARM-USER-ID             TO WS-4822-USER-ID.           
            MOVE PARM-ACCOUNT-NO          TO WS-4822-ACCOUNT-NO.        
            MOVE 407                      TO WS-4822-CNT-NAME-CD.       
            MOVE PROGRAM-NAME             TO WS-4822-CNT-APPL-PGM-ID.   
            MOVE WS-TERM-CHRG-AMT-COMP    TO WS-4822-AMT-ORIG-ENTERED.  
            MOVE 'E'                      TO WS-4822-CODE-CONTRACT-TYPE.
                                                                        
            CALL MCSCB822 USING ABEND-FILE                              
                               ,WS-WARNING-DATA-ELEMENTS                
                               ,WS-CONTRACT-HEADER-PARMS                
                               ,WS-CONTRACT-DETAIL-PARMS                
                               ,WS-CONTRACT-OPERATION-TYPE              
                               ,WS-CONTRACT-RETURN-INFO.                
                                                                        
            IF CPD4822-DB2-ERR-FOUND                                    
               MOVE 100                     TO S-APPL-RETURN-CODE       
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
            ELSE                                                        
               MOVE WS-4822-NEW-ITEM-ID     TO WS-LMS-CNTR-ITEM-ID      
            END-IF.                                                     
                                                                        
       6001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6300-LM001-CUST-LITE-SYNC.                                     *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDLM001                                                
           END-EXEC.                                                            
                                                                        
       5701-WRITE-TRANS-HIST-NEW.                                       
                                                                        
            INITIALIZE DCLLMS-TRANS-HIST                                
                       DCLLMS-TRANS-HIST-DET.                           
            MOVE PROGRAM-NAME                    TO 4J-APPL-PROGRAM-ID. 
            IF PARM-REQUEST-NA-CMT-TXT      > SPACES                    
               MOVE PARM-REQUEST-NA-CMT-LEN      TO                     
                                                 4J-TRANS-COMMENTS-LEN  
               MOVE PARM-REQUEST-NA-CMT-TXT      TO                     
                                                 4J-TRANS-COMMENTS-TEXT 
            ELSE                                                        
               MOVE 14                        TO 4J-TRANS-COMMENTS-LEN  
               MOVE 'REPLACE WIZARD'          TO 4J-TRANS-COMMENTS-TEXT 
            END-IF.                                                     
            PERFORM 5702-WRITE-TRAN-HIST-HDR-NEW   THRU 5702-EXIT.      
                                                                        
            MOVE 4J-TRANS-HIST-SEQ-NO          TO 4S-TRANS-HIST-SEQ-NO. 
                                                                        
            PERFORM 5702A-WRITE-FXTR-TRAN-HIST    THRU 5702A-EXIT.      
                                                                        
            IF PARM-N-CREATE-CNTRCT-FL  = 'Y'                           
ACT039         AND (PARM-O-TERMINATE-CNTRCT-CD NOT = 'R' OR             
ACT039              PARM-O-TERMINATE-CNTRCT-CD NOT = 'T')               
                PERFORM 5703-WRITE-CNTRCT-TRAN-HIST THRU 5703-EXIT      
            END-IF.                                                     
                                                                        
            IF PARM-POLE-ACTION-CD = 'A'                                
               PERFORM 5708-WRITE-NEW-POLE-TRAN-HIST THRU 5708-EXIT     
            END-IF.                                                     
                                                                        
       5701-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE TRANSACTION HISTORY HEADER IN LMS TABLE.                 *        
      ******************************************************************        
       5702-WRITE-TRAN-HIST-HDR-NEW.                                    
                                                                        
            MOVE WS-CURRENT-DATE           TO 4J-TRANS-DATE.            
            MOVE +01                       TO 4S-DETAIL-SEQ-NO.         
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4J-EQUIP-SEQ.             
            MOVE PARM-N-FXTR-EQUIP-TAG-NO  TO 4J-EQUIP-TAG-NO.          
            MOVE PARM-ACCOUNT-NO           TO 4J-ACCOUNT-NO.            
GOPI******  IF LENGTH OF PARM-REQUEST-NO = 6 THEN 'WMS' ELSE 'CIS'              
            MOVE 'CIS'                     TO 4J-SOURCE-APPL-CD.        
            MOVE PARM-REQUEST-NO           TO 4J-SOURCE-APPL-REQ-NO.    
            MOVE 0                         TO 4J-WMS-POINT-NO.          
            MOVE PARM-O-FXTR-INST-LOC-NO   TO 4J-INSTALL-LOC-NO.        
            MOVE PARM-O-FXTR-INST-POINT-NO TO 4J-INSTALL-POINT-NO.      
            MOVE PARM-USER-ID              TO 4J-LAST-UPDATE-USERID     
                                              4S-LAST-UPDATE-USERID.    
                                                                        
            PERFORM 6080-GET-CURR-TS-CPDLM2       THRU 6080-CPDLM2-EXIT.
            PERFORM 6025-INS-LMS-TRN-HST-CPDLM2   THRU 6025-CPDLM2-EXIT.
                                                                        
       5702-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE REPLACEMENT FIXTURE TRANSACTION HISTORY IN LMS TABLE.    *        
      ******************************************************************        
       5702A-WRITE-FXTR-TRAN-HIST.                                      
                                                                        
ACT039* MOVING OLD & NEW FIXTURE TAG VALUE TO HISTORY TABLE.                    
ACT039      MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
ACT039      MOVE 'FXTR_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
ACT039      MOVE 12                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-O-FXTR-EQUIP-TAG-NO  TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-FXTR-EQUIP-TAG-NO  TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039                                                                  
ACT039      PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
ACT039                                         6050-CPDLM2-EXIT.        
                                                                        
      * MOVING FIXTURE INVENTORY STATUS VALUES TO HISTORY TABLE.                
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'FXTR_INVNTRY_ST_CD'      TO 4S-COLUMN-DESC.           
            MOVE 01                        TO 4S-PRV-COLUMN-VALUE-LEN.  
            MOVE 'I'                       TO 4S-PRV-COLUMN-VALUE-TEXT. 
            MOVE 01                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE 'J'                       TO 4S-CHG-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5702A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * WRITE CONTRACT TRANSACTION HISTORY IN LMS TABLE.               *        
      ******************************************************************        
       5703-WRITE-CNTRCT-TRAN-HIST.                                     
                                                                        
      * MOVING CHANGED CONTRACT START DATE VALUES TO HISTORY TABLE              
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_START_DT'         TO 4S-COLUMN-DESC.           
ACT039      MOVE 10                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-CNTRCT-START-DT    TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT END DATE VALUES TO HISTORY TABLE                
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_END_DT'           TO 4S-COLUMN-DESC.           
ACT039      MOVE 10                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-CNTRCT-END-DT      TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT DURATION CD VALUES TO HISTORY TABLE             
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_DURATION_CD'      TO 4S-COLUMN-DESC.           
ACT039      MOVE 10                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-CNTRCT-DURATION-CD TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      *                                                                         
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'FIXTURE_COST_AM'         TO 4S-COLUMN-DESC.           
ACT039      MOVE 08                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE 4L-FIXTURE-COST-AM        TO WS-TERM-CHRG-AMT-HST.     
ACT039      MOVE WS-TERM-CHRG-AMT-HST      TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      *                                                                         
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_COST_AM'            TO 4S-COLUMN-DESC.           
ACT039      MOVE 08                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            MOVE 4L-POLE-COST-AM           TO WS-TERM-CHRG-AMT-HST.     
ACT039      MOVE WS-TERM-CHRG-AMT-HST      TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT CLP NO CODE VALUES TO HISTORY TABLE             
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_CLP_NO'           TO 4S-COLUMN-DESC.           
ACT040      MOVE LENGTH OF PARM-N-CNTRCT-CLP-NO                         
ACT040                                     TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-CNTRCT-CLP-NO      TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED CONTRACT STATUS CD VALUES TO HISTORY TABLE               
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'CNTRCT_STATUS_CD'        TO 4S-COLUMN-DESC.           
ACT039      MOVE 10                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE 4L-CNTRCT-STATUS-CD       TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5703-EXIT.                                                       
             EXIT.                                                      
      ******************************************************************        
      * WRITE NEW POLE ATTACHMENT TRANSACTION HISTORY IN LMS TABLE.    *        
      ******************************************************************        
       5708-WRITE-NEW-POLE-TRAN-HIST.                                   
                                                                        
      * MOVING NEW EQUIP TAG NO VALUES TO HISTORY TABLE                         
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
ACT039      MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-POLE-EQUIP-TAG-NO  TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED STOCK CD VALUES TO HISTORY TABLE                         
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_STOCK_CD'           TO 4S-COLUMN-DESC.           
ACT039      MOVE 12                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-POLE-STOCK-CD      TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-PLAN-NO VALUES TO HISTORY TABLE                     
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_PLAN_NO'       TO 4S-COLUMN-DESC.           
ACT039      MOVE 03                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-POLE-RATE-PLAN-NO  TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED RATE-ITEM-CODE VALUES TO HISTORY TABLE                   
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_RATE_ITEM_CD'       TO 4S-COLUMN-DESC.           
ACT039      MOVE 04                        TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-POLE-RATE-ITEM-CD  TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
      * MOVING CHANGED BILLING FLAG VALUES TO HISTORY TABLE                     
            MOVE PARM-N-FXTR-EQUIP-SEQ     TO 4S-EQUIP-SEQ.             
            MOVE 'POLE_BILLING_FL'         TO 4S-COLUMN-DESC.           
ACT039      MOVE 01                        TO 4S-CHG-COLUMN-VALUE-LEN.  
            IF PARM-N-POLE-RATE-PLAN-NO > SPACES AND                    
               PARM-N-POLE-RATE-ITEM-CD > 0                             
ACT039         MOVE 'Y'                    TO 4S-CHG-COLUMN-VALUE-TEXT  
            ELSE                                                        
ACT039         MOVE 'N'                    TO 4S-CHG-COLUMN-VALUE-TEXT  
            END-IF.                                                     
ACT039      MOVE 07                        TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE '**NEW**'                 TO 4S-PRV-COLUMN-VALUE-TEXT. 
                                                                        
            PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
                                               6050-CPDLM2-EXIT.        
                                                                        
       5708-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7000-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 100                      TO S-APPL-RETURN-CODE       
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-ALL-FIX-ATT-CUR.                                     *        
      ******************************************************************        
       7100-OPEN-ALL-FIX-ATT-CUR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN ALL_FXTR_ATMS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 100                      TO S-APPL-RETURN-CODE       
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ '        TO TABLE-ELEMENT-1          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7101-FETCH-ALL-FIX-ATT-CUR.                                    *        
      ******************************************************************        
       7101-FETCH-ALL-FIX-ATT-CUR.                                      

MSQ008     MOVE 10 TO MSQ008-ALL-FXTR-ATMS
                                                                        
           EXEC SQL                                                     
               FOR :MSQ008-ALL-FXTR-ATMS
              FETCH 
              FROM ALL_FXTR_ATMS         
                INTO :TAB-ATTACH-EQUIP-SEQ                              
                    ,:TAB-EQUIP-TYPE-CD                                 
                    ,:TAB-EQUIP-TAG-NO                                  
                    ,:TAB-INSTALL-POINT-NO                              
                    ,:TAB-RATE-PLAN-NO                                  
                    ,:TAB-RATE-ITEM-CODE                                
                    ,:TAB-BILLING-FL                                    
                    ,:TAB-NO-BILL-REASON-CD                             
                    ,:TAB-ATTACH-EQUIP-DATE                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH  NEXT ROWSET FROM ALL_FXTR_ATMS FOR 10 ROWS                
MFA-TR*         INTO :TAB-ATTACH-EQUIP-SEQ                                      
MFA-TR*             ,:TAB-EQUIP-TYPE-CD                                         
MFA-TR*             ,:TAB-EQUIP-TAG-NO                                          
MFA-TR*             ,:TAB-INSTALL-POINT-NO                                      
MFA-TR*             ,:TAB-RATE-PLAN-NO                                          
MFA-TR*             ,:TAB-RATE-ITEM-CODE                                        
MFA-TR*             ,:TAB-BILLING-FL                                            
MFA-TR*             ,:TAB-NO-BILL-REASON-CD                                     
MFA-TR*             ,:TAB-ATTACH-EQUIP-DATE                                     
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ALL-FXTR-ATMS
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           MOVE SQLERRD(3)                 TO WS-ATCHMNT-COUNT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                    AND WS-ATCHMNT-COUNT >  0                           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 100                     TO S-APPL-RETURN-CODE        
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7101'                  TO ACTIVE-PARAGRAPH          
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'LMS_FXTR_ATTACHMTS'    TO TABLE-1                   
              MOVE 'FXTR_EQUIP_SEQ '       TO TABLE-ELEMENT-1           
              MOVE 4H-FXTR-EQUIP-SEQ       TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7102-CLOSE-ALL-FIX-ATT-CUR.                                    *        
      *                                                                *        
      ******************************************************************        
       7102-CLOSE-ALL-FIX-ATT-CUR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE ALL_FXTR_ATMS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 100                  TO S-APPL-RETURN-CODE          
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7102'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'LMS_FXTR_ATTACHMTS' TO TABLE-1                     
               MOVE 'FXTR_EQUIP_SEQ '    TO TABLE-ELEMENT-1             
               MOVE 4H-FXTR-EQUIP-SEQ    TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7103-GET-OLD-EQ-CNT-PREV                                      *         
      *****************************************************************         
       7103-GET-OLD-EQ-CNT-PREV.                                        
      *                                                                         
            EXEC SQL                                                    
                SELECT  CNTRCT_CLP_NO                                   
                       ,CNTRCT_STATUS_CD                                
                       ,CNTRCT_END_DT                                   
                       ,CNTRCT_DURATION_CD                              
                       ,FIXTURE_COST_AM                                 
                       ,POLE_COST_AM                                    
                  INTO :4L-CNTRCT-CLP-NO                                
                      ,:4L-CNTRCT-STATUS-CD                             
                      ,:4L-CNTRCT-END-DT                                
                      ,:4L-CNTRCT-DURATION-CD                           
                      ,:4L-FIXTURE-COST-AM                              
                      ,:4L-POLE-COST-AM                                 
                  FROM  LMS_EQUIP_CONTRACT                              
                 WHERE  EQUIP_SEQ        = :4L-EQUIP-SEQ                
                   AND  INSTALL_LOC_NO   = :4L-INSTALL-LOC-NO           
                   AND  CNTRCT_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )          
                   AND  ACCOUNT_NO       = :4L-ACCOUNT-NO               
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT  CNTRCT_CLP_NO                                           
MFA-TR*                ,CNTRCT_STATUS_CD                                        
MFA-TR*                ,CNTRCT_END_DT                                           
MFA-TR*                ,CNTRCT_DURATION_CD                                      
MFA-TR*                ,FIXTURE_COST_AM                                         
MFA-TR*                ,POLE_COST_AM                                            
MFA-TR*           INTO :4L-CNTRCT-CLP-NO                                        
MFA-TR*               ,:4L-CNTRCT-STATUS-CD                                     
MFA-TR*               ,:4L-CNTRCT-END-DT                                        
MFA-TR*               ,:4L-CNTRCT-DURATION-CD                                   
MFA-TR*               ,:4L-FIXTURE-COST-AM                                      
MFA-TR*               ,:4L-POLE-COST-AM                                         
MFA-TR*           FROM  LMS_EQUIP_CONTRACT                                      
MFA-TR*          WHERE  EQUIP_SEQ        = :4L-EQUIP-SEQ                        
MFA-TR*            AND  INSTALL_LOC_NO   = :4L-INSTALL-LOC-NO                   
MFA-TR*            AND  CNTRCT_START_DT  = :4L-CNTRCT-START-DT                  
MFA-TR*            AND  ACCOUNT_NO       = :4L-ACCOUNT-NO                       
MFA-TR*        QUERYNO 7103                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7103'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_CONTRACT'    TO TABLE-1                  
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-1          
               MOVE 'CNTRCT_START_DT'       TO TABLE-ELEMENT-2          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-3          
               MOVE 4L-INSTALL-LOC-NO       TO HOSTVAR-ELEMENT-1        
               MOVE 4L-CNTRCT-START-DT      TO HOSTVAR-ELEMENT-2        
               MOVE 4L-ACCOUNT-NO           TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7103-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7104-GET-NEW-EQUIP-SEQ                                         *        
      ******************************************************************        
       7104-GET-NEW-EQUIP-SEQ.                                          
                                                                        
           EXEC SQL                                                     
             SELECT
              NEXT VALUE FOR SEQ_ID_EQUIP_SEQ
            INTO
              :WS-NEW-EQUIP-SEQ                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-NEW-EQUIP-SEQ =                                            
MFA-TR*             NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7104'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'SYSIBM.SYSDUMMY1'       TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7104-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7105-GET-MSTR-STK-INFO.                                        *        
      ******************************************************************        
       7105-GET-MSTR-STK-INFO.                                          
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) [4A].COMPANY_NO,
              [4A].CODE_SERVICE_TYPE,
              [4A].EQUIPMENT_COST_AM                               
               INTO :4A-COMPANY-NO                                      
                   ,:4A-CODE-SERVICE-TYPE                               
                   ,:4A-EQUIPMENT-COST-AM                               
               FROM LMS_MSTR_STCK_INFO  [4A] WITH(READUNCOMMITTED)              
              WHERE [4A].STOCK_CD       = :4A-STOCK-CD                    
                AND [4A].EQUIP_TYPE_CD  = :4A-EQUIP-TYPE-CD               
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  4A.COMPANY_NO                                              
MFA-TR*             ,4A.CODE_SERVICE_TYPE                                       
MFA-TR*             ,4A.EQUIPMENT_COST_AM                                       
MFA-TR*        INTO :4A-COMPANY-NO                                              
MFA-TR*            ,:4A-CODE-SERVICE-TYPE                                       
MFA-TR*            ,:4A-EQUIPMENT-COST-AM                                       
MFA-TR*        FROM LMS_MSTR_STCK_INFO  4A                                      
MFA-TR*       WHERE 4A.STOCK_CD       = :4A-STOCK-CD                            
MFA-TR*         AND 4A.EQUIP_TYPE_CD  = :4A-EQUIP-TYPE-CD                       
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*     QUERYNO 7105                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7105'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_MSTR_STCK_INFO'     TO TABLE-1                  
              MOVE 'STOCK_CD'               TO TABLE-ELEMENT-1          
              MOVE 4A-STOCK-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7106-GET-MAX-INS-POINT                                         *        
      ******************************************************************        
       7106-GET-MAX-INS-POINT.                                          
                                                                        
           EXEC SQL                                                     
             SELECT MAX(INSTALL_POINT_NO)                               
               INTO :WS-MAX-INS-POINT-NO                                
               FROM LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                     
              WHERE INSTALL_LOC_NO = :WS-OLD-FX-INST-LOC-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(INSTALL_POINT_NO)                                       
MFA-TR*        INTO :WS-MAX-INS-POINT-NO                                        
MFA-TR*        FROM LMS_EQUIP_ENVRNMT                                           
MFA-TR*       WHERE INSTALL_LOC_NO = :WS-OLD-FX-INST-LOC-NO                     
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7106                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '7106'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'SELECT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_ENVRNMT'      TO  TABLE-1                 
              MOVE 'INSTALL_LOC_NO'         TO  TABLE-ELEMENT-1         
              MOVE WS-OLD-FX-INST-LOC-NO    TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7106-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS.                                        *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04770_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04770_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSR04770_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04770_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04770_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE 100                      TO S-APPL-RETURN-CODE       
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'Y'                      TO  WS-ERR-INSRT-R1         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04770_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * DELETE FIXTURE ATTACHMENTS                                    *         
      *****************************************************************         
      *                                                                         
       8101-DELETE-ATTACHMENTS.                                         
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM LMS_FXTR_ATTACHMTS                          
                 WHERE FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8101'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_FXTR_ATTACHMTS'    TO TABLE-1                  
               MOVE 'FXTR_EQUIP_SEQ'        TO TABLE-ELEMENT-1          
               MOVE 4H-FXTR-EQUIP-SEQ       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8102-UPDATE-TERM-EQUIP-CNT.                                  *          
      *****************************************************************         
       8102-UPDATE-TERM-EQUIP-CNT.                                      
                                                                        
            EXEC SQL                                                    
               UPDATE  [4L]                             
                  SET  [4L].ORIG_TERM_CHRG_AM  = :4L-ORIG-TERM-CHRG-AM    
                      ,[4L].ACTL_TERM_CHRG_AM  = :4L-ACTL-TERM-CHRG-AM    
                      ,[4L].ACTL_CHRG_DT       =  
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                      ,[4L].CNTRCT_END_DT      =  
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                      ,[4L].CNTRCT_STATUS_CD   = 'T'                      
                      ,[4L].LAST_UPDATE_TS     =  
           CIS.CURRENT$TIMESTAMP()       
                      ,LAST_UPDATE_USERID    = :PARM-USER-ID            
               FROM LMS_EQUIP_CONTRACT [4L]
                WHERE  [4L].EQUIP_SEQ          = :4L-EQUIP-SEQ            
                  AND  [4L].INSTALL_LOC_NO     = :4L-INSTALL-LOC-NO       
                  AND  [4L].CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )      
                  AND  [4L].ACCOUNT_NO         = :4L-ACCOUNT-NO           
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        UPDATE  LMS_EQUIP_CONTRACT 4L                                    
MFA-TR*           SET  4L.ORIG_TERM_CHRG_AM  = :4L-ORIG-TERM-CHRG-AM            
MFA-TR*               ,4L.ACTL_TERM_CHRG_AM  = :4L-ACTL-TERM-CHRG-AM            
MFA-TR*               ,4L.ACTL_CHRG_DT       =  CURRENT DATE                    
MFA-TR*               ,4L.CNTRCT_END_DT      =  CURRENT DATE                    
MFA-TR*               ,4L.CNTRCT_STATUS_CD   = 'T'                              
MFA-TR*               ,4L.LAST_UPDATE_TS     =  CURRENT TIMESTAMP               
MFA-TR*               ,LAST_UPDATE_USERID    = :PARM-USER-ID                    
MFA-TR*         WHERE  4L.EQUIP_SEQ          = :4L-EQUIP-SEQ                    
MFA-TR*           AND  4L.INSTALL_LOC_NO     = :4L-INSTALL-LOC-NO               
MFA-TR*           AND  4L.CNTRCT_START_DT    = :4L-CNTRCT-START-DT              
MFA-TR*           AND  4L.ACCOUNT_NO         = :4L-ACCOUNT-NO                   
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8102'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_CONTRACT'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-2          
               MOVE 'CONTRACT_START_DT'     TO TABLE-ELEMENT-3          
               MOVE 4L-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               MOVE 4L-INSTALL-LOC-NO       TO HOSTVAR-ELEMENT-2        
               MOVE 4L-CNTRCT-START-DT      TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8103-DELETE-EQUIP-ENV.                                        *         
      *****************************************************************         
       8103-DELETE-EQUIP-ENV.                                           
                                                                        
            EXEC SQL                                                    
                DELETE FROM LMS_EQUIP_ENVRNMT                           
                 WHERE INSTALL_LOC_NO    = :4F-INSTALL-LOC-NO           
                   AND INSTALL_POINT_NO  = :4F-INSTALL-POINT-NO         
                   AND EQUIP_SEQ         = :4F-EQUIP-SEQ                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8103'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_ENVRNMT'     TO TABLE-1                  
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-1          
               MOVE 'INSTALL_POINT_NO'      TO TABLE-ELEMENT-2          
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-3          
               MOVE 4F-INSTALL-LOC-NO       TO HOSTVAR-ELEMENT-1        
               MOVE 4F-INSTALL-POINT-NO     TO HOSTVAR-ELEMENT-2        
               MOVE 4F-EQUIP-SEQ            TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8103-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8104-DELETE-EQ-INV.                                           *         
      *****************************************************************         
       8104-DELETE-EQ-INV.                                              
                                                                        
            EXEC SQL                                                    
                DELETE FROM LMS_EQUIP_INVENTRY                          
                 WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8104'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_INVENTRY'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 4D-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8104-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8105-UPDATE-EQUIP-INV                                          *        
      ******************************************************************        
       8105-UPDATE-EQUIP-INV.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE [4D]                               
                 SET [4D].INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD     
                    ,[4D].LAST_UPDATE_USERID = :PARM-USER-ID              
                    ,[4D].LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP()         
              FROM LMS_EQUIP_INVENTRY [4D]
               WHERE [4D].EQUIP_SEQ          = :4D-EQUIP-SEQ              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_INVENTRY       4D                                
MFA-TR*          SET 4D.INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD             
MFA-TR*             ,4D.LAST_UPDATE_USERID = :PARM-USER-ID                      
MFA-TR*             ,4D.LAST_UPDATE_TS     =  CURRENT TIMESTAMP                 
MFA-TR*        WHERE 4D.EQUIP_SEQ          = :4D-EQUIP-SEQ                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '8105'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'LMS_EQUIP_INVENTRY'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 4D-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8106-RPL-EQ-ENV-OLD-FX.                                        *        
      ******************************************************************        
       8106-RPL-EQ-ENV-OLD-FX.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE [4F]                                
                 SET [4F].EQUIP_SEQ          = :PARM-N-FXTR-EQUIP-SEQ     
                    ,[4F].NO_CONTRACT_RSN_CD = 
                                             :PARM-N-NO-CONTRACT-RSN-CD 
                    ,[4F].EQUIP_CONTRACT_FL  = :PARM-N-CREATE-CNTRCT-FL   
              FROM LMS_EQUIP_ENVRNMT [4F]
               WHERE [4F].INSTALL_LOC_NO     = :PARM-O-FXTR-INST-LOC-NO   
                 AND [4F].INSTALL_POINT_NO   = 
                                             :PARM-O-FXTR-INST-POINT-NO 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_ENVRNMT        4F                                
MFA-TR*          SET 4F.EQUIP_SEQ          = :PARM-N-FXTR-EQUIP-SEQ             
MFA-TR*             ,4F.NO_CONTRACT_RSN_CD = :PARM-N-NO-CONTRACT-RSN-CD         
MFA-TR*             ,4F.EQUIP_CONTRACT_FL  = :PARM-N-CREATE-CNTRCT-FL           
MFA-TR*        WHERE 4F.INSTALL_LOC_NO     = :PARM-O-FXTR-INST-LOC-NO           
MFA-TR*          AND 4F.INSTALL_POINT_NO   = :PARM-O-FXTR-INST-POINT-NO         
MFA-TR*      QUERYNO 8106                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8106'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE PARM-O-FXTR-INST-LOC-NO  TO HOSTVAR-ELEMENT-1        
              MOVE PARM-O-FXTR-INST-POINT-NO TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8106-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8107-UPD-EQ-INV-NEW-FX                                         *        
      ******************************************************************        
       8107-UPD-EQ-INV-NEW-FX.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE [4D]                               
                 SET [4D].INVENTRY_STATUS_CD = 'J'                        
                    ,[4D].LAST_UPDATE_USERID = :PARM-USER-ID              
              FROM LMS_EQUIP_INVENTRY [4D]
               WHERE [4D].EQUIP_SEQ          = :PARM-N-FXTR-EQUIP-SEQ     
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_INVENTRY       4D                                
MFA-TR*          SET 4D.INVENTRY_STATUS_CD = 'J'                                
MFA-TR*             ,4D.LAST_UPDATE_USERID = :PARM-USER-ID                      
MFA-TR*        WHERE 4D.EQUIP_SEQ          = :PARM-N-FXTR-EQUIP-SEQ             
MFA-TR*      QUERYNO 8107                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE '8107'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'LMS_EQUIP_INVENTRY'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE PARM-N-FXTR-EQUIP-SEQ   TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8107-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8108-UPDATE-REPLACE-EQUIP-CNT.                                *         
      *****************************************************************         
       8108-UPDATE-REPLACE-EQUIP-CNT.                                   
                                                                        
            EXEC SQL                                                    
               UPDATE  [4L]                             
                  SET  [4L].CNTRCT_END_DT      =  DATEADD( DAY, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )    
                      ,[4L].CNTRCT_STATUS_CD   = 'X'                      
                      ,[4L].LAST_UPDATE_TS     =  
           CIS.CURRENT$TIMESTAMP()       
                      ,LAST_UPDATE_USERID    = :PARM-USER-ID            
               FROM LMS_EQUIP_CONTRACT [4L]
                WHERE  [4L].EQUIP_SEQ          = :4L-EQUIP-SEQ            
                  AND  [4L].INSTALL_LOC_NO     = :4L-INSTALL-LOC-NO       
                  AND  [4L].CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )      
                  AND  [4L].ACCOUNT_NO         = :4L-ACCOUNT-NO           
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        UPDATE  LMS_EQUIP_CONTRACT 4L                                    
MFA-TR*           SET  4L.CNTRCT_END_DT      =  CURRENT DATE - 1 DAY            
MFA-TR*               ,4L.CNTRCT_STATUS_CD   = 'X'                              
MFA-TR*               ,4L.LAST_UPDATE_TS     =  CURRENT TIMESTAMP               
MFA-TR*               ,LAST_UPDATE_USERID    = :PARM-USER-ID                    
MFA-TR*         WHERE  4L.EQUIP_SEQ          = :4L-EQUIP-SEQ                    
MFA-TR*           AND  4L.INSTALL_LOC_NO     = :4L-INSTALL-LOC-NO               
MFA-TR*           AND  4L.CNTRCT_START_DT    = :4L-CNTRCT-START-DT              
MFA-TR*           AND  4L.ACCOUNT_NO         = :4L-ACCOUNT-NO                   
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-APPL-RETURN-CODE       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8108'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'LMS_EQUIP_CONTRACT'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-2          
               MOVE 'CONTRACT_START_DT'     TO TABLE-ELEMENT-3          
               MOVE 4L-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               MOVE 4L-INSTALL-LOC-NO       TO HOSTVAR-ELEMENT-2        
               MOVE 4L-CNTRCT-START-DT      TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8108-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8109-RPL-POLES-NEW-FX-ATT.                                     *        
      ******************************************************************        
       8109-RPL-POLES-NEW-FX-ATT.                                       
                                                                        
           EXEC SQL                                                     
             INSERT INTO LMS_FXTR_ATTACHMTS                             
                 ( FXTR_EQUIP_SEQ                                       
                  ,ATTACH_SEQ_NO                                        
                  ,EQUIP_TYPE_CD                                        
                  ,ATTACH_EQUIP_SEQ                                     
                  ,ATTACH_EQUIP_DT                                      
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
                 VALUES                                                 
                 (                                                      
                   :4H-FXTR-EQUIP-SEQ                                   
                  ,:4H-ATTACH-SEQ-NO                                    
                  ,:4H-EQUIP-TYPE-CD                                    
                  ,:4H-ATTACH-EQUIP-SEQ                                 
                  ,IIF(TRY_CONVERT(DATE, :4H-ATTACH-EQUIP-DT
              ) IS NULL OR (PATINDEX('%.%', :4H-ATTACH-EQUIP-DT
              ) <> 0) OR (LEN(:4H-ATTACH-EQUIP-DT
              ) <> 10), CIS.CHAR2DATE(:4H-ATTACH-EQUIP-DT
              ), CONVERT(DATE, :4H-ATTACH-EQUIP-DT) )                          
                  ,:PARM-USER-ID                                        
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO LMS_FXTR_ATTACHMTS                                     
MFA-TR*          ( FXTR_EQUIP_SEQ                                               
MFA-TR*           ,ATTACH_SEQ_NO                                                
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,ATTACH_EQUIP_SEQ                                             
MFA-TR*           ,ATTACH_EQUIP_DT                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*            :4H-FXTR-EQUIP-SEQ                                           
MFA-TR*           ,:4H-ATTACH-SEQ-NO                                            
MFA-TR*           ,:4H-EQUIP-TYPE-CD                                            
MFA-TR*           ,:4H-ATTACH-EQUIP-SEQ                                         
MFA-TR*           ,:4H-ATTACH-EQUIP-DT                                          
MFA-TR*           ,:PARM-USER-ID                                                
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 ADD 1                      TO 4H-ATTACH-SEQ-NO         
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8109'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ'         TO TABLE-ELEMENT-1          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8109-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8110-ADD-NEW-POLE-EQ-INV                                       *        
      ******************************************************************        
       8110-ADD-NEW-POLE-EQ-INV.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_INVENTRY                            
                 (                                                      
                   EQUIP_SEQ                                            
                  ,EQUIP_TAG_NO                                         
                  ,COMPANY_NO                                           
                  ,CODE_SERVICE_TYPE                                    
                  ,STOCK_CD                                             
                  ,EQUIP_TYPE_CD                                        
                  ,EQUIP_MFR_CD                                         
                  ,EQUIP_MFR_DT                                         
                  ,WARRANTY_EXP_DT                                      
                  ,EQUIP_DISPOSAL_DT                                    
                  ,STORAGE_FAC_CD                                       
                  ,IN_TRANSIT_USERID                                    
                  ,INVENTRY_STATUS_CD                                   
                  ,WRNTY_RECEIVED_FL                                    
                  ,WRNTY_RECOUP_AMT                                     
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :WS-NEW-EQUIP-SEQ                                    
                  ,:PARM-N-POLE-EQUIP-TAG-NO                            
                  ,:4A-COMPANY-NO                                       
                  ,:4A-CODE-SERVICE-TYPE                                
                  ,:PARM-N-POLE-STOCK-CD                                
                  ,:WS-POLE                                             
                  ,' '                                                  
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-MFR-DT 
                                         :WS-NULL-EQUIP-MFR-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-MFR-DT 
                                                  :WS-NULL-EQUIP-MFR-DT
              ) <> 0) OR (LEN(:4D-EQUIP-MFR-DT :WS-NULL-EQUIP-MFR-DT
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-MFR-DT 
                                                  :WS-NULL-EQUIP-MFR-DT
              ), CONVERT(DATE, :4D-EQUIP-MFR-DT :WS-NULL-EQUIP-MFR-DT
              ) )          
                  ,IIF(TRY_CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                         :WS-NULL-WARR-EXP-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-WARRANTY-EXP-DT 
                                                   :WS-NULL-WARR-EXP-DT
              ) <> 0) OR (LEN(:4D-WARRANTY-EXP-DT :WS-NULL-WARR-EXP-DT
              ) <> 10), CIS.CHAR2DATE(:4D-WARRANTY-EXP-DT 
                                                   :WS-NULL-WARR-EXP-DT
              ), CONVERT(DATE, :4D-WARRANTY-EXP-DT :WS-NULL-WARR-EXP-DT
              ) )           
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                         :WS-NULL-EQUIP-DISP-DT
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ) <> 0) OR (LEN(:4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ), CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                                 :WS-NULL-EQUIP-DISP-DT
              ) )         
                  ,' '                                                  
                  ,' '                                                  
                  ,'J'                                                  
                  ,' '                                                  
                  ,0                                                    
                  ,:PARM-USER-ID                                        
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_INVENTRY                                    
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ                                                    
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,STOCK_CD                                                     
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,EQUIP_MFR_CD                                                 
MFA-TR*           ,EQUIP_MFR_DT                                                 
MFA-TR*           ,WARRANTY_EXP_DT                                              
MFA-TR*           ,EQUIP_DISPOSAL_DT                                            
MFA-TR*           ,STORAGE_FAC_CD                                               
MFA-TR*           ,IN_TRANSIT_USERID                                            
MFA-TR*           ,INVENTRY_STATUS_CD                                           
MFA-TR*           ,WRNTY_RECEIVED_FL                                            
MFA-TR*           ,WRNTY_RECOUP_AMT                                             
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :WS-NEW-EQUIP-SEQ                                            
MFA-TR*           ,:PARM-N-POLE-EQUIP-TAG-NO                                    
MFA-TR*           ,:4A-COMPANY-NO                                               
MFA-TR*           ,:4A-CODE-SERVICE-TYPE                                        
MFA-TR*           ,:PARM-N-POLE-STOCK-CD                                        
MFA-TR*           ,:WS-POLE                                                     
MFA-TR*           ,' '                                                          
MFA-TR*           ,:4D-EQUIP-MFR-DT      :WS-NULL-EQUIP-MFR-DT                  
MFA-TR*           ,:4D-WARRANTY-EXP-DT   :WS-NULL-WARR-EXP-DT                   
MFA-TR*           ,:4D-EQUIP-DISPOSAL-DT :WS-NULL-EQUIP-DISP-DT                 
MFA-TR*           ,' '                                                          
MFA-TR*           ,' '                                                          
MFA-TR*           ,'J'                                                          
MFA-TR*           ,' '                                                          
MFA-TR*           ,0                                                            
MFA-TR*           ,:PARM-USER-ID                                                
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8110'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_INVENTRY'     TO  TABLE-1                 
              MOVE 'EQUIP_SEQ'              TO  TABLE-ELEMENT-1         
              MOVE WS-NEW-EQUIP-SEQ         TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8110-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8111-INS-NEW-EQ-CNT                                            *        
      ******************************************************************        
       8111-INS-NEW-EQ-CNT.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_CONTRACT                            
                 (                                                      
                   EQUIP_SEQ                                            
                  ,INSTALL_LOC_NO                                       
                  ,CNTRCT_START_DT                                      
                  ,ACCOUNT_NO                                           
                  ,CNTRCT_END_DT                                        
                  ,CNTRCT_DURATION_CD                                   
                  ,FIXTURE_COST_AM                                      
                  ,POLE_COST_AM                                         
                  ,ORIG_TERM_CHRG_AM                                    
                  ,ACTL_TERM_CHRG_AM                                    
                  ,ACTL_CHRG_DT                                         
                  ,CNTRCT_CLP_NO                                        
                  ,CNTRCT_STATUS_CD                                     
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :PARM-N-FXTR-EQUIP-SEQ                               
                  ,:WS-OLD-FX-INST-LOC-NO                               
                  ,IIF(TRY_CONVERT(DATE, :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )                          
                  ,:PARM-ACCOUNT-NO                                     
                  ,IIF(TRY_CONVERT(DATE, :4L-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-END-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :4L-CNTRCT-END-DT
              ), CONVERT(DATE, :4L-CNTRCT-END-DT) )                            
                  ,:4L-CNTRCT-DURATION-CD                               
                  ,:4L-FIXTURE-COST-AM                                  
                  ,:4L-POLE-COST-AM                                     
                  ,0                                                    
                  ,0                                                    
                  ,IIF(TRY_CONVERT(DATE, :4L-ACTL-CHRG-DT 
                                         :WS-NULL-ACTL-CHRG-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-ACTL-CHRG-DT 
                                                  :WS-NULL-ACTL-CHRG-DT
              ) <> 0) OR (LEN(:4L-ACTL-CHRG-DT :WS-NULL-ACTL-CHRG-DT
              ) <> 10), CIS.CHAR2DATE(:4L-ACTL-CHRG-DT 
                                                  :WS-NULL-ACTL-CHRG-DT
              ), CONVERT(DATE, :4L-ACTL-CHRG-DT :WS-NULL-ACTL-CHRG-DT
              ) )              
                  ,:4L-CNTRCT-CLP-NO                                    
                  ,'A'                                                  
                  ,:PARM-USER-ID                                        
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_CONTRACT                                    
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ                                                    
MFA-TR*           ,INSTALL_LOC_NO                                               
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CNTRCT_END_DT                                                
MFA-TR*           ,CNTRCT_DURATION_CD                                           
MFA-TR*           ,FIXTURE_COST_AM                                              
MFA-TR*           ,POLE_COST_AM                                                 
MFA-TR*           ,ORIG_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_CHRG_DT                                                 
MFA-TR*           ,CNTRCT_CLP_NO                                                
MFA-TR*           ,CNTRCT_STATUS_CD                                             
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :PARM-N-FXTR-EQUIP-SEQ                                       
MFA-TR*           ,:WS-OLD-FX-INST-LOC-NO                                       
MFA-TR*           ,:4L-CNTRCT-START-DT                                          
MFA-TR*           ,:PARM-ACCOUNT-NO                                             
MFA-TR*           ,:4L-CNTRCT-END-DT                                            
MFA-TR*           ,:4L-CNTRCT-DURATION-CD                                       
MFA-TR*           ,:4L-FIXTURE-COST-AM                                          
MFA-TR*           ,:4L-POLE-COST-AM                                             
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,:4L-ACTL-CHRG-DT  :WS-NULL-ACTL-CHRG-DT                      
MFA-TR*           ,:4L-CNTRCT-CLP-NO                                            
MFA-TR*           ,'A'                                                          
MFA-TR*           ,:PARM-USER-ID                                                
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8111'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_CONTRACT'     TO  TABLE-1                 
              MOVE 'INSTALL_LOC_NO'         TO  TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-2         
              MOVE 'CNTRCT_START_DT'        TO  TABLE-ELEMENT-3         
              MOVE WS-OLD-FX-INST-LOC-NO    TO  HOSTVAR-ELEMENT-1       
              MOVE PARM-ACCOUNT-NO          TO  HOSTVAR-ELEMENT-2       
              MOVE 4L-CNTRCT-START-DT       TO  HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8111-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8112-ADD-NEW-POLE-EQ-ENV                                       *        
      ******************************************************************        
       8112-ADD-NEW-POLE-EQ-ENV.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_ENVRNMT                             
                 (                                                      
                   INSTALL_LOC_NO                                       
                  ,INSTALL_POINT_NO                                     
                  ,EQUIP_SEQ                                            
                  ,INSTALL_LOC_CD                                       
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,BILLING_FL                                           
                  ,NO_BILL_REASON_CD                                    
                  ,EQUIP_CONTRACT_FL                                    
                  ,NO_CONTRACT_RSN_CD                                   
                  ,EQUIP_OWNER_CD                                       
                  ,EQUIP_DRAWING_ID                                     
                  ,EQUIP_GIS_GKEY                                       
                  ,SOURCE_APPL_CD                                       
                  ,SOURCE_APPL_REQ_NO                                   
                  ,WMS_POINT_NO                                         
                  ,EQUIP_INSTALL_DT                                     
                  ,INSTALL_USERID                                       
                  ,APPROVED_TS                                          
                  ,APPROVER_USERID                                      
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,SPCL_AGR_COMMENTS                                    
                  ,EQUIP_COMMENTS                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :WS-OLD-FX-INST-LOC-NO                               
                  ,:WS-MAX-INS-POINT-NO                                 
                  ,:WS-NEW-EQUIP-SEQ                                    
                  ,:PARM-O-FXTR-INST-LOC-CD                             
                  ,'U'                                                  
                  ,0                                                    
                  ,:PARM-N-POLE-RATE-PLAN-NO                            
                  ,:PARM-N-POLE-RATE-ITEM-CD                            
                  ,0                                                    
                  ,:4F-BILLING-FL                                       
                  ,' '                                                  
                  ,'N'                                                  
                  ,'  '                                                 
                  ,' '                                                  
                  ,' '                                                  
                  ,0                                                    
                  ,'CIS'                                                
                  ,:PARM-REQUEST-NO                                     
                  ,0                                                    
                  ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
                  ,:PARM-USER-ID                                        
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:PARM-USER-ID                                        
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:PARM-USER-ID                                        
                  ,' '                                                  
                  ,' '                                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_ENVRNMT                                     
MFA-TR*          (                                                              
MFA-TR*            INSTALL_LOC_NO                                               
MFA-TR*           ,INSTALL_POINT_NO                                             
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,INSTALL_LOC_CD                                               
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,BILLING_FL                                                   
MFA-TR*           ,NO_BILL_REASON_CD                                            
MFA-TR*           ,EQUIP_CONTRACT_FL                                            
MFA-TR*           ,NO_CONTRACT_RSN_CD                                           
MFA-TR*           ,EQUIP_OWNER_CD                                               
MFA-TR*           ,EQUIP_DRAWING_ID                                             
MFA-TR*           ,EQUIP_GIS_GKEY                                               
MFA-TR*           ,SOURCE_APPL_CD                                               
MFA-TR*           ,SOURCE_APPL_REQ_NO                                           
MFA-TR*           ,WMS_POINT_NO                                                 
MFA-TR*           ,EQUIP_INSTALL_DT                                             
MFA-TR*           ,INSTALL_USERID                                               
MFA-TR*           ,APPROVED_TS                                                  
MFA-TR*           ,APPROVER_USERID                                              
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,SPCL_AGR_COMMENTS                                            
MFA-TR*           ,EQUIP_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :WS-OLD-FX-INST-LOC-NO                                       
MFA-TR*           ,:WS-MAX-INS-POINT-NO                                         
MFA-TR*           ,:WS-NEW-EQUIP-SEQ                                            
MFA-TR*           ,:PARM-O-FXTR-INST-LOC-CD                                     
MFA-TR*           ,'U'                                                          
MFA-TR*           ,0                                                            
MFA-TR*           ,:PARM-N-POLE-RATE-PLAN-NO                                    
MFA-TR*           ,:PARM-N-POLE-RATE-ITEM-CD                                    
MFA-TR*           ,0                                                            
MFA-TR*           ,:4F-BILLING-FL                                               
MFA-TR*           ,' '                                                          
MFA-TR*           ,'N'                                                          
MFA-TR*           ,'  '                                                         
MFA-TR*           ,' '                                                          
MFA-TR*           ,' '                                                          
MFA-TR*           ,0                                                            
MFA-TR*           ,'CIS'                                                        
MFA-TR*           ,:PARM-REQUEST-NO                                             
MFA-TR*           ,0                                                            
MFA-TR*           ,CURRENT DATE                                                 
MFA-TR*           ,:PARM-USER-ID                                                
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:PARM-USER-ID                                                
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:PARM-USER-ID                                                
MFA-TR*           ,' '                                                          
MFA-TR*           ,' '                                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8112'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_EQUIP_ENVRNMT'      TO  TABLE-1                 
              MOVE 'INSTALL_LOC_NO'         TO  TABLE-ELEMENT-1         
              MOVE 'INSTALL_POINT_NO'       TO  TABLE-ELEMENT-2         
              MOVE 'EQUIP_SEQ'              TO  TABLE-ELEMENT-3         
              MOVE WS-OLD-FX-INST-LOC-NO    TO  HOSTVAR-ELEMENT-1       
              MOVE WS-MAX-INS-POINT-NO      TO  HOSTVAR-ELEMENT-2       
              MOVE WS-NEW-EQUIP-SEQ         TO  HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
        8112-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04770_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
           MOVE S-APPL-RETURN-CODE          TO S-APPL-RETURN-CODE-1.    
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
                                                                        
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    TRANSACTION HISTORY  COPYBOOK                               *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDLM002                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
            
MSQ016        GOBACK.                                                   
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT039* MOVING OLD & CURRENT FIXTURE TAG VALUES TO HISTORY TABLE.               
ACT039      MOVE WS-FIX-EQ-SEQ             TO 4S-EQUIP-SEQ.             
ACT039      MOVE 'FXTR_EQUIP_TAG_NO'       TO 4S-COLUMN-DESC.           
ACT039      MOVE +12                       TO 4S-PRV-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-O-FXTR-EQUIP-TAG-NO  TO 4S-PRV-COLUMN-VALUE-TEXT. 
ACT039      MOVE +12                       TO 4S-CHG-COLUMN-VALUE-LEN.  
ACT039      MOVE PARM-N-FXTR-EQUIP-TAG-NO  TO 4S-CHG-COLUMN-VALUE-TEXT. 
ACT039                                                                  
ACT039      PERFORM 6050-INS-LMS-TRN-HSTDET-CPDLM2 THRU                 
ACT039                                         6050-CPDLM2-EXIT.        
