       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04769.                                            
       DATE-WRITTEN. 08/18/14.                                          
       DATE-COMPILED.                                                   
       AUTHOR. SATISH SIVASUBRAMANIAN.                                  
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *                   UPDATE LIGHTING DETAILS                      *        
      *                   =======================                      *        
      *                                                                *        
      *  THIS SP UPDATES LIGHT DETAILS BASED ON THE PARM SECTION.      *        
      *                                                                *        
      *       LINK-PARM-SECTION =  FIXTURE   'F'                       *        
      *                            POLE      'P'                       *        
      *                            NODE      'N'                       *        
      *                            CONTRACT  'C'                       *        
      *                            GIS       'G'                       *        
      *                                                                *        
      *       LINK-CALL-TYPE    = UPDATE 'U'                           *        
      *                           REMOVE 'R'                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/15/14  SS95855    PROJ#0817 PROCEDURE ORIGINALLY CODED.    *        
      *  04/29/15  HA7A338    PROJ#0817 FOR RATE 064 GET ENVRNMNT DTLS *        
      *                                 WITH EQUIP_SEQ #               *        
A#5084*  06/19/15  SS95855    ACT040 CLP# CHANGED TO CHAR(50).         *        
A#5084*  07/08/15  SS95855    ACT037 1.FIXTURE ID COMPARISON CORRECTED *        
A#5084*                              2.ADD GIS  TO SOURCE_APPL_CD FOR  *        
A#5084*                              GIS CALL.                         *        
A#5084*  09/09/15  SS95855    ACT064 DUPLICATE FIXTURE-ID CHECK FOR GIS*        
A#5084*  12/07/15  SV95326    ACT069 ADD EFFECTIVE DATE IN RRT SCREEN  *        
      *                              AS A NEW INPUT.                   *        
A05470*  02/02/16  GD43988    ACT004 UPDATE POLE INSTALL DATE WHEN     *        
A05470*                              FIXTURE INSTALL DATE CHANGES      *        
      ******************************************************************        
      *****************************************************************         
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04769'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                         PIC X(40) VALUE             
           'WORKING STORAGE FOR CSR04769 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR04769'. 
           05 CSRERLOG                      PIC X(08) VALUE 'CSRERLOG'. 
           05 WS-YES                        PIC X(01) VALUE 'Y'.        
           05 WS-NO                         PIC X(01) VALUE 'N'.        
           05 WS-YET-TO-START-BILLING       PIC X(01) VALUE 'Z'.        
           05 WS-DELETE                     PIC X(09) VALUE '*DELETED*'.
           05 WS-NEW                        PIC X(07) VALUE '**NEW**'.  
           05 WS-REMOVED                    PIC X(01) VALUE 'R'.        
           05 WS-INVENTORY                  PIC X(01) VALUE 'I'.        
                                                                        
       01  WS-MISC.                                                     
           05 WS-SQLSTATE                   PIC X(05) VALUE SPACES.     
           05 WS-EQUIP-TAG-NO               PIC X(12) VALUE SPACES.     
           05 WS-EQUIP-COST-AMT             PIC X(07) VALUE SPACES.     
           05 WS-EQUIP-COST-AMT-NUM REDEFINES                           
              WS-EQUIP-COST-AMT             PIC 9(05)V99.               
           05 WS-EQUIP-COST-AMT-VAL.                                    
              10 WS-AMT-SIGN1               PIC X(01) VALUE SPACES.     
              10 WS-AMT-FIXED1              PIC X(05) VALUE SPACES.     
              10 FILLER                     PIC X(01) VALUE '.'.        
              10 WS-AMT-DEC1                PIC X(02) VALUE SPACES.     
           05 WS-COST-AMT                   PIC -ZZZZ9.99.              
           05 WS-RATE-ITEM-CD               PIC ZZZ9.                   
           05 WS-DATA-FIELDS.                                           
              49 WS-DATA-FIELDS-LEN         PIC S9(4) COMP VALUE 0.     
              49 WS-DATA-FIELDS-TEXT        PIC X(250) VALUE SPACES.    
           05 WS-ACTION-DATE                PIC X(10) VALUE SPACES.     
           05 WS-EQUIP-SEQ                  PIC S9(10)V COMP-3 VALUE 0. 
           05 WS-PRV-EQUIP-TAG-NO           PIC X(12)  VALUE SPACES.    
           05 WS-PRV-STOCK-CD               PIC X(15)  VALUE SPACES.    
           05 WS-PRV-EQUIP-MFR-CD           PIC X(02)  VALUE SPACES.    
           05 WS-PRV-EQUIP-MFR-DT           PIC X(10)  VALUE SPACES.    
           05 WS-PRV-WARRANTY-EXP-DT        PIC X(10)  VALUE SPACES.    
           05 WS-PRV-EQUIP-DISPOSAL-DT      PIC X(10)  VALUE SPACES.    
           05 WS-PRV-STORAGE-FAC-CD         PIC X(03)  VALUE SPACES.    
           05 WS-PRV-WRNTY-RECEIVED-FL      PIC X(01)  VALUE SPACES.    
           05 WS-PRV-WRNTY-RECOUP-AMT       PIC S9(5)V99 COMP-3 VALUE 0.
           05 WS-PRV-INVENTRY-STATUS-CD     PIC X(01)  VALUE SPACES.    
           05 WS-PRV-CODE-UTIL-TYPE         PIC X(01)  VALUE SPACES.    
           05 WS-PRV-RATE-PLAN-NO           PIC X(03)  VALUE SPACES.    
           05 WS-PRV-RATE-ITEM-CODE         PIC S9(4)  COMP VALUE 0.    
           05 WS-PRV-INSTALL-LOC-CD         PIC X(01)  VALUE SPACES.    
           05 WS-PRV-BILLING-FL             PIC X(01)  VALUE SPACES.    
           05 WS-PRV-NO-BILL-REASON-CD      PIC X(02)  VALUE SPACES.    
           05 WS-PRV-EQUIP-CONTRACT-FL      PIC X(01)  VALUE SPACES.    
           05 WS-PRV-EQUIP-OWNER-CD         PIC X(01)  VALUE SPACES.    
           05 WS-PRV-EQUIP-DRAWING-ID       PIC X(10)  VALUE SPACES.    
           05 WS-PRV-EQUIP-INSTALL-DT       PIC X(10)  VALUE SPACES.    
           05 WS-PRV-NO-CONTRACT-RSN-CD     PIC X(02)  VALUE SPACES.    
ACT040     05 WS-PRV-CNTRCT-CLP-NO          PIC X(50)  VALUE SPACES.    
           05 WS-PRV-CNTRCT-DURATION-CD     PIC X(02)  VALUE SPACES.    
           05 WS-PRV-CNTRCT-END-DT          PIC X(10)  VALUE SPACES.    
           05 WS-PRV-CNTRCT-START-DT        PIC X(10)  VALUE SPACES.    
           05 WS-EQUIP-MFR-DT-IND           PIC S9(4) COMP VALUE 0.     
           05 WS-WARRANTY-EXP-DT-IND        PIC S9(4) COMP VALUE 0.     
           05 WS-EQUIP-DISPOSAL-DT-IND      PIC S9(4) COMP VALUE 0.     
           05 WS-EQUIP-INSTALL-DT-IND       PIC S9(4) COMP VALUE 0.     
           05 WS-CNTRCT-END-DT-IND          PIC S9(4) COMP VALUE 0.     
           05 WS-ACTL-CHRG-DT-IND           PIC S9(4) COMP VALUE 0.     
           05 WS-APPROVED-TS-IND            PIC S9(4) COMP VALUE 0.     
ACT004     05 WS-UPDATE-POLE-DATA-FL        PIC X(01) VALUE 'N'.        
                                                                        
       01  CSRERLOG-P.                                                  
           10 S-SP-NAME                     PIC X(18) VALUE SPACES.     
           10 S-SQLCODE                     PIC S9(9) COMP VALUE 0.     
           10 S-SQLSTATE                    PIC X(5)  VALUE ' '.        
           10 S-TABLE-NAME                  PIC X(18) VALUE SPACES.     
           10 S-HOST-VARIABLES.                                         
              49 S-HOST-VARIABLES-L         PIC S9(4) COMP.             
              49 S-HOST-VARIABLES-V         PIC X(255).                 
           10 S-SQL-STATEMENT.                                          
              49 S-SQL-STATEMENT-L          PIC S9(4) COMP.             
              49 S-SQL-STATEMENT-V          PIC X(255).                 
           10 S-SQL-DESCRIPTION.                                        
              49 S-SQL-DESCRIPTION-L        PIC S9(4) COMP.             
              49 S-SQL-DESCRIPTION-V        PIC X(255).                 
           05 WS-ABEND-SQLERRMC.                                        
              49 WS-ABEND-SQLERRMC-L        PIC S9(4) COMP.             
              49 WS-ABEND-SQLERRMC-V        PIC X(255).                 
                                                                        
       01  PARM-FIELDS.                                                 
           05 PARM-SECTION                  PIC X(01) VALUE SPACES.     
           05 PARM-CALL-TYPE                PIC X(01) VALUE SPACES.     
           05 PARM-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0. 
           05 PARM-FXTR-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0. 
           05 PARM-FXTR-INST-LOC-NO         PIC X(10) VALUE SPACES.     
           05 PARM-FXTR-INST-POINT-NO       PIC S9(5)V COMP-3 VALUE 0.  
           05 PARM-FXTR-EQUIP-TAG-NO        PIC X(12) VALUE SPACES.     
           05 PARM-FXTR-INSTALL-LOC-CD      PIC X(01) VALUE SPACES.     
           05 PARM-FXTR-BILLING-FL          PIC X(01) VALUE SPACES.     
           05 PARM-USER-ID                  PIC X(07) VALUE SPACES.     
           05 PARM-TRAN-COMMENTS.                                       
              49 PARM-TRAN-COMMENTS-LEN     PIC S9(4) COMP VALUE 0.     
              49 PARM-TRAN-COMMENTS-TEXT    PIC X(250) VALUE SPACES.    
           05 PARM-ATTCH-EQUIP-SEQ          PIC S9(10)V COMP-3 VALUE 0. 
           05 PARM-ATTCH-INST-POINT-NO      PIC S9(5)V COMP-3 VALUE 0.  
           05 PARM-ATTCH-ATTACH-SEQ-NO      PIC S9(4) COMP VALUE 0.     
           05 PARM-I-EQUIP-TAG-NO           PIC X(12) VALUE SPACES.     
           05 PARM-I-STOCK-CD               PIC X(15) VALUE SPACES.     
           05 PARM-I-EQUIP-MFR-CD           PIC X(02) VALUE SPACES.     
           05 PARM-I-EQUIP-MFR-DT           PIC X(10) VALUE SPACES.     
           05 PARM-I-WARRANTY-EXP-DT        PIC X(10) VALUE SPACES.     
           05 PARM-I-EQUIP-DISPOSAL-DT      PIC X(10) VALUE SPACES.     
           05 PARM-I-STORAGE-FAC-CD         PIC X(03) VALUE SPACES.     
           05 PARM-I-WRNTY-RECEIVED-FL      PIC X(01) VALUE SPACES.     
           05 PARM-I-WRNTY-RECOUP-AMT       PIC S9(5)V99 COMP-3 VALUE 0.
           05 PARM-E-REVENUE-CLASS          PIC X(03) VALUE SPACES.     
           05 PARM-E-CODE-UTIL-TYPE         PIC X(01) VALUE SPACES.     
           05 PARM-E-BILLING-FL             PIC X(01) VALUE SPACES.     
           05 PARM-E-NO-BILL-REASON-CD      PIC X(02) VALUE SPACES.     
           05 PARM-E-RATE-PLAN-NO           PIC X(03) VALUE SPACES.     
           05 PARM-E-RATE-ITEM-CODE         PIC S9(4) COMP VALUE 0.     
           05 PARM-E-EQUIP-OWNER-CD         PIC X(01) VALUE SPACES.     
           05 PARM-E-EQUIP-CONTRACT-FL      PIC X(01) VALUE SPACES.     
           05 PARM-E-NO-CONTRACT-RSN-CD     PIC X(02) VALUE SPACES.     
           05 PARM-E-EQUIP-INSTALL-DT       PIC X(10) VALUE SPACES.     
           05 PARM-E-EQUIP-DRAWING-ID       PIC X(10) VALUE SPACES.     
           05 PARM-E-SPCL-AGR-COMMENTS.                                 
              49 PARM-E-SPCL-AGR-COMMENTS-LEN                           
                                            PIC S9(4) COMP VALUE 0.     
              49 PARM-E-SPCL-AGR-COMMENTS-TEXT                          
                                            PIC X(250) VALUE SPACES.    
           05 PARM-E-EQUIP-COMMENTS.                                    
              49 PARM-E-EQUIP-COMMENTS-LEN  PIC S9(4) COMP VALUE 0.     
              49 PARM-E-EQUIP-COMMENTS-TEXT PIC X(250) VALUE SPACES.    
ACT040     05 PARM-C-CNTRCT-CLP-NO          PIC X(50) VALUE SPACES.     
           05 PARM-C-CNTRCT-START-DT-CUR    PIC X(10) VALUE SPACES.     
           05 PARM-C-CNTRCT-START-DT-NEW    PIC X(10) VALUE SPACES.     
           05 PARM-C-CNTRCT-DURATION-CD     PIC X(02) VALUE SPACES.     
           05 PARM-C-CNTRCT-END-DT          PIC X(10) VALUE SPACES.     
ACT069     05 PARM-C-EFFECTIVE-DT           PIC X(10) VALUE SPACES.     
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS                      PIC S9(9) COMP VALUE 0.     
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW                   PIC X(01) VALUE 'N'.        
              88 NOT-ALL-DONE                         VALUE 'N'.        
              88 ALL-DONE                             VALUE 'Y'.        
           05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.        
              88 SEND-DONE-ERROR                      VALUE 'N'.        
              88 SEND-DONE-OK                         VALUE 'Y'.        
           05 WS-FIXTURE-EXISTS             PIC X(01) VALUE 'N'.        
              88 FIXTURE-NOT-EXISTS                   VALUE 'N'.        
              88 FIXTURE-EXISTS                       VALUE 'Y'.        
           05 WS-INVENTRY-STATUS-CD         PIC X(01) VALUE ' '.        
              88 IN-INVENTORY                         VALUE 'I'.        
              88 INSTALLED                            VALUE 'J'.        
              88 SCRAPPED                             VALUE 'S'.        
              88 IN-TRANSIT                           VALUE 'T'.        
              88 RCVD-IN-VNDR-FILE                    VALUE 'V'.        
           05 WS-ACTION-CODE                PIC X(01) VALUE ' '.        
              88 ADD-NEW-LIGHT                        VALUE 'N'.        
              88 ACTIVATE                             VALUE 'A'.        
              88 INACTIVATE                           VALUE 'I'.        
              88 REMOVE                               VALUE 'R'.        
              88 RATE-CHANGE                          VALUE 'C'.        
           05 WS-SECTION                    PIC X(01) VALUE ' '.        
              88 CONTRACT                             VALUE 'C'.        
              88 FIXTURE                              VALUE 'F'.        
              88 GIS                                  VALUE 'G'.        
              88 NODE                                 VALUE 'N'.        
              88 POLE                                 VALUE 'P'.        
           05 WS-SYNC-FLAG                  PIC X(01) VALUE 'N'.        
              88 DO-NOT-SYNC-FLAG                     VALUE 'N'.        
              88 SYNC-FLAG                            VALUE 'Y'.        
           05 WS-SYNC-RATE                  PIC X(01) VALUE 'N'.        
              88 DO-NOT-SYNC-RATE                     VALUE 'N'.        
              88 SYNC-RATE                            VALUE 'Y'.        
           05 WS-INS-DEL-ENV-TBL            PIC X(01) VALUE 'N'.        
              88 DO-NOT-INS-DEL-ENV-TBL               VALUE 'N'.        
              88 INS-DEL-ENV-TBL                      VALUE 'Y'.        
       01  GTT-MISC-FIELDS.                                             
           05 GTT-ROW.                                                  
              49 GTT-ROW-LEN                PIC S9(4) COMP.             
              49 GTT-ROW-CHAR               PIC X(1024).                
           05 GTT-SQLCODE                   PIC S9(9) COMP.             
           05 GTT-NAME                      PIC X(26) VALUE             
                                          'SESSION.CSR04769_R1'.        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE                 PIC S9(9) COMP VALUE 0.     
           05 S-APPL-RETURN-CODE            PIC S9(9) COMP VALUE 0.     
           05 S-BUS-RULE-ID                 PIC X(10) VALUE SPACES.     
           05 S-BUS-RULE-RESULT-CD          PIC X(08) VALUE SPACES.     
           05 S-BUS-RULE-XREF-ID            PIC X(26) VALUE SPACES.     
                                                                        
      *** WS TO GET THE MOST CURRENT ACCOUNT-NO AT A GIVEN PREMISE              
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      *** WS LMS COPYBOOK TO SYNC RATES                                         
           EXEC SQL                                                             
              INCLUDE CWSLM001                                                  
           END-EXEC.                                                            
                                                                        
      *** WS ABEND WORK AREA                                                    
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *** DB2 ERROR CHECKING.                                                   
           COPY CWS00303.                                                       
                                                                        
      *** SQL COMMUNICATION AREA                                                
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC .                                                           
                                                                        
      *** LMS_EQUIP_ENVRNMT,4F                                                  
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_INVENTRY,4D                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_CONTRACT,4L                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_FXTR_ATTACHMTS,4H                                                 
           EXEC SQL                                                             
              INCLUDE TBFXTATC                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST,4J                                                     
           EXEC SQL                                                             
              INCLUDE TBLGTHST                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST_DET,4S                                                 
           EXEC SQL                                                             
              INCLUDE TBLMSHST                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MNT_TRANS_HIST, MH                                                
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MT_TRN_HST_DET, MI                                                
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_ACCOUNT,AT                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
                                                                        
       01  LINK-SECTION                     PIC X(01).                  
       01  LINK-CALL-TYPE                   PIC X(01).                  
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.         
COB305 01 LINK-FXTR-EQUIP-SEQ        PIC S9(10)V COMP-3 VALUE 0.         
       01  LINK-FXTR-INST-LOC-NO            PIC X(10).                  
COB305 01 LINK-FXTR-INST-POINT-NO        PIC S9(5)V COMP-3 VALUE 0.          
       01  LINK-FXTR-EQUIP-TAG-NO           PIC X(12).                  
       01  LINK-FXTR-INSTALL-LOC-CD         PIC X(01).                  
       01  LINK-FXTR-BILLING-FL             PIC X(01).                  
       01  LINK-USER-ID                     PIC X(07).                  
       01  LINK-TRAN-COMMENTS.                                          
           05 LINK-TRAN-COMMENTS-LEN        PIC S9(04) COMP.            
           05 LINK-TRAN-COMMENTS-TEXT       PIC X(250).                 
COB305 01 LINK-ATTCH-EQUIP-SEQ        PIC S9(10)V COMP-3 VALUE 0.         
COB305 01 LINK-ATTCH-INST-POINT-NO        PIC S9(5)V COMP-3 VALUE 0.          
       01  LINK-ATTCH-ATTACH-SEQ-NO         PIC S9(4) COMP.             
       01  LINK-I-EQUIP-TAG-NO              PIC X(12).                  
       01  LINK-I-STOCK-CD                  PIC X(15).                  
       01  LINK-I-EQUIP-MFR-CD              PIC X(02).                  
       01  LINK-I-EQUIP-MFR-DT              PIC X(10).                  
       01  LINK-I-WARRANTY-EXP-DT           PIC X(10).                  
       01  LINK-I-EQUIP-DISPOSAL-DT         PIC X(10).                  
       01  LINK-I-STORAGE-FAC-CD            PIC X(03).                  
       01  LINK-I-WRNTY-RECEIVED-FL         PIC X(01).                  
COB305 01 LINK-I-WRNTY-RECOUP-AMT        PIC S9(5)V99 COMP-3 VALUE 0.        
       01  LINK-E-REVENUE-CLASS             PIC X(03).                  
       01  LINK-E-CODE-UTIL-TYPE            PIC X(01).                  
       01  LINK-E-BILLING-FL                PIC X(01).                  
       01  LINK-E-NO-BILL-REASON-CD         PIC X(02).                  
       01  LINK-E-RATE-PLAN-NO              PIC X(03).                  
       01  LINK-E-RATE-ITEM-CODE            PIC S9(4) COMP.             
       01  LINK-E-EQUIP-OWNER-CD            PIC X(01).                  
       01  LINK-E-EQUIP-CONTRACT-FL         PIC X(01).                  
       01  LINK-E-NO-CONTRACT-RSN-CD        PIC X(02).                  
       01  LINK-E-EQUIP-INSTALL-DT          PIC X(10).                  
       01  LINK-E-EQUIP-DRAWING-ID          PIC X(10).                  
       01  LINK-E-SPCL-AGR-COMMENTS.                                    
           05 LINK-E-SPCL-AGR-COMMENTS-LEN  PIC S9(4) COMP.             
           05 LINK-E-SPCL-AGR-COMMENTS-TEXT PIC X(250).                 
       01  LINK-E-EQUIP-COMMENTS.                                       
           05 LINK-E-EQUIP-COMMENTS-LEN     PIC S9(4) COMP.             
           05 LINK-E-EQUIP-COMMENTS-TEXT    PIC X(250).                 
ACT040 01  LINK-C-CNTRCT-CLP-NO             PIC X(50).                  
       01  LINK-C-CNTRCT-START-DT-CUR       PIC X(10).                  
       01  LINK-C-CNTRCT-START-DT-NEW       PIC X(10).                  
       01  LINK-C-CNTRCT-DURATION-CD        PIC X(02).                  
       01  LINK-C-CNTRCT-END-DT             PIC X(10).                  
ACT069 01  LINK-C-EFFECTIVE-DT              PIC X(10).                  
                                                                        
       PROCEDURE DIVISION USING LINK-SECTION                            
                                LINK-CALL-TYPE                          
                                LINK-ACCOUNT-NO                         
                                LINK-FXTR-EQUIP-SEQ                     
                                LINK-FXTR-INST-LOC-NO                   
                                LINK-FXTR-INST-POINT-NO                 
                                LINK-FXTR-EQUIP-TAG-NO                  
                                LINK-FXTR-INSTALL-LOC-CD                
                                LINK-FXTR-BILLING-FL                    
                                LINK-USER-ID                            
                                LINK-TRAN-COMMENTS                      
                                LINK-ATTCH-EQUIP-SEQ                    
                                LINK-ATTCH-INST-POINT-NO                
                                LINK-ATTCH-ATTACH-SEQ-NO                
                                LINK-I-EQUIP-TAG-NO                     
                                LINK-I-STOCK-CD                         
                                LINK-I-EQUIP-MFR-CD                     
                                LINK-I-EQUIP-MFR-DT                     
                                LINK-I-WARRANTY-EXP-DT                  
                                LINK-I-EQUIP-DISPOSAL-DT                
                                LINK-I-STORAGE-FAC-CD                   
                                LINK-I-WRNTY-RECEIVED-FL                
                                LINK-I-WRNTY-RECOUP-AMT                 
                                LINK-E-REVENUE-CLASS                    
                                LINK-E-CODE-UTIL-TYPE                   
                                LINK-E-BILLING-FL                       
                                LINK-E-NO-BILL-REASON-CD                
                                LINK-E-RATE-PLAN-NO                     
                                LINK-E-RATE-ITEM-CODE                   
                                LINK-E-EQUIP-OWNER-CD                   
                                LINK-E-EQUIP-CONTRACT-FL                
                                LINK-E-NO-CONTRACT-RSN-CD               
                                LINK-E-EQUIP-INSTALL-DT                 
                                LINK-E-EQUIP-DRAWING-ID                 
                                LINK-E-SPCL-AGR-COMMENTS                
                                LINK-E-EQUIP-COMMENTS                   
                                LINK-C-CNTRCT-CLP-NO                    
                                LINK-C-CNTRCT-START-DT-CUR              
                                LINK-C-CNTRCT-START-DT-NEW              
                                LINK-C-CNTRCT-DURATION-CD               
                                LINK-C-CNTRCT-END-DT                    
ACT069                          LINK-C-EFFECTIVE-DT.                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PARA     THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE-PARA                                           *        
      ******************************************************************        
       0100-INITIALIZE-PARA.                                            
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLLMS-EQUIP-CONTRACT                             
                      DCLLMS-EQUIP-ENVRNMT                              
                      DCLLMS-EQUIP-INVENTRY                             
                      DCLLMS-FXTR-ATTACHMTS                             
                      DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
           PERFORM 7000-GET-ACTION-DATE        THRU 7000-EXIT.          
           IF LINK-FXTR-EQUIP-TAG-NO > SPACES                           
           OR LINK-I-EQUIP-TAG-NO    > SPACES                           
              PERFORM 7025-TAG-NO-CASE-CNVRSN  THRU 7025-EXIT           
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04769_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04769_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS      THRU 8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04769_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04769_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-SECTION                TO PARM-SECTION             
                                               WS-SECTION.              
           MOVE LINK-CALL-TYPE              TO PARM-CALL-TYPE.          
           MOVE LINK-ACCOUNT-NO             TO PARM-ACCOUNT-NO.         
           MOVE LINK-FXTR-EQUIP-SEQ         TO PARM-FXTR-EQUIP-SEQ.     
           MOVE LINK-FXTR-INST-LOC-NO       TO PARM-FXTR-INST-LOC-NO.   
           MOVE LINK-FXTR-INST-POINT-NO     TO PARM-FXTR-INST-POINT-NO. 
           MOVE LINK-FXTR-EQUIP-TAG-NO      TO PARM-FXTR-EQUIP-TAG-NO.  
           MOVE LINK-FXTR-INSTALL-LOC-CD    TO PARM-FXTR-INSTALL-LOC-CD.
           MOVE LINK-FXTR-BILLING-FL        TO PARM-FXTR-BILLING-FL.    
           MOVE LINK-USER-ID                TO PARM-USER-ID.            
           MOVE LINK-TRAN-COMMENTS          TO PARM-TRAN-COMMENTS.      
           MOVE LINK-ATTCH-EQUIP-SEQ        TO PARM-ATTCH-EQUIP-SEQ.    
           MOVE LINK-ATTCH-INST-POINT-NO    TO PARM-ATTCH-INST-POINT-NO.
           MOVE LINK-ATTCH-ATTACH-SEQ-NO    TO PARM-ATTCH-ATTACH-SEQ-NO.
           MOVE LINK-I-EQUIP-TAG-NO         TO PARM-I-EQUIP-TAG-NO.     
           MOVE LINK-I-STOCK-CD             TO PARM-I-STOCK-CD.         
           MOVE LINK-I-EQUIP-MFR-CD         TO PARM-I-EQUIP-MFR-CD.     
           MOVE LINK-I-EQUIP-MFR-DT         TO PARM-I-EQUIP-MFR-DT.     
           MOVE LINK-I-WARRANTY-EXP-DT      TO PARM-I-WARRANTY-EXP-DT.  
           MOVE LINK-I-EQUIP-DISPOSAL-DT    TO PARM-I-EQUIP-DISPOSAL-DT.
           MOVE LINK-I-STORAGE-FAC-CD       TO PARM-I-STORAGE-FAC-CD.   
           MOVE LINK-I-WRNTY-RECEIVED-FL    TO PARM-I-WRNTY-RECEIVED-FL.
           MOVE LINK-I-WRNTY-RECOUP-AMT     TO PARM-I-WRNTY-RECOUP-AMT. 
           MOVE LINK-E-REVENUE-CLASS        TO PARM-E-REVENUE-CLASS.    
           MOVE LINK-E-CODE-UTIL-TYPE       TO PARM-E-CODE-UTIL-TYPE.   
           MOVE LINK-E-BILLING-FL           TO PARM-E-BILLING-FL.       
           MOVE LINK-E-NO-BILL-REASON-CD    TO PARM-E-NO-BILL-REASON-CD.
           MOVE LINK-E-RATE-PLAN-NO         TO PARM-E-RATE-PLAN-NO.     
           MOVE LINK-E-RATE-ITEM-CODE       TO PARM-E-RATE-ITEM-CODE.   
           MOVE LINK-E-EQUIP-OWNER-CD       TO PARM-E-EQUIP-OWNER-CD.   
           MOVE LINK-E-EQUIP-CONTRACT-FL    TO PARM-E-EQUIP-CONTRACT-FL.
           MOVE LINK-E-NO-CONTRACT-RSN-CD   TO PARM-E-NO-CONTRACT-RSN-CD
           MOVE LINK-E-EQUIP-INSTALL-DT     TO PARM-E-EQUIP-INSTALL-DT. 
           MOVE LINK-E-EQUIP-DRAWING-ID     TO PARM-E-EQUIP-DRAWING-ID. 
           MOVE LINK-C-CNTRCT-CLP-NO        TO PARM-C-CNTRCT-CLP-NO.    
           MOVE LINK-C-CNTRCT-START-DT-NEW  TO                          
                                            PARM-C-CNTRCT-START-DT-NEW. 
           MOVE LINK-C-CNTRCT-DURATION-CD   TO PARM-C-CNTRCT-DURATION-CD
           MOVE LINK-C-CNTRCT-END-DT        TO PARM-C-CNTRCT-END-DT.    
ACT069     MOVE LINK-C-EFFECTIVE-DT         TO PARM-C-EFFECTIVE-DT.     
           MOVE LINK-C-CNTRCT-START-DT-CUR  TO                          
                                            PARM-C-CNTRCT-START-DT-CUR. 
           MOVE LINK-E-EQUIP-COMMENTS       TO PARM-E-EQUIP-COMMENTS.   
           MOVE LINK-E-SPCL-AGR-COMMENTS    TO PARM-E-SPCL-AGR-COMMENTS.
                                                                        
           INSPECT PARM-TRAN-COMMENTS-TEXT                              
             REPLACING ALL LOW-VALUES BY SPACES.                        
           INSPECT PARM-E-SPCL-AGR-COMMENTS-TEXT                        
             REPLACING ALL LOW-VALUES BY SPACES.                        
           INSPECT PARM-E-EQUIP-COMMENTS-TEXT                           
             REPLACING ALL LOW-VALUES BY SPACES.                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
              WHEN FIXTURE                                              
                PERFORM 2100-PROCESS-FIXTURE   THRU 2100-EXIT           
                                                                        
              WHEN POLE                                                 
                PERFORM 2200-PROCESS-POLE      THRU 2200-EXIT           
                                                                        
              WHEN NODE                                                 
                PERFORM 2300-PROCESS-NODE      THRU 2300-EXIT           
                                                                        
              WHEN CONTRACT                                             
                PERFORM 2400-PROCESS-CONTRACT  THRU 2400-EXIT           
                                                                        
              WHEN GIS                                                  
                PERFORM 2500-PROCESS-GIS       THRU 2500-EXIT           
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE.            
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2100-PROCESS-FIXTURE.                                            
                                                                        
      *** CHECK IF FIXTURE ALREADY EXISTS IN LMS. IF EXISTS, RETURN             
      *** TO SCREEN WITH BUSINESS RULE.                                         
           PERFORM 5400-CHK-IF-EQUIP-EXISTS    THRU 5400-EXIT.          
           IF FIXTURE-EXISTS                                            
              MOVE ZERO                     TO WS-ACTIVE-RETURN-CODE    
              MOVE 'LMS0000009'             TO S-BUS-RULE-ID            
              GO TO 2100-EXIT                                           
           END-IF.                                                      
                                                                        
      *** CHECK FOR INVENTORY CHANGES                                           
           MOVE PARM-FXTR-EQUIP-SEQ         TO 4D-EQUIP-SEQ.            
           PERFORM 7100-GET-EQUIP-INVENTRY     THRU 7100-EXIT.          
           MOVE 4D-INVENTRY-STATUS-CD       TO WS-INVENTRY-STATUS-CD.   
           IF RCVD-IN-VNDR-FILE                                         
              MOVE 4D-INVENTRY-STATUS-CD    TO WS-PRV-INVENTRY-STATUS-CD
              MOVE WS-INVENTORY             TO 4D-INVENTRY-STATUS-CD    
           END-IF.                                                      
           PERFORM 5000-COMPARE-EQUIP-INV      THRU 5000-EXIT.          
           PERFORM 8200-UPDATE-EQUIP-INV       THRU 8200-EXIT.          
                                                                        
      *** CHECK FOR ENVIRONMENT CHANGES                                         
           IF PARM-FXTR-INST-LOC-NO > SPACES                            
              MOVE PARM-FXTR-INST-LOC-NO    TO 4F-INSTALL-LOC-NO        
              MOVE PARM-FXTR-INST-POINT-NO  TO 4F-INSTALL-POINT-NO      
              MOVE PARM-FXTR-EQUIP-SEQ      TO 4F-EQUIP-SEQ             
              PERFORM 7200-GET-EQUIP-ENV       THRU 7200-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 IF PARM-FXTR-BILLING-FL = 'Z'                          
                    MOVE PARM-FXTR-EQUIP-SEQ TO 4F-EQUIP-SEQ            
                    PERFORM 7250-GET-FXTR-EQUIP-ENV  THRU  7250-EXIT    
                 ELSE                                                   
                    PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT     
                 END-IF                                                 
              END-IF                                                    
              PERFORM 5100-COMPARE-EQUIP-ENV   THRU 5100-EXIT           
           END-IF.                                                      
                                                                        
      *** WHEN BILL FLAG COMES IN AS START BILLING 'Z', CHECK IF THERE          
      *** IS A SWAP BETWEEN PREMISE AND SUBDIVISION OR VICE VERSA.              
      *** CUST PLAN COPYBOOK IS NOT CALLED UNTIL IT'S BILLED.                   
           IF PARM-FXTR-BILLING-FL = 'Z'                                
              IF PARM-E-EQUIP-CONTRACT-FL = WS-YES                      
                 MOVE SPACES                TO 4F-NO-CONTRACT-RSN-CD    
              END-IF                                                    
              PERFORM 5500-SUBDIV-PREM-SWAP    THRU 5500-EXIT           
           ELSE                                                         
              IF INSTALLED                                              
                 IF PARM-FXTR-INSTALL-LOC-CD = 'P'                      
                    PERFORM 5300-CHECK-PREM-LIGHT THRU 5300-EXIT        
                 ELSE                                                   
                    PERFORM 8300-UPDATE-EQUIP-ENV THRU 8300-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
ACT004     IF WS-UPDATE-POLE-DATA-FL = 'Y'                              
ACT004        PERFORM 8375-UPDATE-EQUIP-ENV-POLE  THRU  8375-EXIT       
ACT004     END-IF.                                                      
ACT004                                                                  
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
      ***  SET THE ACCOUNT STATUS TO ACTIVE FROM PENDING                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-PROCESS-POLE.                                               
                                                                        
           MOVE PARM-ATTCH-EQUIP-SEQ        TO 4D-EQUIP-SEQ             
           PERFORM 7100-GET-EQUIP-INVENTRY     THRU 7100-EXIT.          
           PERFORM 5000-COMPARE-EQUIP-INV      THRU 5000-EXIT.          
           PERFORM 8200-UPDATE-EQUIP-INV       THRU 8200-EXIT.          
                                                                        
           IF PARM-FXTR-INST-LOC-NO > SPACES                            
              MOVE PARM-FXTR-INST-LOC-NO    TO 4F-INSTALL-LOC-NO        
              MOVE PARM-ATTCH-INST-POINT-NO TO 4F-INSTALL-POINT-NO      
              MOVE PARM-ATTCH-EQUIP-SEQ     TO 4F-EQUIP-SEQ             
              PERFORM 7200-GET-EQUIP-ENV       THRU 7200-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
              END-IF                                                    
              PERFORM 5100-COMPARE-EQUIP-ENV   THRU 5100-EXIT           
           END-IF.                                                      
                                                                        
           MOVE 4D-INVENTRY-STATUS-CD       TO WS-INVENTRY-STATUS-CD.   
                                                                        
      *** WHEN BILL FLAG COMES IN AS START BILLING 'Z', CHECK BILLING           
      *** FLAG & CONTRACT FLAG AND SPACE OUT RATE/RATE PLAN/CONTRACT - N        
      *** CUST PLAN COPYBOOK IS NOT CALLED UNTIL IT'S BILLED.                   
           IF PARM-FXTR-BILLING-FL = 'Z'                                
              EVALUATE PARM-E-BILLING-FL                                
                  WHEN 'N'                                              
                       MOVE SPACES          TO 4F-RATE-PLAN-NO          
                       MOVE ZEROES          TO 4F-RATE-ITEM-CODE        
                  WHEN 'Z'                                              
                       MOVE SPACES          TO 4F-NO-BILL-REASON-CD     
              END-EVALUATE                                              
              PERFORM 8300-UPDATE-EQUIP-ENV    THRU 8300-EXIT           
           ELSE                                                         
              IF INSTALLED                                              
                 IF PARM-FXTR-INSTALL-LOC-CD = 'P'                      
                    PERFORM 5300-CHECK-PREM-LIGHT THRU 5300-EXIT        
                 ELSE                                                   
                    PERFORM 8300-UPDATE-EQUIP-ENV THRU 8300-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-PROCESS-NODE.                                               
                                                                        
           MOVE PARM-ATTCH-EQUIP-SEQ        TO 4D-EQUIP-SEQ             
                                               4H-ATTACH-EQUIP-SEQ.     
                                                                        
           PERFORM 7100-GET-EQUIP-INVENTRY     THRU 7100-EXIT.          
           MOVE 4D-INVENTRY-STATUS-CD       TO WS-PRV-INVENTRY-STATUS-CD
                                                                        
           MOVE PARM-ATTCH-EQUIP-SEQ        TO 4D-EQUIP-SEQ             
           MOVE PARM-SECTION                TO 4H-EQUIP-TYPE-CD.        
           MOVE PARM-FXTR-EQUIP-SEQ         TO 4H-FXTR-EQUIP-SEQ.       
           PERFORM 8510-DELETE-FXTR-ATTACHMTS  THRU 8510-EXIT.          
                                                                        
           MOVE WS-REMOVED                  TO 4D-INVENTRY-STATUS-CD.   
           PERFORM 8200-UPDATE-EQUIP-INV       THRU 8200-EXIT.          
                                                                        
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-PROCESS-CONTRACT.                                           
      *** PARM-CALL-TYPE WILL BE 'U' IF CNTRCT-START-DT IS NOT CHANGED          
      *** PARM-CALL-TYPE WILL BE 'R' IF CNTRCT-START-DT IS CHANGED              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO 4L-ACCOUNT-NO.           
           MOVE PARM-FXTR-EQUIP-SEQ         TO 4L-EQUIP-SEQ.            
           MOVE PARM-C-CNTRCT-START-DT-CUR  TO 4L-CNTRCT-START-DT.      
           PERFORM 7300-GET-EQUIP-CONTRACT     THRU 7300-EXIT.          
                                                                        
           IF PARM-CALL-TYPE = 'U'                                      
              PERFORM 5200-COMPARE-EQUIP-CNT   THRU 5200-EXIT           
              PERFORM 8400-UPDATE-EQUIP-CNT    THRU 8400-EXIT           
           ELSE                                                         
              MOVE 4L-CNTRCT-CLP-NO         TO WS-PRV-CNTRCT-CLP-NO     
              MOVE 4L-CNTRCT-START-DT       TO WS-PRV-CNTRCT-START-DT   
              MOVE 4L-CNTRCT-DURATION-CD    TO WS-PRV-CNTRCT-DURATION-CD
              MOVE 4L-CNTRCT-END-DT         TO WS-PRV-CNTRCT-END-DT     
              PERFORM 8520-DELETE-EQUIP-CNT    THRU 8520-EXIT           
              MOVE PARM-C-CNTRCT-CLP-NO     TO 4L-CNTRCT-CLP-NO         
              MOVE PARM-C-CNTRCT-START-DT-NEW                           
                                            TO 4L-CNTRCT-START-DT       
              MOVE PARM-C-CNTRCT-DURATION-CD                            
                                            TO 4L-CNTRCT-DURATION-CD    
              MOVE PARM-C-CNTRCT-END-DT     TO 4L-CNTRCT-END-DT         
              MOVE -1                       TO WS-CNTRCT-END-DT-IND     
                                               WS-ACTL-CHRG-DT-IND      
              IF 4L-CNTRCT-END-DT > SPACES                              
                 MOVE +0                    TO WS-CNTRCT-END-DT-IND     
              END-IF                                                    
              IF 4L-ACTL-CHRG-DT > SPACES                               
                 MOVE +0                    TO WS-ACTL-CHRG-DT-IND      
              END-IF                                                    
              PERFORM 8550-INSERT-EQUIP-CNT    THRU 8550-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-PROCESS-GIS.                                                
                                                                        
ACT064*** CHECK IF FIXTURE ALREADY EXISTS IN LMS. IF EXISTS, RETURN             
ACT064*** TO SCREEN WITH BUSINESS RULE.                                         
ACT064     PERFORM 5400-CHK-IF-EQUIP-EXISTS    THRU 5400-EXIT.          
ACT064     IF FIXTURE-EXISTS                                            
ACT064        MOVE ZERO                     TO WS-ACTIVE-RETURN-CODE    
ACT064        MOVE 'LMS0000009'             TO S-BUS-RULE-ID            
ACT064        GO TO 2100-EXIT                                           
ACT064     END-IF.                                                      
ACT064                                                                  
           PERFORM 7500-GET-FIXTURE-DETAILS    THRU 7500-EXIT.          
                                                                        
           PERFORM 8210-UPDATE-GIS-EQUIP-TAG   THRU 8210-EXIT.          
                                                                        
           IF 4F-INSTALL-LOC-CD = 'P'                                   
              MOVE 4F-INSTALL-LOC-NO        TO WS-CPD99-PREMISE-NO      
              PERFORM 6990-FETCH-CUR-ACCOUNT   THRU 6990-EXIT           
              MOVE WS-CPD99-ACCOUNT-NO      TO 4J-ACCOUNT-NO            
           ELSE                                                         
              MOVE PARM-ACCOUNT-NO          TO 4J-ACCOUNT-NO            
           END-IF.                                                      
                                                                        
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-COMPARE-EQUIP-INV.                                          
                                                                        
           IF PARM-I-EQUIP-TAG-NO NOT = 4D-EQUIP-TAG-NO                 
              MOVE 4D-EQUIP-TAG-NO       TO WS-PRV-EQUIP-TAG-NO         
              MOVE PARM-I-EQUIP-TAG-NO   TO 4D-EQUIP-TAG-NO             
           ELSE                                                         
              MOVE PARM-I-EQUIP-TAG-NO   TO WS-PRV-EQUIP-TAG-NO         
           END-IF.                                                      
                                                                        
           IF PARM-I-STOCK-CD NOT = 4D-STOCK-CD                         
              MOVE 4D-STOCK-CD           TO WS-PRV-STOCK-CD             
              MOVE PARM-I-STOCK-CD       TO 4D-STOCK-CD                 
           ELSE                                                         
              MOVE PARM-I-STOCK-CD       TO WS-PRV-STOCK-CD             
           END-IF.                                                      
                                                                        
           IF FIXTURE                                                   
              IF PARM-I-EQUIP-MFR-CD NOT = 4D-EQUIP-MFR-CD              
                 MOVE 4D-EQUIP-MFR-CD       TO WS-PRV-EQUIP-MFR-CD      
                 MOVE PARM-I-EQUIP-MFR-CD   TO 4D-EQUIP-MFR-CD          
              ELSE                                                      
                 MOVE PARM-I-EQUIP-MFR-CD   TO WS-PRV-EQUIP-MFR-CD      
              END-IF                                                    
                                                                        
              IF PARM-I-EQUIP-MFR-DT NOT = 4D-EQUIP-MFR-DT              
                 MOVE 4D-EQUIP-MFR-DT       TO WS-PRV-EQUIP-MFR-DT      
                 MOVE PARM-I-EQUIP-MFR-DT   TO 4D-EQUIP-MFR-DT          
                 IF 4D-EQUIP-MFR-DT > SPACES                            
                    MOVE ZERO               TO WS-EQUIP-MFR-DT-IND      
                 ELSE                                                   
                    MOVE -1                 TO WS-EQUIP-MFR-DT-IND      
                 END-IF                                                 
              ELSE                                                      
                 MOVE PARM-I-EQUIP-MFR-DT   TO WS-PRV-EQUIP-MFR-DT      
              END-IF                                                    
                                                                        
              IF PARM-I-WARRANTY-EXP-DT NOT = 4D-WARRANTY-EXP-DT        
                 MOVE 4D-WARRANTY-EXP-DT    TO WS-PRV-WARRANTY-EXP-DT   
                 MOVE PARM-I-WARRANTY-EXP-DT TO 4D-WARRANTY-EXP-DT      
                 IF 4D-WARRANTY-EXP-DT > SPACES                         
                    MOVE ZERO               TO WS-WARRANTY-EXP-DT-IND   
                 ELSE                                                   
                    MOVE -1                 TO WS-WARRANTY-EXP-DT-IND   
                 END-IF                                                 
              ELSE                                                      
                 MOVE PARM-I-WARRANTY-EXP-DT TO WS-PRV-WARRANTY-EXP-DT  
              END-IF                                                    
                                                                        
              IF PARM-I-EQUIP-DISPOSAL-DT NOT = 4D-EQUIP-DISPOSAL-DT    
                 MOVE 4D-EQUIP-DISPOSAL-DT  TO WS-PRV-EQUIP-DISPOSAL-DT 
                 MOVE PARM-I-EQUIP-DISPOSAL-DT TO 4D-EQUIP-DISPOSAL-DT  
                 IF 4D-EQUIP-DISPOSAL-DT > SPACES                       
                    MOVE ZERO               TO WS-EQUIP-DISPOSAL-DT-IND 
                 ELSE                                                   
                    MOVE -1                 TO WS-EQUIP-DISPOSAL-DT-IND 
                 END-IF                                                 
              ELSE                                                      
               MOVE PARM-I-EQUIP-DISPOSAL-DT TO WS-PRV-EQUIP-DISPOSAL-DT
              END-IF                                                    
                                                                        
              IF PARM-I-STORAGE-FAC-CD NOT = 4D-STORAGE-FAC-CD          
                 MOVE 4D-STORAGE-FAC-CD     TO WS-PRV-STORAGE-FAC-CD    
                 MOVE PARM-I-STORAGE-FAC-CD TO 4D-STORAGE-FAC-CD        
              ELSE                                                      
                 MOVE PARM-I-STORAGE-FAC-CD TO WS-PRV-STORAGE-FAC-CD    
              END-IF                                                    
                                                                        
              IF PARM-I-WRNTY-RECEIVED-FL NOT = 4D-WRNTY-RECEIVED-FL    
                 MOVE 4D-WRNTY-RECEIVED-FL  TO WS-PRV-WRNTY-RECEIVED-FL 
                 MOVE PARM-I-WRNTY-RECEIVED-FL TO 4D-WRNTY-RECEIVED-FL  
              ELSE                                                      
               MOVE PARM-I-WRNTY-RECEIVED-FL TO WS-PRV-WRNTY-RECEIVED-FL
              END-IF                                                    
                                                                        
              IF PARM-I-WRNTY-RECOUP-AMT NOT = 4D-WRNTY-RECOUP-AMT      
                 MOVE 4D-WRNTY-RECOUP-AMT   TO WS-PRV-WRNTY-RECOUP-AMT  
                 MOVE PARM-I-WRNTY-RECOUP-AMT TO 4D-WRNTY-RECOUP-AMT    
              ELSE                                                      
                 MOVE PARM-I-WRNTY-RECOUP-AMT TO WS-PRV-WRNTY-RECOUP-AMT
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-COMPARE-EQUIP-ENV.                                          
                                                                        
           IF PARM-E-CODE-UTIL-TYPE NOT = 4F-CODE-UTIL-TYPE             
              MOVE 4F-CODE-UTIL-TYPE        TO WS-PRV-CODE-UTIL-TYPE    
              MOVE PARM-E-CODE-UTIL-TYPE    TO 4F-CODE-UTIL-TYPE        
           ELSE                                                         
              MOVE PARM-E-RATE-PLAN-NO      TO WS-PRV-CODE-UTIL-TYPE    
           END-IF.                                                      
                                                                        
           IF PARM-E-RATE-PLAN-NO NOT = 4F-RATE-PLAN-NO                 
              MOVE 4F-RATE-PLAN-NO          TO WS-PRV-RATE-PLAN-NO      
              MOVE PARM-E-RATE-PLAN-NO      TO 4F-RATE-PLAN-NO          
           ELSE                                                         
              MOVE PARM-E-RATE-PLAN-NO      TO WS-PRV-RATE-PLAN-NO      
           END-IF.                                                      
                                                                        
           IF PARM-E-RATE-ITEM-CODE NOT = 4F-RATE-ITEM-CODE             
              MOVE 4F-RATE-ITEM-CODE        TO WS-PRV-RATE-ITEM-CODE    
              MOVE PARM-E-RATE-ITEM-CODE    TO 4F-RATE-ITEM-CODE        
           ELSE                                                         
              MOVE PARM-E-RATE-ITEM-CODE    TO WS-PRV-RATE-ITEM-CODE    
           END-IF.                                                      
                                                                        
           IF PARM-E-BILLING-FL NOT = 4F-BILLING-FL                     
              MOVE 4F-BILLING-FL            TO WS-PRV-BILLING-FL        
              MOVE PARM-E-BILLING-FL        TO 4F-BILLING-FL            
           ELSE                                                         
              MOVE PARM-E-BILLING-FL        TO WS-PRV-BILLING-FL        
           END-IF.                                                      
                                                                        
           IF PARM-E-NO-BILL-REASON-CD NOT = 4F-NO-BILL-REASON-CD       
              MOVE 4F-NO-BILL-REASON-CD     TO WS-PRV-NO-BILL-REASON-CD 
              MOVE PARM-E-NO-BILL-REASON-CD TO 4F-NO-BILL-REASON-CD     
           ELSE                                                         
              MOVE PARM-E-NO-BILL-REASON-CD TO WS-PRV-NO-BILL-REASON-CD 
           END-IF.                                                      
                                                                        
           IF PARM-E-EQUIP-OWNER-CD NOT = 4F-EQUIP-OWNER-CD             
              MOVE 4F-EQUIP-OWNER-CD        TO WS-PRV-EQUIP-OWNER-CD    
              MOVE PARM-E-EQUIP-OWNER-CD    TO 4F-EQUIP-OWNER-CD        
           ELSE                                                         
              MOVE PARM-E-EQUIP-OWNER-CD    TO WS-PRV-EQUIP-OWNER-CD    
           END-IF.                                                      
                                                                        
           IF FIXTURE                                                   
              IF PARM-E-NO-CONTRACT-RSN-CD NOT = 4F-NO-CONTRACT-RSN-CD  
                 MOVE 4F-NO-CONTRACT-RSN-CD TO WS-PRV-NO-CONTRACT-RSN-CD
                 MOVE PARM-E-NO-CONTRACT-RSN-CD                         
                                            TO 4F-NO-CONTRACT-RSN-CD    
              ELSE                                                      
                 MOVE PARM-E-NO-CONTRACT-RSN-CD                         
                                            TO WS-PRV-NO-CONTRACT-RSN-CD
              END-IF                                                    
                                                                        
              IF PARM-E-EQUIP-CONTRACT-FL NOT = 4F-EQUIP-CONTRACT-FL    
                 MOVE 4F-EQUIP-CONTRACT-FL  TO WS-PRV-EQUIP-CONTRACT-FL 
                 MOVE PARM-E-EQUIP-CONTRACT-FL                          
                                            TO 4F-EQUIP-CONTRACT-FL     
              ELSE                                                      
                 MOVE PARM-E-EQUIP-CONTRACT-FL                          
                                            TO WS-PRV-EQUIP-CONTRACT-FL 
              END-IF                                                    
                                                                        
              IF PARM-E-EQUIP-INSTALL-DT NOT = 4F-EQUIP-INSTALL-DT      
                 MOVE 4F-EQUIP-INSTALL-DT   TO WS-PRV-EQUIP-INSTALL-DT  
                 MOVE PARM-E-EQUIP-INSTALL-DT                           
                                            TO 4F-EQUIP-INSTALL-DT      
                 IF 4F-EQUIP-INSTALL-DT > SPACES                        
                    MOVE 0                  TO WS-EQUIP-INSTALL-DT-IND  
                 ELSE                                                   
                    MOVE -1                 TO WS-EQUIP-INSTALL-DT-IND  
                 END-IF                                                 
ACT004*** UPDATE POLE(S) DATA: UPDATE INSTALL DATE                              
ACT004           IF PARM-FXTR-BILLING-FL = 'Z'                          
ACT004              MOVE 'Y'                TO WS-UPDATE-POLE-DATA-FL   
ACT004           END-IF                                                 
              ELSE                                                      
                 MOVE PARM-E-EQUIP-INSTALL-DT                           
                                            TO WS-PRV-EQUIP-INSTALL-DT  
              END-IF                                                    
                                                                        
              IF PARM-E-EQUIP-DRAWING-ID NOT = 4F-EQUIP-DRAWING-ID      
                 MOVE 4F-EQUIP-DRAWING-ID   TO WS-PRV-EQUIP-DRAWING-ID  
                 MOVE PARM-E-EQUIP-DRAWING-ID                           
                                            TO 4F-EQUIP-DRAWING-ID      
              ELSE                                                      
                 MOVE PARM-E-EQUIP-DRAWING-ID                           
                                            TO WS-PRV-EQUIP-DRAWING-ID  
              END-IF                                                    
                                                                        
              IF PARM-E-SPCL-AGR-COMMENTS-TEXT NOT =                    
                                               4F-SPCL-AGR-COMMENTS-TEXT
                 IF PARM-E-SPCL-AGR-COMMENTS-TEXT > SPACES              
                    MOVE PARM-E-SPCL-AGR-COMMENTS-TEXT                  
                                            TO 4F-SPCL-AGR-COMMENTS-TEXT
                    MOVE PARM-E-SPCL-AGR-COMMENTS-LEN                   
                                            TO 4F-SPCL-AGR-COMMENTS-LEN 
                 ELSE                                                   
                    MOVE SPACES             TO 4F-SPCL-AGR-COMMENTS-TEXT
                    MOVE ZERO               TO 4F-SPCL-AGR-COMMENTS-LEN 
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF PARM-E-EQUIP-COMMENTS-TEXT NOT = 4F-EQUIP-COMMENTS-TEXT
                 IF PARM-E-EQUIP-COMMENTS-TEXT > SPACES                 
                    MOVE PARM-E-EQUIP-COMMENTS-TEXT                     
                                            TO 4F-EQUIP-COMMENTS-TEXT   
                    MOVE PARM-E-EQUIP-COMMENTS-LEN                      
                                            TO 4F-EQUIP-COMMENTS-LEN    
                 ELSE                                                   
                    MOVE SPACES             TO 4F-EQUIP-COMMENTS-TEXT   
                    MOVE ZERO               TO 4F-EQUIP-COMMENTS-LEN    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-COMPARE-EQUIP-CNT.                                          
                                                                        
           IF PARM-C-CNTRCT-CLP-NO NOT = 4L-CNTRCT-CLP-NO               
              MOVE 4L-CNTRCT-CLP-NO         TO WS-PRV-CNTRCT-CLP-NO     
              MOVE PARM-C-CNTRCT-CLP-NO     TO 4L-CNTRCT-CLP-NO         
           ELSE                                                         
              MOVE PARM-C-CNTRCT-CLP-NO     TO WS-PRV-CNTRCT-CLP-NO     
           END-IF.                                                      
                                                                        
           IF PARM-C-CNTRCT-DURATION-CD NOT = 4L-CNTRCT-DURATION-CD     
              MOVE 4L-CNTRCT-DURATION-CD    TO WS-PRV-CNTRCT-DURATION-CD
              MOVE PARM-C-CNTRCT-DURATION-CD TO 4L-CNTRCT-DURATION-CD   
           ELSE                                                         
              MOVE PARM-C-CNTRCT-DURATION-CD                            
                                            TO WS-PRV-CNTRCT-DURATION-CD
           END-IF.                                                      
                                                                        
           IF PARM-C-CNTRCT-END-DT NOT = 4L-CNTRCT-END-DT               
              MOVE 4L-CNTRCT-END-DT         TO WS-PRV-CNTRCT-END-DT     
              MOVE PARM-C-CNTRCT-END-DT     TO 4L-CNTRCT-END-DT         
              IF 4L-CNTRCT-END-DT > SPACES                              
                 MOVE ZERO                  TO WS-CNTRCT-END-DT-IND     
              ELSE                                                      
                 MOVE -1                    TO WS-CNTRCT-END-DT-IND     
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-C-CNTRCT-END-DT     TO WS-PRV-CNTRCT-END-DT     
           END-IF.                                                      
                                                                        
           IF PARM-C-CNTRCT-START-DT-CUR = 4L-CNTRCT-START-DT           
              MOVE 4L-CNTRCT-START-DT       TO WS-PRV-CNTRCT-START-DT   
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5300-CHECK-PREM-LIGHT.                                           
      *                                                                         
           EVALUATE TRUE                                                
      *      WHEN (CONDITION-1)                                                 
             WHEN  FIXTURE                                              
              AND  WS-PRV-BILLING-FL = 'Y'                              
              AND  PARM-E-BILLING-FL = 'Y'                              
              AND (PARM-E-RATE-PLAN-NO NOT = WS-PRV-RATE-PLAN-NO        
                OR PARM-E-RATE-ITEM-CODE NOT = WS-PRV-RATE-ITEM-CODE)   
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER  THRU  8325-EXIT     
               SET RATE-CHANGE              TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *      WHEN (CONDITION-2)                                                 
             WHEN  FIXTURE                                              
              AND  WS-PRV-BILLING-FL = 'Y'                              
              AND  PARM-E-BILLING-FL = 'N'                              
              AND  PARM-E-RATE-PLAN-NO = WS-PRV-RATE-PLAN-NO            
              AND  PARM-E-RATE-ITEM-CODE = WS-PRV-RATE-ITEM-CODE        
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER  THRU  8325-EXIT     
               SET INACTIVATE               TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *      WHEN (CONDITION-3)                                                 
             WHEN  FIXTURE                                              
              AND  WS-PRV-BILLING-FL = 'N'                              
              AND  PARM-E-BILLING-FL = 'Y'                              
              AND  PARM-E-RATE-PLAN-NO = WS-PRV-RATE-PLAN-NO            
              AND  PARM-E-RATE-ITEM-CODE = WS-PRV-RATE-ITEM-CODE        
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER  THRU  8325-EXIT     
               SET ACTIVATE                 TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *      WHEN (CONDITION-4)                                                 
             WHEN  FIXTURE                                              
              AND  WS-PRV-BILLING-FL = 'N'                              
              AND  PARM-E-BILLING-FL = 'Y'                              
              AND (PARM-E-RATE-PLAN-NO NOT = WS-PRV-RATE-PLAN-NO        
                OR PARM-E-RATE-ITEM-CODE NOT = WS-PRV-RATE-ITEM-CODE)   
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER  THRU  8325-EXIT     
               SET RATE-CHANGE              TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *RATE-CHANGE CALL INDIRECTLY TAKEN CARE OF ACTIVATING THE NEW RATE        
      *AND ENVRNMNT.SO COMMENTING ACTIVATE CALL.                                
      *        SET ACTIVATE                 TO TRUE                             
      *        PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT                     
      *      WHEN (CONDITION-5)                                                 
             WHEN  POLE                                                 
              AND  WS-PRV-BILLING-FL = 'Y'                              
              AND  PARM-E-BILLING-FL = 'Y'                              
              AND (PARM-E-RATE-PLAN-NO NOT = WS-PRV-RATE-PLAN-NO        
                OR PARM-E-RATE-ITEM-CODE NOT = WS-PRV-RATE-ITEM-CODE)   
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER  THRU  8325-EXIT     
               SET RATE-CHANGE              TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *      WHEN (CONDITION-6)                                                 
             WHEN  POLE                                                 
              AND  WS-PRV-BILLING-FL = 'Y'                              
              AND  PARM-E-BILLING-FL = 'N'                              
              AND  PARM-E-RATE-PLAN-NO = WS-PRV-RATE-PLAN-NO            
              AND  PARM-E-RATE-ITEM-CODE = WS-PRV-RATE-ITEM-CODE        
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER  THRU  8325-EXIT     
               SET INACTIVATE               TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *      WHEN (CONDITION-7)                                                 
             WHEN  POLE                                                 
              AND  WS-PRV-BILLING-FL = 'N'                              
              AND  PARM-E-BILLING-FL = 'Y'                              
              AND  PARM-E-RATE-PLAN-NO = WS-PRV-RATE-PLAN-NO            
              AND  PARM-E-RATE-ITEM-CODE = WS-PRV-RATE-ITEM-CODE        
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER  THRU  8325-EXIT     
               SET ACTIVATE                 TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *      WHEN (CONDITION-8)                                                 
             WHEN  POLE                                                 
              AND  WS-PRV-BILLING-FL = 'N'                              
              AND  PARM-E-BILLING-FL = 'Y'                              
              AND  WS-PRV-RATE-PLAN-NO = SPACES                         
              AND  PARM-E-RATE-PLAN-NO > SPACES                         
              AND  WS-PRV-RATE-ITEM-CODE = 0                            
              AND  PARM-E-RATE-ITEM-CODE > 0                            
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER     THRU 8325-EXIT   
               PERFORM 8350-UPDATE-EQUIP-ENV-NEW-LGHT  THRU 8350-EXIT   
               SET ADD-NEW-LIGHT            TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *      WHEN (CONDITION-9)                                                 
             WHEN  POLE                                                 
              AND  WS-PRV-BILLING-FL = 'N'                              
              AND  PARM-E-BILLING-FL = 'Y'                              
              AND (PARM-E-RATE-PLAN-NO NOT = WS-PRV-RATE-PLAN-NO        
                OR PARM-E-RATE-ITEM-CODE NOT = WS-PRV-RATE-ITEM-CODE)   
               PERFORM 8325-UPDATE-EQUIP-ENV-OTHER     THRU 8325-EXIT   
               SET RATE-CHANGE              TO TRUE                     
               PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT             
      *RATE-CHANGE CALL INDIRECTLY TAKEN CARE OF ACTIVATING THE NEW RATE        
      *AND ENVRNMNT.SO COMMENTING ACTIVATE CALL.                                
      *        SET ACTIVATE                 TO TRUE                             
      *        PERFORM 5350-CALL-CUSTPLAN   THRU  5350-EXIT                     
             WHEN OTHER                                                 
               IF 4F-CODE-UTIL-TYPE > ' '  AND                          
                  4F-IC-NO          > 0    AND                          
                  4F-RATE-PLAN-NO   > ' '  AND                          
                  4F-RATE-ITEM-CODE >  0   AND                          
                 (4F-BILLING-FL     = 'Y' OR 'N')                       
                                                                        
                  MOVE PARM-ACCOUNT-NO     TO UT-ACCOUNT-NO             
                  MOVE 4F-INSTALL-LOC-NO   TO UT-PREMISE-NO             
                  MOVE 4F-CODE-UTIL-TYPE   TO UT-CODE-UTIL-TYPE         
                  MOVE 4F-IC-NO            TO UT-IC-NO                  
                  MOVE 4F-RATE-PLAN-NO     TO UT-RATE-PLAN-NO           
                  PERFORM 7600-GET-UTIL-ENV-DATA  THRU  7600-EXIT       
                                                                        
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND        
                     UT-CODE-REVENUE-CLASS NOT = PARM-E-REVENUE-CLASS   
                     MOVE 'LMS0000045'     TO S-BUS-RULE-ID             
                     MOVE 'F'              TO S-BUS-RULE-RESULT-CD      
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
                  ELSE                                                  
                     PERFORM 8325-UPDATE-EQUIP-ENV-OTHER THRU 8325-EXIT 
                  END-IF                                                
               ELSE                                                     
                  PERFORM 8325-UPDATE-EQUIP-ENV-OTHER THRU 8325-EXIT    
               END-IF                                                   
           END-EVALUATE.                                                
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5350-CALL-CUSTPLAN.                                              
      *                                                                         
           INITIALIZE                          LM001-INPUT.             
      *                                                                         
           MOVE PARM-ACCOUNT-NO             TO LM001-ACCOUNT-NO.        
           MOVE PARM-FXTR-INST-LOC-NO       TO LM001-INSTALL-LOC-NO.    
           EVALUATE TRUE                                                
              WHEN FIXTURE                                              
                 MOVE PARM-FXTR-INST-POINT-NO  TO LM001-INSTALL-POINT-NO
              WHEN POLE                                                 
                 MOVE PARM-ATTCH-INST-POINT-NO TO LM001-INSTALL-POINT-NO
           END-EVALUATE.                                                
      *                                                                         
           IF RATE-CHANGE                                               
              MOVE PARM-E-CODE-UTIL-TYPE    TO LM001-NEW-RATE-UTIL-TYPE 
              MOVE PARM-E-RATE-PLAN-NO      TO LM001-NEW-RATE-PLAN-NO   
              MOVE PARM-E-RATE-ITEM-CODE    TO LM001-NEW-RATE-ITEM-CODE 
           END-IF.                                                      
      *                                                                         
           MOVE PARM-E-REVENUE-CLASS        TO LM001-CODE-REVENUE-CLASS.
ACT069*    MOVE WS-ACTION-DATE              TO LM001-ACTION-DATE.               
ACT069     MOVE PARM-C-EFFECTIVE-DT         TO LM001-ACTION-DATE.       
           MOVE WS-ACTION-CODE              TO LM001-ACTION-CODE.       
           MOVE PARM-USER-ID                TO LM001-USER-ID.           
           MOVE PROGRAM-NAME                TO LM001-PROGRAM-NAME.      
      *                                                                         
           PERFORM 6300-LM001-CUST-LIGHT-SYNC                           
              THRU 6300-LM001-EXIT.                                     
      *                                                                         
           IF LM001-ERROR                                               
              MOVE LM001-ERR-SQLCODE        TO WS-ACTIVE-RETURN-CODE    
              MOVE LM001-BUS-RULE-ID        TO S-BUS-RULE-ID            
              MOVE 'F'                      TO S-BUS-RULE-RESULT-CD     
              MOVE 'CPDLM001'               TO ABEND-PROGRAM            
              MOVE LM001-ERR-PARAGRAPH-NO   TO ACTIVE-PARAGRAPH         
              MOVE LM001-ERR-FUNCTION       TO ABEND-FUNCTION           
              MOVE LM001-ERR-TABLE1         TO TABLE-1                  
              MOVE LM001-ERR-TABLE2         TO TABLE-2                  
              MOVE LM001-ERR-COLUMN-1       TO TABLE-ELEMENT-1          
              MOVE LM001-ERR-COLUMN-2       TO TABLE-ELEMENT-2          
              MOVE LM001-ERR-COLUMN-3       TO TABLE-ELEMENT-3          
              MOVE LM001-ERR-COLUMN-4       TO TABLE-ELEMENT-4          
              MOVE LM001-ERR-HOSTVAR-1      TO HOSTVAR-ELEMENT-1        
              MOVE LM001-ERR-HOSTVAR-2      TO HOSTVAR-ELEMENT-2        
              MOVE LM001-ERR-HOSTVAR-3      TO HOSTVAR-ELEMENT-3        
              MOVE LM001-ERR-HOSTVAR-4      TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       5350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5400-CHK-IF-EQUIP-EXISTS.                                        
                                                                        
           PERFORM 7400-GET-EQUIP-SEQ          THRU 7400-EXIT           
                                                                        
           IF WS-EQUIP-SEQ = PARM-FXTR-EQUIP-SEQ                        
              OR ZEROES                                                 
              CONTINUE                                                  
           ELSE                                                         
              SET FIXTURE-EXISTS TO TRUE                                
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5500-SUBDIV-PREM-SWAP.                                           
                                                                        
           EVALUATE PARM-E-RATE-PLAN-NO                                 
             WHEN '064'                                                 
               IF 4F-INSTALL-LOC-CD = 'S'                               
                  PERFORM 8300-UPDATE-EQUIP-ENV THRU 8300-EXIT          
               ELSE                                                     
                  PERFORM 8530-DELETE-EQUIP-ENV THRU 8530-EXIT          
                  MOVE PARM-FXTR-INST-LOC-NO    TO 4F-INSTALL-LOC-NO    
                  MOVE PARM-FXTR-INSTALL-LOC-CD TO 4F-INSTALL-LOC-CD    
                                                                        
                  PERFORM 7350-GET-MAX-INSTALL-POINT-NO THRU 7350-EXIT  
                  COMPUTE 4F-INSTALL-POINT-NO = 4F-INSTALL-POINT-NO + 1 
                                                                        
                  PERFORM 8560-INSRT-EQUIP-ENV  THRU 8560-EXIT          
                  SET INS-DEL-ENV-TBL TO TRUE                           
               END-IF                                                   
                                                                        
             WHEN OTHER                                                 
               IF 4F-INSTALL-LOC-CD  = 'P'                              
                  PERFORM 8300-UPDATE-EQUIP-ENV THRU 8300-EXIT          
               ELSE                                                     
                  PERFORM 8530-DELETE-EQUIP-ENV THRU 8530-EXIT          
                  PERFORM 8560-INSRT-EQUIP-ENV  THRU 8560-EXIT          
                  SET INS-DEL-ENV-TBL TO TRUE                           
               END-IF                                                   
           END-EVALUATE.                                                
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-CREATE-TRNS-HIST.                                           
                                                                        
           MOVE 0                        TO 4J-SOURCE-APPL-REQ-NO       
                                            4J-WMS-POINT-NO.            
           MOVE SPACES                   TO 4J-SOURCE-APPL-CD.          
           MOVE PROGRAM-NAME             TO 4J-APPL-PROGRAM-ID.         
           IF GIS                                                       
ACT037        MOVE 'GIS'                 TO 4J-SOURCE-APPL-CD           
              MOVE PARM-I-EQUIP-TAG-NO   TO 4J-EQUIP-TAG-NO             
              MOVE 4F-INSTALL-LOC-NO     TO 4J-INSTALL-LOC-NO           
              MOVE 4F-INSTALL-POINT-NO   TO 4J-INSTALL-POINT-NO         
              MOVE 4F-EQUIP-SEQ          TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           ELSE                                                         
              MOVE PARM-ACCOUNT-NO       TO 4J-ACCOUNT-NO               
              MOVE PARM-FXTR-EQUIP-TAG-NO                               
                                         TO 4J-EQUIP-TAG-NO             
              MOVE PARM-FXTR-INST-LOC-NO TO 4J-INSTALL-LOC-NO           
              MOVE PARM-FXTR-INST-POINT-NO                              
                                         TO 4J-INSTALL-POINT-NO         
              MOVE PARM-FXTR-EQUIP-SEQ   TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ                
           END-IF.                                                      
                                                                        
           MOVE PARM-USER-ID             TO 4J-LAST-UPDATE-USERID       
                                            4S-LAST-UPDATE-USERID.      
                                                                        
           MOVE PARM-TRAN-COMMENTS-TEXT  TO 4J-TRANS-COMMENTS-TEXT.     
           MOVE LENGTH OF PARM-TRAN-COMMENTS-TEXT                       
                                         TO 4J-TRANS-COMMENTS-LEN.      
           ADD +1                        TO 4S-DETAIL-SEQ-NO.           
                                                                        
           PERFORM 5810-CREATE-TRNS-HIST-DTL THRU 5810-EXIT.            
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5810-CREATE-TRNS-HIST-DTL.                                       
                                                                        
           EVALUATE TRUE                                                
              WHEN FIXTURE                                              
                PERFORM 5820-CREATE-FXT-TRNS-HIST-DTL                   
                   THRU 5820-EXIT                                       
                                                                        
              WHEN POLE                                                 
                PERFORM 5830-CREATE-PLE-TRNS-HIST-DTL                   
                   THRU 5830-EXIT                                       
                                                                        
              WHEN NODE                                                 
                PERFORM 5840-CREATE-NOD-TRNS-HIST-DTL                   
                   THRU 5840-EXIT                                       
                                                                        
              WHEN CONTRACT                                             
                PERFORM 5850-CREATE-CNT-TRNS-HIST-DTL                   
                   THRU 5850-EXIT                                       
                                                                        
              WHEN GIS                                                  
                PERFORM 5860-CREATE-GIS-TRNS-HIST-DTL                   
                   THRU 5860-EXIT                                       
           END-EVALUATE.                                                
                                                                        
       5810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5820-CREATE-FXT-TRNS-HIST-DTL.                                   
                                                                        
           IF 4D-EQUIP-TAG-NO NOT = WS-PRV-EQUIP-TAG-NO                 
              MOVE 'FXTR_EQUIP_TAG_NO'      TO 4S-COLUMN-DESC           
              MOVE WS-PRV-EQUIP-TAG-NO      TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-EQUIP-TAG-NO                        
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-EQUIP-TAG-NO          TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-EQUIP-TAG-NO                            
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-STOCK-CD NOT = WS-PRV-STOCK-CD                         
              MOVE 'FXTR_STOCK_CD'          TO 4S-COLUMN-DESC           
              MOVE WS-PRV-STOCK-CD          TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-STOCK-CD                            
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-STOCK-CD              TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-STOCK-CD    TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-EQUIP-MFR-CD NOT = WS-PRV-EQUIP-MFR-CD                 
              MOVE 'FXTR_EQUIP_MFR_CD'      TO 4S-COLUMN-DESC           
              MOVE WS-PRV-EQUIP-MFR-CD      TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-EQUIP-MFR-CD                        
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-EQUIP-MFR-CD          TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-EQUIP-MFR-CD                            
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-EQUIP-MFR-DT NOT = WS-PRV-EQUIP-MFR-DT                 
              MOVE 'EQUIP_MFR_DT'           TO 4S-COLUMN-DESC           
              MOVE WS-PRV-EQUIP-MFR-DT      TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-EQUIP-MFR-DT                        
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-EQUIP-MFR-DT          TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-EQUIP-MFR-DT                            
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-WARRANTY-EXP-DT NOT = WS-PRV-WARRANTY-EXP-DT           
              MOVE 'WARRANTY_EXP_DT'        TO 4S-COLUMN-DESC           
              MOVE WS-PRV-WARRANTY-EXP-DT   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-WARRANTY-EXP-DT                     
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-WARRANTY-EXP-DT       TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-WARRANTY-EXP-DT                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-EQUIP-DISPOSAL-DT NOT = WS-PRV-EQUIP-DISPOSAL-DT       
              MOVE 'EQUIP_DISPOSAL_DT'      TO 4S-COLUMN-DESC           
              MOVE WS-PRV-EQUIP-DISPOSAL-DT TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-EQUIP-DISPOSAL-DT                   
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-EQUIP-DISPOSAL-DT     TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-EQUIP-DISPOSAL-DT                       
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-STORAGE-FAC-CD NOT = WS-PRV-STORAGE-FAC-CD             
              MOVE 'FXTR_STORAG_FAC_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-PRV-STORAGE-FAC-CD    TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-STORAGE-FAC-CD                      
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-STORAGE-FAC-CD        TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-STORAGE-FAC-CD                          
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-WRNTY-RECEIVED-FL NOT = WS-PRV-WRNTY-RECEIVED-FL       
              MOVE 'WRNTY_RECEIVED_FL'      TO 4S-COLUMN-DESC           
              MOVE WS-PRV-WRNTY-RECEIVED-FL TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-WRNTY-RECEIVED-FL                   
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-WRNTY-RECEIVED-FL     TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-WRNTY-RECEIVED-FL                       
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-WRNTY-RECOUP-AMT NOT = WS-PRV-WRNTY-RECOUP-AMT         
              MOVE 'WRNTY_RECOUP_AMT'       TO 4S-COLUMN-DESC           
              MOVE WS-PRV-WRNTY-RECOUP-AMT  TO WS-COST-AMT              
              MOVE WS-COST-AMT              TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-COST-AMT    TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-WRNTY-RECOUP-AMT      TO WS-COST-AMT              
              MOVE WS-COST-AMT              TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-COST-AMT    TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-INVENTRY-STATUS-CD NOT = WS-PRV-INVENTRY-STATUS-CD     
            AND  RCVD-IN-VNDR-FILE                                      
              MOVE 'FXTR_INVNTRY_ST_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-PRV-INVENTRY-STATUS-CD                            
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-INVENTRY-STATUS-CD                  
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-INVENTRY-STATUS-CD    TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-INVENTRY-STATUS-CD                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF PARM-FXTR-INST-LOC-NO > SPACES                            
              IF INS-DEL-ENV-TBL                                        
                 MOVE 'FXTR_RATE_PLAN_NO'   TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-RATE-PLAN-NO   TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-RATE-PLAN-NO                     
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_RATE_ITEM_CD'   TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-RATE-ITEM-CODE TO WS-RATE-ITEM-CD          
                 MOVE WS-RATE-ITEM-CD       TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-RATE-ITEM-CD                         
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_BILLING_FL'  TO 4S-COLUMN-DESC              
                 MOVE WS-PRV-BILLING-FL  TO 4S-PRV-COLUMN-VALUE-TEXT    
                 MOVE LENGTH OF WS-PRV-BILLING-FL                       
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_NOBILL_RSN_CD'                              
                                            TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-NO-BILL-REASON-CD                          
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-NO-BILL-REASON-CD                
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_EQUIP_OWNR_CD'  TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-EQUIP-OWNER-CD TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-EQUIP-OWNER-CD                   
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'INSTALL_LOC_CD'      TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-INSTALL-LOC-CD TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-INSTALL-LOC-CD                   
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'EQUIP_CONTRACT_FL'   TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-EQUIP-CONTRACT-FL                          
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-EQUIP-CONTRACT-FL                
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'EQUIP_DRAWING_ID'    TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-EQUIP-DRAWING-ID                           
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-EQUIP-DRAWING-ID                 
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'EQUIP_INSTALL_DT'    TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-EQUIP-INSTALL-DT                           
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-EQUIP-INSTALL-DT                 
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'NO_CONTRACT_RSN_CD'  TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-NO-CONTRACT-RSN-CD                         
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-NO-CONTRACT-RSN-CD               
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_RATE_PLAN_NO'   TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-RATE-PLAN-NO       TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-RATE-PLAN-NO                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_RATE_ITEM_CD'   TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-RATE-ITEM-CODE     TO WS-RATE-ITEM-CD          
                 MOVE WS-RATE-ITEM-CD       TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-RATE-ITEM-CD                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_BILLING_FL'  TO 4S-COLUMN-DESC              
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-BILLING-FL      TO 4S-CHG-COLUMN-VALUE-TEXT    
                 MOVE LENGTH OF 4F-BILLING-FL                           
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_NOBILL_RSN_CD'                              
                                            TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-NO-BILL-REASON-CD  TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-NO-BILL-REASON-CD                    
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'FXTR_EQUIP_OWNR_CD'  TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-EQUIP-OWNER-CD     TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-EQUIP-OWNER-CD                       
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'INSTALL_LOC_CD'      TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-INSTALL-LOC-CD     TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-INSTALL-LOC-CD                       
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'EQUIP_CONTRACT_FL'   TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-EQUIP-CONTRACT-FL  TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-EQUIP-CONTRACT-FL                    
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'EQUIP_DRAWING_ID'    TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-EQUIP-DRAWING-ID   TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-EQUIP-DRAWING-ID                     
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'EQUIP_INSTALL_DT'    TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-EQUIP-INSTALL-DT   TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-EQUIP-INSTALL-DT                     
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'NO_CONTRACT_RSN_CD'  TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-NO-CONTRACT-RSN-CD TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-NO-CONTRACT-RSN-CD                   
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
              ELSE                                                      
                 IF 4F-RATE-PLAN-NO NOT = WS-PRV-RATE-PLAN-NO           
                    MOVE 'FXTR_RATE_PLAN_NO'                            
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-RATE-PLAN-NO                            
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-RATE-PLAN-NO                  
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-RATE-PLAN-NO    TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-RATE-PLAN-NO                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-RATE-ITEM-CODE NOT = WS-PRV-RATE-ITEM-CODE       
                    MOVE 'FXTR_RATE_ITEM_CD'                            
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-RATE-ITEM-CODE                          
                                            TO WS-RATE-ITEM-CD          
                    MOVE WS-RATE-ITEM-CD    TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-RATE-ITEM-CD                      
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-RATE-ITEM-CODE  TO WS-RATE-ITEM-CD          
                    MOVE WS-RATE-ITEM-CD    TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-RATE-ITEM-CD                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-BILLING-FL NOT = WS-PRV-BILLING-FL               
                    MOVE 'FXTR_BILLING_FL'  TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-BILLING-FL  TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-BILLING-FL                    
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-BILLING-FL      TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-BILLING-FL                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-NO-BILL-REASON-CD NOT = WS-PRV-NO-BILL-REASON-CD 
                    MOVE 'FXTR_NOBILL_RSN_CD'                           
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-NO-BILL-REASON-CD                       
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-NO-BILL-REASON-CD             
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-NO-BILL-REASON-CD                           
                                            TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-NO-BILL-REASON-CD                 
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-EQUIP-OWNER-CD NOT = WS-PRV-EQUIP-OWNER-CD       
                    MOVE 'FXTR_EQUIP_OWNR_CD'                           
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-EQUIP-OWNER-CD                          
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-EQUIP-OWNER-CD                
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-EQUIP-OWNER-CD  TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-EQUIP-OWNER-CD                    
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-EQUIP-CONTRACT-FL NOT = WS-PRV-EQUIP-CONTRACT-FL 
                    MOVE 'EQUIP_CONTRACT_FL'                            
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-EQUIP-CONTRACT-FL                       
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-EQUIP-CONTRACT-FL             
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-EQUIP-CONTRACT-FL                           
                                            TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-EQUIP-CONTRACT-FL                 
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-EQUIP-DRAWING-ID NOT = WS-PRV-EQUIP-DRAWING-ID   
                    MOVE 'EQUIP_DRAWING_ID' TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-EQUIP-DRAWING-ID                        
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-EQUIP-DRAWING-ID              
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-EQUIP-DRAWING-ID                            
                                            TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-EQUIP-DRAWING-ID                  
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-EQUIP-INSTALL-DT NOT = WS-PRV-EQUIP-INSTALL-DT   
                    MOVE 'EQUIP_INSTALL_DT' TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-EQUIP-INSTALL-DT                        
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-EQUIP-INSTALL-DT              
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-EQUIP-INSTALL-DT                            
                                            TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-EQUIP-INSTALL-DT                  
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-NO-CONTRACT-RSN-CD NOT =                         
                                          WS-PRV-NO-CONTRACT-RSN-CD     
                    MOVE 'NO_CONTRACT_RSN_CD'                           
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-NO-CONTRACT-RSN-CD                      
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-NO-CONTRACT-RSN-CD            
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-NO-CONTRACT-RSN-CD                          
                                            TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-NO-CONTRACT-RSN-CD                
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5830-CREATE-PLE-TRNS-HIST-DTL.                                   
                                                                        
           IF 4D-EQUIP-TAG-NO NOT = WS-PRV-EQUIP-TAG-NO                 
              MOVE 'POLE_EQUIP_TAG_NO'      TO 4S-COLUMN-DESC           
              MOVE WS-PRV-EQUIP-TAG-NO      TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-EQUIP-TAG-NO                        
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-EQUIP-TAG-NO          TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-EQUIP-TAG-NO                            
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-STOCK-CD NOT = WS-PRV-STOCK-CD                         
              MOVE 'POLE_STOCK_CD'          TO 4S-COLUMN-DESC           
              MOVE WS-PRV-STOCK-CD          TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-STOCK-CD                            
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-STOCK-CD              TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-STOCK-CD    TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF 4D-INVENTRY-STATUS-CD NOT = WS-PRV-INVENTRY-STATUS-CD     
            AND  RCVD-IN-VNDR-FILE                                      
              MOVE 'POLE_STORAG_FAC_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-PRV-INVENTRY-STATUS-CD                            
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-INVENTRY-STATUS-CD                  
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4D-INVENTRY-STATUS-CD    TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4D-INVENTRY-STATUS-CD                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           IF PARM-FXTR-INST-LOC-NO > SPACES                            
              IF INS-DEL-ENV-TBL                                        
                 MOVE 'POLE_RATE_PLAN_NO'   TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-RATE-PLAN-NO   TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-RATE-PLAN-NO                     
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_RATE_ITEM_CD'   TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-RATE-ITEM-CODE TO WS-RATE-ITEM-CD          
                 MOVE WS-RATE-ITEM-CD       TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-RATE-ITEM-CD                         
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_BILLING_FL'  TO 4S-COLUMN-DESC              
                 MOVE WS-PRV-BILLING-FL  TO 4S-PRV-COLUMN-VALUE-TEXT    
                 MOVE LENGTH OF WS-PRV-BILLING-FL                       
                                         TO 4S-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_NOBILL_RSN_CD'                              
                                            TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-NO-BILL-REASON-CD                          
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-NO-BILL-REASON-CD                
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_EQUIP_OWNR_CD'  TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-EQUIP-OWNER-CD TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-EQUIP-OWNER-CD                   
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'INSTALL_LOC_CD'      TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-INSTALL-LOC-CD TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-INSTALL-LOC-CD                   
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-DELETE             TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-DELETE   TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_RATE_PLAN_NO'   TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-RATE-PLAN-NO       TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-RATE-PLAN-NO                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_RATE_ITEM_CD'   TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-RATE-ITEM-CODE     TO WS-RATE-ITEM-CD          
                 MOVE WS-RATE-ITEM-CD       TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-RATE-ITEM-CD                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_BILLING_FL'  TO 4S-COLUMN-DESC              
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-BILLING-FL      TO 4S-CHG-COLUMN-VALUE-TEXT    
                 MOVE LENGTH OF 4F-BILLING-FL                           
                                         TO 4S-CHG-COLUMN-VALUE-LEN     
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_NOBILL_RSN_CD'                              
                                            TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-NO-BILL-REASON-CD  TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-NO-BILL-REASON-CD                    
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'POLE_EQUIP_OWNR_CD'  TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-EQUIP-OWNER-CD     TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-EQUIP-OWNER-CD                       
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
                 MOVE 'INSTALL_LOC_CD'      TO 4S-COLUMN-DESC           
                 MOVE WS-NEW                TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-NEW      TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4F-INSTALL-LOC-CD     TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4F-INSTALL-LOC-CD                       
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
                                                                        
              ELSE                                                      
                 IF 4F-RATE-PLAN-NO NOT = WS-PRV-RATE-PLAN-NO           
                    MOVE 'POLE_RATE_PLAN_NO'                            
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-RATE-PLAN-NO                            
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-RATE-PLAN-NO                  
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-RATE-PLAN-NO    TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-RATE-PLAN-NO                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-RATE-ITEM-CODE NOT = WS-PRV-RATE-ITEM-CODE       
                    MOVE 'POLE_RATE_ITEM_CD'                            
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-RATE-ITEM-CODE                          
                                            TO WS-RATE-ITEM-CD          
                    MOVE WS-RATE-ITEM-CD    TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-RATE-ITEM-CD                      
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-RATE-ITEM-CODE  TO WS-RATE-ITEM-CD          
                    MOVE WS-RATE-ITEM-CD    TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-RATE-ITEM-CD                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-BILLING-FL NOT = WS-PRV-BILLING-FL               
                    MOVE 'POLE_BILLING_FL'  TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-BILLING-FL  TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-BILLING-FL                    
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-BILLING-FL      TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-BILLING-FL                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-NO-BILL-REASON-CD NOT = WS-PRV-NO-BILL-REASON-CD 
                    MOVE 'POLE_NOBILL_RSN_CD'                           
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-NO-BILL-REASON-CD                       
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-NO-BILL-REASON-CD             
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-NO-BILL-REASON-CD                           
                                            TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-NO-BILL-REASON-CD                 
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
                                                                        
                 IF 4F-EQUIP-OWNER-CD NOT = WS-PRV-EQUIP-OWNER-CD       
                    MOVE 'POLE_EQUIP_OWNR_CD'                           
                                            TO 4S-COLUMN-DESC           
                    MOVE WS-PRV-EQUIP-OWNER-CD                          
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF WS-PRV-EQUIP-OWNER-CD                
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                    MOVE 4F-EQUIP-OWNER-CD  TO 4S-CHG-COLUMN-VALUE-TEXT 
                    MOVE LENGTH OF 4F-EQUIP-OWNER-CD                    
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                    PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                
                       THRU 6000-CPDLM2-EXIT                            
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5830-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5840-CREATE-NOD-TRNS-HIST-DTL.                                   
                                                                        
           MOVE 'NODE_INVNTRY_ST_CD'        TO 4S-COLUMN-DESC           
           MOVE WS-PRV-INVENTRY-STATUS-CD   TO 4S-PRV-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF WS-PRV-INVENTRY-STATUS-CD                     
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
           MOVE 4D-INVENTRY-STATUS-CD       TO 4S-CHG-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF 4D-INVENTRY-STATUS-CD                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'FXTR_EQUIP_SEQ'            TO 4S-COLUMN-DESC           
           MOVE 4H-FXTR-EQUIP-SEQ           TO 4S-PRV-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF 4H-FXTR-EQUIP-SEQ TO 4S-PRV-COLUMN-VALUE-LEN  
           MOVE WS-DELETE                   TO 4S-CHG-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF WS-DELETE         TO 4S-CHG-COLUMN-VALUE-LEN  
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'ATTACH_EQUIP_SEQ'          TO 4S-COLUMN-DESC           
           MOVE 4H-ATTACH-EQUIP-SEQ         TO 4S-PRV-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF 4H-ATTACH-EQUIP-SEQ                           
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
           MOVE WS-DELETE                   TO 4S-CHG-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF WS-DELETE         TO 4S-CHG-COLUMN-VALUE-LEN  
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'EQUIP_TYPE_CD'             TO 4S-COLUMN-DESC           
           MOVE 4H-EQUIP-TYPE-CD            TO 4S-PRV-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF 4H-EQUIP-TYPE-CD  TO 4S-PRV-COLUMN-VALUE-LEN  
           MOVE WS-DELETE                   TO 4S-CHG-COLUMN-VALUE-TEXT 
           MOVE LENGTH OF WS-DELETE         TO 4S-CHG-COLUMN-VALUE-LEN  
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
       5840-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5850-CREATE-CNT-TRNS-HIST-DTL.                                   
                                                                        
           IF PARM-CALL-TYPE = 'U'                                      
              IF 4L-CNTRCT-CLP-NO NOT = WS-PRV-CNTRCT-CLP-NO            
                 MOVE 'CNTRCT_CLP_NO'       TO 4S-COLUMN-DESC           
ACT040           MOVE WS-PRV-CNTRCT-CLP-NO  TO 4S-PRV-COLUMN-VALUE-TEXT 
ACT040           MOVE LENGTH OF WS-PRV-CNTRCT-CLP-NO                    
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
ACT040           MOVE 4L-CNTRCT-CLP-NO      TO 4S-CHG-COLUMN-VALUE-TEXT 
ACT040           MOVE LENGTH OF 4L-CNTRCT-CLP-NO                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
              END-IF                                                    
                                                                        
              IF 4L-CNTRCT-DURATION-CD NOT = WS-PRV-CNTRCT-DURATION-CD  
                 MOVE 'CNTRCT_DURATION_CD'  TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-CNTRCT-DURATION-CD                         
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-CNTRCT-DURATION-CD               
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4L-CNTRCT-DURATION-CD TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4L-CNTRCT-DURATION-CD                   
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
              END-IF                                                    
                                                                        
              IF 4L-CNTRCT-END-DT NOT = WS-PRV-CNTRCT-END-DT            
                 MOVE 'CNTRCT_END_DT'       TO 4S-COLUMN-DESC           
                 MOVE WS-PRV-CNTRCT-END-DT  TO 4S-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF WS-PRV-CNTRCT-END-DT                    
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
                 MOVE 4L-CNTRCT-END-DT      TO 4S-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF 4L-CNTRCT-END-DT                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                   
                    THRU 6000-CPDLM2-EXIT                               
              END-IF                                                    
           ELSE                                                         
              MOVE 'CNTRCT_CLP_NO'          TO 4S-COLUMN-DESC           
ACT040        MOVE WS-PRV-CNTRCT-CLP-NO     TO 4S-PRV-COLUMN-VALUE-TEXT 
ACT040        MOVE LENGTH OF WS-PRV-CNTRCT-CLP-NO                       
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE WS-DELETE                TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-DELETE      TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'CNTRCT_START_DT'        TO 4S-COLUMN-DESC           
              MOVE WS-PRV-CNTRCT-START-DT   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-CNTRCT-START-DT                     
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE WS-DELETE                TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-DELETE      TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'CNTRCT_DURATION_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-PRV-CNTRCT-DURATION-CD                            
                                            TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-CNTRCT-DURATION-CD                  
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE WS-DELETE                TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-DELETE      TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'CNTRCT_END_DT'          TO 4S-COLUMN-DESC           
              MOVE WS-PRV-CNTRCT-END-DT     TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-PRV-CNTRCT-END-DT                       
                                            TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE WS-DELETE                TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-DELETE      TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'CNTRCT_CLP_NO'          TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
ACT040        MOVE 4L-CNTRCT-CLP-NO         TO 4S-CHG-COLUMN-VALUE-TEXT 
ACT040        MOVE LENGTH OF 4L-CNTRCT-CLP-NO                           
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'CNTRCT_START_DT'        TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4L-CNTRCT-START-DT       TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4L-CNTRCT-START-DT                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'CNTRCT_DURATION_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4L-CNTRCT-DURATION-CD    TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4L-CNTRCT-DURATION-CD                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'CNTRCT_END_DT'          TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE 4L-CNTRCT-END-DT         TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF 4L-CNTRCT-END-DT                           
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
       5850-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5860-CREATE-GIS-TRNS-HIST-DTL.                                   
                                                                        
           MOVE 'FXTR_EQUIP_TAG_NO'      TO 4S-COLUMN-DESC.             
           MOVE PARM-FXTR-EQUIP-TAG-NO   TO 4S-PRV-COLUMN-VALUE-TEXT.   
           MOVE PARM-I-EQUIP-TAG-NO      TO 4S-CHG-COLUMN-VALUE-TEXT.   
           MOVE +12                      TO 4S-PRV-COLUMN-VALUE-LEN     
                                            4S-CHG-COLUMN-VALUE-LEN.    
                                                                        
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
       5860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *6000-LOAD-LMS-TRN-HST-CPDLM2                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM002                                                  
           END-EXEC.                                                            
                                                                        
      *6300-LM001-CUST-LITE-SYNC                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM001                                                  
           END-EXEC.                                                            
                                                                        
      *6990-FETCH-CUR-ACCOUNT                                                   
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT.          
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-GET-ACTION-DATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-ACTION-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-ACTION-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACTION-DATE'            TO TABLE-ELEMENT-1          
              MOVE WS-ACTION-DATE           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-TAG-NO-CASE-CNVRSN.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              UPPER(:LINK-I-EQUIP-TAG-NO),
              UPPER(:LINK-FXTR-EQUIP-TAG-NO)
            INTO
              :LINK-I-EQUIP-TAG-NO,
              :LINK-FXTR-EQUIP-TAG-NO
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :LINK-I-EQUIP-TAG-NO  = UPPER(:LINK-I-EQUIP-TAG-NO)           
MFA-TR*        ,:LINK-FXTR-EQUIP-TAG-NO = UPPER(:LINK-FXTR-EQUIP-TAG-NO)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'POLE-EQUIP-TAG-NO'      TO TABLE-ELEMENT-1          
              MOVE LINK-I-EQUIP-TAG-NO      TO HOSTVAR-ELEMENT-1        
              MOVE 'FXTR-EQUIP-TAG-NO'      TO TABLE-ELEMENT-2          
              MOVE LINK-FXTR-EQUIP-TAG-NO   TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-EQUIP-INVENTRY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT EQUIP_TAG_NO                                       
                    ,STOCK_CD                                           
                    ,EQUIP_MFR_CD                                       
                    ,EQUIP_MFR_DT                                       
                    ,WARRANTY_EXP_DT                                    
                    ,EQUIP_DISPOSAL_DT                                  
                    ,STORAGE_FAC_CD                                     
                    ,WRNTY_RECEIVED_FL                                  
                    ,WRNTY_RECOUP_AMT                                   
                    ,INVENTRY_STATUS_CD                                 
                INTO :4D-EQUIP-TAG-NO                                   
                    ,:4D-STOCK-CD                                       
                    ,:4D-EQUIP-MFR-CD                                   
                    ,:4D-EQUIP-MFR-DT :WS-EQUIP-MFR-DT-IND               
                    ,:4D-WARRANTY-EXP-DT :WS-WARRANTY-EXP-DT-IND         
                    ,:4D-EQUIP-DISPOSAL-DT :WS-EQUIP-DISPOSAL-DT-IND     
                    ,:4D-STORAGE-FAC-CD                                 
                    ,:4D-WRNTY-RECEIVED-FL                              
                    ,:4D-WRNTY-RECOUP-AMT                               
                    ,:4D-INVENTRY-STATUS-CD                             
               FROM LMS_EQUIP_INVENTRY WITH(READUNCOMMITTED)                    
              WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQUIP_TAG_NO                                               
MFA-TR*             ,STOCK_CD                                                   
MFA-TR*             ,EQUIP_MFR_CD                                               
MFA-TR*             ,EQUIP_MFR_DT                                               
MFA-TR*             ,WARRANTY_EXP_DT                                            
MFA-TR*             ,EQUIP_DISPOSAL_DT                                          
MFA-TR*             ,STORAGE_FAC_CD                                             
MFA-TR*             ,WRNTY_RECEIVED_FL                                          
MFA-TR*             ,WRNTY_RECOUP_AMT                                           
MFA-TR*             ,INVENTRY_STATUS_CD                                         
MFA-TR*         INTO :4D-EQUIP-TAG-NO                                           
MFA-TR*             ,:4D-STOCK-CD                                               
MFA-TR*             ,:4D-EQUIP-MFR-CD                                           
MFA-TR*             ,:4D-EQUIP-MFR-DT:WS-EQUIP-MFR-DT-IND                       
MFA-TR*             ,:4D-WARRANTY-EXP-DT:WS-WARRANTY-EXP-DT-IND                 
MFA-TR*             ,:4D-EQUIP-DISPOSAL-DT:WS-EQUIP-DISPOSAL-DT-IND             
MFA-TR*             ,:4D-STORAGE-FAC-CD                                         
MFA-TR*             ,:4D-WRNTY-RECEIVED-FL                                      
MFA-TR*             ,:4D-WRNTY-RECOUP-AMT                                       
MFA-TR*             ,:4D-INVENTRY-STATUS-CD                                     
MFA-TR*        FROM LMS_EQUIP_INVENTRY                                          
MFA-TR*       WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                                   
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-EQUIP-MFR-DT-IND  < 0                               
                 MOVE SPACES                TO 4D-EQUIP-MFR-DT          
              END-IF                                                    
              IF WS-WARRANTY-EXP-DT-IND  < 0                            
                 MOVE SPACES                TO 4D-WARRANTY-EXP-DT       
              END-IF                                                    
              IF WS-EQUIP-DISPOSAL-DT-IND  < 0                          
                 MOVE SPACES                TO 4D-EQUIP-DISPOSAL-DT     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-EQUIP-ENV.                                              
                                                                        
           EXEC SQL                                                     
              SELECT EQUIP_SEQ                                          
                    ,INSTALL_LOC_CD                                     
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,RATE_PLAN_NO                                       
                    ,RATE_ITEM_CODE                                     
                    ,ITEM_SEQ_NO                                        
                    ,BILLING_FL                                         
                    ,NO_BILL_REASON_CD                                  
                    ,EQUIP_CONTRACT_FL                                  
                    ,NO_CONTRACT_RSN_CD                                 
                    ,EQUIP_OWNER_CD                                     
                    ,EQUIP_DRAWING_ID                                   
                    ,EQUIP_GIS_GKEY                                     
                    ,EQUIP_INSTALL_DT                                   
                    ,INSTALL_USERID                                     
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), APPROVED_TS
           , 121), ' ', '-'), ':', '.') APPROVED_TS                            
                    ,APPROVER_USERID                                    
                    ,SPCL_AGR_COMMENTS                                  
                    ,EQUIP_COMMENTS                                     
                INTO :4F-EQUIP-SEQ                                      
                    ,:4F-INSTALL-LOC-CD                                 
                    ,:4F-CODE-UTIL-TYPE                                 
                    ,:4F-IC-NO                                          
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4F-RATE-ITEM-CODE                                 
                    ,:4F-ITEM-SEQ-NO                                    
                    ,:4F-BILLING-FL                                     
                    ,:4F-NO-BILL-REASON-CD                              
                    ,:4F-EQUIP-CONTRACT-FL                              
                    ,:4F-NO-CONTRACT-RSN-CD                             
                    ,:4F-EQUIP-OWNER-CD                                 
                    ,:4F-EQUIP-DRAWING-ID                               
                    ,:4F-EQUIP-GIS-GKEY                                 
                    ,:4F-EQUIP-INSTALL-DT :WS-EQUIP-INSTALL-DT-IND       
                    ,:4F-INSTALL-USERID                                 
                    ,:4F-APPROVED-TS :WS-APPROVED-TS-IND                 
                    ,:4F-APPROVER-USERID                                
                    ,:4F-SPCL-AGR-COMMENTS                              
                    ,:4F-EQUIP-COMMENTS                                 
                FROM LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO              
                 AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO            
                 AND EQUIP_SEQ        = :4F-EQUIP-SEQ                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQUIP_SEQ                                                  
MFA-TR*             ,INSTALL_LOC_CD                                             
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,BILLING_FL                                                 
MFA-TR*             ,NO_BILL_REASON_CD                                          
MFA-TR*             ,EQUIP_CONTRACT_FL                                          
MFA-TR*             ,NO_CONTRACT_RSN_CD                                         
MFA-TR*             ,EQUIP_OWNER_CD                                             
MFA-TR*             ,EQUIP_DRAWING_ID                                           
MFA-TR*             ,EQUIP_GIS_GKEY                                             
MFA-TR*             ,EQUIP_INSTALL_DT                                           
MFA-TR*             ,INSTALL_USERID                                             
MFA-TR*             ,APPROVED_TS                                                
MFA-TR*             ,APPROVER_USERID                                            
MFA-TR*             ,SPCL_AGR_COMMENTS                                          
MFA-TR*             ,EQUIP_COMMENTS                                             
MFA-TR*         INTO :4F-EQUIP-SEQ                                              
MFA-TR*             ,:4F-INSTALL-LOC-CD                                         
MFA-TR*             ,:4F-CODE-UTIL-TYPE                                         
MFA-TR*             ,:4F-IC-NO                                                  
MFA-TR*             ,:4F-RATE-PLAN-NO                                           
MFA-TR*             ,:4F-RATE-ITEM-CODE                                         
MFA-TR*             ,:4F-ITEM-SEQ-NO                                            
MFA-TR*             ,:4F-BILLING-FL                                             
MFA-TR*             ,:4F-NO-BILL-REASON-CD                                      
MFA-TR*             ,:4F-EQUIP-CONTRACT-FL                                      
MFA-TR*             ,:4F-NO-CONTRACT-RSN-CD                                     
MFA-TR*             ,:4F-EQUIP-OWNER-CD                                         
MFA-TR*             ,:4F-EQUIP-DRAWING-ID                                       
MFA-TR*             ,:4F-EQUIP-GIS-GKEY                                         
MFA-TR*             ,:4F-EQUIP-INSTALL-DT:WS-EQUIP-INSTALL-DT-IND               
MFA-TR*             ,:4F-INSTALL-USERID                                         
MFA-TR*             ,:4F-APPROVED-TS:WS-APPROVED-TS-IND                         
MFA-TR*             ,:4F-APPROVER-USERID                                        
MFA-TR*             ,:4F-SPCL-AGR-COMMENTS                                      
MFA-TR*             ,:4F-EQUIP-COMMENTS                                         
MFA-TR*         FROM LMS_EQUIP_ENVRNMT                                          
MFA-TR*        WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO                      
MFA-TR*          AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO                    
MFA-TR*          AND EQUIP_SEQ        = :4F-EQUIP-SEQ                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-EQUIP-INSTALL-DT-IND  < 0                           
                 MOVE SPACES                TO 4F-EQUIP-INSTALL-DT      
              END-IF                                                    
              IF WS-APPROVED-TS-IND < 0                                 
                 MOVE SPACES                TO 4F-APPROVED-TS           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-GET-FXTR-EQUIP-ENV.                                         
                                                                        
           EXEC SQL                                                     
              SELECT INSTALL_LOC_NO                                     
                    ,INSTALL_LOC_CD                                     
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,RATE_PLAN_NO                                       
                    ,RATE_ITEM_CODE                                     
                    ,ITEM_SEQ_NO                                        
                    ,BILLING_FL                                         
                    ,NO_BILL_REASON_CD                                  
                    ,EQUIP_CONTRACT_FL                                  
                    ,NO_CONTRACT_RSN_CD                                 
                    ,EQUIP_OWNER_CD                                     
                    ,EQUIP_DRAWING_ID                                   
                    ,EQUIP_GIS_GKEY                                     
                    ,EQUIP_INSTALL_DT                                   
                    ,INSTALL_USERID                                     
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), APPROVED_TS
           , 121), ' ', '-'), ':', '.') APPROVED_TS                            
                    ,APPROVER_USERID                                    
                    ,SPCL_AGR_COMMENTS                                  
                    ,EQUIP_COMMENTS                                     
                INTO :4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-LOC-CD                                 
                    ,:4F-CODE-UTIL-TYPE                                 
                    ,:4F-IC-NO                                          
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4F-RATE-ITEM-CODE                                 
                    ,:4F-ITEM-SEQ-NO                                    
                    ,:4F-BILLING-FL                                     
                    ,:4F-NO-BILL-REASON-CD                              
                    ,:4F-EQUIP-CONTRACT-FL                              
                    ,:4F-NO-CONTRACT-RSN-CD                             
                    ,:4F-EQUIP-OWNER-CD                                 
                    ,:4F-EQUIP-DRAWING-ID                               
                    ,:4F-EQUIP-GIS-GKEY                                 
                    ,:4F-EQUIP-INSTALL-DT :WS-EQUIP-INSTALL-DT-IND       
                    ,:4F-INSTALL-USERID                                 
                    ,:4F-APPROVED-TS :WS-APPROVED-TS-IND                 
                    ,:4F-APPROVER-USERID                                
                    ,:4F-SPCL-AGR-COMMENTS                              
                    ,:4F-EQUIP-COMMENTS                                 
                FROM LMS_EQUIP_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE EQUIP_SEQ        = :4F-EQUIP-SEQ                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT INSTALL_LOC_NO                                             
MFA-TR*             ,INSTALL_LOC_CD                                             
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,BILLING_FL                                                 
MFA-TR*             ,NO_BILL_REASON_CD                                          
MFA-TR*             ,EQUIP_CONTRACT_FL                                          
MFA-TR*             ,NO_CONTRACT_RSN_CD                                         
MFA-TR*             ,EQUIP_OWNER_CD                                             
MFA-TR*             ,EQUIP_DRAWING_ID                                           
MFA-TR*             ,EQUIP_GIS_GKEY                                             
MFA-TR*             ,EQUIP_INSTALL_DT                                           
MFA-TR*             ,INSTALL_USERID                                             
MFA-TR*             ,APPROVED_TS                                                
MFA-TR*             ,APPROVER_USERID                                            
MFA-TR*             ,SPCL_AGR_COMMENTS                                          
MFA-TR*             ,EQUIP_COMMENTS                                             
MFA-TR*         INTO :4F-INSTALL-LOC-NO                                         
MFA-TR*             ,:4F-INSTALL-LOC-CD                                         
MFA-TR*             ,:4F-CODE-UTIL-TYPE                                         
MFA-TR*             ,:4F-IC-NO                                                  
MFA-TR*             ,:4F-RATE-PLAN-NO                                           
MFA-TR*             ,:4F-RATE-ITEM-CODE                                         
MFA-TR*             ,:4F-ITEM-SEQ-NO                                            
MFA-TR*             ,:4F-BILLING-FL                                             
MFA-TR*             ,:4F-NO-BILL-REASON-CD                                      
MFA-TR*             ,:4F-EQUIP-CONTRACT-FL                                      
MFA-TR*             ,:4F-NO-CONTRACT-RSN-CD                                     
MFA-TR*             ,:4F-EQUIP-OWNER-CD                                         
MFA-TR*             ,:4F-EQUIP-DRAWING-ID                                       
MFA-TR*             ,:4F-EQUIP-GIS-GKEY                                         
MFA-TR*             ,:4F-EQUIP-INSTALL-DT:WS-EQUIP-INSTALL-DT-IND               
MFA-TR*             ,:4F-INSTALL-USERID                                         
MFA-TR*             ,:4F-APPROVED-TS:WS-APPROVED-TS-IND                         
MFA-TR*             ,:4F-APPROVER-USERID                                        
MFA-TR*             ,:4F-SPCL-AGR-COMMENTS                                      
MFA-TR*             ,:4F-EQUIP-COMMENTS                                         
MFA-TR*         FROM LMS_EQUIP_ENVRNMT                                          
MFA-TR*        WHERE EQUIP_SEQ        = :4F-EQUIP-SEQ                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-EQUIP-INSTALL-DT-IND  < 0                           
                 MOVE SPACES                TO 4F-EQUIP-INSTALL-DT      
              END-IF                                                    
              IF WS-APPROVED-TS-IND < 0                                 
                 MOVE SPACES                TO 4F-APPROVED-TS           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4F-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-EQUIP-CONTRACT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT INSTALL_LOC_NO                                     
                    ,CNTRCT_END_DT                                      
                    ,CNTRCT_DURATION_CD                                 
                    ,FIXTURE_COST_AM                                    
                    ,POLE_COST_AM                                       
                    ,ORIG_TERM_CHRG_AM                                  
                    ,ACTL_TERM_CHRG_AM                                  
                    ,ACTL_CHRG_DT                                       
                    ,CNTRCT_CLP_NO                                      
                    ,CNTRCT_STATUS_CD                                   
                INTO :4L-INSTALL-LOC-NO                                 
                    ,:4L-CNTRCT-END-DT :WS-CNTRCT-END-DT-IND             
                    ,:4L-CNTRCT-DURATION-CD                             
                    ,:4L-FIXTURE-COST-AM                                
                    ,:4L-POLE-COST-AM                                   
                    ,:4L-ORIG-TERM-CHRG-AM                              
                    ,:4L-ACTL-TERM-CHRG-AM                              
                    ,:4L-ACTL-CHRG-DT :WS-ACTL-CHRG-DT-IND               
                    ,:4L-CNTRCT-CLP-NO                                  
                    ,:4L-CNTRCT-STATUS-CD                               
                FROM LMS_EQUIP_CONTRACT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO      = :4L-ACCOUNT-NO                   
                 AND EQUIP_SEQ       = :4L-EQUIP-SEQ                    
                 AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT INSTALL_LOC_NO                                             
MFA-TR*             ,CNTRCT_END_DT                                              
MFA-TR*             ,CNTRCT_DURATION_CD                                         
MFA-TR*             ,FIXTURE_COST_AM                                            
MFA-TR*             ,POLE_COST_AM                                               
MFA-TR*             ,ORIG_TERM_CHRG_AM                                          
MFA-TR*             ,ACTL_TERM_CHRG_AM                                          
MFA-TR*             ,ACTL_CHRG_DT                                               
MFA-TR*             ,CNTRCT_CLP_NO                                              
MFA-TR*             ,CNTRCT_STATUS_CD                                           
MFA-TR*         INTO :4L-INSTALL-LOC-NO                                         
MFA-TR*             ,:4L-CNTRCT-END-DT:WS-CNTRCT-END-DT-IND                     
MFA-TR*             ,:4L-CNTRCT-DURATION-CD                                     
MFA-TR*             ,:4L-FIXTURE-COST-AM                                        
MFA-TR*             ,:4L-POLE-COST-AM                                           
MFA-TR*             ,:4L-ORIG-TERM-CHRG-AM                                      
MFA-TR*             ,:4L-ACTL-TERM-CHRG-AM                                      
MFA-TR*             ,:4L-ACTL-CHRG-DT:WS-ACTL-CHRG-DT-IND                       
MFA-TR*             ,:4L-CNTRCT-CLP-NO                                          
MFA-TR*             ,:4L-CNTRCT-STATUS-CD                                       
MFA-TR*         FROM LMS_EQUIP_CONTRACT                                         
MFA-TR*        WHERE ACCOUNT_NO      = :4L-ACCOUNT-NO                           
MFA-TR*          AND EQUIP_SEQ       = :4L-EQUIP-SEQ                            
MFA-TR*          AND CNTRCT_START_DT = :4L-CNTRCT-START-DT                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-CNTRCT-END-DT-IND < 0                               
                 MOVE SPACES                TO 4L-CNTRCT-END-DT         
              END-IF                                                    
              IF WS-ACTL-CHRG-DT-IND < 0                                
                 MOVE SPACES                TO 4L-ACTL-CHRG-DT          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 4L-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-2          
              MOVE 4L-EQUIP-SEQ             TO HOSTVAR-ELEMENT-2        
              MOVE 'CNTRCT_START_DT'        TO TABLE-ELEMENT-3          
              MOVE 4L-CNTRCT-START-DT       TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7350-GET-MAX-INSTALL-POINT-NO.                                   
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MAX([4F].INSTALL_POINT_NO),0)                 
                INTO :4F-INSTALL-POINT-NO                               
               FROM  LMS_EQUIP_ENVRNMT [4F] WITH(READUNCOMMITTED)               
              WHERE  [4F].INSTALL_LOC_NO = :4F-INSTALL-LOC-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(4F.INSTALL_POINT_NO),0)                         
MFA-TR*         INTO :4F-INSTALL-POINT-NO                                       
MFA-TR*        FROM  LMS_EQUIP_ENVRNMT 4F                                       
MFA-TR*       WHERE  4F.INSTALL_LOC_NO = :4F-INSTALL-LOC-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7350'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-EQUIP-SEQ.                                              
                                                                        
           EXEC SQL                                                     
              SELECT EQUIP_SEQ                                          
                INTO :WS-EQUIP-SEQ                                      
                FROM LMS_EQUIP_INVENTRY WITH(READUNCOMMITTED)                   
ACT037         WHERE EQUIP_TAG_NO = :PARM-I-EQUIP-TAG-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQUIP_SEQ                                                  
MFA-TR*         INTO :WS-EQUIP-SEQ                                              
MFA-TR*         FROM LMS_EQUIP_INVENTRY                                         
MFA-TR*        WHERE EQUIP_TAG_NO = :PARM-I-EQUIP-TAG-NO                        
MFA-TR*       WITH UR                                                           
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE PARM-FXTR-EQUIP-TAG-NO   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-GET-FIXTURE-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT [4F].EQUIP_SEQ                                       
                    ,[4F].INSTALL_LOC_NO                                  
                    ,[4F].INSTALL_POINT_NO                                
                    ,[4F].INSTALL_LOC_CD                                  
                INTO :4F-EQUIP-SEQ                                      
                    ,:4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-POINT-NO                               
                    ,:4F-INSTALL-LOC-CD                                 
                FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
               WHERE [4D].EQUIP_TAG_NO       = :PARM-FXTR-EQUIP-TAG-NO    
                 AND [4F].EQUIP_SEQ          = [4D].EQUIP_SEQ               
                 AND [4D].EQUIP_TYPE_CD      = 'F'                        
                 AND [4D].INVENTRY_STATUS_CD = 'J'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 4F.EQUIP_SEQ                                               
MFA-TR*             ,4F.INSTALL_LOC_NO                                          
MFA-TR*             ,4F.INSTALL_POINT_NO                                        
MFA-TR*             ,4F.INSTALL_LOC_CD                                          
MFA-TR*         INTO :4F-EQUIP-SEQ                                              
MFA-TR*             ,:4F-INSTALL-LOC-NO                                         
MFA-TR*             ,:4F-INSTALL-POINT-NO                                       
MFA-TR*             ,:4F-INSTALL-LOC-CD                                         
MFA-TR*         FROM LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*             ,LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*        WHERE 4D.EQUIP_TAG_NO       = :PARM-FXTR-EQUIP-TAG-NO            
MFA-TR*          AND 4F.EQUIP_SEQ          = 4D.EQUIP_SEQ                       
MFA-TR*          AND 4D.EQUIP_TYPE_CD      = 'F'                                
MFA-TR*          AND 4D.INVENTRY_STATUS_CD = 'J'                                
MFA-TR*       WITH UR                                                           
MFA-TR*     QUERYNO 7500                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-1          
              MOVE PARM-FXTR-EQUIP-TAG-NO   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** UTIL ENV DATA WITH CODE UTIL TYPE, IC                        **        
      ******************************************************************        
      *                                                                         
       7600-GET-UTIL-ENV-DATA.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT  UT.CODE_REVENUE_CLASS                              
               INTO :UT-CODE-REVENUE-CLASS                              
               FROM  CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
              WHERE UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO                
                AND UT.PREMISE_NO      =  :UT-PREMISE-NO                
                AND UT.CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE            
                AND UT.IC_NO           =  :UT-IC-NO                     
                AND UT.RATE_PLAN_NO    =  :UT-RATE-PLAN-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  UT.CODE_REVENUE_CLASS                                      
MFA-TR*        INTO :UT-CODE-REVENUE-CLASS                                      
MFA-TR*        FROM  CSS_UTIL_ENVRNMT  UT                                       
MFA-TR*       WHERE UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO                        
MFA-TR*         AND UT.PREMISE_NO      =  :UT-PREMISE-NO                        
MFA-TR*         AND UT.CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE                    
MFA-TR*         AND UT.IC_NO           =  :UT-IC-NO                             
MFA-TR*         AND UT.RATE_PLAN_NO    =  :UT-RATE-PLAN-NO                      
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'RATE-PLAN-NO'           TO TABLE-ELEMENT-4          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-PREMISE-NO            TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE UT-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04761_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04761_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE GTT-NAME                 TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04769_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-BUS-RULE-ID                                       
                  ,:S-BUS-RULE-RESULT-CD                                
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04769_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-BUS-RULE-RESULT-CD                                        
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04769_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
       8200-UPDATE-EQUIP-INV.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_INVENTRY                                 
                 SET EQUIP_TAG_NO       = :4D-EQUIP-TAG-NO              
                    ,STOCK_CD           = :4D-STOCK-CD                  
                    ,EQUIP_MFR_CD       = :4D-EQUIP-MFR-CD              
                    ,EQUIP_MFR_DT       = IIF(TRY_CONVERT(DATE, 
                                                      :4D-EQUIP-MFR-DT 
                                                   :WS-EQUIP-MFR-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-MFR-DT 
                                                   :WS-EQUIP-MFR-DT-IND
              ) <> 0) OR (LEN(:4D-EQUIP-MFR-DT :WS-EQUIP-MFR-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-MFR-DT 
                                                   :WS-EQUIP-MFR-DT-IND
              ), CONVERT(DATE, :4D-EQUIP-MFR-DT :WS-EQUIP-MFR-DT-IND) )        
                    ,WARRANTY_EXP_DT    = IIF(TRY_CONVERT(DATE, 
                                                   :4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) <> 0) OR (LEN(:4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ), CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) )       
                    ,EQUIP_DISPOSAL_DT  = IIF(TRY_CONVERT(DATE, 
                                                 :4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) <> 0) OR (LEN(:4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ), CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) )     
                    ,STORAGE_FAC_CD     = :4D-STORAGE-FAC-CD            
                    ,WRNTY_RECEIVED_FL  = :4D-WRNTY-RECEIVED-FL         
                    ,WRNTY_RECOUP_AMT   = :4D-WRNTY-RECOUP-AMT          
                    ,INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD        
                    ,LAST_UPDATE_USERID = :PARM-USER-ID                 
               WHERE EQUIP_SEQ          = :4D-EQUIP-SEQ                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_INVENTRY                                         
MFA-TR*          SET EQUIP_TAG_NO       = :4D-EQUIP-TAG-NO                      
MFA-TR*             ,STOCK_CD           = :4D-STOCK-CD                          
MFA-TR*             ,EQUIP_MFR_CD       = :4D-EQUIP-MFR-CD                      
MFA-TR*             ,EQUIP_MFR_DT       = :4D-EQUIP-MFR-DT                      
MFA-TR*                                   :WS-EQUIP-MFR-DT-IND                  
MFA-TR*             ,WARRANTY_EXP_DT    = :4D-WARRANTY-EXP-DT                   
MFA-TR*                                   :WS-WARRANTY-EXP-DT-IND               
MFA-TR*             ,EQUIP_DISPOSAL_DT  = :4D-EQUIP-DISPOSAL-DT                 
MFA-TR*                                   :WS-EQUIP-DISPOSAL-DT-IND             
MFA-TR*             ,STORAGE_FAC_CD     = :4D-STORAGE-FAC-CD                    
MFA-TR*             ,WRNTY_RECEIVED_FL  = :4D-WRNTY-RECEIVED-FL                 
MFA-TR*             ,WRNTY_RECOUP_AMT   = :4D-WRNTY-RECOUP-AMT                  
MFA-TR*             ,INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD                
MFA-TR*             ,LAST_UPDATE_USERID = :PARM-USER-ID                         
MFA-TR*        WHERE EQUIP_SEQ          = :4D-EQUIP-SEQ                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE 4D-EQUIP-TAG-NO          TO HOSTVAR-ELEMENT-2        
              MOVE 'EQUIP_MFR_DT'           TO TABLE-ELEMENT-3          
              MOVE 4D-EQUIP-MFR-DT          TO HOSTVAR-ELEMENT-3        
              MOVE 'WARRANTY_EXP_DT'        TO TABLE-ELEMENT-4          
              MOVE 4D-WARRANTY-EXP-DT       TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-UPDATE-GIS-EQUIP-TAG.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_INVENTRY                                 
                 SET EQUIP_TAG_NO       = :PARM-I-EQUIP-TAG-NO          
                    ,LAST_UPDATE_USERID = :PARM-USER-ID                 
               WHERE EQUIP_TAG_NO       = :PARM-FXTR-EQUIP-TAG-NO       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-1          
              MOVE PARM-FXTR-EQUIP-TAG-NO   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-UPDATE-EQUIP-ENV.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                 SET BILLING_FL         = :4F-BILLING-FL                
                    ,CODE_UTIL_TYPE     = :4F-CODE-UTIL-TYPE            
                    ,RATE_PLAN_NO       = :4F-RATE-PLAN-NO              
                    ,RATE_ITEM_CODE     = :4F-RATE-ITEM-CODE            
                    ,EQUIP_CONTRACT_FL  = :4F-EQUIP-CONTRACT-FL         
                    ,NO_BILL_REASON_CD  = :4F-NO-BILL-REASON-CD         
                    ,EQUIP_OWNER_CD     = :4F-EQUIP-OWNER-CD            
                    ,EQUIP_DRAWING_ID   = :4F-EQUIP-DRAWING-ID          
                    ,EQUIP_INSTALL_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) )      
                    ,NO_CONTRACT_RSN_CD = :4F-NO-CONTRACT-RSN-CD        
                    ,SPCL_AGR_COMMENTS  = :4F-SPCL-AGR-COMMENTS         
                    ,EQUIP_COMMENTS     = :4F-EQUIP-COMMENTS            
                    ,LAST_UPDATE_USERID = :PARM-USER-ID                 
               WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO            
                 AND INSTALL_POINT_NO   = :4F-INSTALL-POINT-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_ENVRNMT                                          
MFA-TR*          SET BILLING_FL         = :4F-BILLING-FL                        
MFA-TR*             ,CODE_UTIL_TYPE     = :4F-CODE-UTIL-TYPE                    
MFA-TR*             ,RATE_PLAN_NO       = :4F-RATE-PLAN-NO                      
MFA-TR*             ,RATE_ITEM_CODE     = :4F-RATE-ITEM-CODE                    
MFA-TR*             ,EQUIP_CONTRACT_FL  = :4F-EQUIP-CONTRACT-FL                 
MFA-TR*             ,NO_BILL_REASON_CD  = :4F-NO-BILL-REASON-CD                 
MFA-TR*             ,EQUIP_OWNER_CD     = :4F-EQUIP-OWNER-CD                    
MFA-TR*             ,EQUIP_DRAWING_ID   = :4F-EQUIP-DRAWING-ID                  
MFA-TR*             ,EQUIP_INSTALL_DT   = :4F-EQUIP-INSTALL-DT                  
MFA-TR*                                   :WS-EQUIP-INSTALL-DT-IND              
MFA-TR*             ,NO_CONTRACT_RSN_CD = :4F-NO-CONTRACT-RSN-CD                
MFA-TR*             ,SPCL_AGR_COMMENTS  = :4F-SPCL-AGR-COMMENTS                 
MFA-TR*             ,EQUIP_COMMENTS     = :4F-EQUIP-COMMENTS                    
MFA-TR*             ,LAST_UPDATE_USERID = :PARM-USER-ID                         
MFA-TR*        WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO                    
MFA-TR*          AND INSTALL_POINT_NO   = :4F-INSTALL-POINT-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8325-UPDATE-EQUIP-ENV-OTHER.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                 SET EQUIP_CONTRACT_FL  = :4F-EQUIP-CONTRACT-FL         
                    ,NO_BILL_REASON_CD  = :4F-NO-BILL-REASON-CD         
                    ,EQUIP_OWNER_CD     = :4F-EQUIP-OWNER-CD            
                    ,EQUIP_DRAWING_ID   = :4F-EQUIP-DRAWING-ID          
                    ,EQUIP_INSTALL_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) )      
                    ,NO_CONTRACT_RSN_CD = :4F-NO-CONTRACT-RSN-CD        
                    ,SPCL_AGR_COMMENTS  = :4F-SPCL-AGR-COMMENTS         
                    ,EQUIP_COMMENTS     = :4F-EQUIP-COMMENTS            
                    ,LAST_UPDATE_USERID = :PARM-USER-ID                 
               WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO            
                 AND INSTALL_POINT_NO   = :4F-INSTALL-POINT-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_ENVRNMT                                          
MFA-TR*          SET EQUIP_CONTRACT_FL  = :4F-EQUIP-CONTRACT-FL                 
MFA-TR*             ,NO_BILL_REASON_CD  = :4F-NO-BILL-REASON-CD                 
MFA-TR*             ,EQUIP_OWNER_CD     = :4F-EQUIP-OWNER-CD                    
MFA-TR*             ,EQUIP_DRAWING_ID   = :4F-EQUIP-DRAWING-ID                  
MFA-TR*             ,EQUIP_INSTALL_DT   = :4F-EQUIP-INSTALL-DT                  
MFA-TR*                                   :WS-EQUIP-INSTALL-DT-IND              
MFA-TR*             ,NO_CONTRACT_RSN_CD = :4F-NO-CONTRACT-RSN-CD                
MFA-TR*             ,SPCL_AGR_COMMENTS  = :4F-SPCL-AGR-COMMENTS                 
MFA-TR*             ,EQUIP_COMMENTS     = :4F-EQUIP-COMMENTS                    
MFA-TR*             ,LAST_UPDATE_USERID = :PARM-USER-ID                         
MFA-TR*        WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO                    
MFA-TR*          AND INSTALL_POINT_NO   = :4F-INSTALL-POINT-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8325'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8325-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8350-UPDATE-EQUIP-ENV-NEW-LGHT.                                  
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                 SET CODE_UTIL_TYPE     = :4F-CODE-UTIL-TYPE            
                    ,RATE_PLAN_NO       = :4F-RATE-PLAN-NO              
                    ,RATE_ITEM_CODE     = :4F-RATE-ITEM-CODE            
                    ,IC_NO              =  0                            
                    ,ITEM_SEQ_NO        =  0                            
                    ,BILLING_FL         = 'Z'                           
               WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO            
                 AND INSTALL_POINT_NO   = :4F-INSTALL-POINT-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8350'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT004 8375-UPDATE-EQUIP-ENV-POLE.                                      
ACT004                                                                  
ACT004     EXEC SQL                                                     
ACT004        UPDATE LMS_EQUIP_ENVRNMT                                  
ACT004           SET EQUIP_INSTALL_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) )      
ACT004              ,LAST_UPDATE_USERID = :PARM-USER-ID                 
ACT004              ,LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP()            
ACT004         WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO            
ACT004           AND EQUIP_SEQ         IN                               
ACT004              (SELECT [4H].ATTACH_EQUIP_SEQ                         
ACT004                 FROM LMS_FXTR_ATTACHMTS  [4H]                      
ACT004                WHERE [4H].FXTR_EQUIP_SEQ  =  :PARM-FXTR-EQUIP-SEQ  
ACT004                  AND [4H].EQUIP_TYPE_CD   =  'P')                  
ACT004     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_ENVRNMT                                          
MFA-TR*          SET EQUIP_INSTALL_DT   = :4F-EQUIP-INSTALL-DT                  
MFA-TR*                                   :WS-EQUIP-INSTALL-DT-IND              
MFA-TR*             ,LAST_UPDATE_USERID = :PARM-USER-ID                         
MFA-TR*             ,LAST_UPDATE_TS     =  CURRENT TIMESTAMP                    
MFA-TR*        WHERE INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO                    
MFA-TR*          AND EQUIP_SEQ         IN                                       
MFA-TR*             (SELECT 4H.ATTACH_EQUIP_SEQ                                 
MFA-TR*                FROM LMS_FXTR_ATTACHMTS  4H                              
MFA-TR*               WHERE 4H.FXTR_EQUIP_SEQ  =  :PARM-FXTR-EQUIP-SEQ          
MFA-TR*                 AND 4H.EQUIP_TYPE_CD   =  'P')                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT004                                                                  
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT004        NEXT SENTENCE                                             
ACT004     ELSE                                                         
ACT004        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
ACT004        MOVE '8375'                   TO ACTIVE-PARAGRAPH         
ACT004        MOVE 'UPDATE'                 TO ABEND-FUNCTION           
ACT004        MOVE SPACES                   TO ABEND-TABLES             
ACT004                                         ABEND-SQL-PREDICATES     
ACT004        MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
ACT004        MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
ACT004        MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
ACT004        MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
ACT004        MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
ACT004        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
ACT004     END-IF.                                                      
ACT004                                                                  
ACT004 8375-EXIT.                                                       
ACT004     EXIT.                                                        
ACT004                                                                  
       8400-UPDATE-EQUIP-CNT.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_CONTRACT                                 
                 SET CNTRCT_CLP_NO      = :4L-CNTRCT-CLP-NO             
                    ,CNTRCT_DURATION_CD = :4L-CNTRCT-DURATION-CD        
                    ,CNTRCT_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                     :4L-CNTRCT-END-DT 
                                                  :WS-CNTRCT-END-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-END-DT 
                                                  :WS-CNTRCT-END-DT-IND
              ) <> 0) OR (LEN(:4L-CNTRCT-END-DT :WS-CNTRCT-END-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-END-DT 
                                                  :WS-CNTRCT-END-DT-IND
              ), CONVERT(DATE, :4L-CNTRCT-END-DT :WS-CNTRCT-END-DT-IND
              ) )         
               WHERE ACCOUNT_NO         = :4L-ACCOUNT-NO                
                 AND EQUIP_SEQ          = :4L-EQUIP-SEQ                 
                 AND CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE LMS_EQUIP_CONTRACT                                         
MFA-TR*          SET CNTRCT_CLP_NO      = :4L-CNTRCT-CLP-NO                     
MFA-TR*             ,CNTRCT_DURATION_CD = :4L-CNTRCT-DURATION-CD                
MFA-TR*             ,CNTRCT_END_DT      = :4L-CNTRCT-END-DT                     
MFA-TR*                                   :WS-CNTRCT-END-DT-IND                 
MFA-TR*        WHERE ACCOUNT_NO         = :4L-ACCOUNT-NO                        
MFA-TR*          AND EQUIP_SEQ          = :4L-EQUIP-SEQ                         
MFA-TR*          AND CNTRCT_START_DT    = :4L-CNTRCT-START-DT                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 4L-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_SEQ '             TO TABLE-ELEMENT-2          
              MOVE 4L-EQUIP-SEQ             TO HOSTVAR-ELEMENT-2        
              MOVE 'CNTRCT_START_DT'        TO TABLE-ELEMENT-3          
              MOVE 4L-CNTRCT-START-DT       TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8510-DELETE-FXTR-ATTACHMTS.                                      
                                                                        
           EXEC SQL                                                     
              DELETE                                                    
              FROM LMS_FXTR_ATTACHMTS                                   
               WHERE FXTR_EQUIP_SEQ   = :4H-FXTR-EQUIP-SEQ              
                 AND ATTACH_EQUIP_SEQ = :4H-ATTACH-EQUIP-SEQ            
                 AND EQUIP_TYPE_CD    = :4H-EQUIP-TYPE-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8510'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ'         TO TABLE-ELEMENT-1          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-1        
              MOVE 'ATTACH_EQUIP_SEQ'       TO TABLE-ELEMENT-2          
              MOVE 4H-ATTACH-EQUIP-SEQ      TO HOSTVAR-ELEMENT-2        
              MOVE 'EQUIP_TYPE_CD'          TO TABLE-ELEMENT-3          
              MOVE 4H-EQUIP-TYPE-CD         TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8520-DELETE-EQUIP-CNT.                                           
                                                                        
           EXEC SQL                                                     
              DELETE                                                    
              FROM LMS_EQUIP_CONTRACT                                   
               WHERE ACCOUNT_NO      = :4L-ACCOUNT-NO                   
                 AND EQUIP_SEQ       = :4L-EQUIP-SEQ                    
                 AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE                                                            
MFA-TR*       FROM LMS_EQUIP_CONTRACT                                           
MFA-TR*        WHERE ACCOUNT_NO      = :4L-ACCOUNT-NO                           
MFA-TR*          AND EQUIP_SEQ       = :4L-EQUIP-SEQ                            
MFA-TR*          AND CNTRCT_START_DT = :4L-CNTRCT-START-DT                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 4L-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-2          
              MOVE 4L-EQUIP-SEQ             TO HOSTVAR-ELEMENT-2        
              MOVE 'CNTRCT_START_DT'        TO TABLE-ELEMENT-3          
              MOVE 4L-CNTRCT-START-DT       TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8530-DELETE-EQUIP-ENV.                                           
                                                                        
           EXEC SQL                                                     
              DELETE                                                    
              FROM LMS_EQUIP_ENVRNMT                                    
               WHERE INSTALL_LOC_NO   = :4F-INSTALL-LOC-NO              
                 AND INSTALL_POINT_NO = :4F-INSTALL-POINT-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8530'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8540-DELETE-EQUIP-INVENTRY.                                      
                                                                        
           EXEC SQL                                                     
              DELETE                                                    
              FROM LMS_EQUIP_INVENTRY                                   
               WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8540'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP-SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8550-INSERT-EQUIP-CNT.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_CONTRACT                            
                  (ACCOUNT_NO                                           
                  ,EQUIP_SEQ                                            
                  ,CNTRCT_START_DT                                      
                  ,INSTALL_LOC_NO                                       
                  ,CNTRCT_END_DT                                        
                  ,CNTRCT_DURATION_CD                                   
                  ,FIXTURE_COST_AM                                      
                  ,POLE_COST_AM                                         
                  ,ORIG_TERM_CHRG_AM                                    
                  ,ACTL_TERM_CHRG_AM                                    
                  ,ACTL_CHRG_DT                                         
                  ,CNTRCT_CLP_NO                                        
                  ,CNTRCT_STATUS_CD                                     
                  ,LAST_UPDATE_USERID)                                  
              VALUES                                                    
                  (:4L-ACCOUNT-NO                                       
                  ,:4L-EQUIP-SEQ                                        
                  ,IIF(TRY_CONVERT(DATE, :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )                          
                  ,:4L-INSTALL-LOC-NO                                   
                  ,IIF(TRY_CONVERT(DATE, :4L-CNTRCT-END-DT 
                                         :WS-CNTRCT-END-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-END-DT 
                                                  :WS-CNTRCT-END-DT-IND
              ) <> 0) OR (LEN(:4L-CNTRCT-END-DT :WS-CNTRCT-END-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-END-DT 
                                                  :WS-CNTRCT-END-DT-IND
              ), CONVERT(DATE, :4L-CNTRCT-END-DT :WS-CNTRCT-END-DT-IND
              ) )               
                  ,:4L-CNTRCT-DURATION-CD                               
                  ,:4L-FIXTURE-COST-AM                                  
                  ,:4L-POLE-COST-AM                                     
                  ,:4L-ORIG-TERM-CHRG-AM                                
                  ,:4L-ACTL-TERM-CHRG-AM                                
                  ,IIF(TRY_CONVERT(DATE, :4L-ACTL-CHRG-DT 
                                         :WS-ACTL-CHRG-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4L-ACTL-CHRG-DT 
                                                   :WS-ACTL-CHRG-DT-IND
              ) <> 0) OR (LEN(:4L-ACTL-CHRG-DT :WS-ACTL-CHRG-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4L-ACTL-CHRG-DT 
                                                   :WS-ACTL-CHRG-DT-IND
              ), CONVERT(DATE, :4L-ACTL-CHRG-DT :WS-ACTL-CHRG-DT-IND) )        
                  ,:4L-CNTRCT-CLP-NO                                    
                  ,:4L-CNTRCT-STATUS-CD                                 
                  ,:4L-LAST-UPDATE-USERID)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_CONTRACT                                    
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,INSTALL_LOC_NO                                               
MFA-TR*           ,CNTRCT_END_DT                                                
MFA-TR*           ,CNTRCT_DURATION_CD                                           
MFA-TR*           ,FIXTURE_COST_AM                                              
MFA-TR*           ,POLE_COST_AM                                                 
MFA-TR*           ,ORIG_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_CHRG_DT                                                 
MFA-TR*           ,CNTRCT_CLP_NO                                                
MFA-TR*           ,CNTRCT_STATUS_CD                                             
MFA-TR*           ,LAST_UPDATE_USERID)                                          
MFA-TR*       VALUES                                                            
MFA-TR*           (:4L-ACCOUNT-NO                                               
MFA-TR*           ,:4L-EQUIP-SEQ                                                
MFA-TR*           ,:4L-CNTRCT-START-DT                                          
MFA-TR*           ,:4L-INSTALL-LOC-NO                                           
MFA-TR*           ,:4L-CNTRCT-END-DT:WS-CNTRCT-END-DT-IND                       
MFA-TR*           ,:4L-CNTRCT-DURATION-CD                                       
MFA-TR*           ,:4L-FIXTURE-COST-AM                                          
MFA-TR*           ,:4L-POLE-COST-AM                                             
MFA-TR*           ,:4L-ORIG-TERM-CHRG-AM                                        
MFA-TR*           ,:4L-ACTL-TERM-CHRG-AM                                        
MFA-TR*           ,:4L-ACTL-CHRG-DT:WS-ACTL-CHRG-DT-IND                         
MFA-TR*           ,:4L-CNTRCT-CLP-NO                                            
MFA-TR*           ,:4L-CNTRCT-STATUS-CD                                         
MFA-TR*           ,:4L-LAST-UPDATE-USERID)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8550'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 4L-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-2          
              MOVE 4L-EQUIP-SEQ             TO HOSTVAR-ELEMENT-2        
              MOVE 'CNTRCT_START_DT'        TO TABLE-ELEMENT-3          
              MOVE 4L-CNTRCT-START-DT       TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8560-INSRT-EQUIP-ENV.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_ENVRNMT                             
                   ( INSTALL_LOC_NO                                     
                    ,INSTALL_POINT_NO                                   
                    ,EQUIP_SEQ                                          
                    ,INSTALL_LOC_CD                                     
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,RATE_PLAN_NO                                       
                    ,RATE_ITEM_CODE                                     
                    ,ITEM_SEQ_NO                                        
                    ,BILLING_FL                                         
                    ,NO_BILL_REASON_CD                                  
                    ,EQUIP_CONTRACT_FL                                  
                    ,NO_CONTRACT_RSN_CD                                 
                    ,EQUIP_OWNER_CD                                     
                    ,EQUIP_DRAWING_ID                                   
                    ,EQUIP_GIS_GKEY                                     
                    ,EQUIP_INSTALL_DT                                   
                    ,INSTALL_USERID                                     
                    ,APPROVED_TS                                        
                    ,APPROVER_USERID                                    
                    ,SPCL_AGR_COMMENTS                                  
                    ,EQUIP_COMMENTS                                     
                    ,LAST_UPDATE_USERID)                                
              VALUES                                                    
                 ( :4F-INSTALL-LOC-NO                                   
                  ,:4F-INSTALL-POINT-NO                                 
                  ,:4F-EQUIP-SEQ                                        
                  ,:4F-INSTALL-LOC-CD                                   
                  ,:4F-CODE-UTIL-TYPE                                   
                  ,:4F-IC-NO                                            
                  ,:4F-RATE-PLAN-NO                                     
                  ,:4F-RATE-ITEM-CODE                                   
                  ,:4F-ITEM-SEQ-NO                                      
                  ,:4F-BILLING-FL                                       
                  ,:4F-NO-BILL-REASON-CD                                
                  ,:4F-EQUIP-CONTRACT-FL                                
                  ,:4F-NO-CONTRACT-RSN-CD                               
                  ,:4F-EQUIP-OWNER-CD                                   
                  ,:4F-EQUIP-DRAWING-ID                                 
                  ,:4F-EQUIP-GIS-GKEY                                   
                  ,IIF(TRY_CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                         :WS-EQUIP-INSTALL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT 
                                               :WS-EQUIP-INSTALL-DT-IND
              ) )         
                  ,:4F-INSTALL-USERID                                   
                  ,CIS.CHAR2TIMESTAMP(:4F-APPROVED-TS 
                                      :WS-APPROVED-TS-IND)                   
                  ,:4F-APPROVER-USERID                                  
                  ,:4F-SPCL-AGR-COMMENTS                                
                  ,:4F-EQUIP-COMMENTS                                   
                  ,:4F-LAST-UPDATE-USERID)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_ENVRNMT                                     
MFA-TR*            ( INSTALL_LOC_NO                                             
MFA-TR*             ,INSTALL_POINT_NO                                           
MFA-TR*             ,EQUIP_SEQ                                                  
MFA-TR*             ,INSTALL_LOC_CD                                             
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,ITEM_SEQ_NO                                                
MFA-TR*             ,BILLING_FL                                                 
MFA-TR*             ,NO_BILL_REASON_CD                                          
MFA-TR*             ,EQUIP_CONTRACT_FL                                          
MFA-TR*             ,NO_CONTRACT_RSN_CD                                         
MFA-TR*             ,EQUIP_OWNER_CD                                             
MFA-TR*             ,EQUIP_DRAWING_ID                                           
MFA-TR*             ,EQUIP_GIS_GKEY                                             
MFA-TR*             ,EQUIP_INSTALL_DT                                           
MFA-TR*             ,INSTALL_USERID                                             
MFA-TR*             ,APPROVED_TS                                                
MFA-TR*             ,APPROVER_USERID                                            
MFA-TR*             ,SPCL_AGR_COMMENTS                                          
MFA-TR*             ,EQUIP_COMMENTS                                             
MFA-TR*             ,LAST_UPDATE_USERID)                                        
MFA-TR*       VALUES                                                            
MFA-TR*          ( :4F-INSTALL-LOC-NO                                           
MFA-TR*           ,:4F-INSTALL-POINT-NO                                         
MFA-TR*           ,:4F-EQUIP-SEQ                                                
MFA-TR*           ,:4F-INSTALL-LOC-CD                                           
MFA-TR*           ,:4F-CODE-UTIL-TYPE                                           
MFA-TR*           ,:4F-IC-NO                                                    
MFA-TR*           ,:4F-RATE-PLAN-NO                                             
MFA-TR*           ,:4F-RATE-ITEM-CODE                                           
MFA-TR*           ,:4F-ITEM-SEQ-NO                                              
MFA-TR*           ,:4F-BILLING-FL                                               
MFA-TR*           ,:4F-NO-BILL-REASON-CD                                        
MFA-TR*           ,:4F-EQUIP-CONTRACT-FL                                        
MFA-TR*           ,:4F-NO-CONTRACT-RSN-CD                                       
MFA-TR*           ,:4F-EQUIP-OWNER-CD                                           
MFA-TR*           ,:4F-EQUIP-DRAWING-ID                                         
MFA-TR*           ,:4F-EQUIP-GIS-GKEY                                           
MFA-TR*           ,:4F-EQUIP-INSTALL-DT:WS-EQUIP-INSTALL-DT-IND                 
MFA-TR*           ,:4F-INSTALL-USERID                                           
MFA-TR*           ,:4F-APPROVED-TS:WS-APPROVED-TS-IND                           
MFA-TR*           ,:4F-APPROVER-USERID                                          
MFA-TR*           ,:4F-SPCL-AGR-COMMENTS                                        
MFA-TR*           ,:4F-EQUIP-COMMENTS                                           
MFA-TR*           ,:4F-LAST-UPDATE-USERID)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8560'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_POINT_NO'       TO TABLE-ELEMENT-2          
              MOVE 4F-INSTALL-POINT-NO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8560-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS <= 0                                             
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                   TO S-APPL-RETURN-CODE          
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                 
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
      * COMMENTED TO FIX TEST ISSUE.                                            
      *    INITIALIZE GTT-RETURN-FIELDS.                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE               
                                            ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE            THRU 8900-EXIT.            
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       9999-END-PROGRAM.                                                
      *===============================================================*         
                                                                        
           PERFORM 8800-CHECK-RESULTS        THRU 8800-EXIT.            
           PERFORM 8900-SEND-DONE            THRU 8900-EXIT.            
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                       END OF PROGRAM                           *        
      ******************************************************************        
