       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04768.                                            
       DATE-WRITTEN. 10/13/14.                                          
       DATE-COMPILED.                                                   
       AUTHOR. SATISH SIVASUBRAMANIAN.                                  
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *                      ADD LIGHTING DETAILS                      *        
      *                      ====================                      *        
      *                                                                *        
      *  THIS SP ADDS LIGHT DETAILS BASED ON THE PARM SECTION.         *        
      *                                                                *        
      *       LINK-PARM-SECTION =  FIXTURE   'F'                       *        
      *                            POLE      'P'                       *        
      *                            NODE      'N'                       *        
      *                            CONTRACT  'C'                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/13/14  SS95855    PROJ#0817 PROCEDURE ORIGINALLY CODED.    *        
A#5084*  06/19/15  SS95855    ACT040 CLP# CHANGED TO CHAR(50).         *        
A#5084*  06/24/15  SS95855    ACT046 ADDED INSTALL_DATE AS INPUT.      *        
A#5084*  12/07/15  SV95326    ACT069 ADD EFFECTIVE DATE IN RRT SCREEN  *        
      *                              AS A NEW INPUT.                   *        
A#5460*  04/26/16  HA7A338    ACT160 CODE FIX TO ALLOW MASS CNTRCT UPDT*        
      *                              WHEN THE ACCTS HAS MULT LIGHTS    *        
      ******************************************************************        
      *****************************************************************         
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04768'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                         PIC X(40) VALUE             
           'WORKING STORAGE FOR CSR04768 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR04768'. 
           05 CSRERLOG                      PIC X(08) VALUE 'CSRERLOG'. 
           05 WS-YES                        PIC X(01) VALUE 'Y'.        
           05 WS-NO                         PIC X(01) VALUE 'N'.        
           05 WS-INSTALLED                  PIC X(01) VALUE 'J'.        
           05 WS-PREMISE                    PIC X(01) VALUE 'P'.        
           05 WS-SUBDIVISION                PIC X(01) VALUE 'S'.        
           05 WS-NEW                        PIC X(07) VALUE '**NEW**'.  
           05 WS-COMPANY                    PIC X(02) VALUE '01'.       
           05 WS-CODE-SERVICE-TYPE          PIC X(02) VALUE 'E'.        
           05 WS-TRANS-CMNT-TXT             PIC X(17) VALUE             
                                                 'ADD LIGHT DETAILS'.   
       01  WS-MISC.                                                     
           05 WS-SQLSTATE                   PIC X(05) VALUE SPACES.     
           05 WS-EQUIP-TAG-NO               PIC X(12) VALUE SPACES.     
           05 WS-EQUIP-COST-AMT             PIC X(07) VALUE SPACES.     
           05 WS-EQUIP-COST-AMT-NUM REDEFINES                           
              WS-EQUIP-COST-AMT             PIC 9(05)V99.               
           05 WS-EQUIP-COST-AMT-VAL.                                    
              10 WS-AMT-SIGN1               PIC X(01) VALUE SPACES.     
              10 WS-AMT-FIXED1              PIC X(05) VALUE SPACES.     
              10 FILLER                     PIC X(01) VALUE '.'.        
              10 WS-AMT-DEC1                PIC X(02) VALUE SPACES.     
           05 WS-COST-AMT                   PIC -ZZZZ9.99.              
           05 WS-RATE-ITEM-CD               PIC ZZZ9.                   
           05 WS-ACTION-DATE                PIC X(10) VALUE SPACES.     
           05 WS-RATE-ITEM-CODE             PIC 9(02) VALUE 0.          
           05 WS-EQUIP-SEQ                  PIC 9(10).                  
           05 WS-EQUIP-SEQ-STR      REDEFINES                           
              WS-EQUIP-SEQ                  PIC X(10).                  
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-EQUIP-MFR-DT-IND           PIC S9(4) COMP VALUE -1.    
           05 WS-WARRANTY-EXP-DT-IND        PIC S9(4) COMP VALUE -1.    
           05 WS-EQUIP-DISPOSAL-DT-IND      PIC S9(4) COMP VALUE -1.    
           05 WS-CNTRCT-END-DT-IND          PIC S9(4) COMP VALUE 0.     
           05 WS-ACTL-CHRG-DT-IND           PIC S9(4) COMP VALUE 0.     
                                                                        
       01  WS-ACTION-CODE                   PIC X(01) VALUE ' '.        
           88 ADD-NEW-LIGHT                           VALUE 'N'.        
           88 ACTIVATE                                VALUE 'A'.        
           88 INACTIVATE                              VALUE 'I'.        
           88 REMOVE                                  VALUE 'R'.        
           88 RATE-CHANGE                             VALUE 'C'.        
                                                                        
       01  WS-SECTION                       PIC X(01) VALUE SPACES.     
           88 CONTRACT                                VALUE 'C'.        
           88 FIXTURE                                 VALUE 'F'.        
           88 NODE                                    VALUE 'N'.        
           88 POLE                                    VALUE 'P'.        
                                                                        
       01  CSRERLOG-P.                                                  
           10 S-SP-NAME                     PIC X(18) VALUE SPACES.     
           10 S-SQLCODE                     PIC S9(9) COMP VALUE 0.     
           10 S-SQLSTATE                    PIC X(5)  VALUE ' '.        
           10 S-TABLE-NAME                  PIC X(18) VALUE SPACES.     
           10 S-HOST-VARIABLES.                                         
              49 S-HOST-VARIABLES-L         PIC S9(4) COMP.             
              49 S-HOST-VARIABLES-V         PIC X(255).                 
           10 S-SQL-STATEMENT.                                          
              49 S-SQL-STATEMENT-L          PIC S9(4) COMP.             
              49 S-SQL-STATEMENT-V          PIC X(255).                 
           10 S-SQL-DESCRIPTION.                                        
              49 S-SQL-DESCRIPTION-L        PIC S9(4) COMP.             
              49 S-SQL-DESCRIPTION-V        PIC X(255).                 
           05 WS-ABEND-SQLERRMC.                                        
              49 WS-ABEND-SQLERRMC-L        PIC S9(4) COMP.             
              49 WS-ABEND-SQLERRMC-V        PIC X(255).                 
                                                                        
       01  WS-PRV-VALUES.                                               
           05 WS-PRV-INVENTRY-STATUS-CD     PIC X(01)  VALUE SPACES.    
                                                                        
       01  PARM-FIELDS.                                                 
           05 PARM-SECTION                  PIC X(01) VALUE SPACES.     
           05 PARM-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0. 
           05 PARM-FXTR-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0. 
           05 PARM-FXTR-INST-LOC-NO         PIC X(10) VALUE SPACES.     
           05 PARM-FXTR-INST-POINT-NO       PIC S9(5)V COMP-3 VALUE 0.  
           05 PARM-FXTR-EQUIP-TAG-NO        PIC X(12) VALUE SPACES.     
           05 PARM-FXTR-BILLING-FL          PIC X(01) VALUE SPACES.     
ACT046     05 PARM-FXTR-INSTALL-DATE        PIC X(10) VALUE SPACES.     
           05 PARM-INSTALL-LOC-CD           PIC X(01) VALUE SPACES.     
           05 PARM-USER-ID                  PIC X(07) VALUE SPACES.     
           05 PARM-TRAN-COMMENTS.                                       
              49 PARM-TRAN-COMMENTS-LEN     PIC S9(4) COMP VALUE 0.     
              49 PARM-TRAN-COMMENTS-TEXT    PIC X(250) VALUE SPACES.    
           05 PARM-ATTCH-EQUIP-SEQ          PIC S9(10)V COMP-3 VALUE 0. 
           05 PARM-I-EQUIP-TAG-NO           PIC X(12) VALUE SPACES.     
           05 PARM-I-STOCK-CD               PIC X(15) VALUE SPACES.     
           05 PARM-I-EQUIP-MFR-CD           PIC X(02) VALUE SPACES.     
           05 PARM-I-EQUIP-MFR-DT           PIC X(10) VALUE SPACES.     
           05 PARM-I-WARRANTY-EXP-DT        PIC X(10) VALUE SPACES.     
           05 PARM-I-EQUIP-DISPOSAL-DT      PIC X(10) VALUE SPACES.     
           05 PARM-I-STORAGE-FAC-CD         PIC X(03) VALUE SPACES.     
           05 PARM-I-WRNTY-RECEIVED-FL      PIC X(01) VALUE SPACES.     
           05 PARM-I-WRNTY-RECOUP-AMT       PIC S9(5)V99 COMP-3 VALUE 0.
           05 PARM-E-REVENUE-CLASS          PIC X(03) VALUE SPACES.     
           05 PARM-E-CODE-UTIL-TYPE         PIC X(01) VALUE SPACES.     
           05 PARM-E-BILLING-FL             PIC X(01) VALUE SPACES.     
           05 PARM-E-NO-BILL-REASON-CD      PIC X(02) VALUE SPACES.     
           05 PARM-E-RATE-PLAN-NO           PIC X(03) VALUE SPACES.     
           05 PARM-E-RATE-ITEM-CODE         PIC S9(4) COMP VALUE 0.     
           05 PARM-E-EQUIP-OWNER-CD         PIC X(01) VALUE SPACES.     
           05 PARM-E-EQUIP-CONTRACT-FL      PIC X(01) VALUE SPACES.     
           05 PARM-E-NO-CONTRACT-RSN-CD     PIC X(02) VALUE SPACES.     
           05 PARM-E-EQUIP-DRAWING-ID       PIC X(10) VALUE SPACES.     
           05 PARM-E-SPCL-AGR-COMMENTS.                                 
              49 PARM-E-SPCL-AGR-COMMENTS-LEN                           
                                            PIC S9(4) COMP VALUE 0.     
              49 PARM-E-SPCL-AGR-COMMENTS-TEXT                          
                                            PIC X(250) VALUE SPACES.    
           05 PARM-E-EQUIP-COMMENTS.                                    
              49 PARM-E-EQUIP-COMMENTS-LEN  PIC S9(4) COMP VALUE 0.     
              49 PARM-E-EQUIP-COMMENTS-TEXT PIC X(250) VALUE SPACES.    
ACT040     05 PARM-C-CNTRCT-CLP-NO          PIC X(50) VALUE SPACES.     
           05 PARM-C-CNTRCT-START-DT        PIC X(10) VALUE SPACES.     
           05 PARM-C-CNTRCT-DURATION-CD     PIC X(02) VALUE SPACES.     
           05 PARM-C-CNTRCT-END-DT          PIC X(10) VALUE SPACES.     
           05 PARM-C-SOURCE-APPL-CD         PIC X(03) VALUE SPACES.     
           05 PARM-C-SOURCE-APPL-REQ-NO     PIC S9(13)V COMP-3 VALUE 0. 
           05 PARM-C-WMS-INSTALL-COUNT      PIC S9(4) COMP VALUE 0.     
ACT069     05 PARM-C-EFFECTIVE-DATE         PIC X(10) VALUE SPACES.     
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS                      PIC S9(9) COMP VALUE 0.     
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW                   PIC X(01) VALUE 'N'.        
              88 NOT-ALL-DONE                         VALUE 'N'.        
              88 ALL-DONE                             VALUE 'Y'.        
           05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.        
              88 SEND-DONE-ERROR                      VALUE 'N'.        
              88 SEND-DONE-OK                         VALUE 'Y'.        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05 GTT-ROW.                                                  
              49 GTT-ROW-LEN                PIC S9(4) COMP.             
              49 GTT-ROW-CHAR               PIC X(1024).                
           05 GTT-SQLCODE                   PIC S9(9) COMP.             
           05 GTT-NAME                      PIC X(26) VALUE             
                                          'SESSION.CSR04768_R1'.        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE                 PIC S9(9) COMP VALUE 0.     
           05 S-APPL-RETURN-CODE            PIC S9(9) COMP VALUE 0.     
           05 S-BUS-RULE-ID                 PIC X(10) VALUE SPACES.     
           05 S-BUS-RULE-RESULT-CD          PIC X(08) VALUE SPACES.     
           05 S-BUS-RULE-XREF-ID            PIC X(26) VALUE SPACES.     
                                                                        
      *****************************************************************         
      *                                                                         
      *** WORKING STORAGE COPY BOOK FOR CPD00099                                
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      *** WORKING STORAGE COPY BOOK FOR CPDLM001                                
           EXEC SQL                                                             
              INCLUDE CWSLM001                                                  
           END-EXEC.                                                            
                                                                        
      *** SQL COMMUNICATION AREA                                                
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC .                                                           
                                                                        
      *** LMS_EQUIP_INVENTRY,4D                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_ENVRNMT,4F                                                  
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_CONTRACT,4L                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_FXTR_ATTACHMTS,4H                                                 
           EXEC SQL                                                             
              INCLUDE TBFXTATC                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST,4J                                                     
           EXEC SQL                                                             
              INCLUDE TBLGTHST                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_TRANS_HIST_DET,4S                                                 
           EXEC SQL                                                             
              INCLUDE TBLMSHST                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MNT_TRANS_HIST, MH                                                
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_MT_TRN_HST_DET, MI                                                
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_ACCOUNT,AT                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *** WS ABEND WORK AREA                                                    
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *** DB2 ERROR CHECKING.                                                   
           COPY CWS00303.                                                       
      *                                                                         
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET ALL FIXTURES FOR CONTRACT          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE GET_FXTR_CUR CURSOR FOR                           
                 SELECT [4F].EQUIP_SEQ                                    
                       ,[4F].INSTALL_POINT_NO                             
                       ,[4D].EQUIP_TAG_NO                                 
                   FROM LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)           
                       ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                  WHERE [4F].INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO      
                    AND [4F].SOURCE_APPL_CD     = :4F-SOURCE-APPL-CD      
                    AND [4F].SOURCE_APPL_REQ_NO = :4F-SOURCE-APPL-REQ-NO  
                    AND [4F].INSTALL_LOC_CD     = 'P'                     
                    AND [4D].EQUIP_SEQ          =  [4F].EQUIP_SEQ           
                    AND [4D].EQUIP_TYPE_CD      = 'F'                     
                    AND [4F].BILLING_FL         = 'Z'                     
                    AND NOT EXISTS                                      
                       (SELECT 1                                        
                          FROM LMS_EQUIP_CONTRACT [4L]
                           WITH(READUNCOMMITTED)                    
                         WHERE [4L].EQUIP_SEQ = [4D].EQUIP_SEQ              
                           AND [4L].INSTALL_LOC_NO = 
           [4F].INSTALL_LOC_NO)   
                FOR READ ONLY                                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_FXTR_CUR CURSOR FOR                                   
MFA-TR*          SELECT 4F.EQUIP_SEQ                                            
MFA-TR*                ,4F.INSTALL_POINT_NO                                     
MFA-TR*                ,4D.EQUIP_TAG_NO                                         
MFA-TR*            FROM LMS_EQUIP_ENVRNMT  4F                                   
MFA-TR*                ,LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*           WHERE 4F.INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO              
MFA-TR*             AND 4F.SOURCE_APPL_CD     = :4F-SOURCE-APPL-CD              
MFA-TR*             AND 4F.SOURCE_APPL_REQ_NO = :4F-SOURCE-APPL-REQ-NO          
MFA-TR*             AND 4F.INSTALL_LOC_CD     = 'P'                             
MFA-TR*             AND 4D.EQUIP_SEQ          =  4F.EQUIP_SEQ                   
MFA-TR*             AND 4D.EQUIP_TYPE_CD      = 'F'                             
MFA-TR*             AND 4F.BILLING_FL         = 'Z'                             
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*                (SELECT 1                                                
MFA-TR*                   FROM LMS_EQUIP_CONTRACT 4L                            
MFA-TR*                  WHERE 4L.EQUIP_SEQ = 4D.EQUIP_SEQ                      
MFA-TR*                    AND 4L.INSTALL_LOC_NO = 4F.INSTALL_LOC_NO)           
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
     *                                                                  
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01  LINK-SECTION                     PIC X(01).                  
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.         
COB305 01 LINK-FXTR-EQUIP-SEQ        PIC S9(10)V COMP-3 VALUE 0.         
       01  LINK-FXTR-INST-LOC-NO            PIC X(10).                  
COB305 01 LINK-FXTR-INST-POINT-NO        PIC S9(5)V COMP-3 VALUE 0.          
       01  LINK-FXTR-EQUIP-TAG-NO           PIC X(12).                  
       01  LINK-FXTR-BILLING-FL             PIC X(01).                  
ACT046 01  LINK-FXTR-INSTALL-DATE           PIC X(10).                  
       01  LINK-INSTALL-LOC-CD              PIC X(01).                  
       01  LINK-USER-ID                     PIC X(07).                  
       01  LINK-TRAN-COMMENTS.                                          
           05 LINK-TRAN-COMMENTS-LEN        PIC S9(04) COMP.            
           05 LINK-TRAN-COMMENTS-TEXT       PIC X(250).                 
COB305 01 LINK-ATTCH-EQUIP-SEQ        PIC S9(10)V COMP-3 VALUE 0.         
       01  LINK-I-EQUIP-TAG-NO              PIC X(12).                  
       01  LINK-I-STOCK-CD                  PIC X(15).                  
       01  LINK-I-EQUIP-MFR-CD              PIC X(02).                  
       01  LINK-I-EQUIP-MFR-DT              PIC X(10).                  
       01  LINK-I-WARRANTY-EXP-DT           PIC X(10).                  
       01  LINK-I-EQUIP-DISPOSAL-DT         PIC X(10).                  
       01  LINK-I-STORAGE-FAC-CD            PIC X(03).                  
       01  LINK-I-WRNTY-RECEIVED-FL         PIC X(01).                  
COB305 01 LINK-I-WRNTY-RECOUP-AMT        PIC S9(5)V99 COMP-3 VALUE 0.        
       01  LINK-E-REVENUE-CLASS             PIC X(03).                  
       01  LINK-E-CODE-UTIL-TYPE            PIC X(01).                  
       01  LINK-E-BILLING-FL                PIC X(01).                  
       01  LINK-E-NO-BILL-REASON-CD         PIC X(02).                  
       01  LINK-E-RATE-PLAN-NO              PIC X(03).                  
       01  LINK-E-RATE-ITEM-CODE            PIC S9(4) COMP.             
       01  LINK-E-EQUIP-OWNER-CD            PIC X(01).                  
       01  LINK-E-EQUIP-CONTRACT-FL         PIC X(01).                  
       01  LINK-E-NO-CONTRACT-RSN-CD        PIC X(02).                  
       01  LINK-E-EQUIP-DRAWING-ID          PIC X(10).                  
       01  LINK-E-SPCL-AGR-COMMENTS.                                    
           05 LINK-E-SPCL-AGR-COMMENTS-LEN  PIC S9(4) COMP.             
           05 LINK-E-SPCL-AGR-COMMENTS-TEXT PIC X(250).                 
       01  LINK-E-EQUIP-COMMENTS.                                       
           05 LINK-E-EQUIP-COMMENTS-LEN     PIC S9(4) COMP.             
           05 LINK-E-EQUIP-COMMENTS-TEXT    PIC X(250).                 
ACT040 01  LINK-C-CNTRCT-CLP-NO             PIC X(50).                  
       01  LINK-C-CNTRCT-START-DT           PIC X(10).                  
       01  LINK-C-CNTRCT-DURATION-CD        PIC X(02).                  
       01  LINK-C-CNTRCT-END-DT             PIC X(10).                  
       01  LINK-C-SOURCE-APPL-CD            PIC X(03).                  
COB305 01 LINK-C-SOURCE-APPL-REQ-NO        PIC S9(13)V COMP-3 VALUE 0.         
       01  LINK-C-WMS-INSTALL-COUNT         PIC S9(4) COMP.             
ACT069 01  LINK-C-EFFECTIVE-DATE            PIC X(10).                  
                                                                        
       PROCEDURE DIVISION USING LINK-SECTION                            
                                LINK-ACCOUNT-NO                         
                                LINK-FXTR-EQUIP-SEQ                     
                                LINK-FXTR-INST-LOC-NO                   
                                LINK-FXTR-INST-POINT-NO                 
                                LINK-FXTR-EQUIP-TAG-NO                  
                                LINK-FXTR-BILLING-FL                    
ACT046                          LINK-FXTR-INSTALL-DATE                  
                                LINK-INSTALL-LOC-CD                     
                                LINK-USER-ID                            
                                LINK-TRAN-COMMENTS                      
                                LINK-ATTCH-EQUIP-SEQ                    
                                LINK-I-EQUIP-TAG-NO                     
                                LINK-I-STOCK-CD                         
                                LINK-I-EQUIP-MFR-CD                     
                                LINK-I-EQUIP-MFR-DT                     
                                LINK-I-WARRANTY-EXP-DT                  
                                LINK-I-EQUIP-DISPOSAL-DT                
                                LINK-I-STORAGE-FAC-CD                   
                                LINK-I-WRNTY-RECEIVED-FL                
                                LINK-I-WRNTY-RECOUP-AMT                 
                                LINK-E-REVENUE-CLASS                    
                                LINK-E-CODE-UTIL-TYPE                   
                                LINK-E-BILLING-FL                       
                                LINK-E-NO-BILL-REASON-CD                
                                LINK-E-RATE-PLAN-NO                     
                                LINK-E-RATE-ITEM-CODE                   
                                LINK-E-EQUIP-OWNER-CD                   
                                LINK-E-EQUIP-CONTRACT-FL                
                                LINK-E-NO-CONTRACT-RSN-CD               
                                LINK-E-EQUIP-DRAWING-ID                 
                                LINK-E-SPCL-AGR-COMMENTS                
                                LINK-E-EQUIP-COMMENTS                   
                                LINK-C-CNTRCT-CLP-NO                    
                                LINK-C-CNTRCT-START-DT                  
                                LINK-C-CNTRCT-DURATION-CD               
                                LINK-C-CNTRCT-END-DT                    
                                LINK-C-SOURCE-APPL-CD                   
                                LINK-C-SOURCE-APPL-REQ-NO               
                                LINK-C-WMS-INSTALL-COUNT                
ACT069                          LINK-C-EFFECTIVE-DATE.                  
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PARA     THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE-PARA                                           *        
      ******************************************************************        
       0100-INITIALIZE-PARA.                                            
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      DCLLMS-EQUIP-CONTRACT                             
                      DCLLMS-EQUIP-ENVRNMT                              
                      DCLLMS-EQUIP-INVENTRY                             
                      DCLLMS-FXTR-ATTACHMTS                             
                      DCLLMS-TRANS-HIST                                 
                      DCLLMS-TRANS-HIST-DET.                            
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
           PERFORM 7000-GET-ACTION-DATE        THRU 7000-EXIT.          
           IF LINK-FXTR-EQUIP-TAG-NO > SPACES                           
           OR LINK-I-EQUIP-TAG-NO    > SPACES                           
              PERFORM 7025-TAG-NO-CASE-CNVRSN  THRU 7025-EXIT           
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04768_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04768_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS      THRU 8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04768_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04768_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-SECTION                TO PARM-SECTION.            
           MOVE LINK-ACCOUNT-NO             TO PARM-ACCOUNT-NO.         
           MOVE LINK-FXTR-EQUIP-SEQ         TO PARM-FXTR-EQUIP-SEQ.     
           MOVE LINK-FXTR-INST-LOC-NO       TO PARM-FXTR-INST-LOC-NO.   
           MOVE LINK-FXTR-EQUIP-TAG-NO      TO PARM-FXTR-EQUIP-TAG-NO.  
           MOVE LINK-FXTR-INST-POINT-NO     TO PARM-FXTR-INST-POINT-NO. 
           MOVE LINK-FXTR-BILLING-FL        TO PARM-FXTR-BILLING-FL.    
ACT046     MOVE LINK-FXTR-INSTALL-DATE      TO PARM-FXTR-INSTALL-DATE.  
           MOVE LINK-INSTALL-LOC-CD         TO PARM-INSTALL-LOC-CD.     
           MOVE LINK-USER-ID                TO PARM-USER-ID.            
           MOVE LINK-TRAN-COMMENTS          TO PARM-TRAN-COMMENTS.      
           MOVE LINK-ATTCH-EQUIP-SEQ        TO PARM-ATTCH-EQUIP-SEQ.    
           MOVE LINK-I-EQUIP-TAG-NO         TO PARM-I-EQUIP-TAG-NO.     
           MOVE LINK-I-STOCK-CD             TO PARM-I-STOCK-CD.         
           MOVE LINK-I-EQUIP-MFR-CD         TO PARM-I-EQUIP-MFR-CD.     
           MOVE LINK-I-EQUIP-MFR-DT         TO PARM-I-EQUIP-MFR-DT.     
           MOVE LINK-I-WARRANTY-EXP-DT      TO PARM-I-WARRANTY-EXP-DT.  
           MOVE LINK-I-EQUIP-DISPOSAL-DT    TO PARM-I-EQUIP-DISPOSAL-DT.
           MOVE LINK-I-STORAGE-FAC-CD       TO PARM-I-STORAGE-FAC-CD.   
           MOVE LINK-I-WRNTY-RECEIVED-FL    TO PARM-I-WRNTY-RECEIVED-FL.
           MOVE LINK-I-WRNTY-RECOUP-AMT     TO PARM-I-WRNTY-RECOUP-AMT. 
           MOVE LINK-E-REVENUE-CLASS        TO PARM-E-REVENUE-CLASS.    
           MOVE LINK-E-CODE-UTIL-TYPE       TO PARM-E-CODE-UTIL-TYPE.   
           MOVE LINK-E-BILLING-FL           TO PARM-E-BILLING-FL.       
           MOVE LINK-E-NO-BILL-REASON-CD    TO PARM-E-NO-BILL-REASON-CD.
           MOVE LINK-E-RATE-PLAN-NO         TO PARM-E-RATE-PLAN-NO.     
           MOVE LINK-E-RATE-ITEM-CODE       TO PARM-E-RATE-ITEM-CODE.   
           MOVE LINK-E-EQUIP-OWNER-CD       TO PARM-E-EQUIP-OWNER-CD.   
           MOVE LINK-E-EQUIP-CONTRACT-FL    TO PARM-E-EQUIP-CONTRACT-FL.
           MOVE LINK-E-NO-CONTRACT-RSN-CD   TO PARM-E-NO-CONTRACT-RSN-CD
           MOVE LINK-E-EQUIP-DRAWING-ID     TO PARM-E-EQUIP-DRAWING-ID. 
           MOVE LINK-C-CNTRCT-CLP-NO        TO PARM-C-CNTRCT-CLP-NO.    
           MOVE LINK-C-CNTRCT-START-DT      TO PARM-C-CNTRCT-START-DT.  
           MOVE LINK-C-CNTRCT-DURATION-CD   TO PARM-C-CNTRCT-DURATION-CD
           MOVE LINK-C-CNTRCT-END-DT        TO PARM-C-CNTRCT-END-DT.    
           MOVE LINK-E-EQUIP-COMMENTS       TO PARM-E-EQUIP-COMMENTS.   
           MOVE LINK-E-SPCL-AGR-COMMENTS    TO PARM-E-SPCL-AGR-COMMENTS.
           MOVE LINK-C-SOURCE-APPL-CD       TO PARM-C-SOURCE-APPL-CD.   
           MOVE LINK-C-SOURCE-APPL-REQ-NO   TO PARM-C-SOURCE-APPL-REQ-NO
           MOVE LINK-C-WMS-INSTALL-COUNT    TO PARM-C-WMS-INSTALL-COUNT.
ACT069     MOVE LINK-C-EFFECTIVE-DATE       TO PARM-C-EFFECTIVE-DATE .  
                                                                        
           INSPECT PARM-TRAN-COMMENTS-TEXT                              
             REPLACING ALL LOW-VALUES BY SPACES.                        
           INSPECT PARM-E-SPCL-AGR-COMMENTS-TEXT                        
             REPLACING ALL LOW-VALUES BY SPACES.                        
           INSPECT PARM-E-EQUIP-COMMENTS-TEXT                           
             REPLACING ALL LOW-VALUES BY SPACES.                        
                                                                        
           MOVE PARM-SECTION                TO WS-SECTION.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
              WHEN FIXTURE                                              
                PERFORM 2100-PROCESS-STATUS    THRU 2100-EXIT           
                PERFORM 2200-CREATE-FXTR-ENVT  THRU 2200-EXIT           
                                                                        
              WHEN POLE                                                 
                PERFORM 2500-CREATE-INVENTRY   THRU 2500-EXIT           
                PERFORM 2600-CREATE-ENVRNMT    THRU 2600-EXIT           
                PERFORM 2300-CREATE-ATTACHMTS  THRU 2300-EXIT           
                                                                        
              WHEN NODE                                                 
                PERFORM 2100-PROCESS-STATUS    THRU 2100-EXIT           
                PERFORM 2300-CREATE-ATTACHMTS  THRU 2300-EXIT           
                                                                        
              WHEN CONTRACT                                             
                PERFORM 2400-PROCESS-CONTRACT  THRU 2400-EXIT           
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE.            
           MOVE SPACES                     TO S-BUS-RULE-ID.            
           MOVE SPACES                     TO S-BUS-RULE-RESULT-CD.     
           MOVE SPACES                     TO S-BUS-RULE-XREF-ID.       
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2100-PROCESS-STATUS.                                             
                                                                        
           MOVE PARM-FXTR-EQUIP-SEQ         TO 4D-EQUIP-SEQ.            
           IF NODE                                                      
              MOVE PARM-ATTCH-EQUIP-SEQ     TO 4D-EQUIP-SEQ             
           END-IF.                                                      
                                                                        
           PERFORM 7100-GET-INVENTRY-STATUS-CD THRU 7100-EXIT.          
                                                                        
           MOVE 4D-INVENTRY-STATUS-CD       TO WS-PRV-INVENTRY-STATUS-CD
           MOVE WS-INSTALLED                TO 4D-INVENTRY-STATUS-CD.   
           MOVE PARM-USER-ID                TO 4D-LAST-UPDATE-USERID.   
                                                                        
           PERFORM 8200-UPDATE-EQUIP-INV       THRU 8200-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-CREATE-FXTR-ENVT.                                           
                                                                        
           MOVE PARM-FXTR-INST-LOC-NO       TO 4F-INSTALL-LOC-NO.       
                                                                        
           PERFORM 7200-GET-MAX-INSTALL-POINT-NO THRU 7200-EXIT.        
           COMPUTE 4F-INSTALL-POINT-NO = 4F-INSTALL-POINT-NO + 1.       
                                                                        
           MOVE 4D-EQUIP-SEQ                TO 4F-EQUIP-SEQ.            
                                                                        
           IF PARM-INSTALL-LOC-CD = 'P'                                 
              MOVE WS-PREMISE               TO 4F-INSTALL-LOC-CD        
           ELSE                                                         
              MOVE WS-SUBDIVISION           TO 4F-INSTALL-LOC-CD        
           END-IF.                                                      
                                                                        
           MOVE PARM-E-CODE-UTIL-TYPE       TO 4F-CODE-UTIL-TYPE.       
           MOVE 0                           TO 4F-IC-NO.                
           MOVE PARM-E-RATE-PLAN-NO         TO 4F-RATE-PLAN-NO.         
           MOVE PARM-E-RATE-ITEM-CODE       TO 4F-RATE-ITEM-CODE.       
           MOVE 0                           TO 4F-ITEM-SEQ-NO.          
           MOVE PARM-E-BILLING-FL           TO 4F-BILLING-FL.           
           MOVE PARM-E-NO-BILL-REASON-CD    TO 4F-NO-BILL-REASON-CD.    
           MOVE PARM-E-EQUIP-CONTRACT-FL    TO 4F-EQUIP-CONTRACT-FL.    
           MOVE PARM-E-NO-CONTRACT-RSN-CD   TO 4F-NO-CONTRACT-RSN-CD.   
           MOVE PARM-E-EQUIP-OWNER-CD       TO 4F-EQUIP-OWNER-CD.       
           MOVE PARM-E-EQUIP-DRAWING-ID     TO 4F-EQUIP-DRAWING-ID.     
           MOVE 0                           TO 4F-EQUIP-GIS-GKEY.       
           MOVE SPACES                      TO 4F-SOURCE-APPL-CD.       
           MOVE 0                           TO 4F-SOURCE-APPL-REQ-NO.   
           MOVE 0                           TO 4F-WMS-POINT-NO.         
ACT046     MOVE PARM-FXTR-INSTALL-DATE      TO 4F-EQUIP-INSTALL-DT.     
           MOVE PARM-USER-ID                TO 4F-LAST-UPDATE-USERID.   
                                                                        
           MOVE PARM-E-SPCL-AGR-COMMENTS-TEXT                           
                                            TO 4F-SPCL-AGR-COMMENTS-TEXT
           MOVE LENGTH OF PARM-E-SPCL-AGR-COMMENTS-TEXT                 
                                            TO 4F-SPCL-AGR-COMMENTS-LEN.
                                                                        
           MOVE PARM-E-EQUIP-COMMENTS-TEXT  TO 4F-EQUIP-COMMENTS-TEXT.  
           MOVE LENGTH OF PARM-E-EQUIP-COMMENTS-TEXT                    
                                            TO 4F-EQUIP-COMMENTS-LEN.   
                                                                        
           PERFORM 8300-INSERT-EQUIP-ENV       THRU 8300-EXIT.          
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-CREATE-ATTACHMTS.                                           
                                                                        
           MOVE PARM-FXTR-EQUIP-SEQ         TO 4H-FXTR-EQUIP-SEQ.       
                                                                        
           PERFORM 7300-GET-MAX-ATTACH-SEQ-NO  THRU 7300-EXIT.          
           COMPUTE 4H-ATTACH-SEQ-NO = 4H-ATTACH-SEQ-NO + 1.             
                                                                        
           MOVE 4D-EQUIP-SEQ                TO 4H-ATTACH-EQUIP-SEQ.     
           IF NODE                                                      
              MOVE PARM-ATTCH-EQUIP-SEQ     TO 4H-ATTACH-EQUIP-SEQ      
           END-IF.                                                      
                                                                        
           MOVE PARM-SECTION                TO 4H-EQUIP-TYPE-CD.        
           MOVE WS-ACTION-DATE              TO 4H-ATTACH-EQUIP-DT.      
           MOVE PARM-USER-ID                TO 4H-LAST-UPDATE-USERID.   
                                                                        
           PERFORM 8400-INSERT-FXTR-ATTACHMTS  THRU 8400-EXIT.          
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-PROCESS-CONTRACT.                                           
      *** FOR PARM-C-WMS-INSTALL-COUNT > 1, GET ALL FIXTURES                    
      *** AND CREATE CONTRACT                                                   
                                                                        
           MOVE PARM-ACCOUNT-NO             TO 4L-ACCOUNT-NO.           
           MOVE PARM-C-CNTRCT-START-DT      TO 4L-CNTRCT-START-DT.      
           MOVE PARM-C-CNTRCT-END-DT        TO 4L-CNTRCT-END-DT.        
           MOVE PARM-C-CNTRCT-DURATION-CD   TO 4L-CNTRCT-DURATION-CD.   
           MOVE PARM-C-CNTRCT-CLP-NO        TO 4L-CNTRCT-CLP-NO.        
           MOVE 'A'                         TO 4L-CNTRCT-STATUS-CD.     
           MOVE SPACES                      TO 4F-NO-CONTRACT-RSN-CD.   
           MOVE PARM-FXTR-INST-LOC-NO       TO 4L-INSTALL-LOC-NO        
                                               4F-INSTALL-LOC-NO.       
           MOVE PARM-USER-ID                TO 4L-LAST-UPDATE-USERID    
                                               4F-LAST-UPDATE-USERID.   
                                                                        
           MOVE PARM-C-SOURCE-APPL-CD       TO 4F-SOURCE-APPL-CD.       
           MOVE PARM-C-SOURCE-APPL-REQ-NO   TO 4F-SOURCE-APPL-REQ-NO.   
                                                                        
           IF PARM-C-WMS-INSTALL-COUNT > 1                              
              PERFORM 7510-OPEN-GET-FXTR-CUR   THRU 7510-EXIT           
              PERFORM 7520-FETCH-GET-FXTR-CUR  THRU 7520-EXIT           
                                                                        
              PERFORM 2410-CREATE-CONTRACT     THRU 2410-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                                                                        
              PERFORM 7530-CLOSE-GET-FXTR-CUR  THRU 7530-EXIT           
           ELSE                                                         
              PERFORM 2410-CREATE-CONTRACT     THRU 2410-EXIT           
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2410-CREATE-CONTRACT.                                            
                                                                        
           MOVE PARM-FXTR-EQUIP-SEQ         TO 4L-EQUIP-SEQ.            
           PERFORM 7600-GET-FIXTURE-COST       THRU 7600-EXIT.          
           PERFORM 7700-GET-POLE-COST          THRU 7700-EXIT.          
                                                                        
           PERFORM 8500-INSERT-EQUIP-CNT       THRU 8500-EXIT.          
                                                                        
           MOVE WS-YES                      TO 4F-EQUIP-CONTRACT-FL.    
           MOVE SPACES                      TO 4F-NO-CONTRACT-RSN-CD.   
           PERFORM 8700-UPDATE-CONT-FLAG       THRU 8700-EXIT.          
                                                                        
           PERFORM 5800-CREATE-TRNS-HIST       THRU 5800-EXIT.          
                                                                        
           IF PARM-C-WMS-INSTALL-COUNT > 1                              
A#5460        MOVE 0                        TO 4S-DETAIL-SEQ-NO         
              PERFORM 7520-FETCH-GET-FXTR-CUR  THRU 7520-EXIT           
           END-IF.                                                      
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-CREATE-INVENTRY.                                            
                                                                        
           PERFORM 7400-GET-EQUIP-SEQ          THRU 7400-EXIT.          
                                                                        
           MOVE PARM-I-EQUIP-TAG-NO         TO 4D-EQUIP-TAG-NO.         
           MOVE WS-COMPANY                  TO 4D-COMPANY-NO.           
           MOVE WS-CODE-SERVICE-TYPE        TO 4D-CODE-SERVICE-TYPE.    
           MOVE PARM-I-STOCK-CD             TO 4D-STOCK-CD.             
           MOVE WS-SECTION                  TO 4D-EQUIP-TYPE-CD.        
           MOVE PARM-I-EQUIP-MFR-CD         TO 4D-EQUIP-MFR-CD.         
                                                                        
           IF FIXTURE                                                   
              MOVE PARM-I-EQUIP-MFR-DT      TO 4D-EQUIP-MFR-DT          
              IF 4D-EQUIP-MFR-DT > SPACES                               
                 MOVE 0                     TO WS-EQUIP-MFR-DT-IND      
              END-IF                                                    
              MOVE PARM-I-WARRANTY-EXP-DT   TO 4D-WARRANTY-EXP-DT       
              IF 4D-WARRANTY-EXP-DT > SPACES                            
                 MOVE 0                     TO WS-EQUIP-MFR-DT-IND      
              END-IF                                                    
              MOVE PARM-I-EQUIP-DISPOSAL-DT TO 4D-EQUIP-DISPOSAL-DT     
              IF 4D-EQUIP-DISPOSAL-DT > SPACES                          
                 MOVE 0                     TO WS-EQUIP-DISPOSAL-DT-IND 
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                   TO 4D-EQUIP-MFR-DT          
                                               4D-WARRANTY-EXP-DT       
                                               4D-EQUIP-DISPOSAL-DT     
           END-IF.                                                      
                                                                        
           MOVE SPACES                      TO 4D-STORAGE-FAC-CD.       
           MOVE SPACES                      TO 4D-IN-TRANSIT-USERID.    
           MOVE WS-INSTALLED                TO 4D-INVENTRY-STATUS-CD.   
           MOVE PARM-I-WRNTY-RECEIVED-FL    TO 4D-WRNTY-RECEIVED-FL.    
           MOVE 0                           TO 4D-WRNTY-RECOUP-AMT.     
           MOVE PARM-USER-ID                TO 4D-LAST-UPDATE-USERID.   
                                                                        
           PERFORM 8600-INSERT-EQUIP-INV       THRU 8600-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-CREATE-ENVRNMT.                                             
                                                                        
           MOVE PARM-FXTR-INST-LOC-NO       TO 4F-INSTALL-LOC-NO.       
                                                                        
           PERFORM 7200-GET-MAX-INSTALL-POINT-NO THRU 7200-EXIT.        
           COMPUTE 4F-INSTALL-POINT-NO = 4F-INSTALL-POINT-NO + 1.       
                                                                        
           MOVE 4D-EQUIP-SEQ                TO 4F-EQUIP-SEQ.            
                                                                        
           IF PARM-INSTALL-LOC-CD = 'P'                                 
              MOVE WS-PREMISE               TO 4F-INSTALL-LOC-CD        
           ELSE                                                         
              MOVE WS-SUBDIVISION           TO 4F-INSTALL-LOC-CD        
           END-IF.                                                      
                                                                        
           MOVE PARM-E-CODE-UTIL-TYPE       TO 4F-CODE-UTIL-TYPE.       
           MOVE 0                           TO 4F-IC-NO.                
           MOVE PARM-E-RATE-PLAN-NO         TO 4F-RATE-PLAN-NO.         
           MOVE PARM-E-RATE-ITEM-CODE       TO 4F-RATE-ITEM-CODE.       
           MOVE 0                           TO 4F-ITEM-SEQ-NO.          
           MOVE PARM-E-NO-BILL-REASON-CD    TO 4F-NO-BILL-REASON-CD.    
           MOVE PARM-E-EQUIP-CONTRACT-FL    TO 4F-EQUIP-CONTRACT-FL.    
           MOVE PARM-E-NO-CONTRACT-RSN-CD   TO 4F-NO-CONTRACT-RSN-CD.   
           MOVE PARM-E-EQUIP-OWNER-CD       TO 4F-EQUIP-OWNER-CD.       
           MOVE PARM-E-EQUIP-DRAWING-ID     TO 4F-EQUIP-DRAWING-ID.     
           MOVE 0                           TO 4F-EQUIP-GIS-GKEY.       
           MOVE SPACES                      TO 4F-SOURCE-APPL-CD.       
           MOVE 0                           TO 4F-SOURCE-APPL-REQ-NO.   
           MOVE 0                           TO 4F-WMS-POINT-NO.         
ACT046     IF LINK-FXTR-BILLING-FL = 'Z'                                
ACT046        MOVE PARM-FXTR-INSTALL-DATE   TO 4F-EQUIP-INSTALL-DT      
ACT046     ELSE                                                         
ACT069        IF PARM-C-EFFECTIVE-DATE > SPACES                         
ACT069           MOVE PARM-C-EFFECTIVE-DATE TO 4F-EQUIP-INSTALL-DT      
ACT069                                         WS-ACTION-DATE           
ACT069        ELSE                                                      
ACT069           MOVE WS-ACTION-DATE        TO 4F-EQUIP-INSTALL-DT      
ACT069        END-IF                                                    
ACT046     END-IF.                                                      
           MOVE PARM-USER-ID                TO 4F-LAST-UPDATE-USERID.   
                                                                        
           MOVE PARM-E-SPCL-AGR-COMMENTS-TEXT                           
                                            TO 4F-SPCL-AGR-COMMENTS-TEXT
           MOVE LENGTH OF PARM-E-SPCL-AGR-COMMENTS-TEXT                 
                                            TO 4F-SPCL-AGR-COMMENTS-LEN.
                                                                        
           MOVE PARM-E-EQUIP-COMMENTS-TEXT  TO 4F-EQUIP-COMMENTS-TEXT.  
           MOVE LENGTH OF PARM-E-EQUIP-COMMENTS-TEXT                    
                                            TO 4F-EQUIP-COMMENTS-LEN.   
           MOVE PARM-E-BILLING-FL           TO 4F-BILLING-FL.           
                                                                        
           IF (PARM-FXTR-BILLING-FL = 'Y' OR 'N') AND                   
               PARM-INSTALL-LOC-CD = 'P'          AND                   
               4F-RATE-PLAN-NO > SPACES           AND                   
               4F-RATE-ITEM-CODE > 0                                    
              MOVE 'Z'                      TO 4F-BILLING-FL            
           END-IF.                                                      
                                                                        
           PERFORM 8300-INSERT-EQUIP-ENV       THRU 8300-EXIT.          
                                                                        
           IF (PARM-FXTR-BILLING-FL = 'Y' OR 'N') AND                   
               PARM-INSTALL-LOC-CD = 'P'          AND                   
               4F-RATE-PLAN-NO > SPACES           AND                   
               4F-RATE-ITEM-CODE > 0                                    
               PERFORM 5300-SYNC-LIGHTS      THRU 5300-EXIT             
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-SYNC-LIGHTS.                                              *        
      * THIS WILL BE TREATED AS NEW LIGHT (CALLED FOR NEW INSTALLATION *        
      * OR INITIAL APPROVAL)                                           *        
      ******************************************************************        
       5300-SYNC-LIGHTS.                                                
                                                                        
           SET ADD-NEW-LIGHT TO TRUE.                                   
                                                                        
           INITIALIZE LM001-INPUT.                                      
                                                                        
           MOVE PARM-ACCOUNT-NO             TO LM001-ACCOUNT-NO.        
           MOVE PARM-FXTR-INST-LOC-NO       TO LM001-INSTALL-LOC-NO.    
           EVALUATE TRUE                                                
              WHEN FIXTURE                                              
                 MOVE PARM-FXTR-INST-POINT-NO  TO LM001-INSTALL-POINT-NO
              WHEN POLE                                                 
                 MOVE 4F-INSTALL-POINT-NO      TO LM001-INSTALL-POINT-NO
           END-EVALUATE.                                                
           MOVE PARM-E-REVENUE-CLASS        TO LM001-CODE-REVENUE-CLASS.
           MOVE WS-ACTION-DATE              TO LM001-ACTION-DATE.       
           MOVE WS-ACTION-CODE              TO LM001-ACTION-CODE.       
           MOVE PARM-USER-ID                TO LM001-USER-ID.           
           MOVE PROGRAM-NAME                TO LM001-PROGRAM-NAME.      
                                                                        
           PERFORM 6300-LM001-CUST-LIGHT-SYNC                           
              THRU 6300-LM001-EXIT.                                     
                                                                        
           IF LM001-ERROR                                               
              MOVE LM001-ERR-SQLCODE     TO WS-ACTIVE-RETURN-CODE       
              MOVE LM001-BUS-RULE-ID     TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              MOVE 'CPDLM001'            TO ABEND-PROGRAM               
              MOVE LM001-ERR-PARAGRAPH-NO TO ACTIVE-PARAGRAPH           
              MOVE LM001-ERR-FUNCTION    TO ABEND-FUNCTION              
              MOVE LM001-ERR-TABLE1      TO TABLE-1                     
              MOVE LM001-ERR-TABLE2      TO TABLE-2                     
              MOVE LM001-ERR-COLUMN-1    TO TABLE-ELEMENT-1             
              MOVE LM001-ERR-COLUMN-2    TO TABLE-ELEMENT-2             
              MOVE LM001-ERR-COLUMN-3    TO TABLE-ELEMENT-3             
              MOVE LM001-ERR-COLUMN-4    TO TABLE-ELEMENT-4             
              MOVE LM001-ERR-HOSTVAR-1   TO HOSTVAR-ELEMENT-1           
              MOVE LM001-ERR-HOSTVAR-2   TO HOSTVAR-ELEMENT-2           
              MOVE LM001-ERR-HOSTVAR-3   TO HOSTVAR-ELEMENT-3           
              MOVE LM001-ERR-HOSTVAR-4   TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-CREATE-TRNS-HIST.                                           
                                                                        
           MOVE 0                        TO 4J-SOURCE-APPL-REQ-NO       
                                            4J-WMS-POINT-NO.            
           MOVE SPACES                   TO 4J-SOURCE-APPL-CD.          
           MOVE PROGRAM-NAME             TO 4J-APPL-PROGRAM-ID.         
           MOVE PARM-ACCOUNT-NO          TO 4J-ACCOUNT-NO.              
           MOVE PARM-FXTR-EQUIP-TAG-NO   TO 4J-EQUIP-TAG-NO.            
           MOVE PARM-FXTR-INST-LOC-NO    TO 4J-INSTALL-LOC-NO.          
           MOVE PARM-FXTR-INST-POINT-NO  TO 4J-INSTALL-POINT-NO.        
           MOVE PARM-USER-ID             TO 4J-LAST-UPDATE-USERID       
                                            4S-LAST-UPDATE-USERID.      
           MOVE PARM-FXTR-EQUIP-SEQ      TO 4J-EQUIP-SEQ                
                                            4S-EQUIP-SEQ.               
                                                                        
           IF PARM-TRAN-COMMENTS-TEXT  > SPACES                         
              MOVE PARM-TRAN-COMMENTS-TEXT                              
                                         TO 4J-TRANS-COMMENTS-TEXT      
              MOVE LENGTH OF PARM-TRAN-COMMENTS-TEXT                    
                                         TO 4J-TRANS-COMMENTS-LEN       
           ELSE                                                         
              MOVE WS-TRANS-CMNT-TXT     TO 4J-TRANS-COMMENTS-TEXT      
              MOVE LENGTH OF WS-TRANS-CMNT-TXT                          
                                         TO 4J-TRANS-COMMENTS-LEN       
           END-IF.                                                      
           ADD +1                        TO 4S-DETAIL-SEQ-NO.           
                                                                        
           PERFORM 5810-CREATE-TRNS-HIST-DTL THRU 5810-EXIT.            
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5810-CREATE-TRNS-HIST-DTL.                                       
                                                                        
           EVALUATE TRUE                                                
              WHEN FIXTURE                                              
                PERFORM 5820-CREATE-FXTR-TRANS-HST-DTL                  
                   THRU 5820-EXIT                                       
                                                                        
              WHEN NODE                                                 
                PERFORM 5830-CREATE-NODE-TRANS-HST-DTL                  
                   THRU 5830-EXIT                                       
                                                                        
              WHEN POLE                                                 
                PERFORM 5840-CREATE-POLE-TRANS-HST-DTL                  
                   THRU 5840-EXIT                                       
                                                                        
              WHEN CONTRACT                                             
                PERFORM 5850-CREATE-CNTR-TRANS-HST-DTL                  
                   THRU 5850-EXIT                                       
           END-EVALUATE.                                                
                                                                        
       5810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5820-CREATE-FXTR-TRANS-HST-DTL.                                  
                                                                        
           MOVE 'FXTR_NUMBER'               TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-FXTR-EQUIP-TAG-NO      TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-FXTR-EQUIP-TAG-NO                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'FXTR_RATE_PLAN_NO'         TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-E-RATE-PLAN-NO         TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-E-RATE-PLAN-NO                           
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'FXTR_RATE_ITEM_CD'         TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-E-RATE-ITEM-CODE       TO WS-RATE-ITEM-CD.         
           MOVE WS-RATE-ITEM-CD             TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-RATE-ITEM-CD TO 4S-CHG-COLUMN-VALUE-LEN.   
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'FXTR_BILLING_FL'           TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-FXTR-BILLING-FL        TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-FXTR-BILLING-FL                          
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           IF PARM-FXTR-BILLING-FL = WS-NO                              
              MOVE 'FXTR_NOBILL_RSN_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE PARM-E-NO-BILL-REASON-CD TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF PARM-E-NO-BILL-REASON-CD                   
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           MOVE 'EQUIP_CONTRACT_FL'         TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-E-EQUIP-CONTRACT-FL    TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-E-EQUIP-CONTRACT-FL                      
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           IF PARM-E-EQUIP-CONTRACT-FL = WS-NO                          
              MOVE 'NO_CONTRACT_RSN_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE PARM-E-NO-CONTRACT-RSN-CD                            
                                            TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF PARM-E-NO-CONTRACT-RSN-CD                  
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
           MOVE 'EQUIP_INSTALL_DT'          TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-ACTION-DATE              TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-ACTION-DATE    TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'EQUIP_DRAWING_ID'          TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-E-EQUIP-DRAWING-ID     TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-E-EQUIP-DRAWING-ID                       
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
       5820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5830-CREATE-NODE-TRANS-HST-DTL.                                  
                                                                        
           MOVE 'NODE_NUMBER'               TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-I-EQUIP-TAG-NO         TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-I-EQUIP-TAG-NO                           
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'NODE_INVNTRY_ST_CD'        TO 4S-COLUMN-DESC.          
           MOVE WS-PRV-INVENTRY-STATUS-CD   TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-PRV-INVENTRY-STATUS-CD                     
                                            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE 4D-INVENTRY-STATUS-CD       TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF 4D-INVENTRY-STATUS-CD                         
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
       5830-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5840-CREATE-POLE-TRANS-HST-DTL.                                  
                                                                        
           MOVE 'POLE_NUMBER'               TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-I-EQUIP-TAG-NO         TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-I-EQUIP-TAG-NO                           
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'STOCK_CD'                  TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-I-STOCK-CD             TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-I-STOCK-CD   TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'POLE_BILLING_FL'           TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-E-BILLING-FL           TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-E-BILLING-FL TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           IF PARM-E-BILLING-FL = WS-NO                                 
              MOVE 'POLE_NOBILL_RSN_CD'     TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE PARM-E-NO-BILL-REASON-CD TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF PARM-E-NO-BILL-REASON-CD                   
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           ELSE                                                         
              MOVE 'POLE_RATE_PLAN_NO'      TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE PARM-E-RATE-PLAN-NO      TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF PARM-E-RATE-PLAN-NO                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
                                                                        
              MOVE 'POLE_RATE_ITEM_CD'      TO 4S-COLUMN-DESC           
              MOVE WS-NEW                   TO 4S-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-NEW         TO 4S-PRV-COLUMN-VALUE-LEN  
              MOVE PARM-E-RATE-ITEM-CODE    TO WS-RATE-ITEM-CD          
              MOVE WS-RATE-ITEM-CD          TO 4S-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-RATE-ITEM-CD                            
                                            TO 4S-CHG-COLUMN-VALUE-LEN  
              PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                      
                 THRU 6000-CPDLM2-EXIT                                  
           END-IF.                                                      
                                                                        
       5840-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5850-CREATE-CNTR-TRANS-HST-DTL.                                  
                                                                        
           MOVE 'CNTRCT_START_DT'           TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-C-CNTRCT-START-DT      TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-C-CNTRCT-START-DT                        
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'CNTRCT_END_DT'             TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-C-CNTRCT-END-DT        TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-C-CNTRCT-END-DT                          
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'CNTRCT_DURATION_CD'        TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-C-CNTRCT-DURATION-CD   TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF PARM-C-CNTRCT-DURATION-CD                     
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'FIXTURE_COST_AM'           TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE 4L-FIXTURE-COST-AM          TO WS-COST-AMT.             
           MOVE WS-COST-AMT                 TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-COST-AMT       TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'POLE_COST_AM'              TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE 4L-POLE-COST-AM             TO WS-COST-AMT.             
           MOVE WS-COST-AMT                 TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-COST-AMT       TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'CNTRCT_CLP_NO'             TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE 4L-CNTRCT-CLP-NO            TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF 4L-CNTRCT-CLP-NO  TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
           MOVE 'CNTRCT_STATUS_CD'          TO 4S-COLUMN-DESC.          
           MOVE WS-NEW                      TO 4S-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF WS-NEW            TO 4S-PRV-COLUMN-VALUE-LEN. 
           MOVE 4L-CNTRCT-STATUS-CD         TO 4S-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF 4L-CNTRCT-STATUS-CD                           
                                            TO 4S-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6000-LOAD-LMS-TRN-HST-CPDLM2                         
              THRU 6000-CPDLM2-EXIT.                                    
                                                                        
       5850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *6000-LOAD-LMS-TRN-HST-CPDLM2                                    *        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM002                                                  
           END-EXEC.                                                            
                                                                        
      *6300-LM001-CUST-LITE-SYNC                                                
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDLM001                                                  
           END-EXEC.                                                            
                                                                        
       7000-GET-ACTION-DATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-ACTION-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-ACTION-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'ACTION-DATE'            TO TABLE-ELEMENT-1          
              MOVE WS-ACTION-DATE           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-TAG-NO-CASE-CNVRSN.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              UPPER(:LINK-I-EQUIP-TAG-NO),
              UPPER(:LINK-FXTR-EQUIP-TAG-NO)
            INTO
              :LINK-I-EQUIP-TAG-NO,
              :LINK-FXTR-EQUIP-TAG-NO
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :LINK-I-EQUIP-TAG-NO  = UPPER(:LINK-I-EQUIP-TAG-NO)           
MFA-TR*        ,:LINK-FXTR-EQUIP-TAG-NO = UPPER(:LINK-FXTR-EQUIP-TAG-NO)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'POLE-EQUIP-TAG-NO'      TO TABLE-ELEMENT-1          
              MOVE LINK-I-EQUIP-TAG-NO      TO HOSTVAR-ELEMENT-1        
              MOVE 'FXTR-EQUIP-TAG-NO'      TO TABLE-ELEMENT-2          
              MOVE LINK-FXTR-EQUIP-TAG-NO   TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-INVENTRY-STATUS-CD.                                     
                                                                        
           EXEC SQL                                                     
              SELECT INVENTRY_STATUS_CD                                 
                INTO :4D-INVENTRY-STATUS-CD                             
               FROM  LMS_EQUIP_INVENTRY WITH(READUNCOMMITTED)                   
              WHERE  EQUIP_SEQ = :4D-EQUIP-SEQ                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT INVENTRY_STATUS_CD                                         
MFA-TR*         INTO :4D-INVENTRY-STATUS-CD                                     
MFA-TR*        FROM  LMS_EQUIP_INVENTRY                                         
MFA-TR*       WHERE  EQUIP_SEQ = :4D-EQUIP-SEQ                                  
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-MAX-INSTALL-POINT-NO.                                   
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MAX([4F].INSTALL_POINT_NO),0)                 
                INTO :4F-INSTALL-POINT-NO                               
               FROM  LMS_EQUIP_ENVRNMT [4F] WITH(READUNCOMMITTED)               
              WHERE  [4F].INSTALL_LOC_NO = :4F-INSTALL-LOC-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(4F.INSTALL_POINT_NO),0)                         
MFA-TR*         INTO :4F-INSTALL-POINT-NO                                       
MFA-TR*        FROM  LMS_EQUIP_ENVRNMT 4F                                       
MFA-TR*       WHERE  4F.INSTALL_LOC_NO = :4F-INSTALL-LOC-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-MAX-ATTACH-SEQ-NO.                                      
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MAX([4H].ATTACH_SEQ_NO),0)                    
                INTO :4H-ATTACH-SEQ-NO                                  
               FROM  LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)              
              WHERE  [4H].FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(4H.ATTACH_SEQ_NO),0)                            
MFA-TR*         INTO :4H-ATTACH-SEQ-NO                                          
MFA-TR*        FROM  LMS_FXTR_ATTACHMTS 4H                                      
MFA-TR*       WHERE  4H.FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ'         TO TABLE-ELEMENT-1          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-EQUIP-SEQ.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              NEXT VALUE FOR SEQ_ID_EQUIP_SEQ
            INTO
              :4D-EQUIP-SEQ                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :4D-EQUIP-SEQ =                                               
MFA-TR*           NEXT VALUE FOR SEQ_ID_EQUIP_SEQ                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ '             TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-OPEN-GET-FXTR-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN GET_FXTR_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7510'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'SOURCE_APPL_REQ_NO'     TO TABLE-ELEMENT-2          
              MOVE 4F-SOURCE-APPL-REQ-NO    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7520-FETCH-GET-FXTR-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH GET_FXTR_CUR                                       
                INTO :PARM-FXTR-EQUIP-SEQ                               
                    ,:PARM-FXTR-INST-POINT-NO                           
                    ,:PARM-FXTR-EQUIP-TAG-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'SOURCE_APPL_REQ_NO'     TO TABLE-ELEMENT-2          
              MOVE 4F-SOURCE-APPL-REQ-NO    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7530-CLOSE-GET-FXTR-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE GET_FXTR_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7530'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              MOVE 'SOURCE_APPL_REQ_NO'     TO TABLE-ELEMENT-2          
              MOVE 4F-SOURCE-APPL-REQ-NO    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-GET-FIXTURE-COST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(SUM([4A].EQUIPMENT_COST_AM),0)                
                INTO :4L-FIXTURE-COST-AM                                
               FROM  LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
              WHERE [4A].EQUIP_TYPE_CD  = 'F'                             
                AND [4A].EQUIP_TYPE_CD  = [4D].EQUIP_TYPE_CD                
                AND [4A].STOCK_CD       = [4D].STOCK_CD                     
                AND [4D].EQUIP_SEQ      = :PARM-FXTR-EQUIP-SEQ            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(SUM(4A.EQUIPMENT_COST_AM),0)                        
MFA-TR*         INTO :4L-FIXTURE-COST-AM                                        
MFA-TR*        FROM  LMS_MSTR_STCK_INFO 4A                                      
MFA-TR*             ,LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*       WHERE 4A.EQUIP_TYPE_CD  = 'F'                                     
MFA-TR*         AND 4A.EQUIP_TYPE_CD  = 4D.EQUIP_TYPE_CD                        
MFA-TR*         AND 4A.STOCK_CD       = 4D.STOCK_CD                             
MFA-TR*         AND 4D.EQUIP_SEQ      = :PARM-FXTR-EQUIP-SEQ                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_MSTR_STCK_INFO'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE PARM-FXTR-EQUIP-SEQ      TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-GET-POLE-COST.                                              
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(SUM([4A].EQUIPMENT_COST_AM),0)                
                INTO :4L-POLE-COST-AM                                   
               FROM  LMS_MSTR_STCK_INFO [4A] WITH(READUNCOMMITTED)              
                    ,LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
              WHERE [4A].EQUIP_TYPE_CD    = 'P'                           
                AND [4A].EQUIP_TYPE_CD    = [4D].EQUIP_TYPE_CD              
                AND [4D].EQUIP_TYPE_CD    = [4H].EQUIP_TYPE_CD              
                AND [4A].STOCK_CD         = [4D].STOCK_CD                   
                AND [4H].ATTACH_EQUIP_SEQ = [4F].EQUIP_SEQ                  
                AND [4F].EQUIP_SEQ        = [4D].EQUIP_SEQ                  
                AND [4F].BILLING_FL       = 'Z'                           
                AND [4H].FXTR_EQUIP_SEQ   = :PARM-FXTR-EQUIP-SEQ          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(SUM(4A.EQUIPMENT_COST_AM),0)                        
MFA-TR*         INTO :4L-POLE-COST-AM                                           
MFA-TR*        FROM  LMS_MSTR_STCK_INFO 4A                                      
MFA-TR*             ,LMS_FXTR_ATTACHMTS 4H                                      
MFA-TR*             ,LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*             ,LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*       WHERE 4A.EQUIP_TYPE_CD    = 'P'                                   
MFA-TR*         AND 4A.EQUIP_TYPE_CD    = 4D.EQUIP_TYPE_CD                      
MFA-TR*         AND 4D.EQUIP_TYPE_CD    = 4H.EQUIP_TYPE_CD                      
MFA-TR*         AND 4A.STOCK_CD         = 4D.STOCK_CD                           
MFA-TR*         AND 4H.ATTACH_EQUIP_SEQ = 4F.EQUIP_SEQ                          
MFA-TR*         AND 4F.EQUIP_SEQ        = 4D.EQUIP_SEQ                          
MFA-TR*         AND 4F.BILLING_FL       = 'Z'                                   
MFA-TR*         AND 4H.FXTR_EQUIP_SEQ   = :PARM-FXTR-EQUIP-SEQ                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_MSTR_STCK_INFO'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE PARM-FXTR-EQUIP-SEQ      TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)               
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE      1R                                       
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7800'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-BUS-RULE-ID           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04768_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04768_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE GTT-NAME                 TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04768_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-BUS-RULE-ID                                       
                  ,:S-BUS-RULE-RESULT-CD                                
                  ,:S-BUS-RULE-XREF-ID                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04768_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-BUS-RULE-ID                                               
MFA-TR*           ,:S-BUS-RULE-RESULT-CD                                        
MFA-TR*           ,:S-BUS-RULE-XREF-ID                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04768_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-UPDATE-EQUIP-INV.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_INVENTRY                                 
                 SET INVENTRY_STATUS_CD = :4D-INVENTRY-STATUS-CD        
                    ,LAST_UPDATE_USERID = :4D-LAST-UPDATE-USERID        
               WHERE EQUIP_SEQ = :4D-EQUIP-SEQ                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'LMS_EQUIP_INVENTRY'    TO TABLE-1                  
               MOVE 'EQUIP_SEQ'             TO TABLE-ELEMENT-1          
               MOVE 4D-EQUIP-SEQ            TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-INSERT-EQUIP-ENV.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_ENVRNMT                             
                 (                                                      
                   INSTALL_LOC_NO                                       
                  ,INSTALL_POINT_NO                                     
                  ,EQUIP_SEQ                                            
                  ,INSTALL_LOC_CD                                       
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,BILLING_FL                                           
                  ,NO_BILL_REASON_CD                                    
                  ,EQUIP_CONTRACT_FL                                    
                  ,NO_CONTRACT_RSN_CD                                   
                  ,EQUIP_OWNER_CD                                       
                  ,EQUIP_DRAWING_ID                                     
                  ,EQUIP_GIS_GKEY                                       
                  ,SOURCE_APPL_CD                                       
                  ,SOURCE_APPL_REQ_NO                                   
                  ,WMS_POINT_NO                                         
                  ,EQUIP_INSTALL_DT                                     
                  ,INSTALL_USERID                                       
                  ,LAST_UPDATE_USERID                                   
                  ,SPCL_AGR_COMMENTS                                    
                  ,EQUIP_COMMENTS                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :4F-INSTALL-LOC-NO                                   
                  ,:4F-INSTALL-POINT-NO                                 
                  ,:4F-EQUIP-SEQ                                        
                  ,:4F-INSTALL-LOC-CD                                   
                  ,:4F-CODE-UTIL-TYPE                                   
                  ,:4F-IC-NO                                            
                  ,:4F-RATE-PLAN-NO                                     
                  ,:4F-RATE-ITEM-CODE                                   
                  ,:4F-ITEM-SEQ-NO                                      
                  ,:4F-BILLING-FL                                       
                  ,:4F-NO-BILL-REASON-CD                                
                  ,:4F-EQUIP-CONTRACT-FL                                
                  ,:4F-NO-CONTRACT-RSN-CD                               
                  ,:4F-EQUIP-OWNER-CD                                   
                  ,:4F-EQUIP-DRAWING-ID                                 
                  ,:4F-EQUIP-GIS-GKEY                                   
                  ,:4F-SOURCE-APPL-CD                                   
                  ,:4F-SOURCE-APPL-REQ-NO                               
                  ,:4F-WMS-POINT-NO                                     
                  ,IIF(TRY_CONVERT(DATE, :4F-EQUIP-INSTALL-DT
              ) IS NULL OR (PATINDEX('%.%', :4F-EQUIP-INSTALL-DT
              ) <> 0) OR (LEN(:4F-EQUIP-INSTALL-DT
              ) <> 10), CIS.CHAR2DATE(:4F-EQUIP-INSTALL-DT
              ), CONVERT(DATE, :4F-EQUIP-INSTALL-DT) )                         
                  ,:4F-INSTALL-USERID                                   
                  ,:4F-LAST-UPDATE-USERID                               
                  ,:4F-SPCL-AGR-COMMENTS                                
                  ,:4F-EQUIP-COMMENTS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_ENVRNMT                                     
MFA-TR*          (                                                              
MFA-TR*            INSTALL_LOC_NO                                               
MFA-TR*           ,INSTALL_POINT_NO                                             
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,INSTALL_LOC_CD                                               
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,BILLING_FL                                                   
MFA-TR*           ,NO_BILL_REASON_CD                                            
MFA-TR*           ,EQUIP_CONTRACT_FL                                            
MFA-TR*           ,NO_CONTRACT_RSN_CD                                           
MFA-TR*           ,EQUIP_OWNER_CD                                               
MFA-TR*           ,EQUIP_DRAWING_ID                                             
MFA-TR*           ,EQUIP_GIS_GKEY                                               
MFA-TR*           ,SOURCE_APPL_CD                                               
MFA-TR*           ,SOURCE_APPL_REQ_NO                                           
MFA-TR*           ,WMS_POINT_NO                                                 
MFA-TR*           ,EQUIP_INSTALL_DT                                             
MFA-TR*           ,INSTALL_USERID                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,SPCL_AGR_COMMENTS                                            
MFA-TR*           ,EQUIP_COMMENTS                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :4F-INSTALL-LOC-NO                                           
MFA-TR*           ,:4F-INSTALL-POINT-NO                                         
MFA-TR*           ,:4F-EQUIP-SEQ                                                
MFA-TR*           ,:4F-INSTALL-LOC-CD                                           
MFA-TR*           ,:4F-CODE-UTIL-TYPE                                           
MFA-TR*           ,:4F-IC-NO                                                    
MFA-TR*           ,:4F-RATE-PLAN-NO                                             
MFA-TR*           ,:4F-RATE-ITEM-CODE                                           
MFA-TR*           ,:4F-ITEM-SEQ-NO                                              
MFA-TR*           ,:4F-BILLING-FL                                               
MFA-TR*           ,:4F-NO-BILL-REASON-CD                                        
MFA-TR*           ,:4F-EQUIP-CONTRACT-FL                                        
MFA-TR*           ,:4F-NO-CONTRACT-RSN-CD                                       
MFA-TR*           ,:4F-EQUIP-OWNER-CD                                           
MFA-TR*           ,:4F-EQUIP-DRAWING-ID                                         
MFA-TR*           ,:4F-EQUIP-GIS-GKEY                                           
MFA-TR*           ,:4F-SOURCE-APPL-CD                                           
MFA-TR*           ,:4F-SOURCE-APPL-REQ-NO                                       
MFA-TR*           ,:4F-WMS-POINT-NO                                             
MFA-TR*           ,:4F-EQUIP-INSTALL-DT                                         
MFA-TR*           ,:4F-INSTALL-USERID                                           
MFA-TR*           ,:4F-LAST-UPDATE-USERID                                       
MFA-TR*           ,:4F-SPCL-AGR-COMMENTS                                        
MFA-TR*           ,:4F-EQUIP-COMMENTS                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'LMS_EQUIP_ENVRNMT'     TO TABLE-1                  
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-1          
               MOVE 4F-INSTALL-LOC-NO       TO HOSTVAR-ELEMENT-1        
               MOVE 'INSTALL_POINT_NO'      TO TABLE-ELEMENT-2          
               MOVE 4F-INSTALL-POINT-NO     TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-INSERT-FXTR-ATTACHMTS.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_FXTR_ATTACHMTS                            
                 (                                                      
                   FXTR_EQUIP_SEQ                                       
                  ,ATTACH_SEQ_NO                                        
                  ,EQUIP_TYPE_CD                                        
                  ,ATTACH_EQUIP_SEQ                                     
                  ,ATTACH_EQUIP_DT                                      
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :4H-FXTR-EQUIP-SEQ                                   
                  ,:4H-ATTACH-SEQ-NO                                    
                  ,:4H-EQUIP-TYPE-CD                                    
                  ,:4H-ATTACH-EQUIP-SEQ                                 
                  ,IIF(TRY_CONVERT(DATE, :4H-ATTACH-EQUIP-DT
              ) IS NULL OR (PATINDEX('%.%', :4H-ATTACH-EQUIP-DT
              ) <> 0) OR (LEN(:4H-ATTACH-EQUIP-DT
              ) <> 10), CIS.CHAR2DATE(:4H-ATTACH-EQUIP-DT
              ), CONVERT(DATE, :4H-ATTACH-EQUIP-DT) )                          
                  ,:4H-LAST-UPDATE-USERID                               
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_FXTR_ATTACHMTS                                    
MFA-TR*          (                                                              
MFA-TR*            FXTR_EQUIP_SEQ                                               
MFA-TR*           ,ATTACH_SEQ_NO                                                
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,ATTACH_EQUIP_SEQ                                             
MFA-TR*           ,ATTACH_EQUIP_DT                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :4H-FXTR-EQUIP-SEQ                                           
MFA-TR*           ,:4H-ATTACH-SEQ-NO                                            
MFA-TR*           ,:4H-EQUIP-TYPE-CD                                            
MFA-TR*           ,:4H-ATTACH-EQUIP-SEQ                                         
MFA-TR*           ,:4H-ATTACH-EQUIP-DT                                          
MFA-TR*           ,:4H-LAST-UPDATE-USERID                                       
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ'         TO TABLE-ELEMENT-1          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-1        
              MOVE 'ATTACH_SEQ_NO'          TO TABLE-ELEMENT-2          
              MOVE 4H-ATTACH-SEQ-NO         TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-INSERT-EQUIP-CNT.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_CONTRACT                            
                 (                                                      
                   EQUIP_SEQ                                            
                  ,ACCOUNT_NO                                           
                  ,CNTRCT_START_DT                                      
                  ,INSTALL_LOC_NO                                       
                  ,CNTRCT_END_DT                                        
                  ,CNTRCT_DURATION_CD                                   
                  ,FIXTURE_COST_AM                                      
                  ,POLE_COST_AM                                         
                  ,CNTRCT_CLP_NO                                        
                  ,CNTRCT_STATUS_CD                                     
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :4L-EQUIP-SEQ                                        
                  ,:4L-ACCOUNT-NO                                       
                  ,IIF(TRY_CONVERT(DATE, :4L-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-START-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:4L-CNTRCT-START-DT
              ), CONVERT(DATE, :4L-CNTRCT-START-DT) )                          
                  ,:4L-INSTALL-LOC-NO                                   
                  ,IIF(TRY_CONVERT(DATE, :4L-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :4L-CNTRCT-END-DT
              ) <> 0) OR (LEN(:4L-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :4L-CNTRCT-END-DT
              ), CONVERT(DATE, :4L-CNTRCT-END-DT) )                            
                  ,:4L-CNTRCT-DURATION-CD                               
                  ,:4L-FIXTURE-COST-AM                                  
                  ,:4L-POLE-COST-AM                                     
                  ,:4L-CNTRCT-CLP-NO                                    
                  ,:4L-CNTRCT-STATUS-CD                                 
                  ,:4L-LAST-UPDATE-USERID                               
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_CONTRACT                                    
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ                                                    
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,INSTALL_LOC_NO                                               
MFA-TR*           ,CNTRCT_END_DT                                                
MFA-TR*           ,CNTRCT_DURATION_CD                                           
MFA-TR*           ,FIXTURE_COST_AM                                              
MFA-TR*           ,POLE_COST_AM                                                 
MFA-TR*           ,CNTRCT_CLP_NO                                                
MFA-TR*           ,CNTRCT_STATUS_CD                                             
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :4L-EQUIP-SEQ                                                
MFA-TR*           ,:4L-ACCOUNT-NO                                               
MFA-TR*           ,:4L-CNTRCT-START-DT                                          
MFA-TR*           ,:4L-INSTALL-LOC-NO                                           
MFA-TR*           ,:4L-CNTRCT-END-DT                                            
MFA-TR*           ,:4L-CNTRCT-DURATION-CD                                       
MFA-TR*           ,:4L-FIXTURE-COST-AM                                          
MFA-TR*           ,:4L-POLE-COST-AM                                             
MFA-TR*           ,:4L-CNTRCT-CLP-NO                                            
MFA-TR*           ,:4L-CNTRCT-STATUS-CD                                         
MFA-TR*           ,:4L-LAST-UPDATE-USERID                                       
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 4L-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-2          
              MOVE 4L-EQUIP-SEQ             TO HOSTVAR-ELEMENT-2        
              MOVE 'CNTRCT_START_DT'        TO TABLE-ELEMENT-3          
              MOVE 4L-CNTRCT-START-DT       TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-INSERT-EQUIP-INV.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_EQUIP_INVENTRY                            
                 (                                                      
                   EQUIP_SEQ                                            
                  ,EQUIP_TAG_NO                                         
                  ,COMPANY_NO                                           
                  ,CODE_SERVICE_TYPE                                    
                  ,STOCK_CD                                             
                  ,EQUIP_TYPE_CD                                        
                  ,EQUIP_MFR_CD                                         
                  ,EQUIP_MFR_DT                                         
                  ,WARRANTY_EXP_DT                                      
                  ,EQUIP_DISPOSAL_DT                                    
                  ,STORAGE_FAC_CD                                       
                  ,INVENTRY_STATUS_CD                                   
                  ,WRNTY_RECEIVED_FL                                    
                  ,WRNTY_RECOUP_AMT                                     
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :4D-EQUIP-SEQ                                        
                  ,:4D-EQUIP-TAG-NO                                     
                  ,:4D-COMPANY-NO                                       
                  ,:4D-CODE-SERVICE-TYPE                                
                  ,:4D-STOCK-CD                                         
                  ,:4D-EQUIP-TYPE-CD                                    
                  ,:4D-EQUIP-MFR-CD                                     
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-MFR-DT 
                                         :WS-EQUIP-MFR-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-MFR-DT 
                                                   :WS-EQUIP-MFR-DT-IND
              ) <> 0) OR (LEN(:4D-EQUIP-MFR-DT :WS-EQUIP-MFR-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-MFR-DT 
                                                   :WS-EQUIP-MFR-DT-IND
              ), CONVERT(DATE, :4D-EQUIP-MFR-DT :WS-EQUIP-MFR-DT-IND) )        
                  ,IIF(TRY_CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                         :WS-WARRANTY-EXP-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) <> 0) OR (LEN(:4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ), CONVERT(DATE, :4D-WARRANTY-EXP-DT 
                                                :WS-WARRANTY-EXP-DT-IND
              ) )           
                  ,IIF(TRY_CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                         :WS-EQUIP-DISPOSAL-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) <> 0) OR (LEN(:4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) <> 10), CIS.CHAR2DATE(:4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ), CONVERT(DATE, :4D-EQUIP-DISPOSAL-DT 
                                              :WS-EQUIP-DISPOSAL-DT-IND
              ) )       
                  ,:4D-STORAGE-FAC-CD                                   
                  ,:4D-INVENTRY-STATUS-CD                               
                  ,:4D-WRNTY-RECEIVED-FL                                
                  ,:4D-WRNTY-RECOUP-AMT                                 
                  ,:4D-LAST-UPDATE-USERID                               
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO LMS_EQUIP_INVENTRY                                    
MFA-TR*          (                                                              
MFA-TR*            EQUIP_SEQ                                                    
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,STOCK_CD                                                     
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,EQUIP_MFR_CD                                                 
MFA-TR*           ,EQUIP_MFR_DT                                                 
MFA-TR*           ,WARRANTY_EXP_DT                                              
MFA-TR*           ,EQUIP_DISPOSAL_DT                                            
MFA-TR*           ,STORAGE_FAC_CD                                               
MFA-TR*           ,INVENTRY_STATUS_CD                                           
MFA-TR*           ,WRNTY_RECEIVED_FL                                            
MFA-TR*           ,WRNTY_RECOUP_AMT                                             
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :4D-EQUIP-SEQ                                                
MFA-TR*           ,:4D-EQUIP-TAG-NO                                             
MFA-TR*           ,:4D-COMPANY-NO                                               
MFA-TR*           ,:4D-CODE-SERVICE-TYPE                                        
MFA-TR*           ,:4D-STOCK-CD                                                 
MFA-TR*           ,:4D-EQUIP-TYPE-CD                                            
MFA-TR*           ,:4D-EQUIP-MFR-CD                                             
MFA-TR*           ,:4D-EQUIP-MFR-DT:WS-EQUIP-MFR-DT-IND                         
MFA-TR*           ,:4D-WARRANTY-EXP-DT:WS-WARRANTY-EXP-DT-IND                   
MFA-TR*           ,:4D-EQUIP-DISPOSAL-DT:WS-EQUIP-DISPOSAL-DT-IND               
MFA-TR*           ,:4D-STORAGE-FAC-CD                                           
MFA-TR*           ,:4D-INVENTRY-STATUS-CD                                       
MFA-TR*           ,:4D-WRNTY-RECEIVED-FL                                        
MFA-TR*           ,:4D-WRNTY-RECOUP-AMT                                         
MFA-TR*           ,:4D-LAST-UPDATE-USERID                                       
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-UPDATE-CONT-FLAG.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE LMS_EQUIP_ENVRNMT                                  
                 SET EQUIP_CONTRACT_FL  = :4F-EQUIP-CONTRACT-FL         
                    ,NO_CONTRACT_RSN_CD = :4F-NO-CONTRACT-RSN-CD        
                    ,LAST_UPDATE_USERID = :4F-LAST-UPDATE-USERID        
               WHERE INSTALL_LOC_NO     = :PARM-FXTR-INST-LOC-NO        
                 AND INSTALL_POINT_NO   = :PARM-FXTR-INST-POINT-NO      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8700'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE 'LMS_EQUIP_ENVRNMT'     TO TABLE-1                  
               MOVE 'INSTALL_LOC_NO'        TO TABLE-ELEMENT-1          
               MOVE PARM-FXTR-INST-LOC-NO   TO HOSTVAR-ELEMENT-1        
               MOVE 'INSTALL_POINT_NO'      TO TABLE-ELEMENT-1          
               MOVE PARM-FXTR-INST-POINT-NO TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS <= 0                                             
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100                   TO S-APPL-RETURN-CODE          
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                 
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
      *    COMMENTED TO FIX ADD POLE ISSUE.                                     
      *    INITIALIZE GTT-RETURN-FIELDS.                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE               
                                            ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE            THRU 8900-EXIT.            
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       9999-END-PROGRAM.                                                
      *===============================================================*         
                                                                        
           PERFORM 8800-CHECK-RESULTS        THRU 8800-EXIT.            
           PERFORM 8900-SEND-DONE            THRU 8900-EXIT.            
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                       END OF PROGRAM                           *        
      ******************************************************************        
