       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04766.                                          
COB303 DATE-WRITTEN. AUGUST 8, 2014.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS LIGHT MAINTAIN ELECTRIC ORDERS.         *        
      *  RESULTS SETS:                                                 *        
      *     1.  ORDER DATA                                                      
      *     2.  ORDER INSTRUCTIONS                                     *        
      *     3.  REMARKS                                                         
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/08/14    FMB      NEW PROGRAM.                                      
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04766'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04766 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWKCST                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWAASGN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_MTRD_ENVRNMT,MN                                                   
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_PIM_POINT,PP                                                      
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *   CSS_CUST_PHONE     CB                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04766_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04766_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04766_R3'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-ORDER-TYPE-DESC   PIC X(15) VALUE SPACES.           
               10 S-SERV-ORDER-NO-1   PIC S9(13)V COMP-3 VALUE 0.       
               10 S-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.       
               10 S-ACCOUNT-NO-PRIOR  PIC S9(13)V COMP-3 VALUE 0.       
               10 S-WANTED-BY-TMST    PIC X(26) VALUE SPACES.           
               10 S-SERV-ORDER-STATUS PIC X(25) VALUE SPACES.           
               10 S-ORDER-PLACED-BY   PIC X(25) VALUE SPACES.           
               10 S-WORK-AREA-ID      PIC X(12) VALUE SPACES.           
               10 S-ORDER-STATE-CD    PIC X(25) VALUE SPACES.           
               10 S-ADDRESS-LINE1     PIC X(55) VALUE SPACES.           
               10 S-ADDRESS-LINE2     PIC X(41) VALUE SPACES.           
               10 S-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.       
               10 S-CUSTOMER-NO       PIC S9(10)V COMP-3 VALUE 0.       
               10 S-CUST-NAME         PIC X(80) VALUE SPACES.           
               10 S-SUBDIVISION-ID    PIC X(03) VALUE SPACES.           
               10 S-PHONE-NO          PIC X(10) VALUE SPACES.           
               10 S-POINT-ID          PIC X(10) VALUE SPACES.           
               10 S-ZIP-CODE          PIC X(5)  VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-SERV-ORDER-NO-2   PIC S9(13)V COMP-3 VALUE 0.       
               10 S-CODE-UTIL-TYPE    PIC X(01) VALUE SPACES.           
               10 S-WORK-TYPE-CD      PIC X(03) VALUE SPACES.           
               10 S-WORK-TYPE-DESC    PIC X(25) VALUE SPACES.           
               10 S-METER-NO          PIC X(09) VALUE SPACES.           
               10 S-SO-INST-SEQ-NO    PIC S9(9) COMP VALUE 0.           
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-RETURN-CODE-3     PIC S9(9) COMP VALUE 0.           
               10 S-SERV-ORDER-NO-3   PIC S9(13)V COMP-3 VALUE 0.       
               10 S-REMARK-TYPE-CD    PIC X(20) VALUE SPACES.           
               10 S-REMARK-DATETIME   PIC X(26) VALUE SPACES.           
               10 S-CHANGED-BY-USER-ID PIC X(07) VALUE SPACES.          
               10 S-REMARK-TEXT       PIC X(210) VALUE SPACES.          
       01 WS-ADDRESS.                                                   
          05 WS-IN-STRING.                                              
             10 WS-IN-CHAR               PIC X(1) OCCURS 85 TIMES       
                                            INDEXED BY WS-IN-INDX.      
          05 WS-OUT-STRING.                                             
             10 WS-OUT-CHAR               PIC X(1) OCCURS 85 TIMES      
                                            INDEXED BY WS-OUT-INDX.     
          05 WS-LAST-CHAR                PIC X(1)   VALUE SPACES.       
          05 WS-CHAR-LENGTH              PIC S9(03) VALUE ZERO.         
          05 WS-STREET-ADDRESS.                                         
             10 WS-HOUSE-NO              PIC X(15).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-ADDR-PREFIX-1         PIC X(03).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-ADDR-PREFIX-2         PIC X(02).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-NAME-STREET           PIC X(30).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STREET-SUFFIX         PIC X(04).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-ADDRESS-SUFFIX        PIC X(02).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STREET-LOCATION-1     PIC X(04).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STREET-LOCATION-2     PIC X(11).                     
             10 FILLER                   PIC X(04) VALUE SPACES.        
          05 WS-CITY-STATE.                                             
             10 WS-CITY                  PIC X(26).                     
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-STATE                 PIC X(02).                     
             10 WS-ZIP-FILLER            PIC X(02) VALUE ' *'.          
             10 WS-ZIP.                                                 
                15 WS-ZIP-CODE           PIC X(05).                     
                15 WS-ZIP-DASH           PIC X(01) VALUE '-'.           
                15 WS-ZIP-PLUS-4         PIC X(04).                     
                                                                        
                                                                        
       01 WS-NAME-FORMATTING.                                           
          05 WS-LAST-NAME-SUFF.                                         
             10 WS-LAST-NAME             PIC X(40).                     
             10 FILLER                   PIC X(04) VALUE SPACES.        
          05 WS-FIRST-NAME-SUFF.                                        
             10 WS-FIRST-NAME            PIC X(15).                     
             10 FILLER                   PIC X(04) VALUE SPACES.        
          05 WS-MIDDLE-NAME-INI          PIC X(1).                      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04766'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-I        PIC X(80) VALUE SPACES.         
           05  WS-NAME                  PIC X(80) VALUE SPACES.         
           05  T1-WORK-AREA-TABLE       OCCURS 25 INDEXED BY T1-INDEX.  
               10 T1-WORK-AREA-ID       PIC X(12) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE ORDER-CURSOR CURSOR FOR                           
               SELECT VO.SERV_ORDER_NO                                  
                     ,C2.ORDER_TYPE_DESC                                
                     ,VO.ACCOUNT_NO                                     
                     ,VO.ACCOUNT_NO_PRIOR                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME                             
                     ,VO.ORDER_PLACED_BY                                
                     ,VO.WORK_AREA_ID                                   
                     ,VO.ORDER_STATE_CD                                 
                     ,VO.PREMISE_NO                                     
                     ,VO.PHONE_NO                                       
                     ,VO.COMPANY_NO                                     
                     ,R6.STATUS_TX                                      
                     ,PR.ADDRESS_ID                                     
                     ,PR.SUBDIVISION_ID                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                     ,CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED)                   
                     ,CSS_WK_CLASS_STAT R6 WITH(READUNCOMMITTED)                
                     ,CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND VO.WORK_AREA_ID = :VO-WORK-AREA-ID                
                  AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO =  C2.COMPANY_NO                    
                  AND C2.WORK_CLASS_ID = R6.WORK_CLASS_ID               
                  AND VO.SERV_ORDER_STATUS = R6.SERV_ORDER_STATUS       
                  AND VO.PREMISE_NO = PR.PREMISE_NO                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORDER-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT VO.SERV_ORDER_NO                                          
MFA-TR*              ,C2.ORDER_TYPE_DESC                                        
MFA-TR*              ,VO.ACCOUNT_NO                                             
MFA-TR*              ,VO.ACCOUNT_NO_PRIOR                                       
MFA-TR*              ,VO.WANTED_BY_DATETIME                                     
MFA-TR*              ,VO.ORDER_PLACED_BY                                        
MFA-TR*              ,VO.WORK_AREA_ID                                           
MFA-TR*              ,VO.ORDER_STATE_CD                                         
MFA-TR*              ,VO.PREMISE_NO                                             
MFA-TR*              ,VO.PHONE_NO                                               
MFA-TR*              ,VO.COMPANY_NO                                             
MFA-TR*              ,R6.STATUS_TX                                              
MFA-TR*              ,PR.ADDRESS_ID                                             
MFA-TR*              ,PR.SUBDIVISION_ID                                         
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*              ,CSS_ORDER_TYPE C2                                         
MFA-TR*              ,CSS_WK_CLASS_STAT R6                                      
MFA-TR*              ,CSS_PREMISE PR                                            
MFA-TR*         WHERE ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND VO.WORK_AREA_ID = :VO-WORK-AREA-ID                        
MFA-TR*           AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO =  C2.COMPANY_NO                            
MFA-TR*           AND C2.WORK_CLASS_ID = R6.WORK_CLASS_ID                       
MFA-TR*           AND VO.SERV_ORDER_STATUS = R6.SERV_ORDER_STATUS               
MFA-TR*           AND VO.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ***       WHERE VO.ORDER_TYPE_CD = 'FW003'                                
                                                                        
           EXEC SQL                                                     
              DECLARE INST-CURSOR CURSOR FOR                            
               SELECT VI.WORK_TYPE_CD                                   
                     ,VI.CODE_UTIL_TYPE                                 
                     ,VI.METER_NO                                       
                     ,VI.SO_INST_SEQ_NO                                 
                     ,COALESCE(L4.WORK_TYPE_DESC, VI.WORK_TYPE_CD)        
                 FROM CSS_SO_ORDER_INST   VI WITH(READUNCOMMITTED)              
                  LEFT JOIN CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)              
                  ON (L4.WORK_TYPE_CD = VI.WORK_TYPE_CD                 
                     AND L4.COMPANY_NO = :VO-COMPANY-NO)                
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INST-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT VI.WORK_TYPE_CD                                           
MFA-TR*              ,VI.CODE_UTIL_TYPE                                         
MFA-TR*              ,VI.METER_NO                                               
MFA-TR*              ,VI.SO_INST_SEQ_NO                                         
MFA-TR*              ,IFNULL(L4.WORK_TYPE_DESC, VI.WORK_TYPE_CD)                
MFA-TR*          FROM CSS_SO_ORDER_INST   VI                                    
MFA-TR*           LEFT JOIN CSS_WORK_TYPE L4                                    
MFA-TR*           ON (L4.WORK_TYPE_CD = VI.WORK_TYPE_CD                         
MFA-TR*              AND L4.COMPANY_NO = :VO-COMPANY-NO)                        
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE REMARKS-CURSOR CURSOR FOR                         
               SELECT REMARK_TX,                                        
                      REMARK_TYPE_CD,                                   
                      REPLACE(REPLACE(CONVERT(CHAR(26), REMARK_DATETIME
           , 121), ' ', '-'), ':', '.') REMARK_DATETIME,                       
                      CHANGED_BY_USER_ID                                
                 FROM CSS_SO_REMARKS EF WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                  AND REMARK_TYPE_CD IN ('G','H','C','O','P')           
                AND REMARK_DATETIME =                                   
                   (SELECT MAX(REMARK_DATETIME)                         
                      FROM CSS_SO_REMARKS WITH(READUNCOMMITTED)                 
                     WHERE SERV_ORDER_NO = EF.SERV_ORDER_NO             
                       AND REMARK_TYPE_CD = EF.REMARK_TYPE_CD)          
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REMARKS-CURSOR CURSOR FOR                                 
MFA-TR*        SELECT REMARK_TX,                                                
MFA-TR*               REMARK_TYPE_CD,                                           
MFA-TR*               REMARK_DATETIME,                                          
MFA-TR*               CHANGED_BY_USER_ID                                        
MFA-TR*          FROM CSS_SO_REMARKS EF                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           AND REMARK_TYPE_CD IN ('G','H','C','O','P')                   
MFA-TR*         AND REMARK_DATETIME =                                           
MFA-TR*            (SELECT MAX(REMARK_DATETIME)                                 
MFA-TR*               FROM CSS_SO_REMARKS                                       
MFA-TR*              WHERE SERV_ORDER_NO = EF.SERV_ORDER_NO                     
MFA-TR*                AND REMARK_TYPE_CD = EF.REMARK_TYPE_CD)                  
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE WORK-AREA-CURSOR CURSOR FOR                       
               SELECT DISTINCT WORK_AREA_ID                             
                 FROM CSS_WA_EMP_ASSGN WITH(READUNCOMMITTED)                    
                WHERE EMPLOYEE_ID = :AD-EMPLOYEE-ID                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WORK-AREA-CURSOR CURSOR FOR                               
MFA-TR*        SELECT DISTINCT WORK_AREA_ID                                     
MFA-TR*          FROM CSS_WA_EMP_ASSGN                                          
MFA-TR*         WHERE EMPLOYEE_ID = :AD-EMPLOYEE-ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE               
                     ,:S-STATUS-CODE       AS STATUS_CD                 
                     ,:S-ORDER-TYPE-DESC   AS ORDER_TYPE_DESC           
                     ,:S-SERV-ORDER-NO-1   AS SERV_ORDER_NO             
                     ,:S-ACCOUNT-NO        AS ACCOUNT_NO                
                     ,:S-ACCOUNT-NO-PRIOR  AS ACCOUNT_NO_PRIOR          
                     ,:S-WANTED-BY-TMST    AS WANTED_BY_DATETIME        
                     ,:S-SERV-ORDER-STATUS AS SERV_ORDER_STATUS         
                     ,:S-ORDER-PLACED-BY   AS ORDER_PLACED_BY           
                     ,:S-WORK-AREA-ID      AS WORK_AREA_ID              
                     ,:S-ORDER-STATE-CD    AS ORDER_STATE_CD            
                     ,:S-ADDRESS-LINE1     AS ADDRESS_LINE1             
                     ,:S-ADDRESS-LINE2     AS ADDRESS_LINE2             
                     ,:S-PREMISE-NO        AS PREMISE_NO                
                     ,:S-CUSTOMER-NO       AS CUSTOMER_NO               
                     ,:S-CUST-NAME         AS CUST_NAME                 
                     ,:S-SUBDIVISION-ID    AS SUBDIVISION_ID            
                     ,:S-PHONE-NO          AS PHONE_NO                  
                     ,:S-POINT-ID          AS POINT_ID                  
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE                       
MFA-TR*              ,:S-STATUS-CODE       AS STATUS_CD                         
MFA-TR*              ,:S-ORDER-TYPE-DESC   AS ORDER_TYPE_DESC                   
MFA-TR*              ,:S-SERV-ORDER-NO-1   AS SERV_ORDER_NO                     
MFA-TR*              ,:S-ACCOUNT-NO        AS ACCOUNT_NO                        
MFA-TR*              ,:S-ACCOUNT-NO-PRIOR  AS ACCOUNT_NO_PRIOR                  
MFA-TR*              ,:S-WANTED-BY-TMST    AS WANTED_BY_DATETIME                
MFA-TR*              ,:S-SERV-ORDER-STATUS AS SERV_ORDER_STATUS                 
MFA-TR*              ,:S-ORDER-PLACED-BY   AS ORDER_PLACED_BY                   
MFA-TR*              ,:S-WORK-AREA-ID      AS WORK_AREA_ID                      
MFA-TR*              ,:S-ORDER-STATE-CD    AS ORDER_STATE_CD                    
MFA-TR*              ,:S-ADDRESS-LINE1     AS ADDRESS_LINE1                     
MFA-TR*              ,:S-ADDRESS-LINE2     AS ADDRESS_LINE2                     
MFA-TR*              ,:S-PREMISE-NO        AS PREMISE_NO                        
MFA-TR*              ,:S-CUSTOMER-NO       AS CUSTOMER_NO                       
MFA-TR*              ,:S-CUST-NAME         AS CUST_NAME                         
MFA-TR*              ,:S-SUBDIVISION-ID    AS SUBDIVISION_ID                    
MFA-TR*              ,:S-PHONE-NO          AS PHONE_NO                          
MFA-TR*              ,:S-POINT-ID          AS POINT_ID                          
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE               
                     ,:S-SERV-ORDER-NO-2   AS SERV_ORDER_NO             
                     ,:S-METER-NO          AS METER_NO                  
                     ,:S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE            
                     ,:S-WORK-TYPE-CD      AS WORK_TYPE_CD              
                     ,:S-WORK-TYPE-DESC    AS WORK_TYPE_DESC            
                     ,:S-SO-INST-SEQ-NO    AS SO_INST_SEQ_NO            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE                       
MFA-TR*              ,:S-SERV-ORDER-NO-2   AS SERV_ORDER_NO                     
MFA-TR*              ,:S-METER-NO          AS METER_NO                          
MFA-TR*              ,:S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE                    
MFA-TR*              ,:S-WORK-TYPE-CD      AS WORK_TYPE_CD                      
MFA-TR*              ,:S-WORK-TYPE-DESC    AS WORK_TYPE_DESC                    
MFA-TR*              ,:S-SO-INST-SEQ-NO    AS SO_INST_SEQ_NO                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE               
                     ,:S-SERV-ORDER-NO-3   AS SERV_ORDER_NO             
                     ,:S-REMARK-TYPE-CD    AS REMARK_TYPE               
                     ,:S-REMARK-DATETIME   AS REMARK_DATETIME           
                     ,:S-CHANGED-BY-USER-ID AS CHANGED_BY_USER_ID       
                     ,:S-REMARK-TEXT       AS REMARK_TEXT               
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE                       
MFA-TR*              ,:S-SERV-ORDER-NO-3   AS SERV_ORDER_NO                     
MFA-TR*              ,:S-REMARK-TYPE-CD    AS REMARK_TYPE                       
MFA-TR*              ,:S-REMARK-DATETIME   AS REMARK_DATETIME                   
MFA-TR*              ,:S-CHANGED-BY-USER-ID AS CHANGED_BY_USER_ID               
MFA-TR*              ,:S-REMARK-TEXT       AS REMARK_TEXT                       
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-USERID             PIC X(07).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-USERID.                                  
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T1-INDEX > 25 OR 
               T1-WORK-AREA-ID (T1-INDEX) = SPACES                              
                   MOVE T1-WORK-AREA-ID (T1-INDEX) TO VO-WORK-AREA-ID   
                   PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT           
           END-PERFORM.                                                 
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N'                      TO WS-GTT01-DECLARED           
                                            WS-GTT02-DECLARED           
                                            WS-GTT03-DECLARED.          
           PERFORM 0101-DECLARE-GTT01      THRU 0101-EXIT.              
           PERFORM 0102-DECLARE-GTT02      THRU 0102-EXIT.              
           PERFORM 0103-DECLARE-GTT03      THRU 0103-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04766_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04766_R1
              (                                                          
               RETURN_CODE          INT                             
              ,STATUS_CODE          INT                             
              ,ORDER_TYPE_DESC CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,SERV_ORDER_NO        DECIMAL(13,0)                       
              ,ACCOUNT_NO           DECIMAL(13,0)                       
              ,ACCOUNT_NO_PRIOR     DECIMAL(13,0)                       
              ,WANTED_BY_DATETIME CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,SERV_ORDER_STATUS CHAR(25)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,ORDER_PLACED_BY CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,WORK_AREA_ID CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,ORDER_STATE_CD CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,ADDRESS_LINE1 CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,ADDRESS_LINE2 CHAR(41)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,PREMISE_NO           DECIMAL(10,0)                       
              ,CUSTOMER_NO          DECIMAL(10,0)                       
              ,CUST_NAME CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,SUBDIVISION_ID CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '0101'               TO ACTIVE-PARAGRAPH          
                 MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04766_R1'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT RETURN_CODE                                        
                    ,STATUS_CODE                                        
                    ,ORDER_TYPE_DESC                                    
                    ,SERV_ORDER_NO                                      
                    ,ACCOUNT_NO                                         
                    ,ACCOUNT_NO_PRIOR                                   
                    ,WANTED_BY_DATETIME                                 
                    ,SERV_ORDER_STATUS                                  
                    ,ORDER_PLACED_BY                                    
                    ,WORK_AREA_ID                                       
                    ,ORDER_STATE_CD                                     
                    ,ADDRESS_LINE1                                      
                    ,ADDRESS_LINE2                                      
                    ,PREMISE_NO                                         
                    ,CUSTOMER_NO                                        
                    ,CUST_NAME                                          
                    ,SUBDIVISION_ID                                     
                    ,PHONE_NO                                           
                    ,POINT_ID                                           
              FROM #CSR04766_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT RETURN_CODE                                                
MFA-TR*             ,STATUS_CODE                                                
MFA-TR*             ,ORDER_TYPE_DESC                                            
MFA-TR*             ,SERV_ORDER_NO                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,ACCOUNT_NO_PRIOR                                           
MFA-TR*             ,WANTED_BY_DATETIME                                         
MFA-TR*             ,SERV_ORDER_STATUS                                          
MFA-TR*             ,ORDER_PLACED_BY                                            
MFA-TR*             ,WORK_AREA_ID                                               
MFA-TR*             ,ORDER_STATE_CD                                             
MFA-TR*             ,ADDRESS_LINE1                                              
MFA-TR*             ,ADDRESS_LINE2                                              
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,CUST_NAME                                                  
MFA-TR*             ,SUBDIVISION_ID                                             
MFA-TR*             ,PHONE_NO                                                   
MFA-TR*             ,POINT_ID                                                   
MFA-TR*       FROM SESSION.CSR04766_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04766_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04766_R2
              (                                                          
               RETURN_CODE          INT                             
              ,SERV_ORDER_NO        DECIMAL(13,0)                       
              ,CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,WORK_TYPE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,SO_INST_SEQ_NO       INT                             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '0102'               TO ACTIVE-PARAGRAPH          
                 MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04766_R2'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE                                       
                     ,SERV_ORDER_NO                                     
                     ,METER_NO                                          
                     ,CODE_UTIL_TYPE                                    
                     ,WORK_TYPE_CD                                      
                     ,WORK_TYPE_DESC                                    
                     ,SO_INST_SEQ_NO                                    
                FROM #CSR04766_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,SERV_ORDER_NO                                             
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,WORK_TYPE_CD                                              
MFA-TR*              ,WORK_TYPE_DESC                                            
MFA-TR*              ,SO_INST_SEQ_NO                                            
MFA-TR*         FROM SESSION.CSR04766_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04766_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04766_R3
              (                                                          
               RETURN_CODE          INT                             
              ,SERV_ORDER_NO        DECIMAL(13,0)                       
              ,REMARK_TYPE CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,REMARK_DATETIME CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,CHANGED_BY_USER_ID CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,REMARK_TEXT CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '0103'               TO ACTIVE-PARAGRAPH          
                 MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04766_R3'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE                                       
                     ,SERV_ORDER_NO                                     
                     ,REMARK_TYPE                                       
                     ,REMARK_DATETIME                                   
                     ,CHANGED_BY_USER_ID                                
                     ,REMARK_TEXT                                       
                FROM #CSR04766_R3                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,SERV_ORDER_NO                                             
MFA-TR*              ,REMARK_TYPE                                               
MFA-TR*              ,REMARK_DATETIME                                           
MFA-TR*              ,CHANGED_BY_USER_ID                                        
MFA-TR*              ,REMARK_TEXT                                               
MFA-TR*         FROM SESSION.CSR04766_R3                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE LINK-USERID(3:5) TO AD-EMPLOYEE-ID.                     
           SET T1-INDEX TO +1.                                          
           PERFORM 7090-OPEN-WORK-AREA-CURSOR THRU 7090-EXIT.           
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT                       
           PERFORM 7110-CLOSE-WORK-AREA-CURSOR THRU 7110-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH WORK-AREA-CURSOR                                   
                INTO :AD-WORK-AREA-ID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '1100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_WA_EMP_ASSGN'  TO TABLE-1                  
                   MOVE 'EMPLOYEE_ID'    TO TABLE-ELEMENT-1             
                   MOVE AD-EMPLOYEE-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE AD-WORK-AREA-ID TO T1-WORK-AREA-ID (T1-INDEX).          
           SET T1-INDEX UP BY +1.                                       
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-OPEN-ORDER-CURSOR THRU 7000-EXIT.               
           PERFORM 7010-FETCH-ROWS THRU 7010-EXIT                       
           PERFORM 2100-PROCESS-EACH-ORDER THRU 2100-EXIT               
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7020-CLOSE-ORDER-CURSOR THRU 7020-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-PROCESS-EACH-ORDER.                                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE VO-SERV-ORDER-NO         TO S-SERV-ORDER-NO-1.          
           MOVE C2-ORDER-TYPE-DESC       TO S-ORDER-TYPE-DESC.          
           MOVE VO-ACCOUNT-NO            TO S-ACCOUNT-NO.               
           MOVE VO-ACCOUNT-NO-PRIOR      TO S-ACCOUNT-NO-PRIOR.         
           MOVE VO-WANTED-BY-DATETIME    TO S-WANTED-BY-TMST.           
           MOVE R6-STATUS-TX             TO S-SERV-ORDER-STATUS.        
           MOVE VO-ORDER-PLACED-BY       TO S-ORDER-PLACED-BY.          
           MOVE VO-WORK-AREA-ID          TO S-WORK-AREA-ID.             
           EVALUATE VO-ORDER-STATE-CD                                   
               WHEN 'A'                                                 
                   MOVE 'ACTIVE'         TO S-ORDER-STATE-CD            
               WHEN 'H'                                                 
                   MOVE 'HOLD'           TO S-ORDER-STATE-CD            
               WHEN 'R'                                                 
                   MOVE 'PAYMENT REQUIRED'    TO S-ORDER-STATE-CD       
               WHEN 'D'                                                 
                   MOVE 'TURNED DOWN CUSTOMER' TO S-ORDER-STATE-CD      
               WHEN 'B'                                                 
                   MOVE 'TURNED DOWN COMPANY' TO S-ORDER-STATE-CD       
               WHEN OTHER                                               
                  MOVE VO-ORDER-STATE-CD TO S-ORDER-STATE-CD            
           END-EVALUATE.                                                
           IF PR-ADDRESS-ID > 0                                         
              PERFORM 7300-SELECT-ADDR-FORMATTED THRU 7300-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 3200-FORMAT-ADDRESS  THRU 3200-EXIT            
              ELSE                                                      
                 MOVE SPACES                  TO S-ADDRESS-LINE1        
                                                 S-ADDRESS-LINE2        
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                     TO S-ADDRESS-LINE1        
                                                 S-ADDRESS-LINE2        
           END-IF                                                       
           MOVE VO-PREMISE-NO            TO S-PREMISE-NO                
           MOVE PR-SUBDIVISION-ID        TO S-SUBDIVISION-ID            
           MOVE SPACES                   TO S-POINT-ID                  
           IF VO-ACCOUNT-NO-PRIOR > 0                                   
               MOVE VO-ACCOUNT-NO-PRIOR TO AT-ACCOUNT-NO                
                                           MN-ACCOUNT-NO                
              PERFORM 3100-GET-CUSTOMER-NAME THRU 3100-EXIT             
              PERFORM 7400-SELECT-POINT-ID   THRU 7400-EXIT             
                 STRING PP-AREA-ID         DELIMITED BY SIZE            
                        PP-TAG-NM          DELIMITED BY SIZE            
                   INTO S-POINT-ID                                      
           ELSE                                                         
              MOVE SPACES                     TO S-CUST-NAME            
                                                 S-PHONE-NO             
              MOVE ZEROS                      TO S-CUSTOMER-NO          
           END-IF                                                       
           IF VO-PHONE-NO > SPACES                                      
              MOVE VO-PHONE-NO                TO S-PHONE-NO             
           END-IF                                                       
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           PERFORM 7030-OPEN-INST-CURSOR THRU 7030-EXIT.                
           PERFORM 7040-FETCH-INST-CURSOR THRU 7040-EXIT.               
           PERFORM 2200-PROCESS-INST THRU 2200-EXIT                     
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
           PERFORM 7050-CLOSE-INST-CURSOR THRU 7050-EXIT.               
                                                                        
           PERFORM 7060-OPEN-REMARKS-CURSOR THRU 7060-EXIT.             
           INITIALIZE                   EF-REMARK-TX.                   
           PERFORM 7070-FETCH-REMARKS-CURSOR THRU 7070-EXIT.            
           PERFORM 2300-PROCESS-REMARKS     THRU 2300-EXIT              
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
           PERFORM 7080-CLOSE-REMARKS-CURSOR THRU 7080-EXIT.            
                                                                        
           PERFORM 7010-FETCH-ROWS THRU 7010-EXIT.                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-PROCESS-INST.                                               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE VO-SERV-ORDER-NO TO S-SERV-ORDER-NO-2.                  
           MOVE VI-WORK-TYPE-CD TO S-WORK-TYPE-CD.                      
           MOVE L4-WORK-TYPE-DESC TO S-WORK-TYPE-DESC.                  
           MOVE VI-CODE-UTIL-TYPE TO S-CODE-UTIL-TYPE.                  
           MOVE VI-METER-NO       TO S-METER-NO                         
           MOVE VI-SO-INST-SEQ-NO TO S-SO-INST-SEQ-NO                   
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
           PERFORM 7040-FETCH-INST-CURSOR THRU 7040-EXIT.               
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2300-PROCESS-REMARKS.                                            
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           MOVE VO-SERV-ORDER-NO TO S-SERV-ORDER-NO-3.                  
           MOVE EF-REMARK-TX-TEXT TO S-REMARK-TEXT.                     
           INSPECT S-REMARK-TEXT   REPLACING ALL LOW-VALUES BY SPACES.  
           EVALUATE TRUE                                                
              WHEN EF-REMARK-TYPE-CD = 'G'                              
                 MOVE 'SERVICE ORDER'    TO S-REMARK-TYPE-CD            
              WHEN EF-REMARK-TYPE-CD = 'H'                              
                 MOVE 'HOLD'             TO S-REMARK-TYPE-CD            
              WHEN EF-REMARK-TYPE-CD = 'C'                              
                 MOVE 'CANCELED'         TO S-REMARK-TYPE-CD            
              WHEN EF-REMARK-TYPE-CD = 'O'                              
                 MOVE 'OVERRIDE'         TO S-REMARK-TYPE-CD            
              WHEN EF-REMARK-TYPE-CD = 'P'                              
                 MOVE 'SUSPEND'          TO S-REMARK-TYPE-CD            
              WHEN OTHER                                                
                MOVE EF-REMARK-TYPE-CD   TO S-REMARK-TYPE-CD            
           END-EVALUATE.                                                
           MOVE EF-REMARK-DATETIME TO S-REMARK-DATETIME.                
           MOVE EF-CHANGED-BY-USER-ID TO S-CHANGED-BY-USER-ID           
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
           INITIALIZE                   EF-REMARK-TX.                   
           PERFORM 7070-FETCH-REMARKS-CURSOR THRU 7070-EXIT.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       3100-GET-CUSTOMER-NAME.                                          
      *================================================================*        
                                                                        
           PERFORM 7200-SELECT-NAME-PHONE THRU 7200-EXIT                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CU-CUSTOMER-NO        TO S-CUSTOMER-NO               
              IF DQ-NAME-FORMAT = 'I'                                   
                 MOVE CB-PHONE-NO             TO S-PHONE-NO             
                 MOVE DQ-LAST-NAME            TO WS-LAST-NAME           
                 MOVE DQ-FIRST-NAME           TO WS-FIRST-NAME          
                 MOVE DQ-MIDDLE-NAME (1:1)    TO WS-MIDDLE-NAME-INI     
                 MOVE SPACES                  TO S-CUST-NAME            
                                                                        
                 STRING WS-LAST-NAME-SUFF  DELIMITED BY '    '          
                        ', '               DELIMITED BY SIZE            
                        WS-FIRST-NAME-SUFF DELIMITED BY '    '          
                        ' '                DELIMITED BY SIZE            
                        WS-MIDDLE-NAME-INI DELIMITED BY SIZE            
                   INTO S-CUST-NAME                                     
                                                                        
              ELSE                                                      
                 MOVE DQ-FULL-NAME            TO S-CUST-NAME            
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                     TO S-CUST-NAME            
                                                 S-PHONE-NO             
              MOVE ZEROS                      TO S-CUSTOMER-NO          
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       3200-FORMAT-ADDRESS.                                             
      *================================================================*        
                                                                        
           MOVE SPACES                        TO WS-IN-STRING           
                                                 WS-OUT-STRING          
           MOVE DY-HOUSE-NO                   TO WS-HOUSE-NO            
           MOVE DY-ADDR-PREFIX-1              TO WS-ADDR-PREFIX-1       
           MOVE DY-ADDR-PREFIX-2              TO WS-ADDR-PREFIX-2       
           MOVE DY-STREET-NAME                TO WS-NAME-STREET         
           MOVE DY-STREET-SUFFIX              TO WS-STREET-SUFFIX       
           MOVE DY-STREET-LOCATION-1          TO WS-STREET-LOCATION-1   
           MOVE DY-STREET-LOCATION-2          TO WS-STREET-LOCATION-2   
           MOVE DY-ADDR-SUFFIX                TO WS-ADDRESS-SUFFIX      
           MOVE WS-STREET-ADDRESS             TO WS-IN-STRING           
           MOVE 82                            TO WS-CHAR-LENGTH         
           PERFORM 3210-REDUCE-EMBED-SPACES THRU 3210-EXIT              
           MOVE WS-OUT-STRING                 TO S-ADDRESS-LINE1        
                                                                        
      *** FORMAT ADDRESS LINE 2                                         00055700
           MOVE SPACES                        TO WS-IN-STRING           
                                                 WS-OUT-STRING          
           MOVE DY-ZIP-CODE                   TO A4-ZIP-CODE            
                                                 WS-ZIP-CODE            
                                                 S-ZIP-CODE             
           MOVE DY-ZIP-CODE-TOKEN             TO A4-ZIP-CODE-TOKEN      
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
              MOVE '-'                        TO WS-ZIP-DASH            
              MOVE DY-ZIP-CODE-PLUS-FOUR      TO WS-ZIP-PLUS-4          
           END-IF.                                                      
           MOVE ' *'                          TO WS-ZIP-FILLER          
                                                                        
           PERFORM 7500-SELECT-ZIP-CODE       THRU 7500-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                     TO WS-STATE               
              MOVE 'UNKNOWN *'                TO WS-CITY                
           ELSE                                                         
              MOVE A4-STATE                   TO WS-STATE               
              MOVE A4-TOWN                    TO WS-CITY                
           END-IF.                                                      
                                                                        
           MOVE WS-CITY-STATE                 TO WS-IN-STRING           
           MOVE 41                            TO WS-CHAR-LENGTH         
           PERFORM 3210-REDUCE-EMBED-SPACES THRU 3210-EXIT              
           MOVE WS-OUT-STRING                 TO S-ADDRESS-LINE2        
                                                                        
           INSPECT S-ADDRESS-LINE2    REPLACING ALL '*' BY SPACES.      
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       3210-REDUCE-EMBED-SPACES.                                        
      *================================================================*        
                                                                        
           SET WS-OUT-INDX                    TO 1                      
           MOVE SPACES                        TO WS-LAST-CHAR           
                                                                        
           PERFORM VARYING WS-IN-INDX FROM 1 BY 1                       
                                UNTIL WS-IN-INDX > WS-CHAR-LENGTH       
              EVALUATE TRUE                                             
                 WHEN WS-IN-CHAR (WS-IN-INDX) = LOW-VALUES              
                      CONTINUE                                          
                 WHEN WS-IN-CHAR (WS-IN-INDX) = SPACES                  
                      AND WS-LAST-CHAR = SPACES                         
                      CONTINUE                                          
                 WHEN OTHER                                             
                      MOVE WS-IN-CHAR (WS-IN-INDX) TO WS-LAST-CHAR      
                           WS-OUT-CHAR (WS-OUT-INDX)                    
                      SET WS-OUT-INDX UP BY 1                           
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
      *                                                                         
       3210-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *                                                                *        
                                                                        
       7000-OPEN-ORDER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN ORDER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'ORDER_TYPE_CD'  TO TABLE-ELEMENT-1             
                   MOVE 'FW003'          TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ORDER-CURSOR                                       
                INTO :VO-SERV-ORDER-NO                                  
                    ,:C2-ORDER-TYPE-DESC                                
                    ,:VO-ACCOUNT-NO                                     
                    ,:VO-ACCOUNT-NO-PRIOR                               
                    ,:VO-WANTED-BY-DATETIME :WS-NULL-1                 
                    ,:VO-ORDER-PLACED-BY                                
                    ,:VO-WORK-AREA-ID                                   
                    ,:VO-ORDER-STATE-CD                                 
                    ,:VO-PREMISE-NO                                     
                    ,:VO-PHONE-NO                                       
                    ,:VO-COMPANY-NO                                     
                    ,:R6-STATUS-TX                                      
                    ,:PR-ADDRESS-ID                                     
                    ,:PR-SUBDIVISION-ID                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO VO-WANTED-BY-DATETIME             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'ORDER_TYPE_CD'  TO TABLE-ELEMENT-1             
                   MOVE 'FW003'          TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7020-CLOSE-ORDER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE ORDER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'ORDER_TYPE_CD'  TO TABLE-ELEMENT-1             
                   MOVE 'FW003'          TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-OPEN-INST-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN INST-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-FETCH-INST-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH INST-CURSOR                                        
                INTO :VI-WORK-TYPE-CD                                   
                    ,:VI-CODE-UTIL-TYPE                                 
                    ,:VI-METER-NO                                       
                    ,:VI-SO-INST-SEQ-NO                                 
                    ,:L4-WORK-TYPE-DESC                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_ORDER_ISST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-CLOSE-INST-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE INST-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-OPEN-REMARKS-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN REMARKS-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_REMARKS' TO TABLE-1                     
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-FETCH-REMARKS-CURSOR.                                       
                                                                        
                                                                        
           EXEC SQL                                                     
               FETCH REMARKS-CURSOR                                     
                INTO :EF-REMARK-TX                                      
                    ,:EF-REMARK-TYPE-CD                                 
                    ,:EF-REMARK-DATETIME                                
                    ,:EF-CHANGED-BY-USER-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_REMARKS' TO TABLE-1                     
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-CLOSE-REMARKS-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE REMARKS-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7080'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_REMARKS' TO TABLE-1                     
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-OPEN-WORK-AREA-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               OPEN WORK-AREA-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_WA_EMP_ASSGN' TO TABLE-1                   
                   MOVE 'EMPLOYEE_ID'    TO TABLE-ELEMENT-1             
                   MOVE AD-EMPLOYEE-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-CLOSE-WORK-AREA-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE WORK-AREA-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_WA_EMP_ASSGN' TO TABLE-1                   
                   MOVE 'EMPLOYEE_ID'    TO TABLE-ELEMENT-1             
                   MOVE AD-EMPLOYEE-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *================================================================*        
       7200-SELECT-NAME-PHONE.                                          
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT CU.CUSTOMER_NO                                      
                   ,COALESCE(DQ.NAME_FORMAT, ' ')                         
                   ,COALESCE(DQ.FIRST_NAME, ' ')                          
                   ,COALESCE(DQ.LAST_NAME, ' ')                           
                   ,COALESCE(DQ.MIDDLE_NAME, ' ')                         
                   ,COALESCE(DQ.FULL_NAME, ' ')                           
                   ,COALESCE(CB.PHONE_NO, ' ')                            
               INTO :CU-CUSTOMER-NO                                     
                   ,:DQ-NAME-FORMAT                                     
                   ,:DQ-FIRST-NAME                                      
                   ,:DQ-LAST-NAME                                       
                   ,:DQ-MIDDLE-NAME                                     
                   ,:DQ-FULL-NAME                                       
                   ,:CB-PHONE-NO                                        
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
               JOIN CSS_CUSTOMER CU WITH(READUNCOMMITTED)                       
                 ON (CU.CUSTOMER_NO = AT.CUSTOMER_NO )                  
               LEFT JOIN CSS_NAME     DQ WITH(READUNCOMMITTED)                  
                 ON (CU.NAME_ID = DQ.NAME_ID                            
                     AND DQ.NAME_FORMAT IN ('I','B')                    
                     AND DQ.NAME_TYPE = 'CN')                           
               LEFT JOIN CSS_CUST_PHONE CB WITH(READUNCOMMITTED)                
                 ON (CU.CUSTOMER_NO = CB.CUSTOMER_NO                    
                     AND CB.PHONE_TYPE = 'H1'                           
                     AND CB.CUSTOMER_TYPE = 'C')                        
              WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CU.CUSTOMER_NO                                              
MFA-TR*            ,IFNULL(DQ.NAME_FORMAT, ' ')                                 
MFA-TR*            ,IFNULL(DQ.FIRST_NAME, ' ')                                  
MFA-TR*            ,IFNULL(DQ.LAST_NAME, ' ')                                   
MFA-TR*            ,IFNULL(DQ.MIDDLE_NAME, ' ')                                 
MFA-TR*            ,IFNULL(DQ.FULL_NAME, ' ')                                   
MFA-TR*            ,IFNULL(CB.PHONE_NO, ' ')                                    
MFA-TR*        INTO :CU-CUSTOMER-NO                                             
MFA-TR*            ,:DQ-NAME-FORMAT                                             
MFA-TR*            ,:DQ-FIRST-NAME                                              
MFA-TR*            ,:DQ-LAST-NAME                                               
MFA-TR*            ,:DQ-MIDDLE-NAME                                             
MFA-TR*            ,:DQ-FULL-NAME                                               
MFA-TR*            ,:CB-PHONE-NO                                                
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*        JOIN CSS_CUSTOMER CU                                             
MFA-TR*          ON (CU.CUSTOMER_NO = AT.CUSTOMER_NO )                          
MFA-TR*        LEFT JOIN CSS_NAME     DQ                                        
MFA-TR*          ON (CU.NAME_ID = DQ.NAME_ID                                    
MFA-TR*              AND DQ.NAME_FORMAT IN ('I','B')                            
MFA-TR*              AND DQ.NAME_TYPE = 'CN')                                   
MFA-TR*        LEFT JOIN CSS_CUST_PHONE CB                                      
MFA-TR*          ON (CU.CUSTOMER_NO = CB.CUSTOMER_NO                            
MFA-TR*              AND CB.PHONE_TYPE = 'H1'                                   
MFA-TR*              AND CB.CUSTOMER_TYPE = 'C')                                
MFA-TR*       WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7200                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
       7300-SELECT-ADDR-FORMATTED.                                      
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT                                                     
                   HOUSE_NO                                             
                  ,ADDR_PREFIX_1                                        
                  ,ADDR_PREFIX_2                                        
                  ,STREET_NAME                                          
                  ,STREET_LOCATION_1                                    
                  ,STREET_LOCATION_2                                    
                  ,STREET_SUFFIX                                        
                  ,ADDRESS_OVERFLOW                                     
                  ,CARRIER_ROUTE                                        
                  ,ZIP_CODE                                             
                  ,ZIP_CODE_PLUS_FOUR                                   
                  ,ZIP_CODE_TOKEN                                       
                  ,ADDR_SUFFIX                                          
              INTO :DY-HOUSE-NO                                         
                  ,:DY-ADDR-PREFIX-1                                    
                  ,:DY-ADDR-PREFIX-2                                    
                  ,:DY-STREET-NAME                                      
                  ,:DY-STREET-LOCATION-1                                
                  ,:DY-STREET-LOCATION-2                                
                  ,:DY-STREET-SUFFIX                                    
                  ,:DY-ADDRESS-OVERFLOW                                 
                  ,:DY-CARRIER-ROUTE                                    
                  ,:DY-ZIP-CODE                                         
                  ,:DY-ZIP-CODE-PLUS-FOUR                               
                  ,:DY-ZIP-CODE-TOKEN                                   
                  ,:DY-ADDR-SUFFIX                                      
              FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                     
             WHERE ADDRESS_ID = :PR-ADDRESS-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                     00078400
MFA-TR*            HOUSE_NO                                                 0007
MFA-TR*           ,ADDR_PREFIX_1                                            0007
MFA-TR*           ,ADDR_PREFIX_2                                            0007
MFA-TR*           ,STREET_NAME                                              0007
MFA-TR*           ,STREET_LOCATION_1                                        0007
MFA-TR*           ,STREET_LOCATION_2                                        0007
MFA-TR*           ,STREET_SUFFIX                                            0007
MFA-TR*           ,ADDRESS_OVERFLOW                                         0007
MFA-TR*           ,CARRIER_ROUTE                                            0007
MFA-TR*           ,ZIP_CODE                                                 0007
MFA-TR*           ,ZIP_CODE_PLUS_FOUR                                       0007
MFA-TR*           ,ZIP_CODE_TOKEN                                           0007
MFA-TR*           ,ADDR_SUFFIX                                              0007
MFA-TR*       INTO :DY-HOUSE-NO                                         00079800
MFA-TR*           ,:DY-ADDR-PREFIX-1                                    00079900
MFA-TR*           ,:DY-ADDR-PREFIX-2                                    00080000
MFA-TR*           ,:DY-STREET-NAME                                      00080100
MFA-TR*           ,:DY-STREET-LOCATION-1                                00080200
MFA-TR*           ,:DY-STREET-LOCATION-2                                00080300
MFA-TR*           ,:DY-STREET-SUFFIX                                    00080400
MFA-TR*           ,:DY-ADDRESS-OVERFLOW                                 00080500
MFA-TR*           ,:DY-CARRIER-ROUTE                                    00080600
MFA-TR*           ,:DY-ZIP-CODE                                         00080700
MFA-TR*           ,:DY-ZIP-CODE-PLUS-FOUR                               00080800
MFA-TR*           ,:DY-ZIP-CODE-TOKEN                                   00080900
MFA-TR*           ,:DY-ADDR-SUFFIX                                      00081000
MFA-TR*       FROM CSS_ADDR_FORMATTED                                   00081100
MFA-TR*      WHERE ADDRESS_ID = :PR-ADDRESS-ID                          00081200
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7300                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
              MOVE PR-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7400-SELECT-POINT-ID.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PP.AREA_ID,
              PP.TAG_NM                                          
                INTO :PP-AREA-ID                                        
                    ,:PP-TAG-NM                                         
                FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_PIM_POINT PP WITH(READUNCOMMITTED)                     
               WHERE MN.ACCOUNT_NO = :MN-ACCOUNT-NO                     
                 AND MN.CODE_UTIL_TYPE = 'E'                            
                 AND MN.GIS_POINT_ID = PP.POINT_ID                      
               ORDER BY MN.LAST_REG_READ_DATE DESC                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PP.AREA_ID                                                 
MFA-TR*             ,PP.TAG_NM                                                  
MFA-TR*         INTO :PP-AREA-ID                                                
MFA-TR*             ,:PP-TAG-NM                                                 
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_PIM_POINT PP                                           
MFA-TR*        WHERE MN.ACCOUNT_NO = :MN-ACCOUNT-NO                             
MFA-TR*          AND MN.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*          AND MN.GIS_POINT_ID = PP.POINT_ID                              
MFA-TR*        ORDER BY MN.LAST_REG_READ_DATE DESC                              
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    QUERYNO 7400                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      *================================================================*        
       7500-SELECT-ZIP-CODE.                                            
      *================================================================*        
                                                                        
           EXEC SQL                                                     
             SELECT TOWN                                                
                   ,STATE                                               
               INTO :A4-TOWN                                            
                   ,:A4-STATE                                           
               FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                          
              WHERE ZIP_CODE = :A4-ZIP-CODE AND                         
                    ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT TOWN                                                00088400
MFA-TR*            ,STATE                                               00088600
MFA-TR*        INTO :A4-TOWN                                            00088700
MFA-TR*            ,:A4-STATE                                           00088800
MFA-TR*        FROM CSS_ZIP_CODE                                        00088900
MFA-TR*       WHERE ZIP_CODE = :A4-ZIP-CODE AND                         00089000
MFA-TR*             ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                 00089100
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7500                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ZIP_CODE'        TO TABLE-1                     
              MOVE 'ZIP_CODE'            TO TABLE-ELEMENT-1             
              MOVE A4-ZIP-CODE           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04766_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04766_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04766_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04766_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04766_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04766_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04766_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04766_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8003'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04766_R3'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04766_R1                            
             (                                                          
              RETURN_CODE                                               
             ,STATUS_CODE                                               
             ,ORDER_TYPE_DESC                                           
             ,SERV_ORDER_NO                                             
             ,ACCOUNT_NO                                                
             ,ACCOUNT_NO_PRIOR                                          
             ,WANTED_BY_DATETIME                                        
             ,SERV_ORDER_STATUS                                         
             ,ORDER_PLACED_BY                                           
             ,WORK_AREA_ID                                              
             ,ORDER_STATE_CD                                            
             ,ADDRESS_LINE1                                             
             ,ADDRESS_LINE2                                             
             ,PREMISE_NO                                                
             ,CUSTOMER_NO                                               
             ,CUST_NAME                                                 
             ,SUBDIVISION_ID                                            
             ,PHONE_NO                                                  
             ,POINT_ID                                                  
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1                                         
              ,:S-STATUS-CODE                                           
              ,:S-ORDER-TYPE-DESC                                       
              ,:S-SERV-ORDER-NO-1                                       
              ,:S-ACCOUNT-NO                                            
              ,:S-ACCOUNT-NO-PRIOR                                      
              ,:S-WANTED-BY-TMST                                        
              ,:S-SERV-ORDER-STATUS                                     
              ,:S-ORDER-PLACED-BY                                       
              ,:S-WORK-AREA-ID                                          
              ,:S-ORDER-STATE-CD                                        
              ,:S-ADDRESS-LINE1                                         
              ,:S-ADDRESS-LINE2                                         
              ,:S-PREMISE-NO                                            
              ,:S-CUSTOMER-NO                                           
              ,:S-CUST-NAME                                             
              ,:S-SUBDIVISION-ID                                        
              ,:S-PHONE-NO                                              
              ,:S-POINT-ID                                              
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04766_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,STATUS_CODE                                                       
MFA-TR*      ,ORDER_TYPE_DESC                                                   
MFA-TR*      ,SERV_ORDER_NO                                                     
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,ACCOUNT_NO_PRIOR                                                  
MFA-TR*      ,WANTED_BY_DATETIME                                                
MFA-TR*      ,SERV_ORDER_STATUS                                                 
MFA-TR*      ,ORDER_PLACED_BY                                                   
MFA-TR*      ,WORK_AREA_ID                                                      
MFA-TR*      ,ORDER_STATE_CD                                                    
MFA-TR*      ,ADDRESS_LINE1                                                     
MFA-TR*      ,ADDRESS_LINE2                                                     
MFA-TR*      ,PREMISE_NO                                                        
MFA-TR*      ,CUSTOMER_NO                                                       
MFA-TR*      ,CUST_NAME                                                         
MFA-TR*      ,SUBDIVISION_ID                                                    
MFA-TR*      ,PHONE_NO                                                          
MFA-TR*      ,POINT_ID                                                          
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1                                                 
MFA-TR*       ,:S-STATUS-CODE                                                   
MFA-TR*       ,:S-ORDER-TYPE-DESC                                               
MFA-TR*       ,:S-SERV-ORDER-NO-1                                               
MFA-TR*       ,:S-ACCOUNT-NO                                                    
MFA-TR*       ,:S-ACCOUNT-NO-PRIOR                                              
MFA-TR*       ,:S-WANTED-BY-TMST                                                
MFA-TR*       ,:S-SERV-ORDER-STATUS                                             
MFA-TR*       ,:S-ORDER-PLACED-BY                                               
MFA-TR*       ,:S-WORK-AREA-ID                                                  
MFA-TR*       ,:S-ORDER-STATE-CD                                                
MFA-TR*       ,:S-ADDRESS-LINE1                                                 
MFA-TR*       ,:S-ADDRESS-LINE2                                                 
MFA-TR*       ,:S-PREMISE-NO                                                    
MFA-TR*       ,:S-CUSTOMER-NO                                                   
MFA-TR*       ,:S-CUST-NAME                                                     
MFA-TR*       ,:S-SUBDIVISION-ID                                                
MFA-TR*       ,:S-PHONE-NO                                                      
MFA-TR*       ,:S-POINT-ID                                                      
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04766_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04766_R2                            
             (                                                          
              RETURN_CODE                                               
             ,SERV_ORDER_NO                                             
             ,CODE_UTIL_TYPE                                            
             ,WORK_TYPE_CD                                              
             ,WORK_TYPE_DESC                                            
             ,METER_NO                                                  
             ,SO_INST_SEQ_NO                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2                                         
              ,:S-SERV-ORDER-NO-2                                       
              ,:S-CODE-UTIL-TYPE                                        
              ,:S-WORK-TYPE-CD                                          
              ,:S-WORK-TYPE-DESC                                        
              ,:S-METER-NO                                              
              ,:S-SO-INST-SEQ-NO                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04766_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,SERV_ORDER_NO                                                     
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,WORK_TYPE_CD                                                      
MFA-TR*      ,WORK_TYPE_DESC                                                    
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,SO_INST_SEQ_NO                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2                                                 
MFA-TR*       ,:S-SERV-ORDER-NO-2                                               
MFA-TR*       ,:S-CODE-UTIL-TYPE                                                
MFA-TR*       ,:S-WORK-TYPE-CD                                                  
MFA-TR*       ,:S-WORK-TYPE-DESC                                                
MFA-TR*       ,:S-METER-NO                                                      
MFA-TR*       ,:S-SO-INST-SEQ-NO                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04766_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04766_R3                            
             (                                                          
              RETURN_CODE                                               
             ,SERV_ORDER_NO                                             
             ,REMARK_TYPE                                               
             ,REMARK_DATETIME                                           
             ,CHANGED_BY_USER_ID                                        
             ,REMARK_TEXT                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3                                         
              ,:S-SERV-ORDER-NO-3                                       
              ,:S-REMARK-TYPE-CD                                        
              ,:S-REMARK-DATETIME                                       
              ,:S-CHANGED-BY-USER-ID                                    
              ,:S-REMARK-TEXT                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04766_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,SERV_ORDER_NO                                                     
MFA-TR*      ,REMARK_TYPE                                                       
MFA-TR*      ,REMARK_DATETIME                                                   
MFA-TR*      ,CHANGED_BY_USER_ID                                                
MFA-TR*      ,REMARK_TEXT                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3                                                 
MFA-TR*       ,:S-SERV-ORDER-NO-3                                               
MFA-TR*       ,:S-REMARK-TYPE-CD                                                
MFA-TR*       ,:S-REMARK-DATETIME                                               
MFA-TR*       ,:S-CHANGED-BY-USER-ID                                            
MFA-TR*       ,:S-REMARK-TEXT                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04766_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
      *       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                00381400
      *       MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               00381500
      *       MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      00381600
      *       MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              00381700
      *       MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            00381800
      *       MOVE -1                   TO WS-ACTIVE-RETURN-CODE        00381900
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            00382000
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            00382100
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
