       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04762.                                      
COB303 DATE-WRITTEN.     MAY 18, 2014.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04762              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04762 :                                                --         
      *--                                                            --         
      *--  LIGHT DETAILS SCREEN: RETRIEVE FIXTURE DETAILS, POLE      --         
      *--  DETAILS AND NODE DETAILS USING FIXTURE DATA AS INPUT      --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *-- PARAMETERS                                                 --         
      *--                                                            --         
      *--  INPUT                                                     --         
      *--    FIXTURE_SEQ         CHAR(10)                            --         
      *--    FIXTURE_TAG_NO      CHAR(12)                            --         
      *--                                                            --         
      *--  OUTPUT                                                    --         
      *--    RESULT SET - CSR04762_FXTR: Fixture Details             --         
      *--    RESULT SET - CSR04762_R2  : Pole Details                --         
      *--    RESULT SET - CSR04762_R3  : Node Details                --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00817*--  05/17/2014    AS7C117     RETRIEVE LIGHT DETAILS.         --         
P00817*--  07/01/2014    GD43988     ADDED ADDITIONAL FUNCTIONALITY. --         
P00817*--  10/16/2014    GD43988     VERIFY TAG-1ST CHAR COLUMNS     --         
P00817*--                            BEFORE PROD MIGRATION           --         
A05084*--  04/21/2015    DS16382     ADD ACCT STATUS TO LOCATION     --         
      *--                            RESULT SET                      --         
A#5084*--  06/19/2015    SS95855     ACT040 CLP# CHANGED TO CHAR(50) --         
A05084*--  10/01/2015    SV95326     ACT067 REMOVE +4 FROM ZIP IN    --         
A05084*--                            LOCATIONS RESULT SET            --         
A05136*--  11/12/2015    db41297     Fix init error.                 --         
      *----------------------------------------------------------------         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-FXTR-POLE-CUR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04762'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_INVENTRY, 4D                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_ENVRNMT, 4F                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_FXTR_ATTACHMTS, 4H                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFXTATC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_EQUIP_CONTRACT, 4L                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_TERM_CHRG_CALC, 4K                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBTRMCLC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_SPCL_AGREEMENT, 4Q                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAGR                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_TRANS_HIST,4J                                                    
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLGTHST                                                  
           END-EXEC.                                                            
      *                                                                         
      **** LMS_TRANS_HIST_DET,4S                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLMSHST                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_PREMISE, PR                                                      
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CUST_PLAN, CP                                                    
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MTRD_ENVRNMT, MN                                                 
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_PIM_POINT, PP                                                    
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CUST_PREM_HIST, CH                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME, DQ                                                         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME_ACCT_XREF, HT                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ADDR_FORMATTED, DY                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIP_CODE, A4                                                     
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ZIPCODE_SUBDIV, ZS                                               
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPSUB                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_DELINQUENCY, C8                                                  
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04762'. 
           05  WS-811                       PIC S9(9) VALUE -811 COMP.  
           05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
           05  WS-PENDING                   PIC X(1)  VALUE 'P'.        
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9) COMP.                
           05  PARM-FIXTURE-SEQ          PIC X(10).                     
           05  PARM-FIXTURE-SEQ-NUM  REDEFINES                          
               PARM-FIXTURE-SEQ          PIC 9(10).                     
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-FXTR             PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-LOC              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-POLE             PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-CNTRCT           PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-NODE             PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
      **** GTT TABLE LAYOUT FOR Fixture Details                                 
      *                                                                         
           05 GTT-RETURN-FIELDS-FXTR.                                   
              10 S-F-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
              10 S-F-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0.    
              10 S-F-EQUIP-TAG-NO        PIC X(12) VALUE SPACES.        
              10 S-F-COMPANY-NO          PIC X(02) VALUE SPACES.        
              10 S-F-CODE-SERVICE-TYPE   PIC X(01) VALUE SPACES.        
              10 S-F-STOCK-CD            PIC X(15) VALUE SPACES.        
              10 S-F-EQUIP-MFR-CD        PIC X(02) VALUE SPACES.        
              10 S-F-EQUIP-MFR-DT        PIC X(10) VALUE SPACES.        
              10 S-F-WARRANTY-EXP-DT     PIC X(10) VALUE SPACES.        
              10 S-F-EQUIP-DISPOSAL-DT   PIC X(10) VALUE SPACES.        
              10 S-F-STORAGE-FAC-CD      PIC X(03) VALUE SPACES.        
              10 S-F-INVENTRY-STATUS-CD  PIC X(01) VALUE SPACES.        
              10 S-F-WRNTY-RECEIVED-FL   PIC X(01) VALUE SPACES.        
              10 S-F-WRNTY-RECOUP-AMT    PIC S9(5)V9(2) USAGE COMP-3    
                                                   VALUE 0.             
              10 S-F-INSTALL-LOC-NO      PIC X(10) VALUE SPACES.        
              10 S-F-INSTALL-POINT-NO    PIC S9(5)V USAGE COMP-3        
                                                   VALUE 0.             
              10 S-F-INSTALL-LOC-CD      PIC X(01) VALUE SPACES.        
              10 S-F-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.        
              10 S-F-IC-NO               PIC S9(4) USAGE COMP VALUE 0.  
              10 S-F-RATE-PLAN-NO        PIC X(03) VALUE SPACES.        
              10 S-F-RATE-ITEM-CODE      PIC S9(4) USAGE COMP VALUE 0.  
              10 S-F-ITEM-SEQ-NO         PIC S9(4) USAGE COMP VALUE 0.  
              10 S-F-BILLING-FL          PIC X(01) VALUE SPACES.        
              10 S-F-NO-BILL-REASON-CD   PIC X(02) VALUE SPACES.        
              10 S-F-EQUIP-CONTRACT-FL   PIC X(01) VALUE SPACES.        
              10 S-F-NO-CONTRACT-RSN-CD  PIC X(02) VALUE SPACES.        
              10 S-F-EQUIP-OWNER-CD      PIC X(01) VALUE SPACES.        
              10 S-F-EQUIP-DRAWING-ID    PIC X(10) VALUE SPACES.        
              10 S-F-SOURCE-APPL-CD      PIC X(03) VALUE SPACES.        
              10 S-F-SOURCE-APPL-REQ-NO  PIC S9(13)V USAGE COMP-3       
                                                    VALUE 0.            
              10 S-F-WMS-POINT-NO        PIC S9(3)V9(2) USAGE COMP-3    
                                                    VALUE 0.            
              10 S-F-EQUIP-INSTALL-DT    PIC X(10) VALUE SPACES.        
              10 S-F-SPCL-AGR-COMMENTS   PIC X(250) VALUE SPACES.       
              10 S-F-EQUIP-COMMENTS      PIC X(250) VALUE SPACES.       
              10 S-F-CODE-REVENUE-CLASS  PIC X(03)  VALUE SPACES.       
              10 S-F-TAG-TYPE-CD         PIC X(01)  VALUE SPACES.       
              10 S-F-WMS-INSTALL-COUNT   PIC S9(4) USAGE COMP VALUE 0.  
      *                                                                         
      **** GTT TABLE LAYOUT FOR Fixture Location Details                        
      *                                                                         
           05 GTT-RETURN-FIELDS-LOC.                                    
              10 S-L-RETURN-CODE         PIC S9(9)   COMP   VALUE 0.    
              10 S-L-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE 0.    
              10 S-L-PREMISE-NO          PIC S9(10)V COMP-3 VALUE 0.    
              10 S-L-REV-DISTRICT-CD     PIC X(03)  VALUE SPACES.       
              10 S-L-SUBDIVISION-ID      PIC X(03)  VALUE SPACES.       
              10 S-L-SUB-DIV-ZIP-CD      PIC X(05)  VALUE SPACES.       
              10 S-L-POINT-ID            PIC X(10)  VALUE SPACES.       
              10 S-L-CUSTOMER-NAME       PIC X(70)  VALUE SPACES.       
              10 S-L-ADDRESS             PIC X(170) VALUE SPACES.       
              10 S-L-USAGE-FIXED         PIC S9(9)V COMP-3 VALUE 0.     
A05084        10 S-L-CODE-ACCT-STAT      PIC X(01)  VALUE SPACES.       
      *                                                                         
      **** GTT TABLE LAYOUT FOR Pole Details                                    
      *                                                                         
           05 GTT-RETURN-FIELDS-POLE.                                   
              10 S-P-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
              10 S-P-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0.    
              10 S-P-ATTACH-SEQ-NO       PIC S9(4) COMP VALUE 0.        
              10 S-P-EQUIP-TAG-NO        PIC X(12) VALUE SPACES.        
              10 S-P-COMPANY-NO          PIC X(02) VALUE SPACES.        
              10 S-P-CODE-SERVICE-TYPE   PIC X(01) VALUE SPACES.        
              10 S-P-STOCK-CD            PIC X(15) VALUE SPACES.        
              10 S-P-INVENTRY-STATUS-CD  PIC X(01) VALUE SPACES.        
              10 S-P-INSTALL-POINT-NO    PIC S9(5)V USAGE COMP-3        
                                                   VALUE 0.             
              10 S-P-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.        
              10 S-P-IC-NO               PIC S9(4) USAGE COMP VALUE 0.  
              10 S-P-RATE-PLAN-NO        PIC X(03) VALUE SPACES.        
              10 S-P-RATE-ITEM-CODE      PIC S9(4) USAGE COMP VALUE 0.  
              10 S-P-ITEM-SEQ-NO         PIC S9(4) USAGE COMP VALUE 0.  
              10 S-P-BILLING-FL          PIC X(01) VALUE SPACES.        
              10 S-P-NO-BILL-REASON-CD   PIC X(02) VALUE SPACES.        
              10 S-P-EQUIP-OWNER-CD      PIC X(01) VALUE SPACES.        
              10 S-P-EQUIP-INSTALL-DT    PIC X(10) VALUE SPACES.        
              10 S-P-CODE-REVENUE-CLASS  PIC X(03)  VALUE SPACES.       
              10 S-P-MSG-FXTR-COUNT      PIC S9(4) USAGE COMP VALUE 0.  
              10 S-P-MSG-FXTR-TEXT       PIC X(130) VALUE SPACES.       
      *                                                                         
      **** GTT TABLE LAYOUT FOR Fixture Contract Details                        
      *                                                                         
           05 GTT-RETURN-FIELDS-CNTRCT.                                 
              10 S-C-RETURN-CODE         PIC S9(9)   COMP   VALUE 0.    
              10 S-C-ACCOUNT-NO          PIC S9(13)V COMP-3 VALUE 0.    
              10 S-C-CNTRCT-START-DT     PIC X(10) VALUE SPACES.        
              10 S-C-CNTRCT-END-DT       PIC X(10) VALUE SPACES.        
              10 S-C-CNTRCT-DURATION-CD  PIC X(02) VALUE SPACES.        
              10 S-C-FIXTURE-COST-AM     PIC S9(5)V9(2) COMP-3 VALUE 0. 
              10 S-C-POLE-COST-AM        PIC S9(5)V9(2) COMP-3 VALUE 0. 
              10 S-C-CALC-TERM-CHRG-AM   PIC S9(5)V9(2) COMP-3 VALUE 0. 
              10 S-C-ORIG-TERM-CHRG-AM   PIC S9(5)V9(2) COMP-3 VALUE 0. 
              10 S-C-ACTL-TERM-CHRG-AM   PIC S9(5)V9(2) COMP-3 VALUE 0. 
              10 S-C-ACTL-CHRG-DT        PIC X(10) VALUE SPACES.        
ACT040        10 S-C-CNTRCT-CLP-NO       PIC X(50) VALUE SPACES.        
              10 S-C-CNTRCT-STATUS-CD    PIC X(01) VALUE SPACES.        
      *                                                                         
      **** GTT TABLE LAYOUT FOR Node Details                                    
      *                                                                         
           05 GTT-RETURN-FIELDS-NODE.                                   
              10 S-N-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
              10 S-N-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0.    
              10 S-N-ATTACH-SEQ-NO       PIC S9(4) COMP VALUE 0.        
              10 S-N-EQUIP-TAG-NO        PIC X(12) VALUE SPACES.        
              10 S-N-COMPANY-NO          PIC X(02) VALUE SPACES.        
              10 S-N-CODE-SERVICE-TYPE   PIC X(01) VALUE SPACES.        
              10 S-N-STOCK-CD            PIC X(15) VALUE SPACES.        
              10 S-N-EQUIP-MFR-CD        PIC X(02) VALUE SPACES.        
              10 S-N-EQUIP-MFR-DT        PIC X(10) VALUE SPACES.        
              10 S-N-WARRANTY-EXP-DT     PIC X(10) VALUE SPACES.        
              10 S-N-INVENTRY-STATUS-CD  PIC X(01) VALUE SPACES.        
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05 WS-ADDRESS.                                               
              10 WS-ADDRESS-LINE1        PIC X(85)  VALUE SPACES.       
              10 WS-ADDRESS-LINE2        PIC X(85)  VALUE SPACES.       
              10 WS-IN-STRING.                                          
                 15 WS-IN-CHAR           PIC X(01) OCCURS 85 TIMES      
                                         INDEXED BY WS-IN-INDX.         
              10 WS-OUT-STRING.                                         
                 15 WS-OUT-CHAR          PIC X(01) OCCURS 85 TIMES      
                                         INDEXED BY WS-OUT-INDX.        
              10 WS-LAST-CHAR            PIC X(01) VALUE SPACES.        
              10 WS-CHAR-LENGTH          PIC S9(3) VALUE ZERO.          
              10 WS-STREET-ADDRESS.                                     
                 15 WS-HOUSE-NO          PIC X(15) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-ADDR-PREFIX-1     PIC X(03) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-ADDR-PREFIX-2     PIC X(02) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-NAME-STREET       PIC X(30) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STREET-SUFFIX     PIC X(04) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-ADDRESS-SUFFIX    PIC X(02) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STREET-LOCATION-1 PIC X(04) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STREET-LOCATION-2 PIC X(11) VALUE SPACES.        
                 15 FILLER               PIC X(04) VALUE SPACES.        
              10 WS-CITY-STATE.                                         
                 15 WS-CITY              PIC X(26) VALUE SPACES.        
                 15 FILLER               PIC X(01) VALUE SPACES.        
                 15 WS-STATE             PIC X(02) VALUE SPACES.        
                 15 WS-ZIP-FILLER        PIC X(02) VALUE ' *'.          
                 15 WS-ZIP.                                             
                    20 WS-ZIP-CODE       PIC X(05) VALUE SPACES.        
                    20 WS-ZIP-DASH       PIC X(01) VALUE '-'.           
                    20 WS-ZIP-PLUS-4     PIC X(04) VALUE SPACES.        
      *                                                                         
           05 WS-FXTR-LIST.                                             
              10 WS-FXTR-TAG-NO          PIC X(12) OCCURS 10 TIMES.     
           05 WS-FXTR-POLE-ROW-COUNT     PIC S9(4) USAGE COMP VALUE 0.  
           05 WS-MSG-FXTR-COUNT          PIC S9(4) USAGE COMP VALUE 0.  
           05 WS-MSG-FXTR-TEXT-TEMP      PIC X(130) VALUE SPACES.       
           05 WS-MSG-FXTR-TEXT           PIC X(130) VALUE SPACES.       
           05 WS-WMS-INSTALL-COUNT       PIC S9(4) USAGE COMP VALUE 0.  
      *                                                                         
           05 WS-CONV-TAG-1ST-CHAR       PIC X(01) VALUE 'C'.           
           05 WS-SCEG-TAG-1ST-CHAR       PIC X(01) VALUE 'S'.           
      *                                                                         
       01  WS-FLAGS.                                                    
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  IND-EQUIP-MFR-DT          PIC S9(04) COMP.               
           05  IND-WARRANTY-EXP-DT       PIC S9(04) COMP.               
           05  IND-DISPOSAL-DT           PIC S9(04) COMP.               
           05  IND-INSTALL-DT            PIC S9(04) COMP.               
           05  IND-ACTL-CHRG-DT          PIC S9(04) COMP.               
      *                                                                         
      ****************************************************************          
      **   ERROR PROCESSING VARIABLES                               **          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
      **** CONTRACT TERMINATION CALC                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSLM003                                                 
           END-EXEC.                                                            
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** WOKING STORAGE FOR CPDCA099                                          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** FIXTURE SPECIAL AGREEMENTS CURSOR                            **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE SPCL_AGR_CUR CURSOR FOR                          
                SELECT  [4Q].PREMISE_NO                                   
                  FROM  LMS_SPCL_AGREEMENT  [4Q] WITH(READUNCOMMITTED)          
                 WHERE  [4Q].AGREEMENT_NO  =  :4Q-AGREEMENT-NO            
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SPCL_AGR_CUR CURSOR FOR                                  
MFA-TR*         SELECT  4Q.PREMISE_NO                                           
MFA-TR*           FROM  LMS_SPCL_AGREEMENT  4Q                                  
MFA-TR*          WHERE  4Q.AGREEMENT_NO  =  :4Q-AGREEMENT-NO                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** FIXTURE ATTACHMENTS CURSOR                                   **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE FXTR_ATCH_CUR CURSOR FOR                         
                SELECT  [4H].ATTACH_SEQ_NO                                
                       ,[4H].EQUIP_TYPE_CD                                
                       ,[4H].ATTACH_EQUIP_SEQ                             
                       ,[4H].ATTACH_EQUIP_DT                              
                  FROM  LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)           
                 WHERE  [4H].FXTR_EQUIP_SEQ  =  :4H-FXTR-EQUIP-SEQ        
                   AND  [4H].EQUIP_TYPE_CD  IN  ('P','N')                 
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FXTR_ATCH_CUR CURSOR FOR                                 
MFA-TR*         SELECT  4H.ATTACH_SEQ_NO                                        
MFA-TR*                ,4H.EQUIP_TYPE_CD                                        
MFA-TR*                ,4H.ATTACH_EQUIP_SEQ                                     
MFA-TR*                ,4H.ATTACH_EQUIP_DT                                      
MFA-TR*           FROM  LMS_FXTR_ATTACHMTS 4H                                   
MFA-TR*          WHERE  4H.FXTR_EQUIP_SEQ  =  :4H-FXTR-EQUIP-SEQ                
MFA-TR*            AND  4H.EQUIP_TYPE_CD  IN  ('P','N')                         
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** FIXTURE POLE CURSOR                                          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE FXTR_POLE_CUR CURSOR WITH ROWSET POSITIONING FOR 
                SELECT TOP(10) LTRIM(RTRIM([4D].EQUIP_TAG_NO))                  
                  FROM LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)            
                      ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)            
                      ,LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)            
                 WHERE [4F].INSTALL_LOC_NO  =  :4F-INSTALL-LOC-NO         
                   AND [4F].EQUIP_SEQ       =  [4D].EQUIP_SEQ               
                   AND [4D].EQUIP_TYPE_CD   =  'F'                        
                   AND [4H].FXTR_EQUIP_SEQ  =  [4D].EQUIP_SEQ               
                   AND [4H].EQUIP_TYPE_CD   =  'P'                        
                   AND [4H].FXTR_EQUIP_SEQ <>  :4H-FXTR-EQUIP-SEQ         
                   AND EXISTS                                           
                     (SELECT 1                                          
                        FROM LMS_EQUIP_ENVRNMT  F1 WITH(READUNCOMMITTED)        
                            ,LMS_EQUIP_INVENTRY D1 WITH(READUNCOMMITTED)        
                       WHERE F1.INSTALL_LOC_NO = [4F].INSTALL_LOC_NO      
                         AND F1.EQUIP_SEQ      = [4H].ATTACH_EQUIP_SEQ    
                         AND D1.EQUIP_SEQ      = F1.EQUIP_SEQ           
                         AND D1.EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO       
                         AND D1.EQUIP_TYPE_CD  = 'P')                   
                ORDER BY [4D].EQUIP_TAG_NO                                
                                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FXTR_POLE_CUR CURSOR WITH ROWSET POSITIONING FOR         
MFA-TR*         SELECT STRIP(4D.EQUIP_TAG_NO)                                   
MFA-TR*           FROM LMS_EQUIP_ENVRNMT  4F                                    
MFA-TR*               ,LMS_EQUIP_INVENTRY 4D                                    
MFA-TR*               ,LMS_FXTR_ATTACHMTS 4H                                    
MFA-TR*          WHERE 4F.INSTALL_LOC_NO  =  :4F-INSTALL-LOC-NO                 
MFA-TR*            AND 4F.EQUIP_SEQ       =  4D.EQUIP_SEQ                       
MFA-TR*            AND 4D.EQUIP_TYPE_CD   =  'F'                                
MFA-TR*            AND 4H.FXTR_EQUIP_SEQ  =  4D.EQUIP_SEQ                       
MFA-TR*            AND 4H.EQUIP_TYPE_CD   =  'P'                                
MFA-TR*            AND 4H.FXTR_EQUIP_SEQ <>  :4H-FXTR-EQUIP-SEQ                 
MFA-TR*            AND EXISTS                                                   
MFA-TR*              (SELECT 1                                                  
MFA-TR*                 FROM LMS_EQUIP_ENVRNMT  F1                              
MFA-TR*                     ,LMS_EQUIP_INVENTRY D1                              
MFA-TR*                WHERE F1.INSTALL_LOC_NO = 4F.INSTALL_LOC_NO              
MFA-TR*                  AND F1.EQUIP_SEQ      = 4H.ATTACH_EQUIP_SEQ            
MFA-TR*                  AND D1.EQUIP_SEQ      = F1.EQUIP_SEQ                   
MFA-TR*                  AND D1.EQUIP_TAG_NO   = :4D-EQUIP-TAG-NO               
MFA-TR*                  AND D1.EQUIP_TYPE_CD  = 'P')                           
MFA-TR*         ORDER BY 4D.EQUIP_TAG_NO                                        
MFA-TR*         FETCH FIRST 10 ROWS ONLY WITH UR                                
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 LINK-FIXTURE-SEQ      PIC X(10).                              
      *                                                                         
       PROCEDURE DIVISION USING LINK-FIXTURE-SEQ.                       
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE         THRU  0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT      THRU  1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT     THRU  2000-EXIT.             
           PERFORM 2900-VLDT-NOTFOUND-RES  THRU  2900-EXIT.             
           PERFORM 9999-END-PROGRAM        THRU  9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-FXTR    THRU  0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-LOC     THRU  0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-POLE    THRU  0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT-CNTRCT  THRU  0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT-NODE    THRU  0100E-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - FIXTURE DETAILS             **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-FXTR.                                          
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04762_FXTR'               
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04762_FXTR')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04762_FXTR
              (                                                       
                    RETURN_CODE             INT                     
                   ,EQUIP_SEQ               DECIMAL(10,0)              
                   ,EQUIP_TAG_NO CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_SERVICE_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STOCK_CD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,EQUIP_MFR_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_MFR_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WARRANTY_EXP_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_DISPOSAL_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STORAGE_FAC_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INVENTRY_STATUS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WRNTY_RECEIVED_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WRNTY_RECOUP_AMT        DECIMAL(7,2)               
                   ,INSTALL_LOC_NO CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INSTALL_POINT_NO        DECIMAL(5,0)               
                   ,INSTALL_LOC_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_ITEM_CODE          SMALLINT                    
                   ,ITEM_SEQ_NO             SMALLINT                    
                   ,BILLING_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,NO_BILL_REASON_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_CONTRACT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NO_CONTRACT_RSN_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_OWNER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_DRAWING_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SOURCE_APPL_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SOURCE_APPL_REQ_NO      DECIMAL(13,0)              
                   ,WMS_POINT_NO            DECIMAL(5,2)               
                   ,EQUIP_INSTALL_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SPCL_AGR_COMMENTS CHAR(250)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,EQUIP_COMMENTS CHAR(250)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TAG_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WMS_INSTALL_COUNT       SMALLINT                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS-FXTR  THRU  8000A-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04762_FXTR'       TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,EQUIP_SEQ                                        
                      ,EQUIP_TAG_NO                                     
                      ,COMPANY_NO                                       
                      ,CODE_SERVICE_TYPE                                
                      ,STOCK_CD                                         
                      ,EQUIP_MFR_CD                                     
                      ,EQUIP_MFR_DT                                     
                      ,WARRANTY_EXP_DT                                  
                      ,EQUIP_DISPOSAL_DT                                
                      ,STORAGE_FAC_CD                                   
                      ,INVENTRY_STATUS_CD                               
                      ,WRNTY_RECEIVED_FL                                
                      ,WRNTY_RECOUP_AMT                                 
                      ,INSTALL_LOC_NO                                   
                      ,INSTALL_POINT_NO                                 
                      ,INSTALL_LOC_CD                                   
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,RATE_PLAN_NO                                     
                      ,RATE_ITEM_CODE                                   
                      ,ITEM_SEQ_NO                                      
                      ,BILLING_FL                                       
                      ,NO_BILL_REASON_CD                                
                      ,EQUIP_CONTRACT_FL                                
                      ,NO_CONTRACT_RSN_CD                               
                      ,EQUIP_OWNER_CD                                   
                      ,EQUIP_DRAWING_ID                                 
                      ,SOURCE_APPL_CD                                   
                      ,SOURCE_APPL_REQ_NO                               
                      ,WMS_POINT_NO                                     
                      ,EQUIP_INSTALL_DT                                 
                      ,SPCL_AGR_COMMENTS                                
                      ,EQUIP_COMMENTS                                   
                      ,CODE_REVENUE_CLASS                               
                      ,TAG_TYPE_CD                                      
                      ,WMS_INSTALL_COUNT                                
                  FROM #CSR04762_FXTR                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,EQUIP_SEQ                                                
MFA-TR*               ,EQUIP_TAG_NO                                             
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_SERVICE_TYPE                                        
MFA-TR*               ,STOCK_CD                                                 
MFA-TR*               ,EQUIP_MFR_CD                                             
MFA-TR*               ,EQUIP_MFR_DT                                             
MFA-TR*               ,WARRANTY_EXP_DT                                          
MFA-TR*               ,EQUIP_DISPOSAL_DT                                        
MFA-TR*               ,STORAGE_FAC_CD                                           
MFA-TR*               ,INVENTRY_STATUS_CD                                       
MFA-TR*               ,WRNTY_RECEIVED_FL                                        
MFA-TR*               ,WRNTY_RECOUP_AMT                                         
MFA-TR*               ,INSTALL_LOC_NO                                           
MFA-TR*               ,INSTALL_POINT_NO                                         
MFA-TR*               ,INSTALL_LOC_CD                                           
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,RATE_ITEM_CODE                                           
MFA-TR*               ,ITEM_SEQ_NO                                              
MFA-TR*               ,BILLING_FL                                               
MFA-TR*               ,NO_BILL_REASON_CD                                        
MFA-TR*               ,EQUIP_CONTRACT_FL                                        
MFA-TR*               ,NO_CONTRACT_RSN_CD                                       
MFA-TR*               ,EQUIP_OWNER_CD                                           
MFA-TR*               ,EQUIP_DRAWING_ID                                         
MFA-TR*               ,SOURCE_APPL_CD                                           
MFA-TR*               ,SOURCE_APPL_REQ_NO                                       
MFA-TR*               ,WMS_POINT_NO                                             
MFA-TR*               ,EQUIP_INSTALL_DT                                         
MFA-TR*               ,SPCL_AGR_COMMENTS                                        
MFA-TR*               ,EQUIP_COMMENTS                                           
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,TAG_TYPE_CD                                              
MFA-TR*               ,WMS_INSTALL_COUNT                                        
MFA-TR*           FROM SESSION.CSR04762_FXTR                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - FIXTURE LOCATION DETAILS    **        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-LOC.                                           
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04762_LOC'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04762_LOC')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04762_LOC
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)              
                   ,PREMISE_NO              DECIMAL(10,0)              
                   ,REV_DISTRICT_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SUBDIVISION_ID CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SUB_DIV_ZIP_CD CHAR(05)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,CUSTOMER_NAME CHAR(70)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ADDRESS CHAR(170)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,USAGE_FIXED             DECIMAL(9,0)               
A05084             ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS-LOC  THRU  8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04762_LOC'        TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,PREMISE_NO                                       
                      ,REV_DISTRICT_CD                                  
                      ,SUBDIVISION_ID                                   
                      ,SUB_DIV_ZIP_CD                                   
                      ,POINT_ID                                         
                      ,CUSTOMER_NAME                                    
                      ,ADDRESS                                          
                      ,USAGE_FIXED                                      
A05084                ,CODE_ACCT_STAT                                   
                  FROM #CSR04762_LOC                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,REV_DISTRICT_CD                                          
MFA-TR*               ,SUBDIVISION_ID                                           
MFA-TR*               ,SUB_DIV_ZIP_CD                                           
MFA-TR*               ,POINT_ID                                                 
MFA-TR*               ,CUSTOMER_NAME                                            
MFA-TR*               ,ADDRESS                                                  
MFA-TR*               ,USAGE_FIXED                                              
MFA-TR*               ,CODE_ACCT_STAT                                           
MFA-TR*           FROM SESSION.CSR04762_LOC                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - POLE DETAILS                **        
      ******************************************************************        
      *                                                                         
       0100C-DECLARE-GTT-POLE.                                          
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04762_POLE'               
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04762_POLE')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04762_POLE
              (                                                       
                    RETURN_CODE             INT                     
                   ,EQUIP_SEQ               DECIMAL(10,0)              
                   ,ATTACH_SEQ_NO           SMALLINT                    
                   ,EQUIP_TAG_NO CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_SERVICE_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STOCK_CD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,INVENTRY_STATUS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INSTALL_POINT_NO        DECIMAL(5,0)               
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   SMALLINT                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_ITEM_CODE          SMALLINT                    
                   ,ITEM_SEQ_NO             SMALLINT                    
                   ,BILLING_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,NO_BILL_REASON_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_OWNER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_INSTALL_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MSG_FXTR_COUNT          SMALLINT                    
                   ,MSG_FXTR_TEXT CHAR(130)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS-POLE  THRU  8000C-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100C'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04762_POLE'       TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,EQUIP_SEQ                                        
                      ,ATTACH_SEQ_NO                                    
                      ,EQUIP_TAG_NO                                     
                      ,COMPANY_NO                                       
                      ,CODE_SERVICE_TYPE                                
                      ,STOCK_CD                                         
                      ,INVENTRY_STATUS_CD                               
                      ,INSTALL_POINT_NO                                 
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,RATE_PLAN_NO                                     
                      ,RATE_ITEM_CODE                                   
                      ,ITEM_SEQ_NO                                      
                      ,BILLING_FL                                       
                      ,NO_BILL_REASON_CD                                
                      ,EQUIP_OWNER_CD                                   
                      ,EQUIP_INSTALL_DT                                 
                      ,CODE_REVENUE_CLASS                               
                      ,MSG_FXTR_COUNT                                   
                      ,MSG_FXTR_TEXT                                    
                  FROM #CSR04762_POLE                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,EQUIP_SEQ                                                
MFA-TR*               ,ATTACH_SEQ_NO                                            
MFA-TR*               ,EQUIP_TAG_NO                                             
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_SERVICE_TYPE                                        
MFA-TR*               ,STOCK_CD                                                 
MFA-TR*               ,INVENTRY_STATUS_CD                                       
MFA-TR*               ,INSTALL_POINT_NO                                         
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,RATE_ITEM_CODE                                           
MFA-TR*               ,ITEM_SEQ_NO                                              
MFA-TR*               ,BILLING_FL                                               
MFA-TR*               ,NO_BILL_REASON_CD                                        
MFA-TR*               ,EQUIP_OWNER_CD                                           
MFA-TR*               ,EQUIP_INSTALL_DT                                         
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,MSG_FXTR_COUNT                                           
MFA-TR*               ,MSG_FXTR_TEXT                                            
MFA-TR*           FROM SESSION.CSR04762_POLE                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - FIXTURE CONTRACT DETAILS    **        
      ******************************************************************        
      *                                                                         
       0100D-DECLARE-GTT-CNTRCT.                                        
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04762_CNTRCT'             
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04762_CNTRCT')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04762_CNTRCT
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)              
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_DURATION_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIXTURE_COST_AM         DECIMAL(7,2)               
                   ,POLE_COST_AM            DECIMAL(7,2)               
                   ,CALC_TERM_CHRG_AM       DECIMAL(7,2)               
                   ,ORIG_TERM_CHRG_AM       DECIMAL(7,2)               
                   ,ACTL_TERM_CHRG_AM       DECIMAL(7,2)               
                   ,ACTL_CHRG_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_CLP_NO CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_STATUS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS-CNTRCT  THRU  8000D-EXIT       
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100D'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04762_CNTRCT'     TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,CNTRCT_START_DT                                  
                      ,CNTRCT_END_DT                                    
                      ,CNTRCT_DURATION_CD                               
                      ,FIXTURE_COST_AM                                  
                      ,POLE_COST_AM                                     
                      ,CALC_TERM_CHRG_AM                                
                      ,ORIG_TERM_CHRG_AM                                
                      ,ACTL_TERM_CHRG_AM                                
                      ,ACTL_CHRG_DT                                     
                      ,CNTRCT_CLP_NO                                    
                      ,CNTRCT_STATUS_CD                                 
                  FROM #CSR04762_CNTRCT                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,CNTRCT_START_DT                                          
MFA-TR*               ,CNTRCT_END_DT                                            
MFA-TR*               ,CNTRCT_DURATION_CD                                       
MFA-TR*               ,FIXTURE_COST_AM                                          
MFA-TR*               ,POLE_COST_AM                                             
MFA-TR*               ,CALC_TERM_CHRG_AM                                        
MFA-TR*               ,ORIG_TERM_CHRG_AM                                        
MFA-TR*               ,ACTL_TERM_CHRG_AM                                        
MFA-TR*               ,ACTL_CHRG_DT                                             
MFA-TR*               ,CNTRCT_CLP_NO                                            
MFA-TR*               ,CNTRCT_STATUS_CD                                         
MFA-TR*           FROM SESSION.CSR04762_CNTRCT                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100D-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - NODE DETAILS                **        
      ******************************************************************        
      *                                                                         
       0100E-DECLARE-GTT-NODE.                                          
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04762_NODE'               
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04762_NODE')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04762_NODE
              (                                                       
                    RETURN_CODE             INT                     
                   ,EQUIP_SEQ               DECIMAL(10,0)              
                   ,ATTACH_SEQ_NO           SMALLINT                    
                   ,EQUIP_TAG_NO CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_SERVICE_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STOCK_CD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,EQUIP_MFR_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EQUIP_MFR_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WARRANTY_EXP_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INVENTRY_STATUS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS-NODE  THRU  8000E-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100E'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04762_NODE'       TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
                SELECT RETURN_CODE                                      
                      ,EQUIP_SEQ                                        
                      ,ATTACH_SEQ_NO                                    
                      ,EQUIP_TAG_NO                                     
                      ,COMPANY_NO                                       
                      ,CODE_SERVICE_TYPE                                
                      ,STOCK_CD                                         
                      ,EQUIP_MFR_CD                                     
                      ,EQUIP_MFR_DT                                     
                      ,WARRANTY_EXP_DT                                  
                      ,INVENTRY_STATUS_CD                               
                  FROM #CSR04762_NODE                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,EQUIP_SEQ                                                
MFA-TR*               ,ATTACH_SEQ_NO                                            
MFA-TR*               ,EQUIP_TAG_NO                                             
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_SERVICE_TYPE                                        
MFA-TR*               ,STOCK_CD                                                 
MFA-TR*               ,EQUIP_MFR_CD                                             
MFA-TR*               ,EQUIP_MFR_DT                                             
MFA-TR*               ,WARRANTY_EXP_DT                                          
MFA-TR*               ,INVENTRY_STATUS_CD                                       
MFA-TR*           FROM SESSION.CSR04762_NODE                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100E-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF LINK-FIXTURE-SEQ GREATER THAN SPACES                      
              MOVE LINK-FIXTURE-SEQ       TO PARM-FIXTURE-SEQ           
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE INVENTORY INFO,CUSTOMER INFO,CONTRACT INFO,  **        
      ** ATTACHMENTS INFO (POLE & NODE)                               **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        DCLLMS-EQUIP-INVENTRY      
                                             DCLLMS-EQUIP-ENVRNMT       
                                             DCLLMS-EQUIP-CONTRACT.     
      *                                                                         
      **** FIXTURE INVENTORY DATA                                               
           MOVE PARM-FIXTURE-SEQ-NUM      TO 4D-EQUIP-SEQ               
                                             4F-EQUIP-SEQ               
                                             4L-EQUIP-SEQ               
                                             4H-FXTR-EQUIP-SEQ.         
      *                                                                         
      **** FIXTURE INVENTORY/ ENVIRONMENT INFO                                  
           PERFORM 2050-PROCESS-FIXTURE  THRU  2050-EXIT.               
      *                                                                         
      **** FIXTURE INVENTORY STATUS = J -> INSTALLED                            
           IF 4D-INVENTRY-STATUS-CD = 'J'                               
              PERFORM 2100-PROCESS-FIXTURE-ATTR  THRU  2100-EXIT        
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE INVENTORY/ENVIRONMENT INFO                   **        
      ******************************************************************        
      *                                                                         
       2050-PROCESS-FIXTURE.                                            
      *                                                                         
           MOVE '2050'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 'F'                       TO 4D-EQUIP-TYPE-CD.          
           PERFORM 7200-GET-EQUIP-INV-DET  THRU  7200-EXIT.             
      *                                                                         
      **** INVENTRY STATUS = 'J'(INSTALLED):GET FIXTURE ENV DATA                
      **** INSTALL LOC = 'P'(PREMISE):GET METERED ENV & UTIL ENV DATA           
      *                                                                         
           IF 4D-INVENTRY-STATUS-CD = 'J'                               
              PERFORM 7250-GET-EQUIP-ENV-DET  THRU  7250-EXIT           
              IF 4F-INSTALL-LOC-CD = 'P'                                
                 INITIALIZE                  WS-CPD00099-WORK           
                                             UT-CODE-REVENUE-CLASS      
A05136           MOVE -811                   TO WS-CPD99-DUP-ROWS       
                 MOVE 4F-INSTALL-LOC-NO   TO WS-CPD99-PREMISE-NO        
                 PERFORM 6990-FETCH-CUR-ACCOUNT  THRU  6990-EXIT        
      * VALIDATE ACCOUNT FROM THE ABOVE                                         
                 IF WS-CPD99-ACCOUNT-NO >  0                            
                    MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO           
                    PERFORM 7260-GET-ACCT-DET  THRU  7260-EXIT          
                    IF 4F-BILLING-FL         = 'Z'  AND                 
                       AT-CODE-ACCT-STAT NOT = 'A'                      
      **************   SEND BUSINESS RULE                                       
                       MOVE 100              TO WS-ACTIVE-RETURN-CODE   
                       PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT  
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-CPD99-PREMISE-NO TO AT-PREMISE-NO           
                    MOVE WS-PENDING          TO AT-CODE-ACCT-STAT       
                    PERFORM 7270-GET-ACCT-DET-USING-STAT THRU 7270-EXIT 
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       MOVE AT-ACCOUNT-NO    TO WS-CPD99-ACCOUNT-NO     
                    ELSE                                                
      **************   SEND A BUSINESS RULE                                     
                       MOVE 100              TO WS-ACTIVE-RETURN-CODE   
                       PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT  
                    END-IF                                              
                 END-IF                                                 
                 MOVE WS-CPD99-ACCOUNT-NO TO UT-ACCOUNT-NO              
                 MOVE WS-CPD99-PREMISE-NO TO UT-PREMISE-NO              
                 MOVE 4F-CODE-UTIL-TYPE   TO UT-CODE-UTIL-TYPE          
                 MOVE 4F-IC-NO            TO UT-IC-NO                   
                 MOVE 4F-RATE-PLAN-NO     TO UT-RATE-PLAN-NO            
                 PERFORM 7300-GET-UTIL-ENV-DATA  THRU  7300-EXIT        
                 IF 4F-SOURCE-APPL-CD     = 'WMS'  AND                  
                    4F-SOURCE-APPL-REQ-NO > 0      AND                  
                    4F-BILLING-FL         = 'Z'                         
                    PERFORM 7325-GET-WMS-INSTALL-COUNT THRU 7325-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-MOVE-RESULT-FXTR  THRU  2500-EXIT.              
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE ATTRIBUTES: LOCATION INO, CONTRACT INFO AND  **        
      ** ATTACHMENTS INFO (POLE & NODE)                               **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-FIXTURE-ATTR.                                       
      *                                                                         
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
      **** GET FIXTURE LOCATION DETAILS                                         
           EVALUATE 4F-INSTALL-LOC-CD                                   
               WHEN 'P'                                                 
               WHEN 'S'                                                 
                  PERFORM 2200-PROCESS-LOCATION    THRU  2200-EXIT      
               WHEN 'Z'                                                 
                  MOVE 4F-INSTALL-LOC-NO  TO 4Q-AGREEMENT-NO            
                  PERFORM 7000-OPEN-SPCL-AGR-CUR   THRU  7000-EXIT      
                  PERFORM 7025-FETCH-SPCL-AGR-CUR  THRU  7025-EXIT      
                  PERFORM 2200-PROCESS-LOCATION    THRU  2200-EXIT      
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                  PERFORM 7025-FETCH-SPCL-AGR-CUR  THRU  7025-EXIT      
           END-EVALUATE.                                                
      *                                                                         
      **** GET FIXTURE CONTRACT DETAILS                                         
           IF 4F-EQUIP-CONTRACT-FL = 'Y'                                
              PERFORM 2300-PROCESS-CONTRACT  THRU  2300-EXIT            
           END-IF.                                                      
      *                                                                         
      **** GET FIXTURE ATTACHMENTS DETAILS - POLE & NODE                        
           PERFORM 2400-PROCESS-FXTR-ATTCHMNTS  THRU  2400-EXIT.        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE LOCATION INFO USING PREMISE NO               **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-LOCATION.                                           
      *                                                                         
           MOVE '2200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        PR-SUBDIVISION-ID          
                                             PR-ADDRESS-ID              
                                             PR-REV-DISTRICT-CD         
                                             PP-AREA-ID                 
                                             PP-TAG-NM                  
                                             DQ-FULL-NAME               
                                             ZS-SUBDIVISION-ID          
                                             ZS-REV-DISTRICT-CD         
                                             ZS-ZIP-CODE                
                                             UT-ACCOUNT-NO              
                                             UT-PREMISE-NO              
                                             UT-CODE-UTIL-TYPE          
                                             UT-RATE-PLAN-NO            
                                             CP-RATE-ITEM-CODE          
                                             CP-USAGE-FIXED.            
      *                                                                         
           IF 4F-INSTALL-LOC-CD = 'Z'                                   
              INITIALIZE                     WS-CPD00099-WORK           
A05136        MOVE -811                   TO WS-CPD99-DUP-ROWS          
              MOVE 4Q-PREMISE-NO          TO WS-CPD99-PREMISE-NO        
              PERFORM 6990-FETCH-CUR-ACCOUNT  THRU  6990-EXIT           
A05084        MOVE WS-CPD99-ACCOUNT-NO    TO AT-ACCOUNT-NO              
A05084        PERFORM 7260-GET-ACCT-DET       THRU  7260-EXIT           
           END-IF.                                                      
      *                                                                         
           EVALUATE 4F-INSTALL-LOC-CD                                   
             WHEN 'P'                                                   
             WHEN 'Z'                                                   
               MOVE WS-CPD99-PREMISE-NO   TO PR-PREMISE-NO              
               PERFORM 7350-GET-PREMISE-DET    THRU  7350-EXIT          
               MOVE WS-CPD99-ACCOUNT-NO   TO MN-ACCOUNT-NO              
               PERFORM 7375-GET-POINT-ID-DET   THRU  7375-EXIT          
               MOVE WS-CPD99-ACCOUNT-NO   TO HT-ACCOUNT-NO              
               PERFORM 7400-GET-CUSTOMER-NAME  THRU  7400-EXIT          
               PERFORM 3000-GET-CUST-ADDRESS   THRU  3000-EXIT          
               IF 4F-INSTALL-LOC-CD = 'Z'                               
                  MOVE WS-CPD99-ACCOUNT-NO TO UT-ACCOUNT-NO             
                  MOVE WS-CPD99-PREMISE-NO TO UT-PREMISE-NO             
                  MOVE 4F-CODE-UTIL-TYPE   TO UT-CODE-UTIL-TYPE         
                  MOVE 4F-RATE-PLAN-NO     TO UT-RATE-PLAN-NO           
                  MOVE 4F-RATE-ITEM-CODE   TO CP-RATE-ITEM-CODE         
                  PERFORM 7525-GET-CUST-PLAN-DATA THRU 7525-EXIT        
               END-IF                                                   
             WHEN 'S'                                                   
               MOVE 4F-INSTALL-LOC-NO(1:3)                              
                                          TO ZS-SUBDIVISION-ID          
               PERFORM 7475-GET-ZIPCODE-SUBDIV-DATA  THRU 7475-EXIT     
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 2520-MOVE-RESULT-LOCATION THRU 2520-EXIT.            
      *                                                                         
           IF 4F-INSTALL-LOC-CD = 'Z'                                   
              PERFORM 7025-FETCH-SPCL-AGR-CUR THRU 7025-EXIT            
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE CONTRACT INFO                                **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-CONTRACT.                                           
      *                                                                         
           MOVE '2300'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 4F-INSTALL-LOC-NO         TO 4L-INSTALL-LOC-NO.         
           IF 4F-INSTALL-LOC-CD = 'P'                                   
              MOVE WS-CPD99-ACCOUNT-NO    TO 4L-ACCOUNT-NO              
           ELSE                                                         
              MOVE 0                      TO 4L-ACCOUNT-NO              
           END-IF.                                                      
           PERFORM 7500-GET-CONTRACT-DET    THRU  7500-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2560-MOVE-RESULT-CNTRCT  THRU  2560-EXIT          
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS FIXTURE ATTACHMENTS - POLE / NODE                    **        
      ******************************************************************        
      *                                                                         
       2400-PROCESS-FXTR-ATTCHMNTS.                                     
      *                                                                         
           MOVE '2400'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 7100-OPEN-FXTR-ATCH-CUR     THRU  7100-EXIT.         
           PERFORM 7125-FETCH-FXTR-ATCH-CUR    THRU  7125-EXIT.         
           PERFORM 2425-PROCESS-POLE-NODE-DET  THRU  2425-EXIT          
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7150-CLOSE-FXTR-ATCH-CUR    THRU  7150-EXIT.         
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS POLE - ATTACHMENT, INVENTORY & ENVIRONMENT INFO      **        
      ** PROCESS NODE - ATTACHMENT & INVENTORY INFO                   **        
      ******************************************************************        
      *                                                                         
       2425-PROCESS-POLE-NODE-DET.                                      
      *                                                                         
           MOVE '2425'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        DCLLMS-EQUIP-INVENTRY      
                                             DCLLMS-EQUIP-ENVRNMT       
                                             UT-CODE-REVENUE-CLASS      
                                             WS-FXTR-LIST               
                                             WS-FXTR-POLE-ROW-COUNT     
                                             WS-MSG-FXTR-COUNT          
                                             WS-MSG-FXTR-TEXT           
                                             WS-MSG-FXTR-TEXT-TEMP.     
      *                                                                         
      **** POLE / NODE INVENTORY DATA                                           
           MOVE 4H-ATTACH-EQUIP-SEQ       TO 4D-EQUIP-SEQ.              
           MOVE 4H-EQUIP-TYPE-CD          TO 4D-EQUIP-TYPE-CD.          
           PERFORM 7200-GET-EQUIP-INV-DET  THRU  7200-EXIT.             
      *                                                                         
           IF 4H-EQUIP-TYPE-CD = 'P'                                    
              MOVE 4H-ATTACH-EQUIP-SEQ    TO 4F-EQUIP-SEQ               
              PERFORM 7250-GET-EQUIP-ENV-DET  THRU  7250-EXIT           
              IF 4F-INSTALL-LOC-CD = 'P'                                
                 MOVE WS-CPD99-ACCOUNT-NO TO UT-ACCOUNT-NO              
                 MOVE WS-CPD99-PREMISE-NO TO UT-PREMISE-NO              
                 MOVE 4F-CODE-UTIL-TYPE   TO UT-CODE-UTIL-TYPE          
                 MOVE 4F-IC-NO            TO UT-IC-NO                   
                 MOVE 4F-RATE-PLAN-NO     TO UT-RATE-PLAN-NO            
                 PERFORM 7300-GET-UTIL-ENV-DATA  THRU  7300-EXIT        
      **** GET ALL FIXTURES HAVING SAME POLE NUMBER                             
                 IF 4D-EQUIP-TAG-NO > SPACES                            
                    PERFORM 2450-GET-FXTR-SAME-POLE-NO-DET              
                       THRU 2450-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
              PERFORM 2540-MOVE-RESULT-POLE  THRU  2540-EXIT            
           ELSE                                                         
              PERFORM 2580-MOVE-RESULT-NODE  THRU  2580-EXIT            
           END-IF.                                                      
      *                                                                         
           INITIALIZE                        4H-ATTACH-SEQ-NO           
                                             4H-EQUIP-TYPE-CD           
                                             4H-ATTACH-EQUIP-SEQ        
                                             4H-ATTACH-EQUIP-DT.        
      *                                                                         
           PERFORM 7125-FETCH-FXTR-ATCH-CUR   THRU  7125-EXIT.          
      *                                                                         
       2425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET FIXTURE ID'S OF ALL THE FIXTURS HAVING SAME POLE #       **        
      ******************************************************************        
      *                                                                         
       2450-GET-FXTR-SAME-POLE-NO-DET.                                  
      *                                                                         
           MOVE '2450'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 7600-OPEN-FXTR-POLE-CUR     THRU  7600-EXIT.         
           PERFORM 7625-FETCH-FXTR-POLE-CUR    THRU  7625-EXIT.         
           PERFORM 7650-CLOSE-FXTR-POLE-CUR    THRU  7650-EXIT.         
      *                                                                         
           MOVE WS-FXTR-POLE-ROW-COUNT    TO WS-MSG-FXTR-COUNT.         
                                                                        
           IF WS-FXTR-POLE-ROW-COUNT > 0                                
              STRING WS-FXTR-TAG-NO (1) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (2) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (3) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (4) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (5) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (6) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (7) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (8) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (9) DELIMITED BY SPACE              
                     ','                DELIMITED BY SIZE               
                     WS-FXTR-TAG-NO (10) DELIMITED BY SPACE             
                INTO WS-MSG-FXTR-TEXT-TEMP                              
              UNSTRING WS-MSG-FXTR-TEXT-TEMP DELIMITED BY ',,'          
                  INTO WS-MSG-FXTR-TEXT                                 
           END-IF.                                                      
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND FIXTURE RESULT SET                               **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT-FXTR.                                           
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 4D-EQUIP-SEQ              TO S-F-EQUIP-SEQ.             
           MOVE 4D-EQUIP-TAG-NO           TO S-F-EQUIP-TAG-NO.          
           MOVE 4D-COMPANY-NO             TO S-F-COMPANY-NO.            
           MOVE 4D-CODE-SERVICE-TYPE      TO S-F-CODE-SERVICE-TYPE.     
           MOVE 4D-STOCK-CD               TO S-F-STOCK-CD.              
           MOVE 4D-EQUIP-MFR-CD           TO S-F-EQUIP-MFR-CD.          
           MOVE 4D-EQUIP-MFR-DT           TO S-F-EQUIP-MFR-DT.          
           MOVE 4D-WARRANTY-EXP-DT        TO S-F-WARRANTY-EXP-DT.       
           MOVE 4D-EQUIP-DISPOSAL-DT      TO S-F-EQUIP-DISPOSAL-DT.     
           MOVE 4D-STORAGE-FAC-CD         TO S-F-STORAGE-FAC-CD.        
      *                                                                         
      *** SHOW INTRANSIT OR RECVD IN VENDOR FILE AS IN INVENTORY                
      *                                                                         
           MOVE 4D-INVENTRY-STATUS-CD     TO S-F-INVENTRY-STATUS-CD.    
           IF 4D-INVENTRY-STATUS-CD NOT = 'J' AND                       
              4D-INVENTRY-STATUS-CD NOT = 'S' AND                       
              4D-INVENTRY-STATUS-CD NOT = 'M'                           
              MOVE 'I'                    TO S-F-INVENTRY-STATUS-CD     
           END-IF.                                                      
      *                                                                         
           MOVE 4D-WRNTY-RECEIVED-FL      TO S-F-WRNTY-RECEIVED-FL.     
           MOVE 4D-WRNTY-RECOUP-AMT       TO S-F-WRNTY-RECOUP-AMT.      
      *                                                                         
           IF 4D-INVENTRY-STATUS-CD = 'J'                               
              MOVE 4F-INSTALL-LOC-NO      TO S-F-INSTALL-LOC-NO         
              MOVE 4F-INSTALL-POINT-NO    TO S-F-INSTALL-POINT-NO       
              MOVE 4F-INSTALL-LOC-CD      TO S-F-INSTALL-LOC-CD         
              MOVE 4F-CODE-UTIL-TYPE      TO S-F-CODE-UTIL-TYPE         
              MOVE 4F-IC-NO               TO S-F-IC-NO                  
              MOVE 4F-RATE-PLAN-NO        TO S-F-RATE-PLAN-NO           
              MOVE 4F-RATE-ITEM-CODE      TO S-F-RATE-ITEM-CODE         
              MOVE 4F-ITEM-SEQ-NO         TO S-F-ITEM-SEQ-NO            
              MOVE 4F-BILLING-FL          TO S-F-BILLING-FL             
              MOVE 4F-NO-BILL-REASON-CD   TO S-F-NO-BILL-REASON-CD      
              MOVE 4F-EQUIP-CONTRACT-FL   TO S-F-EQUIP-CONTRACT-FL      
              MOVE 4F-NO-CONTRACT-RSN-CD  TO S-F-NO-CONTRACT-RSN-CD     
              MOVE 4F-EQUIP-OWNER-CD      TO S-F-EQUIP-OWNER-CD         
              MOVE 4F-EQUIP-DRAWING-ID    TO S-F-EQUIP-DRAWING-ID       
              MOVE 4F-SOURCE-APPL-CD      TO S-F-SOURCE-APPL-CD         
              MOVE 4F-SOURCE-APPL-REQ-NO  TO S-F-SOURCE-APPL-REQ-NO     
              MOVE 4F-WMS-POINT-NO        TO S-F-WMS-POINT-NO           
              MOVE 4F-EQUIP-INSTALL-DT    TO S-F-EQUIP-INSTALL-DT       
              MOVE 4F-SPCL-AGR-COMMENTS-TEXT                            
                                          TO S-F-SPCL-AGR-COMMENTS      
              MOVE 4F-EQUIP-COMMENTS-TEXT TO S-F-EQUIP-COMMENTS         
              IF 4F-INSTALL-LOC-CD = 'P'                                
                 MOVE UT-CODE-REVENUE-CLASS                             
                                          TO S-F-CODE-REVENUE-CLASS     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EVALUATE 4D-EQUIP-TAG-NO(1:1)                                
             WHEN WS-CONV-TAG-1ST-CHAR                                  
               MOVE WS-CONV-TAG-1ST-CHAR  TO S-F-TAG-TYPE-CD            
             WHEN WS-SCEG-TAG-1ST-CHAR                                  
               MOVE WS-SCEG-TAG-1ST-CHAR  TO S-F-TAG-TYPE-CD            
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-WMS-INSTALL-COUNT      TO S-F-WMS-INSTALL-COUNT.     
      *                                                                         
           PERFORM 8100A-SEND-RESULT-FXTR  THRU  8100A-EXIT.            
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND LOCATION RESULT SET                              **        
      ******************************************************************        
      *                                                                         
       2520-MOVE-RESULT-LOCATION.                                       
      *                                                                         
           MOVE '2520'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EVALUATE 4F-INSTALL-LOC-CD                                   
             WHEN 'P'                                                   
             WHEN 'Z'                                                   
               MOVE WS-CPD99-ACCOUNT-NO   TO S-L-ACCOUNT-NO             
               MOVE WS-CPD99-PREMISE-NO   TO S-L-PREMISE-NO             
               MOVE PR-REV-DISTRICT-CD    TO S-L-REV-DISTRICT-CD        
               MOVE PR-SUBDIVISION-ID     TO S-L-SUBDIVISION-ID         
               MOVE SPACES                TO S-L-SUB-DIV-ZIP-CD         
               MOVE PP-AREA-ID            TO S-L-POINT-ID(1:3)          
               MOVE PP-TAG-NM             TO S-L-POINT-ID(4:7)          
               MOVE DQ-FULL-NAME          TO S-L-CUSTOMER-NAME          
               STRING WS-ADDRESS-LINE1 DELIMITED BY '   '  ' '          
                      WS-ADDRESS-LINE2 DELIMITED BY '   '               
                 INTO S-L-ADDRESS                                       
               IF 4F-INSTALL-LOC-CD = 'Z'                               
                  MOVE CP-USAGE-FIXED     TO S-L-USAGE-FIXED            
               END-IF                                                   
A05084         MOVE AT-CODE-ACCT-STAT     TO S-L-CODE-ACCT-STAT         
             WHEN 'S'                                                   
               MOVE ZS-REV-DISTRICT-CD    TO S-L-REV-DISTRICT-CD        
               MOVE ZS-SUBDIVISION-ID     TO S-L-SUBDIVISION-ID         
               MOVE ZS-ZIP-CODE           TO S-L-SUB-DIV-ZIP-CD         
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 8100B-SEND-RESULT-LOC  THRU  8100B-EXIT.             
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-LOC.     
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND POLE RESULT SET                                  **        
      ******************************************************************        
      *                                                                         
       2540-MOVE-RESULT-POLE.                                           
      *                                                                         
           MOVE '2540'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 4H-ATTACH-EQUIP-SEQ       TO S-P-EQUIP-SEQ.             
           MOVE 4H-ATTACH-SEQ-NO          TO S-P-ATTACH-SEQ-NO.         
      *                                                                         
           MOVE 4D-EQUIP-TAG-NO           TO S-P-EQUIP-TAG-NO.          
           MOVE 4D-COMPANY-NO             TO S-P-COMPANY-NO.            
           MOVE 4D-CODE-SERVICE-TYPE      TO S-P-CODE-SERVICE-TYPE.     
           MOVE 4D-STOCK-CD               TO S-P-STOCK-CD.              
           MOVE 4D-INVENTRY-STATUS-CD     TO S-P-INVENTRY-STATUS-CD.    
      *                                                                         
           MOVE 4F-INSTALL-POINT-NO       TO S-P-INSTALL-POINT-NO.      
           MOVE 4F-CODE-UTIL-TYPE         TO S-P-CODE-UTIL-TYPE.        
           MOVE 4F-IC-NO                  TO S-P-IC-NO.                 
           MOVE 4F-RATE-PLAN-NO           TO S-P-RATE-PLAN-NO.          
           MOVE 4F-RATE-ITEM-CODE         TO S-P-RATE-ITEM-CODE.        
           MOVE 4F-ITEM-SEQ-NO            TO S-P-ITEM-SEQ-NO.           
           MOVE 4F-BILLING-FL             TO S-P-BILLING-FL.            
           MOVE 4F-NO-BILL-REASON-CD      TO S-P-NO-BILL-REASON-CD.     
           MOVE 4F-EQUIP-OWNER-CD         TO S-P-EQUIP-OWNER-CD.        
           MOVE 4F-EQUIP-INSTALL-DT       TO S-P-EQUIP-INSTALL-DT.      
           MOVE WS-MSG-FXTR-COUNT         TO S-P-MSG-FXTR-COUNT.        
           MOVE WS-MSG-FXTR-TEXT          TO S-P-MSG-FXTR-TEXT.         
      *                                                                         
           IF 4F-INSTALL-LOC-CD = 'P'                                   
              MOVE UT-CODE-REVENUE-CLASS  TO S-P-CODE-REVENUE-CLASS     
           END-IF.                                                      
      *                                                                         
           PERFORM 8100C-SEND-RESULT-POLE  THRU  8100C-EXIT.            
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-POLE.    
      *                                                                         
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND CONTRACT RESULT SET                              **        
      ******************************************************************        
      *                                                                         
       2560-MOVE-RESULT-CNTRCT.                                         
      *                                                                         
           MOVE '2560'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 4L-ACCOUNT-NO             TO S-C-ACCOUNT-NO.            
           MOVE 4L-CNTRCT-START-DT        TO S-C-CNTRCT-START-DT.       
           MOVE 4L-CNTRCT-END-DT          TO S-C-CNTRCT-END-DT.         
           MOVE 4L-CNTRCT-DURATION-CD     TO S-C-CNTRCT-DURATION-CD.    
           MOVE 4L-FIXTURE-COST-AM        TO S-C-FIXTURE-COST-AM.       
           MOVE 4L-POLE-COST-AM           TO S-C-POLE-COST-AM.          
           MOVE 4L-ORIG-TERM-CHRG-AM      TO S-C-ORIG-TERM-CHRG-AM.     
           MOVE 4L-ACTL-TERM-CHRG-AM      TO S-C-ACTL-TERM-CHRG-AM.     
           MOVE 4L-ACTL-CHRG-DT           TO S-C-ACTL-CHRG-DT.          
           MOVE 4L-CNTRCT-CLP-NO          TO S-C-CNTRCT-CLP-NO.         
           MOVE 4L-CNTRCT-STATUS-CD       TO S-C-CNTRCT-STATUS-CD.      
      *                                                                         
           IF 4L-CNTRCT-STATUS-CD = 'A' AND                             
              4L-CNTRCT-DURATION-CD NOT = '64'                          
              INITIALIZE                     CPDLM3-INPUT               
              MOVE 'F'                    TO CPDLM3-CALL-TYPE           
              MOVE 4L-EQUIP-SEQ           TO CPDLM3-FXTR-SEQ            
              MOVE 4L-INSTALL-LOC-NO      TO CPDLM3-INSTALL-LOC-NO      
              MOVE 4L-ACCOUNT-NO          TO CPDLM3-ACCOUNT-NO          
              MOVE 'N'                    TO CPDLM3-UPDATE-FL           
              PERFORM 6000-CPDLM3-LIGHT-CNTRCT-TERM                     
                 THRU 6000-CPDLM3-EXIT                                  
              IF CPDLM3-ERROR                                           
                 PERFORM 6999-CPDLM3-SEND-ERROR-RESULT                  
                    THRU 6999-CPDLM3-EXIT                               
              END-IF                                                    
              MOVE CPDLM3-TOTAL-CHRG-AM   TO S-C-CALC-TERM-CHRG-AM      
           END-IF.                                                      
      *                                                                         
           PERFORM 8100D-SEND-RESULT-CNTRCT  THRU  8100D-EXIT.          
      *                                                                         
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE & SEND NODE RESULT SET                                  **        
      ******************************************************************        
      *                                                                         
       2580-MOVE-RESULT-NODE.                                           
      *                                                                         
           MOVE '2580'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 4H-ATTACH-EQUIP-SEQ       TO S-N-EQUIP-SEQ.             
           MOVE 4H-ATTACH-SEQ-NO          TO S-N-ATTACH-SEQ-NO.         
      *                                                                         
           MOVE 4D-EQUIP-TAG-NO           TO S-N-EQUIP-TAG-NO.          
           MOVE 4D-COMPANY-NO             TO S-N-COMPANY-NO.            
           MOVE 4D-CODE-SERVICE-TYPE      TO S-N-CODE-SERVICE-TYPE.     
           MOVE 4D-STOCK-CD               TO S-N-STOCK-CD.              
           MOVE 4D-EQUIP-MFR-CD           TO S-N-EQUIP-MFR-CD.          
           MOVE 4D-EQUIP-MFR-DT           TO S-N-EQUIP-MFR-DT.          
           MOVE 4D-WARRANTY-EXP-DT        TO S-N-WARRANTY-EXP-DT.       
           MOVE 4D-INVENTRY-STATUS-CD     TO S-N-INVENTRY-STATUS-CD.    
      *                                                                         
           PERFORM 8100E-SEND-RESULT-NODE  THRU  8100E-EXIT.            
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-NODE.    
      *                                                                         
       2580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2900-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2900'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-FXTR = 0                                         
              INITIALIZE                     GTT-RETURN-FIELDS-FXTR     
              MOVE 100                    TO S-F-RETURN-CODE            
              PERFORM 8100A-SEND-RESULT-FXTR  THRU  8100A-EXIT          
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-LOC = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-LOC      
              MOVE 100                    TO S-L-RETURN-CODE            
              PERFORM 8100B-SEND-RESULT-LOC  THRU  8100B-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-POLE = 0                                         
              INITIALIZE                     GTT-RETURN-FIELDS-POLE     
              MOVE 100                    TO S-P-RETURN-CODE            
              PERFORM 8100C-SEND-RESULT-POLE  THRU  8100C-EXIT          
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-CNTRCT = 0                                       
              INITIALIZE                     GTT-RETURN-FIELDS-CNTRCT   
              MOVE 100                    TO S-C-RETURN-CODE            
              PERFORM 8100D-SEND-RESULT-CNTRCT  THRU  8100D-EXIT        
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-NODE = 0                                         
              INITIALIZE                     GTT-RETURN-FIELDS-NODE     
              MOVE 100                    TO S-N-RETURN-CODE            
              PERFORM 8100E-SEND-RESULT-NODE  THRU  8100E-EXIT          
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET ADDRESS USING PREMISE ADDR ID                            **        
      ******************************************************************        
      *                                                                         
       3000-GET-CUST-ADDRESS.                                           
      *                                                                         
           MOVE '3000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        DCLCSS-ADDR-FORMATTED      
                                             A4-ZIP-CODE                
                                             A4-ZIP-CODE-TOKEN          
                                             A4-TOWN                    
                                             A4-STATE                   
                                             WS-ADDRESS.                
      *                                                                         
           MOVE PR-ADDRESS-ID             TO DY-ADDRESS-ID.             
      *                                                                         
           PERFORM 7425-GET-FORMATTED-ADDR  THRU  7425-EXIT.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 3100-FORMAT-ADDRESS   THRU 3100-EXIT              
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FORMAT ADDRESS FIELDS                                        **        
      ******************************************************************        
      *                                                                         
       3100-FORMAT-ADDRESS.                                             
      *                                                                         
           MOVE '3100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE SPACES                    TO WS-IN-STRING               
                                             WS-OUT-STRING.             
           MOVE DY-HOUSE-NO               TO WS-HOUSE-NO.               
           MOVE DY-ADDR-PREFIX-1          TO WS-ADDR-PREFIX-1.          
           MOVE DY-ADDR-PREFIX-2          TO WS-ADDR-PREFIX-2.          
           MOVE DY-STREET-NAME            TO WS-NAME-STREET.            
           MOVE DY-STREET-SUFFIX          TO WS-STREET-SUFFIX.          
           MOVE DY-STREET-LOCATION-1      TO WS-STREET-LOCATION-1.      
           MOVE DY-STREET-LOCATION-2      TO WS-STREET-LOCATION-2.      
           MOVE DY-ADDR-SUFFIX            TO WS-ADDRESS-SUFFIX.         
           MOVE WS-STREET-ADDRESS         TO WS-IN-STRING.              
           MOVE 82                        TO WS-CHAR-LENGTH.            
           PERFORM 3200-REDUCE-EMBED-SPACES  THRU  3200-EXIT.           
           MOVE WS-OUT-STRING             TO WS-ADDRESS-LINE1.          
      *                                                                         
           MOVE SPACES                    TO WS-IN-STRING               
                                             WS-OUT-STRING.             
           MOVE DY-ZIP-CODE               TO A4-ZIP-CODE                
                                             WS-ZIP-CODE.               
           MOVE DY-ZIP-CODE-TOKEN         TO A4-ZIP-CODE-TOKEN.         
ACT067*    IF DY-ZIP-CODE-PLUS-FOUR > SPACES                                    
ACT067*       MOVE '-'                    TO WS-ZIP-DASH                        
ACT067*       MOVE DY-ZIP-CODE-PLUS-FOUR  TO WS-ZIP-PLUS-4                      
ACT067*    END-IF.                                                              
           MOVE ' *'                      TO WS-ZIP-FILLER.             
      *                                                                         
           PERFORM 7450-GET-ZIP-CODE-DET  THRU  7450-EXIT.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                TO WS-STATE                    
              MOVE 'UNKNOWN *'           TO WS-CITY                     
           ELSE                                                         
              MOVE A4-STATE              TO WS-STATE                    
              MOVE A4-TOWN               TO WS-CITY                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-CITY-STATE            TO WS-IN-STRING.               
           MOVE 41                       TO WS-CHAR-LENGTH.             
           PERFORM 3200-REDUCE-EMBED-SPACES THRU 3200-EXIT.             
           MOVE WS-OUT-STRING            TO WS-ADDRESS-LINE2.           
      *                                                                         
           INSPECT WS-ADDRESS-LINE2    REPLACING ALL '*' BY SPACES.     
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REDUCE EMBEDED FIELDS                                        **        
      ******************************************************************        
      *                                                                         
       3200-REDUCE-EMBED-SPACES.                                        
      *                                                                         
           MOVE '3200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           SET WS-OUT-INDX                TO 1.                         
           MOVE SPACES                    TO WS-LAST-CHAR.              
      *                                                                         
           PERFORM VARYING WS-IN-INDX FROM 1 BY 1                       
             UNTIL WS-IN-INDX > WS-CHAR-LENGTH                          
             EVALUATE TRUE                                              
                WHEN WS-IN-CHAR (WS-IN-INDX) = LOW-VALUES               
                     CONTINUE                                           
                WHEN WS-IN-CHAR (WS-IN-INDX) = SPACES                   
                     AND WS-LAST-CHAR = SPACES                          
                     CONTINUE                                           
                WHEN OTHER                                              
                     MOVE WS-IN-CHAR (WS-IN-INDX) TO WS-LAST-CHAR       
                          WS-OUT-CHAR (WS-OUT-INDX)                     
                     SET WS-OUT-INDX UP BY 1                            
             END-EVALUATE                                               
           END-PERFORM.                                                 
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6990-FETCH-CUR-ACCOUNT                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00099                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 6995-CPD99-ERROR-ROUTINE                                     **        
      ******************************************************************        
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           MOVE PROGRAM-NAME             TO ABEND-PROGRAM.              
           MOVE WS-CPD99-RETURN-CODE     TO WS-ACTIVE-RETURN-CODE.      
           PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT.             
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6000-CPDLM3-LIGHT-CNTRCT-TERM                                **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDLM003                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** ABEND PARA FOR LIGHT CONTRACT TERMINATION CHARGES COPYBOOK   **        
      ******************************************************************        
      *                                                                         
       6999-CPDLM3-SEND-ERROR-RESULT.                                   
      *                                                                         
           MOVE CPDLM3-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE.      
           PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT.             
      *                                                                         
       6999-CPDLM3-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN FIXTURE SPECIAL AGREEMENTS CURSOR                       **        
      ******************************************************************        
      *                                                                         
       7000-OPEN-SPCL-AGR-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
                OPEN SPCL_AGR_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_SPCL_AGREEMENT'  TO TABLE-1                     
              MOVE 'AGREEMENT_NO'        TO TABLE-ELEMENT-1             
              MOVE 4Q-AGREEMENT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH FIXTURE SPECIAL AGREEMENTS CURSOR                      **        
      ******************************************************************        
      *                                                                         
       7025-FETCH-SPCL-AGR-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH SPCL_AGR_CUR                                       
                INTO :4Q-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7025'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_SPCL_AGREEMENT'  TO TABLE-1                     
              MOVE 'AGREEMENT_NO'        TO TABLE-ELEMENT-1             
              MOVE 4Q-AGREEMENT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE FIXTURE SPECIAL AGREEMENTS CURSOR                      **        
      ******************************************************************        
      *                                                                         
       7050-CLOSE-SPCL-AGR-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE SPCL_AGR_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_SPCL_AGREEMENT'  TO TABLE-1                     
              MOVE 'AGREEMENT_NO'        TO TABLE-ELEMENT-1             
              MOVE 4Q-AGREEMENT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN FIXTURE ATTACHMENTS CURSOR                              **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-FXTR-ATCH-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
                OPEN FXTR_ATCH_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_FXTR_ATTACHMTS'  TO TABLE-1                     
              MOVE 'FXTR_EQUIP_SEQ'      TO TABLE-ELEMENT-1             
              MOVE 4H-FXTR-EQUIP-SEQ     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH FIXTURE ATTACHMENTS CURSOR                             **        
      ******************************************************************        
      *                                                                         
       7125-FETCH-FXTR-ATCH-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH FXTR_ATCH_CUR                                      
                INTO :4H-ATTACH-SEQ-NO                                  
                    ,:4H-EQUIP-TYPE-CD                                  
                    ,:4H-ATTACH-EQUIP-SEQ                               
                    ,:4H-ATTACH-EQUIP-DT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7125'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_FXTR_ATTACHMTS'  TO TABLE-1                     
              MOVE 'FXTR_EQUIP_SEQ'      TO TABLE-ELEMENT-1             
              MOVE 4H-FXTR-EQUIP-SEQ     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE FIXTURE ATTACHMENTS CURSOR                             **        
      ******************************************************************        
      *                                                                         
       7150-CLOSE-FXTR-ATCH-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE FXTR_ATCH_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_FXTR_ATTACHMTS'  TO TABLE-1                     
              MOVE 'FXTR_EQUIP_SEQ'      TO TABLE-ELEMENT-1             
              MOVE 4H-FXTR-EQUIP-SEQ     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  EQUIPMENT INVENTORY DATA                                    **        
      ******************************************************************        
      *                                                                         
       7200-GET-EQUIP-INV-DET.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4D].EQUIP_TAG_NO                                   
                     ,[4D].COMPANY_NO                                     
                     ,[4D].CODE_SERVICE_TYPE                              
                     ,[4D].STOCK_CD                                       
                     ,[4D].EQUIP_MFR_CD                                   
                     ,[4D].EQUIP_MFR_DT                                   
                     ,[4D].WARRANTY_EXP_DT                                
                     ,[4D].EQUIP_DISPOSAL_DT                              
                     ,[4D].STORAGE_FAC_CD                                 
                     ,[4D].INVENTRY_STATUS_CD                             
                     ,[4D].WRNTY_RECEIVED_FL                              
                     ,[4D].WRNTY_RECOUP_AMT                               
                INTO :4D-EQUIP-TAG-NO                                   
                    ,:4D-COMPANY-NO                                     
                    ,:4D-CODE-SERVICE-TYPE                              
                    ,:4D-STOCK-CD                                       
                    ,:4D-EQUIP-MFR-CD                                   
                    ,:4D-EQUIP-MFR-DT :IND-EQUIP-MFR-DT                  
                    ,:4D-WARRANTY-EXP-DT :IND-WARRANTY-EXP-DT            
                    ,:4D-EQUIP-DISPOSAL-DT :IND-DISPOSAL-DT              
                    ,:4D-STORAGE-FAC-CD                                 
                    ,:4D-INVENTRY-STATUS-CD                             
                    ,:4D-WRNTY-RECEIVED-FL                              
                    ,:4D-WRNTY-RECOUP-AMT                               
               FROM  LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
              WHERE  [4D].EQUIP_SEQ      =  :4D-EQUIP-SEQ                 
                AND  [4D].EQUIP_TYPE_CD  =  :4D-EQUIP-TYPE-CD             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4D.EQUIP_TAG_NO                                           
MFA-TR*              ,4D.COMPANY_NO                                             
MFA-TR*              ,4D.CODE_SERVICE_TYPE                                      
MFA-TR*              ,4D.STOCK_CD                                               
MFA-TR*              ,4D.EQUIP_MFR_CD                                           
MFA-TR*              ,4D.EQUIP_MFR_DT                                           
MFA-TR*              ,4D.WARRANTY_EXP_DT                                        
MFA-TR*              ,4D.EQUIP_DISPOSAL_DT                                      
MFA-TR*              ,4D.STORAGE_FAC_CD                                         
MFA-TR*              ,4D.INVENTRY_STATUS_CD                                     
MFA-TR*              ,4D.WRNTY_RECEIVED_FL                                      
MFA-TR*              ,4D.WRNTY_RECOUP_AMT                                       
MFA-TR*         INTO :4D-EQUIP-TAG-NO                                           
MFA-TR*             ,:4D-COMPANY-NO                                             
MFA-TR*             ,:4D-CODE-SERVICE-TYPE                                      
MFA-TR*             ,:4D-STOCK-CD                                               
MFA-TR*             ,:4D-EQUIP-MFR-CD                                           
MFA-TR*             ,:4D-EQUIP-MFR-DT:IND-EQUIP-MFR-DT                          
MFA-TR*             ,:4D-WARRANTY-EXP-DT:IND-WARRANTY-EXP-DT                    
MFA-TR*             ,:4D-EQUIP-DISPOSAL-DT:IND-DISPOSAL-DT                      
MFA-TR*             ,:4D-STORAGE-FAC-CD                                         
MFA-TR*             ,:4D-INVENTRY-STATUS-CD                                     
MFA-TR*             ,:4D-WRNTY-RECEIVED-FL                                      
MFA-TR*             ,:4D-WRNTY-RECOUP-AMT                                       
MFA-TR*        FROM  LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*       WHERE  4D.EQUIP_SEQ      =  :4D-EQUIP-SEQ                         
MFA-TR*         AND  4D.EQUIP_TYPE_CD  =  :4D-EQUIP-TYPE-CD                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF IND-EQUIP-MFR-DT    = WS-YES-NULL                      
                 MOVE SPACES                  TO 4D-EQUIP-MFR-DT        
              END-IF                                                    
              IF IND-WARRANTY-EXP-DT = WS-YES-NULL                      
                 MOVE SPACES                  TO 4D-WARRANTY-EXP-DT     
              END-IF                                                    
              IF IND-DISPOSAL-DT     = WS-YES-NULL                      
                 MOVE SPACES                  TO 4D-EQUIP-DISPOSAL-DT   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_INVENTRY'       TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 4D-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  EQUIPMENT ENVIRONMENT DATA                                  **        
      ******************************************************************        
      *                                                                         
       7250-GET-EQUIP-ENV-DET.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT  [4F].INSTALL_LOC_NO                                 
                     ,[4F].INSTALL_POINT_NO                               
                     ,[4F].INSTALL_LOC_CD                                 
                     ,[4F].CODE_UTIL_TYPE                                 
                     ,[4F].IC_NO                                          
                     ,[4F].RATE_PLAN_NO                                   
                     ,[4F].RATE_ITEM_CODE                                 
                     ,[4F].ITEM_SEQ_NO                                    
                     ,[4F].BILLING_FL                                     
                     ,[4F].NO_BILL_REASON_CD                              
                     ,[4F].EQUIP_CONTRACT_FL                              
                     ,[4F].NO_CONTRACT_RSN_CD                             
                     ,[4F].EQUIP_OWNER_CD                                 
                     ,[4F].EQUIP_DRAWING_ID                               
                     ,[4F].SOURCE_APPL_CD                                 
                     ,[4F].SOURCE_APPL_REQ_NO                             
                     ,[4F].WMS_POINT_NO                                   
                     ,[4F].EQUIP_INSTALL_DT                               
                     ,[4F].SPCL_AGR_COMMENTS                              
                     ,[4F].EQUIP_COMMENTS                                 
                INTO :4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-POINT-NO                               
                    ,:4F-INSTALL-LOC-CD                                 
                    ,:4F-CODE-UTIL-TYPE                                 
                    ,:4F-IC-NO                                          
                    ,:4F-RATE-PLAN-NO                                   
                    ,:4F-RATE-ITEM-CODE                                 
                    ,:4F-ITEM-SEQ-NO                                    
                    ,:4F-BILLING-FL                                     
                    ,:4F-NO-BILL-REASON-CD                              
                    ,:4F-EQUIP-CONTRACT-FL                              
                    ,:4F-NO-CONTRACT-RSN-CD                             
                    ,:4F-EQUIP-OWNER-CD                                 
                    ,:4F-EQUIP-DRAWING-ID                               
                    ,:4F-SOURCE-APPL-CD                                 
                    ,:4F-SOURCE-APPL-REQ-NO                             
                    ,:4F-WMS-POINT-NO                                   
                    ,:4F-EQUIP-INSTALL-DT :IND-INSTALL-DT                
                    ,:4F-SPCL-AGR-COMMENTS                              
                    ,:4F-EQUIP-COMMENTS                                 
               FROM  LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
              WHERE  [4F].EQUIP_SEQ  =  :4F-EQUIP-SEQ                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  4F.INSTALL_LOC_NO                                         
MFA-TR*              ,4F.INSTALL_POINT_NO                                       
MFA-TR*              ,4F.INSTALL_LOC_CD                                         
MFA-TR*              ,4F.CODE_UTIL_TYPE                                         
MFA-TR*              ,4F.IC_NO                                                  
MFA-TR*              ,4F.RATE_PLAN_NO                                           
MFA-TR*              ,4F.RATE_ITEM_CODE                                         
MFA-TR*              ,4F.ITEM_SEQ_NO                                            
MFA-TR*              ,4F.BILLING_FL                                             
MFA-TR*              ,4F.NO_BILL_REASON_CD                                      
MFA-TR*              ,4F.EQUIP_CONTRACT_FL                                      
MFA-TR*              ,4F.NO_CONTRACT_RSN_CD                                     
MFA-TR*              ,4F.EQUIP_OWNER_CD                                         
MFA-TR*              ,4F.EQUIP_DRAWING_ID                                       
MFA-TR*              ,4F.SOURCE_APPL_CD                                         
MFA-TR*              ,4F.SOURCE_APPL_REQ_NO                                     
MFA-TR*              ,4F.WMS_POINT_NO                                           
MFA-TR*              ,4F.EQUIP_INSTALL_DT                                       
MFA-TR*              ,4F.SPCL_AGR_COMMENTS                                      
MFA-TR*              ,4F.EQUIP_COMMENTS                                         
MFA-TR*         INTO :4F-INSTALL-LOC-NO                                         
MFA-TR*             ,:4F-INSTALL-POINT-NO                                       
MFA-TR*             ,:4F-INSTALL-LOC-CD                                         
MFA-TR*             ,:4F-CODE-UTIL-TYPE                                         
MFA-TR*             ,:4F-IC-NO                                                  
MFA-TR*             ,:4F-RATE-PLAN-NO                                           
MFA-TR*             ,:4F-RATE-ITEM-CODE                                         
MFA-TR*             ,:4F-ITEM-SEQ-NO                                            
MFA-TR*             ,:4F-BILLING-FL                                             
MFA-TR*             ,:4F-NO-BILL-REASON-CD                                      
MFA-TR*             ,:4F-EQUIP-CONTRACT-FL                                      
MFA-TR*             ,:4F-NO-CONTRACT-RSN-CD                                     
MFA-TR*             ,:4F-EQUIP-OWNER-CD                                         
MFA-TR*             ,:4F-EQUIP-DRAWING-ID                                       
MFA-TR*             ,:4F-SOURCE-APPL-CD                                         
MFA-TR*             ,:4F-SOURCE-APPL-REQ-NO                                     
MFA-TR*             ,:4F-WMS-POINT-NO                                           
MFA-TR*             ,:4F-EQUIP-INSTALL-DT:IND-INSTALL-DT                        
MFA-TR*             ,:4F-SPCL-AGR-COMMENTS                                      
MFA-TR*             ,:4F-EQUIP-COMMENTS                                         
MFA-TR*        FROM  LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*       WHERE  4F.EQUIP_SEQ  =  :4F-EQUIP-SEQ                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF IND-INSTALL-DT = WS-YES-NULL                           
                 MOVE SPACES                  TO 4F-EQUIP-INSTALL-DT    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_ENVRNMT'        TO TABLE-1                
              MOVE 'EQUIP_SEQ'                TO TABLE-ELEMENT-1        
              MOVE 4F-EQUIP-SEQ               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET ACCOUNT DETAILS                                          **        
      ******************************************************************        
      *                                                                         
       7260-GET-ACCT-DET.                                               
      *                                                                         
           EXEC SQL                                                     
             SELECT  AT.CODE_ACCT_STAT                                  
               INTO :AT-CODE-ACCT-STAT                                  
               FROM CSS_ACCOUNT    AT WITH(READUNCOMMITTED)                     
              WHERE AT.ACCOUNT_NO  =  :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  AT.CODE_ACCT_STAT                                          
MFA-TR*        INTO :AT-CODE-ACCT-STAT                                          
MFA-TR*        FROM CSS_ACCOUNT    AT                                           
MFA-TR*       WHERE AT.ACCOUNT_NO  =  :AT-ACCOUNT-NO                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7260                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET ACCOUNT DETAILS BASED ON PREMISE AND INPUT STATUS        **        
      ******************************************************************        
      *                                                                         
       7270-GET-ACCT-DET-USING-STAT.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) AT.ACCOUNT_NO                                       
               INTO :AT-ACCOUNT-NO                                      
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE AT.PREMISE_NO      =  :AT-PREMISE-NO                
                AND AT.CODE_ACCT_STAT  =  :AT-CODE-ACCT-STAT            
              ORDER BY ACCT_CREATE_DT DESC                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*       WHERE AT.PREMISE_NO      =  :AT-PREMISE-NO                        
MFA-TR*         AND AT.CODE_ACCT_STAT  =  :AT-CODE-ACCT-STAT                    
MFA-TR*       ORDER BY ACCT_CREATE_DT DESC                                      
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7270                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7270'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_ACCT_STAT'           TO TABLE-ELEMENT-2        
              MOVE AT-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AT-CODE-ACCT-STAT          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UTIL ENV DATA WITH CODE UTIL TYPE, IC                        **        
      ******************************************************************        
      *                                                                         
       7300-GET-UTIL-ENV-DATA.                                          
                                                                        
           EXEC SQL                                                     
             SELECT  UT.CODE_REVENUE_CLASS                              
               INTO :UT-CODE-REVENUE-CLASS                              
               FROM  CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
              WHERE UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO                
                AND UT.PREMISE_NO      =  :UT-PREMISE-NO                
                AND UT.CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE            
                AND UT.IC_NO           =  :UT-IC-NO                     
                AND UT.RATE_PLAN_NO    =  :UT-RATE-PLAN-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  UT.CODE_REVENUE_CLASS                                      
MFA-TR*        INTO :UT-CODE-REVENUE-CLASS                                      
MFA-TR*        FROM  CSS_UTIL_ENVRNMT  UT                                       
MFA-TR*       WHERE UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO                        
MFA-TR*         AND UT.PREMISE_NO      =  :UT-PREMISE-NO                        
MFA-TR*         AND UT.CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE                    
MFA-TR*         AND UT.IC_NO           =  :UT-IC-NO                             
MFA-TR*         AND UT.RATE_PLAN_NO    =  :UT-RATE-PLAN-NO                      
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'RATE-PLAN-NO'             TO TABLE-ELEMENT-4        
              MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UT-PREMISE-NO              TO HOSTVAR-ELEMENT-2      
              MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE UT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** WMS INSTALL REQUEST-COUNT OF INSTALL PENDING APPROVAL LIGHTS **        
      ******************************************************************        
      *                                                                         
       7325-GET-WMS-INSTALL-COUNT.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(COUNT(*),0)                                 
                INTO :WS-WMS-INSTALL-COUNT                              
               FROM  LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
                    ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
              WHERE  [4F].INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO         
                AND  [4F].INSTALL_LOC_CD     = :4F-INSTALL-LOC-CD         
                AND  [4F].BILLING_FL         = :4F-BILLING-FL             
                AND  [4F].SOURCE_APPL_CD     = :4F-SOURCE-APPL-CD         
                AND  [4F].SOURCE_APPL_REQ_NO = :4F-SOURCE-APPL-REQ-NO     
                AND  [4D].EQUIP_SEQ          =  [4F].EQUIP_SEQ              
                AND  [4D].EQUIP_TYPE_CD      = 'F'                        
              HAVING COUNT(*)  >=  2                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(COUNT(*),0)                                         
MFA-TR*         INTO :WS-WMS-INSTALL-COUNT                                      
MFA-TR*        FROM  LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*             ,LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*       WHERE  4F.INSTALL_LOC_NO     = :4F-INSTALL-LOC-NO                 
MFA-TR*         AND  4F.INSTALL_LOC_CD     = :4F-INSTALL-LOC-CD                 
MFA-TR*         AND  4F.BILLING_FL         = :4F-BILLING-FL                     
MFA-TR*         AND  4F.SOURCE_APPL_CD     = :4F-SOURCE-APPL-CD                 
MFA-TR*         AND  4F.SOURCE_APPL_REQ_NO = :4F-SOURCE-APPL-REQ-NO             
MFA-TR*         AND  4D.EQUIP_SEQ          =  4F.EQUIP_SEQ                      
MFA-TR*         AND  4D.EQUIP_TYPE_CD      = 'F'                                
MFA-TR*       HAVING COUNT(*)  >=  2                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7325                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7325'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LMS_EQUIP_ENVRNMT'        TO TABLE-1                
              MOVE 'INSTALL_LOC_NO'           TO TABLE-ELEMENT-1        
              MOVE 'INSTALL_LOC_CD'           TO TABLE-ELEMENT-2        
              MOVE 'BILLING_FL'               TO TABLE-ELEMENT-3        
              MOVE 4F-INSTALL-LOC-NO          TO HOSTVAR-ELEMENT-1      
              MOVE 4F-INSTALL-LOC-CD          TO HOSTVAR-ELEMENT-2      
              MOVE 4F-BILLING-FL              TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PREMISE DATA                                                 **        
      ******************************************************************        
      *                                                                         
       7350-GET-PREMISE-DET.                                            
      *                                                                         
           EXEC SQL                                                     
             SELECT  PR.SUBDIVISION_ID                                  
                    ,PR.ADDRESS_ID                                      
                    ,PR.REV_DISTRICT_CD                                 
               INTO :PR-SUBDIVISION-ID                                  
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-REV-DISTRICT-CD                                 
               FROM  CSS_PREMISE  PR WITH(READUNCOMMITTED)                      
              WHERE PR.PREMISE_NO = :PR-PREMISE-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  PR.SUBDIVISION_ID                                          
MFA-TR*             ,PR.ADDRESS_ID                                              
MFA-TR*             ,PR.REV_DISTRICT_CD                                         
MFA-TR*        INTO :PR-SUBDIVISION-ID                                          
MFA-TR*            ,:PR-ADDRESS-ID                                              
MFA-TR*            ,:PR-REV-DISTRICT-CD                                         
MFA-TR*        FROM  CSS_PREMISE  PR                                            
MFA-TR*       WHERE PR.PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE PR-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET POINT ID                                                 **        
      ******************************************************************        
      *                                                                         
       7375-GET-POINT-ID-DET.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) PP.AREA_ID,
              PP.TAG_NM                                          
               INTO :PP-AREA-ID                                         
                   ,:PP-TAG-NM                                          
               FROM  CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)                 
                    ,CSS_PIM_POINT     PP WITH(READUNCOMMITTED)                 
              WHERE MN.GIS_POINT_ID        =   PP.POINT_ID              
                AND MN.ACCOUNT_NO          =  :MN-ACCOUNT-NO            
                AND MN.CODE_UTIL_TYPE      =  'E'                       
                AND MN.CODE_METER_STATUS  <>  'K'                       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  PP.AREA_ID                                                 
MFA-TR*             ,PP.TAG_NM                                                  
MFA-TR*        INTO :PP-AREA-ID                                                 
MFA-TR*            ,:PP-TAG-NM                                                  
MFA-TR*        FROM  CSS_MTRD_ENVRNMT  MN                                       
MFA-TR*             ,CSS_PIM_POINT     PP                                       
MFA-TR*       WHERE MN.GIS_POINT_ID        =   PP.POINT_ID                      
MFA-TR*         AND MN.ACCOUNT_NO          =  :MN-ACCOUNT-NO                    
MFA-TR*         AND MN.CODE_UTIL_TYPE      =  'E'                               
MFA-TR*         AND MN.CODE_METER_STATUS  <>  'K'                               
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7375                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7375'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER NAME                                            **        
      ******************************************************************        
      *                                                                         
       7400-GET-CUSTOMER-NAME.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME        
                ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '         
                     THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '         
                          THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                 
                INTO  :DQ-FULL-NAME                                     
                FROM  CSS_NAME            DQ WITH(READUNCOMMITTED)              
                     ,CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
               WHERE  HT.ACCOUNT_NO        = :HT-ACCOUNT-NO             
                 AND  HT.NAME_ID           =  DQ.NAME_ID                
                 AND  DQ.NAME_TYPE         =  'CN'                      
                 AND  HT.CUSTOMER_ROLE_CD  =  ' '                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME                
MFA-TR*         ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                          
MFA-TR*              CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '                 
MFA-TR*              THEN '' ELSE ', '    END  ||                               
MFA-TR*                   STRIP(DQ.FIRST_NAME)           ||                     
MFA-TR*              CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '                 
MFA-TR*                   THEN '' ELSE ' '     END  ||                          
MFA-TR*                   STRIP(DQ.MIDDLE_NAME),70) END                         
MFA-TR*         INTO  :DQ-FULL-NAME                                             
MFA-TR*         FROM  CSS_NAME            DQ                                    
MFA-TR*              ,CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*        WHERE  HT.ACCOUNT_NO        = :HT-ACCOUNT-NO                     
MFA-TR*          AND  HT.NAME_ID           =  DQ.NAME_ID                        
MFA-TR*          AND  DQ.NAME_TYPE         =  'CN'                              
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD  =  ' '                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUSTOMER ADDRESS                                         **        
      ******************************************************************        
      *                                                                         
       7425-GET-FORMATTED-ADDR.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT  DY.HOUSE_NO                                        
                    ,DY.ADDR_PREFIX_1                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.STREET_NAME                                     
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDRESS_OVERFLOW                                
                    ,DY.CARRIER_ROUTE                                   
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,DY.ZIP_CODE_TOKEN                                  
                    ,DY.ADDR_SUFFIX                                     
               INTO :DY-HOUSE-NO                                        
                   ,:DY-ADDR-PREFIX-1                                   
                   ,:DY-ADDR-PREFIX-2                                   
                   ,:DY-STREET-NAME                                     
                   ,:DY-STREET-LOCATION-1                               
                   ,:DY-STREET-LOCATION-2                               
                   ,:DY-STREET-SUFFIX                                   
                   ,:DY-ADDRESS-OVERFLOW                                
                   ,:DY-CARRIER-ROUTE                                   
                   ,:DY-ZIP-CODE                                        
                   ,:DY-ZIP-CODE-PLUS-FOUR                              
                   ,:DY-ZIP-CODE-TOKEN                                  
                   ,:DY-ADDR-SUFFIX                                     
               FROM  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
              WHERE  DY.ADDRESS_ID  =  :DY-ADDRESS-ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DY.HOUSE_NO                                                
MFA-TR*             ,DY.ADDR_PREFIX_1                                           
MFA-TR*             ,DY.ADDR_PREFIX_2                                           
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDRESS_OVERFLOW                                        
MFA-TR*             ,DY.CARRIER_ROUTE                                           
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,DY.ZIP_CODE_TOKEN                                          
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*        INTO :DY-HOUSE-NO                                                
MFA-TR*            ,:DY-ADDR-PREFIX-1                                           
MFA-TR*            ,:DY-ADDR-PREFIX-2                                           
MFA-TR*            ,:DY-STREET-NAME                                             
MFA-TR*            ,:DY-STREET-LOCATION-1                                       
MFA-TR*            ,:DY-STREET-LOCATION-2                                       
MFA-TR*            ,:DY-STREET-SUFFIX                                           
MFA-TR*            ,:DY-ADDRESS-OVERFLOW                                        
MFA-TR*            ,:DY-CARRIER-ROUTE                                           
MFA-TR*            ,:DY-ZIP-CODE                                                
MFA-TR*            ,:DY-ZIP-CODE-PLUS-FOUR                                      
MFA-TR*            ,:DY-ZIP-CODE-TOKEN                                          
MFA-TR*            ,:DY-ADDR-SUFFIX                                             
MFA-TR*        FROM  CSS_ADDR_FORMATTED DY                                      
MFA-TR*       WHERE  DY.ADDRESS_ID  =  :DY-ADDRESS-ID                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7425                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '7425'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
              MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET TOWN, STATE USING ZIP CODE                               **        
      ******************************************************************        
      *                                                                         
       7450-GET-ZIP-CODE-DET.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT  A4.TOWN                                            
                    ,A4.STATE                                           
               INTO :A4-TOWN                                            
                   ,:A4-STATE                                           
               FROM  CSS_ZIP_CODE  A4 WITH(READUNCOMMITTED)                     
              WHERE  A4.ZIP_CODE       =  :A4-ZIP-CODE                  
                AND A4.ZIP_CODE_TOKEN  =  :A4-ZIP-CODE-TOKEN            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  A4.TOWN                                                    
MFA-TR*             ,A4.STATE                                                   
MFA-TR*        INTO :A4-TOWN                                                    
MFA-TR*            ,:A4-STATE                                                   
MFA-TR*        FROM  CSS_ZIP_CODE  A4                                           
MFA-TR*       WHERE  A4.ZIP_CODE       =  :A4-ZIP-CODE                          
MFA-TR*         AND A4.ZIP_CODE_TOKEN  =  :A4-ZIP-CODE-TOKEN                    
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '7450'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ZIP_CODE'        TO TABLE-1                     
              MOVE 'ZIP_CODE'            TO TABLE-ELEMENT-1             
              MOVE 'ZIP_CODE_TOKEN'      TO TABLE-ELEMENT-2             
              MOVE A4-ZIP-CODE           TO HOSTVAR-ELEMENT-1           
              MOVE A4-ZIP-CODE-TOKEN     TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET SUB DIVISION ZIP CODE DATA                               **        
      ******************************************************************        
      *                                                                         
       7475-GET-ZIPCODE-SUBDIV-DATA.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) ZS.REV_DISTRICT_CD,
              ZS.ZIP_CODE                                        
               INTO :ZS-REV-DISTRICT-CD                                 
                   ,:ZS-ZIP-CODE                                        
               FROM  CSS_ZIPCODE_SUBDIV  ZS WITH(READUNCOMMITTED)               
              WHERE ZS.SUBDIVISION_ID = :ZS-SUBDIVISION-ID              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  ZS.REV_DISTRICT_CD                                         
MFA-TR*             ,ZS.ZIP_CODE                                                
MFA-TR*        INTO :ZS-REV-DISTRICT-CD                                         
MFA-TR*            ,:ZS-ZIP-CODE                                                
MFA-TR*        FROM  CSS_ZIPCODE_SUBDIV  ZS                                     
MFA-TR*       WHERE ZS.SUBDIVISION_ID = :ZS-SUBDIVISION-ID                      
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7475                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7475'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'SUBDIVISION_ID'           TO TABLE-ELEMENT-1        
              MOVE ZS-SUBDIVISION-ID          TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7475-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET FIXTURE CONRACT DETAILS                                  **        
      ******************************************************************        
      *                                                                         
       7500-GET-CONTRACT-DET.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) [4L].CNTRCT_START_DT,
              [4L].CNTRCT_END_DT,
              [4L].CNTRCT_DURATION_CD,
              [4L].FIXTURE_COST_AM,
              [4L].POLE_COST_AM,
              [4L].ORIG_TERM_CHRG_AM,
              [4L].ACTL_TERM_CHRG_AM,
              [4L].ACTL_CHRG_DT,
              [4L].CNTRCT_CLP_NO,
              [4L].CNTRCT_STATUS_CD                                
               INTO :4L-CNTRCT-START-DT                                 
                   ,:4L-CNTRCT-END-DT                                   
                   ,:4L-CNTRCT-DURATION-CD                              
                   ,:4L-FIXTURE-COST-AM                                 
                   ,:4L-POLE-COST-AM                                    
                   ,:4L-ORIG-TERM-CHRG-AM                               
                   ,:4L-ACTL-TERM-CHRG-AM                               
                   ,:4L-ACTL-CHRG-DT :IND-ACTL-CHRG-DT                   
                   ,:4L-CNTRCT-CLP-NO                                   
                   ,:4L-CNTRCT-STATUS-CD                                
               FROM  LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)              
              WHERE  [4L].EQUIP_SEQ       =  :4L-EQUIP-SEQ                
                AND  [4L].INSTALL_LOC_NO  =  :4L-INSTALL-LOC-NO           
                AND  [4L].ACCOUNT_NO      =  :4L-ACCOUNT-NO               
             ORDER BY [4L].CNTRCT_START_DT DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  4L.CNTRCT_START_DT                                         
MFA-TR*             ,4L.CNTRCT_END_DT                                           
MFA-TR*             ,4L.CNTRCT_DURATION_CD                                      
MFA-TR*             ,4L.FIXTURE_COST_AM                                         
MFA-TR*             ,4L.POLE_COST_AM                                            
MFA-TR*             ,4L.ORIG_TERM_CHRG_AM                                       
MFA-TR*             ,4L.ACTL_TERM_CHRG_AM                                       
MFA-TR*             ,4L.ACTL_CHRG_DT                                            
MFA-TR*             ,4L.CNTRCT_CLP_NO                                           
MFA-TR*             ,4L.CNTRCT_STATUS_CD                                        
MFA-TR*        INTO :4L-CNTRCT-START-DT                                         
MFA-TR*            ,:4L-CNTRCT-END-DT                                           
MFA-TR*            ,:4L-CNTRCT-DURATION-CD                                      
MFA-TR*            ,:4L-FIXTURE-COST-AM                                         
MFA-TR*            ,:4L-POLE-COST-AM                                            
MFA-TR*            ,:4L-ORIG-TERM-CHRG-AM                                       
MFA-TR*            ,:4L-ACTL-TERM-CHRG-AM                                       
MFA-TR*            ,:4L-ACTL-CHRG-DT:IND-ACTL-CHRG-DT                           
MFA-TR*            ,:4L-CNTRCT-CLP-NO                                           
MFA-TR*            ,:4L-CNTRCT-STATUS-CD                                        
MFA-TR*        FROM  LMS_EQUIP_CONTRACT 4L                                      
MFA-TR*       WHERE  4L.EQUIP_SEQ       =  :4L-EQUIP-SEQ                        
MFA-TR*         AND  4L.INSTALL_LOC_NO  =  :4L-INSTALL-LOC-NO                   
MFA-TR*         AND  4L.ACCOUNT_NO      =  :4L-ACCOUNT-NO                       
MFA-TR*      ORDER BY 4L.CNTRCT_START_DT DESC                                   
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF IND-ACTL-CHRG-DT = WS-YES-NULL                         
                 MOVE SPACES                TO 4L-ACTL-CHRG-DT          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-2          
              MOVE 4L-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 4L-EQUIP-SEQ             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET FIXTURE CONRACT DETAILS                                  **        
      ******************************************************************        
      *                                                                         
       7525-GET-CUST-PLAN-DATA.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) CP.USAGE_FIXED                                     
               INTO :CP-USAGE-FIXED                                     
               FROM  CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
                    ,CSS_CUST_PLAN     CP WITH(READUNCOMMITTED)                 
              WHERE  UT.ACCOUNT_NO      =   CP.ACCOUNT_NO               
                AND  UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO               
                AND  UT.PREMISE_NO      =  :UT-PREMISE-NO               
                AND  UT.CODE_UTIL_TYPE  =   CP.CODE_UTIL_TYPE           
                AND  UT.CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE           
                AND  UT.RATE_PLAN_NO    =  :UT-RATE-PLAN-NO             
                AND  UT.IC_NO           =   CP.IC_NO                    
                AND  CP.RATE_ITEM_CODE  =  :CP-RATE-ITEM-CODE           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  CP.USAGE_FIXED                                             
MFA-TR*        INTO :CP-USAGE-FIXED                                             
MFA-TR*        FROM  CSS_UTIL_ENVRNMT  UT                                       
MFA-TR*             ,CSS_CUST_PLAN     CP                                       
MFA-TR*       WHERE  UT.ACCOUNT_NO      =   CP.ACCOUNT_NO                       
MFA-TR*         AND  UT.ACCOUNT_NO      =  :UT-ACCOUNT-NO                       
MFA-TR*         AND  UT.PREMISE_NO      =  :UT-PREMISE-NO                       
MFA-TR*         AND  UT.CODE_UTIL_TYPE  =   CP.CODE_UTIL_TYPE                   
MFA-TR*         AND  UT.CODE_UTIL_TYPE  =  :UT-CODE-UTIL-TYPE                   
MFA-TR*         AND  UT.RATE_PLAN_NO    =  :UT-RATE-PLAN-NO                     
MFA-TR*         AND  UT.IC_NO           =   CP.IC_NO                            
MFA-TR*         AND  CP.RATE_ITEM_CODE  =  :CP-RATE-ITEM-CODE                   
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7525                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7525'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-4          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-PREMISE-NO            TO HOSTVAR-ELEMENT-2        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE UT-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** OPEN FIXTURE POLE CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7600-OPEN-FXTR-POLE-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
                OPEN FXTR_POLE_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_EQUIP_INVENTRY'  TO TABLE-1                     
              MOVE 'EQUIP_TAG_NO'        TO TABLE-ELEMENT-1             
              MOVE 4D-EQUIP-TAG-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** FETCH FIXTURE POLE CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7625-FETCH-FXTR-POLE-CUR.                                        

MSQ008     MOVE 10 TO MSQ008-FXTR-POLE-CUR
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-FXTR-POLE-CUR
              FETCH 
              FROM FXTR_POLE_CUR          
                INTO :WS-FXTR-TAG-NO                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM FXTR_POLE_CUR FOR 10 ROWS                 
MFA-TR*         INTO :WS-FXTR-TAG-NO                                            
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-FXTR-POLE-CUR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)            TO WS-FXTR-POLE-ROW-COUNT      
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7625'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_EQUIP_INVENTRY'  TO TABLE-1                     
              MOVE 'EQUIP_TAG_NO'        TO TABLE-ELEMENT-1             
              MOVE 4D-EQUIP-TAG-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CLOSE FIXTURE POLE CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7650-CLOSE-FXTR-POLE-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE FXTR_POLE_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7650'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'LMS_EQUIP_INVENTRY'  TO TABLE-1                     
              MOVE 'EQUIP_TAG_NO'        TO TABLE-ELEMENT-1             
              MOVE 4D-EQUIP-TAG-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - FIXTURE DETAILS                      **         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS-FXTR.                                         
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04762_FXTR'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04762_FXTR                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04762_FXTR                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04762_FXTR'          TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - FIXTURE LOCATION DETAILS             **         
      *****************************************************************         
      *                                                                         
       8000B-DEL-GTT-ROWS-LOC.                                          
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04762_LOC'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04762_LOC                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04762_LOC                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04762_LOC'           TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - POLE DETAILS                         **         
      *****************************************************************         
      *                                                                         
       8000C-DEL-GTT-ROWS-POLE.                                         
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04762_POLE'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04762_POLE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04762_POLE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000C'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04762_POLE'          TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - FIXTURE CONTRACT DETAILS             **         
      *****************************************************************         
      *                                                                         
       8000D-DEL-GTT-ROWS-CNTRCT.                                       
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04762_CNTRCT'              
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04762_CNTRCT                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04762_CNTRCT                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000D'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04762_CNTRCT'        TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000D-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** DELETE SESSION TABLE - NODE DETAILS                         **         
      *****************************************************************         
      *                                                                         
       8000E-DEL-GTT-ROWS-NODE.                                         
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04762_NODE'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04762_NODE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04762_NODE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000E'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04762_NODE'          TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000E-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - FIXTURE DETAILS                          **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT-FXTR.                                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04762_FXTR                         
                 (                                                      
                   RETURN_CODE                                          
                  ,EQUIP_SEQ                                            
                  ,EQUIP_TAG_NO                                         
                  ,COMPANY_NO                                           
                  ,CODE_SERVICE_TYPE                                    
                  ,STOCK_CD                                             
                  ,EQUIP_MFR_CD                                         
                  ,EQUIP_MFR_DT                                         
                  ,WARRANTY_EXP_DT                                      
                  ,EQUIP_DISPOSAL_DT                                    
                  ,STORAGE_FAC_CD                                       
                  ,INVENTRY_STATUS_CD                                   
                  ,WRNTY_RECEIVED_FL                                    
                  ,WRNTY_RECOUP_AMT                                     
                  ,INSTALL_LOC_NO                                       
                  ,INSTALL_POINT_NO                                     
                  ,INSTALL_LOC_CD                                       
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,BILLING_FL                                           
                  ,NO_BILL_REASON_CD                                    
                  ,EQUIP_CONTRACT_FL                                    
                  ,NO_CONTRACT_RSN_CD                                   
                  ,EQUIP_OWNER_CD                                       
                  ,EQUIP_DRAWING_ID                                     
                  ,SOURCE_APPL_CD                                       
                  ,SOURCE_APPL_REQ_NO                                   
                  ,WMS_POINT_NO                                         
                  ,EQUIP_INSTALL_DT                                     
                  ,SPCL_AGR_COMMENTS                                    
                  ,EQUIP_COMMENTS                                       
                  ,CODE_REVENUE_CLASS                                   
                  ,TAG_TYPE_CD                                          
                  ,WMS_INSTALL_COUNT                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-F-RETURN-CODE                                     
                  ,:S-F-EQUIP-SEQ                                       
                  ,:S-F-EQUIP-TAG-NO                                    
                  ,:S-F-COMPANY-NO                                      
                  ,:S-F-CODE-SERVICE-TYPE                               
                  ,:S-F-STOCK-CD                                        
                  ,:S-F-EQUIP-MFR-CD                                    
                  ,:S-F-EQUIP-MFR-DT                                    
                  ,:S-F-WARRANTY-EXP-DT                                 
                  ,:S-F-EQUIP-DISPOSAL-DT                               
                  ,:S-F-STORAGE-FAC-CD                                  
                  ,:S-F-INVENTRY-STATUS-CD                              
                  ,:S-F-WRNTY-RECEIVED-FL                               
                  ,:S-F-WRNTY-RECOUP-AMT                                
                  ,:S-F-INSTALL-LOC-NO                                  
                  ,:S-F-INSTALL-POINT-NO                                
                  ,:S-F-INSTALL-LOC-CD                                  
                  ,:S-F-CODE-UTIL-TYPE                                  
                  ,:S-F-IC-NO                                           
                  ,:S-F-RATE-PLAN-NO                                    
                  ,:S-F-RATE-ITEM-CODE                                  
                  ,:S-F-ITEM-SEQ-NO                                     
                  ,:S-F-BILLING-FL                                      
                  ,:S-F-NO-BILL-REASON-CD                               
                  ,:S-F-EQUIP-CONTRACT-FL                               
                  ,:S-F-NO-CONTRACT-RSN-CD                              
                  ,:S-F-EQUIP-OWNER-CD                                  
                  ,:S-F-EQUIP-DRAWING-ID                                
                  ,:S-F-SOURCE-APPL-CD                                  
                  ,:S-F-SOURCE-APPL-REQ-NO                              
                  ,:S-F-WMS-POINT-NO                                    
                  ,:S-F-EQUIP-INSTALL-DT                                
                  ,:S-F-SPCL-AGR-COMMENTS                               
                  ,:S-F-EQUIP-COMMENTS                                  
                  ,:S-F-CODE-REVENUE-CLASS                              
                  ,:S-F-TAG-TYPE-CD                                     
                  ,:S-F-WMS-INSTALL-COUNT                               
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04762_FXTR                                 
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,STOCK_CD                                                     
MFA-TR*           ,EQUIP_MFR_CD                                                 
MFA-TR*           ,EQUIP_MFR_DT                                                 
MFA-TR*           ,WARRANTY_EXP_DT                                              
MFA-TR*           ,EQUIP_DISPOSAL_DT                                            
MFA-TR*           ,STORAGE_FAC_CD                                               
MFA-TR*           ,INVENTRY_STATUS_CD                                           
MFA-TR*           ,WRNTY_RECEIVED_FL                                            
MFA-TR*           ,WRNTY_RECOUP_AMT                                             
MFA-TR*           ,INSTALL_LOC_NO                                               
MFA-TR*           ,INSTALL_POINT_NO                                             
MFA-TR*           ,INSTALL_LOC_CD                                               
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,BILLING_FL                                                   
MFA-TR*           ,NO_BILL_REASON_CD                                            
MFA-TR*           ,EQUIP_CONTRACT_FL                                            
MFA-TR*           ,NO_CONTRACT_RSN_CD                                           
MFA-TR*           ,EQUIP_OWNER_CD                                               
MFA-TR*           ,EQUIP_DRAWING_ID                                             
MFA-TR*           ,SOURCE_APPL_CD                                               
MFA-TR*           ,SOURCE_APPL_REQ_NO                                           
MFA-TR*           ,WMS_POINT_NO                                                 
MFA-TR*           ,EQUIP_INSTALL_DT                                             
MFA-TR*           ,SPCL_AGR_COMMENTS                                            
MFA-TR*           ,EQUIP_COMMENTS                                               
MFA-TR*           ,CODE_REVENUE_CLASS                                           
MFA-TR*           ,TAG_TYPE_CD                                                  
MFA-TR*           ,WMS_INSTALL_COUNT                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-F-RETURN-CODE                                             
MFA-TR*           ,:S-F-EQUIP-SEQ                                               
MFA-TR*           ,:S-F-EQUIP-TAG-NO                                            
MFA-TR*           ,:S-F-COMPANY-NO                                              
MFA-TR*           ,:S-F-CODE-SERVICE-TYPE                                       
MFA-TR*           ,:S-F-STOCK-CD                                                
MFA-TR*           ,:S-F-EQUIP-MFR-CD                                            
MFA-TR*           ,:S-F-EQUIP-MFR-DT                                            
MFA-TR*           ,:S-F-WARRANTY-EXP-DT                                         
MFA-TR*           ,:S-F-EQUIP-DISPOSAL-DT                                       
MFA-TR*           ,:S-F-STORAGE-FAC-CD                                          
MFA-TR*           ,:S-F-INVENTRY-STATUS-CD                                      
MFA-TR*           ,:S-F-WRNTY-RECEIVED-FL                                       
MFA-TR*           ,:S-F-WRNTY-RECOUP-AMT                                        
MFA-TR*           ,:S-F-INSTALL-LOC-NO                                          
MFA-TR*           ,:S-F-INSTALL-POINT-NO                                        
MFA-TR*           ,:S-F-INSTALL-LOC-CD                                          
MFA-TR*           ,:S-F-CODE-UTIL-TYPE                                          
MFA-TR*           ,:S-F-IC-NO                                                   
MFA-TR*           ,:S-F-RATE-PLAN-NO                                            
MFA-TR*           ,:S-F-RATE-ITEM-CODE                                          
MFA-TR*           ,:S-F-ITEM-SEQ-NO                                             
MFA-TR*           ,:S-F-BILLING-FL                                              
MFA-TR*           ,:S-F-NO-BILL-REASON-CD                                       
MFA-TR*           ,:S-F-EQUIP-CONTRACT-FL                                       
MFA-TR*           ,:S-F-NO-CONTRACT-RSN-CD                                      
MFA-TR*           ,:S-F-EQUIP-OWNER-CD                                          
MFA-TR*           ,:S-F-EQUIP-DRAWING-ID                                        
MFA-TR*           ,:S-F-SOURCE-APPL-CD                                          
MFA-TR*           ,:S-F-SOURCE-APPL-REQ-NO                                      
MFA-TR*           ,:S-F-WMS-POINT-NO                                            
MFA-TR*           ,:S-F-EQUIP-INSTALL-DT                                        
MFA-TR*           ,:S-F-SPCL-AGR-COMMENTS                                       
MFA-TR*           ,:S-F-EQUIP-COMMENTS                                          
MFA-TR*           ,:S-F-CODE-REVENUE-CLASS                                      
MFA-TR*           ,:S-F-TAG-TYPE-CD                                             
MFA-TR*           ,:S-F-WMS-INSTALL-COUNT                                       
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-FXTR           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04762_FXTR'           TO TABLE-1                 
              MOVE 'FIXTURE SEQ'             TO TABLE-ELEMENT-1         
              MOVE LINK-FIXTURE-SEQ          TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100A-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - FIXTURE LOCATION DETAILS                 **        
      ******************************************************************        
      *                                                                         
       8100B-SEND-RESULT-LOC.                                           
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04762_LOC                          
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,PREMISE_NO                                           
                  ,REV_DISTRICT_CD                                      
                  ,SUBDIVISION_ID                                       
                  ,SUB_DIV_ZIP_CD                                       
                  ,POINT_ID                                             
                  ,CUSTOMER_NAME                                        
                  ,ADDRESS                                              
                  ,USAGE_FIXED                                          
A05084            ,CODE_ACCT_STAT                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-L-RETURN-CODE                                     
                  ,:S-L-ACCOUNT-NO                                      
                  ,:S-L-PREMISE-NO                                      
                  ,:S-L-REV-DISTRICT-CD                                 
                  ,:S-L-SUBDIVISION-ID                                  
                  ,:S-L-SUB-DIV-ZIP-CD                                  
                  ,:S-L-POINT-ID                                        
                  ,:S-L-CUSTOMER-NAME                                   
                  ,:S-L-ADDRESS                                         
                  ,:S-L-USAGE-FIXED                                     
A05084            ,:S-L-CODE-ACCT-STAT                                  
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04762_LOC                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,PREMISE_NO                                                   
MFA-TR*           ,REV_DISTRICT_CD                                              
MFA-TR*           ,SUBDIVISION_ID                                               
MFA-TR*           ,SUB_DIV_ZIP_CD                                               
MFA-TR*           ,POINT_ID                                                     
MFA-TR*           ,CUSTOMER_NAME                                                
MFA-TR*           ,ADDRESS                                                      
MFA-TR*           ,USAGE_FIXED                                                  
MFA-TR*           ,CODE_ACCT_STAT                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-L-RETURN-CODE                                             
MFA-TR*           ,:S-L-ACCOUNT-NO                                              
MFA-TR*           ,:S-L-PREMISE-NO                                              
MFA-TR*           ,:S-L-REV-DISTRICT-CD                                         
MFA-TR*           ,:S-L-SUBDIVISION-ID                                          
MFA-TR*           ,:S-L-SUB-DIV-ZIP-CD                                          
MFA-TR*           ,:S-L-POINT-ID                                                
MFA-TR*           ,:S-L-CUSTOMER-NAME                                           
MFA-TR*           ,:S-L-ADDRESS                                                 
MFA-TR*           ,:S-L-USAGE-FIXED                                             
MFA-TR*           ,:S-L-CODE-ACCT-STAT                                          
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-LOC            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100B'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04762_LOC'            TO TABLE-1                 
              MOVE 'FIXTURE SEQ'             TO TABLE-ELEMENT-1         
              MOVE LINK-FIXTURE-SEQ          TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100B-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - POLE DETAILS                             **        
      ******************************************************************        
      *                                                                         
       8100C-SEND-RESULT-POLE.                                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04762_POLE                         
                 (                                                      
                   RETURN_CODE                                          
                  ,EQUIP_SEQ                                            
                  ,ATTACH_SEQ_NO                                        
                  ,EQUIP_TAG_NO                                         
                  ,COMPANY_NO                                           
                  ,CODE_SERVICE_TYPE                                    
                  ,STOCK_CD                                             
                  ,INVENTRY_STATUS_CD                                   
                  ,INSTALL_POINT_NO                                     
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,ITEM_SEQ_NO                                          
                  ,BILLING_FL                                           
                  ,NO_BILL_REASON_CD                                    
                  ,EQUIP_OWNER_CD                                       
                  ,EQUIP_INSTALL_DT                                     
                  ,CODE_REVENUE_CLASS                                   
                  ,MSG_FXTR_COUNT                                       
                  ,MSG_FXTR_TEXT                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-P-RETURN-CODE                                     
                  ,:S-P-EQUIP-SEQ                                       
                  ,:S-P-ATTACH-SEQ-NO                                   
                  ,:S-P-EQUIP-TAG-NO                                    
                  ,:S-P-COMPANY-NO                                      
                  ,:S-P-CODE-SERVICE-TYPE                               
                  ,:S-P-STOCK-CD                                        
                  ,:S-P-INVENTRY-STATUS-CD                              
                  ,:S-P-INSTALL-POINT-NO                                
                  ,:S-P-CODE-UTIL-TYPE                                  
                  ,:S-P-IC-NO                                           
                  ,:S-P-RATE-PLAN-NO                                    
                  ,:S-P-RATE-ITEM-CODE                                  
                  ,:S-P-ITEM-SEQ-NO                                     
                  ,:S-P-BILLING-FL                                      
                  ,:S-P-NO-BILL-REASON-CD                               
                  ,:S-P-EQUIP-OWNER-CD                                  
                  ,:S-P-EQUIP-INSTALL-DT                                
                  ,:S-P-CODE-REVENUE-CLASS                              
                  ,:S-P-MSG-FXTR-COUNT                                  
                  ,:S-P-MSG-FXTR-TEXT                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04762_POLE                                 
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,ATTACH_SEQ_NO                                                
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,STOCK_CD                                                     
MFA-TR*           ,INVENTRY_STATUS_CD                                           
MFA-TR*           ,INSTALL_POINT_NO                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,ITEM_SEQ_NO                                                  
MFA-TR*           ,BILLING_FL                                                   
MFA-TR*           ,NO_BILL_REASON_CD                                            
MFA-TR*           ,EQUIP_OWNER_CD                                               
MFA-TR*           ,EQUIP_INSTALL_DT                                             
MFA-TR*           ,CODE_REVENUE_CLASS                                           
MFA-TR*           ,MSG_FXTR_COUNT                                               
MFA-TR*           ,MSG_FXTR_TEXT                                                
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-P-RETURN-CODE                                             
MFA-TR*           ,:S-P-EQUIP-SEQ                                               
MFA-TR*           ,:S-P-ATTACH-SEQ-NO                                           
MFA-TR*           ,:S-P-EQUIP-TAG-NO                                            
MFA-TR*           ,:S-P-COMPANY-NO                                              
MFA-TR*           ,:S-P-CODE-SERVICE-TYPE                                       
MFA-TR*           ,:S-P-STOCK-CD                                                
MFA-TR*           ,:S-P-INVENTRY-STATUS-CD                                      
MFA-TR*           ,:S-P-INSTALL-POINT-NO                                        
MFA-TR*           ,:S-P-CODE-UTIL-TYPE                                          
MFA-TR*           ,:S-P-IC-NO                                                   
MFA-TR*           ,:S-P-RATE-PLAN-NO                                            
MFA-TR*           ,:S-P-RATE-ITEM-CODE                                          
MFA-TR*           ,:S-P-ITEM-SEQ-NO                                             
MFA-TR*           ,:S-P-BILLING-FL                                              
MFA-TR*           ,:S-P-NO-BILL-REASON-CD                                       
MFA-TR*           ,:S-P-EQUIP-OWNER-CD                                          
MFA-TR*           ,:S-P-EQUIP-INSTALL-DT                                        
MFA-TR*           ,:S-P-CODE-REVENUE-CLASS                                      
MFA-TR*           ,:S-P-MSG-FXTR-COUNT                                          
MFA-TR*           ,:S-P-MSG-FXTR-TEXT                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-POLE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100C'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04762_POLE'           TO TABLE-1                 
              MOVE 'FIXTURE SEQ'             TO TABLE-ELEMENT-1         
              MOVE LINK-FIXTURE-SEQ          TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100C-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - FIXTURE CONTRACT DETAILS                 **        
      ******************************************************************        
      *                                                                         
       8100D-SEND-RESULT-CNTRCT.                                        
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04762_CNTRCT                       
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,CNTRCT_START_DT                                      
                  ,CNTRCT_END_DT                                        
                  ,CNTRCT_DURATION_CD                                   
                  ,FIXTURE_COST_AM                                      
                  ,POLE_COST_AM                                         
                  ,CALC_TERM_CHRG_AM                                    
                  ,ORIG_TERM_CHRG_AM                                    
                  ,ACTL_TERM_CHRG_AM                                    
                  ,ACTL_CHRG_DT                                         
                  ,CNTRCT_CLP_NO                                        
                  ,CNTRCT_STATUS_CD                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-C-RETURN-CODE                                     
                  ,:S-C-ACCOUNT-NO                                      
                  ,:S-C-CNTRCT-START-DT                                 
                  ,:S-C-CNTRCT-END-DT                                   
                  ,:S-C-CNTRCT-DURATION-CD                              
                  ,:S-C-FIXTURE-COST-AM                                 
                  ,:S-C-POLE-COST-AM                                    
                  ,:S-C-CALC-TERM-CHRG-AM                               
                  ,:S-C-ORIG-TERM-CHRG-AM                               
                  ,:S-C-ACTL-TERM-CHRG-AM                               
                  ,:S-C-ACTL-CHRG-DT                                    
                  ,:S-C-CNTRCT-CLP-NO                                   
                  ,:S-C-CNTRCT-STATUS-CD                                
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04762_CNTRCT                               
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,CNTRCT_END_DT                                                
MFA-TR*           ,CNTRCT_DURATION_CD                                           
MFA-TR*           ,FIXTURE_COST_AM                                              
MFA-TR*           ,POLE_COST_AM                                                 
MFA-TR*           ,CALC_TERM_CHRG_AM                                            
MFA-TR*           ,ORIG_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_TERM_CHRG_AM                                            
MFA-TR*           ,ACTL_CHRG_DT                                                 
MFA-TR*           ,CNTRCT_CLP_NO                                                
MFA-TR*           ,CNTRCT_STATUS_CD                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-C-RETURN-CODE                                             
MFA-TR*           ,:S-C-ACCOUNT-NO                                              
MFA-TR*           ,:S-C-CNTRCT-START-DT                                         
MFA-TR*           ,:S-C-CNTRCT-END-DT                                           
MFA-TR*           ,:S-C-CNTRCT-DURATION-CD                                      
MFA-TR*           ,:S-C-FIXTURE-COST-AM                                         
MFA-TR*           ,:S-C-POLE-COST-AM                                            
MFA-TR*           ,:S-C-CALC-TERM-CHRG-AM                                       
MFA-TR*           ,:S-C-ORIG-TERM-CHRG-AM                                       
MFA-TR*           ,:S-C-ACTL-TERM-CHRG-AM                                       
MFA-TR*           ,:S-C-ACTL-CHRG-DT                                            
MFA-TR*           ,:S-C-CNTRCT-CLP-NO                                           
MFA-TR*           ,:S-C-CNTRCT-STATUS-CD                                        
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-CNTRCT         
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100D'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04762_CNTRCT'         TO TABLE-1                 
              MOVE 'FIXTURE SEQ'             TO TABLE-ELEMENT-1         
              MOVE LINK-FIXTURE-SEQ          TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100D-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** INSERT RESULT SET - NODE DETAILS                             **        
      ******************************************************************        
      *                                                                         
       8100E-SEND-RESULT-NODE.                                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04762_NODE                         
                 (                                                      
                   RETURN_CODE                                          
                  ,EQUIP_SEQ                                            
                  ,ATTACH_SEQ_NO                                        
                  ,EQUIP_TAG_NO                                         
                  ,COMPANY_NO                                           
                  ,CODE_SERVICE_TYPE                                    
                  ,STOCK_CD                                             
                  ,EQUIP_MFR_CD                                         
                  ,EQUIP_MFR_DT                                         
                  ,WARRANTY_EXP_DT                                      
                  ,INVENTRY_STATUS_CD                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-N-RETURN-CODE                                     
                  ,:S-N-EQUIP-SEQ                                       
                  ,:S-N-ATTACH-SEQ-NO                                   
                  ,:S-N-EQUIP-TAG-NO                                    
                  ,:S-N-COMPANY-NO                                      
                  ,:S-N-CODE-SERVICE-TYPE                               
                  ,:S-N-STOCK-CD                                        
                  ,:S-N-EQUIP-MFR-CD                                    
                  ,:S-N-EQUIP-MFR-DT                                    
                  ,:S-N-WARRANTY-EXP-DT                                 
                  ,:S-N-INVENTRY-STATUS-CD                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04762_NODE                                 
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,EQUIP_SEQ                                                    
MFA-TR*           ,ATTACH_SEQ_NO                                                
MFA-TR*           ,EQUIP_TAG_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,STOCK_CD                                                     
MFA-TR*           ,EQUIP_MFR_CD                                                 
MFA-TR*           ,EQUIP_MFR_DT                                                 
MFA-TR*           ,WARRANTY_EXP_DT                                              
MFA-TR*           ,INVENTRY_STATUS_CD                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-N-RETURN-CODE                                             
MFA-TR*           ,:S-N-EQUIP-SEQ                                               
MFA-TR*           ,:S-N-ATTACH-SEQ-NO                                           
MFA-TR*           ,:S-N-EQUIP-TAG-NO                                            
MFA-TR*           ,:S-N-COMPANY-NO                                              
MFA-TR*           ,:S-N-CODE-SERVICE-TYPE                                       
MFA-TR*           ,:S-N-STOCK-CD                                                
MFA-TR*           ,:S-N-EQUIP-MFR-CD                                            
MFA-TR*           ,:S-N-EQUIP-MFR-DT                                            
MFA-TR*           ,:S-N-WARRANTY-EXP-DT                                         
MFA-TR*           ,:S-N-INVENTRY-STATUS-CD                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS-NODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100E'                   TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04762_NODE'           TO TABLE-1                 
              MOVE 'FIXTURE SEQ'             TO TABLE-ELEMENT-1         
              MOVE LINK-FIXTURE-SEQ          TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
        8100E-EXIT.                                                     
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-F-RETURN-CODE               
                                          S-L-RETURN-CODE               
                                          S-P-RETURN-CODE               
                                          S-C-RETURN-CODE               
                                          S-N-RETURN-CODE.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-FXTR    THRU  0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-LOC     THRU  0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-POLE    THRU  0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT-CNTRCT  THRU  0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT-NODE    THRU  0100E-EXIT.          
      *                                                                         
           PERFORM 8100A-SEND-RESULT-FXTR    THRU  8100A-EXIT.          
           PERFORM 8100B-SEND-RESULT-LOC     THRU  8100B-EXIT.          
           PERFORM 8100C-SEND-RESULT-POLE    THRU  8100C-EXIT.          
           PERFORM 8100D-SEND-RESULT-CNTRCT  THRU  8100D-EXIT.          
           PERFORM 8100E-SEND-RESULT-NODE    THRU  8100E-EXIT.          
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE    THRU  9900-EXIT.           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE  THRU  8900-EXIT.                     
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
