       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04761.                                            
       DATE-WRITTEN. 04/15/14.                                          
       DATE-COMPILED.                                                   
       AUTHOR. SATISH SIVASUBRAMANIAN.                                  
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *                      CIS AND LMS SEARCH                        *        
      *                      ==================                        *        
      *  SEARCH CRITERIA CONTAINS THE DATA FOR THE SPECIFIED           *        
      *  SEARCH TYPE. ***                                              *        
      *                                                                *        
      *  INPUT:                                                        *        
      *   1. LINK-SEARCH-TYPE:  ACCOUNT-NO   - 'CA'   CIS SEARCH C*    *        
      *                         CUSTOMER-NO  - 'CC'                    *        
      *                         METER-NO     - 'CM'                    *        
      *                         POINT-ID     - 'CP'                    *        
      *                         NAME         - 'CN'                    *        
      *                         BIZ NAME     - 'CB'                    *        
      *                         ADDRESS      - 'CD'                    *        
      *                         SUB-DIVISION - 'CS'                    *        
      *                         FIXTURE-ID   - 'LF'   LMS SEARCH L*    *        
      *                         POLE-NO      - 'LP'                    *        
      *                         NODE-NO      - 'LN'                    *        
      *                         WMS-REQ-NO   - 'LW'                    *        
      *                         CLP-NO       - 'LC'                    *        
      *                                                                *        
      *   2. LINK-SEARCH-IND-TYP:  'S' START                           *        
      *                            'N' NEXT                            *        
      *                            'E' EXIT                            *        
      *                                                                *        
      *   3. LINK-SEARCH-IND-KEY:  PREMISE-NO                          *        
      *                            FIXTURE-NO                          *        
      *                            CURSOR-NAME                         *        
      *                                                                *        
      *   4. LINK-SEARCH-CRITERIA  MAX 250 BYTES INCLUDING DELIMITER   *        
      *                                                                *        
      *  OUTPUT:                                                       *        
      *      C1 - SEARCH RESULT SET BASED ON THE SEARCH TYPE           *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/15/14  SS95855    PROJ#0817 PROCEDURE ORIGINALLY CODED.    *        
A#5084*  05/29/15  SS95855    ACT033    1. REMOVE INSTALL_POINT_NO.    *        
A#5084*                       IN NAME_CUR,ADDR_CUR & BIZ_NAME_CUR.     *        
A#5084*                                 2. ADD DISTINCT CLAUSE         *        
A#5084*  06/19/15  SS95855    ACT040    CLP# CHANGED TO CHAR(50).      *        
A#5084*  02/22/16  DB41297    ACT072    FIX MOD OVERFLOW/LOOPING.      *        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04761'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                         PIC X(40) VALUE             
           'WORKING STORAGE FOR CSR04761 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR04761'. 
           05 CSRERLOG                      PIC X(08) VALUE 'CSRERLOG'. 
           05 WS-YES                        PIC X(01) VALUE 'Y'.        
           05 WS-NO                         PIC X(01) VALUE 'N'.        
           05 WS-50                         PIC 9(02) VALUE 50.         
           05 CN-DELIMITER                  PIC X(01) VALUE ';'.        
           05 WS-POLE                       PIC X(01) VALUE 'P'.        
           05 WS-NODE                       PIC X(01) VALUE 'N'.        
           05 WS-FIXTURE                    PIC X(01) VALUE 'F'.        
           05 WS-MAX-FXTR-CNT               PIC 9(02) VALUE 20.         
                                                                        
       01  WS-MISC.                                                     
           05 WS-SQLSTATE                   PIC X(05) VALUE SPACES.     
           05 WS-ACCOUNT-NUM                PIC S9(13)V COMP-3 VALUE 0. 
           05 WS-ACTIVE-ACCT-FL             PIC X(01) VALUE SPACES.     
           05 WS-SUBDIVISION-ID             PIC X(03) VALUE SPACES.     
           05 WS-CUSTOMER-NAME              PIC X(70) VALUE SPACES.     
           05 WS-GIS-LOC-OFF                PIC X(03) VALUE SPACES.     
           05 WS-TAG-NM                     PIC X(07) VALUE SPACES.     
           05 WS-STAR-COUNT                 PIC S9(02) COMP-3 VALUE 0.  
           05 WS-PREMISE-NO                 PIC S9(10) COMP-3 VALUE 0.  
           05 NAM-FIRST-NAME                PIC X(15) VALUE SPACES.     
           05 NAM-MIDDLE-NAME               PIC X(15) VALUE SPACES.     
           05 NAM-LAST-NAME                 PIC X(40) VALUE SPACES.     
           05 NAM-CITY-NAME                 PIC X(26) VALUE SPACES.     
           05 NAM-STREET-NAME               PIC X(30) VALUE SPACES.     
           05 BIZ-NAME                      PIC X(70) VALUE SPACES.     
           05 BIZ-STREET-NAME               PIC X(30) VALUE SPACES.     
           05 ADD-STREET-NBR                PIC X(15) VALUE SPACES.     
           05 ADD-PREFIX-1                  PIC X(03) VALUE SPACES.     
           05 ADD-PREFIX-2                  PIC X(02) VALUE SPACES.     
           05 ADD-STREET-NAME               PIC X(30) VALUE SPACES.     
           05 ADD-LOCATION-1                PIC X(04) VALUE SPACES.     
           05 ADD-LOCATION-2                PIC X(11) VALUE SPACES.     
           05 ADD-CITY                      PIC X(26) VALUE SPACES.     
           05 WS-GET-NAME-ADDR-FL           PIC X(01).                  
           05 WS-EQUIP-SEQ                  PIC S9(10)V COMP-3 VALUE 0. 
           05 WS-POLE-COUNT                 PIC S9(4) COMP.             
           05 WS-EQUIP-TAG-NO               PIC X(12).                  
           05 WS-STOCK-CD                   PIC X(15).                  
           05 WS-POLE-TAG-NO                PIC X(15) VALUE SPACES.     
           05 WS-NODE-TAG-NO                PIC X(15) VALUE SPACES.     
           05 WS-IND-PREMISE                PIC 9(10) VALUE 0.          
           05 WS-IND-PREMISE-NO             PIC S9(10)V COMP-3 VALUE 0. 
                                                                        
       01  WS-WORK-AREA.                                                
           05 WS-ADDRESS.                                               
              10 WS-ADDRESS-LINE1           PIC X(85) VALUE SPACES.     
              10 WS-ADDRESS-LINE2           PIC X(85) VALUE SPACES.     
              10 WS-IN-STRING.                                          
                 15 WS-IN-CHAR              PIC X(01) OCCURS 85 TIMES   
                                            INDEXED BY WS-IN-INDX.      
              10 WS-OUT-STRING.                                         
                 15 WS-OUT-CHAR             PIC X(01) OCCURS 85 TIMES   
                                            INDEXED BY WS-OUT-INDX.     
              10 WS-LAST-CHAR               PIC X(01) VALUE SPACES.     
              10 WS-CHAR-LENGTH             PIC S9(03) VALUE ZERO.      
              10 WS-STREET-ADDRESS.                                     
                 15 WS-HOUSE-NO             PIC X(15) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-ADDR-PREFIX-1        PIC X(03) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-ADDR-PREFIX-2        PIC X(02) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-NAME-STREET          PIC X(30) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-STREET-SUFFIX        PIC X(04) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-ADDRESS-SUFFIX       PIC X(02) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-STREET-LOCATION-1    PIC X(04) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-STREET-LOCATION-2    PIC X(11) VALUE SPACES.     
                 15 FILLER                  PIC X(04) VALUE SPACES.     
              10 WS-CITY-STATE.                                         
                 15 WS-CITY                 PIC X(26) VALUE SPACES.     
                 15 FILLER                  PIC X(01) VALUE SPACES.     
                 15 WS-STATE                PIC X(02) VALUE SPACES.     
                 15 WS-ZIP-FILLER           PIC X(02) VALUE ' *'.       
                 15 WS-ZIP.                                             
                    20 WS-ZIP-CODE          PIC X(05) VALUE SPACES.     
                    20 WS-ZIP-DASH          PIC X(01) VALUE '-'.        
                    20 WS-ZIP-PLUS-4        PIC X(04) VALUE SPACES.     
                                                                        
       01  WS-FXTR-ID-ARRAY.                                            
              10 WS-FXTR-ID-TABLE           OCCURS 20 TIMES             
                                            INDEXED BY WS-FXTR-INDX.    
                 15 WS-FXTR-ID              PIC X(12).                  
                                                                        
       01  WS-ACCOUNT-NUM-STR               PIC X(13).                  
       01  WS-ACCOUNT-NO  REDEFINES                                     
           WS-ACCOUNT-NUM-STR               PIC 9(13).                  
       01  WS-CUSTOMER-NUM-STR              PIC X(10).                  
       01  WS-CUSTOMER-NO REDEFINES                                     
           WS-CUSTOMER-NUM-STR              PIC 9(10).                  
       01  WS-PREMISE-NUM                   PIC 9(10).                  
       01  WS-PREMISE     REDEFINES                                     
           WS-PREMISE-NUM                   PIC X(10).                  
       01  WS-WMS-REQ-NO-STR                PIC X(13).                  
       01  WS-WMS-REQ-NO  REDEFINES                                     
           WS-WMS-REQ-NO-STR                PIC 9(13).                  
                                                                        
       01  WS-END-OF-50-ROWS                PIC X(01) VALUE 'N'.        
           88 END-OF-50-ROWS                          VALUE 'Y'.        
                                                                        
       01  WS-SKIP-ACCOUNT                  PIC X(01) VALUE 'N'.        
           88 SKIP-ACCOUNT                            VALUE 'Y'.        
                                                                        
       01  WS-CURRNT-ACCNT                  PIC X(01) VALUE 'N'.        
           88 NOT-A-CURRNT-ACCNT                      VALUE 'Y'.        
                                                                        
       01  WS-SEARCH-TYPE                   PIC X(02) VALUE SPACES.     
           88 SEARCH-BY-ACCOUNT-NO                    VALUE 'CA'.       
           88 SEARCH-BY-CUSTOMER-NO                   VALUE 'CC'.       
           88 SEARCH-BY-METER-NO                      VALUE 'CM'.       
           88 SEARCH-BY-POINT-ID                      VALUE 'CP'.       
           88 SEARCH-BY-NAME                          VALUE 'CN'.       
           88 SEARCH-BY-BIZ-NAME                      VALUE 'CB'.       
           88 SEARCH-BY-ADDRESS                       VALUE 'CD'.       
           88 SEARCH-BY-SUB-DIVISION                  VALUE 'CS'.       
           88 SEARCH-BY-FIXTURE-ID                    VALUE 'LF'.       
           88 SEARCH-BY-POLE-NO                       VALUE 'LP'.       
           88 SEARCH-BY-NODE-NO                       VALUE 'LN'.       
           88 SEARCH-BY-WMS-REQ-NO                    VALUE 'LW'.       
           88 SEARCH-BY-CLP-NO                        VALUE 'LC'.       
                                                                        
       01  CSRERLOG-P.                                                  
           10 S-SP-NAME                     PIC X(18) VALUE SPACES.     
           10 S-SQLCODE                     PIC S9(9) COMP VALUE 0.     
           10 S-SQLSTATE                    PIC X(5)  VALUE ' '.        
           10 S-TABLE-NAME                  PIC X(18) VALUE SPACES.     
           10 S-HOST-VARIABLES.                                         
              49 S-HOST-VARIABLES-L         PIC S9(4) COMP.             
              49 S-HOST-VARIABLES-V         PIC X(255).                 
           10 S-SQL-STATEMENT.                                          
              49 S-SQL-STATEMENT-L          PIC S9(4) COMP.             
              49 S-SQL-STATEMENT-V          PIC X(255).                 
           10 S-SQL-DESCRIPTION.                                        
              49 S-SQL-DESCRIPTION-L        PIC S9(4) COMP.             
              49 S-SQL-DESCRIPTION-V        PIC X(255).                 
           10 WS-ABEND-SQLERRMC.                                        
              49 WS-ABEND-SQLERRMC-L        PIC S9(4) COMP.             
              49 WS-ABEND-SQLERRMC-V        PIC X(255).                 
                                                                        
       01  PARM-FIELDS.                                                 
           05 PARM-SEARCH-TYPE              PIC X(02).                  
           05 PARM-IND-TYP                  PIC X(01).                  
           05 PARM-IND-KEY.                                             
              10 PARM-IND-PREMISE           PIC X(10).                  
              10 PARM-IND-TAG-NO            PIC X(12).                  
              10 PARM-IND-CURSOR            PIC X(02).                  
              10 FILLER                     PIC X(01).                  
           05 PARM-SEARCH-CRITERIA          PIC X(250).                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS-RS1                  PIC S9(09) COMP VALUE 0.    
           05 CTR-ROWS-RS2                  PIC S9(09) COMP VALUE 0.    
           05 CTR-ROWS-RS3                  PIC S9(09) COMP VALUE 0.    
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW                   PIC X(01) VALUE 'N'.        
              88 NOT-ALL-DONE                         VALUE 'N'.        
              88 ALL-DONE                             VALUE 'Y'.        
           05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.        
              88 SEND-DONE-ERROR                      VALUE 'N'.        
              88 SEND-DONE-OK                         VALUE 'Y'.        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05 GTT-NAME-1                    PIC X(26) VALUE             
                                            'SESSION.CSR04761_R1'.      
           05 GTT-NAME-2                    PIC X(26) VALUE             
                                            'SESSION.CSR04761_R2'.      
           05 GTT-ROW.                                                  
              49 GTT-ROW-LEN                PIC S9(04) COMP.            
              49 GTT-ROW-CHAR               PIC X(1024).                
           05 GTT-SQLCODE                   PIC S9(9) COMP.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1           PIC S9(09) COMP VALUE 0.    
               10 S-APPL-RETURN-CODE        PIC S9(09) COMP VALUE 0.    
               10 S-FIX-EQUIP-SEQ           PIC S9(10)V COMP-3 VALUE 0. 
               10 S-FIX-TAG                 PIC X(12) VALUE SPACES.     
               10 S-LIGHT-STATUS            PIC X(01) VALUE SPACES.     
               10 S-FIX-STOCK-CD            PIC X(15) VALUE SPACES.     
               10 S-FIX-RATE                PIC X(03) VALUE SPACES.     
               10 S-POLE-TAG                PIC X(12) VALUE SPACES.     
               10 S-POLE-STOCK-CD           PIC X(15) VALUE SPACES.     
               10 S-ACCOUNT-NO              PIC S9(13)V COMP-3 VALUE 0. 
               10 S-ACCT-STATUS             PIC X(01) VALUE SPACES.     
               10 S-SUBDIVISION-ID          PIC X(03) VALUE SPACES.     
               10 S-CUSTOMER-NAME           PIC X(70) VALUE SPACES.     
               10 S-ADDRESS-LINE1           PIC X(85) VALUE SPACES.     
               10 S-ADDRESS-LINE2           PIC X(85) VALUE SPACES.     
               10 S-POLE-COUNT              PIC S9(04) COMP VALUE 0.    
                                                                        
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2           PIC S9(09) COMP VALUE 0.    
               10 S-IND-TYP                 PIC X(01)  VALUE SPACES.    
               10 S-IND-KEY                 PIC X(25)  VALUE SPACES.    
                                                                        
      *****************************************************************         
                                                                        
      *** WORKING STORAGE COPY BOOK FOR CPD00099                                
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      *** SQL COMMUNICATION AREA                                                
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC .                                                           
                                                                        
      *** CSS_ACCOUNT,AT                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *** CSS_CUSTOMER,CU                                                       
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *** CSS_CUST_PREM_HIST,CH                                                 
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_NAME,DQ                                                           
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *** CSS_NAME_ACCT_XREF,HT                                                 
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_ENVRNMT,4F                                                  
           EXEC SQL                                                             
              INCLUDE TBEQPIVT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_INVENTRY,4D                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPINV                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_EQUIP_CONTRACT,4L                                                 
           EXEC SQL                                                             
              INCLUDE TBEQPCNT                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_FXTR_ATTACHMTS,4H                                                 
           EXEC SQL                                                             
              INCLUDE TBFXTATC                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_MSTR_STCK_INFO,4A                                                 
           EXEC SQL                                                             
              INCLUDE TBMSTINF                                                  
           END-EXEC.                                                            
                                                                        
      *** LMS_SPCL_AGREEMENT,4Q                                                 
           EXEC SQL                                                             
              INCLUDE TBSPLAGR                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_PREMISE,PR                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *** CSS_SUBDIVISION,B0                                                    
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_ADDR_FORMATTED,DY                                                 
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_ZIP_CODE,A4                                                       
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_MTRD_ENVRNMT,MN                                                   
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_EQUIPMENT,EQ                                                      
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_PIM_POINT,PP                                                      
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
                                                                        
      *** WS ABEND WORK AREA                                                    
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *** DB2 ERROR CHECKING.                                                   
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE PREMISE NO FROM CUSTOMER NO    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CUSTNO_CUR CURSOR FOR                             
                 SELECT AT.PREMISE_NO                                   
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                  WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                
                    AND AT.PREMISE_NO >= :WS-IND-PREMISE-NO             
                  ORDER BY AT.PREMISE_NO                                
                FOR READ ONLY                                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUSTNO_CUR CURSOR FOR                                     
MFA-TR*          SELECT AT.PREMISE_NO                                           
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*           WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                        
MFA-TR*             AND AT.PREMISE_NO >= :WS-IND-PREMISE-NO                     
MFA-TR*           ORDER BY AT.PREMISE_NO                                        
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE PREMISE NO FROM POINT ID       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE POINTID_CUR CURSOR FOR                            
                 SELECT HT.PREMISE_NO                                   
                   FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)             
                       ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
                       ,CSS_PIM_POINT PP WITH(READUNCOMMITTED)                  
                  WHERE PP.AREA_ID          = :WS-GIS-LOC-OFF           
                    AND PP.TAG_NM           = :WS-TAG-NM                
                    AND MN.GIS_POINT_ID     = PP.POINT_ID               
                    AND MN.ACCOUNT_NO       = HT.ACCOUNT_NO             
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.PREMISE_NO      >= :WS-IND-PREMISE-NO        
                  ORDER BY HT.PREMISE_NO                                
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE POINTID_CUR CURSOR FOR                                    
MFA-TR*          SELECT HT.PREMISE_NO                                           
MFA-TR*            FROM CSS_NAME_ACCT_XREF HT                                   
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_PIM_POINT PP                                        
MFA-TR*           WHERE PP.AREA_ID          = :WS-GIS-LOC-OFF                   
MFA-TR*             AND PP.TAG_NM           = :WS-TAG-NM                        
MFA-TR*             AND MN.GIS_POINT_ID     = PP.POINT_ID                       
MFA-TR*             AND MN.ACCOUNT_NO       = HT.ACCOUNT_NO                     
MFA-TR*             AND HT.CUSTOMER_ROLE_CD = ' '                               
MFA-TR*             AND HT.PREMISE_NO      >= :WS-IND-PREMISE-NO                
MFA-TR*           ORDER BY HT.PREMISE_NO                                        
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE PREMISE NO FROM CUSTOMER NAME  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE NAME_CUR CURSOR FOR                               
                 SELECT TOP(51) HT.PREMISE_NO,
              HT.ACCOUNT_NO,
              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ' ' + LTRIM(RTRIM(
           DQ.FIRST_NAME) + ' ' + LTRIM(RTRIM(DQ.MIDDLE_NAME))))),
              HT.CODE_ACCT_STAT                               
                   FROM CSS_NAME DQ WITH(READUNCOMMITTED)                       
                       ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)             
                       ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)             
                  WHERE DQ.LAST_NAME     LIKE :NAM-LAST-NAME            
                    AND DQ.FIRST_NAME    LIKE :NAM-FIRST-NAME           
                    AND DQ.MIDDLE_NAME   LIKE :NAM-MIDDLE-NAME          
                    AND DQ.NAME_FORMAT      = 'I'                       
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID             
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.COMPANY_NO       = '01'                      
                    AND HT.STATE            = 'SC'                      
                    AND (DY.STREET_NAME = :NAM-STREET-NAME OR           
                   :NAM-STREET-NAME = '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%') 
                    AND (HT.TOWN = :NAM-CITY-NAME OR                    
                   :NAM-CITY-NAME = '%%%%%%%%%%%%%%%%%%%%%%%%%%')       
                   AND  EXISTS (SELECT 'Y'                              
                                FROM LMS_EQUIP_ENVRNMT [4F]
                           WITH(READUNCOMMITTED)               
                                WHERE [4F].INSTALL_LOC_NO =               
                                      CIS.DIGITS(HT.PREMISE_NO)             
                                  AND [4F].INSTALL_LOC_CD   = 'P'         
                                  AND [4F].INSTALL_LOC_NO >=              
                                      CIS.DIGITS(:WS-IND-PREMISE-NO))       
                  ORDER BY HT.PREMISE_NO                                
                                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE NAME_CUR CURSOR FOR                                       
MFA-TR*          SELECT HT.PREMISE_NO                                           
MFA-TR*                ,HT.ACCOUNT_NO                                           
MFA-TR*                ,RTRIM(LTRIM(RTRIM(DQ.LAST_NAME)   || ' ' ||             
MFA-TR*                       LTRIM(RTRIM(DQ.FIRST_NAME)  || ' ' ||             
MFA-TR*                       LTRIM(RTRIM(DQ.MIDDLE_NAME)))))                   
MFA-TR*                ,HT.CODE_ACCT_STAT                                       
MFA-TR*            FROM CSS_NAME DQ                                             
MFA-TR*                ,CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_NAME_ACCT_XREF HT                                   
MFA-TR*           WHERE DQ.LAST_NAME     LIKE :NAM-LAST-NAME                    
MFA-TR*             AND DQ.FIRST_NAME    LIKE :NAM-FIRST-NAME                   
MFA-TR*             AND DQ.MIDDLE_NAME   LIKE :NAM-MIDDLE-NAME                  
MFA-TR*             AND DQ.NAME_FORMAT      = 'I'                               
MFA-TR*             AND DQ.NAME_TYPE        = 'CN'                              
MFA-TR*             AND HT.NAME_ID          = DQ.NAME_ID                        
MFA-TR*             AND HT.ADDRESS_ID       = DY.ADDRESS_ID                     
MFA-TR*             AND HT.CUSTOMER_ROLE_CD = ' '                               
MFA-TR*             AND HT.COMPANY_NO       = '01'                              
MFA-TR*             AND HT.STATE            = 'SC'                              
MFA-TR*             AND (DY.STREET_NAME = :NAM-STREET-NAME OR                   
MFA-TR*            :NAM-STREET-NAME = '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%')         
MFA-TR*             AND (HT.TOWN = :NAM-CITY-NAME OR                            
MFA-TR*            :NAM-CITY-NAME = '%%%%%%%%%%%%%%%%%%%%%%%%%%')               
MFA-TR*            AND  EXISTS (SELECT 'Y'                                      
MFA-TR*                         FROM LMS_EQUIP_ENVRNMT 4F                       
MFA-TR*                         WHERE 4F.INSTALL_LOC_NO =                       
MFA-TR*                               DIGITS(HT.PREMISE_NO)                     
MFA-TR*                           AND 4F.INSTALL_LOC_CD   = 'P'                 
MFA-TR*                           AND 4F.INSTALL_LOC_NO >=                      
MFA-TR*                               DIGITS(:WS-IND-PREMISE-NO))               
MFA-TR*           ORDER BY HT.PREMISE_NO                                        
MFA-TR*         FETCH FIRST 51 ROWS ONLY                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7080                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE PREMISE NO FROM CUSTOMER ADDRESS        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE ADDR_CUR CURSOR FOR                               
                 SELECT DISTINCT TOP(51) HT.PREMISE_NO                          
                   FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)             
                       ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)             
                 WHERE DY.HOUSE_NO          LIKE :ADD-STREET-NBR        
                   AND DY.ADDR_PREFIX_1     LIKE :ADD-PREFIX-1          
                   AND DY.ADDR_PREFIX_2     LIKE :ADD-PREFIX-2          
                   AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1        
                   AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2        
                   AND DY.STREET_NAME       LIKE :ADD-STREET-NAME       
                   AND DY.ADDRESS_ID           = HT.ADDRESS_ID          
                   AND DY.ADDR_USAGE_CD        = 'F'                    
                   AND HT.TOWN              LIKE :ADD-CITY              
                   AND HT.COMPANY_NO           = '01'                   
                   AND HT.STATE                = 'SC'                   
                   AND HT.CUSTOMER_ROLE_CD     = ' '                    
                   AND HT.PREMISE_NO          >= :WS-IND-PREMISE-NO     
                   AND (EXISTS (SELECT 'X'                              
                                FROM CSS_NAME DQ WITH(READUNCOMMITTED)          
                                WHERE HT.NAME_ID = DQ.NAME_ID           
                                AND DQ.NAME_TYPE = 'CN')                
                            OR HT.NAME_ID = 0)                          
                   AND  EXISTS (SELECT 'Y'                              
                                FROM LMS_EQUIP_ENVRNMT [4F]
                           WITH(READUNCOMMITTED)               
                                WHERE [4F].INSTALL_LOC_NO =               
                                      CIS.DIGITS(HT.PREMISE_NO)             
                                  AND [4F].INSTALL_LOC_CD   = 'P'         
                                  AND [4F].INSTALL_LOC_NO >=              
                                      CIS.DIGITS(:WS-IND-PREMISE-NO))       
                  ORDER BY HT.PREMISE_NO                                
                                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ADDR_CUR CURSOR FOR                                       
MFA-TR*          SELECT DISTINCT HT.PREMISE_NO                                  
MFA-TR*            FROM CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_NAME_ACCT_XREF HT                                   
MFA-TR*          WHERE DY.HOUSE_NO          LIKE :ADD-STREET-NBR                
MFA-TR*            AND DY.ADDR_PREFIX_1     LIKE :ADD-PREFIX-1                  
MFA-TR*            AND DY.ADDR_PREFIX_2     LIKE :ADD-PREFIX-2                  
MFA-TR*            AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                
MFA-TR*            AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                
MFA-TR*            AND DY.STREET_NAME       LIKE :ADD-STREET-NAME               
MFA-TR*            AND DY.ADDRESS_ID           = HT.ADDRESS_ID                  
MFA-TR*            AND DY.ADDR_USAGE_CD        = 'F'                            
MFA-TR*            AND HT.TOWN              LIKE :ADD-CITY                      
MFA-TR*            AND HT.COMPANY_NO           = '01'                           
MFA-TR*            AND HT.STATE                = 'SC'                           
MFA-TR*            AND HT.CUSTOMER_ROLE_CD     = ' '                            
MFA-TR*            AND HT.PREMISE_NO          >= :WS-IND-PREMISE-NO             
MFA-TR*            AND (EXISTS (SELECT 'X'                                      
MFA-TR*                         FROM CSS_NAME DQ                                
MFA-TR*                         WHERE HT.NAME_ID = DQ.NAME_ID                   
MFA-TR*                         AND DQ.NAME_TYPE = 'CN')                        
MFA-TR*                     OR HT.NAME_ID = 0)                                  
MFA-TR*            AND  EXISTS (SELECT 'Y'                                      
MFA-TR*                         FROM LMS_EQUIP_ENVRNMT 4F                       
MFA-TR*                         WHERE 4F.INSTALL_LOC_NO =                       
MFA-TR*                               DIGITS(HT.PREMISE_NO)                     
MFA-TR*                           AND 4F.INSTALL_LOC_CD   = 'P'                 
MFA-TR*                           AND 4F.INSTALL_LOC_NO >=                      
MFA-TR*                               DIGITS(:WS-IND-PREMISE-NO))               
MFA-TR*           ORDER BY HT.PREMISE_NO                                        
MFA-TR*         FETCH FIRST 51 ROWS ONLY                                        
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE PREMISE NO FROM SUBDIVISION ID *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE SUBDIV_CUR CURSOR FOR                             
                 SELECT PR.PREMISE_NO                                   
                   FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                    
                 WHERE PR.SUBDIVISION_ID = :WS-SUBDIVISION-ID           
                   AND PR.PREMISE_NO    >= :WS-IND-PREMISE-NO           
                  ORDER BY PR.PREMISE_NO                                
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SUBDIV_CUR CURSOR FOR                                     
MFA-TR*          SELECT PR.PREMISE_NO                                           
MFA-TR*            FROM CSS_PREMISE PR                                          
MFA-TR*          WHERE PR.SUBDIVISION_ID = :WS-SUBDIVISION-ID                   
MFA-TR*            AND PR.PREMISE_NO    >= :WS-IND-PREMISE-NO                   
MFA-TR*           ORDER BY PR.PREMISE_NO                                        
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7140                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE PREMISE LIGHTS                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE PREM_LIGHT_CUR CURSOR FOR                         
                 SELECT [4D].EQUIP_SEQ                                    
                       ,[4D].EQUIP_TAG_NO                                 
                       ,[4D].STOCK_CD                                     
                       ,[4D].INVENTRY_STATUS_CD                           
                       ,[4F].RATE_PLAN_NO                                 
                   FROM LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)           
                       ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                  WHERE [4F].INSTALL_LOC_NO = :4F-INSTALL-LOC-NO          
                    AND [4F].INSTALL_LOC_CD = 'P'                         
                    AND [4F].EQUIP_SEQ      = [4D].EQUIP_SEQ                
                    AND [4D].EQUIP_TYPE_CD  = 'F'                         
                    AND [4D].EQUIP_TAG_NO  >= :PARM-IND-TAG-NO            
                 UNION                                                  
                 SELECT [4D].EQUIP_SEQ                                    
                       ,[4D].EQUIP_TAG_NO                                 
                       ,[4D].STOCK_CD                                     
                       ,[4D].INVENTRY_STATUS_CD                           
                       ,[4F].RATE_PLAN_NO                                 
                   FROM LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)           
                       ,LMS_SPCL_AGREEMENT [4Q] WITH(READUNCOMMITTED)           
                       ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                  WHERE [4F].INSTALL_LOC_NO = [4Q].AGREEMENT_NO             
                    AND [4Q].PREMISE_NO     = :4Q-PREMISE-NO              
                    AND [4F].INSTALL_LOC_CD = 'Z'                         
                    AND [4F].EQUIP_SEQ      = [4D].EQUIP_SEQ                
                    AND [4D].EQUIP_TYPE_CD  = 'F'                         
                    AND [4D].EQUIP_TAG_NO  >= :PARM-IND-TAG-NO            
ACT072            ORDER BY 2                                            
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PREM_LIGHT_CUR CURSOR FOR                                 
MFA-TR*          SELECT 4D.EQUIP_SEQ                                            
MFA-TR*                ,4D.EQUIP_TAG_NO                                         
MFA-TR*                ,4D.STOCK_CD                                             
MFA-TR*                ,4D.INVENTRY_STATUS_CD                                   
MFA-TR*                ,4F.RATE_PLAN_NO                                         
MFA-TR*            FROM LMS_EQUIP_ENVRNMT  4F                                   
MFA-TR*                ,LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*           WHERE 4F.INSTALL_LOC_NO = :4F-INSTALL-LOC-NO                  
MFA-TR*             AND 4F.INSTALL_LOC_CD = 'P'                                 
MFA-TR*             AND 4F.EQUIP_SEQ      = 4D.EQUIP_SEQ                        
MFA-TR*             AND 4D.EQUIP_TYPE_CD  = 'F'                                 
MFA-TR*             AND 4D.EQUIP_TAG_NO  >= :PARM-IND-TAG-NO                    
MFA-TR*          UNION                                                          
MFA-TR*          SELECT 4D.EQUIP_SEQ                                            
MFA-TR*                ,4D.EQUIP_TAG_NO                                         
MFA-TR*                ,4D.STOCK_CD                                             
MFA-TR*                ,4D.INVENTRY_STATUS_CD                                   
MFA-TR*                ,4F.RATE_PLAN_NO                                         
MFA-TR*            FROM LMS_EQUIP_ENVRNMT  4F                                   
MFA-TR*                ,LMS_SPCL_AGREEMENT 4Q                                   
MFA-TR*                ,LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*           WHERE 4F.INSTALL_LOC_NO = 4Q.AGREEMENT_NO                     
MFA-TR*             AND 4Q.PREMISE_NO     = :4Q-PREMISE-NO                      
MFA-TR*             AND 4F.INSTALL_LOC_CD = 'Z'                                 
MFA-TR*             AND 4F.EQUIP_SEQ      = 4D.EQUIP_SEQ                        
MFA-TR*             AND 4D.EQUIP_TYPE_CD  = 'F'                                 
MFA-TR*             AND 4D.EQUIP_TAG_NO  >= :PARM-IND-TAG-NO                    
MFA-TR*           ORDER BY 2                                                    
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7170                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE SUBDIVISION LIGHTS             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE SUBDIV_LIGHT_CUR CURSOR FOR                       
                 SELECT [4D].EQUIP_SEQ                                    
                       ,[4D].EQUIP_TAG_NO                                 
                       ,[4D].STOCK_CD                                     
                       ,[4F].RATE_PLAN_NO                                 
                   FROM LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)           
                       ,LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                  WHERE CIS.SUBSTR3([4F].INSTALL_LOC_NO,1,3)                   
                                          = :WS-SUBDIVISION-ID          
                    AND [4F].INSTALL_LOC_CD = 'S'                         
                    AND [4F].EQUIP_SEQ      = [4D].EQUIP_SEQ                
                    AND [4D].EQUIP_TAG_NO  >= :PARM-IND-TAG-NO            
                    AND [4D].EQUIP_TYPE_CD  = 'F'                         
ACT072            ORDER BY 2                                            
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SUBDIV_LIGHT_CUR CURSOR FOR                               
MFA-TR*          SELECT 4D.EQUIP_SEQ                                            
MFA-TR*                ,4D.EQUIP_TAG_NO                                         
MFA-TR*                ,4D.STOCK_CD                                             
MFA-TR*                ,4F.RATE_PLAN_NO                                         
MFA-TR*            FROM LMS_EQUIP_ENVRNMT  4F                                   
MFA-TR*                ,LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*           WHERE SUBSTR(4F.INSTALL_LOC_NO,1,3)                           
MFA-TR*                                   = :WS-SUBDIVISION-ID                  
MFA-TR*             AND 4F.INSTALL_LOC_CD = 'S'                                 
MFA-TR*             AND 4F.EQUIP_SEQ      = 4D.EQUIP_SEQ                        
MFA-TR*             AND 4D.EQUIP_TAG_NO  >= :PARM-IND-TAG-NO                    
MFA-TR*             AND 4D.EQUIP_TYPE_CD  = 'F'                                 
MFA-TR*           ORDER BY 2                                                    
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE FIXTURE FOR A GIVEN POLE NUMBER*        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE POLE_CUR CURSOR FOR                               
                 SELECT [4H].FXTR_EQUIP_SEQ                               
                       ,[4D].EQUIP_TAG_NO                                 
                       ,[4D].INVENTRY_STATUS_CD                           
                   FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)           
                       ,LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)           
                  WHERE [4D].EQUIP_TAG_NO LIKE :4D-EQUIP-TAG-NO           
                    AND [4D].EQUIP_TYPE_CD    = 'P'                       
                    AND [4H].ATTACH_EQUIP_SEQ = [4D].EQUIP_SEQ              
                    AND [4H].EQUIP_TYPE_CD    = [4D].EQUIP_TYPE_CD          
                    AND [4D].EQUIP_TAG_NO    >= :PARM-IND-TAG-NO          
                  ORDER BY 2                                            
                FOR READ ONLY                                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE POLE_CUR CURSOR FOR                                       
MFA-TR*          SELECT 4H.FXTR_EQUIP_SEQ                                       
MFA-TR*                ,4D.EQUIP_TAG_NO                                         
MFA-TR*                ,4D.INVENTRY_STATUS_CD                                   
MFA-TR*            FROM LMS_EQUIP_INVENTRY 4D                                   
MFA-TR*                ,LMS_FXTR_ATTACHMTS 4H                                   
MFA-TR*           WHERE 4D.EQUIP_TAG_NO LIKE :4D-EQUIP-TAG-NO                   
MFA-TR*             AND 4D.EQUIP_TYPE_CD    = 'P'                               
MFA-TR*             AND 4H.ATTACH_EQUIP_SEQ = 4D.EQUIP_SEQ                      
MFA-TR*             AND 4H.EQUIP_TYPE_CD    = 4D.EQUIP_TYPE_CD                  
MFA-TR*             AND 4D.EQUIP_TAG_NO    >= :PARM-IND-TAG-NO                  
MFA-TR*           ORDER BY 2                                                    
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7230                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE FIXTURE FOR A GIVEN CLP #      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CLP_CUR CURSOR FOR                                
ACT033          SELECT DISTINCT [4D].EQUIP_SEQ                            
                      ,[4D].INVENTRY_STATUS_CD                            
                  FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)            
                      ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)            
                      ,LMS_EQUIP_CONTRACT [4L] WITH(READUNCOMMITTED)            
                 WHERE [4L].CNTRCT_CLP_NO   = :4L-CNTRCT-CLP-NO           
                   AND [4L].INSTALL_LOC_NO  = [4F].INSTALL_LOC_NO           
                   AND [4F].INSTALL_LOC_CD  = 'P'                         
                   AND [4F].EQUIP_SEQ       = [4D].EQUIP_SEQ                
ACT040             AND [4D].EQUIP_SEQ       = [4L].EQUIP_SEQ                
                   AND [4D].EQUIP_TYPE_CD   = 'F'                         
                   AND [4L].INSTALL_LOC_NO >= :PARM-IND-PREMISE           
                 ORDER BY [4D].EQUIP_SEQ                                  
                FOR READ ONLY                                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CLP_CUR CURSOR FOR                                        
MFA-TR*         SELECT DISTINCT 4D.EQUIP_SEQ                                    
MFA-TR*               ,4D.INVENTRY_STATUS_CD                                    
MFA-TR*           FROM LMS_EQUIP_INVENTRY 4D                                    
MFA-TR*               ,LMS_EQUIP_ENVRNMT  4F                                    
MFA-TR*               ,LMS_EQUIP_CONTRACT 4L                                    
MFA-TR*          WHERE 4L.CNTRCT_CLP_NO   = :4L-CNTRCT-CLP-NO                   
MFA-TR*            AND 4L.INSTALL_LOC_NO  = 4F.INSTALL_LOC_NO                   
MFA-TR*            AND 4F.INSTALL_LOC_CD  = 'P'                                 
MFA-TR*            AND 4F.EQUIP_SEQ       = 4D.EQUIP_SEQ                        
MFA-TR*            AND 4D.EQUIP_SEQ       = 4L.EQUIP_SEQ                        
MFA-TR*            AND 4D.EQUIP_TYPE_CD   = 'F'                                 
MFA-TR*            AND 4L.INSTALL_LOC_NO >= :PARM-IND-PREMISE                   
MFA-TR*          ORDER BY 4D.EQUIP_SEQ                                          
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO GET THE FIXTURE FOR A GIVEN WMS REQ NO *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE WMS_CUR CURSOR FOR                                
                SELECT [4D].EQUIP_SEQ                                     
                      ,[4D].INVENTRY_STATUS_CD                            
                  FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)            
                      ,LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)            
                 WHERE [4F].SOURCE_APPL_REQ_NO = :4F-SOURCE-APPL-REQ-NO   
                   AND [4F].SOURCE_APPL_CD     = 'WMS'                    
                   AND [4F].EQUIP_SEQ          = [4D].EQUIP_SEQ             
                   AND [4D].EQUIP_TYPE_CD      = 'F'                      
                   AND [4D].EQUIP_TAG_NO      >= :PARM-IND-TAG-NO         
                 ORDER BY [4D].EQUIP_SEQ                                  
                FOR READ ONLY                                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WMS_CUR CURSOR FOR                                        
MFA-TR*         SELECT 4D.EQUIP_SEQ                                             
MFA-TR*               ,4D.INVENTRY_STATUS_CD                                    
MFA-TR*           FROM LMS_EQUIP_INVENTRY 4D                                    
MFA-TR*               ,LMS_EQUIP_ENVRNMT  4F                                    
MFA-TR*          WHERE 4F.SOURCE_APPL_REQ_NO = :4F-SOURCE-APPL-REQ-NO           
MFA-TR*            AND 4F.SOURCE_APPL_CD     = 'WMS'                            
MFA-TR*            AND 4F.EQUIP_SEQ          = 4D.EQUIP_SEQ                     
MFA-TR*            AND 4D.EQUIP_TYPE_CD      = 'F'                              
MFA-TR*            AND 4D.EQUIP_TAG_NO      >= :PARM-IND-TAG-NO                 
MFA-TR*          ORDER BY 4D.EQUIP_SEQ                                          
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION USED TO SEARCH FOR BUSINESS'S NAME WITH   *        
      *                    A PRIMARY STREET NAME.                      *        
      ******************************************************************        
           EXEC SQL DECLARE BIZ_NAME_CUR CURSOR FOR                     
               SELECT TOP(51) HT.PREMISE_NO,
              HT.ACCOUNT_NO,
              DQ.FULL_NAME,
              HT.CODE_ACCT_STAT                                 
                 FROM CSS_NAME           DQ WITH(READUNCOMMITTED)               
                     ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                     ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.FULL_NAME    LIKE :BIZ-NAME                    
                  AND DQ.NAME_FORMAT     = 'B'                          
                  AND DQ.NAME_TYPE NOT  IN ('AN', 'AA', 'AI')           
                  AND DY.STREET_NAME  LIKE :BIZ-STREET-NAME             
                  AND HT.NAME_ID         = DQ.NAME_ID                   
                  AND HT.ADDRESS_ID      = DY.ADDRESS_ID                
                  AND HT.COMPANY_NO      = '01'                         
                  AND HT.STATE           = 'SC'                         
                  AND  EXISTS (SELECT 'Y'                               
                               FROM LMS_EQUIP_ENVRNMT [4F]
                           WITH(READUNCOMMITTED)                
                               WHERE [4F].INSTALL_LOC_NO =                
                                     CIS.DIGITS(HT.PREMISE_NO)              
                                 AND [4F].INSTALL_LOC_CD   = 'P'          
                                 AND [4F].INSTALL_LOC_NO >=               
                                     CIS.DIGITS(:WS-IND-PREMISE-NO))        
             ORDER BY HT.PREMISE_NO                                     
                                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE BIZ_NAME_CUR CURSOR FOR                             
MFA-TR*        SELECT HT.PREMISE_NO                                             
MFA-TR*              ,HT.ACCOUNT_NO                                             
MFA-TR*              ,DQ.FULL_NAME                                              
MFA-TR*              ,HT.CODE_ACCT_STAT                                         
MFA-TR*          FROM CSS_NAME           DQ                                     
MFA-TR*              ,CSS_ADDR_FORMATTED DY                                     
MFA-TR*              ,CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FULL_NAME    LIKE :BIZ-NAME                            
MFA-TR*           AND DQ.NAME_FORMAT     = 'B'                                  
MFA-TR*           AND DQ.NAME_TYPE NOT  IN ('AN', 'AA', 'AI')                   
MFA-TR*           AND DY.STREET_NAME  LIKE :BIZ-STREET-NAME                     
MFA-TR*           AND HT.NAME_ID         = DQ.NAME_ID                           
MFA-TR*           AND HT.ADDRESS_ID      = DY.ADDRESS_ID                        
MFA-TR*           AND HT.COMPANY_NO      = '01'                                 
MFA-TR*           AND HT.STATE           = 'SC'                                 
MFA-TR*           AND  EXISTS (SELECT 'Y'                                       
MFA-TR*                        FROM LMS_EQUIP_ENVRNMT 4F                        
MFA-TR*                        WHERE 4F.INSTALL_LOC_NO =                        
MFA-TR*                              DIGITS(HT.PREMISE_NO)                      
MFA-TR*                          AND 4F.INSTALL_LOC_CD   = 'P'                  
MFA-TR*                          AND 4F.INSTALL_LOC_NO >=                       
MFA-TR*                              DIGITS(:WS-IND-PREMISE-NO))                
MFA-TR*      ORDER BY HT.PREMISE_NO                                             
MFA-TR*      FETCH FIRST 51 ROWS ONLY                                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7830                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION FOR THE GLOBAL TEMP TABLE 1               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                 WITH ROWSET POSITIONING FOR                            
               SELECT RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,FIX_EQUIP_SEQ                                     
                     ,FIX_TAG                                           
                     ,LIGHT_STATUS                                      
                     ,FIX_STOCK_CD                                      
                     ,FIX_RATE                                          
                     ,POLE_TAG                                          
                     ,POLE_STOCK_CD                                     
                     ,ACCOUNT_NO                                        
                     ,ACCT_STATUS                                       
                     ,SUBDIVISION_ID                                    
                     ,CUSTOMER_NAME                                     
                     ,ADDRESS_LINE1                                     
                     ,ADDRESS_LINE2                                     
                     ,POLE_COUNT                                        
               FROM #CSR04761_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*          WITH ROWSET POSITIONING FOR                                    
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,FIX_EQUIP_SEQ                                             
MFA-TR*              ,FIX_TAG                                                   
MFA-TR*              ,LIGHT_STATUS                                              
MFA-TR*              ,FIX_STOCK_CD                                              
MFA-TR*              ,FIX_RATE                                                  
MFA-TR*              ,POLE_TAG                                                  
MFA-TR*              ,POLE_STOCK_CD                                             
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,ACCT_STATUS                                               
MFA-TR*              ,SUBDIVISION_ID                                            
MFA-TR*              ,CUSTOMER_NAME                                             
MFA-TR*              ,ADDRESS_LINE1                                             
MFA-TR*              ,ADDRESS_LINE2                                             
MFA-TR*              ,POLE_COUNT                                                
MFA-TR*        FROM SESSION.CSR04761_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION FOR THE GLOBAL TEMP TABLE 2               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                 WITH ROWSET POSITIONING FOR                            
               SELECT RETURN_CODE                                       
                     ,IND_TYP                                           
                     ,IND_KEY                                           
               FROM #CSR04761_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*          WITH ROWSET POSITIONING FOR                                    
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,IND_TYP                                                   
MFA-TR*              ,IND_KEY                                                   
MFA-TR*        FROM SESSION.CSR04761_R2                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SEARCH-TYPE                 PIC X(02).                  
       01  LINK-SEARCH-IND-TYP              PIC X(01).                  
       01  LINK-SEARCH-IND-KEY              PIC X(25).                  
       01  LINK-SEARCH-CRITERIA             PIC X(250).                 
                                                                        
       PROCEDURE DIVISION USING LINK-SEARCH-TYPE                        
                                LINK-SEARCH-IND-TYP                     
                                LINK-SEARCH-IND-KEY                     
                                LINK-SEARCH-CRITERIA.                   
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT        THRU 0100B-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04761_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04761_R1
               (  RETURN_CODE              INT                    
                   ,APPL_RETURN_CODE         INT                    
                   ,FIX_EQUIP_SEQ            DECIMAL(10,0)              
                   ,FIX_TAG CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,LIGHT_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,FIX_STOCK_CD CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,FIX_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,POLE_TAG CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,POLE_STOCK_CD CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,ACCOUNT_NO               DECIMAL(13,0)              
                   ,ACCT_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,SUBDIVISION_ID CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,CUSTOMER_NAME CHAR(70)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,ADDRESS_LINE1 CHAR(85)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,ADDRESS_LINE2 CHAR(85)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
                   ,POLE_COUNT               INT                    
                 )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE TO WS-SQLSTATE.                               
            MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS  THRU 8000A-EXIT           
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE GTT-NAME-1           TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
               END-IF                                                   
            END-IF.                                                     
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0100B-DECLARE-GTT.                                               
                                                                        
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04761_R2')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04761_R2
               (  RETURN_CODE              INT                    
                   ,IND_TYP CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,IND_KEY CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2           
                 )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE TO WS-SQLSTATE.                               
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000B-DELETE-GTT-ROWS   THRU 8000B-EXIT          
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100B'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE GTT-NAME-2           TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
               END-IF                                                   
            END-IF.                                                     
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-SEARCH-TYPE            TO PARM-SEARCH-TYPE         
                                               WS-SEARCH-TYPE.          
           MOVE LINK-SEARCH-CRITERIA        TO PARM-SEARCH-CRITERIA.    
           MOVE LINK-SEARCH-IND-TYP         TO PARM-IND-TYP.            
           MOVE 'E'                         TO S-IND-TYP.               
                                                                        
           IF PARM-IND-TYP = 'S'                                        
              MOVE SPACES                   TO PARM-IND-KEY             
              MOVE 'C1'                     TO PARM-IND-CURSOR          
           ELSE                                                         
              MOVE LINK-SEARCH-IND-KEY      TO PARM-IND-KEY             
              MOVE PARM-IND-PREMISE         TO WS-IND-PREMISE           
              MOVE WS-IND-PREMISE           TO WS-IND-PREMISE-NO        
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-ACCOUNT-NO                                      
              MOVE PARM-SEARCH-CRITERIA     TO WS-ACCOUNT-NUM-STR       
              MOVE WS-ACCOUNT-NO            TO AT-ACCOUNT-NO            
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-CUSTOMER-NO                                     
              MOVE PARM-SEARCH-CRITERIA     TO WS-CUSTOMER-NUM-STR      
              MOVE WS-CUSTOMER-NO           TO AT-CUSTOMER-NO           
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-METER-NO                                        
              MOVE PARM-SEARCH-CRITERIA(1:9) TO EQ-DEVICE-NO            
              MOVE PARM-SEARCH-CRITERIA(10:1) TO EQ-CODE-UTIL-TYPE      
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-POINT-ID                                        
              MOVE PARM-SEARCH-CRITERIA(1:3) TO WS-GIS-LOC-OFF          
              MOVE PARM-SEARCH-CRITERIA(4:7) TO WS-TAG-NM               
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-SUB-DIVISION                                    
              MOVE PARM-SEARCH-CRITERIA     TO WS-SUBDIVISION-ID        
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-NAME                                            
              UNSTRING PARM-SEARCH-CRITERIA DELIMITED BY CN-DELIMITER   
                  INTO NAM-FIRST-NAME                                   
                       NAM-MIDDLE-NAME                                  
                       NAM-LAST-NAME                                    
                       NAM-CITY-NAME                                    
                       NAM-STREET-NAME                                  
                                                                        
              IF NAM-FIRST-NAME > ' '                                   
                 MOVE 0 TO WS-STAR-COUNT                                
                 INSPECT NAM-FIRST-NAME TALLYING WS-STAR-COUNT          
                     FOR ALL '*'                                        
                 IF WS-STAR-COUNT > 0                                   
                    INSPECT NAM-FIRST-NAME REPLACING ALL                
                        '*' BY '%'                                      
                    MOVE FUNCTION REVERSE(NAM-FIRST-NAME) TO            
                         NAM-FIRST-NAME                                 
                    INSPECT NAM-FIRST-NAME REPLACING LEADING            
                     SPACES BY '%'                                      
                    MOVE FUNCTION REVERSE(NAM-FIRST-NAME) TO            
                         NAM-FIRST-NAME                                 
                 END-IF                                                 
              ELSE                                                      
                 MOVE ALL '%' TO NAM-FIRST-NAME                         
              END-IF                                                    
                                                                        
              IF NAM-MIDDLE-NAME > ' '                                  
                 MOVE 0 TO WS-STAR-COUNT                                
                 INSPECT NAM-MIDDLE-NAME TALLYING WS-STAR-COUNT         
                     FOR ALL '*'                                        
                 IF WS-STAR-COUNT > 0                                   
                    INSPECT NAM-MIDDLE-NAME REPLACING ALL               
                        '*' BY '%'                                      
                    MOVE FUNCTION REVERSE(NAM-MIDDLE-NAME) TO           
                         NAM-MIDDLE-NAME                                
                    INSPECT NAM-MIDDLE-NAME REPLACING LEADING           
                     SPACES BY '%'                                      
                    MOVE FUNCTION REVERSE(NAM-MIDDLE-NAME) TO           
                         NAM-MIDDLE-NAME                                
                 END-IF                                                 
              ELSE                                                      
                 MOVE ALL '%' TO NAM-MIDDLE-NAME                        
              END-IF                                                    
                                                                        
              IF NAM-LAST-NAME > ' '                                    
                 MOVE 0 TO WS-STAR-COUNT                                
                 INSPECT NAM-LAST-NAME TALLYING WS-STAR-COUNT           
                     FOR ALL '*'                                        
                 IF WS-STAR-COUNT > 0                                   
                    INSPECT NAM-LAST-NAME REPLACING ALL                 
                        '*' BY '%'                                      
                    MOVE FUNCTION REVERSE(NAM-LAST-NAME) TO             
                         NAM-LAST-NAME                                  
                    INSPECT NAM-LAST-NAME REPLACING LEADING             
                            SPACES BY '%'                               
                    MOVE FUNCTION REVERSE(NAM-LAST-NAME) TO             
                         NAM-LAST-NAME                                  
                 END-IF                                                 
              ELSE                                                      
                 MOVE ALL '%' TO NAM-LAST-NAME                          
              END-IF                                                    
                                                                        
              IF NAM-CITY-NAME = '  '                                   
                 MOVE ALL '%' TO NAM-CITY-NAME                          
              END-IF                                                    
                                                                        
              IF NAM-STREET-NAME = '  '                                 
                 MOVE ALL '%' TO NAM-STREET-NAME                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-BIZ-NAME                                        
              UNSTRING PARM-SEARCH-CRITERIA DELIMITED BY CN-DELIMITER   
                  INTO BIZ-NAME                                         
                       BIZ-STREET-NAME                                  
                                                                        
              IF BIZ-NAME > ' '                                         
                 MOVE 0 TO WS-STAR-COUNT                                
                 INSPECT BIZ-NAME TALLYING WS-STAR-COUNT                
                     FOR ALL '*'                                        
                 IF WS-STAR-COUNT > 0                                   
                    INSPECT BIZ-NAME REPLACING ALL                      
                        '*' BY '%'                                      
                    MOVE FUNCTION REVERSE(BIZ-NAME) TO                  
                         BIZ-NAME                                       
                    INSPECT BIZ-NAME REPLACING LEADING                  
                     SPACES BY '%'                                      
                    MOVE FUNCTION REVERSE(BIZ-NAME) TO                  
                         BIZ-NAME                                       
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF BIZ-STREET-NAME = ' '                                  
                 MOVE ALL '%' TO BIZ-STREET-NAME                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-ADDRESS                                         
              UNSTRING PARM-SEARCH-CRITERIA DELIMITED BY CN-DELIMITER   
                  INTO ADD-STREET-NBR                                   
                       ADD-PREFIX-1                                     
                       ADD-PREFIX-2                                     
                       ADD-STREET-NAME                                  
                       ADD-LOCATION-1                                   
                       ADD-LOCATION-2                                   
                       ADD-CITY                                         
                                                                        
              IF ADD-STREET-NBR > ' '                                   
                 MOVE 0 TO WS-STAR-COUNT                                
                 INSPECT ADD-STREET-NBR TALLYING WS-STAR-COUNT          
                    FOR ALL '*'                                         
                 IF WS-STAR-COUNT > 0                                   
                    INSPECT ADD-STREET-NBR REPLACING ALL                
                       '*' BY '%'                                       
                    MOVE FUNCTION REVERSE(ADD-STREET-NBR) TO            
                       ADD-STREET-NBR                                   
                    INSPECT ADD-STREET-NBR REPLACING LEADING            
                       SPACES BY '%'                                    
                    MOVE FUNCTION REVERSE(ADD-STREET-NBR) TO            
                       ADD-STREET-NBR                                   
                 END-IF                                                 
              ELSE                                                      
                 MOVE ALL '%' TO ADD-STREET-NBR                         
              END-IF                                                    
                                                                        
              IF ADD-PREFIX-1 = '   '                                   
                  MOVE ALL '%' TO ADD-PREFIX-1                          
              END-IF                                                    
                                                                        
              IF ADD-PREFIX-2 = '  '                                    
                  MOVE ALL '%' TO ADD-PREFIX-2                          
              END-IF                                                    
                                                                        
              IF ADD-STREET-NAME > ' '                                  
                 MOVE 0 TO WS-STAR-COUNT                                
                 INSPECT ADD-STREET-NAME TALLYING WS-STAR-COUNT         
                    FOR ALL '*'                                         
                 IF WS-STAR-COUNT > 0                                   
                    INSPECT ADD-STREET-NAME REPLACING ALL               
                       '*' BY '%'                                       
                    MOVE FUNCTION REVERSE(ADD-STREET-NAME) TO           
                       ADD-STREET-NAME                                  
                    INSPECT ADD-STREET-NAME REPLACING LEADING           
                       SPACES BY '%'                                    
                    MOVE FUNCTION REVERSE(ADD-STREET-NAME) TO           
                       ADD-STREET-NAME                                  
                 END-IF                                                 
              ELSE                                                      
                 MOVE ALL '%' TO ADD-STREET-NAME                        
              END-IF                                                    
                                                                        
              IF ADD-LOCATION-1 = ' '                                   
                 MOVE ALL '%' TO ADD-LOCATION-1                         
              END-IF                                                    
                                                                        
              IF ADD-LOCATION-2 > ' '                                   
                 MOVE 0 TO WS-STAR-COUNT                                
                 INSPECT ADD-LOCATION-2 TALLYING WS-STAR-COUNT          
                    FOR ALL '*'                                         
                 IF WS-STAR-COUNT > 0                                   
                    INSPECT ADD-LOCATION-2 REPLACING ALL                
                       '*' BY '%'                                       
                    MOVE FUNCTION REVERSE(ADD-LOCATION-2) TO            
                       ADD-LOCATION-2                                   
                    INSPECT ADD-LOCATION-2 REPLACING LEADING            
                       SPACES BY '%'                                    
                    MOVE FUNCTION REVERSE(ADD-LOCATION-2) TO            
                       ADD-LOCATION-2                                   
                 END-IF                                                 
              ELSE                                                      
                 MOVE ALL '%' TO ADD-LOCATION-2                         
              END-IF                                                    
                                                                        
              IF ADD-CITY = ' '                                         
                 MOVE ALL '%' TO ADD-CITY                               
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-FIXTURE-ID                                      
              MOVE PARM-SEARCH-CRITERIA     TO WS-FXTR-ID-ARRAY         
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-POLE-NO                                         
              MOVE PARM-SEARCH-CRITERIA     TO 4D-EQUIP-TAG-NO          
              MOVE 0 TO WS-STAR-COUNT                                   
              INSPECT 4D-EQUIP-TAG-NO TALLYING WS-STAR-COUNT            
                    FOR ALL '*'                                         
              IF WS-STAR-COUNT > 0                                      
                 INSPECT 4D-EQUIP-TAG-NO REPLACING ALL '*' BY '%'       
                 MOVE FUNCTION REVERSE(4D-EQUIP-TAG-NO)                 
                                            TO 4D-EQUIP-TAG-NO          
                 INSPECT 4D-EQUIP-TAG-NO REPLACING LEADING              
                       SPACES BY '%'                                    
                 MOVE FUNCTION REVERSE(4D-EQUIP-TAG-NO)                 
                                            TO 4D-EQUIP-TAG-NO          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-NODE-NO                                         
              MOVE PARM-SEARCH-CRITERIA     TO WS-NODE-TAG-NO           
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-CLP-NO                                          
ACT040        MOVE PARM-SEARCH-CRITERIA     TO 4L-CNTRCT-CLP-NO         
           END-IF.                                                      
                                                                        
           IF SEARCH-BY-WMS-REQ-NO                                      
              MOVE PARM-SEARCH-CRITERIA     TO WS-WMS-REQ-NO-STR        
              MOVE WS-WMS-REQ-NO            TO 4F-SOURCE-APPL-REQ-NO    
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
             WHEN SEARCH-BY-ACCOUNT-NO                                  
              PERFORM 7000-GET-ACCT-PREMISE    THRU 7000-EXIT           
              PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT           
                                                                        
             WHEN SEARCH-BY-CUSTOMER-NO                                 
              PERFORM 7010-OPEN-CUST-CSR       THRU 7010-EXIT           
              PERFORM 7020-FETCH-CUST-CSR      THRU 7020-EXIT           
              PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7030-CLOSE-CUST-CSR      THRU 7030-EXIT           
                                                                        
             WHEN SEARCH-BY-METER-NO                                    
              PERFORM 7040-GET-METER-PREMISE   THRU 7040-EXIT           
              PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT           
                                                                        
             WHEN SEARCH-BY-POINT-ID                                    
              PERFORM 7050-OPEN-POINTID-CUR    THRU 7050-EXIT           
              PERFORM 7060-FETCH-POINTID-CUR   THRU 7060-EXIT           
              PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7070-CLOSE-POINTID-CUR   THRU 7070-EXIT           
                                                                        
             WHEN SEARCH-BY-NAME                                        
              PERFORM 7080-OPEN-NAME-CUR       THRU 7080-EXIT           
              PERFORM 7090-FETCH-NAME-CUR      THRU 7090-EXIT           
              PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7100-CLOSE-NAME-CUR      THRU 7100-EXIT           
                                                                        
             WHEN SEARCH-BY-BIZ-NAME                                    
              PERFORM 7830-OPEN-BIZ-NAME-CUR   THRU 7830-EXIT           
              PERFORM 7840-FETCH-BIZ-NAME-CUR  THRU 7840-EXIT           
              PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7850-CLOSE-BIZ-NAME-CUR  THRU 7850-EXIT           
                                                                        
             WHEN SEARCH-BY-ADDRESS                                     
              PERFORM 7110-OPEN-ADDR-CUR       THRU 7110-EXIT           
              PERFORM 7120-FETCH-ADDR-CUR      THRU 7120-EXIT           
              PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7130-CLOSE-ADDR-CUR      THRU 7130-EXIT           
                                                                        
             WHEN SEARCH-BY-SUB-DIVISION                                
              IF PARM-IND-CURSOR = 'C1'                                 
                 PERFORM 7140-OPEN-SUBDIV-CUR     THRU 7140-EXIT        
                 PERFORM 7150-FETCH-SUBDIV-CUR    THRU 7150-EXIT        
                 PERFORM 2200-GET-LIGHT-DETAILS   THRU 2200-EXIT        
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                      OR END-OF-50-ROWS                                 
                 PERFORM 7160-CLOSE-SUBDIV-CUR    THRU 7160-EXIT        
                                                                        
                 IF CTR-ROWS-RS3 > WS-50                                
                    GO TO 2000-EXIT                                     
                 END-IF                                                 
                                                                        
                 MOVE 'C2'                     TO PARM-IND-CURSOR       
                 PERFORM 7200-OPEN-SUBDIV-LIGHT-CUR  THRU 7200-EXIT     
                 PERFORM 7210-FETCH-SUBDIV-LIGHT-CUR THRU 7210-EXIT     
                 PERFORM 2500-BUILD-SUBDIVSION-LIGHT THRU 2500-EXIT     
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                      OR END-OF-50-ROWS                                 
                 PERFORM 7220-CLOSE-SUBDIV-LIGHT-CUR THRU 7220-EXIT     
              ELSE                                                      
                 PERFORM 7200-OPEN-SUBDIV-LIGHT-CUR  THRU 7200-EXIT     
                 PERFORM 7210-FETCH-SUBDIV-LIGHT-CUR THRU 7210-EXIT     
                 PERFORM 2500-BUILD-SUBDIVSION-LIGHT THRU 2500-EXIT     
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                      OR END-OF-50-ROWS                                 
                 PERFORM 7220-CLOSE-SUBDIV-LIGHT-CUR THRU 7220-EXIT     
              END-IF                                                    
                                                                        
             WHEN SEARCH-BY-FIXTURE-ID                                  
                PERFORM VARYING WS-FXTR-INDX FROM 1 BY 1                
                  UNTIL WS-FXTR-INDX > WS-MAX-FXTR-CNT                  
                     OR WS-FXTR-ID(WS-FXTR-INDX) <= SPACES              
                     OR WS-FXTR-ID(WS-FXTR-INDX) <= LOW-VALUES          
                                                                        
                    MOVE WS-FIXTURE         TO 4D-EQUIP-TYPE-CD         
                    MOVE WS-FXTR-ID(WS-FXTR-INDX)                       
                                            TO 4D-EQUIP-TAG-NO          
                                                                        
                    PERFORM 7810-EQUIP-INV-TAG-DET  THRU 7810-EXIT      
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       IF 4D-INVENTRY-STATUS-CD = 'J'                   
                          PERFORM 2600-BUILD-FIXTR-LIGHT                
                                                    THRU 2600-EXIT      
                       ELSE                                             
                          MOVE 0            TO HT-ACCOUNT-NO            
                          PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT     
                       END-IF                                           
                    END-IF                                              
                END-PERFORM                                             
                                                                        
             WHEN SEARCH-BY-POLE-NO                                     
              PERFORM 7230-OPEN-POLE-CUR       THRU 7230-EXIT           
              PERFORM 7240-FETCH-POLE-CUR      THRU 7240-EXIT           
              PERFORM 2600-BUILD-FIXTR-LIGHT   THRU 2600-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7250-CLOSE-POLE-CUR      THRU 7250-EXIT           
                                                                        
             WHEN SEARCH-BY-NODE-NO                                     
              PERFORM 7260-GET-NODE-FIXTR-SEQ  THRU 7260-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2600-BUILD-FIXTR-LIGHT THRU 2600-EXIT          
              END-IF                                                    
                                                                        
             WHEN SEARCH-BY-WMS-REQ-NO                                  
              PERFORM 7270-OPEN-WMS-CUR        THRU 7270-EXIT           
              PERFORM 7280-FETCH-WMS-CUR       THRU 7280-EXIT           
              PERFORM 2600-BUILD-FIXTR-LIGHT   THRU 2600-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7290-CLOSE-WMS-CUR       THRU 7290-EXIT           
                                                                        
             WHEN SEARCH-BY-CLP-NO                                      
              PERFORM 7310-OPEN-CLP-CUR        THRU 7310-EXIT           
              PERFORM 7320-FETCH-CLP-CUR       THRU 7320-EXIT           
              PERFORM 2600-BUILD-FIXTR-LIGHT   THRU 2600-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR END-OF-50-ROWS                                    
              PERFORM 7330-CLOSE-CLP-CUR       THRU 7330-EXIT           
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE 0                           TO S-APPL-RETURN-CODE.      
           IF NOT-A-CURRNT-ACCNT                                        
              MOVE +913                     TO S-APPL-RETURN-CODE       
           END-IF.                                                      
                                                                        
           MOVE 4D-EQUIP-SEQ                TO S-FIX-EQUIP-SEQ.         
           MOVE 4D-EQUIP-TAG-NO             TO S-FIX-TAG.               
           MOVE 4D-INVENTRY-STATUS-CD       TO S-LIGHT-STATUS.          
           MOVE 4D-STOCK-CD                 TO S-FIX-STOCK-CD.          
           MOVE 4F-RATE-PLAN-NO             TO S-FIX-RATE.              
           MOVE WS-EQUIP-TAG-NO             TO S-POLE-TAG.              
           MOVE WS-STOCK-CD                 TO S-POLE-STOCK-CD.         
           MOVE HT-ACCOUNT-NO               TO S-ACCOUNT-NO.            
           MOVE HT-CODE-ACCT-STAT           TO S-ACCT-STATUS.           
           MOVE PR-SUBDIVISION-ID           TO S-SUBDIVISION-ID.        
           MOVE DQ-FULL-NAME                TO S-CUSTOMER-NAME.         
           MOVE WS-ADDRESS-LINE1            TO S-ADDRESS-LINE1.         
           MOVE WS-ADDRESS-LINE2            TO S-ADDRESS-LINE2.         
           MOVE WS-POLE-COUNT               TO S-POLE-COUNT.            
                                                                        
           PERFORM 8100-SEND-RESULT-1          THRU 8100-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2200-GET-LIGHT-DETAILS.                                          
                                                                        
           MOVE WS-YES                      TO WS-GET-NAME-ADDR-FL.     
           MOVE WS-NO                       TO WS-SKIP-ACCOUNT.         
           MOVE WS-PREMISE-NO               TO WS-PREMISE-NUM.          
           MOVE WS-PREMISE                  TO 4F-INSTALL-LOC-NO        
                                               4Q-PREMISE-NO.           
      **** GET ALL LIGHTS FOR THE PREMISE                                       
           PERFORM 7170-OPEN-PREM-LIGHT-CUR    THRU 7170-EXIT.          
                                                                        
           PERFORM 7180-FETCH-PREM-LIGHT-CUR   THRU 7180-EXIT.          
                                                                        
           PERFORM 2400-BUILD-PREM-LIGHTS      THRU 2400-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                OR SKIP-ACCOUNT                                         
                OR END-OF-50-ROWS.                                      
                                                                        
           PERFORM 7190-CLOSE-PREM-LIGHT-CUR   THRU 7190-EXIT.          
                                                                        
           EVALUATE TRUE                                                
             WHEN SEARCH-BY-CUSTOMER-NO                                 
              PERFORM 7020-FETCH-CUST-CSR      THRU 7020-EXIT           
                                                                        
             WHEN SEARCH-BY-POINT-ID                                    
              PERFORM 7060-FETCH-POINTID-CUR   THRU 7060-EXIT           
                                                                        
             WHEN SEARCH-BY-NAME                                        
              PERFORM 7090-FETCH-NAME-CUR      THRU 7090-EXIT           
                                                                        
             WHEN SEARCH-BY-BIZ-NAME                                    
              PERFORM 7840-FETCH-BIZ-NAME-CUR  THRU 7840-EXIT           
                                                                        
             WHEN SEARCH-BY-ADDRESS                                     
              PERFORM 7120-FETCH-ADDR-CUR      THRU 7120-EXIT           
                                                                        
             WHEN SEARCH-BY-SUB-DIVISION                                
              PERFORM 7150-FETCH-SUBDIV-CUR    THRU 7150-EXIT           
           END-EVALUATE.                                                
                                                                        
           IF CTR-ROWS-RS3 > WS-50                                      
              SET END-OF-50-ROWS            TO TRUE                     
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-BUILD-PREM-LIGHTS.                                          
                                                                        
           IF WS-GET-NAME-ADDR-FL = WS-YES                              
              MOVE WS-NO                    TO WS-GET-NAME-ADDR-FL      
              MOVE WS-PREMISE-NO            TO WS-CPD99-PREMISE-NO      
                                               PR-PREMISE-NO            
                                               HT-PREMISE-NO            
              PERFORM 6990-FETCH-CUR-ACCOUNT   THRU 6990-EXIT           
                                                                        
              IF SEARCH-BY-ACCOUNT-NO                                   
                 IF AT-ACCOUNT-NO NOT = WS-CPD99-ACCOUNT-NO             
                    SET NOT-A-CURRNT-ACCNT TO TRUE                      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              EVALUATE TRUE                                             
                  WHEN SEARCH-BY-NAME                                   
                  WHEN SEARCH-BY-BIZ-NAME                               
                    IF WS-CPD99-ACCOUNT-NO = HT-ACCOUNT-NO              
                       PERFORM 7300-GET-ADDRESS-ID THRU 7300-EXIT       
                       PERFORM 3000-GET-CUST-ADDRESS THRU 3000-EXIT     
                    ELSE                                                
                       SET SKIP-ACCOUNT TO TRUE                         
                       GO TO 2400-EXIT                                  
                    END-IF                                              
                                                                        
                  WHEN OTHER                                            
                    PERFORM 2800-GET-NAME-ADDRESS THRU 2800-EXIT        
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
           ADD +1                           TO CTR-ROWS-RS3.            
                                                                        
           IF CTR-ROWS-RS3 <= WS-50                                     
              PERFORM 2700-GET-POLE-DETAILS    THRU 2700-EXIT           
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 7180-FETCH-PREM-LIGHT-CUR THRU 7180-EXIT          
           ELSE                                                         
              MOVE 'N'                      TO S-IND-TYP                
              MOVE 4F-INSTALL-LOC-NO        TO PARM-IND-PREMISE         
              MOVE 4D-EQUIP-TAG-NO          TO PARM-IND-TAG-NO          
              MOVE PARM-IND-KEY             TO S-IND-KEY                
              PERFORM 8200-SEND-RESULT-2       THRU 8200-EXIT           
              SET END-OF-50-ROWS            TO TRUE                     
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-BUILD-SUBDIVSION-LIGHT.                                     
                                                                        
           MOVE WS-SUBDIVISION-ID           TO PR-SUBDIVISION-ID.       
           MOVE 0                           TO HT-ACCOUNT-NO.           
                                                                        
           MOVE SPACES                      TO DQ-FULL-NAME             
                                               WS-ADDRESS-LINE1         
                                               WS-ADDRESS-LINE2.        
                                                                        
           PERFORM 2700-GET-POLE-DETAILS       THRU 2700-EXIT.          
                                                                        
           IF CTR-ROWS-RS3 <= WS-50                                     
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 7210-FETCH-SUBDIV-LIGHT-CUR THRU 7210-EXIT        
           ELSE                                                         
              MOVE 'N'                      TO S-IND-TYP                
              MOVE WS-SUBDIVISION-ID        TO PARM-IND-PREMISE         
              MOVE 4D-EQUIP-TAG-NO          TO PARM-IND-TAG-NO          
              MOVE PARM-IND-KEY             TO S-IND-KEY                
              PERFORM 8200-SEND-RESULT-2       THRU 8200-EXIT           
              SET END-OF-50-ROWS            TO TRUE                     
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-BUILD-FIXTR-LIGHT.                                          
                                                                        
           IF SEARCH-BY-FIXTURE-ID                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                   TO WS-EQUIP-TAG-NO          
                                               WS-STOCK-CD              
                                               4D-INVENTRY-STATUS-CD    
              MOVE 4H-FXTR-EQUIP-SEQ        TO WS-EQUIP-SEQ             
              MOVE WS-FIXTURE               TO 4D-EQUIP-TYPE-CD         
              PERFORM 7700-EQUIP-INV-SEQ-DET   THRU 7700-EXIT           
              MOVE WS-EQUIP-TAG-NO          TO 4D-EQUIP-TAG-NO          
              MOVE WS-STOCK-CD              TO 4D-STOCK-CD              
              MOVE 4H-FXTR-EQUIP-SEQ        TO 4D-EQUIP-SEQ             
           END-IF.                                                      
                                                                        
           MOVE 4D-EQUIP-SEQ                TO 4F-EQUIP-SEQ             
           PERFORM 7820-GET-EQUIP-ENV-DET      THRU 7820-EXIT.          
                                                                        
           MOVE 4F-INSTALL-LOC-NO           TO WS-PREMISE-NO.           
                                                                        
           IF 4F-INSTALL-LOC-CD = 'P'                                   
              MOVE WS-PREMISE-NO            TO WS-CPD99-PREMISE-NO      
                                               PR-PREMISE-NO            
                                               HT-PREMISE-NO            
              PERFORM 6990-FETCH-CUR-ACCOUNT   THRU 6990-EXIT           
              PERFORM 2800-GET-NAME-ADDRESS    THRU 2800-EXIT           
           ELSE                                                         
              IF 4F-INSTALL-LOC-CD = 'S'                                
                 MOVE 4F-INSTALL-LOC-NO     TO PR-SUBDIVISION-ID        
              END-IF                                                    
              MOVE 0                        TO HT-ACCOUNT-NO            
              MOVE SPACES                   TO DQ-FULL-NAME             
                                               WS-ADDRESS-LINE1         
                                               WS-ADDRESS-LINE2         
           END-IF.                                                      
                                                                        
           PERFORM 2700-GET-POLE-DETAILS       THRU 2700-EXIT           
           IF SEARCH-BY-POLE-NO                                         
              MOVE WS-POLE-TAG-NO           TO WS-EQUIP-TAG-NO          
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
           EVALUATE TRUE                                                
             WHEN SEARCH-BY-POLE-NO                                     
              MOVE SPACES                   TO WS-POLE-TAG-NO           
              PERFORM 7240-FETCH-POLE-CUR      THRU 7240-EXIT           
                                                                        
             WHEN SEARCH-BY-WMS-REQ-NO                                  
              PERFORM 7280-FETCH-WMS-CUR       THRU 7280-EXIT           
                                                                        
             WHEN SEARCH-BY-CLP-NO                                      
              PERFORM 7320-FETCH-CLP-CUR       THRU 7320-EXIT           
           END-EVALUATE.                                                
                                                                        
           ADD +1                           TO CTR-ROWS-RS3.            
                                                                        
           IF CTR-ROWS-RS3 > WS-50                                      
              MOVE 'N'                      TO S-IND-TYP                
              MOVE 4F-INSTALL-LOC-NO        TO PARM-IND-PREMISE         
              MOVE 4D-EQUIP-TAG-NO          TO PARM-IND-TAG-NO          
              IF SEARCH-BY-POLE-NO                                      
                 MOVE WS-POLE-TAG-NO        TO PARM-IND-TAG-NO          
              END-IF                                                    
              MOVE PARM-IND-KEY             TO S-IND-KEY                
              PERFORM 8200-SEND-RESULT-2       THRU 8200-EXIT           
              SET END-OF-50-ROWS            TO TRUE                     
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2700-GET-POLE-DETAILS.                                           
                                                                        
           MOVE ZERO                        TO WS-POLE-COUNT            
                                               WS-EQUIP-SEQ.            
                                                                        
           MOVE SPACES                      TO WS-EQUIP-TAG-NO          
                                               WS-STOCK-CD.             
                                                                        
           MOVE 4D-EQUIP-SEQ                TO 4H-FXTR-EQUIP-SEQ.       
           PERFORM 7800-GET-POLE-COUNT         THRU 7800-EXIT.          
                                                                        
           IF 4H-ATTACH-EQUIP-SEQ > 0                                   
              MOVE 4H-ATTACH-EQUIP-SEQ      TO WS-EQUIP-SEQ             
              MOVE WS-POLE                  TO 4D-EQUIP-TYPE-CD         
              PERFORM 7700-EQUIP-INV-SEQ-DET   THRU 7700-EXIT           
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2800-GET-NAME-ADDRESS.                                           
                                                                        
           MOVE WS-CPD99-ACCOUNT-NO         TO HT-ACCOUNT-NO.           
           PERFORM 7400-GET-CUSTOMER-NAME      THRU 7400-EXIT.          
                                                                        
           PERFORM 7300-GET-ADDRESS-ID         THRU 7300-EXIT.          
                                                                        
           PERFORM 3000-GET-CUST-ADDRESS       THRU 3000-EXIT.          
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-GET-CUST-ADDRESS.                                           
                                                                        
           INITIALIZE DCLCSS-ADDR-FORMATTED                             
                      A4-ZIP-CODE                                       
                      A4-ZIP-CODE-TOKEN                                 
                      A4-TOWN                                           
                      A4-STATE                                          
                      WS-ADDRESS.                                       
                                                                        
           MOVE PR-ADDRESS-ID               TO DY-ADDRESS-ID.           
           PERFORM 7500-GET-FORMATTED-ADDR     THRU 7500-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 3100-FORMAT-ADDRESS      THRU 3100-EXIT           
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-FORMAT-ADDRESS.                                             
                                                                        
           MOVE SPACES                    TO WS-IN-STRING               
                                             WS-OUT-STRING.             
           MOVE DY-HOUSE-NO               TO WS-HOUSE-NO.               
           MOVE DY-ADDR-PREFIX-1          TO WS-ADDR-PREFIX-1.          
           MOVE DY-ADDR-PREFIX-2          TO WS-ADDR-PREFIX-2.          
           MOVE DY-STREET-NAME            TO WS-NAME-STREET.            
           MOVE DY-STREET-SUFFIX          TO WS-STREET-SUFFIX.          
           MOVE DY-STREET-LOCATION-1      TO WS-STREET-LOCATION-1.      
           MOVE DY-STREET-LOCATION-2      TO WS-STREET-LOCATION-2.      
           MOVE DY-ADDR-SUFFIX            TO WS-ADDRESS-SUFFIX.         
           MOVE WS-STREET-ADDRESS         TO WS-IN-STRING.              
           MOVE 82                        TO WS-CHAR-LENGTH.            
                                                                        
           PERFORM 3200-REDUCE-EMBED-SPACES  THRU 3200-EXIT.            
                                                                        
           MOVE WS-OUT-STRING             TO WS-ADDRESS-LINE1.          
                                                                        
           MOVE SPACES                    TO WS-IN-STRING               
                                             WS-OUT-STRING.             
           MOVE DY-ZIP-CODE               TO A4-ZIP-CODE                
                                             WS-ZIP-CODE.               
           MOVE DY-ZIP-CODE-TOKEN         TO A4-ZIP-CODE-TOKEN.         
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
              MOVE '-'                    TO WS-ZIP-DASH                
              MOVE DY-ZIP-CODE-PLUS-FOUR  TO WS-ZIP-PLUS-4              
           END-IF.                                                      
           MOVE ' *'                      TO WS-ZIP-FILLER.             
                                                                        
           PERFORM 7600-GET-ZIP-CODE-DET  THRU  7600-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                TO WS-STATE                    
              MOVE 'UNKNOWN *'           TO WS-CITY                     
           ELSE                                                         
              MOVE A4-STATE              TO WS-STATE                    
              MOVE A4-TOWN               TO WS-CITY                     
           END-IF.                                                      
                                                                        
           MOVE WS-CITY-STATE            TO WS-IN-STRING.               
           MOVE 41                       TO WS-CHAR-LENGTH.             
           PERFORM 3200-REDUCE-EMBED-SPACES THRU 3200-EXIT.             
           MOVE WS-OUT-STRING            TO WS-ADDRESS-LINE2.           
                                                                        
           INSPECT WS-ADDRESS-LINE2 REPLACING ALL '*' BY SPACES.        
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-REDUCE-EMBED-SPACES.                                        
                                                                        
           SET WS-OUT-INDX TO 1.                                        
           MOVE SPACES                   TO WS-LAST-CHAR.               
                                                                        
           PERFORM VARYING WS-IN-INDX FROM 1 BY 1                       
             UNTIL WS-IN-INDX > WS-CHAR-LENGTH                          
             EVALUATE TRUE                                              
                WHEN WS-IN-CHAR (WS-IN-INDX) = LOW-VALUES               
                     CONTINUE                                           
                WHEN WS-IN-CHAR (WS-IN-INDX) = SPACES                   
                     AND WS-LAST-CHAR = SPACES                          
                     CONTINUE                                           
                WHEN OTHER                                              
                     MOVE WS-IN-CHAR (WS-IN-INDX) TO WS-LAST-CHAR       
                          WS-OUT-CHAR (WS-OUT-INDX)                     
                     SET WS-OUT-INDX UP BY 1                            
             END-EVALUATE                                               
           END-PERFORM.                                                 
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * COPYBOOK TO GET THE MOST CURRENT ACCOUNT AT A PREMISE         *         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
                                                                        
      * ERROR ROUTINE TO HANDLE ERRORS FROM CPD00099                  *         
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT.          
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-GET-ACCT-PREMISE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT AT.PREMISE_NO                                      
                INTO :WS-PREMISE-NO                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                 AND AT.PREMISE_NO >= :WS-IND-PREMISE-NO                
               ORDER BY AT.PREMISE_NO                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.PREMISE_NO                                              
MFA-TR*         INTO :WS-PREMISE-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                            
MFA-TR*          AND AT.PREMISE_NO >= :WS-IND-PREMISE-NO                        
MFA-TR*        ORDER BY AT.PREMISE_NO                                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-CUST-CSR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN CUSTNO_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-FETCH-CUST-CSR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH CUSTNO_CUR                                         
                INTO :WS-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-CUST-CSR.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE CUSTNO_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-GET-METER-PREMISE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT EQ.CRNT_LOC_NO                                     
                INTO :WS-PREMISE-NO                                     
                FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
               WHERE EQ.DEVICE_NO      = :EQ-DEVICE-NO                  
                 AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE             
                 AND EQ.COMPANY_NO     = '01'                           
                 AND EQ.CRNT_LOC_NO   >= :WS-IND-PREMISE-NO             
                 ORDER BY EQ.CRNT_LOC_NO                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQ.CRNT_LOC_NO                                             
MFA-TR*         INTO :WS-PREMISE-NO                                             
MFA-TR*         FROM CSS_EQUIPMENT EQ                                           
MFA-TR*        WHERE EQ.DEVICE_NO      = :EQ-DEVICE-NO                          
MFA-TR*          AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQ.COMPANY_NO     = '01'                                   
MFA-TR*          AND EQ.CRNT_LOC_NO   >= :WS-IND-PREMISE-NO                     
MFA-TR*          ORDER BY EQ.CRNT_LOC_NO                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7040                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'METER_NO'               TO TABLE-ELEMENT-1          
              MOVE EQ-DEVICE-NO             TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-OPEN-POINTID-CUR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN POINTID_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'POINT_ID'               TO TABLE-ELEMENT-1          
              MOVE MN-POINT-ID              TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-FETCH-POINTID-CUR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH POINTID_CUR                                        
                INTO :WS-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'POINT_ID'               TO TABLE-ELEMENT-1          
              MOVE MN-POINT-ID              TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-CLOSE-POINTID-CUR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE POINTID_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                  
              MOVE 'POINT_ID'               TO TABLE-ELEMENT-1          
              MOVE MN-POINT-ID              TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-OPEN-NAME-CUR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN NAME_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7080'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'LAST_NAME'              TO TABLE-ELEMENT-1          
              MOVE NAM-LAST-NAME            TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-FETCH-NAME-CUR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH NAME_CUR                                           
                INTO :WS-PREMISE-NO                                     
                    ,:HT-ACCOUNT-NO                                     
                    ,:DQ-FULL-NAME                                      
                    ,:HT-CODE-ACCT-STAT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7090'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'LAST_NAME'              TO TABLE-ELEMENT-1          
              MOVE NAM-LAST-NAME            TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CLOSE-NAME-CUR.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE NAME_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'LAST_NAME'              TO TABLE-ELEMENT-1          
              MOVE NAM-LAST-NAME            TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-OPEN-ADDR-CUR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN ADDR_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ADDR_FORMATTED'     TO TABLE-1                  
              MOVE 'STREET_NAME'            TO TABLE-ELEMENT-1          
              MOVE ADD-STREET-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-FETCH-ADDR-CUR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH ADDR_CUR                                           
                INTO :WS-PREMISE-NO                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH ADDR_CUR                                                   
MFA-TR*         INTO :WS-PREMISE-NO                                             
MFA-TR*             ,:WS-ADDRESS-LINE1                                          
MFA-TR*             ,:WS-ADDRESS-LINE2                                          
MFA-TR*             ,:HT-CODE-ACCT-STAT                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ADDR_FORMATTED'     TO TABLE-1                  
              MOVE 'STREET_NAME'            TO TABLE-ELEMENT-1          
              MOVE ADD-STREET-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-CLOSE-ADDR-CUR.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE ADDR_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7130'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ADDR_FORMATTED'     TO TABLE-1                  
              MOVE 'STREET_NAME'            TO TABLE-ELEMENT-1          
              MOVE ADD-STREET-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-IND-PREMISE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-OPEN-SUBDIV-CUR.                                            
                                                                        
           EXEC SQL                                                     
                OPEN SUBDIV_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7140'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'SUBDIVISION_ID'         TO TABLE-ELEMENT-1          
              MOVE WS-SUBDIVISION-ID        TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-FETCH-SUBDIV-CUR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH SUBDIV_CUR                                         
                INTO :WS-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'SUBDIVISION_ID'         TO TABLE-ELEMENT-1          
              MOVE WS-SUBDIVISION-ID        TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7160-CLOSE-SUBDIV-CUR.                                           
                                                                        
           EXEC SQL                                                     
                CLOSE SUBDIV_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7160'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'SUBDIVISION_ID'         TO TABLE-ELEMENT-1          
              MOVE WS-SUBDIVISION-ID        TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-OPEN-PREM-LIGHT-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN PREM_LIGHT_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7170'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7180-FETCH-PREM-LIGHT-CUR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH PREM_LIGHT_CUR                                     
                INTO :4D-EQUIP-SEQ                                      
                    ,:4D-EQUIP-TAG-NO                                   
                    ,:4D-STOCK-CD                                       
                    ,:4D-INVENTRY-STATUS-CD                             
                    ,:4F-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7180'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7190-CLOSE-PREM-LIGHT-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE PREM_LIGHT_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7190'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-1          
              MOVE 4F-INSTALL-LOC-NO        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-SUBDIV-LIGHT-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN SUBDIV_LIGHT_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE 'LMS_EQUIP_ENVRNMT'    TO TABLE-1                    
              MOVE 'INSTALL_LOC_NO'       TO TABLE-ELEMENT-1            
              MOVE WS-SUBDIVISION-ID      TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-FETCH-SUBDIV-LIGHT-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH SUBDIV_LIGHT_CUR                                   
                INTO :4D-EQUIP-SEQ                                      
                    ,:4D-EQUIP-TAG-NO                                   
                    ,:4D-STOCK-CD                                       
                    ,:4F-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD +1                     TO CTR-ROWS-RS3             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE '7210'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE 'LMS_EQUIP_ENVRNMT' TO TABLE-1                       
              MOVE 'INSTALL_LOC_NO'    TO TABLE-ELEMENT-1               
              MOVE WS-SUBDIVISION-ID   TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-SUBDIV-LIGHT-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE SUBDIV_LIGHT_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE '7220'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'LMS_EQUIP_ENVRNMT'    TO TABLE-1                    
              MOVE 'INSTALL_LOC_NO'       TO TABLE-ELEMENT-1            
              MOVE WS-SUBDIVISION-ID      TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-OPEN-POLE-CUR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN POLE_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7230'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-TAG-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-FETCH-POLE-CUR.                                             
                                                                        
           EXEC SQL                                                     
               FETCH POLE_CUR                                           
                INTO :4H-FXTR-EQUIP-SEQ                                 
                    ,:WS-POLE-TAG-NO                                    
                    ,:4D-INVENTRY-STATUS-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7240'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-TAG-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-CLOSE-POLE-CUR.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE POLE_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-TAG-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-GET-NODE-FIXTR-SEQ.                                         
                                                                        
           EXEC SQL                                                     
                SELECT [4H].FXTR_EQUIP_SEQ                                
                      ,[4D].INVENTRY_STATUS_CD                            
                  INTO :4H-FXTR-EQUIP-SEQ                               
                      ,:4D-INVENTRY-STATUS-CD                           
                  FROM LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)            
                      ,LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)            
                 WHERE [4D].EQUIP_TAG_NO = :WS-NODE-TAG-NO                
                   AND [4D].EQUIP_TYPE_CD = 'N'                           
                   AND [4H].ATTACH_EQUIP_SEQ = [4D].EQUIP_SEQ               
                   AND [4H].EQUIP_TYPE_CD = [4D].EQUIP_TYPE_CD              
                   AND [4D].EQUIP_TAG_NO >= :PARM-IND-TAG-NO              
                 ORDER BY [4H].FXTR_EQUIP_SEQ                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 4H.FXTR_EQUIP_SEQ                                        
MFA-TR*               ,4D.INVENTRY_STATUS_CD                                    
MFA-TR*           INTO :4H-FXTR-EQUIP-SEQ                                       
MFA-TR*               ,:4D-INVENTRY-STATUS-CD                                   
MFA-TR*           FROM LMS_EQUIP_INVENTRY 4D                                    
MFA-TR*               ,LMS_FXTR_ATTACHMTS 4H                                    
MFA-TR*          WHERE 4D.EQUIP_TAG_NO = :WS-NODE-TAG-NO                        
MFA-TR*            AND 4D.EQUIP_TYPE_CD = 'N'                                   
MFA-TR*            AND 4H.ATTACH_EQUIP_SEQ = 4D.EQUIP_SEQ                       
MFA-TR*            AND 4H.EQUIP_TYPE_CD = 4D.EQUIP_TYPE_CD                      
MFA-TR*            AND 4D.EQUIP_TAG_NO >= :PARM-IND-TAG-NO                      
MFA-TR*          ORDER BY 4H.FXTR_EQUIP_SEQ                                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7260'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-TAG-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7270-OPEN-WMS-CUR.                                               
                                                                        
           EXEC SQL                                                     
                OPEN WMS_CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7270'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'SOURCE_APPL_REQ_NO'     TO TABLE-ELEMENT-1          
              MOVE WS-WMS-REQ-NO-STR        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-2          
              MOVE PARM-IND-PREMISE         TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-FETCH-WMS-CUR.                                              
                                                                        
           EXEC SQL                                                     
               FETCH WMS_CUR                                            
                INTO :4H-FXTR-EQUIP-SEQ                                 
                    ,:4D-INVENTRY-STATUS-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7280'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'SOURCE_APPL_REQ_NO'     TO TABLE-ELEMENT-1          
              MOVE WS-WMS-REQ-NO-STR        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-2          
              MOVE PARM-IND-PREMISE         TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7290-CLOSE-WMS-CUR.                                              
                                                                        
           EXEC SQL                                                     
                CLOSE WMS_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7290'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'SOURCE_APPL_REQ_NO'     TO TABLE-ELEMENT-1          
              MOVE WS-WMS-REQ-NO-STR        TO HOSTVAR-ELEMENT-1        
              MOVE 'INSTALL_LOC_NO'         TO TABLE-ELEMENT-2          
              MOVE PARM-IND-PREMISE         TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-ADDRESS-ID.                                             
                                                                        
           EXEC SQL                                                     
             SELECT PR.ADDRESS_ID                                       
                   ,SUBDIVISION_ID                                      
               INTO :PR-ADDRESS-ID                                      
                   ,:PR-SUBDIVISION-ID                                  
               FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                        
              WHERE PR.PREMISE_NO = :PR-PREMISE-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PR.ADDRESS_ID                                               
MFA-TR*            ,SUBDIVISION_ID                                              
MFA-TR*        INTO :PR-ADDRESS-ID                                              
MFA-TR*            ,:PR-SUBDIVISION-ID                                          
MFA-TR*        FROM CSS_PREMISE PR                                              
MFA-TR*       WHERE PR.PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PREMISE'            TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE PR-PREMISE-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-OPEN-CLP-CUR.                                               
                                                                        
           EXEC SQL                                                     
                OPEN CLP_CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7310'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'CNTRCT_CLP_NO'          TO TABLE-ELEMENT-1          
              MOVE 4L-CNTRCT-CLP-NO         TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-FETCH-CLP-CUR.                                              
                                                                        
           EXEC SQL                                                     
               FETCH CLP_CUR                                            
                INTO :4H-FXTR-EQUIP-SEQ                                 
                    ,:4D-INVENTRY-STATUS-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7320'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'CNTRCT_CLP_NO'          TO TABLE-ELEMENT-1          
              MOVE 4L-CNTRCT-CLP-NO         TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7330-CLOSE-CLP-CUR.                                              
                                                                        
           EXEC SQL                                                     
                CLOSE CLP_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7330'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'LMS_EQUIP_CONTRACT'     TO TABLE-1                  
              MOVE 'CNTRCT_CLP_NO'          TO TABLE-ELEMENT-1          
              MOVE 4L-CNTRCT-CLP-NO         TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-CUSTOMER-NAME.                                          
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME        
                ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '         
                     THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '         
                          THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                 
               ,HT.CODE_ACCT_STAT                                       
                INTO  :DQ-FULL-NAME                                     
                     ,:HT-CODE-ACCT-STAT                                
                FROM  CSS_NAME            DQ WITH(READUNCOMMITTED)              
                     ,CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
               WHERE  HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                 AND  HT.PREMISE_NO = :HT-PREMISE-NO                    
                 AND  HT.NAME_ID = DQ.NAME_ID                           
                 AND  DQ.NAME_TYPE = 'CN'                               
                 AND  HT.CUSTOMER_ROLE_CD = ' '                         
                 AND HT.COMPANY_NO = '01'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME                
MFA-TR*         ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                          
MFA-TR*              CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '                 
MFA-TR*              THEN '' ELSE ', '    END  ||                               
MFA-TR*                   STRIP(DQ.FIRST_NAME)           ||                     
MFA-TR*              CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '                 
MFA-TR*                   THEN '' ELSE ' '     END  ||                          
MFA-TR*                   STRIP(DQ.MIDDLE_NAME),70) END                         
MFA-TR*        ,HT.CODE_ACCT_STAT                                               
MFA-TR*         INTO  :DQ-FULL-NAME                                             
MFA-TR*              ,:HT-CODE-ACCT-STAT                                        
MFA-TR*         FROM  CSS_NAME            DQ                                    
MFA-TR*              ,CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*        WHERE  HT.ACCOUNT_NO = :HT-ACCOUNT-NO                            
MFA-TR*          AND  HT.PREMISE_NO = :HT-PREMISE-NO                            
MFA-TR*          AND  HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*          AND  DQ.NAME_TYPE = 'CN'                                       
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*          AND HT.COMPANY_NO = '01'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_NAME_ACCT_XREF'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE HT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-GET-FORMATTED-ADDR.                                         
                                                                        
           EXEC SQL                                                     
             SELECT  DY.HOUSE_NO                                        
                    ,DY.ADDR_PREFIX_1                                   
                    ,DY.ADDR_PREFIX_2                                   
                    ,DY.STREET_NAME                                     
                    ,DY.STREET_LOCATION_1                               
                    ,DY.STREET_LOCATION_2                               
                    ,DY.STREET_SUFFIX                                   
                    ,DY.ADDRESS_OVERFLOW                                
                    ,DY.CARRIER_ROUTE                                   
                    ,DY.ZIP_CODE                                        
                    ,DY.ZIP_CODE_PLUS_FOUR                              
                    ,DY.ZIP_CODE_TOKEN                                  
                    ,DY.ADDR_SUFFIX                                     
               INTO :DY-HOUSE-NO                                        
                   ,:DY-ADDR-PREFIX-1                                   
                   ,:DY-ADDR-PREFIX-2                                   
                   ,:DY-STREET-NAME                                     
                   ,:DY-STREET-LOCATION-1                               
                   ,:DY-STREET-LOCATION-2                               
                   ,:DY-STREET-SUFFIX                                   
                   ,:DY-ADDRESS-OVERFLOW                                
                   ,:DY-CARRIER-ROUTE                                   
                   ,:DY-ZIP-CODE                                        
                   ,:DY-ZIP-CODE-PLUS-FOUR                              
                   ,:DY-ZIP-CODE-TOKEN                                  
                   ,:DY-ADDR-SUFFIX                                     
               FROM  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
              WHERE  DY.ADDRESS_ID = :DY-ADDRESS-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DY.HOUSE_NO                                                
MFA-TR*             ,DY.ADDR_PREFIX_1                                           
MFA-TR*             ,DY.ADDR_PREFIX_2                                           
MFA-TR*             ,DY.STREET_NAME                                             
MFA-TR*             ,DY.STREET_LOCATION_1                                       
MFA-TR*             ,DY.STREET_LOCATION_2                                       
MFA-TR*             ,DY.STREET_SUFFIX                                           
MFA-TR*             ,DY.ADDRESS_OVERFLOW                                        
MFA-TR*             ,DY.CARRIER_ROUTE                                           
MFA-TR*             ,DY.ZIP_CODE                                                
MFA-TR*             ,DY.ZIP_CODE_PLUS_FOUR                                      
MFA-TR*             ,DY.ZIP_CODE_TOKEN                                          
MFA-TR*             ,DY.ADDR_SUFFIX                                             
MFA-TR*        INTO :DY-HOUSE-NO                                                
MFA-TR*            ,:DY-ADDR-PREFIX-1                                           
MFA-TR*            ,:DY-ADDR-PREFIX-2                                           
MFA-TR*            ,:DY-STREET-NAME                                             
MFA-TR*            ,:DY-STREET-LOCATION-1                                       
MFA-TR*            ,:DY-STREET-LOCATION-2                                       
MFA-TR*            ,:DY-STREET-SUFFIX                                           
MFA-TR*            ,:DY-ADDRESS-OVERFLOW                                        
MFA-TR*            ,:DY-CARRIER-ROUTE                                           
MFA-TR*            ,:DY-ZIP-CODE                                                
MFA-TR*            ,:DY-ZIP-CODE-PLUS-FOUR                                      
MFA-TR*            ,:DY-ZIP-CODE-TOKEN                                          
MFA-TR*            ,:DY-ADDR-SUFFIX                                             
MFA-TR*        FROM  CSS_ADDR_FORMATTED DY                                      
MFA-TR*       WHERE  DY.ADDRESS_ID = :DY-ADDRESS-ID                             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ADDR_FORMATTED'     TO TABLE-1                  
              MOVE 'ADDRESS_ID'             TO TABLE-ELEMENT-1          
              MOVE DY-ADDRESS-ID            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-GET-ZIP-CODE-DET.                                           
                                                                        
           EXEC SQL                                                     
             SELECT A4.TOWN                                             
                   ,A4.STATE                                            
               INTO :A4-TOWN                                            
                   ,:A4-STATE                                           
               FROM  CSS_ZIP_CODE  A4 WITH(READUNCOMMITTED)                     
              WHERE  A4.ZIP_CODE       =  :A4-ZIP-CODE                  
                AND A4.ZIP_CODE_TOKEN  =  :A4-ZIP-CODE-TOKEN            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT A4.TOWN                                                     
MFA-TR*            ,A4.STATE                                                    
MFA-TR*        INTO :A4-TOWN                                                    
MFA-TR*            ,:A4-STATE                                                   
MFA-TR*        FROM  CSS_ZIP_CODE  A4                                           
MFA-TR*       WHERE  A4.ZIP_CODE       =  :A4-ZIP-CODE                          
MFA-TR*         AND A4.ZIP_CODE_TOKEN  =  :A4-ZIP-CODE-TOKEN                    
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ZIP_CODE'           TO TABLE-1                  
              MOVE 'ZIP_CODE'               TO TABLE-ELEMENT-1          
              MOVE 'ZIP_CODE_TOKEN'         TO TABLE-ELEMENT-2          
              MOVE A4-ZIP-CODE              TO HOSTVAR-ELEMENT-1        
              MOVE A4-ZIP-CODE-TOKEN        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-EQUIP-INV-SEQ-DET.                                          
                                                                        
           EXEC SQL                                                     
              SELECT [4D].EQUIP_TAG_NO                                    
                    ,[4D].STOCK_CD                                        
                    ,[4D].INVENTRY_STATUS_CD                              
                INTO :WS-EQUIP-TAG-NO                                   
                    ,:WS-STOCK-CD                                       
                    ,:4D-INVENTRY-STATUS-CD                             
               FROM  LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
              WHERE  [4D].EQUIP_SEQ      =  :WS-EQUIP-SEQ                 
                AND  [4D].EQUIP_TYPE_CD  =  :4D-EQUIP-TYPE-CD             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 4D.EQUIP_TAG_NO                                            
MFA-TR*             ,4D.STOCK_CD                                                
MFA-TR*             ,4D.INVENTRY_STATUS_CD                                      
MFA-TR*         INTO :WS-EQUIP-TAG-NO                                           
MFA-TR*             ,:WS-STOCK-CD                                               
MFA-TR*             ,:4D-INVENTRY-STATUS-CD                                     
MFA-TR*        FROM  LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*       WHERE  4D.EQUIP_SEQ      =  :WS-EQUIP-SEQ                         
MFA-TR*         AND  4D.EQUIP_TYPE_CD  =  :4D-EQUIP-TYPE-CD                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-GET-POLE-COUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(MIN([4H].ATTACH_EQUIP_SEQ),0)                 
                    ,COUNT(*)                                           
                INTO :4H-ATTACH-EQUIP-SEQ                               
                    ,:WS-POLE-COUNT                                     
               FROM  LMS_FXTR_ATTACHMTS [4H] WITH(READUNCOMMITTED)              
              WHERE  [4H].FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ             
                AND  [4H].EQUIP_TYPE_CD  = 'P'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MIN(4H.ATTACH_EQUIP_SEQ),0)                         
MFA-TR*             ,COUNT(*)                                                   
MFA-TR*         INTO :4H-ATTACH-EQUIP-SEQ                                       
MFA-TR*             ,:WS-POLE-COUNT                                             
MFA-TR*        FROM  LMS_FXTR_ATTACHMTS 4H                                      
MFA-TR*       WHERE  4H.FXTR_EQUIP_SEQ = :4H-FXTR-EQUIP-SEQ                     
MFA-TR*         AND  4H.EQUIP_TYPE_CD  = 'P'                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7800'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_FXTR_ATTACHMTS'     TO TABLE-1                  
              MOVE 'FXTR_EQUIP_SEQ'         TO TABLE-ELEMENT-1          
              MOVE 4H-FXTR-EQUIP-SEQ        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7810-EQUIP-INV-TAG-DET.                                          
                                                                        
           EXEC SQL                                                     
              SELECT [4D].EQUIP_SEQ                                       
                    ,[4D].STOCK_CD                                        
                    ,[4D].INVENTRY_STATUS_CD                              
                INTO :4D-EQUIP-SEQ                                      
                    ,:4D-STOCK-CD                                       
                    ,:4D-INVENTRY-STATUS-CD                             
              FROM   LMS_EQUIP_INVENTRY [4D] WITH(READUNCOMMITTED)              
              WHERE  [4D].EQUIP_TAG_NO  = :4D-EQUIP-TAG-NO                
                AND  [4D].EQUIP_TYPE_CD = :4D-EQUIP-TYPE-CD               
                AND  [4D].EQUIP_TAG_NO >= :PARM-IND-TAG-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 4D.EQUIP_SEQ                                               
MFA-TR*             ,4D.STOCK_CD                                                
MFA-TR*             ,4D.INVENTRY_STATUS_CD                                      
MFA-TR*         INTO :4D-EQUIP-SEQ                                              
MFA-TR*             ,:4D-STOCK-CD                                               
MFA-TR*             ,:4D-INVENTRY-STATUS-CD                                     
MFA-TR*       FROM   LMS_EQUIP_INVENTRY 4D                                      
MFA-TR*       WHERE  4D.EQUIP_TAG_NO  = :4D-EQUIP-TAG-NO                        
MFA-TR*         AND  4D.EQUIP_TYPE_CD = :4D-EQUIP-TYPE-CD                       
MFA-TR*         AND  4D.EQUIP_TAG_NO >= :PARM-IND-TAG-NO                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7810                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7810'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_INVENTRY'     TO TABLE-1                  
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-1          
              MOVE 4D-EQUIP-TAG-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'EQUIP_TYPE_CD'          TO TABLE-ELEMENT-2          
              MOVE 4D-EQUIP-TYPE-CD         TO HOSTVAR-ELEMENT-2        
              MOVE 'EQUIP_TAG_NO'           TO TABLE-ELEMENT-3          
              MOVE PARM-IND-TAG-NO          TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7820-GET-EQUIP-ENV-DET.                                          
                                                                        
           EXEC SQL                                                     
              SELECT [4F].INSTALL_LOC_NO                                  
                    ,[4F].INSTALL_LOC_CD                                  
                    ,[4F].RATE_PLAN_NO                                    
                INTO :4F-INSTALL-LOC-NO                                 
                    ,:4F-INSTALL-LOC-CD                                 
                    ,:4F-RATE-PLAN-NO                                   
              FROM   LMS_EQUIP_ENVRNMT  [4F] WITH(READUNCOMMITTED)              
              WHERE  [4F].EQUIP_SEQ = :4F-EQUIP-SEQ                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 4F.INSTALL_LOC_NO                                          
MFA-TR*             ,4F.INSTALL_LOC_CD                                          
MFA-TR*             ,4F.RATE_PLAN_NO                                            
MFA-TR*         INTO :4F-INSTALL-LOC-NO                                         
MFA-TR*             ,:4F-INSTALL-LOC-CD                                         
MFA-TR*             ,:4F-RATE-PLAN-NO                                           
MFA-TR*       FROM   LMS_EQUIP_ENVRNMT  4F                                      
MFA-TR*       WHERE  4F.EQUIP_SEQ = :4F-EQUIP-SEQ                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7820                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7820'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'LMS_EQUIP_ENVRNMT'      TO TABLE-1                  
              MOVE 'EQUIP_SEQ'              TO TABLE-ELEMENT-1          
              MOVE 4F-EQUIP-SEQ             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7830-OPEN-BIZ-NAME-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN BIZ_NAME_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7830'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'FULL_NAME'              TO TABLE-ELEMENT-1          
              MOVE BIZ-NAME                 TO HOSTVAR-ELEMENT-1        
              MOVE 'STREET_NAME'            TO TABLE-ELEMENT-2          
              MOVE BIZ-STREET-NAME          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7840-FETCH-BIZ-NAME-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH BIZ_NAME_CUR                                       
                INTO :WS-PREMISE-NO                                     
                    ,:HT-ACCOUNT-NO                                     
                    ,:DQ-FULL-NAME                                      
                    ,:HT-CODE-ACCT-STAT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7840'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'FULL_NAME'              TO TABLE-ELEMENT-1          
              MOVE BIZ-NAME                 TO HOSTVAR-ELEMENT-1        
              MOVE 'STREET_NAME'            TO TABLE-ELEMENT-2          
              MOVE BIZ-STREET-NAME          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7840-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7850-CLOSE-BIZ-NAME-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE BIZ_NAME_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7850'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_NAME'               TO TABLE-1                  
              MOVE 'FULL_NAME'              TO TABLE-ELEMENT-1          
              MOVE BIZ-NAME                 TO HOSTVAR-ELEMENT-1        
              MOVE 'STREET_NAME'            TO TABLE-ELEMENT-2          
              MOVE BIZ-STREET-NAME          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04761_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04761_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000A'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE GTT-NAME-1               TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04761_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04761_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000B'                  TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE GTT-NAME-2               TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04761_R1                           
                   (RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,FIX_EQUIP_SEQ                                       
                   ,FIX_TAG                                             
                   ,LIGHT_STATUS                                        
                   ,FIX_STOCK_CD                                        
                   ,FIX_RATE                                            
                   ,POLE_TAG                                            
                   ,POLE_STOCK_CD                                       
                   ,ACCOUNT_NO                                          
                   ,ACCT_STATUS                                         
                   ,SUBDIVISION_ID                                      
                   ,CUSTOMER_NAME                                       
                   ,ADDRESS_LINE1                                       
                   ,ADDRESS_LINE2                                       
                   ,POLE_COUNT)                                         
              VALUES                                                    
                   (:S-RETURN-CODE-1                                    
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-FIX-EQUIP-SEQ                                    
                   ,:S-FIX-TAG                                          
                   ,:S-LIGHT-STATUS                                     
                   ,:S-FIX-STOCK-CD                                     
                   ,:S-FIX-RATE                                         
                   ,:S-POLE-TAG                                         
                   ,:S-POLE-STOCK-CD                                    
                   ,:S-ACCOUNT-NO                                       
                   ,:S-ACCT-STATUS                                      
                   ,:S-SUBDIVISION-ID                                   
                   ,:S-CUSTOMER-NAME                                    
                   ,:S-ADDRESS-LINE1                                    
                   ,:S-ADDRESS-LINE2                                    
                   ,:S-POLE-COUNT)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04761_R1                                   
MFA-TR*            (RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,FIX_EQUIP_SEQ                                               
MFA-TR*            ,FIX_TAG                                                     
MFA-TR*            ,LIGHT_STATUS                                                
MFA-TR*            ,FIX_STOCK_CD                                                
MFA-TR*            ,FIX_RATE                                                    
MFA-TR*            ,POLE_TAG                                                    
MFA-TR*            ,POLE_STOCK_CD                                               
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,ACCT_STATUS                                                 
MFA-TR*            ,SUBDIVISION_ID                                              
MFA-TR*            ,CUSTOMER_NAME                                               
MFA-TR*            ,ADDRESS_LINE1                                               
MFA-TR*            ,ADDRESS_LINE2                                               
MFA-TR*            ,POLE_COUNT)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:S-RETURN-CODE-1                                            
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-FIX-EQUIP-SEQ                                            
MFA-TR*            ,:S-FIX-TAG                                                  
MFA-TR*            ,:S-LIGHT-STATUS                                             
MFA-TR*            ,:S-FIX-STOCK-CD                                             
MFA-TR*            ,:S-FIX-RATE                                                 
MFA-TR*            ,:S-POLE-TAG                                                 
MFA-TR*            ,:S-POLE-STOCK-CD                                            
MFA-TR*            ,:S-ACCOUNT-NO                                               
MFA-TR*            ,:S-ACCT-STATUS                                              
MFA-TR*            ,:S-SUBDIVISION-ID                                           
MFA-TR*            ,:S-CUSTOMER-NAME                                            
MFA-TR*            ,:S-ADDRESS-LINE1                                            
MFA-TR*            ,:S-ADDRESS-LINE2                                            
MFA-TR*            ,:S-POLE-COUNT)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE GTT-NAME-1               TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
                                               HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04761_R2                           
                   (RETURN_CODE                                         
                   ,IND_TYP                                             
                   ,IND_KEY)                                            
              VALUES                                                    
                   (:S-RETURN-CODE-2                                    
                   ,:S-IND-TYP                                          
                   ,:S-IND-KEY)                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04761_R2                                   
MFA-TR*            (RETURN_CODE                                                 
MFA-TR*            ,IND_TYP                                                     
MFA-TR*            ,IND_KEY)                                                    
MFA-TR*       VALUES                                                            
MFA-TR*            (:S-RETURN-CODE-2                                            
MFA-TR*            ,:S-IND-TYP                                                  
MFA-TR*            ,:S-IND-KEY)                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE GTT-NAME-2               TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
                                               HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
              PERFORM 8100-SEND-RESULT-1       THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE +0                       TO S-RETURN-CODE-2          
              PERFORM 8200-SEND-RESULT-2       THRU 8200-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
              EXEC SQL                                                  
                   OPEN C1                                              
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
              EXEC SQL                                                  
                   OPEN C2                                              
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                 
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
      *    INITIALIZE GTT-RETURN-FIELDS.                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1          
                                               ABEND-SQLCODE.           
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
           PERFORM 8100-SEND-RESULT-1          THRU 8100-EXIT.          
           PERFORM 0100B-DECLARE-GTT           THRU 0100B-EXIT.         
           PERFORM 8200-SEND-RESULT-2          THRU 8200-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================*         
       9999-END-PROGRAM.                                                
      *===============================================================*         
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                       END OF PROGRAM                           *        
      ******************************************************************        
