       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04760.                                          
       AUTHOR.       SIVARAJAN.                                         
COB303 DATE-WRITTEN. NOV 24,2014.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04760              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04760 :                                                --         
      *--                                                            --         
      *--  #  INSERT RECORDS INTO LMS_REQUEST_DETAIL TABLE           --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            I_SOURCE_APPL_CD         CHAR(3)                --         
      *--            I_SOURCE_APPL_REQ_NO     DECIMAL(13, 0)         --         
      *--            I_WMS_POINT_NO           DECIMAL(5, 2)          --         
      *--            I_ORDER_TYPE_CD          CHAR(5)                --         
      *--            I_WORK_TYPE_CD           CHAR(3)                --         
      *--            I_RECORD_TYPE_CD         CHAR(1)                --         
      *--            I_STOCK_CD               CHAR(15)               --         
      *--            I_RATE_PLAN_NO           CHAR(3)                --         
      *--            I_RATE_ITEM_CODE         SMALLINT               --         
      *--            I_POLE_TAG_NO            CHAR(12)               --         
      *--            I_REQUEST_ACTION_TS      CHAR(26)               --         
      *--            I_REQUEST_ACTION_CD      CHAR(1)                --         
      *--            I_EQUIP_QTY              SMALLINT               --         
      *--            I_ACCOUNT_NO             DECIMAL(13, 0)         --         
      *--            I_LAST_UPDATE_USERID     CHAR(7)                --         
      *--            I_LOCAL_OFFICE           CHAR(3)                --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  CSR04760_R1 - BUS RULE DETAILS                            --         
      *--                                                            --         
      *--            RETURN_CODE               INTEGER               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  11/24/2014    SV95326     INITIAL VERSION.                --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04760'.
MSQ017     COPY MFASQLM.
                                                                        
      *                                                                         
       01  WS-START                         PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04760 STARTS HERE'.                 
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * LMS_REQUEST_DETAIL, 4O                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBREQDET                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(30) VALUE SPACES.     
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04760'. 
                                                                        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(4) COMP VALUE 0.     
      *                                                                         
       01  WS-INDEX-VARS.                                               
           05  WS-TAB-INDX                  PIC S9(4) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC-FIELDS.                                              
           05  WS-FIX-EQ-SEQ                PIC S9(10)V USAGE COMP-3    
                                                      VALUE 0.          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(04) COMP VALUE 0.    
      *                                                                         
      ****************************************************************          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18)  VALUE SPACES.    
           10  S-SQLCODE                    PIC S9(9)  COMP VALUE 0.    
           10  S-SQLSTATE                   PIC X(5)   VALUE ' '.       
           10  S-TABLE-NAME                 PIC X(18)  VALUE SPACES.    
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
      *                                                                         
       LINKAGE SECTION.                                                 
       01 PARM-SOURCE-APPL-CD         PIC X(03).                        
COB305 01 PARM-SOURCE-APPL-REQ-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.         
COB305 01 PARM-WMS-POINT-NO        PIC S9(3)V9(2) USAGE COMP-3 VALUE 0.      
       01 PARM-ORDER-TYPE-CD          PIC X(05).                        
       01 PARM-WORK-TYPE-CD           PIC X(03).                        
       01 PARM-RECORD-TYPE-CD         PIC X(01).                        
       01 PARM-STOCK-CD               PIC X(15).                        
       01 PARM-RATE-PLAN-NO           PIC X(03).                        
       01 PARM-RATE-ITEM-CODE         PIC S9(4) COMP.                   
       01 PARM-POLE-TAG-NO            PIC X(12).                        
       01 PARM-REQUEST-ACTION-TS      PIC X(26).                        
       01 PARM-REQUEST-ACTION-CD      PIC X(01).                        
       01 PARM-EQUIP-QTY              PIC S9(4) COMP.                   
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.         
       01 PARM-LAST-UPDATE-USERID     PIC X(07).                        
       01 PARM-LOCAL-OFFICE           PIC X(03).                        
                                                                        
       PROCEDURE DIVISION USING PARM-SOURCE-APPL-CD                     
                               ,PARM-SOURCE-APPL-REQ-NO                 
                               ,PARM-WMS-POINT-NO                       
                               ,PARM-ORDER-TYPE-CD                      
                               ,PARM-WORK-TYPE-CD                       
                               ,PARM-RECORD-TYPE-CD                     
                               ,PARM-STOCK-CD                           
                               ,PARM-RATE-PLAN-NO                       
                               ,PARM-RATE-ITEM-CODE                     
                               ,PARM-POLE-TAG-NO                        
                               ,PARM-REQUEST-ACTION-TS                  
                               ,PARM-REQUEST-ACTION-CD                  
                               ,PARM-EQUIP-QTY                          
                               ,PARM-ACCOUNT-NO                         
                               ,PARM-LAST-UPDATE-USERID                 
                               ,PARM-LOCAL-OFFICE.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 7000-TAG-NO-CASE-CNVRSN     THRU 7000-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04760_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04760_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04760_R1
              (                                                       
                    RETURN_CODE             INT                     
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                  FROM #CSR04760_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*           FROM SESSION.CSR04760_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-SOURCE-APPL-CD       TO 4O-SOURCE-APPL-CD          
           MOVE PARM-SOURCE-APPL-REQ-NO   TO 4O-SOURCE-APPL-REQ-NO      
           MOVE PARM-WMS-POINT-NO         TO 4O-WMS-POINT-NO            
           MOVE PARM-ORDER-TYPE-CD        TO 4O-ORDER-TYPE-CD           
           MOVE PARM-WORK-TYPE-CD         TO 4O-WORK-TYPE-CD            
           MOVE PARM-RECORD-TYPE-CD       TO 4O-RECORD-TYPE-CD          
           MOVE PARM-STOCK-CD             TO 4O-STOCK-CD                
           MOVE PARM-RATE-PLAN-NO         TO 4O-RATE-PLAN-NO            
           MOVE PARM-RATE-ITEM-CODE       TO 4O-RATE-ITEM-CODE          
           MOVE PARM-POLE-TAG-NO          TO 4O-POLE-TAG-NO             
           MOVE PARM-REQUEST-ACTION-TS    TO 4O-REQUEST-ACTION-TS       
           MOVE PARM-REQUEST-ACTION-CD    TO 4O-REQUEST-ACTION-CD       
           MOVE PARM-EQUIP-QTY            TO 4O-EQUIP-QTY               
           MOVE PARM-ACCOUNT-NO           TO 4O-ACCOUNT-NO              
           MOVE PARM-LAST-UPDATE-USERID   TO 4O-LAST-UPDATE-USERID.     
           MOVE PARM-LOCAL-OFFICE         TO 4O-LOCAL-OFFICE.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE 01                             TO WS-TAB-INDX.          
           PERFORM 2100-PROCESS-DATA           THRU 2100-EXIT           
                   UNTIL WS-TAB-INDX > PARM-EQUIP-QTY.                  
                                                                        
           PERFORM 2500-MOVE-RESULT            THRU 2500-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-PROCESS-DATA.                                             *        
      ******************************************************************        
       2100-PROCESS-DATA.                                               
                                                                        
           PERFORM 8200-INSERT-REQUEST-DETAIL      THRU 8200-EXIT.      
           ADD 1                                   TO WS-TAB-INDX.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-MOVE-RESULT.                                              *        
      ******************************************************************        
       2500-MOVE-RESULT.                                                
                                                                        
            PERFORM 8100-INSERT-GTT-R1         THRU 8100-EXIT.          
                                                                        
       2500-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 7000-TAG-NO-CASE-CNVRSN.                                                
      ******************************************************************        
       7000-TAG-NO-CASE-CNVRSN.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              UPPER(:PARM-POLE-TAG-NO)
            INTO
              :PARM-POLE-TAG-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :PARM-POLE-TAG-NO = UPPER(:PARM-POLE-TAG-NO)                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                                               TABLE-1                  
              MOVE 'POLE-EQUIP-TAG-NO'      TO TABLE-ELEMENT-1          
              MOVE PARM-POLE-TAG-NO         TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS.                                        *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04760_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04760_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE ZEROES                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
            ELSE                                                        
               MOVE 100                     TO S-RETURN-CODE            
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSR04760_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8100-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8100-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04760_R1                           
                 (                                                      
                   RETURN_CODE                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04760_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE 100                      TO  S-RETURN-CODE           
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04760_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************05610000
      *                                                                *05620000
      * 8200-INSERT-REQUEST-DETAIL.                                    *05630000
      ******************************************************************05640000
       8200-INSERT-REQUEST-DETAIL.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO LMS_REQUEST_DETAIL                            
                  (TRANS_SEQ_NO                                         
                  ,SOURCE_APPL_CD                                       
                  ,SOURCE_APPL_REQ_NO                                   
                  ,WMS_POINT_NO                                         
                  ,ORDER_TYPE_CD                                        
                  ,WORK_TYPE_CD                                         
                  ,RECORD_TYPE_CD                                       
                  ,STOCK_CD                                             
                  ,RATE_PLAN_NO                                         
                  ,RATE_ITEM_CODE                                       
                  ,POLE_TAG_NO                                          
                  ,REQUEST_ACTION_TS                                    
                  ,REQUEST_ACTION_CD                                    
                  ,EQUIP_QTY                                            
                  ,ACCOUNT_NO                                           
                  ,LAST_UPDATE_USERID                                   
                  ,LOCAL_OFFICE                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   CIS.CURRENT$TIMESTAMP()                                    
                  ,:4O-SOURCE-APPL-CD                                   
                  ,:4O-SOURCE-APPL-REQ-NO                               
                  ,:4O-WMS-POINT-NO                                     
                  ,:4O-ORDER-TYPE-CD                                    
                  ,:4O-WORK-TYPE-CD                                     
                  ,:4O-RECORD-TYPE-CD                                   
                  ,:4O-STOCK-CD                                         
                  ,:4O-RATE-PLAN-NO                                     
                  ,:4O-RATE-ITEM-CODE                                   
                  ,:4O-POLE-TAG-NO                                      
                  ,CIS.CHAR2TIMESTAMP(:4O-REQUEST-ACTION-TS)                    
                  ,:4O-REQUEST-ACTION-CD                                
                  ,:4O-EQUIP-QTY                                        
                  ,:4O-ACCOUNT-NO                                       
                  ,:4O-LAST-UPDATE-USERID                               
                  ,:4O-LOCAL-OFFICE                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05670000
MFA-TR*       INSERT INTO LMS_REQUEST_DETAIL                            05680000
MFA-TR*           (TRANS_SEQ_NO                                         05690000
MFA-TR*           ,SOURCE_APPL_CD                                       05700000
MFA-TR*           ,SOURCE_APPL_REQ_NO                                   05700000
MFA-TR*           ,WMS_POINT_NO                                         05700000
MFA-TR*           ,ORDER_TYPE_CD                                        05700000
MFA-TR*           ,WORK_TYPE_CD                                         05700000
MFA-TR*           ,RECORD_TYPE_CD                                       05700000
MFA-TR*           ,STOCK_CD                                             05700000
MFA-TR*           ,RATE_PLAN_NO                                         05710000
MFA-TR*           ,RATE_ITEM_CODE                                       05720000
MFA-TR*           ,POLE_TAG_NO                                          05730000
MFA-TR*           ,REQUEST_ACTION_TS                                    05740000
MFA-TR*           ,REQUEST_ACTION_CD                                    05740000
MFA-TR*           ,EQUIP_QTY                                            05740000
MFA-TR*           ,ACCOUNT_NO                                           05700000
MFA-TR*           ,LAST_UPDATE_USERID                                   05710000
MFA-TR*           ,LOCAL_OFFICE                                         05710000
MFA-TR*          )                                                      05750000
MFA-TR*       VALUES                                                    05760000
MFA-TR*          (                                                      05770000
MFA-TR*            CURRENT TIMESTAMP                                    05700000
MFA-TR*           ,:4O-SOURCE-APPL-CD                                   05700000
MFA-TR*           ,:4O-SOURCE-APPL-REQ-NO                               05700000
MFA-TR*           ,:4O-WMS-POINT-NO                                     05700000
MFA-TR*           ,:4O-ORDER-TYPE-CD                                    05700000
MFA-TR*           ,:4O-WORK-TYPE-CD                                     05700000
MFA-TR*           ,:4O-RECORD-TYPE-CD                                   05700000
MFA-TR*           ,:4O-STOCK-CD                                         05710000
MFA-TR*           ,:4O-RATE-PLAN-NO                                     05720000
MFA-TR*           ,:4O-RATE-ITEM-CODE                                   05730000
MFA-TR*           ,:4O-POLE-TAG-NO                                      05740000
MFA-TR*           ,:4O-REQUEST-ACTION-TS                                05740000
MFA-TR*           ,:4O-REQUEST-ACTION-CD                                05740000
MFA-TR*           ,:4O-EQUIP-QTY                                        05700000
MFA-TR*           ,:4O-ACCOUNT-NO                                       05710000
MFA-TR*           ,:4O-LAST-UPDATE-USERID                               05710000
MFA-TR*           ,:4O-LOCAL-OFFICE                                     05710000
MFA-TR*          )                                                      05830000
MFA-TR*    END-EXEC.                                                    05840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8200'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'LMS_REQUEST_DETAIL'     TO  TABLE-1                 
              MOVE 'SOURCE_APPL_CD'         TO  TABLE-ELEMENT-1         
              MOVE 'SOURCE_APPL_REQ_NO'     TO  TABLE-ELEMENT-2         
              MOVE 4O-SOURCE-APPL-CD        TO  HOSTVAR-ELEMENT-1       
              MOVE 4O-SOURCE-APPL-REQ-NO    TO  HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
        8200-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              MOVE   0                      TO S-RETURN-CODE            
              PERFORM 8100-INSERT-GTT-R1       THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04760_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE.           
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
                                                                        
           PERFORM 8100-INSERT-GTT-R1             THRU 8100-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
            
MSQ016        GOBACK.                                                   
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
