       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04759.                                          
COB303 DATE-WRITTEN.     FEB 02, 1996.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S321                                           *        
      *  PROGRAM:       S321                                           *        
      *  CALLING SP:    PA_S321                                        *        
      *  VIEW :         RECONNECT                                      *        
      *  BUSOP:         REQUUPDACCTRECONNECTAGREEMENTINFO              *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM WAS CLONED FROM CSR02321 TO SUPPORT NEW CIS       *        
      * RECONNECT VIEW.                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/02/96   SD        ORIGINALLY WRITTEN                       *        
      *                                                                *        
TP8830*  02/07/97   KOG       ONLY MOVE RECONNECT TABLE ID WHEN        *        
TP8830*                       PROCESSING RECONNECT TYPE.               *        
TP9561*  04/08/97   MJG       FIX THE TRANSACTION JOURNAL ACCORDING TO *        
TP9561*                       PCR 404 AND TPR 9561.                    *        
T18187*  11/17/98   PRA       MADE NOT FOUND CONDITION ACCEPTABLE      *        
      *                       WHEN DELETING RECONNECT AGREEMENT        *        
      *                                                                *        
CBSI  *  12/28/98   KP        MC05 ABEND LOG CORRECTIONS               *        
T19270*  03/10/99   MDJ       WHEN DELETING RECONNECT AGREEMENT, CHECK *        
      *                       CSS_AR_CNTL FOR PRIORITY LEVEL 60 (RCC). *        
      *                       IF ROW EXISTS, DO NOT SPACE OUT WS-CODE- *        
      *                       CONNECT ON CODES DATA PRESENT.                    
T22344*  06/14/00   SR82046   WHEN UPDATING RECONNECT AGREEMENT, SPACE *        
T22344*                       OUT THE WS-CODE-PENDING-DNP ON CODES DATA*        
T22344*                       PRESENT.                                 *        
T29750*  12/23/03   JS83520   WHEN CHANGING HOURS FOR RECONNECT        *        
T29750*                       AGREEMENT THE COLLECT AMOUNT SHOULD BE   *        
T29750*                       UPDATED APPROPRIATELY                    *        
C26296*  02/10/05   SS82048   CHANGES FOR AUTOMATING DEPOSITS          *        
PRDFIX*  06/30/05   SS82048   FIX FOR CODES DATA PRESENT AFTER SETTING *        
      *                       UP AN AUTO DEPOSIT.                      *        
REARCH*  06/25/05   CVNS      RPC TO DB2 COBOL CONVERSION              *        
REARCH*             CHENNAI                                            *        
A37061* 03/27/09   SJ97149   1.REPLACE CODE_REV_CLASS MID DIGIT CHECK *         
A37061*                         WITH CSS_ACCOUNT.ACCOUNT_TYPE_CODE FOR *        
A37061*                         GETTING TYPE OF THE ACCOUNT.           *        
A37061*                       2.ADDED "ROWSET POSITIONING FOR GLOBAL"  *        
A37061*                         TEMPERARY TABLES.                      *        
A37061*                       3.ADDED "WITH UR" TO SQL STATEMENTS.     *        
A02604* 12/23/10   VIJAY     UPDATES COMMENTS IN TRANS HISTORY.        *        
P00726* 04/10/14   AA97148   CREDIT ARRANGEMENTS RELEASE 3 CHANGES -   *        
P00726*                      ADDED NEW FIELDS TO THE RECONNECT TABLE.  *        
P0726A* 01/23/15   GOKUL     ADD TRANSLATIONS FOR RCC_BILL_OPTION_CD.  *        
P0726B* 07/09/15   AA97148   CREDIT ARRANGEMENTS RELEASE 6 CHANGES -   *        
P0726B*                      DEFECT ID 7252  - ADDED LAST UPDATE       *        
P0726B*                      TIMESTAMP VALIDATION.                     *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04759'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR04759 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
T29750     EXEC SQL                                                             
T29750        INCLUDE TBRCNCHR                                                  
T29750     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
T29750     EXEC SQL                                                             
T29750        INCLUDE TBUTLENV                                                  
T29750     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
C26296*                                                                         
C26296*    CSS_DEP_ON_HAND (DO)                                                 
C26296     EXEC SQL                                                             
C26296        INCLUDE TBDEPHND                                                  
C26296     END-EXEC.                                                            
C26296                                                                  
P0726A******************************************************************        
P0726A*    CSS_CODE_VALUE - UV                                         *        
P0726A******************************************************************        
P0726A*                                                                         
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBCDVALU                                                  
P0726A     END-EXEC.                                                            
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      *--------< SUPPORTS CODES-DATA-PRESENT FOR CSS_ACCOUNT >                  
           COPY CWS00056.                                                       
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-DL-NULL-IND-1              PIC S9(4) COMP.             
P00726     05 WS-RCNCT-TERM-ID-NULL         PIC S9(4) COMP VALUE +0.    
C26296     05 WS-NULL-IND4                  PIC S9(04) COMP.            
      *                                                                         
       01  WS-MISC.                                                     
REARCH     05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04759'.    
           05 WS-A                       PIC X(01) VALUE 'A'.           
           05 WS-RECNCT-COLLCT-NUM       PIC 9(7)V99.                   
           05 WS-RECNCT-COLLCT-EDT       PIC $$$$$$9.99.                
           05 WS-TOT-RECNCT-NUM          PIC 9(11)V99.                  
           05 WS-TOT-RECNCT-EDT          PIC $$$$$$$$$$9.99.            
           05 WS-UNPACK-VALUES.                                         
              10 WS-UNPACK-VALUES-N      PIC 9(11)V9(2).                
           05 WS-CLASS                   PIC X(01) VALUE SPACES.        
           05 WS-ACCT-TYPE-CD            PIC X(01) VALUE SPACES.        
P00726     05 WS-RCNCT-TERM-ID           PIC S9(4) USAGE COMP VALUE +0. 
P00726     05 WS-LAST-UPDATE-USERID      PIC X(07) VALUE SPACE.         
P0726B     05 WS-LAST-UPDATE-TIMESTAMP   PIC X(26) VALUE SPACES.        
P00726     05 WS-RCC-BILL-OPTION-CD      PIC X(01) VALUE SPACE.         
C26296     05 WS-DEFAULT-AUTO-DEP-AMT    PIC S9(09)V99 COMP-3 VALUE 0.  
C26296     05 WS-DEFAULT-AUTO-DEP-AMT-X  PIC $(05)9 VALUE SPACES.       
C26296     05 WS-AUTO-DEP-AMT-ED       PIC $$$$,$$$,$$9.99 VALUE SPACES.
C26296     05 WS-DEFAULT-BILL-OPT-CD     PIC X(01) VALUE SPACES.        
C26296     05 WS-AUTO-DEP-AMT-CHG        PIC X(01) VALUE 'N'.           
C26296        88 AUTO-DEP-AMT-CHG                  VALUE 'Y'.           
C26296     05 WS-AUTO-DEP-RECALC-CHG     PIC X(01) VALUE 'N'.           
C26296        88 AUTO-DEP-RECALC-CHG               VALUE 'Y'.           
C26296     05 WS-BILL-OPT-CHG            PIC X(01) VALUE 'N'.           
C26296        88 BILL-OPT-CHG                      VALUE 'Y'.           
C26296     05 WS-INSTALL-CHG             PIC X(01) VALUE 'N'.           
C26296        88 INSTALL-CHG                       VALUE 'Y'.           
C26296                                                                  
C26296     05  WS-AUTO-DEP-AMT-NUM        PIC S9(9)V99 VALUE ZEROES.    
C26296     05  WS-AUTO-DEP-AMT-X  REDEFINES WS-AUTO-DEP-AMT-NUM         
C26296                                    PIC X(11).                    
C26296     05  WS-AUTO-DEP-AMT-Z          PIC $(05)9 VALUE SPACES.      
C26296     05  WS-NO-SCHED-PYMTS-NUM      PIC S9(03) VALUE ZEROES.      
C26296     05  WS-NO-SCHED-PYMTS-X REDEFINES WS-NO-SCHED-PYMTS-NUM      
C26296                                    PIC X(03).                    
C26296     05  WS-COMMENTS-LEN-NUM        PIC S9(04) VALUE ZEROES.      
C26296     05  WS-COMMENTS-LEN-X   REDEFINES WS-COMMENTS-LEN-NUM        
C26296                                    PIC X(04).                    
C26296     05  WS-DEP-TYPE-TEXT           PIC X(15) VALUE SPACES.       
C26296     05  WS-DEP-TYPE-LEN            PIC S9(02) COMP VALUE ZEROES. 
C26296     05  WS-PANEL-COMM-LEN-NUM    PIC S9(04) VALUE ZEROES.        
C26296     05  WS-PANEL-COMM-LEN-X     REDEFINES WS-PANEL-COMM-LEN-NUM  
C26296                                    PIC X(04).                    
C26296     05  WS-PANL-CMNTS-BILL-OPT1    PIC X(10) VALUE SPACES.       
C26296     05  WS-PANL-CMNTS-BILL-OPT2    PIC X(17) VALUE SPACES.       
C26296     05  WS-PANL-CMNTS-BILL-OPT     PIC X(35) VALUE SPACES.       
C26296     05  WS-PANL-CMNTS-AUTO-DEP-AM  PIC X(37) VALUE SPACES.       
C26296     05  WS-INSTALL-CMNTS-NO        PIC Z9 VALUE SPACES.          
C26296     05  WS-MAX-DEP-CERT-NO         PIC S9(9) COMP VALUE 0.       
C26296     05  WS-MTHLY-INSTAL-AMT-NUM    PIC S9(9)V99 VALUE ZEROES.    
C26296     05  WS-MTHLY-INSTAL-AMT-X REDEFINES WS-MTHLY-INSTAL-AMT-NUM  
C26296                                    PIC X(11).                    
C26296     05  WS-RECALC-DIFF             PIC S9(9)V99 COMP-3 VALUE 0.  
C26296     05  WS-RECNCT-AMT-ZERO-UPDT    PIC X(01) VALUE 'N'.          
C26296         88 RECONNECT-AMT-ZERO-UPDT           VALUE 'Y'.          
      *                                                                         
       01  WS-REFUND-TABLE.                                             
           05 WS-PARM-ACCOUNT-NO         PIC X(13).                     
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-PARM-ACCOUNT-NO            
                                         PIC 9(13).                     
COB305     05 WS-AMT-TOT-RECONNECT-COMP3        PIC S9(11)V99 COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RCNCT-COLLECT-AMT-COMP3        PIC S9(07)V99 COMP-3 
COB305       VALUE 0.          
           05 WS-LENGTH                  PIC X(04).                     
           05 WS-LENGTH-NUM              REDEFINES WS-LENGTH            
                                         PIC 9(04).                     
           05 WS-TRANS-COMMENTS          PIC X(210).                    
           05 WS-TRANS-COMMENTS-LEN      PIC S9(4) COMP.                
      *                                                                         
       01  WS-INTERMEDIATE.                                             
           05 WS-DB2-DATE.                                              
              10 DB2-CCYY                PIC X(04).                     
              10 FILLER                  PIC X(01) VALUE '-'.           
              10 DB2-MM                  PIC X(02).                     
              10 FILLER                  PIC X(01) VALUE '-'.           
              10 DB2-DD                  PIC X(02).                     
           05 WS-FORMAT-DATE.                                           
              10 FORMAT-MM               PIC X(02).                     
              10 FILLER                  PIC X(01) VALUE '/'.           
              10 FORMAT-DD               PIC X(02).                     
              10 FILLER                  PIC X(01) VALUE '/'.           
              10 FORMAT-CCYY             PIC X(04).                     
      *                                                                         
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-USERID                  PIC X(08)  VALUE SPACES.      
           05  WS-CURRENT-DATE            PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.      
           05  WS-ACCOUNT-EXISTS          PIC X(01)  VALUE 'N'.         
           05  WS-PANEL-NO                PIC X(09)  VALUE 'PANEL125 '. 
           05  WS-COMMENT                 PIC X(210).                   
           05  WS-COMMENT-LEN             PIC S9(04)  VALUE 0 COMP.     
           05  WS-RESP-AREA-ID            PIC X(03)   VALUE SPACES.     
COB305     05 WS-CUSTOMER-NO-COMP        PIC S9(10) COMP-3 VALUE 0.           
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10) COMP-3 VALUE 0.           
      *                                                                         
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE          PIC X(01)   VALUE 'F'.        
           05  WS-TRAN-APPL-NO            PIC S9(02)  VALUE 0.          
           05  WS-TABLE-ID                PIC X(02).                    
           05  WS-COLUMN-DESC             PIC X(15).                    
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(30).                    
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02).                   
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(30).                    
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02).                   
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROCESS-ONCE-SW         PIC X(01) VALUE 'N'.             
               88 PROCESS-ONCE                   VALUE 'Y'.             
T19270     05  RCC-AR-ROW-EXISTS-SW    PIC X(01) VALUE 'N'.             
T19270         88  RCC-AR-ROW-EXISTS             VALUE 'Y'.             
      *                                                                 00052000
C26296*                                                                         
C26296 01  WS-CSR02072-INPUT-FIELDS.                                    
C26296     05  WS-ACTION-CODE            PIC X(01).                     
C26296     05  WS-ACCT-NO                PIC X(13).                     
C26296     05  WS-AMT-ORIG-ENTERED       PIC X(11).                     
C26296     05  WS-DEPOSIT-STATUS-CD      PIC X(01).                     
C26296     05  WS-SERVICE-TYPE-CD        PIC X(01).                     
C26296     05  WS-DEPOSIT-CERT-NO        PIC X(09).                     
C26296     05  WS-DEP-ACTION-CODE        PIC X(01).                     
C26296     05  WS-USER-ID-UPDT-BY        PIC X(07).                     
C26296     05  WS-COMMENTS               PIC X(210).                    
C26296     05  WS-COMMENTS-LEN           PIC X(04).                     
C26296     05  WS-PANEL-COMMENTS         PIC X(72).                     
C26296     05  WS-PANEL-COMM-LEN         PIC X(04).                     
C26296     05  WS-BILL-OPTION-CD         PIC X(01).                     
C26296     05  WS-ORIG-BILL-OPTN         PIC X(01).                     
C26296     05  WS-NO-SCHED-PYMTS         PIC X(03).                     
C26296     05  WS-AMT-MO-PYMT            PIC X(11).                     
C26296     05  WS-CODE-DEP-TYPE          PIC X(01).                     
C26296     05  WS-CUT-DATE               PIC X(10).                     
C26296     05  WS-PROJECT-CR-DT          PIC X(10).                     
C26296     05  WS-DUE-DATE               PIC X(10).                     
C26296     05  WS-PROGRAM-NAME           PIC X(09).                     
C26296     05  WS-LAST-UPDATE-TS         PIC X(26).                     
C26296     05  WS-CODE-REFUND-ELIG       PIC X(01).                     
C26296     05  WS-ERROR-SWITCH           PIC X(01).                     
C26296     05  WS-AUTO-DEP-LETTER-IND    PIC X(01).                     
C26296     05  WS-AUTO-DEP-LTR-DT        PIC X(10).                     
COB305     05 WS-AUTO-DEP-NOT-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305     05 WS-AUTO-DEP-RECALC-AMT        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.          
C26296*                                                                         
C26296 01  WS-CSR02072-OUTPUT-FIELDS.                                   
C26296     05  WS-CSR02072-ERROR-CODE     PIC X(50) VALUE SPACES.       
C26296     05  WS-CSR02072-RETURN-CODE    PIC S9(09) USAGE COMP         
C26296                                              VALUE ZEROES.       
C26296     05  WS-CSR02072-AR-LOCKOUT-IND PIC X(01) VALUE SPACES.       
C26296     05  WS-CSR02072-ACCT-XFER-TO   PIC X(13) VALUE SPACES.       
C26296     05  WS-CSR02072-SUCCESS-FL     PIC X(01) VALUE SPACES.       
C26296     05  WS-CSR02072-ABEND-PROGRAM     PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-ACTIVE-PARAGRAPH  PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-ABEND-FUNCTION    PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-TABLE-1           PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-TABLE-ELEMENT-1   PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-HOSTVAR-ELEMENT-1 PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-TABLE-ELEMENT-2   PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-HOSTVAR-ELEMENT-2 PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-TABLE-ELEMENT-3   PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-HOSTVAR-ELEMENT-3 PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-TABLE-ELEMENT-4   PIC X(20) VALUE SPACES.    
C26296     05  WS-CSR02072-HOSTVAR-ELEMENT-4 PIC X(20) VALUE SPACES.    
C26296*                                                                         
C26296***************************************************************   ****    
C26296*    DB2 COMMUNICATION REQUIREMENT *                                      
C26296***************************************************************   ****    
C26296*01  LOC1                  USAGE IS SQL TYPE IS                   
C26296*                          RESULT-SET-LOCATOR VARYING.            
C26296 01  ERROR-MESSAGE.                                               
C26296     02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
C26296     02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
C26296                           INDEXED BY ERROR-INDEX.                
C26296 77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
C26296 77  TRACE-MESSAGE-AREA    PIC X(256).                            
C26296 77  OPENFN                PIC X(12).                             
C26296 77  SSID                  PIC X(4).                              
C26296 77  PLANNAME              PIC X(8).                              
C26296 77  RETCODE               PIC S9(5).                             
C26296 77  REASCODE              PIC S9(5).                             
C26296 77  CLOSFN                PIC X(12).                             
C26296 77  TERMOP                PIC X(4).                              
C26296                                                                  
C26296 01  GTT-RETURN-FIELDS.                                           
C26296     05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-RETURN-MESSAGE        PIC X(50) VALUE SPACES.          
P0726B     05  S-APPL-RETURN-CODE      PIC X(10)  VALUE SPACES.         
C26296     05  S-AUTO-DEP-AMT          PIC S9(09)V99 COMP-3 VALUE 0.    
C26296     05  S-DEP-SUCCESS           PIC X(01)  VALUE SPACES.         
C26296     05  S-DEP-CERT-NO           PIC S9(9)  COMP VALUE 0.         
C26296     05  S-ABEND-PROGRAM         PIC X(08)  VALUE SPACES.         
C26296     05  S-ACTIVE-PARAGRAPH      PIC X(04)  VALUE SPACES.         
C26296     05  S-ABEND-FUNCTION        PIC X(08)  VALUE SPACES.         
C26296     05  S-TABLE-1               PIC X(20)  VALUE SPACES.         
C26296     05  S-TABLE-ELEMENT-1       PIC X(20)  VALUE SPACES.         
C26296     05  S-HOSTVAR-ELEMENT-1     PIC X(20)  VALUE SPACES.         
C26296     05  S-TABLE-ELEMENT-2       PIC X(20)  VALUE SPACES.         
C26296     05  S-HOSTVAR-ELEMENT-2     PIC X(20)  VALUE SPACES.         
C26296     05  S-TABLE-ELEMENT-3       PIC X(20)  VALUE SPACES.         
C26296     05  S-HOSTVAR-ELEMENT-3     PIC X(20)  VALUE SPACES.         
C26296     05  S-TABLE-ELEMENT-4       PIC X(20)  VALUE SPACES.         
C26296     05  S-HOSTVAR-ELEMENT-4     PIC X(20)  VALUE SPACES.         
      *                                                                         
HPCCDM*    EJECT                                                        00096000
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR04759_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH                                                                  
       01  PARM-FIELDS.                                                 
           05  PARM-TRANS-COMMENTS     PIC X(210).                      
           05  PARM-TRANS-COMMENTS-LEN PIC X(4).                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
            05 RS-RETURN-MESSAGE       PIC X(50) VALUE SPACES.          
P0726B      05 RS-APPL-RETURN-CODE     PIC X(10) VALUE SPACES.          
                                                                        
REARCH                                                                  
REARCH                                                                  
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).
MSQ001        EXEC SQL
MSQ001          DECLARE CHRG_AUTO_DEP CURSOR
MSQ001          FOR CALL CSR02072                                       
C26296     ( :WS-ACTION-CODE
                  , :WS-ACCT-NO
                  , :WS-AMT-ORIG-ENTERED
                  , :WS-DEPOSIT-STATUS-CD
                  , :WS-SERVICE-TYPE-CD
                  , :WS-DEPOSIT-CERT-NO
                  , :WS-DEP-ACTION-CODE
                  , :WS-USER-ID-UPDT-BY
                  , :WS-COMMENTS
                  , :WS-COMMENTS-LEN
                  , :WS-PANEL-COMMENTS
                  , :WS-PANEL-COMM-LEN
                  , :WS-BILL-OPTION-CD
                  , :WS-ORIG-BILL-OPTN
                  , :WS-NO-SCHED-PYMTS
                  , :WS-AMT-MO-PYMT
                  , :WS-CODE-DEP-TYPE
                  , :WS-CUT-DATE
                  , :WS-PROJECT-CR-DT
                  , :WS-DUE-DATE
                  , :WS-PROGRAM-NAME
                  , :WS-LAST-UPDATE-TS
                  , :WS-CODE-REFUND-ELIG
                  , :WS-ERROR-SWITCH
                  , :WS-AUTO-DEP-LTR-DT
                  , :WS-AUTO-DEP-LETTER-IND
                  , :WS-AUTO-DEP-NOT-AMT
                  , :WS-AUTO-DEP-RECALC-AMT
                  )
MSQ001        END-EXEC.
                     
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO               PIC X(13).                     
REARCH 01  PARM-ACTION-CODE              PIC X(01).                     
REARCH 01  PARM-AGREEMENT-COMMENTS       PIC X(26).                     
COB305 01 PARM-AMT-TOT-RECONNECT        PIC S9(11)V9(2) COMP-3 VALUE 0.        
COB305 01 PARM-RECNCT-COLLECT-AMT        PIC S9(07)V9(2) COMP-3 VALUE 0.        
REARCH 01  PARM-RECNCT-TYPE-CD           PIC X(03).                     
REARCH 01  PARM-USER-ID                  PIC X(07).                     
REARCH 01  PARM-TRANS-CMT                PIC X(210).                    
REARCH 01  PARM-TRANS-CMT-LEN            PIC X(4).                      
REARCH 01  PARM-AUTO-DEP-ID              PIC S9(09) COMP.               
REARCH 01  PARM-AUTO-DEP-LTR-IND         PIC X(01).                     
COB305 01 PARM-AUTO-DEP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305 01 PARM-RECALC-AUTO-DEP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.         
COB305 01 PARM-NOTC-AUTO-DEP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305 01 PARM-DEP-COLLECT-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
REARCH 01  PARM-DEP-BILL-OPT-CD          PIC X(01).                     
REARCH 01  PARM-NO-SCHED-PYMTS           PIC S9(09) COMP.               
REARCH 01  PARM-START-DATE               PIC X(10).                     
COB305 01 PARM-MTHLY-INSTALL-AMT        PIC S9(09)V99 COMP-3 VALUE 0.          
REARCH 01  PARM-RECALC-UPDT              PIC X(01).                     
P00726 01  PARM-RCNCT-TERM-ID            PIC S9(04) COMP.               
P00726 01  PARM-LAST-UPDATE-USERID       PIC X(07).                     
P00726 01  PARM-RCC-BILL-OPTION-CD       PIC X(01).                     
P0726B 01  PARM-LAST-UPDATE-TS           PIC X(26).                     
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                         ,PARM-ACTION-CODE                        
REARCH                         ,PARM-AGREEMENT-COMMENTS                 
REARCH                         ,PARM-AMT-TOT-RECONNECT                  
REARCH                         ,PARM-RECNCT-COLLECT-AMT                 
REARCH                         ,PARM-RECNCT-TYPE-CD                     
REARCH                         ,PARM-USER-ID                            
REARCH                         ,PARM-TRANS-CMT                          
REARCH                         ,PARM-TRANS-CMT-LEN                      
REARCH                         ,PARM-AUTO-DEP-ID                        
REARCH                         ,PARM-AUTO-DEP-LTR-IND                   
REARCH                         ,PARM-AUTO-DEP-AMT                       
REARCH                         ,PARM-RECALC-AUTO-DEP-AMT                
REARCH                         ,PARM-NOTC-AUTO-DEP-AMT,                 
REARCH                         ,PARM-DEP-COLLECT-AMT,                   
REARCH                         ,PARM-DEP-BILL-OPT-CD,                   
REARCH                         ,PARM-NO-SCHED-PYMTS                     
REARCH                         ,PARM-START-DATE                         
REARCH                         ,PARM-MTHLY-INSTALL-AMT                  
REARCH                         ,PARM-RECALC-UPDT                        
P00726                         ,PARM-RCNCT-TERM-ID                      
P00726                         ,PARM-LAST-UPDATE-USERID                 
P00726                         ,PARM-RCC-BILL-OPTION-CD                 
P0726B                         ,PARM-LAST-UPDATE-TS.                    
REARCH*                                                                         
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
REARCH     PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT.                 
REARCH     ADD +1                      TO CTR-ROWS.                     
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR                             
A37061                          WITH ROWSET POSITIONING FOR             
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE          AS  RETURN_CODE              
REARCH            ,:S-RETURN-MESSAGE       AS  RETURN_MESSAGE           
P0726B            ,:S-APPL-RETURN-CODE     AS  APPL_RETURN_CODE         
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*           ,:S-RETURN-MESSAGE       AS  RETURN_MESSAGE                   
MFA-TR*           ,:S-APPL-RETURN-CODE     AS  APPL_RETURN_CODE                 
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************@***********************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
REARCH     MOVE PARM-TRANS-CMT           TO PARM-TRANS-COMMENTS.        
REARCH     MOVE PARM-TRANS-CMT-LEN       TO PARM-TRANS-COMMENTS-LEN.    
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-PARM-ACCOUNT-NO.        
           MOVE WS-ACCOUNT-NO-NUM         TO DL-ACCOUNT-NO              
                                             AT-ACCOUNT-NO.             
                                                                        
P00726     MOVE PARM-AMT-TOT-RECONNECT    TO WS-AMT-TOT-RECONNECT-COMP3.
C26296     IF  WS-AMT-TOT-RECONNECT-COMP3 < ZEROES                      
C26296         MOVE ZEROES                TO WS-AMT-TOT-RECONNECT-COMP3 
C26296     END-IF                                                       
P00726     MOVE PARM-RECNCT-COLLECT-AMT   TO WS-RCNCT-COLLECT-AMT-COMP3.
                                                                        
           MOVE PARM-USER-ID              TO WS-USERID  DL-USER-ID.     
                                                                        
           MOVE PARM-TRANS-COMMENTS       TO WS-TRANS-COMMENTS.         
           MOVE PARM-TRANS-COMMENTS-LEN   TO WS-LENGTH.                 
           MOVE WS-LENGTH-NUM             TO WS-TRANS-COMMENTS-LEN.     
P00726     MOVE PARM-RCNCT-TERM-ID        TO WS-RCNCT-TERM-ID.          
P00726     MOVE PARM-LAST-UPDATE-USERID   TO WS-LAST-UPDATE-USERID.     
P00726     MOVE PARM-RCC-BILL-OPTION-CD   TO WS-RCC-BILL-OPTION-CD.     
P0726B     MOVE PARM-LAST-UPDATE-TS       TO WS-LAST-UPDATE-TIMESTAMP.  
P00726                                                                  
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2110-DESC-RET-CODE                                   *        
      *           5000-PROCESS-REFUND                                  *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           MOVE '0'                              TO RS-RETURN-MESSAGE.  
           PERFORM 5000-PROCESS-REFUND           THRU 5000-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH      MOVE RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH      MOVE RS-RETURN-MESSAGE        TO S-RETURN-MESSAGE.          
P0726B      MOVE RS-APPL-RETURN-CODE      TO S-APPL-RETURN-CODE.        
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH                                                                  
      ***********************************************************               
      * 5000-PROCESS-REFUND.                                                    
      ******************************@****************************               
                                                                        
       5000-PROCESS-REFUND.                                             
           MOVE '5000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 7000-GET-CURRENT-DATE  THRU 7000-EXIT.               
      *                                                                         
           PERFORM 7010-ACCEPT-TIMESTAMP  THRU 7010-EXIT.               
      *                                                                         
           PERFORM 7020-SELECT-ACCOUNT    THRU 7020-EXIT.               
      *                                                                         
P0726B* TIMESTAMP VALIDATION ON ARRANGEMENT SETUP VIEW                          
P0726B     IF WS-LAST-UPDATE-TIMESTAMP = AT-LAST-UPDATE-TS              
P0726B        CONTINUE                                                  
P0726B     ELSE                                                         
P0726B        MOVE 0                   TO RS-RETURN-CODE                
P0726B        MOVE 'CMN0000016'        TO RS-APPL-RETURN-CODE           
P0726B        GO TO 5000-EXIT                                           
P0726B     END-IF.                                                      
P0726B                                                                  
           PERFORM 7030-GET-RESP-AREA-ID  THRU 7030-EXIT.               
      *                                                                         
           PERFORM 8000-SELECT-RECONNECT  THRU 8000-EXIT.               
      *                                                                         
           MOVE WS-CURRENT-DATE           TO DL-DATETIME-SETUP          
                                             WS-DB2-DATE.               
                                                                        
           IF PARM-ACTION-CODE = 'I'                                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 300                      TO RS-RETURN-CODE        
              ELSE                                                      
                 PERFORM 5100-INSERT-RECONNECT THRU 5100-EXIT           
                                                                        
                 MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT 
                 MOVE WS-A                     TO WS-CODE-CONNECT-CHRG  
                 MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT 
                 PERFORM 8600-UPDATE-AT        THRU 8600-EXIT           
              END-IF                                                    
                                                                        
           ELSE                                                         
                                                                        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 300                            TO RS-RETURN-CODE  
              ELSE                                                      
                                                                        
                 IF PARM-ACTION-CODE = 'U'                              
C26296              IF  PARM-RECALC-UPDT = 'Y'                          
C26296                  PERFORM 5350-UPDATE-RECALC   THRU 5350-EXIT     
C26296              ELSE                                                
                        PERFORM 5200-UPDATE-RECONNECT THRU 5200-EXIT    
C26296                  IF PARM-AUTO-DEP-ID = ZEROES                    
C26296*                     IF PARM-AUTO-DEP-AMT > ZEROES                       
C26296                      IF PARM-AUTO-DEP-LTR-IND > SPACES           
C26296                          PERFORM 5250-PROCESS-AUTO-DEPOSIT       
C26296                             THRU 5250-EXIT                       
C26296                      ELSE                                        
C26296                          PERFORM 5290-CHECK-RECONN-AUTO-DEP      
C26296                             THRU 5290-EXIT                       
C26296                      END-IF                                      
C26296                  END-IF                                          
C26296              END-IF                                              
T22344              IF  WS-AMT-TOT-RECONNECT-COMP3 EQUAL ZEROS          
PRDFIX* SELECT CODES-DATA-PRESENT BEFORE UPDATING AS AUTO DEPOSIT               
PRDFIX* COULD HAVE UPDATED THE CODES DATA PRESENT AFTER THE RETRIEVE            
PRDFIX                  PERFORM 7020-SELECT-ACCOUNT  THRU 7020-EXIT     
T22344                  MOVE AT-CODES-DATA-PRESENT   TO                 
T22344                                             WS-CODES-DATA-PRESENT
T22344                  MOVE SPACES                  TO                 
T22344                                               WS-CODE-PENDING-DNP
T22344                  MOVE WS-CODES-DATA-PRESENT   TO                 
T22344                                             AT-CODES-DATA-PRESENT
T22344                  PERFORM 8600-UPDATE-AT       THRU 8600-EXIT     
T22344              END-IF                                              
C26296*             IF  RECONNECT-AMT-ZERO-UPDT                                 
C26296* REVIEW DNPFB/RECONNECT ORDERS FOR MANUAL PROCESSING WOULD BE            
C26296* DISPLAYED ON THE PANEL.                                                 
C26296*                 MOVE 200            TO RS-RETURN-CODE                   
C26296*             END-IF                                                      
                 ELSE                                                   
                    IF PARM-ACTION-CODE = 'D'                           
                       PERFORM 5300-DELETE-RECONNECT THRU 5300-EXIT     
                                                                        
T19270                 PERFORM 7040-SELECT-AR-CNTL   THRU 7040-EXIT     
T19270                 IF RCC-AR-ROW-EXISTS                             
T19270                     NEXT SENTENCE                                
T19270                 ELSE                                             
                           MOVE AT-CODES-DATA-PRESENT    TO             
                                                  WS-CODES-DATA-PRESENT 
                           MOVE SPACE                    TO             
                                                  WS-CODE-CONNECT-CHRG  
                           MOVE WS-CODES-DATA-PRESENT    TO             
                                                  AT-CODES-DATA-PRESENT 
                           PERFORM 8600-UPDATE-AT        THRU 8600-EXIT 
T19270                 END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100 INSERT RECONNECT.                                         *        
      *                                                                *        
      *     -- THIS MODULES INSERTS IN CSS_RECONNECT AND DOES          *        
      *        MAINTAINENCE JOURNALING ROUTINE.                        *        
      *                                                                *        
      ******************************************************************        
       5100-INSERT-RECONNECT.                                           
           MOVE '5100'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE '*NEW*'                     TO WS-PRV-COLUMN-VALUE-TEXT.
           MOVE 5                           TO WS-PRV-COLUMN-VALUE-LEN. 
      *                                                                         
           IF PARM-AGREEMENT-COMMENTS > SPACES                          
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'AGRMT COMMENTS'         TO WS-COLUMN-DESC           
              MOVE 26                       TO WS-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-AGREEMENT-COMMENTS  TO WS-CHG-COLUMN-VALUE-TEXT 
                                               DL-AGREEMENT-COMMENTS    
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           ELSE                                                         
              MOVE SPACES                   TO DL-AGREEMENT-COMMENTS    
           END-IF.                                                      
      *                                                                         
           IF WS-AMT-TOT-RECONNECT-COMP3 > 0                            
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'AGRMT TO COLLCT'        TO WS-COLUMN-DESC           
              MOVE 15                       TO WS-CHG-COLUMN-VALUE-LEN  
                                                                        
              MOVE WS-AMT-TOT-RECONNECT-COMP3 TO DL-AMT-TOT-RECONNECT   
                                               WS-TOT-RECNCT-NUM        
              MOVE WS-TOT-RECNCT-NUM        TO WS-TOT-RECNCT-EDT        
              MOVE WS-TOT-RECNCT-EDT        TO WS-CHG-COLUMN-VALUE-TEXT 
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-RCNCT-COLLECT-AMT-COMP3 > 0                            
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'RCC TO COLLECT'         TO WS-COLUMN-DESC           
              MOVE 15                       TO WS-CHG-COLUMN-VALUE-LEN  
                                                                        
              MOVE WS-RCNCT-COLLECT-AMT-COMP3 TO DL-RECNCT-COLLECT-AMT  
                                               WS-RECNCT-COLLCT-NUM     
              MOVE WS-RECNCT-COLLCT-NUM     TO WS-RECNCT-COLLCT-EDT     
              MOVE WS-RECNCT-COLLCT-EDT     TO WS-CHG-COLUMN-VALUE-TEXT 
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF PARM-RECNCT-TYPE-CD > SPACES                              
TP8830        MOVE 'U7'                     TO WS-TABLE-ID              
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'RCC TYPE'               TO WS-COLUMN-DESC           
              MOVE 3                        TO WS-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-RECNCT-TYPE-CD      TO WS-CHG-COLUMN-VALUE-TEXT 
                                               DL-RECNCT-TYPE-CD        
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
TP8830        MOVE SPACES                   TO WS-TABLE-ID              
           END-IF.                                                      
      *                                                                         
           MOVE 'N' TO DL-RECNCT-NRML-HR-IND.                           
      *                                                                         
           PERFORM 8010-INSERT-RECONNECT    THRU 8010-EXIT.             
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020 UPDATE RECONNECT.                                         *        
      *                                                                *        
      *     -- THIS MODULES UPDATES    CSS_RECONNECT AND DOESTHE       *        
      *        MAINTAINENCE JOURNALING ROUTINE.                        *        
      *                                                                *        
      **********@*******************************************************        
       5200-UPDATE-RECONNECT.                                           
           MOVE '5200'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           IF PARM-AGREEMENT-COMMENTS NOT = DL-AGREEMENT-COMMENTS       
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'AGRMT COMMENTS'        TO WS-COLUMN-DESC            
              MOVE DL-AGREEMENT-COMMENTS    TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE 26                       TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-AGREEMENT-COMMENTS  TO WS-CHG-COLUMN-VALUE-TEXT 
                                               DL-AGREEMENT-COMMENTS    
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-AMT-TOT-RECONNECT-COMP3 NOT = DL-AMT-TOT-RECONNECT     
C26296        IF  WS-AMT-TOT-RECONNECT-COMP3 <= ZEROS                   
C26296            MOVE 'Y'                  TO WS-RECNCT-AMT-ZERO-UPDT  
C26296        END-IF                                                    
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'AGRMT TO COLLCT'        TO WS-COLUMN-DESC           
              MOVE DL-AMT-TOT-RECONNECT     TO WS-TOT-RECNCT-NUM        
                                                                        
              MOVE WS-TOT-RECNCT-NUM        TO WS-TOT-RECNCT-EDT        
              MOVE WS-TOT-RECNCT-EDT        TO WS-PRV-COLUMN-VALUE-TEXT 
                                                                        
              MOVE 15                       TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
                                                                        
              MOVE WS-AMT-TOT-RECONNECT-COMP3 TO DL-AMT-TOT-RECONNECT   
                                               WS-TOT-RECNCT-NUM        
              MOVE WS-TOT-RECNCT-NUM        TO WS-TOT-RECNCT-EDT        
              MOVE WS-TOT-RECNCT-EDT        TO WS-CHG-COLUMN-VALUE-TEXT 
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-RCNCT-COLLECT-AMT-COMP3 NOT = DL-RECNCT-COLLECT-AMT    
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'RCC TO COLLECT'         TO WS-COLUMN-DESC           
              MOVE DL-RECNCT-COLLECT-AMT    TO WS-RECNCT-COLLCT-NUM     
                                                                        
              MOVE WS-RECNCT-COLLCT-NUM     TO WS-RECNCT-COLLCT-EDT     
              MOVE WS-RECNCT-COLLCT-EDT     TO WS-PRV-COLUMN-VALUE-TEXT 
                                                                        
              MOVE 15                       TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
                                                                        
              MOVE WS-RCNCT-COLLECT-AMT-COMP3 TO DL-RECNCT-COLLECT-AMT  
                                               WS-RECNCT-COLLCT-NUM     
              MOVE WS-RECNCT-COLLCT-NUM     TO WS-RECNCT-COLLCT-EDT     
              MOVE WS-RECNCT-COLLCT-EDT     TO WS-CHG-COLUMN-VALUE-TEXT 
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF PARM-RECNCT-TYPE-CD NOT = DL-RECNCT-TYPE-CD               
TP8830        MOVE 'U7'                     TO WS-TABLE-ID              
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'RCC TYPE'               TO WS-COLUMN-DESC           
              MOVE DL-RECNCT-TYPE-CD        TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE 3                        TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-RECNCT-TYPE-CD      TO WS-CHG-COLUMN-VALUE-TEXT 
                                               DL-RECNCT-TYPE-CD        
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
TP8830        MOVE SPACES                   TO WS-TABLE-ID              
T29750*  UPDATE THE RECNCT_COLLECT_AMT WHILE CHANGING THE RECNCT_TYPE_CD        
T29750        MOVE PARM-RECNCT-TYPE-CD       TO DL-RECNCT-TYPE-CD       
T29750        MOVE AT-ACCOUNT-NO             TO DL-ACCOUNT-NO           
T29750        MOVE AT-COMPANY-NO             TO U7-COMPANY-NO           
A37061        IF AT-ACCOUNT-TYPE-CODE  = 'R' OR 'C' OR 'I'              
A37061           MOVE AT-ACCOUNT-TYPE-CODE TO WS-ACCT-TYPE-CD           
A37061        ELSE                                                      
A37061           MOVE     'I'              TO WS-ACCT-TYPE-CD           
A37061        END-IF                                                    
T29750        PERFORM 7500-GET-RECONNECT-INFO   THRU 7500-EXIT          
T29750        MOVE U7-RCNCT-CHRG-AM          TO DL-RECNCT-COLLECT-AMT   
           END-IF.                                                      
P00726* TRANS HIST FOR RECONNECT TERM CODE                                      
P00726     IF PARM-RCNCT-TERM-ID NOT = DL-RCNCT-TERM-ID                 
P00726        ADD +1                        TO WS-TRAN-APPL-NO          
P00726        MOVE 'RECONNECT TERM ID'      TO WS-COLUMN-DESC           
P00726        MOVE DL-RCNCT-TERM-ID         TO WS-PRV-COLUMN-VALUE-TEXT 
P00726        MOVE PARM-RCNCT-TERM-ID       TO WS-CHG-COLUMN-VALUE-TEXT 
P00726        MOVE LENGTH OF WS-PRV-COLUMN-VALUE-TEXT                   
P00726                                      TO WS-PRV-COLUMN-VALUE-LEN  
P00726        MOVE LENGTH OF WS-CHG-COLUMN-VALUE-TEXT                   
P00726                                      TO WS-CHG-COLUMN-VALUE-LEN  
P00726        PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
P00726        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
P00726     END-IF.                                                      
P00726* TRANS HIST FOR LAST UPDATE USER ID                                      
P00726     IF PARM-LAST-UPDATE-USERID NOT = DL-LAST-UPDATE-USERID       
P00726        ADD +1                        TO WS-TRAN-APPL-NO          
P00726        MOVE 'LAST UPDATE USER ID'    TO WS-COLUMN-DESC           
P00726        MOVE DL-LAST-UPDATE-USERID    TO WS-PRV-COLUMN-VALUE-TEXT 
P00726        MOVE PARM-LAST-UPDATE-USERID  TO WS-CHG-COLUMN-VALUE-TEXT 
P00726        MOVE +7                       TO WS-PRV-COLUMN-VALUE-LEN  
P00726                                         WS-CHG-COLUMN-VALUE-LEN  
P00726        PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
P00726        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
P00726     END-IF.                                                      
P00726* TRANS HIST FOR RCC BILL OPTION CODE                                     
P00726     IF PARM-RCC-BILL-OPTION-CD NOT = DL-RCC-BILL-OPTION-CD       
P00726        ADD +1                        TO WS-TRAN-APPL-NO          
P00726        MOVE 'RCC BILL OPTION CD'     TO WS-COLUMN-DESC           
P0726A        MOVE 13                       TO UV-TABLE-NA-LEN          
P0726A        MOVE 'CSS_RECONNECT'          TO UV-TABLE-NA-TEXT         
P0726A        MOVE 18                       TO UV-COLUMN-NA-LEN         
P0726A        MOVE 'RCC_BILL_OPTION_CD'     TO UV-COLUMN-NA-TEXT        
P0726A        MOVE 1                        TO UV-CODE-VALUE-LEN        
P0726A        MOVE DL-RCC-BILL-OPTION-CD    TO UV-CODE-VALUE-TEXT       
P0726A        MOVE AT-COMPANY-NO            TO UV-COMPANY-NO            
P0726A        PERFORM 7100-GET-CD-VALUE     THRU 7100-EXIT              
P0726A        MOVE UV-CODE-SHORT-DESC-TEXT  TO WS-PRV-COLUMN-VALUE-TEXT 
P0726A        MOVE UV-CODE-SHORT-DESC-LEN   TO WS-PRV-COLUMN-VALUE-LEN  
P0726A        MOVE PARM-RCC-BILL-OPTION-CD  TO UV-CODE-VALUE-TEXT       
P0726A        PERFORM 7100-GET-CD-VALUE     THRU 7100-EXIT              
P0726A        MOVE UV-CODE-SHORT-DESC-TEXT  TO WS-CHG-COLUMN-VALUE-TEXT 
P0726A        MOVE UV-CODE-SHORT-DESC-LEN   TO WS-CHG-COLUMN-VALUE-LEN  
P00726        PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
P00726        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
P00726     END-IF.                                                      
      *                                                                         
           PERFORM 8200-UPDATE-RECONNECT    THRU 8200-EXIT.             
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26296*****************************************************************         
C26296* CHARGE A AUTO DEPOSIT IF THE ACCOUNT IS ELIGIBLE FOR ONE      *         
C26296*****************************************************************         
C26296 5250-PROCESS-AUTO-DEPOSIT.                                       
C26296*                                                                         
C26296     IF  PARM-AUTO-DEP-LTR-IND > SPACES                           
C26296     AND PARM-AUTO-DEP-AMT > ZEROES                               
C26296          PERFORM 5260-SET-UP-AUTO-DEP  THRU 5260-EXIT            
C26296     END-IF                                                       
C26296     IF  WS-CSR02072-SUCCESS-FL = 'Y'                             
C26296         MOVE WS-MAX-DEP-CERT-NO  TO  DL-AUTO-DEP-CERT-NO         
C26296         MOVE AT-ACCOUNT-NO       TO  DL-ACCOUNT-NO               
C26296         PERFORM 8710-UPDATE-AUTO-DEP-CERT                        
C26296            THRU 8710-EXIT                                        
C26296         IF  DL-AUTO-DEP-AM EQUAL PARM-AUTO-DEP-AMT               
C26296             CONTINUE                                             
C26296         ELSE                                                     
C26296             MOVE PARM-AUTO-DEP-AMT   TO  DL-AUTO-DEP-AM          
C26296             PERFORM 8720-UPDATE-AUTO-DEP-AM                      
C26296                THRU 8720-EXIT                                    
C26296         END-IF                                                   
C26296         IF  AUTO-DEP-AMT-CHG                                     
C26296         OR  AUTO-DEP-RECALC-CHG                                  
C26296             PERFORM 5280-WRITE-AUTO-DEP-MNT-TRANS                
C26296                THRU 5280-EXIT                                    
C26296         END-IF                                                   
C26296         IF  BILL-OPT-CHG                                         
C26296             PERFORM 5285-WRITE-BILL-OPT-MNT-TRANS                
C26296                THRU 5285-EXIT                                    
C26296         END-IF                                                   
C26296     END-IF.                                                      
C26296*                                                                         
C26296 5250-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296 5260-SET-UP-AUTO-DEP.                                            
C26296*                                                                         
C26296     INITIALIZE WS-CSR02072-INPUT-FIELDS.                         
C26296     MOVE PARM-AUTO-DEP-AMT       TO  WS-AUTO-DEP-AMT-NUM         
C26296     MOVE +12                     TO  WS-COMMENTS-LEN-NUM         
C26296     MOVE PARM-NO-SCHED-PYMTS     TO  WS-NO-SCHED-PYMTS-NUM       
C26296     PERFORM 7280-SELECT-MAX-DEP-CERT THRU 7280-EXIT              
C26296     ADD +1                       TO  WS-MAX-DEP-CERT-NO          
C26296     MOVE   'I'                   TO  WS-ACTION-CODE              
C26296     MOVE  AT-ACCOUNT-NO          TO  WS-ACCT-NO                  
C26296     MOVE  WS-AUTO-DEP-AMT-X      TO  WS-AMT-ORIG-ENTERED         
C26296     MOVE  'A'                    TO  WS-DEPOSIT-STATUS-CD        
C26296     MOVE  'U'                    TO  WS-SERVICE-TYPE-CD          
C26296     MOVE  WS-MAX-DEP-CERT-NO     TO  WS-DEPOSIT-CERT-NO          
C26296     MOVE  SPACES                 TO  WS-DEP-ACTION-CODE          
C26296     MOVE  PARM-USER-ID           TO  WS-USER-ID-UPDT-BY          
A02604     MOVE ' DNP'                  TO  WS-DEP-TYPE-TEXT            
C26296     MOVE +15                     TO  WS-DEP-TYPE-LEN             
C26296*** ADD DEP TYPE TO COMMENTS                                              
C26296     ADD   WS-DEP-TYPE-LEN        TO  WS-COMMENTS-LEN-NUM         
C26296*                                                                         
A02604     IF WS-TRANS-COMMENTS-LEN > 175                               
A02604        MOVE 175 TO WS-TRANS-COMMENTS-LEN                         
A02064     END-IF.                                                      
A02064     ADD WS-TRANS-COMMENTS-LEN TO WS-COMMENTS-LEN-NUM             
                                                                        
C26296     STRING 'AUTO DEPOSIT'     DELIMITED BY SIZE                  
C26296             WS-DEP-TYPE-TEXT  DELIMITED BY SIZE                  
A02604             WS-TRANS-COMMENTS DELIMITED BY SIZE                  
C26296     INTO WS-COMMENTS                                             
C26296****                                                                      
C26296     MOVE  WS-COMMENTS-LEN-X      TO  WS-COMMENTS-LEN             
C26296     PERFORM 5270-SET-PANEL-COMMENTS THRU 5270-EXIT               
C26296     IF  BILL-OPT-CHG OR AUTO-DEP-AMT-CHG                         
C26296         MOVE WS-PANEL-COMM-LEN-X TO  WS-PANEL-COMM-LEN           
C26296     ELSE                                                         
C26296         MOVE SPACES              TO  WS-PANEL-COMMENTS           
C26296         MOVE ZEROES              TO  WS-PANEL-COMM-LEN           
C26296     END-IF                                                       
C26296     MOVE PARM-DEP-BILL-OPT-CD    TO  WS-BILL-OPTION-CD           
C26296     MOVE WS-NO-SCHED-PYMTS-X     TO  WS-NO-SCHED-PYMTS           
C26296     MOVE PARM-MTHLY-INSTALL-AMT  TO  WS-MTHLY-INSTAL-AMT-NUM     
C26296     MOVE WS-MTHLY-INSTAL-AMT-X   TO  WS-AMT-MO-PYMT              
C26296     MOVE 'B'                     TO  WS-CODE-DEP-TYPE            
C26296     MOVE SPACES                  TO  WS-CUT-DATE                 
C26296                                      WS-PROJECT-CR-DT            
C26296                                      WS-DUE-DATE                 
C26296     MOVE 'PANEL125D'             TO  WS-PROGRAM-NAME             
C26296     MOVE SPACES                  TO  WS-LAST-UPDATE-TS           
C26296                                      WS-CODE-REFUND-ELIG.        
C26296     MOVE 'N'                      TO  WS-ERROR-SWITCH            
C26296*                                                                         
C26296     MOVE PARM-AUTO-DEP-LTR-IND    TO WS-AUTO-DEP-LETTER-IND      
C26296     MOVE PARM-NOTC-AUTO-DEP-AMT   TO WS-AUTO-DEP-NOT-AMT         
C26296     IF  PARM-AUTO-DEP-AMT EQUAL PARM-NOTC-AUTO-DEP-AMT           
C26296         MOVE ZEROES               TO WS-AUTO-DEP-RECALC-AMT      
C26296     ELSE                                                         
C26296         MOVE PARM-RECALC-AUTO-DEP-AMT TO WS-AUTO-DEP-RECALC-AMT  
C26296     END-IF                                                       
C26296     MOVE SPACES                   TO  WS-AUTO-DEP-LTR-DT         
C26296     PERFORM 8700-CALL-CSR02072    THRU 8700-EXIT.                
C26296                                                                  
C26296 5260-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* FRAMES PANEL141 COMMENTS BASED ON WHAT DEFAULT VALUES WERE     *        
C26296* CHANGED ON PANEL125.                                           *        
C26296******************************************************************        
C26296*                                                                         
C26296 5270-SET-PANEL-COMMENTS.                                         
C26296*                                                                         
C26296         IF  AT-COMPANY-NO = '26'                                 
C26296             IF  PARM-DEP-BILL-OPT-CD = 'I'                       
C26296                 CONTINUE                                         
C26296             ELSE                                                 
C26296                 MOVE 'I'         TO  WS-DEFAULT-BILL-OPT-CD      
C26296                 SET BILL-OPT-CHG TO TRUE                         
C26296             END-IF                                               
C26296         ELSE                                                     
C26296             IF  AT-COMPANY-NO = '01'                             
C26296                 IF  PARM-DEP-BILL-OPT-CD = 'N'                   
C26296                     CONTINUE                                     
C26296                 ELSE                                             
C26296                     MOVE 'N'     TO  WS-DEFAULT-BILL-OPT-CD      
C26296                     SET BILL-OPT-CHG TO TRUE                     
C26296                 END-IF                                           
C26296             END-IF                                               
C26296         END-IF.                                                  
C26296*                                                                         
C26296     IF  PARM-AUTO-DEP-AMT NOT EQUAL PARM-RECALC-AUTO-DEP-AMT     
C26296     AND PARM-AUTO-DEP-AMT NOT EQUAL PARM-NOTC-AUTO-DEP-AMT       
C26296         SET AUTO-DEP-AMT-CHG     TO TRUE                         
C26296         IF  PARM-NOTC-AUTO-DEP-AMT <= PARM-RECALC-AUTO-DEP-AMT   
C26296             MOVE PARM-NOTC-AUTO-DEP-AMT                          
C26296                                  TO WS-DEFAULT-AUTO-DEP-AMT      
C26296         ELSE                                                     
C26296             MOVE PARM-RECALC-AUTO-DEP-AMT                        
C26296                                  TO WS-DEFAULT-AUTO-DEP-AMT      
C26296         END-IF                                                   
C26296     ELSE                                                         
C26296         IF  PARM-NOTC-AUTO-DEP-AMT EQUAL PARM-RECALC-AUTO-DEP-AMT
C26296             CONTINUE                                             
C26296         ELSE                                                     
C26296             SET AUTO-DEP-RECALC-CHG TO TRUE                      
C26296         END-IF                                                   
C26296     END-IF                                                       
C26296*                                                                         
C26296     IF  BILL-OPT-CHG                                             
C26296         IF  WS-DEFAULT-BILL-OPT-CD = 'N'                         
C26296             MOVE 'NEXT BILL;'     TO  WS-PANL-CMNTS-BILL-OPT1    
C26296             ADD +9                TO  WS-PANEL-COMM-LEN-NUM      
C26296         ELSE                                                     
C26296             IF  WS-DEFAULT-BILL-OPT-CD = 'I'                     
C26296                 MOVE 'IMMED;'     TO  WS-PANL-CMNTS-BILL-OPT1    
C26296                 ADD +5            TO  WS-PANEL-COMM-LEN-NUM      
C26296             END-IF                                               
C26296         END-IF                                                   
C26296         EVALUATE PARM-DEP-BILL-OPT-CD                            
C26296             WHEN 'N'                                             
C26296                 MOVE 'NEXT BILL;' TO  WS-PANL-CMNTS-BILL-OPT2    
C26296                 ADD +9            TO  WS-PANEL-COMM-LEN-NUM      
C26296             WHEN 'I'                                             
C26296                 MOVE 'IMMED;'     TO  WS-PANL-CMNTS-BILL-OPT2    
C26296                 ADD +5           TO  WS-PANEL-COMM-LEN-NUM       
C26296             WHEN 'T'                                             
C26296                 MOVE PARM-NO-SCHED-PYMTS TO                      
C26296                                       WS-INSTALL-CMNTS-NO        
C26296                 STRING ' '                 DELIMITED BY SIZE     
C26296                        WS-INSTALL-CMNTS-NO DELIMITED BY SIZE     
C26296                       ' INSTALLMENTS;' DELIMITED BY SIZE         
C26296                  INTO  WS-PANL-CMNTS-BILL-OPT2                   
C26296                       ADD +16          TO  WS-PANEL-COMM-LEN-NUM 
C26296         END-EVALUATE                                             
C26296         STRING WS-PANL-CMNTS-BILL-OPT1 DELIMITED BY ';'          
C26296                ' TO '                  DELIMITED BY ';'          
C26296                WS-PANL-CMNTS-BILL-OPT2 DELIMITED BY ';'          
C26296                ';'                     DELIMITED BY SIZE         
C26296           INTO WS-PANL-CMNTS-BILL-OPT                            
C26296         ADD +4                   TO WS-PANEL-COMM-LEN-NUM        
C26296     END-IF                                                       
C26296*                                                                         
C26296**** AUTO DEP AMT WAS CHANGED                                             
C26296     IF  AUTO-DEP-AMT-CHG                                         
C26296         MOVE PARM-AUTO-DEP-AMT   TO  WS-AUTO-DEP-AMT-Z           
C26296         MOVE WS-DEFAULT-AUTO-DEP-AMT                             
C26296                                  TO  WS-DEFAULT-AUTO-DEP-AMT-X   
C26296                                                                  
C26296         STRING  'AUTO DEP ' DELIMITED BY SIZE                    
C26296                 WS-DEFAULT-AUTO-DEP-AMT-X DELIMITED BY SIZE      
C26296                 ' TO '                    DELIMITED BY SIZE      
C26296                 WS-AUTO-DEP-AMT-Z         DELIMITED BY SIZE      
C26296           INTO  WS-PANL-CMNTS-AUTO-DEP-AM                        
C26296         ADD +25                  TO  WS-PANEL-COMM-LEN-NUM       
C26296     END-IF                                                       
C26296*                                                                         
C26296**** STRING ALL THE INDIVIDUAL COMMENTS TO FORM THE PANEL141              
C26296**** COMMENTS FIELD THAT IS STORED IN CSS_DEP_ON_HAND                     
C26296*                                                                         
C26296     EVALUATE TRUE ALSO TRUE                                      
C26296*------      WHEN BILL OPTION AND AUTO DEP AMT IS CHANGED                 
C26296         WHEN BILL-OPT-CHG ALSO AUTO-DEP-AMT-CHG                  
C26296             ADD +1               TO  WS-PANEL-COMM-LEN-NUM       
C26296             STRING WS-PANL-CMNTS-BILL-OPT    DELIMITED BY ';'    
C26296                    ';'                       DELIMITED BY SIZE   
C26296                    WS-PANL-CMNTS-AUTO-DEP-AM DELIMITED BY SIZE   
C26296               INTO WS-PANEL-COMMENTS                             
                                                                        
C26296*-------    WHEN BILL OPTION IS CHANGED                                   
C26296         WHEN BILL-OPT-CHG ALSO TRUE                              
C26296             MOVE WS-PANL-CMNTS-BILL-OPT    TO WS-PANEL-COMMENTS  
                                                                        
C26296*-------    WHEN AUTO DEP AMT IS CHANGED                                  
C26296         WHEN AUTO-DEP-AMT-CHG ALSO TRUE                          
C26296             MOVE WS-PANL-CMNTS-AUTO-DEP-AM TO WS-PANEL-COMMENTS  
C26296     END-EVALUATE.                                                
C26296*                                                                         
C26296 5270-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* WRITES MAINT TRANS DET ROW FOR AUTO DEP AMT                    *        
C26296******************************************************************        
C26296*                                                                         
C26296 5280-WRITE-AUTO-DEP-MNT-TRANS.                                   
C26296*                                                                         
C26296     IF  PARM-NOTC-AUTO-DEP-AMT > PARM-RECALC-AUTO-DEP-AMT        
C26296         ADD +1                       TO WS-TRAN-APPL-NO          
C26296         MOVE 'AUTO DEP AMT'          TO WS-COLUMN-DESC           
C26296         MOVE 15                      TO WS-CHG-COLUMN-VALUE-LEN  
C26296         MOVE PARM-RECALC-AUTO-DEP-AMT TO WS-AUTO-DEP-AMT-ED      
C26296         MOVE WS-AUTO-DEP-AMT-ED      TO WS-CHG-COLUMN-VALUE-TEXT 
C26296         MOVE 15                      TO WS-PRV-COLUMN-VALUE-LEN  
C26296         MOVE PARM-NOTC-AUTO-DEP-AMT  TO WS-AUTO-DEP-AMT-ED       
C26296         MOVE WS-AUTO-DEP-AMT-ED      TO WS-PRV-COLUMN-VALUE-TEXT 
C26296                                                                  
C26296         PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
C26296         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
C26296         IF  PARM-AUTO-DEP-AMT EQUAL PARM-RECALC-AUTO-DEP-AMT     
C26296             CONTINUE                                             
C26296         ELSE                                                     
C26296             ADD +1                   TO WS-TRAN-APPL-NO          
C26296             MOVE 'AUTO DEP AMT'      TO WS-COLUMN-DESC           
C26296             MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
C26296             MOVE PARM-AUTO-DEP-AMT   TO WS-AUTO-DEP-AMT-ED       
C26296             MOVE WS-AUTO-DEP-AMT-ED  TO WS-CHG-COLUMN-VALUE-TEXT 
C26296             MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
C26296             MOVE PARM-RECALC-AUTO-DEP-AMT                        
C26296                                      TO WS-AUTO-DEP-AMT-ED       
C26296             MOVE WS-AUTO-DEP-AMT-ED  TO WS-PRV-COLUMN-VALUE-TEXT 
C26296                                                                  
C26296             PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT       
C26296             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
C26296         END-IF                                                   
C26296     ELSE                                                         
C26296         IF  PARM-AUTO-DEP-AMT EQUAL PARM-NOTC-AUTO-DEP-AMT       
C26296             CONTINUE                                             
C26296         ELSE                                                     
C26296             ADD +1                   TO WS-TRAN-APPL-NO          
C26296             MOVE 'AUTO DEP AMT'      TO WS-COLUMN-DESC           
C26296             MOVE 15                  TO WS-CHG-COLUMN-VALUE-LEN  
C26296             MOVE PARM-AUTO-DEP-AMT   TO WS-AUTO-DEP-AMT-ED       
C26296             MOVE WS-AUTO-DEP-AMT-ED  TO WS-CHG-COLUMN-VALUE-TEXT 
C26296             MOVE 15                  TO WS-PRV-COLUMN-VALUE-LEN  
C26296             MOVE PARM-NOTC-AUTO-DEP-AMT                          
C26296                                      TO WS-AUTO-DEP-AMT-ED       
C26296             MOVE WS-AUTO-DEP-AMT-ED  TO WS-PRV-COLUMN-VALUE-TEXT 
C26296                                                                  
C26296             PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT       
C26296             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
C26296         END-IF                                                   
C26296     END-IF.                                                      
C26296*                                                                         
C26296 5280-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296 5285-WRITE-BILL-OPT-MNT-TRANS.                                   
C26296*                                                                         
C26296     IF  PARM-NO-SCHED-PYMTS > 1                                  
C26296         MOVE '1'                 TO WS-PRV-COLUMN-VALUE-TEXT     
C26296         MOVE +1                  TO WS-PRV-COLUMN-VALUE-LEN      
C26296         MOVE WS-INSTALL-CMNTS-NO TO WS-CHG-COLUMN-VALUE-TEXT     
C26296         MOVE +2                  TO WS-CHG-COLUMN-VALUE-LEN      
C26296         MOVE 'INSTALLMENTS'      TO WS-COLUMN-DESC               
C26296         ADD +1                   TO WS-TRAN-APPL-NO              
C26296         PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT          
C26296         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
C26296*        GO  TO 5285-EXIT                                                 
C26296     END-IF.                                                      
C26296*                                                                         
C26296     IF WS-DEFAULT-BILL-OPT-CD NOT EQUAL PARM-DEP-BILL-OPT-CD     
C26296        IF PARM-DEP-BILL-OPT-CD EQUAL SPACES                      
C26296           MOVE '*DELETED*'     TO WS-CHG-COLUMN-VALUE-TEXT       
C26296           MOVE +9              TO WS-CHG-COLUMN-VALUE-LEN        
C26296        ELSE                                                      
C26296           EVALUATE TRUE                                          
C26296             WHEN PARM-DEP-BILL-OPT-CD = 'N'                      
C26296               MOVE 'NEXT BILLING'                                
C26296                                TO WS-CHG-COLUMN-VALUE-TEXT       
C26296               MOVE +12         TO WS-CHG-COLUMN-VALUE-LEN        
C26296             WHEN PARM-DEP-BILL-OPT-CD = 'I'                      
C26296               MOVE 'IMMEDIATELY'                                 
C26296                                TO WS-CHG-COLUMN-VALUE-TEXT       
C26296               MOVE +11         TO WS-CHG-COLUMN-VALUE-LEN        
C26296             WHEN PARM-DEP-BILL-OPT-CD = 'T'                      
C26296               MOVE 'INSTALLMENTS'                                
C26296                                TO WS-CHG-COLUMN-VALUE-TEXT       
C26296               MOVE +12         TO WS-CHG-COLUMN-VALUE-LEN        
C26296           END-EVALUATE                                           
C26296        END-IF                                                    
C26296        IF WS-DEFAULT-BILL-OPT-CD EQUAL SPACES                    
C26296           MOVE '*NEW*'         TO WS-PRV-COLUMN-VALUE-TEXT       
C26296           MOVE +5              TO WS-PRV-COLUMN-VALUE-LEN        
C26296        ELSE                                                      
C26296           EVALUATE TRUE                                          
C26296             WHEN WS-DEFAULT-BILL-OPT-CD = 'N'                    
C26296               MOVE 'NEXT BILLING'                                
C26296                                TO WS-PRV-COLUMN-VALUE-TEXT       
C26296               MOVE +12         TO WS-PRV-COLUMN-VALUE-LEN        
C26296             WHEN WS-DEFAULT-BILL-OPT-CD = 'I'                    
C26296               MOVE 'IMMEDIATELY'                                 
C26296                                TO WS-PRV-COLUMN-VALUE-TEXT       
C26296               MOVE +11         TO WS-PRV-COLUMN-VALUE-LEN        
C26296             WHEN WS-DEFAULT-BILL-OPT-CD = 'T'                    
C26296               MOVE 'INSTALLMENTS'                                
C26296                                TO WS-PRV-COLUMN-VALUE-TEXT       
C26296               MOVE +12         TO WS-PRV-COLUMN-VALUE-LEN        
C26296           END-EVALUATE                                           
C26296        END-IF                                                    
C26296        MOVE 'BILLING OPTION'         TO WS-COLUMN-DESC           
C26296        ADD +1                        TO WS-TRAN-APPL-NO          
C26296        PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
C26296        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
C26296     END-IF.                                                      
C26296*                                                                         
C26296 5285-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* THIS CHECKS IF THE USER CHANGES THE AUTO DEP AMT TO ZERO       *        
C26296* AND WRITES MAINT TRANS ROWS SHOWING THE CHANGED VALUES.        *        
C26296******************************************************************        
C26296 5290-CHECK-RECONN-AUTO-DEP.                                      
C26296*                                                                         
C26296*    IF  PARM-AUTO-DEP-AMT  EQUAL ZEROES                                  
C26296*    AND DL-AUTO-DEP-AM NOT EQUAL ZEROES                                  
C26296     IF  PARM-AUTO-DEP-AMT NOT EQUAL DL-AUTO-DEP-AM               
C26296         PERFORM 5280-WRITE-AUTO-DEP-MNT-TRANS                    
C26296            THRU 5280-EXIT                                        
C26296         MOVE PARM-AUTO-DEP-AMT TO DL-AUTO-DEP-AM                 
C26296         PERFORM 8720-UPDATE-AUTO-DEP-AM                          
C26296            THRU 8720-EXIT                                        
C26296     END-IF.                                                      
C26296*                                                                         
C26296 5290-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
      ******************************************************************        
      * 5300 DELETES RECONNECT.                                        *        
      *                                                                *        
      *     -- THIS MODULES DELETE FROM CSS_RECONNECT AND DOES THE     *        
      *        MAINTAINENCE JOURNALING ROUTINE.                        *        
      *                                                                *        
      ******************************************************************        
       5300-DELETE-RECONNECT.                                           
           MOVE '5300'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE '*DELETED*'                 TO WS-CHG-COLUMN-VALUE-TEXT.
           MOVE 9                           TO WS-CHG-COLUMN-VALUE-LEN. 
      *                                                                         
           IF DL-AGREEMENT-COMMENTS > SPACES                            
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'AGRMT COMMENTS'         TO WS-COLUMN-DESC           
              MOVE 26                       TO WS-PRV-COLUMN-VALUE-LEN  
              MOVE PARM-AGREEMENT-COMMENTS  TO WS-PRV-COLUMN-VALUE-TEXT 
                                               DL-AGREEMENT-COMMENTS    
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF DL-AMT-TOT-RECONNECT > 0                                  
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'AGRMT TO COLLCT'        TO WS-COLUMN-DESC           
              MOVE 15                       TO WS-PRV-COLUMN-VALUE-LEN  
                                                                        
              MOVE WS-AMT-TOT-RECONNECT-COMP3 TO DL-AMT-TOT-RECONNECT   
                                               WS-TOT-RECNCT-NUM        
              MOVE WS-TOT-RECNCT-NUM        TO WS-TOT-RECNCT-EDT        
              MOVE WS-TOT-RECNCT-EDT        TO WS-PRV-COLUMN-VALUE-TEXT 
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF DL-RECNCT-COLLECT-AMT > 0                                 
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'RCC TO COLLECT'         TO WS-COLUMN-DESC           
              MOVE 15                       TO WS-PRV-COLUMN-VALUE-LEN  
                                                                        
              MOVE WS-RCNCT-COLLECT-AMT-COMP3 TO DL-RECNCT-COLLECT-AMT  
                                               WS-RECNCT-COLLCT-NUM     
              MOVE WS-RECNCT-COLLCT-NUM     TO WS-RECNCT-COLLCT-EDT     
              MOVE WS-RECNCT-COLLCT-EDT     TO WS-PRV-COLUMN-VALUE-TEXT 
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF DL-RECNCT-TYPE-CD > SPACES                                
TP8830        MOVE 'U7'                     TO WS-TABLE-ID              
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'RCC TYPE'               TO WS-COLUMN-DESC           
              MOVE 3                        TO WS-PRV-COLUMN-VALUE-LEN  
              MOVE PARM-RECNCT-TYPE-CD      TO WS-PRV-COLUMN-VALUE-TEXT 
                                               DL-RECNCT-TYPE-CD        
                                                                        
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
TP8830        MOVE SPACES                   TO WS-TABLE-ID              
           END-IF.                                                      
      *                                                                         
           PERFORM 8300-DELETE-RECONNECT    THRU 8300-EXIT.             
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
C26296*                                                                         
C26296                                                                  
C26296******************************************************************        
C26296* 5350 UPDATE RECALC.                                            *        
C26296*                                                                *        
C26296*     -- THIS MODULES UPDATES    CSS_RECONNECT AND DOESTHE       *        
C26296*        MAINTAINENCE JOURNALING ROUTINE WHEN THE AUTO DEP AMT   *        
C26296*        IS RECALCULATED BY THE RETRIEVE.                        *        
C26296******************************************************************        
C26296 5350-UPDATE-RECALC.                                              
C26296*                                                                         
C26296     MOVE '5350'                      TO ACTIVE-PARAGRAPH.        
C26296*                                                                         
C26296     MOVE 'SYSTEM'                    TO WS-USERID                
C26296                                         DL-USER-ID               
C26296     MOVE SPACES                      TO PF-RESP-AREA-ID          
C26296     IF PARM-RECALC-AUTO-DEP-AMT NOT = DL-AUTO-DEP-AM             
C26296        COMPUTE WS-RECALC-DIFF =                                  
C26296                DL-AUTO-DEP-AM - PARM-RECALC-AUTO-DEP-AMT         
C26296        ADD +1                        TO WS-TRAN-APPL-NO          
C26296        MOVE 'AUTO DEP AMT'           TO WS-COLUMN-DESC           
C26296        MOVE DL-AUTO-DEP-AM           TO WS-AUTO-DEP-AMT-ED       
C26296                                                                  
C26296        MOVE WS-AUTO-DEP-AMT-ED       TO WS-PRV-COLUMN-VALUE-TEXT 
C26296                                                                  
C26296        MOVE 15                       TO WS-PRV-COLUMN-VALUE-LEN  
C26296                                         WS-CHG-COLUMN-VALUE-LEN  
C26296                                                                  
C26296        MOVE PARM-RECALC-AUTO-DEP-AMT TO DL-AUTO-DEP-AM           
C26296                                         WS-AUTO-DEP-AMT-ED       
C26296        MOVE WS-AUTO-DEP-AMT-ED       TO WS-CHG-COLUMN-VALUE-TEXT 
C26296                                                                  
C26296        PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
C26296        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
C26296* SUBTRACT THE DIFFERENCE OF RECALC FROM AMT-TOT-RECONECT                 
C26296        ADD +1                        TO WS-TRAN-APPL-NO          
C26296        MOVE 'AGRMT TO COLLCT'        TO WS-COLUMN-DESC           
C26296        MOVE DL-AMT-TOT-RECONNECT     TO WS-TOT-RECNCT-NUM        
C26296                                                                  
C26296        MOVE WS-TOT-RECNCT-NUM        TO WS-TOT-RECNCT-EDT        
C26296        MOVE WS-TOT-RECNCT-EDT        TO WS-PRV-COLUMN-VALUE-TEXT 
C26296                                                                  
C26296        MOVE 15                       TO WS-PRV-COLUMN-VALUE-LEN  
C26296                                         WS-CHG-COLUMN-VALUE-LEN  
C26296        SUBTRACT WS-RECALC-DIFF FROM DL-AMT-TOT-RECONNECT         
C26296        IF  DL-AMT-TOT-RECONNECT < ZEROES                         
C26296            MOVE ZEROES               TO DL-AMT-TOT-RECONNECT     
C26296        END-IF                                                    
C26296        IF  DL-AMT-TOT-RECONNECT = ZEROS                          
C26296            MOVE 'Y'                  TO WS-RECNCT-AMT-ZERO-UPDT  
C26296        END-IF                                                    
C26296        MOVE DL-AMT-TOT-RECONNECT     TO WS-TOT-RECNCT-NUM        
C26296                                                                  
C26296        MOVE WS-TOT-RECNCT-NUM        TO WS-TOT-RECNCT-EDT        
C26296        MOVE WS-TOT-RECNCT-EDT        TO WS-CHG-COLUMN-VALUE-TEXT 
C26296                                                                  
C26296        PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
C26296        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
C26296     END-IF.                                                      
C26296*                                                                         
C26296     PERFORM 8250-UPDATE-RECAL-RECONNCT  THRU 8250-EXIT.          
C26296*                                                                         
C26296 5350-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
      ******************************************************************        
      * 5950 SET MNT TRANS VARS                                        *        
      *      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *        
      *         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *        
      *         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *        
      *         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *        
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
      ******************************************************************        
       5950-SET-MNT-TRANS-VARS.                                         
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO-NUM           TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-USERID                   TO MH-USER-ID.              
      *                                                                         
T18187     IF WS-TRANS-COMMENTS = 'RECONNECT ORDER CANCELED'            
T18187        MOVE 'PANEL016A'              TO MH-APPL-PROGRAM-ID       
T18187     ELSE                                                         
              MOVE WS-PANEL-NO              TO MH-APPL-PROGRAM-ID       
T18187     END-IF.                                                      
      *                                                                         
           IF WS-TRANS-COMMENTS-LEN > 0                                 
              MOVE WS-TRANS-COMMENTS        TO MH-TRAN-COMMENT-TEXT     
              MOVE WS-TRANS-COMMENTS-LEN    TO MH-TRAN-COMMENT-LEN      
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE 0                        TO MH-TRAN-COMMENT-LEN      
           END-IF                                                       
      *                                                                         
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00067                                                 
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      * 7000-GET-CURRENT-DATE                                          *        
      *      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
CBSI          MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
CBSI          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT
           END-IF.               
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010 ACCEPT TIMESTAMP                                          *        
      *      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
       7010-ACCEPT-TIMESTAMP.                                           
           MOVE '7010'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
CBSI          MOVE 'SET'                    TO ABEND-FUNCTION           
CBSI          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7020-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
               SELECT CODES_DATA_PRESENT,                               
T29750                COMPANY_NO                                        
A37061                ,ACCOUNT_TYPE_CODE                                
P0726B                ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
               INTO   :AT-CODES-DATA-PRESENT,                           
T29750                :AT-COMPANY-NO                                    
A37061                ,:AT-ACCOUNT-TYPE-CODE                            
P0726B                ,:AT-LAST-UPDATE-TS                               
               FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODES_DATA_PRESENT,                                       
MFA-TR*               COMPANY_NO                                                
MFA-TR*               ,ACCOUNT_TYPE_CODE                                        
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*        INTO   :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-COMPANY-NO                                            
MFA-TR*               ,:AT-ACCOUNT-TYPE-CODE                                    
MFA-TR*               ,:AT-LAST-UPDATE-TS                                       
MFA-TR*        FROM   CSS_ACCOUNT                                               
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030 GET RESP AREA ID                                          *        
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
       7030-GET-RESP-AREA-ID.                                           
           MOVE '7030'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-USERID                   TO PF-USER-ID.              
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :PF-USER-ID                             
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :PF-USER-ID                                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
CBSI          MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
CBSI          MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE WS-USERID                TO HOSTVAR-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
CBSI          MOVE PARM-ACCOUNT-NO          TO HOSTVAR-ELEMENT-2        
              MOVE 'GET RESP AREA ID - 7030' TO RS-RETURN-MESSAGE       
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040 GET AR CNTL                                               *        
      *      -- THIS MODULE SETS SWITCH IF PYMT PRIORITY LVL 060 (RCC) *        
      *         IS FOUND               .                               *        
      ******************************************************************        
T19270 7040-SELECT-AR-CNTL.                                             
           MOVE '7040'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE 'N'                         TO RCC-AR-ROW-EXISTS-SW.    
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT 'Y'                                      
                 INTO :RCC-AR-ROW-EXISTS-SW                             
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE PYMT_PRIORITY_LVL = 60                            
                  AND ACCOUNT_NO        = :AT-ACCOUNT-NO                
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT 'Y'                                              
MFA-TR*          INTO :RCC-AR-ROW-EXISTS-SW                                     
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE PYMT_PRIORITY_LVL = 60                                    
MFA-TR*           AND ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_CNTL '           TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'SELECT AR CNTL   - 7040' TO RS-RETURN-MESSAGE       
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0726A******************************************************************        
P0726A* 7100-GET-CD-VALUE.                                             *        
P0726A******************************************************************        
P0726A*                                                                         
P0726A 7100-GET-CD-VALUE.                                               
P0726A*                                                                         
P0726A     EXEC SQL                                                     
P0726A        SELECT                                                    
P0726A               UV.CODE_SHORT_DESC                                 
P0726A          INTO                                                    
P0726A               :UV-CODE-SHORT-DESC                                
P0726A          FROM                                                    
P0726A               CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                    
P0726A         WHERE                                                    
P0726A               UV.COLUMN_NA   = :UV-COLUMN-NA                     
P0726A           AND UV.TABLE_NA    = :UV-TABLE-NA                      
P0726A           AND UV.CODE_VALUE  = :UV-CODE-VALUE                    
P0726A           AND UV.COMPANY_NO  = :UV-COMPANY-NO                    
P0726A           AND UV.PROGRAM_ID  = 'ALL'                             
P0726A                                                           
P0726A                                                      
P0726A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              UV.CODE_SHORT_DESC                                         
MFA-TR*         INTO                                                            
MFA-TR*              :UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CODE_VALUE UV                                          
MFA-TR*        WHERE                                                            
MFA-TR*              UV.COLUMN_NA   = :UV-COLUMN-NA                             
MFA-TR*          AND UV.TABLE_NA    = :UV-TABLE-NA                              
MFA-TR*          AND UV.CODE_VALUE  = :UV-CODE-VALUE                            
MFA-TR*          AND UV.COMPANY_NO  = :UV-COMPANY-NO                            
MFA-TR*          AND UV.PROGRAM_ID  = 'ALL'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726A*                                                                         
P0726A     MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
P0726A*                                                                         
P0726A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0726A        CONTINUE                                                  
P0726A     ELSE                                                         
P0726A        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
P0726A        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
P0726A        MOVE '7100'                       TO ACTIVE-PARAGRAPH     
P0726A        MOVE 'SELECT'                     TO ABEND-FUNCTION       
P0726A        MOVE 'CSS_CODE_VALUE'             TO TABLE-1              
P0726A        MOVE 'CODE_VALUE'                 TO TABLE-ELEMENT-1      
P0726A        MOVE UV-CODE-VALUE                TO HOSTVAR-ELEMENT-1    
P0726A        MOVE 'COLUMN_NA'                  TO TABLE-ELEMENT-2      
P0726A        MOVE UV-COLUMN-NA                 TO HOSTVAR-ELEMENT-2    
P0726A        MOVE 'SELECT CODE VALUE- 7100' TO RS-RETURN-MESSAGE       
P0726A        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P0726A        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P0726A     END-IF.                                                      
P0726A*                                                                         
P0726A 7100-EXIT.                                                       
P0726A     EXIT.                                                        
      *                                                                         
C26296*                                                                         
C26296******************************************************************        
C26296* 7280-SELECT-MAX-DEP-CERT.                                      *        
C26296******************************************************************        
C26296*                                                                         
C26296 7280-SELECT-MAX-DEP-CERT.                                        
C26296                                                                  
C26296     EXEC SQL                                                     
C26296        SELECT MAX(DEPOSIT_CERT_NO)                               
C26296        INTO  :WS-MAX-DEP-CERT-NO :WS-NULL-IND4                    
C26296        FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
C26296        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
A37061                                                           
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(DEPOSIT_CERT_NO)                                       
MFA-TR*       INTO  :WS-MAX-DEP-CERT-NO:WS-NULL-IND4                            
MFA-TR*       FROM   CSS_DEP_ON_HAND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C26296         IF  WS-NULL-IND4 < ZEROS                                 
C26296             MOVE ZEROS     TO WS-NULL-IND4                       
C26296                               WS-MAX-DEP-CERT-NO                 
C26296         END-IF                                                   
C26296     ELSE                                                         
C26296        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
C26296        MOVE '7280'          TO ACTIVE-PARAGRAPH                  
C26296        MOVE 'SELECT'             TO ABEND-FUNCTION               
C26296        MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
C26296        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C26296        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
C26296        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C26296        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C26296     END-IF.                                                      
C26296*                                                                         
C26296 7280-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
T29750***************************************************************** 17003000
T29750* 7500-GET-RECONNECT-INFO                                       * 17004000
T29750*                                                               * 17005000
T29750* THIS PARAGRAPH SELECTS THE RECONNECT TYPE, AMOUNT AND OTHER   * 17006000
T29750* CODES PERTINENT TO THE RECONNECT ORDER.                       * 17007000
T29750*                                                               * 17007200
T29750***************************************************************** 17008000
T29750 7500-GET-RECONNECT-INFO.                                         
T29750                                                                  
T29750     EXEC SQL                                                     
T29750         SELECT U7.RCNCT_CHRG_AM                                  
T29750           INTO :U7-RCNCT-CHRG-AM                                 
T29750           FROM CSS_RECONNECT_CHRG U7 WITH(READUNCOMMITTED),              
T29750                CSS_RECONNECT      DL WITH(READUNCOMMITTED)               
T29750          WHERE DL.ACCOUNT_NO          = :DL-ACCOUNT-NO           
T29750            AND U7.COMPANY_NO          = :U7-COMPANY-NO           
T29750            AND U7.RCNCT_TYPE_NO       = :DL-RECNCT-TYPE-CD       
T29750            AND U7.RCNCT_ACCT_TYPE_CD  = :WS-ACCT-TYPE-CD         
A37061                                                           
T29750     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17009200
MFA-TR*        SELECT U7.RCNCT_CHRG_AM                                  17009400
MFA-TR*          INTO :U7-RCNCT-CHRG-AM                                 17009900
MFA-TR*          FROM CSS_RECONNECT_CHRG U7,                            17010300
MFA-TR*               CSS_RECONNECT      DL                             17010400
MFA-TR*         WHERE DL.ACCOUNT_NO          = :DL-ACCOUNT-NO           17010500
MFA-TR*           AND U7.COMPANY_NO          = :U7-COMPANY-NO           17010600
MFA-TR*           AND U7.RCNCT_TYPE_NO       = :DL-RECNCT-TYPE-CD       17010700
MFA-TR*           AND U7.RCNCT_ACCT_TYPE_CD  = :WS-ACCT-TYPE-CD         17010700
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    17010800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29750                                                                  
T29750     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T29750                                                                  
T29750     EVALUATE WS-ACTIVE-RETURN-CODE                               
T29750        WHEN SUCCESSFUL-CALL                                      
T29750           CONTINUE                                               
T29750        WHEN OTHER                                                
T29750           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
T29750           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
T29750           MOVE 'SELECT'              TO ABEND-FUNCTION           
T29750                                         RS-RETURN-MESSAGE        
T29750           MOVE SPACES                TO ABEND-SQL-PREDICATES     
T29750                                         ABEND-TABLES             
T29750           MOVE '7500'                  TO ACTIVE-PARAGRAPH       
T29750           MOVE 'CSS_RECONNECT_CHRG'    TO TABLE-1                
T29750           MOVE 'CSS_RECONNECT'         TO TABLE-2                
T29750           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
T29750           MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2        
T29750           MOVE DL-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
T29750           MOVE U7-COMPANY-NO           TO HOSTVAR-ELEMENT-2      
T29750           MOVE 'SELECT CSS_RECONNECT  SEL -7500'                 
T29750                                      TO RS-RETURN-MESSAGE        
T29750           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
T29750           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
T29750     END-EVALUATE.                                                
T29750                                                                  
T29750 7500-EXIT.                                                       
T29750     EXIT.                                                        
T29750                                                                  
       8000-SELECT-RECONNECT.                                           
           MOVE '8000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                SELECT AGREEMENT_COMMENTS,                              
                       AMT_TOT_RECONNECT,                               
                       DATETIME_SETUP,                                  
                       RECNCT_COLLECT_AMT,                              
                       RECNCT_TYPE_CD,                                  
                       USER_ID                                          
C26296                ,AUTO_DEP_AM                                      
C26296                ,AUTO_DEP_CERT_NO                                 
P00726                ,RCNCT_TERM_ID                                    
P00726                ,LAST_UPDATE_USERID                               
P00726                ,RCC_BILL_OPTION_CD                               
                  INTO :DL-AGREEMENT-COMMENTS,                          
                       :DL-AMT-TOT-RECONNECT,                           
                       :DL-DATETIME-SETUP :WS-DL-NULL-IND-1,             
                       :DL-RECNCT-COLLECT-AMT,                          
                       :DL-RECNCT-TYPE-CD,                              
                       :DL-USER-ID                                      
C26296                ,:DL-AUTO-DEP-AM,                                 
C26296                 :DL-AUTO-DEP-CERT-NO                             
P00726                ,:DL-RCNCT-TERM-ID :WS-RCNCT-TERM-ID-NULL         
P00726                ,:DL-LAST-UPDATE-USERID                           
P00726                ,:DL-RCC-BILL-OPTION-CD                           
                  FROM CSS_RECONNECT WITH(READUNCOMMITTED)                      
                 WHERE ACCOUNT_NO   =  :DL-ACCOUNT-NO                   
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AGREEMENT_COMMENTS,                                      
MFA-TR*                AMT_TOT_RECONNECT,                                       
MFA-TR*                DATETIME_SETUP,                                          
MFA-TR*                RECNCT_COLLECT_AMT,                                      
MFA-TR*                RECNCT_TYPE_CD,                                          
MFA-TR*                USER_ID                                                  
MFA-TR*               ,AUTO_DEP_AM                                              
MFA-TR*               ,AUTO_DEP_CERT_NO                                         
MFA-TR*               ,RCNCT_TERM_ID                                            
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*               ,RCC_BILL_OPTION_CD                                       
MFA-TR*           INTO :DL-AGREEMENT-COMMENTS,                                  
MFA-TR*                :DL-AMT-TOT-RECONNECT,                                   
MFA-TR*                :DL-DATETIME-SETUP:WS-DL-NULL-IND-1,                     
MFA-TR*                :DL-RECNCT-COLLECT-AMT,                                  
MFA-TR*                :DL-RECNCT-TYPE-CD,                                      
MFA-TR*                :DL-USER-ID                                              
MFA-TR*               ,:DL-AUTO-DEP-AM,                                         
MFA-TR*                :DL-AUTO-DEP-CERT-NO                                     
MFA-TR*               ,:DL-RCNCT-TERM-ID :WS-RCNCT-TERM-ID-NULL                 
MFA-TR*               ,:DL-LAST-UPDATE-USERID                                   
MFA-TR*               ,:DL-RCC-BILL-OPTION-CD                                   
MFA-TR*           FROM CSS_RECONNECT                                            
MFA-TR*          WHERE ACCOUNT_NO   =  :DL-ACCOUNT-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
                                    OR NOT-FOUND                        
P00726        IF WS-RCNCT-TERM-ID-NULL < 0                              
P00726           MOVE 0                     TO DL-RCNCT-TERM-ID         
P00726                                         WS-RCNCT-TERM-ID-NULL    
P00726        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
                                               RS-RETURN-MESSAGE        
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RECONNECT'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'SELECT CSS_RECONNECT  UPD OR DEL -8000'             
                                            TO RS-RETURN-MESSAGE        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-RECONNECT.                                         *        
      *       -- THIS MODULE UPDATES CSS_RECONNECT.                    *        
      ******************************************************************        
       8010-INSERT-RECONNECT.                                           
           MOVE '8010'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_RECONNECT                               
                       (ACCOUNT_NO,                                     
                        AGREEMENT_COMMENTS,                             
                        AMT_TOT_RECONNECT,                              
                        DATETIME_SETUP,                                 
                        RECNCT_COLLECT_AMT,                             
                        RECNCT_TYPE_CD,                                 
                        RECNCT_NRML_HR_IND,                             
                        USER_ID)                                        
                VALUES                                                  
                      (:DL-ACCOUNT-NO,                                  
                       :DL-AGREEMENT-COMMENTS,                          
                       :DL-AMT-TOT-RECONNECT,                           
                       IIF(TRY_CONVERT(DATE, :DL-DATETIME-SETUP 
                                             :WS-DL-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ) <> 0) OR (LEN(:DL-DATETIME-SETUP :WS-DL-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ), CONVERT(DATE, :DL-DATETIME-SETUP :WS-DL-NULL-IND-1) ),        
                       :DL-RECNCT-COLLECT-AMT,                          
                       :DL-RECNCT-TYPE-CD,                              
                       :DL-RECNCT-NRML-HR-IND,                          
                       :DL-USER-ID)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_RECONNECT                                       
MFA-TR*                (ACCOUNT_NO,                                             
MFA-TR*                 AGREEMENT_COMMENTS,                                     
MFA-TR*                 AMT_TOT_RECONNECT,                                      
MFA-TR*                 DATETIME_SETUP,                                         
MFA-TR*                 RECNCT_COLLECT_AMT,                                     
MFA-TR*                 RECNCT_TYPE_CD,                                         
MFA-TR*                 RECNCT_NRML_HR_IND,                                     
MFA-TR*                 USER_ID)                                                
MFA-TR*         VALUES                                                          
MFA-TR*               (:DL-ACCOUNT-NO,                                          
MFA-TR*                :DL-AGREEMENT-COMMENTS,                                  
MFA-TR*                :DL-AMT-TOT-RECONNECT,                                   
MFA-TR*                :DL-DATETIME-SETUP:WS-DL-NULL-IND-1,                     
MFA-TR*                :DL-RECNCT-COLLECT-AMT,                                  
MFA-TR*                :DL-RECNCT-TYPE-CD,                                      
MFA-TR*                :DL-RECNCT-NRML-HR-IND,                                  
MFA-TR*                :DL-USER-ID)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
CBSI          MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RECONNECT'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'RECNCT_TYPE_CD'         TO TABLE-ELEMENT-2          
CBSI          MOVE 'DATETIME_SETUP'         TO TABLE-ELEMENT-3          
CBSI          MOVE 'USER_ID'                TO TABLE-ELEMENT-4          
              MOVE DL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE DL-RECNCT-TYPE-CD        TO HOSTVAR-ELEMENT-2        
CBSI          MOVE DL-DATETIME-SETUP        TO HOSTVAR-ELEMENT-3        
CBSI          MOVE DL-USER-ID               TO HOSTVAR-ELEMENT-4        
CBSI          MOVE 'INSERT RECONNECT 8010'  TO RS-RETURN-MESSAGE        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-UPDATE-RECONNECT                                          *        
      *       -- THIS MODULE UPDATES CSS_RECONNECT.                    *        
      ******************************************************************        
       8200-UPDATE-RECONNECT.                                           
           MOVE '8200'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_RECONNECT                                    
                SET AGREEMENT_COMMENTS = :DL-AGREEMENT-COMMENTS,        
                    AMT_TOT_RECONNECT  = :DL-AMT-TOT-RECONNECT,         
                    DATETIME_SETUP     =                                
                                    IIF(TRY_CONVERT(DATE, 
                                                    :DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ) <> 0) OR (LEN(:DL-DATETIME-SETUP :WS-DL-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ), CONVERT(DATE, :DL-DATETIME-SETUP :WS-DL-NULL-IND-1) ),
                    RECNCT_COLLECT_AMT = :DL-RECNCT-COLLECT-AMT,        
                    RECNCT_TYPE_CD     = :DL-RECNCT-TYPE-CD,            
                    USER_ID            = :DL-USER-ID,                   
P00726              RCNCT_TERM_ID      = :WS-RCNCT-TERM-ID,             
P00726              LAST_UPDATE_USERID = :WS-LAST-UPDATE-USERID,        
P00726              RCC_BILL_OPTION_CD = :WS-RCC-BILL-OPTION-CD         
                WHERE ACCOUNT_NO       = :DL-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_RECONNECT                                            
MFA-TR*         SET AGREEMENT_COMMENTS = :DL-AGREEMENT-COMMENTS,                
MFA-TR*             AMT_TOT_RECONNECT  = :DL-AMT-TOT-RECONNECT,                 
MFA-TR*             DATETIME_SETUP     =                                        
MFA-TR*                             :DL-DATETIME-SETUP:WS-DL-NULL-IND-1,        
MFA-TR*             RECNCT_COLLECT_AMT = :DL-RECNCT-COLLECT-AMT,                
MFA-TR*             RECNCT_TYPE_CD     = :DL-RECNCT-TYPE-CD,                    
MFA-TR*             USER_ID            = :DL-USER-ID,                           
MFA-TR*             RCNCT_TERM_ID      = :WS-RCNCT-TERM-ID,                     
MFA-TR*             LAST_UPDATE_USERID = :WS-LAST-UPDATE-USERID,                
MFA-TR*             RCC_BILL_OPTION_CD = :WS-RCC-BILL-OPTION-CD                 
MFA-TR*         WHERE ACCOUNT_NO       = :DL-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
CBSI          MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RECONNECT'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE 'RECNCT_TYPE_CD'         TO TABLE-ELEMENT-2          
CBSI          MOVE 'DATETIME_SETUP'         TO TABLE-ELEMENT-3          
CBSI          MOVE 'USER_ID'                TO TABLE-ELEMENT-4          
              MOVE DL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE DL-RECNCT-TYPE-CD        TO HOSTVAR-ELEMENT-2        
CBSI          MOVE DL-DATETIME-SETUP        TO HOSTVAR-ELEMENT-3        
CBSI          MOVE DL-USER-ID               TO HOSTVAR-ELEMENT-4        
CBSI          MOVE 'UPDATE CSS_RECONNECT - 8200'                        
CBSI                                        TO RS-RETURN-MESSAGE        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C26296******************************************************************        
C26296* 8250-UPDATE-RECAL-RECONNCT.                                    *        
C26296*       -- THIS MODULE UPDATES CSS_RECONNECT WHEN AUTO DEP AMT   *        
C26296*       -- IS RECALCULATED DURING PANEL125 RETRIEVE.             *        
C26296******************************************************************        
C26296 8250-UPDATE-RECAL-RECONNCT.                                      
C26296*                                                                         
C26296     MOVE '8250'                      TO ACTIVE-PARAGRAPH.        
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296          UPDATE CSS_RECONNECT                                    
C26296          SET AUTO_DEP_AM        = :DL-AUTO-DEP-AM                
C26296             ,AMT_TOT_RECONNECT  = :DL-AMT-TOT-RECONNECT          
C26296             ,DATETIME_SETUP     =                                
C26296                              IIF(TRY_CONVERT(DATE, 
                                                    :DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ) <> 0) OR (LEN(:DL-DATETIME-SETUP :WS-DL-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:DL-DATETIME-SETUP 
                                                      :WS-DL-NULL-IND-1
              ), CONVERT(DATE, :DL-DATETIME-SETUP :WS-DL-NULL-IND-1) ) 
C26296             ,USER_ID            = :DL-USER-ID,                   
P00726              LAST_UPDATE_USERID = :WS-LAST-UPDATE-USERID         
C26296          WHERE ACCOUNT_NO       = :DL-ACCOUNT-NO                 
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_RECONNECT                                            
MFA-TR*         SET AUTO_DEP_AM        = :DL-AUTO-DEP-AM                        
MFA-TR*            ,AMT_TOT_RECONNECT  = :DL-AMT-TOT-RECONNECT                  
MFA-TR*            ,DATETIME_SETUP     =                                        
MFA-TR*                             :DL-DATETIME-SETUP:WS-DL-NULL-IND-1         
MFA-TR*            ,USER_ID            = :DL-USER-ID,                           
MFA-TR*             LAST_UPDATE_USERID = :WS-LAST-UPDATE-USERID                 
MFA-TR*         WHERE ACCOUNT_NO       = :DL-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
C26296                                         RS-RETURN-CODE.          
C26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C26296        NEXT SENTENCE                                             
C26296     ELSE                                                         
C26296        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
CBSI96        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
C26296        MOVE '8250'                   TO ACTIVE-PARAGRAPH         
C26296        MOVE SPACES                   TO ABEND-TABLES             
C26296                                         ABEND-SQL-PREDICATES     
CBSI96        MOVE 'UPDATE'                 TO ABEND-FUNCTION           
C26296        MOVE 'CSS_RECONNECT'          TO TABLE-1                  
C26296        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI96        MOVE 'AUTO_DEP_AM'            TO TABLE-ELEMENT-2          
CBSI96        MOVE 'DATETIME_SETUP'         TO TABLE-ELEMENT-3          
CBSI96        MOVE 'USER_ID'                TO TABLE-ELEMENT-4          
C26296        MOVE DL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI96        MOVE DL-AUTO-DEP-AM           TO HOSTVAR-ELEMENT-2-N      
CBSI96        MOVE DL-DATETIME-SETUP        TO HOSTVAR-ELEMENT-3        
CBSI96        MOVE DL-USER-ID               TO HOSTVAR-ELEMENT-4        
CBSI96        MOVE 'UPDATE CSS_RECONNECT - 8250'                        
CBSI96                                      TO RS-RETURN-MESSAGE        
C26296        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C26296        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C26296     END-IF.                                                      
C26296*                                                                         
C26296 8250-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
      ******************************************************************        
      * 8300-DELETE-RECONNECT                                          *        
      *       -- THIS MODULE DELETES FROM CSS_RECONNECT                *        
      ******************************************************************        
       8300-DELETE-RECONNECT.                                           
           MOVE '8300'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_RECONNECT                               
                WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
T18187     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE '8300'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_RECONNECT '         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE DL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE 'DELETE'                 TO ABEND-FUNCTION           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8600-UPDATE-AT                                                 *        
      *       -- THIS MODULE UPDATES CSS_ACCOUNT.                      *        
      ******************************************************************        
       8600-UPDATE-AT.                                                  
           MOVE '8600'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO AT-LAST-UPDATE-TS.       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_ACCOUNT                                      
                SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,        
                    LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )             
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_ACCOUNT                                              
MFA-TR*         SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,                
MFA-TR*             LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS                     
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE '8600'                   TO ACTIVE-PARAGRAPH         
CBSI          MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
CBSI          MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_ACCOUNT  '          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
CBSI          MOVE 'LAST_UPDATE_TS'         TO TABLE-ELEMENT-2          
CBSI          MOVE AT-LAST-UPDATE-TS        TO HOSTVAR-ELEMENT-2        
CBSI          MOVE 'UPDATE AR-ACCOUNT    - 8600'                        
                                            TO RS-RETURN-MESSAGE        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
C26296*                                                                         
C26296 8700-CALL-CSR02072.                                              
C26296*                                                                         
C26296     INITIALIZE WS-CSR02072-OUTPUT-FIELDS.                        
C26296*    EXEC SQL CALL CSR02072                                       
C26296*    (:WS-ACTION-CODE,                                            
C26296*     :WS-ACCT-NO,                                                
C26296*     :WS-AMT-ORIG-ENTERED ,                                      
C26296*     :WS-DEPOSIT-STATUS-CD,                                      
C26296*     :WS-SERVICE-TYPE-CD  ,                                      
C26296*     :WS-DEPOSIT-CERT-NO  ,                                      
C26296*     :WS-DEP-ACTION-CODE  ,                                      
C26296*     :WS-USER-ID-UPDT-BY  ,                                      
C26296*     :WS-COMMENTS         ,                                      
C26296*     :WS-COMMENTS-LEN,                                           
C26296*     :WS-PANEL-COMMENTS   ,                                      
C26296*     :WS-PANEL-COMM-LEN,                                         
C26296*     :WS-BILL-OPTION-CD   ,                                      
C26296*     :WS-ORIG-BILL-OPTN,                                         
C26296*     :WS-NO-SCHED-PYMTS   ,                                      
C26296*     :WS-AMT-MO-PYMT      ,                                      
C26296*     :WS-CODE-DEP-TYPE    ,                                      
C26296*     :WS-CUT-DATE ,                                              
C26296*     :WS-PROJECT-CR-DT,                                          
C26296*     :WS-DUE-DATE,                                               
C26296*     :WS-PROGRAM-NAME,                                           
C26296*     :WS-LAST-UPDATE-TS,                                         
C26296*     :WS-CODE-REFUND-ELIG,                                       
C26296*     :WS-ERROR-SWITCH,                                           
C26296*     :WS-AUTO-DEP-LTR-DT,                                        
C26296*     :WS-AUTO-DEP-LETTER-IND,                                    
C26296*     :WS-AUTO-DEP-NOT-AMT,                                       
C26296*     :WS-AUTO-DEP-RECALC-AMT)                                    
C26296*     END-EXEC                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CHRG_AUTO_DEP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CHRG_AUTO_DEP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CHRG_AUTO_DEP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C26296      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE      
C26296      IF  WS-ACTIVE-RETURN-CODE = +466                            
C26296*         EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE       
C26296*            CSR02072                                             
C26296*         END-EXEC                                                
C26296                                                                  
C26296*         EXEC SQL                                                
C26296*           ALLOCATE CHRG_AUTO_DEP CURSOR FOR RESULT SET :LOC1    
C26296*         END-EXEC                                                
C26296                                                                  
C26296          EXEC SQL                                                
C26296            FETCH CHRG_AUTO_DEP                                   
C26296            INTO :WS-CSR02072-ERROR-CODE                          
C26296                ,:WS-CSR02072-RETURN-CODE                         
C26296                ,:WS-CSR02072-AR-LOCKOUT-IND                      
C26296                ,:WS-CSR02072-ACCT-XFER-TO                        
C26296                ,:WS-CSR02072-ABEND-PROGRAM                       
C26296                ,:WS-CSR02072-ACTIVE-PARAGRAPH                    
C26296                ,:WS-CSR02072-ABEND-FUNCTION                      
C26296                ,:WS-CSR02072-TABLE-1                             
C26296                ,:WS-CSR02072-TABLE-ELEMENT-1                     
C26296                ,:WS-CSR02072-TABLE-ELEMENT-2                     
C26296                ,:WS-CSR02072-TABLE-ELEMENT-3                     
C26296                ,:WS-CSR02072-TABLE-ELEMENT-4                     
C26296                ,:WS-CSR02072-HOSTVAR-ELEMENT-1                   
C26296                ,:WS-CSR02072-HOSTVAR-ELEMENT-2                   
C26296                ,:WS-CSR02072-HOSTVAR-ELEMENT-3                   
C26296                ,:WS-CSR02072-HOSTVAR-ELEMENT-4                   
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296          MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
C26296          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C26296              EVALUATE WS-CSR02072-RETURN-CODE                    
C26296                  WHEN 0                                          
C26296                      IF  WS-CSR02072-ERROR-CODE EQUAL SPACES     
C26296                          MOVE 'Y' TO WS-CSR02072-SUCCESS-FL      
C26296*                     MOVE WS-MAX-DEP-CERT-NO TO S-DEP-CERT-NO            
C26296                      END-IF                                      
C26296                  WHEN OTHER                                      
C26296                      MOVE 'N' TO WS-CSR02072-SUCCESS-FL          
C26296                      MOVE WS-CSR02072-RETURN-CODE                
C26296                      TO WS-ACTIVE-RETURN-CODE                    
C26296                         SQLCODE                                  
C26296                      MOVE WS-CSR02072-ABEND-FUNCTION             
C26296                      TO ABEND-FUNCTION                           
C26296                      MOVE WS-CSR02072-ACTIVE-PARAGRAPH           
C26296                      TO ACTIVE-PARAGRAPH                         
C26296                      MOVE WS-CSR02072-ABEND-PROGRAM              
C26296                      TO ABEND-PROGRAM                            
C26296                      MOVE WS-CSR02072-TABLE-1                    
C26296                      TO TABLE-1                                  
C26296                      MOVE WS-CSR02072-TABLE-ELEMENT-1            
C26296                      TO TABLE-ELEMENT-1                          
C26296                      MOVE WS-CSR02072-HOSTVAR-ELEMENT-1          
C26296                      TO HOSTVAR-ELEMENT-1                        
C26296                      MOVE WS-CSR02072-TABLE-ELEMENT-2            
C26296                      TO TABLE-ELEMENT-2                          
C26296                      MOVE WS-CSR02072-HOSTVAR-ELEMENT-2          
C26296                      TO HOSTVAR-ELEMENT-2                        
C26296                      MOVE WS-CSR02072-TABLE-ELEMENT-3            
C26296                      TO TABLE-ELEMENT-3                          
C26296                      MOVE WS-CSR02072-HOSTVAR-ELEMENT-3          
C26296                      TO HOSTVAR-ELEMENT-3                        
C26296                      MOVE WS-CSR02072-TABLE-ELEMENT-4            
C26296                      TO TABLE-ELEMENT-4                          
C26296                      MOVE WS-CSR02072-HOSTVAR-ELEMENT-4          
C26296                      TO HOSTVAR-ELEMENT-4                        
C26296                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT
C26296                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
C26296              END-EVALUATE                                        
C26296          ELSE                                                    
C26296              MOVE 'N' TO WS-CSR02072-SUCCESS-FL                  
C26296              MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
C26296              MOVE '8700'              TO ACTIVE-PARAGRAPH        
C26296              MOVE 'FETCH'             TO ABEND-FUNCTION          
C26296              MOVE SPACES              TO ABEND-SQL-PREDICATES    
C26296                                                ABEND-TABLES      
C26296              MOVE 'CSR02072'          TO TABLE-1                 
C26296              MOVE 'SQLCODE'           TO TABLE-ELEMENT-1         
C26296              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
C26296              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2         
C26296              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2       
C26296              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
C26296              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
C26296          END-IF                                                  
C26296                                                                  
C26296          EXEC SQL                                                
C26296             CLOSE CHRG_AUTO_DEP                                  
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296          MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE          
C26296          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C26296              CONTINUE                                            
C26296          ELSE                                                    
C26296             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
C26296             MOVE '8700'               TO ACTIVE-PARAGRAPH        
C26296             MOVE 'CLOSE'              TO ABEND-FUNCTION          
C26296             MOVE 'CSR02072'           TO TABLE-1                 
C26296             MOVE 'WS-ACTIVE-RETURN-CODE' TO TABLE-ELEMENT-1      
C26296             MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1      
C26296             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2         
C26296             MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2       
C26296             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
C26296             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C26296          END-IF                                                  
C26296     ELSE                                                         
C26296         MOVE -1                       TO WS-ACTIVE-RETURN-CODE   
C26296         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
C26296         MOVE '8700'                   TO ACTIVE-PARAGRAPH        
C26296         MOVE 'DB2SP'                  TO ABEND-FUNCTION          
C26296         MOVE SPACES                   TO ABEND-SQL-PREDICATES    
C26296                                           ABEND-TABLES           
C26296         MOVE 'CSR02072'               TO TABLE-1                 
C26296         MOVE 'SQLCODE'                TO TABLE-ELEMENT-1         
C26296         MOVE SQLCODE                  TO HOSTVAR-ELEMENT-1       
C26296         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2         
C26296         MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2       
C26296         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
C26296         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C26296     END-IF.                                                      
C26296*                                                                         
C26296 8700-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* UPDATES CSS_RECONNECT WITH THE AUTO DEPOSIT CERT NO.           *        
C26296******************************************************************        
C26296 8710-UPDATE-AUTO-DEP-CERT.                                       
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296        UPDATE CSS_RECONNECT                                      
C26296           SET AUTO_DEP_CERT_NO = :DL-AUTO-DEP-CERT-NO            
C26296         WHERE ACCOUNT_NO       = :DL-ACCOUNT-NO                  
C26296     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C26296         CONTINUE                                                 
C26296     ELSE                                                         
C26296         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C26296         MOVE '8710'                     TO ACTIVE-PARAGRAPH      
C26296         MOVE 'UPDATE'                   TO ABEND-FUNCTION        
C26296         MOVE SPACES                     TO ABEND-SQL-PREDICATES  
C26296                                            ABEND-TABLES          
C26296         MOVE 'CSS_RECONNECT '           TO TABLE-1               
C26296         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
C26296         MOVE 'AUTO_DEP_CERT_NO'         TO TABLE-ELEMENT-2       
C26296         MOVE DL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1-N   
C26296         MOVE DL-AUTO-DEP-CERT-NO        TO HOSTVAR-ELEMENT-2-N   
C26296         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C26296         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C26296     END-IF.                                                      
C26296*                                                                         
C26296 8710-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* UPDATES CSS_RECONNECT WITH THE AUTO DEP AM.                    *        
C26296******************************************************************        
C26296 8720-UPDATE-AUTO-DEP-AM.                                         
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296        UPDATE CSS_RECONNECT                                      
C26296           SET AUTO_DEP_AM      = :DL-AUTO-DEP-AM                 
C26296         WHERE ACCOUNT_NO       = :DL-ACCOUNT-NO                  
C26296     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C26296         CONTINUE                                                 
C26296     ELSE                                                         
C26296         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C26296         MOVE '8720'                     TO ACTIVE-PARAGRAPH      
C26296         MOVE 'UPDATE'                   TO ABEND-FUNCTION        
C26296         MOVE SPACES                     TO ABEND-SQL-PREDICATES  
C26296                                            ABEND-TABLES          
C26296         MOVE 'CSS_RECONNECT '           TO TABLE-1               
C26296         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
C26296         MOVE DL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1-N   
C26296         MOVE 'AUTO_DEP_AM'              TO TABLE-ELEMENT-2       
C26296         MOVE DL-AUTO-DEP-AM             TO HOSTVAR-ELEMENT-2-N   
C26296         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C26296         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C26296     END-IF.                                                      
C26296*                                                                         
C26296 8720-EXIT.                                                       
C26296     EXIT.                                                        
      *                                                                         
      ******************************************************************        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
