       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04758.                                            
COB303 DATE-WRITTEN.  JANUARY 2015.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00080000
      *                                                                *00090000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00100000
      *                                                                *00130000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM RETRIEVES THE BANK DEPOSIT SUMMARY FROM          *00210000
      *  CSS_BANK_TRANSFER TABLE FOR BANKS THAT ARE IN CSS_BANK AND    *00220000
      *  FOR GIVEN CASH LOCAL OFFICE AND CASH REPORT DATE.             *00220000
      *                                                                *        
      *  BUSOP NAME: GETBANKDEPOSITSUMMARY                             *        
      ******************************************************************00180000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  01/02/15  AP40911    THIS PROCEDURE WAS WRITTEN TO USE IN CIS *00270002
      *                       MODERNIZATION TO RETRIEVE BANK DEPOSIT   *        
      *                       SUMMARY.                                 *        
      ******************************************************************00290000
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04758'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)       VALUE            
           'WORKING STORAGE FOR CSR04758 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00303.                                               01700000
                                                                        
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN         PIC S9(9)       COMP VALUE 1.         
           05  CTR-ROWS           PIC S9(9)       COMP VALUE 0.         
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)       VALUE 'CSR04758'.
           05  WS-SQLSTATE             PIC X(05).                       
           05  SEND-DONE-SW            PIC X(01)       VALUE 'Y'.       
               88 SEND-DONE-ERROR                      VALUE 'N'.       
               88 SEND-DONE-OK                         VALUE 'Y'.       
                                                                        
       01  WS-WORK-FIELDS.                                              
           05  WS-RETURN-CODE          PIC S9(09)      COMP-4.          
           05  WS-CURRENCY-TYPE        PIC X.                           
               88 CASH                                 VALUE 'A'.       
               88 CHECK                                VALUE 'C'.       
               88 MONEY-ORDER                          VALUE 'M'.       
               88 DRAFT                                VALUE 'D'.       
           05  WS-BANK-NO.                                              
               10 BANK-ST-CD           PIC X(02)       VALUE SPACES.    
               10 WS-FILLER            PIC X           VALUE SPACES.    
               10 BANK-CD              PIC X(05)       VALUE SPACES.    
           05  WS-C                    PIC X(01)       VALUE 'C'.       
           05  WS-TRANSFER-TS          PIC X(26).                       
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-CASHIER-FULL-NAME    PIC X(40) VALUE SPACES.          
                                                                        
       01  FILLER                      PIC X(32)       VALUE            
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09)      COMP             
                                                       VALUE 0.         
           05  S-BANK-NO               PIC X(08).                       
           05  S-BANK-NAME             PIC X(50).                       
COB305     05 S-CASH-AMOUNT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305     05 S-CHECK-MO-AMOUNT        PIC S9(09)V99 COMP-3 VALUE 0.          
COB305     05 S-TOTAL-AMOUNT        PIC S9(11)V99 COMP-3 VALUE 0.          
           05  S-USER-ID               PIC X(07).                       
           05  S-CASHIER-FULL-NAME     PIC X(40) VALUE SPACE.           
           05  S-CASH-DRAWER-ID        PIC S9(04) COMP.                 
           05  S-REPORT-STATUS         PIC X.                           
           05  S-TRANSFER-TS           PIC X(26).                       
           05  S-BANK-POST-DT          PIC X(10) VALUE SPACES.          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                           05750000
           END-EXEC.                                                    05760000
                                                                        
      *************************************************************             
      *    CSS_BANK  D1                                           *             
      *************************************************************             
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBBANK                                         05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_BANK_TRANSFER  YB                                  *             
      *************************************************************             
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBBNKXFR                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************02510050
      *    CSS_USER_PROFILE    PF                                      *02520050
      ******************************************************************02530050
           EXEC SQL                                                     02540050
              INCLUDE TBUSRPRF                                          02550050
           END-EXEC.                                                    02560050
                                                                        
      *************************************************************             
      *    CSS_CSH_REPORT_HDR   YR                                *             
      *************************************************************             
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBCSRPHD                                       05870000
           END-EXEC.                                                    05880000
      ******************************************************************06900000
      *          CURSOR FOR CSS_BANK_TRANSFER                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  BANK_TRNXFR_CURSOR CURSOR FOR                  
                 SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           YB.TRANSFER_TS, 121), ' ', '-'), ':', '.') TRANSFER_TS,             
                         YB.CURRENCY_TYPE,                              
                         YB.USER_ID,                                    
                         YB.CASH_DRAWER_ID,                             
                         YB.BANK_ID,                                    
                         YB.TRANSFER_AMT,                               
                         YB.CODE_DR_CR,                                 
                         YB.BANK_POST_DT,                               
                         D1.FCS_DEP_BANK_ST_CD,                         
                         D1.FCS_DEP_BANK_CD,                            
                         D1.BANK_NAME                                   
                   FROM  CSS_BANK_TRANSFER  YB,                         
                         CSS_BANK           D1                          
                  WHERE  YB.CASH_COMPANY_NO      = :YB-CASH-COMPANY-NO  
                    AND  YB.CASH_LOCAL_OFFICE    = :YB-CASH-LOCAL-OFFICE
                    AND  YB.DATE_CASH_REPORT     = 
              IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ) 
                    AND  YB.BANK_ID              = D1.BANK_ID           
               ORDER BY  D1.FCS_DEP_BANK_ST_CD,                         
                         D1.FCS_DEP_BANK_CD,                            
                         YB.BANK_ID ASC,                                
                         YB.USER_ID ASC,                                
                         TRANSFER_TS DESC                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*         DECLARE  BANK_TRNXFR_CURSOR CURSOR FOR                  06930000
MFA-TR*          SELECT  YB.TRANSFER_TS,                                 0694000
MFA-TR*                  YB.CURRENCY_TYPE,                               0695000
MFA-TR*                  YB.USER_ID,                                            
MFA-TR*                  YB.CASH_DRAWER_ID,                                     
MFA-TR*                  YB.BANK_ID,                                            
MFA-TR*                  YB.TRANSFER_AMT,                                       
MFA-TR*                  YB.CODE_DR_CR,                                         
MFA-TR*                  YB.BANK_POST_DT,                                       
MFA-TR*                  D1.FCS_DEP_BANK_ST_CD,                                 
MFA-TR*                  D1.FCS_DEP_BANK_CD,                                    
MFA-TR*                  D1.BANK_NAME                                           
MFA-TR*            FROM  CSS_BANK_TRANSFER  YB,                                 
MFA-TR*                  CSS_BANK           D1                                  
MFA-TR*           WHERE  YB.CASH_COMPANY_NO      = :YB-CASH-COMPANY-NO          
MFA-TR*             AND  YB.CASH_LOCAL_OFFICE    = :YB-CASH-LOCAL-OFFICE        
MFA-TR*             AND  YB.DATE_CASH_REPORT     = :YB-DATE-CASH-REPORT         
MFA-TR*             AND  YB.BANK_ID              = D1.BANK_ID                   
MFA-TR*        ORDER BY  D1.FCS_DEP_BANK_ST_CD,                                 
MFA-TR*                  D1.FCS_DEP_BANK_CD,                                    
MFA-TR*                  YB.BANK_ID ASC,                                        
MFA-TR*                  YB.USER_ID ASC,                                        
MFA-TR*                  YB.TRANSFER_TS DESC                                    
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-CASH-COMPANY-NO    PIC X(02).                            
       01 PARM-CASH-LOCAL-OFFICE  PIC X(03).                            
       01 PARM-DATE-CASH-REPORT   PIC X(10).                            
      *                                                                         
       PROCEDURE DIVISION USING PARM-CASH-COMPANY-NO                    
                                PARM-CASH-LOCAL-OFFICE                  
                                PARM-DATE-CASH-REPORT.                  
                                                                        
      ******************************************************************07600000
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      ******************************************************************07630000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100-INITIALIZE                                                *07740000
      ******************************************************************07800000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                         TO ACTIVE-PARAGRAPH.     
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                   RETURN_CODE                                          
                  ,BANK_NO                AS  BANK_NUMBER               
                  ,LTRIM(RTRIM(BANK_NAME))      AS  BANK_NAME                 
                  ,CASH_AMOUNT                                          
                  ,CHECK_MO_AMOUNT                                      
                  ,TOTAL_AMOUNT                                         
                  ,USER_ID                                              
                  ,CASHIER_FULL_NAME                                    
                  ,CASH_DRAWER_ID                                       
                  ,REPORT_STATUS                                        
                  ,TRANSFER_TS                                          
                  ,BANK_POST_DT                                         
              FROM                                                      
                  #CSR04758_R1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BANK_NO                AS  BANK_NUMBER                       
MFA-TR*           ,STRIP(BANK_NAME )      AS  BANK_NAME                         
MFA-TR*           ,CASH_AMOUNT                                                  
MFA-TR*           ,CHECK_MO_AMOUNT                                              
MFA-TR*           ,TOTAL_AMOUNT                                                 
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,CASHIER_FULL_NAME                                            
MFA-TR*           ,CASH_DRAWER_ID                                               
MFA-TR*           ,REPORT_STATUS                                                
MFA-TR*           ,TRANSFER_TS                                                  
MFA-TR*           ,BANK_POST_DT                                                 
MFA-TR*       FROM                                                              
MFA-TR*           SESSION.CSR04758_R1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08040000
      * 1000-PROCESS-INPUT.                                            *08050000
      *                                                                *08060000
      *     1. RECEIVE PARMS.                                          *08070000
      *                                                                *08080000
      ******************************************************************08090000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
      *    PERFORM 1100-RECEIVE-PARMS          THRU 1100-EXIT.          08130000
           MOVE PARM-CASH-COMPANY-NO           TO YB-CASH-COMPANY-NO,   
                                                  YR-CASH-COMPANY-NO    
           MOVE PARM-CASH-LOCAL-OFFICE         TO YB-CASH-LOCAL-OFFICE, 
                                                  YR-CASH-LOCAL-OFFICE. 
           MOVE PARM-DATE-CASH-REPORT          TO YB-DATE-CASH-REPORT,  
                                                  YR-DATE-CASH-REPORT.  
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08170000
      *0100A-DECLARE-GTT.                                             *         
      ***************************************************************** 08170000
       0100A-DECLARE-GTT.                                               
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04758_R1'            
                                         TO S-SQL-STATEMENT-V.          
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04758_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04758_R1
              (                                                        
                    RETURN_CODE        INT                          
                   ,BANK_NO CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,BANK_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CASH_AMOUNT        DECIMAL(11,2)                    
                   ,CHECK_MO_AMOUNT    DECIMAL(11,2)                    
                   ,TOTAL_AMOUNT       DECIMAL(13,2)                    
                   ,USER_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,CASHIER_FULL_NAME CHAR(40)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CASH_DRAWER_ID     SMALLINT                         
                   ,REPORT_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,TRANSFER_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BANK_POST_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS                             
                                         THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04758_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************08470000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *                                                                *08490000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     2. BUILD RESULT SET                                        *08510000
      *                                                                *08540000
      ******************************************************************08550000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 2200-PROCESS-DETAIL         THRU 2200-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08640000
      ******************************************************************        
      *    2200-PROCESS-DETAIL                                         *        
      *                                                                *        
      *    1. CHECK IF CASH-REPORT IS PRESENT FOR THE DAY.             *        
      *    2. IF NOT PRESENT RETURN 2000.                              *        
      *    3. CHECK IF BANK TRANSFERS HAVE BEEN MADE FOR THIS DAY.     *        
      *    4. RETURN 1000 IF NOT BANK TRANSFERS ARE MADE YET.          *        
      *    5. RETURN THE RESULTING BANK TRANSFERS.                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-DETAIL.                                             
                                                                        
           MOVE '2200'                          TO ACTIVE-PARAGRAPH.    
           PERFORM 7000-SELECT-REPORT-STATUS    THRU 7000-EXIT.         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 7100-OPEN-BANK-TRNXFR-CURSOR                     
                                                THRU 7100-EXIT          
               PERFORM 7200-FETCH-BANK-TRNXFR-CURSOR                    
                                                THRU 7200-EXIT          
                                                                        
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   PERFORM 2300-MOVE-PARA       THRU 2300-EXIT          
                   PERFORM 2400-PROCESS-TRANSFER-DET                    
                                                THRU 2400-EXIT          
                   UNTIL WS-RETURN-CODE = NOT-FOUND                     
               ELSE                                                     
                   MOVE YR-STATUS               TO S-REPORT-STATUS      
                   MOVE 1000                    TO S-RETURN-CODE        
                   PERFORM 8100-SEND-RESULT     THRU 8100-EXIT          
               END-IF                                                   
                                                                        
               PERFORM 7300-CLOSE-BANK-TRNXFR-CURSOR                    
                                                THRU 7300-EXIT          
           ELSE                                                         
               MOVE 2000                        TO S-RETURN-CODE        
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *   2300-MOVE-PARA.                                             *         
      *                                                               *         
      *   MOVE THE VALUES FROM THE FETCH TO THE RESULT FIELDS.        *         
      *                                                               *         
      *****************************************************************         
       2300-MOVE-PARA.                                                  
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
           MOVE D1-FCS-DEP-BANK-ST-CD           TO BANK-ST-CD.          
           MOVE D1-FCS-DEP-BANK-CD              TO BANK-CD.             
           MOVE WS-BANK-NO                      TO S-BANK-NO.           
           MOVE YR-STATUS                       TO S-REPORT-STATUS.     
           MOVE D1-BANK-NAME                    TO S-BANK-NAME.         
           MOVE YB-USER-ID                      TO S-USER-ID            
                                                   PF-USER-ID.          
           MOVE YB-CASH-DRAWER-ID               TO S-CASH-DRAWER-ID.    
           MOVE YB-BANK-POST-DT                 TO S-BANK-POST-DT.      
           MOVE YB-CURRENCY-TYPE                TO WS-CURRENCY-TYPE.    
                                                                        
           PERFORM 7400-GET-USER-PROFILE THRU 7400-EXIT                 
             MOVE WS-CASHIER-FULL-NAME     TO S-CASHIER-FULL-NAME       
           IF  CHECK OR MONEY-ORDER OR DRAFT                            
               ADD YB-TRANSFER-AMT              TO S-CHECK-MO-AMOUNT    
           ELSE                                                         
               IF  CASH                                                 
                   ADD YB-TRANSFER-AMT          TO S-CASH-AMOUNT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE YB-TRANSFER-TS                  TO WS-TRANSFER-TS.      
           MOVE WS-TRANSFER-TS                  TO S-TRANSFER-TS.       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2400-PROCESS-TRANSFER-DET                                   *        
      *                                                                *        
      *    1. BUILD THE RESULT SET                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2400-PROCESS-TRANSFER-DET.                                       
                                                                        
           MOVE '2400'                          TO ACTIVE-PARAGRAPH.    
           PERFORM 7200-FETCH-BANK-TRNXFR-CURSOR                        
                                                THRU 7200-EXIT.         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2500-PROCESS-NXT-TRAN    THRU 2500-EXIT          
           ELSE                                                         
               ADD S-CASH-AMOUNT               TO S-TOTAL-AMOUNT        
               ADD S-CHECK-MO-AMOUNT           TO S-TOTAL-AMOUNT        
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2500-PROCESS-NXT-TRAN                                       *        
      *                                                                *        
      *    1. ACCUMULATE BANK TRANSFERS FOR A SINGLE TRANSFER-TS AND   *        
      *       CASHIER.                                                 *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2500-PROCESS-NXT-TRAN.                                           
                                                                        
           MOVE '2500'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           IF  YB-USER-ID EQUAL S-USER-ID AND                           
               YB-TRANSFER-TS EQUAL WS-TRANSFER-TS                      
               MOVE YB-CURRENCY-TYPE            TO WS-CURRENCY-TYPE     
               IF  CHECK OR MONEY-ORDER OR DRAFT                        
                   ADD YB-TRANSFER-AMT          TO S-CHECK-MO-AMOUNT    
               ELSE                                                     
                   IF  CASH                                             
                       ADD YB-TRANSFER-AMT      TO S-CASH-AMOUNT        
                   END-IF                                               
               END-IF                                                   
           ELSE                                                         
               ADD S-CASH-AMOUNT               TO S-TOTAL-AMOUNT        
               ADD S-CHECK-MO-AMOUNT           TO S-TOTAL-AMOUNT        
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               INITIALIZE GTT-RETURN-FIELDS                             
               PERFORM 2300-MOVE-PARA           THRU 2300-EXIT          
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7000-SELECT-REPORT-STATUS                                   *        
      *                                                                *        
      *    TO SELECT THE REPORT STATUS FOR THE DATE_CASH_REPORT        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-SELECT-REPORT-STATUS.                                       
                                                                        
           EXEC SQL                                                     
                SELECT  STATUS                                          
                  INTO  :YR-STATUS                                      
                  FROM  CSS_CSH_REPORT_HDR                              
                 WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO         
                   AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE       
                   AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  STATUS                                                  
MFA-TR*           INTO  :YR-STATUS                                              
MFA-TR*           FROM  CSS_CSH_REPORT_HDR                                      
MFA-TR*          WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE               
MFA-TR*            AND  DATE_CASH_REPORT  = :YR-DATE-CASH-REPORT                
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7000'                      TO ACTIVE-PARAGRAPH     
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES,
                                                   ABEND-TABLES         
               MOVE 'CSS_CSH_REPORT_HDR'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE YR-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YR-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YR-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7100-OPEN-BANK-TRNXFR-CURSOR                                *        
      *                                                                *        
      *    TO OPEN THE BANK_TRNXFR_CURSOR                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-OPEN-BANK-TRNXFR-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
                OPEN  BANK_TRNXFR_CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7100'                      TO ACTIVE-PARAGRAPH     
               MOVE 'OPEN'                      TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES,
                                                   ABEND-TABLES         
               MOVE 'CSS_BANK_TRANSFER'         TO TABLE-1              
               MOVE 'CSS_BANK'                  TO TABLE-2              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE YB-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YB-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YB-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7200-FETCH-BANK-TRNXFR-CURSOR                               *        
      *                                                                *        
      *    THIS PARA IS TO FETCH THE BANK_TRNXFR_CURSOR                *        
      ******************************************************************        
                                                                        
       7200-FETCH-BANK-TRNXFR-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
                FETCH  BANK_TRNXFR_CURSOR                               
                 INTO  :YB-TRANSFER-TS,                                 
                       :YB-CURRENCY-TYPE,                               
                       :YB-USER-ID,                                     
                       :YB-CASH-DRAWER-ID,                              
                       :YB-BANK-ID,                                     
                       :YB-TRANSFER-AMT,                                
                       :YB-CODE-DR-CR,                                  
                       :YB-BANK-POST-DT :WS-NULL-INDICATOR-1,           
                       :D1-FCS-DEP-BANK-ST-CD,                          
                       :D1-FCS-DEP-BANK-CD,                             
                       :D1-BANK-NAME                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           MOVE SQLCODE                         TO WS-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR              
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF WS-NULL-INDICATOR-1 EQUAL -1                       
                     MOVE SPACES                TO YB-BANK-POST-DT      
                  END-IF                                                
                  IF YB-CODE-DR-CR = WS-C                               
                     MULTIPLY -1 BY YB-TRANSFER-AMT                     
                  END-IF                                                
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7200'                      TO ACTIVE-PARAGRAPH     
               MOVE 'FETCH'                     TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
               MOVE 'CSS_BANK_TRANSFER'         TO TABLE-1              
               MOVE 'CSS_BANK'                  TO TABLE-2              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE YB-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YB-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YB-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7300-CLOSE-BANK-TRNXFR-CURSOR                               *        
      *                                                                *        
      *    TO CLOSE THE BANK_TRNXFR_CURSOR                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7300-CLOSE-BANK-TRNXFR-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
                CLOSE  BANK_TRNXFR_CURSOR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7300'                      TO ACTIVE-PARAGRAPH     
               MOVE 'CLOSE'                     TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
               MOVE 'CSS_BANK_TRANSFER'         TO TABLE-1              
               MOVE 'CSS_BANK'                  TO TABLE-2              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE YB-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YB-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YB-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42800000
      ******************************************************************11340087
      *    THIS PARA IS TO GET THE USER PROFILE SUCH AS FULL NAME       11350087
      ******************************************************************11360087
       7400-GET-USER-PROFILE.                                           
           EXEC SQL                                                     
                SELECT RTRIM(PF.LAST_NAME) + ', ' + RTRIM(PF.FIRST_NAME
           ) + ' ' + RTRIM(PF.MIDDLE_NAME)                            
                INTO   :WS-CASHIER-FULL-NAME                            
                FROM  CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE USER_ID = :PF-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     11380050
MFA-TR*         SELECT RTRIM(PF.LAST_NAME) || ', ' ||                   11390050
MFA-TR*                RTRIM(PF.FIRST_NAME) || ' ' ||                           
MFA-TR*                RTRIM(PF.MIDDLE_NAME)                                    
MFA-TR*         INTO   :WS-CASHIER-FULL-NAME                                    
MFA-TR*         FROM  CSS_USER_PROFILE PF                               11440050
MFA-TR*         WHERE USER_ID = :PF-USER-ID                             11450051
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                    11460050

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_USER_PROFILE'         TO TABLE-1               
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-1       
               MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************42800000
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************42800000
       8000A-DELETE-GTT-ROWS.                                           
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04758_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04758_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04758_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 42800000
      ******************************************************************42800000
      *8100-SEND-RESULT.                                               *        
      ******************************************************************42800000
       8100-SEND-RESULT.                                                
      *                                                                 42800000
           EXEC SQL                                                     
                 INSERT INTO #CSR04758_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,BANK_NO                                           
                     ,BANK_NAME                                         
                     ,CASH_AMOUNT                                       
                     ,CHECK_MO_AMOUNT                                   
                     ,TOTAL_AMOUNT                                      
                     ,USER_ID                                           
                     ,CASHIER_FULL_NAME                                 
                     ,CASH_DRAWER_ID                                    
                     ,REPORT_STATUS                                     
                     ,TRANSFER_TS                                       
                     ,BANK_POST_DT                                      
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-BANK-NO                                        
                     ,:S-BANK-NAME                                      
                     ,:S-CASH-AMOUNT                                    
                     ,:S-CHECK-MO-AMOUNT                                
                     ,:S-TOTAL-AMOUNT                                   
                     ,:S-USER-ID                                        
                     ,:S-CASHIER-FULL-NAME                              
                     ,:S-CASH-DRAWER-ID                                 
                     ,:S-REPORT-STATUS                                  
                     ,:S-TRANSFER-TS                                    
                     ,:S-BANK-POST-DT                                   
                 )                                                      
                 END-EXEC.                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*          INSERT INTO SESSION.CSR04758_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,BANK_NO                                                   
MFA-TR*              ,BANK_NAME                                                 
MFA-TR*              ,CASH_AMOUNT                                               
MFA-TR*              ,CHECK_MO_AMOUNT                                           
MFA-TR*              ,TOTAL_AMOUNT                                              
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,CASHIER_FULL_NAME                                         
MFA-TR*              ,CASH_DRAWER_ID                                            
MFA-TR*              ,REPORT_STATUS                                             
MFA-TR*              ,TRANSFER_TS                                               
MFA-TR*              ,BANK_POST_DT                                              
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-BANK-NO                                                
MFA-TR*              ,:S-BANK-NAME                                              
MFA-TR*              ,:S-CASH-AMOUNT                                            
MFA-TR*              ,:S-CHECK-MO-AMOUNT                                        
MFA-TR*              ,:S-TOTAL-AMOUNT                                           
MFA-TR*              ,:S-USER-ID                                                
MFA-TR*              ,:S-CASHIER-FULL-NAME                                      
MFA-TR*              ,:S-CASH-DRAWER-ID                                         
MFA-TR*              ,:S-REPORT-STATUS                                          
MFA-TR*              ,:S-TRANSFER-TS                                            
MFA-TR*              ,:S-BANK-POST-DT                                           
MFA-TR*          )                                                              
MFA-TR*          END-EXEC.                                                      

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                    TO CTR-ROWS                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04758_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************42800000
      * 9700 -  ABEND HANDLING ROUTINE                                 *42810000
      ******************************************************************42820000
                                                                        
           EXEC SQL                                                     01720000
               INCLUDE CPD0023C                                         01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
