       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04757.                                         
       AUTHOR.        AARON ABRAHAM.                                    
COB303 DATE-WRITTEN.  MAY 07, 2014.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  CSR04757 RETRIEVE SP FOR RECONNECT                                     
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  RETRIEVES ROWS FROM CSS_RECONNECT_CHRG & CSS_RECONNECT_TERM   *        
      *  INVOKED FROM RECONNECT BUSOP REQUGETRECONNECTTYPECHARGES.     *        
      *  RESULTS SETS:                                                 *        
      *     1.  RECONNECT DETAILS                                      *        
      *     2.  BUSINESS RULES                                         *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00726*  03/04/13  AA97148    INITIAL IMPLEMENTATION.                  *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04757'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR CSR04757 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08)  VALUE 'CSR04757'.   
           05  WS-PGRMNAME               PIC X(08)  VALUE 'CSR04757'.   
           05  WS-RCNCT-TERM-ID          PIC S9(4)  COMP VALUE 0.       
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-MORE-CHRG-TERM         PIC X(01)  VALUE 'Y'.          
               88 NO-MORE-CHRG-TERM-ROWS            VALUE 'N'.          
           05  WS-MORE-BUS-RULE          PIC X(01)  VALUE 'Y'.          
               88 NO-MORE-BUS-RULE-ROWS             VALUE 'N'.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9)  COMP VALUE 0.       
           05  CTR-ROWS-RS2              PIC S9(9)  COMP VALUE 0.       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-R1-RETURN-CODE        PIC S9(9)  COMP VALUE 0.      
               10 S-R1-RCNCT-TYPE-NO      PIC X(05)  VALUE SPACES.      
               10 S-R1-COMPANY-NO         PIC X(03)  VALUE SPACES.      
               10 S-R1-RCNCT-ELEC-SVC-FL  PIC X(01)  VALUE SPACES.      
               10 S-R1-RCNCT-GAS-SVC-FL   PIC X(01)  VALUE SPACES.      
               10 S-R1-RCNCT-WTR-SVC-FL   PIC X(01)  VALUE SPACES.      
               10 S-R1-RCNCT-SWR-SVC-FL   PIC X(01)  VALUE SPACES.      
               10 S-R1-RCNCT-NRML-HRS-FL  PIC X(01)  VALUE SPACES.      
               10 S-R1-RCNCT-CHRG-AM      PIC S9(7)V9(2) COMP-3 VALUE 0.
               10 S-R1-RCNCT-TYPE-TX      PIC X(75)  VALUE SPACES.      
               10 S-R1-RCNCT-ACCT-TYPE-CD PIC X(01)  VALUE SPACES.      
               10 S-R1-RCNCT-TERM-ID      PIC S9(4)  COMP VALUE 0.      
               10 S-R1-PYMT-TIME-RANGE-CD PIC X(02)  VALUE SPACES.      
               10 S-R1-RCNCT-SAME-DAY-FL  PIC X(01)  VALUE SPACES.      
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-R2-RETURN-CODE        PIC S9(9)  COMP VALUE 0.      
               10 S-R2-BUS-RULE-ID        PIC X(10)  VALUE SPACES.      
               10 S-R2-RCNCT-TERM-ID      PIC S9(4)  COMP VALUE 0.      
               10 S-R2-SORT-ORDER         PIC S9(9)  COMP VALUE 0.      
                                                                        
       01  CSRERLOG-P.                                                  
           05  S-SP-NAME                 PIC X(18)  VALUE SPACES.       
           05  S-SQLCODE                 PIC S9(9)  COMP  VALUE 0.      
           05  S-SQLSTATE                PIC X(5)   VALUE ' '.          
           05  S-TABLE-NAME              PIC X(18)  VALUE SPACES.       
           05  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4)  USAGE COMP.         
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           05  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4)  USAGE COMP.         
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           05  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4)  USAGE COMP.         
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           05  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4)  USAGE COMP.         
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           05  WS-SQLSTATE               PIC X(05)  VALUE SPACES.       
           05  WS-GTT-NAME               PIC X(19)  VALUE SPACES.       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RECONNECT       - DL                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RECONNECT_CHRG  - U7                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RECONNECT_TERM  - 3T                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRECTRM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RECON_BUS_RULE  - 5L                                    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRECRUL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CWS00056.                                               01680000
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00309                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE CWS00309                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO GET RECONNECT CHARGES AND TERM DTAILS.    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE RCNCT_CHRG_TERM CURSOR FOR                        
                 SELECT U7.RCNCT_TYPE_NO                                
                       ,U7.COMPANY_NO                                   
                       ,U7.RCNCT_ELEC_SVC_FL                            
                       ,U7.RCNCT_GAS_SVC_FL                             
                       ,U7.RCNCT_WTR_SVC_FL                             
                       ,U7.RCNCT_SWR_SVC_FL                             
                       ,U7.RCNCT_NRML_HRS_FL                            
                       ,U7.RCNCT_CHRG_AM                                
                       ,U7.RCNCT_TYPE_TX                                
                       ,U7.RCNCT_ACCT_TYPE_CD                           
                       ,[3T].RCNCT_TERM_ID                                
                       ,[3T].PYMT_TIME_RANGE_CD                           
                       ,[3T].RCNCT_SAME_DAY_FL                            
                   FROM CSS_RECONNECT_CHRG U7 WITH(READUNCOMMITTED)             
                       ,CSS_RECONNECT_TERM [3T] WITH(READUNCOMMITTED)           
                  WHERE U7.RCNCT_TYPE_NO      = [3T].RCNCT_TYPE_NO        
                    AND U7.COMPANY_NO         = [3T].COMPANY_NO           
                    AND U7.RCNCT_ACCT_TYPE_CD = [3T].RCNCT_ACCT_TYPE_CD   
                    AND [3T].RCNCT_TERM_EFF_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                    AND [3T].RCNCT_TERM_EXP_DT >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RCNCT_CHRG_TERM CURSOR FOR                                
MFA-TR*          SELECT U7.RCNCT_TYPE_NO                                        
MFA-TR*                ,U7.COMPANY_NO                                           
MFA-TR*                ,U7.RCNCT_ELEC_SVC_FL                                    
MFA-TR*                ,U7.RCNCT_GAS_SVC_FL                                     
MFA-TR*                ,U7.RCNCT_WTR_SVC_FL                                     
MFA-TR*                ,U7.RCNCT_SWR_SVC_FL                                     
MFA-TR*                ,U7.RCNCT_NRML_HRS_FL                                    
MFA-TR*                ,U7.RCNCT_CHRG_AM                                        
MFA-TR*                ,U7.RCNCT_TYPE_TX                                        
MFA-TR*                ,U7.RCNCT_ACCT_TYPE_CD                                   
MFA-TR*                ,3T.RCNCT_TERM_ID                                        
MFA-TR*                ,3T.PYMT_TIME_RANGE_CD                                   
MFA-TR*                ,3T.RCNCT_SAME_DAY_FL                                    
MFA-TR*            FROM CSS_RECONNECT_CHRG U7                                   
MFA-TR*                ,CSS_RECONNECT_TERM 3T                                   
MFA-TR*           WHERE U7.RCNCT_TYPE_NO      = 3T.RCNCT_TYPE_NO                
MFA-TR*             AND U7.COMPANY_NO         = 3T.COMPANY_NO                   
MFA-TR*             AND U7.RCNCT_ACCT_TYPE_CD = 3T.RCNCT_ACCT_TYPE_CD           
MFA-TR*             AND 3T.RCNCT_TERM_EFF_DT <= CURRENT DATE                    
MFA-TR*             AND 3T.RCNCT_TERM_EXP_DT >= CURRENT DATE                    
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO GET RECONNECT BUSINESS RULES              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE BUS_RULE CURSOR FOR                               
                 SELECT [5L].BUS_RULE_ID                                  
                       ,[5L].RCNCT_TERM_ID                                
                       ,[5L].SORT_ORDER                                   
                   FROM CSS_RECON_BUS_RULE [5L] WITH(READUNCOMMITTED)           
                  WHERE [5L].RCNCT_TERM_ID    = :WS-RCNCT-TERM-ID         
                    AND [5L].BUS_RULE_EFF_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)              
                    AND [5L].BUS_RULE_EXP_DT >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)              
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BUS_RULE CURSOR FOR                                       
MFA-TR*          SELECT 5L.BUS_RULE_ID                                          
MFA-TR*                ,5L.RCNCT_TERM_ID                                        
MFA-TR*                ,5L.SORT_ORDER                                           
MFA-TR*            FROM CSS_RECON_BUS_RULE 5L                                   
MFA-TR*           WHERE 5L.RCNCT_TERM_ID    = :WS-RCNCT-TERM-ID                 
MFA-TR*             AND 5L.BUS_RULE_EFF_DT <= CURRENT DATE                      
MFA-TR*             AND 5L.BUS_RULE_EXP_DT >= CURRENT DATE                      
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7540                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
                                                                        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04757_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04757_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04757_R1
              (                                                          
                  RETURN_CODE           INT                         
                 ,RCNCT_TYPE_NO CHAR(05)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,COMPANY_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,RCNCT_ELEC_SVC_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_GAS_SVC_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_WTR_SVC_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_SWR_SVC_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_NRML_HRS_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_CHRG_AM         DECIMAL(9,2)                   
                 ,RCNCT_TYPE_TX CHAR(75)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_ACCT_TYPE_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_TERM_ID         SMALLINT                        
                 ,PYMT_TIME_RANGE_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,RCNCT_SAME_DAY_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,LTRIM(RTRIM(RCNCT_TYPE_NO))      AS RCNCT_TYPE_NO            
                 ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO               
                 ,LTRIM(RTRIM(RCNCT_ELEC_SVC_FL))  AS RCNCT_ELEC_SVC_FL        
                 ,LTRIM(RTRIM(RCNCT_GAS_SVC_FL))   AS RCNCT_GAS_SVC_FL         
                 ,LTRIM(RTRIM(RCNCT_WTR_SVC_FL))   AS RCNCT_WTR_SVC_FL         
                 ,LTRIM(RTRIM(RCNCT_SWR_SVC_FL))   AS RCNCT_SWR_SVC_FL         
                 ,LTRIM(RTRIM(RCNCT_NRML_HRS_FL))  AS RCNCT_NRML_HRS_FL        
                 ,RCNCT_CHRG_AM                                         
                 ,LTRIM(RTRIM(RCNCT_TYPE_TX))      AS RCNCT_TYPE_TX            
                 ,LTRIM(RTRIM(RCNCT_ACCT_TYPE_CD)) AS RCNCT_ACCT_TYPE_CD       
                 ,RCNCT_TERM_ID                                         
                 ,LTRIM(RTRIM(PYMT_TIME_RANGE_CD)) AS PYMT_TIME_RANGE_CD       
                 ,LTRIM(RTRIM(RCNCT_SAME_DAY_FL))  AS RCNCT_SAME_DAY_FL        
               FROM #CSR04757_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(RCNCT_TYPE_NO)      AS RCNCT_TYPE_NO                    
MFA-TR*          ,STRIP(COMPANY_NO)         AS COMPANY_NO                       
MFA-TR*          ,STRIP(RCNCT_ELEC_SVC_FL)  AS RCNCT_ELEC_SVC_FL                
MFA-TR*          ,STRIP(RCNCT_GAS_SVC_FL)   AS RCNCT_GAS_SVC_FL                 
MFA-TR*          ,STRIP(RCNCT_WTR_SVC_FL)   AS RCNCT_WTR_SVC_FL                 
MFA-TR*          ,STRIP(RCNCT_SWR_SVC_FL)   AS RCNCT_SWR_SVC_FL                 
MFA-TR*          ,STRIP(RCNCT_NRML_HRS_FL)  AS RCNCT_NRML_HRS_FL                
MFA-TR*          ,RCNCT_CHRG_AM                                                 
MFA-TR*          ,STRIP(RCNCT_TYPE_TX)      AS RCNCT_TYPE_TX                    
MFA-TR*          ,STRIP(RCNCT_ACCT_TYPE_CD) AS RCNCT_ACCT_TYPE_CD               
MFA-TR*          ,RCNCT_TERM_ID                                                 
MFA-TR*          ,STRIP(PYMT_TIME_RANGE_CD) AS PYMT_TIME_RANGE_CD               
MFA-TR*          ,STRIP(RCNCT_SAME_DAY_FL)  AS RCNCT_SAME_DAY_FL                
MFA-TR*        FROM SESSION.CSR04757_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04757_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04757_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04757_R2
              (                                                          
                  RETURN_CODE               INT                     
                 ,BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,RCNCT_TERM_ID             SMALLINT                    
                 ,SORT_ORDER                INT                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,LTRIM(RTRIM(BUS_RULE_ID))       AS BUS_RULE_ID               
                 ,RCNCT_TERM_ID                                         
                 ,SORT_ORDER                                            
               FROM #CSR04757_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(BUS_RULE_ID)       AS BUS_RULE_ID                       
MFA-TR*          ,RCNCT_TERM_ID                                                 
MFA-TR*          ,SORT_ORDER                                                    
MFA-TR*        FROM SESSION.CSR04757_R2                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 'Y'                         TO WS-MORE-CHRG-TERM.       
                                                                        
           PERFORM 7500-OPEN-CHRG-TERM-CURSOR         THRU 7500-EXIT.   
           PERFORM 7510-FETCH-CHRG-TERM-CURSOR        THRU 7510-EXIT.   
           PERFORM 2010-PROCESS-CHRG-TERM             THRU 2010-EXIT    
             UNTIL NO-MORE-CHRG-TERM-ROWS                               
           PERFORM 7520-CLOSE-CHRG-TERM-CURSOR        THRU 7520-EXIT.   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010-PROCESS-CHRG-TERM                                         *        
      ******************************************************************        
                                                                        
       2010-PROCESS-CHRG-TERM.                                          
                                                                        
           PERFORM 2020-BUILD-RESULTS-1               THRU 2020-EXIT.   
           MOVE 3T-RCNCT-TERM-ID            TO WS-RCNCT-TERM-ID.        
           MOVE 'Y'                         TO WS-MORE-BUS-RULE.        
                                                                        
           PERFORM 7530-OPEN-BUS-RULE-CURSOR          THRU 7530-EXIT.   
           PERFORM 7540-FETCH-BUS-RULE-CURSOR         THRU 7540-EXIT.   
           PERFORM 2030-PROCESS-BUSINESS-RULE         THRU 2030-EXIT    
             UNTIL NO-MORE-BUS-RULE-ROWS                                
           PERFORM 7550-CLOSE-BUS-RULE-CURSOR         THRU 7550-EXIT.   
                                                                        
           PERFORM 7510-FETCH-CHRG-TERM-CURSOR        THRU 7510-EXIT.   
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2020-BUILD-RESULTS-1                                           *        
      ******************************************************************        
                                                                        
       2020-BUILD-RESULTS-1.                                            
                                                                        
           MOVE U7-RCNCT-TYPE-NO            TO S-R1-RCNCT-TYPE-NO.      
           MOVE U7-COMPANY-NO               TO S-R1-COMPANY-NO.         
           MOVE U7-RCNCT-ELEC-SVC-FL        TO S-R1-RCNCT-ELEC-SVC-FL.  
           MOVE U7-RCNCT-GAS-SVC-FL         TO S-R1-RCNCT-GAS-SVC-FL.   
           MOVE U7-RCNCT-WTR-SVC-FL         TO S-R1-RCNCT-WTR-SVC-FL.   
           MOVE U7-RCNCT-SWR-SVC-FL         TO S-R1-RCNCT-SWR-SVC-FL.   
           MOVE U7-RCNCT-NRML-HRS-FL        TO S-R1-RCNCT-NRML-HRS-FL.  
           MOVE U7-RCNCT-CHRG-AM            TO S-R1-RCNCT-CHRG-AM.      
           MOVE U7-RCNCT-TYPE-TX            TO S-R1-RCNCT-TYPE-TX.      
           MOVE U7-RCNCT-ACCT-TYPE-CD       TO S-R1-RCNCT-ACCT-TYPE-CD. 
           MOVE 3T-RCNCT-TERM-ID            TO S-R1-RCNCT-TERM-ID.      
           MOVE 3T-PYMT-TIME-RANGE-CD       TO S-R1-PYMT-TIME-RANGE-CD. 
           MOVE 3T-RCNCT-SAME-DAY-FL        TO S-R1-RCNCT-SAME-DAY-FL.  
                                                                        
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2030-PROCESS-BUSINESS-RULE                                     *        
      ******************************************************************        
                                                                        
       2030-PROCESS-BUSINESS-RULE.                                      
                                                                        
           PERFORM 2040-BUILD-RESULTS-2               THRU 2040-EXIT.   
                                                                        
           PERFORM 7540-FETCH-BUS-RULE-CURSOR         THRU 7540-EXIT.   
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2040-BUILD-RESULTS-2                                           *        
      ******************************************************************        
                                                                        
       2040-BUILD-RESULTS-2.                                            
                                                                        
           MOVE 5L-BUS-RULE-ID              TO S-R2-BUS-RULE-ID.        
           MOVE 5L-RCNCT-TERM-ID            TO S-R2-RCNCT-TERM-ID.      
           MOVE 5L-SORT-ORDER               TO S-R2-SORT-ORDER.         
                                                                        
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-CHRG-TERM-CURSOR                                              
      ******************************************************************        
                                                                        
       7500-OPEN-CHRG-TERM-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN RCNCT_CHRG_TERM                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7500'               TO ACTIVE-PARAGRAPH       
                    MOVE 'OPEN'               TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_RECONNECT_CHRG' TO TABLE-1                
                    MOVE 'CSS_RECONNECT_TERM' TO TABLE-2                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-CHRG-TERM-CURSOR                                             
      ******************************************************************        
                                                                        
       7510-FETCH-CHRG-TERM-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH RCNCT_CHRG_TERM                                    
                INTO :U7-RCNCT-TYPE-NO                                  
                    ,:U7-COMPANY-NO                                     
                    ,:U7-RCNCT-ELEC-SVC-FL                              
                    ,:U7-RCNCT-GAS-SVC-FL                               
                    ,:U7-RCNCT-WTR-SVC-FL                               
                    ,:U7-RCNCT-SWR-SVC-FL                               
                    ,:U7-RCNCT-NRML-HRS-FL                              
                    ,:U7-RCNCT-CHRG-AM                                  
                    ,:U7-RCNCT-TYPE-TX                                  
                    ,:U7-RCNCT-ACCT-TYPE-CD                             
                    ,:3T-RCNCT-TERM-ID                                  
                    ,:3T-PYMT-TIME-RANGE-CD                             
                    ,:3T-RCNCT-SAME-DAY-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-CHRG-TERM-ROWS   TO TRUE                
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7510'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_RECONNECT_CHRG' TO TABLE-1                
                    MOVE 'CSS_RECONNECT_TERM' TO TABLE-2                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-CHRG-TERM-CURSOR                                             
      ******************************************************************        
                                                                        
       7520-CLOSE-CHRG-TERM-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE RCNCT_CHRG_TERM                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7520'               TO ACTIVE-PARAGRAPH       
                    MOVE 'CLOSE'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_RECONNECT_CHRG' TO TABLE-1                
                    MOVE 'CSS_RECONNECT_TERM' TO TABLE-2                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7530-OPEN-BUS-RULE-CURSOR                                               
      ******************************************************************        
                                                                        
       7530-OPEN-BUS-RULE-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN BUS_RULE                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7530'               TO ACTIVE-PARAGRAPH       
                    MOVE 'OPEN'               TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_RECON_BUS_RULE' TO TABLE-1                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7540-FETCH-BUS-RULE-CURSOR                                              
      ******************************************************************        
                                                                        
       7540-FETCH-BUS-RULE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH BUS_RULE                                           
                INTO :5L-BUS-RULE-ID                                    
                    ,:5L-RCNCT-TERM-ID                                  
                    ,:5L-SORT-ORDER                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-BUS-RULE-ROWS TO TRUE                   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7540'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_RECON_BUS_RULE' TO TABLE-1                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-CLOSE-BUS-RULE-CURSOR                                              
      ******************************************************************        
                                                                        
       7550-CLOSE-BUS-RULE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE BUS_RULE                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7550'               TO ACTIVE-PARAGRAPH       
                    MOVE 'CLOSE'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_RECON_BUS_RULE' TO TABLE-1                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04757_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04757_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04757_R1'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04757_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04757_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000B'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04757_R2'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04757_R1                            
             (                                                          
              RETURN_CODE                                               
             ,RCNCT_TYPE_NO                                             
             ,COMPANY_NO                                                
             ,RCNCT_ELEC_SVC_FL                                         
             ,RCNCT_GAS_SVC_FL                                          
             ,RCNCT_WTR_SVC_FL                                          
             ,RCNCT_SWR_SVC_FL                                          
             ,RCNCT_NRML_HRS_FL                                         
             ,RCNCT_CHRG_AM                                             
             ,RCNCT_TYPE_TX                                             
             ,RCNCT_ACCT_TYPE_CD                                        
             ,RCNCT_TERM_ID                                             
             ,PYMT_TIME_RANGE_CD                                        
             ,RCNCT_SAME_DAY_FL                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R1-RETURN-CODE                                         
             ,:S-R1-RCNCT-TYPE-NO                                       
             ,:S-R1-COMPANY-NO                                          
             ,:S-R1-RCNCT-ELEC-SVC-FL                                   
             ,:S-R1-RCNCT-GAS-SVC-FL                                    
             ,:S-R1-RCNCT-WTR-SVC-FL                                    
             ,:S-R1-RCNCT-SWR-SVC-FL                                    
             ,:S-R1-RCNCT-NRML-HRS-FL                                   
             ,:S-R1-RCNCT-CHRG-AM                                       
             ,:S-R1-RCNCT-TYPE-TX                                       
             ,:S-R1-RCNCT-ACCT-TYPE-CD                                  
             ,:S-R1-RCNCT-TERM-ID                                       
             ,:S-R1-PYMT-TIME-RANGE-CD                                  
             ,:S-R1-RCNCT-SAME-DAY-FL                                   
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04757_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,RCNCT_TYPE_NO                                                     
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,RCNCT_ELEC_SVC_FL                                                 
MFA-TR*      ,RCNCT_GAS_SVC_FL                                                  
MFA-TR*      ,RCNCT_WTR_SVC_FL                                                  
MFA-TR*      ,RCNCT_SWR_SVC_FL                                                  
MFA-TR*      ,RCNCT_NRML_HRS_FL                                                 
MFA-TR*      ,RCNCT_CHRG_AM                                                     
MFA-TR*      ,RCNCT_TYPE_TX                                                     
MFA-TR*      ,RCNCT_ACCT_TYPE_CD                                                
MFA-TR*      ,RCNCT_TERM_ID                                                     
MFA-TR*      ,PYMT_TIME_RANGE_CD                                                
MFA-TR*      ,RCNCT_SAME_DAY_FL                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R1-RETURN-CODE                                                 
MFA-TR*      ,:S-R1-RCNCT-TYPE-NO                                               
MFA-TR*      ,:S-R1-COMPANY-NO                                                  
MFA-TR*      ,:S-R1-RCNCT-ELEC-SVC-FL                                           
MFA-TR*      ,:S-R1-RCNCT-GAS-SVC-FL                                            
MFA-TR*      ,:S-R1-RCNCT-WTR-SVC-FL                                            
MFA-TR*      ,:S-R1-RCNCT-SWR-SVC-FL                                            
MFA-TR*      ,:S-R1-RCNCT-NRML-HRS-FL                                           
MFA-TR*      ,:S-R1-RCNCT-CHRG-AM                                               
MFA-TR*      ,:S-R1-RCNCT-TYPE-TX                                               
MFA-TR*      ,:S-R1-RCNCT-ACCT-TYPE-CD                                          
MFA-TR*      ,:S-R1-RCNCT-TERM-ID                                               
MFA-TR*      ,:S-R1-PYMT-TIME-RANGE-CD                                          
MFA-TR*      ,:S-R1-RCNCT-SAME-DAY-FL                                           
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04757_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04757_R2                            
             (                                                          
              RETURN_CODE                                               
             ,BUS_RULE_ID                                               
             ,RCNCT_TERM_ID                                             
             ,SORT_ORDER                                                
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R2-RETURN-CODE                                         
             ,:S-R2-BUS-RULE-ID                                         
             ,:S-R2-RCNCT-TERM-ID                                       
             ,:S-R2-SORT-ORDER                                          
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04757_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BUS_RULE_ID                                                       
MFA-TR*      ,RCNCT_TERM_ID                                                     
MFA-TR*      ,SORT_ORDER                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R2-RETURN-CODE                                                 
MFA-TR*      ,:S-R2-BUS-RULE-ID                                                 
MFA-TR*      ,:S-R2-RCNCT-TERM-ID                                               
MFA-TR*      ,:S-R2-SORT-ORDER                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS2            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04757_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-R1-RETURN-CODE         
                                               S-R2-RETURN-CODE.        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT.            
                                                                        
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS-RS1 < 1 AND                                      
              CTR-ROWS-RS2 < 1                                          
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
                                                                        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
