       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04756.                                         
COB303 DATE-WRITTEN.  MARCH 2014.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00080000
      *                                                                *00090000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00100000
      *                                                                *00090000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES THE DATA FROM THE CASH DRAWER JOURNAL*00190002
      *  TABLE.                                                        *00110000
      *  BUSOP NAME:   GETCASHDRAWERJOURNALDTLS                        *00110000
      *                                                                *00150000
      ******************************************************************00180000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM RETRIEVES THE DATA FROM THE CASH JOURNAL TABLE   *00210000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
PRJ586*  03/26/14  CB18344    THIS PROCEDURE WAS WRITTEN TO USE IN     *00270002
      *                       CIS MODERNIZATION TO RETRIEVE JOURNAL    *00270002
      *                       TRANSACTIONS.                            *        
      *                       CLONED FROM CSR02390.                    *        
PRJ586*  10/20/14  CB18344    ADDED LAST-UPDATE-TS TO RESULT SET       *00270002
PRJ586*  11/14/14  CB18344    CHANGED SELECT STATEMENT IN PARAGRAPH    *00270002
      *                       2210 TO USE PYMT_RCVD_TS INSTEAD OF      *00270002
      *                       APPLIED_TS TO REFLECT ALL CREDIT CARD    *00270002
      *                       TOTALS.                                  *00270002
PDSUPP*  10/19/15  CB18344    MADE CHANGE TO SELECT STATEMENT IN PARA  *00270002
      *                       2210 FOR PERFORMANCE.                    *00270002
      *                       DEFECT 9431                              *00270002
PRJ586*  03/21/16  CB18344    ADDED METER NO TO SELECT FOR VOUCHER     *00270002
PRJ586*                       REIMBURSEMENT                            *00270002
PRJ586*  06/02/16  CB18344    ADDED MISC PAYMENT TRANS ID TO QUERY FOR *00270002
PRJ586*                       SETTING CIS-PAYMENT-IND FLAG             *00270002
      ******************************************************************01310000
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04756'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04756 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
           COPY CWS00303.                                               01700000
           COPY CJF00101.                                               01700000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  WS-HDR-COUNT-FLAG        PIC X(01)  VALUE 'N'.           
           05  CTR-COLUMN               PIC S9(9)  COMP VALUE 1.        
           05  CTR-ROWS-RS1             PIC S9(9)  COMP VALUE 0.        
           05  CTR-ROWS-RS2             PIC S9(9)  COMP VALUE 0.        
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9)  COMP.                
           05  WRKLEN1                  PIC S9(9)  COMP.                
           05  WRKLEN2                  PIC S9(9)  COMP.                
           05  WRK-DONE-STATUS          PIC S9(9)  COMP.                
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC  X(08)  VALUE 'CSR04756'.    
           05  WS-GTT-NAME             PIC  X(19)  VALUE SPACES.        
           05  WS-SQLSTATE             PIC  X(05).                      
           05  WS-ZERO                 PIC  X(01)  VALUE '0'.           
           05  WS-ONE                  PIC  S9(01) VALUE +1.            
           05  ALL-DONE-SW             PIC  X(01)  VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW            PIC  X(01)  VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-COUNT-1              PIC S9(9)   COMP VALUE 0.        
           05  WS-COUNT-2              PIC S9(9)   COMP VALUE 0.        
           05  WS-RETURN-CODE-1        PIC S9(4)   COMP VALUE 0.        
           05  WS-RETURN-CODE-2        PIC S9(4)   COMP VALUE 0.        
                                                                        
                                                                        
       01  WS-NULL-IND.                                                 
           05 WS-NULL-IND1             PIC S9(04)  COMP VALUE +0.       
           05 WS-NULL-IND2             PIC S9(04)  COMP VALUE +0.       
           05 WS-NULL-IND3             PIC S9(04)  COMP VALUE +0.       
           05 WS-NULL-IND4             PIC S9(04)  COMP VALUE +0.       
PRJ586     05 WS-NULL-IND5             PIC S9(04)  COMP VALUE +0.       
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-RETURN-CODE           PIC S9(09)       COMP-4.         
           05 WS-PREV-ENTRY-NO         PIC S9(09)       COMP.           
COB305     05 WS-GEN-LED-AMT        PIC S9(09)V9(02) COMP-3 VALUE 0.         
           05 WS-CASH-GL-NUM           PIC X(01).                       
           05 WS-LIHEAP-PMT            PIC X(01).                       
           05 WS-LIHEAP-RVSL           PIC X(01).                       
           05 WS-CLEAR-CASH            PIC X(08)       VALUE 'CLR-CASH'.
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC  9(13).                      
           05 WS-ACCOUNT-NO-COMP3      PIC S9(13)V      COMP-3 VALUE +0.
COB305     05 WS-GL-ACCT-NO        PIC S9(03)V9(04) COMP-3 VALUE 0.         
           05 WS-GL-ACCT-NO-ED         PIC 9(03).9(04).                 
COB305     05 WS-TOTAL-AMOUNT        PIC S9(11)V9(02) COMP-3 VALUE 0.         
           05 WS-CURRENCY-TYPE         PIC X(01).                       
              88 CASH                                   VALUE 'A'.      
              88 CHECK                                  VALUE 'C'.      
              88 MONEY-ORDER                            VALUE 'M'.      
              88 DRAFT                                  VALUE 'D'.      
          05 WS-RESULT-TYPE            PIC 9(01)        VALUE ZERO.     
             88 WS-RESULT-1                             VALUE 1.        
             88 WS-RESULT-2                             VALUE 2.        
           05 WS-CIS-PAYMENT-IND       PIC X(01).                       
           05 WS-MULTI-BATCH-IND       PIC X(01).                       
           05 WS-BANK-TRANS-TOTAL      PIC S9(11)V9(02) COMP-3 VALUE +0.
           05 WS-BANK-TRANS            PIC S9(11)V9(02) COMP-3 VALUE +0.
           05 WS-MULTI-BATCH-COUNT     PIC S9(04)       COMP VALUE 0.   
           05 WS-CCARD-COUNT           PIC S9(04)       COMP VALUE 0.   
           05 WS-CCARD-TOTAL           PIC S9(11)V9(02) COMP-3 VALUE +0.
           05 WS-DATE-YYYYMMDD.                                         
              10 WS-YY                 PIC X(04).                       
              10 FILLER                PIC X(01).                       
              10 WS-MM                 PIC X(02).                       
              10 FILLER                PIC X(01).                       
              10 WS-DD                 PIC X(02).                       
           05 WS-DATE-TRAN.                                             
              10 WS-DATE-TRAN-MM       PIC X(02).                       
              10 FILLER                PIC X(01)       VALUE '/'.       
              10 WS-DATE-TRAN-DD       PIC X(02).                       
              10 FILLER                PIC X(01)       VALUE '/'.       
              10 WS-DATE-TRAN-YY       PIC X(04).                       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05 WS-YES                   PIC X           VALUE 'Y'.       
           05 WS-NO                    PIC X           VALUE 'N'.       
           05 WS-C                     PIC X           VALUE 'C'.       
           05 WS-INITIAL-VALUE         PIC X           VALUE 'I'.       
           05 WS-GL-ACCT-FLAG          PIC X           VALUE 'N'.       
           05 WS-SEND-ROW              PIC X           VALUE 'C'.       
                                                                        
       01  FILLER                      PIC X(32)       VALUE            
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
      *                                                                         
       01  TDS-RETURN-FIELDS-1.                                         
           05  RS-RETURN-CODE-1        PIC S9(009)     COMP VALUE 0.    
           05  RS-APPL-RETURN-CODE     PIC S9(009)     COMP VALUE 0.    
           05  RS-CASH-LOCAL-OFFICE    PIC X(003).                      
           05  RS-USER-ID              PIC X(007).                      
           05  RS-DATE-TRAN            PIC X(010).                      
           05  RS-CASH-DRAWER-ID       PIC S9(004)     COMP.            
           05  RS-CASH-DRAWER-STAT     PIC X(001).                      
           05  RS-TRAN-TIME            PIC X(008).                      
           05  RS-TRAN-ID              PIC X(004).                      
           05  RS-TRAN-DESC            PIC X(020).                      
           05  RS-ACCOUNT-NO           PIC X(020).                      
COB305     05 RS-CASH-AMOUNT        PIC S9(009)V99 COMP-3 VALUE 0.          
COB305     05 RS-CHECK-MO-AMT        PIC S9(009)V99 COMP-3 VALUE 0.          
COB305     05 RS-OTHER-AMT        PIC S9(009)V99 COMP-3 VALUE 0.          
COB305     05 RS-TOTAL-AMOUNT        PIC S9(011)V99 COMP-3 VALUE 0.          
COB305     05 RS-BANK-TRANS-TOTAL        PIC S9(009)V99 COMP-3 VALUE 0.         
COB305     05 RS-WORK-FUND-TOTAL        PIC S9(013)V99 COMP-3 VALUE 0.          
           05  RS-ENTRY-NO             PIC S9(009)     COMP.            
           05  RS-TRAN-COMMENT         PIC X(210)      VALUE SPACES.    
           05  RS-REVERSED-FLAG        PIC X(001).                      
           05  RS-CIS-PAYMENT-IND      PIC X(001).                      
           05  RS-MULTI-BATCH-IND      PIC X(001).                      
           05  RS-TRAN-TS              PIC X(026).                      
           05  RS-CURRENCY-TYPE        PIC X(001).                      
           05  RS-CODE-PYMT-FACILITY   PIC X(001).                      
           05  RS-CREATED-TS           PIC X(026).                      
PRJ586     05  RS-LAST-UPDATE-TS       PIC X(026).                      
PRJ586     05  RS-METER-NO             PIC X(09).                       
      *                                                                         
       01  TDS-RETURN-FIELDS-2.                                         
           05  RS-RETURN-CODE-2        PIC S9(009)     COMP VALUE 0.    
           05  RS-CREDIT-CARD-COUNT    PIC S9(04)      COMP.            
           05  RS-CREDIT-CARD-AMOUNT   PIC S9(11)V99   COMP-3 VALUE +0. 
      *                                                                         
       01 GTT-RETURN-FIELDS-1.                                          
          05  S-RETURN-CODE-1         PIC S9(009)      COMP VALUE 0.    
          05  S-APPL-RETURN-CODE      PIC S9(009)      COMP VALUE 0.    
          05  S-CASH-LOCAL-OFFICE     PIC X(003).                       
          05  S-USER-ID               PIC X(007).                       
          05  S-DATE-TRAN             PIC X(010).                       
          05  S-CASH-DRAWER-ID        PIC S9(004)      COMP.            
          05  S-CASH-DRAWER-STAT      PIC X(001).                       
          05  S-TRAN-TIME             PIC X(008).                       
          05  S-TRAN-ID               PIC X(004).                       
          05  S-TRAN-DESC             PIC X(020).                       
          05  S-ACCOUNT-NO            PIC X(020).                       
COB305    05 S-CASH-AMOUNT        PIC S9(009)V99 COMP-3 VALUE 0.          
COB305    05 S-CHECK-MO-AMT        PIC S9(009)V99 COMP-3 VALUE 0.          
COB305    05 S-OTHER-AMT        PIC S9(009)V99 COMP-3 VALUE 0.          
COB305    05 S-TOTAL-AMOUNT        PIC S9(011)V99 COMP-3 VALUE 0.          
COB305    05 S-BANK-TRANS-TOTAL        PIC S9(009)V99 COMP-3 VALUE 0.          
COB305    05 S-WORK-FUND-TOTAL        PIC S9(013)V99 COMP-3 VALUE 0.          
          05  S-ENTRY-NO              PIC S9(009)      COMP.            
          05  S-TRAN-COMMENT          PIC X(210)       VALUE SPACES.    
          05  S-REVERSED-FLAG         PIC X(001).                       
          05  S-CIS-PAYMENT-IND       PIC X(001).                       
          05  S-MULTI-BATCH-IND       PIC X(001).                       
          05  S-TRAN-TS               PIC X(026).                       
          05  S-CURRENCY-TYPE         PIC X(001).                       
          05  S-CODE-PYMT-FACILITY    PIC X(001).                       
          05  S-CREATED-TS            PIC X(026).                       
PRJ586    05  S-LAST-UPDATE-TS        PIC X(026).                       
PRJ586    05  S-METER-NO              PIC X(09).                        
                                                                        
       01 GTT-RETURN-FIELDS-2.                                          
          05  S-RETURN-CODE-2         PIC S9(09)       COMP VALUE 0.    
          05  S-CREDIT-CARD-COUNT     PIC S9(04)       COMP.            
          05  S-CREDIT-CARD-AMOUNT    PIC S9(11)V99    COMP-3 VALUE +0. 
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)       VALUE SPACES.    
           10  S-SQLCODE               PIC S9(9)       COMP VALUE 0.    
           10  S-SQLSTATE              PIC X(5)        VALUE ' '.       
           10  S-TABLE-NAME            PIC X(18)       VALUE SPACES.    
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4)       USAGE COMP.      
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4)       USAGE COMP.      
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4)       USAGE COMP.      
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                           05750000
           END-EXEC.                                                    05760000
                                                                        
      *************************************************************             
      *    CSS_ACCOUNT - AT                                       *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBACCT                                         05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_APPL_PGM_DESC - K9                                 *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBPGMDSC                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_BANK_TRANSFER - YB                                 *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBBNKXFR                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_CNTL - CS                                 *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBCDCNTL                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_JRNL - CJ                                 *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE TBCDJRNL                                                
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_GL_ACCT_NO - GO                                    *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE TBGLATNO                                        05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_LIEAP_AGENCY - I5                                  *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBLIAGCY                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_PAYMENT_TRANS - JT                                 *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBPMTRAN                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      *                                                                         
      ******************************************************************        
      *    CURSOR FOR CSS_BANK_TRANSFER                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
            DECLARE BXFER_CURSOR CURSOR FOR                             
             SELECT SUM(TRANSFER_AMT)                                   
                    ,CODE_DR_CR                                         
               FROM CSS_BANK_TRANSFER                                   
              WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID              
              GROUP BY CODE_DR_CR                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BXFER_CURSOR CURSOR FOR                                     
MFA-TR*      SELECT SUM(TRANSFER_AMT)                                           
MFA-TR*             ,CODE_DR_CR                                                 
MFA-TR*        FROM CSS_BANK_TRANSFER                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                      
MFA-TR*       GROUP BY CODE_DR_CR                                               
MFA-TR*     QUERYNO 7010                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************06900000
      *    CURSOR FOR CSS_CSH_DRWR_JRNL                                *06910000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE JOURNAL_CURSOR  CURSOR FOR                      
                 SELECT DATE_TRAN                                       
                        ,REPLACE(REPLACE(CONVERT(CHAR(26), TRAN_TS
           , 121), ' ', '-'), ':', '.') TRAN_TS                                
                        ,REPLACE(CONVERT(CHAR(8), TRAN_TIME, 108), ':', 
           '.') TRAN_TIME                                      
                        ,TRAN_ID                                        
                        ,ACCOUNT_NO                                     
                        ,CURRENCY_TYPE                                  
                        ,CODE_PYMT_FACILITY                             
                        ,TRAN_DATA                                      
                        ,ENTRY_NO                                       
                        ,TRAN_APPL_NO                                   
                        ,TRAN_COMMENT                                   
                        ,REVERSED_FL                                    
                        ,METER_NO                                       
                   FROM CSS_CSH_DRWR_JRNL                               
                  WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO      
                    AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE    
                    AND DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )     
                    AND CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID       
               ORDER BY DATE_TRAN DESC                                  
                        ,TRAN_TS DESC                                   
                        ,TRAN_TIME DESC                                 
                        ,ENTRY_NO ASC                                   
                        ,TRAN_APPL_NO ASC                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*         DECLARE JOURNAL_CURSOR  CURSOR FOR                      06930000
MFA-TR*          SELECT DATE_TRAN                                       06940000
MFA-TR*                 ,TRAN_TS                                                
MFA-TR*                 ,TRAN_TIME                                              
MFA-TR*                 ,TRAN_ID                                        06950000
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,CURRENCY_TYPE                                          
MFA-TR*                 ,CODE_PYMT_FACILITY                                     
MFA-TR*                 ,TRAN_DATA                                              
MFA-TR*                 ,ENTRY_NO                                               
MFA-TR*                 ,TRAN_APPL_NO                                           
MFA-TR*                 ,TRAN_COMMENT                                           
MFA-TR*                 ,REVERSED_FL                                            
MFA-TR*                 ,METER_NO                                               
MFA-TR*            FROM CSS_CSH_DRWR_JRNL                                       
MFA-TR*           WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO              
MFA-TR*             AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE            
MFA-TR*             AND DATE_CASH_REPORT     = :CJ-DATE-CASH-REPORT             
MFA-TR*             AND CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID               
MFA-TR*        ORDER BY DATE_TRAN DESC                                          
MFA-TR*                 ,TRAN_TS DESC                                           
MFA-TR*                 ,TRAN_TIME DESC                                         
MFA-TR*                 ,ENTRY_NO ASC                                           
MFA-TR*                 ,TRAN_APPL_NO ASC                                       
MFA-TR*     QUERYNO 7060                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************06900000
      *    CURSOR FOR CSS_CSH_DRWR_JRNL FOR CASHIER                    *06910000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE CASHIER_JOURNAL_CURSOR  CURSOR FOR              
                 SELECT DATE_TRAN                                       
                        ,REPLACE(REPLACE(CONVERT(CHAR(26), TRAN_TS
           , 121), ' ', '-'), ':', '.') TRAN_TS                                
                        ,REPLACE(CONVERT(CHAR(8), TRAN_TIME, 108), ':', 
           '.') TRAN_TIME                                      
                        ,TRAN_ID                                        
                        ,ACCOUNT_NO                                     
                        ,CURRENCY_TYPE                                  
                        ,CODE_PYMT_FACILITY                             
                        ,TRAN_DATA                                      
                        ,ENTRY_NO                                       
                        ,TRAN_APPL_NO                                   
                        ,TRAN_COMMENT                                   
                        ,REVERSED_FL                                    
                        ,METER_NO                                       
                   FROM CSS_CSH_DRWR_JRNL                               
                  WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO      
                    AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE    
                    AND DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )     
                    AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID       
               ORDER BY DATE_TRAN DESC                                  
                        ,TRAN_TS DESC                                   
                        ,TRAN_TIME DESC                                 
                        ,ENTRY_NO ASC                                   
                        ,TRAN_APPL_NO ASC                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*         DECLARE CASHIER_JOURNAL_CURSOR  CURSOR FOR              06930000
MFA-TR*          SELECT DATE_TRAN                                       06940000
MFA-TR*                 ,TRAN_TS                                                
MFA-TR*                 ,TRAN_TIME                                              
MFA-TR*                 ,TRAN_ID                                        06950000
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,CURRENCY_TYPE                                          
MFA-TR*                 ,CODE_PYMT_FACILITY                                     
MFA-TR*                 ,TRAN_DATA                                              
MFA-TR*                 ,ENTRY_NO                                               
MFA-TR*                 ,TRAN_APPL_NO                                           
MFA-TR*                 ,TRAN_COMMENT                                           
MFA-TR*                 ,REVERSED_FL                                            
MFA-TR*                 ,METER_NO                                               
MFA-TR*            FROM CSS_CSH_DRWR_JRNL                                       
MFA-TR*           WHERE CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO              
MFA-TR*             AND CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE            
MFA-TR*             AND DATE_CASH_REPORT     = :CJ-DATE-CASH-REPORT             
MFA-TR*             AND CASH_DRAWER_ID       = :CJ-CASH-DRAWER-ID               
MFA-TR*        ORDER BY DATE_TRAN DESC                                          
MFA-TR*                 ,TRAN_TS DESC                                           
MFA-TR*                 ,TRAN_TIME DESC                                         
MFA-TR*                 ,ENTRY_NO ASC                                           
MFA-TR*                 ,TRAN_APPL_NO ASC                                       
MFA-TR*     QUERYNO 7065                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR FOR CSS_LIEAP_AGENCY                                 *06910000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE LIEAP_CURSOR CURSOR FOR                         
                 SELECT :WS-YES                                         
                   FROM CSS_LIEAP_AGENCY                                
                  WHERE GL_ACCT_NO  = :I5-GL-ACCT-NO                    
               OPTION(FAST 1)                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ021
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE LIEAP_CURSOR CURSOR FOR                                 
MFA-TR*          SELECT :WS-YES                                                 
MFA-TR*            FROM CSS_LIEAP_AGENCY                                        
MFA-TR*           WHERE GL_ACCT_NO  = :I5-GL-ACCT-NO                            
MFA-TR*        OPTIMIZE FOR 1 ROW                                               
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************06900000
      *    CURSOR FOR CSS_CSH_DRWR_CNTL                                *06910000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE DRWR_CNTL_CURSOR CURSOR FOR                     
                 SELECT CASH_DRAWER_ID                                  
                        ,AMT_BASIC_WORK                                 
                        ,CODE_CSH_DRWR_STAT                             
                        ,REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                   FROM CSS_CSH_DRWR_CNTL                               
                  WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO        
                    AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE      
                    AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
                    AND USER_ID            = :CS-USER-ID                
               ORDER BY CASH_DRAWER_ID DESC                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DRWR_CNTL_CURSOR CURSOR FOR                             
MFA-TR*          SELECT CASH_DRAWER_ID                                          
MFA-TR*                 ,AMT_BASIC_WORK                                         
MFA-TR*                 ,CODE_CSH_DRWR_STAT                                     
MFA-TR*                 ,CREATED_TS                                             
MFA-TR*            FROM CSS_CSH_DRWR_CNTL                                       
MFA-TR*           WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                
MFA-TR*             AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE              
MFA-TR*             AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT               
MFA-TR*             AND USER_ID            = :CS-USER-ID                        
MFA-TR*        ORDER BY CASH_DRAWER_ID DESC                                     
MFA-TR*     QUERYNO 7200                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************06900000
      *    CURSOR FOR CSS_CSH_DRWR_CNTL FOR PARM-CASH-DRAWER > 0       *06910000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE DRWR_ID_CNTL_CURSOR CURSOR FOR                  
                 SELECT CASH_DRAWER_ID                                  
                        ,AMT_BASIC_WORK                                 
                        ,CODE_CSH_DRWR_STAT                             
                        ,REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                   FROM CSS_CSH_DRWR_CNTL                               
                  WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO        
                    AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE      
                    AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
                    AND USER_ID            = :CS-USER-ID                
                    AND CASH_DRAWER_ID     = :CJ-CASH-DRAWER-ID         
               ORDER BY CASH_DRAWER_ID DESC                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DRWR_ID_CNTL_CURSOR CURSOR FOR                          
MFA-TR*          SELECT CASH_DRAWER_ID                                          
MFA-TR*                 ,AMT_BASIC_WORK                                         
MFA-TR*                 ,CODE_CSH_DRWR_STAT                                     
MFA-TR*                 ,CREATED_TS                                             
MFA-TR*            FROM CSS_CSH_DRWR_CNTL                                       
MFA-TR*           WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                
MFA-TR*             AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE              
MFA-TR*             AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT               
MFA-TR*             AND USER_ID            = :CS-USER-ID                        
MFA-TR*             AND CASH_DRAWER_ID     = :CJ-CASH-DRAWER-ID                 
MFA-TR*        ORDER BY CASH_DRAWER_ID DESC                                     
MFA-TR*     QUERYNO 7205                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
       LINKAGE SECTION.                                                 
      *                                                                *        
      ******************************************************************        
      *                                                                         
       01  PARM-COMPANY-NO         PIC X(02).                           
       01  PARM-CASH-LOCAL-OFFICE  PIC X(03).                           
       01  PARM-USER-ID            PIC X(07).                           
       01  PARM-DATE-CASH-REPORT   PIC X(10).                           
       01  PARM-CASH-DRAWER-ID     PIC S9(04) COMP.                     
      *                                                                         
       PROCEDURE DIVISION USING    PARM-COMPANY-NO                      
                                   PARM-CASH-LOCAL-OFFICE               
                                   PARM-USER-ID                         
                                   PARM-DATE-CASH-REPORT                
                                   PARM-CASH-DRAWER-ID.                 
      *                                                                 07590000
      ******************************************************************07600000
      *                                                                *        
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      *                                                                *        
      ******************************************************************07630000
      *                                                                 07640000
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07640000
      ******************************************************************07730000
      *                                                                *07790000
      * 0100-INITIALIZE                                                *07740000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *07760000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *07770000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07780000
      *                                                                *07790000
      ******************************************************************07800000
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE TDS-RETURN-FIELDS-1                               
                      TDS-RETURN-FIELDS-2                               
                      GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2                               
                      WS-TOTAL-AMOUNT.                                  
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT  RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,CASH_LOCAL_OFFICE                                
                      ,USER_ID                                          
                      ,DATE_TRAN                                        
                      ,CASH_DRAWER_ID                                   
                      ,CASH_DRAWER_STAT                                 
                      ,TRAN_TIME                                        
                      ,TRAN_ID                                          
                      ,LTRIM(RTRIM(TRAN_DESC))     AS TRAN_DESC                
                      ,LTRIM(RTRIM(ACCOUNT_NO))    AS ACCOUNT_NO               
                      ,CASH_AMT                                         
                      ,CHECK_MO_AMT                                     
                      ,OTHER_AMT                                        
                      ,TOTAL_AMT                                        
                      ,BANK_TRANS_TOTAL                                 
                      ,WORK_FUND_TOTAL                                  
                      ,ENTRY_NO                                         
                      ,TRAN_COMMENT                                     
                      ,LTRIM(RTRIM(REVERSED_FLAG)) AS REVERSED_FLAG            
                      ,CIS_PAYMENT_IND                                  
                      ,MULTI_BATCH_IND                                  
                      ,TRAN_TS                                          
                      ,CURRENCY_TYPE                                    
                      ,CODE_PYMT_FACILITY                               
                      ,CREATED_TS                                       
PRJ586                ,LAST_UPDATE_TS                                   
PRJ586                ,METER_NO                                         
               FROM                                                     
                   #CSR04756_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,CASH_LOCAL_OFFICE                                        
MFA-TR*               ,USER_ID                                                  
MFA-TR*               ,DATE_TRAN                                                
MFA-TR*               ,CASH_DRAWER_ID                                           
MFA-TR*               ,CASH_DRAWER_STAT                                         
MFA-TR*               ,TRAN_TIME                                                
MFA-TR*               ,TRAN_ID                                                  
MFA-TR*               ,STRIP(TRAN_DESC)     AS TRAN_DESC                        
MFA-TR*               ,STRIP(ACCOUNT_NO)    AS ACCOUNT_NO                       
MFA-TR*               ,CASH_AMT                                                 
MFA-TR*               ,CHECK_MO_AMT                                             
MFA-TR*               ,OTHER_AMT                                                
MFA-TR*               ,TOTAL_AMT                                                
MFA-TR*               ,BANK_TRANS_TOTAL                                         
MFA-TR*               ,WORK_FUND_TOTAL                                          
MFA-TR*               ,ENTRY_NO                                                 
MFA-TR*               ,TRAN_COMMENT                                             
MFA-TR*               ,STRIP(REVERSED_FLAG) AS REVERSED_FLAG                    
MFA-TR*               ,CIS_PAYMENT_IND                                          
MFA-TR*               ,MULTI_BATCH_IND                                          
MFA-TR*               ,TRAN_TS                                                  
MFA-TR*               ,CURRENCY_TYPE                                            
MFA-TR*               ,CODE_PYMT_FACILITY                                       
MFA-TR*               ,CREATED_TS                                               
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,METER_NO                                                 
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04756_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR  FOR                        
               SELECT  RETURN_CODE                                      
                      ,CREDIT_CARD_COUNT                                
                      ,CREDIT_CARD_AMOUNT                               
               FROM                                                     
                   #CSR04756_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,CREDIT_CARD_COUNT                                        
MFA-TR*               ,CREDIT_CARD_AMOUNT                                       
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04756_R2                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04756_R1'            
                                       TO S-SQL-STATEMENT-V.            
                                                                        
           SET WS-RESULT-1 TO TRUE                                      
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04756_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04756_R1
              (                                                       
                    RETURN_CODE            INT                      
                   ,APPL_RETURN_CODE       INT                      
                   ,CASH_LOCAL_OFFICE CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,USER_ID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,DATE_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CASH_DRAWER_ID         SMALLINT                     
                   ,CASH_DRAWER_STAT CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,TRAN_TIME CHAR(8)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,TRAN_ID CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,TRAN_DESC CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ACCOUNT_NO CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CASH_AMT               DECIMAL(11,2)                
                   ,CHECK_MO_AMT           DECIMAL(11,2)                
                   ,OTHER_AMT              DECIMAL(11,2)                
                   ,TOTAL_AMT              DECIMAL(13,2)                
                   ,BANK_TRANS_TOTAL       DECIMAL(11,2)                
                   ,WORK_FUND_TOTAL        DECIMAL(15,2)                
                   ,ENTRY_NO               INT                      
                   ,TRAN_COMMENT CHAR(210)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REVERSED_FLAG CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,CIS_PAYMENT_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,MULTI_BATCH_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,TRAN_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,CURRENCY_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_PYMT_FACILITY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CREATED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
PRJ586             ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
PRJ586             ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE SQLCODE               TO ABEND-SQLCODE             
                MOVE SQLSTATE              TO ABEND-SQLSTATE            
                MOVE '0100A'               TO ACTIVE-PARAGRAPH          
                MOVE 'DECLARE GTT'         TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04756_R1'         TO TABLE-1                   
                MOVE SPACES                TO TABLE-ELEMENT-1           
                MOVE SPACES                TO HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04756_R2'            
                                       TO S-SQL-STATEMENT-V.            
                                                                        
           SET WS-RESULT-2 TO TRUE                                      
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04756_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04756_R2
              (                                                       
                    RETURN_CODE            INT                      
                   ,CREDIT_CARD_COUNT      SMALLINT                     
                   ,CREDIT_CARD_AMOUNT     DECIMAL(13,2)                
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE SQLCODE               TO ABEND-SQLCODE             
                MOVE SQLSTATE              TO ABEND-SQLSTATE            
                MOVE '0100A'               TO ACTIVE-PARAGRAPH          
                MOVE 'DECLARE GTT'         TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04756_R2'         TO TABLE-1                   
                MOVE SPACES                TO TABLE-ELEMENT-1           
                MOVE SPACES                TO HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************08040000
      *                                                                *08080000
      * 1000-PROCESS-INPUT.                                            *08050000
      *     1. RECEIVE PARMS.                                          *08070000
      *                                                                *08080000
      ******************************************************************08090000
      *                                                                         
       1000-PROCESS-INPUT.                                              
           MOVE '1000'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           MOVE PARM-COMPANY-NO        TO CS-CASH-COMPANY-NO            
                                          CJ-CASH-COMPANY-NO.           
           MOVE PARM-CASH-LOCAL-OFFICE TO CS-CASH-LOCAL-OFFICE          
                                          CJ-CASH-LOCAL-OFFICE          
                                          JT-CASH-LOCAL-OFFICE.         
           MOVE PARM-USER-ID           TO CS-USER-ID                    
                                          CJ-USER-ID.                   
           MOVE PARM-DATE-CASH-REPORT  TO CS-DATE-CASH-REPORT           
                                          CJ-DATE-CASH-REPORT           
                                          JT-DATE-CASH-REPORT.          
           MOVE PARM-CASH-DRAWER-ID    TO CJ-CASH-DRAWER-ID.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08160000
      ******************************************************************08470000
      *                                                                *08490000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     3. BUILD RESULT SET                                        *08520000
      *     4. SEND RESULT SET                                         *08530000
      *                                                                *08540000
      ******************************************************************08550000
      *                                                                 08560000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           SET WS-RESULT-1                     TO TRUE.                 
           PERFORM 2200-PROCESS-DETAIL1        THRU 2200-EXIT.          
           SET WS-RESULT-2                     TO TRUE.                 
PDSUPP     IF CS-CODE-CSH-DRWR-STAT = 'A'                               
PDSUPP        PERFORM 2210-PROCESS-DETAIL2        THRU 2210-EXIT        
PDSUPP     ELSE                                                         
PDSUPP        MOVE 0 TO RS-RETURN-CODE-2                                
PDSUPP        MOVE 0 TO RS-CREDIT-CARD-COUNT                            
PDSUPP        MOVE 0 TO RS-CREDIT-CARD-AMOUNT                           
PDSUPP        PERFORM 2000B-MOVE-RESULT       THRU 2000B-EXIT           
PDSUPP        PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
PDSUPP     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2200-PROCESS-DETAIL1                                           *        
      *    1. GET GL_ACCT_NO.                                          *        
      *    2. GET THE BATCHES FOR THE DAY AND USER.                    *        
      *    3. CHECKING FOR MULTIPLE BATCHES.                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-DETAIL1.                                            
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7045-GET-ACCT-NUMBER        THRU 7045-EXIT.          
           IF PARM-CASH-DRAWER-ID = 0                                   
              PERFORM 7040-CK-MULTI-BATCH         THRU 7040-EXIT        
           ELSE                                                         
              PERFORM 7041-CK-ID-MULTI-BATCH      THRU 7041-EXIT        
           END-IF.                                                      
                                                                        
           IF  WS-MULTI-BATCH-COUNT  GREATER THAN WS-ONE                
               MOVE WS-YES                     TO WS-MULTI-BATCH-IND    
           ELSE                                                         
               MOVE WS-NO                      TO WS-MULTI-BATCH-IND    
           END-IF.                                                      
                                                                        
           IF PARM-CASH-DRAWER-ID = 0                                   
              PERFORM 7200-OPEN-CNTL-CURSOR       THRU 7200-EXIT        
              PERFORM 7250-FETCH-CNTL-CURSOR      THRU 7250-EXIT        
           ELSE                                                         
              PERFORM 7205-OPEN-DRWR-ID-CNTL-CURSOR  THRU 7205-EXIT     
              PERFORM 7255-FETCH-DRWR-ID-CNTL-CURSOR THRU 7255-EXIT     
           END-IF.                                                      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2250-PROCESS-BATCH-DET  THRU 2250-EXIT           
                             UNTIL WS-RETURN-CODE = NOT-FOUND           
           ELSE                                                         
               MOVE +0                         TO RS-RETURN-CODE-1      
               MOVE +1000                      TO RS-APPL-RETURN-CODE   
               PERFORM 2000A-MOVE-RESULT       thru 2000A-EXIT          
               PERFORM 8100-SEND-RESULT-1      THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS1 = 0                                          
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1             
              PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                 
           END-IF.                                                      
                                                                        
           IF PARM-CASH-DRAWER-ID = 0                                   
              PERFORM 7210-CLOSE-DRWR-CNTL-CURSOR    THRU 7210-EXIT     
           ELSE                                                         
              PERFORM 7215-CLOSE-DRWR-ID-CNTL-CURSOR THRU 7215-EXIT     
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2000A-MOVE-RESULT                                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE-1          TO S-RETURN-CODE-1.          
            MOVE RS-APPL-RETURN-CODE       TO S-APPL-RETURN-CODE.       
            MOVE RS-CASH-LOCAL-OFFICE      TO S-CASH-LOCAL-OFFICE.      
            MOVE RS-USER-ID                TO S-USER-ID.                
            MOVE RS-DATE-TRAN              TO S-DATE-TRAN.              
            MOVE RS-CASH-DRAWER-ID         TO S-CASH-DRAWER-ID.         
            MOVE RS-CASH-DRAWER-STAT       TO S-CASH-DRAWER-STAT.       
            MOVE RS-TRAN-TIME              TO S-TRAN-TIME.              
            MOVE RS-TRAN-ID                TO S-TRAN-ID.                
            MOVE RS-TRAN-DESC              TO S-TRAN-DESC.              
            MOVE RS-ACCOUNT-NO             TO S-ACCOUNT-NO.             
            MOVE RS-CASH-AMOUNT            TO S-CASH-AMOUNT.            
            MOVE RS-CHECK-MO-AMT           TO S-CHECK-MO-AMT.           
            MOVE RS-OTHER-AMT              TO S-OTHER-AMT.              
            MOVE RS-TOTAL-AMOUNT           TO S-TOTAL-AMOUNT.           
            MOVE RS-BANK-TRANS-TOTAL       TO S-BANK-TRANS-TOTAL.       
            MOVE RS-WORK-FUND-TOTAL        TO S-WORK-FUND-TOTAL.        
            MOVE RS-ENTRY-NO               TO S-ENTRY-NO.               
            MOVE RS-TRAN-COMMENT           TO S-TRAN-COMMENT.           
            MOVE RS-REVERSED-FLAG          TO S-REVERSED-FLAG.          
            MOVE RS-CIS-PAYMENT-IND        TO S-CIS-PAYMENT-IND.        
            MOVE RS-MULTI-BATCH-IND        TO S-MULTI-BATCH-IND.        
            MOVE RS-TRAN-TS                TO S-TRAN-TS.                
            MOVE RS-CURRENCY-TYPE          TO S-CURRENCY-TYPE.          
            MOVE RS-CODE-PYMT-FACILITY     TO S-CODE-PYMT-FACILITY.     
            MOVE RS-CREATED-TS             TO S-CREATED-TS.             
PRJ586      MOVE RS-LAST-UPDATE-TS         TO S-LAST-UPDATE-TS.         
PRJ586      MOVE RS-METER-NO               TO S-METER-NO.               
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 2000B-MOVE-RESULT.                                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       2000B-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE-2          TO S-RETURN-CODE-2.          
            MOVE RS-CREDIT-CARD-COUNT      TO S-CREDIT-CARD-COUNT.      
            MOVE RS-CREDIT-CARD-AMOUNT     TO S-CREDIT-CARD-AMOUNT.     
      *                                                                         
       2000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2210-PROCESS-DETAIL2                                           *        
      *    GET THE TOTAL COUNT AND AMOUNT FOR CREDIT CARD TRANSACTIONS *        
      *                                                                *        
      ******************************************************************42800000
      *                                                                         
       2210-PROCESS-DETAIL2.                                            
                                                                        
           EXEC SQL                                                     
             SELECT  COUNT(*)                                           
PDSUPP              ,SUM(PAYMENT_AMT)                                   
               INTO  :RS-CREDIT-CARD-COUNT                              
                    ,:RS-CREDIT-CARD-AMOUNT :WS-NULL-IND4                
PDSUPP         FROM  CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                    
PDSUPP        WHERE CIS.SUBSTR3(CUST_PHONE_NO,1,7) = :CS-USER-ID             
PDSUPP          AND CIS.SUBSTR3(CUST_PHONE_NO,8,3) = 
                                                  :CS-CASH-LOCAL-OFFICE   
PDSUPP          AND PYMT_FACILITY_CD = 'O'                              
PDSUPP          AND PYMT_RCVD_TS > CIS.CHAR2TIMESTAMP(:CS-CREATED-TS)           
PDSUPP          AND CASH_LOCAL_OFFICE = '058'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  COUNT(*)                                                   
MFA-TR*             ,SUM(PAYMENT_AMT)                                           
MFA-TR*        INTO  :RS-CREDIT-CARD-COUNT                                      
MFA-TR*             ,:RS-CREDIT-CARD-AMOUNT:WS-NULL-IND4                        
MFA-TR*        FROM  CSS_PAYMENT_TRANS                                          
MFA-TR*       WHERE SUBSTR(CUST_PHONE_NO,1,7) = :CS-USER-ID                     
MFA-TR*         AND SUBSTR(CUST_PHONE_NO,8,3) = :CS-CASH-LOCAL-OFFICE           
MFA-TR*         AND PYMT_FACILITY_CD = 'O'                                      
MFA-TR*         AND PYMT_RCVD_TS > :CS-CREATED-TS                               
MFA-TR*         AND CASH_LOCAL_OFFICE = '058'                                   
MFA-TR*     WITH UR                                                             
MFA-TR*    QUERYNO 2210                                                         
MFA-TR*    END-EXEC.                                                    03050073

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-IND4 < ZERO                                  
                   MOVE 0 TO RS-CREDIT-CARD-AMOUNT                      
               END-IF                                                   
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE-2           
               PERFORM 2000B-MOVE-RESULT       THRU 2000B-EXIT          
               PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT           
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-2      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '2210'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_PAYMENT_TRANS'        TO TABLE-1               
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-1       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-2       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3       
               MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-1     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-2     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2250-PROCESS-BATCH-DET                                         *        
      *    GET THE BANK TRANSFER AMOUNT FOR THE BATCH AND USER.        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2250-PROCESS-BATCH-DET.                                          
                                                                        
           MOVE '2250' TO ACTIVE-PARAGRAPH.                             
                                                                        
           INITIALIZE TDS-RETURN-FIELDS-1                               
                      WS-TOTAL-AMOUNT.                                  
                                                                        
           MOVE WS-INITIAL-VALUE               TO WS-SEND-ROW.          
           MOVE ZERO                           TO WS-BANK-TRANS         
                                                  WS-BANK-TRANS-TOTAL.  
                                                                        
           PERFORM 7010-OPEN-BXFER-CURSOR      THRU 7010-EXIT.          
           PERFORM 7020-FETCH-BXFER-CURSOR     THRU 7020-EXIT           
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.          
           PERFORM 7030-CLOSE-BXFER-CURSOR     THRU 7030-EXIT.          
                                                                        
           IF PARM-CASH-DRAWER-ID = 0                                   
              PERFORM 7060-OPEN-JOURNAL-CURSOR THRU 7060-EXIT           
              PERFORM 7070-FETCH-JOURNAL-CURSOR THRU 7070-EXIT          
           ELSE                                                         
              PERFORM 7065-OPEN-CSHR-JOURNAL-CURSOR THRU 7065-EXIT      
              PERFORM 7075-FETCH-CSHR-JOURNAL-CURSOR THRU 7075-EXIT     
           END-IF.                                                      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2300-PROCESS-JOURNAL    THRU 2300-EXIT           
               IF  WS-SEND-ROW = WS-INITIAL-VALUE                       
                   MOVE +0                     TO RS-RETURN-CODE-1      
                   MOVE +2000                  TO RS-APPL-RETURN-CODE   
                   MOVE WS-MULTI-BATCH-IND     TO RS-MULTI-BATCH-IND    
                   MOVE CS-CASH-LOCAL-OFFICE   TO RS-CASH-LOCAL-OFFICE  
                   MOVE CS-USER-ID             TO RS-USER-ID            
                   MOVE CS-CASH-DRAWER-ID      TO RS-CASH-DRAWER-ID     
                   MOVE CS-CODE-CSH-DRWR-STAT  TO RS-CASH-DRAWER-STAT   
                   MOVE CS-AMT-BASIC-WORK      TO RS-WORK-FUND-TOTAL    
                   MOVE CS-CREATED-TS          TO RS-CREATED-TS         
                   PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
                   PERFORM 8100-SEND-RESULT-1  THRU 8100-EXIT           
               END-IF                                                   
           ELSE                                                         
               MOVE +0                         TO RS-RETURN-CODE-1      
               MOVE +2000                      TO RS-APPL-RETURN-CODE   
               MOVE WS-MULTI-BATCH-IND         TO RS-MULTI-BATCH-IND    
               MOVE CS-CASH-LOCAL-OFFICE       TO RS-CASH-LOCAL-OFFICE  
               MOVE CS-USER-ID                 TO RS-USER-ID            
               MOVE CS-CASH-DRAWER-ID          TO RS-CASH-DRAWER-ID     
               MOVE CS-CODE-CSH-DRWR-STAT      TO RS-CASH-DRAWER-STAT   
               MOVE CS-AMT-BASIC-WORK          TO RS-WORK-FUND-TOTAL    
               MOVE CS-CREATED-TS              TO RS-CREATED-TS         
               PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT-1      THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-CASH-DRAWER-ID = 0                                   
              PERFORM 7080-CLOSE-JOURNAL-CURSOR THRU 7080-EXIT          
              PERFORM 7250-FETCH-CNTL-CURSOR    THRU 7250-EXIT          
           ELSE                                                         
              PERFORM 7085-CLOSE-CSHR-JOURNAL-CURSOR THRU 7085-EXIT     
              PERFORM 7255-FETCH-DRWR-ID-CNTL-CURSOR THRU 7255-EXIT     
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2300-PROCESS-JOURNAL                                           *        
      *    GET ALL THE TRANSACTIONS FOR A BATCH                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-JOURNAL.                                            
                                                                        
           MOVE '2300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM UNTIL WS-RETURN-CODE = NOT-FOUND                     
                                                                        
              PERFORM 7400-GET-TRAN-DESC THRU 7400-EXIT                 
              PERFORM 2350-BUILD-TRANS-ROW THRU 2350-EXIT               
                                                                        
              IF PARM-CASH-DRAWER-ID = 0                                
                 PERFORM 7070-FETCH-JOURNAL-CURSOR THRU 7070-EXIT       
              ELSE                                                      
                 PERFORM 7075-FETCH-CSHR-JOURNAL-CURSOR THRU 7075-EXIT  
              END-IF                                                    
                                                                        
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF  CJ-ENTRY-NO = WS-PREV-ENTRY-NO                    
                      CONTINUE                                          
                  ELSE                                                  
                      MOVE WS-MULTI-BATCH-IND TO RS-MULTI-BATCH-IND     
                      MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE-1    
                      MOVE WS-TOTAL-AMOUNT TO RS-TOTAL-AMOUNT           
                      IF  WS-SEND-ROW EQUAL WS-YES                      
                          PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT     
                          PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT     
                          MOVE WS-NO TO WS-SEND-ROW                     
                          INITIALIZE TDS-RETURN-FIELDS-1                
                                     WS-TOTAL-AMOUNT                    
                      END-IF                                            
                  END-IF                                                
              ELSE                                                      
                  MOVE WS-MULTI-BATCH-IND TO RS-MULTI-BATCH-IND         
                  MOVE WS-TOTAL-AMOUNT TO RS-TOTAL-AMOUNT               
                  IF  WS-SEND-ROW EQUAL WS-YES                          
                      PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT         
                      PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT         
                      MOVE WS-NO TO WS-SEND-ROW                         
                  END-IF                                                
                  INITIALIZE TDS-RETURN-FIELDS-1                        
                             WS-TOTAL-AMOUNT                            
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 24730000
      *                                                               *         
      * 2350-BUILD-TRANS-ROW                                          *         
      *   ACCUMULATE ALL THE VAUES FOR THE AMOUNT FIELDS ON THE PANEL *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       2350-BUILD-TRANS-ROW.                                            
                                                                        
           MOVE WS-NO TO WS-CASH-GL-NUM                                 
                         WS-LIHEAP-RVSL                                 
                         WS-LIHEAP-PMT.                                 
           MOVE CJ-ENTRY-NO TO WS-PREV-ENTRY-NO.                        
           MOVE CJ-TRAN-DATA TO CJF00101.                               
           IF  CJ-ACCOUNT-NO EQUAL ZERO                                 
               MOVE WS-NO TO WS-CIS-PAYMENT-IND                         
               IF  WS-101-FCS-ACCT-NO < SPACES OR LOW-VALUES            
                   MOVE WS-ZERO TO RS-ACCOUNT-NO                        
               ELSE                                                     
                   MOVE WS-101-FCS-ACCT-NO TO RS-ACCOUNT-NO             
               END-IF                                                   
           ELSE                                                         
               MOVE CJ-ACCOUNT-NO TO WS-ACCOUNT-NO-COMP3                
               MOVE WS-ACCOUNT-NO-COMP3 TO WS-ACCOUNT-NO-NUM            
               MOVE WS-ACCOUNT-NO TO RS-ACCOUNT-NO                      
               PERFORM 7300-CK-CIS-PAYMENT THRU 7300-EXIT               
           END-IF.                                                      
                                                                        
           IF  WS-101-ACCT-GEN-LED-DR = WS-101-ACCT-GEN-LED-CR          
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-101-ACCT-GEN-LED-DR = GO-GL-ACCT-NO OR            
                   WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO               
                   MOVE WS-YES TO WS-CASH-GL-NUM                        
               ELSE                                                     
                   MOVE WS-101-ACCT-GEN-LED-DR TO I5-GL-ACCT-NO         
                   PERFORM 2400-CHECK-GL-NUM THRU 2400-EXIT             
                                                                        
                   IF  WS-GL-ACCT-FLAG = WS-YES                         
                       MOVE WS-YES TO WS-LIHEAP-PMT                     
                   ELSE                                                 
                       MOVE WS-101-ACCT-GEN-LED-CR TO I5-GL-ACCT-NO     
                       PERFORM 2400-CHECK-GL-NUM THRU 2400-EXIT         
                                                                        
                       IF  WS-GL-ACCT-FLAG = WS-YES                     
                           MOVE WS-YES TO WS-LIHEAP-RVSL                
                       END-IF                                           
                   END-IF                                               
                   MOVE WS-NO TO WS-GL-ACCT-FLAG                        
               END-IF                                                   
                                                                        
               IF  WS-CASH-GL-NUM = WS-YES                              
               OR  WS-LIHEAP-PMT = WS-YES                               
               OR  WS-LIHEAP-RVSL = WS-YES                              
                   MOVE WS-YES TO WS-SEND-ROW                           
                   MOVE WS-101-AMT-POSTED TO WS-GEN-LED-AMT             
                                                                        
                   IF  WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO OR        
                       WS-LIHEAP-RVSL = WS-YES                          
                       MULTIPLY -1 BY WS-GEN-LED-AMT                    
                   END-IF                                               
                                                                        
                   ADD WS-GEN-LED-AMT TO WS-TOTAL-AMOUNT                
                   MOVE CJ-CURRENCY-TYPE TO WS-CURRENCY-TYPE            
                                                                        
                   IF  CASH                                             
                       ADD WS-GEN-LED-AMT TO RS-CASH-AMOUNT             
                   ELSE                                                 
                       IF  CHECK OR MONEY-ORDER OR DRAFT                
                           ADD WS-GEN-LED-AMT TO RS-CHECK-MO-AMT        
                       ELSE                                             
                           ADD WS-GEN-LED-AMT TO RS-OTHER-AMT           
                       END-IF                                           
                   END-IF                                               
                                                                        
                   MOVE WS-BANK-TRANS-TOTAL TO RS-BANK-TRANS-TOTAL      
                   MOVE WS-CIS-PAYMENT-IND TO RS-CIS-PAYMENT-IND        
                   MOVE CJ-CASH-LOCAL-OFFICE TO RS-CASH-LOCAL-OFFICE    
                   MOVE CJ-USER-ID TO RS-USER-ID                        
                   MOVE CJ-DATE-TRAN TO WS-DATE-YYYYMMDD                
                   MOVE WS-YY TO WS-DATE-TRAN-YY                        
                   MOVE WS-MM TO WS-DATE-TRAN-MM                        
                   MOVE WS-DD TO WS-DATE-TRAN-DD                        
                   MOVE WS-DATE-TRAN TO RS-DATE-TRAN                    
                   MOVE CS-CASH-DRAWER-ID TO RS-CASH-DRAWER-ID          
                   MOVE CS-CODE-CSH-DRWR-STAT TO RS-CASH-DRAWER-STAT    
                   MOVE K9-APPL-PROGRAM-DESC TO RS-TRAN-DESC            
                   MOVE CJ-TRAN-ID TO RS-TRAN-ID                        
                   MOVE CJ-TRAN-TIME TO RS-TRAN-TIME                    
                   MOVE CJ-TRAN-TS TO RS-TRAN-TS                        
                   MOVE CJ-ENTRY-NO TO RS-ENTRY-NO                      
                   MOVE CJ-REVERSED-FL TO RS-REVERSED-FLAG              
                   MOVE CJ-TRAN-COMMENT-TEXT TO RS-TRAN-COMMENT         
                   MOVE CS-AMT-BASIC-WORK TO RS-WORK-FUND-TOTAL         
                   MOVE CJ-CURRENCY-TYPE TO RS-CURRENCY-TYPE            
                   MOVE CJ-CODE-PYMT-FACILITY TO RS-CODE-PYMT-FACILITY  
                   MOVE CS-CREATED-TS TO RS-CREATED-TS                  
PRJ586             MOVE CJ-METER-NO TO RS-METER-NO                      
                   INITIALIZE CJ-TRAN-COMMENT                           
               END-IF                                                   
           END-IF.                                                      
      *                                                                 24730000
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24730000
      ******************************************************************        
      *                                                                         
      * 2400-CHECK-GL-NUM                                                       
      *    TO CHECK WHETHER GL_ACCT_NO IS IN THE CSS_LIEAP_AGENCY               
      *                                                                         
      ******************************************************************        
      *                                                                         
       2400-CHECK-GL-NUM.                                               
                                                                        
           MOVE '2400' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7100-OPEN-LIEAP-CURSOR THRU 7100-EXIT.               
           PERFORM 7120-FETCH-LIEAP-CURSOR THRU 7120-EXIT.              
           PERFORM 7140-CLOSE-LIEAP-CURSOR THRU 7140-EXIT.              
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7010-OPEN-BXFER-CURSOR                                         *        
      *    TO OPEN THE BXFER_CURSOR                                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7010-OPEN-BXFER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN  BXFER_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7010'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7020-FETCH-BXFER-CURSOR                                        *        
      *    TO FETCH THE BXFER_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7020-FETCH-BXFER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH BXFER_CURSOR                                        
               INTO :WS-BANK-TRANS :WS-NULL-IND1                        
                    ,:YB-CODE-DR-CR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF WS-NULL-IND1 < ZERO                                
                     MOVE 0 TO WS-BANK-TRANS                            
                  ELSE                                                  
                     IF YB-CODE-DR-CR = WS-C                            
                        MULTIPLY -1 BY WS-BANK-TRANS                    
                     END-IF                                             
                  END-IF                                                
                  ADD WS-BANK-TRANS TO WS-BANK-TRANS-TOTAL              
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7020'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7030-CLOSE-BXFER-CURSOR                                        *        
      *    TO CLOSE THE BXFER_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7030-CLOSE-BXFER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE  BXFER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7030'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7040-CK-MULTI-BATCH                                            *        
      *    TO CHECK FOR THE MULTIPLE BATCHES                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7040-CK-MULTI-BATCH.                                             
                                                                        
           EXEC SQL                                                     
                SELECT  COUNT(*)                                        
                  INTO  :WS-MULTI-BATCH-COUNT                           
                  FROM  CSS_CSH_DRWR_CNTL                               
                 WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO         
                   AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE       
                   AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
                   AND  USER_ID           = :CS-USER-ID                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  COUNT(*)                                                
MFA-TR*           INTO  :WS-MULTI-BATCH-COUNT                                   
MFA-TR*           FROM  CSS_CSH_DRWR_CNTL                                       
MFA-TR*          WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE               
MFA-TR*            AND  DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                
MFA-TR*            AND  USER_ID           = :CS-USER-ID                         
MFA-TR*     QUERYNO 7040                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE-1.                            
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7040'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7041-CK-ID-MULTI-BATCH                                         *        
      *    TO CHECK FOR A SPECIFIC BATCH                               *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7041-CK-ID-MULTI-BATCH.                                          
                                                                        
           EXEC SQL                                                     
                SELECT  COUNT(*)                                        
                  INTO  :WS-MULTI-BATCH-COUNT                           
                  FROM  CSS_CSH_DRWR_CNTL                               
                 WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO         
                   AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE       
                   AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
                   AND  USER_ID           = :CS-USER-ID                 
                   AND  CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  COUNT(*)                                                
MFA-TR*           INTO  :WS-MULTI-BATCH-COUNT                                   
MFA-TR*           FROM  CSS_CSH_DRWR_CNTL                                       
MFA-TR*          WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE               
MFA-TR*            AND  DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                
MFA-TR*            AND  USER_ID           = :CS-USER-ID                         
MFA-TR*            AND  CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                  
MFA-TR*     QUERYNO 7041                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE-1.                            
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7041'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7041-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7045-GET-ACCT-NUMBER                                           *        
      *    TO GET THE CLEAR CASH ACCOUNT NUMBER                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7045-GET-ACCT-NUMBER.                                            
                                                                        
           EXEC SQL                                                     
                SELECT  GL_ACCT_NO                                      
                INTO    :GO-GL-ACCT-NO                                  
                FROM    CSS_GL_ACCT_NO                                  
                WHERE   COMPANY_NO   = :CS-CASH-COMPANY-NO              
                AND     GL_ACCT_NAME = :WS-CLEAR-CASH                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  GL_ACCT_NO                                              
MFA-TR*         INTO    :GO-GL-ACCT-NO                                          
MFA-TR*         FROM    CSS_GL_ACCT_NO                                          
MFA-TR*         WHERE   COMPANY_NO   = :CS-CASH-COMPANY-NO                      
MFA-TR*         AND     GL_ACCT_NAME = :WS-CLEAR-CASH                           
MFA-TR*     QUERYNO 7045                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7045'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-2       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-2     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7050-GET-BANKTRANS                                             *        
      *    TO GET THE TOTAL BANK TRANSFER FOR THE BATCH                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7050-GET-BANKTRANS.                                              
                                                                        
           EXEC SQL                                                     
                SELECT  SUM(TRANSFER_AMT)                               
                INTO    :WS-BANK-TRANS-TOTAL :WS-NULL-IND1               
                FROM    CSS_BANK_TRANSFER                               
                WHERE   CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO         
                AND     CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE       
                AND     DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
                AND     CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID          
                AND     USER_ID           = :CS-USER-ID                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  SUM(TRANSFER_AMT)                                       
MFA-TR*         INTO    :WS-BANK-TRANS-TOTAL:WS-NULL-IND1                       
MFA-TR*         FROM    CSS_BANK_TRANSFER                                       
MFA-TR*         WHERE   CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                 
MFA-TR*         AND     CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE               
MFA-TR*         AND     DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                
MFA-TR*         AND     CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                  
MFA-TR*         AND     USER_ID           = :CS-USER-ID                         
MFA-TR*     QUERYNO 7050                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-IND1 < ZERO                                  
                   MOVE 0                      TO WS-BANK-TRANS-TOTAL   
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7060-OPEN-JOURNAL-CURSOR                                       *        
      *    TO OPEN THE JOURNAL_CURSOR                                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7060-OPEN-JOURNAL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN  JOURNAL_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7060'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7065-OPEN-CSHR-JOURNAL-CURSOR                                  *        
      *    TO OPEN THE CSHR_JOURNAL_CURSOR                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7065-OPEN-CSHR-JOURNAL-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
                OPEN  CASHIER_JOURNAL_CURSOR                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7065'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7065-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7070-FETCH-JOURNAL-CURSOR                                      *        
      *    TO FETCH THE JOURNAL_CURSOR                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7070-FETCH-JOURNAL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                FETCH  JOURNAL_CURSOR                                   
                INTO   :CJ-DATE-TRAN                                    
                      ,:CJ-TRAN-TS :WS-NULL-IND2                         
                      ,:CJ-TRAN-TIME                                    
                      ,:CJ-TRAN-ID                                      
                      ,:CJ-ACCOUNT-NO                                   
                      ,:CJ-CURRENCY-TYPE                                
                      ,:CJ-CODE-PYMT-FACILITY                           
                      ,:CJ-TRAN-DATA                                    
                      ,:CJ-ENTRY-NO                                     
                      ,:CJ-TRAN-APPL-NO                                 
                      ,:CJ-TRAN-COMMENT                                 
                      ,:CJ-REVERSED-FL                                  
                      ,:CJ-METER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-RETURN-CODE.                              
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               IF WS-NULL-IND2 < ZERO                                   
                   MOVE LOW-VALUES TO CJ-TRAN-TS                        
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7070'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7075-FETCH-CSHR-JOURNAL-CURSOR                                 *        
      *    TO FETCH THE CASHIER_JOURNAL_CURSOR                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7075-FETCH-CSHR-JOURNAL-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
                FETCH  CASHIER_JOURNAL_CURSOR                           
                INTO   :CJ-DATE-TRAN                                    
                      ,:CJ-TRAN-TS :WS-NULL-IND2                         
                      ,:CJ-TRAN-TIME                                    
                      ,:CJ-TRAN-ID                                      
                      ,:CJ-ACCOUNT-NO                                   
                      ,:CJ-CURRENCY-TYPE                                
                      ,:CJ-CODE-PYMT-FACILITY                           
                      ,:CJ-TRAN-DATA                                    
                      ,:CJ-ENTRY-NO                                     
                      ,:CJ-TRAN-APPL-NO                                 
                      ,:CJ-TRAN-COMMENT                                 
                      ,:CJ-REVERSED-FL                                  
                      ,:CJ-METER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-RETURN-CODE.                              
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               IF WS-NULL-IND2 < ZERO                                   
                   MOVE LOW-VALUES TO CJ-TRAN-TS                        
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7075'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7080-CLOSE-JOURNAL-CURSOR                                      *        
      *    TO CLOSE THE JOURNAL_CURSOR                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7080-CLOSE-JOURNAL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE  JOURNAL_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7080'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7085-CLOSE-CSHR-JOURNAL-CURSOR                                 *        
      *    TO CLOSE THE CASHIER_JOURNAL_CURSOR                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7085-CLOSE-CSHR-JOURNAL-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
                CLOSE  CASHIER_JOURNAL_CURSOR                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7085'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_JRNL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7085-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      * 7100-OPEN-LIEAP-CURSOR                                                  
      *    TO OPEN THE LIEAP_CURSOR                                             
      *                                                                         
      ******************************************************************        
      *                                                                         
       7100-OPEN-LIEAP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN LIEAP_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      * 7120-FETCH-LIEAP-CURSOR                                                 
      *    TO FETCH THE LIEAP_CURSOR                                            
      *                                                                         
      ******************************************************************        
      *                                                                         
       7120-FETCH-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                FETCH LIEAP_CURSOR                                      
                 INTO :WS-GL-ACCT-FLAG                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7120'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_LIEAP_AGENCY'      TO TABLE-1                  
               MOVE 'GL_ACCT_NO'            TO TABLE-ELEMENT-1          
               MOVE I5-GL-ACCT-NO           TO WS-GL-ACCT-NO-ED         
               MOVE WS-GL-ACCT-NO-ED        TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      * 7140-CLOSE-LIEAP-CURSOR                                                 
      *    TO CLOSE THE LIEAP_CURSOR                                            
      *                                                                         
      ******************************************************************        
      *                                                                         
       7140-CLOSE-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE LIEAP_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7140'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7200-OPEN-CNTL-CURSOR                                          *        
      *    TO OPEN THE DRWR_CNTL_CURSOR                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-CNTL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN  DRWR_CNTL_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_CNTL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7205-OPEN-DRWR-ID-CNTL-CURSOR                                  *        
      *    TO OPEN THE DRWR_ID_CNTL_CURSOR                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7205-OPEN-DRWR-ID-CNTL-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
                OPEN  DRWR_ID_CNTL_CURSOR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7205'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_CNTL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7210-CLOSE-DRWR-CNTL-CURSOR                                    *        
      *    TO CLOSE THE DRWR_CNTL_CURSOR                               *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7210-CLOSE-DRWR-CNTL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE  DRWR_CNTL_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7210'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_CNTL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7215-CLOSE-DRWR-ID-CNTL-CURSOR                                 *        
      *    TO CLOSE THE DRWR_ID_CNTL_CURSOR                            *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7215-CLOSE-DRWR-ID-CNTL-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
                CLOSE  DRWR_ID_CNTL_CURSOR                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7215'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_CNTL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7250-FETCH-CNTL-CURSOR                                         *        
      *    THIS PARA IS TO FETCH THE DRWR_CNTL_CURSOR                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7250-FETCH-CNTL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  DRWR_CNTL_CURSOR                                 
                INTO   :CS-CASH-DRAWER-ID,                              
                       :CS-AMT-BASIC-WORK,                              
                       :CS-CODE-CSH-DRWR-STAT,                          
                       :CS-CREATED-TS :WS-NULL-IND3                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-RETURN-CODE.                              
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-NULL-IND3 < ZERO                                   
                   MOVE LOW-VALUES TO CS-CREATED-TS                     
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7250'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_CNTL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7255-FETCH-DRWR-ID-CNTL-CURSOR                                 *        
      *    THIS PARA IS TO FETCH THE DRWR_ID_CNTL_CURSOR               *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7255-FETCH-DRWR-ID-CNTL-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
                FETCH  DRWR_ID_CNTL_CURSOR                              
                INTO   :CS-CASH-DRAWER-ID                               
                      ,:CS-AMT-BASIC-WORK                               
                      ,:CS-CODE-CSH-DRWR-STAT                           
                      ,:CS-CREATED-TS :WS-NULL-IND3                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-RETURN-CODE.                              
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-NULL-IND3 < ZERO                                   
                   MOVE LOW-VALUES TO CS-CREATED-TS                     
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-1      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7255'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASH_DRWR_CNTL'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7255-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7300-CK-CIS-PAYMENT                                           *         
      *   TO CHECK IF THE ACOOUNT BELONGS TO CIS PAYMENT.             *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       7300-CK-CIS-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
                SELECT  :WS-YES                                         
PRJ586                 ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO    :WS-CIS-PAYMENT-IND                             
PRJ586                 ,:RS-LAST-UPDATE-TS :WS-NULL-IND5                 
                FROM    CSS_ACCOUNT                                     
                WHERE   ACCOUNT_NO = :CJ-ACCOUNT-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  :WS-YES                                                 
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*         INTO    :WS-CIS-PAYMENT-IND                                     
MFA-TR*                ,:RS-LAST-UPDATE-TS:WS-NULL-IND5                         
MFA-TR*         FROM    CSS_ACCOUNT                                             
MFA-TR*         WHERE   ACCOUNT_NO = :CJ-ACCOUNT-NO                             
MFA-TR*     QUERYNO 7300                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
PRJ586         IF WS-NULL-IND5 < ZERO                                   
PRJ586             MOVE LOW-VALUES TO RS-LAST-UPDATE-TS                 
PRJ586         END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
PRJ586            IF CJ-TRAN-ID = 'S319'                                
PRJ586            OR CJ-TRAN-ID = 'A400'                                
PRJ586            OR CJ-TRAN-ID = 'P400'                                
PRJ586               MOVE WS-YES TO WS-CIS-PAYMENT-IND                  
PRJ586            ELSE                                                  
PRJ586               MOVE WS-NO TO WS-CIS-PAYMENT-IND                   
PRJ586            END-IF                                                
               ELSE                                                     
                  MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE-1     
                  MOVE PROGRAM-NAME             TO ABEND-PROGRAM        
                  MOVE '7300'                   TO ACTIVE-PARAGRAPH     
                  MOVE 'SELECT'                 TO ABEND-FUNCTION       
                  MOVE SPACES                   TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                  MOVE 'CSS_ACCOUNT'            TO TABLE-1              
                  MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1      
                  MOVE 'CASH_COMPANY_NO'        TO TABLE-ELEMENT-2      
                  MOVE 'CASH_LOCAL_OFFICE'      TO TABLE-ELEMENT-3      
                  MOVE 'DATE_CASH_REPORT'       TO TABLE-ELEMENT-4      
                  MOVE CJ-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1    
                  MOVE CJ-CASH-COMPANY-NO       TO HOSTVAR-ELEMENT-2    
                  MOVE CJ-CASH-LOCAL-OFFICE     TO HOSTVAR-ELEMENT-3    
                  MOVE CJ-DATE-CASH-REPORT      TO HOSTVAR-ELEMENT-4    
                  PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT          
           END-IF
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7400-GET-TRAN-DESC                                             *        
      *    GET THE DESCRIPTION FOR THE TRAN-ID                         *        
      *                                                                *        
      ******************************************************************42800000
      *                                                                         
       7400-GET-TRAN-DESC.                                              
                                                                        
           EXEC SQL                                                     
                SELECT  APPL_PROGRAM_DESC                               
                INTO    :K9-APPL-PROGRAM-DESC                           
                FROM    CSS_APPL_PGM_DESC                               
                WHERE   APPL_PROGRAM_ID  = :CJ-TRAN-ID                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  APPL_PROGRAM_DESC                                       
MFA-TR*         INTO    :K9-APPL-PROGRAM-DESC                                   
MFA-TR*         FROM    CSS_APPL_PGM_DESC                                       
MFA-TR*         WHERE   APPL_PROGRAM_ID  = :CJ-TRAN-ID                          
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE CJ-TRAN-ID              TO K9-APPL-PROGRAM-DESC  
               ELSE                                                     
                  MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE-1      
                  MOVE PROGRAM-NAME            TO ABEND-PROGRAM         
                  MOVE '7400'                  TO ACTIVE-PARAGRAPH      
                  MOVE 'SELECT'                TO ABEND-FUNCTION        
                  MOVE SPACES                  TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                  MOVE 'CSS_APPL_PGM_DESC'     TO TABLE-1               
                  MOVE 'TRAN_ID'               TO TABLE-ELEMENT-1       
                  MOVE 'CASH_COMPANY_NO'       TO TABLE-ELEMENT-2       
                  MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-3       
                  MOVE 'DATE_CASH_REPORT'      TO TABLE-ELEMENT-4       
                  MOVE CJ-TRAN-ID              TO HOSTVAR-ELEMENT-1     
                  MOVE CJ-CASH-COMPANY-NO      TO HOSTVAR-ELEMENT-2     
                  MOVE CJ-CASH-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-3     
                  MOVE CJ-DATE-CASH-REPORT     TO HOSTVAR-ELEMENT-4     
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *                                                            *            
      * 8000A-DELETE-GTT-ROWS                                      *            
      *                                                            *            
      **************************************************************            
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04756_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04756_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04756_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8000B-DELETE-GTT-ROWS                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04756_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04756_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '8000B'             TO ACTIVE-PARAGRAPH              
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE 'DELETE'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSR04756_R2'       TO TABLE-1                       
              MOVE SPACES              TO TABLE-ELEMENT-1               
              MOVE SPACES              TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************42800000
      *                                                                *        
      * 9700 -  ABEND HANDLING ROUTINE                                 *42810000
      *     9700-PROCESS-ABEND                                         *42810000
      *                                                                *        
      ******************************************************************42820000
      *                                                                         
           EXEC SQL                                                     01720000
                INCLUDE CPD0023C                                        01730000
           END-EXEC.                                                    01740000
      *                                                                         
      ******************************************************************42800000
      *                                                                *        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      *     9900-SQL-ERROR-ROUTINE                                     *        
      *     9975-ABEND-CONTROL-TRANSFER                                *        
      *                                                                *        
      ******************************************************************42820000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                 42860000
      ******************************************************************        
      *                                                                *        
      * 8100-SEMD-RESULT-1                                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                 42860000
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04756_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,CASH_LOCAL_OFFICE                                   
                   ,USER_ID                                             
                   ,DATE_TRAN                                           
                   ,CASH_DRAWER_ID                                      
                   ,CASH_DRAWER_STAT                                    
                   ,TRAN_TIME                                           
                   ,TRAN_ID                                             
                   ,TRAN_DESC                                           
                   ,ACCOUNT_NO                                          
                   ,CASH_AMT                                            
                   ,CHECK_MO_AMT                                        
                   ,OTHER_AMT                                           
                   ,TOTAL_AMT                                           
                   ,BANK_TRANS_TOTAL                                    
                   ,WORK_FUND_TOTAL                                     
                   ,ENTRY_NO                                            
                   ,TRAN_COMMENT                                        
                   ,REVERSED_FLAG                                       
                   ,CIS_PAYMENT_IND                                     
                   ,MULTI_BATCH_IND                                     
                   ,TRAN_TS                                             
                   ,CURRENCY_TYPE                                       
                   ,CODE_PYMT_FACILITY                                  
                   ,CREATED_TS                                          
PRJ586             ,LAST_UPDATE_TS                                      
PRJ586             ,METER_NO                                            
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE-1                                    
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-CASH-LOCAL-OFFICE                                
                   ,:S-USER-ID                                          
                   ,:S-DATE-TRAN                                        
                   ,:S-CASH-DRAWER-ID                                   
                   ,:S-CASH-DRAWER-STAT                                 
                   ,:S-TRAN-TIME                                        
                   ,:S-TRAN-ID                                          
                   ,:S-TRAN-DESC                                        
                   ,:S-ACCOUNT-NO                                       
                   ,:S-CASH-AMOUNT                                      
                   ,:S-CHECK-MO-AMT                                     
                   ,:S-OTHER-AMT                                        
                   ,:S-TOTAL-AMOUNT                                     
                   ,:S-BANK-TRANS-TOTAL                                 
                   ,:S-WORK-FUND-TOTAL                                  
                   ,:S-ENTRY-NO                                         
                   ,:S-TRAN-COMMENT                                     
                   ,:S-REVERSED-FLAG                                    
                   ,:S-CIS-PAYMENT-IND                                  
                   ,:S-MULTI-BATCH-IND                                  
                   ,:S-TRAN-TS                                          
                   ,:S-CURRENCY-TYPE                                    
                   ,:S-CODE-PYMT-FACILITY                               
                   ,:S-CREATED-TS                                       
PRJ586             ,:S-LAST-UPDATE-TS                                   
PRJ586             ,:S-METER-NO                                         
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04756_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,CASH_LOCAL_OFFICE                                           
MFA-TR*            ,USER_ID                                                     
MFA-TR*            ,DATE_TRAN                                                   
MFA-TR*            ,CASH_DRAWER_ID                                              
MFA-TR*            ,CASH_DRAWER_STAT                                            
MFA-TR*            ,TRAN_TIME                                                   
MFA-TR*            ,TRAN_ID                                                     
MFA-TR*            ,TRAN_DESC                                                   
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,CASH_AMT                                                    
MFA-TR*            ,CHECK_MO_AMT                                                
MFA-TR*            ,OTHER_AMT                                                   
MFA-TR*            ,TOTAL_AMT                                                   
MFA-TR*            ,BANK_TRANS_TOTAL                                            
MFA-TR*            ,WORK_FUND_TOTAL                                             
MFA-TR*            ,ENTRY_NO                                                    
MFA-TR*            ,TRAN_COMMENT                                                
MFA-TR*            ,REVERSED_FLAG                                               
MFA-TR*            ,CIS_PAYMENT_IND                                             
MFA-TR*            ,MULTI_BATCH_IND                                             
MFA-TR*            ,TRAN_TS                                                     
MFA-TR*            ,CURRENCY_TYPE                                               
MFA-TR*            ,CODE_PYMT_FACILITY                                          
MFA-TR*            ,CREATED_TS                                                  
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,METER_NO                                                    
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE-1                                            
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-CASH-LOCAL-OFFICE                                        
MFA-TR*            ,:S-USER-ID                                                  
MFA-TR*            ,:S-DATE-TRAN                                                
MFA-TR*            ,:S-CASH-DRAWER-ID                                           
MFA-TR*            ,:S-CASH-DRAWER-STAT                                         
MFA-TR*            ,:S-TRAN-TIME                                                
MFA-TR*            ,:S-TRAN-ID                                                  
MFA-TR*            ,:S-TRAN-DESC                                                
MFA-TR*            ,:S-ACCOUNT-NO                                               
MFA-TR*            ,:S-CASH-AMOUNT                                              
MFA-TR*            ,:S-CHECK-MO-AMT                                             
MFA-TR*            ,:S-OTHER-AMT                                                
MFA-TR*            ,:S-TOTAL-AMOUNT                                             
MFA-TR*            ,:S-BANK-TRANS-TOTAL                                         
MFA-TR*            ,:S-WORK-FUND-TOTAL                                          
MFA-TR*            ,:S-ENTRY-NO                                                 
MFA-TR*            ,:S-TRAN-COMMENT                                             
MFA-TR*            ,:S-REVERSED-FLAG                                            
MFA-TR*            ,:S-CIS-PAYMENT-IND                                          
MFA-TR*            ,:S-MULTI-BATCH-IND                                          
MFA-TR*            ,:S-TRAN-TS                                                  
MFA-TR*            ,:S-CURRENCY-TYPE                                            
MFA-TR*            ,:S-CODE-PYMT-FACILITY                                       
MFA-TR*            ,:S-CREATED-TS                                               
MFA-TR*            ,:S-LAST-UPDATE-TS                                           
MFA-TR*            ,:S-METER-NO                                                 
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS-RS1                
                                            WS-COUNT-1                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04756_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8200-SEND-RESULT-2                                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04756_R2                         
                (                                                       
                    RETURN_CODE                                         
                   ,CREDIT_CARD_COUNT                                   
                   ,CREDIT_CARD_AMOUNT                                  
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE-2                                    
                   ,:S-CREDIT-CARD-COUNT                                
                   ,:S-CREDIT-CARD-AMOUNT                               
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04756_R2                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,CREDIT_CARD_COUNT                                           
MFA-TR*            ,CREDIT_CARD_AMOUNT                                          
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE-2                                            
MFA-TR*            ,:S-CREDIT-CARD-COUNT                                        
MFA-TR*            ,:S-CREDIT-CARD-AMOUNT                                       
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS-RS2                
                                            WS-COUNT-2                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04756_R2'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8800-CHECK-RESULTS                                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF WS-COUNT-1     = 0                                        
              INITIALIZE TDS-RETURN-FIELDS-1                            
              MOVE 100                      TO RS-RETURN-CODE-1         
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 8100-SEND-RESULT-1    THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-COUNT-2   = 0                                          
              INITIALIZE TDS-RETURN-FIELDS-2                            
              MOVE 100                      TO RS-RETURN-CODE-2         
              PERFORM 2000B-MOVE-RESULT     THRU 2000B-EXIT             
              PERFORM 8200-SEND-RESULT-2    THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE                                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
      *                                                                 00300000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N' TO SEND-DONE-SW.                                    
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-2.                              
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-RESULT-1                                         
                    MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1       
                                                  ABEND-SQLCODE         
               WHEN WS-RESULT-2                                         
                    MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-2       
                                                  ABEND-SQLCODE         
           END-EVALUATE.                                                
                                                                        
           MOVE SQLERRMC TO ABEND-SQLERRMC.                             
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK' TO ABEND-FUNCTION                         
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
                                                                        
           MOVE WS-RETURN-CODE-1 TO S-RETURN-CODE-1.                    
           MOVE WS-RETURN-CODE-2 TO S-RETURN-CODE-2.                    
                                                                        
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   9999-END-PROGRAM                                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS-RS1 < 1                                          
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                 
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
