       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04755.                                         
COB303 DATE-WRITTEN.  MARCH 2014.                                       
       DATE-COMPILED.                                                   
      *                                                                 00050003
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES LOCAL OFFICE SUMMARY AND ALSO        *00190002
      *  CREDIT CARD DETAILS.                                          *        
      *                                                                *00150000
      *  BUSOP NAME: GETCASHLOCALOFFICESUMMARYBUSINESSOP               *        
      ******************************************************************00160000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  03/26/14  AP40911    THIS PROCEDURE WAS WRITTEN TO USE IN CIS *00270002
      *                       MODERNIZATION TO RETRIEVE OFFICE SUMMARY.*        
PRJ586*  02/23/15  AP40911    1)RETRIEVE DEPOSIT AMOUNT                *        
      *                       2)DRAWER OPEN USER ID AS I'TS REQUIRED   *        
      *                         TO GET VIEW DRAWER DETAILS.            *        
      *                       3)GET CASHIER PROFILE NAME AS PER UI     *        
      *                          DESIGN REQUIREMENT.                   *        
PDSUPP*  09/10/15  cb18344    INCREASED THE SIZE OF S-TRAN-TYPE-COUNT  *        
      *                       TO ALLOW LARGER NUMBER OF PAYMENTS       *        
A17897*  11/30/16  AP40911    FIX FOR ACTUAL-DEPOSIT-AMT               *        
      ******************************************************************00290000
      ******************************************************************00290003
      *                                                                *00300003
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00310003
      *                                                                *00320003
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00330003
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00340003
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00350003
      *  3000 - 4999  NOT USED                                         *00360003
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00370003
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00380003
      *  7000 - 7999  INPUT MODULES                                    *00390003
      *  8000 - 8999  OUTPUT MODULES                                   *00400003
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00410003
      *                                                                *00420003
      ******************************************************************00430003
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04755'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04755 STARTS HERE'.                  
                                                                        
      ******************************************************************00520003
      *    COBOL WORKING STORAGE COPY BOOKS                            *00530003
      ******************************************************************00540003
                                                                        
          COPY CWS00303.                                                00590003
          COPY CJF00101.                                                00600006
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00620003
      *    WORK AREAS                                                  *00630003
      ******************************************************************00640003
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  COUNTER-FLAG.                                                
           05  CTR-ROWS-1               PIC S9(9) COMP VALUE 0.         
           05  CTR-ROWS-3               PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(8)  VALUE 'CSR04755'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE +0.       
PRJ586     05  WS-NULL-IND4             PIC S9(04) COMP VALUE +0.       
           05  WS-BMX-LOCAL-OFFICE      PIC X(3) VALUE SPACES.          
           05  WS-COUNT-1               PIC S9(9) COMP VALUE 0.         
           05  WS-COUNT-3               PIC S9(9) COMP VALUE 0.         
           05  WS-RETURN-CODE-1         PIC S9(4)    COMP VALUE 0.      
           05  WS-RETURN-CODE-3         PIC S9(4)    COMP VALUE 0.      
                                                                        
                                                                        
       01  WS-WORK-FIELDS.                                              
PRJ586     05 WS-DRWR-OPEN-USER-ID         PIC X(07) VALUE SPACE.       
PRJ586     05 WS-CASHIER-FULL-NAME         PIC X(40) VALUE SPACES.      
PRJ586     05 WS-DRWR-CLOSED-CASHIER-NAME  PIC X(40) VALUE SPACES.      
PRJ586     05 WS-RPT-CLOSED-CASHIER-NAME   PIC X(40) VALUE SPACES.      
COB305     05 WS-GEN-LED-AMT        PIC S9(11)V99 COMP-3 VALUE 0.       
           05 WS-GL-ACCT-NO-ED             PIC 9(3).9(4).               
COB305     05 WS-TOTAL-AMOUNT        PIC S9(11)V99 COMP-3 VALUE 0.       
           05 WS-TRAN-DESC                 PIC X(20) VALUE SPACES.      
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-GL-ACCT-FLAG          PIC X(01) VALUE 'N'.            
                                                                        
       01  FILLER                       PIC X(32) VALUE                 
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  GTT-RETURN-FIELDS-1.                                         
           05  S-RETURN-CODE-1          PIC S9(9) COMP VALUE 0.         
PRJ586     05  S-DRWR-OPEN-USER-ID      PIC X(07) VALUE SPACE.          
PRJ586     05  S-DRWR-OPEN-USER-NAME    PIC X(40) VALUE SPACE.          
           05  S-DRAWER-NO              PIC S9(04) COMP.                
           05  S-DRAWER-STATUS          PIC X(06) VALUE SPACE.          
           05  S-DRAWER-TOTAL           PIC S9(11)V99 COMP-3 VALUE +0.  
           05  S-RPT-CLOSED-DATETIME    PIC X(26) VALUE SPACE.          
           05  S-DRWR-CLOSED-DATETIME   PIC X(26) VALUE SPACE.          
PRJ586     05  S-DRWR-CLOSED-BY         PIC X(40) VALUE SPACE.          
PRJ586     05  S-RPT-CLOSED-BY          PIC X(40) VALUE SPACE.          
           05  S-CREATED-TS             PIC X(026).                     
PRJ586     05  S-ACTUAL-DEPOSIT-AMT     PIC S9(11)V99 COMP-3 VALUE +0.  
                                                                        
       01  GTT-RETURN-FIELDS-3.                                         
           05  S-RETURN-CODE-3          PIC S9(9) COMP VALUE 0.         
           05  S-PYMT-TRAN-TYPE         PIC X(20) VALUE SPACE.          
PDSUPP     05  S-TRAN-TYPE-COUNT        PIC S9(07) COMP.                
PDSUPP     05  S-TRAN-TYPE-AMOUNT       PIC S9(13)V99 COMP-3 VALUE +0.  
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  GL-ACCOUNT-STATUS        PIC  X(01).                     
               88  CLEARING-ACCOUNT               VALUE 'C'.            
               88  LIHEAP-PAYMENT                 VALUE 'L'.            
               88  LIHEAP-REVERSAL                VALUE 'R'.            
           05  WS-CSH-DRWR-STATUS       PIC  X(06).                     
               88  CSH-DRWR-STAT-CLOSED           VALUE 'CLOSED'.       
               88  CSH-DRWR-STAT-ACTIVE           VALUE 'ACTIVE'.       
                                                                        
           05  WS-NO-MORE-DATA          PIC  X(01) VALUE 'N'.           
               88  NO-MORE-JRNL-DATA               VALUES 'Y'.          
               88  MORE-JRNL-DATA                  VALUES 'N'.          
                                                                        
           05  WS-NO-MORE-CNTL-DATA     PIC  X(01) VALUE 'N'.           
               88  NO-MORE-CNTL-DATA               VALUES 'Y'.          
                                                                        
          05 WS-RESULT-TYPE          PIC 9(01) VALUE ZERO.              
             88 WS-RESULT-1                    VALUE 1.                 
             88 WS-RESULT-3                    VALUE 3.                 
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      ******************************************************************02010037
      *    DB2 INCLUDES                                                *02020037
      ******************************************************************02030037
                                                                        
           EXEC SQL                                                     02050037
              INCLUDE SQLCA                                             02060037
           END-EXEC.                                                    02070037
      ******************************************************************02080037
      *    CSS_CSH_DRWR_JRNL CJ                                        *02090037
      ******************************************************************02100037
            EXEC SQL                                                    02110037
                INCLUDE TBCDJRNL                                        02120037
            END-EXEC.                                                   02130037
                                                                        
      ******************************************************************02150037
      *    CSS_CSH_DRWR_CNTL CS                                        *02160037
      ******************************************************************02170037
            EXEC SQL                                                    02180037
               INCLUDE  TBCDCNTL                                        02190037
            END-EXEC.                                                   02200037
                                                                        
      ******************************************************************02220037
      *    CSS_LIEAP_AGENCY I5                                         *02240037
      ******************************************************************02250037
           EXEC SQL                                                     02260037
              INCLUDE  TBLIAGCY                                         02270037
           END-EXEC.                                                    02280037
                                                                        
      ******************************************************************02370037
      *    CSS_GL_ACCT_NO   GO                                         *02380037
      ******************************************************************02390037
           EXEC SQL                                                     02400037
              INCLUDE TBGLATNO                                          02410037
           END-EXEC.                                                    02420037
                                                                        
      ******************************************************************02430037
      *    CSS_CSH_REPORT_HDR   YR                                     *02440037
      ******************************************************************02450037
           EXEC SQL                                                     02460037
              INCLUDE TBCSRPHD                                          02470037
           END-EXEC.                                                    02480037
                                                                        
      ******************************************************************02510050
      *    CSS_USER_PROFILE    PF                                      *02520050
      ******************************************************************02530050
           EXEC SQL                                                     02540050
              INCLUDE TBUSRPRF                                          02550050
           END-EXEC.                                                    02560050
                                                                        
      ******************************************************************02510050
      *    CSS_PAYMENT_TRANS   JT                                      *02520050
      ******************************************************************02530050
           EXEC SQL                                                     02540050
              INCLUDE TBPMTRAN                                          02550050
           END-EXEC.                                                    02560050
                                                                        
      ******************************************************************        
      *   CSS_APPL_PGM_DESC    K9                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPGMDSC                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_BANK_TRANSFER   YB                                 *             
      *************************************************************             
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBBNKXFR                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      **********************************************************        02590037
      *         CURSOR FOR CSS_CSH_DRWR_CNTL                            02600037
      **********************************************************        02610037
           EXEC SQL                                                     
                DECLARE  CNTL_CURSOR  CURSOR FOR                        
                SELECT                                                  
                       CASH_DRAWER_ID,                                  
                       USER_ID,                                         
                       CODE_CSH_DRWR_STAT,                              
                       REPLACE(REPLACE(CONVERT(CHAR(26), BALANCED_TS
           , 121), ' ', '-'), ':', '.') BALANCED_TS,                           
                       BALANCED_BY,                                     
                       REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                FROM                                                    
                  CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                       
                WHERE    CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO       
                  AND    CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE     
                  AND    DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )      
                  ORDER BY                                              
                         CASH_DRAWER_ID                                 
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02620037
MFA-TR*         DECLARE  CNTL_CURSOR  CURSOR FOR                        02630037
MFA-TR*         SELECT                                                  02640037
MFA-TR*                CASH_DRAWER_ID,                                  02650037
MFA-TR*                USER_ID,                                                 
MFA-TR*                CODE_CSH_DRWR_STAT,                              02660037
MFA-TR*                BALANCED_TS,                                     02670037
MFA-TR*                BALANCED_BY,                                     02680037
MFA-TR*                CREATED_TS                                               
MFA-TR*         FROM                                                    02730037
MFA-TR*           CSS_CSH_DRWR_CNTL                                     02740037
MFA-TR*         WHERE    CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO       02750037
MFA-TR*           AND    CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE     02760037
MFA-TR*           AND    DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT      02770037
MFA-TR*           ORDER BY                                              02780037
MFA-TR*                  CASH_DRAWER_ID                                 02790037
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    02810056
HPCCDM*EJECT                                                            02820037
      **********************************************************        02590037
      *         CURSOR FOR CSS_CSH_DRWR_JRNL                            02600037
      **********************************************************        02610037
           EXEC SQL                                                     
                DECLARE  JRNL_CURSOR  CURSOR FOR                        
                SELECT                                                  
                       CASH_COMPANY_NO,                                 
                       CASH_LOCAL_OFFICE,                               
                       DATE_CASH_REPORT,                                
                       ENTRY_NO,                                        
                       CURRENCY_TYPE,                                   
                       TRAN_DATA,                                       
                       TRAN_ID,                                         
                       TRAN_APPL_NO,                                    
                       CURRENCY_TYPE MSQ056A9                                   
                FROM                                                    
                  CSS_CSH_DRWR_JRNL WITH(READUNCOMMITTED)                       
                WHERE    CASH_COMPANY_NO    = :CJ-CASH-COMPANY-NO       
                  AND    CASH_LOCAL_OFFICE  = :CJ-CASH-LOCAL-OFFICE     
                  AND    DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
                  AND    CASH_DRAWER_ID     = :CJ-CASH-DRAWER-ID        
                  ORDER BY                                              
                         CASH_DRAWER_ID,                                
                         CURRENCY_TYPE                                  
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ056
MFA-TR*    EXEC SQL                                                     02620037
MFA-TR*         DECLARE  JRNL_CURSOR  CURSOR FOR                        02630037
MFA-TR*         SELECT                                                  02640037
MFA-TR*                CASH_COMPANY_NO,                                 02650037
MFA-TR*                CASH_LOCAL_OFFICE,                               02660037
MFA-TR*                DATE_CASH_REPORT,                                02670037
MFA-TR*                ENTRY_NO,                                        02690037
MFA-TR*                CURRENCY_TYPE,                                   02710037
MFA-TR*                TRAN_DATA,                                       02720037
MFA-TR*                TRAN_ID,                                                 
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                CURRENCY_TYPE                                            
MFA-TR*         FROM                                                    02730037
MFA-TR*           CSS_CSH_DRWR_JRNL                                     02740037
MFA-TR*         WHERE    CASH_COMPANY_NO    = :CJ-CASH-COMPANY-NO       02750037
MFA-TR*           AND    CASH_LOCAL_OFFICE  = :CJ-CASH-LOCAL-OFFICE     02760037
MFA-TR*           AND    DATE_CASH_REPORT   = :CJ-DATE-CASH-REPORT      02770037
MFA-TR*           AND    CASH_DRAWER_ID     = :CJ-CASH-DRAWER-ID                
MFA-TR*           ORDER BY                                              02780037
MFA-TR*                  CASH_DRAWER_ID,                                02790037
MFA-TR*                  CURRENCY_TYPE                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    02810056
HPCCDM*EJECT                                                            02820037
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-COMPANY-NO          PIC X(2).                           
       01  PARM-CASH-LOCAL-OFFICE   PIC X(3).                           
       01  PARM-CASH-REPORT-DATE    PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING  PARM-COMPANY-NO                        
                                 PARM-CASH-LOCAL-OFFICE                 
                                 PARM-CASH-REPORT-DATE.                 
                                                                        
      ******************************************************************03090037
      * 0000-MAINLINE                                                  *03100037
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03110037
      ******************************************************************03120037
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03240037
      * 0100-INITIALIZE                                                *03250037
      *                                                                *03260037
      *     1. RESET DB2 ERROR HANDLERS                                *03270037
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03280037
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03290037
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03300037
      *                                                                *03310037
      ******************************************************************03320037
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
      *                                                                         
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     RETURN_CODE                                        
PRJ586              ,LTRIM(RTRIM(DRWR_OPEN_USER_ID))    AS 
           DRWR_OPEN_USER_ID   
PRJ586              ,LTRIM(RTRIM(DRWR_OPEN_USER_NAME))  AS 
           DRWR_OPEN_USER_NAME 
                    ,DRAWER_NO                                          
                    ,LTRIM(RTRIM(DRAWER_STATUS))        AS  
           DRAWER_STATUS      
                    ,DRAWER_TOTAL                                       
                    ,LTRIM(RTRIM(RPT_CLOSED_DTETIME))   AS  
           RPT_CLOSED_DTETIME 
                    ,LTRIM(RTRIM(DRWR_CLOSED_DTETME))   AS  
           DRWR_CLOSED_DTETME 
                    ,LTRIM(RTRIM(DRWR_CLOSED_BY))       AS  
           DRWR_CLOSED_BY     
                    ,LTRIM(RTRIM(RPT_CLOSED_BY))        AS  
           RPT_CLOSED_BY      
                    ,CREATED_TS                                         
PRJ586              ,ACTUAL_DEPOSIT_AMT                                 
                FROM                                                    
                    #CSR04755_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STRIP(DRWR_OPEN_USER_ID)    AS DRWR_OPEN_USER_ID           
MFA-TR*             ,STRIP(DRWR_OPEN_USER_NAME)  AS DRWR_OPEN_USER_NAME         
MFA-TR*             ,DRAWER_NO                                                  
MFA-TR*             ,STRIP(DRAWER_STATUS)        AS  DRAWER_STATUS              
MFA-TR*             ,DRAWER_TOTAL                                               
MFA-TR*             ,STRIP(RPT_CLOSED_DTETIME)   AS  RPT_CLOSED_DTETIME         
MFA-TR*             ,STRIP(DRWR_CLOSED_DTETME)   AS  DRWR_CLOSED_DTETME         
MFA-TR*             ,STRIP(DRWR_CLOSED_BY)       AS  DRWR_CLOSED_BY             
MFA-TR*             ,STRIP(RPT_CLOSED_BY)        AS  RPT_CLOSED_BY              
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,ACTUAL_DEPOSIT_AMT                                         
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04755_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE C3 CURSOR  FOR                       
                SELECT                                                  
                     RETURN_CODE                                        
                    ,PYMT_TRAN_TYPE                                     
                    ,TRAN_TYPE_COUNT                                    
                    ,TRAN_TYPE_AMOUNT                                   
                FROM                                                    
                    #CSR04755_R3                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C3 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,PYMT_TRAN_TYPE                                             
MFA-TR*             ,TRAN_TYPE_COUNT                                            
MFA-TR*             ,TRAN_TYPE_AMOUNT                                           
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04755_R3                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02530000
      * 0100A-DECLARE-GTT                                              *02540000
      ******************************************************************02610000
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04755_R1'            
                                          TO S-SQL-STATEMENT-V.         
           SET WS-RESULT-1                TO TRUE                       
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04755_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04755_R1
              (                                                       
                     RETURN_CODE            INT                     
                    ,DRWR_OPEN_USER_ID CHAR(07)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,DRWR_OPEN_USER_NAME CHAR(40)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,DRAWER_NO              SMALLINT                    
                    ,DRAWER_STATUS CHAR(06)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,DRAWER_TOTAL           DECIMAL(13,2)               
                    ,RPT_CLOSED_DTETIME CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,DRWR_CLOSED_DTETME CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,DRWR_CLOSED_BY CHAR(40)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,RPT_CLOSED_BY CHAR(40)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CREATED_TS CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
PRJ586              ,ACTUAL_DEPOSIT_AMT     DECIMAL(11,2)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE            TO WS-SQLSTATE.                     
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                     NEXT SENTENCE                                      
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04755_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04755_R3'            
                                          TO S-SQL-STATEMENT-V.         
           SET WS-RESULT-3                TO TRUE                       
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04755_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04755_R3
              (                                                       
                     RETURN_CODE            INT                     
                    ,PYMT_TRAN_TYPE CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,TRAN_TYPE_COUNT        INT                     
                    ,TRAN_TYPE_AMOUNT       DECIMAL(13,2)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE            TO WS-SQLSTATE.                     
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DELETE-GTT-ROWS THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                     NEXT SENTENCE                                      
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04755_R3'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************03600037
      * 1000-PROCESS-INPUT                                             *03610037
      *     1. RECEIVE PARMS.                                          *03620037
      ******************************************************************03630037
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                          TO ACTIVE-PARAGRAPH     
                                                                        
           MOVE PARM-CASH-REPORT-DATE           TO CS-DATE-CASH-REPORT, 
                                                   CJ-DATE-CASH-REPORT, 
                                                   JT-DATE-CASH-REPORT, 
PRJ586                                             YB-DATE-CASH-REPORT  
                                                                        
           MOVE PARM-COMPANY-NO                 TO CS-CASH-COMPANY-NO,  
                                                   CJ-CASH-COMPANY-NO,  
PRJ586                                             YB-CASH-COMPANY-NO   
                                                                        
           MOVE PARM-CASH-LOCAL-OFFICE          TO CS-CASH-LOCAL-OFFICE,
                                                   CJ-CASH-LOCAL-OFFICE,
                                                   JT-CASH-LOCAL-OFFICE,
PRJ586                                             YB-CASH-LOCAL-OFFICE 
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04330037
      * 2000-PROCESS-OUTPUT.                                           *04340037
      *                                                                *04350037
      *     1. DESCRIBE RESULT SET                                     *04360037
      *     2. UPDATE DB2 DATA                                         *04370037
      *     3. SEND RESULT SET                                         *04380037
      *                                                                *04390037
      ******************************************************************04400037
      *                                                                 04410037
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                          TO ACTIVE-PARAGRAPH.    
           PERFORM 2200-BUILD-RESULT            THRU 2200-EXIT.         
           SET WS-RESULT-3                      TO TRUE.                
           PERFORM 7800-GET-CREDIT-CARD-DETAILS THRU 7800-EXIT.         
      *                                                                 04480037
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06680037
      * 2200-BUILD-RESULT                                           *   06690037
      *     BUILD THE RESULT SET                                    *   06700037
      ***************************************************************   06710037
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                          TO ACTIVE-PARAGRAPH.    
           INITIALIZE WS-TOTAL-AMOUNT ,                                 
                      WS-CSH-DRWR-STATUS                                
           SET WS-RESULT-1                    TO TRUE                   
           PERFORM 7000-GET-CLR-ACCT-NUMBER   THRU 7000-EXIT            
              PERFORM 7020-OPEN-CNTL-CURSOR      THRU 7020-EXIT         
              PERFORM 7050-FETCH-CNTL-CURSOR     THRU 7050-EXIT         
              IF NO-MORE-CNTL-DATA                                      
                 MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE-1     
                 PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT         
              ELSE                                                      
                 PERFORM 2250-DETAIL-PROCESSING  THRU 2250-EXIT         
              END-IF.                                                   
              PERFORM 7070-CLOSE-CNTL-CURSOR     THRU 7070-EXIT         
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06950086
      * 2250-DETAIL-PROCESSING                                      *   06960086
      * PROCESS THE CASH-DRAWER-ID'S IN THE CNTL TABLE AND SENDS    *   06970086
      * RESULTS.                                                    *   06980086
      ***************************************************************   06990086
       2250-DETAIL-PROCESSING.                                          
            PERFORM UNTIL NO-MORE-CNTL-DATA                             
                MOVE CS-CASH-DRAWER-ID           TO CJ-CASH-DRAWER-ID,  
                                                    S-DRAWER-NO         
                MOVE CS-CREATED-TS               TO S-CREATED-TS        
                IF CS-CODE-CSH-DRWR-STAT = 'A'                          
                   SET CSH-DRWR-STAT-ACTIVE TO TRUE                     
                ELSE                                                    
                   SET CSH-DRWR-STAT-CLOSED TO TRUE                     
                END-IF                                                  
                MOVE CS-USER-ID                  TO PF-USER-ID          
                                                    WS-DRWR-OPEN-USER-ID
                IF PF-USER-ID = SPACES                                  
PRJ586             MOVE SPACES                   TO WS-CASHIER-FULL-NAME
                ELSE                                                    
                   PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT         
                END-IF                                                  
PRJ586          MOVE WS-DRWR-OPEN-USER-ID       TO S-DRWR-OPEN-USER-ID  
PRJ586          MOVE WS-CASHIER-FULL-NAME       TO S-DRWR-OPEN-USER-NAME
                PERFORM 7100-OPEN-JRNL-CURSOR    THRU 7100-EXIT         
                PERFORM 7200-FETCH-JRNL-CURSOR   THRU 7200-EXIT         
                IF NO-MORE-JRNL-DATA                                    
                   PERFORM 2500-SELECT-LOCOFF-STATUS                    
                                                 THRU 2500-EXIT         
                   MOVE WS-CSH-DRWR-STATUS       TO S-DRAWER-STATUS     
                   MOVE CS-BALANCED-TS           TO                     
                                                 S-DRWR-CLOSED-DATETIME 
                   MOVE CS-BALANCED-BY           TO PF-USER-ID          
                   IF PF-USER-ID = SPACES                               
PRJ586                MOVE SPACES TO WS-DRWR-CLOSED-CASHIER-NAME        
                   ELSE                                                 
                      PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT      
PRJ586                MOVE WS-CASHIER-FULL-NAME TO                      
PRJ586                                    WS-DRWR-CLOSED-CASHIER-NAME   
                   END-IF                                               
                   MOVE WS-DRWR-CLOSED-CASHIER-NAME TO                  
                                             S-DRWR-CLOSED-BY           
PRJ586             PERFORM 7900-SUM-BANK-DEPOSIT   THRU 7900-EXIT       
PRJ586             MOVE YB-TRANSFER-AMT       TO S-ACTUAL-DEPOSIT-AMT   
                   PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT       
                   INITIALIZE WS-TOTAL-AMOUNT                           
                              WS-CSH-DRWR-STATUS                        
                              GTT-RETURN-FIELDS-1                       
                ELSE                                                    
                   PERFORM 2300-DETAIL-PROCESSING   THRU 2300-EXIT      
                END-IF                                                  
                PERFORM 7300-CLOSE-JRNL-CURSOR      THRU 7300-EXIT      
                PERFORM 7050-FETCH-CNTL-CURSOR      THRU 7050-EXIT      
                SET MORE-JRNL-DATA                  TO TRUE             
            END-PERFORM                                                 
            .                                                           
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06950086
      * 2300-DETAIL-PROCESSING                                      *   06960086
      * PROCESS THE JRNL TABLE DETAIL AND SENDS THE RESULTS TO      *   06970086
      * OUTPUT VARIABLES.                                           *   06980086
      ***************************************************************   06990086
       2300-DETAIL-PROCESSING.                                          
            PERFORM UNTIL NO-MORE-JRNL-DATA                             
                PERFORM 2400-PROCESS-DATA-LINE THRU 2400-EXIT           
                PERFORM 7200-FETCH-JRNL-CURSOR     THRU 7200-EXIT       
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   CONTINUE                                             
                ELSE                                                    
                   MOVE SPACES            TO S-DRWR-CLOSED-DATETIME     
                   MOVE WS-TOTAL-AMOUNT       TO S-DRAWER-TOTAL         
                   PERFORM 2500-SELECT-LOCOFF-STATUS THRU 2500-EXIT     
                   MOVE WS-CSH-DRWR-STATUS TO S-DRAWER-STATUS           
                   MOVE CS-BALANCED-TS     TO S-DRWR-CLOSED-DATETIME    
                   MOVE CS-BALANCED-BY           TO PF-USER-ID          
                   IF PF-USER-ID = SPACES                               
PRJ586                MOVE SPACES TO WS-DRWR-CLOSED-CASHIER-NAME        
                   ELSE                                                 
                      PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT      
PRJ586                MOVE WS-CASHIER-FULL-NAME  TO                     
PRJ586                                      WS-DRWR-CLOSED-CASHIER-NAME 
                   END-IF                                               
                   MOVE WS-DRWR-CLOSED-CASHIER-NAME TO S-DRWR-CLOSED-BY 
PRJ586             PERFORM 7900-SUM-BANK-DEPOSIT   THRU 7900-EXIT       
PRJ586             MOVE YB-TRANSFER-AMT       TO S-ACTUAL-DEPOSIT-AMT   
                   PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT       
                   INITIALIZE WS-TOTAL-AMOUNT ,                         
                              WS-CSH-DRWR-STATUS,                       
                              GTT-RETURN-FIELDS-1                       
                END-IF                                                  
            END-PERFORM                                                 
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   07450086
      * 2400-PROCESS-DATA-LINE.                                         07460086
      ***************************************************************   07470086
       2400-PROCESS-DATA-LINE.                                          
            MOVE WS-NO                       TO WS-GL-ACCT-FLAG         
            MOVE SPACES                      TO GL-ACCOUNT-STATUS       
            MOVE CJ-TRAN-DATA                TO CJF00101                
            IF WS-101-ACCT-GEN-LED-DR  = WS-101-ACCT-GEN-LED-CR         
               GO TO 2400-EXIT                                          
            ELSE                                                        
               IF (WS-101-ACCT-GEN-LED-DR  = GO-GL-ACCT-NO)  OR         
                  (WS-101-ACCT-GEN-LED-CR  = GO-GL-ACCT-NO)             
                  SET CLEARING-ACCOUNT          TO TRUE                 
               END-IF                                                   
               MOVE WS-101-ACCT-GEN-LED-DR   TO I5-GL-ACCT-NO           
               PERFORM 7400-CHECK-GL-ACCT-NO     THRU 7400-EXIT         
               IF WS-GL-ACCT-FLAG = WS-YES                              
                  SET LIHEAP-PAYMENT         TO TRUE                    
               ELSE                                                     
                  MOVE WS-101-ACCT-GEN-LED-CR TO I5-GL-ACCT-NO          
                                                                        
                  PERFORM 7400-CHECK-GL-ACCT-NO  THRU  7400-EXIT        
                  IF WS-GL-ACCT-FLAG = WS-YES                           
                     IF WS-101-ACCT-GEN-LED-DR = GO-GL-ACCT-NO          
                        SET CLEARING-ACCOUNT          TO TRUE           
                     ELSE                                               
                        SET LIHEAP-REVERSAL     TO TRUE                 
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
            END-IF                                                      
            IF (CLEARING-ACCOUNT OR LIHEAP-PAYMENT OR LIHEAP-REVERSAL)  
               MOVE WS-101-AMT-POSTED      TO WS-GEN-LED-AMT            
               IF (WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO OR            
                  LIHEAP-REVERSAL)                                      
                  COMPUTE WS-GEN-LED-AMT = WS-GEN-LED-AMT * -1          
               END-IF                                                   
                                                                        
               ADD WS-GEN-LED-AMT            TO WS-TOTAL-AMOUNT         
               PERFORM 7500-GET-TRAN-DESC  THRU 7500-EXIT               
               MOVE K9-APPL-PROGRAM-DESC   TO WS-TRAN-DESC              
                                              S-PYMT-TRAN-TYPE          
               IF CJ-TRAN-APPL-NO EQUAL +1                              
                  MOVE 1                   TO S-TRAN-TYPE-COUNT         
               ELSE                                                     
                  MOVE 0                   TO S-TRAN-TYPE-COUNT         
               END-IF                                                   
               MOVE WS-GEN-LED-AMT         TO S-TRAN-TYPE-AMOUNT        
               SET WS-RESULT-3             TO TRUE                      
               PERFORM 2450-TRAN-TYPE-SUMMARY-AMOUNTS  THRU 2450-EXIT   
               SET WS-RESULT-1             TO TRUE                      
            END-IF                                                      
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   07450086
      * 2450-TRAN-TYPE-SUMMARY-AMOUNTS.                                 07460086
      ***************************************************************   07470086
       2450-TRAN-TYPE-SUMMARY-AMOUNTS.                                  
                                                                        
             EXEC SQL                                                   
                  UPDATE #CSR04755_R3                            
                    SET TRAN_TYPE_COUNT  = TRAN_TYPE_COUNT +            
                                           :S-TRAN-TYPE-COUNT,          
                        TRAN_TYPE_AMOUNT = TRAN_TYPE_AMOUNT +           
                                           :S-TRAN-TYPE-AMOUNT          
                    WHERE PYMT_TRAN_TYPE = :S-PYMT-TRAN-TYPE            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*      EXEC SQL                                                           
MFA-TR*           UPDATE SESSION.CSR04755_R3                                    
MFA-TR*             SET TRAN_TYPE_COUNT  = TRAN_TYPE_COUNT +                    
MFA-TR*                                    :S-TRAN-TYPE-COUNT,                  
MFA-TR*                 TRAN_TYPE_AMOUNT = TRAN_TYPE_AMOUNT +                   
MFA-TR*                                    :S-TRAN-TYPE-AMOUNT                  
MFA-TR*             WHERE PYMT_TRAN_TYPE = :S-PYMT-TRAN-TYPE                    
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
               PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT            
              END-IF                                                    
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-3       
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '2450'                      TO ACTIVE-PARAGRAPH      
              MOVE 'UPDATE'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'SESSION.CSR04755_R3'       TO TABLE-1               
              MOVE 'PYMT_TRAN_TYPE'            TO TABLE-ELEMENT-1       
              MOVE  WS-TRAN-DESC               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       2450-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************   07880086
      * 2500-SELECT-LOCOFF-STATUS                                   *   07890086
      * THIS PARA FETCHES THE LOCAL OFFICE STATUS                   *   07900086
      ***************************************************************   07910086
       2500-SELECT-LOCOFF-STATUS.                                       
           PERFORM 7600-SELECT-LOCOFF-STATUS THRU 7600-EXIT             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE YR-USER-ID                TO PF-USER-ID              
              IF PF-USER-ID = SPACES                                    
PRJ586           MOVE SPACES      TO WS-RPT-CLOSED-CASHIER-NAME         
              ELSE                                                      
                 PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT           
PRJ586           MOVE WS-CASHIER-FULL-NAME   TO                         
PRJ586                                   WS-RPT-CLOSED-CASHIER-NAME     
              END-IF                                                    
              MOVE WS-RPT-CLOSED-CASHIER-NAME TO S-RPT-CLOSED-BY        
              MOVE YR-CLOSED-TS               TO S-RPT-CLOSED-DATETIME  
           ELSE                                                         
              MOVE  SPACES TO S-RPT-CLOSED-DATETIME                     
           END-IF                                                       
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08610037
      *    THIS PARA IS TO GET THE CASH CLEAR ACCOUNT NUMBER            08620037
      ******************************************************************08630037
       7000-GET-CLR-ACCT-NUMBER.                                        
           EXEC SQL                                                     
                SELECT GL_ACCT_NO                                       
                INTO   :GO-GL-ACCT-NO                                   
                FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                     
                WHERE  COMPANY_NO   = :CJ-CASH-COMPANY-NO               
                AND    GL_ACCT_NAME = 'CLR-CASH'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08650037
MFA-TR*         SELECT GL_ACCT_NO                                       08660037
MFA-TR*         INTO   :GO-GL-ACCT-NO                                   08670037
MFA-TR*         FROM   CSS_GL_ACCT_NO                                   08680037
MFA-TR*         WHERE  COMPANY_NO   = :CJ-CASH-COMPANY-NO               08690037
MFA-TR*         AND    GL_ACCT_NAME = 'CLR-CASH'                        08700037
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                    08710037

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1       
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7000'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_GL_ACCT_NO'            TO TABLE-1               
              MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-1       
              MOVE  GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-2       
              MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-2     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-3       
              MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE_CASH-REPORT'          TO TABLE-ELEMENT-4       
              MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 08950037
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08980037
      *    THIS PARA IS TO OPEN THE CNTL_CURSOR                        *08990037
      ******************************************************************09000037
       7020-OPEN-CNTL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN CNTL_CURSOR                                        
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1       
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7020'                      TO ACTIVE-PARAGRAPH      
              MOVE 'OPEN'                      TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_CNTL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
              MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
              MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3       
              MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF                                                       
           .                                                            
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09330037
      *    THIS PARA IS TO FETCH THE CNTL_CURSOR                       *09340037
      ******************************************************************09350037
       7050-FETCH-CNTL-CURSOR.                                          
            EXEC SQL                                                    
                 FETCH CNTL_CURSOR                                      
                 INTO  :CS-CASH-DRAWER-ID,                              
                       :CS-USER-ID,                                     
                       :CS-CODE-CSH-DRWR-STAT,                          
                       :CS-BALANCED-TS :WS-NULL-IND1,                    
                       :CS-BALANCED-BY :WS-NULL-IND2,                    
                       :CS-CREATED-TS                                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF WS-NULL-IND1 < ZERO                                
                     MOVE LOW-VALUES TO CS-BALANCED-TS                  
                  END-IF                                                
                  IF WS-NULL-IND2 < ZERO                                
                     MOVE SPACES TO CS-BALANCED-BY                      
                  END-IF                                                
               ELSE                                                     
                  SET NO-MORE-CNTL-DATA TO TRUE                         
               END-IF                                                   
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1      
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7050'                      TO ACTIVE-PARAGRAPH     
               MOVE 'FETCH'                     TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
               MOVE 'CSS_CASH_DRWR_CNTL'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
            END-IF                                                      
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09780037
      *    THIS PARA IS TO CLOSE THE CNTL_CURSOR                        09790037
      ************************************************************      09800037
       7070-CLOSE-CNTL-CURSOR.                                          
            EXEC SQL                                                    
                 CLOSE CNTL_CURSOR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1       
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7070'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_CNTL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
              MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
              MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3       
              MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF                                                       
           .                                                            
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08980037
      *    THIS PARA IS TO OPEN  JRNL_CURSOR                           *08990037
      ******************************************************************09000037
       7100-OPEN-JRNL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN JRNL_CURSOR                                        
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1       
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'OPEN'                      TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CJ-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
              MOVE CJ-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
              MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3       
              MOVE CJ-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE-CASH_REPORT'          TO TABLE-ELEMENT-4       
              MOVE CJ-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09330037
      *    THIS PARA IS TO FETCH THE JRNL_CURSOR                        09340037
      ************************************************************      09350037
       7200-FETCH-JRNL-CURSOR.                                          
            EXEC SQL                                                    
                 FETCH JRNL_CURSOR                                      
                 INTO  :CJ-CASH-COMPANY-NO,                             
                       :CJ-CASH-LOCAL-OFFICE,                           
                       :CJ-DATE-CASH-REPORT,                            
                       :CJ-ENTRY-NO,                                    
                       :CJ-CURRENCY-TYPE,                               
                       :CJ-TRAN-DATA,                                   
                       :CJ-TRAN-ID,                                     
                       :CJ-TRAN-APPL-NO                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  SET NO-MORE-JRNL-DATA TO TRUE                         
               END-IF                                                   
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1      
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7200'                      TO ACTIVE-PARAGRAPH     
               MOVE 'FETCH'                     TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
               MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3      
               MOVE CJ-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3    
               MOVE 'DATE-CASH_REPORT'          TO TABLE-ELEMENT-4      
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
            END-IF.                                                     
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09780037
      *    THIS PARA IS TO CLOSE THE JRNL_CURSOR                        09790037
      ************************************************************      09800037
       7300-CLOSE-JRNL-CURSOR.                                          
            EXEC SQL                                                    
                 CLOSE JRNL_CURSOR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-1       
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7300'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CJ-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
              MOVE CJ-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
              MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3       
              MOVE CJ-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-4       
              MOVE CJ-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10910087
      *    THIS PARA IS TO GET GL-ACCT-NO                              *10920087
      ******************************************************************10930087
       7400-CHECK-GL-ACCT-NO.                                           
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                INTO   :WS-GL-ACCT-FLAG                                 
                FROM   CSS_LIEAP_AGENCY WITH(READUNCOMMITTED)                   
                WHERE  GL_ACCT_NO = :I5-GL-ACCT-NO                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10120037
MFA-TR*         SELECT 'Y'                                              10130037
MFA-TR*         INTO   :WS-GL-ACCT-FLAG                                 10140037
MFA-TR*         FROM   CSS_LIEAP_AGENCY                                 10150037
MFA-TR*         WHERE  GL_ACCT_NO = :I5-GL-ACCT-NO                      10160037
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                    10170037

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)  OR             
              (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                       
              NEXT SENTENCE                                             
           ELSE                                                         
                MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE-1       
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE '7400'                    TO ACTIVE-PARAGRAPH      
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE SPACES                    TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                MOVE 'CSS_LIEAP_AGENCY'        TO TABLE-1               
                MOVE 'GL_ACCT_NO'              TO TABLE-ELEMENT-1       
                MOVE I5-GL-ACCT-NO             TO WS-GL-ACCT-NO-ED      
                MOVE WS-GL-ACCT-NO-ED          TO HOSTVAR-ELEMENT-1     
                MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-2       
                MOVE CJ-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-2     
                MOVE 'USER_ID'                 TO TABLE-ELEMENT-3       
                MOVE CS-USER-ID                TO HOSTVAR-ELEMENT-3     
                MOVE 'DATE-CASH_REPORT'        TO TABLE-ELEMENT-4       
                MOVE CJ-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-4     
                PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT           
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * GET THE TRANSACTION DESCRIPTION BY USING THE TRAN-ID.          *        
      ******************************************************************        
       7500-GET-TRAN-DESC.                                              
                                                                        
           MOVE CJ-TRAN-ID             TO K9-APPL-PROGRAM-ID.           
                                                                        
           EXEC SQL                                                     
              SELECT APPL_PROGRAM_DESC                                  
               INTO :K9-APPL-PROGRAM-DESC                               
               FROM  CSS_APPL_PGM_DESC WITH(READUNCOMMITTED)                    
               WHERE APPL_PROGRAM_ID = :K9-APPL-PROGRAM-ID              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT APPL_PROGRAM_DESC                                          
MFA-TR*        INTO :K9-APPL-PROGRAM-DESC                                       
MFA-TR*        FROM  CSS_APPL_PGM_DESC                                          
MFA-TR*        WHERE APPL_PROGRAM_ID = :K9-APPL-PROGRAM-ID                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE CJ-TRAN-ID            TO K9-APPL-PROGRAM-DESC   
               ELSE                                                     
                   MOVE '7500'                TO ACTIVE-PARAGRAPH       
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS-APPL-PGM-DESC'   TO TABLE-1                
                   MOVE 'APPL-PROGRAM-ID'     TO TABLE-ELEMENT-1        
                   MOVE K9-APPL-PROGRAM-ID    TO HOSTVAR-ELEMENT-1      
                                                                        
                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10910087
      *    THIS PARA IS TO GET THE STATUS OF THE REPORTS               *10920087
      ******************************************************************10930087
       7600-SELECT-LOCOFF-STATUS.                                       
           EXEC SQL                                                     
                SELECT                                                  
                       USER_ID,                                         
                       STATUS,                                          
                       REPLACE(REPLACE(CONVERT(CHAR(26), CLOSED_TS
           , 121), ' ', '-'), ':', '.') CLOSED_TS                              
                INTO   :YR-USER-ID,                                     
                       :YR-STATUS,                                      
                       :YR-CLOSED-TS                                    
                FROM  CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                  
                WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO           
                AND   CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE         
                AND   DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
                AND   STATUS            = 'C'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10950037
MFA-TR*         SELECT                                                  10960037
MFA-TR*                USER_ID,                                         10970060
MFA-TR*                STATUS,                                          10980037
MFA-TR*                CLOSED_TS                                        10990037
MFA-TR*         INTO   :YR-USER-ID,                                     11000061
MFA-TR*                :YR-STATUS,                                      11010060
MFA-TR*                :YR-CLOSED-TS                                    11020037
MFA-TR*         FROM  CSS_CSH_REPORT_HDR                                11030037
MFA-TR*         WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO           11040037
MFA-TR*         AND   CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE         11050037
MFA-TR*         AND   DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT          11060037
MFA-TR*         AND   STATUS            = 'C'                           11070037
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                    11080037

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE-1       
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7600'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-1       
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-1     
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE 'DATE_CASH-REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11340087
      *    THIS PARA IS TO GET THE USER PROFILE SUCH AS FULL NAME       11350087
      ******************************************************************11360087
       7700-GET-USER-PROFILE.                                           
           EXEC SQL                                                     
                SELECT RTRIM(PF.LAST_NAME) + ', ' + RTRIM(PF.FIRST_NAME
           ) + ' ' + RTRIM(PF.MIDDLE_NAME)                            
                INTO   :WS-CASHIER-FULL-NAME                            
                FROM  CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE USER_ID = :PF-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     11380050
MFA-TR*         SELECT RTRIM(PF.LAST_NAME) || ', ' ||                   11390050
MFA-TR*                RTRIM(PF.FIRST_NAME) || ' ' ||                           
MFA-TR*                RTRIM(PF.MIDDLE_NAME)                                    
MFA-TR*         INTO   :WS-CASHIER-FULL-NAME                                    
MFA-TR*         FROM  CSS_USER_PROFILE PF                               11440050
MFA-TR*         WHERE USER_ID = :PF-USER-ID                             11450051
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                    11460050

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE-1       
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7700'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_USER_PROFILE'         TO TABLE-1               
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-1       
               MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11340087
      *    THIS PARA IS TO GET CREDIT CARD COUNT AND AMOUNT            *11350087
      ******************************************************************11360087
       7800-GET-CREDIT-CARD-DETAILS.                                    
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                       COUNT(*),                                        
                       SUM(PAYMENT_AMT)                                 
                INTO                                                    
                       :S-TRAN-TYPE-COUNT,                              
                       :S-TRAN-TYPE-AMOUNT :WS-NULL-IND3                 
                FROM                                                    
                  CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                       
                WHERE    CASH_LOCAL_OFFICE  = '058'                     
                  AND    DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )      
                  AND    PYMT_FACILITY_CD   = 'O'                       
                  AND    CIS.SUBSTR3(CUST_PHONE_NO,8,3)                      
                                           =:JT-CASH-LOCAL-OFFICE       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02860073
MFA-TR*         SELECT                                                  02880073
MFA-TR*                COUNT(*),                                        02900073
MFA-TR*                SUM(PAYMENT_AMT)                                 02930073
MFA-TR*         INTO                                                            
MFA-TR*                :S-TRAN-TYPE-COUNT,                                      
MFA-TR*                :S-TRAN-TYPE-AMOUNT:WS-NULL-IND3                         
MFA-TR*         FROM                                                    02970073
MFA-TR*           CSS_PAYMENT_TRANS                                     02980073
MFA-TR*         WHERE    CASH_LOCAL_OFFICE  = '058'                     02990073
MFA-TR*           AND    DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT      03000073
MFA-TR*           AND    PYMT_FACILITY_CD   = 'O'                               
MFA-TR*           AND    SUBSTR(CUST_PHONE_NO,8,3)                              
MFA-TR*                                    =:JT-CASH-LOCAL-OFFICE               
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7800                                                   
MFA-TR*    END-EXEC.                                                    03050073

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               IF  WS-NULL-IND3 < ZERO                                  
                   MOVE 0 TO S-TRAN-TYPE-AMOUNT                         
               END-IF                                                   
              IF S-TRAN-TYPE-COUNT > 0                                  
               MOVE 'CREDIT CARDS'              TO S-PYMT-TRAN-TYPE     
               PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE-3       
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7800'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_PAYMENT_TRANS'         TO TABLE-1               
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-1       
              MOVE JT-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-1     
              MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-4       
              MOVE JT-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ586******************************************************************        
PRJ586*    7900-GET BANK DEPOSIT FOR A GIVEN DRAWER ID AND DATE CASH   *        
PRJ586*         REPORT.                                                *        
PRJ586******************************************************************        
                                                                        
       7900-SUM-BANK-DEPOSIT.                                           
                                                                        
           MOVE CJ-CASH-DRAWER-ID      TO YB-CASH-DRAWER-ID             
           EXEC SQL                                                     
A17897          SELECT  SUM(                                            
A17897            CASE CODE_DR_CR                                       
A17897                      WHEN 'D' THEN TRANSFER_AMT                  
A17897                      WHEN 'C' THEN TRANSFER_AMT * -1             
A17897            END)                                                  
                  INTO  :YB-TRANSFER-AMT :WS-NULL-IND4                   
                  FROM  CSS_BANK_TRANSFER                               
                 WHERE  CASH_DRAWER_ID = :YB-CASH-DRAWER-ID             
                   AND  DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )         
                   AND  CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE       
                   AND  CASH_COMPANY_NO = :YB-CASH-COMPANY-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  SUM(                                                    
MFA-TR*           CASE CODE_DR_CR                                               
MFA-TR*                     WHEN 'D' THEN TRANSFER_AMT                          
MFA-TR*                     WHEN 'C' THEN TRANSFER_AMT * -1                     
MFA-TR*           END)                                                          
MFA-TR*           INTO  :YB-TRANSFER-AMT:WS-NULL-IND4                           
MFA-TR*           FROM  CSS_BANK_TRANSFER                                       
MFA-TR*          WHERE  CASH_DRAWER_ID = :YB-CASH-DRAWER-ID                     
MFA-TR*            AND  DATE_CASH_REPORT = :YB-DATE-CASH-REPORT                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE               
MFA-TR*            AND  CASH_COMPANY_NO = :YB-CASH-COMPANY-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF  WS-NULL-IND4 < ZERO                                  
                   MOVE 0 TO YB-TRANSFER-AMT                            
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE-1       
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7900'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECTS'                  TO ABEND-FUNCTION        
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02530000
      *8000A-DELETE-GTT-ROWS                                           *02540000
      ******************************************************************02610000
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04755_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04755_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04755_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************02530000
      *8000C-DELETE-GTT-ROWS                                           *02540000
      ******************************************************************02610000
       8000C-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04755_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04755_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000C'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04755_R3'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
       8000C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************02530000
      * 8010-INSERT-GTT-R1                                             *02540000
      ******************************************************************02610000
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04755_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,DRWR_OPEN_USER_ID                                  
                    ,DRWR_OPEN_USER_NAME                                
                    ,DRAWER_NO                                          
                    ,DRAWER_STATUS                                      
                    ,DRAWER_TOTAL                                       
                    ,RPT_CLOSED_DTETIME                                 
                    ,DRWR_CLOSED_DTETME                                 
                    ,DRWR_CLOSED_BY                                     
                    ,RPT_CLOSED_BY                                      
                    ,CREATED_TS                                         
PRJ586              ,ACTUAL_DEPOSIT_AMT                                 
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE-1                                   
                    ,:S-DRWR-OPEN-USER-ID                               
                    ,:S-DRWR-OPEN-USER-NAME                             
                    ,:S-DRAWER-NO                                       
                    ,:S-DRAWER-STATUS                                   
                    ,:S-DRAWER-TOTAL                                    
                    ,:S-RPT-CLOSED-DATETIME                             
                    ,:S-DRWR-CLOSED-DATETIME                            
                    ,:S-DRWR-CLOSED-BY                                  
                    ,:S-RPT-CLOSED-BY                                   
                    ,:S-CREATED-TS                                      
PRJ586              ,:S-ACTUAL-DEPOSIT-AMT                              
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04755_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,DRWR_OPEN_USER_ID                                          
MFA-TR*             ,DRWR_OPEN_USER_NAME                                        
MFA-TR*             ,DRAWER_NO                                                  
MFA-TR*             ,DRAWER_STATUS                                              
MFA-TR*             ,DRAWER_TOTAL                                               
MFA-TR*             ,RPT_CLOSED_DTETIME                                         
MFA-TR*             ,DRWR_CLOSED_DTETME                                         
MFA-TR*             ,DRWR_CLOSED_BY                                             
MFA-TR*             ,RPT_CLOSED_BY                                              
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,ACTUAL_DEPOSIT_AMT                                         
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE-1                                           
MFA-TR*             ,:S-DRWR-OPEN-USER-ID                                       
MFA-TR*             ,:S-DRWR-OPEN-USER-NAME                                     
MFA-TR*             ,:S-DRAWER-NO                                               
MFA-TR*             ,:S-DRAWER-STATUS                                           
MFA-TR*             ,:S-DRAWER-TOTAL                                            
MFA-TR*             ,:S-RPT-CLOSED-DATETIME                                     
MFA-TR*             ,:S-DRWR-CLOSED-DATETIME                                    
MFA-TR*             ,:S-DRWR-CLOSED-BY                                          
MFA-TR*             ,:S-RPT-CLOSED-BY                                           
MFA-TR*             ,:S-CREATED-TS                                              
MFA-TR*             ,:S-ACTUAL-DEPOSIT-AMT                                      
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                    TO CTR-ROWS-1                   
                                           WS-COUNT-1                   
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04755_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02530000
      * 8030-INSERT-GTT-R3                                             *02540000
      ******************************************************************02610000
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04755_R3                         
                (                                                       
                     RETURN_CODE                                        
                    ,PYMT_TRAN_TYPE                                     
                    ,TRAN_TYPE_COUNT                                    
                    ,TRAN_TYPE_AMOUNT                                   
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE-3                                   
                    ,:S-PYMT-TRAN-TYPE                                  
                    ,:S-TRAN-TYPE-COUNT                                 
                    ,:S-TRAN-TYPE-AMOUNT                                
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04755_R3                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,PYMT_TRAN_TYPE                                             
MFA-TR*             ,TRAN_TYPE_COUNT                                            
MFA-TR*             ,TRAN_TYPE_AMOUNT                                           
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE-3                                           
MFA-TR*             ,:S-PYMT-TRAN-TYPE                                          
MFA-TR*             ,:S-TRAN-TYPE-COUNT                                         
MFA-TR*             ,:S-TRAN-TYPE-AMOUNT                                        
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                    TO CTR-ROWS-3                   
                                           WS-COUNT-3                   
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04755_R3'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF WS-COUNT-1     = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-COUNT-3     = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                      TO S-RETURN-CODE-3          
              PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 00300000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT.                                        *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-RESULT-1                                         
                    MOVE S-RETURN-CODE-1 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-3            
               WHEN  WS-RESULT-3                                        
                    MOVE S-RETURN-CODE-3 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-3            
           END-EVALUATE.                                                
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS-1                               
                      GTT-RETURN-FIELDS-3.                              
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                         
           MOVE WS-RETURN-CODE-1         TO S-RETURN-CODE-1.            
           MOVE WS-RETURN-CODE-3         TO S-RETURN-CODE-3.            
      *                                                                 00339704
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
           PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT.                
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                 00380000
           IF CTR-ROWS-1 < 1                                            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                 
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT
           END-IF.                
      *                                                                 00391000
           
MSQ016        GOBACK.                                                    
      *                                                                 00391000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      **********************End Of Program *****************************        
      *                                                                *        
