       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04754.                                          
COB303 DATE-WRITTEN.      MARCH 25, 2014.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM BUILDS AND INSERTS A SERVICE ORDER.              *        
      *  STATUS CODES:                                                 *        
      *       200     NO WORK TYPE                                     *        
      *       300     NO ORDER TYPE                                    *        
      *  WORKING STORAGE TABLES:                                       *        
      *     **T1      DATA FROM CSR02210                               *        
      *     **T2      PARM APPLIANCE DATA                              *        
      *     **T4      PARM UTILITY DATA                              *          
      *    ***T5      APPLIANCE DATA FROM CSS_APPLIANCE                *        
      *    ***T6      DATA FROM CSR02046                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/25/14  PK44514    NEW PROGRAM.                             *        
P0795A*  10/15/14  PK44514    ADDING APPLIANCES AND RATES.             *        
A05020*  12/10/14  VV90387    MOVE BUSINESS UNIT TO 3374               *        
P0795B*  03/18/15  PK44514    DEFECT 6991-INCREASE TABLE SIZE OF T1 TO *        
P0795B*                       80, HOLDS RSLT SET OF CSR02210           *        
P0795C*  06/08/15  DB18339    DEFECT 7075-ADDING ORDER KEY AS PARM.    *        
P0795D*  06/22/15  PK44514    AOO MAINTENANCE- ADD SO# AND DO NOT      *        
P0795D*                       OPTIMIZE AS PARM.                        *        
DT9687*  12/10/15  PK44514    SEND ALL UPDATES TO CLICK FOR MAINTAIN   *        
DT9687*                       PROCESS.                                 *        
D10330*  02/18/15  PK44514    UPDATE DO NOT OPTIMIZE INFO ON THE ORDER *        
D10563*  04/15/16  PK44514    ADDING INPUT PARM FOR CLICK ORDER CODE   *        
D10675*  04/16/16  PK44514    REQUIREMENTS FOR MAINTAIN ON DATE CHANGE *        
D10675*                       REPRINT IF ORDER TYPE IS CHANGED         *        
DAAAAA*  04/22/16  PK44514    UPDATE THE INPUT SOURCE SYSTEM IN TABLE  *        
PRDFIX*  07/14/16  PK44514    REMOVE DUPLICATE CURSOR NAMES            *        
PRDFIX*  07/18/16  PK44514    TO SEND ORDERS WITH COMPLIANCE DAYS MORE *        
PRDFIX*                       0 TO CLICK.                              *        
ACT233*  07/27/16  TP7R341    REPLACE CSR00028 WITH CSR04675           *00290000
ACT233*   A05460                                                       *00290000
PDFIX1*  08/30/16  PK44514    FIX DUPLICATE CURSOR- 2ND TRY            *        
D12609*  12/13/16  PK44514    FIX FOR USER ID IN CLICK CALL AND ADDING *        
D12609*                       CHANGE LOG                               *        
PRDFX1*  01/13/17  PK44514    TO INCREASE T1 TABLE SIZE TO 120         *        
PRDFX2*  01/31/17  PK44514    NOT MOVE CP ROWS TO T1 TABLE             *        
A05317*  02/21/17  PK44514    REPLACE CALL TO CSR02211 WITH CSR04642   *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04754'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START     PIC X(40)  VALUE                                
           'WORKING STORAGE FOR CSR04754 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *  CSS_SO_DATA VO                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *  CSS_PREMISE  PR                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *  CSS_APPLIANCE LA                                                       
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
      * CSS_MKT_APPLIANCE JA                                                    
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
      * CSS_APPLIANCE_COND A7                                                   
           EXEC SQL                                                             
              INCLUDE TBAPLCON                                                  
           END-EXEC.                                                            
      * CSS_USER_PROFILE PF                                                     
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      * CSS_SO_REQUIREMENT EG                                                   
           EXEC SQL                                                             
              INCLUDE TBSOREQ                                                   
           END-EXEC.                                                            
      * CSS_SO_REMARKS TBSOREM                                                  
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
      * CSS_ZIP_CODE A4                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      * CSS_ACCOUNT AT                                                          
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      * CSS_SO_UPDATE VW                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
      * CSS_ORDER_TYPE C2                                                       
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
      * CSS_WORK_TYPE L4                                                        
D12609     EXEC SQL                                                             
D12609        INCLUDE TBWKTYP                                                   
D12609     END-EXEC.                                                            
      * CSS_ORDER_PRIORITY OY                                                   
           EXEC SQL                                                             
              INCLUDE TBORDPRI                                                  
           END-EXEC.                                                            
      * CSS_CUSTOMER CU                                                         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *  CSS_MNT_TRANS_HIST  MH                                                 
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      * CSS_MT_TRN_HST_DET MI                                                   
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSRVCHG                                                  
           END-EXEC.                                                            
      * CSS_LOCAL OFFICE                                                        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *CSS_ADDR_FORMATTED DY                                                    
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
DT9687     EXEC SQL                                                             
DT9687         INCLUDE TBCADPQU                                                 
DT9687     END-EXEC.                                                            
DT9687* CSS_SO_PRINT_LOC  C4                                                    
DT9687     EXEC SQL                                                             
DT9687        INCLUDE TBSOLOC                                                   
DT9687     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKAR                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPRMRL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRLSED                                                   
           END-EXEC.                                                            
PRDFIX*  *** CSS_ORDER_WK_TYPE L3                                               
PRDFIX     EXEC SQL                                                             
PRDFIX         INCLUDE TBORWT                                                   
PRDFIX     END-EXEC.                                                            
D12609*  *** CSS_SO_ORDER_INST VI                                               
D12609     EXEC SQL                                                             
D12609         INCLUDE TBSOODR                                                  
D12609     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04754_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SERV-ORDER-NO        PIC X(13) VALUE SPACES.           
           05  S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.           
                                                                        
       01 WS-WORK-DATE.                                                 
           05 WS-WORK-YYYY               PIC X(4).                      
           05 FILLER                     PIC X    VALUE '-'.            
           05 WS-WORK-MM                 PIC XX.                        
           05 FILLER                     PIC X    VALUE '-'.            
           05 WS-WORK-DD                 PIC XX.                        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      REDEFINES WS-CUSTOMER-NO-NUM    
                                        PIC X(10).                      
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-ACCOUNT-XFER-CHAR     PIC X(13).                      
           05  WS-ACCOUNT-XFER-NUM      REDEFINES WS-ACCOUNT-XFER-CHAR  
                                        PIC 9(13).                      
           05  WS-SERV-ORDER-NO-CHAR    PIC X(13).                      
           05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO-CHAR 
                                        PIC 9(13).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-DATE-USA      PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04754'.     
           05  WS-II-CTR                PIC S9(4) COMP VALUE 0.         
           05  WS-II-MCTR               PIC S9(4) COMP VALUE 0.         
           05  WS-LIGHTING-CONTRACT-FL  PIC X(01) VALUE SPACES.         
           05  WS-BUILDER-LIGHTING-FL   PIC X(01) VALUE SPACES.         
           05  WS-ACTIVE-CONTRACT-FL    PIC X(01) VALUE SPACES.         
           05  WS-LAST-READ-DATE        PIC X(10) VALUE SPACES.         
           05  WS-DATE-LAST-YEAR        PIC X(10) VALUE SPACES.         
           05  WS-MORE-ROWS             PIC X(01) VALUE SPACES.         
           05  WS-T3-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-T5-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-NO-OF-DAYS-LITE       PIC S9(4) COMP VALUE 0.         
           05  WS-NO-OF-DAYS-DEP        PIC S9(4) COMP VALUE 0.         
           05  WS-DEPOSIT-AMT-NUM       PIC 9(7)V99.                    
           05  WS-DEPOSIT-AMT-CHAR      REDEFINES WS-DEPOSIT-AMT-NUM    
                                        PIC X(9).                       
           05  WS-DEPOSIT-AMT           PIC 9(9) VALUE 0.               
           05  WS-DEPOSIT-AMT-DEC       PIC 9(7)V99 VALUE 0.            
           05  WS-PRIORITY              PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-IND-1            PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-IND-2            PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-IND-3            PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-IND-4            PIC S9(4) COMP VALUE 0.         
D12609     05  WS-NULL-APPT-DT          PIC S9(04) COMP VALUE ZERO.     
D12609     05  WS-NULL-ACCESS-DT        PIC S9(04) COMP VALUE ZERO.     
D12609     05  WS-NULL-ACCT-DESC        PIC S9(04) COMP VALUE ZERO.     
           05  WS-UTIL-ENV-EXISTS       PIC X(01) VALUE SPACES.         
           05  WS-ORDER-INST-EXISTS     PIC X(01) VALUE SPACES.         
           05  WS-EQUIPMENT-EXISTS      PIC X(01) VALUE SPACES.         
           05  WS-INCLUDE-INST          PIC X(01) VALUE SPACES.         
           05  WS-LINK-SCHEDULED-DT     PIC X(10) VALUE SPACES.         
           05  WS-PLAN-START-DATE       PIC X(10) VALUE SPACES.         
           05  WS-NEW-ACCOUNT-NO        PIC X(13) VALUE SPACES.         
           05  WS-NEW-CUSTOMER-NO-NUM   PIC 9(13) VALUE ZEROES.         
P0795A     05  WS-LFTM-HI-PEAK-DMD-N    PIC 9(7)V99.                    
P0795A     05  WS-LFTM-HI-PEAK-DMD-C  REDEFINES WS-LFTM-HI-PEAK-DMD-N   
P0795A                                    PIC X(9).                     
P0795A     05  WS-GAS-BASE-USE-N        PIC 9(9).                       
P0795A     05  WS-GAS-BASE-USE-C      REDEFINES WS-GAS-BASE-USE-N       
P0795A                                    PIC X(09).                    
           05  WS-UTILITY-PARM.                                         
               10 WS-UTILITY-PARM-LEN    PIC S9(4) COMP.                
               10 WS-UTILITY-PARM-TEXT   PIC X(550).                    
           05  WS-SPCL-READ-INST.                                       
               10 WS-SPCL-READ-INST-LEN  PIC S9(4) COMP.                
               10 WS-SPCL-READ-INST-TEXT PIC X(255).                    
           05  WS-SPCL-INST.                                            
               10 WS-SPCL-INST-LEN       PIC S9(4) COMP.                
               10 WS-SPCL-INST-TEXT      PIC X(255).                    
           05  WS-PREM-DIRECTIONS.                                      
               10 WS-PREM-DIRECTIONS-LEN  PIC S9(4) COMP.               
               10 WS-PREM-DIRECTIONS-TEXT PIC X(255).                   
           05  WS-SCRATCHPAD.                                           
               10 WS-SCRATCHPAD-LEN      PIC S9(4) COMP.                
               10 WS-SCRATCHPAD-TEXT     PIC X(255).                    
           05  WS-APPLIANCE-PARM.                                       
               10 WS-APPLIANCE-PARM-LEN  PIC S9(4) COMP.                
               10 WS-APPLIANCE-PARM-TEXT PIC X(2500).                   
           05  WS-MISMATCH-COMMENTS     PIC X(47) VALUE SPACES.         
           05  WS-SEASONAL-APP-FL       PIC X(01) VALUE SPACES.         
           05  WS-COMBO-DIST-LO-FL      PIC X(01) VALUE SPACES.         
           05  WS-GAS-WORK-AREA-FL      PIC X(01) VALUE SPACES.         
           05  WS-APPLIANCE-FL          PIC X(01) VALUE SPACES.         
           05  WS-UNBLOCK-GAS-FL        PIC X(01) VALUE SPACES.         
           05  WS-UNBLOCK-FL            PIC X(01) VALUE SPACES.         
           05  WS-NOTIFY-CSR-FL         PIC X(01) VALUE SPACES.         
           05  WS-APPL-INSERT-FL        PIC X(01) VALUE SPACES.         
           05  WS-APPL-UPDATE-FL        PIC X(01) VALUE SPACES.         
           05  WS-APPL-MATCH-FL         PIC X(01) VALUE SPACES.         
           05  WS-APPL-OLD-LOC-CD       PIC X(03) VALUE SPACES.         
           05  WS-SUB1                  PIC 9(02) VALUE 0.              
           05  WS-PREMISE-NO            PIC S9(10) USAGE COMP-3 VALUE 0.
           05  WS-TOTAL-DUE             PIC S9(9)V99 COMP-3 VALUE +0.   
           05  WS-TRAN-APPL-NO          PIC S9(4) COMP VALUE 1.         
           05  WS-HOLD-WAIVER-FL        PIC X(01) VALUE SPACES.         
           05  WS-COUNT-CC              PIC S9(4) COMP VALUE 0.         
           05  WS-COUNT-OFF             PIC S9(4) COMP VALUE 0.         
           05  WS-TEMP-DATE             PIC X(08) VALUE SPACES.         
           05  WS-ASSIGNED-DATETIME-1   PIC X(10) VALUE SPACES.         
           05  WS-ASSIGNED-DATETIME-2   PIC X(10) VALUE SPACES.         
           05  WS-ASSIGNED-DATETIME-3   PIC X(10) VALUE SPACES.         
           05  WS-MAX-SCHEDULED-DT      PIC X(10) VALUE SPACES.         
           05  WS-MIN-SCHEDULED-DT      PIC X(10) VALUE SPACES.         
DT9687     05  WS-IS-CLICK-PRIOR        PIC X(01) VALUE SPACES.         
DT9687     05  WS-IS-CLICK-CURR         PIC X(01) VALUE SPACES.         
DT9687     05  WS-IS-CAD                PIC X(01) VALUE SPACES.         
DT9687     05  WS-IS-CAD-PRIOR          PIC X(01) VALUE SPACES.         
DT9687     05  WS-IS-CAD-CURR           PIC X(01) VALUE SPACES.         
DT9687     05  WS-RETURN-CODE-4747      PIC S9(09) COMP VALUE +0.       
DT9687     05  WS-WORK-DISTRICT-4747    PIC X(40).                      
DT9687     05  WS-WORK-DISTRICT         PIC X(40) VALUE SPACES.         
DT9687     05  WS-NEW-ORDER-FL          PIC X(01) VALUE SPACES.         
D10675     05  WS-ORIG-ORDER-TYPE-CD    PIC X(05) VALUE SPACES.         
D10675     05  WS-ORDER-TYPE-CHGD       PIC X(01) VALUE 'N'.            
           05  WS-POINT-ID              PIC X(10) VALUE SPACES.         
           05  WS-READ-ROUTE-2211       PIC 9(04) VALUE ZEROES.         
           05  WS-READ-ROUTE-CHAR-2211  REDEFINES WS-READ-ROUTE-2211    
                                        PIC X(04).                      
           05  WS-READ-ROUTE            PIC 9(04) VALUE ZEROES.         
           05  WS-READ-ROUTE-CHAR       REDEFINES WS-READ-ROUTE         
                                        PIC X(04).                      
                                                                        
           05  WS-CHANGE-LOG-VALUE     PIC X(20) VALUE SPACES.          
           05  WS-COUNT-O              PIC S9(4) COMP VALUE 0.          
           05  WS-LENGTH               PIC S9(4) COMP VALUE 0.          
           05  WS-CHANGE-LOG-REMARKS.                                   
               49 CHANGE-LOG-LEN          PIC S9(4) USAGE COMP VALUE 0. 
               49 CHANGE-LOG-REMARKS      PIC X(210) VALUE SPACES.      
           05  WS-CHANGE-LOG-INDEX-NAME.                                
               10 WS-I-PHONE-NO          PIC S9(4) COMP VALUE  1.       
               10 WS-I-PHONE-NO-EXT      PIC S9(4) COMP VALUE  2.       
               10 WS-I-ALT-PHONE-NO      PIC S9(4) COMP VALUE  3.       
               10 WS-I-ALT-PHONE-NO-EXT  PIC S9(4) COMP VALUE  4.       
               10 WS-I-MTR-ACCESS-CD     PIC S9(4) COMP VALUE  5.       
               10 WS-I-MTR-ACCESS-RSN    PIC S9(4) COMP VALUE  6.       
               10 WS-I-GAS-WORK-TYPE     PIC S9(4) COMP VALUE  7.       
               10 WS-I-ELEC-WORK-TYPE    PIC S9(4) COMP VALUE  8.       
               10 WS-I-ORDER-TYPE-CD     PIC S9(4) COMP VALUE  9.       
               10 WS-I-ORDER-RSN-CD      PIC S9(4) COMP VALUE 10.       
               10 WS-I-ORDER-STATE-CD    PIC S9(4) COMP VALUE 11.       
               10 WS-I-PLACED-BY         PIC S9(4) COMP VALUE 12.       
               10 WS-I-WANTED-DT         PIC S9(4) COMP VALUE 13.       
               10 WS-I-ASSIGNED-DT       PIC S9(4) COMP VALUE 14.       
               10 WS-I-CALL-BEFORE       PIC S9(4) COMP VALUE 15.       
               10 WS-I-WORK-AREA-ID      PIC S9(4) COMP VALUE 16.       
               10 WS-I-BREAKERS-IND      PIC S9(4) COMP VALUE 17.       
               10 WS-I-ORDER-PRTY-CD     PIC S9(4) COMP VALUE 18.       
               10 WS-I-MTR-ACCESS-DT     PIC S9(4) COMP VALUE 19.       
               10 WS-I-HOME-ALL-DAY      PIC S9(4) COMP VALUE 20.       
               10 WS-I-OPTIMIZE-FL       PIC S9(4) COMP VALUE 21.       
               10 WS-I-WORK-TYPE         PIC S9(4) COMP VALUE 22.       
           05 WS-CHANGE-LOG-TABLE.                                      
              10 WS-CHANGE-LOG-DATA.                                    
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG PHONE NO:'.                                   
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG PHONE NO EXT:'.                               
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG ALT PHONE NO:'.                               
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG ALT PHONE EXT:'.                              
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG MTR ACCESS CD:'.                              
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG MTR ACCESS RSN:'.                             
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG GAS WKTYPE:'.                                 
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG ELEC WKTYPE:'.                                
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG ORDER TYPE:'.                                 
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG ORDER RSN:'.                                  
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG ORDER STATE:'.                                
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG PLACED BY:'.                                  
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG WANTED DT:'.                                  
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG SCHEDULED DT:'.                               
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG CALL BEFORE:'.                                
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG WORK AREA:'.                                  
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG BREAKERS IND:'.                               
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG PRIORITY CD:'.                                
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG MTR ACCESS DT:'.                              
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG HOME ALL DAY:'.                               
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG OPTIMIZE FL:'.                                
                 15 FILLER            PIC X(20) VALUE                   
                    'ORIG WORKTYPE:'.                                   
              10 WS-CHANGE-LOG-DATA-R REDEFINES WS-CHANGE-LOG-DATA.     
                 15 WS-CHANGE-LOG-ROW OCCURS 22                         
                                      INDEXED BY WS-CHANGE-LOG-INDEX.   
                    20 WS-CHANGE-LOG-TEXT  PIC X(20).                   
                                                                        
           05 WS-ORDER-STATE-TABLE.                                     
              10 WS-ORDER-STATE-DATA.                                   
                 15 FILLER    PIC X(22) VALUE 'A ACTIVE              '. 
                 15 FILLER    PIC X(22) VALUE 'B TURNED DOWN COMPANY '. 
                 15 FILLER    PIC X(22) VALUE 'C CANCELLED           '. 
                 15 FILLER    PIC X(22) VALUE 'D TURNED DOWN CUSTOMER'. 
                 15 FILLER    PIC X(22) VALUE 'H HOLD                '. 
                 15 FILLER    PIC X(22) VALUE 'R PAYMENT REQUIRED    '. 
                 15 FILLER    PIC X(22) VALUE 'Z POSTED              '. 
                                                                        
              10 WS-ORDER-STATE-DATA-R REDEFINES WS-ORDER-STATE-DATA.   
                 15 WS-ORDER-STATE-ROW OCCURS 7                         
                                      INDEXED BY WS-ORDER-STATE-INDEX.  
                    20 WS-ORDER-STATE-CODE PIC X(02).                   
                    20 WS-ORDER-STATE-DESC PIC X(20).                   
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
       01  WS-TABLES.                                                   
P0795B     05  T1-CSR02210            OCCURS 120                        
                                      INDEXED BY T1-INDEX.              
               10 T1-TABLE-ID           PIC X(02) VALUE SPACES.         
               10 T1-UT-CODE-UTIL-TYPE  PIC X(01) VALUE SPACES.         
               10 T1-UT-IC-NO           PIC S9(4) COMP VALUE 0.         
               10 T1-UT-READ-ROUTE      PIC S9(4) COMP VALUE 0.         
               10 T1-UT-RATE-PLAN-NO    PIC X(03).                      
               10 T1-UT-RATE-DESC       PIC X(25).                      
               10 T1-UT-CODE-REV-CLASS  PIC X(03).                      
               10 T1-UT-READ-CYCLE      PIC X(02).                      
               10 T1-UT-CODE-SIC-NO     PIC X(04).                      
               10 T1-MN-METER-NO        PIC X(09).                      
               10 T1-MN-MTR-REF-NO      PIC S9(4) COMP VALUE 0.         
               10 T1-MN-CODE-TIME-PER   PIC S9(4) COMP VALUE 0.         
               10 T1-MN-LAST-READ-VAL   PIC S9(12)V9(3) COMP-3 VALUE 0. 
               10 T1-MN-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-USAGE-T    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-USAGE-I    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-USAGE-S    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-METER-S    PIC X(01) VALUE SPACES.         
               10 T1-MN-METER-SUPPLY    PIC X(15) VALUE SPACES.         
               10 T1-MN-CODE-METER-LOC  PIC X(02) VALUE SPACES.         
               10 T1-MN-METER-LOC-DESC  PIC X(14) VALUE SPACES.         
               10 T1-MN-METER-IND       PIC X(01) VALUE SPACES.         
               10 T1-MN-CONSTANT        PIC S9(6)V COMP-3 VALUE 0.      
               10 T1-MN-NO-DIALS        PIC S9(4) COMP VALUE 0.         
               10 T1-MN-DIST-NODE-PO    PIC X(20) VALUE SPACES.         
               10 T1-MN-POINT-ID        PIC X(10) VALUE SPACES.         
               10 T1-MN-SEAL-CODE-ID    PIC X(01) VALUE SPACES.         
               10 T1-MN-HEX-LOCATION    PIC X(02) VALUE SPACES.         
               10 T1-MN-INSULATED-IND   PIC X(01) VALUE SPACES.         
               10 T1-MN-LOCK-TYPE-ID    PIC X(01) VALUE SPACES.         
               10 T1-MN-DELIVERY-LEV    PIC X(01) VALUE SPACES.         
               10 T1-MN-UTILITY-SOURCE  PIC X(01) VALUE SPACES.         
               10 T1-MN-IDR-RECIPIENT   PIC X(01) VALUE SPACES.         
               10 T1-MN-PROGRAM-ID      PIC X(02) VALUE SPACES.         
               10 T1-MN-MTR-READ-SOURCE PIC X(01) VALUE SPACES.         
               10 T1-RG-LAST-READD      PIC X(10) VALUE SPACES.         
               10 T1-RG-REG-ID-NO       PIC S9(4) COMP VALUE 0.         
               10 T1-CP-NO-UNITS        PIC S9(9) COMP VALUE 0.         
               10 T1-CP-CODE-PLAN       PIC X(01) VALUE SPACES.         
               10 T1-CP-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T1-CP-CD-SVC-TYPE     PIC X(01) VALUE SPACES.         
               10 T1-CP-MTHLY-AMT       PIC S9(9)V COMP-3 VALUE 0.      
               10 T1-CP-RT-ITEM-CD      PIC S9(4) COMP VALUE 0.         
               10 T1-CP-LIGHT-NO        PIC S9(4) COMP VALUE 0.         
               10 T1-CP-POLE-NO         PIC X(07) VALUE SPACES.         
               10 T1-CP-DIST-NO         PIC X(03) VALUE SPACES.         
               10 T1-CP-USAGE-FIXED     PIC S9(9)V COMP-3 VALUE 0.      
               10 T1-CP-ITEM-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T1-CP-EQUIP-ID        PIC X(02) VALUE SPACES.         
               10 T1-PREM-DIR-IND       PIC X(01) VALUE SPACES.         
               10 T1-SUBDIV-LIGHT       PIC S9(3)V COMP-3 VALUE 0.      
               10 T1-ACCT-TYPE-CODE     PIC X(01) VALUE SPACES.         
               10 T1-CD-RENTAL-PROP     PIC X(01) VALUE SPACES.         
               10 T1-LL-CUSTOMER-NO     PIC S9(10)V COMP-3 VALUE 0.     
               10 T1-REV-DISTRICT-CD    PIC X(03) VALUE SPACES.         
               10 T1-DISC-BAL           PIC S9(11)V99 COMP-3 VALUE 0.   
               10 T1-OUT-ACCOUNT-NO     PIC S9(13)V COMP-3 VALUE 0.     
               10 T1-ACCT-STATUS        PIC X(01) VALUE SPACES.         
               10 T1-ROW-NO             PIC S9(4) COMP VALUE 0.         
               10 T1-DEPOSIT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T1-SEC-TOT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T1-CUR-MTH-ARR-CD     PIC X(01) VALUE SPACES.         
               10 T1-CREDIT-GROUP       PIC X(01) VALUE SPACES.         
               10 T1-CURRENT-ACCOUNT    PIC X(01) VALUE SPACES.         
               10 T1-DATE-BANKRUPT      PIC X(10) VALUE SPACES.         
               10 T1-FILED-CASE-NO      PIC X(10) VALUE SPACES.         
               10 T1-DL-NO              PIC X(19) VALUE SPACES.         
               10 T1-DL-STATE           PIC X(02) VALUE SPACES.         
               10 T1-SSN                PIC X(09) VALUE SPACES.         
               10 T1-PRIOR-ACCT-STAT    PIC X(01) VALUE SPACES.         
               10 T1-READ-CYCLE         PIC X(02) VALUE SPACES.         
               10 T1-SERV-STRT-DT       PIC X(10) VALUE SPACES.         
               10 T1-DEP-INTST-RT       PIC S9(2)V99 COMP-3 VALUE 0.    
               10 T1-CP-DT-PLAN-ST      PIC X(10) VALUE SPACES.         
               10 T1-ACTIVE-CONTRACT    PIC X(01) VALUE SPACES.         
               10 T1-SECURED-RATE-FL    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-MTR-RD     PIC X(02) VALUE SPACES.         
               10 T1-MN-MTR-PRESS       PIC X(03) VALUE SPACES.         
               10 T1-WORK-TYPE-CD       PIC X(03) VALUE SPACES.         
               10 T1-RLSE-REQUIRED      PIC X(01) VALUE SPACES.         
               10 T1-RLSE-NO            PIC X(10) VALUE SPACES.         
               10 T1-RLSE-DATE          PIC X(10) VALUE SPACES.         
               10 T1-PM-RATE-PLAN       PIC X(03).                      
               10 T1-PM-REV-CLASS       PIC X(03).                      
                                                                        
           05  T2-APPLIANCE-LINE        PIC X(2500).                    
           05  T2-APPLIANCE-TABLE REDEFINES T2-APPLIANCE-LINE.          
               10  T2-PARM-APPLIANCE      OCCURS 100                    
                                          INDEXED BY T2-INDEX.          
                   15 T2-EQUIPMENT-NO       PIC X(20).                  
                   15 T2-APPLIANCE-CD       PIC X(02).                  
                   15 T2-LOCATION-CD        PIC X(03).                  
                                                                        
           05  T4-UTILITY-LINE      PIC X(550).                         
           05  T4-UTILITY-TABLE REDEFINES T4-UTILITY-LINE.              
               10  T4-PARM-UTILITY        OCCURS 50                     
                                          INDEXED BY T4-INDEX.          
                   15 T4-CODE-UTIL-TYPE   PIC X(01).                    
                   15 T4-IC-NO            PIC 9(4).                     
                   15 T4-RATE-PLAN-NO     PIC X(03).                    
                   15 T4-REVENUE-CLASS    PIC X(03).                    
                                                                        
           05  T5-APPLIANCES          OCCURS 100                        
                                      INDEXED BY T5-INDEX.              
               10 T5-APPLIANCE-CD       PIC X(02) VALUE SPACES.         
               10 T5-EQUIP-OWNER        PIC X(12) VALUE SPACES.         
               10 T5-PRIMARY-FUEL-CD    PIC X(06) VALUE SPACES.         
               10 T5-EQUIPMENT-NO       PIC X(20) VALUE SPACES.         
               10 T5-INSTALL-DT         PIC X(10) VALUE SPACES.         
               10 T5-REPLACE-APP-FL     PIC X(01) VALUE SPACES.         
               10 T5-CAUTION-TAG-IND    PIC X(01) VALUE SPACES.         
               10 T5-CONDITION-DESC     PIC X(50) VALUE SPACES.         
               10 T5-CUT-IND            PIC X(01) VALUE SPACES.         
               10 T5-APPLIANCE-DESC     PIC X(20) VALUE SPACES.         
               10 T5-CRAWL-FL           PIC X(01) VALUE SPACES.         
               10 T5-LOCATION-CD        PIC X(03) VALUE SPACES.         
               10 T5-PM-LIGHT-IND       PIC X(01) VALUE SPACES.         
               10 T5-PM-REPAIR-IND      PIC X(01) VALUE SPACES.         
                                                                        
P0795A     05  T6-CSR02046-DATA       OCCURS 100                        
P0795A                                INDEXED BY T6-INDEX.              
P0795A         10 T6-RETURN-CODE          PIC S9(9) COMP VALUE 0.       
P0795A         10 T6-RATE-PLAN-NO         PIC X(03)      VALUE SPACES.  
P0795A         10 T6-CODE-REVENUE-CLASS   PIC X(03)      VALUE SPACES.  
P0795A         10 T6-CODE-SIC-NO          PIC X(04)      VALUE SPACES.  
P0795A         10 T6-CODE-ESTIMATE-OK     PIC X(01)      VALUE SPACES.  
P0795A         10 T6-SEASONAL-USE-CODE    PIC X(02)      VALUE SPACES.  
P0795A         10 T6-CODE-MTR-READ-FREQ   PIC X(03)      VALUE SPACES.  
P0795A         10 T6-CODE-SERVICE-TYPE    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-READ-CYCLE           PIC X(02)      VALUE SPACES.  
P0795A         10 T6-READ-ROUTE           PIC S9(4) COMP VALUE 0.       
P0795A         10 T6-SPLY-SENSITIVE-IND   PIC X(01)      VALUE SPACES.  
P0795A         10 T6-ACTIVE-METERS-NO     PIC S9(9) COMP VALUE 0.       
P0795A         10 T6-GAS-BASE-LAST-UPDT   PIC X(08)      VALUE SPACES.  
P0795A         10 T6-DATE-LFTM-HI-DMD     PIC X(08)      VALUE SPACES.  
P0795A         10 T6-STATE-TAX-EXMPT-NO   PIC X(13)      VALUE SPACES.  
P0795A         10 T6-CODE-STAT-TAX-XMT    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-CODE-CITY-TAX-XMT    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-ACTIVE-PLANS-IND     PIC X(01)      VALUE SPACES.  
P0795A         10 T6-MULTIPLE-ICPS-IND    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-MULTI-GAS-ELE-IND    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-GAS-BASE-USE         PIC S9(9)V COMP-3 VALUE 0.    
P0795A         10 T6-LFTM-HI-PEAK-DMD     PIC S9(7)V99 COMP-3 VALUE 0.  
P0795A         10 T6-LFTM-HI-DMD-UNITS    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-ENERGY-PERIODS       PIC X(01)      VALUE SPACES.  
P0795A         10 T6-DEMAND-PERIODS       PIC X(01)      VALUE SPACES.  
P0795A         10 T6-CODE-UTIL-TYPE       PIC X(01)      VALUE SPACES.  
P0795A         10 T6-IC-NO                PIC S9(4) COMP VALUE 0.       
P0795A         10 T6-READ-METERS-IND      PIC X(01)      VALUE SPACES.  
P0795A         10 T6-FIXED-FACTORS-IND    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-BILL-CONTRACT-IND    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-INTERRUPT-ACCT-IND   PIC X(01)      VALUE SPACES.  
P0795A         10 T6-EPP-ACCOUNT-IND      PIC X(01)      VALUE SPACES.  
P0795A         10 T6-SERV-ORD-PEND-IND    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-LOCAL-OFFICE         PIC X(03)      VALUE SPACES.  
P0795A         10 T6-COMPANY-NO           PIC X(02)      VALUE SPACES.  
P0795A         10 T6-REV-DISTRICT-CD      PIC X(03)      VALUE SPACES.  
P0795A         10 T6-ENABLE-PEAK-IND      PIC X(01)      VALUE SPACES.  
P0795A         10 T6-PERSONAL-CNTCT-CD    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-BILL-CYCLE           PIC X(02)      VALUE SPACES.  
P0795A         10 T6-ZERO-USE-INVEST-DT   PIC X(08)      VALUE SPACES.  
P0795A         10 T6-ACCT-ON-BANK-DRAFT   PIC X(01)      VALUE SPACES.  
P0795A         10 T6-DUMMY1               PIC X(01)      VALUE SPACES.  
P0795A         10 T6-PRTY-SVC-CAT-CD      PIC X(02)      VALUE SPACES.  
P0795A         10 T6-ALT-FUEL-CD          PIC X(01)      VALUE SPACES.  
P0795A         10 T6-INDUS-GAS-CUST       PIC X(01)      VALUE SPACES.  
P0795A         10 T6-BASE-USE-IND         PIC X(01)      VALUE SPACES.  
P0795A         10 T6-SUBDVSN-LIGHT-IND    PIC X(01)      VALUE SPACES.  
P0795A         10 T6-NAICS-CD             PIC X(06)      VALUE SPACES.  
P0795A         10 T6-ACCT-TYPE            PIC X(01)      VALUE SPACES.  
P0795A         10 T6-ACCT-SUB-TYPE        PIC X(01)      VALUE SPACES.  
P0795A         10 T6-RATE-PKG-OPTION      PIC X(255)     VALUE SPACES.  
P0795A         10 T6-COD-MTR-RD-FRQ-IND   PIC X(01)      VALUE SPACES.  
P0795A         10 T6-COD-MTR-RD-FRQ-MON   PIC X(01)      VALUE SPACES.  
P0795A         10 T6-DATE-LFT-HI-DMD-PB   PIC X(10)      VALUE SPACES.  
P0795A         10 T6-ZERO-USE-INS-DT-PB   PIC X(10)      VALUE SPACES.  
P0795A         10 T6-RT-PKG-EXPIRE-FLAG   PIC X(01)      VALUE SPACES.  
P0795A         10 T6-AGL-SENIOR-FLAG      PIC X(01)      VALUE SPACES.  
P0795A         10 T6-OPTION-CD            PIC X(12)      VALUE SPACES.  
P0795A         10 T6-GROUP-CD             PIC X(09)      VALUE SPACES.  
P0795A         10 T6-PEND-OPTION-FL       PIC X(01)      VALUE SPACES.  
P0795A         10 T6-CURR-OPT-DESC-INT    PIC X(50)      VALUE SPACES.  
P0795A         10 T6-PEND-OPT-DESC-INT    PIC X(50)      VALUE SPACES.  
P0795A         10 T6-LAST-DRAFT-DATE      PIC X(10)      VALUE SPACES.  
P0795A         10 T6-DRAFT-CYCLE          PIC X(02)      VALUE SPACES.  
P0795A         10 T6-DRAFT-DATE           PIC X(10)      VALUE SPACES.  
P0795A         10 T6-ADJUSTABLE-OPTION-FLAG PIC X(1)     VALUE SPACES.  
                                                                        
       01  CSR02210-CALL-DATA.                                          
           03 ACCOUNT-NO-2210           PIC X(13) VALUE SPACES.         
           03 PREMISE-NO-2210           PIC X(10) VALUE SPACES.         
           03 COMPANY-NO-2210           PIC X(02) VALUE SPACES.         
           03 MKTG-ORDER-2210           PIC X(01) VALUE SPACES.         
           03 RETURN-UTILS-2210         PIC X(01) VALUE SPACES.         
           03 RETURN-DISC-BAL-2210      PIC X(01) VALUE SPACES.         
           03 ORDER-REASON-2210         PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR02210-RETURN-DATA.                                        
           05  RETURN-CODE-2210      PIC S9(9)     COMP VALUE 0.        
           05  ACTIVE-PARA-2210      PIC X(30)     VALUE SPACES.        
           05  TABLE-NAME-2210       PIC X(30)     VALUE SPACES.        
           05  TABLE-ID-2210         PIC X(2)      VALUE SPACES.        
           05  UT-CODE-UTIL-TY-2210  PIC X(1)      VALUE SPACES.        
           05  UT-IC-NO-2210         PIC S9(4)     COMP VALUE 0.        
           05  UT-READ-ROUTE-2210    PIC S9(4)     COMP VALUE 0.        
           05  UT-RATE-PLAN-NO-2210  PIC X(3)      VALUE SPACES.        
           05  UT-RATE-DESC-2210     PIC X(25)     VALUE SPACES.        
           05  UT-CODE-REV-CLA-2210  PIC X(3)      VALUE SPACES.        
           05  UT-READ-CYCLE-2210    PIC X(2)      VALUE SPACES.        
           05  UT-CODE-SIC-NO-2210   PIC X(4)      VALUE SPACES.        
           05  MN-METER-NO-2210      PIC X(9)      VALUE SPACES.        
           05  MN-MTR-REF-NO-2210    PIC S9(4)     COMP VALUE 0.        
           05  MN-CODE-TIME-PE-2210  PIC S9(4)     COMP VALUE 0.        
           05  MN-LAST-READ-VA-2210  PIC S9(12)V999 COMP-3 VALUE 0.     
           05  MN-CD-STUS-RS-2210    PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-T-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-I-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-METER-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-METER-SUPPLY-2210  PIC X(15)     VALUE SPACES.        
           05  MN-CODE-METER-L-2210  PIC X(2)      VALUE SPACES.        
           05  MN-METER-LOC-DE-2210  PIC X(14)     VALUE SPACES.        
           05  MN-METER-IND-2210     PIC X(1)      VALUE SPACES.        
           05  MN-CONSTANT-2210      PIC S9(6)V    COMP-3 VALUE 0.      
           05  MN-NO-DIALS-2210      PIC S9(4) COMP VALUE 0.            
           05  MN-DIST-NODE-PO-2210  PIC X(20)     VALUE SPACES.        
           05  MN-POINT-ID-2210      PIC X(10)     VALUE SPACES.        
           05  MN-SEAL-CODE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-HEX-LOCATION-2210  PIC X(02)     VALUE SPACES.        
           05  MN-INSULATED-IN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-LOCK-TYPE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-DELIVERY-LEV-2210  PIC X(01)     VALUE SPACES.        
           05  MN-UTILITY-SOUR-2210  PIC X(01)     VALUE SPACES.        
           05  MN-IDR-RECIPIEN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-PROGRAM-ID-2210    PIC X(02)     VALUE SPACES.        
           05  MN-MTR-READ-SO-2210   PIC X(01)     VALUE SPACES.        
           05  RG-CODE-REG-ST-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-STATUS-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-TIME-P-2210   PIC S9(4)     COMP VALUE 0.        
           05  RG-CODE-USAGE-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-SRC-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  RG-LAST-READD-2210    PIC X(10)     VALUE SPACES.        
           05  RG-LST-READVL-2210    PIC S9(12)V9(3) COMP-3 VALUE 0.    
           05  RG-REG-ID-NO-2210     PIC S9(4)     COMP VALUE 0.        
           05  CP-NO-UNITS-2210      PIC S9(9)     COMP VALUE 0.        
           05  CP-CODE-PLAN-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-STATRS-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-SVC-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  CP-MTLY-AMT-FX-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-RT-ITEM-CD-2210    PIC S9(4)     COMP VALUE 0.        
           05  CP-LIGHT-NO-2210      PIC S9(4)     COMP VALUE 0.        
           05  CP-POLE-NO-2210       PIC X(7)      VALUE SPACES.        
           05  CP-DIST-NO-2210       PIC X(3)      VALUE SPACES.        
           05  CP-USAGE-FIXED-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-ITEM-SEQ-NO-2210   PIC S9(4)     COMP VALUE 0.        
           05  CP-EQUIP-ID-2210      PIC X(2)      VALUE SPACES.        
           05  PREM-DIR-IND-2210     PIC X(1)      VALUE SPACES.        
           05  SUBDIV-LIGHT-2210 PIC S9(3)V        COMP-3 VALUE 0.      
           05  ACCT-TYPE-2210        PIC X(1)      VALUE SPACES.        
           05  CD-RNTL-PROP-2210     PIC X(1)      VALUE SPACES.        
           05  LL-CUSTOMER-NO-2210   PIC S9(10)    COMP-3 VALUE 0.      
           05  REV-DIST-CD-2210      PIC X(3)      VALUE SPACES.        
           05  DISC-BAL-2210         PIC S9(11)V99 COMP-3 VALUE 0.      
           05  OUT-ACCOUNT-NO-2210   PIC S9(13)V   COMP-3 VALUE 0.      
           05  ACCT-STATUS-2210      PIC X(1)      VALUE SPACES.        
           05  ROW-NO-2210           PIC S9(4)     COMP VALUE 0.        
           05  DEPOSIT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  SEC-TOT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  CUR-MTH-ARR-CD-2210   PIC X(01)     VALUE SPACES.        
           05  CREDIT-GROUP-2210     PIC X(01)     VALUE SPACES.        
           05  CURRENT-ACCOUNT-2210  PIC X(01)     VALUE 'Y'.           
           05  DATE-BNKRPT-FL-2210   PIC X(10)     VALUE SPACES.        
           05  FILED-CASE-NO-2210    PIC X(10)     VALUE SPACES.        
           05  DL-NO-2210            PIC X(19)     VALUE SPACES.        
           05  DL-STATE-2210         PIC X(02)     VALUE SPACES.        
           05  SSN-2210              PIC X(09)     VALUE SPACES.        
           05  PRIOR-ACCT-STAT-2210  PIC X(01)     VALUE SPACES.        
           05  READ-CYCLE-2210       PIC X(02)     VALUE SPACES.        
           05  SERV-STRT-DT-2210     PIC X(10)     VALUE SPACES.        
           05  DEP-INTST-RT-2210     PIC S9(2)V99  COMP-3 VALUE 0.      
           05  CP-DT-PLN-ST-2210     PIC X(10)     VALUE SPACES.        
           05  ACTIVE-CONTRACT-2210  PIC X(01)     VALUE SPACES.        
           05  SECURED-RATE-FL-2210  PIC X(01)     VALUE SPACES.        
           05  MN-CODE-MTR-RD-2210   PIC X(02)     VALUE SPACES.        
           05  MN-MTR-PRESS-2210     PIC X(03)     VALUE SPACES.        
           05  ERROR-MSG-NO-02-2210  PIC X(05)     VALUE SPACES.        
           05  ERROR-MSG-NO-A4-2210  PIC X(05)     VALUE SPACES.        
                                                                        
                                                                        
P0795A 01  CSR02046-CALL-DATA.                                          
P0795A     05  ACTION-MODE-2046         PIC X(01) VALUE SPACES.         
P0795A     05  ACCOUNT-NO-2046          PIC X(13) VALUE SPACES.         
P0795A     05  CODE-UTIL-TYPE-2046      PIC X(01) VALUE SPACES.         
P0795A     05  IC-NO-2046               PIC S9(4) COMP VALUE 0.         
P0795A     05  PREMISE-NO-2046          PIC X(10) VALUE SPACES.         
                                                                        
                                                                        
P0795A 01  CSR02046-RETURN-DATA.                                        
P0795A     05 RETURN-CODE-2046        PIC S9(9) COMP VALUE 0.           
P0795A     05 RATE-PLAN-NO-2046       PIC X(03)      VALUE SPACES.      
P0795A     05 CODE-REVENUE-CLASS-2046 PIC X(03)      VALUE SPACES.      
P0795A     05 CODE-SIC-NO-2046        PIC X(04)      VALUE SPACES.      
P0795A     05 CODE-ESTIMATE-OK-2046   PIC X(01)      VALUE SPACES.      
P0795A     05 SEASONAL-USE-CODE-2046  PIC X(02)      VALUE SPACES.      
P0795A     05 CODE-SERVICE-TYPE-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 CODE-MTR-READ-FREQ-2046 PIC X(03)      VALUE SPACES.      
P0795A     05 READ-CYCLE-2046         PIC X(02)      VALUE SPACES.      
P0795A     05 READ-ROUTE-2046         PIC S9(4) COMP VALUE 0.           
P0795A     05 SPLY-SENSITIVE-IND-2046 PIC X(01)      VALUE SPACES.      
P0795A     05 ACTIVE-METERS-NO-2046   PIC S9(9) COMP VALUE 0.           
P0795A     05 GAS-BASE-LAST-UPDT-2046 PIC X(08)      VALUE SPACES.      
P0795A     05 DATE-LFTM-HI-DMD-2046   PIC X(08)      VALUE SPACES.      
P0795A     05 STATE-TAX-EXMPT-NO-2046 PIC X(13)      VALUE SPACES.      
P0795A     05 CODE-STAT-TAX-XMT-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 CODE-CITY-TAX-XMT-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 ACTIVE-PLANS-IND-2046   PIC X(01)      VALUE SPACES.      
P0795A     05 MULTIPLE-ICPS-IND-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 MULTI-GAS-ELE-IND-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 GAS-BASE-USE-2046       PIC S9(9)V COMP-3 VALUE 0.        
P0795A     05 LFTM-HI-PEAK-DMD-2046   PIC S9(7)V99 COMP-3 VALUE 0.      
P0795A     05 LFTM-HI-DMD-UNITS-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 ENERGY-PERIODS-2046     PIC X(01)      VALUE SPACES.      
P0795A     05 DEMAND-PERIODS-2046     PIC X(01)      VALUE SPACES.      
P0795A     05 CODE-UTIL-TYPE1-2046     PIC X(01)      VALUE SPACES.     
P0795A     05 IC-NO1-2046              PIC S9(4) COMP VALUE 0.          
P0795A     05 READ-METERS-IND-2046    PIC X(01)      VALUE SPACES.      
P0795A     05 FIXED-FACTORS-IND-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 BILL-CONTRACT-IND-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 INTERRUPT-ACCT-IND-2046 PIC X(01)      VALUE SPACES.      
P0795A     05 EPP-ACCOUNT-IND-2046    PIC X(01)      VALUE SPACES.      
P0795A     05 SERV-ORD-PEND-IND-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 LOCAL-OFFICE-2046       PIC X(03)      VALUE SPACES.      
P0795A     05 COMPANY-NO-2046         PIC X(02)      VALUE SPACES.      
P0795A     05 REV-DISTRICT-CD-2046    PIC X(03)      VALUE SPACES.      
P0795A     05 ENABLE-PEAK-IND-2046    PIC X(01)      VALUE SPACES.      
P0795A     05 PERSONAL-CNTCT-CD-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 BILL-CYCLE-2046         PIC X(02)      VALUE SPACES.      
P0795A     05 ZERO-USE-INVEST-DT-2046 PIC X(08)      VALUE SPACES.      
P0795A     05 ACCT-ON-BANK-DRAFT-2046 PIC X(01)      VALUE SPACES.      
P0795A     05 DUMMY1                  PIC X(01)      VALUE SPACES.      
P0795A     05 PRTY-SVC-CAT-CD-2046    PIC X(02)      VALUE SPACES.      
P0795A     05 ALT-FUEL-CD-2046        PIC X(01)      VALUE SPACES.      
P0795A     05 INDUS-GAS-CUST-2046     PIC X(01)      VALUE SPACES.      
P0795A     05 BASE-USE-IND-2046       PIC X(01)      VALUE SPACES.      
P0795A     05 SUBDVSN-LIGHT-IND-2046  PIC X(01)      VALUE SPACES.      
P0795A     05 NAICS-CD-2046           PIC X(06)      VALUE SPACES.      
P0795A     05 ACCT-TYPE-2046          PIC X(01)      VALUE SPACES.      
P0795A     05 ACCT-SUB-TYPE-2046      PIC X(01)      VALUE SPACES.      
P0795A     05 RATE-PKG-OPTION-2046    PIC X(255)     VALUE SPACES.      
P0795A     05 COD-MTR-RD-FRQ-IND      PIC X(01)      VALUE SPACES.      
P0795A     05 COD-MTR-RD-FRQ-MON      PIC X(01)      VALUE SPACES.      
P0795A     05 DATE-LFT-HI-DMD-PB      PIC X(10)      VALUE SPACES.      
P0795A     05 ZERO-USE-INS-DT-PB      PIC X(10)      VALUE SPACES.      
P0795A     05 RT-PKG-EXPIRE-FLAG-2046 PIC X(01)      VALUE SPACES.      
P0795A     05 AGL-SENIOR-FLAG-2046    PIC X(01)      VALUE SPACES.      
P0795A     05 OPTION-CD-2046          PIC X(12)      VALUE SPACES.      
P0795A     05 GROUP-CD-2046           PIC X(09)      VALUE SPACES.      
P0795A     05 PEND-OPTION-FL-2046     PIC X(01)      VALUE SPACES.      
P0795A     05 CURR-OPT-DESC-INT-2046  PIC X(50)      VALUE SPACES.      
P0795A     05 PEND-OPT-DESC-INT-2046  PIC X(50)      VALUE SPACES.      
P0795A     05 LAST-DRAFT-DATE-2046    PIC X(10)      VALUE SPACES.      
P0795A     05 DRAFT-CYCLE-2046        PIC X(02)      VALUE SPACES.      
P0795A     05 DRAFT-DATE-2046         PIC X(10)      VALUE SPACES.      
P0795A     05 ADJUSTABLE-OPTION-FLAG-2046 PIC X(1)        VALUE SPACES. 
                                                                        
A05317 01 CSR04642-CALL-DATA.                                           
A05317     05  APPL-PGM-ID-4642             PIC X(08).                  
A05317     05  UPDT-ACTION-IND-4642         PIC X(01).                  
A05317     05  USERID-4642                  PIC X(07).                  
A05317     05  ACCOUNT-NO-4642              PIC S9(13)V COMP-3 VALUE 0. 
A05317     05  PREMISE-NO-4642              PIC X(10).                  
A05317     05  CUSTOMER-NO-4642             PIC X(10).                  
A05317     05  COMPANY-NO-4642              PIC X(02).                  
A05317     05  CODE-UTIL-TYPE-4642          PIC X(01).                  
A05317     05  IC-NO-4642                   PIC S9(4) COMP.             
A05317     05  RATE-PLAN-NO-4642            PIC X(03).                  
A05317     05  CODE-REVENUE-CLASS-4642      PIC X(03).                  
A05317     05  CODE-SIC-NO-4672             PIC X(04).                  
A05317     05  NAICS-CD-4642                PIC X(06).                  
A05317     05  SEASONAL-USE-CODE-4642       PIC X(02).                  
A05317     05  ZERO-USE-INVEST-DT-4642      PIC X(10).                  
A05317     05  READ-CYCLE-4642              PIC X(02).                  
A05317     05  READ-ROUTE-4642 PIC S9(4) COMP VALUE 0.                  
A05317     05  CODE-MTR-READ-FREQ-4642      PIC X(03).                  
A05317     05  CODE-ESTIMATE-OK-4642        PIC X(01).                  
A05317     05  PERSONAL-CNTCT-CD-4642       PIC X(01).                  
A05317     05  ALTERNATE-FUEL-CD-4642       PIC X(01).                  
A05317     05  PRTY-SVC-CAT-CD-4642         PIC X(02).                  
A05317     05  GAS-BASE-USE-4642            PIC S9(09)V COMP-3 VALUE 0. 
A05317     05  GAS-BASE-LAST-UPDT-4642      PIC X(10).                  
A05317     05  CALC-ACT-TYPE-CD-4642        PIC X(01).                  
A05317     05  BILL-CYCLE-4642              PIC X(02).                  
A05317     05  PRORATE-CD-4642              PIC X(01).                  
A05317     05  DELETE-SUBDSN-FL-4642        PIC X(01).                  
A05317     05  WQ-COMMENT-4642              PIC X(210).                 
A05317     05  WQ-CREATE-FL-4642            PIC X(01).                  
                                                                        
A05317 01 CSR04642-RETURN-DATA.                                         
A05317     05  RETURN-CODE-4642             PIC S9(9) COMP VALUE 0.     
A05317     05  APPL-RETURN-CODE-4642        PIC S9(9) COMP VALUE 0.     
A05317     05  BUS-RULE-ID-4642             PIC X(10)  VALUE SPACES.    
A05317     05  ACTION-TYPE-CD-4642          PIC X(08)  VALUE SPACES.    
A05317     05  BUS-RULE-XREF-ID-4642        PIC X(26)  VALUE SPACES.    
                                                                        
                                                                        
       01  CSR01116-CALL-DATA.                                          
           03 LOCAL-OFFICE-1116         PIC X(03) VALUE SPACES.         
           03 CODE-UTIL-TYPE-1116       PIC X(50) VALUE SPACES.         
           03 WORK-TYPE-CD-1116         PIC X(150) VALUE SPACES.        
           03 CRAWL-IND-1116            PIC X(01) VALUE SPACES.         
           03 METER-IND-1116            PIC X(50) VALUE SPACES.         
           03 ZIP-CODE-1116             PIC X(05) VALUE SPACES.         
           03 READ-ROUTE-1116           PIC X(04) VALUE SPACES.         
           03 POINT-ID-1116             PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR01116-RETURN-DATA.                                        
           05  RETURN-CODE-1116         PIC S9(9) COMP VALUE 0.         
           05  WORK-AREA-1116           PIC X(12) VALUE SPACES.         
P00718     05  BUSINESS-UNIT-1116       PIC X(03) VALUE SPACES.         
                                                                        
      ******************************************************************        
      * CSR01105 - GET DATA FOR EXISTING SERVICE ORDER                 *        
      ******************************************************************        
                                                                        
       01  CSR01105-CALL-DATA.                                          
           03  SERV-ORDER-NO-1105       PIC X(13) VALUE SPACES.         
           03  HISTORY-FL-1105          PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01105-RETURN-DATA.                                        
           05  RETURN-CODE-1105          PIC S9(9) COMP VALUE 0.        
           05  ORDER-TYPE-CD-1105        PIC X(05) VALUE SPACES.        
           05  ORDER-REASON-1105         PIC X(15) VALUE SPACES.        
           05  STATUS-TX-1105            PIC X(25) VALUE SPACES.        
           05  ORDER-STATE-CD-1105       PIC X(01) VALUE SPACES.        
           05  ORDER-PLACED-BY-1105      PIC X(25) VALUE SPACES.        
           05  PHONE-NO-1105             PIC X(10) VALUE SPACES.        
           05  PHONE-NO-EXT-1105         PIC X(06) VALUE SPACES.        
           05  WANTED-BY-DATETIME-1105   PIC X(26) VALUE SPACES.        
           05  ASSIGNED-DATETIME-1105    PIC X(26) VALUE SPACES.        
           05  CALL-BEFORE-MINUTS-1105   PIC X(03) VALUE SPACES.        
           05  WORK-AREA-ID-1105         PIC X(12) VALUE SPACES.        
           05  BREAKERS-OFF-IND-1105     PIC X(01) VALUE SPACES.        
           05  INIT-BY-CNTRCT-IND-1105   PIC X(01) VALUE SPACES.        
           05  NOTIFY-CSR-IND-1105       PIC X(01) VALUE SPACES.        
           05  NOTIFY-CUST-IND-1105      PIC X(01) VALUE SPACES.        
           05  ORDER-PRIORITY-CD-1105    PIC S9(4) COMP VALUE 0.        
           05  STD-LABOR-CHRG-1105       PIC S9(7)V9(2) COMP-3 VALUE 0. 
           05  WORK-TYPE-CD-1105         PIC X(03) VALUE SPACES.        
           05  BACK-DATED-IND-1105       PIC X(01) VALUE SPACES.        
           05  DEPOSIT-AMT-1105          PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  ORDER-RECVED-BY-1105      PIC X(07) VALUE SPACES.        
           05  VERIFY-RATE-1105          PIC X(01) VALUE SPACES.        
           05  PREMISE-NO-1105           PIC S9(10)V COMP-3 VALUE 0.    
           05  ACCOUNT-NO-1105           PIC S9(13)V COMP-3 VALUE 0.    
           05  ACCOUNT-NO-PRIOR-1105     PIC S9(13)V COMP-3 VALUE 0.    
           05  BEGIN-APPT-DATE-1105      PIC X(26) VALUE SPACES.        
           05  SO-EST-LABOR-HR-1105      PIC S9(5)V9 COMP-3 VALUE 0.    
           05  CUSTCHG-ORD-TYPE-FL-1105  PIC X(01) VALUE SPACES.        
           05  AMOUNT-DISC-BAL-1105      PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  FILLER-1105               PIC S9(4) COMP VALUE 0.        
           05  CURRENT-DATE-1105         PIC X(10) VALUE SPACES.        
           05  CODE-UTIL-TYPE-1105       PIC X(01) VALUE SPACES.        
           05  PRICE-PER-SERV-1105       PIC S9(3)V9(6) COMP-3 VALUE 0. 
           05  ACCOUNT-TYPE-DESC-1105    PIC X(25) VALUE SPACES.        
           05  ORDER-CHARGE-AMT-1105     PIC S9(3)V9(2) COMP-3 VALUE 0. 
           05  TOTAL-CHARGES-AMT-1105    PIC S9(7)V9(2) COMP-3 VALUE 0. 
           05  CUST-CNT-ID-1105          PIC X(10) VALUE SPACES.        
           05  FILLER-A-1105             PIC X(01) VALUE SPACES.        
           05  FILLER-B-1105             PIC X(10) VALUE SPACES.        
           05  FILLER-C-1105             PIC X(08) VALUE SPACES.        
           05  FILLER-D-1105             PIC X(10) VALUE SPACES.        
           05  FILLER-E-1105             PIC X(04) VALUE SPACES.        
           05  MTR-ACCESSIBLE-CD-1105    PIC X(02) VALUE SPACES.        
           05  MTR-ACCESSIBLE-DT-1105    PIC X(10) VALUE SPACES.        
           05  MTR-ACCESSIBLE-RSN-1105   PIC X(02) VALUE SPACES.        
           05  SOURCE-SYSTEM-CD-1105     PIC X(03) VALUE SPACES.        
           05  ALT-PHONE-NO-1105         PIC X(10) VALUE SPACES.        
           05  ALT-PHONE-NO-EXT-1105     PIC X(06) VALUE SPACES.        
           05  HOME-ALL-DAY-FL-1105      PIC X(01) VALUE SPACES.        
P00718     05  BUSINESS-UNIT-1105        PIC X(03) VALUE SPACES.        
P00718     05  OPTIMIZE-ORDER-1105       PIC X(01) VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR03374 - ADD/UPDATE UNMETERED ORDER                          *        
      ******************************************************************        
                                                                        
       01  CSR03374-CALL-DATA.                                          
           05  PREMISE-NO-3374          PIC X(10)  VALUE SPACES.        
           05  ACCOUNT-NO-3374          PIC X(13)  VALUE SPACES.        
           05  ACCOUNT-NO-PRIOR-3374    PIC X(13)  VALUE SPACES.        
           05  SERV-ORDER-NO-3374       PIC X(13)  VALUE SPACES.        
           05  ORDER-TYPE-CD-3374       PIC X(05)  VALUE SPACES.        
           05  LOCAL-OFFICE-3374        PIC X(03)  VALUE SPACES.        
           05  PHONE-NO-EXT-3374        PIC X(06)  VALUE SPACES.        
           05  PHONE-NO-3374            PIC X(10)  VALUE SPACES.        
           05  ORDER-PLACED-BY-3374     PIC X(25)  VALUE SPACES.        
           05  ORDER-RECVED-BY-3374     PIC X(07)  VALUE SPACES.        
           05  WANTED-BY-DATE-3374      PIC X(10)  VALUE SPACES.        
           05  ASSIGNED-DATETIME-3374   PIC X(26)  VALUE SPACES.        
           05  ORDER-REASON-3374        PIC X(01)  VALUE SPACES.        
           05  BACK-DATED-IND-3374      PIC X(01)  VALUE SPACES.        
           05  RESP-AREA-ID-3374        PIC X(03)  VALUE SPACES.        
           05  CALL-BEFORE-MIN-3374     PIC X(03)  VALUE SPACES.        
           05  NOTIFY-CUST-IND-3374     PIC X(01)  VALUE SPACES.        
           05  NOTIFY-CSR-IND-3374      PIC X(01)  VALUE SPACES.        
           05  BREAKERS-OFF-3374        PIC X(01)  VALUE SPACES.        
           05  DEPOSIT-AMT-3374         PIC X(11)  VALUE SPACES.        
           05  INIT-BY-CNTRCT-3374      PIC X(01)  VALUE SPACES.        
           05  WORK-AREA-ID-3374        PIC X(12)  VALUE SPACES.        
           05  ORDER-PRIORITY-3374      PIC X(04)  VALUE SPACES.        
           05  ORDER-STATE-CD-3374      PIC X(01)  VALUE SPACES.        
           05  WORK-TYPE-CD-3374        PIC X(03)  VALUE SPACES.        
           05  CODE-UTIL-TYPE-3374      PIC X(01)  VALUE SPACES.        
           05  STD-CHG-AMT-3374         PIC X(09)  VALUE SPACES.        
           05  VERIFY-RATE-3374         PIC X(01)  VALUE SPACES.        
           05  PANEL-NO-3374            PIC X(04)  VALUE SPACES.        
           05  USER-ID-3374             PIC X(07)  VALUE SPACES.        
           05  SO-EST-LABOR-HR-3374     PIC X(03)  VALUE SPACES.        
           05  ACCT-STATUS-3374         PIC X(01)  VALUE SPACES.        
           05  REORDER-FLAG-3374        PIC X(01)  VALUE SPACES.        
           05  COMPANY-NO-3374          PIC X(02)  VALUE SPACES.        
           05  OLD-ACCOUNT-STAT-3374    PIC X(01)  VALUE SPACES.        
           05  CODE-KEY-FIELD-3374      PIC X(01)  VALUE SPACES.        
           05  DATE-FORECAST-DNP-3374    PIC X(10)  VALUE SPACES.       
           05  AMT-DNP-AT-BILLING-3374    PIC X(11)  VALUE SPACES.      
           05  PRICE-PER-SERV-3374      PIC X(09)  VALUE SPACES.        
           05  ACCOUNT-TYPE-CODE-3374    PIC X(01)  VALUE SPACES.       
           05  WORK-PERIOD-CD-3374      PIC X(01)  VALUE SPACES.        
           05  WAIVER-TYPE-CD-3374      PIC X(01)  VALUE SPACES.        
           05  BUSINESS-UNIT-3374       PIC X(03)  VALUE SPACES.        
                                                                        
       01  CSR03374-RETURN-DATA.                                        
           05  RETURN-CODE-3374         PIC S9(9)  COMP VALUE 0.        
           05  NEW-SERV-ORDER-NO-3374   PIC S9(13)V COMP-3 VALUE 0.     
      ******************************************************************        
ACT233* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT233     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT233     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
      ******************************************************************        
      * CSR02517 - ADD A COMMUNICATION RECORD                          *        
      ******************************************************************        
                                                                        
       01  CSR02517-CALL-DATA.                                          
           05  ACTION-CD-2517            PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2517           PIC X(13) VALUE SPACES.        
           05  CUSTOMER-NO-2517          PIC X(10) VALUE SPACES.        
           05  PREMISE-NO-2517           PIC X(10) VALUE SPACES.        
           05  COMMUNICATION-ID-2517     PIC X(26) VALUE SPACES.        
           05  COMPANY-NO-2517           PIC X(13) VALUE SPACES.        
           05  RED-FLAG-IND-2517         PIC X(01) VALUE SPACES.        
           05  RED-FLAG-EXP-DT-2517      PIC X(26) VALUE SPACES.        
           05  COMM-METHOD-2517          PIC X(01) VALUE SPACES.        
           05  COMM-DIRECTION-2517       PIC X(01) VALUE SPACES.        
           05  COMM-TYPE-CD-2517         PIC X(02) VALUE SPACES.        
           05  COMM-SUBTYPE-CD-2517      PIC X(02) VALUE SPACES.        
           05  USER-ID-ORIG-2517         PIC X(07) VALUE SPACES.        
           05  CONTACT-NAME-2517         PIC X(25) VALUE SPACES.        
           05  PROMOTION-ID-2517         PIC X(12) VALUE SPACES.        
           05  PSC-COMPLAINT-IND-2517    PIC X(01) VALUE SPACES.        
           05  CALL-ORIGIN-ID-2517       PIC X(04) VALUE SPACES.        
           05  CALL-END-TIME-2517        PIC X(26) VALUE SPACES.        
           05  NUMBER-TRANSFERS-2517     PIC X(09) VALUE SPACES.        
           05  HOLD-TIME-2517            PIC X(05) VALUE SPACES.        
           05  QUEUE-TIME-2517           PIC X(05) VALUE SPACES.        
           05  SCREEN-POP-IND-2517       PIC X(01) VALUE SPACES.        
           05  TOTAL-CALL-TIME-2517      PIC X(05) VALUE SPACES.        
           05  COMMENT-LEN-2517          PIC S9(4) COMP VALUE 0.        
           05  COMMENT-TEXT-2517         PIC X(255) VALUE SPACES.       
           05  COMM-ASSOC-CD-2517        PIC X(01) VALUE SPACES.        
           05  COMPLAINT-FL-2517         PIC X(01) VALUE SPACES.        
           05  RESPONSE-RESN-CD-2517     PIC X(04) VALUE SPACES.        
           05  RESPONSE-TYPE-CD-2517     PIC X(04) VALUE SPACES.        
           05  SOLICITATION-CD-2517      PIC X(03) VALUE SPACES.        
                                                                        
       01  CSR02517-RETURN-DATA.                                        
           05  RETURN-CODE-2517          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02165 - ADD A WAIVER                                        *        
      ******************************************************************        
                                                                        
       01  CSR02165-CALL-DATA.                                          
           05  ACTION-CODE-2165          PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2165           PIC X(13) VALUE SPACES.        
           05  WAIVER-TYPE-CD-2165       PIC X(01) VALUE SPACES.        
           05  CODE-STATUS-2165          PIC X(01) VALUE SPACES.        
           05  COMMENTS-LEN-2165         PIC X(04) VALUE SPACES.        
           05  COMMENTS-TEXT-2165        PIC X(72) VALUE SPACES.        
           05  CODE-STATUS-REAS-2165     PIC X(20) VALUE SPACES.        
           05  WAIVER-SRCE-DESC-2165     PIC X(35) VALUE SPACES.        
           05  TRIGGER-DATE-2165         PIC X(10) VALUE SPACES.        
           05  BOND-ITEM-ID-2165         PIC X(09) VALUE SPACES.        
           05  USER-ID-2165              PIC X(07) VALUE SPACES.        
           05  TRAN-COMMENT-LEN-2165     PIC X(04) VALUE SPACES.        
           05  TRAN-COMMENT-TXT-2165     PIC X(210) VALUE SPACES.       
                                                                        
       01  CSR02165-RETURN-DATA.                                        
           05  RETURN-CODE-2165          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR00151 - ADD SERVICE ORDER CHARGES                           *        
      ******************************************************************        
                                                                        
       01  CSR00151-CALL-DATA.                                          
           05  SERV-ORDER-NO-0151        PIC X(13) VALUE SPACES.        
           05  CODE-UTIL-TYPE-0151       PIC X(01) VALUE SPACES.        
           05  OT-CHARGEABLE-HR-0151     PIC S9(4) COMP VALUE 0.        
           05  REG-CHARGEABLE-HR-0151    PIC S9(4) COMP VALUE 0.        
           05  MATERIAL-CHRG-0151        PIC S9(7)V99 COMP-3 VALUE 0.   
           05  OTHER-CHRG-0151           PIC S9(7)V99 COMP-3 VALUE 0.   
           05  CALC-LABOR-CHRG-0151      PIC S9(7)V99 COMP-3 VALUE 0.   
           05  COMMENTS-0151             PIC X(35) VALUE SPACES.        
           05  STD-LABOR-CHRG-0151       PIC S9(7)V99 COMP-3 VALUE 0.   
           05  ACCOUNT-TYPE-CD-0151      PIC X(01) VALUE SPACES.        
           05  USER-ID-0151              PIC X(07) VALUE SPACES.        
           05  PANEL-NO-0151             PIC X(04) VALUE SPACES.        
           05  WORK-PERIOD-CD-0151       PIC X(01) VALUE SPACES.        
           05  WAIVER-TYPE-CD-0151       PIC X(01) VALUE SPACES.        
                                                                        
       01  CSR00151-RETURN-DATA.                                        
           05  RETURN-CODE-0151          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR01416 - GET DATE X NUMBER OF BUSINESS DAYS IN THE FUTURE    *        
      ******************************************************************        
                                                                        
       01  CSR01416-CALL-DATA.                                          
           05  INPUT-DATE-1416           PIC X(26) VALUE SPACES.        
           05  BUSINESS-DAYS-1416        PIC S9(4) COMP VALUE 0.        
                                                                        
       01  CSR01416-RETURN-DATA.                                        
           05  OUTPUT-DATE-1416          PIC X(26) VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR02120 - SET SO PENDING FLAG                                 *        
      ******************************************************************        
                                                                        
       01  CSR02120-CALL-DATA.                                          
           05  PREMISE-NO-2120           PIC X(10) VALUE SPACES.        
           05  ACCOUNT-NO-2120           PIC X(13) VALUE SPACES.        
           05  ORDER-TYPE-CD-2120        PIC X(05) VALUE SPACES.        
           05  ORDER-STATE-CD-2120       PIC X(01) VALUE SPACES.        
                                                                        
       01  CSR02120-RETURN-DATA.                                        
           05  RETURN-CODE-2120          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR01297 - ADD/UPDATE APPLIANCE                                *        
      ******************************************************************        
                                                                        
       01  CSR01297-CALL-DATA.                                          
           03  UPDATE-TYPE-1297         PIC X(02) VALUE SPACES.         
           03  PREMISE-NO-1297          PIC X(10) VALUE SPACES.         
           03  EQUIPMENT-NO-1297        PIC X(20) VALUE SPACES.         
           03  COMPANY-NO-1297          PIC X(02) VALUE SPACES.         
           03  APPLIANCE-CD-1297        PIC X(02) VALUE SPACES.         
           03  CAUTION-TAG-IND-1297     PIC X(01) VALUE SPACES.         
           03  CUT-IND-1297             PIC X(01) VALUE SPACES.         
           03  PRIMARY-FUEL-CD-1297     PIC X(06) VALUE SPACES.         
           03  UPDATE-DT-1297           PIC X(10) VALUE SPACES.         
           03  UPDATE-ID-1297           PIC X(07) VALUE SPACES.         
           03  TAG-NO-1297              PIC X(10) VALUE SPACES.         
           03  CONDITION-CD-1297        PIC X(03) VALUE SPACES.         
           03  LOCATION-CD-1297         PIC X(03) VALUE SPACES.         
           03  APPL-CMNT-LEN-1297       PIC S9(04) COMP VALUE 0.        
           03  APPL-CMNT-TXT-1297       PIC X(255) VALUE SPACES.        
           03  CAUTION-TAG-DT-1297      PIC X(10) VALUE SPACES.         
           03  SOURCE-SYSTEM-CD-1297    PIC X(03) VALUE SPACES.         
           03  CMNT-TXT-LEN-1297        PIC S9(04) COMP VALUE 0.        
           03  CMNT-TXT-1297            PIC X(255) VALUE SPACES.        
                                                                        
       01  CSR01297-RETURN-DATA.                                        
           05  RETURN-CODE-1297      PIC S9(9)     COMP VALUE 0.        
           05  WQ-FLAG-1297          PIC X(01)     VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR01334 - SEND ORDER TO PRINT/CAD                             *        
      ******************************************************************        
                                                                        
       01  CSR01334-CALL-DATA.                                          
           03  SERV-ORDER-NO-1334       PIC X(13) VALUE SPACES.         
           03  PRINT-DEST-1334          PIC X(15) VALUE SPACES.         
           03  PRINT-DEST-IND-1334      PIC X(01) VALUE SPACES.         
           03  USER-ID-1334             PIC X(07) VALUE SPACES.         
           03  CAD-TRANS-TYPE-1334      PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01334-RETURN-DATA.                                        
           05  RETURN-CODE-1334      PIC S9(9)     COMP VALUE 0.        
           05  ITEM-ID-1334          PIC S9(10)V   COMP-3 VALUE 0.      
                                                                        
      ******************************************************************        
      * CSR02059 - UPDATE ADDITIONAL PREMISE INFO                      *        
      ******************************************************************        
                                                                        
       01  CSR02059-CALL-DATA.                                          
           03  PREMISE-NO-2059          PIC X(10) VALUE SPACES.         
           03  PREMISE-DIR-LEN-2059     PIC S9(4) COMP VALUE 0.         
           03  PREMISE-DIR-TEXT-2059    PIC X(255) VALUE SPACES.        
           03  PREMISE-SCR-LEN-2059     PIC S9(4) COMP VALUE 0.         
           03  PREMISE-SCR-TEXT-2059    PIC X(255) VALUE SPACES.        
           03  PREMISE-SPIN-LEN-2059    PIC S9(4) COMP VALUE 0.         
           03  PREMISE-SPIN-TEXT-2059   PIC X(255) VALUE SPACES.        
           03  PREMISE-RDIN-LEN-2059    PIC S9(4) COMP VALUE 0.         
           03  PREMISE-RDIN-TEXT-2059   PIC X(255) VALUE SPACES.        
           03  DATE-SPCL-MSG-ENDS-2059  PIC X(10) VALUE SPACES.         
           03  USERID-2059              PIC X(07) VALUE SPACES.         
                                                                        
       01  CSR02059-RETURN-DATA.                                        
           05  RETURN-CODE-2059      PIC S9(9)     COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR04747 - CHECK IF CLICK AND GET WORK DISTRICT                *        
      ******************************************************************        
                                                                        
       01  CSR04747-CALL-DATA.                                          
           03  SERV-ORDER-NO-4747       PIC X(13) VALUE SPACES.         
           03  PRIORITY-4747            PIC X(01) VALUE SPACES.         
           03  ACTION-CD-4747           PIC X(01) VALUE SPACES.         
           03  USER-ID-4747             PIC X(07) VALUE SPACES.         
           03  WORK-DISTRICT-IN-4747    PIC X(40) VALUE SPACES.         
                                                                        
       01  CSR04747-RETURN-DATA.                                        
           05  RETURN-CODE-4747          PIC S9(9) COMP VALUE 0.        
           05  WORK-DISTRICT-OUT-4747    PIC X(40) VALUE SPACES.        
                                                                        
                                                                        
D10675******************************************************************        
D10675* CSR00092 - UPDATE REQUIREMENT FOR MARKETING ORDERS             *        
D10675******************************************************************        
D10675                                                                  
D10675 01  CSR00092-CALL-DATA.                                          
D10675     05 SERV-ORDER-NO-0092       PIC X(13) VALUE SPACES.          
D10675     05 SERV-ORDER-STATUS-0092   PIC X(02) VALUE SPACES.          
D10675     05 REQUIREMENT_CD-0092      PIC X(03) VALUE SPACES.          
D10675     05 USERID-0092              PIC X(07) VALUE SPACES.          
D10675     05 WANTED-DATE-0092         PIC X(26) VALUE SPACES.          
D10675     05 PANEL-NO-0092            PIC X(04) VALUE SPACES.          
D10675     05 UPDATE-STATUS-0092       PIC X(02) VALUE SPACES.          
D10675                                                                  
D10675 01  CSR00092-RETURN-DATA.                                        
D10675     05  RETURN-CODE-0092        PIC S9(9) COMP VALUE 0.          
                                                                        
D10675******************************************************************        
D10675* CSR01110 - GET THE CURRENT SERVICE ORDER STATUS                *        
D10675******************************************************************        
D10675                                                                  
D10675 01  CSR01110-CALL-DATA.                                          
D10675     05 SERV-ORDER-NO-1110       PIC X(13) VALUE SPACES.          
D10675                                                                  
D10675 01  CSR01110-RETURN-DATA.                                        
D10675     05 SERV-ORDER-STATUS-1110   PIC X(02) VALUE SPACES.          
                                                                        
D10675******************************************************************        
D10675* CSR00413 - RESET REQUIREMENTS ON THE SERVICE ORDER             *        
D10675******************************************************************        
D10675                                                                  
D10675 01  CSR00413-CALL-DATA.                                          
D10675     05 SERV-ORDER-NO-0413       PIC X(13) VALUE SPACES.          
D10675     05 USER-ID-0413             PIC X(07) VALUE SPACES.          
D10675     05 PANEL-NO-0413            PIC X(03) VALUE SPACES.          
D10675                                                                  
D10675 01  CSR00413-RETURN-DATA.                                        
D10675     05 RETURN-CODE-0413         PIC S9(9) COMP VALUE 0.          
D10675     05 SERV-ORDER-STATUS-0413   PIC X(25) VALUE SPACES.          
      *                                                                         
      ******************************************************************        
      * CSR00425 - ADD CHANGE LOG REMARKS                              *        
      ******************************************************************        
                                                                        
       01  CSR00425-CALL-DATA.                                          
           05  SERV-ORDER-NO-0425        PIC X(13) VALUE SPACES.        
           05  REMARK-TYPE-CD-0425       PIC X(01) VALUE SPACES.        
           05  REMARKS-0425.                                            
              49 REMARKS-0425-LEN        PIC S9(4) USAGE COMP VALUE 0.  
              49 REMARKS-0425-TEXT       PIC X(210) VALUE SPACES.       
           05  USER-ID-0425              PIC X(07) VALUE SPACES.        
                                                                        
       01  CSR00425-RETURN-DATA.                                        
           05  RETURN-CODE-0425          PIC S9(9) COMP VALUE 0.        
      *                                                                         
       01  WS-COMPRESSION-TABLES.                                       
            05  WS-EMB-INPUT.                                           
                10  WS-EMB-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-EMB-INDX.         
            05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +255.          
            05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
            05  WS-EMB-LAST-CHAR        PIC X(01).                      
            05  WS-CMP-TABLE.                                           
                10  WS-CMP-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-CMP-INDX.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) COMP.                 
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) COMP.                 
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) COMP.                 
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC2210 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1116 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2517 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC3374 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2165 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0151 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1416 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2120 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1297 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1334 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2059 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
P0795A*01 LOC2046 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
P0795A*01 LOC2211 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
A05317*01 LOC4642 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
D10675*01 LOC1110 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
D10675*01 LOC0092 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
D10675*01 LOC0413 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
DT9687*01 LOC4747Z USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
DT9687*01 LOC4747S USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
DT9687*01 LOC4747U USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC0425 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
P0795N*01 LOC1105 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
               DECLARE APP_CURSOR CURSOR FOR                            
                   SELECT LA.APPLIANCE_CD,                              
                          LA.PRIMARY_FUEL_CD,                           
                          LA.EQUIPMENT_NO,                              
                          LA.CAUTION_TAG_IND,                           
                          A7.CONDITION_DESC,                            
                          LA.CUT_IND,                                   
                          JA.APPLIANCE_DESC,                            
                          JA.CRAWL_FL,                                  
                          JA.SEASONAL_RT_FL,                            
                          LA.LOCATION_CD                                
                     FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),               
                          CSS_APPLIANCE_COND A7 WITH(READUNCOMMITTED),          
                          CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)            
                    WHERE LA.PREMISE_NO = :LA-PREMISE-NO                
                      AND LA.PRIMARY_FUEL_CD = 'NA-GAS'                 
                      AND LA.CONDITION_CD    = A7.CONDITION_CD          
                      AND LA.COMPANY_NO      = A7.COMPANY_NO            
                      AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD          
                      AND LA.COMPANY_NO      = JA.COMPANY_NO            
                   FOR READ ONLY                                       
                                                                 
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE APP_CURSOR CURSOR FOR                                    
MFA-TR*            SELECT LA.APPLIANCE_CD,                                      
MFA-TR*                   LA.PRIMARY_FUEL_CD,                                   
MFA-TR*                   LA.EQUIPMENT_NO,                                      
MFA-TR*                   LA.CAUTION_TAG_IND,                                   
MFA-TR*                   A7.CONDITION_DESC,                                    
MFA-TR*                   LA.CUT_IND,                                           
MFA-TR*                   JA.APPLIANCE_DESC,                                    
MFA-TR*                   JA.CRAWL_FL,                                          
MFA-TR*                   JA.SEASONAL_RT_FL,                                    
MFA-TR*                   LA.LOCATION_CD                                        
MFA-TR*              FROM CSS_APPLIANCE LA,                                     
MFA-TR*                   CSS_APPLIANCE_COND A7,                                
MFA-TR*                   CSS_MKT_APPLIANCE JA                                  
MFA-TR*             WHERE LA.PREMISE_NO = :LA-PREMISE-NO                        
MFA-TR*               AND LA.PRIMARY_FUEL_CD = 'NA-GAS'                         
MFA-TR*               AND LA.CONDITION_CD    = A7.CONDITION_CD                  
MFA-TR*               AND LA.COMPANY_NO      = A7.COMPANY_NO                    
MFA-TR*               AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD                  
MFA-TR*               AND LA.COMPANY_NO      = JA.COMPANY_NO                    
MFA-TR*            FOR FETCH ONLY                                               
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7160                                                 
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2210 CURSOR
MSQ001          FOR CALL CSR02210                                             
                  ( :ACCOUNT-NO-2210
                  , :PREMISE-NO-2210
                  , :COMPANY-NO-2210
                  , :MKTG-ORDER-2210
                  , :RETURN-UTILS-2210
                  , :RETURN-DISC-BAL-2210
                  , :ORDER-REASON-2210
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1116 CURSOR
MSQ001          FOR CALL CSR01116                                             
                  ( :LOCAL-OFFICE-1116
                  , :CODE-UTIL-TYPE-1116
                  , :WORK-TYPE-CD-1116
                  , :CRAWL-IND-1116
                  , :METER-IND-1116
                  , :ZIP-CODE-1116
                  , :READ-ROUTE-1116
                  , :POINT-ID-1116
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2046 CURSOR
MSQ001          FOR CALL CSR02046                                             
                  ( :ACTION-MODE-2046
                  , :ACCOUNT-NO-2046
                  , :CODE-UTIL-TYPE-2046
                  , :IC-NO-2046
                  , :PREMISE-NO-2046
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4642 CURSOR
MSQ001          FOR CALL CSR04642                                             
A05317          ( :APPL-PGM-ID-4642
                  , :UPDT-ACTION-IND-4642
                  , :USERID-4642
                  , :ACCOUNT-NO-4642
                  , :PREMISE-NO-4642
                  , :CUSTOMER-NO-4642
                  , :COMPANY-NO-4642
                  , :CODE-UTIL-TYPE-4642
                  , :IC-NO-4642
                  , :RATE-PLAN-NO-4642
                  , :CODE-REVENUE-CLASS-4642
                  , :CODE-SIC-NO-4672
                  , :NAICS-CD-4642
                  , :SEASONAL-USE-CODE-4642
                  , :ZERO-USE-INVEST-DT-4642
                  , :READ-CYCLE-4642
                  , :READ-ROUTE-4642
                  , :CODE-MTR-READ-FREQ-4642
                  , :CODE-ESTIMATE-OK-4642
                  , :PERSONAL-CNTCT-CD-4642
                  , :ALTERNATE-FUEL-CD-4642
                  , :PRTY-SVC-CAT-CD-4642
                  , :GAS-BASE-USE-4642
                  , :GAS-BASE-LAST-UPDT-4642
                  , :CALC-ACT-TYPE-CD-4642
                  , :BILL-CYCLE-4642
                  , :PRORATE-CD-4642
                  , :DELETE-SUBDSN-FL-4642
                  , :WQ-COMMENT-4642
                  , :WQ-CREATE-FL-4642
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1105 CURSOR
MSQ001          FOR CALL CSR01105                                             
                  ( :SERV-ORDER-NO-1105
                  , :HISTORY-FL-1105
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_3374 CURSOR
MSQ001          FOR CALL CSR03374                                             
                    ( :PREMISE-NO-3374
                  , :ACCOUNT-NO-3374
                  , :ACCOUNT-NO-PRIOR-3374
                  , :SERV-ORDER-NO-3374
                  , :ORDER-TYPE-CD-3374
                  , :LOCAL-OFFICE-3374
                  , :PHONE-NO-EXT-3374
                  , :PHONE-NO-3374
                  , :ORDER-PLACED-BY-3374
                  , :ORDER-RECVED-BY-3374
                  , :WANTED-BY-DATE-3374
                  , :ASSIGNED-DATETIME-3374
                  , :ORDER-REASON-3374
                  , :BACK-DATED-IND-3374
                  , :RESP-AREA-ID-3374
                  , :CALL-BEFORE-MIN-3374
                  , :NOTIFY-CUST-IND-3374
                  , :NOTIFY-CSR-IND-3374
                  , :BREAKERS-OFF-3374
                  , :DEPOSIT-AMT-3374
                  , :INIT-BY-CNTRCT-3374
                  , :WORK-AREA-ID-3374
                  , :ORDER-PRIORITY-3374
                  , :ORDER-STATE-CD-3374
                  , :WORK-TYPE-CD-3374
                  , :CODE-UTIL-TYPE-3374
                  , :STD-CHG-AMT-3374
                  , :VERIFY-RATE-3374
                  , :PANEL-NO-3374
                  , :USER-ID-3374
                  , :SO-EST-LABOR-HR-3374
                  , :ACCT-STATUS-3374
                  , :REORDER-FLAG-3374
                  , :COMPANY-NO-3374
                  , :OLD-ACCOUNT-STAT-3374
                  , :CODE-KEY-FIELD-3374
                  , :DATE-FORECAST-DNP-3374
                  , :AMT-DNP-AT-BILLING-3374
                  , :PRICE-PER-SERV-3374
                  , :ACCOUNT-TYPE-CODE-3374
                  , :WORK-PERIOD-CD-3374
                  , :WAIVER-TYPE-CD-3374
                  , :BUSINESS-UNIT-3374
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1297 CURSOR
MSQ001          FOR CALL CSR01297                                             
                  ( :UPDATE-TYPE-1297
                  , :PREMISE-NO-1297
                  , :EQUIPMENT-NO-1297
                  , :COMPANY-NO-1297
                  , :APPLIANCE-CD-1297
                  , :CAUTION-TAG-IND-1297
                  , :CUT-IND-1297
                  , :PRIMARY-FUEL-CD-1297
                  , :UPDATE-DT-1297
                  , :UPDATE-ID-1297
                  , :TAG-NO-1297
                  , :CONDITION-CD-1297
                  , :LOCATION-CD-1297
                  , :APPL-CMNT-LEN-1297
                  , :APPL-CMNT-TXT-1297
                  , :CAUTION-TAG-DT-1297
                  , :SOURCE-SYSTEM-CD-1297
                  , :CMNT-TXT-LEN-1297
                  , :CMNT-TXT-1297
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1334 CURSOR
MSQ001          FOR CALL CSR01334                                             
                  ( :SERV-ORDER-NO-1334
                  , :PRINT-DEST-1334
                  , :PRINT-DEST-IND-1334
                  , :USER-ID-1334
                  , :CAD-TRANS-TYPE-1334
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2059 CURSOR
MSQ001          FOR CALL CSR02059                                             
                  ( :PREMISE-NO-2059
                  , :PREMISE-DIR-LEN-2059
                  , :PREMISE-DIR-TEXT-2059
                  , :PREMISE-SCR-LEN-2059
                  , :PREMISE-SCR-TEXT-2059
                  , :PREMISE-SPIN-LEN-2059
                  , :PREMISE-SPIN-TEXT-2059
                  , :PREMISE-RDIN-LEN-2059
                  , :PREMISE-RDIN-TEXT-2059
                  , :DATE-SPCL-MSG-ENDS-2059
                  , :USERID-2059
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2517 CURSOR
MSQ001          FOR CALL CSR02517                                             
                  ( :ACTION-CD-2517
                  , :ACCOUNT-NO-2517
                  , :CUSTOMER-NO-2517
                  , :PREMISE-NO-2517
                  , :COMMUNICATION-ID-2517
                  , :COMPANY-NO-2517
                  , :RED-FLAG-IND-2517
                  , :RED-FLAG-EXP-DT-2517
                  , :COMM-METHOD-2517
                  , :COMM-DIRECTION-2517
                  , :COMM-TYPE-CD-2517
                  , :COMM-SUBTYPE-CD-2517
                  , :USER-ID-ORIG-2517
                  , :CONTACT-NAME-2517
                  , :PROMOTION-ID-2517
                  , :PSC-COMPLAINT-IND-2517
                  , :CALL-ORIGIN-ID-2517
                  , :CALL-END-TIME-2517
                  , :NUMBER-TRANSFERS-2517
                  , :HOLD-TIME-2517
                  , :QUEUE-TIME-2517
                  , :SCREEN-POP-IND-2517
                  , :TOTAL-CALL-TIME-2517
                  , :COMMENT-LEN-2517
                  , :COMMENT-TEXT-2517
                  , :COMM-ASSOC-CD-2517
                  , :COMPLAINT-FL-2517
                  , :RESPONSE-RESN-CD-2517
                  , :RESPONSE-TYPE-CD-2517
                  , :SOLICITATION-CD-2517
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1416 CURSOR
MSQ001          FOR CALL CSR01416                                             
                  ( :INPUT-DATE-1416
                  , :BUSINESS-DAYS-1416
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2120 CURSOR
MSQ001          FOR CALL CSR02120                                             
                  ( :PREMISE-NO-2120
                  , :ACCOUNT-NO-2120
                  , :ORDER-TYPE-CD-2120
                  , :ORDER-STATE-CD-2120
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0092 CURSOR
MSQ001          FOR CALL CSR00092                                             
D10675             ( :SERV-ORDER-NO-0092
                  , :SERV-ORDER-STATUS-0092
                  , :REQUIREMENT_CD-0092
                  , :USERID-0092
                  , :WANTED-DATE-0092
                  , :PANEL-NO-0092
                  , :UPDATE-STATUS-0092
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1110 CURSOR
MSQ001          FOR CALL CSR01110                                             
D10675             ( :SERV-ORDER-NO-1110
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0425 CURSOR
MSQ001          FOR CALL CSR00425                                             
                  ( :SERV-ORDER-NO-0425
                  , :REMARK-TYPE-CD-0425
                  , :REMARKS-0425
                  , :USER-ID-0425
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747S CURSOR
MSQ001          FOR CALL CSR04747 ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :WORK-DISTRICT-IN-4747 OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747Z CURSOR
MSQ001          FOR CALL CSR04747 ( :VO-SERV-ORDER-NO
                  , '1'
                  , 'Z'
                  , :LINK-USER-ID
                  , :WS-WORK-DISTRICT OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747U CURSOR
MSQ001          FOR CALL CSR04747 ( :VO-SERV-ORDER-NO
                  , '1'
                  , 'U'
                  , :LINK-USER-ID
                  , :WS-WORK-DISTRICT OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0413 CURSOR
MSQ001          FOR CALL CSR00413                                             
                  ( :SERV-ORDER-NO-0413
                  , :USER-ID-0413
                  , :PANEL-NO-0413
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-ORDER-TYPE-CD      PIC X(05).                           
       01  LINK-ARRANGEMENT-FL     PIC X(01).                           
       01  LINK-START-TS           PIC X(26).                           
       01  LINK-STOP-TS            PIC X(26).                           
       01  LINK-PHONE-NO-EXT       PIC X(06).                           
       01  LINK-PHONE-NO           PIC X(10).                           
       01  LINK-ORDER-PLACED-BY    PIC X(25).                           
       01  LINK-ORDER-RECVED-BY    PIC X(07).                           
       01  LINK-WANTED-BY-DATE     PIC X(10).                           
       01  LINK-ASSIGNED-DATETIME  PIC X(26).                           
       01  LINK-ORDER-REASON       PIC X(01).                           
       01  LINK-BACK-DATED-IND     PIC X(01).                           
       01  LINK-CALL-BEFORE-MIN    PIC X(03).                           
       01  LINK-NOTIFY-CSR         PIC X(01).                           
       01  LINK-NOTIFY-CUSTOMER    PIC X(01).                           
       01  LINK-BREAKERS-OFF       PIC X(01).                           
       01  LINK-STD-CHG-AMT        PIC X(09).                           
       01  LINK-DEPOSIT-AMT        PIC X(11).                           
       01  LINK-INIT-BY-CNTRCT     PIC X(01).                           
       01  LINK-WORK-AREA-ID       PIC X(12).                           
       01  LINK-ORDER-STATE-CD     PIC X(01).                           
       01  LINK-WORK-TYPE-CD       PIC X(03).                           
       01  LINK-CODE-UTIL-TYPE     PIC X(01).                           
       01  LINK-VERIFY-RATE        PIC X(01).                           
       01  LINK-PANEL-NO           PIC X(04).                           
       01  LINK-USER-ID            PIC X(07).                           
       01  LINK-EST-LABOR-HRS      PIC X(03).                           
       01  LINK-ACCT-STATUS        PIC X(01).                           
       01  LINK-REORDER-FLAG       PIC X(01).                           
       01  LINK-OLD-ACCOUNT-STAT   PIC X(01).                           
       01  LINK-CODE-KEY-FIELD     PIC X(01).                           
       01  LINK-DATE-FORECAST-DNP  PIC X(10).                           
       01  LINK-AMT-DNP-AT-BILL    PIC X(11).                           
       01  LINK-CUST-CNT-ID        PIC X(10).                           
       01  LINK-PRICE-PER-SERV     PIC X(09).                           
       01  LINK-ACCOUNT-TYPE-CD    PIC X(01).                           
       01  LINK-WORK-PERIOD-CD     PIC X(01).                           
       01  LINK-WAIVER-TYPE-CD     PIC X(01).                           
       01  LINK-ALT-PHONE-NO       PIC X(10).                           
       01  LINK-MTR-ACCESS-CD      PIC X(02).                           
       01  LINK-MTR-ACCESS-RSN     PIC X(02).                           
       01  LINK-SO-REMARKS         PIC X(210).                          
       01  LINK-SPCL-READ-INST     PIC X(114).                          
       01  LINK-SPCL-INST          PIC X(255).                          
       01  LINK-PREM-DIRECTIONS    PIC X(255).                          
       01  LINK-SCRATCHPAD         PIC X(255).                          
       01  LINK-COMM-COMMENTS      PIC X(255).                          
       01  LINK-CDP                PIC X(35).                           
       01  LINK-SOURCE-SYSTEM      PIC X(03).                           
       01  LINK-HOLD-REMARKS       PIC X(210).                          
       01  LINK-OVERRIDE-REMARKS   PIC X(210).                          
       01  LINK-ALT-PHONE-NO-EXT   PIC X(06).                           
       01  LINK-HOME-ALL-DAY       PIC X(01).                           
       01  LINK-COMM-METHOD        PIC X(01).                           
       01  LINK-CHANGE-REMARKS     PIC X(210).                          
       01  LINK-BUSINESS-UNIT      PIC X(03).                           
       01  LINK-APPLIANCE-PARMS    PIC X(2500).                         
       01  LINK-UTILITY-PARMS      PIC X(550).                          
P0795C 01  LINK-ORDER-KEY          PIC X(14).                           
P0795D 01  LINK-SERV-ORDER-NO      PIC X(13).                           
P0795D 01  LINK-DONOT-OPTIMIZE-FL  PIC X(01).                           
D10563 01  LINK-CLICK-ORDER-CODE   PIC X(01).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-PREMISE-NO                               
                          LINK-ACCOUNT-NO                               
                          LINK-ORDER-TYPE-CD                            
                          LINK-ARRANGEMENT-FL                           
                          LINK-START-TS                                 
                          LINK-STOP-TS                                  
                          LINK-PHONE-NO-EXT                             
                          LINK-PHONE-NO                                 
                          LINK-ORDER-PLACED-BY                          
                          LINK-ORDER-RECVED-BY                          
                          LINK-WANTED-BY-DATE                           
                          LINK-ASSIGNED-DATETIME                        
                          LINK-ORDER-REASON                             
                          LINK-BACK-DATED-IND                           
                          LINK-CALL-BEFORE-MIN                          
                          LINK-NOTIFY-CUSTOMER                          
                          LINK-NOTIFY-CSR                               
                          LINK-BREAKERS-OFF                             
                          LINK-STD-CHG-AMT                              
                          LINK-DEPOSIT-AMT                              
                          LINK-INIT-BY-CNTRCT                           
                          LINK-WORK-AREA-ID                             
                          LINK-ORDER-STATE-CD                           
                          LINK-WORK-TYPE-CD                             
                          LINK-CODE-UTIL-TYPE                           
                          LINK-VERIFY-RATE                              
                          LINK-PANEL-NO                                 
                          LINK-USER-ID                                  
                          LINK-EST-LABOR-HRS                            
                          LINK-ACCT-STATUS                              
                          LINK-REORDER-FLAG                             
                          LINK-OLD-ACCOUNT-STAT                         
                          LINK-CODE-KEY-FIELD                           
                          LINK-DATE-FORECAST-DNP                        
                          LINK-AMT-DNP-AT-BILL                          
                          LINK-CUST-CNT-ID                              
                          LINK-PRICE-PER-SERV                           
                          LINK-ACCOUNT-TYPE-CD                          
                          LINK-WORK-PERIOD-CD                           
                          LINK-WAIVER-TYPE-CD                           
                          LINK-ALT-PHONE-NO                             
                          LINK-MTR-ACCESS-CD                            
                          LINK-MTR-ACCESS-RSN                           
                          LINK-SO-REMARKS                               
                          LINK-SPCL-READ-INST                           
                          LINK-SPCL-INST                                
                          LINK-PREM-DIRECTIONS                          
                          LINK-SCRATCHPAD                               
                          LINK-COMM-COMMENTS                            
                          LINK-CDP                                      
                          LINK-SOURCE-SYSTEM                            
                          LINK-HOLD-REMARKS                             
                          LINK-OVERRIDE-REMARKS                         
                          LINK-ALT-PHONE-NO-EXT                         
                          LINK-HOME-ALL-DAY                             
                          LINK-COMM-METHOD                              
                          LINK-CHANGE-REMARKS                           
                          LINK-BUSINESS-UNIT                            
                          LINK-APPLIANCE-PARMS                          
                          LINK-UTILITY-PARMS                            
P0795C                    LINK-ORDER-KEY                                
P0795D                    LINK-SERV-ORDER-NO                            
P0795D                    LINK-DONOT-OPTIMIZE-FL                        
D10563                    LINK-CLICK-ORDER-CODE.                        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE        AS RETURN_CODE,             
                      :S-STATUS-CODE        AS STATUS_CODE,             
                      :S-SERV-ORDER-NO      AS SERV_ORDER_NO,           
                      :S-ORDER-TYPE-CD      AS ORDER_TYPE_CD            
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE        AS RETURN_CODE,                     
MFA-TR*               :S-STATUS-CODE        AS STATUS_CODE,                     
MFA-TR*               :S-SERV-ORDER-NO      AS SERV_ORDER_NO,                   
MFA-TR*               :S-ORDER-TYPE-CD      AS ORDER_TYPE_CD                    
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE),'USA')
            INTO
              :WS-CURRENT-DATE-USA       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE-USA = CHAR(CURRENT_DATE,USA)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-LAST-YEAR                                
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 1 YEAR)                        
MFA-TR*          INTO :WS-DATE-LAST-YEAR                                        
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ORDER-STATE-CD <= SPACES                             
               MOVE 'A' TO LINK-ORDER-STATE-CD
           END-IF.                         
           IF LINK-CALL-BEFORE-MIN = '060'                              
               MOVE '60 ' TO LINK-CALL-BEFORE-MIN
           END-IF.                      
           IF LINK-CALL-BEFORE-MIN = '045'                              
               MOVE '45 ' TO LINK-CALL-BEFORE-MIN
           END-IF.                      
           IF LINK-CALL-BEFORE-MIN = '030'                              
               MOVE '30 ' TO LINK-CALL-BEFORE-MIN
           END-IF.                      
           IF LINK-CALL-BEFORE-MIN = '015'                              
               MOVE '15 ' TO LINK-CALL-BEFORE-MIN
           END-IF.                      
           IF LINK-CALL-BEFORE-MIN = '000' OR '00 ' OR '0  '            
               MOVE SPACES TO LINK-CALL-BEFORE-MIN
           END-IF.                     
           IF LINK-CALL-BEFORE-MIN > SPACES                             
              IF LINK-ARRANGEMENT-FL <= SPACES                          
                  MOVE 'C' TO LINK-ARRANGEMENT-FL                       
              ELSE                                                      
                  MOVE 'B' TO LINK-ARRANGEMENT-FL
              END-IF
           END-IF.                      
           IF LINK-HOME-ALL-DAY > SPACES AND                            
              LINK-ARRANGEMENT-FL <= SPACES                             
               MOVE 'C' TO LINK-ARRANGEMENT-FL
           END-IF.                         
           IF LINK-STD-CHG-AMT   NOT NUMERIC                            
               MOVE '0.00' TO LINK-STD-CHG-AMT
           END-IF.                         
           IF LINK-EST-LABOR-HRS NOT NUMERIC                            
               MOVE '0.00' TO LINK-EST-LABOR-HRS
           END-IF.                       
           IF LINK-DEPOSIT-AMT NOT NUMERIC                              
               MOVE '0.00' TO LINK-DEPOSIT-AMT
           END-IF.                         
           IF LINK-NOTIFY-CSR = 'N'                                     
               MOVE SPACES TO LINK-NOTIFY-CSR
           END-IF.                          
           IF LINK-NOTIFY-CUSTOMER = 'N'                                
               MOVE SPACES TO LINK-NOTIFY-CUSTOMER
           END-IF.                     
           IF LINK-PHONE-NO-EXT = ZEROES                                
               MOVE SPACES TO LINK-PHONE-NO-EXT
           END-IF.                        
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE LINK-ORDER-TYPE-CD TO S-ORDER-TYPE-CD                   
                                      C2-ORDER-TYPE-CD.                 
           MOVE 'N' TO LINK-REORDER-FLAG.                               
                                                                        
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE '0000000000' TO LINK-PREMISE-NO
           END-IF.                    
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO                      
                                     VO-PREMISE-NO.                     
                                                                        
           MOVE LINK-WANTED-BY-DATE TO WS-LINK-SCHEDULED-DT.            
           MOVE 'N' TO WS-UNBLOCK-GAS-FL                                
                       WS-UNBLOCK-FL                                    
                       WS-APPLIANCE-FL                                  
                       WS-SEASONAL-APP-FL                               
                       WS-COMBO-DIST-LO-FL                              
                       WS-GAS-WORK-AREA-FL.                             
           MOVE LINK-NOTIFY-CSR TO WS-NOTIFY-CSR-FL.                    
           MOVE LINK-SPCL-READ-INST TO WS-SPCL-READ-INST.               
           MOVE LINK-SPCL-INST TO WS-SPCL-INST.                         
           MOVE LINK-PREM-DIRECTIONS TO WS-PREM-DIRECTIONS.             
           MOVE LINK-SCRATCHPAD TO WS-SCRATCHPAD.                       
           MOVE LINK-APPLIANCE-PARMS TO WS-APPLIANCE-PARM.              
           MOVE WS-APPLIANCE-PARM-TEXT TO T2-APPLIANCE-LINE.            
           MOVE LINK-UTILITY-PARMS TO WS-UTILITY-PARM.                  
           MOVE WS-UTILITY-PARM-TEXT TO T4-UTILITY-LINE.                
                                                                        
           IF LINK-WORK-TYPE-CD = ' '                                   
               MOVE +200 TO S-STATUS-CODE
           END-IF.                              
           IF LINK-ORDER-TYPE-CD  <= SPACES                             
               MOVE +300 TO S-STATUS-CODE
           END-IF.                              
                                                                        
           IF S-STATUS-CODE NOT = 0                                     
               GO TO 1000-EXIT
           END-IF.                                         
                                                                        
           MOVE 'Y' TO WS-NEW-ORDER-FL.                                 
DT9687     IF LINK-SERV-ORDER-NO > SPACES AND                           
DT9687        LINK-SERV-ORDER-NO NOT = '0000000000000'                  
DT9687         MOVE 'N' TO WS-NEW-ORDER-FL                              
DT9687         MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-CHAR         
DT9687         MOVE WS-SERV-ORDER-NO-NUM TO VO-SERV-ORDER-NO            
D12609                                      VI-SERV-ORDER-NO            
DT9687     END-IF.                                                      
           PERFORM 7180-GET-RESP-AREA THRU 7180-EXIT.                   
           PERFORM 1100-FORMAT-TRANS-HIST THRU 1100-EXIT.               
           PERFORM 7100-SELECT-PREMISE THRU 7100-EXIT.                  
           PERFORM 7210-GET-LOCAL-OFFICE THRU 7210-EXIT.                
           PERFORM 7220-GET-ZIP-CODE THRU 7220-EXIT.                    
           PERFORM 7760-GET-ORDER-TYPE-INFO THRU 7760-EXIT.             
           IF AT-ACCOUNT-NO > 0                                         
              PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT                
           END-IF.                                                      
           PERFORM 3100-CALL-CSR02210 THRU 3100-EXIT                    
           PERFORM 3300A-GET-IC-DETAILS  THRU  3300A-EXIT               
           IF LINK-PANEL-NO = 'SST'                                     
              PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                
SCA006            T1-INDEX > 20 OR 
SCA006            WS-POINT-ID > SPACES OR 
                  T1-TABLE-ID (T1-INDEX) <= SPACES                              
                     IF T1-MN-POINT-ID (T1-INDEX) > SPACES              
                         MOVE T1-MN-POINT-ID (T1-INDEX) TO WS-POINT-ID  
                         MOVE T1-UT-READ-ROUTE (T1-INDEX) TO            
                                                    WS-READ-ROUTE       
                     END-IF                                             
              END-PERFORM                                               
              IF WS-POINT-ID = SPACES                                   
                  MOVE T1-UT-READ-ROUTE (1) TO WS-READ-ROUTE            
              END-IF                                                    
              PERFORM 3200-CALL-CSR01116 THRU 3200-EXIT                 
           END-IF                                                       
           IF WS-NEW-ORDER-FL = 'N'                                     
D12609       PERFORM 3680-CALL-CSR01105 THRU 3680-EXIT                  
D12609       PERFORM 7240-GET-SO-ORDER-INST THRU 7240-EXIT              
DT9687*    CHECK FOR CLICK PRIOR TO UPDATE                                      
             PERFORM 7230-GET-SO-DATA THRU 7230-EXIT                    
             IF WS-ORIG-ORDER-TYPE-CD NOT = LINK-ORDER-TYPE-CD          
                MOVE 'Y' TO WS-ORDER-TYPE-CHGD                          
             END-IF                                                     
             PERFORM 5420-CHECK-CLICK THRU 5420-EXIT                    
             IF WORK-DISTRICT-OUT-4747 >  SPACES                        
                MOVE 'Y' TO WS-IS-CLICK-PRIOR                           
             ELSE                                                       
                MOVE VO-WORK-AREA-ID  TO C4-WORK-AREA-ID                
                PERFORM 5430-CHECK-CAD THRU 5430-EXIT                   
                IF WS-IS-CAD = 'Y'                                      
                   MOVE  'Y' TO WS-IS-CAD-PRIOR                         
                END-IF                                                  
             END-IF                                                     
           END-IF                                                       
                                                                        
           PERFORM 4000-ADD-ORDER THRU 4000-EXIT.                       
                                                                        
D10675*    IF LINK-ASSIGNED-DATETIME(1:10) = WS-CURRENT-DATE AND                
D10675*       LINK-ORDER-STATE-CD = 'A' AND                                     
D10675*       LINK-BACK-DATED-IND NOT = 'Y'                                     
D10675*           PERFORM 4300-CALL-CSR01334 THRU 4300-EXIT                     
D10675*           MOVE LINK-PANEL-NO TO VW-PANEL-NO                             
D10675*           PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                 
                                                                        
           PERFORM 5170-CALL-CSR01110 THRU 5170-EXIT                    
           IF LINK-ASSIGNED-DATETIME(1:10) = WS-CURRENT-DATE AND        
              LINK-ORDER-STATE-CD = 'A' AND                             
              (SERV-ORDER-STATUS-1110 = '10' OR                         
D10675         WS-ORDER-TYPE-CHGD = 'Y')                                
                IF LINK-BACK-DATED-IND NOT = 'Y'                        
                   PERFORM 4300-CALL-CSR01334 THRU 4300-EXIT            
A04670*         MOVE LINK-PANEL-NO TO VW-PANEL-NO                               
P00795*         PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                   
D10675*         MOVE 'YC' TO WS-UPDATE-STATUS-0092                              
                   PERFORM 5160-CALL-CSR00092  THRU 5160-EXIT           
                END-IF                                                  
           END-IF                                                       
           PERFORM 8500-UPDATE-ORDER THRU 8500-EXIT.                    
           PERFORM 5140-CALL-CSR02120 THRU 5140-EXIT.                   
                                                                        
DT9687     IF WS-NEW-ORDER-FL = 'N'                                     
DT9687        PERFORM 4600-WRITE-CHANGE-LOG THRU 4600-EXIT              
DT9687**  CHECK FOR CLICK AFTER ORDER UPDATE                                    
D10563*       PERFORM 5420-CHECK-CLICK THRU 5420-EXIT                           
D10563*       IF WORK-DISTRICT-OUT-4747 > SPACES                                
D10563*         MOVE 'Y' TO WS-IS-CLICK-CURR                                    
D01563*       ELSE                                                              
              MOVE LINK-CLICK-ORDER-CODE TO WS-IS-CLICK-CURR            
              IF WS-IS-CLICK-CURR = 'N'                                 
                MOVE LINK-WORK-AREA-ID TO C4-WORK-AREA-ID               
                PERFORM 5430-CHECK-CAD THRU 5430-EXIT                   
                IF WS-IS-CAD = 'Y'                                      
                   MOVE  'Y' TO WS-IS-CAD-CURR                          
                END-IF                                                  
              ELSE                                                      
                PERFORM 7762-GET-ORDER-WK-TYPE-INFO THRU 7762-EXIT      
                IF L3-COMPLIANCE-DAYS-NO > 0                            
                    MOVE 'Y' TO WS-IS-CLICK-CURR                        
                END-IF                                                  
              END-IF                                                    
              IF LINK-BACK-DATED-IND NOT= 'Y'                           
                 PERFORM 4500-CLICK-CAD-UPDATE THRU 4500-EXIT           
              END-IF                                                    
DT9687     END-IF                                                       
                                                                        
           IF LINK-CDP(12:1) = 'A'                                      
               PERFORM 8810-UPDATE-APPL-CDP THRU 8810-EXIT
           END-IF.             
           IF LINK-SO-REMARKS > ' '                                     
               MOVE 'G' TO EF-REMARK-TYPE-CD                            
               MOVE LINK-SO-REMARKS TO EF-REMARK-TX-TEXT                
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT
           END-IF.              
           IF LINK-HOLD-REMARKS > ' '                                   
               MOVE 'H' TO EF-REMARK-TYPE-CD                            
               MOVE LINK-HOLD-REMARKS TO EF-REMARK-TX-TEXT              
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT
           END-IF.              
           IF LINK-OVERRIDE-REMARKS > ' '                               
               MOVE 'O' TO EF-REMARK-TYPE-CD                            
               MOVE LINK-OVERRIDE-REMARKS TO EF-REMARK-TX-TEXT          
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT
           END-IF.              
           IF LINK-CHANGE-REMARKS > ' '                                 
               MOVE 'E' TO EF-REMARK-TYPE-CD                            
               MOVE LINK-CHANGE-REMARKS TO EF-REMARK-TX-TEXT            
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT
           END-IF.              
           IF WS-SPCL-READ-INST-LEN > 0 OR                              
              WS-SPCL-INST-LEN > 0 OR                                   
              WS-PREM-DIRECTIONS-LEN > 0 OR                             
              WS-SCRATCHPAD-LEN > 0                                     
                  PERFORM 4400-CALL-CSR02059 THRU 4400-EXIT
           END-IF.            
           IF LINK-COMM-COMMENTS > ' '                                  
               PERFORM 5090-CALL-CSR02517 THRU 5090-EXIT
           END-IF.               
P0795A     PERFORM 4170-GET-APPLIANCES THRU 4170-EXIT.                  
P0795A*                                                                         
P0795A     PERFORM VARYING T4-INDEX FROM 1 BY 1                         
P0795A        UNTIL T4-INDEX > 50 OR T4-CODE-UTIL-TYPE (T4-INDEX) <= ' '
P0795A             PERFORM 3210-UPDATE-RATE-REVENUE THRU 3210-EXIT      
P0795A     END-PERFORM.                                                 
                                                                        
           IF LINK-BACK-DATED-IND = 'Y'                                 
               PERFORM 8000-FRO-REQUIREMENTS THRU 8000-EXIT             
           ELSE                                                         
               IF WS-NEW-ORDER-FL   NOT= 'Y'  AND                       
                 ((LINK-ASSIGNED-DATETIME(1:10)  NOT =                  
                           VO-ASSIGNED-DATETIME(1:10)  AND              
                  VO-ASSIGNED-DATETIME(1:10) <= WS-CURRENT-DATE AND     
                  LINK-ASSIGNED-DATETIME(1:10) >  WS-CURRENT-DATE) OR   
                  WS-ORDER-TYPE-CHGD    = 'Y')                          
                   PERFORM 5470-CALL-CSR00413    THRU 5470-EXIT         
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FORMAT-TRANS-HIST.                                          
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
MAINTN*    MOVE LINK-ORDER-RECVED-BY        TO MH-USER-ID.              11640000
           MOVE LINK-USER-ID                TO MH-USER-ID.              
           MOVE 'CSR04754'                  TO MH-APPL-PROGRAM-ID.      
           MOVE 0                           TO MH-TRAN-COMMENT-LEN      
           MOVE SPACES                      TO MH-TRAN-COMMENT-TEXT.    
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE.            
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       3100-CALL-CSR02210.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-2210.                     
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2210.                     
           MOVE PR-COMPANY-NO TO COMPANY-NO-2210.                       
           MOVE 'N' TO MKTG-ORDER-2210.                                 
           MOVE 'Y' TO RETURN-UTILS-2210.                               
           MOVE 'N' TO RETURN-DISC-BAL-2210.                            
           MOVE ' ' TO ORDER-REASON-2210.                               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02210                                             
      *           (:ACCOUNT-NO-2210,                                    
      *            :PREMISE-NO-2210,                                    
      *            :COMPANY-NO-2210,                                    
      *            :MKTG-ORDER-2210,                                    
      *            :RETURN-UTILS-2210,                                  
      *            :RETURN-DISC-BAL-2210,                               
      *            :ORDER-REASON-2210)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2210 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02210'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2210)                                                
      *       WITH PROCEDURE CSR02210                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2210 CURSOR FOR RESULT SET        
      *       :LOC2210                                                  
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y' TO SW-FETCH.                                        
           SET T1-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2210 INTO                          
                   :RETURN-CODE-2210,                                   
                   :ACTIVE-PARA-2210,                                   
                   :TABLE-NAME-2210,                                    
                   :TABLE-ID-2210,                                      
                   :UT-CODE-UTIL-TY-2210,                               
                   :UT-IC-NO-2210,                                      
                   :UT-READ-ROUTE-2210,                                 
                   :UT-RATE-PLAN-NO-2210,                               
                   :UT-RATE-DESC-2210,                                  
                   :UT-CODE-REV-CLA-2210,                               
                   :UT-READ-CYCLE-2210,                                 
                   :UT-CODE-SIC-NO-2210,                                
                   :MN-METER-NO-2210,                                   
                   :MN-MTR-REF-NO-2210,                                 
                   :MN-CODE-TIME-PE-2210,                               
                   :MN-LAST-READ-VA-2210,                               
                   :MN-CD-STUS-RS-2210,                                 
                   :MN-CODE-USAGE-T-2210,                               
                   :MN-CODE-USAGE-I-2210,                               
                   :MN-CODE-USAGE-S-2210,                               
                   :MN-CODE-METER-S-2210,                               
                   :MN-METER-SUPPLY-2210,                               
                   :MN-CODE-METER-L-2210,                               
                   :MN-METER-LOC-DE-2210,                               
                   :MN-METER-IND-2210,                                  
                   :MN-CONSTANT-2210,                                   
                   :MN-NO-DIALS-2210,                                   
                   :MN-DIST-NODE-PO-2210,                               
                   :MN-POINT-ID-2210,                                   
                   :MN-SEAL-CODE-ID-2210,                               
                   :MN-HEX-LOCATION-2210,                               
                   :MN-INSULATED-IN-2210,                               
                   :MN-LOCK-TYPE-ID-2210,                               
                   :MN-DELIVERY-LEV-2210,                               
                   :MN-UTILITY-SOUR-2210,                               
                   :MN-IDR-RECIPIEN-2210,                               
                   :MN-PROGRAM-ID-2210,                                 
                   :MN-MTR-READ-SO-2210,                                
                   :RG-CODE-REG-ST-2210,                                
                   :RG-CODE-STATUS-2210,                                
                   :RG-CODE-TIME-P-2210,                                
                   :RG-CODE-USAGE-2210,                                 
                   :RG-CD-USG-SRC-2210,                                 
                   :RG-CD-USG-TYP-2210,                                 
                   :RG-LAST-READD-2210,                                 
                   :RG-LST-READVL-2210,                                 
                   :RG-REG-ID-NO-2210,                                  
                   :CP-NO-UNITS-2210,                                   
                   :CP-CODE-PLAN-2210,                                  
                   :CP-CD-STATRS-2210,                                  
                   :CP-CD-SVC-TYP-2210,                                 
                   :CP-MTLY-AMT-FX-2210,                                
                   :CP-RT-ITEM-CD-2210,                                 
                   :CP-LIGHT-NO-2210,                                   
                   :CP-POLE-NO-2210,                                    
                   :CP-DIST-NO-2210,                                    
                   :CP-USAGE-FIXED-2210,                                
                   :CP-ITEM-SEQ-NO-2210,                                
                   :CP-EQUIP-ID-2210,                                   
                   :PREM-DIR-IND-2210,                                  
                   :SUBDIV-LIGHT-2210,                                  
                   :ACCT-TYPE-2210,                                     
                   :CD-RNTL-PROP-2210,                                  
                   :LL-CUSTOMER-NO-2210,                                
                   :REV-DIST-CD-2210,                                   
                   :DISC-BAL-2210,                                      
                   :OUT-ACCOUNT-NO-2210,                                
                   :ACCT-STATUS-2210,                                   
                   :ROW-NO-2210,                                        
                   :DEPOSIT-AMT-2210,                                   
                   :SEC-TOT-AMT-2210,                                   
                   :CUR-MTH-ARR-CD-2210,                                
                   :CREDIT-GROUP-2210,                                  
                   :CURRENT-ACCOUNT-2210,                               
                   :DATE-BNKRPT-FL-2210,                                
                   :FILED-CASE-NO-2210,                                 
                   :DL-NO-2210,                                         
                   :DL-STATE-2210,                                      
                   :SSN-2210,                                           
                   :PRIOR-ACCT-STAT-2210,                               
                   :READ-CYCLE-2210,                                    
                   :SERV-STRT-DT-2210,                                  
                   :DEP-INTST-RT-2210,                                  
                   :CP-DT-PLN-ST-2210,                                  
                   :ACTIVE-CONTRACT-2210,                               
                   :SECURED-RATE-FL-2210,                               
                   :MN-CODE-MTR-RD-2210,                                
                   :MN-MTR-PRESS-2210,                                  
                   :ERROR-MSG-NO-02-2210,                               
                   :ERROR-MSG-NO-A4-2210                                
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-2210 NOT = 0 AND                    
                        RETURN-CODE-2210 NOT = 100                      
                         MOVE RETURN-CODE-2210  TO                      
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '3100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR02210'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE LINK-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1    
                         MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-2      
                         MOVE LINK-PREMISE-NO   TO HOSTVAR-ELEMENT-2    
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                     END-IF                                             
PRDFX2               IF TABLE-ID-2210 NOT = 'CP'                        
P0795A                PERFORM 3110-LOAD-CSR02210-TABLE THRU 3110-EXIT   
PRDFX2               END-IF                                             
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02210'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3110-LOAD-CSR02210-TABLE.                                        
                                                                        
           MOVE TABLE-ID-2210 TO T1-TABLE-ID (T1-INDEX).                
           MOVE MN-CODE-METER-S-2210 TO T1-MN-CODE-METER-S (T1-INDEX).  
           MOVE UT-CODE-UTIL-TY-2210 TO T1-UT-CODE-UTIL-TYPE (T1-INDEX).
           MOVE UT-IC-NO-2210 TO T1-UT-IC-NO (T1-INDEX).                
           MOVE UT-READ-ROUTE-2210 TO T1-UT-READ-ROUTE (T1-INDEX).      
           MOVE UT-RATE-PLAN-NO-2210 TO T1-UT-RATE-PLAN-NO (T1-INDEX).  
           MOVE UT-RATE-DESC-2210 TO T1-UT-RATE-DESC (T1-INDEX).        
           MOVE UT-CODE-REV-CLA-2210 TO                                 
                T1-UT-CODE-REV-CLASS (T1-INDEX).                        
           MOVE UT-READ-CYCLE-2210 TO T1-UT-READ-CYCLE (T1-INDEX).      
           MOVE UT-CODE-SIC-NO-2210 TO T1-UT-CODE-SIC-NO (T1-INDEX).    
           MOVE MN-METER-NO-2210 TO T1-MN-METER-NO (T1-INDEX).          
           MOVE MN-MTR-REF-NO-2210 TO T1-MN-MTR-REF-NO (T1-INDEX).      
           MOVE MN-CODE-TIME-PE-2210 TO T1-MN-CODE-TIME-PER (T1-INDEX). 
           MOVE MN-LAST-READ-VA-2210 TO T1-MN-LAST-READ-VAL (T1-INDEX). 
           MOVE MN-CD-STUS-RS-2210 TO T1-MN-CD-STAT-REAS (T1-INDEX).    
           MOVE MN-CODE-USAGE-T-2210 TO T1-MN-CODE-USAGE-T (T1-INDEX).  
           MOVE MN-CODE-USAGE-I-2210 TO T1-MN-CODE-USAGE-I (T1-INDEX).  
           MOVE MN-CODE-USAGE-S-2210 TO T1-MN-CODE-USAGE-S (T1-INDEX).  
           MOVE MN-CODE-METER-S-2210 TO T1-MN-CODE-METER-S (T1-INDEX).  
           MOVE MN-METER-SUPPLY-2210 TO T1-MN-METER-SUPPLY (T1-INDEX).  
           MOVE MN-CODE-METER-L-2210 TO                                 
                T1-MN-CODE-METER-LOC (T1-INDEX).                        
           MOVE MN-METER-LOC-DE-2210 TO                                 
                T1-MN-METER-LOC-DESC (T1-INDEX).                        
           MOVE MN-METER-IND-2210 TO T1-MN-METER-IND (T1-INDEX).        
           MOVE MN-CONSTANT-2210 TO T1-MN-CONSTANT (T1-INDEX).          
           MOVE MN-NO-DIALS-2210 TO T1-MN-NO-DIALS (T1-INDEX).          
           MOVE MN-DIST-NODE-PO-2210 TO                                 
                T1-MN-DIST-NODE-PO (T1-INDEX).                          
           MOVE MN-POINT-ID-2210 TO T1-MN-POINT-ID (T1-INDEX).          
           MOVE MN-SEAL-CODE-ID-2210 TO T1-MN-SEAL-CODE-ID (T1-INDEX).  
           MOVE MN-HEX-LOCATION-2210 TO T1-MN-HEX-LOCATION (T1-INDEX).  
           MOVE MN-INSULATED-IN-2210 TO T1-MN-INSULATED-IND (T1-INDEX). 
           MOVE MN-LOCK-TYPE-ID-2210 TO T1-MN-LOCK-TYPE-ID (T1-INDEX).  
           MOVE MN-DELIVERY-LEV-2210 TO T1-MN-DELIVERY-LEV (T1-INDEX).  
           MOVE MN-UTILITY-SOUR-2210 TO                                 
                T1-MN-UTILITY-SOURCE (T1-INDEX).                        
           MOVE MN-IDR-RECIPIEN-2210 TO T1-MN-IDR-RECIPIENT (T1-INDEX). 
           MOVE MN-PROGRAM-ID-2210 TO T1-MN-PROGRAM-ID (T1-INDEX).      
           MOVE MN-MTR-READ-SO-2210 TO                                  
                T1-MN-MTR-READ-SOURCE (T1-INDEX).                       
           MOVE RG-LAST-READD-2210 TO T1-RG-LAST-READD (T1-INDEX).      
           MOVE RG-REG-ID-NO-2210 TO T1-RG-REG-ID-NO (T1-INDEX).        
           MOVE CP-NO-UNITS-2210 TO T1-CP-NO-UNITS (T1-INDEX).          
           MOVE CP-CODE-PLAN-2210 TO T1-CP-CODE-PLAN (T1-INDEX).        
           MOVE CP-CD-STATRS-2210 TO T1-CP-CD-STAT-REAS (T1-INDEX).     
           MOVE CP-CD-SVC-TYP-2210 TO T1-CP-CD-SVC-TYPE (T1-INDEX).     
           MOVE CP-MTLY-AMT-FX-2210 TO T1-CP-MTHLY-AMT (T1-INDEX).      
           MOVE CP-RT-ITEM-CD-2210 TO T1-CP-RT-ITEM-CD (T1-INDEX).      
           MOVE CP-LIGHT-NO-2210 TO T1-CP-LIGHT-NO (T1-INDEX).          
           MOVE CP-POLE-NO-2210 TO T1-CP-POLE-NO (T1-INDEX).            
           MOVE CP-DIST-NO-2210 TO T1-CP-DIST-NO (T1-INDEX).            
           MOVE CP-USAGE-FIXED-2210 TO T1-CP-USAGE-FIXED (T1-INDEX).    
           MOVE CP-ITEM-SEQ-NO-2210 TO T1-CP-ITEM-SEQ-NO (T1-INDEX).    
           MOVE CP-EQUIP-ID-2210 TO T1-CP-EQUIP-ID (T1-INDEX).          
           MOVE PREM-DIR-IND-2210 TO T1-PREM-DIR-IND (T1-INDEX).        
           MOVE SUBDIV-LIGHT-2210 TO T1-SUBDIV-LIGHT (T1-INDEX).        
           MOVE ACCT-TYPE-2210 TO T1-ACCT-TYPE-CODE (T1-INDEX).         
           MOVE CD-RNTL-PROP-2210 TO T1-CD-RENTAL-PROP (T1-INDEX).      
           MOVE LL-CUSTOMER-NO-2210 TO T1-LL-CUSTOMER-NO (T1-INDEX).    
           MOVE REV-DIST-CD-2210 TO T1-REV-DISTRICT-CD (T1-INDEX).      
           MOVE DISC-BAL-2210 TO T1-DISC-BAL (T1-INDEX).                
           MOVE OUT-ACCOUNT-NO-2210 TO T1-OUT-ACCOUNT-NO (T1-INDEX).    
           MOVE ACCT-STATUS-2210 TO T1-ACCT-STATUS (T1-INDEX).          
           MOVE ROW-NO-2210 TO T1-ROW-NO (T1-INDEX).                    
           MOVE DEPOSIT-AMT-2210 TO T1-DEPOSIT-AMT (T1-INDEX).          
           MOVE SEC-TOT-AMT-2210 TO T1-SEC-TOT-AMT (T1-INDEX).          
           MOVE CUR-MTH-ARR-CD-2210 TO T1-CUR-MTH-ARR-CD (T1-INDEX).    
           MOVE CREDIT-GROUP-2210 TO T1-CREDIT-GROUP (T1-INDEX).        
           MOVE CURRENT-ACCOUNT-2210 TO T1-CURRENT-ACCOUNT (T1-INDEX).  
           MOVE DATE-BNKRPT-FL-2210 TO T1-DATE-BANKRUPT (T1-INDEX).     
           MOVE FILED-CASE-NO-2210 TO T1-FILED-CASE-NO (T1-INDEX).      
           MOVE DL-NO-2210 TO T1-DL-NO (T1-INDEX).                      
           MOVE DL-STATE-2210 TO T1-DL-STATE (T1-INDEX).                
           MOVE SSN-2210 TO T1-SSN (T1-INDEX).                          
           MOVE PRIOR-ACCT-STAT-2210 TO T1-PRIOR-ACCT-STAT (T1-INDEX).  
           MOVE READ-CYCLE-2210 TO T1-READ-CYCLE (T1-INDEX).            
           MOVE SERV-STRT-DT-2210 TO T1-SERV-STRT-DT (T1-INDEX).        
           MOVE DEP-INTST-RT-2210 TO T1-DEP-INTST-RT (T1-INDEX).        
           MOVE CP-DT-PLN-ST-2210 TO T1-CP-DT-PLAN-ST (T1-INDEX).       
           MOVE ACTIVE-CONTRACT-2210 TO T1-ACTIVE-CONTRACT (T1-INDEX).  
           MOVE SECURED-RATE-FL-2210 TO T1-SECURED-RATE-FL (T1-INDEX).  
           MOVE MN-CODE-MTR-RD-2210 TO T1-MN-CODE-MTR-RD (T1-INDEX).    
           MOVE MN-MTR-PRESS-2210 TO T1-MN-MTR-PRESS (T1-INDEX).        
           MOVE SPACES TO T1-WORK-TYPE-CD (T1-INDEX)                    
                          T1-RLSE-REQUIRED (T1-INDEX)                   
                          T1-RLSE-NO (T1-INDEX)                         
                          T1-RLSE-DATE (T1-INDEX).                      
P0795A*    IF T1-TABLE-ID (T1-INDEX) = 'UT'                                     
P0795A*       PERFORM 3300-CALL-CSR02046  THRU 3300-EXIT                        
P0795A*    END-IF.                                                              
           SET T1-INDEX UP BY 1.                                        
                                                                        
       3110-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3200-CALL-CSR01116.                                              
                                                                        
           MOVE PR-LOCAL-OFFICE TO LOCAL-OFFICE-1116.                   
           MOVE LINK-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-1116.             
           MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-1116.                 
           MOVE 'N' TO CRAWL-IND-1116.                                  
           MOVE 'N' TO METER-IND-1116.                                  
           MOVE DY-ZIP-CODE TO ZIP-CODE-1116.                           
           MOVE WS-READ-ROUTE-CHAR TO READ-ROUTE-1116.                  
           MOVE WS-POINT-ID TO POINT-ID-1116.                           
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01116                                             
      *           (:LOCAL-OFFICE-1116,                                  
      *            :CODE-UTIL-TYPE-1116,                                
      *            :WORK-TYPE-CD-1116,                                  
      *            :CRAWL-IND-1116,                                     
      *            :METER-IND-1116,                                     
      *            :ZIP-CODE-1116,                                      
      *            :READ-ROUTE-1116,                                    
      *            :POINT-ID-1116)                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1116 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01116'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1116)                                                
      *       WITH PROCEDURE CSR01116                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1116 CURSOR FOR RESULT SET        
      *       :LOC1116                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1116 INTO                            
                   :RETURN-CODE-1116,                                   
                   :WORK-AREA-1116,                                     
P00718             :BUSINESS-UNIT-1116                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                 IF RETURN-CODE-1116 NOT = 0                            
                     MOVE RETURN-CODE-1116      TO                      
                          WS-ACTIVE-RETURN-CODE                         
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR01116'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '3200'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'FETCH'                   TO ABEND-FUNCTION       
                 MOVE 'CSR01116'                TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                 MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2      
                 MOVE LINK-PREMISE-NO           TO HOSTVAR-ELEMENT-2    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
P0795A 3210-UPDATE-RATE-REVENUE.                                        
                                                                        
           PERFORM VARYING T6-INDEX FROM 1 BY 1                         
               UNTIL T6-INDEX > 100 OR                                  
                     T6-RATE-PLAN-NO (T6-INDEX) <= SPACES               
                   IF (T4-CODE-UTIL-TYPE (T4-INDEX) =                   
                         T6-CODE-UTIL-TYPE (T6-INDEX)  AND              
                      T4-IC-NO (T4-INDEX) =                             
                         T6-IC-NO (T6-INDEX)           AND              
                      (T4-RATE-PLAN-NO (T4-INDEX) NOT =                 
                         T6-RATE-PLAN-NO (T6-INDEX)    OR               
                       T4-REVENUE-CLASS (T4-INDEX) NOT =                
                          T6-CODE-REVENUE-CLASS (T6-INDEX)))            
A05317                   PERFORM 3410-CALL-CSR04642 THRU 3410-EXIT      
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
P0795A 3210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3300A-GET-IC-DETAILS.                                            
P0795A     SET T6-INDEX TO +1.                                          
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T1-INDEX > 20 OR 
               T1-TABLE-ID (T1-INDEX) <= SPACES                                 
                  IF T1-TABLE-ID (T1-INDEX) = 'UT'                      
                     PERFORM 3300-CALL-CSR02046  THRU 3300-EXIT         
                  END-IF                                                
           END-PERFORM.                                                 
       3300A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
       3300-CALL-CSR02046.                                              
                                                                        
           MOVE 'U' TO ACTION-MODE-2046                                 
           MOVE LINK-ACCOUNT-NO TO  ACCOUNT-NO-2046                     
           MOVE T1-UT-CODE-UTIL-TYPE (T1-INDEX) TO CODE-UTIL-TYPE-2046  
           MOVE T1-UT-IC-NO (T1-INDEX) TO IC-NO-2046                    
           MOVE LINK-PREMISE-NO TO  PREMISE-NO-2046                     
                                                                        
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02046                                             
      *           (:ACTION-MODE-2046                                    
      *           ,:ACCOUNT-NO-2046                                     
      *           ,:CODE-UTIL-TYPE-2046                                 
      *           ,:IC-NO-2046                                          
      *           ,:PREMISE-NO-2046)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2046
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2046
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2046 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02046'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2046)                                                
      *       WITH PROCEDURE CSR02046                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2046 CURSOR FOR RESULT SET        
      *       :LOC2046                                                  
      *    END-EXEC.                                                    
                                                                        
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2046 INTO                          
P0795A             :RETURN-CODE-2046                                    
P0795A            ,:RATE-PLAN-NO-2046                                   
P0795A            ,:CODE-REVENUE-CLASS-2046                             
P0795A            ,:CODE-SIC-NO-2046                                    
P0795A            ,:CODE-ESTIMATE-OK-2046                               
P0795A            ,:SEASONAL-USE-CODE-2046                              
P0795A            ,:CODE-SERVICE-TYPE-2046                              
P0795A            ,:CODE-MTR-READ-FREQ-2046                             
P0795A            ,:READ-CYCLE-2046                                     
P0795A            ,:READ-ROUTE-2046                                     
P0795A            ,:SPLY-SENSITIVE-IND-2046                             
P0795A            ,:ACTIVE-METERS-NO-2046                               
P0795A            ,:GAS-BASE-LAST-UPDT-2046                             
P0795A            ,:DATE-LFTM-HI-DMD-2046                               
P0795A            ,:STATE-TAX-EXMPT-NO-2046                             
P0795A            ,:CODE-STAT-TAX-XMT-2046                              
P0795A            ,:CODE-CITY-TAX-XMT-2046                              
P0795A            ,:ACTIVE-PLANS-IND-2046                               
P0795A            ,:MULTIPLE-ICPS-IND-2046                              
P0795A            ,:MULTI-GAS-ELE-IND-2046                              
P0795A            ,:GAS-BASE-USE-2046                                   
P0795A            ,:LFTM-HI-PEAK-DMD-2046                               
P0795A            ,:LFTM-HI-DMD-UNITS-2046                              
P0795A            ,:ENERGY-PERIODS-2046                                 
P0795A            ,:DEMAND-PERIODS-2046                                 
P0795A            ,:CODE-UTIL-TYPE1-2046                                
P0795A            ,:IC-NO1-2046                                         
P0795A            ,:READ-METERS-IND-2046                                
P0795A            ,:FIXED-FACTORS-IND-2046                              
P0795A            ,:BILL-CONTRACT-IND-2046                              
P0795A            ,:INTERRUPT-ACCT-IND-2046                             
P0795A            ,:EPP-ACCOUNT-IND-2046                                
P0795A            ,:SERV-ORD-PEND-IND-2046                              
P0795A            ,:LOCAL-OFFICE-2046                                   
P0795A            ,:COMPANY-NO-2046                                     
P0795A            ,:REV-DISTRICT-CD-2046                                
P0795A            ,:ENABLE-PEAK-IND-2046                                
P0795A            ,:PERSONAL-CNTCT-CD-2046                              
P0795A            ,:BILL-CYCLE-2046                                     
P0795A            ,:ZERO-USE-INVEST-DT-2046                             
P0795A            ,:ACCT-ON-BANK-DRAFT-2046                             
P0795A            ,:DUMMY1                                              
P0795A            ,:PRTY-SVC-CAT-CD-2046                                
P0795A            ,:ALT-FUEL-CD-2046                                    
P0795A            ,:INDUS-GAS-CUST-2046                                 
P0795A            ,:BASE-USE-IND-2046                                   
P0795A            ,:SUBDVSN-LIGHT-IND-2046                              
P0795A            ,:NAICS-CD-2046                                       
P0795A            ,:ACCT-TYPE-2046                                      
P0795A            ,:ACCT-SUB-TYPE-2046                                  
P0795A            ,:RATE-PKG-OPTION-2046                                
P0795A            ,:COD-MTR-RD-FRQ-IND                                  
P0795A            ,:COD-MTR-RD-FRQ-MON                                  
P0795A            ,:DATE-LFT-HI-DMD-PB                                  
P0795A            ,:ZERO-USE-INS-DT-PB                                  
P0795A            ,:RT-PKG-EXPIRE-FLAG-2046                             
P0795A            ,:AGL-SENIOR-FLAG-2046                                
P0795A            ,:OPTION-CD-2046                                      
P0795A            ,:GROUP-CD-2046                                       
P0795A            ,:PEND-OPTION-FL-2046                                 
P0795A            ,:CURR-OPT-DESC-INT-2046                              
P0795A            ,:PEND-OPT-DESC-INT-2046                              
P0795A            ,:LAST-DRAFT-DATE-2046                                
P0795A            ,:DRAFT-CYCLE-2046                                    
P0795A            ,:DRAFT-DATE-2046                                     
P0795A            ,:ADJUSTABLE-OPTION-FLAG-2046                         
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                 WHEN +354                                              
                    IF RETURN-CODE-2046 NOT = 0 AND                     
                       RETURN-CODE-2046 NOT = +100 AND                  
                       RETURN-CODE-2046 NOT = +354                      
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '3300'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR02046'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE LINK-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1    
                         MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-2      
                         MOVE LINK-PREMISE-NO   TO HOSTVAR-ELEMENT-2    
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                     END-IF                                             
                    IF RETURN-CODE-2046 = +100                          
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                     PERFORM 3310-LOAD-CSR02046-TABLE THRU 3310-EXIT    
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3300'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02046'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE.                                              
                                                                        
       3300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3310-LOAD-CSR02046-TABLE.                                        
                                                                        
P0795A     MOVE RETURN-CODE-2046 TO T6-RETURN-CODE (T6-INDEX)           
P0795A     MOVE RATE-PLAN-NO-2046 TO T6-RATE-PLAN-NO (T6-INDEX)         
P0795A     MOVE CODE-REVENUE-CLASS-2046 TO                              
P0795A                             T6-CODE-REVENUE-CLASS (T6-INDEX)     
P0795A     MOVE CODE-SIC-NO-2046 TO T6-CODE-SIC-NO (T6-INDEX)           
P0795A     MOVE CODE-ESTIMATE-OK-2046 TO T6-CODE-ESTIMATE-OK (T6-INDEX) 
P0795A     MOVE SEASONAL-USE-CODE-2046 TO                               
P0795A                                 T6-SEASONAL-USE-CODE (T6-INDEX)  
P0795A     MOVE CODE-MTR-READ-FREQ-2046 TO                              
P0795A                              T6-CODE-MTR-READ-FREQ (T6-INDEX)    
P0795A     MOVE CODE-SERVICE-TYPE-2046 TO                               
P0795A                          T6-CODE-SERVICE-TYPE (T6-INDEX)         
P0795A     MOVE READ-CYCLE-2046 TO T6-READ-CYCLE (T6-INDEX)             
P0795A     MOVE READ-ROUTE-2046 TO T6-READ-ROUTE (T6-INDEX)             
P0795A     MOVE SPLY-SENSITIVE-IND-2046 TO                              
P0795A                        T6-SPLY-SENSITIVE-IND (T6-INDEX)          
P0795A     MOVE ACTIVE-METERS-NO-2046 TO T6-ACTIVE-METERS-NO (T6-INDEX) 
P0795A     MOVE GAS-BASE-LAST-UPDT-2046 TO                              
P0795A                            T6-GAS-BASE-LAST-UPDT (T6-INDEX)      
P0795A     MOVE DATE-LFTM-HI-DMD-2046 TO T6-DATE-LFTM-HI-DMD (T6-INDEX) 
P0795A     MOVE STATE-TAX-EXMPT-NO-2046 TO                              
P0795A                            T6-STATE-TAX-EXMPT-NO (T6-INDEX)      
P0795A     MOVE CODE-STAT-TAX-XMT-2046 TO                               
P0795A                            T6-CODE-CITY-TAX-XMT (T6-INDEX)       
P0795A     MOVE ACTIVE-PLANS-IND-2046 TO T6-ACTIVE-PLANS-IND (T6-INDEX) 
P0795A     MOVE MULTIPLE-ICPS-IND-2046 TO                               
P0795A                           T6-MULTIPLE-ICPS-IND (T6-INDEX)        
P0795A     MOVE MULTI-GAS-ELE-IND-2046 TO                               
P0795A                           T6-MULTI-GAS-ELE-IND (T6-INDEX)        
P0795A     MOVE GAS-BASE-USE-2046 TO T6-GAS-BASE-USE (T6-INDEX)         
P0795A     MOVE LFTM-HI-PEAK-DMD-2046 TO T6-LFTM-HI-PEAK-DMD (T6-INDEX) 
P0795A     MOVE LFTM-HI-DMD-UNITS-2046 TO                               
P0795A                            T6-LFTM-HI-DMD-UNITS (T6-INDEX)       
P0795A     MOVE ENERGY-PERIODS-2046 TO T6-ENERGY-PERIODS (T6-INDEX)     
P0795A     MOVE DEMAND-PERIODS-2046 TO T6-DEMAND-PERIODS (T6-INDEX)     
P0795A     MOVE CODE-UTIL-TYPE1-2046 TO T6-CODE-UTIL-TYPE (T6-INDEX)    
P0795A     MOVE IC-NO1-2046 TO T6-IC-NO (T6-INDEX)                      
P0795A     MOVE READ-METERS-IND-2046 TO T6-READ-METERS-IND (T6-INDEX)   
P0795A     MOVE FIXED-FACTORS-IND-2046 TO                               
P0795A                           T6-FIXED-FACTORS-IND (T6-INDEX)        
P0795A     MOVE BILL-CONTRACT-IND-2046 TO                               
P0795A                              T6-BILL-CONTRACT-IND (T6-INDEX)     
P0795A     MOVE INTERRUPT-ACCT-IND-2046 TO                              
P0795A                             T6-INTERRUPT-ACCT-IND (T6-INDEX)     
P0795A     MOVE EPP-ACCOUNT-IND-2046 TO T6-EPP-ACCOUNT-IND (T6-INDEX)   
P0795A     MOVE SERV-ORD-PEND-IND-2046 TO                               
P0795A                            T6-SERV-ORD-PEND-IND (T6-INDEX)       
P0795A     MOVE LOCAL-OFFICE-2046 TO T6-LOCAL-OFFICE (T6-INDEX)         
P0795A     MOVE COMPANY-NO-2046 TO T6-COMPANY-NO (T6-INDEX)             
P0795A     MOVE REV-DISTRICT-CD-2046 TO T6-REV-DISTRICT-CD (T6-INDEX)   
P0795A     MOVE ENABLE-PEAK-IND-2046 TO T6-ENABLE-PEAK-IND (T6-INDEX)   
P0795A     MOVE PERSONAL-CNTCT-CD-2046 TO                               
P0795A                              T6-PERSONAL-CNTCT-CD (T6-INDEX)     
P0795A     MOVE BILL-CYCLE-2046 TO T6-BILL-CYCLE (T6-INDEX)             
P0795A     MOVE ZERO-USE-INVEST-DT-2046 TO                              
P0795A                               T6-ZERO-USE-INVEST-DT (T6-INDEX)   
P0795A     MOVE ACCT-ON-BANK-DRAFT-2046 TO                              
P0795A                            T6-ACCT-ON-BANK-DRAFT (T6-INDEX)      
P0795A     MOVE PRTY-SVC-CAT-CD-2046 TO T6-PRTY-SVC-CAT-CD (T6-INDEX)   
P0795A     MOVE ALT-FUEL-CD-2046 TO T6-ALT-FUEL-CD (T6-INDEX)           
P0795A     MOVE INDUS-GAS-CUST-2046 TO T6-INDUS-GAS-CUST (T6-INDEX)     
P0795A     MOVE BASE-USE-IND-2046 TO T6-BASE-USE-IND (T6-INDEX)         
P0795A     MOVE SUBDVSN-LIGHT-IND-2046 TO                               
P0795A                              T6-SUBDVSN-LIGHT-IND (T6-INDEX)     
P0795A     MOVE NAICS-CD-2046 TO T6-NAICS-CD (T6-INDEX)                 
P0795A     MOVE ACCT-TYPE-2046 TO T6-ACCT-TYPE (T6-INDEX)               
P0795A     MOVE ACCT-SUB-TYPE-2046 TO T6-ACCT-SUB-TYPE (T6-INDEX)       
P0795A     MOVE RATE-PKG-OPTION-2046 TO T6-RATE-PKG-OPTION (T6-INDEX)   
P0795A     MOVE RT-PKG-EXPIRE-FLAG-2046 TO                              
P0795A                             T6-RT-PKG-EXPIRE-FLAG (T6-INDEX)     
P0795A     MOVE AGL-SENIOR-FLAG-2046 TO T6-AGL-SENIOR-FLAG (T6-INDEX)   
P0795A     MOVE OPTION-CD-2046 TO T6-OPTION-CD (T6-INDEX)               
P0795A     MOVE GROUP-CD-2046 TO T6-GROUP-CD (T6-INDEX)                 
P0795A     MOVE PEND-OPTION-FL-2046 TO T6-PEND-OPTION-FL (T6-INDEX)     
P0795A     MOVE CURR-OPT-DESC-INT-2046 TO                               
P0795A                             T6-CURR-OPT-DESC-INT (T6-INDEX)      
P0795A     MOVE PEND-OPT-DESC-INT-2046 TO                               
P0795A                             T6-PEND-OPT-DESC-INT (T6-INDEX)      
P0795A     MOVE LAST-DRAFT-DATE-2046 TO T6-LAST-DRAFT-DATE (T6-INDEX)   
P0795A     MOVE DRAFT-CYCLE-2046 TO T6-DRAFT-CYCLE (T6-INDEX)           
P0795A     MOVE DRAFT-DATE-2046 TO T6-DRAFT-DATE (T6-INDEX)             
P0795A     MOVE ADJUSTABLE-OPTION-FLAG-2046 TO                          
P0795A                         T6-ADJUSTABLE-OPTION-FLAG (T6-INDEX)     
           SET T6-INDEX UP BY 1.                                        
                                                                        
P0795A 3310-EXIT.                                                       
P0795A      EXIT.                                                       
                                                                        
                                                                        
A05317* TO UPDATE RATE/REVENUE ON THE ACCOUNT                                   
A05317 3410-CALL-CSR04642.                                              
A05317     STRING 'PANEL' LINK-PANEL-NO                                 
A05317             DELIMITED BY SIZE INTO APPL-PGM-ID-4642              
A05317     MOVE 'U'                  TO  UPDT-ACTION-IND-4642           
A05317     MOVE LINK-USER-ID         TO  USERID-4642                    
A05317     MOVE AT-ACCOUNT-NO        TO  ACCOUNT-NO-4642                
A05317     MOVE LINK-PREMISE-NO      TO  PREMISE-NO-4642                
A05317     MOVE AT-CUSTOMER-NO       TO  WS-CUSTOMER-NO-NUM             
A05317     MOVE WS-CUSTOMER-NO-CHAR TO  CUSTOMER-NO-4642                
A05317     MOVE PR-COMPANY-NO        TO  COMPANY-NO-4642                
A05317     MOVE T6-CODE-UTIL-TYPE (T6-INDEX) TO CODE-UTIL-TYPE-4642     
A05317     MOVE T6-IC-NO (T6-INDEX)  TO  IC-NO-4642                     
A05317     MOVE T4-RATE-PLAN-NO (T4-INDEX) TO RATE-PLAN-NO-4642         
A05317     MOVE T4-REVENUE-CLASS (T4-INDEX) TO                          
A05317                                   CODE-REVENUE-CLASS-4642        
A05317     MOVE SPACES               TO  CODE-SIC-NO-4672               
A05317     MOVE T6-NAICS-CD (T6-INDEX) TO NAICS-CD-4642                 
A05317     MOVE T6-SEASONAL-USE-CODE (T6-INDEX) TO                      
A05317                                         SEASONAL-USE-CODE-4642   
A05317     IF T6-ZERO-USE-INVEST-DT (T6-INDEX) > SPACES                 
A05317        MOVE T6-ZERO-USE-INVEST-DT (T6-INDEX) TO WS-TEMP-DATE     
A05317        MOVE WS-TEMP-DATE (1:2)     TO WS-WORK-MM                 
A05317        MOVE WS-TEMP-DATE (3:2)     TO WS-WORK-DD                 
A05317        MOVE WS-TEMP-DATE (5:4)     TO WS-WORK-YYYY               
A05317        MOVE WS-WORK-DATE           TO ZERO-USE-INVEST-DT-4642    
A05317     ELSE                                                         
A05317         MOVE T6-ZERO-USE-INVEST-DT (T6-INDEX)                    
A05317                                     TO ZERO-USE-INVEST-DT-4642   
A05317     END-IF                                                       
A05317     MOVE T6-READ-CYCLE (T6-INDEX)   TO READ-CYCLE-4642           
A05317     MOVE T6-READ-ROUTE (T6-INDEX)   TO READ-ROUTE-4642           
A05317     MOVE T6-CODE-MTR-READ-FREQ (T6-INDEX)  TO                    
A05317                                CODE-MTR-READ-FREQ-4642           
A05317     MOVE SPACES TO            CODE-ESTIMATE-OK-4642              
A05317     MOVE T6-PERSONAL-CNTCT-CD (T6-INDEX) TO                      
A05317                                        PERSONAL-CNTCT-CD-4642    
A05317     MOVE T6-PRTY-SVC-CAT-CD (T6-INDEX) TO PRTY-SVC-CAT-CD-4642   
A05317     MOVE T6-ALT-FUEL-CD (T6-INDEX) TO ALTERNATE-FUEL-CD-4642     
A05317     MOVE T6-GAS-BASE-USE (T6-INDEX)    TO GAS-BASE-USE-4642      
A05317     IF T6-GAS-BASE-LAST-UPDT (T6-INDEX) > SPACES                 
A05317         MOVE T6-GAS-BASE-LAST-UPDT (T6-INDEX) TO WS-TEMP-DATE    
A05317         MOVE WS-TEMP-DATE (1:2)     TO WS-WORK-MM                
A05317         MOVE WS-TEMP-DATE (3:2)     TO WS-WORK-DD                
A05317         MOVE WS-TEMP-DATE (5:4)     TO WS-WORK-YYYY              
A05317         MOVE WS-WORK-DATE           TO GAS-BASE-LAST-UPDT-4642   
A05317     ELSE                                                         
A05317         MOVE T6-GAS-BASE-LAST-UPDT (T6-INDEX)                    
A05317                                     TO GAS-BASE-LAST-UPDT-4642   
A05317     END-IF                                                       
A05317     MOVE 'Y'  TO                     CALC-ACT-TYPE-CD-4642       
A05317     MOVE T6-BILL-CYCLE (T6-INDEX) TO        BILL-CYCLE-4642      
A05317* PRORATE CD IS Y IF READ CYCLE IS CHANGED                                
A05317     MOVE SPACES                    TO       PRORATE-CD-4642      
A05317     MOVE 'N'        TO         DELETE-SUBDSN-FL-4642             
A05317     MOVE SPACES     TO         WQ-COMMENT-4642                   
A05317     MOVE SPACES     TO         WQ-CREATE-FL-4642                 
                                                                        
                                                                        
A05317*                                                                         
A05317*    EXEC SQL                                                     
A05317*       CALL CSR04642                                             
A05317*         (:APPL-PGM-ID-4642                                      
A05317*         ,:UPDT-ACTION-IND-4642                                  
A05317*         ,:USERID-4642                                           
A05317*         ,:ACCOUNT-NO-4642                                       
A05317*         ,:PREMISE-NO-4642                                       
A05317*         ,:CUSTOMER-NO-4642                                      
A05317*         ,:COMPANY-NO-4642                                       
A05317*         ,:CODE-UTIL-TYPE-4642                                   
A05317*         ,:IC-NO-4642                                            
A05317*         ,:RATE-PLAN-NO-4642                                     
A05317*         ,:CODE-REVENUE-CLASS-4642                               
A05317*         ,:CODE-SIC-NO-4672                                      
A05317*         ,:NAICS-CD-4642                                         
A05317*         ,:SEASONAL-USE-CODE-4642                                
A05317*         ,:ZERO-USE-INVEST-DT-4642                               
A05317*         ,:READ-CYCLE-4642                                       
A05317*         ,:READ-ROUTE-4642                                       
A05317*         ,:CODE-MTR-READ-FREQ-4642                               
A05317*         ,:CODE-ESTIMATE-OK-4642                                 
A05317*         ,:PERSONAL-CNTCT-CD-4642                                
A05317*         ,:ALTERNATE-FUEL-CD-4642                                
A05317*         ,:PRTY-SVC-CAT-CD-4642                                  
A05317*         ,:GAS-BASE-USE-4642                                     
A05317*         ,:GAS-BASE-LAST-UPDT-4642                               
A05317*         ,:CALC-ACT-TYPE-CD-4642                                 
A05317*         ,:BILL-CYCLE-4642                                       
A05317*         ,:PRORATE-CD-4642                                       
A05317*         ,:DELETE-SUBDSN-FL-4642                                 
A05317*         ,:WQ-COMMENT-4642                                       
A05317*         ,:WQ-CREATE-FL-4642)                                    
A05317*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4642
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4642
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4642 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
A05317        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A05317        MOVE '3410'                TO ACTIVE-PARAGRAPH            
A05317        MOVE 'CALL'                TO ABEND-FUNCTION              
A05317        MOVE 'CSR04642'            TO TABLE-1                     
A05317        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A05317        MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
A05317        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
A05317        MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
A05317        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A05317        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A05317     END-IF.                                                      
A05317                                                                  
A05317*    EXEC SQL                                                     
A05317*       ASSOCIATE LOCATORS                                        
A05317*       (:LOC4642)                                                
A05317*       WITH PROCEDURE CSR04642                                   
A05317*    END-EXEC.                                                    
A05317                                                                  
A05317*    EXEC SQL                                                     
A05317*       ALLOCATE RESULT_SET_CSR_4642 CURSOR FOR RESULT SET        
A05317*       :LOC4642                                                  
A05317*    END-EXEC.                                                    
A05317                                                                  
A05317       EXEC SQL                                                   
A05317          FETCH RESULT_SET_CSR_4642 INTO                          
A05317                :RETURN-CODE-4642                                 
A05317               ,:APPL-RETURN-CODE-4642                            
A05317               ,:BUS-RULE-ID-4642                                 
A05317               ,:ACTION-TYPE-CD-4642                              
A05317               ,:BUS-RULE-XREF-ID-4642                            
A05317       END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317       MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
A05317       EVALUATE WS-ACTIVE-RETURN-CODE                             
A05317           WHEN SUCCESSFUL-CALL                                   
A05317               IF RETURN-CODE-4642 NOT = 0                        
A05317                   MOVE RETURN-CODE-4642     TO                   
A05317                        WS-ACTIVE-RETURN-CODE                     
A05317                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
A05317                   MOVE '3410'            TO ACTIVE-PARAGRAPH     
A05317                   MOVE 'FETCH'           TO ABEND-FUNCTION       
A05317                   MOVE 'CSR02211'        TO TABLE-1              
A05317                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
A05317                   MOVE LINK-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1    
A05317                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-2      
A05317                   MOVE LINK-PREMISE-NO   TO HOSTVAR-ELEMENT-2    
A05317                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
A05317                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
A05317               END-IF                                             
A05317           WHEN NOT-FOUND                                         
A05317               MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
A05317           WHEN OTHER                                             
A05317               MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
A05317               MOVE '3410'                TO ACTIVE-PARAGRAPH     
A05317               MOVE 'FETCH'               TO ABEND-FUNCTION       
A05317               MOVE 'CSR04246'            TO TABLE-1              
A05317               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
A05317               MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
A05317               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
A05317               MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
A05317               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
A05317               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
A05317       END-EVALUATE.                                              
A05317                                                                  
A05317 3410-EXIT.                                                       
A05317      EXIT.                                                       
                                                                        
D12609****************************************************************          
      **  CALL CSR01105 TO GET DATA FOR THE EXISTING ORDER.         **          
      ****************************************************************          
                                                                        
       3680-CALL-CSR01105.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-1105.               
           MOVE 'C' TO HISTORY-FL-1105.                                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01105                                             
      *           (:SERV-ORDER-NO-1105,                                 
      *            :HISTORY-FL-1105)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1105
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1105
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1105 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3680'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01105'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1105)                                                
      *       WITH PROCEDURE CSR01105                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1105 CURSOR FOR RESULT SET        
      *       :LOC1105                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1105 INTO                            
                   :RETURN-CODE-1105,                                   
                   :ORDER-TYPE-CD-1105,                                 
                   :ORDER-REASON-1105,                                  
                   :STATUS-TX-1105,                                     
                   :ORDER-STATE-CD-1105,                                
                   :ORDER-PLACED-BY-1105,                               
                   :PHONE-NO-1105,                                      
                   :PHONE-NO-EXT-1105,                                  
                   :WANTED-BY-DATETIME-1105,                            
                   :ASSIGNED-DATETIME-1105,                             
                   :CALL-BEFORE-MINUTS-1105,                            
                   :WORK-AREA-ID-1105,                                  
                   :BREAKERS-OFF-IND-1105,                              
                   :INIT-BY-CNTRCT-IND-1105,                            
                   :NOTIFY-CSR-IND-1105,                                
                   :NOTIFY-CUST-IND-1105,                               
                   :ORDER-PRIORITY-CD-1105,                             
                   :STD-LABOR-CHRG-1105,                                
                   :WORK-TYPE-CD-1105,                                  
                   :BACK-DATED-IND-1105,                                
                   :DEPOSIT-AMT-1105,                                   
                   :ORDER-RECVED-BY-1105,                               
                   :VERIFY-RATE-1105,                                   
                   :PREMISE-NO-1105,                                    
                   :ACCOUNT-NO-1105,                                    
                   :ACCOUNT-NO-PRIOR-1105,                              
                   :BEGIN-APPT-DATE-1105 :WS-NULL-APPT-DT,               
                   :SO-EST-LABOR-HR-1105,                               
                   :CUSTCHG-ORD-TYPE-FL-1105,                           
                   :AMOUNT-DISC-BAL-1105,                               
                   :FILLER-1105,                                        
                   :CURRENT-DATE-1105,                                  
                   :CODE-UTIL-TYPE-1105,                                
                   :PRICE-PER-SERV-1105,                                
                   :ACCOUNT-TYPE-DESC-1105 :WS-NULL-ACCT-DESC,           
                   :ORDER-CHARGE-AMT-1105,                              
                   :TOTAL-CHARGES-AMT-1105,                             
                   :CUST-CNT-ID-1105,                                   
                   :FILLER-A-1105,                                      
                   :FILLER-B-1105,                                      
                   :FILLER-C-1105,                                      
                   :FILLER-D-1105,                                      
                   :FILLER-E-1105,                                      
                   :MTR-ACCESSIBLE-CD-1105,                             
                   :MTR-ACCESSIBLE-DT-1105 :WS-NULL-ACCESS-DT,           
                   :MTR-ACCESSIBLE-RSN-1105,                            
                   :SOURCE-SYSTEM-CD-1105,                              
                   :ALT-PHONE-NO-1105,                                  
                   :ALT-PHONE-NO-EXT-1105,                              
                   :HOME-ALL-DAY-FL-1105,                               
P00718             :BUSINESS-UNIT-1105,                                 
P00718             :OPTIMIZE-ORDER-1105                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1105 NOT = 0                          
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3680'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01105'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE LINK-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                   IF WS-NULL-ACCESS-DT < 0                             
                       MOVE SPACES TO MTR-ACCESSIBLE-DT-1105            
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3680'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01105'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3680-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ****************************************************************          
      **  LOAD DATA FOR THE ORDER                                   **          
      ****************************************************************          
                                                                        
       4000-ADD-ORDER.                                                  
           MOVE LINK-PREMISE-NO TO PREMISE-NO-3374.                     
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-PRIOR-3374.               
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-3374.                     
P0795D*    MOVE ZEROES TO SERV-ORDER-NO-3374.                                   
P0795D     MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-3374.               
           MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-3374.               
           MOVE PR-LOCAL-OFFICE TO LOCAL-OFFICE-3374.                   
           MOVE LINK-PHONE-NO-EXT TO PHONE-NO-EXT-3374.                 
           MOVE LINK-PHONE-NO TO PHONE-NO-3374.                         
           MOVE LINK-ORDER-PLACED-BY TO ORDER-PLACED-BY-3374.           
           MOVE LINK-ORDER-RECVED-BY TO ORDER-RECVED-BY-3374.           
           MOVE LINK-WANTED-BY-DATE TO WANTED-BY-DATE-3374              
           MOVE LINK-ASSIGNED-DATETIME TO ASSIGNED-DATETIME-3374.       
           MOVE LINK-ORDER-REASON TO ORDER-REASON-3374.                 
           MOVE LINK-BACK-DATED-IND TO BACK-DATED-IND-3374.             
           MOVE PF-RESP-AREA-ID TO RESP-AREA-ID-3374.                   
           MOVE LINK-CALL-BEFORE-MIN TO CALL-BEFORE-MIN-3374.           
           MOVE LINK-NOTIFY-CUSTOMER TO NOTIFY-CUST-IND-3374            
           MOVE WS-NOTIFY-CSR-FL TO NOTIFY-CSR-IND-3374.                
           MOVE LINK-BREAKERS-OFF TO BREAKERS-OFF-3374.                 
           MOVE LINK-DEPOSIT-AMT  TO DEPOSIT-AMT-3374                   
           MOVE SPACES TO INIT-BY-CNTRCT-3374.                          
           IF LINK-PANEL-NO = 'SST'                                     
              MOVE WORK-AREA-1116 TO WORK-AREA-ID-3374                  
A05020        MOVE BUSINESS-UNIT-1116 TO BUSINESS-UNIT-3374             
           ELSE                                                         
              MOVE LINK-WORK-AREA-ID TO WORK-AREA-ID-3374               
A05020        MOVE LINK-BUSINESS-UNIT TO BUSINESS-UNIT-3374             
           END-IF                                                       
                                                                        
                                                                        
           MOVE C2-PRIORITY-CD TO OY-PRIORITY-CD                        
           PERFORM 7820-OVERRIDE-PRIORITY THRU 7820-EXIT                
           MOVE C2-PRIORITY-CD TO ORDER-PRIORITY-3374                   
           IF OY-OVERRIDE-PRTY-CD NOT= 'N'                              
              EVALUATE LINK-ARRANGEMENT-FL                              
                 WHEN 'C'                                               
                     MOVE 'ARRANGEMENT' TO OY-PRIORITY-DESC             
                     PERFORM 7810-ORDER-PRIORITY THRU 7810-EXIT         
                     MOVE OY-PRIORITY-CD TO WS-PRIORITY                 
                 WHEN 'A'                                               
                 WHEN 'P'                                               
                 WHEN 'F'                                               
                 WHEN 'N'                                               
                 WHEN 'O'                                               
                 WHEN 'E'                                               
                 WHEN 'B'                                               
                     MOVE 'APPOINTMENT' TO OY-PRIORITY-DESC             
                     PERFORM 7810-ORDER-PRIORITY THRU 7810-EXIT         
                     MOVE OY-PRIORITY-CD TO WS-PRIORITY                 
                 WHEN OTHER                                             
                     MOVE 'NORMAL' TO OY-PRIORITY-DESC                  
                     PERFORM 7810-ORDER-PRIORITY THRU 7810-EXIT         
                     MOVE OY-PRIORITY-CD TO WS-PRIORITY                 
              END-EVALUATE                                              
              MOVE WS-PRIORITY TO ORDER-PRIORITY-3374                   
           END-IF.                                                      
           MOVE LINK-ORDER-STATE-CD TO ORDER-STATE-CD-3374.             
           MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-3374.                 
           MOVE LINK-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-3374.             
           MOVE LINK-STD-CHG-AMT TO STD-CHG-AMT-3374.                   
           MOVE LINK-VERIFY-RATE TO VERIFY-RATE-3374.                   
           MOVE LINK-PANEL-NO TO PANEL-NO-3374.                         
MAINTN*    MOVE LINK-ORDER-RECVED-BY TO USER-ID-3374.                           
           MOVE LINK-USER-ID         TO USER-ID-3374.                   
           MOVE LINK-EST-LABOR-HRS TO SO-EST-LABOR-HR-3374.             
           MOVE AT-CODE-ACCT-STAT TO ACCT-STATUS-3374.                  
           MOVE LINK-REORDER-FLAG TO REORDER-FLAG-3374.                 
           MOVE PR-COMPANY-NO TO COMPANY-NO-3374.                       
           MOVE SPACES TO OLD-ACCOUNT-STAT-3374.                        
           MOVE LINK-CODE-KEY-FIELD TO CODE-KEY-FIELD-3374.             
           MOVE LINK-DATE-FORECAST-DNP TO DATE-FORECAST-DNP-3374        
           MOVE LINK-AMT-DNP-AT-BILL TO AMT-DNP-AT-BILLING-3374.        
           MOVE LINK-PRICE-PER-SERV TO PRICE-PER-SERV-3374.             
           MOVE LINK-ACCOUNT-TYPE-CD TO ACCOUNT-TYPE-CODE-3374.         
           MOVE LINK-WORK-PERIOD-CD TO WORK-PERIOD-CD-3374              
           MOVE LINK-WAIVER-TYPE-CD TO WAIVER-TYPE-CD-3374.             
A05020*    MOVE LINK-BUSINESS-UNIT  TO BUSINESS-UNIT-3374.                      
                                                                        
           PERFORM 4200-CALL-CSR03374 THRU 4200-EXIT.                   
                                                                        
           MOVE NEW-SERV-ORDER-NO-3374 TO S-SERV-ORDER-NO               
                                          VO-SERV-ORDER-NO.             
           MOVE ASSIGNED-DATETIME-3374 TO VO-ASSIGNED-DATETIME          
           MOVE WANTED-BY-DATE-3374 TO VO-WANTED-BY-DATETIME(1:10).     
           MOVE '-00.00.00.000000'  TO VO-WANTED-BY-DATETIME(11:16).    
           MOVE ORDER-STATE-CD-3374 TO VO-ORDER-STATE-CD.               
           MOVE ORDER-TYPE-CD-3374 TO VO-ORDER-TYPE-CD.                 
           IF WS-NEW-ORDER-FL = 'Y'                                     
              MOVE '10' TO VO-SERV-ORDER-STATUS                         
           END-IF.                                                      
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
                                                                        
                                                                        
      ****************************************************************          
      **  GET APPLIANCES FOR THE PREMISE FROM CSS_APPLIANCE.        **          
      **  MATCH EQUIPMENT NUMBERS FROM INPUT PARM AGAINST           **          
      **  CSS_APPLIANCE. UPDATE IF LOCATION CHANGE; INSERT IF NEW   **          
      **  APPLIANCE HAS BEEN ADDED.                                 **          
      ****************************************************************          
                                                                        
       4170-GET-APPLIANCES.                                             
                                                                        
           MOVE LINK-PREMISE-NO TO LA-PREMISE-NO.                       
           PERFORM 7160-OPEN-APP-CURSOR THRU 7160-EXIT.                 
           PERFORM 4175-BUILD-TABLE THRU 4175-EXIT VARYING              
                T5-INDEX FROM 1 BY 1 UNTIL                              
                T5-INDEX > 100  OR                                      
                WS-ACTIVE-RETURN-CODE = NOT-FOUND.                      
           PERFORM 7170-CLOSE-APP-CURSOR THRU 7170-EXIT.                
                                                                        
           PERFORM VARYING T2-INDEX FROM 1 BY 1                         
               UNTIL T2-INDEX > 100 OR                                  
                     T2-EQUIPMENT-NO (T2-INDEX) <= ' '                  
                         PERFORM 4180-MATCH-APPLIANCES THRU 4180-EXIT   
                         IF WS-APPL-UPDATE-FL = 'Y'                     
                            MOVE T2-EQUIPMENT-NO (T2-INDEX) TO          
                                 LA-EQUIPMENT-NO                        
                            MOVE T2-LOCATION-CD (T2-INDEX) TO           
                                 LA-LOCATION-CD                         
                            MOVE T5-LOCATION-CD (T5-INDEX) TO           
                                 WS-APPL-OLD-LOC-CD                     
                            PERFORM 8860-UPDATE-APPLIANCE THRU 8860-EXIT
                         END-IF                                         
                         IF WS-APPL-INSERT-FL = 'Y'                     
                            PERFORM 4220-CALL-CSR01297 THRU 4220-EXIT   
                         END-IF                                         
           END-PERFORM.                                                 
                                                                        
       4170-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD APPLIANCE DATA FOR PREMISE INTO T5-APPLIANCES        **          
      **  WORKING STORAGE TABLE.  THE ROWCOUNT FOR THIS TABLE IS    **          
      **  IN WS-T5-ROWCOUNT.                                        **          
      ****************************************************************          
                                                                        
       4175-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH APP_CURSOR                                         
               INTO :LA-APPLIANCE-CD,                                   
                    :LA-PRIMARY-FUEL-CD,                                
                    :LA-EQUIPMENT-NO,                                   
                    :LA-CAUTION-TAG-IND,                                
                    :A7-CONDITION-DESC,                                 
                    :LA-CUT-IND,                                        
                    :JA-APPLIANCE-DESC,                                 
                    :JA-CRAWL-FL,                                       
                    :JA-SEASONAL-RT-FL,                                 
                    :LA-LOCATION-CD                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-APPLIANCE-FL                          
                   MOVE LA-APPLIANCE-CD TO                              
                        T5-APPLIANCE-CD (T5-INDEX)                      
                   MOVE LA-PRIMARY-FUEL-CD TO                           
                        T5-PRIMARY-FUEL-CD (T5-INDEX)                   
                   MOVE LA-EQUIPMENT-NO TO                              
                        T5-EQUIPMENT-NO (T5-INDEX)                      
                   MOVE LA-CAUTION-TAG-IND TO                           
                        T5-CAUTION-TAG-IND (T5-INDEX)                   
                   MOVE A7-CONDITION-DESC TO                            
                        T5-CONDITION-DESC (T5-INDEX)                    
                   MOVE LA-CUT-IND TO                                   
                        T5-CUT-IND (T5-INDEX)                           
                   MOVE LA-LOCATION-CD TO                               
                        T5-LOCATION-CD (T5-INDEX)                       
                   MOVE JA-APPLIANCE-DESC TO                            
                        T5-APPLIANCE-DESC (T5-INDEX)                    
                   MOVE JA-CRAWL-FL TO                                  
                        T5-CRAWL-FL (T5-INDEX)                          
                   MOVE SPACES TO                                       
                        T5-EQUIP-OWNER (T5-INDEX)                       
                        T5-INSTALL-DT (T5-INDEX)                        
                   MOVE 'N' TO T5-REPLACE-APP-FL (T5-INDEX)             
                   IF JA-SEASONAL-RT-FL = 'Y'                           
                       MOVE 'Y' TO WS-SEASONAL-APP-FL                   
                   END-IF                                               
                   ADD 1 TO WS-T5-ROWCOUNT                              
               WHEN NOT-FOUND                                           
                   GO TO 4175-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '4075'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'FETCH'                  TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_APPLIANCE'          TO TABLE-1             
                   MOVE 'CSS_MKT-APPLIANCE'      TO TABLE-2             
                   MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1     
                   MOVE LA-PREMISE-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4175-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  MATCH APPLIANCE PARM DATA WITH PREMISE APPLIANCES         **          
      ****************************************************************          
                                                                        
       4180-MATCH-APPLIANCES.                                           
                                                                        
           MOVE 'N' TO WS-APPL-INSERT-FL                                
                       WS-APPL-UPDATE-FL                                
                       WS-APPL-MATCH-FL.                                
           PERFORM VARYING T5-INDEX FROM 1 BY 1                         
               UNTIL T5-INDEX > 100 OR                                  
                     T5-EQUIPMENT-NO (T5-INDEX) <= ' '                  
                   IF T2-LOCATION-CD (T2-INDEX) < SPACES                
                      MOVE SPACES TO T2-LOCATION-CD (T2-INDEX)          
                   END-IF                                               
                   IF T2-EQUIPMENT-NO  (T2-INDEX) =                     
                      T5-EQUIPMENT-NO  (T5-INDEX)                       
                          MOVE 'Y' TO WS-APPL-MATCH-FL                  
                          IF T2-LOCATION-CD (T2-INDEX) NOT =            
                             T5-LOCATION-CD (T5-INDEX)                  
                                 MOVE 'Y' TO WS-APPL-UPDATE-FL          
                          END-IF                                        
                   END-IF                                               
           END-PERFORM.                                                 
           IF WS-APPL-MATCH-FL = 'N'                                    
               MOVE 'Y' TO WS-APPL-INSERT-FL
           END-IF.                           
                                                                        
       4180-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR03374 TO ADD AN ORDER.                            **          
      **                                                            **          
      ****************************************************************          
                                                                        
       4200-CALL-CSR03374.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR03374                                             
      *             (:PREMISE-NO-3374,                                  
      *              :ACCOUNT-NO-3374,                                  
      *              :ACCOUNT-NO-PRIOR-3374,                            
      *              :SERV-ORDER-NO-3374,                               
      *              :ORDER-TYPE-CD-3374,                               
      *              :LOCAL-OFFICE-3374,                                
      *              :PHONE-NO-EXT-3374,                                
      *              :PHONE-NO-3374,                                    
      *              :ORDER-PLACED-BY-3374,                             
      *              :ORDER-RECVED-BY-3374,                             
      *              :WANTED-BY-DATE-3374,                              
      *              :ASSIGNED-DATETIME-3374,                           
      *              :ORDER-REASON-3374,                                
      *              :BACK-DATED-IND-3374,                              
      *              :RESP-AREA-ID-3374,                                
      *              :CALL-BEFORE-MIN-3374,                             
      *              :NOTIFY-CUST-IND-3374,                             
      *              :NOTIFY-CSR-IND-3374,                              
      *              :BREAKERS-OFF-3374,                                
      *              :DEPOSIT-AMT-3374,                                 
      *              :INIT-BY-CNTRCT-3374,                              
      *              :WORK-AREA-ID-3374,                                
      *              :ORDER-PRIORITY-3374,                              
      *              :ORDER-STATE-CD-3374,                              
      *              :WORK-TYPE-CD-3374,                                
      *              :CODE-UTIL-TYPE-3374,                              
      *              :STD-CHG-AMT-3374,                                 
      *              :VERIFY-RATE-3374,                                 
      *              :PANEL-NO-3374,                                    
      *              :USER-ID-3374,                                     
      *              :SO-EST-LABOR-HR-3374,                             
      *              :ACCT-STATUS-3374,                                 
      *              :REORDER-FLAG-3374,                                
      *              :COMPANY-NO-3374,                                  
      *              :OLD-ACCOUNT-STAT-3374,                            
      *              :CODE-KEY-FIELD-3374,                              
      *              :DATE-FORECAST-DNP-3374,                           
      *              :AMT-DNP-AT-BILLING-3374,                          
      *              :PRICE-PER-SERV-3374,                              
      *              :ACCOUNT-TYPE-CODE-3374,                           
      *              :WORK-PERIOD-CD-3374,                              
      *              :WAIVER-TYPE-CD-3374,                              
      *              :BUSINESS-UNIT-3374)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_3374
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_3374
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_3374 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR03374'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-3374       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC3374)                                                
      *       WITH PROCEDURE CSR03374                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_3374 CURSOR FOR RESULT SET        
      *       :LOC3374                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_3374 INTO                            
                 :RETURN-CODE-3374,                                     
                 :NEW-SERV-ORDER-NO-3374                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR03374'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PREMISE-NO-3374       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
ACT233**  CALL CSR04675 TO INSERT A WQ.                             **          
      ****************************************************************          
                                                                        
ACT233 4210-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE 0                      TO IN-ITEM-ID-4675.              
ACT233     MOVE PR-LOCAL-OFFICE        TO LOCAL-OFFICE-4675.            
MAINTN*    MOVE LINK-ORDER-RECVED-BY TO USER-ID-ORIG-4675.                      
ACT233     MOVE LINK-USER-ID           TO USER-ID-ORIG-4675.            
ACT233     MOVE SPACES                 TO USER-ID-ASGN-4675             
ACT233                                    RESP-AREA-ID-4675             
ACT233                                    DATE-REQUIRED-4675            
ACT233                                    DATE-CREATED-4675             
ACT233                                    FREE-FORM-DATA-4675-TEXT.     
ACT233     MOVE 'N'                    TO WQ-PRIORITY-4675              
ACT233     MOVE 0                      TO FREE-FORM-DATA-4675-LEN.      
ACT233     MOVE PR-PREMISE-NO          TO PREMISE-NO-4675.              
ACT233     MOVE NEW-SERV-ORDER-NO-3374 TO SERV-ORDER-NO-4675.           
ACT233     MOVE 'CSR04754'             TO CREATED-BY-4675.              
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT233        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT233        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO S-STATUS-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT233                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT233                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT233             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT233             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR01297 TO ADD AN APPLIANCE.                        **          
      ****************************************************************          
                                                                        
       4220-CALL-CSR01297.                                              
                                                                        
           ADD +1 TO WS-T5-ROWCOUNT.                                    
           SET T5-INDEX TO WS-T5-ROWCOUNT.                              
                                                                        
           MOVE 'I' TO UPDATE-TYPE-1297.                                
           MOVE LINK-PREMISE-NO TO PREMISE-NO-1297.                     
           MOVE T2-EQUIPMENT-NO (T2-INDEX) TO EQUIPMENT-NO-1297         
                                            T5-EQUIPMENT-NO (T5-INDEX). 
           MOVE PR-COMPANY-NO TO COMPANY-NO-1297.                       
           MOVE T2-APPLIANCE-CD (T2-INDEX) TO APPLIANCE-CD-1297         
                                             T5-APPLIANCE-CD (T5-INDEX).
           MOVE 'N' TO CAUTION-TAG-IND-1297                             
                       CUT-IND-1297                                     
                       T5-CAUTION-TAG-IND (T5-INDEX)                    
                       T5-CUT-IND (T5-INDEX).                           
           MOVE 'NA-GAS' TO PRIMARY-FUEL-CD-1297                        
                            T5-PRIMARY-FUEL-CD (T5-INDEX).              
           MOVE WS-CURRENT-DATE TO UPDATE-DT-1297.                      
MAINTN*    MOVE LINK-ORDER-RECVED-BY TO UPDATE-ID-1297.                         
           MOVE LINK-USER-ID         TO UPDATE-ID-1297.                 
           IF T2-LOCATION-CD (T2-INDEX) < SPACES                        
              MOVE SPACES TO T2-LOCATION-CD (T2-INDEX)                  
           END-IF                                                       
           MOVE T2-LOCATION-CD (T2-INDEX) TO LOCATION-CD-1297           
                                          T5-LOCATION-CD (T5-INDEX).    
           MOVE SPACES TO TAG-NO-1297                                   
                          CONDITION-CD-1297                             
                          APPL-CMNT-TXT-1297                            
                          CMNT-TXT-1297                                 
                          CAUTION-TAG-DT-1297.                          
           MOVE 0 TO APPL-CMNT-LEN-1297                                 
                     CMNT-TXT-LEN-1297.                                 
           MOVE LINK-SOURCE-SYSTEM TO SOURCE-SYSTEM-CD-1297.            
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01297                                             
      *           (:UPDATE-TYPE-1297,                                   
      *            :PREMISE-NO-1297,                                    
      *            :EQUIPMENT-NO-1297,                                  
      *            :COMPANY-NO-1297,                                    
      *            :APPLIANCE-CD-1297,                                  
      *            :CAUTION-TAG-IND-1297,                               
      *            :CUT-IND-1297,                                       
      *            :PRIMARY-FUEL-CD-1297,                               
      *            :UPDATE-DT-1297,                                     
      *            :UPDATE-ID-1297,                                     
      *            :TAG-NO-1297,                                        
      *            :CONDITION-CD-1297,                                  
      *            :LOCATION-CD-1297,                                   
      *            :APPL-CMNT-LEN-1297,                                 
      *            :APPL-CMNT-TXT-1297,                                 
      *            :CAUTION-TAG-DT-1297,                                
      *            :SOURCE-SYSTEM-CD-1297,                              
      *            :CMNT-TXT-LEN-1297,                                  
      *            :CMNT-TXT-1297)                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1297
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1297
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1297 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4220'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01297'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1297)                                                
      *       WITH PROCEDURE CSR01297                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1297 CURSOR FOR RESULT SET        
      *       :LOC1297                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1297 INTO                            
                 :RETURN-CODE-1297,                                     
                 :WQ-FLAG-1297                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1297 NOT = 0                          
                       MOVE RETURN-CODE-1297  TO S-STATUS-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4220'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01297'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
                       MOVE LINK-PREMISE-NO TO HOSTVAR-ELEMENT-1        
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4220'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01297'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4300-CALL-CSR01334.                                              
                                                                        
           MOVE S-SERV-ORDER-NO TO SERV-ORDER-NO-1334.                  
           MOVE SPACES TO PRINT-DEST-1334                               
                          PRINT-DEST-IND-1334.                          
MAINTN*    MOVE LINK-ORDER-RECVED-BY TO USER-ID-1334.                           
           MOVE LINK-USER-ID         TO USER-ID-1334.                   
           MOVE 'A' TO CAD-TRANS-TYPE-1334.                             
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01334                                             
      *           (:SERV-ORDER-NO-1334,                                 
      *            :PRINT-DEST-1334,                                    
      *            :PRINT-DEST-IND-1334,                                
      *            :USER-ID-1334,                                       
      *            :CAD-TRANS-TYPE-1334)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1334
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1334
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1334 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01334'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-1334    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1334)                                                
      *       WITH PROCEDURE CSR01334                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1334 CURSOR FOR RESULT SET        
      *       :LOC1334                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1334 INTO                            
                 :RETURN-CODE-1334,                                     
                 :ITEM-ID-1334                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1334 NOT = 0                          
                       MOVE RETURN-CODE-1334  TO S-STATUS-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4300'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01334'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-1334 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01334'            TO TABLE-1                
                   MOVE 'SERV-ORDER-NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-1334     TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4400-CALL-CSR02059.                                              
                                                                        
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2059.                     
           MOVE WS-PREM-DIRECTIONS-LEN TO PREMISE-DIR-LEN-2059.         
           MOVE WS-PREM-DIRECTIONS-TEXT TO PREMISE-DIR-TEXT-2059.       
           MOVE WS-SCRATCHPAD-LEN TO PREMISE-SCR-LEN-2059.              
           MOVE WS-SCRATCHPAD-TEXT TO PREMISE-SCR-TEXT-2059.            
           MOVE WS-SPCL-INST-LEN TO PREMISE-SPIN-LEN-2059.              
           MOVE WS-SPCL-INST-TEXT TO PREMISE-SPIN-TEXT-2059.            
           MOVE WS-SPCL-READ-INST-LEN TO PREMISE-RDIN-LEN-2059.         
           MOVE WS-SPCL-READ-INST-TEXT TO PREMISE-RDIN-TEXT-2059.       
           MOVE PR-DATE-SPCL-MSG-ENDS TO DATE-SPCL-MSG-ENDS-2059.       
MAINTN*    MOVE LINK-ORDER-RECVED-BY TO USERID-2059.                            
           MOVE LINK-USER-ID         TO USERID-2059.                    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02059                                             
      *           (:PREMISE-NO-2059,                                    
      *            :PREMISE-DIR-LEN-2059,                               
      *            :PREMISE-DIR-TEXT-2059,                              
      *            :PREMISE-SCR-LEN-2059,                               
      *            :PREMISE-SCR-TEXT-2059,                              
      *            :PREMISE-SPIN-LEN-2059,                              
      *            :PREMISE-SPIN-TEXT-2059,                             
      *            :PREMISE-RDIN-LEN-2059,                              
      *            :PREMISE-RDIN-TEXT-2059,                             
      *            :DATE-SPCL-MSG-ENDS-2059,                            
      *            :USERID-2059)                                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2059
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2059
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2059 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02059'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-2059       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2059)                                                
      *       WITH PROCEDURE CSR02059                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2059 CURSOR FOR RESULT SET        
      *       :LOC2059                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2059 INTO                            
                 :RETURN-CODE-2059                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2059 NOT = 0                          
                       MOVE RETURN-CODE-2059  TO S-STATUS-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4400'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02059'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
                       MOVE PREMISE-NO-2059    TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4400'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02059'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PREMISE-NO-2059        TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4500-CLICK-CAD-UPDATE.                                           
           IF WS-IS-CLICK-PRIOR = 'Y' AND WS-IS-CLICK-CURR ='N'         
              PERFORM 5440-CANCEL-CLICK-ORDER THRU 5440-EXIT
           END-IF.           
           IF WS-IS-CAD-PRIOR = 'Y' AND WS-IS-CAD-CURR NOT = 'Y'        
              PERFORM 5460-INSERT-CAD-CANCEL   THRU 5460-EXIT
           END-IF.          
           IF WS-IS-CLICK-CURR = 'Y'                                    
              PERFORM 5450-INSERT-CLICK-UPDATE THRU  5450-EXIT
           END-IF.         
                                                                        
       4500-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4600-WRITE-CHANGE-LOG.                                           
                                                                        
           IF LINK-PHONE-NO NOT = PHONE-NO-1105                         
              SET WS-CHANGE-LOG-INDEX TO WS-I-PHONE-NO                  
              MOVE PHONE-NO-1105 TO WS-CHANGE-LOG-VALUE                 
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-PHONE-NO-EXT NOT = PHONE-NO-EXT-1105                 
              SET WS-CHANGE-LOG-INDEX TO WS-I-PHONE-NO-EXT              
              MOVE PHONE-NO-EXT-1105 TO WS-CHANGE-LOG-VALUE             
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-ORDER-TYPE-CD NOT = ORDER-TYPE-CD-1105               
              SET WS-CHANGE-LOG-INDEX TO WS-I-ORDER-TYPE-CD             
              MOVE ORDER-TYPE-CD-1105 TO C2-ORDER-TYPE-CD               
              PERFORM 7760-GET-ORDER-TYPE-INFO THRU 7760-EXIT           
              MOVE C2-ORDER-TYPE-DESC TO WS-CHANGE-LOG-VALUE            
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-ORDER-REASON NOT = ORDER-REASON-1105                 
              SET WS-CHANGE-LOG-INDEX TO WS-I-ORDER-RSN-CD              
              MOVE ORDER-REASON-1105 TO WS-CHANGE-LOG-VALUE             
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-ORDER-STATE-CD NOT = ORDER-STATE-CD-1105             
              SET WS-CHANGE-LOG-INDEX TO WS-I-ORDER-STATE-CD            
                                                                        
              SET WS-ORDER-STATE-INDEX TO +1                            
              SEARCH WS-ORDER-STATE-ROW                                 
                 AT END                                                 
                    MOVE SPACES TO WS-CHANGE-LOG-VALUE                  
                 WHEN ORDER-STATE-CD-1105 =                             
                         WS-ORDER-STATE-CODE (WS-ORDER-STATE-INDEX)     
                    MOVE WS-ORDER-STATE-DESC (WS-ORDER-STATE-INDEX) TO  
                                WS-CHANGE-LOG-VALUE                     
              END-SEARCH                                                
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-ORDER-PLACED-BY NOT = ORDER-PLACED-BY-1105           
              SET WS-CHANGE-LOG-INDEX TO WS-I-PLACED-BY                 
              MOVE ORDER-PLACED-BY-1105 TO WS-CHANGE-LOG-VALUE          
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-WANTED-BY-DATE NOT = WANTED-BY-DATETIME-1105(1:10)   
              SET WS-CHANGE-LOG-INDEX TO WS-I-WANTED-DT                 
              MOVE WANTED-BY-DATETIME-1105(1:10) TO WS-CHANGE-LOG-VALUE 
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-ASSIGNED-DATETIME(1:10)  NOT =                       
                              ASSIGNED-DATETIME-1105(1:10)              
              SET WS-CHANGE-LOG-INDEX TO WS-I-ASSIGNED-DT               
              MOVE ASSIGNED-DATETIME-1105(1:10) TO WS-CHANGE-LOG-VALUE  
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-CALL-BEFORE-MIN NOT = CALL-BEFORE-MINUTS-1105        
              SET WS-CHANGE-LOG-INDEX TO WS-I-CALL-BEFORE               
              MOVE CALL-BEFORE-MINUTS-1105 TO WS-CHANGE-LOG-VALUE       
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-WORK-AREA-ID NOT = WORK-AREA-ID-1105                 
              SET WS-CHANGE-LOG-INDEX TO WS-I-WORK-AREA-ID              
              MOVE WORK-AREA-ID-1105 TO WS-CHANGE-LOG-VALUE             
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-BREAKERS-OFF NOT = BREAKERS-OFF-IND-1105             
              SET WS-CHANGE-LOG-INDEX TO WS-I-BREAKERS-IND              
              MOVE BREAKERS-OFF-IND-1105 TO WS-CHANGE-LOG-VALUE         
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
P0795N*    IF LINK-ORDER-PRIORITY-CD NOT = ORDER-PRIORITY-CD-1105               
P0795N*       SET WS-CHANGE-LOG-INDEX TO WS-I-ORDER-PRTY-CD                     
P0795N*       MOVE ORDER-PRIORITY-CD-1105 TO WS-CHANGE-LOG-VALUE                
P0795N*       PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT                      
P0795N*    END-IF.                                                              
DT9203     IF LINK-ASSIGNED-DATETIME(1:10) NOT = MTR-ACCESSIBLE-DT-1105 
              SET WS-CHANGE-LOG-INDEX TO WS-I-MTR-ACCESS-DT             
              MOVE MTR-ACCESSIBLE-DT-1105 TO WS-CHANGE-LOG-VALUE        
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-HOME-ALL-DAY NOT = HOME-ALL-DAY-FL-1105              
              SET WS-CHANGE-LOG-INDEX TO WS-I-HOME-ALL-DAY              
              MOVE HOME-ALL-DAY-FL-1105 TO WS-CHANGE-LOG-VALUE          
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-DONOT-OPTIMIZE-FL NOT = OPTIMIZE-ORDER-1105          
              SET WS-CHANGE-LOG-INDEX TO WS-I-OPTIMIZE-FL               
              MOVE OPTIMIZE-ORDER-1105 TO WS-CHANGE-LOG-VALUE           
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           IF LINK-WORK-TYPE-CD  NOT = VI-WORK-TYPE-CD                  
              SET WS-CHANGE-LOG-INDEX TO WS-I-WORK-TYPE                 
              MOVE VI-WORK-TYPE-CD  TO L4-WORK-TYPE-CD                  
              PERFORM 7972-WORK-TYPE  THRU 7972-EXIT                    
              MOVE L4-WORK-TYPE-DESC TO WS-CHANGE-LOG-VALUE             
              PERFORM 4610-BUILD-CHANGE-LOG THRU 4610-EXIT              
           END-IF.                                                      
           PERFORM 5410-CALL-CSR00425  THRU 5410-EXIT.                  
                                                                        
       4600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4610-BUILD-CHANGE-LOG.                                           
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE                     
           MOVE 0 TO WS-COUNT-O WS-LENGTH                               
           IF WS-CHANGE-LOG-VALUE = SPACES                              
              MOVE 'BLANKS' TO WS-CHANGE-LOG-VALUE                      
           END-IF                                                       
           IF CHANGE-LOG-LEN > 0                                        
             STRING CHANGE-LOG-REMARKS (1:CHANGE-LOG-LEN)               
                    ' '                                                 
                    WS-CHANGE-LOG-TEXT (WS-CHANGE-LOG-INDEX)            
                    WS-CHANGE-LOG-VALUE                                 
                    DELIMITED BY SIZE INTO WS-EMB-INPUT                 
           ELSE                                                         
             STRING WS-CHANGE-LOG-TEXT (WS-CHANGE-LOG-INDEX)            
                    WS-CHANGE-LOG-VALUE                                 
                    DELIMITED BY SIZE INTO WS-EMB-INPUT                 
           END-IF                                                       
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
           INSPECT WS-CMP-TABLE REPLACING ALL LOW-VALUES BY ' '         
           INSPECT FUNCTION REVERSE(WS-CMP-TABLE) TALLYING              
                             WS-COUNT-O FOR LEADING SPACES              
           COMPUTE WS-LENGTH = LENGTH OF WS-CMP-TABLE - WS-COUNT-O      
           MOVE WS-CMP-TABLE TO CHANGE-LOG-REMARKS.                     
           MOVE WS-LENGTH TO CHANGE-LOG-LEN.                            
                                                                        
       4610-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      **  CALL CSR02517 TO INSERT A COMMUNICATION RECORD.           **          
      ****************************************************************          
                                                                        
       5090-CALL-CSR02517.                                              
                                                                        
           MOVE 'I' TO ACTION-CD-2517.                                  
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2517.                     
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-2517                      
           MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM                    
           MOVE AT-CUSTOMER-NO TO CUSTOMER-NO-2517                      
           MOVE SPACES TO COMMUNICATION-ID-2517                         
                          RED-FLAG-EXP-DT-2517                          
                          PROMOTION-ID-2517                             
                          CALL-END-TIME-2517                            
                          SCREEN-POP-IND-2517                           
                          RESPONSE-RESN-CD-2517                         
                          RESPONSE-TYPE-CD-2517                         
                          SOLICITATION-CD-2517.                         
           MOVE PR-COMPANY-NO TO COMPANY-NO-2517.                       
           MOVE 'N' TO RED-FLAG-IND-2517                                
                       PSC-COMPLAINT-IND-2517                           
                       COMPLAINT-FL-2517.                               
           MOVE LINK-COMM-METHOD TO COMM-METHOD-2517.                   
           MOVE 'I' TO COMM-DIRECTION-2517.                             
           MOVE '41' TO COMM-TYPE-CD-2517.                              
           IF LINK-ORDER-TYPE-CD = 'EM002'                              
               MOVE '02' TO COMM-SUBTYPE-CD-2517                        
           ELSE                                                         
               MOVE '09' TO COMM-SUBTYPE-CD-2517                        
           END-IF                                                       
MAINTN*    MOVE LINK-ORDER-RECVED-BY TO USER-ID-ORIG-2517.                      
           MOVE LINK-USER-ID         TO USER-ID-ORIG-2517.              
           MOVE LINK-ORDER-PLACED-BY TO CONTACT-NAME-2517.              
           MOVE ZEROES TO CALL-ORIGIN-ID-2517                           
                          NUMBER-TRANSFERS-2517                         
                          HOLD-TIME-2517                                
                          QUEUE-TIME-2517                               
                          TOTAL-CALL-TIME-2517.                         
           MOVE 'A' TO COMM-ASSOC-CD-2517.                              
           MOVE LINK-COMM-COMMENTS TO COMMENT-TEXT-2517.                
           MOVE LENGTH OF LINK-COMM-COMMENTS TO COMMENT-LEN-2517.       
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02517                                             
      *           (:ACTION-CD-2517,                                     
      *            :ACCOUNT-NO-2517,                                    
      *            :CUSTOMER-NO-2517,                                   
      *            :PREMISE-NO-2517,                                    
      *            :COMMUNICATION-ID-2517,                              
      *            :COMPANY-NO-2517,                                    
      *            :RED-FLAG-IND-2517,                                  
      *            :RED-FLAG-EXP-DT-2517,                               
      *            :COMM-METHOD-2517,                                   
      *            :COMM-DIRECTION-2517,                                
      *            :COMM-TYPE-CD-2517,                                  
      *            :COMM-SUBTYPE-CD-2517,                               
      *            :USER-ID-ORIG-2517,                                  
      *            :CONTACT-NAME-2517,                                  
      *            :PROMOTION-ID-2517,                                  
      *            :PSC-COMPLAINT-IND-2517,                             
      *            :CALL-ORIGIN-ID-2517,                                
      *            :CALL-END-TIME-2517,                                 
      *            :NUMBER-TRANSFERS-2517,                              
      *            :HOLD-TIME-2517,                                     
      *            :QUEUE-TIME-2517,                                    
      *            :SCREEN-POP-IND-2517,                                
      *            :TOTAL-CALL-TIME-2517,                               
      *            :COMMENT-LEN-2517,                                   
      *            :COMMENT-TEXT-2517,                                  
      *            :COMM-ASSOC-CD-2517,                                 
      *            :COMPLAINT-FL-2517,                                  
      *            :RESPONSE-RESN-CD-2517,                              
      *            :RESPONSE-TYPE-CD-2517,                              
      *            :SOLICITATION-CD-2517)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2517 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5090'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02517'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2517)                                                
      *       WITH PROCEDURE CSR02517                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2517 CURSOR FOR RESULT SET        
      *       :LOC2517                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2517 INTO                            
                 :RETURN-CODE-2517                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2517 NOT = 0                          
                       MOVE RETURN-CODE-2517  TO S-STATUS-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5090'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02517'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2517   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5090'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02517'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5090-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
                                                                        
      ****************************************************************          
      **  CALL CSR01416 TO GET THE DATE THAT IS X NUMBER OF         **          
      **  BUSINESS DAYS IN THE FUTURE.                              **          
      ****************************************************************          
                                                                        
       5130-CALL-CSR01416.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01416                                             
      *           (:INPUT-DATE-1416,                                    
      *            :BUSINESS-DAYS-1416)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1416 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5130'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01416'            TO TABLE-1                     
              MOVE 'INPUT-DATE'          TO TABLE-ELEMENT-1             
              MOVE INPUT-DATE-1416       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1416)                                                
      *       WITH PROCEDURE CSR01416                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1416 CURSOR FOR RESULT SET        
      *       :LOC1416                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1416 INTO                            
                 :OUTPUT-DATE-1416                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5130'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01416'            TO TABLE-1                
                   MOVE 'INPUT_DATE'          TO TABLE-ELEMENT-1        
                   MOVE INPUT-DATE-1416       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5130-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02120 TO UPDATE PENDING ORDERS FLAG               **          
      ****************************************************************          
                                                                        
       5140-CALL-CSR02120.                                              
                                                                        
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2120.                     
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-2120.                     
           MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-2120.               
           MOVE 'A' TO ORDER-STATE-CD-2120.                             
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02120                                             
      *           (:PREMISE-NO-2120,                                    
      *            :ACCOUNT-NO-2120,                                    
      *            :ORDER-TYPE-CD-2120,                                 
      *            :ORDER-STATE-CD-2120)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2120
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2120
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2120 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5140'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02120'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-2120       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2120)                                                
      *       WITH PROCEDURE CSR02120                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2120 CURSOR FOR RESULT SET        
      *       :LOC2120                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2120 INTO                            
                 :RETURN-CODE-2120                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2120 NOT = 0                          
                       MOVE RETURN-CODE-2120  TO S-STATUS-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5140'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02120'        TO TABLE-1                
                       MOVE 'PREMISE-NO'      TO TABLE-ELEMENT-1        
                       MOVE PREMISE-NO-2120   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5140'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02120'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PREMISE-NO-2120       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5140-EXIT.                                                       
            EXIT.                                                       
                                                                        
D10675****************************************************************          
D10675**  CALL CSR00092 TO UPDATE SO REQUIREMENT                     *          
D10675****************************************************************          
D10675                                                                  
D10675 5160-CALL-CSR00092.                                              
D10675                                                                  
D10675     MOVE S-SERV-ORDER-NO      TO SERV-ORDER-NO-0092              
D10675     MOVE '10'                 TO SERV-ORDER-STATUS-0092          
D10675     MOVE '2'                  TO REQUIREMENT_CD-0092             
D10675     MOVE LINK-USER-ID         TO USERID-0092                     
D10675     MOVE WS-CURRENT-TIMESTAMP TO WANTED-DATE-0092                
D10675     MOVE LINK-PANEL-NO      TO PANEL-NO-0092                     
D10675     MOVE 'YC' TO UPDATE-STATUS-0092                              
D10675                                                                  
D10675*    EXEC SQL                                                     
D10675*       CALL CSR00092                                             
D10675*            (:SERV-ORDER-NO-0092,                                
D10675*             :SERV-ORDER-STATUS-0092,                            
D10675*             :REQUIREMENT_CD-0092,                               
D10675*             :USERID-0092,                                       
D10675*             :WANTED-DATE-0092,                                  
D10675*             :PANEL-NO-0092,                                     
D10675*             :UPDATE-STATUS-0092                                 
D10675*             )                                                   
D10675*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0092
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0092
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0092 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
D10675                                                                  
D10675     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
D10675                                                                  
D10675     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
D10675        IF WS-ACTIVE-RETURN-CODE = 0                              
D10675            MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
D10675        END-IF                                                    
D10675        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
D10675        MOVE '5160'                TO ACTIVE-PARAGRAPH            
D10675        MOVE 'CALL'                TO ABEND-FUNCTION              
D10675        MOVE 'CSR00092'            TO TABLE-1                     
D10675        MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
D10675        MOVE SERV-ORDER-NO-0092    TO HOSTVAR-ELEMENT-1           
D10675        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
D10675        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
D10675     END-IF.                                                      
D10675                                                                  
D10675*    EXEC SQL                                                     
D10675*       ASSOCIATE LOCATORS                                        
D10675*       (:LOC0092)                                                
D10675*       WITH PROCEDURE CSR00092                                   
D10675*    END-EXEC.                                                    
D10675                                                                  
D10675*    EXEC SQL                                                     
D10675*       ALLOCATE RESULT_SET_CSR_0092 CURSOR FOR RESULT SET        
D10675*       :LOC0092                                                  
D10675*    END-EXEC.                                                    
D10675                                                                  
D10675     EXEC SQL                                                     
D10675        FETCH RESULT_SET_CSR_0092 INTO                            
D10675           :RETURN-CODE-0092                                      
D10675     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

D10675                                                                  
D10675     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
D10675     EVALUATE WS-ACTIVE-RETURN-CODE                               
D10675         WHEN SUCCESSFUL-CALL                                     
D10675             IF RETURN-CODE-0092 NOT = 0                          
D10675                 MOVE RETURN-CODE-0092  TO S-STATUS-CODE          
D10675                                           WS-ACTIVE-RETURN-CODE  
D10675                 MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
D10675                 MOVE '5160'            TO ACTIVE-PARAGRAPH       
D10675                 MOVE 'FETCH'           TO ABEND-FUNCTION         
D10675                 MOVE 'CSR00092'        TO TABLE-1                
D10675                 MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1    
D10675                 MOVE SERV-ORDER-NO-0092    TO HOSTVAR-ELEMENT-1  
D10675                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
D10675                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
D10675             END-IF                                               
D10675         WHEN OTHER                                               
D10675             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
D10675             MOVE '5160'                TO ACTIVE-PARAGRAPH       
D10675             MOVE 'FETCH'               TO ABEND-FUNCTION         
D10675             MOVE 'CSR00092'            TO TABLE-1                
D10675             MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1        
D10675             MOVE SERV-ORDER-NO-0092    TO HOSTVAR-ELEMENT-1      
D10675             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
D10675             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
D10675     END-EVALUATE.                                                
D10675                                                                  
D10675 5160-EXIT.                                                       
D10675      EXIT.                                                       
D10675                                                                  
D10675****************************************************************          
D10675**  CALL CSR01110 TO GET THE STATUS OF THE ORDER               *          
D10675****************************************************************          
D10675                                                                  
D10675 5170-CALL-CSR01110.                                              
D10675                                                                  
D10675     MOVE S-SERV-ORDER-NO      TO SERV-ORDER-NO-1110              
D10675                                                                  
D10675*    EXEC SQL                                                     
D10675*       CALL CSR01110                                             
D10675*            (:SERV-ORDER-NO-1110                                 
D10675*             )                                                   
D10675*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1110
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1110
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1110 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
D10675                                                                  
D10675     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
D10675                                                                  
D10675     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
D10675        IF WS-ACTIVE-RETURN-CODE = 0                              
D10675            MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
D10675        END-IF                                                    
D10675        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
D10675        MOVE '5170'                TO ACTIVE-PARAGRAPH            
D10675        MOVE 'CALL'                TO ABEND-FUNCTION              
D10675        MOVE 'CSR01110'            TO TABLE-1                     
D10675        MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
D10675        MOVE SERV-ORDER-NO-1110    TO HOSTVAR-ELEMENT-1           
D10675        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
D10675        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
D10675     END-IF.                                                      
D10675                                                                  
D10675*    EXEC SQL                                                     
D10675*       ASSOCIATE LOCATORS                                        
D10675*       (:LOC1110)                                                
D10675*       WITH PROCEDURE CSR01110                                   
D10675*    END-EXEC.                                                    
D10675                                                                  
D10675*    EXEC SQL                                                     
D10675*       ALLOCATE RESULT_SET_CSR_1110 CURSOR FOR RESULT SET        
D10675*       :LOC1110                                                  
D10675*    END-EXEC.                                                    
D10675                                                                  
D10675     EXEC SQL                                                     
D10675        FETCH RESULT_SET_CSR_1110 INTO                            
D10675           :SERV-ORDER-STATUS-1110                                
D10675     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

D10675                                                                  
D10675     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
D10675     EVALUATE WS-ACTIVE-RETURN-CODE                               
D10675         WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
D10675         WHEN OTHER                                               
D10675             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
D10675             MOVE '5170'                TO ACTIVE-PARAGRAPH       
D10675             MOVE 'FETCH'               TO ABEND-FUNCTION         
D10675             MOVE 'CSR01110'            TO TABLE-1                
D10675             MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1        
D10675             MOVE SERV-ORDER-NO-1110    TO HOSTVAR-ELEMENT-1      
D10675             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
D10675             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
D10675     END-EVALUATE.                                                
D10675                                                                  
D10675 5170-EXIT.                                                       
D10675      EXIT.                                                       
D10675                                                                  
      ****************************************************************          
      **  CALL CSR00425 TO INSERT NEW CHANGE LOG REMARKS.           **          
      ****************************************************************          
                                                                        
       5410-CALL-CSR00425.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-0425.               
           MOVE 'E' TO REMARK-TYPE-CD-0425.                             
           IF CHANGE-LOG-LEN > 210                                      
              MOVE 210 TO CHANGE-LOG-LEN                                
              MOVE CHANGE-LOG-REMARKS (1:210) TO CHANGE-LOG-REMARKS     
           END-IF                                                       
           MOVE WS-CHANGE-LOG-REMARKS TO REMARKS-0425.                  
P0795N*    MOVE LINK-ORDER-RECVED-BY TO USER-ID-0425.                           
           MOVE LINK-USER-ID         TO USER-ID-0425.                   
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00425                                             
      *           (:SERV-ORDER-NO-0425,                                 
      *            :REMARK-TYPE-CD-0425,                                
      *            :REMARKS-0425,                                       
      *            :USER-ID-0425)                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0425
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0425
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0425 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5410'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00425'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0425    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0425)                                                
      *       WITH PROCEDURE CSR00425                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0425 CURSOR FOR RESULT SET        
      *       :LOC0425                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0425 INTO                            
                 :RETURN-CODE-0425                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0425 NOT = 0                          
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5410'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00425'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-0425 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5410'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00425'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0425    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5410-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
P0795N* CALL CSR04747 - CHECK IF CLICK ORDER- RETURNS WORK DISTRICT *   08064003
      ******************************************************************        
       5420-CHECK-CLICK.                                                
                                                                        
           MOVE LINK-SERV-ORDER-NO TO  SERV-ORDER-NO-4747.              
           MOVE '1'                TO  PRIORITY-4747.                   
           MOVE 'S'                TO  ACTION-CD-4747                   
D12609     MOVE LINK-USER-ID       TO  USER-ID-4747                     
           MOVE SPACES             TO  WORK-DISTRICT-IN-4747.           
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :SERV-ORDER-NO-4747                             
      *                ,:PRIORITY-4747                                  
      *                ,:ACTION-CD-4747                                 
      *                ,:USER-ID-4747                                   
      *                ,:WORK-DISTRICT-IN-4747)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747S
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747S
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747S INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5420'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK CLICK'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4747S)                                               
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747S CURSOR FOR RESULT SET           
      *       :LOC4747S                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747S INTO                               
                 :RETURN-CODE-4747,                                     
                 :WORK-DISTRICT-OUT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WORK-DISTRICT-OUT-4747 TO WS-WORK-DISTRICT      
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5420'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-EVALUATE.                                                
                                                                        
       5420-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5430-CHECK-CAD.                                                  
                                                                        
           MOVE SPACES TO WS-IS-CAD.                                    
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-IS-CAD                                        
                 FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                    
                WHERE WORK_AREA_ID = :C4-WORK-AREA-ID                   
                  AND PRINTER_ID = 'CAD'                                
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-IS-CAD                                                
MFA-TR*          FROM CSS_SO_PRINT_LOC                                          
MFA-TR*         WHERE WORK_AREA_ID = :C4-WORK-AREA-ID                           
MFA-TR*           AND PRINTER_ID = 'CAD'                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7830                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '5430'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PRINT-LOC'      TO TABLE-1                 
                   MOVE C4-WORK-AREA-ID      TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5430-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************02630000
      *   5440-CANCEL-CLICK-ORDER.                                     *08063003
      *       CANCEL THE CLICK ORDER                                   *08064003
      ******************************************************************08061003
                                                                        
       5440-CANCEL-CLICK-ORDER.                                         
                                                                        
           MOVE '5440'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :VO-SERV-ORDER-NO,                              
      *                 '1',                                            
      *                 'Z',                                            
      *                 :LINK-USER-ID,                                  
      *                 :WS-WORK-DISTRICT)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747Z
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747Z
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747Z INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5440'                TO ACTIVE-PARAGRAPH            
              MOVE 'CANCEL CLICK'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4747Z)                                               
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747Z CURSOR FOR RESULT SET           
      *       :LOC4747Z                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747Z INTO                               
                 :WS-RETURN-CODE-4747,                                  
                 :WS-WORK-DISTRICT-4747                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7700'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       5440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   5450-INSERT-CLICK-UPDATE.                                    *08063003
      *       INSERT UPDATE FOR CLICK ORDER                            *08064003
      ******************************************************************08061003
                                                                        
       5450-INSERT-CLICK-UPDATE.                                        
                                                                        
           MOVE '5450'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :VO-SERV-ORDER-NO,                              
      *                 '1',                                            
      *                 'U',                                            
      *                 :LINK-USER-ID,                                  
      *                 :WS-WORK-DISTRICT)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747U
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747U
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747U INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5450'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLICK UPDATE'        TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4747U)                                               
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747U CURSOR FOR RESULT SET           
      *       :LOC4747U                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747U INTO                               
                 :WS-RETURN-CODE-4747,                                  
                 :WS-WORK-DISTRICT-4747                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7700'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       5450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************0000    
      *   5460-INSERT-CAD-CANCEL.                                      *08063003
      *        SENDS CANCEL ROW TO CSS_SO_CAD_QUEUE                    *08064003
      ******************************************************************8061003 
                                                                        
       5460-INSERT-CAD-CANCEL.                                          
                                                                        
           MOVE '5460'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PR-COMPANY-NO TO VO-COMPANY-NO.                         
           MOVE PR-LOCAL-OFFICE TO VO-LOCAL-OFFICE.                     
           EXEC SQL                                                     
               INSERT INTO CSS_SO_CAD_QUEUE                             
                (SERV_ORDER_NO,                                         
                 COMPANY_NO,                                            
                 LOCAL_OFFICE,                                          
                 WORK_GROUP_ID,                                         
                 WORK_AREA_ID,                                          
                 CREATED_TS,                                            
                 CAD_TS,                                                
                 CAD_PRIORITY,                                          
                 CREATED_BY_USER_ID,                                    
                 CAD_TRANS_TY_ACTN)                                     
               VALUES                                                   
                (:VO-SERV-ORDER-NO,                                     
                 :VO-COMPANY-NO,                                        
                 :VO-LOCAL-OFFICE,                                      
                 ' ',                                                   
                 ' ',                                                   
                 CIS.CURRENT$TIMESTAMP(),                                     
                 NULL,                                                  
                 '1',                                                   
                 'SYSTEM',                                              
                 'C')                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080693
MFA-TR*        INSERT INTO CSS_SO_CAD_QUEUE                             08080694
MFA-TR*         (SERV_ORDER_NO,                                         08080694
MFA-TR*          COMPANY_NO,                                            08080694
MFA-TR*          LOCAL_OFFICE,                                          08069203
MFA-TR*          WORK_GROUP_ID,                                         08069203
MFA-TR*          WORK_AREA_ID,                                          08069203
MFA-TR*          CREATED_TS,                                            08069203
MFA-TR*          CAD_TS,                                                08069203
MFA-TR*          CAD_PRIORITY,                                          08069203
MFA-TR*          CREATED_BY_USER_ID,                                    08069203
MFA-TR*          CAD_TRANS_TY_ACTN)                                     08069203
MFA-TR*        VALUES                                                   08080694
MFA-TR*         (:VO-SERV-ORDER-NO,                                     08080694
MFA-TR*          :VO-COMPANY-NO,                                        08080694
MFA-TR*          :VO-LOCAL-OFFICE,                                      08069203
MFA-TR*          ' ',                                                   08069203
MFA-TR*          ' ',                                                   08069203
MFA-TR*          CURRENT TIMESTAMP,                                     08069203
MFA-TR*          NULL,                                                  08069203
MFA-TR*          '1',                                                   08069203
MFA-TR*          'SYSTEM',                                              08069203
MFA-TR*          'C')                                                   08069203
MFA-TR*    END-EXEC.                                                    08080695

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5460'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT CAD CANCEL'   TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_CAD_QUEUE'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5460-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00413 TO RESET REQUIREMENTS                       **          
      ****************************************************************          
                                                                        
       5470-CALL-CSR00413.                                              
                                                                        
           MOVE S-SERV-ORDER-NO       TO SERV-ORDER-NO-0413.            
           MOVE LINK-USER-ID          TO USER-ID-0413.                  
           MOVE LINK-PANEL-NO         TO PANEL-NO-0413.                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00413                                             
      *           (:SERV-ORDER-NO-0413,                                 
      *            :USER-ID-0413,                                       
      *            :PANEL-NO-0413)                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0413
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0413
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0413 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5470'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00413'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0413    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0413)                                                
      *       WITH PROCEDURE CSR00413                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0413 CURSOR FOR RESULT SET        
      *       :LOC0413                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0413 INTO                            
                 :RETURN-CODE-0413                                      
                ,:SERV-ORDER-STATUS-0413                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0413 NOT = 0                          
                       MOVE RETURN-CODE-0413  TO S-STATUS-CODE          
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5470'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00413'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-0413 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5470'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00413'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0413    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5470-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       6000-REDUCE-EMBEDDED-SPACES.                                     
                                                                        
           MOVE 255 TO WS-EMB-TBL-LENG.                                 
           SET WS-EMB-INDX TO 1.                                        
           SET WS-CMP-INDX TO 1.                                        
           MOVE SPACE TO WS-EMB-LAST-CHAR.                              
           IF WS-EMB-LENG NUMERIC AND                                   
              WS-EMB-LENG > ZERO AND                                    
              WS-EMB-LENG < WS-EMB-TBL-LENG                             
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-TBL-LENG TO WS-EMB-LENG
           END-IF.                     
           PERFORM 6010-COMPRESSION-ROUTINE THRU 6010-EXIT              
               VARYING WS-EMB-INDX FROM WS-EMB-INDX BY 1                
               UNTIL WS-EMB-INDX > WS-EMB-LENG.                         
           MOVE ZERO TO WS-EMB-LENG.                                    
                                                                        
       6000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6010-COMPRESSION-ROUTINE.                                        
                                                                        
           IF WS-EMB-CHAR (WS-EMB-INDX) EQUAL SPACE AND                 
              WS-EMB-LAST-CHAR                                          
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-CHAR (WS-EMB-INDX) TO                        
                    WS-CMP-CHAR (WS-CMP-INDX)                           
                    WS-EMB-LAST-CHAR                                    
                SET WS-CMP-INDX UP BY 1
           END-IF.                                
                                                                        
       6010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  GET PREMISE INFORMATION.                                  **          
      ****************************************************************          
                                                                        
       7100-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COMPANY_NO,
              REV_DISTRICT_CD,
              LOCAL_OFFICE,
              DATE_SPCL_MSG_ENDS,
              ADDRESS_ID                                        
                 INTO :PR-COMPANY-NO,                                   
                      :PR-REV-DISTRICT-CD,                              
                      :PR-LOCAL-OFFICE,                                 
                      :PR-DATE-SPCL-MSG-ENDS :WS-NULL-IND-3,             
                      :PR-ADDRESS-ID                                    
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :PR-PREMISE-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO,                                               
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               DATE_SPCL_MSG_ENDS,                                       
MFA-TR*               ADDRESS_ID                                                
MFA-TR*          INTO :PR-COMPANY-NO,                                           
MFA-TR*               :PR-REV-DISTRICT-CD,                                      
MFA-TR*               :PR-LOCAL-OFFICE,                                         
MFA-TR*               :PR-DATE-SPCL-MSG-ENDS:WS-NULL-IND-3,                     
MFA-TR*               :PR-ADDRESS-ID                                            
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO     = :PR-PREMISE-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-3 < 0                                 
                       MOVE SPACES TO PR-DATE-SPCL-MSG-ENDS             
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-GET-RELEASE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RE.REV_DISTRICT_CD,
              RLSE_TYPE,
              RLSE_SUPPLIES                                     
                 INTO :RE-REV-DISTRICT-CD,                              
                      :RE-RLSE-TYPE,                                    
                      :RE-RLSE-SUPPLIES                                 
                 FROM CSS_PREM_RLSE_DATA RP WITH(READUNCOMMITTED),              
                      CSS_PREM_RLSE RE WITH(READUNCOMMITTED)                    
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND RP.RLSE_NO = RE.RLSE_NO                           
                  AND RLSE_EXP_DATE >= CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RE.REV_DISTRICT_CD,                                       
MFA-TR*               RLSE_TYPE,                                                
MFA-TR*               RLSE_SUPPLIES                                             
MFA-TR*          INTO :RE-REV-DISTRICT-CD,                                      
MFA-TR*               :RE-RLSE-TYPE,                                            
MFA-TR*               :RE-RLSE-SUPPLIES                                         
MFA-TR*          FROM CSS_PREM_RLSE_DATA RP,                                    
MFA-TR*               CSS_PREM_RLSE RE                                          
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND RP.RLSE_NO = RE.RLSE_NO                                   
MFA-TR*           AND RLSE_EXP_DATE >= :WS-CURRENT-TIMESTAMP                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RE-REV-DISTRICT-CD                    
                                  RE-RLSE-TYPE                          
                                  RE-RLSE-SUPPLIES                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                 
                   MOVE 'CSS_PREM_RLSE'      TO TABLE-2                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  CURSOR PROCESSING TO READ CSS_APPLIANCE.                  **          
      ****************************************************************          
                                                                        
       7160-OPEN-APP-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN APP_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7160'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_APPLIANCE'         TO TABLE-1                  
               MOVE 'CSS_MKT_APPLIANCE'     TO TABLE-2                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE LA-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-CLOSE-APP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE APP_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7170'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_APPLIANCE'         TO TABLE-1                  
               MOVE 'CSS_MKT_APPLIANCE'     TO TABLE-2                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE LA-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET THE RESPONSIBLE AREA FOR THE USERID.  IT WILL BE      **          
      **  PASSED INTO CSR00073 WHEN THE ORDER IS CREATED.           **          
      ****************************************************************          
                                                                        
       7180-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :LINK-ORDER-RECVED-BY                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :LINK-ORDER-RECVED-BY                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7180                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PF-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7180'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_USER_PROFILE'   TO TABLE-1                 
                   MOVE 'USER_ID'            TO TABLE-ELEMENT-1         
                   MOVE LINK-ORDER-RECVED-BY TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET ACCOUNT INFORMATION.                                  **          
      ****************************************************************          
                                                                        
       7200-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO,
              CODES_DATA_PRESENT,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              CODE_ACCT_STAT                                    
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
                      :AT-CODE-ACCT-STAT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               CODES_DATA_PRESENT,                                       
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT,                                           
MFA-TR*               CODE_ACCT_STAT                                            
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :AT-CODE-ACCT-STAT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET LOCAL OFFICE INFORMATION FOR THE PREMISE.             **          
      ****************************************************************          
                                                                        
       7210-GET-LOCAL-OFFICE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PHONE_NO,
              PHONE_NO_EXT                                      
                 INTO :B1-PHONE-NO,                                     
                      :B1-PHONE-NO-EXT                                  
                 FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO   = :PR-COMPANY-NO                     
                  AND LOCAL_OFFICE = :PR-LOCAL-OFFICE                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PHONE_NO,                                                 
MFA-TR*               PHONE_NO_EXT                                              
MFA-TR*          INTO :B1-PHONE-NO,                                             
MFA-TR*               :B1-PHONE-NO-EXT                                          
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*         WHERE COMPANY_NO   = :PR-COMPANY-NO                             
MFA-TR*           AND LOCAL_OFFICE = :PR-LOCAL-OFFICE                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO B1-PHONE-NO                           
                                  B1-PHONE-NO-EXT                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_LOCAL_OFFICE'   TO TABLE-1                 
                   MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
                   MOVE PR-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
                   MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2         
                   MOVE PR-COMPANY-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7220-GET-ZIP-CODE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DY.ZIP_CODE                                       
                 INTO :DY-ZIP-CODE                                      
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DY.ZIP_CODE                                               
MFA-TR*          INTO :DY-ZIP-CODE                                              
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7220                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO DY-ZIP-CODE                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7220'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-GET-SO-DATA.                                                
                                                                        
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-CHAR.            
           MOVE WS-SERV-ORDER-NO-NUM TO VO-SERV-ORDER-NO.               
           EXEC SQL                                                     
               SELECT WORK_AREA_ID                                      
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME                                 
                     ,ORDER_TYPE_CD                                     
                 INTO :VO-WORK-AREA-ID                                  
                     ,:VO-ASSIGNED-DATETIME                             
                     ,:WS-ORIG-ORDER-TYPE-CD                            
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_AREA_ID                                              
MFA-TR*              ,ASSIGNED_DATETIME                                         
MFA-TR*              ,ORDER_TYPE_CD                                             
MFA-TR*          INTO :VO-WORK-AREA-ID                                          
MFA-TR*              ,:VO-ASSIGNED-DATETIME                                     
MFA-TR*              ,:WS-ORIG-ORDER-TYPE-CD                                    
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7230                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7230'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-GET-SO-ORDER-INST.                                          
                                                                        
           MOVE SPACES TO VI-WORK-TYPE-CD.                              
           EXEC SQL                                                     
               SELECT TOP(1) WORK_TYPE_CD                                      
                 INTO :VI-WORK-TYPE-CD                                  
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_TYPE_CD                                              
MFA-TR*          INTO :VI-WORK-TYPE-CD                                          
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7240                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO VI-WORK-TYPE-CD                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7240'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VI-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795 7760-GET-ORDER-TYPE-INFO.                                        
P00795                                                                  
P00795     EXEC SQL                                                     
P0079D         SELECT PRIORITY_CD                                       
P0079D           INTO :C2-PRIORITY-CD                                   
P00795           FROM CSS_ORDER_TYPE WITH(READUNCOMMITTED)                      
P00795          WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                
P00795            AND COMPANY_NO    = :PR-COMPANY-NO                    
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRIORITY_CD                                               
MFA-TR*          INTO :C2-PRIORITY-CD                                           
MFA-TR*          FROM CSS_ORDER_TYPE                                            
MFA-TR*         WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                        
MFA-TR*           AND COMPANY_NO    = :PR-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7760                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00795         WHEN SUCCESSFUL-CALL                                     
P00795              CONTINUE                                            
P00795         WHEN OTHER                                               
P00795             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00795             MOVE '7760'           TO ACTIVE-PARAGRAPH            
P00795             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00795             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00795                                           ABEND-TABLES           
P00795             MOVE 'CSS_ORDER-TYPE'     TO TABLE-1                 
P00795             MOVE 'ORDER-TYPE'         TO TABLE-ELEMENT-1         
P00795             MOVE C2-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
P00795             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00795             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00795     END-EVALUATE.                                                
P00795                                                                  
P00795 7760-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
PRDFIX****************************************************************          
PRDFIX**  GET ORDER WK INFO                                           **        
PRDFIX****************************************************************          
P00795 7762-GET-ORDER-WK-TYPE-INFO.                                     
P00795                                                                  
P00795     MOVE LINK-ORDER-TYPE-CD TO L3-ORDER-TYPE-CD                  
P00795     MOVE LINK-WORK-TYPE-CD   TO L3-WORK-TYPE-CD                  
P00795                                                                  
P00795     EXEC SQL                                                     
P00795         SELECT COMPLIANCE_DAYS_NO                                
P00795           INTO :L3-COMPLIANCE-DAYS-NO                            
P00795           FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
P00795          WHERE ORDER_TYPE_CD =  :L3-ORDER-TYPE-CD                
P00795            AND COMPANY_NO    = :PR-COMPANY-NO                    
P00795            AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                  
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPLIANCE_DAYS_NO                                        
MFA-TR*          INTO :L3-COMPLIANCE-DAYS-NO                                    
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE ORDER_TYPE_CD =  :L3-ORDER-TYPE-CD                        
MFA-TR*           AND COMPANY_NO    = :PR-COMPANY-NO                            
MFA-TR*           AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7762                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00795         WHEN SUCCESSFUL-CALL                                     
P00795              CONTINUE                                            
P00795         WHEN OTHER                                               
P00795             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00795             MOVE '7762'           TO ACTIVE-PARAGRAPH            
P00795             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00795             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00795                                           ABEND-TABLES           
P00795             MOVE 'CSS_ORDER-WK-TYPE'  TO TABLE-1                 
P00795             MOVE 'ORDER-TYPE'         TO TABLE-ELEMENT-1         
P00795             MOVE L3-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
P00795             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00795             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00795     END-EVALUATE.                                                
P00795                                                                  
P00795 7762-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET ORDER PRIORITY                                        **          
      ****************************************************************          
                                                                        
       7810-ORDER-PRIORITY.                                             
                                                                        
           EXEC SQL                                                     
               SELECT PRIORITY_CD                                       
                 INTO :OY-PRIORITY-CD                                   
                 FROM CSS_ORDER_PRIORITY WITH(READUNCOMMITTED)                  
                WHERE PRIORITY_DESC = :OY-PRIORITY-DESC                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRIORITY_CD                                               
MFA-TR*          INTO :OY-PRIORITY-CD                                           
MFA-TR*          FROM CSS_ORDER_PRIORITY                                        
MFA-TR*         WHERE PRIORITY_DESC = :OY-PRIORITY-DESC                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7810                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 7 TO OY-PRIORITY-CD                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7810'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_PRIORITY' TO TABLE-1                 
                   MOVE OY-PRIORITY-DESC     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET PRIORITY FROM CSS_ORDER_TYPE TABLE                    **          
      ****************************************************************          
                                                                        
       7820-OVERRIDE-PRIORITY.                                          
                                                                        
           EXEC SQL                                                     
               SELECT OVERRIDE_PRTY_CD                                  
                 INTO :OY-OVERRIDE-PRTY-CD                              
                 FROM CSS_ORDER_PRIORITY WITH(READUNCOMMITTED)                  
                WHERE PRIORITY_CD = :OY-PRIORITY-CD                     
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OVERRIDE_PRTY_CD                                          
MFA-TR*          INTO :OY-OVERRIDE-PRTY-CD                                      
MFA-TR*          FROM CSS_ORDER_PRIORITY                                        
MFA-TR*         WHERE PRIORITY_CD = :OY-PRIORITY-CD                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7820                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO OY-OVERRIDE-PRTY-CD                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7820'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER-PRIORITY' TO TABLE-1                 
                   MOVE OY-OVERRIDE-PRTY-CD     TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7972-WORK-TYPE.                                                  
                                                                        
           MOVE PR-COMPANY-NO TO L4-COMPANY-NO.                         
           EXEC SQL                                                     
               SELECT TOP(1) WORK_TYPE_DESC                                    
                 INTO :L4-WORK-TYPE-DESC                                
                 FROM CSS_WORK_TYPE WITH(READUNCOMMITTED)                       
                WHERE WORK_TYPE_CD = :L4-WORK-TYPE-CD                   
                  AND COMPANY_NO   = :L4-COMPANY-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_TYPE_DESC                                            
MFA-TR*          INTO :L4-WORK-TYPE-DESC                                        
MFA-TR*          FROM CSS_WORK_TYPE                                             
MFA-TR*         WHERE WORK_TYPE_CD = :L4-WORK-TYPE-CD                           
MFA-TR*           AND COMPANY_NO   = :L4-COMPANY-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7972                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7972'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_WORK_TYPE'     TO TABLE-1                  
                   MOVE 'WORK_TYPE_CD'      TO TABLE-ELEMENT-1          
                   MOVE L4-WORK-TYPE-CD     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7972-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-FRO-REQUIREMENTS.                                           
                                                                        
           MOVE NEW-SERV-ORDER-NO-3374 TO EG-SERV-ORDER-NO.             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_REQUIREMENT                                
                  SET REQMNT_STAGE_CD = 'C',                            
                      REQMNT_COMP_DT = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              ),           
                      COMP_BY_USER_ID = :LINK-USER-ID                   
                WHERE SERV_ORDER_NO = :EG-SERV-ORDER-NO                 
                  AND CIS.SUBSTR3(SERV_ORDER_STATUS,1,1) = '2'               
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_REQUIREMENT                                        
MFA-TR*           SET REQMNT_STAGE_CD = 'C',                                    
MFA-TR*               REQMNT_COMP_DT = :WS-CURRENT-TIMESTAMP,                   
MFA-TR*               COMP_BY_USER_ID = :LINK-USER-ID                           
MFA-TR*         WHERE SERV_ORDER_NO = :EG-SERV-ORDER-NO                         
MFA-TR*           AND SUBSTR(SERV_ORDER_STATUS,1,1) = '2'                       
MFA-TR*         QUERYNO 80001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '80001'          TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_REQUIREMENT' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EG-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_REQUIREMENT                                
                  SET REQMNT_STAGE_CD = 'C',                            
                      REQMNT_COMP_DT = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              ),           
                      COMP_BY_USER_ID = :LINK-USER-ID                   
                WHERE SERV_ORDER_NO = :EG-SERV-ORDER-NO                 
                  AND SERV_ORDER_STATUS = '10'                          
                  AND REQUIREMENT_CD = '2'                              
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_REQUIREMENT                                        
MFA-TR*           SET REQMNT_STAGE_CD = 'C',                                    
MFA-TR*               REQMNT_COMP_DT = :WS-CURRENT-TIMESTAMP,                   
MFA-TR*               COMP_BY_USER_ID = :LINK-USER-ID                           
MFA-TR*         WHERE SERV_ORDER_NO = :EG-SERV-ORDER-NO                         
MFA-TR*           AND SERV_ORDER_STATUS = '10'                                  
MFA-TR*           AND REQUIREMENT_CD = '2'                                      
MFA-TR*         QUERYNO 80002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '80002'          TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_REQUIREMENT' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EG-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET SERV_ORDER_STATUS = '30'                          
                WHERE SERV_ORDER_NO = :EG-SERV-ORDER-NO                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET SERV_ORDER_STATUS = '30'                                  
MFA-TR*         WHERE SERV_ORDER_NO = :EG-SERV-ORDER-NO                         
MFA-TR*         QUERYNO 80003                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '80003'          TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'        TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EG-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      **  INSERT REMARKS.                                           **          
      ****************************************************************          
                                                                        
       8200-INSERT-REMARKS.                                             
                                                                        
           MOVE NEW-SERV-ORDER-NO-3374 TO EF-SERV-ORDER-NO.             
           MOVE +210 TO EF-REMARK-TX-LEN.                               
MAINTN*    MOVE LINK-ORDER-RECVED-BY TO EF-CHANGED-BY-USER-ID.                  
           MOVE LINK-USER-ID         TO EF-CHANGED-BY-USER-ID.          
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REMARKS                               
                   (SERV_ORDER_NO,                                      
                    REMARK_TYPE_CD,                                     
                    REMARK_DATETIME,                                    
                    CHANGED_BY_USER_ID,                                 
                    REMARK_TX)                                          
               VALUES                                                   
                   ( :EF-SERV-ORDER-NO,                                 
                     :EF-REMARK-TYPE-CD,                                
                     CIS.CURRENT$TIMESTAMP(),                                 
                     :EF-CHANGED-BY-USER-ID,                            
                     :EF-REMARK-TX)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_REMARKS                                       
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             REMARK_TYPE_CD,                                             
MFA-TR*             REMARK_DATETIME,                                            
MFA-TR*             CHANGED_BY_USER_ID,                                         
MFA-TR*             REMARK_TX)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*            ( :EF-SERV-ORDER-NO,                                         
MFA-TR*              :EF-REMARK-TYPE-CD,                                        
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :EF-CHANGED-BY-USER-ID,                                    
MFA-TR*              :EF-REMARK-TX)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_REMARKS'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EF-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE SERVICE ORDER.                                     **          
      ****************************************************************          
                                                                        
       8500-UPDATE-ORDER.                                               
                                                                        
           MOVE NEW-SERV-ORDER-NO-3374 TO VO-SERV-ORDER-NO.             
           IF LINK-ARRANGEMENT-FL = ' ' OR 'C'                          
               MOVE SPACES TO VO-BEGIN-APPT-DT                          
                              VO-END-APPT-DT                            
                              VO-APPT-AM-PM-CD                          
               MOVE -1 TO WS-NULL-IND-1 WS-NULL-IND-2                   
           ELSE                                                         
               MOVE LINK-ARRANGEMENT-FL TO VO-APPT-AM-PM-CD             
               MOVE LINK-START-TS TO VO-BEGIN-APPT-DT                   
               MOVE LINK-STOP-TS TO VO-END-APPT-DT
           END-IF.                     
           MOVE LINK-ASSIGNED-DATETIME(1:10) TO VO-MTR-ACCESSIBLE-DT.   
           MOVE LINK-MTR-ACCESS-CD(1:1) TO  VO-MTR-ACCESSIBLE-CD.       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET ALT_PHONE_NO = :LINK-ALT-PHONE-NO,                
                      ALT_PHONE_NO_EXT = :LINK-ALT-PHONE-NO-EXT,        
                      MTR_ACCESSIBLE_CD = :VO-MTR-ACCESSIBLE-CD,        
                      MTR_ACCESSIBLE_RSN = :LINK-MTR-ACCESS-RSN,        
                      MTR_ACCESSIBLE_DT = IIF(TRY_CONVERT(DATE, 
                                                  :VO-MTR-ACCESSIBLE-DT
              ) IS NULL OR (PATINDEX('%.%', :VO-MTR-ACCESSIBLE-DT
              ) <> 0) OR (LEN(:VO-MTR-ACCESSIBLE-DT
              ) <> 10), CIS.CHAR2DATE(:VO-MTR-ACCESSIBLE-DT
              ), CONVERT(DATE, :VO-MTR-ACCESSIBLE-DT) ),        
                      APPT_AM_PM_CD = :VO-APPT-AM-PM-CD,                
                      BEGIN_APPT_DT = CIS.CHAR2TIMESTAMP(
                                                     :VO-BEGIN-APPT-DT 
                                                         :WS-NULL-IND-1
              ),  
                      END_APPT_DT   = CIS.CHAR2TIMESTAMP(
                                                       :VO-END-APPT-DT 
                                                         :WS-NULL-IND-2
              ),    
                      SOURCE_SYSTEM_CD = :LINK-SOURCE-SYSTEM,           
                      HOME_ALL_DAY_FL = :LINK-HOME-ALL-DAY,             
                      OPTIMIZE_ORDER_FL = :LINK-DONOT-OPTIMIZE-FL,      
P0795C                ORDER_KEY       = :LINK-ORDER-KEY                 
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET ALT_PHONE_NO = :LINK-ALT-PHONE-NO,                        
MFA-TR*               ALT_PHONE_NO_EXT = :LINK-ALT-PHONE-NO-EXT,                
MFA-TR*               MTR_ACCESSIBLE_CD = :VO-MTR-ACCESSIBLE-CD,                
MFA-TR*               MTR_ACCESSIBLE_RSN = :LINK-MTR-ACCESS-RSN,                
MFA-TR*               MTR_ACCESSIBLE_DT = :VO-MTR-ACCESSIBLE-DT,                
MFA-TR*               APPT_AM_PM_CD = :VO-APPT-AM-PM-CD,                        
MFA-TR*               BEGIN_APPT_DT = :VO-BEGIN-APPT-DT:WS-NULL-IND-1,          
MFA-TR*               END_APPT_DT   = :VO-END-APPT-DT:WS-NULL-IND-2,            
MFA-TR*               SOURCE_SYSTEM_CD = :LINK-SOURCE-SYSTEM,                   
MFA-TR*               HOME_ALL_DAY_FL = :LINK-HOME-ALL-DAY,                     
MFA-TR*               OPTIMIZE_ORDER_FL = :LINK-DONOT-OPTIMIZE-FL,              
MFA-TR*               ORDER_KEY       = :LINK-ORDER-KEY                         
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         QUERYNO 8500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'        TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  INSERT AN AUDIT ROW.                                      **          
      ****************************************************************          
                                                                        
       8700-INSERT-AUDIT-ROW.                                           
                                                                        
           MOVE LINK-USER-ID TO VW-USER-ID-UPDT-BY.                     
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_UPDATE                                
                   (SERV_ORDER_NO,                                      
                    USER_ID_UPDT_BY,                                    
                    UPDATE_DATETIME,                                    
                    PANEL_NO,                                           
                    ASSIGNED_DATETIME,                                  
                    ORDER_TYPE_CD,                                      
                    SERV_ORDER_STATUS,                                  
                    ORDER_STATE_CD,                                     
                    WANTED_BY_DATETIME)                                 
               VALUES                                                   
                   (:VO-SERV-ORDER-NO,                                  
                    :VW-USER-ID-UPDT-BY,                                
                    CIS.CURRENT$TIMESTAMP(),                                  
                    :VW-PANEL-NO,                                       
                    CIS.CHAR2TIMESTAMP(:VO-ASSIGNED-DATETIME),                  
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-SERV-ORDER-STATUS,                              
                    :VO-ORDER-STATE-CD,                                 
                    CIS.CHAR2TIMESTAMP(:VO-WANTED-BY-DATETIME))                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_UPDATE                                        
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             USER_ID_UPDT_BY,                                            
MFA-TR*             UPDATE_DATETIME,                                            
MFA-TR*             PANEL_NO,                                                   
MFA-TR*             ASSIGNED_DATETIME,                                          
MFA-TR*             ORDER_TYPE_CD,                                              
MFA-TR*             SERV_ORDER_STATUS,                                          
MFA-TR*             ORDER_STATE_CD,                                             
MFA-TR*             WANTED_BY_DATETIME)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (:VO-SERV-ORDER-NO,                                          
MFA-TR*             :VW-USER-ID-UPDT-BY,                                        
MFA-TR*             CURRENT TIMESTAMP,                                          
MFA-TR*             :VW-PANEL-NO,                                               
MFA-TR*             :VO-ASSIGNED-DATETIME,                                      
MFA-TR*             :VO-ORDER-TYPE-CD,                                          
MFA-TR*             :VO-SERV-ORDER-STATUS,                                      
MFA-TR*             :VO-ORDER-STATE-CD,                                         
MFA-TR*             :VO-WANTED-BY-DATETIME)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_UPDATE'      TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      **  UPDATE CODES_DATA_PRESENT FOR UNBLOCK GAS WITH NO         **          
      **  SEASONAL APPLIANCE                                        **          
      ****************************************************************          
                                                                        
       8810-UPDATE-APPL-CDP.                                            
                                                                        
           MOVE NEW-SERV-ORDER-NO-3374 TO VO-SERV-ORDER-NO.             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET CODES_DATA_PRESENT =                              
                  (CIS.SUBSTR3(CODES_DATA_PRESENT,1,11) + 'A' + 
           CIS.SUBSTR3(CODES_DATA_PRESENT,13,23))                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET CODES_DATA_PRESENT =                                      
MFA-TR*           (SUBSTR(CODES_DATA_PRESENT,1,11) || 'A' ||                    
MFA-TR*            SUBSTR(CODES_DATA_PRESENT,13,23))                            
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*        QUERYNO 8810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8810'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'        TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      **  UPDATE CODES_DATA_PRESENT FOR UTILITY CHANGE              **          
      ****************************************************************          
                                                                        
A04670 8840-UPDATE-CDP.                                                 
A04670                                                                  
A04670     MOVE NEW-SERV-ORDER-NO-3374 TO VO-SERV-ORDER-NO.             
A04670                                                                  
A04670     EXEC SQL                                                     
A04670         UPDATE CSS_SO_DATA                                       
A04670            SET CODES_DATA_PRESENT =                              
A04670               (CIS.SUBSTR3(CODES_DATA_PRESENT,1,9) + 'A' + 
           CIS.SUBSTR3(CODES_DATA_PRESENT,11,25))                 
A04670          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
A04670                                                      
A04670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET CODES_DATA_PRESENT =                                      
MFA-TR*              (SUBSTR(CODES_DATA_PRESENT,1,9) || 'A' ||                  
MFA-TR*               SUBSTR(CODES_DATA_PRESENT,11,25))                         
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         QUERYNO 8840                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04670                                                                  
A04670     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04670                                                                  
A04670     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04670         WHEN SUCCESSFUL-CALL                                     
A04670             CONTINUE                                             
A04670         WHEN OTHER                                               
A04670             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A04670             MOVE '8850'           TO ACTIVE-PARAGRAPH            
A04670             MOVE 'UPDATE'         TO ABEND-FUNCTION              
A04670             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A04670                                           ABEND-TABLES           
A04670             MOVE 'CSS_SO_DATA'        TO TABLE-1                 
A04670             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
A04670             MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
A04670             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A04670             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A04670     END-EVALUATE.                                                
A04670                                                                  
A04670 8840-EXIT.                                                       
A04670     EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      **  UPDATE CSS_APPLIANCE.LOCATION_CD                          **          
      ****************************************************************          
                                                                        
       8860-UPDATE-APPLIANCE.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_APPLIANCE                                     
                  SET LOCATION_CD = :LA-LOCATION-CD                     
                WHERE EQUIPMENT_NO = :LA-EQUIPMENT-NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_APPLIANCE                                             
MFA-TR*           SET LOCATION_CD = :LA-LOCATION-CD                             
MFA-TR*         WHERE EQUIPMENT_NO = :LA-EQUIPMENT-NO                           
MFA-TR*         QUERYNO 8860                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8860'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
                   MOVE 'EQUIPMENT_NO'       TO TABLE-ELEMENT-1         
                   MOVE LA-EQUIPMENT-NO      TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE ZEROES TO MH-CUSTOMER-NO                                
                          MH-ACCOUNT-NO.                                
           MOVE PR-PREMISE-NO TO MH-PREMISE-NO.                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
           MOVE 'EQUIPMENT NO' TO MI-COLUMN-DESC.                       
           MOVE LA-EQUIPMENT-NO TO MI-PRV-COLUMN-VALUE-TEXT.            
           MOVE +20 TO MI-PRV-COLUMN-VALUE-LEN.                         
           MOVE SPACES TO MI-TABLE-ID.                                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
           MOVE 'LOCATION'  TO MI-COLUMN-DESC.                          
           IF WS-APPL-OLD-LOC-CD = ' '                                  
               MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT                 
               MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                       
           ELSE                                                         
               MOVE WS-APPL-OLD-LOC-CD TO MI-PRV-COLUMN-VALUE-TEXT      
               MOVE +25 TO MI-PRV-COLUMN-VALUE-LEN
           END-IF.                     
           MOVE +25 TO MI-CHG-COLUMN-VALUE-LEN.                         
           MOVE LA-LOCATION-CD TO MI-CHG-COLUMN-VALUE-TEXT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
