       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04752.                                         
COB303 DATE-WRITTEN.  FEBRUARY 2014.                                    
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *        
      *  THIS PROCEDURE CREATES A NEW DRAWER IN CASH DRAWER CONTROL    *00190002
      *  TABLE AND OPENS A CASH REPORT IF NOT ALREADY OPENED FOR THE   *00110000
      *  THE REPORT DATE. ALSO UPDATES CASHIER TABLE FOR A CHANGE IN   *00150000
      *  OFFICE.                                                       *        
      *  BUSOP NAME: UPDOPENCASHDRAWERDTLSBUSINESSOP                   *        
      ******************************************************************00160000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
PRJ586*  02/11/14  AP40911    NEW  PROCEDURE FOR MOD                   *00270002
      ******************************************************************00290000
      ******************************************************************00320000
      ******************************************************************00330000
      *                                                                *00340000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350000
      *                                                                *00360000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390000
      *  3000 - 4999  NOT USED                                         *00400000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420000
      *  7000 - 7999  INPUT MODULES                                    *00430000
      *  8000 - 8999  OUTPUT MODULES                                   *00440000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450000
      *                                                                *00460000
      ******************************************************************00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04752'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04752 STARTS HERE'.                  
                                                                        
      ******************************************************************01080000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090000
      ******************************************************************01100000
                                                                        
          COPY CCA00001.                                                01150000
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
          COPY CWS00011.                                                01150000
          COPY CWS00027.                                                01160000
          COPY CWS00303.                                                01170000
                                                                        
      ******************************************************************01240000
      *    WORK AREAS                                                  *01250000
      ******************************************************************01260000
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                 PIC X(26)                       
                                            VALUE 'SESSION.CSR02389_R1'.
       01  COUNTER-FLAG.                                                
           05  WS-CSH-RPT-HDR-FLAG      PIC X(01) VALUE 'N'.            
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(8)  VALUE 'CSR04752'.     
           05  WS-SQLSTATE              PIC X(05)  VALUE  SPACES.       
           05  WS-INSERT-BATCH-FLAG     PIC X(01) VALUE 'Y'.            
           05  WS-CSH-RPT-HDR-STATUS    PIC X(01).                      
           05  WS-USER-ID               PIC X(07).                      
           05  WS-CASH-LOCAL-OFFICE     PIC X(03).                      
                                                                        
       01  WS-NULL-INDICATOR.                                           
           05 WS-NULL-INDICATOR1        PIC S9(04) COMP VALUE +0.       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-ONE                   PIC S9    COMP VALUE 1.         
           05  WS-MAX-BATCH-COUNT       PIC S9(4) COMP VALUE 1000.      
           05  WS-ACTIVE-CODE           PIC X(01) VALUE 'A'.            
           05  WS-INACTIVE-CODE         PIC X(01) VALUE 'C'.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(009) COMP VALUE +0.       
                                                                        
       01   CSRERLOG-P.                                                 
           10  S-SP-NAME                PIC X(18)      VALUE SPACES.    
           10  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
           10  S-SQLSTATE               PIC X(5)       VALUE ' '.       
           10  S-TABLE-NAME             PIC X(18)      VALUE SPACES.    
           10  S-HOST-VARIABLES.                                        
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
           10  S-SQL-STATEMENT.                                         
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
           10  S-SQL-DESCRIPTION.                                       
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
     *                                                                  
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
           EXEC SQL                                                     00600000
              INCLUDE SQLCA                                             00610000
           END-EXEC.                                                    00620000
                                                                        
      ******************************************************************02150037
      *    CSS_CSH_DRWR_CNTL CS                                        *02160037
      ******************************************************************02170037
           EXEC SQL                                                     00840000
              INCLUDE TBCDCNTL                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      ******************************************************************02430037
      *    CSS_CSH_REPORT_HDR   YR                                     *02440037
      ******************************************************************02450037
           EXEC SQL                                                     00840000
              INCLUDE TBCSRPHD                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      ******************************************************************02430037
      *    CSS_CASH_PC_ID     Y3                                       *02440037
      ******************************************************************02450037
           EXEC SQL                                                     00840000
              INCLUDE TBCSPCID                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      ******************************************************************02430037
      *    CSS_AR_LOCKOUT     AL                                       *02440037
      ******************************************************************02450037
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************02430037
      *    CSS_CASHIER    Y1                                           *02440037
      ******************************************************************02450037
           EXEC SQL                                                             
               INCLUDE TBCSHIER                                                 
           END-EXEC.                                                            
     *                                                                  
       LINKAGE SECTION.                                                 
       01 PARM-USER-ID              PIC X(7).                           
COB305 01 PARM-WORKING-FUNDS        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
       01 PARM-REPORT-DATE          PIC X(10).                          
       01 PARM-OPEN-BATCH-FLAG      PIC X(01).                          
       01 PARM-COMPANY-NO           PIC X(2).                           
       01 PARM-LOCAL-OFFICE         PIC X(3).                           
       01 PARM-REPORT-NO            PIC X(3).                           
       01 PARM-PC-ID                PIC X(15).                          
     *                                                                  
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION USING     PARM-USER-ID                        
                                    PARM-WORKING-FUNDS                  
                                    PARM-REPORT-DATE                    
                                    PARM-OPEN-BATCH-FLAG                
                                    PARM-COMPANY-NO                     
                                    PARM-LOCAL-OFFICE                   
                                    PARM-REPORT-NO                      
                                    PARM-PC-ID.                         
                                                                        
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      *                                                                *02310000
      *     1. RESET DB2 ERROR HANDLERS                                *02320000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02330000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02340000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02350000
      *                                                                *02360000
      ******************************************************************02370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                FROM                                                    
                    #CSR04752_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04752_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
     *******************************************************************2530000 
     **0100A-DECLARE-GTT.                                              *02540000
     *******************************************************************2890000 
       0100A-DECLARE-GTT.                                               
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04752_R1'            
                                       TO S-SQL-STATEMENT-V.            
     *                                                                  
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04752_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04752_R1
              (                                                       
                   RETURN_CODE              INT                     
                  ,APPL_RETURN_CODE         INT                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-SQLSTATE = '42710'                                     
                  PERFORM 8000A-DELETE-GTT-ROWS                         
                                             THRU 8000A-EXIT            
           ELSE                                                         
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                     NEXT SENTENCE                                      
                  ELSE                                                  
                     MOVE PROGRAM-NAME       TO ABEND-PROGRAM           
                     MOVE SQLCODE            TO ABEND-SQLCODE           
                     MOVE SQLSTATE           TO ABEND-SQLSTATE          
                     MOVE '0100A'            TO ACTIVE-PARAGRAPH        
                     MOVE 'DECLARE GTT'      TO ABEND-FUNCTION          
                     MOVE SPACES             TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                     MOVE 'CSR04752_R1'      TO TABLE-1                 
                     MOVE SPACES             TO TABLE-ELEMENT-1         
                     MOVE SPACES             TO HOSTVAR-ELEMENT-1       
                     PERFORM 9900-SQL-ERROR-ROUTINE                     
                                                    THRU  9900-EXIT     
                  END-IF                                                
           END-IF.                                                      
     *                                                                  
         0100A-EXIT.                                                    
              EXIT.                                                     
     *                                                                  
      ******************************************************************02650000
      * 1000-PROCESS-INPUT                                             *02660000
      *     1. RECEIVE PARMS.                                          *02680000
      ******************************************************************02700000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           MOVE WS-ACTIVE-CODE                  TO CS-CODE-CSH-DRWR-STAT
           MOVE SPACES                          TO CS-CASHIER-CODE.     
           MOVE PARM-USER-ID                    TO CS-USER-ID,          
                                                   YR-USER-ID           
           MOVE PARM-WORKING-FUNDS              TO CS-AMT-BASIC-WORK,   
                                                   CS-AMT-CASH-BEGIN-BAL
           MOVE PARM-REPORT-DATE                TO CS-DATE-CASH-REPORT, 
                                                   YR-DATE-CASH-REPORT, 
                                                   CS-DATE-LAST-ACTIVITY
           MOVE PARM-COMPANY-NO                 TO CS-CASH-COMPANY-NO,  
                                                   YR-CASH-COMPANY-NO,  
                                                   Y3-CASH-COMPANY-NO   
           MOVE PARM-LOCAL-OFFICE               TO CS-CASH-LOCAL-OFFICE,
                                                   YR-CASH-LOCAL-OFFICE,
                                                   Y3-CASH-LOCAL-OFFICE 
           MOVE PARM-REPORT-NO                  TO CS-CASH-REPORT-NO.   
           MOVE PARM-PC-ID                      TO Y3-CASH-PC-ID.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      *                                                                *05130000
      *     1. DESCRIBE RESULT SET                                     *05130000
      *     2. BUILD THE RESULT SET                                    *05150000
      *     3. SEND RESULT SET                                         *05170000
      *                                                                *05180000
      ******************************************************************05190000
      *                                                                 05200000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7999-SELECT-AL               THRU                    
                                                7999-SELECT-AL-EXIT.    
           IF  AL-AR-LOCKOUT-IND = WS-YES                               
               MOVE 5000                        TO S-APPL-RETURN-CODE   
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
           PERFORM 2200-BUILD-RESULT            THRU 2200-EXIT.         
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
      *                                                                 05270000
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 2200-BUILD-RESULT                                           *           
      *     BUILD THE RESULT SET                                    *           
      *         CHECK IF BATCH IS TO BE OPENED                      *           
      *           1.CHECK CASH REPORT HEADER STATUS                 *           
      *             RETURN 1000 IF CASH REPORT HEADER IS CLOSED     *           
      *             IF CASH REPORT HEADER NOT FOUND INSERT ONE      *           
      *           2.UPDATE CASHIER TABLE IF CASHIER OFFICE IS       *           
      *             CHANGED.                                        *           
      *           3.INITIALIZE THE HOST VARIABLES FOR INSERTING     *           
      *             INTO CASH DRAWER CNTL.                          *           
      *             INSERT NEW ROW INTO CASH DRAWER CNTL            *           
      *         RETURN                                              *           
      *                                                             *           
      ***************************************************************           
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           IF PARM-OPEN-BATCH-FLAG = WS-YES                             
               PERFORM 7100-SELECT-STATUS       THRU 7100-EXIT          
               PERFORM 7000-SELECT-CASHIER      THRU 7000-EXIT          
               IF WS-CASH-LOCAL-OFFICE NOT EQUAL TO PARM-LOCAL-OFFICE   
               PERFORM 7000A-UPDATE-CASHIER     THRU 7000A-EXIT         
               END-IF                                                   
               IF WS-CSH-RPT-HDR-FLAG = WS-NO                           
                   PERFORM 2250-INITIALIZE-HOST THRU 2250-EXIT          
                   PERFORM 7200-INSERT-CASHREPORT                       
                                                THRU 7200-EXIT          
               ELSE                                                     
                   IF WS-CSH-RPT-HDR-STATUS = WS-INACTIVE-CODE          
                       MOVE 1000                TO S-APPL-RETURN-CODE   
                       MOVE WS-NO               TO WS-INSERT-BATCH-FLAG 
                   END-IF                                               
               END-IF                                                   
                                                                        
               IF WS-INSERT-BATCH-FLAG = WS-YES                         
                   PERFORM 2300-INITIALIZE-HOST-VARIABLES               
                                                THRU 2300-EXIT          
                                                                        
                   PERFORM 7500-INSERT-CASHDRWR THRU 7500-EXIT          
               END-IF                                                   
           END-IF.                                                      
                                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INITIALIZE HOST VARIABLES.                                  *           
      ***************************************************************           
                                                                        
       2250-INITIALIZE-HOST.                                            
                                                                        
           MOVE '2250'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           MOVE    WS-ACTIVE-CODE               TO YR-STATUS.           
           PERFORM 7700-GET-CURRENT-TIMESTAMP   THRU 7700-EXIT.         
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INITIALIZE HOST VARIABLES.                                  *           
      ***************************************************************           
                                                                        
       2300-INITIALIZE-HOST-VARIABLES.                                  
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
           INITIALIZE CS-CASH-DRAWER-ID.                                
                                                                        
           PERFORM 7300-SELECT-CASHDRAWERID     THRU 7300-EXIT.         
           ADD  WS-ONE                          TO CS-CASH-DRAWER-ID.   
                                                                        
           INITIALIZE CS-CODE-PYMT-FACILITY                             
           PERFORM 7400-SELECT-PYMTFACLTY       THRU 7400-EXIT          
                                                                        
           MOVE WS-NO                           TO CS-CODE-FCS-EXTRACTED
                                                                        
           INITIALIZE  CS-AMT-CASH-DEBIT,                               
                       CS-AMT-CASH-CREDIT,                              
                       CS-AMT-AR-DEBIT,                                 
                       CS-AMT-AR-CREDIT,                                
                       CS-AMT-CK-ISS-DEBIT,                             
                       CS-AMT-CK-ISS-CREDIT,                            
                       CS-AMT-GL-DEBIT,                                 
                       CS-AMT-GL-CREDIT,                                
                       CS-NO-ITEMS-ENTERED.                             
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *  7000-SELECT-CASHIER                                        *           
      ***************************************************************           
       7000-SELECT-CASHIER.                                             
           EXEC SQL                                                     
              SELECT USER_ID,                                           
                     CASH_LOCAL_OFFICE                                  
              INTO   :Y1-USER-ID,                                       
                     :WS-CASH-LOCAL-OFFICE                              
              FROM CSS_CASHIER WITH(READUNCOMMITTED)                            
              WHERE USER_ID  =:PARM-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*       SELECT USER_ID,                                           04950000
MFA-TR*              CASH_LOCAL_OFFICE                                  04950000
MFA-TR*       INTO   :Y1-USER-ID,                                       04950000
MFA-TR*              :WS-CASH-LOCAL-OFFICE                              04950000
MFA-TR*       FROM CSS_CASHIER                                          04950000
MFA-TR*       WHERE USER_ID  =:PARM-USER-ID                             04950000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    04950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CASHIER'               TO TABLE-1              
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-1      
               MOVE 'USER_ID'                   TO TABLE-ELEMENT-2      
               MOVE PARM-LOCAL-OFFICE           TO HOSTVAR-ELEMENT-1    
               MOVE PARM-USER-ID                TO HOSTVAR-ELEMENT-2    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *  7000A-UPDATE-CASHIER                                       *           
      *   IF CASHIER OFFICE IS CHANGED UPDATE CASHIER TABLE WITH    *           
      *   NEW OFFICE                                                *           
      ***************************************************************           
       7000A-UPDATE-CASHIER.                                            
                                                                        
           MOVE '7000A'                         TO ACTIVE-PARAGRAPH.    
           EXEC SQL                                                     
              UPDATE CSS_CASHIER                                        
              SET    CASH_LOCAL_OFFICE   = :PARM-LOCAL-OFFICE           
                    ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()            
                    ,LAST_UPDATE_USERID  = :PARM-USER-ID                
              WHERE  USER_ID             = :PARM-USER-ID                
                AND CASH_COMPANY_NO      = '01'                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CASHIER                                                
MFA-TR*       SET    CASH_LOCAL_OFFICE   = :PARM-LOCAL-OFFICE                   
MFA-TR*             ,LAST_UPDATE_TS      = CURRENT TIMESTAMP                    
MFA-TR*             ,LAST_UPDATE_USERID  = :PARM-USER-ID                        
MFA-TR*       WHERE  USER_ID             = :PARM-USER-ID                        
MFA-TR*         AND CASH_COMPANY_NO      = '01'                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'UPDATE'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CASHIER'               TO TABLE-1              
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-1      
               MOVE 'USER_ID'                   TO TABLE-ELEMENT-2      
               MOVE PARM-LOCAL-OFFICE           TO HOSTVAR-ELEMENT-1    
               MOVE PARM-USER-ID                TO HOSTVAR-ELEMENT-2    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
       7000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * SELECT THE COUNT OF CSS_CSH_REPORT_HDR FOR REPORT DATE      *           
      ***************************************************************           
                                                                        
       7100-SELECT-STATUS.                                              
                                                                        
           MOVE '7100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             SELECT :WS-YES,                                            
                    STATUS                                              
             INTO   :WS-CSH-RPT-HDR-FLAG,                               
                    :WS-CSH-RPT-HDR-STATUS                              
             FROM   CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
             WHERE  CASH_COMPANY_NO      = :YR-CASH-COMPANY-NO          
             AND    CASH_LOCAL_OFFICE    = :YR-CASH-LOCAL-OFFICE        
             AND    DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )         
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT :WS-YES,                                                    
MFA-TR*             STATUS                                                      
MFA-TR*      INTO   :WS-CSH-RPT-HDR-FLAG,                                       
MFA-TR*             :WS-CSH-RPT-HDR-STATUS                                      
MFA-TR*      FROM   CSS_CSH_REPORT_HDR                                  70000   
MFA-TR*      WHERE  CASH_COMPANY_NO      = :YR-CASH-COMPANY-NO                  
MFA-TR*      AND    CASH_LOCAL_OFFICE    = :YR-CASH-LOCAL-OFFICE                
MFA-TR*      AND    DATE_CASH_REPORT     = :YR-DATE-CASH-REPORT                 
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_REPORT_HDR'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE YR-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YR-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YR-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT INTO CSS_CSH_REPORT_HDR                              *           
      ***************************************************************           
                                                                        
       7200-INSERT-CASHREPORT.                                          
                                                                        
           MOVE '7200'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CSH_REPORT_HDR                            
                (                                                       
                          CASH_COMPANY_NO,                              
                          CASH_LOCAL_OFFICE,                            
                          DATE_CASH_REPORT,                             
                          USER_ID,                                      
                          STATUS,                                       
                          CLOSED_TS                                     
                )                                                       
              VALUES                                                    
                (                                                       
                          :YR-CASH-COMPANY-NO,                          
                          :YR-CASH-LOCAL-OFFICE,                        
                          IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) ),                        
                          :YR-USER-ID,                                  
                          :YR-STATUS,                                   
                          CIS.CHAR2TIMESTAMP(:YR-CLOSED-TS)                     
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CSH_REPORT_HDR                                    
MFA-TR*         (                                                               
MFA-TR*                   CASH_COMPANY_NO,                                      
MFA-TR*                   CASH_LOCAL_OFFICE,                                    
MFA-TR*                   DATE_CASH_REPORT,                                     
MFA-TR*                   USER_ID,                                              
MFA-TR*                   STATUS,                                               
MFA-TR*                   CLOSED_TS                                             
MFA-TR*         )                                                               
MFA-TR*       VALUES                                                            
MFA-TR*         (                                                               
MFA-TR*                   :YR-CASH-COMPANY-NO,                                  
MFA-TR*                   :YR-CASH-LOCAL-OFFICE,                                
MFA-TR*                   :YR-DATE-CASH-REPORT,                                 
MFA-TR*                   :YR-USER-ID,                                          
MFA-TR*                   :YR-STATUS,                                           
MFA-TR*                   :YR-CLOSED-TS                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'INSERT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_REPORT_HDR'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE 'USER_ID'                   TO TABLE-ELEMENT-4      
               MOVE YR-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YR-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YR-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
               MOVE YR-USER-ID                  TO HOSTVAR-ELEMENT-4    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * DETERMINE BATCH NUMBER.                                     *           
      ***************************************************************           
                                                                        
       7300-SELECT-CASHDRAWERID.                                        
                                                                        
           MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CASH_DRAWER_ID)                                 
             INTO   :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1               
             FROM   CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
             WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO           
             AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE         
             AND    DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
             AND    CASH_DRAWER_ID      < 9000                          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(CASH_DRAWER_ID)                                         
MFA-TR*      INTO   :CS-CASH-DRAWER-ID:WS-NULL-INDICATOR1                       
MFA-TR*      FROM   CSS_CSH_DRWR_CNTL                                   70000   
MFA-TR*      WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO                   
MFA-TR*      AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*      AND    DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT                  
MFA-TR*      AND    CASH_DRAWER_ID      < 9000                                  
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF  WS-NULL-INDICATOR1 < ZERO                            
                   MOVE 0                       TO CS-CASH-DRAWER-ID    
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_DRWR_CNTL'         TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * GET CODE PAYMENT FACILITY FROM CASH PC ID TABLE             *           
      ***************************************************************           
                                                                        
       7400-SELECT-PYMTFACLTY.                                          
                                                                        
           MOVE '7400'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                                                                        
             SELECT CODE_PYMT_FACILITY                                  
             INTO   :CS-CODE-PYMT-FACILITY                              
             FROM   CSS_CASH_PC_ID WITH(READUNCOMMITTED)                        
             WHERE  CASH_COMPANY_NO     = :Y3-CASH-COMPANY-NO           
             AND    CASH_LOCAL_OFFICE   = :Y3-CASH-LOCAL-OFFICE         
             AND    CASH_PC_ID          = :Y3-CASH-PC-ID                
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      SELECT CODE_PYMT_FACILITY                                          
MFA-TR*      INTO   :CS-CODE-PYMT-FACILITY                                      
MFA-TR*      FROM   CSS_CASH_PC_ID                                              
MFA-TR*      WHERE  CASH_COMPANY_NO     = :Y3-CASH-COMPANY-NO                   
MFA-TR*      AND    CASH_LOCAL_OFFICE   = :Y3-CASH-LOCAL-OFFICE                 
MFA-TR*      AND    CASH_PC_ID          = :Y3-CASH-PC-ID                        
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT CODE_PYMT'          TO ABEND-FUNCTION       
               MOVE 'CSS_CASH_PC_ID'            TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'CASH_PC_ID'                TO TABLE-ELEMENT-3      
               MOVE Y3-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE Y3-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE Y3-CASH-PC-ID               TO HOSTVAR-ELEMENT-3    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT NEW BATCH INTO CASH DRAWER CNTL.                     *           
      ***************************************************************           
                                                                        
       7500-INSERT-CASHDRWR.                                            
                                                                        
           MOVE '7500'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL(                             
                         CASH_COMPANY_NO,                               
                         CASH_LOCAL_OFFICE,                             
                         CASH_REPORT_NO,                                
                         DATE_CASH_REPORT,                              
                         CASH_DRAWER_ID,                                
                         AMT_CASH_DEBIT,                                
                         AMT_CASH_CREDIT,                               
                         AMT_AR_DEBIT,                                  
                         AMT_AR_CREDIT,                                 
                         AMT_CK_ISS_DEBIT,                              
                         AMT_CK_ISS_CREDIT,                             
                         AMT_GL_DEBIT,                                  
                         AMT_GL_CREDIT,                                 
                         AMT_CASH_BEGIN_BAL,                            
                         AMT_BASIC_WORK,                                
                         USER_ID,                                       
                         CASHIER_CODE,                                  
                         CODE_PYMT_FACILITY,                            
                         CODE_FCS_EXTRACTED,                            
                         CODE_CSH_DRWR_STAT,                            
                         DATE_LAST_ACTIVITY,                            
                         NO_ITEMS_ENTERED)                              
             VALUES(                                                    
                         :CS-CASH-COMPANY-NO,                           
                         :CS-CASH-LOCAL-OFFICE,                         
                         :CS-CASH-REPORT-NO,                            
                         IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) ),                        
                         :CS-CASH-DRAWER-ID,                            
                         :CS-AMT-CASH-DEBIT,                            
                         :CS-AMT-CASH-CREDIT,                           
                         :CS-AMT-AR-DEBIT,                              
                         :CS-AMT-AR-CREDIT,                             
                         :CS-AMT-CK-ISS-DEBIT,                          
                         :CS-AMT-CK-ISS-CREDIT,                         
                         :CS-AMT-GL-DEBIT,                              
                         :CS-AMT-GL-CREDIT,                             
                         :CS-AMT-CASH-BEGIN-BAL,                        
                         :CS-AMT-BASIC-WORK,                            
                         :CS-USER-ID,                                   
                         :CS-CASHIER-CODE,                              
                         :CS-CODE-PYMT-FACILITY,                        
                         :CS-CODE-FCS-EXTRACTED,                        
                         :CS-CODE-CSH-DRWR-STAT,                        
                         IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),                      
                         :CS-NO-ITEMS-ENTERED)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL(                                     
MFA-TR*                  CASH_COMPANY_NO,                                       
MFA-TR*                  CASH_LOCAL_OFFICE,                                     
MFA-TR*                  CASH_REPORT_NO,                                        
MFA-TR*                  DATE_CASH_REPORT,                                      
MFA-TR*                  CASH_DRAWER_ID,                                        
MFA-TR*                  AMT_CASH_DEBIT,                                        
MFA-TR*                  AMT_CASH_CREDIT,                                       
MFA-TR*                  AMT_AR_DEBIT,                                          
MFA-TR*                  AMT_AR_CREDIT,                                         
MFA-TR*                  AMT_CK_ISS_DEBIT,                                      
MFA-TR*                  AMT_CK_ISS_CREDIT,                                     
MFA-TR*                  AMT_GL_DEBIT,                                          
MFA-TR*                  AMT_GL_CREDIT,                                         
MFA-TR*                  AMT_CASH_BEGIN_BAL,                                    
MFA-TR*                  AMT_BASIC_WORK,                                        
MFA-TR*                  USER_ID,                                               
MFA-TR*                  CASHIER_CODE,                                          
MFA-TR*                  CODE_PYMT_FACILITY,                                    
MFA-TR*                  CODE_FCS_EXTRACTED,                                    
MFA-TR*                  CODE_CSH_DRWR_STAT,                                    
MFA-TR*                  DATE_LAST_ACTIVITY,                                    
MFA-TR*                  NO_ITEMS_ENTERED)                                      
MFA-TR*      VALUES(                                                            
MFA-TR*                  :CS-CASH-COMPANY-NO,                                   
MFA-TR*                  :CS-CASH-LOCAL-OFFICE,                                 
MFA-TR*                  :CS-CASH-REPORT-NO,                                    
MFA-TR*                  :CS-DATE-CASH-REPORT,                                  
MFA-TR*                  :CS-CASH-DRAWER-ID,                                    
MFA-TR*                  :CS-AMT-CASH-DEBIT,                                    
MFA-TR*                  :CS-AMT-CASH-CREDIT,                                   
MFA-TR*                  :CS-AMT-AR-DEBIT,                                      
MFA-TR*                  :CS-AMT-AR-CREDIT,                                     
MFA-TR*                  :CS-AMT-CK-ISS-DEBIT,                                  
MFA-TR*                  :CS-AMT-CK-ISS-CREDIT,                                 
MFA-TR*                  :CS-AMT-GL-DEBIT,                                      
MFA-TR*                  :CS-AMT-GL-CREDIT,                                     
MFA-TR*                  :CS-AMT-CASH-BEGIN-BAL,                                
MFA-TR*                  :CS-AMT-BASIC-WORK,                                    
MFA-TR*                  :CS-USER-ID,                                           
MFA-TR*                  :CS-CASHIER-CODE,                                      
MFA-TR*                  :CS-CODE-PYMT-FACILITY,                                
MFA-TR*                  :CS-CODE-FCS-EXTRACTED,                                
MFA-TR*                  :CS-CODE-CSH-DRWR-STAT,                                
MFA-TR*                  :CS-DATE-LAST-ACTIVITY,                                
MFA-TR*                  :CS-NO-ITEMS-ENTERED)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'INSERT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_DRWR_CNTL'         TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-4      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE CS-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3    
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7700-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :YR-CLOSED-TS                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :YR-CLOSED-TS = CURRENT TIMESTAMP                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE        
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE '7700'                      TO ACTIVE-PARAGRAPH     
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SET'                       TO ABEND-FUNCTION       
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
              EXEC SQL                                                          
                 INCLUDE CPD0023C                                               
              END-EXEC.                                                         
                                                                        
      ******************************************************************        
      **7999-SELECT-AL                                                 *        
      ******************************************************************        
              EXEC SQL                                                          
                 INCLUDE CPD00075                                               
              END-EXEC.                                                         
                                                                        
     *******************************************************************12310000
     **8000A-DELETE-GTT-ROWS.                                          *12320000
     *******************************************************************12330000
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
                DELETE FROM #CSR04752_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04752_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE '8000A'               TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                                ABEND-TABLES            
               MOVE 'CSR04752_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
     *                                                                  
     ****************************************************************   12310000
     **8100-SEND-RESULT.                                             *  12320000
     ****************************************************************   12330000
       8100-SEND-RESULT.                                                
     *                                                                  
           EXEC SQL                                                     
                INSERT INTO #CSR04752_R1                         
                (                                                       
                      RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                )                                                       
                VALUES                                                  
                (                                                       
                      :S-RETURN-CODE                                    
                     ,:S-APPL-RETURN-CODE                               
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04752_R1                                 
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-APPL-RETURN-CODE                                       
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

     *                                                                  
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
     *                                                                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR04752_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16263003
      ** 9900- JOURNALING / ERROR HANDLING INCLUDE *                    16265003
      ****************************************************************  16267003
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ****************************************************************  16310003
      *       END PROGRAM COPYLIB                                       16330003
      ****************************************************************  16360003
      *COPY CPD00302.                                                   16361003
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
