       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04746.                                         
COB303 DATE-WRITTEN.  APRIL 10, 2014.                                   
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  CSR04746 :                                                             
      *                                                                         
      *  #  THIS STORED PROCEDURE IS PERFORM INSERT,UPDATE AND                  
      *     DELETE FOR BILL CONTRACT SCREEN.                                    
      *                                                                         
      *     CLONED FROM CSR02115.                                               
      *                                                                         
      *  INSERT:                                                                
      *     1. INSERT NEW ROW IN CSS_BILL_CONTRACT TABLE.                       
      *     2. INSERT TRANSACTION HISTORY FOR THE INSERTED ROW.                 
      *                                                                         
      *  UPDATE:                                                                
      *     1. UPDATE THE EXISTING ROW IN CSS_BILL_CONTRACT TABLE.              
      *     2. INSERT TRANSACTION HISTORY FOR THE UPDATEED ROW.                 
      *                                                                         
      *  DELETE:                                                                
      *     1. DELETE A RECORD FROM CSS_BILL_CONTRACT.                          
      *                                                                         
      *****************************************************************         
      *--                                                                       
      *--  PARAMETERS                                                           
      *--                                                                       
      *--      INPUT                                                            
      *--             I_ACTION_CODE        CHAR(1)                              
      *--             I_ACCOUNT_NO         CHAR(13)                             
      *--             I_CODE_UTIL_TYPE     CHAR(01)                             
      *--             I_IC_NO              CHAR(04)                             
      *--             I_CNTRCT_START_DT    CHAR(10)                             
      *--             I_CNTRCT_END_DT      CHAR(10)                             
      *--             I_CONTRACT_DEMAND    CHAR(11)                             
      *--             I_BUILD_UP_MONTHS    CHAR(04)                             
      *--             I_SPCL_MO_MIN_AM     CHAR(7)                              
      *--             I_SPCL_ANN_MIN_AM    CHAR(11)                             
      *--             I_ANN_MIN_TYPE_CD    CHAR(1)                              
      *--             I_CBL_REF_RATE_PLN   CHAR(3)                              
      *--             I_COMP_RATE_PLAN     CHAR(3)                              
      *--             I_COMPARE_TYPE_CD    CHAR(1)                              
      *--             I_LFTM_HI_PEAK_DMD   CHAR(7)                              
      *--             I_DATE_LFTM_HI_DMD   CHAR(10)                             
      *--             I_DEFAULT_SUPPLY     CHAR(01)                             
      *--             I_DEM_CNSLDTN_CD     CHAR(01)                             
      *--             I_FIRM_PER_HR_KWH    CHAR(11)                             
      *--             I_USER_ID            CHAR(7)                              
      *--             I_CONTRACT_TERM_CD   CHAR(01)                             
      *--             I_ANN_REVIEW_MONTH   CHAR(02)                             
      *--             I_ALL_RATES_FLAG     CHAR(01)                             
      *--             I_CONTRACT_ECON_DEM  CHAR(07)                             
      *--             I_MAX_ECON_DEM       CHAR(07)                             
      *--             I_DELETE_ALL_RATE_FL CHAR(01)                             
      *--             I_PRTY_SVC_CAT_CD    CHAR(02)                             
      *--      OUT                                                              
      *--                                                                       
      *--            NONE                                                       
      *--                                                                       
      *--      INOUT                                                            
      *--                                                                       
      *--            NONE                                                       
      *--                                                                       
      *--      RESULT SET                                                       
      *--                                                                       
      *--             RETURN_CODE         INTEGER                               
      *--             APPL_RETURN_CODE    INTEGER                               
      *--             BUS_RULE_ID         CHAR(10)                              
      *--             BUS_RULE_RESULT_CD  CHAR(01)                              
      *--             BUS_RULE_XREF_ID    CHAR(26)                              
      *--                                                                       
      *                                                                         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
P00801*  04/10/14  AS7C117    INITIAL VERSION.                                  
A05136*  01/28/2015 MR7E794   FOR TABLE CSS_ALTN_FUEL_SPLY ADDED                
A05136*              ACT024   TRANSACTION HISTORY TABLES UPDATE LOGIC           
      *                                                                         
      *****************************************************************         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04746'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04746 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILL_CONTRACT  BK                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MNT_TRANS_HIST  MH                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MT_TRN_HST_DET  MI                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_USER_PROFILE  PF                                                 
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_ALTN_FUEL_SPLY  AK                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBALTSPY                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_BILL_CNTR_HIST  BX                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBBLCNTH                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_RATE_PLAN_DESC  RD                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT    UT                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_PRTY_SVC_CAT    Z4                                               
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
                                                                        
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04746'.     
           05  WS-GAS                   PIC X(01) VALUE 'G'.            
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE ZERO.           
           05  WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE 0.      
           05  WS-CODE-UTIL-TYPE        PIC X(1) VALUE SPACES.          
           05  WS-IC-NO                 PIC 9(4) VALUE ZERO.            
           05  WS-IC-NO-NUM             PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-NEW-CNTRCT-START-DT   PIC X(10) VALUE SPACES.         
           05  WS-EXISTING-CNT-START-DT PIC X(10) VALUE SPACES.         
           05  WS-CNTRCT-END-DT         PIC X(10) VALUE SPACES.         
           05  WS-ACC-NUM-TMP           PIC S9(13) COMP-3 VALUE 0.      
           05  WS-CODE-TYPE-TMP         PIC X(1) VALUE SPACES.          
           05  WS-IC-NO-TMP             PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-CNT-ST-DT-TMP         PIC X(10) VALUE SPACES.         
           05  WS-CNT-ND-DT-TMP         PIC X(10) VALUE SPACES.         
           05  WS-MINUS-ONE-DAY         PIC X(10).                      
           05  WS-CONTRACT-DEMAND-C     PIC X(11).                      
           05  WS-CONTRACT-DEMAND-N     REDEFINES WS-CONTRACT-DEMAND-C  
                                        PIC 9(09)V99.                   
COB305     05 WS-CONTRACT-DEMAND        PIC S9(07)V99 COMP-3 VALUE 0.           
           05  WS-CONTRACT-DEMAND-X     PIC ZZZZZZZZ9.99.               
           05  WS-BUILD-UP-MONTHS       PIC 9(4) VALUE 0.               
           05  WS-BUILD-UP-MONTHS-NUM   PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-BUILD-UP-MONTHS-X     PIC ZZZ9.                       
           05  WS-SPCL-MO-MIN-AM-C      PIC X(7).                       
           05  WS-SPCL-MO-MIN-AM-N      REDEFINES WS-SPCL-MO-MIN-AM-C   
                                        PIC 9(05)V99.                   
COB305     05 WS-SPCL-MO-MIN-AM        PIC S9(05)V99 COMP-3 VALUE 0.           
           05  WS-SPCL-MO-MIN-AM-X      PIC ZZZZ9.99.                   
           05  WS-SPCL-ANN-MIN-AM-C     PIC X(11).                      
           05  WS-SPCL-ANN-MIN-AM-N     REDEFINES WS-SPCL-ANN-MIN-AM-C  
                                        PIC 9(09)V99.                   
COB305     05 WS-SPCL-ANN-MIN-AM        PIC S9(09)V99 COMP-3 VALUE 0.           
           05  WS-SPCL-ANN-MIN-AM-X     PIC ZZZZZZZZ9.99.               
           05  WS-ANN-MIN-TYPE-CD       PIC X(1).                       
           05  WS-CBL-REF-RATE-PLN      PIC X(3).                       
           05  WS-COMP-RATE-PLAN        PIC X(3).                       
           05  WS-COMPARE-TYPE-CD       PIC X(1).                       
COB305     05 WS-CODE-CURTAIL-PRTY        PIC S9(2)V9(1) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CODE-CURTAIL-PRTY-X   PIC ZZ9.9.                      
           05  WS-LFTM-HI-PEAK-DMD-C    PIC X(7).                       
           05  WS-LFTM-HI-PEAK-DMD-N    REDEFINES WS-LFTM-HI-PEAK-DMD-C 
                                        PIC 9(07)V.                     
COB305     05 WS-LFTM-HI-PEAK-DMD        PIC S9(07)V COMP-3 VALUE 0.            
           05  WS-LFTM-HI-PEAK-DMD-X    PIC ZZZZZZ9.99.                 
           05  WS-MAX-ECON-DEM-C        PIC X(7).                       
           05  WS-MAX-ECON-DEM-N        REDEFINES WS-MAX-ECON-DEM-C     
                                        PIC 9(07)V.                     
COB305     05 WS-MAX-ECON-DEM        PIC S9(07)V COMP-3 VALUE 0.             
           05  WS-MAX-ECON-DEM-X        PIC ZZZZZZ9.99.                 
           05  WS-CONTRACT-ECON-DEM-C   PIC X(7).                       
           05  WS-CONTRACT-ECON-DEM-N   REDEFINES WS-CONTRACT-ECON-DEM-C
                                        PIC 9(07)V.                     
COB305     05 WS-CONTRACT-ECON-DEM        PIC S9(07)V COMP-3 VALUE 0.           
           05  WS-CONTRACT-ECON-DEM-X   PIC ZZZZZZ9.99.                 
           05  WS-FIRM-PER-HR-KWH-C     PIC X(11).                      
           05  WS-FIRM-PER-HR-KWH-N     REDEFINES WS-FIRM-PER-HR-KWH-C  
                                        PIC 9(09)V99.                   
COB305     05 WS-FIRM-PER-HR-KWH        PIC S9(07)V99 COMP-3 VALUE 0.           
           05  WS-FIRM-PER-HR-KWH-X     PIC ZZZZZZZZ9.99.               
           05  WS-DATE-LFTM-HI-DMD      PIC X(10).                      
           05  WS-TRAN-APPL-NO          PIC 9(02) VALUE ZERO.           
           05  WS-DEFAULT-SUPPLY        PIC X(1).                       
           05  WS-NEGOTIATED            PIC X(1)  VALUE 'N'.            
           05  WS-TRANSPORTATION        PIC X(1)  VALUE 'T'.            
           05  WS-FAILED                PIC X(1)  VALUE 'F'.            
           05  WS-BUS-RULE-ID           PIC X(10) VALUE 'BCNTRCT008'.   
           05  WS-DEM-CNSLDTN-CD        PIC X(1).                       
           05  WS-USER-ID               PIC X(7).                       
           05  WS-RESP-AREA-ID          PIC X(3).                       
           05  WS-DATE-NI               PIC S9(4) COMP VALUE 0.         
           05  WS-COMMENT-LEN-NUM       PIC S9(4) USAGE COMP VALUE 210. 
           05  WS-ALTN-FUEL-SPLY-CD     PIC X(1).                       
           05  WS-PSNC                  PIC X(02) VALUE '26'.           
           05  WS-ALT-SPLY-RATE-NO      PIC X(3).                       
           05  WS-ALT-SPLY-REV-CL-CD    PIC X(3).                       
           05  WS-FUEL-SHIPPER-CD       PIC X(1).                       
           05  WS-ALTERNATE-FUEL-CD     PIC X(1).                       
           05  WS-CONTRACT-TERM-CD      PIC X(01) VALUE SPACES.         
           05  WS-ANN-REVIEW-MONTH      PIC X(02) VALUE SPACES.         
           05  WS-ALL-RATES-FLAG        PIC X(01) VALUE SPACES.         
           05  WS-RATE-PLAN-NO          PIC X(03) VALUE SPACES.         
           05  WS-RATE-DESC             PIC X(50) VALUE SPACES.         
           05  WS-ACTION-CODE           PIC X(01) VALUE SPACES.         
               88 WS-INSERT                       VALUE 'I'.            
               88 WS-UPDATE                       VALUE 'U'.            
               88 WS-DELETE                       VALUE 'D'.            
           05  WS-COMMENT-TEXT.                                         
               10 WS-TEXT-1             PIC X(15) VALUE                 
                  'CONTRACT PROV -'.                                    
               10 WS-COM-CONTRACT-NO    PIC X(13) VALUE SPACES.         
               10 WS-TEXT-2             PIC X(20) VALUE                 
                  'CONTRACT START DATE:'.                               
               10 WS-COM-CONTRACT-DATE  PIC X(10) VALUE SPACES.         
               10 WS-TEXT-3             PIC X(10) VALUE SPACES.         
               10 WS-COM-IC-NO          PIC X(04) VALUE SPACES.         
               10 WS-TEXT-4             PIC X(01) VALUE ','.            
               10 WS-COM-RATE-PLAN-NO   PIC X(03) VALUE SPACES.         
               10 WS-TEXT-5             PIC X(01) VALUE '-'.            
               10 WS-COM-RATE-DESC      PIC X(50) VALUE SPACES.         
               10 FILLER                PIC X(65) VALUE SPACES.         
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  CONTRACT-EXISTS-SW       PIC X(01) VALUE 'N'.            
               88 CONTRACT-EXISTS                 VALUE 'Y'.            
               88 CONTRACT-NOT-EXISTS             VALUE 'N'.            
ACT024     05  WS-COMMENT-TXT.                                          
ACT024         10  WS-COM-TXT-IN          PIC X(42)  VALUE              
ACT024            'MAINTENANCE FOR ALT FUEL SUPPLY - CSR04746'.         
ACT024         10  WS-COM-BLNK-IN         PIC X(168) VALUE SPACES.      
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR JOURNALING                                 *        
      ******************************************************************        
       01  MNT-TRANSACTION-STORAGE.                                     
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(9) COMP VALUE 0.          
           05  S-BUS-RULE-ID           PIC X(10) VALUE SPACES.          
           05  S-BUS-RULE-RESULT-CD    PIC X(01) VALUE SPACES.          
           05  S-BUS-RULE-XREF-ID      PIC X(26) VALUE SPACES.          
                                                                        
      *****************************************************************         
      * DECLARE CURSOR FOR ALTERNATE FUEL SUPPLY                      *         
      *****************************************************************         
                                                                        
           EXEC SQL DECLARE FU-CURSOR CURSOR FOR                        
              SELECT  ALTN_FUEL_SPLY_CD                                 
                     ,ALT_SPLY_RATE_NO                                  
                     ,ALT_SPLY_REV_CL_CD                                
                     ,FUEL_SHIPPER_CD                                   
                     ,CNTRCT_START_DT                                   
                     ,ALTERNATE_FUEL_CD                                 
                FROM CSS_ALTN_FUEL_SPLY AK WITH(READUNCOMMITTED)                
               WHERE AK.ACCOUNT_NO        =  :WS-ACCOUNT-NO-NUM         
                 AND AK.CODE_UTIL_TYPE    =  :WS-CODE-UTIL-TYPE         
                 AND AK.ALTN_FUEL_SPLY_CD IN ('N','T')                  
                 AND AK.CNTRCT_START_DT   =                             
                     (SELECT MAX(CNTRCT_START_DT)                       
                        FROM CSS_ALTN_FUEL_SPLY A1 WITH(READUNCOMMITTED)        
                       WHERE A1.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM    
                         AND A1.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE)   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE FU-CURSOR CURSOR FOR                                
MFA-TR*       SELECT  ALTN_FUEL_SPLY_CD                                         
MFA-TR*              ,ALT_SPLY_RATE_NO                                          
MFA-TR*              ,ALT_SPLY_REV_CL_CD                                        
MFA-TR*              ,FUEL_SHIPPER_CD                                           
MFA-TR*              ,CNTRCT_START_DT                                           
MFA-TR*              ,ALTERNATE_FUEL_CD                                         
MFA-TR*         FROM CSS_ALTN_FUEL_SPLY AK                                      
MFA-TR*        WHERE AK.ACCOUNT_NO        =  :WS-ACCOUNT-NO-NUM                 
MFA-TR*          AND AK.CODE_UTIL_TYPE    =  :WS-CODE-UTIL-TYPE                 
MFA-TR*          AND AK.ALTN_FUEL_SPLY_CD IN ('N','T')                          
MFA-TR*          AND AK.CNTRCT_START_DT   =                                     
MFA-TR*              (SELECT MAX(CNTRCT_START_DT)                               
MFA-TR*                 FROM CSS_ALTN_FUEL_SPLY A1                              
MFA-TR*                WHERE A1.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM            
MFA-TR*                  AND A1.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE)           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7710                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * DECLARE CURSOR FOR RATE PLANS                                 *         
      *****************************************************************         
                                                                        
           EXEC SQL DECLARE RT-CURSOR CURSOR FOR                        
              SELECT IC_NO                                              
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM          
                 AND UT.CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE          
                 AND UT.IC_NO            != :WS-IC-NO-NUM               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE RT-CURSOR CURSOR FOR                                
MFA-TR*       SELECT IC_NO                                                      
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM                  
MFA-TR*          AND UT.CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                  
MFA-TR*          AND UT.IC_NO            != :WS-IC-NO-NUM                       
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7610                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACTION-CODE         PIC X(1)                 .          
       01  PARM-ACCOUNT-NO          PIC X(13)                .          
       01  PARM-CODE-UTIL-TYPE      PIC X(01)                .          
       01  PARM-IC-NO               PIC X(04)                .          
       01  PARM-CNTRCT-START-DT     PIC X(10)                .          
       01  PARM-CNTRCT-END-DT       PIC X(10)                .          
       01  PARM-CONTRACT-DEMAND     PIC X(11)                .          
       01  PARM-BUILD-UP-MONTHS     PIC X(04)                .          
       01  PARM-SPCL-MO-MIN-AM      PIC X(7)                 .          
       01  PARM-SPCL-ANN-MIN-AM     PIC X(11)                .          
       01  PARM-ANN-MIN-TYPE-CD     PIC X(1)                 .          
       01  PARM-CBL-REF-RATE-PLN    PIC X(3)                 .          
       01  PARM-COMP-RATE-PLAN      PIC X(3)                 .          
       01  PARM-COMPARE-TYPE-CD     PIC X(1)                 .          
       01  PARM-LFTM-HI-PEAK-DMD    PIC X(7)                 .          
       01  PARM-DATE-LFTM-HI-DMD    PIC X(10)                .          
       01  PARM-DEFAULT-SUPPLY      PIC X(01)                .          
       01  PARM-DEM-CNSLDTN-CD      PIC X(01)                .          
       01  PARM-FIRM-PER-HR-KWH     PIC X(11)                .          
       01  PARM-USER-ID             PIC X(7)                 .          
       01  PARM-CONTRACT-TERM-CD    PIC X(01)                .          
       01  PARM-ANN-REVIEW-MONTH    PIC X(02)                .          
       01  PARM-ALL-RATES-FLAG      PIC X(01)                .          
       01  PARM-CONTRACT-ECON-DEM   PIC X(07)                .          
       01  PARM-MAX-ECON-DEM        PIC X(07)                .          
       01  PARM-DELETE-ALL-RATE-FL  PIC X(01)                .          
       01  PARM-PRTY-SVC-CAT-CD     PIC X(02)                .          
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-ACTION-CODE                                        
               ,PARM-ACCOUNT-NO                                         
               ,PARM-CODE-UTIL-TYPE                                     
               ,PARM-IC-NO                                              
               ,PARM-CNTRCT-START-DT                                    
               ,PARM-CNTRCT-END-DT                                      
               ,PARM-CONTRACT-DEMAND                                    
               ,PARM-BUILD-UP-MONTHS                                    
               ,PARM-SPCL-MO-MIN-AM                                     
               ,PARM-SPCL-ANN-MIN-AM                                    
               ,PARM-ANN-MIN-TYPE-CD                                    
               ,PARM-CBL-REF-RATE-PLN                                   
               ,PARM-COMP-RATE-PLAN                                     
               ,PARM-COMPARE-TYPE-CD                                    
               ,PARM-LFTM-HI-PEAK-DMD                                   
               ,PARM-DATE-LFTM-HI-DMD                                   
               ,PARM-DEFAULT-SUPPLY                                     
               ,PARM-DEM-CNSLDTN-CD                                     
               ,PARM-FIRM-PER-HR-KWH                                    
               ,PARM-USER-ID                                            
               ,PARM-CONTRACT-TERM-CD                                   
               ,PARM-ANN-REVIEW-MONTH                                   
               ,PARM-ALL-RATES-FLAG                                     
               ,PARM-CONTRACT-ECON-DEM                                  
               ,PARM-MAX-ECON-DEM                                       
               ,PARM-DELETE-ALL-RATE-FL                                 
               ,PARM-PRTY-SVC-CAT-CD                                    
               .                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. DECLARE CURSORS FOR RETURN VALUES.                               
      *                                                                         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
              SELECT :S-RETURN-CODE           AS RETURN_CODE            
                    ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE       
      *             ,:S-BUS-RULE-ID           AS BUS_RULE_ID                    
      *             ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD             
      *             ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID               
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*       SELECT :S-RETURN-CODE           AS RETURN_CODE                    
MFA-TR*             ,:S-APPL-RETURN-CODE      AS APPL_RETURN_CODE               
MFA-TR*             ,:S-BUS-RULE-ID           AS BUS_RULE_ID                    
MFA-TR*             ,:S-BUS-RULE-RESULT-CD    AS BUS_RULE_RESULT_CD             
MFA-TR*             ,:S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MAIN PROCESS INSERT/UPDATE/DELETE                           *           
      ***************************************************************           
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
                                                                        
            WHEN WS-INSERT                                              
                 PERFORM 7010-CHECK-DATE-OVERLAP      THRU 7010-EXIT    
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE WS-NEW-CNTRCT-START-DT       TO                
                                                      WS-MINUS-ONE-DAY  
                    PERFORM 7020-PREV-DAY             THRU 7020-EXIT    
                    PERFORM 7030-UPDT-PREV-CNTRCT     THRU 7030-EXIT    
                 END-IF                                                 
                 PERFORM 7500-GET-BK-INFO             THRU 7500-EXIT    
                 PERFORM 8010-INSERT-BILL-CONTRACT    THRU 8010-EXIT    
                 PERFORM 2010-OTHER-INSERT-PROCESS    THRU 2010-EXIT    
                 IF WS-ALL-RATES-FLAG = 'Y'                             
                    PERFORM 7600-INSERT-RATE-PLANS    THRU 7600-EXIT    
                 END-IF                                                 
                 PERFORM 7080-GET-COMPANY-NO          THRU 7080-EXIT    
                 IF PARM-PRTY-SVC-CAT-CD > SPACES AND                   
                    UT-COMPANY-NO  = WS-PSNC                            
                    PERFORM 2020-PROCESS-UPDATE-UTIL  THRU 2020-EXIT    
                 END-IF                                                 
            WHEN WS-UPDATE                                              
                 PERFORM 7050-CHECK-BILL-CNTRCT       THRU 7050-EXIT    
                 PERFORM 7500-GET-BK-INFO             THRU 7500-EXIT    
                 IF CONTRACT-EXISTS                                     
                    PERFORM 7060-UPDATE-BILL-CONTRACT THRU 7060-EXIT    
                 ELSE                                                   
                    PERFORM 8010-INSERT-BILL-CONTRACT THRU 8010-EXIT    
                 END-IF                                                 
                 PERFORM 2010-OTHER-INSERT-PROCESS    THRU 2010-EXIT    
                 PERFORM 7080-GET-COMPANY-NO          THRU 7080-EXIT    
                 IF PARM-PRTY-SVC-CAT-CD > SPACES  AND                  
                    UT-COMPANY-NO        = WS-PSNC                      
                    PERFORM 2020-PROCESS-UPDATE-UTIL  THRU 2020-EXIT    
                 END-IF                                                 
            WHEN WS-DELETE                                              
                 IF PARM-DELETE-ALL-RATE-FL = 'Y'                       
                    PERFORM 8030-DELETE-ALL-BILL-CONTRACT               
                                                      THRU 8030-EXIT    
                 ELSE                                                   
                    PERFORM 8020-DELETE-BILL-CONTRACT THRU 8020-EXIT    
                 END-IF                                                 
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    MOVE 200              TO WS-ACTIVE-RETURN-CODE      
      *             MOVE WS-BUS-RULE-ID   TO S-BUS-RULE-ID                      
      *             MOVE WS-FAILED        TO S-BUS-RULE-RESULT-CD               
      *             PERFORM 7900-GET-RULE-XREF-ID                               
      *                                   THRU 7900-EXIT                        
                 END-IF                                                 
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           PERFORM 8500-SEND-RESULT   THRU 8500-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * MOVE PARAMETER FIELDS INTO WORKING STORAGE                 *            
      **************************************************************            
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACTION-CODE          TO WS-ACTION-CODE.            
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE.         
           MOVE PARM-IC-NO                TO WS-IC-NO.                  
           MOVE WS-IC-NO                  TO WS-IC-NO-NUM.              
           MOVE PARM-CNTRCT-START-DT      TO WS-NEW-CNTRCT-START-DT.    
           MOVE PARM-CNTRCT-END-DT        TO WS-CNTRCT-END-DT.          
           MOVE PARM-CONTRACT-DEMAND      TO WS-CONTRACT-DEMAND-C.      
           MOVE WS-CONTRACT-DEMAND-N      TO WS-CONTRACT-DEMAND.        
           MOVE PARM-BUILD-UP-MONTHS      TO WS-BUILD-UP-MONTHS.        
           MOVE WS-BUILD-UP-MONTHS        TO WS-BUILD-UP-MONTHS-NUM.    
           MOVE PARM-SPCL-MO-MIN-AM       TO WS-SPCL-MO-MIN-AM-C.       
           MOVE WS-SPCL-MO-MIN-AM-N       TO WS-SPCL-MO-MIN-AM.         
           MOVE PARM-SPCL-ANN-MIN-AM      TO WS-SPCL-ANN-MIN-AM-C.      
           MOVE PARM-FIRM-PER-HR-KWH      TO WS-FIRM-PER-HR-KWH-C.      
           MOVE WS-FIRM-PER-HR-KWH-N      TO WS-FIRM-PER-HR-KWH.        
           MOVE WS-SPCL-ANN-MIN-AM-N      TO WS-SPCL-ANN-MIN-AM.        
           MOVE PARM-ANN-MIN-TYPE-CD      TO WS-ANN-MIN-TYPE-CD.        
           MOVE PARM-DEFAULT-SUPPLY       TO WS-DEFAULT-SUPPLY.         
           MOVE PARM-DEM-CNSLDTN-CD       TO WS-DEM-CNSLDTN-CD.         
           MOVE PARM-MAX-ECON-DEM         TO WS-MAX-ECON-DEM-C.         
           MOVE WS-MAX-ECON-DEM-N         TO WS-MAX-ECON-DEM.           
           MOVE PARM-CONTRACT-ECON-DEM    TO WS-CONTRACT-ECON-DEM-C.    
           MOVE WS-CONTRACT-ECON-DEM-N    TO WS-CONTRACT-ECON-DEM.      
           MOVE PARM-CBL-REF-RATE-PLN     TO WS-CBL-REF-RATE-PLN.       
           MOVE PARM-COMP-RATE-PLAN       TO WS-COMP-RATE-PLAN.         
           MOVE PARM-COMPARE-TYPE-CD      TO WS-COMPARE-TYPE-CD.        
           MOVE PARM-LFTM-HI-PEAK-DMD     TO WS-LFTM-HI-PEAK-DMD-C.     
           MOVE WS-LFTM-HI-PEAK-DMD-N     TO WS-LFTM-HI-PEAK-DMD.       
           MOVE PARM-DATE-LFTM-HI-DMD     TO WS-DATE-LFTM-HI-DMD.       
           MOVE PARM-USER-ID              TO WS-USER-ID.                
           MOVE PARM-CONTRACT-TERM-CD     TO WS-CONTRACT-TERM-CD.       
           MOVE PARM-ANN-REVIEW-MONTH     TO WS-ANN-REVIEW-MONTH.       
           MOVE PARM-ALL-RATES-FLAG       TO WS-ALL-RATES-FLAG.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * JOURNAL MAINTENANCE TRANSACTION HEADER                      *           
      ***************************************************************           
                                                                        
       7800-JRNL-TRAN-HEAD.                                             
                                                                        
           PERFORM 7200-SELECT-TIMESTAMP  THRU 7200-EXIT.               
           PERFORM 7300-SELECT-RESP-AREA  THRU 7300-EXIT.               
           PERFORM 7400-GET-RATE-DESC     THRU 7400-EXIT.               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE 1                         TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE WS-ACCOUNT-NO-NUM         TO MH-ACCOUNT-NO.             
           MOVE WS-RESP-AREA-ID           TO MH-RESP-AREA-ID.           
           MOVE 0                         TO MH-CUSTOMER-NO.            
           MOVE 0                         TO MH-PREMISE-NO.             
           MOVE WS-USER-ID                TO MH-USER-ID.                
           MOVE PROGRAM-NAME              TO MH-APPL-PROGRAM-ID.        
           MOVE PARM-ACCOUNT-NO           TO WS-COM-CONTRACT-NO.        
           MOVE PARM-CNTRCT-START-DT      TO WS-COM-CONTRACT-DATE.      
           IF PARM-CODE-UTIL-TYPE = 'E'                                 
              MOVE 'ELECTRIC -'           TO WS-TEXT-3                  
           END-IF                                                       
           IF PARM-CODE-UTIL-TYPE = 'G'                                 
              MOVE 'GAS -'                TO WS-TEXT-3                  
           END-IF                                                       
           MOVE PARM-IC-NO                TO WS-COM-IC-NO.              
           MOVE WS-RATE-PLAN-NO           TO WS-COM-RATE-PLAN-NO.       
           MOVE WS-RATE-DESC              TO WS-COM-RATE-DESC.          
           MOVE WS-COMMENT-LEN-NUM        TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-COMMENT-TEXT           TO MH-TRAN-COMMENT-TEXT.      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *  SELECT BILL CONTRACT INFORMATION                           *           
      ***************************************************************           
                                                                        
       7500-GET-BK-INFO.                                                
                                                                        
           PERFORM 7510-SELECT-BK-INFO  THRU 7510-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 0                    TO WS-ACTIVE-RETURN-CODE        
              MOVE SPACES               TO BK-CNTRCT-START-DT           
              MOVE SPACES               TO BK-CNTRCT-END-DT             
              MOVE 0                    TO BK-CONTRACT-DEMAND           
              MOVE 0                    TO BK-FIRM-PER-HR-KWH           
              MOVE 0                    TO BK-BUILD-UP-MONTHS           
              MOVE 0                    TO BK-SPCL-MO-MIN-AM            
              MOVE 0                    TO BK-SPCL-ANN-MIN-AM           
              MOVE 0                    TO BK-MAX-ECON-DEM              
              MOVE SPACES               TO BK-DEM-CNSLDTN-CD            
              MOVE SPACES               TO BK-DFLT-USAGE-CLS-CD         
              MOVE SPACES               TO BK-ANN-MIN-TYPE-CD           
              MOVE SPACES               TO BK-CBL-REF-RATE-PLN          
              MOVE SPACES               TO BK-COMP-RATE-PLAN            
              MOVE SPACES               TO BK-COMPARE-TYPE-CD           
              MOVE 0                    TO BK-LFTM-HI-PEAK-DMD          
              MOVE SPACES               TO BK-DATE-LFTM-HI-DMD          
              MOVE SPACES               TO BK-CONTRACT-TERM-CD          
              MOVE SPACES               TO BK-ANN-REVIEW-MONTH          
              MOVE 0                    TO BK-CONTRACT-ECON-DEM         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERTS DATA INTO TABLES                                    *           
      ***************************************************************           
                                                                        
       2010-OTHER-INSERT-PROCESS.                                       
                                                                        
           IF PARM-CODE-UTIL-TYPE = WS-GAS                              
           PERFORM 7700-INSERT-ALTERNATE-FUEL   THRU 7700-EXIT          
           END-IF                                                       
           PERFORM 7800-JRNL-TRAN-HEAD          THRU 7800-EXIT.         
           PERFORM 8300-INSERT-UPDATE-JRNL      THRU 8300-EXIT.         
                                                                        
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERTS DATA INTO TABLES                                    *           
      ***************************************************************           
                                                                        
       2020-PROCESS-UPDATE-UTIL.                                        
                                                                        
           MOVE PARM-PRTY-SVC-CAT-CD        TO Z4-PRTY-SVC-CAT-CD       
           PERFORM 7040-GET-CURTAIL-PRTY    THRU 7040-EXIT              
           MOVE Z4-CODE-CURTAIL-PRTY        TO WS-CODE-CURTAIL-PRTY     
           IF UT-CODE-CURTAIL-PRTY NOT = WS-CODE-CURTAIL-PRTY           
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              MOVE WS-CODE-CURTAIL-PRTY  TO WS-CODE-CURTAIL-PRTY-X      
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-CODE-CURTAIL-PRTY-X TO MI-CHG-COLUMN-VALUE-TEXT   
                                                                        
              MOVE UT-CODE-CURTAIL-PRTY  TO WS-CODE-CURTAIL-PRTY-X      
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE WS-CODE-CURTAIL-PRTY-X TO MI-PRV-COLUMN-VALUE-TEXT   
                                                                        
              MOVE 'CODE CURTAIL PRTY'  TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                     TO WS-TRAN-APPL-NO              
           END-IF.                                                      
           PERFORM 8200-UPDATE-UTIL-ENVRNMT THRU 8200-EXIT.             
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * JOURNAL EVERY CHANGED ENTRY FIELD                          *            
      **************************************************************            
                                                                        
       8300-INSERT-UPDATE-JRNL.                                         
                                                                        
      *****************************************************************         
      * JOURNAL CONTRACT START DATE CHANGE                            *         
      *****************************************************************         
                                                                        
           IF BK-CNTRCT-START-DT NOT = WS-NEW-CNTRCT-START-DT           
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-NEW-CNTRCT-START-DT > SPACES                        
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-NEW-CNTRCT-START-DT TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-CNTRCT-START-DT > SPACES                            
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-CNTRCT-START-DT    TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'CNTRCT START DT'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL CONTRACT END DATE CHANGE                              *         
      *****************************************************************         
                                                                        
           IF BK-CNTRCT-END-DT NOT = WS-CNTRCT-END-DT                   
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-CNTRCT-END-DT > SPACES                              
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CNTRCT-END-DT    TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-CNTRCT-END-DT > SPACES                              
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-CNTRCT-END-DT    TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'CNTRCT END DT'    TO MI-COLUMN-DESC                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL CONTRACT DEMAND CHANGE                                *         
      *****************************************************************         
                                                                        
           IF BK-CONTRACT-DEMAND NOT = WS-CONTRACT-DEMAND               
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-CONTRACT-DEMAND > 0                                 
                 MOVE WS-CONTRACT-DEMAND    TO WS-CONTRACT-DEMAND-X     
                 MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CONTRACT-DEMAND-X  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-CONTRACT-DEMAND > 0                                 
                 MOVE BK-CONTRACT-DEMAND    TO WS-CONTRACT-DEMAND-X     
                 MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-CONTRACT-DEMAND-X  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'CNTRCT DEMAND'      TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL BUILD UP MONTHS CHANGE                                *         
      *****************************************************************         
                                                                        
           IF BK-BUILD-UP-MONTHS NOT = WS-BUILD-UP-MONTHS-NUM           
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-BUILD-UP-MONTHS-NUM > 0                             
                 MOVE WS-BUILD-UP-MONTHS-NUM TO WS-BUILD-UP-MONTHS-X    
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-BUILD-UP-MONTHS-X  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-BUILD-UP-MONTHS    > 0                              
                 MOVE BK-BUILD-UP-MONTHS    TO WS-BUILD-UP-MONTHS-X     
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-BUILD-UP-MONTHS-X  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'BUILD UP MONTHS'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL MINIMUM MONTHLY AMOUNT CHANGE                         *         
      *****************************************************************         
                                                                        
           IF BK-SPCL-MO-MIN-AM  NOT = WS-SPCL-MO-MIN-AM                
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-SPCL-MO-MIN-AM  > 0                                 
                 MOVE WS-SPCL-MO-MIN-AM     TO WS-SPCL-MO-MIN-AM-X      
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-SPCL-MO-MIN-AM-X   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-SPCL-MO-MIN-AM     > 0                              
                 MOVE BK-SPCL-MO-MIN-AM     TO WS-SPCL-MO-MIN-AM-X      
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-SPCL-MO-MIN-AM-X   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'SPCL MO MIN AM' TO MI-COLUMN-DESC                   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL MINIMUM ANNUAL AMOUNT CHANGE                          *         
      *****************************************************************         
                                                                        
           IF BK-SPCL-ANN-MIN-AM  NOT = WS-SPCL-ANN-MIN-AM              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-SPCL-ANN-MIN-AM  > 0                                
                 MOVE WS-SPCL-ANN-MIN-AM    TO WS-SPCL-ANN-MIN-AM-X     
                 MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-SPCL-ANN-MIN-AM-X  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-SPCL-ANN-MIN-AM     > 0                             
                 MOVE BK-SPCL-ANN-MIN-AM    TO WS-SPCL-ANN-MIN-AM-X     
                 MOVE +11                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-SPCL-ANN-MIN-AM-X  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'SPCL ANN MIN AM' TO MI-COLUMN-DESC                  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL ANNUAL MINIMUM TYPE CODE CHANGE                       *         
      *****************************************************************         
                                                                        
           IF BK-ANN-MIN-TYPE-CD  NOT = WS-ANN-MIN-TYPE-CD              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-ANN-MIN-TYPE-CD  > SPACES                           
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-ANN-MIN-TYPE-CD    TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-ANN-MIN-TYPE-CD     > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-ANN-MIN-TYPE-CD    TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'INCL FUEL COST'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
                                                                        
      *****************************************************************         
      * JOURNAL CBL RATE PLAN CHANGE                                  *         
      *****************************************************************         
                                                                        
           IF BK-CBL-REF-RATE-PLN NOT = WS-CBL-REF-RATE-PLN             
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'RD'                     TO MI-TABLE-ID              
                                                                        
              IF WS-CBL-REF-RATE-PLN > SPACES                           
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CBL-REF-RATE-PLN   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-CBL-REF-RATE-PLN    > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-CBL-REF-RATE-PLN   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'CBL RATE PLAN'          TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      ******************************************************************        
      * JOURNAL COMPARISON RATE PLAN CHANGE                            *        
      ******************************************************************        
                                                                        
           IF BK-COMP-RATE-PLAN   NOT = WS-COMP-RATE-PLAN               
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'RD'                     TO MI-TABLE-ID              
                                                                        
              IF WS-COMP-RATE-PLAN   > SPACES                           
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-COMP-RATE-PLAN     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-COMP-RATE-PLAN      > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-COMP-RATE-PLAN     TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'COMP RATE PLAN'   TO MI-COLUMN-DESC                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL COMPARISON TYPE CODE CHANGE                           *         
      *****************************************************************         
                                                                        
           IF BK-COMPARE-TYPE-CD   NOT = WS-COMPARE-TYPE-CD             
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE '01'                     TO MI-TABLE-ID              
                                                                        
              IF WS-COMPARE-TYPE-CD  > SPACES                           
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-COMPARE-TYPE-CD    TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-COMPARE-TYPE-CD     > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-COMPARE-TYPE-CD    TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'COMPARISON TYPE'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL LIFETIME PEAK DEMAND CHANGE                           *         
      *****************************************************************         
                                                                        
           IF BK-LFTM-HI-PEAK-DMD  NOT = WS-LFTM-HI-PEAK-DMD            
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-LFTM-HI-PEAK-DMD > 0                                
                 MOVE WS-LFTM-HI-PEAK-DMD   TO WS-LFTM-HI-PEAK-DMD-X    
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-LFTM-HI-PEAK-DMD-X TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-LFTM-HI-PEAK-DMD    > 0                             
                 MOVE BK-LFTM-HI-PEAK-DMD   TO WS-LFTM-HI-PEAK-DMD-X    
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-LFTM-HI-PEAK-DMD-X TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'LFTM PEAK DEM'  TO MI-COLUMN-DESC                   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL PEAK DEMAND DATE CHANGE                               *         
      *****************************************************************         
                                                                        
           IF BK-DATE-LFTM-HI-DMD  NOT = WS-DATE-LFTM-HI-DMD            
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-DATE-LFTM-HI-DMD > SPACES                           
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-DATE-LFTM-HI-DMD   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-DATE-LFTM-HI-DMD    > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-DATE-LFTM-HI-DMD   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'PEAK DEM DATE' TO MI-COLUMN-DESC                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL DEFAULT SUPPLY                                        *         
      *****************************************************************         
                                                                        
           IF BK-DFLT-USAGE-CLS-CD NOT = WS-DEFAULT-SUPPLY              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-DEFAULT-SUPPLY  > SPACES                            
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-DEFAULT-SUPPLY     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-DFLT-USAGE-CLS-CD   > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-DFLT-USAGE-CLS-CD  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'DEFAULT SUPPLY'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL DEMAND CONSOLIDATION CODE CHANGE                      *         
      *****************************************************************         
                                                                        
           IF BK-DEM-CNSLDTN-CD  NOT = WS-DEM-CNSLDTN-CD                
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-DEM-CNSLDTN-CD  > SPACES                            
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-DEM-CNSLDTN-CD     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-DEM-CNSLDTN-CD      > SPACES                        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-DEM-CNSLDTN-CD     TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'DEM CNSLDTN CD'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL MAX ECON DEMAND                                       *         
      *****************************************************************         
                                                                        
           IF BK-MAX-ECON-DEM      NOT = WS-MAX-ECON-DEM                
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-MAX-ECON-DEM     > 0                                
                 MOVE WS-MAX-ECON-DEM       TO WS-MAX-ECON-DEM-X        
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-MAX-ECON-DEM-X     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-MAX-ECON-DEM        > 0                             
                 MOVE BK-MAX-ECON-DEM       TO WS-MAX-ECON-DEM-X        
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-MAX-ECON-DEM-X     TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'MAX ECON  DEM'  TO MI-COLUMN-DESC                   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL CONTRACT ECON DEM                                     *         
      *****************************************************************         
                                                                        
           IF BK-CONTRACT-ECON-DEM NOT = WS-CONTRACT-ECON-DEM           
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-CONTRACT-ECON-DEM > 0                               
                 MOVE WS-CONTRACT-ECON-DEM  TO WS-CONTRACT-ECON-DEM-X   
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CONTRACT-ECON-DEM-X                            
                                    TO MI-CHG-COLUMN-VALUE-TEXT         
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-CONTRACT-ECON-DEM   > 0                             
                 MOVE BK-CONTRACT-ECON-DEM  TO WS-CONTRACT-ECON-DEM-X   
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-CONTRACT-ECON-DEM-X                            
                               TO MI-PRV-COLUMN-VALUE-TEXT              
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'CONTR ECON  DEM'  TO MI-COLUMN-DESC                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL CONTRACT FIRM-PER-HR-KWH                              *         
      *****************************************************************         
                                                                        
           IF BK-FIRM-PER-HR-KWH NOT = WS-FIRM-PER-HR-KWH               
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-FIRM-PER-HR-KWH > 0                                 
                 MOVE WS-FIRM-PER-HR-KWH    TO WS-FIRM-PER-HR-KWH-X     
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-FIRM-PER-HR-KWH-X  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-CONTRACT-DEMAND > 0                                 
                 MOVE BK-FIRM-PER-HR-KWH    TO WS-FIRM-PER-HR-KWH-X     
                 MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-FIRM-PER-HR-KWH-X  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'FIRM PER HR KWH'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL CONTRACT TERM CODE                                    *         
      *****************************************************************         
                                                                        
           IF BK-CONTRACT-TERM-CD  NOT = WS-CONTRACT-TERM-CD            
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-CONTRACT-TERM-CD > SPACES                           
                 MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CONTRACT-TERM-CD   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-CONTRACT-TERM-CD    > SPACES                        
                 MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-CONTRACT-TERM-CD   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'CNTRCT TERM CD '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *****************************************************************         
      * JOURNAL ANNUAL REVIEW MONTH                                   *         
      *****************************************************************         
                                                                        
           IF BK-ANN-REVIEW-MONTH  NOT = WS-ANN-REVIEW-MONTH            
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
                                                                        
              IF WS-ANN-REVIEW-MONTH > SPACES                           
                 MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-ANN-REVIEW-MONTH   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BK-ANN-REVIEW-MONTH    > SPACES                        
                 MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BK-ANN-REVIEW-MONTH   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'ANN REVIEW MNTH'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * GETS CURRENT TIMESTAMP AND CURRENT DATE                       *         
      *****************************************************************         
       7200-SELECT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GETS RESP AREA ID                                             *         
      *****************************************************************         
       7300-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :WS-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :WS-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :WS-USER-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                              ABEND-TABLES              
              MOVE 'CSS_USER_PROFILE'   TO TABLE-1                      
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-USER-ID           TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * SELECT BILL CONTRACT INFORMATION                              *         
      *****************************************************************         
       7510-SELECT-BK-INFO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BK.CNTRCT_START_DT,
              BK.CNTRCT_END_DT,
              BK.CONTRACT_DEMAND,
              BK.BUILD_UP_MONTHS,
              BK.SPCL_MO_MIN_AM,
              BK.SPCL_ANN_MIN_AM,
              BK.ANN_MIN_TYPE_CD,
              BK.CBL_REF_RATE_PLN,
              BK.COMP_RATE_PLAN,
              BK.COMPARE_TYPE_CD,
              BK.LFTM_HI_PEAK_DMD,
              BK.DATE_LFTM_HI_DMD,
              BK.DFLT_USAGE_CLS_CD,
              BK.DEM_CNSLDTN_CD,
              BK.MAX_ECON_DEM,
              BK.CONTRACT_ECON_DEM,
              BK.FIRM_PER_HR_KWH,
              BK.CONTRACT_TERM_CD,
              BK.ANN_REVIEW_MONTH                                
                INTO :BK-CNTRCT-START-DT                                
                    ,:BK-CNTRCT-END-DT                                  
                    ,:BK-CONTRACT-DEMAND                                
                    ,:BK-BUILD-UP-MONTHS                                
                    ,:BK-SPCL-MO-MIN-AM                                 
                    ,:BK-SPCL-ANN-MIN-AM                                
                    ,:BK-ANN-MIN-TYPE-CD                                
                    ,:BK-CBL-REF-RATE-PLN                               
                    ,:BK-COMP-RATE-PLAN                                 
                    ,:BK-COMPARE-TYPE-CD                                
                    ,:BK-LFTM-HI-PEAK-DMD                               
                    ,:BK-DATE-LFTM-HI-DMD :WS-DATE-NI                    
                    ,:BK-DFLT-USAGE-CLS-CD                              
                    ,:BK-DEM-CNSLDTN-CD                                 
                    ,:BK-MAX-ECON-DEM                                   
                    ,:BK-CONTRACT-ECON-DEM                              
                    ,:BK-FIRM-PER-HR-KWH                                
                    ,:BK-CONTRACT-TERM-CD                               
                    ,:BK-ANN-REVIEW-MONTH                               
                FROM CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
               WHERE BK.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM             
                 AND BK.IC_NO          = :WS-IC-NO-NUM                  
                 AND BK.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE             
               ORDER BY CNTRCT_START_DT DESC                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BK.CNTRCT_START_DT                                         
MFA-TR*             ,BK.CNTRCT_END_DT                                           
MFA-TR*             ,BK.CONTRACT_DEMAND                                         
MFA-TR*             ,BK.BUILD_UP_MONTHS                                         
MFA-TR*             ,BK.SPCL_MO_MIN_AM                                          
MFA-TR*             ,BK.SPCL_ANN_MIN_AM                                         
MFA-TR*             ,BK.ANN_MIN_TYPE_CD                                         
MFA-TR*             ,BK.CBL_REF_RATE_PLN                                        
MFA-TR*             ,BK.COMP_RATE_PLAN                                          
MFA-TR*             ,BK.COMPARE_TYPE_CD                                         
MFA-TR*             ,BK.LFTM_HI_PEAK_DMD                                        
MFA-TR*             ,BK.DATE_LFTM_HI_DMD                                        
MFA-TR*             ,BK.DFLT_USAGE_CLS_CD                                       
MFA-TR*             ,BK.DEM_CNSLDTN_CD                                          
MFA-TR*             ,BK.MAX_ECON_DEM                                            
MFA-TR*             ,BK.CONTRACT_ECON_DEM                                       
MFA-TR*             ,BK.FIRM_PER_HR_KWH                                         
MFA-TR*             ,BK.CONTRACT_TERM_CD                                        
MFA-TR*             ,BK.ANN_REVIEW_MONTH                                        
MFA-TR*         INTO :BK-CNTRCT-START-DT                                        
MFA-TR*             ,:BK-CNTRCT-END-DT                                          
MFA-TR*             ,:BK-CONTRACT-DEMAND                                        
MFA-TR*             ,:BK-BUILD-UP-MONTHS                                        
MFA-TR*             ,:BK-SPCL-MO-MIN-AM                                         
MFA-TR*             ,:BK-SPCL-ANN-MIN-AM                                        
MFA-TR*             ,:BK-ANN-MIN-TYPE-CD                                        
MFA-TR*             ,:BK-CBL-REF-RATE-PLN                                       
MFA-TR*             ,:BK-COMP-RATE-PLAN                                         
MFA-TR*             ,:BK-COMPARE-TYPE-CD                                        
MFA-TR*             ,:BK-LFTM-HI-PEAK-DMD                                       
MFA-TR*             ,:BK-DATE-LFTM-HI-DMD:WS-DATE-NI                            
MFA-TR*             ,:BK-DFLT-USAGE-CLS-CD                                      
MFA-TR*             ,:BK-DEM-CNSLDTN-CD                                         
MFA-TR*             ,:BK-MAX-ECON-DEM                                           
MFA-TR*             ,:BK-CONTRACT-ECON-DEM                                      
MFA-TR*             ,:BK-FIRM-PER-HR-KWH                                        
MFA-TR*             ,:BK-CONTRACT-TERM-CD                                       
MFA-TR*             ,:BK-ANN-REVIEW-MONTH                                       
MFA-TR*         FROM CSS_BILL_CONTRACT BK                                       
MFA-TR*        WHERE BK.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM                     
MFA-TR*          AND BK.IC_NO          = :WS-IC-NO-NUM                          
MFA-TR*          AND BK.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                     
MFA-TR*        ORDER BY CNTRCT_START_DT DESC                                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7510                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7510'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILL_CONTRACT'     TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE 'IC_NO'                 TO TABLE-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
              MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1         
              MOVE WS-IC-NO-NUM            TO HOSTVAR-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CHECK WHETHER MATCHING RECORD EXISTS                          *         
      *****************************************************************         
       7050-CHECK-BILL-CNTRCT.                                          
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :CONTRACT-EXISTS-SW                               
                 FROM CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                
                WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM           
                  AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE           
                  AND BK.IC_NO           = :WS-IC-NO-NUM                
                  AND BK.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) )      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :CONTRACT-EXISTS-SW                                       
MFA-TR*          FROM CSS_BILL_CONTRACT BK                                      
MFA-TR*         WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM                   
MFA-TR*           AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                   
MFA-TR*           AND BK.IC_NO           = :WS-IC-NO-NUM                        
MFA-TR*           AND BK.CNTRCT_START_DT = :WS-NEW-CNTRCT-START-DT              
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7050'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                              ABEND-TABLES              
              MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CHECK WHETHER OVELAP DATES EXIST FOR CONTRACTS                *         
      *****************************************************************         
       7010-CHECK-DATE-OVERLAP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) BK.ACCOUNT_NO,
              BK.CODE_UTIL_TYPE,
              BK.IC_NO,
              BK.CNTRCT_START_DT,
              BK.CNTRCT_END_DT                                  
                INTO  :WS-ACC-NUM-TMP                                   
                     ,:WS-CODE-TYPE-TMP                                 
                     ,:WS-IC-NO-TMP                                     
                     ,:WS-CNT-ST-DT-TMP                                 
                     ,:WS-CNT-ND-DT-TMP                                 
                FROM CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
               WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM            
                 AND BK.IC_NO           = :WS-IC-NO-NUM                 
                 AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE            
                 AND BK.CNTRCT_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) )       
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BK.ACCOUNT_NO                                             
MFA-TR*              ,BK.CODE_UTIL_TYPE                                         
MFA-TR*              ,BK.IC_NO                                                  
MFA-TR*              ,BK.CNTRCT_START_DT                                        
MFA-TR*              ,BK.CNTRCT_END_DT                                          
MFA-TR*         INTO  :WS-ACC-NUM-TMP                                           
MFA-TR*              ,:WS-CODE-TYPE-TMP                                         
MFA-TR*              ,:WS-IC-NO-TMP                                             
MFA-TR*              ,:WS-CNT-ST-DT-TMP                                         
MFA-TR*              ,:WS-CNT-ND-DT-TMP                                         
MFA-TR*         FROM CSS_BILL_CONTRACT BK                                       
MFA-TR*        WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM                    
MFA-TR*          AND BK.IC_NO           = :WS-IC-NO-NUM                         
MFA-TR*          AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                    
MFA-TR*          AND BK.CNTRCT_END_DT  >= :WS-NEW-CNTRCT-START-DT               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7010'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                              ABEND-TABLES              
              MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GETS RATE PLAN DESC                                           *         
      *****************************************************************         
       7400-GET-RATE-DESC.                                              
                                                                        
           EXEC SQL                                                     
               SELECT RD.RATE_PLAN_NO                                   
                     ,RD.RATE_DESC                                      
                 INTO :WS-RATE-PLAN-NO                                  
                     ,:WS-RATE-DESC                                     
                FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED),               
                     CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE UT.CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE          
                 AND UT.IC_NO             = :WS-IC-NO-NUM               
                 AND UT.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM          
                 AND UT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE           
                 AND UT.RATE_PLAN_NO      = RD.RATE_PLAN_NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RD.RATE_PLAN_NO                                           
MFA-TR*              ,RD.RATE_DESC                                              
MFA-TR*          INTO :WS-RATE-PLAN-NO                                          
MFA-TR*              ,:WS-RATE-DESC                                             
MFA-TR*         FROM CSS_UTIL_ENVRNMT   UT,                                     
MFA-TR*              CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE UT.CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                  
MFA-TR*          AND UT.IC_NO             = :WS-IC-NO-NUM                       
MFA-TR*          AND UT.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM                  
MFA-TR*          AND UT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE                   
MFA-TR*          AND UT.RATE_PLAN_NO      = RD.RATE_PLAN_NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                              ABEND-TABLES              
              MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * GETS THE PREVIUS DAY.                                         *         
      *****************************************************************         
       7020-PREV-DAY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-MINUS-ONE-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-MINUS-ONE-DAY
              ) <> 0) OR (LEN(:WS-MINUS-ONE-DAY) <> 10), CIS.CHAR2DATE(
                                                      :WS-MINUS-ONE-DAY
              ), CONVERT(DATE, :WS-MINUS-ONE-DAY) ) )
            INTO
              :WS-MINUS-ONE-DAY 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-MINUS-ONE-DAY = DATE(:WS-MINUS-ONE-DAY) - 1 DAYS         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                              ABEND-TABLES              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * UPDATES THE PREVIOUS CONTRACT.                                *         
      *****************************************************************         
       7030-UPDT-PREV-CNTRCT.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE BK                               
                  SET BK.CNTRCT_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                      :WS-MINUS-ONE-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-MINUS-ONE-DAY
              ) <> 0) OR (LEN(:WS-MINUS-ONE-DAY) <> 10), CIS.CHAR2DATE(
                                                      :WS-MINUS-ONE-DAY
              ), CONVERT(DATE, :WS-MINUS-ONE-DAY) )         
               FROM CSS_BILL_CONTRACT BK
                WHERE BK.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM        
                  AND BK.CODE_UTIL_TYPE     = :WS-CODE-TYPE-TMP         
                  AND BK.IC_NO              = :WS-IC-NO-TMP             
                  AND BK.CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                      :WS-CNT-ST-DT-TMP
              ) IS NULL OR (PATINDEX('%.%', :WS-CNT-ST-DT-TMP
              ) <> 0) OR (LEN(:WS-CNT-ST-DT-TMP) <> 10), CIS.CHAR2DATE(
                                                      :WS-CNT-ST-DT-TMP
              ), CONVERT(DATE, :WS-CNT-ST-DT-TMP) )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILL_CONTRACT BK                                      
MFA-TR*           SET BK.CNTRCT_END_DT      = :WS-MINUS-ONE-DAY                 
MFA-TR*         WHERE BK.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM                
MFA-TR*           AND BK.CODE_UTIL_TYPE     = :WS-CODE-TYPE-TMP                 
MFA-TR*           AND BK.IC_NO              = :WS-IC-NO-TMP                     
MFA-TR*           AND BK.CNTRCT_START_DT    = :WS-CNT-ST-DT-TMP                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7030'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                              ABEND-TABLES              
              MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-GET-CURTAIL-PRTY.                                         *        
      *                                                                *        
      ******************************************************************        
       7040-GET-CURTAIL-PRTY.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CODE_CURTAIL_PRTY                                  
                INTO :Z4-CODE-CURTAIL-PRTY                              
                FROM CSS_PRTY_SVC_CAT WITH(READUNCOMMITTED)                     
               WHERE PRTY_SVC_CAT_CD    = :Z4-PRTY-SVC-CAT-CD           
                 AND COMPANY_NO         = :WS-PSNC                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_CURTAIL_PRTY                                          
MFA-TR*         INTO :Z4-CODE-CURTAIL-PRTY                                      
MFA-TR*         FROM CSS_PRTY_SVC_CAT                                           
MFA-TR*        WHERE PRTY_SVC_CAT_CD    = :Z4-PRTY-SVC-CAT-CD                   
MFA-TR*          AND COMPANY_NO         = :WS-PSNC                              
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7040'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PRTY_SVC_CAT'    TO TABLE-1                     
              MOVE 'PRTY_SVC_CAT_CD'     TO TABLE-ELEMENT-1             
              MOVE Z4-PRTY-SVC-CAT-CD    TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE Z4-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN THE SPECIAL CONTRACT PROVISIONS TABLE.     *           
      ***************************************************************           
                                                                        
       8010-INSERT-BILL-CONTRACT.                                       
                                                                        
           IF WS-DATE-LFTM-HI-DMD <= SPACES                             
              MOVE -1                     TO WS-DATE-NI                 
           ELSE                                                         
              MOVE 0                      TO WS-DATE-NI                 
           END-IF.                                                      
           EXEC SQL                                                     
           INSERT INTO CSS_BILL_CONTRACT                                
                  ( ACCOUNT_NO                                          
                   ,CODE_UTIL_TYPE                                      
                   ,IC_NO                                               
                   ,CNTRCT_START_DT                                     
                   ,CNTRCT_END_DT                                       
                   ,CONTRACT_DEMAND                                     
                   ,BUILD_UP_MONTHS                                     
                   ,SPCL_MO_MIN_AM                                      
                   ,SPCL_ANN_MIN_AM                                     
                   ,ANN_MIN_TYPE_CD                                     
                   ,CBL_REF_RATE_PLN                                    
                   ,COMP_RATE_PLAN                                      
                   ,COMPARE_TYPE_CD                                     
                   ,LFTM_HI_PEAK_DMD                                    
                   ,DATE_LFTM_HI_DMD                                    
                   ,DFLT_USAGE_CLS_CD                                   
                   ,DEM_CNSLDTN_CD                                      
                   ,MAX_ECON_DEM                                        
                   ,CONTRACT_ECON_DEM                                   
                   ,FIRM_PER_HR_KWH                                     
                   ,CONTRACT_TERM_CD                                    
                   ,ANN_REVIEW_MONTH)                                   
           VALUES ( :WS-ACCOUNT-NO-NUM                                  
                   ,:WS-CODE-UTIL-TYPE                                  
                   ,:WS-IC-NO-NUM                                       
                   ,IIF(TRY_CONVERT(DATE, :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) )                      
                   ,IIF(TRY_CONVERT(DATE, :WS-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CNTRCT-END-DT
              ) <> 0) OR (LEN(:WS-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-CNTRCT-END-DT
              ), CONVERT(DATE, :WS-CNTRCT-END-DT) )                            
                   ,:WS-CONTRACT-DEMAND                                 
                   ,:WS-BUILD-UP-MONTHS-NUM                             
                   ,:WS-SPCL-MO-MIN-AM                                  
                   ,:WS-SPCL-ANN-MIN-AM                                 
                   ,:WS-ANN-MIN-TYPE-CD                                 
                   ,:WS-CBL-REF-RATE-PLN                                
                   ,:WS-COMP-RATE-PLAN                                  
                   ,:WS-COMPARE-TYPE-CD                                 
                   ,:WS-LFTM-HI-PEAK-DMD                                
                   ,IIF(TRY_CONVERT(DATE, :WS-DATE-LFTM-HI-DMD 
                                          :WS-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-LFTM-HI-DMD 
                                                            :WS-DATE-NI
              ) <> 0) OR (LEN(:WS-DATE-LFTM-HI-DMD :WS-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-LFTM-HI-DMD :WS-DATE-NI
              ), CONVERT(DATE, :WS-DATE-LFTM-HI-DMD :WS-DATE-NI) )             
                   ,:WS-DEFAULT-SUPPLY                                  
                   ,:WS-DEM-CNSLDTN-CD                                  
                   ,:WS-MAX-ECON-DEM                                    
                   ,:WS-CONTRACT-ECON-DEM                               
                   ,:WS-FIRM-PER-HR-KWH                                 
                   ,:WS-CONTRACT-TERM-CD                                
                   ,:WS-ANN-REVIEW-MONTH)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_BILL_CONTRACT                                        
MFA-TR*           ( ACCOUNT_NO                                                  
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,CNTRCT_START_DT                                             
MFA-TR*            ,CNTRCT_END_DT                                               
MFA-TR*            ,CONTRACT_DEMAND                                             
MFA-TR*            ,BUILD_UP_MONTHS                                             
MFA-TR*            ,SPCL_MO_MIN_AM                                              
MFA-TR*            ,SPCL_ANN_MIN_AM                                             
MFA-TR*            ,ANN_MIN_TYPE_CD                                             
MFA-TR*            ,CBL_REF_RATE_PLN                                            
MFA-TR*            ,COMP_RATE_PLAN                                              
MFA-TR*            ,COMPARE_TYPE_CD                                             
MFA-TR*            ,LFTM_HI_PEAK_DMD                                            
MFA-TR*            ,DATE_LFTM_HI_DMD                                            
MFA-TR*            ,DFLT_USAGE_CLS_CD                                           
MFA-TR*            ,DEM_CNSLDTN_CD                                              
MFA-TR*            ,MAX_ECON_DEM                                                
MFA-TR*            ,CONTRACT_ECON_DEM                                           
MFA-TR*            ,FIRM_PER_HR_KWH                                             
MFA-TR*            ,CONTRACT_TERM_CD                                            
MFA-TR*            ,ANN_REVIEW_MONTH)                                           
MFA-TR*    VALUES ( :WS-ACCOUNT-NO-NUM                                          
MFA-TR*            ,:WS-CODE-UTIL-TYPE                                          
MFA-TR*            ,:WS-IC-NO-NUM                                               
MFA-TR*            ,:WS-NEW-CNTRCT-START-DT                                     
MFA-TR*            ,:WS-CNTRCT-END-DT                                           
MFA-TR*            ,:WS-CONTRACT-DEMAND                                         
MFA-TR*            ,:WS-BUILD-UP-MONTHS-NUM                                     
MFA-TR*            ,:WS-SPCL-MO-MIN-AM                                          
MFA-TR*            ,:WS-SPCL-ANN-MIN-AM                                         
MFA-TR*            ,:WS-ANN-MIN-TYPE-CD                                         
MFA-TR*            ,:WS-CBL-REF-RATE-PLN                                        
MFA-TR*            ,:WS-COMP-RATE-PLAN                                          
MFA-TR*            ,:WS-COMPARE-TYPE-CD                                         
MFA-TR*            ,:WS-LFTM-HI-PEAK-DMD                                        
MFA-TR*            ,:WS-DATE-LFTM-HI-DMD:WS-DATE-NI                             
MFA-TR*            ,:WS-DEFAULT-SUPPLY                                          
MFA-TR*            ,:WS-DEM-CNSLDTN-CD                                          
MFA-TR*            ,:WS-MAX-ECON-DEM                                            
MFA-TR*            ,:WS-CONTRACT-ECON-DEM                                       
MFA-TR*            ,:WS-FIRM-PER-HR-KWH                                         
MFA-TR*            ,:WS-CONTRACT-TERM-CD                                        
MFA-TR*            ,:WS-ANN-REVIEW-MONTH)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *INSERT RECORD IN THE CSS_BILL_CONTRACT TABLE FOR ALL RATE PLAN           
      ***************************************************************           
                                                                        
       7600-INSERT-RATE-PLANS.                                          
                                                                        
           PERFORM 7610-OPEN-RATE-CURSOR     THRU 7610-EXIT             
           PERFORM 7620-FETCH-RATE-CURSOR    THRU 7620-EXIT             
           PERFORM 7630-INSERT-FETCH-PLAN    THRU 7630-EXIT             
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
           PERFORM 7640-CLOSE-RATE-CURSOR    THRU 7640-EXIT.            
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN THE SPECIAL CONTRACT PROVISIONS TABLE.     *           
      ***************************************************************           
                                                                        
       7700-INSERT-ALTERNATE-FUEL.                                      
                                                                        
           IF WS-DEFAULT-SUPPLY = WS-NEGOTIATED OR                      
                                  WS-TRANSPORTATION                     
              PERFORM 7710-OPEN-ALT-FUEL        THRU 7710-EXIT          
              PERFORM 7720-FETCH-ALT-FUEL       THRU 7720-EXIT          
              PERFORM 7730-ALTERNATE-FUEL-PROCESS THRU 7730-EXIT        
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
              PERFORM 7740-CLOSE-ALT-FUEL       THRU 7740-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************           
      * UPDATE RECORD IN THE CSS_BILL_CONTRACT TABLE.               *           
      ***************************************************************           
                                                                        
       7060-UPDATE-BILL-CONTRACT.                                       
                                                                        
           IF WS-DATE-LFTM-HI-DMD <= SPACES                             
              MOVE -1                     TO WS-DATE-NI                 
           ELSE                                                         
              MOVE 0                      TO WS-DATE-NI                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
           UPDATE BK                                   
              SET BK.CNTRCT_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                      :WS-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CNTRCT-END-DT
              ) <> 0) OR (LEN(:WS-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-CNTRCT-END-DT
              ), CONVERT(DATE, :WS-CNTRCT-END-DT) )             
                 ,BK.CONTRACT_DEMAND    = :WS-CONTRACT-DEMAND           
                 ,BK.BUILD_UP_MONTHS    = :WS-BUILD-UP-MONTHS-NUM       
                 ,BK.SPCL_MO_MIN_AM     = :WS-SPCL-MO-MIN-AM            
                 ,BK.SPCL_ANN_MIN_AM    = :WS-SPCL-ANN-MIN-AM           
                 ,BK.ANN_MIN_TYPE_CD    = :WS-ANN-MIN-TYPE-CD           
                 ,BK.CBL_REF_RATE_PLN   = :WS-CBL-REF-RATE-PLN          
                 ,BK.COMP_RATE_PLAN     = :WS-COMP-RATE-PLAN            
                 ,BK.COMPARE_TYPE_CD    = :WS-COMPARE-TYPE-CD           
                 ,BK.LFTM_HI_PEAK_DMD   = :WS-LFTM-HI-PEAK-DMD          
                 ,BK.DATE_LFTM_HI_DMD   = IIF(TRY_CONVERT(DATE, 
                                                  :WS-DATE-LFTM-HI-DMD 
                                                            :WS-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-LFTM-HI-DMD 
                                                            :WS-DATE-NI
              ) <> 0) OR (LEN(:WS-DATE-LFTM-HI-DMD :WS-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-LFTM-HI-DMD :WS-DATE-NI
              ), CONVERT(DATE, :WS-DATE-LFTM-HI-DMD :WS-DATE-NI) )             
                 ,BK.DFLT_USAGE_CLS_CD  = :WS-DEFAULT-SUPPLY            
                 ,BK.DEM_CNSLDTN_CD     = :WS-DEM-CNSLDTN-CD            
                 ,BK.MAX_ECON_DEM       = :WS-MAX-ECON-DEM              
                 ,BK.CONTRACT_ECON_DEM  = :WS-CONTRACT-ECON-DEM         
                 ,BK.FIRM_PER_HR_KWH    = :WS-FIRM-PER-HR-KWH           
                 ,BK.CONTRACT_TERM_CD   = :WS-CONTRACT-TERM-CD          
                 ,BK.ANN_REVIEW_MONTH   = :WS-ANN-REVIEW-MONTH          
           FROM CSS_BILL_CONTRACT BK
            WHERE BK.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            
              AND BK.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            
              AND BK.IC_NO              = :WS-IC-NO-NUM                 
              AND BK.CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    UPDATE CSS_BILL_CONTRACT BK                                          
MFA-TR*       SET BK.CNTRCT_END_DT      = :WS-CNTRCT-END-DT                     
MFA-TR*          ,BK.CONTRACT_DEMAND    = :WS-CONTRACT-DEMAND                   
MFA-TR*          ,BK.BUILD_UP_MONTHS    = :WS-BUILD-UP-MONTHS-NUM               
MFA-TR*          ,BK.SPCL_MO_MIN_AM     = :WS-SPCL-MO-MIN-AM                    
MFA-TR*          ,BK.SPCL_ANN_MIN_AM    = :WS-SPCL-ANN-MIN-AM                   
MFA-TR*          ,BK.ANN_MIN_TYPE_CD    = :WS-ANN-MIN-TYPE-CD                   
MFA-TR*          ,BK.CBL_REF_RATE_PLN   = :WS-CBL-REF-RATE-PLN                  
MFA-TR*          ,BK.COMP_RATE_PLAN     = :WS-COMP-RATE-PLAN                    
MFA-TR*          ,BK.COMPARE_TYPE_CD    = :WS-COMPARE-TYPE-CD                   
MFA-TR*          ,BK.LFTM_HI_PEAK_DMD   = :WS-LFTM-HI-PEAK-DMD                  
MFA-TR*          ,BK.DATE_LFTM_HI_DMD   = :WS-DATE-LFTM-HI-DMD                  
MFA-TR*                                   :WS-DATE-NI                           
MFA-TR*          ,BK.DFLT_USAGE_CLS_CD  = :WS-DEFAULT-SUPPLY                    
MFA-TR*          ,BK.DEM_CNSLDTN_CD     = :WS-DEM-CNSLDTN-CD                    
MFA-TR*          ,BK.MAX_ECON_DEM       = :WS-MAX-ECON-DEM                      
MFA-TR*          ,BK.CONTRACT_ECON_DEM  = :WS-CONTRACT-ECON-DEM                 
MFA-TR*          ,BK.FIRM_PER_HR_KWH    = :WS-FIRM-PER-HR-KWH                   
MFA-TR*          ,BK.CONTRACT_TERM_CD   = :WS-CONTRACT-TERM-CD                  
MFA-TR*          ,BK.ANN_REVIEW_MONTH   = :WS-ANN-REVIEW-MONTH                  
MFA-TR*     WHERE BK.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM                    
MFA-TR*       AND BK.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                    
MFA-TR*       AND BK.IC_NO              = :WS-IC-NO-NUM                         
MFA-TR*       AND BK.CNTRCT_START_DT    = :WS-NEW-CNTRCT-START-DT               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7060'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE RECORD IN THE CSS_UTIL_ENVRNMT TABLE                 *           
      ***************************************************************           
                                                                        
       8200-UPDATE-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE UT                                 
                 SET UT.CODE_CURTAIL_PRTY  = :WS-CODE-CURTAIL-PRTY      
              FROM CSS_UTIL_ENVRNMT UT
               WHERE UT.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM         
                 AND UT.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE         
                 AND UT.IC_NO              = :WS-IC-NO-NUM              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_UTIL_ENVRNMT UT                                        
MFA-TR*          SET UT.CODE_CURTAIL_PRTY  = :WS-CODE-CURTAIL-PRTY              
MFA-TR*        WHERE UT.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM                 
MFA-TR*          AND UT.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                 
MFA-TR*          AND UT.IC_NO              = :WS-IC-NO-NUM                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * SELECT RECORD IN THE CSS_UTIL_ENVRNMT TABLE                 *           
      ***************************************************************           
                                                                        
       7080-GET-COMPANY-NO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT UT.CODE_CURTAIL_PRTY                               
                    ,UT.COMPANY_NO                                      
                INTO :UT-CODE-CURTAIL-PRTY                              
                    ,:UT-COMPANY-NO                                     
                FROM CSS_UTIL_ENVRNMT UT                                
               WHERE UT.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM         
                 AND UT.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE         
                 AND UT.IC_NO              = :WS-IC-NO-NUM              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7080'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * DELETE RECORD IN THE CSS_BILL_CONTRACT TABLE.               *           
      ***************************************************************           
                                                                        
       8020-DELETE-BILL-CONTRACT.                                       
                                                                        
           EXEC SQL                                                     
           DELETE FROM BK                              
           FROM CSS_BILL_CONTRACT BK
            WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM               
              AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE               
              AND BK.IC_NO           = :WS-IC-NO-NUM                    
              AND BK.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) )          
              AND NOT EXISTS (                                          
                  SELECT 1                                              
                    FROM CSS_BILL_CNTR_HIST BX                          
                   WHERE BX.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM        
                     AND BX.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE        
                     AND BX.IC_NO           = :WS-IC-NO-NUM             
                     AND BX.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) ))  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DELETE FROM CSS_BILL_CONTRACT BK                                     
MFA-TR*     WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM                       
MFA-TR*       AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                       
MFA-TR*       AND BK.IC_NO           = :WS-IC-NO-NUM                            
MFA-TR*       AND BK.CNTRCT_START_DT = :WS-NEW-CNTRCT-START-DT                  
MFA-TR*       AND NOT EXISTS (                                                  
MFA-TR*           SELECT 1                                                      
MFA-TR*             FROM CSS_BILL_CNTR_HIST BX                                  
MFA-TR*            WHERE BX.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM                
MFA-TR*              AND BX.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                
MFA-TR*              AND BX.IC_NO           = :WS-IC-NO-NUM                     
MFA-TR*              AND BX.CNTRCT_START_DT = :WS-NEW-CNTRCT-START-DT)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * DELETE RECORD IN THE CSS_BILL_CONTRACT TABLE.               *           
      ***************************************************************           
                                                                        
       8030-DELETE-ALL-BILL-CONTRACT.                                   
                                                                        
           EXEC SQL                                                     
           DELETE FROM BK                              
           FROM CSS_BILL_CONTRACT BK
            WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM               
              AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE               
              AND BK.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) )          
              AND BK.CNTRCT_END_DT   = IIF(TRY_CONVERT(DATE, 
                                                      :WS-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CNTRCT-END-DT
              ) <> 0) OR (LEN(:WS-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-CNTRCT-END-DT
              ), CONVERT(DATE, :WS-CNTRCT-END-DT) )                
              AND NOT EXISTS (                                          
                  SELECT 1                                              
                    FROM CSS_BILL_CNTR_HIST BX                          
                   WHERE BX.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM        
                     AND BX.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE        
                     AND BX.IC_NO           = :WS-IC-NO-NUM             
                     AND BX.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:WS-NEW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-CNTRCT-START-DT
              ), CONVERT(DATE, :WS-NEW-CNTRCT-START-DT) ))  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DELETE FROM CSS_BILL_CONTRACT BK                                     
MFA-TR*     WHERE BK.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM                       
MFA-TR*       AND BK.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                       
MFA-TR*       AND BK.CNTRCT_START_DT = :WS-NEW-CNTRCT-START-DT                  
MFA-TR*       AND BK.CNTRCT_END_DT   = :WS-CNTRCT-END-DT                        
MFA-TR*       AND NOT EXISTS (                                                  
MFA-TR*           SELECT 1                                                      
MFA-TR*             FROM CSS_BILL_CNTR_HIST BX                                  
MFA-TR*            WHERE BX.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM                
MFA-TR*              AND BX.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                
MFA-TR*              AND BX.IC_NO           = :WS-IC-NO-NUM                     
MFA-TR*              AND BX.CNTRCT_START_DT = :WS-NEW-CNTRCT-START-DT)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_END_DT'      TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-3          
              MOVE WS-CNTRCT-END-DT       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN  ALTERNATE FUEL SUPPLY                                   *         
      *****************************************************************         
       7710-OPEN-ALT-FUEL.                                              
           EXEC SQL                                                     
              OPEN FU-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7710'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN '              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_ALTN_FUEL_SPLY'                                 
                                        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * FETCH ALTERNATE FUEL SUPPLY                                   *         
      *****************************************************************         
       7720-FETCH-ALT-FUEL.                                             
           EXEC SQL                                                     
               FETCH FU-CURSOR                                          
                INTO :WS-ALTN-FUEL-SPLY-CD                              
                    ,:WS-ALT-SPLY-RATE-NO                               
                    ,:WS-ALT-SPLY-REV-CL-CD                             
                    ,:WS-FUEL-SHIPPER-CD                                
                    ,:WS-EXISTING-CNT-START-DT                          
                    ,:WS-ALTERNATE-FUEL-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7720'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                         ABEND-TABLES                   
              MOVE 'CSS_ALTN_FUEL_SPLY'                                 
                                     TO TABLE-1                         
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1               
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-3               
              PERFORM 9000-SEND-ERROR-RESULT                            
                                     THRU 9000-EXIT                     
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                     THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CLOSE ALTERNATE FUEL SUPPLY                                   *         
      *****************************************************************         
       7740-CLOSE-ALT-FUEL.                                             
           EXEC SQL                                                     
              CLOSE FU-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7740'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_ALTN_FUEL_SPLY'                                 
                                        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN  RATE PLAN CURSOR                                        *         
      *****************************************************************         
       7610-OPEN-RATE-CURSOR.                                           
           EXEC SQL                                                     
              OPEN RT-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7610'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN '              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_UTIL_ENVRNMT'                                   
                                        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7610-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * FETCH RATE PLANS                                              *         
      *****************************************************************         
       7620-FETCH-RATE-CURSOR.                                          
           EXEC SQL                                                     
               FETCH RT-CURSOR                                          
                INTO :WS-IC-NO-NUM                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7620'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                         ABEND-TABLES                   
              MOVE 'CSS_UTIL_ENVRNMT'                                   
                                     TO TABLE-1                         
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1               
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-3               
              PERFORM 9000-SEND-ERROR-RESULT                            
                                     THRU 9000-EXIT                     
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                     THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORDS IN THE CSS_BILL_CONTRACT TABLE FOR ALL IC NO *           
      ***************************************************************           
       7630-INSERT-FETCH-PLAN.                                          
                                                                        
           PERFORM 7010-CHECK-DATE-OVERLAP            THRU 7010-EXIT.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-NEW-CNTRCT-START-DT             TO                
                                                      WS-MINUS-ONE-DAY  
              PERFORM 7020-PREV-DAY                   THRU 7020-EXIT    
              PERFORM 7030-UPDT-PREV-CNTRCT           THRU 7030-EXIT    
           END-IF.                                                      
           PERFORM 7500-GET-BK-INFO                   THRU 7500-EXIT.   
           PERFORM 8010-INSERT-BILL-CONTRACT          THRU 8010-EXIT.   
           PERFORM 2010-OTHER-INSERT-PROCESS          THRU 2010-EXIT.   
           PERFORM 7620-FETCH-RATE-CURSOR             THRU 7620-EXIT.   
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN CSS_ALTN_FUEL_SPLY                         *           
      ***************************************************************           
                                                                        
       7730-ALTERNATE-FUEL-PROCESS.                                     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-EXISTING-CNT-START-DT NOT = WS-NEW-CNTRCT-START-DT  
                MOVE WS-ACCOUNT-NO-NUM   TO AK-ACCOUNT-NO               
                MOVE WS-CODE-UTIL-TYPE   TO AK-CODE-UTIL-TYPE           
                MOVE WS-IC-NO-NUM        TO AK-IC-NO                    
                MOVE WS-NEW-CNTRCT-START-DT TO AK-CNTRCT-START-DT       
                MOVE WS-ALTN-FUEL-SPLY-CD                               
                                         TO AK-ALTN-FUEL-SPLY-CD        
                MOVE WS-ALT-SPLY-RATE-NO TO AK-ALT-SPLY-RATE-NO         
                MOVE WS-ALT-SPLY-REV-CL-CD                              
                                         TO AK-ALT-SPLY-REV-CL-CD       
                MOVE WS-FUEL-SHIPPER-CD  TO AK-FUEL-SHIPPER-CD          
                MOVE WS-ALTERNATE-FUEL-CD                               
                                         TO AK-ALTERNATE-FUEL-CD        
                                                                        
                PERFORM 8400-INSERT-ALT-FUEL                            
                                         THRU 8400-EXIT                 
ACT024          IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
ACT024             PERFORM 8600-PROCESS-LOAD-IN-TRANS THRU 8600-EXIT    
ACT024          END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
              PERFORM 7720-FETCH-ALT-FUEL       THRU 7720-EXIT.         
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * CLOSE ALTERNATE FUEL SUPPLY                                   *         
      *****************************************************************         
       7640-CLOSE-RATE-CURSOR.                                          
           EXEC SQL                                                     
              CLOSE RT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7630'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_UTIL_ENVRNMT'                                   
                                        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
      *7900-GET-RULE-XREF-ID.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT BUS_RULE_XREF_ID                                           
      *         INTO :S-BUS-RULE-XREF-ID                                        
      *         FROM CSS_BUS_RULE      1R                                       
      *             ,CSS_BUS_RULE_XREF 1T                                       
      *        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
      *          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
      *        FETCH FIRST ROW ONLY WITH UR                                     
      *      QUERYNO 7900                                                       
      *    END-EXEC                                                             
      *                                                                         
      *    MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE          
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL                       
      *       CONTINUE                                                          
      *    ELSE                                                                 
      *       MOVE SPACES                    TO ABEND-TABLES                    
      *       MOVE SPACES                    TO ABEND-SQL-PREDICATES            
      *       MOVE '7900'                    TO ACTIVE-PARAGRAPH                
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_BUS_RULE'            TO TABLE-1                         
      *       MOVE 'BUS_RULE_ID'             TO TABLE-ELEMENT-1                 
      *       MOVE S-BUS-RULE-ID             TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                     
      *       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *7900-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ***************************************************************           
      * INSERT RECORD IN CSS_ALTN_FUEL_SPLY                         *           
      ***************************************************************           
                                                                        
       8400-INSERT-ALT-FUEL.                                            
           EXEC SQL                                                     
           INSERT INTO CSS_ALTN_FUEL_SPLY                               
                  ( ACCOUNT_NO                                          
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CNTRCT_START_DT                                    
                    ,ALTN_FUEL_SPLY_CD                                  
                    ,ALT_SPLY_RATE_NO                                   
                    ,ALT_SPLY_REV_CL_CD                                 
                    ,FUEL_SHIPPER_CD                                    
                    ,ALTERNATE_FUEL_CD )                                
           VALUES ( :AK-ACCOUNT-NO                                      
                   ,:AK-CODE-UTIL-TYPE                                  
                   ,:AK-IC-NO                                           
                   ,IIF(TRY_CONVERT(DATE, :AK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :AK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:AK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:AK-CNTRCT-START-DT
              ), CONVERT(DATE, :AK-CNTRCT-START-DT) )                          
                   ,:AK-ALTN-FUEL-SPLY-CD                               
                   ,:AK-ALT-SPLY-RATE-NO                                
                   ,:AK-ALT-SPLY-REV-CL-CD                              
                   ,:AK-FUEL-SHIPPER-CD                                 
                   ,:AK-ALTERNATE-FUEL-CD)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_ALTN_FUEL_SPLY                                       
MFA-TR*           ( ACCOUNT_NO                                                  
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,CNTRCT_START_DT                                            
MFA-TR*             ,ALTN_FUEL_SPLY_CD                                          
MFA-TR*             ,ALT_SPLY_RATE_NO                                           
MFA-TR*             ,ALT_SPLY_REV_CL_CD                                         
MFA-TR*             ,FUEL_SHIPPER_CD                                            
MFA-TR*             ,ALTERNATE_FUEL_CD )                                        
MFA-TR*    VALUES ( :AK-ACCOUNT-NO                                              
MFA-TR*            ,:AK-CODE-UTIL-TYPE                                          
MFA-TR*            ,:AK-IC-NO                                                   
MFA-TR*            ,:AK-CNTRCT-START-DT                                         
MFA-TR*            ,:AK-ALTN-FUEL-SPLY-CD                                       
MFA-TR*            ,:AK-ALT-SPLY-RATE-NO                                        
MFA-TR*            ,:AK-ALT-SPLY-REV-CL-CD                                      
MFA-TR*            ,:AK-FUEL-SHIPPER-CD                                         
MFA-TR*            ,:AK-ALTERNATE-FUEL-CD)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                        OR ALREADY-EXISTS               
              CONTINUE                                                  
           ELSE                                                         
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_ALTN_FUEL_SPLY' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            
              MOVE WS-NEW-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT                            
                                        THRU 9000-EXIT                  
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                        THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT024*                                                                         
ACT024******************************************************************04400001
ACT024*  LOAD THE DATA IN   MNT TRANSACTION HISTORY & DETAIL TABLE     *04420001
ACT024******************************************************************04450001
ACT024 8600-PROCESS-LOAD-IN-TRANS.                                      
ACT024                                                                  
ACT024     PERFORM 7800-JRNL-TRAN-HEAD     THRU 7800-EXIT.              
ACT024     MOVE WS-COMMENT-LEN-NUM         TO MH-TRAN-COMMENT-LEN.      
ACT024     MOVE WS-COMMENT-TXT             TO MH-TRAN-COMMENT-TEXT.     
ACT024     MOVE 'CSR04746A'                TO MH-APPL-PROGRAM-ID.       
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +1                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-CODE-UTIL-TYPE          TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'CODE UTIL TYPE '          TO MI-COLUMN-DESC.           
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +4                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-IC-NO-NUM               TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'IC NO          '          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +10                        TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-NEW-CNTRCT-START-DT     TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'CNTRCT START DT'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +1                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-ALTN-FUEL-SPLY-CD       TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT SPLY CD    '          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +3                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-ALT-SPLY-RATE-NO        TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT SPL RATE NO'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +3                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-ALT-SPLY-REV-CL-CD      TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT SPLY REV CL'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +1                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-FUEL-SHIPPER-CD         TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT FUEL SHIPCD'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +1                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE WS-ALTERNATE-FUEL-CD       TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT FUEL CD    '          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024 8600-EXIT.                                                       
ACT024      EXIT.                                                       
ACT024*                                                                         
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
      ****************************************************************          
      * SENDS THE RESULT SET                                         *          
      ****************************************************************          
                                                                        
       8500-SEND-RESULT.                                                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
