       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04745.                                      
COB303 DATE-WRITTEN.     APRIL 03, 2014.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04745              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04745 :                                                --         
      *--                                                            --         
      *--  RETRIEVE THE BILL  CONTRACT DATA FROM CSS_BILL_CONTRACT.  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             I-ACCOUNT-NO          CHAR(13)                 --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--  CSR04745_R1 - BILL CONTRACT - CLONED FROM CSR02113        --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,CNTRCT_START_DT         DATE                     --         
      *--          ,CNTRCT_END_DT           DATE                     --         
      *--          ,CUSTOMER_TYPE           CHAR(04)                 --         
      *--                                                            --         
      *--  CSR04745_R2 - CONTRACT DETAILS - CLONED FROM CSR02113     --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,RATE_PLAN_NO            CHAR(03)                 --         
      *--          ,RATE_PLAN_DESC          CHAR(50)                 --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,IC_NO                   INTEGER                  --         
      *--          ,COMPANY_NO              CHAR(02)                 --         
      *--          ,CNTRCT_START_DT         DATE                     --         
      *--          ,CNTRCT_END_DT           DATE                     --         
      *--          ,CONTRACT_TERM_CD        CHAR(01)                 --         
      *--          ,CONTRACT_DEMAND         DECIMAL (9,2)            --         
      *--          ,ANN_REVIEW_MONTH        CHAR(02)                 --         
      *--          ,SPCL_MO_MIN_AM          DECIMAL (7,2)            --         
      *--          ,SPCL_ANN_MIN_AM         DECIMAL (11,2)           --         
      *--          ,ANN_MIN_TYPE_CD         CHAR(01)                 --         
      *--          ,DEM_CNSLDTN_CD          CHAR(01)                 --         
      *--          ,BUILD_UP_MONTHS         INTEGER                  --         
      *--          ,LFTM_HI_PEAK_DMD        DECIMAL (7,0)            --         
      *--          ,DATE_LFTM_HI_DMD        DATE                     --         
      *--          ,DFLT_USAGE_CLS_CD       CHAR(01)                 --         
      *--          ,FIRM_PER_HR_KWH         DECIMAL (9,2)            --         
      *--          ,OFF_PEAK_DEMAND         DECIMAL (9,2)            --         
      *--          ,CBL_REF_RATE_PLN        CHAR(03)                 --         
      *--          ,CONTRACT_ECON_DEM       DECIMAL(7,0)             --         
      *--          ,MIN_DMD_QTY             DECIMAL(11,0)            --         
      *--          ,PRTY_SVC_CAT_CD         CHAR(02)                 --         
      *--                                                            --         
      *--  CSR04745_R3 - VOLUME BLOCKS DETAILS - CLONED FROM CSR02472--         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,PRIMARY_IC_NO           INTEGER                  --         
      *--          ,RATE_PLAN_NO            CHAR(03)                 --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,IC_NO                   INTEGER                  --         
      *--          ,PRTY_SVC_CAT_CD         CHAR(02)                 --         
      *--          ,VOL_BLOCK_FACTOR        DECIMAL(7,0)             --         
      *--          ,CONTRACT_DEMAND         DECIMAL(9,2)             --         
      *--          ,ALTERNATE_FUEL_CD       CHAR(01)                 --         
      *--                                                            --         
      *--  CSR04745_R4 - TRANSPORT AGREEMENT DETAILS - CSR02475      --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,PRIMARY_IC_NO           INTEGER                  --         
      *--          ,PRIMARY_RATE_PLAN_NO    CHAR(03)                 --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,IC_NO                   INTEGER                  --         
      *--          ,CNTRCT_START_DT         CHAR(10)                 --         
      *--          ,TRNSP_SHRINK_PCT        DECIMAL(4,2)             --         
      *--          ,FUEL_SHIPPER_CD         CHAR(01)                 --         
      *--          ,TRNSP_MDQ               DECIMAL(7,0)             --         
      *--          ,PRTY_SVC_CAT_CD         CHAR(02)                 --         
      *--          ,TRAN_RATE_PLAN          CHAR(03)                 --         
      *--          ,CODE_REVENUE_CLASS      CHAR(03)                 --         
      *--          ,CONTRACT_DEMAND         DECIMAL(9,2)             --         
      *--          ,FACTOR                  DECIMAL(13,4)            --         
      *--          ,TRANSM_ACCT_NO          DECIMAL(5,0)             --         
      *--          ,MAX_CNTRCT_START_DT     CHAR(10)                 --         
      *--          ,CNTRCT_END_DT           CHAR(10)                 --         
      *--                                                            --         
      *--  CSR04745_R5 -  BASELINE DETAILS - CLONED FROM CSR04466    --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,IC_NO                   INTEGER                  --         
      *--          ,CNTRCT_START_DT         CHAR(10)                 --         
      *--          ,BASELINE_MONTH          INTEGER                  --         
      *--          ,CMPNT_ID_CD             CHAR(02)                 --         
      *--          ,INSTR_USE_TYPE_CD       CHAR(01)                 --         
      *--          ,CODE_TIME_PERIOD        INTEGER                  --         
      *--          ,BASELINE_UNITS          DECIMAL(10,1)            --         
      *--                                                            --         
      *--  CSR04745_R6 - INTERRUPT CONTRACT DETAILS - CLONED CSR02000--         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,IC_NO                   INTEGER                  --         
      *--          ,TYP_INTRPT_DEMAND       DECIMAL(9,0)             --         
      *--          ,CATEGORY                CHAR(02)                 --         
      *--          ,CONTRACT_DATE           CHAR(10)                 --         
      *--          ,FIRM_DEMAND_LEVEL       DECIMAL(9,0)             --         
      *--          ,CURTAILMENT_IND         CHAR(01)                 --         
      *--          ,BASELINE_UNITS          DECIMAL(10,1)            --         
      *--          ,USER_ID_ACCT_MGR        CHAR(05)                 --         
      *--                                                            --         
      *--  CSR04745_R7 -  INTERRUPT DETAILS - CSR02229 & CSR02262    --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,IC_NO                   INTEGER                  --         
      *--          ,NON_COMPLIANCE_IND      CHAR(01)                 --         
      *--          ,INTERRUPT_DATE          CHAR(10)                 --         
      *--          ,INTERRUPT_TIME_OFF      CHAR(08)                 --         
      *--          ,INTERRUPT_TIME_ON       CHAR(08)                 --         
      *--          ,TOTAL_HOURS             CHAR(08)                 --         
      *--          ,EXCEPTION_CD            CHAR(02)                 --         
      *--          ,POWER_COST              DECIMAL(9,6)             --         
      *--          ,INTERRUPT_REASON        CHAR(254)                --         
      *--          ,INTERRUPT_END           CHAR(10)                 --         
      *--          ,NOTIFY_DATE             CHAR(10)                 --         
      *--          ,NOTIFY_TIME             CHAR(08)                 --         
      *--          ,NOTIFY_NAME             CHAR(50)                 --         
      *--          ,NOTIFY_POSITION         CHAR(30)                 --         
      *--          ,USER_ID_NOTIFY_BY       CHAR(07)                 --         
      *--          ,TYP_INTRPT_DEMAND       DECIMAL(9,0)             --         
      *--          ,RESP_CUSTOMER           CHAR(254)                --         
      *--          ,REMARKS                 VARCHAR(254)             --         
      *--                                                            --         
      *--  CSR04745_R8 -  ALTERNATE FUEL SUPPLY - CLONED CSR02454    --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,IC_NO                   INTEGER                  --         
      *--          ,CNTRCT_START_DT         CHAR(10)                 --         
      *--          ,ALTN_FUEL_SPLY_CD       CHAR(01)                 --         
      *--          ,ALT_SPLY_RATE_NO        CHAR(03)                 --         
      *--          ,ALT_SPLY_REV_CL_CD      CHAR(03)                 --         
      *--          ,FUEL_SHIPPER_CD         CHAR(01)                 --         
      *--          ,ALTERNATE_FUEL_CD       CHAR(01)                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00801*--  04/03/2014    MC95456     RETRIEVE BILL CONTRACT DETAILS  --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04745'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                         PIC X(40) VALUE              
            'WORKING STORAGE FOR CSR04745 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                PIC X(08) VALUE 'CSRERLOG'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'CSR04745'.  
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS2                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS3                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS4                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS5                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS6                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS7                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS8                PIC S9(9) COMP VALUE 0.      
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                 PIC X(05)  VALUE SPACES.     
           05  WS-GTT-NAME                 PIC X(19)  VALUE SPACES.     
           05  WS-CUT-OFF-DATE             PIC X(10)  VALUE SPACES.     
           05  WS-CUT-OFF-MNTHS            PIC S9(04) COMP  VALUE ZEROS.
           05  WS-DUMMY-START-DT           PIC X(10)  VALUE SPACES.     
           05  WS-CUSTOMER-TYPE            PIC X(04)  VALUE SPACES.     
           05  WS-CIG-CUSTOMER             PIC X(01)  VALUE 'N'.        
           05  WS-TRANSRATE                PIC X(10) VALUE 'TRNSPRATE'. 
COB305     05 WS-FACTOR-CMP3        PIC S9(9)V9(6) USAGE COMP-3 VALUE 0. 
           05  WS-FACTOR-NUM               PIC S9(9)V9(6) VALUE ZEROES. 
           05  WS-FACTOR                  PIC Z(8)9.999999 VALUE ZEROES.
           05  WS-FACTOR-FF               PIC S9(09)V9(06) USAGE COMP-3 
                                                          VALUE 0.      
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-A                        PIC X(01)  VALUE 'A'.        
           05  WS-SCEG                     PIC X(02)  VALUE '01'.       
           05  WS-PSNC                     PIC X(02)  VALUE '26'.       
           05  WS-TOTAL-DIFFERENCE         PIC X(06).                   
           05  WS-CMPNT-ID-CD              PIC X(02)  VALUE '10'.       
           05  WS-TOTAL-HOURS.                                          
               10 WS-TOTAL-HH              PIC X(02).                   
               10 WS-TOTAL-S1              PIC X(01).                   
               10 WS-TOTAL-MM              PIC X(02).                   
               10 WS-TOTAL-S2              PIC X(01).                   
               10 WS-TOTAL-SS              PIC X(02).                   
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-LFTM-HI-DMD-NI  PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-START-DATE      PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-END-DATE        PIC S9(04) COMP VALUE 0.         
           05  WS-INTRPT-TIME-ON-NULL  PIC S9(04) COMP VALUE 0.         
           05  WS-NOTIFY-DATE-NULL     PIC S9(04) COMP VALUE 0.         
           05  WS-NOTIFY-TIME-NULL     PIC S9(04) COMP VALUE 0.         
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-BK-ROWS           PIC X(01) VALUE 'N'.         
              88 NO-MORE-BK-ROWS                     VALUE 'Y'.         
           05 WS-NO-MORE-ALTN-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-ALTN-ROWS                   VALUE 'Y'.         
           05 WS-NO-MORE-VBLK-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-VBLK-ROWS                   VALUE 'Y'.         
           05 WS-NO-MORE-TRNS-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-TRNS-ROWS                   VALUE 'Y'.         
           05 WS-NO-MORE-BSLN-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-BSLN-ROWS                   VALUE 'Y'.         
           05 WS-NO-MORE-INTR-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-INTR-ROWS                   VALUE 'Y'.         
           05 WS-NO-MORE-INPT-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-INPT-ROWS                   VALUE 'Y'.         
                                                                        
       01  WS-ERR-CODES.                                                
           05  WS-ERR-INSRT-R1             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R2             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R3             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R4             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R5             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R6             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R7             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R8             PIC X(01) VALUE 'N'.         
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                   PIC X(18) VALUE SPACES.      
           10  S-SQLCODE                   PIC S9(9) COMP VALUE 0.      
           10  S-SQLSTATE                  PIC X(05) VALUE ' '.         
           10  S-TABLE-NAME                PIC X(18) VALUE SPACES.      
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L      PIC S9(4) USAGE COMP.        
               49  S-HOST-VARIABLES-V      PIC X(255).                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L       PIC S9(4) USAGE COMP.        
               49  S-SQL-STATEMENT-V       PIC X(255).                  
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L     PIC S9(4) USAGE COMP.        
               49  S-SQL-DESCRIPTION-V     PIC X(255).                  
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L     PIC S9(4) USAGE COMP.        
               49  WS-ABEND-SQLERRMC-V     PIC X(255).                  
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILL CONTRACT                  *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1            PIC S9(04) COMP VALUE 0.     
             10 S-RS1-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS1-CNTRCT-START-DT      PIC X(10)  VALUE SPACES.     
             10 S-RS1-CNTRCT-END-DT        PIC X(10)  VALUE SPACES.     
             10 S-RS1-CUSTOMER-TYPE        PIC X(04)  VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILL CONTRACT DETAILS          *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2            PIC S9(04) COMP VALUE 0.     
             10 S-RS2-RATE-PLAN-NO         PIC X(03)  VALUE SPACES.     
             10 S-RS2-RATE-PLAN-DESC       PIC X(50)  VALUE SPACES.     
             10 S-RS2-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS2-IC-NO                PIC S9(04) COMP VALUE 0.     
             10 S-RS2-COMPANY-NO           PIC X(02)  VALUE SPACES.     
             10 S-RS2-CNTRCT-START-DT      PIC X(10)  VALUE SPACES.     
             10 S-RS2-CNTRCT-END-DT        PIC X(10)  VALUE SPACES.     
             10 S-RS2-CONTRACT-TERM-CD     PIC X(01)  VALUE SPACES.     
             10 S-RS2-CONTRACT-DEMAND      PIC S9(09)V9(2)              
                                                       COMP-3 VALUE 0.  
             10 S-RS2-ANN-REVIEW-MONTH     PIC X(02)  VALUE SPACES.     
             10 S-RS2-SPCL-MO-MIN-AM       PIC S9(07)V9(2)              
                                                       COMP-3 VALUE 0.  
             10 S-RS2-SPCL-ANN-MIN-AM      PIC S9(11)V9(2)              
                                                       COMP-3 VALUE 0.  
             10 S-RS2-ANN-MIN-TYPE-CD      PIC X(01)  VALUE SPACES.     
             10 S-RS2-DEM-CNSLDTN-CD       PIC X(01)  VALUE SPACES.     
             10 S-RS2-BUILD-UP-MONTHS      PIC S9(04) COMP  VALUE 0.    
             10 S-RS2-LFTM-HI-PEAK-DMD     PIC S9(07)V                  
                                                      COMP-3 VALUE 0.   
             10 S-RS2-DATE-LFTM-HI-DMD     PIC X(10) VALUE SPACES.      
             10 S-RS2-DFLT-USAGE-CLS-CD    PIC X(01) VALUE SPACES.      
             10 S-RS2-FIRM-PER-HR-KWH      PIC S9(09)V9(2)              
                                                      COMP-3 VALUE 0.   
             10 S-RS2-OFF-PEAK-CNT-DMD     PIC S9(07)V                  
                                                      COMP-3 VALUE 0.   
             10 S-RS2-CBL-REF-RATE-PLN     PIC X(03) VALUE SPACES.      
             10 S-RS2-CONTRACT-ECON-DEM    PIC S9(07)V                  
                                                      COMP-3 VALUE 0.   
             10 S-RS2-MIN-DMD-QTY          PIC S9(11)V                  
                                                      COMP-3 VALUE 0.   
             10 S-RS2-PRTY-SVC-CAT-CD      PIC X(02)  VALUE SPACES.     
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR VOLUME BLOCK DETAILS           *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3            PIC S9(04) COMP VALUE 0.     
             10 S-RS3-PRIMARY-IC-NO        PIC S9(04) COMP VALUE 0.     
             10 S-RS3-RATE-PLAN-NO         PIC X(03)  VALUE SPACES.     
             10 S-RS3-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS3-IC-NO                PIC S9(04) COMP VALUE 0.     
             10 S-RS3-CNTRCT-START-DT      PIC X(10)  VALUE SPACES.     
             10 S-RS3-PRTY-SVC-CAT-CD      PIC X(02)  VALUE SPACES.     
             10 S-RS3-VOL-BLOCK-FACTOR     PIC S9(07)V                  
                                                      COMP-3 VALUE 0.   
             10 S-RS3-CONTRACT-DEMAND      PIC S9(09)V9(2)              
                                                      COMP-3 VALUE 0.   
             10 S-RS3-ALTERNATE-FUEL-CD    PIC X(01)  VALUE SPACES.     
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR TRANSPORT AGREEMENT DETAILS    *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4            PIC S9(04) COMP VALUE 0.     
             10 S-RS4-PRIMARY-IC-NO        PIC S9(04) COMP VALUE 0.     
             10 S-RS4-PRIMARY-RATE-PLAN-NO PIC X(03)  VALUE SPACES.     
             10 S-RS4-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS4-IC-NO                PIC S9(04) COMP VALUE 0.     
             10 S-RS4-CNTRCT-START-DT      PIC X(10)  VALUE SPACES.     
             10 S-RS4-TRNSP-SHRINK-PCT     PIC S9(04)V9(2)              
                                                      COMP-3 VALUE 0.   
             10 S-RS4-FUEL-SHIPPER-CD      PIC X(01)  VALUE SPACES.     
             10 S-RS4-TRNSP-MDQ            PIC S9(07)V                  
                                                      COMP-3 VALUE 0.   
             10 S-RS4-PRTY-SVC-CAT-CD      PIC X(02)  VALUE SPACES.     
             10 S-RS4-TRANSP-RATE-PLAN-NO  PIC X(03)  VALUE SPACES.     
             10 S-RS4-CODE-REVENUE-CLASS   PIC X(03)  VALUE SPACES.     
             10 S-RS4-CONTRACT-DEMAND      PIC S9(09)V9(2)              
                                                      COMP-3 VALUE 0.   
             10 S-RS4-FACTOR               PIC S9(13)V9(4)              
                                                      COMP-3 VALUE 0.   
             10 S-RS4-TRANSM-ACCOUNT-NO    PIC S9(05)V                  
                                                      COMP-3 VALUE 0.   
             10 S-RS4-MAX-CNTRCT-START-DT  PIC X(10)  VALUE SPACES.     
             10 S-RS4-MAX-CNTRCT-END-DT    PIC X(10)  VALUE SPACES.     
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BASELINE CONTRACT DETAILS      *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5            PIC S9(04) COMP VALUE 0.     
             10 S-RS5-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS5-IC-NO                PIC S9(04) COMP VALUE 0.     
             10 S-RS5-CNTRCT-START-DT      PIC X(10)  VALUE SPACES.     
             10 S-RS5-BASELINE-MONTH       PIC S9(04) COMP VALUE 0.     
             10 S-RS5-CMPNT-ID-CD          PIC X(02)  VALUE SPACES.     
             10 S-RS5-INSTR-USE-TYPE-CD    PIC X(01)  VALUE SPACES.     
             10 S-RS5-CODE-TIME-PERIOD     PIC S9(9)  COMP VALUE 0.     
             10 S-RS5-BASELINE-UNITS       PIC S9(9)V9(1)               
                                                      COMP-3 VALUE 0.   
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR INTERRUPT ACCOUNT DETAILS      *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6            PIC S9(04) COMP VALUE 0.     
             10 S-RS6-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS6-IC-NO                PIC S9(04) COMP VALUE 0.     
             10 S-RS6-TYP-INTRPT-DEMAND    PIC S9(9)V                   
                                                      COMP-3 VALUE 0.   
             10 S-RS6-CATEGORY             PIC X(02)  VALUE SPACES.     
             10 S-RS6-CONTRACT-DATE        PIC X(10)  VALUE SPACES.     
             10 S-RS6-FIRM-DEMAND-LEVEL    PIC S9(9)V                   
                                                      COMP-3 VALUE 0.   
             10 S-RS6-CURTAILMENT-IND      PIC X(01)  VALUE SPACES.     
             10 S-RS6-USER-ID-ACCT-MGR     PIC X(07)  VALUE SPACES.     
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR INTERRUPT DETAILS              *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-7.                                       
             10 S-RETURN-CODE-7            PIC S9(04) COMP VALUE 0.     
             10 S-RS7-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS7-IC-NO                PIC S9(04) COMP VALUE 0.     
             10 S-RS7-NON-COMPLIANCE-IND   PIC X(01)  VALUE SPACES.     
             10 S-RS7-INTERRUPT-DT         PIC X(10)  VALUE SPACES.     
             10 S-RS7-INTERRUPT-TIME-OFF   PIC X(08)  VALUE SPACES.     
             10 S-RS7-INTERRUPT-TIME-ON    PIC X(08)  VALUE SPACES.     
             10 S-RS7-TOTAL-HOURS          PIC X(08)  VALUE SPACES.     
             10 S-RS7-EXCEPTION-CD         PIC X(02)  VALUE SPACES.     
             10 S-RS7-POWER-COST           PIC S9(9)V9(6)               
                                                      COMP-3 VALUE 0.   
             10 S-RS7-INTERRUPT-REASON     PIC X(254) VALUE SPACES.     
             10 S-RS7-INTERRUPT-END        PIC X(10)  VALUE SPACES.     
             10 S-RS7-NOTIFY-DATE          PIC X(10)  VALUE SPACES.     
             10 S-RS7-NOTIFY-TIME          PIC X(08)  VALUE SPACES.     
             10 S-RS7-NOTIFY-NAME          PIC X(50)  VALUE SPACES.     
             10 S-RS7-NOTIFY-POSITION      PIC X(30)  VALUE SPACES.     
             10 S-RS7-USER-ID-NOTIFY-BY    PIC X(07)  VALUE SPACES.     
             10 S-RS7-TYP-INTRPT-DEMAND    PIC S9(9)V                   
                                                      COMP-3 VALUE 0.   
             10 S-RS7-RESP-CUSTOMER        PIC X(254) VALUE SPACES.     
             10 S-RS7-REMARKS              PIC X(254) VALUE SPACES.     
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BILL ALTERNATE FUEL SUPPLY     *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-8.                                       
             10 S-RETURN-CODE-8            PIC S9(04) COMP VALUE 0.     
             10 S-RS8-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS8-IC-NO                PIC S9(04) COMP VALUE 0.     
             10 S-RS8-CNTRCT-START-DT      PIC X(10)  VALUE SPACES.     
             10 S-RS8-ALTN-FUEL-SPLY-CD    PIC X(01)  VALUE SPACES.     
             10 S-RS8-ALT-SPLY-RATE-NO     PIC X(03)  VALUE SPACES.     
             10 S-RS8-ALT-SPLY-REV-CL-CD   PIC X(03)  VALUE SPACES.     
             10 S-RS8-FUEL-SHIPPER-CD      PIC X(01)  VALUE SPACES.     
             10 S-RS8-ALTERNATE-FUEL-CD    PIC X(01)  VALUE SPACES.     
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ALTN_FUEL_SPLY AK                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBALTSPY                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_CONTRACT  BK                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY    C8                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DEMAND_INSTR   DI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDMDINS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR     FF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_INTERRUPT_ACCT IP                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINTACT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_INTERRUPT      IR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINTRPT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_COMP_DEF  J1                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_BSLN_CNTR LN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLCNTB                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PRICE_SCHED    PS                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC   RD                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR     RT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR        SF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TRNSP_CONTRACT   TW                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTRNCNT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TRNSP_VOL_BLK    TZ                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTRNBLK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_VOL_BLOCK        UB                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBVOLBLK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT     UT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PRTY_SVC_CAT     Z4                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH THE BILL CONTRACT DETAILS        *        
      *   ON THE ACCOUNT NO.                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE BILL_CNRCT  CURSOR FOR                           
                SELECT BK.ACCOUNT_NO                                    
                      ,BK.IC_NO                                         
                      ,UT.RATE_PLAN_NO                                  
                      ,UT.COMPANY_NO                                    
                      ,UT.CODE_CURTAIL_PRTY                             
                      ,BK.CODE_UTIL_TYPE                                
                      ,BK.CNTRCT_START_DT                               
                      ,CIS.CHAR2$DATE(CNTRCT_START_DT,'USA')                    
                      ,CIS.CHAR2$DATE(CNTRCT_END_DT,'USA')                      
                      ,BK.CONTRACT_DEMAND                               
                      ,BK.BUILD_UP_MONTHS                               
                      ,BK.SPCL_MO_MIN_AM                                
                      ,BK.SPCL_ANN_MIN_AM                               
                      ,BK.ANN_MIN_TYPE_CD                               
                      ,BK.CBL_REF_RATE_PLN                              
                      ,BK.COMP_RATE_PLAN                                
                      ,BK.COMPARE_TYPE_CD                               
                      ,BK.LFTM_HI_PEAK_DMD                              
                      ,CIS.CHAR2$DATE(DATE_LFTM_HI_DMD,'USA')                   
                      ,BK.STDBY_LIMIT_HRS                               
                      ,BK.STDBY_LIMIT_PK_HRS                            
                      ,BK.STDBY_YTD_PK_HRS                              
                      ,BK.STDBY_YTD_HRS                                 
                      ,BK.STDBY_RESET_MTH                               
                      ,BK.DFLT_USAGE_CLS_CD                             
                      ,BK.DEM_CNSLDTN_CD                                
                      ,BK.MAX_ECON_DEM                                  
                      ,BK.CONTRACT_ECON_DEM                             
                      ,BK.FIRM_PER_HR_KWH                               
                      ,BK.VERS_PRORATE_CD                               
                      ,BK.CONTRACT_TERM_CD                              
                      ,BK.ANN_REVIEW_MONTH                              
                  FROM CSS_BILL_CONTRACT  BK WITH(READUNCOMMITTED)              
                      ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)              
                 WHERE BK.ACCOUNT_NO         = :BK-ACCOUNT-NO           
                   AND BK.ACCOUNT_NO         = UT.ACCOUNT_NO            
                   AND BK.IC_NO              = UT.IC_NO                 
                   AND BK.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE        
                   AND UT.CODE_UTIL_TYPE     <> 'U'                     
                   AND BK.CNTRCT_END_DT      > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CUT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUT-OFF-DATE
              ) <> 0) OR (LEN(:WS-CUT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUT-OFF-DATE
              ), CONVERT(DATE, :WS-CUT-OFF-DATE) )         
                   ORDER BY BK.CNTRCT_START_DT DESC                     
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BILL_CNRCT  CURSOR FOR                                   
MFA-TR*         SELECT BK.ACCOUNT_NO                                            
MFA-TR*               ,BK.IC_NO                                                 
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*               ,UT.COMPANY_NO                                            
MFA-TR*               ,UT.CODE_CURTAIL_PRTY                                     
MFA-TR*               ,BK.CODE_UTIL_TYPE                                        
MFA-TR*               ,BK.CNTRCT_START_DT                                       
MFA-TR*               ,CHAR(CNTRCT_START_DT,USA)                                
MFA-TR*               ,CHAR(CNTRCT_END_DT,USA)                                  
MFA-TR*               ,BK.CONTRACT_DEMAND                                       
MFA-TR*               ,BK.BUILD_UP_MONTHS                                       
MFA-TR*               ,BK.SPCL_MO_MIN_AM                                        
MFA-TR*               ,BK.SPCL_ANN_MIN_AM                                       
MFA-TR*               ,BK.ANN_MIN_TYPE_CD                                       
MFA-TR*               ,BK.CBL_REF_RATE_PLN                                      
MFA-TR*               ,BK.COMP_RATE_PLAN                                        
MFA-TR*               ,BK.COMPARE_TYPE_CD                                       
MFA-TR*               ,BK.LFTM_HI_PEAK_DMD                                      
MFA-TR*               ,CHAR(DATE_LFTM_HI_DMD,USA)                               
MFA-TR*               ,BK.STDBY_LIMIT_HRS                                       
MFA-TR*               ,BK.STDBY_LIMIT_PK_HRS                                    
MFA-TR*               ,BK.STDBY_YTD_PK_HRS                                      
MFA-TR*               ,BK.STDBY_YTD_HRS                                         
MFA-TR*               ,BK.STDBY_RESET_MTH                                       
MFA-TR*               ,BK.DFLT_USAGE_CLS_CD                                     
MFA-TR*               ,BK.DEM_CNSLDTN_CD                                        
MFA-TR*               ,BK.MAX_ECON_DEM                                          
MFA-TR*               ,BK.CONTRACT_ECON_DEM                                     
MFA-TR*               ,BK.FIRM_PER_HR_KWH                                       
MFA-TR*               ,BK.VERS_PRORATE_CD                                       
MFA-TR*               ,BK.CONTRACT_TERM_CD                                      
MFA-TR*               ,BK.ANN_REVIEW_MONTH                                      
MFA-TR*           FROM CSS_BILL_CONTRACT  BK                                    
MFA-TR*               ,CSS_UTIL_ENVRNMT   UT                                    
MFA-TR*          WHERE BK.ACCOUNT_NO         = :BK-ACCOUNT-NO                   
MFA-TR*            AND BK.ACCOUNT_NO         = UT.ACCOUNT_NO                    
MFA-TR*            AND BK.IC_NO              = UT.IC_NO                         
MFA-TR*            AND BK.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                
MFA-TR*            AND UT.CODE_UTIL_TYPE     <> 'U'                             
MFA-TR*            AND BK.CNTRCT_END_DT      > :WS-CUT-OFF-DATE                 
MFA-TR*            ORDER BY BK.CNTRCT_START_DT DESC                             
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH THE ALTERNATE FUEL DETAILS       *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE ALTN_FUEL CURSOR FOR                             
               SELECT AK.CODE_UTIL_TYPE                                 
                     ,AK.IC_NO                                          
                     ,AK.CNTRCT_START_DT                                
                     ,AK.ALTN_FUEL_SPLY_CD                              
                     ,AK.ALT_SPLY_RATE_NO                               
                     ,AK.ALT_SPLY_REV_CL_CD                             
                     ,AK.FUEL_SHIPPER_CD                                
                     ,AK.ALTERNATE_FUEL_CD                              
                 FROM CSS_ALTN_FUEL_SPLY AK WITH(READUNCOMMITTED)               
                     ,CSS_BILL_CONTRACT  BK WITH(READUNCOMMITTED)               
                WHERE AK.ACCOUNT_NO      = :AK-ACCOUNT-NO               
                  AND AK.ACCOUNT_NO      = BK.ACCOUNT_NO                
                  AND AK.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE            
                  AND AK.IC_NO           = BK.IC_NO                     
                  AND AK.CNTRCT_START_DT = BK.CNTRCT_START_DT           
                  AND BK.CNTRCT_END_DT   > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CUT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUT-OFF-DATE
              ) <> 0) OR (LEN(:WS-CUT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUT-OFF-DATE
              ), CONVERT(DATE, :WS-CUT-OFF-DATE) )             
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04460001
MFA-TR*        DECLARE ALTN_FUEL CURSOR FOR                                     
MFA-TR*        SELECT AK.CODE_UTIL_TYPE                                 04470001
MFA-TR*              ,AK.IC_NO                                          04470001
MFA-TR*              ,AK.CNTRCT_START_DT                                        
MFA-TR*              ,AK.ALTN_FUEL_SPLY_CD                              04470001
MFA-TR*              ,AK.ALT_SPLY_RATE_NO                                       
MFA-TR*              ,AK.ALT_SPLY_REV_CL_CD                                     
MFA-TR*              ,AK.FUEL_SHIPPER_CD                                        
MFA-TR*              ,AK.ALTERNATE_FUEL_CD                                      
MFA-TR*          FROM CSS_ALTN_FUEL_SPLY AK                                     
MFA-TR*              ,CSS_BILL_CONTRACT  BK                                     
MFA-TR*         WHERE AK.ACCOUNT_NO      = :AK-ACCOUNT-NO                       
MFA-TR*           AND AK.ACCOUNT_NO      = BK.ACCOUNT_NO                        
MFA-TR*           AND AK.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE                    
MFA-TR*           AND AK.IC_NO           = BK.IC_NO                             
MFA-TR*           AND AK.CNTRCT_START_DT = BK.CNTRCT_START_DT                   
MFA-TR*           AND BK.CNTRCT_END_DT   > :WS-CUT-OFF-DATE                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    04480001
      ******************************************************************        
      *   CURSOR DECLARATION FOR VOLUME BLOCK DETAILS       *                   
      ******************************************************************        
           EXEC SQL DECLARE VOL_BLOCK CURSOR FOR                        
               SELECT UB.PRIMARY_IC_NO                                  
                     ,UB.VOL_BLOCK_FACTOR                               
                     ,UB.IC_NO                                          
                     ,UB.VOL_BLOCK_SEQ                                  
                     ,UB.CODE_UTIL_TYPE                                 
                     ,UB.CNTRCT_START_DT                                
                     ,UT.ALTERNATE_FUEL_CD                              
                     ,UT.RATE_PLAN_NO                                   
                     ,UT.CODE_CURTAIL_PRTY                              
                     ,UT.COMPANY_NO                                     
                     ,BK.CONTRACT_DEMAND                                
                 FROM CSS_VOL_BLOCK UB WITH(READUNCOMMITTED)                    
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                
                WHERE UB.ACCOUNT_NO       = :UB-ACCOUNT-NO              
                  AND UB.ACCOUNT_NO       = BK.ACCOUNT_NO               
                  AND UB.CODE_UTIL_TYPE   = BK.CODE_UTIL_TYPE           
                  AND UB.IC_NO            = BK.IC_NO                    
                  AND UB.CNTRCT_START_DT  = BK.CNTRCT_START_DT          
                  AND BK.CNTRCT_END_DT    > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CUT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUT-OFF-DATE
              ) <> 0) OR (LEN(:WS-CUT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUT-OFF-DATE
              ), CONVERT(DATE, :WS-CUT-OFF-DATE) )            
                  AND UB.ACCOUNT_NO       = UT.ACCOUNT_NO               
                  AND UB.IC_NO            = UT.IC_NO                    
                  AND UB.CODE_UTIL_TYPE   = UT.CODE_UTIL_TYPE           
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE VOL_BLOCK CURSOR FOR                                
MFA-TR*        SELECT UB.PRIMARY_IC_NO                                          
MFA-TR*              ,UB.VOL_BLOCK_FACTOR                                       
MFA-TR*              ,UB.IC_NO                                                  
MFA-TR*              ,UB.VOL_BLOCK_SEQ                                          
MFA-TR*              ,UB.CODE_UTIL_TYPE                                         
MFA-TR*              ,UB.CNTRCT_START_DT                                        
MFA-TR*              ,UT.ALTERNATE_FUEL_CD                                      
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*              ,UT.CODE_CURTAIL_PRTY                                      
MFA-TR*              ,UT.COMPANY_NO                                             
MFA-TR*              ,BK.CONTRACT_DEMAND                                        
MFA-TR*          FROM CSS_VOL_BLOCK UB                                          
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_BILL_CONTRACT BK                                      
MFA-TR*         WHERE UB.ACCOUNT_NO       = :UB-ACCOUNT-NO                      
MFA-TR*           AND UB.ACCOUNT_NO       = BK.ACCOUNT_NO                       
MFA-TR*           AND UB.CODE_UTIL_TYPE   = BK.CODE_UTIL_TYPE                   
MFA-TR*           AND UB.IC_NO            = BK.IC_NO                            
MFA-TR*           AND UB.CNTRCT_START_DT  = BK.CNTRCT_START_DT                  
MFA-TR*           AND BK.CNTRCT_END_DT    > :WS-CUT-OFF-DATE                    
MFA-TR*           AND UB.ACCOUNT_NO       = UT.ACCOUNT_NO                       
MFA-TR*           AND UB.IC_NO            = UT.IC_NO                            
MFA-TR*           AND UB.CODE_UTIL_TYPE   = UT.CODE_UTIL_TYPE                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7300                                                  
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      *   CURSOR DECLARATION FOR TRANSPORT AGREEMENT DETAILS*                   
      ******************************************************************        
           EXEC SQL DECLARE TRANS_AGRMNT CURSOR FOR                     
                SELECT TW.PRIMARY_IC_NO                                 
                      ,TW.CODE_UTIL_TYPE                                
                      ,TW.CNTRCT_START_DT                               
                      ,TW.TRNSP_SHRINK_PCT                              
                      ,TW.TRNSP_MDQ                                     
                      ,TW.TRANSM_ACCT_NO                                
                      ,TW.FUEL_SHIPPER_CD                               
                      ,TZ.IC_NO                                         
                      ,TZ.CODE_REVENUE_CLASS                            
                      ,TZ.RATE_PLAN_NO                                  
                      ,TZ.TRNSP_SEQ                                     
                      ,UT.RATE_PLAN_NO                                  
                      ,UT.CODE_CURTAIL_PRTY                             
                      ,UT.COMPANY_NO                                    
                      ,BK.CONTRACT_DEMAND                               
                      ,BK.CNTRCT_END_DT                                 
                  FROM CSS_TRNSP_CONTRACT  TW WITH(READUNCOMMITTED)             
                      ,CSS_TRNSP_VOL_BLK   TZ WITH(READUNCOMMITTED)             
                      ,CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)             
                      ,CSS_BILL_CONTRACT   BK WITH(READUNCOMMITTED)             
                 WHERE TW.ACCOUNT_NO        = :TW-ACCOUNT-NO            
                   AND TW.ACCOUNT_NO        = TZ.ACCOUNT_NO             
                   AND TW.CODE_UTIL_TYPE    = TZ.CODE_UTIL_TYPE         
                   AND TW.PRIMARY_IC_NO     = TZ.PRIMARY_IC_NO          
                   AND TW.CNTRCT_START_DT   = TZ.CNTRCT_START_DT        
                   AND TZ.ACCOUNT_NO        = BK.ACCOUNT_NO             
                   AND TZ.CODE_UTIL_TYPE    = BK.CODE_UTIL_TYPE         
                   AND TZ.CNTRCT_START_DT   = BK.CNTRCT_START_DT        
                   AND TZ.IC_NO             = BK.IC_NO                  
                   AND BK.CNTRCT_END_DT     > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CUT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUT-OFF-DATE
              ) <> 0) OR (LEN(:WS-CUT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUT-OFF-DATE
              ), CONVERT(DATE, :WS-CUT-OFF-DATE) )          
                   AND TZ.ACCOUNT_NO        = UT.ACCOUNT_NO             
                   AND TZ.IC_NO             = UT.IC_NO                  
                   AND TZ.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE         
                 ORDER BY TW.CNTRCT_START_DT DESC                       
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE TRANS_AGRMNT CURSOR FOR                             
MFA-TR*         SELECT TW.PRIMARY_IC_NO                                         
MFA-TR*               ,TW.CODE_UTIL_TYPE                                        
MFA-TR*               ,TW.CNTRCT_START_DT                                       
MFA-TR*               ,TW.TRNSP_SHRINK_PCT                                      
MFA-TR*               ,TW.TRNSP_MDQ                                             
MFA-TR*               ,TW.TRANSM_ACCT_NO                                        
MFA-TR*               ,TW.FUEL_SHIPPER_CD                                       
MFA-TR*               ,TZ.IC_NO                                                 
MFA-TR*               ,TZ.CODE_REVENUE_CLASS                                    
MFA-TR*               ,TZ.RATE_PLAN_NO                                          
MFA-TR*               ,TZ.TRNSP_SEQ                                             
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*               ,UT.CODE_CURTAIL_PRTY                                     
MFA-TR*               ,UT.COMPANY_NO                                            
MFA-TR*               ,BK.CONTRACT_DEMAND                                       
MFA-TR*               ,BK.CNTRCT_END_DT                                         
MFA-TR*           FROM CSS_TRNSP_CONTRACT  TW                                   
MFA-TR*               ,CSS_TRNSP_VOL_BLK   TZ                                   
MFA-TR*               ,CSS_UTIL_ENVRNMT    UT                                   
MFA-TR*               ,CSS_BILL_CONTRACT   BK                                   
MFA-TR*          WHERE TW.ACCOUNT_NO        = :TW-ACCOUNT-NO                    
MFA-TR*            AND TW.ACCOUNT_NO        = TZ.ACCOUNT_NO                     
MFA-TR*            AND TW.CODE_UTIL_TYPE    = TZ.CODE_UTIL_TYPE                 
MFA-TR*            AND TW.PRIMARY_IC_NO     = TZ.PRIMARY_IC_NO                  
MFA-TR*            AND TW.CNTRCT_START_DT   = TZ.CNTRCT_START_DT                
MFA-TR*            AND TZ.ACCOUNT_NO        = BK.ACCOUNT_NO                     
MFA-TR*            AND TZ.CODE_UTIL_TYPE    = BK.CODE_UTIL_TYPE                 
MFA-TR*            AND TZ.CNTRCT_START_DT   = BK.CNTRCT_START_DT                
MFA-TR*            AND TZ.IC_NO             = BK.IC_NO                          
MFA-TR*            AND BK.CNTRCT_END_DT     > :WS-CUT-OFF-DATE                  
MFA-TR*            AND TZ.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*            AND TZ.IC_NO             = UT.IC_NO                          
MFA-TR*            AND TZ.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                 
MFA-TR*          ORDER BY TW.CNTRCT_START_DT DESC                               
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION FOR BASE LINE CONTRACT DETAILS*                    
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BSLN_CNTR CURSOR FOR                              
               SELECT LN.CODE_UTIL_TYPE                                 
                     ,LN.IC_NO                                          
                     ,LN.CNTRCT_START_DT                                
                     ,LN.CMPNT_ID_CD                                    
                     ,LN.INSTR_USE_TYPE_CD                              
                     ,LN.CODE_TIME_PERIOD                               
                     ,LN.BASELINE_MONTH                                 
                     ,LN.BASELINE_UNITS                                 
                 FROM CSS_BILL_BSLN_CNTR LN WITH(READUNCOMMITTED)               
                     ,CSS_BILL_CONTRACT  BK WITH(READUNCOMMITTED)               
                WHERE LN.ACCOUNT_NO      = :LN-ACCOUNT-NO               
                  AND LN.ACCOUNT_NO      = BK.ACCOUNT_NO                
                  AND LN.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE            
                  AND LN.IC_NO           = BK.IC_NO                     
                  AND LN.CNTRCT_START_DT = BK.CNTRCT_START_DT           
                  AND BK.CNTRCT_END_DT   > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CUT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUT-OFF-DATE
              ) <> 0) OR (LEN(:WS-CUT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUT-OFF-DATE
              ), CONVERT(DATE, :WS-CUT-OFF-DATE) )             
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BSLN_CNTR CURSOR FOR                                      
MFA-TR*        SELECT LN.CODE_UTIL_TYPE                                         
MFA-TR*              ,LN.IC_NO                                                  
MFA-TR*              ,LN.CNTRCT_START_DT                                        
MFA-TR*              ,LN.CMPNT_ID_CD                                            
MFA-TR*              ,LN.INSTR_USE_TYPE_CD                                      
MFA-TR*              ,LN.CODE_TIME_PERIOD                                       
MFA-TR*              ,LN.BASELINE_MONTH                                         
MFA-TR*              ,LN.BASELINE_UNITS                                         
MFA-TR*          FROM CSS_BILL_BSLN_CNTR LN                                     
MFA-TR*              ,CSS_BILL_CONTRACT  BK                                     
MFA-TR*         WHERE LN.ACCOUNT_NO      = :LN-ACCOUNT-NO                       
MFA-TR*           AND LN.ACCOUNT_NO      = BK.ACCOUNT_NO                        
MFA-TR*           AND LN.CODE_UTIL_TYPE  = BK.CODE_UTIL_TYPE                    
MFA-TR*           AND LN.IC_NO           = BK.IC_NO                             
MFA-TR*           AND LN.CNTRCT_START_DT = BK.CNTRCT_START_DT                   
MFA-TR*           AND BK.CNTRCT_END_DT   > :WS-CUT-OFF-DATE                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      *   CURSOR DECLARATION FOR INTERRUPT ACCOUNT  DETAILS*                    
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE INTRPT_ACCT CURSOR FOR                            
               SELECT IP.CODE_UTIL_TYPE                                 
                     ,IP.IC_NO                                          
                     ,IP.TYP_INTRPT_DEMAND                              
                     ,IP.CATEGORY                                       
                     ,IP.CONTRACT_DATE                                  
                     ,IP.FIRM_DEMAND_LEVEL                              
                     ,IP.CURTAILMENT_IND                                
                     ,IP.USER_ID_ACCT_MGR                               
                 FROM CSS_INTERRUPT_ACCT IP WITH(READUNCOMMITTED)               
                WHERE IP.ACCOUNT_NO      = :IP-ACCOUNT-NO               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INTRPT_ACCT CURSOR FOR                                    
MFA-TR*        SELECT IP.CODE_UTIL_TYPE                                         
MFA-TR*              ,IP.IC_NO                                                  
MFA-TR*              ,IP.TYP_INTRPT_DEMAND                                      
MFA-TR*              ,IP.CATEGORY                                               
MFA-TR*              ,IP.CONTRACT_DATE                                          
MFA-TR*              ,IP.FIRM_DEMAND_LEVEL                                      
MFA-TR*              ,IP.CURTAILMENT_IND                                        
MFA-TR*              ,IP.USER_ID_ACCT_MGR                                       
MFA-TR*          FROM CSS_INTERRUPT_ACCT IP                                     
MFA-TR*         WHERE IP.ACCOUNT_NO      = :IP-ACCOUNT-NO                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      *   CURSOR DECLARATION FOR INTERRUPT DETAILS         *                    
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE INTRPT_CSR  CURSOR FOR                            
               SELECT IR.CODE_UTIL_TYPE                                 
                     ,IR.IC_NO                                          
                     ,IR.NON_COMPLIANCE_IND                             
                     ,IR.INTERRUPT_DATE                                 
                     ,REPLACE(CONVERT(CHAR(8), IR.INTERRUPT_TIME_OFF
           , 108), ':', '.') INTERRUPT_TIME_OFF                             
                     ,REPLACE(CONVERT(CHAR(8), IR.INTERRUPT_TIME_ON
           , 108), ':', '.') INTERRUPT_TIME_ON                              
                     ,CIS.SUBSTR3$(CIS.DECIMAL2CHAR(CIS.DIFFTIME( 
           IR.INTERRUPT_TIME_ON, IR.INTERRUPT_TIME_OFF )), 2, 6)               
                     ,IR.EXCEPTION_CD                                   
                     ,IR.POWER_COST                                     
                     ,IR.INTERRUPT_REASON                               
                     ,IR.NOTIFY_DATE                                    
                     ,REPLACE(CONVERT(CHAR(8), IR.NOTIFY_TIME, 108), 
           ':', '.') NOTIFY_TIME                                    
                     ,IR.NOTIFY_NAME                                    
                     ,IR.NOTIFY_POSITION                                
                     ,IR.USER_ID_NOTIFY_BY                              
                     ,IR.RESP_CUSTOMER                                  
                     ,IR.REMARKS                                        
                     ,IP.TYP_INTRPT_DEMAND                              
                 FROM CSS_INTERRUPT      IR WITH(READUNCOMMITTED)               
                     ,CSS_INTERRUPT_ACCT IP WITH(READUNCOMMITTED)               
                WHERE IR.ACCOUNT_NO      = :IR-ACCOUNT-NO               
                  AND IR.ACCOUNT_NO      = IP.ACCOUNT_NO                
                  AND IR.IC_NO           = IP.IC_NO                     
                  AND IR.CODE_UTIL_TYPE  = IP.CODE_UTIL_TYPE            
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INTRPT_CSR  CURSOR FOR                                    
MFA-TR*        SELECT IR.CODE_UTIL_TYPE                                         
MFA-TR*              ,IR.IC_NO                                                  
MFA-TR*              ,IR.NON_COMPLIANCE_IND                                     
MFA-TR*              ,IR.INTERRUPT_DATE                                         
MFA-TR*              ,IR.INTERRUPT_TIME_OFF                                     
MFA-TR*              ,IR.INTERRUPT_TIME_ON                                      
MFA-TR*              ,SUBSTR(CHAR(IR.INTERRUPT_TIME_ON  -                       
MFA-TR*               IR.INTERRUPT_TIME_OFF),2,6)                               
MFA-TR*              ,IR.EXCEPTION_CD                                           
MFA-TR*              ,IR.POWER_COST                                             
MFA-TR*              ,IR.INTERRUPT_REASON                                       
MFA-TR*              ,IR.NOTIFY_DATE                                            
MFA-TR*              ,IR.NOTIFY_TIME                                            
MFA-TR*              ,IR.NOTIFY_NAME                                            
MFA-TR*              ,IR.NOTIFY_POSITION                                        
MFA-TR*              ,IR.USER_ID_NOTIFY_BY                                      
MFA-TR*              ,IR.RESP_CUSTOMER                                          
MFA-TR*              ,IR.REMARKS                                                
MFA-TR*              ,IP.TYP_INTRPT_DEMAND                                      
MFA-TR*          FROM CSS_INTERRUPT      IR                                     
MFA-TR*              ,CSS_INTERRUPT_ACCT IP                                     
MFA-TR*         WHERE IR.ACCOUNT_NO      = :IR-ACCOUNT-NO                       
MFA-TR*           AND IR.ACCOUNT_NO      = IP.ACCOUNT_NO                        
MFA-TR*           AND IR.IC_NO           = IP.IC_NO                             
MFA-TR*           AND IR.CODE_UTIL_TYPE  = IP.CODE_UTIL_TYPE                    
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
       LINKAGE SECTION.                                                 
       01 I-ACCOUNT-NO          PIC X(13).                              
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02920000
      * 0100-INITIALIZE                                                *02930000
      *                                                                *02940000
      *     1. RESET DB2 ERROR HANDLERS                                *02950000
      *     2. DECLARE CURSORS FOR RETURN VALUES.                      *02960000
      *                                                                *02990000
      ******************************************************************03000000
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                          TO ACTIVE-PARAGRAPH.    
           PERFORM 0100A-DECLARE-GTT-R1         THRU 0100A-EXIT.        
           PERFORM 0100B-DECLARE-GTT-R2         THRU 0100B-EXIT.        
           MOVE 'BILL-CONTRACT-MONTHS'          TO C8-DELINQ-CD         
           PERFORM 7000-GET-DELINQUENCY-VALUE   THRU 7000-EXIT          
           MOVE C8-DELINQ-VALUE                 TO WS-CUT-OFF-MNTHS     
           PERFORM 7025-GET-CUT-OFF-DATE        THRU 7025-EXIT.         
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE '0100A'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CUSTOMER_TYPE CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE      AS RETURN_CODE         
                      ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE      
                      ,CNTRCT_START_DT           AS CNTRCT_START_DT     
                      ,CNTRCT_END_DT             AS CNTRCT_END_DT       
                      ,CUSTOMER_TYPE             AS CUSTOMER_TYPE       
                  FROM #CSR04745_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE      AS RETURN_CODE                 
MFA-TR*               ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE              
MFA-TR*               ,CNTRCT_START_DT           AS CNTRCT_START_DT             
MFA-TR*               ,CNTRCT_END_DT             AS CNTRCT_END_DT               
MFA-TR*               ,CUSTOMER_TYPE             AS CUSTOMER_TYPE               
MFA-TR*           FROM SESSION.CSR04745_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE '0100B'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CNTRCT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CONTRACT_TERM_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CONTRACT_DEMAND         DECIMAL(9,2)               
                   ,ANN_REVIEW_MONTH CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SPCL_MO_MIN_AM          DECIMAL(7,2)               
                   ,SPCL_ANN_MIN_AM         DECIMAL(11,2)              
                   ,ANN_MIN_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DEM_CNSLDTN_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUILD_UP_MONTHS         INT                     
                   ,LFTM_HI_PEAK_DMD        DECIMAL(7,0)               
                   ,DATE_LFTM_HI_DMD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DFLT_USAGE_CLS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIRM_PER_HR_KWH         DECIMAL(9,2)               
                   ,OFF_PEAK_DEMAND         DECIMAL(7,0)               
                   ,CBL_REF_RATE_PLN CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CONTRACT_ECON_DEM       DECIMAL(7,0)               
                   ,MIN_DMD_QTY             DECIMAL(11,0)              
                   ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE               AS RETURN_CODE         
                      ,RATE_PLAN_NO              AS RATE_PLAN_NO        
                      ,RATE_PLAN_DESC            AS RATE_DESC           
                      ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE      
                      ,IC_NO                     AS IC_NO               
                      ,COMPANY_NO                AS COMPANY_NO          
                      ,CNTRCT_START_DT           AS CNTRCT_START_DT     
                      ,CNTRCT_END_DT             AS CNTRCT_END_DT       
                      ,CONTRACT_TERM_CD          AS CONTRACT_TERM_CD    
                      ,CONTRACT_DEMAND           AS CONTRACT_DEMAND     
                      ,ANN_REVIEW_MONTH          AS ANN_REVIEW_MONTH    
                      ,SPCL_MO_MIN_AM            AS SPCL_MO_MIN_AM      
                      ,SPCL_ANN_MIN_AM           AS SPCL_ANN_MIN_AM     
                      ,ANN_MIN_TYPE_CD           AS ANN_MIN_TYPE_CD     
                      ,DEM_CNSLDTN_CD            AS DEM_CNSLDTN_CD      
                      ,BUILD_UP_MONTHS           AS BUILD_UP_MONTHS     
                      ,LFTM_HI_PEAK_DMD          AS LFTM_HI_PEAK_DMD    
                      ,DATE_LFTM_HI_DMD          AS DATE_LFTM_HI_DMD    
                      ,DFLT_USAGE_CLS_CD         AS DFLT_USAGE_CLS_CD   
                      ,FIRM_PER_HR_KWH           AS FIRM_PER_HR_KWH     
                      ,OFF_PEAK_DEMAND           AS OFF_PEAK_DEMAND     
                      ,CBL_REF_RATE_PLN          AS CBL_REF_RATE_PLN    
                      ,CONTRACT_ECON_DEM         AS CONTRACT_ECON_DEM   
                      ,MIN_DMD_QTY               AS MIN_DMD_QTY         
                      ,PRTY_SVC_CAT_CD           AS PRTY_SVC_CAT_CD     
                  FROM #CSR04745_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE               AS RETURN_CODE                 
MFA-TR*               ,RATE_PLAN_NO              AS RATE_PLAN_NO                
MFA-TR*               ,RATE_PLAN_DESC            AS RATE_DESC                   
MFA-TR*               ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE              
MFA-TR*               ,IC_NO                     AS IC_NO                       
MFA-TR*               ,COMPANY_NO                AS COMPANY_NO                  
MFA-TR*               ,CNTRCT_START_DT           AS CNTRCT_START_DT             
MFA-TR*               ,CNTRCT_END_DT             AS CNTRCT_END_DT               
MFA-TR*               ,CONTRACT_TERM_CD          AS CONTRACT_TERM_CD            
MFA-TR*               ,CONTRACT_DEMAND           AS CONTRACT_DEMAND             
MFA-TR*               ,ANN_REVIEW_MONTH          AS ANN_REVIEW_MONTH            
MFA-TR*               ,SPCL_MO_MIN_AM            AS SPCL_MO_MIN_AM              
MFA-TR*               ,SPCL_ANN_MIN_AM           AS SPCL_ANN_MIN_AM             
MFA-TR*               ,ANN_MIN_TYPE_CD           AS ANN_MIN_TYPE_CD             
MFA-TR*               ,DEM_CNSLDTN_CD            AS DEM_CNSLDTN_CD              
MFA-TR*               ,BUILD_UP_MONTHS           AS BUILD_UP_MONTHS             
MFA-TR*               ,LFTM_HI_PEAK_DMD          AS LFTM_HI_PEAK_DMD            
MFA-TR*               ,DATE_LFTM_HI_DMD          AS DATE_LFTM_HI_DMD            
MFA-TR*               ,DFLT_USAGE_CLS_CD         AS DFLT_USAGE_CLS_CD           
MFA-TR*               ,FIRM_PER_HR_KWH           AS FIRM_PER_HR_KWH             
MFA-TR*               ,OFF_PEAK_DEMAND           AS OFF_PEAK_DEMAND             
MFA-TR*               ,CBL_REF_RATE_PLN          AS CBL_REF_RATE_PLN            
MFA-TR*               ,CONTRACT_ECON_DEM         AS CONTRACT_ECON_DEM           
MFA-TR*               ,MIN_DMD_QTY               AS MIN_DMD_QTY                 
MFA-TR*               ,PRTY_SVC_CAT_CD           AS PRTY_SVC_CAT_CD             
MFA-TR*           FROM SESSION.CSR04745_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100C-DECLARE-GTT-R3                                           *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE '0100C'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,PRIMARY_IC_NO           INT                     
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,VOL_BLOCK_FACTOR        DECIMAL(7,0)               
                   ,CONTRACT_DEMAND         DECIMAL(9,2)               
                   ,ALTERNATE_FUEL_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE               AS RETURN_CODE         
                      ,PRIMARY_IC_NO             AS PRIMARY_IC_NO       
                      ,RATE_PLAN_NO              AS RATE_PLAN_NO        
                      ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE      
                      ,IC_NO                     AS IC_NO               
                      ,CNTRCT_START_DT           AS CNTRCT_START_DT     
                      ,PRTY_SVC_CAT_CD           AS PRTY_SVC_CAT_CD     
                      ,VOL_BLOCK_FACTOR          AS VOL_BLOCK_FACTOR    
                      ,CONTRACT_DEMAND           AS CONTRACT_DEMAND     
                      ,ALTERNATE_FUEL_CD         AS ALTERNATE_FUEL_CD   
                  FROM #CSR04745_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE               AS RETURN_CODE                 
MFA-TR*               ,PRIMARY_IC_NO             AS PRIMARY_IC_NO               
MFA-TR*               ,RATE_PLAN_NO              AS RATE_PLAN_NO                
MFA-TR*               ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE              
MFA-TR*               ,IC_NO                     AS IC_NO                       
MFA-TR*               ,CNTRCT_START_DT           AS CNTRCT_START_DT             
MFA-TR*               ,PRTY_SVC_CAT_CD           AS PRTY_SVC_CAT_CD             
MFA-TR*               ,VOL_BLOCK_FACTOR          AS VOL_BLOCK_FACTOR            
MFA-TR*               ,CONTRACT_DEMAND           AS CONTRACT_DEMAND             
MFA-TR*               ,ALTERNATE_FUEL_CD         AS ALTERNATE_FUEL_CD           
MFA-TR*           FROM SESSION.CSR04745_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 0100D-DECLARE-GTT-R4                                           *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE '0100D'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,PRIMARY_IC_NO           INT                     
                   ,PRIMARY_RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TRNSP_SHRINK_PCT        DECIMAL(4,2)               
                   ,FUEL_SHIPPER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TRNSP_MDQ               DECIMAL(7,0)               
                   ,PRTY_SVC_CAT_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TRANSP_RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CONTRACT_DEMAND         DECIMAL(9,2)               
                   ,FACTOR                  DECIMAL(13,4)               
                   ,TRANSM_ACCOUNT_NO       DECIMAL(5,0)                
                   ,MAX_CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MAX_CNTRCT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE             AS RETURN_CODE           
                      ,PRIMARY_IC_NO           AS PRIMARY_IC_NO         
                      ,PRIMARY_RATE_PLAN_NO    AS PRIMARY_RATE_PLAN_NO  
                      ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE        
                      ,IC_NO                   AS IC_NO                 
                      ,CNTRCT_START_DT         AS CNTRCT_START_DT       
                      ,TRNSP_SHRINK_PCT        AS TRNSP_SHRINK_PCT      
                      ,FUEL_SHIPPER_CD         AS FUEL_SHIPPER_CD       
                      ,TRNSP_MDQ               AS TRNSP_MDQ             
                      ,PRTY_SVC_CAT_CD         AS PRTY_SVC_CAT_CD       
                      ,TRANSP_RATE_PLAN_NO     AS TRANSP_RATE_PLAN_NO   
                      ,CODE_REVENUE_CLASS      AS CODE_REVENUE_CLASS    
                      ,CONTRACT_DEMAND         AS CONTRACT_DEMAND       
                      ,FACTOR                  AS FACTOR                
                      ,TRANSM_ACCOUNT_NO       AS TRANSM_ACCOUNT_NO     
                      ,MAX_CNTRCT_START_DT     AS MAX_CNTRCT_START_DT   
                      ,MAX_CNTRCT_END_DT       AS MAX_CNTRCT_END_DT     
                  FROM #CSR04745_R4                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE             AS RETURN_CODE                   
MFA-TR*               ,PRIMARY_IC_NO           AS PRIMARY_IC_NO                 
MFA-TR*               ,PRIMARY_RATE_PLAN_NO    AS PRIMARY_RATE_PLAN_NO          
MFA-TR*               ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE                
MFA-TR*               ,IC_NO                   AS IC_NO                         
MFA-TR*               ,CNTRCT_START_DT         AS CNTRCT_START_DT               
MFA-TR*               ,TRNSP_SHRINK_PCT        AS TRNSP_SHRINK_PCT              
MFA-TR*               ,FUEL_SHIPPER_CD         AS FUEL_SHIPPER_CD               
MFA-TR*               ,TRNSP_MDQ               AS TRNSP_MDQ                     
MFA-TR*               ,PRTY_SVC_CAT_CD         AS PRTY_SVC_CAT_CD               
MFA-TR*               ,TRANSP_RATE_PLAN_NO     AS TRANSP_RATE_PLAN_NO           
MFA-TR*               ,CODE_REVENUE_CLASS      AS CODE_REVENUE_CLASS            
MFA-TR*               ,CONTRACT_DEMAND         AS CONTRACT_DEMAND               
MFA-TR*               ,FACTOR                  AS FACTOR                        
MFA-TR*               ,TRANSM_ACCOUNT_NO       AS TRANSM_ACCOUNT_NO             
MFA-TR*               ,MAX_CNTRCT_START_DT     AS MAX_CNTRCT_START_DT           
MFA-TR*               ,MAX_CNTRCT_END_DT       AS MAX_CNTRCT_END_DT             
MFA-TR*           FROM SESSION.CSR04745_R4                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 0100E-DECLARE-GTT-R5.                                          *        
      ******************************************************************        
       0100E-DECLARE-GTT-R5.                                            
                                                                        
           MOVE '0100E'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R5'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R5
              (                                                       
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BASELINE_MONTH          INT                     
                   ,CMPNT_ID_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INSTR_USE_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CODE_TIME_PERIOD        INT                     
                   ,BASELINE_UNITS          DECIMAL(10,1)              
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS    THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100E'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE             AS RETURN_CODE           
                      ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE        
                      ,IC_NO                   AS IC_NO                 
                      ,CNTRCT_START_DT         AS CNTRCT_START_DT       
                      ,BASELINE_MONTH          AS BASELINE_MONTH        
                      ,CMPNT_ID_CD             AS CMPNT_ID_CD           
                      ,INSTR_USE_TYPE_CD       AS INSTR_USE_TYPE_CD     
                      ,CODE_TIME_PERIOD        AS CODE_TIME_PERIOD      
                      ,BASELINE_UNITS          AS BASELINE_UNITS        
                  FROM #CSR04745_R5                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE             AS RETURN_CODE                   
MFA-TR*               ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE                
MFA-TR*               ,IC_NO                   AS IC_NO                         
MFA-TR*               ,CNTRCT_START_DT         AS CNTRCT_START_DT               
MFA-TR*               ,BASELINE_MONTH          AS BASELINE_MONTH                
MFA-TR*               ,CMPNT_ID_CD             AS CMPNT_ID_CD                   
MFA-TR*               ,INSTR_USE_TYPE_CD       AS INSTR_USE_TYPE_CD             
MFA-TR*               ,CODE_TIME_PERIOD        AS CODE_TIME_PERIOD              
MFA-TR*               ,BASELINE_UNITS          AS BASELINE_UNITS                
MFA-TR*           FROM SESSION.CSR04745_R5                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100E-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 0100F-DECLARE-GTT-R6.                                          *        
      ******************************************************************        
       0100F-DECLARE-GTT-R6.                                            
                                                                        
           MOVE '0100F'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R6'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R6
              (                                                       
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,TYP_INTRPT_DEMAND       DECIMAL(9,0)               
                   ,CATEGORY CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,CONTRACT_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FIRM_DEMAND_LEVEL       DECIMAL(9,0)               
                   ,CURTAILMENT_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,USER_ID_ACCT_MGR CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000F-DEL-GTT-ROWS    THRU 8000F-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100F'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C6 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE             AS RETURN_CODE           
                      ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE        
                      ,IC_NO                   AS IC_NO                 
                      ,TYP_INTRPT_DEMAND       AS TYP_INTRPT_DEMAND     
                      ,CATEGORY                AS CATEGORY              
                      ,CONTRACT_DATE           AS CONTRACT_DATE         
                      ,FIRM_DEMAND_LEVEL       AS FIRM_DEMAND_LEVEL     
                      ,CURTAILMENT_IND         AS CURTAILMENT_IND       
                      ,USER_ID_ACCT_MGR        AS USER_ID_ACCT_MGR      
                  FROM #CSR04745_R6                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE             AS RETURN_CODE                   
MFA-TR*               ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE                
MFA-TR*               ,IC_NO                   AS IC_NO                         
MFA-TR*               ,TYP_INTRPT_DEMAND       AS TYP_INTRPT_DEMAND             
MFA-TR*               ,CATEGORY                AS CATEGORY                      
MFA-TR*               ,CONTRACT_DATE           AS CONTRACT_DATE                 
MFA-TR*               ,FIRM_DEMAND_LEVEL       AS FIRM_DEMAND_LEVEL             
MFA-TR*               ,CURTAILMENT_IND         AS CURTAILMENT_IND               
MFA-TR*               ,USER_ID_ACCT_MGR        AS USER_ID_ACCT_MGR              
MFA-TR*           FROM SESSION.CSR04745_R6                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100F-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 0100G-DECLARE-GTT-R7.                                          *        
      ******************************************************************        
       0100G-DECLARE-GTT-R7.                                            
                                                                        
           MOVE '0100G'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R7'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R7')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R7
              (                                                       
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,NON_COMPLIANCE_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INTERRUPT_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INTERRUPT_TIME_OFF CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INTERRUPT_TIME_ON CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TOTAL_HOURS CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EXCEPTION_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,POWER_COST              DECIMAL(9,6)                
                   ,INTERRUPT_REASON CHAR(254)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,INTERRUPT_END CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NOTIFY_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NOTIFY_TIME CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NOTIFY_NAME CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,NOTIFY_POSITION CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,USER_ID_NOTIFY_BY CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TYP_INTRPT_DEMAND       DECIMAL(9,0)                
                   ,RESP_CUSTOMER CHAR(254)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,REMARKS CHAR(254)  COLLATE LATIN1_GENERAL_100_BIN2          
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000G-DEL-GTT-ROWS    THRU 8000G-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100G'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C7 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE             AS RETURN_CODE           
                      ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE        
                      ,IC_NO                   AS IC_NO                 
                      ,NON_COMPLIANCE_IND      AS NON_COMPLIANCE_IND    
                      ,INTERRUPT_DATE          AS INTERRUPT_DATE        
                      ,INTERRUPT_TIME_OFF      AS INTERRUPT_TIME_OFF    
                      ,INTERRUPT_TIME_ON       AS INTERRUPT_TIME_ON     
                      ,TOTAL_HOURS             AS TOTAL_HOURS           
                      ,EXCEPTION_CD            AS EXCEPTION_CD          
                      ,POWER_COST              AS POWER_COST            
                      ,INTERRUPT_REASON        AS INTERRUPT_REASON      
                      ,INTERRUPT_END           AS INTERRUPT_END         
                      ,NOTIFY_DATE             AS NOTIFY_DATE           
                      ,NOTIFY_TIME             AS NOTIFY_TIME           
                      ,NOTIFY_NAME             AS NOTIFY_NAME           
                      ,NOTIFY_POSITION         AS NOTIFY_POSITION       
                      ,USER_ID_NOTIFY_BY       AS USER_ID_NOTIFY_BY     
                      ,TYP_INTRPT_DEMAND       AS TYP_INTRPT_DEMAND     
                      ,RESP_CUSTOMER           AS RESP_CUSTOMER         
                      ,REMARKS                 AS REMARKS               
                  FROM #CSR04745_R7                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C7 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE             AS RETURN_CODE                   
MFA-TR*               ,CODE_UTIL_TYPE          AS CODE_UTIL_TYPE                
MFA-TR*               ,IC_NO                   AS IC_NO                         
MFA-TR*               ,NON_COMPLIANCE_IND      AS NON_COMPLIANCE_IND            
MFA-TR*               ,INTERRUPT_DATE          AS INTERRUPT_DATE                
MFA-TR*               ,INTERRUPT_TIME_OFF      AS INTERRUPT_TIME_OFF            
MFA-TR*               ,INTERRUPT_TIME_ON       AS INTERRUPT_TIME_ON             
MFA-TR*               ,TOTAL_HOURS             AS TOTAL_HOURS                   
MFA-TR*               ,EXCEPTION_CD            AS EXCEPTION_CD                  
MFA-TR*               ,POWER_COST              AS POWER_COST                    
MFA-TR*               ,INTERRUPT_REASON        AS INTERRUPT_REASON              
MFA-TR*               ,INTERRUPT_END           AS INTERRUPT_END                 
MFA-TR*               ,NOTIFY_DATE             AS NOTIFY_DATE                   
MFA-TR*               ,NOTIFY_TIME             AS NOTIFY_TIME                   
MFA-TR*               ,NOTIFY_NAME             AS NOTIFY_NAME                   
MFA-TR*               ,NOTIFY_POSITION         AS NOTIFY_POSITION               
MFA-TR*               ,USER_ID_NOTIFY_BY       AS USER_ID_NOTIFY_BY             
MFA-TR*               ,TYP_INTRPT_DEMAND       AS TYP_INTRPT_DEMAND             
MFA-TR*               ,RESP_CUSTOMER           AS RESP_CUSTOMER                 
MFA-TR*               ,REMARKS                 AS REMARKS                       
MFA-TR*           FROM SESSION.CSR04745_R7                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100G-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 0100H-DECLARE-GTT-R8                                           *        
      ******************************************************************        
       0100H-DECLARE-GTT-R8.                                            
                                                                        
           MOVE '0100H'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04745_R8'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04745_R8')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04745_R8
              (                                                       
                    RETURN_CODE             INT                     
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ALTN_FUEL_SPLY_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ALT_SPLY_RATE_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ALT_SPLY_REV_CL_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FUEL_SHIPPER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ALTERNATE_FUEL_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000H-DEL-GTT-ROWS    THRU 8000H-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100H'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C8 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE               AS RETURN_CODE         
                      ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE      
                      ,IC_NO                     AS IC_NO               
                      ,CNTRCT_START_DT           AS CNTRCT_START_DT     
                      ,ALTN_FUEL_SPLY_CD         AS ALTN_FUEL_SPLY_CD   
                      ,ALT_SPLY_RATE_NO          AS ALTN_SPLY_RATE_NO   
                      ,ALT_SPLY_REV_CL_CD        AS ALTN_SPLY_REV_CL_CD 
                      ,FUEL_SHIPPER_CD           AS FUEL_SHIPPER_CD     
                      ,ALTERNATE_FUEL_CD         AS ALTERNATE_FUEL_CD   
                  FROM #CSR04745_R8                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C8 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE               AS RETURN_CODE                 
MFA-TR*               ,CODE_UTIL_TYPE            AS CODE_UTIL_TYPE              
MFA-TR*               ,IC_NO                     AS IC_NO                       
MFA-TR*               ,CNTRCT_START_DT           AS CNTRCT_START_DT             
MFA-TR*               ,ALTN_FUEL_SPLY_CD         AS ALTN_FUEL_SPLY_CD           
MFA-TR*               ,ALT_SPLY_RATE_NO          AS ALTN_SPLY_RATE_NO           
MFA-TR*               ,ALT_SPLY_REV_CL_CD        AS ALTN_SPLY_REV_CL_CD         
MFA-TR*               ,FUEL_SHIPPER_CD           AS FUEL_SHIPPER_CD             
MFA-TR*               ,ALTERNATE_FUEL_CD         AS ALTERNATE_FUEL_CD           
MFA-TR*           FROM SESSION.CSR04745_R8                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100H-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                       TO ACTIVE-PARAGRAPH.       
           MOVE I-ACCOUNT-NO                 TO BK-ACCOUNT-NO.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7100-OPEN-BILL-CNTRCT     THRU 7100-EXIT.            
           PERFORM 7110-FETCH-BILL-CNTRCT    THRU 7110-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2100-DETERMINE-ACCT-TYPE  THRU 2100-EXIT          
              PERFORM 2110-DECLARE-GTTS         THRU 2110-EXIT          
              PERFORM 2500-BUILD-BILL-CNTRCT    THRU 2500-EXIT          
                                                UNTIL NO-MORE-BK-ROWS   
              PERFORM 7120-CLOSE-BILL-CNTRCT    THRU 7120-EXIT          
              EVALUATE WS-CUSTOMER-TYPE                                 
                  WHEN 'CIG '                                           
                       PERFORM 2600-BUILD-VOL-BLOCK   THRU 2600-EXIT    
                  WHEN 'SCEG'                                           
                       PERFORM 2700-BUILD-INTERRUPT   THRU 2700-EXIT    
                  WHEN 'PSNC'                                           
                       PERFORM 2800-BUILD-ALTN-FUEL   THRU 2800-EXIT    
              END-EVALUATE                                              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 2150-DETERMINE-ACCT-TYPE     THRU 2150-EXIT    
                 PERFORM 2110-DECLARE-GTTS            THRU 2110-EXIT    
                 PERFORM 2160-LOAD-BILL-CNTRCT        THRU 2160-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-DETERMINE-ACCT-TYPE.                                      *        
      ******************************************************************        
        2100-DETERMINE-ACCT-TYPE.                                       
                                                                        
             IF UT-COMPANY-NO = WS-PSNC                                 
                MOVE 'PSNC'       TO WS-CUSTOMER-TYPE                   
             ELSE                                                       
                IF BK-CODE-UTIL-TYPE = 'E'                              
                   MOVE 'SCEG'    TO WS-CUSTOMER-TYPE                   
                ELSE                                                    
                   MOVE BK-CODE-UTIL-TYPE           TO J1-CODE-UTIL-TYPE
                   MOVE UT-RATE-PLAN-NO             TO J1-RATE-PLAN-NO  
                   PERFORM 7050-CHECK-CIG-CUSTOMER  THRU 7050-EXIT      
                   IF WS-CIG-CUSTOMER = 'Y'                             
                      MOVE 'CIG'  TO WS-CUSTOMER-TYPE                   
                   ELSE                                                 
                      MOVE 'SCEG' TO WS-CUSTOMER-TYPE                   
                   END-IF                                               
                END-IF                                                  
             END-IF.                                                    
                                                                        
        2100-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      *                                                                *        
      * 2110-DECLARE-GTTS.                                             *        
      ******************************************************************        
        2110-DECLARE-GTTS.                                              
                                                                        
             EVALUATE WS-CUSTOMER-TYPE                                  
                 WHEN 'CIG '                                            
                      PERFORM 0100C-DECLARE-GTT-R3   THRU 0100C-EXIT    
                      PERFORM 0100D-DECLARE-GTT-R4   THRU 0100D-EXIT    
                 WHEN 'SCEG'                                            
                      PERFORM 0100E-DECLARE-GTT-R5   THRU 0100E-EXIT    
                      PERFORM 0100F-DECLARE-GTT-R6   THRU 0100F-EXIT    
                      PERFORM 0100G-DECLARE-GTT-R7   THRU 0100G-EXIT    
                 WHEN 'PSNC'                                            
                      PERFORM 0100H-DECLARE-GTT-R8   THRU 0100H-EXIT    
             END-EVALUATE.                                              
                                                                        
        2110-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      *                                                                *        
      * 2150-DETERMINE-ACCT-TYPE.                                      *        
      ******************************************************************        
        2150-DETERMINE-ACCT-TYPE.                                       
                                                                        
             MOVE I-ACCOUNT-NO                      TO UT-ACCOUNT-NO.   
             PERFORM 7010-SELECT-UTIL-ENV-DETAILS   THRU 7010-EXIT.     
                                                                        
             IF UT-COMPANY-NO = WS-PSNC                                 
                MOVE 'PSNC'       TO WS-CUSTOMER-TYPE                   
             ELSE                                                       
                IF UT-CODE-UTIL-TYPE = 'E'                              
                   MOVE 'SCEG'    TO WS-CUSTOMER-TYPE                   
                ELSE                                                    
                   MOVE    UT-CODE-UTIL-TYPE        TO J1-CODE-UTIL-TYPE
                   MOVE    UT-RATE-PLAN-NO          TO J1-RATE-PLAN-NO  
                   PERFORM 7050-CHECK-CIG-CUSTOMER  THRU 7050-EXIT      
                   IF WS-CIG-CUSTOMER = 'Y'                             
                      MOVE 'CIG'  TO WS-CUSTOMER-TYPE                   
                   ELSE                                                 
                      MOVE 'SCEG' TO WS-CUSTOMER-TYPE                   
                   END-IF                                               
                END-IF                                                  
             END-IF.                                                    
                                                                        
        2150-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      * 2160-LOAD-BILL-CNTRCT.                                         *        
      ******************************************************************        
       2160-LOAD-BILL-CNTRCT.                                           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           MOVE UT-CODE-UTIL-TYPE          TO S-RS1-CODE-UTIL-TYPE      
           MOVE SPACES                     TO S-RS1-CNTRCT-START-DT     
           MOVE SPACES                     TO S-RS1-CNTRCT-END-DT       
           MOVE WS-CUSTOMER-TYPE           TO S-RS1-CUSTOMER-TYPE       
                                                                        
           PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT.              
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *2500-BUILD-BILL-CNTRCT.                                                  
      ****************************************************************          
       2500-BUILD-BILL-CNTRCT.                                          
                                                                        
             PERFORM 2510-LOAD-BILL-CNTRCT     THRU 2510-EXIT.          
             PERFORM 2520-LOAD-BILL-CNTRCT-DET THRU 2520-EXIT.          
             PERFORM 7110-FETCH-BILL-CNTRCT    THRU 7110-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-LOAD-BILL-CNTRCT.                                         *        
      ******************************************************************        
       2510-LOAD-BILL-CNTRCT.                                           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           MOVE BK-CODE-UTIL-TYPE          TO S-RS1-CODE-UTIL-TYPE      
           MOVE BK-CNTRCT-START-DT         TO S-RS1-CNTRCT-START-DT     
           MOVE BK-CNTRCT-END-DT           TO S-RS1-CNTRCT-END-DT       
           MOVE WS-CUSTOMER-TYPE           TO S-RS1-CUSTOMER-TYPE       
                                                                        
           PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT.              
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2520-LOAD-BILL-CNTRCT-DET.                                     *        
      ******************************************************************        
       2520-LOAD-BILL-CNTRCT-DET.                                       
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
           MOVE UT-RATE-PLAN-NO               TO S-RS2-RATE-PLAN-NO     
           IF UT-RATE-PLAN-NO NOT EQUAL RD-RATE-PLAN-NO                 
              MOVE    BK-CODE-UTIL-TYPE       TO RD-CODE-UTIL-TYPE      
              MOVE    UT-RATE-PLAN-NO         TO RD-RATE-PLAN-NO        
              PERFORM 7250-SELECT-RATE-PLAN-DESC THRU 7250-EXIT         
           END-IF.                                                      
           MOVE BK-CODE-UTIL-TYPE             TO RT-CODE-UTIL-TYPE      
           MOVE UT-RATE-PLAN-NO               TO RT-RATE-PLAN-NO        
           PERFORM 7255-SELECT-MIN-DMD-QTY    THRU 7255-EXIT            
                                                                        
           IF UT-CODE-CURTAIL-PRTY > 0 AND UT-COMPANY-NO = WS-PSNC      
              PERFORM 7260-GET-SVC-CAT     THRU 7260-EXIT               
              MOVE Z4-PRTY-SVC-CAT-CD         TO S-RS2-PRTY-SVC-CAT-CD  
           ELSE                                                         
              MOVE SPACES                     TO S-RS2-PRTY-SVC-CAT-CD  
           END-IF.                                                      
           MOVE RD-RATE-DESC                  TO S-RS2-RATE-PLAN-DESC   
           MOVE BK-CODE-UTIL-TYPE             TO S-RS2-CODE-UTIL-TYPE   
           MOVE BK-IC-NO                      TO S-RS2-IC-NO            
           MOVE UT-COMPANY-NO                 TO S-RS2-COMPANY-NO       
           MOVE BK-CNTRCT-START-DT            TO S-RS2-CNTRCT-START-DT  
           MOVE BK-CNTRCT-END-DT              TO S-RS2-CNTRCT-END-DT    
           MOVE BK-CONTRACT-TERM-CD           TO S-RS2-CONTRACT-TERM-CD 
           MOVE BK-CONTRACT-DEMAND            TO S-RS2-CONTRACT-DEMAND  
           MOVE BK-ANN-REVIEW-MONTH           TO S-RS2-ANN-REVIEW-MONTH 
           MOVE BK-SPCL-MO-MIN-AM             TO S-RS2-SPCL-MO-MIN-AM   
           MOVE BK-SPCL-ANN-MIN-AM            TO S-RS2-SPCL-ANN-MIN-AM  
           MOVE BK-ANN-MIN-TYPE-CD            TO S-RS2-ANN-MIN-TYPE-CD  
           MOVE BK-DEM-CNSLDTN-CD             TO S-RS2-DEM-CNSLDTN-CD   
           MOVE BK-BUILD-UP-MONTHS            TO S-RS2-BUILD-UP-MONTHS  
           MOVE BK-LFTM-HI-PEAK-DMD           TO S-RS2-LFTM-HI-PEAK-DMD 
           MOVE BK-DATE-LFTM-HI-DMD           TO S-RS2-DATE-LFTM-HI-DMD 
           MOVE BK-DFLT-USAGE-CLS-CD          TO S-RS2-DFLT-USAGE-CLS-CD
           MOVE BK-FIRM-PER-HR-KWH            TO S-RS2-FIRM-PER-HR-KWH  
           MOVE BK-MAX-ECON-DEM               TO S-RS2-OFF-PEAK-CNT-DMD 
           MOVE BK-CBL-REF-RATE-PLN           TO S-RS2-CBL-REF-RATE-PLN 
           MOVE BK-CONTRACT-ECON-DEM          TO S-RS2-CONTRACT-ECON-DEM
           MOVE DI-MIN-DMD-QTY                TO S-RS2-MIN-DMD-QTY      
           PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT.           
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2600-BUILD-VOL-BLOCK.                                          *        
      ******************************************************************        
       2600-BUILD-VOL-BLOCK.                                            
                                                                        
           MOVE    I-ACCOUNT-NO              TO UB-ACCOUNT-NO           
           PERFORM 7300-OPEN-VOL-BLOCK       THRU 7300-EXIT.            
           PERFORM 7310-FETCH-VOL-BLOCK      THRU 7310-EXIT.            
           PERFORM 2610-LOAD-VOL-BLOCK       THRU 2610-EXIT             
                                             UNTIL NO-MORE-VBLK-ROWS.   
           PERFORM 7320-CLOSE-VOL-BLOCK      THRU 7320-EXIT.            
                                                                        
           MOVE    I-ACCOUNT-NO              TO TW-ACCOUNT-NO           
           PERFORM 7400-OPEN-TRANS-AGRMNT    THRU 7400-EXIT.            
           PERFORM 7410-FETCH-TRANS-AGRMNT   THRU 7410-EXIT.            
           PERFORM 2620-LOAD-TRANS-AGRMNT    THRU 2620-EXIT             
                                             UNTIL NO-MORE-TRNS-ROWS.   
           PERFORM 7420-CLOSE-TRANS-AGRMNT   THRU 7420-EXIT.            
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 2610-LOAD-VOL-BLOCK.                                           *        
      ******************************************************************        
       2610-LOAD-VOL-BLOCK.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
                                                                        
           MOVE UB-PRIMARY-IC-NO           TO S-RS3-PRIMARY-IC-NO       
           MOVE UB-VOL-BLOCK-FACTOR        TO S-RS3-VOL-BLOCK-FACTOR    
           MOVE UB-IC-NO                   TO S-RS3-IC-NO               
           MOVE UB-CODE-UTIL-TYPE          TO S-RS3-CODE-UTIL-TYPE      
           MOVE UB-CNTRCT-START-DT         TO S-RS3-CNTRCT-START-DT     
           MOVE BK-CONTRACT-DEMAND         TO S-RS3-CONTRACT-DEMAND     
                                                                        
           MOVE UT-ALTERNATE-FUEL-CD       TO S-RS3-ALTERNATE-FUEL-CD   
           MOVE UT-RATE-PLAN-NO            TO S-RS3-RATE-PLAN-NO        
           IF UT-CODE-CURTAIL-PRTY > 0                                  
              PERFORM 7260-GET-SVC-CAT     THRU 7260-EXIT               
              MOVE Z4-PRTY-SVC-CAT-CD      TO S-RS3-PRTY-SVC-CAT-CD     
           END-IF.                                                      
                                                                        
           PERFORM 8030-INSERT-GTT-R3      THRU 8030-EXIT.              
           PERFORM 7310-FETCH-VOL-BLOCK    THRU 7310-EXIT.              
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2620-LOAD-TRANS-AGRMNT.                                        *        
      ******************************************************************        
       2620-LOAD-TRANS-AGRMNT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-4.                              
                                                                        
           MOVE TW-PRIMARY-IC-NO          TO S-RS4-PRIMARY-IC-NO        
           MOVE UT-RATE-PLAN-NO           TO S-RS4-PRIMARY-RATE-PLAN-NO 
           MOVE TW-CODE-UTIL-TYPE         TO S-RS4-CODE-UTIL-TYPE       
           MOVE TZ-IC-NO                  TO S-RS4-IC-NO                
           MOVE TW-CNTRCT-START-DT        TO S-RS4-CNTRCT-START-DT      
           MOVE TW-TRNSP-SHRINK-PCT       TO S-RS4-TRNSP-SHRINK-PCT     
           MOVE TW-FUEL-SHIPPER-CD        TO S-RS4-FUEL-SHIPPER-CD      
           MOVE TW-TRNSP-MDQ              TO S-RS4-TRNSP-MDQ            
           MOVE TZ-RATE-PLAN-NO           TO S-RS4-TRANSP-RATE-PLAN-NO  
           MOVE TZ-CODE-REVENUE-CLASS     TO S-RS4-CODE-REVENUE-CLASS   
           MOVE TW-TRANSM-ACCT-NO         TO S-RS4-TRANSM-ACCOUNT-NO    
                                                                        
           IF UT-CODE-CURTAIL-PRTY > 0                                  
              PERFORM 7260-GET-SVC-CAT    THRU 7260-EXIT                
              MOVE Z4-PRTY-SVC-CAT-CD     TO S-RS4-PRTY-SVC-CAT-CD      
           END-IF.                                                      
           MOVE    BK-CONTRACT-DEMAND     TO   S-RS4-CONTRACT-DEMAND    
                                                                        
           MOVE    TW-ACCOUNT-NO          TO   FF-ACCOUNT-NO            
           MOVE    TW-CODE-UTIL-TYPE      TO   FF-CODE-UTIL-TYPE        
           MOVE    TZ-IC-NO               TO   FF-IC-NO                 
           MOVE    TW-CNTRCT-START-DT     TO   FF-EFF-DATE-FROM         
           MOVE    BK-CNTRCT-END-DT       TO   FF-EFF-DATE-TO           
           PERFORM 7290-CHECK-FIXED-FACTOR THRU 7290-EXIT               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE TZ-RATE-PLAN-NO        TO RT-RATE-PLAN-NO            
              MOVE TW-CODE-UTIL-TYPE      TO RT-CODE-UTIL-TYPE          
              PERFORM 7295-CHECK-PRICE-SCHED   THRU 7295-EXIT           
              IF PS-SCHED-PRICE-AM > 0                                  
                 MOVE PS-SCHED-PRICE-AM       TO WS-FACTOR-CMP3         
                 MOVE WS-FACTOR-CMP3          TO WS-FACTOR-NUM          
                 MOVE WS-FACTOR-NUM           TO WS-FACTOR              
                 MOVE WS-FACTOR               TO S-RS4-FACTOR           
              ELSE                                                      
                 MOVE 0                       TO S-RS4-FACTOR           
              END-IF                                                    
           ELSE                                                         
              IF SF-FCTR-POWER-10 NOT EQUAL 0                           
                 COMPUTE WS-FACTOR-FF = FF-FACTOR * 10**SF-FCTR-POWER-10
                 MOVE WS-FACTOR-FF            TO WS-FACTOR-CMP3         
              ELSE                                                      
                  MOVE FF-FACTOR              TO WS-FACTOR-CMP3         
              END-IF                                                    
              MOVE WS-FACTOR-CMP3             TO WS-FACTOR-NUM          
              MOVE WS-FACTOR-NUM              TO WS-FACTOR              
              MOVE WS-FACTOR                  TO S-RS4-FACTOR           
           END-IF.                                                      
                                                                        
           MOVE    TW-ACCOUNT-NO          TO   BK-ACCOUNT-NO            
           MOVE    TW-CODE-UTIL-TYPE      TO   BK-CODE-UTIL-TYPE        
           MOVE    TZ-IC-NO               TO   BK-IC-NO                 
           PERFORM 7280-GET-MAX-DATES     THRU 7280-EXIT.               
           MOVE    BK-CNTRCT-START-DT     TO   S-RS4-MAX-CNTRCT-START-DT
           MOVE    BK-CNTRCT-END-DT       TO   S-RS4-MAX-CNTRCT-END-DT  
           PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT.               
           PERFORM 7410-FETCH-TRANS-AGRMNT THRU 7410-EXIT.              
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2700-BUILD-INTERRUPT.                                          *        
      ******************************************************************        
       2700-BUILD-INTERRUPT.                                            
                                                                        
           MOVE    I-ACCOUNT-NO              TO LN-ACCOUNT-NO           
           PERFORM 7500-OPEN-BSLN-CNTR       THRU 7500-EXIT.            
           PERFORM 7510-FETCH-BSLN-CNTR      THRU 7510-EXIT.            
           PERFORM 2710-LOAD-BSLN-CNTR       THRU 2710-EXIT             
                                             UNTIL NO-MORE-BSLN-ROWS.   
           PERFORM 7520-CLOSE-BSLN-CNTR      THRU 7520-EXIT.            
                                                                        
           MOVE    I-ACCOUNT-NO              TO IP-ACCOUNT-NO           
           PERFORM 7600-OPEN-INTRPT-ACCT     THRU 7600-EXIT.            
           PERFORM 7610-FETCH-INTRPT-ACCT    THRU 7610-EXIT.            
           PERFORM 2720-LOAD-INTRPT-ACCT     THRU 2720-EXIT             
                                             UNTIL NO-MORE-INTR-ROWS.   
           PERFORM 7620-CLOSE-INTRPT-ACCT    THRU 7620-EXIT.            
                                                                        
           MOVE    I-ACCOUNT-NO              TO IR-ACCOUNT-NO           
           PERFORM 7700-OPEN-INTRPT-CSR      THRU 7700-EXIT.            
           PERFORM 7710-FETCH-INTRPT-CSR     THRU 7710-EXIT.            
           PERFORM 2730-LOAD-INTRPT-CSR      THRU 2730-EXIT             
                                             UNTIL NO-MORE-INPT-ROWS.   
           PERFORM 7720-CLOSE-INTRPT-CSR     THRU 7720-EXIT.            
                                                                        
       2700-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 2710-LOAD-BSLN-CNTR.                                          *         
      ******************************************************************        
       2710-LOAD-BSLN-CNTR.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-5.                              
           MOVE LN-CODE-UTIL-TYPE         TO S-RS5-CODE-UTIL-TYPE       
           MOVE LN-IC-NO                  TO S-RS5-IC-NO                
           MOVE LN-CNTRCT-START-DT        TO S-RS5-CNTRCT-START-DT      
           MOVE LN-CMPNT-ID-CD            TO S-RS5-CMPNT-ID-CD          
           MOVE LN-INSTR-USE-TYPE-CD      TO S-RS5-INSTR-USE-TYPE-CD    
           MOVE LN-CODE-TIME-PERIOD       TO S-RS5-CODE-TIME-PERIOD     
           MOVE LN-BASELINE-MONTH         TO S-RS5-BASELINE-MONTH       
           MOVE LN-BASELINE-UNITS         TO S-RS5-BASELINE-UNITS       
           PERFORM 8050-INSERT-GTT-R5     THRU 8050-EXIT.               
           PERFORM 7510-FETCH-BSLN-CNTR   THRU 7510-EXIT.               
                                                                        
        2710-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      * 2720-LOAD-INTRPT-ACCT.                                        *         
      ******************************************************************        
       2720-LOAD-INTRPT-ACCT.                                           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-6.                              
           MOVE IP-CODE-UTIL-TYPE         TO S-RS6-CODE-UTIL-TYPE       
           MOVE IP-IC-NO                  TO S-RS6-IC-NO                
           MOVE IP-TYP-INTRPT-DEMAND      TO S-RS6-TYP-INTRPT-DEMAND    
           MOVE IP-CATEGORY               TO S-RS6-CATEGORY             
           MOVE IP-CONTRACT-DATE          TO S-RS6-CONTRACT-DATE        
           MOVE IP-FIRM-DEMAND-LEVEL      TO S-RS6-FIRM-DEMAND-LEVEL    
           MOVE IP-CURTAILMENT-IND        TO S-RS6-CURTAILMENT-IND      
           MOVE IP-USER-ID-ACCT-MGR       TO S-RS6-USER-ID-ACCT-MGR     
           PERFORM 8060-INSERT-GTT-R6     THRU 8060-EXIT.               
           PERFORM 7610-FETCH-INTRPT-ACCT THRU 7610-EXIT.               
                                                                        
        2720-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      * 2730-LOAD-INTRPT-CSR.                                         *         
      ******************************************************************        
       2730-LOAD-INTRPT-CSR.                                            
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-7.                              
           MOVE IR-CODE-UTIL-TYPE         TO S-RS7-CODE-UTIL-TYPE       
           MOVE IR-IC-NO                  TO S-RS7-IC-NO                
           MOVE IR-NON-COMPLIANCE-IND     TO S-RS7-NON-COMPLIANCE-IND   
           MOVE IR-INTERRUPT-DATE         TO S-RS7-INTERRUPT-DT         
           MOVE IR-INTERRUPT-TIME-OFF     TO S-RS7-INTERRUPT-TIME-OFF   
           MOVE IR-INTERRUPT-TIME-ON      TO S-RS7-INTERRUPT-TIME-ON    
           MOVE WS-TOTAL-DIFFERENCE(1:2)  TO WS-TOTAL-HH                
           MOVE '.'                       TO WS-TOTAL-S1                
           MOVE WS-TOTAL-DIFFERENCE(3:2)  TO WS-TOTAL-MM                
           MOVE '.'                       TO WS-TOTAL-S2                
           MOVE WS-TOTAL-DIFFERENCE(5:2)  TO WS-TOTAL-SS                
           MOVE WS-TOTAL-HOURS            TO S-RS7-TOTAL-HOURS          
           MOVE IR-INTERRUPT-DATE         TO S-RS7-INTERRUPT-END        
           MOVE IR-NOTIFY-DATE            TO S-RS7-NOTIFY-DATE          
           MOVE IR-NOTIFY-TIME            TO S-RS7-NOTIFY-TIME          
           MOVE IR-EXCEPTION-CD           TO S-RS7-EXCEPTION-CD         
           MOVE IR-POWER-COST             TO S-RS7-POWER-COST           
           MOVE IR-INTERRUPT-REASON       TO S-RS7-INTERRUPT-REASON     
           MOVE IR-NOTIFY-NAME            TO S-RS7-NOTIFY-NAME          
           MOVE IR-NOTIFY-POSITION        TO S-RS7-NOTIFY-POSITION      
           MOVE IR-USER-ID-NOTIFY-BY      TO S-RS7-USER-ID-NOTIFY-BY    
           MOVE IP-TYP-INTRPT-DEMAND      TO S-RS7-TYP-INTRPT-DEMAND    
           MOVE IR-RESP-CUSTOMER          TO S-RS7-RESP-CUSTOMER        
           MOVE IR-REMARKS-TEXT           TO S-RS7-REMARKS              
           PERFORM 8070-INSERT-GTT-R7     THRU 8070-EXIT.               
           PERFORM 7710-FETCH-INTRPT-CSR  THRU 7710-EXIT.               
                                                                        
        2730-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      * 2800-BUILD-ALTN-FUEL.                                          *        
      ******************************************************************        
       2800-BUILD-ALTN-FUEL.                                            
                                                                        
           MOVE    I-ACCOUNT-NO              TO AK-ACCOUNT-NO           
           PERFORM 7200-OPEN-ALTN-FUEL       THRU 7200-EXIT.            
           PERFORM 7210-FETCH-ALTN-FUEL      THRU 7210-EXIT.            
           PERFORM 2810-LOAD-ALTN-FUEL       THRU 2810-EXIT             
                                             UNTIL NO-MORE-ALTN-ROWS.   
           PERFORM 7220-CLOSE-ALTN-FUEL      THRU 7220-EXIT.            
                                                                        
       2800-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 2810-LOAD-ALTN-FUEL.                                           *        
      ******************************************************************        
       2810-LOAD-ALTN-FUEL.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-8.                              
                                                                        
           MOVE AK-CODE-UTIL-TYPE          TO S-RS8-CODE-UTIL-TYPE      
           MOVE AK-IC-NO                   TO S-RS8-IC-NO               
           MOVE AK-CNTRCT-START-DT         TO S-RS8-CNTRCT-START-DT     
           MOVE AK-ALTN-FUEL-SPLY-CD       TO S-RS8-ALTN-FUEL-SPLY-CD   
           MOVE AK-ALT-SPLY-RATE-NO        TO S-RS8-ALT-SPLY-RATE-NO    
           MOVE AK-ALT-SPLY-REV-CL-CD      TO S-RS8-ALT-SPLY-REV-CL-CD  
           MOVE AK-FUEL-SHIPPER-CD         TO S-RS8-FUEL-SHIPPER-CD     
           MOVE AK-ALTERNATE-FUEL-CD       TO S-RS8-ALTERNATE-FUEL-CD   
                                                                        
           PERFORM 8080-INSERT-GTT-R8      THRU 8080-EXIT.              
           PERFORM 7210-FETCH-ALTN-FUEL    THRU 7210-EXIT.              
                                                                        
       2810-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7000-GET-DELINQUENCY-VALUE.                                    *        
      ******************************************************************        
       7000-GET-DELINQUENCY-VALUE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT DELINQ_VALUE                                       17970000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   17980000
MFA-TR*         FROM CSS_DELINQUENCY C8                                 17990000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         18000000
MFA-TR*          AND COMPANY_NO = '01'                                  18010000
MFA-TR*         WITH UR                                                 18011000
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'C8-DELINQ-CD'            TO TABLE-ELEMENT-1         
              MOVE  C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
              MOVE 'C8-COMPANY-NO'           TO TABLE-ELEMENT-2         
              MOVE  C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7010-SELECT-UTIL-ENV-DETAILS.                                  *        
      ******************************************************************        
       7010-SELECT-UTIL-ENV-DETAILS.                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) UT.COMPANY_NO,
              UT.CODE_UTIL_TYPE,
              UT.RATE_PLAN_NO                                    
                INTO :UT-COMPANY-NO                                     
                    ,:UT-CODE-UTIL-TYPE                                 
                    ,:UT-RATE-PLAN-NO                                   
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                        
               ORDER BY IC_NO                                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT UT.COMPANY_NO                                      17970000
MFA-TR*             ,UT.CODE_UTIL_TYPE                                          
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*         INTO :UT-COMPANY-NO                                     17980000
MFA-TR*             ,:UT-CODE-UTIL-TYPE                                         
MFA-TR*             ,:UT-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                17990000
MFA-TR*        WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                        18000000
MFA-TR*        ORDER BY IC_NO                                           18010000
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                 18011000
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'UT-ACCOUNT-NO'           TO TABLE-ELEMENT-1         
              MOVE  UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7025-GET-CUT-OFF-DATE.                                         *        
      * THIS DATE WILL BE USED TO GET THE CONTRACTS EXPIRED/ACTIVE     *        
      * BEYOND THIS DATE                                               *        
      ******************************************************************        
       7025-GET-CUT-OFF-DATE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT
              DATEADD( MONTH, -(:WS-CUT-OFF-MNTHS), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CUT-OFF-DATE       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CUT-OFF-DATE    =                                          
MFA-TR*           DATE(CURRENT DATE) - (:WS-CUT-OFF-MNTHS) MONTHS               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7025'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SET'                 TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      *7050-CHECK-CIG-CUSTOMER.                                                 
      **************************************************************            
       7050-CHECK-CIG-CUSTOMER.                                         
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-CIG-CUSTOMER                                    
               FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                     
              WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE               
                AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                 
                AND REG_TYPE_CD      =  'D'                             
                AND VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)    
                          FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)          
                          WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE    
                           AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO)     
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-CIG-CUSTOMER                                            
MFA-TR*        FROM CSS_RATE_COMP_DEF                                           
MFA-TR*       WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE                       
MFA-TR*         AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                         
MFA-TR*         AND REG_TYPE_CD      =  'D'                                     
MFA-TR*         AND VERSION_NO_CNTRL = (SELECT MAX(VERSION_NO_CNTRL)            
MFA-TR*                   FROM CSS_RATE_COMP_DEF                                
MFA-TR*                   WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE            
MFA-TR*                    AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO)             
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7050                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-N                  TO WS-CIG-CUSTOMER       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7050'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CSS_RATE_COMP_DEF'    TO TABLE-1              
                    MOVE 'RATE-PLAN-NO'         TO TABLE-ELEMENT-1      
                    MOVE UT-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-1    
                    MOVE 'CODE-UTIL-TYPE'       TO TABLE-ELEMENT-2      
                    MOVE BK-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * OPEN CURSOR FOR CONTRACTS ON GIVEN ACCOUNT                    *         
      *****************************************************************         
                                                                        
       7100-OPEN-BILL-CNTRCT.                                           
                                                                        
           EXEC SQL                                                     
              OPEN BILL_CNRCT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN '             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_BILL_CONTRACT' TO TABLE-1                       
              MOVE 'CSS_UTIL_ENVRNMNT' TO TABLE-2                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE BK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'WS-CUT-OFF-DATE'   TO TABLE-ELEMENT-2               
              MOVE WS-CUT-OFF-DATE     TO HOSTVAR-ELEMENT-2             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7110-FETCH-BILL-CNTRCT.                                                 
      **************************************************************            
                                                                        
       7110-FETCH-BILL-CNTRCT.                                          
                                                                        
           EXEC SQL FETCH BILL_CNRCT                                    
                  INTO :BK-ACCOUNT-NO                                   
                      ,:BK-IC-NO                                        
                      ,:UT-RATE-PLAN-NO                                 
                      ,:UT-COMPANY-NO                                   
                      ,:UT-CODE-CURTAIL-PRTY                            
                      ,:BK-CODE-UTIL-TYPE                               
                      ,:WS-DUMMY-START-DT                               
                      ,:BK-CNTRCT-START-DT                              
                      ,:BK-CNTRCT-END-DT                                
                      ,:BK-CONTRACT-DEMAND                              
                      ,:BK-BUILD-UP-MONTHS                              
                      ,:BK-SPCL-MO-MIN-AM                               
                      ,:BK-SPCL-ANN-MIN-AM                              
                      ,:BK-ANN-MIN-TYPE-CD                              
                      ,:BK-CBL-REF-RATE-PLN                             
                      ,:BK-COMP-RATE-PLAN                               
                      ,:BK-COMPARE-TYPE-CD                              
                      ,:BK-LFTM-HI-PEAK-DMD                             
                      ,:BK-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NI      
                      ,:BK-STDBY-LIMIT-HRS                              
                      ,:BK-STDBY-LIMIT-PK-HRS                           
                      ,:BK-STDBY-YTD-PK-HRS                             
                      ,:BK-STDBY-YTD-HRS                                
                      ,:BK-STDBY-RESET-MTH                              
                      ,:BK-DFLT-USAGE-CLS-CD                            
                      ,:BK-DEM-CNSLDTN-CD                               
                      ,:BK-MAX-ECON-DEM                                 
                      ,:BK-CONTRACT-ECON-DEM                            
                      ,:BK-FIRM-PER-HR-KWH                              
                      ,:BK-VERS-PRORATE-CD                              
                      ,:BK-CONTRACT-TERM-CD                             
                      ,:BK-ANN-REVIEW-MONTH                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-DATE-LFTM-HI-DMD-NI < 0 THEN                  
                       MOVE SPACES             TO BK-DATE-LFTM-HI-DMD   
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                   TO WS-NO-MORE-BK-ROWS    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7110'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_BILL_CONTRACT'  TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE BK-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7120-CLOSE-BILL-CNTRCT.                                                  
      **************************************************************            
                                                                        
       7120-CLOSE-BILL-CNTRCT.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE BILL_CNRCT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7120'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_BILL_CONTRACT'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE BK-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN CURSOR FOR ALTERNATE FUEL SUPPLY FOR PSNC ACCOUNT        *         
      *****************************************************************         
                                                                        
       7200-OPEN-ALTN-FUEL.                                             
                                                                        
           EXEC SQL                                                     
              OPEN ALTN_FUEL                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-8.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN '             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_ALTN_FUEL_SPLY' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7210-FETCH-ALTN-FUEL.                                                   
      **************************************************************            
                                                                        
       7210-FETCH-ALTN-FUEL.                                            
                                                                        
           EXEC SQL FETCH ALTN_FUEL                                     
                  INTO :AK-CODE-UTIL-TYPE                               
                      ,:AK-IC-NO                                        
                      ,:AK-CNTRCT-START-DT                              
                      ,:AK-ALTN-FUEL-SPLY-CD                            
                      ,:AK-ALT-SPLY-RATE-NO                             
                      ,:AK-ALT-SPLY-REV-CL-CD                           
                      ,:AK-FUEL-SHIPPER-CD                              
                      ,:AK-ALTERNATE-FUEL-CD                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-8        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                  TO WS-NO-MORE-ALTN-ROWS   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7210'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_ALTN_FUEL_SPLY' TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE AK-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7220-CLOSE-ALTN-FUEL.                                                    
      **************************************************************            
                                                                        
       7220-CLOSE-ALTN-FUEL.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE ALTN_FUEL                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7220'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ALTN_FUEL_SPLY'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AK-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7250-SELECT-RATE-PLAN-DESC.                                              
      **************************************************************            
       7250-SELECT-RATE-PLAN-DESC.                                      
                                                                        
           EXEC SQL                                                     
             SELECT RATE_DESC                                           
               INTO :RD-RATE-DESC                                       
               FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                    
              WHERE RATE_PLAN_NO   = :RD-RATE-PLAN-NO                   
                AND CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT RATE_DESC                                                   
MFA-TR*        INTO :RD-RATE-DESC                                               
MFA-TR*        FROM CSS_RATE_PLAN_DESC                                          
MFA-TR*       WHERE RATE_PLAN_NO   = :RD-RATE-PLAN-NO                           
MFA-TR*         AND CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                         
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7250                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES                TO RD-RATE-DESC          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7250'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CSS_RATE_PLAN_DESC'   TO TABLE-1              
                    MOVE 'RATE-PLAN-NO'         TO TABLE-ELEMENT-1      
                    MOVE RD-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-1    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************            
      *7255-SELECT-MIN-DMD-QTY.                                                 
      **************************************************************            
       7255-SELECT-MIN-DMD-QTY.                                         
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) DI.MIN_DMD_QTY                                      
               INTO :DI-MIN-DMD-QTY                                     
               FROM CSS_DEMAND_INSTR DI WITH(READUNCOMMITTED)                   
                   ,CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                   
              WHERE RT.CODE_UTIL_TYPE   = :RT-CODE-UTIL-TYPE            
                AND RT.RATE_PLAN_NO     = :RT-RATE-PLAN-NO              
                AND RT.CODE_STATUS      = :WS-A                         
                AND RT.CODE_UTIL_TYPE   = DI.CODE_UTIL_TYPE             
                AND RT.RATE_PLAN_NO     = DI.RATE_PLAN_NO               
                AND RT.VERSION_NO_CNTRL = DI.VERSION_NO_CNTRL           
                AND DI.CMPNT_ID_CD      = :WS-CMPNT-ID-CD               
              ORDER BY DI.VERSION_NO_CNTRL DESC                         
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DI.MIN_DMD_QTY                                              
MFA-TR*        INTO :DI-MIN-DMD-QTY                                             
MFA-TR*        FROM CSS_DEMAND_INSTR DI                                         
MFA-TR*            ,CSS_RATE_CREATOR RT                                         
MFA-TR*       WHERE RT.CODE_UTIL_TYPE   = :RT-CODE-UTIL-TYPE                    
MFA-TR*         AND RT.RATE_PLAN_NO     = :RT-RATE-PLAN-NO                      
MFA-TR*         AND RT.CODE_STATUS      = :WS-A                                 
MFA-TR*         AND RT.CODE_UTIL_TYPE   = DI.CODE_UTIL_TYPE                     
MFA-TR*         AND RT.RATE_PLAN_NO     = DI.RATE_PLAN_NO                       
MFA-TR*         AND RT.VERSION_NO_CNTRL = DI.VERSION_NO_CNTRL                   
MFA-TR*         AND DI.CMPNT_ID_CD      = :WS-CMPNT-ID-CD                       
MFA-TR*       ORDER BY DI.VERSION_NO_CNTRL DESC                                 
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7255                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROS                  TO DI-MIN-DMD-QTY       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7255'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CSS_DEMAND_INSTR'     TO TABLE-1              
                    MOVE 'CSS_RATE_CREATOR'     TO TABLE-2              
                    MOVE 'CODE-UTIL-TYPE'       TO TABLE-ELEMENT-1      
                    MOVE RT-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1    
                    MOVE 'RATE-PLAN-NO'         TO TABLE-ELEMENT-2      
                    MOVE RT-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-2    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7255-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * 7260-GET-SVC-CAT.                                            *          
      ****************************************************************          
                                                                        
       7260-GET-SVC-CAT.                                                
                                                                        
            EXEC SQL                                                    
                SELECT Z4.PRTY_SVC_CAT_CD                               
                 INTO  :Z4-PRTY-SVC-CAT-CD                              
                 FROM CSS_PRTY_SVC_CAT Z4                               
                 WHERE Z4.CODE_CURTAIL_PRTY = :UT-CODE-CURTAIL-PRTY     
                   AND Z4.COMPANY_NO        = :UT-COMPANY-NO            
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PRTY_SVC_CAT'         TO TABLE-1                
              MOVE 'CODE_CURTAIL_PRTY'        TO TABLE-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
            END-IF.                                                     
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7280-GET-MAX-DATES.                                          *          
      ****************************************************************          
                                                                        
       7280-GET-MAX-DATES.                                              
                                                                        
            EXEC SQL                                                    
                SELECT  MAX(CNTRCT_START_DT)                            
                       ,MAX(CNTRCT_END_DT)                              
                 INTO  :BK-CNTRCT-START-DT :WS-NULL-START-DATE           
                      ,:BK-CNTRCT-END-DT :WS-NULL-END-DATE               
                 FROM CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                
                 WHERE ACCOUNT_NO      = :BK-ACCOUNT-NO                 
                   AND CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE             
                   AND IC_NO           = :BK-IC-NO                      
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT  MAX(CNTRCT_START_DT)                                    
MFA-TR*                ,MAX(CNTRCT_END_DT)                                      
MFA-TR*          INTO  :BK-CNTRCT-START-DT:WS-NULL-START-DATE                   
MFA-TR*               ,:BK-CNTRCT-END-DT:WS-NULL-END-DATE                       
MFA-TR*          FROM CSS_BILL_CONTRACT BK                                      
MFA-TR*          WHERE ACCOUNT_NO      = :BK-ACCOUNT-NO                         
MFA-TR*            AND CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE                     
MFA-TR*            AND IC_NO           = :BK-IC-NO                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            EVALUATE WS-ACTIVE-RETURN-CODE                              
                WHEN SUCCESSFUL-CALL                                    
                     IF WS-NULL-START-DATE < 0                          
                        MOVE SPACES TO BK-CNTRCT-START-DT               
                     END-IF                                             
                     IF WS-NULL-END-DATE < 0                            
                        MOVE SPACES TO BK-CNTRCT-END-DT                 
                     END-IF                                             
                WHEN NOT-FOUND                                          
                     CONTINUE                                           
                WHEN OTHER                                              
                     MOVE PROGRAM-NAME        TO ABEND-PROGRAM          
                     MOVE '7280'              TO ACTIVE-PARAGRAPH       
                     MOVE 'SELECT'            TO ABEND-FUNCTION         
                     MOVE 'CSS_BILL_CONTRACT' TO TABLE-1                
                     MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1        
                     MOVE BK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1      
                     MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2        
                     MOVE BK-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2      
                     PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT         
            END-EVALUATE.                                               
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7290-CHECK-FIXED-FACTOR.                                     *          
      ****************************************************************          
                                                                        
       7290-CHECK-FIXED-FACTOR.                                         
                                                                        
            EXEC SQL                                                    
                SELECT FF.FACTOR                                        
                      ,SF.FCTR_POWER_10                                 
                 INTO  :FF-FACTOR                                       
                      ,:SF-FCTR-POWER-10                                
                 FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
                     ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                    
                 WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO               
                   AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE           
                   AND FF.FACTOR_ID      = :WS-TRANSRATE                
                   AND FF.FACTOR_ID      = SF.FACTOR_ID                 
                   AND FF.IC_NO          = :FF-IC-NO                    
                   AND FF.EFF_DATE_FROM >= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )            
                   AND FF.EFF_DATE_TO   <= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )              
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT FF.FACTOR                                                
MFA-TR*               ,SF.FCTR_POWER_10                                         
MFA-TR*          INTO  :FF-FACTOR                                               
MFA-TR*               ,:SF-FCTR-POWER-10                                        
MFA-TR*          FROM CSS_FIXED_FCTR FF                                         
MFA-TR*              ,CSS_SPCL_FCTR SF                                          
MFA-TR*          WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                       
MFA-TR*            AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                   
MFA-TR*            AND FF.FACTOR_ID      = :WS-TRANSRATE                        
MFA-TR*            AND FF.FACTOR_ID      = SF.FACTOR_ID                         
MFA-TR*            AND FF.IC_NO          = :FF-IC-NO                            
MFA-TR*            AND FF.EFF_DATE_FROM >= :FF-EFF-DATE-FROM                    
MFA-TR*            AND FF.EFF_DATE_TO   <= :FF-EFF-DATE-TO                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7290                                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FACTOR'        TO TABLE-1                 
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE  FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE  FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2       
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE  TZ-IC-NO                 TO HOSTVAR-ELEMENT-3       
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-4         
              MOVE  TZ-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7295-CHECK-PRICE-SCHED.                                      *          
      ****************************************************************          
                                                                        
       7295-CHECK-PRICE-SCHED.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SCHED_PRICE_AM                                     
                INTO :PS-SCHED-PRICE-AM                                 
                FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
                    ,CSS_PRICE_SCHED  PS WITH(READUNCOMMITTED)                  
               WHERE RT.RATE_PLAN_NO       = :RT-RATE-PLAN-NO           
                 AND PS.RATE_PLAN_NO       = RT.RATE_PLAN_NO            
                 AND RT.CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE         
                 AND PS.CODE_UTIL_TYPE     = RT.CODE_UTIL_TYPE          
                 AND PS.VERSION_NO_CNTRL   = RT.VERSION_NO_CNTRL        
                 AND RT.CODE_STATUS       IN ('A','F')                  
                 AND PS.CMPNT_ID_CD        = '65'                       
                 AND PS.CODE_SEASON        = 'B'                        
                 AND PS.CODE_USE_INST_TYPE = 'R'                        
                 AND PS.BLOCK_NO           = 1                          
                 AND RT.FROM_EFFECTIVE_DT  =                            
                     (SELECT MAX (RT2.FROM_EFFECTIVE_DT)                
                        FROM CSS_RATE_CREATOR RT2 WITH(READUNCOMMITTED)         
                       WHERE RT2.RATE_PLAN_NO      = RT.RATE_PLAN_NO    
                         AND RT2.CODE_STATUS       IN ('A','F')         
                         AND RT2.CODE_UTIL_TYPE    = RT.CODE_UTIL_TYPE  
                         AND RT2.FROM_EFFECTIVE_DT                      
                                  <= IIF(TRY_CONVERT(DATE, 
                                                      :BK-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-END-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :BK-CNTRCT-END-DT
              ), CONVERT(DATE, :BK-CNTRCT-END-DT) ))                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SCHED_PRICE_AM                                             
MFA-TR*         INTO :PS-SCHED-PRICE-AM                                         
MFA-TR*         FROM CSS_RATE_CREATOR RT                                05110000
MFA-TR*             ,CSS_PRICE_SCHED  PS                                        
MFA-TR*        WHERE RT.RATE_PLAN_NO       = :RT-RATE-PLAN-NO           05120000
MFA-TR*          AND PS.RATE_PLAN_NO       = RT.RATE_PLAN_NO                    
MFA-TR*          AND RT.CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE         05140000
MFA-TR*          AND PS.CODE_UTIL_TYPE     = RT.CODE_UTIL_TYPE                  
MFA-TR*          AND PS.VERSION_NO_CNTRL   = RT.VERSION_NO_CNTRL                
MFA-TR*          AND RT.CODE_STATUS       IN ('A','F')                  05130000
MFA-TR*          AND PS.CMPNT_ID_CD        = '65'                               
MFA-TR*          AND PS.CODE_SEASON        = 'B'                                
MFA-TR*          AND PS.CODE_USE_INST_TYPE = 'R'                                
MFA-TR*          AND PS.BLOCK_NO           = 1                                  
MFA-TR*          AND RT.FROM_EFFECTIVE_DT  =                            05150000
MFA-TR*              (SELECT MAX (RT2.FROM_EFFECTIVE_DT)                05160000
MFA-TR*                 FROM CSS_RATE_CREATOR RT2                       05170000
MFA-TR*                WHERE RT2.RATE_PLAN_NO      = RT.RATE_PLAN_NO    05180000
MFA-TR*                  AND RT2.CODE_STATUS       IN ('A','F')         05190000
MFA-TR*                  AND RT2.CODE_UTIL_TYPE    = RT.CODE_UTIL_TYPE  05200000
MFA-TR*                  AND RT2.FROM_EFFECTIVE_DT                      05210000
MFA-TR*                           <= :BK-CNTRCT-END-DT)                 05220000
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7295                                                   
MFA-TR*    END-EXEC.                                                    05230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE  ZEROS                 TO PS-SCHED-PRICE-AM       
              ELSE                                                      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7295'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PRICE_SCHED_AM'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE  RT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1       
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE  RT-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7295-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN CURSOR FOR VOLUME BLOCKS FOR CIG ACCOUNT                 *         
      *****************************************************************         
                                                                        
       7300-OPEN-VOL-BLOCK.                                             
                                                                        
           EXEC SQL                                                     
              OPEN VOL_BLOCK                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-3.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN '             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_VOL_BLOCK'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE UB-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7310-FETCH-VOL-BLOCK.                                                   
      **************************************************************            
                                                                        
       7310-FETCH-VOL-BLOCK.                                            
                                                                        
           EXEC SQL FETCH VOL_BLOCK                                     
                  INTO :UB-PRIMARY-IC-NO                                
                      ,:UB-VOL-BLOCK-FACTOR                             
                      ,:UB-IC-NO                                        
                      ,:UB-VOL-BLOCK-SEQ                                
                      ,:UB-CODE-UTIL-TYPE                               
                      ,:UB-CNTRCT-START-DT                              
                      ,:UT-ALTERNATE-FUEL-CD                            
                      ,:UT-RATE-PLAN-NO                                 
                      ,:UT-CODE-CURTAIL-PRTY                            
                      ,:UT-COMPANY-NO                                   
                      ,:BK-CONTRACT-DEMAND                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-3        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                  TO WS-NO-MORE-VBLK-ROWS   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7310'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_VOL_BLOCK'      TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE UB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7320-CLOSE-VOL-BLOCK.                                                    
      **************************************************************            
                                                                        
       7320-CLOSE-VOL-BLOCK.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE VOL_BLOCK                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-3.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7320'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_VOL_BLOCK'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE UB-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN CURSOR FOR TRANSPORT AGREEMENT DETAILS FOR CIG ACCOUNT   *         
      *****************************************************************         
                                                                        
       7400-OPEN-TRANS-AGRMNT.                                          
                                                                        
           EXEC SQL                                                     
              OPEN TRANS_AGRMNT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-4.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7400'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN '             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_TRNSP_CONTRACT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE TW-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7410-FETCH-TRANS-AGRMNT.                                                
      **************************************************************            
                                                                        
       7410-FETCH-TRANS-AGRMNT.                                         
                                                                        
           EXEC SQL FETCH TRANS_AGRMNT                                  
                  INTO :TW-PRIMARY-IC-NO                                
                      ,:TW-CODE-UTIL-TYPE                               
                      ,:TW-CNTRCT-START-DT                              
                      ,:TW-TRNSP-SHRINK-PCT                             
                      ,:TW-TRNSP-MDQ                                    
                      ,:TW-TRANSM-ACCT-NO                               
                      ,:TW-FUEL-SHIPPER-CD                              
                      ,:TZ-IC-NO                                        
                      ,:TZ-CODE-REVENUE-CLASS                           
                      ,:TZ-RATE-PLAN-NO                                 
                      ,:TZ-TRNSP-SEQ                                    
                      ,:UT-RATE-PLAN-NO                                 
                      ,:UT-CODE-CURTAIL-PRTY                            
                      ,:UT-COMPANY-NO                                   
                      ,:BK-CONTRACT-DEMAND                              
                      ,:BK-CNTRCT-END-DT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-4        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                  TO WS-NO-MORE-TRNS-ROWS   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7410'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_TRNSP_CONTRACT' TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE TW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7420-CLOSE-TRANS-AGRMNT.                                                 
      **************************************************************            
                                                                        
       7420-CLOSE-TRANS-AGRMNT.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE TRANS_AGRMNT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-4.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7420'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_TRNSP_CONTRACT'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE TW-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN CURSOR FOR BASELINE CONTRACT DETAILS FOR SCEG ACCOUNT   *          
      *****************************************************************         
                                                                        
       7500-OPEN-BSLN-CNTR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN BSLN_CNTR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-5.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7500'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN '             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_BILL_BSLN_CNTR' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE LN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7510-FETCH-BSLN-CNTR.                                                   
      **************************************************************            
                                                                        
       7510-FETCH-BSLN-CNTR.                                            
                                                                        
           EXEC SQL FETCH BSLN_CNTR                                     
                  INTO :LN-CODE-UTIL-TYPE                               
                      ,:LN-IC-NO                                        
                      ,:LN-CNTRCT-START-DT                              
                      ,:LN-CMPNT-ID-CD                                  
                      ,:LN-INSTR-USE-TYPE-CD                            
                      ,:LN-CODE-TIME-PERIOD                             
                      ,:LN-BASELINE-MONTH                               
                      ,:LN-BASELINE-UNITS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-5        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                  TO WS-NO-MORE-BSLN-ROWS   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7510'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_BILL_BSLN_CNTR' TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE LN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7520-CLOSE-BSLN-CNTR.                                                    
      **************************************************************            
                                                                        
       7520-CLOSE-BSLN-CNTR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE BSLN_CNTR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-5.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7520'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_BILL_BSLN_CNTR'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE LN-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN CURSOR FOR INTERRUPT ACCOUNT DETAILS FOR SCEG ACCOUNT   *          
      *****************************************************************         
                                                                        
       7600-OPEN-INTRPT-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              OPEN INTRPT_ACCT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-6.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7600'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN '             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_INTERRUPT_ACCT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE IP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7610-FETCH-INTRPT-ACCT.                                                 
      **************************************************************            
                                                                        
       7610-FETCH-INTRPT-ACCT.                                          
                                                                        
           EXEC SQL FETCH INTRPT_ACCT                                   
                  INTO :IP-CODE-UTIL-TYPE                               
                      ,:IP-IC-NO                                        
                      ,:IP-TYP-INTRPT-DEMAND                            
                      ,:IP-CATEGORY                                     
                      ,:IP-CONTRACT-DATE                                
                      ,:IP-FIRM-DEMAND-LEVEL                            
                      ,:IP-CURTAILMENT-IND                              
                      ,:IP-USER-ID-ACCT-MGR                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-6        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                  TO WS-NO-MORE-INTR-ROWS   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7610'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_INTERRUPT_ACCT' TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE IP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7620-CLOSE-INTRPT-ACCT.                                                  
      **************************************************************            
                                                                        
       7620-CLOSE-INTRPT-ACCT.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE INTRPT_ACCT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-6.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7620'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_INTERRUPT_ACCT'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE IP-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * OPEN CURSOR FOR INTERRUPT DETAILS FOR SCEG ACCOUNT   *                  
      *****************************************************************         
                                                                        
       7700-OPEN-INTRPT-CSR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN INTRPT_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-7.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7700'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN '             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_INTERRUPT'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE IR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7710-FETCH-INTRPT-CSR.                                                  
      **************************************************************            
                                                                        
       7710-FETCH-INTRPT-CSR.                                           
                                                                        
           EXEC SQL FETCH INTRPT_CSR                                    
                  INTO :IR-CODE-UTIL-TYPE                               
                      ,:IR-IC-NO                                        
                      ,:IR-NON-COMPLIANCE-IND                           
                      ,:IR-INTERRUPT-DATE                               
                      ,:IR-INTERRUPT-TIME-OFF                           
                      ,:IR-INTERRUPT-TIME-ON :WS-INTRPT-TIME-ON-NULL     
                      ,:WS-TOTAL-DIFFERENCE                             
                      ,:IR-EXCEPTION-CD                                 
                      ,:IR-POWER-COST                                   
                      ,:IR-INTERRUPT-REASON                             
                      ,:IR-NOTIFY-DATE :WS-NOTIFY-DATE-NULL              
                      ,:IR-NOTIFY-TIME :WS-NOTIFY-TIME-NULL              
                      ,:IR-NOTIFY-NAME                                  
                      ,:IR-NOTIFY-POSITION                              
                      ,:IR-USER-ID-NOTIFY-BY                            
                      ,:IR-RESP-CUSTOMER                                
                      ,:IR-REMARKS                                      
                      ,:IP-TYP-INTRPT-DEMAND                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-7        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-INTRPT-TIME-ON-NULL < 0                       
                       MOVE SPACES TO            IR-INTERRUPT-TIME-ON   
                    END-IF                                              
                    IF WS-NOTIFY-DATE-NULL < 0                          
                       MOVE SPACES TO            IR-NOTIFY-DATE         
                    END-IF                                              
                    IF WS-NOTIFY-TIME-NULL < 0                          
                       MOVE SPACES TO            IR-NOTIFY-TIME         
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                  TO WS-NO-MORE-INPT-ROWS   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7710'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_INTERRUPT'      TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE IR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *7720-CLOSE-INTRPT-CSR.                                                   
      **************************************************************            
                                                                        
       7720-CLOSE-INTRPT-CSR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE INTRPT_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE-7.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7720'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_INTERRUPT'        TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE IR-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000C'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R3'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000D'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R4'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000E-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000E-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000D'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R5'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000F-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000F-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-6.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-6          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000F'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R5'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000F-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000G-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000G-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R7                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R7                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-7.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-7          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000G'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R5'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000G-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000H-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000H-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04745_R8                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04745_R8                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-8.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-8          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000H'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04745_R8'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000H-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,CODE_UTIL_TYPE                                       
                  ,CNTRCT_START_DT                                      
                  ,CNTRCT_END_DT                                        
                  ,CUSTOMER_TYPE                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-CNTRCT-START-DT                               
                  ,:S-RS1-CNTRCT-END-DT                                 
                  ,:S-RS1-CUSTOMER-TYPE                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,CNTRCT_END_DT                                                
MFA-TR*           ,CUSTOMER_TYPE                                                
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS1-CNTRCT-START-DT                                       
MFA-TR*           ,:S-RS1-CNTRCT-END-DT                                         
MFA-TR*           ,:S-RS1-CUSTOMER-TYPE                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,RATE_PLAN_NO                                       
                    ,RATE_PLAN_DESC                                     
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,COMPANY_NO                                         
                    ,CNTRCT_START_DT                                    
                    ,CNTRCT_END_DT                                      
                    ,CONTRACT_TERM_CD                                   
                    ,CONTRACT_DEMAND                                    
                    ,ANN_REVIEW_MONTH                                   
                    ,SPCL_MO_MIN_AM                                     
                    ,SPCL_ANN_MIN_AM                                    
                    ,ANN_MIN_TYPE_CD                                    
                    ,DEM_CNSLDTN_CD                                     
                    ,BUILD_UP_MONTHS                                    
                    ,LFTM_HI_PEAK_DMD                                   
                    ,DATE_LFTM_HI_DMD                                   
                    ,DFLT_USAGE_CLS_CD                                  
                    ,FIRM_PER_HR_KWH                                    
                    ,OFF_PEAK_DEMAND                                    
                    ,CBL_REF_RATE_PLN                                   
                    ,CONTRACT_ECON_DEM                                  
                    ,MIN_DMD_QTY                                        
                    ,PRTY_SVC_CAT_CD                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-RS2-RATE-PLAN-NO                                  
                  ,:S-RS2-RATE-PLAN-DESC                                
                  ,:S-RS2-CODE-UTIL-TYPE                                
                  ,:S-RS2-IC-NO                                         
                  ,:S-RS2-COMPANY-NO                                    
                  ,:S-RS2-CNTRCT-START-DT                               
                  ,:S-RS2-CNTRCT-END-DT                                 
                  ,:S-RS2-CONTRACT-TERM-CD                              
                  ,:S-RS2-CONTRACT-DEMAND                               
                  ,:S-RS2-ANN-REVIEW-MONTH                              
                  ,:S-RS2-SPCL-MO-MIN-AM                                
                  ,:S-RS2-SPCL-ANN-MIN-AM                               
                  ,:S-RS2-ANN-MIN-TYPE-CD                               
                  ,:S-RS2-DEM-CNSLDTN-CD                                
                  ,:S-RS2-BUILD-UP-MONTHS                               
                  ,:S-RS2-LFTM-HI-PEAK-DMD                              
                  ,:S-RS2-DATE-LFTM-HI-DMD                              
                  ,:S-RS2-DFLT-USAGE-CLS-CD                             
                  ,:S-RS2-FIRM-PER-HR-KWH                               
                  ,:S-RS2-OFF-PEAK-CNT-DMD                              
                  ,:S-RS2-CBL-REF-RATE-PLN                              
                  ,:S-RS2-CONTRACT-ECON-DEM                             
                  ,:S-RS2-MIN-DMD-QTY                                   
                  ,:S-RS2-PRTY-SVC-CAT-CD                               
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_PLAN_DESC                                             
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,CNTRCT_START_DT                                            
MFA-TR*             ,CNTRCT_END_DT                                              
MFA-TR*             ,CONTRACT_TERM_CD                                           
MFA-TR*             ,CONTRACT_DEMAND                                            
MFA-TR*             ,ANN_REVIEW_MONTH                                           
MFA-TR*             ,SPCL_MO_MIN_AM                                             
MFA-TR*             ,SPCL_ANN_MIN_AM                                            
MFA-TR*             ,ANN_MIN_TYPE_CD                                            
MFA-TR*             ,DEM_CNSLDTN_CD                                             
MFA-TR*             ,BUILD_UP_MONTHS                                            
MFA-TR*             ,LFTM_HI_PEAK_DMD                                           
MFA-TR*             ,DATE_LFTM_HI_DMD                                           
MFA-TR*             ,DFLT_USAGE_CLS_CD                                          
MFA-TR*             ,FIRM_PER_HR_KWH                                            
MFA-TR*             ,OFF_PEAK_DEMAND                                            
MFA-TR*             ,CBL_REF_RATE_PLN                                           
MFA-TR*             ,CONTRACT_ECON_DEM                                          
MFA-TR*             ,MIN_DMD_QTY                                                
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-RS2-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS2-RATE-PLAN-DESC                                        
MFA-TR*           ,:S-RS2-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS2-IC-NO                                                 
MFA-TR*           ,:S-RS2-COMPANY-NO                                            
MFA-TR*           ,:S-RS2-CNTRCT-START-DT                                       
MFA-TR*           ,:S-RS2-CNTRCT-END-DT                                         
MFA-TR*           ,:S-RS2-CONTRACT-TERM-CD                                      
MFA-TR*           ,:S-RS2-CONTRACT-DEMAND                                       
MFA-TR*           ,:S-RS2-ANN-REVIEW-MONTH                                      
MFA-TR*           ,:S-RS2-SPCL-MO-MIN-AM                                        
MFA-TR*           ,:S-RS2-SPCL-ANN-MIN-AM                                       
MFA-TR*           ,:S-RS2-ANN-MIN-TYPE-CD                                       
MFA-TR*           ,:S-RS2-DEM-CNSLDTN-CD                                        
MFA-TR*           ,:S-RS2-BUILD-UP-MONTHS                                       
MFA-TR*           ,:S-RS2-LFTM-HI-PEAK-DMD                                      
MFA-TR*           ,:S-RS2-DATE-LFTM-HI-DMD                                      
MFA-TR*           ,:S-RS2-DFLT-USAGE-CLS-CD                                     
MFA-TR*           ,:S-RS2-FIRM-PER-HR-KWH                                       
MFA-TR*           ,:S-RS2-OFF-PEAK-CNT-DMD                                      
MFA-TR*           ,:S-RS2-CBL-REF-RATE-PLN                                      
MFA-TR*           ,:S-RS2-CONTRACT-ECON-DEM                                     
MFA-TR*           ,:S-RS2-MIN-DMD-QTY                                           
MFA-TR*           ,:S-RS2-PRTY-SVC-CAT-CD                                       
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R3                           
                 (                                                      
                     RETURN_CODE                                        
                    ,PRIMARY_IC_NO                                      
                    ,RATE_PLAN_NO                                       
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CNTRCT_START_DT                                    
                    ,PRTY_SVC_CAT_CD                                    
                    ,VOL_BLOCK_FACTOR                                   
                    ,CONTRACT_DEMAND                                    
                    ,ALTERNATE_FUEL_CD                                  
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-RS3-PRIMARY-IC-NO                                 
                  ,:S-RS3-RATE-PLAN-NO                                  
                  ,:S-RS3-CODE-UTIL-TYPE                                
                  ,:S-RS3-IC-NO                                         
                  ,:S-RS3-CNTRCT-START-DT                               
                  ,:S-RS3-PRTY-SVC-CAT-CD                               
                  ,:S-RS3-VOL-BLOCK-FACTOR                              
                  ,:S-RS3-CONTRACT-DEMAND                               
                  ,:S-RS3-ALTERNATE-FUEL-CD                             
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R3                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,PRIMARY_IC_NO                                              
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,CNTRCT_START_DT                                            
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,VOL_BLOCK_FACTOR                                           
MFA-TR*             ,CONTRACT_DEMAND                                            
MFA-TR*             ,ALTERNATE_FUEL_CD                                          
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-RS3-PRIMARY-IC-NO                                         
MFA-TR*           ,:S-RS3-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS3-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS3-IC-NO                                                 
MFA-TR*           ,:S-RS3-CNTRCT-START-DT                                       
MFA-TR*           ,:S-RS3-PRTY-SVC-CAT-CD                                       
MFA-TR*           ,:S-RS3-VOL-BLOCK-FACTOR                                      
MFA-TR*           ,:S-RS3-CONTRACT-DEMAND                                       
MFA-TR*           ,:S-RS3-ALTERNATE-FUEL-CD                                     
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8040-INSERT-GTT-R4.                                            *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R4                           
                 (                                                      
                     RETURN_CODE                                        
                    ,PRIMARY_IC_NO                                      
                    ,PRIMARY_RATE_PLAN_NO                               
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CNTRCT_START_DT                                    
                    ,TRNSP_SHRINK_PCT                                   
                    ,FUEL_SHIPPER_CD                                    
                    ,TRNSP_MDQ                                          
                    ,PRTY_SVC_CAT_CD                                    
                    ,TRANSP_RATE_PLAN_NO                                
                    ,CODE_REVENUE_CLASS                                 
                    ,CONTRACT_DEMAND                                    
                    ,FACTOR                                             
                    ,TRANSM_ACCOUNT_NO                                  
                    ,MAX_CNTRCT_START_DT                                
                    ,MAX_CNTRCT_END_DT                                  
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-RS4-PRIMARY-IC-NO                                 
                  ,:S-RS4-PRIMARY-RATE-PLAN-NO                          
                  ,:S-RS4-CODE-UTIL-TYPE                                
                  ,:S-RS4-IC-NO                                         
                  ,:S-RS4-CNTRCT-START-DT                               
                  ,:S-RS4-TRNSP-SHRINK-PCT                              
                  ,:S-RS4-FUEL-SHIPPER-CD                               
                  ,:S-RS4-TRNSP-MDQ                                     
                  ,:S-RS4-PRTY-SVC-CAT-CD                               
                  ,:S-RS4-TRANSP-RATE-PLAN-NO                           
                  ,:S-RS4-CODE-REVENUE-CLASS                            
                  ,:S-RS4-CONTRACT-DEMAND                               
                  ,:S-RS4-FACTOR                                        
                  ,:S-RS4-TRANSM-ACCOUNT-NO                             
                  ,:S-RS4-MAX-CNTRCT-START-DT                           
                  ,:S-RS4-MAX-CNTRCT-END-DT                             
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R4                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,PRIMARY_IC_NO                                              
MFA-TR*             ,PRIMARY_RATE_PLAN_NO                                       
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,CNTRCT_START_DT                                            
MFA-TR*             ,TRNSP_SHRINK_PCT                                           
MFA-TR*             ,FUEL_SHIPPER_CD                                            
MFA-TR*             ,TRNSP_MDQ                                                  
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,TRANSP_RATE_PLAN_NO                                        
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,CONTRACT_DEMAND                                            
MFA-TR*             ,FACTOR                                                     
MFA-TR*             ,TRANSM_ACCOUNT_NO                                          
MFA-TR*             ,MAX_CNTRCT_START_DT                                        
MFA-TR*             ,MAX_CNTRCT_END_DT                                          
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-4                                             
MFA-TR*           ,:S-RS4-PRIMARY-IC-NO                                         
MFA-TR*           ,:S-RS4-PRIMARY-RATE-PLAN-NO                                  
MFA-TR*           ,:S-RS4-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS4-IC-NO                                                 
MFA-TR*           ,:S-RS4-CNTRCT-START-DT                                       
MFA-TR*           ,:S-RS4-TRNSP-SHRINK-PCT                                      
MFA-TR*           ,:S-RS4-FUEL-SHIPPER-CD                                       
MFA-TR*           ,:S-RS4-TRNSP-MDQ                                             
MFA-TR*           ,:S-RS4-PRTY-SVC-CAT-CD                                       
MFA-TR*           ,:S-RS4-TRANSP-RATE-PLAN-NO                                   
MFA-TR*           ,:S-RS4-CODE-REVENUE-CLASS                                    
MFA-TR*           ,:S-RS4-CONTRACT-DEMAND                                       
MFA-TR*           ,:S-RS4-FACTOR                                                
MFA-TR*           ,:S-RS4-TRANSM-ACCOUNT-NO                                     
MFA-TR*           ,:S-RS4-MAX-CNTRCT-START-DT                                   
MFA-TR*           ,:S-RS4-MAX-CNTRCT-END-DT                                     
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R4 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS4               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R4            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8040-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8050-INSERT-GTT-R5.                                            *        
      ******************************************************************        
       8050-INSERT-GTT-R5.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R5                           
                 (                                                      
                     RETURN_CODE                                        
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CNTRCT_START_DT                                    
                    ,CMPNT_ID_CD                                        
                    ,INSTR_USE_TYPE_CD                                  
                    ,CODE_TIME_PERIOD                                   
                    ,BASELINE_MONTH                                     
                    ,BASELINE_UNITS                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-5                                     
                  ,:S-RS5-CODE-UTIL-TYPE                                
                  ,:S-RS5-IC-NO                                         
                  ,:S-RS5-CNTRCT-START-DT                               
                  ,:S-RS5-CMPNT-ID-CD                                   
                  ,:S-RS5-INSTR-USE-TYPE-CD                             
                  ,:S-RS5-CODE-TIME-PERIOD                              
                  ,:S-RS5-BASELINE-MONTH                                
                  ,:S-RS5-BASELINE-UNITS                                
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R5                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,CNTRCT_START_DT                                            
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,INSTR_USE_TYPE_CD                                          
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,BASELINE_MONTH                                             
MFA-TR*             ,BASELINE_UNITS                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-5                                             
MFA-TR*           ,:S-RS5-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS5-IC-NO                                                 
MFA-TR*           ,:S-RS5-CNTRCT-START-DT                                       
MFA-TR*           ,:S-RS5-CMPNT-ID-CD                                           
MFA-TR*           ,:S-RS5-INSTR-USE-TYPE-CD                                     
MFA-TR*           ,:S-RS5-CODE-TIME-PERIOD                                      
MFA-TR*           ,:S-RS5-BASELINE-MONTH                                        
MFA-TR*           ,:S-RS5-BASELINE-UNITS                                        
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R5 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS5               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R5            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R5'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8050-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 8060-INSERT-GTT-R6.                                            *        
      ******************************************************************        
       8060-INSERT-GTT-R6.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R6                           
                 (                                                      
                     RETURN_CODE                                        
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,TYP_INTRPT_DEMAND                                  
                    ,CATEGORY                                           
                    ,CONTRACT_DATE                                      
                    ,FIRM_DEMAND_LEVEL                                  
                    ,CURTAILMENT_IND                                    
                    ,USER_ID_ACCT_MGR                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-6                                     
                  ,:S-RS6-CODE-UTIL-TYPE                                
                  ,:S-RS6-IC-NO                                         
                  ,:S-RS6-TYP-INTRPT-DEMAND                             
                  ,:S-RS6-CATEGORY                                      
                  ,:S-RS6-CONTRACT-DATE                                 
                  ,:S-RS6-FIRM-DEMAND-LEVEL                             
                  ,:S-RS6-CURTAILMENT-IND                               
                  ,:S-RS6-USER-ID-ACCT-MGR                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R6                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,TYP_INTRPT_DEMAND                                          
MFA-TR*             ,CATEGORY                                                   
MFA-TR*             ,CONTRACT_DATE                                              
MFA-TR*             ,FIRM_DEMAND_LEVEL                                          
MFA-TR*             ,CURTAILMENT_IND                                            
MFA-TR*             ,USER_ID_ACCT_MGR                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-6                                             
MFA-TR*           ,:S-RS6-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS6-IC-NO                                                 
MFA-TR*           ,:S-RS6-TYP-INTRPT-DEMAND                                     
MFA-TR*           ,:S-RS6-CATEGORY                                              
MFA-TR*           ,:S-RS6-CONTRACT-DATE                                         
MFA-TR*           ,:S-RS6-FIRM-DEMAND-LEVEL                                     
MFA-TR*           ,:S-RS6-CURTAILMENT-IND                                       
MFA-TR*           ,:S-RS6-USER-ID-ACCT-MGR                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R6 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS6               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8060'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R6            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R6'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8060-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 8070-INSERT-GTT-R7.                                            *        
      ******************************************************************        
       8070-INSERT-GTT-R7.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R7                           
                 (                                                      
                     RETURN_CODE                                        
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,NON_COMPLIANCE_IND                                 
                    ,INTERRUPT_DATE                                     
                    ,INTERRUPT_TIME_OFF                                 
                    ,INTERRUPT_TIME_ON                                  
                    ,TOTAL_HOURS                                        
                    ,EXCEPTION_CD                                       
                    ,POWER_COST                                         
                    ,INTERRUPT_REASON                                   
                    ,INTERRUPT_END                                      
                    ,NOTIFY_DATE                                        
                    ,NOTIFY_TIME                                        
                    ,NOTIFY_NAME                                        
                    ,NOTIFY_POSITION                                    
                    ,USER_ID_NOTIFY_BY                                  
                    ,TYP_INTRPT_DEMAND                                  
                    ,RESP_CUSTOMER                                      
                    ,REMARKS                                            
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-7                                     
                  ,:S-RS7-CODE-UTIL-TYPE                                
                  ,:S-RS7-IC-NO                                         
                  ,:S-RS7-NON-COMPLIANCE-IND                            
                  ,:S-RS7-INTERRUPT-DT                                  
                  ,:S-RS7-INTERRUPT-TIME-OFF                            
                  ,:S-RS7-INTERRUPT-TIME-ON                             
                  ,:S-RS7-TOTAL-HOURS                                   
                  ,:S-RS7-EXCEPTION-CD                                  
                  ,:S-RS7-POWER-COST                                    
                  ,:S-RS7-INTERRUPT-REASON                              
                  ,:S-RS7-INTERRUPT-END                                 
                  ,:S-RS7-NOTIFY-DATE                                   
                  ,:S-RS7-NOTIFY-TIME                                   
                  ,:S-RS7-NOTIFY-NAME                                   
                  ,:S-RS7-NOTIFY-POSITION                               
                  ,:S-RS7-USER-ID-NOTIFY-BY                             
                  ,:S-RS7-TYP-INTRPT-DEMAND                             
                  ,:S-RS7-RESP-CUSTOMER                                 
                  ,:S-RS7-REMARKS                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R7                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,NON_COMPLIANCE_IND                                         
MFA-TR*             ,INTERRUPT_DATE                                             
MFA-TR*             ,INTERRUPT_TIME_OFF                                         
MFA-TR*             ,INTERRUPT_TIME_ON                                          
MFA-TR*             ,TOTAL_HOURS                                                
MFA-TR*             ,EXCEPTION_CD                                               
MFA-TR*             ,POWER_COST                                                 
MFA-TR*             ,INTERRUPT_REASON                                           
MFA-TR*             ,INTERRUPT_END                                              
MFA-TR*             ,NOTIFY_DATE                                                
MFA-TR*             ,NOTIFY_TIME                                                
MFA-TR*             ,NOTIFY_NAME                                                
MFA-TR*             ,NOTIFY_POSITION                                            
MFA-TR*             ,USER_ID_NOTIFY_BY                                          
MFA-TR*             ,TYP_INTRPT_DEMAND                                          
MFA-TR*             ,RESP_CUSTOMER                                              
MFA-TR*             ,REMARKS                                                    
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-7                                             
MFA-TR*           ,:S-RS7-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS7-IC-NO                                                 
MFA-TR*           ,:S-RS7-NON-COMPLIANCE-IND                                    
MFA-TR*           ,:S-RS7-INTERRUPT-DT                                          
MFA-TR*           ,:S-RS7-INTERRUPT-TIME-OFF                                    
MFA-TR*           ,:S-RS7-INTERRUPT-TIME-ON                                     
MFA-TR*           ,:S-RS7-TOTAL-HOURS                                           
MFA-TR*           ,:S-RS7-EXCEPTION-CD                                          
MFA-TR*           ,:S-RS7-POWER-COST                                            
MFA-TR*           ,:S-RS7-INTERRUPT-REASON                                      
MFA-TR*           ,:S-RS7-INTERRUPT-END                                         
MFA-TR*           ,:S-RS7-NOTIFY-DATE                                           
MFA-TR*           ,:S-RS7-NOTIFY-TIME                                           
MFA-TR*           ,:S-RS7-NOTIFY-NAME                                           
MFA-TR*           ,:S-RS7-NOTIFY-POSITION                                       
MFA-TR*           ,:S-RS7-USER-ID-NOTIFY-BY                                     
MFA-TR*           ,:S-RS7-TYP-INTRPT-DEMAND                                     
MFA-TR*           ,:S-RS7-RESP-CUSTOMER                                         
MFA-TR*           ,:S-RS7-REMARKS                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-7.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R7 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS7               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8070'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R7            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R7'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8070-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 8080-INSERT-GTT-R8.                                            *        
      ******************************************************************        
       8080-INSERT-GTT-R8.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04745_R8                           
                 (                                                      
                   RETURN_CODE                                          
                  ,CODE_UTIL_TYPE                                       
                  ,IC_NO                                                
                  ,CNTRCT_START_DT                                      
                  ,ALTN_FUEL_SPLY_CD                                    
                  ,ALT_SPLY_RATE_NO                                     
                  ,ALT_SPLY_REV_CL_CD                                   
                  ,FUEL_SHIPPER_CD                                      
                  ,ALTERNATE_FUEL_CD                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-8                                     
                  ,:S-RS8-CODE-UTIL-TYPE                                
                  ,:S-RS8-IC-NO                                         
                  ,:S-RS8-CNTRCT-START-DT                               
                  ,:S-RS8-ALTN-FUEL-SPLY-CD                             
                  ,:S-RS8-ALT-SPLY-RATE-NO                              
                  ,:S-RS8-ALT-SPLY-REV-CL-CD                            
                  ,:S-RS8-FUEL-SHIPPER-CD                               
                  ,:S-RS8-ALTERNATE-FUEL-CD                             
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04745_R8                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,CNTRCT_START_DT                                              
MFA-TR*           ,ALTN_FUEL_SPLY_CD                                            
MFA-TR*           ,ALT_SPLY_RATE_NO                                             
MFA-TR*           ,ALT_SPLY_REV_CL_CD                                           
MFA-TR*           ,FUEL_SHIPPER_CD                                              
MFA-TR*           ,ALTERNATE_FUEL_CD                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-8                                             
MFA-TR*           ,:S-RS8-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS8-IC-NO                                                 
MFA-TR*           ,:S-RS8-CNTRCT-START-DT                                       
MFA-TR*           ,:S-RS8-ALTN-FUEL-SPLY-CD                                     
MFA-TR*           ,:S-RS8-ALT-SPLY-RATE-NO                                      
MFA-TR*           ,:S-RS8-ALT-SPLY-REV-CL-CD                                    
MFA-TR*           ,:S-RS8-FUEL-SHIPPER-CD                                       
MFA-TR*           ,:S-RS8-ALTERNATE-FUEL-CD                                     
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-8.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS8               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8080'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R8            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04745_R8'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8080-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   100                     TO S-RETURN-CODE-1         
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   100                     TO S-RETURN-CODE-2         
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
                                                                        
           EVALUATE WS-CUSTOMER-TYPE                                    
               WHEN 'CIG'                                               
                    IF CTR-ROWS-RS3 <= 0                                
                       INITIALIZE GTT-RETURN-FIELDS-3                   
                       MOVE 100                    TO S-RETURN-CODE-3   
                       PERFORM 8030-INSERT-GTT-R3  THRU 8030-EXIT       
                    END-IF                                              
                    IF CTR-ROWS-RS4 <= 0                                
                       INITIALIZE GTT-RETURN-FIELDS-4                   
                       MOVE 100                    TO S-RETURN-CODE-4   
                       PERFORM 8040-INSERT-GTT-R4  THRU 8040-EXIT       
                    END-IF                                              
               WHEN 'SCEG'                                              
                    IF CTR-ROWS-RS5 <= 0                                
                       INITIALIZE GTT-RETURN-FIELDS-5                   
                       MOVE 100                    TO S-RETURN-CODE-5   
                       PERFORM 8050-INSERT-GTT-R5  THRU 8050-EXIT       
                    END-IF                                              
                    IF CTR-ROWS-RS6 <= 0                                
                       INITIALIZE GTT-RETURN-FIELDS-6                   
                       MOVE 100                    TO S-RETURN-CODE-6   
                       PERFORM 8060-INSERT-GTT-R6  THRU 8060-EXIT       
                    END-IF                                              
                    IF CTR-ROWS-RS7 <= 0                                
                       INITIALIZE GTT-RETURN-FIELDS-7                   
                       MOVE 100                    TO S-RETURN-CODE-7   
                       PERFORM 8070-INSERT-GTT-R7  THRU 8070-EXIT       
                    END-IF                                              
               WHEN 'PSNC'                                              
                    IF CTR-ROWS-RS8 <= 0                                
                       INITIALIZE GTT-RETURN-FIELDS-8                   
                       MOVE 100                    TO S-RETURN-CODE-8   
                       PERFORM 8080-INSERT-GTT-R8  THRU 8080-EXIT       
                    END-IF                                              
           END-EVALUATE.                                                
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EVALUATE WS-CUSTOMER-TYPE                                    
               WHEN 'CIG '                                              
                    PERFORM 8910-SEND-DONE THRU 8910-EXIT               
               WHEN 'SCEG'                                              
                    PERFORM 8920-SEND-DONE THRU 8920-EXIT               
               WHEN 'PSNC'                                              
                    PERFORM 8930-SEND-DONE THRU 8930-EXIT               
           END-EVALUATE.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8910-SEND-DONE.                                                *        
      ******************************************************************        
       8910-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8910'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8910-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      *                                                                *        
      * 8920-SEND-DONE.                                                *        
      ******************************************************************        
       8920-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8920'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R5'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C6                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R6'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C7                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-7.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R7'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8920-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8930-SEND-DONE.                                                *        
      ******************************************************************        
       8930-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8930'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C8                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C8 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-8.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04745_R8'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8930-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
                                               S-RETURN-CODE-4          
                                               S-RETURN-CODE-5          
                                               S-RETURN-CODE-6          
                                               S-RETURN-CODE-7          
                                               S-RETURN-CODE-8.         
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
           EVALUATE WS-CUSTOMER-TYPE                                    
               WHEN 'CIG '                                              
                    PERFORM 0100C-DECLARE-GTT-R3 THRU 0100C-EXIT        
                    PERFORM 8030-INSERT-GTT-R3   THRU 8030-EXIT         
                    PERFORM 0100D-DECLARE-GTT-R4 THRU 0100D-EXIT        
                    PERFORM 8040-INSERT-GTT-R4   THRU 8040-EXIT         
               WHEN 'SCEG'                                              
                    PERFORM 0100E-DECLARE-GTT-R5 THRU 0100E-EXIT        
                    PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT         
                    PERFORM 0100F-DECLARE-GTT-R6 THRU 0100F-EXIT        
                    PERFORM 8060-INSERT-GTT-R6   THRU 8060-EXIT         
                    PERFORM 0100G-DECLARE-GTT-R7 THRU 0100G-EXIT        
                    PERFORM 8070-INSERT-GTT-R7   THRU 8070-EXIT         
               WHEN OTHER                                               
                    PERFORM 0100H-DECLARE-GTT-R8 THRU 0100H-EXIT        
                    PERFORM 8080-INSERT-GTT-R8   THRU 8080-EXIT         
           END-EVALUATE.                                                
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
