       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04744.                                      
COB303 DATE-WRITTEN.     JANUARY 17, 2014.                              
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04744              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04744 :                                                --         
      *--                                                            --         
      *--  RETRIEVE THE SERVICE ORDER DATA FROM SO TABLE BASED ON    --         
      *--  PREMISE NUMBER AND HISTORY CODE TO DISPLAY THE ORDER      --         
      *--  DETAILS IN ORDER LANDING PAGE.                            --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             I-PREMISE-NO          CHAR(10)                 --         
      *--             I-HISTORY-CODE        CHAR(01)                 --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--  CSR04744_R1 - PENDING & COMPLETED                         --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,ACCOUNT_NO              CHAR(13)                 --         
      *--          ,SERV_ORDER_NO           DECIMAL(13,0)            --         
      *--          ,FULL_NAME               CHAR(70)                 --         
      *--          ,CODE_UTIL_TYPE          CHAR(1)                  --         
      *--          ,ORDER_TYPE_CODE         CHAR(5)                  --         
      *--          ,WORK_TYPE_CODE          CHAR(3)                  --         
      *--          ,ASSIGNED_DATETIME       CHAR(26)                 --         
      *--          ,SERVICE_ORDER_STATUS    CHAR(2)                  --         
      *--          ,ORDER_STATE_CODE        CHAR(1)                  --         
      *--          ,COMPLETED_DATETIME      CHAR(26)                 --         
      *--          ,WORK_CLASS_ID           CHAR(4)                  --         
      *--          ,BACK_DATED_IND          CHAR(1)                  --         
      *--          ,SOURCE_SYSTEM_CD        CHAR(3)                  --         
      *--          ,ORDER_KEY               CHAR(14)                 --         
P0795D*--          ,CODE_RENTAL_PROP        CHAR(1)                  --         
P0795E*--          ,ORDER_REASON            CHAR(2)                  --         
D10004*--          ,IS_CLICK_ORDER          CHAR(1)                  --         
D10004*--          ,TASK_STATUS_CD          CHAR(1)                  --         
      *--                                                            --         
      *--  CSR04744_R2 - DETAILS & MORE DETAILS SCREEN               --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,ACCOUNT_NO              CHAR(13)                 --         
      *--          ,SERV_ORDER_NO           DECIMAL(13,0)            --         
      *--          ,CODE_UTIL_TYPE          CHAR(1)                  --         
      *--          ,ORDER_RECEIVED_BY       CHAR(7)                  --         
      *--          ,ORDER_REC_BY_NAME       CHAR(28)                 --         
      *--          ,INITIATED_ON            CHAR(26)                 --         
      *--          ,LAST_UPDATED_BY         CHAR(07)                 --         
      *--          ,LAST_UPDATE_BY_NAME     CHAR(28)                 --         
      *--          ,LAST_UPDATED_ON         CHAR(26)                 --         
      *--          ,WORK_AREA_ID            CHAR(12)                 --         
      *--          ,ACCOUNT_NO_PRIOR        CHAR(13)                 --         
      *--          ,SERVICE_CHARGE          DECIMAL (9,2)            --         
      *--                                                            --         
      *--  CSR04744_R3 -  LAST READING DETAILS                       --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,ACCOUNT_NO              CHAR(13)                 --         
      *--          ,SERV_ORDER_NO           DECIMAL(13,0)            --         
      *--          ,CODE_UTIL_TYPE          CHAR(01)                 --         
      *--          ,RELEASE_STATUS          CHAR(01)                 --         
      *--          ,RELEASE_NO              CHAR(10)                 --         
      *--          ,RELEASE_DATE            CHAR(10)                 --         
      *--          ,METER_NO                CHAR(09)                 --         
      *--          ,CODE_METER_STATUS       CHAR(01)                 --         
      *--          ,LAST_READ_VALUE         DECIMAL(15,3)            --         
      *--          ,LAST_REG_READ_DATE      CHAR(26)                 --         
      *--          ,METER_SUPPLYING         CHAR(15)                 --         
      *--          ,IC_NO                   CHAR(01)                 --         
      *--          ,MTR_REF_NO              CHAR(01)                 --         
      *--          ,NO_DIALS                INTEGER                  --         
      *--                                                            --         
      *--  CSR04744_R4 -  SO REMARKS DETAILS                         --         
      *--                                                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,SERV_ORDER_NO           DECIMAL(13,0)            --         
      *--          ,REMARK_TYPE_CODE        CHAR(01)                 --         
      *--          ,REMARK_TX               CHAR(210)                --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00795*--  01/17/2014    MC95456     RETRIEVE PENDING & COMPLETED,   --         
      *--                            LAST READING DETAILS.           --         
P00795*--  08/07/2014    DB18339     ADDED SUSPEND REMARKS ('P').    --         
P00795*--  01/20/2015    DB18339     ADDED CHECK FOR HST_SO_UPDATE.  --         
P0795A*--  02/17/2015    PK44514     DEFECT 6882: FIX FOR -180 ERROR --         
      *--                             ON MOW ORDERS                  --         
P0795A*--  03/02/2015    DB18339     DEFECT 6882: FIX FOR -180 ERROR --         
      *--                             ON MOW ORDERS                  --         
P0795B*--  05/20/2015    DB18339     DEFECT 6824: ADD SOURCE SYS CD  --         
P0795C*--  06/04/2015    DB18339     DEFECT 7075: ADD ORDER KEY      --         
P0795D*--  08/10/2015    DB18339     DEFECT 8410: ADD CODE RENTAL PROP-         
P0795D*--  08/10/2015                TO SEE REVERT LANDLORD CODE      -         
P0795E*--  10/27/2015    DB18339     DEFECT 9483: ADD ORDER REASON.             
D10004*--  04/13/2016    PK44514     DEFECT 10004:send back if click --         
D10004*--                            order code                      --         
DT9519*--  08/15/2016    pk44514     DEFECT 9519:SEB DNP cancel:make --         
DT9519*--                            order reason 2 chars long       --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04744'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                         PIC X(40) VALUE              
            'WORKING STORAGE FOR CSR04744 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                PIC X(08) VALUE 'CSRERLOG'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'CSR04744'.  
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS2                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS3                PIC S9(9) COMP VALUE 0.      
           05  CTR-ROWS-RS4                PIC S9(9) COMP VALUE 0.      
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                 PIC X(05)  VALUE SPACES.     
           05  WS-GTT-NAME                 PIC X(19)  VALUE SPACES.     
           05  WS-PREV-SERV-ORDER-NO       PIC S9(13)V COMP-3 VALUE 0.  
           05  WS-PREMISE-NO               PIC X(10)  VALUE SPACES.     
           05  WS-HISTORY-CODE             PIC X(01)  VALUE SPACES.     
           05  WS-HIST                     PIC X(01)  VALUE 'H'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-SPACE-CNT                PIC S9(04) COMP VALUE +0.    
           05  WS-LENGTH                   PIC S9(04) COMP VALUE +0.    
           05  WS-USER-NAME                PIC X(28) VALUE SPACES.      
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-RLSE-DT-NULL             PIC S9(04) COMP.             
           05  WS-ASSIGN-DT-NULL           PIC S9(04) COMP.             
           05  WS-COMPLETE-DT-NULL         PIC S9(04) COMP.             
           05  WS-RECVED-DT-NULL           PIC S9(04) COMP.             
           05  WS-DATE-LAST-NULL           PIC S9(04) COMP.             
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-SO-ROWS           PIC X(01) VALUE 'N'.         
              88 NO-MORE-SO-ROWS                     VALUE 'Y'.         
                                                                        
           05 WS-NO-MORE-INST-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-INST-ROWS                   VALUE 'Y'.         
                                                                        
           05 WS-NO-MORE-HST-ROWS          PIC X(01) VALUE 'N'.         
              88 NO-MORE-HST-ROWS                    VALUE 'Y'.         
                                                                        
           05 WS-NO-MORE-RMRK-ROWS         PIC X(01) VALUE 'N'.         
              88 NO-MORE-RMRK-ROWS                   VALUE 'Y'.         
                                                                        
                                                                        
                                                                        
       01  WS-ERR-CODES.                                                
           05  WS-ERR-INSRT-R1             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R2             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R3             PIC X(01) VALUE 'N'.         
           05  WS-ERR-INSRT-R4             PIC X(01) VALUE 'N'.         
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                   PIC X(18) VALUE SPACES.      
           10  S-SQLCODE                   PIC S9(9) COMP VALUE 0.      
           10  S-SQLSTATE                  PIC X(05) VALUE ' '.         
           10  S-TABLE-NAME                PIC X(18) VALUE SPACES.      
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L      PIC S9(4) USAGE COMP.        
               49  S-HOST-VARIABLES-V      PIC X(255).                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L       PIC S9(4) USAGE COMP.        
               49  S-SQL-STATEMENT-V       PIC X(255).                  
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L     PIC S9(4) USAGE COMP.        
               49  S-SQL-DESCRIPTION-V     PIC X(255).                  
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L     PIC S9(4) USAGE COMP.        
               49  WS-ABEND-SQLERRMC-V     PIC X(255).                  
                                                                        
d10004******************************************************************        
d10004* CSR04747 - CHECK IF CLICK AND GET WORK DISTRICT                *        
d10004******************************************************************        
                                                                        
       01  CSR04747-CALL-DATA.                                          
           03  SERV-ORDER-NO-4747       PIC X(13) VALUE SPACES.         
           03  PRIORITY-4747            PIC X(01) VALUE SPACES.         
           03  ACTION-CD-4747           PIC X(01) VALUE SPACES.         
           03  USER-ID-4747             PIC X(07) VALUE SPACES.         
           03  WORK-DISTRICT-IN-4747    PIC X(40) VALUE SPACES.         
                                                                        
       01  CSR04747-RETURN-DATA.                                        
           05  RETURN-CODE-4747          PIC S9(9) COMP VALUE 0.        
           05  WORK-DISTRICT-OUT-4747    PIC X(40) VALUE SPACES.        
                                                                        
d10004*01 LOC4747 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR PENDING & COMPLETED            *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1            PIC S9(04) COMP VALUE 0.     
             10 S-RS1-ACCOUNT-NO           PIC X(13)  VALUE SPACES.     
             10 S-RS1-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.  
             10 S-RS1-FULL-NAME            PIC X(70)  VALUE SPACES.     
             10 S-RS1-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS1-ORDER-TYPE-CODE      PIC X(05)  VALUE SPACES.     
             10 S-RS1-WORK-TYPE-CODE       PIC X(03)  VALUE SPACES.     
             10 S-RS1-ASSIGNED-DATETIME    PIC X(26)  VALUE SPACES.     
             10 S-RS1-SERV-ORDER-STATUS    PIC X(02)  VALUE SPACES.     
             10 S-RS1-ORDER-STATE-CODE     PIC X(01)  VALUE SPACES.     
             10 S-RS1-COMPLETED-DATETIME   PIC X(26)  VALUE SPACES.     
             10 S-RS1-WORK-CLASS-ID        PIC X(04)  VALUE SPACES.     
             10 S-RS1-BACK-DATED-IND       PIC X(01)  VALUE SPACES.     
P0795B       10 S-RS1-SOURCE-SYSTEM-CD     PIC X(03)  VALUE SPACES.     
P0795C       10 S-RS1-ORDER-KEY            PIC X(14)  VALUE SPACES.     
P0795D       10 S-RS1-CODE-RENTAL-PROP     PIC X(01)  VALUE SPACES.     
P0795E       10 S-RS1-ORDER-REASON         PIC X(02)  VALUE SPACES.     
D10004       10 S-RS1-IS-CLICK-ORDER       PIC X(01)  VALUE SPACES.     
D10004       10 S-RS1-TASK-STATUS-CODE     PIC X(01)  VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR DETAILS & MORE DETAILS SCREEN  *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2            PIC S9(04) COMP VALUE 0.     
             10 S-RS2-ACCOUNT-NO           PIC X(13)  VALUE SPACES.     
             10 S-RS2-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.  
             10 S-RS2-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.     
             10 S-RS2-ORDER-RECVED-BY      PIC x(07)  VALUE SPACES.     
             10 S-RS2-ORDER-REC-BY-NAME    PIC x(28)  VALUE SPACES.     
             10 S-RS2-DATE-RECVED          PIC X(26)  VALUE SPACES.     
             10 S-RS2-USER-ID-UPDT-BY      PIC X(07)  VALUE SPACES.     
             10 S-RS2-UPDATE-BY-NAME       PIC X(28)  VALUE SPACES.     
             10 S-RS2-UPDATE-DATETIME      PIC X(26)  VALUE SPACES.     
             10 S-RS2-WORK-AREA-ID         PIC X(12)  VALUE SPACES.     
             10 S-RS2-ACCOUNT-NO-PRIOR     PIC X(13)  VALUE SPACES.     
             10 S-RS2-STD-LABOR-CHRG       PIC S9(07)V9(2)              
                                                       COMP-3 VALUE 0.  
             10 S-RS2-RESP-AREA-INIT-BY    PIC X(03)  VALUE SPACES.     
             10 S-RS2-RESP-AREA-UPDT-BY    PIC X(03)  VALUE SPACES.     
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR UNMETER CSS_CUST_PLAN          *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3            PIC S9(04) COMP VALUE 0.     
             10 S-RS3-ACCOUNT-NO           PIC X(13) VALUE SPACES.      
             10 S-RS3-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.  
             10 S-RS3-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.      
             10 S-RS3-HOLD-RELEASE         PIC X(01) VALUE SPACES.      
             10 S-RS3-RLSE-NO              PIC X(10) VALUE SPACES.      
             10 S-RS3-RLSE-DATE            PIC X(26) VALUE SPACES.      
             10 S-RS3-METER-NO             PIC X(09) VALUE SPACES.      
             10 S-RS3-CODE-MTR-STATUS      PIC X(01) VALUE SPACES.      
COB305       10 S-RS3-LAST-READ-VALUE        PIC S9(12)V9(3) 
COB305          USAGE COMP-3 VALUE 0.
             10 S-RS3-LAST-REG-READ-DATE   PIC X(26) VALUE SPACES.      
             10 S-RS3-METER-SUPPLYING      PIC X(15) VALUE SPACES.      
             10 S-RS3-IC-NO                PIC S9(4) USAGE COMP VALUE 0.
             10 S-RS3-MTR-REF-NO           PIC S9(4) USAGE COMP VALUE 0.
             10 S-RS3-NO-DIALS             PIC S9(4) USAGE COMP VALUE 0.
                                                                        
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4            PIC S9(04) COMP VALUE 0.     
             10 S-RS4-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.  
             10 S-RS4-REMARK-TYPE-CD       PIC X(01)  VALUE SPACES.     
             10 S-RS4-REMARK-TX            PIC X(210).                  
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_CHARGES     CH                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOCHR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ORDER_TYPE     C2                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME           DQ                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_REMARKS     EF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME_ACCT_XREF HT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_WORK_TYPE L4                                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_SO_REMARKS     OE                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTREM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_USER_PROFILE   PF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_WK_CLASS_STAT  R6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWKCST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_MTR_CHG     VC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOMCG                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_ORDER_INST  VI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_METER       VM                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOMTR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_DATA        VO                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_SO_METER       VR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTMTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_SO_MTR_CHG     VS                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTMCG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_UPDATE      VW                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_SO_DATA YV                                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_SO_ORDER_INST  ZG                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTODR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PREMISE PR                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH CURRENT DATA FOR SO DATA BASED   *        
      *   ON THE PREMISE NO AND HISTORY CODE.                         *         
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE SO_DATA_CSR  CURSOR FOR                          
                SELECT VO.ACCOUNT_NO                                    
                      ,VO.SERV_ORDER_NO                                 
                      ,VO.ORDER_TYPE_CD                                 
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME                             
                      ,VO.SERV_ORDER_STATUS                             
                      ,VO.ORDER_STATE_CD                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                            
                      ,VO.ORDER_RECVED_BY                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), VO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED                            
                      ,VO.WORK_AREA_ID                                  
                      ,VO.ACCOUNT_NO_PRIOR                              
                      ,VO.RESP_AREA_ID                                  
                      ,VO.BACK_DATED_IND                                
P0795B                ,VO.SOURCE_SYSTEM_CD                              
P0795C                ,VO.ORDER_KEY                                     
P0795E                ,VO.ORDER_REASON                                  
                      ,VI.CODE_UTIL_TYPE                                
                      ,VI.WORK_TYPE_CD                                  
D10004                ,VI.TASK_STATUS_CD                                
                      ,R6.WORK_CLASS_ID                                 
                  FROM CSS_SO_DATA        VO WITH(READUNCOMMITTED)              
                      ,CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)              
                      ,CSS_ORDER_TYPE     OT WITH(READUNCOMMITTED)              
                      ,CSS_WORK_TYPE      WK WITH(READUNCOMMITTED)              
                      ,CSS_WK_CLASS_STAT  R6 WITH(READUNCOMMITTED)              
                 WHERE VO.PREMISE_NO         = :VO-PREMISE-NO           
                   AND VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO         
                   AND VO.ORDER_TYPE_CD      = OT.ORDER_TYPE_CD         
                   AND VI.WORK_TYPE_CD       = WK.WORK_TYPE_CD          
                   AND VO.COMPANY_NO         = OT.COMPANY_NO            
                   AND OT.COMPANY_NO         = WK.COMPANY_NO            
                   AND OT.WORK_CLASS_ID      = R6.WORK_CLASS_ID         
                   AND VO.SERV_ORDER_STATUS  = R6.SERV_ORDER_STATUS     
                   AND VI.WORK_TYPE_CD > ' '                            
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_DATA_CSR  CURSOR FOR                                  
MFA-TR*         SELECT VO.ACCOUNT_NO                                            
MFA-TR*               ,VO.SERV_ORDER_NO                                         
MFA-TR*               ,VO.ORDER_TYPE_CD                                         
MFA-TR*               ,VO.ASSIGNED_DATETIME                                     
MFA-TR*               ,VO.SERV_ORDER_STATUS                                     
MFA-TR*               ,VO.ORDER_STATE_CD                                        
MFA-TR*               ,VO.COMPLETED_DATETIME                                    
MFA-TR*               ,VO.ORDER_RECVED_BY                                       
MFA-TR*               ,VO.DATE_RECVED                                           
MFA-TR*               ,VO.WORK_AREA_ID                                          
MFA-TR*               ,VO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,VO.RESP_AREA_ID                                          
MFA-TR*               ,VO.BACK_DATED_IND                                        
MFA-TR*               ,VO.SOURCE_SYSTEM_CD                                      
MFA-TR*               ,VO.ORDER_KEY                                             
MFA-TR*               ,VO.ORDER_REASON                                          
MFA-TR*               ,VI.CODE_UTIL_TYPE                                        
MFA-TR*               ,VI.WORK_TYPE_CD                                          
MFA-TR*               ,VI.TASK_STATUS_CD                                        
MFA-TR*               ,R6.WORK_CLASS_ID                                         
MFA-TR*           FROM CSS_SO_DATA        VO                                    
MFA-TR*               ,CSS_SO_ORDER_INST  VI                                    
MFA-TR*               ,CSS_ORDER_TYPE     OT                                    
MFA-TR*               ,CSS_WORK_TYPE      WK                                    
MFA-TR*               ,CSS_WK_CLASS_STAT  R6                                    
MFA-TR*          WHERE VO.PREMISE_NO         = :VO-PREMISE-NO                   
MFA-TR*            AND VO.SERV_ORDER_NO      = VI.SERV_ORDER_NO                 
MFA-TR*            AND VO.ORDER_TYPE_CD      = OT.ORDER_TYPE_CD                 
MFA-TR*            AND VI.WORK_TYPE_CD       = WK.WORK_TYPE_CD                  
MFA-TR*            AND VO.COMPANY_NO         = OT.COMPANY_NO                    
MFA-TR*            AND OT.COMPANY_NO         = WK.COMPANY_NO                    
MFA-TR*            AND OT.WORK_CLASS_ID      = R6.WORK_CLASS_ID                 
MFA-TR*            AND VO.SERV_ORDER_STATUS  = R6.SERV_ORDER_STATUS             
MFA-TR*            AND VI.WORK_TYPE_CD > ' '                                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH CURRENT DATA  FOR SO DATA BASED  *        
      *   ON THE PREMISE NO AND HISTORY CODE.                         *         
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE SO_ORDER_INST_CSR CURSOR FOR                     
                SELECT VI.SERV_ORDER_NO                                 
                      ,' '                                              
                      ,' '                                              
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), CASE WHEN 
           VI.RLSE_DATE IS NULL                   
P0795A                      THEN CIS.CHAR2TIMESTAMP( '0001-01-01')              
P0795A                      ELSE VI.RLSE_DATE                           
P0795A                 END, 121), ' ', '-'), ':', '.')                          
                      ,VC.METER_NO                                      
                      ,VC.CODE_UTIL_TYPE                                
                      ,VC.IC_NO                                         
                      ,VC.MTR_REF_NO                                    
                      ,VC.CODE_MTR_STATUS_IS                            
                      ,VC.CODE_MTR_STATUS_WS                            
                      ,' '                                              
                      ,VC.LAST_READ_VALUE                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VC.LAST_REG_READ_DATE, 121), ' ', '-'), ':', '.') 
           LAST_REG_READ_DATE                            
                      ,' '                                              
                      ,VC.NO_DIALS                                      
                  FROM CSS_SO_MTR_CHG     VC WITH(READUNCOMMITTED)              
                      ,CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)              
                 WHERE VI.SERV_ORDER_NO      = :VI-SERV-ORDER-NO        
                   AND VI.SERV_ORDER_NO      = VC.SERV_ORDER_NO         
                   AND VI.METER_NO           = VC.METER_NO              
                   AND VI.IC_NO              = VC.IC_NO                 
                   AND VI.CODE_UTIL_TYPE     = VC.CODE_UTIL_TYPE        
                   AND VI.MTR_REF_NO         = VC.MTR_REF_NO            
                 UNION ALL                                              
                SELECT VI.SERV_ORDER_NO                                 
                      ,' '                                              
                      ,' '                                              
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), CASE WHEN 
           VI.RLSE_DATE IS NULL                   
P0795A                      THEN CIS.CHAR2TIMESTAMP( '0001-01-01')              
P0795A                      ELSE VI.RLSE_DATE                           
P0795A                 END, 121), ' ', '-'), ':', '.')                          
                      ,VM.METER_NO                                      
                      ,VM.CODE_UTIL_TYPE                                
                      ,VM.IC_NO                                         
                      ,VM.MTR_REF_NO                                    
                      ,' '                                              
                      ,' '                                              
                      ,VM.CODE_METER_STATUS                             
                      ,VM.LAST_READ_VALUE                               
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CHAR2TIMESTAMP('0001-01-01'), 121), ' ', '-'), ':', '.')        
                      ,' '                                              
                      ,VM.NO_DIALS                                      
                  FROM CSS_SO_METER       VM WITH(READUNCOMMITTED)              
                      ,CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)              
                 WHERE VI.SERV_ORDER_NO      = :VI-SERV-ORDER-NO        
                   AND VI.SERV_ORDER_NO      = VM.SERV_ORDER_NO         
                   AND VI.IC_NO              = VM.IC_NO                 
                   AND VI.CODE_UTIL_TYPE     = VM.CODE_UTIL_TYPE        
                   AND VI.MTR_REF_NO         = VM.MTR_REF_NO            
                   AND VM.METER_NO           > ' '                      
                 UNION ALL                                              
                SELECT VI.SERV_ORDER_NO                                 
                      ,VI.HOLD_RELEASE                                  
                      ,VI.RLSE_NO                                       
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), CASE WHEN 
           VI.RLSE_DATE IS NULL                   
P0795A                      THEN CIS.CHAR2TIMESTAMP( '0001-01-01')              
P0795A                      ELSE VI.RLSE_DATE                           
P0795A                 END, 121), ' ', '-'), ':', '.')                          
                      ,VI.METER_NO                                      
                      ,VI.CODE_UTIL_TYPE                                
                      ,VI.IC_NO                                         
                      ,VI.MTR_REF_NO                                    
                      ,' '                                              
                      ,' '                                              
                      ,' '                                              
                      ,0                                                
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CHAR2TIMESTAMP('0001-01-01'), 121), ' ', '-'), ':', '.')        
                      ,VI.METER_SUPPLYING                               
                      ,0                                                
                  FROM CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)              
                 WHERE VI.SERV_ORDER_NO = :VI-SERV-ORDER-NO             
                   AND (VI.HOLD_RELEASE = 'Y'                           
                    OR VI.RLSE_NO > ' ')                                
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_ORDER_INST_CSR CURSOR FOR                             
MFA-TR*         SELECT VI.SERV_ORDER_NO                                         
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,CASE WHEN VI.RLSE_DATE IS NULL                           
MFA-TR*                     THEN TIMESTAMP( '0001-01-01')                       
MFA-TR*                     ELSE VI.RLSE_DATE                                   
MFA-TR*                END                                                      
MFA-TR*               ,VC.METER_NO                                              
MFA-TR*               ,VC.CODE_UTIL_TYPE                                        
MFA-TR*               ,VC.IC_NO                                                 
MFA-TR*               ,VC.MTR_REF_NO                                            
MFA-TR*               ,VC.CODE_MTR_STATUS_IS                                    
MFA-TR*               ,VC.CODE_MTR_STATUS_WS                                    
MFA-TR*               ,' '                                                      
MFA-TR*               ,VC.LAST_READ_VALUE                                       
MFA-TR*               ,VC.LAST_REG_READ_DATE                                    
MFA-TR*               ,' '                                                      
MFA-TR*               ,VC.NO_DIALS                                              
MFA-TR*           FROM CSS_SO_MTR_CHG     VC                                    
MFA-TR*               ,CSS_SO_ORDER_INST  VI                                    
MFA-TR*          WHERE VI.SERV_ORDER_NO      = :VI-SERV-ORDER-NO                
MFA-TR*            AND VI.SERV_ORDER_NO      = VC.SERV_ORDER_NO                 
MFA-TR*            AND VI.METER_NO           = VC.METER_NO                      
MFA-TR*            AND VI.IC_NO              = VC.IC_NO                         
MFA-TR*            AND VI.CODE_UTIL_TYPE     = VC.CODE_UTIL_TYPE                
MFA-TR*            AND VI.MTR_REF_NO         = VC.MTR_REF_NO                    
MFA-TR*          UNION ALL                                                      
MFA-TR*         SELECT VI.SERV_ORDER_NO                                         
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,CASE WHEN VI.RLSE_DATE IS NULL                           
MFA-TR*                     THEN TIMESTAMP( '0001-01-01')                       
MFA-TR*                     ELSE VI.RLSE_DATE                                   
MFA-TR*                END                                                      
MFA-TR*               ,VM.METER_NO                                              
MFA-TR*               ,VM.CODE_UTIL_TYPE                                        
MFA-TR*               ,VM.IC_NO                                                 
MFA-TR*               ,VM.MTR_REF_NO                                            
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,VM.CODE_METER_STATUS                                     
MFA-TR*               ,VM.LAST_READ_VALUE                                       
MFA-TR*               ,TIMESTAMP('0001-01-01')                                  
MFA-TR*               ,' '                                                      
MFA-TR*               ,VM.NO_DIALS                                              
MFA-TR*           FROM CSS_SO_METER       VM                                    
MFA-TR*               ,CSS_SO_ORDER_INST  VI                                    
MFA-TR*          WHERE VI.SERV_ORDER_NO      = :VI-SERV-ORDER-NO                
MFA-TR*            AND VI.SERV_ORDER_NO      = VM.SERV_ORDER_NO                 
MFA-TR*            AND VI.IC_NO              = VM.IC_NO                         
MFA-TR*            AND VI.CODE_UTIL_TYPE     = VM.CODE_UTIL_TYPE                
MFA-TR*            AND VI.MTR_REF_NO         = VM.MTR_REF_NO                    
MFA-TR*            AND VM.METER_NO           > ' '                              
MFA-TR*          UNION ALL                                                      
MFA-TR*         SELECT VI.SERV_ORDER_NO                                         
MFA-TR*               ,VI.HOLD_RELEASE                                          
MFA-TR*               ,VI.RLSE_NO                                               
MFA-TR*               ,CASE WHEN VI.RLSE_DATE IS NULL                           
MFA-TR*                     THEN TIMESTAMP( '0001-01-01')                       
MFA-TR*                     ELSE VI.RLSE_DATE                                   
MFA-TR*                END                                                      
MFA-TR*               ,VI.METER_NO                                              
MFA-TR*               ,VI.CODE_UTIL_TYPE                                        
MFA-TR*               ,VI.IC_NO                                                 
MFA-TR*               ,VI.MTR_REF_NO                                            
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,0                                                        
MFA-TR*               ,TIMESTAMP('0001-01-01')                                  
MFA-TR*               ,VI.METER_SUPPLYING                                       
MFA-TR*               ,0                                                        
MFA-TR*           FROM CSS_SO_ORDER_INST  VI                                    
MFA-TR*          WHERE VI.SERV_ORDER_NO = :VI-SERV-ORDER-NO                     
MFA-TR*            AND (VI.HOLD_RELEASE = 'Y'                                   
MFA-TR*             OR VI.RLSE_NO > ' ')                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH HISTORY DATA FOR SO DATA BASED   *        
      *   ON THE PREMISE NO AND HISTORY CODE.                         *         
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE HST_SO_DATA_CSR CURSOR FOR                       
                SELECT YV.ACCOUNT_NO                                    
                      ,YV.SERV_ORDER_NO                                 
                      ,YV.ORDER_TYPE_CD                                 
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           YV.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME                             
                      ,YV.SERV_ORDER_STATUS                             
                      ,YV.ORDER_STATE_CD                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           YV.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                            
                      ,YV.ORDER_RECVED_BY                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), YV.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED                            
                      ,YV.WORK_AREA_ID                                  
                      ,YV.ACCOUNT_NO_PRIOR                              
                      ,YV.RESP_AREA_ID                                  
                      ,YV.BACK_DATED_IND                                
P0795B                ,YV.SOURCE_SYSTEM_CD                              
P0795C                ,YV.ORDER_KEY                                     
P0795E                ,YV.ORDER_REASON                                  
                      ,ZG.CODE_UTIL_TYPE                                
                      ,ZG.WORK_TYPE_CD                                  
D10004                ,ZG.TASK_STATUS_CD                                
                      ,R6.WORK_CLASS_ID                                 
                  FROM HST_SO_DATA        YV WITH(READUNCOMMITTED)              
                      ,HST_SO_ORDER_INST  ZG WITH(READUNCOMMITTED)              
                      ,CSS_ORDER_TYPE     OT WITH(READUNCOMMITTED)              
                      ,CSS_WORK_TYPE      WK WITH(READUNCOMMITTED)              
                      ,CSS_WK_CLASS_STAT  R6 WITH(READUNCOMMITTED)              
                 WHERE YV.PREMISE_NO         = :YV-PREMISE-NO           
                   AND YV.SERV_ORDER_NO      = ZG.SERV_ORDER_NO         
                   AND YV.ORDER_TYPE_CD      = OT.ORDER_TYPE_CD         
                   AND ZG.WORK_TYPE_CD       = WK.WORK_TYPE_CD          
                   AND YV.COMPANY_NO         = OT.COMPANY_NO            
                   AND OT.COMPANY_NO         = WK.COMPANY_NO            
                   AND OT.WORK_CLASS_ID      = R6.WORK_CLASS_ID         
                   AND YV.SERV_ORDER_STATUS  = R6.SERV_ORDER_STATUS     
                   AND ZG.WORK_TYPE_CD > ' '                            
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE HST_SO_DATA_CSR CURSOR FOR                               
MFA-TR*         SELECT YV.ACCOUNT_NO                                            
MFA-TR*               ,YV.SERV_ORDER_NO                                         
MFA-TR*               ,YV.ORDER_TYPE_CD                                         
MFA-TR*               ,YV.ASSIGNED_DATETIME                                     
MFA-TR*               ,YV.SERV_ORDER_STATUS                                     
MFA-TR*               ,YV.ORDER_STATE_CD                                        
MFA-TR*               ,YV.COMPLETED_DATETIME                                    
MFA-TR*               ,YV.ORDER_RECVED_BY                                       
MFA-TR*               ,YV.DATE_RECVED                                           
MFA-TR*               ,YV.WORK_AREA_ID                                          
MFA-TR*               ,YV.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,YV.RESP_AREA_ID                                          
MFA-TR*               ,YV.BACK_DATED_IND                                        
MFA-TR*               ,YV.SOURCE_SYSTEM_CD                                      
MFA-TR*               ,YV.ORDER_KEY                                             
MFA-TR*               ,YV.ORDER_REASON                                          
MFA-TR*               ,ZG.CODE_UTIL_TYPE                                        
MFA-TR*               ,ZG.WORK_TYPE_CD                                          
MFA-TR*               ,ZG.TASK_STATUS_CD                                        
MFA-TR*               ,R6.WORK_CLASS_ID                                         
MFA-TR*           FROM HST_SO_DATA        YV                                    
MFA-TR*               ,HST_SO_ORDER_INST  ZG                                    
MFA-TR*               ,CSS_ORDER_TYPE     OT                                    
MFA-TR*               ,CSS_WORK_TYPE      WK                                    
MFA-TR*               ,CSS_WK_CLASS_STAT  R6                                    
MFA-TR*          WHERE YV.PREMISE_NO         = :YV-PREMISE-NO                   
MFA-TR*            AND YV.SERV_ORDER_NO      = ZG.SERV_ORDER_NO                 
MFA-TR*            AND YV.ORDER_TYPE_CD      = OT.ORDER_TYPE_CD                 
MFA-TR*            AND ZG.WORK_TYPE_CD       = WK.WORK_TYPE_CD                  
MFA-TR*            AND YV.COMPANY_NO         = OT.COMPANY_NO                    
MFA-TR*            AND OT.COMPANY_NO         = WK.COMPANY_NO                    
MFA-TR*            AND OT.WORK_CLASS_ID      = R6.WORK_CLASS_ID                 
MFA-TR*            AND YV.SERV_ORDER_STATUS  = R6.SERV_ORDER_STATUS             
MFA-TR*            AND ZG.WORK_TYPE_CD > ' '                                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH CURRENT DATA2 FOR SO DATA BASED  *        
      *   ON THE PREMISE NO AND HISTORY CODE.                         *         
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE HST_SO_DATA_INST CURSOR FOR                      
                SELECT ZG.SERV_ORDER_NO                                 
                      ,' '                                              
                      ,' '                                              
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), CASE WHEN 
           ZG.RLSE_DATE IS NULL                   
P0795A                      THEN CIS.CHAR2TIMESTAMP( '0001-01-01')              
P0795A                      ELSE ZG.RLSE_DATE                           
P0795A                 END, 121), ' ', '-'), ':', '.')                          
                      ,VS.METER_NO                                      
                      ,VS.CODE_UTIL_TYPE                                
                      ,VS.IC_NO                                         
                      ,VS.MTR_REF_NO                                    
                      ,VS.CODE_MTR_STATUS_IS                            
                      ,VS.CODE_MTR_STATUS_WS                            
                      ,' '                                              
                      ,VS.LAST_READ_VALUE                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           VS.LAST_REG_READ_DATE, 121), ' ', '-'), ':', '.') 
           LAST_REG_READ_DATE                            
                      ,' '                                              
                      ,VS.NO_DIALS                                      
                  FROM HST_SO_MTR_CHG     VS WITH(READUNCOMMITTED)              
                      ,HST_SO_ORDER_INST  ZG WITH(READUNCOMMITTED)              
                 WHERE ZG.SERV_ORDER_NO      = :ZG-SERV-ORDER-NO        
                   AND ZG.SERV_ORDER_NO      = VS.SERV_ORDER_NO         
                   AND ZG.METER_NO           = VS.METER_NO              
                   AND ZG.IC_NO              = VS.IC_NO                 
                   AND ZG.CODE_UTIL_TYPE     = VS.CODE_UTIL_TYPE        
                   AND ZG.MTR_REF_NO         = VS.MTR_REF_NO            
                 UNION ALL                                              
                SELECT ZG.SERV_ORDER_NO                                 
                      ,' '                                              
                      ,' '                                              
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), CASE WHEN 
           ZG.RLSE_DATE IS NULL                   
P0795A                      THEN CIS.CHAR2TIMESTAMP( '0001-01-01')              
P0795A                      ELSE ZG.RLSE_DATE                           
P0795A                 END, 121), ' ', '-'), ':', '.')                          
                      ,VR.METER_NO                                      
                      ,VR.CODE_UTIL_TYPE                                
                      ,VR.IC_NO                                         
                      ,VR.MTR_REF_NO                                    
                      ,' '                                              
                      ,' '                                              
                      ,VR.CODE_METER_STATUS                             
                      ,VR.LAST_READ_VALUE                               
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CHAR2TIMESTAMP('0001-01-01'), 121), ' ', '-'), ':', '.')        
                      ,' '                                              
                      ,VR.NO_DIALS                                      
                  FROM HST_SO_METER       VR WITH(READUNCOMMITTED)              
                      ,HST_SO_ORDER_INST  ZG WITH(READUNCOMMITTED)              
                 WHERE ZG.SERV_ORDER_NO      = :ZG-SERV-ORDER-NO        
                   AND ZG.SERV_ORDER_NO      = VR.SERV_ORDER_NO         
                   AND ZG.IC_NO              = VR.IC_NO                 
                   AND ZG.CODE_UTIL_TYPE     = VR.CODE_UTIL_TYPE        
                   AND ZG.MTR_REF_NO         = VR.MTR_REF_NO            
                   AND VR.METER_NO           > ' '                      
                 UNION ALL                                              
                SELECT ZG.SERV_ORDER_NO                                 
                      ,ZG.HOLD_RELEASE                                  
                      ,ZG.RLSE_NO                                       
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), CASE WHEN 
           ZG.RLSE_DATE IS NULL                   
P0795A                      THEN CIS.CHAR2TIMESTAMP( '0001-01-01')              
P0795A                      ELSE ZG.RLSE_DATE                           
P0795A                 END, 121), ' ', '-'), ':', '.')                          
                      ,ZG.METER_NO                                      
                      ,ZG.CODE_UTIL_TYPE                                
                      ,ZG.IC_NO                                         
                      ,ZG.MTR_REF_NO                                    
                      ,' '                                              
                      ,' '                                              
                      ,' '                                              
                      ,0                                                
P0795A                ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CHAR2TIMESTAMP('0001-01-01'), 121), ' ', '-'), ':', '.')        
                      ,ZG.METER_SUPPLYING                               
                      ,0                                                
                  FROM HST_SO_ORDER_INST  ZG WITH(READUNCOMMITTED)              
                 WHERE ZG.SERV_ORDER_NO = :ZG-SERV-ORDER-NO             
                   AND (ZG.HOLD_RELEASE = 'Y'                           
                    OR ZG.RLSE_NO > ' ')                                
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE HST_SO_DATA_INST CURSOR FOR                              
MFA-TR*         SELECT ZG.SERV_ORDER_NO                                         
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,CASE WHEN ZG.RLSE_DATE IS NULL                           
MFA-TR*                     THEN TIMESTAMP( '0001-01-01')                       
MFA-TR*                     ELSE ZG.RLSE_DATE                                   
MFA-TR*                END                                                      
MFA-TR*               ,VS.METER_NO                                              
MFA-TR*               ,VS.CODE_UTIL_TYPE                                        
MFA-TR*               ,VS.IC_NO                                                 
MFA-TR*               ,VS.MTR_REF_NO                                            
MFA-TR*               ,VS.CODE_MTR_STATUS_IS                                    
MFA-TR*               ,VS.CODE_MTR_STATUS_WS                                    
MFA-TR*               ,' '                                                      
MFA-TR*               ,VS.LAST_READ_VALUE                                       
MFA-TR*               ,VS.LAST_REG_READ_DATE                                    
MFA-TR*               ,' '                                                      
MFA-TR*               ,VS.NO_DIALS                                              
MFA-TR*           FROM HST_SO_MTR_CHG     VS                                    
MFA-TR*               ,HST_SO_ORDER_INST  ZG                                    
MFA-TR*          WHERE ZG.SERV_ORDER_NO      = :ZG-SERV-ORDER-NO                
MFA-TR*            AND ZG.SERV_ORDER_NO      = VS.SERV_ORDER_NO                 
MFA-TR*            AND ZG.METER_NO           = VS.METER_NO                      
MFA-TR*            AND ZG.IC_NO              = VS.IC_NO                         
MFA-TR*            AND ZG.CODE_UTIL_TYPE     = VS.CODE_UTIL_TYPE                
MFA-TR*            AND ZG.MTR_REF_NO         = VS.MTR_REF_NO                    
MFA-TR*          UNION ALL                                                      
MFA-TR*         SELECT ZG.SERV_ORDER_NO                                         
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,CASE WHEN ZG.RLSE_DATE IS NULL                           
MFA-TR*                     THEN TIMESTAMP( '0001-01-01')                       
MFA-TR*                     ELSE ZG.RLSE_DATE                                   
MFA-TR*                END                                                      
MFA-TR*               ,VR.METER_NO                                              
MFA-TR*               ,VR.CODE_UTIL_TYPE                                        
MFA-TR*               ,VR.IC_NO                                                 
MFA-TR*               ,VR.MTR_REF_NO                                            
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,VR.CODE_METER_STATUS                                     
MFA-TR*               ,VR.LAST_READ_VALUE                                       
MFA-TR*               ,TIMESTAMP('0001-01-01')                                  
MFA-TR*               ,' '                                                      
MFA-TR*               ,VR.NO_DIALS                                              
MFA-TR*           FROM HST_SO_METER       VR                                    
MFA-TR*               ,HST_SO_ORDER_INST  ZG                                    
MFA-TR*          WHERE ZG.SERV_ORDER_NO      = :ZG-SERV-ORDER-NO                
MFA-TR*            AND ZG.SERV_ORDER_NO      = VR.SERV_ORDER_NO                 
MFA-TR*            AND ZG.IC_NO              = VR.IC_NO                         
MFA-TR*            AND ZG.CODE_UTIL_TYPE     = VR.CODE_UTIL_TYPE                
MFA-TR*            AND ZG.MTR_REF_NO         = VR.MTR_REF_NO                    
MFA-TR*            AND VR.METER_NO           > ' '                              
MFA-TR*          UNION ALL                                                      
MFA-TR*         SELECT ZG.SERV_ORDER_NO                                         
MFA-TR*               ,ZG.HOLD_RELEASE                                          
MFA-TR*               ,ZG.RLSE_NO                                               
MFA-TR*               ,CASE WHEN ZG.RLSE_DATE IS NULL                           
MFA-TR*                     THEN TIMESTAMP( '0001-01-01')                       
MFA-TR*                     ELSE ZG.RLSE_DATE                                   
MFA-TR*                END                                                      
MFA-TR*               ,ZG.METER_NO                                              
MFA-TR*               ,ZG.CODE_UTIL_TYPE                                        
MFA-TR*               ,ZG.IC_NO                                                 
MFA-TR*               ,ZG.MTR_REF_NO                                            
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,' '                                                      
MFA-TR*               ,0                                                        
MFA-TR*               ,TIMESTAMP('0001-01-01')                                  
MFA-TR*               ,ZG.METER_SUPPLYING                                       
MFA-TR*               ,0                                                        
MFA-TR*           FROM HST_SO_ORDER_INST  ZG                                    
MFA-TR*          WHERE ZG.SERV_ORDER_NO = :ZG-SERV-ORDER-NO                     
MFA-TR*            AND (ZG.HOLD_RELEASE = 'Y'                                   
MFA-TR*             OR ZG.RLSE_NO > ' ')                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7550                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH REMARKS                                   
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE SO_REMARKS_CSR CURSOR FOR                        
                SELECT EF.SERV_ORDER_NO                                 
                      ,EF.REMARK_TYPE_CD                                
                      ,EF.REMARK_TX                                     
                  FROM CSS_SO_REMARKS EF WITH(READUNCOMMITTED)                  
                 WHERE EF.SERV_ORDER_NO      = :EF-SERV-ORDER-NO        
                   AND EF.REMARK_TYPE_CD IN ('G','H','C','O','P', 'A')  
                   AND EF.REMARK_DATETIME =                             
                       (SELECT MAX(R1.REMARK_DATETIME)                  
                          FROM CSS_SO_REMARKS R1 WITH(READUNCOMMITTED)          
                         WHERE R1.SERV_ORDER_NO  = EF.SERV_ORDER_NO     
                           AND R1.REMARK_TYPE_CD =EF.REMARK_TYPE_CD)    
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_REMARKS_CSR CURSOR FOR                                
MFA-TR*         SELECT EF.SERV_ORDER_NO                                         
MFA-TR*               ,EF.REMARK_TYPE_CD                                        
MFA-TR*               ,EF.REMARK_TX                                             
MFA-TR*           FROM CSS_SO_REMARKS EF                                        
MFA-TR*          WHERE EF.SERV_ORDER_NO      = :EF-SERV-ORDER-NO                
MFA-TR*            AND EF.REMARK_TYPE_CD IN ('G','H','C','O','P', 'A')          
MFA-TR*            AND EF.REMARK_DATETIME =                                     
MFA-TR*                (SELECT MAX(R1.REMARK_DATETIME)                          
MFA-TR*                   FROM CSS_SO_REMARKS R1                                
MFA-TR*                  WHERE R1.SERV_ORDER_NO  = EF.SERV_ORDER_NO             
MFA-TR*                    AND R1.REMARK_TYPE_CD =EF.REMARK_TYPE_CD)            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH HST REMARKS                               
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE SO_HST_REMARKS_CSR CURSOR FOR                    
                SELECT OE.SERV_ORDER_NO                                 
                      ,OE.REMARK_TYPE_CD                                
                      ,OE.REMARK_TX                                     
                  FROM HST_SO_REMARKS OE WITH(READUNCOMMITTED)                  
                 WHERE OE.SERV_ORDER_NO      = :OE-SERV-ORDER-NO        
                   AND OE.REMARK_TYPE_CD IN ('G','H','C','O','P','A')   
                   AND OE.REMARK_DATETIME =                             
                       (SELECT MAX(R1.REMARK_DATETIME)                  
                          FROM HST_SO_REMARKS R1 WITH(READUNCOMMITTED)          
                         WHERE R1.SERV_ORDER_NO  = OE.SERV_ORDER_NO     
                           AND R1.REMARK_TYPE_CD = OE.REMARK_TYPE_CD)   
                   FOR READ ONLY                                
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_HST_REMARKS_CSR CURSOR FOR                            
MFA-TR*         SELECT OE.SERV_ORDER_NO                                         
MFA-TR*               ,OE.REMARK_TYPE_CD                                        
MFA-TR*               ,OE.REMARK_TX                                             
MFA-TR*           FROM HST_SO_REMARKS OE                                        
MFA-TR*          WHERE OE.SERV_ORDER_NO      = :OE-SERV-ORDER-NO                
MFA-TR*            AND OE.REMARK_TYPE_CD IN ('G','H','C','O','P','A')           
MFA-TR*            AND OE.REMARK_DATETIME =                                     
MFA-TR*                (SELECT MAX(R1.REMARK_DATETIME)                          
MFA-TR*                   FROM HST_SO_REMARKS R1                                
MFA-TR*                  WHERE R1.SERV_ORDER_NO  = OE.SERV_ORDER_NO             
MFA-TR*                    AND R1.REMARK_TYPE_CD = OE.REMARK_TYPE_CD)           
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747 CURSOR
MSQ001          FOR CALL CSR04747 ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :WORK-DISTRICT-IN-4747 OUTPUT
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01 I-PREMISE-NO          PIC X(10).                              
       01 I-HISTORY-CODE        PIC X(01).                              
                                                                        
       PROCEDURE DIVISION USING I-PREMISE-NO, I-HISTORY-CODE.           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02920000
      * 0100-INITIALIZE                                                *02930000
      *                                                                *02940000
      *     1. RESET DB2 ERROR HANDLERS                                *02950000
      *     2. DECLARE CURSORS FOR RETURN VALUES.                      *02960000
      *                                                                *02990000
      ******************************************************************03000000
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                          TO ACTIVE-PARAGRAPH.    
           PERFORM 0100A-DECLARE-GTT-R1         THRU 0100A-EXIT.        
           PERFORM 0100B-DECLARE-GTT-R2         THRU 0100B-EXIT.        
           PERFORM 0100C-DECLARE-GTT-R3         THRU 0100C-EXIT.        
           PERFORM 0100D-DECLARE-GTT-R4         THRU 0100D-EXIT.        
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE '0100A'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04744_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04744_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04744_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,SERV_ORDER_NO           DECIMAL(13,0)               
                   ,FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,ORDER_TYPE_CODE CHAR(5)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,WORK_TYPE_CODE CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,ASSIGNED_DATETIME CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SERV_ORDER_STATUS CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,ORDER_STATE_CODE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,COMPLETED_DATETIME CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WORK_CLASS_ID CHAR(4)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,BACK_DATED_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
P0795B             ,SOURCE_SYSTEM_CD CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
P0795C             ,ORDER_KEY CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
P0795D             ,CODE_RENTAL_PROP CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
P0795E             ,ORDER_REASON CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
D10004             ,IS_CLICK_ORDER CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
D10004             ,TASK_STATUS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE               AS RETURN_CODE         
                      ,LTRIM(RTRIM(ACCOUNT_NO))         AS 
           ACCOUNT_NUMBER      
                      ,SERV_ORDER_NO             AS SERVICE_ORDER_NUMBER
                      ,LTRIM(RTRIM(FULL_NAME))          AS FULL_NAME           
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))     AS 
           CODE_UTILITY_TYPE   
                      ,LTRIM(RTRIM(ORDER_TYPE_CODE))    AS 
           ORDER_TYPE_CODE     
                      ,LTRIM(RTRIM(WORK_TYPE_CODE))     AS 
           WORK_TYPE_CODE      
                      ,LTRIM(RTRIM(ASSIGNED_DATETIME))  AS 
           ASSIGNED_DATETIME   
                      ,LTRIM(RTRIM(SERV_ORDER_STATUS))  AS 
           SERV_ORDER_STATUS   
                      ,LTRIM(RTRIM(ORDER_STATE_CODE))   AS 
           ORDER_STATE_CODE    
                      ,LTRIM(RTRIM(COMPLETED_DATETIME)) AS 
           COMPLETED_DATETIME  
                      ,LTRIM(RTRIM(WORK_CLASS_ID))      AS WORK_CLASS_ID       
                      ,LTRIM(RTRIM(BACK_DATED_IND))     AS 
           BACK_DATED_INDICATOR
P0795B                ,LTRIM(RTRIM(SOURCE_SYSTEM_CD))   AS 
           SOURCE_SYSTEM_CODE  
P0795C                ,LTRIM(RTRIM(ORDER_KEY))          AS ORDER_KEY           
P0795D                ,LTRIM(RTRIM(CODE_RENTAL_PROP))   AS 
           CODE_RENTAL_PROP    
P0795E                ,LTRIM(RTRIM(ORDER_REASON))       AS ORDER_REASON        
D10004                ,LTRIM(RTRIM(IS_CLICK_ORDER))     AS 
           IS_CLICK_ORDER      
D10004                ,LTRIM(RTRIM(TASK_STATUS_CD))     AS 
           TASK_STATUS_CODE    
                  FROM #CSR04744_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE               AS RETURN_CODE                 
MFA-TR*               ,STRIP(ACCOUNT_NO)         AS ACCOUNT_NUMBER              
MFA-TR*               ,SERV_ORDER_NO             AS SERVICE_ORDER_NUMBER        
MFA-TR*               ,STRIP(FULL_NAME)          AS FULL_NAME                   
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)     AS CODE_UTILITY_TYPE           
MFA-TR*               ,STRIP(ORDER_TYPE_CODE)    AS ORDER_TYPE_CODE             
MFA-TR*               ,STRIP(WORK_TYPE_CODE)     AS WORK_TYPE_CODE              
MFA-TR*               ,STRIP(ASSIGNED_DATETIME)  AS ASSIGNED_DATETIME           
MFA-TR*               ,STRIP(SERV_ORDER_STATUS)  AS SERV_ORDER_STATUS           
MFA-TR*               ,STRIP(ORDER_STATE_CODE)   AS ORDER_STATE_CODE            
MFA-TR*               ,STRIP(COMPLETED_DATETIME) AS COMPLETED_DATETIME          
MFA-TR*               ,STRIP(WORK_CLASS_ID)      AS WORK_CLASS_ID               
MFA-TR*               ,STRIP(BACK_DATED_IND)     AS BACK_DATED_INDICATOR        
MFA-TR*               ,STRIP(SOURCE_SYSTEM_CD)   AS SOURCE_SYSTEM_CODE          
MFA-TR*               ,STRIP(ORDER_KEY)          AS ORDER_KEY                   
MFA-TR*               ,STRIP(CODE_RENTAL_PROP)   AS CODE_RENTAL_PROP            
MFA-TR*               ,STRIP(ORDER_REASON)       AS ORDER_REASON                
MFA-TR*               ,STRIP(IS_CLICK_ORDER)     AS IS_CLICK_ORDER              
MFA-TR*               ,STRIP(TASK_STATUS_CD)     AS TASK_STATUS_CODE            
MFA-TR*           FROM SESSION.CSR04744_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE '0100B'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04744_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04744_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04744_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,SERV_ORDER_NO           DECIMAL(13,0)               
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,ORDER_RECEIVED_BY CHAR(7)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,ORDER_REC_BY_NAME CHAR(28)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INITIATED_ON CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATED_BY CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_BY_NAME CHAR(28)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATED_ON CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WORK_AREA_ID CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCOUNT_NO_PRIOR CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SERVICE_CHARGE          DECIMAL(9,2)               
                   ,RESP_AREA_ID_INIT_BY CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RESP_AREA_ID_UPDT_BY CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE               AS RETURN_CODE         
                      ,LTRIM(RTRIM(ACCOUNT_NO))         AS 
           ACCOUNT_NUMBER      
                      ,SERV_ORDER_NO             AS SERVICE_ORDER_NUMBER
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))     AS 
           CODE_UTILITY_TYPE   
                      ,LTRIM(RTRIM(ORDER_RECEIVED_BY))  AS 
           ORDER_RECEIVED_BY   
                      ,LTRIM(RTRIM(ORDER_REC_BY_NAME))  AS 
           ORDER_REC_BY_NAME   
                      ,LTRIM(RTRIM(INITIATED_ON))       AS INITIATED_ON        
                      ,LTRIM(RTRIM(LAST_UPDATED_BY))    AS 
           LAST_UPDATED_BY     
                      ,LTRIM(RTRIM(LAST_UPDATE_BY_NAME)) AS 
           LAST_UPDATE_BY_NAME
                      ,LTRIM(RTRIM(LAST_UPDATED_ON))    AS 
           LAST_UPDATED_ON     
                      ,LTRIM(RTRIM(WORK_AREA_ID))       AS WORK_AREA_ID        
                      ,LTRIM(RTRIM(ACCOUNT_NO_PRIOR))   AS 
           ACCOUNT_NO_PRIOR    
                      ,SERVICE_CHARGE            AS SERVICE_CHARGE      
                      ,LTRIM(RTRIM(RESP_AREA_ID_INIT_BY))                      
                                               AS RESP_AREA_ID_INIT_BY  
                      ,LTRIM(RTRIM(RESP_AREA_ID_UPDT_BY))                      
                                               AS RESP_AREA_ID_UPDATE_BY
                  FROM #CSR04744_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE               AS RETURN_CODE                 
MFA-TR*               ,STRIP(ACCOUNT_NO)         AS ACCOUNT_NUMBER              
MFA-TR*               ,SERV_ORDER_NO             AS SERVICE_ORDER_NUMBER        
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)     AS CODE_UTILITY_TYPE           
MFA-TR*               ,STRIP(ORDER_RECEIVED_BY)  AS ORDER_RECEIVED_BY           
MFA-TR*               ,STRIP(ORDER_REC_BY_NAME)  AS ORDER_REC_BY_NAME           
MFA-TR*               ,STRIP(INITIATED_ON)       AS INITIATED_ON                
MFA-TR*               ,STRIP(LAST_UPDATED_BY)    AS LAST_UPDATED_BY             
MFA-TR*               ,STRIP(LAST_UPDATE_BY_NAME) AS LAST_UPDATE_BY_NAME        
MFA-TR*               ,STRIP(LAST_UPDATED_ON)    AS LAST_UPDATED_ON             
MFA-TR*               ,STRIP(WORK_AREA_ID)       AS WORK_AREA_ID                
MFA-TR*               ,STRIP(ACCOUNT_NO_PRIOR)   AS ACCOUNT_NO_PRIOR            
MFA-TR*               ,SERVICE_CHARGE            AS SERVICE_CHARGE              
MFA-TR*               ,STRIP(RESP_AREA_ID_INIT_BY)                              
MFA-TR*                                        AS RESP_AREA_ID_INIT_BY          
MFA-TR*               ,STRIP(RESP_AREA_ID_UPDT_BY)                              
MFA-TR*                                        AS RESP_AREA_ID_UPDATE_BY        
MFA-TR*           FROM SESSION.CSR04744_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3                                           *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE '0100C'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04744_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04744_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04744_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,SERV_ORDER_NO           DECIMAL(13,0)               
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,HOLD_RELEASE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,RLSE_DATE CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,CODE_MTR_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_READ_VALUE         DECIMAL(15,3)               
                   ,LAST_REG_READ_DATE CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,METER_SUPPLYING CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,IC_NO                   INT                     
                   ,MTR_REF_NO              INT                     
                   ,NO_DIALS                INT                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE              AS RETURN_CODE          
                      ,LTRIM(RTRIM(ACCOUNT_NO))        AS ACCOUNT_NUMBER       
                      ,SERV_ORDER_NO            AS SERVICE_ORDER_NUMBER 
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))    AS 
           CODE_UTILITY_TYPE    
                      ,LTRIM(RTRIM(HOLD_RELEASE))      AS RELEASE_STATUS       
                      ,LTRIM(RTRIM(RLSE_NO))           AS RELEASE_NUMBER       
                      ,LTRIM(RTRIM(RLSE_DATE))         AS RELEASE_DATE         
                      ,LTRIM(RTRIM(METER_NO))          AS METER_NUMBER         
                      ,LTRIM(RTRIM(CODE_MTR_STATUS))   AS 
           CODE_MTR_STATUS_WS   
                      ,LAST_READ_VALUE          AS LAST_READ_VALUE      
                      ,LAST_REG_READ_DATE       AS LAST_REG_READ_DATE   
                      ,LTRIM(RTRIM(METER_SUPPLYING))   AS 
           METER_SUPPLYING      
                      ,IC_NO                    AS IC_NO                
                      ,MTR_REF_NO               AS MTR_REF_NO           
                      ,NO_DIALS                 AS NO_DIALS             
                 FROM #CSR04744_R3                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE              AS RETURN_CODE                  
MFA-TR*               ,STRIP(ACCOUNT_NO)        AS ACCOUNT_NUMBER               
MFA-TR*               ,SERV_ORDER_NO            AS SERVICE_ORDER_NUMBER         
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)    AS CODE_UTILITY_TYPE            
MFA-TR*               ,STRIP(HOLD_RELEASE)      AS RELEASE_STATUS               
MFA-TR*               ,STRIP(RLSE_NO)           AS RELEASE_NUMBER               
MFA-TR*               ,STRIP(RLSE_DATE)         AS RELEASE_DATE                 
MFA-TR*               ,STRIP(METER_NO)          AS METER_NUMBER                 
MFA-TR*               ,STRIP(CODE_MTR_STATUS)   AS CODE_MTR_STATUS_WS           
MFA-TR*               ,LAST_READ_VALUE          AS LAST_READ_VALUE              
MFA-TR*               ,LAST_REG_READ_DATE       AS LAST_REG_READ_DATE           
MFA-TR*               ,STRIP(METER_SUPPLYING)   AS METER_SUPPLYING              
MFA-TR*               ,IC_NO                    AS IC_NO                        
MFA-TR*               ,MTR_REF_NO               AS MTR_REF_NO                   
MFA-TR*               ,NO_DIALS                 AS NO_DIALS                     
MFA-TR*          FROM SESSION.CSR04744_R3                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100D-DECLARE-GTT-R4                                           *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE '0100D'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'SESSION.CSR04744_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04744_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04744_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,SERV_ORDER_NO           DECIMAL(13,0)               
                   ,REMARK_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REMARK_TX CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE              AS RETURN_CODE          
                      ,SERV_ORDER_NO            AS SERVICE_ORDER_NUMBER 
                      ,LTRIM(RTRIM(REMARK_TYPE_CD))    AS REMARK_TYPE_CD       
                      ,LTRIM(RTRIM(REMARK_TX))         AS REMARK_TEXT          
                 FROM #CSR04744_R4                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE              AS RETURN_CODE                  
MFA-TR*               ,SERV_ORDER_NO            AS SERVICE_ORDER_NUMBER         
MFA-TR*               ,STRIP(REMARK_TYPE_CD)    AS REMARK_TYPE_CD               
MFA-TR*               ,STRIP(REMARK_TX)         AS REMARK_TEXT                  
MFA-TR*          FROM SESSION.CSR04744_R4                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
           MOVE I-PREMISE-NO                   TO WS-PREMISE-NO.        
           MOVE I-HISTORY-CODE                 TO WS-HISTORY-CODE.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           IF WS-HISTORY-CODE NOT EQUAL WS-HIST                         
              MOVE    WS-PREMISE-NO                TO VO-PREMISE-NO     
              PERFORM 7000-OPEN-SO-DATA-CSR        THRU 7000-EXIT       
              PERFORM 7010-FETCH-SO-DATA-CSR       THRU 7010-EXIT       
              PERFORM 2100-BUILD-SO-DATA-RESULT    THRU 2100-EXIT       
                                                 UNTIL NO-MORE-SO-ROWS  
              PERFORM 7020-CLOSE-SO-DATA-CSR       THRU 7020-EXIT       
           ELSE                                                         
              MOVE    WS-PREMISE-NO                TO YV-PREMISE-NO     
              PERFORM 7500-OPEN-HST-SO-DATA-CSR    THRU 7500-EXIT       
              PERFORM 7510-FETCH-HST-SO-DATA-CSR   THRU 7510-EXIT       
              PERFORM 2200-BUILD-HST-SO-RESULT     THRU 2200-EXIT       
                                                 UNTIL NO-MORE-HST-ROWS 
              PERFORM 7520-CLOSE-HST-SO-DATA-CSR   THRU 7520-EXIT       
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-BUILD-SO-DATA-RESULT.                                    *         
      ******************************************************************        
       2100-BUILD-SO-DATA-RESULT.                                       
                                                                        
           MOVE '2100'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 2150-LOAD-RESULT-SET-1       THRU 2150-EXIT.         
           PERFORM 2160-LOAD-RESULT-SET-2       THRU 2160-EXIT.         
                                                                        
           IF VO-SERV-ORDER-NO NOT EQUAL WS-PREV-SERV-ORDER-NO          
              MOVE WS-N                         TO WS-NO-MORE-INST-ROWS 
              MOVE VO-SERV-ORDER-NO             TO VI-SERV-ORDER-NO     
              PERFORM 7100-OPEN-ORDER-INST-CSR  THRU 7100-EXIT          
              PERFORM 7110-FETCH-ORDER-INST-CSR THRU 7110-EXIT          
              PERFORM 2170-LOAD-RESULT-SET-3    THRU 2170-EXIT          
                                                UNTIL NO-MORE-INST-ROWS 
              PERFORM 7120-CLOSE-ORDER-INST-CSR THRU 7120-EXIT          
                                                                        
              MOVE WS-N                         TO WS-NO-MORE-RMRK-ROWS 
              MOVE VO-SERV-ORDER-NO             TO EF-SERV-ORDER-NO     
              PERFORM 7200-OPEN-REMARKS-CSR     THRU 7200-EXIT          
              PERFORM 7210-FETCH-REMARKS-CSR    THRU 7210-EXIT          
              PERFORM 2180-LOAD-RESULT-SET-4    THRU 2180-EXIT          
                                                UNTIL NO-MORE-RMRK-ROWS 
              PERFORM 7220-CLOSE-REMARKS-CSR    THRU 7220-EXIT          
                                                                        
           END-IF.                                                      
           MOVE VO-SERV-ORDER-NO                TO                      
                                                WS-PREV-SERV-ORDER-NO.  
                                                                        
           PERFORM 7010-FETCH-SO-DATA-CSR       THRU 7010-EXIT.         
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2150-LOAD-RESULT-SET-1.                                        *        
      ******************************************************************        
       2150-LOAD-RESULT-SET-1.                                          
                                                                        
           MOVE '2150'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           MOVE SPACES                     TO DQ-FULL-NAME.             
P0795D     MOVE SPACE                      TO PR-CODE-RENTAL-PROP.      
           IF VO-ACCOUNT-NO > 0                                         
              MOVE VO-ACCOUNT-NO           TO HT-ACCOUNT-NO             
              PERFORM 7600-GET-NAME        THRU 7600-EXIT               
           END-IF.                                                      
P0795D     IF WS-PREMISE-NO > 0                                         
P0795D        MOVE WS-PREMISE-NO            TO PR-PREMISE-NO            
P0795D        PERFORM 7700-GET-PREMISE-INFO THRU 7700-EXIT              
P0795D     END-IF.                                                      
                                                                        
           MOVE VO-ACCOUNT-NO              TO S-RS1-ACCOUNT-NO          
           MOVE VO-SERV-ORDER-NO           TO S-RS1-SERV-ORDER-NO       
           MOVE DQ-FULL-NAME               TO S-RS1-FULL-NAME           
           MOVE VI-CODE-UTIL-TYPE          TO S-RS1-CODE-UTIL-TYPE      
           MOVE VO-ORDER-TYPE-CD           TO S-RS1-ORDER-TYPE-CODE     
           MOVE VI-WORK-TYPE-CD            TO S-RS1-WORK-TYPE-CODE      
D10004     MOVE VI-TASK-STATUS-CD          TO S-RS1-TASK-STATUS-CODE    
           MOVE VO-ASSIGNED-DATETIME       TO S-RS1-ASSIGNED-DATETIME   
           MOVE VO-SERV-ORDER-STATUS       TO S-RS1-SERV-ORDER-STATUS   
           MOVE VO-ORDER-STATE-CD          TO S-RS1-ORDER-STATE-CODE    
           MOVE VO-COMPLETED-DATETIME      TO S-RS1-COMPLETED-DATETIME  
           MOVE R6-WORK-CLASS-ID           TO S-RS1-WORK-CLASS-ID       
           MOVE VO-BACK-DATED-IND          TO S-RS1-BACK-DATED-IND      
P0795B     MOVE VO-SOURCE-SYSTEM-CD        TO S-RS1-SOURCE-SYSTEM-CD    
P0795C     MOVE VO-ORDER-KEY               TO S-RS1-ORDER-KEY           
P0795D     MOVE PR-CODE-RENTAL-PROP        TO S-RS1-CODE-RENTAL-PROP    
P0795E     MOVE VO-ORDER-REASON            TO S-RS1-ORDER-REASON        
D10004     IF WORK-DISTRICT-OUT-4747 > SPACES                           
D10004        MOVE 'Y' TO S-RS1-IS-CLICK-ORDER                          
D10004     ELSE                                                         
D10004        MOVE 'N' TO S-RS1-IS-CLICK-ORDER                          
D10004     END-IF                                                       
                                                                        
           PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT.              
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2160-LOAD-RESULT-SET-2.                                        *        
      ******************************************************************        
       2160-LOAD-RESULT-SET-2.                                          
                                                                        
           MOVE '2160'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
           IF VO-SERV-ORDER-NO NOT EQUAL WS-PREV-SERV-ORDER-NO          
              MOVE VO-SERV-ORDER-NO            TO VW-SERV-ORDER-NO      
              PERFORM 7610-GET-LAST-UPDT-BY    THRU 7610-EXIT           
              MOVE    VW-USER-ID-UPDT-BY       TO PF-USER-ID            
              PERFORM 7615-GET-RESP-AREA-ID    THRU 7615-EXIT           
              MOVE WS-USER-NAME               TO S-RS2-UPDATE-BY-NAME   
              MOVE PF-RESP-AREA-ID            TO S-RS2-RESP-AREA-UPDT-BY
              MOVE VO-ORDER-RECVED-BY          TO PF-USER-ID            
              PERFORM 7615-GET-RESP-AREA-ID    THRU 7615-EXIT           
              MOVE WS-USER-NAME               TO S-RS2-ORDER-REC-BY-NAME
              MOVE PF-RESP-AREA-ID            TO S-RS2-RESP-AREA-INIT-BY
           END-IF.                                                      
                                                                        
           MOVE VO-SERV-ORDER-NO              TO VG-SERV-ORDER-NO       
           MOVE VI-CODE-UTIL-TYPE             TO VG-CODE-UTIL-TYPE      
           PERFORM 7620-GET-SERV-CHARGE       THRU 7620-EXIT.           
                                                                        
           MOVE VO-ACCOUNT-NO                 TO S-RS2-ACCOUNT-NO       
           MOVE VO-SERV-ORDER-NO              TO S-RS2-SERV-ORDER-NO    
           MOVE VI-CODE-UTIL-TYPE             TO S-RS2-CODE-UTIL-TYPE   
           MOVE VO-ORDER-RECVED-BY            TO S-RS2-ORDER-RECVED-BY  
           MOVE VO-DATE-RECVED                TO S-RS2-DATE-RECVED      
           MOVE VW-USER-ID-UPDT-BY            TO S-RS2-USER-ID-UPDT-BY  
           MOVE VW-UPDATE-DATETIME            TO S-RS2-UPDATE-DATETIME  
           MOVE VO-WORK-AREA-ID               TO S-RS2-WORK-AREA-ID     
           MOVE VO-ACCOUNT-NO-PRIOR           TO S-RS2-ACCOUNT-NO-PRIOR 
           MOVE VG-STD-LABOR-CHRG             TO S-RS2-STD-LABOR-CHRG   
                                                                        
           PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT.           
                                                                        
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 2170-LOAD-RESULT-SET-3.                                       *         
      ******************************************************************        
       2170-LOAD-RESULT-SET-3.                                          
                                                                        
           MOVE '2170'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE GTT-RETURN-FIELDS-3                               
                                                                        
           MOVE VO-ACCOUNT-NO               TO S-RS3-ACCOUNT-NO         
           MOVE VI-SERV-ORDER-NO            TO S-RS3-SERV-ORDER-NO      
           MOVE VC-CODE-UTIL-TYPE           TO S-RS3-CODE-UTIL-TYPE     
           MOVE VI-HOLD-RELEASE             TO S-RS3-HOLD-RELEASE       
           MOVE VI-RLSE-NO                  TO S-RS3-RLSE-NO            
           MOVE VI-RLSE-DATE                TO S-RS3-RLSE-DATE          
           MOVE VC-LAST-READ-VALUE          TO S-RS3-LAST-READ-VALUE    
           MOVE VC-LAST-REG-READ-DATE       TO S-RS3-LAST-REG-READ-DATE 
           MOVE VC-METER-SUPPLYING          TO S-RS3-METER-SUPPLYING    
           MOVE VC-METER-NO                 TO S-RS3-METER-NO           
           MOVE VC-IC-NO                    TO S-RS3-IC-NO              
           MOVE VC-MTR-REF-NO               TO S-RS3-MTR-REF-NO         
           MOVE VC-NO-DIALS                 TO S-RS3-NO-DIALS           
           IF VC-CODE-MTR-STATUS-IS > SPACES                            
              MOVE VC-CODE-MTR-STATUS-IS    TO S-RS3-CODE-MTR-STATUS    
           ELSE                                                         
              IF VC-CODE-MTR-STATUS-WS > SPACES                         
                 MOVE VC-CODE-MTR-STATUS-WS TO S-RS3-CODE-MTR-STATUS    
              ELSE                                                      
                 MOVE VM-CODE-METER-STATUS  TO S-RS3-CODE-MTR-STATUS    
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8030-INSERT-GTT-R3           THRU 8030-EXIT          
                                                                        
           PERFORM 7110-FETCH-ORDER-INST-CSR    THRU 7110-EXIT.         
                                                                        
       2170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2180-LOAD-RESULT-SET-4.                                       *         
      ******************************************************************        
       2180-LOAD-RESULT-SET-4.                                          
                                                                        
           MOVE '2180'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE GTT-RETURN-FIELDS-4.                              
           INITIALIZE WS-SPACE-CNT.                                     
           MOVE EF-SERV-ORDER-NO               TO S-RS4-SERV-ORDER-NO.  
           MOVE EF-REMARK-TYPE-CD              TO S-RS4-REMARK-TYPE-CD  
           INSPECT EF-REMARK-TX-TEXT                                    
                   REPLACING ALL LOW-VALUES BY SPACES                   
           INSPECT FUNCTION REVERSE (EF-REMARK-TX-TEXT) TALLYING        
                   WS-SPACE-CNT FOR LEADING SPACES.                     
           COMPUTE WS-LENGTH = 210 - WS-SPACE-CNT.                      
           MOVE EF-REMARK-TX-TEXT(1:WS-LENGTH) TO S-RS4-REMARK-TX.      
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
                                                                        
           PERFORM 7210-FETCH-REMARKS-CSR      THRU 7210-EXIT.          
                                                                        
       2180-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      * 2200-BUILD-HST-SO-RESULT.                                      *        
      ******************************************************************        
       2200-BUILD-HST-SO-RESULT.                                        
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 2250-LOAD-RESULT-SET-1      THRU 2250-EXIT.          
           PERFORM 2260-LOAD-RESULT-SET-2      THRU 2260-EXIT.          
                                                                        
                                                                        
           IF YV-SERV-ORDER-NO NOT EQUAL WS-PREV-SERV-ORDER-NO          
              MOVE YV-SERV-ORDER-NO            TO ZG-SERV-ORDER-NO      
              MOVE WS-N                        TO WS-NO-MORE-INST-ROWS  
              PERFORM 7550-OPEN-HIST-INST-CSR  THRU 7550-EXIT           
              PERFORM 7560-FETCH-HIST-INST-CSR THRU 7560-EXIT           
              PERFORM 2270-LOAD-RESULT-SET-3   THRU 2270-EXIT           
                                               UNTIL NO-MORE-INST-ROWS  
              PERFORM 7570-CLOSE-HIST-INST-CSR THRU 7570-EXIT           
                                                                        
              MOVE WS-N                        TO WS-NO-MORE-RMRK-ROWS  
              MOVE YV-SERV-ORDER-NO            TO OE-SERV-ORDER-NO      
              PERFORM 7250-OPEN-HST-RMRKS-CSR  THRU 7250-EXIT           
              PERFORM 7260-FETCH-HST-RMRKS-CSR THRU 7260-EXIT           
              PERFORM 2280-LOAD-RESULT-SET-4   THRU 2280-EXIT           
                                               UNTIL NO-MORE-RMRK-ROWS  
              PERFORM 7270-CLOSE-HST-RMRKS-CSR THRU 7270-EXIT           
           END-IF.                                                      
           MOVE YV-SERV-ORDER-NO            TO WS-PREV-SERV-ORDER-NO.   
                                                                        
           PERFORM 7510-FETCH-HST-SO-DATA-CSR  THRU 7510-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-LOAD-RESULT-SET-1.                                        *        
      ******************************************************************        
       2250-LOAD-RESULT-SET-1.                                          
                                                                        
           MOVE '2250'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           MOVE SPACES                  TO DQ-FULL-NAME.                
           IF YV-ACCOUNT-NO > 0                                         
              MOVE YV-ACCOUNT-NO        TO HT-ACCOUNT-NO                
              PERFORM 7600-GET-NAME     THRU 7600-EXIT                  
           END-IF.                                                      
                                                                        
           MOVE YV-ACCOUNT-NO           TO S-RS1-ACCOUNT-NO             
           MOVE YV-SERV-ORDER-NO        TO S-RS1-SERV-ORDER-NO          
           MOVE DQ-FULL-NAME            TO S-RS1-FULL-NAME              
           MOVE ZG-CODE-UTIL-TYPE       TO S-RS1-CODE-UTIL-TYPE         
           MOVE YV-ORDER-TYPE-CD        TO S-RS1-ORDER-TYPE-CODE        
           MOVE ZG-WORK-TYPE-CD         TO S-RS1-WORK-TYPE-CODE         
           MOVE YV-ASSIGNED-DATETIME    TO S-RS1-ASSIGNED-DATETIME      
           MOVE YV-SERV-ORDER-STATUS    TO S-RS1-SERV-ORDER-STATUS      
           MOVE YV-ORDER-STATE-CD       TO S-RS1-ORDER-STATE-CODE       
           MOVE YV-COMPLETED-DATETIME   TO S-RS1-COMPLETED-DATETIME     
           MOVE R6-WORK-CLASS-ID        TO S-RS1-WORK-CLASS-ID          
           MOVE YV-BACK-DATED-IND       TO S-RS1-BACK-DATED-IND         
P0795B     MOVE YV-SOURCE-SYSTEM-CD     TO S-RS1-SOURCE-SYSTEM-CD       
P0795C     MOVE YV-ORDER-KEY            TO S-RS1-ORDER-KEY              
P0795E     MOVE YV-ORDER-REASON         TO S-RS1-ORDER-REASON           
                                                                        
           PERFORM 8010-INSERT-GTT-R1   THRU 8010-EXIT.                 
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2260-LOAD-RESULT-SET-2.                                        *        
      ******************************************************************        
       2260-LOAD-RESULT-SET-2.                                          
                                                                        
           MOVE '2260'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
           IF YV-SERV-ORDER-NO NOT EQUAL WS-PREV-SERV-ORDER-NO          
              MOVE YV-SERV-ORDER-NO           TO VW-SERV-ORDER-NO       
P00795        PERFORM 7630-GET-LAST-UPDT-BY   THRU 7630-EXIT            
              MOVE    VW-USER-ID-UPDT-BY       TO PF-USER-ID            
              PERFORM 7615-GET-RESP-AREA-ID    THRU 7615-EXIT           
P00795        MOVE WS-USER-NAME               TO S-RS2-UPDATE-BY-NAME   
              MOVE PF-RESP-AREA-ID             TO                       
                                               S-RS2-RESP-AREA-UPDT-BY  
              MOVE YV-ORDER-RECVED-BY          TO PF-USER-ID            
              PERFORM 7615-GET-RESP-AREA-ID    THRU 7615-EXIT           
P00795        MOVE WS-USER-NAME              TO S-RS2-ORDER-REC-BY-NAME 
              MOVE PF-RESP-AREA-ID             TO                       
                                               S-RS2-RESP-AREA-INIT-BY  
           END-IF.                                                      
                                                                        
           MOVE YV-SERV-ORDER-NO              TO VG-SERV-ORDER-NO.      
           MOVE ZG-CODE-UTIL-TYPE             TO VG-CODE-UTIL-TYPE.     
           PERFORM 7620-GET-SERV-CHARGE       THRU 7620-EXIT.           
                                                                        
           MOVE YV-ACCOUNT-NO                 TO S-RS2-ACCOUNT-NO       
           MOVE YV-SERV-ORDER-NO              TO S-RS2-SERV-ORDER-NO    
           MOVE ZG-CODE-UTIL-TYPE             TO S-RS2-CODE-UTIL-TYPE   
           MOVE YV-ORDER-RECVED-BY            TO S-RS2-ORDER-RECVED-BY  
           MOVE YV-DATE-RECVED                TO S-RS2-DATE-RECVED      
           MOVE VW-USER-ID-UPDT-BY            TO S-RS2-USER-ID-UPDT-BY  
           MOVE VW-UPDATE-DATETIME            TO S-RS2-UPDATE-DATETIME  
           MOVE YV-WORK-AREA-ID               TO S-RS2-WORK-AREA-ID     
           MOVE YV-ACCOUNT-NO-PRIOR           TO S-RS2-ACCOUNT-NO-PRIOR 
           MOVE VG-STD-LABOR-CHRG             TO S-RS2-STD-LABOR-CHRG   
                                                                        
           PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT.           
                                                                        
       2260-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 2270-LOAD-RESULT-SET-3.                                       *         
      ******************************************************************        
       2270-LOAD-RESULT-SET-3.                                          
                                                                        
           MOVE '2270'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE GTT-RETURN-FIELDS-3                               
                                                                        
           MOVE YV-ACCOUNT-NO                TO S-RS3-ACCOUNT-NO        
           MOVE ZG-SERV-ORDER-NO             TO S-RS3-SERV-ORDER-NO     
           MOVE VS-CODE-UTIL-TYPE            TO S-RS3-CODE-UTIL-TYPE    
           MOVE ZG-HOLD-RELEASE              TO S-RS3-HOLD-RELEASE      
           MOVE ZG-RLSE-NO                   TO S-RS3-RLSE-NO           
           MOVE ZG-RLSE-DATE                 TO S-RS3-RLSE-DATE         
           MOVE VS-LAST-READ-VALUE           TO S-RS3-LAST-READ-VALUE   
           MOVE VS-LAST-REG-READ-DATE        TO S-RS3-LAST-REG-READ-DATE
           MOVE VS-METER-SUPPLYING           TO S-RS3-METER-SUPPLYING   
           MOVE VS-METER-NO                  TO S-RS3-METER-NO          
           MOVE VS-IC-NO                     TO S-RS3-IC-NO             
           MOVE VS-MTR-REF-NO                TO S-RS3-MTR-REF-NO        
           MOVE VS-NO-DIALS                  TO S-RS3-NO-DIALS          
           IF VS-CODE-MTR-STATUS-IS > SPACES                            
              MOVE VS-CODE-MTR-STATUS-IS     TO S-RS3-CODE-MTR-STATUS   
           ELSE                                                         
              IF VS-CODE-MTR-STATUS-WS > SPACES                         
                 MOVE VS-CODE-MTR-STATUS-WS  TO S-RS3-CODE-MTR-STATUS   
              ELSE                                                      
                 MOVE VR-CODE-METER-STATUS   TO S-RS3-CODE-MTR-STATUS   
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8030-INSERT-GTT-R3        THRU 8030-EXIT             
                                                                        
           PERFORM 7560-FETCH-HIST-INST-CSR  THRU 7560-EXIT.            
                                                                        
       2270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2280-LOAD-RESULT-SET-4.                                       *         
      ******************************************************************        
       2280-LOAD-RESULT-SET-4.                                          
                                                                        
           MOVE '2280'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE GTT-RETURN-FIELDS-4.                              
           INITIALIZE WS-SPACE-CNT.                                     
           MOVE OE-SERV-ORDER-NO                TO S-RS4-SERV-ORDER-NO. 
           MOVE OE-REMARK-TYPE-CD               TO S-RS4-REMARK-TYPE-CD.
           INSPECT OE-REMARK-TX-TEXT                                    
                   REPLACING ALL LOW-VALUES BY SPACES                   
           INSPECT FUNCTION REVERSE (OE-REMARK-TX-TEXT) TALLYING        
                   WS-SPACE-CNT FOR LEADING SPACES.                     
           COMPUTE WS-LENGTH = 210 - WS-SPACE-CNT.                      
           MOVE OE-REMARK-TX-TEXT(1:WS-LENGTH ) TO S-RS4-REMARK-TX.     
           PERFORM 8040-INSERT-GTT-R4           THRU 8040-EXIT.         
                                                                        
           PERFORM 7260-FETCH-HST-RMRKS-CSR     THRU 7260-EXIT.         
                                                                        
       2280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-SO-DATA-CSR.                                         *        
      ******************************************************************        
       7000-OPEN-SO-DATA-CSR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN SO_DATA_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'SO_DATA_CURSOR'      TO TABLE-1                     
              MOVE 'PREMISE NO'          TO TABLE-ELEMENT-1             
              MOVE VO-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-FETCH-SO-DATA-CSR.                                        *        
      ******************************************************************        
       7010-FETCH-SO-DATA-CSR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH SO_DATA_CSR                                        
                INTO :VO-ACCOUNT-NO                                     
                    ,:VO-SERV-ORDER-NO                                  
                    ,:VO-ORDER-TYPE-CD                                  
                    ,:VO-ASSIGNED-DATETIME :WS-ASSIGN-DT-NULL            
                    ,:VO-SERV-ORDER-STATUS                              
                    ,:VO-ORDER-STATE-CD                                 
                    ,:VO-COMPLETED-DATETIME :WS-COMPLETE-DT-NULL         
                    ,:VO-ORDER-RECVED-BY                                
                    ,:VO-DATE-RECVED :WS-RECVED-DT-NULL                  
                    ,:VO-WORK-AREA-ID                                   
                    ,:VO-ACCOUNT-NO-PRIOR                               
                    ,:VO-RESP-AREA-ID                                   
                    ,:VO-BACK-DATED-IND                                 
P0795B              ,:VO-SOURCE-SYSTEM-CD                               
P0795C              ,:VO-ORDER-KEY                                      
P0795E              ,:VO-ORDER-REASON                                   
                    ,:VI-CODE-UTIL-TYPE                                 
                    ,:VI-WORK-TYPE-CD                                   
                    ,:VI-TASK-STATUS-CD                                 
                    ,:R6-WORK-CLASS-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-ASSIGN-DT-NULL < 0                            
                       MOVE SPACES TO VO-ASSIGNED-DATETIME              
                    END-IF                                              
                    IF WS-COMPLETE-DT-NULL < 0                          
                       MOVE SPACES TO VO-COMPLETED-DATETIME             
                    END-IF                                              
                    IF WS-RECVED-DT-NULL < 0                            
                       MOVE SPACES TO VO-DATE-RECVED                    
                    END-IF                                              
                    PERFORM 7800-CHECK-CLICK THRU 7800-EXIT             
               WHEN NOT-FOUND                                           
                    MOVE WS-Y               TO WS-NO-MORE-SO-ROWS       
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7010'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CURR_DATA_CUR'    TO TABLE-1                  
                    MOVE 'PREMISE NO'       TO TABLE-ELEMENT-1          
                    MOVE WS-PREMISE-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-CLOSE-SO-DATA-CSR.                                        *        
      ******************************************************************        
       7020-CLOSE-SO-DATA-CSR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE SO_DATA_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CURR_DATA_CUR'          TO TABLE-1                  
              MOVE 'PREMISE NO'             TO TABLE-ELEMENT-1          
              MOVE WS-PREMISE-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-OPEN-ORDER-INST-CSR.                                   *           
      ******************************************************************        
       7100-OPEN-ORDER-INST-CSR.                                        
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN SO_ORDER_INST_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ORDER_INST_CSR'      TO TABLE-1                     
              MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-FETCH-ORDER-INST-CSR.                                  *           
      ******************************************************************        
       7110-FETCH-ORDER-INST-CSR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH SO_ORDER_INST_CSR                                  
                INTO :VI-SERV-ORDER-NO                                  
                    ,:VI-HOLD-RELEASE                                   
                    ,:VI-RLSE-NO                                        
                    ,:VI-RLSE-DATE :WS-RLSE-DT-NULL                      
                    ,:VC-METER-NO                                       
                    ,:VC-CODE-UTIL-TYPE                                 
                    ,:VC-IC-NO                                          
                    ,:VC-MTR-REF-NO                                     
                    ,:VC-CODE-MTR-STATUS-IS                             
                    ,:VC-CODE-MTR-STATUS-WS                             
                    ,:VM-CODE-METER-STATUS                              
                    ,:VC-LAST-READ-VALUE                                
                    ,:VC-LAST-REG-READ-DATE                             
                    ,:VC-METER-SUPPLYING                                
                    ,:VC-NO-DIALS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-RLSE-DT-NULL < 0                              
                       MOVE SPACES TO VI-RLSE-DATE                      
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE WS-Y               TO WS-NO-MORE-INST-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7110'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'ORDER_INST_CSR'   TO TABLE-1                  
                    MOVE 'SERVICE ORDER NO' TO TABLE-ELEMENT-1          
                    MOVE VO-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7120-CLOSE-ORDER-INST-CSR.                                     *        
      ******************************************************************        
       7120-CLOSE-ORDER-INST-CSR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE SO_ORDER_INST_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'ORDER_INST_CSR'         TO TABLE-1                  
              MOVE 'SERVICE ORDER NO'       TO TABLE-ELEMENT-1          
              MOVE VO-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-OPEN-REMARKS-CSR.                                         *        
      ******************************************************************        
       7200-OPEN-REMARKS-CSR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN SO_REMARKS_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REMARKS_CSR'         TO TABLE-1                     
              MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
              MOVE EF-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7210-FETCH-REMARKS-CSR.                                     *           
      ******************************************************************        
       7210-FETCH-REMARKS-CSR.                                          
                                                                        
D11057     MOVE SPACES to EF-REMARK-TYPE-CD                             
D11057                    EF-REMARK-TX.                                 
                                                                        
           EXEC SQL                                                     
               FETCH SO_REMARKS_CSR                                     
                INTO :EF-SERV-ORDER-NO                                  
                    ,:EF-REMARK-TYPE-CD                                 
                    ,:EF-REMARK-TX                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-Y               TO WS-NO-MORE-RMRK-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7210'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'SO_REMARKS_CSR'   TO TABLE-1                  
                    MOVE 'SERVICE ORDER NO' TO TABLE-ELEMENT-1          
                    MOVE EF-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7220-CLOSE-REMARKS-CSR.                                        *        
      ******************************************************************        
       7220-CLOSE-REMARKS-CSR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE SO_REMARKS_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SO_REMARKS_CSR'         TO TABLE-1                  
              MOVE 'SERVICE ORDER NO'       TO TABLE-ELEMENT-1          
              MOVE EF-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7250-OPEN-HST-RMRKS-CSR.                                       *        
      ******************************************************************        
       7250-OPEN-HST-RMRKS-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN SO_HST_REMARKS_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'HST_REMARKS_CSR'     TO TABLE-1                     
              MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
              MOVE EF-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7260-FETCH-HST-RMRKS-CSR.                                      *        
      ******************************************************************        
       7260-FETCH-HST-RMRKS-CSR.                                        
                                                                        
D11057     MOVE SPACES TO OE-REMARK-TYPE-CD                             
D11057                    OE-REMARK-TX.                                 
           EXEC SQL                                                     
               FETCH SO_HST_REMARKS_CSR                                 
                INTO :OE-SERV-ORDER-NO                                  
                    ,:OE-REMARK-TYPE-CD                                 
                    ,:OE-REMARK-TX                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-Y               TO WS-NO-MORE-RMRK-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7260'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'SO_HST_REMARKS_CSR'   TO TABLE-1              
                    MOVE 'SERVICE ORDER NO' TO TABLE-ELEMENT-1          
                    MOVE EF-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7270-CLOSE-HST-RMRKS-CSR.                                      *        
      ******************************************************************        
       7270-CLOSE-HST-RMRKS-CSR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE SO_HST_REMARKS_CSR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7270'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SO_HST_REMARKS_CSR'     TO TABLE-1                  
              MOVE 'SERVICE ORDER NO'       TO TABLE-ELEMENT-1          
              MOVE EF-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-OPEN-HST-SO-DATA-CSR.                                     *        
      ******************************************************************        
       7500-OPEN-HST-SO-DATA-CSR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN HST_SO_DATA_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'HST_SO_DATA'         TO TABLE-1                     
              MOVE 'PREMISE NO'          TO TABLE-ELEMENT-1             
              MOVE YV-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7510-FETCH-HST-SO-DATA-CSR.                                    *        
      ******************************************************************        
       7510-FETCH-HST-SO-DATA-CSR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH HST_SO_DATA_CSR                                    
                INTO :YV-ACCOUNT-NO                                     
                    ,:YV-SERV-ORDER-NO                                  
                    ,:YV-ORDER-TYPE-CD                                  
                    ,:YV-ASSIGNED-DATETIME :WS-ASSIGN-DT-NULL            
                    ,:YV-SERV-ORDER-STATUS                              
                    ,:YV-ORDER-STATE-CD                                 
                    ,:YV-COMPLETED-DATETIME :WS-COMPLETE-DT-NULL         
                    ,:YV-ORDER-RECVED-BY                                
                    ,:YV-DATE-RECVED :WS-RECVED-DT-NULL                  
                    ,:YV-WORK-AREA-ID                                   
                    ,:YV-ACCOUNT-NO-PRIOR                               
                    ,:YV-RESP-AREA-ID                                   
                    ,:YV-BACK-DATED-IND                                 
P0795B              ,:YV-SOURCE-SYSTEM-CD                               
P0795C              ,:YV-ORDER-KEY                                      
P0795E              ,:YV-ORDER-REASON                                   
                    ,:ZG-CODE-UTIL-TYPE                                 
                    ,:ZG-WORK-TYPE-CD                                   
                    ,:ZG-TASK-STATUS-CD                                 
                    ,:R6-WORK-CLASS-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-ASSIGN-DT-NULL < 0                            
                       MOVE SPACES TO YV-ASSIGNED-DATETIME              
                    END-IF                                              
                    IF WS-COMPLETE-DT-NULL < 0                          
                       MOVE SPACES TO YV-COMPLETED-DATETIME             
                    END-IF                                              
                    IF WS-RECVED-DT-NULL < 0                            
                       MOVE SPACES TO YV-DATE-RECVED                    
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE WS-Y               TO WS-NO-MORE-HST-ROWS      
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7510'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'HST_SO_DATA_CSR'  TO TABLE-1                  
                    MOVE 'PREMISE NO'       TO TABLE-ELEMENT-1          
                    MOVE YV-PREMISE-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7520-CLOSE-HST-SO-DATA-CSR.                                    *        
      ******************************************************************        
       7520-CLOSE-HST-SO-DATA-CSR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE HST_SO_DATA_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'HST_SO_DATA_CSR'        TO TABLE-1                  
              MOVE 'PREMISE NO'             TO TABLE-ELEMENT-1          
              MOVE YV-PREMISE-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7550-OPEN-HIST-INST-CSR.                                       *        
      ******************************************************************        
       7550-OPEN-HIST-INST-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN HST_SO_DATA_INST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7550'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'HST_SO_DATA_INST'    TO TABLE-1                     
              MOVE 'SERVICE ORDER NO'    TO TABLE-ELEMENT-1             
              MOVE ZG-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7560-FETCH-HIST-INST-CSR.                                      *        
      ******************************************************************        
       7560-FETCH-HIST-INST-CSR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH HST_SO_DATA_INST                                   
                INTO :ZG-SERV-ORDER-NO                                  
                    ,:ZG-HOLD-RELEASE                                   
                    ,:ZG-RLSE-NO                                        
                    ,:ZG-RLSE-DATE :WS-RLSE-DT-NULL                      
                    ,:VS-METER-NO                                       
                    ,:VS-CODE-UTIL-TYPE                                 
                    ,:VS-IC-NO                                          
                    ,:VS-MTR-REF-NO                                     
                    ,:VS-CODE-MTR-STATUS-IS                             
                    ,:VS-CODE-MTR-STATUS-WS                             
                    ,:VR-CODE-METER-STATUS                              
                    ,:VS-LAST-READ-VALUE                                
                    ,:VS-LAST-REG-READ-DATE                             
                    ,:VS-METER-SUPPLYING                                
                    ,:VS-NO-DIALS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF  WS-RLSE-DT-NULL < 0                             
                        MOVE SPACES TO ZG-RLSE-DATE                     
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE WS-Y               TO WS-NO-MORE-INST-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7560'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'HST_SO_DATA_INST' TO TABLE-1                  
                    MOVE 'SERVICE ORDER NO' TO TABLE-ELEMENT-1          
                    MOVE ZG-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7570-CLOSE-HIST-INST-CSR.                                      *        
      ******************************************************************        
       7570-CLOSE-HIST-INST-CSR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE HST_SO_DATA_INST                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7570'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'HST_SO_DATA_INST'       TO TABLE-1                  
              MOVE 'SERVICE ORDER NO'       TO TABLE-ELEMENT-1          
              MOVE ZG-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-NAME.                                                 *        
      ******************************************************************        
       7600-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
             SELECT CASE DQ.NAME_FORMAT                                 
                    WHEN 'I' THEN RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + CIS.SUBSTR3(DQ.MIDDLE_NAME, 1, 1)            
                    WHEN 'B' THEN DQ.FULL_NAME                          
                    END                                                 
                    INTO :DQ-FULL-NAME                                  
               FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),                
                    CSS_NAME DQ WITH(READUNCOMMITTED)                           
              WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                      
                AND HT.NAME_ID = DQ.NAME_ID                             
                AND HT.CUSTOMER_ROLE_CD = ' '                           
                AND DQ.NAME_TYPE = 'CN'                                 
                AND DQ.NAME_FORMAT IN ('I','B')                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CASE DQ.NAME_FORMAT                                         
MFA-TR*             WHEN 'I' THEN RTRIM(DQ.LAST_NAME) || ', ' ||                
MFA-TR*                      RTRIM(DQ.FIRST_NAME)  || ' ' ||                    
MFA-TR*                      SUBSTR(DQ.MIDDLE_NAME, 1, 1)                       
MFA-TR*             WHEN 'B' THEN DQ.FULL_NAME                                  
MFA-TR*             END                                                         
MFA-TR*             INTO :DQ-FULL-NAME                                          
MFA-TR*        FROM CSS_NAME_ACCT_XREF HT,                                      
MFA-TR*             CSS_NAME DQ                                                 
MFA-TR*       WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                              
MFA-TR*         AND HT.NAME_ID = DQ.NAME_ID                                     
MFA-TR*         AND HT.CUSTOMER_ROLE_CD = ' '                                   
MFA-TR*         AND DQ.NAME_TYPE = 'CN'                                         
MFA-TR*         AND DQ.NAME_FORMAT IN ('I','B')                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7600                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES                TO DQ-FULL-NAME          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7600'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7610-GET-LAST-UPDT-BY.                                         *        
      ******************************************************************        
       7610-GET-LAST-UPDT-BY.                                           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           VW.UPDATE_DATETIME, 121), ' ', '-'), ':', '.') 
           UPDATE_DATETIME,
              VW.USER_ID_UPDT_BY                                  
               INTO :VW-UPDATE-DATETIME                                 
                   ,:VW-USER-ID-UPDT-BY                                 
               FROM CSS_SO_UPDATE  VW WITH(READUNCOMMITTED)                     
              WHERE VW.SERV_ORDER_NO  = :VW-SERV-ORDER-NO               
              ORDER BY UPDATE_DATETIME DESC                          
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT VW.UPDATE_DATETIME                                          
MFA-TR*            ,VW.USER_ID_UPDT_BY                                          
MFA-TR*        INTO :VW-UPDATE-DATETIME                                         
MFA-TR*            ,:VW-USER-ID-UPDT-BY                                         
MFA-TR*        FROM CSS_SO_UPDATE  VW                                           
MFA-TR*       WHERE VW.SERV_ORDER_NO  = :VW-SERV-ORDER-NO                       
MFA-TR*       ORDER BY VW.UPDATE_DATETIME DESC                                  
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7610                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES              TO VW-UPDATE-DATETIME      
                    MOVE SPACES              TO VW-USER-ID-UPDT-BY      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7610'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CSS_SO_UPDATE'        TO TABLE-1              
                    MOVE 'SERV-ORDER-NO'        TO TABLE-ELEMENT-1      
                    MOVE VW-SERV-ORDER-NO       TO HOSTVAR-ELEMENT-1    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7615-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
       7615-GET-RESP-AREA-ID.                                           
                                                                        
           EXEC SQL                                                     
             SELECT PF.RESP_AREA_ID,                                    
                    RTRIM(PF.FIRST_NAME) + ' ' + RTRIM(PF.LAST_NAME)            
               INTO :PF-RESP-AREA-ID,                                   
                    :WS-USER-NAME                                       
               FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                   
              WHERE PF.USER_ID        = :PF-USER-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PF.RESP_AREA_ID,                                            
MFA-TR*             RTRIM(PF.FIRST_NAME) || ' ' ||                              
MFA-TR*             RTRIM(PF.LAST_NAME)                                         
MFA-TR*        INTO :PF-RESP-AREA-ID,                                           
MFA-TR*             :WS-USER-NAME                                               
MFA-TR*        FROM CSS_USER_PROFILE PF                                         
MFA-TR*       WHERE PF.USER_ID        = :PF-USER-ID                             
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7615                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES                TO PF-RESP-AREA-ID       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7615'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
                    MOVE 'CSS_USER_PROFILE'    TO TABLE-1               
                    MOVE 'USER_ID_UPDT_BY'     TO TABLE-ELEMENT-1       
                    MOVE VW-USER-ID-UPDT-BY    TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7615-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7620-GET-SERV-CHARGE.                                          *        
      ******************************************************************        
       7620-GET-SERV-CHARGE.                                            
                                                                        
           EXEC SQL                                                     
             SELECT VG.STD_LABOR_CHRG                                   
               INTO :VG-STD-LABOR-CHRG                                  
               FROM CSS_SO_CHARGES VG WITH(READUNCOMMITTED)                     
              WHERE VG.SERV_ORDER_NO  = :VG-SERV-ORDER-NO               
                AND VG.CODE_UTIL_TYPE = :VG-CODE-UTIL-TYPE              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT VG.STD_LABOR_CHRG                                           
MFA-TR*        INTO :VG-STD-LABOR-CHRG                                          
MFA-TR*        FROM CSS_SO_CHARGES VG                                           
MFA-TR*       WHERE VG.SERV_ORDER_NO  = :VG-SERV-ORDER-NO                       
MFA-TR*         AND VG.CODE_UTIL_TYPE = :VG-CODE-UTIL-TYPE                      
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7620                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROS                  TO VG-STD-LABOR-CHRG    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7620'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CSS_SO_CHARGES'       TO TABLE-1              
                    MOVE 'SERV-ORDER-NO'        TO TABLE-ELEMENT-1      
                    MOVE 'CODE_UITL_TYPE'       TO TABLE-ELEMENT-2      
                    MOVE VG-SERV-ORDER-NO       TO HOSTVAR-ELEMENT-1    
                    MOVE VG-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795******************************************************************        
P00795* 7630-GET-LAST-UPDT-BY.                                         *        
P00795******************************************************************        
P00795 7630-GET-LAST-UPDT-BY.                                           
P00795                                                                  
P00795     EXEC SQL                                                     
P00795       SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           OK.UPDATE_DATETIME, 121), ' ', '-'), ':', '.') 
           UPDATE_DATETIME,
              OK.USER_ID_UPDT_BY                                  
P00795         INTO :VW-UPDATE-DATETIME                                 
P00795             ,:VW-USER-ID-UPDT-BY                                 
P00795         FROM HST_SO_UPDATE  OK WITH(READUNCOMMITTED)                     
P00795        WHERE OK.SERV_ORDER_NO  = :VW-SERV-ORDER-NO               
P00795        ORDER BY UPDATE_DATETIME DESC                          
P00795                                              
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT OK.UPDATE_DATETIME                                          
MFA-TR*            ,OK.USER_ID_UPDT_BY                                          
MFA-TR*        INTO :VW-UPDATE-DATETIME                                         
MFA-TR*            ,:VW-USER-ID-UPDT-BY                                         
MFA-TR*        FROM HST_SO_UPDATE  OK                                           
MFA-TR*       WHERE OK.SERV_ORDER_NO  = :VW-SERV-ORDER-NO                       
MFA-TR*       ORDER BY OK.UPDATE_DATETIME DESC                                  
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*     QUERYNO 7630                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00795                                                                  
P00795     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00795         WHEN SUCCESSFUL-CALL                                     
P00795              CONTINUE                                            
P00795         WHEN NOT-FOUND                                           
P00795              MOVE SPACES              TO VW-UPDATE-DATETIME      
P00795              MOVE SPACES              TO VW-USER-ID-UPDT-BY      
P00795         WHEN OTHER                                               
P00795              MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
P00795              MOVE '7630'                 TO ACTIVE-PARAGRAPH     
P00795              MOVE 'SELECT'               TO ABEND-FUNCTION       
P00795              MOVE SPACES                 TO ABEND-SQL-PREDICATES 
P00795                                             ABEND-TABLES         
P00795              MOVE 'HST_SO_UPDATE'        TO TABLE-1              
P00795              MOVE 'SERV-ORDER-NO'        TO TABLE-ELEMENT-1      
P00795              MOVE VW-SERV-ORDER-NO       TO HOSTVAR-ELEMENT-1    
P00795              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P00795     END-EVALUATE.                                                
P00795                                                                  
P00795 7630-EXIT.                                                       
P00795      EXIT.                                                       
                                                                        
P0795D******************************************************************        
P0795D* 7700-GET-PREMISE-INFO.                                         *        
P0795D******************************************************************        
P0795D 7700-GET-PREMISE-INFO.                                           
P0795D                                                                  
P0795D     EXEC SQL                                                     
P0795D       SELECT TOP(1) PR.CODE_RENTAL_PROP                                 
P0795D         INTO :PR-CODE-RENTAL-PROP                                
P0795D         FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                        
P0795D        WHERE PR.PREMISE_NO = :PR-PREMISE-NO                      
P0795D                                              
P0795D                                                           
P0795D                                                      
P0795D     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PR.CODE_RENTAL_PROP                                         
MFA-TR*        INTO :PR-CODE-RENTAL-PROP                                        
MFA-TR*        FROM CSS_PREMISE PR                                              
MFA-TR*       WHERE PR.PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*     QUERYNO 7700                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795D                                                                  
P0795D     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P0795D                                                                  
P0795D     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795D         WHEN SUCCESSFUL-CALL                                     
P0795D              CONTINUE                                            
P0795D         WHEN NOT-FOUND                                           
P0795D              MOVE SPACES                 TO PR-CODE-RENTAL-PROP  
P0795D         WHEN OTHER                                               
P0795D              MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
P0795D              MOVE '7700'                 TO ACTIVE-PARAGRAPH     
P0795D              MOVE 'SELECT'               TO ABEND-FUNCTION       
P0795D              MOVE SPACES                 TO ABEND-SQL-PREDICATES 
P0795D                                             ABEND-TABLES         
P0795D              MOVE 'CSS_PREMISE'          TO TABLE-1              
P0795D              MOVE 'PREMISE-NO'           TO TABLE-ELEMENT-1      
P0795D              MOVE PR-PREMISE-NO          TO HOSTVAR-ELEMENT-1    
P0795D              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P0795D     END-EVALUATE.                                                
P0795D                                                                  
P0795D 7700-EXIT.                                                       
P0795D      EXIT.                                                       
                                                                        
      ******************************************************************        
d10004* CALL CSR04747 - CHECK IF CLICK ORDER- RETURNS WORK DISTRICT *   08064003
      ******************************************************************        
       7800-CHECK-CLICK.                                                
                                                                        
           MOVE vo-SERV-ORDER-NO TO  SERV-ORDER-NO-4747.                
           MOVE '1'                TO  PRIORITY-4747.                   
           MOVE 'S'                TO  ACTION-CD-4747                   
           MOVE SPACES             TO  USER-ID-4747                     
           MOVE SPACES             TO  WORK-DISTRICT-IN-4747.           
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :SERV-ORDER-NO-4747                             
      *                ,:PRIORITY-4747                                  
      *                ,:ACTION-CD-4747                                 
      *                ,:USER-ID-4747                                   
      *                ,:WORK-DISTRICT-IN-4747)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK CLICK'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4747)                                                
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747 CURSOR FOR RESULT SET            
      *       :LOC4747                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747 INTO                                
                 :RETURN-CODE-4747,                                     
                 :WORK-DISTRICT-OUT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7800'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04744_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04744_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04744_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04744_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04744_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04744_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04744_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04744_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04744_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04744_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04744_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04744_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   PENDING & COMPLETED                      *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04744_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,SERV_ORDER_NO                                        
                  ,FULL_NAME                                            
                  ,CODE_UTIL_TYPE                                       
                  ,ORDER_TYPE_CODE                                      
                  ,WORK_TYPE_CODE                                       
                  ,ASSIGNED_DATETIME                                    
                  ,SERV_ORDER_STATUS                                    
                  ,ORDER_STATE_CODE                                     
                  ,COMPLETED_DATETIME                                   
                  ,WORK_CLASS_ID                                        
                  ,BACK_DATED_IND                                       
P0795B            ,SOURCE_SYSTEM_CD                                     
P0795C            ,ORDER_KEY                                            
P0795D            ,CODE_RENTAL_PROP                                     
P0795E            ,ORDER_REASON                                         
P0795E            ,IS_CLICK_ORDER                                       
P0795E            ,TASK_STATUS_CD                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-RS1-ACCOUNT-NO                                    
                  ,:S-RS1-SERV-ORDER-NO                                 
                  ,:S-RS1-FULL-NAME                                     
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-ORDER-TYPE-CODE                               
                  ,:S-RS1-WORK-TYPE-CODE                                
                  ,:S-RS1-ASSIGNED-DATETIME                             
                  ,:S-RS1-SERV-ORDER-STATUS                             
                  ,:S-RS1-ORDER-STATE-CODE                              
                  ,:S-RS1-COMPLETED-DATETIME                            
                  ,:S-RS1-WORK-CLASS-ID                                 
                  ,:S-RS1-BACK-DATED-IND                                
P0795B            ,:S-RS1-SOURCE-SYSTEM-CD                              
P0795C            ,:S-RS1-ORDER-KEY                                     
P0795D            ,:S-RS1-CODE-RENTAL-PROP                              
P0795E            ,:S-RS1-ORDER-REASON                                  
D10004            ,:S-RS1-IS-CLICK-ORDER                                
D10004            ,:S-RS1-TASK-STATUS-CODE                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04744_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,SERV_ORDER_NO                                                
MFA-TR*           ,FULL_NAME                                                    
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,ORDER_TYPE_CODE                                              
MFA-TR*           ,WORK_TYPE_CODE                                               
MFA-TR*           ,ASSIGNED_DATETIME                                            
MFA-TR*           ,SERV_ORDER_STATUS                                            
MFA-TR*           ,ORDER_STATE_CODE                                             
MFA-TR*           ,COMPLETED_DATETIME                                           
MFA-TR*           ,WORK_CLASS_ID                                                
MFA-TR*           ,BACK_DATED_IND                                               
MFA-TR*           ,SOURCE_SYSTEM_CD                                             
MFA-TR*           ,ORDER_KEY                                                    
MFA-TR*           ,CODE_RENTAL_PROP                                             
MFA-TR*           ,ORDER_REASON                                                 
MFA-TR*           ,IS_CLICK_ORDER                                               
MFA-TR*           ,TASK_STATUS_CD                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-RS1-ACCOUNT-NO                                            
MFA-TR*           ,:S-RS1-SERV-ORDER-NO                                         
MFA-TR*           ,:S-RS1-FULL-NAME                                             
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS1-ORDER-TYPE-CODE                                       
MFA-TR*           ,:S-RS1-WORK-TYPE-CODE                                        
MFA-TR*           ,:S-RS1-ASSIGNED-DATETIME                                     
MFA-TR*           ,:S-RS1-SERV-ORDER-STATUS                                     
MFA-TR*           ,:S-RS1-ORDER-STATE-CODE                                      
MFA-TR*           ,:S-RS1-COMPLETED-DATETIME                                    
MFA-TR*           ,:S-RS1-WORK-CLASS-ID                                         
MFA-TR*           ,:S-RS1-BACK-DATED-IND                                        
MFA-TR*           ,:S-RS1-SOURCE-SYSTEM-CD                                      
MFA-TR*           ,:S-RS1-ORDER-KEY                                             
MFA-TR*           ,:S-RS1-CODE-RENTAL-PROP                                      
MFA-TR*           ,:S-RS1-ORDER-REASON                                          
MFA-TR*           ,:S-RS1-IS-CLICK-ORDER                                        
MFA-TR*           ,:S-RS1-TASK-STATUS-CODE                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04744_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04744_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,ACCOUNT_NO                                         
                    ,SERV_ORDER_NO                                      
                    ,CODE_UTIL_TYPE                                     
                    ,ORDER_RECEIVED_BY                                  
                    ,ORDER_REC_BY_NAME                                  
                    ,INITIATED_ON                                       
                    ,LAST_UPDATED_BY                                    
                    ,LAST_UPDATE_BY_NAME                                
                    ,LAST_UPDATED_ON                                    
                    ,WORK_AREA_ID                                       
                    ,ACCOUNT_NO_PRIOR                                   
                    ,SERVICE_CHARGE                                     
                    ,RESP_AREA_ID_INIT_BY                               
                    ,RESP_AREA_ID_UPDT_BY                               
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-RS2-ACCOUNT-NO                                    
                  ,:S-RS2-SERV-ORDER-NO                                 
                  ,:S-RS2-CODE-UTIL-TYPE                                
                  ,:S-RS2-ORDER-RECVED-BY                               
                  ,:S-RS2-ORDER-REC-BY-NAME                             
                  ,:S-RS2-DATE-RECVED                                   
                  ,:S-RS2-USER-ID-UPDT-BY                               
                  ,:S-RS2-UPDATE-BY-NAME                                
                  ,:S-RS2-UPDATE-DATETIME                               
                  ,:S-RS2-WORK-AREA-ID                                  
                  ,:S-RS2-ACCOUNT-NO-PRIOR                              
                  ,:S-RS2-STD-LABOR-CHRG                                
                  ,:S-RS2-RESP-AREA-INIT-BY                             
                  ,:S-RS2-RESP-AREA-UPDT-BY                             
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04744_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,SERV_ORDER_NO                                              
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,ORDER_RECEIVED_BY                                          
MFA-TR*             ,ORDER_REC_BY_NAME                                          
MFA-TR*             ,INITIATED_ON                                               
MFA-TR*             ,LAST_UPDATED_BY                                            
MFA-TR*             ,LAST_UPDATE_BY_NAME                                        
MFA-TR*             ,LAST_UPDATED_ON                                            
MFA-TR*             ,WORK_AREA_ID                                               
MFA-TR*             ,ACCOUNT_NO_PRIOR                                           
MFA-TR*             ,SERVICE_CHARGE                                             
MFA-TR*             ,RESP_AREA_ID_INIT_BY                                       
MFA-TR*             ,RESP_AREA_ID_UPDT_BY                                       
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-RS2-ACCOUNT-NO                                            
MFA-TR*           ,:S-RS2-SERV-ORDER-NO                                         
MFA-TR*           ,:S-RS2-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS2-ORDER-RECVED-BY                                       
MFA-TR*           ,:S-RS2-ORDER-REC-BY-NAME                                     
MFA-TR*           ,:S-RS2-DATE-RECVED                                           
MFA-TR*           ,:S-RS2-USER-ID-UPDT-BY                                       
MFA-TR*           ,:S-RS2-UPDATE-BY-NAME                                        
MFA-TR*           ,:S-RS2-UPDATE-DATETIME                                       
MFA-TR*           ,:S-RS2-WORK-AREA-ID                                          
MFA-TR*           ,:S-RS2-ACCOUNT-NO-PRIOR                                      
MFA-TR*           ,:S-RS2-STD-LABOR-CHRG                                        
MFA-TR*           ,:S-RS2-RESP-AREA-INIT-BY                                     
MFA-TR*           ,:S-RS2-RESP-AREA-UPDT-BY                                     
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04744_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04744_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,SERV_ORDER_NO                                        
                  ,CODE_UTIL_TYPE                                       
                  ,HOLD_RELEASE                                         
                  ,RLSE_NO                                              
                  ,RLSE_DATE                                            
                  ,METER_NO                                             
                  ,CODE_MTR_STATUS                                      
                  ,LAST_READ_VALUE                                      
                  ,LAST_REG_READ_DATE                                   
                  ,METER_SUPPLYING                                      
                  ,IC_NO                                                
                  ,MTR_REF_NO                                           
                  ,NO_DIALS                                             
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-RS3-ACCOUNT-NO                                    
                  ,:S-RS3-SERV-ORDER-NO                                 
                  ,:S-RS3-CODE-UTIL-TYPE                                
                  ,:S-RS3-HOLD-RELEASE                                  
                  ,:S-RS3-RLSE-NO                                       
                  ,:S-RS3-RLSE-DATE                                     
                  ,:S-RS3-METER-NO                                      
                  ,:S-RS3-CODE-MTR-STATUS                               
                  ,:S-RS3-LAST-READ-VALUE                               
                  ,:S-RS3-LAST-REG-READ-DATE                            
                  ,:S-RS3-METER-SUPPLYING                               
                  ,:S-RS3-IC-NO                                         
                  ,:S-RS3-MTR-REF-NO                                    
                  ,:S-RS3-NO-DIALS                                      
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04744_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,SERV_ORDER_NO                                                
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,HOLD_RELEASE                                                 
MFA-TR*           ,RLSE_NO                                                      
MFA-TR*           ,RLSE_DATE                                                    
MFA-TR*           ,METER_NO                                                     
MFA-TR*           ,CODE_MTR_STATUS                                              
MFA-TR*           ,LAST_READ_VALUE                                              
MFA-TR*           ,LAST_REG_READ_DATE                                           
MFA-TR*           ,METER_SUPPLYING                                              
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,MTR_REF_NO                                                   
MFA-TR*           ,NO_DIALS                                                     
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-RS3-ACCOUNT-NO                                            
MFA-TR*           ,:S-RS3-SERV-ORDER-NO                                         
MFA-TR*           ,:S-RS3-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS3-HOLD-RELEASE                                          
MFA-TR*           ,:S-RS3-RLSE-NO                                               
MFA-TR*           ,:S-RS3-RLSE-DATE                                             
MFA-TR*           ,:S-RS3-METER-NO                                              
MFA-TR*           ,:S-RS3-CODE-MTR-STATUS                                       
MFA-TR*           ,:S-RS3-LAST-READ-VALUE                                       
MFA-TR*           ,:S-RS3-LAST-REG-READ-DATE                                    
MFA-TR*           ,:S-RS3-METER-SUPPLYING                                       
MFA-TR*           ,:S-RS3-IC-NO                                                 
MFA-TR*           ,:S-RS3-MTR-REF-NO                                            
MFA-TR*           ,:S-RS3-NO-DIALS                                              
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04744_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8040-INSERT-GTT-R4.                                            *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04744_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,SERV_ORDER_NO                                        
                  ,REMARK_TYPE_CD                                       
                  ,REMARK_TX                                            
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-RS4-SERV-ORDER-NO                                 
                  ,:S-RS4-REMARK-TYPE-CD                                
                  ,:S-RS4-REMARK-TX                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04744_R4                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,SERV_ORDER_NO                                                
MFA-TR*           ,REMARK_TYPE_CD                                               
MFA-TR*           ,REMARK_TX                                                    
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-4                                             
MFA-TR*           ,:S-RS4-SERV-ORDER-NO                                         
MFA-TR*           ,:S-RS4-REMARK-TYPE-CD                                        
MFA-TR*           ,:S-RS4-REMARK-TX                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R4 = WS-Y            
              ADD +1                     TO  CTR-ROWS-RS4               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-Y                  TO  WS-ERR-INSRT-R4            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04744_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8040-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   100                     TO S-RETURN-CODE-1         
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   100                     TO S-RETURN-CODE-2         
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   100                     TO S-RETURN-CODE-3         
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE   100                     TO S-RETURN-CODE-4         
              PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04744_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04744_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04744_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04744_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
                                               S-RETURN-CODE-4.         
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
