       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR04727.                                        
       AUTHOR.         AMIRTHARAJ                                       
       DATE-WRITTEN.   OCT 2014.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      *****************************************************************         
      **                STORED PROCEDURE:  CSR04727                  **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      **  THIS PROGRAM USED  INSERT DATA IN CSS_SPCL_BILL_MSG        **         
      **  AND CSS_COMM_DATA TABLE FOR STATEMENT REQUEST PROJECT      **         
      **  BASED ON CONDITION.                                        **         
      **                                                             **         
      **  PARAMETERS                                                 **         
      **                                                             **         
      **      INPUT                                                  **         
      **       ACCOUNT NO           DECIMAL(13)                      **         
      **       USER ID              CHAR(07)                         **         
      **       INS_IND              CHAR(01)                         **         
      **       STMNT_OPT            CHAR(05)                         **         
      **                                                             **         
      **      OUT                                                    **         
      **            NONE                                             **         
      **                                                             **         
      **      INOUT                                                  **         
      **            NONE                                             **         
      **                                                             **         
      **      RESULT SET 1                                           **         
      **       RETURN_CODE_1        INTEGER                          **         
      **       ACCT_CREATE_DT       CHAR(10)                         **         
      **       LAST_BILL_DT         CHAR(10)                         **         
      **       EXIST_STMT_OPT       CHAR(05)                         **         
      **       ACCT_BILLS_COUNT     INTEGER                          **         
      **                                                             **         
      **      RESULT SET 2                                           **         
      **       RETURN_CODE_2         INTEGER                         **         
      **       APPL_RETURN_CODE      INTEGER                         **         
      **       BUS_RULE_ID           CHAR(10)                        **         
      **       ACTION_TYPE_CD        CHAR(08)                        **         
      **       MESSAGE_PARM          CHAR(26)                        **         
      **       BUS_RULE_XREF_ID      CHAR(26)                        **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      **                                                              *         
      **              PROGRAM MODIFICATION LOG                        *         
      ** DATE        INITIALS     REASON                              *         
      ** --------    ---------    ----------------------------------- *         
      ** 10OCT2014   AD7F921      INITIAL VERSION.                    *         
P00836** 19FEB2016   VK7L032      FIXED 305 SQL ERROR WHEN CREATE     *         
ACT039** 11AUG2016   AK7T405      TO GET LATEST DPP BILL STATEMENT    *         
ACT040** 12AUG2016   AK7T405      TO LOOK 3 YEARS FOR BBP FROM THE    *         
ACT040**                          PAYMENT START DATE                  *         
ACT043** 26AUG2016   MS7M727      TO DISPLAY RESULT SET1 VALUE FOR    *         
ACT043**                          BCNSMPT028                          *         
      *****************************************************************         
      *                                                               *         
      *         -----    BASIC SEQUENCE STRUCTURE   -----             *         
      * 0000         MODULE CONTROL                                   *         
      * 0100 - 0999  INITIALIZATION                                   *         
      * 1000 - 1999  FUNCTIONAL CONTROL                               *         
      * 2000 - 4999  DETAIL LOGIC                                     *         
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               *         
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     *         
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    *         
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    *         
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04727'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1           PIC X(01) VALUE 'N'.           
           05  WS-ERR-INSRT-R2           PIC X(01) VALUE 'N'.           
                                                                        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-ALREADY-EXIST          PIC S9(9) COMP VALUE -803.     
           05  WS-FAILED                 PIC X(01) VALUE 'F'.           
      *                                                                         
       01  WS-CONSTANTS.                                                
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
      *                                                                         
       01  WS-WORKING-VARIABLES.                                        
           05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR04727'.    
P00836     05  WS-NULL-IND             PIC S9(04) COMP  VALUE +0.       
           05  WS-ACCOUNT-NO           PIC S9(13)  COMP-3 VALUE ZERO.   
           05  WS-STMNT-OPT            PIC X(05)   VALUE SPACES.        
           05  WS-CURR-REV-MONTH       PIC X(06)   VALUE SPACES.        
           05  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.        
           05  WS-CURRENT-TIMESTMP     PIC X(26)   VALUE SPACES.        
           05  WS-TRAN-APPL-NO         PIC S9(02)  VALUE +1.            
           05  WS-CODE-DFA-TYPE        PIC X(01)   VALUE SPACES.        
           05  WS-TOU-FLAG             PIC X(01)   VALUE 'N'.           
           05  WS-DFA-TAB-FLAG         PIC X(01)   VALUE 'N'.           
           05  WS-BBP-FLAG             PIC X(01)   VALUE 'N'.           
           05  WS-INS-FLAG             PIC X(01)   VALUE 'N'.           
           05  WS-BILL-MSG-FLAG        PIC X(01)   VALUE 'N'.           
           05  WS-CONTRACT-FLAG        PIC X(01)   VALUE 'N'.           
           05  WS-SECURE-RATE-FLAG     PIC X(01)   VALUE 'N'.           
           05  WS-PREPAY-FLAG          PIC X(01)   VALUE 'N'.           
           05  WS-TOU-SEC-FL           PIC X(01)   VALUE 'N'.           
           05  WS-MASTER-SUB-FLAG      PIC X(01)   VALUE 'N'.           
           05  WS-RED-FL-NULL-IND      PIC S9(4) COMP VALUE 0.          
           05  WS-END-NULL-IND         PIC S9(4) COMP VALUE 0.          
           05  WS-GTT-NAME             PIC X(19) VALUE SPACES.          
           05  WS-APPL-RETURN-CODE     PIC S9(4) COMP VALUE 0.          
           05  WS-INITIAL-COMMENT-TX.                                   
               10 WS-INITIAL-COMMENT-TX-LEN                             
                                       PIC S9(4) USAGE COMP.            
               10 WS-INITIAL-COMMENT-TX-TEXT                            
                                       PIC X(255).                      
           05  WS-INIT-COMMENTS-LEN    PIC S9(4) USAGE COMP VALUE +87.  
           05  WS-INIT-COMMENTS-TEXT.                                   
               10 FILLER               PIC X(89) VALUE SPACES.          
           05  WS-DATABASE             PIC 9(01) VALUE 0.               
               88  CSR-DATABASE                  VALUE 1.               
               88  SEB-DATABASE                  VALUE 2.               
           05  WS-ADD-DAYS             PIC S9(4) USAGE COMP.            
           05  WS-2YR-PREV-DT          PIC X(10) VALUE SPACES.          
           05  WS-PYMNT-END-DT         PIC X(10) VALUE SPACES.          
      *                                                                         
       01  WS-MESSAGE-PARM.                                             
           05 WS-NOT-FOUND             PIC X(09) VALUE 'NOT FOUND'.     
           05 WS-BUD-BILL              PIC X(14) VALUE 'BUDGET BILLING'.
           05 WS-DPP                   PIC X(03) VALUE 'DPP'.           
           05 WS-SEC-RATE              PIC X(12) VALUE 'SECURED RATE'.  
           05 WS-TOU                   PIC X(11) VALUE 'TIME OF USE'.   
           05 WS-ENRGY-PREPAY          PIC X(20) VALUE                  
                                               'SCANA ENERGY PRE-PAY'.  
           05 WS-SUB-MAST-ACCT         PIC X(18) VALUE                  
                                               'SUB/MASTER ACCOUNT'.    
           05 WS-DFA-CNT               PIC X(12) VALUE 'DFA CONTRACT'.  
           05 WS-PREV-BAL-CNT          PIC X(25) VALUE                  
                                            'PREVIOUS BALANCE CONTRACT'.
P00836     05 WS-NO                    PIC X(02) VALUE 'NO'.            
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR RATE CSS_UTIL_ENVRNMT          *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-ACCT-CREATE-DT        PIC X(10)  VALUE SPACES.    
             10 S-RS1-LAST-BILL-DT          PIC X(10)  VALUE SPACES.    
             10 S-RS1-EXIST-STMT-OPT        PIC X(05)  VALUE SPACES.    
             10 S-RS1-ACCT-BILLS-COUNT      PIC S9(09) COMP VALUE 0.    
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS2-MESSAGE-PARM          PIC X(26)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      *****************************************************************         
      *    DB2 TABLES INCLUDED IN PROGRAM                             *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCOUNT - AT                                              *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_SPCL_BILL_MSG  - U1                                       *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBSBLMSG                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MNT_TRANS_HIST - MH                                       *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMNHIST                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MT_TRN_HST_DET - MI                                       *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMNHDT                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_COMM_DATA - KO                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_DELINQUENCY - C8                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_BILLING_DET - BG                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_DFA_ACCT    - DA                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_BILLING_DET CURSOR                                      *          
      ****************************************************************          
           EXEC SQL                                                     
             DECLARE BILL_DET_CUR CURSOR FOR                            
              SELECT BG.ACCOUNT_NO                                      
                    ,BG.CODE_UTIL_TYPE                                  
                    ,BG.RATE_PLAN_NO                                    
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
               WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO             
                 AND BG.BILL_ITEM_TIMESTMP >=(DATEADD( YEAR, -2, 
           CIS.CURRENT$TIMESTAMP() )) 
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BILL_DET_CUR CURSOR FOR                                    
MFA-TR*       SELECT BG.ACCOUNT_NO                                              
MFA-TR*             ,BG.CODE_UTIL_TYPE                                          
MFA-TR*             ,BG.RATE_PLAN_NO                                            
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*        WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO                     
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP >=(CURRENT TIMESTAMP                 
MFA-TR*                                                      - 2 YEARS)         
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*         QUERYNO 7920                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.           
       01 PARM-USER-ID              PIC X(07).                          
       01 PARM-INS-IND              PIC X(01).                          
       01 PARM-STMNT-OPT            PIC X(05).                          
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                               ,PARM-USER-ID                            
                               ,PARM-INS-IND                            
                               ,PARM-STMNT-OPT.                         
      *                                                                         
      *****************************************************************         
      *  0000-MAINLINE                                                *         
      *      THE FOLLOWING IS THE MAJOR CONTROL FOR THE PROGRAM       *         
      *****************************************************************         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
           PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  0100-INITIALIZATION                                          *         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
           PERFORM 0100B-DECLARE-GTT-R2          THRU 0100B-EXIT.       
                                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04727_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04727_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04727_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,ACCT_CREATE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_BILL_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EXIST_STMT_OPT CHAR(05)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCT_BILLS_COUNT        INT                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(ACCT_CREATE_DT))       AS 
           ACCT_CREATE_DT    
                      ,LTRIM(RTRIM(LAST_BILL_DT))         AS 
           LAST_BILL_DT      
                      ,LTRIM(RTRIM(EXIST_STMT_OPT))       AS 
           EXIST_STMT_OPT    
                      ,ACCT_BILLS_COUNT                                 
                  FROM #CSR04727_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(ACCT_CREATE_DT)       AS ACCT_CREATE_DT            
MFA-TR*               ,STRIP(LAST_BILL_DT)         AS LAST_BILL_DT              
MFA-TR*               ,STRIP(EXIST_STMT_OPT)       AS EXIST_STMT_OPT            
MFA-TR*               ,ACCT_BILLS_COUNT                                         
MFA-TR*           FROM SESSION.CSR04727_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04727_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04727_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04727_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MESSAGE_PARM CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(MESSAGE_PARM))         AS 
           MESSAGE_PARM      
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04727_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(MESSAGE_PARM)         AS MESSAGE_PARM              
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04727_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *  1000-PROCESS-INPUT                                           *         
      *     RECEIVE PARMS                                             *         
      *****************************************************************         
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE PARM-STMNT-OPT              TO WS-STMNT-OPT.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2000-PROCESS-OUTPUT                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           IF PARM-INS-IND  = 'N'                                       
              PERFORM 2100-VALIDATE-ACCOUNT     THRU 2100-EXIT          
           ELSE                                                         
              PERFORM 2200-INS-BILL-MSG-PROCESS THRU 2200-EXIT          
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 2100-VALIDATE-ACCOUNT.                                      *           
      ***************************************************************           
                                                                        
       2100-VALIDATE-ACCOUNT.                                           
                                                                        
           PERFORM 7000-SELECT-ACCOUNT            THRU 7000-EXIT.       
      *                                                                         
           MOVE AT-ACCT-CREATE-DT(1:10)     TO S-RS1-ACCT-CREATE-DT.    
      *                                                                         
           EVALUATE TRUE                                                
              WHEN AT-CODES-DATA-PRESENT(3:1)  = 'A'                    
                   MOVE 'BCNSMPT027'                                    
                                            TO S-RS2-BUS-RULE-ID        
                   MOVE WS-BUD-BILL         TO S-RS2-MESSAGE-PARM       
                   PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT        
              WHEN AT-CODES-DATA-PRESENT(5:1)  = 'A'                    
                   MOVE 'BCNSMPT027'                                    
                                            TO S-RS2-BUS-RULE-ID        
                   MOVE WS-DFA-CNT          TO S-RS2-MESSAGE-PARM       
                   PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT        
              WHEN AT-CODES-DATA-PRESENT(26:1) = 'A'                    
                   MOVE 'BCNSMPT027'                                    
                                            TO S-RS2-BUS-RULE-ID        
                   MOVE WS-DPP              TO S-RS2-MESSAGE-PARM       
                   PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT        
              WHEN AT-CODES-DATA-PRESENT(15:1) = 'A'                    
                   MOVE 'BCNSMPT027'                                    
                                            TO S-RS2-BUS-RULE-ID        
                   MOVE WS-ENRGY-PREPAY     TO S-RS2-MESSAGE-PARM       
                   PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT        
              WHEN AT-MST-SUB-ACCT-IND         = 'M' OR 'S'             
                   MOVE 'BCNSMPT027'                                    
                                            TO S-RS2-BUS-RULE-ID        
                   MOVE WS-SUB-MAST-ACCT    TO S-RS2-MESSAGE-PARM       
                   PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT        
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                         
P00836     PERFORM 7950-GET-LAST-BILL-DT          THRU 7950-EXIT.       
P00836     MOVE BG-BILL-ITEM-TIMESTMP(1:10) TO S-RS1-LAST-BILL-DT.      
P00836     IF BG-BILL-ITEM-TIMESTMP EQUAL SPACES                        
P00836           MOVE 'BCNSMPT027'                                      
P00836                                    TO S-RS2-BUS-RULE-ID          
P00836           MOVE WS-NO               TO S-RS2-MESSAGE-PARM         
P00836           PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT          
P00836     END-IF.                                                      
P00836     PERFORM 7960-GET-ACCT-BILLS-COUNT      THRU 7960-EXIT.       
      *                                                                         
           PERFORM 7700-CHECK-SPCL-BILL-MSG   THRU 7700-EXIT.           
           MOVE  U1-BILL-MSG-ID           TO S-RS1-EXIST-STMT-OPT       
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              MOVE 'BCNSMPT028'           TO S-RS2-BUS-RULE-ID          
ACT043        PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
              PERFORM 2250-GET-BUSINESS-RULE   THRU 2250-EXIT           
           END-IF.                                                      
      *                                                                         
           IF AT-MST-SUB-ACCT-IND = ' '                                 
              PERFORM 7850-CHECK-MASTER-SUB     THRU 7850-EXIT          
              IF WS-MASTER-SUB-FLAG = 'Y'                               
                 MOVE 'BCNSMPT027'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 MOVE WS-SUB-MAST-ACCT    TO S-RS2-MESSAGE-PARM         
                 PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7050-GET-PREV-DT             THRU 7050-EXIT.         
           MOVE 'B'                       TO WS-CODE-DFA-TYPE.          
           PERFORM 7200-CHECK-DFA-TABLE         THRU 7200-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              COMPUTE WS-ADD-DAYS ROUNDED = (DA-NO-SCHED-PYMTS - 1) *   
                                                               30.5     
              PERFORM 7060-GET-PYMNT-END-DT     THRU 7060-EXIT          
              IF WS-PYMNT-END-DT >= WS-2YR-PREV-DT                      
                 MOVE 'BCNSMPT027'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 MOVE WS-DPP              TO S-RS2-MESSAGE-PARM         
                 PERFORM 2250-GET-BUSINESS-RULE THRU 2250-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE 'A'                        TO WS-CODE-DFA-TYPE.         
           PERFORM 7200-CHECK-DFA-TABLE           THRU 7200-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 0                       TO WS-ADD-DAYS               
              COMPUTE WS-ADD-DAYS ROUNDED = (DA-NO-SCHED-PYMTS - 1) *   
                                                               30.5     
              PERFORM 7060-GET-PYMNT-END-DT       THRU 7060-EXIT        
              IF WS-PYMNT-END-DT >= WS-2YR-PREV-DT                      
                 MOVE 'BCNSMPT027'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 MOVE WS-DFA-CNT          TO S-RS2-MESSAGE-PARM         
                 PERFORM 2250-GET-BUSINESS-RULE   THRU 2250-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7400-CHECK-BBP-ACCT            THRU 7400-EXIT.       
           IF WS-BBP-FLAG = 'Y'                                         
              MOVE 'BCNSMPT027'                                         
                                          TO S-RS2-BUS-RULE-ID          
              MOVE WS-BUD-BILL            TO S-RS2-MESSAGE-PARM         
              PERFORM 2250-GET-BUSINESS-RULE      THRU 2250-EXIT        
           END-IF.                                                      
      *                                                                         
           PERFORM 7910-OPEN-BILL-DET-CUR         THRU 7910-EXIT.       
           PERFORM 7920-FETCH-BILL-DET-CUR        THRU 7920-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 5300-GET-TOU-SECURE-ACCT    THRU 5300-EXIT        
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
                   OR WS-TOU-SEC-FL = 'Y'                               
           END-IF.                                                      
           PERFORM 7930-CLOSE-BILL-DET-CUR        THRU 7930-EXIT.       
      *                                                                         
      *    IF WS-TOU-FLAG = 'Y' OR WS-SECURE-RATE-FLAG = 'Y'                    
      *       PERFORM 9999-END-PROGRAM            THRU 9999-EXIT                
      *    END-IF.                                                              
      *                                                                         
           MOVE ZERO            TO WS-DATABASE.                         
           MOVE 'DATABASE'      TO C8-DELINQ-CD.                        
           PERFORM 7750-GET-DELINQUENCY-VALUE    THRU 7750-EXIT.        
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           IF SEB-DATABASE                                              
              PERFORM 7800-CHECK-CONTRACT        THRU 7800-EXIT         
              IF WS-CONTRACT-FLAG = 'Y'                                 
                 MOVE 'BCNSMPT027'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 MOVE WS-PREV-BAL-CNT     TO S-RS2-MESSAGE-PARM         
                 PERFORM 2250-GET-BUSINESS-RULE  THRU 2250-EXIT         
              END-IF                                                    
                                                                        
              PERFORM 7900-CHECK-PREPAY-HIST     THRU 7900-EXIT         
              IF WS-PREPAY-FLAG = 'Y'                                   
                 MOVE 'BCNSMPT027'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 MOVE WS-ENRGY-PREPAY     TO S-RS2-MESSAGE-PARM         
                 PERFORM 2250-GET-BUSINESS-RULE  THRU 2250-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7300-CHECK-RATE-PLAN          THRU 7300-EXIT.        
           IF WS-INS-FLAG = 'N'                                         
              MOVE 'BCNSMPT029'                                         
                                          TO S-RS2-BUS-RULE-ID          
              PERFORM 2250-GET-BUSINESS-RULE     THRU 2250-EXIT         
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 2200-INS-BILL-MSG-PROCESS.                                  *           
      ***************************************************************           
      *                                                                         
       2200-INS-BILL-MSG-PROCESS.                                       
      *                                                                         
           PERFORM 7960-GET-ACCT-BILLS-COUNT      THRU 7960-EXIT.       
           PERFORM 7300-CHECK-RATE-PLAN           THRU 7300-EXIT.       
           IF WS-INS-FLAG = 'Y'                                         
              MOVE WS-ACCOUNT-NO          TO U1-ACCOUNT-NO              
              PERFORM 7700-CHECK-SPCL-BILL-MSG    THRU 7700-EXIT        
              IF U1-BILL-MSG-ID = WS-STMNT-OPT                          
                 MOVE  WS-ALREADY-EXIST   TO S-RETURN-CODE-1            
                 MOVE 'BCNSMPT028'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 PERFORM 2250-GET-BUSINESS-RULE   THRU 2250-EXIT        
              ELSE                                                      
                 PERFORM 8100-DELETE-BILL-MSG     THRU 8100-EXIT        
                 PERFORM 7000-SELECT-ACCOUNT      THRU 7000-EXIT        
                 PERFORM 7500-GET-REVENUE-MONTH   THRU 7500-EXIT        
                 MOVE WS-CURR-REV-MONTH   TO U1-REVENUE-MO-ST           
                 MOVE WS-STMNT-OPT        TO U1-BILL-MSG-ID             
                 MOVE 'S'                 TO U1-MSG-TYPE-CD             
                 MOVE AT-COMPANY-NO       TO U1-COMPANY-NO              
                 MOVE 1                   TO U1-BILL-CYCLE-ST           
                 MOVE 21                  TO U1-BILL-CYCLE-END          
                 MOVE WS-CURR-REV-MONTH   TO U1-REVENUE-MO-END          
                 PERFORM 8200-INSERT-SPCL-BILL-MSG  THRU 8200-EXIT      
                 MOVE ZERO                TO S-RETURN-CODE              
                 PERFORM 7600-SELECT-CUR-TIMESTAMP  THRU 7600-EXIT      
                 PERFORM 2300-PROCESS-COMM-DATA     THRU 2300-EXIT      
              END-IF                                                    
           ELSE                                                         
              MOVE 'BCNSMPT029'                                         
                                          TO S-RS2-BUS-RULE-ID          
              PERFORM 2250-GET-BUSINESS-RULE        THRU 2250-EXIT      
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2250-GET-BUSINESS-RULE                                         *        
      ******************************************************************        
       2250-GET-BUSINESS-RULE.                                          
      *                                                                         
           MOVE WS-FAILED                  TO S-RS2-BUS-RULE-RESULT-CD. 
           IF S-RS2-BUS-RULE-ID GREATER THAN SPACES                     
              PERFORM 7550-GET-RULE-XREF-ID       THRU 7550-EXIT        
           END-IF.                                                      
           PERFORM 8020-INSERT-GTT-R2             THRU 8020-EXIT.       
           PERFORM 9999-END-PROGRAM               THRU 9999-EXIT.       
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-COMM-DATA                                         *        
      ******************************************************************        
       2300-PROCESS-COMM-DATA.                                          
      *                                                                         
           MOVE WS-INIT-COMMENTS-LEN   TO WS-INITIAL-COMMENT-TX-LEN.    
           MOVE 'SYSTEM'               TO WS-INIT-COMMENTS-TEXT.        
           MOVE WS-INIT-COMMENTS-TEXT  TO WS-INITIAL-COMMENT-TX-TEXT.   
           MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
           MOVE 'N'                    TO KO-RED-FLAG-IND.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
           MOVE -1                     TO WS-RED-FL-NULL-IND.           
           MOVE 'O'                    TO KO-COMM-METHOD.               
           MOVE 'I'                    TO KO-COMM-DIRECTION.            
           MOVE '42'                   TO KO-COMM-TYPE-CD.              
           MOVE '51'                   TO KO-COMM-SUBTYPE-CODE.         
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE SPACES                 TO KO-CONTACT-NAME.              
           MOVE SPACES                 TO KO-PROMOTION-ID.              
           MOVE 'N'                    TO KO-PSC-COMPLIANCE-IND.        
           MOVE 0                      TO KO-CALL-ORIGIN-ID.            
           MOVE SPACES                 TO KO-CALL-END-TIME.             
           MOVE -1                     TO WS-END-NULL-IND.              
           MOVE 0                      TO KO-NUMBER-TRANSFERS.          
           MOVE 0                      TO KO-HOLD-TIME.                 
           MOVE 0                      TO KO-QUEUE-TIME.                
           MOVE 'N'                    TO KO-SCREEN-POP-IND.            
           MOVE 0                      TO KO-TOTAL-CALL-TIME.           
           MOVE WS-INITIAL-COMMENT-TX  TO KO-INITIAL-COMMENT-TX.        
           MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
           MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
           MOVE SPACES                 TO KO-SOLICITATION-CD.           
           MOVE SPACES                 TO KO-COMM-ASSOC-CD.             
           MOVE SPACES                 TO KO-COMPLAINT-FL.              
           MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
           MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
      *                                                                         
           PERFORM 8300-INSERT-COMM-DATA         THRU 8300-EXIT.        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5300-GET-TOU-SECURE-ACCT.                                     *         
      *****************************************************************         
       5300-GET-TOU-SECURE-ACCT.                                        
      *                                                                         
           IF WS-TOU-FLAG = 'N'                                         
              PERFORM 7100-CHECK-TOU-ACCT      THRU 7100-EXIT           
              IF WS-TOU-FLAG = 'Y'                                      
                 MOVE 'Y'                 TO WS-TOU-SEC-FL              
                 PERFORM 7930-CLOSE-BILL-DET-CUR                        
                                               THRU 7930-EXIT           
                 MOVE 'BCNSMPT027'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 MOVE WS-TOU              TO S-RS2-MESSAGE-PARM         
                 PERFORM 2250-GET-BUSINESS-RULE  THRU 2250-EXIT         
              END-IF                                                    
           END-IF.                                                      
           IF WS-SECURE-RATE-FLAG = 'N'                                 
              PERFORM 7940-CHECK-SECURE-RATE   THRU 7940-EXIT           
              IF WS-SECURE-RATE-FLAG = 'Y'                              
                 MOVE 'Y'                 TO WS-TOU-SEC-FL              
                 PERFORM 7930-CLOSE-BILL-DET-CUR                        
                                               THRU 7930-EXIT           
                 MOVE 'BCNSMPT027'                                      
                                          TO S-RS2-BUS-RULE-ID          
                 MOVE WS-SEC-RATE         TO S-RS2-MESSAGE-PARM         
                 PERFORM 2250-GET-BUSINESS-RULE  THRU 2250-EXIT         
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7920-FETCH-BILL-DET-CUR    THRU 7920-EXIT.           
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNALLING COPYBOOK.                                         *         
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 7000-SELECT-ACCOUNT.                                          *         
      *****************************************************************         
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.COMPANY_NO                                      
                    ,AT.MST_SUB_ACCT_IND                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                    ,AT.ACCOUNT_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-ACCT-CREATE-DT                                 
                    ,:AT-ACCOUNT-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,AT.ACCT_CREATE_DT                                          
MFA-TR*             ,AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-ACCT-CREATE-DT                                         
MFA-TR*             ,:AT-ACCOUNT-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7050-GET-PREV-DT.                                             *         
      *****************************************************************         
       7050-GET-PREV-DT.                                                
      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, -2, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-2YR-PREV-DT             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-2YR-PREV-DT = CURRENT DATE - 2 YEARS                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7060-GET-PYMNT-END-DT.                                        *         
      *****************************************************************         
       7060-GET-PYMNT-END-DT.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, :WS-ADD-DAYS, IIF(TRY_CONVERT(DATE, 
                                                    :DA-DATE-PYMT-START
              ) IS NULL OR (PATINDEX('%.%', :DA-DATE-PYMT-START
              ) <> 0) OR (LEN(:DA-DATE-PYMT-START
              ) <> 10), CIS.CHAR2DATE(:DA-DATE-PYMT-START
              ), CONVERT(DATE, :DA-DATE-PYMT-START) ) )
            INTO
              :WS-PYMNT-END-DT          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-PYMNT-END-DT = DATE (:DA-DATE-PYMT-START) +              
MFA-TR*                                      :WS-ADD-DAYS DAYS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7060'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'DATE_PYMT_START'       TO TABLE-ELEMENT-1          
               MOVE DA-DATE-PYMT-START      TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7100-CHECK-TOU-ACCT.                                          *         
      *****************************************************************         
                                                                        
       7100-CHECK-TOU-ACCT.                                             
                                                                        
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-TOU-FLAG                                       
              FROM CSS_RATE_TOU_DEF RJ WITH(READUNCOMMITTED)                    
                  ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
              WHERE UT.ACCOUNT_NO = :WS-ACCOUNT-NO                      
                AND RJ.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE               
                AND RJ.RATE_PLAN_NO   = UT.RATE_PLAN_NO                 
                AND RJ.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE              
                AND RJ.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                
                AND RJ.VERSION_NO_CNTRL =                               
                (SELECT MAX(RT.VERSION_NO_CNTRL)                        
                 FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                 
                 WHERE RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE            
                   AND RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO              
                   AND RT.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE           
                   AND RT.RATE_PLAN_NO   = :BG-RATE-PLAN-NO             
                   AND RT.CODE_STATUS    NOT IN ('T')                   
                   AND RT.FROM_EFFECTIVE_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE))            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-TOU-FLAG                                               
MFA-TR*       FROM CSS_RATE_TOU_DEF RJ                                          
MFA-TR*           ,CSS_UTIL_ENVRNMT UT                                          
MFA-TR*       WHERE UT.ACCOUNT_NO = :WS-ACCOUNT-NO                              
MFA-TR*         AND RJ.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                       
MFA-TR*         AND RJ.RATE_PLAN_NO   = UT.RATE_PLAN_NO                         
MFA-TR*         AND RJ.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                      
MFA-TR*         AND RJ.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                        
MFA-TR*         AND RJ.VERSION_NO_CNTRL =                                       
MFA-TR*         (SELECT MAX(RT.VERSION_NO_CNTRL)                                
MFA-TR*          FROM CSS_RATE_CREATOR RT                                       
MFA-TR*          WHERE RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE                    
MFA-TR*            AND RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO                      
MFA-TR*            AND RT.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                   
MFA-TR*            AND RT.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                     
MFA-TR*            AND RT.CODE_STATUS    NOT IN ('T')                           
MFA-TR*            AND RT.FROM_EFFECTIVE_DT <= CURRENT DATE)                    
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-1                  
               MOVE 'CSS_RATE_TOU_DEF'      TO TABLE-2                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-CHECK-DFA-TABLE.                                         *         
      *****************************************************************         
                                                                        
       7200-CHECK-DFA-TABLE.                                            
                                                                        
           MOVE '7200'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NO_SCHED_PYMTS,
              DATE_PYMT_START                                    
                INTO :DA-NO-SCHED-PYMTS                                 
                    ,:DA-DATE-PYMT-START                                
                FROM CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                      
              WHERE DA.ACCOUNT_NO      = :WS-ACCOUNT-NO                 
                AND DA.CODE_DFA_TYPE   = :WS-CODE-DFA-TYPE              
ACT039          ORDER BY DATE_PYMT_START DESC                           
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NO_SCHED_PYMTS                                             
MFA-TR*             ,DATE_PYMT_START                                            
MFA-TR*         INTO :DA-NO-SCHED-PYMTS                                         
MFA-TR*             ,:DA-DATE-PYMT-START                                        
MFA-TR*         FROM CSS_DFA_ACCT DA                                            
MFA-TR*       WHERE DA.ACCOUNT_NO      = :WS-ACCOUNT-NO                         
MFA-TR*         AND DA.CODE_DFA_TYPE   = :WS-CODE-DFA-TYPE                      
MFA-TR*         ORDER BY DATE_PYMT_START DESC                                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_DFA_ACCT'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7300-CHECK-RATE-PLAN.                                         *         
      *****************************************************************         
                                                                        
       7300-CHECK-RATE-PLAN.                                            
                                                                        
           MOVE '7300'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-INS-FLAG                                       
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
              WHERE BG.ACCOUNT_NO     = :WS-ACCOUNT-NO                  
                AND ((BG.CODE_UTIL_TYPE = 'E' AND                       
                      BG.RATE_PLAN_NO IN ('001','002','006','008','009',
                                          '010','012','014','022')) OR  
                     (BG.CODE_UTIL_TYPE = 'G' AND                       
                      BG.RATE_PLAN_NO IN ('031','31A','31B','32S','32B',
                                          '32V','033','33B','022','101',
                                          '102','115','125','126','127',
                                          '225','227')) OR              
                      BG.CODE_UTIL_TYPE= 'U')                           
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-INS-FLAG                                               
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*       WHERE BG.ACCOUNT_NO     = :WS-ACCOUNT-NO                          
MFA-TR*         AND ((BG.CODE_UTIL_TYPE = 'E' AND                               
MFA-TR*               BG.RATE_PLAN_NO IN ('001','002','006','008','009',        
MFA-TR*                                   '010','012','014','022')) OR          
MFA-TR*              (BG.CODE_UTIL_TYPE = 'G' AND                               
MFA-TR*               BG.RATE_PLAN_NO IN ('031','31A','31B','32S','32B',        
MFA-TR*                                   '32V','033','33B','022','101',        
MFA-TR*                                   '102','115','125','126','127',        
MFA-TR*                                   '225','227')) OR                      
MFA-TR*               BG.CODE_UTIL_TYPE= 'U')                                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7400-CHECK-BBP-ACCT.                                          *         
      *****************************************************************         
                                                                        
       7400-CHECK-BBP-ACCT.                                             
                                                                        
           MOVE '7400'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-BBP-FLAG                                       
                FROM CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                   
              WHERE BH.ACCOUNT_NO      = :WS-ACCOUNT-NO                 
ACT040          AND DATEADD( MONTH, 12, BH.DATE_PYMT_STRT ) >=                  
ACT040              (DATEADD( YEAR, -2, CAST(SYSDATETIMEOFFSET() 
           AS DATE) ))                            
                AND BH.CHANGE_REASON   <> 'O'                           
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-BBP-FLAG                                               
MFA-TR*         FROM CSS_BUDGET_HIST BH                                         
MFA-TR*       WHERE BH.ACCOUNT_NO      = :WS-ACCOUNT-NO                         
MFA-TR*         AND BH.DATE_PYMT_STRT + 12 MONTHS >=                            
MFA-TR*             (CURRENT DATE - 2 YEARS)                                    
MFA-TR*         AND BH.CHANGE_REASON   <> 'O'                                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUDGET_HIST'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-GET-REVENUE-MONTH.                                                 
      ******************************************************************        
      *                                                                         
       7500-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,15,06)                            
                INTO :WS-CURR-REV-MONTH                                 
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME   = 'COMMON'                          
                 AND COMPANY_NO     = '01'                              
                 AND CMND_CODE      = 'DATE'                            
                 AND SEQ_NO         = 20                                
                 AND STATUS         = 'A'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR(PARM_DATA,15,06)                                    
MFA-TR*         INTO :WS-CURR-REV-MONTH                                         
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME   = 'COMMON'                                  
MFA-TR*          AND COMPANY_NO     = '01'                                      
MFA-TR*          AND CMND_CODE      = 'DATE'                                    
MFA-TR*          AND SEQ_NO         = 20                                        
MFA-TR*          AND STATUS         = 'A'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_JOB_PARM'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS2-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   R WITH(READUNCOMMITTED)                     
                    ,CSS_BUS_RULE_XREF T WITH(READUNCOMMITTED)                  
               WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                 
                 AND R.BUS_RULE_ID = T.BUS_RULE_ID                      
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS2-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   R                                           
MFA-TR*             ,CSS_BUS_RULE_XREF T                                        
MFA-TR*        WHERE R.BUS_RULE_ID = :S-RS2-BUS-RULE-ID                         
MFA-TR*          AND R.BUS_RULE_ID = T.BUS_RULE_ID                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS2-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  GET THE CURRENT TIMESTAMP                                     *        
      ******************************************************************        
                                                                        
       7600-SELECT-CUR-TIMESTAMP.                                       
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP ,                   
MFA-TR*            :WS-CURRENT-DATE     = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7600'               TO ACTIVE-PARAGRAPH            
               MOVE 'SET'                TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE SPACES               TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7700-CHECK-SPCL-BILL-MSG.                                     *         
      *****************************************************************         
                                                                        
       7700-CHECK-SPCL-BILL-MSG.                                        
                                                                        
           MOVE '7700'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) U1.BILL_MSG_ID                                     
                INTO :U1-BILL-MSG-ID                                    
                FROM CSS_SPCL_BILL_MSG U1 WITH(READUNCOMMITTED)                 
              WHERE U1.ACCOUNT_NO      = :WS-ACCOUNT-NO                 
                AND U1.MSG_TYPE_CD     = 'S'                            
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT U1.BILL_MSG_ID                                             
MFA-TR*         INTO :U1-BILL-MSG-ID                                            
MFA-TR*         FROM CSS_SPCL_BILL_MSG U1                                       
MFA-TR*       WHERE U1.ACCOUNT_NO      = :WS-ACCOUNT-NO                         
MFA-TR*         AND U1.MSG_TYPE_CD     = 'S'                                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7700'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_SPCL_BILL_MSG'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   ARE WE IN SEB OR CSR?                                        *        
      ******************************************************************        
                                                                        
       7750-GET-DELINQUENCY-VALUE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
                AND   COMPANY_NO = :AT-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*         AND   COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7750'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_DELINQUENCY'       TO TABLE-1                   
              MOVE 'DATABASE'              TO TABLE-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
      *****************************************************************         
      * 7800-CHECK-CONTRACT.                                          *         
      *****************************************************************         
                                                                        
       7800-CHECK-CONTRACT.                                             
                                                                        
           MOVE '7800'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CONTRACT-FLAG                                  
                FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                      
              WHERE CT.ACCOUNT_NO      = :WS-ACCOUNT-NO                 
                AND CT.DATE_CONTRACT   >= (DATEADD( YEAR, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))      
                AND CT.CNT_NAME_CD     = 530                            
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CONTRACT-FLAG                                          
MFA-TR*         FROM CSS_CONTRACT CT                                            
MFA-TR*       WHERE CT.ACCOUNT_NO      = :WS-ACCOUNT-NO                         
MFA-TR*         AND CT.DATE_CONTRACT   >= (CURRENT DATE - 2 YEARS)              
MFA-TR*         AND CT.CNT_NAME_CD     = 530                                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7800'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CONTRACT'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7850-CHECK-MASTER-SUB.                                        *         
      *****************************************************************         
                                                                        
       7850-CHECK-MASTER-SUB.                                           
                                                                        
           MOVE '7850'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MASTER-SUB-FLAG                                
                FROM CSS_BILL_ACCT_XFER AF WITH(READUNCOMMITTED)                
               WHERE (AF.ACCOUNT_NO     = :WS-ACCOUNT-NO                
                               OR                                       
                      AF.ACCT_XFER_FROM = :WS-ACCOUNT-NO)               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MASTER-SUB-FLAG                                        
MFA-TR*         FROM CSS_BILL_ACCT_XFER AF                                      
MFA-TR*        WHERE (AF.ACCOUNT_NO     = :WS-ACCOUNT-NO                        
MFA-TR*                        OR                                               
MFA-TR*               AF.ACCT_XFER_FROM = :WS-ACCOUNT-NO)                       
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7850'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CSS_BILL_ACCT_XFER'    TO TABLE-2                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7900-CHECK-PREPAY-HIST.                                       *         
      *****************************************************************         
                                                                        
       7900-CHECK-PREPAY-HIST.                                          
                                                                        
           MOVE '7900'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-PREPAY-FLAG                                    
                FROM CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                   
              WHERE PK.ACCOUNT_NO         = :WS-ACCOUNT-NO              
                AND PK.PREPAY_HIST_SEQ_TS >= (DATEADD( YEAR, -2, 
           CIS.CURRENT$TIMESTAMP() )) 
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-PREPAY-FLAG                                            
MFA-TR*         FROM CSS_PREPAY_HIST PK                                         
MFA-TR*       WHERE PK.ACCOUNT_NO         = :WS-ACCOUNT-NO                      
MFA-TR*         AND PK.PREPAY_HIST_SEQ_TS >= (CURRENT TIMESTAMP -               
MFA-TR*                                                        2 YEARS)         
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7900'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_PREPAY_HIST'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7910-OPEN-BILL-DET-CUR                                                 
      ******************************************************************        
      *                                                                         
       7910-OPEN-BILL-DET-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN BILL_DET_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
             MOVE PROGRAM-NAME            TO ABEND-PROGRAM              
             MOVE '7910'                  TO ACTIVE-PARAGRAPH           
             MOVE 'OPEN'                  TO ABEND-FUNCTION             
             MOVE SPACES                  TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
             MOVE 'CSS_BILLING_DET'       TO TABLE-1                    
             MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1            
             MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1          
             PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT           
           END-IF.                                                      
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7920-FETCH-BILL-DET-CUR.                                               
      ******************************************************************        
                                                                        
       7920-FETCH-BILL-DET-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH BILL_DET_CUR                                       
                INTO :BG-ACCOUNT-NO                                     
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              CONTINUE                                                  
             ELSE                                                       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7920'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT
           END-IF.        
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7930-CLOSE-BILL-DET-CUR.                                                
      ******************************************************************        
       7930-CLOSE-BILL-DET-CUR.                                         
           EXEC SQL                                                     
               CLOSE BILL_DET_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7930'                  TO ACTIVE-PARAGRAPH          
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7940-CHECK-SECURE-RATE .                                      *         
      *****************************************************************         
                                                                        
       7940-CHECK-SECURE-RATE.                                          
                                                                        
           MOVE '7940'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SECURE-RATE-FLAG                               
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
              WHERE RD.CODE_UTIL_TYPE  = :BG-CODE-UTIL-TYPE             
                AND RD.RATE_PLAN_NO    = :BG-RATE-PLAN-NO               
                AND RD.SECURED_RATE_FL = 'Y'                            
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SECURE-RATE-FLAG                                       
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*       WHERE RD.CODE_UTIL_TYPE  = :BG-CODE-UTIL-TYPE                     
MFA-TR*         AND RD.RATE_PLAN_NO    = :BG-RATE-PLAN-NO                       
MFA-TR*         AND RD.SECURED_RATE_FL = 'Y'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7940                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7940'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_RATE_PLAN_DESC'    TO TABLE-1                  
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL-TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-1        
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7950-GET-LAST-BILL-DT.                                        *         
      *****************************************************************         
                                                                        
       7950-GET-LAST-BILL-DT.                                           
                                                                        
           MOVE '7950'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           BILL_ITEM_TIMESTMP), 121), ' ', '-'), ':', '.')                     
P00836          INTO :BG-BILL-ITEM-TIMESTMP :WS-NULL-IND                 
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
              WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO              
                AND BG.CODE_BILL_CALC     = 'A'                         
                AND BG.CODE_BILL_ITM_TYPE = 'C'                         
                AND BG.CODE_BILL_ITM_IND  = 'A'                         
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BILL_ITEM_TIMESTMP)                                    
MFA-TR*         INTO :BG-BILL-ITEM-TIMESTMP:WS-NULL-IND                         
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*       WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO                      
MFA-TR*         AND BG.CODE_BILL_CALC     = 'A'                                 
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE = 'C'                                 
MFA-TR*         AND BG.CODE_BILL_ITM_IND  = 'A'                                 
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7950                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00836        IF WS-NULL-IND    < 0                                     
P00836           MOVE SPACES                TO BG-BILL-ITEM-TIMESTMP    
P00836        END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7950'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7960-GET-ACCT-BILLS-COUNT                                      *        
      ******************************************************************        
       7960-GET-ACCT-BILLS-COUNT.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT  COUNT(DISTINCT REVENUE_MONTH)                    
                 INTO  :S-RS1-ACCT-BILLS-COUNT                          
                 FROM  CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                WHERE  ACCOUNT_NO     = :WS-ACCOUNT-NO                  
                  AND  REVENUE_MONTH  > 0                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COUNT(DISTINCT REVENUE_MONTH)                            
MFA-TR*          INTO  :S-RS1-ACCT-BILLS-COUNT                                  
MFA-TR*          FROM  CSS_BILLING_DET                                          
MFA-TR*         WHERE  ACCOUNT_NO     = :WS-ACCOUNT-NO                          
MFA-TR*           AND  REVENUE_MONTH  > 0                                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7960'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04727_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04727_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04727_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04727_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04727_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04727_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04727_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ACCT_CREATE_DT                                       
                  ,LAST_BILL_DT                                         
                  ,EXIST_STMT_OPT                                       
                  ,ACCT_BILLS_COUNT                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-ACCT-CREATE-DT                                
                  ,:S-RS1-LAST-BILL-DT                                  
                  ,:S-RS1-EXIST-STMT-OPT                                
                  ,:S-RS1-ACCT-BILLS-COUNT                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04727_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCT_CREATE_DT                                               
MFA-TR*           ,LAST_BILL_DT                                                 
MFA-TR*           ,EXIST_STMT_OPT                                               
MFA-TR*           ,ACCT_BILLS_COUNT                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-ACCT-CREATE-DT                                        
MFA-TR*           ,:S-RS1-LAST-BILL-DT                                          
MFA-TR*           ,:S-RS1-EXIST-STMT-OPT                                        
MFA-TR*           ,:S-RS1-ACCT-BILLS-COUNT                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04727_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04727_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,MESSAGE_PARM                                         
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BUS-RULE-ID                                   
                  ,:S-RS2-BUS-RULE-RESULT-CD                            
                  ,:S-RS2-MESSAGE-PARM                                  
                  ,:S-RS2-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04727_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,MESSAGE_PARM                                                 
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS2-MESSAGE-PARM                                          
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04727_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8100-DELETE-BILL-MSG                                          *         
      *****************************************************************         
                                                                        
       8100-DELETE-BILL-MSG.                                            
                                                                        
           MOVE '8100'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              DELETE FROM U1                           
              FROM CSS_SPCL_BILL_MSG U1
               WHERE U1.ACCOUNT_NO      = :WS-ACCOUNT-NO                
                 AND U1.MSG_TYPE_CD     = 'S'                           
                 AND U1.BILL_MSG_ID     = :U1-BILL-MSG-ID               
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_SPCL_BILL_MSG U1                                  
MFA-TR*        WHERE U1.ACCOUNT_NO      = :WS-ACCOUNT-NO                        
MFA-TR*          AND U1.MSG_TYPE_CD     = 'S'                                   
MFA-TR*          AND U1.BILL_MSG_ID     = :U1-BILL-MSG-ID                       
MFA-TR*       QUERYNO 8100                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_SPCL_BILL_MSG'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-SPCL-BILL-MSG.                                     *        
      ******************************************************************        
      *                                                                         
       8200-INSERT-SPCL-BILL-MSG.                                       
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_SPCL_BILL_MSG                              
                  ( REVENUE_MO_ST                                       
                   ,ACCOUNT_NO                                          
                   ,BILL_MSG_ID                                         
                   ,MSG_TYPE_CD                                         
                   ,COMPANY_NO                                          
                   ,BILL_CYCLE_ST                                       
                   ,BILL_CYCLE_END                                      
                   ,REVENUE_MO_END )                                    
            VALUES (:U1-REVENUE-MO-ST                                   
                   ,:U1-ACCOUNT-NO                                      
                   ,:U1-BILL-MSG-ID                                     
                   ,:U1-MSG-TYPE-CD                                     
                   ,:U1-COMPANY-NO                                      
                   ,:U1-BILL-CYCLE-ST                                   
                   ,:U1-BILL-CYCLE-END                                  
                   ,:U1-REVENUE-MO-END )                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ALREADY-EXIST                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '8200'                        TO ACTIVE-PARAGRAPH    
              MOVE 'INSERT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_SPCL_BILL_MSG'           TO TABLE-1             
              MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
              MOVE U1-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
              MOVE 'BILL_MSG_ID'                 TO TABLE-ELEMENT-2     
              MOVE U1-BILL-MSG-ID                TO HOSTVAR-ELEMENT-2   
              MOVE 'REVENUE_MO_END'              TO TABLE-ELEMENT-3     
              MOVE U1-REVENUE-MO-END             TO HOSTVAR-ELEMENT-3   
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *   8300-INSERT-COMM-DATA                                      *          
      ****************************************************************          
       8300-INSERT-COMM-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE ACTIVE-PARAGRAPH      TO ABEND-FUNCTION              
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE KO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE KO-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04727_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04727_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
