       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04726.                                      
       AUTHOR.        AMIRTARAJ D.                                      
COB303 DATE-WRITTEN.     JUN 14,2014                                    
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04726              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04726 :                                                --         
      *--                                                            --         
      *--  RETRIEVE BILLING KEYS FOR THE GIVEN BILL NUMBER.          --         
      *--  IT ALSO RETRIEVES REBILL/CANCEL BILLING KEYS (IF PRESENT) --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                               --         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--           ACCOUNT_NO             DECIMAL(13)               --         
      *--           CODE_UTIL_TYPE         CHAR(02)                  --         
      *--           IC_NO                  SMALLINT                  --         
      *--           BILL_NO                INTEGER                   --         
      *--                                                            --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      *--  CSR04726_R1 - RATE DETAILS                                --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,ACCOUNT_NO             DECIMAL(13,0)             --         
      *--          ,RE_CODE_UTIL_TYPE      CHAR(1)                   --         
      *--          ,RE_IC_NO               SMALLINT                  --         
      *--          ,RE_BILL_NO             INTEGER                   --         
      *--          ,RE_BILL_ITEM_TS        CHAR(26)                  --         
      *--          ,CAN_CODE_UTIL_TYPE     CHAR(1)                   --         
      *--          ,CAN_IC_NO              SMALLINT                  --         
      *--          ,CAN_BILL_NO            INTEGER                   --         
      *--          ,CAN_BILL_ITEM_TS       CHAR(26)                  --         
      *--          ,CAN_REVENUE_MONTH      DECIMAL(6,0)              --         
      *--                                                            --         
      *--  CSR04726_R2 - BUS RULE DETAILS.                           --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,BUS_RULE_ID            CHAR(10)                  --         
      *--          ,BUS_RULE_RESULT_CD     CHAR(10)                  --         
      *--          ,BUS_RULE_XREF_ID       CHAR(26)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  06/14/2014    AD7F921     INITIAL VERSION.                --         
      *--                                                            --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04726'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04726 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(08) VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04726'. 
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-ONE                       PIC 9(01) VALUE 1.          
           05  WS-ZERO                      PIC 9(01) VALUE 0.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(4) COMP VALUE 0.     
           05  WS-CANCEL-BILL-CNT           PIC S9(4) COMP VALUE 0.     
           05  WS-CNCL-REBIL-CNT            PIC S9(4) COMP VALUE 0.     
                                                                        
       01  WS-CANCEL-BILL-KEY.                                          
           05  WS-ACCOUNT-NO                PIC S9(13)V USAGE COMP-3    
                                                           VALUE 0.     
           05  WS-REVENUE-MONTH             PIC S9(06)V USAGE COMP-3    
                                                           VALUE 0.     
           05  WS-ORIG-REVENUE-MONTH        PIC S9(06)V USAGE COMP-3    
                                                           VALUE 0.     
           05  WS-BILL-NO                   PIC S9(09)  USAGE COMP      
                                                           VALUE 0.     
           05  WS-IC-NO                     PIC S9(4) COMP VALUE 0.     
           05  WS-CODE-UTIL-TYPE            PIC X(01) VALUE SPACES.     
           05  WS-BILL-ITEM-TIMESTMP        PIC X(26) VALUE SPACES.     
           05  WS-FREE-FORM-TEXT            PIC X(03) VALUE '999'.      
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
              88 NO-MORE-ROWS                         VALUE 'Y'.        
           05 WS-IC-HAS-CNSMPTN             PIC X(01) VALUE 'Y'.        
              88 IC-HAS-CNSMPTN                       VALUE 'Y'.        
              88 IC-HAS-NO-CNSMPTN                    VALUE 'N'.        
           05 WS-MTRD-IC                    PIC X(01) VALUE 'Y'.        
              88 MTRD-IC                              VALUE 'Y'.        
              88 UNMTRD-IC                            VALUE 'N'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT                                    *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-ACCOUNT-NO            PIC S9(13)V USAGE COMP-3    
                                                       VALUE 0.         
             10 S-RS1-RE-CODE-UTIL-TYPE     PIC X(01)  VALUE SPACES.    
             10 S-RS1-RE-IC-NO              PIC S9(04) USAGE COMP       
                                                       VALUE 0.         
             10 S-RS1-RE-BILL-NO            PIC S9(09) USAGE COMP       
                                                       VALUE 0.         
             10 S-RS1-RE-BILL-ITEM-TS       PIC X(26)  VALUE SPACES.    
             10 S-RS1-RE-ADJ-REASON-CD      PIC X(03)  VALUE SPACES.    
             10 S-RS1-RE-ADJ-REASON-TEXT    PIC X(255) VALUE SPACES.    
             10 S-RS1-CAN-CODE-UTIL-TYPE    PIC X(01)  VALUE SPACES.    
             10 S-RS1-CAN-IC-NO             PIC S9(04) USAGE COMP       
                                                       VALUE 0.         
             10 S-RS1-CAN-BILL-NO           PIC S9(09) USAGE COMP       
                                                       VALUE 0.         
             10 S-RS1-CAN-BILL-ITEM-TS      PIC X(26)  VALUE SPACES.    
             10 S-RS1-CAN-REVENUE-MONTH     PIC S9(6)V USAGE COMP-3     
                                                       VALUE 0.         
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS2-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILLING_DET    BG                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILLING_HDR    BI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BILL_ADJUSTMNT, BP                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILADJ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BILL_ADJ_REASN, K0                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLADRSN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CNSMPTN_HIST,    CX                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CUST_PLAN,       CP                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UM_CNSMPT_HIST,  UC                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBUMCNSM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE CAN_REBILL_CSR CURSOR FOR                         
                 SELECT BG.ACCOUNT_NO                                   
                       ,BG.CODE_UTIL_TYPE                               
                       ,BG.IC_NO                                        
                       ,BG.BILL_NO                                      
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                           
                       ,BG.REV_MTH_ORIG_BILL                            
                       ,BG.ADJ_REASON_CD                                
                       ,BG.DATE_ORIG_BILL                               
                   FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                
                       ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                
                  WHERE BG.ACCOUNT_NO         = BI.ACCOUNT_NO           
                    AND BG.BILL_NO            = BI.BILL_NO              
                    AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO          
                    AND BG.BILL_NO            = :BG-BILL-NO             
                    AND BG.IC_NO              = :BG-IC-NO               
                    AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE      
                    AND BG.CODE_BILL_ITM_TYPE <> 'B'                    
                    AND BG.CODE_BILL_ITM_IND  = 'A'                     
                    AND BG.CODE_BILL_CALC     = 'A'                     
                    AND BG.DATE_ORIG_BILL     IS NOT NULL               
                 ORDER BY BILL_ITEM_TIMESTMP DESC                    
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CAN_REBILL_CSR CURSOR FOR                                 
MFA-TR*          SELECT BG.ACCOUNT_NO                                           
MFA-TR*                ,BG.CODE_UTIL_TYPE                                       
MFA-TR*                ,BG.IC_NO                                                
MFA-TR*                ,BG.BILL_NO                                              
MFA-TR*                ,BG.BILL_ITEM_TIMESTMP                                   
MFA-TR*                ,BG.REV_MTH_ORIG_BILL                                    
MFA-TR*                ,BG.ADJ_REASON_CD                                        
MFA-TR*                ,BG.DATE_ORIG_BILL                                       
MFA-TR*            FROM CSS_BILLING_DET BG                                      
MFA-TR*                ,CSS_BILLING_HDR BI                                      
MFA-TR*           WHERE BG.ACCOUNT_NO         = BI.ACCOUNT_NO                   
MFA-TR*             AND BG.BILL_NO            = BI.BILL_NO                      
MFA-TR*             AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                  
MFA-TR*             AND BG.BILL_NO            = :BG-BILL-NO                     
MFA-TR*             AND BG.IC_NO              = :BG-IC-NO                       
MFA-TR*             AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE              
MFA-TR*             AND BG.CODE_BILL_ITM_TYPE <> 'B'                            
MFA-TR*             AND BG.CODE_BILL_ITM_IND  = 'A'                             
MFA-TR*             AND BG.CODE_BILL_CALC     = 'A'                             
MFA-TR*             AND BG.DATE_ORIG_BILL     IS NOT NULL                       
MFA-TR*          ORDER BY BG.BILL_ITEM_TIMESTMP DESC                            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 I-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
       01 I-CODE-UTIL-TYPE                  PIC X(01).                  
       01 I-IC-NO                           PIC S9(4)   USAGE COMP.     
       01 I-BILL-NO                         PIC S9(09)  USAGE COMP.     
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                                I-CODE-UTIL-TYPE                        
                                I-IC-NO                                 
                                I-BILL-NO.                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04726_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04726_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04726_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,ACCOUNT_NO              DECIMAL(13,0)               
                   ,RE_CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RE_IC_NO                SMALLINT                    
                   ,RE_BILL_NO              INT                     
                   ,RE_BILL_ITEM_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RE_ADJ_REASON_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RE_ADJ_REASON_TEXT CHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,CAN_CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CAN_IC_NO               SMALLINT                    
                   ,CAN_BILL_NO             INT                     
                   ,CAN_BILL_ITEM_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CAN_REVENUE_MONTH       DECIMAL(6,0)                
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,ACCOUNT_NO                  AS ACCOUNT_NO        
                      ,LTRIM(RTRIM(RE_CODE_UTIL_TYPE))    AS 
           RE_CODE_UTIL_TYPE 
                      ,RE_IC_NO                    AS RE_IC_NO          
                      ,RE_BILL_NO                  AS RE_BILL_NO        
                      ,LTRIM(RTRIM(RE_BILL_ITEM_TS))      AS 
           RE_BILL_ITEM_TS   
                      ,LTRIM(RTRIM(RE_ADJ_REASON_CD))     AS 
           RE_ADJ_REASON_CD  
                      ,LTRIM(RTRIM(RE_ADJ_REASON_TEXT))   AS 
           RE_ADJ_REASON_TEXT
                      ,LTRIM(RTRIM(CAN_CODE_UTIL_TYPE))   AS 
           CAN_CODE_UTIL_TYPE
                      ,CAN_IC_NO                   AS CAN_IC_NO         
                      ,CAN_BILL_NO                 AS CAN_BILL_NO       
                      ,LTRIM(RTRIM(CAN_BILL_ITEM_TS))     AS 
           CAN_BILL_ITEM_TS  
                      ,CAN_REVENUE_MONTH                                
                  FROM #CSR04726_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ACCOUNT_NO                  AS ACCOUNT_NO                
MFA-TR*               ,STRIP(RE_CODE_UTIL_TYPE)    AS RE_CODE_UTIL_TYPE         
MFA-TR*               ,RE_IC_NO                    AS RE_IC_NO                  
MFA-TR*               ,RE_BILL_NO                  AS RE_BILL_NO                
MFA-TR*               ,STRIP(RE_BILL_ITEM_TS)      AS RE_BILL_ITEM_TS           
MFA-TR*               ,STRIP(RE_ADJ_REASON_CD)     AS RE_ADJ_REASON_CD          
MFA-TR*               ,STRIP(RE_ADJ_REASON_TEXT)   AS RE_ADJ_REASON_TEXT        
MFA-TR*               ,STRIP(CAN_CODE_UTIL_TYPE)   AS CAN_CODE_UTIL_TYPE        
MFA-TR*               ,CAN_IC_NO                   AS CAN_IC_NO                 
MFA-TR*               ,CAN_BILL_NO                 AS CAN_BILL_NO               
MFA-TR*               ,STRIP(CAN_BILL_ITEM_TS)     AS CAN_BILL_ITEM_TS          
MFA-TR*               ,CAN_REVENUE_MONTH                                        
MFA-TR*           FROM SESSION.CSR04726_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04726_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04726_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04726_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04726_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04726_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-ACCOUNT-NO                TO BG-ACCOUNT-NO            
                                               BI-ACCOUNT-NO.           
           MOVE I-CODE-UTIL-TYPE            TO BG-CODE-UTIL-TYPE.       
           MOVE I-IC-NO                     TO BG-IC-NO.                
           MOVE I-BILL-NO                   TO BG-BILL-NO               
                                               BI-BILL-NO.              
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-PROCESS-REBIL-ROWS     THRU 2100-EXIT.          
           PERFORM 2200-PROCESS-ACTV-ROWS      THRU 2200-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-REBIL-ROWS                                        *        
      ******************************************************************        
       2100-PROCESS-REBIL-ROWS.                                         
                                                                        
           PERFORM 7000-OPEN-CANCEL-REBILL     THRU 7000-EXIT.          
           PERFORM 7005-FETCH-CANCEL-REBILL    THRU 7005-EXIT.          
           PERFORM 5000-PROCESS-CANCEL-REBILL  THRU 5000-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7010-CLOSE-CANCEL-REBILL    THRU 7010-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2200-PROCESS-ACTV-ROWS.                                       *         
      *****************************************************************         
       2200-PROCESS-ACTV-ROWS.                                          
                                                                        
           SET MTRD-IC                      TO TRUE.                    
           SET IC-HAS-CNSMPTN               TO TRUE.                    
           MOVE I-ACCOUNT-NO                TO BG-ACCOUNT-NO            
                                               CP-ACCOUNT-NO            
                                               CX-ACCOUNT-NO            
                                               UC-ACCOUNT-NO.           
           MOVE I-CODE-UTIL-TYPE            TO BG-CODE-UTIL-TYPE        
                                               CP-CODE-UTIL-TYPE        
                                               CX-CODE-UTIL-TYPE        
                                               UC-CODE-UTIL-TYPE.       
           MOVE I-IC-NO                     TO BG-IC-NO                 
                                               CP-IC-NO                 
                                               CX-IC-NO                 
                                               UC-IC-NO.                
           MOVE I-BILL-NO                   TO BG-BILL-NO               
                                               CX-BILL-NO               
                                               UC-BILL-NO               
                                                                        
           PERFORM 7065-GET-ACTV-BILL-KEY      THRU 7065-EXIT.          
                                                                        
           IF IC-HAS-CNSMPTN                                            
              EVALUATE TRUE                                             
                 WHEN BG-CODE-UTIL-TYPE = 'U'                           
                    SET UNMTRD-IC    TO TRUE                            
                 WHEN BG-CODE-UTIL-TYPE = 'E'                           
                 WHEN BG-CODE-UTIL-TYPE = 'G'                           
                    PERFORM 7070-CUST-PLAN-EXISTS   THRU 7070-EXIT      
              END-EVALUATE                                              
              IF MTRD-IC                                                
                 PERFORM 7080-METERED-CNSMPTN THRU 7080-EXIT            
              END-IF                                                    
              IF UNMTRD-IC                                              
                 PERFORM 7090-UNMTRD-CNSMPTN  THRU 7090-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF IC-HAS-CNSMPTN                                            
              PERFORM 6000-MOVE-RATE-RS1       THRU 6000-EXIT           
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
             EXIT.                                                      
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5000-PROCESS-CANCEL-REBILL.                                   *         
      *****************************************************************         
       5000-PROCESS-CANCEL-REBILL.                                      
                                                                        
           MOVE BG-ACCOUNT-NO               TO BP-ACCOUNT-NO.           
           MOVE BG-CODE-UTIL-TYPE           TO BP-CODE-UTIL-TYPE.       
           MOVE BG-IC-NO                    TO BP-IC-NO.                
           MOVE BG-BILL-NO                  TO BP-BILL-NO.              
           MOVE BG-BILL-ITEM-TIMESTMP       TO BP-BILL-ITEM-TIMESTMP.   
                                                                        
           PERFORM 7015-GET-CNCL-REBIL-CNT     THRU 7015-EXIT.          
                                                                        
           EVALUATE WS-CNCL-REBIL-CNT                                   
              WHEN WS-ZERO                                              
                 PERFORM 5100-PROCESS-CNCL-BILL                         
                                               THRU 5100-EXIT           
              WHEN WS-ONE                                               
                 PERFORM 7020-GET-CANCEL-REBILL                         
                                               THRU 7020-EXIT           
              WHEN OTHER                                                
                 PERFORM 5200-PROCESS-MULT-CNCL-REBIL                   
                                               THRU 5200-EXIT           
           END-EVALUATE                                                 
                                                                        
           IF WS-CNCL-REBIL-CNT > WS-ZERO OR                            
              WS-CANCEL-BILL-CNT > WS-ZERO                              
              PERFORM 5300-GET-ADJST-REASON    THRU 5300-EXIT           
              PERFORM 6000-MOVE-RATE-RS1       THRU 6000-EXIT           
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
                                                                        
              INITIALIZE WS-CANCEL-BILL-KEY                             
                         DCLCSS-BILLING-DET                             
                         GTT-RETURN-FIELDS-1                            
           END-IF.                                                      
                                                                        
           PERFORM 7005-FETCH-CANCEL-REBILL    THRU 7005-EXIT.          
                                                                        
       5000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5100-PROCESS-CNCL-BILL.                                       *         
      *****************************************************************         
       5100-PROCESS-CNCL-BILL.                                          
                                                                        
           PERFORM 7025-GET-CANCEL-BILL-CNT    THRU 7025-EXIT           
                                                                        
           EVALUATE WS-CANCEL-BILL-CNT                                  
              WHEN WS-ZERO                                              
                 CONTINUE                                               
              WHEN WS-ONE                                               
                 PERFORM 7030-GET-CANCEL-BILL  THRU 7030-EXIT           
              WHEN OTHER                                                
                 PERFORM 5200-PROCESS-MULT-CNCL-REBIL                   
                                               THRU 5200-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       5100-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 5200-PROCESS-MULT-CNCL-REBIL.                                 *         
      *****************************************************************         
       5200-PROCESS-MULT-CNCL-REBIL.                                    
                                                                        
           PERFORM 7035-CHK-OVERIDE-EXIST      THRU 7035-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7040-GET-BCKOUT-BILL     THRU 7040-EXIT           
              PERFORM 7045-GET-CNCL-BILL-FOR-BCK-ROW                    
                                               THRU 7045-EXIT           
           ELSE                                                         
              PERFORM 7045-GET-CNCL-BILL-FOR-BCK-ROW                    
                                               THRU 7045-EXIT           
           END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 5300-GET-ADJST-REASON.                                        *         
      *****************************************************************         
       5300-GET-ADJST-REASON.                                           
                                                                        
           PERFORM 7050-GET-BCKOUT-BILL-ADJ    THRU 7050-EXIT.          
                                                                        
           IF BG-ADJ-REASON-CD EQUAL WS-FREE-FORM-TEXT                  
             MOVE 'BADJ'                    TO BP-ADJ-TYPE-CD           
                                                S-RS1-RE-ADJ-REASON-CD  
             PERFORM 7055-BILL-ADJ-REASON      THRU 7055-EXIT           
             MOVE BP-ADJ-REASON-DESC-TEXT   TO S-RS1-RE-ADJ-REASON-TEXT 
           ELSE                                                         
             MOVE BG-ADJ-REASON-CD          TO K0-ADJ-REASON-CD         
                                                S-RS1-RE-ADJ-REASON-CD  
             PERFORM 7060-BILL-ADJ-REASON-FMT  THRU 7060-EXIT           
             MOVE K0-ADJ-REASON-DESC        TO S-RS1-RE-ADJ-REASON-TEXT 
           END-IF.                                                      
      *                                                                         
       5300-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 6000-MOVE-RATE-RS1.                                            *        
      ******************************************************************        
       6000-MOVE-RATE-RS1.                                              
                                                                        
           MOVE BG-ACCOUNT-NO               TO S-RS1-ACCOUNT-NO.        
           MOVE BG-CODE-UTIL-TYPE           TO S-RS1-RE-CODE-UTIL-TYPE. 
           MOVE BG-IC-NO                    TO S-RS1-RE-IC-NO.          
           MOVE BG-BILL-NO                  TO S-RS1-RE-BILL-NO.        
           MOVE BG-BILL-ITEM-TIMESTMP       TO S-RS1-RE-BILL-ITEM-TS.   
           MOVE WS-CODE-UTIL-TYPE           TO S-RS1-CAN-CODE-UTIL-TYPE.
           MOVE WS-IC-NO                    TO S-RS1-CAN-IC-NO.         
           MOVE WS-BILL-NO                  TO S-RS1-CAN-BILL-NO.       
           MOVE WS-BILL-ITEM-TIMESTMP       TO S-RS1-CAN-BILL-ITEM-TS.  
           MOVE WS-REVENUE-MONTH            TO S-RS1-CAN-REVENUE-MONTH. 
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-OPEN-CANCEL-REBILL.                                      *         
      *****************************************************************         
       7000-OPEN-CANCEL-REBILL.                                         
                                                                        
           EXEC SQL                                                     
                OPEN CAN_REBILL_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7005-FETCH-CANCEL-REBILL.                                     *         
      *****************************************************************         
       7005-FETCH-CANCEL-REBILL.                                        
                                                                        
           EXEC SQL                                                     
               FETCH CAN_REBILL_CSR                                     
                INTO :BG-ACCOUNT-NO                                     
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-BILL-NO                                        
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-ADJ-REASON-CD                                  
                    ,:BG-DATE-ORIG-BILL                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE WS-YES                  TO WS-NO-MORE-ROWS          
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7010-CLOSE-CANCEL-REBILL.                                     *         
      *****************************************************************         
       7010-CLOSE-CANCEL-REBILL.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE CAN_REBILL_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_BILLING_DET'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BG-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BG-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7015-GET-CNCL-REBIL-CNT                                        *        
      *  GET CANCEL COUNT FOR REBILL CANCELLED ROWS.                   *        
      ******************************************************************        
       7015-GET-CNCL-REBIL-CNT.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT COALESCE(COUNT(*),0)                                
                 INTO :WS-CNCL-REBIL-CNT                                
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO             
                  AND BG.CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE         
                  AND BG.IC_NO             = :BG-IC-NO                  
                  AND BG.REV_MTH_ORIG_BILL = :BG-REV-MTH-ORIG-BILL      
                  AND BG.DATE_ORIG_BILL    = IIF(TRY_CONVERT(DATE, 
                                                     :BG-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL) )         
                  AND BG.CODE_BILL_ITM_IND = 'K'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(COUNT(*),0)                                        
MFA-TR*          INTO :WS-CNCL-REBIL-CNT                                        
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*         WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO                     
MFA-TR*           AND BG.CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE                 
MFA-TR*           AND BG.IC_NO             = :BG-IC-NO                          
MFA-TR*           AND BG.REV_MTH_ORIG_BILL = :BG-REV-MTH-ORIG-BILL              
MFA-TR*           AND BG.DATE_ORIG_BILL    = :BG-DATE-ORIG-BILL                 
MFA-TR*           AND BG.CODE_BILL_ITM_IND = 'K'                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7015'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'REV_MTH_ORIG_BILL'     TO TABLE-ELEMENT-4          
               MOVE BG-REV-MTH-ORIG-BILL    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-GET-CANCEL-REBILL                                         *        
      *                                                                *        
      ******************************************************************        
       7020-GET-CANCEL-REBILL.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT BG.ACCOUNT_NO                                     
                     ,BG.CODE_UTIL_TYPE                                 
                     ,BG.IC_NO                                          
                     ,BG.BILL_NO                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                     ,BG.REV_MTH_ORIG_BILL                              
                 INTO :WS-ACCOUNT-NO                                    
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-IC-NO                                         
                     ,:WS-BILL-NO                                       
                     ,:WS-BILL-ITEM-TIMESTMP                            
                     ,:WS-REVENUE-MONTH                                 
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO             
                  AND BG.CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE         
                  AND BG.IC_NO             = :BG-IC-NO                  
                  AND BG.REV_MTH_ORIG_BILL = :BG-REV-MTH-ORIG-BILL      
                  AND BG.DATE_ORIG_BILL    = IIF(TRY_CONVERT(DATE, 
                                                     :BG-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL) )         
                  AND BG.CODE_BILL_ITM_IND = 'K'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.ACCOUNT_NO                                             
MFA-TR*              ,BG.CODE_UTIL_TYPE                                         
MFA-TR*              ,BG.IC_NO                                                  
MFA-TR*              ,BG.BILL_NO                                                
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*              ,BG.REV_MTH_ORIG_BILL                                      
MFA-TR*          INTO :WS-ACCOUNT-NO                                            
MFA-TR*              ,:WS-CODE-UTIL-TYPE                                        
MFA-TR*              ,:WS-IC-NO                                                 
MFA-TR*              ,:WS-BILL-NO                                               
MFA-TR*              ,:WS-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:WS-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*         WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO                     
MFA-TR*           AND BG.CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE                 
MFA-TR*           AND BG.IC_NO             = :BG-IC-NO                          
MFA-TR*           AND BG.REV_MTH_ORIG_BILL = :BG-REV-MTH-ORIG-BILL              
MFA-TR*           AND BG.DATE_ORIG_BILL    = :BG-DATE-ORIG-BILL                 
MFA-TR*           AND BG.CODE_BILL_ITM_IND = 'K'                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7020'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'REV_MTH_ORIG_BILL'     TO TABLE-ELEMENT-4          
               MOVE BG-REV-MTH-ORIG-BILL    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7025-GET-CANCEL-BILL-CNT                                       *        
      *  GET CANCEL BILL ROW COUNT FOR ORIGINAL CANCELLED ROW          *        
      ******************************************************************        
       7025-GET-CANCEL-BILL-CNT.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT COALESCE(COUNT(*),0)                                
                 INTO :WS-CANCEL-BILL-CNT                               
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                     ,CSS_BILLING_HDR        BI WITH(READUNCOMMITTED)           
                WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO             
                  AND BG.CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE         
                  AND BG.IC_NO             = :BG-IC-NO                  
                  AND BG.REVENUE_MONTH     = :BG-REV-MTH-ORIG-BILL      
                  AND BG.REV_MTH_ORIG_BILL = 0                          
                  AND BG.CODE_BILL_ITM_IND = 'K'                        
                  AND BI.DATE_BILLED       = IIF(TRY_CONVERT(DATE, 
                                                     :BG-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL) )         
                  AND BG.ACCOUNT_NO        = BI.ACCOUNT_NO              
                  AND BG.BILL_NO           = BI.BILL_NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(COUNT(*),0)                                        
MFA-TR*          INTO :WS-CANCEL-BILL-CNT                                       
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*              ,CSS_BILLING_HDR        BI                                 
MFA-TR*         WHERE BG.ACCOUNT_NO        = :BG-ACCOUNT-NO                     
MFA-TR*           AND BG.CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE                 
MFA-TR*           AND BG.IC_NO             = :BG-IC-NO                          
MFA-TR*           AND BG.REVENUE_MONTH     = :BG-REV-MTH-ORIG-BILL              
MFA-TR*           AND BG.REV_MTH_ORIG_BILL = 0                                  
MFA-TR*           AND BG.CODE_BILL_ITM_IND = 'K'                                
MFA-TR*           AND BI.DATE_BILLED       = :BG-DATE-ORIG-BILL                 
MFA-TR*           AND BG.ACCOUNT_NO        = BI.ACCOUNT_NO                      
MFA-TR*           AND BG.BILL_NO           = BI.BILL_NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7025'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'REV_MTH_ORIG_BILL'     TO TABLE-ELEMENT-4          
               MOVE BG-REV-MTH-ORIG-BILL    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-GET-CANCEL-BILL                                           *        
      *                                                                *        
      ******************************************************************        
       7030-GET-CANCEL-BILL.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT BG.ACCOUNT_NO                                     
                     ,BG.CODE_UTIL_TYPE                                 
                     ,BG.IC_NO                                          
                     ,BG.BILL_NO                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                     ,BG.REVENUE_MONTH                                  
                 INTO :WS-ACCOUNT-NO                                    
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-IC-NO                                         
                     ,:WS-BILL-NO                                       
                     ,:WS-BILL-ITEM-TIMESTMP                            
                     ,:WS-REVENUE-MONTH                                 
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                     ,CSS_BILLING_HDR        BI WITH(READUNCOMMITTED)           
                WHERE BG.ACCOUNT_NO       = :BG-ACCOUNT-NO              
                  AND BG.CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE          
                  AND BG.IC_NO            = :BG-IC-NO                   
                  AND BG.REVENUE_MONTH    = :BG-REV-MTH-ORIG-BILL       
                  AND BG.CODE_BILL_ITM_IND = 'K'                        
                  AND BG.REV_MTH_ORIG_BILL = 0                          
                  AND BI.DATE_BILLED       = IIF(TRY_CONVERT(DATE, 
                                                     :BG-DATE-ORIG-BILL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL) )         
                  AND BG.ACCOUNT_NO        = BI.ACCOUNT_NO              
                  AND BG.BILL_NO           = BI.BILL_NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.ACCOUNT_NO                                             
MFA-TR*              ,BG.CODE_UTIL_TYPE                                         
MFA-TR*              ,BG.IC_NO                                                  
MFA-TR*              ,BG.BILL_NO                                                
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*              ,BG.REVENUE_MONTH                                          
MFA-TR*          INTO :WS-ACCOUNT-NO                                            
MFA-TR*              ,:WS-CODE-UTIL-TYPE                                        
MFA-TR*              ,:WS-IC-NO                                                 
MFA-TR*              ,:WS-BILL-NO                                               
MFA-TR*              ,:WS-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:WS-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*              ,CSS_BILLING_HDR        BI                                 
MFA-TR*         WHERE BG.ACCOUNT_NO       = :BG-ACCOUNT-NO                      
MFA-TR*           AND BG.CODE_UTIL_TYPE   = :BG-CODE-UTIL-TYPE                  
MFA-TR*           AND BG.IC_NO            = :BG-IC-NO                           
MFA-TR*           AND BG.REVENUE_MONTH    = :BG-REV-MTH-ORIG-BILL               
MFA-TR*           AND BG.CODE_BILL_ITM_IND = 'K'                                
MFA-TR*           AND BG.REV_MTH_ORIG_BILL = 0                                  
MFA-TR*           AND BI.DATE_BILLED       = :BG-DATE-ORIG-BILL                 
MFA-TR*           AND BG.ACCOUNT_NO        = BI.ACCOUNT_NO                      
MFA-TR*           AND BG.BILL_NO           = BI.BILL_NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'REV_MTH_ORIG_BILL'     TO TABLE-ELEMENT-4          
               MOVE BG-REV-MTH-ORIG-BILL    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7035-CHK-OVERIDE-EXIST.                                        *        
      *                                                                *        
      ******************************************************************        
       7035-CHK-OVERIDE-EXIST.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) BP1.ACCOUNT_NO,
              BP1.CODE_UTIL_TYPE,
              BP1.IC_NO,
              BP1.BILL_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BP1.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,
              BP1.REVENUE_MONTH                                 
                 INTO :WS-ACCOUNT-NO                                    
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-IC-NO                                         
                     ,:WS-BILL-NO                                       
                     ,:WS-BILL-ITEM-TIMESTMP                            
                     ,:WS-REVENUE-MONTH                                 
                 FROM CSS_BILL_ADJUSTMNT     BP WITH(READUNCOMMITTED)           
                     ,CSS_BILL_ADJUSTMNT     BP1 WITH(READUNCOMMITTED)          
                WHERE BP.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BP.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BP.IC_NO              = :BG-IC-NO                 
                  AND BP.BILL_NO            = :BG-BILL-NO               
                  AND BP.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )    
                  AND BP.ADJ_TYPE_CD        = 'RTOV'                    
                  AND BP.ACCOUNT_NO         = BP1.ACCOUNT_NO            
                  AND BP.CODE_UTIL_TYPE     = BP1.CODE_UTIL_TYPE        
                  AND BP.IC_NO              = BP1.IC_NO                 
                  AND BP.BILL_NO            = BP1.BILL_NO               
                  AND BP.BILL_ITEM_TIMESTMP <> BP1.BILL_ITEM_TIMESTMP   
                  AND BP.OVRRIDE_RT_REV_MTH = BP1.OVRRIDE_RT_REV_MTH    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BP1.ACCOUNT_NO                                            
MFA-TR*              ,BP1.CODE_UTIL_TYPE                                        
MFA-TR*              ,BP1.IC_NO                                                 
MFA-TR*              ,BP1.BILL_NO                                               
MFA-TR*              ,BP1.BILL_ITEM_TIMESTMP                                    
MFA-TR*              ,BP1.REVENUE_MONTH                                         
MFA-TR*          INTO :WS-ACCOUNT-NO                                            
MFA-TR*              ,:WS-CODE-UTIL-TYPE                                        
MFA-TR*              ,:WS-IC-NO                                                 
MFA-TR*              ,:WS-BILL-NO                                               
MFA-TR*              ,:WS-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:WS-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_ADJUSTMNT     BP                                 
MFA-TR*              ,CSS_BILL_ADJUSTMNT     BP1                                
MFA-TR*         WHERE BP.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BP.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BP.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BP.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BP.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP            
MFA-TR*           AND BP.ADJ_TYPE_CD        = 'RTOV'                            
MFA-TR*           AND BP.ACCOUNT_NO         = BP1.ACCOUNT_NO                    
MFA-TR*           AND BP.CODE_UTIL_TYPE     = BP1.CODE_UTIL_TYPE                
MFA-TR*           AND BP.IC_NO              = BP1.IC_NO                         
MFA-TR*           AND BP.BILL_NO            = BP1.BILL_NO                       
MFA-TR*           AND BP.BILL_ITEM_TIMESTMP <> BP1.BILL_ITEM_TIMESTMP           
MFA-TR*           AND BP.OVRRIDE_RT_REV_MTH = BP1.OVRRIDE_RT_REV_MTH            
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7035'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILL_ADJUSTMNT'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
               MOVE BG-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-GET-BCKOUT-BILL                                           *        
      *                                                                *        
      ******************************************************************        
       7040-GET-BCKOUT-BILL.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) BG1.ACCOUNT_NO,
              BG1.CODE_UTIL_TYPE,
              BG1.IC_NO,
              BG1.BILL_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BG1.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,
              BG1.REV_MTH_ORIG_BILL                             
                 INTO :WS-ACCOUNT-NO                                    
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-IC-NO                                         
                     ,:WS-BILL-NO                                       
                     ,:WS-BILL-ITEM-TIMESTMP                            
                     ,:WS-REVENUE-MONTH                                 
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                     ,CSS_BILLING_DET        BG1 WITH(READUNCOMMITTED)          
                WHERE BG.ACCOUNT_NO             = :BG-ACCOUNT-NO        
                  AND BG.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE    
                  AND BG.IC_NO                  = :BG-IC-NO             
                  AND BG.BILL_NO                = :BG-BILL-NO           
                  AND BG.REV_MTH_ORIG_BILL      = :BG-REV-MTH-ORIG-BILL 
                  AND BG.BILL_ITEM_TIMESTMP     = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )
                  AND BG1.CODE_BILL_ITM_TYPE    = 'B'                   
                  AND BG.DATE_ORIG_BILL         = BG1.DATE_ORIG_BILL    
                  AND BG.ACCOUNT_NO             = BG1.ACCOUNT_NO        
                  AND BG.CODE_UTIL_TYPE         = BG1.CODE_UTIL_TYPE    
                  AND BG.IC_NO                  = BG1.IC_NO             
                  AND BG.BILL_NO                = BG1.BILL_NO           
                  AND BG.BILL_ITEM_TIMESTMP    <> BG1.BILL_ITEM_TIMESTMP
                  AND BG.REV_MTH_ORIG_BILL      = BG1.REV_MTH_ORIG_BILL 
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG1.ACCOUNT_NO                                            
MFA-TR*              ,BG1.CODE_UTIL_TYPE                                        
MFA-TR*              ,BG1.IC_NO                                                 
MFA-TR*              ,BG1.BILL_NO                                               
MFA-TR*              ,BG1.BILL_ITEM_TIMESTMP                                    
MFA-TR*              ,BG1.REV_MTH_ORIG_BILL                                     
MFA-TR*          INTO :WS-ACCOUNT-NO                                            
MFA-TR*              ,:WS-CODE-UTIL-TYPE                                        
MFA-TR*              ,:WS-IC-NO                                                 
MFA-TR*              ,:WS-BILL-NO                                               
MFA-TR*              ,:WS-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:WS-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*              ,CSS_BILLING_DET        BG1                                
MFA-TR*         WHERE BG.ACCOUNT_NO             = :BG-ACCOUNT-NO                
MFA-TR*           AND BG.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE            
MFA-TR*           AND BG.IC_NO                  = :BG-IC-NO                     
MFA-TR*           AND BG.BILL_NO                = :BG-BILL-NO                   
MFA-TR*           AND BG.REV_MTH_ORIG_BILL      = :BG-REV-MTH-ORIG-BILL         
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP     = :BG-BILL-ITEM-TIMESTMP        
MFA-TR*           AND BG1.CODE_BILL_ITM_TYPE    = 'B'                           
MFA-TR*           AND BG.DATE_ORIG_BILL         = BG1.DATE_ORIG_BILL            
MFA-TR*           AND BG.ACCOUNT_NO             = BG1.ACCOUNT_NO                
MFA-TR*           AND BG.CODE_UTIL_TYPE         = BG1.CODE_UTIL_TYPE            
MFA-TR*           AND BG.IC_NO                  = BG1.IC_NO                     
MFA-TR*           AND BG.BILL_NO                = BG1.BILL_NO                   
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP    <> BG1.BILL_ITEM_TIMESTMP        
MFA-TR*           AND BG.REV_MTH_ORIG_BILL      = BG1.REV_MTH_ORIG_BILL         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7040'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'REV_MTH_ORIG_BILL'     TO TABLE-ELEMENT-4          
               MOVE BG-REV-MTH-ORIG-BILL    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7045-GET-CNCL-BILL-FOR-BCK-ROW                                 *        
      *                                                                *        
      ******************************************************************        
       7045-GET-CNCL-BILL-FOR-BCK-ROW.                                  
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) BG.ACCOUNT_NO,
              BG.CODE_UTIL_TYPE,
              BG.IC_NO,
              BG.BILL_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), BG.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,
              BG.REVENUE_MONTH,
              BG.REV_MTH_ORIG_BILL                              
                 INTO :WS-ACCOUNT-NO                                    
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-IC-NO                                         
                     ,:WS-BILL-NO                                       
                     ,:WS-BILL-ITEM-TIMESTMP                            
                     ,:WS-REVENUE-MONTH                                 
                     ,:WS-ORIG-REVENUE-MONTH                            
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                WHERE BG.ACCOUNT_NO             = :WS-ACCOUNT-NO        
                  AND BG.CODE_UTIL_TYPE         = :WS-CODE-UTIL-TYPE    
                  AND BG.IC_NO                  = :WS-IC-NO             
                  AND BG.BILL_NO               <> :WS-BILL-NO           
                  AND BG.BILL_ITEM_TIMESTMP     = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )
                  AND ((BG.REVENUE_MONTH        = :WS-REVENUE-MONTH     
                  AND BG.REV_MTH_ORIG_BILL      = 0)                    
                   OR BG.REV_MTH_ORIG_BILL      = :WS-REVENUE-MONTH )   
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.ACCOUNT_NO                                             
MFA-TR*              ,BG.CODE_UTIL_TYPE                                         
MFA-TR*              ,BG.IC_NO                                                  
MFA-TR*              ,BG.BILL_NO                                                
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*              ,BG.REVENUE_MONTH                                          
MFA-TR*              ,BG.REV_MTH_ORIG_BILL                                      
MFA-TR*          INTO :WS-ACCOUNT-NO                                            
MFA-TR*              ,:WS-CODE-UTIL-TYPE                                        
MFA-TR*              ,:WS-IC-NO                                                 
MFA-TR*              ,:WS-BILL-NO                                               
MFA-TR*              ,:WS-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:WS-REVENUE-MONTH                                         
MFA-TR*              ,:WS-ORIG-REVENUE-MONTH                                    
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*         WHERE BG.ACCOUNT_NO             = :WS-ACCOUNT-NO                
MFA-TR*           AND BG.CODE_UTIL_TYPE         = :WS-CODE-UTIL-TYPE            
MFA-TR*           AND BG.IC_NO                  = :WS-IC-NO                     
MFA-TR*           AND BG.BILL_NO               <> :WS-BILL-NO                   
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP     = :WS-BILL-ITEM-TIMESTMP        
MFA-TR*           AND ((BG.REVENUE_MONTH        = :WS-REVENUE-MONTH             
MFA-TR*           AND BG.REV_MTH_ORIG_BILL      = 0)                            
MFA-TR*            OR BG.REV_MTH_ORIG_BILL      = :WS-REVENUE-MONTH )           
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-ORIG-REVENUE-MONTH > 0                             
                  MOVE WS-ORIG-REVENUE-MONTH                            
                                            TO WS-REVENUE-MONTH         
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7045'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-4          
               MOVE BG-REV-MTH-ORIG-BILL    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-GET-BCKOUT-BILL-ADJ                                       *        
      *                                                                *        
      ******************************************************************        
       7050-GET-BCKOUT-BILL-ADJ.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT BG.ADJ_REASON_CD                                  
                 INTO :BG-ADJ-REASON-CD                                 
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.IC_NO              = :BG-IC-NO                 
                  AND BG.BILL_NO            = :BG-BILL-NO               
                  AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.ADJ_REASON_CD                                          
MFA-TR*          INTO :BG-ADJ-REASON-CD                                         
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-4          
               MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7055-BILL-ADJ-REASON.                                          *        
      ******************************************************************        
       7055-BILL-ADJ-REASON.                                            
                                                                        
           EXEC SQL                                                     
               SELECT BP.ADJ_REASON_DESC                                
                 INTO :BP-ADJ-REASON-DESC                               
                 FROM CSS_BILL_ADJUSTMNT BP WITH(READUNCOMMITTED)               
                WHERE BP.ACCOUNT_NO         = :BP-ACCOUNT-NO            
                  AND BP.BILL_NO            = :BP-BILL-NO               
                  AND BP.CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE        
                  AND BP.IC_NO              = :BP-IC-NO                 
                  AND BP.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BP-BILL-ITEM-TIMESTMP
              )    
                  AND BP.ADJ_TYPE_CD        = :BP-ADJ-TYPE-CD           
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BP.ADJ_REASON_DESC                                        
MFA-TR*          INTO :BP-ADJ-REASON-DESC                                       
MFA-TR*          FROM CSS_BILL_ADJUSTMNT BP                                     
MFA-TR*         WHERE BP.ACCOUNT_NO         = :BP-ACCOUNT-NO                    
MFA-TR*           AND BP.BILL_NO            = :BP-BILL-NO                       
MFA-TR*           AND BP.CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE                
MFA-TR*           AND BP.IC_NO              = :BP-IC-NO                         
MFA-TR*           AND BP.BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP            
MFA-TR*           AND BP.ADJ_TYPE_CD        = :BP-ADJ-TYPE-CD                   
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7055                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO BP-ADJ-REASON-DESC-TEXT  
                 MOVE ZEROES                TO BP-ADJ-REASON-DESC-LEN   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7055'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_ADJUSTMENT'    TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'BILL_NO'                TO TABLE-ELEMENT-2          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-4          
              MOVE BP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE BP-BILL-NO               TO HOSTVAR-ELEMENT-2        
              MOVE BP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3        
              MOVE BP-IC-NO                 TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-BILL-ADJ-REASON-FMT.                                      *        
      ******************************************************************        
       7060-BILL-ADJ-REASON-FMT.                                        
                                                                        
           EXEC SQL                                                     
               SELECT K0.ADJ_REASON_DESC                                
                 INTO :K0-ADJ-REASON-DESC                               
                 FROM CSS_BILL_ADJ_REASN K0 WITH(READUNCOMMITTED)               
                WHERE K0.ADJ_REASON_CD      = :K0-ADJ-REASON-CD         
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT K0.ADJ_REASON_DESC                                        
MFA-TR*          INTO :K0-ADJ-REASON-DESC                                       
MFA-TR*          FROM CSS_BILL_ADJ_REASN K0                                     
MFA-TR*         WHERE K0.ADJ_REASON_CD      = :K0-ADJ-REASON-CD                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO K0-ADJ-REASON-DESC       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7060'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_ADJ_REASN'     TO TABLE-1                  
              MOVE 'ADJ_REASON_CD'          TO TABLE-ELEMENT-1          
              MOVE K0-ADJ-REASON-CD         TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7065-GET-ACTV-BILL-KEY                                         *        
      *                                                                *        
      ******************************************************************        
       7065-GET-ACTV-BILL-KEY.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                 INTO :BG-BILL-ITEM-TIMESTMP                            
                 FROM CSS_BILLING_DET        BG WITH(READUNCOMMITTED)           
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.IC_NO              = :BG-IC-NO                 
                  AND BG.BILL_NO            = :BG-BILL-NO               
                  AND BG.DATE_ORIG_BILL     IS NULL                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*          INTO :BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*          FROM CSS_BILLING_DET        BG                                 
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BG.DATE_ORIG_BILL     IS NULL                             
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET IC-HAS-NO-CNSMPTN       TO TRUE                    
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7065'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-4          
               MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7065-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK TO SEE IF UNMETERED ACCOUNT EXISTS WITH UTIL TYPE E OR G *        
      ******************************************************************        
       7070-CUST-PLAN-EXISTS.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT  'N'                                              
                 INTO  :WS-MTRD-IC                                      
                 FROM  CSS_CUST_PLAN  CP WITH(READUNCOMMITTED)                  
                WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                  
                  AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE              
                  AND  IC_NO          = :CP-IC-NO                       
                  AND  CODE_UTIL_TYPE IN ('E', 'G')                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'N'                                                      
MFA-TR*          INTO  :WS-MTRD-IC                                              
MFA-TR*          FROM  CSS_CUST_PLAN  CP                                        
MFA-TR*         WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                      
MFA-TR*           AND  IC_NO          = :CP-IC-NO                               
MFA-TR*           AND  CODE_UTIL_TYPE IN ('E', 'G')                             
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CUST_PLAN'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CHECK TO SEE IF METERED ACCOUNT HAS CONSUMPTION EXISTS         *        
      ******************************************************************        
       7080-METERED-CNSMPTN.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-IC-HAS-CNSMPTN                                
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND BILL_NO            = :CX-BILL-NO                  
                  AND IC_NO              = :CX-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                  AND CODE_ITEM_STATUS IN ( 'A' , 'T')                  
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-IC-HAS-CNSMPTN                                        
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND BILL_NO            = :CX-BILL-NO                          
MFA-TR*           AND IC_NO              = :CX-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*           AND CODE_ITEM_STATUS IN ( 'A' , 'T')                          
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET IC-HAS-NO-CNSMPTN       TO TRUE                    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CHECK TO SEE IF UNMTRD ACCOUNT HAS CONSUMPTION EXISTS          *        
      ******************************************************************        
       7090-UNMTRD-CNSMPTN.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-IC-HAS-CNSMPTN                                
                 FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE           
                  AND BILL_NO            = :UC-BILL-NO                  
                  AND IC_NO              = :UC-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-IC-HAS-CNSMPTN                                        
MFA-TR*          FROM CSS_UM_CNSMPT_HIST                                        
MFA-TR*         WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE                   
MFA-TR*           AND BILL_NO            = :UC-BILL-NO                          
MFA-TR*           AND IC_NO              = :UC-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET IC-HAS-NO-CNSMPTN       TO TRUE                    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UM_CNSMPT_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE UC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UC-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7090-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04726_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04726_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-1.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-1         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04726_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04726_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04726_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-2.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04726_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   OFFER CODE TABLE                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04726_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ACCOUNT_NO                                           
                  ,RE_CODE_UTIL_TYPE                                    
                  ,RE_IC_NO                                             
                  ,RE_BILL_NO                                           
                  ,RE_BILL_ITEM_TS                                      
                  ,RE_ADJ_REASON_CD                                     
                  ,RE_ADJ_REASON_TEXT                                   
                  ,CAN_CODE_UTIL_TYPE                                   
                  ,CAN_IC_NO                                            
                  ,CAN_BILL_NO                                          
                  ,CAN_BILL_ITEM_TS                                     
                  ,CAN_REVENUE_MONTH                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-ACCOUNT-NO                                    
                  ,:S-RS1-RE-CODE-UTIL-TYPE                             
                  ,:S-RS1-RE-IC-NO                                      
                  ,:S-RS1-RE-BILL-NO                                    
                  ,:S-RS1-RE-BILL-ITEM-TS                               
                  ,:S-RS1-RE-ADJ-REASON-CD                              
                  ,:S-RS1-RE-ADJ-REASON-TEXT                            
                  ,:S-RS1-CAN-CODE-UTIL-TYPE                            
                  ,:S-RS1-CAN-IC-NO                                     
                  ,:S-RS1-CAN-BILL-NO                                   
                  ,:S-RS1-CAN-BILL-ITEM-TS                              
                  ,:S-RS1-CAN-REVENUE-MONTH                             
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04726_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,RE_CODE_UTIL_TYPE                                            
MFA-TR*           ,RE_IC_NO                                                     
MFA-TR*           ,RE_BILL_NO                                                   
MFA-TR*           ,RE_BILL_ITEM_TS                                              
MFA-TR*           ,RE_ADJ_REASON_CD                                             
MFA-TR*           ,RE_ADJ_REASON_TEXT                                           
MFA-TR*           ,CAN_CODE_UTIL_TYPE                                           
MFA-TR*           ,CAN_IC_NO                                                    
MFA-TR*           ,CAN_BILL_NO                                                  
MFA-TR*           ,CAN_BILL_ITEM_TS                                             
MFA-TR*           ,CAN_REVENUE_MONTH                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-ACCOUNT-NO                                            
MFA-TR*           ,:S-RS1-RE-CODE-UTIL-TYPE                                     
MFA-TR*           ,:S-RS1-RE-IC-NO                                              
MFA-TR*           ,:S-RS1-RE-BILL-NO                                            
MFA-TR*           ,:S-RS1-RE-BILL-ITEM-TS                                       
MFA-TR*           ,:S-RS1-RE-ADJ-REASON-CD                                      
MFA-TR*           ,:S-RS1-RE-ADJ-REASON-TEXT                                    
MFA-TR*           ,:S-RS1-CAN-CODE-UTIL-TYPE                                    
MFA-TR*           ,:S-RS1-CAN-IC-NO                                             
MFA-TR*           ,:S-RS1-CAN-BILL-NO                                           
MFA-TR*           ,:S-RS1-CAN-BILL-ITEM-TS                                      
MFA-TR*           ,:S-RS1-CAN-REVENUE-MONTH                                     
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-YES          
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE WS-YES                   TO  WS-ERR-INSRT-R1         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04726_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04726_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-BUS-RULE-ID                                   
                  ,:S-RS2-BUS-RULE-RESULT-CD                            
                  ,:S-RS2-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04726_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS2-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS2-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-2.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = WS-YES          
              ADD +1                        TO  CTR-ROWS-RS2            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8020'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE WS-YES                   TO  WS-ERR-INSRT-R2         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04726_R2'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                      TO S-RETURN-CODE-2          
              MOVE 100                      TO S-APPL-RETURN-CODE-2     
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04726_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                S-RETURN-CODE-2.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04726_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS         THRU 8800-EXIT           
            PERFORM 8900-SEND-DONE             THRU 8900-EXIT           
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
