       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04722.                                      
       AUTHOR.        AMIRTHARAJ D.                                     
COB303 DATE-WRITTEN.     MARCH 31, 2014.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:   CSR04722             --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--   CSR04722 :                                               --         
      *--                                                            --         
      *--  UPDATE TAX RATE DETAILS THROUGH TAX MANAGE TAX SCREEN.    --         
      *--                                                            --         
      *--  CLONED FROM PCSRT056.                                     --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                               --         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--           ACTION_CODE        CHAR(01)                      --         
      *--           TAX_CNTL_NO        SMALLINT                      --         
      *--           TAX_ENTRY_SEQ_NO   SMALLINT                      --         
      *--           DETAIL_ID          CHAR(03)                      --         
      *--           DATE_FROM          CHAR(10)                      --         
      *--           DATE_TO            CHAR(10)                      --         
      *--           TAX_RATE           DECIMAL(5,4)                  --         
      *--           CODE_TAX_CALC_INST CHAR(01)                      --         
      *--           LAST_UPDT_USER_ID  CHAR(07)                      --         
      *--           TAX_ELEC           CHAR(01)                      --         
      *--           TAX_GAS            CHAR(01)                      --         
      *--           TAX_MDSE           CHAR(01)                      --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      *--   CSR04722_R1 - BUS RULE DETAILS.                          --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,BUS_RULE_ID            CHAR(10)                  --         
      *--          ,BUS_RULE_RESULT_CD     CHAR(10)                  --         
      *--          ,BUS_RULE_XREF_ID       CHAR(26)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  03/31/2014    AD7F921     UPDATE TAX RATE.                --         
      *--                                                            --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04722'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(60) VALUE                    
            'WORKING STORAGE FOR  CSR04722 STARTS HERE'.                
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04722'. 
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(4) COMP VALUE 0.     
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-MAX-SEQ-NO                PIC S9(4) COMP VALUE 0.     
           05  WS-NEW-SEQ-NO                PIC S9(4) COMP VALUE 0.     
           05  WS-DETAIL-COUNT              PIC S9(4) COMP VALUE 0.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  WS-TAX-CNTRL-NO              PIC S9(4) COMP VALUE 0.     
           05  WS-TAX-ENTRY-SEQ-NO          PIC S9(4) COMP VALUE 0.     
           05  WS-DATE-FROM                 PIC X(10) VALUE SPACES.     
           05  WS-DATE-TO                   PIC X(10) VALUE SPACES.     
           05  WS-CODE-TAX-CALC-INST        PIC X(01) VALUE SPACES.     
           05  WS-TAX-ELEC                  PIC X(01) VALUE SPACES.     
           05  WS-TAX-GAS                   PIC X(01) VALUE SPACES.     
           05  WS-TAX-MDSE                  PIC X(01) VALUE SPACES.     
           05  WS-TAX-RATE-OL-FLAG          PIC X(01) VALUE SPACES.     
           05  WS-TAX-RATE-COUNT            PIC S9(4) COMP VALUE 0.     
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-FAILED                    PIC X(01) VALUE 'F'.        
           05  WS-A                         PIC X(01) VALUE 'A'.        
           05  WS-01                        PIC S9(4) COMP VALUE 1.     
           05  WS-ZERO                      PIC S9(4) COMP VALUE 0.     
                                                                        
        01 SWITCHES.                                                    
           05 WS-ACTION-CODE                PIC X(01) VALUE SPACES.     
              88 INSERT-TAX                           VALUE 'I'.        
              88 UPDATE-TAX                           VALUE 'U'.        
              88 DELETE-TAX                           VALUE 'D'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE         *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS1-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS1-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TAX_USE_CNTL   TU                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXUSE                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TAX_RATE       TR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXRATE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TAX_CNTL       TC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
       LINKAGE SECTION.                                                 
       01 I-ACTION-CODE         PIC X(01).                              
       01 I-TAX-CNTL-NO         PIC S9(4)   USAGE COMP.                 
       01 I-TAX-ENTRY-SEQ-NO    PIC S9(4)   USAGE COMP.                 
       01 I-DETAIL-ID           PIC X(03).                              
       01 I-DATE-FROM           PIC X(10).                              
       01 I-DATE-TO             PIC X(10).                              
COB305 01 I-TAX-RATE        PIC S9(1)V9(4) USAGE COMP-3 VALUE 0.            
       01 I-CODE-TAX-CALC-INST  PIC X(01).                              
       01 I-LAST-UPDT-USER-ID   PIC X(07).                              
       01 I-TAX-ELEC            PIC X(01).                              
       01 I-TAX-GAS             PIC X(01).                              
       01 I-TAX-MDSE            PIC X(01).                              
                                                                        
       PROCEDURE DIVISION USING I-ACTION-CODE                           
                                I-TAX-CNTL-NO                           
                                I-TAX-ENTRY-SEQ-NO                      
                                I-DETAIL-ID                             
                                I-DATE-FROM                             
                                I-DATE-TO                               
                                I-TAX-RATE                              
                                I-CODE-TAX-CALC-INST                    
                                I-LAST-UPDT-USER-ID                     
                                I-TAX-ELEC                              
                                I-TAX-GAS                               
                                I-TAX-MDSE.                             
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04722_R1'      TO WS-GTT-NAME.              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04722_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04722_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04722_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04722_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-ACTION-CODE                TO WS-ACTION-CODE.         
      *                                                                         
           MOVE I-TAX-CNTL-NO                TO TC-TAX-CNTRL-NO         
                                                TR-TAX-CNTRL-NO         
                                                TU-TAX-CNTRL-NO.        
                                                                        
           MOVE WS-A                         TO TC-OPER-MODE            
                                                TR-OPER-MODE            
                                                TU-OPER-MODE.           
                                                                        
           MOVE I-TAX-ENTRY-SEQ-NO           TO TR-TAX-ENTRY-SEQ-NO     
                                                TU-TAX-ENTRY-SEQ-NO.    
                                                                        
           MOVE I-DETAIL-ID                  TO TR-DETAIL-ID            
                                                TU-DETAIL-ID.           
                                                                        
           MOVE I-DATE-FROM                  TO TR-DATE-FROM.           
           MOVE I-DATE-TO                    TO TR-DATE-TO.             
           MOVE I-TAX-RATE                   TO TR-TAX-RATE.            
                                                                        
           MOVE I-CODE-TAX-CALC-INST         TO TU-CODE-TAX-CALC-INST.  
                                                                        
           MOVE I-LAST-UPDT-USER-ID          TO TR-LAST-UPDATE-USERID   
                                                TU-LAST-UPDATE-USERID.  
                                                                        
           MOVE I-TAX-ELEC                   TO TU-TAX-ELEC.            
           MOVE I-TAX-GAS                    TO TU-TAX-GAS.             
           MOVE I-TAX-MDSE                   TO TU-TAX-MDSE.            
                                                                        
           MOVE 'N'                          TO TU-TAX-WATER            
                                                TU-TAX-SEWER            
                                                TU-TAX-TRASH.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-MANAGE-TAX-RATE        THRU 2100-EXIT.          
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-MANAGE-TAX-RATE.                                          *        
      ******************************************************************        
       2100-MANAGE-TAX-RATE.                                            
                                                                        
           EVALUATE TRUE                                                
              WHEN INSERT-TAX                                           
               PERFORM 2200-INSERT-TAX-RATE        THRU 2200-EXIT       
              WHEN UPDATE-TAX                                           
               PERFORM 2300-UPDATE-TAX-RATE        THRU 2300-EXIT       
              WHEN DELETE-TAX                                           
               PERFORM 2400-DELETE-TAX-RATE        THRU 2400-EXIT       
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-INSERT-TAX-RATE.                                          *        
      ******************************************************************        
       2200-INSERT-TAX-RATE.                                            
                                                                        
           PERFORM 7000-CHECK-TUCNTL-EXIST        THRU 7000-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              MOVE WS-TAX-ENTRY-SEQ-NO      TO TU-TAX-ENTRY-SEQ-NO      
                                               TR-TAX-ENTRY-SEQ-NO      
                                                                        
              IF (WS-CODE-TAX-CALC-INST  NOT = TU-CODE-TAX-CALC-INST    
                   OR WS-TAX-ELEC        NOT = TU-TAX-ELEC              
                   OR WS-TAX-GAS         NOT = TU-TAX-GAS               
                   OR WS-TAX-MDSE        NOT = TU-TAX-MDSE)             
                 PERFORM 7005-UPDATE-TAX-USE-CNTL THRU 7005-EXIT        
              END-IF                                                    
                                                                        
              PERFORM 2235-TAX-RATE-VALIDATION THRU 2235-EXIT           
           ELSE                                                         
              PERFORM 2230-GET-NEW-SEQ-NO         THRU 2230-EXIT        
              PERFORM 7020-INSERT-TAX-USE-CNTL    THRU 7020-EXIT        
              PERFORM 7030-INSERT-TAX-RATE        THRU 7030-EXIT        
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2230-GET-NEW-SEQ-NO.                                           *        
      ******************************************************************        
       2230-GET-NEW-SEQ-NO.                                             
                                                                        
           PERFORM 7010-GET-MAX-SEQ-NO      THRU 7010-EXIT.             
           COMPUTE WS-NEW-SEQ-NO         = WS-MAX-SEQ-NO + 1.           
           MOVE WS-NEW-SEQ-NO            TO TU-TAX-ENTRY-SEQ-NO         
                                            TR-TAX-ENTRY-SEQ-NO.        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2235-TAX-RATE-VALIDATION.                                      *        
      ******************************************************************        
       2235-TAX-RATE-VALIDATION.                                        
                                                                        
           PERFORM 7025-GET-TAX-RATE              THRU 7025-EXIT.       
                                                                        
      * CHECK FOR DATE OVERLAP IN TAX_RATE - WARNING MESSAGE                    
           IF TR-DATE-FROM NOT EQUAL WS-DATE-FROM                       
              MOVE 'TXR0000004'             TO S-RS1-BUS-RULE-ID        
              IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID                          
                                                  THRU 7550-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7030-INSERT-TAX-RATE           THRU 7030-EXIT.       
                                                                        
       2235-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-UPDATE-TAX-RATE.                                          *        
      ******************************************************************        
       2300-UPDATE-TAX-RATE.                                            
                                                                        
           PERFORM 2350-END-DATE-VALIDATION    THRU 2350-EXIT.          
           PERFORM 7050-UPDATE-TAX-RATE        THRU 7050-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2350-END-DATE-VALIDATION.                                      *        
      ******************************************************************        
       2350-END-DATE-VALIDATION.                                        
                                                                        
           PERFORM 7055-GET-OVERLAP-TAX-RATE   THRU 7055-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'TXR0000018'             TO S-RS1-BUS-RULE-ID        
              MOVE WS-FAILED                TO                          
                                      S-RS1-BUS-RULE-RESULT-CD          
              IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7550-GET-RULE-XREF-ID  THRU 7550-EXIT          
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-DELETE-TAX-RATE.                                          *        
      ******************************************************************        
       2400-DELETE-TAX-RATE.                                            
                                                                        
           PERFORM 7060-GET-TAX-RATE-COUNT     THRU 7060-EXIT           
           IF WS-TAX-RATE-COUNT = WS-01                                 
              PERFORM 7070-DELETE-TAX-USE-CNTL THRU 7070-EXIT           
           ELSE                                                         
              PERFORM 7080-DELETE-TAX-RATE     THRU 7080-EXIT           
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-CHECK-TUCNTL-EXIST.                                       *        
      ******************************************************************        
       7000-CHECK-TUCNTL-EXIST.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) TU.TAX_ENTRY_SEQ_NO,
              TU.CODE_TAX_CALC_INST,
              TU.TAX_ELEC,
              TU.TAX_GAS,
              TU.TAX_MDSE                                      
                  INTO :WS-TAX-ENTRY-SEQ-NO                             
                      ,:WS-CODE-TAX-CALC-INST                           
                      ,:WS-TAX-ELEC                                     
                      ,:WS-TAX-GAS                                      
                      ,:WS-TAX-MDSE                                     
                  FROM CSS_TAX_USE_CNTL    TU WITH(READUNCOMMITTED)             
                 WHERE TU.TAX_CNTRL_NO       = :TU-TAX-CNTRL-NO         
                   AND TU.DETAIL_ID          = :TU-DETAIL-ID            
                   AND TU.OPER_MODE          = :WS-A                    
                 ORDER BY TU.TAX_ENTRY_SEQ_NO DESC                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT TU.TAX_ENTRY_SEQ_NO                                      
MFA-TR*               ,TU.CODE_TAX_CALC_INST                                    
MFA-TR*               ,TU.TAX_ELEC                                              
MFA-TR*               ,TU.TAX_GAS                                               
MFA-TR*               ,TU.TAX_MDSE                                              
MFA-TR*           INTO :WS-TAX-ENTRY-SEQ-NO                                     
MFA-TR*               ,:WS-CODE-TAX-CALC-INST                                   
MFA-TR*               ,:WS-TAX-ELEC                                             
MFA-TR*               ,:WS-TAX-GAS                                              
MFA-TR*               ,:WS-TAX-MDSE                                             
MFA-TR*           FROM CSS_TAX_USE_CNTL    TU                                   
MFA-TR*          WHERE TU.TAX_CNTRL_NO       = :TU-TAX-CNTRL-NO                 
MFA-TR*            AND TU.DETAIL_ID          = :TU-DETAIL-ID                    
MFA-TR*            AND TU.OPER_MODE          = :WS-A                            
MFA-TR*          ORDER BY TU.TAX_ENTRY_SEQ_NO DESC                              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_TAX_USE_CNTL'       TO TABLE-1                  
              MOVE 'OPER_MODE'              TO TABLE-ELEMENT-1          
              MOVE 'TAX_CNTRL_NO'           TO TABLE-ELEMENT-2          
              MOVE 'TAX_DETAIL_ID'          TO TABLE-ELEMENT-3          
              MOVE TU-OPER-MODE             TO HOSTVAR-ELEMENT-1        
              MOVE TU-TAX-CNTRL-NO          TO HOSTVAR-ELEMENT-2        
              MOVE TU-DETAIL-ID             TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7005-UPDATE-TAX-USE-CNTL.                                      *        
      ******************************************************************        
       7005-UPDATE-TAX-USE-CNTL.                                        
                                                                        
           EXEC SQL                                                     
                UPDATE TU                               
                SET TU.CODE_TAX_CALC_INST = :TU-CODE-TAX-CALC-INST      
                   ,TU.TAX_ELEC           = :TU-TAX-ELEC                
                   ,TU.TAX_GAS            = :TU-TAX-GAS                 
                   ,TU.TAX_MDSE           = :TU-TAX-MDSE                
                   ,TU.LAST_UPDATE_USERID = :TU-LAST-UPDATE-USERID      
                FROM CSS_TAX_USE_CNTL TU
                WHERE TU.OPER_MODE        = :TU-OPER-MODE               
                  AND TU.TAX_CNTRL_NO     = :TU-TAX-CNTRL-NO            
                  AND TU.TAX_ENTRY_SEQ_NO = :TU-TAX-ENTRY-SEQ-NO        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_TAX_USE_CNTL      TU                                 
MFA-TR*         SET TU.CODE_TAX_CALC_INST = :TU-CODE-TAX-CALC-INST              
MFA-TR*            ,TU.TAX_ELEC           = :TU-TAX-ELEC                        
MFA-TR*            ,TU.TAX_GAS            = :TU-TAX-GAS                         
MFA-TR*            ,TU.TAX_MDSE           = :TU-TAX-MDSE                        
MFA-TR*            ,TU.LAST_UPDATE_USERID = :TU-LAST-UPDATE-USERID              
MFA-TR*         WHERE TU.OPER_MODE        = :TU-OPER-MODE                       
MFA-TR*           AND TU.TAX_CNTRL_NO     = :TU-TAX-CNTRL-NO                    
MFA-TR*           AND TU.TAX_ENTRY_SEQ_NO = :TU-TAX-ENTRY-SEQ-NO                
MFA-TR*       QUERYNO 7005                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_TAX_USE_CNTL'       TO TABLE-1                  
              MOVE 'OPER_MODE'              TO TABLE-ELEMENT-1          
              MOVE 'TAX_CNTRL_NO'           TO TABLE-ELEMENT-2          
              MOVE 'TAX_ENTRY_SEQ_NO'       TO TABLE-ELEMENT-3          
              MOVE TU-OPER-MODE             TO HOSTVAR-ELEMENT-1        
              MOVE TU-TAX-CNTRL-NO          TO HOSTVAR-ELEMENT-2        
              MOVE TU-TAX-ENTRY-SEQ-NO      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-GET-MAX-SEQ-NO.                                           *        
      ******************************************************************        
       7010-GET-MAX-SEQ-NO.                                             
                                                                        
           EXEC SQL                                                     
                SELECT COALESCE(MAX(TU.TAX_ENTRY_SEQ_NO),0)                
                  INTO :WS-MAX-SEQ-NO                                   
                  FROM CSS_TAX_USE_CNTL   TU WITH(READUNCOMMITTED)              
                 WHERE TU.TAX_CNTRL_NO  = :TU-TAX-CNTRL-NO              
                   AND TU.OPER_MODE     = 'A'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT VALUE(MAX(TU.TAX_ENTRY_SEQ_NO),0)                        
MFA-TR*           INTO :WS-MAX-SEQ-NO                                           
MFA-TR*           FROM CSS_TAX_USE_CNTL   TU                                    
MFA-TR*          WHERE TU.TAX_CNTRL_NO  = :TU-TAX-CNTRL-NO                      
MFA-TR*            AND TU.OPER_MODE     = 'A'                                   
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_USE_CNTL'    TO TABLE-1                     
              MOVE 'TAX_CNTL_NO'         TO TABLE-ELEMENT-1             
              MOVE TU-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'OPER_MODE'           TO TABLE-ELEMENT-2             
              MOVE TU-OPER-MODE          TO HOSTVAR-ELEMENT-2           
              MOVE 'DETAIL_ID'           TO TABLE-ELEMENT-3             
              MOVE TU-DETAIL-ID          TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-INSERT-TAX-USE-CNTL.                                      *        
      ******************************************************************        
       7020-INSERT-TAX-USE-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_TAX_USE_CNTL                              
                ( OPER_MODE                                             
                 ,TAX_CNTRL_NO                                          
                 ,TAX_ENTRY_SEQ_NO                                      
                 ,DETAIL_ID                                             
                 ,CODE_TAX_CALC_INST                                    
                 ,TAX_ELEC                                              
                 ,TAX_GAS                                               
                 ,TAX_MDSE                                              
                 ,TAX_WATER                                             
                 ,TAX_SEWER                                             
                 ,TAX_TRASH                                             
                 ,LAST_UPDATE_USERID                                    
                )                                                       
              VALUES                                                    
                ( :TU-OPER-MODE                                         
                 ,:TU-TAX-CNTRL-NO                                      
                 ,:TU-TAX-ENTRY-SEQ-NO                                  
                 ,:TU-DETAIL-ID                                         
                 ,:TU-CODE-TAX-CALC-INST                                
                 ,:TU-TAX-ELEC                                          
                 ,:TU-TAX-GAS                                           
                 ,:TU-TAX-MDSE                                          
                 ,:TU-TAX-WATER                                         
                 ,:TU-TAX-SEWER                                         
                 ,:TU-TAX-TRASH                                         
                 ,:TU-LAST-UPDATE-USERID                                
                )                                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7020'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_TAX_USE_CNTL'                                   
                                       TO TABLE-1                       
              MOVE 'TAX_CNTRL_NO'      TO TABLE-ELEMENT-1               
              MOVE 'TAX_ENTRY_SEQ_NO'  TO TABLE-ELEMENT-2               
              MOVE 'OPER_MODE'         TO TABLE-ELEMENT-3               
              MOVE TU-TAX-CNTRL-NO     TO HOSTVAR-ELEMENT-1             
              MOVE TU-TAX-ENTRY-SEQ-NO TO HOSTVAR-ELEMENT-2             
              MOVE TU-OPER-MODE        TO HOSTVAR-ELEMENT-3             
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7025-GET-TAX-RATE.                                             *        
      ******************************************************************        
       7025-GET-TAX-RATE.                                               
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) TR.TAX_CNTRL_NO,
              TR.TAX_ENTRY_SEQ_NO,
              TR.DATE_FROM,
              TR.DATE_TO                                       
                  INTO :WS-TAX-CNTRL-NO                                 
                      ,:WS-TAX-ENTRY-SEQ-NO                             
                      ,:WS-DATE-FROM                                    
                      ,:WS-DATE-TO                                      
                  FROM CSS_TAX_RATE           TR WITH(READUNCOMMITTED)          
                 WHERE TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO           
                   AND TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO       
                   AND TR.OPER_MODE        = :WS-A                      
                   AND (                                                
                   TR.DATE_FROM BETWEEN IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) ) AND 
              IIF(TRY_CONVERT(DATE, :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )   
                   OR                                                   
                   TR.DATE_TO   BETWEEN IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) ) AND 
              IIF(TRY_CONVERT(DATE, :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )   
                       )                                                
                 ORDER BY TR.DATE_FROM DESC                             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT TR.TAX_CNTRL_NO                                          
MFA-TR*               ,TR.TAX_ENTRY_SEQ_NO                                      
MFA-TR*               ,TR.DATE_FROM                                             
MFA-TR*               ,TR.DATE_TO                                               
MFA-TR*           INTO :WS-TAX-CNTRL-NO                                         
MFA-TR*               ,:WS-TAX-ENTRY-SEQ-NO                                     
MFA-TR*               ,:WS-DATE-FROM                                            
MFA-TR*               ,:WS-DATE-TO                                              
MFA-TR*           FROM CSS_TAX_RATE           TR                                
MFA-TR*          WHERE TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO                   
MFA-TR*            AND TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO               
MFA-TR*            AND TR.OPER_MODE        = :WS-A                              
MFA-TR*            AND (                                                        
MFA-TR*            TR.DATE_FROM BETWEEN :TR-DATE-FROM AND :TR-DATE-TO           
MFA-TR*            OR                                                           
MFA-TR*            TR.DATE_TO   BETWEEN :TR-DATE-FROM AND :TR-DATE-TO           
MFA-TR*                )                                                        
MFA-TR*          ORDER BY TR.DATE_FROM DESC                                     
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7025'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_RATE'        TO TABLE-1                     
              MOVE 'TAX_CNTRL_NO'        TO TABLE-ELEMENT-1             
              MOVE TR-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'TAX_ENTRY_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE TR-TAX-ENTRY-SEQ-NO   TO HOSTVAR-ELEMENT-2           
              MOVE 'OPER_MODE'           TO TABLE-ELEMENT-3             
              MOVE TR-OPER-MODE          TO HOSTVAR-ELEMENT-3           
              MOVE 'DATE_FROM'           TO TABLE-ELEMENT-4             
              MOVE TR-DATE-FROM          TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7030-INSERT-TAX-RATE.                                          *        
      ******************************************************************        
       7030-INSERT-TAX-RATE.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_TAX_RATE                                  
                ( OPER_MODE                                             
                 ,TAX_CNTRL_NO                                          
                 ,TAX_ENTRY_SEQ_NO                                      
                 ,DETAIL_ID                                             
                 ,DATE_FROM                                             
                 ,DATE_TO                                               
                 ,TAX_RATE                                              
                 ,LAST_UPDATE_USERID                                    
                )                                                       
               VALUES                                                   
                ( :TR-OPER-MODE                                         
                 ,:TR-TAX-CNTRL-NO                                      
                 ,:TR-TAX-ENTRY-SEQ-NO                                  
                 ,:TR-DETAIL-ID                                         
                 ,IIF(TRY_CONVERT(DATE, :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )                                
                 ,IIF(TRY_CONVERT(DATE, :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )                                           
                 ,:TR-TAX-RATE                                          
                 ,:TR-LAST-UPDATE-USERID                                
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_TAX_RATE                                          
MFA-TR*         ( OPER_MODE                                                     
MFA-TR*          ,TAX_CNTRL_NO                                                  
MFA-TR*          ,TAX_ENTRY_SEQ_NO                                              
MFA-TR*          ,DETAIL_ID                                                     
MFA-TR*          ,DATE_FROM                                                     
MFA-TR*          ,DATE_TO                                                       
MFA-TR*          ,TAX_RATE                                                      
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*         )                                                               
MFA-TR*        VALUES                                                           
MFA-TR*         ( :TR-OPER-MODE                                                 
MFA-TR*          ,:TR-TAX-CNTRL-NO                                              
MFA-TR*          ,:TR-TAX-ENTRY-SEQ-NO                                          
MFA-TR*          ,:TR-DETAIL-ID                                                 
MFA-TR*          ,:TR-DATE-FROM                                                 
MFA-TR*          ,:TR-DATE-TO                                                   
MFA-TR*          ,:TR-TAX-RATE                                                  
MFA-TR*          ,:TR-LAST-UPDATE-USERID                                        
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN ALREADY-EXISTS                                      
                    MOVE ZERO               TO S-RETURN-CODE-1          
                    MOVE 'TXR0000005'       TO S-RS1-BUS-RULE-ID        
                    MOVE WS-FAILED          TO                          
                                            S-RS1-BUS-RULE-RESULT-CD    
                    IF S-RS1-BUS-RULE-ID GREATER THAN SPACES            
                       PERFORM 7550-GET-RULE-XREF-ID                    
                                                  THRU 7550-EXIT        
                    END-IF                                              
                    PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT        
                    PERFORM 9999-END-PROGRAM      THRU 9999-EXIT        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7030'             TO ACTIVE-PARAGRAPH         
                    MOVE 'INSERT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                                     ABEND-TABLES       
                    MOVE 'CSS_TAX_RATE'     TO TABLE-1                  
                    MOVE 'TAX_CNTRL_NO'     TO TABLE-ELEMENT-1          
                    MOVE 'OPER_MODE'        TO TABLE-ELEMENT-2          
                    MOVE 'TAX_ENTRY_SEQ_NO' TO TABLE-ELEMENT-3          
                    MOVE 'DATE_FROM'        TO TABLE-ELEMENT-4          
                    MOVE TR-TAX-CNTRL-NO    TO HOSTVAR-ELEMENT-1        
                    MOVE TR-OPER-MODE       TO HOSTVAR-ELEMENT-2        
                    MOVE TR-TAX-ENTRY-SEQ-NO                            
                                            TO HOSTVAR-ELEMENT-3        
                    MOVE TR-DATE-FROM       TO HOSTVAR-ELEMENT-4        
                    PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-UPDATE-TAX-RATE.                                          *        
      ******************************************************************        
       7050-UPDATE-TAX-RATE.                                            
                                                                        
           EXEC SQL                                                     
                UPDATE TR                                   
                SET TR.DETAIL_ID          = :TR-DETAIL-ID               
                   ,TR.DATE_FROM          = IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )               
                   ,TR.DATE_TO            = IIF(TRY_CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )                 
                   ,TR.TAX_RATE           = :TR-TAX-RATE                
                   ,TR.LAST_UPDATE_USERID = :TR-LAST-UPDATE-USERID      
                FROM CSS_TAX_RATE TR
              WHERE TR.OPER_MODE          = :TR-OPER-MODE               
                AND TR.TAX_CNTRL_NO       = :TR-TAX-CNTRL-NO            
                AND TR.TAX_ENTRY_SEQ_NO   = :TR-TAX-ENTRY-SEQ-NO        
                AND TR.DATE_FROM          = IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_TAX_RATE          TR                                 
MFA-TR*         SET TR.DETAIL_ID          = :TR-DETAIL-ID                       
MFA-TR*            ,TR.DATE_FROM          = :TR-DATE-FROM                       
MFA-TR*            ,TR.DATE_TO            = :TR-DATE-TO                         
MFA-TR*            ,TR.TAX_RATE           = :TR-TAX-RATE                        
MFA-TR*            ,TR.LAST_UPDATE_USERID = :TR-LAST-UPDATE-USERID              
MFA-TR*       WHERE TR.OPER_MODE          = :TR-OPER-MODE                       
MFA-TR*         AND TR.TAX_CNTRL_NO       = :TR-TAX-CNTRL-NO                    
MFA-TR*         AND TR.TAX_ENTRY_SEQ_NO   = :TR-TAX-ENTRY-SEQ-NO                
MFA-TR*         AND TR.DATE_FROM          = :TR-DATE-FROM                       
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_TAX_RATE'           TO TABLE-1                  
              MOVE 'OPER_MODE'              TO TABLE-ELEMENT-1          
              MOVE 'TAX_CNTRL_NO'           TO TABLE-ELEMENT-2          
              MOVE 'TAX_ENTRY_SEQ_NO'       TO TABLE-ELEMENT-3          
              MOVE 'DATE_FROM'              TO TABLE-ELEMENT-4          
              MOVE TR-OPER-MODE             TO HOSTVAR-ELEMENT-1        
              MOVE TR-TAX-CNTRL-NO          TO HOSTVAR-ELEMENT-2        
              MOVE TR-TAX-ENTRY-SEQ-NO      TO HOSTVAR-ELEMENT-3        
              MOVE TR-DATE-FROM             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7055-GET-OVERLAP-TAX-RATE.                                     *        
      ******************************************************************        
       7055-GET-OVERLAP-TAX-RATE.                                       
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-TAX-RATE-OL-FLAG                             
                  FROM CSS_TAX_RATE           TR WITH(READUNCOMMITTED)          
                 WHERE TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO           
                   AND TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO       
                   AND TR.OPER_MODE        = :WS-A                      
                   AND TR.DATE_FROM       <> IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )              
                   AND TR.DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )                
                   AND TR.DATE_TO         >  IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-TAX-RATE-OL-FLAG                                     
MFA-TR*           FROM CSS_TAX_RATE           TR                                
MFA-TR*          WHERE TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO                   
MFA-TR*            AND TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO               
MFA-TR*            AND TR.OPER_MODE        = :WS-A                              
MFA-TR*            AND TR.DATE_FROM       <> :TR-DATE-FROM                      
MFA-TR*            AND TR.DATE_FROM       <= :TR-DATE-TO                        
MFA-TR*            AND TR.DATE_TO         >  :TR-DATE-FROM                      
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7055                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7055'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_RATE'        TO TABLE-1                     
              MOVE 'TAX_CNTRL_NO'        TO TABLE-ELEMENT-1             
              MOVE TR-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'TAX_ENTRY_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE TR-TAX-ENTRY-SEQ-NO   TO HOSTVAR-ELEMENT-2           
              MOVE 'OPER_MODE'           TO TABLE-ELEMENT-3             
              MOVE TR-OPER-MODE          TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-GET-TAX-RATE-COUNT.                                       *        
      ******************************************************************        
       7060-GET-TAX-RATE-COUNT.                                         
                                                                        
           EXEC SQL                                                     
                SELECT COUNT(*)                                         
                  INTO :WS-TAX-RATE-COUNT                               
                  FROM CSS_TAX_RATE           TR WITH(READUNCOMMITTED)          
                 WHERE TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO           
                   AND TR.OPER_MODE        = 'A'                        
                   AND TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-TAX-RATE-COUNT                                       
MFA-TR*           FROM CSS_TAX_RATE           TR                                
MFA-TR*          WHERE TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO                   
MFA-TR*            AND TR.OPER_MODE        = 'A'                                
MFA-TR*            AND TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO               
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_RATE'        TO TABLE-1                     
              MOVE 'TAX_CNTL_NO'         TO TABLE-ELEMENT-1             
              MOVE 'TAX_ENTRY_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE TR-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1           
              MOVE TR-TAX-ENTRY-SEQ-NO   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7070-DELETE-TAX-USE-CNTL.                                      *        
      ******************************************************************        
       7070-DELETE-TAX-USE-CNTL.                                        
                                                                        
           EXEC SQL                                                     
                DELETE FROM TU                          
                FROM CSS_TAX_USE_CNTL TU
                WHERE  TU.OPER_MODE        = :TU-OPER-MODE              
                  AND  TU.TAX_CNTRL_NO     = :TU-TAX-CNTRL-NO           
                  AND  TU.TAX_ENTRY_SEQ_NO = :TU-TAX-ENTRY-SEQ-NO       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_TAX_USE_CNTL TU                                 
MFA-TR*         WHERE  TU.OPER_MODE        = :TU-OPER-MODE                      
MFA-TR*           AND  TU.TAX_CNTRL_NO     = :TU-TAX-CNTRL-NO                   
MFA-TR*           AND  TU.TAX_ENTRY_SEQ_NO = :TU-TAX-ENTRY-SEQ-NO               
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_USE_CNTL'    TO TABLE-1                     
              MOVE 'OPER_MODE'           TO TABLE-ELEMENT-1             
              MOVE 'TAX_CNTL_NO'         TO TABLE-ELEMENT-1             
              MOVE 'TAX_ENTRY_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE TU-OPER-MODE          TO HOSTVAR-ELEMENT-1           
              MOVE TU-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1           
              MOVE TU-TAX-ENTRY-SEQ-NO   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7080-DELETE-TAX-RATE.                                          *        
      ******************************************************************        
       7080-DELETE-TAX-RATE.                                            
                                                                        
           EXEC SQL                                                     
                DELETE FROM TR                              
                FROM CSS_TAX_RATE TR
                WHERE  TR.OPER_MODE        = :TR-OPER-MODE              
                  AND  TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO           
                  AND  TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO       
                  AND  TR.DATE_FROM        = IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_TAX_RATE     TR                                 
MFA-TR*         WHERE  TR.OPER_MODE        = :TR-OPER-MODE                      
MFA-TR*           AND  TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO                   
MFA-TR*           AND  TR.TAX_ENTRY_SEQ_NO = :TR-TAX-ENTRY-SEQ-NO               
MFA-TR*           AND  TR.DATE_FROM        = :TR-DATE-FROM                      
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_RATE'        TO TABLE-1                     
              MOVE 'OPER_MODE'           TO TABLE-ELEMENT-1             
              MOVE 'TAX_CNTL_NO'         TO TABLE-ELEMENT-2             
              MOVE 'TAX_ENTRY_SEQ_NO'    TO TABLE-ELEMENT-3             
              MOVE 'DATE_FROM'           TO TABLE-ELEMENT-4             
              MOVE TR-OPER-MODE          TO HOSTVAR-ELEMENT-1           
              MOVE TR-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-2           
              MOVE TR-TAX-ENTRY-SEQ-NO   TO HOSTVAR-ELEMENT-3           
              MOVE TR-DATE-FROM          TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                                         
      * 7550-GET-RULE-XREF-ID                                                   
      *                                                                         
      ************************************************************              
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS1-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   R WITH(READUNCOMMITTED)                     
                    ,CSS_BUS_RULE_XREF T WITH(READUNCOMMITTED)                  
               WHERE R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                 
                 AND R.BUS_RULE_ID = T.BUS_RULE_ID                      
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   R                                           
MFA-TR*             ,CSS_BUS_RULE_XREF T                                        
MFA-TR*        WHERE R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                         
MFA-TR*          AND R.BUS_RULE_ID = T.BUS_RULE_ID                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS1-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04722_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04722_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04722_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.       BUSINESS RULE                        *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04722_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04722_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04722_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04722_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
