       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04721.                                      
       AUTHOR.        AMIRTHARAJ D.                                     
COB303 DATE-WRITTEN.     MARCH 25, 2014.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:   CSR04721             --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--   CSR04721 :                                               --         
      *--                                                            --         
      *--  RETRIEVE ALL TAX DETAILS FOR BILLING CONTROLS.            --         
      *--                                                            --         
      *--  CLONED FROM PCSRT003 & PCSRT004.                          --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS:                                               --         
      *--                                                            --         
      *--  INPUT PARAMETERS.                                         --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  OUTPUT RESULT SET.                                        --         
      *--                                                            --         
      *--   CSR04721_R1 - TAX CONTROL DETAILS.                       --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,TAX_CNTL_NO            SMALLINT                  --         
      *--          ,TAX_TYPE               CHAR(01)                  --         
      *--          ,ENERGY_TAX_FLAG        CHAR(01)                  --         
      *--          ,DETAIL_ID_TYPE         CHAR(10)                  --         
      *--          ,FACTOR_ID              CHAR(09)                  --         
      *--          ,FACTOR_DESC            CHAR(60)                  --         
      *--                                                            --         
      *--   CSR04721_R2 - TAX RATE DETAILS.                          --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,TAX_CNTL_NO            SMALLINT                  --         
      *--          ,TAX_ENTRY_SEQ_NO       SMALLINT                  --         
      *--          ,REV_DIST_CD            CHAR(03)                  --         
      *--          ,REV_DIST_DESC          CHAR(35)                  --         
      *--          ,START_DATE             CHAR(10)                  --         
      *--          ,END_DATE               CHAR(10)                  --         
      *--          ,TAX_RATE               DECIMAL(5,4)              --         
      *--          ,CALC_INSTR             CHAR(01)                  --         
      *--          ,ELEC_FLAG              CHAR(01)                  --         
      *--          ,GAS_FLAG               CHAR(01)                  --         
      *--          ,MDSE_FLAG              CHAR(01)                  --         
      *--                                                            --         
      *--   CSR04721_R3 - BUS RULE DETAILS.                          --         
      *--                                                            --         
      *--           RETURN_CODE            INTEGER                   --         
      *--          ,APPL_RETURN_CODE       INTEGER                   --         
      *--          ,BUS_RULE_ID            CHAR(10)                  --         
      *--          ,BUS_RULE_RESULT_CD     CHAR(10)                  --         
      *--          ,BUS_RULE_XREF_ID       CHAR(26)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  03/25/2014    AD7F921     RETRIEVE TAX DETAILS.           --         
      *--                                                            --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04721'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(60) VALUE                    
            'WORKING STORAGE FOR  CSR04721 STARTS HERE'.                
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04721'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(4) COMP VALUE 0.     
           05  WS-TAX-CNTRL-NO              PIC  9(4) VALUE 0.          
           05  WS-TAX-CNTRL-TEXT REDEFINES WS-TAX-CNTRL-NO.             
               10 WS-TAX-CNTRL-ZERO         PIC X(02).                  
               10 WS-TAX-CNTRL-VALUE        PIC X(02).                  
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-A                         PIC X(01) VALUE 'A'.        
           05  WS-B                         PIC X(01) VALUE 'B'.        
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R3              PIC X(01) VALUE 'N'.        
                                                                        
       01  SWITCHES.                                                    
           05  END-OF-TC-SW             PIC X(01) VALUE 'N'.            
               88 NO-MORE-TAX-CNTL-RECS           VALUE 'Y'.            
           05  END-OF-TR-SW             PIC X(01) VALUE 'N'.            
               88 NO-MORE-TAX-RATE-RECS           VALUE 'Y'.            
               88 MORE-TAX-RATE-RECS              VALUE 'N'.            
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR TAX CONTROL DETAILS            *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-TAX-CNTL-NO           PIC S9(04) COMP VALUE 0.    
             10 S-RS1-TAX-TYPE              PIC X(01)  VALUE SPACES.    
             10 S-RS1-ENERGY-TAX-FLAG       PIC X(01)  VALUE SPACES.    
             10 S-RS1-DETAIL-ID-TYPE        PIC X(10)  VALUE SPACES.    
             10 S-RS1-FACTOR-ID             PIC X(09)  VALUE SPACES.    
             10 S-RS1-FACTOR-DESC           PIC X(60)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR TAX RATE DETAILS               *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-TAX-CNTL-NO           PIC S9(04) COMP VALUE 0.    
             10 S-RS2-TAX-ENTRY-SEQ-NO      PIC S9(04) COMP VALUE 0.    
             10 S-RS2-REV-DIST-CD           PIC X(03)  VALUE SPACES.    
             10 S-RS2-REV-DIST-DESC         PIC X(35)  VALUE SPACES.    
             10 S-RS2-START-DATE            PIC X(10)  VALUE SPACES.    
             10 S-RS2-END-DATE              PIC X(10)  VALUE SPACES.    
             10 S-RS2-TAX-RATE              PIC S9(1)V9(4) USAGE COMP-3 
                                                            VALUE 0.    
             10 S-RS2-CALC-INSTR            PIC X(01)  VALUE SPACES.    
             10 S-RS2-ELEC-FLAG             PIC X(01)  VALUE SPACES.    
             10 S-RS2-GAS-FLAG              PIC X(01)  VALUE SPACES.    
             10 S-RS2-MDSE-FLAG             PIC X(01)  VALUE SPACES.    
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE         *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.    
             10 S-RS3-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS3-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS3-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TAX_USE_CNTL   TU                                      *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXUSE                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TAX_RATE       TR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXRATE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_TAX_CNTL       TC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBTXCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR      TR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REV_DISTRICT   A9                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO TAX_CNTL DATA                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE TAX_CNTL_CUR CURSOR FOR                          
                SELECT TC.TAX_CNTRL_NO                                  
                      ,TC.TAX_TYPE                                      
                      ,TC.ENERGY_TAX_FL                                 
                      ,TC.DETAIL_ID_TYPE                                
                      ,TC.FACTOR_ID                                     
                      ,COALESCE(SF.FACTOR_DESC,'None')                    
                  FROM CSS_TAX_CNTL             TC WITH(READUNCOMMITTED)        
             LEFT JOIN CSS_SPCL_FCTR            SF WITH(READUNCOMMITTED)        
                    ON SF.FACTOR_ID = TC.FACTOR_ID                      
                 WHERE TC.OPER_MODE = 'A'                               
                 ORDER BY TC.TAX_CNTRL_NO                               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE TAX_CNTL_CUR CURSOR FOR                                  
MFA-TR*         SELECT TC.TAX_CNTRL_NO                                          
MFA-TR*               ,TC.TAX_TYPE                                              
MFA-TR*               ,TC.ENERGY_TAX_FL                                         
MFA-TR*               ,TC.DETAIL_ID_TYPE                                        
MFA-TR*               ,TC.FACTOR_ID                                             
MFA-TR*               ,IFNULL(SF.FACTOR_DESC,'None')                            
MFA-TR*           FROM CSS_TAX_CNTL             TC                              
MFA-TR*      LEFT JOIN CSS_SPCL_FCTR            SF                              
MFA-TR*             ON SF.FACTOR_ID = TC.FACTOR_ID                              
MFA-TR*          WHERE TC.OPER_MODE = 'A'                                       
MFA-TR*          ORDER BY TC.TAX_CNTRL_NO                                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO TAX_RATE DATA                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE TAX_RATE_CUR CURSOR FOR                          
                SELECT TR.TAX_CNTRL_NO                                  
                      ,TR.TAX_ENTRY_SEQ_NO                              
                      ,TR.DETAIL_ID                                     
                      ,TR.DATE_FROM                                     
                      ,TR.DATE_TO                                       
                      ,TR.TAX_RATE                                      
                      ,TU.TAX_ELEC                                      
                      ,TU.TAX_GAS                                       
                      ,TU.TAX_MDSE                                      
                      ,TU.CODE_TAX_CALC_INST                            
                      ,A9.REV_DISTRICT_DESC                             
                  FROM CSS_TAX_RATE         TR WITH(READUNCOMMITTED),           
                       CSS_TAX_USE_CNTL     TU WITH(READUNCOMMITTED),           
                       CSS_REV_DISTRICT     A9 WITH(READUNCOMMITTED)            
                  WHERE TR.OPER_MODE        = 'A'                       
                    AND TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO          
                    AND TR.OPER_MODE        = TU.OPER_MODE              
                    AND TR.TAX_CNTRL_NO     = TU.TAX_CNTRL_NO           
                    AND TR.TAX_ENTRY_SEQ_NO = TU.TAX_ENTRY_SEQ_NO       
                    AND TR.DETAIL_ID        = A9.REV_DISTRICT_CD        
                  ORDER BY TR.TAX_CNTRL_NO                              
                          ,TR.DETAIL_ID                                 
                          ,TR.DATE_FROM        DESC                     
                          ,TR.TAX_ENTRY_SEQ_NO DESC                     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE TAX_RATE_CUR CURSOR FOR                                  
MFA-TR*         SELECT TR.TAX_CNTRL_NO                                          
MFA-TR*               ,TR.TAX_ENTRY_SEQ_NO                                      
MFA-TR*               ,TR.DETAIL_ID                                             
MFA-TR*               ,TR.DATE_FROM                                             
MFA-TR*               ,TR.DATE_TO                                               
MFA-TR*               ,TR.TAX_RATE                                              
MFA-TR*               ,TU.TAX_ELEC                                              
MFA-TR*               ,TU.TAX_GAS                                               
MFA-TR*               ,TU.TAX_MDSE                                              
MFA-TR*               ,TU.CODE_TAX_CALC_INST                                    
MFA-TR*               ,A9.REV_DISTRICT_DESC                                     
MFA-TR*           FROM CSS_TAX_RATE         TR,                                 
MFA-TR*                CSS_TAX_USE_CNTL     TU,                                 
MFA-TR*                CSS_REV_DISTRICT     A9                                  
MFA-TR*           WHERE TR.OPER_MODE        = 'A'                               
MFA-TR*             AND TR.TAX_CNTRL_NO     = :TR-TAX-CNTRL-NO                  
MFA-TR*             AND TR.OPER_MODE        = TU.OPER_MODE                      
MFA-TR*             AND TR.TAX_CNTRL_NO     = TU.TAX_CNTRL_NO                   
MFA-TR*             AND TR.TAX_ENTRY_SEQ_NO = TU.TAX_ENTRY_SEQ_NO               
MFA-TR*             AND TR.DETAIL_ID        = A9.REV_DISTRICT_CD                
MFA-TR*           ORDER BY TR.TAX_CNTRL_NO                                      
MFA-TR*                   ,TR.DETAIL_ID                                         
MFA-TR*                   ,TR.DATE_FROM        DESC                             
MFA-TR*                   ,TR.TAX_ENTRY_SEQ_NO DESC                             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
           PERFORM 0100B-DECLARE-GTT-R2          THRU 0100B-EXIT.       
           PERFORM 0100C-DECLARE-GTT-R3          THRU 0100C-EXIT.       
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04721_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04721_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04721_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TAX_CNTL_NO             SMALLINT                    
                   ,TAX_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,ENERGY_TAX_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DETAIL_ID_TYPE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,FACTOR_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,TAX_CNTL_NO                 AS TAX_CNTL_NO       
                      ,LTRIM(RTRIM(TAX_TYPE))             AS TAX_TYPE          
                      ,LTRIM(RTRIM(ENERGY_TAX_FLAG))      AS 
           ENERGY_TAX_FLAG   
                      ,LTRIM(RTRIM(DETAIL_ID_TYPE))       AS 
           DETAIL_ID_TYPE    
                      ,LTRIM(RTRIM(FACTOR_ID))            AS FACTOR_ID         
                      ,LTRIM(RTRIM(FACTOR_DESC))          AS FACTOR_DESC       
                  FROM #CSR04721_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,TAX_CNTL_NO                 AS TAX_CNTL_NO               
MFA-TR*               ,STRIP(TAX_TYPE)             AS TAX_TYPE                  
MFA-TR*               ,STRIP(ENERGY_TAX_FLAG)      AS ENERGY_TAX_FLAG           
MFA-TR*               ,STRIP(DETAIL_ID_TYPE)       AS DETAIL_ID_TYPE            
MFA-TR*               ,STRIP(FACTOR_ID)            AS FACTOR_ID                 
MFA-TR*               ,STRIP(FACTOR_DESC)          AS FACTOR_DESC               
MFA-TR*           FROM SESSION.CSR04721_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04721_R2'      TO WS-GTT-NAME.              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04721_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04721_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TAX_CNTL_NO             SMALLINT                    
                   ,TAX_ENTRY_SEQ_NO        SMALLINT                    
                   ,REV_DIST_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REV_DIST_DESC CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,END_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,TAX_RATE                DECIMAL(5,4)                
                   ,CALC_INSTR CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,ELEC_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,GAS_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,MDSE_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,TAX_CNTL_NO                 AS TAX_CNTL_NO       
                      ,TAX_ENTRY_SEQ_NO            AS TAX_ENTRY_SEQ_NO  
                      ,LTRIM(RTRIM(REV_DIST_CD))          AS REV_DIST_CD       
                      ,LTRIM(RTRIM(REV_DIST_DESC))        AS 
           REV_DIST_DESC     
                      ,LTRIM(RTRIM(START_DATE))           AS START_DATE        
                      ,LTRIM(RTRIM(END_DATE))             AS END_DATE          
                      ,TAX_RATE                    AS TAX_RATE          
                      ,LTRIM(RTRIM(CALC_INSTR))           AS CALC_INSTR        
                      ,LTRIM(RTRIM(ELEC_FLAG))            AS ELEC_FLAG         
                      ,LTRIM(RTRIM(GAS_FLAG))             AS GAS_FLAG          
                      ,LTRIM(RTRIM(MDSE_FLAG))            AS MDSE_FLAG         
                  FROM #CSR04721_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,TAX_CNTL_NO                 AS TAX_CNTL_NO               
MFA-TR*               ,TAX_ENTRY_SEQ_NO            AS TAX_ENTRY_SEQ_NO          
MFA-TR*               ,STRIP(REV_DIST_CD)          AS REV_DIST_CD               
MFA-TR*               ,STRIP(REV_DIST_DESC)        AS REV_DIST_DESC             
MFA-TR*               ,STRIP(START_DATE)           AS START_DATE                
MFA-TR*               ,STRIP(END_DATE)             AS END_DATE                  
MFA-TR*               ,TAX_RATE                    AS TAX_RATE                  
MFA-TR*               ,STRIP(CALC_INSTR)           AS CALC_INSTR                
MFA-TR*               ,STRIP(ELEC_FLAG)            AS ELEC_FLAG                 
MFA-TR*               ,STRIP(GAS_FLAG)             AS GAS_FLAG                  
MFA-TR*               ,STRIP(MDSE_FLAG)            AS MDSE_FLAG                 
MFA-TR*           FROM SESSION.CSR04721_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3                                           *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04721_R3'      TO WS-GTT-NAME.              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04721_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04721_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04721_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04721_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-GET-TAX-CNTL           THRU 2100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-GET-TAX-CNTL.                                             *        
      ******************************************************************        
       2100-GET-TAX-CNTL.                                               
                                                                        
           PERFORM 7010-OPEN-TAX-CNTL          THRU 7010-EXIT.          
           PERFORM 7020-FETCH-TAX-CNTL         THRU 7020-EXIT.          
           PERFORM 2200-PROCESS-TAX-CNTL       THRU 2200-EXIT           
                                  UNTIL NO-MORE-TAX-CNTL-RECS.          
           PERFORM 7030-CLOSE-TAX-CNTL         THRU 7030-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-PROCESS-TAX-CNTL.                                         *        
      ******************************************************************        
       2200-PROCESS-TAX-CNTL.                                           
                                                                        
           MOVE TC-TAX-CNTRL-NO             TO TR-TAX-CNTRL-NO.         
           MOVE ZERO                        TO WS-TAX-CNTRL-NO.         
           MOVE SPACES                      TO UV-CODE-VALUE.           
           IF TC-FACTOR-ID EQUAL SPACES                                 
              MOVE 'NONE'                   TO TC-FACTOR-ID             
              PERFORM 2250-GET-FACTOR-DESC     THRU 2250-EXIT           
           END-IF.                                                      
           PERFORM 2400-GET-TAX-RATE           THRU 2400-EXIT.          
                                                                        
           PERFORM 2300-BUILD-TAX-CNTL-RS1     THRU 2300-EXIT.          
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           MOVE SPACES                      TO TC-FACTOR-ID             
                                               SF-FACTOR-ID             
                                               SF-FACTOR-DESC.          
                                                                        
           PERFORM 7020-FETCH-TAX-CNTL         THRU 7020-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2250-GET-FACTOR-DESC.                                          *        
      ******************************************************************        
       2250-GET-FACTOR-DESC.                                            
                                                                        
           MOVE TC-TAX-CNTRL-NO             TO WS-TAX-CNTRL-NO.         
           INITIALIZE                          UV-CODE-LONG-DESC.       
           PERFORM 7025-GET-CODE-VALUE         THRU 7025-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE UV-CODE-LONG-DESC-TEXT                               
                          (1:UV-CODE-LONG-DESC-LEN)                     
                                            TO SF-FACTOR-DESC           
           ELSE                                                         
              MOVE 'None'                   TO SF-FACTOR-DESC           
           END-IF.                                                      
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-BUILD-TAX-CNTL-RS1.                                       *        
      ******************************************************************        
       2300-BUILD-TAX-CNTL-RS1.                                         
                                                                        
           MOVE TC-TAX-CNTRL-NO             TO S-RS1-TAX-CNTL-NO.       
           MOVE TC-TAX-TYPE                 TO S-RS1-TAX-TYPE.          
           MOVE TC-ENERGY-TAX-FL            TO S-RS1-ENERGY-TAX-FLAG.   
           MOVE TC-DETAIL-ID-TYPE           TO S-RS1-DETAIL-ID-TYPE.    
           MOVE TC-FACTOR-ID                TO S-RS1-FACTOR-ID.         
           MOVE SF-FACTOR-DESC              TO S-RS1-FACTOR-DESC.       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-GET-TAX-RATE.                                             *        
      ******************************************************************        
       2400-GET-TAX-RATE.                                               
                                                                        
           PERFORM 7110-OPEN-TAX-RATE          THRU 7110-EXIT.          
           SET MORE-TAX-RATE-RECS           TO TRUE.                    
           PERFORM 7120-FETCH-TAX-RATE         THRU 7120-EXIT.          
           PERFORM 2500-PROCESS-TAX-RATE       THRU 2500-EXIT           
                                  UNTIL NO-MORE-TAX-RATE-RECS.          
           PERFORM 7130-CLOSE-TAX-RATE         THRU 7130-EXIT.          
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 2500-PROCESS-TAX-RATE.                                         *        
      ******************************************************************        
       2500-PROCESS-TAX-RATE.                                           
                                                                        
           PERFORM 2600-BUILD-TAX-RATE-RS2     THRU 2600-EXIT.          
                                                                        
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
           PERFORM 7120-FETCH-TAX-RATE         THRU 7120-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2600-BUILD-TAX-RATE-RS2.                                       *        
      ******************************************************************        
       2600-BUILD-TAX-RATE-RS2.                                         
                                                                        
           MOVE TR-TAX-CNTRL-NO             TO S-RS2-TAX-CNTL-NO.       
           MOVE TR-TAX-ENTRY-SEQ-NO         TO S-RS2-TAX-ENTRY-SEQ-NO.  
           MOVE TR-DETAIL-ID                TO S-RS2-REV-DIST-CD.       
           MOVE A9-REV-DISTRICT-DESC        TO S-RS2-REV-DIST-DESC.     
           MOVE TR-DATE-FROM                TO S-RS2-START-DATE.        
           MOVE TR-DATE-TO                  TO S-RS2-END-DATE.          
           MOVE TR-TAX-RATE                 TO S-RS2-TAX-RATE.          
           MOVE TU-CODE-TAX-CALC-INST       TO S-RS2-CALC-INSTR.        
           MOVE TU-TAX-ELEC                 TO S-RS2-ELEC-FLAG.         
           MOVE TU-TAX-GAS                  TO S-RS2-GAS-FLAG.          
           MOVE TU-TAX-MDSE                 TO S-RS2-MDSE-FLAG.         
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-OPEN-TAX-CNTL.                                            *        
      ******************************************************************        
       7010-OPEN-TAX-CNTL.                                              
                                                                        
           EXEC SQL                                                     
                OPEN TAX_CNTL_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_CNTL'        TO TABLE-1                     
              MOVE 'TAX_CNTL_NO'         TO TABLE-ELEMENT-1             
              MOVE TC-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7020-FETCH-TAX-CNTL.                                           *        
      ******************************************************************        
       7020-FETCH-TAX-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               FETCH TAX_CNTL_CUR                                       
                INTO :TC-TAX-CNTRL-NO                                   
                    ,:TC-TAX-TYPE                                       
                    ,:TC-ENERGY-TAX-FL                                  
                    ,:TC-DETAIL-ID-TYPE                                 
                    ,:TC-FACTOR-ID                                      
                    ,:SF-FACTOR-DESC                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-TAX-CNTL-RECS                           
                                            TO TRUE                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7020'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_TAX_CNTL'                                 
                                            TO TABLE-1                  
                    MOVE 'TAX_CNTL_NO'      TO TABLE-ELEMENT-1          
                    MOVE TC-TAX-CNTRL-NO    TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7025-GET-CODE-VALUE.                                           *        
      ******************************************************************        
       7025-GET-CODE-VALUE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT UV.CODE_LONG_DESC                                  
                INTO :UV-CODE-LONG-DESC                                 
                FROM CSS_CODE_VALUE   UV WITH(READUNCOMMITTED)                  
               WHERE UV.COLUMN_NA  = 'TAX_CNTRL_NO'                     
                 AND UV.TABLE_NA   = 'CSS_TAX_CNTL'                     
                 AND UV.CODE_VALUE = :WS-TAX-CNTRL-VALUE                
                 AND UV.PROGRAM_ID = 'CSR04721'                         
                 AND UV.COMPANY_NO = '01'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_LONG_DESC                                          
MFA-TR*         INTO :UV-CODE-LONG-DESC                                         
MFA-TR*         FROM CSS_CODE_VALUE   UV                                        
MFA-TR*        WHERE UV.COLUMN_NA  = 'TAX_CNTRL_NO'                             
MFA-TR*          AND UV.TABLE_NA   = 'CSS_TAX_CNTL'                             
MFA-TR*          AND UV.CODE_VALUE = :WS-TAX-CNTRL-VALUE                        
MFA-TR*          AND UV.PROGRAM_ID = 'CSR04721'                                 
MFA-TR*          AND UV.COMPANY_NO = '01'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE +0                 TO S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7025'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CODE_VALUE'                               
                                            TO TABLE-1                  
                    MOVE 'COLUMN_NA'        TO TABLE-ELEMENT-1          
                    MOVE UV-COLUMN-NA       TO HOSTVAR-ELEMENT-1        
                    MOVE 'TABLE_NA'         TO TABLE-ELEMENT-1          
                    MOVE UV-TABLE-NA        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7030-CLOSE-TAX-CNTL.                                           *        
      ******************************************************************        
       7030-CLOSE-TAX-CNTL.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE TAX_CNTL_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_TAX_CNTL'           TO TABLE-1                  
              MOVE 'TAX_CNTL_NO'            TO TABLE-ELEMENT-1          
              MOVE TC-TAX-CNTRL-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7110-OPEN-TAX-RATE.                                            *        
      ******************************************************************        
       7110-OPEN-TAX-RATE.                                              
                                                                        
           EXEC SQL                                                     
                OPEN TAX_RATE_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_TAX_RATE'        TO TABLE-1                     
              MOVE 'TAX_CNTL_NO'         TO TABLE-ELEMENT-1             
              MOVE 'TAX_ENTRY_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE TR-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1           
              MOVE TR-TAX-ENTRY-SEQ-NO   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7120-FETCH-TAX-RATE.                                           *        
      ******************************************************************        
       7120-FETCH-TAX-RATE.                                             
                                                                        
           EXEC SQL                                                     
               FETCH TAX_RATE_CUR                                       
                INTO :TR-TAX-CNTRL-NO                                   
                    ,:TR-TAX-ENTRY-SEQ-NO                               
                    ,:TR-DETAIL-ID                                      
                    ,:TR-DATE-FROM                                      
                    ,:TR-DATE-TO                                        
                    ,:TR-TAX-RATE                                       
                    ,:TU-TAX-ELEC                                       
                    ,:TU-TAX-GAS                                        
                    ,:TU-TAX-MDSE                                       
                    ,:TU-CODE-TAX-CALC-INST                             
                    ,:A9-REV-DISTRICT-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-TAX-RATE-RECS                           
                                            TO TRUE                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7120'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_TAX_RATE'        TO TABLE-1               
                    MOVE 'TAX_CNTL_NO'         TO TABLE-ELEMENT-1       
                    MOVE 'TAX_ENTRY_SEQ_NO'    TO TABLE-ELEMENT-2       
                    MOVE TR-TAX-CNTRL-NO       TO HOSTVAR-ELEMENT-1     
                    MOVE TR-TAX-ENTRY-SEQ-NO   TO HOSTVAR-ELEMENT-2     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7130-CLOSE-TAX-RATE.                                           *        
      ******************************************************************        
       7130-CLOSE-TAX-RATE.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE TAX_RATE_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7130'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_TAX_RATE'           TO TABLE-1                  
              MOVE 'TAX_CNTL_NO'            TO TABLE-ELEMENT-1          
              MOVE TR-TAX-CNTRL-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04721_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04721_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04721_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04721_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04721_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04721_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04721_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04721_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000C'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04721_R3'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   TAX CONTROL DETAIL                       *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04721_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TAX_CNTL_NO                                          
                  ,TAX_TYPE                                             
                  ,ENERGY_TAX_FLAG                                      
                  ,DETAIL_ID_TYPE                                       
                  ,FACTOR_ID                                            
                  ,FACTOR_DESC                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-TAX-CNTL-NO                                   
                  ,:S-RS1-TAX-TYPE                                      
                  ,:S-RS1-ENERGY-TAX-FLAG                               
                  ,:S-RS1-DETAIL-ID-TYPE                                
                  ,:S-RS1-FACTOR-ID                                     
                  ,:S-RS1-FACTOR-DESC                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04721_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TAX_CNTL_NO                                                  
MFA-TR*           ,TAX_TYPE                                                     
MFA-TR*           ,ENERGY_TAX_FLAG                                              
MFA-TR*           ,DETAIL_ID_TYPE                                               
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,FACTOR_DESC                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-TAX-CNTL-NO                                           
MFA-TR*           ,:S-RS1-TAX-TYPE                                              
MFA-TR*           ,:S-RS1-ENERGY-TAX-FLAG                                       
MFA-TR*           ,:S-RS1-DETAIL-ID-TYPE                                        
MFA-TR*           ,:S-RS1-FACTOR-ID                                             
MFA-TR*           ,:S-RS1-FACTOR-DESC                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04721_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.   TAX RATE DETAIL                          *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04721_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TAX_CNTL_NO                                          
                  ,TAX_ENTRY_SEQ_NO                                     
                  ,REV_DIST_CD                                          
                  ,REV_DIST_DESC                                        
                  ,START_DATE                                           
                  ,END_DATE                                             
                  ,TAX_RATE                                             
                  ,CALC_INSTR                                           
                  ,ELEC_FLAG                                            
                  ,GAS_FLAG                                             
                  ,MDSE_FLAG                                            
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-TAX-CNTL-NO                                   
                  ,:S-RS2-TAX-ENTRY-SEQ-NO                              
                  ,:S-RS2-REV-DIST-CD                                   
                  ,:S-RS2-REV-DIST-DESC                                 
                  ,:S-RS2-START-DATE                                    
                  ,:S-RS2-END-DATE                                      
                  ,:S-RS2-TAX-RATE                                      
                  ,:S-RS2-CALC-INSTR                                    
                  ,:S-RS2-ELEC-FLAG                                     
                  ,:S-RS2-GAS-FLAG                                      
                  ,:S-RS2-MDSE-FLAG                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04721_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TAX_CNTL_NO                                                  
MFA-TR*           ,TAX_ENTRY_SEQ_NO                                             
MFA-TR*           ,REV_DIST_CD                                                  
MFA-TR*           ,REV_DIST_DESC                                                
MFA-TR*           ,START_DATE                                                   
MFA-TR*           ,END_DATE                                                     
MFA-TR*           ,TAX_RATE                                                     
MFA-TR*           ,CALC_INSTR                                                   
MFA-TR*           ,ELEC_FLAG                                                    
MFA-TR*           ,GAS_FLAG                                                     
MFA-TR*           ,MDSE_FLAG                                                    
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-TAX-CNTL-NO                                           
MFA-TR*           ,:S-RS2-TAX-ENTRY-SEQ-NO                                      
MFA-TR*           ,:S-RS2-REV-DIST-CD                                           
MFA-TR*           ,:S-RS2-REV-DIST-DESC                                         
MFA-TR*           ,:S-RS2-START-DATE                                            
MFA-TR*           ,:S-RS2-END-DATE                                              
MFA-TR*           ,:S-RS2-TAX-RATE                                              
MFA-TR*           ,:S-RS2-CALC-INSTR                                            
MFA-TR*           ,:S-RS2-ELEC-FLAG                                             
MFA-TR*           ,:S-RS2-GAS-FLAG                                              
MFA-TR*           ,:S-RS2-MDSE-FLAG                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04721_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8030-INSERT-GTT-R3.       BUSINESS RULE                        *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04721_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-BUS-RULE-ID                                   
                  ,:S-RS3-BUS-RULE-RESULT-CD                            
                  ,:S-RS3-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04721_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS3-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS3-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04721_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S-RETURN-CODE-3         
              MOVE 100                       TO S-APPL-RETURN-CODE-3    
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04721_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04721_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04721_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
