       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04720.                                      
COB303 DATE-WRITTEN.     DEC 20, 2013.                                  
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00060000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00080000
      *--                   STORED PROCEDURE:  CSR04720              -- 00090000
      *---------------------------------------------------------------- 00100000
      *--                         S U M M A R Y                      -- 00110000
      *--                                                            -- 00120000
      *--  CSR04720 :                                                -- 00130000
      *--                                                            -- 00140000
      *--  THIS PROGRAM WILL RETRIVE THE CSS_VOL_GROUP AND           -- 00150000
      *--  CSS_VOL_TYPE DATA TO THE RESULT SET 1 AND 02              -- 00160000
      *--  RESPECTIEVLY.                                             -- 00170000
      *--                                                            -- 00180000
      *--       CSS_VOL_GROUP  W7                                    -- 00190000
      *--       CSS_VOL_TYPE   X8                                    -- 00200000
      *--                                                            -- 00210000
      *---------------------------------------------------------------- 00220000
      *--                                                            -- 00230000
      *--  PARAMETERS                                                -- 00240000
      *--                                                            -- 00250000
      *--      INPUT                                                 -- 00260000
      *--                                                            -- 00280000
P00821*--       I_ACCOUNT_NO             DECIMAL(13)                 -- 00281000
P00821*--       I_BILL_NO                INTEGER                     -- 00282000
P00821*--       I_CODE_UTIL_TYPE         CHAR(1)                     -- 00283000
P00821*--       I_IC_NO                  SMALLINT                    -- 00283100
P00821*--       I_BILL_ITEM_TIMESTMP     CHAR(26)                    -- 00283200
      *--                                                            -- 00284000
      *--      OUT                                                   -- 00290000
      *--                                                            -- 00300000
      *--            NONE                                            -- 00310000
      *--                                                            -- 00320000
      *--      INOUT                                                 -- 00330000
      *--                                                            -- 00340000
      *--            NONE                                            -- 00350000
      *--                                                            -- 00360000
      *--  RESULT SET                                                -- 00370000
      *--                                                            -- 00380000
      *--  CSR04720_R1 - CSS_VOL_GROUP DATA                          -- 00390000
      *--                                                            -- 00400000
      *--           RETURN_CODE                    INTEGER           -- 00410000
      *--          ,COMPANY_NO                     CHAR(02)          -- 00420000
      *--          ,CODE_UTIL_TYPE                 CHAR(01)          -- 00430000
      *--          ,VOL_GROUP_CD                   SMALLINT          -- 00440000
      *--          ,VOL_GROUP_DESC                 CHAR(25)          -- 00450000
      *--          ,STATUS_CD                      CHAR(01)          -- 00460000
      *--          ,STATUS_CHANGE_DT               CHAR(10)          -- 00470000
      *--          ,LAST_UPDATE_TS                 CHAR(26)          -- 00480000
      *--          ,LAST_UPDATE_USERID             CHAR(07)          -- 00490000
      *--                                                            -- 00500000
      *--  CSR04720_R2 - CSS_VOL_TYPE DATA                           -- 00510000
      *--                                                            -- 00520000
      *--           RETURN_CODE                    INTEGER           -- 00530000
      *--          ,COMPANY_NO                     CHAR(2)           -- 00540000
      *--          ,CODE_UTIL_TYPE                 CHAR(1)           -- 00550000
      *--          ,VOL_GROUP_CD                   SMALLINT          -- 00560000
      *--          ,VOL_TYPE_CD                    CHAR(2)           -- 00570000
      *--          ,ENERGY_UNIT_CD                 CHAR(1)           -- 00580000
      *--          ,VOL_TYPE_DESC                  CHAR(25)          -- 00590000
      *--          ,VOL_GROUP_SEQ                  SMALLINT          -- 00600000
      *--          ,CMPNT_ID_CD                    CHAR(2)           -- 00610000
      *--          ,MANUAL_ENTRY_FL                CHAR(1)           -- 00620000
      *--          ,ACCUM_TOTAL_FL                 CHAR(1)           -- 00630000
      *--          ,BILL_PRINT_FL                  CHAR(1)           -- 00640000
      *--          ,COLUMN_HEADER1                 CHAR(14)          -- 00650000
      *--          ,COLUMN_HEADER2                 CHAR(14)          -- 00660000
      *--          ,COLUMN_HEADER3                 CHAR(14)          -- 00670000
      *--          ,COLUMN_HEADER4                 CHAR(14)          -- 00680000
      *--          ,STATUS_CD                      CHAR(1)           -- 00690000
      *--          ,STATUS_CHANGE_DT               CHAR(10)          -- 00700000
      *--          ,LAST_UPDATE_TS                 CHAR(26)          -- 00710000
      *--          ,LAST_UPDATE_USERID             CHAR(07)          -- 00720000
      *---------------------------------------------------------------- 00730000
      *--                        MODIFICATION LOG                    -- 00740000
      *--                                                            -- 00750000
      *--  DATE          INITIALS    COMMENTS                        -- 00760000
      *--  -----------   --------    ---------------------------------- 00770000
      *--  12/20/2013    AD7F921     INITIAL VERSION                 -- 00780000
P00821*--  01/27/2015    VK7L032     ADDED BILLING KEY AS INPUT      -- 00790000
      *---------------------------------------------------------------- 00800000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04720'.
MSQ017     COPY MFASQLM.
      *                                                                 00850000
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04720 STARTS HERE'.                 
      *                                                                 00880000
      ******************************************************************00890000
      *    WORK AREAS                                                  *00900000
      ******************************************************************00910000
      *                                                                 00920000
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04720'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05)  VALUE SPACES.    
           05  WS-GTT-NAME                  PIC X(19)  VALUE SPACES.    
           05  WS-UNBILLED-FLAG             PIC X(01)  VALUE SPACES.    
           05  RETURN-CODE-1                PIC S9(9) COMP  VALUE 0.    
           05  RETURN-CODE-2                PIC S9(9) COMP  VALUE 0.    
                                                                        
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-GRP-ROWS           PIC X(01) VALUE 'N'.        
              88 NO-MORE-GRP-ROWS                     VALUE 'Y'.        
           05 WS-NO-MORE-TYPE-ROWS          PIC X(01) VALUE 'N'.        
              88 NO-MORE-TYPE-ROWS                    VALUE 'Y'.        
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-ZERO                      PIC S9(04) VALUE 0.         
                                                                        
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************         01240000
      *   GTT TABLE LAYOUT FOR RATE CSS_UTIL_ENVRNMT          *         01250000
      *********************************************************         01260000
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-COMPANY-NO            PIC X(02)  VALUE SPACES.    
             10 S-RS1-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS1-VOL-GROUP-CD          PIC S9(4)  USAGE COMP       
                                                       VALUE 0.         
             10 S-RS1-VOL-GROUP-DESC        PIC X(25)  VALUE SPACES.    
             10 S-RS1-STATUS-CD             PIC X(01)  VALUE SPACES.    
             10 S-RS1-STATUS-CHANGE-DT      PIC X(10)  VALUE SPACES.    
             10 S-RS1-LAST-UPDATE-TS        PIC X(26)  VALUE SPACES.    
             10 S-RS1-LAST-UPDATE-USERID    PIC X(07)  VALUE SPACES.    
                                                                        
      *********************************************************         01410000
      *   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE        *          01420000
      *********************************************************         01430000
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-COMPANY-NO            PIC X(02)  VALUE SPACES.    
             10 S-RS2-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.    
             10 S-RS2-VOL-GROUP-CD          PIC S9(4) USAGE COMP        
                                                       VALUE 0.         
             10 S-RS2-VOL-TYPE-CD           PIC X(02)  VALUE SPACES.    
             10 S-RS2-ENERGY-UNIT-CD        PIC X(01)  VALUE SPACES.    
             10 S-RS2-VOL-TYPE-DESC         PIC X(25)  VALUE SPACES.    
             10 S-RS2-VOL-GROUP-SEQ         PIC S9(4) USAGE COMP        
                                                       VALUE 0.         
             10 S-RS2-CMPNT-ID-CD           PIC X(02)  VALUE SPACES.    
             10 S-RS2-MANUAL-ENTRY-FL       PIC X(01)  VALUE SPACES.    
             10 S-RS2-ACCUM-TOTAL-FL        PIC X(01)  VALUE SPACES.    
             10 S-RS2-BILL-PRINT-FL         PIC X(01)  VALUE SPACES.    
             10 S-RS2-COLUMN-HEADER1        PIC X(14)  VALUE SPACES.    
             10 S-RS2-COLUMN-HEADER2        PIC X(14)  VALUE SPACES.    
             10 S-RS2-COLUMN-HEADER3        PIC X(14)  VALUE SPACES.    
             10 S-RS2-COLUMN-HEADER4        PIC X(14)  VALUE SPACES.    
             10 S-RS2-STATUS-CD             PIC X(01)  VALUE SPACES.    
             10 S-RS2-STATUS-CHANGE-DT      PIC X(10)  VALUE SPACES.    
             10 S-RS2-LAST-UPDATE-TS        PIC X(26)  VALUE SPACES.    
             10 S-RS2-LAST-UPDATE-USERID    PIC X(07)  VALUE SPACES.    
                                                                        
      ****************************************************************  01690000
      *                                                              *  01700000
      *    ERROR PROCESSING VARIABLES                                *  01710000
      ****************************************************************  01720000
      *                                                                 01730000
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
      ******************************************************************01920000
      *               COBOL WORKING STORAGE COPY BOOKS                 *01930000
      ******************************************************************01940000
      ******************************************************************01950000
      *    DB2 INCLUDES                                                *01960000
      ******************************************************************01970000
           EXEC SQL                                                     01980000
              INCLUDE SQLCA                                             01990000
           END-EXEC.                                                    02000000
                                                                        
      ******************************************************************02020000
      *    CSS_BILLING_DET      BG                                     *02030000
      ******************************************************************02040000
           EXEC SQL                                                     02050000
              INCLUDE TBBLLDET                                          02060000
           END-EXEC.                                                    02070000
                                                                        
      ******************************************************************02090000
      *    CSS_BILLING_HDR      BI                                     *02100000
      ******************************************************************02110000
           EXEC SQL                                                     02120000
              INCLUDE TBBLLHDR                                          02130000
           END-EXEC.                                                    02140000
                                                                        
      ******************************************************************02150100
      *    CSS_VOL_GROUP      W7                                       *02150200
      ******************************************************************02150300
           EXEC SQL                                                     02150400
              INCLUDE TBVOLGRP                                          02150500
           END-EXEC.                                                    02150600
                                                                        
      ******************************************************************02150800
      *    CSS_VOL_TYPE       X8                                       *02150900
      ******************************************************************02151000
           EXEC SQL                                                     02151100
              INCLUDE TBVOLTYP                                          02151200
           END-EXEC.                                                    02151300
                                                                        
P00821******************************************************************02151500
P00821*    CSS_VOL_DAILY      ND                                       *02152000
P00821******************************************************************02153000
P00821     EXEC SQL                                                     02154000
P00821        INCLUDE TBVOLDLY                                          02155000
P00821     END-EXEC.                                                    02156000
P00821                                                                  
      ******************************************************************02160000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02170000
      ******************************************************************02180000
      ******************************************************************02190000
      *    ERROR HANDLING                                               02200000
      ******************************************************************02210000
           EXEC SQL                                                     02220000
               INCLUDE CWSX0010                                         02230000
           END-EXEC.                                                    02240000
                                                                        
      ******************************************************************02260000
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *02270000
      ******************************************************************02280000
           COPY CWS00303.                                               02290000
                                                                        
      ******************************************************************02310000
      *   CURSOR DECLARATION TO FETCH CSS_VOL_GROUP DATA               *02320000
      *                                                                *02330000
      ******************************************************************02340000
                                                                        
           EXEC SQL                                                     
               DECLARE VOL_GROUP_CUR CURSOR FOR                         
                SELECT W7.COMPANY_NO                                    
                      ,W7.CODE_UTIL_TYPE                                
                      ,W7.VOL_GROUP_CD                                  
                      ,W7.VOL_GROUP_DESC                                
                      ,W7.STATUS_CD                                     
                      ,W7.STATUS_CHANGE_DT                              
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           W7.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,W7.LAST_UPDATE_USERID                            
                  FROM CSS_VOL_GROUP            W7 WITH(READUNCOMMITTED)        
P00821           WHERE W7.CODE_UTIL_TYPE = :ND-CODE-UTIL-TYPE           
                  ORDER BY W7.VOL_GROUP_CD                              
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02360000
MFA-TR*        DECLARE VOL_GROUP_CUR CURSOR FOR                         02370000
MFA-TR*         SELECT W7.COMPANY_NO                                    02380000
MFA-TR*               ,W7.CODE_UTIL_TYPE                                02390000
MFA-TR*               ,W7.VOL_GROUP_CD                                  02400000
MFA-TR*               ,W7.VOL_GROUP_DESC                                02410000
MFA-TR*               ,W7.STATUS_CD                                     02420000
MFA-TR*               ,W7.STATUS_CHANGE_DT                              02430000
MFA-TR*               ,W7.LAST_UPDATE_TS                                02440000
MFA-TR*               ,W7.LAST_UPDATE_USERID                            02450000
MFA-TR*           FROM CSS_VOL_GROUP            W7                      02460000
MFA-TR*          WHERE W7.CODE_UTIL_TYPE = :ND-CODE-UTIL-TYPE           02461000
MFA-TR*           ORDER BY W7.VOL_GROUP_CD                              02470000
MFA-TR*           FOR FETCH ONLY WITH UR                                02480000
MFA-TR*           QUERYNO 7000                                          02490000
MFA-TR*    END-EXEC.                                                    02500000
                                                                        
      ******************************************************************02520000
      *   CURSOR DECLARATION TO FETCH CSS_VOL_TYPE DATA                *02530000
      *                                                                *02540000
      ******************************************************************02550000
           EXEC SQL                                                     
               DECLARE VOL_TYPE_CUR CURSOR FOR                          
               SELECT X8.COMPANY_NO                                     
                     ,X8.CODE_UTIL_TYPE                                 
                     ,X8.VOL_GROUP_CD                                   
                     ,X8.VOL_TYPE_CD                                    
                     ,X8.ENERGY_UNIT_CD                                 
                     ,X8.VOL_TYPE_DESC                                  
                     ,X8.VOL_GROUP_SEQ                                  
                     ,X8.CMPNT_ID_CD                                    
                     ,X8.MANUAL_ENTRY_FL                                
                     ,X8.ACCUM_TOTAL_FL                                 
                     ,X8.BILL_PRINT_FL                                  
                     ,X8.COLUMN_HEADER1                                 
                     ,X8.COLUMN_HEADER2                                 
                     ,X8.COLUMN_HEADER3                                 
                     ,X8.COLUMN_HEADER4                                 
                     ,X8.STATUS_CD                                      
                     ,X8.STATUS_CHANGE_DT                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           X8.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,X8.LAST_UPDATE_USERID                             
                 FROM CSS_VOL_TYPE            X8 WITH(READUNCOMMITTED)          
P00821          WHERE X8.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE        
P00821            AND (EXISTS (                                         
P00821                 SELECT 1                                         
P00821                   FROM CSS_VOL_DAILY   ND WITH(READUNCOMMITTED)          
P00821                  WHERE ND.VOL_TYPE_CD        = X8.VOL_TYPE_CD    
P00821                    AND ND.ENERGY_UNIT_CD     = X8.ENERGY_UNIT_CD 
P00821                    AND ND.CODE_UTIL_TYPE     = X8.CODE_UTIL_TYPE 
P00821                    AND ND.ACCOUNT_NO         = :ND-ACCOUNT-NO    
P00821                    AND ND.BILL_NO            = :ND-BILL-NO       
P00821                    AND ND.IC_NO              = :ND-IC-NO         
P00821                    AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE
P00821                    AND ND.BILL_ITEM_TIMESTMP =                   
P00821                       CIS.CHAR2TIMESTAMP(:ND-BILL-ITEM-TIMESTMP))        
P00821                 OR ( X8.MANUAL_ENTRY_FL        = 'Y'             
P00821                  AND :WS-UNBILLED-FLAG         = 'Y') )          
                 ORDER BY X8.VOL_TYPE_CD                                
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02560000
MFA-TR*        DECLARE VOL_TYPE_CUR CURSOR FOR                          02570000
MFA-TR*        SELECT X8.COMPANY_NO                                     02580000
MFA-TR*              ,X8.CODE_UTIL_TYPE                                 02590000
MFA-TR*              ,X8.VOL_GROUP_CD                                   02600000
MFA-TR*              ,X8.VOL_TYPE_CD                                    02610000
MFA-TR*              ,X8.ENERGY_UNIT_CD                                 02620000
MFA-TR*              ,X8.VOL_TYPE_DESC                                  02630000
MFA-TR*              ,X8.VOL_GROUP_SEQ                                  02640000
MFA-TR*              ,X8.CMPNT_ID_CD                                    02650000
MFA-TR*              ,X8.MANUAL_ENTRY_FL                                02660000
MFA-TR*              ,X8.ACCUM_TOTAL_FL                                 02670000
MFA-TR*              ,X8.BILL_PRINT_FL                                  02680000
MFA-TR*              ,X8.COLUMN_HEADER1                                 02690000
MFA-TR*              ,X8.COLUMN_HEADER2                                 02700000
MFA-TR*              ,X8.COLUMN_HEADER3                                 02710000
MFA-TR*              ,X8.COLUMN_HEADER4                                 02720000
MFA-TR*              ,X8.STATUS_CD                                      02730000
MFA-TR*              ,X8.STATUS_CHANGE_DT                               02740000
MFA-TR*              ,X8.LAST_UPDATE_TS                                 02750000
MFA-TR*              ,X8.LAST_UPDATE_USERID                             02760000
MFA-TR*          FROM CSS_VOL_TYPE            X8                        02770000
MFA-TR*         WHERE X8.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE        02771100
MFA-TR*           AND (EXISTS (                                         02771200
MFA-TR*                SELECT 1                                         02771300
MFA-TR*                  FROM CSS_VOL_DAILY   ND                        02772000
MFA-TR*                 WHERE ND.VOL_TYPE_CD        = X8.VOL_TYPE_CD    02773000
MFA-TR*                   AND ND.ENERGY_UNIT_CD     = X8.ENERGY_UNIT_CD 02773100
MFA-TR*                   AND ND.CODE_UTIL_TYPE     = X8.CODE_UTIL_TYPE 02773200
MFA-TR*                   AND ND.ACCOUNT_NO         = :ND-ACCOUNT-NO    02774000
MFA-TR*                   AND ND.BILL_NO            = :ND-BILL-NO       02775000
MFA-TR*                   AND ND.IC_NO              = :ND-IC-NO         02775100
MFA-TR*                   AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE02776000
MFA-TR*                   AND ND.BILL_ITEM_TIMESTMP =                   02777000
MFA-TR*                      :ND-BILL-ITEM-TIMESTMP)                    02777100
MFA-TR*                OR ( X8.MANUAL_ENTRY_FL        = 'Y'             02778002
MFA-TR*                 AND :WS-UNBILLED-FLAG         = 'Y') )          02779002
MFA-TR*          ORDER BY X8.VOL_TYPE_CD                                02780000
MFA-TR*          FOR FETCH ONLY WITH UR                                 02790000
MFA-TR*          QUERYNO 7100                                           02800000
MFA-TR*    END-EXEC.                                                    02810000
                                                                        
P00821 LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.                  
P00821 01 PARM-BILL-NO             PIC S9(9) USAGE COMP.                
P00821 01 PARM-CODE-UTIL-TYPE      PIC X(01).                           
P00821 01 PARM-IC-NO               PIC S9(4) USAGE COMP.                
P00821 01 PARM-BILL-ITEM-TIMESTMP  PIC X(26).                           
P00821                                                                  
P00821 PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
P00821                          PARM-BILL-NO                            
P00821                          PARM-CODE-UTIL-TYPE                     
P00821                          PARM-IC-NO                              
P00821                          PARM-BILL-ITEM-TIMESTMP.                
                                                                        
      ******************************************************************02860000
      * 0000-MAINLINE                                                  *02870000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02880000
      ******************************************************************02890000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03010000
      *                                                                *03020000
      * 0100-INITIALIZE                                                *03030000
      ******************************************************************03040000
       0100-INITIALIZE.                                                 
      *                                                                 03060000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 03100000
           PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
           PERFORM 0100B-DECLARE-GTT-R2          THRU 0100B-EXIT.       
      *                                                                 03130000
       0100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        03160000
      ******************************************************************03170000
      *                                                                *03180000
      * 0100A-DECLARE-GTT-R1                                           *03190000
      ******************************************************************03200000
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04720_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04720_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04720_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,VOL_GROUP_CD            SMALLINT                    
                   ,VOL_GROUP_DESC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,STATUS_CHANGE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,VOL_GROUP_CD                                     
                      ,LTRIM(RTRIM(VOL_GROUP_DESC))       AS 
           VOL_GROUP_DESC    
                      ,LTRIM(RTRIM(STATUS_CD))            AS STATUS_CD         
                      ,LTRIM(RTRIM(STATUS_CHANGE_DT))     AS 
           STATUS_CHANGE_DT  
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                  FROM #CSR04720_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03630000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            03640000
MFA-TR*                          WITH ROWSET POSITIONING FOR            03650000
MFA-TR*         SELECT RETURN_CODE                                      03660000
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO        03670000
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE    03680000
MFA-TR*               ,VOL_GROUP_CD                                     03690000
MFA-TR*               ,STRIP(VOL_GROUP_DESC)       AS VOL_GROUP_DESC    03700000
MFA-TR*               ,STRIP(STATUS_CD)            AS STATUS_CD         03710000
MFA-TR*               ,STRIP(STATUS_CHANGE_DT)     AS STATUS_CHANGE_DT  03720000
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS    03730000
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID03740000
MFA-TR*           FROM SESSION.CSR04720_R1                              03750000
MFA-TR*    END-EXEC.                                                    03760000
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************03810000
      *                                                                *03820000
      * 0100B-DECLARE-GTT-R2                                           *03830000
      ******************************************************************03840000
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04720_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04720_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04720_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,VOL_GROUP_CD            SMALLINT                    
                   ,VOL_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ENERGY_UNIT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,VOL_TYPE_DESC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,VOL_GROUP_SEQ           SMALLINT                    
                   ,CMPNT_ID_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MANUAL_ENTRY_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCUM_TOTAL_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BILL_PRINT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COLUMN_HEADER1 CHAR(14)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COLUMN_HEADER2 CHAR(14)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COLUMN_HEADER3 CHAR(14)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COLUMN_HEADER4 CHAR(14)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,STATUS_CHANGE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO          
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))     AS 
           CODE_UTIL_TYPE      
                      ,VOL_GROUP_CD                                     
                      ,LTRIM(RTRIM(VOL_TYPE_CD))        AS VOL_TYPE_CD         
                      ,LTRIM(RTRIM(ENERGY_UNIT_CD))     AS 
           ENERGY_UNIT_CD      
                      ,LTRIM(RTRIM(VOL_TYPE_DESC))      AS VOL_TYPE_DESC       
                      ,VOL_GROUP_SEQ                                    
                      ,LTRIM(RTRIM(CMPNT_ID_CD))        AS CMPNT_ID_CD         
                      ,LTRIM(RTRIM(MANUAL_ENTRY_FL))    AS 
           MANUAL_ENTRY_FL     
                      ,LTRIM(RTRIM(ACCUM_TOTAL_FL))     AS 
           ACCUM_TOTAL_FL      
                      ,LTRIM(RTRIM(BILL_PRINT_FL))      AS BILL_PRINT_FL       
                      ,LTRIM(RTRIM(COLUMN_HEADER1))     AS 
           COLUMN_HEADER1      
                      ,LTRIM(RTRIM(COLUMN_HEADER2))     AS 
           COLUMN_HEADER2      
                      ,LTRIM(RTRIM(COLUMN_HEADER3))     AS 
           COLUMN_HEADER3      
                      ,LTRIM(RTRIM(COLUMN_HEADER4))     AS 
           COLUMN_HEADER4      
                      ,LTRIM(RTRIM(STATUS_CD))          AS STATUS_CD           
                      ,LTRIM(RTRIM(STATUS_CHANGE_DT))   AS 
           STATUS_CHANGE_DT    
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))     AS 
           LAST_UPDATE_TS      
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID)) AS 
           LAST_UPDATE_USERID  
                  FROM #CSR04720_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04380000
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            04390000
MFA-TR*                          WITH ROWSET POSITIONING FOR            04400000
MFA-TR*         SELECT RETURN_CODE                                      04410000
MFA-TR*               ,STRIP(COMPANY_NO)         AS COMPANY_NO          04420000
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)     AS CODE_UTIL_TYPE      04430000
MFA-TR*               ,VOL_GROUP_CD                                     04440000
MFA-TR*               ,STRIP(VOL_TYPE_CD)        AS VOL_TYPE_CD         04450000
MFA-TR*               ,STRIP(ENERGY_UNIT_CD)     AS ENERGY_UNIT_CD      04460000
MFA-TR*               ,STRIP(VOL_TYPE_DESC)      AS VOL_TYPE_DESC       04470000
MFA-TR*               ,VOL_GROUP_SEQ                                    04480000
MFA-TR*               ,STRIP(CMPNT_ID_CD)        AS CMPNT_ID_CD         04490000
MFA-TR*               ,STRIP(MANUAL_ENTRY_FL)    AS MANUAL_ENTRY_FL     04500000
MFA-TR*               ,STRIP(ACCUM_TOTAL_FL)     AS ACCUM_TOTAL_FL      04510000
MFA-TR*               ,STRIP(BILL_PRINT_FL)      AS BILL_PRINT_FL       04520000
MFA-TR*               ,STRIP(COLUMN_HEADER1)     AS COLUMN_HEADER1      04530000
MFA-TR*               ,STRIP(COLUMN_HEADER2)     AS COLUMN_HEADER2      04540000
MFA-TR*               ,STRIP(COLUMN_HEADER3)     AS COLUMN_HEADER3      04550000
MFA-TR*               ,STRIP(COLUMN_HEADER4)     AS COLUMN_HEADER4      04560000
MFA-TR*               ,STRIP(STATUS_CD)          AS STATUS_CD           04570000
MFA-TR*               ,STRIP(STATUS_CHANGE_DT)   AS STATUS_CHANGE_DT    04580000
MFA-TR*               ,STRIP(LAST_UPDATE_TS)     AS LAST_UPDATE_TS      04590000
MFA-TR*               ,STRIP(LAST_UPDATE_USERID) AS LAST_UPDATE_USERID  04600000
MFA-TR*           FROM SESSION.CSR04720_R2                              04610000
MFA-TR*    END-EXEC.                                                    04620000
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************04670000
      *                                                                *04680000
      * 1000-PROCESS-INPUT                                             *04690000
      ******************************************************************04700000
       1000-PROCESS-INPUT.                                              
      *                                                                 04720000
           MOVE WS-ZERO                     TO CTR-ROWS-RS1             
                                               CTR-ROWS-RS2.            
P00821     MOVE PARM-ACCOUNT-NO             TO ND-ACCOUNT-NO            
P00821                                         BG-ACCOUNT-NO.           
P00821     MOVE PARM-BILL-NO                TO ND-BILL-NO               
P00821                                         BG-BILL-NO.              
P00821     MOVE PARM-CODE-UTIL-TYPE         TO ND-CODE-UTIL-TYPE        
P00821                                         BG-CODE-UTIL-TYPE.       
P00821     MOVE PARM-IC-NO                  TO ND-IC-NO                 
P00821                                         BG-IC-NO.                
P00821     MOVE PARM-BILL-ITEM-TIMESTMP     TO ND-BILL-ITEM-TIMESTMP    
P00821                                         BG-BILL-ITEM-TIMESTMP.   
                                                                        
           INITIALIZE                          DCLCSS-VOL-GROUP         
                                               DCLCSS-VOL-TYPE.         
      *                                                                 04780000
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04820000
      *                                                                *04830000
      * 2000-PROCESS-OUTPUT                                            *04840000
      ******************************************************************04850000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-UNBILLED-FLAG        THRU 7000-EXIT.        
           PERFORM 2010-PROCESS-VOL-GROUP-CUR    THRU 2010-EXIT.        
           PERFORM 2110-PROCESS-VOL-TYPE-CUR     THRU 2110-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04940000
      *                                                                *04950000
      * 2000A-MOVE-RS1.                                                *04960000
      ******************************************************************04970000
       2000A-MOVE-RS1.                                                  
           MOVE W7-COMPANY-NO               TO S-RS1-COMPANY-NO.        
           MOVE W7-CODE-UTIL-TYPE           TO S-RS1-CODE-UTIL-TYPE.    
           MOVE W7-VOL-GROUP-CD             TO S-RS1-VOL-GROUP-CD.      
           MOVE W7-VOL-GROUP-DESC           TO S-RS1-VOL-GROUP-DESC.    
           MOVE W7-STATUS-CD                TO S-RS1-STATUS-CD.         
           MOVE W7-STATUS-CHANGE-DT         TO S-RS1-STATUS-CHANGE-DT.  
           MOVE W7-LAST-UPDATE-TS           TO S-RS1-LAST-UPDATE-TS.    
           MOVE W7-LAST-UPDATE-USERID       TO S-RS1-LAST-UPDATE-USERID.
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************05100000
      *                                                                *05110000
      * 2000B-MOVE-RS2.                                                *05120000
      ******************************************************************05130000
       2000B-MOVE-RS2.                                                  
           MOVE X8-COMPANY-NO               TO S-RS2-COMPANY-NO.        
           MOVE X8-CODE-UTIL-TYPE           TO S-RS2-CODE-UTIL-TYPE.    
           MOVE X8-VOL-GROUP-CD             TO S-RS2-VOL-GROUP-CD.      
           MOVE X8-VOL-TYPE-CD              TO S-RS2-VOL-TYPE-CD.       
           MOVE X8-ENERGY-UNIT-CD           TO S-RS2-ENERGY-UNIT-CD.    
           MOVE X8-VOL-TYPE-DESC            TO S-RS2-VOL-TYPE-DESC.     
           MOVE X8-VOL-GROUP-SEQ            TO S-RS2-VOL-GROUP-SEQ.     
           MOVE X8-CMPNT-ID-CD              TO S-RS2-CMPNT-ID-CD.       
           MOVE X8-MANUAL-ENTRY-FL          TO S-RS2-MANUAL-ENTRY-FL.   
           MOVE X8-ACCUM-TOTAL-FL           TO S-RS2-ACCUM-TOTAL-FL.    
           MOVE X8-BILL-PRINT-FL            TO S-RS2-BILL-PRINT-FL.     
           MOVE X8-COLUMN-HEADER1           TO S-RS2-COLUMN-HEADER1.    
           MOVE X8-COLUMN-HEADER2           TO S-RS2-COLUMN-HEADER2.    
           MOVE X8-COLUMN-HEADER3           TO S-RS2-COLUMN-HEADER3.    
           MOVE X8-COLUMN-HEADER4           TO S-RS2-COLUMN-HEADER4.    
           MOVE X8-STATUS-CD                TO S-RS2-STATUS-CD.         
           MOVE X8-STATUS-CHANGE-DT         TO S-RS2-STATUS-CHANGE-DT.  
           MOVE X8-LAST-UPDATE-TS           TO S-RS2-LAST-UPDATE-TS.    
           MOVE X8-LAST-UPDATE-USERID       TO S-RS2-LAST-UPDATE-USERID.
       2000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************05370000
      *                                                                *05380000
      * 2010-PROCESS-VOL-GROUP-CUR.                                    *05390000
      ******************************************************************05400000
       2010-PROCESS-VOL-GROUP-CUR.                                      
                                                                        
           PERFORM 7010-OPEN-VOL-GROUP-CUR       THRU 7010-EXIT.        
           PERFORM 7020-FETCH-VOL-GROUP-CUR      THRU 7020-EXIT         
                                                UNTIL NO-MORE-GRP-ROWS  
           PERFORM 7030-CLOSE-VOL-GROUP-CUR      THRU 7030-EXIT.        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05500000
      *                                                                *05510000
      * 2110-PROCESS-VOL-TYPE-CUR.                                     *05520000
      ******************************************************************05530000
       2110-PROCESS-VOL-TYPE-CUR.                                       
                                                                        
           PERFORM 7110-OPEN-VOL-TYPE-CUR        THRU 7110-EXIT.        
           PERFORM 7120-FETCH-VOL-TYPE-CUR       THRU 7120-EXIT         
                                                UNTIL NO-MORE-TYPE-ROWS 
           PERFORM 7130-CLOSE-VOL-TYPE-CUR       THRU 7130-EXIT.        
       2110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05611000
      *                                                                *05612000
      * 7000-GET-UNBILLED-FLAG                                         *05613000
      ******************************************************************05614000
      *                                                                 05614100
       7000-GET-UNBILLED-FLAG.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-UNBILLED-FLAG                                  
                FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
               WHERE BI.DATE_BILLED        IS NULL                      
                 AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
                 AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
                 AND BG.IC_NO              = :BG-IC-NO                  
                 AND BG.BILL_NO            = :BG-BILL-NO                
                 AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )     
                 AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO              
                 AND BI.BILL_NO            = BG.BILL_NO                 
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05617000
MFA-TR*       SELECT 'Y'                                                05617100
MFA-TR*         INTO :WS-UNBILLED-FLAG                                  05617200
MFA-TR*         FROM CSS_BILLING_HDR BI                                 05617300
MFA-TR*             ,CSS_BILLING_DET BG                                 05617400
MFA-TR*        WHERE BI.DATE_BILLED        IS NULL                      05617700
MFA-TR*          AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             05617800
MFA-TR*          AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         05617900
MFA-TR*          AND BG.IC_NO              = :BG-IC-NO                  05618002
MFA-TR*          AND BG.BILL_NO            = :BG-BILL-NO                05618102
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP     05618202
MFA-TR*          AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO              05618302
MFA-TR*          AND BI.BILL_NO            = BG.BILL_NO                 05618402
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             05618502
MFA-TR*    END-EXEC.                                                    05621100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_DET'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE BG-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE 'BILL_NO'             TO TABLE-ELEMENT-3             
              MOVE BG-BILL-NO            TO HOSTVAR-ELEMENT-3           
              MOVE 'BILL_ITEM_TIMESTMP'  TO TABLE-ELEMENT-4             
              MOVE BG-BILL-ITEM-TIMESTMP TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        7000-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************05630000
      *                                                                *05640000
      * 7010-OPEN-VOL-GROUP-CUR.                                       *05650000
      ******************************************************************05660000
       7010-OPEN-VOL-GROUP-CUR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN VOL_GROUP_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_VOL_GROUP'       TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05920000
      *                                                                *05930000
      * 7020-FETCH-VOL-GROUP-CUR.                                      *05940000
      ******************************************************************05950000
       7020-FETCH-VOL-GROUP-CUR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH VOL_GROUP_CUR                                      
                INTO :W7-COMPANY-NO                                     
                    ,:W7-CODE-UTIL-TYPE                                 
                    ,:W7-VOL-GROUP-CD                                   
                    ,:W7-VOL-GROUP-DESC                                 
                    ,:W7-STATUS-CD                                      
                    ,:W7-STATUS-CHANGE-DT                               
                    ,:W7-LAST-UPDATE-TS                                 
                    ,:W7-LAST-UPDATE-USERID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    PERFORM 2000A-MOVE-RS1       THRU 2000A-EXIT        
                    PERFORM 8010-INSERT-GTT-R1   THRU 8010-EXIT         
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-GRP-ROWS      
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7020'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_VOL_GROUP'    TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06340000
      *                                                                *06350000
      * 7030-CLOSE-VOL-GROUP-CUR.                                      *06360000
      ******************************************************************06370000
       7030-CLOSE-VOL-GROUP-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE VOL_GROUP_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_VOL_GROUP'          TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06630000
      *                                                                *06640000
      * 7110-OPEN-VOL-TYPE-CUR.                                        *06650000
      ******************************************************************06660000
       7110-OPEN-VOL-TYPE-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN VOL_TYPE_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_VOL_TYPE'        TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06920000
      *                                                                *06930000
      * 7120-FETCH-VOL-TYPE-CUR.                                       *06940000
      ******************************************************************06950000
       7120-FETCH-VOL-TYPE-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH VOL_TYPE_CUR                                       
                INTO :X8-COMPANY-NO                                     
                    ,:X8-CODE-UTIL-TYPE                                 
                    ,:X8-VOL-GROUP-CD                                   
                    ,:X8-VOL-TYPE-CD                                    
                    ,:X8-ENERGY-UNIT-CD                                 
                    ,:X8-VOL-TYPE-DESC                                  
                    ,:X8-VOL-GROUP-SEQ                                  
                    ,:X8-CMPNT-ID-CD                                    
                    ,:X8-MANUAL-ENTRY-FL                                
                    ,:X8-ACCUM-TOTAL-FL                                 
                    ,:X8-BILL-PRINT-FL                                  
                    ,:X8-COLUMN-HEADER1                                 
                    ,:X8-COLUMN-HEADER2                                 
                    ,:X8-COLUMN-HEADER3                                 
                    ,:X8-COLUMN-HEADER4                                 
                    ,:X8-STATUS-CD                                      
                    ,:X8-STATUS-CHANGE-DT                               
                    ,:X8-LAST-UPDATE-TS                                 
                    ,:X8-LAST-UPDATE-USERID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    PERFORM 2000B-MOVE-RS2       THRU 2000B-EXIT        
                    PERFORM 8020-INSERT-GTT-R2   THRU 8020-EXIT         
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-TYPE-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7120'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_VOL_TYPE'     TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07450000
      *                                                                *07460000
      * 7130-CLOSE-VOL-TYPE-CUR.                                       *07470000
      ******************************************************************07480000
       7130-CLOSE-VOL-TYPE-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE VOL_TYPE_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7130'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_VOL_TYPE'           TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07740000
      *                                                               * 07750000
      * 8000A-DEL-GTT-ROWS.                                           * 07760000
      ***************************************************************** 07770000
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04720_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07800000
MFA-TR*        DELETE FROM SESSION.CSR04720_R1                          07810000
MFA-TR*    END-EXEC.                                                    07820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04720_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ***************************************************************** 08100000
      *                                                               * 08110000
      * 8000B-DEL-GTT-ROWS.                                           * 08120000
      ***************************************************************** 08130000
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04720_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     08160000
MFA-TR*        DELETE FROM SESSION.CSR04720_R2                          08170000
MFA-TR*    END-EXEC.                                                    08180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04720_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************08460000
      *                                                                *08470000
      * 8010-INSERT-GTT-R1.                                            *08480000
      ******************************************************************08490000
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04720_R1                           
                 ( RETURN_CODE                                          
                  ,COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,VOL_GROUP_CD                                         
                  ,VOL_GROUP_DESC                                       
                  ,STATUS_CD                                            
                  ,STATUS_CHANGE_DT                                     
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                 )                                                      
              VALUES                                                    
                 ( :S-RETURN-CODE-1                                     
                  ,:S-RS1-COMPANY-NO                                    
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-VOL-GROUP-CD                                  
                  ,:S-RS1-VOL-GROUP-DESC                                
                  ,:S-RS1-STATUS-CD                                     
                  ,:S-RS1-STATUS-CHANGE-DT                              
                  ,:S-RS1-LAST-UPDATE-TS                                
                  ,:S-RS1-LAST-UPDATE-USERID                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     08520000
MFA-TR*       INSERT INTO SESSION.CSR04720_R1                           08530000
MFA-TR*          ( RETURN_CODE                                          08540000
MFA-TR*           ,COMPANY_NO                                           08550000
MFA-TR*           ,CODE_UTIL_TYPE                                       08560000
MFA-TR*           ,VOL_GROUP_CD                                         08570000
MFA-TR*           ,VOL_GROUP_DESC                                       08580000
MFA-TR*           ,STATUS_CD                                            08590000
MFA-TR*           ,STATUS_CHANGE_DT                                     08600000
MFA-TR*           ,LAST_UPDATE_TS                                       08610000
MFA-TR*           ,LAST_UPDATE_USERID                                   08620000
MFA-TR*          )                                                      08630000
MFA-TR*       VALUES                                                    08640000
MFA-TR*          ( :S-RETURN-CODE-1                                     08650000
MFA-TR*           ,:S-RS1-COMPANY-NO                                    08660000
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                08670000
MFA-TR*           ,:S-RS1-VOL-GROUP-CD                                  08680000
MFA-TR*           ,:S-RS1-VOL-GROUP-DESC                                08690000
MFA-TR*           ,:S-RS1-STATUS-CD                                     08700000
MFA-TR*           ,:S-RS1-STATUS-CHANGE-DT                              08710000
MFA-TR*           ,:S-RS1-LAST-UPDATE-TS                                08720000
MFA-TR*           ,:S-RS1-LAST-UPDATE-USERID                            08730000
MFA-TR*          )                                                      08740000
MFA-TR*    END-EXEC.                                                    08750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              INITIALIZE DCLCSS-VOL-GROUP                               
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04720_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************09010000
      *                                                                *09020000
      * 8020-INSERT-GTT-R2.                                            *09030000
      ******************************************************************09040000
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04720_R2                           
                 (   RETURN_CODE                                        
                    ,COMPANY_NO                                         
                    ,CODE_UTIL_TYPE                                     
                    ,VOL_GROUP_CD                                       
                    ,VOL_TYPE_CD                                        
                    ,ENERGY_UNIT_CD                                     
                    ,VOL_TYPE_DESC                                      
                    ,VOL_GROUP_SEQ                                      
                    ,CMPNT_ID_CD                                        
                    ,MANUAL_ENTRY_FL                                    
                    ,ACCUM_TOTAL_FL                                     
                    ,BILL_PRINT_FL                                      
                    ,COLUMN_HEADER1                                     
                    ,COLUMN_HEADER2                                     
                    ,COLUMN_HEADER3                                     
                    ,COLUMN_HEADER4                                     
                    ,STATUS_CD                                          
                    ,STATUS_CHANGE_DT                                   
                    ,LAST_UPDATE_TS                                     
                    ,LAST_UPDATE_USERID                                 
                 )                                                      
              VALUES                                                    
                 ( :S-RETURN-CODE-2                                     
                  ,:S-RS2-COMPANY-NO                                    
                  ,:S-RS2-CODE-UTIL-TYPE                                
                  ,:S-RS2-VOL-GROUP-CD                                  
                  ,:S-RS2-VOL-TYPE-CD                                   
                  ,:S-RS2-ENERGY-UNIT-CD                                
                  ,:S-RS2-VOL-TYPE-DESC                                 
                  ,:S-RS2-VOL-GROUP-SEQ                                 
                  ,:S-RS2-CMPNT-ID-CD                                   
                  ,:S-RS2-MANUAL-ENTRY-FL                               
                  ,:S-RS2-ACCUM-TOTAL-FL                                
                  ,:S-RS2-BILL-PRINT-FL                                 
                  ,:S-RS2-COLUMN-HEADER1                                
                  ,:S-RS2-COLUMN-HEADER2                                
                  ,:S-RS2-COLUMN-HEADER3                                
                  ,:S-RS2-COLUMN-HEADER4                                
                  ,:S-RS2-STATUS-CD                                     
                  ,:S-RS2-STATUS-CHANGE-DT                              
                  ,:S-RS2-LAST-UPDATE-TS                                
                  ,:S-RS2-LAST-UPDATE-USERID                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     09070000
MFA-TR*       INSERT INTO SESSION.CSR04720_R2                           09080000
MFA-TR*          (   RETURN_CODE                                        09090000
MFA-TR*             ,COMPANY_NO                                         09100000
MFA-TR*             ,CODE_UTIL_TYPE                                     09110000
MFA-TR*             ,VOL_GROUP_CD                                       09120000
MFA-TR*             ,VOL_TYPE_CD                                        09130000
MFA-TR*             ,ENERGY_UNIT_CD                                     09140000
MFA-TR*             ,VOL_TYPE_DESC                                      09150000
MFA-TR*             ,VOL_GROUP_SEQ                                      09160000
MFA-TR*             ,CMPNT_ID_CD                                        09170000
MFA-TR*             ,MANUAL_ENTRY_FL                                    09180000
MFA-TR*             ,ACCUM_TOTAL_FL                                     09190000
MFA-TR*             ,BILL_PRINT_FL                                      09200000
MFA-TR*             ,COLUMN_HEADER1                                     09210000
MFA-TR*             ,COLUMN_HEADER2                                     09220000
MFA-TR*             ,COLUMN_HEADER3                                     09230000
MFA-TR*             ,COLUMN_HEADER4                                     09240000
MFA-TR*             ,STATUS_CD                                          09250000
MFA-TR*             ,STATUS_CHANGE_DT                                   09260000
MFA-TR*             ,LAST_UPDATE_TS                                     09270000
MFA-TR*             ,LAST_UPDATE_USERID                                 09280000
MFA-TR*          )                                                      09290000
MFA-TR*       VALUES                                                    09300000
MFA-TR*          ( :S-RETURN-CODE-2                                     09310000
MFA-TR*           ,:S-RS2-COMPANY-NO                                    09320000
MFA-TR*           ,:S-RS2-CODE-UTIL-TYPE                                09330000
MFA-TR*           ,:S-RS2-VOL-GROUP-CD                                  09340000
MFA-TR*           ,:S-RS2-VOL-TYPE-CD                                   09350000
MFA-TR*           ,:S-RS2-ENERGY-UNIT-CD                                09360000
MFA-TR*           ,:S-RS2-VOL-TYPE-DESC                                 09370000
MFA-TR*           ,:S-RS2-VOL-GROUP-SEQ                                 09380000
MFA-TR*           ,:S-RS2-CMPNT-ID-CD                                   09390000
MFA-TR*           ,:S-RS2-MANUAL-ENTRY-FL                               09400000
MFA-TR*           ,:S-RS2-ACCUM-TOTAL-FL                                09410000
MFA-TR*           ,:S-RS2-BILL-PRINT-FL                                 09420000
MFA-TR*           ,:S-RS2-COLUMN-HEADER1                                09430000
MFA-TR*           ,:S-RS2-COLUMN-HEADER2                                09440000
MFA-TR*           ,:S-RS2-COLUMN-HEADER3                                09450000
MFA-TR*           ,:S-RS2-COLUMN-HEADER4                                09460000
MFA-TR*           ,:S-RS2-STATUS-CD                                     09470000
MFA-TR*           ,:S-RS2-STATUS-CHANGE-DT                              09480000
MFA-TR*           ,:S-RS2-LAST-UPDATE-TS                                09490000
MFA-TR*           ,:S-RS2-LAST-UPDATE-USERID                            09500000
MFA-TR*          )                                                      09510000
MFA-TR*    END-EXEC.                                                    09520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              INITIALIZE DCLCSS-VOL-TYPE                                
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04720_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ***************************************************************** 09780000
      *                                                               * 09790000
      * 8800-CHECK-RESULTS.                                           * 09800000
      ***************************************************************** 09810000
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE DCLCSS-VOL-GROUP                               
              MOVE   0                       TO S-RETURN-CODE-1         
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                 09890000
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE DCLCSS-VOL-TYPE                                
              MOVE   0                       TO S-RETURN-CODE-2         
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                 09950000
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09990000
      *                                                                *10000000
      * 8900-SEND-DONE.                                                *10010000
      ******************************************************************10020000
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04720_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04720_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10450000
      *                                                                *10460000
      * 9000-SEND-ERROR-RESULT                                         *10470000
      ******************************************************************10480000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE  GTT-RETURN-FIELDS                                
                       DCLCSS-VOL-GROUP                                 
                       DCLCSS-VOL-TYPE.                                 
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE.           
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10790000
      * 9700-ABEND-PROCESSING.                                         *10800000
      ******************************************************************10810000
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10900000
      * 9900-SQL-ERROR-ROUTINE.                                        *10910000
      ******************************************************************10920000
                                                                        
           EXEC SQL                                                     10940000
              INCLUDE CPDSP300                                          10950000
           END-EXEC.                                                    10960000
                                                                        
      ******************************************************************10980000
      * 9999-END-PROGRAM.                                              *10990000
      ******************************************************************11000000
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
