       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04717.                                         
COB303 DATE-WRITTEN.  DECEMBER 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS TO UPDATE THE DAILY VOLUME UNITS.HE DAILY   *        
      *                                                                *        
      *  THIS STORED PROCEDURE IS CLONED FROM CSR02531 UPDATE LOGIC.   *        
      ******************************************************************        
      *--                                                            --*        
      *--  PARAMETERS                                                --*        
      *--                                                            --*        
      *--      INPUT                                                 --*        
      *--            NONE                                            --*        
      *--                                                            --*        
      *--      OUT                                                   --*        
      *--                                                            --*        
      *--            NONE                                            --*        
      *--                                                            --*        
      *--      INOUT                                                 --*        
      *--                                                            --*        
      *--            NONE                                            --*        
      *--                                                            --*        
      *--  RESULT SET                                                --*        
      *--                                                            --*        
      *--  CSR04717_R1 - BUS RULE DETAILS                            --*        
      *--                                                            --*        
      *--            RETURN_CODE             INTEGER                 --*        
      *--           ,APPL_RETURN_CODE        INTEGER                 --*        
      *--           ,BUS_RULE_ID             CHAR(10)                --*        
      *--           ,BUS_RULE_RESULT_CD      CHAR(10)                --*        
      *--           ,BUS_RULE_XREF_ID        CHAR(26)                --*        
      *--                                                            --*        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/04/13  AD7F921    INITIAL VERSION.                         *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04717'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_BILLING_DET        BG                                   **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_VOL_DAILY          ND                                   **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBVOLDLY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_VOL_TYPE           X8                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBVOLTYP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_TRNSP_CONTRACT     TW                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBTRNCNT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_TRNSP_VOL_BLK       TZ                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBTRNBLK                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_MT_TRN_HST_DET      MI                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_MNT_TRANS_HIST      MH                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_USER_PROFILE        PF                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *    COPY SYGWCOB.                                                        
           COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           COPY CWS00038.                                                       
           COPY CWS00114.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1               PIC S9(9) COMP VALUE 0.       
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-SQLSTATE                PIC X(05) VALUE SPACES.       
           05  WS-GTT-NAME                PIC X(26) VALUE SPACES.       
           05  WS-ERR-INSRT-R1            PIC X(01) VALUE 'N'.          
           05  WS-APPL-RETURN-CODE        PIC S9(04) COMP VALUE 0.      
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR ICP CSS_UTIL_ENVRNMT           *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS1-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS1-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
      *                                                                         
       01  SWITCHES.                                                    
           05  MULTI-UPDT-SW              PIC X(01) VALUE 'N'.          
               88 MULTI-UPDT                        VALUE 'Y'.          
           05  WS-NEGATIVE-UNITS          PIC X(01) VALUE 'N'.          
               88 NEGATIVE-UNITS                    VALUE 'Y'.          
           05  WS-FCTR-ID-EXISTS          PIC X(01) VALUE 'N'.          
               88 FCTR-ID-EXISTS                    VALUE 'Y'.          
               88 FCTR-ID-MISSING                   VALUE 'N'.          
      *                                                                         
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME               PIC X(08)  VALUE 'CSR04717'.  
           05  WS-PGRMNAME                PIC X(08)  VALUE 'CSR04717'.  
      *                                                                         
       01  STORAGE-FIELDS.                                              
           05  WS-PARM-FIELDS.                                          
COB305         10 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
               10 WS-CODE-UTIL-TYPE       PIC X(1).                     
               10 WS-BILL-NO              PIC S9(9) USAGE COMP.         
               10 WS-IC-NO                PIC S9(04) COMP.              
               10 WS-BILL-ITEM-TIMESTMP   PIC X(26).                    
               10 WS-TRSP-BG-TIMESTMP     PIC X(26).                    
               10 WS-VOL-TYPE-CD          PIC X(02).                    
               10 WS-ENERGY-UNIT-CD       PIC X(01).                    
               10 WS-ACTION-IND           PIC X(01).                    
               10 WS-USERID               PIC X(08) VALUE SPACES.       
               10 WS-INPUT-DATE-READ      PIC X(250).                   
               10 WS-INPUT-UNITS          PIC X(250).                   
           05  WS-LITERALS.                                             
               10 WS-ST                   PIC X(02) VALUE 'ST'.         
               10 WS-NT                   PIC X(02) VALUE 'NT'.         
               10 WS-DT                   PIC X(02) VALUE 'DT'.         
               10 WS-EG                   PIC X(02) VALUE 'EG'.         
               10 WS-I                    PIC X(01) VALUE 'I'.          
               10 WS-U                    PIC X(01) VALUE 'U'.          
               10 WS-R                    PIC X(01) VALUE 'R'.          
               10 WS-D                    PIC X(01) VALUE 'D'.          
               10 WS-DILIMITER            PIC X(01) VALUE ';'.          
               10 WS-FAILED               PIC X(01) VALUE 'F'.          
               10 WS-INFO                 PIC X(01) VALUE 'I'.          
               10 WS-TRANSCO              PIC X(07) VALUE 'TRANSCO'.    
               10 WS-1                    PIC 9(01) VALUE 1.            
               10 WS-250                  PIC 9(03) VALUE 250.          
               10 WS-100                  PIC 9(03) VALUE 100.          
           05  WS-SWITCHES.                                             
               10 WS-END-DATA             PIC X(01) VALUE 'N'.          
                  88 END-DATA                       VALUE 'Y'.          
               10 WS-DATE-READ-OVERFL     PIC X(01) VALUE 'Y'.          
                  88 DATE-READ-OVERFL               VALUE 'Y'.          
           05  WS-DERIVED-FIELDS.                                       
               10 WS-TEMP-DATE-READ       PIC X(250) VALUE SPACES.      
               10 WS-TEMP-UNITS           PIC X(250) VALUE SPACES.      
               10 WS-DATE-RD              PIC X(10).                    
               10 WS-VOL-NO-UNITS         PIC X(11) JUSTIFIED RIGHT.    
               10 WS-CNTR                 PIC S9(03) VALUE ZEROS.       
               10 WS-UNITS-CNTR           PIC S9(03) VALUE ZEROS.       
               10 WS-CNTR1                PIC S9(03) VALUE ZEROS.       
               10 WS-UNITS-CNTR1          PIC S9(03) VALUE ZEROS.       
               10 WS-CNTR2                PIC S9(03) VALUE 250.         
               10 WS-UNITS-CNTR2          PIC S9(03) VALUE 250.         
               10 WS-DATE-TEMP.                                         
                  15 WS-TEMP-CCYY         PIC X(04).                    
                  15 FILLER               PIC X(01) VALUE '-'.          
                  15 WS-TEMP-MM           PIC X(02).                    
                  15 FILLER               PIC X(01) VALUE '-'.          
                  15 WS-TEMP-DD           PIC X(02).                    
               10 WS-DATE-FRMT.                                         
                  15 WS-FRMT-MM           PIC X(02).                    
                  15 WS-FRMT-DD           PIC X(02).                    
                  15 WS-FRMT-CCYY         PIC X(04).                    
               10 WS-NO-UNITS-BRK.                                      
                  15 WS-NO-UNITS-INT      PIC X(09).                    
                  15 FILLER               PIC X(01) VALUE '.'.          
                  15 WS-NO-UNITS-DEC      PIC X(01).                    
               10 WS-NO-UNITS-NUM.                                      
                  15 WS-NO-UNITS-INT-N    PIC X(09).                    
                  15 WS-NO-UNITS-DEC-N    PIC X(01).                    
               10 WS-NO-UNITS-NUM-RED REDEFINES WS-NO-UNITS-NUM         
                                          PIC 9(09)V9.                  
               10 WS-COMP-2-CHAR-CONV     PIC -(8)9.9 VALUE ZEROS.      
               10 WS-NO-UNITS-TEMP        PIC S9(9)V9(1) USAGE COMP-3   
                                                    VALUE ZEROS.        
               10 WS-PREV-NO-UNITS        PIC S9(9)V9(1) USAGE COMP-3   
                                                    VALUE ZEROS.        
               10  WS-INSPECT-CNTR        PIC 99 VALUE ZERO.            
      *                                                                         
           05  WS-NULL-INDICATORS.                                      
               10 WS-NULL-IND1            PIC S9(04)  COMP.             
               10 WS-NULL-IND2            PIC S9(04)  COMP.             
      *                                                                         
       01 WS-INPUT-DATA-TABLE.                                          
          05 WS-INPUT-DATA-TAB OCCURS 31 TIMES INDEXED BY WS-SUB.       
             10 WS-DATE-READ              PIC X(08).                    
             10 WS-NO-UNITS               PIC X(11) JUSTIFIED RIGHT.    
      *                                                                         
      *                                                                         
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-CURRENT-DATE            PIC X(10) VALUE SPACES.       
           05  WS-CURRENT-TIMESTAMP       PIC X(26) VALUE SPACES.       
           05  WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.       
      *                                                                         
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE          PIC X(01) VALUE 'F'.          
           05  WS-TRAN-APPL-NO            PIC S9(02) VALUE 0.           
           05  WS-COLUMN-DESC             PIC X(15).                    
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(30).                    
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02).                   
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(30).                    
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02).                   
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
COB305 01 PARM-ACCOUNT-NO        PIC  S9(13)V USAGE COMP-3 VALUE 0.    
       01 PARM-BILL-NO                    PIC  S9(9) USAGE COMP.        
       01 PARM-CODE-UTIL-TYPE             PIC  X(01).                   
       01 PARM-IC-NO                      PIC  S9(4) USAGE COMP.        
       01 PARM-BILL-ITEM-TIMESTMP         PIC  X(26).                   
       01 PARM-VOL-TYPE-CD                PIC  X(02).                   
       01 PARM-ENERGY-UNIT-CD             PIC  X(01).                   
       01 PARM-DATE-READ                  PIC  X(250).                  
       01 PARM-UNITS                      PIC  X(250).                  
       01 PARM-ACTION-IND                 PIC  X(01).                   
       01 PARM-USER-ID                    PIC  X(07).                   
       01 PARM-COMMENT-TEXT               PIC  X(210).                  
       01 PARM-COMMENT-LEN                PIC  S9(04) USAGE COMP.       
      *                                                                         
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                ,PARM-BILL-NO                           
                                ,PARM-CODE-UTIL-TYPE                    
                                ,PARM-IC-NO                             
                                ,PARM-BILL-ITEM-TIMESTMP                
                                ,PARM-VOL-TYPE-CD                       
                                ,PARM-ENERGY-UNIT-CD                    
                                ,PARM-DATE-READ                         
                                ,PARM-UNITS                             
                                ,PARM-ACTION-IND                        
                                ,PARM-USER-ID                           
                                ,PARM-COMMENT-TEXT                      
                                ,PARM-COMMENT-LEN.                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                THRU 0100-EXIT.       
           PERFORM 1000-PROCESS-INPUT             THRU 1000-EXIT.       
           PERFORM 2000-PROCESS-OUTPUT            THRU 2000-EXIT.       
           PERFORM 9999-END-PROGRAM               THRU 9999-EXIT.       
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-R1.                                            
      *                                                                         
           MOVE 'SESSION.CSR04717_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04717_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04717_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS          THRU 8000A-EXIT       
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04717_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04717_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *     2. ASSIGNS PARMS TO WORKING STORAGE.                       *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO           
                                                BG-ACCOUNT-NO.          
           MOVE PARM-BILL-NO                 TO WS-BILL-NO              
                                                BG-BILL-NO.             
           MOVE PARM-CODE-UTIL-TYPE          TO WS-CODE-UTIL-TYPE       
                                                BG-CODE-UTIL-TYPE.      
           MOVE PARM-IC-NO                   TO WS-IC-NO                
                                                BG-IC-NO.               
           MOVE PARM-BILL-ITEM-TIMESTMP      TO WS-BILL-ITEM-TIMESTMP   
                                                BG-BILL-ITEM-TIMESTMP.  
           MOVE PARM-VOL-TYPE-CD             TO WS-VOL-TYPE-CD.         
           MOVE PARM-ENERGY-UNIT-CD          TO WS-ENERGY-UNIT-CD.      
           MOVE PARM-DATE-READ               TO WS-INPUT-DATE-READ.     
           MOVE PARM-UNITS                   TO WS-INPUT-UNITS.         
           MOVE PARM-ACTION-IND              TO WS-ACTION-IND.          
           MOVE PARM-USER-ID                 TO WS-USERID.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           EVALUATE PARM-ACTION-IND                                     
      *                                                                         
             WHEN WS-U                                                  
      *                                                                         
                MOVE WS-N                   TO WS-END-DATA              
                PERFORM 2300-UPDATE-DAILY-VOLS      THRU 2300-EXIT      
                    VARYING WS-SUB FROM 1 BY 1                          
                    UNTIL WS-SUB > 32 OR END-DATA                       
      *                                                                         
                PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT      
      *                                                                         
             WHEN WS-I                                                  
      *                                                                         
                PERFORM 2400-MOVE-DAILY-VOLS        THRU 2400-EXIT      
                PERFORM 7150-GET-VOL-DTLS           THRU 7150-EXIT      
                                                                        
                IF WS-VOL-TYPE-CD = WS-EG                               
                   PERFORM 7650-SELECT-RATE-DETAILS THRU 7650-EXIT      
                   PERFORM 7350-CHECK-SPL-FCTR      THRU 7350-EXIT      
      *                                                                         
                   IF FCTR-ID-MISSING                                   
                      MOVE 'BCNSMPT025'     TO S-RS1-BUS-RULE-ID        
                      MOVE WS-FAILED        TO S-RS1-BUS-RULE-RESULT-CD 
      *                                                                         
                      IF S-RS1-BUS-RULE-ID GREATER THAN SPACES          
                      PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT      
                      END-IF                                            
      *                                                                         
                   PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT      
                   PERFORM 9999-END-PROGRAM         THRU 9999-EXIT      
      *                                                                         
                   END-IF                                               
      *                                                                         
                END-IF                                                  
      *                                                                         
                IF WS-VOL-TYPE-CD = WS-NT                               
                   PERFORM 7800-GET-SHRINKAGE-PCT  THRU 7800-EXIT       
      *                                                                         
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      MOVE 'BCNSMPT024'     TO S-RS1-BUS-RULE-ID        
                      MOVE WS-FAILED        TO S-RS1-BUS-RULE-RESULT-CD 
      *                                                                         
                      IF S-RS1-BUS-RULE-ID GREATER THAN SPACES          
                      PERFORM 7550-GET-RULE-XREF-ID THRU 7550-EXIT      
                      END-IF                                            
      *                                                                         
                   PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT      
                   PERFORM 9999-END-PROGRAM         THRU 9999-EXIT      
                   END-IF                                               
      *                                                                         
                   PERFORM 7650-SELECT-RATE-DETAILS THRU 7650-EXIT      
      ******************************************************************        
      *   CHECKS IF NOMINATED TRNSP IS INSERTED FOR TRANSP BG          *        
      *   IF THERE IS NO TRANSP BG AVAILABLE, INSERT A ROW IN          *        
      *   BILLING DETAIL TABLE,INSERT THE DAILY VOL DETAILS FOR THE NEW*        
      *   TRANSP BG.                                                   *        
      ******************************************************************        
                   IF BG-CODE-REVENUE-CLASS NOT EQUAL                   
                                            TZ-CODE-REVENUE-CLASS       
      *                                                                         
                      PERFORM 7980-GET-TIMESTMP          THRU 7980-EXIT 
                      MOVE WS-TRSP-BG-TIMESTMP                          
                                            TO     BG-BILL-ITEM-TIMESTMP
                      PERFORM 7650-SELECT-RATE-DETAILS   THRU 7650-EXIT 
      *                                                                         
                      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                         MOVE TZ-CODE-REVENUE-CLASS                     
                                            TO     BG-CODE-REVENUE-CLASS
                         MOVE 'T'           TO BG-REV-RPT-CD            
                         PERFORM 7990-INSERT-TRSP-BG     THRU 7990-EXIT 
                         MOVE WS-TRSP-BG-TIMESTMP                       
                                            TO     ND-BILL-ITEM-TIMESTMP
                      ELSE                                              
      *                                                                         
                         MOVE 'BCNSMPT023'  TO S-RS1-BUS-RULE-ID        
                         MOVE WS-FAILED     TO S-RS1-BUS-RULE-RESULT-CD 
      *                                                                         
                         IF S-RS1-BUS-RULE-ID GREATER THAN SPACES       
                            PERFORM 7550-GET-RULE-XREF-ID               
                                                      THRU 7550-EXIT    
                         END-IF                                         
      *                                                                         
                         PERFORM 8010-INSERT-GTT-R1   THRU 8010-EXIT    
                         PERFORM 9999-END-PROGRAM     THRU 9999-EXIT    
                      END-IF                                            
                   END-IF                                               
                END-IF                                                  
      *                                                                         
                PERFORM 7500-INSERT-DAILYVOL-DTLS     THRU 7500-EXIT    
                PERFORM 2700-UPDATE-MNT-TRANS         THRU 2700-EXIT    
      *                                                                         
                IF WS-VOL-TYPE-CD = WS-NT                               
                   MOVE ND-NO-UNITS         TO WS-NO-UNITS-TEMP         
                   COMPUTE ND-NO-UNITS ROUNDED = (ND-NO-UNITS *         
                                      TW-TRNSP-SHRINK-PCT) / WS-100     
                   MOVE WS-ST               TO ND-VOL-TYPE-CD           
                   PERFORM 7150-GET-VOL-DTLS          THRU 7150-EXIT    
                   PERFORM 7500-INSERT-DAILYVOL-DTLS  THRU 7500-EXIT    
                   PERFORM 2700-UPDATE-MNT-TRANS      THRU 2700-EXIT    
                   SUBTRACT ND-NO-UNITS     FROM WS-NO-UNITS-TEMP       
                   MOVE WS-NO-UNITS-TEMP    TO ND-NO-UNITS              
                   IF ND-NO-UNITS > TW-TRNSP-MDQ                        
                      MOVE 'BCNSMPT019'     TO S-RS1-BUS-RULE-ID        
                      MOVE WS-INFO          TO S-RS1-BUS-RULE-RESULT-CD 
      *                                                                         
                      IF S-RS1-BUS-RULE-ID GREATER THAN SPACES          
                      PERFORM 7550-GET-RULE-XREF-ID   THRU 7550-EXIT    
                      END-IF                                            
      *                                                                         
                   END-IF                                               
                   MOVE WS-DT               TO ND-VOL-TYPE-CD           
                   PERFORM 7150-GET-VOL-DTLS          THRU 7150-EXIT    
                   PERFORM 7500-INSERT-DAILYVOL-DTLS  THRU 7500-EXIT    
                   PERFORM 2700-UPDATE-MNT-TRANS      THRU 2700-EXIT    
      *                                                                         
                END-IF                                                  
      *                                                                         
                PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT    
      *                                                                         
             WHEN WS-D                                                  
      *                                                                         
                   PERFORM 2400-MOVE-DAILY-VOLS        THRU 2400-EXIT   
                   PERFORM 7150-GET-VOL-DTLS           THRU 7150-EXIT   
                   PERFORM 7700-DELETE-DAILY-VOLS      THRU 7700-EXIT   
                   PERFORM 2700-UPDATE-MNT-TRANS       THRU 2700-EXIT   
      *                                                                         
                IF WS-VOL-TYPE-CD = WS-NT                               
                   MOVE WS-ST               TO ND-VOL-TYPE-CD           
                   PERFORM 7150-GET-VOL-DTLS           THRU 7150-EXIT   
                   PERFORM 7700-DELETE-DAILY-VOLS      THRU 7700-EXIT   
                   PERFORM 2700-UPDATE-MNT-TRANS       THRU 2700-EXIT   
                   MOVE WS-DT               TO ND-VOL-TYPE-CD           
                   PERFORM 7150-GET-VOL-DTLS           THRU 7150-EXIT   
                   PERFORM 7700-DELETE-DAILY-VOLS      THRU 7700-EXIT   
                   PERFORM 2700-UPDATE-MNT-TRANS       THRU 2700-EXIT   
                END-IF                                                  
      *                                                                         
                PERFORM  8010-INSERT-GTT-R1            THRU 8010-EXIT   
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-UPDATE-DAILY-VOLS                                         *        
      *                                                                *        
      ******************************************************************        
       2300-UPDATE-DAILY-VOLS.                                          
      *                                                                         
           MOVE WS-ACCOUNT-NO               TO ND-ACCOUNT-NO.           
           MOVE WS-BILL-NO                  TO ND-BILL-NO.              
           MOVE WS-CODE-UTIL-TYPE           TO ND-CODE-UTIL-TYPE.       
           MOVE WS-IC-NO                    TO ND-IC-NO.                
           MOVE WS-BILL-ITEM-TIMESTMP       TO ND-BILL-ITEM-TIMESTMP.   
           MOVE WS-VOL-TYPE-CD              TO ND-VOL-TYPE-CD.          
           MOVE WS-ENERGY-UNIT-CD           TO ND-ENERGY-UNIT-CD.       
      *                                                                         
           SET DATE-READ-OVERFL             TO TRUE.                    
      *                                                                         
           IF WS-INPUT-DATE-READ NOT = SPACES                           
              UNSTRING WS-INPUT-DATE-READ                               
              DELIMITED BY WS-DILIMITER                                 
              INTO WS-DATE-READ(WS-SUB) COUNT IN WS-CNTR                
              ON OVERFLOW                                               
                 PERFORM 2350-OVERFLOW            THRU 2350-EXIT        
           END-IF.                                                      
      *                                                                         
           MOVE WS-N                        TO WS-DATE-READ-OVERFL      
      *                                                                         
           IF WS-INPUT-UNITS NOT = SPACES                               
              UNSTRING WS-INPUT-UNITS                                   
              DELIMITED BY WS-DILIMITER                                 
              INTO WS-NO-UNITS(WS-SUB) COUNT IN WS-UNITS-CNTR           
              ON OVERFLOW                                               
                 PERFORM 2350-OVERFLOW            THRU 2350-EXIT        
           END-IF.                                                      
      *                                                                         
           MOVE WS-TEMP-DATE-READ           TO WS-INPUT-DATE-READ.      
           MOVE WS-TEMP-UNITS               TO WS-INPUT-UNITS.          
      *                                                                         
           IF WS-INPUT-DATE-READ = SPACES AND WS-INPUT-UNITS = SPACES   
              SET END-DATA                  TO TRUE                     
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                      TO WS-TEMP-DATE-READ.       
           MOVE SPACES                      TO WS-TEMP-UNITS.           
           MOVE WS-DATE-READ(WS-SUB)        TO WS-DATE-FRMT.            
           MOVE WS-FRMT-MM                  TO WS-TEMP-MM.              
           MOVE WS-FRMT-DD                  TO WS-TEMP-DD.              
           MOVE WS-FRMT-CCYY                TO WS-TEMP-CCYY.            
           MOVE WS-DATE-TEMP                TO ND-DATE-READ.            
           MOVE ZEROS                       TO WS-INSPECT-CNTR.         
      *                                                                         
           INSPECT WS-NO-UNITS(WS-SUB)                                  
           TALLYING WS-INSPECT-CNTR                                     
           FOR ALL '-'.                                                 
      *                                                                         
           INSPECT WS-NO-UNITS(WS-SUB)                                  
           REPLACING ALL '-' BY ZEROS.                                  
      *                                                                         
           IF WS-INSPECT-CNTR > 0                                       
              SET NEGATIVE-UNITS            TO TRUE                     
           END-IF.                                                      
      *                                                                         
           INSPECT WS-NO-UNITS(WS-SUB) REPLACING LEADING SPACES         
                   BY ZEROS.                                            
           MOVE WS-NO-UNITS(WS-SUB)         TO WS-NO-UNITS-BRK.         
           MOVE WS-NO-UNITS-INT             TO WS-NO-UNITS-INT-N.       
           MOVE WS-NO-UNITS-DEC             TO WS-NO-UNITS-DEC-N.       
           MOVE WS-NO-UNITS-NUM-RED         TO ND-NO-UNITS.             
      *                                                                         
           IF NEGATIVE-UNITS                                            
              COMPUTE ND-NO-UNITS = ND-NO-UNITS * -1                    
              MOVE WS-N                     TO WS-NEGATIVE-UNITS        
           END-IF.                                                      
      *                                                                         
           PERFORM 7150-GET-VOL-DTLS              THRU 7150-EXIT.       
           PERFORM 7400-UPDATE-DAILYVOL-DTLS      THRU 7400-EXIT.       
           PERFORM 2700-UPDATE-MNT-TRANS          THRU 2700-EXIT.       
           SET MULTI-UPDT                    TO TRUE.                   
      *                                                                         
           IF ND-VOL-TYPE-CD = WS-NT                                    
              PERFORM 7800-GET-SHRINKAGE-PCT      THRU 7800-EXIT        
              MOVE ND-NO-UNITS               TO WS-NO-UNITS-TEMP        
              COMPUTE ND-NO-UNITS ROUNDED =                             
                            (ND-NO-UNITS * TW-TRNSP-SHRINK-PCT) / WS-100
      *                                                                         
              IF ND-NO-UNITS > TW-TRNSP-MDQ                             
                 MOVE 'BCNSMPT019'           TO S-RS1-BUS-RULE-ID       
                 MOVE WS-INFO                TO S-RS1-BUS-RULE-RESULT-CD
      *                                                                         
                 IF S-RS1-BUS-RULE-ID GREATER THAN SPACES               
                 PERFORM 7550-GET-RULE-XREF-ID    THRU 7550-EXIT        
                 END-IF                                                 
      *                                                                         
              END-IF                                                    
              MOVE WS-ST                    TO ND-VOL-TYPE-CD           
      *                                                                         
              PERFORM 7150-GET-VOL-DTLS           THRU 7150-EXIT        
              PERFORM 7400-UPDATE-DAILYVOL-DTLS   THRU 7400-EXIT        
              PERFORM 2700-UPDATE-MNT-TRANS       THRU 2700-EXIT        
              SUBTRACT ND-NO-UNITS          FROM WS-NO-UNITS-TEMP       
              MOVE WS-NO-UNITS-TEMP         TO ND-NO-UNITS              
              MOVE WS-DT                    TO ND-VOL-TYPE-CD           
              PERFORM 7150-GET-VOL-DTLS           THRU 7150-EXIT        
              PERFORM 7400-UPDATE-DAILYVOL-DTLS   THRU 7400-EXIT        
              PERFORM 2700-UPDATE-MNT-TRANS       THRU 2700-EXIT        
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2350-OVERFLOW.                                                 *        
      *    -- THIS MODULE IS PERFOMED WHEN THERE IS AN OVERFLOW IN     *        
      *       THE UNSTRING STAT.                                       *        
      ******************************************************************        
       2350-OVERFLOW.                                                   
      *                                                                         
           IF DATE-READ-OVERFL                                          
              MOVE ZEROS                    TO WS-CNTR1                 
              ADD WS-CNTR                   TO WS-CNTR1                 
              ADD WS-1                      TO WS-CNTR1                 
              SUBTRACT WS-CNTR1             FROM WS-CNTR2               
              ADD WS-1                      TO WS-CNTR1                 
              MOVE WS-INPUT-DATE-READ(WS-CNTR1 : WS-CNTR2)              
                                            TO WS-TEMP-DATE-READ        
              SUBTRACT WS-1                 FROM WS-CNTR1               
           ELSE                                                         
              MOVE ZEROS                    TO WS-UNITS-CNTR1           
              ADD WS-UNITS-CNTR             TO WS-UNITS-CNTR1           
              ADD WS-1                      TO WS-UNITS-CNTR1           
              SUBTRACT WS-UNITS-CNTR1       FROM WS-UNITS-CNTR2         
              ADD WS-1                      TO WS-UNITS-CNTR1           
              MOVE WS-INPUT-UNITS(WS-UNITS-CNTR1 : WS-UNITS-CNTR2)      
                                            TO WS-TEMP-UNITS            
              SUBTRACT WS-1                 FROM WS-UNITS-CNTR1         
           END-IF.                                                      
      *                                                                         
           MOVE WS-250                      TO WS-CNTR2.                
           MOVE WS-250                      TO WS-UNITS-CNTR2.          
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-MOVE-DAILY-VOLS.                                          *        
      *    -- THIS MODULE SETS UP THE VALUES FOR INSERTING/ DELETING   *        
      *       DAILY VOLUME DETAILS IN THE CSS_VOL_DAILY TABLE.         *        
      ******************************************************************        
       2400-MOVE-DAILY-VOLS.                                            
           UNSTRING WS-INPUT-DATE-READ                                  
           DELIMITED BY WS-DILIMITER                                    
           INTO WS-DATE-RD.                                             
           UNSTRING WS-INPUT-UNITS                                      
           DELIMITED BY WS-DILIMITER                                    
           INTO WS-VOL-NO-UNITS.                                        
           MOVE WS-DATE-RD                  TO WS-DATE-FRMT.            
           MOVE WS-FRMT-MM                  TO WS-TEMP-MM.              
           MOVE WS-FRMT-DD                  TO WS-TEMP-DD.              
           MOVE WS-FRMT-CCYY                TO WS-TEMP-CCYY.            
           MOVE WS-DATE-TEMP                TO ND-DATE-READ.            
           MOVE ZEROS                       TO WS-INSPECT-CNTR.         
           INSPECT WS-VOL-NO-UNITS                                      
           TALLYING WS-INSPECT-CNTR                                     
           FOR ALL '-'.                                                 
           INSPECT WS-VOL-NO-UNITS                                      
           REPLACING ALL '-' BY ZEROS.                                  
           IF WS-INSPECT-CNTR > 0                                       
              SET NEGATIVE-UNITS            TO TRUE                     
           END-IF.                                                      
           INSPECT WS-VOL-NO-UNITS REPLACING LEADING SPACES             
                   BY ZEROS.                                            
           MOVE WS-VOL-NO-UNITS             TO WS-NO-UNITS-BRK.         
           MOVE WS-NO-UNITS-INT             TO WS-NO-UNITS-INT-N.       
           MOVE WS-NO-UNITS-DEC             TO WS-NO-UNITS-DEC-N.       
           MOVE WS-NO-UNITS-NUM-RED         TO ND-NO-UNITS.             
           IF NEGATIVE-UNITS                                            
              COMPUTE ND-NO-UNITS = ND-NO-UNITS * -1                    
              MOVE WS-N                     TO WS-NEGATIVE-UNITS        
           END-IF.                                                      
           MOVE WS-ACCOUNT-NO               TO ND-ACCOUNT-NO.           
           MOVE WS-BILL-NO                  TO ND-BILL-NO.              
           MOVE WS-CODE-UTIL-TYPE           TO ND-CODE-UTIL-TYPE.       
           MOVE WS-IC-NO                    TO ND-IC-NO.                
           MOVE WS-BILL-ITEM-TIMESTMP       TO ND-BILL-ITEM-TIMESTMP.   
           MOVE WS-VOL-TYPE-CD              TO ND-VOL-TYPE-CD.          
           MOVE WS-ENERGY-UNIT-CD           TO ND-ENERGY-UNIT-CD.       
           MOVE ZEROS                       TO ND-FIXED-FCTR-SEQ-NO.    
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700 SET MNT TRANS VARS                                        *        
      *      -- THIS MODULE SETS UP THE VALUES TO UPDATE THE MNT TRANS *        
      *         TABLES.                                                *        
      ******************************************************************        
       2700-UPDATE-MNT-TRANS.                                           
      *                                                                         
           IF ND-VOL-TYPE-CD = WS-ST OR WS-DT                           
              CONTINUE                                                  
           ELSE                                                         
              IF MULTI-UPDT                                             
                 ADD  +1                    TO  WS-TRAN-APPL-NO         
              ELSE                                                      
                 PERFORM 7960-GET-TIMESTMP        THRU 7960-EXIT        
                 PERFORM 7970-GET-RESP-AREA-ID    THRU 7970-EXIT        
                 MOVE  +1                   TO  WS-TRAN-APPL-NO         
              END-IF                                                    
              MOVE 'DATE READ'              TO  WS-COLUMN-DESC          
              IF WS-ACTION-IND = WS-I THEN                              
                 MOVE '*NEW*'               TO  WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                     TO  WS-PRV-COLUMN-VALUE-LEN 
              ELSE                                                      
                 MOVE ND-DATE-READ          TO  WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 10                    TO  WS-PRV-COLUMN-VALUE-LEN 
              END-IF                                                    
              IF WS-ACTION-IND = WS-D THEN                              
                 MOVE '*DELETED*'           TO  WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                     TO  WS-CHG-COLUMN-VALUE-LEN 
              ELSE                                                      
                 MOVE ND-DATE-READ          TO  WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 10                    TO  WS-CHG-COLUMN-VALUE-LEN 
              END-IF                                                    
              PERFORM 2750-SET-MNT-TRANS-VARS     THRU 2750-EXIT        
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
           END-IF.                                                      
      *                                                                         
           IF MULTI-UPDT                                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE ND-CODE-UTIL-TYPE        TO X8-CODE-UTIL-TYPE        
              MOVE ND-VOL-TYPE-CD           TO X8-VOL-TYPE-CD           
              MOVE ND-ENERGY-UNIT-CD        TO X8-ENERGY-UNIT-CD        
              PERFORM 7300-GET-VOLTYP-DESC        THRU 7300-EXIT        
              ADD   +1                      TO WS-TRAN-APPL-NO          
              MOVE 'VOL TYPE CD'            TO WS-COLUMN-DESC           
              IF WS-ACTION-IND = WS-I THEN                              
                 MOVE '*NEW*'               TO  WS-PRV-COLUMN-VALUE-TEXT
                 MOVE 5                     TO  WS-PRV-COLUMN-VALUE-LEN 
              ELSE                                                      
                 MOVE X8-VOL-TYPE-DESC      TO WS-PRV-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF X8-VOL-TYPE-DESC                        
                                            TO  WS-PRV-COLUMN-VALUE-LEN 
              END-IF                                                    
              IF WS-ACTION-IND = WS-D THEN                              
                 MOVE '*DELETED*'           TO  WS-CHG-COLUMN-VALUE-TEXT
                 MOVE 9                     TO  WS-CHG-COLUMN-VALUE-LEN 
              ELSE                                                      
                 MOVE X8-VOL-TYPE-DESC      TO WS-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF X8-VOL-TYPE-DESC                        
                                            TO WS-CHG-COLUMN-VALUE-LEN  
              END-IF                                                    
              PERFORM 2750-SET-MNT-TRANS-VARS     THRU 2750-EXIT        
              PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT        
           END-IF.                                                      
      *                                                                         
           ADD   +1                         TO  WS-TRAN-APPL-NO.        
           MOVE 'UNITS'                     TO  WS-COLUMN-DESC.         
           IF WS-ACTION-IND = WS-I THEN                                 
              MOVE '*NEW*'                  TO  WS-PRV-COLUMN-VALUE-TEXT
              MOVE 5                        TO  WS-PRV-COLUMN-VALUE-LEN 
           ELSE                                                         
              MOVE WS-PREV-NO-UNITS         TO  WS-COMP-2-CHAR-CONV     
              MOVE WS-COMP-2-CHAR-CONV      TO                          
                                            WS-PRV-COLUMN-VALUE-TEXT    
              MOVE +15                      TO  WS-PRV-COLUMN-VALUE-LEN 
           END-IF                                                       
           IF WS-ACTION-IND = WS-D THEN                                 
              MOVE '*DELETED*'              TO  WS-CHG-COLUMN-VALUE-TEXT
              MOVE 9                        TO  WS-CHG-COLUMN-VALUE-LEN 
           ELSE                                                         
              MOVE ND-NO-UNITS              TO  WS-COMP-2-CHAR-CONV     
              MOVE WS-COMP-2-CHAR-CONV      TO                          
                                         WS-CHG-COLUMN-VALUE-TEXT       
              MOVE +15                      TO  WS-CHG-COLUMN-VALUE-LEN 
           END-IF                                                       
           PERFORM 2750-SET-MNT-TRANS-VARS        THRU 2750-EXIT.       
           PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT.       
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2750-SET-MNT-TRANS-VARS                                        *        
      *                                                                *        
      ******************************************************************        
       2750-SET-MNT-TRANS-VARS.                                         
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
           MOVE WS-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE PARM-USER-ID                TO MH-USER-ID.              
           MOVE WS-PGRMNAME                 TO MH-APPL-PROGRAM-ID.      
           MOVE PARM-COMMENT-TEXT           TO MH-TRAN-COMMENT-TEXT.    
           MOVE PARM-COMMENT-LEN            TO MH-TRAN-COMMENT-LEN.     
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE 'ND'                        TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO                          
                                            MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO                          
                                            MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-GET-VOL-DTLS.                                             *        
      *                                                                *        
      ******************************************************************        
       7150-GET-VOL-DTLS.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT  NO_UNITS                                         
                 INTO :WS-PREV-NO-UNITS                                 
                FROM   CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                   
                   WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO            
                     AND BILL_NO            = :ND-BILL-NO               
                     AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )    
                     AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD           
                     AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD        
                     AND DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  NO_UNITS                                                 
MFA-TR*          INTO :WS-PREV-NO-UNITS                                         
MFA-TR*         FROM   CSS_VOL_DAILY ND                                         
MFA-TR*            WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO                    
MFA-TR*              AND BILL_NO            = :ND-BILL-NO                       
MFA-TR*              AND BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP            
MFA-TR*              AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD                   
MFA-TR*              AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD                
MFA-TR*              AND DATE_READ          = :ND-DATE-READ                     
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7150'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_VOL_DAILY'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'VOL_TYPE_CD'           TO TABLE-ELEMENT-3          
               MOVE 'DATE_READ'             TO TABLE-ELEMENT-4          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE WS-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE ND-VOL-TYPE-CD          TO HOSTVAR-ELEMENT-3        
               MOVE ND-DATE-READ            TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-VOLTYP-DESC                                           *        
      *                                                                *        
      ******************************************************************        
       7300-GET-VOLTYP-DESC.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT VOL_TYPE_DESC                                     
                 INTO :X8-VOL-TYPE-DESC                                 
                 FROM CSS_VOL_TYPE X8 WITH(READUNCOMMITTED)                     
                WHERE COMPANY_NO      = '01'                            
                  AND CODE_UTIL_TYPE  = :X8-CODE-UTIL-TYPE              
                  AND VOL_TYPE_CD     = :X8-VOL-TYPE-CD                 
                  AND ENERGY_UNIT_CD  = :X8-ENERGY-UNIT-CD              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VOL_TYPE_DESC                                             
MFA-TR*          INTO :X8-VOL-TYPE-DESC                                         
MFA-TR*          FROM CSS_VOL_TYPE X8                                           
MFA-TR*         WHERE COMPANY_NO      = '01'                                    
MFA-TR*           AND CODE_UTIL_TYPE  = :X8-CODE-UTIL-TYPE                      
MFA-TR*           AND VOL_TYPE_CD     = :X8-VOL-TYPE-CD                         
MFA-TR*           AND ENERGY_UNIT_CD  = :X8-ENERGY-UNIT-CD                      
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_VOL_TYPE'          TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE 'VOL_TYPE_CD'           TO TABLE-ELEMENT-3          
               MOVE 'ENERGY_UNIT_CD'        TO TABLE-ELEMENT-4          
               MOVE X8-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               MOVE X8-VOL-TYPE-CD          TO HOSTVAR-ELEMENT-3        
               MOVE X8-ENERGY-UNIT-CD       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 7350-CHECK-SPL-FCTR                                            *        
      *       -- THIS MODULE VALIDS THE FACTOR ID FOR EMERGENCY VOL TYP*        
      ******************************************************************        
       7350-CHECK-SPL-FCTR.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-FCTR-ID-EXISTS                                
                 FROM CSS_SPCL_FCTR_APPL WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE              
                  AND RATE_PLAN_NO    = :BG-RATE-PLAN-NO                
                  AND FACTOR_ID       = :WS-TRANSCO                     
                  AND DATE_FROM      <= IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                   
                  AND DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-FCTR-ID-EXISTS                                        
MFA-TR*          FROM CSS_SPCL_FCTR_APPL                                        
MFA-TR*         WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                      
MFA-TR*           AND RATE_PLAN_NO    = :BG-RATE-PLAN-NO                        
MFA-TR*           AND FACTOR_ID       = :WS-TRANSCO                             
MFA-TR*           AND DATE_FROM      <= :ND-DATE-READ                           
MFA-TR*           AND DATE_TO        >= :ND-DATE-READ                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
              -811                                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7350'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-3          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-4          
               MOVE WS-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE BG-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-2        
               MOVE ND-DATE-READ            TO HOSTVAR-ELEMENT-3        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT     
               PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-UPDATE-DAILYVOL-DTLS.                                    **        
      *                                                               **        
      ******************************************************************        
       7400-UPDATE-DAILYVOL-DTLS.                                       
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_VOL_DAILY                                    
                   SET NO_UNITS           = :ND-NO-UNITS                
                 WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO              
                   AND BILL_NO            = :ND-BILL-NO                 
                   AND IC_NO              = :ND-IC-NO                   
                   AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE          
                   AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )      
                   AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD             
                   AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD          
                   AND DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_VOL_DAILY                                            
MFA-TR*            SET NO_UNITS           = :ND-NO-UNITS                        
MFA-TR*          WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :ND-BILL-NO                         
MFA-TR*            AND IC_NO              = :ND-IC-NO                           
MFA-TR*            AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE                  
MFA-TR*            AND BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP              
MFA-TR*            AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD                     
MFA-TR*            AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD                  
MFA-TR*            AND DATE_READ          = :ND-DATE-READ                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_VOL_DAILY'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'VOL_TYPE_CD'           TO TABLE-ELEMENT-3          
               MOVE 'DATE_READ'             TO TABLE-ELEMENT-4          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE WS-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE ND-VOL-TYPE-CD          TO HOSTVAR-ELEMENT-3        
               MOVE ND-DATE-READ            TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-INSERT-DAILYVOL-DTLS                                      *        
      *      -- THIS MODULE INSERTS DAILY VOLUME DETAILS.              *        
      ******************************************************************        
       7500-INSERT-DAILYVOL-DTLS.                                       
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_VOL_DAILY                               
                            ( ACCOUNT_NO                                
                             ,BILL_NO                                   
                             ,CODE_UTIL_TYPE                            
                             ,IC_NO                                     
                             ,BILL_ITEM_TIMESTMP                        
                             ,VOL_TYPE_CD                               
                             ,ENERGY_UNIT_CD                            
                             ,DATE_READ                                 
                             ,NO_UNITS                                  
                             ,FIXED_FCTR_SEQ_NO)                        
                     VALUES ( :ND-ACCOUNT-NO                            
                             ,:ND-BILL-NO                               
                             ,:ND-CODE-UTIL-TYPE                        
                             ,:ND-IC-NO                                 
                             ,CIS.CHAR2TIMESTAMP(:ND-BILL-ITEM-TIMESTMP)        
                             ,:ND-VOL-TYPE-CD                           
                             ,:ND-ENERGY-UNIT-CD                        
                             ,IIF(TRY_CONVERT(DATE, :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                             
                             ,:ND-NO-UNITS                              
                             ,:ND-FIXED-FCTR-SEQ-NO)                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_VOL_DAILY                                       
MFA-TR*                     ( ACCOUNT_NO                                        
MFA-TR*                      ,BILL_NO                                           
MFA-TR*                      ,CODE_UTIL_TYPE                                    
MFA-TR*                      ,IC_NO                                             
MFA-TR*                      ,BILL_ITEM_TIMESTMP                                
MFA-TR*                      ,VOL_TYPE_CD                                       
MFA-TR*                      ,ENERGY_UNIT_CD                                    
MFA-TR*                      ,DATE_READ                                         
MFA-TR*                      ,NO_UNITS                                          
MFA-TR*                      ,FIXED_FCTR_SEQ_NO)                                
MFA-TR*              VALUES ( :ND-ACCOUNT-NO                                    
MFA-TR*                      ,:ND-BILL-NO                                       
MFA-TR*                      ,:ND-CODE-UTIL-TYPE                                
MFA-TR*                      ,:ND-IC-NO                                         
MFA-TR*                      ,:ND-BILL-ITEM-TIMESTMP                            
MFA-TR*                      ,:ND-VOL-TYPE-CD                                   
MFA-TR*                      ,:ND-ENERGY-UNIT-CD                                
MFA-TR*                      ,:ND-DATE-READ                                     
MFA-TR*                      ,:ND-NO-UNITS                                      
MFA-TR*                      ,:ND-FIXED-FCTR-SEQ-NO)                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_VOL_DAILY'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE PARM-BILL-NO            TO HOSTVAR-ELEMENT-2        
               MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-3          
               MOVE PARM-BILL-ITEM-TIMESTMP TO HOSTVAR-ELEMENT-3        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-4          
               MOVE PARM-IC-NO              TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 7650-SELECT-RATE-DETAILS                                       *        
      *       -- THIS MODULE SELECTS BG DETAILS.                       *        
      ******************************************************************        
       7650-SELECT-RATE-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                     ,BILL_NO                                           
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
                     ,DATE_ORIG_BILL                                    
                     ,AMT_BILL_ITEM                                     
                     ,CODE_BILL_CALC                                    
                     ,CODE_BILL_ITM_TYPE                                
                     ,CODE_BILL_ITM_IND                                 
                     ,CODE_DR_CR_CNSMPTN                                
                     ,AMT_STATE_TAX                                     
                     ,AMT_CITY_TAX                                      
                     ,AMT_OTHER_TAX                                     
                     ,CODE_REVENUE_CLASS                                
                     ,CODE_SIC_NO                                       
                     ,RATE_PLAN_NO                                      
                     ,CODE_CURTAIL_PRTY                                 
                     ,CODE_STAT_TAX_XMT                                 
                     ,CODE_CITY_TAX_XMT                                 
                     ,CODE_OTHR_TAX_XMT                                 
                     ,REV_RPT_CD                                        
                     ,STANDBY_COMPLIED                                  
                     ,PRORATE_CD                                        
                     ,NEW_RATE_PCT                                      
                     ,CODE_SUB_TOTAL                                    
                     ,TAX_REFUND_CD                                     
                     ,ACCOUNT_NO                                        
                     ,COMPANY_NO                                        
                     ,DATE_LFTM_HI_DMD                                  
                     ,LFTM_HI_PEAK_DMD                                  
                     ,REBILL_IND                                        
                     ,ADJ_REASON_CD                                     
                     ,REVENUE_MONTH                                     
                     ,GAS_BASE_USE                                      
                     ,WNA_FACTOR                                        
                     ,BTU_FACTOR                                        
                     ,NO_OF_CONS_DAYS                                   
                     ,REV_MTH_ORIG_BILL                                 
                     ,REV_DISTRICT_CD                                   
                     ,FUEL_SHIPPER_CD                                   
                     ,ALTERNATE_FUEL_CD                                 
                     ,TRNSP_OVER_MDQ_FL                                 
                 INTO :BG-PREMISE-NO                                    
                     ,:BG-BILL-NO                                       
                     ,:BG-CODE-UTIL-TYPE                                
                     ,:BG-IC-NO                                         
                     ,:BG-BILL-ITEM-TIMESTMP                            
                     ,:BG-DATE-ORIG-BILL :WS-NULL-IND1                  
                     ,:BG-AMT-BILL-ITEM                                 
                     ,:BG-CODE-BILL-CALC                                
                     ,:BG-CODE-BILL-ITM-TYPE                            
                     ,:BG-CODE-BILL-ITM-IND                             
                     ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-AMT-STATE-TAX                                 
                     ,:BG-AMT-CITY-TAX                                  
                     ,:BG-AMT-OTHER-TAX                                 
                     ,:BG-CODE-REVENUE-CLASS                            
                     ,:BG-CODE-SIC-NO                                   
                     ,:BG-RATE-PLAN-NO                                  
                     ,:BG-CODE-CURTAIL-PRTY                             
                     ,:BG-CODE-STAT-TAX-XMT                             
                     ,:BG-CODE-CITY-TAX-XMT                             
                     ,:BG-CODE-OTHR-TAX-XMT                             
                     ,:BG-REV-RPT-CD                                    
                     ,:BG-STANDBY-COMPLIED                              
                     ,:BG-PRORATE-CD                                    
                     ,:BG-NEW-RATE-PCT                                  
                     ,:BG-CODE-SUB-TOTAL                                
                     ,:BG-TAX-REFUND-CD                                 
                     ,:BG-ACCOUNT-NO                                    
                     ,:BG-COMPANY-NO                                    
                     ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND2                
                     ,:BG-LFTM-HI-PEAK-DMD                              
                     ,:BG-REBILL-IND                                    
                     ,:BG-ADJ-REASON-CD                                 
                     ,:BG-REVENUE-MONTH                                 
                     ,:BG-GAS-BASE-USE                                  
                     ,:BG-WNA-FACTOR                                    
                     ,:BG-BTU-FACTOR                                    
                     ,:BG-NO-OF-CONS-DAYS                               
                     ,:BG-REV-MTH-ORIG-BILL                             
                     ,:BG-REV-DISTRICT-CD                               
                     ,:BG-FUEL-SHIPPER-CD                               
                     ,:BG-ALTERNATE-FUEL-CD                             
                     ,:BG-TRNSP-OVER-MDQ-FL                             
                 FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                      
                  AND BILL_NO     = :BG-BILL-NO                         
                  AND IC_NO       = :BG-IC-NO                           
                  AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE               
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,DATE_ORIG_BILL                                            
MFA-TR*              ,AMT_BILL_ITEM                                             
MFA-TR*              ,CODE_BILL_CALC                                            
MFA-TR*              ,CODE_BILL_ITM_TYPE                                        
MFA-TR*              ,CODE_BILL_ITM_IND                                         
MFA-TR*              ,CODE_DR_CR_CNSMPTN                                        
MFA-TR*              ,AMT_STATE_TAX                                             
MFA-TR*              ,AMT_CITY_TAX                                              
MFA-TR*              ,AMT_OTHER_TAX                                             
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,CODE_SIC_NO                                               
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,CODE_CURTAIL_PRTY                                         
MFA-TR*              ,CODE_STAT_TAX_XMT                                         
MFA-TR*              ,CODE_CITY_TAX_XMT                                         
MFA-TR*              ,CODE_OTHR_TAX_XMT                                         
MFA-TR*              ,REV_RPT_CD                                                
MFA-TR*              ,STANDBY_COMPLIED                                          
MFA-TR*              ,PRORATE_CD                                                
MFA-TR*              ,NEW_RATE_PCT                                              
MFA-TR*              ,CODE_SUB_TOTAL                                            
MFA-TR*              ,TAX_REFUND_CD                                             
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,DATE_LFTM_HI_DMD                                          
MFA-TR*              ,LFTM_HI_PEAK_DMD                                          
MFA-TR*              ,REBILL_IND                                                
MFA-TR*              ,ADJ_REASON_CD                                             
MFA-TR*              ,REVENUE_MONTH                                             
MFA-TR*              ,GAS_BASE_USE                                              
MFA-TR*              ,WNA_FACTOR                                                
MFA-TR*              ,BTU_FACTOR                                                
MFA-TR*              ,NO_OF_CONS_DAYS                                           
MFA-TR*              ,REV_MTH_ORIG_BILL                                         
MFA-TR*              ,REV_DISTRICT_CD                                           
MFA-TR*              ,FUEL_SHIPPER_CD                                           
MFA-TR*              ,ALTERNATE_FUEL_CD                                         
MFA-TR*              ,TRNSP_OVER_MDQ_FL                                         
MFA-TR*          INTO :BG-PREMISE-NO                                            
MFA-TR*              ,:BG-BILL-NO                                               
MFA-TR*              ,:BG-CODE-UTIL-TYPE                                        
MFA-TR*              ,:BG-IC-NO                                                 
MFA-TR*              ,:BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:BG-DATE-ORIG-BILL :WS-NULL-IND1                          
MFA-TR*              ,:BG-AMT-BILL-ITEM                                         
MFA-TR*              ,:BG-CODE-BILL-CALC                                        
MFA-TR*              ,:BG-CODE-BILL-ITM-TYPE                                    
MFA-TR*              ,:BG-CODE-BILL-ITM-IND                                     
MFA-TR*              ,:BG-CODE-DR-CR-CNSMPTN                                    
MFA-TR*              ,:BG-AMT-STATE-TAX                                         
MFA-TR*              ,:BG-AMT-CITY-TAX                                          
MFA-TR*              ,:BG-AMT-OTHER-TAX                                         
MFA-TR*              ,:BG-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:BG-CODE-SIC-NO                                           
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*              ,:BG-CODE-CURTAIL-PRTY                                     
MFA-TR*              ,:BG-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-OTHR-TAX-XMT                                     
MFA-TR*              ,:BG-REV-RPT-CD                                            
MFA-TR*              ,:BG-STANDBY-COMPLIED                                      
MFA-TR*              ,:BG-PRORATE-CD                                            
MFA-TR*              ,:BG-NEW-RATE-PCT                                          
MFA-TR*              ,:BG-CODE-SUB-TOTAL                                        
MFA-TR*              ,:BG-TAX-REFUND-CD                                         
MFA-TR*              ,:BG-ACCOUNT-NO                                            
MFA-TR*              ,:BG-COMPANY-NO                                            
MFA-TR*              ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND2                        
MFA-TR*              ,:BG-LFTM-HI-PEAK-DMD                                      
MFA-TR*              ,:BG-REBILL-IND                                            
MFA-TR*              ,:BG-ADJ-REASON-CD                                         
MFA-TR*              ,:BG-REVENUE-MONTH                                         
MFA-TR*              ,:BG-GAS-BASE-USE                                          
MFA-TR*              ,:BG-WNA-FACTOR                                            
MFA-TR*              ,:BG-BTU-FACTOR                                            
MFA-TR*              ,:BG-NO-OF-CONS-DAYS                                       
MFA-TR*              ,:BG-REV-MTH-ORIG-BILL                                     
MFA-TR*              ,:BG-REV-DISTRICT-CD                                       
MFA-TR*              ,:BG-FUEL-SHIPPER-CD                                       
MFA-TR*              ,:BG-ALTERNATE-FUEL-CD                                     
MFA-TR*              ,:BG-TRNSP-OVER-MDQ-FL                                     
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*         WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                              
MFA-TR*           AND BILL_NO     = :BG-BILL-NO                                 
MFA-TR*           AND IC_NO       = :BG-IC-NO                                   
MFA-TR*           AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                       
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND1 = -1                                      
                 MOVE SPACES                TO BG-DATE-ORIG-BILL        
              END-IF                                                    
              IF WS-NULL-IND2 = -1                                      
                 MOVE SPACES                TO BG-DATE-LFTM-HI-DMD      
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7650'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE BG-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT     
               PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS1-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS1-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS1-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-DELETE-DAILY-VOLS.                                        *        
      *      -- THIS MODULE DELETES DAILY VOLUME DETAILS.              *        
      ******************************************************************        
       7700-DELETE-DAILY-VOLS.                                          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_VOL_DAILY                               
                 WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO              
                   AND BILL_NO            = :ND-BILL-NO                 
                   AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )      
                   AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD             
                   AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD          
                   AND DATE_READ          = IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_VOL_DAILY                                       
MFA-TR*          WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :ND-BILL-NO                         
MFA-TR*            AND BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP              
MFA-TR*            AND VOL_TYPE_CD        = :ND-VOL-TYPE-CD                     
MFA-TR*            AND ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD                  
MFA-TR*            AND DATE_READ          = :ND-DATE-READ                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7700'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_VOL_DAILY'      TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
               MOVE 'BILL_NO'            TO TABLE-ELEMENT-2             
               MOVE PARM-BILL-NO         TO HOSTVAR-ELEMENT-2           
               MOVE 'BILL_ITEM_TIMESTMP' TO TABLE-ELEMENT-3             
               MOVE PARM-BILL-ITEM-TIMESTMP                             
                                         TO HOSTVAR-ELEMENT-3           
               MOVE 'IC_NO'              TO TABLE-ELEMENT-4             
               MOVE PARM-IC-NO           TO HOSTVAR-ELEMENT-4           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7800-GET-SHRINKAGE-PCT.                                        *        
      *                                                                *        
      ******************************************************************        
       7800-GET-SHRINKAGE-PCT.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT TW.TRNSP_SHRINK_PCT                               
                     ,TW.TRNSP_MDQ                                      
                     ,TZ.CODE_REVENUE_CLASS                             
                 INTO :TW-TRNSP-SHRINK-PCT                              
                     ,:TW-TRNSP-MDQ                                     
                     ,:TZ-CODE-REVENUE-CLASS                            
                 FROM CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED),              
                         CSS_TRNSP_VOL_BLK TZ WITH(READUNCOMMITTED)             
                   WHERE TW.ACCOUNT_NO       = :ND-ACCOUNT-NO           
                     AND TW.ACCOUNT_NO       = TZ.ACCOUNT_NO            
                     AND TW.CODE_UTIL_TYPE   = :ND-CODE-UTIL-TYPE       
                     AND TW.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE        
                     AND TW.PRIMARY_IC_NO    = TZ.PRIMARY_IC_NO         
                     AND TW.PRIMARY_IC_NO    = TZ.IC_NO                 
                     AND TZ.IC_NO            = :ND-IC-NO                
                     AND TW.CNTRCT_START_DT  = TZ.CNTRCT_START_DT       
                     AND TZ.CNTRCT_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )         
                     AND TZ.CNTRCT_START_DT =                           
                         (SELECT MAX(T1.CNTRCT_START_DT)                
                            FROM CSS_TRNSP_VOL_BLK T1
                           WITH(READUNCOMMITTED)                   
                           WHERE T1.ACCOUNT_NO       = TZ.ACCOUNT_NO    
                             AND T1.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE
                             AND TW.PRIMARY_IC_NO    = T1.PRIMARY_IC_NO 
                             AND T1.IC_NO    = :ND-IC-NO                
                             AND T1.CNTRCT_START_DT <= 
              IIF(TRY_CONVERT(DATE, :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) ))   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TW.TRNSP_SHRINK_PCT                                       
MFA-TR*              ,TW.TRNSP_MDQ                                              
MFA-TR*              ,TZ.CODE_REVENUE_CLASS                                     
MFA-TR*          INTO :TW-TRNSP-SHRINK-PCT                                      
MFA-TR*              ,:TW-TRNSP-MDQ                                             
MFA-TR*              ,:TZ-CODE-REVENUE-CLASS                                    
MFA-TR*          FROM CSS_TRNSP_CONTRACT TW,                                    
MFA-TR*                  CSS_TRNSP_VOL_BLK TZ                                   
MFA-TR*            WHERE TW.ACCOUNT_NO       = :ND-ACCOUNT-NO                   
MFA-TR*              AND TW.ACCOUNT_NO       = TZ.ACCOUNT_NO                    
MFA-TR*              AND TW.CODE_UTIL_TYPE   = :ND-CODE-UTIL-TYPE               
MFA-TR*              AND TW.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE                
MFA-TR*              AND TW.PRIMARY_IC_NO    = TZ.PRIMARY_IC_NO                 
MFA-TR*              AND TW.PRIMARY_IC_NO    = TZ.IC_NO                         
MFA-TR*              AND TZ.IC_NO            = :ND-IC-NO                        
MFA-TR*              AND TW.CNTRCT_START_DT  = TZ.CNTRCT_START_DT               
MFA-TR*              AND TZ.CNTRCT_START_DT    <= :ND-DATE-READ                 
MFA-TR*              AND TZ.CNTRCT_START_DT =                                   
MFA-TR*                  (SELECT MAX(T1.CNTRCT_START_DT)                        
MFA-TR*                     FROM CSS_TRNSP_VOL_BLK T1                           
MFA-TR*                    WHERE T1.ACCOUNT_NO       = TZ.ACCOUNT_NO            
MFA-TR*                      AND T1.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE        
MFA-TR*                      AND TW.PRIMARY_IC_NO    = T1.PRIMARY_IC_NO         
MFA-TR*                      AND T1.IC_NO    = :ND-IC-NO                        
MFA-TR*                      AND T1.CNTRCT_START_DT <= :ND-DATE-READ)           
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7800'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_TRNSP_CONTRACT'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE ND-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE ND-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'DATE_READ'             TO TABLE-ELEMENT-3          
               MOVE ND-DATE-READ            TO HOSTVAR-ELEMENT-3        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-4          
               MOVE ND-IC-NO                TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7960-GET-TIMESTMP                                            **         
      *                                                              **         
      *****************************************************************         
       7960-GET-TIMESTMP.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*            ,:WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7960'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7970-GET-RESP-AREA-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7970-GET-RESP-AREA-ID.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :WS-USERID                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :WS-USERID                                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7970'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_USER_PROFILE  '    TO TABLE-1                  
               MOVE 'USER_ID'               TO TABLE-ELEMENT-1          
               MOVE WS-USERID               TO HOSTVAR-ELEMENT-1        
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
        7970-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7980 GET TIMESTMP                                              *        
      *      -- THIS MODULE INCREMENTS THE TIMESTAMP TO 1 MICRO        *        
      *         SECOND TO CHECK IF THERE IS ANY TRSP BG.               *        
      ******************************************************************        
       7980-GET-TIMESTMP.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :WS-TRSP-BG-TIMESTMP 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TRSP-BG-TIMESTMP =                                        
MFA-TR*               TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) + 1 MICROSECOND         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7980'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-1          
               MOVE BG-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
        7980-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7990-INSERT-TRSP-BG.                                           *        
      *       -- THIS MODULE INSERTS TRANSPORTATION BG ROW             *        
      ******************************************************************        
       7990-INSERT-TRSP-BG.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_DET                              
                     (PREMISE_NO                                        
                     ,BILL_NO                                           
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,BILL_ITEM_TIMESTMP                                
                     ,DATE_ORIG_BILL                                    
                     ,AMT_BILL_ITEM                                     
                     ,CODE_BILL_CALC                                    
                     ,CODE_BILL_ITM_TYPE                                
                     ,CODE_BILL_ITM_IND                                 
                     ,CODE_DR_CR_CNSMPTN                                
                     ,AMT_STATE_TAX                                     
                     ,AMT_CITY_TAX                                      
                     ,AMT_OTHER_TAX                                     
                     ,CODE_REVENUE_CLASS                                
                     ,CODE_SIC_NO                                       
                     ,RATE_PLAN_NO                                      
                     ,CODE_CURTAIL_PRTY                                 
                     ,CODE_STAT_TAX_XMT                                 
                     ,CODE_CITY_TAX_XMT                                 
                     ,CODE_OTHR_TAX_XMT                                 
                     ,REV_RPT_CD                                        
                     ,STANDBY_COMPLIED                                  
                     ,PRORATE_CD                                        
                     ,NEW_RATE_PCT                                      
                     ,CODE_SUB_TOTAL                                    
                     ,TAX_REFUND_CD                                     
                     ,ACCOUNT_NO                                        
                     ,COMPANY_NO                                        
                     ,DATE_LFTM_HI_DMD                                  
                     ,LFTM_HI_PEAK_DMD                                  
                     ,REBILL_IND                                        
                     ,ADJ_REASON_CD                                     
                     ,REVENUE_MONTH                                     
                     ,GAS_BASE_USE                                      
                     ,WNA_FACTOR                                        
                     ,BTU_FACTOR                                        
                     ,NO_OF_CONS_DAYS                                   
                     ,REV_MTH_ORIG_BILL                                 
                     ,REV_DISTRICT_CD                                   
                     ,FUEL_SHIPPER_CD                                   
                     ,ALTERNATE_FUEL_CD                                 
                     ,TRNSP_OVER_MDQ_FL)                                
              VALUES(:BG-PREMISE-NO                                     
                     ,:BG-BILL-NO                                       
                     ,:BG-CODE-UTIL-TYPE                                
                     ,:BG-IC-NO                                         
                     ,CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP)                
                     ,IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                            :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL :WS-NULL-IND1
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL :WS-NULL-IND1) )             
                     ,:BG-AMT-BILL-ITEM                                 
                     ,:BG-CODE-BILL-CALC                                
                     ,:BG-CODE-BILL-ITM-TYPE                            
                     ,:BG-CODE-BILL-ITM-IND                             
                     ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-AMT-STATE-TAX                                 
                     ,:BG-AMT-CITY-TAX                                  
                     ,:BG-AMT-OTHER-TAX                                 
                     ,:BG-CODE-REVENUE-CLASS                            
                     ,:BG-CODE-SIC-NO                                   
                     ,:BG-RATE-PLAN-NO                                  
                     ,:BG-CODE-CURTAIL-PRTY                             
                     ,:BG-CODE-STAT-TAX-XMT                             
                     ,:BG-CODE-CITY-TAX-XMT                             
                     ,:BG-CODE-OTHR-TAX-XMT                             
                     ,:BG-REV-RPT-CD                                    
                     ,:BG-STANDBY-COMPLIED                              
                     ,:BG-PRORATE-CD                                    
                     ,:BG-NEW-RATE-PCT                                  
                     ,:BG-CODE-SUB-TOTAL                                
                     ,:BG-TAX-REFUND-CD                                 
                     ,:BG-ACCOUNT-NO                                    
                     ,:BG-COMPANY-NO                                    
                     ,IIF(TRY_CONVERT(DATE, :BG-DATE-LFTM-HI-DMD 
                                            :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-LFTM-HI-DMD 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:BG-DATE-LFTM-HI-DMD :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-LFTM-HI-DMD 
                                                          :WS-NULL-IND2
              ), CONVERT(DATE, :BG-DATE-LFTM-HI-DMD :WS-NULL-IND2) )           
                     ,:BG-LFTM-HI-PEAK-DMD                              
                     ,:BG-REBILL-IND                                    
                     ,:BG-ADJ-REASON-CD                                 
                     ,:BG-REVENUE-MONTH                                 
                     ,:BG-GAS-BASE-USE                                  
                     ,:BG-WNA-FACTOR                                    
                     ,:BG-BTU-FACTOR                                    
                     ,:BG-NO-OF-CONS-DAYS                               
                     ,:BG-REV-MTH-ORIG-BILL                             
                     ,:BG-REV-DISTRICT-CD                               
                     ,:BG-FUEL-SHIPPER-CD                               
                     ,:BG-ALTERNATE-FUEL-CD                             
                     ,:BG-TRNSP-OVER-MDQ-FL)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_DET                                      
MFA-TR*              (PREMISE_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,DATE_ORIG_BILL                                            
MFA-TR*              ,AMT_BILL_ITEM                                             
MFA-TR*              ,CODE_BILL_CALC                                            
MFA-TR*              ,CODE_BILL_ITM_TYPE                                        
MFA-TR*              ,CODE_BILL_ITM_IND                                         
MFA-TR*              ,CODE_DR_CR_CNSMPTN                                        
MFA-TR*              ,AMT_STATE_TAX                                             
MFA-TR*              ,AMT_CITY_TAX                                              
MFA-TR*              ,AMT_OTHER_TAX                                             
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,CODE_SIC_NO                                               
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,CODE_CURTAIL_PRTY                                         
MFA-TR*              ,CODE_STAT_TAX_XMT                                         
MFA-TR*              ,CODE_CITY_TAX_XMT                                         
MFA-TR*              ,CODE_OTHR_TAX_XMT                                         
MFA-TR*              ,REV_RPT_CD                                                
MFA-TR*              ,STANDBY_COMPLIED                                          
MFA-TR*              ,PRORATE_CD                                                
MFA-TR*              ,NEW_RATE_PCT                                              
MFA-TR*              ,CODE_SUB_TOTAL                                            
MFA-TR*              ,TAX_REFUND_CD                                             
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,DATE_LFTM_HI_DMD                                          
MFA-TR*              ,LFTM_HI_PEAK_DMD                                          
MFA-TR*              ,REBILL_IND                                                
MFA-TR*              ,ADJ_REASON_CD                                             
MFA-TR*              ,REVENUE_MONTH                                             
MFA-TR*              ,GAS_BASE_USE                                              
MFA-TR*              ,WNA_FACTOR                                                
MFA-TR*              ,BTU_FACTOR                                                
MFA-TR*              ,NO_OF_CONS_DAYS                                           
MFA-TR*              ,REV_MTH_ORIG_BILL                                         
MFA-TR*              ,REV_DISTRICT_CD                                           
MFA-TR*              ,FUEL_SHIPPER_CD                                           
MFA-TR*              ,ALTERNATE_FUEL_CD                                         
MFA-TR*              ,TRNSP_OVER_MDQ_FL)                                        
MFA-TR*       VALUES(:BG-PREMISE-NO                                             
MFA-TR*              ,:BG-BILL-NO                                               
MFA-TR*              ,:BG-CODE-UTIL-TYPE                                        
MFA-TR*              ,:BG-IC-NO                                                 
MFA-TR*              ,:BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:BG-DATE-ORIG-BILL :WS-NULL-IND1                          
MFA-TR*              ,:BG-AMT-BILL-ITEM                                         
MFA-TR*              ,:BG-CODE-BILL-CALC                                        
MFA-TR*              ,:BG-CODE-BILL-ITM-TYPE                                    
MFA-TR*              ,:BG-CODE-BILL-ITM-IND                                     
MFA-TR*              ,:BG-CODE-DR-CR-CNSMPTN                                    
MFA-TR*              ,:BG-AMT-STATE-TAX                                         
MFA-TR*              ,:BG-AMT-CITY-TAX                                          
MFA-TR*              ,:BG-AMT-OTHER-TAX                                         
MFA-TR*              ,:BG-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:BG-CODE-SIC-NO                                           
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*              ,:BG-CODE-CURTAIL-PRTY                                     
MFA-TR*              ,:BG-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-OTHR-TAX-XMT                                     
MFA-TR*              ,:BG-REV-RPT-CD                                            
MFA-TR*              ,:BG-STANDBY-COMPLIED                                      
MFA-TR*              ,:BG-PRORATE-CD                                            
MFA-TR*              ,:BG-NEW-RATE-PCT                                          
MFA-TR*              ,:BG-CODE-SUB-TOTAL                                        
MFA-TR*              ,:BG-TAX-REFUND-CD                                         
MFA-TR*              ,:BG-ACCOUNT-NO                                            
MFA-TR*              ,:BG-COMPANY-NO                                            
MFA-TR*              ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND2                        
MFA-TR*              ,:BG-LFTM-HI-PEAK-DMD                                      
MFA-TR*              ,:BG-REBILL-IND                                            
MFA-TR*              ,:BG-ADJ-REASON-CD                                         
MFA-TR*              ,:BG-REVENUE-MONTH                                         
MFA-TR*              ,:BG-GAS-BASE-USE                                          
MFA-TR*              ,:BG-WNA-FACTOR                                            
MFA-TR*              ,:BG-BTU-FACTOR                                            
MFA-TR*              ,:BG-NO-OF-CONS-DAYS                                       
MFA-TR*              ,:BG-REV-MTH-ORIG-BILL                                     
MFA-TR*              ,:BG-REV-DISTRICT-CD                                       
MFA-TR*              ,:BG-FUEL-SHIPPER-CD                                       
MFA-TR*              ,:BG-ALTERNATE-FUEL-CD                                     
MFA-TR*              ,:BG-TRNSP-OVER-MDQ-FL)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7990'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE BG-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT     
               PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       7990-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *                                                               *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04717_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04717_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04717_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      *                                                                *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04717_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-BUS-RULE-ID                                   
                  ,:S-RS1-BUS-RULE-RESULT-CD                            
                  ,:S-RS1-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04717_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'Y'                      TO  WS-ERR-INSRT-R1         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04717_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT        
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04717_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1           THRU 0100A-EXIT.      
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT.       
           PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT.       
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    COPY BOOK FOR MNT TRANSACTION HIST TABLE.                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
