       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04716.                                         
COB303 DATE-WRITTEN.  DECEMBER,2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS THE RETRIEVE RATE DETAILS, PEAK VOLUME AND  *        
      *  CONSUMPTION DETAILS FOR THE DAILY VOLUME.                     *        
      *  THIS STORED PROCEDURE IS CLONED FROM CSR02531.                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/26/13  AD7F921    INITIAL VERSION                          *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04716'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
             'WORKING STORAGE FOR CSR04716 STARTS HERE'.                
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_VOL_DAILY               ND                                        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBVOLDLY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_VOL_TYPE                X8                                        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBVOLTYP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_BILLING_DET             BG                                        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_JOB_PARM                G6                                        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_UTIL_ENVRNMT            UT                                        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_READ_WINDOW             RW                                        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBRDWNDW                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CSS_PRTY_SVC_CAT            Z4                                        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           COPY CWS00038.                                                       
           COPY CWS00114.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                 PIC X(5)   VALUE SPACES.     
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  WS-GTT-NAME                PIC X(19) VALUE SPACES.       
           05  WS-APPL-RETURN-CODE        PIC S9(04) COMP VALUE 0.      
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
      *                                                                         
           05 S-RETURN-CODE                 PIC S9(04) COMP VALUE 0.    
      *                                                                         
           05 TDS-RETURN-FIELDS-1.                                      
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 RS-RATE-PLAN-NO             PIC X(03) VALUE SPACES.     
             10 RS-REVENUE-CLASS            PIC X(03) VALUE SPACES.     
             10 RS-VOL-TYPE-CD              PIC X(02) VALUE SPACES.     
             10 RS-CATEGORY                 PIC X(02) VALUE SPACES.     
             10 RS-PEAK1-DATE               PIC X(10) VALUE SPACES.     
             10 RS-PEAK1-UNITS              PIC S9(9)V9(1) USAGE COMP-3 
                                                      VALUE -999999999. 
             10 RS-PEAK2-DATE               PIC X(10) VALUE SPACES.     
             10 RS-PEAK2-UNITS              PIC S9(9)V9(1) USAGE COMP-3 
                                                      VALUE -999999999. 
             10 RS-PEAK3-DATE               PIC X(10) VALUE SPACES.     
             10 RS-PEAK3-UNITS              PIC S9(9)V9(1) USAGE COMP-3 
                                                      VALUE -999999999. 
             10 RS-DAYS-COUNT               PIC S9(4)      USAGE COMP   
                                                      VALUE ZEROS.      
             10 RS-MAX-DATE                 PIC X(10) VALUE SPACES.     
             10 RS-MIN-DATE                 PIC X(10) VALUE SPACES.     
      *                                                                         
           05 TDS-RETURN-FIELDS-2.                                      
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
           05 GTT-RETURN-FIELDS-1.                                      
             10 S-RATE-PLAN-NO              PIC X(03) VALUE SPACES.     
             10 S-REVENUE-CLASS             PIC X(03) VALUE SPACES.     
             10 S-VOL-TYPE-CD               PIC X(02) VALUE SPACES.     
             10 S-CATEGORY                  PIC X(02) VALUE SPACES.     
             10 S-PEAK1-DATE                PIC X(10) VALUE SPACES.     
             10 S-PEAK1-UNITS               PIC S9(9)V9(1) USAGE COMP-3 
                                                      VALUE -999999999. 
             10 S-PEAK2-DATE                PIC X(10) VALUE SPACES.     
             10 S-PEAK2-UNITS               PIC S9(9)V9(1) USAGE COMP-3 
                                                      VALUE -999999999. 
             10 S-PEAK3-DATE                PIC X(10) VALUE SPACES.     
             10 S-PEAK3-UNITS               PIC S9(9)V9(1) USAGE COMP-3 
                                                      VALUE -999999999. 
             10 S-DAYS-COUNT                PIC S9(4)      USAGE COMP   
                                                      VALUE ZEROS.      
             10 S-MAX-DATE                  PIC X(10) VALUE SPACES.     
             10 S-MIN-DATE                  PIC X(10) VALUE SPACES.     
      *                                                                         
           05 GTT-RETURN-FIELDS-2.                                      
             10 S-DATE-READ                 PIC X(10) VALUE SPACES.     
             10 S-UNITS                     PIC S9(9)V9(1) USAGE COMP-3 
                                                      VALUE ZEROS.      
           05 GTT-RETURN-FIELDS-3.                                      
             10 S-RETURN-CODE-3             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.    
             10 S-RS3-BUS-RULE-ID           PIC X(10)  VALUE SPACES.    
             10 S-RS3-BUS-RULE-RESULT-CD    PIC X(10)  VALUE SPACES.    
             10 S-RS3-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.    
      *                                                                         
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME               PIC X(08)  VALUE 'CSR04716'.  
           05  WS-PGRMNAME                PIC X(08)  VALUE 'CSR04716'.  
      *                                                                         
       01  STORAGE-FIELDS.                                              
      *                                                                         
           05  WS-PARM-FIELDS.                                          
COB305         10 WS-ACCOUNT-NO-COMP        PIC S9(13)V COMP-3 VALUE 0.         
               10 WS-CODE-UTIL-TYPE       PIC X(1).                     
               10 WS-BILL-NO              PIC S9(9) USAGE COMP.         
               10 WS-IC-NO                PIC S9(04) COMP.              
               10 WS-BILL-ITEM-TIMESTMP   PIC X(26).                    
               10 WS-TRSP-BG-TIMESTMP     PIC X(26).                    
               10 WS-VOL-TYPE-CD          PIC X(02).                    
               10 WS-ENERGY-UNIT-CD       PIC X(01).                    
               10 WS-DEFAULT-VOL          PIC X(01).                    
               10 WS-REVENUE-CLASS        PIC X(03).                    
               10 WS-INPUT-DATE-READ      PIC X(250).                   
               10 WS-INPUT-UNITS          PIC X(250).                   
      *                                                                         
           05  WS-LITERALS.                                             
               10 WS-NT                   PIC X(02) VALUE 'NT'.         
               10 WS-VB                   PIC X(02) VALUE 'VB'.         
               10 WS-FAILED               PIC X(01) VALUE 'F'.          
               10 WS-NO                   PIC X(01) VALUE 'N'.          
               10 WS-YES                  PIC X(01) VALUE 'Y'.          
               10 WS-1                    PIC 9(01) VALUE 1.            
      *                                                                         
           05  WS-DERIVED-FIELDS.                                       
               10 WS-LIMIT                PIC S9(04) COMP VALUE 0.      
               10  WS-DB2-DATE            PIC X(10).                    
               10  WS-MAX-READ-DT         PIC X(10).                    
               10  WS-MIN-READ-DT         PIC X(10).                    
               10  WS-PARM-REVENUE-MONTH.                               
                   15 WS-PARM-REV-YEAR    PIC 9(04).                    
                   15 WS-PARM-REV-MONTH   PIC 9(02).                    
               10  WS-PARM-REV-MONTH-N      REDEFINES                   
                   WS-PARM-REVENUE-MONTH  PIC 9(06).                    
               10  WS-CURR-REV-MONTH      PIC 9(06).                    
               10  WS-PROCESS-REV-MONTH   PIC 9(06).                    
      *                                                                         
           05  WS-NULL-INDICATORS.                                      
               10 WS-NULL-IND1            PIC S9(04)  COMP.             
               10 WS-NULL-IND2            PIC S9(04)  COMP.             
      *                                                                         
       01 WS-INPUT-DATA-TABLE.                                          
          05 WS-INPUT-DATA-TAB OCCURS 31 TIMES INDEXED BY WS-SUB.       
             10 WS-DATE-READ              PIC X(10).                    
             10 WS-NO-UNITS               PIC X(11) JUSTIFIED RIGHT.    
      *                                                                         
       01 WS-FRMT-DATA-TABLE.                                           
          05 WS-FRMT-DATA-TAB OCCURS 31 TIMES INDEXED BY WS-INDEX.      
             10 WS-DATE-READ-FRMT         PIC X(10).                    
COB305       10 WS-NO-UNITS-FRMT        PIC S9(09)V9 USAGE COMP-3 
COB305          VALUE 0.    
      *                                                                         
       01  WS-ERR-FLAGS.                                                
           05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
           05  WS-ERR-INSRT-R3              PIC X(01) VALUE 'N'.        
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
COB305 01 PARM-ACCOUNT-NO        PIC  S9(13)V USAGE COMP-3 VALUE 0.    
       01 PARM-BILL-NO                    PIC  S9(9) USAGE COMP.        
       01 PARM-CODE-UTIL-TYPE             PIC  X(01).                   
       01 PARM-IC-NO                      PIC  S9(4) USAGE COMP.        
       01 PARM-BILL-ITEM-TIMESTMP         PIC  X(26).                   
       01 PARM-VOL-TYPE-CD                PIC  X(02).                   
       01 PARM-ENERGY-UNIT-CD             PIC  X(01).                   
       01 PARM-DEFAULT-VOL                PIC  X(01).                   
      *                                                                         
      ******************************************************************        
      *                         CURSORS                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE DAILYVOL_CURSOR CURSOR FOR                       
                  SELECT NO_UNITS                                       
                        ,DATE_READ                                      
                  FROM  CSS_VOL_DAILY WITH(READUNCOMMITTED)                     
                  WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-COMP        
                     AND BILL_NO            = :WS-BILL-NO               
                     AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-ITEM-TIMESTMP
              )    
                     AND VOL_TYPE_CD        = :WS-VOL-TYPE-CD           
                     AND ENERGY_UNIT_CD     = :WS-ENERGY-UNIT-CD        
                     ORDER BY DATE_READ ASC                             
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DAILYVOL_CURSOR CURSOR FOR                               
MFA-TR*           SELECT NO_UNITS                                               
MFA-TR*                 ,DATE_READ                                              
MFA-TR*           FROM  CSS_VOL_DAILY                                           
MFA-TR*           WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-COMP                
MFA-TR*              AND BILL_NO            = :WS-BILL-NO                       
MFA-TR*              AND BILL_ITEM_TIMESTMP = :WS-BILL-ITEM-TIMESTMP            
MFA-TR*              AND VOL_TYPE_CD        = :WS-VOL-TYPE-CD                   
MFA-TR*              AND ENERGY_UNIT_CD     = :WS-ENERGY-UNIT-CD                
MFA-TR*              ORDER BY DATE_READ ASC                                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION USING   PARM-ACCOUNT-NO                       
                                , PARM-BILL-NO                          
                                , PARM-CODE-UTIL-TYPE                   
                                , PARM-IC-NO                            
                                , PARM-BILL-ITEM-TIMESTMP               
                                , PARM-VOL-TYPE-CD                      
                                , PARM-ENERGY-UNIT-CD                   
                                , PARM-DEFAULT-VOL.                     
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
           PERFORM 0100B-DECLARE-GTT-R2          THRU 0100B-EXIT.       
           PERFORM 0100C-DECLARE-GTT-R3          THRU 0100C-EXIT.       
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-R1.                                            
      *                                                                         
           MOVE 'SESSION.CSR04716_R1'       TO WS-GTT-NAME.             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04716_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04716_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,APPL_RETURN_CODE        INT                      
                  ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,REVENUE_CLASS CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,VOL_TYPE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,CATEGORY CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,PEAK1_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,PEAK1_UNITS             DECIMAL(10,1)                
                  ,PEAK2_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,PEAK2_UNITS             DECIMAL(10,1)                
                  ,PEAK3_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,PEAK3_UNITS             DECIMAL(10,1)                
                  ,DAYS_COUNT              SMALLINT                     
                  ,MAX_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,MIN_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DELETE-GTT-ROWS                            
                                         THRU 8000A-EXIT                
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '0100A'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DECLARE GTT'    TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE 'CSR04716_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND                           
                                         THRU  9700-EXIT                
               END-IF                                                   
           END-IF.                                                      
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(REVENUE_CLASS))        AS 
           REVENUE_CLASS     
                      ,LTRIM(RTRIM(VOL_TYPE_CD))          AS VOL_TYPE_CD       
                      ,LTRIM(RTRIM(CATEGORY))             AS CATEGORY          
                      ,LTRIM(RTRIM(PEAK1_DATE))           AS PEAK1_DATE        
                      ,PEAK1_UNITS                 AS PEAK1_UNITS       
                      ,LTRIM(RTRIM(PEAK2_DATE))           AS PEAK2_DATE        
                      ,PEAK2_UNITS                 AS PEAK2_UNITS       
                      ,LTRIM(RTRIM(PEAK3_DATE))           AS PEAK3_DATE        
                      ,PEAK3_UNITS                 AS PEAK3_UNITS       
                      ,DAYS_COUNT                  AS DAYS_COUNT        
                      ,LTRIM(RTRIM(MAX_DATE))             AS MAX_DATE          
                      ,LTRIM(RTRIM(MIN_DATE))             AS MIN_DATE          
                  FROM #CSR04716_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(REVENUE_CLASS)        AS REVENUE_CLASS             
MFA-TR*               ,STRIP(VOL_TYPE_CD)          AS VOL_TYPE_CD               
MFA-TR*               ,STRIP(CATEGORY)             AS CATEGORY                  
MFA-TR*               ,STRIP(PEAK1_DATE)           AS PEAK1_DATE                
MFA-TR*               ,PEAK1_UNITS                 AS PEAK1_UNITS               
MFA-TR*               ,STRIP(PEAK2_DATE)           AS PEAK2_DATE                
MFA-TR*               ,PEAK2_UNITS                 AS PEAK2_UNITS               
MFA-TR*               ,STRIP(PEAK3_DATE)           AS PEAK3_DATE                
MFA-TR*               ,PEAK3_UNITS                 AS PEAK3_UNITS               
MFA-TR*               ,DAYS_COUNT                  AS DAYS_COUNT                
MFA-TR*               ,STRIP(MAX_DATE)             AS MAX_DATE                  
MFA-TR*               ,STRIP(MIN_DATE)             AS MIN_DATE                  
MFA-TR*           FROM SESSION.CSR04716_R1                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-R2.                                            
      *                                                                         
           MOVE 'SESSION.CSR04716_R2'       TO WS-GTT-NAME.             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04716_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04716_R2
              (                                                        
                   RETURN_CODE             INT                      
                  ,APPL_RETURN_CODE        INT                      
                  ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,UNITS                   DECIMAL(10,1)                
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000B-DELETE-GTT-ROWS                            
                                         THRU 8000B-EXIT                
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '0100B'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DECLARE GTT'    TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE 'CSR04716_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND                           
                                         THRU  9700-EXIT                
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,LTRIM(RTRIM(DATE_READ))           AS DATE_READ              
                  ,UNITS                                                
               FROM                                                     
                   #CSR04716_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,STRIP(DATE_READ)           AS DATE_READ                      
MFA-TR*           ,UNITS                                                        
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04716_R2                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 0100C-DECLARE-GTT-R3                                           *        
      *                                                                *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04716_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04716_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04716_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DELETE-GTT-ROWS    THRU 8000C-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
                      ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
                      ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
                  FROM #CSR04716_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID               
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD        
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SESSION.CSR04716_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *     2. ASSIGNS PARMS TO WORKING STORAGE.                       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-ASSIGN-WS-VARS           THRU 1150-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 1150 ASSIGN-WS-VARS                                            *        
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *        
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *        
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *        
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *        
      *        SELECT STATEMENTS.                                      *        
      ******************************************************************        
       1150-ASSIGN-WS-VARS.                                             
      *                                                                         
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO-COMP             
                                         BG-ACCOUNT-NO.                 
           MOVE PARM-BILL-NO          TO WS-BILL-NO                     
                                         BG-BILL-NO.                    
           MOVE PARM-CODE-UTIL-TYPE   TO WS-CODE-UTIL-TYPE              
                                         BG-CODE-UTIL-TYPE.             
           MOVE PARM-IC-NO            TO WS-IC-NO                       
                                         BG-IC-NO.                      
           MOVE PARM-BILL-ITEM-TIMESTMP                                 
                                      TO WS-BILL-ITEM-TIMESTMP          
                                         BG-BILL-ITEM-TIMESTMP.         
           MOVE PARM-VOL-TYPE-CD      TO WS-VOL-TYPE-CD.                
           MOVE PARM-ENERGY-UNIT-CD   TO WS-ENERGY-UNIT-CD.             
           MOVE PARM-DEFAULT-VOL      TO WS-DEFAULT-VOL.                
           PERFORM VARYING WS-INDEX FROM 1 BY 1                         
                   UNTIL WS-INDEX > 31                                  
              INITIALIZE WS-DATE-READ-FRMT(WS-INDEX)                    
                         WS-NO-UNITS-FRMT(WS-INDEX)                     
           END-PERFORM.                                                 
           SET WS-INDEX               TO WS-1.                          
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2200-GET-DAILY-VOL-DTLS       THRU 2200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 2000A-MOVE-RESULT.                                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE  RS-RATE-PLAN-NO         TO  S-RATE-PLAN-NO.            
           MOVE  RS-REVENUE-CLASS        TO  S-REVENUE-CLASS.           
           MOVE  RS-VOL-TYPE-CD          TO  S-VOL-TYPE-CD.             
           MOVE  RS-CATEGORY             TO  S-CATEGORY.                
           MOVE  RS-PEAK1-DATE           TO  S-PEAK1-DATE.              
           MOVE  RS-PEAK1-UNITS          TO  S-PEAK1-UNITS.             
           MOVE  RS-PEAK2-DATE           TO  S-PEAK2-DATE.              
           MOVE  RS-PEAK2-UNITS          TO  S-PEAK2-UNITS.             
           MOVE  RS-PEAK3-DATE           TO  S-PEAK3-DATE.              
           MOVE  RS-PEAK3-UNITS          TO  S-PEAK3-UNITS.             
           MOVE  RS-DAYS-COUNT           TO  S-DAYS-COUNT.              
           MOVE  RS-MAX-DATE             TO  S-MAX-DATE.                
           MOVE  RS-MIN-DATE             TO  S-MIN-DATE.                
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-GET-DAILY-VOL-DTLS.                                       *        
      *      --THIS MODULE GETS THE DAILY VOL DTLS                     *        
      ******************************************************************        
       2200-GET-DAILY-VOL-DTLS.                                         
      *                                                                         
           PERFORM 2500-GET-RATE-DTLS                THRU 2500-EXIT     
           PERFORM 7000-OPEN-DAILYVOL-CURSOR         THRU 7000-EXIT     
           PERFORM 7100-FETCH-DAILYVOL-CURSOR        THRU 7100-EXIT     
      *  DEFAULT THE VOL TYPE BASED ON THE BG ROW SELECTED.                     
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              IF WS-DEFAULT-VOL = WS-Y                                  
                 MOVE WS-VB                 TO WS-VOL-TYPE-CD           
                                               RS-VOL-TYPE-CD           
                 PERFORM 7200-CLOSE-DAILYVOL-CURSOR  THRU 7200-EXIT     
                 PERFORM 7000-OPEN-DAILYVOL-CURSOR   THRU 7000-EXIT     
                 PERFORM 7100-FETCH-DAILYVOL-CURSOR                     
                                                  THRU 7100-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE WS-NT              TO WS-VOL-TYPE-CD           
                                               RS-VOL-TYPE-CD           
                    PERFORM 7200-CLOSE-DAILYVOL-CURSOR                  
                                                  THRU 7200-EXIT        
                    PERFORM 7000-OPEN-DAILYVOL-CURSOR                   
                                                  THRU 7000-EXIT        
                    PERFORM 7100-FETCH-DAILYVOL-CURSOR                  
                                                  THRU 7100-EXIT        
                 END-IF                                                 
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    PERFORM 7200-CLOSE-DAILYVOL-CURSOR                  
                                                  THRU 7200-EXIT        
                    MOVE ZEROS              TO RS-PEAK1-UNITS           
                                               RS-PEAK2-UNITS           
                                               RS-PEAK3-UNITS           
      *                                                                         
                    MOVE 'BCNSMPT026'       TO S-RS3-BUS-RULE-ID        
                    MOVE WS-FAILED          TO S-RS3-BUS-RULE-RESULT-CD 
                                                                        
                    IF S-RS3-BUS-RULE-ID GREATER THAN SPACES            
                       PERFORM 7550-GET-RULE-XREF-ID                    
                                                  THRU 7550-EXIT        
                    END-IF                                              
                    PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT        
                    PERFORM 9999-END-PROGRAM      THRU 9999-EXIT        
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 7200-CLOSE-DAILYVOL-CURSOR                     
                                                  THRU 7200-EXIT        
                 MOVE ZEROS                 TO RS-PEAK1-UNITS           
                                               RS-PEAK2-UNITS           
                                               RS-PEAK3-UNITS           
      *                                                                         
                 MOVE 'BCNSMPT026'          TO S-RS3-BUS-RULE-ID        
                 MOVE WS-FAILED             TO S-RS3-BUS-RULE-RESULT-CD 
                                                                        
                 IF S-RS3-BUS-RULE-ID GREATER THAN SPACES               
                    PERFORM 7550-GET-RULE-XREF-ID                       
                                                  THRU 7550-EXIT        
                 END-IF                                                 
                 PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT        
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
           END-IF                                                       
           PERFORM 2250-SET-DAILY-VOL-DTLS        THRU 2250-EXIT        
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
           PERFORM 7200-CLOSE-DAILYVOL-CURSOR     THRU 7200-EXIT        
      *                                                                         
           SET  WS-LIMIT                    TO   WS-INDEX               
           SET  WS-INDEX                    TO   WS-1                   
      *                                                                         
           PERFORM 2600-MOVE-RESULTS              THRU 2600-EXIT.       
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2250-SET-DAILY-VOL-DTLS                                        *        
      *                                                                *        
      ******************************************************************        
       2250-SET-DAILY-VOL-DTLS.                                         
      *                                                                         
           PERFORM 2550-GET-PEAK-UNITS            THRU 2550-EXIT.       
           IF WS-INDEX <= 31                                            
              MOVE ND-DATE-READ             TO                          
                                           WS-DATE-READ-FRMT(WS-INDEX)  
              MOVE ND-NO-UNITS              TO                          
                                           WS-NO-UNITS-FRMT(WS-INDEX)   
              ADD WS-1                      TO RS-DAYS-COUNT            
              SET WS-INDEX UP BY WS-1                                   
           END-IF.                                                      
           PERFORM 7100-FETCH-DAILYVOL-CURSOR     THRU 7100-EXIT.       
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-GET-RATE-DTLS                                             *        
      *                                                                *        
      ******************************************************************        
       2500-GET-RATE-DTLS.                                              
           PERFORM 7650-SELECT-RATE-DETAILS       THRU 7650-EXIT.       
           MOVE BG-CODE-CURTAIL-PRTY        TO Z4-CODE-CURTAIL-PRTY.    
           MOVE BG-COMPANY-NO               TO Z4-COMPANY-NO.           
           PERFORM 7660-GET-CATEGORY              THRU 7660-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                   TO RS-CATEGORY              
           ELSE                                                         
              MOVE Z4-PRTY-SVC-CAT-CD       TO RS-CATEGORY              
           END-IF.                                                      
           MOVE BG-RATE-PLAN-NO             TO RS-RATE-PLAN-NO.         
           MOVE BG-CODE-REVENUE-CLASS       TO RS-REVENUE-CLASS.        
           MOVE WS-VOL-TYPE-CD              TO RS-VOL-TYPE-CD.          
           IF  BG-REV-MTH-ORIG-BILL > 0                                 
               MOVE BG-REV-MTH-ORIG-BILL    TO WS-PROCESS-REV-MONTH     
           ELSE                                                         
               MOVE 'REPORTDATE'            TO G6-PROGRAM-NAME          
               MOVE 'DATE'                  TO G6-CMND-CODE             
               MOVE '01'                    TO G6-COMPANY-NO            
               MOVE WS-1                    TO G6-SEQ-NO                
               PERFORM 7750-GET-REVENUE-MNTH      THRU 7750-EXIT        
               MOVE G6-PARM-DATA            TO                          
                                               WS-INPUT-DATA-BREAKDOWN  
               MOVE WS-PARM-YR              TO WS-PARM-REV-YEAR         
               MOVE WS-PARM-MONTH           TO WS-PARM-REV-MONTH        
               MOVE WS-PARM-REV-MONTH-N     TO WS-CURR-REV-MONTH        
               MOVE WS-CURR-REV-MONTH       TO WS-PROCESS-REV-MONTH     
           END-IF.                                                      
      *                                                                         
           PERFORM 2650-GET-MIN-MAX-DT            THRU 2650-EXIT.       
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2550-GET-PEAK-UNITS                                            *        
      *       THIS MODULE SETS UP THE VALUES FOR THE PEAK UNITS        *        
      ******************************************************************        
       2550-GET-PEAK-UNITS.                                             
           EVALUATE TRUE                                                
              WHEN ND-NO-UNITS >= RS-PEAK1-UNITS                        
                 MOVE RS-PEAK2-UNITS        TO RS-PEAK3-UNITS           
                 MOVE RS-PEAK2-DATE         TO RS-PEAK3-DATE            
                 MOVE RS-PEAK1-UNITS        TO RS-PEAK2-UNITS           
                 MOVE RS-PEAK1-DATE         TO RS-PEAK2-DATE            
                 MOVE ND-NO-UNITS           TO RS-PEAK1-UNITS           
                 MOVE ND-DATE-READ          TO RS-PEAK1-DATE            
              WHEN ND-NO-UNITS >= RS-PEAK2-UNITS                        
                 MOVE RS-PEAK2-UNITS        TO RS-PEAK3-UNITS           
                 MOVE RS-PEAK2-DATE         TO RS-PEAK3-DATE            
                 MOVE ND-NO-UNITS           TO RS-PEAK2-UNITS           
                 MOVE ND-DATE-READ          TO RS-PEAK2-DATE            
              WHEN ND-NO-UNITS >= RS-PEAK3-UNITS                        
                 MOVE ND-NO-UNITS           TO RS-PEAK3-UNITS           
                 MOVE ND-DATE-READ          TO RS-PEAK2-DATE            
           END-EVALUATE.                                                
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-MOVE-RESULTS.                                             *        
      *                                                                *        
      ******************************************************************        
       2600-MOVE-RESULTS.                                               
      *                                                                         
           PERFORM 2620-DATE-UNIT-MOVE            THRU 2620-EXIT        
                   VARYING WS-INDEX        FROM 1 BY 1                  
                   UNTIL   WS-INDEX = WS-LIMIT                          
      *                                                                         
           IF RS-PEAK1-UNITS = -999999999                               
              MOVE ZEROS                    TO RS-PEAK1-UNITS           
           END-IF.                                                      
           IF RS-PEAK2-UNITS = -999999999                               
              MOVE ZEROS                    TO RS-PEAK2-UNITS           
           END-IF.                                                      
           IF RS-PEAK3-UNITS = -999999999                               
              MOVE ZEROS                    TO RS-PEAK3-UNITS           
           END-IF.                                                      
           PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT        
           PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.        
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2620-DATE-UNIT-MOVE                                            *        
      *                                                                *        
      ******************************************************************        
       2620-DATE-UNIT-MOVE.                                             
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS-2                               
           MOVE WS-DATE-READ-FRMT(WS-INDEX) TO S-DATE-READ              
           MOVE WS-NO-UNITS-FRMT(WS-INDEX)  TO S-UNITS                  
      *    SET WS-INDEX UP BY WS-1                                              
           PERFORM 8020-INSERT-GTT-R2            THRU 8020-EXIT.        
      *                                                                         
       2620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    2650-GET-MIN-MAX-DT                                      **         
      **                                                             **         
      *****************************************************************         
       2650-GET-MIN-MAX-DT.                                             
           MOVE WS-ACCOUNT-NO-COMP          TO UT-ACCOUNT-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO UT-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO UT-IC-NO.                
           PERFORM 7850-GET-READ-CYCLE           THRU 7850-EXIT.        
           MOVE UT-READ-CYCLE               TO RW-READ-CYCLE.           
           MOVE WS-PROCESS-REV-MONTH        TO RW-REVENUE-MONTH.        
      *                                                                         
           PERFORM 7900-SELECT-OPT-READ-DT        THRU 7900-EXIT.       
           MOVE RW-OPTIMUM-READ-DATE        TO WS-MAX-READ-DT.          
           MOVE WS-MAX-READ-DT              TO RS-MAX-DATE.             
      *                                                                         
           MOVE WS-PROCESS-REV-MONTH        TO WS-PARM-REV-MONTH-N.     
      *                                                                         
           COMPUTE WS-PARM-REV-MONTH = WS-PARM-REV-MONTH - 1.           
      *                                                                         
           IF  WS-PARM-REV-MONTH = 0                                    
               COMPUTE WS-PARM-REV-MONTH = 12                           
               COMPUTE WS-PARM-REV-YEAR  = WS-PARM-REV-YEAR - 1         
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-REV-MONTH-N         TO RW-REVENUE-MONTH.        
           PERFORM 7900-SELECT-OPT-READ-DT        THRU 7900-EXIT.       
           MOVE RW-OPTIMUM-READ-DATE        TO WS-DB2-DATE.             
           PERFORM 7950-GET-NEXT-DAY             THRU 7950-EXIT         
           MOVE WS-DB2-DATE                 TO WS-MIN-READ-DT.          
           MOVE WS-MIN-READ-DT              TO RS-MIN-DATE.             
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-DAILYVOL-CURSOR.                                     *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-DAILYVOL-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN DAILYVOL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_VOL_DAILY'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'VOL_TYPE_CD'           TO TABLE-ELEMENT-3          
               MOVE 'ENERGY_TYPE_CD'        TO TABLE-ELEMENT-4          
               MOVE WS-ACCOUNT-NO-COMP      TO HOSTVAR-ELEMENT-1        
               MOVE WS-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE ND-VOL-TYPE-CD          TO HOSTVAR-ELEMENT-3        
               MOVE ND-ENERGY-UNIT-CD       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-DAILYVOL-CURSOR.                                    *        
      *                                                                *        
      ******************************************************************        
       7100-FETCH-DAILYVOL-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               FETCH DAILYVOL_CURSOR                                    
                INTO :ND-NO-UNITS,                                      
                     :ND-DATE-READ                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_VOL_DAILY'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'VOL_TYPE_CD'           TO TABLE-ELEMENT-3          
               MOVE 'ENERGY_TYPE_CD'        TO TABLE-ELEMENT-4          
               MOVE WS-ACCOUNT-NO-COMP      TO HOSTVAR-ELEMENT-1        
               MOVE WS-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE ND-VOL-TYPE-CD          TO HOSTVAR-ELEMENT-3        
               MOVE ND-ENERGY-UNIT-CD       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-DAILYVOL-CURSOR                                     *        
      *                                                                *        
      ******************************************************************        
       7200-CLOSE-DAILYVOL-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE DAILYVOL_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_VOL_DAILY'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'VOL_TYPE_CD'           TO TABLE-ELEMENT-3          
               MOVE 'ENERGY_TYPE_CD'        TO TABLE-ELEMENT-4          
               MOVE WS-ACCOUNT-NO-COMP      TO HOSTVAR-ELEMENT-1        
               MOVE WS-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE ND-VOL-TYPE-CD          TO HOSTVAR-ELEMENT-3        
               MOVE ND-ENERGY-UNIT-CD       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7550-GET-RULE-XREF-ID                                          *        
      *                                                                *        
      ******************************************************************        
       7550-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS3-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS3-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS3-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS3-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
               MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
               MOVE S-RS3-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-SELECT-RATE-DETAILS                                       *        
      *       -- THIS MODULE SELECTS BG DETAILS.                       *        
      ******************************************************************        
       7650-SELECT-RATE-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                     ,BILL_NO                                           
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
                     ,DATE_ORIG_BILL                                    
                     ,AMT_BILL_ITEM                                     
                     ,CODE_BILL_CALC                                    
                     ,CODE_BILL_ITM_TYPE                                
                     ,CODE_BILL_ITM_IND                                 
                     ,CODE_DR_CR_CNSMPTN                                
                     ,AMT_STATE_TAX                                     
                     ,AMT_CITY_TAX                                      
                     ,AMT_OTHER_TAX                                     
                     ,CODE_REVENUE_CLASS                                
                     ,CODE_SIC_NO                                       
                     ,RATE_PLAN_NO                                      
                     ,CODE_CURTAIL_PRTY                                 
                     ,CODE_STAT_TAX_XMT                                 
                     ,CODE_CITY_TAX_XMT                                 
                     ,CODE_OTHR_TAX_XMT                                 
                     ,REV_RPT_CD                                        
                     ,STANDBY_COMPLIED                                  
                     ,PRORATE_CD                                        
                     ,NEW_RATE_PCT                                      
                     ,CODE_SUB_TOTAL                                    
                     ,TAX_REFUND_CD                                     
                     ,ACCOUNT_NO                                        
                     ,COMPANY_NO                                        
                     ,DATE_LFTM_HI_DMD                                  
                     ,LFTM_HI_PEAK_DMD                                  
                     ,REBILL_IND                                        
                     ,ADJ_REASON_CD                                     
                     ,REVENUE_MONTH                                     
                     ,GAS_BASE_USE                                      
                     ,WNA_FACTOR                                        
                     ,BTU_FACTOR                                        
                     ,NO_OF_CONS_DAYS                                   
                     ,REV_MTH_ORIG_BILL                                 
                     ,REV_DISTRICT_CD                                   
                     ,FUEL_SHIPPER_CD                                   
                     ,ALTERNATE_FUEL_CD                                 
                     ,TRNSP_OVER_MDQ_FL                                 
                 INTO :BG-PREMISE-NO                                    
                     ,:BG-BILL-NO                                       
                     ,:BG-CODE-UTIL-TYPE                                
                     ,:BG-IC-NO                                         
                     ,:BG-BILL-ITEM-TIMESTMP                            
                     ,:BG-DATE-ORIG-BILL :WS-NULL-IND1                  
                     ,:BG-AMT-BILL-ITEM                                 
                     ,:BG-CODE-BILL-CALC                                
                     ,:BG-CODE-BILL-ITM-TYPE                            
                     ,:BG-CODE-BILL-ITM-IND                             
                     ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-AMT-STATE-TAX                                 
                     ,:BG-AMT-CITY-TAX                                  
                     ,:BG-AMT-OTHER-TAX                                 
                     ,:BG-CODE-REVENUE-CLASS                            
                     ,:BG-CODE-SIC-NO                                   
                     ,:BG-RATE-PLAN-NO                                  
                     ,:BG-CODE-CURTAIL-PRTY                             
                     ,:BG-CODE-STAT-TAX-XMT                             
                     ,:BG-CODE-CITY-TAX-XMT                             
                     ,:BG-CODE-OTHR-TAX-XMT                             
                     ,:BG-REV-RPT-CD                                    
                     ,:BG-STANDBY-COMPLIED                              
                     ,:BG-PRORATE-CD                                    
                     ,:BG-NEW-RATE-PCT                                  
                     ,:BG-CODE-SUB-TOTAL                                
                     ,:BG-TAX-REFUND-CD                                 
                     ,:BG-ACCOUNT-NO                                    
                     ,:BG-COMPANY-NO                                    
                     ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND2                
                     ,:BG-LFTM-HI-PEAK-DMD                              
                     ,:BG-REBILL-IND                                    
                     ,:BG-ADJ-REASON-CD                                 
                     ,:BG-REVENUE-MONTH                                 
                     ,:BG-GAS-BASE-USE                                  
                     ,:BG-WNA-FACTOR                                    
                     ,:BG-BTU-FACTOR                                    
                     ,:BG-NO-OF-CONS-DAYS                               
                     ,:BG-REV-MTH-ORIG-BILL                             
                     ,:BG-REV-DISTRICT-CD                               
                     ,:BG-FUEL-SHIPPER-CD                               
                     ,:BG-ALTERNATE-FUEL-CD                             
                     ,:BG-TRNSP-OVER-MDQ-FL                             
                 FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                      
                  AND BILL_NO     = :BG-BILL-NO                         
                  AND IC_NO       = :BG-IC-NO                           
                  AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE               
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,DATE_ORIG_BILL                                            
MFA-TR*              ,AMT_BILL_ITEM                                             
MFA-TR*              ,CODE_BILL_CALC                                            
MFA-TR*              ,CODE_BILL_ITM_TYPE                                        
MFA-TR*              ,CODE_BILL_ITM_IND                                         
MFA-TR*              ,CODE_DR_CR_CNSMPTN                                        
MFA-TR*              ,AMT_STATE_TAX                                             
MFA-TR*              ,AMT_CITY_TAX                                              
MFA-TR*              ,AMT_OTHER_TAX                                             
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,CODE_SIC_NO                                               
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,CODE_CURTAIL_PRTY                                         
MFA-TR*              ,CODE_STAT_TAX_XMT                                         
MFA-TR*              ,CODE_CITY_TAX_XMT                                         
MFA-TR*              ,CODE_OTHR_TAX_XMT                                         
MFA-TR*              ,REV_RPT_CD                                                
MFA-TR*              ,STANDBY_COMPLIED                                          
MFA-TR*              ,PRORATE_CD                                                
MFA-TR*              ,NEW_RATE_PCT                                              
MFA-TR*              ,CODE_SUB_TOTAL                                            
MFA-TR*              ,TAX_REFUND_CD                                             
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,DATE_LFTM_HI_DMD                                          
MFA-TR*              ,LFTM_HI_PEAK_DMD                                          
MFA-TR*              ,REBILL_IND                                                
MFA-TR*              ,ADJ_REASON_CD                                             
MFA-TR*              ,REVENUE_MONTH                                             
MFA-TR*              ,GAS_BASE_USE                                              
MFA-TR*              ,WNA_FACTOR                                                
MFA-TR*              ,BTU_FACTOR                                                
MFA-TR*              ,NO_OF_CONS_DAYS                                           
MFA-TR*              ,REV_MTH_ORIG_BILL                                         
MFA-TR*              ,REV_DISTRICT_CD                                           
MFA-TR*              ,FUEL_SHIPPER_CD                                           
MFA-TR*              ,ALTERNATE_FUEL_CD                                         
MFA-TR*              ,TRNSP_OVER_MDQ_FL                                         
MFA-TR*          INTO :BG-PREMISE-NO                                            
MFA-TR*              ,:BG-BILL-NO                                               
MFA-TR*              ,:BG-CODE-UTIL-TYPE                                        
MFA-TR*              ,:BG-IC-NO                                                 
MFA-TR*              ,:BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:BG-DATE-ORIG-BILL :WS-NULL-IND1                          
MFA-TR*              ,:BG-AMT-BILL-ITEM                                         
MFA-TR*              ,:BG-CODE-BILL-CALC                                        
MFA-TR*              ,:BG-CODE-BILL-ITM-TYPE                                    
MFA-TR*              ,:BG-CODE-BILL-ITM-IND                                     
MFA-TR*              ,:BG-CODE-DR-CR-CNSMPTN                                    
MFA-TR*              ,:BG-AMT-STATE-TAX                                         
MFA-TR*              ,:BG-AMT-CITY-TAX                                          
MFA-TR*              ,:BG-AMT-OTHER-TAX                                         
MFA-TR*              ,:BG-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:BG-CODE-SIC-NO                                           
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*              ,:BG-CODE-CURTAIL-PRTY                                     
MFA-TR*              ,:BG-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-OTHR-TAX-XMT                                     
MFA-TR*              ,:BG-REV-RPT-CD                                            
MFA-TR*              ,:BG-STANDBY-COMPLIED                                      
MFA-TR*              ,:BG-PRORATE-CD                                            
MFA-TR*              ,:BG-NEW-RATE-PCT                                          
MFA-TR*              ,:BG-CODE-SUB-TOTAL                                        
MFA-TR*              ,:BG-TAX-REFUND-CD                                         
MFA-TR*              ,:BG-ACCOUNT-NO                                            
MFA-TR*              ,:BG-COMPANY-NO                                            
MFA-TR*              ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND2                        
MFA-TR*              ,:BG-LFTM-HI-PEAK-DMD                                      
MFA-TR*              ,:BG-REBILL-IND                                            
MFA-TR*              ,:BG-ADJ-REASON-CD                                         
MFA-TR*              ,:BG-REVENUE-MONTH                                         
MFA-TR*              ,:BG-GAS-BASE-USE                                          
MFA-TR*              ,:BG-WNA-FACTOR                                            
MFA-TR*              ,:BG-BTU-FACTOR                                            
MFA-TR*              ,:BG-NO-OF-CONS-DAYS                                       
MFA-TR*              ,:BG-REV-MTH-ORIG-BILL                                     
MFA-TR*              ,:BG-REV-DISTRICT-CD                                       
MFA-TR*              ,:BG-FUEL-SHIPPER-CD                                       
MFA-TR*              ,:BG-ALTERNATE-FUEL-CD                                     
MFA-TR*              ,:BG-TRNSP-OVER-MDQ-FL                                     
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*         WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                              
MFA-TR*           AND BILL_NO     = :BG-BILL-NO                                 
MFA-TR*           AND IC_NO       = :BG-IC-NO                                   
MFA-TR*           AND CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                       
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
      *                                                                         
              IF WS-NULL-IND1 = -1                                      
                 MOVE SPACES                TO BG-DATE-ORIG-BILL        
              END-IF                                                    
      *                                                                         
              IF WS-NULL-IND2 = -1                                      
                 MOVE SPACES                TO BG-DATE-LFTM-HI-DMD      
              END-IF                                                    
      *                                                                         
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7650'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'BILL_NO'               TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-4          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2        
               MOVE BG-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE BG-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7660-GET-CATEGORY                                              *        
      *       -- THIS MODULE SELECTS CATEGORY DETAILS                  *        
      ******************************************************************        
       7660-GET-CATEGORY.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT PRTY_SVC_CAT_CD                                   
                 INTO :Z4-PRTY-SVC-CAT-CD                               
                 FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                 
                WHERE COMPANY_NO        = :Z4-COMPANY-NO                
                  AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRTY_SVC_CAT_CD                                           
MFA-TR*          INTO :Z4-PRTY-SVC-CAT-CD                                       
MFA-TR*          FROM CSS_PRTY_SVC_CAT Z4                                       
MFA-TR*         WHERE COMPANY_NO        = :Z4-COMPANY-NO                        
MFA-TR*           AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7660'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_PRTY_SVC_CAT'      TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2          
               MOVE Z4-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7750-GET-REVENUE-MNTH.                                         *        
      *      -- THIS MODULE GETS THE REPORT DATE FROM THE JOB PARM     *        
      *      -- TABLE FOR THE CURRENT REVENUE MONTH.                   *        
      ******************************************************************        
       7750-GET-REVENUE-MNTH.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  PARM_DATA                                         
                INTO  :G6-PARM-DATA                                     
              FROM    CSS_JOB_PARM WITH(READUNCOMMITTED)                        
              WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                 
                AND   CMND_CODE      = :G6-CMND-CODE                    
                AND   COMPANY_NO     = :G6-COMPANY-NO                   
                AND   SEQ_NO         = :G6-SEQ-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PARM_DATA                                                 
MFA-TR*         INTO  :G6-PARM-DATA                                             
MFA-TR*       FROM    CSS_JOB_PARM                                              
MFA-TR*       WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                         
MFA-TR*         AND   CMND_CODE      = :G6-CMND-CODE                            
MFA-TR*         AND   COMPANY_NO     = :G6-COMPANY-NO                           
MFA-TR*         AND   SEQ_NO         = :G6-SEQ-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7750'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_JOB_PARM'          TO TABLE-1                  
               MOVE 'PROGRAM_NAME'          TO TABLE-ELEMENT-1          
               MOVE G6-PROGRAM-NAME         TO HOSTVAR-ELEMENT-1        
               MOVE 'CMND_CODE'             TO TABLE-ELEMENT-2          
               MOVE G6-CMND-CODE            TO HOSTVAR-ELEMENT-2        
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3          
               MOVE G6-COMPANY-NO           TO HOSTVAR-ELEMENT-3        
               MOVE 'SEQ_NO'                TO TABLE-ELEMENT-4          
               MOVE G6-SEQ-NO               TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** SELECT READ CYCLE FOR THE ACCOUNT                           **         
      *****************************************************************         
       7850-GET-READ-CYCLE.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT READ_CYCLE                                        
                 INTO :UT-READ-CYCLE                                    
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE ACCOUNT_NO    = :UT-ACCOUNT-NO                    
                  AND CODE_UTIL_TYPE= :UT-CODE-UTIL-TYPE                
                  AND IC_NO         = :UT-IC-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_CYCLE                                                
MFA-TR*          INTO :UT-READ-CYCLE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE ACCOUNT_NO    = :UT-ACCOUNT-NO                            
MFA-TR*           AND CODE_UTIL_TYPE= :UT-CODE-UTIL-TYPE                        
MFA-TR*           AND IC_NO         = :UT-IC-NO                                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7850'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE UT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE UT-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE UT-IC-NO                TO HOSTVAR-ELEMENT-3        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      ** SELECT OPTIMUM READ DATE OF THE MONTH                       **         
      *****************************************************************         
       7900-SELECT-OPT-READ-DT.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT OPTIMUM_READ_DATE                                 
                 INTO :RW-OPTIMUM-READ-DATE                             
                 FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
                WHERE READ_CYCLE    = :RW-READ-CYCLE                    
                  AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OPTIMUM_READ_DATE                                         
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE                                     
MFA-TR*          FROM CSS_READ_WINDOW                                           
MFA-TR*         WHERE READ_CYCLE    = :RW-READ-CYCLE                            
MFA-TR*           AND REVENUE_MONTH = :RW-REVENUE-MONTH                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7900'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_READ_WINDOW'       TO TABLE-1                  
               MOVE 'READ_CYCLE'            TO TABLE-ELEMENT-1          
               MOVE RW-READ-CYCLE           TO HOSTVAR-ELEMENT-1        
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-2          
               MOVE RW-REVENUE-MONTH        TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      ** SELECT TO ADD ONE DAY TO A DATE                             **         
      *****************************************************************         
       7950-GET-NEXT-DAY.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )
            INTO
              :WS-DB2-DATE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DB2-DATE = DATE(:WS-DB2-DATE) + 1 DAY                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7950'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'DATE'                  TO TABLE-ELEMENT-1          
               MOVE WS-DB2-DATE             TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      *                                                                *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE '8000A'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'DELETE ROWS_C1'            TO WS-GTT-NAME.             
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04716_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04716_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
                MOVE '8000A'                TO ACTIVE-PARAGRAPH         
                MOVE 'DELETE'               TO ABEND-FUNCTION           
                MOVE SPACES                 TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                MOVE 'CSR04716_R1'          TO TABLE-1                  
                MOVE SPACES                 TO TABLE-ELEMENT-1          
                MOVE SPACES                 TO HOSTVAR-ELEMENT-1        
                PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      *                                                                *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE '8000B'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'DELETE ROWS_C2'            TO WS-GTT-NAME.             
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04716_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04716_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
                MOVE '8000B'                TO ACTIVE-PARAGRAPH         
                MOVE 'DELETE'               TO ABEND-FUNCTION           
                MOVE SPACES                 TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                MOVE 'CSR04716_R2'          TO TABLE-1                  
                MOVE SPACES                 TO TABLE-ELEMENT-1          
                MOVE SPACES                 TO HOSTVAR-ELEMENT-1        
                PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8000C-DELETE-GTT-ROWS.                                         *        
      *                                                                *        
      ******************************************************************        
       8000C-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE '8000C'                     TO ACTIVE-PARAGRAPH.        
           MOVE 'DELETE ROWS_C3'            TO WS-GTT-NAME.             
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04716_R3                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04716_R3                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
                MOVE '8000C'                TO ACTIVE-PARAGRAPH         
                MOVE 'DELETE'               TO ABEND-FUNCTION           
                MOVE SPACES                 TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                MOVE 'CSR04716_R3'          TO TABLE-1                  
                MOVE SPACES                 TO TABLE-ELEMENT-1          
                MOVE SPACES                 TO HOSTVAR-ELEMENT-1        
                PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT        
           END-IF.                                                      
      *                                                                         
       8000C-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1                                                      
      *                                                                         
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
           EXEC SQL                                                     
             INSERT INTO #CSR04716_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,RATE_PLAN_NO                                              
             ,REVENUE_CLASS                                             
             ,VOL_TYPE_CD                                               
             ,CATEGORY                                                  
             ,PEAK1_DATE                                                
             ,PEAK1_UNITS                                               
             ,PEAK2_DATE                                                
             ,PEAK2_UNITS                                               
             ,PEAK3_DATE                                                
             ,PEAK3_UNITS                                               
             ,DAYS_COUNT                                                
             ,MAX_DATE                                                  
             ,MIN_DATE                                                  
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-1                                          
             ,:S-APPL-RETURN-CODE-1                                     
             ,:S-RATE-PLAN-NO                                           
             ,:S-REVENUE-CLASS                                          
             ,:S-VOL-TYPE-CD                                            
             ,:S-CATEGORY                                               
             ,:S-PEAK1-DATE                                             
             ,:S-PEAK1-UNITS                                            
             ,:S-PEAK2-DATE                                             
             ,:S-PEAK2-UNITS                                            
             ,:S-PEAK3-DATE                                             
             ,:S-PEAK3-UNITS                                            
             ,:S-DAYS-COUNT                                             
             ,:S-MAX-DATE                                               
             ,:S-MIN-DATE                                               
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04716_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,REVENUE_CLASS                                                     
MFA-TR*      ,VOL_TYPE_CD                                                       
MFA-TR*      ,CATEGORY                                                          
MFA-TR*      ,PEAK1_DATE                                                        
MFA-TR*      ,PEAK1_UNITS                                                       
MFA-TR*      ,PEAK2_DATE                                                        
MFA-TR*      ,PEAK2_UNITS                                                       
MFA-TR*      ,PEAK3_DATE                                                        
MFA-TR*      ,PEAK3_UNITS                                                       
MFA-TR*      ,DAYS_COUNT                                                        
MFA-TR*      ,MAX_DATE                                                          
MFA-TR*      ,MIN_DATE                                                          
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-1                                                  
MFA-TR*      ,:S-APPL-RETURN-CODE-1                                             
MFA-TR*      ,:S-RATE-PLAN-NO                                                   
MFA-TR*      ,:S-REVENUE-CLASS                                                  
MFA-TR*      ,:S-VOL-TYPE-CD                                                    
MFA-TR*      ,:S-CATEGORY                                                       
MFA-TR*      ,:S-PEAK1-DATE                                                     
MFA-TR*      ,:S-PEAK1-UNITS                                                    
MFA-TR*      ,:S-PEAK2-DATE                                                     
MFA-TR*      ,:S-PEAK2-UNITS                                                    
MFA-TR*      ,:S-PEAK3-DATE                                                     
MFA-TR*      ,:S-PEAK3-UNITS                                                    
MFA-TR*      ,:S-DAYS-COUNT                                                     
MFA-TR*      ,:S-MAX-DATE                                                       
MFA-TR*      ,:S-MIN-DATE                                                       
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-YES          
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-YES                TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04716_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
       8010-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 8020-INSERT-GTT-R2                                                      
      *                                                                         
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
           EXEC SQL                                                     
             INSERT INTO #CSR04716_R2                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,DATE_READ                                                 
             ,UNITS                                                     
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-2                                          
             ,:S-APPL-RETURN-CODE-2                                     
             ,:S-DATE-READ                                              
             ,:S-UNITS                                                  
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04716_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,DATE_READ                                                         
MFA-TR*      ,UNITS                                                             
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-2                                                  
MFA-TR*      ,:S-APPL-RETURN-CODE-2                                             
MFA-TR*      ,:S-DATE-READ                                                      
MFA-TR*      ,:S-UNITS                                                          
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = WS-YES          
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-YES                TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04716_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
       8020-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04716_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,BUS_RULE_ID                                          
                  ,BUS_RULE_RESULT_CD                                   
                  ,BUS_RULE_XREF_ID                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-BUS-RULE-ID                                   
                  ,:S-RS3-BUS-RULE-RESULT-CD                            
                  ,:S-RS3-BUS-RULE-XREF-ID                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04716_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,BUS_RULE_ID                                                  
MFA-TR*           ,BUS_RULE_RESULT_CD                                           
MFA-TR*           ,BUS_RULE_XREF_ID                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-BUS-RULE-ID                                           
MFA-TR*           ,:S-RS3-BUS-RULE-RESULT-CD                                    
MFA-TR*           ,:S-RS3-BUS-RULE-XREF-ID                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = WS-YES          
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-YES                TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04716_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              MOVE RS-MAX-DATE               TO S-MAX-DATE              
              MOVE RS-MIN-DATE               TO S-MIN-DATE              
              PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT        
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT        
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S-RETURN-CODE-3         
              MOVE 100                       TO S-APPL-RETURN-CODE-3    
              PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT        
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04716_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04716_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04716_R3'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS            THRU 8800-EXIT        
            PERFORM 8900-SEND-DONE                THRU 8900-EXIT        
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
