       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04712.                                         
COB303 DATE-WRITTEN.  MAY 16, 2014.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES MISC ACCOUNT INFORMATION.                *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  05/16/14   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04712'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     01050000
              INCLUDE TBACCT                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBNMACTX                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBATMISC                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04712'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-MISC-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 MISC-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-MISC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 MISC-CHANGED                    VALUE 'YES'.          
           05  WS-ACCT-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ACCT-CHANGED                    VALUE 'YES'.          
           05  WS-ARCI-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ARCI-CHANGED                    VALUE 'YES'.          
           05  WS-PREV-ARC-IND          PIC X(01) VALUE SPACES.         
           05  WS-COMMENTS-NO          PIC X(210) VALUE                 
           'PERSONAL CHECK RECEIVED BY MAIL WILL NOT BE CONVERTED TO ELE        
      -    'CTRONIC PAYMENT.'.                                                  
           05  WS-COMMENTS-YES         PIC X(210) VALUE                 
           'PERSONAL CHECK RECEIVED BY MAIL WILL BE CONVERTED TO ELECTRO        
      -    'NIC PAYMENT. CUSTOMER WILL NOT RECEIVE CANCELED CHECK FROM H        
      -    'IS  FINANCIAL INSTITUTION.'.                                        
           05  WS-ATTRIBUTE-DESC       PIC X(210) VALUE                 
           'CONVERT CHECK ELECTRONICALLY FOR PROCESSING-DEFAULT IS YES'.
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-CODE-MAJOR-ACCT     PIC X(01).                          
       01  LINK-ARC-IND             PIC X(01).                          
       01  LINK-GROUP-ID            PIC X(25).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
       01  LINK-SEASONAL-FL         PIC X(01).                          
       01  LINK-ACCOUNT-TYPE-CODE   PIC X(01).                          
       01  LINK-CODE-CRIT-OUTAGE    PIC X(02).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO,                                        
                LINK-CODE-MAJOR-ACCT,                                   
                LINK-ARC-IND,                                           
                LINK-GROUP-ID,                                          
                LINK-USERID,                                            
                LINK-COMMENTS,                                          
                LINK-SEASONAL-FL,                                       
                LINK-ACCOUNT-TYPE-CODE,                                 
                LINK-CODE-CRIT-OUTAGE.                                  
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-PREMISE-NO               
                                            MH-CUSTOMER-NO.             
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 'PANEL085'               TO MH-APPL-PROGRAM-ID.         
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
                                                                        
           MOVE 'NO' TO WS-ACCT-CHANGED-FLAG.                           
                                                                        
           IF AT-CODE-MAJOR-ACCT NOT = LINK-CODE-MAJOR-ACCT             
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-CODE-MAJOR-ACCT > SPACES                         
                   MOVE +1 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-CODE-MAJOR-ACCT TO                         
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-CODE-MAJOR-ACCT > SPACES                           
                   MOVE +1 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-CODE-MAJOR-ACCT TO   MI-PRV-COLUMN-VALUE-TEXT
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'MAJOR ACCT' TO MI-COLUMN-DESC                      
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF AT-ACCOUNT-TYPE-CODE NOT = LINK-ACCOUNT-TYPE-CODE         
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-ACCOUNT-TYPE-CODE > SPACES                       
                   MOVE +1 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-ACCOUNT-TYPE-CODE TO                       
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-ACCOUNT-TYPE-CODE > SPACES                         
                   MOVE +1 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-ACCOUNT-TYPE-CODE TO MI-PRV-COLUMN-VALUE-TEXT
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'N9' TO MI-TABLE-ID                                 
               MOVE 'ACCT TYPE CODE' TO MI-COLUMN-DESC                  
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO                                 
               MOVE SPACES TO MI-TABLE-ID
           END-IF.                              
                                                                        
           IF AT-CODE-CRIT-OUTAGE NOT = LINK-CODE-CRIT-OUTAGE           
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-CODE-CRIT-OUTAGE > SPACES                        
                   MOVE +2 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-CODE-CRIT-OUTAGE TO                        
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-CODE-CRIT-OUTAGE > SPACES                          
                   MOVE +2 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-CODE-CRIT-OUTAGE TO MI-PRV-COLUMN-VALUE-TEXT 
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'Q2' TO MI-TABLE-ID                                 
               MOVE 'CRITICAL ACCT' TO MI-COLUMN-DESC                   
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO                                 
               MOVE SPACES TO MI-TABLE-ID
           END-IF.                              
                                                                        
           IF ACCT-CHANGED                                              
               MOVE LINK-CODE-MAJOR-ACCT TO AT-CODE-MAJOR-ACCT          
               MOVE LINK-ACCOUNT-TYPE-CODE TO AT-ACCOUNT-TYPE-CODE      
               MOVE LINK-CODE-CRIT-OUTAGE TO AT-CODE-CRIT-OUTAGE        
               PERFORM 8350-UPDATE-ACCOUNT THRU 8350-EXIT               
               PERFORM 8360-UPDATE-XREF THRU 8360-EXIT
           END-IF.                 
                                                                        
           MOVE 'NO' TO WS-MISC-EXISTS-FLAG                             
                        WS-MISC-CHANGED-FLAG.                           
                                                                        
           PERFORM 7030-SELECT-ACCT-MISC THRU 7030-EXIT.                
           IF NOT MISC-EXISTS                                           
               INITIALIZE DCLCSS-ACCT-MISC-INFO
           END-IF.                        
                                                                        
           IF TA-GROUP-ID NOT = LINK-GROUP-ID                           
               MOVE 'YES' TO WS-MISC-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-GROUP-ID > SPACES                                
                   MOVE +25 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-GROUP-ID TO MI-CHG-COLUMN-VALUE-TEXT       
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF TA-GROUP-ID > SPACES                                  
                   MOVE +25 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE TA-GROUP-ID TO MI-PRV-COLUMN-VALUE-TEXT         
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'GROUP/CONTRACT' TO MI-COLUMN-DESC                  
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF TA-SEASONAL-FL = ' ' OR 'N'                               
               MOVE ' ' TO TA-SEASONAL-FL
           END-IF.                              
           IF LINK-SEASONAL-FL = ' ' OR 'N'                             
               MOVE ' ' TO LINK-SEASONAL-FL
           END-IF.                            
                                                                        
           IF TA-SEASONAL-FL NOT = LINK-SEASONAL-FL                     
               MOVE 'YES' TO WS-MISC-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-SEASONAL-FL > SPACES                             
                   MOVE +1 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-SEASONAL-FL TO MI-CHG-COLUMN-VALUE-TEXT    
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF TA-SEASONAL-FL > SPACES                               
                   MOVE +1 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE TA-SEASONAL-FL TO MI-PRV-COLUMN-VALUE-TEXT      
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'SEASONAL FL' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF MISC-CHANGED                                              
               MOVE LINK-GROUP-ID TO TA-GROUP-ID                        
               MOVE LINK-SEASONAL-FL TO TA-SEASONAL-FL                  
               IF MISC-EXISTS                                           
                   PERFORM 8340-UPDATE-MISC THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-MISC THRU 8190-EXIT         
               ELSE                                                     
                   PERFORM 8050-INSERT-MISC THRU 8050-EXIT
               END-IF
           END-IF.             
                                                                        
           IF LINK-ARC-IND = 'I'                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 2010-ARC-PROCESSING THRU 2010-EXIT
           END-IF.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-ARC-PROCESSING.                                             
                                                                        
           MOVE 'NO' TO WS-ARCI-CHANGED-FLAG.                           
                                                                        
           PERFORM 7040-SELECT-ARC-IND THRU 7040-EXIT.                  
                                                                        
           IF WS-PREV-ARC-IND NOT = LINK-ARC-IND                        
               MOVE 'YES' TO WS-ARCI-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-ARC-IND > SPACES                                 
                   MOVE +3 TO MI-CHG-COLUMN-VALUE-LEN                   
                   EVALUATE LINK-ARC-IND                                
                       WHEN 'N'                                         
                           MOVE 'NO' TO MI-CHG-COLUMN-VALUE-TEXT        
                       WHEN OTHER                                       
                           MOVE 'YES' TO MI-CHG-COLUMN-VALUE-TEXT       
                   END-EVALUATE                                         
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF WS-PREV-ARC-IND > SPACES                              
                   MOVE +3 TO MI-CHG-COLUMN-VALUE-LEN                   
                   EVALUATE WS-PREV-ARC-IND                             
                       WHEN 'N'                                         
                           MOVE 'NO' TO MI-PRV-COLUMN-VALUE-TEXT        
                       WHEN OTHER                                       
                           MOVE 'YES' TO MI-PRV-COLUMN-VALUE-TEXT       
                   END-EVALUATE                                         
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'CONV CHK (ARC)' TO MI-COLUMN-DESC                  
               IF WS-COMMENTS-TEXT = SPACES                             
                   EVALUATE LINK-ARC-IND                                
                       WHEN 'N'                                         
                           MOVE WS-COMMENTS-NO TO MH-TRAN-COMMENT-TEXT  
                           MOVE +100 TO MH-TRAN-COMMENT-LEN             
                       WHEN OTHER                                       
                           MOVE WS-COMMENTS-YES TO MH-TRAN-COMMENT-TEXT 
                           MOVE +150 TO MH-TRAN-COMMENT-LEN             
                   END-EVALUATE                                         
               ELSE                                                     
                   EVALUATE LINK-ARC-IND                                
                       WHEN 'N'                                         
                           STRING WS-COMMENTS-TEXT(1:WS-COMMENTS-LEN)   
                                  '-'                                   
                                  WS-COMMENTS-NO                        
                                  DELIMITED BY SIZE                     
                                  INTO MH-TRAN-COMMENT-TEXT             
                           END-STRING                                   
                           MOVE 210 TO MH-TRAN-COMMENT-LEN              
                       WHEN OTHER                                       
                           STRING WS-COMMENTS-TEXT(1:WS-COMMENTS-LEN)   
                                  '-'                                   
                                  WS-COMMENTS-YES                       
                                  DELIMITED BY SIZE                     
                                  INTO MH-TRAN-COMMENT-TEXT             
                           END-STRING                                   
                       MOVE 210 TO MH-TRAN-COMMENT-LEN                  
                   END-EVALUATE                                         
               END-IF                                                   
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
      * THE DEFAULT FOR CONVERTING CHECKS ELECTRONICALLY IS YES                 
      * IF NO IS SELECTED, ADD THE ATTRIBUTE                                    
      * IF YES IS SELECTED, DELETE THE ATTRIBUTE                                
                                                                        
           IF ARCI-CHANGED                                              
               EVALUATE LINK-ARC-IND                                    
                   WHEN 'N'                                             
                       MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO              
                       MOVE SPACES TO YP-STATUS-CD                      
                       MOVE 'CONVERT_CHK_ELEC' TO YP-ATTRIBUTE-DESC     
                       MOVE 'NO' TO YP-ATTRIBUTE-VALUE-CD               
                       MOVE +60 TO YP-ATTRIBUTE-VALUE-TX-LEN            
                       MOVE WS-ATTRIBUTE-DESC TO                        
                            YP-ATTRIBUTE-VALUE-TX-TEXT                  
                       PERFORM 8060-INSERT-ATTRIBUTE THRU 8060-EXIT     
                   WHEN 'Y'                                             
                       MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO              
                       MOVE 'CONVERT_CHK_ELEC' TO YP-ATTRIBUTE-DESC     
                       PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT     
               END-EVALUATE
           END-IF.                                            
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_MAJOR_ACCT,
              ACCOUNT_TYPE_CODE,
              CODE_CRIT_OUTAGE,
              COMPANY_NO                                         
                INTO :AT-CODE-MAJOR-ACCT,                               
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-CRIT-OUTAGE,                              
                     :AT-COMPANY-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_MAJOR_ACCT,                                           
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              CODE_CRIT_OUTAGE,                                          
MFA-TR*              COMPANY_NO                                                 
MFA-TR*         INTO :AT-CODE-MAJOR-ACCT,                                       
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-CODE-CRIT-OUTAGE,                                      
MFA-TR*              :AT-COMPANY-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-ACCT-MISC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              GROUP_ID,
              SEASONAL_FL                                        
                INTO :WS-MISC-EXISTS-FLAG,                              
                     :TA-GROUP-ID,                                      
                     :TA-SEASONAL-FL                                    
                FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              GROUP_ID,                                                  
MFA-TR*              SEASONAL_FL                                                
MFA-TR*         INTO :WS-MISC-EXISTS-FLAG,                                      
MFA-TR*              :TA-GROUP-ID,                                              
MFA-TR*              :TA-SEASONAL-FL                                            
MFA-TR*         FROM CSS_ACCT_MISC_INFO                                         
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7030'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-ARC-IND.                                             
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) YP.ACCOUNT_NO                                    
                  INTO :YP-ACCOUNT-NO                                   
                  FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED),                  
                       CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
                 WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
                   AND YP.ATTRIBUTE_DESC    = 'CONVERT_CHK_ELEC'        
                   AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
                   AND YP.ACCOUNT_NO        = :AT-ACCOUNT-NO            
                   AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
                   AND WZ.ATTRIBUTE_TYPE_TX = 'ARC'                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT YP.ACCOUNT_NO                                            
MFA-TR*           INTO :YP-ACCOUNT-NO                                           
MFA-TR*           FROM CSS_ATTRIBUTE WZ,                                        
MFA-TR*                CSS_ACCT_ATTRIBUTE YP                                    
MFA-TR*          WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC                 
MFA-TR*            AND YP.ATTRIBUTE_DESC    = 'CONVERT_CHK_ELEC'                
MFA-TR*            AND WZ.COMPANY_NO        = :AT-COMPANY-NO                    
MFA-TR*            AND YP.ACCOUNT_NO        = :AT-ACCOUNT-NO                    
MFA-TR*            AND WZ.ATTRIBUTE_STAT_CD = 'A'                               
MFA-TR*            AND WZ.ATTRIBUTE_TYPE_TX = 'ARC'                             
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO WS-PREV-ARC-IND                          
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'Y' TO WS-PREV-ARC-IND                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7040'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'CSS_ATTRIBUTE'   TO TABLE-2                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   MOVE 'ATTRIBUTE_DESC'  TO TABLE-ELEMENT-2            
                   MOVE YP-ATTRIBUTE-DESC TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-MISC.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_MISC_INFO                            
                   ( ACCOUNT_NO,                                        
                     GROUP_ID,                                          
                     SEASONAL_FL)                                       
              VALUES                                                    
                   (:AT-ACCOUNT-NO,                                     
                    :TA-GROUP-ID,                                       
                    :TA-SEASONAL-FL)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-ATTRIBUTE.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_ATTRIBUTE                           
                     (ACCOUNT_NO,                                       
                      ATTRIBUTE_DESC,                                   
                      ATTRIBUTE_VALUE_CD,                               
                      ATTRIBUTE_VALUE_DT,                               
                      ATTRIBUTE_VALUE_TX,                               
                      STATUS_CD)                                        
               VALUES                                                   
                     (:YP-ACCOUNT-NO,                                   
                      :YP-ATTRIBUTE-DESC,                               
                      :YP-ATTRIBUTE-VALUE-CD,                           
                      CAST(SYSDATETIMEOFFSET() AS DATE),                        
                      :YP-ATTRIBUTE-VALUE-TX,                           
                      :YP-STATUS-CD)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               ATTRIBUTE_DESC,                                           
MFA-TR*               ATTRIBUTE_VALUE_CD,                                       
MFA-TR*               ATTRIBUTE_VALUE_DT,                                       
MFA-TR*               ATTRIBUTE_VALUE_TX,                                       
MFA-TR*               STATUS_CD)                                                
MFA-TR*        VALUES                                                           
MFA-TR*              (:YP-ACCOUNT-NO,                                           
MFA-TR*               :YP-ATTRIBUTE-DESC,                                       
MFA-TR*               :YP-ATTRIBUTE-VALUE-CD,                                   
MFA-TR*               CURRENT DATE,                                             
MFA-TR*               :YP-ATTRIBUTE-VALUE-TX,                                   
MFA-TR*               :YP-STATUS-CD)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-2              
              MOVE YP-ATTRIBUTE-DESC    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8180-DELETE-ATTRIBUTE.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_ATTRIBUTE                            
               WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                    
                 AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ACCT_ATTRIBUTE                                    
MFA-TR*        WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                            
MFA-TR*          AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                        
MFA-TR*       QUERYNO 8180                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ATTRIBUTE'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-2              
              MOVE YP-ATTRIBUTE-DESC    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-MISC.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_MISC_INFO                            
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
                 AND EDI_PHONE_NO       = ' '                           
                 AND LOCK_BOX_NO        = ' '                           
                 AND ADDTL_BILL_NAME_TX = ' '                           
                 AND SPCL_BILL_STMNT_TX = ' '                           
                 AND INTERNET_ADDR      = ' '                           
                 AND EDI_ACCT_CD        = ' '                           
                 AND DBA_TAX_ID         = ' '                           
                 AND GROUP_ID           = ' '                           
                 AND SERVICE_CARE_ID    = ' '                           
                 AND WEBSITE_ADDR       = ' '                           
                 AND SEASONAL_FL        = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ACCT_MISC_INFO                                    
MFA-TR*        WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO                       
MFA-TR*          AND EDI_PHONE_NO       = ' '                                   
MFA-TR*          AND LOCK_BOX_NO        = ' '                                   
MFA-TR*          AND ADDTL_BILL_NAME_TX = ' '                                   
MFA-TR*          AND SPCL_BILL_STMNT_TX = ' '                                   
MFA-TR*          AND INTERNET_ADDR      = ' '                                   
MFA-TR*          AND EDI_ACCT_CD        = ' '                                   
MFA-TR*          AND DBA_TAX_ID         = ' '                                   
MFA-TR*          AND GROUP_ID           = ' '                                   
MFA-TR*          AND SERVICE_CARE_ID    = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND SEASONAL_FL        = ' '                                   
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-MISC.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_MISC_INFO                                 
                 SET GROUP_ID = :TA-GROUP-ID,                           
                     SEASONAL_FL = :TA-SEASONAL-FL                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_MISC_INFO                                         
MFA-TR*          SET GROUP_ID = :TA-GROUP-ID,                                   
MFA-TR*              SEASONAL_FL = :TA-SEASONAL-FL                              
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8340'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8350-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_MAJOR_ACCT   = :AT-CODE-MAJOR-ACCT,           
                     ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE,         
                     CODE_CRIT_OUTAGE  = :AT-CODE-CRIT-OUTAGE           
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODE_MAJOR_ACCT   = :AT-CODE-MAJOR-ACCT,                   
MFA-TR*              ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE,                 
MFA-TR*              CODE_CRIT_OUTAGE  = :AT-CODE-CRIT-OUTAGE                   
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8350'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-XREF.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME_ACCT_XREF                                 
                 SET ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME_ACCT_XREF                                         
MFA-TR*          SET ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE                  
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8360'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
