       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04711.                                         
COB303 DATE-WRITTEN.  MAY 15, 2014.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES ACCOUNT BILLING DETAILS.                 *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  05/15/14   FMB       NEW PROGRAM.                             *00290000
ACT233*  07/26/16   TP7R341   REPLACE CSR00028 WITH CSR04675           *00290000
ACT233*   A05460                                                       *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04711'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     01050000
              INCLUDE TBACCT                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBBLLHDR                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBBLLDET                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBBNKEFT                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBUTLENV                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBPDBKDF                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBSODAT                                           01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBSOCREW                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBWKAR                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-ORDER-NO-CHAR         PIC X(13).                      
           05  WS-ORDER-NO-NUM          REDEFINES WS-ORDER-NO-CHAR      
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      REDEFINES WS-CUSTOMER-NO-NUM    
                                        PIC X(10).                      
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04711'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-DISPLAY-COPIES        PIC 9(04) VALUE ZEROES.         
           05  WS-EFT-FL                PIC X(01) VALUE SPACES.         
           05  WS-GENERATE-WQ-FL        PIC X(01) VALUE SPACES.         
           05  WS-PENDING-DRAFT-FL      PIC X(01) VALUE SPACES.         
           05  WS-PAYMENT-FL            PIC X(01) VALUE SPACES.         
           05  WS-UPDATE-PROFILE-FL     PIC X(01) VALUE SPACES.         
           05  WS-BILL-CYCLE-NUM        PIC 9(02)   VALUE 0.            
           05  WS-NEW-DRAFT-CYCLE       PIC 9(02)   VALUE 0.            
           05  WS-NEW-DRAFT-CYCLE-C     PIC X(02)   VALUE SPACES.       
           05  WS-BILL-CYCLE-PLUS-5     PIC 9(02)   VALUE 0.            
           05  WS-BILL-CYCLE-MINUS-2    PIC 9(02)   VALUE 0.            
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-ACCT-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ACCT-CHANGED                    VALUE 'YES'.          
           05  WS-BCYC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 BCYC-CHANGED                    VALUE 'YES'.          
           05  WS-REAS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 REAS-CHANGED                    VALUE 'YES'.          
           05  WS-WQ-COMMENTS-1.                                        
               10  F                    PIC X(40) VALUE                 
              'PAYMENT RECEIVED,DNP STATE IS COMPLETE,'.                
               10  F                    PIC X(47) VALUE                 
              'POST ORDER AND REVIEW FOR POSSIBLE RECONNECT.'.          
           05  WS-WQ-COMMENTS-2.                                        
               10  F                    PIC X(17) VALUE                 
                  'LAST DRAFT DATE: '.                                  
               10  WS-WQ-LAST-DRAFT-DT  PIC X(10) VALUE SPACES.         
               10  F                    PIC X(22) VALUE                 
                  '; PENDING DRAFT DATE: '.                             
               10  WS-WQ-PEND-DRAFT-DT  PIC X(10) VALUE SPACES.         
               10  F                    PIC X(23) VALUE                 
                  '; CURRENT DRAFT CYCLE: '.                            
               10  WS-WQ-CURR-DRAFT-CY  PIC X(02) VALUE SPACES.         
               10  F                    PIC X(23) VALUE                 
                  '; PREVIOUS BILL CYCLE: '.                            
               10  WS-WQ-PREV-BILL-CY   PIC X(02) VALUE SPACES.         
               10  F                    PIC X(30) VALUE                 
                  '; THE BILL CYCLE HAS CHANGED. '.                     
               10  F                    PIC X(31) VALUE                 
                  'PLEASE REVIEW DRAFT CYCLE(ACCT)'.                    
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
       01  CSR00125-CALL-DATA.                                          
           05  ACCOUNT-NO-0125           PIC X(13) VALUE SPACES.        
           05  PREMISE-NO-0125           PIC X(10) VALUE SPACES.        
           05  USER-ID-0125              PIC X(07) VALUE SPACES.        
           05  REMARKS-0125.                                            
               49 REMARKS-0125-LEN       PIC S9(4) USAGE COMP VALUE +45.
               49 REMARKS-0125-TEXT      PIC X(45) VALUE                
               'SYSTEM GENERATED CANCEL DUE TO FIA SET UP.'.            
           05  UPDATE-REMARKS-0125       PIC X(01) VALUE 'Y'.           
           05  SELECT-UPDATE-FL-0125     PIC X(01) VALUE SPACES.        
           05  PANEL-NO-0125             PIC X(04) VALUE '085'.         
           05  ORDER-TYPE-FL-0125        PIC X(01) VALUE 'A'.           
           05  CANCEL-REASON-0125        PIC X(01) VALUE 'R'.           
                                                                        
       01  CSR00125-RETURN-DATA.                                        
           05  RETURN-CODE-0125          PIC S9(9) COMP VALUE 0.        
           05  SERV-ORDER-NO-0125        PIC X(13) VALUE SPACES.        
           05  ORDER-REASON-0125         PIC X(01) VALUE SPACES.        
           05  RESP-AREA-0125            PIC X(03) VALUE SPACES.        
           05  PENDING-SO-FL-0125        PIC X(01) VALUE SPACES.        
           05  INSERT-WQ-FL-0125         PIC X(01) VALUE SPACES.        
           05  AMOUNT-DISC-BAL-0125      PIC X(11) VALUE SPACES.        
           05  ORDER-TYPE-CD-0125        PIC X(05) VALUE SPACES.        
                                                                        
       01  CSR02122-CALL-DATA.                                          
           05  ACCOUNT-NO-2122           PIC X(13) VALUE SPACES.        
           05  PREMISE-NO-2122           PIC X(10) VALUE SPACES.        
           05  ORDER-REASON-2122         PIC X(02) VALUE SPACES.        
           05  CANCEL-REASON-2122        PIC X(01) VALUE 'R'.           
           05  PENDING-SO-FL-2122        PIC X(01) VALUE SPACES.        
           05  UPDATE-PROFILE-2122       PIC X(01) VALUE SPACES.        
           05  AMOUNT-DISC-BAL-2122      PIC X(11) VALUE SPACES.        
           05  PANEL-NO-2122             PIC X(04) VALUE '085'.         
           05  ORDER-TYPE-CD-2122        PIC X(05) VALUE SPACES.        
           05  REMARKS-2122.                                            
               49 REMARKS-2122-LEN       PIC S9(4) USAGE COMP VALUE +0. 
               49 REMARKS-2122-TEXT      PIC X(45) VALUE SPACES.        
                                                                        
       01  CSR02122-RETURN-DATA.                                        
           05  RETURN-CODE-2122          PIC S9(9) COMP VALUE 0.        
                                                                        
       01  CSR01334-CALL-DATA.                                          
           05  SERV-ORDER-NO-1334        PIC X(13) VALUE SPACES.        
           05  PRINT-DEST-1334           PIC X(15) VALUE SPACES.        
           05  PRINT-DEST-IND-1334       PIC X(02) VALUE 'N'.           
           05  USER-ID-1334              PIC X(07) VALUE SPACES.        
           05  CAD-TRAN-TYPE-1334        PIC X(01) VALUE 'C'.           
                                                                        
       01  CSR01334-RETURN-DATA.                                        
           05  RETURN-CODE-1334          PIC S9(9) COMP VALUE 0.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0125 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2122 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1334 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0125 CURSOR
MSQ001          FOR CALL CSR00125                                             
                  ( :ACCOUNT-NO-0125
                  , :PREMISE-NO-0125
                  , :USER-ID-0125
                  , :REMARKS-0125
                  , :UPDATE-REMARKS-0125
                  , :SELECT-UPDATE-FL-0125
                  , :PANEL-NO-0125
                  , :ORDER-TYPE-FL-0125
                  , :CANCEL-REASON-0125
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2122 CURSOR
MSQ001          FOR CALL CSR02122                                             
                  ( :ACCOUNT-NO-2122
                  , :PREMISE-NO-2122
                  , :ORDER-REASON-2122
                  , :CANCEL-REASON-2122
                  , :PENDING-SO-FL-2122
                  , :UPDATE-PROFILE-2122
                  , :AMOUNT-DISC-BAL-2122
                  , :PANEL-NO-2122
                  , :ORDER-TYPE-CD-2122
                  , :REMARKS-2122
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1334 CURSOR
MSQ001          FOR CALL CSR01334                                             
                  ( :SERV-ORDER-NO-1334
                  , :PRINT-DEST-1334
                  , :PRINT-DEST-IND-1334
                  , :USER-ID-1334
                  , :CAD-TRAN-TYPE-1334
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-BILL-CYCLE          PIC X(02).                          
       01  LINK-CYCLE-CHG-CD        PIC X(01).                          
       01  LINK-NO-BILL-COPIES      PIC S9(4) COMP.                     
       01  LINK-PRINT-TYPE-CD       PIC X(01).                          
       01  LINK-CODE-BILL-FREQ      PIC X(03).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO,                                        
                LINK-BILL-CYCLE,                                        
                LINK-CYCLE-CHG-CD,                                      
                LINK-NO-BILL-COPIES,                                    
                LINK-PRINT-TYPE-CD,                                     
                LINK-CODE-BILL-FREQ,                                    
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           EVALUATE LINK-BILL-CYCLE                                     
               WHEN '1 '                                                
                   MOVE '01' TO LINK-BILL-CYCLE                         
               WHEN '2 '                                                
                   MOVE '02' TO LINK-BILL-CYCLE                         
               WHEN '3 '                                                
                   MOVE '03' TO LINK-BILL-CYCLE                         
               WHEN '4 '                                                
                   MOVE '04' TO LINK-BILL-CYCLE                         
               WHEN '5 '                                                
                   MOVE '05' TO LINK-BILL-CYCLE                         
               WHEN '6 '                                                
                   MOVE '06' TO LINK-BILL-CYCLE                         
               WHEN '7 '                                                
                   MOVE '07' TO LINK-BILL-CYCLE                         
               WHEN '8 '                                                
                   MOVE '08' TO LINK-BILL-CYCLE                         
               WHEN '9 '                                                
                   MOVE '09' TO LINK-BILL-CYCLE                         
           END-EVALUATE.                                                
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-PREMISE-NO               
                                            MH-CUSTOMER-NO.             
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 'PANEL085'               TO MH-APPL-PROGRAM-ID.         
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7030-READ-CYCLE THRU 7030-EXIT.                      
                                                                        
           IF LINK-CYCLE-CHG-CD = 'D' OR                                
             (LINK-CYCLE-CHG-CD = 'C' AND                               
              AT-BILL-CYCLE-CHG-CD = 'F')                               
                  MOVE UT-READ-CYCLE TO LINK-BILL-CYCLE
           END-IF.                
                                                                        
           MOVE 'NO' TO WS-ACCT-CHANGED-FLAG                            
                        WS-BCYC-CHANGED-FLAG                            
                        WS-REAS-CHANGED-FLAG.                           
                                                                        
           IF AT-BILL-CYCLE NOT = LINK-BILL-CYCLE                       
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
                             WS-BCYC-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-BILL-CYCLE > SPACES                              
                   MOVE +2 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-BILL-CYCLE TO MI-CHG-COLUMN-VALUE-TEXT     
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-BILL-CYCLE > SPACES                                
                   MOVE +2 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-BILL-CYCLE TO MI-PRV-COLUMN-VALUE-TEXT       
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL CYCLE' TO MI-COLUMN-DESC                      
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF AT-BILL-CYCLE-CHG-CD NOT = LINK-CYCLE-CHG-CD              
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
                             WS-REAS-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-CYCLE-CHG-CD > SPACES                            
                   MOVE +2 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-CYCLE-CHG-CD TO MI-CHG-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-BILL-CYCLE-CHG-CD > SPACES                         
                   MOVE +2 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-BILL-CYCLE-CHG-CD TO                         
                        MI-PRV-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'CYCLE CHG CD' TO MI-COLUMN-DESC                    
               MOVE '08' TO MI-TABLE-ID                                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO                                 
               MOVE SPACES TO MI-TABLE-ID
           END-IF.                              
                                                                        
           IF AT-NO-BILL-COPIES NOT = LINK-NO-BILL-COPIES               
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NO-BILL-COPIES > ZEROES                          
                   MOVE +4 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-NO-BILL-COPIES TO WS-DISPLAY-COPIES        
                   MOVE WS-DISPLAY-COPIES TO MI-CHG-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-NO-BILL-COPIES > ZEROES                            
                   MOVE +4 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-NO-BILL-COPIES TO WS-DISPLAY-COPIES          
                   MOVE WS-DISPLAY-COPIES TO MI-PRV-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL COPIES' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF AT-PRINT-TYPE-CD NOT = LINK-PRINT-TYPE-CD                 
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-PRINT-TYPE-CD > SPACES                           
                   MOVE +1 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-PRINT-TYPE-CD TO MI-CHG-COLUMN-VALUE-TEXT  
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-PRINT-TYPE-CD > SPACES                             
                   MOVE +1 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-PRINT-TYPE-CD TO MI-PRV-COLUMN-VALUE-TEXT    
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE '10' TO MI-TABLE-ID                                 
               MOVE 'PRINT TYPE' TO MI-COLUMN-DESC                      
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO                                 
               MOVE SPACES TO MI-TABLE-ID
           END-IF.                              
                                                                        
           IF AT-CODE-BILL-FREQ NOT = LINK-CODE-BILL-FREQ               
               MOVE 'YES' TO WS-ACCT-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-CODE-BILL-FREQ > SPACES                          
                   MOVE +3 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-CODE-BILL-FREQ TO MI-CHG-COLUMN-VALUE-TEXT 
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AT-CODE-BILL-FREQ > SPACES                            
                   MOVE +3 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE AT-CODE-BILL-FREQ TO MI-PRV-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE '09' TO MI-TABLE-ID                                 
               MOVE 'BILL FREQ' TO MI-COLUMN-DESC                       
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO                                 
               MOVE SPACES TO MI-TABLE-ID
           END-IF.                              
                                                                        
           IF BCYC-CHANGED                                              
               MOVE AT-BILL-CYCLE TO AT-PREV-BILL-CYCLE                 
               PERFORM 2200-UPDATE-PRORATE-CD THRU 2200-EXIT            
               PERFORM 2300-CALC-DRAFT-CYCLE THRU 2300-EXIT
           END-IF.            
                                                                        
           IF REAS-CHANGED                                              
               IF LINK-CYCLE-CHG-CD = 'C' AND                           
                  AT-BILL-CYCLE-CHG-CD = 'F' AND                        
                  AT-CODE-DISC-OK > ' ' AND                             
                  AT-CODE-DISC-OK NOT = 'L'                             
                      MOVE SPACES TO AT-CODE-DISC-OK                    
               END-IF                                                   
               IF LINK-CYCLE-CHG-CD = 'F'                               
                   IF AT-CODE-LPC-XMT = ' '                             
                       MOVE '1' TO AT-CODE-LPC-XMT                      
                   END-IF                                               
                   IF AT-CODE-DISC-OK = ' '                             
                       MOVE '1' TO AT-CODE-DISC-OK                      
                   END-IF                                               
                   PERFORM 7070-DNP THRU 7070-EXIT                      
                   IF VO-PREMISE-NO > 0                                 
                       PERFORM 2400-CANCEL-DNP THRU 2400-EXIT
                   END-IF
               END-IF
           END-IF.          
                                                                        
           IF ACCT-CHANGED                                              
               MOVE LINK-BILL-CYCLE TO AT-BILL-CYCLE                    
               IF LINK-CYCLE-CHG-CD = 'D'                               
                   MOVE SPACES TO AT-BILL-CYCLE-CHG-CD                  
               ELSE                                                     
                   MOVE LINK-CYCLE-CHG-CD TO AT-BILL-CYCLE-CHG-CD       
               END-IF                                                   
               MOVE LINK-NO-BILL-COPIES TO AT-NO-BILL-COPIES            
               MOVE LINK-PRINT-TYPE-CD TO AT-PRINT-TYPE-CD              
               MOVE LINK-CODE-BILL-FREQ TO AT-CODE-BILL-FREQ            
               PERFORM 8350-UPDATE-ACCOUNT THRU 8350-EXIT
           END-IF.              
                                                                        
           IF WS-GENERATE-WQ-FL = 'Y'                                   
               MOVE BE-LAST-DRAFT-DATE TO WS-WQ-LAST-DRAFT-DT           
               MOVE PB-DRAFT-DATE TO WS-WQ-PEND-DRAFT-DT                
               MOVE BE-DRAFT-CYCLE TO WS-WQ-CURR-DRAFT-CY               
               MOVE AT-BILL-CYCLE TO WS-WQ-PREV-BILL-CY                 
ACT233         MOVE WS-WQ-COMMENTS-2 TO COMMENTS-4675-TEXT              
ACT233         MOVE 175 TO COMMENTS-4675-LEN                            
ACT233         MOVE '4' TO ROUTING-CATEGORY-4675                        
ACT233         MOVE 12 TO CATEGORY-ID-4675                              
ACT233         MOVE ZEROES TO SERV-ORDER-NO-4675                        
ACT233         MOVE 'N' TO WQ-PRIORITY-4675                             
ACT233         MOVE SPACES TO LOCAL-OFFICE-4675                         
ACT233                        RESP-AREA-ID-4675                         
ACT233         PERFORM 4000-CALL-CSR04675 THRU 4000-EXIT
           END-IF.               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-UPDATE-PRORATE-CD.                                          
                                                                        
           PERFORM 7040-FUTURE-BILL THRU 7040-EXIT.                     
           IF BI-BILL-NO > 0                                            
               PERFORM 8360-UPDATE-BILL-DETAIL THRU 8360-EXIT
           END-IF.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-CALC-DRAFT-CYCLE.                                           
                                                                        
           PERFORM 7050-BANK-EFT THRU 7050-EXIT.                        
           PERFORM 7060-PENDING-DRAFT THRU 7060-EXIT.                   
           IF WS-EFT-FL = 'N' OR                                        
             (BE-STATUS-CODE = 'E' OR 'D')                              
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE LINK-BILL-CYCLE TO WS-BILL-CYCLE-NUM                
               IF BE-REQSTED-DRAFT-DAY <= SPACES                        
                   PERFORM 2310-CYCLE-PLUS-5 THRU 2310-EXIT             
                   MOVE WS-BILL-CYCLE-PLUS-5 TO WS-NEW-DRAFT-CYCLE      
               ELSE                                                     
                   PERFORM 2310-CYCLE-PLUS-5 THRU 2310-EXIT             
                   PERFORM 2320-CYCLE-MINUS-2 THRU 2320-EXIT            
                   IF ((BE-DRAFT-CYCLE >= WS-BILL-CYCLE-PLUS-5 AND      
                        BE-DRAFT-CYCLE <= WS-BILL-CYCLE-MINUS-2) AND    
                        WS-BILL-CYCLE-PLUS-5 < WS-BILL-CYCLE-MINUS-2) OR
                      ((BE-DRAFT-CYCLE >= WS-BILL-CYCLE-PLUS-5 OR       
                        BE-DRAFT-CYCLE <= WS-BILL-CYCLE-MINUS-2) AND    
                        WS-BILL-CYCLE-PLUS-5 > WS-BILL-CYCLE-MINUS-2)   
                            MOVE BE-DRAFT-CYCLE TO WS-NEW-DRAFT-CYCLE   
                   ELSE                                                 
                       IF WS-BILL-CYCLE-PLUS-5 > BE-DRAFT-CYCLE         
                           MOVE WS-BILL-CYCLE-PLUS-5 TO                 
                                WS-NEW-DRAFT-CYCLE                      
                       ELSE                                             
                           MOVE WS-BILL-CYCLE-PLUS-5 TO                 
                                WS-NEW-DRAFT-CYCLE                      
                           MOVE 'C' TO BE-STATUS-CODE                   
                           PERFORM 8370-UPDATE-EFT-STATUS THRU 8370-EXIT
                           MOVE 'Y' TO WS-GENERATE-WQ-FL                
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
               MOVE WS-NEW-DRAFT-CYCLE TO WS-NEW-DRAFT-CYCLE-C          
               IF BE-DRAFT-CYCLE NOT = WS-NEW-DRAFT-CYCLE-C             
                   PERFORM 8380-UPDATE-EFT THRU 8380-EXIT               
                   MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO              
                   MOVE +2 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE WS-NEW-DRAFT-CYCLE-C TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE +2 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE BE-DRAFT-CYCLE TO MI-PRV-COLUMN-VALUE-TEXT      
                   MOVE 'DRAFT CYCLE' TO MI-COLUMN-DESC                 
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1 TO WS-TRAN-APPL-NO
               END-IF
           END-IF.                            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-CYCLE-PLUS-5.                                               
                                                                        
           COMPUTE WS-BILL-CYCLE-PLUS-5 = WS-BILL-CYCLE-NUM + 5.        
           IF WS-BILL-CYCLE-PLUS-5 > 20                                 
               COMPUTE WS-BILL-CYCLE-PLUS-5 =                           
                       WS-BILL-CYCLE-PLUS-5 - 20
           END-IF.                       
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2320-CYCLE-MINUS-2.                                              
                                                                        
           IF WS-BILL-CYCLE-NUM > 2                                     
               COMPUTE WS-BILL-CYCLE-MINUS-2 = WS-BILL-CYCLE-NUM - 2    
           ELSE                                                         
               COMPUTE WS-BILL-CYCLE-MINUS-2 = WS-BILL-CYCLE-NUM + 18
           END-IF.  
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-CANCEL-DNP.                                                 
                                                                        
           MOVE 'S' TO SELECT-UPDATE-FL-0125.                           
           PERFORM 4100-CALL-CSR00125 THRU 4100-EXIT.                   
           PERFORM 7090-GET-ORDER-DATA THRU 7090-EXIT.                  
           IF INSERT-WQ-FL-0125 = 'Y'                                   
               PERFORM 7100-GET-CREW THRU 7100-EXIT                     
               IF TE-CREW-ID <= SPACES                                  
                   STRING 'DNP ORDER CANCELLED, '                       
                          'DNP WORK AREA WAS '                          
                          I2-WORK-AREA-TX                               
                          DELIMITED BY SIZE                             
ACT233                    INTO COMMENTS-4675-TEXT                       
                   END-STRING                                           
ACT233             MOVE 80 TO COMMENTS-4675-LEN                         
               ELSE                                                     
                   STRING 'DNP ORDER CANCELLED, '                       
                          'DNP CREW ID WAS '                            
                          TE-CREW-ID                                    
                          DELIMITED BY SIZE                             
ACT233                    INTO COMMENTS-4675-TEXT                       
                   END-STRING                                           
ACT233             MOVE 50 TO COMMENTS-4675-LEN                         
               END-IF                                                   
ACT233         MOVE '1' TO ROUTING-CATEGORY-4675                        
ACT233         MOVE 31 TO CATEGORY-ID-4675                              
ACT233         MOVE VO-SERV-ORDER-NO TO SERV-ORDER-NO-4675              
ACT233         MOVE 'H' TO WQ-PRIORITY-4675                             
ACT233         MOVE VO-LOCAL-OFFICE TO LOCAL-OFFICE-4675                
ACT233         MOVE RESP-AREA-0125 TO RESP-AREA-ID-4675                 
               IF WS-PAYMENT-FL = 'Y'                                   
ACT233             MOVE 160 TO CATEGORY-ID-4675                         
ACT233             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT233             MOVE 90 TO COMMENTS-4675-LEN                         
               END-IF                                                   
ACT233         PERFORM 4000-CALL-CSR04675 THRU 4000-EXIT
           END-IF.               
                                                                        
           IF WS-PAYMENT-FL = 'Y'                                       
               GO TO 2400-EXIT
           END-IF.                                         
                                                                        
           MOVE 'U' TO SELECT-UPDATE-FL-0125.                           
           PERFORM 4100-CALL-CSR00125 THRU 4100-EXIT.                   
                                                                        
           PERFORM 4200-CALL-CSR02122 THRU 4200-EXIT.                   
                                                                        
           IF VO-PRINTED-IND = 'Y' AND                                  
              INSERT-WQ-FL-0125 = 'Y'                                   
                  PERFORM 4300-CALL-CSR01334 THRU 4300-EXIT
           END-IF.            
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT233 4000-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE AT-CUSTOMER-NO TO CUSTOMER-NO-4675.                     
ACT233     MOVE AT-PREMISE-NO TO PREMISE-NO-4675.                       
ACT233     MOVE AT-ACCOUNT-NO TO ACCOUNT-NO-4675.                       
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT233     MOVE LINK-USERID TO USER-ID-ORIG-4675.                       
ACT233     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT233                    DATE-REQUIRED-4675                            
ACT233                    DATE-CREATED-4675                             
ACT233                    FREE-FORM-DATA-4675-TEXT.                     
ACT233     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT233     MOVE 'CSR04711' TO CREATED-BY-4675.                          
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
ACT233        MOVE CUSTOMER-NO-4675      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4000'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1        
ACT233                 MOVE CUSTOMER-NO-4675  TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
ACT233             MOVE CUSTOMER-NO-4675      TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4100-CALL-CSR00125.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-0125.                     
           MOVE WS-PREMISE-NO-CHAR TO PREMISE-NO-0125.                  
           MOVE LINK-USERID TO USER-ID-0125.                            
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00125                                             
      *           (:ACCOUNT-NO-0125,                                    
      *            :PREMISE-NO-0125,                                    
      *            :USER-ID-0125,                                       
      *            :REMARKS-0125,                                       
      *            :UPDATE-REMARKS-0125,                                
      *            :SELECT-UPDATE-FL-0125,                              
      *            :PANEL-NO-0125,                                      
      *            :ORDER-TYPE-FL-0125,                                 
      *            :CANCEL-REASON-0125)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0125
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0125
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0125 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00125'            TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-0125       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0125)                                                
      *       WITH PROCEDURE CSR00125                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0125 CURSOR FOR RESULT SET        
      *       :LOC0125                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0125 INTO                            
                 :RETURN-CODE-0125,                                     
                 :SERV-ORDER-NO-0125,                                   
                 :ORDER-REASON-0125,                                    
                 :RESP-AREA-0125,                                       
                 :PENDING-SO-FL-0125,                                   
                 :INSERT-WQ-FL-0125,                                    
                 :AMOUNT-DISC-BAL-0125,                                 
                 :ORDER-TYPE-CD-0125                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0125 NOT = 0 AND                      
                      RETURN-CODE-0125 NOT = 100 AND                    
                      RETURN-CODE-0125 NOT = 5000                       
                         MOVE RETURN-CODE-0125  TO WS-ACTIVE-RETURN-CODE
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '4100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR00125'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-0125   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00125'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-0125       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF RETURN-CODE-0125 = 5000                                   
               MOVE 'Y' TO WS-PAYMENT-FL
           END-IF.                               
           IF ORDER-REASON-0125 <= SPACES                               
               MOVE SPACES TO ORDER-REASON-0125
           END-IF.                        
           IF ORDER-TYPE-CD-0125 = 'DNPFB'                              
               MOVE 'N' TO WS-UPDATE-PROFILE-FL                         
           ELSE                                                         
               MOVE 'Y' TO WS-UPDATE-PROFILE-FL
           END-IF.                        
           MOVE SERV-ORDER-NO-0125 TO WS-ORDER-NO-CHAR.                 
           MOVE WS-ORDER-NO-NUM TO VO-SERV-ORDER-NO.                    
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4200-CALL-CSR02122.                                              
                                                                        
           MOVE ACCOUNT-NO-0125 TO ACCOUNT-NO-2122.                     
           MOVE PREMISE-NO-0125 TO PREMISE-NO-2122.                     
           MOVE ORDER-REASON-0125 TO ORDER-REASON-2122.                 
           MOVE PENDING-SO-FL-0125 TO PENDING-SO-FL-2122.               
           MOVE WS-UPDATE-PROFILE-FL TO UPDATE-PROFILE-2122.            
           MOVE AMOUNT-DISC-BAL-0125 TO AMOUNT-DISC-BAL-2122.           
           MOVE ORDER-TYPE-CD-0125 TO ORDER-TYPE-CD-2122.               
           MOVE REMARKS-0125 TO REMARKS-2122.                           
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02122                                             
      *           (:ACCOUNT-NO-2122,                                    
      *            :PREMISE-NO-2122,                                    
      *            :ORDER-REASON-2122,                                  
      *            :CANCEL-REASON-2122,                                 
      *            :PENDING-SO-FL-2122,                                 
      *            :UPDATE-PROFILE-2122,                                
      *            :AMOUNT-DISC-BAL-2122,                               
      *            :PANEL-NO-2122,                                      
      *            :ORDER-TYPE-CD-2122,                                 
      *            :REMARKS-2122)                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2122
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2122
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2122 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02122'            TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2122       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2122)                                                
      *       WITH PROCEDURE CSR02122                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2122 CURSOR FOR RESULT SET        
      *       :LOC2122                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2122 INTO                            
                 :RETURN-CODE-0125                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2122 NOT = 0                          
                       MOVE RETURN-CODE-2122  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4200'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02122'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2122   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02122'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2122       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4300-CALL-CSR01334.                                              
                                                                        
           MOVE SERV-ORDER-NO-0125 TO SERV-ORDER-NO-1334.               
           MOVE LINK-USERID TO USER-ID-1334.                            
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01334                                             
      *           (:SERV-ORDER-NO-1334,                                 
      *            :PRINT-DEST-1334,                                    
      *            :PRINT-DEST-IND-1334,                                
      *            :USER-ID-1334,                                       
      *            :CAD-TRAN-TYPE-1334)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1334
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1334
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1334 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01334'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-1334    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1334)                                                
      *       WITH PROCEDURE CSR01334                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1334 CURSOR FOR RESULT SET        
      *       :LOC1334                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1334 INTO                            
                 :RETURN-CODE-1334                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1334 NOT = 0                          
                       MOVE RETURN-CODE-1334  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4300'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01334'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-1334 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01334'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-1334    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) BILL_CYCLE,
              BILL_CYCLE_CHG_CD,
              NO_BILL_COPIES,
              PRINT_TYPE_CD,
              CODE_BILL_FREQ,
              CODE_ACCT_BILLED,
              CUSTOMER_NO,
              PREMISE_NO,
              PREV_BILL_CYCLE,
              CODE_DISC_OK,
              CODE_LPC_XMT                                       
                INTO :AT-BILL-CYCLE,                                    
                     :AT-BILL-CYCLE-CHG-CD,                             
                     :AT-NO-BILL-COPIES,                                
                     :AT-PRINT-TYPE-CD,                                 
                     :AT-CODE-BILL-FREQ,                                
                     :AT-CODE-ACCT-BILLED,                              
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-PREV-BILL-CYCLE,                               
                     :AT-CODE-DISC-OK,                                  
                     :AT-CODE-LPC-XMT                                   
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_CYCLE,                                                
MFA-TR*              BILL_CYCLE_CHG_CD,                                         
MFA-TR*              NO_BILL_COPIES,                                            
MFA-TR*              PRINT_TYPE_CD,                                             
MFA-TR*              CODE_BILL_FREQ,                                            
MFA-TR*              CODE_ACCT_BILLED,                                          
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              PREV_BILL_CYCLE,                                           
MFA-TR*              CODE_DISC_OK,                                              
MFA-TR*              CODE_LPC_XMT                                               
MFA-TR*         INTO :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-BILL-CYCLE-CHG-CD,                                     
MFA-TR*              :AT-NO-BILL-COPIES,                                        
MFA-TR*              :AT-PRINT-TYPE-CD,                                         
MFA-TR*              :AT-CODE-BILL-FREQ,                                        
MFA-TR*              :AT-CODE-ACCT-BILLED,                                      
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-PREV-BILL-CYCLE,                                       
MFA-TR*              :AT-CODE-DISC-OK,                                          
MFA-TR*              :AT-CODE-LPC-XMT                                           
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-PREMISE-NO TO WS-PREMISE-NO-NUM              
                   MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-READ-CYCLE.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT MIN(READ_CYCLE)                                    
                INTO :UT-READ-CYCLE :WS-NULL-1                           
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(READ_CYCLE)                                            
MFA-TR*         INTO :UT-READ-CYCLE:WS-NULL-1                                   
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE LINK-BILL-CYCLE TO UT-READ-CYCLE            
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7030'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-FUTURE-BILL.                                                
                                                                        
           EXEC SQL                                                     
              SELECT MAX(BILL_NO)                                       
                INTO :BI-BILL-NO :WS-NULL-2                              
                FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND DATE_BILLED IS NULL                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BILL_NO)                                               
MFA-TR*         INTO :BI-BILL-NO:WS-NULL-2                                      
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND DATE_BILLED IS NULL                                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE ZEROES TO BI-BILL-NO                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  BI-BILL-NO                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7040'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_BILLING_HDR' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-BANK-EFT.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) STATUS_CODE,
              REQSTED_DRAFT_DAY,
              DRAFT_CYCLE,
              LAST_DRAFT_DATE                                   
                 INTO :BE-STATUS-CODE,                                  
                      :BE-REQSTED-DRAFT-DAY,                            
                      :BE-DRAFT-CYCLE,                                  
                      :BE-LAST-DRAFT-DATE :WS-NULL-3                     
                 FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND STATUS_CODE NOT IN ('M', 'N', 'O')                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT STATUS_CODE,                                              
MFA-TR*               REQSTED_DRAFT_DAY,                                        
MFA-TR*               DRAFT_CYCLE,                                              
MFA-TR*               LAST_DRAFT_DATE                                           
MFA-TR*          INTO :BE-STATUS-CODE,                                          
MFA-TR*               :BE-REQSTED-DRAFT-DAY,                                    
MFA-TR*               :BE-DRAFT-CYCLE,                                          
MFA-TR*               :BE-LAST-DRAFT-DATE:WS-NULL-3                             
MFA-TR*          FROM CSS_BANK_EFT                                              
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND STATUS_CODE NOT IN ('M', 'N', 'O')                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO BE-LAST-DRAFT-DATE                
                   END-IF                                               
                   MOVE 'Y' TO WS-EFT-FL                                
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-EFT-FL                                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7050'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_BANK_EFT'    TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-PENDING-DRAFT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DRAFT_DATE                                         
                INTO :PB-DRAFT-DATE :WS-NULL-4                           
              FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
              ORDER BY DRAFT_DATE DESC                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DRAFT_DATE                                                 
MFA-TR*         INTO :PB-DRAFT-DATE:WS-NULL-4                                   
MFA-TR*       FROM CSS_PNDNG_BNK_DRFT                                           
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       ORDER BY DRAFT_DATE DESC                                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-PENDING-DRAFT-FL                      
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO PB-DRAFT-DATE                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-PENDING-DRAFT-FL                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7060'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-DNP.                                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                         
                INTO :VO-PREMISE-NO                                     
              FROM CSS_SO_DATA WITH(READUNCOMMITTED)                            
              WHERE PREMISE_NO = :AT-PREMISE-NO                         
                AND ORDER_TYPE_CD = 'DNP01'                             
                AND ORDER_STATE_CD = 'A'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO                                                 
MFA-TR*         INTO :VO-PREMISE-NO                                             
MFA-TR*       FROM CSS_SO_DATA                                                  
MFA-TR*       WHERE PREMISE_NO = :AT-PREMISE-NO                                 
MFA-TR*         AND ORDER_TYPE_CD = 'DNP01'                                     
MFA-TR*         AND ORDER_STATE_CD = 'A'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  VO-PREMISE-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7070'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SO_DATA'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-GET-ORDER-DATA.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) VO.LOCAL_OFFICE,
              WORK_AREA_TX,
              PRINTED_IND                                        
                INTO :VO-LOCAL-OFFICE,                                  
                     :I2-WORK-AREA-TX,                                  
                     :VO-PRINTED-IND                                    
              FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                        
                   CSS_WORK_AREA I2 WITH(READUNCOMMITTED)                       
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
                AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT VO.LOCAL_OFFICE,                                           
MFA-TR*              WORK_AREA_TX,                                              
MFA-TR*              PRINTED_IND                                                
MFA-TR*         INTO :VO-LOCAL-OFFICE,                                          
MFA-TR*              :I2-WORK-AREA-TX,                                          
MFA-TR*              :VO-PRINTED-IND                                            
MFA-TR*       FROM CSS_SO_DATA VO,                                              
MFA-TR*            CSS_WORK_AREA I2                                             
MFA-TR*       WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                           
MFA-TR*         AND VO.WORK_AREA_ID = I2.WORK_AREA_ID                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO VO-LOCAL-OFFICE                       
                                  I2-WORK-AREA-TX                       
                                  VO-PRINTED-IND                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7090'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SO_DATA'     TO TABLE-1                    
                   MOVE 'CSS_WORK_AREA'   TO TABLE-2                    
                   MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1            
                   MOVE VO-SERV-ORDER-NO  TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-CREW.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CREW_ID                                            
                INTO :TE-CREW-ID                                        
              FROM CSS_SO_CREW WITH(READUNCOMMITTED)                            
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CREW_ID                                                    
MFA-TR*         INTO :TE-CREW-ID                                                
MFA-TR*       FROM CSS_SO_CREW                                                  
MFA-TR*       WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO TE-CREW-ID                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7100'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_SO_CREW'     TO TABLE-1                    
                   MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1            
                   MOVE VO-SERV-ORDER-NO  TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8350-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET BILL_CYCLE = :AT-BILL-CYCLE,                       
                     BILL_CYCLE_CHG_CD = :AT-BILL-CYCLE-CHG-CD,         
                     NO_BILL_COPIES = :AT-NO-BILL-COPIES,               
                     PRINT_TYPE_CD = :AT-PRINT-TYPE-CD,                 
                     CODE_BILL_FREQ = :AT-CODE-BILL-FREQ,               
                     PREV_BILL_CYCLE = :AT-PREV-BILL-CYCLE,             
                     CODE_DISC_OK = :AT-CODE-DISC-OK,                   
                     CODE_LPC_XMT = :AT-CODE-LPC-XMT                    
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET BILL_CYCLE = :AT-BILL-CYCLE,                               
MFA-TR*              BILL_CYCLE_CHG_CD = :AT-BILL-CYCLE-CHG-CD,                 
MFA-TR*              NO_BILL_COPIES = :AT-NO-BILL-COPIES,                       
MFA-TR*              PRINT_TYPE_CD = :AT-PRINT-TYPE-CD,                         
MFA-TR*              CODE_BILL_FREQ = :AT-CODE-BILL-FREQ,                       
MFA-TR*              PREV_BILL_CYCLE = :AT-PREV-BILL-CYCLE,                     
MFA-TR*              CODE_DISC_OK = :AT-CODE-DISC-OK,                           
MFA-TR*              CODE_LPC_XMT = :AT-CODE-LPC-XMT                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8350'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-BILL-DETAIL.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_BILLING_DET                                    
                 SET PRORATE_CD         = 'C'                           
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND BILL_NO            = :BI-BILL-NO                   
                 AND CODE_BILL_CALC     = 'A'                           
                 AND CODE_BILL_ITM_TYPE = 'C'                           
                 AND CODE_BILL_ITM_IND  = 'A'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILLING_DET                                            
MFA-TR*          SET PRORATE_CD         = 'C'                                   
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :BI-BILL-NO                           
MFA-TR*          AND CODE_BILL_CALC     = 'A'                                   
MFA-TR*          AND CODE_BILL_ITM_TYPE = 'C'                                   
MFA-TR*          AND CODE_BILL_ITM_IND  = 'A'                                   
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8360'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_NO'             TO TABLE-ELEMENT-2             
              MOVE BI-BILL-NO            TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8370-UPDATE-EFT-STATUS.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BANK_EFT                                      
                  SET STATUS_CODE = 'C'                                 
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BANK_EFT                                              
MFA-TR*           SET STATUS_CODE = 'C'                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8370'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANK_EFT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_NO'             TO TABLE-ELEMENT-2             
              MOVE BI-BILL-NO            TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8380-UPDATE-EFT.                                                 
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BANK_EFT                                      
                  SET DRAFT_CYCLE = :WS-NEW-DRAFT-CYCLE-C,              
                      REQSTED_DRAFT_DAY = ' '                           
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BANK_EFT                                              
MFA-TR*           SET DRAFT_CYCLE = :WS-NEW-DRAFT-CYCLE-C,                      
MFA-TR*               REQSTED_DRAFT_DAY = ' '                                   
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       QUERYNO 8380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8380'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANK_EFT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_NO'             TO TABLE-ELEMENT-2             
              MOVE BI-BILL-NO            TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
