       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04710.                                         
COB303 DATE-WRITTEN.  MAY 14, 2014.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES DBA INFO FOR AN ACCOUNT.                 *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  05/14/14   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04710'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     01050000
              INCLUDE TBACCT                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBATMISC                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBATBLNM                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBNAME                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBNMACTX                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                             
              INCLUDE TBNAMEID                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04710'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-MISC-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 MISC-EXISTS                     VALUE 'YES'.          
           05  WS-DBAN-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 DBAN-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-MISC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 MISC-CHANGED                    VALUE 'YES'.          
           05  WS-ACCT-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ACCT-CHANGED                    VALUE 'YES'.          
           05  WS-DBAN-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 DBAN-CHANGED                    VALUE 'YES'.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-DBA-NAME            PIC X(70).                          
       01  LINK-WEBSITE-ADDR        PIC X(75).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO,                                        
                LINK-DBA-NAME,                                          
                LINK-WEBSITE-ADDR,                                      
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           INSPECT LINK-DBA-NAME REPLACING ALL '~' BY '-'.              
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-PREMISE-NO               
                                            MH-CUSTOMER-NO.             
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 'PANEL085'               TO MH-APPL-PROGRAM-ID.         
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
                                                                        
           MOVE 'NO' TO WS-MISC-EXISTS-FLAG                             
                        WS-MISC-CHANGED-FLAG.                           
                                                                        
           PERFORM 7030-SELECT-ACCT-MISC THRU 7030-EXIT.                
           IF NOT MISC-EXISTS                                           
               INITIALIZE DCLCSS-ACCT-MISC-INFO
           END-IF.                        
                                                                        
           IF TA-WEBSITE-ADDR NOT = LINK-WEBSITE-ADDR                   
               MOVE 'YES' TO WS-MISC-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-WEBSITE-ADDR > SPACES                            
                   MOVE +75 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-WEBSITE-ADDR TO MI-CHG-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF TA-WEBSITE-ADDR > SPACES                              
                   MOVE +75 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE TA-WEBSITE-ADDR TO MI-PRV-COLUMN-VALUE-TEXT     
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'WEBSITE ADDR' TO MI-COLUMN-DESC                    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF MISC-CHANGED                                              
               MOVE LINK-WEBSITE-ADDR TO TA-WEBSITE-ADDR                
               IF MISC-EXISTS                                           
                   PERFORM 8340-UPDATE-MISC THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-MISC THRU 8190-EXIT         
               ELSE                                                     
                   PERFORM 8050-INSERT-MISC THRU 8050-EXIT
               END-IF
           END-IF.             
                                                                        
           PERFORM 7040-SELECT-DBA THRU 7040-EXIT.                      
           IF DBAN-EXISTS                                               
               PERFORM 2200-UPDATE-DBA THRU 2200-EXIT                   
           ELSE                                                         
               IF LINK-DBA-NAME > ' '                                   
                   PERFORM 2100-INSERT-DBA THRU 2100-EXIT
               END-IF
           END-IF.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-INSERT-DBA.                                                 
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
                                                                        
           INITIALIZE DCLCSS-NAME.                                      
           MOVE WS-91-NEW-NAME-ID        TO DQ-NAME-ID.                 
           MOVE 'DB'                     TO DQ-NAME-TYPE.               
           MOVE 'B'                      TO DQ-NAME-FORMAT.             
           MOVE LINK-DBA-NAME            TO DQ-FULL-NAME.               
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           PERFORM 8030-INSERT-NAME THRU 8030-EXIT.                     
                                                                        
           INITIALIZE DCLCSS-NAME-ACCT-XREF.                            
           MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           MOVE AT-COMPANY-NO TO HT-COMPANY-NO.                         
           MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO.                       
           MOVE AT-PREMISE-NO TO HT-PREMISE-NO.                         
           MOVE AT-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE.           
           MOVE AT-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT.                 
           MOVE DQ-NAME-ID TO HT-NAME-ID.                               
           MOVE SPACES TO HT-CUSTOMER-ROLE-CD.                          
           PERFORM 7050-SELECT-ADDRESS THRU 7050-EXIT.                  
           PERFORM 8220-INSERT-NAME-XREF THRU 8220-EXIT.                
                                                                        
           MOVE WS-91-NEW-NAME-ID TO AB-NAME-ID.                        
           PERFORM 8020-INSERT-ACCT-NAME THRU 8020-EXIT.                
                                                                        
           MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
           MOVE +70 TO MI-CHG-COLUMN-VALUE-LEN.                         
           MOVE LINK-DBA-NAME TO MI-CHG-COLUMN-VALUE-TEXT.              
           MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN.                          
           MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT.                    
           MOVE 'DBA NAME' TO MI-COLUMN-DESC.                           
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-UPDATE-DBA.                                                 
                                                                        
           IF DQ-FULL-NAME NOT = LINK-DBA-NAME                          
               MOVE 'YES' TO WS-DBAN-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-DBA-NAME > SPACES                                
                   MOVE +70 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-DBA-NAME TO MI-CHG-COLUMN-VALUE-TEXT       
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-FULL-NAME > SPACES                                 
                   MOVE +70 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-FULL-NAME TO MI-PRV-COLUMN-VALUE-TEXT        
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'DBA NAME' TO MI-COLUMN-DESC                        
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-DBA-NAME > SPACES                                    
               MOVE LINK-DBA-NAME TO DQ-FULL-NAME                       
               PERFORM 8360-UPDATE-DBA THRU 8360-EXIT                   
           ELSE                                                         
               PERFORM 8180-DELETE-DBA THRU 8180-EXIT                   
               PERFORM 8185-DELETE-NAME-ACCT-XREF THRU 8185-EXIT
           END-IF.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              COMPANY_NO,
              ACCOUNT_TYPE_CODE,
              PREMISE_NO,
              CODE_ACCT_STAT                                     
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-PREMISE-NO,                                    
                     :AT-CODE-ACCT-STAT                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              CODE_ACCT_STAT                                             
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-ACCT-MISC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              WEBSITE_ADDR                                       
                INTO :WS-MISC-EXISTS-FLAG,                              
                     :TA-WEBSITE-ADDR                                   
                FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              WEBSITE_ADDR                                               
MFA-TR*         INTO :WS-MISC-EXISTS-FLAG,                                      
MFA-TR*              :TA-WEBSITE-ADDR                                           
MFA-TR*         FROM CSS_ACCT_MISC_INFO                                         
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-DBA.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              FULL_NAME,
              DQ.NAME_ID                                         
                INTO :WS-DBAN-EXISTS-FLAG,                              
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-ID                                        
                FROM CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),               
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND AB.NAME_TYPE = 'DB'                                
                 AND AB.NAME_ID = DQ.NAME_ID                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              DQ.NAME_ID                                                 
MFA-TR*         INTO :WS-DBAN-EXISTS-FLAG,                                      
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-ID                                                
MFA-TR*         FROM CSS_ACCT_BILL_NMES AB,                                     
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND AB.NAME_TYPE = 'DB'                                        
MFA-TR*          AND AB.NAME_ID = DQ.NAME_ID                                    
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT ADDRESS_ID,                              
                      TOWN,                                             
                      STATE,                                            
                      LOCAL_OFFICE                                      
                 INTO :HT-ADDRESS-ID,                                   
                      :HT-TOWN,                                         
                      :HT-STATE,                                        
                      :HT-LOCAL-OFFICE                                  
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                  AND HT.NAME_ID  = DQ.NAME_ID                          
                  AND DQ.NAME_TYPE = 'CN'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT ADDRESS_ID,                                      
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE,                                                    
MFA-TR*               LOCAL_OFFICE                                              
MFA-TR*          INTO :HT-ADDRESS-ID,                                           
MFA-TR*               :HT-TOWN,                                                 
MFA-TR*               :HT-STATE,                                                
MFA-TR*               :HT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*           AND HT.NAME_ID  = DQ.NAME_ID                                  
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-ACCT-NAME.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_BILL_NMES                            
                      (ACCOUNT_NO,                                      
                       NAME_TYPE,                                       
                       NAME_ID)                                         
              VALUES  (:AT-ACCOUNT-NO,                                  
                       'DB',                                            
                       :AB-NAME-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-MISC.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_MISC_INFO                            
                   ( ACCOUNT_NO,                                        
                     WEBSITE_ADDR)                                      
              VALUES                                                    
                   (:AT-ACCOUNT-NO,                                     
                    :TA-WEBSITE-ADDR)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8180-DELETE-DBA.                                                 
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_BILL_NMES                            
               WHERE ACCOUNT_NO =  :AT-ACCOUNT-NO                       
                 AND NAME_TYPE  = 'DB'                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ACCT_BILL_NMES                                    
MFA-TR*        WHERE ACCOUNT_NO =  :AT-ACCOUNT-NO                               
MFA-TR*          AND NAME_TYPE  = 'DB'                                          
MFA-TR*       QUERYNO 8180                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'DB'                 TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8185-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
               WHERE ACCOUNT_NO =  :AT-ACCOUNT-NO                       
                 AND NAME_ID = :DQ-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*        WHERE ACCOUNT_NO =  :AT-ACCOUNT-NO                               
MFA-TR*          AND NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       QUERYNO 8185                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8185'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-2              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8185-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-MISC.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_MISC_INFO                            
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
                 AND EDI_PHONE_NO       = ' '                           
                 AND LOCK_BOX_NO        = ' '                           
                 AND ADDTL_BILL_NAME_TX = ' '                           
                 AND SPCL_BILL_STMNT_TX = ' '                           
                 AND INTERNET_ADDR      = ' '                           
                 AND EDI_ACCT_CD        = ' '                           
                 AND DBA_TAX_ID         = ' '                           
                 AND GROUP_ID           = ' '                           
                 AND SERVICE_CARE_ID    = ' '                           
                 AND WEBSITE_ADDR       = ' '                           
                 AND SEASONAL_FL        = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ACCT_MISC_INFO                                    
MFA-TR*        WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO                       
MFA-TR*          AND EDI_PHONE_NO       = ' '                                   
MFA-TR*          AND LOCK_BOX_NO        = ' '                                   
MFA-TR*          AND ADDTL_BILL_NAME_TX = ' '                                   
MFA-TR*          AND SPCL_BILL_STMNT_TX = ' '                                   
MFA-TR*          AND INTERNET_ADDR      = ' '                                   
MFA-TR*          AND EDI_ACCT_CD        = ' '                                   
MFA-TR*          AND DBA_TAX_ID         = ' '                                   
MFA-TR*          AND GROUP_ID           = ' '                                   
MFA-TR*          AND SERVICE_CARE_ID    = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND SEASONAL_FL        = ' '                                   
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8220-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     PREMISE_NO,                                        
                     CUSTOMER_ROLE_CD,                                  
                     TOWN,                                              
                     STATE,                                             
                     LOCAL_OFFICE,                                      
                     ACCOUNT_TYPE_CODE,                                 
                     CODE_ACCT_STAT)                                    
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-CUSTOMER-ROLE-CD,                               
                    :HT-TOWN,                                           
                    :HT-STATE,                                          
                    :HT-LOCAL-OFFICE,                                   
                    :HT-ACCOUNT-TYPE-CODE,                              
                    :HT-CODE-ACCT-STAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8220'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE HT-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-MISC.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_MISC_INFO                                 
                 SET WEBSITE_ADDR = :TA-WEBSITE-ADDR                    
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_MISC_INFO                                         
MFA-TR*          SET WEBSITE_ADDR = :TA-WEBSITE-ADDR                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8340'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-DBA.                                                 
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET FULL_NAME = :DQ-FULL-NAME                          
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*          SET FULL_NAME = :DQ-FULL-NAME                                  
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8360'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-2             
              MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00091                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
