       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04709.                                         
COB303 DATE-WRITTEN.  APRIL 2, 2014.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES M&P BILL WINDOW NAMES                    *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  04/04/14   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04709'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     01050000
              INCLUDE TBACCT                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBCUST                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBPREM                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBATMISC                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBATBLNM                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBNAME                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBNAMEID                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBNMACTX                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBADRFMT                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBZIPCD                                           01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBBLADRX                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS0091A                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-NAME-ID-CHAR          PIC X(13).                      
           05  WS-NAME-ID-NUM           REDEFINES WS-NAME-ID-CHAR       
                                        PIC 9(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04709'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-MISC-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 MISC-EXISTS                     VALUE 'YES'.          
           05  WS-NBNB-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 NBNB-EXISTS                     VALUE 'YES'.          
           05  WS-AIAA-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 AIAA-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-MISC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 MISC-CHANGED                    VALUE 'YES'.          
           05  WS-NBNB-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NBNB-CHANGED                    VALUE 'YES'.          
           05  WS-AIAA-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 AIAA-CHANGED                    VALUE 'YES'.          
           05  WS-AIAA-DELETE-FL        PIC X(01) VALUE SPACES.         
           05  WS-NBNB-DELETE-FL        PIC X(01) VALUE SPACES.         
           05  WS-NBNB-LINKAGE-FL       PIC X(01) VALUE SPACES.         
           05  WS-AT-NAME-ID            PIC 9(13) VALUE ZEROES.         
           05  WS-NB-NAME-ID            PIC 9(13) VALUE ZEROES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
              DECLARE ACCT-CURSOR CURSOR FOR                            
               SELECT ACCOUNT_NO                                        
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-AT-NAME-ID          PIC X(13).                          
       01  LINK-AT-NAME-TYPE        PIC X(02).                          
       01  LINK-AT-NAME-FORMAT      PIC X(01).                          
       01  LINK-AT-TITLE-PREFIX     PIC X(09).                          
       01  LINK-AT-FIRST-NAME       PIC X(15).                          
       01  LINK-AT-MIDDLE-NAME      PIC X(15).                          
       01  LINK-AT-LAST-NAME        PIC X(40).                          
       01  LINK-AT-TITLE-SUFFIX     PIC X(03).                          
       01  LINK-AT-FULL-NAME        PIC X(70).                          
       01  LINK-NB-NAME-ID          PIC X(13).                          
       01  LINK-NB-NAME-TYPE        PIC X(02).                          
       01  LINK-NB-NAME-FORMAT      PIC X(01).                          
       01  LINK-NB-TITLE-PREFIX     PIC X(09).                          
       01  LINK-NB-FIRST-NAME       PIC X(15).                          
       01  LINK-NB-MIDDLE-NAME      PIC X(15).                          
       01  LINK-NB-LAST-NAME        PIC X(40).                          
       01  LINK-NB-TITLE-SUFFIX     PIC X(03).                          
       01  LINK-NB-FULL-NAME        PIC X(70).                          
       01  LINK-SPECIAL-ID          PIC X(35).                          
       01  LINK-ACCOUNT-UPDATE-CD   PIC X(03).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO,                                        
                LINK-AT-NAME-ID,                                        
                LINK-AT-NAME-TYPE,                                      
                LINK-AT-NAME-FORMAT,                                    
                LINK-AT-TITLE-PREFIX,                                   
                LINK-AT-FIRST-NAME,                                     
                LINK-AT-MIDDLE-NAME,                                    
                LINK-AT-LAST-NAME,                                      
                LINK-AT-TITLE-SUFFIX,                                   
                LINK-AT-FULL-NAME,                                      
                LINK-NB-NAME-ID,                                        
                LINK-NB-NAME-TYPE,                                      
                LINK-NB-NAME-FORMAT,                                    
                LINK-NB-TITLE-PREFIX,                                   
                LINK-NB-FIRST-NAME,                                     
                LINK-NB-MIDDLE-NAME,                                    
                LINK-NB-LAST-NAME,                                      
                LINK-NB-TITLE-SUFFIX,                                   
                LINK-NB-FULL-NAME,                                      
                LINK-SPECIAL-ID,                                        
                LINK-ACCOUNT-UPDATE-CD,                                 
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           IF LINK-AT-NAME-ID <= SPACES                                 
               MOVE ZEROES TO LINK-AT-NAME-ID
           END-IF.                          
           MOVE LINK-AT-NAME-ID TO WS-AT-NAME-ID.                       
           IF LINK-NB-NAME-ID <= SPACES                                 
               MOVE ZEROES TO LINK-NB-NAME-ID
           END-IF.                          
           MOVE LINK-NB-NAME-ID TO WS-NB-NAME-ID.                       
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           EVALUATE LINK-AT-NAME-FORMAT                                 
               WHEN 'I'                                                 
                   MOVE SPACES TO LINK-AT-FULL-NAME                     
               WHEN 'B'                                                 
                   MOVE SPACES TO LINK-AT-TITLE-PREFIX                  
                                  LINK-AT-FIRST-NAME                    
                                  LINK-AT-MIDDLE-NAME                   
                                  LINK-AT-LAST-NAME                     
                                  LINK-AT-TITLE-SUFFIX                  
               WHEN OTHER                                               
                   MOVE SPACES TO LINK-AT-FULL-NAME                     
                                  LINK-AT-TITLE-PREFIX                  
                                  LINK-AT-FIRST-NAME                    
                                  LINK-AT-MIDDLE-NAME                   
                                  LINK-AT-LAST-NAME                     
                                  LINK-AT-TITLE-SUFFIX                  
           END-EVALUATE.                                                
           EVALUATE LINK-NB-NAME-FORMAT                                 
               WHEN 'I'                                                 
                   MOVE SPACES TO LINK-NB-FULL-NAME                     
               WHEN 'B'                                                 
                   MOVE SPACES TO LINK-NB-TITLE-PREFIX                  
                                  LINK-NB-FIRST-NAME                    
                                  LINK-NB-MIDDLE-NAME                   
                                  LINK-NB-LAST-NAME                     
                                  LINK-NB-TITLE-SUFFIX                  
               WHEN OTHER                                               
                   MOVE SPACES TO LINK-NB-FULL-NAME                     
                                  LINK-NB-TITLE-PREFIX                  
                                  LINK-NB-FIRST-NAME                    
                                  LINK-NB-MIDDLE-NAME                   
                                  LINK-NB-LAST-NAME                     
                                  LINK-NB-TITLE-SUFFIX                  
           END-EVALUATE.                                                
                                                                        
           IF LINK-AT-NAME-TYPE > SPACES AND                            
              LINK-AT-TITLE-PREFIX = SPACES AND                         
              LINK-AT-FIRST-NAME = SPACES AND                           
              LINK-AT-MIDDLE-NAME = SPACES AND                          
              LINK-AT-LAST-NAME = SPACES AND                            
              LINK-AT-TITLE-SUFFIX = SPACES AND                         
              LINK-AT-FULL-NAME = SPACES                                
                  MOVE SPACES TO LINK-AT-NAME-FORMAT                    
                  MOVE 'Y' TO WS-AIAA-DELETE-FL
           END-IF.                        
           IF LINK-NB-NAME-TYPE > SPACES AND                            
              LINK-NB-FIRST-NAME = SPACES AND                           
              LINK-NB-MIDDLE-NAME = SPACES AND                          
              LINK-NB-LAST-NAME = SPACES AND                            
              LINK-NB-TITLE-SUFFIX = SPACES AND                         
              LINK-NB-FULL-NAME = SPACES                                
                  MOVE SPACES TO LINK-NB-NAME-FORMAT                    
                  MOVE 'Y' TO WS-NBNB-DELETE-FL
           END-IF.                        
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-PREMISE-NO               
                                            MH-CUSTOMER-NO.             
           MOVE 'PANEL086'               TO MH-APPL-PROGRAM-ID.         
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           EVALUATE LINK-ACCOUNT-UPDATE-CD                              
               WHEN 'ALL'                                               
                   PERFORM 7500-OPEN-ACCT-CURSOR THRU 7500-EXIT         
                   PERFORM 2400-FETCH-ROWS THRU 2400-EXIT               
                   PERFORM 7501-CLOSE-ACCT-CURSOR THRU 7501-EXIT        
               WHEN OTHER                                               
                   PERFORM 2100-NAMES THRU 2100-EXIT                    
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-NAMES.                                                      
                                                                        
           MOVE 'NO' TO WS-MISC-EXISTS-FLAG                             
                        WS-MISC-CHANGED-FLAG                            
                        WS-AIAA-EXISTS-FLAG                             
                        WS-AIAA-CHANGED-FLAG                            
                        WS-NBNB-EXISTS-FLAG                             
                        WS-NBNB-CHANGED-FLAG.                           
                                                                        
           MOVE AT-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7010-SELECT-CUSTOMER THRU 7010-EXIT.                 
           PERFORM 7020-SELECT-PREMISE THRU 7020-EXIT.                  
                                                                        
           PERFORM 7030-SELECT-ACCT-MISC THRU 7030-EXIT.                
           IF NOT MISC-EXISTS                                           
               INITIALIZE DCLCSS-ACCT-MISC-INFO
           END-IF.                        
                                                                        
           IF TA-ADDTL-BILL-NAME-TX NOT = LINK-SPECIAL-ID               
               MOVE 'YES' TO WS-MISC-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-SPECIAL-ID > SPACES                              
                   MOVE +35 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-SPECIAL-ID TO MI-CHG-COLUMN-VALUE-TEXT     
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF TA-ADDTL-BILL-NAME-TX > SPACES                        
                   MOVE +35 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE TA-ADDTL-BILL-NAME-TX TO                        
                        MI-PRV-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'SPECIAL ID' TO MI-COLUMN-DESC                      
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF MISC-CHANGED                                              
               MOVE LINK-SPECIAL-ID TO TA-ADDTL-BILL-NAME-TX            
               IF MISC-EXISTS                                           
                   PERFORM 8340-UPDATE-MISC THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-MISC THRU 8190-EXIT         
               ELSE                                                     
                   PERFORM 8050-INSERT-MISC THRU 8050-EXIT
               END-IF
           END-IF.             
                                                                        
           PERFORM 7040-SELECT-AI-AA-NAME THRU 7040-EXIT.               
           IF AIAA-EXISTS                                               
               MOVE AB-NAME-ID TO DQ-NAME-ID                            
               PERFORM 7070-SELECT-NAME THRU 7070-EXIT                  
           ELSE                                                         
               INITIALIZE DCLCSS-ACCT-BILL-NMES                         
                          DCLCSS-NAME
           END-IF.                                  
                                                                        
           PERFORM 2110-AI-AA-TRANSHIST THRU 2110-EXIT.                 
                                                                        
           IF AIAA-CHANGED                                              
               MOVE LINK-AT-NAME-TYPE TO AB-NAME-TYPE                   
                                         DQ-NAME-TYPE                   
               MOVE LINK-AT-NAME-FORMAT TO DQ-NAME-FORMAT               
               MOVE LINK-AT-TITLE-PREFIX TO DQ-TITLE-PREFIX             
               MOVE LINK-AT-FIRST-NAME TO DQ-FIRST-NAME                 
               MOVE LINK-AT-MIDDLE-NAME TO DQ-MIDDLE-NAME               
               MOVE LINK-AT-LAST-NAME TO DQ-LAST-NAME                   
               MOVE LINK-AT-TITLE-SUFFIX TO DQ-TITLE-SUFFIX-1           
               MOVE LINK-AT-FULL-NAME TO DQ-FULL-NAME                   
               IF AIAA-EXISTS                                           
                   IF WS-AIAA-DELETE-FL = 'Y'                           
                       PERFORM 8200-DELETE-BILL-NMES THRU 8200-EXIT     
                       PERFORM 8150-DELETE-NAME-ACCT-XREF THRU 8150-EXIT
                       MOVE CU-NAME-ID TO AB-NAME-ID                    
                       PERFORM 8360-UPDATE-BILL-ADDR THRU 8360-EXIT     
                   ELSE                                                 
                       PERFORM 8350-UPDATE-BILL-NMES THRU 8350-EXIT     
                       PERFORM 8370-UPDATE-NAME THRU 8370-EXIT          
                       PERFORM 8360-UPDATE-BILL-ADDR THRU 8360-EXIT     
                   END-IF                                               
               ELSE                                                     
                   PERFORM 2120-INSERT-AIAA-NAME THRU 2120-EXIT
               END-IF
           END-IF.        
                                                                        
           INITIALIZE DCLCSS-ACCT-BILL-NMES                             
                      DCLCSS-NAME                                       
                      DCLCSS-BILL-ADDR-XREF                             
                      DCLCSS-NAME-ACCT-XREF.                            
                                                                        
           IF LINK-NB-NAME-TYPE > SPACES                                
               PERFORM 7050-SELECT-NB-NAME THRU 7050-EXIT               
               IF NBNB-EXISTS                                           
                   MOVE AB-NAME-ID TO DQ-NAME-ID                        
                   PERFORM 7070-SELECT-NAME THRU 7070-EXIT              
               ELSE                                                     
                   INITIALIZE DCLCSS-ACCT-BILL-NMES                     
                              DCLCSS-NAME                               
               END-IF                                                   
               PERFORM 2130-NB-TRANSHIST THRU 2130-EXIT                 
               IF NBNB-CHANGED                                          
                   MOVE 'AN' TO AB-NAME-TYPE                            
                                DQ-NAME-TYPE                            
                   MOVE LINK-NB-NAME-FORMAT TO DQ-NAME-FORMAT           
                   MOVE LINK-NB-TITLE-PREFIX TO DQ-TITLE-PREFIX         
                   MOVE LINK-NB-FIRST-NAME TO DQ-FIRST-NAME             
                   MOVE LINK-NB-MIDDLE-NAME TO DQ-MIDDLE-NAME           
                   MOVE LINK-NB-LAST-NAME TO DQ-LAST-NAME               
                   MOVE LINK-NB-TITLE-SUFFIX TO DQ-TITLE-SUFFIX-1       
                   MOVE LINK-NB-FULL-NAME TO DQ-FULL-NAME               
                   IF NBNB-EXISTS                                       
                       IF WS-NBNB-DELETE-FL = 'Y'                       
                           PERFORM 8200-DELETE-BILL-NMES THRU 8200-EXIT 
                           PERFORM 8150-DELETE-NAME-ACCT-XREF THRU      
                                   8150-EXIT                            
                       ELSE                                             
                           PERFORM 8350-UPDATE-BILL-NMES THRU 8350-EXIT 
                           PERFORM 8370-UPDATE-NAME THRU 8370-EXIT      
                       END-IF                                           
                   ELSE                                                 
                       PERFORM 2140-INSERT-NBNB-NAME THRU 2140-EXIT
                   END-IF
               END-IF
           END-IF.    
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-AI-AA-TRANSHIST.                                            
                                                                        
           IF WS-AIAA-DELETE-FL = 'Y' AND                               
              AIAA-EXISTS                                               
                  MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO               
                  MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                    
                  MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT          
                  EVALUATE AB-NAME-TYPE                                 
                      WHEN 'AI'                                         
                          MOVE 'IN CARE OF' TO MI-PRV-COLUMN-VALUE-TEXT 
                      WHEN 'AA'                                         
                          MOVE 'ATTENTION' TO MI-PRV-COLUMN-VALUE-TEXT  
                  END-EVALUATE                                          
                  MOVE +10 TO MI-PRV-COLUMN-VALUE-LEN                   
                  MOVE 'NAME TYPE' TO MI-COLUMN-DESC                    
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                             
                                                                        
           IF AB-NAME-TYPE NOT = LINK-AT-NAME-TYPE                      
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-NAME-TYPE > SPACES                            
                   EVALUATE LINK-AT-NAME-TYPE                           
                       WHEN 'AI'                                        
                           MOVE 'IN CARE OF' TO MI-CHG-COLUMN-VALUE-TEXT
                       WHEN 'AA'                                        
                           MOVE 'ATTENTION' TO MI-CHG-COLUMN-VALUE-TEXT 
                   END-EVALUATE                                         
                   MOVE +10 TO MI-CHG-COLUMN-VALUE-LEN                  
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF AB-NAME-TYPE > SPACES                                 
                   EVALUATE AB-NAME-TYPE                                
                       WHEN 'AI'                                        
                           MOVE 'IN CARE OF' TO MI-PRV-COLUMN-VALUE-TEXT
                       WHEN 'AA'                                        
                           MOVE 'ATTENTION' TO MI-PRV-COLUMN-VALUE-TEXT 
                   END-EVALUATE                                         
                   MOVE +10 TO MI-PRV-COLUMN-VALUE-LEN                  
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'NAME TYPE' TO MI-COLUMN-DESC                       
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-NAME-FORMAT NOT = LINK-AT-NAME-FORMAT                  
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-NAME-FORMAT > SPACES                          
                   EVALUATE LINK-AT-NAME-FORMAT                         
                       WHEN 'I'                                         
                           MOVE 'INDIVIDUAL' TO MI-CHG-COLUMN-VALUE-TEXT
                       WHEN 'B'                                         
                           MOVE 'BUSINESS' TO MI-CHG-COLUMN-VALUE-TEXT  
                   END-EVALUATE                                         
                   MOVE +10 TO MI-CHG-COLUMN-VALUE-LEN                  
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-NAME-FORMAT > SPACES                               
                   EVALUATE DQ-NAME-FORMAT                              
                       WHEN 'I'                                         
                           MOVE 'INDIVIDUAL' TO MI-PRV-COLUMN-VALUE-TEXT
                       WHEN 'B'                                         
                           MOVE 'BUSINESS' TO MI-PRV-COLUMN-VALUE-TEXT  
                   END-EVALUATE                                         
                   MOVE +10 TO MI-PRV-COLUMN-VALUE-LEN                  
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'NAME FORMAT' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-TITLE-PREFIX NOT = LINK-AT-TITLE-PREFIX                
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-TITLE-PREFIX > SPACES                         
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-AT-TITLE-PREFIX TO                         
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-TITLE-PREFIX > SPACES                              
                   MOVE +9 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE DQ-TITLE-PREFIX TO MI-PRV-COLUMN-VALUE-TEXT     
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'TITLE PREFIX' TO MI-COLUMN-DESC                    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-AT-FIRST-NAME                    
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-FIRST-NAME > SPACES                           
                   MOVE +15 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-AT-FIRST-NAME TO                           
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-FIRST-NAME > SPACES                                
                   MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-FIRST-NAME TO MI-PRV-COLUMN-VALUE-TEXT       
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'FIRST NAME' TO MI-COLUMN-DESC                      
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-MIDDLE-NAME NOT = LINK-AT-MIDDLE-NAME                  
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-MIDDLE-NAME > SPACES                          
                   MOVE +15 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-AT-MIDDLE-NAME TO                          
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-MIDDLE-NAME > SPACES                               
                   MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-MIDDLE-NAME TO MI-PRV-COLUMN-VALUE-TEXT      
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'MIDDLE NAME' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-LAST-NAME NOT = LINK-AT-LAST-NAME                      
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-LAST-NAME > SPACES                            
                   MOVE +40 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-AT-LAST-NAME TO                            
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-LAST-NAME > SPACES                                 
                   MOVE +40 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-LAST-NAME TO MI-PRV-COLUMN-VALUE-TEXT        
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'LAST NAME' TO MI-COLUMN-DESC                       
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-TITLE-SUFFIX-1 NOT = LINK-AT-TITLE-SUFFIX              
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-TITLE-SUFFIX > SPACES                         
                   MOVE +3 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-AT-TITLE-SUFFIX TO                         
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-TITLE-SUFFIX-1 > SPACES                            
                   MOVE +3 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE DQ-TITLE-SUFFIX-1 TO MI-PRV-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'TITLE SUFFIX' TO MI-COLUMN-DESC                    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-FULL-NAME NOT = LINK-AT-FULL-NAME                      
               MOVE 'YES' TO WS-AIAA-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-AT-FULL-NAME > SPACES                            
                   MOVE +70 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-AT-FULL-NAME TO                            
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-FULL-NAME > SPACES                                 
                   MOVE +70 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-FULL-NAME TO MI-PRV-COLUMN-VALUE-TEXT        
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'FULL NAME' TO MI-COLUMN-DESC                       
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2120-INSERT-AIAA-NAME.                                           
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
                                                                        
           MOVE WS-91-NEW-NAME-ID        TO DQ-NAME-ID.                 
           MOVE LINK-AT-NAME-TYPE        TO DQ-NAME-TYPE.               
           MOVE LINK-AT-NAME-FORMAT      TO DQ-NAME-FORMAT.             
           MOVE LINK-AT-FULL-NAME        TO DQ-FULL-NAME.               
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           MOVE LINK-AT-FIRST-NAME       TO DQ-FIRST-NAME.              
           MOVE LINK-AT-MIDDLE-NAME      TO DQ-MIDDLE-NAME.             
           MOVE LINK-AT-LAST-NAME        TO DQ-LAST-NAME.               
           MOVE LINK-AT-TITLE-PREFIX     TO DQ-TITLE-PREFIX.            
           MOVE LINK-AT-TITLE-SUFFIX     TO DQ-TITLE-SUFFIX-1.          
           MOVE SPACES                   TO DQ-TITLE-SUFFIX-2.          
           PERFORM 8011-INSERT-NAME THRU 8011-EXIT.                     
                                                                        
           MOVE WS-91-NEW-NAME-ID        TO AB-NAME-ID.                 
           MOVE LINK-AT-NAME-TYPE        TO AB-NAME-TYPE.               
           PERFORM 8030-INSERT-BILL-NMES THRU 8030-EXIT.                
                                                                        
           MOVE WS-91-NEW-NAME-ID TO HT-NAME-ID.                        
           MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO.                       
           MOVE PR-ADDRESS-ID TO HT-ADDRESS-ID.                         
           MOVE AT-COMPANY-NO TO HT-COMPANY-NO.                         
           MOVE ZERO TO HT-CONTACT-ID.                                  
           MOVE AT-PREMISE-NO TO HT-PREMISE-NO                          
           MOVE A4-TOWN TO HT-TOWN                                      
           MOVE A4-STATE TO HT-STATE                                    
           MOVE PR-LOCAL-OFFICE TO HT-LOCAL-OFFICE                      
           MOVE AT-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE            
           MOVE AT-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT                  
           PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT.                
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2130-NB-TRANSHIST.                                               
                                                                        
           IF WS-NBNB-DELETE-FL = 'Y' AND                               
              NBNB-EXISTS                                               
                  MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO               
                  MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                    
                  MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT          
                  MOVE 'NAME ON BILL' TO MI-PRV-COLUMN-VALUE-TEXT       
                  MOVE +12 TO MI-PRV-COLUMN-VALUE-LEN                   
                  MOVE 'NAME TYPE' TO MI-COLUMN-DESC                    
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                             
                                                                        
           IF DQ-NAME-FORMAT NOT = LINK-NB-NAME-FORMAT                  
               MOVE 'YES' TO WS-NBNB-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NB-NAME-FORMAT > SPACES                          
                   EVALUATE LINK-NB-NAME-FORMAT                         
                       WHEN 'I'                                         
                           MOVE 'INDIVIDUAL' TO MI-CHG-COLUMN-VALUE-TEXT
                       WHEN 'B'                                         
                           MOVE 'BUSINESS' TO MI-CHG-COLUMN-VALUE-TEXT  
                   END-EVALUATE                                         
                   MOVE +10 TO MI-CHG-COLUMN-VALUE-LEN                  
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-NAME-FORMAT > SPACES                               
                   EVALUATE DQ-NAME-FORMAT                              
                       WHEN 'I'                                         
                           MOVE 'INDIVIDUAL' TO MI-PRV-COLUMN-VALUE-TEXT
                       WHEN 'B'                                         
                           MOVE 'BUSINESS' TO MI-PRV-COLUMN-VALUE-TEXT  
                   END-EVALUATE                                         
                   MOVE +10 TO MI-PRV-COLUMN-VALUE-LEN                  
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'NAME FORMAT' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-TITLE-PREFIX NOT = LINK-NB-TITLE-PREFIX                
               MOVE 'YES' TO WS-NBNB-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NB-TITLE-PREFIX > SPACES                         
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-NB-TITLE-PREFIX TO                         
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-TITLE-PREFIX > SPACES                              
                   MOVE +9 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE DQ-TITLE-PREFIX TO MI-PRV-COLUMN-VALUE-TEXT     
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL PREFIX' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-NB-FIRST-NAME                    
               MOVE 'YES' TO WS-NBNB-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NB-FIRST-NAME > SPACES                           
                   MOVE +15 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-NB-FIRST-NAME TO                           
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-FIRST-NAME > SPACES                                
                   MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-FIRST-NAME TO MI-PRV-COLUMN-VALUE-TEXT       
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL FIRST' TO MI-COLUMN-DESC                      
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-MIDDLE-NAME NOT = LINK-NB-MIDDLE-NAME                  
               MOVE 'YES' TO WS-NBNB-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NB-MIDDLE-NAME > SPACES                          
                   MOVE +15 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-NB-MIDDLE-NAME TO                          
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-MIDDLE-NAME > SPACES                               
                   MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-MIDDLE-NAME TO MI-PRV-COLUMN-VALUE-TEXT      
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL MIDDLE' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-LAST-NAME NOT = LINK-NB-LAST-NAME                      
               MOVE 'YES' TO WS-NBNB-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NB-LAST-NAME > SPACES                            
                   MOVE +40 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-NB-LAST-NAME TO                            
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-LAST-NAME > SPACES                                 
                   MOVE +40 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-LAST-NAME TO MI-PRV-COLUMN-VALUE-TEXT        
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL LAST' TO MI-COLUMN-DESC                       
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-TITLE-SUFFIX-1 NOT = LINK-NB-TITLE-SUFFIX              
               MOVE 'YES' TO WS-NBNB-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NB-TITLE-SUFFIX > SPACES                         
                   MOVE +3 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE LINK-NB-TITLE-SUFFIX TO                         
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-TITLE-SUFFIX-1 > SPACES                            
                   MOVE +3 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE DQ-TITLE-SUFFIX-1 TO MI-PRV-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL SUFFIX' TO MI-COLUMN-DESC                     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DQ-FULL-NAME NOT = LINK-NB-FULL-NAME                      
               MOVE 'YES' TO WS-NBNB-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-NB-FULL-NAME > SPACES                            
                   MOVE +70 TO MI-CHG-COLUMN-VALUE-LEN                  
                   MOVE LINK-NB-FULL-NAME TO                            
                        MI-CHG-COLUMN-VALUE-TEXT                        
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF DQ-FULL-NAME > SPACES                                 
                   MOVE +70 TO MI-PRV-COLUMN-VALUE-LEN                  
                   MOVE DQ-FULL-NAME TO MI-PRV-COLUMN-VALUE-TEXT        
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'BILL FULL' TO MI-COLUMN-DESC                       
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2140-INSERT-NBNB-NAME.                                           
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
                                                                        
           MOVE WS-91-NEW-NAME-ID        TO DQ-NAME-ID                  
           MOVE 'AN'                     TO DQ-NAME-TYPE                
           MOVE LINK-NB-NAME-FORMAT      TO DQ-NAME-FORMAT              
           MOVE LINK-NB-FULL-NAME        TO DQ-FULL-NAME                
           MOVE WS-CURRENT-TIMESTAMP TO DQ-CREATED-DATE                 
           MOVE LINK-NB-FIRST-NAME       TO DQ-FIRST-NAME               
           MOVE LINK-NB-MIDDLE-NAME      TO DQ-MIDDLE-NAME              
           MOVE LINK-NB-LAST-NAME        TO DQ-LAST-NAME                
           MOVE LINK-NB-TITLE-PREFIX TO DQ-TITLE-PREFIX                 
           MOVE LINK-NB-TITLE-SUFFIX TO DQ-TITLE-SUFFIX-1               
           MOVE SPACES                   TO DQ-TITLE-SUFFIX-2           
           PERFORM 8011-INSERT-NAME THRU 8011-EXIT.                     
                                                                        
           MOVE WS-91-NEW-NAME-ID        TO AB-NAME-ID.                 
           MOVE 'AN'                     TO AB-NAME-TYPE.               
           PERFORM 8030-INSERT-BILL-NMES THRU 8030-EXIT.                
                                                                        
           MOVE WS-91-NEW-NAME-ID TO HT-NAME-ID.                        
           MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO.                       
           MOVE PR-ADDRESS-ID TO HT-ADDRESS-ID.                         
           MOVE AT-COMPANY-NO TO HT-COMPANY-NO.                         
           MOVE ZERO TO HT-CONTACT-ID.                                  
           MOVE AT-PREMISE-NO TO HT-PREMISE-NO                          
           MOVE A4-TOWN TO HT-TOWN                                      
           MOVE A4-STATE TO HT-STATE                                    
           MOVE PR-LOCAL-OFFICE TO HT-LOCAL-OFFICE                      
           MOVE AT-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE            
           MOVE AT-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT                  
           PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT.                
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCT-CURSOR                                        
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2400-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           PERFORM 2100-NAMES THRU 2100-EXIT.                           
                                                                        
           GO TO 2400-FETCH-ROWS.                                       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              COMPANY_NO,
              PREMISE_NO,
              CODE_ACCT_STAT,
              ACCOUNT_TYPE_CODE                                  
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-COMPANY-NO,                                    
                     :AT-PREMISE-NO,                                    
                     :AT-CODE-ACCT-STAT,                                
                     :AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              ACCOUNT_TYPE_CODE                                          
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_ID                                            
                INTO :CU-NAME-ID                                        
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :CU-NAME-ID                                                
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7010'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_CUSTOMER'    TO TABLE-1                    
                   MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1            
                   MOVE AT-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PR.ADDRESS_ID,
              LOCAL_OFFICE,
              TOWN,
              STATE                                              
                INTO :PR-ADDRESS-ID,                                    
                     :PR-LOCAL-OFFICE,                                  
                     :A4-TOWN,                                          
                     :A4-STATE                                          
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                      
                     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE PREMISE_NO = :AT-PREMISE-NO                        
                 AND PR.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.ADDRESS_ID,                                             
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE                                                      
MFA-TR*         INTO :PR-ADDRESS-ID,                                            
MFA-TR*              :PR-LOCAL-OFFICE,                                          
MFA-TR*              :A4-TOWN,                                                  
MFA-TR*              :A4-STATE                                                  
MFA-TR*         FROM CSS_PREMISE PR,                                            
MFA-TR*              CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE PREMISE_NO = :AT-PREMISE-NO                                
MFA-TR*          AND PR.ADDRESS_ID = DY.ADDRESS_ID                              
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7020'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_PREMISE'     TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-ACCT-MISC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              ADDTL_BILL_NAME_TX                                 
                INTO :WS-MISC-EXISTS-FLAG,                              
                     :TA-ADDTL-BILL-NAME-TX                             
                FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              ADDTL_BILL_NAME_TX                                         
MFA-TR*         INTO :WS-MISC-EXISTS-FLAG,                                      
MFA-TR*              :TA-ADDTL-BILL-NAME-TX                                     
MFA-TR*         FROM CSS_ACCT_MISC_INFO                                         
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7030'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-AI-AA-NAME.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              NAME_ID,
              NAME_TYPE                                          
                INTO :WS-AIAA-EXISTS-FLAG,                              
                     :AB-NAME-ID,                                       
                     :AB-NAME-TYPE                                      
                FROM CSS_ACCT_BILL_NMES WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND NAME_TYPE IN ('AA', 'AI')                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              NAME_ID,                                                   
MFA-TR*              NAME_TYPE                                                  
MFA-TR*         INTO :WS-AIAA-EXISTS-FLAG,                                      
MFA-TR*              :AB-NAME-ID,                                               
MFA-TR*              :AB-NAME-TYPE                                              
MFA-TR*         FROM CSS_ACCT_BILL_NMES                                         
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND NAME_TYPE IN ('AA', 'AI')                                  
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7040'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   MOVE 'NAME_TYPE'       TO TABLE-ELEMENT-2            
                   MOVE AB-NAME-TYPE      TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-NB-NAME.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              NAME_ID                                            
                INTO :WS-NBNB-EXISTS-FLAG,                              
                     :AB-NAME-ID                                        
                FROM CSS_ACCT_BILL_NMES WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND NAME_TYPE = 'AN'                                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              NAME_ID                                                    
MFA-TR*         INTO :WS-NBNB-EXISTS-FLAG,                                      
MFA-TR*              :AB-NAME-ID                                                
MFA-TR*         FROM CSS_ACCT_BILL_NMES                                         
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND NAME_TYPE = 'AN'                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'NAME_TYPE'      TO TABLE-ELEMENT-2             
                   MOVE 'AN'             TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     NAME_FORMAT,                                       
                     FULL_NAME                                          
              INTO  :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-NAME-FORMAT,                                    
                    :DQ-FULL-NAME                                       
              FROM   CSS_NAME WITH(READUNCOMMITTED)                             
              WHERE  NAME_ID = :DQ-NAME-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              FULL_NAME                                                  
MFA-TR*       INTO  :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-FULL-NAME                                               
MFA-TR*       FROM   CSS_NAME                                                   
MFA-TR*       WHERE  NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'I'                              
                       MOVE SPACES TO DQ-FULL-NAME                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_NAME'       TO TABLE-1                     
                   MOVE 'NAME_ID'        TO TABLE-ELEMENT-1             
                   MOVE DQ-NAME-ID       TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8011-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8011'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     PREMISE_NO,                                        
                     CONTACT_ID,                                        
                     TOWN,                                              
                     STATE,                                             
                     LOCAL_OFFICE,                                      
                     ACCOUNT_TYPE_CODE,                                 
                     CODE_ACCT_STAT)                                    
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-CONTACT-ID,                                     
                    :HT-TOWN,                                           
                    :HT-STATE,                                          
                    :HT-LOCAL-OFFICE,                                   
                    :HT-ACCOUNT-TYPE-CODE,                              
                    :HT-CODE-ACCT-STAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE HT-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-BILL-NMES.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_BILL_NMES                            
                   ( ACCOUNT_NO,                                        
                     NAME_TYPE,                                         
                     NAME_ID)                                           
              VALUES                                                    
                   (:AT-ACCOUNT-NO,                                     
                    :AB-NAME-TYPE,                                      
                    :AB-NAME-ID)                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE AB-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-3              
              MOVE AB-NAME-ID           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-MISC.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_MISC_INFO                            
                   ( ACCOUNT_NO,                                        
                     ADDTL_BILL_NAME_TX)                                
              VALUES                                                    
                   (:AT-ACCOUNT-NO,                                     
                    :TA-ADDTL-BILL-NAME-TX)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8150-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
              WHERE NAME_ID = :AB-NAME-ID                               
                AND ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*       WHERE NAME_ID = :AB-NAME-ID                                       
MFA-TR*         AND ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'NAME_ID'        TO TABLE-ELEMENT-1             
                   MOVE AB-NAME-ID       TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-MISC.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_MISC_INFO                            
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
                 AND EDI_PHONE_NO       = ' '                           
                 AND LOCK_BOX_NO        = ' '                           
                 AND ADDTL_BILL_NAME_TX = ' '                           
                 AND SPCL_BILL_STMNT_TX = ' '                           
                 AND INTERNET_ADDR      = ' '                           
                 AND EDI_ACCT_CD        = ' '                           
                 AND DBA_TAX_ID         = ' '                           
                 AND GROUP_ID           = ' '                           
                 AND SERVICE_CARE_ID    = ' '                           
                 AND WEBSITE_ADDR       = ' '                           
                 AND SEASONAL_FL        = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ACCT_MISC_INFO                                    
MFA-TR*        WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO                       
MFA-TR*          AND EDI_PHONE_NO       = ' '                                   
MFA-TR*          AND LOCK_BOX_NO        = ' '                                   
MFA-TR*          AND ADDTL_BILL_NAME_TX = ' '                                   
MFA-TR*          AND SPCL_BILL_STMNT_TX = ' '                                   
MFA-TR*          AND INTERNET_ADDR      = ' '                                   
MFA-TR*          AND EDI_ACCT_CD        = ' '                                   
MFA-TR*          AND DBA_TAX_ID         = ' '                                   
MFA-TR*          AND GROUP_ID           = ' '                                   
MFA-TR*          AND SERVICE_CARE_ID    = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND SEASONAL_FL        = ' '                                   
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8190'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE AT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-DELETE-BILL-NMES.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_BILL_NMES                            
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND NAME_ID    = :AB-NAME-ID                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ACCT_BILL_NMES                                    
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND NAME_ID    = :AB-NAME-ID                                   
MFA-TR*       QUERYNO 8200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8200'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE AT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE 'NAME_ID'       TO TABLE-ELEMENT-2              
                   MOVE AB-NAME-ID      TO HOSTVAR-ELEMENT-2            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-MISC.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_MISC_INFO                                 
                 SET ADDTL_BILL_NAME_TX = :TA-ADDTL-BILL-NAME-TX        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_MISC_INFO                                         
MFA-TR*          SET ADDTL_BILL_NAME_TX = :TA-ADDTL-BILL-NAME-TX                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8340'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8350-UPDATE-BILL-NMES.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_BILL_NMES                                 
                 SET NAME_TYPE = :AB-NAME-TYPE                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND NAME_ID    = :AB-NAME-ID                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_BILL_NMES                                         
MFA-TR*          SET NAME_TYPE = :AB-NAME-TYPE                                  
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND NAME_ID    = :AB-NAME-ID                                   
MFA-TR*       QUERYNO 8350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8350'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'NAME_ID'        TO TABLE-ELEMENT-2             
                   MOVE AB-NAME-ID       TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-BILL-ADDR.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_BILL_ADDR_XREF                                 
                 SET NAME_ID = :AB-NAME-ID                              
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILL_ADDR_XREF                                         
MFA-TR*          SET NAME_ID = :AB-NAME-ID                                      
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8360'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE 'CSS_BILL_ADDR_XREF' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'NAME_ID'        TO TABLE-ELEMENT-2             
                   MOVE AB-NAME-ID       TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8370-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
              SET    FIRST_NAME      = :DQ-FIRST-NAME,                  
                     MIDDLE_NAME     = :DQ-MIDDLE-NAME,                 
                     LAST_NAME       = :DQ-LAST-NAME,                   
                     TITLE_PREFIX    = :DQ-TITLE-PREFIX,                
                     TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1,              
                     NAME_FORMAT     = :DQ-NAME-FORMAT,                 
                     NAME_TYPE       = :DQ-NAME-TYPE,                   
                     FULL_NAME       = :DQ-FULL-NAME                    
              WHERE  NAME_ID         = :DQ-NAME-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*       SET    FIRST_NAME      = :DQ-FIRST-NAME,                          
MFA-TR*              MIDDLE_NAME     = :DQ-MIDDLE-NAME,                         
MFA-TR*              LAST_NAME       = :DQ-LAST-NAME,                           
MFA-TR*              TITLE_PREFIX    = :DQ-TITLE-PREFIX,                        
MFA-TR*              TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1,                      
MFA-TR*              NAME_FORMAT     = :DQ-NAME-FORMAT,                         
MFA-TR*              NAME_TYPE       = :DQ-NAME-TYPE,                           
MFA-TR*              FULL_NAME       = :DQ-FULL-NAME                            
MFA-TR*       WHERE  NAME_ID         = :DQ-NAME-ID                              
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8370'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-2              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-3              
              MOVE 'MIDDLE_NAME'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-2            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-3            
              MOVE DQ-MIDDLE-NAME       TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00091                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
