       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04708.                                         
COB303 DATE-WRITTEN.  APRIL 9, 2014.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES M&P BILL ADDRESS INFORMATION.            *00200000
      *  STATUS CODE VALUES:                                           *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  04/09/14   FMB       NEW PROGRAM.                             *00290000
ACT233*  07/26/16   TP7R341   REPLACE CSR00028 WITH CSR04675           *00290000
ACT233*   A05460                                                       *00290000
A05317*  11/02/16   FMB       IMPROVE TRANSHIST WHEN BILL ADDRESS FOR  *00290000
A05317*                       LANDLORD IS DELETED.                     *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04708'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     01090000
              INCLUDE TBADRFMT                                          01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01090000
              INCLUDE TBADRFRE                                          01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01090000
              INCLUDE TBZIPCD                                           01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01130000
              INCLUDE TBADDRID                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01130000
              INCLUDE TBBLADRX                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01130000
              INCLUDE TBLNDLRD                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01130000
              INCLUDE TBCUST                                            01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01130000
              INCLUDE TBCAT                                             01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBDELQ                                            01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBACCT                                            01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBPREM                                            01430000
           END-EXEC.                                                    01440000
                                                                        
           COPY CWS00011.                                               01520000
           COPY CWS00303.                                               01520000
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00071                                          01680000
           END-EXEC.                                                    01690000
           EXEC SQL                                                     01710000
              INCLUDE CWS0090A                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-NEW-ADDR-ID-NUM       PIC 9(13).                      
           05  WS-NEW-ADDR-ID-CHAR      REDEFINES WS-NEW-ADDR-ID-NUM    
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04708'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-ADDR-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ADDR-CHANGED                    VALUE 'YES'.          
           05  WS-AFMT-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 AFMT-CHANGED                    VALUE 'YES'.          
           05  WS-UPDATE-TYPE           PIC X(01) VALUE SPACES.         
           05  WS-FMT-DELETE-FL         PIC X(01) VALUE SPACES.         
           05  WS-FRE-DELETE-FL         PIC X(01) VALUE SPACES.         
           05  WS-SUBI                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUBO                  PIC S9(4) COMP VALUE 0.         
           05  WS-ACCOUNT-CT            PIC S9(4) COMP VALUE 0.         
           05  WS-STREET-LOC-2          PIC X(11) VALUE SPACES.         
           05  WS-FF-TO-FMT-FL          PIC X(01) VALUE SPACES.         
           05  WS-FF-MATCH-FOUND-FL     PIC X(01) VALUE SPACES.         
           05  WS-FMT-MATCH-FOUND-FL    PIC X(01) VALUE SPACES.         
           05  WS-LL-MATCH-FOUND-FL     PIC X(01) VALUE SPACES.         
           05  WS-IAT-CAT-FOUND         PIC X(01) VALUE 'N'.            
           05  WS-LL-ROWS-FL            PIC X(01) VALUE 'N'.            
           05  WS-OLD-BILL-ADDR-ID      PIC 9(13) VALUE 0.              
           05  WS-OLD-BILL-ADDR-CHAR    REDEFINES WS-OLD-BILL-ADDR-ID   
                                        PIC X(13).                      
           05  WS-OLD-SI-ADDR-ID        PIC 9(13) VALUE 0.              
           05  WS-OLD-SI-ADDR-ID-CHAR   REDEFINES WS-OLD-SI-ADDR-ID     
                                        PIC X(13).                      
           05  WS-INTERNATIONAL-FL      PIC X(01) VALUE SPACES.         
           05  WS-SHARED-LL-ADDR-ID     PIC 9(13) VALUE ZEROES.         
           05  WS-DISPLAY-ADDR          PIC 9(13) VALUE ZEROES.         
           05  WS-IAT-MESSAGE.                                          
               10  F                    PIC X(51) VALUE                 
              'VERIFY OR UPDATE THE INTERNATIONAL ADDRESS ENTERED.'.    
                                                                        
      * ADDRESS FIELDS FOR PREMISE OF ACCOUNT BEING PROCESSED                   
       01  PR-ADDR-FORMATTED.                                           
           10 PR-HOUSE-NO             PIC X(15).                        
           10 PR-ADDR-PREFIX-1        PIC X(3).                         
           10 PR-ADDR-PREFIX-2        PIC X(2).                         
           10 PR-STREET-NAME          PIC X(30).                        
           10 PR-STREET-LOCATION-1    PIC X(4).                         
           10 PR-STREET-LOCATION-2    PIC X(11).                        
           10 PR-STREET-SUFFIX        PIC X(4).                         
           10 PR-ZIP-CODE             PIC X(5).                         
           10 PR-ZIP-CODE-TOKEN       PIC X(1).                         
           10 PR-ADDR-SUFFIX          PIC X(2).                         
           10 PR-ZIP-CODE-PLUS-FOUR   PIC X(4).                         
           10 PR-USPS-DELIV-PT-CD     PIC X(2).                         
           10 PR-ADDRESS-OVERFLOW     PIC X(35).                        
A05317     10 PR-ADDRESS-LINE         PIC X(75).                        
      * EXISTING FORMATTED BILL ADDRESS FIELD OF ACCOUNT BEING PROCESSED        
       01  BA-ADDR-FORMATTED.                                           
           10 BA-HOUSE-NO             PIC X(15).                        
           10 BA-ADDR-PREFIX-1        PIC X(3).                         
           10 BA-ADDR-PREFIX-2        PIC X(2).                         
           10 BA-STREET-NAME          PIC X(30).                        
           10 BA-STREET-LOCATION-1    PIC X(4).                         
           10 BA-STREET-LOCATION-2    PIC X(11).                        
           10 BA-STREET-SUFFIX        PIC X(4).                         
           10 BA-ZIP-CODE             PIC X(5).                         
           10 BA-ZIP-CODE-TOKEN       PIC X(1).                         
           10 BA-ADDR-SUFFIX          PIC X(2).                         
           10 BA-OVERFLOW-FMT         PIC X(35).                        
      * EXISTING FREEFORM BILL ADDRESS FIELD OF ACCOUNT BEING PROCESSED         
       01  BA-ADDR-FREEFORM.                                            
           10 BA-ADDR-STREET          PIC X(55).                        
           10 BA-ADDR-CITY-STATE      PIC X(30).                        
           10 BA-ADDR-ZIP-CODE        PIC X(9).                         
           10 BA-ADDR-COUNTRY         PIC X(35).                        
           10 BA-ADDRESS-OVERFLOW     PIC X(35).                        
      * EXISTING FORMATTED LANDLORD ADDRESS FIELDS                              
       01  SI-ADDR-FORMATTED.                                           
           10 SI-HOUSE-NO             PIC X(15).                        
           10 SI-ADDR-PREFIX-1        PIC X(3).                         
           10 SI-ADDR-PREFIX-2        PIC X(2).                         
           10 SI-STREET-NAME          PIC X(30).                        
           10 SI-STREET-LOCATION-1    PIC X(4).                         
           10 SI-STREET-LOCATION-2    PIC X(11).                        
           10 SI-STREET-SUFFIX        PIC X(4).                         
           10 SI-ZIP-CODE             PIC X(5).                         
           10 SI-ZIP-CODE-TOKEN       PIC X(1).                         
           10 SI-ADDR-SUFFIX          PIC X(2).                         
           10 SI-OVERFLOW-FMT         PIC X(35).                        
A05317     10 SI-ADDRESS-LINE-FMT     PIC X(75).                        
      * EXISTING FREEFORM LANDLORD ADDRESS FIELDS                               
       01  SI-ADDR-FREEFORM.                                            
           10 SI-ADDR-STREET          PIC X(55).                        
           10 SI-ADDR-CITY-STATE      PIC X(30).                        
           10 SI-ADDR-ZIP-CODE        PIC X(9).                         
           10 SI-ADDR-COUNTRY         PIC X(35).                        
           10 SI-ADDRESS-OVERFLOW     PIC X(35).                        
A05317     10 SI-ADDRESS-LINE-FRE     PIC X(75).                        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-ADDRESS-ID              PIC S9(13)V COMP-3 VALUE 0.    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
      ******************************************************************        
ACT233* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT233     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT233     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE ACCT-CURSOR CURSOR FOR                            
               SELECT ACCOUNT_NO                                        
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE LL-CURSOR CURSOR FOR                              
               SELECT ADDRESS_ID,                                       
                      ADDRESS_FORMAT,                                   
                      PREMISE_NO                                        
                 FROM CSS_LANDLORD                                      
                WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                     
                FOR UPDATE OF ADDRESS_ID, ADDRESS_FORMAT                
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LL-CURSOR CURSOR FOR                                      
MFA-TR*        SELECT ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT,                                           
MFA-TR*               PREMISE_NO                                                
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                             
MFA-TR*         FOR UPDATE OF ADDRESS_ID, ADDRESS_FORMAT                        
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-ADDRESS-ID          PIC X(13).                          
       01  LINK-ADDRESS-FORMAT      PIC X(01).                          
       01  LINK-FF-STREET-1         PIC X(55).                          
       01  LINK-FF-STREET-2         PIC X(55).                          
       01  LINK-FF-CITY-STATE       PIC X(30).                          
       01  LINK-FF-ZIP-CODE         PIC X(09).                          
       01  LINK-FF-COUNTRY          PIC X(35).                          
       01  LINK-HOUSE-NO            PIC X(15).                          
       01  LINK-ADDR-PREFIX-1       PIC X(03).                          
       01  LINK-ADDR-PREFIX-2       PIC X(02).                          
       01  LINK-STREET-NAME         PIC X(30).                          
       01  LINK-STREET-SUFFIX       PIC X(04).                          
       01  LINK-ADDR-SUFFIX         PIC X(02).                          
       01  LINK-STREET-LOC-1        PIC X(04).                          
       01  LINK-STREET-LOC-2        PIC X(11).                          
       01  LINK-TOWN                PIC X(26).                          
       01  LINK-STATE               PIC X(02).                          
       01  LINK-ZIP-CODE            PIC X(05).                          
       01  LINK-ZIP-CODE-4          PIC X(04).                          
       01  LINK-USPS-DELIV-PT       PIC X(02).                          
       01  LINK-ACCOUNT-UPDATE-CD   PIC X(03).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
       01  LINK-OVERFLOW            PIC X(35).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO,                                        
                LINK-ADDRESS-ID,                                        
                LINK-ADDRESS-FORMAT,                                    
                LINK-FF-STREET-1,                                       
                LINK-FF-STREET-2,                                       
                LINK-FF-CITY-STATE,                                     
                LINK-FF-ZIP-CODE,                                       
                LINK-FF-COUNTRY,                                        
                LINK-HOUSE-NO,                                          
                LINK-ADDR-PREFIX-1,                                     
                LINK-ADDR-PREFIX-2,                                     
                LINK-STREET-NAME,                                       
                LINK-STREET-SUFFIX,                                     
                LINK-ADDR-SUFFIX,                                       
                LINK-STREET-LOC-1,                                      
                LINK-STREET-LOC-2,                                      
                LINK-TOWN,                                              
                LINK-STATE,                                             
                LINK-ZIP-CODE,                                          
                LINK-ZIP-CODE-4,                                        
                LINK-USPS-DELIV-PT,                                     
                LINK-ACCOUNT-UPDATE-CD,                                 
                LINK-USERID,                                            
                LINK-COMMENTS                                           
                LINK-OVERFLOW.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE,                  
                       :S-ADDRESS-ID  AS ADDRESS_ID                     
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE,                          
MFA-TR*                :S-ADDRESS-ID  AS ADDRESS_ID                             
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-ADDRESS-ID <= SPACES                                 
               MOVE ZEROES TO LINK-ADDRESS-ID
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
                                                                        
           INSPECT LINK-HOUSE-NO REPLACING ALL '~' BY '-'.              
           INSPECT LINK-STREET-NAME REPLACING ALL '~' BY '-'.           
           INSPECT LINK-STREET-LOC-2 REPLACING ALL '~' BY '-'.          
           INSPECT LINK-FF-STREET-1 REPLACING ALL '~' BY '-'.           
           INSPECT LINK-FF-STREET-2 REPLACING ALL '~' BY '-'.           
           INSPECT LINK-FF-CITY-STATE REPLACING ALL '~' BY '-'.         
           INSPECT LINK-FF-COUNTRY REPLACING ALL '~' BY '-'.            
                                                                        
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           IF LINK-ADDRESS-FORMAT = 'A' OR 'B'                          
               NEXT SENTENCE                                            
           ELSE                                                         
               INITIALIZE DCLCSS-ADDR-FORMATTED                         
                          DCLCSS-ADDR-FREEFORM                          
               MOVE SPACES TO LINK-ADDRESS-FORMAT                       
               EVALUATE TRUE                                            
                   WHEN LINK-STREET-NAME > ' '                          
                       MOVE 'A' TO LINK-ADDRESS-FORMAT                  
                   WHEN LINK-FF-STREET-1 > ' '                          
                       MOVE 'B' TO LINK-ADDRESS-FORMAT                  
               END-EVALUATE
           END-IF.                                            
                                                                        
      * VALUES IN ADDRESS ID AND ADDRESS FORMAT WITH SPACES IN THE              
      * ACTUAL ADDRESS FIELDS INDICATES A DELETE                                
                                                                        
           MOVE 'N' TO WS-FMT-DELETE-FL                                 
                       WS-FRE-DELETE-FL.                                
           IF LINK-ADDRESS-ID > ZEROES AND                              
              LINK-ADDRESS-FORMAT = 'A' AND                             
              LINK-HOUSE-NO = SPACES AND                                
              LINK-ADDR-PREFIX-1 = SPACES AND                           
              LINK-ADDR-PREFIX-2 = SPACES AND                           
              LINK-STREET-NAME = SPACES AND                             
              LINK-STREET-SUFFIX = SPACES AND                           
              LINK-ADDR-SUFFIX = SPACES AND                             
              LINK-STREET-LOC-1 = SPACES AND                            
              LINK-STREET-LOC-2 = SPACES AND                            
              LINK-ZIP-CODE = SPACES                                    
                  MOVE 'Y' TO WS-FMT-DELETE-FL
           END-IF.                         
                                                                        
           IF LINK-ADDRESS-ID > ZEROES AND                              
              LINK-ADDRESS-FORMAT = 'B' AND                             
              LINK-FF-STREET-1 = SPACES AND                             
              LINK-FF-STREET-2 = SPACES AND                             
              LINK-FF-CITY-STATE = SPACES AND                           
              LINK-FF-ZIP-CODE = SPACES AND                             
              LINK-FF-COUNTRY = SPACES                                  
                  MOVE 'Y' TO WS-FRE-DELETE-FL
           END-IF.                         
                                                                        
           IF LINK-ADDRESS-FORMAT = 'B' AND                             
              LINK-FF-COUNTRY > SPACES AND                              
              LINK-FF-COUNTRY NOT = 'UNITED STATES' AND                 
              LINK-FF-COUNTRY NOT = 'USA'                               
                  MOVE 'Y' TO WS-INTERNATIONAL-FL                       
           ELSE                                                         
               MOVE 'N' TO WS-INTERNATIONAL-FL
           END-IF.                         
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           IF SEB-DATABASE                                              
               PERFORM 1200-REMOVE-DASH-POUND THRU 1200-EXIT
           END-IF.           
                                                                        
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-CUSTOMER-NO              
                                            MH-PREMISE-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL086'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-REMOVE-DASH-POUND.                                          
                                                                        
           IF LINK-ADDRESS-FORMAT = 'A'                                 
               INSPECT LINK-STREET-NAME REPLACING ALL '-' BY ' '        
               INSPECT LINK-STREET-NAME REPLACING ALL '*' BY ' '        
               INSPECT LINK-STREET-LOC-2 REPLACING ALL '*' BY ' '       
               INSPECT LINK-STREET-LOC-2 REPLACING ALL '#' BY ' '       
               IF LINK-STREET-LOC-2 > ' '                               
                   MOVE LINK-STREET-LOC-2 TO WS-STREET-LOC-2            
                   MOVE SPACES TO LINK-STREET-LOC-2                     
                   MOVE 1 TO WS-SUBI WS-SUBO                            
                   PERFORM UNTIL WS-SUBI > 11                           
                       IF WS-STREET-LOC-2(WS-SUBI:1) > ' '              
                           MOVE WS-STREET-LOC-2(WS-SUBI:1) TO           
                                LINK-STREET-LOC-2(WS-SUBO:1)            
                           ADD 1 TO WS-SUBO                             
                       END-IF                                           
                       ADD 1 TO WS-SUBI                                 
                   END-PERFORM                                          
               END-IF                                                   
           ELSE                                                         
               INSPECT LINK-FF-STREET-1 REPLACING ALL '-' BY ' '        
               INSPECT LINK-FF-STREET-1 REPLACING ALL '*' BY ' '        
               IF LINK-FF-STREET-1 > ' '                                
                   MOVE SPACES TO WS-EMB-INPUT                          
                                  WS-CMP-TABLE                          
                   MOVE LINK-FF-STREET-1 TO WS-EMB-INPUT                
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT   
                   MOVE WS-CMP-TABLE TO LINK-FF-STREET-1                
               END-IF                                                   
                                                                        
               INSPECT LINK-FF-STREET-2 REPLACING ALL '*' BY ' '        
               IF LINK-FF-STREET-2 > ' '                                
                   MOVE SPACES TO WS-EMB-INPUT                          
                                  WS-CMP-TABLE                          
                   MOVE LINK-FF-STREET-2 TO WS-EMB-INPUT                
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT   
                   MOVE WS-CMP-TABLE TO LINK-FF-STREET-2
               END-IF
           END-IF.               
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           EVALUATE LINK-ACCOUNT-UPDATE-CD                              
               WHEN 'ALL'                                               
                   IF WS-FRE-DELETE-FL = 'N' AND                        
                      WS-FMT-DELETE-FL = 'N'                            
                          PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT
                          MOVE WS-90-NEW-ADDRESS-ID TO                  
                               WS-NEW-ADDR-ID-NUM                       
                          EVALUATE LINK-ADDRESS-FORMAT                  
                              WHEN 'A'                                  
                                  PERFORM 3020-INSERT-FMT-ADDRESS THRU  
                                          3020-EXIT                     
                              WHEN 'B'                                  
                                  PERFORM 3010-INSERT-FF-ADDRESS THRU   
                                          3010-EXIT                     
                          END-EVALUATE                                  
                   END-IF                                               
                   PERFORM 7500-OPEN-ACCT-CURSOR THRU 7500-EXIT         
                   PERFORM 2400-FETCH-ROWS THRU 2400-EXIT               
                   PERFORM 7501-CLOSE-ACCT-CURSOR THRU 7501-EXIT        
                   MOVE AT-CUSTOMER-NO TO SI-CUSTOMER-NO                
                   PERFORM 7200-SELECT-LANDLORD THRU 7200-EXIT          
                   IF WS-LL-ROWS-FL = 'Y'                               
                       PERFORM 3050-LANDLORD-FOR-ALL THRU 3050-EXIT     
                   END-IF                                               
               WHEN OTHER                                               
                   PERFORM 2100-ADDRESS-PROCESSING THRU 2100-EXIT       
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-ADDRESS-PROCESSING.                                         
                                                                        
           MOVE AT-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           EVALUATE TRUE                                                
               WHEN AT-ADDRESS-ID = ZEROES                              
                   MOVE 'I' TO WS-UPDATE-TYPE                           
               WHEN WS-FMT-DELETE-FL = 'Y'                              
               WHEN WS-FRE-DELETE-FL = 'Y'                              
                   MOVE 'D' TO WS-UPDATE-TYPE                           
               WHEN OTHER                                               
                   MOVE 'U' TO WS-UPDATE-TYPE                           
           END-EVALUATE.                                                
                                                                        
           EVALUATE WS-UPDATE-TYPE                                      
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-ADDRESS THRU 3000-EXIT           
               WHEN 'U'                                                 
                   PERFORM 3100-UPDATE-ADDRESS THRU 3100-EXIT           
               WHEN 'D'                                                 
                   IF AT-ADDRESS-ID > 0 AND                             
                     (AT-ADDRESS-FORMAT = 'A' OR 'B')                   
                          PERFORM 3200-DELETE-ADDRESS THRU 3200-EXIT    
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           MOVE AT-CUSTOMER-NO TO SI-CUSTOMER-NO.                       
           PERFORM 7510-OPEN-LL-CURSOR THRU 7510-EXIT.                  
           PERFORM 3040-FETCH-ROWS THRU 3040-EXIT.                      
           PERFORM 7511-CLOSE-LL-CURSOR THRU 7511-EXIT.                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PROCESSING ALL ACCOUNTS FOR THE CUSTOMER OF THE INPUT ACCOUNT.          
                                                                        
       2400-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCT-CURSOR                                        
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2400-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-FMT-DELETE-FL = 'Y'                              
               WHEN WS-FRE-DELETE-FL = 'Y'                              
                   MOVE 'D' TO WS-UPDATE-TYPE                           
               WHEN AT-ADDRESS-ID = ZEROES                              
                   MOVE 'I' TO WS-UPDATE-TYPE                           
               WHEN OTHER                                               
                   MOVE 'U' TO WS-UPDATE-TYPE                           
           END-EVALUATE.                                                
                                                                        
      * ONE NEW ADDRESS ROW IS INSERTED FOR EITHER INSERT OR UPDATE.            
      * THE ACCOUNT TABLE IS UPDATED WITH THIS ADDRESS ID FOR ALL OF            
      * THE CUSTOMER'S ACCOUNTS.                                                
                                                                        
           EVALUATE WS-UPDATE-TYPE                                      
               WHEN 'I'                                                 
                   PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT     
                   MOVE WS-NEW-ADDR-ID-NUM TO AT-ADDRESS-ID             
                   MOVE LINK-ADDRESS-FORMAT TO AT-ADDRESS-FORMAT        
                   PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT           
                   PERFORM 8020-INSERT-ADDR-XREF THRU 8020-EXIT         
                   IF WS-INTERNATIONAL-FL = 'Y'                         
                       MOVE 'D' TO AT-CODE-PERM-BILL                    
                       PERFORM 3030-IAT-WQ THRU 3030-EXIT               
                   ELSE                                                 
                       MOVE 'A' TO AT-CODE-PERM-BILL                    
                   END-IF                                               
                   PERFORM 8030-UPDATE-PULL-CODE THRU 8030-EXIT         
               WHEN 'U'                                                 
                   MOVE AT-ADDRESS-ID TO WS-OLD-BILL-ADDR-ID            
                   PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT     
                   PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT     
                   MOVE WS-NEW-ADDR-ID-NUM TO AT-ADDRESS-ID             
                   MOVE LINK-ADDRESS-FORMAT TO AT-ADDRESS-FORMAT        
                   PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT           
                   PERFORM 8120-UPDATE-ADDR-XREF THRU 8120-EXIT         
                   IF WS-INTERNATIONAL-FL = 'Y'                         
                       MOVE 'D' TO AT-CODE-PERM-BILL                    
                   ELSE                                                 
                       MOVE 'A' TO AT-CODE-PERM-BILL                    
                   END-IF                                               
                   PERFORM 8030-UPDATE-PULL-CODE THRU 8030-EXIT         
               WHEN 'D'                                                 
                   IF AT-ADDRESS-ID > 0 AND                             
                      AT-ADDRESS-FORMAT = 'A' OR 'B'                    
                          PERFORM 3200-DELETE-ADDRESS THRU 3200-EXIT    
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           GO TO 2400-FETCH-ROWS.                                       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * INSERT PROCESS FOR A SINGLE ACCOUNT                                     
      * IF THERE IS A MATCHING ADDRESS ROW FOR THIS CUSTOMER, USE IT.           
      * IF NOT, INSERT A NEW ADDRESS ROW.                                       
                                                                        
       3000-INSERT-ADDRESS.                                             
                                                                        
           EVALUATE LINK-ADDRESS-FORMAT                                 
               WHEN 'A'                                                 
                   PERFORM 3005-CHECK-FOR-FMT-MATCH THRU 3005-EXIT      
                   IF WS-FMT-MATCH-FOUND-FL = 'Y'                       
                       MOVE DY-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM         
                                             S-ADDRESS-ID               
                   ELSE                                                 
                       PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT   
                       MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM  
                                                    S-ADDRESS-ID        
                   END-IF                                               
               WHEN 'B'                                                 
                   PERFORM 3060-CHECK-FOR-FF-MATCH THRU 3060-EXIT       
                   IF WS-FF-MATCH-FOUND-FL = 'Y'                        
                       MOVE DZ-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM         
                                             S-ADDRESS-ID               
                   ELSE                                                 
                       PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT   
                       MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM  
                                                    S-ADDRESS-ID        
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           INITIALIZE BA-ADDR-FORMATTED                                 
                      BA-ADDR-FREEFORM.                                 
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           EVALUATE LINK-ADDRESS-FORMAT                                 
               WHEN 'A'                                                 
                   IF WS-FMT-MATCH-FOUND-FL = 'N'                       
                       PERFORM 3020-INSERT-FMT-ADDRESS THRU 3020-EXIT   
                   END-IF                                               
               WHEN 'B'                                                 
                   IF WS-FF-MATCH-FOUND-FL = 'N'                        
                       PERFORM 3010-INSERT-FF-ADDRESS THRU 3010-EXIT    
                   END-IF                                               
                   IF WS-INTERNATIONAL-FL = 'Y'                         
                       MOVE 'D' TO AT-CODE-PERM-BILL                    
                       PERFORM 3030-IAT-WQ THRU 3030-EXIT               
                   ELSE                                                 
                       MOVE 'A' TO AT-CODE-PERM-BILL                    
                   END-IF                                               
                   PERFORM 8030-UPDATE-PULL-CODE THRU 8030-EXIT         
           END-EVALUATE.                                                
                                                                        
           MOVE WS-NEW-ADDR-ID-NUM TO AT-ADDRESS-ID.                    
           MOVE LINK-ADDRESS-FORMAT TO AT-ADDRESS-FORMAT.               
           PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT.                  
           PERFORM 8020-INSERT-ADDR-XREF THRU 8020-EXIT.                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3005-CHECK-FOR-FMT-MATCH.                                        
                                                                        
           MOVE 'N' TO WS-FMT-MATCH-FOUND-FL.                           
           MOVE LINK-TOWN TO A4-TOWN.                                   
           MOVE LINK-STATE TO A4-STATE.                                 
           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE.                           
           PERFORM 7010-GET-TOKEN THRU 7010-EXIT.                       
           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO.                           
           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1.                 
           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2.                 
           MOVE LINK-STREET-NAME TO DY-STREET-NAME.                     
           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX.                 
           MOVE LINK-STREET-LOC-1 TO DY-STREET-LOCATION-1.              
           MOVE LINK-STREET-LOC-2 TO DY-STREET-LOCATION-2.              
           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX.                     
           MOVE LINK-ZIP-CODE TO DY-ZIP-CODE.                           
           MOVE LINK-OVERFLOW TO DY-ADDRESS-OVERFLOW.                   
           PERFORM 7020-EXACT-FMT-MATCH THRU 7020-EXIT.                 
                                                                        
       3005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-INSERT-FF-ADDRESS.                                          
                                                                        
           INITIALIZE DCLCSS-ADDR-FREEFORM.                             
           MOVE WS-NEW-ADDR-ID-NUM TO DZ-ADDRESS-ID.                    
           MOVE LINK-FF-STREET-1 TO DZ-ADDR-STREET.                     
           MOVE LINK-FF-STREET-2 TO DZ-ADDRESS-OVERFLOW.                
           MOVE LINK-FF-CITY-STATE TO DZ-ADDR-CITY-STATE.               
           MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE.                   
           MOVE LINK-FF-COUNTRY TO DZ-ADDR-COUNTRY.                     
           PERFORM 8000-INSERT-FF-ADDR THRU 8000-EXIT.                  
           IF LINK-FF-COUNTRY <= SPACES AND                             
              LINK-FF-ZIP-CODE(1:5) > SPACES AND                        
              LINK-FF-ZIP-CODE(1:5) NUMERIC                             
                  MOVE LINK-FF-ZIP-CODE(1:5) TO A4-ZIP-CODE             
                  PERFORM 7120-VALIDATE-ZIP THRU 7120-EXIT              
                  IF A4-ZIP-CODE-TOKEN = SPACES                         
ACT233                MOVE 428              TO CATEGORY-ID-4675         
ACT233                MOVE SPACES           TO RESP-AREA-ID-4675        
ACT233                MOVE ZERO             TO SERV-ORDER-NO-4675       
ACT233                MOVE LINK-USERID      TO USER-ID-ORIG-4675        
ACT233                MOVE SPACES           TO DATE-CREATED-4675        
ACT233                MOVE SPACES           TO DATE-REQUIRED-4675       
ACT233                MOVE AT-ACCOUNT-NO    TO ACCOUNT-NO-4675          
ACT233                MOVE AT-PREMISE-NO    TO PREMISE-NO-4675          
ACT233                MOVE AT-CUSTOMER-NO   TO CUSTOMER-NO-4675         
ACT233                MOVE SPACES           TO LOCAL-OFFICE-4675        
ACT233                MOVE '4'              TO ROUTING-CATEGORY-4675    
ACT233                MOVE 'N'              TO WQ-PRIORITY-4675         
ACT233                MOVE 'N'              TO WQ-PRIORITY-4675         
                      MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE          
                      STRING 'THE CITY STATE ZIPCODE '                  
                             LINK-FF-CITY-STATE                         
                             ' '                                        
                             LINK-FF-ZIP-CODE(1:5)                      
                             ' '                                        
                             'DOES NOT EXIST IN THE TABLE.'             
                             DELIMITED BY SIZE INTO WS-EMB-INPUT        
                      PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT
ACT233                MOVE WS-CMP-TABLE TO COMMENTS-4675-TEXT           
ACT233                MOVE +88 TO COMMENTS-4675-LEN                     
ACT233                MOVE SPACES           TO FREE-FORM-DATA-4675-TEXT 
ACT233                MOVE ZERO             TO FREE-FORM-DATA-4675-LEN  
ACT233                MOVE 'CSR04708'       TO CREATED-BY-4675          
ACT233                PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT
                  END-IF
           END-IF.        
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3020-INSERT-FMT-ADDRESS.                                         
                                                                        
           INITIALIZE DCLCSS-ADDR-FORMATTED.                            
           MOVE WS-NEW-ADDR-ID-NUM TO DY-ADDRESS-ID.                    
           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO.                           
           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1.                 
           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2.                 
           MOVE LINK-STREET-NAME TO DY-STREET-NAME.                     
           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX.                 
           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX.                     
           MOVE LINK-STREET-LOC-1 TO DY-STREET-LOCATION-1.              
           MOVE LINK-STREET-LOC-2 TO DY-STREET-LOCATION-2.              
           MOVE LINK-ZIP-CODE TO DY-ZIP-CODE.                           
           MOVE LINK-ZIP-CODE-4 TO DY-ZIP-CODE-PLUS-FOUR.               
           MOVE LINK-TOWN TO A4-TOWN.                                   
           MOVE LINK-STATE TO A4-STATE.                                 
           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE.                           
           PERFORM 7010-GET-TOKEN THRU 7010-EXIT.                       
           MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN.                 
           MOVE LINK-OVERFLOW TO DY-ADDRESS-OVERFLOW.                   
           MOVE 'F' TO DY-ADDR-USAGE-CD.                                
           MOVE LINK-USPS-DELIV-PT TO DY-USPS-DELIV-PT-CD.              
           PERFORM 8010-INSERT-FMT-ADDR THRU 8010-EXIT.                 
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3030-IAT-WQ.                                                     
                                                                        
           MOVE 'N'                       TO WS-IAT-CAT-FOUND.          
           PERFORM 7850-CHECK-IAT-CATEGORY THRU 7850-EXIT.              
                                                                        
           IF WS-IAT-CAT-FOUND = 'N'                                    
ACT233         MOVE 423                     TO CATEGORY-ID-4675         
ACT233         MOVE SPACES                  TO RESP-AREA-ID-4675        
ACT233         MOVE ZERO                    TO SERV-ORDER-NO-4675       
ACT233         MOVE LINK-USERID             TO USER-ID-ORIG-4675        
ACT233         MOVE SPACES                  TO DATE-CREATED-4675        
ACT233         MOVE SPACES                  TO DATE-REQUIRED-4675       
ACT233         MOVE AT-ACCOUNT-NO           TO ACCOUNT-NO-4675          
ACT233         MOVE AT-PREMISE-NO           TO PREMISE-NO-4675          
ACT233         MOVE AT-CUSTOMER-NO          TO CUSTOMER-NO-4675         
ACT233         MOVE PR-LOCAL-OFFICE         TO LOCAL-OFFICE-4675        
ACT233         MOVE '4'                     TO ROUTING-CATEGORY-4675    
ACT233         MOVE 'N'                     TO WQ-PRIORITY-4675         
ACT233         MOVE WS-IAT-MESSAGE          TO COMMENTS-4675-TEXT       
ACT233         MOVE 51                      TO COMMENTS-4675-LEN        
ACT233         MOVE SPACES                  TO FREE-FORM-DATA-4675-TEXT 
ACT233         MOVE ZERO                    TO FREE-FORM-DATA-4675-LEN  
ACT233         MOVE 'CSR04708'              TO CREATED-BY-4675          
ACT233         PERFORM 4210-CALL-CSR04675   THRU 4210-EXIT
           END-IF.             
                                                                        
       3030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * LANDLORD PROCESSING FOR SINGLE ACCOUNT. IF THE CUSTOMER OF              
      * THE ACCOUNT BEING PROCESSED IS THE LANDLORD FOR ANY PREMISES,           
      * PROCESS EACH PREMISE. GET THE ADDRESS DATA FOR THE EXISTING             
      * CSS_LANDLORD.ADDRESS_ID AND HOLD IN WORKING STORAGE.                    
                                                                        
       3040-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH LL-CURSOR                                          
                INTO :SI-ADDRESS-ID,                                    
                     :SI-ADDRESS-FORMAT,                                
                     :SI-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 3040-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '3040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE SI-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'ADDRESS_ID'     TO TABLE-ELEMENT-1             
                   MOVE SI-ADDRESS-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE SI-ADDRESS-ID TO WS-OLD-SI-ADDR-ID.                     
           EVALUATE SI-ADDRESS-FORMAT                                   
               WHEN 'A'                                                 
                   PERFORM 7100-SELECT-FMT-SI-ADDRESS THRU 7100-EXIT    
               WHEN 'B'                                                 
                   PERFORM 7110-SELECT-FF-SI-ADDRESS THRU 7110-EXIT     
           END-EVALUATE.                                                
                                                                        
      *  PR-ADDR-FORMATTED = ADDRESS FIELDS FOR PREMISE OF ACCOUNT              
      *  BA-ADDR-FORMATTED = EXISTING FORMATTED BILL ADDRESS OF ACCOUNT         
      *  BA-ADDR-FREEFORM  = EXISTING FREEFORM BILL ADDRESS OF ACCOUNT          
      *  SI-ADDR-FORMATTED = EXISTING FORMATTED LANDLORD ADDRESS OF ROW         
      *                      FETCHED BY LL-CURSOR                               
      *  SI-ADDR-FREEFORM  = EXISTING FREEFORM LANDLORD ADDRESS OF ROW          
      *                      FETCHED BY LL-CURSOR                               
                                                                        
      *  INSERT - IF EXISTING LANDLORD ADDRESS MATCHES THE LANDLORD'S           
      *  UPDATE   PREMISE ADDRESS OR THE NEW OLD ADDRESS, UPDATE LL             
      *           WITH THE NEW BILL ADDRESS. LL ADDRESS ID IS NEVER A           
      *           PREMISE ADDRESS ID.                                           
      *  DELETE - SWITCH FROM THE EXISTING LANDLORD'S ADDRESS TO A COPY         
      *           OF THE PREMISE ADDRESS OF THE ACCOUNT BEING PROCESSED.        
      *           LL ADDRESS IS NEVER A PREMISE ADDRESS ID. LOOK FOR A          
      *           MATCH ON THE PREMISE DATA FOR THE CUSTOMER. IF NONE,          
      *           INSERT A NEW FORMATTED ADDRESS ROW. ONCE AN ADDRESS           
      *           ID HAS BEEN FOUND OR CREATED, USE IT FOR ALL PREMISES.        
                                                                        
           EVALUATE WS-UPDATE-TYPE                                      
               WHEN 'I'                                                 
               WHEN 'U'                                                 
                   IF (SI-HOUSE-NO = PR-HOUSE-NO AND                    
                       SI-ADDR-PREFIX-1 = PR-ADDR-PREFIX-1 AND          
                       SI-ADDR-PREFIX-2 = PR-ADDR-PREFIX-2 AND          
                       SI-STREET-NAME = PR-STREET-NAME AND              
                       SI-STREET-SUFFIX = PR-STREET-SUFFIX AND          
                       SI-STREET-LOCATION-1 = PR-STREET-LOCATION-1 AND  
                       SI-STREET-LOCATION-2 = PR-STREET-LOCATION-2 AND  
                       SI-ADDR-SUFFIX = PR-ADDR-SUFFIX AND              
                       SI-ZIP-CODE = PR-ZIP-CODE AND                    
                       SI-ZIP-CODE-TOKEN = PR-ZIP-CODE-TOKEN) OR        
                      (SI-ADDRESS-FORMAT = 'A' AND                      
                       SI-HOUSE-NO = BA-HOUSE-NO AND                    
                       SI-ADDR-PREFIX-1 = BA-ADDR-PREFIX-1 AND          
                       SI-ADDR-PREFIX-2 = BA-ADDR-PREFIX-2 AND          
                       SI-STREET-NAME = BA-STREET-NAME AND              
                       SI-STREET-SUFFIX = BA-STREET-SUFFIX AND          
                       SI-STREET-LOCATION-1 = BA-STREET-LOCATION-1 AND  
                       SI-STREET-LOCATION-2 = SI-STREET-LOCATION-2 AND  
                       SI-ADDR-SUFFIX = BA-ADDR-SUFFIX AND              
                       SI-ZIP-CODE = BA-ZIP-CODE AND                    
                       SI-ZIP-CODE-TOKEN = BA-ZIP-CODE-TOKEN) OR        
                      (SI-ADDRESS-FORMAT = 'B' AND                      
                       SI-ADDR-STREET = BA-ADDR-STREET AND              
                       SI-ADDRESS-OVERFLOW = BA-ADDRESS-OVERFLOW AND    
                       SI-ADDR-CITY-STATE = BA-ADDR-CITY-STATE AND      
                       SI-ADDR-ZIP-CODE = BA-ADDR-ZIP-CODE AND          
                       SI-ADDR-COUNTRY = BA-ADDR-COUNTRY)               
                          MOVE AT-ADDRESS-ID TO SI-ADDRESS-ID           
                          MOVE AT-ADDRESS-FORMAT TO SI-ADDRESS-FORMAT   
                   END-IF                                               
               WHEN 'D'                                                 
                   IF WS-SHARED-LL-ADDR-ID = 0                          
                       MOVE PR-HOUSE-NO TO DY-HOUSE-NO                  
                       MOVE PR-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1        
                       MOVE PR-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2        
                       MOVE PR-STREET-NAME TO DY-STREET-NAME            
                       MOVE PR-STREET-SUFFIX TO DY-STREET-SUFFIX        
                       MOVE PR-STREET-LOCATION-1 TO DY-STREET-LOCATION-1
                       MOVE PR-STREET-LOCATION-2 TO DY-STREET-LOCATION-2
                       MOVE PR-ADDR-SUFFIX TO DY-ADDR-SUFFIX            
                       MOVE PR-ZIP-CODE TO DY-ZIP-CODE                  
                       MOVE PR-ADDRESS-OVERFLOW TO DY-ADDRESS-OVERFLOW  
                       PERFORM 7020-EXACT-FMT-MATCH THRU 7020-EXIT      
                       IF WS-FMT-MATCH-FOUND-FL = 'Y'                   
                           MOVE DY-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM     
                                                 WS-SHARED-LL-ADDR-ID   
                       ELSE                                             
                           PERFORM 6202-GET-NEW-ADDRESS-ID THRU         
                                   6202-EXIT                            
                           MOVE WS-90-NEW-ADDRESS-ID TO                 
                                WS-NEW-ADDR-ID-NUM                      
                                WS-SHARED-LL-ADDR-ID                    
                           INITIALIZE DCLCSS-ADDR-FORMATTED             
                           MOVE WS-NEW-ADDR-ID-NUM TO DY-ADDRESS-ID     
                           MOVE PR-HOUSE-NO TO DY-HOUSE-NO              
                           MOVE PR-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1    
                           MOVE PR-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2    
                           MOVE PR-STREET-NAME TO DY-STREET-NAME        
                           MOVE PR-STREET-SUFFIX TO DY-STREET-SUFFIX    
                           MOVE PR-ADDR-SUFFIX TO DY-ADDR-SUFFIX        
                           MOVE PR-STREET-LOCATION-1 TO                 
                                DY-STREET-LOCATION-1                    
                           MOVE PR-STREET-LOCATION-2 TO                 
                                DY-STREET-LOCATION-2                    
                           MOVE PR-ZIP-CODE TO DY-ZIP-CODE              
                           MOVE PR-ZIP-CODE-PLUS-FOUR TO                
                                DY-ZIP-CODE-PLUS-FOUR                   
                           MOVE PR-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN  
                           MOVE 'F' TO DY-ADDR-USAGE-CD                 
                           MOVE PR-USPS-DELIV-PT-CD TO                  
                                DY-USPS-DELIV-PT-CD                     
                           MOVE PR-ADDRESS-OVERFLOW TO                  
                                DY-ADDRESS-OVERFLOW                     
                           PERFORM 8010-INSERT-FMT-ADDR THRU 8010-EXIT  
                       END-IF                                           
                   ELSE                                                 
                       MOVE WS-SHARED-LL-ADDR-ID TO WS-NEW-ADDR-ID-NUM  
                   END-IF                                               
                   MOVE WS-NEW-ADDR-ID-NUM TO SI-ADDRESS-ID             
                   MOVE 'A' TO SI-ADDRESS-FORMAT                        
           END-EVALUATE.                                                
           PERFORM 8110-UPDATE-LANDLORD THRU 8110-EXIT.                 
                                                                        
           MOVE SI-PREMISE-NO TO MH-PREMISE-NO.                         
           MOVE ZEROES TO MH-ACCOUNT-NO.                                
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
A05317     MOVE 'PANEL062' TO MH-APPL-PROGRAM-ID.                       
                                                                        
           IF WS-OLD-SI-ADDR-ID NOT = SI-ADDRESS-ID                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +13                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +13                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE SI-ADDRESS-ID          TO WS-DISPLAY-ADDR            
              MOVE WS-DISPLAY-ADDR        TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE WS-OLD-SI-ADDR-ID-CHAR TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'LL ADDRESS ID'        TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
                                                                        
A05317        IF WS-UPDATE-TYPE = 'D'                                   
A05317            MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO            
A05317            MOVE +75                TO MI-PRV-COLUMN-VALUE-LEN    
A05317            MOVE +75                TO MI-CHG-COLUMN-VALUE-LEN    
A05317            MOVE PR-ADDRESS-LINE    TO MI-CHG-COLUMN-VALUE-TEXT   
A05317            EVALUATE SI-ADDRESS-FORMAT                            
A05317                WHEN 'A'                                          
A05317                    MOVE SI-ADDRESS-LINE-FMT TO                   
A05317                         MI-PRV-COLUMN-VALUE-TEXT                 
A05317                WHEN 'B'                                          
A05317                    MOVE SI-ADDRESS-LINE-FRE TO                   
A05317                         MI-PRV-COLUMN-VALUE-TEXT                 
A05317            END-EVALUATE                                          
A05317            MOVE 'LL ADDRESS'    TO MI-COLUMN-DESC                
A05317            PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
A05317            ADD 1 TO WS-TRAN-APPL-NO
              END-IF
           END-IF.                             
                                                                        
           GO TO 3040-FETCH-ROWS.                                       
                                                                        
       3040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * IF THE CUSTOMER IS A LANDLORD, UPDATE ALL LANDLORD ROWS WITH            
      * THE NEW BILL ADDRESS. IF WE'RE DELETING, CREATE A COPY OF THE           
      * PREMISE ADDRESS.                                                        
                                                                        
       3050-LANDLORD-FOR-ALL.                                           
                                                                        
           EVALUATE WS-UPDATE-TYPE                                      
               WHEN 'I'                                                 
               WHEN 'U'                                                 
                   MOVE AT-ADDRESS-ID TO SI-ADDRESS-ID                  
                   MOVE AT-ADDRESS-FORMAT TO SI-ADDRESS-FORMAT          
               WHEN 'D'                                                 
                   PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT       
                   MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM      
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                   MOVE WS-NEW-ADDR-ID-NUM TO DY-ADDRESS-ID             
                                              SI-ADDRESS-ID             
                   MOVE PR-HOUSE-NO TO DY-HOUSE-NO                      
                   MOVE PR-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1            
                   MOVE PR-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2            
                   MOVE PR-STREET-NAME TO DY-STREET-NAME                
                   MOVE PR-STREET-SUFFIX TO DY-STREET-SUFFIX            
                   MOVE PR-ADDR-SUFFIX TO DY-ADDR-SUFFIX                
                   MOVE PR-STREET-LOCATION-1 TO DY-STREET-LOCATION-1    
                   MOVE PR-STREET-LOCATION-2 TO DY-STREET-LOCATION-2    
                   MOVE PR-ZIP-CODE TO DY-ZIP-CODE                      
                   MOVE PR-ZIP-CODE-PLUS-FOUR TO DY-ZIP-CODE-PLUS-FOUR  
                   MOVE PR-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN          
                   MOVE 'F' TO DY-ADDR-USAGE-CD                         
                   MOVE PR-USPS-DELIV-PT-CD TO DY-USPS-DELIV-PT-CD      
                   MOVE PR-ADDRESS-OVERFLOW TO DY-ADDRESS-OVERFLOW      
                   PERFORM 8010-INSERT-FMT-ADDR THRU 8010-EXIT          
                   MOVE 'A' TO SI-ADDRESS-FORMAT                        
           END-EVALUATE.                                                
           PERFORM 8130-UPDATE-LL-ALL THRU 8130-EXIT.                   
                                                                        
       3050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3060-CHECK-FOR-FF-MATCH.                                         
                                                                        
           MOVE 'N' TO WS-FF-MATCH-FOUND-FL.                            
           MOVE LINK-FF-STREET-1 TO DZ-ADDR-STREET.                     
           MOVE LINK-FF-STREET-2 TO DZ-ADDRESS-OVERFLOW.                
           MOVE LINK-FF-CITY-STATE TO DZ-ADDR-CITY-STATE.               
           MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE.                   
           MOVE LINK-FF-COUNTRY TO DZ-ADDR-COUNTRY.                     
           PERFORM 7030-EXACT-FF-MATCH THRU 7030-EXIT.                  
                                                                        
       3060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-ADDRESS.                                             
                                                                        
           MOVE ZEROES TO S-ADDRESS-ID.                                 
           MOVE AT-ADDRESS-ID TO WS-OLD-BILL-ADDR-ID.                   
           PERFORM 7090-COUNT-ACCOUNTS THRU 7090-EXIT.                  
                                                                        
           PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT.            
           PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT.            
                                                                        
      * IF THE ADDRESS FORMAT HAS CHANGED, PERFORM MATCHING LOGIC ON            
      * THE INPUT ADDRESS INFO. IF A MATCH IS FOUND, USE THAT ADDRESS           
      * ID. IF NOT, INSERT A NEW ADDRESS ROW.                                   
                                                                        
           IF ADDR-CHANGED                                              
               IF AFMT-CHANGED                                          
                   EVALUATE LINK-ADDRESS-FORMAT                         
                       WHEN 'A'                                         
                           PERFORM 3005-CHECK-FOR-FMT-MATCH THRU        
                                   3005-EXIT                            
                           IF WS-FMT-MATCH-FOUND-FL = 'Y'               
                               MOVE DY-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM 
                           ELSE                                         
                               PERFORM 6202-GET-NEW-ADDRESS-ID THRU     
                                       6202-EXIT                        
                               MOVE WS-90-NEW-ADDRESS-ID TO             
                                    WS-NEW-ADDR-ID-NUM                  
                               MOVE WS-NEW-ADDR-ID-NUM TO DY-ADDRESS-ID 
                               PERFORM 3020-INSERT-FMT-ADDRESS THRU     
                                       3020-EXIT                        
                           END-IF                                       
                       WHEN 'B'                                         
                           PERFORM 3060-CHECK-FOR-FF-MATCH THRU         
                                   3060-EXIT                            
                           IF WS-FF-MATCH-FOUND-FL = 'Y'                
                               MOVE DZ-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM 
                           ELSE                                         
                               PERFORM 6202-GET-NEW-ADDRESS-ID THRU     
                                       6202-EXIT                        
                               MOVE WS-90-NEW-ADDRESS-ID TO             
                                    WS-NEW-ADDR-ID-NUM                  
                               MOVE WS-NEW-ADDR-ID-NUM TO DZ-ADDRESS-ID 
                               PERFORM 3010-INSERT-FF-ADDRESS THRU      
                                       3010-EXIT                        
                           END-IF                                       
                   END-EVALUATE                                         
                   MOVE WS-NEW-ADDR-ID-NUM TO AT-ADDRESS-ID             
                   MOVE LINK-ADDRESS-FORMAT TO AT-ADDRESS-FORMAT        
                   PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT           
                   IF WS-INTERNATIONAL-FL = 'Y'                         
                       MOVE 'D' TO AT-CODE-PERM-BILL                    
                   ELSE                                                 
                       MOVE 'A' TO AT-CODE-PERM-BILL                    
                   END-IF                                               
                   PERFORM 8030-UPDATE-PULL-CODE THRU 8030-EXIT         
               ELSE                                                     
                   EVALUATE LINK-ADDRESS-FORMAT                         
                       WHEN 'A'                                         
                           IF WS-ACCOUNT-CT > 1                         
                               PERFORM 3110-FORMATTED-UPDATE THRU       
                                       3110-EXIT                        
                           ELSE                                         
                               PERFORM 8400-UPDATE-FMT-ADDRESS THRU     
                                       8400-EXIT                        
                           END-IF                                       
                       WHEN 'B'                                         
                           IF WS-ACCOUNT-CT > 1                         
                               PERFORM 3120-FREEFORM-UPDATE THRU        
                                       3120-EXIT                        
                           ELSE                                         
                               PERFORM 8390-UPDATE-FF-ADDRESS THRU      
                                       8390-EXIT                        
                           END-IF                                       
                   END-EVALUATE
               END-IF
           END-IF.                                        
                                                                        
           IF WS-NEW-ADDR-ID-NUM NOT = WS-OLD-BILL-ADDR-ID              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-NEW-ADDR-ID-CHAR   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE WS-OLD-BILL-ADDR-CHAR TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDRESS ID'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * THE ADDRESS FORMAT HAS NOT CHANGED, AND THE CUSTOMER HAS                
      * MORE THAN ONE ACCOUNT. NEED TO PERFORM MATCHING LOGIC ON THE            
      * INPUT ADDRESS INFO.                                                     
      * CAN'T UPDATE EXISTING ADDRESS DATA BECAUSE IT COULD BE USED ON          
      * ANOTHER OF THE CUSTOMER'S ACCOUNTS.                                     
                                                                        
       3110-FORMATTED-UPDATE.                                           
                                                                        
           PERFORM 3005-CHECK-FOR-FMT-MATCH THRU 3005-EXIT.             
           IF WS-FMT-MATCH-FOUND-FL = 'Y'                               
               MOVE DY-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM                 
                                     AT-ADDRESS-ID                      
           ELSE                                                         
               PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT           
               MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM          
               MOVE WS-NEW-ADDR-ID-NUM TO AT-ADDRESS-ID                 
               PERFORM 3020-INSERT-FMT-ADDRESS THRU 3020-EXIT
           END-IF.          
                                                                        
           MOVE LINK-ADDRESS-FORMAT TO AT-ADDRESS-FORMAT.               
           PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT.                  
           PERFORM 8120-UPDATE-ADDR-XREF THRU 8120-EXIT.                
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3120-FREEFORM-UPDATE.                                            
                                                                        
           PERFORM 3060-CHECK-FOR-FF-MATCH THRU 3060-EXIT.              
           IF WS-FF-MATCH-FOUND-FL = 'Y'                                
               MOVE DZ-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM                 
                                     AT-ADDRESS-ID                      
           ELSE                                                         
               PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT           
               MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM          
               MOVE WS-NEW-ADDR-ID-NUM TO AT-ADDRESS-ID                 
               PERFORM 3010-INSERT-FF-ADDRESS THRU 3010-EXIT
           END-IF.           
                                                                        
           MOVE LINK-ADDRESS-FORMAT TO AT-ADDRESS-FORMAT.               
           PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT.                  
           PERFORM 8120-UPDATE-ADDR-XREF THRU 8120-EXIT.                
                                                                        
           IF WS-INTERNATIONAL-FL = 'Y'                                 
               MOVE 'D' TO AT-CODE-PERM-BILL                            
           ELSE                                                         
               MOVE 'A' TO AT-CODE-PERM-BILL
           END-IF.                           
           PERFORM 8030-UPDATE-PULL-CODE THRU 8030-EXIT.                
                                                                        
       3120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-DELETE-ADDRESS.                                             
                                                                        
           MOVE ZEROES TO S-ADDRESS-ID.                                 
           MOVE AT-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM.                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE WS-NEW-ADDR-ID-CHAR   TO MI-PRV-COLUMN-VALUE-TEXT       
           EVALUATE AT-ADDRESS-FORMAT                                   
               WHEN 'A'                                                 
                   MOVE 'ADDR FORMATTED' TO MI-COLUMN-DESC              
               WHEN 'B'                                                 
                   MOVE 'ADDR FREEFORM' TO MI-COLUMN-DESC               
           END-EVALUATE                                                 
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE AT-ADDRESS-FORMAT     TO MI-PRV-COLUMN-VALUE-TEXT       
           MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC                 
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE WS-NEW-ADDR-ID-CHAR   TO MI-PRV-COLUMN-VALUE-TEXT       
           MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'ADDRESS ID'          TO MI-COLUMN-DESC                 
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF LINK-ACCOUNT-UPDATE-CD = 'ALL'                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE 'ALL'                 TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SPACES                TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'UPDATE FLAG'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           MOVE ZEROES TO AT-ADDRESS-ID.                                
           MOVE SPACES TO AT-ADDRESS-FORMAT.                            
           PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT.                  
           PERFORM 8430-DELETE-ADDR-XREF THRU 8430-EXIT.                
           IF AT-CODE-PERM-BILL = 'D'                                   
               MOVE 'A' TO AT-CODE-PERM-BILL                            
               PERFORM 8030-UPDATE-PULL-CODE THRU 8030-EXIT
           END-IF.            
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT233 4210-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT233        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT233        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT233                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT233                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT233             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT233             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF LINK-ADDRESS-FORMAT > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDRESS-FORMAT   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-STREET-1 > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +55                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-STREET-1      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR STREET 1'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-STREET-2 > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +55                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-STREET-2      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR STREET 2'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-CITY-STATE > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-CITY-STATE    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR CITY/ST'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-ZIP-CODE > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-ZIP-CODE      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR ZIPCODE'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-COUNTRY > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-COUNTRY       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR COUNTRY'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOUSE-NO > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-HOUSE-NO         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-PREFIX-1 > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-PREFIX-1    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-PREFIX-2 > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-PREFIX-2    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-NAME > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-NAME      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-SUFFIX > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-SUFFIX    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-SUFFIX > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-SUFFIX      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-LOC-1 > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-LOC-1     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET LOC 1'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-LOC-2 > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-LOC-2     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET LOC 2'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TOWN > SPACES                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +26                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TOWN             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'TOWN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STATE > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STATE            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STATE'               TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ZIP-CODE > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ZIP-CODE-4 > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE-4       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE 4'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-USPS-DELIV-PT > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-USPS-DELIV-PT    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DELIVERY PT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-OVERFLOW > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-OVERFLOW         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OVERFLOW'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ACCOUNT-UPDATE-CD = 'ALL'                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE 'ALL'                 TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SPACES                TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'UPDATE FLAG'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE +13                      TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE WS-NEW-ADDR-ID-CHAR      TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE 'ADDRESS ID'             TO MI-COLUMN-DESC.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF AT-ADDRESS-FORMAT NOT = LINK-ADDRESS-FORMAT               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
                                            WS-AFMT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDRESS-FORMAT > SPACES                           
                 EVALUATE LINK-ADDRESS-FORMAT                           
                     WHEN 'A'                                           
                         MOVE 'FORMATTED'   TO MI-CHG-COLUMN-VALUE-TEXT 
                         MOVE +9            TO MI-CHG-COLUMN-VALUE-LEN  
                     WHEN 'B'                                           
                         MOVE 'FREEFORM'    TO MI-CHG-COLUMN-VALUE-TEXT 
                         MOVE +8            TO MI-CHG-COLUMN-VALUE-LEN  
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF AT-ADDRESS-FORMAT > SPACES                             
                 EVALUATE AT-ADDRESS-FORMAT                             
                     WHEN 'A'                                           
                         MOVE 'FORMATTED'   TO MI-PRV-COLUMN-VALUE-TEXT 
                         MOVE +9            TO MI-PRV-COLUMN-VALUE-LEN  
                     WHEN 'B'                                           
                         MOVE 'FREEFORM'    TO MI-PRV-COLUMN-VALUE-TEXT 
                         MOVE +8            TO MI-PRV-COLUMN-VALUE-LEN  
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-STREET NOT = LINK-FF-STREET-1                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-STREET-1 > SPACES                              
                 MOVE +55                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-STREET-1   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-STREET > SPACES                                
                 MOVE +55                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-STREET     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW NOT = LINK-FF-STREET-2                
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-STREET-2 > SPACES                              
                 MOVE +55                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-STREET-2   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +55                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDRESS-OVERFLOW TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-CITY-STATE NOT = LINK-FF-CITY-STATE               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-CITY-STATE > SPACES                            
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-CITY-STATE TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-CITY-STATE > SPACES                            
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-CITY-STATE TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CITY STATE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-ZIP-CODE NOT = LINK-FF-ZIP-CODE                   
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-ZIP-CODE   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-ZIP-CODE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR ZIP CODE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-COUNTRY NOT = LINK-FF-COUNTRY                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-COUNTRY > SPACES                               
                 MOVE +35                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-COUNTRY    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-COUNTRY > SPACES                               
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-COUNTRY    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'COUNTRY'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-HOUSE-NO NOT = LINK-HOUSE-NO                           
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-HOUSE-NO > SPACES                                 
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-HOUSE-NO      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-HOUSE-NO > SPACES                                   
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-HOUSE-NO        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-1 NOT = LINK-ADDR-PREFIX-1                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-1 > SPACES                            
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-1 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-PREFIX-1 > SPACES                              
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-PREFIX-1   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-2 NOT = LINK-ADDR-PREFIX-2                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-2 > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-2 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-PREFIX-2 > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-PREFIX-2   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-NAME NOT = LINK-STREET-NAME                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-NAME > SPACES                              
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-NAME   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-NAME > SPACES                                
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-SUFFIX NOT = LINK-STREET-SUFFIX                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-SUFFIX > SPACES                            
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-SUFFIX > SPACES                              
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-SUFFIX   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-SUFFIX NOT = LINK-ADDR-SUFFIX                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-SUFFIX > SPACES                              
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-SUFFIX   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-SUFFIX > SPACES                                
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-SUFFIX     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-1 NOT = LINK-STREET-LOC-1              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOC-1 > SPACES                             
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOC-1  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-LOCATION-1 > SPACES                          
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-LOCATION-1 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 1'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-2 NOT = LINK-STREET-LOC-2              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOC-2 > SPACES                             
                 MOVE +11                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOC-2  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-LOCATION-2 > SPACES                          
                 MOVE +11                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-LOCATION-2 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 2'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE NOT = LINK-ZIP-CODE                           
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE > SPACES                                 
                 MOVE +5                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ZIP-CODE > SPACES                                   
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ZIP-CODE        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE-PLUS-FOUR NOT = LINK-ZIP-CODE-4               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE-4 > SPACES                               
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE-4    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ZIP-CODE-PLUS-FOUR > SPACES                         
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ZIP-CODE-PLUS-FOUR TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE +4'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-USPS-DELIV-PT-CD NOT = LINK-USPS-DELIV-PT              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-USPS-DELIV-PT > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-USPS-DELIV-PT TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-USPS-DELIV-PT-CD > SPACES                           
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-USPS-DELIV-PT-CD TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DELIVERY PT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDRESS-OVERFLOW NOT = LINK-OVERFLOW                   
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OVERFLOW > SPACES                                 
                 MOVE +35                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OVERFLOW      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDRESS-OVERFLOW TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OVERFLOW'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-ACCOUNT-UPDATE-CD = 'ALL'                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE 'ALL'                 TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE SPACES                TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'UPDATE FLAG'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * HOLD THE EXISTING ADDRESS DATA IN WORKING STORAGE                       
                                                                        
       5800-GET-BASELINE-DETAILS.                                       
                                                                        
           EVALUATE AT-ADDRESS-FORMAT                                   
               WHEN 'A'                                                 
                   PERFORM 7040-SELECT-FMT-ADDRESS THRU 7040-EXIT       
                   MOVE DY-HOUSE-NO TO BA-HOUSE-NO                      
                   MOVE DY-ADDR-PREFIX-1 TO BA-ADDR-PREFIX-1            
                   MOVE DY-ADDR-PREFIX-2 TO BA-ADDR-PREFIX-2            
                   MOVE DY-STREET-NAME TO BA-STREET-NAME                
                   MOVE DY-STREET-SUFFIX TO BA-STREET-SUFFIX            
                   MOVE DY-STREET-LOCATION-1 TO BA-STREET-LOCATION-1    
                   MOVE DY-STREET-LOCATION-2 TO BA-STREET-LOCATION-2    
                   MOVE DY-ADDR-SUFFIX TO BA-ADDR-SUFFIX                
                   MOVE DY-ZIP-CODE TO BA-ZIP-CODE                      
                   MOVE DY-ZIP-CODE-TOKEN TO BA-ZIP-CODE-TOKEN          
                   MOVE DY-ADDRESS-OVERFLOW TO BA-OVERFLOW-FMT          
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
                              BA-ADDR-FREEFORM                          
               WHEN 'B'                                                 
                   PERFORM 7060-SELECT-FF-ADDRESS THRU 7060-EXIT        
                   MOVE DZ-ADDR-STREET TO BA-ADDR-STREET                
                   MOVE DZ-ADDR-CITY-STATE TO BA-ADDR-CITY-STATE        
                   MOVE DZ-ADDR-ZIP-CODE TO BA-ADDR-ZIP-CODE            
                   MOVE DZ-ADDR-COUNTRY TO BA-ADDR-COUNTRY              
                   MOVE DZ-ADDRESS-OVERFLOW TO BA-ADDRESS-OVERFLOW      
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                              BA-ADDR-FORMATTED                         
           END-EVALUATE.                                                
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AT.CUSTOMER_NO,
              AT.ADDRESS_ID,
              AT.ADDRESS_FORMAT,
              NAME_ID,
              AT.PREMISE_NO,
              PR.LOCAL_OFFICE,
              PR.ADDRESS_ID,
              CODE_PERM_BILL,
              AT.COMPANY_NO,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              DY.ZIP_CODE,
              DY.ZIP_CODE_TOKEN,
              ADDR_SUFFIX,
              ZIP_CODE_PLUS_FOUR,
              USPS_DELIV_PT_CD,
              ADDRESS_OVERFLOW,
              RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE) + ' ' + 
           LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))               
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT,                                
                     :CU-NAME-ID,                                       
                     :AT-PREMISE-NO,                                    
                     :PR-LOCAL-OFFICE,                                  
                     :PR-ADDRESS-ID,                                    
                     :AT-CODE-PERM-BILL,                                
                     :AT-COMPANY-NO,                                    
                     :PR-HOUSE-NO,                                      
                     :PR-ADDR-PREFIX-1,                                 
                     :PR-ADDR-PREFIX-2,                                 
                     :PR-STREET-NAME,                                   
                     :PR-STREET-SUFFIX,                                 
                     :PR-STREET-LOCATION-1,                             
                     :PR-STREET-LOCATION-2,                             
                     :PR-ZIP-CODE,                                      
                     :PR-ZIP-CODE-TOKEN,                                
                     :PR-ADDR-SUFFIX,                                   
                     :PR-ZIP-CODE-PLUS-FOUR,                            
                     :PR-USPS-DELIV-PT-CD,                              
                     :PR-ADDRESS-OVERFLOW,                              
A05317               :PR-ADDRESS-LINE                                   
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_PREMISE PR WITH(READUNCOMMITTED),                      
A05317               CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
A05317               CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                    
                 AND AT.PREMISE_NO = PR.PREMISE_NO                      
                 AND PR.ADDRESS_ID = DY.ADDRESS_ID                      
A05317           AND DY.ZIP_CODE = A4.ZIP_CODE                          
A05317           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO,                                            
MFA-TR*              AT.ADDRESS_ID,                                             
MFA-TR*              AT.ADDRESS_FORMAT,                                         
MFA-TR*              NAME_ID,                                                   
MFA-TR*              AT.PREMISE_NO,                                             
MFA-TR*              PR.LOCAL_OFFICE,                                           
MFA-TR*              PR.ADDRESS_ID,                                             
MFA-TR*              CODE_PERM_BILL,                                            
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              USPS_DELIV_PT_CD,                                          
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                    
MFA-TR*              LTRIM(RTRIM(TOWN) || ', ' ||                               
MFA-TR*              LTRIM(RTRIM(STATE) || ' ' ||                               
MFA-TR*              LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))                       
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-ADDRESS-ID,                                            
MFA-TR*              :AT-ADDRESS-FORMAT,                                        
MFA-TR*              :CU-NAME-ID,                                               
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :PR-LOCAL-OFFICE,                                          
MFA-TR*              :PR-ADDRESS-ID,                                            
MFA-TR*              :AT-CODE-PERM-BILL,                                        
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :PR-HOUSE-NO,                                              
MFA-TR*              :PR-ADDR-PREFIX-1,                                         
MFA-TR*              :PR-ADDR-PREFIX-2,                                         
MFA-TR*              :PR-STREET-NAME,                                           
MFA-TR*              :PR-STREET-SUFFIX,                                         
MFA-TR*              :PR-STREET-LOCATION-1,                                     
MFA-TR*              :PR-STREET-LOCATION-2,                                     
MFA-TR*              :PR-ZIP-CODE,                                              
MFA-TR*              :PR-ZIP-CODE-TOKEN,                                        
MFA-TR*              :PR-ADDR-SUFFIX,                                           
MFA-TR*              :PR-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :PR-USPS-DELIV-PT-CD,                                      
MFA-TR*              :PR-ADDRESS-OVERFLOW,                                      
MFA-TR*              :PR-ADDRESS-LINE                                           
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_PREMISE PR,                                            
MFA-TR*              CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                            
MFA-TR*          AND AT.PREMISE_NO = PR.PREMISE_NO                              
MFA-TR*          AND PR.ADDRESS_ID = DY.ADDRESS_ID                              
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-TOKEN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'TOWN'               TO TABLE-ELEMENT-1         
                   MOVE A4-TOWN              TO HOSTVAR-ELEMENT-1       
                   MOVE 'STATE'              TO TABLE-ELEMENT-2         
                   MOVE A4-STATE             TO HOSTVAR-ELEMENT-2       
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-3         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-3       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-EXACT-FMT-MATCH.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DY.ADDRESS_ID                                      
                INTO :DY-ADDRESS-ID                                     
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                   
                 AND AT.ADDRESS_ID > 0                                  
                 AND ADDRESS_FORMAT = 'A'                               
                 AND AT.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND HOUSE_NO = :DY-HOUSE-NO                            
                 AND ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1                  
                 AND ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2                  
                 AND STREET_NAME = :DY-STREET-NAME                      
                 AND STREET_SUFFIX = :DY-STREET-SUFFIX                  
                 AND STREET_LOCATION_1 = :DY-STREET-LOCATION-1          
                 AND STREET_LOCATION_2 = :DY-STREET-LOCATION-2          
                 AND ADDR_SUFFIX = :DY-ADDR-SUFFIX                      
                 AND ZIP_CODE = :DY-ZIP-CODE                            
                 AND ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                
                 AND ADDRESS_OVERFLOW = :DY-ADDRESS-OVERFLOW            
                 AND ADDR_USAGE_CD = 'F'                                
                 AND NOT EXISTS (                                       
                     SELECT '1'                                         
                       FROM CSS_PREMISE WITH(READUNCOMMITTED)                   
                      WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DY.ADDRESS_ID                                              
MFA-TR*         INTO :DY-ADDRESS-ID                                             
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                           
MFA-TR*          AND AT.ADDRESS_ID > 0                                          
MFA-TR*          AND ADDRESS_FORMAT = 'A'                                       
MFA-TR*          AND AT.ADDRESS_ID = DY.ADDRESS_ID                              
MFA-TR*          AND HOUSE_NO = :DY-HOUSE-NO                                    
MFA-TR*          AND ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1                          
MFA-TR*          AND ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2                          
MFA-TR*          AND STREET_NAME = :DY-STREET-NAME                              
MFA-TR*          AND STREET_SUFFIX = :DY-STREET-SUFFIX                          
MFA-TR*          AND STREET_LOCATION_1 = :DY-STREET-LOCATION-1                  
MFA-TR*          AND STREET_LOCATION_2 = :DY-STREET-LOCATION-2                  
MFA-TR*          AND ADDR_SUFFIX = :DY-ADDR-SUFFIX                              
MFA-TR*          AND ZIP_CODE = :DY-ZIP-CODE                                    
MFA-TR*          AND ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                        
MFA-TR*          AND ADDRESS_OVERFLOW = :DY-ADDRESS-OVERFLOW                    
MFA-TR*          AND ADDR_USAGE_CD = 'F'                                        
MFA-TR*          AND NOT EXISTS (                                               
MFA-TR*              SELECT '1'                                                 
MFA-TR*                FROM CSS_PREMISE                                         
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-FMT-MATCH-FOUND-FL                    
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-FMT-MATCH-FOUND-FL                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ACCOUNT'        TO TABLE-2                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-EXACT-FF-MATCH.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DZ.ADDRESS_ID                                      
                INTO :DZ-ADDRESS-ID                                     
                FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED),                
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                   
                 AND AT.ADDRESS_ID > 0                                  
                 AND ADDRESS_FORMAT = 'B'                               
                 AND AT.ADDRESS_ID = DZ.ADDRESS_ID                      
                 AND ADDR_STREET = :DZ-ADDR-STREET                      
                 AND ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW            
                 AND ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE              
                 AND ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE                  
                 AND ADDR_COUNTRY = :DZ-ADDR-COUNTRY                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DZ.ADDRESS_ID                                              
MFA-TR*         INTO :DZ-ADDRESS-ID                                             
MFA-TR*         FROM CSS_ADDR_FREEFORM DZ,                                      
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                           
MFA-TR*          AND AT.ADDRESS_ID > 0                                          
MFA-TR*          AND ADDRESS_FORMAT = 'B'                                       
MFA-TR*          AND AT.ADDRESS_ID = DZ.ADDRESS_ID                              
MFA-TR*          AND ADDR_STREET = :DZ-ADDR-STREET                              
MFA-TR*          AND ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW                    
MFA-TR*          AND ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE                      
MFA-TR*          AND ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE                          
MFA-TR*          AND ADDR_COUNTRY = :DZ-ADDR-COUNTRY                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-FF-MATCH-FOUND-FL                     
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-FF-MATCH-FOUND-FL                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                 
                   MOVE 'CSS_ACCOUNT'        TO TABLE-2                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-FMT-ADDRESS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              STREET_SUFFIX,
              DY.ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              ADDR_SUFFIX,
              USPS_DELIV_PT_CD,
              TOWN,
              STATE,
              ADDRESS_OVERFLOW                                   
                INTO :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-SUFFIX,                                 
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
                     :DY-ADDR-SUFFIX,                                   
                     :DY-USPS-DELIV-PT-CD,                              
                     :A4-TOWN,                                          
                     :A4-STATE,                                         
                     :DY-ADDRESS-OVERFLOW                               
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              USPS_DELIV_PT_CD,                                          
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE,                                                     
MFA-TR*              ADDRESS_OVERFLOW                                           
MFA-TR*         INTO :DY-HOUSE-NO,                                              
MFA-TR*              :DY-ADDR-PREFIX-1,                                         
MFA-TR*              :DY-ADDR-PREFIX-2,                                         
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-USPS-DELIV-PT-CD,                                      
MFA-TR*              :A4-TOWN,                                                  
MFA-TR*              :A4-STATE,                                                 
MFA-TR*              :DY-ADDRESS-OVERFLOW                                       
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-2                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE AT-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY                                       
                INTO :DZ-ADDR-STREET,                                   
                     :DZ-ADDRESS-OVERFLOW,                              
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY                                   
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY                                               
MFA-TR*         INTO :DZ-ADDR-STREET,                                           
MFA-TR*              :DZ-ADDRESS-OVERFLOW,                                      
MFA-TR*              :DZ-ADDR-CITY-STATE,                                       
MFA-TR*              :DZ-ADDR-ZIP-CODE,                                         
MFA-TR*              :DZ-ADDR-COUNTRY                                           
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE AT-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-ADDRESS-ID       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-COUNT-ACCOUNTS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-ACCOUNT-CT                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-ACCOUNT-CT                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-ACCOUNT-CT                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-FMT-SI-ADDRESS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              STREET_SUFFIX,
              DY.ZIP_CODE,
              DY.ZIP_CODE_TOKEN,
              ADDR_SUFFIX,
              ADDRESS_OVERFLOW,
              RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE) + ' ' + 
           LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))               
                INTO :SI-HOUSE-NO,                                      
                     :SI-ADDR-PREFIX-1,                                 
                     :SI-ADDR-PREFIX-2,                                 
                     :SI-STREET-NAME,                                   
                     :SI-STREET-LOCATION-1,                             
                     :SI-STREET-LOCATION-2,                             
                     :SI-STREET-SUFFIX,                                 
                     :SI-ZIP-CODE,                                      
                     :SI-ZIP-CODE-TOKEN,                                
                     :SI-ADDR-SUFFIX,                                   
                     :SI-OVERFLOW-FMT,                                  
A05317               :SI-ADDRESS-LINE-FMT                               
                FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
A05317               CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE ADDRESS_ID = :SI-ADDRESS-ID                        
A05317           AND DY.ZIP_CODE = A4.ZIP_CODE                          
A05317           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                    
MFA-TR*              LTRIM(RTRIM(TOWN) || ', ' ||                               
MFA-TR*              LTRIM(RTRIM(STATE) || ' ' ||                               
MFA-TR*              LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))                       
MFA-TR*         INTO :SI-HOUSE-NO,                                              
MFA-TR*              :SI-ADDR-PREFIX-1,                                         
MFA-TR*              :SI-ADDR-PREFIX-2,                                         
MFA-TR*              :SI-STREET-NAME,                                           
MFA-TR*              :SI-STREET-LOCATION-1,                                     
MFA-TR*              :SI-STREET-LOCATION-2,                                     
MFA-TR*              :SI-STREET-SUFFIX,                                         
MFA-TR*              :SI-ZIP-CODE,                                              
MFA-TR*              :SI-ZIP-CODE-TOKEN,                                        
MFA-TR*              :SI-ADDR-SUFFIX,                                           
MFA-TR*              :SI-OVERFLOW-FMT,                                          
MFA-TR*              :SI-ADDRESS-LINE-FMT                                       
MFA-TR*         FROM CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE ADDRESS_ID = :SI-ADDRESS-ID                                
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE SI-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-FF-SI-ADDRESS.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY,
              RTRIM(LTRIM(RTRIM(ADDR_STREET) + ' ' + LTRIM(RTRIM(
           ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(ADDR_CITY_STATE) + 
           ' ' + LTRIM(RTRIM(ADDR_ZIP_CODE) + ' ' + LTRIM(RTRIM(
           ADDR_COUNTRY)))))))                    
                INTO :SI-ADDR-STREET,                                   
                     :SI-ADDRESS-OVERFLOW,                              
                     :SI-ADDR-CITY-STATE,                               
                     :SI-ADDR-ZIP-CODE,                                 
                     :SI-ADDR-COUNTRY,                                  
A05317               :SI-ADDRESS-LINE-FRE                               
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :SI-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY,                                              
MFA-TR*              RTRIM(LTRIM(RTRIM(ADDR_STREET) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                    
MFA-TR*              LTRIM(RTRIM(ADDR_CITY_STATE) || ' ' ||                     
MFA-TR*              LTRIM(RTRIM(ADDR_ZIP_CODE) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_COUNTRY)))))))                            
MFA-TR*         INTO :SI-ADDR-STREET,                                           
MFA-TR*              :SI-ADDRESS-OVERFLOW,                                      
MFA-TR*              :SI-ADDR-CITY-STATE,                                       
MFA-TR*              :SI-ADDR-ZIP-CODE,                                         
MFA-TR*              :SI-ADDR-COUNTRY,                                          
MFA-TR*              :SI-ADDRESS-LINE-FRE                                       
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :SI-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE SI-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-VALIDATE-ZIP.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO A4-ZIP-CODE-TOKEN                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7120'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-1         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO                                        
                INTO :SI-CUSTOMER-NO                                    
                FROM CSS_LANDLORD WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*         INTO :SI-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_LANDLORD                                               
MFA-TR*        WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-LL-ROWS-FL                            
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-LL-ROWS-FL                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE SI-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-OPEN-LL-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN LL-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7510'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE SI-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'ADDRESS_ID'     TO TABLE-ELEMENT-2             
                   MOVE SI-ADDRESS-ID    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7511-CLOSE-LL-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE LL-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7511'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE SI-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'ADDRESS_ID'     TO TABLE-ELEMENT-2             
                   MOVE SI-ADDRESS-ID    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7511-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7850-CHECK-IAT-CATEGORY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-IAT-CAT-FOUND                                  
                FROM CSS_CATEGORY WITH(READUNCOMMITTED)                         
               WHERE USER_ID = :LINK-USERID                             
                 AND CATEGORY_ID = 327                                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-IAT-CAT-FOUND                                          
MFA-TR*         FROM CSS_CATEGORY                                               
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*          AND CATEGORY_ID = 327                                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7850                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-IAT-CAT-FOUND                           
                 MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                   
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE 'CSS_CATEGORY'            TO TABLE-1              
                 MOVE 'USER_ID'                 TO TABLE-ELEMENT-1      
                 MOVE LINK-USERID               TO HOSTVAR-ELEMENT-1    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-FF-ADDR.                                             
                                                                        
            EXEC SQL                                                    
               INSERT INTO CSS_ADDR_FREEFORM                            
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDRESS_OVERFLOW,                                  
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY)                                      
               VALUES                                                   
                    (:DZ-ADDRESS-ID,                                    
                     :DZ-ADDR-STREET,                                   
                     :DZ-ADDRESS-OVERFLOW,                              
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY)                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_STREET'        TO TABLE-ELEMENT-2              
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-STREET       TO HOSTVAR-ELEMENT-2            
              MOVE AT-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-INSERT-FMT-ADDR.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                   (ADDRESS_ID,                                         
                    HOUSE_NO,                                           
                    ADDR_PREFIX_1,                                      
                    ADDR_PREFIX_2,                                      
                    STREET_NAME,                                        
                    STREET_SUFFIX,                                      
                    STREET_LOCATION_1,                                  
                    STREET_LOCATION_2,                                  
                    ZIP_CODE,                                           
                    ZIP_CODE_PLUS_FOUR,                                 
                    ZIP_CODE_TOKEN,                                     
                    ADDR_SUFFIX,                                        
                    ADDR_USAGE_CD,                                      
                    USPS_DELIV_PT_CD,                                   
                    ADDRESS_OVERFLOW)                                   
              VALUES                                                    
                   (:DY-ADDRESS-ID,                                     
                    :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-SUFFIX,                                  
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-ADDR-SUFFIX,                                    
                    :DY-ADDR-USAGE-CD,                                  
                    :DY-USPS-DELIV-PT-CD,                               
                    :DY-ADDRESS-OVERFLOW)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'STREET_NAME'        TO TABLE-ELEMENT-2              
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DY-STREET-NAME       TO HOSTVAR-ELEMENT-2            
              MOVE AT-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-ADDR-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BILL_ADDR_XREF                            
                   (ACCOUNT_NO,                                         
                    ADDRESS_ID,                                         
                    NAME_ID,                                            
                    COMPANY_NO)                                         
              VALUES                                                    
                   (:AT-ACCOUNT-NO,                                     
                    :AT-ADDRESS-ID,                                     
                    :CU-NAME-ID,                                        
                    :AT-COMPANY-NO)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -803                                                
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8020'          TO ACTIVE-PARAGRAPH             
                   MOVE 'INSERT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_BILL_ADDR_XREF' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE 'ADDRESS_ID'    TO TABLE-ELEMENT-2              
                   MOVE AT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE AT-ADDRESS-ID   TO HOSTVAR-ELEMENT-3            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-UPDATE-PULL-CODE.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_PERM_BILL = :AT-CODE-PERM-BILL                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODE_PERM_BILL = :AT-CODE-PERM-BILL                        
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8330'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8090-UPDATE-ACCOUNT.                                             
                                                                        
           IF AT-ADDRESS-ID = 0                                         
               MOVE SPACES TO AT-ADDRESS-FORMAT
           END-IF.                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET ADDRESS_ID = :AT-ADDRESS-ID,                       
                     ADDRESS_FORMAT = :AT-ADDRESS-FORMAT                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET ADDRESS_ID = :AT-ADDRESS-ID,                               
MFA-TR*              ADDRESS_FORMAT = :AT-ADDRESS-FORMAT                        
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8090'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8110-UPDATE-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_LANDLORD                                       
                 SET ADDRESS_ID = :SI-ADDRESS-ID,                       
                     ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                
               WHERE CURRENT OF LL-CURSOR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8110'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_LANDLORD'       TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE SI-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8120-UPDATE-ADDR-XREF.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_BILL_ADDR_XREF                                 
                 SET ADDRESS_ID = :AT-ADDRESS-ID                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILL_ADDR_XREF                                         
MFA-TR*          SET ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8120'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_BILL_XREF' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8130-UPDATE-LL-ALL.                                              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_LANDLORD                                       
                 SET ADDRESS_ID = :SI-ADDRESS-ID,                       
                     ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_LANDLORD                                               
MFA-TR*          SET ADDRESS_ID = :SI-ADDRESS-ID,                               
MFA-TR*              ADDRESS_FORMAT = :SI-ADDRESS-FORMAT                        
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*        QUERYNO 8130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME     TO ABEND-PROGRAM                
                  MOVE '8130'           TO ACTIVE-PARAGRAPH             
                  MOVE 'UPDATE'         TO ABEND-FUNCTION               
                  MOVE 'CSS_LANDLORD'   TO TABLE-1                      
                  MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1              
                  MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1            
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8390-UPDATE-FF-ADDRESS.                                          
                                                                        
           MOVE LINK-FF-STREET-1 TO DZ-ADDR-STREET.                     
           MOVE LINK-FF-STREET-2 TO DZ-ADDRESS-OVERFLOW.                
           MOVE LINK-FF-CITY-STATE TO DZ-ADDR-CITY-STATE.               
           MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE.                   
           MOVE LINK-FF-COUNTRY TO DZ-ADDR-COUNTRY.                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FREEFORM                                  
                 SET ADDR_STREET = :DZ-ADDR-STREET,                     
                     ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE,             
                     ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE,                 
                     ADDR_COUNTRY = :DZ-ADDR-COUNTRY,                   
                     ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW            
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FREEFORM                                          
MFA-TR*          SET ADDR_STREET = :DZ-ADDR-STREET,                             
MFA-TR*              ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE,                     
MFA-TR*              ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE,                         
MFA-TR*              ADDR_COUNTRY = :DZ-ADDR-COUNTRY,                           
MFA-TR*              ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW                    
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*       QUERYNO 8390                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8390'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8390-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * THE ADDRESS FORMAT HAS NOT CHANGED, AND THE CUSTOMER HAS                
      * ONLY ONE ACCOUNT. CAN UPDATE THE ADDRESS EXISTING ADDRESS               
      * ROW.                                                                    
                                                                        
       8400-UPDATE-FMT-ADDRESS.                                         
                                                                        
           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO.                           
           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1.                 
           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2.                 
           MOVE LINK-STREET-NAME TO DY-STREET-NAME.                     
           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX.                 
           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX.                     
           MOVE LINK-STREET-LOC-1 TO DY-STREET-LOCATION-1.              
           MOVE LINK-STREET-LOC-2 TO DY-STREET-LOCATION-2.              
           MOVE LINK-ZIP-CODE TO DY-ZIP-CODE.                           
           MOVE LINK-ZIP-CODE-4 TO DY-ZIP-CODE-PLUS-FOUR.               
           MOVE LINK-TOWN TO A4-TOWN.                                   
           MOVE LINK-STATE TO A4-STATE.                                 
           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE.                           
           PERFORM 7010-GET-TOKEN THRU 7010-EXIT.                       
           MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN.                 
           MOVE LINK-OVERFLOW TO DY-ADDRESS-OVERFLOW.                   
           MOVE 'F' TO DY-ADDR-USAGE-CD.                                
           MOVE LINK-USPS-DELIV-PT TO DY-USPS-DELIV-PT-CD.              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FORMATTED                                 
                 SET HOUSE_NO = :DY-HOUSE-NO,                           
                     ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1,                 
                     ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2,                 
                     STREET_NAME = :DY-STREET-NAME,                     
                     STREET_LOCATION_1 = :DY-STREET-LOCATION-1,         
                     STREET_LOCATION_2 = :DY-STREET-LOCATION-2,         
                     STREET_SUFFIX = :DY-STREET-SUFFIX,                 
                     ZIP_CODE = :DY-ZIP-CODE,                           
                     ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,       
                     ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN,               
                     ADDR_SUFFIX = :DY-ADDR-SUFFIX,                     
                     USPS_DELIV_PT_CD = :DY-USPS-DELIV-PT-CD,           
                     ADDRESS_OVERFLOW = :DY-ADDRESS-OVERFLOW            
               WHERE ADDRESS_ID = :AT-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FORMATTED                                         
MFA-TR*          SET HOUSE_NO = :DY-HOUSE-NO,                                   
MFA-TR*              ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1,                         
MFA-TR*              ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2,                         
MFA-TR*              STREET_NAME = :DY-STREET-NAME,                             
MFA-TR*              STREET_LOCATION_1 = :DY-STREET-LOCATION-1,                 
MFA-TR*              STREET_LOCATION_2 = :DY-STREET-LOCATION-2,                 
MFA-TR*              STREET_SUFFIX = :DY-STREET-SUFFIX,                         
MFA-TR*              ZIP_CODE = :DY-ZIP-CODE,                                   
MFA-TR*              ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,               
MFA-TR*              ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN,                       
MFA-TR*              ADDR_SUFFIX = :DY-ADDR-SUFFIX,                             
MFA-TR*              USPS_DELIV_PT_CD = :DY-USPS-DELIV-PT-CD,                   
MFA-TR*              ADDRESS_OVERFLOW = :DY-ADDRESS-OVERFLOW                    
MFA-TR*        WHERE ADDRESS_ID = :AT-ADDRESS-ID                                
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8430-DELETE-ADDR-XREF.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_BILL_ADDR_XREF                            
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_BILL_ADDR_XREF                                    
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8430                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8430'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_BILL_ADDR_XREF' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE AT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD00004.                                               29740000
           EXEC SQL                                                     29740000
              INCLUDE CPD00071                                          29750000
           END-EXEC.                                                    29760000
           EXEC SQL                                                     29780000
              INCLUDE CPD00090                                          29790000
           END-EXEC.                                                    29800000
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
