       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04707.                                         
COB303 DATE-WRITTEN.  MARCH 26, 2014.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES CUSTOMER PHONE INFORMATION.              *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  03/26/14   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04707'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00970000
              INCLUDE TBCSTPHN                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01010000
              INCLUDE TBCSTSTS                                          01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01050000
              INCLUDE TBCUST                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04707'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CSTS-EXISTS                     VALUE 'YES'.          
           05  WS-PHONE-EXISTS-FLAG     PIC X(03) VALUE 'NO '.          
               88 PHONE-EXISTS                    VALUE 'YES'.          
           05  WS-HMPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 HMPH-EXISTS                     VALUE 'YES'.          
           05  WS-WKPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 WKPH-EXISTS                     VALUE 'YES'.          
           05  WS-ALPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ALPH-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-HOME-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-HOME-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-WORK-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXTENSION-NO     PIC X(06) VALUE SPACES.         
           05  WS-WORK-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-ALT-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-ALT-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-HMPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HMPH-CHANGED                    VALUE 'YES'.          
           05  WS-WKPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WKPH-CHANGED                    VALUE 'YES'.          
           05  WS-ALPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ALPH-CHANGED                    VALUE 'YES'.          
           05  WS-CSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CSTS-CHANGED                    VALUE 'YES'.          
           05  WS-HPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HPFL-CHANGED                    VALUE 'YES'.          
           05  WS-WPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WPFL-CHANGED                    VALUE 'YES'.          
           05  WS-APFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 APFL-CHANGED                    VALUE 'YES'.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-ALLOW-CALL-FL       PIC X(01).                          
       01  LINK-WORK-PHONE-NO       PIC X(10).                          
       01  LINK-WORK-PHONE-EXT      PIC X(06).                          
       01  LINK-WORK-MOBILE-FL      PIC X(01).                          
       01  LINK-WORK-MKT-FL         PIC X(01).                          
       01  LINK-HOME-PHONE-NO       PIC X(10).                          
       01  LINK-HOME-MOBILE-FL      PIC X(01).                          
       01  LINK-HOME-MKT-FL         PIC X(01).                          
       01  LINK-ALT-PHONE-NO        PIC X(10).                          
       01  LINK-ALT-MOBILE-FL       PIC X(01).                          
       01  LINK-ALT-MKT-FL          PIC X(01).                          
       01  LINK-EMPLOYER            PIC X(23).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO,                                       
                LINK-ALLOW-CALL-FL,                                     
                LINK-WORK-PHONE-NO,                                     
                LINK-WORK-PHONE-EXT,                                    
                LINK-WORK-MOBILE-FL,                                    
                LINK-WORK-MKT-FL,                                       
                LINK-HOME-PHONE-NO,                                     
                LINK-HOME-MOBILE-FL,                                    
                LINK-HOME-MKT-FL,                                       
                LINK-ALT-PHONE-NO,                                      
                LINK-ALT-MOBILE-FL,                                     
                LINK-ALT-MKT-FL,                                        
                LINK-EMPLOYER,                                          
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           IF LINK-ALLOW-CALL-FL = 'Y'                                  
               MOVE ' ' TO LINK-ALLOW-CALL-FL
           END-IF.                          
           IF LINK-WORK-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-WORK-PHONE-EXT                       
                              LINK-WORK-MOBILE-FL                       
                              LINK-WORK-MKT-FL
           END-IF.                         
           IF LINK-HOME-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-HOME-MOBILE-FL                       
                              LINK-HOME-MKT-FL
           END-IF.                         
           IF LINK-ALT-PHONE-NO <= SPACES                               
               MOVE SPACES TO LINK-ALT-MOBILE-FL                        
                              LINK-ALT-MKT-FL
           END-IF.                          
           PERFORM 7005-DETERMINE-DATABASE THRU 7005-EXIT.              
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-PREMISE-NO.              
           MOVE CU-CUSTOMER-NO           TO MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL087'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 'H1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-HOME-PHONE-NO            
              MOVE CB-MOBILE-PHONE-FL    TO WS-HOME-MOBILE-FL           
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-HOME-MKT-FL              
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-HOME-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-HOME-PHONE-NO            
                                            WS-HOME-MOBILE-FL           
                                            WS-HOME-MKT-FL              
                                            WS-HOME-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO' TO WS-PHONE-EXISTS-FLAG.                           
           MOVE 'W1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-WORK-PHONE-NO            
              MOVE CB-EXTENSION-NO       TO WS-WORK-EXTENSION-NO        
              MOVE CB-MOBILE-PHONE-FL    TO WS-WORK-MOBILE-FL           
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-WORK-MKT-FL              
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-WORK-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-WORK-PHONE-NO            
                                            WS-WORK-EXTENSION-NO        
                                            WS-WORK-MOBILE-FL           
                                            WS-WORK-MKT-FL              
                                            WS-WORK-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO'                     TO WS-PHONE-EXISTS-FLAG.       
           MOVE 'A1'                     TO WS-PHONE-TYPE.              
           PERFORM 7050-SELECT-PHONE          THRU 7050-EXIT.           
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-ALT-PHONE-NO             
              MOVE CB-MOBILE-PHONE-FL    TO WS-ALT-MOBILE-FL            
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-ALT-MKT-FL               
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-ALT-MKT-DT               
           ELSE                                                         
              MOVE SPACES                TO WS-ALT-PHONE-NO             
                                            WS-ALT-MOBILE-FL            
                                            WS-ALT-MKT-FL               
                                            WS-ALT-MKT-DT
           END-IF.              
                                                                        
           PERFORM 7030-SELECT-CUST-STATS THRU 7030-EXIT.               
           IF NOT CSTS-EXISTS                                           
               INITIALIZE DCLCSS-CUST-STATS
           END-IF.                            
                                                                        
           PERFORM 2100-TRANSACTION-HISTORY THRU 2100-EXIT.             
                                                                        
           IF CSTS-CHANGED                                              
               MOVE CU-CUSTOMER-NO TO CE-CUSTOMER-NO                    
               MOVE LINK-EMPLOYER TO CE-EMPLOYER                        
               MOVE LINK-ALLOW-CALL-FL TO CE-ALLOW-CALL-FL              
               IF CSTS-EXISTS                                           
                   PERFORM 8340-UPDATE-CSTS THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-CSTS THRU 8190-EXIT         
               ELSE                                                     
                   PERFORM 7020-SELECT-CUSTOMER THRU 7020-EXIT          
                   MOVE CU-NAME-ID TO CE-NAME-ID                        
                   MOVE 'C' TO CE-CUSTOMER-TYPE                         
                   PERFORM 8050-INSERT-CUST-STATS THRU 8050-EXIT
               END-IF
           END-IF.       
                                                                        
           IF HMPH-CHANGED                                              
              MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'H1' TO CB-PHONE-TYPE                                
              MOVE LINK-HOME-PHONE-NO TO CB-PHONE-NO                    
              MOVE SPACES TO CB-EXTENSION-NO                            
              MOVE LINK-HOME-MOBILE-FL TO CB-MOBILE-PHONE-FL            
              MOVE LINK-HOME-MKT-FL TO CB-PERMISN-TO-MKT-FL             
              IF HPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF HMPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF WKPH-CHANGED                                              
              MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'W1' TO CB-PHONE-TYPE                                
              MOVE LINK-WORK-PHONE-NO TO CB-PHONE-NO                    
              MOVE LINK-WORK-PHONE-EXT TO CB-EXTENSION-NO               
              MOVE LINK-WORK-MOBILE-FL TO CB-MOBILE-PHONE-FL            
              MOVE LINK-WORK-MKT-FL TO CB-PERMISN-TO-MKT-FL             
              IF WPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF WKPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF ALPH-CHANGED                                              
              MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'A1' TO CB-PHONE-TYPE                                
              MOVE LINK-ALT-PHONE-NO TO CB-PHONE-NO                     
              MOVE SPACES TO CB-EXTENSION-NO                            
              MOVE LINK-ALT-MOBILE-FL TO CB-MOBILE-PHONE-FL             
              MOVE LINK-ALT-MKT-FL TO CB-PERMISN-TO-MKT-FL              
              IF APFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF ALPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-TRANSACTION-HISTORY.                                        
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           IF CE-ALLOW-CALL-FL NOT = LINK-ALLOW-CALL-FL                 
              MOVE 'YES'                     TO WS-CSTS-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALLOW-CALL-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALLOW-CALL-FL     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF CE-ALLOW-CALL-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE CE-ALLOW-CALL-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALLOW CALL'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-PHONE-NO NOT = LINK-WORK-PHONE-NO                 
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-WORK-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-WORK-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-WORK-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-WORK-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'WORK PHONE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-EXTENSION-NO NOT = LINK-WORK-PHONE-EXT            
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-PHONE-EXT > SPACES                           
                 MOVE +6                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-PHONE-EXT    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-EXTENSION-NO > SPACES                          
                 MOVE +6                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-EXTENSION-NO   TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK PHONE EXT'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MOBILE-FL NOT = LINK-WORK-MOBILE-FL               
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MOBILE'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MKT-FL NOT = LINK-WORK-MKT-FL                     
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
                                                WS-WPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MKT PRMSN'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-WORK-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-WORK-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-WORK-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'WORK MKT DATE'       TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-HOME-PHONE-NO NOT = LINK-HOME-PHONE-NO                 
              MOVE 'YES'                   TO WS-HMPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-HOME-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-HOME-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-HOME-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-HOME-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'PRIMARY PHONE'         TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MOBILE-FL NOT = LINK-HOME-MOBILE-FL               
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'HOME MOBILE'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MKT-FL NOT = LINK-HOME-MKT-FL                     
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
                                                WS-HPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'HOME MKT PRMSN'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-HOME-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-HOME-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-HOME-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'HOME MKT DATE'       TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ALT-PHONE-NO NOT = LINK-ALT-PHONE-NO                   
              MOVE 'YES'                  TO WS-ALPH-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-ALT-PHONE-NO > SPACES                             
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-ALT-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF WS-ALT-PHONE-NO > SPACES                               
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE WS-ALT-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'ALTERNATE PHONE'      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MOBILE-FL NOT = LINK-ALT-MOBILE-FL                 
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MOBILE-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MOBILE-FL TO     MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MOBILE-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MOBILE-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALTERNATE MOBILE'        TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MKT-FL NOT = LINK-ALT-MKT-FL                       
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
                                                WS-APFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MKT-FL > SPACES                               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MKT-FL TO        MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MKT-FL > SPACES                                 
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MKT-FL          TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MKT PRMSN'           TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-ALT-MKT-FL > ' '                                  
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-ALT-MKT-DT > SPACES                             
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-ALT-MKT-DT    TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'ALT MKT DATE'        TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CE-EMPLOYER NOT = LINK-EMPLOYER                           
              MOVE 'YES'                     TO WS-CSTS-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-EMPLOYER > SPACES                                 
                 MOVE +23                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-EMPLOYER          TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF CE-EMPLOYER > SPACES                                   
                 MOVE +23                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE CE-EMPLOYER            TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'EMPLOYER'                TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DETERMINE-DATABASE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'DATABASE'                             
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                                     
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DATABASE                  
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO WS-DATABASE                                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DATABASE'       TO TABLE-ELEMENT-1             
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_ID                                            
                INTO :CU-NAME-ID                                        
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :CU-NAME-ID                                                
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     EMPLOYER,                                          
                     ALLOW_CALL_FL                                      
              INTO   :WS-CSTS-EXISTS-FLAG,                              
                     :CE-EMPLOYER,                                      
                     :CE-ALLOW-CALL-FL                                  
              FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO    = :CU-CUSTOMER-NO                   
                AND  CUSTOMER_TYPE  = 'C'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              ALLOW_CALL_FL                                              
MFA-TR*       INTO   :WS-CSTS-EXISTS-FLAG,                                      
MFA-TR*              :CE-EMPLOYER,                                              
MFA-TR*              :CE-ALLOW-CALL-FL                                          
MFA-TR*       FROM   CSS_CUST_STATS                                             
MFA-TR*       WHERE  CUSTOMER_NO    = :CU-CUSTOMER-NO                           
MFA-TR*         AND  CUSTOMER_TYPE  = 'C'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE 'C'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT                                  
              INTO  :WS-PHONE-EXISTS-FLAG,                              
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO,                                   
                    :CB-MOBILE-PHONE-FL,                                
                    :CB-PERMISN-TO-MKT-FL,                              
                    :CB-PERMISN-TO-MKT-DT :WS-NULL-1                     
              FROM   CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO   = :CU-CUSTOMER-NO                    
                AND  PHONE_TYPE    = :WS-PHONE-TYPE                     
                AND  CUSTOMER_TYPE = 'C'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT                                          
MFA-TR*       INTO  :WS-PHONE-EXISTS-FLAG,                                      
MFA-TR*             :CB-PHONE-TYPE,                                             
MFA-TR*             :CB-PHONE-NO,                                               
MFA-TR*             :CB-EXTENSION-NO,                                           
MFA-TR*             :CB-MOBILE-PHONE-FL,                                        
MFA-TR*             :CB-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :CB-PERMISN-TO-MKT-DT:WS-NULL-1                             
MFA-TR*       FROM   CSS_CUST_PHONE                                             
MFA-TR*       WHERE  CUSTOMER_NO   = :CU-CUSTOMER-NO                            
MFA-TR*         AND  PHONE_TYPE    = :WS-PHONE-TYPE                             
MFA-TR*         AND  CUSTOMER_TYPE = 'C'                                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'PHONE_TYPE'     TO TABLE-ELEMENT-2             
                   MOVE WS-PHONE-TYPE    TO HOSTVAR-ELEMENT-2           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-3             
                   MOVE 'C'              TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= SPACES                            
               MOVE -1 TO WS-NULL-3
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_PHONE                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT)                                 
              VALUES                                                    
                   (:CB-CUSTOMER-NO,                                    
                    'C',                                                
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO,                                   
                    :CB-MOBILE-PHONE-FL,                                
                    :CB-PERMISN-TO-MKT-FL,                              
                    IIF(TRY_CONVERT(DATE, :CB-PERMISN-TO-MKT-DT 
                                          :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-3
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-3) ))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_PHONE                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:CB-CUSTOMER-NO,                                            
MFA-TR*             'C',                                                        
MFA-TR*             :CB-PHONE-TYPE,                                             
MFA-TR*             :CB-PHONE-NO,                                               
MFA-TR*             :CB-EXTENSION-NO,                                           
MFA-TR*             :CB-MOBILE-PHONE-FL,                                        
MFA-TR*             :CB-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :CB-PERMISN-TO-MKT-DT:WS-NULL-3)                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-3            
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     NAME_ID,                                           
                     EMPLOYER,                                          
                     ALLOW_CALL_FL)                                     
              VALUES                                                    
                   (:CE-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CE-NAME-ID,                                        
                    :CE-EMPLOYER,                                       
                    :CE-ALLOW-CALL-FL)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-3              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE CE-NAME-ID           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-CSTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_STATS                                
               WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO              
                 AND CUSTOMER_TYPE      =  'C'                          
                 AND SSN                =  ' '                          
                 AND CODE_STATE_ID      =  ' '                          
                 AND DRIVERS_LICENSE_NO =  ' '                          
                 AND EMPLOYER           =  ' '                          
                 AND EMPLOYED_DATE      IS NULL                         
                 AND OCCUPATION         =  ' '                          
                 AND OTHER_ID_TYPE      =  ' '                          
                 AND OTHER_ID           =  ' '                          
                 AND DRVR_LIC_ISS_DT    IS NULL                         
                 AND DATE_OF_BIRTH      IS NULL                         
                 AND EMPLOYEE_NBR       =  ' '                          
                 AND INTR_CO_IND        =  ' '                          
                 AND EBILL_REGISTER_IND =  ' '                          
                 AND PASSWORD_HINT_CD   = ' '                           
                 AND PASSWORD_TX        = ' '                           
                 AND REFUSED_SSN_FL     = ' '                           
                 AND LANGUAGE_PREF_CD   = ' '                           
                 AND DOB_VERIFIED_CD    = ' '                           
                 AND ACCESS_LEVEL_CD    = ' '                           
                 AND ALLOW_CALL_FL      = ' '                           
                 AND ITIN_ID            = ' '                           
                 AND VERIFY_SSN_FL      = ' '                           
                 AND PASSWORD_HINT      = ' '                           
                 AND ALLOW_EMAIL_FL     = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  'C'                                  
MFA-TR*          AND SSN                =  ' '                                  
MFA-TR*          AND CODE_STATE_ID      =  ' '                                  
MFA-TR*          AND DRIVERS_LICENSE_NO =  ' '                                  
MFA-TR*          AND EMPLOYER           =  ' '                                  
MFA-TR*          AND EMPLOYED_DATE      IS NULL                                 
MFA-TR*          AND OCCUPATION         =  ' '                                  
MFA-TR*          AND OTHER_ID_TYPE      =  ' '                                  
MFA-TR*          AND OTHER_ID           =  ' '                                  
MFA-TR*          AND DRVR_LIC_ISS_DT    IS NULL                                 
MFA-TR*          AND DATE_OF_BIRTH      IS NULL                                 
MFA-TR*          AND EMPLOYEE_NBR       =  ' '                                  
MFA-TR*          AND INTR_CO_IND        =  ' '                                  
MFA-TR*          AND EBILL_REGISTER_IND =  ' '                                  
MFA-TR*          AND PASSWORD_HINT_CD   = ' '                                   
MFA-TR*          AND PASSWORD_TX        = ' '                                   
MFA-TR*          AND REFUSED_SSN_FL     = ' '                                   
MFA-TR*          AND LANGUAGE_PREF_CD   = ' '                                   
MFA-TR*          AND DOB_VERIFIED_CD    = ' '                                   
MFA-TR*          AND ACCESS_LEVEL_CD    = ' '                                   
MFA-TR*          AND ALLOW_CALL_FL      = ' '                                   
MFA-TR*          AND ITIN_ID            = ' '                                   
MFA-TR*          AND VERIFY_SSN_FL      = ' '                                   
MFA-TR*          AND PASSWORD_HINT      = ' '                                   
MFA-TR*          AND ALLOW_EMAIL_FL     = ' '                                   
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-DELETE-NULL-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PHONE                                
               WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO               
                 AND PHONE_TYPE         = :CB-PHONE-TYPE                
                 AND PHONE_NO           = ' '                           
                 AND EXTENSION_NO       = ' '                           
                 AND CUSTOMER_TYPE      = 'C'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PHONE                                        
MFA-TR*        WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO                       
MFA-TR*          AND PHONE_TYPE         = :CB-PHONE-TYPE                        
MFA-TR*          AND PHONE_NO           = ' '                                   
MFA-TR*          AND EXTENSION_NO       = ' '                                   
MFA-TR*          AND CUSTOMER_TYPE      = 'C'                                   
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE-TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-CSTS.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
              SET EMPLOYER           = :CE-EMPLOYER,                    
                  ALLOW_CALL_FL      = :CE-ALLOW-CALL-FL                
               WHERE CUSTOMER_NO     = :CE-CUSTOMER-NO                  
                 AND CUSTOMER_TYPE   = 'C'                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*       SET EMPLOYER           = :CE-EMPLOYER,                            
MFA-TR*           ALLOW_CALL_FL      = :CE-ALLOW-CALL-FL                        
MFA-TR*        WHERE CUSTOMER_NO     = :CE-CUSTOMER-NO                          
MFA-TR*          AND CUSTOMER_TYPE   = 'C'                                      
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8340'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= ' '                               
               MOVE -1 TO WS-NULL-2
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PHONE                                     
              SET    PHONE_NO          = :CB-PHONE-NO,                  
                     EXTENSION_NO      = :CB-EXTENSION-NO,              
                     MOBILE_PHONE_FL   = :CB-MOBILE-PHONE-FL,           
                     PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,         
                     PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-2
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-2
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-2
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-2
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-2) )
              WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                    
                AND  PHONE_TYPE    = :CB-PHONE-TYPE                     
                AND  CUSTOMER_TYPE = 'C'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_PHONE                                             
MFA-TR*       SET    PHONE_NO          = :CB-PHONE-NO,                          
MFA-TR*              EXTENSION_NO      = :CB-EXTENSION-NO,                      
MFA-TR*              MOBILE_PHONE_FL   = :CB-MOBILE-PHONE-FL,                   
MFA-TR*              PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :CB-PERMISN-TO-MKT-DT:WS-NULL-2        
MFA-TR*       WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                            
MFA-TR*         AND  PHONE_TYPE    = :CB-PHONE-TYPE                             
MFA-TR*         AND  CUSTOMER_TYPE = 'C'                                        
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8360'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-3            
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
