       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04706.                                         
COB303 DATE-WRITTEN.  APRIL 1, 2014.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES M&P NOTIFICATIONS.                       *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  04/01/14   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04706'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     01010000
              INCLUDE TBCSTSTS                                          01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01050000
              INCLUDE TBCUST                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBACCT                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBACTATT                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01050000
              INCLUDE TBADRFRE                                          01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04706'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CSTS-EXISTS                     VALUE 'YES'.          
           05  WS-ATTR-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ATTR-EXISTS                     VALUE 'YES'.          
           05  WS-IADD-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 IADD-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-CSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CSTS-CHANGED                    VALUE 'YES'.          
           05  WS-BILL-NOTIFICATION     PIC X(01) VALUE SPACES.         
           05  WS-OLD-PULL-CD           PIC X(01) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
              DECLARE ACCT-CURSOR CURSOR FOR                            
               SELECT ACCOUNT_NO                                        
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-LANGUAGE-PREF-CD    PIC X(02).                          
       01  LINK-BILL-NOTIFICATION   PIC X(01).                          
       01  LINK-PAY-REMIND-FL       PIC X(01).                          
       01  LINK-ACCOUNT-UPDATE-CD   PIC X(03).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO,                                       
                LINK-ACCOUNT-NO,                                        
                LINK-LANGUAGE-PREF-CD,                                  
                LINK-BILL-NOTIFICATION,                                 
                LINK-PAY-REMIND-FL,                                     
                LINK-ACCOUNT-UPDATE-CD,                                 
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO <= SPACES                                
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-ACCOUNT-UPDATE-CD = 'ALL'                            
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO                      
                                     YP-ACCOUNT-NO.                     
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT
           END-IF.              
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           IF LINK-PAY-REMIND-FL <= SPACES                              
               MOVE 'N' TO LINK-PAY-REMIND-FL
           END-IF.                          
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO        
                                            MI-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-PREMISE-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF CU-CUSTOMER-NO > 0                                        
               PERFORM 2100-LANGUAGE-PREF THRU 2100-EXIT                
               IF LINK-ACCOUNT-UPDATE-CD = 'ALL'                        
                   PERFORM 7500-OPEN-ACCT-CURSOR THRU 7500-EXIT         
                   PERFORM 2400-FETCH-ROWS THRU 2400-EXIT               
                   PERFORM 7501-CLOSE-ACCT-CURSOR THRU 7501-EXIT        
                   MOVE ZEROES TO AT-ACCOUNT-NO
               END-IF
           END-IF.                        
                                                                        
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 2200-PAYMENT-REMINDER THRU 2200-EXIT             
               PERFORM 2300-BILL-NOTIFICATION THRU 2300-EXIT
           END-IF.           
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-LANGUAGE-PREF.                                              
                                                                        
           MOVE 'PANEL087' TO MH-APPL-PROGRAM-ID.                       
           MOVE CU-CUSTOMER-NO TO MH-CUSTOMER-NO.                       
           MOVE ZEROES TO MH-ACCOUNT-NO.                                
                                                                        
           PERFORM 7030-SELECT-CUST-STATS THRU 7030-EXIT.               
           IF NOT CSTS-EXISTS                                           
               INITIALIZE DCLCSS-CUST-STATS
           END-IF.                            
                                                                        
           IF CE-LANGUAGE-PREF-CD NOT = LINK-LANGUAGE-PREF-CD           
               MOVE 'YES' TO WS-CSTS-CHANGED-FLAG                       
               MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                  
               IF LINK-LANGUAGE-PREF-CD > SPACES                        
                   MOVE +18 TO MI-CHG-COLUMN-VALUE-LEN                  
                   EVALUATE LINK-LANGUAGE-PREF-CD                       
                       WHEN 'EN'                                        
                           MOVE 'PREFERS ENGLISH' TO                    
                                MI-CHG-COLUMN-VALUE-TEXT                
                       WHEN 'SP'                                        
                           MOVE 'PREFERS SPANISH' TO                    
                                MI-CHG-COLUMN-VALUE-TEXT                
                       WHEN 'OT'                                        
                           MOVE 'OTHER' TO                              
                                MI-CHG-COLUMN-VALUE-TEXT                
                       WHEN OTHER                                       
                           MOVE SPACES TO MI-CHG-COLUMN-VALUE-TEXT      
                   END-EVALUATE                                         
               ELSE                                                     
                   MOVE +9 TO MI-CHG-COLUMN-VALUE-LEN                   
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               IF CE-LANGUAGE-PREF-CD > SPACES                          
                   MOVE +18 TO MI-PRV-COLUMN-VALUE-LEN                  
                   EVALUATE CE-LANGUAGE-PREF-CD                         
                       WHEN 'EN'                                        
                           MOVE 'PREFERS ENGLISH' TO                    
                                MI-PRV-COLUMN-VALUE-TEXT                
                       WHEN 'SP'                                        
                           MOVE 'PREFERS SPANISH' TO                    
                                MI-PRV-COLUMN-VALUE-TEXT                
                       WHEN 'OT'                                        
                           MOVE 'OTHER' TO                              
                                MI-PRV-COLUMN-VALUE-TEXT                
                       WHEN OTHER                                       
                           MOVE SPACES TO MI-PRV-COLUMN-VALUE-TEXT      
                   END-EVALUATE                                         
               ELSE                                                     
                   MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN                   
                   MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT             
               END-IF                                                   
               MOVE 'LANGUAGE PREF' TO MI-COLUMN-DESC                   
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF CSTS-CHANGED                                              
               MOVE LINK-LANGUAGE-PREF-CD TO CE-LANGUAGE-PREF-CD        
               IF CSTS-EXISTS                                           
                   PERFORM 8340-UPDATE-CSTS THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-CSTS THRU 8190-EXIT         
               ELSE                                                     
                   MOVE 'C' TO CE-CUSTOMER-TYPE                         
                   PERFORM 7010-SELECT-CUSTOMER THRU 7010-EXIT          
                   MOVE CU-NAME-ID TO CE-NAME-ID                        
                   PERFORM 8050-INSERT-CUST-STATS THRU 8050-EXIT
               END-IF
           END-IF.       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-PAYMENT-REMINDER.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
           MOVE 'EMAIL PMT REMINDER' TO YP-ATTRIBUTE-DESC.              
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF NOT ATTR-EXISTS                                           
               INITIALIZE DCLCSS-ACCT-ATTRIBUTE                         
               MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO                      
               MOVE 'NO' TO YP-ATTRIBUTE-VALUE-CD
           END-IF.                      
                                                                        
           IF YP-ATTRIBUTE-VALUE-CD(1:1) NOT = LINK-PAY-REMIND-FL       
               EVALUATE LINK-PAY-REMIND-FL                              
                   WHEN 'Y'                                             
                       MOVE 'EMAIL PMT REMINDER' TO WZ-ATTRIBUTE-DESC   
                                                    YP-ATTRIBUTE-DESC   
                       PERFORM 7020-ACCOUNT-ATTRIB THRU 7020-EXIT       
                       EVALUATE WZ-ATTRIB-DFLT-VAL-CD                   
                           WHEN 'NO'                                    
                               MOVE 'YES' TO YP-ATTRIBUTE-VALUE-CD      
                           WHEN 'YES'                                   
                               MOVE 'NO' TO YP-ATTRIBUTE-VALUE-CD       
                       END-EVALUATE                                     
                       MOVE WZ-ATTRIB-DFLT-VAL-TX TO                    
                            YP-ATTRIBUTE-VALUE-TX                       
                       MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT    
                       PERFORM 8060-INSERT-ATTRIBUTE THRU 8060-EXIT     
                   WHEN 'N'                                             
                       PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT     
               END-EVALUATE                                             
               MOVE 'CSR03513A' TO MH-APPL-PROGRAM-ID                   
               MOVE AT-ACCOUNT-NO TO MH-ACCOUNT-NO                      
               MOVE ZEROES TO MH-CUSTOMER-NO                            
               IF LINK-PAY-REMIND-FL = 'Y'                              
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE SPACES               TO MI-TABLE-ID             
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE 'EMAIL PMT REMINDER' TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE +18                  TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'ATTRIBUTE DESC '    TO MI-COLUMN-DESC          
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1                     TO WS-TRAN-APPL-NO         
                                                                        
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE SPACES               TO MI-TABLE-ID             
                   MOVE 'OPT OUT'            TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE +7                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE 'OPT IN'             TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE +6                   TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'PYMT REMINDER'      TO MI-COLUMN-DESC          
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1                     TO WS-TRAN-APPL-NO         
               ELSE                                                     
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE SPACES               TO MI-TABLE-ID             
                   MOVE 'EMAIL PMT REMINDER' TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE +18                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '* DELETED *'        TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'ATTRIBUTE DESC '    TO MI-COLUMN-DESC          
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1                     TO WS-TRAN-APPL-NO         
                                                                        
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE SPACES               TO MI-TABLE-ID             
                   MOVE 'OPT IN'             TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE +6                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE 'OPT OUT'            TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE +7                   TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE 'PYMT REMINDER '    TO MI-COLUMN-DESC           
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1 TO WS-TRAN-APPL-NO
               END-IF
           END-IF.                            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-BILL-NOTIFICATION.                                          
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
           MOVE 'PANEL490' TO MH-APPL-PROGRAM-ID.                       
           MOVE ZEROES TO MH-CUSTOMER-NO.                               
           MOVE AT-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
                                                                        
      * ACCOUNT WITH EXTRA POSTAGE SWITCHING TO PAPERLESS                       
                                                                        
           IF AT-CODE-PERM-BILL = 'D' AND                               
              LINK-BILL-NOTIFICATION = '1' AND                          
              AT-NO-BILL-COPIES > 0                                     
                  MOVE 'A' TO AT-CODE-PERM-BILL                         
                  PERFORM 8350-UPDATE-PULL-CODE THRU 8350-EXIT
           END-IF.         
                                                                        
      * ACCOUNT WITH INTERNATIONAL ADDRESS SWITCHING FROM PAPERLESS             
                                                                        
           IF AT-CODE-PERM-BILL = 'A' AND                               
             (LINK-BILL-NOTIFICATION = '2' OR '3') AND                  
              AT-NO-BILL-COPIES = 0 AND                                 
              AT-ADDRESS-ID > 0 AND                                     
              AT-ADDRESS-FORMAT = 'B'                                   
                  MOVE 'NO' TO WS-IADD-EXISTS-FLAG                      
                  PERFORM 7050-SELECT-ADDRESS THRU 7050-EXIT            
                  IF IADD-EXISTS                                        
                      MOVE 'D' TO AT-CODE-PERM-BILL                     
                      PERFORM 8350-UPDATE-PULL-CODE THRU 8350-EXIT
                  END-IF
           END-IF.     
                                                                        
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF ATTR-EXISTS                                               
               MOVE '4' TO WS-BILL-NOTIFICATION                         
           ELSE                                                         
               IF AT-NO-BILL-COPIES = 0                                 
                   MOVE '1' TO WS-BILL-NOTIFICATION                     
               ELSE                                                     
                   IF AT-NO-BILL-COPIES > 0                             
                       MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC      
                       PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT     
                       IF ATTR-EXISTS                                   
                           MOVE '3' TO WS-BILL-NOTIFICATION             
                       ELSE                                             
                           MOVE '5' TO WS-BILL-NOTIFICATION
                       END-IF
                   END-IF
               END-IF
           END-IF.            
                                                                        
           IF (AT-NO-BILL-COPIES = 0 OR                                 
               CE-EBILL-REGISTER-IND = 'Y') AND                         
               WS-BILL-NOTIFICATION = '5'                               
                  MOVE '2' TO WS-BILL-NOTIFICATION
           END-IF.                     
                                                                        
           IF LINK-BILL-NOTIFICATION = SPACES                           
               MOVE WS-BILL-NOTIFICATION TO LINK-BILL-NOTIFICATION
           END-IF.     
                                                                        
           IF LINK-BILL-NOTIFICATION NOT = WS-BILL-NOTIFICATION         
               EVALUATE LINK-BILL-NOTIFICATION                          
                  WHEN '1'                                              
                       PERFORM 2310-EMAIL-ONLY  THRU 2310-EXIT          
                  WHEN '2'                                              
                       PERFORM 2320-EMAIL-PAPER THRU 2320-EXIT          
                  WHEN '3'                                              
                       PERFORM 2330-PAPER-ONLY  THRU 2330-EXIT          
                  WHEN '4'                                              
                       PERFORM 2340-NO-BILL-NOTIFY THRU 2340-EXIT       
               END-EVALUATE                                             
                                                                        
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'BILL NOTIFY OPT' TO MI-COLUMN-DESC                 
               EVALUATE WS-BILL-NOTIFICATION                            
                  WHEN 1                                                
                      MOVE +15               TO MI-PRV-COLUMN-VALUE-LEN 
                      MOVE 'PAPERLESS/EMAIL' TO MI-PRV-COLUMN-VALUE-TEXT
                  WHEN 2                                                
                      MOVE +15               TO MI-PRV-COLUMN-VALUE-LEN 
                      MOVE 'EMAIL AND PAPER' TO MI-PRV-COLUMN-VALUE-TEXT
                  WHEN 3                                                
                      MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN 
                      MOVE 'PAPER ONLY'      TO MI-PRV-COLUMN-VALUE-TEXT
                  WHEN 4                                                
                      MOVE +17               TO MI-PRV-COLUMN-VALUE-LEN 
                      MOVE 'NO PAPER/NO EMAIL' TO                       
                           MI-PRV-COLUMN-VALUE-TEXT                     
                  WHEN 5                                                
                      MOVE +25               TO MI-PRV-COLUMN-VALUE-LEN 
                      MOVE 'SYSTEM DEFAULT PAPER ONLY' TO               
                           MI-PRV-COLUMN-VALUE-TEXT                     
               END-EVALUATE                                             
               EVALUATE LINK-BILL-NOTIFICATION                          
                  WHEN 1                                                
                      MOVE +15               TO MI-CHG-COLUMN-VALUE-LEN 
                      MOVE 'PAPERLESS/EMAIL' TO MI-CHG-COLUMN-VALUE-TEXT
                  WHEN 2                                                
                      MOVE +15               TO MI-CHG-COLUMN-VALUE-LEN 
                      MOVE 'EMAIL AND PAPER' TO MI-CHG-COLUMN-VALUE-TEXT
                  WHEN 3                                                
                      MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN 
                      MOVE 'PAPER ONLY'      TO MI-CHG-COLUMN-VALUE-TEXT
                  WHEN 4                                                
                      MOVE +17               TO MI-CHG-COLUMN-VALUE-LEN 
                      MOVE 'NO PAPER/NO EMAIL' TO                       
                           MI-CHG-COLUMN-VALUE-TEXT                     
                  WHEN 5                                                
                      MOVE +25               TO MI-CHG-COLUMN-VALUE-LEN 
                      MOVE 'SYSTEM DEFAULT PAPER ONLY' TO               
                           MI-CHG-COLUMN-VALUE-TEXT                     
               END-EVALUATE                                             
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF AT-CODE-PERM-BILL NOT = WS-OLD-PULL-CD                    
               MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO           
               MOVE 'PERM PULL CODE'       TO MI-COLUMN-DESC            
               MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-OLD-PULL-CD         TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE AT-CODE-PERM-BILL      TO MI-CHG-COLUMN-VALUE-TEXT  
               MOVE '70'                   TO MI-TABLE-ID               
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO                                 
               MOVE SPACES TO MI-TABLE-ID
           END-IF.                              
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-EMAIL-ONLY.                                                 
                                                                        
           MOVE 0 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
           MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC.                 
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF ATTR-EXISTS                                               
               PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT
           END-IF.            
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF ATTR-EXISTS                                               
               PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT
           END-IF.            
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2320-EMAIL-PAPER.                                                
                                                                        
           MOVE 1 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
           MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC.                 
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF ATTR-EXISTS                                               
               PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT
           END-IF.            
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF ATTR-EXISTS                                               
               PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT
           END-IF.            
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2330-PAPER-ONLY.                                                 
                                                                        
           MOVE 1 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
           MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC.                 
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF NOT ATTR-EXISTS                                           
               MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO                      
               MOVE 'YES' TO YP-ATTRIBUTE-VALUE-CD                      
               MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT            
               MOVE +15 TO YP-ATTRIBUTE-VALUE-TX-LEN                    
               MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-VALUE-TX-TEXT     
               PERFORM 8060-INSERT-ATTRIBUTE THRU 8060-EXIT
           END-IF.            
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF ATTR-EXISTS                                               
               PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT
           END-IF.            
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2340-NO-BILL-NOTIFY.                                             
                                                                        
           MOVE 0 TO AT-NO-BILL-COPIES.                                 
           PERFORM 8360-UPDATE-BILL-COPIES THRU 8360-EXIT.              
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF NOT ATTR-EXISTS                                           
               MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO                      
               MOVE 'NO' TO YP-ATTRIBUTE-VALUE-CD                       
               MOVE WS-CURRENT-DATE TO YP-ATTRIBUTE-VALUE-DT            
               MOVE +16 TO YP-ATTRIBUTE-VALUE-TX-LEN                    
               MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-VALUE-TX-TEXT    
               PERFORM 8060-INSERT-ATTRIBUTE THRU 8060-EXIT
           END-IF.            
           MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC.                 
           PERFORM 7040-SELECT-ATTRIBUTE THRU 7040-EXIT.                
           IF ATTR-EXISTS                                               
               PERFORM 8180-DELETE-ATTRIBUTE THRU 8180-EXIT
           END-IF.            
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCT-CURSOR                                        
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2400-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-ACCOUNT-NO TO YP-ACCOUNT-NO.                         
           PERFORM 2200-PAYMENT-REMINDER THRU 2200-EXIT.                
           PERFORM 2300-BILL-NOTIFICATION THRU 2300-EXIT.               
                                                                        
           GO TO 2400-FETCH-ROWS.                                       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              COMPANY_NO,
              CODE_PERM_BILL,
              NO_BILL_COPIES,
              ADDRESS_ID,
              ADDRESS_FORMAT                                     
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-COMPANY-NO,                                    
                     :AT-CODE-PERM-BILL,                                
                     :AT-NO-BILL-COPIES,                                
                     :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              CODE_PERM_BILL,                                            
MFA-TR*              NO_BILL_COPIES,                                            
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT                                             
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-CODE-PERM-BILL,                                        
MFA-TR*              :AT-NO-BILL-COPIES,                                        
MFA-TR*              :AT-ADDRESS-ID,                                            
MFA-TR*              :AT-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CU-CUSTOMER-NO = ZEROES                           
                       MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO            
                   END-IF                                               
                   MOVE AT-CODE-PERM-BILL TO WS-OLD-PULL-CD             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_ID                                            
                INTO :CU-NAME-ID                                        
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :CU-NAME-ID                                                
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7010'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_CUSTOMER'    TO TABLE-1                    
                   MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1            
                   MOVE CU-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-ACCOUNT-ATTRIB.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ATTRIB_DFLT_VAL_CD,
              ATTRIB_DFLT_VAL_TX                                 
                INTO :WZ-ATTRIB-DFLT-VAL-CD,                            
                     :WZ-ATTRIB-DFLT-VAL-TX                             
                FROM CSS_ATTRIBUTE WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO = :AT-COMPANY-NO                        
                 AND ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ATTRIB_DFLT_VAL_CD,                                        
MFA-TR*              ATTRIB_DFLT_VAL_TX                                         
MFA-TR*         INTO :WZ-ATTRIB-DFLT-VAL-CD,                                    
MFA-TR*              :WZ-ATTRIB-DFLT-VAL-TX                                     
MFA-TR*         FROM CSS_ATTRIBUTE                                              
MFA-TR*        WHERE COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          AND ATTRIBUTE_DESC = :WZ-ATTRIBUTE-DESC                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7020'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ATTRIBUTE'   TO TABLE-1                    
                   MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-COMPANY-NO     TO HOSTVAR-ELEMENT-1          
                   MOVE 'ATTRIBUTE_DESC'  TO TABLE-ELEMENT-2            
                   MOVE WZ-ATTRIBUTE-DESC TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              LANGUAGE_PREF_CD,
              EBILL_REGISTER_IND                                 
                INTO :WS-CSTS-EXISTS-FLAG,                              
                     :CE-LANGUAGE-PREF-CD,                              
                     :CE-EBILL-REGISTER-IND                             
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                   
                 AND CUSTOMER_TYPE  = 'C'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              LANGUAGE_PREF_CD,                                          
MFA-TR*              EBILL_REGISTER_IND                                         
MFA-TR*         INTO :WS-CSTS-EXISTS-FLAG,                                      
MFA-TR*              :CE-LANGUAGE-PREF-CD,                                      
MFA-TR*              :CE-EBILL-REGISTER-IND                                     
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                           
MFA-TR*          AND CUSTOMER_TYPE  = 'C'                                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-LANGUAGE-PREF-CD < SPACES                      
                       MOVE SPACES TO CE-LANGUAGE-PREF-CD               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE 'C'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-ATTRIBUTE.                                           
                                                                        
           MOVE 'NO' TO WS-ATTR-EXISTS-FLAG.                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              ATTRIBUTE_VALUE_CD,
              ATTRIBUTE_VALUE_DT,
              ATTRIBUTE_VALUE_TX                                 
                INTO :WS-ATTR-EXISTS-FLAG,                              
                     :YP-ATTRIBUTE-VALUE-CD,                            
                     :YP-ATTRIBUTE-VALUE-DT,                            
                     :YP-ATTRIBUTE-VALUE-TX                             
                FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                    
                 AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              ATTRIBUTE_VALUE_CD,                                        
MFA-TR*              ATTRIBUTE_VALUE_DT,                                        
MFA-TR*              ATTRIBUTE_VALUE_TX                                         
MFA-TR*         INTO :WS-ATTR-EXISTS-FLAG,                                      
MFA-TR*              :YP-ATTRIBUTE-VALUE-CD,                                    
MFA-TR*              :YP-ATTRIBUTE-VALUE-DT,                                    
MFA-TR*              :YP-ATTRIBUTE-VALUE-TX                                     
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE                                         
MFA-TR*        WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                            
MFA-TR*          AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE YP-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'ATTRIBUTE_DESC' TO TABLE-ELEMENT-2             
                   MOVE YP-ATTRIBUTE-DESC TO HOSTVAR-ELEMENT-2          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT ADDR_COUNTRY                                      
                 INTO :DZ-ADDR-COUNTRY                                  
                 FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
                WHERE ADDRESS_ID = :AT-ADDRESS-ID                       
                  AND ADDR_COUNTRY > ' '                                
                  AND ADDR_COUNTRY <> 'USA'                             
                  AND ADDR_COUNTRY <> 'US'                              
                  AND ADDR_COUNTRY <> 'UNITED STATES'                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDR_COUNTRY                                              
MFA-TR*          INTO :DZ-ADDR-COUNTRY                                          
MFA-TR*          FROM CSS_ADDR_FREEFORM                                         
MFA-TR*         WHERE ADDRESS_ID = :AT-ADDRESS-ID                               
MFA-TR*           AND ADDR_COUNTRY > ' '                                        
MFA-TR*           AND ADDR_COUNTRY = 'USA'                                     
MFA-TR*           AND ADDR_COUNTRY = 'US'                                      
MFA-TR*           AND ADDR_COUNTRY = 'UNITED STATES'                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'YES' TO WS-IADD-EXISTS-FLAG                    
               WHEN NOT-FOUND                                           
                   MOVE 'NO' TO WS-IADD-EXISTS-FLAG                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ADDRESS_ID'     TO TABLE-ELEMENT-1             
                   MOVE AT-ADDRESS-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     NAME_ID,                                           
                     LANGUAGE_PREF_CD)                                  
              VALUES                                                    
                   (:CU-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CU-NAME-ID,                                        
                    :CE-LANGUAGE-PREF-CD)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'LANGUAGE_PREF_CD'   TO TABLE-ELEMENT-3              
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE CE-LANGUAGE-PREF-CD  TO HOSTVAR-ELEMENT-3            
              MOVE CU-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-ATTRIBUTE.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                   ( ACCOUNT_NO,                                        
                     ATTRIBUTE_DESC,                                    
                     ATTRIBUTE_VALUE_CD,                                
                     ATTRIBUTE_VALUE_DT,                                
                     ATTRIBUTE_VALUE_TX)                                
              VALUES                                                    
                   (:YP-ACCOUNT-NO,                                     
                    :YP-ATTRIBUTE-DESC,                                 
                    :YP-ATTRIBUTE-VALUE-CD,                             
                    IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) ),                      
                    :YP-ATTRIBUTE-VALUE-TX)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*            ( ACCOUNT_NO,                                                
MFA-TR*              ATTRIBUTE_DESC,                                            
MFA-TR*              ATTRIBUTE_VALUE_CD,                                        
MFA-TR*              ATTRIBUTE_VALUE_DT,                                        
MFA-TR*              ATTRIBUTE_VALUE_TX)                                        
MFA-TR*       VALUES                                                            
MFA-TR*            (:YP-ACCOUNT-NO,                                             
MFA-TR*             :YP-ATTRIBUTE-DESC,                                         
MFA-TR*             :YP-ATTRIBUTE-VALUE-CD,                                     
MFA-TR*             :YP-ATTRIBUTE-VALUE-DT,                                     
MFA-TR*             :YP-ATTRIBUTE-VALUE-TX)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8180-DELETE-ATTRIBUTE.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ACCT_ATTRIBUTE                            
               WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                        
                 AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ACCT_ATTRIBUTE                                    
MFA-TR*        WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                                
MFA-TR*          AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                        
MFA-TR*       QUERYNO 8180                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ATTRIBUTE_DESC'     TO TABLE-ELEMENT-2              
              MOVE YP-ATTRIBUTE-DESC    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-CSTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_STATS                                
               WHERE CUSTOMER_NO        =  :CU-CUSTOMER-NO              
                 AND CUSTOMER_TYPE      =  'C'                          
                 AND SSN                =  ' '                          
                 AND CODE_STATE_ID      =  ' '                          
                 AND DRIVERS_LICENSE_NO =  ' '                          
                 AND EMPLOYER           =  ' '                          
                 AND EMPLOYED_DATE      IS NULL                         
                 AND OCCUPATION         =  ' '                          
                 AND OTHER_ID_TYPE      =  ' '                          
                 AND OTHER_ID           =  ' '                          
                 AND DRVR_LIC_ISS_DT    IS NULL                         
                 AND DATE_OF_BIRTH      IS NULL                         
                 AND EMPLOYEE_NBR       =  ' '                          
                 AND INTR_CO_IND        =  ' '                          
                 AND EBILL_REGISTER_IND =  ' '                          
                 AND PASSWORD_HINT_CD   = ' '                           
                 AND PASSWORD_TX        = ' '                           
                 AND REFUSED_SSN_FL     = ' '                           
                 AND LANGUAGE_PREF_CD   = ' '                           
                 AND DOB_VERIFIED_CD    = ' '                           
                 AND ACCESS_LEVEL_CD    = ' '                           
                 AND ALLOW_CALL_FL      = ' '                           
                 AND ITIN_ID            = ' '                           
                 AND VERIFY_SSN_FL      = ' '                           
                 AND PASSWORD_HINT      = ' '                           
                 AND ALLOW_EMAIL_FL     = ' '                           
                 AND INDIV_NAME_ID      = 0                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CU-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  'C'                                  
MFA-TR*          AND SSN                =  ' '                                  
MFA-TR*          AND CODE_STATE_ID      =  ' '                                  
MFA-TR*          AND DRIVERS_LICENSE_NO =  ' '                                  
MFA-TR*          AND EMPLOYER           =  ' '                                  
MFA-TR*          AND EMPLOYED_DATE      IS NULL                                 
MFA-TR*          AND OCCUPATION         =  ' '                                  
MFA-TR*          AND OTHER_ID_TYPE      =  ' '                                  
MFA-TR*          AND OTHER_ID           =  ' '                                  
MFA-TR*          AND DRVR_LIC_ISS_DT    IS NULL                                 
MFA-TR*          AND DATE_OF_BIRTH      IS NULL                                 
MFA-TR*          AND EMPLOYEE_NBR       =  ' '                                  
MFA-TR*          AND INTR_CO_IND        =  ' '                                  
MFA-TR*          AND EBILL_REGISTER_IND =  ' '                                  
MFA-TR*          AND PASSWORD_HINT_CD   = ' '                                   
MFA-TR*          AND PASSWORD_TX        = ' '                                   
MFA-TR*          AND REFUSED_SSN_FL     = ' '                                   
MFA-TR*          AND LANGUAGE_PREF_CD   = ' '                                   
MFA-TR*          AND DOB_VERIFIED_CD    = ' '                                   
MFA-TR*          AND ACCESS_LEVEL_CD    = ' '                                   
MFA-TR*          AND ALLOW_CALL_FL      = ' '                                   
MFA-TR*          AND ITIN_ID            = ' '                                   
MFA-TR*          AND VERIFY_SSN_FL      = ' '                                   
MFA-TR*          AND PASSWORD_HINT      = ' '                                   
MFA-TR*          AND ALLOW_EMAIL_FL     = ' '                                   
MFA-TR*          AND INDIV_NAME_ID      = 0                                     
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-CSTS.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
                 SET LANGUAGE_PREF_CD = :CE-LANGUAGE-PREF-CD            
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE = 'C'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*          SET LANGUAGE_PREF_CD = :CE-LANGUAGE-PREF-CD                    
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8340'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_TYPE'       TO TABLE-ELEMENT-2             
              MOVE 'C'                   TO HOSTVAR-ELEMENT-2           
              MOVE 'LANGUAGE_PREF_CD'    TO TABLE-ELEMENT-3             
              MOVE CE-LANGUAGE-PREF-CD   TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8350-UPDATE-PULL-CODE.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_PERM_BILL = :AT-CODE-PERM-BILL                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODE_PERM_BILL = :AT-CODE-PERM-BILL                        
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8350'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-BILL-COPIES.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                        
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8360'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
