       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04705.                                         
COB303 DATE-WRITTEN.  FEBRUARY 17, 2014.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES CONTACT INFORMATION.                     *00200000
      *  STATUS CODE VALUES ARE:                                       *00200000
      *      +2 = INVALID ACTION CODE                                  *00200000
      *      +3 = ENTITY / DATA MISMATCH                               *00200000
      *      +4 = 10 MEMO BILLING CONTACTS EXIST                       *00200000
      *      +5 = ENTITY IS BLANK FOR INSERT OR UPDATE                 *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  02/17/14   FMB       NEW PROGRAM.                             *00290000
P00740*  04/22/14   FMB       HANDLE ADDRESS FORMAT INPUT WITH NO      *00290000
P00740*                       ADDRESS FIELDS.                          *00290000
P00836*  08/05/15   FMB       SECONDARY USER PROCESSING.               *00290000
A05317*  03/16/16   FMB       SALES SPECIALIST ENTITY.                 *00290000
ACT233*  07/26/16   TP7R341   REPLACE CSR00028 WITH CSR04675 FOR       *00290000
ACT233*   A05460                                                       *00290000
A05317*  02/17/17   FMB       WEB PU AND SU CONTACT ENTITY AND NAME    *00290000
A05317*  02/17/17   FMB       FORMAT MISMATCHES.                       *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04705'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE TBCNTCCS                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBCNTCAT                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00770000
              INCLUDE TBCNTCPR                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00930000
              INCLUDE TBCNTACT                                          00940000
           END-EXEC.                                                    00950000
           EXEC SQL                                                     00970000
              INCLUDE TBCNTPHN                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBCONSTA                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01090000
              INCLUDE TBNAME                                            01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01090000
              INCLUDE TBADRFMT                                          01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01090000
              INCLUDE TBADRFRE                                          01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01090000
              INCLUDE TBZIPCD                                           01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01130000
              INCLUDE TBNAMEID                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01130000
              INCLUDE TBCNTCID                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01130000
              INCLUDE TBADDRID                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBDELQ                                            01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBACCT                                            01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBSALSPL                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCONACC                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCTYPE                                           01430000
           END-EXEC.                                                    01440000
                                                                        
           COPY CWS00011.                                               01520000
           COPY CWS00303.                                               01520000
                                                                        
           EXEC SQL                                                     01630000
              INCLUDE CWS0013A                                          01640000
           END-EXEC.                                                    01650000
           EXEC SQL                                                     01670000
              INCLUDE CWS00071                                          01680000
           END-EXEC.                                                    01690000
           EXEC SQL                                                     01710000
              INCLUDE CWS0090A                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     01750000
              INCLUDE CWS0091A                                          01760000
           END-EXEC.                                                    01770000
           EXEC SQL                                                     01750000
              INCLUDE CWS0092A                                          01760000
           END-EXEC.                                                    01770000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CONTACT-ID-CHAR       PIC X(10).                      
           05  WS-CONTACT-ID-NUM        REDEFINES WS-CONTACT-ID-CHAR    
                                        PIC 9(10).                      
           05  WS-NEW-CONTACT-ID-NUM    PIC 9(10).                      
           05  WS-NEW-CONTACT-ID-CHAR   REDEFINES WS-NEW-CONTACT-ID-NUM 
                                        PIC X(10).                      
           05  WS-NEW-NAME-ID-NUM       PIC 9(13).                      
           05  WS-NEW-NAME-ID-CHAR      REDEFINES WS-NEW-NAME-ID-NUM    
                                        PIC X(13).                      
           05  WS-NEW-ADDR-ID-NUM       PIC 9(13).                      
           05  WS-NEW-ADDR-ID-CHAR      REDEFINES WS-NEW-ADDR-ID-NUM    
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-POSITION.                                             
               10 WS-POSITION-LEN       PIC S9(4) COMP.                 
               10 WS-POSITION-TEXT      PIC X(30).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04705'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CONTACT-NAME          PIC X(72) VALUE SPACES.         
           05  WS-CONTACT-ID            PIC S9(10)V COMP-3 VALUE 0.     
           05  WS-NAME-ID               PIC S9(13)V COMP-3 VALUE 0.     
           05  WS-TOTAL-CT              PIC S9(9) COMP VALUE 0.         
           05  WS-CONTACT-XFER-FL       PIC X(01) VALUE SPACES.         
           05  WS-CONT-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CONT-EXISTS                     VALUE 'YES'.          
           05  WS-CSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CSTS-EXISTS                     VALUE 'YES'.          
           05  WS-ADDR-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ADDR-EXISTS                     VALUE 'YES'.          
           05  WS-PHONE-EXISTS-FLAG     PIC X(03) VALUE 'NO '.          
               88 PHONE-EXISTS                    VALUE 'YES'.          
           05  WS-HMPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 HMPH-EXISTS                     VALUE 'YES'.          
           05  WS-WKPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 WKPH-EXISTS                     VALUE 'YES'.          
           05  WS-ALPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ALPH-EXISTS                     VALUE 'YES'.          
           05  WS-FXPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 FXPH-EXISTS                     VALUE 'YES'.          
           05  WS-NAME-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 NAME-EXISTS                     VALUE 'YES'.          
           05  WS-SPLS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 SPLS-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-6                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-7                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-ENTITY-TYPE           PIC X(01) VALUE SPACES.         
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-HOME-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-HOME-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-WORK-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXTENSION-NO     PIC X(06) VALUE SPACES.         
           05  WS-WORK-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-ALT-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-ALT-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-FAX-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-FAX-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-FAX-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-FAX-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-OLD-PREMISE-NO        PIC 9(10) VALUE ZEROES.         
           05  WS-OLD-ACCOUNT-NO        PIC 9(13) VALUE ZEROES.         
           05  WS-OLD-CUSTOMER-NO       PIC 9(10) VALUE ZEROES.         
           05  WS-NEW-SS-FIRST-NAME     PIC X(15) VALUE SPACES.         
           05  WS-NEW-SS-MIDDLE-NAME    PIC X(15) VALUE SPACES.         
           05  WS-NEW-SS-LAST-NAME      PIC X(40) VALUE SPACES.         
           05  WS-OLD-SS-FIRST-NAME     PIC X(15) VALUE SPACES.         
           05  WS-OLD-SS-MIDDLE-NAME    PIC X(15) VALUE SPACES.         
           05  WS-OLD-SS-LAST-NAME      PIC X(40) VALUE SPACES.         
           05  WS-OLD-SS-CONTACT-ID     PIC S9(10)V COMP-3 VALUE 0.     
A05317     05  WS-SS-CONTACT-ID         PIC S9(10)V COMP-3 VALUE 0.     
P00837     05  WS-SS-NAME-ID            PIC S9(13)V COMP-3 VALUE 0.     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-NAME-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NAME-CHANGED                    VALUE 'YES'.          
           05  WS-ADDR-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ADDR-CHANGED                    VALUE 'YES'.          
           05  WS-ADDR-ADDED-FLAG       PIC X(03) VALUE 'NO '.          
               88 ADDR-ADDED                      VALUE 'YES'.          
           05  WS-ADDR-DELETED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ADDR-DELETED                    VALUE 'YES'.          
           05  WS-AFMT-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 AFMT-CHANGED                    VALUE 'YES'.          
           05  WS-CONT-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CONT-CHANGED                    VALUE 'YES'.          
           05  WS-CSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CSTS-CHANGED                    VALUE 'YES'.          
           05  WS-HMPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HMPH-CHANGED                    VALUE 'YES'.          
           05  WS-WKPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WKPH-CHANGED                    VALUE 'YES'.          
           05  WS-ALPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ALPH-CHANGED                    VALUE 'YES'.          
           05  WS-FXPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 FXPH-CHANGED                    VALUE 'YES'.          
           05  WS-HPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HPFL-CHANGED                    VALUE 'YES'.          
           05  WS-WPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WPFL-CHANGED                    VALUE 'YES'.          
           05  WS-APFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 APFL-CHANGED                    VALUE 'YES'.          
           05  WS-FPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 FPFL-CHANGED                    VALUE 'YES'.          
           05  WS-SPLS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 SPLS-CHANGED                    VALUE 'YES'.          
           05  WS-ENTY-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ENTY-CHANGED                    VALUE 'YES'.          
           05  WS-SPLS-FL               PIC X(01) VALUE SPACES.         
P00836     05  WS-SU-MATCH-FL           PIC X(01) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CONTACT-ID           PIC X(10) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
      ******************************************************************        
ACT233* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT233     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT233     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
P00836     EXEC SQL                                                     
P00836        DECLARE CONTACT-CURSOR CURSOR FOR                         
P00836         SELECT ACCOUNT_NO                                        
P00836           FROM CSS_CONTACT_ACCT WITH(READUNCOMMITTED)                    
P00836          WHERE CONTACT_ID = :DW-CONTACT-ID                       
P00836                                                           
P00836          FOR READ ONLY                                          
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTACT-CURSOR CURSOR FOR                                 
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          FROM CSS_CONTACT_ACCT                                          
MFA-TR*         WHERE CONTACT_ID = :DW-CONTACT-ID                               
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7190                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE         PIC X(01).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-CONTACT-ID          PIC X(10).                          
       01  LINK-CONTACT-TYPE        PIC X(02).                          
       01  LINK-ENTITY-TYPE         PIC X(01).                          
       01  LINK-NAME-FORMAT         PIC X(01).                          
       01  LINK-TITLE               PIC X(09).                          
       01  LINK-FIRST-NAME          PIC X(15).                          
       01  LINK-MIDDLE-NAME         PIC X(15).                          
       01  LINK-LAST-NAME           PIC X(40).                          
       01  LINK-SUFFIX              PIC X(03).                          
       01  LINK-FULL-NAME           PIC X(70).                          
       01  LINK-TAX-ID              PIC X(09).                          
       01  LINK-WEBSITE-ADDR        PIC X(75).                          
       01  LINK-DATE-OF-BIRTH       PIC X(10).                          
       01  LINK-EMPLOYEE-TITLE      PIC X(50).                          
       01  LINK-BUSINESS-NAME       PIC X(50).                          
       01  LINK-EMPLOYER            PIC X(50).                          
       01  LINK-OTHER-ID            PIC X(16).                          
       01  LINK-OTHER-ID-TYPE       PIC X(12).                          
       01  LINK-DLN                 PIC X(19).                          
       01  LINK-DLN-STATE           PIC X(02).                          
       01  LINK-SSN                 PIC X(09).                          
       01  LINK-ITIN                PIC X(09).                          
       01  LINK-ALLOW-CALL-FL       PIC X(01).                          
       01  LINK-WORK-PHONE-NO       PIC X(10).                          
       01  LINK-WORK-PHONE-EXT      PIC X(06).                          
       01  LINK-WORK-MOBILE-FL      PIC X(01).                          
       01  LINK-WORK-MKT-FL         PIC X(01).                          
       01  LINK-HOME-PHONE-NO       PIC X(10).                          
       01  LINK-HOME-MOBILE-FL      PIC X(01).                          
       01  LINK-HOME-MKT-FL         PIC X(01).                          
       01  LINK-ALT-PHONE-NO        PIC X(10).                          
       01  LINK-ALT-MOBILE-FL       PIC X(01).                          
       01  LINK-ALT-MKT-FL          PIC X(01).                          
       01  LINK-FAX-PHONE-NO        PIC X(10).                          
       01  LINK-FAX-MOBILE-FL       PIC X(01).                          
       01  LINK-FAX-MKT-FL          PIC X(01).                          
       01  LINK-POSITION            PIC X(30).                          
       01  LINK-EFF-DT              PIC X(10).                          
       01  LINK-EXP-DT              PIC X(10).                          
       01  LINK-EFF-CD              PIC X(02).                          
       01  LINK-ACCESS-LEVEL-CD     PIC X(02).                          
       01  LINK-ADDRESS-FORMAT      PIC X(01).                          
       01  LINK-FF-STREET-1         PIC X(55).                          
       01  LINK-FF-STREET-2         PIC X(55).                          
       01  LINK-FF-CITY-STATE       PIC X(30).                          
       01  LINK-FF-ZIP-CODE         PIC X(09).                          
       01  LINK-FF-COUNTRY          PIC X(35).                          
       01  LINK-HOUSE-NO            PIC X(15).                          
       01  LINK-ADDR-PREFIX-1       PIC X(03).                          
       01  LINK-ADDR-PREFIX-2       PIC X(02).                          
       01  LINK-STREET-NAME         PIC X(30).                          
       01  LINK-STREET-SUFFIX       PIC X(04).                          
       01  LINK-ADDR-SUFFIX         PIC X(02).                          
       01  LINK-STREET-LOC-1        PIC X(04).                          
       01  LINK-STREET-LOC-2        PIC X(11).                          
       01  LINK-TOWN                PIC X(26).                          
       01  LINK-STATE               PIC X(02).                          
       01  LINK-ZIP-CODE            PIC X(05).                          
       01  LINK-ZIP-CODE-4          PIC X(04).                          
       01  LINK-USPS-DELIV-PT       PIC X(02).                          
       01  LINK-MEMO-BILL-IND       PIC X(01).                          
       01  LINK-SS-USERID           PIC X(07).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-UPDATE-TYPE,                                       
                LINK-ACCOUNT-NO,                                        
                LINK-CUSTOMER-NO,                                       
                LINK-PREMISE-NO,                                        
                LINK-CONTACT-ID,                                        
                LINK-CONTACT-TYPE,                                      
                LINK-ENTITY-TYPE,                                       
                LINK-NAME-FORMAT,                                       
                LINK-TITLE,                                             
                LINK-FIRST-NAME,                                        
                LINK-MIDDLE-NAME,                                       
                LINK-LAST-NAME,                                         
                LINK-SUFFIX,                                            
                LINK-FULL-NAME,                                         
                LINK-TAX-ID,                                            
                LINK-WEBSITE-ADDR,                                      
                LINK-DATE-OF-BIRTH,                                     
                LINK-EMPLOYEE-TITLE,                                    
                LINK-BUSINESS-NAME,                                     
                LINK-EMPLOYER,                                          
                LINK-OTHER-ID,                                          
                LINK-OTHER-ID-TYPE,                                     
                LINK-DLN,                                               
                LINK-DLN-STATE,                                         
                LINK-SSN,                                               
                LINK-ITIN,                                              
                LINK-ALLOW-CALL-FL,                                     
                LINK-WORK-PHONE-NO,                                     
                LINK-WORK-PHONE-EXT,                                    
                LINK-WORK-MOBILE-FL,                                    
                LINK-WORK-MKT-FL,                                       
                LINK-HOME-PHONE-NO,                                     
                LINK-HOME-MOBILE-FL,                                    
                LINK-HOME-MKT-FL,                                       
                LINK-ALT-PHONE-NO,                                      
                LINK-ALT-MOBILE-FL,                                     
                LINK-ALT-MKT-FL,                                        
                LINK-FAX-PHONE-NO,                                      
                LINK-FAX-MOBILE-FL,                                     
                LINK-FAX-MKT-FL,                                        
                LINK-POSITION,                                          
                LINK-EFF-DT,                                            
                LINK-EXP-DT,                                            
                LINK-EFF-CD,                                            
                LINK-ACCESS-LEVEL-CD,                                   
                LINK-ADDRESS-FORMAT,                                    
                LINK-FF-STREET-1,                                       
                LINK-FF-STREET-2,                                       
                LINK-FF-CITY-STATE,                                     
                LINK-FF-ZIP-CODE,                                       
                LINK-FF-COUNTRY,                                        
                LINK-HOUSE-NO,                                          
                LINK-ADDR-PREFIX-1,                                     
                LINK-ADDR-PREFIX-2,                                     
                LINK-STREET-NAME,                                       
                LINK-STREET-SUFFIX,                                     
                LINK-ADDR-SUFFIX,                                       
                LINK-STREET-LOC-1,                                      
                LINK-STREET-LOC-2,                                      
                LINK-TOWN,                                              
                LINK-STATE,                                             
                LINK-ZIP-CODE,                                          
                LINK-ZIP-CODE-4,                                        
                LINK-USPS-DELIV-PT,                                     
                LINK-MEMO-BILL-IND,                                     
                LINK-SS-USERID,                                         
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE,                  
                       :RS-CONTACT-ID  AS CONTACT_ID                    
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE,                          
MFA-TR*                :RS-CONTACT-ID  AS CONTACT_ID                            
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           EXEC SQL                                                     
               SELECT LTRIM(:LINK-HOUSE-NO)                             
                 INTO :LINK-HOUSE-NO                                    
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-HOUSE-NO)                                     
MFA-TR*          INTO :LINK-HOUSE-NO                                            
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT LTRIM(:LINK-ADDR-PREFIX-1)                        
                 INTO :LINK-ADDR-PREFIX-1                               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-ADDR-PREFIX-1)                                
MFA-TR*          INTO :LINK-ADDR-PREFIX-1                                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT LTRIM(:LINK-STREET-NAME)                          
                 INTO :LINK-STREET-NAME                                 
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-NAME)                                  
MFA-TR*          INTO :LINK-STREET-NAME                                         
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT LTRIM(:LINK-STREET-LOC-1)                         
                 INTO :LINK-STREET-LOC-1                                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-LOC-1)                                 
MFA-TR*          INTO :LINK-STREET-LOC-1                                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT LTRIM(:LINK-STREET-LOC-2)                         
                 INTO :LINK-STREET-LOC-2                                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-LOC-2)                                 
MFA-TR*          INTO :LINK-STREET-LOC-2                                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT LTRIM(:LINK-STREET-SUFFIX)                        
                 INTO :LINK-STREET-SUFFIX                               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-SUFFIX)                                
MFA-TR*          INTO :LINK-STREET-SUFFIX                                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT LTRIM(:LINK-TOWN)                                 
                 INTO :LINK-TOWN                                        
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-TOWN)                                         
MFA-TR*          INTO :LINK-TOWN                                                
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-CUSTOMER-NO <= SPACES                                
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-PREMISE-NO <= SPACES                                 
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-CONTACT-ID <= SPACES                                 
               MOVE ZEROES TO LINK-CONTACT-ID
           END-IF.                          
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE LINK-CONTACT-ID TO WS-CONTACT-ID-CHAR.                  
           IF LINK-CONTACT-TYPE = 'SA' OR 'SE' OR 'SG' OR 'PG'          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES TO LINK-SS-USERID
           END-IF.                           
           IF ((LINK-ENTITY-TYPE = 'A' AND                              
                LINK-ACCOUNT-NO = ZEROES AND                            
                LINK-CUSTOMER-NO = ZEROES) OR                           
               (LINK-ENTITY-TYPE = 'C' AND                              
                LINK-CUSTOMER-NO = ZEROES) OR                           
               (LINK-ENTITY-TYPE = 'P' AND                              
                LINK-PREMISE-NO = ZEROES)) AND                          
                LINK-UPDATE-TYPE = 'I'                                  
                    MOVE 0 TO S-RETURN-CODE                             
                    MOVE +3 TO S-STATUS-CODE                            
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.      
           IF LINK-ENTITY-TYPE <= SPACES AND                            
             (LINK-UPDATE-TYPE = 'I' OR 'U')                            
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE +5 TO S-STATUS-CODE                              
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.        
                                                                        
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           MOVE LINK-POSITION TO WS-POSITION.                           
A05317     IF LINK-CONTACT-TYPE = ('PU' OR 'SU') AND                    
A05317        LINK-NAME-FORMAT = 'I' AND                                
A05317        LINK-FULL-NAME > SPACES                                   
A05317            MOVE 'B' TO LINK-NAME-FORMAT
           END-IF.                         
           IF LINK-NAME-FORMAT = 'I' OR 'B'                             
               NEXT SENTENCE                                            
           ELSE                                                         
              IF LINK-LAST-NAME > ' '                                   
                  MOVE 'I' TO LINK-NAME-FORMAT                          
              ELSE                                                      
                  MOVE 'B' TO LINK-NAME-FORMAT
              END-IF
           END-IF.                         
           IF LINK-NAME-FORMAT = 'I'                                    
               MOVE SPACES TO LINK-FULL-NAME
           END-IF.                           
           IF LINK-ADDRESS-FORMAT = 'A' OR 'B'                          
P00740         IF LINK-UPDATE-TYPE = 'I' OR 'U'                         
P00740             EVALUATE LINK-ADDRESS-FORMAT                         
P00740                 WHEN 'A'                                         
P00740                     IF LINK-HOUSE-NO <= SPACES AND               
P00740                        LINK-ADDR-PREFIX-1 <= SPACES AND          
P00740                        LINK-ADDR-PREFIX-2 <= SPACES AND          
P00740                        LINK-STREET-NAME <= SPACES AND            
P00740                        LINK-STREET-SUFFIX <= SPACES AND          
P00740                        LINK-ADDR-SUFFIX <= SPACES AND            
P00740                        LINK-STREET-LOC-1 <= SPACES AND           
P00740                        LINK-STREET-LOC-2 <= SPACES AND           
P00740                        LINK-TOWN <= SPACES AND                   
P00740                        LINK-STATE <= SPACES AND                  
P00740                        LINK-ZIP-CODE <= SPACES AND               
P00740                        LINK-ZIP-CODE-4 <= SPACES AND             
P00740                        LINK-USPS-DELIV-PT <= SPACES              
P00740                            MOVE SPACES TO LINK-ADDRESS-FORMAT    
P00740                     END-IF                                       
P00740                 WHEN 'B'                                         
P00740                     IF LINK-FF-STREET-1 <= SPACES AND            
P00740                        LINK-FF-STREET-2 <= SPACES AND            
P00740                        LINK-FF-CITY-STATE <= SPACES AND          
P00740                        LINK-FF-ZIP-CODE <= SPACES AND            
P00740                        LINK-FF-COUNTRY <= SPACES                 
P00740                            MOVE SPACES TO LINK-ADDRESS-FORMAT    
P00740                     END-IF                                       
P00740             END-EVALUATE                                         
P00740         END-IF                                                   
           ELSE                                                         
               INITIALIZE DCLCSS-ADDR-FORMATTED                         
                          DCLCSS-ADDR-FREEFORM                          
               MOVE SPACES TO LINK-ADDRESS-FORMAT                       
               EVALUATE TRUE                                            
                   WHEN LINK-STREET-NAME > ' '                          
                       MOVE 'A' TO LINK-ADDRESS-FORMAT                  
                   WHEN LINK-FF-STREET-1 > ' '                          
                       MOVE 'B' TO LINK-ADDRESS-FORMAT                  
               END-EVALUATE
           END-IF.                                            
           INSPECT LINK-FIRST-NAME REPLACING ALL '~' BY '-'.            
           INSPECT LINK-MIDDLE-NAME REPLACING ALL '~' BY '-'.           
           INSPECT LINK-LAST-NAME REPLACING ALL '~' BY '-'.             
           INSPECT LINK-FULL-NAME REPLACING ALL '~' BY '-'.             
A05317     IF (LINK-CONTACT-TYPE = 'SU' OR 'PU') AND                    
A05317         LINK-ENTITY-TYPE = 'A' AND                               
A05317         LINK-ACCOUNT-NO = ZEROES AND                             
A05317         LINK-CUSTOMER-NO > ZEROES                                
A05317             MOVE 'C' TO LINK-ENTITY-TYPE
           END-IF.                        
           IF LINK-ENTITY-TYPE = 'A' AND                                
              LINK-ACCOUNT-NO = ZEROES AND                              
              LINK-CUSTOMER-NO > ZEROES                                 
                  MOVE 'Y' TO WS-CONTACT-XFER-FL                        
           ELSE                                                         
               MOVE 'N' TO WS-CONTACT-XFER-FL
           END-IF.                          
           IF LINK-ALLOW-CALL-FL = 'Y'                                  
               MOVE ' ' TO LINK-ALLOW-CALL-FL
           END-IF.                          
           IF LINK-MEMO-BILL-IND = 'N'                                  
               MOVE ' ' TO LINK-MEMO-BILL-IND
           END-IF.                          
           IF LINK-WORK-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-WORK-PHONE-EXT                       
                              LINK-WORK-MOBILE-FL                       
                              LINK-WORK-MKT-FL
           END-IF.                         
           IF LINK-HOME-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-HOME-MOBILE-FL                       
                              LINK-HOME-MKT-FL
           END-IF.                         
           IF LINK-ALT-PHONE-NO <= SPACES                               
               MOVE SPACES TO LINK-ALT-MOBILE-FL                        
                              LINK-ALT-MKT-FL
           END-IF.                          
           IF LINK-ACCESS-LEVEL-CD <= ' ' AND                           
             (LINK-UPDATE-TYPE = 'I' OR 'U')                            
                  PERFORM 7025-ACCESS-LEVEL THRU 7025-EXIT              
                  MOVE D8-ACCESS-LEVEL-CD TO LINK-ACCESS-LEVEL-CD
           END-IF.      
                                                                        
           IF LINK-ADDRESS-FORMAT = 'B' AND                             
              LINK-FF-STREET-1 <= SPACES AND                            
              LINK-FF-STREET-2 <= SPACES AND                            
              LINK-FF-CITY-STATE <= SPACES AND                          
              LINK-FF-ZIP-CODE <= SPACES AND                            
              LINK-FF-COUNTRY <= SPACES                                 
                  MOVE 'YES' TO WS-ADDR-DELETED-FLAG
           END-IF.                   
                                                                        
           IF LINK-ADDRESS-FORMAT = 'A' AND                             
              LINK-HOUSE-NO <= SPACES AND                               
              LINK-ADDR-PREFIX-1 <= SPACES AND                          
              LINK-ADDR-PREFIX-2 <= SPACES AND                          
              LINK-STREET-NAME <= SPACES AND                            
              LINK-STREET-SUFFIX <= SPACES AND                          
              LINK-ADDR-SUFFIX <= SPACES AND                            
              LINK-STREET-LOC-1 <= SPACES AND                           
              LINK-STREET-LOC-2 <= SPACES AND                           
              LINK-TOWN <= SPACES AND                                   
              LINK-STATE <= SPACES AND                                  
              LINK-ZIP-CODE <= SPACES AND                               
              LINK-ZIP-CODE-4 <= SPACES AND                             
              LINK-USPS-DELIV-PT <= SPACES                              
                  MOVE 'YES' TO WS-ADDR-DELETED-FLAG
           END-IF.                   
                                                                        
P00836     IF LINK-CONTACT-TYPE = 'SU' AND                              
P00836        LINK-UPDATE-TYPE = 'I' AND                                
P00836        LINK-ENTITY-TYPE = 'A' AND                                
P00836        WS-ACCOUNT-NO-NUM > 0                                     
P00836            PERFORM 1200-VALIDATE-SECONDARY THRU 1200-EXIT
           END-IF.       
                                                                        
           IF LINK-SS-USERID > SPACES                                   
               MOVE LINK-SS-USERID TO 3K-SALES-SPLS-USER-ID             
               PERFORM 7090-SELECT-SALES-SPCL THRU 7090-EXIT            
               MOVE 3K-FIRST-NAME TO WS-NEW-SS-FIRST-NAME               
               MOVE 3K-MIDDLE-NAME TO WS-NEW-SS-MIDDLE-NAME             
               MOVE 3K-LAST-NAME TO WS-NEW-SS-LAST-NAME                 
           ELSE                                                         
               MOVE SPACES TO 3K-SALES-SPLS-USER-ID
           END-IF.                    
                                                                        
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE WS-CUSTOMER-NO-NUM       TO MH-CUSTOMER-NO.             
           MOVE WS-PREMISE-NO-NUM        TO MH-PREMISE-NO.              
           MOVE WS-ACCOUNT-NO-NUM        TO MH-ACCOUNT-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL433'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 1200-VALIDATE-SECONDARY.                                         
P00836                                                                  
P00836     MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
P00836     PERFORM 7150-SELECT-ACCOUNT THRU 7150-EXIT.                  
P00836     MOVE LINK-FIRST-NAME TO DQ-FIRST-NAME.                       
P00836     MOVE LINK-LAST-NAME TO DQ-LAST-NAME.                         
P00836     PERFORM 7160-CHECK-SU THRU 7160-EXIT.                        
P00836     IF WS-SU-MATCH-FL = 'Y'                                      
P00836         MOVE 'S' TO LINK-UPDATE-TYPE                             
P00836         MOVE CV-CONTACT-ID TO WS-NEW-CONTACT-ID-NUM
           END-IF.             
P00836                                                                  
P00836 1200-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-CONTACT THRU 3000-EXIT           
                   IF LINK-SS-USERID > SPACES                           
                       MOVE 'SS' TO LINK-CONTACT-TYPE                   
                       MOVE WS-NEW-SS-FIRST-NAME TO LINK-FIRST-NAME     
                       MOVE WS-NEW-SS-MIDDLE-NAME TO LINK-MIDDLE-NAME   
                       MOVE WS-NEW-SS-LAST-NAME TO LINK-LAST-NAME       
                       PERFORM 3000-INSERT-CONTACT THRU 3000-EXIT       
                   END-IF                                               
               WHEN 'U'                                                 
                   PERFORM 3100-UPDATE-CONTACT THRU 3100-EXIT           
               WHEN 'D'                                                 
                   PERFORM 3200-DELETE-CONTACT THRU 3200-EXIT           
               WHEN 'V'                                                 
                   PERFORM 3300-VALIDATE-CONTACT THRU 3300-EXIT         
P00836         WHEN 'S'                                                 
P00836             PERFORM 3500-SHARE-CONTACT-ID THRU 3500-EXIT         
               WHEN OTHER                                               
                   PERFORM 3400-INVALID-ACTION THRU 3400-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-CONTACT.                                             
                                                                        
           IF LINK-MEMO-BILL-IND = 'Y' AND                              
              WS-ACCOUNT-NO-NUM > 0                                     
                  MOVE WS-ACCOUNT-NO-NUM TO DW-ACCOUNT-NO               
                  PERFORM 7000-COUNT-MB THRU 7000-EXIT                  
                  EVALUATE TRUE                                         
                      WHEN WS-TOTAL-CT > 9                              
                          MOVE 0 TO S-RETURN-CODE                       
                          MOVE +4 TO S-STATUS-CODE                      
                          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT 
                          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT 
                      WHEN WS-TOTAL-CT = 0                              
                          MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO       
                          MOVE 'Y' TO AT-MEMO-BILL-IND                  
                          PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT    
                  END-EVALUATE
           END-IF.                                         
                                                                        
           PERFORM 6402-GET-NEW-CNTCT-ID THRU 6402-EXIT.                
           MOVE WS-92-NEW-CONTACT-ID TO WS-NEW-CONTACT-ID-NUM.          
           MOVE WS-NEW-CONTACT-ID-CHAR TO RS-CONTACT-ID.                
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
           MOVE WS-91-NEW-NAME-ID TO WS-NEW-NAME-ID-NUM.                
                                                                        
           IF LINK-ADDRESS-FORMAT = 'A' OR 'B'                          
               PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT           
               MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM
           END-IF.         
                                                                        
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           MOVE WS-NEW-NAME-ID-NUM       TO DQ-NAME-ID.                 
           EVALUATE LINK-ENTITY-TYPE                                    
               WHEN 'A'                                                 
                   IF WS-CONTACT-XFER-FL = 'Y'                          
                       MOVE 'CC'             TO DQ-NAME-TYPE            
                   ELSE                                                 
                       MOVE 'AC'             TO DQ-NAME-TYPE            
                   END-IF                                               
               WHEN 'C'                                                 
                   MOVE 'CC'             TO DQ-NAME-TYPE                
               WHEN 'P'                                                 
                   MOVE 'PC'             TO DQ-NAME-TYPE                
           END-EVALUATE.                                                
           MOVE LINK-NAME-FORMAT         TO DQ-NAME-FORMAT.             
           IF LINK-NAME-FORMAT = 'B'                                    
               MOVE LINK-FULL-NAME       TO DQ-FULL-NAME                
           ELSE                                                         
               MOVE SPACES               TO DQ-FULL-NAME
           END-IF.               
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           MOVE LINK-FIRST-NAME          TO DQ-FIRST-NAME.              
           MOVE LINK-MIDDLE-NAME         TO DQ-MIDDLE-NAME.             
           MOVE LINK-LAST-NAME           TO DQ-LAST-NAME.               
           MOVE LINK-TITLE               TO DQ-TITLE-PREFIX.            
           MOVE LINK-SUFFIX              TO DQ-TITLE-SUFFIX-1.          
           MOVE SPACES                   TO DQ-TITLE-SUFFIX-2.          
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           PERFORM 8025-INSERT-NAME THRU 8025-EXIT.                     
                                                                        
           EVALUATE LINK-ADDRESS-FORMAT                                 
               WHEN 'A'                                                 
                   PERFORM 3020-INSERT-FMT-ADDRESS THRU 3020-EXIT       
               WHEN 'B'                                                 
                   PERFORM 3010-INSERT-FF-ADDRESS THRU 3010-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE WS-NEW-CONTACT-ID-NUM    TO CV-CONTACT-ID.              
           MOVE LINK-CONTACT-TYPE        TO CV-CONTACT-TYPE.            
           MOVE +1                       TO CV-CONTACT-ORDER.           
           MOVE WS-NEW-NAME-ID-NUM       TO CV-NAME-ID.                 
           MOVE LINK-ADDRESS-FORMAT      TO CV-ADDRESS-FORMAT.          
           IF LINK-ADDRESS-FORMAT = 'A' OR 'B'                          
               MOVE WS-NEW-ADDR-ID-NUM       TO CV-ADDRESS-ID           
           ELSE                                                         
               MOVE ZEROES               TO CV-ADDRESS-ID
           END-IF.              
           MOVE WS-POSITION-TEXT         TO CV-CONTACT-POSITION-TEXT.   
           MOVE WS-POSITION-LEN          TO CV-CONTACT-POSITION-LEN.    
           MOVE WS-CURRENT-DATE          TO CV-DATE-CREATED.            
           MOVE LINK-ACCESS-LEVEL-CD     TO CV-ACCESS-LEVEL-CD.         
           MOVE WS-CURRENT-TIMESTAMP     TO CV-VALIDATION-TS            
                                            CV-LAST-UPDATE-TS.          
           MOVE LINK-EXP-DT              TO CV-CONTACT-EXP-DT.          
           MOVE LINK-EFF-DT              TO CV-CONTACT-EFF-DT.          
           MOVE LINK-EFF-CD              TO CV-EFFECTIVE-CD.            
           MOVE LINK-MEMO-BILL-IND       TO CV-MEMO-BILL-IND.           
           MOVE WS-CONTACT-XFER-FL       TO CV-CONTACT-XFER-FL.         
           PERFORM 8020-INSERT-CONTACT  THRU 8020-EXIT.                 
                                                                        
           IF HMPH-EXISTS                                               
               MOVE WS-NEW-CONTACT-ID-NUM   TO LP-CONTACT-ID            
               MOVE 'H1'                    TO LP-PHONE-TYPE            
               MOVE LINK-HOME-PHONE-NO      TO LP-PHONE-NO              
               MOVE SPACES                  TO LP-EXTENSION-NO          
               MOVE LINK-HOME-MOBILE-FL     TO LP-MOBILE-PHONE-FL       
               MOVE LINK-HOME-MKT-FL        TO LP-PERMISN-TO-MKT-FL     
               IF LINK-HOME-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO LP-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO LP-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF WKPH-EXISTS                                               
               MOVE WS-NEW-CONTACT-ID-NUM   TO LP-CONTACT-ID            
               MOVE 'W1'                    TO LP-PHONE-TYPE            
               MOVE LINK-WORK-PHONE-NO      TO LP-PHONE-NO              
               MOVE LINK-WORK-PHONE-EXT     TO LP-EXTENSION-NO          
               MOVE LINK-WORK-MOBILE-FL     TO LP-MOBILE-PHONE-FL       
               MOVE LINK-WORK-MKT-FL        TO LP-PERMISN-TO-MKT-FL     
               IF LINK-WORK-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO LP-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO LP-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF ALPH-EXISTS                                               
               MOVE WS-NEW-CONTACT-ID-NUM   TO LP-CONTACT-ID            
               MOVE 'A1'                    TO LP-PHONE-TYPE            
               MOVE LINK-ALT-PHONE-NO       TO LP-PHONE-NO              
               MOVE SPACES                  TO LP-EXTENSION-NO          
               MOVE LINK-ALT-MOBILE-FL      TO LP-MOBILE-PHONE-FL       
               MOVE LINK-ALT-MKT-FL         TO LP-PERMISN-TO-MKT-FL     
               IF LINK-ALT-MKT-FL = 'Y' OR 'N'                          
                   MOVE WS-CURRENT-DATE     TO LP-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO LP-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF FXPH-EXISTS                                               
               MOVE WS-NEW-CONTACT-ID-NUM   TO LP-CONTACT-ID            
               MOVE 'F1'                    TO LP-PHONE-TYPE            
               MOVE LINK-FAX-PHONE-NO       TO LP-PHONE-NO              
               MOVE SPACES                  TO LP-EXTENSION-NO          
               MOVE LINK-FAX-MOBILE-FL      TO LP-MOBILE-PHONE-FL       
               MOVE LINK-FAX-MKT-FL         TO LP-PERMISN-TO-MKT-FL     
               IF LINK-FAX-MKT-FL = 'Y' OR 'N'                          
                   MOVE WS-CURRENT-DATE     TO LP-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO LP-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF CSTS-EXISTS                                               
               MOVE WS-NEW-CONTACT-ID-NUM   TO 3H-CONTACT-ID            
               MOVE LINK-TAX-ID             TO 3H-TAX-ID                
               MOVE LINK-WEBSITE-ADDR       TO 3H-WEBSITE-ADDR          
               MOVE LINK-DATE-OF-BIRTH      TO 3H-DATE-OF-BIRTH         
               MOVE LINK-EMPLOYEE-TITLE     TO 3H-EMPLOYEE-TITLE        
               MOVE LINK-BUSINESS-NAME      TO 3H-BUSINESS-NAME         
               MOVE LINK-EMPLOYER           TO 3H-EMPLOYER              
               MOVE LINK-OTHER-ID-TYPE      TO 3H-OTHER-ID-TYPE         
               MOVE LINK-OTHER-ID           TO 3H-OTHER-ID              
               MOVE LINK-DLN-STATE          TO 3H-CODE-STATE-ID         
               MOVE LINK-DLN                TO 3H-DRIVERS-LICENSE-NO    
               MOVE LINK-SSN                TO 3H-SSN                   
               MOVE LINK-ITIN               TO 3H-ITIN-ID               
               MOVE LINK-ALLOW-CALL-FL      TO 3H-ALLOW-CALL-FL         
               PERFORM 8050-INSERT-CONT-STATS THRU 8050-EXIT
           END-IF.           
                                                                        
           EVALUATE LINK-ENTITY-TYPE                                    
               WHEN 'A'                                                 
                   IF WS-CONTACT-XFER-FL = 'Y'                          
                       MOVE WS-NEW-CONTACT-ID-NUM TO DT-CONTACT-ID      
                       MOVE WS-CUSTOMER-NO-NUM TO DT-CUSTOMER-NO        
                       PERFORM 8070-INSERT-CONT-CUST THRU 8070-EXIT     
                   ELSE                                                 
                       MOVE WS-NEW-CONTACT-ID-NUM TO DW-CONTACT-ID      
                       MOVE WS-ACCOUNT-NO-NUM TO DW-ACCOUNT-NO          
                       PERFORM 8060-INSERT-CONT-ACCT THRU 8060-EXIT     
                   END-IF                                               
               WHEN 'C'                                                 
                   MOVE WS-NEW-CONTACT-ID-NUM TO DT-CONTACT-ID          
                   MOVE WS-CUSTOMER-NO-NUM TO DT-CUSTOMER-NO            
                   PERFORM 8070-INSERT-CONT-CUST THRU 8070-EXIT         
               WHEN 'P'                                                 
                   MOVE WS-NEW-CONTACT-ID-NUM TO DX-CONTACT-ID          
                   MOVE WS-PREMISE-NO-NUM TO DX-PREMISE-NO              
                   PERFORM 8080-INSERT-CONT-PREM THRU 8080-EXIT         
           END-EVALUATE.                                                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-INSERT-FF-ADDRESS.                                          
                                                                        
           INITIALIZE DCLCSS-ADDR-FREEFORM.                             
           MOVE WS-NEW-ADDR-ID-NUM TO DZ-ADDRESS-ID.                    
           MOVE LINK-FF-STREET-1 TO DZ-ADDR-STREET.                     
           MOVE LINK-FF-STREET-2 TO DZ-ADDRESS-OVERFLOW.                
           MOVE LINK-FF-CITY-STATE TO DZ-ADDR-CITY-STATE.               
           MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE.                   
           MOVE LINK-FF-COUNTRY TO DZ-ADDR-COUNTRY.                     
           MOVE WS-CURRENT-TIMESTAMP TO DZ-LAST-UPDATE-TS.              
           PERFORM 8000-INSERT-FF-ADDR THRU 8000-EXIT.                  
           IF LINK-FF-COUNTRY <= SPACES AND                             
              LINK-FF-ZIP-CODE(1:5) > SPACES AND                        
              LINK-FF-ZIP-CODE(1:5) NUMERIC                             
                  MOVE LINK-FF-ZIP-CODE(1:5) TO A4-ZIP-CODE             
                  PERFORM 7140-VALIDATE-ZIP THRU 7140-EXIT              
                  IF A4-ZIP-CODE-TOKEN = SPACES                         
ACT233                MOVE 428                TO CATEGORY-ID-4675       
ACT233                MOVE SPACES             TO RESP-AREA-ID-4675      
ACT233                MOVE ZERO               TO SERV-ORDER-NO-4675     
ACT233                MOVE LINK-USERID        TO USER-ID-ORIG-4675      
ACT233                MOVE SPACES             TO DATE-CREATED-4675      
ACT233                MOVE SPACES             TO DATE-REQUIRED-4675     
ACT233                MOVE WS-ACCOUNT-NO-NUM  TO ACCOUNT-NO-4675        
ACT233                MOVE WS-PREMISE-NO-NUM  TO PREMISE-NO-4675        
ACT233                MOVE WS-CUSTOMER-NO-NUM TO CUSTOMER-NO-4675       
ACT233                MOVE SPACES             TO LOCAL-OFFICE-4675      
ACT233                MOVE '4'                TO ROUTING-CATEGORY-4675  
ACT233                MOVE 'N'                TO WQ-PRIORITY-4675       
ACT233                MOVE 'CSR04705'         TO CREATED-BY-4675        
                      MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE          
                      STRING 'THE CITY STATE ZIPCODE '                  
                             LINK-FF-CITY-STATE                         
                             ' '                                        
                             LINK-FF-ZIP-CODE(1:5)                      
                             ' '                                        
                             'DOES NOT EXIST IN THE TABLE.'             
                             DELIMITED BY SIZE INTO WS-EMB-INPUT        
                      PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT
ACT233                MOVE WS-CMP-TABLE TO COMMENTS-4675-TEXT           
ACT233                MOVE +88 TO COMMENTS-4675-LEN                     
ACT233                MOVE SPACES           TO FREE-FORM-DATA-4675-TEXT 
ACT233                MOVE ZERO             TO FREE-FORM-DATA-4675-LEN  
ACT233                PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT
                  END-IF
           END-IF.        
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3020-INSERT-FMT-ADDRESS.                                         
                                                                        
           MOVE LINK-TOWN TO A4-TOWN.                                   
           MOVE LINK-STATE TO A4-STATE.                                 
           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE.                           
           PERFORM 7010-GET-TOKEN THRU 7010-EXIT.                       
                                                                        
           INITIALIZE DCLCSS-ADDR-FORMATTED.                            
           MOVE WS-NEW-ADDR-ID-NUM TO DY-ADDRESS-ID.                    
           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO.                           
           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1.                 
           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2.                 
           MOVE LINK-STREET-NAME TO DY-STREET-NAME.                     
           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX.                 
           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX.                     
           MOVE LINK-STREET-LOC-1 TO DY-STREET-LOCATION-1.              
           MOVE LINK-STREET-LOC-2 TO DY-STREET-LOCATION-2.              
           MOVE LINK-ZIP-CODE TO DY-ZIP-CODE.                           
           MOVE LINK-ZIP-CODE-4 TO DY-ZIP-CODE-PLUS-FOUR.               
           MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN.                 
           MOVE 'F' TO DY-ADDR-USAGE-CD.                                
           MOVE LINK-USPS-DELIV-PT TO DY-USPS-DELIV-PT-CD.              
           MOVE WS-CURRENT-TIMESTAMP TO DY-LAST-UPDATE-TS.              
           PERFORM 8010-INSERT-FMT-ADDR THRU 8010-EXIT.                 
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-CONTACT.                                             
                                                                        
           MOVE WS-CONTACT-ID-NUM TO CV-CONTACT-ID.                     
           MOVE LINK-CONTACT-ID TO RS-CONTACT-ID.                       
                                                                        
           PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT.            
                                                                        
P00836     IF WS-ENTITY-TYPE = 'A' AND                                  
P00836        CV-CONTACT-TYPE = 'SU'                                    
P00836            MOVE CV-CONTACT-ID TO DW-CONTACT-ID                   
P00836            PERFORM 7190-OPEN-CONTACT-CURSOR THRU 7190-EXIT       
P00836            PERFORM 3120-FETCH-ROWS THRU 3120-EXIT                
P00836            PERFORM 7191-CLOSE-CONTACT-CURSOR THRU 7191-EXIT      
P00836     ELSE                                                         
               PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT
           END-IF.        
                                                                        
           IF LINK-MEMO-BILL-IND = 'Y' AND                              
             (CV-MEMO-BILL-IND = 'N' OR ' ') AND                        
              DW-ACCOUNT-NO > 0                                         
                  PERFORM 7000-COUNT-MB THRU 7000-EXIT                  
                  EVALUATE TRUE                                         
                      WHEN WS-TOTAL-CT > 9                              
                          MOVE 0 TO S-RETURN-CODE                       
                          MOVE +4 TO S-STATUS-CODE                      
                          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT 
                          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT 
                      WHEN WS-TOTAL-CT = 0                              
                          MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO       
                          MOVE 'Y' TO AT-MEMO-BILL-IND                  
                          PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT    
                  END-EVALUATE
           END-IF.                                         
           IF (LINK-MEMO-BILL-IND = 'N' OR ' ') AND                     
               CV-MEMO-BILL-IND = 'Y' AND                               
               DW-ACCOUNT-NO > 0                                        
                  PERFORM 7000-COUNT-MB THRU 7000-EXIT                  
                  EVALUATE TRUE                                         
                      WHEN WS-TOTAL-CT = 1                              
                          MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO       
                          MOVE ' ' TO AT-MEMO-BILL-IND                  
                          PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT    
                  END-EVALUATE
           END-IF.                                         
                                                                        
           IF CSTS-CHANGED                                              
               MOVE CV-CONTACT-ID TO 3H-CONTACT-ID                      
               MOVE LINK-TAX-ID TO 3H-TAX-ID                            
               MOVE LINK-WEBSITE-ADDR TO 3H-WEBSITE-ADDR                
               MOVE LINK-DATE-OF-BIRTH TO 3H-DATE-OF-BIRTH              
               MOVE LINK-EMPLOYEE-TITLE TO 3H-EMPLOYEE-TITLE            
               MOVE LINK-BUSINESS-NAME TO 3H-BUSINESS-NAME              
               MOVE LINK-EMPLOYER TO 3H-EMPLOYER                        
               MOVE LINK-OTHER-ID-TYPE TO 3H-OTHER-ID-TYPE              
               MOVE LINK-OTHER-ID TO 3H-OTHER-ID                        
               MOVE LINK-DLN-STATE TO 3H-CODE-STATE-ID                  
               MOVE LINK-DLN TO 3H-DRIVERS-LICENSE-NO                   
               MOVE LINK-SSN TO 3H-SSN                                  
               MOVE LINK-ITIN TO 3H-ITIN-ID                             
               MOVE LINK-ALLOW-CALL-FL TO 3H-ALLOW-CALL-FL              
               IF CSTS-EXISTS                                           
                   PERFORM 8340-UPDATE-CSTS THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-CSTS THRU 8190-EXIT         
               ELSE                                                     
                   PERFORM 8050-INSERT-CONT-STATS THRU 8050-EXIT
               END-IF
           END-IF.       
                                                                        
           IF NAME-CHANGED                                              
               MOVE CV-NAME-ID TO DQ-NAME-ID                            
               MOVE LINK-NAME-FORMAT TO DQ-NAME-FORMAT                  
               MOVE LINK-FIRST-NAME TO DQ-FIRST-NAME                    
               MOVE LINK-MIDDLE-NAME TO DQ-MIDDLE-NAME                  
               MOVE LINK-LAST-NAME TO DQ-LAST-NAME                      
               MOVE LINK-TITLE TO DQ-TITLE-PREFIX                       
               MOVE LINK-SUFFIX TO DQ-TITLE-SUFFIX-1                    
               MOVE LINK-FULL-NAME TO DQ-FULL-NAME                      
               PERFORM 8370-UPDATE-NAME THRU 8370-EXIT
           END-IF.                 
                                                                        
                                                                        
           IF ADDR-ADDED                                                
               MOVE 'NO' TO WS-ADDR-CHANGED-FLAG                        
               PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT           
               MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM          
                                            CV-ADDRESS-ID               
               EVALUATE LINK-ADDRESS-FORMAT                             
                   WHEN 'A'                                             
                       PERFORM 3020-INSERT-FMT-ADDRESS THRU 3020-EXIT   
                   WHEN 'B'                                             
                       PERFORM 3010-INSERT-FF-ADDRESS THRU 3010-EXIT    
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF ADDR-DELETED AND                                          
              CV-ADDRESS-ID > ZEROES                                    
                  MOVE ZEROES TO CV-ADDRESS-ID                          
                  MOVE SPACES TO CV-ADDRESS-FORMAT                      
                  MOVE 'YES' TO WS-CONT-CHANGED-FLAG
           END-IF.                   
           IF CV-ADDRESS-ID = ZEROES AND                                
              CV-ADDRESS-FORMAT > SPACES                                
                  MOVE SPACES TO CV-ADDRESS-FORMAT                      
                  MOVE 'YES' TO WS-CONT-CHANGED-FLAG
           END-IF.                   
                                                                        
           IF CONT-CHANGED                                              
               MOVE LINK-CONTACT-TYPE TO CV-CONTACT-TYPE                
               MOVE LINK-POSITION TO CV-CONTACT-POSITION                
               MOVE LINK-ACCESS-LEVEL-CD TO CV-ACCESS-LEVEL-CD          
               MOVE LINK-EXP-DT TO CV-CONTACT-EXP-DT                    
               MOVE LINK-EFF-DT TO CV-CONTACT-EFF-DT                    
               MOVE LINK-EFF-CD TO CV-EFFECTIVE-CD                      
               MOVE LINK-ADDRESS-FORMAT TO CV-ADDRESS-FORMAT            
               MOVE LINK-MEMO-BILL-IND TO CV-MEMO-BILL-IND              
               MOVE WS-CURRENT-TIMESTAMP TO CV-LAST-UPDATE-TS           
               PERFORM 8330-UPDATE-CONTACT THRU 8330-EXIT
           END-IF.              
                                                                        
           IF HMPH-CHANGED                                              
              MOVE CV-CONTACT-ID TO LP-CONTACT-ID                       
              MOVE 'H1' TO LP-PHONE-TYPE                                
              MOVE LINK-HOME-PHONE-NO TO LP-PHONE-NO                    
              MOVE SPACES TO LP-EXTENSION-NO                            
              MOVE LINK-HOME-MOBILE-FL TO LP-MOBILE-PHONE-FL            
              MOVE LINK-HOME-MKT-FL TO LP-PERMISN-TO-MKT-FL             
              IF HPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO LP-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF HMPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF WKPH-CHANGED                                              
              MOVE CV-CONTACT-ID TO LP-CONTACT-ID                       
              MOVE 'W1' TO LP-PHONE-TYPE                                
              MOVE LINK-WORK-PHONE-NO TO LP-PHONE-NO                    
              MOVE LINK-WORK-PHONE-EXT TO LP-EXTENSION-NO               
              MOVE LINK-WORK-MOBILE-FL TO LP-MOBILE-PHONE-FL            
              MOVE LINK-WORK-MKT-FL TO LP-PERMISN-TO-MKT-FL             
              IF WPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO LP-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF WKPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF ALPH-CHANGED                                              
              MOVE CV-CONTACT-ID TO LP-CONTACT-ID                       
              MOVE 'A1' TO LP-PHONE-TYPE                                
              MOVE LINK-ALT-PHONE-NO TO LP-PHONE-NO                     
              MOVE SPACES TO LP-EXTENSION-NO                            
              MOVE LINK-ALT-MOBILE-FL TO LP-MOBILE-PHONE-FL             
              MOVE LINK-ALT-MKT-FL TO LP-PERMISN-TO-MKT-FL              
              IF APFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO LP-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF ALPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF FXPH-CHANGED                                              
              MOVE CV-CONTACT-ID TO LP-CONTACT-ID                       
              MOVE 'F1' TO LP-PHONE-TYPE                                
              MOVE LINK-FAX-PHONE-NO TO LP-PHONE-NO                     
              MOVE SPACES TO LP-EXTENSION-NO                            
              MOVE LINK-FAX-MOBILE-FL TO LP-MOBILE-PHONE-FL             
              MOVE LINK-FAX-MKT-FL TO LP-PERMISN-TO-MKT-FL              
              IF FPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO LP-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF FXPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF ADDR-CHANGED                                              
               IF AFMT-CHANGED                                          
                   EVALUATE LINK-ADDRESS-FORMAT                         
                       WHEN 'A'                                         
                           MOVE CV-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM     
                           PERFORM 3020-INSERT-FMT-ADDRESS THRU         
                                   3020-EXIT                            
                           MOVE CV-ADDRESS-ID TO DZ-ADDRESS-ID          
                           PERFORM 8410-DELETE-FF-ADDRESS THRU 8410-EXIT
                       WHEN 'B'                                         
                           MOVE CV-ADDRESS-ID TO WS-NEW-ADDR-ID-NUM     
                           PERFORM 3010-INSERT-FF-ADDRESS THRU 3010-EXIT
                           MOVE CV-ADDRESS-ID TO DY-ADDRESS-ID          
                           PERFORM 8420-DELETE-FM-ADDRESS THRU 8420-EXIT
                   END-EVALUATE                                         
               ELSE                                                     
                   EVALUATE LINK-ADDRESS-FORMAT                         
                       WHEN 'A'                                         
                           MOVE CV-ADDRESS-ID TO DY-ADDRESS-ID          
                           MOVE LINK-TOWN TO A4-TOWN                    
                           MOVE LINK-STATE TO A4-STATE                  
                           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE            
                                                 DY-ZIP-CODE            
                           PERFORM 7010-GET-TOKEN THRU 7010-EXIT        
                           MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN  
                           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO            
                           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1  
                           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2  
                           MOVE LINK-STREET-NAME TO DY-STREET-NAME      
                           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX  
                           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX      
                           MOVE LINK-STREET-LOC-1 TO                    
                                DY-STREET-LOCATION-1                    
                           MOVE LINK-STREET-LOC-2 TO                    
                                DY-STREET-LOCATION-2                    
                           MOVE LINK-ZIP-CODE-4 TO DY-ZIP-CODE-PLUS-FOUR
                           MOVE LINK-USPS-DELIV-PT TO                   
                                DY-USPS-DELIV-PT-CD                     
                           PERFORM 8400-UPDATE-FM-ADDRESS THRU 8400-EXIT
                       WHEN 'B'                                         
                           MOVE CV-ADDRESS-ID TO DZ-ADDRESS-ID          
                           MOVE LINK-FF-STREET-1 TO DZ-ADDR-STREET      
                           MOVE LINK-FF-STREET-2 TO DZ-ADDRESS-OVERFLOW 
                           MOVE LINK-FF-CITY-STATE TO DZ-ADDR-CITY-STATE
                           MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE    
                           MOVE LINK-FF-COUNTRY TO DZ-ADDR-COUNTRY      
                           PERFORM 8390-UPDATE-FF-ADDRESS THRU 8390-EXIT
                   END-EVALUATE
               END-IF
           END-IF.                                        
                                                                        
           IF SPLS-CHANGED                                              
               EVALUATE WS-SPLS-FL                                      
                   WHEN 'A'                                             
                       MOVE 'SS' TO LINK-CONTACT-TYPE                   
                       MOVE WS-NEW-SS-FIRST-NAME TO LINK-FIRST-NAME     
                       MOVE WS-NEW-SS-MIDDLE-NAME TO LINK-MIDDLE-NAME   
                       MOVE WS-NEW-SS-LAST-NAME TO LINK-LAST-NAME       
                       MOVE DW-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM          
                       PERFORM 3000-INSERT-CONTACT THRU 3000-EXIT       
                   WHEN 'U'                                             
                       MOVE WS-SS-NAME-ID TO CV-NAME-ID                 
                                             DQ-NAME-ID                 
                       PERFORM 7070-SELECT-NAME THRU 7070-EXIT          
                       MOVE DQ-FIRST-NAME TO WS-OLD-SS-FIRST-NAME       
                       MOVE DQ-MIDDLE-NAME TO WS-OLD-SS-MIDDLE-NAME     
                       MOVE DQ-LAST-NAME TO WS-OLD-SS-LAST-NAME         
                       MOVE WS-NEW-SS-FIRST-NAME TO DQ-FIRST-NAME       
                       MOVE WS-NEW-SS-MIDDLE-NAME TO DQ-MIDDLE-NAME     
                       MOVE WS-NEW-SS-LAST-NAME TO DQ-LAST-NAME         
                       MOVE SPACES TO DQ-FULL-NAME                      
                                      DQ-TITLE-PREFIX                   
                                      DQ-TITLE-SUFFIX-1                 
                       PERFORM 8370-UPDATE-NAME THRU 8370-EXIT          
                       PERFORM 3110-SPLS-TRANSHIST THRU 3110-EXIT       
                   WHEN 'D'                                             
                       IF WS-SS-NAME-ID > 0                             
                           MOVE WS-SS-NAME-ID TO CV-NAME-ID             
                           PERFORM 7070-SELECT-NAME THRU 7070-EXIT      
                           MOVE DQ-FIRST-NAME TO WS-OLD-SS-FIRST-NAME   
                           MOVE DQ-MIDDLE-NAME TO WS-OLD-SS-MIDDLE-NAME 
                           MOVE DQ-LAST-NAME TO WS-OLD-SS-LAST-NAME     
                           MOVE SPACES TO WS-NEW-SS-FIRST-NAME          
                                          WS-NEW-SS-MIDDLE-NAME         
                                          WS-NEW-SS-LAST-NAME           
                           PERFORM 3110-SPLS-TRANSHIST THRU 3110-EXIT   
                       END-IF                                           
                       IF WS-SS-CONTACT-ID > 0                          
                           MOVE WS-SS-CONTACT-ID TO CV-CONTACT-ID       
                           PERFORM 8160-DELETE-CONTACT THRU 8160-EXIT   
                       END-IF                                           
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF ENTY-CHANGED                                              
               EVALUATE WS-ENTITY-TYPE                                  
                   WHEN 'A'                                             
                       MOVE WS-OLD-ACCOUNT-NO TO DW-ACCOUNT-NO          
                       MOVE CV-CONTACT-ID TO DW-CONTACT-ID              
                       PERFORM 8430-DELETE-CONT-ACCT THRU 8430-EXIT     
                   WHEN 'C'                                             
                       MOVE WS-OLD-CUSTOMER-NO TO DT-CUSTOMER-NO        
                       MOVE CV-CONTACT-ID TO DT-CONTACT-ID              
                       PERFORM 8440-DELETE-CONT-CUST THRU 8440-EXIT     
                   WHEN 'P'                                             
                       MOVE WS-OLD-PREMISE-NO TO DX-PREMISE-NO          
                       MOVE CV-CONTACT-ID TO DX-CONTACT-ID              
                       PERFORM 8450-DELETE-CONT-PREM THRU 8450-EXIT     
               END-EVALUATE                                             
               EVALUATE LINK-ENTITY-TYPE                                
                   WHEN 'A'                                             
                       MOVE WS-ACCOUNT-NO-NUM TO DW-ACCOUNT-NO          
                       MOVE CV-CONTACT-ID TO DW-CONTACT-ID              
                       PERFORM 8060-INSERT-CONT-ACCT THRU 8060-EXIT     
                   WHEN 'C'                                             
                       MOVE WS-CUSTOMER-NO-NUM TO DT-CUSTOMER-NO        
                       MOVE CV-CONTACT-ID TO DT-CONTACT-ID              
                       PERFORM 8070-INSERT-CONT-CUST THRU 8070-EXIT     
                   WHEN 'P'                                             
                       MOVE WS-PREMISE-NO-NUM TO DX-PREMISE-NO          
                       MOVE CV-CONTACT-ID TO DX-CONTACT-ID              
                       PERFORM 8080-INSERT-CONT-PREM THRU 8080-EXIT     
               END-EVALUATE
           END-IF.                                            
                                                                        
           MOVE WS-CONTACT-ID-NUM TO CV-CONTACT-ID.                     
           MOVE WS-CURRENT-TIMESTAMP TO CV-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3110-SPLS-TRANSHIST.                                             
                                                                        
           IF WS-OLD-SS-FIRST-NAME NOT = WS-NEW-SS-FIRST-NAME           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF WS-NEW-SS-FIRST-NAME > SPACES                          
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-NEW-SS-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF WS-OLD-SS-FIRST-NAME > SPACES                          
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-OLD-SS-FIRST-NAME  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-OLD-SS-MIDDLE-NAME NOT = WS-NEW-SS-MIDDLE-NAME         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF WS-NEW-SS-MIDDLE-NAME > SPACES                         
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-NEW-SS-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF WS-OLD-SS-MIDDLE-NAME > SPACES                         
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-OLD-SS-MIDDLE-NAME TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-OLD-SS-LAST-NAME NOT = WS-NEW-SS-LAST-NAME             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF WS-NEW-SS-LAST-NAME > SPACES                           
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-NEW-SS-LAST-NAME TO   MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF WS-OLD-SS-LAST-NAME > SPACES                           
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-OLD-SS-LAST-NAME TO   MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 3120-FETCH-ROWS.                                                 
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         FETCH CONTACT-CURSOR                                     
P00836          INTO :DW-ACCOUNT-NO                                     
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN NOT-FOUND                                           
P00836             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00836             GO TO 3120-EXIT                                      
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '3120'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836             MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
P00836             MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
P00836             MOVE DW-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00836             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00836             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836     EXEC SQL                                                     
P00836          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836     MOVE WS-CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO.           
P00836     MOVE DW-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
P00836     MOVE 1 TO WS-TRAN-APPL-NO                                    
P00836               MI-TRAN-APPL-NO.                                   
P00836     PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT.            
P00836                                                                  
P00836     GO TO 3120-FETCH-ROWS.                                       
P00836                                                                  
P00836 3120-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
       3200-DELETE-CONTACT.                                             
                                                                        
           MOVE LINK-CONTACT-ID TO RS-CONTACT-ID.                       
           MOVE WS-CONTACT-ID-NUM TO CV-CONTACT-ID.                     
           PERFORM 7020-SELECT-CONTACT THRU 7020-EXIT.                  
                                                                        
           MOVE ZEROES TO DW-ACCOUNT-NO                                 
                          DT-CUSTOMER-NO                                
                          DX-PREMISE-NO.                                
           MOVE SPACES TO WS-ENTITY-TYPE.                               
           PERFORM 7100-SELECT-CONT-ACCT THRU 7100-EXIT.                
           IF WS-ENTITY-TYPE = SPACES                                   
               PERFORM 7110-SELECT-CONT-CUST THRU 7110-EXIT
           END-IF.            
           IF WS-ENTITY-TYPE = SPACES                                   
               PERFORM 7120-SELECT-CONT-PREM THRU 7120-EXIT
           END-IF.            
           MOVE DW-ACCOUNT-NO         TO MH-ACCOUNT-NO.                 
           MOVE DT-CUSTOMER-NO        TO MH-CUSTOMER-NO.                
           MOVE DX-PREMISE-NO         TO MH-PREMISE-NO.                 
                                                                        
           IF CV-CONTACT-TYPE = 'SA' OR 'SE' OR 'SG' OR 'PG'            
A05317         EVALUATE WS-ENTITY-TYPE                                  
A05317             WHEN 'C'                                             
A05317                 PERFORM 7180-SS-CONTACT-CUST THRU 7180-EXIT      
A05317             WHEN 'A'                                             
A05317                 PERFORM 7130-SS-CONTACT-ACCT THRU 7130-EXIT      
A05317         END-EVALUATE
           END-IF.                                            
                                                                        
           IF CV-MEMO-BILL-IND = 'Y' AND                                
              DW-ACCOUNT-NO > 0                                         
                  PERFORM 7000-COUNT-MB THRU 7000-EXIT                  
                  EVALUATE TRUE                                         
                      WHEN WS-TOTAL-CT = 1                              
                          MOVE DW-ACCOUNT-NO TO AT-ACCOUNT-NO           
                          MOVE ' ' TO AT-MEMO-BILL-IND                  
                          PERFORM 8090-UPDATE-ACCOUNT THRU 8090-EXIT    
                  END-EVALUATE
           END-IF.                                         
                                                                        
P00836     IF WS-ENTITY-TYPE = 'A' AND                                  
P00836        CV-CONTACT-TYPE = 'SU'                                    
P00836            MOVE CV-CONTACT-ID TO DW-CONTACT-ID                   
P00836            PERFORM 7190-OPEN-CONTACT-CURSOR THRU 7190-EXIT       
P00836            PERFORM 3210-FETCH-ROWS THRU 3210-EXIT                
P00836            PERFORM 7191-CLOSE-CONTACT-CURSOR THRU 7191-EXIT      
P00836     ELSE                                                         
P00836         PERFORM 3220-TRANSHIST-FOR-DELETE THRU 3220-EXIT
           END-IF.        
                                                                        
           PERFORM 8160-DELETE-CONTACT THRU 8160-EXIT.                  
                                                                        
           IF CV-CONTACT-TYPE = 'SA' OR 'SE' OR 'SG' OR 'PG'            
               IF WS-SS-CONTACT-ID > 0                                  
                   MOVE WS-SS-CONTACT-ID TO CV-CONTACT-ID               
                   PERFORM 7020-SELECT-CONTACT THRU 7020-EXIT           
P00836             PERFORM 3220-TRANSHIST-FOR-DELETE THRU 3220-EXIT     
                   PERFORM 8160-DELETE-CONTACT THRU 8160-EXIT
               END-IF
           END-IF.          
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 3210-FETCH-ROWS.                                                 
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         FETCH CONTACT-CURSOR                                     
P00836          INTO :DW-ACCOUNT-NO                                     
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN NOT-FOUND                                           
P00836             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00836             GO TO 3210-EXIT                                      
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '3210'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836             MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
P00836             MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
P00836             MOVE DW-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00836             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00836             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836     EXEC SQL                                                     
P00836          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836     MOVE WS-CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO.           
P00836     MOVE DW-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
P00836     MOVE 1 TO WS-TRAN-APPL-NO                                    
P00836               MI-TRAN-APPL-NO.                                   
P00836     PERFORM 3220-TRANSHIST-FOR-DELETE THRU 3220-EXIT.            
P00836                                                                  
P00836     GO TO 3210-FETCH-ROWS.                                       
P00836                                                                  
P00836 3210-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
P00836 3220-TRANSHIST-FOR-DELETE.                                       
P00836                                                                  
P00836     MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
P00836     MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
P00836     MOVE +72                   TO MI-PRV-COLUMN-VALUE-LEN.       
P00836     MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
P00836     MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
P00836     EVALUATE DQ-NAME-FORMAT                                      
P00836         WHEN 'I'                                                 
P00836             MOVE WS-CONTACT-NAME TO MI-PRV-COLUMN-VALUE-TEXT     
P00836         WHEN 'B'                                                 
P00836             MOVE DQ-FULL-NAME  TO MI-PRV-COLUMN-VALUE-TEXT       
P00836     END-EVALUATE.                                                
P00836     STRING CV-CONTACT-TYPE                                       
P00836            ' '                                                   
P00836            'CONTACT'                                             
P00836            DELIMITED BY SIZE                                     
P00836            INTO MI-COLUMN-DESC                                   
P00836     END-STRING.                                                  
P00836     MOVE SPACES TO MI-TABLE-ID.                                  
P00836     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00836     ADD 1 TO WS-TRAN-APPL-NO.                                    
P00836                                                                  
P00836 3220-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
       3300-VALIDATE-CONTACT.                                           
                                                                        
           MOVE LINK-CONTACT-ID TO RS-CONTACT-ID.                       
           MOVE WS-CONTACT-ID-NUM TO CV-CONTACT-ID.                     
           MOVE WS-CURRENT-TIMESTAMP TO CV-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
           PERFORM 7020-SELECT-CONTACT THRU 7020-EXIT.                  
           MOVE ZEROES TO DW-ACCOUNT-NO                                 
                          DT-CUSTOMER-NO                                
                          DX-PREMISE-NO.                                
           MOVE SPACES TO WS-ENTITY-TYPE.                               
           PERFORM 7100-SELECT-CONT-ACCT THRU 7100-EXIT.                
           IF WS-ENTITY-TYPE = SPACES                                   
               PERFORM 7110-SELECT-CONT-CUST THRU 7110-EXIT
           END-IF.            
           IF WS-ENTITY-TYPE = SPACES                                   
               PERFORM 7120-SELECT-CONT-PREM THRU 7120-EXIT
           END-IF.            
                                                                        
P00836     IF WS-ENTITY-TYPE = 'A' AND                                  
P00836        CV-CONTACT-TYPE = 'SU'                                    
P00836            MOVE CV-CONTACT-ID TO DW-CONTACT-ID                   
P00836            PERFORM 7190-OPEN-CONTACT-CURSOR THRU 7190-EXIT       
P00836            PERFORM 3310-FETCH-ROWS THRU 3310-EXIT                
P00836            PERFORM 7191-CLOSE-CONTACT-CURSOR THRU 7191-EXIT      
P00836     ELSE                                                         
P00836         PERFORM 3320-TRANSHIST-FOR-VALIDATE THRU 3320-EXIT
           END-IF.      
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 3310-FETCH-ROWS.                                                 
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         FETCH CONTACT-CURSOR                                     
P00836          INTO :DW-ACCOUNT-NO                                     
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN NOT-FOUND                                           
P00836             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00836             GO TO 3310-EXIT                                      
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '3310'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836             MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
P00836             MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
P00836             MOVE DW-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00836             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00836             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836     EXEC SQL                                                     
P00836          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836     MOVE WS-CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO.           
P00836     MOVE DW-ACCOUNT-NO TO MH-ACCOUNT-NO.                         
P00836     MOVE 1 TO WS-TRAN-APPL-NO                                    
P00836               MI-TRAN-APPL-NO.                                   
P00836     PERFORM 3320-TRANSHIST-FOR-VALIDATE THRU 3320-EXIT.          
P00836                                                                  
P00836     GO TO 3310-FETCH-ROWS.                                       
P00836                                                                  
P00836 3310-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
P00836 3320-TRANSHIST-FOR-VALIDATE.                                     
P00836                                                                  
P00836     MOVE DW-ACCOUNT-NO         TO MH-ACCOUNT-NO.                 
P00836     MOVE DT-CUSTOMER-NO        TO MH-CUSTOMER-NO.                
P00836     MOVE DX-PREMISE-NO         TO MH-PREMISE-NO.                 
P00836     MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
P00836     MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
P00836     MOVE +72                   TO MI-PRV-COLUMN-VALUE-LEN.       
P00836     MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN.       
P00836     MOVE '*CONFIRMED*'         TO MI-CHG-COLUMN-VALUE-TEXT.      
P00836     EVALUATE DQ-NAME-FORMAT                                      
P00836         WHEN 'I'                                                 
P00836             MOVE WS-CONTACT-NAME TO MI-PRV-COLUMN-VALUE-TEXT     
P00836         WHEN 'B'                                                 
P00836             MOVE DQ-FULL-NAME TO MI-PRV-COLUMN-VALUE-TEXT        
P00836     END-EVALUATE.                                                
P00836     STRING CV-CONTACT-TYPE                                       
P00836            ' '                                                   
P00836            'CONTACT'                                             
P00836            DELIMITED BY SIZE                                     
P00836            INTO MI-COLUMN-DESC                                   
P00836     END-STRING                                                   
P00836     MOVE SPACES                TO MI-TABLE-ID.                   
P00836     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00836     ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF CV-CONTACT-TYPE = 'SA' OR 'SE' OR 'SG' OR 'PG'            
A05317         EVALUATE WS-ENTITY-TYPE                                  
A05317             WHEN 'C'                                             
A05317                 PERFORM 7180-SS-CONTACT-CUST THRU 7180-EXIT      
A05317             WHEN 'A'                                             
A05317                 PERFORM 7130-SS-CONTACT-ACCT THRU 7130-EXIT      
A05317         END-EVALUATE                                             
               IF WS-SS-CONTACT-ID > 0                                  
                   MOVE WS-SS-CONTACT-ID TO CV-CONTACT-ID               
                   MOVE WS-CURRENT-TIMESTAMP TO CV-VALIDATION-TS        
                   PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT        
                   PERFORM 7020-SELECT-CONTACT THRU 7020-EXIT           
                   MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO    
                   MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO         
                   MOVE +72                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE +12                  TO MI-CHG-COLUMN-VALUE-LEN 
                   MOVE '*CONFIRMED*'        TO MI-CHG-COLUMN-VALUE-TEXT
                   EVALUATE DQ-NAME-FORMAT                              
                       WHEN 'I'                                         
                           MOVE WS-CONTACT-NAME TO                      
                                MI-PRV-COLUMN-VALUE-TEXT                
                       WHEN 'B'                                         
                           MOVE DQ-FULL-NAME TO MI-PRV-COLUMN-VALUE-TEXT
                   END-EVALUATE                                         
                   STRING CV-CONTACT-TYPE                               
                          ' '                                           
                          'CONTACT'                                     
                          DELIMITED BY SIZE                             
                          INTO MI-COLUMN-DESC                           
                   END-STRING                                           
                   MOVE SPACES                TO MI-TABLE-ID            
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1 TO WS-TRAN-APPL-NO
               END-IF
           END-IF.                            
                                                                        
P00836                                                                  
P00836 3320-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
       3400-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           MOVE 0 TO S-RETURN-CODE.                                     
           MOVE +2 TO S-STATUS-CODE.                                    
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 3500-SHARE-CONTACT-ID.                                           
P00836                                                                  
P00836     PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
P00836                                                                  
P00836     MOVE WS-NEW-CONTACT-ID-NUM TO DW-CONTACT-ID.                 
P00836     MOVE WS-NEW-CONTACT-ID-CHAR TO RS-CONTACT-ID.                
P00836     MOVE WS-ACCOUNT-NO-NUM TO DW-ACCOUNT-NO.                     
P00836     PERFORM 8060-INSERT-CONT-ACCT THRU 8060-EXIT.                
P00836                                                                  
P00836 3500-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
ACT233 4210-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT233        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT233        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT233                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT233                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT233             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT233             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF LINK-CONTACT-TYPE > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-CONTACT-TYPE     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CONTACT TYPE'        TO MI-COLUMN-DESC              
              IF LINK-CONTACT-TYPE = 'SS'                               
                  MOVE SPACES            TO MI-TABLE-ID                 
                  MOVE 'SALES SPECIALIST' TO MI-CHG-COLUMN-VALUE-TEXT   
                  MOVE +17 TO MI-CHG-COLUMN-VALUE-LEN                   
              ELSE                                                      
                  MOVE 'D8'                  TO MI-TABLE-ID             
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID
           END-IF.                               
                                                                        
           IF LINK-ENTITY-TYPE > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +8                    TO MI-CHG-COLUMN-VALUE-LEN     
              EVALUATE LINK-ENTITY-TYPE                                 
                  WHEN 'A'                                              
                      MOVE 'ACCOUNT'     TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'C'                                              
                      MOVE 'CUSTOMER'    TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'P'                                              
                      MOVE 'PREMISE'     TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ENTITY TYPE'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-NAME-FORMAT > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              EVALUATE LINK-NAME-FORMAT                                 
                  WHEN 'I'                                              
                      MOVE 'INDIVIDUAL'  TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'B'                                              
                      MOVE 'BUSINESS'    TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'NAME FORMAT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TITLE > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TITLE            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FIRST-NAME  > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FIRST-NAME       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-MIDDLE-NAME  > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-MIDDLE-NAME  TO MI-CHG-COLUMN-VALUE-TEXT        
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-LAST-NAME > SPACES                                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LAST-NAME        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SUFFIX  > SPACES                                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SUFFIX           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FULL-NAME  > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +70                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FULL-NAME        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FULL NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TAX-ID  > SPACES                                     
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TAX-ID           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'TAX ID'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WEBSITE-ADDR > SPACES                                
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +75                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-WEBSITE-ADDR     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'WEBSITE'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DATE-OF-BIRTH  > SPACES                              
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DATE-OF-BIRTH    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EMPLOYEE-TITLE > SPACES                              
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +50                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EMPLOYEE-TITLE   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMPLOYEE TITLE'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-BUSINESS-NAME > SPACES                               
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +50                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-BUSINESS-NAME    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BUSINESS NAME'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EMPLOYER > SPACES                                    
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +50                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EMPLOYER         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMPLOYER'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-OTHER-ID-TYPE  > SPACES                              
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-OTHER-ID-TYPE    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID TYPE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-OTHER-ID  > SPACES                                   
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +16                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-OTHER-ID         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DLN  > SPACES                                        
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +19                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DLN              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LICENSE NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DLN-STATE  > SPACES                                  
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DLN-STATE        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CODE STATE ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SSN  > SPACES                                        
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SSN              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SSN'                 TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ITIN  > SPACES                                       
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ITIN             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ITIN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALLOW-CALL-FL > SPACES                               
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALLOW-CALL-FL    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALLOW CALL'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-WORK-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'WORK PHONE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-EXT > SPACES                              
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +6                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-PHONE-EXT      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK PHONE EXT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MOBILE-FL      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MOBILE'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MKT-FL         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MARKET'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MKT DT'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-HOME-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PRIMARY PHONE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MOBILE-FL      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MOBILE'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MKT-FL         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MARKET'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MKT DT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-PHONE-NO > SPACES                                
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALT-PHONE-NO     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALT PHONE'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MOBILE-FL = 'Y' OR 'N'                           
              MOVE 'YES'                    TO WS-ALPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MOBILE-FL       TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MOBILE'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MKT-FL = 'Y' OR 'N'                              
              MOVE 'YES'                    TO WS-ALPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MKT-FL          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MARKET'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MKT DT'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FAX-PHONE-NO > SPACES                                
              MOVE 'YES'                 TO WS-FXPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FAX-PHONE-NO     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FAX PHONE'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FAX-MOBILE-FL = 'Y' OR 'N'                           
              MOVE 'YES'                    TO WS-FXPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-FAX-MOBILE-FL       TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'FAX MOBILE'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FAX-MKT-FL = 'Y' OR 'N'                              
              MOVE 'YES'                    TO WS-FXPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-FAX-MKT-FL          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'FAX MARKET'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'FAX MKT DT'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-MEMO-BILL-IND = 'Y'                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-MEMO-BILL-IND    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MEMO BILL'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF WS-POSITION-TEXT > ' '                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-POSITION-TEXT      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'POSITION'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EFF-DT > ' '                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EFF-DT           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EFFECTIVE DT'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EXP-DT > ' '                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EXP-DT           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EXPIRATION DT'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EFF-CD > ' '                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              EVALUATE LINK-EFF-CD                                      
                  WHEN 'D'                                              
                      MOVE 'FROM/TO DATES' TO MI-CHG-COLUMN-VALUE-TEXT  
                  WHEN 'L'                                              
                      MOVE 'LIFE OF ACCOUNT' TO MI-CHG-COLUMN-VALUE-TEXT
                  WHEN OTHER                                            
                      MOVE LINK-EFF-CD       TO MI-CHG-COLUMN-VALUE-TEXT
              END-EVALUATE                                              
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DURATION'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ACCESS-LEVEL-CD > ' '                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ACCESS-LEVEL-CD  TO 3I-ACCESS-LEVEL-CD          
              PERFORM 7015-CONTACT-ACCESS THRU 7015-EXIT                
              MOVE 3I-ACCESS-LEVEL-DESC  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ACCESS LEVEL'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDRESS-FORMAT > SPACES                              
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDRESS-FORMAT   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-STREET-1 > SPACES                                 
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +55                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-STREET-1      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR STREET 1'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-STREET-2 > SPACES                                 
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +55                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-STREET-2      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR STREET 2'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-CITY-STATE > SPACES                               
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-CITY-STATE    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR CITY/ST'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-ZIP-CODE > SPACES                                 
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-ZIP-CODE      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR ZIPCODE'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-COUNTRY > SPACES                                  
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-COUNTRY       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR COUNTRY'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOUSE-NO > SPACES                                    
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-HOUSE-NO         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-PREFIX-1 > SPACES                               
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-PREFIX-1    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-PREFIX-2 > SPACES                               
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-PREFIX-2    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-NAME > SPACES                                 
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-NAME      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-SUFFIX > SPACES                               
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-SUFFIX    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-SUFFIX > SPACES                                 
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-SUFFIX      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-LOC-1 > SPACES                                
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-LOC-1     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET LOC 1'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-LOC-2 > SPACES                                
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-LOC-2     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET LOC 2'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TOWN > SPACES                                        
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +26                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TOWN             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'TOWN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STATE > SPACES                                       
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STATE            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STATE'               TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ZIP-CODE > SPACES                                    
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ZIP-CODE-4 > SPACES                                  
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE-4       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE 4'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-USPS-DELIV-PT > SPACES                               
              MOVE 'YES'                 TO WS-ADDR-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-USPS-DELIV-PT    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DELIVERY PT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF WS-ENTITY-TYPE NOT = LINK-ENTITY-TYPE                     
              MOVE 'YES'                 TO WS-ENTY-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +01                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ENTITY-TYPE      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE WS-ENTITY-TYPE        TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ENTITY TYPE'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CV-CONTACT-TYPE NOT = LINK-CONTACT-TYPE                   
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +02                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-CONTACT-TYPE     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE CV-CONTACT-TYPE       TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CONTACT TYPE'        TO MI-COLUMN-DESC              
              IF LINK-CONTACT-TYPE = 'SS'                               
                  MOVE SPACES             TO MI-TABLE-ID                
                  MOVE 'SALES SPECIALIST' TO MI-CHG-COLUMN-VALUE-TEXT   
                  MOVE +17                TO MI-CHG-COLUMN-VALUE-LEN    
              END-IF                                                    
              IF CV-CONTACT-TYPE = 'SS'                                 
                  MOVE SPACES             TO MI-TABLE-ID                
                  MOVE 'SALES SPECIALIST' TO MI-PRV-COLUMN-VALUE-TEXT   
                  MOVE +17                TO MI-PRV-COLUMN-VALUE-LEN    
              END-IF                                                    
              MOVE 'D8'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID                                
           END-IF.                                                      
                                                                        
           IF DQ-NAME-FORMAT NOT = LINK-NAME-FORMAT                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +11                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-NAME-FORMAT      TO MI-CHG-COLUMN-VALUE-TEXT    
              EVALUATE LINK-NAME-FORMAT                                 
                  WHEN 'B'                                              
                      MOVE 'BUSINESS'    TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'I'                                              
                      MOVE 'INDIVIDUAL'  TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN OTHER                                            
                      MOVE SPACES        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE DQ-NAME-FORMAT        TO MI-PRV-COLUMN-VALUE-TEXT    
              EVALUATE DQ-NAME-FORMAT                                   
                  WHEN 'B'                                              
                      MOVE 'BUSINESS'    TO MI-PRV-COLUMN-VALUE-TEXT    
                  WHEN 'I'                                              
                      MOVE 'INDIVIDUAL'  TO MI-PRV-COLUMN-VALUE-TEXT    
                  WHEN OTHER                                            
                      MOVE SPACES        TO MI-PRV-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE 'NAME FORMAT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-PREFIX NOT = LINK-TITLE                          
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TITLE > SPACES                                    
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TITLE         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-PREFIX > SPACES                               
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-PREFIX    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-FIRST-NAME                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FIRST-NAME > SPACES                               
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-FIRST-NAME > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FIRST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-MIDDLE-NAME NOT = LINK-MIDDLE-NAME                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-MIDDLE-NAME > SPACES                              
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT      
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-MIDDLE-NAME > SPACES                                
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-MIDDLE-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-LAST-NAME NOT = LINK-LAST-NAME                         
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-LAST-NAME > SPACES                                
                 MOVE +40                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-LAST-NAME > SPACES                                  
                 MOVE +40                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-LAST-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-SUFFIX-1 NOT = LINK-SUFFIX                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SUFFIX > SPACES                                   
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SUFFIX        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-SUFFIX-1 > SPACES                             
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-SUFFIX-1  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FULL-NAME NOT = LINK-FULL-NAME AND                     
              LINK-NAME-FORMAT = 'B'                                    
                  MOVE 'YES'              TO WS-NAME-CHANGED-FLAG       
                  MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO            
                  MOVE +70                TO MI-PRV-COLUMN-VALUE-LEN    
                  MOVE +70                TO MI-CHG-COLUMN-VALUE-LEN    
                  MOVE LINK-FULL-NAME     TO MI-CHG-COLUMN-VALUE-TEXT   
                  MOVE DQ-FULL-NAME       TO MI-PRV-COLUMN-VALUE-TEXT   
                  MOVE 'FULL NAME'        TO MI-COLUMN-DESC             
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
           END-IF.                                                      
                                                                        
           IF 3H-TAX-ID NOT = LINK-TAX-ID                               
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TAX-ID > SPACES                                   
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TAX-ID        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-TAX-ID > SPACES                                     
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-TAX-ID          TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'TAX ID'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-WEBSITE-ADDR NOT = LINK-WEBSITE-ADDR                   
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-WEBSITE-ADDR > SPACES                             
                 MOVE +75                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-WEBSITE-ADDR  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-WEBSITE-ADDR > SPACES                               
                 MOVE +75                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-WEBSITE-ADDR    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'WEBSITE ADDR'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-DATE-OF-BIRTH NOT = LINK-DATE-OF-BIRTH                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DATE-OF-BIRTH > SPACES                            
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DATE-OF-BIRTH TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-DATE-OF-BIRTH    > SPACES                           
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-DATE-OF-BIRTH   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-EMPLOYEE-TITLE NOT = LINK-EMPLOYEE-TITLE               
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EMPLOYEE-TITLE > SPACES                           
                 MOVE +50                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-EMPLOYEE-TITLE TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-EMPLOYEE-TITLE   > SPACES                           
                 MOVE +50                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-EMPLOYEE-TITLE  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'EMPLOYEE TITLE'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-BUSINESS-NAME NOT = LINK-BUSINESS-NAME                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-BUSINESS-NAME > SPACES                            
                 MOVE +50                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-BUSINESS-NAME TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-BUSINESS-NAME    > SPACES                           
                 MOVE +50                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-BUSINESS-NAME   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'BUSINESS NAME'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-EMPLOYER NOT = LINK-EMPLOYER                           
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EMPLOYER > SPACES                                 
                 MOVE +50                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-EMPLOYER      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-EMPLOYER         > SPACES                           
                 MOVE +50                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-EMPLOYER        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'EMPLOYER'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-OTHER-ID-TYPE NOT = LINK-OTHER-ID-TYPE                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID-TYPE > SPACES                            
                 MOVE +12                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID-TYPE TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-OTHER-ID-TYPE > SPACES                              
                 MOVE +12                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-OTHER-ID-TYPE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID TYPE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-OTHER-ID NOT = LINK-OTHER-ID                           
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID > SPACES                                 
                 MOVE +16                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID  TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-OTHER-ID > SPACES                                   
                 MOVE +16                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-OTHER-ID        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-DRIVERS-LICENSE-NO NOT = LINK-DLN                      
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN > SPACES                                      
                 MOVE +19                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-DRIVERS-LICENSE-NO > SPACES                         
                 MOVE +19                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-DRIVERS-LICENSE-NO TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LICENSE NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-CODE-STATE-ID NOT = LINK-DLN-STATE                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN-STATE > SPACES                                
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN-STATE     TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-CODE-STATE-ID > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-CODE-STATE-ID   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CODE STATE ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-SSN NOT = LINK-SSN                                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SSN > SPACES                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SSN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-SSN > SPACES                                        
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-SSN             TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SSN'                 TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-ITIN-ID NOT = LINK-ITIN                                
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ITIN > SPACES                                     
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ITIN          TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3H-ITIN-ID > SPACES                                    
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3H-ITIN-ID         TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ITIN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3H-ALLOW-CALL-FL NOT = LINK-ALLOW-CALL-FL                 
              MOVE 'YES'                     TO WS-CSTS-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALLOW-CALL-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALLOW-CALL-FL     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF 3H-ALLOW-CALL-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE 3H-ALLOW-CALL-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALLOW CALL'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-PHONE-NO NOT = LINK-WORK-PHONE-NO                 
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-WORK-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-WORK-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-WORK-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-WORK-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'WORK PHONE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-EXTENSION-NO NOT = LINK-WORK-PHONE-EXT            
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-PHONE-EXT > SPACES                           
                 MOVE +6                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-PHONE-EXT    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-EXTENSION-NO > SPACES                          
                 MOVE +6                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-EXTENSION-NO   TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK PHONE EXT'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MOBILE-FL NOT = LINK-WORK-MOBILE-FL               
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MOBILE'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MKT-FL NOT = LINK-WORK-MKT-FL                     
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
                                                WS-WPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MARKET'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-WORK-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-WORK-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-WORK-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'WORK MKT DT'         TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-HOME-PHONE-NO NOT = LINK-HOME-PHONE-NO                 
              MOVE 'YES'                   TO WS-HMPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-HOME-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-HOME-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-HOME-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-HOME-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'PRIMARY PHONE'         TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MOBILE-FL NOT = LINK-HOME-MOBILE-FL               
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MOBILE'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MKT-FL NOT = LINK-HOME-MKT-FL                     
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
                                                WS-HPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MARKET'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-HOME-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-HOME-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-HOME-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'PRIMARY MKT DT'      TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ALT-PHONE-NO NOT = LINK-ALT-PHONE-NO                   
              MOVE 'YES'                  TO WS-ALPH-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-ALT-PHONE-NO > SPACES                             
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-ALT-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF WS-ALT-PHONE-NO > SPACES                               
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE WS-ALT-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'ALT PHONE'            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MOBILE-FL NOT = LINK-ALT-MOBILE-FL                 
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MOBILE-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MOBILE-FL TO     MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MOBILE-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MOBILE-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MOBILE'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MKT-FL NOT = LINK-ALT-MKT-FL                       
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
                                                WS-APFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MKT-FL > SPACES                               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MKT-FL TO        MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MKT-FL > SPACES                                 
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MKT-FL          TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MARKET'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-ALT-MKT-FL > ' '                                  
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-ALT-MKT-DT > SPACES                             
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-ALT-MKT-DT    TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'ALT MKT DT'          TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-FAX-PHONE-NO NOT = LINK-FAX-PHONE-NO                   
              MOVE 'YES'                  TO WS-FXPH-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-FAX-PHONE-NO > SPACES                             
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-FAX-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF WS-FAX-PHONE-NO > SPACES                               
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE WS-FAX-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'FAX PHONE'            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-FAX-MOBILE-FL NOT = LINK-FAX-MOBILE-FL                 
              MOVE 'YES'                     TO WS-FXPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-FAX-MOBILE-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-FAX-MOBILE-FL TO     MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-FAX-MOBILE-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-FAX-MOBILE-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'FAX MOBILE'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-FAX-MKT-FL NOT = LINK-FAX-MKT-FL                       
              MOVE 'YES'                     TO WS-FXPH-CHANGED-FLAG    
                                                WS-FPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-FAX-MKT-FL > SPACES                               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-FAX-MKT-FL TO        MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-FAX-MKT-FL > SPACES                                 
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-FAX-MKT-FL          TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'FAX MARKET'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-FAX-MKT-FL > ' '                                  
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-FAX-MKT-DT > SPACES                             
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-FAX-MKT-DT    TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'FAX MKT DT'          TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CV-MEMO-BILL-IND = 'N'                                    
               MOVE ' ' TO CV-MEMO-BILL-IND
           END-IF.                            
                                                                        
           IF CV-MEMO-BILL-IND NOT = LINK-MEMO-BILL-IND                 
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-MEMO-BILL-IND > SPACES                            
                 MOVE +1                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-MEMO-BILL-IND TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CV-MEMO-BILL-IND  > SPACES                             
                 MOVE +1                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CV-MEMO-BILL-IND   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'MEMO BILL'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           INSPECT WS-POSITION-TEXT REPLACING ALL LOW-VALUES BY SPACES. 
           INSPECT CV-CONTACT-POSITION-TEXT                             
               REPLACING ALL LOW-VALUES BY SPACES.                      
           IF CV-CONTACT-POSITION-TEXT NOT = WS-POSITION-TEXT           
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF WS-POSITION-TEXT > SPACES                              
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-POSITION-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CV-CONTACT-POSITION-TEXT > SPACES                      
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CV-CONTACT-POSITION-TEXT TO                       
                      MI-PRV-COLUMN-VALUE-TEXT                          
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'POSITION'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CV-CONTACT-EFF-DT NOT = LINK-EFF-DT                       
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EFF-DT  > SPACES                                  
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-EFF-DT        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CV-CONTACT-EFF-DT > SPACES                             
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CV-CONTACT-EFF-DT  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'EFFECTIVE DT'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CV-CONTACT-EXP-DT NOT = LINK-EXP-DT                       
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EXP-DT  > SPACES                                  
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-EXP-DT        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CV-CONTACT-EXP-DT > SPACES                             
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CV-CONTACT-EXP-DT  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'EXPIRATION DT'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CV-EFFECTIVE-CD NOT = LINK-EFF-CD                         
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EFF-CD > SPACES                                   
                 MOVE +15               TO MI-CHG-COLUMN-VALUE-LEN      
                 EVALUATE LINK-EFF-CD                                   
                     WHEN 'D'                                           
                         MOVE 'FROM/TO DATES' TO                        
                              MI-CHG-COLUMN-VALUE-TEXT                  
                     WHEN 'L'                                           
                         MOVE 'LIFE OF ACCOUNT' TO                      
                              MI-CHG-COLUMN-VALUE-TEXT                  
                     WHEN OTHER                                         
                         MOVE LINK-EFF-CD TO MI-CHG-COLUMN-VALUE-TEXT   
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CV-EFFECTIVE-CD > SPACES                               
                 MOVE +15               TO MI-PRV-COLUMN-VALUE-LEN      
                 EVALUATE CV-EFFECTIVE-CD                               
                     WHEN 'D'                                           
                         MOVE 'FROM/TO DATES' TO                        
                              MI-PRV-COLUMN-VALUE-TEXT                  
                     WHEN 'L'                                           
                         MOVE 'LIFE OF ACCOUNT' TO                      
                              MI-PRV-COLUMN-VALUE-TEXT                  
                     WHEN OTHER                                         
                         MOVE CV-EFFECTIVE-CD TO                        
                              MI-PRV-COLUMN-VALUE-TEXT                  
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DURATION'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CV-ACCESS-LEVEL-CD NOT = LINK-ACCESS-LEVEL-CD             
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ACCESS-LEVEL-CD > SPACES                          
                 MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-ACCESS-LEVEL-CD  TO 3I-ACCESS-LEVEL-CD       
                 PERFORM 7015-CONTACT-ACCESS THRU 7015-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CV-ACCESS-LEVEL-CD > SPACES                            
                 MOVE +15                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE CV-ACCESS-LEVEL-CD    TO 3I-ACCESS-LEVEL-CD       
                 PERFORM 7015-CONTACT-ACCESS THRU 7015-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CONTACT ACCESS'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CV-ADDRESS-FORMAT NOT = LINK-ADDRESS-FORMAT               
              IF CV-ADDRESS-FORMAT = 'A' OR 'B'                         
                  MOVE 'YES'             TO WS-ADDR-CHANGED-FLAG        
                                            WS-AFMT-CHANGED-FLAG        
              ELSE                                                      
                  MOVE 'YES'             TO WS-ADDR-ADDED-FLAG          
              END-IF                                                    
              MOVE 'YES'                 TO WS-CONT-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDRESS-FORMAT > SPACES                           
                 EVALUATE LINK-ADDRESS-FORMAT                           
                     WHEN 'A'                                           
                         MOVE 'FORMATTED'   TO MI-CHG-COLUMN-VALUE-TEXT 
                         MOVE +9            TO MI-CHG-COLUMN-VALUE-LEN  
                     WHEN 'B'                                           
                         MOVE 'FREEFORM'    TO MI-CHG-COLUMN-VALUE-TEXT 
                         MOVE +8            TO MI-CHG-COLUMN-VALUE-LEN  
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CV-ADDRESS-FORMAT > SPACES                             
                 EVALUATE CV-ADDRESS-FORMAT                             
                     WHEN 'A'                                           
                         MOVE 'FORMATTED'   TO MI-PRV-COLUMN-VALUE-TEXT 
                         MOVE +9            TO MI-PRV-COLUMN-VALUE-LEN  
                     WHEN 'B'                                           
                         MOVE 'FREEFORM'    TO MI-PRV-COLUMN-VALUE-TEXT 
                         MOVE +8            TO MI-PRV-COLUMN-VALUE-LEN  
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-STREET NOT = LINK-FF-STREET-1                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-STREET-1 > SPACES                              
                 MOVE +55                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-STREET-1   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-STREET > SPACES                                
                 MOVE +55                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-STREET     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW NOT = LINK-FF-STREET-2                
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-STREET-2 > SPACES                              
                 MOVE +55                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-STREET-2   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +55                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDRESS-OVERFLOW TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-CITY-STATE NOT = LINK-FF-CITY-STATE               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-CITY-STATE > SPACES                            
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-CITY-STATE TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-CITY-STATE > SPACES                            
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-CITY-STATE TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CITY STATE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-ZIP-CODE NOT = LINK-FF-ZIP-CODE                   
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-ZIP-CODE   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-ZIP-CODE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR ZIP CODE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-COUNTRY NOT = LINK-FF-COUNTRY                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-COUNTRY > SPACES                               
                 MOVE +35                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-COUNTRY    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-COUNTRY > SPACES                               
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-COUNTRY    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'COUNTRY'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-HOUSE-NO NOT = LINK-HOUSE-NO                           
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-HOUSE-NO > SPACES                                 
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-HOUSE-NO      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-HOUSE-NO > SPACES                                   
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-HOUSE-NO        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-1 NOT = LINK-ADDR-PREFIX-1                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-1 > SPACES                            
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-1 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-PREFIX-1 > SPACES                              
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-PREFIX-1   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-2 NOT = LINK-ADDR-PREFIX-2                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-2 > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-2 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-PREFIX-2 > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-PREFIX-2   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-NAME NOT = LINK-STREET-NAME                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-NAME > SPACES                              
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-NAME   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-NAME > SPACES                                
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-SUFFIX NOT = LINK-STREET-SUFFIX                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-SUFFIX > SPACES                            
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-SUFFIX > SPACES                              
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-SUFFIX   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-SUFFIX NOT = LINK-ADDR-SUFFIX                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-SUFFIX > SPACES                              
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-SUFFIX   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-SUFFIX > SPACES                                
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-SUFFIX     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-1 NOT = LINK-STREET-LOC-1              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOC-1 > SPACES                             
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOC-1  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-LOCATION-1 > SPACES                          
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-LOCATION-1 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 1'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-2 NOT = LINK-STREET-LOC-2              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOC-2 > SPACES                             
                 MOVE +11                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOC-2  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-LOCATION-2 > SPACES                          
                 MOVE +11                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-LOCATION-2 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 2'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE NOT = LINK-ZIP-CODE                           
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE > SPACES                                 
                 MOVE +5                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ZIP-CODE > SPACES                                   
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ZIP-CODE        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE-PLUS-FOUR NOT = LINK-ZIP-CODE-4               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE-4 > SPACES                               
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE-4    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ZIP-CODE-PLUS-FOUR > SPACES                         
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ZIP-CODE-PLUS-FOUR TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE +4'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-USPS-DELIV-PT-CD NOT = LINK-USPS-DELIV-PT              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-USPS-DELIV-PT > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-USPS-DELIV-PT TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-USPS-DELIV-PT-CD > SPACES                           
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-USPS-DELIV-PT-CD TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DELIVERY PT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF 3K-SALES-SPLS-USER-ID NOT = LINK-SS-USERID                
              MOVE 'YES'                 TO WS-SPLS-CHANGED-FLAG        
              MOVE 'U'                   TO WS-SPLS-FL                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SS-USERID > SPACES                                
                 MOVE +7                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SS-USERID     TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE 'D'                TO WS-SPLS-FL                  
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF 3K-SALES-SPLS-USER-ID > SPACES                         
                 MOVE +7                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 3K-SALES-SPLS-USER-ID TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE 'A'                TO WS-SPLS-FL                  
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SALES SPCLST'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-GET-BASELINE-DETAILS.                                       
                                                                        
           PERFORM 7020-SELECT-CONTACT THRU 7020-EXIT.                  
                                                                        
           MOVE ZEROES TO DW-ACCOUNT-NO                                 
                          DT-CUSTOMER-NO                                
                          DX-PREMISE-NO.                                
           MOVE SPACES TO WS-ENTITY-TYPE.                               
           PERFORM 7100-SELECT-CONT-ACCT THRU 7100-EXIT.                
           IF WS-ENTITY-TYPE = SPACES                                   
               PERFORM 7110-SELECT-CONT-CUST THRU 7110-EXIT
           END-IF.            
           IF WS-ENTITY-TYPE = SPACES                                   
               PERFORM 7120-SELECT-CONT-PREM THRU 7120-EXIT
           END-IF.            
                                                                        
      * WRITE TRANSHIST TO OLD AND NEW ENTITIES                                 
      * MEMO BILLING ON ACCOUNT IF ENTITY CHANGED                               
                                                                        
           IF WS-ENTITY-TYPE NOT = LINK-ENTITY-TYPE                     
               EVALUATE LINK-ENTITY-TYPE                                
                   WHEN 'A'                                             
                       MOVE WS-ACCOUNT-NO-NUM TO DW-ACCOUNT-NO          
                   WHEN 'C'                                             
                       MOVE WS-CUSTOMER-NO-NUM TO DT-CUSTOMER-NO        
                   WHEN 'P'                                             
                       MOVE WS-PREMISE-NO-NUM TO DX-PREMISE-NO          
               END-EVALUATE
           END-IF.                                            
                                                                        
           MOVE DW-ACCOUNT-NO         TO MH-ACCOUNT-NO                  
                                         WS-OLD-ACCOUNT-NO.             
           MOVE DT-CUSTOMER-NO        TO MH-CUSTOMER-NO                 
                                         WS-OLD-CUSTOMER-NO.            
           MOVE DX-PREMISE-NO         TO MH-PREMISE-NO                  
                                         WS-OLD-PREMISE-NO.             
                                                                        
           PERFORM 7030-SELECT-CONT-STATS THRU 7030-EXIT.               
           IF NOT CSTS-EXISTS                                           
               INITIALIZE DCLCSS-CONTACT-STATS
           END-IF.                         
                                                                        
           PERFORM 7070-SELECT-NAME THRU 7070-EXIT.                     
                                                                        
           EVALUATE CV-ADDRESS-FORMAT                                   
               WHEN 'A'                                                 
                   PERFORM 7040-SELECT-FMT-ADDRESS THRU 7040-EXIT       
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
               WHEN 'B'                                                 
                   PERFORM 7060-SELECT-FF-ADDRESS THRU 7060-EXIT        
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
               WHEN OTHER                                               
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
                              DCLCSS-ADDR-FORMATTED                     
           END-EVALUATE.                                                
                                                                        
           MOVE 'H1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE LP-PHONE-NO           TO WS-HOME-PHONE-NO            
              MOVE LP-MOBILE-PHONE-FL    TO WS-HOME-MOBILE-FL           
              MOVE LP-PERMISN-TO-MKT-FL  TO WS-HOME-MKT-FL              
              MOVE LP-PERMISN-TO-MKT-DT  TO WS-HOME-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-HOME-PHONE-NO            
                                            WS-HOME-MOBILE-FL           
                                            WS-HOME-MKT-FL              
                                            WS-HOME-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO' TO WS-PHONE-EXISTS-FLAG.                           
           MOVE 'W1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE LP-PHONE-NO           TO WS-WORK-PHONE-NO            
              MOVE LP-EXTENSION-NO       TO WS-WORK-EXTENSION-NO        
              MOVE LP-MOBILE-PHONE-FL    TO WS-WORK-MOBILE-FL           
              MOVE LP-PERMISN-TO-MKT-FL  TO WS-WORK-MKT-FL              
              MOVE LP-PERMISN-TO-MKT-DT  TO WS-WORK-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-WORK-PHONE-NO            
                                            WS-WORK-EXTENSION-NO        
                                            WS-WORK-MOBILE-FL           
                                            WS-WORK-MKT-FL              
                                            WS-WORK-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO'                     TO WS-PHONE-EXISTS-FLAG.       
           MOVE 'A1'                     TO WS-PHONE-TYPE.              
           PERFORM 7050-SELECT-PHONE          THRU 7050-EXIT.           
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE LP-PHONE-NO           TO WS-ALT-PHONE-NO             
              MOVE LP-MOBILE-PHONE-FL    TO WS-ALT-MOBILE-FL            
              MOVE LP-PERMISN-TO-MKT-FL  TO WS-ALT-MKT-FL               
              MOVE LP-PERMISN-TO-MKT-DT  TO WS-ALT-MKT-DT               
           ELSE                                                         
              MOVE SPACES                TO WS-ALT-PHONE-NO             
                                            WS-ALT-MOBILE-FL            
                                            WS-ALT-MKT-FL               
                                            WS-ALT-MKT-DT
           END-IF.              
                                                                        
           MOVE 'NO'                     TO WS-PHONE-EXISTS-FLAG.       
           MOVE 'F1'                     TO WS-PHONE-TYPE.              
           PERFORM 7050-SELECT-PHONE          THRU 7050-EXIT.           
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-FXPH-EXISTS-FLAG         
              MOVE LP-PHONE-NO           TO WS-FAX-PHONE-NO             
              MOVE LP-MOBILE-PHONE-FL    TO WS-FAX-MOBILE-FL            
              MOVE LP-PERMISN-TO-MKT-FL  TO WS-FAX-MKT-FL               
              MOVE LP-PERMISN-TO-MKT-DT  TO WS-FAX-MKT-DT               
           ELSE                                                         
              MOVE SPACES                TO WS-FAX-PHONE-NO             
                                            WS-FAX-MOBILE-FL            
                                            WS-FAX-MKT-FL               
                                            WS-FAX-MKT-DT
           END-IF.              
                                                                        
           IF CV-CONTACT-TYPE = 'SA' OR 'SE' OR 'SG' OR 'PG'            
A05317         EVALUATE WS-ENTITY-TYPE                                  
A05317             WHEN 'C'                                             
A05317                 PERFORM 7180-SS-CONTACT-CUST THRU 7180-EXIT      
A05317             WHEN 'A'                                             
A05317                 PERFORM 7130-SS-CONTACT-ACCT THRU 7130-EXIT      
A05317         END-EVALUATE
           END-IF.                                            
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-COUNT-MB.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-TOTAL-CT                                       
                FROM CSS_CONTACT CV WITH(READUNCOMMITTED),                      
                     CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                        
                 AND DW.CONTACT_ID = CV.CONTACT_ID                      
                 AND MEMO_BILL_IND = 'Y'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-TOTAL-CT                                               
MFA-TR*         FROM CSS_CONTACT CV,                                            
MFA-TR*              CSS_CONTACT_ACCT DW                                        
MFA-TR*        WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                                
MFA-TR*          AND DW.CONTACT_ID = CV.CONTACT_ID                              
MFA-TR*          AND MEMO_BILL_IND = 'Y'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-TOTAL-CT                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_CONTACT'     TO TABLE-1                    
                   MOVE '1SS_CONTACT_ACCT' TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE DW-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-TOKEN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'TOWN'               TO TABLE-ELEMENT-1         
                   MOVE A4-TOWN              TO HOSTVAR-ELEMENT-1       
                   MOVE 'STATE'              TO TABLE-ELEMENT-2         
                   MOVE A4-STATE             TO HOSTVAR-ELEMENT-2       
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-2         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-CONTACT-ACCESS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ACCESS_LEVEL_DESC                                  
                INTO :3I-ACCESS-LEVEL-DESC                              
                FROM CSS_CONTACT_ACCESS WITH(READUNCOMMITTED)                   
               WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD              
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_DESC                                          
MFA-TR*         INTO :3I-ACCESS-LEVEL-DESC                                      
MFA-TR*         FROM CSS_CONTACT_ACCESS                                         
MFA-TR*        WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD                      
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 3I-ACCESS-LEVEL-CD TO 3I-ACCESS-LEVEL-DESC      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7015'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCESS' TO TABLE-1                 
                   MOVE 3I-ACCESS-LEVEL-CD TO TABLE-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-CONTACT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              CONTACT_TYPE,
              CONTACT_POSITION,
              ACCESS_LEVEL_CD,
              CONTACT_EXP_DT,
              CONTACT_EFF_DT,
              EFFECTIVE_CD,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              MEMO_BILL_IND,
              CV.NAME_ID,
              NAME_FORMAT,
              FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              FULL_NAME,
              RTRIM(RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME) + 
           ' ' + RTRIM(LAST_NAME))                                  
                INTO :WS-CONT-EXISTS-FLAG,                              
                     :CV-CONTACT-TYPE,                                  
                     :CV-CONTACT-POSITION,                              
                     :CV-ACCESS-LEVEL-CD,                               
                     :CV-CONTACT-EXP-DT :WS-NULL-1,                      
                     :CV-CONTACT-EFF-DT :WS-NULL-2,                      
                     :CV-EFFECTIVE-CD,                                  
                     :CV-ADDRESS-ID,                                    
                     :CV-ADDRESS-FORMAT,                                
                     :CV-MEMO-BILL-IND,                                 
                     :CV-NAME-ID,                                       
                     :DQ-NAME-FORMAT,                                   
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME,                                     
                     :WS-CONTACT-NAME                                   
                FROM CSS_CONTACT CV WITH(READUNCOMMITTED),                      
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                 AND CV.NAME_ID = DQ.NAME_ID                            
                                                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              CONTACT_TYPE,                                              
MFA-TR*              CONTACT_POSITION,                                          
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              CONTACT_EXP_DT,                                            
MFA-TR*              CONTACT_EFF_DT,                                            
MFA-TR*              EFFECTIVE_CD,                                              
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT,                                            
MFA-TR*              MEMO_BILL_IND,                                             
MFA-TR*              CV.NAME_ID,                                                
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              RTRIM(RTRIM(FIRST_NAME) ||                                 
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(MIDDLE_NAME) ||                                      
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(LAST_NAME))                                          
MFA-TR*         INTO :WS-CONT-EXISTS-FLAG,                                      
MFA-TR*              :CV-CONTACT-TYPE,                                          
MFA-TR*              :CV-CONTACT-POSITION,                                      
MFA-TR*              :CV-ACCESS-LEVEL-CD,                                       
MFA-TR*              :CV-CONTACT-EXP-DT:WS-NULL-1,                              
MFA-TR*              :CV-CONTACT-EFF-DT:WS-NULL-2,                              
MFA-TR*              :CV-EFFECTIVE-CD,                                          
MFA-TR*              :CV-ADDRESS-ID,                                            
MFA-TR*              :CV-ADDRESS-FORMAT,                                        
MFA-TR*              :CV-MEMO-BILL-IND,                                         
MFA-TR*              :CV-NAME-ID,                                               
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :WS-CONTACT-NAME                                           
MFA-TR*         FROM CSS_CONTACT CV,                                            
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*          AND CV.NAME_ID = DQ.NAME_ID                                    
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO CV-CONTACT-EXP-DT                 
                   END-IF                                               
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CV-CONTACT-EFF-DT                 
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT'    TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-1                     
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-ACCESS-LEVEL.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCESS_LEVEL_CD                                    
                INTO :D8-ACCESS-LEVEL-CD                                
                FROM CSS_CONTACT_TYPE WITH(READUNCOMMITTED)                     
               WHERE CONTACT_TYPE = :LINK-CONTACT-TYPE                  
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_CD                                            
MFA-TR*         INTO :D8-ACCESS-LEVEL-CD                                        
MFA-TR*         FROM CSS_CONTACT_TYPE                                           
MFA-TR*        WHERE CONTACT_TYPE = :LINK-CONTACT-TYPE                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO D8-ACCESS-LEVEL-CD                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
                   MOVE '7025'     TO ACTIVE-PARAGRAPH                  
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_CONTACT_TYPE' TO TABLE-1                   
                   MOVE 'CONTACT_TYPE'  TO TABLE-ELEMENT-1              
                   MOVE CV-CONTACT-TYPE TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-CONT-STATS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              TAX_ID,
              WEBSITE_ADDR,
              DATE_OF_BIRTH,
              EMPLOYEE_TITLE,
              BUSINESS_NAME,
              EMPLOYER,
              OTHER_ID,
              OTHER_ID_TYPE,
              DRIVERS_LICENSE_NO,
              CODE_STATE_ID,
              SSN,
              ITIN_ID,
              ALLOW_CALL_FL                                      
                INTO :WS-CSTS-EXISTS-FLAG,                              
                     :3H-TAX-ID,                                        
                     :3H-WEBSITE-ADDR,                                  
                     :3H-DATE-OF-BIRTH :WS-NULL-3,                       
                     :3H-EMPLOYEE-TITLE,                                
                     :3H-BUSINESS-NAME,                                 
                     :3H-EMPLOYER,                                      
                     :3H-OTHER-ID,                                      
                     :3H-OTHER-ID-TYPE,                                 
                     :3H-DRIVERS-LICENSE-NO,                            
                     :3H-CODE-STATE-ID,                                 
                     :3H-SSN,                                           
                     :3H-ITIN-ID,                                       
                     :3H-ALLOW-CALL-FL                                  
                FROM CSS_CONTACT_STATS WITH(READUNCOMMITTED)                    
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              TAX_ID,                                                    
MFA-TR*              WEBSITE_ADDR,                                              
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              EMPLOYEE_TITLE,                                            
MFA-TR*              BUSINESS_NAME,                                             
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ALLOW_CALL_FL                                              
MFA-TR*         INTO :WS-CSTS-EXISTS-FLAG,                                      
MFA-TR*              :3H-TAX-ID,                                                
MFA-TR*              :3H-WEBSITE-ADDR,                                          
MFA-TR*              :3H-DATE-OF-BIRTH:WS-NULL-3,                               
MFA-TR*              :3H-EMPLOYEE-TITLE,                                        
MFA-TR*              :3H-BUSINESS-NAME,                                         
MFA-TR*              :3H-EMPLOYER,                                              
MFA-TR*              :3H-OTHER-ID,                                              
MFA-TR*              :3H-OTHER-ID-TYPE,                                         
MFA-TR*              :3H-DRIVERS-LICENSE-NO,                                    
MFA-TR*              :3H-CODE-STATE-ID,                                         
MFA-TR*              :3H-SSN,                                                   
MFA-TR*              :3H-ITIN-ID,                                               
MFA-TR*              :3H-ALLOW-CALL-FL                                          
MFA-TR*         FROM CSS_CONTACT_STATS                                          
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO 3H-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_STATS' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-FMT-ADDRESS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              STREET_SUFFIX,
              ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              ZIP_CODE_TOKEN,
              ADDR_SUFFIX,
              USPS_DELIV_PT_CD                                   
                INTO :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-SUFFIX,                                 
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
                     :DY-ADDR-SUFFIX,                                   
                     :DY-USPS-DELIV-PT-CD                               
                FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                   
               WHERE ADDRESS_ID = :CV-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              ZIP_CODE,                                                  
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              ZIP_CODE_TOKEN,                                            
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              USPS_DELIV_PT_CD                                           
MFA-TR*         INTO :DY-HOUSE-NO,                                              
MFA-TR*              :DY-ADDR-PREFIX-1,                                         
MFA-TR*              :DY-ADDR-PREFIX-2,                                         
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-USPS-DELIV-PT-CD                                       
MFA-TR*         FROM CSS_ADDR_FORMATTED                                         
MFA-TR*        WHERE ADDRESS_ID = :CV-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE CV-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT                                  
                INTO :WS-PHONE-EXISTS-FLAG,                             
                     :LP-PHONE-TYPE,                                    
                     :LP-PHONE-NO,                                      
                     :LP-EXTENSION-NO,                                  
                     :LP-MOBILE-PHONE-FL,                               
                     :LP-PERMISN-TO-MKT-FL,                             
                     :LP-PERMISN-TO-MKT-DT :WS-NULL-2                    
                FROM CSS_CONTACT_PHONE WITH(READUNCOMMITTED)                    
               WHERE CONTACT_ID  = :CV-CONTACT-ID                       
                 AND PHONE_TYPE  = :WS-PHONE-TYPE                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT                                          
MFA-TR*         INTO :WS-PHONE-EXISTS-FLAG,                                     
MFA-TR*              :LP-PHONE-TYPE,                                            
MFA-TR*              :LP-PHONE-NO,                                              
MFA-TR*              :LP-EXTENSION-NO,                                          
MFA-TR*              :LP-MOBILE-PHONE-FL,                                       
MFA-TR*              :LP-PERMISN-TO-MKT-FL,                                     
MFA-TR*              :LP-PERMISN-TO-MKT-DT:WS-NULL-2                            
MFA-TR*         FROM CSS_CONTACT_PHONE                                          
MFA-TR*        WHERE CONTACT_ID  = :CV-CONTACT-ID                               
MFA-TR*          AND PHONE_TYPE  = :WS-PHONE-TYPE                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO LP-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_PHONE' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   MOVE 'PHONE_TYPE'     TO TABLE-ELEMENT-2             
                   MOVE WS-PHONE-TYPE    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY                                       
                INTO :DZ-ADDR-STREET,                                   
                     :DZ-ADDRESS-OVERFLOW,                              
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY                                   
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :CV-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY                                               
MFA-TR*         INTO :DZ-ADDR-STREET,                                           
MFA-TR*              :DZ-ADDRESS-OVERFLOW,                                      
MFA-TR*              :DZ-ADDR-CITY-STATE,                                       
MFA-TR*              :DZ-ADDR-ZIP-CODE,                                         
MFA-TR*              :DZ-ADDR-COUNTRY                                           
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :CV-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE CV-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_TYPE,
              NAME_FORMAT,
              FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              FULL_NAME                                          
                INTO :DQ-NAME-TYPE,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME                                      
                FROM CSS_NAME WITH(READUNCOMMITTED)                             
               WHERE NAME_ID = :CV-NAME-ID                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              FULL_NAME                                                  
MFA-TR*         INTO :DQ-NAME-TYPE,                                             
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-FULL-NAME                                              
MFA-TR*         FROM CSS_NAME                                                   
MFA-TR*        WHERE NAME_ID = :CV-NAME-ID                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-2             
              MOVE CV-NAME-ID            TO HOSTVAR-ELEMENT-1           
              MOVE CV-CONTACT-ID         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CONTACT-ID       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-SELECT-SALES-SPCL.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME                                          
                INTO :3K-FIRST-NAME,                                    
                     :3K-MIDDLE-NAME,                                   
                     :3K-LAST-NAME                                      
                FROM CSS_SALES_SPCLST WITH(READUNCOMMITTED)                     
               WHERE SALES_SPLS_USER_ID = :3K-SALES-SPLS-USER-ID        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME                                                  
MFA-TR*         INTO :3K-FIRST-NAME,                                            
MFA-TR*              :3K-MIDDLE-NAME,                                           
MFA-TR*              :3K-LAST-NAME                                              
MFA-TR*         FROM CSS_SALES_SPCLST                                           
MFA-TR*        WHERE SALES_SPLS_USER_ID = :3K-SALES-SPLS-USER-ID                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO LINK-SS-USERID                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-SALES-SPCLST                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_SALES_SPCLST' TO TABLE-1                   
                   MOVE 'SALES_SPLS_USER_ID' TO TABLE-ELEMENT-1         
                   MOVE 3K-SALES-SPLS-USER-ID TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-CONT-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'A',
              ACCOUNT_NO                                         
                INTO :WS-ENTITY-TYPE,                                   
                     :DW-ACCOUNT-NO                                     
                FROM CSS_CONTACT_ACCT WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'A',                                                       
MFA-TR*              ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ENTITY-TYPE,                                           
MFA-TR*              :DW-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_CONTACT_ACCT                                           
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DW-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-CONT-CUST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'C',
              CUSTOMER_NO                                        
                INTO :WS-ENTITY-TYPE,                                   
                     :DT-CUSTOMER-NO                                    
                FROM CSS_CONTACT_CUST WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'C',                                                       
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*         INTO :WS-ENTITY-TYPE,                                           
MFA-TR*              :DT-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_CONTACT_CUST                                           
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DT-CUSTOMER-NO                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-CONT-PREM.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'P',
              PREMISE_NO                                         
                INTO :WS-ENTITY-TYPE,                                   
                     :DX-PREMISE-NO                                     
                FROM CSS_CONTACT_PREM WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'P',                                                       
MFA-TR*              PREMISE_NO                                                 
MFA-TR*         INTO :WS-ENTITY-TYPE,                                           
MFA-TR*              :DX-PREMISE-NO                                             
MFA-TR*         FROM CSS_CONTACT_PREM                                           
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DX-PREMISE-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7120'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_PREM' TO TABLE-1                   
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-SS-CONTACT-ACCT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CV.CONTACT_ID,
              SALES_SPLS_USER_ID,
              CV.NAME_ID                                         
                INTO :WS-SS-CONTACT-ID,                                 
                     :3K-SALES-SPLS-USER-ID,                            
                     :WS-SS-NAME-ID                                     
                FROM CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                 
                     CSS_CONTACT CV WITH(READUNCOMMITTED),                      
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_SALES_SPCLST SS WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                        
                 AND DW.CONTACT_ID = CV.CONTACT_ID                      
                 AND CONTACT_TYPE = 'SS'                                
                 AND CV.NAME_ID = DQ.NAME_ID                            
                 AND DQ.FIRST_NAME = SS.FIRST_NAME                      
                 AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                    
                 AND DQ.LAST_NAME = SS.LAST_NAME                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CV.CONTACT_ID,                                             
MFA-TR*              SALES_SPLS_USER_ID,                                        
MFA-TR*              CV.NAME_ID                                                 
MFA-TR*         INTO :WS-SS-CONTACT-ID,                                         
MFA-TR*              :3K-SALES-SPLS-USER-ID,                                    
MFA-TR*              :WS-SS-NAME-ID                                             
MFA-TR*         FROM CSS_CONTACT_ACCT DW,                                       
MFA-TR*              CSS_CONTACT CV,                                            
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_SALES_SPCLST SS                                        
MFA-TR*        WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                                
MFA-TR*          AND DW.CONTACT_ID = CV.CONTACT_ID                              
MFA-TR*          AND CONTACT_TYPE = 'SS'                                        
MFA-TR*          AND CV.NAME_ID = DQ.NAME_ID                                    
MFA-TR*          AND DQ.FIRST_NAME = SS.FIRST_NAME                              
MFA-TR*          AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                            
MFA-TR*          AND DQ.LAST_NAME = SS.LAST_NAME                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-CONTACT-ID                         
                   MOVE SPACES TO 3K-SALES-SPLS-USER-ID                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'    TO TABLE-2                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE DW-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-VALIDATE-ZIP.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7140                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO A4-ZIP-CODE-TOKEN                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7140'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-1         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 7150-SELECT-ACCOUNT.                                             
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         SELECT TOP(1) CUSTOMER_NO                                       
P00836           INTO :AT-CUSTOMER-NO                                   
P00836           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
P00836          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
P00836                                           
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '7150'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                           ABEND-TABLES           
P00836             MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
P00836             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00836             MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00836             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00836             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7150-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
P00836 7160-CHECK-SU.                                                   
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         SELECT TOP(1) CV.CONTACT_ID                                     
P00836           INTO :CV-CONTACT-ID                                    
P00836           FROM CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00836                CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00836                CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
P00836                CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
P00836          WHERE DQ.NAME_ID = CV.NAME_ID                           
P00836            AND NAME_TYPE = 'AC'                                  
P00836            AND FIRST_NAME = :DQ-FIRST-NAME                       
P00836            AND LAST_NAME = :DQ-LAST-NAME                         
P00836            AND CV.CONTACT_ID = DW.CONTACT_ID                     
P00836            AND DW.ACCOUNT_NO = AT.ACCOUNT_NO                     
P00836            AND AT.CUSTOMER_NO = :AT-CUSTOMER-NO                  
P00836                                           
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CV.CONTACT_ID                                             
MFA-TR*          INTO :CV-CONTACT-ID                                            
MFA-TR*          FROM CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*         WHERE DQ.NAME_ID = CV.NAME_ID                                   
MFA-TR*           AND NAME_TYPE = 'AC'                                          
MFA-TR*           AND FIRST_NAME = :DQ-FIRST-NAME                               
MFA-TR*           AND LAST_NAME = :DQ-LAST-NAME                                 
MFA-TR*           AND CV.CONTACT_ID = DW.CONTACT_ID                             
MFA-TR*           AND DW.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND AT.CUSTOMER_NO = :AT-CUSTOMER-NO                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7160                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             MOVE 'Y' TO WS-SU-MATCH-FL                           
P00836         WHEN NOT-FOUND                                           
P00836             MOVE 'N' TO WS-SU-MATCH-FL                           
P00836             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '7160'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                           ABEND-TABLES           
P00836             MOVE 'CSS_CONTACT'        TO TABLE-1                 
P00836             MOVE 'CSS_NAME'           TO TABLE-2                 
P00836             MOVE 'CSS_CONTACT_ACCT'   TO TABLE-3                 
P00836             MOVE 'CSS_ACCOUNT'        TO TABLE-4                 
P00836             MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-1         
P00836             MOVE 'LAST_NAME'          TO TABLE-ELEMENT-2         
P00836             MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3         
P00836             MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-1       
P00836             MOVE DQ-LAST-NAME         TO HOSTVAR-ELEMENT-2       
P00836             MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-3       
P00836             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00836             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7160-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
A05317 7180-SS-CONTACT-CUST.                                            
A05317                                                                  
A05317     EXEC SQL                                                     
A05317        SELECT TOP(1) CV.CONTACT_ID,
              SALES_SPLS_USER_ID,
              CV.NAME_ID                                         
A05317          INTO :WS-SS-CONTACT-ID,                                 
A05317               :3K-SALES-SPLS-USER-ID,                            
A05317               :WS-SS-NAME-ID                                     
A05317          FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                 
A05317               CSS_CONTACT CV WITH(READUNCOMMITTED),                      
A05317               CSS_NAME DQ WITH(READUNCOMMITTED),                         
A05317               CSS_SALES_SPCLST SS WITH(READUNCOMMITTED)                  
A05317         WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                      
A05317           AND DT.CONTACT_ID = CV.CONTACT_ID                      
A05317           AND CONTACT_TYPE = 'SS'                                
A05317           AND CV.NAME_ID = DQ.NAME_ID                            
A05317           AND DQ.FIRST_NAME = SS.FIRST_NAME                      
A05317           AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                    
A05317           AND DQ.LAST_NAME = SS.LAST_NAME                        
A05317                                           
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CV.CONTACT_ID,                                             
MFA-TR*              SALES_SPLS_USER_ID,                                        
MFA-TR*              CV.NAME_ID                                                 
MFA-TR*         INTO :WS-SS-CONTACT-ID,                                         
MFA-TR*              :3K-SALES-SPLS-USER-ID,                                    
MFA-TR*              :WS-SS-NAME-ID                                             
MFA-TR*         FROM CSS_CONTACT_CUST DT,                                       
MFA-TR*              CSS_CONTACT CV,                                            
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_SALES_SPCLST SS                                        
MFA-TR*        WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                              
MFA-TR*          AND DT.CONTACT_ID = CV.CONTACT_ID                              
MFA-TR*          AND CONTACT_TYPE = 'SS'                                        
MFA-TR*          AND CV.NAME_ID = DQ.NAME_ID                                    
MFA-TR*          AND DQ.FIRST_NAME = SS.FIRST_NAME                              
MFA-TR*          AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                            
MFA-TR*          AND DQ.LAST_NAME = SS.LAST_NAME                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7180                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN NOT-FOUND                                           
A05317             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05317                            WS-SS-CONTACT-ID                      
A05317             MOVE SPACES TO 3K-SALES-SPLS-USER-ID                 
A05317         WHEN OTHER                                               
A05317             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A05317             MOVE '7180'           TO ACTIVE-PARAGRAPH            
A05317             MOVE 'SELECT'         TO ABEND-FUNCTION              
A05317             MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
A05317             MOVE 'CSS_CONTACT'    TO TABLE-2                     
A05317             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
A05317             MOVE DT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
A05317             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05317             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7180-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
P00836 7190-OPEN-CONTACT-CURSOR.                                        
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN CONTACT-CURSOR                                      
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '7190'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836             MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
P00836             MOVE 'CONTACT_NO'     TO TABLE-ELEMENT-1             
P00836             MOVE DW-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00836             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00836             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7190-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
P00836 7191-CLOSE-CONTACT-CURSOR.                                       
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         CLOSE CONTACT-CURSOR                                     
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '7191'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836             MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
P00836             MOVE 'CONTACT_NO'     TO TABLE-ELEMENT-1             
P00836             MOVE DW-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00836             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00836             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7191-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
       8000-INSERT-FF-ADDR.                                             
                                                                        
            EXEC SQL                                                    
               INSERT INTO CSS_ADDR_FREEFORM                            
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDRESS_OVERFLOW,                                  
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY)                                      
               VALUES                                                   
                    (:DZ-ADDRESS-ID,                                    
                     :DZ-ADDR-STREET,                                   
                     :DZ-ADDRESS-OVERFLOW,                              
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY)                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_STREET'        TO TABLE-ELEMENT-2              
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-STREET       TO HOSTVAR-ELEMENT-2            
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-INSERT-FMT-ADDR.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                   (ADDRESS_ID,                                         
                    HOUSE_NO,                                           
                    ADDR_PREFIX_1,                                      
                    ADDR_PREFIX_2,                                      
                    STREET_NAME,                                        
                    STREET_SUFFIX,                                      
                    STREET_LOCATION_1,                                  
                    STREET_LOCATION_2,                                  
                    ZIP_CODE,                                           
                    ZIP_CODE_PLUS_FOUR,                                 
                    ZIP_CODE_TOKEN,                                     
                    ADDR_SUFFIX,                                        
                    ADDR_USAGE_CD,                                      
                    USPS_DELIV_PT_CD)                                   
              VALUES                                                    
                   (:DY-ADDRESS-ID,                                     
                    :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-SUFFIX,                                  
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-ADDR-SUFFIX,                                    
                    :DY-ADDR-USAGE-CD,                                  
                    :DY-USPS-DELIV-PT-CD)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'STREET_NAME'        TO TABLE-ELEMENT-2              
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-3              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DY-STREET-NAME       TO HOSTVAR-ELEMENT-2            
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-CONTACT.                                             
                                                                        
           IF CV-CONTACT-EXP-DT <= SPACES                               
               MOVE -1 TO WS-NULL-1                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-1
           END-IF.                                     
           IF CV-CONTACT-EFF-DT <= SPACES                               
               MOVE -1 TO WS-NULL-4                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-4
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT                                   
                   ( CONTACT_ID,                                        
                     CONTACT_TYPE,                                      
                     CONTACT_ORDER,                                     
                     NAME_ID,                                           
                     ADDRESS_ID,                                        
                     CONTACT_POSITION,                                  
                     DATE_CREATED,                                      
                     ACCESS_LEVEL_CD,                                   
                     VALIDATION_TS,                                     
                     CONTACT_EXP_DT,                                    
                     LAST_UPDATE_TS,                                    
                     CONTACT_EFF_DT,                                    
                     EFFECTIVE_CD,                                      
                     CONTACT_XFER_FL,                                   
                     MEMO_BILL_IND,                                     
                     ADDRESS_FORMAT)                                    
              VALUES                                                    
                   (:CV-CONTACT-ID,                                     
                    :CV-CONTACT-TYPE,                                   
                    :CV-CONTACT-ORDER,                                  
                    :CV-NAME-ID,                                        
                    :CV-ADDRESS-ID,                                     
                    :CV-CONTACT-POSITION,                               
                    IIF(TRY_CONVERT(DATE, :CV-DATE-CREATED
              ) IS NULL OR (PATINDEX('%.%', :CV-DATE-CREATED
              ) <> 0) OR (LEN(:CV-DATE-CREATED) <> 10), CIS.CHAR2DATE(
                                                       :CV-DATE-CREATED
              ), CONVERT(DATE, :CV-DATE-CREATED) ),                            
                    :CV-ACCESS-LEVEL-CD,                                
                    CIS.CHAR2TIMESTAMP(:CV-VALIDATION-TS),                      
                    IIF(TRY_CONVERT(DATE, :CV-CONTACT-EXP-DT :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :CV-CONTACT-EXP-DT 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:CV-CONTACT-EXP-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:CV-CONTACT-EXP-DT :WS-NULL-1
              ), CONVERT(DATE, :CV-CONTACT-EXP-DT :WS-NULL-1) ),               
                    CIS.CHAR2TIMESTAMP(:CV-LAST-UPDATE-TS),                     
                    IIF(TRY_CONVERT(DATE, :CV-CONTACT-EFF-DT :WS-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :CV-CONTACT-EFF-DT 
                                                             :WS-NULL-4
              ) <> 0) OR (LEN(:CV-CONTACT-EFF-DT :WS-NULL-4
              ) <> 10), CIS.CHAR2DATE(:CV-CONTACT-EFF-DT :WS-NULL-4
              ), CONVERT(DATE, :CV-CONTACT-EFF-DT :WS-NULL-4) ),               
                    :CV-EFFECTIVE-CD,                                   
                    :CV-CONTACT-XFER-FL,                                
                    :CV-MEMO-BILL-IND,                                  
                    :CV-ADDRESS-FORMAT)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONTACT                                           
MFA-TR*            ( CONTACT_ID,                                                
MFA-TR*              CONTACT_TYPE,                                              
MFA-TR*              CONTACT_ORDER,                                             
MFA-TR*              NAME_ID,                                                   
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              CONTACT_POSITION,                                          
MFA-TR*              DATE_CREATED,                                              
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              VALIDATION_TS,                                             
MFA-TR*              CONTACT_EXP_DT,                                            
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              CONTACT_EFF_DT,                                            
MFA-TR*              EFFECTIVE_CD,                                              
MFA-TR*              CONTACT_XFER_FL,                                           
MFA-TR*              MEMO_BILL_IND,                                             
MFA-TR*              ADDRESS_FORMAT)                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (:CV-CONTACT-ID,                                             
MFA-TR*             :CV-CONTACT-TYPE,                                           
MFA-TR*             :CV-CONTACT-ORDER,                                          
MFA-TR*             :CV-NAME-ID,                                                
MFA-TR*             :CV-ADDRESS-ID,                                             
MFA-TR*             :CV-CONTACT-POSITION,                                       
MFA-TR*             :CV-DATE-CREATED,                                           
MFA-TR*             :CV-ACCESS-LEVEL-CD,                                        
MFA-TR*             :CV-VALIDATION-TS,                                          
MFA-TR*             :CV-CONTACT-EXP-DT:WS-NULL-1,                               
MFA-TR*             :CV-LAST-UPDATE-TS,                                         
MFA-TR*             :CV-CONTACT-EFF-DT:WS-NULL-4,                               
MFA-TR*             :CV-EFFECTIVE-CD,                                           
MFA-TR*             :CV-CONTACT-XFER-FL,                                        
MFA-TR*             :CV-MEMO-BILL-IND,                                          
MFA-TR*             :CV-ADDRESS-FORMAT)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8020'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CONTACT'         TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE CV-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-2             
              MOVE 'CONTACT_TYPE'        TO TABLE-ELEMENT-3             
              MOVE 'ACCESS LEVEL'        TO TABLE-ELEMENT-4             
              MOVE CV-NAME-ID            TO HOSTVAR-ELEMENT-2           
              MOVE CV-CONTACT-TYPE       TO HOSTVAR-ELEMENT-3           
              MOVE CV-ACCESS-LEVEL-CD    TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8025-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8025'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-PHONE.                                               
                                                                        
           IF LP-PERMISN-TO-MKT-DT <= SPACES                            
               MOVE -1 TO WS-NULL-10                                    
           ELSE                                                         
               MOVE 0 TO WS-NULL-10
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_PHONE                             
                   ( CONTACT_ID,                                        
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT)                                 
              VALUES                                                    
                   (:LP-CONTACT-ID,                                     
                    :LP-PHONE-TYPE,                                     
                    :LP-PHONE-NO,                                       
                    :LP-EXTENSION-NO,                                   
                    :LP-MOBILE-PHONE-FL,                                
                    :LP-PERMISN-TO-MKT-FL,                              
                    IIF(TRY_CONVERT(DATE, :LP-PERMISN-TO-MKT-DT 
                                          :WS-NULL-10
              ) IS NULL OR (PATINDEX('%.%', :LP-PERMISN-TO-MKT-DT 
                                                            :WS-NULL-10
              ) <> 0) OR (LEN(:LP-PERMISN-TO-MKT-DT :WS-NULL-10
              ) <> 10), CIS.CHAR2DATE(:LP-PERMISN-TO-MKT-DT :WS-NULL-10
              ), CONVERT(DATE, :LP-PERMISN-TO-MKT-DT :WS-NULL-10) ))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONTACT_PHONE                                     
MFA-TR*            ( CONTACT_ID,                                                
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:LP-CONTACT-ID,                                             
MFA-TR*             :LP-PHONE-TYPE,                                             
MFA-TR*             :LP-PHONE-NO,                                               
MFA-TR*             :LP-EXTENSION-NO,                                           
MFA-TR*             :LP-MOBILE-PHONE-FL,                                        
MFA-TR*             :LP-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :LP-PERMISN-TO-MKT-DT:WS-NULL-10)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-3              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE LP-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE LP-PHONE-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CONT-STATS.                                          
                                                                        
           IF 3H-DATE-OF-BIRTH <= ' '                                   
               MOVE -1 TO WS-NULL-5                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-5
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_STATS                             
                   ( CONTACT_ID,                                        
                     TAX_ID,                                            
                     WEBSITE_ADDR,                                      
                     DATE_OF_BIRTH,                                     
                     EMPLOYEE_TITLE,                                    
                     BUSINESS_NAME,                                     
                     EMPLOYER,                                          
                     OTHER_ID,                                          
                     OTHER_ID_TYPE,                                     
                     DRIVERS_LICENSE_NO,                                
                     CODE_STATE_ID,                                     
                     SSN,                                               
                     ITIN_ID,                                           
                     ALLOW_CALL_FL)                                     
              VALUES                                                    
                   (:3H-CONTACT-ID,                                     
                    :3H-TAX-ID,                                         
                    :3H-WEBSITE-ADDR,                                   
                    IIF(TRY_CONVERT(DATE, :3H-DATE-OF-BIRTH :WS-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :3H-DATE-OF-BIRTH 
                                                             :WS-NULL-5
              ) <> 0) OR (LEN(:3H-DATE-OF-BIRTH :WS-NULL-5
              ) <> 10), CIS.CHAR2DATE(:3H-DATE-OF-BIRTH :WS-NULL-5
              ), CONVERT(DATE, :3H-DATE-OF-BIRTH :WS-NULL-5) ),                
                    :3H-EMPLOYEE-TITLE,                                 
                    :3H-BUSINESS-NAME,                                  
                    :3H-EMPLOYER,                                       
                    :3H-OTHER-ID,                                       
                    :3H-OTHER-ID-TYPE,                                  
                    :3H-DRIVERS-LICENSE-NO,                             
                    :3H-CODE-STATE-ID,                                  
                    :3H-SSN,                                            
                    :3H-ITIN-ID,                                        
                    :3H-ALLOW-CALL-FL)                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONTACT_STATS                                     
MFA-TR*            ( CONTACT_ID,                                                
MFA-TR*              TAX_ID,                                                    
MFA-TR*              WEBSITE_ADDR,                                              
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              EMPLOYEE_TITLE,                                            
MFA-TR*              BUSINESS_NAME,                                             
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ALLOW_CALL_FL)                                             
MFA-TR*       VALUES                                                            
MFA-TR*            (:3H-CONTACT-ID,                                             
MFA-TR*             :3H-TAX-ID,                                                 
MFA-TR*             :3H-WEBSITE-ADDR,                                           
MFA-TR*             :3H-DATE-OF-BIRTH:WS-NULL-5,                                
MFA-TR*             :3H-EMPLOYEE-TITLE,                                         
MFA-TR*             :3H-BUSINESS-NAME,                                          
MFA-TR*             :3H-EMPLOYER,                                               
MFA-TR*             :3H-OTHER-ID,                                               
MFA-TR*             :3H-OTHER-ID-TYPE,                                          
MFA-TR*             :3H-DRIVERS-LICENSE-NO,                                     
MFA-TR*             :3H-CODE-STATE-ID,                                          
MFA-TR*             :3H-SSN,                                                    
MFA-TR*             :3H-ITIN-ID,                                                
MFA-TR*             :3H-ALLOW-CALL-FL)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_STATS'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 'SSN'                TO TABLE-ELEMENT-2              
              MOVE 3H-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 3H-SSN               TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-CONT-ACCT.                                           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CONTACT_ACCT                               
                    (ACCOUNT_NO,                                        
                     CONTACT_ID )                                       
             VALUES (:DW-ACCOUNT-NO,                                    
                     :DW-CONTACT-ID)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DW-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8070-INSERT-CONT-CUST.                                           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CONTACT_CUST                               
                    (CUSTOMER_NO,                                       
                     CONTACT_ID )                                       
             VALUES (:DT-CUSTOMER-NO,                                   
                     :DT-CONTACT-ID)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8070'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE DT-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8080-INSERT-CONT-PREM.                                           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CONTACT_PREM                               
                    (PREMISE_NO,                                        
                     CONTACT_ID )                                       
             VALUES (:DX-PREMISE-NO,                                    
                     :DX-CONTACT-ID)                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8080'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_PREM'   TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-2              
              MOVE DX-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DX-PREMISE-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8090-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET MEMO_BILL_IND = :AT-MEMO-BILL-IND                  
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND NOT MST_SUB_ACCT_IND = 'S'                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET MEMO_BILL_IND = :AT-MEMO-BILL-IND                          
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND NOT MST_SUB_ACCT_IND = 'S'                                 
MFA-TR*       QUERYNO 8090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8390'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8160-DELETE-CONTACT.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT                                   
              WHERE  CONTACT_ID = :CV-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT                                           
MFA-TR*       WHERE  CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       QUERYNO 8160                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8160'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CONTACT'         TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE CV-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-CSTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_STATS                             
               WHERE CONTACT_ID         = :CV-CONTACT-ID                
                 AND TAX_ID             = ' '                           
                 AND WEBSITE_ADDR       = ' '                           
                 AND DATE_OF_BIRTH      IS NULL                         
                 AND EMPLOYEE_TITLE     = ' '                           
                 AND BUSINESS_NAME      = ' '                           
                 AND EMPLOYER           = ' '                           
                 AND OTHER_ID           = ' '                           
                 AND OTHER_ID_TYPE      = ' '                           
                 AND DRIVERS_LICENSE_NO = ' '                           
                 AND CODE_STATE_ID      = ' '                           
                 AND SSN                = ' '                           
                 AND ITIN_ID            = ' '                           
                 AND ALLOW_CALL_FL      = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_STATS                                     
MFA-TR*        WHERE CONTACT_ID         = :CV-CONTACT-ID                        
MFA-TR*          AND TAX_ID             = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND DATE_OF_BIRTH      IS NULL                                 
MFA-TR*          AND EMPLOYEE_TITLE     = ' '                                   
MFA-TR*          AND BUSINESS_NAME      = ' '                                   
MFA-TR*          AND EMPLOYER           = ' '                                   
MFA-TR*          AND OTHER_ID           = ' '                                   
MFA-TR*          AND OTHER_ID_TYPE      = ' '                                   
MFA-TR*          AND DRIVERS_LICENSE_NO = ' '                                   
MFA-TR*          AND CODE_STATE_ID      = ' '                                   
MFA-TR*          AND SSN                = ' '                                   
MFA-TR*          AND ITIN_ID            = ' '                                   
MFA-TR*          AND ALLOW_CALL_FL      = ' '                                   
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_STATS'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-DELETE-NULL-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_PHONE                             
               WHERE CONTACT_ID         = :CV-CONTACT-ID                
                 AND PHONE_TYPE         = :LP-PHONE-TYPE                
                 AND PHONE_NO           = ' '                           
                 AND EXTENSION_NO       = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_PHONE                                     
MFA-TR*        WHERE CONTACT_ID         = :CV-CONTACT-ID                        
MFA-TR*          AND PHONE_TYPE         = :LP-PHONE-TYPE                        
MFA-TR*          AND PHONE_NO           = ' '                                   
MFA-TR*          AND EXTENSION_NO       = ' '                                   
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE-TYPE'         TO TABLE-ELEMENT-2              
              MOVE LP-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8330-UPDATE-CONTACT.                                             
                                                                        
           IF CV-CONTACT-EXP-DT <= SPACES                               
               MOVE -1 TO WS-NULL-7                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-7
           END-IF.                                     
           IF CV-CONTACT-EFF-DT <= SPACES                               
               MOVE -1 TO WS-NULL-8                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-8
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT                                        
                 SET LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :CV-LAST-UPDATE-TS
              ),               
                     CONTACT_TYPE = :CV-CONTACT-TYPE,                   
                     CONTACT_POSITION = :CV-CONTACT-POSITION,           
                     ACCESS_LEVEL_CD = :CV-ACCESS-LEVEL-CD,             
                     CONTACT_EXP_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CV-CONTACT-EXP-DT 
                                                            :WS-NULL-7
              ) IS NULL OR (PATINDEX('%.%', :CV-CONTACT-EXP-DT 
                                                             :WS-NULL-7
              ) <> 0) OR (LEN(:CV-CONTACT-EXP-DT :WS-NULL-7
              ) <> 10), CIS.CHAR2DATE(:CV-CONTACT-EXP-DT :WS-NULL-7
              ), CONVERT(DATE, :CV-CONTACT-EXP-DT :WS-NULL-7) ),     
                     CONTACT_EFF_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CV-CONTACT-EFF-DT 
                                                            :WS-NULL-8
              ) IS NULL OR (PATINDEX('%.%', :CV-CONTACT-EFF-DT 
                                                             :WS-NULL-8
              ) <> 0) OR (LEN(:CV-CONTACT-EFF-DT :WS-NULL-8
              ) <> 10), CIS.CHAR2DATE(:CV-CONTACT-EFF-DT :WS-NULL-8
              ), CONVERT(DATE, :CV-CONTACT-EFF-DT :WS-NULL-8) ),     
                     EFFECTIVE_CD  = :CV-EFFECTIVE-CD,                  
                     ADDRESS_FORMAT = :CV-ADDRESS-FORMAT,               
                     ADDRESS_ID = :CV-ADDRESS-ID,                       
                     MEMO_BILL_IND = :CV-MEMO-BILL-IND                  
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT                                                
MFA-TR*          SET LAST_UPDATE_TS = :CV-LAST-UPDATE-TS,                       
MFA-TR*              CONTACT_TYPE = :CV-CONTACT-TYPE,                           
MFA-TR*              CONTACT_POSITION = :CV-CONTACT-POSITION,                   
MFA-TR*              ACCESS_LEVEL_CD = :CV-ACCESS-LEVEL-CD,                     
MFA-TR*              CONTACT_EXP_DT = :CV-CONTACT-EXP-DT:WS-NULL-7,             
MFA-TR*              CONTACT_EFF_DT = :CV-CONTACT-EFF-DT:WS-NULL-8,             
MFA-TR*              EFFECTIVE_CD  = :CV-EFFECTIVE-CD,                          
MFA-TR*              ADDRESS_FORMAT = :CV-ADDRESS-FORMAT,                       
MFA-TR*              ADDRESS_ID = :CV-ADDRESS-ID,                               
MFA-TR*              MEMO_BILL_IND = :CV-MEMO-BILL-IND                          
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       QUERYNO 8330                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8330'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT'        TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-CSTS.                                                
                                                                        
           IF 3H-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-6                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-6
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT_STATS                                  
                 SET TAX_ID = :3H-TAX-ID,                               
                     WEBSITE_ADDR = :3H-WEBSITE-ADDR,                   
                     DATE_OF_BIRTH = IIF(TRY_CONVERT(DATE, 
                                                     :3H-DATE-OF-BIRTH 
                                                           :WS-NULL-6
              ) IS NULL OR (PATINDEX('%.%', :3H-DATE-OF-BIRTH 
                                                             :WS-NULL-6
              ) <> 0) OR (LEN(:3H-DATE-OF-BIRTH :WS-NULL-6
              ) <> 10), CIS.CHAR2DATE(:3H-DATE-OF-BIRTH :WS-NULL-6
              ), CONVERT(DATE, :3H-DATE-OF-BIRTH :WS-NULL-6) ),       
                     EMPLOYEE_TITLE = :3H-EMPLOYEE-TITLE,               
                     BUSINESS_NAME = :3H-BUSINESS-NAME,                 
                     EMPLOYER = :3H-EMPLOYER,                           
                     OTHER_ID = :3H-OTHER-ID,                           
                     OTHER_ID_TYPE = :3H-OTHER-ID-TYPE,                 
                     DRIVERS_LICENSE_NO = :3H-DRIVERS-LICENSE-NO,       
                     CODE_STATE_ID = :3H-CODE-STATE-ID,                 
                     SSN = :3H-SSN,                                     
                     ITIN_ID = :3H-ITIN-ID,                             
                     ALLOW_CALL_FL = :3H-ALLOW-CALL-FL                  
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_STATS                                          
MFA-TR*          SET TAX_ID = :3H-TAX-ID,                                       
MFA-TR*              WEBSITE_ADDR = :3H-WEBSITE-ADDR,                           
MFA-TR*              DATE_OF_BIRTH = :3H-DATE-OF-BIRTH:WS-NULL-6,               
MFA-TR*              EMPLOYEE_TITLE = :3H-EMPLOYEE-TITLE,                       
MFA-TR*              BUSINESS_NAME = :3H-BUSINESS-NAME,                         
MFA-TR*              EMPLOYER = :3H-EMPLOYER,                                   
MFA-TR*              OTHER_ID = :3H-OTHER-ID,                                   
MFA-TR*              OTHER_ID_TYPE = :3H-OTHER-ID-TYPE,                         
MFA-TR*              DRIVERS_LICENSE_NO = :3H-DRIVERS-LICENSE-NO,               
MFA-TR*              CODE_STATE_ID = :3H-CODE-STATE-ID,                         
MFA-TR*              SSN = :3H-SSN,                                             
MFA-TR*              ITIN_ID = :3H-ITIN-ID,                                     
MFA-TR*              ALLOW_CALL_FL = :3H-ALLOW-CALL-FL                          
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8340'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CONTACT_STATS'   TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE CV-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
              MOVE 'DRIVERS_LICENSE_NO'  TO TABLE-ELEMENT-2             
              MOVE 3H-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-2           
              MOVE 'DATE_OF_BIRTH'       TO TABLE-ELEMENT-3             
              MOVE 3H-DATE-OF-BIRTH      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-PHONE.                                               
                                                                        
           IF LP-PERMISN-TO-MKT-DT <= ' '                               
               MOVE -1 TO WS-NULL-9                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-9
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT_PHONE                                  
                 SET PHONE_NO = :LP-PHONE-NO,                           
                     EXTENSION_NO = :LP-EXTENSION-NO,                   
                     MOBILE_PHONE_FL = :LP-MOBILE-PHONE-FL,             
                     PERMISN_TO_MKT_FL = :LP-PERMISN-TO-MKT-FL,         
                     PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :LP-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-9
              ) IS NULL OR (PATINDEX('%.%', :LP-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-9
              ) <> 0) OR (LEN(:LP-PERMISN-TO-MKT-DT :WS-NULL-9
              ) <> 10), CIS.CHAR2DATE(:LP-PERMISN-TO-MKT-DT :WS-NULL-9
              ), CONVERT(DATE, :LP-PERMISN-TO-MKT-DT :WS-NULL-9) )
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                 AND PHONE_TYPE = :LP-PHONE-TYPE                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_PHONE                                          
MFA-TR*          SET PHONE_NO = :LP-PHONE-NO,                                   
MFA-TR*              EXTENSION_NO = :LP-EXTENSION-NO,                           
MFA-TR*              MOBILE_PHONE_FL = :LP-MOBILE-PHONE-FL,                     
MFA-TR*              PERMISN_TO_MKT_FL = :LP-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :LP-PERMISN-TO-MKT-DT:WS-NULL-9        
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*          AND PHONE_TYPE = :LP-PHONE-TYPE                                
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8360'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE LP-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-3              
              MOVE LP-PHONE-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8370-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET NAME_FORMAT = :DQ-NAME-FORMAT,                     
                     FIRST_NAME = :DQ-FIRST-NAME,                       
                     MIDDLE_NAME = :DQ-MIDDLE-NAME,                     
                     LAST_NAME = :DQ-LAST-NAME,                         
                     TITLE_PREFIX = :DQ-TITLE-PREFIX,                   
                     TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1,               
                     FULL_NAME = :DQ-FULL-NAME                          
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*          SET NAME_FORMAT = :DQ-NAME-FORMAT,                             
MFA-TR*              FIRST_NAME = :DQ-FIRST-NAME,                               
MFA-TR*              MIDDLE_NAME = :DQ-MIDDLE-NAME,                             
MFA-TR*              LAST_NAME = :DQ-LAST-NAME,                                 
MFA-TR*              TITLE_PREFIX = :DQ-TITLE-PREFIX,                           
MFA-TR*              TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1,                       
MFA-TR*              FULL_NAME = :DQ-FULL-NAME                                  
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8370'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-2              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-3              
              MOVE 'MIDDLE_NAME'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-2            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-3            
              MOVE DQ-MIDDLE-NAME       TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8380-UPDATE-VALIDATION.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT                                        
                 SET VALIDATION_TS = CIS.CHAR2TIMESTAMP(
                                                      :CV-VALIDATION-TS
              )                  
               WHERE CONTACT_ID = :CV-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT                                                
MFA-TR*          SET VALIDATION_TS = :CV-VALIDATION-TS                          
MFA-TR*        WHERE CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       QUERYNO 8380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8380'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT'        TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE CV-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8390-UPDATE-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FREEFORM                                  
                 SET ADDR_STREET = :DZ-ADDR-STREET,                     
                     ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE,             
                     ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE,                 
                     ADDR_COUNTRY = :DZ-ADDR-COUNTRY,                   
                     ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW            
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FREEFORM                                          
MFA-TR*          SET ADDR_STREET = :DZ-ADDR-STREET,                             
MFA-TR*              ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE,                     
MFA-TR*              ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE,                         
MFA-TR*              ADDR_COUNTRY = :DZ-ADDR-COUNTRY,                           
MFA-TR*              ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW                    
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*       QUERYNO 8390                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8390'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8390-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-UPDATE-FM-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FORMATTED                                 
                 SET HOUSE_NO = :DY-HOUSE-NO,                           
                     ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1,                 
                     ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2,                 
                     STREET_NAME = :DY-STREET-NAME,                     
                     STREET_LOCATION_1 = :DY-STREET-LOCATION-1,         
                     STREET_LOCATION_2 = :DY-STREET-LOCATION-2,         
                     STREET_SUFFIX = :DY-STREET-SUFFIX,                 
                     ZIP_CODE = :DY-ZIP-CODE,                           
                     ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,       
                     ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN,               
                     ADDR_SUFFIX = :DY-ADDR-SUFFIX,                     
                     USPS_DELIV_PT_CD = :DY-USPS-DELIV-PT-CD            
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FORMATTED                                         
MFA-TR*          SET HOUSE_NO = :DY-HOUSE-NO,                                   
MFA-TR*              ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1,                         
MFA-TR*              ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2,                         
MFA-TR*              STREET_NAME = :DY-STREET-NAME,                             
MFA-TR*              STREET_LOCATION_1 = :DY-STREET-LOCATION-1,                 
MFA-TR*              STREET_LOCATION_2 = :DY-STREET-LOCATION-2,                 
MFA-TR*              STREET_SUFFIX = :DY-STREET-SUFFIX,                         
MFA-TR*              ZIP_CODE = :DY-ZIP-CODE,                                   
MFA-TR*              ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,               
MFA-TR*              ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN,                       
MFA-TR*              ADDR_SUFFIX = :DY-ADDR-SUFFIX,                             
MFA-TR*              USPS_DELIV_PT_CD = :DY-USPS-DELIV-PT-CD                    
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8410-DELETE-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FREEFORM                             
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ADDR_FREEFORM                                     
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*       QUERYNO 8410                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8410'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8420-DELETE-FM-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FORMATTED                            
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ADDR_FORMATTED                                    
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*       QUERYNO 8420                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8420'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8430-DELETE-CONT-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_ACCT                              
               WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                        
                 AND CONTACT_ID = :DW-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_ACCT                                      
MFA-TR*        WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                                
MFA-TR*          AND CONTACT_ID = :DW-CONTACT-ID                                
MFA-TR*       QUERYNO 8430                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8430'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-2              
              MOVE DW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE DW-CONTACT-ID        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8440-DELETE-CONT-CUST.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_CUST                              
               WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                      
                 AND CONTACT_ID = :DT-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_CUST                                      
MFA-TR*        WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                              
MFA-TR*          AND CONTACT_ID = :DT-CONTACT-ID                                
MFA-TR*       QUERYNO 8440                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8440'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-2              
              MOVE DT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE DT-CONTACT-ID        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8440-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8450-DELETE-CONT-PREM.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_PREM                              
               WHERE PREMISE_NO = :DX-PREMISE-NO                        
                 AND CONTACT_ID = :DX-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_PREM                                      
MFA-TR*        WHERE PREMISE_NO = :DX-PREMISE-NO                                
MFA-TR*          AND CONTACT_ID = :DX-CONTACT-ID                                
MFA-TR*       QUERYNO 8450                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8450'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_PREM'   TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-2              
              MOVE DX-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE DX-CONTACT-ID        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD00004.                                               29740000
           EXEC SQL                                                     29700000
              INCLUDE CPD00013                                          29710000
           END-EXEC.                                                    29720000
           EXEC SQL                                                     29740000
              INCLUDE CPD00071                                          29750000
           END-EXEC.                                                    29760000
           EXEC SQL                                                     29780000
              INCLUDE CPD00090                                          29790000
           END-EXEC.                                                    29800000
           EXEC SQL                                                     29820000
              INCLUDE CPD00091                                          29830000
           END-EXEC.                                                    29840000
           EXEC SQL                                                     29820000
              INCLUDE CPD00092                                          29830000
           END-EXEC.                                                    29840000
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
