       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04704.                                         
COB303 DATE-WRITTEN.  JANUARY 28, 2014.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES THIRD PARTY INFORMATION. A THIRD PARTY   *00200000
      *  CANNOT BE DELETED.                                            *00200000
      *  STATUS CODE VALUES:                                           *00200000
      *      +2 = INVALID ACTION CODE                                  *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  01/28/14   FMB       NEW PROGRAM.                             *00290000
A05317*  05/23/16   FMB       SELECT TWO MORE DATES FROM CSS_THD_PRTY  *00290000
ACT233*  07/26/16   TP7R341   REPLACE CSR00028 WITH CSR04675 FOR       *00290000
ACT233*   A05460                                                       *00290000
A05317*  12/07/16   FMB       LEFT TRIM ADDRESS FIELDS.                *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04704'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00970000
              INCLUDE TBUSRPRF                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBNAME                                            00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBADRFRE                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01010000
              INCLUDE TBADRFMT                                          01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBADDRID                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBNAMEID                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBTHDPTY                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBTHDPHO                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBTHDEML                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBTHDHST                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBACCT                                            01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBDELQ                                            01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBZIPCD                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCONACC                                          01430000
           END-EXEC.                                                    01440000
                                                                        
           COPY CWS00011.                                               01520000
           COPY CWS00303.                                               01520000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                     00000010
               INCLUDE CWS0090A                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                     00000010
               INCLUDE CWS0091A                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                     00000010
               INCLUDE CWS00071                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                     00000010
               INCLUDE CWS0013A                                         00000020
           END-EXEC.                                                    00000030
           EXEC SQL                                                     00000010
               INCLUDE CWS00056                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-THD-PRTY-ID-CHAR      PIC X(10).                      
           05  WS-THD-PRTY-ID-NUM       REDEFINES WS-THD-PRTY-ID-CHAR   
                                        PIC 9(10).                      
           05  WS-NEW-THD-PRTY-ID-NUM   PIC 9(10).                      
           05  WS-NEW-THD-PRTY-ID-CHAR  REDEFINES WS-NEW-THD-PRTY-ID-NUM
                                        PIC X(10).                      
           05  WS-NEW-NAME-ID-NUM       PIC 9(13).                      
           05  WS-NEW-NAME-ID-CHAR      REDEFINES WS-NEW-NAME-ID-NUM    
                                        PIC X(13).                      
           05  WS-NEW-ADDRESS-ID-NUM    PIC 9(13).                      
           05  WS-NEW-ADDRESS-ID-CHAR   REDEFINES WS-NEW-ADDRESS-ID-NUM 
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04704'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-PHONE-EXISTS-FLAG     PIC X(03) VALUE 'NO '.          
               88 PHONE-EXISTS                    VALUE 'YES'.          
           05  WS-HMPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 HMPH-EXISTS                     VALUE 'YES'.          
           05  WS-WKPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 WKPH-EXISTS                     VALUE 'YES'.          
           05  WS-ALPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ALPH-EXISTS                     VALUE 'YES'.          
           05  WS-NAME-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 NAME-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-6                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-7                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
A05317     05  WS-NULL-11               PIC S9(04) COMP VALUE ZERO.     
A05317     05  WS-NULL-12               PIC S9(04) COMP VALUE ZERO.     
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-HOME-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-HOME-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-WORK-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXTENSION-NO     PIC X(06) VALUE SPACES.         
           05  WS-WORK-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-ALT-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-ALT-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-COUNT                 PIC 9(09) COMP VALUE 0.         
           05  WS-DATE-NEXT-ANNIV       PIC X(10)  VALUE SPACES.        
           05  WS-ACTIVE-TO-INACTIVE-FL PIC X(01) VALUE SPACES.         
           05  WS-INACTIVE-TO-ACTIVE-FL PIC X(01) VALUE SPACES.         
           05  WS-NAME-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NAME-CHANGED                    VALUE 'YES'.          
           05  WS-THDP-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 THDP-CHANGED                    VALUE 'YES'.          
           05  WS-HMPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HMPH-CHANGED                    VALUE 'YES'.          
           05  WS-WKPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WKPH-CHANGED                    VALUE 'YES'.          
           05  WS-ALPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ALPH-CHANGED                    VALUE 'YES'.          
           05  WS-HPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HPFL-CHANGED                    VALUE 'YES'.          
           05  WS-WPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WPFL-CHANGED                    VALUE 'YES'.          
           05  WS-APFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 APFL-CHANGED                    VALUE 'YES'.          
           05  WS-ADDR-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ADDR-CHANGED                    VALUE 'YES'.          
           05  WS-AFMT-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 AFMT-CHANGED                    VALUE 'YES'.          
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-ACCOUNT-NO           PIC X(13) VALUE SPACES.          
           05  RS-THD-PRTY-ID          PIC X(10) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
      ******************************************************************        
ACT233* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT233     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT233     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE         PIC X(01).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-THD-PRTY-ID         PIC X(10).                          
       01  LINK-NAME-FORMAT         PIC X(01).                          
       01  LINK-TITLE               PIC X(09).                          
       01  LINK-FIRST-NAME          PIC X(15).                          
       01  LINK-MIDDLE-NAME         PIC X(15).                          
       01  LINK-LAST-NAME           PIC X(40).                          
       01  LINK-SUFFIX              PIC X(03).                          
       01  LINK-BUSINESS-NAME       PIC X(70).                          
       01  LINK-DATE-OF-BIRTH       PIC X(10).                          
       01  LINK-ALLOW-CALL-FL       PIC X(01).                          
       01  LINK-WORK-PHONE-NO       PIC X(10).                          
       01  LINK-WORK-PHONE-EXT      PIC X(06).                          
       01  LINK-WORK-MOBILE-FL      PIC X(01).                          
       01  LINK-WORK-MKT-FL         PIC X(01).                          
       01  LINK-HOME-PHONE-NO       PIC X(10).                          
       01  LINK-HOME-MOBILE-FL      PIC X(01).                          
       01  LINK-HOME-MKT-FL         PIC X(01).                          
       01  LINK-ALT-PHONE-NO        PIC X(10).                          
       01  LINK-ALT-MOBILE-FL       PIC X(01).                          
       01  LINK-ALT-MKT-FL          PIC X(01).                          
       01  LINK-EMPLOYER            PIC X(23).                          
       01  LINK-RELATIONSHIP        PIC X(15).                          
       01  LINK-THD-PRTY-STATUS     PIC X(01).                          
       01  LINK-ACCESS-LEVEL-CD     PIC X(02).                          
       01  LINK-ADDRESS-FORMAT      PIC X(01).                          
       01  LINK-FF-STREET-1         PIC X(55).                          
       01  LINK-FF-STREET-2         PIC X(55).                          
       01  LINK-FF-CITY-STATE       PIC X(30).                          
       01  LINK-FF-ZIP-CODE         PIC X(09).                          
       01  LINK-FF-COUNTRY          PIC X(35).                          
       01  LINK-HOUSE-NO            PIC X(15).                          
       01  LINK-ADDR-PREFIX-1       PIC X(03).                          
       01  LINK-ADDR-PREFIX-2       PIC X(02).                          
       01  LINK-STREET-NAME         PIC X(30).                          
       01  LINK-STREET-SUFFIX       PIC X(04).                          
       01  LINK-ADDR-SUFFIX         PIC X(02).                          
       01  LINK-STREET-LOC-1        PIC X(04).                          
       01  LINK-STREET-LOC-2        PIC X(11).                          
       01  LINK-TOWN                PIC X(26).                          
       01  LINK-STATE               PIC X(02).                          
       01  LINK-ZIP-CODE            PIC X(05).                          
       01  LINK-ZIP-CODE-4          PIC X(04).                          
       01  LINK-USPS-DELIV-PT       PIC X(02).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-UPDATE-TYPE,                                       
                LINK-ACCOUNT-NO,                                        
                LINK-THD-PRTY-ID,                                       
                LINK-NAME-FORMAT,                                       
                LINK-TITLE,                                             
                LINK-FIRST-NAME,                                        
                LINK-MIDDLE-NAME,                                       
                LINK-LAST-NAME,                                         
                LINK-SUFFIX,                                            
                LINK-BUSINESS-NAME,                                     
                LINK-DATE-OF-BIRTH,                                     
                LINK-ALLOW-CALL-FL,                                     
                LINK-WORK-PHONE-NO,                                     
                LINK-WORK-PHONE-EXT,                                    
                LINK-WORK-MOBILE-FL,                                    
                LINK-WORK-MKT-FL,                                       
                LINK-HOME-PHONE-NO,                                     
                LINK-HOME-MOBILE-FL,                                    
                LINK-HOME-MKT-FL,                                       
                LINK-ALT-PHONE-NO,                                      
                LINK-ALT-MOBILE-FL,                                     
                LINK-ALT-MKT-FL,                                        
                LINK-EMPLOYER,                                          
                LINK-RELATIONSHIP,                                      
                LINK-THD-PRTY-STATUS,                                   
                LINK-ACCESS-LEVEL-CD,                                   
                LINK-ADDRESS-FORMAT,                                    
                LINK-FF-STREET-1,                                       
                LINK-FF-STREET-2,                                       
                LINK-FF-CITY-STATE,                                     
                LINK-FF-ZIP-CODE,                                       
                LINK-FF-COUNTRY,                                        
                LINK-HOUSE-NO,                                          
                LINK-ADDR-PREFIX-1,                                     
                LINK-ADDR-PREFIX-2,                                     
                LINK-STREET-NAME,                                       
                LINK-STREET-SUFFIX,                                     
                LINK-ADDR-SUFFIX,                                       
                LINK-STREET-LOC-1,                                      
                LINK-STREET-LOC-2,                                      
                LINK-TOWN,                                              
                LINK-STATE,                                             
                LINK-ZIP-CODE,                                          
                LINK-ZIP-CODE-4,                                        
                LINK-USPS-DELIV-PT,                                     
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE,                  
                       :RS-ACCOUNT-NO  AS ACCOUNT_NO,                   
                       :RS-THD-PRTY-ID AS THD_PRTY_ID                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE,                          
MFA-TR*                :RS-ACCOUNT-NO  AS ACCOUNT_NO,                           
MFA-TR*                :RS-THD-PRTY-ID AS THD_PRTY_ID                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7015-DELINQUENCY THRU 7015-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-THD-PRTY-ID = SPACES                                 
               MOVE ZEROES TO LINK-THD-PRTY-ID
           END-IF.                         
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE LINK-THD-PRTY-ID TO WS-THD-PRTY-ID-CHAR.                
           MOVE WS-THD-PRTY-ID-NUM TO ZW-THD-PRTY-ID.                   
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           MOVE LINK-ACCOUNT-NO TO RS-ACCOUNT-NO.                       
           MOVE LINK-THD-PRTY-ID TO RS-THD-PRTY-ID.                     
           INSPECT LINK-FIRST-NAME REPLACING ALL '~' BY '-'.            
           INSPECT LINK-MIDDLE-NAME REPLACING ALL '~' BY '-'.           
           INSPECT LINK-LAST-NAME REPLACING ALL '~' BY '-'.             
           EXEC SQL                                                     
               SELECT CIS.STRIP3 (:LINK-RELATIONSHIP, 'LEADING', ' ')          
                 INTO :LINK-RELATIONSHIP                                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT STRIP (:LINK-RELATIONSHIP, LEADING, ' ')                  
MFA-TR*          INTO :LINK-RELATIONSHIP                                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A05317     EXEC SQL                                                     
A05317         SELECT LTRIM(:LINK-HOUSE-NO)                             
A05317           INTO :LINK-HOUSE-NO                                    
A05317           FROM CIS.SYSDUMMY1                                  
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-HOUSE-NO)                                     
MFA-TR*          INTO :LINK-HOUSE-NO                                            
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     EXEC SQL                                                     
A05317         SELECT LTRIM(:LINK-ADDR-PREFIX-1)                        
A05317           INTO :LINK-ADDR-PREFIX-1                               
A05317           FROM CIS.SYSDUMMY1                                  
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-ADDR-PREFIX-1)                                
MFA-TR*          INTO :LINK-ADDR-PREFIX-1                                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     EXEC SQL                                                     
A05317         SELECT LTRIM(:LINK-STREET-NAME)                          
A05317           INTO :LINK-STREET-NAME                                 
A05317           FROM CIS.SYSDUMMY1                                  
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-NAME)                                  
MFA-TR*          INTO :LINK-STREET-NAME                                         
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     EXEC SQL                                                     
A05317         SELECT LTRIM(:LINK-STREET-LOC-1)                         
A05317           INTO :LINK-STREET-LOC-1                                
A05317           FROM CIS.SYSDUMMY1                                  
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-LOC-1)                                 
MFA-TR*          INTO :LINK-STREET-LOC-1                                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     EXEC SQL                                                     
A05317         SELECT LTRIM(:LINK-STREET-LOC-2)                         
A05317           INTO :LINK-STREET-LOC-2                                
A05317           FROM CIS.SYSDUMMY1                                  
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-LOC-2)                                 
MFA-TR*          INTO :LINK-STREET-LOC-2                                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     EXEC SQL                                                     
A05317         SELECT LTRIM(:LINK-STREET-SUFFIX)                        
A05317           INTO :LINK-STREET-SUFFIX                               
A05317           FROM CIS.SYSDUMMY1                                  
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-STREET-SUFFIX)                                
MFA-TR*          INTO :LINK-STREET-SUFFIX                                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     EXEC SQL                                                     
A05317         SELECT LTRIM(:LINK-TOWN)                                 
A05317           INTO :LINK-TOWN                                        
A05317           FROM CIS.SYSDUMMY1                                  
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LTRIM(:LINK-TOWN)                                         
MFA-TR*          INTO :LINK-TOWN                                                
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-ALLOW-CALL-FL = 'Y'                                  
               MOVE ' ' TO LINK-ALLOW-CALL-FL
           END-IF.                          
           IF LINK-WORK-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-WORK-PHONE-EXT                       
                              LINK-WORK-MOBILE-FL                       
                              LINK-WORK-MKT-FL
           END-IF.                         
           IF LINK-HOME-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-HOME-MOBILE-FL                       
                              LINK-HOME-MKT-FL
           END-IF.                         
           IF LINK-ALT-PHONE-NO <= SPACES                               
               MOVE SPACES TO LINK-ALT-MOBILE-FL                        
                              LINK-ALT-MKT-FL
           END-IF.                          
           IF LINK-ACCESS-LEVEL-CD <= ' ' AND                           
             (LINK-UPDATE-TYPE = 'I' OR 'U')                            
                  EVALUATE TRUE                                         
                      WHEN CSR-DATABASE                                 
                          MOVE '03' TO LINK-ACCESS-LEVEL-CD             
                      WHEN SEB-DATABASE                                 
                          MOVE '  ' TO LINK-ACCESS-LEVEL-CD             
                  END-EVALUATE
           END-IF.                                         
                                                                        
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE ZEROES                   TO MH-PREMISE-NO               
                                            MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL037'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-THD-PRTY THRU 3000-EXIT          
               WHEN 'U'                                                 
                   PERFORM 3100-UPDATE-THD-PRTY THRU 3100-EXIT          
               WHEN 'V'                                                 
                   PERFORM 3300-VALIDATE-THD-PRTY THRU 3300-EXIT        
               WHEN OTHER                                               
                   PERFORM 3400-INVALID-ACTION THRU 3400-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-THD-PRTY.                                            
                                                                        
           PERFORM 7090-MAX-THD-PRTY THRU 7090-EXIT.                    
           ADD +1 TO ZW-THD-PRTY-ID.                                    
           MOVE ZW-THD-PRTY-ID TO WS-NEW-THD-PRTY-ID-NUM.               
           MOVE WS-NEW-THD-PRTY-ID-CHAR TO RS-THD-PRTY-ID.              
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
           MOVE WS-91-NEW-NAME-ID TO WS-NEW-NAME-ID-NUM.                
                                                                        
           PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT.              
           MOVE WS-90-NEW-ADDRESS-ID TO WS-NEW-ADDRESS-ID-NUM.          
                                                                        
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           INITIALIZE DCLCSS-NAME.                                      
           MOVE WS-NEW-NAME-ID-NUM       TO DQ-NAME-ID.                 
           MOVE 'TP'                     TO DQ-NAME-TYPE.               
           MOVE LINK-NAME-FORMAT         TO DQ-NAME-FORMAT.             
           IF LINK-NAME-FORMAT = 'B'                                    
               MOVE LINK-BUSINESS-NAME   TO DQ-FULL-NAME                
           ELSE                                                         
               MOVE SPACES               TO DQ-FULL-NAME
           END-IF.               
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           MOVE LINK-FIRST-NAME          TO DQ-FIRST-NAME.              
           MOVE LINK-MIDDLE-NAME         TO DQ-MIDDLE-NAME.             
           MOVE LINK-LAST-NAME           TO DQ-LAST-NAME.               
           MOVE LINK-TITLE               TO DQ-TITLE-PREFIX.            
           MOVE LINK-SUFFIX              TO DQ-TITLE-SUFFIX-1.          
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           PERFORM 8011-INSERT-NAME THRU 8011-EXIT.                     
                                                                        
           EVALUATE LINK-ADDRESS-FORMAT                                 
               WHEN 'A'                                                 
                   PERFORM 3020-INSERT-FMT-ADDRESS THRU 3020-EXIT       
               WHEN 'B'                                                 
                   PERFORM 3010-INSERT-FF-ADDRESS THRU 3010-EXIT        
           END-EVALUATE.                                                
                                                                        
           INITIALIZE DCLCSS-THD-PRTY.                                  
           MOVE WS-NEW-THD-PRTY-ID-NUM TO ZW-THD-PRTY-ID.               
           MOVE AT-ACCOUNT-NO TO ZW-ACCOUNT-NO.                         
           MOVE WS-NEW-NAME-ID-NUM TO ZW-NAME-ID.                       
           MOVE WS-NEW-ADDRESS-ID-NUM TO ZW-ADDRESS-ID.                 
           MOVE WS-CURRENT-DATE TO ZW-DATE-CREATED.                     
           MOVE LINK-THD-PRTY-STATUS TO ZW-THD-PRTY-STATUS.             
           MOVE LINK-RELATIONSHIP TO ZW-THD-PRTY-RELTNSHIP.             
           MOVE LINK-EMPLOYER TO ZW-EMPLOYER.                           
           MOVE LINK-ACCESS-LEVEL-CD TO ZW-ACCESS-LEVEL-CD.             
           MOVE LINK-ADDRESS-FORMAT TO ZW-ADDRESS-FORMAT.               
           MOVE LINK-ALLOW-CALL-FL TO ZW-ALLOW-CALL-FL.                 
           MOVE WS-CURRENT-TIMESTAMP TO ZW-LAST-UPDATE-TS.              
           MOVE LINK-DATE-OF-BIRTH TO ZW-DATE-OF-BIRTH.                 
           MOVE 'THD-PRTY-ANNIV-REV' TO C8-DELINQ-CD.                   
           MOVE AT-COMPANY-NO TO C8-COMPANY-NO.                         
           PERFORM 7020-SELECT-DELQ THRU 7020-EXIT.                     
           MOVE WS-DATE-NEXT-ANNIV TO ZW-DATE-NEXT-ANNIV.               
           PERFORM 8020-INSERT-THD-PRTY THRU 8020-EXIT.                 
                                                                        
           IF HMPH-EXISTS                                               
               MOVE WS-NEW-THD-PRTY-ID-NUM  TO ZY-THD-PRTY-ID           
               MOVE 'H1'                    TO ZY-PHONE-TYPE            
               MOVE LINK-HOME-PHONE-NO      TO ZY-PHONE-NO              
               MOVE SPACES                  TO ZY-EXTENSION-NO          
               MOVE LINK-HOME-MOBILE-FL     TO ZY-MOBILE-PHONE-FL       
               MOVE LINK-HOME-MKT-FL        TO ZY-PERMISN-TO-MKT-FL     
               IF LINK-HOME-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO ZY-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO ZY-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF WKPH-EXISTS                                               
               MOVE WS-NEW-THD-PRTY-ID-NUM  TO ZY-THD-PRTY-ID           
               MOVE 'W1'                    TO ZY-PHONE-TYPE            
               MOVE LINK-WORK-PHONE-NO      TO ZY-PHONE-NO              
               MOVE LINK-WORK-PHONE-EXT     TO ZY-EXTENSION-NO          
               MOVE LINK-WORK-MOBILE-FL     TO ZY-MOBILE-PHONE-FL       
               MOVE LINK-WORK-MKT-FL        TO ZY-PERMISN-TO-MKT-FL     
               IF LINK-WORK-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO ZY-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO ZY-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF ALPH-EXISTS                                               
               MOVE WS-NEW-THD-PRTY-ID-NUM  TO ZY-THD-PRTY-ID           
               MOVE 'A1'                    TO ZY-PHONE-TYPE            
               MOVE LINK-ALT-PHONE-NO       TO ZY-PHONE-NO              
               MOVE SPACES                  TO ZY-EXTENSION-NO          
               MOVE LINK-ALT-MOBILE-FL      TO ZY-MOBILE-PHONE-FL       
               MOVE LINK-ALT-MKT-FL         TO ZY-PERMISN-TO-MKT-FL     
               IF LINK-ALT-MKT-FL = 'Y' OR 'N'                          
                   MOVE WS-CURRENT-DATE     TO ZY-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO ZY-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           MOVE 'A' TO WS-CODE-THIRD-PTY.                               
           MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.         
           PERFORM 8040-UPDATE-ACCOUNT THRU 8040-EXIT.                  
                                                                        
           INITIALIZE DCLCSS-THD-PRTY-HIST.                             
           MOVE ZW-THD-PRTY-ID TO ZX-THD-PRTY-ID.                       
           MOVE 'A' TO ZX-LETTER-TYPE-CD.                               
           MOVE 'P' TO ZX-LETTER-STATUS.                                
           MOVE WS-CURRENT-TIMESTAMP TO ZX-DATE-TRANS.                  
           MOVE LINK-USERID TO ZX-USER-ID.                              
           PERFORM 8050-INSERT-THD-PRTY-HIST THRU 8050-EXIT.            
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-INSERT-FF-ADDRESS.                                          
                                                                        
           INITIALIZE DCLCSS-ADDR-FREEFORM.                             
           MOVE WS-NEW-ADDRESS-ID-NUM TO DZ-ADDRESS-ID.                 
           MOVE LINK-FF-STREET-1 TO DZ-ADDR-STREET.                     
           MOVE LINK-FF-STREET-2 TO DZ-ADDRESS-OVERFLOW.                
           MOVE LINK-FF-CITY-STATE TO DZ-ADDR-CITY-STATE.               
           MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE.                   
           MOVE LINK-FF-COUNTRY TO DZ-ADDR-COUNTRY.                     
           MOVE WS-CURRENT-TIMESTAMP TO DZ-LAST-UPDATE-TS.              
           PERFORM 8000-INSERT-FF-ADDR THRU 8000-EXIT.                  
           IF LINK-FF-COUNTRY <= SPACES AND                             
              LINK-FF-ZIP-CODE(1:5) > SPACES AND                        
              LINK-FF-ZIP-CODE(1:5) NUMERIC                             
                  MOVE LINK-FF-ZIP-CODE(1:5) TO A4-ZIP-CODE             
                  PERFORM 7120-VALIDATE-ZIP THRU 7120-EXIT              
                  IF A4-ZIP-CODE-TOKEN = SPACES                         
ACT233                MOVE 428              TO CATEGORY-ID-4675         
ACT233                MOVE SPACES           TO RESP-AREA-ID-4675        
ACT233                MOVE ZERO             TO SERV-ORDER-NO-4675       
ACT233                MOVE LINK-USERID      TO USER-ID-ORIG-4675        
ACT233                MOVE SPACES           TO DATE-CREATED-4675        
ACT233                MOVE SPACES           TO DATE-REQUIRED-4675       
ACT233                MOVE AT-ACCOUNT-NO    TO ACCOUNT-NO-4675          
ACT233                MOVE AT-PREMISE-NO    TO PREMISE-NO-4675          
ACT233                MOVE AT-CUSTOMER-NO   TO CUSTOMER-NO-4675         
ACT233                MOVE SPACES           TO LOCAL-OFFICE-4675        
ACT233                MOVE '4'              TO ROUTING-CATEGORY-4675    
ACT233                MOVE 'N'              TO WQ-PRIORITY-4675         
ACT233                MOVE 'CSR04704'       TO CREATED-BY-4675          
                      MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE          
                      STRING 'THE CITY STATE ZIPCODE '                  
                             LINK-FF-CITY-STATE                         
                             ' '                                        
                             LINK-FF-ZIP-CODE(1:5)                      
                             ' '                                        
                             'DOES NOT EXIST IN THE TABLE.'             
                             DELIMITED BY SIZE INTO WS-EMB-INPUT        
                      PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT
ACT233                MOVE WS-CMP-TABLE TO COMMENTS-4675-TEXT           
ACT233                MOVE +88 TO COMMENTS-4675-LEN                     
ACT233                MOVE SPACES           TO FREE-FORM-DATA-4675-TEXT 
ACT233                MOVE ZERO             TO FREE-FORM-DATA-4675-LEN  
ACT233                PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT
                  END-IF
           END-IF.        
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3020-INSERT-FMT-ADDRESS.                                         
                                                                        
           MOVE LINK-TOWN TO A4-TOWN.                                   
           MOVE LINK-STATE TO A4-STATE.                                 
           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE.                           
           PERFORM 7010-GET-TOKEN THRU 7010-EXIT.                       
                                                                        
           INITIALIZE DCLCSS-ADDR-FORMATTED.                            
           MOVE WS-NEW-ADDRESS-ID-NUM TO DY-ADDRESS-ID.                 
           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO.                           
           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1.                 
           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2.                 
           MOVE LINK-STREET-NAME TO DY-STREET-NAME.                     
           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX.                 
           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX.                     
           MOVE LINK-STREET-LOC-1 TO DY-STREET-LOCATION-1.              
           MOVE LINK-STREET-LOC-2 TO DY-STREET-LOCATION-2.              
           MOVE LINK-ZIP-CODE TO DY-ZIP-CODE.                           
           MOVE LINK-ZIP-CODE-4 TO DY-ZIP-CODE-PLUS-FOUR.               
           MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN.                 
           MOVE 'F' TO DY-ADDR-USAGE-CD.                                
           MOVE LINK-USPS-DELIV-PT TO DY-USPS-DELIV-PT-CD.              
           MOVE WS-CURRENT-TIMESTAMP TO DY-LAST-UPDATE-TS.              
           PERFORM 8010-INSERT-FMT-ADDR THRU 8010-EXIT.                 
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-THD-PRTY.                                            
                                                                        
           MOVE AT-ACCOUNT-NO TO ZW-ACCOUNT-NO.                         
           PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT.            
           PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT.            
                                                                        
           IF NAME-CHANGED                                              
               MOVE LINK-NAME-FORMAT TO DQ-NAME-FORMAT                  
               MOVE LINK-FIRST-NAME TO DQ-FIRST-NAME                    
               MOVE LINK-MIDDLE-NAME TO DQ-MIDDLE-NAME                  
               MOVE LINK-LAST-NAME TO DQ-LAST-NAME                      
               MOVE LINK-TITLE TO DQ-TITLE-PREFIX                       
               MOVE LINK-SUFFIX TO DQ-TITLE-SUFFIX-1                    
               MOVE LINK-BUSINESS-NAME TO DQ-FULL-NAME                  
               PERFORM 8370-UPDATE-NAME THRU 8370-EXIT
           END-IF.                 
                                                                        
           IF HMPH-CHANGED                                              
              MOVE ZW-THD-PRTY-ID TO ZY-THD-PRTY-ID                     
              MOVE 'H1' TO ZY-PHONE-TYPE                                
              MOVE LINK-HOME-PHONE-NO TO ZY-PHONE-NO                    
              MOVE SPACES TO ZY-EXTENSION-NO                            
              MOVE LINK-HOME-MOBILE-FL TO ZY-MOBILE-PHONE-FL            
              MOVE LINK-HOME-MKT-FL TO ZY-PERMISN-TO-MKT-FL             
              IF HPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO ZY-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF HMPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF WKPH-CHANGED                                              
              MOVE ZW-THD-PRTY-ID TO ZY-THD-PRTY-ID                     
              MOVE 'W1' TO ZY-PHONE-TYPE                                
              MOVE LINK-WORK-PHONE-NO TO ZY-PHONE-NO                    
              MOVE LINK-WORK-PHONE-EXT TO ZY-EXTENSION-NO               
              MOVE LINK-WORK-MOBILE-FL TO ZY-MOBILE-PHONE-FL            
              MOVE LINK-WORK-MKT-FL TO ZY-PERMISN-TO-MKT-FL             
              IF WPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO ZY-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF WKPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF ALPH-CHANGED                                              
              MOVE ZW-THD-PRTY-ID TO ZY-THD-PRTY-ID                     
              MOVE 'A1' TO ZY-PHONE-TYPE                                
              MOVE LINK-ALT-PHONE-NO TO ZY-PHONE-NO                     
              MOVE SPACES TO ZY-EXTENSION-NO                            
              MOVE LINK-ALT-MOBILE-FL TO ZY-MOBILE-PHONE-FL             
              MOVE LINK-ALT-MKT-FL TO ZY-PERMISN-TO-MKT-FL              
              IF APFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO ZY-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF ALPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF THDP-CHANGED                                              
               MOVE LINK-THD-PRTY-STATUS TO ZW-THD-PRTY-STATUS          
               IF WS-INACTIVE-TO-ACTIVE-FL = 'Y'                        
                   MOVE 'THD-PRTY-ANNIV-REV' TO C8-DELINQ-CD            
                   MOVE AT-COMPANY-NO TO C8-COMPANY-NO                  
                   PERFORM 7020-SELECT-DELQ THRU 7020-EXIT              
                   MOVE WS-DATE-NEXT-ANNIV TO ZW-DATE-NEXT-ANNIV        
                   MOVE SPACES TO ZW-DATE-INACTIVE                      
               END-IF                                                   
               IF WS-ACTIVE-TO-INACTIVE-FL = 'Y'                        
                   MOVE SPACES TO ZW-DATE-NEXT-ANNIV                    
                   MOVE WS-CURRENT-DATE TO ZW-DATE-INACTIVE             
               END-IF                                                   
               MOVE LINK-RELATIONSHIP TO ZW-THD-PRTY-RELTNSHIP          
               MOVE LINK-ACCESS-LEVEL-CD TO ZW-ACCESS-LEVEL-CD          
               MOVE LINK-DATE-OF-BIRTH TO ZW-DATE-OF-BIRTH              
               MOVE LINK-EMPLOYER TO ZW-EMPLOYER                        
               MOVE LINK-ALLOW-CALL-FL TO ZW-ALLOW-CALL-FL              
               MOVE LINK-ADDRESS-FORMAT TO ZW-ADDRESS-FORMAT            
               PERFORM 8350-UPDATE-THD-PRTY THRU 8350-EXIT
           END-IF.             
                                                                        
           IF ADDR-CHANGED                                              
               IF AFMT-CHANGED                                          
                   EVALUATE LINK-ADDRESS-FORMAT                         
                       WHEN 'A'                                         
                           MOVE ZW-ADDRESS-ID TO WS-NEW-ADDRESS-ID-NUM  
                           PERFORM 3020-INSERT-FMT-ADDRESS THRU         
                                   3020-EXIT                            
                           MOVE ZW-ADDRESS-ID TO DZ-ADDRESS-ID          
                           PERFORM 8410-DELETE-FF-ADDRESS THRU 8410-EXIT
                       WHEN 'B'                                         
                           MOVE ZW-ADDRESS-ID TO WS-NEW-ADDRESS-ID-NUM  
                           PERFORM 3010-INSERT-FF-ADDRESS THRU 3010-EXIT
                           MOVE ZW-ADDRESS-ID TO DY-ADDRESS-ID          
                           PERFORM 8420-DELETE-FM-ADDRESS THRU 8420-EXIT
                   END-EVALUATE                                         
               ELSE                                                     
                   EVALUATE LINK-ADDRESS-FORMAT                         
                       WHEN 'A'                                         
                           MOVE ZW-ADDRESS-ID TO DY-ADDRESS-ID          
                           MOVE LINK-TOWN TO A4-TOWN                    
                           MOVE LINK-STATE TO A4-STATE                  
                           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE            
                                                 DY-ZIP-CODE            
                           PERFORM 7010-GET-TOKEN THRU 7010-EXIT        
                           MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN  
                           MOVE LINK-HOUSE-NO TO DY-HOUSE-NO            
                           MOVE LINK-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1  
                           MOVE LINK-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2  
                           MOVE LINK-STREET-NAME TO DY-STREET-NAME      
                           MOVE LINK-STREET-SUFFIX TO DY-STREET-SUFFIX  
                           MOVE LINK-ADDR-SUFFIX TO DY-ADDR-SUFFIX      
                           MOVE LINK-STREET-LOC-1 TO                    
                                DY-STREET-LOCATION-1                    
                           MOVE LINK-STREET-LOC-2 TO                    
                                DY-STREET-LOCATION-2                    
                           MOVE LINK-ZIP-CODE-4 TO DY-ZIP-CODE-PLUS-FOUR
                           MOVE LINK-USPS-DELIV-PT TO                   
                                DY-USPS-DELIV-PT-CD                     
                           PERFORM 8400-UPDATE-FM-ADDRESS THRU 8400-EXIT
                       WHEN 'B'                                         
                           MOVE ZW-ADDRESS-ID TO DZ-ADDRESS-ID          
                           MOVE LINK-FF-STREET-1 TO DZ-ADDR-STREET      
                           MOVE LINK-FF-STREET-2 TO DZ-ADDRESS-OVERFLOW 
                           MOVE LINK-FF-CITY-STATE TO DZ-ADDR-CITY-STATE
                           MOVE LINK-FF-ZIP-CODE TO DZ-ADDR-ZIP-CODE    
                           MOVE LINK-FF-COUNTRY TO DZ-ADDR-COUNTRY      
                           PERFORM 8390-UPDATE-FF-ADDRESS THRU 8390-EXIT
                   END-EVALUATE
               END-IF
           END-IF.                                        
                                                                        
           PERFORM 7100-SELECT-HIST THRU 7100-EXIT.                     
                                                                        
           IF WS-INACTIVE-TO-ACTIVE-FL = 'Y'                            
               PERFORM 3110-INACTIVE-TO-ACTIVE THRU 3110-EXIT           
           ELSE                                                         
               IF WS-ACTIVE-TO-INACTIVE-FL = 'Y'                        
                   PERFORM 3120-ACTIVE-TO-INACTIVE THRU 3120-EXIT       
               ELSE                                                     
                   IF NAME-CHANGED OR                                   
                      HMPH-CHANGED OR                                   
                      WKPH-CHANGED OR                                   
                      ALPH-CHANGED OR                                   
                      THDP-CHANGED OR                                   
                      ADDR-CHANGED                                      
                          PERFORM 3130-CREATE-HISTORY THRU 3130-EXIT
                   END-IF
               END-IF
           END-IF.   
                                                                        
           MOVE AT-ACCOUNT-NO TO ZW-ACCOUNT-NO.                         
           MOVE WS-CURRENT-TIMESTAMP TO ZW-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3110-INACTIVE-TO-ACTIVE.                                         
                                                                        
           IF ZX-LETTER-TYPE-CD = 'I' AND                               
              ZX-LETTER-STATUS = 'P'                                    
                  MOVE 'I' TO ZX-LETTER-TYPE-CD                         
                  MOVE 'N' TO ZX-LETTER-STATUS                          
                  MOVE LINK-USERID TO ZX-USER-ID                        
                  PERFORM 8060-UPDATE-THD-PRTY-HIST THRU 8060-EXIT
           END-IF.     
                                                                        
           IF ZX-LETTER-TYPE-CD = 'C' AND                               
              ZX-LETTER-STATUS = 'P'                                    
                  MOVE 'C' TO ZX-LETTER-TYPE-CD                         
                  MOVE 'N' TO ZX-LETTER-STATUS                          
                  MOVE LINK-USERID TO ZX-USER-ID                        
                  PERFORM 8060-UPDATE-THD-PRTY-HIST THRU 8060-EXIT
           END-IF.     
                                                                        
           INITIALIZE DCLCSS-THD-PRTY-HIST                              
           MOVE ZW-THD-PRTY-ID TO ZX-THD-PRTY-ID                        
           MOVE 'A' TO ZX-LETTER-TYPE-CD                                
           MOVE 'P' TO ZX-LETTER-STATUS                                 
           MOVE WS-CURRENT-TIMESTAMP TO ZX-DATE-TRANS                   
           MOVE LINK-USERID TO ZX-USER-ID                               
           PERFORM 8050-INSERT-THD-PRTY-HIST THRU 8050-EXIT.            
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3120-ACTIVE-TO-INACTIVE.                                         
                                                                        
           IF ZX-LETTER-TYPE-CD = 'A' AND                               
              ZX-LETTER-STATUS = 'P'                                    
                  MOVE 'A' TO ZX-LETTER-TYPE-CD                         
                  MOVE 'N' TO ZX-LETTER-STATUS                          
                  MOVE LINK-USERID TO ZX-USER-ID                        
                  PERFORM 8060-UPDATE-THD-PRTY-HIST THRU 8060-EXIT      
                  GO TO 3120-EXIT
           END-IF.                                      
                                                                        
           IF ZX-LETTER-TYPE-CD = 'C' AND                               
              ZX-LETTER-STATUS = 'P'                                    
                  MOVE 'C' TO ZX-LETTER-TYPE-CD                         
                  MOVE 'N' TO ZX-LETTER-STATUS                          
                  MOVE LINK-USERID TO ZX-USER-ID                        
                  PERFORM 8060-UPDATE-THD-PRTY-HIST THRU 8060-EXIT
           END-IF.     
                                                                        
           INITIALIZE DCLCSS-THD-PRTY-HIST                              
           MOVE ZW-THD-PRTY-ID TO ZX-THD-PRTY-ID                        
           MOVE 'I' TO ZX-LETTER-TYPE-CD                                
           MOVE 'P' TO ZX-LETTER-STATUS                                 
           MOVE WS-CURRENT-TIMESTAMP TO ZX-DATE-TRANS                   
           MOVE LINK-USERID TO ZX-USER-ID                               
           PERFORM 8050-INSERT-THD-PRTY-HIST THRU 8050-EXIT.            
                                                                        
       3120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3130-CREATE-HISTORY.                                             
                                                                        
           IF NOT ((ZX-LETTER-TYPE-CD = 'A' AND                         
                    ZX-LETTER-STATUS = 'P') OR                          
                   (ZX-LETTER-TYPE-CD = 'C' AND                         
                    ZX-LETTER-STATUS = 'P'))                            
                        INITIALIZE DCLCSS-THD-PRTY-HIST                 
                        MOVE ZW-THD-PRTY-ID TO ZX-THD-PRTY-ID           
                        MOVE 'C' TO ZX-LETTER-TYPE-CD                   
                        MOVE 'P' TO ZX-LETTER-STATUS                    
                        MOVE WS-CURRENT-TIMESTAMP TO ZX-DATE-TRANS      
                        MOVE LINK-USERID TO ZX-USER-ID                  
                        PERFORM 8050-INSERT-THD-PRTY-HIST THRU          
                                8050-EXIT
           END-IF.                              
                                                                        
       3130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-VALIDATE-THD-PRTY.                                          
                                                                        
           MOVE AT-ACCOUNT-NO TO ZW-ACCOUNT-NO.                         
           MOVE WS-CURRENT-TIMESTAMP TO ZW-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*CONFIRMED*'         TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE LINK-THD-PRTY-ID      TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'THIRD PARTY ID'      TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3400-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           MOVE 0 TO S-RETURN-CODE.                                     
           MOVE +2 TO S-STATUS-CODE.                                    
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT233 4210-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              IF WS-ACTIVE-RETURN-CODE = 0                              
                  MOVE +466 TO WS-ACTIVE-RETURN-CODE                    
              END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT233        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT233        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT233                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT233                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT233             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT233             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           MOVE 'THD PRTY ID'           TO MI-COLUMN-DESC.              
           MOVE 10                      TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE WS-NEW-THD-PRTY-ID-CHAR TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE 5                       TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                       TO WS-TRAN-APPL-NO.             
                                                                        
           IF LINK-NAME-FORMAT > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              EVALUATE LINK-NAME-FORMAT                                 
                  WHEN 'I'                                              
                      MOVE 'INDIVIDUAL'  TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'B'                                              
                      MOVE 'BUSINESS'    TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'NAME FORMAT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TITLE > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TITLE            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FIRST-NAME  > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FIRST-NAME       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-MIDDLE-NAME  > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-MIDDLE-NAME  TO MI-CHG-COLUMN-VALUE-TEXT        
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-LAST-NAME > SPACES                                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LAST-NAME        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SUFFIX  > SPACES                                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SUFFIX           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-BUSINESS-NAME  > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +70                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-BUSINESS-NAME    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FULL NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF WS-NEW-NAME-ID-CHAR > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-NEW-NAME-ID-CHAR   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'NAME ID        '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DATE-OF-BIRTH  > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DATE-OF-BIRTH    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALLOW-CALL-FL > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALLOW-CALL-FL    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALLOW CALL'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-WORK-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'WORK PHONE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-EXT > SPACES                              
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +6                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-PHONE-EXT      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK PHONE EXT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MOBILE-FL      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MOBILE'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MKT-FL         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MARKET'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MKT DT'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-HOME-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PRIMARY PHONE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MOBILE-FL      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MOBILE'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MKT-FL         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MARKET'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MKT DT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-PHONE-NO > SPACES                                
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALT-PHONE-NO     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALT PHONE'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MOBILE-FL = 'Y' OR 'N'                           
              MOVE 'YES'                    TO WS-ALPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MOBILE-FL       TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MOBILE'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MKT-FL = 'Y' OR 'N'                              
              MOVE 'YES'                    TO WS-ALPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MKT-FL          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MARKET'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MKT DT'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EMPLOYER > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +23                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EMPLOYER         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMPLOYER'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-RELATIONSHIP > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-RELATIONSHIP     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'RELATION'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-THD-PRTY-STATUS > SPACES                             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              EVALUATE LINK-THD-PRTY-STATUS                             
                  WHEN 'A'                                              
                      MOVE 'ACTIVE'      TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'I'                                              
                      MOVE 'INACTIVE'    TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STATUS'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ACCESS-LEVEL-CD > SPACES                             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ACCESS-LEVEL-CD  TO 3I-ACCESS-LEVEL-CD          
              PERFORM 7005-CONTACT-ACCESS THRU 7005-EXIT                
              MOVE 3I-ACCESS-LEVEL-DESC  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ACCESS LEVEL'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDRESS-FORMAT > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDRESS-FORMAT   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-STREET-1 > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +55                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-STREET-1      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR STREET 1'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-STREET-2 > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +55                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-STREET-2      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR STREET 2'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-CITY-STATE > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-CITY-STATE    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR CITY/ST'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-ZIP-CODE > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-ZIP-CODE      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR ZIPCODE'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FF-COUNTRY > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FF-COUNTRY       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR COUNTRY'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOUSE-NO > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-HOUSE-NO         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-PREFIX-1 > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-PREFIX-1    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-PREFIX-2 > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-PREFIX-2    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-NAME > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-NAME      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-SUFFIX > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-SUFFIX    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ADDR-SUFFIX > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ADDR-SUFFIX      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-LOC-1 > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-LOC-1     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET LOC 1'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STREET-LOC-2 > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STREET-LOC-2     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STREET LOC 2'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TOWN > SPACES                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +26                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TOWN             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'TOWN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-STATE > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-STATE            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STATE'               TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ZIP-CODE > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ZIP-CODE-4 > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ZIP-CODE-4       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ZIP CODE 4'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-USPS-DELIV-PT > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-USPS-DELIV-PT    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DELIVERY PT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF DQ-NAME-FORMAT NOT = LINK-NAME-FORMAT                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-NAME-FORMAT > SPACES                              
                 EVALUATE LINK-NAME-FORMAT                              
                     WHEN 'I'                                           
                         MOVE 'INDIVIDUAL' TO MI-CHG-COLUMN-VALUE-TEXT  
                         MOVE +10          TO MI-CHG-COLUMN-VALUE-LEN   
                     WHEN 'B'                                           
                         MOVE 'BUSINESS'   TO MI-CHG-COLUMN-VALUE-TEXT  
                         MOVE +8           TO MI-CHG-COLUMN-VALUE-LEN   
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-NAME-FORMAT > SPACES                                
                 EVALUATE DQ-NAME-FORMAT                                
                     WHEN 'I'                                           
                         MOVE 'INDIVIDUAL' TO MI-PRV-COLUMN-VALUE-TEXT  
                         MOVE +10          TO MI-PRV-COLUMN-VALUE-LEN   
                     WHEN 'B'                                           
                         MOVE 'BUSINESS'   TO MI-PRV-COLUMN-VALUE-TEXT  
                         MOVE +8           TO MI-PRV-COLUMN-VALUE-LEN   
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'NAME FORMAT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-PREFIX NOT = LINK-TITLE                          
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TITLE > SPACES                                    
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TITLE         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-PREFIX > SPACES                               
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-PREFIX    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-FIRST-NAME                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FIRST-NAME > SPACES                               
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-FIRST-NAME > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FIRST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-MIDDLE-NAME NOT = LINK-MIDDLE-NAME                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-MIDDLE-NAME > SPACES                              
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT      
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-MIDDLE-NAME > SPACES                                
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-MIDDLE-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-LAST-NAME NOT = LINK-LAST-NAME                         
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-LAST-NAME > SPACES                                
                 MOVE +40                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-LAST-NAME > SPACES                                  
                 MOVE +40                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-LAST-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-SUFFIX-1 NOT = LINK-SUFFIX                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SUFFIX > SPACES                                   
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SUFFIX        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-SUFFIX-1 > SPACES                             
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-SUFFIX-1  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FULL-NAME NOT = LINK-BUSINESS-NAME                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-BUSINESS-NAME > SPACES                            
                 MOVE +70                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-BUSINESS-NAME TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-FULL-NAME > SPACES                                  
                 MOVE +70                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FULL-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'BUSINESS NAME'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF ZW-DATE-OF-BIRTH NOT = LINK-DATE-OF-BIRTH                 
              MOVE 'YES'                 TO WS-THDP-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DATE-OF-BIRTH > SPACES                            
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DATE-OF-BIRTH TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF ZW-DATE-OF-BIRTH    > SPACES                           
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE ZW-DATE-OF-BIRTH   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF ZW-ALLOW-CALL-FL NOT = LINK-ALLOW-CALL-FL                 
              MOVE 'YES'                     TO WS-THDP-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALLOW-CALL-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALLOW-CALL-FL     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF ZW-ALLOW-CALL-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE ZW-ALLOW-CALL-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALLOW CALL'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-PHONE-NO NOT = LINK-WORK-PHONE-NO                 
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-WORK-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-WORK-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-WORK-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-WORK-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'WORK PHONE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-EXTENSION-NO NOT = LINK-WORK-PHONE-EXT            
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-PHONE-EXT > SPACES                           
                 MOVE +6                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-PHONE-EXT    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-EXTENSION-NO > SPACES                          
                 MOVE +6                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-EXTENSION-NO   TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK PHONE EXT'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MOBILE-FL NOT = LINK-WORK-MOBILE-FL               
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MOBILE'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MKT-FL NOT = LINK-WORK-MKT-FL                     
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
                                                WS-WPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MARKET'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-WORK-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-WORK-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-WORK-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'WORK MKT DT'         TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-HOME-PHONE-NO NOT = LINK-HOME-PHONE-NO                 
              MOVE 'YES'                   TO WS-HMPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-HOME-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-HOME-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-HOME-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-HOME-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'PRIMARY PHONE'         TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MOBILE-FL NOT = LINK-HOME-MOBILE-FL               
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MOBILE'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MKT-FL NOT = LINK-HOME-MKT-FL                     
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
                                                WS-HPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MARKET'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-HOME-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-HOME-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-HOME-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'PRIMARY MKT DT'      TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ALT-PHONE-NO NOT = LINK-ALT-PHONE-NO                   
              MOVE 'YES'                  TO WS-ALPH-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-ALT-PHONE-NO > SPACES                             
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-ALT-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF WS-ALT-PHONE-NO > SPACES                               
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE WS-ALT-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'ALT PHONE'            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MOBILE-FL NOT = LINK-ALT-MOBILE-FL                 
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MOBILE-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MOBILE-FL TO     MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MOBILE-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MOBILE-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MOBILE'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MKT-FL NOT = LINK-ALT-MKT-FL                       
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
                                                WS-APFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MKT-FL > SPACES                               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MKT-FL TO        MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MKT-FL > SPACES                                 
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MKT-FL          TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MARKET'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-ALT-MKT-FL > ' '                                  
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-ALT-MKT-DT > SPACES                             
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-ALT-MKT-DT    TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'ALT MKT DT'          TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF ZW-EMPLOYER NOT = LINK-EMPLOYER                           
              MOVE 'YES'                 TO WS-THDP-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EMPLOYER  > SPACES                                
                 MOVE +23                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-EMPLOYER  TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF ZW-EMPLOYER   > SPACES                                 
                 MOVE +23                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE ZW-EMPLOYER        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'EMPLOYER'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF ZW-THD-PRTY-RELTNSHIP NOT = LINK-RELATIONSHIP             
              MOVE 'YES'                 TO WS-THDP-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-RELATIONSHIP  > SPACES                            
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-RELATIONSHIP  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF ZW-THD-PRTY-RELTNSHIP > SPACES                         
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE ZW-THD-PRTY-RELTNSHIP TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'RELATIONSHIP'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF ZW-THD-PRTY-STATUS NOT = LINK-THD-PRTY-STATUS             
              MOVE 'YES'                 TO WS-THDP-CHANGED-FLAG        
              IF ZW-THD-PRTY-STATUS = 'A' AND                           
                 LINK-THD-PRTY-STATUS = 'I'                             
                     MOVE 'Y' TO WS-ACTIVE-TO-INACTIVE-FL               
              END-IF                                                    
              IF ZW-THD-PRTY-STATUS = 'I' AND                           
                 LINK-THD-PRTY-STATUS = 'A'                             
                     MOVE 'Y' TO WS-INACTIVE-TO-ACTIVE-FL               
              END-IF                                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-THD-PRTY-STATUS > SPACES                          
                 EVALUATE LINK-THD-PRTY-STATUS                          
                     WHEN 'A'                                           
                         MOVE 'ACTIVE'   TO MI-CHG-COLUMN-VALUE-TEXT    
                         MOVE +6         TO MI-CHG-COLUMN-VALUE-LEN     
                     WHEN 'I'                                           
                         MOVE 'INACTIVE' TO MI-CHG-COLUMN-VALUE-TEXT    
                         MOVE +8         TO MI-CHG-COLUMN-VALUE-LEN     
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF ZW-THD-PRTY-STATUS > SPACES                            
                 EVALUATE ZW-THD-PRTY-STATUS                            
                     WHEN 'A'                                           
                         MOVE 'ACTIVE'   TO MI-PRV-COLUMN-VALUE-TEXT    
                         MOVE +6         TO MI-PRV-COLUMN-VALUE-LEN     
                     WHEN 'I'                                           
                         MOVE 'INACTIVE' TO MI-PRV-COLUMN-VALUE-TEXT    
                         MOVE +8         TO MI-PRV-COLUMN-VALUE-LEN     
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STATUS'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF ZW-ACCESS-LEVEL-CD NOT = LINK-ACCESS-LEVEL-CD             
              MOVE 'YES'                 TO WS-THDP-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ACCESS-LEVEL-CD > SPACES                          
                 MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-ACCESS-LEVEL-CD  TO 3I-ACCESS-LEVEL-CD       
                 PERFORM 7005-CONTACT-ACCESS THRU 7005-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF ZW-ACCESS-LEVEL-CD > SPACES                            
                 MOVE +15                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE ZW-ACCESS-LEVEL-CD    TO 3I-ACCESS-LEVEL-CD       
                 PERFORM 7005-CONTACT-ACCESS THRU 7005-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE '3RD PRTY ACCESS'     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF ZW-ADDRESS-FORMAT NOT = LINK-ADDRESS-FORMAT               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
                                            WS-AFMT-CHANGED-FLAG        
                                            WS-THDP-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDRESS-FORMAT > SPACES                           
                 EVALUATE LINK-ADDRESS-FORMAT                           
                     WHEN 'A'                                           
                         MOVE 'FORMATTED'   TO MI-CHG-COLUMN-VALUE-TEXT 
                         MOVE +9            TO MI-CHG-COLUMN-VALUE-LEN  
                     WHEN 'B'                                           
                         MOVE 'FREEFORM'    TO MI-CHG-COLUMN-VALUE-TEXT 
                         MOVE +8            TO MI-CHG-COLUMN-VALUE-LEN  
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF ZW-ADDRESS-FORMAT > SPACES                             
                 EVALUATE ZW-ADDRESS-FORMAT                             
                     WHEN 'A'                                           
                         MOVE 'FORMATTED'   TO MI-PRV-COLUMN-VALUE-TEXT 
                         MOVE +9            TO MI-PRV-COLUMN-VALUE-LEN  
                     WHEN 'B'                                           
                         MOVE 'FREEFORM'    TO MI-PRV-COLUMN-VALUE-TEXT 
                         MOVE +8            TO MI-PRV-COLUMN-VALUE-LEN  
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-STREET NOT = LINK-FF-STREET-1                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-STREET-1 > SPACES                              
                 MOVE +55                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-STREET-1   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-STREET > SPACES                                
                 MOVE +55                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-STREET     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW NOT = LINK-FF-STREET-2                
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-STREET-2 > SPACES                              
                 MOVE +55                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-STREET-2   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDRESS-OVERFLOW > SPACES                           
                 MOVE +55                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDRESS-OVERFLOW TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-CITY-STATE NOT = LINK-FF-CITY-STATE               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-CITY-STATE > SPACES                            
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-CITY-STATE TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-CITY-STATE > SPACES                            
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-CITY-STATE TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CITY STATE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-ZIP-CODE NOT = LINK-FF-ZIP-CODE                   
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-ZIP-CODE   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-ZIP-CODE > SPACES                              
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-ZIP-CODE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR ZIP CODE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-COUNTRY NOT = LINK-FF-COUNTRY                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FF-COUNTRY > SPACES                               
                 MOVE +35                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FF-COUNTRY    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DZ-ADDR-COUNTRY > SPACES                               
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DZ-ADDR-COUNTRY    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'COUNTRY'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-HOUSE-NO NOT = LINK-HOUSE-NO                           
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-HOUSE-NO > SPACES                                 
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-HOUSE-NO      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-HOUSE-NO > SPACES                                   
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-HOUSE-NO        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'HOUSE NO'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-1 NOT = LINK-ADDR-PREFIX-1                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-1 > SPACES                            
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-1 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-PREFIX-1 > SPACES                              
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-PREFIX-1   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX 1'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-PREFIX-2 NOT = LINK-ADDR-PREFIX-2                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-PREFIX-2 > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-PREFIX-2 TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-PREFIX-2 > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-PREFIX-2   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX 2'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-NAME NOT = LINK-STREET-NAME                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-NAME > SPACES                              
                 MOVE +30                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-NAME   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-NAME > SPACES                                
                 MOVE +30                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-SUFFIX NOT = LINK-STREET-SUFFIX                 
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-SUFFIX > SPACES                            
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-SUFFIX > SPACES                              
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-SUFFIX   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'STREET SUFFIX'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ADDR-SUFFIX NOT = LINK-ADDR-SUFFIX                     
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ADDR-SUFFIX > SPACES                              
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ADDR-SUFFIX   TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ADDR-SUFFIX > SPACES                                
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ADDR-SUFFIX     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ADDR SUFFIX'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-1 NOT = LINK-STREET-LOC-1              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOC-1 > SPACES                             
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOC-1  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-LOCATION-1 > SPACES                          
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-LOCATION-1 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 1'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-STREET-LOCATION-2 NOT = LINK-STREET-LOC-2              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-STREET-LOC-2 > SPACES                             
                 MOVE +11                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-STREET-LOC-2  TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-STREET-LOCATION-2 > SPACES                          
                 MOVE +11                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-STREET-LOCATION-2 TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LOCATION 2'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE NOT = LINK-ZIP-CODE                           
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE > SPACES                                 
                 MOVE +5                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ZIP-CODE > SPACES                                   
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ZIP-CODE        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE-PLUS-FOUR NOT = LINK-ZIP-CODE-4               
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ZIP-CODE-4 > SPACES                               
                 MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ZIP-CODE-4    TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-ZIP-CODE-PLUS-FOUR > SPACES                         
                 MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-ZIP-CODE-PLUS-FOUR TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ZIP CODE +4'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DY-USPS-DELIV-PT-CD NOT = LINK-USPS-DELIV-PT              
              MOVE 'YES'                 TO WS-ADDR-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-USPS-DELIV-PT > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-USPS-DELIV-PT TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DY-USPS-DELIV-PT-CD > SPACES                           
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DY-USPS-DELIV-PT-CD TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DELIVERY PT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-GET-BASELINE-DETAILS.                                       
                                                                        
           PERFORM 7030-SELECT-THD-PRTY THRU 7030-EXIT.                 
                                                                        
           EVALUATE ZW-ADDRESS-FORMAT                                   
               WHEN 'A'                                                 
                   PERFORM 7040-SELECT-FMT-ADDRESS THRU 7040-EXIT       
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
               WHEN 'B'                                                 
                   PERFORM 7060-SELECT-FF-ADDRESS THRU 7060-EXIT        
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
           END-EVALUATE.                                                
                                                                        
           MOVE 'H1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE ZY-PHONE-NO           TO WS-HOME-PHONE-NO            
              MOVE ZY-MOBILE-PHONE-FL    TO WS-HOME-MOBILE-FL           
              MOVE ZY-PERMISN-TO-MKT-FL  TO WS-HOME-MKT-FL              
              MOVE ZY-PERMISN-TO-MKT-DT  TO WS-HOME-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-HOME-PHONE-NO            
                                            WS-HOME-MOBILE-FL           
                                            WS-HOME-MKT-FL              
                                            WS-HOME-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO' TO WS-PHONE-EXISTS-FLAG.                           
           MOVE 'W1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE ZY-PHONE-NO           TO WS-WORK-PHONE-NO            
              MOVE ZY-EXTENSION-NO       TO WS-WORK-EXTENSION-NO        
              MOVE ZY-MOBILE-PHONE-FL    TO WS-WORK-MOBILE-FL           
              MOVE ZY-PERMISN-TO-MKT-FL  TO WS-WORK-MKT-FL              
              MOVE ZY-PERMISN-TO-MKT-DT  TO WS-WORK-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-WORK-PHONE-NO            
                                            WS-WORK-EXTENSION-NO        
                                            WS-WORK-MOBILE-FL           
                                            WS-WORK-MKT-FL              
                                            WS-WORK-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO'                     TO WS-PHONE-EXISTS-FLAG.       
           MOVE 'A1'                     TO WS-PHONE-TYPE.              
           PERFORM 7050-SELECT-PHONE          THRU 7050-EXIT.           
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE ZY-PHONE-NO           TO WS-ALT-PHONE-NO             
              MOVE ZY-MOBILE-PHONE-FL    TO WS-ALT-MOBILE-FL            
              MOVE ZY-PERMISN-TO-MKT-FL  TO WS-ALT-MKT-FL               
              MOVE ZY-PERMISN-TO-MKT-DT  TO WS-ALT-MKT-DT               
           ELSE                                                         
              MOVE SPACES                TO WS-ALT-PHONE-NO             
                                            WS-ALT-MOBILE-FL            
                                            WS-ALT-MKT-FL               
                                            WS-ALT-MKT-DT
           END-IF.              
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CODES_DATA_PRESENT,                               
                      COMPANY_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO                                        
                 INTO :AT-CODES-DATA-PRESENT,                           
                      :AT-COMPANY-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-PREMISE-NO                                    
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODES_DATA_PRESENT,                                       
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO                                                
MFA-TR*          INTO :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-PREMISE-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-CONTACT-ACCESS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ACCESS_LEVEL_DESC                                  
                INTO :3I-ACCESS-LEVEL-DESC                              
                FROM CSS_CONTACT_ACCESS WITH(READUNCOMMITTED)                   
               WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD              
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_DESC                                          
MFA-TR*         INTO :3I-ACCESS-LEVEL-DESC                                      
MFA-TR*         FROM CSS_CONTACT_ACCESS                                         
MFA-TR*        WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD                      
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 3I-ACCESS-LEVEL-CD TO 3I-ACCESS-LEVEL-DESC      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCESS' TO TABLE-1                 
                   MOVE 3I-ACCESS-LEVEL-CD TO TABLE-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-TOKEN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'TOWN'               TO TABLE-ELEMENT-1         
                   MOVE A4-TOWN              TO HOSTVAR-ELEMENT-1       
                   MOVE 'STATE'              TO TABLE-ELEMENT-2         
                   MOVE A4-STATE             TO HOSTVAR-ELEMENT-2       
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-2         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7015'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-DELQ.                                                
                                                                        
           EXEC SQL                                                     
               SELECT DATEADD(MONTH, IIF(TRY_CAST(DELINQ_VALUE
               AS INT) IS NULL, CIS.INTEGER(DELINQ_VALUE), CAST(
           DELINQ_VALUE AS INT)), CAST(SYSDATETIMEOFFSET() AS DATE))    
                 INTO :WS-DATE-NEXT-ANNIV                               
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD = :C8-DELINQ-CD                         
                  AND COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADD_MONTHS(CURRENT DATE,INTEGER(DELINQ_VALUE))            
MFA-TR*          INTO :WS-DATE-NEXT-ANNIV                                       
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD = :C8-DELINQ-CD                                 
MFA-TR*           AND COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_DELINQUENCY'    TO TABLE-1                 
                   MOVE 'DELINQ_CD'          TO TABLE-ELEMENT-1         
                   MOVE C8-DELINQ-CD         TO HOSTVAR-ELEMENT-1       
                   MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2         
                   MOVE C8-COMPANY-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-THD-PRTY.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ZW.NAME_ID,
              NAME_FORMAT,
              TITLE_PREFIX,
              FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_SUFFIX_1,
              FULL_NAME,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              THD_PRTY_STATUS,
              THD_PRTY_RELTNSHIP,
              ACCESS_LEVEL_CD,
              DATE_OF_BIRTH,
              EMPLOYER,
              ALLOW_CALL_FL,
              DATE_NEXT_ANNIV,
              DATE_INACTIVE                                      
                INTO :ZW-NAME-ID,                                       
                     :DQ-NAME-FORMAT,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME,                                     
                     :ZW-ADDRESS-ID,                                    
                     :ZW-ADDRESS-FORMAT,                                
                     :ZW-THD-PRTY-STATUS,                               
                     :ZW-THD-PRTY-RELTNSHIP,                            
                     :ZW-ACCESS-LEVEL-CD,                               
                     :ZW-DATE-OF-BIRTH :WS-NULL-7,                       
                     :ZW-EMPLOYER,                                      
                     :ZW-ALLOW-CALL-FL,                                 
A05317               :ZW-DATE-NEXT-ANNIV :WS-NULL-11,                    
A05317               :ZW-DATE-INACTIVE :WS-NULL-12                       
                FROM CSS_THD_PRTY ZW WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE THD_PRTY_ID  = :ZW-THD-PRTY-ID                     
                 AND ACCOUNT_NO = :ZW-ACCOUNT-NO                        
                 AND ZW.NAME_ID = DQ.NAME_ID                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ZW.NAME_ID,                                                
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT,                                            
MFA-TR*              THD_PRTY_STATUS,                                           
MFA-TR*              THD_PRTY_RELTNSHIP,                                        
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              DATE_NEXT_ANNIV,                                           
MFA-TR*              DATE_INACTIVE                                              
MFA-TR*         INTO :ZW-NAME-ID,                                               
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :ZW-ADDRESS-ID,                                            
MFA-TR*              :ZW-ADDRESS-FORMAT,                                        
MFA-TR*              :ZW-THD-PRTY-STATUS,                                       
MFA-TR*              :ZW-THD-PRTY-RELTNSHIP,                                    
MFA-TR*              :ZW-ACCESS-LEVEL-CD,                                       
MFA-TR*              :ZW-DATE-OF-BIRTH:WS-NULL-7,                               
MFA-TR*              :ZW-EMPLOYER,                                              
MFA-TR*              :ZW-ALLOW-CALL-FL,                                         
MFA-TR*              :ZW-DATE-NEXT-ANNIV:WS-NULL-11,                            
MFA-TR*              :ZW-DATE-INACTIVE:WS-NULL-12                               
MFA-TR*         FROM CSS_THD_PRTY ZW,                                           
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE THD_PRTY_ID  = :ZW-THD-PRTY-ID                             
MFA-TR*          AND ACCOUNT_NO = :ZW-ACCOUNT-NO                                
MFA-TR*          AND ZW.NAME_ID = DQ.NAME_ID                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-7 < 0                                     
                       MOVE SPACES TO ZW-DATE-OF-BIRTH                  
                   END-IF                                               
A05317             IF WS-NULL-11 < 0                                    
A05317                 MOVE SPACES TO ZW-DATE-NEXT-ANNIV                
A05317             END-IF                                               
A05317             IF WS-NULL-12 < 0                                    
A05317                 MOVE SPACES TO ZW-DATE-INACTIVE                  
A05317             END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_THD_PRTY'       TO TABLE-1                 
                   MOVE 'CSS_NAME'           TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE ZW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-2         
                   MOVE ZW-THD-PRTY-ID       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-FMT-ADDRESS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              STREET_SUFFIX,
              ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              ZIP_CODE_TOKEN,
              ADDR_SUFFIX,
              USPS_DELIV_PT_CD                                   
                INTO :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-SUFFIX,                                 
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
                     :DY-ADDR-SUFFIX,                                   
                     :DY-USPS-DELIV-PT-CD                               
                FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                   
               WHERE ADDRESS_ID = :ZW-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              ZIP_CODE,                                                  
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              ZIP_CODE_TOKEN,                                            
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              USPS_DELIV_PT_CD                                           
MFA-TR*         INTO :DY-HOUSE-NO,                                              
MFA-TR*              :DY-ADDR-PREFIX-1,                                         
MFA-TR*              :DY-ADDR-PREFIX-2,                                         
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-USPS-DELIV-PT-CD                                       
MFA-TR*         FROM CSS_ADDR_FORMATTED                                         
MFA-TR*        WHERE ADDRESS_ID = :ZW-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE ZW-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT                                  
                INTO :WS-PHONE-EXISTS-FLAG,                             
                     :ZY-PHONE-TYPE,                                    
                     :ZY-PHONE-NO,                                      
                     :ZY-EXTENSION-NO,                                  
                     :ZY-MOBILE-PHONE-FL,                               
                     :ZY-PERMISN-TO-MKT-FL,                             
                     :ZY-PERMISN-TO-MKT-DT :WS-NULL-2                    
                FROM CSS_THD_PRTY_PHONE WITH(READUNCOMMITTED)                   
               WHERE THD_PRTY_ID   = :ZW-THD-PRTY-ID                    
                 AND PHONE_TYPE    = :WS-PHONE-TYPE                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT                                          
MFA-TR*         INTO :WS-PHONE-EXISTS-FLAG,                                     
MFA-TR*              :ZY-PHONE-TYPE,                                            
MFA-TR*              :ZY-PHONE-NO,                                              
MFA-TR*              :ZY-EXTENSION-NO,                                          
MFA-TR*              :ZY-MOBILE-PHONE-FL,                                       
MFA-TR*              :ZY-PERMISN-TO-MKT-FL,                                     
MFA-TR*              :ZY-PERMISN-TO-MKT-DT:WS-NULL-2                            
MFA-TR*         FROM CSS_THD_PRTY_PHONE                                         
MFA-TR*        WHERE THD_PRTY_ID   = :ZW-THD-PRTY-ID                            
MFA-TR*          AND PHONE_TYPE    = :WS-PHONE-TYPE                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO ZY-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE ZW-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   MOVE 'PHONE_TYPE'     TO TABLE-ELEMENT-2             
                   MOVE WS-PHONE-TYPE    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY                                       
                INTO :DZ-ADDR-STREET,                                   
                     :DZ-ADDRESS-OVERFLOW,                              
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY                                   
                FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
               WHERE ADDRESS_ID = :ZW-ADDRESS-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY                                               
MFA-TR*         INTO :DZ-ADDR-STREET,                                           
MFA-TR*              :DZ-ADDRESS-OVERFLOW,                                      
MFA-TR*              :DZ-ADDR-CITY-STATE,                                       
MFA-TR*              :DZ-ADDR-ZIP-CODE,                                         
MFA-TR*              :DZ-ADDR-COUNTRY                                           
MFA-TR*         FROM CSS_ADDR_FREEFORM                                          
MFA-TR*        WHERE ADDRESS_ID = :ZW-ADDRESS-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE ZW-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1                                     
                INTO :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1                                 
                FROM CSS_NAME WITH(READUNCOMMITTED)                             
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1                                             
MFA-TR*         INTO :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1                                         
MFA-TR*         FROM CSS_NAME                                                   
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-1           
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-MAX-THD-PRTY.                                               
                                                                        
           EXEC SQL                                                     
              SELECT MAX(THD_PRTY_ID)                                   
                INTO :ZW-THD-PRTY-ID :WS-NULL-1                          
                FROM CSS_THD_PRTY WITH(READUNCOMMITTED)                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(THD_PRTY_ID)                                           
MFA-TR*         INTO :ZW-THD-PRTY-ID:WS-NULL-1                                  
MFA-TR*         FROM CSS_THD_PRTY                                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 8540                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE 0 TO ZW-THD-PRTY-ID                         
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO ZW-THD-PRTY-ID                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_THD_PRTY'   TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-HIST.                                                
                                                                        
           INITIALIZE DCLCSS-THD-PRTY-HIST.                             
                                                                        
           EXEC SQL                                                     
              SELECT THD_PRTY_ID,                                       
                     LETTER_TYPE_CD,                                    
                     LETTER_STATUS                                      
                INTO :ZX-THD-PRTY-ID,                                   
                     :ZX-LETTER-TYPE-CD,                                
                     :ZX-LETTER-STATUS                                  
                FROM CSS_THD_PRTY_HIST WITH(READUNCOMMITTED)                    
               WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                      
                 AND  CAST(DATE_TRANS AS DATE) = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
                 AND  LETTER_STATUS = 'P'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT THD_PRTY_ID,                                               
MFA-TR*              LETTER_TYPE_CD,                                            
MFA-TR*              LETTER_STATUS                                              
MFA-TR*         INTO :ZX-THD-PRTY-ID,                                           
MFA-TR*              :ZX-LETTER-TYPE-CD,                                        
MFA-TR*              :ZX-LETTER-STATUS                                          
MFA-TR*         FROM CSS_THD_PRTY_HIST                                          
MFA-TR*        WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                              
MFA-TR*          AND  DATE( DATE_TRANS) = :WS-CURRENT-DATE                      
MFA-TR*          AND  LETTER_STATUS = 'P'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_THD_PRTY_HIST' TO TABLE-1                  
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-2             
                   MOVE ZW-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   MOVE ZW-ACCOUNT-NO    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-VALIDATE-ZIP.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO A4-ZIP-CODE-TOKEN                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7120'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-1         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-FF-ADDR.                                             
                                                                        
            EXEC SQL                                                    
               INSERT INTO CSS_ADDR_FREEFORM                            
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_STREET_2,                                     
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW)                                  
               VALUES                                                   
                    (:DZ-ADDRESS-ID,                                    
                     :DZ-ADDR-STREET,                                   
                     :DZ-ADDR-STREET-2,                                 
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY,                                  
                     :DZ-ADDRESS-OVERFLOW)                              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_STREET'        TO TABLE-ELEMENT-2              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-STREET       TO HOSTVAR-ELEMENT-2            
              MOVE ZW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-INSERT-FMT-ADDR.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                   (ADDRESS_ID,                                         
                    HOUSE_NO,                                           
                    ADDR_PREFIX_1,                                      
                    ADDR_PREFIX_2,                                      
                    STREET_NAME,                                        
                    STREET_SUFFIX,                                      
                    STREET_LOCATION_1,                                  
                    STREET_LOCATION_2,                                  
                    ZIP_CODE,                                           
                    ZIP_CODE_PLUS_FOUR,                                 
                    ZIP_CODE_TOKEN,                                     
                    ADDR_SUFFIX,                                        
                    ADDR_USAGE_CD,                                      
                    USPS_DELIV_PT_CD)                                   
              VALUES                                                    
                   (:DY-ADDRESS-ID,                                     
                    :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-SUFFIX,                                  
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-ADDR-SUFFIX,                                    
                    :DY-ADDR-USAGE-CD,                                  
                    :DY-USPS-DELIV-PT-CD)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'STREET_NAME'        TO TABLE-ELEMENT-2              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DY-STREET-NAME       TO HOSTVAR-ELEMENT-2            
              MOVE ZW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8011-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              MOVE LINK-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-THD-PRTY.                                            
                                                                        
           IF ZW-DATE-INACTIVE <= SPACES                                
               MOVE -1 TO WS-NULL-6                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-6
           END-IF.                                     
                                                                        
           IF ZW-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-7                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-7
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_THD_PRTY                                 
                    (THD_PRTY_ID,                                       
                     ACCOUNT_NO,                                        
                     NAME_ID,                                           
                     ADDRESS_ID,                                        
                     DATE_CREATED,                                      
                     THD_PRTY_STATUS,                                   
                     DATE_INACTIVE,                                     
                     DATE_NEXT_ANNIV,                                   
                     THD_PRTY_RELTNSHIP,                                
                     ACCESS_LEVEL_CD,                                   
                     DATE_OF_BIRTH,                                     
                     LAST_UPDATE_TS,                                    
                     EMPLOYER,                                          
                     ALLOW_CALL_FL,                                     
                     ADDRESS_FORMAT)                                    
               VALUES                                                   
                     (:ZW-THD-PRTY-ID,                                  
                      :ZW-ACCOUNT-NO,                                   
                      :ZW-NAME-ID,                                      
                      :ZW-ADDRESS-ID,                                   
                      IIF(TRY_CONVERT(DATE, :ZW-DATE-CREATED
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-CREATED
              ) <> 0) OR (LEN(:ZW-DATE-CREATED) <> 10), CIS.CHAR2DATE(
                                                       :ZW-DATE-CREATED
              ), CONVERT(DATE, :ZW-DATE-CREATED) ),                            
                      :ZW-THD-PRTY-STATUS,                              
                      IIF(TRY_CONVERT(DATE, :ZW-DATE-INACTIVE :WS-NULL-6
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-INACTIVE 
                                                             :WS-NULL-6
              ) <> 0) OR (LEN(:ZW-DATE-INACTIVE :WS-NULL-6
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-INACTIVE :WS-NULL-6
              ), CONVERT(DATE, :ZW-DATE-INACTIVE :WS-NULL-6) ),                
                      IIF(TRY_CONVERT(DATE, :ZW-DATE-NEXT-ANNIV
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-NEXT-ANNIV
              ) <> 0) OR (LEN(:ZW-DATE-NEXT-ANNIV
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-NEXT-ANNIV
              ), CONVERT(DATE, :ZW-DATE-NEXT-ANNIV) ),                         
                      :ZW-THD-PRTY-RELTNSHIP,                           
                      :ZW-ACCESS-LEVEL-CD,                              
                      IIF(TRY_CONVERT(DATE, :ZW-DATE-OF-BIRTH :WS-NULL-7
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-OF-BIRTH 
                                                             :WS-NULL-7
              ) <> 0) OR (LEN(:ZW-DATE-OF-BIRTH :WS-NULL-7
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-OF-BIRTH :WS-NULL-7
              ), CONVERT(DATE, :ZW-DATE-OF-BIRTH :WS-NULL-7) ),                
                      CIS.CHAR2TIMESTAMP(:ZW-LAST-UPDATE-TS),                   
                      :ZW-EMPLOYER,                                     
                      :ZW-ALLOW-CALL-FL,                                
                      :ZW-ADDRESS-FORMAT)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_THD_PRTY                                         
MFA-TR*             (THD_PRTY_ID,                                               
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              NAME_ID,                                                   
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              DATE_CREATED,                                              
MFA-TR*              THD_PRTY_STATUS,                                           
MFA-TR*              DATE_INACTIVE,                                             
MFA-TR*              DATE_NEXT_ANNIV,                                           
MFA-TR*              THD_PRTY_RELTNSHIP,                                        
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ADDRESS_FORMAT)                                            
MFA-TR*        VALUES                                                           
MFA-TR*              (:ZW-THD-PRTY-ID,                                          
MFA-TR*               :ZW-ACCOUNT-NO,                                           
MFA-TR*               :ZW-NAME-ID,                                              
MFA-TR*               :ZW-ADDRESS-ID,                                           
MFA-TR*               :ZW-DATE-CREATED,                                         
MFA-TR*               :ZW-THD-PRTY-STATUS,                                      
MFA-TR*               :ZW-DATE-INACTIVE:WS-NULL-6,                              
MFA-TR*               :ZW-DATE-NEXT-ANNIV,                                      
MFA-TR*               :ZW-THD-PRTY-RELTNSHIP,                                   
MFA-TR*               :ZW-ACCESS-LEVEL-CD,                                      
MFA-TR*               :ZW-DATE-OF-BIRTH:WS-NULL-7,                              
MFA-TR*               :ZW-LAST-UPDATE-TS,                                       
MFA-TR*               :ZW-EMPLOYER,                                             
MFA-TR*               :ZW-ALLOW-CALL-FL,                                        
MFA-TR*               :ZW-ADDRESS-FORMAT)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE ZW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-PHONE.                                               
                                                                        
           IF ZY-PERMISN-TO-MKT-DT <= SPACES                            
               MOVE -1 TO WS-NULL-10                                    
           ELSE                                                         
               MOVE 0 TO WS-NULL-10
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_THD_PRTY_PHONE                            
                   ( THD_PRTY_ID,                                       
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT)                                 
              VALUES                                                    
                   (:ZY-THD-PRTY-ID,                                    
                    :ZY-PHONE-TYPE,                                     
                    :ZY-PHONE-NO,                                       
                    :ZY-EXTENSION-NO,                                   
                    :ZY-MOBILE-PHONE-FL,                                
                    :ZY-PERMISN-TO-MKT-FL,                              
                    IIF(TRY_CONVERT(DATE, :ZY-PERMISN-TO-MKT-DT 
                                          :WS-NULL-10
              ) IS NULL OR (PATINDEX('%.%', :ZY-PERMISN-TO-MKT-DT 
                                                            :WS-NULL-10
              ) <> 0) OR (LEN(:ZY-PERMISN-TO-MKT-DT :WS-NULL-10
              ) <> 10), CIS.CHAR2DATE(:ZY-PERMISN-TO-MKT-DT :WS-NULL-10
              ), CONVERT(DATE, :ZY-PERMISN-TO-MKT-DT :WS-NULL-10) ))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_THD_PRTY_PHONE                                    
MFA-TR*            ( THD_PRTY_ID,                                               
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:ZY-THD-PRTY-ID,                                            
MFA-TR*             :ZY-PHONE-TYPE,                                             
MFA-TR*             :ZY-PHONE-NO,                                               
MFA-TR*             :ZY-EXTENSION-NO,                                           
MFA-TR*             :ZY-MOBILE-PHONE-FL,                                        
MFA-TR*             :ZY-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :ZY-PERMISN-TO-MKT-DT:WS-NULL-10)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-3              
              MOVE ZY-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE ZY-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE ZY-PHONE-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8040-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8040'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-THD-PRTY-HIST.                                       
                                                                        
             IF ZX-DATE-MAILED <= SPACES                                
                 MOVE -1 TO WS-NULL-3                                   
           ELSE                                                         
               MOVE 0 TO WS-NULL-3
             END-IF.                                     
                                                                        
             EXEC SQL                                                   
                 INSERT INTO CSS_THD_PRTY_HIST                          
                     (THD_PRTY_ID,                                      
                      DATE_TRANS,                                       
                      LETTER_STATUS,                                    
                      LETTER_TYPE_CD,                                   
                      DATE_MAILED,                                      
                      USER_ID)                                          
                 VALUES                                                 
                      (:ZX-THD-PRTY-ID,                                 
                       CIS.CHAR2TIMESTAMP(:ZX-DATE-TRANS),                      
                       :ZX-LETTER-STATUS,                               
                       :ZX-LETTER-TYPE-CD,                              
                       IIF(TRY_CONVERT(DATE, :ZX-DATE-MAILED :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :ZX-DATE-MAILED :WS-NULL-3
              ) <> 0) OR (LEN(:ZX-DATE-MAILED :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:ZX-DATE-MAILED :WS-NULL-3
              ), CONVERT(DATE, :ZX-DATE-MAILED :WS-NULL-3) ),                  
                       :ZX-USER-ID)                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*      EXEC SQL                                                           
MFA-TR*          INSERT INTO CSS_THD_PRTY_HIST                                  
MFA-TR*              (THD_PRTY_ID,                                              
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               LETTER_STATUS,                                            
MFA-TR*               LETTER_TYPE_CD,                                           
MFA-TR*               DATE_MAILED,                                              
MFA-TR*               USER_ID)                                                  
MFA-TR*          VALUES                                                         
MFA-TR*               (:ZX-THD-PRTY-ID,                                         
MFA-TR*                :ZX-DATE-TRANS,                                          
MFA-TR*                :ZX-LETTER-STATUS,                                       
MFA-TR*                :ZX-LETTER-TYPE-CD,                                      
MFA-TR*                :ZX-DATE-MAILED:WS-NULL-3,                               
MFA-TR*                :ZX-USER-ID)                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_HIST'  TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE ZW-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-UPDATE-THD-PRTY-HIST.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_THD_PRTY_HIST                                 
                  SET LETTER_TYPE_CD = :ZX-LETTER-TYPE-CD,              
                      LETTER_STATUS = :ZX-LETTER-STATUS,                
                      USER_ID = :ZX-USER-ID                             
                WHERE THD_PRTY_ID = :ZX-THD-PRTY-ID                     
                  AND CAST(DATE_TRANS AS DATE) = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_THD_PRTY_HIST                                         
MFA-TR*           SET LETTER_TYPE_CD = :ZX-LETTER-TYPE-CD,                      
MFA-TR*               LETTER_STATUS = :ZX-LETTER-STATUS,                        
MFA-TR*               USER_ID = :ZX-USER-ID                                     
MFA-TR*         WHERE THD_PRTY_ID = :ZX-THD-PRTY-ID                             
MFA-TR*           AND DATE(DATE_TRANS) = :WS-CURRENT-DATE                       
MFA-TR*      QUERYNO 8060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_HIST'  TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE ZW-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-DELETE-NULL-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_THD_PRTY_PHONE                            
               WHERE THD_PRTY_ID        = :ZY-THD-PRTY-ID               
                 AND PHONE_TYPE         = :ZY-PHONE-TYPE                
                 AND PHONE_NO           = ' '                           
                 AND EXTENSION_NO       = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_THD_PRTY_PHONE                                    
MFA-TR*        WHERE THD_PRTY_ID        = :ZY-THD-PRTY-ID                       
MFA-TR*          AND PHONE_TYPE         = :ZY-PHONE-TYPE                        
MFA-TR*          AND PHONE_NO           = ' '                                   
MFA-TR*          AND EXTENSION_NO       = ' '                                   
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE ZY-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE-TYPE'         TO TABLE-ELEMENT-2              
              MOVE ZY-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8350-UPDATE-THD-PRTY.                                            
                                                                        
           IF ZW-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-7                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-7
           END-IF.                                     
           IF ZW-DATE-NEXT-ANNIV <= SPACES                              
               MOVE -1 TO WS-NULL-8                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-8
           END-IF.                                     
           IF ZW-DATE-INACTIVE <= SPACES                                
               MOVE -1 TO WS-NULL-9                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-9
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_THD_PRTY                                       
                 SET THD_PRTY_STATUS = :ZW-THD-PRTY-STATUS,             
                     THD_PRTY_RELTNSHIP = :ZW-THD-PRTY-RELTNSHIP,       
                     ACCESS_LEVEL_CD = :ZW-ACCESS-LEVEL-CD,             
                     DATE_OF_BIRTH = IIF(TRY_CONVERT(DATE, 
                                                     :ZW-DATE-OF-BIRTH 
                                                           :WS-NULL-7
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-OF-BIRTH 
                                                             :WS-NULL-7
              ) <> 0) OR (LEN(:ZW-DATE-OF-BIRTH :WS-NULL-7
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-OF-BIRTH :WS-NULL-7
              ), CONVERT(DATE, :ZW-DATE-OF-BIRTH :WS-NULL-7) ),       
                     EMPLOYER = :ZW-EMPLOYER,                           
                     ALLOW_CALL_FL = :ZW-ALLOW-CALL-FL,                 
                     ADDRESS_FORMAT = :ZW-ADDRESS-FORMAT,               
                     DATE_NEXT_ANNIV = IIF(TRY_CONVERT(DATE, 
                                                   :ZW-DATE-NEXT-ANNIV 
                                                             :WS-NULL-8
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-NEXT-ANNIV 
                                                             :WS-NULL-8
              ) <> 0) OR (LEN(:ZW-DATE-NEXT-ANNIV :WS-NULL-8
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-NEXT-ANNIV :WS-NULL-8
              ), CONVERT(DATE, :ZW-DATE-NEXT-ANNIV :WS-NULL-8) ),   
                     DATE_INACTIVE = IIF(TRY_CONVERT(DATE, 
                                                     :ZW-DATE-INACTIVE 
                                                           :WS-NULL-9
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-INACTIVE 
                                                             :WS-NULL-9
              ) <> 0) OR (LEN(:ZW-DATE-INACTIVE :WS-NULL-9
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-INACTIVE :WS-NULL-9
              ), CONVERT(DATE, :ZW-DATE-INACTIVE :WS-NULL-9) )        
               WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                      
                 AND ACCOUNT_NO = :ZW-ACCOUNT-NO                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY                                               
MFA-TR*          SET THD_PRTY_STATUS = :ZW-THD-PRTY-STATUS,                     
MFA-TR*              THD_PRTY_RELTNSHIP = :ZW-THD-PRTY-RELTNSHIP,               
MFA-TR*              ACCESS_LEVEL_CD = :ZW-ACCESS-LEVEL-CD,                     
MFA-TR*              DATE_OF_BIRTH = :ZW-DATE-OF-BIRTH:WS-NULL-7,               
MFA-TR*              EMPLOYER = :ZW-EMPLOYER,                                   
MFA-TR*              ALLOW_CALL_FL = :ZW-ALLOW-CALL-FL,                         
MFA-TR*              ADDRESS_FORMAT = :ZW-ADDRESS-FORMAT,                       
MFA-TR*              DATE_NEXT_ANNIV = :ZW-DATE-NEXT-ANNIV:WS-NULL-8,           
MFA-TR*              DATE_INACTIVE = :ZW-DATE-INACTIVE:WS-NULL-9                
MFA-TR*        WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                              
MFA-TR*          AND ACCOUNT_NO = :ZW-ACCOUNT-NO                                
MFA-TR*       QUERYNO 8350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8350'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY'       TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE ZW-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE ZW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-PHONE.                                               
                                                                        
           IF ZY-PERMISN-TO-MKT-DT <= ' '                               
               MOVE -1 TO WS-NULL-5                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-5
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_THD_PRTY_PHONE                                 
                 SET PHONE_NO          = :ZY-PHONE-NO,                  
                     EXTENSION_NO      = :ZY-EXTENSION-NO,              
                     MOBILE_PHONE_FL   = :ZY-MOBILE-PHONE-FL,           
                     PERMISN_TO_MKT_FL = :ZY-PERMISN-TO-MKT-FL,         
                     PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :ZY-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :ZY-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) <> 0) OR (LEN(:ZY-PERMISN-TO-MKT-DT :WS-NULL-5
              ) <> 10), CIS.CHAR2DATE(:ZY-PERMISN-TO-MKT-DT :WS-NULL-5
              ), CONVERT(DATE, :ZY-PERMISN-TO-MKT-DT :WS-NULL-5) )
               WHERE THD_PRTY_ID   = :ZY-THD-PRTY-ID                    
                 AND PHONE_TYPE    = :ZY-PHONE-TYPE                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY_PHONE                                         
MFA-TR*          SET PHONE_NO          = :ZY-PHONE-NO,                          
MFA-TR*              EXTENSION_NO      = :ZY-EXTENSION-NO,                      
MFA-TR*              MOBILE_PHONE_FL   = :ZY-MOBILE-PHONE-FL,                   
MFA-TR*              PERMISN_TO_MKT_FL = :ZY-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :ZY-PERMISN-TO-MKT-DT:WS-NULL-5        
MFA-TR*        WHERE THD_PRTY_ID   = :ZY-THD-PRTY-ID                            
MFA-TR*          AND PHONE_TYPE    = :ZY-PHONE-TYPE                             
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8360'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE ZY-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE ZY-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE ZY-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8370-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET FIRST_NAME      = :DQ-FIRST-NAME,                  
                     MIDDLE_NAME     = :DQ-MIDDLE-NAME,                 
                     LAST_NAME       = :DQ-LAST-NAME,                   
                     TITLE_PREFIX    = :DQ-TITLE-PREFIX,                
                     TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1,              
                     NAME_FORMAT     = :DQ-NAME-FORMAT,                 
                     FULL_NAME       = :DQ-FULL-NAME                    
               WHERE NAME_ID         = :ZW-NAME-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*          SET FIRST_NAME      = :DQ-FIRST-NAME,                          
MFA-TR*              MIDDLE_NAME     = :DQ-MIDDLE-NAME,                         
MFA-TR*              LAST_NAME       = :DQ-LAST-NAME,                           
MFA-TR*              TITLE_PREFIX    = :DQ-TITLE-PREFIX,                        
MFA-TR*              TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1,                      
MFA-TR*              NAME_FORMAT     = :DQ-NAME-FORMAT,                         
MFA-TR*              FULL_NAME       = :DQ-FULL-NAME                            
MFA-TR*        WHERE NAME_ID         = :ZW-NAME-ID                              
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8370'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-2              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-3              
              MOVE 'MIDDLE_NAME'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-2            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-3            
              MOVE DQ-MIDDLE-NAME       TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8380-UPDATE-VALIDATION.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_THD_PRTY                                       
                 SET VALIDATION_TS = CIS.CHAR2TIMESTAMP(
                                                      :ZW-VALIDATION-TS
              )                  
               WHERE ACCOUNT_NO = :ZW-ACCOUNT-NO                        
                 AND THD_PRTY_ID = :ZW-THD-PRTY-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY                                               
MFA-TR*          SET VALIDATION_TS = :ZW-VALIDATION-TS                          
MFA-TR*        WHERE ACCOUNT_NO = :ZW-ACCOUNT-NO                                
MFA-TR*          AND THD_PRTY_ID = :ZW-THD-PRTY-ID                              
MFA-TR*       QUERYNO 8380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8380'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE ZW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-2              
              MOVE ZW-THD-PRTY-ID       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8390-UPDATE-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FREEFORM                                  
                 SET ADDR_STREET = :DZ-ADDR-STREET,                     
                     ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE,             
                     ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE,                 
                     ADDR_COUNTRY = :DZ-ADDR-COUNTRY,                   
                     ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW            
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FREEFORM                                          
MFA-TR*          SET ADDR_STREET = :DZ-ADDR-STREET,                             
MFA-TR*              ADDR_CITY_STATE = :DZ-ADDR-CITY-STATE,                     
MFA-TR*              ADDR_ZIP_CODE = :DZ-ADDR-ZIP-CODE,                         
MFA-TR*              ADDR_COUNTRY = :DZ-ADDR-COUNTRY,                           
MFA-TR*              ADDRESS_OVERFLOW = :DZ-ADDRESS-OVERFLOW                    
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*       QUERYNO 8390                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8390'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8390-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-UPDATE-FM-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FORMATTED                                 
                 SET HOUSE_NO = :DY-HOUSE-NO,                           
                     ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1,                 
                     ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2,                 
                     STREET_NAME = :DY-STREET-NAME,                     
                     STREET_LOCATION_1 = :DY-STREET-LOCATION-1,         
                     STREET_LOCATION_2 = :DY-STREET-LOCATION-2,         
                     STREET_SUFFIX = :DY-STREET-SUFFIX,                 
                     ZIP_CODE = :DY-ZIP-CODE,                           
                     ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,       
                     ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN,               
                     ADDR_SUFFIX = :DY-ADDR-SUFFIX,                     
                     USPS_DELIV_PT_CD = :DY-USPS-DELIV-PT-CD            
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FORMATTED                                         
MFA-TR*          SET HOUSE_NO = :DY-HOUSE-NO,                                   
MFA-TR*              ADDR_PREFIX_1 = :DY-ADDR-PREFIX-1,                         
MFA-TR*              ADDR_PREFIX_2 = :DY-ADDR-PREFIX-2,                         
MFA-TR*              STREET_NAME = :DY-STREET-NAME,                             
MFA-TR*              STREET_LOCATION_1 = :DY-STREET-LOCATION-1,                 
MFA-TR*              STREET_LOCATION_2 = :DY-STREET-LOCATION-2,                 
MFA-TR*              STREET_SUFFIX = :DY-STREET-SUFFIX,                         
MFA-TR*              ZIP_CODE = :DY-ZIP-CODE,                                   
MFA-TR*              ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,               
MFA-TR*              ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN,                       
MFA-TR*              ADDR_SUFFIX = :DY-ADDR-SUFFIX,                             
MFA-TR*              USPS_DELIV_PT_CD = :DY-USPS-DELIV-PT-CD                    
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8410-DELETE-FF-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FREEFORM                             
               WHERE ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ADDR_FREEFORM                                     
MFA-TR*        WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*       QUERYNO 8410                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8410'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8420-DELETE-FM-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FORMATTED                            
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ADDR_FORMATTED                                    
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*       QUERYNO 8420                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8420'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD00004.                                               29740000
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
           EXEC SQL                                                             
               INCLUDE CPD00071                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00013                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00090                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00091                                                 
           END-EXEC.                                                            
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
