       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04703.                                         
COB303 DATE-WRITTEN.  JANUARY 15, 2014.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES ROOMMATE/COAPPLICANT INFORMATION.        *00200000
      *  STATUS CODE VALUES:                                           *00200000
      *      +2 = INVALID ACTION CODE                                  *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  01/15/14   FMB       NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04703'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00970000
              INCLUDE TBUSRPRF                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBCUST                                            00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBCSTPHN                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01010000
              INCLUDE TBCSTSTS                                          01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01090000
              INCLUDE TBNAME                                            01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01170000
              INCLUDE TBNMACTX                                          01180000
           END-EXEC.                                                    01190000
           EXEC SQL                                                     01340000
              INCLUDE TBACCT                                            01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCUSXFR                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBROOMT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCOAPP                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCONACC                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBDELQ                                            01430000
           END-EXEC.                                                    01440000
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-ASSOC-CUSTOMER-NO     PIC 9(10).                      
           05  WS-ACCOUNT-NO            PIC 9(13).                      
           05  WS-CUSTOMER-NO           PIC 9(10).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04703'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-PHONE-EXISTS-FLAG     PIC X(03) VALUE 'NO '.          
               88 PHONE-EXISTS                    VALUE 'YES'.          
           05  WS-HMPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 HMPH-EXISTS                     VALUE 'YES'.          
           05  WS-WKPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 WKPH-EXISTS                     VALUE 'YES'.          
           05  WS-ALPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ALPH-EXISTS                     VALUE 'YES'.          
           05  WS-NAME-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 NAME-EXISTS                     VALUE 'YES'.          
           05  WS-CSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CSTS-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-HOME-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-HOME-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-WORK-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXTENSION-NO     PIC X(06) VALUE SPACES.         
           05  WS-WORK-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-ALT-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-ALT-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-ACCESS-LEVEL-CD       PIC X(02) VALUE SPACES.         
           05  WS-NAME-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NAME-CHANGED                    VALUE 'YES'.          
           05  WS-CSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CSTS-CHANGED                    VALUE 'YES'.          
           05  WS-HMPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HMPH-CHANGED                    VALUE 'YES'.          
           05  WS-WKPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WKPH-CHANGED                    VALUE 'YES'.          
           05  WS-ALPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ALPH-CHANGED                    VALUE 'YES'.          
           05  WS-HPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HPFL-CHANGED                    VALUE 'YES'.          
           05  WS-WPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WPFL-CHANGED                    VALUE 'YES'.          
           05  WS-APFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 APFL-CHANGED                    VALUE 'YES'.          
           05  WS-ACCS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ACCS-CHANGED                    VALUE 'YES'.          
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE         PIC X(01).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-ASSOC-CUSTOMER-NO   PIC X(10).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-ALLIANCE-TYPE-CD    PIC X(02).                          
       01  LINK-TITLE               PIC X(09).                          
       01  LINK-FIRST-NAME          PIC X(15).                          
       01  LINK-MIDDLE-NAME         PIC X(15).                          
       01  LINK-LAST-NAME           PIC X(40).                          
       01  LINK-SUFFIX              PIC X(03).                          
       01  LINK-SSN                 PIC X(09).                          
       01  LINK-ITIN                PIC X(09).                          
       01  LINK-REFUSED-SSN         PIC X(01).                          
       01  LINK-DLN                 PIC X(19).                          
       01  LINK-DLN-STATE           PIC X(02).                          
       01  LINK-DATE-OF-BIRTH       PIC X(10).                          
       01  LINK-OTHER-ID-TYPE       PIC X(12).                          
       01  LINK-OTHER-ID            PIC X(16).                          
       01  LINK-ALLOW-CALL-FL       PIC X(01).                          
       01  LINK-ALLOW-EMAIL-FL      PIC X(01).                          
       01  LINK-WORK-PHONE-NO       PIC X(10).                          
       01  LINK-WORK-PHONE-EXT      PIC X(06).                          
       01  LINK-WORK-MOBILE-FL      PIC X(01).                          
       01  LINK-WORK-MKT-FL         PIC X(01).                          
       01  LINK-HOME-PHONE-NO       PIC X(10).                          
       01  LINK-HOME-MOBILE-FL      PIC X(01).                          
       01  LINK-HOME-MKT-FL         PIC X(01).                          
       01  LINK-ALT-PHONE-NO        PIC X(10).                          
       01  LINK-ALT-MOBILE-FL       PIC X(01).                          
       01  LINK-ALT-MKT-FL          PIC X(01).                          
       01  LINK-EMPLOYER            PIC X(23).                          
       01  LINK-ACCESS-LEVEL-CD     PIC X(02).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
      * LINK-ASSOC-CUSTOMER-NO CONTAINS THE CUSTOMER NUMBER WITH                
      * WHICH THE ROOMMATE OR COAPP IS ASSOCIATED.                              
      * WILL HAVE EITHER LINK-ACCOUNT-NO OR LINK-ASSOC-CUSTOMER-NO.             
      * LINK-CUSTOMER-NO CONTAINS THE CUSTOMER NUMBER OF THE ROOMMATE           
      * OR COAPPLICANT.                                                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-UPDATE-TYPE,                                       
                LINK-ACCOUNT-NO,                                        
                LINK-ASSOC-CUSTOMER-NO,                                 
                LINK-CUSTOMER-NO,                                       
                LINK-ALLIANCE-TYPE-CD,                                  
                LINK-TITLE,                                             
                LINK-FIRST-NAME,                                        
                LINK-MIDDLE-NAME,                                       
                LINK-LAST-NAME,                                         
                LINK-SUFFIX,                                            
                LINK-SSN,                                               
                LINK-ITIN,                                              
                LINK-REFUSED-SSN,                                       
                LINK-DLN,                                               
                LINK-DLN-STATE,                                         
                LINK-DATE-OF-BIRTH,                                     
                LINK-OTHER-ID-TYPE,                                     
                LINK-OTHER-ID,                                          
                LINK-ALLOW-CALL-FL,                                     
                LINK-ALLOW-EMAIL-FL,                                    
                LINK-WORK-PHONE-NO,                                     
                LINK-WORK-PHONE-EXT,                                    
                LINK-WORK-MOBILE-FL,                                    
                LINK-WORK-MKT-FL,                                       
                LINK-HOME-PHONE-NO,                                     
                LINK-HOME-MOBILE-FL,                                    
                LINK-HOME-MKT-FL,                                       
                LINK-ALT-PHONE-NO,                                      
                LINK-ALT-MOBILE-FL,                                     
                LINK-ALT-MKT-FL,                                        
                LINK-EMPLOYER,                                          
                LINK-ACCESS-LEVEL-CD,                                   
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE,                  
                       :RS-CUSTOMER-NO AS CUSTOMER_NO                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE,                          
MFA-TR*                :RS-CUSTOMER-NO AS CUSTOMER_NO                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7015-DELINQUENCY THRU 7015-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-CUSTOMER-NO <= SPACES                                
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-ASSOC-CUSTOMER-NO <= SPACES                          
               MOVE ZEROES TO LINK-ASSOC-CUSTOMER-NO
           END-IF.                   
           IF LINK-ACCOUNT-NO <= SPACES                                 
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-ACCOUNT-NO > ZEROES                                  
               MOVE ZEROES TO LINK-ASSOC-CUSTOMER-NO
           END-IF.                   
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO.                   
           MOVE LINK-ASSOC-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.          
           MOVE WS-CUSTOMER-NO-NUM TO WS-ASSOC-CUSTOMER-NO.             
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO WS-ACCOUNT-NO.                     
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           MOVE LINK-CUSTOMER-NO TO RS-CUSTOMER-NO.                     
           INSPECT LINK-FIRST-NAME REPLACING ALL '~' BY '-'.            
           INSPECT LINK-MIDDLE-NAME REPLACING ALL '~' BY '-'.           
           INSPECT LINK-LAST-NAME REPLACING ALL '~' BY '-'.             
           IF LINK-ALLOW-CALL-FL = 'Y'                                  
               MOVE ' ' TO LINK-ALLOW-CALL-FL
           END-IF.                          
           IF LINK-ALLOW-EMAIL-FL = 'Y'                                 
               MOVE ' ' TO LINK-ALLOW-EMAIL-FL
           END-IF.                         
           IF LINK-REFUSED-SSN = 'N'                                    
               MOVE ' ' TO LINK-REFUSED-SSN
           END-IF.                            
           IF LINK-WORK-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-WORK-PHONE-EXT                       
                              LINK-WORK-MOBILE-FL                       
                              LINK-WORK-MKT-FL
           END-IF.                         
           IF LINK-HOME-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-HOME-MOBILE-FL                       
                              LINK-HOME-MKT-FL
           END-IF.                         
           IF LINK-ALT-PHONE-NO <= SPACES                               
               MOVE SPACES TO LINK-ALT-MOBILE-FL                        
                              LINK-ALT-MKT-FL
           END-IF.                          
           IF LINK-ACCESS-LEVEL-CD <= ' ' AND                           
             (LINK-UPDATE-TYPE = 'I' OR 'U')                            
                  IF CSR-DATABASE                                       
                      EVALUATE LINK-ALLIANCE-TYPE-CD                    
                          WHEN 'CO'                                     
                              MOVE '01' TO LINK-ACCESS-LEVEL-CD         
                          WHEN 'RO'                                     
                              MOVE '03' TO LINK-ACCESS-LEVEL-CD         
                      END-EVALUATE                                      
                  ELSE                                                  
                      EVALUATE LINK-ALLIANCE-TYPE-CD                    
                          WHEN 'CO'                                     
                              MOVE '  ' TO LINK-ACCESS-LEVEL-CD         
                          WHEN 'RO'                                     
                              MOVE '  ' TO LINK-ACCESS-LEVEL-CD         
                      END-EVALUATE
                  END-IF
           END-IF.                                     
                                                                        
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE WS-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE WS-ASSOC-CUSTOMER-NO     TO MH-CUSTOMER-NO.             
           MOVE ZEROES                   TO MH-PREMISE-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL037'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-ACCOUNT-NO > 0                                         
               MOVE WS-ACCOUNT-NO TO AT-ACCOUNT-NO                      
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT
           END-IF.              
           IF WS-CUSTOMER-NO > 0                                        
               MOVE WS-CUSTOMER-NO TO CU-CUSTOMER-NO                    
               PERFORM 7020-SELECT-CUSTOMER THRU 7020-EXIT
           END-IF.             
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-ALLIANCE THRU 3000-EXIT          
               WHEN 'U'                                                 
                   PERFORM 3100-UPDATE-ALLIANCE THRU 3100-EXIT          
               WHEN 'D'                                                 
                   PERFORM 3200-DELETE-ALLIANCE THRU 3200-EXIT          
               WHEN 'V'                                                 
                   PERFORM 3300-VALIDATE-ALLIANCE THRU 3300-EXIT        
               WHEN OTHER                                               
                   PERFORM 3400-INVALID-ACTION THRU 3400-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-ALLIANCE.                                            
                                                                        
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   PERFORM 3010-ROOMMATE-INSERT-PROCESS THRU 3010-EXIT  
               WHEN 'CO'                                                
                   PERFORM 3020-COAPP-INSERT-PROCESS THRU 3020-EXIT     
           END-EVALUATE.                                                
                                                                        
      * PERFORM UPDATE ROUTINE TO PROCESS ANY CHANGES TO CUSTOMER DATA          
                                                                        
           PERFORM 3100-UPDATE-ALLIANCE THRU 3100-EXIT.                 
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-ROOMMATE-INSERT-PROCESS.                                    
                                                                        
           IF WS-ACCOUNT-NO > 0                                         
               MOVE WS-ACCOUNT-NO TO RO-ACCOUNT-NO                      
               MOVE WS-CUSTOMER-NO TO RO-CUSTOMER-NO                    
               MOVE LINK-ACCESS-LEVEL-CD TO RO-ACCESS-LEVEL-CD          
               PERFORM 8070-INSERT-ROOMMATE THRU 8070-EXIT              
               MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO                      
               MOVE AT-COMPANY-NO TO HT-COMPANY-NO                      
               MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO                    
               MOVE AT-PREMISE-NO TO HT-PREMISE-NO                      
               MOVE AT-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE        
               MOVE AT-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT              
               MOVE CU-NAME-ID TO HT-NAME-ID                            
               MOVE 'A' TO HT-CUSTOMER-ROLE-CD                          
               PERFORM 7010-SELECT-ADDRESS THRU 7010-EXIT               
               PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT             
           ELSE                                                         
               IF WS-ASSOC-CUSTOMER-NO > 0                              
                   MOVE WS-ASSOC-CUSTOMER-NO TO EK-ASSOC-CUSTOMER-NO    
                   MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO                
                   MOVE 'RO' TO EK-RELATION-TYPE-CD                     
                   MOVE LINK-ACCESS-LEVEL-CD TO EK-ACCESS-LEVEL-CD      
                   PERFORM 8080-INSERT-CUST-XFER THRU 8080-EXIT
               END-IF
           END-IF.        
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3020-COAPP-INSERT-PROCESS.                                       
                                                                        
           IF WS-ACCOUNT-NO > 0                                         
               MOVE WS-ACCOUNT-NO TO IC-ACCOUNT-NO                      
               MOVE WS-CUSTOMER-NO TO IC-CUSTOMER-NO                    
               MOVE LINK-ACCESS-LEVEL-CD TO IC-ACCESS-LEVEL-CD          
               MOVE WS-CURRENT-DATE TO IC-CREATED-DATE                  
               PERFORM 8060-INSERT-COAPP THRU 8060-EXIT                 
               MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO                      
               MOVE AT-COMPANY-NO TO HT-COMPANY-NO                      
               MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO                    
               MOVE AT-PREMISE-NO TO HT-PREMISE-NO                      
               MOVE AT-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE        
               MOVE AT-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT              
               MOVE CU-NAME-ID TO HT-NAME-ID                            
               MOVE 'B' TO HT-CUSTOMER-ROLE-CD                          
               PERFORM 7010-SELECT-ADDRESS THRU 7010-EXIT               
               PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT             
           ELSE                                                         
               IF WS-ASSOC-CUSTOMER-NO > 0                              
                   MOVE WS-ASSOC-CUSTOMER-NO TO EK-ASSOC-CUSTOMER-NO    
                   MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO                
                   MOVE 'CO' TO EK-RELATION-TYPE-CD                     
                   MOVE LINK-ACCESS-LEVEL-CD TO EK-ACCESS-LEVEL-CD      
                   PERFORM 8080-INSERT-CUST-XFER THRU 8080-EXIT
               END-IF
           END-IF.        
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO CU-VALIDATION-TS.               
           MOVE WS-CUSTOMER-NO TO CU-CUSTOMER-NO.                       
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-ALLIANCE.                                            
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   IF WS-ACCOUNT-NO > 0                                 
                       MOVE WS-ACCOUNT-NO TO RO-ACCOUNT-NO              
                       MOVE WS-CUSTOMER-NO TO RO-CUSTOMER-NO            
                       PERFORM 7090-SELECT-ROOMMATE THRU 7090-EXIT      
                       MOVE RO-ACCESS-LEVEL-CD TO WS-ACCESS-LEVEL-CD    
                   ELSE                                                 
                       IF WS-ASSOC-CUSTOMER-NO > 0                      
                           MOVE WS-ASSOC-CUSTOMER-NO TO                 
                                EK-ASSOC-CUSTOMER-NO                    
                           MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO        
                           MOVE 'RO' TO EK-RELATION-TYPE-CD             
                           PERFORM 7110-SELECT-CUST-XFER THRU 7110-EXIT 
                           MOVE EK-ACCESS-LEVEL-CD TO WS-ACCESS-LEVEL-CD
                       END-IF                                           
                   END-IF                                               
               WHEN 'CO'                                                
                   IF WS-ACCOUNT-NO > 0                                 
                       MOVE WS-ACCOUNT-NO TO IC-ACCOUNT-NO              
                       MOVE WS-CUSTOMER-NO TO IC-CUSTOMER-NO            
                       PERFORM 7100-SELECT-COAPPLICANT THRU 7100-EXIT   
                       MOVE IC-ACCESS-LEVEL-CD TO WS-ACCESS-LEVEL-CD    
                   ELSE                                                 
                       IF WS-ASSOC-CUSTOMER-NO > 0                      
                           MOVE WS-ASSOC-CUSTOMER-NO TO                 
                                EK-ASSOC-CUSTOMER-NO                    
                           MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO        
                           MOVE 'CO' TO EK-RELATION-TYPE-CD             
                           PERFORM 7110-SELECT-CUST-XFER THRU 7110-EXIT 
                           MOVE EK-ACCESS-LEVEL-CD TO WS-ACCESS-LEVEL-CD
                       END-IF                                           
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT.            
           PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT.            
                                                                        
           IF CSTS-CHANGED                                              
               MOVE 'C' TO CE-CUSTOMER-TYPE                             
               MOVE LINK-SSN TO CE-SSN                                  
               MOVE LINK-DLN-STATE TO CE-CODE-STATE-ID                  
               MOVE LINK-DLN TO CE-DRIVERS-LICENSE-NO                   
               MOVE LINK-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE              
               MOVE LINK-OTHER-ID TO CE-OTHER-ID                        
               MOVE LINK-DATE-OF-BIRTH TO CE-DATE-OF-BIRTH              
               MOVE LINK-REFUSED-SSN TO CE-REFUSED-SSN-FL               
               MOVE LINK-ITIN TO CE-ITIN-ID                             
               MOVE LINK-ALLOW-CALL-FL TO CE-ALLOW-CALL-FL              
               MOVE LINK-ALLOW-EMAIL-FL TO CE-ALLOW-EMAIL-FL            
               MOVE LINK-EMPLOYER TO CE-EMPLOYER                        
               IF CSTS-EXISTS                                           
                   PERFORM 8340-UPDATE-CSTS THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-CSTS THRU 8190-EXIT         
               ELSE                                                     
                   MOVE CU-NAME-ID TO CE-NAME-ID                        
                   PERFORM 8050-INSERT-CUST-STATS THRU 8050-EXIT
               END-IF
           END-IF.       
                                                                        
           IF NAME-CHANGED                                              
               MOVE LINK-FIRST-NAME TO DQ-FIRST-NAME                    
               MOVE LINK-MIDDLE-NAME TO DQ-MIDDLE-NAME                  
               MOVE LINK-LAST-NAME TO DQ-LAST-NAME                      
               MOVE LINK-TITLE TO DQ-TITLE-PREFIX                       
               MOVE LINK-SUFFIX TO DQ-TITLE-SUFFIX-1                    
               PERFORM 8370-UPDATE-NAME THRU 8370-EXIT
           END-IF.                 
                                                                        
           IF HMPH-CHANGED                                              
              MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'H1' TO CB-PHONE-TYPE                                
              MOVE LINK-HOME-PHONE-NO TO CB-PHONE-NO                    
              MOVE SPACES TO CB-EXTENSION-NO                            
              MOVE LINK-HOME-MOBILE-FL TO CB-MOBILE-PHONE-FL            
              MOVE LINK-HOME-MKT-FL TO CB-PERMISN-TO-MKT-FL             
              IF HPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF HMPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF WKPH-CHANGED                                              
              MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'W1' TO CB-PHONE-TYPE                                
              MOVE LINK-WORK-PHONE-NO TO CB-PHONE-NO                    
              MOVE LINK-WORK-PHONE-EXT TO CB-EXTENSION-NO               
              MOVE LINK-WORK-MOBILE-FL TO CB-MOBILE-PHONE-FL            
              MOVE LINK-WORK-MKT-FL TO CB-PERMISN-TO-MKT-FL             
              IF WPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF WKPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF ALPH-CHANGED                                              
              MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'A1' TO CB-PHONE-TYPE                                
              MOVE LINK-ALT-PHONE-NO TO CB-PHONE-NO                     
              MOVE SPACES TO CB-EXTENSION-NO                            
              MOVE LINK-ALT-MOBILE-FL TO CB-MOBILE-PHONE-FL             
              MOVE LINK-ALT-MKT-FL TO CB-PERMISN-TO-MKT-FL              
              IF APFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF ALPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF ACCS-CHANGED                                              
               EVALUATE LINK-ALLIANCE-TYPE-CD                           
                   WHEN 'RO'                                            
                       IF WS-ACCOUNT-NO > 0                             
                           MOVE WS-ACCOUNT-NO TO RO-ACCOUNT-NO          
                           MOVE WS-CUSTOMER-NO TO RO-CUSTOMER-NO        
                           MOVE LINK-ACCESS-LEVEL-CD TO                 
                                RO-ACCESS-LEVEL-CD                      
                           PERFORM 8110-UPDATE-ROOMMATE THRU 8110-EXIT  
                       ELSE                                             
                           IF WS-ASSOC-CUSTOMER-NO > 0                  
                               MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO    
                               MOVE WS-ASSOC-CUSTOMER-NO TO             
                                    EK-ASSOC-CUSTOMER-NO                
                               MOVE LINK-ACCESS-LEVEL-CD TO             
                                   EK-ACCESS-LEVEL-CD                   
                               PERFORM 8120-UPDATE-CUST-XFER THRU       
                                       8120-EXIT                        
                           END-IF                                       
                       END-IF                                           
                   WHEN 'CO'                                            
                       IF WS-ACCOUNT-NO > 0                             
                           MOVE WS-ACCOUNT-NO TO IC-ACCOUNT-NO          
                           MOVE WS-CUSTOMER-NO TO IC-CUSTOMER-NO        
                           MOVE LINK-ACCESS-LEVEL-CD TO                 
                                IC-ACCESS-LEVEL-CD                      
                           PERFORM 8090-UPDATE-COAPPLICANT THRU         
                                   8090-EXIT                            
                       ELSE                                             
                           IF WS-ASSOC-CUSTOMER-NO > 0                  
                               MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO    
                               MOVE WS-ASSOC-CUSTOMER-NO TO             
                                    EK-ASSOC-CUSTOMER-NO                
                               MOVE LINK-ACCESS-LEVEL-CD TO             
                                   EK-ACCESS-LEVEL-CD                   
                               PERFORM 8120-UPDATE-CUST-XFER THRU       
                                       8120-EXIT                        
                           END-IF                                       
                       END-IF                                           
               END-EVALUATE
           END-IF.                                            
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO CU-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-DELETE-ALLIANCE.                                            
                                                                        
           PERFORM 5200-TRANSHIST-FOR-DELETE THRU 5200-EXIT.            
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   PERFORM 3210-ROOMMATE-DELETE-PROCESS THRU 3210-EXIT  
               WHEN 'CO'                                                
                   PERFORM 3220-COAPP-DELETE-PROCESS THRU 3220-EXIT     
           END-EVALUATE.                                                
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3210-ROOMMATE-DELETE-PROCESS.                                    
                                                                        
           IF WS-ACCOUNT-NO > 0                                         
               MOVE WS-ACCOUNT-NO TO RO-ACCOUNT-NO                      
               MOVE WS-CUSTOMER-NO TO RO-CUSTOMER-NO                    
               PERFORM 8000-DELETE-ROOMMATE THRU 8000-EXIT              
               MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO                      
               MOVE AT-COMPANY-NO TO HT-COMPANY-NO                      
               MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO                    
               MOVE AT-PREMISE-NO TO HT-PREMISE-NO                      
               MOVE CU-NAME-ID TO HT-NAME-ID                            
               MOVE ZEROES TO HT-CONTACT-ID                             
               MOVE 'A' TO HT-CUSTOMER-ROLE-CD                          
               PERFORM 8150-DELETE-HT THRU 8150-EXIT                    
           ELSE                                                         
               IF WS-ASSOC-CUSTOMER-NO > 0                              
                   MOVE WS-ASSOC-CUSTOMER-NO TO EK-ASSOC-CUSTOMER-NO    
                   MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO                
                   MOVE 'RO' TO EK-RELATION-TYPE-CD                     
                   PERFORM 8010-DELETE-CUST-XFER THRU 8010-EXIT
               END-IF
           END-IF.        
                                                                        
       3210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3220-COAPP-DELETE-PROCESS.                                       
                                                                        
           IF WS-ACCOUNT-NO > 0                                         
               MOVE WS-ACCOUNT-NO TO IC-ACCOUNT-NO                      
               MOVE WS-CUSTOMER-NO TO IC-CUSTOMER-NO                    
               PERFORM 8040-DELETE-COAPP THRU 8040-EXIT                 
               MOVE AT-ACCOUNT-NO TO HT-ACCOUNT-NO                      
               MOVE AT-COMPANY-NO TO HT-COMPANY-NO                      
               MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO                    
               MOVE AT-PREMISE-NO TO HT-PREMISE-NO                      
               MOVE CU-NAME-ID TO HT-NAME-ID                            
               MOVE ZEROES TO HT-CONTACT-ID                             
               MOVE 'B' TO HT-CUSTOMER-ROLE-CD                          
               PERFORM 8150-DELETE-HT THRU 8150-EXIT                    
           ELSE                                                         
               IF WS-ASSOC-CUSTOMER-NO > 0                              
                   MOVE WS-ASSOC-CUSTOMER-NO TO EK-ASSOC-CUSTOMER-NO    
                   MOVE WS-CUSTOMER-NO TO EK-CUSTOMER-NO                
                   MOVE 'CO' TO EK-RELATION-TYPE-CD                     
                   PERFORM 8010-DELETE-CUST-XFER THRU 8010-EXIT
               END-IF
           END-IF.        
                                                                        
       3220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-VALIDATE-ALLIANCE.                                          
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO CU-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +20                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*CONFIRMED*'         TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE LINK-CUSTOMER-NO      TO MI-PRV-COLUMN-VALUE-TEXT.      
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   MOVE 'ROOMMATE INFO' TO MI-COLUMN-DESC               
               WHEN 'CO'                                                
                   MOVE 'COAPP INFO' TO MI-COLUMN-DESC                  
           END-EVALUATE.                                                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3400-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           MOVE 0 TO S-RETURN-CODE.                                     
           MOVE +2 TO S-STATUS-CODE.                                    
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   MOVE 'ROOMT CUST NO' TO MI-COLUMN-DESC               
               WHEN 'CO'                                                
                   MOVE 'COAPP CUST NO' TO MI-COLUMN-DESC               
           END-EVALUATE.                                                
           MOVE 10                 TO MI-CHG-COLUMN-VALUE-LEN.          
           MOVE LINK-CUSTOMER-NO   TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE 5                  TO MI-PRV-COLUMN-VALUE-LEN.          
           MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT.         
           MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   MOVE 'ROOMT FNAME' TO MI-COLUMN-DESC                 
               WHEN 'CO'                                                
                   MOVE 'COAPP FNAME' TO MI-COLUMN-DESC                 
           END-EVALUATE.                                                
           MOVE 15                 TO MI-CHG-COLUMN-VALUE-LEN.          
           MOVE LINK-FIRST-NAME    TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE 5                  TO MI-PRV-COLUMN-VALUE-LEN.          
           MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT.         
           MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
           IF LINK-MIDDLE-NAME > ' '                                    
               EVALUATE LINK-ALLIANCE-TYPE-CD                           
                   WHEN 'RO'                                            
                       MOVE 'ROOMT MNAME' TO MI-COLUMN-DESC             
                   WHEN 'CO'                                            
                       MOVE 'COAPP MNAME' TO MI-COLUMN-DESC             
               END-EVALUATE                                             
               MOVE 15               TO MI-CHG-COLUMN-VALUE-LEN         
               MOVE LINK-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT        
               MOVE 5                TO MI-PRV-COLUMN-VALUE-LEN         
               MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT        
               MOVE WS-TRAN-APPL-NO  TO MI-TRAN-APPL-NO                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD +1                TO WS-TRAN-APPL-NO
           END-IF.                
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   MOVE 'ROOMT LNAME' TO MI-COLUMN-DESC                 
               WHEN 'CO'                                                
                   MOVE 'COAPP LNAME' TO MI-COLUMN-DESC                 
           END-EVALUATE.                                                
           MOVE 40                 TO MI-CHG-COLUMN-VALUE-LEN.          
           MOVE LINK-LAST-NAME     TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE 5                  TO MI-PRV-COLUMN-VALUE-LEN.          
           MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT.         
           MOVE WS-TRAN-APPL-NO  TO MI-TRAN-APPL-NO.                    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF DQ-TITLE-PREFIX NOT = LINK-TITLE                          
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TITLE > SPACES                                    
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TITLE         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-PREFIX > SPACES                               
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-PREFIX    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-FIRST-NAME                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FIRST-NAME > SPACES                               
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-FIRST-NAME > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FIRST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-MIDDLE-NAME NOT = LINK-MIDDLE-NAME                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-MIDDLE-NAME > SPACES                              
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT      
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-MIDDLE-NAME > SPACES                                
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-MIDDLE-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-LAST-NAME NOT = LINK-LAST-NAME                         
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-LAST-NAME > SPACES                                
                 MOVE +40                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-LAST-NAME > SPACES                                  
                 MOVE +40                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-LAST-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-SUFFIX-1 NOT = LINK-SUFFIX                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SUFFIX > SPACES                                   
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SUFFIX        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-SUFFIX-1 > SPACES                             
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-SUFFIX-1  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-SSN NOT = LINK-SSN                                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SSN > SPACES                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SSN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-SSN > SPACES                                        
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-SSN             TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SSN'                 TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ITIN-ID NOT = LINK-ITIN                                
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ITIN > SPACES                                     
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ITIN          TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-ITIN-ID > SPACES                                    
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-ITIN-ID         TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ITIN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-REFUSED-SSN-FL = LOW-VALUES                            
              MOVE SPACES TO CE-REFUSED-SSN-FL
           END-IF.                         
           IF CE-REFUSED-SSN-FL = SPACES OR 'N'                         
               MOVE ' ' TO CE-REFUSED-SSN-FL
           END-IF.                           
           IF LINK-REFUSED-SSN = SPACES OR 'N'                          
               MOVE ' ' TO LINK-REFUSED-SSN
           END-IF.                            
                                                                        
           IF CE-REFUSED-SSN-FL NOT = LINK-REFUSED-SSN                  
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-REFUSED-SSN > SPACES                              
                 MOVE +1                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-REFUSED-SSN                                  
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-REFUSED-SSN-FL > SPACES                             
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE CE-REFUSED-SSN-FL   TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'REFUSED SSN'     TO MI-COLUMN-DESC                  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DRIVERS-LICENSE-NO NOT = LINK-DLN                      
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN > SPACES                                      
                 MOVE +19                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-DRIVERS-LICENSE-NO > SPACES                         
                 MOVE +19                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DRIVERS-LICENSE-NO TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LICENSE NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-CODE-STATE-ID NOT = LINK-DLN-STATE                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN-STATE > SPACES                                
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN-STATE     TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-CODE-STATE-ID > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-CODE-STATE-ID   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CODE STATE ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DATE-OF-BIRTH NOT = LINK-DATE-OF-BIRTH                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DATE-OF-BIRTH > SPACES                            
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DATE-OF-BIRTH TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-DATE-OF-BIRTH    > SPACES                           
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DATE-OF-BIRTH   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID-TYPE NOT = LINK-OTHER-ID-TYPE                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID-TYPE > SPACES                            
                 MOVE +12                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID-TYPE TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-OTHER-ID-TYPE > SPACES                              
                 MOVE +12                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OTHER-ID-TYPE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID TYPE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID NOT = LINK-OTHER-ID                           
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID > SPACES                                 
                 MOVE +16                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID  TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-OTHER-ID > SPACES                                   
                 MOVE +16                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OTHER-ID        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ALLOW-CALL-FL = SPACES OR 'Y'                          
               MOVE ' ' TO CE-ALLOW-CALL-FL
           END-IF.                            
           IF LINK-ALLOW-CALL-FL = SPACES OR 'Y'                        
               MOVE ' ' TO LINK-ALLOW-CALL-FL
           END-IF.                          
                                                                        
           IF CE-ALLOW-CALL-FL NOT = LINK-ALLOW-CALL-FL                 
              MOVE 'YES'                     TO WS-CSTS-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALLOW-CALL-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALLOW-CALL-FL     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF CE-ALLOW-CALL-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE CE-ALLOW-CALL-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALLOW CALL'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ALLOW-EMAIL-FL = SPACES OR 'Y'                         
               MOVE ' ' TO CE-ALLOW-EMAIL-FL
           END-IF.                           
           IF LINK-ALLOW-EMAIL-FL = SPACES OR 'Y'                       
               MOVE ' ' TO LINK-ALLOW-EMAIL-FL
           END-IF.                         
                                                                        
           IF CE-ALLOW-EMAIL-FL NOT = LINK-ALLOW-EMAIL-FL               
              MOVE 'YES'                     TO WS-CSTS-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALLOW-EMAIL-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALLOW-EMAIL-FL    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF CE-ALLOW-EMAIL-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE CE-ALLOW-EMAIL-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALLOW EMAIL'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-PHONE-NO NOT = LINK-WORK-PHONE-NO                 
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-WORK-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-WORK-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-WORK-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-WORK-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'WORK PHONE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-EXTENSION-NO NOT = LINK-WORK-PHONE-EXT            
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-PHONE-EXT > SPACES                           
                 MOVE +6                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-PHONE-EXT    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-EXTENSION-NO > SPACES                          
                 MOVE +6                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-EXTENSION-NO   TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK PHONE EXT'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MOBILE-FL NOT = LINK-WORK-MOBILE-FL               
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MOBILE'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MKT-FL NOT = LINK-WORK-MKT-FL                     
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
                                                WS-WPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MARKET'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-WORK-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-WORK-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-WORK-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'WORK MKT DT'         TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-HOME-PHONE-NO NOT = LINK-HOME-PHONE-NO                 
              MOVE 'YES'                   TO WS-HMPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-HOME-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-HOME-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-HOME-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-HOME-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'PRIMARY PHONE'         TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MOBILE-FL NOT = LINK-HOME-MOBILE-FL               
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MOBILE'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MKT-FL NOT = LINK-HOME-MKT-FL                     
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
                                                WS-HPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MARKET'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-HOME-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-HOME-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-HOME-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'PRIMARY MKT DT'      TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ALT-PHONE-NO NOT = LINK-ALT-PHONE-NO                   
              MOVE 'YES'                  TO WS-ALPH-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-ALT-PHONE-NO > SPACES                             
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-ALT-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF WS-ALT-PHONE-NO > SPACES                               
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE WS-ALT-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'ALT PHONE'            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MOBILE-FL NOT = LINK-ALT-MOBILE-FL                 
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MOBILE-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MOBILE-FL TO     MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MOBILE-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MOBILE-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MOBILE'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MKT-FL NOT = LINK-ALT-MKT-FL                       
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
                                                WS-APFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MKT-FL > SPACES                               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MKT-FL TO        MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MKT-FL > SPACES                                 
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MKT-FL          TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MARKET'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-ALT-MKT-FL > ' '                                  
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-ALT-MKT-DT > SPACES                             
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-ALT-MKT-DT    TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'ALT MKT DT'          TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CE-EMPLOYER NOT = LINK-EMPLOYER                           
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EMPLOYER  > SPACES                                
                 MOVE +23                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-EMPLOYER  TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-EMPLOYER   > SPACES                                 
                 MOVE +23                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-EMPLOYER        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'EMPLOYER       '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ACCESS-LEVEL-CD NOT = LINK-ACCESS-LEVEL-CD             
              MOVE 'YES'                 TO WS-ACCS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ACCESS-LEVEL-CD > SPACES                          
                 MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-ACCESS-LEVEL-CD  TO 3I-ACCESS-LEVEL-CD       
                 PERFORM 7005-CONTACT-ACCESS THRU 7005-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC  TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF WS-ACCESS-LEVEL-CD > SPACES                            
                 MOVE +15                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-ACCESS-LEVEL-CD    TO 3I-ACCESS-LEVEL-CD       
                 PERFORM 7005-CONTACT-ACCESS THRU 7005-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC  TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              EVALUATE LINK-ALLIANCE-TYPE-CD                            
                  WHEN 'RO'                                             
                      MOVE 'ROOMMATE ACCESS' TO MI-COLUMN-DESC          
                  WHEN 'CO'                                             
                      MOVE 'COAPP ACCESS' TO MI-COLUMN-DESC             
              END-EVALUATE                                              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-TRANSHIST-FOR-DELETE.                                       
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   MOVE 'ROOMT CUST NO' TO MI-COLUMN-DESC               
               WHEN 'CO'                                                
                   MOVE 'COAPP CUST NO' TO MI-COLUMN-DESC               
           END-EVALUATE.                                                
           MOVE 10                 TO MI-PRV-COLUMN-VALUE-LEN.          
           MOVE LINK-CUSTOMER-NO   TO MI-PRV-COLUMN-VALUE-TEXT.         
           MOVE 9                  TO MI-CHG-COLUMN-VALUE-LEN.          
           MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   MOVE 'ROOMT FNAME' TO MI-COLUMN-DESC                 
               WHEN 'CO'                                                
                   MOVE 'COAPP FNAME' TO MI-COLUMN-DESC                 
           END-EVALUATE.                                                
           MOVE 15                 TO MI-PRV-COLUMN-VALUE-LEN.          
           MOVE LINK-FIRST-NAME    TO MI-PRV-COLUMN-VALUE-TEXT.         
           MOVE 9                  TO MI-CHG-COLUMN-VALUE-LEN.          
           MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
           IF LINK-MIDDLE-NAME > ' '                                    
               EVALUATE LINK-ALLIANCE-TYPE-CD                           
                   WHEN 'RO'                                            
                       MOVE 'ROOMT MNAME' TO MI-COLUMN-DESC             
                   WHEN 'CO'                                            
                       MOVE 'COAPP MNAME' TO MI-COLUMN-DESC             
               END-EVALUATE                                             
               MOVE 15               TO MI-PRV-COLUMN-VALUE-LEN         
               MOVE LINK-MIDDLE-NAME TO MI-PRV-COLUMN-VALUE-TEXT        
               MOVE 9                TO MI-CHG-COLUMN-VALUE-LEN         
               MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT        
               MOVE WS-TRAN-APPL-NO  TO MI-TRAN-APPL-NO                 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD +1                TO WS-TRAN-APPL-NO
           END-IF.                
                                                                        
           EVALUATE LINK-ALLIANCE-TYPE-CD                               
               WHEN 'RO'                                                
                   MOVE 'ROOMT LNAME' TO MI-COLUMN-DESC                 
               WHEN 'CO'                                                
                   MOVE 'COAPP LNAME' TO MI-COLUMN-DESC                 
           END-EVALUATE.                                                
           MOVE 40                 TO MI-PRV-COLUMN-VALUE-LEN.          
           MOVE LINK-LAST-NAME     TO MI-PRV-COLUMN-VALUE-TEXT.         
           MOVE 9                  TO MI-CHG-COLUMN-VALUE-LEN.          
           MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT.         
           MOVE WS-TRAN-APPL-NO  TO MI-TRAN-APPL-NO.                    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD +1                  TO WS-TRAN-APPL-NO.                  
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-GET-BASELINE-DETAILS.                                       
                                                                        
           PERFORM 7030-SELECT-CUST-STATS THRU 7030-EXIT.               
                                                                        
           MOVE CU-NAME-ID TO DQ-NAME-ID.                               
           PERFORM 7070-SELECT-NAME THRU 7070-EXIT.                     
                                                                        
           MOVE 'H1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-HOME-PHONE-NO            
              MOVE CB-MOBILE-PHONE-FL    TO WS-HOME-MOBILE-FL           
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-HOME-MKT-FL              
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-HOME-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-HOME-PHONE-NO            
                                            WS-HOME-MOBILE-FL           
                                            WS-HOME-MKT-FL              
                                            WS-HOME-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO' TO WS-PHONE-EXISTS-FLAG.                           
           MOVE 'W1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-WORK-PHONE-NO            
              MOVE CB-EXTENSION-NO       TO WS-WORK-EXTENSION-NO        
              MOVE CB-MOBILE-PHONE-FL    TO WS-WORK-MOBILE-FL           
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-WORK-MKT-FL              
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-WORK-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-WORK-PHONE-NO            
                                            WS-WORK-EXTENSION-NO        
                                            WS-WORK-MOBILE-FL           
                                            WS-WORK-MKT-FL              
                                            WS-WORK-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO'                     TO WS-PHONE-EXISTS-FLAG.       
           MOVE 'A1'                     TO WS-PHONE-TYPE.              
           PERFORM 7050-SELECT-PHONE          THRU 7050-EXIT.           
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-ALT-PHONE-NO             
              MOVE CB-MOBILE-PHONE-FL    TO WS-ALT-MOBILE-FL            
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-ALT-MKT-FL               
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-ALT-MKT-DT               
           ELSE                                                         
              MOVE SPACES                TO WS-ALT-PHONE-NO             
                                            WS-ALT-MOBILE-FL            
                                            WS-ALT-MKT-FL               
                                            WS-ALT-MKT-DT
           END-IF.              
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      COMPANY_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      ACCOUNT_TYPE_CODE,                                
                      CODE_ACCT_STAT                                    
                 INTO :AT-ADDRESS-ID,                                   
                      :AT-COMPANY-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-PREMISE-NO,                                   
                      :AT-ACCOUNT-TYPE-CODE,                            
                      :AT-CODE-ACCT-STAT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               CODE_ACCT_STAT                                            
MFA-TR*          INTO :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-CODE-ACCT-STAT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-CONTACT-ACCESS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ACCESS_LEVEL_DESC                                  
                INTO :3I-ACCESS-LEVEL-DESC                              
                FROM CSS_CONTACT_ACCESS WITH(READUNCOMMITTED)                   
               WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD              
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_DESC                                          
MFA-TR*         INTO :3I-ACCESS-LEVEL-DESC                                      
MFA-TR*         FROM CSS_CONTACT_ACCESS                                         
MFA-TR*        WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD                      
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 3I-ACCESS-LEVEL-CD TO 3I-ACCESS-LEVEL-DESC      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCESS' TO TABLE-1                 
                   MOVE 3I-ACCESS-LEVEL-CD TO TABLE-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT ADDRESS_ID,                              
                      TOWN,                                             
                      STATE,                                            
                      LOCAL_OFFICE                                      
                 INTO :HT-ADDRESS-ID,                                   
                      :HT-TOWN,                                         
                      :HT-STATE,                                        
                      :HT-LOCAL-OFFICE                                  
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.ACCOUNT_NO  = :HT-ACCOUNT-NO                   
                  AND HT.NAME_ID  = DQ.NAME_ID                          
                  AND DQ.NAME_TYPE = 'CN'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT ADDRESS_ID,                                      
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE,                                                    
MFA-TR*               LOCAL_OFFICE                                              
MFA-TR*          INTO :HT-ADDRESS-ID,                                           
MFA-TR*               :HT-TOWN,                                                 
MFA-TR*               :HT-STATE,                                                
MFA-TR*               :HT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.ACCOUNT_NO  = :HT-ACCOUNT-NO                           
MFA-TR*           AND HT.NAME_ID  = DQ.NAME_ID                                  
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7015'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT NAME_ID                                            
                INTO :CU-NAME-ID                                        
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :CU-NAME-ID                                                
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     SSN,                                               
                     NAME_ID,                                           
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DATE_OF_BIRTH,                                     
                     REFUSED_SSN_FL,                                    
                     ALLOW_CALL_FL,                                     
                     ALLOW_EMAIL_FL,                                    
                     ITIN_ID                                            
                INTO :WS-CSTS-EXISTS-FLAG,                              
                     :CE-SSN,                                           
                     :CE-NAME-ID,                                       
                     :CE-CODE-STATE-ID,                                 
                     :CE-DRIVERS-LICENSE-NO,                            
                     :CE-EMPLOYER,                                      
                     :CE-OTHER-ID-TYPE,                                 
                     :CE-OTHER-ID,                                      
                     :CE-DATE-OF-BIRTH :WS-NULL-3,                       
                     :CE-REFUSED-SSN-FL,                                
                     :CE-ALLOW-CALL-FL,                                 
                     :CE-ALLOW-EMAIL-FL,                                
                     :CE-ITIN-ID                                        
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                   
                 AND CUSTOMER_TYPE  = 'C'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              REFUSED_SSN_FL,                                            
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              ITIN_ID                                                    
MFA-TR*         INTO :WS-CSTS-EXISTS-FLAG,                                      
MFA-TR*              :CE-SSN,                                                   
MFA-TR*              :CE-NAME-ID,                                               
MFA-TR*              :CE-CODE-STATE-ID,                                         
MFA-TR*              :CE-DRIVERS-LICENSE-NO,                                    
MFA-TR*              :CE-EMPLOYER,                                              
MFA-TR*              :CE-OTHER-ID-TYPE,                                         
MFA-TR*              :CE-OTHER-ID,                                              
MFA-TR*              :CE-DATE-OF-BIRTH:WS-NULL-3,                               
MFA-TR*              :CE-REFUSED-SSN-FL,                                        
MFA-TR*              :CE-ALLOW-CALL-FL,                                         
MFA-TR*              :CE-ALLOW-EMAIL-FL,                                        
MFA-TR*              :CE-ITIN-ID                                                
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                           
MFA-TR*          AND CUSTOMER_TYPE  = 'C'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-CUST-STATS                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE 'C'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT                                  
                INTO :WS-PHONE-EXISTS-FLAG,                             
                     :CB-PHONE-TYPE,                                    
                     :CB-PHONE-NO,                                      
                     :CB-EXTENSION-NO,                                  
                     :CB-MOBILE-PHONE-FL,                               
                     :CB-PERMISN-TO-MKT-FL,                             
                     :CB-PERMISN-TO-MKT-DT :WS-NULL-2                    
                FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO   = :CU-CUSTOMER-NO                    
                 AND PHONE_TYPE    = :WS-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = 'C'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT                                          
MFA-TR*         INTO :WS-PHONE-EXISTS-FLAG,                                     
MFA-TR*              :CB-PHONE-TYPE,                                            
MFA-TR*              :CB-PHONE-NO,                                              
MFA-TR*              :CB-EXTENSION-NO,                                          
MFA-TR*              :CB-MOBILE-PHONE-FL,                                       
MFA-TR*              :CB-PERMISN-TO-MKT-FL,                                     
MFA-TR*              :CB-PERMISN-TO-MKT-DT:WS-NULL-2                            
MFA-TR*         FROM CSS_CUST_PHONE                                             
MFA-TR*        WHERE CUSTOMER_NO   = :CU-CUSTOMER-NO                            
MFA-TR*          AND PHONE_TYPE    = :WS-PHONE-TYPE                             
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'PHONE_TYPE'     TO TABLE-ELEMENT-2             
                   MOVE WS-PHONE-TYPE    TO HOSTVAR-ELEMENT-2           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-3             
                   MOVE 'C'              TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1                                     
                INTO :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1                                 
                FROM CSS_NAME WITH(READUNCOMMITTED)                             
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1                                             
MFA-TR*         INTO :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1                                         
MFA-TR*         FROM CSS_NAME                                                   
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-1           
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-SELECT-ROOMMATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT ACCESS_LEVEL_CD                                    
                INTO :RO-ACCESS-LEVEL-CD                                
                FROM CSS_ROOMMATE WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :RO-CUSTOMER-NO                      
                 AND ACCOUNT_NO = :RO-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_CD                                            
MFA-TR*         INTO :RO-ACCESS-LEVEL-CD                                        
MFA-TR*         FROM CSS_ROOMMATE                                               
MFA-TR*        WHERE CUSTOMER_NO = :RO-CUSTOMER-NO                              
MFA-TR*          AND ACCOUNT_NO = :RO-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7090'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ROOMMATE'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE RO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE RO-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-COAPPLICANT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT ACCESS_LEVEL_CD                                    
                INTO :IC-ACCESS-LEVEL-CD                                
                FROM CSS_COAPPLICANT WITH(READUNCOMMITTED)                      
               WHERE CUSTOMER_NO = :IC-CUSTOMER-NO                      
                 AND ACCOUNT_NO = :IC-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_CD                                            
MFA-TR*         INTO :IC-ACCESS-LEVEL-CD                                        
MFA-TR*         FROM CSS_COAPPLICANT                                            
MFA-TR*        WHERE CUSTOMER_NO = :IC-CUSTOMER-NO                              
MFA-TR*          AND ACCOUNT_NO = :IC-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_COAPPLICANT'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE IC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE IC-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-CUST-XFER.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ACCESS_LEVEL_CD                                    
                INTO :EK-ACCESS-LEVEL-CD                                
                FROM CSS_CUSTOMER_XFER WITH(READUNCOMMITTED)                    
               WHERE CUSTOMER_NO = :EK-CUSTOMER-NO                      
                 AND ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_CD                                            
MFA-TR*         INTO :EK-ACCESS-LEVEL-CD                                        
MFA-TR*         FROM CSS_CUSTOMER_XFER                                          
MFA-TR*        WHERE CUSTOMER_NO = :EK-CUSTOMER-NO                              
MFA-TR*          AND ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER_XFER'   TO TABLE-1                     
              MOVE 'ASSOC_CUSTOMER_NO'   TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE EK-ASSOC-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1           
              MOVE EK-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-DELETE-ROOMMATE.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ROOMMATE                                  
               WHERE ACCOUNT_NO  = :RO-ACCOUNT-NO                       
                 AND CUSTOMER_NO = :RO-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_ROOMMATE                                          
MFA-TR*        WHERE ACCOUNT_NO  = :RO-ACCOUNT-NO                               
MFA-TR*          AND CUSTOMER_NO = :RO-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ROOMMATE'       TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE RO-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE RO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-DELETE-CUST-XFER.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUSTOMER_XFER                             
               WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO          
                 AND CUSTOMER_NO = :EK-CUSTOMER-NO                      
                 AND RELATION_TYPE_CD = :EK-RELATION-TYPE-CD            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUSTOMER_XFER                                     
MFA-TR*        WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO                  
MFA-TR*          AND CUSTOMER_NO = :EK-CUSTOMER-NO                              
MFA-TR*          AND RELATION_TYPE_CD = :EK-RELATION-TYPE-CD                    
MFA-TR*       QUERYNO 8010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER_XFER'  TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE EK-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ASSOC_CUSTOMER_NO'  TO TABLE-ELEMENT-2              
              MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     PREMISE_NO,                                        
                     CUSTOMER_ROLE_CD,                                  
                     TOWN,                                              
                     STATE,                                             
                     LOCAL_OFFICE,                                      
                     ACCOUNT_TYPE_CODE,                                 
                     CODE_ACCT_STAT)                                    
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-CUSTOMER-ROLE-CD,                               
                    :HT-TOWN,                                           
                    :HT-STATE,                                          
                    :HT-LOCAL-OFFICE,                                   
                    :HT-ACCOUNT-TYPE-CODE,                              
                    :HT-CODE-ACCT-STAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE HT-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= SPACES                            
               MOVE -1 TO WS-NULL-10                                    
           ELSE                                                         
               MOVE 0 TO WS-NULL-10
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_PHONE                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT)                                 
              VALUES                                                    
                   (:CB-CUSTOMER-NO,                                    
                    'C',                                                
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO,                                   
                    :CB-MOBILE-PHONE-FL,                                
                    :CB-PERMISN-TO-MKT-FL,                              
                    IIF(TRY_CONVERT(DATE, :CB-PERMISN-TO-MKT-DT 
                                          :WS-NULL-10
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                            :WS-NULL-10
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-10
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-10
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-10) ))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_PHONE                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:CB-CUSTOMER-NO,                                            
MFA-TR*             'C',                                                        
MFA-TR*             :CB-PHONE-TYPE,                                             
MFA-TR*             :CB-PHONE-NO,                                               
MFA-TR*             :CB-EXTENSION-NO,                                           
MFA-TR*             :CB-MOBILE-PHONE-FL,                                        
MFA-TR*             :CB-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :CB-PERMISN-TO-MKT-DT:WS-NULL-10)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-3            
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8040-DELETE-COAPP.                                               
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_COAPPLICANT                               
               WHERE ACCOUNT_NO  = :IC-ACCOUNT-NO                       
                 AND CUSTOMER_NO = :IC-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_COAPPLICANT                                       
MFA-TR*        WHERE ACCOUNT_NO  = :IC-ACCOUNT-NO                               
MFA-TR*          AND CUSTOMER_NO = :IC-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8040'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_COAPPLICANT'    TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE IC-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE IC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CUST-STATS.                                          
                                                                        
           IF CE-DATE-OF-BIRTH <= ' '                                   
               MOVE -1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-3
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     SSN,                                               
                     NAME_ID,                                           
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DATE_OF_BIRTH,                                     
                     REFUSED_SSN_FL,                                    
                     ITIN_ID,                                           
                     ALLOW_CALL_FL,                                     
                     ALLOW_EMAIL_FL)                                    
              VALUES                                                    
                   (:CU-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CE-SSN,                                            
                    :CE-NAME-ID,                                        
                    :CE-CODE-STATE-ID,                                  
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-EMPLOYER,                                       
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-OTHER-ID,                                       
                    IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-3
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-3) ),                
                    :CE-REFUSED-SSN-FL,                                 
                    :CE-ITIN-ID,                                        
                    :CE-ALLOW-CALL-FL,                                  
                    :CE-ALLOW-EMAIL-FL)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_STATS                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              REFUSED_SSN_FL,                                            
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL)                                            
MFA-TR*       VALUES                                                            
MFA-TR*            (:CU-CUSTOMER-NO,                                            
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-SSN,                                                    
MFA-TR*             :CE-NAME-ID,                                                
MFA-TR*             :CE-CODE-STATE-ID,                                          
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                                     
MFA-TR*             :CE-EMPLOYER,                                               
MFA-TR*             :CE-OTHER-ID-TYPE,                                          
MFA-TR*             :CE-OTHER-ID,                                               
MFA-TR*             :CE-DATE-OF-BIRTH:WS-NULL-3,                                
MFA-TR*             :CE-REFUSED-SSN-FL,                                         
MFA-TR*             :CE-ITIN-ID,                                                
MFA-TR*             :CE-ALLOW-CALL-FL,                                          
MFA-TR*             :CE-ALLOW-EMAIL-FL)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'SSN'                TO TABLE-ELEMENT-3              
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE CE-SSN               TO HOSTVAR-ELEMENT-3            
              MOVE CE-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-COAPP.                                               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_COAPPLICANT                               
                      (ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       CREATED_DATE,                                    
                       ACCESS_LEVEL_CD)                                 
              VALUES  (:IC-ACCOUNT-NO,                                  
                       :IC-CUSTOMER-NO,                                 
                       IIF(TRY_CONVERT(DATE, :IC-CREATED-DATE
              ) IS NULL OR (PATINDEX('%.%', :IC-CREATED-DATE
              ) <> 0) OR (LEN(:IC-CREATED-DATE) <> 10), CIS.CHAR2DATE(
                                                       :IC-CREATED-DATE
              ), CONVERT(DATE, :IC-CREATED-DATE) ),                            
                       :IC-ACCESS-LEVEL-CD)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COAPPLICANT                                       
MFA-TR*               (ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                CREATED_DATE,                                            
MFA-TR*                ACCESS_LEVEL_CD)                                         
MFA-TR*       VALUES  (:IC-ACCOUNT-NO,                                          
MFA-TR*                :IC-CUSTOMER-NO,                                         
MFA-TR*                :IC-CREATED-DATE,                                        
MFA-TR*                :IC-ACCESS-LEVEL-CD)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_COAPPLICANT'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE IC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE IC-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8070-INSERT-ROOMMATE.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ROOMMATE                                  
                      (ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       ACCESS_LEVEL_CD)                                 
              VALUES  (:RO-ACCOUNT-NO,                                  
                       :RO-CUSTOMER-NO,                                 
                       :RO-ACCESS-LEVEL-CD)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8070'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ROOMMATE'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE RO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RO-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8080-INSERT-CUST-XFER.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUSTOMER_XFER                             
                      (ASSOC_CUSTOMER_NO,                               
                       CUSTOMER_NO,                                     
                       RELATION_TYPE_CD,                                
                       ACCESS_LEVEL_CD)                                 
              VALUES  (:EK-ASSOC-CUSTOMER-NO,                           
                       :EK-CUSTOMER-NO,                                 
                       :EK-RELATION-TYPE-CD,                            
                       :EK-ACCESS-LEVEL-CD)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8080'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER-XFER'  TO TABLE-1                      
              MOVE 'ASSOC_CUSTOMER_NO'  TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-1            
              MOVE EK-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8090-UPDATE-COAPPLICANT.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_COAPPLICANT                                    
                 SET ACCESS_LEVEL_CD = :IC-ACCESS-LEVEL-CD              
               WHERE ACCOUNT_NO = :IC-ACCOUNT-NO                        
                 AND CUSTOMER_NO = :IC-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_COAPPLICANT                                            
MFA-TR*          SET ACCESS_LEVEL_CD = :IC-ACCESS-LEVEL-CD                      
MFA-TR*        WHERE ACCOUNT_NO = :IC-ACCOUNT-NO                                
MFA-TR*          AND CUSTOMER_NO = :IC-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8090'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_COAPPLICANT'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE IC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE IC-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8110-UPDATE-ROOMMATE.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ROOMMATE                                       
                 SET ACCESS_LEVEL_CD = :RO-ACCESS-LEVEL-CD              
               WHERE ACCOUNT_NO = :RO-ACCOUNT-NO                        
                 AND CUSTOMER_NO = :RO-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ROOMMATE                                               
MFA-TR*          SET ACCESS_LEVEL_CD = :RO-ACCESS-LEVEL-CD                      
MFA-TR*        WHERE ACCOUNT_NO = :RO-ACCOUNT-NO                                
MFA-TR*          AND CUSTOMER_NO = :RO-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8110'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ROOMMATE'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE RO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RO-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8120-UPDATE-CUST-XFER.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUSTOMER_XFER                                  
                 SET ACCESS_LEVEL_CD = :EK-ACCESS-LEVEL-CD              
               WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO          
                 AND CUSTOMER_NO = :EK-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUSTOMER_XFER                                          
MFA-TR*          SET ACCESS_LEVEL_CD = :EK-ACCESS-LEVEL-CD                      
MFA-TR*        WHERE ASSOC_CUSTOMER_NO = :EK-ASSOC-CUSTOMER-NO                  
MFA-TR*          AND CUSTOMER_NO = :EK-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8120'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER_XFER'  TO TABLE-1                      
              MOVE 'ASSOC_CUSTOMER_NO'  TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE EK-ASSOC-CUSTOMER-NO TO HOSTVAR-ELEMENT-1            
              MOVE EK-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8150-DELETE-HT.                                                  
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                 AND CUSTOMER_NO = :HT-CUSTOMER-NO                      
                 AND COMPANY_NO = :HT-COMPANY-NO                        
                 AND NAME_ID = :HT-NAME-ID                              
                 AND PREMISE_NO = :HT-PREMISE-NO                        
                 AND CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD            
                 AND CONTACT_ID = :HT-CONTACT-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*          AND CUSTOMER_NO = :HT-CUSTOMER-NO                              
MFA-TR*          AND COMPANY_NO = :HT-COMPANY-NO                                
MFA-TR*          AND NAME_ID = :HT-NAME-ID                                      
MFA-TR*          AND PREMISE_NO = :HT-PREMISE-NO                                
MFA-TR*          AND CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD                    
MFA-TR*          AND CONTACT_ID = :HT-CONTACT-ID                                
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8150'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE HT-NAME-ID            TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-CSTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_STATS                                
               WHERE CUSTOMER_NO        =  :CU-CUSTOMER-NO              
                 AND CUSTOMER_TYPE      =  'C'                          
                 AND SSN                =  ' '                          
                 AND CODE_STATE_ID      =  ' '                          
                 AND DRIVERS_LICENSE_NO =  ' '                          
                 AND EMPLOYER           =  ' '                          
                 AND EMPLOYED_DATE      IS NULL                         
                 AND OCCUPATION         =  ' '                          
                 AND OTHER_ID_TYPE      =  ' '                          
                 AND OTHER_ID           =  ' '                          
                 AND DRVR_LIC_ISS_DT    IS NULL                         
                 AND DATE_OF_BIRTH      IS NULL                         
                 AND EMPLOYEE_NBR       =  ' '                          
                 AND INTR_CO_IND        =  ' '                          
                 AND EBILL_REGISTER_IND =  ' '                          
                 AND PASSWORD_HINT_CD   = ' '                           
                 AND PASSWORD_TX        = ' '                           
                 AND REFUSED_SSN_FL     = ' '                           
                 AND LANGUAGE_PREF_CD   = ' '                           
                 AND DOB_VERIFIED_CD    = ' '                           
                 AND ACCESS_LEVEL_CD    = ' '                           
                 AND ALLOW_CALL_FL      = ' '                           
                 AND ITIN_ID            = ' '                           
                 AND VERIFY_SSN_FL      = ' '                           
                 AND PASSWORD_HINT      = ' '                           
                 AND ALLOW_EMAIL_FL     = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CU-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  'C'                                  
MFA-TR*          AND SSN                =  ' '                                  
MFA-TR*          AND CODE_STATE_ID      =  ' '                                  
MFA-TR*          AND DRIVERS_LICENSE_NO =  ' '                                  
MFA-TR*          AND EMPLOYER           =  ' '                                  
MFA-TR*          AND EMPLOYED_DATE      IS NULL                                 
MFA-TR*          AND OCCUPATION         =  ' '                                  
MFA-TR*          AND OTHER_ID_TYPE      =  ' '                                  
MFA-TR*          AND OTHER_ID           =  ' '                                  
MFA-TR*          AND DRVR_LIC_ISS_DT    IS NULL                                 
MFA-TR*          AND DATE_OF_BIRTH      IS NULL                                 
MFA-TR*          AND EMPLOYEE_NBR       =  ' '                                  
MFA-TR*          AND INTR_CO_IND        =  ' '                                  
MFA-TR*          AND EBILL_REGISTER_IND =  ' '                                  
MFA-TR*          AND PASSWORD_HINT_CD   = ' '                                   
MFA-TR*          AND PASSWORD_TX        = ' '                                   
MFA-TR*          AND REFUSED_SSN_FL     = ' '                                   
MFA-TR*          AND LANGUAGE_PREF_CD   = ' '                                   
MFA-TR*          AND DOB_VERIFIED_CD    = ' '                                   
MFA-TR*          AND ACCESS_LEVEL_CD    = ' '                                   
MFA-TR*          AND ALLOW_CALL_FL      = ' '                                   
MFA-TR*          AND ITIN_ID            = ' '                                   
MFA-TR*          AND VERIFY_SSN_FL      = ' '                                   
MFA-TR*          AND PASSWORD_HINT      = ' '                                   
MFA-TR*          AND ALLOW_EMAIL_FL     = ' '                                   
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-DELETE-NULL-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PHONE                                
               WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO               
                 AND PHONE_TYPE         = :CB-PHONE-TYPE                
                 AND PHONE_NO           = ' '                           
                 AND EXTENSION_NO       = ' '                           
                 AND CUSTOMER_TYPE      = 'C'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PHONE                                        
MFA-TR*        WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO                       
MFA-TR*          AND PHONE_TYPE         = :CB-PHONE-TYPE                        
MFA-TR*          AND PHONE_NO           = ' '                                   
MFA-TR*          AND EXTENSION_NO       = ' '                                   
MFA-TR*          AND CUSTOMER_TYPE      = 'C'                                   
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE-TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-CSTS.                                                
                                                                        
           IF CE-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-4                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-4
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
                 SET SSN                = :CE-SSN,                      
                     CODE_STATE_ID   = :CE-CODE-STATE-ID,               
                     DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,       
                     OTHER_ID_TYPE   = :CE-OTHER-ID-TYPE,               
                     OTHER_ID        = :CE-OTHER-ID,                    
                     DATE_OF_BIRTH   = IIF(TRY_CONVERT(DATE, 
                                                     :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-4
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-4
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-4
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-4) ),     
                     REFUSED_SSN_FL  = :CE-REFUSED-SSN-FL,              
                     ITIN_ID         = :CE-ITIN-ID,                     
                     ALLOW_CALL_FL   = :CE-ALLOW-CALL-FL,               
                     ALLOW_EMAIL_FL  = :CE-ALLOW-EMAIL-FL,              
                     EMPLOYER        = :CE-EMPLOYER                     
               WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                     
                 AND CUSTOMER_TYPE = 'C'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*          SET SSN                = :CE-SSN,                              
MFA-TR*              CODE_STATE_ID   = :CE-CODE-STATE-ID,                       
MFA-TR*              DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,               
MFA-TR*              OTHER_ID_TYPE   = :CE-OTHER-ID-TYPE,                       
MFA-TR*              OTHER_ID        = :CE-OTHER-ID,                            
MFA-TR*              DATE_OF_BIRTH   = :CE-DATE-OF-BIRTH:WS-NULL-4,             
MFA-TR*              REFUSED_SSN_FL  = :CE-REFUSED-SSN-FL,                      
MFA-TR*              ITIN_ID         = :CE-ITIN-ID,                             
MFA-TR*              ALLOW_CALL_FL   = :CE-ALLOW-CALL-FL,                       
MFA-TR*              ALLOW_EMAIL_FL  = :CE-ALLOW-EMAIL-FL,                      
MFA-TR*              EMPLOYER        = :CE-EMPLOYER                             
MFA-TR*        WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                             
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8340'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'DRIVERS_LICENSE_NO' TO TABLE-ELEMENT-3              
              MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-3           
              MOVE 'DATE_OF_BIRTH'      TO TABLE-ELEMENT-4              
              MOVE CE-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= ' '                               
               MOVE -1 TO WS-NULL-5                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-5
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PHONE                                     
                 SET PHONE_NO          = :CB-PHONE-NO,                  
                     EXTENSION_NO      = :CB-EXTENSION-NO,              
                     MOBILE_PHONE_FL   = :CB-MOBILE-PHONE-FL,           
                     PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,         
                     PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-5
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-5
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-5) )
               WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                    
                 AND PHONE_TYPE    = :CB-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = 'C'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_PHONE                                             
MFA-TR*          SET PHONE_NO          = :CB-PHONE-NO,                          
MFA-TR*              EXTENSION_NO      = :CB-EXTENSION-NO,                      
MFA-TR*              MOBILE_PHONE_FL   = :CB-MOBILE-PHONE-FL,                   
MFA-TR*              PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :CB-PERMISN-TO-MKT-DT:WS-NULL-5        
MFA-TR*        WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                            
MFA-TR*          AND PHONE_TYPE    = :CB-PHONE-TYPE                             
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8360'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-3            
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8370-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET FIRST_NAME      = :DQ-FIRST-NAME,                  
                     MIDDLE_NAME     = :DQ-MIDDLE-NAME,                 
                     LAST_NAME       = :DQ-LAST-NAME,                   
                     TITLE_PREFIX    = :DQ-TITLE-PREFIX,                
                     TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1               
               WHERE NAME_ID         = :DQ-NAME-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*          SET FIRST_NAME      = :DQ-FIRST-NAME,                          
MFA-TR*              MIDDLE_NAME     = :DQ-MIDDLE-NAME,                         
MFA-TR*              LAST_NAME       = :DQ-LAST-NAME,                           
MFA-TR*              TITLE_PREFIX    = :DQ-TITLE-PREFIX,                        
MFA-TR*              TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1                       
MFA-TR*        WHERE NAME_ID         = :DQ-NAME-ID                              
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8370'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-2              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-3              
              MOVE 'MIDDLE_NAME'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-2            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-3            
              MOVE DQ-MIDDLE-NAME       TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8380-UPDATE-VALIDATION.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUSTOMER                                       
                 SET VALIDATION_TS = CIS.CHAR2TIMESTAMP(
                                                      :CU-VALIDATION-TS
              )                  
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUSTOMER                                               
MFA-TR*          SET VALIDATION_TS = :CU-VALIDATION-TS                          
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8380'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER'       TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
