       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04702.                                         
COB303 DATE-WRITTEN.  JANUARY 8, 2014.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES SPOUSE INFORMATION.                      *00200000
      *  STATUS CODE VALUES:                                           *00200000
      *      +1 = SSN HAS AN ITPA ALERT                                *00200000
      *      +2 = INVALID ACTION CODE                                  *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  01/08/14   FMB       NEW PROGRAM.                             *00290000
A04860*  10/10/14  MC95456    REPLACED CSR00028 CALL WITH MCSCB077     *        
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04702'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00970000
              INCLUDE TBUSRPRF                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBCUST                                            00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     00970000
              INCLUDE TBCSTPHN                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01010000
              INCLUDE TBCSTSTS                                          01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01090000
              INCLUDE TBNAME                                            01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01130000
              INCLUDE TBNAMEID                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01170000
              INCLUDE TBNMACTX                                          01180000
           END-EXEC.                                                    01190000
           EXEC SQL                                                     01250000
              INCLUDE TBCRHIST                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01250000
              INCLUDE TBCRITPA                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01250000
              INCLUDE TBCOMDAT                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01250000
              INCLUDE TBDELQ                                            01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCONACC                                          01430000
           END-EXEC.                                                    01440000
                                                                        
A04860*    FOR MCSCB077                                                *        
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     01670000
              INCLUDE CWS00071                                          01680000
           END-EXEC.                                                    01690000
           EXEC SQL                                                     01710000
              INCLUDE CWS0091A                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-NEW-NAME-ID-NUM       PIC 9(13).                      
           05  WS-NEW-NAME-ID-CHAR      REDEFINES WS-NEW-NAME-ID-NUM    
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04702'.     
A04860     05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-PHONE-EXISTS-FLAG     PIC X(03) VALUE 'NO '.          
               88 PHONE-EXISTS                    VALUE 'YES'.          
           05  WS-HMPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 HMPH-EXISTS                     VALUE 'YES'.          
           05  WS-WKPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 WKPH-EXISTS                     VALUE 'YES'.          
           05  WS-ALPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ALPH-EXISTS                     VALUE 'YES'.          
           05  WS-NAME-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 NAME-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-8                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-9                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-HOME-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-HOME-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-WORK-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXTENSION-NO     PIC X(06) VALUE SPACES.         
           05  WS-WORK-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-ALT-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-ALT-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-NAME-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NAME-CHANGED                    VALUE 'YES'.          
           05  WS-CSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CSTS-CHANGED                    VALUE 'YES'.          
           05  WS-HMPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HMPH-CHANGED                    VALUE 'YES'.          
           05  WS-WKPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WKPH-CHANGED                    VALUE 'YES'.          
           05  WS-ALPH-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 ALPH-CHANGED                    VALUE 'YES'.          
           05  WS-HPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HPFL-CHANGED                    VALUE 'YES'.          
           05  WS-WPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WPFL-CHANGED                    VALUE 'YES'.          
           05  WS-APFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 APFL-CHANGED                    VALUE 'YES'.          
           05  WS-ITPA-EXISTS-FL        PIC X(01) VALUE SPACES.         
           05  WS-CUSTOMER-NO           PIC S9(10)V COMP-3 VALUE 0.     
           05  WS-WQ-LITERAL.                                           
               10  FILLER               PIC X(47) VALUE                 
                  'ATTEMPTED TO ADD SPOUSE WITH UNRESOLVED ITPA - '.    
               10  WS-WQ-NAME           PIC X(50) VALUE SPACES.         
               10  WS-WQ-SSN            PIC X(11) VALUE SPACES.         
           05  WS-HT-DATA.                                              
COB305         10 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
COB305         10 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.       
               10  WS-COMPANY-NO        PIC X(02) VALUE SPACES.         
COB305         10 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
               10  WS-TOWN              PIC X(26) VALUE SPACES.         
               10  WS-STATE             PIC X(02) VALUE SPACES.         
               10  WS-LOCAL-OFFICE      PIC X(26) VALUE SPACES.         
               10  WS-ACCOUNT-TYPE-CODE PIC X(01) VALUE SPACES.         
               10  WS-CODE-ACCT-STAT    PIC X(01) VALUE SPACES.         
                                                                        
A04860 01  WS-MCSCB077-OUTPUT.                                          
A04860     05  WS-MCSCB077-RET-CODE        PIC S9(09) COMP VALUE 0.     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  S-STATUS-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
      *01 LOC0028 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
               DECLARE SPOUSE_CURSOR CURSOR FOR                         
                   SELECT HT.ACCOUNT_NO,                                
                          HT.ADDRESS_ID,                                
                          HT.COMPANY_NO,                                
                          HT.PREMISE_NO,                                
                          HT.TOWN,                                      
                          HT.STATE,                                     
                          HT.LOCAL_OFFICE,                              
                          HT.ACCOUNT_TYPE_CODE,                         
                          HT.CODE_ACCT_STAT                             
                     FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),          
                          CSS_NAME DQ WITH(READUNCOMMITTED)                     
                    WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO              
                      AND HT.NAME_ID = DQ.NAME_ID                       
                      AND DQ.NAME_TYPE = 'CN'                           
                      AND HT.CUSTOMER_ROLE_CD = ' '                     
                      FOR READ ONLY                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SPOUSE_CURSOR CURSOR FOR                                 
MFA-TR*            SELECT HT.ACCOUNT_NO,                                        
MFA-TR*                   HT.ADDRESS_ID,                                        
MFA-TR*                   HT.COMPANY_NO,                                        
MFA-TR*                   HT.PREMISE_NO,                                        
MFA-TR*                   HT.TOWN,                                              
MFA-TR*                   HT.STATE,                                             
MFA-TR*                   HT.LOCAL_OFFICE,                                      
MFA-TR*                   HT.ACCOUNT_TYPE_CODE,                                 
MFA-TR*                   HT.CODE_ACCT_STAT                                     
MFA-TR*              FROM CSS_NAME_ACCT_XREF HT,                                
MFA-TR*                   CSS_NAME DQ                                           
MFA-TR*             WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                      
MFA-TR*               AND HT.NAME_ID = DQ.NAME_ID                               
MFA-TR*               AND DQ.NAME_TYPE = 'CN'                                   
MFA-TR*               AND HT.CUSTOMER_ROLE_CD = ' '                             
MFA-TR*               FOR FETCH ONLY WITH UR                                    
MFA-TR*             QUERYNO 8400                                                
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE         PIC X(01).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-TITLE               PIC X(09).                          
       01  LINK-FIRST-NAME          PIC X(15).                          
       01  LINK-MIDDLE-NAME         PIC X(15).                          
       01  LINK-LAST-NAME           PIC X(40).                          
       01  LINK-SUFFIX              PIC X(03).                          
       01  LINK-SSN                 PIC X(09).                          
       01  LINK-ITIN                PIC X(09).                          
       01  LINK-REFUSED-SSN         PIC X(01).                          
       01  LINK-DLN                 PIC X(19).                          
       01  LINK-DLN-STATE           PIC X(02).                          
       01  LINK-DATE-OF-BIRTH       PIC X(10).                          
       01  LINK-OTHER-ID-TYPE       PIC X(12).                          
       01  LINK-OTHER-ID            PIC X(16).                          
       01  LINK-ALLOW-CALL-FL       PIC X(01).                          
       01  LINK-ALLOW-EMAIL-FL      PIC X(01).                          
       01  LINK-WORK-PHONE-NO       PIC X(10).                          
       01  LINK-WORK-PHONE-EXT      PIC X(06).                          
       01  LINK-WORK-MOBILE-FL      PIC X(01).                          
       01  LINK-WORK-MKT-FL         PIC X(01).                          
       01  LINK-HOME-PHONE-NO       PIC X(10).                          
       01  LINK-HOME-MOBILE-FL      PIC X(01).                          
       01  LINK-HOME-MKT-FL         PIC X(01).                          
       01  LINK-ALT-PHONE-NO        PIC X(10).                          
       01  LINK-ALT-MOBILE-FL       PIC X(01).                          
       01  LINK-ALT-MKT-FL          PIC X(01).                          
       01  LINK-EMPLOYER            PIC X(23).                          
       01  LINK-ACCESS-LEVEL-CD     PIC X(02).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-UPDATE-TYPE,                                       
                LINK-CUSTOMER-NO,                                       
                LINK-TITLE,                                             
                LINK-FIRST-NAME,                                        
                LINK-MIDDLE-NAME,                                       
                LINK-LAST-NAME,                                         
                LINK-SUFFIX,                                            
                LINK-SSN,                                               
                LINK-ITIN,                                              
                LINK-REFUSED-SSN,                                       
                LINK-DLN,                                               
                LINK-DLN-STATE,                                         
                LINK-DATE-OF-BIRTH,                                     
                LINK-OTHER-ID-TYPE,                                     
                LINK-OTHER-ID,                                          
                LINK-ALLOW-CALL-FL,                                     
                LINK-ALLOW-EMAIL-FL,                                    
                LINK-WORK-PHONE-NO,                                     
                LINK-WORK-PHONE-EXT,                                    
                LINK-WORK-MOBILE-FL,                                    
                LINK-WORK-MKT-FL,                                       
                LINK-HOME-PHONE-NO,                                     
                LINK-HOME-MOBILE-FL,                                    
                LINK-HOME-MKT-FL,                                       
                LINK-ALT-PHONE-NO,                                      
                LINK-ALT-MOBILE-FL,                                     
                LINK-ALT-MKT-FL,                                        
                LINK-EMPLOYER,                                          
                LINK-ACCESS-LEVEL-CD,                                   
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE,                  
                       :RS-CUSTOMER-NO AS CUSTOMER_NO                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE,                          
MFA-TR*                :RS-CUSTOMER-NO AS CUSTOMER_NO                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CE-CUSTOMER-NO                    
                                      MH-CUSTOMER-NO.                   
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           IF LINK-REFUSED-SSN = 'N'                                    
               MOVE ' ' TO LINK-REFUSED-SSN
           END-IF.                            
           IF LINK-ALLOW-CALL-FL = 'Y'                                  
               MOVE ' ' TO LINK-ALLOW-CALL-FL
           END-IF.                          
           IF LINK-ALLOW-EMAIL-FL = 'Y'                                 
               MOVE ' ' TO LINK-ALLOW-EMAIL-FL
           END-IF.                         
           IF LINK-WORK-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-WORK-PHONE-EXT                       
                              LINK-WORK-MOBILE-FL                       
                              LINK-WORK-MKT-FL
           END-IF.                         
           IF LINK-HOME-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-HOME-MOBILE-FL                       
                              LINK-HOME-MKT-FL
           END-IF.                         
           IF LINK-ALT-PHONE-NO <= SPACES                               
               MOVE SPACES TO LINK-ALT-MOBILE-FL                        
                              LINK-ALT-MKT-FL
           END-IF.                          
           INSPECT LINK-FIRST-NAME REPLACING ALL '~' BY '-'.            
           INSPECT LINK-MIDDLE-NAME REPLACING ALL '~' BY '-'.           
           INSPECT LINK-LAST-NAME REPLACING ALL '~' BY '-'.             
           IF LINK-UPDATE-TYPE = 'D'                                    
               MOVE SPACES TO LINK-TITLE                                
                              LINK-FIRST-NAME                           
                              LINK-FIRST-NAME                           
                              LINK-MIDDLE-NAME                          
                              LINK-LAST-NAME                            
                              LINK-SUFFIX                               
                              LINK-SSN                                  
                              LINK-ITIN                                 
                              LINK-REFUSED-SSN                          
                              LINK-DLN                                  
                              LINK-DLN-STATE                            
                              LINK-DATE-OF-BIRTH                        
                              LINK-OTHER-ID-TYPE                        
                              LINK-OTHER-ID                             
                              LINK-ALLOW-CALL-FL                        
                              LINK-ALLOW-EMAIL-FL                       
                              LINK-WORK-PHONE-NO                        
                              LINK-WORK-PHONE-EXT                       
                              LINK-WORK-MOBILE-FL                       
                              LINK-WORK-MKT-FL                          
                              LINK-HOME-PHONE-NO                        
                              LINK-HOME-MOBILE-FL                       
                              LINK-HOME-MKT-FL                          
                              LINK-ALT-PHONE-NO                         
                              LINK-ALT-MOBILE-FL                        
                              LINK-ALT-MKT-FL                           
                              LINK-EMPLOYER                             
                              LINK-ACCESS-LEVEL-CD
           END-IF.                     
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-ACCESS-LEVEL-CD <= SPACES AND                        
             (LINK-UPDATE-TYPE = 'I' OR 'U')                            
                  IF CSR-DATABASE                                       
                      MOVE '02' TO LINK-ACCESS-LEVEL-CD                 
                  ELSE                                                  
                      MOVE '02' TO LINK-ACCESS-LEVEL-CD
                  END-IF
           END-IF.                
                                                                        
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-PREMISE-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL032'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF LINK-SSN > ' ' AND                                        
              LINK-SSN(5:1) IS NUMERIC AND                              
             (LINK-UPDATE-TYPE = 'I' OR 'U')                            
                 PERFORM 7100-CUST-FOR-SSN THRU 7100-EXIT               
                 IF WS-CUSTOMER-NO > 0                                  
                     PERFORM 7200-CREDIT-HIST THRU 7200-EXIT            
                     IF WS-ITPA-EXISTS-FL = 'Y'                         
                         STRING LINK-FIRST-NAME                         
                                LINK-MIDDLE-NAME                        
                                LINK-LAST-NAME                          
                         DELIMITED BY SIZE INTO WS-WQ-NAME              
                         STRING '***-**-' LINK-SSN(6:4)                 
                         DELIMITED BY SIZE INTO WS-WQ-SSN               
                         PERFORM 4100-COMMUNICATION THRU 4100-EXIT      
A04860                   PERFORM 4000-CALL-MCSCB077 THRU 4000-EXIT      
                         MOVE 0 TO S-RETURN-CODE                        
                         MOVE +1 TO S-STATUS-CODE
                     END-IF
                 END-IF
           END-IF.                      
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   IF S-STATUS-CODE = 0                                 
                       PERFORM 3000-INSERT-SPOUSE THRU 3000-EXIT        
                   END-IF                                               
               WHEN 'U'                                                 
                   IF S-STATUS-CODE = 0                                 
                       PERFORM 3100-UPDATE-SPOUSE THRU 3100-EXIT        
                   END-IF                                               
               WHEN 'D'                                                 
                   PERFORM 3200-DELETE-SPOUSE THRU 3200-EXIT            
               WHEN 'V'                                                 
                   PERFORM 3300-VALIDATE-SPOUSE THRU 3300-EXIT          
               WHEN OTHER                                               
                   PERFORM 3400-INVALID-ACTION THRU 3400-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-SPOUSE.                                              
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
           MOVE WS-91-NEW-NAME-ID TO WS-NEW-NAME-ID-NUM.                
                                                                        
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           MOVE WS-NEW-NAME-ID-NUM       TO DQ-NAME-ID.                 
           MOVE 'SN'                     TO DQ-NAME-TYPE.               
           MOVE 'I'                      TO DQ-NAME-FORMAT.             
           MOVE SPACES                   TO DQ-FULL-NAME.               
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           MOVE LINK-FIRST-NAME          TO DQ-FIRST-NAME.              
           MOVE LINK-MIDDLE-NAME         TO DQ-MIDDLE-NAME.             
           MOVE LINK-LAST-NAME           TO DQ-LAST-NAME.               
           MOVE LINK-TITLE               TO DQ-TITLE-PREFIX.            
           MOVE LINK-SUFFIX              TO DQ-TITLE-SUFFIX-1.          
           MOVE SPACES                   TO DQ-TITLE-SUFFIX-2.          
           PERFORM 8011-INSERT-NAME THRU 8011-EXIT.                     
                                                                        
           MOVE 'S'                         TO CE-CUSTOMER-TYPE.        
           MOVE LINK-SSN                    TO CE-SSN.                  
           MOVE WS-NEW-NAME-ID-NUM          TO CE-NAME-ID.              
           MOVE LINK-DLN-STATE              TO CE-CODE-STATE-ID.        
           MOVE LINK-DLN                    TO CE-DRIVERS-LICENSE-NO.   
           MOVE LINK-EMPLOYER               TO CE-EMPLOYER.             
           MOVE LINK-OTHER-ID-TYPE          TO CE-OTHER-ID-TYPE.        
           MOVE LINK-OTHER-ID               TO CE-OTHER-ID.             
           MOVE LINK-DATE-OF-BIRTH          TO CE-DATE-OF-BIRTH.        
           MOVE LINK-REFUSED-SSN            TO CE-REFUSED-SSN-FL.       
           MOVE LINK-ITIN                   TO CE-ITIN-ID.              
           MOVE LINK-ALLOW-CALL-FL          TO CE-ALLOW-CALL-FL.        
           MOVE LINK-ALLOW-EMAIL-FL         TO CE-ALLOW-EMAIL-FL.       
           MOVE LINK-ACCESS-LEVEL-CD        TO CE-ACCESS-LEVEL-CD.      
           MOVE WS-CURRENT-TIMESTAMP        TO CE-INFO-VERIFIED-TS.     
           PERFORM 8050-INSERT-CUST-STATS THRU 8050-EXIT.               
                                                                        
           MOVE WS-NEW-NAME-ID-NUM TO HT-NAME-ID.                       
           MOVE WS-CUSTOMER-NO-NUM TO HT-CUSTOMER-NO.                   
           PERFORM 8400-OPEN-SPOUSE-CURSOR THRU 8400-EXIT.              
           PERFORM 8410-FETCH-ROWS THRU 8410-EXIT.                      
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               MOVE WS-ACCOUNT-NO TO HT-ACCOUNT-NO                      
               MOVE WS-ADDRESS-ID TO HT-ADDRESS-ID                      
               MOVE WS-COMPANY-NO TO HT-COMPANY-NO                      
               MOVE ZERO TO HT-CONTACT-ID                               
               MOVE WS-PREMISE-NO TO HT-PREMISE-NO                      
               MOVE WS-TOWN TO HT-TOWN                                  
               MOVE WS-STATE TO HT-STATE                                
               MOVE WS-LOCAL-OFFICE TO HT-LOCAL-OFFICE                  
               MOVE WS-ACCOUNT-TYPE-CODE TO HT-ACCOUNT-TYPE-CODE        
               MOVE WS-CODE-ACCT-STAT TO HT-CODE-ACCT-STAT              
               PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT             
               PERFORM 8410-FETCH-ROWS THRU 8410-EXIT                   
           END-PERFORM                                                  
           PERFORM 8420-CLOSE-SPOUSE-CURSOR THRU 8420-EXIT              
                                                                        
           IF HMPH-EXISTS                                               
               MOVE CE-CUSTOMER-NO          TO CB-CUSTOMER-NO           
               MOVE 'H1'                    TO CB-PHONE-TYPE            
               MOVE LINK-HOME-PHONE-NO      TO CB-PHONE-NO              
               MOVE SPACES                  TO CB-EXTENSION-NO          
               MOVE LINK-HOME-MOBILE-FL     TO CB-MOBILE-PHONE-FL       
               MOVE LINK-HOME-MKT-FL        TO CB-PERMISN-TO-MKT-FL     
               IF LINK-HOME-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO CB-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO CB-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF WKPH-EXISTS                                               
               MOVE CE-CUSTOMER-NO          TO CB-CUSTOMER-NO           
               MOVE 'W1'                    TO CB-PHONE-TYPE            
               MOVE LINK-WORK-PHONE-NO      TO CB-PHONE-NO              
               MOVE LINK-WORK-PHONE-EXT     TO CB-EXTENSION-NO          
               MOVE LINK-WORK-MOBILE-FL     TO CB-MOBILE-PHONE-FL       
               MOVE LINK-WORK-MKT-FL        TO CB-PERMISN-TO-MKT-FL     
               IF LINK-WORK-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO CB-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO CB-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF ALPH-EXISTS                                               
               MOVE CE-CUSTOMER-NO          TO CB-CUSTOMER-NO           
               MOVE 'A1'                    TO CB-PHONE-TYPE            
               MOVE LINK-ALT-PHONE-NO       TO CB-PHONE-NO              
               MOVE SPACES                  TO CB-EXTENSION-NO          
               MOVE LINK-ALT-MOBILE-FL      TO CB-MOBILE-PHONE-FL       
               MOVE LINK-ALT-MKT-FL         TO CB-PERMISN-TO-MKT-FL     
               IF LINK-ALT-MKT-FL = 'Y' OR 'N'                          
                   MOVE WS-CURRENT-DATE     TO CB-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO CB-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-SPOUSE.                                              
                                                                        
           MOVE LINK-CUSTOMER-NO TO RS-CUSTOMER-NO.                     
                                                                        
           PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT.            
           PERFORM 5100-TRANSHIST-FOR-UPD-DEL THRU 5100-EXIT.           
                                                                        
           IF CSTS-CHANGED                                              
               MOVE LINK-SSN TO CE-SSN                                  
               MOVE LINK-DLN-STATE TO CE-CODE-STATE-ID                  
               MOVE LINK-DLN TO CE-DRIVERS-LICENSE-NO                   
               MOVE LINK-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE              
               MOVE LINK-OTHER-ID TO CE-OTHER-ID                        
               MOVE LINK-DATE-OF-BIRTH TO CE-DATE-OF-BIRTH              
               MOVE LINK-REFUSED-SSN TO CE-REFUSED-SSN-FL               
               MOVE LINK-ITIN TO CE-ITIN-ID                             
               MOVE LINK-ACCESS-LEVEL-CD TO CE-ACCESS-LEVEL-CD          
               MOVE LINK-ALLOW-CALL-FL TO CE-ALLOW-CALL-FL              
               MOVE LINK-ALLOW-EMAIL-FL TO CE-ALLOW-EMAIL-FL            
               MOVE LINK-EMPLOYER TO CE-EMPLOYER                        
               PERFORM 8340-UPDATE-CSTS THRU 8340-EXIT
           END-IF.                 
                                                                        
           IF NAME-CHANGED                                              
               MOVE LINK-FIRST-NAME TO DQ-FIRST-NAME                    
               MOVE LINK-MIDDLE-NAME TO DQ-MIDDLE-NAME                  
               MOVE LINK-LAST-NAME TO DQ-LAST-NAME                      
               MOVE LINK-TITLE TO DQ-TITLE-PREFIX                       
               MOVE LINK-SUFFIX TO DQ-TITLE-SUFFIX-1                    
               PERFORM 8370-UPDATE-NAME THRU 8370-EXIT
           END-IF.                 
                                                                        
           IF HMPH-CHANGED                                              
              MOVE CE-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'H1' TO CB-PHONE-TYPE                                
              MOVE LINK-HOME-PHONE-NO TO CB-PHONE-NO                    
              MOVE SPACES TO CB-EXTENSION-NO                            
              MOVE LINK-HOME-MOBILE-FL TO CB-MOBILE-PHONE-FL            
              MOVE LINK-HOME-MKT-FL TO CB-PERMISN-TO-MKT-FL             
              IF HPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF HMPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF WKPH-CHANGED                                              
              MOVE CE-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'W1' TO CB-PHONE-TYPE                                
              MOVE LINK-WORK-PHONE-NO TO CB-PHONE-NO                    
              MOVE LINK-WORK-PHONE-EXT TO CB-EXTENSION-NO               
              MOVE LINK-WORK-MOBILE-FL TO CB-MOBILE-PHONE-FL            
              MOVE LINK-WORK-MKT-FL TO CB-PERMISN-TO-MKT-FL             
              IF WPFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF WKPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           IF ALPH-CHANGED                                              
              MOVE CE-CUSTOMER-NO TO CB-CUSTOMER-NO                     
              MOVE 'A1' TO CB-PHONE-TYPE                                
              MOVE LINK-ALT-PHONE-NO TO CB-PHONE-NO                     
              MOVE SPACES TO CB-EXTENSION-NO                            
              MOVE LINK-ALT-MOBILE-FL TO CB-MOBILE-PHONE-FL             
              MOVE LINK-ALT-MKT-FL TO CB-PERMISN-TO-MKT-FL              
              IF APFL-CHANGED                                           
                  MOVE WS-CURRENT-DATE TO CB-PERMISN-TO-MKT-DT          
              END-IF                                                    
              IF ALPH-EXISTS                                            
                 PERFORM 8360-UPDATE-PHONE THRU 8360-EXIT               
                 PERFORM 8210-DELETE-NULL-PHONE THRU 8210-EXIT          
              ELSE                                                      
                 PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
              END-IF
           END-IF.              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO CE-INFO-VERIFIED-TS.            
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-DELETE-SPOUSE.                                              
                                                                        
           MOVE LINK-CUSTOMER-NO   TO RS-CUSTOMER-NO.                   
                                                                        
           PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT.            
           PERFORM 5100-TRANSHIST-FOR-UPD-DEL THRU 5100-EXIT.           
                                                                        
           PERFORM 8190-DELETE-CSTS THRU 8190-EXIT.                     
           PERFORM 8150-DELETE-NAME-ACCT-XREF THRU 8150-EXIT.           
           PERFORM 8200-DELETE-PHONE THRU 8200-EXIT.                    
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-VALIDATE-SPOUSE.                                            
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO CE-INFO-VERIFIED-TS.            
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +20                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*CONFIRMED*'         TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE LINK-CUSTOMER-NO      TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'SPOUSE INFO'         TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3400-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           MOVE 0 TO S-RETURN-CODE.                                     
           MOVE +2 TO S-STATUS-CODE.                                    
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04860 4000-CALL-MCSCB077.                                              
                                                                        
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE WS-WQ-LITERAL  TO WS-77-COMMENTS-TEXT.                  
A04860     MOVE 108            TO WS-77-COMMENTS-LEN.                   
A04860     MOVE '5'            TO WS-77-ROUTE-CATEGORY.                 
A04860     MOVE 370            TO WS-77-CATEGORY-ID.                    
A04860     MOVE CE-CUSTOMER-NO TO WS-77-CUSTOMER-NO.                    
A04860     MOVE 0              TO WS-77-ITEM-ID.                        
A04860     MOVE LINK-USERID    TO WS-77-USER-ID-ORIG.                   
A04860     MOVE SPACES         TO WS-77-USER-ID-ASGN                    
A04860                            WS-77-LOCAL-OFFICE                    
A04860                            WS-77-RESP-AREA-ID                    
A04860                            WS-77-DATE-REQUIRED                   
A04860                            WS-77-DATE-CREATED                    
A04860                            WS-77-FREE-FORM-TXT.                  
A04860     MOVE 'H'            TO WS-77-PRIORITY.                       
A04860     MOVE 0              TO WS-77-FREE-FORM-LEN.                  
A04860     MOVE ZEROES         TO WS-77-PREMISE-NO                      
A04860                            WS-77-ACCOUNT-NO                      
A04860                            WS-77-SERV-ORDER-NO.                  
A04860     MOVE PROGRAM-NAME   TO WS-77-CREATED-BY.                     
                                                                        
A04860     CALL MCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            WS-MCSCB077-RET-CODE.                 
                                                                        
A04860     MOVE WS-MCSCB077-RET-CODE       TO WS-ACTIVE-RETURN-CODE.    
                                                                        
A04860     IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
A04860        MOVE 'MCSCB077'            TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A04860        MOVE WS-77-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4100-COMMUNICATION.                                              
                                                                        
           INITIALIZE DCLCSS-COMM-DATA.                                 
           MOVE WS-CURRENT-TIMESTAMP TO KO-COMMUNICATION-ID.            
           MOVE CE-CUSTOMER-NO TO KO-CUSTOMER-NO.                       
           PERFORM 7020-SELECT-CUSTOMER THRU 7020-EXIT.                 
           MOVE CU-COMPANY-NO-ORIG TO KO-COMPANY-NO.                    
           MOVE 'N' TO KO-RED-FLAG-IND.                                 
           MOVE 'O' TO KO-COMM-METHOD.                                  
           MOVE 'I' TO KO-COMM-DIRECTION.                               
           MOVE '05' TO KO-COMM-TYPE-CD.                                
           MOVE '16' TO KO-COMM-SUBTYPE-CODE.                           
           MOVE LINK-USERID TO KO-USER-ID-ORIG.                         
           IF SEB-DATABASE                                              
               MOVE 'CREDIT DEPARTMENT' TO KO-CONTACT-NAME              
           ELSE                                                         
               MOVE 'RECEIVABLES MANAGEMENT' TO KO-CONTACT-NAME
           END-IF.        
           MOVE 'N' TO KO-PSC-COMPLIANCE-IND                            
                       KO-COMPLAINT-FL                                  
                       KO-SCREEN-POP-IND.                               
           MOVE 'C' TO KO-COMM-ASSOC-CD.                                
           MOVE WS-WQ-LITERAL TO KO-INITIAL-COMMENT-TX-TEXT.            
           MOVE +108 TO KO-INITIAL-COMMENT-TX-LEN.                      
           MOVE -1 TO WS-NULL-8                                         
                      WS-NULL-9.                                        
           PERFORM 8000-INSERT-COMM THRU 8000-EXIT.                     
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF LINK-TITLE > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TITLE            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FIRST-NAME  > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FIRST-NAME       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-MIDDLE-NAME  > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-MIDDLE-NAME  TO MI-CHG-COLUMN-VALUE-TEXT        
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-LAST-NAME > SPACES                                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LAST-NAME        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SUFFIX  > SPACES                                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SUFFIX           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SSN  > SPACES                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SSN              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SSN            '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ITIN  > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ITIN             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ITIN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-REFUSED-SSN       > SPACES                           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-REFUSED-SSN      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'REFUSED SSN'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DLN  > SPACES                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +19                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DLN              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LICENSE NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DLN-STATE  > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DLN-STATE        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CODE STATE ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DATE-OF-BIRTH  > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DATE-OF-BIRTH    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-OTHER-ID-TYPE  > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-OTHER-ID-TYPE    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID TYPE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-OTHER-ID  > SPACES                                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +16                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-OTHER-ID         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALLOW-CALL-FL = 'N'                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALLOW-CALL-FL    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALLOW CALL'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALLOW-EMAIL-FL = 'N'                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALLOW-EMAIL-FL   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALLOW EMAIL'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-WORK-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'WORK PHONE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-EXT > SPACES                              
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +6                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-PHONE-EXT      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK PHONE EXT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MOBILE-FL      TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MOBILE'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MKT-FL         TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MARKET'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MKT DT'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-HOME-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PRIMARY PHONE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MOBILE-FL      TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MOBILE'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MKT-FL         TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MARKET'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MKT DT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-PHONE-NO > SPACES                                
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALT-PHONE-NO         TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALT PHONE'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MOBILE-FL = 'Y' OR 'N'                           
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MOBILE-FL       TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MOBILE'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MKT-FL = 'Y' OR 'N'                              
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MKT-FL          TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MARKET'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO  MI-CHG-COLUMN-VALUE-TEXT
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MKT DT'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EMPLOYER > SPACES                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +23                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EMPLOYER         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMPLOYER'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ACCESS-LEVEL-CD > SPACES                             
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ACCESS-LEVEL-CD  TO 3I-ACCESS-LEVEL-CD          
              PERFORM 7010-CONTACT-ACCESS THRU 7010-EXIT                
              MOVE 3I-ACCESS-LEVEL-DESC  TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SPOUSE ACCESS'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPD-DEL.                                      
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF DQ-TITLE-PREFIX NOT = LINK-TITLE                          
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TITLE > SPACES                                    
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TITLE         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-PREFIX > SPACES                               
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-PREFIX    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-FIRST-NAME                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FIRST-NAME > SPACES                               
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-FIRST-NAME > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FIRST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-MIDDLE-NAME NOT = LINK-MIDDLE-NAME                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-MIDDLE-NAME > SPACES                              
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT      
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-MIDDLE-NAME > SPACES                                
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-MIDDLE-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-LAST-NAME NOT = LINK-LAST-NAME                         
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-LAST-NAME > SPACES                                
                 MOVE +40                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-LAST-NAME > SPACES                                  
                 MOVE +40                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-LAST-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-SUFFIX-1 NOT = LINK-SUFFIX                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SUFFIX > SPACES                                   
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SUFFIX        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-SUFFIX-1 > SPACES                             
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-SUFFIX-1  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-SSN NOT = LINK-SSN                                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SSN > SPACES                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SSN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-SSN > SPACES                                        
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-SSN             TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SSN'                 TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ITIN-ID NOT = LINK-ITIN                                
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ITIN > SPACES                                     
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ITIN          TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-ITIN-ID > SPACES                                    
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-ITIN-ID         TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ITIN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-REFUSED-SSN-FL = LOW-VALUES                            
              MOVE SPACES TO CE-REFUSED-SSN-FL                          
           END-IF.                                                      
                                                                        
           IF CE-REFUSED-SSN-FL NOT = LINK-REFUSED-SSN                  
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-REFUSED-SSN > SPACES                              
                 MOVE +1                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-REFUSED-SSN                                  
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-REFUSED-SSN-FL > SPACES                             
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE CE-REFUSED-SSN-FL   TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'REFUSED SSN'     TO MI-COLUMN-DESC                  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DRIVERS-LICENSE-NO NOT = LINK-DLN                      
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN > SPACES                                      
                 MOVE +19                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-DRIVERS-LICENSE-NO > SPACES                         
                 MOVE +19                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DRIVERS-LICENSE-NO TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LICENSE NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-CODE-STATE-ID NOT = LINK-DLN-STATE                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN-STATE > SPACES                                
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN-STATE     TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-CODE-STATE-ID > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-CODE-STATE-ID   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CODE STATE ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DATE-OF-BIRTH NOT = LINK-DATE-OF-BIRTH                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DATE-OF-BIRTH > SPACES                            
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DATE-OF-BIRTH TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-DATE-OF-BIRTH    > SPACES                           
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DATE-OF-BIRTH   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID-TYPE NOT = LINK-OTHER-ID-TYPE                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID-TYPE > SPACES                            
                 MOVE +12                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID-TYPE TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-OTHER-ID-TYPE > SPACES                              
                 MOVE +12                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OTHER-ID-TYPE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID TYPE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID NOT = LINK-OTHER-ID                           
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID > SPACES                                 
                 MOVE +16                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID  TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-OTHER-ID > SPACES                                   
                 MOVE +16                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OTHER-ID        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ALLOW-CALL-FL NOT = LINK-ALLOW-CALL-FL                 
              MOVE 'YES'                     TO WS-CSTS-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALLOW-CALL-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALLOW-CALL-FL     TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF CE-ALLOW-CALL-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE CE-ALLOW-CALL-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALLOW CALL'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ALLOW-EMAIL-FL NOT = LINK-ALLOW-EMAIL-FL               
              MOVE 'YES'                     TO WS-CSTS-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALLOW-EMAIL-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALLOW-EMAIL-FL    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF CE-ALLOW-EMAIL-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE CE-ALLOW-EMAIL-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALLOW EMAIL'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-PHONE-NO NOT = LINK-WORK-PHONE-NO                 
              MOVE 'YES'                   TO WS-WKPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-WORK-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-WORK-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-WORK-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-WORK-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'WORK PHONE'            TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-EXTENSION-NO NOT = LINK-WORK-PHONE-EXT            
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-PHONE-EXT > SPACES                           
                 MOVE +6                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-PHONE-EXT    TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-EXTENSION-NO > SPACES                          
                 MOVE +6                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-EXTENSION-NO   TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK PHONE EXT'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MOBILE-FL NOT = LINK-WORK-MOBILE-FL               
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MOBILE'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-WORK-MKT-FL NOT = LINK-WORK-MKT-FL                     
              MOVE 'YES'                     TO WS-WKPH-CHANGED-FLAG    
                                                WS-WPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-WORK-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-WORK-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-WORK-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-WORK-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'WORK MARKET'             TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-WORK-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-WORK-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-WORK-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'WORK MKT DT'         TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-HOME-PHONE-NO NOT = LINK-HOME-PHONE-NO                 
              MOVE 'YES'                   TO WS-HMPH-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-HOME-PHONE-NO > SPACES                            
                 MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-HOME-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-HOME-PHONE-NO > SPACES                              
                 MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-HOME-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'PRIMARY PHONE'         TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MOBILE-FL NOT = LINK-HOME-MOBILE-FL               
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MOBILE-FL > SPACES                           
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MOBILE-FL TO    MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MOBILE-FL > SPACES                             
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MOBILE-FL      TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MOBILE'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-HOME-MKT-FL NOT = LINK-HOME-MKT-FL                     
              MOVE 'YES'                     TO WS-HMPH-CHANGED-FLAG    
                                                WS-HPFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-HOME-MKT-FL > SPACES                              
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-HOME-MKT-FL TO       MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-HOME-MKT-FL > SPACES                                
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-HOME-MKT-FL         TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'PRIMARY MARKET'          TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-HOME-MKT-FL > ' '                                 
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-HOME-MKT-DT > SPACES                            
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-HOME-MKT-DT   TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'PRIMARY MKT DT'      TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ALT-PHONE-NO NOT = LINK-ALT-PHONE-NO                   
              MOVE 'YES'                  TO WS-ALPH-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-ALT-PHONE-NO > SPACES                             
                 MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-ALT-PHONE-NO   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF WS-ALT-PHONE-NO > SPACES                               
                 MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE WS-ALT-PHONE-NO     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'ALTERNATE PHONE'      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MOBILE-FL NOT = LINK-ALT-MOBILE-FL                 
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MOBILE-FL > SPACES                            
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MOBILE-FL TO     MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MOBILE-FL > SPACES                              
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MOBILE-FL       TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALTERNATE MOBILE'        TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-ALT-MKT-FL NOT = LINK-ALT-MKT-FL                       
              MOVE 'YES'                     TO WS-ALPH-CHANGED-FLAG    
                                                WS-APFL-CHANGED-FLAG    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              IF LINK-ALT-MKT-FL > SPACES                               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE LINK-ALT-MKT-FL TO        MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF WS-ALT-MKT-FL > SPACES                                 
                 MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE WS-ALT-MKT-FL          TO MI-PRV-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'ALT MARKET'              TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
              IF LINK-ALT-MKT-FL > ' '                                  
                  MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO         
                  MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT
                  IF WS-ALT-MKT-DT > SPACES                             
                       MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE WS-ALT-MKT-DT    TO MI-PRV-COLUMN-VALUE-TEXT
                  ELSE                                                  
                       MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                  MOVE 'ALT MKT DT'          TO MI-COLUMN-DESC          
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CE-EMPLOYER NOT = LINK-EMPLOYER                           
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-EMPLOYER  > SPACES                                
                 MOVE +23                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-EMPLOYER  TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-EMPLOYER   > SPACES                                 
                 MOVE +23                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-EMPLOYER        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'EMPLOYER       '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ACCESS-LEVEL-CD NOT = LINK-ACCESS-LEVEL-CD             
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ACCESS-LEVEL-CD > SPACES                          
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ACCESS-LEVEL-CD TO 3I-ACCESS-LEVEL-CD        
                 PERFORM 7010-CONTACT-ACCESS THRU 7010-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-ACCESS-LEVEL-CD > SPACES                            
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-ACCESS-LEVEL-CD TO 3I-ACCESS-LEVEL-CD          
                 PERFORM 7010-CONTACT-ACCESS THRU 7010-EXIT             
                 MOVE 3I-ACCESS-LEVEL-DESC TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SPOUSE ACCESS'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-GET-BASELINE-DETAILS.                                       
                                                                        
           PERFORM 7030-SELECT-CUST-STATS THRU 7030-EXIT.               
                                                                        
           MOVE CE-NAME-ID TO DQ-NAME-ID.                               
           PERFORM 7070-SELECT-NAME THRU 7070-EXIT.                     
                                                                        
           MOVE 'H1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-HOME-PHONE-NO            
              MOVE CB-MOBILE-PHONE-FL    TO WS-HOME-MOBILE-FL           
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-HOME-MKT-FL              
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-HOME-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-HOME-PHONE-NO            
                                            WS-HOME-MOBILE-FL           
                                            WS-HOME-MKT-FL              
                                            WS-HOME-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO' TO WS-PHONE-EXISTS-FLAG.                           
           MOVE 'W1' TO WS-PHONE-TYPE.                                  
           PERFORM 7050-SELECT-PHONE THRU 7050-EXIT.                    
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-WORK-PHONE-NO            
              MOVE CB-EXTENSION-NO       TO WS-WORK-EXTENSION-NO        
              MOVE CB-MOBILE-PHONE-FL    TO WS-WORK-MOBILE-FL           
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-WORK-MKT-FL              
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-WORK-MKT-DT              
           ELSE                                                         
              MOVE SPACES                TO WS-WORK-PHONE-NO            
                                            WS-WORK-EXTENSION-NO        
                                            WS-WORK-MOBILE-FL           
                                            WS-WORK-MKT-FL              
                                            WS-WORK-MKT-DT
           END-IF.             
                                                                        
           MOVE 'NO'                     TO WS-PHONE-EXISTS-FLAG.       
           MOVE 'A1'                     TO WS-PHONE-TYPE.              
           PERFORM 7050-SELECT-PHONE          THRU 7050-EXIT.           
           IF PHONE-EXISTS                                              
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE CB-PHONE-NO           TO WS-ALT-PHONE-NO             
              MOVE CB-MOBILE-PHONE-FL    TO WS-ALT-MOBILE-FL            
              MOVE CB-PERMISN-TO-MKT-FL  TO WS-ALT-MKT-FL               
              MOVE CB-PERMISN-TO-MKT-DT  TO WS-ALT-MKT-DT               
           ELSE                                                         
              MOVE SPACES                TO WS-ALT-PHONE-NO             
                                            WS-ALT-MOBILE-FL            
                                            WS-ALT-MKT-FL               
                                            WS-ALT-MKT-DT
           END-IF.              
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE C8-DELINQ-CD     TO TABLE-ELEMENT-1             
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-CONTACT-ACCESS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT ACCESS_LEVEL_DESC                                  
                INTO :3I-ACCESS-LEVEL-DESC                              
                FROM CSS_CONTACT_ACCESS WITH(READUNCOMMITTED)                   
               WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD              
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCESS_LEVEL_DESC                                          
MFA-TR*         INTO :3I-ACCESS-LEVEL-DESC                                      
MFA-TR*         FROM CSS_CONTACT_ACCESS                                         
MFA-TR*        WHERE ACCESS_LEVEL_CD = :3I-ACCESS-LEVEL-CD                      
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 3I-ACCESS-LEVEL-CD TO 3I-ACCESS-LEVEL-DESC      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCESS' TO TABLE-1                 
                   MOVE 3I-ACCESS-LEVEL-CD TO TABLE-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO_ORIG                                    
              INTO  :CU-COMPANY-NO-ORIG                                 
              FROM   CSS_CUSTOMER WITH(READUNCOMMITTED)                         
              WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                      
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO_ORIG                                            
MFA-TR*       INTO  :CU-COMPANY-NO-ORIG                                         
MFA-TR*       FROM   CSS_CUSTOMER                                               
MFA-TR*       WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CE-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT SSN,                                               
                     NAME_ID,                                           
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DATE_OF_BIRTH,                                     
                     REFUSED_SSN_FL,                                    
                     ALLOW_CALL_FL,                                     
                     ALLOW_EMAIL_FL,                                    
                     ITIN_ID,                                           
                     ACCESS_LEVEL_CD                                    
              INTO   :CE-SSN,                                           
                     :CE-NAME-ID,                                       
                     :CE-CODE-STATE-ID,                                 
                     :CE-DRIVERS-LICENSE-NO,                            
                     :CE-EMPLOYER,                                      
                     :CE-OTHER-ID-TYPE,                                 
                     :CE-OTHER-ID,                                      
                     :CE-DATE-OF-BIRTH :WS-NULL-3,                       
                     :CE-REFUSED-SSN-FL,                                
                     :CE-ALLOW-CALL-FL,                                 
                     :CE-ALLOW-EMAIL-FL,                                
                     :CE-ITIN-ID,                                       
                     :CE-ACCESS-LEVEL-CD                                
              FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO    = :CE-CUSTOMER-NO                   
                AND  CUSTOMER_TYPE  = 'S'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              REFUSED_SSN_FL,                                            
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ACCESS_LEVEL_CD                                            
MFA-TR*       INTO   :CE-SSN,                                                   
MFA-TR*              :CE-NAME-ID,                                               
MFA-TR*              :CE-CODE-STATE-ID,                                         
MFA-TR*              :CE-DRIVERS-LICENSE-NO,                                    
MFA-TR*              :CE-EMPLOYER,                                              
MFA-TR*              :CE-OTHER-ID-TYPE,                                         
MFA-TR*              :CE-OTHER-ID,                                              
MFA-TR*              :CE-DATE-OF-BIRTH:WS-NULL-3,                               
MFA-TR*              :CE-REFUSED-SSN-FL,                                        
MFA-TR*              :CE-ALLOW-CALL-FL,                                         
MFA-TR*              :CE-ALLOW-EMAIL-FL,                                        
MFA-TR*              :CE-ITIN-ID,                                               
MFA-TR*              :CE-ACCESS-LEVEL-CD                                        
MFA-TR*       FROM   CSS_CUST_STATS                                             
MFA-TR*       WHERE  CUSTOMER_NO    = :CE-CUSTOMER-NO                           
MFA-TR*         AND  CUSTOMER_TYPE  = 'S'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE 'S'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT                                  
              INTO  :WS-PHONE-EXISTS-FLAG,                              
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO,                                   
                    :CB-MOBILE-PHONE-FL,                                
                    :CB-PERMISN-TO-MKT-FL,                              
                    :CB-PERMISN-TO-MKT-DT :WS-NULL-2                     
              FROM   CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO   = :CE-CUSTOMER-NO                    
                AND  PHONE_TYPE    = :WS-PHONE-TYPE                     
                AND  CUSTOMER_TYPE = 'S'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT                                          
MFA-TR*       INTO  :WS-PHONE-EXISTS-FLAG,                                      
MFA-TR*             :CB-PHONE-TYPE,                                             
MFA-TR*             :CB-PHONE-NO,                                               
MFA-TR*             :CB-EXTENSION-NO,                                           
MFA-TR*             :CB-MOBILE-PHONE-FL,                                        
MFA-TR*             :CB-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :CB-PERMISN-TO-MKT-DT:WS-NULL-2                             
MFA-TR*       FROM   CSS_CUST_PHONE                                             
MFA-TR*       WHERE  CUSTOMER_NO   = :CE-CUSTOMER-NO                            
MFA-TR*         AND  PHONE_TYPE    = :WS-PHONE-TYPE                             
MFA-TR*         AND  CUSTOMER_TYPE = 'S'                                        
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'PHONE_TYPE'     TO TABLE-ELEMENT-2             
                   MOVE WS-PHONE-TYPE    TO HOSTVAR-ELEMENT-2           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-3             
                   MOVE 'S'              TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1                                     
              INTO  :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1                                  
              FROM   CSS_NAME WITH(READUNCOMMITTED)                             
              WHERE  NAME_ID = :DQ-NAME-ID                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1                                             
MFA-TR*       INTO  :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1                                          
MFA-TR*       FROM   CSS_NAME                                                   
MFA-TR*       WHERE  NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-1           
              MOVE CE-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CUST-FOR-SSN.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO                                        
              INTO  :WS-CUSTOMER-NO                                     
              FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE  SSN = :LINK-SSN                                    
                AND  CUSTOMER_TYPE = 'C'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*       INTO  :WS-CUSTOMER-NO                                             
MFA-TR*       FROM   CSS_CUST_STATS                                             
MFA-TR*       WHERE  SSN = :LINK-SSN                                            
MFA-TR*         AND  CUSTOMER_TYPE = 'C'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-CUSTOMER-NO                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7100'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_CUST_STATS'     TO TABLE-1                 
                   MOVE 'SSN'                TO TABLE-ELEMENT-1         
                   MOVE LINK-SSN             TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CREDIT-HIST.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM,
              LF.ITPA_RSLT_CURR_CD                              
                 INTO :CK-CR-HIST-TRAN-DT,                              
                      :CK-CR-HIST-TRAN-TM,                              
                      :LF-ITPA-RSLT-CURR-CD                             
                 FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED),                 
                      CSS_CRED_ITPA_HIST LF WITH(READUNCOMMITTED)               
                WHERE CK.CUSTOMER_NO = :WS-CUSTOMER-NO                  
                  AND CK.CR_HIST_TRAN_TM =                              
                     (SELECT MAX(CR_HIST_TRAN_TM)                       
                        FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)              
                       WHERE CUSTOMER_NO = :WS-CUSTOMER-NO              
                         AND CR_HIST_TRAN_DT =                          
                          (SELECT MAX(CR_HIST_TRAN_DT)                  
                             FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)         
                            WHERE CUSTOMER_NO = :WS-CUSTOMER-NO))       
                  AND CK.CR_HIST_TRAN_DT =                              
                   (SELECT MAX(CR_HIST_TRAN_DT)                         
                       FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)               
                 WHERE CUSTOMER_NO = :WS-CUSTOMER-NO)                   
                   AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                  
                   AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT          
                   AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CK.CR_HIST_TRAN_DT,                                       
MFA-TR*               CK.CR_HIST_TRAN_TM,                                       
MFA-TR*               LF.ITPA_RSLT_CURR_CD                                      
MFA-TR*          INTO :CK-CR-HIST-TRAN-DT,                                      
MFA-TR*               :CK-CR-HIST-TRAN-TM,                                      
MFA-TR*               :LF-ITPA-RSLT-CURR-CD                                     
MFA-TR*          FROM CSS_CREDIT_HIST CK,                                       
MFA-TR*               CSS_CRED_ITPA_HIST LF                                     
MFA-TR*         WHERE CK.CUSTOMER_NO = :WS-CUSTOMER-NO                          
MFA-TR*           AND CK.CR_HIST_TRAN_TM =                                      
MFA-TR*              (SELECT MAX(CR_HIST_TRAN_TM)                               
MFA-TR*                 FROM CSS_CREDIT_HIST                                    
MFA-TR*                WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                      
MFA-TR*                  AND CR_HIST_TRAN_DT =                                  
MFA-TR*                   (SELECT MAX(CR_HIST_TRAN_DT)                          
MFA-TR*                      FROM CSS_CREDIT_HIST                               
MFA-TR*                     WHERE CUSTOMER_NO = :WS-CUSTOMER-NO))               
MFA-TR*           AND CK.CR_HIST_TRAN_DT =                                      
MFA-TR*            (SELECT MAX(CR_HIST_TRAN_DT)                                 
MFA-TR*                FROM CSS_CREDIT_HIST                                     
MFA-TR*          WHERE CUSTOMER_NO = :WS-CUSTOMER-NO)                           
MFA-TR*            AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                          
MFA-TR*            AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT                  
MFA-TR*            AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF LF-ITPA-RSLT-CURR-CD = ' ' OR 'R'                 
                       MOVE 'N' TO WS-ITPA-EXISTS-FL                    
                   ELSE                                                 
                       MOVE 'Y' TO WS-ITPA-EXISTS-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_CREDIT_HIST'    TO TABLE-1                 
                   MOVE 'CSS_CRED_ITPA_HIST' TO TABLE-2                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-COMM.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_COMM_DATA                                 
                   ( COMMUNICATION_ID,                                  
                     ACCOUNT_NO,                                        
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     COMPANY_NO,                                        
                     RED_FLAG_IND,                                      
                     RED_FLAG_EXPIRE_DT,                                
                     COMM_METHOD,                                       
                     COMM_DIRECTION,                                    
                     COMM_TYPE_CD,                                      
                     COMM_SUBTYPE_CODE,                                 
                     USER_ID_ORIG,                                      
                     CONTACT_NAME,                                      
                     PROMOTION_ID,                                      
                     PSC_COMPLIANCE_IND,                                
                     CALL_ORIGIN_ID,                                    
                     CALL_END_TIME,                                     
                     NUMBER_TRANSFERS,                                  
                     HOLD_TIME,                                         
                     QUEUE_TIME,                                        
                     SCREEN_POP_IND,                                    
                     TOTAL_CALL_TIME,                                   
                     INITIAL_COMMENT_TX,                                
                     COMM_ASSOC_CD,                                     
                     COMPLAINT_FL,                                      
                     DISCOVERY_MTHD_CD,                                 
                     PREV_MARKETER_CD)                                  
              VALUES                                                    
                   (CIS.CHAR2TIMESTAMP(:KO-COMMUNICATION-ID),                   
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT :WS-NULL-8
              ),                   
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME :WS-NULL-9),           
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL,                                   
                    :KO-DISCOVERY-MTHD-CD,                              
                    :KO-PREV-MARKETER-CD)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COMM_DATA                                         
MFA-TR*            ( COMMUNICATION_ID,                                          
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              RED_FLAG_IND,                                              
MFA-TR*              RED_FLAG_EXPIRE_DT,                                        
MFA-TR*              COMM_METHOD,                                               
MFA-TR*              COMM_DIRECTION,                                            
MFA-TR*              COMM_TYPE_CD,                                              
MFA-TR*              COMM_SUBTYPE_CODE,                                         
MFA-TR*              USER_ID_ORIG,                                              
MFA-TR*              CONTACT_NAME,                                              
MFA-TR*              PROMOTION_ID,                                              
MFA-TR*              PSC_COMPLIANCE_IND,                                        
MFA-TR*              CALL_ORIGIN_ID,                                            
MFA-TR*              CALL_END_TIME,                                             
MFA-TR*              NUMBER_TRANSFERS,                                          
MFA-TR*              HOLD_TIME,                                                 
MFA-TR*              QUEUE_TIME,                                                
MFA-TR*              SCREEN_POP_IND,                                            
MFA-TR*              TOTAL_CALL_TIME,                                           
MFA-TR*              INITIAL_COMMENT_TX,                                        
MFA-TR*              COMM_ASSOC_CD,                                             
MFA-TR*              COMPLAINT_FL,                                              
MFA-TR*              DISCOVERY_MTHD_CD,                                         
MFA-TR*              PREV_MARKETER_CD)                                          
MFA-TR*       VALUES                                                            
MFA-TR*            (:KO-COMMUNICATION-ID,                                       
MFA-TR*             :KO-ACCOUNT-NO,                                             
MFA-TR*             :KO-CUSTOMER-NO,                                            
MFA-TR*             :KO-PREMISE-NO,                                             
MFA-TR*             :KO-COMPANY-NO,                                             
MFA-TR*             :KO-RED-FLAG-IND,                                           
MFA-TR*             :KO-RED-FLAG-EXPIRE-DT:WS-NULL-8,                           
MFA-TR*             :KO-COMM-METHOD,                                            
MFA-TR*             :KO-COMM-DIRECTION,                                         
MFA-TR*             :KO-COMM-TYPE-CD,                                           
MFA-TR*             :KO-COMM-SUBTYPE-CODE,                                      
MFA-TR*             :KO-USER-ID-ORIG,                                           
MFA-TR*             :KO-CONTACT-NAME,                                           
MFA-TR*             :KO-PROMOTION-ID,                                           
MFA-TR*             :KO-PSC-COMPLIANCE-IND,                                     
MFA-TR*             :KO-CALL-ORIGIN-ID,                                         
MFA-TR*             :KO-CALL-END-TIME:WS-NULL-9,                                
MFA-TR*             :KO-NUMBER-TRANSFERS,                                       
MFA-TR*             :KO-HOLD-TIME,                                              
MFA-TR*             :KO-QUEUE-TIME,                                             
MFA-TR*             :KO-SCREEN-POP-IND,                                         
MFA-TR*             :KO-TOTAL-CALL-TIME,                                        
MFA-TR*             :KO-INITIAL-COMMENT-TX,                                     
MFA-TR*             :KO-COMM-ASSOC-CD,                                          
MFA-TR*             :KO-COMPLAINT-FL,                                           
MFA-TR*             :KO-DISCOVERY-MTHD-CD,                                      
MFA-TR*             :KO-PREV-MARKETER-CD)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_COMM_DATA'      TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8011-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              MOVE LINK-CUSTOMER-NO TO HOSTVAR-ELEMENT-4                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     PREMISE_NO,                                        
                     CONTACT_ID,                                        
                     TOWN,                                              
                     STATE,                                             
                     LOCAL_OFFICE,                                      
                     ACCOUNT_TYPE_CODE,                                 
                     CODE_ACCT_STAT)                                    
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-CONTACT-ID,                                     
                    :HT-TOWN,                                           
                    :HT-STATE,                                          
                    :HT-LOCAL-OFFICE,                                   
                    :HT-ACCOUNT-TYPE-CODE,                              
                    :HT-CODE-ACCT-STAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE HT-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= SPACES                            
               MOVE -1 TO WS-NULL-10                                    
           ELSE                                                         
               MOVE 0 TO WS-NULL-10
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_PHONE                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT)                                 
              VALUES                                                    
                   (:CB-CUSTOMER-NO,                                    
                    'S',                                                
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO,                                   
                    :CB-MOBILE-PHONE-FL,                                
                    :CB-PERMISN-TO-MKT-FL,                              
                    IIF(TRY_CONVERT(DATE, :CB-PERMISN-TO-MKT-DT 
                                          :WS-NULL-10
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                            :WS-NULL-10
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-10
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-10
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-10) ))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_PHONE                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:CB-CUSTOMER-NO,                                            
MFA-TR*             'S',                                                        
MFA-TR*             :CB-PHONE-TYPE,                                             
MFA-TR*             :CB-PHONE-NO,                                               
MFA-TR*             :CB-EXTENSION-NO,                                           
MFA-TR*             :CB-MOBILE-PHONE-FL,                                        
MFA-TR*             :CB-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :CB-PERMISN-TO-MKT-DT:WS-NULL-10)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'S'                  TO HOSTVAR-ELEMENT-2            
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-3            
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CUST-STATS.                                          
                                                                        
           IF CE-DATE-OF-BIRTH <= ' '                                   
               MOVE -1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-3
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     SSN,                                               
                     NAME_ID,                                           
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DATE_OF_BIRTH,                                     
                     REFUSED_SSN_FL,                                    
                     ITIN_ID,                                           
                     ALLOW_CALL_FL,                                     
                     ALLOW_EMAIL_FL,                                    
                     ACCESS_LEVEL_CD,                                   
                     INFO_VERIFIED_TS)                                  
              VALUES                                                    
                   (:CE-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CE-SSN,                                            
                    :CE-NAME-ID,                                        
                    :CE-CODE-STATE-ID,                                  
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-EMPLOYER,                                       
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-OTHER-ID,                                       
                    IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-3
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-3) ),                
                    :CE-REFUSED-SSN-FL,                                 
                    :CE-ITIN-ID,                                        
                    :CE-ALLOW-CALL-FL,                                  
                    :CE-ALLOW-EMAIL-FL,                                 
                    :CE-ACCESS-LEVEL-CD,                                
                    CIS.CHAR2TIMESTAMP(:CE-INFO-VERIFIED-TS))                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_STATS                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              REFUSED_SSN_FL,                                            
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              INFO_VERIFIED_TS)                                          
MFA-TR*       VALUES                                                            
MFA-TR*            (:CE-CUSTOMER-NO,                                            
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-SSN,                                                    
MFA-TR*             :CE-NAME-ID,                                                
MFA-TR*             :CE-CODE-STATE-ID,                                          
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                                     
MFA-TR*             :CE-EMPLOYER,                                               
MFA-TR*             :CE-OTHER-ID-TYPE,                                          
MFA-TR*             :CE-OTHER-ID,                                               
MFA-TR*             :CE-DATE-OF-BIRTH:WS-NULL-3,                                
MFA-TR*             :CE-REFUSED-SSN-FL,                                         
MFA-TR*             :CE-ITIN-ID,                                                
MFA-TR*             :CE-ALLOW-CALL-FL,                                          
MFA-TR*             :CE-ALLOW-EMAIL-FL,                                         
MFA-TR*             :CE-ACCESS-LEVEL-CD,                                        
MFA-TR*             :CE-INFO-VERIFIED-TS)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'SSN'                TO TABLE-ELEMENT-3              
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE CE-SSN               TO HOSTVAR-ELEMENT-3            
              MOVE CE-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8150-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
              WHERE  NAME_ID = :CE-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*       WHERE  NAME_ID = :CE-NAME-ID                                      
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8150'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE CE-NAME-ID            TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-CSTS.                                                
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_STATS                                
               WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO              
                 AND CUSTOMER_TYPE      =  'S'                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  'S'                                  
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'S'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-DELETE-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PHONE                                
               WHERE CUSTOMER_NO        = :CE-CUSTOMER-NO               
                 AND CUSTOMER_TYPE      = 'S'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PHONE                                        
MFA-TR*        WHERE CUSTOMER_NO        = :CE-CUSTOMER-NO                       
MFA-TR*          AND CUSTOMER_TYPE      = 'S'                                   
MFA-TR*       QUERYNO 8200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'S'                  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-DELETE-NULL-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PHONE                                
               WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO               
                 AND PHONE_TYPE         = :CB-PHONE-TYPE                
                 AND PHONE_NO           = ' '                           
                 AND EXTENSION_NO       = ' '                           
                 AND CUSTOMER_TYPE      = 'S'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PHONE                                        
MFA-TR*        WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO                       
MFA-TR*          AND PHONE_TYPE         = :CB-PHONE-TYPE                        
MFA-TR*          AND PHONE_NO           = ' '                                   
MFA-TR*          AND EXTENSION_NO       = ' '                                   
MFA-TR*          AND CUSTOMER_TYPE      = 'S'                                   
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE-TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'S'                  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-CSTS.                                                
                                                                        
           IF CE-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-4                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-4
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
              SET SSN                = :CE-SSN,                         
                  CODE_STATE_ID      = :CE-CODE-STATE-ID,               
                  DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,          
                  OTHER_ID_TYPE      = :CE-OTHER-ID-TYPE,               
                  OTHER_ID           = :CE-OTHER-ID,                    
                  DATE_OF_BIRTH      = IIF(TRY_CONVERT(DATE, 
                                                     :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-4
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-4
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-4
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-4) ),     
                  REFUSED_SSN_FL     = :CE-REFUSED-SSN-FL,              
                  ITIN_ID            = :CE-ITIN-ID,                     
                  ALLOW_CALL_FL      = :CE-ALLOW-CALL-FL,               
                  ALLOW_EMAIL_FL     = :CE-ALLOW-EMAIL-FL,              
                  EMPLOYER           = :CE-EMPLOYER,                    
                  ACCESS_LEVEL_CD    = :CE-ACCESS-LEVEL-CD              
               WHERE CUSTOMER_NO     = :CE-CUSTOMER-NO                  
                 AND CUSTOMER_TYPE   = 'S'                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*       SET SSN                = :CE-SSN,                                 
MFA-TR*           CODE_STATE_ID      = :CE-CODE-STATE-ID,                       
MFA-TR*           DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,                  
MFA-TR*           OTHER_ID_TYPE      = :CE-OTHER-ID-TYPE,                       
MFA-TR*           OTHER_ID           = :CE-OTHER-ID,                            
MFA-TR*           DATE_OF_BIRTH      = :CE-DATE-OF-BIRTH:WS-NULL-4,             
MFA-TR*           REFUSED_SSN_FL     = :CE-REFUSED-SSN-FL,                      
MFA-TR*           ITIN_ID            = :CE-ITIN-ID,                             
MFA-TR*           ALLOW_CALL_FL      = :CE-ALLOW-CALL-FL,                       
MFA-TR*           ALLOW_EMAIL_FL     = :CE-ALLOW-EMAIL-FL,                      
MFA-TR*           EMPLOYER           = :CE-EMPLOYER,                            
MFA-TR*           ACCESS_LEVEL_CD    = :CE-ACCESS-LEVEL-CD                      
MFA-TR*        WHERE CUSTOMER_NO     = :CE-CUSTOMER-NO                          
MFA-TR*          AND CUSTOMER_TYPE   = 'S'                                      
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8340'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'S'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'DRIVERS_LICENSE_NO' TO TABLE-ELEMENT-3              
              MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-3           
              MOVE 'DATE_OF_BIRTH'      TO TABLE-ELEMENT-4              
              MOVE CE-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= ' '                               
               MOVE -1 TO WS-NULL-5                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-5
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PHONE                                     
              SET    PHONE_NO          = :CB-PHONE-NO,                  
                     EXTENSION_NO      = :CB-EXTENSION-NO,              
                     MOBILE_PHONE_FL   = :CB-MOBILE-PHONE-FL,           
                     PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,         
                     PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-5
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-5
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-5) )
              WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                    
                AND  PHONE_TYPE    = :CB-PHONE-TYPE                     
                AND  CUSTOMER_TYPE = 'S'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_PHONE                                             
MFA-TR*       SET    PHONE_NO          = :CB-PHONE-NO,                          
MFA-TR*              EXTENSION_NO      = :CB-EXTENSION-NO,                      
MFA-TR*              MOBILE_PHONE_FL   = :CB-MOBILE-PHONE-FL,                   
MFA-TR*              PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :CB-PERMISN-TO-MKT-DT:WS-NULL-5        
MFA-TR*       WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                            
MFA-TR*         AND  PHONE_TYPE    = :CB-PHONE-TYPE                             
MFA-TR*         AND  CUSTOMER_TYPE = 'S'                                        
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8360'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'S'                  TO HOSTVAR-ELEMENT-3            
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8370-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
              SET    FIRST_NAME      = :DQ-FIRST-NAME,                  
                     MIDDLE_NAME     = :DQ-MIDDLE-NAME,                 
                     LAST_NAME       = :DQ-LAST-NAME,                   
                     TITLE_PREFIX    = :DQ-TITLE-PREFIX,                
                     TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1               
              WHERE  NAME_ID         = :DQ-NAME-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*       SET    FIRST_NAME      = :DQ-FIRST-NAME,                          
MFA-TR*              MIDDLE_NAME     = :DQ-MIDDLE-NAME,                         
MFA-TR*              LAST_NAME       = :DQ-LAST-NAME,                           
MFA-TR*              TITLE_PREFIX    = :DQ-TITLE-PREFIX,                        
MFA-TR*              TITLE_SUFFIX_1  = :DQ-TITLE-SUFFIX-1                       
MFA-TR*       WHERE  NAME_ID         = :DQ-NAME-ID                              
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8370'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-2              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-3              
              MOVE 'MIDDLE_NAME'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-2            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-3            
              MOVE DQ-MIDDLE-NAME       TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8380-UPDATE-VALIDATION.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
              SET    INFO_VERIFIED_TS = CIS.CHAR2TIMESTAMP(
                                                   :CE-INFO-VERIFIED-TS
              )            
              WHERE  CUSTOMER_NO      = :CE-CUSTOMER-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*       SET    INFO_VERIFIED_TS = :CE-INFO-VERIFIED-TS                    
MFA-TR*       WHERE  CUSTOMER_NO      = :CE-CUSTOMER-NO                         
MFA-TR*       QUERYNO 8380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8380'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'S'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-OPEN-SPOUSE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN SPOUSE_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8400'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CSS_NAME'            TO TABLE-2                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8410-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH SPOUSE_CURSOR                                       
               INTO :WS-ACCOUNT-NO,                                     
                    :WS-ADDRESS-ID,                                     
                    :WS-COMPANY-NO,                                     
                    :WS-PREMISE-NO,                                     
                    :WS-TOWN,                                           
                    :WS-STATE,                                          
                    :WS-LOCAL-OFFICE,                                   
                    :WS-ACCOUNT-TYPE-CODE,                              
                    :WS-CODE-ACCT-STAT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8410'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CSS_NAME'            TO TABLE-2                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8420-CLOSE-SPOUSE-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE SPOUSE_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8420'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CSS_NAME'            TO TABLE-2                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE WS-CUSTOMER-NO-NUM    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29740000
              INCLUDE CPD00071                                          29750000
           END-EXEC.                                                    29760000
                                                                        
           EXEC SQL                                                     29780000
              INCLUDE CPD00091                                          29790000
           END-EXEC.                                                    29800000
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
