       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04701.                                          
       AUTHOR.       SHABNAM.                                           
COB303 DATE-WRITTEN. APRIL 3, 2014.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIVES ADDRESS INFORMATION BASED ON THE        *        
      *  ACCOUNT LEVEL.                                                *        
      *                                                                *        
      *  CLONED FROM CSR02545 & CSR02337.                              *        
      *                                                                *        
      *  1. USED IT IN CASA PROJECT TO GET BILLING ADDRESS FOR THE ACCT*        
      *  2. USED IN THE GLOBAL PRINT SCREEN TO GET BILLING ADDRESS AND *        
      *     SERVICE ADDRESS BASED ON THE ACCOUNT.                      *        
      *  3. IF THE ACCOUNT NUM ALONE PASSED, IT WILL RETURN            *        
      *     RESULTS SET 1 AS PART OF BILL WINDOW.                      *        
      *  4. IF ACCOUNT NUM AND CUSTOMER NUM PASSED, IT WILL RETURN     *        
      *     RESULT SET 2 AS PART OF GLOBAL EMAIL PRINT SCREEN.         *        
      *                                                                *        
      ******************************************************************        
      *   PARAMETERS:                                                  *        
      *                                                                *        
      *   INPUT PARAMETERS.                                            *        
      *                                                                *        
      *            ACCOUNT_NO             CHAR(13)                     *        
      *            CUSTOMER_NO            CHAR(10)                     *        
      *            ACCOUNT_ARCHIVE_FLAG   CHAR(01)                     *        
      *                                                                *        
      *   OUTPUT RESULT SET.                                           *        
      *                                                                *        
      *   CSR04701_R1 - FOR CASA PROJECT                               *        
      *                                                                *        
      *            RETURN_CODE          INTEGER                        *        
      *            STATUS_CODE          INTEGER                        *        
      *            NAME_ADDR_TYPE       CHAR(02)                       *        
      *            NAME_ADDR_LINE       CHAR(100)                      *        
      *                                                                *        
      *   CSR04701_R2 - FOR GLOBAL EMAIL PRINT                         *        
      *                                                                *        
      *            RETURN_CODE          INTEGER                        *        
      *            CODE_ACCT_STAT       CHAR(01)                       *        
      *            ACCOUNT_NO           CHAR(13)                       *        
      *            ADDR_LINE_1          CHAR(50)                       *        
      *            ADDR_LINE_2          CHAR(50)                       *        
      *            ADDR_LINE_3          CHAR(50)                       *        
      *            ADDR_LINE_4          CHAR(50)                       *        
      *            ADDR_LINE_5          CHAR(50)                       *        
      *            ADDR_LINE_6          CHAR(50)                       *        
      *            NAME                 CHAR(50)                       *        
      *            SERV_ADDR            CHAR(50)                       *        
      *            CONTACT_POSITION     CHAR(30)                       *        
      *            CONTACT_TYPE         CHAR(02)                       *        
      *            ADDRESS_NAME         CHAR(100)                      *        
      *            ADDRESS_TYPE         CHAR(16)                       *        
      *            SERVICE_DATE         CHAR(10)                       *        
      *            SERVICE_END_DATE     CHAR(10)                       *        
      *            MONTHS               SMALLINT                       *        
      *            NO_30_DAY            SMALLINT                       *        
      *            NO_RET_CHECKS        SMALLINT                       *        
      *            NO_DNP               SMALLINT                       *        
      *            FINAL_BILL_AMOUNT    DECIMAL(11,2)                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/03/14  SS7F226    NEW PROGRAM.                                      
A05136*  10/23/14  SS7F226    REMOVE IF STATEMENT IN 2900- PARA TO FIX          
A05136*            ACT209     PROD ISSUE.(ISSUE: SAME ADDRESS IS                
A05136*                       DISPLAYING AT ADDRLINE 3&4 IN RESULT SET)         
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04701'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04701 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_BILL_NMES (AB)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        (AT)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ZIP_CODE       (A4)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY    (C8)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CONTACT        (CV)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCNTACT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CREDIT_PROFILE (CZ)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CONTACT_CUST   (DT)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCNTCCS                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CONTACT_ACCT   (DW)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCNTCAT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_ADDR_XREF (DM)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME           (DQ)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ADDR_FORMATTED (DY)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ADDR_FREEFORM  (DZ)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME_ACCT_XREF (HT)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NSF_HIST       (NH)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBNSFHST                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PREMISE        (PR)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_MISC_INFO (TA)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  WORKING STORAGE COPYBOOK FOR CPD00074                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWS00074                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  WORKING STORAGE COPYBOOK FOR CPD00068                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
           COPY CWS0068L.                                                       
                                                                        
           COPY CWS00056.                                                       
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1                PIC X(26) VALUE               
                                          'SESSION.CSR04701_R1'.        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN            PIC S9(04) COMP.              
                49 GTT-ROW-CHAR           PIC X(1024).                  
            05  GTT-SQLCODE               PIC S9(9) COMP.               
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9) COMP.               
           05  SNA-CONNECTION-NAME        PIC X(08) VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP VALUE 1.       
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS-R2                PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM            PIC S9(9) COMP.               
           05  WRKLEN1                    PIC S9(9) COMP.               
           05  WRKLEN2                    PIC S9(9) COMP.               
           05  WRK-DONE-STATUS            PIC S9(9) COMP.               
                                                                        
       01  FILLER                         PIC X(32) VALUE               
                                         'THIS IS THE ROW RETURN AREA.'.
                                                                        
       01  WS-ACCT-FIELDS.                                              
           05 WS-SERVICE-DATE             PIC X(10) VALUE SPACES.       
           05 WS-SERV-END-DATE            PIC X(10) VALUE SPACES.       
           05 WS-ARREARS-HIST-O           PIC S9(04) COMP  VALUE 0.     
           05 WS-NO-30-DAY                PIC S9(04) COMP  VALUE 0.     
           05 WS-NO-RET-CHECKS            PIC S9(04) COMP  VALUE 0.     
           05 WS-NO-DNP                   PIC S9(04) COMP  VALUE 0.     
           05 WS-FINAL-BILL-AMT           PIC S9(09)V99 VALUE 0 COMP-3. 
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1         PIC S9(9) COMP VALUE 0.       
               10 S-STATUS-CODE           PIC S9(9) COMP VALUE 0.       
               10 S-NAME-ADDR-TYPE        PIC X(02) VALUE SPACES.       
               10 S-NAME-ADDR-LINE        PIC X(100) VALUE SPACES.      
                                                                        
      *RESULT SET FOR EMAIL AND PRINT                                           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2         PIC S9(9) COMP.               
               10 S-CODE-ACCT-STAT        PIC X(01).                    
               10 S-ACCOUNT-NO            PIC X(13).                    
               10 S-ADDR-LINE-1           PIC X(50).                    
               10 S-ADDR-LINE-2           PIC X(50).                    
               10 S-ADDR-LINE-3           PIC X(50).                    
               10 S-ADDR-LINE-4           PIC X(50).                    
               10 S-ADDR-LINE-5           PIC X(50).                    
               10 S-ADDR-LINE-6           PIC X(50).                    
               10 S-NAME                  PIC X(50).                    
               10 S-SERV-ADDR             PIC X(50).                    
               10 S-CONTACT-POSITION      PIC X(30).                    
               10 S-CONTACT-TYPE          PIC X(02).                    
               10 S-ADDRESS-NAME          PIC X(100).                   
               10 S-ADDRESS-TYPE          PIC X(16).                    
               10 S-SERVICE-DATE          PIC X(10) VALUE SPACES.       
               10 S-SERV-END-DATE         PIC X(10) VALUE SPACES.       
               10 S-ARREARS-HIST          PIC S9(04) COMP  VALUE 0.     
               10 S-NO-30-DAY             PIC S9(04) COMP  VALUE 0.     
               10 S-NO-RET-CHECKS         PIC S9(04) COMP  VALUE 0.     
               10 S-NO-DNP                PIC S9(04) COMP  VALUE 0.     
               10 S-FINAL-BILL-AMT        PIC S9(09)V99 VALUE 0 COMP-3. 
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
           05  WS-RESULT-FLAG             PIC X(04).                    
               88 BILL-WINDOW-PROCESS               VALUE 'BILL'.       
               88 MAIL-PRINT-PROCESS                VALUE 'MAIL'.       
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR         PIC X(13).                    
           05  WS-ACCOUNT-NO-NUM          REDEFINES WS-ACCOUNT-NO-CHAR  
                                          PIC 9(13).                    
           05  WS-ACCOUNT-TEMP            PIC 9(13).                    
           05  WS-CUST-NO-CHAR            PIC X(10).                    
           05  WS-CUST-NO-NUM             REDEFINES WS-CUST-NO-CHAR     
                                          PIC 9(10).                    
           05  WS-CURRENT-TS              PIC X(26) VALUE SPACES.       
           05  WS-CURRENT-DATE            PIC X(10) VALUE SPACES.       
           05  WS-SQLSTATE                PIC X(05) VALUE SPACES.       
           05  RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.       
           05  WS-GTT01-DECLARED          PIC X(01) VALUE 'N'.          
           05  WS-GTT02-DECLARED          PIC X(01) VALUE 'N'.          
           05  WS-ACCT-ARCHIVE-FLAG       PIC X(1).                     
           05  WS-SUB1                    PIC S9(4) COMP VALUE 0.       
           05  WS-PREV-ACCOUNT-NO         PIC X(13) VALUE SPACES.       
           05  WS-NULL-CREATE-DATE        PIC S9(04) COMP.              
           05  WS-NULL-FINAL-DATE         PIC S9(04) COMP.              
           05  WS-ARREARS-HIST            PIC X(24).                    
           05  WS-ARREARS-HIST-BRKDWN REDEFINES WS-ARREARS-HIST         
                                          PIC X(01) OCCURS 24.          
           05  WS-DISC-HIST               PIC X(24).                    
           05  WS-DISC-HIST-BRKDWN REDEFINES WS-DISC-HIST               
                                          PIC X(01) OCCURS 24.          
           05  WS-EXCEPTIONAL-HIST        PIC X(24).                    
           05  WS-EXCEPTIONAL-HIST-BRKDWN REDEFINES                     
               WS-EXCEPTIONAL-HIST        PIC X(01) OCCURS 24.          
           05  WS-PREV-MNTH               PIC S9(4) COMP VALUE 0.       
           05  WS-ROW-COUNT               PIC S9(9) COMP VALUE 0.       
           05  WS-MCSCB068                PIC X(08) VALUE 'MCSCB068'.   
                                                                        
       01  WS-SELECT-DATE-FORM.                                         
           10  WS-SELECT-CENT             PIC X(02) VALUE SPACES.       
           10  WS-SELECT-YEAR             PIC X(02) VALUE SPACES.       
           10  FILLER                     PIC X(01) VALUE SPACES.       
           10  WS-SELECT-MONTH            PIC X(02) VALUE SPACES.       
           10  FILLER                     PIC X(01) VALUE SPACES.       
           10  WS-SELECT-DAY              PIC X(02) VALUE SPACES.       
           10  FILLER                     PIC X(16) VALUE SPACES.       
                                                                        
       01  WS-SELECT-DATE-USA.                                          
           10  WS-SELECT-MM               PIC X(02) VALUE SPACES.       
           10  FILLER                     PIC X(01) VALUE '/'.          
           10  WS-SELECT-DD               PIC X(02) VALUE SPACES.       
           10  FILLER                     PIC X(01) VALUE '/'.          
           10  WS-SELECT-CC               PIC X(02) VALUE SPACES.       
           10  WS-SELECT-YY               PIC X(02) VALUE SPACES.       
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME               PIC X(08) VALUE 'CSR04701'.   
           05  WS-YES                     PIC X(01) VALUE 'Y'.          
           05  WS-NO                      PIC X(01) VALUE 'N'.          
           05  WS-SUCCESS                 PIC X(01) VALUE 'Y'.          
           05  WS-ONE                     PIC 9(01) VALUE 1.            
           05  WS-BILLING-ADDRESS         PIC X(16) VALUE               
                                          'BILLING '.                   
           05  WS-SERVICE-ADDRESS         PIC X(16) VALUE               
                                          'SERVICE '.                   
           05  WS-ADDRESS-TYPE            PIC X(16).                    
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                 PIC X(18) VALUE SPACES.       
            10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.       
            10  S-SQLSTATE                PIC X(5)  VALUE ' '.          
            10  S-TABLE-NAME              PIC X(18) VALUE SPACES.       
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.         
                49  S-HOST-VARIABLES-V    PIC X(255).                   
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.         
                49  S-SQL-STATEMENT-V     PIC X(255).                   
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.         
                49  S-SQL-DESCRIPTION-V   PIC X(255).                   
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT RETURN_CODE    AS RETURN_CODE                     
                     ,STATUS_CODE    AS STATUS_CODE                     
                     ,NAME_ADDR_TYPE AS NAME_ADDR_TYPE                  
                     ,NAME_ADDR_LINE AS NAME_ADDR_LINE                  
                FROM #CSR04701_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT RETURN_CODE    AS RETURN_CODE                             
MFA-TR*              ,STATUS_CODE    AS STATUS_CODE                             
MFA-TR*              ,NAME_ADDR_TYPE AS NAME_ADDR_TYPE                          
MFA-TR*              ,NAME_ADDR_LINE AS NAME_ADDR_LINE                          
MFA-TR*         FROM SESSION.CSR04701_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE               
                     ,:S-STATUS-CODE       AS STATUS_CODE               
                     ,:S-NAME-ADDR-TYPE    AS NAME_ADDR_TYPE            
                     ,:S-NAME-ADDR-LINE    AS NAME_ADDR_LINE            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE                       
MFA-TR*              ,:S-STATUS-CODE       AS STATUS_CODE                       
MFA-TR*              ,:S-NAME-ADDR-TYPE    AS NAME_ADDR_TYPE                    
MFA-TR*              ,:S-NAME-ADDR-LINE    AS NAME_ADDR_LINE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO                PIC X(13).                    
       01  LINK-CUSTOMER-NO               PIC X(10).                    
       01  LINK-ACCT-ARCHIVE-FLAG         PIC X(01).                    
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO                               
                          LINK-CUSTOMER-NO                              
                          LINK-ACCT-ARCHIVE-FLAG.                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                             *            
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
                                                                        
      * CHECK FOR PROCESS THE BILL-WINDOW OR MAIL-PRINT                         
           IF BILL-WINDOW-PROCESS                                       
              PERFORM 2000-PROCESS-BILL-WINDOW                          
                                              THRU 2000-EXIT            
           ELSE                                                         
              PERFORM 2100-PROCESS-MAIL-PRNT  THRU 2100-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE.                                           *            
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE WS-NO                        TO WS-GTT01-DECLARED       
                                                WS-GTT02-DECLARED.      
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0101-DECLARE-GTT01.                                        *            
      ******************************************************************        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04701_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04701_R1
              (                                                          
               RETURN_CODE          INT                             
              ,STATUS_CODE          INT                             
              ,NAME_ADDR_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,NAME_ADDR_LINE CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS   THRU 8001-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0101'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04701_R1'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                              THRU 9900-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-YES                       TO WS-GTT01-DECLARED.      
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0102-DECLARE-GTT02.                                        *            
      ******************************************************************        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04701_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04701_R2
              (                                                          
               RETURN_CODE          INT                             
              ,CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,ADDR_LINE_1 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,ADDR_LINE_2 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,ADDR_LINE_3 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,ADDR_LINE_4 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,ADDR_LINE_5 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,ADDR_LINE_6 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2                   
              ,SERV_ADDR CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,CONTACT_POSITION CHAR(30)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,CONTACT_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,ADDRESS_NAME CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,ADDRESS_TYPE CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,SERVICE_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,SERVICE_END_DATE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,MONTHS               SMALLINT                            
              ,NO_30_DAY            SMALLINT                            
              ,NO_RET_CHECKS        SMALLINT                            
              ,NO_DNP               SMALLINT                            
              ,FINAL_BILL_AMOUNT    DECIMAL(11,2)                       
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS   THRU 8002-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0102'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04701_R2'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                              THRU 9900-EXIT            
               END-IF                                                   
           END-IF.                                                      
           MOVE WS-YES                       TO WS-GTT02-DECLARED.      
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  FOR                         
               SELECT RETURN_CODE                AS RETURN_CODE         
                     ,LTRIM(RTRIM(CODE_ACCT_STAT))      AS 
           CODE_ACCT_STAT      
                     ,LTRIM(RTRIM(ACCOUNT_NO))          AS ACCOUNT_NO          
                     ,LTRIM(RTRIM(ADDR_LINE_1))         AS ADDR_LINE_1         
                     ,LTRIM(RTRIM(ADDR_LINE_2))         AS ADDR_LINE_2         
                     ,LTRIM(RTRIM(ADDR_LINE_3))         AS ADDR_LINE_3         
                     ,LTRIM(RTRIM(ADDR_LINE_4))         AS ADDR_LINE_4         
                     ,LTRIM(RTRIM(ADDR_LINE_5))         AS ADDR_LINE_5         
                     ,LTRIM(RTRIM(ADDR_LINE_6))         AS ADDR_LINE_6         
                     ,LTRIM(RTRIM(NAME))                AS NAME                
                     ,LTRIM(RTRIM(SERV_ADDR))           AS SERV_ADDR           
                     ,LTRIM(RTRIM(CONTACT_POSITION))    AS 
           CONTACT_POSITION    
                     ,LTRIM(RTRIM(CONTACT_TYPE))        AS CONTACT_TYPE        
                     ,LTRIM(RTRIM(ADDRESS_NAME))        AS ADDRESS_NAME        
                     ,LTRIM(RTRIM(ADDRESS_TYPE))        AS ADDRESS_TYPE        
                     ,LTRIM(RTRIM(SERVICE_DATE))        AS SERVICE_DATE        
                     ,LTRIM(RTRIM(SERVICE_END_DATE))    AS 
           SERVICE_END_DATE    
                     ,MONTHS                     AS MONTHS              
                     ,NO_30_DAY                  AS NO_30_DAY           
                     ,NO_RET_CHECKS              AS NO_RET_CHECKS       
                     ,NO_DNP                     AS NO_DNP              
                     ,FINAL_BILL_AMOUNT          AS FINAL_BILL_AMOUNT   
                FROM #CSR04701_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT RETURN_CODE                AS RETURN_CODE                 
MFA-TR*              ,STRIP(CODE_ACCT_STAT)      AS CODE_ACCT_STAT              
MFA-TR*              ,STRIP(ACCOUNT_NO)          AS ACCOUNT_NO                  
MFA-TR*              ,STRIP(ADDR_LINE_1)         AS ADDR_LINE_1                 
MFA-TR*              ,STRIP(ADDR_LINE_2)         AS ADDR_LINE_2                 
MFA-TR*              ,STRIP(ADDR_LINE_3)         AS ADDR_LINE_3                 
MFA-TR*              ,STRIP(ADDR_LINE_4)         AS ADDR_LINE_4                 
MFA-TR*              ,STRIP(ADDR_LINE_5)         AS ADDR_LINE_5                 
MFA-TR*              ,STRIP(ADDR_LINE_6)         AS ADDR_LINE_6                 
MFA-TR*              ,STRIP(NAME)                AS NAME                        
MFA-TR*              ,STRIP(SERV_ADDR)           AS SERV_ADDR                   
MFA-TR*              ,STRIP(CONTACT_POSITION)    AS CONTACT_POSITION            
MFA-TR*              ,STRIP(CONTACT_TYPE)        AS CONTACT_TYPE                
MFA-TR*              ,STRIP(ADDRESS_NAME)        AS ADDRESS_NAME                
MFA-TR*              ,STRIP(ADDRESS_TYPE)        AS ADDRESS_TYPE                
MFA-TR*              ,STRIP(SERVICE_DATE)        AS SERVICE_DATE                
MFA-TR*              ,STRIP(SERVICE_END_DATE)    AS SERVICE_END_DATE            
MFA-TR*              ,MONTHS                     AS MONTHS                      
MFA-TR*              ,NO_30_DAY                  AS NO_30_DAY                   
MFA-TR*              ,NO_RET_CHECKS              AS NO_RET_CHECKS               
MFA-TR*              ,NO_DNP                     AS NO_DNP                      
MFA-TR*              ,FINAL_BILL_AMOUNT          AS FINAL_BILL_AMOUNT           
MFA-TR*         FROM SESSION.CSR04701_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT.                                        *            
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES                   TO LINK-ACCOUNT-NO         
           END-IF.                                                      
           MOVE LINK-ACCOUNT-NO              TO WS-ACCOUNT-NO-CHAR.     
           MOVE WS-ACCOUNT-NO-NUM            TO AT-ACCOUNT-NO.          
           MOVE LINK-ACCT-ARCHIVE-FLAG       TO WS-ACCT-ARCHIVE-FLAG.   
           MOVE LINK-CUSTOMER-NO             TO WS-CUST-NO-CHAR.        
           MOVE WS-CUST-NO-NUM               TO AT-CUSTOMER-NO.         
                                                                        
      *SET THE FLAG OF BILL-WINDOW-PROCESS OR MAIN-PRINT-PROCESS                
           IF AT-CUSTOMER-NO GREATER THAN ZERO                          
              SET MAIL-PRINT-PROCESS TO TRUE                            
              PERFORM 0102-DECLARE-GTT02      THRU 0102-EXIT            
           ELSE                                                         
              SET BILL-WINDOW-PROCESS TO TRUE                           
              PERFORM 1200-PROCESS-BILL-WINDOW-INPUT                    
                                              THRU 1200-EXIT            
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02140013
      *                                                                *        
      *1200-PROCESS-BILL-WINDOW-INPUT                                  *02150013
      *     GET THE CURRENT DATE AND TIMESTAMP. AND VALIDATE THE INPUT *02160013
      *     ACCOUNT NO FOR BILL-WINDOW.                                *02160013
      ******************************************************************02170013
       1200-PROCESS-BILL-WINDOW-INPUT.                                  
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF LINK-ACCOUNT-NO = ZEROES                                  
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE +100                      TO S-RETURN-CODE-1         
              MOVE 'ALL PARMS ZERO'          TO S-NAME-ADDR-LINE        
              PERFORM 0101-DECLARE-GTT01      THRU 0101-EXIT            
              PERFORM 8100-SEND-RESULT-1      THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-BILL-WINDOW.                                  *            
      ******************************************************************        
       2000-PROCESS-BILL-WINDOW.                                        
                                                                        
           PERFORM 7000-SELECT-ACCOUNT        THRU 7000-EXIT.           
                                                                        
           PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT.           
                                                                        
           PERFORM VARYING SUB1 FROM 1 BY 1 UNTIL                       
               SUB1 > 6 OR WS-NAME-ADDR-TYPE (SUB1) <= SPACES           
                   INITIALIZE GTT-RETURN-FIELDS-1                       
                   MOVE WS-NAME-ADDR-TYPE (SUB1)                        
                                             TO S-NAME-ADDR-TYPE        
                   MOVE WS-NAME-ADDR-LINE (SUB1)                        
                                             TO S-NAME-ADDR-LINE        
                   IF WS-GTT01-DECLARED = WS-NO                         
                       PERFORM 0101-DECLARE-GTT01                       
                                              THRU 0101-EXIT            
                   END-IF                                               
                   PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT            
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-MAIL-PRNT.                                        *        
      ******************************************************************        
       2100-PROCESS-MAIL-PRNT.                                          
                                                                        
           IF WS-ACCT-ARCHIVE-FLAG = WS-NO                              
              PERFORM 7000-SELECT-ACCOUNT     THRU 7000-EXIT            
           ELSE                                                         
              PERFORM 7010-SELECT-HST-ACT     THRU 7010-EXIT            
              MOVE ZEROES                    TO AT-TOTAL-AR-BALANCE     
              MOVE SPACES                    TO AT-CODES-DATA-PRESENT   
           END-IF.                                                      
                                                                        
           PERFORM 2150-GET-ARREARS-DNP       THRU 2150-EXIT.           
      * PROCESS TO GET BILLING/SERVICE ADDRESS DETAILS                          
           PERFORM 2200-PROCESS-ACCT-ADDRESS THRU 2200-EXIT.            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2150-GET-ARREARS-DNP.                                          *        
      ******************************************************************        
       2150-GET-ARREARS-DNP.                                            
                                                                        
           MOVE AT-ACCOUNT-NO                TO NH-ACCOUNT-NO           
           MOVE ZEROS                        TO WS-ROW-COUNT            
           PERFORM 7700-SELECT-NSF-HIST       THRU 7700-EXIT            
           IF WS-ROW-COUNT > 0                                          
              MOVE WS-ROW-COUNT              TO WS-NO-RET-CHECKS        
           ELSE                                                         
              MOVE ZEROES                    TO WS-NO-RET-CHECKS        
           END-IF                                                       
           PERFORM 7800-GET-ARREARS           THRU 7800-EXIT            
           PERFORM 2600-CALC-NO-OF-DNPS       THRU 2600-EXIT            
           PERFORM 2650-CALC-NO-OF-30-DAY     THRU 2650-EXIT            
           IF WS-NULL-CREATE-DATE < 0                                   
              MOVE SPACES                    TO WS-SERVICE-DATE         
           ELSE                                                         
              MOVE AT-ACCT-CREATE-DT         TO WS-SELECT-DATE-FORM     
              MOVE WS-SELECT-CENT            TO WS-SELECT-CC            
              MOVE WS-SELECT-YEAR            TO WS-SELECT-YY            
              MOVE WS-SELECT-MONTH           TO WS-SELECT-MM            
              MOVE WS-SELECT-DAY             TO WS-SELECT-DD            
              MOVE WS-SELECT-DATE-USA        TO WS-SERVICE-DATE         
           END-IF                                                       
           IF WS-NULL-FINAL-DATE < 0                                    
              MOVE 'PRESENT'                 TO WS-SERV-END-DATE        
           ELSE                                                         
              MOVE AT-ACCT-FINALED-DT        TO WS-SELECT-DATE-FORM     
              MOVE WS-SELECT-CENT            TO WS-SELECT-CC            
              MOVE WS-SELECT-YEAR            TO WS-SELECT-YY            
              MOVE WS-SELECT-MONTH           TO WS-SELECT-MM            
              MOVE WS-SELECT-DAY             TO WS-SELECT-DD            
              MOVE WS-SELECT-DATE-USA        TO WS-SERV-END-DATE        
              IF AT-CODE-ACCT-STAT = 'S'                                
                  PERFORM 9500-CALL-CPD00068  THRU 9500-EXIT            
                  MOVE WS-WO-BALANCE         TO WS-FINAL-BILL-AMT       
              ELSE                                                      
                  MOVE AT-TOTAL-AR-BALANCE   TO WS-FINAL-BILL-AMT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * 2200-PROCESS-ACCT-ADDRESS.                                 *            
      ******************************************************************        
       2200-PROCESS-ACCT-ADDRESS.                                       
                                                                        
           PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT.           
                                                                        
      * LOAD THE BILLING ADDRESS DETAILS                                        
           PERFORM 2300-LOAD-BILLING-ADDRESS  THRU 2300-EXIT.           
                                                                        
      * PROCESS TO GET SERVICE ADDRESS DETAILS                                  
           PERFORM 2400-PROCESS-SERVICE-ADDRESS                         
                                              THRU 2400-EXIT.           
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-LOAD-BILLING-ADDRESS.                                     *        
      ******************************************************************        
       2300-LOAD-BILLING-ADDRESS.                                       
                                                                        
           MOVE SPACES                       TO CV-CONTACT-TYPE         
                                             CV-CONTACT-POSITION-TEXT.  
           MOVE WS-BILLING-ADDRESS           TO WS-ADDRESS-TYPE.        
                                                                        
           PERFORM 2900-LOAD-NAME-AND-ADDRESS THRU 2900-EXIT.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02140013
      *                                                                *        
      * 2400-PROCESS-SERVICE-ADDRESS                                   *02150013
      ******************************************************************02170013
       2400-PROCESS-SERVICE-ADDRESS.                                    
                                                                        
           PERFORM 7020-SELECT-PREMISE-ADDR   THRU 7020-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              PERFORM 4050-GET-FORMATTED-ADDRESS                        
                                              THRU 4050-EXIT            
              PERFORM 4030-LOAD-NAME-ADDR     THRU 4030-EXIT            
              MOVE SPACES                    TO                         
                                             CV-CONTACT-TYPE            
                                             CV-CONTACT-POSITION-TEXT   
              MOVE WS-SERVICE-ADDRESS        TO WS-ADDRESS-TYPE         
              PERFORM 2900-LOAD-NAME-AND-ADDRESS                        
                                              THRU 2900-EXIT            
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2600-CALC-NO-OF-DNPS.                                      *            
      ******************************************************************        
                                                                        
       2600-CALC-NO-OF-DNPS.                                            
                                                                        
           MOVE CZ-DISCONNECT-HIST           TO WS-DISC-HIST.           
           MOVE CZ-DISC-EXCEPTN-HIST         TO WS-EXCEPTIONAL-HIST.    
           MOVE 0                            TO WS-NO-DNP.              
           MOVE 1                            TO WS-PREV-MNTH.           
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
                                                                        
              IF WS-DISC-HIST-BRKDWN(WS-PREV-MNTH) = '4'                
                 ADD 1                       TO WS-NO-DNP               
              END-IF                                                    
                                                                        
              IF WS-EXCEPTIONAL-HIST-BRKDWN(WS-PREV-MNTH) = '4'         
                 ADD 1                       TO WS-NO-DNP               
              END-IF                                                    
                                                                        
              ADD 1                          TO WS-PREV-MNTH            
                                                                        
           END-PERFORM.                                                 
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2650-CALC-NO-OF-30-DAY.                                    *            
      ******************************************************************        
       2650-CALC-NO-OF-30-DAY.                                          
                                                                        
           MOVE CZ-ARREARS-HIST              TO WS-ARREARS-HIST.        
           MOVE 0                            TO WS-NO-30-DAY.           
           MOVE 1                            TO WS-PREV-MNTH.           
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
                                                                        
              IF WS-ARREARS-HIST-BRKDWN(WS-PREV-MNTH) > 0               
                 ADD 1                       TO WS-NO-30-DAY            
              END-IF                                                    
                                                                        
              IF WS-ARREARS-HIST-BRKDWN(WS-PREV-MNTH) <= SPACES         
                 CONTINUE                                               
              ELSE                                                      
                 ADD 1                       TO WS-ARREARS-HIST-O       
              END-IF                                                    
                                                                        
              ADD 1                          TO WS-PREV-MNTH            
                                                                        
           END-PERFORM.                                                 
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02140013
      *                                                                *        
      * 2900-LOAD-NAME-AND-ADDRESS                                     *02150013
      *     SELECT THE ADDRESS TYPE AND FORMAT IT TO BE RETURNED TO    *02160013
      *     CIS MOD                                                    *02160013
      ******************************************************************02170013
       2900-LOAD-NAME-AND-ADDRESS.                                      
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
           MOVE RS-RETURN-CODE               TO S-RETURN-CODE-2.        
           MOVE AT-CODE-ACCT-STAT            TO S-CODE-ACCT-STAT.       
                                                                        
           MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO-NUM.      
                                                                        
           MOVE WS-ACCOUNT-NO-CHAR           TO S-ACCOUNT-NO.           
           MOVE WS-NAME-ADDR-LINE (1)        TO S-ADDR-LINE-1.          
                                                                        
           MOVE WS-ADDRESS-TYPE              TO S-ADDRESS-TYPE.         
                                                                        
ACT209     MOVE WS-NAME-ADDR-LINE (2)        TO S-ADDR-LINE-2.          
ACT209     MOVE WS-NAME-ADDR-LINE (3)        TO S-ADDR-LINE-3.          
                                                                        
           MOVE WS-NAME-ADDR-LINE (4)        TO S-ADDR-LINE-4.          
           MOVE WS-NAME-ADDR-LINE (5)        TO S-ADDR-LINE-5.          
           MOVE WS-NAME-ADDR-LINE (6)        TO S-ADDR-LINE-6.          
                                                                        
           IF WS-SALUTATION-NAME(1:3) = 'MR ' OR                        
              WS-SALUTATION-NAME(1:4) = 'MRS ' OR                       
              WS-SALUTATION-NAME(1:5) = 'MISS '                         
                  PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL             
                              WS-SUB1 > +6                              
                      IF WS-NAME-ADDR-TYPE(WS-SUB1) = 'CN'              
                         MOVE WS-NAME-ADDR-LINE(WS-SUB1) TO S-NAME      
                         MOVE +7                         TO WS-SUB1     
                      END-IF                                            
                  END-PERFORM                                           
                  IF S-NAME <= SPACES                                   
                     MOVE WS-SALUTATION-NAME                            
                                             TO S-NAME                  
                  END-IF                                                
           ELSE                                                         
               MOVE WS-SALUTATION-NAME       TO S-NAME                  
           END-IF.                                                      
                                                                        
           MOVE WS-PREMISE-ADDR              TO S-SERV-ADDR.            
           MOVE CV-CONTACT-TYPE              TO S-CONTACT-TYPE.         
           MOVE CV-CONTACT-POSITION-TEXT     TO S-CONTACT-POSITION.     
           MOVE SPACES                       TO S-ADDRESS-NAME.         
                                                                        
           MOVE WS-SERVICE-DATE              TO S-SERVICE-DATE.         
           MOVE WS-SERV-END-DATE             TO S-SERV-END-DATE.        
           MOVE WS-ARREARS-HIST-O            TO S-ARREARS-HIST.         
           MOVE WS-NO-30-DAY                 TO S-NO-30-DAY.            
           MOVE WS-NO-RET-CHECKS             TO S-NO-RET-CHECKS.        
           MOVE WS-NO-DNP                    TO S-NO-DNP.               
           MOVE WS-FINAL-BILL-AMT            TO S-FINAL-BILL-AMT.       
                                                                        
           IF(S-ADDR-LINE-3     >  SPACES) AND                          
             (S-SERV-ADDR       >  SPACES)                              
              PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
           END-IF.                                                      
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 4060-GET-NAME.                                                 *        
      * 4022-SALUTATION-NAME.                                          *        
      * 4090-SELECT-ADDR-FREEFORM.                                     *        
      * 4030-LOAD-NAME-ADDR.                                           *        
      * 4000-MAIL-NAME-ADDRESS.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00004                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-SELECT-ACCOUNT.                                       *            
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AT.CUSTOMER_NO,
              AT.PREMISE_NO,
              AT.COMPANY_NO,
              AT.ADDRESS_ID,
              AT.ADDRESS_FORMAT,
              REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,
              AT.TOTAL_AR_BALANCE,
              AT.CODES_DATA_PRESENT,
              AT.CODE_ACCT_STAT                                  
                INTO :AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:AT-ACCT-CREATE-DT :WS-NULL-CREATE-DATE             
                    ,:AT-ACCT-FINALED-DT :WS-NULL-FINAL-DATE             
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-CODE-ACCT-STAT                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                 AND AT.ACCOUNT_NO = HT.ACCOUNT_NO                      
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*             ,AT.ACCT_CREATE_DT                                          
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*         INTO :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-ADDRESS-ID                                             
MFA-TR*             ,:AT-ADDRESS-FORMAT                                         
MFA-TR*             ,:AT-ACCT-CREATE-DT:WS-NULL-CREATE-DATE                     
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-NULL-FINAL-DATE                     
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_NAME_ACCT_XREF HT                                      
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*          AND AT.ACCOUNT_NO = HT.ACCOUNT_NO                              
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7010-SELECT-HST-ACT.                                       *            
      ******************************************************************        
       7010-SELECT-HST-ACT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AT.CUSTOMER_NO,
              AT.PREMISE_NO,
              AT.COMPANY_NO,
              AT.ADDRESS_ID,
              AT.ADDRESS_FORMAT,
              AT.ACCT_CREATE_DT,
              AT.ACCT_FINALED_DT,
              AT.CODE_ACCT_STAT                                  
                INTO :AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:AT-ACCT-CREATE-DT :WS-NULL-CREATE-DATE             
                    ,:AT-ACCT-FINALED-DT :WS-NULL-FINAL-DATE             
                    ,:AT-CODE-ACCT-STAT                                 
                FROM HST_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                 AND AT.ACCOUNT_NO = HT.ACCOUNT_NO                      
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*             ,AT.ACCT_CREATE_DT                                          
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*         INTO :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-ADDRESS-ID                                             
MFA-TR*             ,:AT-ADDRESS-FORMAT                                         
MFA-TR*             ,:AT-ACCT-CREATE-DT:WS-NULL-CREATE-DATE                     
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-NULL-FINAL-DATE                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM HST_ACCOUNT AT                                             
MFA-TR*             ,CSS_NAME_ACCT_XREF HT                                      
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*          AND AT.ACCOUNT_NO = HT.ACCOUNT_NO                              
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'HST_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7020-SELECT-PREMISE-ADDR.                                  *            
      ******************************************************************        
       7020-SELECT-PREMISE-ADDR.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT PR.ADDRESS_ID                                      
                INTO :PR-ADDRESS-ID                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE AT.PREMISE_NO = PR.PREMISE_NO                      
                 AND AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.ADDRESS_ID                                              
MFA-TR*         INTO :PR-ADDRESS-ID                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_PREMISE PR                                             
MFA-TR*        WHERE AT.PREMISE_NO = PR.PREMISE_NO                              
MFA-TR*          AND AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'CSS_ACCOUNT'             TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7700-SELECT-NSF-HIST.                                          *        
      ******************************************************************        
       7700-SELECT-NSF-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-ROW-COUNT                                      
                FROM CSS_NSF_HIST NH WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
                 AND NSF_STATUS_CD = 'C'                                
                 AND DATE_TRAN     > DATEADD( YEAR, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-ROW-COUNT                                              
MFA-TR*         FROM CSS_NSF_HIST NH                                            
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                             
MFA-TR*          AND NSF_STATUS_CD = 'C'                                        
MFA-TR*          AND DATE_TRAN     > CURRENT DATE - 1 YEAR                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7700'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_NSF_HIST'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE NH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7800-GET-ARREARS.                                              *        
      ******************************************************************        
       7800-GET-ARREARS.                                                
                                                                        
           EXEC SQL                                                     
              SELECT CZ.ARREARS_HIST                                    
                    ,CZ.DISCONNECT_HIST                                 
                    ,CZ.DISC_EXCEPTN_HIST                               
                INTO :CZ-ARREARS-HIST                                   
                    ,:CZ-DISCONNECT-HIST                                
                    ,:CZ-DISC-EXCEPTN-HIST                              
                FROM CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                
               WHERE CZ.ACCOUNT_NO  =  :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CZ.ARREARS_HIST                                            
MFA-TR*             ,CZ.DISCONNECT_HIST                                         
MFA-TR*             ,CZ.DISC_EXCEPTN_HIST                                       
MFA-TR*         INTO :CZ-ARREARS-HIST                                           
MFA-TR*             ,:CZ-DISCONNECT-HIST                                        
MFA-TR*             ,:CZ-DISC-EXCEPTN-HIST                                      
MFA-TR*         FROM CSS_CREDIT_PROFILE CZ                                      
MFA-TR*        WHERE CZ.ACCOUNT_NO  =  :AT-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CREDIT_PROFILE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      * 8001-DELETE-GTT1-ROWS.                                         *        
      ******************************************************************        
       8001-DELETE-GTT1-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04701_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04701_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '8001'               TO ACTIVE-PARAGRAPH        
                   MOVE 'DELETE'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04701_R1'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8002-DELETE-GTT2-ROWS.                                     *            
      ******************************************************************        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04701_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04701_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8002'              TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04701_R2'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND                          
                                              THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT-1.                                            *        
      ******************************************************************        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04701_R1                            
             (                                                          
              RETURN_CODE                                               
             ,STATUS_CODE                                               
             ,NAME_ADDR_TYPE                                            
             ,NAME_ADDR_LINE                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1                                         
              ,:S-STATUS-CODE                                           
              ,:S-NAME-ADDR-TYPE                                        
              ,:S-NAME-ADDR-LINE                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04701_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,STATUS_CODE                                                       
MFA-TR*      ,NAME_ADDR_TYPE                                                    
MFA-TR*      ,NAME_ADDR_LINE                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1                                                 
MFA-TR*       ,:S-STATUS-CODE                                                   
MFA-TR*       ,:S-NAME-ADDR-TYPE                                                
MFA-TR*       ,:S-NAME-ADDR-LINE                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04701_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           ADD WS-ONE                        TO CTR-ROWS.               
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-SEND-RESULT-2.                                            *        
      ******************************************************************        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04701_R2                            
             (                                                          
              RETURN_CODE                                               
             ,CODE_ACCT_STAT                                            
             ,ACCOUNT_NO                                                
             ,ADDR_LINE_1                                               
             ,ADDR_LINE_2                                               
             ,ADDR_LINE_3                                               
             ,ADDR_LINE_4                                               
             ,ADDR_LINE_5                                               
             ,ADDR_LINE_6                                               
             ,NAME                                                      
             ,SERV_ADDR                                                 
             ,CONTACT_POSITION                                          
             ,CONTACT_TYPE                                              
             ,ADDRESS_NAME                                              
             ,ADDRESS_TYPE                                              
             ,SERVICE_DATE                                              
             ,SERVICE_END_DATE                                          
             ,MONTHS                                                    
             ,NO_30_DAY                                                 
             ,NO_RET_CHECKS                                             
             ,NO_DNP                                                    
             ,FINAL_BILL_AMOUNT                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2                                         
              ,:S-CODE-ACCT-STAT                                        
              ,:S-ACCOUNT-NO                                            
              ,:S-ADDR-LINE-1                                           
              ,:S-ADDR-LINE-2                                           
              ,:S-ADDR-LINE-3                                           
              ,:S-ADDR-LINE-4                                           
              ,:S-ADDR-LINE-5                                           
              ,:S-ADDR-LINE-6                                           
              ,:S-NAME                                                  
              ,:S-SERV-ADDR                                             
              ,:S-CONTACT-POSITION                                      
              ,:S-CONTACT-TYPE                                          
              ,:S-ADDRESS-NAME                                          
              ,:S-ADDRESS-TYPE                                          
              ,:S-SERVICE-DATE                                          
              ,:S-SERV-END-DATE                                         
              ,:S-ARREARS-HIST                                          
              ,:S-NO-30-DAY                                             
              ,:S-NO-RET-CHECKS                                         
              ,:S-NO-DNP                                                
              ,:S-FINAL-BILL-AMT                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04701_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CODE_ACCT_STAT                                                    
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,ADDR_LINE_1                                                       
MFA-TR*      ,ADDR_LINE_2                                                       
MFA-TR*      ,ADDR_LINE_3                                                       
MFA-TR*      ,ADDR_LINE_4                                                       
MFA-TR*      ,ADDR_LINE_5                                                       
MFA-TR*      ,ADDR_LINE_6                                                       
MFA-TR*      ,NAME                                                              
MFA-TR*      ,SERV_ADDR                                                         
MFA-TR*      ,CONTACT_POSITION                                                  
MFA-TR*      ,CONTACT_TYPE                                                      
MFA-TR*      ,ADDRESS_NAME                                                      
MFA-TR*      ,ADDRESS_TYPE                                                      
MFA-TR*      ,SERVICE_DATE                                                      
MFA-TR*      ,SERVICE_END_DATE                                                  
MFA-TR*      ,MONTHS                                                            
MFA-TR*      ,NO_30_DAY                                                         
MFA-TR*      ,NO_RET_CHECKS                                                     
MFA-TR*      ,NO_DNP                                                            
MFA-TR*      ,FINAL_BILL_AMOUNT                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2                                                 
MFA-TR*       ,:S-CODE-ACCT-STAT                                                
MFA-TR*       ,:S-ACCOUNT-NO                                                    
MFA-TR*       ,:S-ADDR-LINE-1                                                   
MFA-TR*       ,:S-ADDR-LINE-2                                                   
MFA-TR*       ,:S-ADDR-LINE-3                                                   
MFA-TR*       ,:S-ADDR-LINE-4                                                   
MFA-TR*       ,:S-ADDR-LINE-5                                                   
MFA-TR*       ,:S-ADDR-LINE-6                                                   
MFA-TR*       ,:S-NAME                                                          
MFA-TR*       ,:S-SERV-ADDR                                                     
MFA-TR*       ,:S-CONTACT-POSITION                                              
MFA-TR*       ,:S-CONTACT-TYPE                                                  
MFA-TR*       ,:S-ADDRESS-NAME                                                  
MFA-TR*       ,:S-ADDRESS-TYPE                                                  
MFA-TR*       ,:S-SERVICE-DATE                                                  
MFA-TR*       ,:S-SERV-END-DATE                                                 
MFA-TR*       ,:S-ARREARS-HIST                                                  
MFA-TR*       ,:S-NO-30-DAY                                                     
MFA-TR*       ,:S-NO-RET-CHECKS                                                 
MFA-TR*       ,:S-NO-DNP                                                        
MFA-TR*       ,:S-FINAL-BILL-AMT                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD WS-ONE                     TO CTR-ROWS-R2             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04701_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = WS-YES                                
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
              IF WS-GTT02-DECLARED = WS-YES                             
                  EXEC SQL                                              
                      OPEN C2                                           
                  END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                              
              ELSE                                                      
                 MOVE +100                   TO S-RETURN-CODE-1         
                 EXEC SQL                                               
                     OPEN N1                                            
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9500-CALL-CPD00068.                                            *        
      ******************************************************************        
       9500-CALL-CPD00068.                                              
                                                                        
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
           MOVE SPACES                       TO WS-HOLD-DATE.           
           MOVE 'Y'                          TO CALC-PAST-DUE-SW.       
                                                                        
           CALL WS-MCSCB068  USING CWS00068-FIELDS                      
                                   WS-CODES-DATA-PRESENT                
                                   DCLCSS-ACCOUNT                       
                                   ABEND-FILE                           
                                   RS-RETURN-CODE.                      
                                                                        
           MOVE RS-RETURN-CODE               TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-2         
                                                SQLCODE.                
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                     TO RS-RETURN-CODE          
                                                WS-ACTIVE-RETURN-CODE   
              END-IF                                                    
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '9500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CALL'                    TO ABEND-FUNCTION          
              MOVE 'MCSCB068'                TO TABLE-1                 
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT.                                    *            
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-NO                        TO SEND-DONE-SW.           
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE        TO S-RETURN-CODE-1         
                                                S-RETURN-CODE-2         
                                                ABEND-SQLCODE.          
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           IF WS-GTT02-DECLARED   = WS-YES                              
              PERFORM 0102-DECLARE-GTT02      THRU 0102-EXIT            
              PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9700-PROCESS-ABEND.                                        *            
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT.           
           PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT.           
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9900-SQL-ERROR-ROUTINE.                                    *            
      ******************************************************************        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT            
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9999-END-PROGRAM.                                          *            
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1 AND WS-GTT01-DECLARED = WS-YES               
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '9999-END-PROGRAM'        TO ABEND-FUNCTION          
              MOVE 'PROGRAMMER LOGIC'        TO TABLE-1                 
              MOVE 'FAILED TO SEND'          TO TABLE-ELEMENT-1         
              MOVE 'RESULT SET'              TO HOSTVAR-ELEMENT-1       
              MOVE -1                        TO                         
                                             WS-ACTIVE-RETURN-CODE      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              IF CTR-ROWS-R2 < 1 AND WS-GTT02-DECLARED = WS-YES         
                 INITIALIZE GTT-RETURN-FIELDS-2                         
                 MOVE 100                    TO S-RETURN-CODE-2         
                 PERFORM 8200-SEND-RESULT-2   THRU 8200-EXIT            
                 PERFORM 8900-SEND-DONE       THRU 8900-EXIT            
              ELSE                                                      
                 PERFORM 8900-SEND-DONE       THRU 8900-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
