       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04700.                                          
COB303 DATE-WRITTEN. MARCH 24, 2014.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS MESSAGE AND PERFERENCE DATA.            *        
      *  RESULTS SETS:                                                 *        
      *     1.  M&P INFORMATION                                        *        
      *     2.  PHONE NUMBERS                                          *        
      *     3.  EMAIL ADDRESSES                                        *        
      *     4.  NAMES                                                  *        
      *     5.  ADDRESSES                                              *        
      *     6.  NON-ARCHIVED ACCOUNTS FOR CUSTOMER                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/24/14    FMB      NEW PROGRAM.                                      
D05317*  11/12/15    FMB      EMAIL DATE TO TIMESTAMP.                          
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04700'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04700 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBEMAIL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACDEST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHSTNME                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04700_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04700_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04700_R3'.          
            05  GTT-NAME-4              PIC X(26) VALUE                 
                                        'SESSION.CSR04700_R4'.          
            05  GTT-NAME-5              PIC X(26) VALUE                 
                                        'SESSION.CSR04700_R5'.          
            05  GTT-NAME-6              PIC X(26) VALUE                 
                                        'SESSION.CSR04700_R6'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-LANGUAGE-PREF     PIC X(02) VALUE SPACES.           
               10 S-BILL-NOTIFICATION PIC X(01) VALUE SPACES.           
               10 S-PAYMENT-REMINDER  PIC X(01) VALUE SPACES.           
               10 S-PASSWORD          PIC X(16) VALUE SPACES.           
               10 S-PASSWORD-HINT     PIC X(100) VALUE SPACES.          
               10 S-WELCOME-KIT-CD    PIC X(01) VALUE SPACES.           
               10 S-WELCOME-DISP-FL   PIC X(01) VALUE SPACES.           
               10 S-SPECIAL-ID        PIC X(35) VALUE SPACES.           
               10 S-ACCOUNT-ID        PIC X(35) VALUE SPACES.           
               10 S-SERVICE-CARE-ID   PIC X(35) VALUE SPACES.           
               10 S-ALLOW-CALL-FL     PIC X(01) VALUE SPACES.           
               10 S-ALLOW-EMAIL-FL    PIC X(01) VALUE SPACES.           
               10 S-EMPLOYER          PIC X(23) VALUE SPACES.           
               10 S-EDI-FL            PIC X(01) VALUE SPACES.           
               10 S-DEST-ID           PIC X(10) VALUE SPACES.           
               10 S-EBILL-FL          PIC X(01) VALUE SPACES.           
               10 S-NAME-FORMAT-1     PIC X(01) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-PHONE-TYPE        PIC X(02) VALUE SPACES.           
               10 S-PHONE-NUMBER      PIC X(10) VALUE SPACES.           
               10 S-PHONE-EXT         PIC X(06) VALUE SPACES.           
               10 S-PHONE-MOBILE-FL   PIC X(01) VALUE SPACES.           
               10 S-PHONE-MKT-FL      PIC X(01) VALUE SPACES.           
               10 S-PHONE-MKT-DT      PIC X(10) VALUE SPACES.           
               10 S-PHONE-TEXT-FL     PIC X(01) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-RETURN-CODE-3     PIC S9(9) COMP VALUE 0.           
               10 S-EMAIL-ADDRESS     PIC X(100) VALUE SPACES.          
               10 S-EMAIL-TYPE-CD     PIC X(02) VALUE SPACES.           
               10 S-EMAIL-MKT-FL      PIC X(01) VALUE SPACES.           
               10 S-EMAIL-MKT-DT      PIC X(10) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-4.                                     
               10 S-RETURN-CODE-4     PIC S9(9) COMP VALUE 0.           
               10 S-NAME-ID           PIC S9(13)V COMP-3 VALUE 0.       
               10 S-NAME-TYPE         PIC X(02) VALUE SPACES.           
               10 S-NAME-FORMAT-4     PIC X(01) VALUE SPACES.           
               10 S-TITLE-PREFIX      PIC X(09) VALUE SPACES.           
               10 S-FIRST-NAME        PIC X(15) VALUE SPACES.           
               10 S-MIDDLE-NAME       PIC X(15) VALUE SPACES.           
               10 S-LAST-NAME         PIC X(40) VALUE SPACES.           
               10 S-TITLE-SUFFIX      PIC X(03) VALUE SPACES.           
               10 S-FULL-NAME         PIC X(70) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-5.                                     
               10 S-RETURN-CODE-5     PIC S9(9) COMP VALUE 0.           
               10 S-ADDRESS-TYPE      PIC X(02) VALUE SPACES.           
               10 S-ADDRESS-ID        PIC S9(13)V COMP-3 VALUE 0.       
               10 S-ADDRESS-FORMAT    PIC X(01) VALUE SPACES.           
               10 S-FREEFORM.                                           
                  15 S-FF-STREET-1    PIC X(55) VALUE SPACES.           
                  15 S-FF-STREET-2    PIC X(55) VALUE SPACES.           
                  15 S-FF-CITY-STATE  PIC X(30) VALUE SPACES.           
                  15 S-FF-ZIP-CODE    PIC X(09) VALUE SPACES.           
                  15 S-FF-COUNTRY     PIC X(35) VALUE SPACES.           
                  15 S-FF-CITY        PIC X(30) VALUE SPACES.           
                  15 S-FF-STATE       PIC X(02) VALUE SPACES.           
                  15 S-IAT-CITY       PIC X(40) VALUE SPACES.           
                  15 S-IAT-PROVINCE   PIC X(10) VALUE SPACES.           
                  15 S-IAT-POST-CODE  PIC X(25) VALUE SPACES.           
               10 S-FORMATTED.                                          
                  15 S-FMT-STREET-1   PIC X(55) VALUE SPACES.           
                  15 S-FMT-STREET-2   PIC X(55) VALUE SPACES.           
                  15 S-TOWN           PIC X(26) VALUE SPACES.           
                  15 S-STATE          PIC X(02) VALUE SPACES.           
                  15 S-ZIP-CODE       PIC X(05) VALUE SPACES.           
                  15 S-ZIP-CODE-4     PIC X(04) VALUE SPACES.           
                  15 S-ZIP-CODE-TOKEN PIC X(01) VALUE SPACES.           
                  15 S-USPS-DELIV-PT  PIC X(02) VALUE SPACES.           
                  15 S-HOUSE-NO       PIC X(15) VALUE SPACES.           
                  15 S-ADDR-PREFIX-1  PIC X(03) VALUE SPACES.           
                  15 S-ADDR-PREFIX-2  PIC X(02) VALUE SPACES.           
                  15 S-STREET-NAME    PIC X(30) VALUE SPACES.           
                  15 S-STREET-SUFFIX  PIC X(04) VALUE SPACES.           
                  15 S-ADDR-SUFFIX    PIC X(02) VALUE SPACES.           
                  15 S-STREET-LOC-1   PIC X(04) VALUE SPACES.           
                  15 S-STREET-LOC-2   PIC X(11) VALUE SPACES.           
                  15 S-PO-BOX-FL      PIC X(01) VALUE SPACES.           
                  15 S-ADDRESS-OVERFLOW PIC X(35) VALUE SPACES.         
           05  GTT-RETURN-FIELDS-6.                                     
               10 S-RETURN-CODE-6     PIC S9(9) COMP VALUE 0.           
               10 S-BA-ADDRESS-FORMAT PIC X(01) VALUE SPACES.           
               10 S-BA-ADDRESS-ID     PIC S9(13)V COMP-3 VALUE 0.       
               10 S-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.       
               10 S-SERV-ADDRESS      PIC X(80) VALUE SPACES.           
               10 S-CODE-ACCT-STAT    PIC X(01) VALUE SPACES.           
               10 S-COMPANY-NO        PIC X(02) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04700'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT04-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT06-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ADDRESS-LINE-1        PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-2        PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-CD            PIC X(02) VALUE SPACES.         
           05  WS-CUT-OFF-DT            PIC X(10) VALUE SPACES.         
           05  WS-LAST-WKIT-DT          PIC X(10) VALUE SPACES.         
           05  WS-WELCOME-DISP-FL       PIC X(10) VALUE SPACES.         
           05  WS-MASK-SSN-CUST-DAYS    PIC 9(09) VALUE 0.              
           05  WS-MASK-SSN-SCORE-HOURS  PIC 9(09) VALUE 0.              
           05  WS-CURRENT-DT-NUM        PIC 9(08) VALUE 0.              
           05  WS-CURRENT-HR-NUM        PIC 9(08) VALUE 0.              
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-I        PIC X(80) VALUE SPACES.         
           05  WS-DATE.                                                 
               10  WS-DATE-YYYY         PIC X(04).                      
               10  WS-DATE-MM           PIC X(02).                      
               10  WS-DATE-DD           PIC X(02).                      
           05  WS-DATE-R REDEFINES WS-DATE PIC 9(08).                   
           05  WS-DAYS                  PIC 9(09) VALUE 0.              
           05  WS-HOURS                 PIC S9(09) VALUE 0.             
           05  WS-SUB1                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUB2                  PIC S9(4) COMP VALUE 0.         
           05  WS-ARCHIVED-ACCOUNT      PIC X(01) VALUE 'N'.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  CSR01416-CALL-DATA.                                          
           05  INPUT-DATE-1416           PIC X(26) VALUE SPACES.        
           05  BUSINESS-DAYS-1416        PIC S9(4) COMP VALUE 0.        
                                                                        
       01  CSR01416-RETURN-DATA.                                        
           05  OUTPUT-DATE-1416          PIC X(26) VALUE SPACES.        
                                                                        
      *01 LOC1416 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE PHONE-CURSOR CURSOR FOR                           
               SELECT PHONE_TYPE,                                       
                      PHONE_NO,                                         
                      EXTENSION_NO,                                     
                      MOBILE_PHONE_FL,                                  
                      PERMISN_TO_MKT_FL,                                
                      PERMISN_TO_MKT_DT,                                
                      PERMISN_TO_TEXT_FL                                
                 FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = 'C'                               
                  AND PHONE_TYPE IN ('A1', 'H1', 'W1')                  
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PHONE-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT PHONE_TYPE,                                               
MFA-TR*               PHONE_NO,                                                 
MFA-TR*               EXTENSION_NO,                                             
MFA-TR*               MOBILE_PHONE_FL,                                          
MFA-TR*               PERMISN_TO_MKT_FL,                                        
MFA-TR*               PERMISN_TO_MKT_DT,                                        
MFA-TR*               PERMISN_TO_TEXT_FL                                        
MFA-TR*          FROM CSS_CUST_PHONE                                            
MFA-TR*         WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = 'C'                                       
MFA-TR*           AND PHONE_TYPE IN ('A1', 'H1', 'W1')                          
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE EMAIL-CURSOR CURSOR FOR                           
               SELECT EMAIL_TYPE_CD,                                    
                      EMAIL_ADDRESS_TX,                                 
                      PERMISN_TO_MKT_FL,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           PERMISN_TO_MKT_TS, 121), ' ', '-'), ':', '.') 
           PERMISN_TO_MKT_TS                                 
                 FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                     
                  AND EMAIL_TYPE_CD LIKE 'P%'                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EMAIL-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT EMAIL_TYPE_CD,                                            
MFA-TR*               EMAIL_ADDRESS_TX,                                         
MFA-TR*               PERMISN_TO_MKT_FL,                                        
MFA-TR*               PERMISN_TO_MKT_TS                                         
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD LIKE 'P%'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE NAME-CURSOR CURSOR FOR                            
               SELECT AB.NAME_TYPE,                                     
                      AB.NAME_ID,                                       
                      NAME_FORMAT,                                      
                      TITLE_PREFIX,                                     
                      FIRST_NAME,                                       
                      MIDDLE_NAME,                                      
                      LAST_NAME,                                        
                      TITLE_SUFFIX_1,                                   
                      FULL_NAME                                         
                 FROM CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AB-ACCOUNT-NO                       
                  AND AB.NAME_ID = DQ.NAME_ID                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE NAME-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT AB.NAME_TYPE,                                             
MFA-TR*               AB.NAME_ID,                                               
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               TITLE_PREFIX,                                             
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               FULL_NAME                                                 
MFA-TR*          FROM CSS_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AB-ACCOUNT-NO                               
MFA-TR*           AND AB.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7520                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE H-NAME-CURSOR CURSOR FOR                          
               SELECT AB.NAME_TYPE,                                     
                      AB.NAME_ID,                                       
                      NAME_FORMAT,                                      
                      TITLE_PREFIX,                                     
                      FIRST_NAME,                                       
                      MIDDLE_NAME,                                      
                      LAST_NAME,                                        
                      TITLE_SUFFIX_1,                                   
                      FULL_NAME                                         
                 FROM HST_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AB-ACCOUNT-NO                       
                  AND AB.NAME_ID = DQ.NAME_ID                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE H-NAME-CURSOR CURSOR FOR                                  
MFA-TR*        SELECT AB.NAME_TYPE,                                             
MFA-TR*               AB.NAME_ID,                                               
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               TITLE_PREFIX,                                             
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               FULL_NAME                                                 
MFA-TR*          FROM HST_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AB-ACCOUNT-NO                               
MFA-TR*           AND AB.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7525                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ACCT-CURSOR CURSOR FOR                            
               SELECT AT.ADDRESS_FORMAT,                                
                      AT.ADDRESS_ID,                                    
                      ACCOUNT_NO,                                       
                      CODE_ACCT_STAT,                                   
                      AT.COMPANY_NO,                                    
                      PR.ADDRESS_ID                                     
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND AT.PREMISE_NO = PR.PREMISE_NO                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT AT.ADDRESS_FORMAT,                                        
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               PR.ADDRESS_ID                                             
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_PREMISE PR                                            
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND AT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7530                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CD,                
                      :S-LANGUAGE-PREF     AS LANGUAGE_PREF,            
                      :S-BILL-NOTIFICATION AS BILL_NOTIFICATION,        
                      :S-PAYMENT-REMINDER  AS PAYMENT_REMINDER,         
                      :S-PASSWORD          AS PASSWORD,                 
                      :S-PASSWORD-HINT     AS PASSWORD_HINT,            
                      :S-WELCOME-KIT-CD    AS WELCOME_KIT_CD,           
                      :S-WELCOME-DISP-FL   AS WELCOME_KIT_DISP_FL,      
                      :S-SPECIAL-ID        AS SPECIAL_ID,               
                      :S-ACCOUNT-ID        AS ACCOUNT_ID,               
                      :S-SERVICE-CARE-ID   AS [SERVICE-CARE_ID],          
                      :S-ALLOW-CALL-FL     AS ALLOW_CALL_FL,            
                      :S-ALLOW-EMAIL-FL    AS ALLOW_EMAIL_FL,           
                      :S-EMPLOYER          AS EMPLOYER,                 
                      :S-EDI-FL            AS EDI_FL,                   
                      :S-DEST-ID           AS DEST_ID,                  
                      :S-EBILL-FL          AS EBILL_FL,                 
                      :S-NAME-FORMAT-1     AS CUST_NAME_FORMAT          
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CD,                        
MFA-TR*               :S-LANGUAGE-PREF     AS LANGUAGE_PREF,                    
MFA-TR*               :S-BILL-NOTIFICATION AS BILL_NOTIFICATION,                
MFA-TR*               :S-PAYMENT-REMINDER  AS PAYMENT_REMINDER,                 
MFA-TR*               :S-PASSWORD          AS PASSWORD,                         
MFA-TR*               :S-PASSWORD-HINT     AS PASSWORD_HINT,                    
MFA-TR*               :S-WELCOME-KIT-CD    AS WELCOME_KIT_CD,                   
MFA-TR*               :S-WELCOME-DISP-FL   AS WELCOME_KIT_DISP_FL,              
MFA-TR*               :S-SPECIAL-ID        AS SPECIAL_ID,                       
MFA-TR*               :S-ACCOUNT-ID        AS ACCOUNT_ID,                       
MFA-TR*               :S-SERVICE-CARE-ID   AS SERVICE-CARE_ID,                  
MFA-TR*               :S-ALLOW-CALL-FL     AS ALLOW_CALL_FL,                    
MFA-TR*               :S-ALLOW-EMAIL-FL    AS ALLOW_EMAIL_FL,                   
MFA-TR*               :S-EMPLOYER          AS EMPLOYER,                         
MFA-TR*               :S-EDI-FL            AS EDI_FL,                           
MFA-TR*               :S-DEST-ID           AS DEST_ID,                          
MFA-TR*               :S-EBILL-FL          AS EBILL_FL,                         
MFA-TR*               :S-NAME-FORMAT-1     AS CUST_NAME_FORMAT                  
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      PHONE_TYPE        AS PHONE_TYPE,                  
                      PHONE_NUMBER      AS PHONE_NUMBER,                
                      PHONE_EXT         AS PHONE_EXT,                   
                      PHONE_MOBILE_FL   AS PHONE_MOBILE_FL,             
                      PHONE_MKT_FL      AS PHONE_MKT_FL,                
                      PHONE_MKT_DT      AS PHONE_MKT_DT,                
                      PHONE_TEXT_FL     AS PHONE_TEXT_FL                
                FROM #CSR04700_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               PHONE_TYPE        AS PHONE_TYPE,                          
MFA-TR*               PHONE_NUMBER      AS PHONE_NUMBER,                        
MFA-TR*               PHONE_EXT         AS PHONE_EXT,                           
MFA-TR*               PHONE_MOBILE_FL   AS PHONE_MOBILE_FL,                     
MFA-TR*               PHONE_MKT_FL      AS PHONE_MKT_FL,                        
MFA-TR*               PHONE_MKT_DT      AS PHONE_MKT_DT,                        
MFA-TR*               PHONE_TEXT_FL     AS PHONE_TEXT_FL                        
MFA-TR*         FROM SESSION.CSR04700_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-PHONE-TYPE        AS PHONE_TYPE,               
                      :S-PHONE-NUMBER      AS PHONE_NUMBER,             
                      :S-PHONE-EXT         AS PHONE_EXT,                
                      :S-PHONE-MOBILE-FL   AS PHONE_MOBILE_FL,          
                      :S-PHONE-MKT-FL      AS PHONE_MKT_FL,             
                      :S-PHONE-MKT-DT      AS PHONE_MKT_DT,             
                      :S-PHONE-TEXT-FL     AS PHONE_TEXT_FL             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-PHONE-TYPE        AS PHONE_TYPE,                       
MFA-TR*               :S-PHONE-NUMBER      AS PHONE_NUMBER,                     
MFA-TR*               :S-PHONE-EXT         AS PHONE_EXT,                        
MFA-TR*               :S-PHONE-MOBILE-FL   AS PHONE_MOBILE_FL,                  
MFA-TR*               :S-PHONE-MKT-FL      AS PHONE_MKT_FL,                     
MFA-TR*               :S-PHONE-MKT-DT      AS PHONE_MKT_DT,                     
MFA-TR*               :S-PHONE-TEXT-FL     AS PHONE_TEXT_FL                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      EMAIL_ADDRESS     AS EMAIL_ADDRESS,               
                      EMAIL_TYPE_CD     AS EMAIL_TYPE_CD,               
                      EMAIL_MKT_FL      AS EMAIL_MKT_FL,                
                      EMAIL_MKT_DT      AS EMAIL_MKT_DT                 
                FROM #CSR04700_R3                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               EMAIL_ADDRESS     AS EMAIL_ADDRESS,                       
MFA-TR*               EMAIL_TYPE_CD     AS EMAIL_TYPE_CD,                       
MFA-TR*               EMAIL_MKT_FL      AS EMAIL_MKT_FL,                        
MFA-TR*               EMAIL_MKT_DT      AS EMAIL_MKT_DT                         
MFA-TR*         FROM SESSION.CSR04700_R3                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE,              
                      :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,            
                      :S-EMAIL-TYPE-CD     AS EMAIL_TYPE_CD,            
                      :S-EMAIL-MKT-FL      AS EMAIL_MKT_FL,             
                      :S-EMAIL-MKT-DT      AS EMAIL_MKT_DT              
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                      
MFA-TR*               :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,                    
MFA-TR*               :S-EMAIL-TYPE-CD     AS EMAIL_TYPE_CD,                    
MFA-TR*               :S-EMAIL-MKT-FL      AS EMAIL_MKT_FL,                     
MFA-TR*               :S-EMAIL-MKT-DT      AS EMAIL_MKT_DT                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      NAME_ID           AS NAME_ID,                     
                      NAME_TYPE         AS NAME_TYPE,                   
                      NAME_FORMAT       AS NAME_FORMAT,                 
                      TITLE_PREFIX      AS TITLE_PREFIX,                
                      FIRST_NAME        AS FIRST_NAME,                  
                      MIDDLE_NAME       AS MIDDLE_NAME,                 
                      LAST_NAME         AS LAST_NAME,                   
                      TITLE_SUFFIX      AS TITLE_SUFFIX,                
                      FULL_NAME         AS FULL_NAME                    
                FROM #CSR04700_R4                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               NAME_ID           AS NAME_ID,                             
MFA-TR*               NAME_TYPE         AS NAME_TYPE,                           
MFA-TR*               NAME_FORMAT       AS NAME_FORMAT,                         
MFA-TR*               TITLE_PREFIX      AS TITLE_PREFIX,                        
MFA-TR*               FIRST_NAME        AS FIRST_NAME,                          
MFA-TR*               MIDDLE_NAME       AS MIDDLE_NAME,                         
MFA-TR*               LAST_NAME         AS LAST_NAME,                           
MFA-TR*               TITLE_SUFFIX      AS TITLE_SUFFIX,                        
MFA-TR*               FULL_NAME         AS FULL_NAME                            
MFA-TR*         FROM SESSION.CSR04700_R4                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N4 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-4     AS RETURN_CODE,              
                      :S-NAME-ID           AS NAME_ID,                  
                      :S-NAME-TYPE         AS NAME_TYPE,                
                      :S-NAME-FORMAT-4     AS NAME_FORMAT,              
                      :S-TITLE-PREFIX      AS TITLE_PREFIX,             
                      :S-FIRST-NAME        AS FIRST_NAME,               
                      :S-MIDDLE-NAME       AS MIDDLE_NAME,              
                      :S-LAST-NAME         AS LAST_NAME,                
                      :S-TITLE-SUFFIX      AS TITLE_SUFFIX,             
                      :S-FULL-NAME         AS FULL_NAME                 
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-4     AS RETURN_CODE,                      
MFA-TR*               :S-NAME-ID           AS NAME_ID,                          
MFA-TR*               :S-NAME-TYPE         AS NAME_TYPE,                        
MFA-TR*               :S-NAME-FORMAT-4     AS NAME_FORMAT,                      
MFA-TR*               :S-TITLE-PREFIX      AS TITLE_PREFIX,                     
MFA-TR*               :S-FIRST-NAME        AS FIRST_NAME,                       
MFA-TR*               :S-MIDDLE-NAME       AS MIDDLE_NAME,                      
MFA-TR*               :S-LAST-NAME         AS LAST_NAME,                        
MFA-TR*               :S-TITLE-SUFFIX      AS TITLE_SUFFIX,                     
MFA-TR*               :S-FULL-NAME         AS FULL_NAME                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C5 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      ADDRESS_TYPE      AS ADDRESS_TYPE,                
                      ADDRESS_ID        AS ADDRESS_ID,                  
                      ADDRESS_FORMAT    AS ADDRESS_FORMAT,              
                      FF_STREET_1       AS FF_STREET_1,                 
                      FF_STREET_2       AS FF_STREET_2,                 
                      FF_CITY_STATE     AS FF_CITY_STATE,               
                      FF_ZIP_CODE       AS FF_ZIP_CODE,                 
                      FF_COUNTRY        AS FF_COUNTRY,                  
                      FF_CITY           AS FF_CITY,                     
                      FF_STATE          AS FF_STATE,                    
                      IAT_CITY          AS IAT_CITY,                    
                      IAT_PROVINCE      AS IAT_PROVINCE,                
                      IAT_POST_CODE     AS IAT_POST_CODE,               
                      FMT_STREET_1      AS FMT_STREET_1,                
                      FMT_STREET_2      AS FMT_STREET_2,                
                      TOWN              AS TOWN,                        
                      STATE             AS STATE,                       
                      ZIP_CODE          AS ZIP_CODE,                    
                      ZIP_CODE_PLUS_FOUR AS ZIP_CODE_PLUS_FOUR,         
                      ZIP_CODE_TOKEN    AS ZIP_CODE_TOKEN,              
                      DELIV_PT          AS DELIV_PT,                    
                      HOUSE_NO          AS HOUSE_NO,                    
                      ADDR_PREFIX_1     AS ADDR_PREFIX_1,               
                      ADDR_PREFIX_2     AS ADDR_PREFIX_2,               
                      STREET_NAME       AS STREET_NAME,                 
                      STREET_SUFFIX     AS STREET_SUFFIX,               
                      ADDR_SUFFIX       AS ADDR_SUFFIX,                 
                      STREET_LOC_1      AS STREET_LOC_1,                
                      STREET_LOC_2      AS STREET_LOC_2,                
                      PO_BOX_FL         AS PO_BOX_FL,                   
                      ADDRESS_OVERFLOW  AS ADDRESS_OVERFLOW             
                FROM #CSR04700_R5                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               ADDRESS_TYPE      AS ADDRESS_TYPE,                        
MFA-TR*               ADDRESS_ID        AS ADDRESS_ID,                          
MFA-TR*               ADDRESS_FORMAT    AS ADDRESS_FORMAT,                      
MFA-TR*               FF_STREET_1       AS FF_STREET_1,                         
MFA-TR*               FF_STREET_2       AS FF_STREET_2,                         
MFA-TR*               FF_CITY_STATE     AS FF_CITY_STATE,                       
MFA-TR*               FF_ZIP_CODE       AS FF_ZIP_CODE,                         
MFA-TR*               FF_COUNTRY        AS FF_COUNTRY,                          
MFA-TR*               FF_CITY           AS FF_CITY,                             
MFA-TR*               FF_STATE          AS FF_STATE,                            
MFA-TR*               IAT_CITY          AS IAT_CITY,                            
MFA-TR*               IAT_PROVINCE      AS IAT_PROVINCE,                        
MFA-TR*               IAT_POST_CODE     AS IAT_POST_CODE,                       
MFA-TR*               FMT_STREET_1      AS FMT_STREET_1,                        
MFA-TR*               FMT_STREET_2      AS FMT_STREET_2,                        
MFA-TR*               TOWN              AS TOWN,                                
MFA-TR*               STATE             AS STATE,                               
MFA-TR*               ZIP_CODE          AS ZIP_CODE,                            
MFA-TR*               ZIP_CODE_PLUS_FOUR AS ZIP_CODE_PLUS_FOUR,                 
MFA-TR*               ZIP_CODE_TOKEN    AS ZIP_CODE_TOKEN,                      
MFA-TR*               DELIV_PT          AS DELIV_PT,                            
MFA-TR*               HOUSE_NO          AS HOUSE_NO,                            
MFA-TR*               ADDR_PREFIX_1     AS ADDR_PREFIX_1,                       
MFA-TR*               ADDR_PREFIX_2     AS ADDR_PREFIX_2,                       
MFA-TR*               STREET_NAME       AS STREET_NAME,                         
MFA-TR*               STREET_SUFFIX     AS STREET_SUFFIX,                       
MFA-TR*               ADDR_SUFFIX       AS ADDR_SUFFIX,                         
MFA-TR*               STREET_LOC_1      AS STREET_LOC_1,                        
MFA-TR*               STREET_LOC_2      AS STREET_LOC_2,                        
MFA-TR*               PO_BOX_FL         AS PO_BOX_FL,                           
MFA-TR*               ADDRESS_OVERFLOW  AS ADDRESS_OVERFLOW                     
MFA-TR*         FROM SESSION.CSR04700_R5                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N5 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-5     AS RETURN_CODE,              
                      :S-ADDRESS-TYPE      AS ADDRESS_TYPE,             
                      :S-ADDRESS-ID        AS ADDRESS_ID,               
                      :S-ADDRESS-FORMAT    AS ADDRESS_FORMAT,           
                      :S-FF-STREET-1       AS FF_STREET_1,              
                      :S-FF-STREET-2       AS FF_STREET_2,              
                      :S-FF-CITY-STATE     AS FF_CITY_STATE,            
                      :S-FF-ZIP-CODE       AS FF_ZIP_CODE,              
                      :S-FF-COUNTRY        AS FF_COUNTRY,               
                      :S-FF-CITY           AS FF_CITY,                  
                      :S-FF-STATE          AS FF_STATE,                 
                      :S-IAT-CITY          AS IAT_CITY,                 
                      :S-IAT-PROVINCE      AS IAT_PROVINCE,             
                      :S-IAT-POST-CODE     AS IAT_POST_CODE,            
                      :S-FMT-STREET-1      AS FMT_STREET_1,             
                      :S-FMT-STREET-2      AS FMT_STREET_2,             
                      :S-TOWN              AS TOWN,                     
                      :S-STATE             AS STATE,                    
                      :S-ZIP-CODE          AS ZIP_CODE,                 
                      :S-ZIP-CODE-4        AS ZIP_CODE_PLUS_FOUR,       
                      :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,           
                      :S-USPS-DELIV-PT     AS DELIV_PT,                 
                      :S-HOUSE-NO          AS [HOUSE-NO],                 
                      :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,            
                      :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,            
                      :S-STREET-NAME       AS STREET_NAME,              
                      :S-STREET-SUFFIX     AS STREET_SUFFIX,            
                      :S-ADDR-SUFFIX       AS ADDR_SUFFIX,              
                      :S-STREET-LOC-1      AS STREET_LOC_1,             
                      :S-STREET-LOC-2      AS STREET_LOC_2,             
                      :S-PO-BOX-FL         AS PO_BOX_FL,                
                      :S-ADDRESS-OVERFLOW  AS ADDRESS_OVERFLOW          
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N5 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-5     AS RETURN_CODE,                      
MFA-TR*               :S-ADDRESS-TYPE      AS ADDRESS_TYPE,                     
MFA-TR*               :S-ADDRESS-ID        AS ADDRESS_ID,                       
MFA-TR*               :S-ADDRESS-FORMAT    AS ADDRESS_FORMAT,                   
MFA-TR*               :S-FF-STREET-1       AS FF_STREET_1,                      
MFA-TR*               :S-FF-STREET-2       AS FF_STREET_2,                      
MFA-TR*               :S-FF-CITY-STATE     AS FF_CITY_STATE,                    
MFA-TR*               :S-FF-ZIP-CODE       AS FF_ZIP_CODE,                      
MFA-TR*               :S-FF-COUNTRY        AS FF_COUNTRY,                       
MFA-TR*               :S-FF-CITY           AS FF_CITY,                          
MFA-TR*               :S-FF-STATE          AS FF_STATE,                         
MFA-TR*               :S-IAT-CITY          AS IAT_CITY,                         
MFA-TR*               :S-IAT-PROVINCE      AS IAT_PROVINCE,                     
MFA-TR*               :S-IAT-POST-CODE     AS IAT_POST_CODE,                    
MFA-TR*               :S-FMT-STREET-1      AS FMT_STREET_1,                     
MFA-TR*               :S-FMT-STREET-2      AS FMT_STREET_2,                     
MFA-TR*               :S-TOWN              AS TOWN,                             
MFA-TR*               :S-STATE             AS STATE,                            
MFA-TR*               :S-ZIP-CODE          AS ZIP_CODE,                         
MFA-TR*               :S-ZIP-CODE-4        AS ZIP_CODE_PLUS_FOUR,               
MFA-TR*               :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,                   
MFA-TR*               :S-USPS-DELIV-PT     AS DELIV_PT,                         
MFA-TR*               :S-HOUSE-NO          AS HOUSE-NO,                         
MFA-TR*               :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,                    
MFA-TR*               :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,                    
MFA-TR*               :S-STREET-NAME       AS STREET_NAME,                      
MFA-TR*               :S-STREET-SUFFIX     AS STREET_SUFFIX,                    
MFA-TR*               :S-ADDR-SUFFIX       AS ADDR_SUFFIX,                      
MFA-TR*               :S-STREET-LOC-1      AS STREET_LOC_1,                     
MFA-TR*               :S-STREET-LOC-2      AS STREET_LOC_2,                     
MFA-TR*               :S-PO-BOX-FL         AS PO_BOX_FL,                        
MFA-TR*               :S-ADDRESS-OVERFLOW  AS ADDRESS_OVERFLOW                  
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C6 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      BA_ADDRESS_FORMAT AS BILL_ADDRESS_FORMAT,         
                      BA_ADDRESS_ID     AS BILL_ADDRESS_ID,             
                      ACCOUNT_NO        AS ACCOUNT_NO,                  
                      SERV_ADDRESS      AS SERV_ADDRESS,                
                      CODE_ACCT_STAT    AS CODE_ACCT_STAT,              
                      COMPANY_NO        AS COMPANY_NO                   
                FROM #CSR04700_R6                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C6 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               BA_ADDRESS_FORMAT AS BILL_ADDRESS_FORMAT,                 
MFA-TR*               BA_ADDRESS_ID     AS BILL_ADDRESS_ID,                     
MFA-TR*               ACCOUNT_NO        AS ACCOUNT_NO,                          
MFA-TR*               SERV_ADDRESS      AS SERV_ADDRESS,                        
MFA-TR*               CODE_ACCT_STAT    AS CODE_ACCT_STAT,                      
MFA-TR*               COMPANY_NO        AS COMPANY_NO                           
MFA-TR*         FROM SESSION.CSR04700_R6                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N6 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-6     AS RETURN_CODE,              
                      :S-BA-ADDRESS-FORMAT AS BILL_ADDRESS_FORMAT,      
                      :S-BA-ADDRESS-ID     AS BILL_ADDRESS_ID,          
                      :S-ACCOUNT-NO        AS ACCOUNT_NO,               
                      :S-SERV-ADDRESS      AS SERV_ADDRESS,             
                      :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,           
                      :S-COMPANY-NO        AS COMPANY_NO                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N6 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-6     AS RETURN_CODE,                      
MFA-TR*               :S-BA-ADDRESS-FORMAT AS BILL_ADDRESS_FORMAT,              
MFA-TR*               :S-BA-ADDRESS-ID     AS BILL_ADDRESS_ID,                  
MFA-TR*               :S-ACCOUNT-NO        AS ACCOUNT_NO,                       
MFA-TR*               :S-SERV-ADDRESS      AS SERV_ADDRESS,                     
MFA-TR*               :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,                   
MFA-TR*               :S-COMPANY-NO        AS COMPANY_NO                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1416 CURSOR
MSQ001          FOR CALL CSR01416                                             
                  ( :INPUT-DATE-1416
                  , :BUSINESS-DAYS-1416
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO                               
                          LINK-CUSTOMER-NO                              
                          LINK-PREMISE-NO.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED                                
                       WS-GTT04-DECLARED                                
                       WS-GTT05-DECLARED                                
                       WS-GTT06-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04700_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04700_R2
              (                                                          
               RETURN_CODE          INT,                            
               PHONE_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               PHONE_NUMBER CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
               PHONE_EXT CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2,             
               PHONE_MOBILE_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PHONE_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               PHONE_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
               PHONE_TEXT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04700_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04700_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04700_R3
              (                                                          
               RETURN_CODE          INT,                            
               EMAIL_ADDRESS CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2,        
               EMAIL_TYPE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
               EMAIL_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               EMAIL_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04700_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0104-DECLARE-GTT04.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04700_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04700_R4
              (                                                          
               RETURN_CODE          INT,                            
               NAME_ID              DECIMAL(13,0),                      
               NAME_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               TITLE_PREFIX CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,          
               FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,            
               MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,           
               LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,             
               TITLE_SUFFIX CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2              
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8004-DELETE-GTT4-ROWS THRU 8004-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0104'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04700_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT04-DECLARED.                               
                                                                        
       0104-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0105-DECLARE-GTT05.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04700_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04700_R5
              (                                                          
               RETURN_CODE          INT,                            
               ADDRESS_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ADDRESS_ID           DECIMAL(13,0),                      
               ADDRESS_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               FF_STREET_1 CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2,           
               FF_STREET_2 CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2,           
               FF_CITY_STATE CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,         
               FF_ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,           
               FF_COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2,            
               FF_CITY CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,               
               FF_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,              
               IAT_CITY CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,              
               IAT_PROVINCE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
               IAT_POST_CODE CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,         
               FMT_STREET_1 CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2,          
               FMT_STREET_2 CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2,          
               TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ZIP_CODE_PLUS_FOUR CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ZIP_CODE_TOKEN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               DELIV_PT CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,              
               HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ADDR_PREFIX_1 CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ADDR_PREFIX_2 CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
               STREET_NAME CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,           
               STREET_SUFFIX CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,           
               STREET_LOC_1 CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,          
               STREET_LOC_2 CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2,          
               PO_BOX_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT5-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04700_R5'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT05-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0106-DECLARE-GTT06.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04700_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04700_R6
              (                                                          
               RETURN_CODE          INT,                            
               BA_ADDRESS_FORMAT CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               BA_ADDRESS_ID        DECIMAL(13,0),                      
               ACCOUNT_NO           DECIMAL(13,0),                      
               SERV_ADDRESS CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8006-DELETE-GTT6-ROWS THRU 8006-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0106'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04700_R6'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT06-DECLARED.                               
                                                                        
       0106-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF (LINK-CUSTOMER-NO = ZEROES AND                            
               LINK-ACCOUNT-NO = ZEROES AND                             
               LINK-PREMISE-NO = ZEROES)                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                  MOVE 'ALL PARMS ZERO' TO S-LAST-NAME                  
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT             
                  PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT             
                  PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT             
                  PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT             
                  PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT             
                  PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT             
                  PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT             
                  PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT             
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           IF AT-ACCOUNT-NO > ZEROES                                    
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT               
               PERFORM 7150-SELECT-MISC THRU 7150-EXIT                  
               PERFORM 7060-EDI-DEST THRU 7060-EXIT                     
               MOVE NF-DEST-ID TO S-DEST-ID                             
               MOVE 'EMAIL PMT REMINDER' TO YP-ATTRIBUTE-DESC           
               MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX                     
               PERFORM 7200-SELECT-ATTRIB THRU 7200-EXIT                
               IF YP-ATTRIBUTE-VALUE-CD = 'YES'                         
                   MOVE 'Y' TO S-PAYMENT-REMINDER                       
               ELSE                                                     
                   MOVE 'N' TO S-PAYMENT-REMINDER                       
               END-IF                                                   
               PERFORM 2010-BILL-NOTIFICATION THRU 2010-EXIT            
               MOVE AT-ACCOUNT-NO TO AB-ACCOUNT-NO                      
               IF WS-ARCHIVED-ACCOUNT = 'N'                             
                   PERFORM 7520-OPEN-NAME-CURSOR THRU 7520-EXIT         
                   PERFORM 2300-FETCH-ROWS THRU 2300-EXIT               
                   PERFORM 7521-CLOSE-NAME-CURSOR THRU 7521-EXIT        
               ELSE                                                     
                   PERFORM 7525-OPEN-H-NAME-CURSOR THRU 7525-EXIT       
                   PERFORM 2350-FETCH-ROWS THRU 2350-EXIT               
                   PERFORM 7526-CLOSE-H-NAME-CURSOR THRU 7526-EXIT      
               END-IF                                                   
               MOVE SPACES TO WS-ADDRESS-CD                             
               IF AT-ADDRESS-ID > 0                                     
                   MOVE 'BI' TO WS-ADDRESS-CD                           
                   EVALUATE AT-ADDRESS-FORMAT                           
                       WHEN 'A'                                         
                           MOVE AT-ADDRESS-ID TO DY-ADDRESS-ID          
                           PERFORM 2020-FORMATTED-ADDRESS THRU 2020-EXIT
                       WHEN 'B'                                         
                           MOVE AT-ADDRESS-ID TO DZ-ADDRESS-ID          
                           PERFORM 2030-FREEFORM-ADDRESS THRU 2030-EXIT 
                   END-EVALUATE
               END-IF
           END-IF.                                        
           IF CU-CUSTOMER-NO > ZEROES                                   
               PERFORM 7050-SELECT-CUSTOMER THRU 7050-EXIT              
               PERFORM 7100-SELECT-STATS THRU 7100-EXIT
           END-IF.                
               MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                    
               PERFORM 7510-OPEN-PHONE-CURSOR THRU 7510-EXIT            
               PERFORM 2100-FETCH-ROWS THRU 2100-EXIT                   
               PERFORM 7511-CLOSE-PHONE-CURSOR THRU 7511-EXIT           
               MOVE CU-CUSTOMER-NO TO NE-CUSTOMER-NO                    
               PERFORM 7500-OPEN-EMAIL-CURSOR THRU 7500-EXIT            
               PERFORM 2200-FETCH-ROWS THRU 2200-EXIT                   
               PERFORM 7501-CLOSE-EMAIL-CURSOR THRU 7501-EXIT           
               PERFORM 2500-WELCOME-KIT THRU 2500-EXIT                  
               MOVE SPACES TO WS-ADDRESS-CD                             
               MOVE CU-CUSTOMER-NO TO DM-CUSTOMER-NO                    
               PERFORM 7250-SELECT-CORR-ADDR THRU 7250-EXIT             
               IF DM-ADDRESS-ID > 0                                     
                   MOVE 'CO' TO WS-ADDRESS-CD                           
                   EVALUATE DM-ADDRESS-FORMAT                           
                       WHEN 'A'                                         
                           MOVE DM-ADDRESS-ID TO DY-ADDRESS-ID          
                           PERFORM 2020-FORMATTED-ADDRESS THRU 2020-EXIT
                       WHEN 'B'                                         
                           MOVE DM-ADDRESS-ID TO DZ-ADDRESS-ID          
                           PERFORM 2030-FREEFORM-ADDRESS THRU 2030-EXIT 
                   END-EVALUATE                                         
               END-IF                                                   
               PERFORM 7530-OPEN-ACCT-CURSOR THRU 7530-EXIT             
               PERFORM 2400-FETCH-ROWS THRU 2400-EXIT                   
               PERFORM 7531-CLOSE-ACCT-CURSOR THRU 7531-EXIT.           
                                                                        
           MOVE CE-LANGUAGE-PREF-CD TO S-LANGUAGE-PREF.                 
           MOVE CE-PASSWORD-TX TO S-PASSWORD.                           
           MOVE CE-PASSWORD-HINT TO S-PASSWORD-HINT.                    
           MOVE TA-ADDTL-BILL-NAME-TX TO S-SPECIAL-ID.                  
           MOVE TA-SPCL-BILL-STMNT-TX TO S-ACCOUNT-ID.                  
           MOVE TA-SERVICE-CARE-ID TO S-SERVICE-CARE-ID.                
           MOVE CE-ALLOW-CALL-FL TO S-ALLOW-CALL-FL.                    
           MOVE CE-ALLOW-EMAIL-FL TO S-ALLOW-EMAIL-FL.                  
           MOVE CE-EMPLOYER TO S-EMPLOYER.                              
           MOVE CU-WELCOME-KIT-CD TO S-WELCOME-KIT-CD.                  
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT-1.                      
           MOVE CE-EBILL-REGISTER-IND TO S-EBILL-FL.                    
           IF (AT-NO-BILL-COPIES = 0 OR                                 
               CE-EBILL-REGISTER-IND = 'Y') AND                         
               S-BILL-NOTIFICATION = '5'                                
                   MOVE '2' TO S-BILL-NOTIFICATION
           END-IF.                     
           IF WS-ARCHIVED-ACCOUNT = 'Y'                                 
               MOVE SPACES TO S-BILL-NOTIFICATION
           END-IF.                      
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-BILL-NOTIFICATION.                                          
                                                                        
           MOVE 'EMAIL_BILLNOTIFY' TO YP-ATTRIBUTE-DESC.                
           MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX.                        
           PERFORM 7200-SELECT-ATTRIB THRU 7200-EXIT.                   
           IF YP-ATTRIBUTE-VALUE-CD = 'NO'                              
               MOVE '4' TO S-BILL-NOTIFICATION                          
           ELSE                                                         
               IF AT-NO-BILL-COPIES = 0                                 
                   MOVE '1' TO S-BILL-NOTIFICATION                      
               ELSE                                                     
                   IF AT-NO-BILL-COPIES > 0                             
                       MOVE 'EMAIL_PAPERONLY' TO YP-ATTRIBUTE-DESC      
                       MOVE 'EMAIL' TO WZ-ATTRIBUTE-TYPE-TX             
                       PERFORM 7200-SELECT-ATTRIB THRU 7200-EXIT        
                       IF YP-ATTRIBUTE-VALUE-CD = 'YES'                 
                           MOVE '3' TO S-BILL-NOTIFICATION              
                       ELSE                                             
                           MOVE '5' TO S-BILL-NOTIFICATION
                       END-IF
                   END-IF
               END-IF
           END-IF.             
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2020-FORMATTED-ADDRESS.                                          
                                                                        
           PERFORM 7300-SELECT-FMT-ADDR THRU 7300-EXIT.                 
           INITIALIZE GTT-RETURN-FIELDS-5.                              
           MOVE WS-ADDRESS-CD TO S-ADDRESS-TYPE.                        
           MOVE DY-ADDRESS-ID TO S-ADDRESS-ID.                          
           MOVE 'A' TO S-ADDRESS-FORMAT.                                
           MOVE WS-ADDRESS-LINE-1 TO S-FMT-STREET-1.                    
           MOVE WS-ADDRESS-LINE-2 TO S-FMT-STREET-2.                    
           MOVE A4-TOWN TO S-TOWN.                                      
           MOVE A4-STATE TO S-STATE.                                    
           MOVE DY-ZIP-CODE TO S-ZIP-CODE.                              
           MOVE DY-ZIP-CODE-PLUS-FOUR TO S-ZIP-CODE-4.                  
           MOVE DY-ZIP-CODE-TOKEN TO S-ZIP-CODE-TOKEN.                  
           MOVE DY-USPS-DELIV-PT-CD TO S-USPS-DELIV-PT.                 
           MOVE DY-HOUSE-NO TO S-HOUSE-NO.                              
           MOVE DY-ADDR-PREFIX-1 TO S-ADDR-PREFIX-1.                    
           MOVE DY-ADDR-PREFIX-2 TO S-ADDR-PREFIX-2.                    
           MOVE DY-STREET-NAME TO S-STREET-NAME.                        
           MOVE DY-STREET-SUFFIX TO S-STREET-SUFFIX.                    
           MOVE DY-ADDR-SUFFIX TO S-ADDR-SUFFIX.                        
           MOVE DY-STREET-LOCATION-1 TO S-STREET-LOC-1.                 
           MOVE DY-STREET-LOCATION-2 TO S-STREET-LOC-2.                 
           MOVE DY-ADDRESS-OVERFLOW TO S-ADDRESS-OVERFLOW.              
           IF DY-STREET-NAME(1:7) = 'PO BOX '                           
               MOVE 'Y' TO S-PO-BOX-FL                                  
           ELSE                                                         
               MOVE 'N' TO S-PO-BOX-FL
           END-IF.                                 
           IF WS-GTT05-DECLARED = 'N'                                   
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT
           END-IF.               
           PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT.                   
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2030-FREEFORM-ADDRESS.                                           
                                                                        
           PERFORM 7400-SELECT-FF-ADDR THRU 7400-EXIT.                  
           INITIALIZE GTT-RETURN-FIELDS-5.                              
           MOVE WS-ADDRESS-CD TO S-ADDRESS-TYPE.                        
           MOVE DZ-ADDRESS-ID TO S-ADDRESS-ID.                          
           MOVE 'B' TO S-ADDRESS-FORMAT.                                
           MOVE DZ-ADDR-STREET TO S-FF-STREET-1.                        
           MOVE DZ-ADDRESS-OVERFLOW TO S-FF-STREET-2.                   
           MOVE DZ-ADDR-CITY-STATE TO S-FF-CITY-STATE.                  
           MOVE DZ-ADDR-ZIP-CODE TO S-FF-ZIP-CODE.                      
           IF DZ-ADDR-COUNTRY = 'USA' OR 'UNITED STATES'                
               MOVE SPACES TO S-FF-COUNTRY                              
           ELSE                                                         
               MOVE DZ-ADDR-COUNTRY TO S-FF-COUNTRY
           END-IF.                    
           MOVE DZ-INTRNTNL-CITY TO S-IAT-CITY.                         
           MOVE DZ-INTRNTNL-PROVINCE TO S-IAT-PROVINCE.                 
           MOVE DZ-INTRNTNL-POST-CODE TO S-IAT-POST-CODE.               
           IF DZ-ADDR-CITY-STATE > ' ' AND                              
             (DZ-ADDR-COUNTRY = ' ' OR 'UNITED STATES' OR 'USA')        
                 PERFORM 2040-EXTRACT-CITY-STATE THRU 2040-EXIT
           END-IF.        
           IF DZ-ADDR-STREET(1:7) = 'PO BOX '                           
               MOVE 'Y' TO S-PO-BOX-FL                                  
           ELSE                                                         
               MOVE 'N' TO S-PO-BOX-FL
           END-IF.                                 
           IF WS-GTT05-DECLARED = 'N'                                   
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT
           END-IF.               
           PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT.                   
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2040-EXTRACT-CITY-STATE.                                         
                                                                        
           INSPECT DZ-ADDR-CITY-STATE REPLACING ALL ',' BY ' '.         
           MOVE +30 TO WS-SUB1.                                         
           MOVE 0 TO WS-SUB2.                                           
           PERFORM UNTIL DZ-ADDR-CITY-STATE(WS-SUB1:1) > ' '            
               SUBTRACT +1 FROM WS-SUB1                                 
           END-PERFORM.                                                 
           IF DZ-ADDR-CITY-STATE(WS-SUB1 - 2:1) = ' '                   
               MOVE DZ-ADDR-CITY-STATE(WS-SUB1 - 1:2) TO S-FF-STATE     
               MOVE DZ-ADDR-CITY-STATE(1:WS-SUB1 - 3) TO S-FF-CITY
           END-IF.     
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH PHONE-CURSOR                                       
                INTO :CB-PHONE-TYPE,                                    
                     :CB-PHONE-NO,                                      
                     :CB-EXTENSION-NO,                                  
                     :CB-MOBILE-PHONE-FL,                               
                     :CB-PERMISN-TO-MKT-FL,                             
                     :CB-PERMISN-TO-MKT-DT :WS-NULL-1,                   
                     :CB-PERMISN-TO-TEXT-FL                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CB-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE CB-PHONE-TYPE TO S-PHONE-TYPE.                          
           MOVE CB-PHONE-NO TO S-PHONE-NUMBER.                          
           MOVE CB-EXTENSION-NO TO S-PHONE-EXT.                         
           MOVE CB-MOBILE-PHONE-FL TO S-PHONE-MOBILE-FL.                
           MOVE CB-PERMISN-TO-MKT-FL TO S-PHONE-MKT-FL.                 
           MOVE CB-PERMISN-TO-MKT-DT TO S-PHONE-MKT-DT.                 
           MOVE CB-PERMISN-TO-TEXT-FL TO S-PHONE-TEXT-FL.               
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO NE-EMAIL-ADDRESS-TX.                          
                                                                        
           EXEC SQL                                                     
               FETCH EMAIL-CURSOR                                       
                INTO :NE-EMAIL-TYPE-CD,                                 
                     :NE-EMAIL-ADDRESS-TX,                              
                     :NE-PERMISN-TO-MKT-FL,                             
                     :NE-PERMISN-TO-MKT-TS :WS-NULL-3                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO NE-PERMISN-TO-MKT-TS              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2200-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           MOVE NE-EMAIL-TYPE-CD TO S-EMAIL-TYPE-CD.                    
           MOVE NE-EMAIL-ADDRESS-TX-TEXT TO S-EMAIL-ADDRESS.            
           MOVE NE-PERMISN-TO-MKT-FL TO S-EMAIL-MKT-FL.                 
           MOVE NE-PERMISN-TO-MKT-TS(1:10) TO S-EMAIL-MKT-DT.           
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
           GO TO 2200-FETCH-ROWS.                                       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH NAME-CURSOR                                        
                INTO :AB-NAME-TYPE,                                     
                     :AB-NAME-ID,                                       
                     :DQ-NAME-FORMAT,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2300-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-4.                              
           MOVE AB-NAME-TYPE TO S-NAME-TYPE.                            
           MOVE AB-NAME-ID TO S-NAME-ID.                                
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT-4.                      
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-TITLE-PREFIX TO S-TITLE-PREFIX                   
               MOVE DQ-FIRST-NAME TO S-FIRST-NAME                       
               MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME                     
               MOVE DQ-LAST-NAME TO S-LAST-NAME                         
               MOVE DQ-TITLE-SUFFIX-1 TO S-TITLE-SUFFIX                 
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-FULL-NAME
           END-IF.                        
           IF WS-GTT04-DECLARED = 'N'                                   
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT
           END-IF.               
           PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT.                   
                                                                        
           GO TO 2300-FETCH-ROWS.                                       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2350-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH H-NAME-CURSOR                                      
                INTO :AB-NAME-TYPE,                                     
                     :AB-NAME-ID,                                       
                     :DQ-NAME-FORMAT,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2350-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2350'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-4.                              
           MOVE AB-NAME-TYPE TO S-NAME-TYPE.                            
           MOVE AB-NAME-ID TO S-NAME-ID.                                
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT-4.                      
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-TITLE-PREFIX TO S-TITLE-PREFIX                   
               MOVE DQ-FIRST-NAME TO S-FIRST-NAME                       
               MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME                     
               MOVE DQ-LAST-NAME TO S-LAST-NAME                         
               MOVE DQ-TITLE-SUFFIX-1 TO S-TITLE-SUFFIX                 
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-FULL-NAME
           END-IF.                        
           IF WS-GTT04-DECLARED = 'N'                                   
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT
           END-IF.               
           PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT.                   
                                                                        
           GO TO 2350-FETCH-ROWS.                                       
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCT-CURSOR                                        
                INTO :AT-ADDRESS-FORMAT,                                
                     :AT-ADDRESS-ID,                                    
                     :AT-ACCOUNT-NO,                                    
                     :AT-CODE-ACCT-STAT,                                
                     :AT-COMPANY-NO,                                    
                     :PR-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2400-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-6.                              
           MOVE AT-ADDRESS-FORMAT TO S-BA-ADDRESS-FORMAT.               
           MOVE AT-ADDRESS-ID TO S-BA-ADDRESS-ID.                       
           MOVE AT-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE AT-CODE-ACCT-STAT TO S-CODE-ACCT-STAT.                  
           MOVE AT-COMPANY-NO TO S-COMPANY-NO.                          
           IF PR-ADDRESS-ID > 0                                         
               PERFORM 7280-SERVICE-ADDRESS THRU 7280-EXIT              
               IF DY-ADDR-USAGE-CD = 'I'                                
                   MOVE WS-ADDRESS-LINE-I TO S-SERV-ADDRESS             
               ELSE                                                     
                   MOVE WS-ADDRESS-LINE TO S-SERV-ADDRESS
               END-IF
           END-IF.              
                                                                        
           IF WS-GTT06-DECLARED = 'N'                                   
               PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT
           END-IF.               
           PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT.                   
                                                                        
           GO TO 2400-FETCH-ROWS.                                       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-WELCOME-KIT.                                                
                                                                        
            IF CU-COMPANY-NO-ORIG = '26'                                
               PERFORM 7900-GET-WELCOME-FL-CUONLY THRU 7900-EXIT        
            ELSE                                                        
               MOVE 'N' TO S-WELCOME-DISP-FL
            END-IF.                           
            IF S-WELCOME-DISP-FL = 'N'                                  
               PERFORM 7910-GET-WELCOME-FL-PEND THRU 7910-EXIT          
               IF S-WELCOME-DISP-FL = 'N'                               
                  PERFORM 7920-GET-WELCOME-FL   THRU 7920-EXIT
               END-IF
            END-IF.         
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2510-CALL-CSR01416.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01416                                             
      *           (:INPUT-DATE-1416,                                    
      *            :BUSINESS-DAYS-1416)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1416 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01416'            TO TABLE-1                     
              MOVE 'INPUT_DATE'          TO TABLE-ELEMENT-1             
              MOVE INPUT-DATE-1416       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1416)                                                
      *       WITH PROCEDURE CSR01416                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1416 CURSOR FOR RESULT SET        
      *       :LOC1416                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1416 INTO                            
                 :OUTPUT-DATE-1416                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '2300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01416'            TO TABLE-1                
                   MOVE 'INPUT_DATE'          TO TABLE-ELEMENT-1        
                   MOVE INPUT-DATE-1416       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              PREMISE_NO,
              COMPANY_NO,
              NO_BILL_COPIES,
              ADDRESS_ID,
              ADDRESS_FORMAT                                     
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-COMPANY-NO,                                    
                     :AT-NO-BILL-COPIES,                                
                     :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              NO_BILL_COPIES,                                            
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT                                             
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-NO-BILL-COPIES,                                        
MFA-TR*              :AT-ADDRESS-ID,                                            
MFA-TR*              :AT-ADDRESS-FORMAT                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CU-CUSTOMER-NO = ZEROES                           
                       MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO            
                   END-IF                                               
                   IF PR-PREMISE-NO = ZEROES                            
                       MOVE AT-PREMISE-NO TO PR-PREMISE-NO              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ACCOUNT                            
                   MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO              
                   PERFORM 7001-SELECT-ACCOUNT-ARCH THRU 7001-EXIT      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7000'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT' TO TABLE-1                        
                   MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7001-SELECT-ACCOUNT-ARCH.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     COMPANY_NO,                                        
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT                                     
              INTO  :AT-CUSTOMER-NO,                                    
                    :AT-PREMISE-NO,                                     
                    :AT-COMPANY-NO,                                     
                    :AT-ADDRESS-ID,                                     
                    :AT-ADDRESS-FORMAT                                  
                 FROM HST_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT                                             
MFA-TR*       INTO  :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-PREMISE-NO,                                             
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-ADDRESS-ID,                                             
MFA-TR*             :AT-ADDRESS-FORMAT                                          
MFA-TR*          FROM HST_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ARCHIVED-ACCOUNT                      
                   IF CU-CUSTOMER-NO = ZEROES                           
                       MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO            
                   END-IF                                               
                   IF PR-PREMISE-NO = ZEROES                            
                       MOVE AT-PREMISE-NO TO PR-PREMISE-NO              
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'   TO TABLE-ELEMENT-1                
                   MOVE C8-DELINQ-CD  TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) WELCOME_KIT_CD,
              COMPANY_NO_ORIG,
              NAME_FORMAT                                        
                INTO :CU-WELCOME-KIT-CD,                                
                     :CU-COMPANY-NO-ORIG,                               
                     :DQ-NAME-FORMAT                                    
                FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
              WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
                AND CU.NAME_ID = DQ.NAME_ID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WELCOME_KIT_CD,                                            
MFA-TR*              COMPANY_NO_ORIG,                                           
MFA-TR*              NAME_FORMAT                                                
MFA-TR*         INTO :CU-WELCOME-KIT-CD,                                        
MFA-TR*              :CU-COMPANY-NO-ORIG,                                       
MFA-TR*              :DQ-NAME-FORMAT                                            
MFA-TR*         FROM CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                               
MFA-TR*         AND CU.NAME_ID = DQ.NAME_ID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7050'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER' TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-EDI-DEST.                                                   
                                                                        
           EXEC SQL                                                     
                SELECT DEST_ID                                          
                  INTO :NF-DEST-ID                                      
                  FROM CSS_EDI_ACCT_DEST WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
                   AND STATUS_CD  = 'A'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DEST_ID                                                  
MFA-TR*           INTO :NF-DEST-ID                                              
MFA-TR*           FROM CSS_EDI_ACCT_DEST                                        
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*            AND STATUS_CD  = 'A'                                         
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7060                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-EDI-FL                                 
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO S-EDI-FL                                 
                   MOVE SPACES TO S-DEST-ID                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7000'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT' TO TABLE-1                        
                   MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) LANGUAGE_PREF_CD,
              PASSWORD_HINT,
              PASSWORD_TX,
              EBILL_REGISTER_IND,
              ALLOW_CALL_FL,
              ALLOW_EMAIL_FL,
              EMPLOYER                                           
               INTO :CE-LANGUAGE-PREF-CD,                               
                    :CE-PASSWORD-HINT,                                  
                    :CE-PASSWORD-TX,                                    
                    :CE-EBILL-REGISTER-IND,                             
                    :CE-ALLOW-CALL-FL,                                  
                    :CE-ALLOW-EMAIL-FL,                                 
                    :CE-EMPLOYER                                        
               FROM  CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
                AND CUSTOMER_TYPE = 'C'                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT  LANGUAGE_PREF_CD,                                  14210000
MFA-TR*              PASSWORD_HINT,                                     14240000
MFA-TR*              PASSWORD_TX,                                       14250000
MFA-TR*              EBILL_REGISTER_IND,                                        
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              EMPLOYER                                                   
MFA-TR*        INTO :CE-LANGUAGE-PREF-CD,                               14380000
MFA-TR*             :CE-PASSWORD-HINT,                                  14410000
MFA-TR*             :CE-PASSWORD-TX,                                    14410000
MFA-TR*             :CE-EBILL-REGISTER-IND,                             14420000
MFA-TR*             :CE-ALLOW-CALL-FL,                                  14420000
MFA-TR*             :CE-ALLOW-EMAIL-FL,                                 14420000
MFA-TR*             :CE-EMPLOYER                                        14420000
MFA-TR*        FROM  CSS_CUST_STATS                                     14550000
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       14560000
MFA-TR*         AND CUSTOMER_TYPE = 'C'                                 14561000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-STATS                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7100'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-SELECT-MISC.                                                
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ADDTL_BILL_NAME_TX,
              SPCL_BILL_STMNT_TX,
              SERVICE_CARE_ID                                    
               INTO :TA-ADDTL-BILL-NAME-TX,                             
                    :TA-SPCL-BILL-STMNT-TX,                             
                    :TA-SERVICE-CARE-ID                                 
               FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT  ADDTL_BILL_NAME_TX,                                14210000
MFA-TR*              SPCL_BILL_STMNT_TX,                                14240000
MFA-TR*              SERVICE_CARE_ID                                    14250000
MFA-TR*        INTO :TA-ADDTL-BILL-NAME-TX,                             14380000
MFA-TR*             :TA-SPCL-BILL-STMNT-TX,                             14410000
MFA-TR*             :TA-SERVICE-CARE-ID                                 14420000
MFA-TR*        FROM CSS_ACCT_MISC_INFO                                  14550000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         14560000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ACCT-MISC-INFO                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7150'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-ATTRIB.                                              
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ATTRIBUTE_VALUE_CD                                  
               INTO :YP-ATTRIBUTE-VALUE-CD                              
               FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED),                
                    CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND COMPANY_NO = :AT-COMPANY-NO                         
                AND YP.ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC              
                AND ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX           
                AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC               
                AND ATTRIBUTE_STAT_CD = 'A'                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT ATTRIBUTE_VALUE_CD                                  14210000
MFA-TR*        INTO :YP-ATTRIBUTE-VALUE-CD                              14380000
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE YP,                              14550000
MFA-TR*             CSS_ATTRIBUTE WZ                                            
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         14560000
MFA-TR*         AND COMPANY_NO = :AT-COMPANY-NO                                 
MFA-TR*         AND YP.ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                      
MFA-TR*         AND ATTRIBUTE_TYPE_TX = :WZ-ATTRIBUTE-TYPE-TX                   
MFA-TR*         AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC                       
MFA-TR*         AND ATTRIBUTE_STAT_CD = 'A'                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ACCT-ATTRIBUTE                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7200'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   MOVE 'ATTRIBUTE_DESC'  TO TABLE-ELEMENT-2            
                   MOVE 'EMAIL PMT REMINDER' TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-SELECT-CORR-ADDR.                                           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ADDRESS_ID,
              ADDRESS_FORMAT                                      
               INTO :DM-ADDRESS-ID,                                     
                    :DM-ADDRESS-FORMAT                                  
               FROM CSS_CUST_ADDR_XREF WITH(READUNCOMMITTED)                    
              WHERE CUSTOMER_NO = :DM-CUSTOMER-NO                       
                AND ADDRESS_TYPE = 'M'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT ADDRESS_ID,                                         14210000
MFA-TR*             ADDRESS_FORMAT                                              
MFA-TR*        INTO :DM-ADDRESS-ID,                                     14380000
MFA-TR*             :DM-ADDRESS-FORMAT                                          
MFA-TR*        FROM CSS_CUST_ADDR_XREF                                  14550000
MFA-TR*       WHERE CUSTOMER_NO = :DM-CUSTOMER-NO                       14560000
MFA-TR*         AND ADDRESS_TYPE = 'M'                                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-ADDR-XREF                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7250'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_ADDR_XREF' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE DM-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-SERVICE-ADDRESS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),
              RTRIM(LTRIM(RTRIM(STREET_NAME) + ' &  ' + LTRIM(RTRIM(
           ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE))))))),
              ADDR_USAGE_CD                                     
                 INTO :WS-ADDRESS-LINE,                                 
                      :WS-ADDRESS-LINE-I,                               
                      :DY-ADDR-USAGE-CD                                 
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
               WHERE ADDRESS_ID = :PR-ADDRESS-ID                        
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||             00010002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||              00020002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||              00030002
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                00040002
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||              00050002
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                00060002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||          00070002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||           00080002
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                      00090006
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                      00100002
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),             00110004
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' &  ' ||       00010002
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||           00020002
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                      00090006
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                      00100002
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE))))))),                   00110004
MFA-TR*               ADDR_USAGE_CD                                             
MFA-TR*          INTO :WS-ADDRESS-LINE,                                         
MFA-TR*               :WS-ADDRESS-LINE-I,                                       
MFA-TR*               :DY-ADDR-USAGE-CD                                         
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            00130001
MFA-TR*               CSS_ZIP_CODE A4                                   00140001
MFA-TR*        WHERE ADDRESS_ID = :PR-ADDRESS-ID                        00160000
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                          00180000
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              00190000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00200000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-ADDRESS-LINE                       
                                  WS-ADDRESS-LINE-I                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7280'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID'   TO TABLE-ELEMENT-1               
                   MOVE PR-ADDRESS-ID  TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-FMT-ADDR.                                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX)))))))),
              RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2)))),
              ADDRESS_OVERFLOW,
              DY.ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              USPS_DELIV_PT_CD,
              TOWN,
              STATE,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2                                   
               INTO :WS-ADDRESS-LINE-1,                                 
                    :WS-ADDRESS-LINE-2,                                 
                    :DY-ADDRESS-OVERFLOW,                               
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-USPS-DELIV-PT-CD,                               
                    :A4-TOWN,                                           
                    :A4-STATE,                                          
                    :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-SUFFIX,                                  
                    :DY-ADDR-SUFFIX,                                    
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2                               
               FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),                
                    CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                       
              WHERE ADDRESS_ID = :DY-ADDRESS-ID                         
                AND DY.ZIP_CODE = A4.ZIP_CODE                           
                AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                       
MFA-TR*             LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                        
MFA-TR*             LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                        
MFA-TR*             LTRIM(RTRIM(STREET_NAME) || ' ' ||                          
MFA-TR*             LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                        
MFA-TR*             LTRIM(RTRIM(ADDR_SUFFIX)))))))),                            
MFA-TR*             RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||              
MFA-TR*             LTRIM(RTRIM(STREET_LOCATION_2)))),                          
MFA-TR*             ADDRESS_OVERFLOW,                                           
MFA-TR*             DY.ZIP_CODE,                                                
MFA-TR*             ZIP_CODE_PLUS_FOUR,                                         
MFA-TR*             DY.ZIP_CODE_TOKEN,                                          
MFA-TR*             USPS_DELIV_PT_CD,                                           
MFA-TR*             TOWN,                                                       
MFA-TR*             STATE,                                                      
MFA-TR*             HOUSE_NO,                                                   
MFA-TR*             ADDR_PREFIX_1,                                              
MFA-TR*             ADDR_PREFIX_2,                                              
MFA-TR*             STREET_NAME,                                                
MFA-TR*             STREET_SUFFIX,                                              
MFA-TR*             ADDR_SUFFIX,                                                
MFA-TR*             STREET_LOCATION_1,                                          
MFA-TR*             STREET_LOCATION_2                                           
MFA-TR*        INTO :WS-ADDRESS-LINE-1,                                         
MFA-TR*             :WS-ADDRESS-LINE-2,                                         
MFA-TR*             :DY-ADDRESS-OVERFLOW,                                       
MFA-TR*             :DY-ZIP-CODE,                                               
MFA-TR*             :DY-ZIP-CODE-PLUS-FOUR,                                     
MFA-TR*             :DY-ZIP-CODE-TOKEN,                                         
MFA-TR*             :DY-USPS-DELIV-PT-CD,                                       
MFA-TR*             :A4-TOWN,                                                   
MFA-TR*             :A4-STATE,                                                  
MFA-TR*             :DY-HOUSE-NO,                                               
MFA-TR*             :DY-ADDR-PREFIX-1,                                          
MFA-TR*             :DY-ADDR-PREFIX-2,                                          
MFA-TR*             :DY-STREET-NAME,                                            
MFA-TR*             :DY-STREET-SUFFIX,                                          
MFA-TR*             :DY-ADDR-SUFFIX,                                            
MFA-TR*             :DY-STREET-LOCATION-1,                                      
MFA-TR*             :DY-STREET-LOCATION-2                                       
MFA-TR*        FROM CSS_ADDR_FORMATTED DY,                              14550000
MFA-TR*             CSS_ZIP_CODE A4                                             
MFA-TR*       WHERE ADDRESS_ID = :DY-ADDRESS-ID                         14560000
MFA-TR*         AND DY.ZIP_CODE = A4.ZIP_CODE                                   
MFA-TR*         AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                              DCLCSS-ZIP-CODE                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7300'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID'   TO TABLE-ELEMENT-1               
                   MOVE DY-ADDRESS-ID  TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-FF-ADDR.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY,
              INTRNTNL_CITY,
              INTRNTNL_PROVINCE,
              INTRNTNL_POST_CODE                                 
               INTO :DZ-ADDR-STREET,                                    
                    :DZ-ADDRESS-OVERFLOW,                               
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY,                                   
                    :DZ-INTRNTNL-CITY,                                  
                    :DZ-INTRNTNL-PROVINCE,                              
                    :DZ-INTRNTNL-POST-CODE                              
               FROM  CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
              WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY,                                              
MFA-TR*              INTRNTNL_CITY,                                             
MFA-TR*              INTRNTNL_PROVINCE,                                         
MFA-TR*              INTRNTNL_POST_CODE                                         
MFA-TR*        INTO :DZ-ADDR-STREET,                                            
MFA-TR*             :DZ-ADDRESS-OVERFLOW,                                       
MFA-TR*             :DZ-ADDR-CITY-STATE,                                        
MFA-TR*             :DZ-ADDR-ZIP-CODE,                                          
MFA-TR*             :DZ-ADDR-COUNTRY,                                           
MFA-TR*             :DZ-INTRNTNL-CITY,                                          
MFA-TR*             :DZ-INTRNTNL-PROVINCE,                                      
MFA-TR*             :DZ-INTRNTNL-POST-CODE                                      
MFA-TR*        FROM  CSS_ADDR_FREEFORM                                          
MFA-TR*       WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7400'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ADDRESS_ID'   TO TABLE-ELEMENT-1               
                   MOVE DZ-ADDRESS-ID  TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-EMAIL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN EMAIL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-EMAIL-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE EMAIL-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-OPEN-PHONE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN PHONE-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7510'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CB-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7511-CLOSE-PHONE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE PHONE-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7511'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CB-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7511-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7520-OPEN-NAME-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN NAME-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7520'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_BILL_NMES'  TO TABLE-1                
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AB-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7521-CLOSE-NAME-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE NAME-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7521'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AB-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7521-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7525-OPEN-H-NAME-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN H-NAME-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7525'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCT_BILL_NMES'  TO TABLE-1                
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AB-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7526-CLOSE-H-NAME-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE H-NAME-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7526'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AB-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7526-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7530-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7530'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7531-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7531'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7531-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7900-GET-WELCOME-FL-CUONLY.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                 INTO :WS-WELCOME-DISP-FL                               
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'N'                                                       
MFA-TR*          INTO :WS-WELCOME-DISP-FL                                       
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-WELCOME-DISP-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO S-WELCOME-DISP-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7900'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'  TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7910-GET-WELCOME-FL-PEND.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-WELCOME-DISP-FL                               
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.CUSTOMER_NO = :CU-CUSTOMER-NO                  
                  AND AT.ACCOUNT_TYPE_CODE = 'R'                        
                  AND AT.COMPANY_NO = '26'                              
                  AND AT.CODE_ACCT_STAT = 'P'                           
                  AND NOT EXISTS                                        
                     (SELECT 1                                          
                        FROM CSS_ACCOUNT AT1 WITH(READUNCOMMITTED),             
                             CSS_CUST_PREM_HIST CH1
                           WITH(READUNCOMMITTED)                     
                       WHERE AT.ACCOUNT_NO <> AT1.ACCOUNT_NO            
                         AND AT.CUSTOMER_NO = AT1.CUSTOMER_NO           
                         AND AT1.ACCOUNT_NO = CH1.ACCOUNT_NO            
                         AND AT1.COMPANY_NO = '26'                      
                         AND AT1.ACCOUNT_TYPE_CODE = 'R')               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-WELCOME-DISP-FL                                       
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.CUSTOMER_NO = :CU-CUSTOMER-NO                          
MFA-TR*           AND AT.ACCOUNT_TYPE_CODE = 'R'                                
MFA-TR*           AND AT.COMPANY_NO = '26'                                      
MFA-TR*           AND AT.CODE_ACCT_STAT = 'P'                                   
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*              (SELECT 1                                                  
MFA-TR*                 FROM CSS_ACCOUNT AT1,                                   
MFA-TR*                      CSS_CUST_PREM_HIST CH1                             
MFA-TR*                WHERE AT.ACCOUNT_NO <> AT1.ACCOUNT_NO                    
MFA-TR*                  AND AT.CUSTOMER_NO = AT1.CUSTOMER_NO                   
MFA-TR*                  AND AT1.ACCOUNT_NO = CH1.ACCOUNT_NO                    
MFA-TR*                  AND AT1.COMPANY_NO = '26'                              
MFA-TR*                  AND AT1.ACCOUNT_TYPE_CODE = 'R')                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7910                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-WELCOME-DISP-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-WELCOME-DISP-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7910'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'  TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7920-GET-WELCOME-FL.                                             
                                                                        
           MOVE WS-CURRENT-TS TO INPUT-DATE-1416.                       
           MOVE -11 TO BUSINESS-DAYS-1416.                              
           PERFORM 2510-CALL-CSR01416 THRU 2510-EXIT.                   
           MOVE OUTPUT-DATE-1416(1:10) TO WS-LAST-WKIT-DT.              
           MOVE SPACES TO WS-WELCOME-DISP-FL.                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-WELCOME-DISP-FL                               
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               
                WHERE AT.CUSTOMER_NO = :CU-CUSTOMER-NO                  
                  AND AT.ACCOUNT_TYPE_CODE = 'R'                        
                  AND AT.COMPANY_NO = '26'                              
                  AND AT.CODE_ACCT_STAT = 'A'                           
                  AND AT.ACCOUNT_NO = CH.ACCOUNT_NO                     
                  AND CH.DATE_UTIL_SVC_STRT >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-LAST-WKIT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-WKIT-DT
              ) <> 0) OR (LEN(:WS-LAST-WKIT-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-LAST-WKIT-DT
              ), CONVERT(DATE, :WS-LAST-WKIT-DT) )         
                  AND CH.DATE_UTIL_SVC_STRT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )         
                  AND NOT EXISTS                                        
                     (SELECT 1                                          
                        FROM CSS_ACCOUNT AT1 WITH(READUNCOMMITTED),             
                             CSS_CUST_PREM_HIST CH1
                           WITH(READUNCOMMITTED)                     
                       WHERE AT.ACCOUNT_NO <> AT1.ACCOUNT_NO            
                         AND AT.CUSTOMER_NO = AT1.CUSTOMER_NO           
                         AND AT1.ACCOUNT_NO = CH1.ACCOUNT_NO            
                         AND AT1.COMPANY_NO = '26'                      
                         AND AT1.ACCOUNT_TYPE_CODE = 'R'                
                         AND CH1.DATE_UTIL_SVC_STRT <                   
                             CH.DATE_UTIL_SVC_STRT)                     
                  AND NOT EXISTS                                        
                     (SELECT 1                                          
                        FROM CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)           
                       WHERE AE.CUSTOMER_NO = AT.CUSTOMER_NO            
                         AND EMAIL_EVENT_CD = 'ECS20'                   
                         AND PROCESSED_CD IN ('S', 'R'))                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-WELCOME-DISP-FL                                       
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_CUST_PREM_HIST CH                                     
MFA-TR*         WHERE AT.CUSTOMER_NO = :CU-CUSTOMER-NO                          
MFA-TR*           AND AT.ACCOUNT_TYPE_CODE = 'R'                                
MFA-TR*           AND AT.COMPANY_NO = '26'                                      
MFA-TR*           AND AT.CODE_ACCT_STAT = 'A'                                   
MFA-TR*           AND AT.ACCOUNT_NO = CH.ACCOUNT_NO                             
MFA-TR*           AND CH.DATE_UTIL_SVC_STRT >= :WS-LAST-WKIT-DT                 
MFA-TR*           AND CH.DATE_UTIL_SVC_STRT <= :WS-CURRENT-DATE                 
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*              (SELECT 1                                                  
MFA-TR*                 FROM CSS_ACCOUNT AT1,                                   
MFA-TR*                      CSS_CUST_PREM_HIST CH1                             
MFA-TR*                WHERE AT.ACCOUNT_NO <> AT1.ACCOUNT_NO                    
MFA-TR*                  AND AT.CUSTOMER_NO = AT1.CUSTOMER_NO                   
MFA-TR*                  AND AT1.ACCOUNT_NO = CH1.ACCOUNT_NO                    
MFA-TR*                  AND AT1.COMPANY_NO = '26'                              
MFA-TR*                  AND AT1.ACCOUNT_TYPE_CODE = 'R'                        
MFA-TR*                  AND CH1.DATE_UTIL_SVC_STRT <                           
MFA-TR*                      CH.DATE_UTIL_SVC_STRT)                             
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*              (SELECT 1                                                  
MFA-TR*                 FROM CSS_BATCH_EMAIL AE                                 
MFA-TR*                WHERE AE.CUSTOMER_NO = AT.CUSTOMER_NO                    
MFA-TR*                  AND EMAIL_EVENT_CD = 'ECS20'                           
MFA-TR*                  AND PROCESSED_CD IN ('S', 'R'))                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7920                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-WELCOME-DISP-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-WELCOME-DISP-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7920'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CSS_CUST_PREM_HIST' TO TABLE-2                 
                   MOVE 'CSS_BATCH_EMAIL'    TO TABLE-3                 
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04700_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04700_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04700_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04700_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04700_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8003'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04700_R3'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8004-DELETE-GTT4-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04700_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04700_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8004'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04700_R4'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8004-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8005-DELETE-GTT5-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04700_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04700_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04700_R5'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8006-DELETE-GTT6-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04700_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04700_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8006'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04700_R6'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8006-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04700_R2                            
             (                                                          
              RETURN_CODE,                                              
              PHONE_TYPE,                                               
              PHONE_NUMBER,                                             
              PHONE_EXT,                                                
              PHONE_MOBILE_FL,                                          
              PHONE_MKT_FL,                                             
              PHONE_MKT_DT,                                             
              PHONE_TEXT_FL                                             
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-PHONE-TYPE,                                           
               :S-PHONE-NUMBER,                                         
               :S-PHONE-EXT,                                            
               :S-PHONE-MOBILE-FL,                                      
               :S-PHONE-MKT-FL,                                         
               :S-PHONE-MKT-DT,                                         
               :S-PHONE-TEXT-FL                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04700_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PHONE_TYPE,                                                       
MFA-TR*       PHONE_NUMBER,                                                     
MFA-TR*       PHONE_EXT,                                                        
MFA-TR*       PHONE_MOBILE_FL,                                                  
MFA-TR*       PHONE_MKT_FL,                                                     
MFA-TR*       PHONE_MKT_DT,                                                     
MFA-TR*       PHONE_TEXT_FL                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-PHONE-TYPE,                                                   
MFA-TR*        :S-PHONE-NUMBER,                                                 
MFA-TR*        :S-PHONE-EXT,                                                    
MFA-TR*        :S-PHONE-MOBILE-FL,                                              
MFA-TR*        :S-PHONE-MKT-FL,                                                 
MFA-TR*        :S-PHONE-MKT-DT,                                                 
MFA-TR*        :S-PHONE-TEXT-FL                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04700_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04700_R3                            
             (                                                          
              RETURN_CODE,                                              
              EMAIL_ADDRESS,                                            
              EMAIL_TYPE_CD,                                            
              EMAIL_MKT_FL,                                             
              EMAIL_MKT_DT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-EMAIL-ADDRESS,                                        
               :S-EMAIL-TYPE-CD,                                        
               :S-EMAIL-MKT-FL,                                         
               :S-EMAIL-MKT-DT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04700_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       EMAIL_ADDRESS,                                                    
MFA-TR*       EMAIL_TYPE_CD,                                                    
MFA-TR*       EMAIL_MKT_FL,                                                     
MFA-TR*       EMAIL_MKT_DT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-EMAIL-ADDRESS,                                                
MFA-TR*        :S-EMAIL-TYPE-CD,                                                
MFA-TR*        :S-EMAIL-MKT-FL,                                                 
MFA-TR*        :S-EMAIL-MKT-DT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04700_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-SEND-RESULT-4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04700_R4                            
             (                                                          
              RETURN_CODE,                                              
              NAME_ID,                                                  
              NAME_TYPE,                                                
              NAME_FORMAT,                                              
              TITLE_PREFIX,                                             
              FIRST_NAME,                                               
              MIDDLE_NAME,                                              
              LAST_NAME,                                                
              TITLE_SUFFIX,                                             
              FULL_NAME                                                 
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-4,                                        
               :S-NAME-ID,                                              
               :S-NAME-TYPE,                                            
               :S-NAME-FORMAT-4,                                        
               :S-TITLE-PREFIX,                                         
               :S-FIRST-NAME,                                           
               :S-MIDDLE-NAME,                                          
               :S-LAST-NAME,                                            
               :S-TITLE-SUFFIX,                                         
               :S-FULL-NAME                                             
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04700_R4                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       NAME_ID,                                                          
MFA-TR*       NAME_TYPE,                                                        
MFA-TR*       NAME_FORMAT,                                                      
MFA-TR*       TITLE_PREFIX,                                                     
MFA-TR*       FIRST_NAME,                                                       
MFA-TR*       MIDDLE_NAME,                                                      
MFA-TR*       LAST_NAME,                                                        
MFA-TR*       TITLE_SUFFIX,                                                     
MFA-TR*       FULL_NAME                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-4,                                                
MFA-TR*        :S-NAME-ID,                                                      
MFA-TR*        :S-NAME-TYPE,                                                    
MFA-TR*        :S-NAME-FORMAT-4,                                                
MFA-TR*        :S-TITLE-PREFIX,                                                 
MFA-TR*        :S-FIRST-NAME,                                                   
MFA-TR*        :S-MIDDLE-NAME,                                                  
MFA-TR*        :S-LAST-NAME,                                                    
MFA-TR*        :S-TITLE-SUFFIX,                                                 
MFA-TR*        :S-FULL-NAME                                                     
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04700_R4'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-SEND-RESULT-5.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04700_R5                            
             (                                                          
              RETURN_CODE,                                              
              ADDRESS_TYPE,                                             
              ADDRESS_ID,                                               
              ADDRESS_FORMAT,                                           
              FF_STREET_1,                                              
              FF_STREET_2,                                              
              FF_CITY_STATE,                                            
              FF_ZIP_CODE,                                              
              FF_COUNTRY,                                               
              FF_CITY,                                                  
              FF_STATE,                                                 
              IAT_CITY,                                                 
              IAT_PROVINCE,                                             
              IAT_POST_CODE,                                            
              FMT_STREET_1,                                             
              FMT_STREET_2,                                             
              TOWN,                                                     
              STATE,                                                    
              ZIP_CODE,                                                 
              ZIP_CODE_PLUS_FOUR,                                       
              ZIP_CODE_TOKEN,                                           
              DELIV_PT,                                                 
              HOUSE_NO,                                                 
              ADDR_PREFIX_1,                                            
              ADDR_PREFIX_2,                                            
              STREET_NAME,                                              
              STREET_SUFFIX,                                            
              ADDR_SUFFIX,                                              
              STREET_LOC_1,                                             
              STREET_LOC_2,                                             
              PO_BOX_FL,                                                
              ADDRESS_OVERFLOW                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-5,                                        
               :S-ADDRESS-TYPE,                                         
               :S-ADDRESS-ID,                                           
               :S-ADDRESS-FORMAT,                                       
               :S-FF-STREET-1,                                          
               :S-FF-STREET-2,                                          
               :S-FF-CITY-STATE,                                        
               :S-FF-ZIP-CODE,                                          
               :S-FF-COUNTRY,                                           
               :S-FF-CITY,                                              
               :S-FF-STATE,                                             
               :S-IAT-CITY,                                             
               :S-IAT-PROVINCE,                                         
               :S-IAT-POST-CODE,                                        
               :S-FMT-STREET-1,                                         
               :S-FMT-STREET-2,                                         
               :S-TOWN,                                                 
               :S-STATE,                                                
               :S-ZIP-CODE,                                             
               :S-ZIP-CODE-4,                                           
               :S-ZIP-CODE-TOKEN,                                       
               :S-USPS-DELIV-PT,                                        
               :S-HOUSE-NO,                                             
               :S-ADDR-PREFIX-1,                                        
               :S-ADDR-PREFIX-2,                                        
               :S-STREET-NAME,                                          
               :S-STREET-SUFFIX,                                        
               :S-ADDR-SUFFIX,                                          
               :S-STREET-LOC-1,                                         
               :S-STREET-LOC-2,                                         
               :S-PO-BOX-FL,                                            
               :S-ADDRESS-OVERFLOW                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04700_R5                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ADDRESS_TYPE,                                                     
MFA-TR*       ADDRESS_ID,                                                       
MFA-TR*       ADDRESS_FORMAT,                                                   
MFA-TR*       FF_STREET_1,                                                      
MFA-TR*       FF_STREET_2,                                                      
MFA-TR*       FF_CITY_STATE,                                                    
MFA-TR*       FF_ZIP_CODE,                                                      
MFA-TR*       FF_COUNTRY,                                                       
MFA-TR*       FF_CITY,                                                          
MFA-TR*       FF_STATE,                                                         
MFA-TR*       IAT_CITY,                                                         
MFA-TR*       IAT_PROVINCE,                                                     
MFA-TR*       IAT_POST_CODE,                                                    
MFA-TR*       FMT_STREET_1,                                                     
MFA-TR*       FMT_STREET_2,                                                     
MFA-TR*       TOWN,                                                             
MFA-TR*       STATE,                                                            
MFA-TR*       ZIP_CODE,                                                         
MFA-TR*       ZIP_CODE_PLUS_FOUR,                                               
MFA-TR*       ZIP_CODE_TOKEN,                                                   
MFA-TR*       DELIV_PT,                                                         
MFA-TR*       HOUSE_NO,                                                         
MFA-TR*       ADDR_PREFIX_1,                                                    
MFA-TR*       ADDR_PREFIX_2,                                                    
MFA-TR*       STREET_NAME,                                                      
MFA-TR*       STREET_SUFFIX,                                                    
MFA-TR*       ADDR_SUFFIX,                                                      
MFA-TR*       STREET_LOC_1,                                                     
MFA-TR*       STREET_LOC_2,                                                     
MFA-TR*       PO_BOX_FL,                                                        
MFA-TR*       ADDRESS_OVERFLOW                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-5,                                                
MFA-TR*        :S-ADDRESS-TYPE,                                                 
MFA-TR*        :S-ADDRESS-ID,                                                   
MFA-TR*        :S-ADDRESS-FORMAT,                                               
MFA-TR*        :S-FF-STREET-1,                                                  
MFA-TR*        :S-FF-STREET-2,                                                  
MFA-TR*        :S-FF-CITY-STATE,                                                
MFA-TR*        :S-FF-ZIP-CODE,                                                  
MFA-TR*        :S-FF-COUNTRY,                                                   
MFA-TR*        :S-FF-CITY,                                                      
MFA-TR*        :S-FF-STATE,                                                     
MFA-TR*        :S-IAT-CITY,                                                     
MFA-TR*        :S-IAT-PROVINCE,                                                 
MFA-TR*        :S-IAT-POST-CODE,                                                
MFA-TR*        :S-FMT-STREET-1,                                                 
MFA-TR*        :S-FMT-STREET-2,                                                 
MFA-TR*        :S-TOWN,                                                         
MFA-TR*        :S-STATE,                                                        
MFA-TR*        :S-ZIP-CODE,                                                     
MFA-TR*        :S-ZIP-CODE-4,                                                   
MFA-TR*        :S-ZIP-CODE-TOKEN,                                               
MFA-TR*        :S-USPS-DELIV-PT,                                                
MFA-TR*        :S-HOUSE-NO,                                                     
MFA-TR*        :S-ADDR-PREFIX-1,                                                
MFA-TR*        :S-ADDR-PREFIX-2,                                                
MFA-TR*        :S-STREET-NAME,                                                  
MFA-TR*        :S-STREET-SUFFIX,                                                
MFA-TR*        :S-ADDR-SUFFIX,                                                  
MFA-TR*        :S-STREET-LOC-1,                                                 
MFA-TR*        :S-STREET-LOC-2,                                                 
MFA-TR*        :S-PO-BOX-FL,                                                    
MFA-TR*        :S-ADDRESS-OVERFLOW                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04700_R5'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-SEND-RESULT-6.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04700_R6                            
             (                                                          
              RETURN_CODE,                                              
              BA_ADDRESS_FORMAT,                                        
              BA_ADDRESS_ID,                                            
              ACCOUNT_NO,                                               
              SERV_ADDRESS,                                             
              CODE_ACCT_STAT,                                           
              COMPANY_NO                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-6,                                        
               :S-BA-ADDRESS-FORMAT,                                    
               :S-BA-ADDRESS-ID,                                        
               :S-ACCOUNT-NO,                                           
               :S-SERV-ADDRESS,                                         
               :S-CODE-ACCT-STAT,                                       
               :S-COMPANY-NO                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04700_R6                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BA_ADDRESS_FORMAT,                                                
MFA-TR*       BA_ADDRESS_ID,                                                    
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       SERV_ADDRESS,                                                     
MFA-TR*       CODE_ACCT_STAT,                                                   
MFA-TR*       COMPANY_NO                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-6,                                                
MFA-TR*        :S-BA-ADDRESS-FORMAT,                                            
MFA-TR*        :S-BA-ADDRESS-ID,                                                
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-SERV-ADDRESS,                                                 
MFA-TR*        :S-CODE-ACCT-STAT,                                               
MFA-TR*        :S-COMPANY-NO                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8600'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04700_R6'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT04-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-4                             
               EXEC SQL                                                 
                   OPEN N4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT05-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-5                             
               EXEC SQL                                                 
                   OPEN N5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT06-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C6                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-6                             
               EXEC SQL                                                 
                   OPEN N6                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
