       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04698.                                          
COB303 DATE-WRITTEN. FEBRUARY 11, 2014.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS CONTACT DATA.                           *        
      *  RESULTS SETS:                                                 *        
      *     1.  CONTACT DATA                                           *        
      *     2.  EMAIL ADDRESSES                                        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/11/14    FMB      NEW PROGRAM.                                      
D05317*  11/12/15    FMB      EMAIL DATE TO TIMESTAMP.                          
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04698'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04698 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCPR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCONEML                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCONSTA                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSALSPL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04698_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04698_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-CONTACT-ID        PIC S9(10)V COMP-3 VALUE 0.       
               10 S-CONTACT-TYPE      PIC X(02) VALUE SPACES.           
               10 S-ENTITY-TYPE       PIC X(01) VALUE SPACES.           
               10 S-NAME-FORMAT       PIC X(01) VALUE SPACES.           
               10 S-TITLE             PIC X(09) VALUE SPACES.           
               10 S-FIRST-NAME        PIC X(15) VALUE SPACES.           
               10 S-MIDDLE-NAME       PIC X(15) VALUE SPACES.           
               10 S-LAST-NAME         PIC X(40) VALUE SPACES.           
               10 S-SUFFIX            PIC X(03) VALUE SPACES.           
               10 S-FULL-NAME         PIC X(70) VALUE SPACES.           
               10 S-TAX-ID            PIC X(09) VALUE SPACES.           
               10 S-WEBSITE-ADDR      PIC X(75) VALUE SPACES.           
               10 S-DOB               PIC X(10) VALUE SPACES.           
               10 S-EMPLOYEE-TITLE    PIC X(50) VALUE SPACES.           
               10 S-BUSINESS-NAME     PIC X(50) VALUE SPACES.           
               10 S-EMPLOYER          PIC X(50) VALUE SPACES.           
               10 S-OTHER-ID          PIC X(16) VALUE SPACES.           
               10 S-OTHER-ID-TYPE     PIC X(12) VALUE SPACES.           
               10 S-DLN               PIC X(19) VALUE SPACES.           
               10 S-CODE-STATE-ID     PIC X(02) VALUE SPACES.           
               10 S-SSN               PIC X(09) VALUE SPACES.           
               10 S-ITIN              PIC X(09) VALUE SPACES.           
               10 S-ALLOW-CALL-FL     PIC X(01) VALUE SPACES.           
               10 S-WORK-PHONE        PIC X(10) VALUE SPACES.           
               10 S-WORK-PHONE-EXT    PIC X(06) VALUE SPACES.           
               10 S-WORK-MOBILE-FL    PIC X(01) VALUE SPACES.           
               10 S-WORK-MKT-FL       PIC X(01) VALUE SPACES.           
               10 S-WORK-MKT-DT       PIC X(10) VALUE SPACES.           
               10 S-HOME-PHONE        PIC X(10) VALUE SPACES.           
               10 S-HOME-MOBILE-FL    PIC X(01) VALUE SPACES.           
               10 S-HOME-MKT-FL       PIC X(01) VALUE SPACES.           
               10 S-HOME-MKT-DT       PIC X(10) VALUE SPACES.           
               10 S-ALT-PHONE         PIC X(10) VALUE SPACES.           
               10 S-ALT-MOBILE-FL     PIC X(01) VALUE SPACES.           
               10 S-ALT-MKT-FL        PIC X(01) VALUE SPACES.           
               10 S-ALT-MKT-DT        PIC X(10) VALUE SPACES.           
               10 S-FAX-PHONE         PIC X(10) VALUE SPACES.           
               10 S-FAX-MOBILE-FL     PIC X(01) VALUE SPACES.           
               10 S-FAX-MKT-FL        PIC X(01) VALUE SPACES.           
               10 S-FAX-MKT-DT        PIC X(10) VALUE SPACES.           
               10 S-POSITION          PIC X(30) VALUE SPACES.           
               10 S-EFF-DT            PIC X(10) VALUE SPACES.           
               10 S-EXP-DT            PIC X(10) VALUE SPACES.           
               10 S-EFF-CD            PIC X(01) VALUE SPACES.           
               10 S-ACCESS-LEVEL-CD   PIC X(02) VALUE SPACES.           
               10 S-MEMO-BILL-IND     PIC X(01) VALUE SPACES.           
               10 S-SS-USERID         PIC X(07) VALUE SPACES.           
               10 S-ADDRESS-FORMAT    PIC X(01) VALUE SPACES.           
               10 S-FREEFORM.                                           
                  15 S-FF-STREET-1    PIC X(55) VALUE SPACES.           
                  15 S-FF-STREET-2    PIC X(55) VALUE SPACES.           
                  15 S-FF-CITY-STATE  PIC X(30) VALUE SPACES.           
                  15 S-FF-ZIP-CODE    PIC X(09) VALUE SPACES.           
                  15 S-FF-COUNTRY     PIC X(35) VALUE SPACES.           
                  15 S-FF-CITY        PIC X(30) VALUE SPACES.           
                  15 S-FF-STATE       PIC X(02) VALUE SPACES.           
               10 S-FORMATTED.                                          
                  15 S-FMT-STREET-1   PIC X(55) VALUE SPACES.           
                  15 S-FMT-STREET-2   PIC X(55) VALUE SPACES.           
                  15 S-TOWN           PIC X(26) VALUE SPACES.           
                  15 S-STATE          PIC X(02) VALUE SPACES.           
                  15 S-ZIP-CODE       PIC X(05) VALUE SPACES.           
                  15 S-ZIP-CODE-4     PIC X(04) VALUE SPACES.           
                  15 S-ZIP-CODE-TOKEN PIC X(01) VALUE SPACES.           
                  15 S-USPS-DELIV-PT  PIC X(02) VALUE SPACES.           
                  15 S-HOUSE-NO       PIC X(15) VALUE SPACES.           
                  15 S-ADDR-PREFIX-1  PIC X(03) VALUE SPACES.           
                  15 S-ADDR-PREFIX-2  PIC X(02) VALUE SPACES.           
                  15 S-STREET-NAME    PIC X(30) VALUE SPACES.           
                  15 S-STREET-SUFFIX  PIC X(04) VALUE SPACES.           
                  15 S-ADDR-SUFFIX    PIC X(02) VALUE SPACES.           
                  15 S-STREET-LOC-1   PIC X(04) VALUE SPACES.           
                  15 S-STREET-LOC-2   PIC X(11) VALUE SPACES.           
                  15 S-PO-BOX-FL      PIC X(01) VALUE SPACES.           
               10 S-VALIDATION-TS     PIC X(26) VALUE SPACES.           
               10 S-CONFIRM-FL        PIC X(01) VALUE SPACES.           
               10 S-CREATE-DT         PIC X(10) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-EMAIL-ADDRESS     PIC X(100) VALUE SPACES.          
               10 S-EMAIL-TYPE-CD     PIC X(02) VALUE SPACES.           
               10 S-EMAIL-MKT-FL      PIC X(01) VALUE SPACES.           
               10 S-EMAIL-MKT-DT      PIC X(10) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CONTACT-ID-CHAR       PIC X(10).                      
           05  WS-CONTACT-ID-NUM        REDEFINES WS-CONTACT-ID-CHAR    
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04698'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ADDRESS-LINE-1        PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE-2        PIC X(80) VALUE SPACES.         
           05  WS-ENTITY-FOUND-FL       PIC X(01) VALUE 'N'.            
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
           05  WS-SPACES                PIC S9(02) COMP-3 VALUE +0.     
           05  WS-LENGTH                PIC S9(02) COMP-3 VALUE +0.     
           05  WS-SSN-FORMAT            PIC X(01) VALUE SPACES.         
           05  WS-UNFORMATTED-SSN       PIC X(09) VALUE SPACES.         
           05  WS-SUB1                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUB2                  PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE EMAIL-CURSOR CURSOR FOR                           
               SELECT EMAIL_TYPE_CD,                                    
                      EMAIL_ADDRESS_TX,                                 
                      PERMISN_TO_MKT_FL,                                
D05317                REPLACE(REPLACE(CONVERT(CHAR(26), 
           PERMISN_TO_MKT_TS, 121), ' ', '-'), ':', '.') 
           PERMISN_TO_MKT_TS                                 
                 FROM CSS_CONTACT_EMAIL WITH(READUNCOMMITTED)                   
                WHERE CONTACT_ID = :CV-CONTACT-ID                       
                  AND EMAIL_TYPE_CD LIKE 'N%'                           
                  AND EMAIL_ADDRESS_TX > ' '                            
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EMAIL-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT EMAIL_TYPE_CD,                                            
MFA-TR*               EMAIL_ADDRESS_TX,                                         
MFA-TR*               PERMISN_TO_MKT_FL,                                        
MFA-TR*               PERMISN_TO_MKT_TS                                         
MFA-TR*          FROM CSS_CONTACT_EMAIL                                         
MFA-TR*         WHERE CONTACT_ID = :CV-CONTACT-ID                               
MFA-TR*           AND EMAIL_TYPE_CD LIKE 'N%'                                   
MFA-TR*           AND EMAIL_ADDRESS_TX > ' '                                    
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1    AS RETURN_CODE,               
                      :S-STATUS-CODE      AS STATUS_CODE,               
                      :S-CONTACT-ID       AS CONTACT_ID,                
                      :S-CONTACT-TYPE     AS CONTACT_TYPE,              
                      :S-ENTITY-TYPE      AS ENTITY_TYPE,               
                      :S-NAME-FORMAT      AS NAME_FORMAT,               
                      :S-TITLE            AS TITLE,                     
                      :S-FIRST-NAME       AS FIRST_NAME,                
                      :S-MIDDLE-NAME      AS MIDDLE_NAME,               
                      :S-LAST-NAME        AS LAST_NAME,                 
                      :S-SUFFIX           AS SUFFIX,                    
                      :S-FULL-NAME        AS FULL_NAME,                 
                      :S-TAX-ID           AS TAX_ID,                    
                      :S-WEBSITE-ADDR     AS WEBSITE_ADDR,              
                      :S-DOB              AS DATE_OF_BIRTH,             
                      :S-EMPLOYEE-TITLE   AS EMPLOYEE_TITLE,            
                      :S-BUSINESS-NAME    AS BUSINESS_NAME,             
                      :S-EMPLOYER         AS EMPLOYER,                  
                      :S-OTHER-ID         AS OTHER_ID,                  
                      :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,             
                      :S-DLN              AS DLN,                       
                      :S-CODE-STATE-ID    AS CODE_STATE_ID,             
                      :S-SSN              AS SSN,                       
                      :S-ITIN AS ITIN,                                  
                      :S-ALLOW-CALL-FL    AS ALLOW_CALL_FL,             
                      :S-WORK-PHONE       AS WORK_PHONE,                
                      :S-WORK-PHONE-EXT   AS WORK_PHONE_EXT,            
                      :S-WORK-MOBILE-FL   AS WORK_MOBILE_FL,            
                      :S-WORK-MKT-FL      AS WORK_MKT_FL,               
                      :S-WORK-MKT-DT      AS WORK_MKT_DT,               
                      :S-HOME-PHONE       AS HOME_PHONE,                
                      :S-HOME-MOBILE-FL   AS HOME_MOBILE_FL,            
                      :S-HOME-MKT-FL      AS HOME_MKT_FL,               
                      :S-HOME-MKT-DT      AS HOME_MKT_DT,               
                      :S-ALT-PHONE        AS ALT_PHONE,                 
                      :S-ALT-MOBILE-FL    AS ALT_MOBILE_FL,             
                      :S-ALT-MKT-FL       AS ALT_MKT_FL,                
                      :S-ALT-MKT-DT       AS ALT_MKT_DT,                
                      :S-FAX-PHONE        AS FAX_PHONE,                 
                      :S-FAX-MOBILE-FL    AS FAX_MOBILE_FL,             
                      :S-FAX-MKT-FL       AS FAX_MKT_FL,                
                      :S-FAX-MKT-DT       AS FAX_MKT_DT,                
                      :S-POSITION         AS POSITION,                  
                      :S-EFF-DT           AS EFFECTIVE_DT,              
                      :S-EXP-DT           AS EXPIRATION_DT,             
                      :S-EFF-CD           AS EFFECTIVE_CD,              
                      :S-ACCESS-LEVEL-CD  AS ACCESS_LEVEL_CD,           
                      :S-MEMO-BILL-IND    AS MEMO_BILL_IND,             
                      :S-SS-USERID        AS SALES_SPCL_USERID,         
                      :S-ADDRESS-FORMAT   AS ADDRESS_FORMAT,            
                      :S-FF-STREET-1      AS FF_STREET_1,               
                      :S-FF-STREET-2      AS FF_STREET_2,               
                      :S-FF-CITY-STATE    AS FF_CITY_STATE,             
                      :S-FF-ZIP-CODE      AS FF_ZIP_CODE,               
                      :S-FF-COUNTRY       AS FF_COUNTRY,                
                      :S-FF-CITY          AS FF_CITY,                   
                      :S-FF-STATE         AS FF_STATE,                  
                      :S-FMT-STREET-1     AS FMT_STREET_1,              
                      :S-FMT-STREET-2     AS FMT_STREET_2,              
                      :S-TOWN             AS TOWN,                      
                      :S-STATE            AS STATE,                     
                      :S-ZIP-CODE         AS ZIP_CODE,                  
                      :S-ZIP-CODE-4       AS ZIP_CODE_4,                
                      :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,           
                      :S-USPS-DELIV-PT     AS DELIV_PT,                 
                      :S-HOUSE-NO          AS [HOUSE-NO],                 
                      :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,            
                      :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,            
                      :S-STREET-NAME       AS STREET_NAME,              
                      :S-STREET-SUFFIX     AS STREET_SUFFIX,            
                      :S-ADDR-SUFFIX       AS ADDR_SUFFIX,              
                      :S-STREET-LOC-1      AS STREET_LOC_1,             
                      :S-STREET-LOC-2      AS STREET_LOC_2,             
                      :S-PO-BOX-FL         AS PO_BOX_FL,                
                      :S-VALIDATION-TS    AS VALIDATION_TS,             
                      :S-CONFIRM-FL       AS CONFIRM_FL,                
                      :S-CREATE-DT        AS CREATED_DT                 
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1    AS RETURN_CODE,                       
MFA-TR*               :S-STATUS-CODE      AS STATUS_CODE,                       
MFA-TR*               :S-CONTACT-ID       AS CONTACT_ID,                        
MFA-TR*               :S-CONTACT-TYPE     AS CONTACT_TYPE,                      
MFA-TR*               :S-ENTITY-TYPE      AS ENTITY_TYPE,                       
MFA-TR*               :S-NAME-FORMAT      AS NAME_FORMAT,                       
MFA-TR*               :S-TITLE            AS TITLE,                             
MFA-TR*               :S-FIRST-NAME       AS FIRST_NAME,                        
MFA-TR*               :S-MIDDLE-NAME      AS MIDDLE_NAME,                       
MFA-TR*               :S-LAST-NAME        AS LAST_NAME,                         
MFA-TR*               :S-SUFFIX           AS SUFFIX,                            
MFA-TR*               :S-FULL-NAME        AS FULL_NAME,                         
MFA-TR*               :S-TAX-ID           AS TAX_ID,                            
MFA-TR*               :S-WEBSITE-ADDR     AS WEBSITE_ADDR,                      
MFA-TR*               :S-DOB              AS DATE_OF_BIRTH,                     
MFA-TR*               :S-EMPLOYEE-TITLE   AS EMPLOYEE_TITLE,                    
MFA-TR*               :S-BUSINESS-NAME    AS BUSINESS_NAME,                     
MFA-TR*               :S-EMPLOYER         AS EMPLOYER,                          
MFA-TR*               :S-OTHER-ID         AS OTHER_ID,                          
MFA-TR*               :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,                     
MFA-TR*               :S-DLN              AS DLN,                               
MFA-TR*               :S-CODE-STATE-ID    AS CODE_STATE_ID,                     
MFA-TR*               :S-SSN              AS SSN,                               
MFA-TR*               :S-ITIN AS ITIN,                                          
MFA-TR*               :S-ALLOW-CALL-FL    AS ALLOW_CALL_FL,                     
MFA-TR*               :S-WORK-PHONE       AS WORK_PHONE,                        
MFA-TR*               :S-WORK-PHONE-EXT   AS WORK_PHONE_EXT,                    
MFA-TR*               :S-WORK-MOBILE-FL   AS WORK_MOBILE_FL,                    
MFA-TR*               :S-WORK-MKT-FL      AS WORK_MKT_FL,                       
MFA-TR*               :S-WORK-MKT-DT      AS WORK_MKT_DT,                       
MFA-TR*               :S-HOME-PHONE       AS HOME_PHONE,                        
MFA-TR*               :S-HOME-MOBILE-FL   AS HOME_MOBILE_FL,                    
MFA-TR*               :S-HOME-MKT-FL      AS HOME_MKT_FL,                       
MFA-TR*               :S-HOME-MKT-DT      AS HOME_MKT_DT,                       
MFA-TR*               :S-ALT-PHONE        AS ALT_PHONE,                         
MFA-TR*               :S-ALT-MOBILE-FL    AS ALT_MOBILE_FL,                     
MFA-TR*               :S-ALT-MKT-FL       AS ALT_MKT_FL,                        
MFA-TR*               :S-ALT-MKT-DT       AS ALT_MKT_DT,                        
MFA-TR*               :S-FAX-PHONE        AS FAX_PHONE,                         
MFA-TR*               :S-FAX-MOBILE-FL    AS FAX_MOBILE_FL,                     
MFA-TR*               :S-FAX-MKT-FL       AS FAX_MKT_FL,                        
MFA-TR*               :S-FAX-MKT-DT       AS FAX_MKT_DT,                        
MFA-TR*               :S-POSITION         AS POSITION,                          
MFA-TR*               :S-EFF-DT           AS EFFECTIVE_DT,                      
MFA-TR*               :S-EXP-DT           AS EXPIRATION_DT,                     
MFA-TR*               :S-EFF-CD           AS EFFECTIVE_CD,                      
MFA-TR*               :S-ACCESS-LEVEL-CD  AS ACCESS_LEVEL_CD,                   
MFA-TR*               :S-MEMO-BILL-IND    AS MEMO_BILL_IND,                     
MFA-TR*               :S-SS-USERID        AS SALES_SPCL_USERID,                 
MFA-TR*               :S-ADDRESS-FORMAT   AS ADDRESS_FORMAT,                    
MFA-TR*               :S-FF-STREET-1      AS FF_STREET_1,                       
MFA-TR*               :S-FF-STREET-2      AS FF_STREET_2,                       
MFA-TR*               :S-FF-CITY-STATE    AS FF_CITY_STATE,                     
MFA-TR*               :S-FF-ZIP-CODE      AS FF_ZIP_CODE,                       
MFA-TR*               :S-FF-COUNTRY       AS FF_COUNTRY,                        
MFA-TR*               :S-FF-CITY          AS FF_CITY,                           
MFA-TR*               :S-FF-STATE         AS FF_STATE,                          
MFA-TR*               :S-FMT-STREET-1     AS FMT_STREET_1,                      
MFA-TR*               :S-FMT-STREET-2     AS FMT_STREET_2,                      
MFA-TR*               :S-TOWN             AS TOWN,                              
MFA-TR*               :S-STATE            AS STATE,                             
MFA-TR*               :S-ZIP-CODE         AS ZIP_CODE,                          
MFA-TR*               :S-ZIP-CODE-4       AS ZIP_CODE_4,                        
MFA-TR*               :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,                   
MFA-TR*               :S-USPS-DELIV-PT     AS DELIV_PT,                         
MFA-TR*               :S-HOUSE-NO          AS HOUSE-NO,                         
MFA-TR*               :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,                    
MFA-TR*               :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,                    
MFA-TR*               :S-STREET-NAME       AS STREET_NAME,                      
MFA-TR*               :S-STREET-SUFFIX     AS STREET_SUFFIX,                    
MFA-TR*               :S-ADDR-SUFFIX       AS ADDR_SUFFIX,                      
MFA-TR*               :S-STREET-LOC-1      AS STREET_LOC_1,                     
MFA-TR*               :S-STREET-LOC-2      AS STREET_LOC_2,                     
MFA-TR*               :S-PO-BOX-FL         AS PO_BOX_FL,                        
MFA-TR*               :S-VALIDATION-TS    AS VALIDATION_TS,                     
MFA-TR*               :S-CONFIRM-FL       AS CONFIRM_FL,                        
MFA-TR*               :S-CREATE-DT        AS CREATED_DT                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      EMAIL_ADDRESS     AS EMAIL_ADDRESS,               
                      EMAIL_TYPE_CD     AS EMAIL_TYPE_CD,               
                      EMAIL_MKT_FL      AS EMAIL_MKT_FL,                
                      EMAIL_MKT_DT      AS EMAIL_MKT_DT                 
                FROM #CSR04698_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               EMAIL_ADDRESS     AS EMAIL_ADDRESS,                       
MFA-TR*               EMAIL_TYPE_CD     AS EMAIL_TYPE_CD,                       
MFA-TR*               EMAIL_MKT_FL      AS EMAIL_MKT_FL,                        
MFA-TR*               EMAIL_MKT_DT      AS EMAIL_MKT_DT                         
MFA-TR*         FROM SESSION.CSR04698_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,            
                      :S-EMAIL-TYPE-CD     AS EMAIL_TYPE_CD,            
                      :S-EMAIL-MKT-FL      AS EMAIL_MKT_FL,             
                      :S-EMAIL-MKT-DT      AS EMAIL_MKT_DT              
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,                    
MFA-TR*               :S-EMAIL-TYPE-CD     AS EMAIL_TYPE_CD,                    
MFA-TR*               :S-EMAIL-MKT-FL      AS EMAIL_MKT_FL,                     
MFA-TR*               :S-EMAIL-MKT-DT      AS EMAIL_MKT_DT                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CONTACT-ID         PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CONTACT-ID.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04698_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04698_R2
              (                                                          
               RETURN_CODE          INT,                            
               EMAIL_ADDRESS VARCHAR(100)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                       
               EMAIL_TYPE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
               EMAIL_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               EMAIL_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04698_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CONTACT-ID NOT NUMERIC                               
               MOVE ZEROES TO LINK-CONTACT-ID
           END-IF.                          
                                                                        
           MOVE LINK-CONTACT-ID TO WS-CONTACT-ID-CHAR.                  
           MOVE WS-CONTACT-ID-NUM TO CV-CONTACT-ID.                     
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF LINK-CONTACT-ID = ZEROES                                  
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-LAST-NAME                     
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           PERFORM 7100-SELECT-CONTACT-INFO THRU 7100-EXIT.             
           PERFORM 7600-SELECT-CONTACT-STATS THRU 7600-EXIT.            
           PERFORM 2005-DETERMINE-ENTITY THRU 2005-EXIT.                
                                                                        
           MOVE CV-CONTACT-ID TO S-CONTACT-ID.                          
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
           MOVE DQ-FIRST-NAME TO S-FIRST-NAME.                          
           MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME.                        
           MOVE DQ-LAST-NAME TO S-LAST-NAME.                            
           MOVE DQ-TITLE-PREFIX TO S-TITLE.                             
           MOVE DQ-TITLE-SUFFIX-1 TO S-SUFFIX.                          
           IF DQ-NAME-FORMAT = 'B'                                      
               MOVE DQ-FULL-NAME TO S-FULL-NAME                         
           ELSE                                                         
               MOVE SPACES TO S-FULL-NAME
           END-IF.                              
           IF DQ-NAME-FORMAT = 'I' AND                                  
              DQ-LAST-NAME <= SPACES AND                                
              DQ-FULL-NAME > SPACES                                     
                  MOVE DQ-FULL-NAME TO S-FULL-NAME
           END-IF.                     
           MOVE CV-CONTACT-TYPE TO S-CONTACT-TYPE.                      
           MOVE CV-CONTACT-POSITION-TEXT TO S-POSITION.                 
           MOVE CV-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD.                
           MOVE CV-MEMO-BILL-IND TO S-MEMO-BILL-IND.                    
           MOVE CV-CONTACT-EXP-DT TO S-EXP-DT.                          
           MOVE CV-CONTACT-EFF-DT TO S-EFF-DT.                          
           MOVE CV-EFFECTIVE-CD TO S-EFF-CD.                            
           MOVE CV-VALIDATION-TS TO S-VALIDATION-TS.                    
           MOVE CV-DATE-CREATED TO S-CREATE-DT.                         
           MOVE 'CASA-CONTACT-CONFIRM' TO C8-DELINQ-CD                  
           MOVE WS-COMPANY-NO TO C8-COMPANY-NO                          
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT           
           EVALUATE C8-DELINQ-VALUE                                     
               WHEN 0                                                   
                   MOVE 'N' TO S-CONFIRM-FL                             
               WHEN 1                                                   
                   MOVE 'Y' TO S-CONFIRM-FL                             
           END-EVALUATE.                                                
           MOVE 3H-TAX-ID TO S-TAX-ID.                                  
           MOVE 3H-WEBSITE-ADDR TO S-WEBSITE-ADDR.                      
           MOVE 3H-DATE-OF-BIRTH TO S-DOB.                              
           MOVE 3H-EMPLOYEE-TITLE TO S-EMPLOYEE-TITLE.                  
           MOVE 3H-BUSINESS-NAME TO S-BUSINESS-NAME.                    
           MOVE 3H-EMPLOYER TO S-EMPLOYER.                              
           MOVE 3H-OTHER-ID TO S-OTHER-ID.                              
           MOVE 3H-OTHER-ID-TYPE TO S-OTHER-ID-TYPE.                    
           MOVE 3H-DRIVERS-LICENSE-NO TO S-DLN.                         
           MOVE 3H-CODE-STATE-ID TO S-CODE-STATE-ID.                    
           MOVE 3H-SSN TO S-SSN.                                        
           MOVE 3H-ITIN-ID TO S-ITIN.                                   
           MOVE 3H-ALLOW-CALL-FL TO S-ALLOW-CALL-FL.                    
           MOVE CV-ADDRESS-FORMAT TO S-ADDRESS-FORMAT.                  
           EVALUATE CV-ADDRESS-FORMAT                                   
               WHEN 'A'                                                 
                   MOVE CV-ADDRESS-ID TO DY-ADDRESS-ID                  
                   PERFORM 7200-FORMATTED-ADDR THRU 7200-EXIT           
                   MOVE WS-ADDRESS-LINE-1 TO S-FMT-STREET-1             
                   MOVE WS-ADDRESS-LINE-2 TO S-FMT-STREET-2             
                   MOVE A4-TOWN TO S-TOWN                               
                   MOVE A4-STATE TO S-STATE                             
                   MOVE DY-ZIP-CODE TO S-ZIP-CODE                       
                   MOVE DY-ZIP-CODE-PLUS-FOUR TO S-ZIP-CODE-4           
                   MOVE DY-ZIP-CODE-TOKEN TO S-ZIP-CODE-TOKEN           
                   MOVE DY-USPS-DELIV-PT-CD TO S-USPS-DELIV-PT          
                   MOVE DY-HOUSE-NO TO S-HOUSE-NO                       
                   MOVE DY-ADDR-PREFIX-1 TO S-ADDR-PREFIX-1             
                   MOVE DY-ADDR-PREFIX-2 TO S-ADDR-PREFIX-2             
                   MOVE DY-STREET-NAME TO S-STREET-NAME                 
                   MOVE DY-STREET-SUFFIX TO S-STREET-SUFFIX             
                   MOVE DY-ADDR-SUFFIX TO S-ADDR-SUFFIX                 
                   MOVE DY-STREET-LOCATION-1 TO S-STREET-LOC-1          
                   MOVE DY-STREET-LOCATION-2 TO S-STREET-LOC-2          
                   IF DY-STREET-NAME(1:7) = 'PO BOX '                   
                       MOVE 'Y' TO S-PO-BOX-FL                          
                   ELSE                                                 
                       MOVE 'N' TO S-PO-BOX-FL                          
                   END-IF                                               
               WHEN 'B'                                                 
                   MOVE CV-ADDRESS-ID TO DZ-ADDRESS-ID                  
                   PERFORM 7300-FREEFORM-ADDR THRU 7300-EXIT            
                   MOVE DZ-ADDR-STREET TO S-FF-STREET-1                 
                   MOVE DZ-ADDRESS-OVERFLOW TO S-FF-STREET-2            
                   MOVE DZ-ADDR-CITY-STATE TO S-FF-CITY-STATE           
                   MOVE DZ-ADDR-ZIP-CODE TO S-FF-ZIP-CODE               
                   MOVE DZ-ADDR-COUNTRY TO S-FF-COUNTRY                 
                   IF DZ-ADDR-STREET(1:7) = 'PO BOX '                   
                       MOVE 'Y' TO S-PO-BOX-FL                          
                   ELSE                                                 
                       MOVE 'N' TO S-PO-BOX-FL                          
                   END-IF                                               
                   IF DZ-ADDR-CITY-STATE > ' ' AND                      
                     (DZ-ADDR-COUNTRY = ' ' OR 'UNITED STATES')         
                         PERFORM 2040-EXTRACT-CITY-STATE THRU 2040-EXIT 
                   END-IF                                               
           END-EVALUATE.                                                
           IF (CV-CONTACT-TYPE = 'SA' OR 'SE' OR 'SG' OR 'PG')          
               EVALUATE S-ENTITY-TYPE                                   
                   WHEN 'A'                                             
                       PERFORM 7800-SALES-SPECIALIST THRU 7800-EXIT     
                       MOVE 3K-SALES-SPLS-USER-ID TO S-SS-USERID        
                   WHEN 'C'                                             
                       PERFORM 7810-SALES-SPECIALIST THRU 7810-EXIT     
                       MOVE 3K-SALES-SPLS-USER-ID TO S-SS-USERID        
               END-EVALUATE
           END-IF.                                            
                                                                        
           MOVE 'H1' TO WS-PHONE-TYPE.                                  
           PERFORM 7400-SELECT-PHONE-NO THRU 7400-EXIT.                 
           MOVE LP-PHONE-NO TO S-HOME-PHONE.                            
           MOVE LP-MOBILE-PHONE-FL TO S-HOME-MOBILE-FL.                 
           MOVE LP-PERMISN-TO-MKT-FL TO S-HOME-MKT-FL.                  
           MOVE LP-PERMISN-TO-MKT-DT TO S-HOME-MKT-DT.                  
                                                                        
           MOVE 'W1' TO WS-PHONE-TYPE.                                  
           PERFORM 7400-SELECT-PHONE-NO THRU 7400-EXIT.                 
           MOVE LP-PHONE-NO TO S-WORK-PHONE.                            
           MOVE LP-EXTENSION-NO TO S-WORK-PHONE-EXT.                    
           MOVE LP-MOBILE-PHONE-FL TO S-WORK-MOBILE-FL.                 
           MOVE LP-PERMISN-TO-MKT-FL TO S-WORK-MKT-FL.                  
           MOVE LP-PERMISN-TO-MKT-DT TO S-WORK-MKT-DT.                  
                                                                        
           MOVE 'A1' TO WS-PHONE-TYPE.                                  
           PERFORM 7400-SELECT-PHONE-NO THRU 7400-EXIT.                 
           MOVE LP-PHONE-NO TO S-ALT-PHONE.                             
           MOVE LP-MOBILE-PHONE-FL TO S-ALT-MOBILE-FL.                  
           MOVE LP-PERMISN-TO-MKT-FL TO S-ALT-MKT-FL.                   
           MOVE LP-PERMISN-TO-MKT-DT TO S-ALT-MKT-DT.                   
                                                                        
           MOVE 'F1' TO WS-PHONE-TYPE.                                  
           PERFORM 7400-SELECT-PHONE-NO THRU 7400-EXIT.                 
           MOVE LP-PHONE-NO TO S-FAX-PHONE.                             
           MOVE LP-MOBILE-PHONE-FL TO S-FAX-MOBILE-FL.                  
           MOVE LP-PERMISN-TO-MKT-FL TO S-FAX-MKT-FL.                   
           MOVE LP-PERMISN-TO-MKT-DT TO S-FAX-MKT-DT.                   
                                                                        
           IF S-POSITION > SPACES                                       
               PERFORM 2010-CONVERT-POSITION THRU 2010-EXIT
           END-IF.            
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
           PERFORM 7500-OPEN-EMAIL-CURSOR THRU 7500-EXIT.               
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
           PERFORM 7501-CLOSE-EMAIL-CURSOR THRU 7501-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2005-DETERMINE-ENTITY.                                           
                                                                        
           MOVE 'N' TO WS-ENTITY-FOUND-FL.                              
           PERFORM 7700-CONTACT-ACCT THRU 7700-EXIT.                    
           IF WS-ENTITY-FOUND-FL = 'N'                                  
               PERFORM 7710-CONTACT-CUST THRU 7710-EXIT
           END-IF.                
           IF WS-ENTITY-FOUND-FL = 'N'                                  
               PERFORM 7720-CONTACT-PREM THRU 7720-EXIT
           END-IF.                
                                                                        
       2005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-CONVERT-POSITION.                                           
                                                                        
           IF S-POSITION(1:15) = 'DRIVERS LICENSE' AND                  
              S-DLN <= SPACES AND                                       
              DQ-NICKNAME > SPACES                                      
                  MOVE DQ-NICKNAME TO S-DLN                             
                  MOVE SPACES TO S-POSITION
           END-IF.                            
                                                                        
           IF S-POSITION(1:11) = 'MILITARY ID' AND                      
              S-OTHER-ID <= SPACES AND                                  
              S-OTHER-ID-TYPE <= SPACES AND                             
              DQ-NICKNAME > SPACES                                      
                  MOVE DQ-NICKNAME TO S-OTHER-ID                        
                  MOVE 'MILITARY' TO S-OTHER-ID-TYPE                    
                  MOVE SPACES TO S-POSITION
           END-IF.                            
                                                                        
           IF S-POSITION(1:8) = 'OTHER ID' AND                          
              S-OTHER-ID <= SPACES AND                                  
              S-OTHER-ID-TYPE <= SPACES AND                             
              DQ-NICKNAME > SPACES                                      
                  MOVE DQ-NICKNAME TO S-OTHER-ID                        
                  MOVE 'OTHER' TO S-OTHER-ID-TYPE                       
                  MOVE SPACES TO S-POSITION
           END-IF.                            
                                                                        
           IF S-POSITION(1:15) = 'SOCIAL SECURITY' AND                  
              S-SSN <= SPACES AND                                       
              DQ-NICKNAME > SPACES                                      
                  PERFORM 4000-FORMAT-SSN THRU 4000-EXIT
           END-IF.               
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2040-EXTRACT-CITY-STATE.                                         
                                                                        
           MOVE +30 TO WS-SUB1.                                         
           MOVE 0 TO WS-SUB2.                                           
           PERFORM UNTIL DZ-ADDR-CITY-STATE(WS-SUB1:1) > ' '            
               SUBTRACT +1 FROM WS-SUB1                                 
           END-PERFORM.                                                 
           IF DZ-ADDR-CITY-STATE(WS-SUB1 - 2:1) = ' '                   
               MOVE DZ-ADDR-CITY-STATE(WS-SUB1 - 1:2) TO S-FF-STATE     
               MOVE DZ-ADDR-CITY-STATE(1:WS-SUB1 - 3) TO S-FF-CITY
           END-IF.     
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH EMAIL-CURSOR                                       
                INTO :3G-EMAIL-TYPE-CD,                                 
                     :3G-EMAIL-ADDRESS-TX,                              
                     :3G-PERMISN-TO-MKT-FL,                             
D05317               :3G-PERMISN-TO-MKT-TS :WS-NULL-4                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-4 < 0                                     
D05317                 MOVE SPACES TO 3G-PERMISN-TO-MKT-TS              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                 
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE 3G-EMAIL-TYPE-CD TO S-EMAIL-TYPE-CD.                    
           MOVE 3G-EMAIL-ADDRESS-TX TO S-EMAIL-ADDRESS.                 
           MOVE 3G-PERMISN-TO-MKT-FL TO S-EMAIL-MKT-FL.                 
D05317     MOVE 3G-PERMISN-TO-MKT-TS(1:10) TO S-EMAIL-MKT-DT.           
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4000-FORMAT-SSN.                                                 
                                                                        
           MOVE 0 TO WS-SPACES WS-LENGTH.                               
           INSPECT FUNCTION REVERSE (DQ-NICKNAME) TALLYING              
               WS-SPACES FOR LEADING SPACES.                            
           COMPUTE WS-LENGTH = 50 - WS-SPACES.                          
           MOVE SPACES TO WS-SSN-FORMAT WS-UNFORMATTED-SSN.             
           IF WS-LENGTH = 9 AND DQ-NICKNAME(1:9) NUMERIC                
               MOVE 'U' TO WS-SSN-FORMAT                                
           ELSE                                                         
               IF WS-LENGTH = 11 AND                                    
                  DQ-NICKNAME(4:1) = '-' AND                            
                  DQ-NICKNAME(7:1) = '-'                                
                      MOVE 'F' TO WS-SSN-FORMAT
               END-IF
           END-IF.                        
            EVALUATE WS-SSN-FORMAT                                      
                WHEN 'F'                                                
                    MOVE DQ-NICKNAME(1:3) TO                            
                         WS-UNFORMATTED-SSN(1:3)                        
                    MOVE DQ-NICKNAME(5:2) TO                            
                         WS-UNFORMATTED-SSN(4:2)                        
                    MOVE DQ-NICKNAME(8:4) TO                            
                         WS-UNFORMATTED-SSN(6:4)                        
                    MOVE WS-UNFORMATTED-SSN TO S-SSN                    
                WHEN 'U'                                                
                    MOVE DQ-NICKNAME(1:9) TO S-SSN                      
                WHEN OTHER                                              
                    MOVE SPACES TO S-SSN                                
                                   S-POSITION                           
                    MOVE DQ-NICKNAME TO S-OTHER-ID                      
                    MOVE 'OTHER' TO S-OTHER-ID-TYPE                     
            END-EVALUATE.                                               
            IF S-SSN > SPACES                                           
                MOVE SPACES TO S-POSITION
            END-IF.                              
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY'  TO TABLE-1                   
                   MOVE 'DELINQ_CD'    TO TABLE-ELEMENT-1               
                   MOVE C8-DELINQ-CD   TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-CONTACT-INFO.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CV.NAME_ID,
              CONTACT_TYPE,
              ADDRESS_ID,
              CONTACT_POSITION,
              ACCESS_LEVEL_CD,
              MEMO_BILL_IND,
              CONTACT_EXP_DT,
              CONTACT_EFF_DT,
              EFFECTIVE_CD,
              ADDRESS_FORMAT,
              NAME_FORMAT,
              FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              FULL_NAME,
              REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS, 121), 
           ' ', '-'), ':', '.') VALIDATION_TS,
              DATE_CREATED,
              NICKNAME                                           
               INTO :CV-NAME-ID,                                        
                    :CV-CONTACT-TYPE,                                   
                    :CV-ADDRESS-ID,                                     
                    :CV-CONTACT-POSITION,                               
                    :CV-ACCESS-LEVEL-CD,                                
                    :CV-MEMO-BILL-IND,                                  
                    :CV-CONTACT-EXP-DT :WS-NULL-1,                       
                    :CV-CONTACT-EFF-DT :WS-NULL-2,                       
                    :CV-EFFECTIVE-CD,                                   
                    :CV-ADDRESS-FORMAT,                                 
                    :DQ-NAME-FORMAT,                                    
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-FULL-NAME,                                      
                    :CV-VALIDATION-TS :WS-NULL-6,                        
                    :CV-DATE-CREATED :WS-NULL-7,                         
                    :DQ-NICKNAME                                        
               FROM  CSS_CONTACT CV WITH(READUNCOMMITTED),                      
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
              WHERE CONTACT_ID = :CV-CONTACT-ID                         
                AND CV.NAME_ID = DQ.NAME_ID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT CV.NAME_ID,                                                
MFA-TR*              CONTACT_TYPE,                                              
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              CONTACT_POSITION,                                          
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              MEMO_BILL_IND,                                             
MFA-TR*              CONTACT_EXP_DT,                                            
MFA-TR*              CONTACT_EFF_DT,                                            
MFA-TR*              EFFECTIVE_CD,                                              
MFA-TR*              ADDRESS_FORMAT,                                            
MFA-TR*              NAME_FORMAT,                                       14210000
MFA-TR*              FIRST_NAME,                                        14240000
MFA-TR*              MIDDLE_NAME,                                       14250000
MFA-TR*              LAST_NAME,                                         14260000
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              VALIDATION_TS,                                             
MFA-TR*              DATE_CREATED,                                              
MFA-TR*              NICKNAME                                                   
MFA-TR*        INTO :CV-NAME-ID,                                        13440800
MFA-TR*             :CV-CONTACT-TYPE,                                   13440900
MFA-TR*             :CV-ADDRESS-ID,                                     13441000
MFA-TR*             :CV-CONTACT-POSITION,                               13441200
MFA-TR*             :CV-ACCESS-LEVEL-CD,                                13441300
MFA-TR*             :CV-MEMO-BILL-IND,                                  13441300
MFA-TR*             :CV-CONTACT-EXP-DT:WS-NULL-1,                       13441300
MFA-TR*             :CV-CONTACT-EFF-DT:WS-NULL-2,                       13441300
MFA-TR*             :CV-EFFECTIVE-CD,                                   13441300
MFA-TR*             :CV-ADDRESS-FORMAT,                                 13441300
MFA-TR*             :DQ-NAME-FORMAT,                                    14380000
MFA-TR*             :DQ-FIRST-NAME,                                     14410000
MFA-TR*             :DQ-MIDDLE-NAME,                                    14410000
MFA-TR*             :DQ-LAST-NAME,                                      14410000
MFA-TR*             :DQ-TITLE-PREFIX,                                   14420000
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                 14430000
MFA-TR*             :DQ-FULL-NAME,                                      14480000
MFA-TR*             :CV-VALIDATION-TS:WS-NULL-6,                        14480000
MFA-TR*             :CV-DATE-CREATED:WS-NULL-7,                         14480000
MFA-TR*             :DQ-NICKNAME                                        14480000
MFA-TR*        FROM  CSS_CONTACT CV,                                    14550000
MFA-TR*              CSS_NAME DQ                                        14550000
MFA-TR*       WHERE CONTACT_ID = :CV-CONTACT-ID                                 
MFA-TR*         AND CV.NAME_ID = DQ.NAME_ID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO CV-CONTACT-EXP-DT                 
                   END-IF                                               
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CV-CONTACT-EFF-DT                 
                   END-IF                                               
                   IF WS-NULL-6 < 0                                     
                       MOVE SPACES TO CV-VALIDATION-TS                  
                   END-IF                                               
                   IF WS-NULL-7 < 0                                     
                       MOVE SPACES TO CV-DATE-CREATED                   
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7100'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT'  TO TABLE-1                       
                   MOVE 'CSS_NAME'     TO TABLE-2                       
                   MOVE 'CONTACT_ID'   TO TABLE-ELEMENT-1               
                   MOVE CV-CONTACT-ID  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-FORMATTED-ADDR.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX)))))))),
              RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2)))),
              TOWN,
              STATE,
              DY.ZIP_CODE,
              DY.ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              USPS_DELIV_PT_CD,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2                                  
               INTO :WS-ADDRESS-LINE-1,                                 
                    :WS-ADDRESS-LINE-2,                                 
                    :A4-TOWN,                                           
                    :A4-STATE,                                          
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-USPS-DELIV-PT-CD,                               
                    :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-SUFFIX,                                  
                    :DY-ADDR-SUFFIX,                                    
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2                               
               FROM  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
              WHERE ADDRESS_ID = :DY-ADDRESS-ID                         
                AND DY.ZIP_CODE = A4.ZIP_CODE                           
                AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX)))))))),                           
MFA-TR*              RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||             
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)))),                         
MFA-TR*              TOWN,                                                      
MFA-TR*              STATE,                                                     
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              DY.ZIP_CODE_PLUS_FOUR,                                     
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              USPS_DELIV_PT_CD,                                          
MFA-TR*              HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2                                          
MFA-TR*        INTO :WS-ADDRESS-LINE-1,                                 13440800
MFA-TR*             :WS-ADDRESS-LINE-2,                                 13440900
MFA-TR*             :A4-TOWN,                                                   
MFA-TR*             :A4-STATE,                                                  
MFA-TR*             :DY-ZIP-CODE,                                               
MFA-TR*             :DY-ZIP-CODE-PLUS-FOUR,                                     
MFA-TR*             :DY-ZIP-CODE-TOKEN,                                         
MFA-TR*             :DY-USPS-DELIV-PT-CD,                                       
MFA-TR*             :DY-HOUSE-NO,                                               
MFA-TR*             :DY-ADDR-PREFIX-1,                                          
MFA-TR*             :DY-ADDR-PREFIX-2,                                          
MFA-TR*             :DY-STREET-NAME,                                            
MFA-TR*             :DY-STREET-SUFFIX,                                          
MFA-TR*             :DY-ADDR-SUFFIX,                                            
MFA-TR*             :DY-STREET-LOCATION-1,                                      
MFA-TR*             :DY-STREET-LOCATION-2                                       
MFA-TR*        FROM  CSS_ADDR_FORMATTED DY,                             14550000
MFA-TR*              CSS_ZIP_CODE A4                                    14550000
MFA-TR*       WHERE ADDRESS_ID = :DY-ADDRESS-ID                         14560000
MFA-TR*         AND DY.ZIP_CODE = A4.ZIP_CODE                                   
MFA-TR*         AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-2                 
                   MOVE 'ADDRESS-ID'         TO TABLE-ELEMENT-1         
                   MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-FREEFORM-ADDR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ADDR_STREET,
              ADDRESS_OVERFLOW,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY                                       
               INTO :DZ-ADDR-STREET,                                    
                    :DZ-ADDRESS-OVERFLOW,                               
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY                                    
               FROM  CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
              WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY                                               
MFA-TR*        INTO :DZ-ADDR-STREET,                                    13440800
MFA-TR*             :DZ-ADDRESS-OVERFLOW,                               13440900
MFA-TR*             :DZ-ADDR-CITY-STATE,                                        
MFA-TR*             :DZ-ADDR-ZIP-CODE,                                          
MFA-TR*             :DZ-ADDR-COUNTRY                                            
MFA-TR*        FROM  CSS_ADDR_FREEFORM                                  14550000
MFA-TR*       WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         14560000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7300'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                 
                   MOVE 'ADDRESS-ID'         TO TABLE-ELEMENT-1         
                   MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-PHONE-NO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PHONE_NO,
              EXTENSION_NO,
              MOBILE_PHONE_FL,
              PERMISN_TO_MKT_FL,
              PERMISN_TO_MKT_DT                                  
               INTO :LP-PHONE-NO,                                       
                    :LP-EXTENSION-NO,                                   
                    :LP-MOBILE-PHONE-FL,                                
                    :LP-PERMISN-TO-MKT-FL,                              
                    :LP-PERMISN-TO-MKT-DT :WS-NULL-3                     
               FROM CSS_CONTACT_PHONE WITH(READUNCOMMITTED)                     
              WHERE CONTACT_ID = :CV-CONTACT-ID                         
                AND PHONE_TYPE = :WS-PHONE-TYPE                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT PHONE_NO,                                          15225200
MFA-TR*              EXTENSION_NO,                                      15225300
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT                                          
MFA-TR*        INTO :LP-PHONE-NO,                                       15225400
MFA-TR*             :LP-EXTENSION-NO,                                   15225500
MFA-TR*             :LP-MOBILE-PHONE-FL,                                        
MFA-TR*             :LP-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :LP-PERMISN-TO-MKT-DT:WS-NULL-3                             
MFA-TR*        FROM CSS_CONTACT_PHONE                                   15225600
MFA-TR*       WHERE CONTACT_ID = :CV-CONTACT-ID                         15225700
MFA-TR*         AND PHONE_TYPE = :WS-PHONE-TYPE                         15225800
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO LP-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CONTACT-PHONE                      
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7400'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PHONE' TO TABLE-1                  
                   MOVE 'CONTACT_ID'  TO TABLE-ELEMENT-1                
                   MOVE CV-CONTACT-ID TO HOSTVAR-ELEMENT-1              
                   MOVE 'PHONE_TYPE'  TO TABLE-ELEMENT-1                
                   MOVE WS-PHONE-TYPE TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-EMAIL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN EMAIL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-EMAIL-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE EMAIL-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-SELECT-CONTACT-STATS.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) TAX_ID,
              WEBSITE_ADDR,
              DATE_OF_BIRTH,
              EMPLOYEE_TITLE,
              BUSINESS_NAME,
              EMPLOYER,
              OTHER_ID,
              OTHER_ID_TYPE,
              DRIVERS_LICENSE_NO,
              CODE_STATE_ID,
              SSN,
              ITIN_ID,
              ALLOW_CALL_FL                                      
               INTO :3H-TAX-ID,                                         
                    :3H-WEBSITE-ADDR,                                   
                    :3H-DATE-OF-BIRTH :WS-NULL-5,                        
                    :3H-EMPLOYEE-TITLE,                                 
                    :3H-BUSINESS-NAME,                                  
                    :3H-EMPLOYER,                                       
                    :3H-OTHER-ID,                                       
                    :3H-OTHER-ID-TYPE,                                  
                    :3H-DRIVERS-LICENSE-NO,                             
                    :3H-CODE-STATE-ID,                                  
                    :3H-SSN,                                            
                    :3H-ITIN-ID,                                        
                    :3H-ALLOW-CALL-FL                                   
               FROM  CSS_CONTACT_STATS WITH(READUNCOMMITTED)                    
              WHERE CONTACT_ID = :CV-CONTACT-ID                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT TAX_ID,                                                    
MFA-TR*              WEBSITE_ADDR,                                              
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              EMPLOYEE_TITLE,                                            
MFA-TR*              BUSINESS_NAME,                                             
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ALLOW_CALL_FL                                              
MFA-TR*        INTO :3H-TAX-ID,                                         13440800
MFA-TR*             :3H-WEBSITE-ADDR,                                   13440900
MFA-TR*             :3H-DATE-OF-BIRTH:WS-NULL-5,                        13441000
MFA-TR*             :3H-EMPLOYEE-TITLE,                                 13441200
MFA-TR*             :3H-BUSINESS-NAME,                                  13441300
MFA-TR*             :3H-EMPLOYER,                                       13441300
MFA-TR*             :3H-OTHER-ID,                                       13441300
MFA-TR*             :3H-OTHER-ID-TYPE,                                  13441300
MFA-TR*             :3H-DRIVERS-LICENSE-NO,                             13441300
MFA-TR*             :3H-CODE-STATE-ID,                                  14380000
MFA-TR*             :3H-SSN,                                            14410000
MFA-TR*             :3H-ITIN-ID,                                        14410000
MFA-TR*             :3H-ALLOW-CALL-FL                                   14410000
MFA-TR*        FROM  CSS_CONTACT_STATS                                  14550000
MFA-TR*       WHERE CONTACT_ID = :CV-CONTACT-ID                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-5 < 0                                     
                       MOVE SPACES TO 3H-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CONTACT-STATS                      
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7600'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_STATS'  TO TABLE-1                 
                   MOVE 'CONTACT_ID'   TO TABLE-ELEMENT-1               
                   MOVE CV-CONTACT-ID  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-CONTACT-ACCT.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DW.ACCOUNT_NO,
              COMPANY_NO                                         
               INTO :DW-ACCOUNT-NO,                                     
                    :AT-COMPANY-NO                                      
               FROM  CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                 
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
              WHERE CONTACT_ID = :CV-CONTACT-ID                         
                AND DW.ACCOUNT_NO = AT.ACCOUNT_NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT DW.ACCOUNT_NO,                                             
MFA-TR*              COMPANY_NO                                                 
MFA-TR*        INTO :DW-ACCOUNT-NO,                                     13440800
MFA-TR*             :AT-COMPANY-NO                                      13440800
MFA-TR*        FROM  CSS_CONTACT_ACCT DW,                               14550000
MFA-TR*              CSS_ACCOUNT AT                                     14550000
MFA-TR*       WHERE CONTACT_ID = :CV-CONTACT-ID                                 
MFA-TR*         AND DW.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ENTITY-FOUND-FL                       
                   MOVE 'A' TO S-ENTITY-TYPE                            
                   MOVE AT-COMPANY-NO TO WS-COMPANY-NO                  
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ENTITY-FOUND-FL                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7700'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
                   MOVE 'CSS_ACCOUNT'       TO TABLE-2                  
                   MOVE 'CONTACT_ID'   TO TABLE-ELEMENT-1               
                   MOVE CV-CONTACT-ID  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7710-CONTACT-CUST.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DT.CUSTOMER_NO,
              COMPANY_NO_ORIG                                    
               INTO :DT-CUSTOMER-NO,                                    
                    :CU-COMPANY-NO-ORIG                                 
               FROM  CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                 
                     CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
              WHERE CONTACT_ID = :CV-CONTACT-ID                         
                AND DT.CUSTOMER_NO = CU.CUSTOMER_NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT DT.CUSTOMER_NO,                                            
MFA-TR*              COMPANY_NO_ORIG                                            
MFA-TR*        INTO :DT-CUSTOMER-NO,                                    13440800
MFA-TR*             :CU-COMPANY-NO-ORIG                                 13440800
MFA-TR*        FROM  CSS_CONTACT_CUST DT,                               14550000
MFA-TR*              CSS_CUSTOMER CU                                            
MFA-TR*       WHERE CONTACT_ID = :CV-CONTACT-ID                                 
MFA-TR*         AND DT.CUSTOMER_NO = CU.CUSTOMER_NO                             
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7710                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ENTITY-FOUND-FL                       
                   MOVE 'C' TO S-ENTITY-TYPE                            
                   MOVE CU-COMPANY-NO-ORIG TO WS-COMPANY-NO             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ENTITY-FOUND-FL                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7710'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CUSTOMER'      TO TABLE-2                  
                   MOVE 'CONTACT_ID'   TO TABLE-ELEMENT-1               
                   MOVE CV-CONTACT-ID  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7720-CONTACT-PREM.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DX.PREMISE_NO,
              COMPANY_NO                                         
               INTO :DX-PREMISE-NO,                                     
                    :PR-COMPANY-NO                                      
               FROM  CSS_CONTACT_PREM DX WITH(READUNCOMMITTED),                 
                     CSS_PREMISE PR WITH(READUNCOMMITTED)                       
              WHERE CONTACT_ID = :CV-CONTACT-ID                         
                AND DX.PREMISE_NO = PR.PREMISE_NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT DX.PREMISE_NO,                                             
MFA-TR*              COMPANY_NO                                                 
MFA-TR*        INTO :DX-PREMISE-NO,                                     13440800
MFA-TR*             :PR-COMPANY-NO                                              
MFA-TR*        FROM  CSS_CONTACT_PREM DX,                               14550000
MFA-TR*              CSS_PREMISE PR                                     14550000
MFA-TR*       WHERE CONTACT_ID = :CV-CONTACT-ID                                 
MFA-TR*         AND DX.PREMISE_NO = PR.PREMISE_NO                               
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7720                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ENTITY-FOUND-FL                       
                   MOVE 'P' TO S-ENTITY-TYPE                            
                   MOVE PR-COMPANY-NO TO WS-COMPANY-NO                  
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ENTITY-FOUND-FL                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7720'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PREM'  TO TABLE-1                  
                   MOVE 'CSS_PREMISE'  TO TABLE-2                       
                   MOVE 'CONTACT_ID'   TO TABLE-ELEMENT-1               
                   MOVE CV-CONTACT-ID  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-SALES-SPECIALIST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SALES_SPLS_USER_ID                                 
               INTO :3K-SALES-SPLS-USER-ID                              
               FROM  CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                 
                     CSS_CONTACT CV WITH(READUNCOMMITTED),                      
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_SALES_SPCLST SS WITH(READUNCOMMITTED)                  
              WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                         
                AND DW.CONTACT_ID = CV.CONTACT_ID                       
                AND CV.CONTACT_TYPE = 'SS'                              
                AND CV.NAME_ID = DQ.NAME_ID                             
                AND DQ.FIRST_NAME = SS.FIRST_NAME                       
                AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                     
                AND DQ.LAST_NAME = SS.LAST_NAME                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT SALES_SPLS_USER_ID                                         
MFA-TR*        INTO :3K-SALES-SPLS-USER-ID                              13440800
MFA-TR*        FROM  CSS_CONTACT_ACCT DW,                               14550000
MFA-TR*              CSS_CONTACT CV,                                            
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_SALES_SPCLST SS                                        
MFA-TR*       WHERE ACCOUNT_NO = :DW-ACCOUNT-NO                                 
MFA-TR*         AND DW.CONTACT_ID = CV.CONTACT_ID                               
MFA-TR*         AND CV.CONTACT_TYPE = 'SS'                                      
MFA-TR*         AND CV.NAME_ID = DQ.NAME_ID                                     
MFA-TR*         AND DQ.FIRST_NAME = SS.FIRST_NAME                               
MFA-TR*         AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                             
MFA-TR*         AND DQ.LAST_NAME = SS.LAST_NAME                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO 3K-SALES-SPLS-USER-ID                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7800'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'  TO TABLE-2                       
                   MOVE 'CSS_NAME'     TO TABLE-3                       
                   MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1               
                   MOVE DW-ACCOUNT-NO  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7810-SALES-SPECIALIST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SALES_SPLS_USER_ID                                 
               INTO :3K-SALES-SPLS-USER-ID                              
               FROM  CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                 
                     CSS_CONTACT CV WITH(READUNCOMMITTED),                      
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_SALES_SPCLST SS WITH(READUNCOMMITTED)                  
              WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                       
                AND DT.CONTACT_ID = CV.CONTACT_ID                       
                AND CV.CONTACT_TYPE = 'SS'                              
                AND CV.NAME_ID = DQ.NAME_ID                             
                AND DQ.FIRST_NAME = SS.FIRST_NAME                       
                AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                     
                AND DQ.LAST_NAME = SS.LAST_NAME                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT SALES_SPLS_USER_ID                                         
MFA-TR*        INTO :3K-SALES-SPLS-USER-ID                              13440800
MFA-TR*        FROM  CSS_CONTACT_CUST DT,                               14550000
MFA-TR*              CSS_CONTACT CV,                                            
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_SALES_SPCLST SS                                        
MFA-TR*       WHERE CUSTOMER_NO = :DT-CUSTOMER-NO                               
MFA-TR*         AND DT.CONTACT_ID = CV.CONTACT_ID                               
MFA-TR*         AND CV.CONTACT_TYPE = 'SS'                                      
MFA-TR*         AND CV.NAME_ID = DQ.NAME_ID                                     
MFA-TR*         AND DQ.FIRST_NAME = SS.FIRST_NAME                               
MFA-TR*         AND DQ.MIDDLE_NAME = SS.MIDDLE_NAME                             
MFA-TR*         AND DQ.LAST_NAME = SS.LAST_NAME                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7810                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO 3K-SALES-SPLS-USER-ID                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7810'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'  TO TABLE-2                       
                   MOVE 'CSS_NAME'     TO TABLE-3                       
                   MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1               
                   MOVE DT-CUSTOMER-NO TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04698_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04698_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04698_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04698_R2                            
             (                                                          
              RETURN_CODE,                                              
              EMAIL_ADDRESS,                                            
              EMAIL_TYPE_CD,                                            
              EMAIL_MKT_FL,                                             
              EMAIL_MKT_DT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-EMAIL-ADDRESS,                                        
               :S-EMAIL-TYPE-CD,                                        
               :S-EMAIL-MKT-FL,                                         
               :S-EMAIL-MKT-DT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04698_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       EMAIL_ADDRESS,                                                    
MFA-TR*       EMAIL_TYPE_CD,                                                    
MFA-TR*       EMAIL_MKT_FL,                                                     
MFA-TR*       EMAIL_MKT_DT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-EMAIL-ADDRESS,                                                
MFA-TR*        :S-EMAIL-TYPE-CD,                                                
MFA-TR*        :S-EMAIL-MKT-FL,                                                 
MFA-TR*        :S-EMAIL-MKT-DT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04698_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
