       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04695.                                          
COB303 DATE-WRITTEN. MAY 12, 2014.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS ACCOUNT INFORMATION.                    *        
      *  RESULTS SETS:                                                 *        
      *     1.  ACCOUNT INFO                                           *        
      *     2.  ATTRIBUTES                                             *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/12/14    FMB      NEW PROGRAM.                                      
A05317*  02/24/17    FMB      CHECK ORDER STATUS FOR CSS_SO_ACCT_XFER  *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04695'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04695 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATTRIB                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWCACCT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMIAXRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRITOG                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOXAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHSTNME                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00056.                                                       
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04695_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04695_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-ACCOUNT-TYPE-CODE PIC X(01) VALUE SPACES.           
               10 S-ACCOUNT-INIT-DT   PIC X(10) VALUE SPACES.           
               10 S-ACCT-CREATE-DT    PIC X(10) VALUE SPACES.           
               10 S-ACCT-FINALED-DT   PIC X(10) VALUE SPACES.           
               10 S-CODE-ACCT-STAT    PIC X(01) VALUE SPACES.           
               10 S-UTIL-NON-UTIL     PIC X(01) VALUE SPACES.           
               10 S-DBA-NAME          PIC X(70) VALUE SPACES.           
               10 S-BILL-CYCLE        PIC X(02) VALUE SPACES.           
               10 S-BILL-CYCLE-CHG-CD PIC X(01) VALUE SPACES.           
               10 S-PREV-BILL-CYCLE   PIC X(02) VALUE SPACES.           
               10 S-CODE-STATUS-REASON PIC X(01) VALUE SPACES.          
               10 S-NO-BILL-COPIES    PIC S9(4) COMP VALUE 0.           
               10 S-PRINT-TYPE-CD     PIC X(01) VALUE SPACES.           
               10 S-CODE-BILL-FREQ    PIC X(03) VALUE SPACES.           
               10 S-MST-SUB-ACCT-IND  PIC X(01) VALUE SPACES.           
               10 S-CODE-MAJOR-ACCT   PIC X(01) VALUE SPACES.           
               10 S-CODE-CRIT-OUTAGE  PIC X(02) VALUE SPACES.           
               10 S-SECURE-FL         PIC X(01) VALUE SPACES.           
               10 S-EXTERNAL-ID       PIC X(19) VALUE SPACES.           
               10 S-ARC-FL            PIC X(01) VALUE SPACES.           
               10 S-CODE-WC-EQUIP     PIC X(02) VALUE SPACES.           
               10 S-WC-EQUIP-INST-DT  PIC X(10) VALUE SPACES.           
               10 S-WC-COMMENTS       PIC X(200) VALUE SPACES.          
               10 S-WC-BACKUP-HOURS   PIC S9(3)V COMP-3 VALUE 0.        
               10 S-GIS-POINT-ID      PIC X(10) VALUE SPACES.           
               10 S-WEBSITE-ADDR      PIC X(75) VALUE SPACES.           
               10 S-GROUP-ID          PIC X(25) VALUE SPACES.           
               10 S-AGL-TRACKING-ID   PIC X(30) VALUE SPACES.           
               10 S-DIST-ACCT-NO      PIC X(20) VALUE SPACES.           
               10 S-ORIGINATION-CD    PIC X(01) VALUE SPACES.           
               10 S-AFF-COMPANY-NO    PIC X(02) VALUE SPACES.           
               10 S-ORIG-DIST-ACCT-NO PIC X(20) VALUE SPACES.           
               10 S-DIST-COMPANY-NO   PIC X(02) VALUE SPACES.           
               10 S-MKT-POOL-GRP      PIC X(03) VALUE SPACES.           
               10 S-RATE-SCHEDULE     PIC X(03) VALUE SPACES.           
               10 S-AGL-PREMISE-NO    PIC S9(9)V COMP-3 VALUE 0.        
               10 S-DELETE-FL         PIC X(01) VALUE SPACES.           
               10 S-CODE-ACCT-USAGE   PIC X(01) VALUE SPACES.           
               10 S-READ-CYCLE        PIC X(02) VALUE SPACES.           
               10 S-REG-DEREG-CD      PIC X(01) VALUE SPACES.           
               10 S-FORECAST-DNP-FL   PIC X(01) VALUE SPACES.           
               10 S-DPP-CD            PIC X(01) VALUE SPACES.           
               10 S-SEASONAL-FL       PIC X(01) VALUE SPACES.           
               10 S-SENIOR-RATE-FL    PIC X(01) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-ATTRIBUTE-DESC    PIC X(18) VALUE SPACES.           
               10 S-ATTRIBUTE-DT      PIC X(10) VALUE SPACES.           
               10 S-ATTRIBUTE-STATUS  PIC X(01) VALUE SPACES.           
               10 S-ATTRIBUTE-VALUE   PIC X(05) VALUE SPACES.           
               10 S-ATTRIBUTE-TYPE    PIC X(08) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04695'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  WS-ORIGINATION-CD        PIC X(01) VALUE SPACES.         
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ARC-VALID-FL          PIC X(01) VALUE 'N'.            
           05  WS-ARCHIVED-ACCOUNT      PIC X(01) VALUE 'N'.            
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-ACCOUNT-NO.                                           
               10  WS-ACCOUNT-NO-BYTE  OCCURS 13 PIC 9(01).             
           05  WS-SUB1                  PIC S9(4) COMP VALUE +0.        
           05  WS-SUB2                  PIC S9(4) COMP VALUE +0.        
           05  WS-SUB3                  PIC S9(4) COMP VALUE +0.        
           05  WS-SUB4                  PIC S9(4) COMP VALUE +0.        
           05  WS-MOD-OUT               PIC S9(9) COMP VALUE +0.        
           05  WS-MOD-BYTE              PIC 9(01) VALUE 0.              
           05  WS-EXTERNAL-ID           PIC X(16) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE ATTRIB-CURSOR CURSOR FOR                          
              SELECT YP.ATTRIBUTE_DESC,                                 
                     ATTRIBUTE_VALUE_CD,                                
                     ATTRIBUTE_VALUE_DT,                                
                     STATUS_CD,                                         
                     ATTRIBUTE_TYPE_TX                                  
               FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED),                
                    CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC               
                AND COMPANY_NO = :AT-COMPANY-NO                         
                                                                 
              FOR READ ONLY                                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ATTRIB-CURSOR CURSOR FOR                                  
MFA-TR*       SELECT YP.ATTRIBUTE_DESC,                                         
MFA-TR*              ATTRIBUTE_VALUE_CD,                                        
MFA-TR*              ATTRIBUTE_VALUE_DT,                                        
MFA-TR*              STATUS_CD,                                                 
MFA-TR*              ATTRIBUTE_TYPE_TX                                          
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE YP,                                      
MFA-TR*             CSS_ATTRIBUTE WZ                                            
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*         AND YP.ATTRIBUTE_DESC = WZ.ATTRIBUTE_DESC                       
MFA-TR*         AND COMPANY_NO = :AT-COMPANY-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CD,                
                      :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,        
                      :S-ACCOUNT-INIT-DT   AS ACCOUNT_INIT_DT,          
                      :S-ACCT-CREATE-DT    AS ACCT_CREATE_DT,           
                      :S-ACCT-FINALED-DT   AS ACCT_FINALED_DT,          
                      :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,           
                      :S-UTIL-NON-UTIL     AS UTIL_NON_UTIL,            
                      :S-DBA-NAME          AS DBA_NAME,                 
                      :S-BILL-CYCLE        AS BILL_CYCLE,               
                      :S-BILL-CYCLE-CHG-CD AS BILL_CYCLE_CHG_CD,        
                      :S-PREV-BILL-CYCLE   AS PREV_BILL_CYCLE,          
                      :S-CODE-STATUS-REASON AS CODE_STATUS_REASON,      
                      :S-NO-BILL-COPIES    AS NO_BILL_COPIES,           
                      :S-PRINT-TYPE-CD     AS PRINT_TYPE_CD,            
                      :S-CODE-BILL-FREQ    AS CODE_BILL_FREQ,           
                      :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,         
                      :S-CODE-MAJOR-ACCT   AS CODE_MAJOR_ACCT,          
                      :S-CODE-CRIT-OUTAGE  AS CODE_CRIT_OUTAGE,         
                      :S-SECURE-FL         AS SECURE_FL,                
                      :S-EXTERNAL-ID       AS EXTERNAL_ID,              
                      :S-ARC-FL            AS ARC_FL,                   
                      :S-CODE-WC-EQUIP     AS CODE_WC_EQUIP,            
                      :S-WC-EQUIP-INST-DT  AS WC_EQUIP_INST_DT,         
                      :S-WC-COMMENTS       AS WC_COMMENTS,              
                      :S-WC-BACKUP-HOURS   AS WC_BACKUP_HOURS,          
                      :S-GIS-POINT-ID      AS GIS_POINT_ID,             
                      :S-WEBSITE-ADDR      AS WEBSITE_ADDR,             
                      :S-GROUP-ID          AS GROUP_ID,                 
                      :S-AGL-TRACKING-ID   AS AGL_TRACKING_ID,          
                      :S-DIST-ACCT-NO      AS DIST_ACCOUNT_NO,          
                      :S-ORIGINATION-CD    AS ORIGINATION_CD,           
                      :S-AFF-COMPANY-NO    AS AFF_COMPANY_NO,           
                      :S-ORIG-DIST-ACCT-NO AS ORIG_DIST_ACCT_NO,        
                      :S-DIST-COMPANY-NO   AS DIST_COMPANY_NO,          
                      :S-MKT-POOL-GRP      AS MKT_POOL_GRP,             
                      :S-RATE-SCHEDULE     AS RATE_SCHEDULE,            
                      :S-AGL-PREMISE-NO    AS AGL_PREMISE_NO,           
                      :S-DELETE-FL         AS DELETE_FL,                
                      :S-CODE-ACCT-USAGE   AS CODE_ACCT_USAGE,          
                      :S-READ-CYCLE        AS READ_CYCLE,               
                      :S-REG-DEREG-CD      AS REG_DEREG_CD,             
                      :S-FORECAST-DNP-FL   AS FORECAST_DNP_FL,          
                      :S-DPP-CD            AS DPP_CD,                   
                      :S-SEASONAL-FL       AS SEASONAL_FL,              
                      :S-SENIOR-RATE-FL    AS SENIOR_RATE_FL            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CD,                        
MFA-TR*               :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE,                
MFA-TR*               :S-ACCOUNT-INIT-DT   AS ACCOUNT_INIT_DT,                  
MFA-TR*               :S-ACCT-CREATE-DT    AS ACCT_CREATE_DT,                   
MFA-TR*               :S-ACCT-FINALED-DT   AS ACCT_FINALED_DT,                  
MFA-TR*               :S-CODE-ACCT-STAT    AS CODE_ACCT_STAT,                   
MFA-TR*               :S-UTIL-NON-UTIL     AS UTIL_NON_UTIL,                    
MFA-TR*               :S-DBA-NAME          AS DBA_NAME,                         
MFA-TR*               :S-BILL-CYCLE        AS BILL_CYCLE,                       
MFA-TR*               :S-BILL-CYCLE-CHG-CD AS BILL_CYCLE_CHG_CD,                
MFA-TR*               :S-PREV-BILL-CYCLE   AS PREV_BILL_CYCLE,                  
MFA-TR*               :S-CODE-STATUS-REASON AS CODE_STATUS_REASON,              
MFA-TR*               :S-NO-BILL-COPIES    AS NO_BILL_COPIES,                   
MFA-TR*               :S-PRINT-TYPE-CD     AS PRINT_TYPE_CD,                    
MFA-TR*               :S-CODE-BILL-FREQ    AS CODE_BILL_FREQ,                   
MFA-TR*               :S-MST-SUB-ACCT-IND  AS MST_SUB_ACCT_IND,                 
MFA-TR*               :S-CODE-MAJOR-ACCT   AS CODE_MAJOR_ACCT,                  
MFA-TR*               :S-CODE-CRIT-OUTAGE  AS CODE_CRIT_OUTAGE,                 
MFA-TR*               :S-SECURE-FL         AS SECURE_FL,                        
MFA-TR*               :S-EXTERNAL-ID       AS EXTERNAL_ID,                      
MFA-TR*               :S-ARC-FL            AS ARC_FL,                           
MFA-TR*               :S-CODE-WC-EQUIP     AS CODE_WC_EQUIP,                    
MFA-TR*               :S-WC-EQUIP-INST-DT  AS WC_EQUIP_INST_DT,                 
MFA-TR*               :S-WC-COMMENTS       AS WC_COMMENTS,                      
MFA-TR*               :S-WC-BACKUP-HOURS   AS WC_BACKUP_HOURS,                  
MFA-TR*               :S-GIS-POINT-ID      AS GIS_POINT_ID,                     
MFA-TR*               :S-WEBSITE-ADDR      AS WEBSITE_ADDR,                     
MFA-TR*               :S-GROUP-ID          AS GROUP_ID,                         
MFA-TR*               :S-AGL-TRACKING-ID   AS AGL_TRACKING_ID,                  
MFA-TR*               :S-DIST-ACCT-NO      AS DIST_ACCOUNT_NO,                  
MFA-TR*               :S-ORIGINATION-CD    AS ORIGINATION_CD,                   
MFA-TR*               :S-AFF-COMPANY-NO    AS AFF_COMPANY_NO,                   
MFA-TR*               :S-ORIG-DIST-ACCT-NO AS ORIG_DIST_ACCT_NO,                
MFA-TR*               :S-DIST-COMPANY-NO   AS DIST_COMPANY_NO,                  
MFA-TR*               :S-MKT-POOL-GRP      AS MKT_POOL_GRP,                     
MFA-TR*               :S-RATE-SCHEDULE     AS RATE_SCHEDULE,                    
MFA-TR*               :S-AGL-PREMISE-NO    AS AGL_PREMISE_NO,                   
MFA-TR*               :S-DELETE-FL         AS DELETE_FL,                        
MFA-TR*               :S-CODE-ACCT-USAGE   AS CODE_ACCT_USAGE,                  
MFA-TR*               :S-READ-CYCLE        AS READ_CYCLE,                       
MFA-TR*               :S-REG-DEREG-CD      AS REG_DEREG_CD,                     
MFA-TR*               :S-FORECAST-DNP-FL   AS FORECAST_DNP_FL,                  
MFA-TR*               :S-DPP-CD            AS DPP_CD,                           
MFA-TR*               :S-SEASONAL-FL       AS SEASONAL_FL,                      
MFA-TR*               :S-SENIOR-RATE-FL    AS SENIOR_RATE_FL                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      ATTRIBUTE_DESC    AS ATTRIBUTE_DESC,              
                      ATTRIBUTE_DT      AS ATTRIBUTE_DT,                
                      ATTRIBUTE_STATUS  AS ATTRIBUTE_STATUS,            
                      ATTRIBUTE_VALUE   AS ATTRIBUTE_VALUE,             
                      ATTRIBUTE_TYPE    AS ATTRIBUTE_TYPE               
                FROM #CSR04695_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               ATTRIBUTE_DESC    AS ATTRIBUTE_DESC,                      
MFA-TR*               ATTRIBUTE_DT      AS ATTRIBUTE_DT,                        
MFA-TR*               ATTRIBUTE_STATUS  AS ATTRIBUTE_STATUS,                    
MFA-TR*               ATTRIBUTE_VALUE   AS ATTRIBUTE_VALUE,                     
MFA-TR*               ATTRIBUTE_TYPE    AS ATTRIBUTE_TYPE                       
MFA-TR*         FROM SESSION.CSR04695_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-ATTRIBUTE-DESC    AS ATTRIBUTE_DESC,           
                      :S-ATTRIBUTE-DT      AS ATTRIBUTE_DT,             
                      :S-ATTRIBUTE-STATUS  AS ATTRIBUTE_STATUS,         
                      :S-ATTRIBUTE-VALUE   AS ATTRIBUTE_VALUE,          
                      :S-ATTRIBUTE-TYPE    AS ATTRIBUTE_TYPE            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-ATTRIBUTE-DESC    AS ATTRIBUTE_DESC,                   
MFA-TR*               :S-ATTRIBUTE-DT      AS ATTRIBUTE_DT,                     
MFA-TR*               :S-ATTRIBUTE-STATUS  AS ATTRIBUTE_STATUS,                 
MFA-TR*               :S-ATTRIBUTE-VALUE   AS ATTRIBUTE_VALUE,                  
MFA-TR*               :S-ATTRIBUTE-TYPE    AS ATTRIBUTE_TYPE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04695_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04695_R2
              (                                                          
               RETURN_CODE          INT,                            
               ATTRIBUTE_DESC CHAR(18)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ATTRIBUTE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ATTRIBUTE_STATUS CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ATTRIBUTE_VALUE CHAR(05)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ATTRIBUTE_TYPE CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04695_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR                   
                                   WS-ACCOUNT-NO.                       
                                                                        
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7030-DELINQUENCY THRU 7030-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           IF LINK-ACCOUNT-NO = ZEROES                                  
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-DBA-NAME                      
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE 'N' TO S-DELETE-FL.                                     
           IF (AT-CODE-ACCT-STAT = 'P' OR                               
               AT-ACCOUNT-TYPE-CODE = 'N') AND                          
               WS-ARCHIVED-ACCOUNT = 'N'                                
                  PERFORM 2010-SET-DELETE-FL THRU 2010-EXIT
           END-IF.            
           IF WS-ARCHIVED-ACCOUNT = 'Y'                                 
               PERFORM 7011-SELECT-DBA-ARCH THRU 7011-EXIT              
           ELSE                                                         
               PERFORM 7010-SELECT-DBA THRU 7010-EXIT
           END-IF.                  
           PERFORM 7020-SELECT-WC THRU 7020-EXIT.                       
           MOVE 'ARC-IND-INVALID' TO C8-DELINQ-CD.                      
           PERFORM 7030-DELINQUENCY THRU 7030-EXIT.                     
           IF WS-ARC-VALID-FL = 'Y'                                     
              PERFORM 7040-CHECK-ARC-IND THRU 7040-EXIT                 
           ELSE                                                         
              MOVE 'I' TO S-ARC-FL
           END-IF.                                     
           PERFORM 7050-SELECT-MISC THRU 7050-EXIT.                     
           PERFORM 7090-SELECT-UTIL-ENV THRU 7090-EXIT.                 
           IF WS-ARCHIVED-ACCOUNT = 'N'                                 
               IF SEB-DATABASE                                          
                   PERFORM 7060-SELECT-MIA-XREF THRU 7060-EXIT          
                   PERFORM 7070-SELECT-MKTX THRU 7070-EXIT              
                   PERFORM 7100-SELECT-REG-PROFILE THRU 7100-EXIT       
                   PERFORM 7150-SENIOR-RATE THRU 7150-EXIT              
               ELSE                                                     
                   MOVE 'N' TO S-SENIOR-RATE-FL                         
                   INITIALIZE DCLCSS-SEB-MIA-XREF                       
                   INITIALIZE DCLCSS-MKT-XREF-ACCT                      
                   INITIALIZE DCLCSS-REG-PROFILE
               END-IF
           END-IF.                       
                                                                        
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.            
           MOVE AT-ACCOUNT-INIT-TS(1:10) TO S-ACCOUNT-INIT-DT.          
           MOVE AT-ACCT-CREATE-DT(1:10) TO S-ACCT-CREATE-DT.            
           MOVE AT-ACCT-FINALED-DT(1:10) TO S-ACCT-FINALED-DT.          
           MOVE AT-CODE-ACCT-STAT TO S-CODE-ACCT-STAT.                  
           MOVE AT-BILL-CYCLE TO S-BILL-CYCLE.                          
           MOVE AT-BILL-CYCLE-CHG-CD TO S-BILL-CYCLE-CHG-CD.            
           MOVE AT-PREV-BILL-CYCLE TO S-PREV-BILL-CYCLE.                
           MOVE AT-CODE-STATUS-REASON TO S-CODE-STATUS-REASON.          
           MOVE AT-NO-BILL-COPIES TO S-NO-BILL-COPIES.                  
           MOVE AT-PRINT-TYPE-CD TO S-PRINT-TYPE-CD.                    
           MOVE AT-CODE-BILL-FREQ TO S-CODE-BILL-FREQ.                  
           MOVE AT-MST-SUB-ACCT-IND TO S-MST-SUB-ACCT-IND.              
           MOVE AT-CODE-MAJOR-ACCT TO S-CODE-MAJOR-ACCT.                
           MOVE AT-CODE-CRIT-OUTAGE TO S-CODE-CRIT-OUTAGE.              
           MOVE AT-CODE-ACCT-USAGE TO S-CODE-ACCT-USAGE.                
           MOVE UT-READ-CYCLE TO S-READ-CYCLE.                          
           IF AT-CODE-CRIT-OUTAGE > ' '                                 
               PERFORM 7080-SELECT-CRIT-OUTAGE THRU 7080-EXIT           
               MOVE Q2-SECURE-FL TO S-SECURE-FL
           END-IF.                        
           IF AT-CREDIT-GROUP = 'M' OR AT-CREDIT-GROUP = 'D'            
              MOVE 'N' TO S-UTIL-NON-UTIL                               
           ELSE                                                         
              MOVE 'U' TO S-UTIL-NON-UTIL
           END-IF.                              
           IF DQ-FULL-NAME = SPACES AND                                 
              AT-CODE-ACCT-STAT = 'P'                                   
                  PERFORM 7015-SELECT-CUST-DBA THRU 7015-EXIT
           END-IF.          
           MOVE DQ-FULL-NAME TO S-DBA-NAME.                             
           MOVE PP-AREA-ID TO S-GIS-POINT-ID(1:3).                      
           MOVE PP-TAG-NM TO S-GIS-POINT-ID(4:7).                       
           MOVE WH-CODE-WC-EQUIP TO S-CODE-WC-EQUIP.                    
           MOVE WH-WC-EQUIP-INST-DATE TO S-WC-EQUIP-INST-DT.            
           MOVE WH-WC-COMMENTS-TEXT TO S-WC-COMMENTS.                   
           MOVE WH-WC-BACKUP-HOURS TO S-WC-BACKUP-HOURS.                
           MOVE TA-WEBSITE-ADDR TO S-WEBSITE-ADDR.                      
           MOVE TA-GROUP-ID TO S-GROUP-ID.                              
           MOVE TA-SEASONAL-FL TO S-SEASONAL-FL.                        
           MOVE JM-AGL-TRACKING-ID TO S-AGL-TRACKING-ID.                
           MOVE XM-DIST-ACCT-NO TO S-DIST-ACCT-NO.                      
           MOVE XM-ORIGINATION-CD TO S-ORIGINATION-CD.                  
           MOVE XM-AFF-COMPANY-NO TO S-AFF-COMPANY-NO.                  
           MOVE XM-ORIG-DIST-ACCT-NO TO S-ORIG-DIST-ACCT-NO.            
           MOVE XM-DIST-COMPANY-NO TO S-DIST-COMPANY-NO.                
           MOVE XM-MKT-POOL-GRP TO S-MKT-POOL-GRP.                      
           MOVE XM-RATE-SCHEDULE TO S-RATE-SCHEDULE.                    
           MOVE PR-AGL-PREM-NO TO S-AGL-PREMISE-NO.                     
           EVALUATE LR-REG-GROUP-CD                                     
               WHEN '100'                                               
               WHEN '200'                                               
                   MOVE 'R' TO S-REG-DEREG-CD                           
               WHEN OTHER                                               
                   MOVE 'D' TO S-REG-DEREG-CD                           
           END-EVALUATE.                                                
           MOVE WS-CODE-DPP-ACCT TO S-DPP-CD.                           
           PERFORM 2200-ENCRYPT-ACCOUNT THRU 2200-EXIT.                 
           ADD 1 TO CTR-ROWS.                                           
                                                                        
           PERFORM 7500-OPEN-ATTRIB-CURSOR THRU 7500-EXIT.              
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
           PERFORM 7501-CLOSE-ATTRIB-CURSOR THRU 7501-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-SET-DELETE-FL.                                              
                                                                        
           PERFORM 7200-SELECT-AR-CNTL THRU 7200-EXIT.                  
           IF S-DELETE-FL = 'Y'                                         
              PERFORM 7210-SELECT-DEP-ON-HAND THRU 7210-EXIT
           END-IF.           
           IF S-DELETE-FL = 'Y'                                         
              PERFORM 7220-SELECT-AR-TRANSHIST THRU 7220-EXIT
           END-IF.          
           IF S-DELETE-FL = 'Y'                                         
              PERFORM 7230-SELECT-ACCT-XFER THRU 7230-EXIT
           END-IF.             
           IF S-DELETE-FL = 'Y'                                         
              PERFORM 7240-SELECT-SO-DATA THRU 7240-EXIT
           END-IF.               
           IF S-DELETE-FL = 'Y'                                         
              PERFORM 7250-SELECT-SO-XFER THRU 7250-EXIT
           END-IF.               
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ATTRIB-CURSOR                                      
                INTO :YP-ATTRIBUTE-DESC,                                
                     :YP-ATTRIBUTE-VALUE-CD,                            
                     :YP-ATTRIBUTE-VALUE-DT :WS-NULL-1,                  
                     :YP-STATUS-CD,                                     
                     :WZ-ATTRIBUTE-TYPE-TX                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO YP-ATTRIBUTE-VALUE-DT             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE YP-ATTRIBUTE-DESC TO S-ATTRIBUTE-DESC.                  
           MOVE YP-ATTRIBUTE-VALUE-CD TO S-ATTRIBUTE-VALUE.             
           MOVE YP-ATTRIBUTE-VALUE-DT TO S-ATTRIBUTE-DT.                
           MOVE YP-STATUS-CD TO S-ATTRIBUTE-STATUS.                     
           MOVE WZ-ATTRIBUTE-TYPE-TX TO S-ATTRIBUTE-TYPE.               
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * WS-SUB1 = THE POSITION WITHIN THE INPUT ACCOUNT NUMBER                  
      * WS-SUB2 = THE INCREMENTOR FOR MOD                                       
      * WS-SUB3 = THE VALUE OF THE ACCOUNT NUMBER BYTE BEING PROCESSED          
      * WS-SUB4 = THE POSITION WITHIN THE OUTPUT EXTERNAL ACCOUNT NUMBER        
                                                                        
       2200-ENCRYPT-ACCOUNT.                                            
                                                                        
           IF SEB-DATABASE                                              
               MOVE '2' TO WS-EXTERNAL-ID(1:1)                          
           ELSE                                                         
               MOVE '1' TO WS-EXTERNAL-ID(1:1)
           END-IF.                         
           MOVE AT-COMPANY-NO TO WS-EXTERNAL-ID(2:2).                   
           MOVE +4 TO WS-SUB4.                                          
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL WS-SUB1 > 13       
               IF WS-SUB1 > 9                                           
                   COMPUTE WS-SUB2 = WS-SUB1 - 10                       
               ELSE                                                     
                   MOVE WS-SUB1 TO WS-SUB2                              
               END-IF                                                   
               MOVE WS-ACCOUNT-NO-BYTE(WS-SUB1) TO WS-SUB3              
               EXEC SQL                                                 
                  SELECT
              (((:WS-SUB3 + :WS-SUB2))%(10))
            INTO
              :WS-MOD-OUT                                    
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*        EXEC SQL                                                         
MFA-TR*           VALUES MOD((:WS-SUB3 + :WS-SUB2), 10)                         
MFA-TR*             INTO :WS-MOD-OUT                                            
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE WS-MOD-OUT TO WS-MOD-BYTE                           
               MOVE WS-MOD-BYTE TO WS-EXTERNAL-ID(WS-SUB4:1)            
               ADD +1 TO WS-SUB4                                        
           END-PERFORM.                                                 
           MOVE WS-EXTERNAL-ID (1:4) TO S-EXTERNAL-ID(1:4).             
           MOVE WS-EXTERNAL-ID (5:4) TO S-EXTERNAL-ID(6:4).             
           MOVE WS-EXTERNAL-ID (9:4) TO S-EXTERNAL-ID(11:4).            
           MOVE WS-EXTERNAL-ID (13:4) TO S-EXTERNAL-ID(16:4).           
           MOVE '-' TO S-EXTERNAL-ID(5:1)                               
                       S-EXTERNAL-ID(10:1)                              
                       S-EXTERNAL-ID(15:1).                             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_TYPE_CODE,
              REPLACE(REPLACE(CONVERT(CHAR(26), ACCOUNT_INIT_TS, 121), 
           ' ', '-'), ':', '.') ACCOUNT_INIT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT, 121), 
           ' ', '-'), ':', '.') ACCT_CREATE_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT, 121), 
           ' ', '-'), ':', '.') ACCT_FINALED_DT,
              CODE_ACCT_STAT,
              BILL_CYCLE,
              BILL_CYCLE_CHG_CD,
              PREV_BILL_CYCLE,
              CODE_STATUS_REASON,
              NO_BILL_COPIES,
              PRINT_TYPE_CD,
              CODE_BILL_FREQ,
              MST_SUB_ACCT_IND,
              CODE_MAJOR_ACCT,
              CODE_CRIT_OUTAGE,
              CREDIT_GROUP,
              AT.COMPANY_NO,
              AGL_PREM_NO,
              CODE_ACCT_USAGE,
              CODES_DATA_PRESENT,
              CUSTOMER_NO                                        
                INTO :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-ACCOUNT-INIT-TS :WS-NULL-2,                     
                     :AT-ACCT-CREATE-DT :WS-NULL-3,                      
                     :AT-ACCT-FINALED-DT :WS-NULL-4,                     
                     :AT-CODE-ACCT-STAT,                                
                     :AT-BILL-CYCLE,                                    
                     :AT-BILL-CYCLE-CHG-CD,                             
                     :AT-PREV-BILL-CYCLE,                               
                     :AT-CODE-STATUS-REASON,                            
                     :AT-NO-BILL-COPIES,                                
                     :AT-PRINT-TYPE-CD,                                 
                     :AT-CODE-BILL-FREQ,                                
                     :AT-MST-SUB-ACCT-IND,                              
                     :AT-CODE-MAJOR-ACCT,                               
                     :AT-CODE-CRIT-OUTAGE,                              
                     :AT-CREDIT-GROUP,                                  
                     :AT-COMPANY-NO,                                    
                     :PR-AGL-PREM-NO,                                   
                     :AT-CODE-ACCT-USAGE,                               
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_PREMISE PR WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND AT.PREMISE_NO = PR.PREMISE_NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE,                                         
MFA-TR*              ACCOUNT_INIT_TS,                                           
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              ACCT_FINALED_DT,                                           
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              BILL_CYCLE,                                                
MFA-TR*              BILL_CYCLE_CHG_CD,                                         
MFA-TR*              PREV_BILL_CYCLE,                                           
MFA-TR*              CODE_STATUS_REASON,                                        
MFA-TR*              NO_BILL_COPIES,                                            
MFA-TR*              PRINT_TYPE_CD,                                             
MFA-TR*              CODE_BILL_FREQ,                                            
MFA-TR*              MST_SUB_ACCT_IND,                                          
MFA-TR*              CODE_MAJOR_ACCT,                                           
MFA-TR*              CODE_CRIT_OUTAGE,                                          
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AGL_PREM_NO,                                               
MFA-TR*              CODE_ACCT_USAGE,                                           
MFA-TR*              CODES_DATA_PRESENT,                                        
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-ACCOUNT-INIT-TS:WS-NULL-2,                             
MFA-TR*              :AT-ACCT-CREATE-DT:WS-NULL-3,                              
MFA-TR*              :AT-ACCT-FINALED-DT:WS-NULL-4,                             
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-BILL-CYCLE-CHG-CD,                                     
MFA-TR*              :AT-PREV-BILL-CYCLE,                                       
MFA-TR*              :AT-CODE-STATUS-REASON,                                    
MFA-TR*              :AT-NO-BILL-COPIES,                                        
MFA-TR*              :AT-PRINT-TYPE-CD,                                         
MFA-TR*              :AT-CODE-BILL-FREQ,                                        
MFA-TR*              :AT-MST-SUB-ACCT-IND,                                      
MFA-TR*              :AT-CODE-MAJOR-ACCT,                                       
MFA-TR*              :AT-CODE-CRIT-OUTAGE,                                      
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :PR-AGL-PREM-NO,                                           
MFA-TR*              :AT-CODE-ACCT-USAGE,                                       
MFA-TR*              :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_PREMISE PR                                             
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*         AND AT.PREMISE_NO = PR.PREMISE_NO                               
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT  
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO AT-ACCOUNT-INIT-TS                
                   END-IF                                               
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ACCOUNT                            
                              DCLCSS-PREMISE                            
                   MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO              
                   PERFORM 7001-SELECT-ACCOUNT-ARCH THRU 7001-EXIT      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7000'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT' TO TABLE-1                        
                   MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                
                   MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7001-SELECT-ACCOUNT-ARCH.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_ACCT_STAT,                                    
                     CODE_STATUS_REASON,                                
                     CREDIT_GROUP,                                      
                     ACCT_XFER_TO,                                      
                     ACCT_XFER_FROM_LST,                                
                     ACCOUNT_BALANCE_AM,                                
                     PREMISE_NO,                                        
                     ACCT_FINALED_DT,                                   
                     COMPANY_NO,                                        
                     LOCAL_OFFICE,                                      
                     CUSTOMER_NO,                                       
                     ADDRESS_ID,                                        
                     LAST_PYMT_AMOUNT,                                  
                     LAST_PYMT_DATE,                                    
                     ACCOUNT_TYPE_CODE,                                 
                     ACCT_CREATE_DT,                                    
                     REG_GROUP_CD,                                      
                     SENIOR_FL,                                         
                     ORIGINATION_CD,                                    
                     DIST_ACCT_NO,                                      
                     ARCHIVED_DT                                        
              INTO  :AT-CODE-ACCT-STAT,                                 
                    :AT-CODE-STATUS-REASON,                             
                    :AT-CREDIT-GROUP,                                   
                    :AT-ACCT-XFER-TO,                                   
                    :AT-ACCT-XFER-FROM-LST,                             
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-PREMISE-NO,                                     
                    :AT-ACCT-FINALED-DT :WS-NULL-6,                      
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-CUSTOMER-NO,                                    
                    :AT-ADDRESS-ID,                                     
                    :AT-LAST-PYMT-AMOUNT,                               
                    :AT-LAST-PYMT-DATE :WS-NULL-7,                      
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-ACCT-CREATE-DT :WS-NULL-5,                       
                    :LR-REG-GROUP-CD,                                   
                    :LR-SENIOR-FL,                                      
                    :WS-ORIGINATION-CD,                                 
                    :XM-DIST-ACCT-NO,                                   
                    :HA-ARCHIVED-DT                                     
                 FROM HST_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_ACCT_STAT,                                            
MFA-TR*              CODE_STATUS_REASON,                                        
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              ACCT_XFER_TO,                                              
MFA-TR*              ACCT_XFER_FROM_LST,                                        
MFA-TR*              ACCOUNT_BALANCE_AM,                                        
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              ACCT_FINALED_DT,                                           
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              LAST_PYMT_AMOUNT,                                          
MFA-TR*              LAST_PYMT_DATE,                                            
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              REG_GROUP_CD,                                              
MFA-TR*              SENIOR_FL,                                                 
MFA-TR*              ORIGINATION_CD,                                            
MFA-TR*              DIST_ACCT_NO,                                              
MFA-TR*              ARCHIVED_DT                                                
MFA-TR*       INTO  :AT-CODE-ACCT-STAT,                                         
MFA-TR*             :AT-CODE-STATUS-REASON,                                     
MFA-TR*             :AT-CREDIT-GROUP,                                           
MFA-TR*             :AT-ACCT-XFER-TO,                                           
MFA-TR*             :AT-ACCT-XFER-FROM-LST,                                     
MFA-TR*             :AT-TOTAL-AR-BALANCE,                                       
MFA-TR*             :AT-PREMISE-NO,                                             
MFA-TR*             :AT-ACCT-FINALED-DT:WS-NULL-6,                              
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-LOCAL-OFFICE,                                           
MFA-TR*             :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-ADDRESS-ID,                                             
MFA-TR*             :AT-LAST-PYMT-AMOUNT,                                       
MFA-TR*             :AT-LAST-PYMT-DATE :WS-NULL-7,                              
MFA-TR*             :AT-ACCOUNT-TYPE-CODE,                                      
MFA-TR*             :AT-ACCT-CREATE-DT:WS-NULL-5,                               
MFA-TR*             :LR-REG-GROUP-CD,                                           
MFA-TR*             :LR-SENIOR-FL,                                              
MFA-TR*             :WS-ORIGINATION-CD,                                         
MFA-TR*             :XM-DIST-ACCT-NO,                                           
MFA-TR*             :HA-ARCHIVED-DT                                             
MFA-TR*          FROM HST_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ARCHIVED-ACCOUNT                      
                   IF WS-NULL-7 < 0                                     
                       MOVE SPACES TO AT-LAST-PYMT-DATE                 
                   END-IF                                               
                   IF WS-NULL-6 < 0                                     
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
                   IF WS-NULL-5 < 0                                     
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-DBA.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FULL_NAME                                         
                 INTO :DQ-FULL-NAME                                     
                 FROM CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND AB.NAME_TYPE = 'DB'                               
                  AND AB.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FULL_NAME                                                 
MFA-TR*          INTO :DQ-FULL-NAME                                             
MFA-TR*          FROM CSS_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND AB.NAME_TYPE = 'DB'                                       
MFA-TR*           AND AB.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO DQ-FULL-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7011-SELECT-DBA-ARCH.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FULL_NAME                                         
                 INTO :DQ-FULL-NAME                                     
                 FROM HST_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND AB.NAME_TYPE = 'DB'                               
                  AND AB.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FULL_NAME                                                 
MFA-TR*          INTO :DQ-FULL-NAME                                             
MFA-TR*          FROM HST_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND AB.NAME_TYPE = 'DB'                                       
MFA-TR*           AND AB.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7011                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO DQ-FULL-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7011'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCT_BILL_NMES' TO TABLE-1                 
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-SELECT-CUST-DBA.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DBA_NAME,
              WEBSITE_ADDR                                      
                 INTO :DQ-FULL-NAME,                                    
                      :TA-WEBSITE-ADDR                                  
                 FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DBA_NAME,                                                 
MFA-TR*               WEBSITE_ADDR                                              
MFA-TR*          INTO :DQ-FULL-NAME,                                            
MFA-TR*               :TA-WEBSITE-ADDR                                          
MFA-TR*          FROM CSS_CUST_MISC_INFO                                        
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO DQ-FULL-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7015'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-WC.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) WC.POINT_ID,
              CODE_WC_EQUIP,
              WC_EQUIP_INST_DATE,
              WC_BACKUP_HOURS,
              WC_COMMENTS,
              TAG_NM,
              AREA_ID                                           
                 INTO :WH-POINT-ID,                                     
                      :WH-CODE-WC-EQUIP,                                
                      :WH-WC-EQUIP-INST-DATE,                           
                      :WH-WC-BACKUP-HOURS,                              
                      :WH-WC-COMMENTS,                                  
                      :PP-TAG-NM,                                       
                      :PP-AREA-ID                                       
                 FROM CSS_ACCT_WHT_CROSS WC WITH(READUNCOMMITTED),              
                      CSS_PIM_POINT PP WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND WC.GIS_POINT_ID = PP.POINT_ID                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WC.POINT_ID,                                              
MFA-TR*               CODE_WC_EQUIP,                                            
MFA-TR*               WC_EQUIP_INST_DATE,                                       
MFA-TR*               WC_BACKUP_HOURS,                                          
MFA-TR*               WC_COMMENTS,                                              
MFA-TR*               TAG_NM,                                                   
MFA-TR*               AREA_ID                                                   
MFA-TR*          INTO :WH-POINT-ID,                                             
MFA-TR*               :WH-CODE-WC-EQUIP,                                        
MFA-TR*               :WH-WC-EQUIP-INST-DATE,                                   
MFA-TR*               :WH-WC-BACKUP-HOURS,                                      
MFA-TR*               :WH-WC-COMMENTS,                                          
MFA-TR*               :PP-TAG-NM,                                               
MFA-TR*               :PP-AREA-ID                                               
MFA-TR*          FROM CSS_ACCT_WHT_CROSS WC,                                    
MFA-TR*               CSS_PIM_POINT PP                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND WC.GIS_POINT_ID = PP.POINT_ID                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ACCT-WHT-CROSS                     
                              DCLCSS-PIM-POINT                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_WHT_CROSS' TO TABLE-1                 
                   MOVE 'CSS_PIM_POINT'  TO TABLE-2                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD = :C8-DELINQ-CD                         
                  AND COMPANY_NO = '01'                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD = :C8-DELINQ-CD                                 
MFA-TR*           AND COMPANY_NO = '01'                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO WS-ARC-VALID-FL                          
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'Y' TO WS-ARC-VALID-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'      TO TABLE-ELEMENT-1             
                   MOVE C8-DELINQ-CD     TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * ROW ON TABLE INDICATES CHECKS CANNOT BE CONVERTED ELECTRONICALLY        
                                                                        
       7040-CHECK-ARC-IND.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :YP-ACCOUNT-NO                                    
                 FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED),                   
                      CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)               
                WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC          
                  AND YP.ATTRIBUTE_DESC    = 'CONVERT_CHK_ELEC'         
                  AND WZ.COMPANY_NO        = :AT-COMPANY-NO             
                  AND YP.ACCOUNT_NO        = :AT-ACCOUNT-NO             
                  AND WZ.ATTRIBUTE_STAT_CD = 'A'                        
                  AND WZ.ATTRIBUTE_TYPE_TX = 'ARC'                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :YP-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ATTRIBUTE WZ,                                         
MFA-TR*               CSS_ACCT_ATTRIBUTE YP                                     
MFA-TR*         WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC                  
MFA-TR*           AND YP.ATTRIBUTE_DESC    = 'CONVERT_CHK_ELEC'                 
MFA-TR*           AND WZ.COMPANY_NO        = :AT-COMPANY-NO                     
MFA-TR*           AND YP.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*           AND WZ.ATTRIBUTE_STAT_CD = 'A'                                
MFA-TR*           AND WZ.ATTRIBUTE_TYPE_TX = 'ARC'                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-ARC-FL                                 
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'Y' TO S-ARC-FL                                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ATTRIBUTE'   TO TABLE-1                    
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-2             
                   MOVE AT-COMPANY-NO    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-MISC.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) WEBSITE_ADDR,
              GROUP_ID,
              SEASONAL_FL                                       
                 INTO :TA-WEBSITE-ADDR,                                 
                      :TA-GROUP-ID,                                     
                      :TA-SEASONAL-FL                                   
                 FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WEBSITE_ADDR,                                             
MFA-TR*               GROUP_ID,                                                 
MFA-TR*               SEASONAL_FL                                               
MFA-TR*          INTO :TA-WEBSITE-ADDR,                                         
MFA-TR*               :TA-GROUP-ID,                                             
MFA-TR*               :TA-SEASONAL-FL                                           
MFA-TR*          FROM CSS_ACCT_MISC_INFO                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ACCT-MISC-INFO                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-MIA-XREF.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AGL_TRACKING_ID                                   
                 INTO :JM-AGL-TRACKING-ID                               
                 FROM CSS_SEB_MIA_XREF WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AGL_TRACKING_ID                                           
MFA-TR*          INTO :JM-AGL-TRACKING-ID                                       
MFA-TR*          FROM CSS_SEB_MIA_XREF                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO S-AGL-TRACKING-ID                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7060'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_SEB_MIA_XREF'   TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-MKTX.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DIST_ACCT_NO,
              ORIGINATION_CD,
              AFF_COMPANY_NO,
              ORIG_DIST_ACCT_NO,
              DIST_COMPANY_NO,
              MKT_POOL_GRP,
              RATE_SCHEDULE                                     
                 INTO :XM-DIST-ACCT-NO,                                 
                      :XM-ORIGINATION-CD,                               
                      :XM-AFF-COMPANY-NO,                               
                      :XM-ORIG-DIST-ACCT-NO,                            
                      :XM-DIST-COMPANY-NO,                              
                      :XM-MKT-POOL-GRP,                                 
                      :XM-RATE-SCHEDULE                                 
                 FROM CSS_MKT_XREF_ACCT WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DIST_ACCT_NO,                                             
MFA-TR*               ORIGINATION_CD,                                           
MFA-TR*               AFF_COMPANY_NO,                                           
MFA-TR*               ORIG_DIST_ACCT_NO,                                        
MFA-TR*               DIST_COMPANY_NO,                                          
MFA-TR*               MKT_POOL_GRP,                                             
MFA-TR*               RATE_SCHEDULE                                             
MFA-TR*          INTO :XM-DIST-ACCT-NO,                                         
MFA-TR*               :XM-ORIGINATION-CD,                                       
MFA-TR*               :XM-AFF-COMPANY-NO,                                       
MFA-TR*               :XM-ORIG-DIST-ACCT-NO,                                    
MFA-TR*               :XM-DIST-COMPANY-NO,                                      
MFA-TR*               :XM-MKT-POOL-GRP,                                         
MFA-TR*               :XM-RATE-SCHEDULE                                         
MFA-TR*          FROM CSS_MKT_XREF_ACCT                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO XM-DIST-ACCT-NO                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7070'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-CRIT-OUTAGE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SECURE_FL                                         
                 INTO :Q2-SECURE-FL                                     
                 FROM CSS_CRIT_OUTAGE WITH(READUNCOMMITTED)                     
                WHERE CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE           
                  AND COMPANY_NO = :AT-COMPANY-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SECURE_FL                                                 
MFA-TR*          INTO :Q2-SECURE-FL                                             
MFA-TR*          FROM CSS_CRIT_OUTAGE                                           
MFA-TR*         WHERE CODE_CRIT_OUTAGE = :AT-CODE-CRIT-OUTAGE                   
MFA-TR*           AND COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO Q2-SECURE-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7080'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CRIT_OUTAGE' TO TABLE-1                    
                   MOVE 'CODE_CRIT_OUTAGE' TO TABLE-ELEMENT-1           
                   MOVE AT-CODE-CRIT-OUTAGE TO HOSTVAR-ELEMENT-1        
                   MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-2             
                   MOVE AT-COMPANY-NO    TO HOSTVAR-ELEMENT-2           
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-SELECT-UTIL-ENV.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) READ_CYCLE                                        
                 INTO :UT-READ-CYCLE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE IN ('E', 'G')                      
                  AND READ_CYCLE > ' '                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_CYCLE                                                
MFA-TR*          INTO :UT-READ-CYCLE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE IN ('E', 'G')                              
MFA-TR*           AND READ_CYCLE > ' '                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO UT-READ-CYCLE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-REG-PROFILE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO LR-REG-GROUP-CD                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_REG_PROFILE' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-SENIOR-RATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :FF-ACCOUNT-NO                                    
                 FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND FACTOR_ID IN ('AGLSR CUS', 'AGLSR SOC')           
                  AND EFF_DATE_TO > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :FF-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_FIXED_FCTR                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND FACTOR_ID IN ('AGLSR CUS', 'AGLSR SOC')                   
MFA-TR*           AND EFF_DATE_TO > :WS-CURRENT-DATE                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-SENIOR-RATE-FL                         
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO S-SENIOR-RATE-FL                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_FIXED_FCTR' TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :AC-ACCOUNT-NO                                    
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :AC-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-DELETE-FL                              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'Y' TO S-DELETE-FL                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_CNTL'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :DO-ACCOUNT-NO                                    
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND DEPOSIT_STATUS_CD IN ('A', 'P')                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :DO-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_STATUS_CD IN ('A', 'P')                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-DELETE-FL                              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DEP_ON_HAND' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-SELECT-AR-TRANSHIST.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :AR-ACCOUNT-NO                                    
                 FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :AR-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_AR_TRANS_HIST                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-DELETE-FL                              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7220'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_TRANS_HIST' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-SELECT-ACCT-XFER.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCT_XFER_TO                                      
                 INTO :AT-ACCT-XFER-TO                                  
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCT_XFER_TO = :AT-ACCOUNT-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCT_XFER_TO                                              
MFA-TR*          INTO :AT-ACCT-XFER-TO                                          
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCT_XFER_TO = :AT-ACCOUNT-NO                             
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7230                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-DELETE-FL                              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7230'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-SELECT-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :VO-ACCOUNT-NO                                    
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE (ACCOUNT_NO = :AT-ACCOUNT-NO                      
                   OR ACCOUNT_NO_PRIOR = :AT-ACCOUNT-NO)                
                  AND ORDER_STATE_CD NOT IN ('Z', 'C')                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :VO-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE (ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*            OR ACCOUNT_NO_PRIOR = :AT-ACCOUNT-NO)                        
MFA-TR*           AND ORDER_STATE_CD NOT IN ('Z', 'C')                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7240                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-DELETE-FL                              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7240'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'ACCOUNT_NO_PRIOR' TO TABLE-ELEMENT-2           
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-SELECT-SO-XFER.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TO_ACCT_NO                                        
                 INTO :VY-TO-ACCT-NO                                    
                 FROM CSS_SO_ACCT_XFER VY WITH(READUNCOMMITTED),                
A05317                CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE TO_ACCT_NO = :AT-ACCOUNT-NO                       
A05317            AND VY.SERV_ORDER_NO = VO.SERV_ORDER_NO               
A05317            AND ORDER_STATE_CD NOT IN ('Z', 'C')                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TO_ACCT_NO                                                
MFA-TR*          INTO :VY-TO-ACCT-NO                                            
MFA-TR*          FROM CSS_SO_ACCT_XFER VY,                                      
MFA-TR*               CSS_SO_DATA VO                                            
MFA-TR*         WHERE TO_ACCT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND VY.SERV_ORDER_NO = VO.SERV_ORDER_NO                       
MFA-TR*           AND ORDER_STATE_CD NOT IN ('Z', 'C')                          
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-DELETE-FL                              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7250'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_ACCT_XFER' TO TABLE-1                   
                   MOVE 'TO_ACCT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-ATTRIB-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN ATTRIB-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-ATTRIB-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE ATTRIB-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04695_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04695_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04695_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04695_R2                            
             (                                                          
              RETURN_CODE,                                              
              ATTRIBUTE_DESC,                                           
              ATTRIBUTE_DT,                                             
              ATTRIBUTE_STATUS,                                         
              ATTRIBUTE_VALUE,                                          
              ATTRIBUTE_TYPE                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-ATTRIBUTE-DESC,                                       
               :S-ATTRIBUTE-DT,                                         
               :S-ATTRIBUTE-STATUS,                                     
               :S-ATTRIBUTE-VALUE,                                      
               :S-ATTRIBUTE-TYPE                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04695_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ATTRIBUTE_DESC,                                                   
MFA-TR*       ATTRIBUTE_DT,                                                     
MFA-TR*       ATTRIBUTE_STATUS,                                                 
MFA-TR*       ATTRIBUTE_VALUE,                                                  
MFA-TR*       ATTRIBUTE_TYPE                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-ATTRIBUTE-DESC,                                               
MFA-TR*        :S-ATTRIBUTE-DT,                                                 
MFA-TR*        :S-ATTRIBUTE-STATUS,                                             
MFA-TR*        :S-ATTRIBUTE-VALUE,                                              
MFA-TR*        :S-ATTRIBUTE-TYPE                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04695_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
