       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04692.                                          
COB303 DATE-WRITTEN. JANUARY 8, 2014.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS SPOUSE DATA.                            *        
      *  RESULTS SETS:                                                 *        
      *     1.  SPOUSE INFORMATION                                     *        
      *     2.  EMAIL ADDRESSES                                        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/08/14    FMB      NEW PROGRAM.                                      
D05317*  11/12/15    FMB      EMAIL DATE TO TIMESTAMP.                          
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04692'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04692 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04692_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04692_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-CUSTOMER-NO       PIC S9(13)V COMP-3 VALUE 0.       
               10 S-TITLE             PIC X(09) VALUE SPACES.           
               10 S-FIRST-NAME        PIC X(15) VALUE SPACES.           
               10 S-MIDDLE-NAME       PIC X(15) VALUE SPACES.           
               10 S-LAST-NAME         PIC X(40) VALUE SPACES.           
               10 S-SUFFIX            PIC X(03) VALUE SPACES.           
               10 S-SSN               PIC X(09) VALUE SPACES.           
               10 S-ITIN              PIC X(09) VALUE SPACES.           
               10 S-REFUSED-SSN       PIC X(01) VALUE SPACES.           
               10 S-DLN               PIC X(19) VALUE SPACES.           
               10 S-DLN-STATE         PIC X(02) VALUE SPACES.           
               10 S-DOB               PIC X(10) VALUE SPACES.           
               10 S-OTHER-ID-TYPE     PIC X(12) VALUE SPACES.           
               10 S-OTHER-ID          PIC X(16) VALUE SPACES.           
               10 S-ALLOW-CALL-FL     PIC X(01) VALUE SPACES.           
               10 S-ALLOW-EMAIL-FL    PIC X(01) VALUE SPACES.           
               10 S-WORK-PHONE        PIC X(10) VALUE SPACES.           
               10 S-WORK-PHONE-EXT    PIC X(06) VALUE SPACES.           
               10 S-WORK-MOBILE-FL    PIC X(01) VALUE SPACES.           
               10 S-WORK-MKT-FL       PIC X(01) VALUE SPACES.           
               10 S-WORK-MKT-DT       PIC X(10) VALUE SPACES.           
               10 S-HOME-PHONE        PIC X(10) VALUE SPACES.           
               10 S-HOME-MOBILE-FL    PIC X(01) VALUE SPACES.           
               10 S-HOME-MKT-FL       PIC X(01) VALUE SPACES.           
               10 S-HOME-MKT-DT       PIC X(10) VALUE SPACES.           
               10 S-ALT-PHONE         PIC X(10) VALUE SPACES.           
               10 S-ALT-MOBILE-FL     PIC X(01) VALUE SPACES.           
               10 S-ALT-MKT-FL        PIC X(01) VALUE SPACES.           
               10 S-ALT-MKT-DT        PIC X(10) VALUE SPACES.           
               10 S-EMPLOYER          PIC X(23) VALUE SPACES.           
               10 S-ACCESS-LEVEL-CD   PIC X(02) VALUE SPACES.           
               10 S-VALIDATION-TS     PIC X(26) VALUE SPACES.           
               10 S-CONFIRM-FL        PIC X(26) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-EMAIL-ADDRESS     PIC X(100) VALUE SPACES.          
               10 S-EMAIL-TYPE-CD     PIC X(02) VALUE SPACES.           
               10 S-EMAIL-MKT-FL      PIC X(01) VALUE SPACES.           
               10 S-EMAIL-MKT-DT      PIC X(10) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04692'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE EMAIL-CURSOR CURSOR FOR                           
               SELECT EMAIL_TYPE_CD,                                    
                      EMAIL_ADDRESS_TX,                                 
                      PERMISN_TO_MKT_FL,                                
D05317                REPLACE(REPLACE(CONVERT(CHAR(26), 
           PERMISN_TO_MKT_TS, 121), ' ', '-'), ':', '.') 
           PERMISN_TO_MKT_TS                                 
                 FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                     
                  AND EMAIL_TYPE_CD LIKE 'S%'                           
                  AND EMAIL_ADDRESS_TX > ' '                            
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EMAIL-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT EMAIL_TYPE_CD,                                            
MFA-TR*               EMAIL_ADDRESS_TX,                                         
MFA-TR*               PERMISN_TO_MKT_FL,                                        
MFA-TR*               PERMISN_TO_MKT_TS                                         
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD LIKE 'S%'                                   
MFA-TR*           AND EMAIL_ADDRESS_TX > ' '                                    
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1    AS RETURN_CODE,               
                      :S-STATUS-CODE      AS STATUS_CD,                 
                      :S-CUSTOMER-NO      AS CUSTOMER_NO,               
                      :S-TITLE            AS TITLE,                     
                      :S-FIRST-NAME       AS FIRST_NAME,                
                      :S-MIDDLE-NAME      AS MIDDLE_NAME,               
                      :S-LAST-NAME        AS LAST_NAME,                 
                      :S-SUFFIX           AS SUFFIX,                    
                      :S-SSN              AS SSN,                       
                      :S-ITIN             AS ITIN,                      
                      :S-REFUSED-SSN      AS REFUSED_SSN,               
                      :S-DLN              AS DLN,                       
                      :S-DLN-STATE        AS DLN_STATE,                 
                      :S-DOB              AS DOB,                       
                      :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,             
                      :S-OTHER-ID         AS OTHER_ID,                  
                      :S-ALLOW-CALL-FL    AS ALLOW_CALL_FL,             
                      :S-ALLOW-EMAIL-FL   AS ALLOW_EMAIL_FL,            
                      :S-WORK-PHONE       AS WORK_PHONE,                
                      :S-WORK-PHONE-EXT   AS WORK_PHONE_EXT,            
                      :S-WORK-MOBILE-FL   AS WORK_MOBILE_FL,            
                      :S-WORK-MKT-FL      AS WORK_MKT_FL,               
                      :S-WORK-MKT-DT      AS WORK_MKT_DT,               
                      :S-HOME-PHONE       AS HOME_PHONE,                
                      :S-HOME-MOBILE-FL   AS HOME_MOBILE_FL,            
                      :S-HOME-MKT-FL      AS HOME_MKT_FL,               
                      :S-HOME-MKT-DT      AS HOME_MKT_DT,               
                      :S-ALT-PHONE        AS ALT_PHONE,                 
                      :S-ALT-MOBILE-FL    AS ALT_MOBILE_FL,             
                      :S-ALT-MKT-FL       AS ALT_MKT_FL,                
                      :S-ALT-MKT-DT       AS ALT_MKT_DT,                
                      :S-EMPLOYER         AS EMPLOYER,                  
                      :S-ACCESS-LEVEL-CD  AS ACCESS_LEVEL_CD,           
                      :S-VALIDATION-TS    AS VALIDATION_TS,             
                      :S-CONFIRM-FL       AS CONFIRM_FL                 
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1    AS RETURN_CODE,                       
MFA-TR*               :S-STATUS-CODE      AS STATUS_CD,                         
MFA-TR*               :S-CUSTOMER-NO      AS CUSTOMER_NO,                       
MFA-TR*               :S-TITLE            AS TITLE,                             
MFA-TR*               :S-FIRST-NAME       AS FIRST_NAME,                        
MFA-TR*               :S-MIDDLE-NAME      AS MIDDLE_NAME,                       
MFA-TR*               :S-LAST-NAME        AS LAST_NAME,                         
MFA-TR*               :S-SUFFIX           AS SUFFIX,                            
MFA-TR*               :S-SSN              AS SSN,                               
MFA-TR*               :S-ITIN             AS ITIN,                              
MFA-TR*               :S-REFUSED-SSN      AS REFUSED_SSN,                       
MFA-TR*               :S-DLN              AS DLN,                               
MFA-TR*               :S-DLN-STATE        AS DLN_STATE,                         
MFA-TR*               :S-DOB              AS DOB,                               
MFA-TR*               :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,                     
MFA-TR*               :S-OTHER-ID         AS OTHER_ID,                          
MFA-TR*               :S-ALLOW-CALL-FL    AS ALLOW_CALL_FL,                     
MFA-TR*               :S-ALLOW-EMAIL-FL   AS ALLOW_EMAIL_FL,                    
MFA-TR*               :S-WORK-PHONE       AS WORK_PHONE,                        
MFA-TR*               :S-WORK-PHONE-EXT   AS WORK_PHONE_EXT,                    
MFA-TR*               :S-WORK-MOBILE-FL   AS WORK_MOBILE_FL,                    
MFA-TR*               :S-WORK-MKT-FL      AS WORK_MKT_FL,                       
MFA-TR*               :S-WORK-MKT-DT      AS WORK_MKT_DT,                       
MFA-TR*               :S-HOME-PHONE       AS HOME_PHONE,                        
MFA-TR*               :S-HOME-MOBILE-FL   AS HOME_MOBILE_FL,                    
MFA-TR*               :S-HOME-MKT-FL      AS HOME_MKT_FL,                       
MFA-TR*               :S-HOME-MKT-DT      AS HOME_MKT_DT,                       
MFA-TR*               :S-ALT-PHONE        AS ALT_PHONE,                         
MFA-TR*               :S-ALT-MOBILE-FL    AS ALT_MOBILE_FL,                     
MFA-TR*               :S-ALT-MKT-FL       AS ALT_MKT_FL,                        
MFA-TR*               :S-ALT-MKT-DT       AS ALT_MKT_DT,                        
MFA-TR*               :S-EMPLOYER         AS EMPLOYER,                          
MFA-TR*               :S-ACCESS-LEVEL-CD  AS ACCESS_LEVEL_CD,                   
MFA-TR*               :S-VALIDATION-TS    AS VALIDATION_TS,                     
MFA-TR*               :S-CONFIRM-FL       AS CONFIRM_FL                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      EMAIL_ADDRESS     AS EMAIL_ADDRESS,               
                      EMAIL_TYPE_CD     AS EMAIL_TYPE_CD,               
                      EMAIL_MKT_FL      AS EMAIL_MKT_FL,                
                      EMAIL_MKT_DT      AS EMAIL_MKT_DT                 
                FROM #CSR04692_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               EMAIL_ADDRESS     AS EMAIL_ADDRESS,                       
MFA-TR*               EMAIL_TYPE_CD     AS EMAIL_TYPE_CD,                       
MFA-TR*               EMAIL_MKT_FL      AS EMAIL_MKT_FL,                        
MFA-TR*               EMAIL_MKT_DT      AS EMAIL_MKT_DT                         
MFA-TR*         FROM SESSION.CSR04692_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,            
                      :S-EMAIL-TYPE-CD     AS EMAIL_TYPE_CD,            
                      :S-EMAIL-MKT-FL      AS EMAIL_MKT_FL,             
                      :S-EMAIL-MKT-DT      AS EMAIL_MKT_DT              
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,                    
MFA-TR*               :S-EMAIL-TYPE-CD     AS EMAIL_TYPE_CD,                    
MFA-TR*               :S-EMAIL-MKT-FL      AS EMAIL_MKT_FL,                     
MFA-TR*               :S-EMAIL-MKT-DT      AS EMAIL_MKT_DT                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04692_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04692_R2
              (                                                          
               RETURN_CODE          INT,                            
               EMAIL_ADDRESS VARCHAR(100)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                       
               EMAIL_TYPE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
               EMAIL_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               EMAIL_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04692_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CE-CUSTOMER-NO.                   
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF LINK-CUSTOMER-NO = ZEROES                                 
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-LAST-NAME                     
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           PERFORM 7100-SELECT-SPOUSE-INFO THRU 7100-EXIT.              
                                                                        
           MOVE CE-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           MOVE DQ-FIRST-NAME TO S-FIRST-NAME.                          
           MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME.                        
           MOVE DQ-LAST-NAME TO S-LAST-NAME.                            
           MOVE DQ-TITLE-PREFIX TO S-TITLE.                             
           MOVE DQ-TITLE-SUFFIX-1 TO S-SUFFIX.                          
           MOVE CE-SSN TO S-SSN.                                        
           MOVE CE-CODE-STATE-ID TO S-DLN-STATE.                        
           MOVE CE-DRIVERS-LICENSE-NO TO S-DLN.                         
           MOVE CE-EMPLOYER TO S-EMPLOYER.                              
           MOVE CE-OTHER-ID-TYPE TO S-OTHER-ID-TYPE.                    
           MOVE CE-OTHER-ID TO S-OTHER-ID.                              
           MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN.                     
           MOVE CE-DATE-OF-BIRTH TO S-DOB.                              
           MOVE CE-ITIN-ID TO S-ITIN.                                   
           MOVE CE-ALLOW-CALL-FL TO S-ALLOW-CALL-FL.                    
           MOVE CE-ALLOW-EMAIL-FL TO S-ALLOW-EMAIL-FL.                  
           MOVE CE-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD.                
           MOVE CE-INFO-VERIFIED-TS TO S-VALIDATION-TS.                 
           MOVE 'CASA-CONTACT-CONFIRM' TO C8-DELINQ-CD.                 
           MOVE CU-COMPANY-NO-ORIG TO C8-COMPANY-NO.                    
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           EVALUATE C8-DELINQ-VALUE                                     
               WHEN 0                                                   
                   MOVE 'N' TO S-CONFIRM-FL                             
               WHEN 1                                                   
                   MOVE 'Y' TO S-CONFIRM-FL                             
           END-EVALUATE.                                                
                                                                        
           MOVE 'H1' TO WS-PHONE-TYPE.                                  
           PERFORM 7400-SELECT-PHONE-NO THRU 7400-EXIT.                 
           MOVE CB-PHONE-NO TO S-HOME-PHONE.                            
           MOVE CB-MOBILE-PHONE-FL TO S-HOME-MOBILE-FL.                 
           MOVE CB-PERMISN-TO-MKT-FL TO S-HOME-MKT-FL.                  
           MOVE CB-PERMISN-TO-MKT-DT TO S-HOME-MKT-DT.                  
                                                                        
           MOVE 'W1' TO WS-PHONE-TYPE.                                  
           PERFORM 7400-SELECT-PHONE-NO THRU 7400-EXIT.                 
           MOVE CB-PHONE-NO TO S-WORK-PHONE.                            
           MOVE CB-EXTENSION-NO TO S-WORK-PHONE-EXT.                    
           MOVE CB-MOBILE-PHONE-FL TO S-WORK-MOBILE-FL.                 
           MOVE CB-PERMISN-TO-MKT-FL TO S-WORK-MKT-FL.                  
           MOVE CB-PERMISN-TO-MKT-DT TO S-WORK-MKT-DT.                  
                                                                        
           MOVE 'A1' TO WS-PHONE-TYPE.                                  
           PERFORM 7400-SELECT-PHONE-NO THRU 7400-EXIT.                 
           MOVE CB-PHONE-NO TO S-ALT-PHONE.                             
           MOVE CB-MOBILE-PHONE-FL TO S-ALT-MOBILE-FL.                  
           MOVE CB-PERMISN-TO-MKT-FL TO S-ALT-MKT-FL.                   
           MOVE CB-PERMISN-TO-MKT-DT TO S-ALT-MKT-DT.                   
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
           PERFORM 7500-OPEN-EMAIL-CURSOR THRU 7500-EXIT.               
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
           PERFORM 7501-CLOSE-EMAIL-CURSOR THRU 7501-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO NE-EMAIL-ADDRESS-TX.                          
                                                                        
           EXEC SQL                                                     
               FETCH EMAIL-CURSOR                                       
                INTO :NE-EMAIL-TYPE-CD,                                 
                     :NE-EMAIL-ADDRESS-TX,                              
                     :NE-PERMISN-TO-MKT-FL,                             
D05317               :NE-PERMISN-TO-MKT-TS :WS-NULL-3                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
D05317                 MOVE SPACES TO NE-PERMISN-TO-MKT-TS              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE NE-EMAIL-TYPE-CD TO S-EMAIL-TYPE-CD.                    
           MOVE NE-EMAIL-ADDRESS-TX-TEXT TO S-EMAIL-ADDRESS.            
           MOVE NE-PERMISN-TO-MKT-FL TO S-EMAIL-MKT-FL.                 
D05317     MOVE NE-PERMISN-TO-MKT-TS(1:10) TO S-EMAIL-MKT-DT.           
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'   TO TABLE-ELEMENT-1                
                   MOVE C8-DELINQ-CD  TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-SPOUSE-INFO.                                         
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) SSN,
              CODE_STATE_ID,
              DRIVERS_LICENSE_NO,
              EMPLOYER,
              OTHER_ID_TYPE,
              OTHER_ID,
              DATE_OF_BIRTH,
              ALLOW_CALL_FL,
              ALLOW_EMAIL_FL,
              ITIN_ID,
              ACCESS_LEVEL_CD,
              REFUSED_SSN_FL,
              FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              REPLACE(REPLACE(CONVERT(CHAR(26), INFO_VERIFIED_TS, 121), 
           ' ', '-'), ':', '.') INFO_VERIFIED_TS,
              COMPANY_NO_ORIG                                    
               INTO :CE-SSN,                                            
                    :CE-CODE-STATE-ID,                                  
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-EMPLOYER,                                       
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-OTHER-ID,                                       
                    :CE-DATE-OF-BIRTH :WS-NULL-1,                        
                    :CE-ALLOW-CALL-FL,                                  
                    :CE-ALLOW-EMAIL-FL,                                 
                    :CE-ITIN-ID,                                        
                    :CE-ACCESS-LEVEL-CD,                                
                    :CE-REFUSED-SSN-FL,                                 
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :CE-INFO-VERIFIED-TS :WS-NULL-4,                     
                    :CU-COMPANY-NO-ORIG                                 
               FROM  CSS_CUST_STATS CE WITH(READUNCOMMITTED),                   
                     CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
              WHERE CE.CUSTOMER_NO = :CE-CUSTOMER-NO                    
                AND CE.CUSTOMER_NO = CU.CUSTOMER_NO                     
                AND CUSTOMER_TYPE = 'S'                                 
                AND CE.NAME_ID = DQ.NAME_ID                             
                AND NAME_TYPE = 'SN'                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT  SSN,                                               14210000
MFA-TR*              CODE_STATE_ID,                                     14240000
MFA-TR*              DRIVERS_LICENSE_NO,                                14250000
MFA-TR*              EMPLOYER,                                          14260000
MFA-TR*              OTHER_ID_TYPE,                                     14310000
MFA-TR*              OTHER_ID,                                          14320000
MFA-TR*              DATE_OF_BIRTH,                                     14340000
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ACCESS_LEVEL_CD,                                           
MFA-TR*              REFUSED_SSN_FL,                                            
MFA-TR*              FIRST_NAME,                                        13330800
MFA-TR*              MIDDLE_NAME,                                       13330900
MFA-TR*              LAST_NAME,                                         13331000
MFA-TR*              TITLE_PREFIX,                                      13332000
MFA-TR*              TITLE_SUFFIX_1,                                    13380000
MFA-TR*              INFO_VERIFIED_TS,                                          
MFA-TR*              COMPANY_NO_ORIG                                            
MFA-TR*        INTO :CE-SSN,                                            14380000
MFA-TR*             :CE-CODE-STATE-ID,                                  14410000
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                             14420000
MFA-TR*             :CE-EMPLOYER,                                       14430000
MFA-TR*             :CE-OTHER-ID-TYPE,                                  14480000
MFA-TR*             :CE-OTHER-ID,                                       14490000
MFA-TR*             :CE-DATE-OF-BIRTH:WS-NULL-1,                        14510000
MFA-TR*             :CE-ALLOW-CALL-FL,                                          
MFA-TR*             :CE-ALLOW-EMAIL-FL,                                         
MFA-TR*             :CE-ITIN-ID,                                                
MFA-TR*             :CE-ACCESS-LEVEL-CD,                                        
MFA-TR*             :CE-REFUSED-SSN-FL,                                         
MFA-TR*             :DQ-FIRST-NAME,                                     13440800
MFA-TR*             :DQ-MIDDLE-NAME,                                    13440900
MFA-TR*             :DQ-LAST-NAME,                                      13441000
MFA-TR*             :DQ-TITLE-PREFIX,                                   13441200
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                 13441300
MFA-TR*             :CE-INFO-VERIFIED-TS:WS-NULL-4,                     13441300
MFA-TR*             :CU-COMPANY-NO-ORIG                                         
MFA-TR*        FROM  CSS_CUST_STATS CE,                                 14550000
MFA-TR*              CSS_NAME DQ,                                               
MFA-TR*              CSS_CUSTOMER CU                                            
MFA-TR*       WHERE CE.CUSTOMER_NO = :CE-CUSTOMER-NO                    14560000
MFA-TR*         AND CE.CUSTOMER_NO = CU.CUSTOMER_NO                     14560000
MFA-TR*         AND CUSTOMER_TYPE = 'S'                                 14561000
MFA-TR*         AND CE.NAME_ID = DQ.NAME_ID                                     
MFA-TR*         AND NAME_TYPE = 'SN'                                            
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-SSN > SPACES AND                               
                      CE-OTHER-ID > SPACES AND                          
                      CE-OTHER-ID-TYPE = 'ITIN'                         
                          MOVE 'OTHER' TO CE-OTHER-ID-TYPE              
                   END-IF                                               
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO CE-INFO-VERIFIED-TS               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-STATS                         
                              DCLCSS-NAME                               
                              DCLCSS-CUSTOMER                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7100'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CSS_NAME'    TO TABLE-2                        
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CE-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-PHONE-NO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PHONE_NO,
              EXTENSION_NO,
              MOBILE_PHONE_FL,
              PERMISN_TO_MKT_FL,
              PERMISN_TO_MKT_DT                                  
               INTO :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO,                                   
                    :CB-MOBILE-PHONE-FL,                                
                    :CB-PERMISN-TO-MKT-FL,                              
                    :CB-PERMISN-TO-MKT-DT :WS-NULL-2                     
               FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                        
              WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                       
                AND PHONE_TYPE    = :WS-PHONE-TYPE                      
                AND CUSTOMER_TYPE = 'S'                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT PHONE_NO,                                          15225200
MFA-TR*              EXTENSION_NO,                                      15225300
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT                                          
MFA-TR*        INTO :CB-PHONE-NO,                                       15225400
MFA-TR*             :CB-EXTENSION-NO,                                   15225500
MFA-TR*             :CB-MOBILE-PHONE-FL,                                        
MFA-TR*             :CB-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :CB-PERMISN-TO-MKT-DT:WS-NULL-2                             
MFA-TR*        FROM CSS_CUST_PHONE                                      15225600
MFA-TR*       WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                       15225700
MFA-TR*         AND PHONE_TYPE    = :WS-PHONE-TYPE                      15225800
MFA-TR*         AND CUSTOMER_TYPE = 'S'                                 15225900
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-PHONE                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7400'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CE-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   MOVE 'PHONE_TYPE'  TO TABLE-ELEMENT-1                
                   MOVE WS-PHONE-TYPE TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-EMAIL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN EMAIL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-EMAIL-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE EMAIL-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04692_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04692_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04692_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04692_R2                            
             (                                                          
              RETURN_CODE,                                              
              EMAIL_ADDRESS,                                            
              EMAIL_TYPE_CD,                                            
              EMAIL_MKT_FL,                                             
              EMAIL_MKT_DT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-EMAIL-ADDRESS,                                        
               :S-EMAIL-TYPE-CD,                                        
               :S-EMAIL-MKT-FL,                                         
               :S-EMAIL-MKT-DT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04692_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       EMAIL_ADDRESS,                                                    
MFA-TR*       EMAIL_TYPE_CD,                                                    
MFA-TR*       EMAIL_MKT_FL,                                                     
MFA-TR*       EMAIL_MKT_DT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-EMAIL-ADDRESS,                                                
MFA-TR*        :S-EMAIL-TYPE-CD,                                                
MFA-TR*        :S-EMAIL-MKT-FL,                                                 
MFA-TR*        :S-EMAIL-MKT-DT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04692_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
