000100 IDENTIFICATION DIVISION.                                         
000200 PROGRAM-ID.  CSR04691.                                           
000300 DATE-WRITTEN.  12/04/13.                                         
000400 DATE-COMPILED.                                                   
000500                                                                  
000600******************************************************************00000600
000700*                                                                *00000700
000800*               SOUTH CAROLINA ELECTRIC & GAS                    *00000800
000900*----------------------------------------------------------------*00000900
001000*                STORED PROCEDURE:  CSR04691                     *00001000
001100******************************************************************00001100
001200*                 P R O G R A M  S U M M A R Y                   *00001200
001300*                                                                *00001300
001400*   CSR04691:                                                    *00001400
001500*                                                                *00001500
001600*  THIS PROGRAM UPDATES THE EXCL_DMD_RCHT_IND FIELD ON THE       *00001600
001700*  CSS_CNSMPTN_HIST TABLE.                                       *00001700
001800*                                                                *00001800
001900*  CLONED FROM CSR02363.                                         *00001900
002000*                                                                *00002000
002100*  DB2 TABLES USED.                                              *00002100
002200*     1.CSS_CNSMPTN_HIST                                         *00002200
002300*                                                                *00002300
002400*----------------------------------------------------------------*00002400
002500*    PARAMETERS                                                  *00002500
002600*                                                                *00002600
002700*        INPUT                                                   *00002700
002800*               ACCOUNT_NO          DECIMAL(13, 0)               *00002800
002900*               BILL_NO             INTEGER                      *00002900
003000*               CODE_UTIL_TYPE      CHAR(1)                      *00003000
003100*               IC_NO               SMALLINT                     *00003100
003200*               BILL_ITEM_TIMESTMP  CHAR(26)                     *00003200
003300*               EXCL_DMD_RCHT_IND   CHAR(1)                      *00003300
003400*               MTR_REF_NO          SMALLINT                     *00003400
003500*               REG_ID_NO           SMALLINT                     *00003500
003600*               CODE_TIME_PERIOD    SMALLINT                     *00003600
003700*               ITEM_SEQ_NO         SMALLINT                     *00003700
003800*                                                                *00003800
003900*                                                                *00003900
004000*        OUT                                                     *00004000
004100*                                                                *00004100
004200*              NONE                                              *00004200
004300*                                                                *00004300
004400*        INOUT                                                   *00004400
004500*                                                                *00004500
004600*              NONE                                              *00004600
004700*                                                                *00004700
004800*    RESULT SET                                                  *00004800
004900*                                                                *00004900
005000*                                                                *00005000
005100*     CSR04691_R1 - BUS RULE DETAILS                             *00005100
005200*                                                                *00005200
005300*             RETURN_CODE         INTEGER                        *00005300
005400*            ,APPL_RETURN_CODE    INTEGER                        *00005400
005500*            ,BUS_RULE_ID         CHAR(10)                       *00005500
005600*            ,BUS_RULE_RESULT_CD  CHAR(10)                       *00005600
005700*            ,BUS_RULE_XREF_ID    CHAR(26)                       *00005700
005800*                                                                *00005800
005900******************************************************************00005900
006000*                                                                *00006000
006100*                     PROGRAM MODIFICATION LOG                   *00006100
006200*                                                                *00006200
006300*    DATE    INITIALS   COMMENTS                                 *00006300
006400*  --------  --------   ---------------------------------------  *00006400
006500*  12/04/13   AD7F921   INITIAL VERSION.                         *00006500
006600******************************************************************00006600
006700*                                                                 00006700
006800 ENVIRONMENT DIVISION.                                            
006900 DATA DIVISION.                                                   
007000 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04691'.
MSQ017     COPY MFASQLM.
007100*                                                                 00007100
007200 01 WS-START                   PIC X(40)        VALUE             
007300      'WORKING STORAGE FOR CSR04691 STARTS HERE'.                 
007400*                                                                 00007400
007500******************************************************************00007500
007600*    DB2 INCLUDES                                                 00007600
007700***************************************************************** 00007700
007800     EXEC SQL                                                     00007800
007900        INCLUDE SQLCA                                             00007900
008000     END-EXEC.                                                    00008000
008100                                                                  
008200******************************************************************00008200
008300*    CX - CSS_CNSMPTN_HIST                                       *00008300
008400******************************************************************00008400
008500     EXEC SQL                                                     00008500
008600         INCLUDE TBCNSMP                                          00008600
008700     END-EXEC.                                                    00008700
008800                                                                  
008900******************************************************************00008900
009000*    COMMON COPYLIBS                                             *00009000
009100******************************************************************00009100
009200                                                                  
009300     EXEC SQL                                                     00009300
009400          INCLUDE CWSX0010                                        00009400
009500     END-EXEC.                                                    00009500
009600                                                                  
009700******************************************************************00009700
009800* -- SUPPORTS DB2 AND SQL ERROR CHECKING                          00009800
009900******************************************************************00009900
010000     COPY CWS00303.                                               00010000
010100                                                                  
010200******************************************************************00010200
010300*    WORK AREAS                                                  *00010300
010400******************************************************************00010400
010500*                                                                 00010500
010600 01  GTT-MISC-FIELDS.                                             
010700      05  WS-GTT-NAME                 PIC X(26)                   
010800                                                VALUE SPACES.     
010900 01  GTT-RETURN-FIELDS.                                           
011000******************************************************************00011000
011100*   GTT TABLE LAYOUT FOR BUS RULE ERROR MESSAGE                  *00011100
011200******************************************************************00011200
011300     10 S-RETURN-CODE             PIC S9(04) COMP  VALUE 0.       
011400     10 S-APPL-RETURN-CODE        PIC S9(04) COMP  VALUE 0.       
011500     10 S-RS1-BUS-RULE-ID         PIC X(10)  VALUE SPACES.        
011600     10 S-RS1-BUS-RULE-RESULT-CD  PIC X(10)  VALUE SPACES.        
011700     10 S-RS1-BUS-RULE-XREF-ID    PIC X(26)  VALUE SPACES.        
011800                                                                  
011810 01  WS-BUS-RULE-ID.                                              
011820     05  WS-REC-NOTFOUND-RULE-ID  PIC X(10)  VALUE 'CMN0000002'.  
011900                                                                  
012100 01  WS-MISC-FIELDS.                                              
012200     05  PROGRAM-NAME             PIC X(08)  VALUE 'CSR04691'.    
012300     05  WS-SQLSTATE              PIC X(05)  VALUE SPACES.        
012400     05  WS-FAILED                PIC X(01)  VALUE 'F'.           
012500*                                                                 00012500
012600 01  CSRERLOG-P.                                                  
012700      10  S-SP-NAME               PIC X(18) VALUE SPACES.         
012800      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
012900      10  S-SQLSTATE              PIC X(5)  VALUE ' '.            
013000      10  S-TABLE-NAME            PIC X(18) VALUE SPACES.         
013100      10  S-HOST-VARIABLES.                                       
013200          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
013300          49  S-HOST-VARIABLES-V  PIC X(255).                     
013400      10  S-SQL-STATEMENT.                                        
013500          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
013600          49  S-SQL-STATEMENT-V   PIC X(255).                     
013700      10  S-SQL-DESCRIPTION.                                      
013800          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
013900          49  S-SQL-DESCRIPTION-V PIC X(255).                     
014000      10  WS-ABEND-SQLERRMC.                                      
014100          49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.           
014200          49  WS-ABEND-SQLERRMC-V PIC X(255).                     
HPCCDM*    EJECT                                                        00014300
014400                                                                  
014500******************************************************************00014500
014600*    LINKAGE SECTION                                             *00014600
014700******************************************************************00014700
014800 LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.           
015000 01  PARM-BILL-NO             PIC S9(9) USAGE COMP.               
015100 01  PARM-CODE-UTIL-TYPE      PIC X(1).                           
015200 01  PARM-IC-NO               PIC S9(4) USAGE COMP.               
015300 01  PARM-BILL-ITEM-TIMESTMP  PIC X(26).                          
015400 01  PARM-EXCL-DMD-RCHT-IND   PIC X(1).                           
015500 01  PARM-MTR-REF-NO          PIC S9(4) USAGE COMP.               
015600 01  PARM-REG-ID-NO           PIC S9(4) USAGE COMP.               
015700 01  PARM-CODE-TIME-PERIOD    PIC S9(4) USAGE COMP.               
015800 01  PARM-ITEM-SEQ-NO         PIC S9(4) USAGE COMP.               
015900                                                                  
016000*                                                                 00016000
HPCCDM*    EJECT                                                        00016100
016200*                                                                 00016200
016300 PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
016400                         , PARM-BILL-NO                           
016500                         , PARM-CODE-UTIL-TYPE                    
016600                         , PARM-IC-NO                             
016700                         , PARM-BILL-ITEM-TIMESTMP                
016800                         , PARM-EXCL-DMD-RCHT-IND                 
016900                         , PARM-MTR-REF-NO                        
017000                         , PARM-REG-ID-NO                         
017100                         , PARM-CODE-TIME-PERIOD                  
017200                         , PARM-ITEM-SEQ-NO.                      
017300*                                                                 00017300
017400******************************************************************00017400
017500* 0000-MAINLINE                                                  *00017500
017600*     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00017600
017700******************************************************************00017700
017800                                                                  
017900 0000-MAINLINE.                                                   
018000                                                                  
018100     PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
018200     PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
018300     PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
018400     PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
018500                                                                  
018600 0000-EXIT.                                                       
018700     EXIT.                                                        
HPCCDM*    EJECT                                                        00018800
018900******************************************************************00018900
019000*                                                                *00019000
019100* 0100-INITIALIZE                                                *00019100
019200*                                                                *00019200
019300******************************************************************00019300
019400                                                                  
019500 0100-INITIALIZE.                                                 
019600                                                                  
019700     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
019800     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
019900     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
020000                                                                  
020100     PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
020200                                                                  
020300 0100-EXIT.                                                       
020400     EXIT.                                                        
HPCCDM*    EJECT                                                        00020500
020600****************************************************************  00020600
020700*                                                                 00020700
020800*  0100A-DECLARE-GTT-R1                                           00020800
020900****************************************************************  00020900
021000 0100A-DECLARE-GTT-R1.                                            
021100                                                                  
021200     MOVE 'SESSION. CSR04691_R1'      TO WS-GTT-NAME.             
021300                                                                  
021400     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04691_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04691_R1
              (                                                       
021700              RETURN_CODE             INT                     
021800             ,APPL_RETURN_CODE        INT                     
021900             ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
022000             ,BUS_RULE_RESULT_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
022100             ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
022200          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

022400                                                                  
022500     MOVE SQLSTATE                    TO WS-SQLSTATE.             
022600     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
022700                                                                  
022800     IF WS-SQLSTATE = '42710'                                     
022900        PERFORM 8000A-DEL-GTT-ROWS         THRU 8000A-EXIT        
023000     ELSE                                                         
023100        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
023200           CONTINUE                                               
023300        ELSE                                                      
023400           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
023500           MOVE '0100A'               TO ACTIVE-PARAGRAPH         
023600           MOVE SQLCODE               TO ABEND-SQLCODE            
023700           MOVE SQLSTATE              TO ABEND-SQLSTATE           
023800           MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
023900           MOVE SPACES                TO ABEND-SQL-PREDICATES     
024000                                         ABEND-TABLES             
024100           MOVE WS-GTT-NAME           TO TABLE-1                  
024200           MOVE SPACES                TO TABLE-ELEMENT-1          
024300           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
024400           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
024500        END-IF                                                    
024600     END-IF.                                                      
024700                                                                  
024800     EXEC SQL                                                     
024900         DECLARE C1 CURSOR                             
025000                           WITH ROWSET POSITIONING FOR            
025100          SELECT RETURN_CODE                                      
025200                ,APPL_RETURN_CODE                                 
025300                ,LTRIM(RTRIM(BUS_RULE_ID))          AS BUS_RULE_ID       
025400                ,LTRIM(RTRIM(BUS_RULE_RESULT_CD))   AS 
           BUS_RULE_RESULT_CD
025500                ,LTRIM(RTRIM(BUS_RULE_XREF_ID))     AS 
           BUS_RULE_XREF_ID  
025600            FROM #CSR04691_R1                             
025700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00024800
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00024900
MFA-TR*                          WITH ROWSET POSITIONING FOR            00025000
MFA-TR*         SELECT RETURN_CODE                                      00025100
MFA-TR*               ,APPL_RETURN_CODE                                 00025200
MFA-TR*               ,STRIP(BUS_RULE_ID)          AS BUS_RULE_ID       00025300
MFA-TR*               ,STRIP(BUS_RULE_RESULT_CD)   AS BUS_RULE_RESULT_CD00025400
MFA-TR*               ,STRIP(BUS_RULE_XREF_ID)     AS BUS_RULE_XREF_ID  00025500
MFA-TR*           FROM SESSION. CSR04691_R1                             00025600
MFA-TR*    END-EXEC.                                                    00025700
025800                                                                  
025900 0100A-EXIT.                                                      
026000      EXIT.                                                       
026100                                                                  
026200******************************************************************00026200
026300*1000-PROCESS-INPUT                                              *00026300
026400*                                                                *00026400
026500*    1. RECEIVE EACH PARAMETER FROM THE LINKAGE SECTION          *00026500
026600*                                                                *00026600
026700******************************************************************00026700
026800                                                                  
026900 1000-PROCESS-INPUT.                                              
027000*                                                                 00027000
027100     MOVE PARM-ACCOUNT-NO             TO CX-ACCOUNT-NO.           
027200     MOVE PARM-BILL-NO                TO CX-BILL-NO.              
027300     MOVE PARM-CODE-UTIL-TYPE         TO CX-CODE-UTIL-TYPE.       
027400     MOVE PARM-IC-NO                  TO CX-IC-NO.                
027500     MOVE PARM-BILL-ITEM-TIMESTMP     TO CX-BILL-ITEM-TIMESTMP.   
027600     MOVE PARM-EXCL-DMD-RCHT-IND      TO CX-EXCL-DMD-RCHT-IND.    
027700     MOVE PARM-MTR-REF-NO             TO CX-MTR-REF-NO.           
027800     MOVE PARM-REG-ID-NO              TO CX-REG-ID-NO.            
027900     MOVE PARM-CODE-TIME-PERIOD       TO CX-CODE-TIME-PERIOD.     
028000     MOVE PARM-ITEM-SEQ-NO            TO CX-ITEM-SEQ-NO.          
028100*                                                                 00028100
028200 1000-EXIT.                                                       
028300     EXIT.                                                        
HPCCDM*    EJECT                                                        00028400
028500******************************************************************00028500
028600* 2000-PROCESS-OUTPUT                                            *00028600
028700*                                                                *00028700
028800*     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *00028800
028900*     BUILD THE RESULT SET.                                      *00028900
029000*                                                                *00029000
029100******************************************************************00029100
029200                                                                  
029300 2000-PROCESS-OUTPUT.                                             
029400*                                                                *00029400
029500     PERFORM 7100-UPDATE-CNSMPTN-HIST           THRU 7100-EXIT.   
029600*                                                                *00029600
032900*                                                                 00032900
033000 2000-EXIT.                                                       
033100     EXIT.                                                        
HPCCDM*    EJECT                                                        00033200
033300******************************************************************00033300
033400* 7100-UPDATE-CNSMPTN-HIST                                       *00033400
033500******************************************************************00033500
033600*                                                                *00033600
033700 7100-UPDATE-CNSMPTN-HIST.                                        
033800*                                                                *00033800
033900     EXEC SQL                                                     
034000        UPDATE CSS_CNSMPTN_HIST                                   
034100           SET EXCL_DMD_RCHT_IND  = :CX-EXCL-DMD-RCHT-IND         
034200         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                
034300           AND BILL_NO            = :CX-BILL-NO                   
034400           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE            
034500           AND IC_NO              = :CX-IC-NO                     
034600           AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
034700           AND MTR_REF_NO         = :CX-MTR-REF-NO                
034800           AND REG_ID_NO          = :CX-REG-ID-NO                 
034900           AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD          
035000           AND ITEM_SEQ_NO        = :CX-ITEM-SEQ-NO               
035100     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00033900
MFA-TR*       UPDATE CSS_CNSMPTN_HIST                                   00034000
MFA-TR*          SET EXCL_DMD_RCHT_IND  = :CX-EXCL-DMD-RCHT-IND         00034100
MFA-TR*        WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                00034200
MFA-TR*          AND BILL_NO            = :CX-BILL-NO                   00034300
MFA-TR*          AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE            00034400
MFA-TR*          AND IC_NO              = :CX-IC-NO                     00034500
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP        00034600
MFA-TR*          AND MTR_REF_NO         = :CX-MTR-REF-NO                00034700
MFA-TR*          AND REG_ID_NO          = :CX-REG-ID-NO                 00034800
MFA-TR*          AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD          00034900
MFA-TR*          AND ITEM_SEQ_NO        = :CX-ITEM-SEQ-NO               00035000
MFA-TR*    END-EXEC                                                     00035100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

035200                                                                  
035300     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
035310*                                                                 00035310
035400     EVALUATE WS-ACTIVE-RETURN-CODE                               
035410*                                                                 00035410
035420        WHEN SUCCESSFUL-CALL                                      
035430             MOVE WS-ACTIVE-RETURN-CODE                           
035440                                      TO S-RETURN-CODE            
035450                                         S-APPL-RETURN-CODE       
035460             PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT    
035470*                                                                 00035470
035480        WHEN NOT-FOUND                                            
035490             MOVE WS-REC-NOTFOUND-RULE-ID                         
035491                                      TO S-RS1-BUS-RULE-ID        
035492             S-RS1-BUS-RULE-ID                                    
035493             MOVE WS-FAILED           TO S-RS1-BUS-RULE-RESULT-CD 
035494             PERFORM 7550-GET-RULE-XREF-ID      THRU 7550-EXIT    
035495             PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT    
035496*                                                                 00035496
035497        WHEN OTHER                                                
035498             MOVE SPACES              TO ABEND-TABLES             
035499             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
035500             MOVE '7100'              TO ACTIVE-PARAGRAPH         
035501             MOVE 'UPDATE'            TO ABEND-FUNCTION           
035502             MOVE SPACES              TO ABEND-SQL-PREDICATES     
035503                                         ABEND-TABLES             
035504             MOVE 'CSS_CNSMPTN_HIST'  TO TABLE-1                  
035505             MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
035506             MOVE 'BILL_NO'           TO TABLE-ELEMENT-2          
035507             MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-3          
035508             MOVE 'IC_NO'             TO TABLE-ELEMENT-4          
035509             MOVE CX-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
035510             MOVE CX-BILL-NO          TO HOSTVAR-ELEMENT-2        
035511             MOVE CX-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-3        
035512             MOVE CX-IC-NO            TO HOSTVAR-ELEMENT-4        
035513             PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT         
035514     END-EVALUATE.                                                
035520*                                                                 00035520
035600 7100-EXIT.                                                       
035700     EXIT.                                                        
HPCCDM*    EJECT                                                        00035800
035900************************************************************      00035900
036000*                                                                 00036000
036100* 7550-GET-RULE-XREF-ID                                           00036100
036200*                                                                 00036200
036300************************************************************      00036300
036400 7550-GET-RULE-XREF-ID.                                           
036500                                                                  
036600     EXEC SQL                                                     
036700        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
036800          INTO :S-RS1-BUS-RULE-XREF-ID                            
036900          FROM CSS_BUS_RULE   R WITH(READUNCOMMITTED)                     
037000              ,CSS_BUS_RULE_XREF T WITH(READUNCOMMITTED)                  
037100         WHERE R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                 
037200           AND R.BUS_RULE_ID = T.BUS_RULE_ID                      
037300                                       
037400                                                      
037500     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00036600
MFA-TR*       SELECT BUS_RULE_XREF_ID                                   00036700
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                            00036800
MFA-TR*         FROM CSS_BUS_RULE   R                                   00036900
MFA-TR*             ,CSS_BUS_RULE_XREF T                                00037000
MFA-TR*        WHERE R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                 00037100
MFA-TR*          AND R.BUS_RULE_ID = T.BUS_RULE_ID                      00037200
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             00037300
MFA-TR*      QUERYNO 7550                                               00037400
MFA-TR*    END-EXEC                                                     00037500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

037600                                                                  
037700     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
037800                                                                  
037900     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
038000        CONTINUE                                                  
038100     ELSE                                                         
038200         MOVE SPACES                  TO ABEND-TABLES             
038300         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
038400         MOVE '7550'                  TO ACTIVE-PARAGRAPH         
038500         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
038600         MOVE SQLCODE                 TO ABEND-SQLCODE            
038700         MOVE SQLSTATE                TO ABEND-SQLSTATE           
038800         MOVE 'SELECT'                TO ABEND-FUNCTION           
038900         MOVE 'CSS_BUS_RULE'          TO TABLE-1                  
039000         MOVE 'BUS_RULE_ID'           TO TABLE-ELEMENT-1          
039100         MOVE S-RS1-BUS-RULE-ID       TO HOSTVAR-ELEMENT-1        
039200         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
039300     END-IF.                                                      
039400                                                                  
039500 7550-EXIT.                                                       
039600     EXIT.                                                        
039700                                                                  
039800***************************************************************** 00039800
039900*                                                               * 00039900
040000* 8000A-DEL-GTT-ROWS.                                           * 00040000
040100***************************************************************** 00040100
040200 8000A-DEL-GTT-ROWS.                                              
040300                                                                  
040400     EXEC SQL                                                     
040500         DELETE FROM #CSR04691_R1                          
040600     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00040400
MFA-TR*        DELETE FROM SESSION.CSR04691_R1                          00040500
MFA-TR*    END-EXEC.                                                    00040600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

040700                                                                  
040800     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
040900                                         S-RETURN-CODE.           
041000                                                                  
041100     EVALUATE WS-ACTIVE-RETURN-CODE                               
041200*                                                                 00041200
041300         WHEN SUCCESSFUL-CALL                                     
041400              CONTINUE                                            
041500*                                                                 00041500
041600         WHEN NOT-FOUND                                           
041700              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
041800                                         S-RETURN-CODE            
041900         WHEN OTHER                                               
042000              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
042100              MOVE SQLCODE            TO ABEND-SQLCODE            
042200              MOVE SQLSTATE           TO ABEND-SQLSTATE           
042300              MOVE '8000A'            TO ACTIVE-PARAGRAPH         
042400              MOVE 'DELETE'           TO ABEND-FUNCTION           
042500              MOVE SPACES             TO ABEND-SQL-PREDICATES     
042600                                         ABEND-TABLES             
042700              MOVE 'CSR04691_R1'      TO TABLE-1                  
042800              MOVE SPACES             TO TABLE-ELEMENT-1          
042900              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
043000              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
043100     END-EVALUATE.                                                
043200                                                                  
043300 8000A-EXIT.                                                      
043400      EXIT.                                                       
043500                                                                  
043600******************************************************************00043600
043700*                                                                *00043700
043800* 8010-INSERT-GTT-R1.                                            *00043800
043900******************************************************************00043900
044000 8010-INSERT-GTT-R1.                                              
044100                                                                  
044200     EXEC SQL                                                     
044300        INSERT INTO #CSR04691_R1                          
044400           (                                                      
044500             RETURN_CODE                                          
044600            ,APPL_RETURN_CODE                                     
044700            ,BUS_RULE_ID                                          
044800            ,BUS_RULE_RESULT_CD                                   
044900            ,BUS_RULE_XREF_ID                                     
045000           )                                                      
045100        VALUES                                                    
045200           (                                                      
045300             :S-RETURN-CODE                                       
045400            ,:S-APPL-RETURN-CODE                                  
045500            ,:S-RS1-BUS-RULE-ID                                   
045600            ,:S-RS1-BUS-RULE-RESULT-CD                            
045700            ,:S-RS1-BUS-RULE-XREF-ID                              
045800           )                                                      
045900     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00044200
MFA-TR*       INSERT INTO SESSION. CSR04691_R1                          00044300
MFA-TR*          (                                                      00044400
MFA-TR*            RETURN_CODE                                          00044500
MFA-TR*           ,APPL_RETURN_CODE                                     00044600
MFA-TR*           ,BUS_RULE_ID                                          00044700
MFA-TR*           ,BUS_RULE_RESULT_CD                                   00044800
MFA-TR*           ,BUS_RULE_XREF_ID                                     00044900
MFA-TR*          )                                                      00045000
MFA-TR*       VALUES                                                    00045100
MFA-TR*          (                                                      00045200
MFA-TR*            :S-RETURN-CODE                                       00045300
MFA-TR*           ,:S-APPL-RETURN-CODE                                  00045400
MFA-TR*           ,:S-RS1-BUS-RULE-ID                                   00045500
MFA-TR*           ,:S-RS1-BUS-RULE-RESULT-CD                            00045600
MFA-TR*           ,:S-RS1-BUS-RULE-XREF-ID                              00045700
MFA-TR*          )                                                      00045800
MFA-TR*    END-EXEC.                                                    00045900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

046000                                                                  
046100     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
046200                                         S-RETURN-CODE.           
046300                                                                  
046400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
046500        CONTINUE                                                  
046600     ELSE                                                         
046700        MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
046800        MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
046900        MOVE SQLCODE                  TO  ABEND-SQLCODE           
047000        MOVE 'INSERT'                 TO  ABEND-FUNCTION          
047100        MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
047200                                          ABEND-TABLES            
047300        MOVE ' CSR04691_R1'           TO  TABLE-1                 
047400        MOVE SPACES                   TO  TABLE-ELEMENT-1         
047500        MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
047600        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
047700     END-IF.                                                      
047800                                                                  
047900  8010-EXIT.                                                      
048000      EXIT.                                                       
048100                                                                  
048200************************************************************      00048200
048300*                                                                 00048300
048400* 8900-SEND-DONE.                                                 00048400
048500************************************************************      00048500
048600 8900-SEND-DONE.                                                  
048700                                                                  
048800     MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
048900     MOVE '8900'                      TO ACTIVE-PARAGRAPH         
049000     MOVE 'OPEN'                      TO ABEND-FUNCTION           
049100                                                                  
049200     EXEC SQL                                                     
049300         OPEN C1                                                  
049400     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
049500                                                                  
049600     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
049700                                         S-RETURN-CODE.           
049800                                                                  
049900     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
050000        CONTINUE                                                  
050100     ELSE                                                         
050200        MOVE SQLCODE                  TO ABEND-SQLCODE            
050300        MOVE SQLSTATE                 TO ABEND-SQLSTATE           
050400        MOVE ' CSR04691_R1'           TO TABLE-1                  
050500        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
050600     END-IF.                                                      
050700                                                                  
050800 8900-EXIT.                                                       
050900     EXIT.                                                        
051000                                                                  
051100************************************************************      00051100
051200*                                                                 00051200
051300* 9000-SEND-ERROR-RESULT                                          00051300
051400************************************************************      00051400
051500 9000-SEND-ERROR-RESULT.                                          
051600                                                                  
051700     INITIALIZE GTT-RETURN-FIELDS.                                
051800     MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
051900                                         S-RETURN-CODE            
052000                                                                  
052100     MOVE ZERO                        TO S-APPL-RETURN-CODE       
052200                                                                  
052300                                                                  
052400     MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
052500                                                                  
052600     EXEC SQL                                                     
052700         ROLLBACK                                                 
052800     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

052900                                                                  
053000     IF SQLCODE = 0                                               
053100        CONTINUE                                                  
053200     ELSE                                                         
053300        MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
053400     END-IF.                                                      
053500                                                                  
053600     PERFORM 0100A-DECLARE-GTT-R1          THRU 0100A-EXIT.       
053700                                                                  
053800     PERFORM 8010-INSERT-GTT-R1            THRU 8010-EXIT.        
053900                                                                  
054000 9000-EXIT.                                                       
054100     EXIT.                                                        
054200                                                                  
054300************************************************************      00054300
054400* 9700-ABEND-PROCESSING.                                          00054400
054500************************************************************      00054500
054600 9700-PROCESS-ABEND.                                              
054700                                                                  
054800     PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT.        
054900     PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT.        
055000                                                                  
055100 9700-EXIT.                                                       
055200     EXIT.                                                        
055300                                                                  
055400******************************************************************00055400
055500* 9900- JOURNALING / ERROR HANDLING INCLUDE                      *00055500
055600******************************************************************00055600
055700     EXEC SQL                                                     00055700
055800        INCLUDE CPDSP300                                          00055800
055900     END-EXEC.                                                    00055900
HPCCDM*    EJECT                                                        00056000
056100************************************************************      00056100
056200* 9999-END-PROGRAM.                                               00056200
056300************************************************************      00056300
056400                                                                  
056500 9999-END-PROGRAM.                                                
056600                                                                  
056700      PERFORM 8900-SEND-DONE               THRU 8900-EXIT         
056800                                                                  
056900     
MSQ016        GOBACK.                                                    
057000                                                                  
057100 9999-EXIT.                                                       
057200     EXIT.                                                        
